'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjParse.inc                                                                                    |
'--------------------------------------------------------------------------------------------------+
                                                                  '

CLASS cObjParse                                                   '
   '-----------------------------------------------------------------------------------------------+
   '- Data for the Parse Model processing                                                          |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE Tbl                 AS IPOWERCOLLECTION               ' Parse working table
   INSTANCE Ops()               AS STRING                         ' Cmd Line Operands (0)=Command Name
   INSTANCE OpsNum              AS LONG                           ' Number of Cmd operands
   INSTANCE MaxNum,   GotNum    AS LONG                           ' Max/Got Numeric operands
   INSTANCE MaxLit,   GotLit    AS LONG                           ' Max/Got Literal operands
   INSTANCE MaxDotd,  GotDotd   AS LONG                           ' Max/Got Dotted (.) operands
   INSTANCE MaxLptr,  GotLPtr   AS LONG                           ' Max/Got LPtr   (!) operands
   INSTANCE MaxTag,   GotTag    AS LONG                           ' Max/Got Tag operands
   INSTANCE MaxAdj,   GotAdj    AS LONG                           ' Max/Got Adjustment (+-) operands
   INSTANCE MaxKwd              AS LONG                           ' Max Kwd type operands
   INSTANCE Flg                 AS ParseFlags                     ' Option flags for Parse
   INSTANCE ErrMsg,   EType     AS STRING                         ' Error fields
   INSTANCE ItemName, ItemValue AS WSTRING                        ' Key/Value in WSTRING format
   INSTANCE VarValue            AS VARIANT                        ' Retrieval Variant
   '-----------------------------------------------------------------------------------------------+
   '- Data for the PTBL Find/Change data                                                           |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE ColFrom             AS LONG                           ' From column
   INSTANCE ColTo               AS LONG                           ' To   column
   INSTANCE FindRngEnd          AS LONG                           ' End Range (.ZLAST)
   INSTANCE FindRngFlag         AS LONG                           ' K/+/- flag from range
   INSTANCE FindRngLCtl         AS STRING                         ' Line control mode (U/T)
   INSTANCE FindRngSet          AS LONG                           ' Range other than .ZFIRST to .ZLAST is set
   INSTANCE FindRngStart        AS LONG                           ' Start range (.ZFIRST)
   INSTANCE FindRngTag          AS STRING                         ' Range is a Tag range
   INSTANCE FindRngTNF          AS LONG                           ' Tag1 is a NF tag
   INSTANCE FlgAll              AS BYTE                           ' Operand ALL       present
   INSTANCE FlgChars            AS BYTE                           ' Operand CHARS     present
   INSTANCE FlgCS               AS BYTE                           ' Operand CS        present
   INSTANCE FlgComment          AS BYTE                           ' Operand Comment   present
   INSTANCE FlgDS               AS BYTE                           ' Operand DS        present
   INSTANCE FlgDX               AS BYTE                           ' Operand DX        present
   INSTANCE FlgFirst            AS BYTE                           ' Operand FIRST     present
   INSTANCE FlgFCol             AS BYTE                           ' Operand FCOL      present
   INSTANCE FlgHiClr            AS BYTE                           ' Operand HICLR     present
   INSTANCE FlgHiOff            AS BYTE                           ' Operand HIOFF     present
   INSTANCE FlgHiOn             AS BYTE                           ' Operand HION      present
   INSTANCE FlgLast             AS BYTE                           ' Operand LAST      present
   INSTANCE FlgLeft             AS BYTE                           ' Operand LEFT      present
   INSTANCE FlgLit1             AS BYTE                           ' Operand LIT1      present
   INSTANCE FlgL1Picture        AS BYTE                           ' Operand L1PICTURE present
   INSTANCE FlgL1Hex            AS BYTE                           ' Operand L1HEX     present
   INSTANCE FlgL1RegEx          AS BYTE                           ' Operand L1REGEX   present
   INSTANCE FlgL1DLM            AS BYTE                           ' Operand L1DLM     present
   INSTANCE FlgL1CaseComp       AS BYTE                           ' Operand L1CASECOMP present
   INSTANCE FlgL1CaseInComp     AS BYTE                           ' Operand L1CASEINCOMP present
   INSTANCE FlgLit2             AS BYTE                           ' Operand LIT2      present
   INSTANCE FlgL2Picture        AS BYTE                           ' Operand L2PICTURE present
   INSTANCE FlgL2Hex            AS BYTE                           ' Operand L2HEX     present
   INSTANCE FlgL2Format         AS BYTE                           ' Operand L2FORMAT  present
   INSTANCE FlgL2CaseComp       AS BYTE                           ' Operand L2CASECOMP present
   INSTANCE FlgL2CaseInComp     AS BYTE                           ' Operand L2CASEINCOMP present
   INSTANCE FlgL2Trunc          AS BYTE                           ' Operand L2Trunc   present
   INSTANCE FlgLM               AS BYTE                           ' Operand LM        present
   INSTANCE FlgMax              AS BYTE                           ' Operand MAX       present
   INSTANCE FlgMSolid           AS BYTE                           ' Operand MSOLID    present
   INSTANCE FlgMStd             AS BYTE                           ' Operand MSTD      present
   INSTANCE FlgMX               AS BYTE                           ' Operand MX        present
   INSTANCE FlgNext             AS BYTE                           ' Operand NEXT      present
   INSTANCE FlgNF               AS BYTE                           ' Operand NF        present
   INSTANCE FlgNX               AS BYTE                           ' Operand NX        present
   INSTANCE FlgNU               AS BYTE                           ' Operand NU        present
   INSTANCE FlgOn               AS BYTE                           ' Operand ON        present
   INSTANCE FlgOff              AS BYTE                           ' Operand OFF       present
   INSTANCE FlgPrefix           AS BYTE                           ' Operand PREFIX    present
   INSTANCE FlgPrev             AS BYTE                           ' Operand PREV      present
   INSTANCE FlgPStd             AS BYTE                           ' Operand PSTD      present
   INSTANCE FlgQuoted           AS BYTE                           ' Operand QUOTED    present
   INSTANCE FlgRight            AS BYTE                           ' Operand RIGHT     present
   INSTANCE FlgRngPass          AS BYTE                           ' Operand RNGPASS   (Internal)
   INSTANCE FlgRM               AS BYTE                           ' Operand RM        present
   INSTANCE FlgSet              AS BYTE                           ' Operand SET       present
   INSTANCE FlgSolid            AS BYTE                           ' Operand SOLID     present
   INSTANCE FlgStd              AS BYTE                           ' Operand STD       present
   INSTANCE FlgSuffix           AS BYTE                           ' Operand SUFFIX    present
   INSTANCE FlgTCol             AS BYTE                           ' Operand TCOL      present
   INSTANCE FlgText             AS BYTE                           ' Operand T         present
   INSTANCE FlgToggle           AS BYTE                           ' Operand TOGGLE    present
   INSTANCE FlgTop              AS BYTE                           ' Operand TOP       present
   INSTANCE FlgU                AS BYTE                           ' Operand U         present
   INSTANCE FlgWord             AS BYTE                           ' Operand WORD      present
   INSTANCE FlgX                AS BYTE                           ' Operand X         present
   INSTANCE FoundFailed         AS LONG                           ' Current Last search resulted in Not Found 1 = Top, 2 = Bottom
   INSTANCE FoundCol            AS LONG                           ' Current Found column
   INSTANCE FoundLen            AS LONG                           ' Current Found length
   INSTANCE FoundLine           AS LONG                           ' Current Found line
   INSTANCE HiLiteOff           AS LONG                           ' HiLite -Off color
   INSTANCE HiLiteOn            AS LONG                           ' HiLite +On  color
   INSTANCE HiLiteSrch          AS LONG                           ' HiLite search color
   INSTANCE L1Raw               AS STRING                         ' Literal 1 raw
   INSTANCE L1RData             AS STRING                         ' Literal 1 massaged data
   INSTANCE L1Len               AS LONG                           ' Current real length of find string
   INSTANCE L2Raw               AS STRING                         ' Literal 2 raw
   INSTANCE L2RData             AS STRING                         ' Literal 2 massaged data
   INSTANCE L2Len               AS LONG                           ' Current real length of L2
   INSTANCE SplitPoint1         AS LONG                           ' Current SPLIT point (where the | is) Lit1
   INSTANCE SplitPoint2         AS LONG                           ' Current SPLIT point (where the | is) Lit2
   '-----------------------------------------------------------------------------------------------+
   '- Data for the * style F/C operands                                                            |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE RL1Raw              AS STRING                         '
   INSTANCE RL1RData            AS STRING                         '
   INSTANCE RL1Len              AS LONG                           '
   INSTANCE RSplitPoint1        AS LONG                           '
   INSTANCE RSplitPoint2        AS LONG                           '
   INSTANCE RFlgLit1            AS BYTE                           '
   INSTANCE RFlgL1Picture       AS BYTE                           '
   INSTANCE RFlgL1Hex           AS BYTE                           '
   INSTANCE RFlgL1RegEx         AS BYTE                           '
   INSTANCE RFlgL1CaseComp      AS BYTE                           '
   INSTANCE RFlgL1CaseInComp    AS BYTE                           '

   INSTANCE RL2Raw              AS STRING                         '
   INSTANCE RL2RData            AS STRING                         '
   INSTANCE RL2Len              AS LONG                           '
   INSTANCE RFlgLit2            AS BYTE                           '
   INSTANCE RFlgL2Hex           AS BYTE                           '
   INSTANCE RFlgL2CaseComp      AS BYTE                           '
   INSTANCE RFlgL2CaseInComp    AS BYTE                           '

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
      LET Tbl = CLASS "PowerCollection"                           ' Initialize the Model table
      DIM Ops(0 TO 100) AS INSTANCE STRING                        ' CmdLine operands
   END METHOD                                                     '

   INTERFACE iObjParse: INHERIT IUNKNOWN                          '
      gsProp(OpsNum,   LONG)                                      ' # of command operands
      gsProp(GotNum,   LONG)                                      ' # of Numeric operands
      gsProp(MaxNum,   LONG)                                      '
      gsProp(GotLit,   LONG)                                      ' # of Literal operands
      gsProp(MaxLit,   LONG)                                      '
      gsProp(GotLPtr,  LONG)                                      ' # of LPtr operands
      gsProp(MaxLPtr,  LONG)                                      '
      gsProp(GotDotd,  LONG)                                      ' # of Dotted operands
      gsProp(MaxDotd,  LONG)                                      '
      gsProp(GotTag,   LONG)                                      ' # of Tag operands
      gsProp(MaxTag,   LONG)                                      '
      gsProp(GotAdj,   LONG)                                      ' # of Adj operands
      gsProp(MaxAdj,   LONG)                                      '
      gsProp(MaxKwd,   LONG)                                      ' # of Kwd possibilities
      gsProp(ErrMsg,   STRING)                                    ' Error Meaasge
      gsProp(EType,    STRING)                                    ' Error type

      gsProp(ColFrom, LONG)                                       ' From column
      gsProp(ColTo, LONG)                                         ' To   column
      gsProp(FindRngEnd, LONG)                                    ' End Range (.ZLAST)
      gsProp(FindRngFlag, LONG)                                   ' K/+/- flag from range
      gsProp(FindRngLCtl, STRING)                                 ' Line control mode (U/T)
      gsProp(FindRngSet, LONG)                                    ' Range other than .ZFIRST to .ZLAST is set
      gsProp(FindRngStart, LONG)                                  ' Start range (.ZFIRST)
      gsProp(FindRngTag, STRING)                                  ' Range is a Tag range
      gsProp(FindRngTNF, LONG)                                    ' Tag1 is a NF
      gsProp(Flg, ParseFlags)                                     ' Option flags for Parse
      gsProp(FlgAll, BYTE)                                        ' ALL       present
      gsProp(FlgChars, BYTE)                                      ' CHARS     present
      gsProp(FlgCS, BYTE)                                         ' CS        present
      gsProp(FlgComment, BYTE)                                    ' COMMENT   present
      gsProp(FlgDS, BYTE)                                         ' DS        present
      gsProp(FlgDX, BYTE)                                         ' DX        present
      gsProp(FlgQuoted, BYTE)                                     ' QUOTED    present
      gsProp(FlgFCol, BYTE)                                       ' FCOL      present
      gsProp(FlgFirst, BYTE)                                      ' FIRST     present
      gsProp(FlgHiClr, BYTE)                                      ' HICLR     present
      gsProp(FlgHiOff, BYTE)                                      ' HIOFF     present
      gsProp(FlgHiOn, BYTE)                                       ' HION      present
      gsProp(FlgLast, BYTE)                                       ' LAST      present
      gsProp(FlgLeft, BYTE)                                       ' LEFT      present
      gsProp(FlgLit1, BYTE)                                       ' LIT1      present
      gsProp(FlgL1Picture, BYTE)                                  ' L1PICTURE present
      gsProp(FlgL1Hex, BYTE)                                      ' L1HEX     present
      gsProp(FlgL1RegEx, BYTE)                                    ' L1REGEX   present
      gsProp(FlgL1DLM, BYTE)                                      ' L1DLM     present
      gsProp(FlgL1CaseComp, BYTE)                                 ' L1CASECOMP present
      gsProp(FlgL1CaseInComp, BYTE)                               ' L1CASEINCOMP present
      gsProp(FlgLit2, BYTE)                                       ' LIT2      present
      gsProp(FlgL2Picture, BYTE)                                  ' L2PICTURE present
      gsProp(FlgL2Hex, BYTE)                                      ' L2HEX     present
      gsProp(FlgL2Format, BYTE)                                   ' L2FORMAT  present
      gsProp(FlgL2CaseComp, BYTE)                                 ' L2CASECOMP present
      gsProp(FlgL2CaseInComp, BYTE)                               ' L2CASEINCOMP present
      gsProp(FlgL2Trunc, BYTE)                                    ' L2TRUNC   present
      gsProp(FlgLM, BYTE)                                         ' LM        present
      gsProp(FlgMax, BYTE)                                        ' MAX       present
      gsProp(FlgMSolid, BYTE)                                     ' MSOLID    present
      gsProp(FlgMStd, BYTE)                                       ' MSTD      present
      gsProp(FlgNext, BYTE)                                       ' Next      present
      gsProp(FlgNF, BYTE)                                         ' NF        present
      gsProp(FlgMX, BYTE)                                         ' MX        present
      gsProp(FlgNU, BYTE)                                         ' NU        present
      gsProp(FlgNX, BYTE)                                         ' NX        present
      gsProp(FlgOn, BYTE)                                         ' ON        present
      gsProp(FlgOff, BYTE)                                        ' OFF       present
      gsProp(FlgPrefix, BYTE)                                     ' PREFIX    present
      gsProp(FlgPrev, BYTE)                                       ' PREV      present
      gsProp(FlgPStd, BYTE)                                       ' PSTD      present
      gsProp(FlgRight, BYTE)                                      ' RIGHT     present
      gsProp(FlgRngPass, BYTE)                                    ' RNGPASS   (Internal)
      gsProp(FlgRM, BYTE)                                         ' RM        present
      gsProp(FlgSet, BYTE)                                        ' SET       present
      gsProp(FlgSolid, BYTE)                                      ' SOLID     present
      gsProp(FlgStd, BYTE)                                        ' STD       present
      gsProp(FlgSuffix, BYTE)                                     ' SUFFIX    present
      gsProp(FlgTCol, BYTE)                                       ' TCOL      present
      gsProp(FlgText, BYTE)                                       ' T         present
      gsProp(FlgToggle, BYTE)                                     ' TOGGLE    present
      gsProp(FlgTop, BYTE)                                        ' TOP       present
      gsProp(FlgU, BYTE)                                          ' U         present
      gsProp(FlgWord, BYTE)                                       ' WORD      present
      gsProp(FlgX, BYTE)                                          ' X         present
      gsProp(FoundFailed, LONG)                                   ' Current Last search resulted in Not Found 1 = Top, 2 = Bottom
      gsProp(FoundCol, LONG)                                      ' Current Found column
      gsProp(FoundLen, LONG)                                      ' Current Found length
      gsProp(FoundLine, LONG)                                     ' Current Found line
      gsProp(HiLiteOff, LONG)                                     ' Current HiLite -Off color
      gsProp(HiLiteOn, LONG)                                      ' Current HiLite +On  color
      gsProp(HiLiteSrch, LONG)                                    ' Current HiLite search color
      gsProp(ItemName, WSTRING)                                   ' Key in WSTRING format
      gsProp(ItemValue, WSTRING)                                  ' Value in WSTRING format
      gsProp(L1Raw, STRING)                                       ' Literal 1 raw
      gsProp(L1RData, STRING)                                     ' Literal 1 massaged data
      gsProp(L1Len, LONG)                                         ' Current real length of find string
      gsProp(L2Raw, STRING)                                       ' Literal 2 raw
      gsProp(L2RData, STRING)                                     ' Literal 2 massaged data
      gsProp(L2Len, LONG)                                         ' Current real length of change string
      gsProp(SplitPoint1, LONG)                                   ' Current SPLIT point (where the | is) Lit1
      gsProp(SplitPoint2, LONG)                                   ' Current SPLIT point (where the | is) Lit2)

      gsProp(RL1Raw, STRING)                                      '
      gsProp(RL1RData, STRING)                                    '
      gsProp(RL1Len, LONG)                                        '
      gsProp(RSplitPoint1, LONG)                                  '
      gsProp(RSplitPoint2, LONG)                                  '
      gsProp(RFlgLit1, BYTE)                                      '
      gsProp(RFlgL1Picture, BYTE)                                 '
      gsProp(RFlgL1Hex, BYTE)                                     '
      gsProp(RFlgL1RegEx, BYTE)                                   '
      gsProp(RFlgL1CaseComp, BYTE)                                '
      gsProp(RFlgL1CaseInComp, BYTE)                              '

      gsProp(RL2Raw, STRING)                                      '
      gsProp(RL2RData, STRING)                                    '
      gsProp(RL2Len, LONG)                                        '
      gsProp(RFlgLit2, BYTE)                                      '
      gsProp(RFlgL2Hex, BYTE)                                     '
      gsProp(RFlgL2CaseComp, BYTE)                                '
      gsProp(RFlgL2CaseInComp, BYTE)                              '

      METHOD PTBLReset()                                          '
         RESET ColFrom, ColTo, FindRngEnd, FindRngFlag, FindRngLCtl, FindRngSet, FindRngStart   '
         RESET FindRngTag, FindRngTNF, FlgAll, FlgChars, FlgCS, FlgComment, FlgDS, FlgDX, FlgQuoted   '
         RESET FlgFCol, FlgFirst, FlgHiClr, FlgHiOff, FlgHiOn, FlgLast, FlgLeft, FlgLit1, FlgL1Picture   '
         RESET FlgL1Hex, FlgL1RegEx, FlgL1DLM, FlgL1CaseComp, FlgL1CaseInComp, FlgLit2, FlgL2Picture  '
         RESET FlgL2Hex, FlgL2Format, FlgL2CaseComp, FlgL2CaseInComp, FlgL2Trunc, FlgLM, FlgMax '
         RESET FlgMSolid, FlgMStd, FlgNext, FlgNF, FlgMX, FlgNU, FlgNX, FlgOn, FlgOff, FlgPrefix   '
         RESET FlgPrev, FlgPStd, FlgRight, FlgRngPass, FlgRM, FlgSet, FlgSolid, FlgStd, FlgSuffix  '
         RESET FlgTCol, FlgText, FlgToggle, FlgTop, FlgU, FlgWord, FlgX, FoundFailed, FoundCol  '
         RESET FoundLen, FoundLine, HiLiteOff, HiLiteOn, HiLiteSrch  '
         RESET L1Raw, L1RData, L1Len, L2Raw, L2RData, L2Len, SplitPoint1, SplitPoint2  '
         '-----------------------------------------------------------------------------------------+
         '- Initialize it to look like ALL                                                         |
         '-----------------------------------------------------------------------------------------+
         ColFrom = TP.FCB_.BndLeft                                ' Set defaults to ALL
         ColTo= TP.FCB_.BndRight                                  '
         IF ColTo = 0 THEN ColTo = TP.MaxLength                   '
         TP.sLine = 1: TP.sCol = 1                                ' Reset search location
         FindRngStart = 2: FindRngEnd = TP.LastLine - 1           '
         FindRngFlag = 0                                          '
         FindRngLCtl = " "                                        '
         FindRngSet = %False                                      '
         FindRngTag = ""                                          '
         FindRngTNF = %False                                      '
      END METHOD                                                  '

      METHOD Reverse()                                            '
         FlgNext = IIF(FlgNext, %False, %True)                    ' Reverse search direction
         FlgPrev = IIF(FlgPrev, %False, %True)                    '
         TP.sDir = IIF(TP.sDir = 1, -1, 1)                        '
      END METHOD                                                  '

      METHOD Ops(ix AS LONG) AS STRING: METHOD = Ops(ix): END METHOD '
      METHOD OpsShift()                                           '
         IF OpsNum > 0 THEN                                       ' Something there?
            ARRAY DELETE Ops(0): DECR OpsNum                      ' Remove the 1st
         END IF                                                   '
      END METHOD                                                  '

      METHOD LoadModel(CmdName AS STRING, OPT PreLoad AS LONG) AS LONG  '
      '--------------------------------------------------------------------------------------------+
      '- First, Parse the Definition string                                                        |
      '--------------------------------------------------------------------------------------------+
      LOCAL num, tv AS LONG                                       '
      LOCAL KWCtl, KWCtl2, KWGroup, KWEntry, KWMastName, t, u AS STRING '
      LOCAL i, j, k, x, NumAliases, MOpsNum, Uniq, PLoad, OptKey AS LONG   '
      LOCAL PDVMax, PDVGot AS LONG                                '
      LOCAL PDVType AS STRING                                     '
      LOCAL MOps() AS STRING                                      '
      STATIC LastModel AS STRING                                  '
      DIM   MOps(0 TO 300) AS STRING                              '
      IF ISFALSE ISMISSING(PreLoad) THEN PLoad = %True            ' Just a Preload?
         IF CmdName = LastModel AND PLoad THEN EXIT METHOD        ' And already loaded, do nothing
         Tbl.Clear                                                ' Clear the Parse table
         RESET MaxNum, MaxLit, MaxDotd, MaxLPtr, MaxTag, MaxKwd   ' Clear MAX counters
         '-----------------------------------------------------------------------------------------+
         '- Fetch the Model                                                                        |
         '-----------------------------------------------------------------------------------------+
         t = TRIM$(gSQLP.GetString(CmdName))                      ' Fetch the model for this command
         IF ISNULL(t) AND ISFALSE IsMacro(CmdName) THEN           ' No there and not a Macro
            MyMsgBox("Parse Model missing for: |K" + CmdName + "|B", %MB_OK OR %MB_USERICON OR %MB_TASKMODAL, "Serious PARSE error")   '
            EXIT METHOD                                           '
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Break it into 'words'                                                                  |
         '-----------------------------------------------------------------------------------------+
         DO WHILE LEN(t)                                          ' Break out the operands
            INCR MOpsNum                                          ' Bump index
            MOps(MOpsNum) = GetNextWord(t, %True)                 '
         LOOP                                                     '
         '-----------------------------------------------------------------------------------------+
         '- Save the mandatory # style parameters                                                  |
         '-----------------------------------------------------------------------------------------+
         MaxNum = VAL(MOps(1))                                    ' Save basic #
         IF INSTR(MOps(1), "~")  THEN MaxNum += %Arg_Var          '   If variable,  set the flag
         IF INSTR(MOps(1), "!")  THEN MaxNum += %Arg_Def          '   If defined,   set the flag
         IF INSTR(MOps(1), "?")  THEN MaxNum += %Arg_Opt          '   If optional,  set the flag
         MaxLit = VAL(MOps(2))                                    ' Save basic #
         IF INSTR(MOps(2), "~")  THEN MaxLit += %Arg_Var          '   If variable,  set the flag
         IF INSTR(MOps(2), "!")  THEN MaxLit += %Arg_Def          '   If defined,   set the flag
         IF INSTR(MOps(2), "?")  THEN MaxLit += %Arg_Opt          '   If optional,  set the flag
         MaxDotd = VAL(MOps(3))                                   ' Save basic #
         IF INSTR(MOps(3), "~")  THEN MaxDotd += %Arg_Var         '   If variable,  set the flag
         IF INSTR(MOps(3), "!")  THEN MaxDotd += %Arg_Def         '   If defined,   set the flag
         IF INSTR(MOps(3), "?")  THEN MaxDotd += %Arg_Opt         '   If optional,  set the flag
         MaxLPtr = VAL(MOps(4))                                   ' Save basic #
         IF INSTR(MOps(4), "~")  THEN MaxLPtr += %Arg_Var         '   If variable,  set the flag
         IF INSTR(MOps(4), "!")  THEN MaxLPtr += %Arg_Def         '   If defined,   set the flag
         IF INSTR(MOps(4), "?")  THEN MaxLPtr += %Arg_Opt         '   If optional,  set the flag
         MaxTag = VAL(MOps(5))                                    ' Save basic #
         IF INSTR(MOps(5), "~")  THEN MaxTag += %Arg_Var          '   If variable,  set the flag
         IF INSTR(MOps(5), "!")  THEN MaxTag += %Arg_Def          '   If defined,   set the flag
         IF INSTR(MOps(5), "?")  THEN MaxTag += %Arg_Opt          '   If optional,  set the flag
         MaxAdj = VAL(MOps(6))                                    ' Save basic #
         IF INSTR(MOps(6), "~")  THEN MaxAdj += %Arg_Var          '   If variable,  set the flag
         IF INSTR(MOps(6), "!")  THEN MaxAdj += %Arg_Def          '   If defined,   set the flag
         IF INSTR(MOps(6), "?")  THEN MaxAdj += %Arg_Opt          '   If optional,  set the flag
         '-----------------------------------------------------------------------------------------+
         '- Do the KW string types if present                                                      |
         '-----------------------------------------------------------------------------------------+
         RESET Flg                                                ' Clear all flags
         IF MOpsNum > 6 THEN                                      ' Optional operands?
            FOR x = 7 TO MOpsNum                                  ' Process them
               KWCtl = MOps(x)                                    ' Get the next
               IF ISNULL(KWCtl) THEN ITERATE FOR                  ' Ignore nulls
               KWGroup = ""                                       ' Reset the groupname
               '-----------------------------------------------------------------------------------+
               '- Handle each Model operand (Space delimited) now                                  |
               '-----------------------------------------------------------------------------------+
               IF LEFT$(KWCtl, 8) = "OPTIONS:" THEN               ' Got an OPTIONS: string?
                  KWCtl = MID$(KWCtl, 9)                          ' Remove OPTIONS:
                  IF ISNOTNULL(KWCtl) THEN                        ' Something there?
                     FOR i = 1 TO LEN(KWCtl)                      ' Process them
                        SELECT CASE AS CONST$ MID$(KWCtl, i, 1)   '
                           CASE "R": Flg.LRangeOK = %True         '
                           CASE "#": Flg.LRangeNum = %True        '
                           CASE "C": Flg.ColsOK = %True           '
                           CASE "1": Flg.L1OK = %True             '
                           CASE "2": Flg.L2OK = %True             '
                           CASE "F": Flg.L1FName = %True          '
                        END SELECT                                '
                     NEXT i                                       '
                  END IF                                          '
                  ITERATE FOR                                     '
               END IF                                             '
               '-----------------------------------------------------------------------------------+
               '- Process any Groupname if present, or create a pseudo one                         |
               '-----------------------------------------------------------------------------------+
               IF INSTR(KWCtl, ":") THEN                          ' Is a groupname present?
                  KWGroup = "$$" + EXTRACT$(KWCtl, ":")           ' Extract it
                  KWCtl = REMAIN$(KWCtl, ":")                     ' Strip xxxx: from KWCtl
                  INCR MaxKwd                                     '
               ELSE                                               ' No Groupname, create a pseudo one
                  IF LEFT$(KWCtl, 1) = "*" AND LEN(KWCtl) > 1 THEN   ' An ignorable Kwd?
                     KWGroup = "$$0000"                           ' Use fixed $$0000
                     KWCtl = CLIP$(LEFT, KWCtl, 1)                ' Remove the *
                  ELSE                                            '
                     INCR uniq                                    ' Create a pseudo group
                     KWGroup = "$$" + FORMAT$(uniq, "0000")       ' $$ + uniq
                  END IF                                          '
                  INCR MaxKwd                                     '
               END IF                                             '
               IF KWGroup <> "$$0000" OR ISFALSE OptKey THEN      ' Actually write it?
                  ItemName = KWGroup                              ' Setup the key
                  ItemValue = ""                                  ' Initialize as null
                  Tbl.Add(ItemName, ItemValue)                    ' Add the Grpname entry
               END IF                                             '
               IF KWGroup = "$$0000" THEN OptKey = %True          ' Only save $$0000 once
               SELECT CASE AS CONST$ LEFT$(KWCtl, 1)              ' What's next
                  CASE "("                                        ' Parenthesis
                     KWCtl = MID$(KWCtl, 2 TO LEN(KWCtl) - 1)     ' Remove (...)
                     FOR i = 1 TO PARSECOUNT(KWCtl, "|")          ' Do each operand
                        t = PARSE$(KWCtl, "|", i)                 '
                        IF LEFT$(t, 1) <> "[" THEN                ' If not an alias
                           IF i = 1 AND t = LCASE$(t) THEN        ' If first item and in lowercase
                              ItemName = KWGroup: ItemValue = t   ' Update group with the default 1st entry
                              Tbl.Replace(ItemName, ItemValue)    '
                           END IF                                 '
                           ItemName = UCASE$(t): ItemValue = KWGroup ' Point Kwd at the Groupname
                           Tbl.Add(ItemName, ItemValue)           ' Add the keyword entry
                           ITERATE FOR                            ' We're done, onward
                        ELSE                                      ' It's an embedded Alias entry
                           KWCtl2 = t                             ' Copy for inner loop processing
                           NumAliases = 0                         ' Reset alias count [aa/bb/cc]
                           FOR j = 1 TO PARSECOUNT(KWCtl2, "/")   ' Do each alias operand
                              u = PARSE$(KWCtl2, "/", j)          '
                              IF LEFT$(u, 1) = "[" THEN u = CLIP$(LEFT, u, 1) '
                              IF RIGHT$(u, 1) = "]" THEN u = CLIP$(RIGHT, u, 1)  '
                              INCR NumAliases                     ' INCR aliases
                              IF NumAliases = 1 THEN              ' Make the 1st a normal list item
                                 IF u = LCASE$(u) THEN            ' If first item and in lowercase
                                    ItemName = KWGroup: ItemValue = u   ' Update group with the default 1st entry
                                    Tbl.Replace(ItemName, ItemValue) '
                                 END IF                           '
                                 KWMastName = UCASE$(u)           ' Save it
                                 ItemName = UCASE$(u): ItemValue = KWGroup '
                                 Tbl.Add(ItemName, ItemValue)     ' Add the master keyword entry
                              ELSE                                ' An alias, secondary entry
                                 ItemName = u: ItemValue = "@@" + KWMastName  '
                                 Tbl.Add(ItemName, ItemValue)     ' Add the master keyword entry
                              END IF                              '
                              ITERATE FOR                         '
                           NEXT j                                 '
                        END IF                                    '
                     NEXT i                                       '

                  CASE "["                                        ' Simple alias names in Brackets?
                     NumAliases = 0                               ' Reset alias count [aa/bb/cc]
                     KWCtl = MID$(KWCtl, 2 TO LEN(KWCtl) - 1)     ' Remove [...]
                     FOR i = 1 TO PARSECOUNT(KWCtl, "/")          ' Do each alias operand
                        u = PARSE$(KWCtl, "/", i)                 '
                        INCR NumAliases                           ' INCR aliases
                        IF i = 1 AND u = LCASE$(u) THEN           ' If first item and in lowercase
                           ItemName = KWGroup: ItemValue = u      ' Update group with the default 1st entry
                           Tbl.Replace(ItemName, ItemValue)       '
                        END IF                                    '
                        IF NumAliases = 1 THEN                    ' Make the 1st a normal list item
                           KWMastName = UCASE$(u)                 ' Save it
                           ItemName = UCASE$(u): ItemValue = KWGroup '
                           Tbl.Add(ItemName, ItemValue)           ' Add the master keyword entry
                        ELSE                                      ' An alias, secondary entry
                           ItemName = u: ItemValue = "@@" + KWMastName  '
                           Tbl.Add(ItemName, ItemValue)           ' Add the master keyword entry
                        END IF                                    '
                        ITERATE FOR                               '
                     NEXT j                                       '

                  CASE ELSE                                       ' Simple Kwd
                     ItemName = KWCtl                             '
                     ItemName = KWCtl: ItemValue = KWGroup        '
                     Tbl.Add(ItemName, ItemValue)                 ' Add the simple keyword entry
               END SELECT                                         '
            NEXT x                                                '
         END IF                                                   '
         LastModel = CmdName                                      ' Save as loaded name
'-       FOR x = 1 TO Tbl.Count
'-          TBL.Entry(x, ItemName, varValue)
'-          debug LSET$(ItemName, 10)+"="+VARIANT$(varValue)
'-       NEXT x
'-       debug "---------------"                                 '
         METHOD = %False                                          '
         EXIT METHOD                                              '
      END METHOD                                                  '

      METHOD DefKwd(Kwd AS STRING) AS LONG                        '
      '--------------------------------------------------------------------------------------------+
      '- Get Keyword definition presence True/False                                                |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, k AS WSTRING, Ans AS VARIANT                       '
         k = UCASE$(Kwd)                                          ' Start with UC version
         Ans = Tbl.Item(k)                                        ' Fetch its value
         IF OBJRESULT = 0 THEN METHOD = %True: EXIT METHOD        ' Found it, return True
         k = LCASE$(Kwd)                                          ' LC Arg
         Ans = Tbl.Item(k)                                        ' Fetch its value
         IF OBJRESULT > 0 THEN EXIT METHOD                        ' Not a Kwd
         METHOD = %True                                           ' It's here
      END METHOD                                                  '

      METHOD IsKwd(Kwd AS STRING) AS LONG                         '
      '--------------------------------------------------------------------------------------------+
      '- Get Keyword presence True/False                                                           |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, k AS WSTRING, Ans AS VARIANT                       '
         k = UCASE$(Kwd)                                          ' UC Arg
         Ans = Tbl.Item(k)                                        ' Fetch its value
         IF OBJRESULT > 0 THEN EXIT METHOD                        ' Not a Kwd
         t = VARIANT$(Ans)                                        ' Get it as TXT
         IF LEFT$(t, 2) = "$$" THEN                               ' Groupname chain?
            Ans = Tbl.Item(t)                                     ' Chain to it
            t = VARIANT$(Ans)                                     ' Make a WSTRING
            IF t = k THEN METHOD = %True                          ' Then it wins
         END IF                                                   '
      END METHOD                                                  '

      METHOD Grp(GrpName AS STRING) AS STRING                     '
      '--------------------------------------------------------------------------------------------+
      '- Get Which GroupName was entered, or NULL                                                  |
      '--------------------------------------------------------------------------------------------+
      LOCAL t AS STRING                                           '
      LOCAL V AS VARIANT                                          '
         ItemName = "$$" + UCASE$(GrpName)                        ' Build key
         V = Tbl.Item(ItemName)                                   ' Try the retrieval
         IF OBJRESULT > 0 THEN                                    ' Not found
            METHOD = "": EXIT METHOD                              ' Return Null
         ELSE                                                     ' Retrieved OK
            t = UCASE$(VARIANT$(V))                               ' Return string
            METHOD = t                                            ' Return it
         END IF                                                   '
      END METHOD                                                  '

      METHOD NULL(PType AS STRING, Num AS LONG)                   '
      '--------------------------------------------------------------------------------------------------+
      '- Get Parsed Positional type parameter                                                            |
      '--------------------------------------------------------------------------------------------------+
      LOCAL v AS VARIANT                                          '
         IF PType = "#" AND Num > GotNum _                        ' First ensure index is OK
         OR PType = "$" AND Num > GotLit _                        '
         OR PType = "$$" AND Num > GotLit _                       '
         OR PType = "." AND Num > GotDotd _                       '
         OR PType = "!" AND Num > GotLPtr _                       '
         OR PType = ":" AND Num > GotTag THEN                     '
            EXIT METHOD                                           '
         END IF                                                   '
         ItemName = PType + FORMAT$(Num)                          ' Build key
         Tbl.Replace(ItemName, "")                                ' Nullify it
      END METHOD                                                  '

      METHOD POS(PType AS STRING, Num AS LONG) AS STRING          '
      '--------------------------------------------------------------------------------------------------+
      '- Get Parsed Positional type parameter                                                            |
      '--------------------------------------------------------------------------------------------------+
      LOCAL v AS VARIANT                                          '
         IF PType = "#" AND Num > GotNum _                        ' First ensure index is OK
         OR PType = "$" AND Num > GotLit _                        '
         OR PType = "$$" AND Num > GotLit _                       '
         OR PType = "." AND Num > GotDotd _                       '
         OR PType = "!" AND Num > GotLPtr _                       '
         OR PType = "+" AND Num > GotAdj _                        '
         OR PType = ":" AND Num > GotTag THEN                     '
            METHOD = "": EXIT METHOD                              '
         END IF                                                   '
         ItemName = PType + FORMAT$(Num)                          ' Build key
         V = Tbl.Item(ItemName)                                   ' Try the retrieval
         METHOD = VARIANT$(V)                                     ' Return string
      END METHOD                                                  '

      METHOD POS2(Num AS LONG) AS STRING                          '
      '--------------------------------------------------------------------------------------------------+
      '- Get Parsed String type starting at real data pos - 2                                            |
      '--------------------------------------------------------------------------------------------------+
      LOCAL v AS VARIANT                                          '
         IF Num > GotLit THEN METHOD = "": EXIT METHOD            ' Invalid index, return null
         ItemName = "$" + FORMAT$(Num)                            ' Build key
         V = Tbl.Item(ItemName)                                   ' Try the retrieval
         METHOD = MID$(VARIANT$(V), 2)                            ' Return string
      END METHOD                                                  '

      METHOD SwapPos(PType AS STRING, Num1 AS LONG, Num2 AS LONG) '
      '--------------------------------------------------------------------------------------------------+
      '- Swap two parameters                                                                             |
      '--------------------------------------------------------------------------------------------------+
      LOCAL v AS VARIANT, T1Name, T1Value, T2Name, T2Value AS WSTRING   '
         IF PType = "#" AND Num1 > GotNum _                       ' First ensure indexes are OK
         OR PType = "$" AND Num1 > GotLit _                       '
         OR PType = "$$" AND Num1 > GotLit _                      '
         OR PType = "." AND Num1 > GotDotd _                      '
         OR PType = "!" AND Num1 > GotLPtr _                      '
         OR PType = "+" AND Num1 > GotAdj _                       '
         OR PType = ":" AND Num1 > GotTag THEN EXIT METHOD        '
         IF PType = "#" AND Num2 > GotNum _                       ' First ensure indexes are OK
         OR PType = "$" AND Num2 > GotLit _                       '
         OR PType = "$$" AND Num2 > GotLit _                      '
         OR PType = "." AND Num2 > GotDotd _                      '
         OR PType = "!" AND Num2 > GotLPtr _                      '
         OR PType = "+" AND Num2 > GotAdj _                       '
         OR PType = ":" AND Num2 > GotTag THEN EXIT METHOD        '

         T1Name = PType + FORMAT$(Num1)                           ' Get current values
         T1Value = VARIANT$(Tbl.Item(T1Name))                     '
         T2Name = PType + FORMAT$(Num2)                           '
         T2Value = VARIANT$(Tbl.Item(T2Name))                     '

         Tbl.Replace(T1Name, T2Value)                             ' Swap them
         Tbl.Replace(T2Name, T1Value)                             '
      END METHOD                                                  '

      METHOD SwapL1L2()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Swap two Criteria L1 l2 pair                                                              |
      '--------------------------------------------------------------------------------------------+
         SWAP L1Raw,   L2Raw                                      '
         SWAP L1RData, L2RData                                    '
         SWAP L1Len,   L2Len                                      '
      END METHOD                                                  '

      METHOD ParseCmd(Cmd AS STRING, Phase AS LONG) AS LONG       '
      '--------------------------------------------------------------------------------------------+
      '- Parse the command line                                                                    |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, t1, Dlm1, Dlm2, p, VType, StrStart, StrEnd, Rx, IRx, L1Type, L2Type AS STRING '
      LOCAL i, j, k, x, Q1, Q2, Qt, FindChange, VMax, VGot, tv, D1, GotBar, StrNum AS LONG   '
      LOCAL  KWMastName, GroupName, TempValue AS WSTRING          '
         METHOD = 2                                               ' Set default exit (Fail)
         IF (Phase AND %PLOAD) THEN                               ' Load the Model?
            '--------------------------------------------------------------------------------------+
            '- Break out operands, get the Command name from the first operand                     |
            '--------------------------------------------------------------------------------------+
            t = TRIM$(Cmd)                                        ' Get a copy to play with, reset
            RESET OpsNum, Ops()                                   '
            DO WHILE LEN(t)                                       ' Break out the operands
               Ops(OpsNum) = GetNextWord(t, %True)                ' Grab next 'word' of Cmd
               INCR OpsNum                                        '
               IF OpsNum = UBOUND(Ops()) THEN                     ' Time to expand?
                  REDIM PRESERVE Ops(0 TO 2 * OpsNum) AS INSTANCE STRING   '
               END IF                                             '
            LOOP                                                  '
            IF OpsNum = 0 THEN ErrMsg = "No CmdName present": METHOD = 2: EXIT METHOD  ' Nothing - return
            DECR OpsNum                                           ' So OpsNum is the 1-n count

            '--------------------------------------------------------------------------------------+
            '- Get the MODEL for this command loaded                                               |
            '--------------------------------------------------------------------------------------+
            IF me.LoadModel(UCASE$(Ops(0))) THEN ErrMsg = "Internal MODEL error": EXIT METHOD   ' Probable unknown command
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Handle the trivial ? case                                                              |
         '-----------------------------------------------------------------------------------------+
         IF (Phase AND %PParse) THEN                              ' Parse against the Model?
            IF OpsNum = 1 AND Ops(1) = "?" THEN                   ' First eliminate the ? request
               ErrMsg = "": METHOD = 1: EXIT METHOD               ' Tell caller
            END IF                                                '

            RESET GotLit, GotNum, GotLPtr, GotTag, GotDotd, GotAdj   '

            FOR j = 1 TO OpsNum                                   ' OK, now process the operands
               IF ISNULL(Ops(j)) THEN ITERATE FOR                 ' Only do non-null operands
               '--------------------------------------------------------------------------------------+
               '- First see if it's one of the unique types                                           |
               '--------------------------------------------------------------------------------------+
               IF LEFT$(Ops(j), 1) = "." THEN                     ' Is this a . Line reference?
                  IF GotDotd = (MaxDotd AND &H00FFFFFF) THEN ErrMsg = "Operand: " + Ops(j) + ", exceeds the maximum allowed Line References": EXIT METHOD   ' At the maximum
                  '-----------------------------------------------------------------------------------+
                  '- Validate a Line Reference if requested                                           |
                  '-----------------------------------------------------------------------------------+
                  k = VERIFY(2, Ops(j), "<>=\" + CHR$(172))       ' Find 1st Label/Tagname character
                  t = IIF$(k = 2, Ops(j), "." + MID$(Ops(j), k))  ' Build operand
                  IF (MaxDotd AND %ARG_DEF) <> 0 THEN             ' If ARG_DEF, then it must exist
                    IF TP.LineNoRef(t) = -1 THEN _                ' If invalid
                       ErrMsg = "Line Reference: " + Ops(j) + " is invalid": EXIT METHOD  '
                  END IF                                          '
                  IF LEN(Ops(j)) < 2 THEN ErrMsg = "Line Reference: " + Ops(j) + " is invalid": EXIT METHOD '
                  INCR GotDotd                                    ' Count it
                  ItemValue = Ops(j)                              ' Make it Wide
                  ItemName = "." + FORMAT$(GotDotd)               ' Build the key
                  Tbl.Add(ItemName, ItemValue)                    ' Try to Add the .n entry
                  ITERATE FOR                                     ' Done this operand
               END IF                                             '

               IF (LEFT$(Ops(j), 1) <> "+" AND LEFT$(Ops(j), 1) <> "-") THEN GOTO NoPM ' Is not a Possible +- adjustment
               IF LEN(Ops(j)) = 1 THEN ErrMsg = "Operand: " + Ops(j) + ", cannot be a sole operand": EXIT METHOD  ' At the maximum
               IF VERIFY(2, Ops(j), $Numeric) = 0 THEN            '
                  IF GotAdj = (MaxAdj AND &H00FFFFFF) THEN ErrMsg = "Operand: " + Ops(j) + ", exceeds the maximum allowed +/- Adjustments": EXIT METHOD  ' At the maximum
                  '-----------------------------------------------------------------------------------+
                  '- Validate a +/- adjustment                                                        |
                  '-----------------------------------------------------------------------------------+
                  INCR GotAdj                                     ' Count it
                  ItemValue = Ops(j)                              ' Make it Wide
                  ItemName = "+" + FORMAT$(GotAdj)                ' Build the key
                  Tbl.Add(ItemName, ItemValue)                    ' Try to Add the +-nn entry
                  ITERATE FOR                                     ' Done this operand
               END IF                                             '

               NoPM:                                              '
               IF LEFT$(Ops(j), 1) = "!" THEN                     ' Is this a ! Line pointer?
                  IF GotLptr = (MaxLptr AND &H00FFFFFF) THEN ErrMsg = "Operand: " + Ops(j) + ", exceeds the maximum allowed Line Pointers": EXIT METHOD  ' At the maximum
                  '-----------------------------------------------------------------------------------+
                  '- Validate a Line Reference if requested                                           |
                  '-----------------------------------------------------------------------------------+
                  k = VERIFY(2, Ops(j), "<>=\" + CHR$(172))       ' Find 1st Label/Tagname character
                  t = IIF$(k = 2, Ops(j), "!" + MID$(Ops(j), k))  ' Build operand
                  IF (MaxLptr AND %ARG_DEF) <> 0 THEN             ' If ARG_DEF, then it must exist
                    IF TP.LineNoRef(t) = -1 THEN _                ' If invalid
                       ErrMsg = "Line Pointer: " + Ops(j) + " is invalid": EXIT METHOD '
                  END IF                                          '
                  IF LEN(Ops(j)) < 2 THEN ErrMsg = "Line Pointer: " + Ops(j) + " is invalid": EXIT METHOD   '
                  INCR GotLptr                                    ' Count it
                  ItemValue = Ops(j)                              ' Make it Wide
                  ItemName = "!" + FORMAT$(GotLptr)               ' Build the key
                  Tbl.Add(ItemName, ItemValue)                    ' Try to Add the .n entry
                  ITERATE FOR                                     ' Done this operand
               END IF                                             '

               IF LEFT$(Ops(j), 1) = ":" THEN                     ' Is this a Tag??
                  IF GotTag = (MaxTag AND &H00FFFFFF) THEN ErrMsg = "Operand: " + Ops(j) + ", exceeds the maximum allowed Tag References": EXIT METHOD   ' At the maximum
                  k = VERIFY(2, Ops(j), "<>=\" + CHR$(172))       ' Find 1st Label/Tagname character
                  t = IIF$(k = 2, Ops(j), "." + MID$(Ops(j), k))  ' Build operand
                  IF (MaxTag AND %ARG_DEF) <> 0 THEN              ' If ARG_DEF, make sure it's valid
                     IF TagValidate(t, %True) THEN _              ' If invalid
                        ErrMsg = "Tag Operand: " + Ops(j) + " is invalid": EXIT METHOD '
                  END IF                                          '
                  IF LEN(Ops(j)) < 2 THEN ErrMsg = "Tag Operand: " + Ops(j) + " is invalid": EXIT METHOD '
                  INCR GotTag                                     ' Count it
                  ItemValue = Ops(j)                              ' Make it Wide
                  ItemName = ":" + FORMAT$(GotTag)                ' Build the key
                  Tbl.Add(ItemName, ItemValue)                    ' Try to Add the :n entry
                  ITERATE FOR                                     ' Done this operand
               END IF                                             '

               IF VERIFY(Ops(j), "0123456789") = 0 THEN           ' Is this a numeric literal
                  i = (MaxNum AND &H00FFFFFF)                     '
                  IF GotNum = (MaxNum AND &H00FFFFFF) THEN ErrMsg = "Operand: " + Ops(j) + ", exceeds the maximum allowed numeric literals": EXIT METHOD ' At the maximum
                  INCR GotNum                                     ' Count it
                  ItemValue = Ops(j)                              ' Make it Wide
                  ItemName = "#" + FORMAT$(GotNum)                ' Build the key
                  Tbl.Add(ItemName, ItemValue)                    ' Try to Add the #n entry
                  ITERATE FOR                                     ' Done this operand
               END IF                                             '
               '--------------------------------------------------------------------------------------+
               '- If Not a Kwd, then it's a String                                                    |
               '--------------------------------------------------------------------------------------+
               KWMastName = UCASE$(Ops(j))                        ' Save as Master name
               ItemName = KWMastName                              ' Working name
               GroupName = VARIANT$(Tbl.Item(ItemName))           ' Try for the $$ entry
               IF OBJRESULT <> 0 THEN                             ' Not found, this must be a string
                  IF (MaxLit + MaxNum + MaxTag + MaxLPtr + MaxDotd + MaxAdj) = 0 AND MaxKwd > 0 THEN  '
                     ErrMsg = "Operand: " + UCASE$(Ops(j)) + " is an unrecognized keyword": EXIT METHOD  '
                  END IF                                          '
                  IF GotLit = (MaxLit AND &H00FFFFFF) THEN        ' Over the Max literals allowed?
                     i = ArraySearch(gKwdMast, Ops(j), CompareSimpleS)  ' Search for the possible Kwd
                     IF i = 0 THEN                                '
                        ErrMsg = "Operand: " + Ops(j) + ", exceeds the maximum allowed text operands": EXIT METHOD   ' At the maximum
                     ELSE                                         '
                        ErrMsg = "Operand: " + UCASE$(Ops(j)) + ", is an unsupported keyword for this command": EXIT METHOD   ' At the maximum
                     END IF                                       '
                  END IF                                          '
                  INCR GotLit                                     ' Count it
                  t = Ops(j)                                      ' Get local copy
                  IF INSTR(t, ANY $Quotes) = 0 THEN               ' If no quotes
                     t = $OpStr + t                               ' Make it a simple string
                  ELSE                                            '
                     '-----------------------------------------------------------------------------+
                     '- Check for matching quotes                                                  |
                     '-----------------------------------------------------------------------------+
                     t1 = t                                       ' Save original
                     q1 = 1: q2 = LEN(t): qt = 0                  ' Setup for "xxxxx" style
                     GOSUB DoQStr                                 ' Check it
                     IF t <> t1 THEN GOTO GotQItem                ' A change, we have it
                     IF LEN(t) < 3 THEN                           ' No change, big enogh fr a type code?
                        ErrMsg = "Mis-matched or missing quotes detected in Operand #" + FORMAT$(j):  EXIT METHOD '
                     END IF                                       '
                     q1 = 2: q2 = LEN(t): qt = 1                  ' Setup for T"xxxxx" style
                     GOSUB DoQStr                                 ' Check it
                     IF t <> t1 THEN GOTO GotQItem                ' A change, we have it
                     q1 = 1: q2 = LEN(t) - 1: qt = LEN(t)         ' Setup for "xxxxx"T style
                     GOSUB DoQStr                                 ' Check it
                     IF t = t1 THEN                               ' No change, this is an Oops
                        ErrMsg = "Mis-matched or missing quotes detected in Operand #" + FORMAT$(j): EXIT METHOD  '
                     END IF                                       '
                  END IF                                          '
                  GotQItem:                                       '
                  ItemValue = t                                   ' Make it Wide
                  ItemName = "$" + FORMAT$(GotLit)                ' Build the key
                  Tbl.Add(ItemName, ItemValue)                    ' Try to Add the .n entry
                  ItemValue = Ops(j)                              ' Save the Raw
                  ItemName = "$$" + FORMAT$(GotLit)               ' Build the key
                  Tbl.Add(ItemName, ItemValue)                    ' Try to Add the .n entry
                  ITERATE FOR                                     ' Done with this operand
               END IF                                             '
               '--------------------------------------------------------------------------------------+
               '- We have some kind of Kwd                                                            |
               '--------------------------------------------------------------------------------------+
               IF GroupName = "$$0000" THEN ITERATE FOR           ' Ignorable Kwd, we're done
               IF LEFT$(GroupName, 2) = "@@" THEN                 ' An alias entry, not a $$ Group?
                  KWMastName = MID$(GroupName, 3)                 ' Chain to the real entry
                  GroupName = VARIANT$(Tbl.Item(KWMastName))      ' Itemname = $$ Group name
               END IF                                             '
               TempValue = VARIANT$(Tbl.Item(GroupName))          ' Fetch the $$ Group value
               IF ISNULL(TempValue) OR TempValue = LCASE$(TempValue) THEN  ' OK to swap it?
                  Tbl.Replace(GroupName, KWMastName)              ' Adjust entry to contain choice
                  ITERATE FOR                                     ' We're done
               ELSE                                               '
                  ErrMsg = "Operand: " + UCASE$(Ops(j)) + ", conflicts with " + TempValue: EXIT METHOD   '
               END IF                                             '
            NEXT j                                                '
            '--------------------------------------------------------------------------------------------+
            '- Test for overall limit requirements                                                       |
            '--------------------------------------------------------------------------------------------+
            VMax = MaxLit:  VGot = GotLit:  VType = " TEXT literals, ":    GOSUB VLimit   '
            VMax = MaxNum:  VGot = GotNum:  VType = " Numeric literals, ": GOSUB VLimit   '
            VMax = MaxTag:  VGot = GotTag:  VType = " Tag operands, ":     GOSUB VLimit   '
            VMax = MaxLPtr: VGot = GotLPtr: VType = " Line Pointers, ":    GOSUB VLimit   '
            VMax = MaxDotd: VGot = GotDotd: VType = " Line Referencess, ": GOSUB VLimit   '
            VMax = MaxAdj:  VGot = GotAdj:  VType = " Adjustment value, ": GOSUB VLimit   '
'-          FOR x = 1 TO Tbl.Count
'-             TBL.Entry(x, ItemName, varValue)
'-             debug LSET$(ItemName, 10)+"="+VARIANT$(varValue)
'-          NEXT x
'-          debug "---------------"
         END IF                                                   '

         IF (Phase AND %PAssign) THEN                             ' Do the Assign phase?
            '--------------------------------------------------------------------------------------+
            '- Time to stuff it all in the Criteria variables                                      |
            '--------------------------------------------------------------------------------------+
            '--------------------------------------------------------------------------------------+
            '- Start by resetting everything                                                       |
            '--------------------------------------------------------------------------------------+
            me.PTBLReset                                          ' Setup some defaults

            IF OpsNum = 0 AND ISFALSE (Flg.LRangeNum OR Flg.LRangeOK) THEN METHOD = 3: EXIT METHOD ' Nothing to process
            '--------------------------------------------------------------------------------------+
            '- See if one of the FIND/CHANGE command types, remember it                            |
            '--------------------------------------------------------------------------------------+
            t1 = UCASE$(LSET$(TP.CurrPCmd, 8))                    ' Make a temp fixed length field
            IF INSTR("CHANGE  C       CHA     CHG     RCHANGE F       FIND    " + _ '
                     "RFIND   NFIND   RNFIND  DELETE  DEL     NDELETE NDEL    " + _ '
                     "EXCLUDE EX      EXC     X       NEXCLUDENX      FLIP    " + _ '
                     "LABEL   LBL     LAB     X       NEXCLUDENX      FLIP    " + _ '
                     "NFLIP   SHOW    NSHOW   FF      ULINE   REVERT  NULINE  " + _ '
                     "NREVERT VV      UU      ", t1) <> 0 THEN FindChange = %True   '

            '--------------------------------------------------------------------------------------+
            '- Start with Cols operands                                                            |
            '--------------------------------------------------------------------------------------+

           IF Flg.ColsOK AND GotNum > 0 THEN                      ' Cols allowed?  And GotNum > 0
              ColFrom = VAL(TP.PTBL_.Pos("#", 1))                 ' No? Set this as FCol then
              FlgFCol = %True                                     ' Remember we saw it
              IF GotNum > 1 THEN                                  ' Another?
                 ColTo = VAL(TP.PTBL_.Pos("#", 2))                ' Yes, Set this as TCol then
                 IF ColTo < ColFrom THEN _                        ' Valid?
                    ErrMsg = "To Col: " + TP.PTBL_.Pos("#", 2) + " is not >= From Col: " + TP.PTBL_.Pos("#", 1): EXIT METHOD  '
                 FlgTCol = %True                                  ' Remember we saw it
              END IF                                              '
              IF GotNum > 2 THEN ErrMsg = "Extra numeric operand detected": EXIT METHOD   '
              GotNum = 0                                          ' Prevent re-use
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- If Line range allowed, do it now                                                    |
            '--------------------------------------------------------------------------------------+
            IF Flg.LRangeNum OR Flg.LRangeOK THEN                 ' Line Range allowed
               StrNum = 0                                         ' Reset located operand count

               IF Flg.LRangeNum THEN                              ' Numeric Line Range allowed
                  IF GotNum THEN                                  ' And we have some
                     SELECT CASE GotNum                           ' How many
                        CASE 1: StrStart = TP.PTBL_.Pos("#", 1): StrEnd = "": StrNum = 1  '
                        CASE 2: StrStart = TP.PTBL_.Pos("#", 1): StrEnd = TP.PTBL_.Pos("#", 2): StrNum = 2  '
                     END SELECT                                   '
                  END IF                                          '
               END IF                                             '

               IF Flg.LRangeOK THEN                               ' Line reference Range allowed
                  IF GotDotd THEN                                 ' And we have some
                     IF StrNum = 0 THEN                           ' And none found yet
                        SELECT CASE GotDotd                       ' How many
                           CASE 1: StrStart = TP.PTBL_.Pos(".", 1): StrEnd = "": StrNum = 1  '
                           CASE 2: StrStart = TP.PTBL_.Pos(".", 1): StrEnd = TP.PTBL_.Pos(".", 2): StrNum = 2  '
                        END SELECT                                '
                     ELSEIF StrNum = 1 THEN                       ' Got 1 already?
                        SELECT CASE GotDotd                       ' How many
                           CASE 1: StrEnd = TP.PTBL_.Pos(".", 1): INCR StrNum '
                           CASE 2: ErrMsg = "Excessive line pointers detected": EXIT METHOD  '
                        END SELECT                                '
                     ELSEIF StrNum = 2 THEN                       ' Got 2 already?
                           ErrMsg = "Excessive line pointers detected": EXIT METHOD '
                     END IF                                       '
                  END IF                                          '

                  IF GotLPtr THEN                                 ' We have some LPtrs
                     IF StrNum = 0 THEN                           ' And none found yet
                        SELECT CASE GotLPtr                       ' How many
                           CASE 1: StrStart = TP.PTBL_.Pos("!", 1): StrEnd = "": StrNum = 1  '
                           CASE 2: StrStart = TP.PTBL_.Pos("!", 1): StrEnd = TP.PTBL_.Pos("!", 2): StrNum = 2  '
                        END SELECT                                '
                     ELSEIF StrNum = 1 THEN                       ' Got 1 already?
                        SELECT CASE GotLPtr                       ' How many
                           CASE 1: StrEnd = TP.PTBL_.Pos("!", 1): INCR StrNum '
                           CASE 2: ErrMsg = "Excessive line pointers detected": EXIT METHOD  '
                        END SELECT                                '
                     ELSEIF StrNum = 2 THEN                       ' Got 2 already?
                           ErrMsg = "Excessive line pointers detected": EXIT METHOD '
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            IF ISNOTNULL(StrStart) AND ISNULL(StrEnd) THEN        ' Just one operand
               FindRngStart = TP.LineNoRef(StrStart)              ' Yes, set 1st as start
               IF FindRngStart = -1 THEN _                        ' An Oops?
                  ErrMsg = "Line reference " + StrStart + " is undefined": EXIT METHOD '
               FindRngEnd = 0                                     ' End = 0 to say not there
               FindRngSet = %True                                 ' Say we're OK
            ELSEIF ISNOTNULL(StrStart) AND ISNOTNULL(StrEnd) THEN ' Both?
               FindRngStart = TP.LineNoRef(StrStart)              ' Yes, set 1st as start
               IF FindRngStart = -1 THEN _                        ' An Oops?
                  ErrMsg = "Line reference " + StrStart + " is undefined": EXIT METHOD '
               FindRngEnd = TP.LineNoRef(StrEnd)                  ' Yes, set 2nd as end
               IF FindRngEnd = -1 THEN _                          ' An Oops?
                  ErrMsg = "Line reference " + StrEnd + " is undefined": EXIT METHOD   '
               IF FindRngStart > FindRngEnd THEN                  ' Look for the simple out of order swap
                  SWAP FindRngStart, FindRngEnd                   '
               END IF                                             '
               FindRngSet = %True                                 ' Say we're OK
            ELSEIF ISNULL(StrStart) AND ISNULL(StrEnd) THEN       ' If nothing scanned out aleady?
               IF ISTRUE gLTblRange THEN                          ' And a line range present
                  FindRngLCtl = TRIM$(gLTblSCmd)                  ' Save C / M line mode
                  FindRngStart = gLTblSFrom                       ' Something there set it up
                  FindRngEnd = gLTblSTo                           '
                  TP.TTblDel(gLTblSFrom)                          ' Remove from Touched lines
                  TP.UpdLControl(gLTblSFrom)                      ' Clear from the line
                  TP.TTblDel(gLTblSTo)                            ' Remove from Touched lines
                  TP.UpdLControl(gLTblSTo)                        ' Clear from the line
                  FindRngSet = %True                              '
                  FindRngFlag = gLTblSFlag                        '
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Handle tags now                                                                     |
            '--------------------------------------------------------------------------------------+
            IF GotTag = 1 THEN                                    ' A tag operand?
               FindRngSet = %True: FindRngTag = TP.PTBL_.Pos(":", 1) ' Save our answer
               IF LEFT$(FindRngTag, 2) = ":\" THEN                ' A NF request?
                  FindRngTNF = %True: FindRngTag = ":" + MID$(FindRngTag, 3)  ' Yes, set flag, remove \
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Now do Color operands                                                               |
            '--------------------------------------------------------------------------------------+
            t = TP.PTBL_.Grp("ClrSrchP")                          ' Get color search
            IF ISNOTNULL(t) THEN                                  ' A color search?
               ARRAY SCAN gHiLites(), COLLATE UCASE, = t, TO j    ' See if a HiLite Name
               HiLiteSrch = j                                     ' Save the color hilite index
               FlgHiClr = %True                                   ' Remember we saw it
            END IF                                                '

            t = TP.PTBL_.Grp("ClrSrchM")                          ' Get color search
            IF ISNOTNULL(t) THEN                                  ' A color search?
               t = CLIP$(LEFT, t, 1)                              ' Remove leading -
               ARRAY SCAN gHiLites(), COLLATE UCASE, = t, TO j    ' See if a HiLite Name
               HiLiteSrch = (0 - j)                               ' Negate and save the color hilite index
               FlgHiClr = %True                                   ' Remember we saw it
            END IF                                                '

            t = TP.PTBL_.Grp("ClrChngP")                          ' Get color change
            t1 = CLIP$(LEFT, t, 1)                                ' Remove the + -
            IF ISNOTNULL(t) THEN                                  ' A color search?
               ARRAY SCAN gHiLites(), COLLATE UCASE, = t1, TO j   ' See if a HiLite Name
               HiLiteOn = j                                       ' Save the color hilite number
               FlgHiOn = %True                                    ' Remember we saw it
            END IF                                                '

            t = TP.PTBL_.Grp("ClrChngM")                          ' Get color change
            t1 = CLIP$(LEFT, t, 1)                                ' Remove the + -
            IF ISNOTNULL(t) THEN                                  ' A color search?
               HiLiteOff = j                                      ' Save the color hilite number
               FlgHiOff = %True                                   ' Remember we saw it
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Now do the literals                                                                 |
            '--------------------------------------------------------------------------------------+
            IF Flg.L1OK AND GotLit > 0 THEN                       ' Literal1 allowed?
               t = TP.PTBL_.Pos("$", 1)                           ' Get the 1st literal
               L1Type = LEFT$(t, 1): t = MID$(t, 2)               ' Save the Optype and remove it
               IF ISNULL(t) THEN _                                ' No null search strings (yet)
                  ErrMsg = IIF$(Flg.L1FName, "Filename ", "Search literal ") + "may not be Null": EXIT METHOD  '
               IF L1Type = $OpPStr THEN                           ' Need to convert a Picture String?
                  IF Flg.L1FName THEN ErrMsg = "Filename may not be a Picture string": EXIT METHOD '
                  L1Raw = TP.PTBL_.Pos("$$", 1)                   ' Save Raw form
                  L1RData = t                                     ' Swap in the converted string
                  FlgLit1 = %True                                 ' Remember we saw it
                  FlgL1Picture = %True                            ' Remember it was a Picture string
                  '--------------------------------------------------------------------------------+
                  '- Fudge the [ and ] characters                                                  |
                  '--------------------------------------------------------------------------------+
                  IF L1RData = "[]" OR L1RData = "[" OR L1RData = "]" OR _ ' Invalid string
                     L1RData = "{}" OR L1RData = "{" OR L1RData = "}" THEN _  '
                     ErrMsg = L1RData + " is an invalid Left/Right boundary literal": EXIT METHOD  '
                  IF LEFT$(L1RData, 1) = "{" THEN FlgLM = %True   ' If we have a { modifier, set LM
                  IF RIGHT$(L1RData, 1) = "}" THEN FlgRM = %True  ' If we have a } modifier, set RM

                  IF LEFT$(L1RData, 1) = "[" THEN                 ' If we have a [ modifier
                     L1RData = MID$(L1RData, 2)                   ' Strip off the [
                     FlgLM = %True                                ' Set the LM flag
                  END IF                                          '

                  IF RIGHT$(L1RData, 1) = "]" THEN                ' Got a ] ?
                     IF MID$(L1RData, LEN(L1RData) - 1, 1) <> "\" THEN  ' If we have an unescaped ] modifier
                        L1RData = CLIP$(RIGHT,L1RData, 1)         ' Strip off the ]
                        FlgRM = %True                             ' Set the RM flag
                     END IF                                       '
                     j = INSTR(L1RData, "\")                      ' Handle escaped chars
                     DO WHILE j                                   '
                        IF MID$(L1RData, j + 1, 1) = "[" OR _     ' Trailing [ ]
                           MID$(L1RData, j + 1, 1) = "]" THEN     '
                           L1RData = LEFT$(L1RData, j - 1) + MID$(L1RData, j + 1)   '
                        END IF                                    '
                        j = INSTR(j + 1, L1RData, "\")            ' Continue scan
                     LOOP                                         '
                  END IF                                          '
                  L1Len = LEN(L1RData)                            '

               ELSEIF L1Type = $OpXStr THEN                       ' Need to convert a Hex String?
                  IF Flg.L1FName THEN ErrMsg = "Filename may not be a Hex string": EXIT METHOD  '
                  L1Raw = TP.PTBL_.Pos("$$", 1)                   ' Save Raw form
                  iRx = t                                         ' Copy to work field
                  GOSUB iRxHex                                    ' Go convert it
                  L1RData = rx                                    ' Swap in the converted string
                  L1Len = LEN(L1RData)                            '
                  FlgLit1 = %True                                 ' Remember we saw it
                  FlgL1Hex = %True                                ' Remember it was a Hex string

               ELSEIF L1Type = $OpRStr THEN                       ' Need to handle a RegEx String?
                  IF Flg.L1FName THEN ErrMsg = "Filename may not be a RegEx expression": EXIT METHOD  '
                  L1Raw = TP.PTBL_.Pos("$$", 1)                   ' Save Raw form
                  t = PCRERegexCompile(t)                         ' Let pcre_compile test the string
                  IF ISNOTNULL(t) THEN _                          ' We get an error message back?
                     ErrMsg = "Regex error " + t: EXIT METHOD     '
                  L1RData = MID$(TP.PTBL_.Pos("$", 1), 2)         ' Save it
                  L1Len = LEN(L1RData)                            '
                  FlgLit1 = %True                                 ' Remember we saw it
                  FlgL1RegEx = %True                              ' Remember it was a RegEx

                  '-------------------------------------------------------------------------------+
                  '- Fudge the line start/end characters                                          |
                  '-------------------------------------------------------------------------------+
                  IF LEFT$(L1RData, 1) = "^" THEN                 ' If we have a ^ modifier
                     FlgLM = %True                                ' Set the LM flag
                  END IF                                          '
                  IF RIGHT$(L1RData, 1) = "$" THEN                ' Got a $ ?
                     IF MID$(L1RData, LEN(L1RData) - 1, 1) <> "\" THEN  ' If we have an unescaped $ modifier
                        FlgRM = %True                             ' Set the RM flag
                     END IF                                       '
                  END IF                                          '

               ELSEIF L1Type = $OpCStr THEN                       ' C'...' type literal (Case sensitive)
                  IF Flg.L1FName THEN ErrMsg = "Filename may not be a Case sensitive string": EXIT METHOD   '
                  L1Raw = TP.PTBL_.Pos("$$", 1)                   ' Save Raw form
                  L1RData = t                                     ' Save also as processed data
                  L1Len = LEN(L1RData)                            '
                  FlgLit1 = %True                                 ' Remember we saw it
                  FlgL1CaseComp = %True                           ' Remember it was a Case sensitive

               ELSEIF L1Type = $OpDStr THEN                       ' D'...' type literal (DLM type)
                  IF Flg.L1FName THEN ErrMsg = "Filename may not be a Delimited string": EXIT METHOD  '
                  L1Raw = TP.PTBL_.Pos("$$", 1)                   ' Save Raw form
                  iRx = t                                         ' Copy to work field
                  GOSUB iDLMPreTest                               ' Go pre-process / verify it / convert it
                  L1RData = Rx                                    ' Save also as processed data
                  L1Len = LEN(L1RData)                            '
                  FlgLit1 = %True                                 ' Remember we saw it
                  FlgL1DLM = %True                                ' Remember it was a DLM Type
                  IF TP.FCB_.CaseFlag = "C" THEN FlgL1CaseComp = %True  ' Set CASE properly

               ELSEIF L1Type = $OpTStr THEN                       ' T'...' type literal (Case IN sensitive)
                  IF Flg.L1FName THEN ErrMsg = "Filename may not be a Text string": EXIT METHOD '
                  L1Raw = TP.PTBL_.Pos("$$", 1)                   ' Save Raw form
                  L1RData = t                                     ' Save also as processed data
                  L1Len = LEN(L1RData)                            '
                  FlgLit1 = %True                                 ' Remember we saw it
                  FlgL1CaseInComp = %True                         ' Remember it was a Case in sensitive

               ELSEIF L1Type = $OpFStr THEN                       ' F'...' type literal (Format string)
                  ErrMsg = "Search literal may not use F'xxx' type literal - ": EXIT METHOD  '

               ELSE                                               ' Everything else
                  L1Raw = TP.PTBL_.Pos("$$", 1)                   ' Save Raw form
                  L1RData = t                                     ' Save Processed data
                  L1Len = LEN(L1RData)                            '
                  IF TP.FCB_.CaseFlag = "C" THEN FlgL1CaseComp = %True  ' Set the comarison default
                  IF TP.FCB_.CaseFlag = "T" THEN FlgL1CaseInComp = %True   '
                  FlgLit1 = %True                                 ' Remember we saw it
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Handle L2 if possible                                                               |
            '--------------------------------------------------------------------------------------+
            IF Flg.L2OK AND GotLit > 1 THEN                       ' Literal2 allowed and is present?
               t = TP.PTBL_.Pos("$", 2)                           ' Get the value
               L2Type = LEFT$(t, 1): t = MID$(t, 2)               ' Save the Optype and remove it
               IF L2Type = $OpPStr THEN                           ' Need to convert a Picture String?
                  L2Raw = TP.PTBL_.Pos("$$", 2)                   ' Save Raw form
                  L2RData = t                                     ' Swap in the converted string
                  FlgLit2 = %True                                 ' Remember we saw it
                  FlgL2Picture = %True                            ' Remember it was a Picture string
                  GOSUB FudgeSplit                                ' Fudge out the | split character
                  GOSUB FudgeUCLC                                 ' Fudge out the !< and !>  character
                  IF LEN(L1RData) < TALLY(L2RData, ANY "=<>~") THEN _   ' Picture literals have to be the same length
                     ErrMsg = "CHANGE chars =<>~ greater than Find picture length": EXIT METHOD '
                  IF LEN(L2RData) > LEN(L1RData) THEN             ' If change string longer than search string
                     IF INSTR(MID$(L2RData, LEN(L1RData) + 1), ANY "=<>~") THEN _   ' Special chars past the end?
                        ErrMsg = "CHANGE chars =<>~ appear past the length of the Find string": EXIT METHOD '
                  END IF                                          '
                  IF ISTRUE INSTR(L2RData, "{") AND ISFALSE INSTR(L1RData, "{") THEN _ ' If change has {, then find must have {
                     ErrMsg = "CHANGE string has {, FIND string must also have {": EXIT METHOD  '
                  IF ISTRUE INSTR(L2RData, "}") AND ISFALSE INSTR(L1RData, "}") THEN _ ' If change has }, then find must have }
                     ErrMsg = "CHANGE string has }, FIND string must also have }": EXIT METHOD  '
                  L2Len = LEN(L2RData)                            '

               ELSEIF L2Type = $OpFStr THEN                       ' Need to convert a Format String?
                  IF LEN(L1RData) < TALLY(TP.PTBL_.Pos("$", 2), ANY "=<>~") THEN _  ' Picture literals have to be the same length
                     ErrMsg = "CHANGE chars =<> greater than Find picture length": EXIT METHOD  '
                  L2Raw = TP.PTBL_.Pos("$$", 2)                   ' Save Raw form
                  L2RData = t                                     ' And the string
                  L2Len = LEN(L2RData)                            '
                  FlgLit2 = %True                                 ' Remember we saw it
                  FlgL2Format = %True                             ' Remember it was a Picture string
                  GOSUB FudgeSplit                                ' Fudge out the | split character
                  GOSUB FudgeUCLC                                 ' Fudge out the !< and !>  character

               ELSEIF L2Type = $OpXStr THEN                       ' Need to convert a Hex String?
                  iRx = t                                         ' Copy to work field
                  GOSUB iRxHex                                    ' Go convert it
                  L2Raw = TP.PTBL_.Pos("$$", 2)                   ' Save Raw form
                  L2RData = rx                                    ' Swap in the converted string
                  L2Len = LEN(L2RData)                            '
                  FlgLit2 = %True                                 ' Remember we saw it
                  FlgL2Hex = %True                                ' Remember it was a Hex string

               ELSEIF L2Type = $OpCStr THEN                       ' C'...' type literal (Case sensitive)
                  L2Raw = TP.PTBL_.Pos("$$", 2)                   ' Save Raw form
                  L2RData = t                                     ' Save as converted string
                  L2Len = LEN(L2RData)                            '
                  FlgLit2 = %True                                 ' Remember we saw it
                  FlgL2CaseComp = %True                           ' Remember it was a Case sensitive

               ELSEIF L2Type = $OpTStr THEN                       ' T'...' type literal (Case IN sensitive)
                  L2Raw = TP.PTBL_.Pos("$$", 2)                   ' Save Raw form
                  L2RData = t                                     ' Save as converted string
                  L2Len = LEN(L2RData)                            '
                  FlgLit2 = %True                                 ' Remember we saw it
                  FlgL2CaseInComp = %True                         ' Remember it was a Case in sensitive

               ELSE                                               ' Everything else
                  L2Raw = TP.PTBL_.Pos("$$", 2)                   ' Save Raw form
                  L2RData = t                                     ' Save as converted string
                  L2Len = LEN(L2RData)                            '
                  FlgLit2 = %True                                 ' Remember we saw it
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Handle all the Kwd entries                                                          |
            '--------------------------------------------------------------------------------------+
            FlgFirst    = me.IsKwd("First"):          FlgCS       = me.IsKwd("CS")  '
            FlgLast     = me.IsKwd("Last"):           FlgQuoted   = me.IsKwd("Q")   '
            FlgNext     = me.IsKwd("Next"):           FlgNF       = me.IsKwd("NF")  '
            FlgPrev     = me.IsKwd("Prev"):           FlgON       = me.IsKwd("On")  '
            FlgAll      = me.IsKwd("All"):            FlgOFF      = me.IsKwd("Off") '
            FlgChars    = me.IsKwd("Char"):           FlgText     = me.IsKwd("T")   '
            FlgPrefix   = me.IsKwd("Prefix"):         FlgToggle   = me.IsKwd("Toggle") '
            FlgSuffix   = me.IsKwd("Suffix")                      '
            FlgWord     = me.IsKwd("Word"):           FlgSet      = me.IsKwd("Set") '
            FlgLeft     = me.IsKwd("Left"):           FlgL2TRUNC  = me.IsKwd("Trunc")  '
            FlgRight    = me.IsKwd("Right"):          FlgStd      = me.IsKwd("Std") '
            FlgMStd     = me.IsKwd("-Std"):           FlgPStd     = me.IsKwd("+Std")   '
            FlgTop      = me.IsKwd("Top"):            FlgSolid    = me.IsKwd("Solid")  '
                                                                  ' FlgChange   = me.IsKwd("Change")
            FlgMSolid   = me.IsKwd("-Solid"):         FlgDS       = me.IsKwd("DS")  '
            FlgMX       = me.IsKwd("MX"):             FlgMax      = me.IsKwd("Max") '
            FlgDX       = me.IsKwd("DX"):             FlgComment  = me.IsKwd("C")   '
            '--------------------------------------------------------------------------------------+
            '- Handle the items using RangeVal for testing                                         |
            '--------------------------------------------------------------------------------------+
            IF me.IsKwd("X")  THEN FlgX  = %True: FindRngSet = %True '
            IF me.IsKwd("NX") THEN FlgNX = %True: FindRngSet = %True '
            IF me.IsKwd("U")  THEN FlgU  = %True: FindRngSet = %True '
            IF me.IsKwd("NU") THEN FlgNU = %True: FindRngSet = %True '
            '--------------------------------------------------------------------------------------+
            '- Handle global overrides if no specific requests for CS/DS and WORD/CHAR             |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE FlgCS AND ISFALSE FlgDS THEN               ' Neither CS nor DS?
               IF TP.FCB_.ChangeMode = "C" THEN FlgCS = %True     ' Then use the Profile value
               IF TP.FCB_.ChangeMode = "D" THEN FlgDS = %True     '
            END IF                                                '
            IF ISFALSE FlgWord AND ISFALSE FlgChars AND ISFALSE FlgPrefix AND ISFALSE FlgSuffix AND _ '
               ISTRUE FindChange AND ISTRUE FlgLit1 THEN          ' Have we seen Literal1 and no Word/Chars default?
               IF TP.FindWord THEN FlgWord = %True                ' Set based on FindWord
            END IF                                                '
            '--------------------------------------------------------------------------------------+
            '- Now check for Conflicts between KW and other operands                               |
            '--------------------------------------------------------------------------------------+
            IF (FlgDX OR FlgMX) AND IsTPHideFlag AND ISFALSE FlgAll THEN _ '
               ErrMsg = "HIDE mode and DX/MX require ALL keyword as well": EXIT METHOD '

            IF (FlgLeft OR FlgRight) AND FlgL1RegEx THEN _        '
               ErrMsg = "LEFT/RIGHT cannot be used with RegEX literals": EXIT METHOD   '

            IF (FlgComment OR FlgQuoted OR FlgText) THEN          ' Any CQT entered?
               IF ISFALSE TP.FCB_.HiAuto OR ISFALSE IsTPClrFlag THEN ' If colorization not possible, kill these
                  t = SWITCH$(FlgComment, "C", FlgQuoted, "Q", FlgText,  "T") '
                  ErrMsg = t + " operand requires Colorization to be active": EXIT METHOD '
               END IF                                             '
            END IF                                                '

            i = 0                                                 ' Count special operands
            IF FlgComment     THEN INCR i                         '
            IF FlgQuoted      THEN INCR i                         '
            IF FlgText        THEN INCR i                         '
            IF i = 3 THEN _                                       ' If ridiculous
               ErrMsg = "Using all qualifiers C Q and T on one command is disallowed": EXIT METHOD '

            IF FlgLM AND (FlgFCol OR FlgTCol) THEN _              '
               ErrMsg = "LM or [ Left bound in Picture cannot be used with column operands": EXIT METHOD '

            IF FlgRM AND (FlgFCol OR FlgTCol) THEN _              '
               ErrMsg = "RM or ] Right bound in Picture cannot be used with column operands": EXIT METHOD   '

            '--------------------------------------------------------------------------------------+
            '- Verify all the color operands                                                       |
            '--------------------------------------------------------------------------------------+
            IF FlgHiOn AND FlgHiOff THEN _                        ' Both adding and removing colors?
               ErrMsg = "Cannot specify both positive and negative color changes": EXIT METHOD  '

            '--------------------------------------------------------------------------------------+
            '- See if maybe global BNDS should be applied                                          |
            '--------------------------------------------------------------------------------------+
            IF Flg.ColsOK AND FlgLit1 THEN                        ' If Cols are allowed and we have a literal
               IF ISFALSE FlgFCol THEN                            ' And no column operand specified
                  IF TP.FCB_.BndLeft > 1 OR TP.FCB_.BndRight > 0 THEN   ' And Global BNDS are active
                     FlgFCol = %True: FlgTCol = %True             ' Inherit the global bounds
                     ColFrom = TP.FCB_.BndLeft: ColTo = TP.FCB_.BndRight   '
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- See if Find / Change operands of * detected                                         |
            '--------------------------------------------------------------------------------------+
            IF L1RData  = "*" AND L1Type <> $OpQStr AND ISFALSE FlgL1Picture THEN   ' Request for previous search?
               IF RFlgLit1 THEN                                   ' Is there one?
                  L1Raw             = RL1Raw                      '
                  L1RData           = RL1RData                    '
                  L1Len             = RL1Len                      '
                  SplitPoint1       = RSplitPoint1                '
                  SplitPoint2       = RSplitPoint2                '
                  FlgLit1           = RFlgLit1                    '
                  FlgL1Picture      = RFlgL1Picture               '
                  FlgL1Hex          = RFlgL1Hex                   '
                  FlgL1RegEx        = RFlgL1RegEx                 '
                  FlgL1CaseComp     = RFlgL1CaseComp              '
                  FlgL1CaseInComp   = RFlgL1CaseInComp            '
               ELSE                                               '
                  ErrMsg = "No previous Find string available": EXIT METHOD   '
               END IF                                             '
            END IF                                                '

            IF L2RData = "*" AND L2Type <> $OpQStr THEN           ' Request for previous change?
               IF RFlgLit2 THEN                                   ' Is there one?
                  L2Raw           = RL2Raw                        ' Copy previous change stuff
                  L2RData         = RL2RData                      '
                  L2Len           = RL2Len                        '
                  FlgLit2         = RFlgLit2                      '
                  FlgL2Hex        = RFlgL2Hex                     '
                  FlgL2CaseComp   = RFlgL2CaseComp                '
                  FlgL2CaseInComp = RFlgL2CaseInComp              '
               ELSE                                               '
                  ErrMsg = "No previous Change string available": EXIT METHOD '
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Now save PTBL area if this version has a FindStr                                    |
            '--------------------------------------------------------------------------------------+
            IF ISNOTNULL(L1RData) AND ISFALSE Flg.L1FName THEN    ' Save it
               RL1Raw             = L1Raw                         '
               RL1RData           = L1RData                       '
               RL1Len             = L1Len                         '
               RSplitPoint1       = SplitPoint1                   '
               RSplitPoint2       = SplitPoint2                   '
               RFlgLit1           = FlgLit1                       '
               RFlgL1Picture      = FlgL1Picture                  '
               RFlgL1Hex          = FlgL1Hex                      '
               RFlgL1RegEx        = FlgL1RegEx                    '
               RFlgL1CaseComp     = FlgL1CaseComp                 '
               RFlgL1CaseInComp   = FlgL1CaseInComp               '
               RL2Raw             = L2Raw                         '
               RL2RData           = L2RData                       '
               RL2Len             = L2Len                         '
               RFlgLit2           = FlgLit2                       '
               RFlgL2Hex          = FlgL2Hex                      '
               RFlgL2CaseComp     = FlgL2CaseComp                 '
               RFlgL2CaseInComp   = FlgL2CaseInComp               '
            END IF                                                '
'-        FOR x = 1 TO Tbl.Count
'-           TBL.Entry(x, ItemName, varValue)
'-           debug LSET$(ItemName, 10)+"="+VARIANT$(varValue)
'-        NEXT x
'-        debug "---------------"
      END IF                                                      '
      METHOD = 3                                                  ' Set OK Exit
      EXIT METHOD                                                 '
      '--------------------------------------------------------------------------------------------+
      '- Pre-Process a DLM type literal                                                            |
      '--------------------------------------------------------------------------------------------+
      iDLMPreTest:                                                '
         Rx = "": GotBar = %False                                 ' Start answer as Null
         IF iRx = "|" THEN _                                      ' Just a DLM bar?
            ErrMsg = "'D' type literal has no Prefix or Suffix string": EXIT METHOD '
         FOR D1 = 1 TO LEN(iRx)                                   ' Loop through D-string
            SELECT CASE AS MID$(iRx, D1, 1)                       ' Examine each character
               CASE "\"                                           ' escape char?
                  IF MID$(iRx, D1 + 1, 1) = "\" THEN              ' Next char another "\"
                     Rx += "\": INCR D1: ITERATE FOR              ' Insert one "\", step over the pair, loop back
                  ELSEIF MID$(iRx, D1 + 1, 1) = "|" THEN          ' Escaped "|"?
                     Rx += "|": INCR D1: ITERATE FOR              ' Insert one "|", step over the pair, loop back
                  ELSE                                            ' Not escaped \ or |
                     Rx += "\": ITERATE FOR                       ' Treat as a normal character then
                  END IF                                          '
               CASE "|"                                           ' Separator Bar?
                  IF GotBar THEN _                                ' Seen it already?
                     ErrMsg = "Multiple | character in a 'D' type literal": EXIT METHOD   '
                  GotBar = %True: Rx += CHR$(0)                   ' Add split marker to the string
               CASE ELSE                                          '
                  Rx += MID$(iRx, D1, 1)                          ' Copy everything else
            END SELECT                                            '
         NEXT D1                                                  '
         IF ISFALSE GotBar THEN _                                 ' Seen the DLM?
            ErrMsg = "'D' type literal has no delimiter '|'": EXIT METHOD  '
         '-----------------------------------------------------------------------------------------+
         '- Let DML_Search get it ready                                                            |
         '-----------------------------------------------------------------------------------------+
         IF TP.FCB_.CaseFlag = "T" THEN rx = uucase(rx)           ' Set CASE properly
         TP.DLMSearch(Rx)                                         ' Call search routine
         RETURN                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Process a possible HEX operand                                                            |
      '--------------------------------------------------------------------------------------------+
      iRxHex:                                                     '
         iRx = UCASE$(iRx)                                        ' Uppercase it
         IF (LEN(iRx) MOD 2) = 1 THEN _                           ' Better be even # chars
            ErrMsg = "Invalid Hex literal length": EXIT METHOD    '
         IF VERIFY(iRx, $Hex) <> 0 THEN _                         ' All valid Hex chars?
            ErrMsg = "Restricted character in Hex literal": EXIT METHOD '
         rx = ""                                                  ' Convert to hex
         FOR j = 1 TO LEN(iRx) STEP 2                             '
            rx += CHR$(VAL("&H" + MID$(iRx, j, 2)))               '
         NEXT j                                                   '
         IF TP.FCB_.SrceXlate THEN TP.Translate(rx, TP.FCB_.GetSS2APtr) ' Translate SOURCE to ANSI
         RETURN                                                   '

      FudgeSplit:                                                 '
         '-----------------------------------------------------------------------------------------+
         '- Fudge the | split character                                                            |
         '-----------------------------------------------------------------------------------------+
         IF FindChange THEN RETURN                                ' Ignore for normal F/C operands
         j = INSTR(L2RData, "|")                                  ' Any | characters?
         DO WHILE j                                               ' Process the | characters
            IF j = 1 OR MID$(L2RData, j - 1, 1) <> "\" THEN       ' We have an unescaped | char.
               IF SplitPoint2 <> 0 THEN _                         ' Oops, already have a Split Point
                  ErrMsg = "Multiple | SPLIT points present": EXIT METHOD  '
               SplitPoint2 = j                                    ' Save it
               L2RData = LEFT$(L2RData, j - 1) + MID$(L2RData, j + 1)   ' Shrink the literal
            END IF                                                '
            j = INSTR(j + 1, L2RData, "|")                        ' Any MORE | characters?
         LOOP                                                     '
         j = INSTR(L2RData, "\")                                  ' Handle escaped chars
         DO WHILE j                                               '
            IF MID$(L2RData, j + 1, 1) = "|" THEN                 ' Trailing |
               L2RData = LEFT$(L2RData, j - 1) + MID$(L2RData, j + 1)   '
               IF j < SplitPoint2 THEN SplitPoint2 = SplitPoint2 - 1 '
            END IF                                                '
            j = INSTR(j + 1, L2RData, "\")                        ' Continue scan
         LOOP                                                     '
         RETURN                                                   '

      FudgeUCLC:                                                  '
         '-----------------------------------------------------------------------------------------+
         '- Fudge the UC/LC escaped versions into   characters                                   |
         '-----------------------------------------------------------------------------------------+
         j = INSTR(L2RData, "!")                                  ' Any ! characters?
         DO WHILE j                                               ' Process the ! characters
            IF j = 1 OR MID$(L2RData, j - 1, 1) <> "\" THEN       ' We have an unescaped ! char.
               IF MID$(L2RData, j + 1, 1) = "<" THEN _            ' A lowercase request
                  L2RData = LEFT$(L2RData, j - 1) + "" + MID$(L2RData, j + 2)   ' Shrink the literal
               IF MID$(L2RData, j + 1, 1) = ">" THEN _            ' An uppercase request
                  L2RData = LEFT$(L2RData, j - 1) + "" + MID$(L2RData, j + 2)   ' Shrink the literal
               IF MID$(L2RData, j + 1, 1) = "=" THEN _            ' A sort-of escaped version
                  L2RData = LEFT$(L2RData, j) + MID$(L2RData, j + 2) ' Shrink the literal
            END IF                                                '
            j = INSTR(j + 1, L2RData, "!")                        ' Any MORE ! characters?
         LOOP                                                     '
         RETURN                                                   '

         vLimit:                                                  '
         IF (VMax AND %Arg_Var) THEN RETURN                       ' If VAR specified, anything is fine
         tv = VMax AND &H00FFFFFF                                 ' Get value without flag bits
         IF tv > 0 THEN                                           ' Something is wanted
            IF (VMax AND %Arg_Opt) THEN                           ' If OPT specified, must be equal or zero
               IF VGot <> tv AND VGot <> 0 THEN                   '
                  ErrMsg = "Command requires 0 or " + FORMAT$(tv) + VType +  FORMAT$(vGot) + IIF$(vGot = 1, " was ", " were ") + "entered": EXIT METHOD  '
               END IF                                             '
            ELSE                                                  '
               IF vGot <> tv THEN                                 '
                  ErrMsg = "Command requires " + FORMAT$(tv) + VType +  FORMAT$(VGot) + IIF$(VGot = 1, " was ", " were ") + "entered": EXIT METHOD '
               END IF                                             '
            END IF                                                '
         END IF                                                   '
         RETURN                                                   '

         DoQStr:                                                  '
            dlm1 = MID$(t, q1, 1)                                 ' Get LH quote possibility
            dlm2 = MID$(t, q2, 1)                                 ' Get RH quote possibility
            IF INSTR($Quotes, Dlm1) <> 0 THEN                     ' Got leading quote?
               IF dlm1 = dlm2 THEN                                ' and same ending quotes
                  IF qt = 0 THEN                                  ' Simple quoted str?
                     t = $OpQStr + MID$(t, q1 + 1 TO q2 - 1)      ' Extract between quotes
                  ELSE                                            '
                     p = UCASE$(MID$(t, qt, 1))                   ' Pick up type character
                     IF INSTR("CPRXTFD", p) THEN                  ' A C"xx", P'xx', R'xx' X'xx' T'xx', F'xx', or D'xx'  type?
                        t = p + MID$(t, q1 + 1 TO q2 - 1)         '
                     ELSE                                         '
                        ErrMsg = "Unknown literal type code in Operand #" + FORMAT$(j): EXIT METHOD  ' Issue error
                     END IF                                       '
                  END IF                                          '
                  IF INSTR(t, dlm1) THEN ErrMsg = "Extraneous quotes detected in Operand #" + FORMAT$(j): EXIT METHOD
               END IF                                             '
            END IF                                                '
         RETURN                                                   '
      END METHOD                                                  '
   END INTERFACE                                                  '
END CLASS                                                         '
