'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'--------------------------------------------------------------------------------------------------+
#COMPILE EXE "D:\SPFLite3\CFGMaint.EXE"
#DIM ALL
#DEBUG DISPLAY OFF
#DEBUG ERROR OFF
#TOOLS OFF
#OPTIMIZE CODE ON
#RESOURCE ICON, a, "..\Resource File\SPFLite3.ICO"


#INCLUDE ONCE "Win32Api.inc"                                      ' Windows standard stuff
#INCLUDE ONCE "WTypes.inc"                                        '
#INCLUDE ONCE "ShlObj.inc"                                        '
#INCLUDE ONCE "Macros.inc"                                        ' Get SPFLite macros
#INCLUDE ONCE "Types.inc"                                         ' SPFLite Types, equates
#INCLUDE      "ObjSQL.inc"                                        ' SPFLite SQLite access Object
#INCLUDE      "ObjKwd.inc"                                        ' SPFLite Keywords Object
#INCLUDE      "PCRE.inc"                                          ' PCRE Regex stuff
#INCLUDE      "CFGVersion.inc"                                    ' Our Version Info

'--------------------------------------------------------------------------------------------------+
'- SQLite declares                                                ' Declares FOR real SQLite DLL   |
'--------------------------------------------------------------------------------------------------+
DECLARE SUB FREE CDECL LIB "msvcrt.dll" ALIAS "free" (BYVAL DWORD)
DECLARE FUNCTION sqlite3_open      CDECL LIB "sqlite3.dll" ALIAS _
                "sqlite3_open" (zFilename AS ASCIIZ, hDB AS LONG) AS LONG
DECLARE FUNCTION sqlite3_open16    CDECL LIB "sqlite3.dll" ALIAS _
                "sqlite3_open16" (zFilename AS ASCIIZ, hDB AS LONG) AS LONG
DECLARE SUB      sqlite3_close     CDECL LIB "sqlite3.dll" ALIAS _
                "sqlite3_close" (BYVAL hDB AS LONG)
DECLARE FUNCTION sqlite_get_table  CDECL LIB "sqlite3.dll" ALIAS _
                "sqlite3_get_table" (BYVAL hDB AS LONG, szSql AS ASCIIZ, _
                                     lpTable AS LONG, nRow AS LONG, nColumn AS LONG, lpErrMsg AS LONG) AS LONG
DECLARE FUNCTION sqlite_free_table CDECL LIB "sqlite3.dll" ALIAS _
                "sqlite3_free_table" (BYVAL lpTable AS LONG PTR) AS LONG
DECLARE FUNCTION sqlite3_errmsg    CDECL LIB "sqlite3.dll" ALIAS _
                "sqlite3_errmsg" (BYVAL hDB AS LONG) AS LONG

'--------------------------------------------------------------------------------------------------+
'- MyMsgBox Equates                                                                                |
'--------------------------------------------------------------------------------------------------+
ENUM MyMsgBox_equates SINGULAR
    MMB_Dlg = 9800
    MMB_Msg              ' Return Codes
    MMB_OK               '  1  %IDOK
    MMB_Cancel           '  2  %IDCANCEL
    MMB_Abort            '  3  %IDABORT
    MMB_Retry            '  4  %IDRETRY
    MMB_Ignore           '  5  %IDIGNORE
    MMB_Yes              '  6  %IDYES
    MMB_No               '  7  %IDNO
    MMB_TryAgain         ' 10  %IDTRYAGAIN
    MMB_Continue         ' 11  %IDCONTINUE
    MMB_Icon
    MMB_WOpen
    MMB_Open

END ENUM
%MB_WOpenOpenCancel      = &H00000007                             ' Private type for MyMsgBox

TYPE WININFOTYPE                                                  ' For searching window titles
    WinTitle AS STRING * 256
    WinHandle AS LONG
END TYPE

#UTILITY DEBUG OFF
ASMDATA Cmpi_tbl
   DB   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15
   DB  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31
   DB  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47
   DB  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63
   DB  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79
   DB  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95
   DB  96,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79
   DB  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90, 123, 124, 125, 126, 127
   DB 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143
   DB 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 138, 155, 140, 157, 142, 159
   DB 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175
   DB 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191
   DB 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207
   DB 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223
   DB 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207
   DB 208, 209, 210, 211, 212, 213, 214, 247, 216, 217, 218, 219, 220, 221, 222, 159
END ASMDATA

'--------------------------------------------------------------------------------------------------+
'- Global Data                                                                                     |
'--------------------------------------------------------------------------------------------------+
GLOBAL Keys()                   AS STRING                         ' Keyboard Key Names
GLOBAL lclK                     AS KwdEnt                         ' Local copy of Kwd table entry
GLOBAL LogEnt()                 AS STRING                         ' LOG file entries
GLOBAL LogEntCtr                AS LONG                           ' Number of entries
GLOBAL IP()                     AS STRING                         ' To hold data extracted from an SQLite table
GLOBAL IPCtr                    AS LONG                           ' Number of entries currently in IP()
GLOBAL IPName                   AS STRING                         ' Name of the table from which IP() was loaded
GLOBAL DBTables()               AS STRING                         ' Names of Tables in the CFG file
GLOBAL DBCtr                    AS LONG                           ' No. of entries in DBTables
GLOBAL ImpFixed                 AS LONG                           ' Import fix count
GLOBAL gFMProp()                AS STRING                         ' FM File Properties supported
GLOBAL gFMPropNum               AS LONG                           ' Number of FM File Properties

'--------------------------------------------------------------------------------------------------+
'- Where Files live                                                                                |
'--------------------------------------------------------------------------------------------------+
GLOBAL RoamHome                 AS STRING                         ' Location of Roaming home
GLOBAL HomeData                 AS STRING                         ' Location of the SPFLite data folder
GLOBAL HomeFolder               AS STRING                         ' Location of the SPFLite CFG file folder
GLOBAL HomeLog                  AS STRING                         ' Location of the CFG Log File

'--------------------------------------------------------------------------------------------------+
'- External / Log file handling                                                                    |
'--------------------------------------------------------------------------------------------------+
GLOBAL FN                       AS LONG                           ' Export / Import file
GLOBAL FName                    AS STRING                         '
GLOBAL lFN                      AS LONG                           ' LOG file
GLOBAL lFName                   AS STRING                         '

'--------------------------------------------------------------------------------------------------+
'- For performing a Window search                                                                  |
'--------------------------------------------------------------------------------------------------+
GLOBAL gWinList()               AS WININFOTYPE
GLOBAL gWinListPos              AS LONG

'--------------------------------------------------------------------------------------------------+
'- RegEx areas                                                                                     |
'--------------------------------------------------------------------------------------------------+
GLOBAL PCRE_Regex_Str2     AS STRING                              ' String to build pseudo ASCIIZ string
GLOBAL PCRE_ErrPtr         AS ASCIIZ PTR                          ' Pointer to pcre_compile error message string
GLOBAL PCRE_ErrOffsetPtr   AS DWORD                               ' Pointer to offset in Regex string where error was detected
GLOBAL PCRE_Options        AS LONG                                ' Options passed to pcre
GLOBAL PCRE_Offsets()      AS LONG                                ' Table of offsets to located strings
GLOBAL hLib_PCRE           AS LONG                                ' Handle of PCRE3.dll library
GLOBAL hProc_PCRE_Compile  AS LONG                                ' Handle to Compile function
GLOBAL hProc_PCRE_Exec     AS LONG                                ' Handle to Exec function
GLOBAL hProc_PCRE_Free     AS LONG                                ' Handle to Free function
GLOBAL hProc_PCRE_Free_Ptr AS LONG                                ' Handle to Real Free function
GLOBAL hPCRE               AS DWORD                               '

'--------------------------------------------------------------------------------------------------+
'- Misc Globals                                                                                    |
'--------------------------------------------------------------------------------------------------+
GLOBAL approvedlocation         AS LONG                           ' For path searching
GLOBAL approvedpath             AS ASCIIZ * %MAX_PATH             '
GLOBAL PgmVers                  AS STRING                         ' EXE version
GLOBAL TimeStamp                AS STRING                         '
GLOBAL PExpName                 AS STRING                         ' -EXPORT tablename
GLOBAL PImpName                 AS STRING                         ' -IMPORT filename
GLOBAL KeepLog                  AS LONG                           ' Keep the LOG file
GLOBAL Pass                     AS LONG                           ' Pass number
GLOBAL PMode                    AS LONG                           ' Command line stuff
%PExport    = &H00000001                                          '
%PImport    = &H00000002                                          '
%PRepair    = &H00000004                                          '
%PQuiet     = &H00000008                                          '
%PExpColor  = &H00000010                                          '
%PImpColor  = &H00000020                                          '
GLOBAL PExpMax                  AS LONG                           ' # gens for Export management
GLOBAL SawQuote                 AS LONG                           ' Quoted filename

'--------------------------------------------------------------------------------------------------+
'- AddLog message type                                                                             |
'--------------------------------------------------------------------------------------------------+
%MsgLog     = &H00000001                                          ' Issue Msg to the log
%MsgMsg     = &H00000002                                          ' Issue Msg via MyMsgBox
%MsgBoth    = &H00000003                                          ' Issue Both
%MsgKeep    = &H00000004                                          ' Set KeepLog

'--------------------------------------------------------------------------------------------------+
'- Define our Objects                                                                              |
'--------------------------------------------------------------------------------------------------+
GLOBAL SQL                      AS SQLI                           ' SQL DB handler
GLOBAL Kwd                      AS iKwd                           ' Keyword tables

FUNCTION PBMAIN () AS LONG
LOCAL i, j AS LONG, k AS SINGLE, t, BlockBuffer, sLangID, cword, EXEFullPath AS STRING
LOCAL lptr, pLang AS LONG POINTER
LOCAL lpdwHandle, RC AS LONG
LOCAL tASCIIZ  AS ASCIIZ * %MAX_PATH
LOCAL lclpValue AS ASCIIZ PTR
LET Kwd       = CLASS "cKwd"                                      ' Initialize the Kwd Object
DIM IP(1 TO 1000) AS GLOBAL STRING                                ' DIM the GLOBAL tables
DIM Keys(1 TO 107) AS GLOBAL STRING                               '
DIM DBTables(1 TO 500) AS GLOBAL STRING                           '
DIM LogEnt(1 TO 1000)  AS GLOBAL STRING                           '
DIM PCRE_Offsets(12)   AS GLOBAL LONG                             '
DIM gFMProp(1 TO 50)   AS GLOBAL STRING                           '

   '-----------------------------------------------------------------------------------------------+
   '- Tell Kwd where the Validation routines are                                                   |
   '-----------------------------------------------------------------------------------------------+
      Kwd.AddCPtr(01, CODEPTR(V1Char))                            ' Create the CODEPTR list
      Kwd.AddCPtr(02, CODEPTR(VAny))                              '
      Kwd.AddCPtr(03, CODEPTR(VCommaNum))                         '
      Kwd.AddCPtr(04, CODEPTR(VDate))                             '
      Kwd.AddCPtr(05, CODEPTR(VEOL))                              '
      Kwd.AddCPtr(06, CODEPTR(VFileLine))                         '
      Kwd.AddCPtr(07, CODEPTR(VFMLayout))                         '
      Kwd.AddCPtr(08, CODEPTR(VInvChar))                          '
      Kwd.AddCPtr(09, CODEPTR(VKillQ))                            '
      Kwd.AddCPtr(10, CODEPTR(VList))                             '
      Kwd.AddCPtr(11, CODEPTR(VNumeric))                          '
      Kwd.AddCPtr(12, CODEPTR(VOnOff))                            '
      Kwd.AddCPtr(13, CODEPTR(VPerNum))                           '
      Kwd.AddCPtr(14, CODEPTR(VRange))                            '
      Kwd.AddCPtr(15, CODEPTR(VSBLayout))                         '
      Kwd.AddCPtr(16, CODEPTR(VTStamp))                           '
   '-----------------------------------------------------------------------------------------------+
   '- Get our official version                                                                     |
   '-----------------------------------------------------------------------------------------------+
   EXEFullPath = EXE.FULL$                                        ' Save where the EXE file is
   tASCIIZ = EXEFullPath                                          ' Into ASCIIZ
   i = GetFileVersionInfoSize(tASCIIZ, lpdwHandle)                ' Fetch size of area needed
   BlockBuffer = SPACE$(i)                                        ' Alloc a block
   RC = GetFileVersionInfo(BYCOPY EXEFullPath, lpdwHandle, i, BYVAL STRPTR(BlockBuffer)) ' Copy the EXE info block
   RC = VerQueryValue(BYVAL STRPTR(BlockBuffer), "\VarFileInfo\Translation", pLang, lpdwHandle)                                 '
   sLangID = IIF$(RC, HEX$(LO(WORD, @pLang), 4) + HEX$(HI(WORD, @pLang), 4), "040904E4") ' Get lang. or use American English/ANSI
   RC = VerQueryValue(BYVAL STRPTR(BlockBuffer), "\StringFileInfo\" & sLangID & "\ProductVersion", lclpValue, lpdwHandle)                                 '
   PgmVers = @lclpValue                                           ' Save version

   '-----------------------------------------------------------------------------------------------+
   '- OK, lets start                                                                               |
   '-----------------------------------------------------------------------------------------------+
   AddLog "CFGMaint Version " + PgmVers + " LOG "                 ' Write something to the LOG
   LoadKeys()                                                     ' Load the KBD Keys table
   ARRAY ASSIGN gFMProp() = "Artist", "Album", "BRate", "BDepth", "Contrib", "CamMaker", "CamModel", _
                            "DateTaken", "Dimension", "Duration", "Exp", "Flash", "FStop", "Genre", "HRes", _
                            "ISO", "Publisher", "Rating", "SubTitle", "Title", "Trk", "VRes", "Year"
   gFMPropNum = 22                                                ' Set the count

   TimeStamp  = MID$(DATE$, 7, 4) + "-" + MID$(DATE$, 1, 2) + "-" + MID$(DATE$, 4, 2)
   TimeStamp += " " + MID$(TIME$, 1, 2) + "." + MID$(TIME$, 4, 2) ' Build the Run Timestamp
   pExpMax = VAL(RegGet("Software\SPFLite", "EXPMAX", "3"))       ' Try getting EXPMAX, else default to 3
   IF GetHomeFolders(%False) THEN EXIT FUNCTION                   ' No Homefolder, then no run

   '-----------------------------------------------------------------------------------------------+
   '- See if SPFLite is running                                                                    |
   '-----------------------------------------------------------------------------------------------+
   i = sFindWindow("SPFLite(", j)                                 ' See if SPFLite is running somewhere
   IF i <>  0 THEN                                                ' Yes, tell user
      AddLog "Cancelled, there is an INSTANCE of SPFLite executing", (%MsgBoth OR %MsgKeep)
      GOTO ShutItDown                                             '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get PCRE ready to use                                                                        |
   '-----------------------------------------------------------------------------------------------+
   hLib_PCRE = LoadLibraryA( BYCOPY "PCRE3.Dll" )                 ' Get handle to the DLL
   IF hLib_PCRE THEN                                              ' PCRE exists
      hProc_PCRE_Compile          = GetProcAddress(hLib_PCRE, BYCOPY "pcre_compile")
      hProc_PCRE_Exec             = GetProcAddress(hLib_PCRE, BYCOPY "pcre_exec")
      hProc_PCRE_Free             = GetProcAddress(hLib_PCRE, BYCOPY "pcre_free")
      lptr = hProc_PCRE_Free                                      ' Free returns a POINTER to the real free routine
      hProc_PCRE_Free_Ptr = @lptr                                 ' so chain to it as the REAL entry point
      IF hProc_PCRE_Compile        AND _                          ' All three better be non-zero
         hProc_PCRE_Exec           AND _                          '
         hProc_PCRE_Free_Ptr       THEN                           '
      ELSE                                                        '
         AddLog "Internal PCRE functions NOT found", (%MsgBoth OR %MsgKeep) ' Error
         GOTO ShutItDown                                          '
      END IF                                                      '
   ELSE                                                           '
      AddLog "PCRE DLL does NOT appear TO be installed", (%MsgBoth OR %MsgKeep) ' Say why we didn't DO it
      GOTO ShutItDown                                             '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Determine what type of run we're doing, die IF errors                                        |
   '-----------------------------------------------------------------------------------------------+
   IF GetPgmMode() THEN KeepLog = %True: GOTO ShutItDown          ' Get program mode, exit if errors

   '-----------------------------------------------------------------------------------------------+
   '-  All the basic Init is done, now split by what Mode has been requested                       |
   '-----------------------------------------------------------------------------------------------+
   Pass = 1                                                       ' To start
   IF (PMode AND %PExport)   THEN DoExport                        ' Call whichever mode was requested
   IF (PMode AND %PImport)   THEN DoImport                        '
   IF (PMode AND %PRepair)   THEN DoRepair                        '
   IF (PMode AND %PExpColor) THEN DoExpColor                      '
   IF (PMode AND %PImpColor) THEN DoImpColor                      '

ShutItDown:
   IF KeepLog THEN                                                ' Need to keep the LOG file
      '--------------------------------------------------------------------------------------------+
      '- Open our Log file                                                                         |
      '--------------------------------------------------------------------------------------------+
      lFName = HomeLog + "CFGMaint LOG " + Timestamp + ".TXT"     ' Build log file name
      lFN    = FREEFILE                                           ' Get a file number
      OPEN lFName FOR OUTPUT AS lFN                               ' Open it.
      FOR i = 1 TO LogEntCtr                                      ' Dump the entries
         PRINT # lFN, LogEnt(i)                                   ' Write one
      NEXT i                                                      '
      CLOSE #lFN                                                  ' Close the LOG
      FUNCTION = 8                                                ' Set program RC to 8
   END IF                                                         '
   IF (PMode AND %PExport) AND PExpMax > 0 AND pExpName = "" THEN Retention() ' If a full Export run and -EXPMAX is non-zero, do retention processing
END FUNCTION                                                      '

SUB AddLog(lTxt AS STRING, OPT MType AS LONG)
'--------------------------------------------------------------------------------------------------+
'- Add a line to the LOG file                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL lclMType, i, j AS LONG, CleanTxt AS STRING
   lclMType = IIF(ISMISSING(MType), %MsgLog, MType)               ' Setup message type

   '-----------------------------------------------------------------------------------------------+
   '- Do whatever message types are asked for                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF (lclMType AND %MsgMsg) THEN                                 ' Msgbox?
      IF (PMode AND %PQuiet) = 0 THEN _                           ' If not Quiet mode
         MyMsgBox lTxt, %MB_OK OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint"
   END IF                                                         '

   IF (lclMType AND %MsgLog) THEN                                 ' MsgLog?
      IF INSTR(lTxt, "|") <> 0 THEN                               ' Formatting characters?
         FOR i = 1 TO LEN(lTxt)                                   ' Yes, strip them out
            IF MID$(lTxt, i, 1) = "|" THEN                        ' Escape char?
               i += 1                                             ' Yes, step over them
               ITERATE FOR                                        ' Continue
            ELSE                                                  ' Else
               CleanTxt += MID$(lTxt, i, 1)                       ' Add to the clean string
            END IF                                                '
         NEXT i                                                   '
      ELSE                                                        ' No cleaning needed
         CleanTxt = lTxt                                          '
      END IF                                                      '
      INCR LogEntCtr                                              ' Bump count
      IF LogEntCtr > UBOUND(LogEnt()) THEN REDIM PRESERVE LogEnt(1 TO 2 * LogEntCtr) AS GLOBAL STRING
      LogEnt(LogEntCtr) = "CFGMaint - " + CleanTxt                ' Prefix and tuck the line away
   END IF                                                         '
   IF (lclMType AND %MsgKeep) <> 0 THEN KeepLog = %True
END SUB                                                           '

SUB DoExport()
'--------------------------------------------------------------------------------------------------+
'- Export the CFG data                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING, i, j AS LONG
   '-----------------------------------------------------------------------------------------------+
   '- Get environment set up                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF GetCFGOpen(%False) THEN EXIT SUB                            ' OPEN failed, so no run

   '-----------------------------------------------------------------------------------------------+
   '- If pExpname available, do that one table                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF pExpName <> "" THEN                                         ' Do we have a table name?
      '----- See if the table exists
      IF ISFALSE SQL.TableExist(PExpname) THEN                    ' See if table exists
         AddLog "EXPORT table NAME: " + PExpName + " can NOT be found IN the CFG file", (%MsgBoth OR %MsgKeep)
         EXIT SUB                                                 '
      END IF                                                      '
      DBCtr = 1                                                   ' Fudge a single table entry
      DBTables(DBctr) = pExpName                                  '

   ELSE                                                           ' Get the full list of table names

      '--------------------------------------------------------------------------------------------+
      '- Get all the table names                                                                   |
      '--------------------------------------------------------------------------------------------+
      AddLog "Fetching CFG table names"                           ' Status message to LOG
      SQL.SelBegin("select NAME FROM sqlite_master WHERE TYPE ='table'")
      IF SQL.SelFirst() THEN                                      ' Select the first
         DO                                                       ' Loop through them
            INCR DBCtr                                            ' Count them
            IF DBCtr > UBOUND(DBTables()) THEN REDIM PRESERVE DBTables(1 TO 2 * UBOUND(DBTables())) AS GLOBAL STRING
            DBTables(DBctr) = SQL.SelGet("Name")                  ' Save the table name
         LOOP WHILE SQL.SelNext()                                 '
      END IF                                                      '
      SQL.SelEnd                                                  ' Close the SQL request
      ARRAY SORT DBTables() FOR DBCtr                             ' Sort Table names
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Open the output file                                                                         |
   '-----------------------------------------------------------------------------------------------+
   FN = FREEFILE                                                  ' Get a file number
   FName = HomeFolder + "CFGMaint EXP " + Timestamp + IIF$(pExpName <> "", ".[" + pExpName + "]", "") + ".TXT" ' Setup filename
   OPEN FName FOR OUTPUT AS #FN                                   ' Open the file

   '-----------------------------------------------------------------------------------------------+
   '- Dump details for each table                                                                  |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO DBCtr                                             ' Loop through them
      DumpTable(DBTables(i))                                      '
   NEXT i                                                         '

   CLOSE #FN                                                      ' Close the output
   SQL.DBClose                                                    ' Close the CFG file
   AddLog "Export complete, invalid items dropped: " + FORMAT$(ImpFixed), %MsgBoth  ' Status message
END SUB

SUB DoExpColor()
'--------------------------------------------------------------------------------------------------+
'- Export the CFG data                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING, i, j AS LONG

   '-----------------------------------------------------------------------------------------------+
   '- Get environment set up                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF GetCFGOpen(%False) THEN EXIT SUB                            ' OPEN failed, so no run

   '-----------------------------------------------------------------------------------------------+
   '- Ensure table exists                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE SQL.TableExist(PExpname) THEN                       ' See if table exists
      AddLog "EXPCOLOR table NAME: " + PExpName + " can NOT be found IN the CFG file", (%MsgBoth OR %MsgKeep)
      EXIT SUB                                                    '
   END IF                                                         '
   DBCtr = 1                                                      ' Fudge a single table entry
   DBTables(DBctr) = pExpName                                     '

   '-----------------------------------------------------------------------------------------------+
   '- Open the output file                                                                         |
   '-----------------------------------------------------------------------------------------------+
   FN = FREEFILE                                                  ' Get a file number
   FName = HomeFolder + "CFGMaint EXP " + Timestamp + IIF$(pExpName <> "", ".[" + pExpName + " Colors]", "") + ".TXT" ' Setup filename
   OPEN FName FOR OUTPUT AS #FN                                   ' Open the file

   '-----------------------------------------------------------------------------------------------+
   '- Dump details for each table                                                                  |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO DBCtr                                             ' Loop through them
      DumpTable(DBTables(i))                                      '
   NEXT i                                                         '

   CLOSE #FN                                                      ' Close the output
   SQL.DBClose                                                    ' Close the CFG file
   AddLog "ExpColor complete", %MsgBoth                           ' Status message
END SUB

SUB DoImport()
'--------------------------------------------------------------------------------------------------+
'- Import a CFG file's DATA                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING, i, j, GotTable AS LONG

   '-----------------------------------------------------------------------------------------------+
   '- Get environment set up                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF GetCFGOpen(%True) THEN EXIT SUB                             ' OPEN failed, so no run

   '-----------------------------------------------------------------------------------------------+
   '- If pImpName available then no need to prompt                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF pImpName <> "" THEN                                         ' If we have an Import file-name
      FName = pImpName                                            ' Use the provided name
   ELSE
      '--------------------------------------------------------------------------------------------+
      '- Get the selected Export file that's TO be re-loaded                                       |
      '--------------------------------------------------------------------------------------------+
      DISPLAY OPENFILE 0, 25, 25, "Enter EXPORT file TO re-load", HomeFolder, _
                                  "EXPORT" + CHR$(0) + "*EXP*.TXT" + CHR$(0) +  _
                                  "All Files" + CHR$(0) + "*.*" + CHR$(0), _
                       "", "", %OFN_FILEMUSTEXIST TO FName        '
      IF ISNULL(FName) THEN                                       ' Create the tables
         AddLog " No file selected, IMPORT run cancelled", (%MsgBoth OR %MsgKeep)
         EXIT SUB                                                 ' Bail out, tell mainline to create the LOG
      END IF                                                      '
   END IF                                                         '

   StartPass:
   '-----------------------------------------------------------------------------------------------+
   '- OPEN the Import file                                                                         |
   '-----------------------------------------------------------------------------------------------+
   FN = FREEFILE                                                  ' Get a file number

   '-----------------------------------------------------------------------------------------------+
   '- Open the file                                                                                |
   '-----------------------------------------------------------------------------------------------+
   TRY                                                            ' Open it
      OPEN FName FOR INPUT AS #FN                                 '
   CATCH                                                          '
      AddLog "Can't OPEN: |K" + FName + "|B, Import run cancelled", (%MsgBoth OR %MsgKeep)
      EXIT SUB                                                    ' Bail out, tell mainline to create the LOG
   END TRY

   '-----------------------------------------------------------------------------------------------+
   '- Get next section from the file                          '                                    |
   '-----------------------------------------------------------------------------------------------+
   NextTable:
   IPCtr = 0                                                      ' Reset count
   IF ISFALSE EOF(FN) THEN                                        ' At least 1 line
      LINE INPUT # FN, t                                          ' Get a record
      t = RTRIM$(t)                                               ' Right trim it
      IF LEFT$(t, 1) <> "[" THEN                                  ' Look OK?
         AddLog "Invalid HEADER record: |K" + t + "|B, IMPORT run cancelled", (%MsgBoth OR %MsgKeep)
         EXIT SUB                                                 ' Bail out, tell mainline to create the LOG
      END IF                                                      '
      t = TRIM$(t)                                                ' Strip it
      i = INSTR(t, "]")                                           ' Find trailing ]
      IPName = MID$(t, 2 TO i - 1)                                ' Extract the table name
      IF RIGHT$(t, 1) <> "]" THEN                                 ' Just the [name]?
         AddLog "Invalid HEADER record: |K" + t + "|B, IMPORT run cancelled", (%MsgBoth OR %MsgKeep)
         EXIT SUB                                                 ' Bail out, tell mainline to create the LOG
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now get the table's DATA                                                                  |
      '--------------------------------------------------------------------------------------------+
      DO WHILE ISFALSE EOF(FN)                                    ' Process the file records
         LINE INPUT # FN, t                                       ' Get a record
         t = RTRIM$(t)                                            ' Clean it up
         IF LEFT$(t, 8) = "========" THEN EXIT DO                 ' End of table
         INCR IPCtr                                               ' Count it
         IP(IPCtr) = t                                            ' Save it
      LOOP

      '--------------------------------------------------------------------------------------------+
      '- We have a table's entries, go PROCESS them                                                |
      '--------------------------------------------------------------------------------------------+
      GotTable = %True                                            ' Remember we got 'something'
      SELECT CASE AS CONST$ LEFT$(IPName, 1)                      ' Split off
         CASE "S": LoadSet                                        ' "S" table
         CASE "B": LoadBkp                                        ' "B" table
         CASE "R": LoadRet                                        ' "R" table
         CASE "E": LoadEFT                                        ' "E" table
         CASE "O": IF LoadOpt THEN KeepLog = %True: EXIT SUB      ' Bail out, tell mainline to create the LOG
         CASE "K": IF LoadKbd THEN KeepLog = %True: EXIT SUB      '
         CASE "P": IF LoadPrf THEN KeepLog = %True: EXIT SUB      '
      END SELECT                                                  '
      GOTO NextTable                                              ' Do it again for the next table
   END IF
   CLOSE #FN                                                      ' Close the file

   '-----------------------------------------------------------------------------------------------+
   '- Did we do anything?                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE GotTable THEN                                       ' No, nothing
      AddLog "There were NO tables IN the IMPORT file", (%MsgBoth OR %MsgKeep)
      EXIT SUB                                                    ' Bail out, tell mainline to create the LOG
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Ask if OK to do the update                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF Pass = 1 AND (PMode AND %PQuiet) = 0 THEN                   ' Ask permission if not Quiet mode
      i = MyMsgBox(BUILD$("Import file validation complete.", $CRLF, _ '
               "Proceed TO LOAD into the CFG file?"), %MB_YESNO OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint")
      IF i = %IDNO THEN                                           ' No-Go?
         SQL.DBClose                                              ' Shut DB
         EXIT SUB                                                 ' We're done THEN
      END IF                                                      '
      Pass = 2                                                    ' Going ahead, set Pass to 2
      GOTO StartPass                                              ' Loop back and do it again
   END IF                                                         '

   SQL.VacuumDB                                                   ' Vacuum
   SQL.DBClose                                                    ' Close the CFG file
   AddLog "CFG entries re-loaded successfully, items corrected: " + FORMAT$(ImpFixed), %MsgBoth
END SUB

SUB DoImpColor()
'--------------------------------------------------------------------------------------------------+
'- Import a CFG file's Color data                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL t, tID, tName, LH, RH AS STRING, i, j, GotTable AS LONG

   '-----------------------------------------------------------------------------------------------+
   '- Get environment set up                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF GetCFGOpen(%True) THEN EXIT SUB                             ' OPEN failed, so no run

   IF ISFALSE SQL.TableExist(PImpname) THEN                       ' See if table exists
      AddLog "IMPCOLOR table NAME: " + PImpName + " can NOT be found IN the CFG file", (%MsgBoth OR %MsgKeep)
      EXIT SUB                                                    '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get the selected Export file that's TO be re-loaded                                          |
   '-----------------------------------------------------------------------------------------------+
   DISPLAY OPENFILE 0, 25, 25, "Enter EXPORT file TO re-load", HomeFolder, _
                               "EXPORT" + CHR$(0) + "*EXP*.TXT" + CHR$(0) +  _
                               "All Files" + CHR$(0) + "*.*" + CHR$(0), _
                    "", "", %OFN_FILEMUSTEXIST TO FName           '
   IF ISNULL(FName) THEN                                          '
      AddLog " No file selected, IMPCOLOR run cancelled", (%MsgBoth OR %MsgKeep)
      EXIT SUB                                                    ' Bail out, tell mainline to create the LOG
   END IF                                                         '

   StartPass:
   '-----------------------------------------------------------------------------------------------+
   '- OPEN the Import file                                                                         |
   '-----------------------------------------------------------------------------------------------+
   FN = FREEFILE                                                  ' Get a file number

   '-----------------------------------------------------------------------------------------------+
   '- Open the file                                                                                |
   '-----------------------------------------------------------------------------------------------+
   TRY                                                            ' Open it
      OPEN FName FOR INPUT AS #FN                                 '
   CATCH                                                          '
      AddLog "Can't OPEN: |K" + FName + "|B, IMPCOLOR run cancelled", (%MsgBoth OR %MsgKeep)
      EXIT SUB                                                    ' Bail out, tell mainline to create the LOG
   END TRY

   '-----------------------------------------------------------------------------------------------+
   '- Get next section from the file                          '                                    |
   '-----------------------------------------------------------------------------------------------+
   IPCtr = 0                                                      ' Reset count
   IF ISFALSE EOF(FN) THEN                                        ' At least 1 line
      LINE INPUT # FN, t                                          ' Get a record
      t = RTRIM$(t)                                               ' Right trim it
      IF LEFT$(t, 1) <> "[" THEN                                  ' Look OK?
         AddLog "Invalid HEADER record: |K" + t + "|B, IMPCOLOR run cancelled", (%MsgBoth OR %MsgKeep)
         EXIT SUB                                                 ' Bail out, tell mainline to create the LOG
      END IF                                                      '
      t = TRIM$(t)                                                ' Strip it
      i = INSTR(t, "]")                                           ' Find trailing ]
      IPName = MID$(t, 2 TO i - 1)                                ' Extract the table name
      IF MID$(t, i + 1) <> " Colors" THEN                         ' Better be a Colors Export
         AddLog "Invalid HEADER record: |K" + t + "|B, Import file is not an EXPCOLOR created file", (%MsgBoth OR %MsgKeep)
         EXIT SUB                                                 ' Bail out, tell mainline to create the LOG
      END IF                                                      '
   END IF                                                         '
   IPName = PImpname                                              ' Swap to the desired O/P table name

   '-----------------------------------------------------------------------------------------------+
   '- Now get the table's DATA                                                                     |
   '-----------------------------------------------------------------------------------------------+
   DO WHILE ISFALSE EOF(FN)                                       ' Process the file records
      LINE INPUT # FN, t                                          ' Get a record
      t = RTRIM$(t)                                               ' Clean it up
      IF LEFT$(t, 8) = "========" THEN EXIT DO                    ' End of table
      INCR IPCtr                                                  ' Count it
      IP(IPCtr) = t                                               ' Save it
   LOOP                                                           '
   CLOSE # FN                                                     ' Close file, only 1 table needed

   '-----------------------------------------------------------------------------------------------+
   '- We have the table's entries, go PROCESS them                                                 |
   '-----------------------------------------------------------------------------------------------+
   GotTable = %True                                               ' Remember we got 'something'
   IF LoadOpt THEN KeepLog = %True: EXIT SUB                      ' Bail out, tell mainline to create the LOG

   '-----------------------------------------------------------------------------------------------+
   '- Update the provided values                                                                   |
   '-----------------------------------------------------------------------------------------------+
   tID = LEFT$(IPName, 1): tName = MID$(IPName, 2)                ' Get table type and name
   SQL.OptName = tName                                            ' Set the SQL full table name
   FOR i = 1 TO IPCtr                                             ' Process the entries
      j = INSTR(IP(i), "=")                                       ' Find the = sign
      LH = LEFT$(IP(i), j - 1)                                    ' Separate the LH and RH
      RH = MID$(IP(i), j + 1)                                     '
      SQL.UpdateString(tID, LH, RH)                               ' Update this entry
   NEXT i                                                         '

   SQL.VacuumDB                                                   ' Vacuum
   SQL.DBClose                                                    ' Close the CFG file
   AddLog "CFG color entries re-loaded successfully", %MsgBoth
END SUB

SUB DoRepair()
'--------------------------------------------------------------------------------------------------+
'- Do the CFG Repair function                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL wKW, wData, SrchAns, TblType, TblName, ScanKey, t, k, v, r AS STRING, INIKW(), INIValue() AS STRING
LOCAL CFGCtr, TblCount, i, j, l, m, NumFixed, NumIgnored AS LONG
DIM CFGDump(1 TO 10000) AS STRING
DIM INITable(1 TO 10000) AS STRING
DIM INIKW(1 TO 10000) AS STRING
DIM INIValue(1 TO 10000) AS STRING

   '-----------------------------------------------------------------------------------------------+
   '- Get environment set up                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF GetCFGOpen(%False) THEN EXIT SUB                            ' OPEN failed, so no run

   '-----------------------------------------------------------------------------------------------+
   '- Get all the table names                                                                      |
   '-----------------------------------------------------------------------------------------------+
   AddLog "Fetching table names"                                  ' Status message to LOG
   RESET DBCtr                                                    ' Start at 0
   SQL.SelBegin("select NAME FROM sqlite_master WHERE TYPE ='table'")
   IF SQL.SelFirst() THEN                                         ' Select the first
      DO                                                          ' Loop through them
         INCR DBCtr                                               ' Count them
         IF DBCtr > UBOUND(DBTables()) THEN REDIM PRESERVE DBTables(1 TO 2 * UBOUND(DBTables())) AS GLOBAL STRING
         DBTables(DBctr) = SQL.SelGet("Name")                     ' Save the table name
      LOOP WHILE SQL.SelNext()                                    '
   END IF                                                         '
   SQL.SelEnd                                                     ' Close the SQL request
   ARRAY SORT DBTables() FOR DBCtr                                ' Sort Table names

   '-----------------------------------------------------------------------------------------------+
   '- Fetch all the values from all the tables                                                     |
   '-----------------------------------------------------------------------------------------------+
   RESET CFGCtr                                                   ' Initialize the index
   FOR i = 1 TO DBCtr                                             ' Loop through them
      SQL.SelBegin("select * FROM " + $DQ + DBTables(i) + $DQ)    ' Ask for everything in the table
      IF SQL.SelFirst() THEN                                      ' Select the first
         DO                                                       ' Loop through all the entries
            t = LSET$(DBTables(i), 10)                            ' Get the tablename padded to 10
            k = LSET$(SQL.SelGet("DBKey"), 20)                    ' Get the keyword padded to 20
            v = RTRIM$(SQL.SelGet("DBData"))                      ' Get the Data (Rtrimmed)
            INCR CFGCtr                                           ' Count it
            CFGDump(CFGCtr) = BUILD$(t, k, v)                     ' Save an entry
         LOOP WHILE SQL.SelNext()                                 '
      END IF                                                      '
      SQL.SelEnd                                                  ' Close the SQL request
   NEXT i

   '-----------------------------------------------------------------------------------------------+
   '- We now have the entire CFG file loaded into tables                                           |
   '-----------------------------------------------------------------------------------------------+

   FOR i = 1 TO CFGCtr                                            ' Loop through all entries and review them
      SELECT CASE AS CONST$ LEFT$(CFGDump(i), 1)                  ' Validate each entry type (1st char of table name)

         '-----------------------------------------------------------------------------------------+
         '- Options KW=value type                                                                  |
         '-----------------------------------------------------------------------------------------+
         CASE "O", "P"                                            ' Keyword type (Options / Profile)
            t = TRIM$(LEFT$(CFGDump(i), 10))                      ' Get tablename
            k = TRIM$(MID$(CFGDump(i), 11 TO 30))                 ' Get key
            v = RTRIM$(MID$(CFGDump(i), 31))                      ' Get key
            SrchAns = SrchKW(k, v, LEFT$(CFGDump(i), 1))          ' Lookup and validate the keyword
            r = MID$(SrchAns, 2)                                  ' Separate replacement value
            IF LEFT$(SrchAns, 1) = "4" THEN                       ' Valid KW but invalid Data?
               j = MyMsgBox(BUILD$("Table: |K", t, "|B, Entry: |K", k, "|B,", $CRLF, _
                            "Contains an invalid value: |K", v, "|B.", $CRLF, $CRLF, _
                            "Replace with the DEFAULT value: |K", r, "|B?"), _
                            %MB_YESNOCANCEL OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint")
               IF j = %IDYES THEN                                 ' Permission to correct
                  SQL.UpdateStringDirect(t, k, MID$(SrchAns, 2))  ' Update the entry
                  AddLog BUILD$("Table: ", t, ", Entry: ", k, ", was corrected TO value: ", r), (%MsgLog OR %MsgKeep)
                  INCR NumFixed                                   ' Count fixed

               ELSEIF j = %IDNO THEN                              ' User says leave alone?
                  AddLog BUILD$("Table: ", t, ", Entry: ", k, ", Value: ", v, " was invalid but NOT corrected"), (%MsgLog OR %MsgKeep)
                  INCR NumIgnored                                 ' Count ignored

               ELSE                                               ' Told to CANCEL?
                  SQL.SelEnd                                      ' Do so
                  SQL.DBClose                                     '
                  KeepLog = %True                                 ' Have LOG created
                  EXIT SUB                                        '
               END IF                                             '

            ELSEIF LEFT$(SrchAns, 1) = "8" THEN                   ' Invalid KW?
               j = MyMsgBox(BUILD$("Table: |K", t, "|B, Entry: |K", k,"|B,",$CRLF, _
                            "Value: |K", v, "|B, IS an invalid OR obsolete Keyword.", $CRLF, $CRLF, _
                            "Permission TO remove it?"), _
                            %MB_YESNOCANCEL OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint")
               IF j = %IDYES THEN                                 ' Permission to Delete?
                  SQL.RowDeleteDirect(t, k)                       ' Do it
                  AddLog BUILD$("Table: ", t, ", Entry: ", k, ", was invalid AND deleted"), (%MsgLog OR %MsgKeep)
                  INCR NumFixed                                   ' Count fixed

               ELSEIF j = %IDNO THEN                              ' User says leave alone?
                   AddLog BUILD$("Table: ", t, ", Entry: ", k, ", was invalid but NOT deleted"), (%MsgLog OR %MsgKeep)
                   INCR NumIgnored                                ' Count ignored

               ELSE                                               ' Told to CANCEL?
                  SQL.SelEnd                                      ' Do so
                  SQL.DBClose                                     '
                  KeepLog = %True                                 ' Have LOG created
                  EXIT SUB                                        '
               END IF                                             '
            END IF                                                '

         CASE "K"                                                 ' Keyboard table
            RESET j                                               ' Reset ctr
            t = TRIM$(LEFT$(CFGDump(i), 10))                      ' Get tablename from 1st entry

            FOR m = i TO CFGCtr                                   ' Lets see how many entries
               IF t = TRIM$(LEFT$(CFGDump(m), 10)) THEN           ' Same name?
                  INCR j                                          ' Count it
               ELSE                                               ' If not, we're into the NEXT table
                  EXIT FOR                                        ' Done searching
               END IF
            NEXT m

            IF j <> 1071 THEN                                     ' Wrong size?
               MyMsgBox BUILD$("Keyboard table FOR: |K", t, "|B has an incorrect # of entries", $CRLF, _
                        "Please DO a KEYMAP update / SAVE TO correct this"), _
                        %MB_OK OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint"
               AddLog BUILD$("Keyboard table FOR: ", t, " has an incorrect # of entries, Please DO a KEYMAP update / SAVE TO correct this"), (%MsgLog OR %MsgKeep)
            END IF                                                '
            i = m - 1                                             ' Resume outer loop after this table

         CASE "S", "B", "R"                                       ' "S", "B" and "R" simple types
            RESET j                                               ' Reset ctr
            t = TRIM$(LEFT$(CFGDump(i), 10))                      ' Get tablename
            k = TRIM$(MID$(CFGDump(i), 11 TO 30))                 ' Get key
            v = RTRIM$(MID$(CFGDump(i), 31))                      ' Get value
            IF k <> "R00000" THEN
               MyMsgBox BUILD$("Table: |K", t, "|B IS missing the 1st CONTROL record", $CRLF, _
                        "Validation was skipped FOR THIS table."), _
                        %MB_OK OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint"
               AddLog BUILD$("Table: |K", t, "|B IS missing the 1st CONTROL record, Validation was skipped FOR THIS table."), (%MsgLog OR %MsgKeep)
               FOR m = i TO CFGCtr                                ' Skip over the tablle
                  IF t <> TRIM$(LEFT$(CFGDump(m + 1), 10)) THEN   ' Look at next name
                     i = m                                        ' Swap current into i (its the last table entry)
                     EXIT FOR                                     ' We're done
                  END IF                                          '
               NEXT m                                             '
               i = m - 1                                          '
            ELSE
               TblCount = VAL(v)                                  ' Get count in this table
            END IF                                                '

            FOR m = i + 1 TO CFGCtr                               ' Lets see how many entries
               IF t = TRIM$(LEFT$(CFGDump(m), 10)) THEN           ' Same name?
                  INCR j                                          ' Count it
               ELSE                                               ' If not, we're into the NEXT table
                  EXIT FOR                                        ' Done searching
               END IF
            NEXT m

            IF j <> TblCount THEN                                 ' Correct?
               MyMsgBox("Table: |K" + t + "|B, has |K" + FORMAT$(j) + "|B entries, the |RHeader|B says it has |K" + FORMAT$(TblCount) + $CRLF + $CRLF + _
                        "This will auto-correct the NEXT SPFLite startup", _
                        %MB_YESNOCANCEL OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint")
            END IF                                                '
            i = m - 1                                             ' Set continue point

         CASE "L"                                                 ' Layout table
            '                                                     ' DO nothing

      END SELECT
   NEXT i

   '-----------------------------------------------------------------------------------------------+
   '- Now look at each O and P table to ensure complete                                            |
   '-----------------------------------------------------------------------------------------------+
   ARRAY SORT DBTables() FOR DBCtr                                ' Sort Table names
   FOR i = 1 TO DBCtr                                             ' Loop through table names
      t = DBTables(i)                                             ' Get table name
      TblType = LEFT$(t, 1)                                       ' And type
      IF TblType <> "O" AND TblType <> "P" THEN ITERATE FOR       ' Ignore non "O" and "P" tables

      '--------------------------------------------------------------------------------------------+
      '- Now check that an entry exists for all items in the Kwd table                             |
      '--------------------------------------------------------------------------------------------+
      FOR j = 1 TO Kwd.KCtr                                        ' Spin through the KWD table
         Kwd.GetByIX(lclK, j)                                      ' Get 1st entry
         IF lclK.TType = TblType THEN                              ' Proper keyword type for this table?
            Scankey = LSET$(t, 10) + LSET$(lclK.Name, 20)          ' Build search key
            ARRAY SCAN CFGDump() FOR CFGCtr, FROM 1 TO 30, COLLATE UCASE, = Scankey, TO l
            IF l = 0 THEN                                         ' We didn't have THIS one
               m = MyMsgBox("Table: |K" + t + "|B, Entry: |K" + lclK.Name + "|B, IS missing." + $CRLF + $CRLF + _
                            "Permission TO ADD it with the DEFAULT value?", _
                            %MB_YESNOCANCEL OR %MB_USERICON OR %MB_SYSTEMMODAL, "CFGMaint")
               IF m = %IDYES THEN                                 ' Permission to Add?
                  SQL.AddStringDirect(t, TRIM$(lclK.Name), TRIM$(lclK.DefaultStr)) 'Add it now
                  AddLog "Table: " + t + ", Entry: " + lclK.Name + ", was added with the DEFAULT value.", (%MsgLog OR %MsgKeep)

               ELSEIF m = %IDNO THEN                              ' User says leave alone?
                  AddLog "Table: " + t + ", Entry: " + lclK.Name +  ", was invalid but NOT added TO the table", (%MsgLog OR %MsgKeep)
                  INCR NumIgnored                                 '

               ELSE                                               ' Told to CANCEL?
                  SQL.SelEnd                                      ' Do so
                  SQL.DBClose                                     '
                  KeepLog = %True                                 ' Have LOG created
                  EXIT SUB                                        '
               END IF                                             '
            END IF                                                '
         END IF                                                   '
      NEXT j                                                      '
   NEXT i                                                         '

   AddLog "Repair complete, Items Corrected: |K" + FORMAT$(NumFixed) + "|B, Items ignored: |K" + FORMAT$(NumIgnored) + "|B", %MsgBoth

END SUB

SUB DumpTable(TblName AS STRING)
'--------------------------------------------------------------------------------------------------+
'- Output a single table                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL t, wKW, wData, SrchAns, TblType AS STRING, INITable() AS STRING
LOCAL INICtr, i, j, HadError AS LONG
DIM INITable(1 TO 1000) AS STRING
   TblType = LEFT$(TblName, 1)                                    ' Split table type
   IF INSTR("OPKBRSE", TblType) = 0 THEN EXIT SUB                 ' Just do supported tables
   AddLog "Exporting table: " + "[" + TblName + IIF$((PMode AND %PExpColor), " Colors]", "]") ' Status message to LOG
   PRINT #FN, "[" + TblName + "]" + IIF$((PMode AND %PExpColor), " Colors", "") ' Header line to Export file

   SELECT CASE AS CONST$ TblType                                  ' Handle each type

      '--------------------------------------------------------------------------------------------+
      '- Options INI type                                                                          |
      '--------------------------------------------------------------------------------------------+
      CASE "O", "P"                                               ' Options INI type
         HadError = %False                                        ' Reset
         '-----------------------------------------------------------------------------------------+
         '- Extract the data from the SQL Table                                                    |
         '-----------------------------------------------------------------------------------------+
         SQL.SelBegin("select * FROM " + $DQ + TblName + $DQ)     ' Ask for everything
         IF SQL.SelFirst() THEN                                   ' Select the first
            DO                                                    ' Loop through them
               wKW = SQL.SelGet("DBKey")                          ' Get the keyword
               wData = SQL.SelGet("DBData")                       ' Get the Data
               SrchAns = SrchKW(wKW, wData, TblType)              ' Lookup the keyword
               IF LEFT$(SrchAns, 1) = "0" OR _                    ' A current valid keyword?
                  LEFT$(SrchAns, 1) = "4" THEN                    ' or valid KW but invalid Data
                  IF (PMode AND %PExpColor) THEN                  ' If an EXPCOLOR run
                     IF MID$(SrchAns, 2, 1) = "0" THEN ITERATE DO ' And this is not a color operand, then skip it
                  END IF                                          '
                  INCR INICtr                                     ' Count it
                  INITable(INICtr) = wKW + "=" + wData            ' Write the KW=value string
               ELSE
                  AddLog "Table: " + TblName + ", Entry: " + wKW + "=" + SQL.SelGet("DBData") + " IS Obsolete / Invalid, Dropped", (%MsgLog OR %MsgKeep)
                  INCR ImpFixed                                   ' Count dropped
               END IF                                             '
            LOOP WHILE SQL.SelNext()                              '
         END IF                                                   '
         SQL.SelEnd                                               ' Close the SQL request

         '-----------------------------------------------------------------------------------------+
         '- Sort into order                                                                        |
         '-----------------------------------------------------------------------------------------+
         ARRAY SORT INITable() FOR INICtr                         ' Sort the keywords

         FOR i = 1 TO INICtr                                      '
            PRINT #FN, INITable(i)                                ' Output the detail line
         NEXT i                                                   '
         AddLog TblName + " EXPORT complete"                      ' Say Table is done

      '--------------------------------------------------------------------------------------------+
      '- Format Keyboard entries                                                                   |
      '--------------------------------------------------------------------------------------------+
      CASE "K"
         '-----------------------------------------------------------------------------------------+
         '- OK, read items in correct order                                                        |
         '-----------------------------------------------------------------------------------------+
         FOR j = 1 TO 1070 STEP 10                                               ' Loop through the table
            t = SQL.GetStringDirect(TblName, "R" + FORMAT$(j, "00000"), "0")
            t = LSET$(MID$(t, 17), 7)                             ' Get the key name
            PRINT #FN, "Key: " + t + "-UP  = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 1, "00000"), "0")
            PRINT #FN, "Key: " + t + "-N   = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 2, "00000"), "0")
            PRINT #FN, "Key: " + t + "-S   = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 3, "00000"), "0")
            PRINT #FN, "Key: " + t + "-C   = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 4, "00000"), "0")
            PRINT #FN, "Key: " + t + "-A   = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 5, "00000"), "0")
            PRINT #FN, "Key: " + t + "-SC  = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 6, "00000"), "0")
            PRINT #FN, "Key: " + t + "-SA  = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 7, "00000"), "0")
            PRINT #FN, "Key: " + t + "-SCA = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 8, "00000"), "0")
            PRINT #FN, "Key: " + t + "-CA  = " + SQL.GetStringDirect(TblName, "R" + FORMAT$(j + 9, "00000"), "0")
         NEXT j                                                   '
         AddLog TblName + " EXPORT complete"                      ' Say Table is done

      '--------------------------------------------------------------------------------------------+
      '- Output the SPS, SPR, EFT and BKP entries                                                  |
      '--------------------------------------------------------------------------------------------+
      CASE "S", "R", "B", "E"
         '-----------------------------------------------------------------------------------------+
         '- Extract the data from the SQL Table                                                    |
         '-----------------------------------------------------------------------------------------+
         SQL.SelBegin("select * FROM " + $DQ + TblName + $DQ)
         IF SQL.SelFirst() THEN                                   ' Select the first
            DO                                                    ' Loop through them
               PRINT #FN, SQL.SelGet("DBData")                    ' Output it
            LOOP WHILE SQL.SelNext()                              '
         END IF                                                   '
         AddLog TblName + " EXPORT complete"                      ' Say Table is done

   END SELECT
   PRINT #FN, "=================================================================================="
END SUB

FUNCTION GetCFGOpen(OKCreate AS LONG) AS LONG
'--------------------------------------------------------------------------------------------------+
'- Get CFG file opened, create if needed and OKCreate, else fail by returning %True                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG, t AS STRING

   IF ISFALSE ISFILE(HomeFolder + "SPFLite.CFG") THEN             ' CFG exist?
      IF ISFALSE OKCreate THEN                                    ' If not allowed to create it
         AddLog "SPFLite.CFG file does NOT exist IN: |K" + HomeFolder + "|B", (%MsgBoth OR %MsgKeep)
         FUNCTION = %True: EXIT FUNCTION                          ' We can do no more
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Open the CFG file                                                                            |
   '-----------------------------------------------------------------------------------------------+
   '- If we get here CFG exists, OR we're allowed TO CREATE it                                     |
   '-----------------------------------------------------------------------------------------------+
   LET SQL       = CLASS "SQLC"                                   ' Initialize the SQL Object
   IF ISFALSE SQL.DBOpen(HomeFolder + "SPFLite.CFG") THEN         ' Open the CFG file
      AddLog "SPFLite.CFG file failed TO Open", (%MsgBoth OR %MsgKeep)                   '
      FUNCTION = %True: EXIT FUNCTION                             ' We can do no more
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Define the basic tables                                                                      |
   '-----------------------------------------------------------------------------------------------+
   t = "OPKBRSEL"                                                 ' Set table IDs to create
   FOR i = 1 TO LEN(t)                                            ' Loop through them
      IF ISFALSE SQL.TableCreate(MID$(t, i, 1) + "DEFAULT") THEN  ' Create the tables
      AddLog "SPFLite.CFG Tables failed TO Initialize", (%MsgBoth OR %MsgKeep)
      FUNCTION = %True: EXIT FUNCTION                             ' We can do no more
      END IF                                                      '
   NEXT i                                                         '
END FUNCTION                                                      '

FUNCTION GetHomeFolders(OKCreate AS LONG) AS LONG
'--------------------------------------------------------------------------------------------------+
'- Find our HomeFolders, create if permitted, return %True if error                                |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING, i, j AS LONG
   approvedlocation = %csidl_desktop                              ' First get User's DESKTOP folder AS a fall-back
   i = shgetfolderpath (BYVAL %Null, _                            ' Ask system for the location
                        approvedlocation OR %CSIDL_FLAG_CREATE, _ '
                        -0&, _                                    '
                        %shgfp_type_current, _                    '
                        approvedpath)                             '
   HomeLog = TRIM$(approvedpath) + "\"                            ' Create default HomeLog location
   AddLog "Temporary LOG location SET TO: " + HomeLog             ' Say what we've done

   approvedlocation = %csidl_personal                             ' First get User's Documents folder IN CASE the RegGet fails
   i = shgetfolderpath (BYVAL %Null, _                            ' Ask system for the location
                        approvedlocation OR %CSIDL_FLAG_CREATE, _ '
                        -0&, _                                    '
                        %shgfp_type_current, _                    '
                        approvedpath)                             '
   t = TRIM$(approvedpath) + "\SPFLite\"                          ' Create default HomeFolder location


   HomeFolder = RegGet("Software\SPFLite", "HomeFolder", "MISSING") ' Try getting HomeFolder from the Registry
   HomeData   = RegGet("Software\SPFLite", "HomeData",   "MISSING") ' Try getting HomeData

   RoamHome = EXE.PATH$ + "CONFIG\"                               ' Build possible Roaming Home
   IF ISFOLDER(RoamHome) THEN                                     ' Exist? Then we're roaming
      HomeFolder = RoamHome: HomeData = RoamHome                  ' Set Home path and Data path
   END IF

   IF HomeFolder = "MISSING" THEN                                 ' No V2 startup has been done yet
      IF ISFALSE OKCreate THEN                                    ' If not OK to create
         AddLog "Cancelled, cannot LOCATE the SPFLite Home OR DATA folders", (%MsgBoth OR %MsgKeep)
         FUNCTION = %True: EXIT FUNCTION                          ' Return with failure
      ELSE                                                        ' We have permission to create
         HomeFolder = t: HomeData = t: HomeLog = HomeFolder       ' Swap in the default
         IF ISFALSE ISFOLDER(HomeFolder) THEN MKDIR HomeFolder    ' Make sure it exists
         RegSet("Software\SPFLite", "HomeFolder", HomeFolder)     ' Save them in the registry
         RegSet("Software\SPFLite", "HomeData",   HomeData)       '
      END IF                                                      '
   ELSE                                                           '
      HomeLog = HomeFolder                                        ' Found some, reset the Log location
      AddLog "Log file location switched TO: " + HomeLog          ' Say we've found a NEW home FOR the LOG
   END IF                                                         '
                                                                  '
END FUNCTION                                                      '

FUNCTION GetPgmMode() AS LONG
'--------------------------------------------------------------------------------------------------+
'- See what Mode we're being asked to do                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL Ops(), t AS STRING, i, j, k, SawExpMax, SawQuiet AS LONG
   t = TRIM$(COMMAND$)                                            ' Get trimmed command line
   IF t <> "" THEN                                                ' We have a command line
      i = PARSECOUNT(t, " ")                                      ' Get number of operands
      REDIM Ops(1 TO i) AS STRING                                 ' Make table the correct size
      PARSE UCASE$(t), Ops(), " "                                 ' Split out the uppercase operands
      FOR j = 1 TO i                                              ' Have a look at each
         SELECT CASE AS CONST$ Ops(j)                             ' Split off
            CASE "-EXPORT"                                        ' -EXPORT?
               IF (PMode AND (%PImport OR %PRepair OR %PExpColor OR %PImpColor)) <> 0 THEN ' Already have another mode?
                  AddLog "Cancelled, COMMAND LINE has multiple modes specified", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               PMode OR= %PExport                                 ' Set Export mode

               '-----------------------------------------------------------------------------------+
               '- See if an Export table-name                                                      |
               '-----------------------------------------------------------------------------------+
               IF j < i THEN                                      ' If at least one more operand
                  IF LEFT$(Ops(j + 1), 1) <> "-" THEN             ' and it's NOT another Keyword
                     pExpName = Ops(j + 1)                        ' Then save it as a TableName
                     INCR j                                       ' Step over it
                  END IF                                          '
               END IF                                             '
            CASE "-EXPCOLOR"                                      ' -EXPCOLOR?
               IF (PMode AND (%PImport OR %PRepair OR %PExport OR %PImpColor)) <> 0 THEN ' Already have another mode?
                  AddLog "Cancelled, COMMAND LINE has multiple modes specified", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               PMode OR= %PExpColor                               ' Set ExpColor mode
               IF j >= i OR LEFT$(Ops(j + 1), 1) = "-" THEN       ' Better have a tablename
                  AddLog "Cancelled, EXPCOLOR requires a Tablename operand", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               IF UCASE$(LEFT$(Ops(j + 1), 1)) <> "O" THEN        ' Better be an Options table
                  AddLog "Cancelled, EXPCOLOR only handles O...... tables", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               PMode OR= %PExpColor                               ' Set ExpColor mode
               pExpName = Ops(j + 1)                              ' Save the TableName
               INCR j                                             ' Step over it
            CASE "-IMPORT"                                        ' -IMPORT?
               IF (PMode AND (%PExport OR %PRepair OR %PExpColor OR %PImpColor)) <> 0 THEN ' Already have another mode?
                  AddLog "Cancelled, COMMAND LINE has multiple modes specified", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               PMode OR= %PImport                                 ' Set Import mode

               '-----------------------------------------------------------------------------------+
               '- See if an Import file-name                                                       |
               '-----------------------------------------------------------------------------------+
               IF j < i THEN                                      ' If more operands
                  IF LEFT$(Ops(j + 1), 1) = "-" THEN              ' and it's a Keyword TYPE
                     AddLog "Cancelled, IMPORT does NOT support aditional -KEYWORD TYPE operands", (%MsgBoth OR %MsgKeep)
                     FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
                  END IF                                          '
                  pImpName = ""                                   '
                  FOR k = j + 1 TO i                              ' Pick up remaining operands
                     pImpName += Ops(k) + " "                     ' in case a filename with embedded spaces
                  NEXT k                                          '
                  pImpName = CLIP$(RIGHT, pImpName, 1)            ' Remove trailing space
                  strUnQuote(pImpName)                            ' Remove quotes if present
                  IF ISFALSE ISFILE(pImpName) THEN                ' File better exist
                     AddLog "Cancelled, filename: " + pImpName + " cannot be found", (%MsgBoth OR %MsgKeep)
                     FUNCTION = %True: EXIT FUNCTION              ' Tell caller we failed
                  END IF                                          '
                  EXIT FOR                                        ' We're ALL done parsing
               END IF                                             '
            CASE "-IMPCOLOR"                                      ' -IMPCOLOR?
               IF (PMode AND (%PImport OR %PRepair OR %PExport OR %PExpColor)) <> 0 THEN ' Already have another mode?
                  AddLog "Cancelled, COMMAND LINE has multiple modes specified", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               IF j >= i OR LEFT$(Ops(j + 1), 1) = "-" THEN       ' Better have a tablename
                  AddLog "Cancelled, IMPCOLOR requires a Tablename operand", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               IF UCASE$(LEFT$(Ops(j + 1), 1)) <> "O" THEN        ' Better be an Options table
                  AddLog "Cancelled, IMPCOLOR only handles O...... tables", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               PMode OR= %PImpColor                               ' Set ImpColor mode
               pImpName = Ops(j + 1)                              ' Save the TableName
               INCR j                                             ' Step over it
            CASE "-REPAIR"                                        ' -REPAIR?
               IF (PMode AND (%PExport OR %PImport OR %PExpColor OR %PImpColor)) <> 0 THEN ' Already have another mode?
                  AddLog "Cancelled, COMMAND LINE has multiple modes specified", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               PMode OR= %PRepair                                 ' Set Repair mode
            CASE "-QUIET"                                         ' -QUIET?
               PMode OR= %PQuiet                                  ' Set Quiet mode
               SawQuiet = %True                                   ' Remember it
            CASE "-EXPMAX"                                        ' -EXPMAX
               IF j = i THEN                                      ' If no more operands
                  AddLog "Cancelled, -EXPMAX operand has no value", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               t = Ops(j+1)                                       ' Get next operand
               IF VERIFY(t, "0123456789") > 0 OR _                ' See if it looks OK
                  VAL(t) < 0 THEN                                 '
                  AddLog "Cancelled, -EXPMAX value IS non-numeric OR < zero", (%MsgBoth OR %MsgKeep)
                  FUNCTION = %True: EXIT FUNCTION                 ' Tell caller we failed
               END IF                                             '
               PExpMax = VAL(t)                                   ' Looks OK, save it
               SawExpMax = %True                                  ' Remember we saw it
               RegSet("Software\SPFLite", "EXPMAX", FORMAT$(pExpMax)) ' Save it in the registry
               INCR j                                             ' Step over the numeric operand

            CASE ELSE                                             ' Oops, bad operand
               AddLog "Cancelled, COMMAND LINE operand: " + Ops(j) + " IS NOT recognized", (%MsgBoth OR %MsgKeep)
               FUNCTION = %True: EXIT FUNCTION                    ' Tell caller we failed
         END SELECT                                               '
      NEXT j                                                      '
      IF (PMode AND (%PImport OR %PExport OR %PRepair OR %PExpColor OR %PImpColor)) = 0 THEN  ' Better have ended up with a mode
         PMode OR= %PExport                                       ' Set the default then
      END IF                                                      '
   ELSE                                                           ' No command line
      PMode = %PExport                                            ' Set the default
   END IF                                                         '
   IF SawExpMax AND (pExpname <> "" OR ((PMode AND %PExport) = 0)) THEN ' EXPMAX only allowed for Full Export
      AddLog "Cancelled, EXPMAX specified FOR Non, FULL-EXPORT run", (%MsgBoth OR %MsgKeep)
      FUNCTION = %True: EXIT FUNCTION                             ' Tell caller we failed
   END IF
   IF SawQuiet AND ((PMode AND %PRepair) = 1) THEN                ' QUIET not allowed for -REPAIR
      AddLog "Cancelled, QUIET specified FOR a REPAIR run", (%MsgBoth OR %MsgKeep)
      FUNCTION = %True: EXIT FUNCTION                             ' Tell caller we failed
   END IF
   t = "Running with: "                                           ' Build message                                                  '
   IF (PMode AND %PExport) THEN
      IF pExpName =  "" THEN t += "-EXPORT -EXPMAX " + FORMAT$(PExpmax) '
      IF pExpName <> "" THEN t += "-EXPORT " + pExpName
   END IF
   IF (PMode AND %PImport) THEN
      IF pImpName =  "" THEN t += "-IMPORT"
      IF pImpName <> "" THEN t += "-IMPORT " + IIF$(SawQuote, $DQ, "") + PImpName + IIF$(SawQuote, $DQ, "")
   END IF
   IF (PMode AND %PRepair) THEN t += "-REPAIR"                    '
   IF (PMode AND %PQuiet)  THEN t += " -QUIET"                    '
   AddLog t                                                       ' Write the message
   AddLog "Running with HomeFolder: " + HomeFolder                ' Add Homefolder
   AddLog "Running with HomeData  : " + HomeData                  ' And HomeData
END FUNCTION

SUB      LoadBKP()
'--------------------------------------------------------------------------------------------------+
'- Do the BKP table entries                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, tID, tName AS STRING
   AddLog IIF$(Pass = 1, "Validating table: ", "Loading table: ") + IPName, %MsgLog
   IF Pass = 2 THEN                                               ' Only on Pass 2
      tID = LEFT$(IPName, 1): tName = MID$(IPName, 2)             ' Get table type and name
      SQL.BkpName = tName                                         ' Set the SQL full table name
      SQL.Execute("PRAGMA synchronous = OFF")                     ' To optimize things
      SQL.TableClear(IPName)                                      ' Clear the existing table
      IF IPCtr = 0 THEN                                           ' Empty?
         SQL.AddString(tID, "R00000", "0")                        ' Write zero
      ELSE                                                        ' Else write what's there
         SQL.AddString(tID, "R00000", IP(1))                      ' Write the Total # entries
         FOR i = 2 TO IPCtr                                       ' Dump the Table
            SQL.AddString(tID, "R" + FORMAT$(i, "00000"), IP(i))  '
         NEXT i                                                   '
      END IF                                                      '
      SQL.Execute("PRAGMA synchronous = ON")                      '
   END IF                                                         '
END SUB

FUNCTION LoadKBD() AS LONG
'--------------------------------------------------------------------------------------------------+
'- Do the KBD table file                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, RNum AS LONG, tID, tName AS STRING
   AddLog IIF$(Pass = 1, "Validating table: ", "Loading table: ") + IPName, %MsgLog
   j = 0
   tID = LEFT$(IPName, 1): tName = MID$(IPName, 2)                ' Get table type and name
   SQL.KbdName = tName                                            ' Set the SQL full table name

   IF IPCtr <> 963 THEN                                           ' Better be the right size
      AddLog "Keyboard table FOR: |K" + IPNAME + "|B has incorrect record count", (%MsgBoth OR %MsgKeep)
      FUNCTION = %True                                            ' Say we failed
      EXIT FUNCTION                                               '
   END IF                                                         '

   FOR i = 1 TO 963 STEP 9                                        ' See if in sets of 9
      INCR j                                                      ' Bump index to Keys table
      IF TRIM$(MID$(IP(i), 6, 7)) <> Keys(j) OR _                 '
         TRIM$(MID$(IP(i+1), 6, 7)) <> Keys(j) OR _               '
         TRIM$(MID$(IP(i+2), 6, 7)) <> Keys(j) OR _               '
         TRIM$(MID$(IP(i+3), 6, 7)) <> Keys(j) OR _               '
         TRIM$(MID$(IP(i+4), 6, 7)) <> Keys(j) OR _               '
         TRIM$(MID$(IP(i+5), 6, 7)) <> Keys(j) OR _               '
         TRIM$(MID$(IP(i+6), 6, 7)) <> Keys(j) OR _               '
         TRIM$(MID$(IP(i+7), 6, 7)) <> Keys(j) THEN               '
         AddLog "Keyboard table FOR: |K" + IPNAME + "|B has mis-matched OR OUT of sequence Key sets", (%MsgBoth OR %MsgKeep)
         FUNCTION = %True                                         ' Say we failed
         EXIT FUNCTION                                            '
      END IF                                                      '
   NEXT

   '-----------------------------------------------------------------------------------------------+
   '- Delete the old data                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF Pass = 2 THEN                                               ' Only if Pass 2
      SQL.Execute("PRAGMA synchronous = OFF")                     ' To optimize things
      SQL.TableClear(IPName)                                      ' Clear the existing table
      SQL.AddString(tID, "R00000", "1070")                        ' Write the Total # entries
      RNum = 0                                                    ' Reset record num
      FOR i = 1 TO IPCtr STEP 9                                   ' Process the entries
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), "; ------------- " + RTRIM$(MID$(IP(i), 6, 7)))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 1), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 2), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 3), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 4), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 5), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 6), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 7), 20))
         INCR RNum                                                ' Bump Record number
         SQL.AddString(tID, "R" + FORMAT$(RNum, "00000"), MID$(IP(i + 8), 20))
      NEXT i                                                      '
      SQL.Execute("PRAGMA synchronous = ON")                      '
   END IF                                                         '
END FUNCTION

SUB LoadKeys()
'--------------------------------------------------------------------------------------------------+
'- Load the table of Keyboard key names                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG
   FOR i = 1 TO 107
      Keys(i) = READ$(i)
   NEXT i
   DATA "ESC", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10"
   DATA "F11", "F12", "PRTSCR", "SCRLK", "PAUSE", "`", "1", "2", "3", "4"
   DATA "5", "6", "7", "8", "9", "0", "-", "=", "BKSP", "TAB", "Q", "W", "E"
   DATA "R", "T", "Y", "U", "I", "O", "P", "[", "]", "ENTER", "CAPSLK", "A"
   DATA "S", "D", "F", "G", "H", "J", "K", "L", ";", "'", "\", "LSHIFT", "Z"
   DATA "X", "C", "V", "B", "N", "M", ",", ".", "/", "RSHIFT", "LCTRL"
   DATA "LWIN", "LALT", "SPACE", "RALT", "RWIN", "APPMENU", "RCTRL", "INS"
   DATA "HOME", "PGUP", "DEL", "END", "PGDN", "UP", "DOWN", "LEFT", "RIGHT"
   DATA "NUMLK", "KP/", "KP*", "KP-", "KP7", "KP8", "KP9", "KP+", "KP4"
   DATA "KP5", "KP6", "KP1", "KP2", "KP3", "KPENTER", "KP0", "KP.", "LMB"
   DATA "MMB", "RMB",

END SUB

SUB      LoadEFT()
'--------------------------------------------------------------------------------------------------+
'- Do the EFT table entries                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, tID, tName, LH, RH AS STRING
   AddLog IIF$(Pass = 1, "Validating table: ", "Loading table: ") + IPName, %MsgLog
   tID = LEFT$(IPName, 1): tName = MID$(IPName, 2)                ' Get table type and name
   IF Pass = 2 THEN                                               ' Only load if Pass 2
      IF ISFALSE SQL.TableExist(IPName) THEN                      ' If Table doesn't exist
         SQL.TableCopy(tID + "DEFAULT", IPName)                   ' Create it now from the default
      END IF                                                      '
      SQL.SetName = tName                                         ' Set the SQL full table name
      SQL.Execute("PRAGMA synchronous = OFF")                     ' To optimize things
      SQL.TableClear(IPName)                                      ' Clear the existing table
      IF IPCtr = 0 THEN                                           ' Empty?
         SQL.AddString(tID, "R00000", "0")                        ' Write zero
      ELSE                                                        ' Else write what's there
         SQL.AddString(tID, "R00000", IP(1))                      ' Write the Total # entries
         FOR i = 2 TO IPCtr                                       ' Dump the Table
            SQL.AddString(tID, "R" + FORMAT$(i, "00000"), IP(i))  '
         NEXT i                                                   '
      END IF                                                      '
      SQL.Execute("PRAGMA synchronous = ON")                      '
   END IF                                                         '
END SUB

FUNCTION LoadOpt() AS LONG
'--------------------------------------------------------------------------------------------------+
'- Do the OPT table files                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, l, INICtr AS LONG, tID, tName, LH, RH, RC, NewIP, SrchAns, INIKW(), INIValue() AS STRING
   DIM INIKW(1 TO 2000) AS STRING
   DIM INIValue(1 TO 2000) AS STRING
   AddLog IIF$(Pass = 1, "Validating table: ", "Loading table: ") + IPName, %MsgLog

   tID = LEFT$(IPName, 1): tName = MID$(IPName, 2)                ' Get table type and name
   IF tID = "O" THEN SQL.OptName = tName                          ' Set the SQL full table name

   FOR i = 1 TO IPCtr                                             ' See if the keywords look OK
      IF IP(i) = "" THEN ITERATE FOR                              ' Skip in Pass 2 if a Null'ed entry FROM Pass 1
      j = INSTR(IP(i), "=")                                       ' Find the = sign
      LH = LEFT$(IP(i), j - 1)                                    ' Separate the LH and RH
      RH = MID$(IP(i), j + 1)                                     '
      INCR INICtr                                                 ' Add to INI tables
      INIKW(INICtr) = LH: INIValue(INICtr) = RH                   '
      RC = SrchKW(LH, RH, "O")                                    ' Ask SrchKW TO validate it
      IF LEFT$(RC, 1) = "0" THEN ITERATE FOR                      ' If OK, onward to next item

      '--------------------------------------------------------------------------------------------+
      '- Something's wrong                                                                         |
      '--------------------------------------------------------------------------------------------+
      IF LEFT$(RC, 1) = "8" THEN                                  ' Totally invalid KW?
         IF Pass = 1 THEN                                         ' Tell User on Pass 1
            AddLog "Table: " + IPName + ", Entry: " + IP(i) + ", is an invalid Keyword, The entry will be ignored", (%MsgLog OR %MsgKeep)
            INCR ImpFixed                                         ' Count fixed items
         END IF                                                   '
         IP(i) = ""                                               ' Null entry
         ITERATE FOR                                              ' Continue
      END IF                                                      '
      IF LEFT$(RC, 1) = "4" THEN                                  ' Corrected entry?
         NewIP = LH + "=" + MID$(RC, 2)                           ' Build new entry
         IF Pass = 1 THEN                                         ' If Pass 1, tell user
            AddLog "Table: " + IPName + ", Entry: " + IP(i) + ", is invalid, It will be corrected TO: " + MID$(RC, 2), (%MsgLog OR %MsgKeep)
            INCR ImpFixed                                         ' Count fixed items
         END IF                                                   '
         IP(i) = NewIP                                            ' Corect the entry
         ITERATE FOR                                              ' Continue
      END IF                                                      '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Delete the old data                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF Pass = 2 THEN                                               ' Only on Pass 2
      IF ISFALSE SQL.TableExist(IPName) THEN                      ' If Table doesn't exist
         SQL.TableCopy(tID + "DEFAULT", IPName)                   ' Create it now from the default
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Add in the provided values                                                                |
      '--------------------------------------------------------------------------------------------+
      SQL.Execute("PRAGMA synchronous = OFF")                     ' To optimize things
      SQL.TableClear(IPName)                                      ' Clear the existing table
      FOR i = 1 TO IPCtr                                          ' Process the entries
         j = INSTR(IP(i), "=")                                    ' Find the = sign
         LH = LEFT$(IP(i), j - 1)                                 ' Separate the LH and RH
         RH = MID$(IP(i), j + 1)                                  '
         SQL.AddString(tID, LH, RH)                               ' Add this entry
      NEXT i                                                      '
      SQL.Execute("PRAGMA synchronous = ON")                      '

      '--------------------------------------------------------------------------------------------+
      '- Now check that an entry exists for all items in the Kwd table                             |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO Kwd.KCtr                                       ' Spin through the KWD table
         Kwd.GetByIX(lclK, k)                                     ' Get a lcl copy
         IF lclK.TType = tID THEN                                 ' Proper keyword type for this table?
            ARRAY SCAN INIKW() FOR INICtr, COLLATE UCASE, = TRIM$(lclK.Name), TO l
            IF l = 0 THEN                                         ' We didn't have THIS one
               SQL.OptName = MID$(IPName, 2)                      ' Set the SQL full table name
               SrchAns = lclK.DefaultStr                          ' Get the default
               SQL.AddString(tID, TRIM$(lclK.Name), SrchAns)      ' Add the entry
               AddLog "Table: " + IPname + ", Entry: " + lclK.Name + " was missing and added with the DEFAULT of: " + IIF$(SrchAns = "", "*NULL*", SrchAns), (%MsgLog OR %MsgKeep)
               INCR ImpFixed                                      ' Count fixed items
            END IF                                                '
         END IF                                                   '
      NEXT k                                                      '

   END IF                                                         '
END FUNCTION

FUNCTION LoadPrf() AS LONG
'--------------------------------------------------------------------------------------------------+
'- Do the Prof table files                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, l, INICtr AS LONG, LH, RH, RC, NewIP, SrchAns, INIKW(), INIValue(), t AS STRING
   DIM INIKW(1 TO 2000) AS STRING
   DIM INIValue(1 TO 2000) AS STRING
   AddLog IIF$(Pass = 1, "Validating table: ", "Loading table: ") + IPName, %MsgLog

   FOR i = 1 TO IPCtr                                             ' See if the keywords look OK
      IF IP(i) = "" THEN ITERATE FOR                              ' Skip in Pass 2 if a Null'ed entry FROM Pass 1
      j = INSTR(IP(i), "=")                                       ' Find the = sign
      LH = LEFT$(IP(i), j - 1)                                    ' Separate the LH and RH
      RH = MID$(IP(i), j + 1)                                     '
      INCR INICtr                                                 ' Add to INI tables
      INIKW(INICtr) = LH: INIValue(INICtr) = RH                   '
      RC = SrchKW(LH, RH, "P")                                    ' Ask SrchKW TO validate it
      IF LEFT$(RC, 1) = "0" THEN ITERATE FOR                      ' If OK, onward to next item

      '--------------------------------------------------------------------------------------------+
      '- Something's wrong                                                                         |
      '--------------------------------------------------------------------------------------------+
      IF LEFT$(RC, 1) = "8" THEN                                  ' Totally invalid KW?
         IF Pass = 1 THEN                                         ' Tell User on Pass 1
            AddLog "Table: " + IPName + ", Entry: " + IP(i) + ", is an invalid Keyword, The entry will be ignored", (%MsgLog OR %MsgKeep)
            INCR ImpFixed                                         ' Count fixed items
         END IF                                                   '
         IP(i) = ""                                               ' Null entry
         ITERATE FOR                                              ' Continue
      END IF                                                      '
      IF LEFT$(RC, 1) = "4" THEN                                  ' Corrected entry?
         NewIP = LH + "=" + MID$(RC, 2)                           ' Build new entry
         IF Pass = 1 THEN                                         ' If Pass 1, tell user
            AddLog "Table: " + IPName + ", Entry: " + IP(i) + ", is invalid, It will be corrected TO: " + MID$(RC, 2), (%MsgLog OR %MsgKeep)
            INCR ImpFixed                                         ' Count fixed items
         END IF
         IP(i) = NewIP                                            ' Correct the entry
         ITERATE FOR                                              ' Continue
      END IF                                                      '
   NEXT i                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Delete the old data                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF Pass = 2 THEN                                               ' Only on Pass 2
      IF ISFALSE SQL.TableExist(IPName) THEN                      ' If Table doesn't exist
         SQL.TableCopy("PDEFAULT", IPName)                        ' Create it now from the default
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Add in the provided values                                                                |
      '--------------------------------------------------------------------------------------------+
      SQL.Execute("PRAGMA synchronous = OFF")                     ' To optimize things
      SQL.TableClear(IPName)                                      ' Clear the existing table
      FOR i = 1 TO IPCtr                                          ' Process the entries
         j = INSTR(IP(i), "=")                                    ' Find the = sign
         LH = LEFT$(IP(i), j - 1)                                 ' Separate the LH and RH
         RH = MID$(IP(i), j + 1)                                  '
         SQL.AddStringDirect(IPName, LH, RH)                      ' Add this entry
      NEXT i                                                      '
      SQL.Execute("PRAGMA synchronous = ON")                      '

      '--------------------------------------------------------------------------------------------+
      '- Now check that an entry exists for all items in the Kwd table                             |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO Kwd.KCtr                                       ' Spin through the KWD table
         Kwd.GetByIX(lclK, k)                                     ' Get local copy
         IF lclK.TType = "P" THEN                                 ' Proper keyword type for this table?
            ARRAY SCAN INIKW() FOR INICtr, COLLATE UCASE, = TRIM$(lclK.Name), TO l
            IF l = 0 THEN                                         ' We didn't have THIS one
               SrchAns = lclK.DefaultStr                          ' Get the default
               SQL.AddStringDirect(IPName, TRIM$(lclK.Name), SrchAns) ' Add the entry
               AddLog "Table: " + IPname + ", Entry: " + lclK.Name + " was missing and added with the DEFAULT of: " + IIF$(SrchAns = "", "*NULL*", SrchAns), (%MsgLog OR %MsgKeep)
               INCR ImpFixed                                      ' Count fixed items
            END IF                                                '
         END IF                                                   '
      NEXT k                                                      '

   END IF                                                         '
END FUNCTION

SUB      LoadRet()
'--------------------------------------------------------------------------------------------------+
'- Do the RTR table entries                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, tID, tName AS STRING
   AddLog IIF$(Pass = 1, "Validating table: ", "Loading table: ") + IPName, %MsgLog
   tID = LEFT$(IPName, 1): tName = MID$(IPName, 2)                ' Get table type and name
   IF Pass = 2 THEN                                               ' Only load if Pass 2
      IF ISFALSE SQL.TableExist(IPName) THEN                      ' If Table doesn't exist
         SQL.TableCopy(tID + "DEFAULT", IPName)                   ' Create it now from the default
      END IF                                                      '
      SQL.RtrName = tName                                         ' Set the SQL full table name
      SQL.Execute("PRAGMA synchronous = OFF")                     ' To optimize things
      SQL.TableClear(IPName)                                      ' Clear the existing table
      IF IPCtr = 0 THEN                                           ' Empty?
         SQL.AddString(tID, "R00000", "0")                        ' Write zero
      ELSE                                                        ' Else write what's there
         SQL.AddString(tID, "R00000", IP(1))                      ' Write the Total # entries
         FOR i = 2 TO IPCtr                                       ' Dump the Table
            SQL.AddString(tID, "R" + FORMAT$(i, "00000"), IP(i))  '
         NEXT i                                                   '
      END IF                                                      '
      SQL.Execute("PRAGMA synchronous = ON")                      '
   END IF                                                         '
END SUB

SUB      LoadSet()
'--------------------------------------------------------------------------------------------------+
'- Do the SET table entries                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, tID, tName AS STRING
   AddLog IIF$(Pass = 1, "Validating table: ", "Loading table: ") + IPName, %MsgLog
   tID = LEFT$(IPName, 1): tName = MID$(IPName, 2)                ' Get table type and name
   IF Pass = 2 THEN                                               ' Only load if Pass 2
      IF ISFALSE SQL.TableExist(IPName) THEN                      ' If Table doesn't exist
         SQL.TableCopy(tID + "DEFAULT", IPName)                   ' Create it now from the default
      END IF                                                      '
      SQL.SetName = tName                                         ' Set the SQL full table name
      SQL.Execute("PRAGMA synchronous = OFF")                     ' To optimize things
      SQL.TableClear(IPName)                                      ' Clear the existing table
      IF IPCtr = 0 THEN                                           ' Empty?
         SQL.AddString(tID, "R00000", "0")                        ' Write zero
      ELSE                                                        ' Else write what's there
         SQL.AddString(tID, "R00000", IP(1))                      ' Write the Total # entries
         FOR i = 2 TO IPCtr                                       ' Dump the Table
            SQL.AddString(tID, "R" + FORMAT$(i, "00000"), IP(i))  '
         NEXT i                                                   '
      END IF                                                      '
      SQL.Execute("PRAGMA synchronous = ON")                      '
   END IF                                                         '
END SUB

FUNCTION PCRE_Regex_Compile(str1 AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Compile / Test a Regex string                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL txtP AS ASCIIZ PTR

   IF hPCRE <> 0 THEN                                             ' Any prior area? Free it
      TRY                                                         ' Lets not crash
         FREE hPCRE                                               ' Free it one way
      CATCH                                                       ' Oops, try the other way
         CALL DWORD hProc_PCRE_Free_Ptr USING pcre_free( _        ' Free it
                    hPCRE)                                        ' Compile handle
      FINALLY                                                     '
         hPCRE = 0                                                ' Regardless, zero the pointer
      END TRY                                                     '
   END IF                                                         '
   PCRE_Options = %PCRE_CASELESS                                  ' Set Options
   PCRE_Regex_Str2 = str1 + CHR$(0)                               ' Make into pseudo ASCIIZ
   CALL DWORD hProc_PCRE_Compile USING pcre_compile( _            ' Try the compile
              BYVAL STRPTR(PCRE_Regex_Str2), _                    ' Regex string
              BYVAL PCRE_Options,            _                    ' Options
              BYVAL VARPTR(PCRE_ErrPtr),     _                    ' Pointer to error string
              BYVAL VARPTR(PCRE_ErrOffsetPtr),_                   ' Error offset
              BYVAL &0) _                                         ' Character tables
              TO hPCRE                                            ' Answer area
   IF hPCRE = 0 THEN                                              ' OK?
      txtp = PCRE_ErrPtr                                          ' No, get error message
      FUNCTION = "at COL: " + FORMAT$(PCRE_ErrOffsetPtr + 1) + " : " +  @Txtp
      EXIT FUNCTION                                               '
   END IF                                                         '
   FUNCTION = ""                                                  ' Return null to indicate OK
END FUNCTION

SUB PCRE_Regex_Test(str1 AS STRING, scol AS LONG, fcol AS LONG, flen AS LONG)
'--------------------------------------------------------------------------------------------------+
'- PCRE regex test                                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL strt, RC AS LONG, lclPCRE AS DWORD
LOCAL optr AS BYTE PTR
   strt = scol - 1                                                ' Calc start column
   optr = VARPTR(PCRE_Offsets(0))                                 ' Point at answer array
   CALL DWORD hProc_PCRE_Exec USING pcre_exec( _                  ' Call for the test
              hPCRE,                           _                  ' Compile handle
              &0,                              _                  ' extra-data
              STRPTR(str1),                    _                  ' Test-string
              LEN(str1),                       _                  ' length of Test-srtring
              strt,                            _                  ' Starting position
              &0,                              _                  ' Options
              optr,                            _                  ' PCRE_Offsets array
              &12)                             _                  ' Size of offsets array
              TO RC                                               ' Answer area

   IF RC < 1 THEN                                                 ' How'd search go?
      fcol = 0: flen = 0                                          ' Not found
   ELSE                                                           '
      fcol = PCRE_Offsets(0) + 1                                  ' Pass back column found in
      flen = PCRE_Offsets(1) - PCRE_Offsets(0)                    ' And length
   END IF                                                         '
END SUB

FUNCTION RegGet(BYVAL sSubKeys AS STRING, BYVAL sValueName AS STRING, BYVAL sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Get a key from the Registry                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lKey AS DWORD, zRegVal AS ASCIIZ * 1024, dwType AS DWORD, dwSize AS DWORD
   zRegVal = sDefault                                             '
   IF (RegOpenKeyEx(%HKEY_CURRENT_USER, TRIM$(sSubKeys, "\"), 0, %KEY_READ, lKey) = %ERROR_SUCCESS) THEN
      dwType = %REG_SZ                                            '
      dwSize = SIZEOF(zRegVal)                                    '
      RegQueryValueEx(lKey, BYCOPY sValueName, 0, dwType, zRegVal, dwSize)
      RegCloseKey lKey                                            '
   END IF                                                         '
   FUNCTION = zRegVal                                             '
END FUNCTION

FUNCTION RegSet(BYVAL sSubKeys AS STRING, BYVAL sValueName AS STRING, BYVAL sData AS STRING) AS LONG
'--------------------------------------------------------------------------------------------------+
'- Set a key into the Registry                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lKey AS DWORD, zRegName AS ASCIIZ * 1024, zRegVal AS ASCIIZ * 1024, dwType AS DWORD, dwSize AS DWORD
   zRegVal = sData                                                '
   zRegName = sValueName                                          '
   IF RegCreateKeyEx(%HKEY_CURRENT_USER, TRIM$(sSubKeys, "\"), 0, "", 0, %KEY_WRITE, BYVAL %Null, _
                     lKey, BYVAL %Null) = %ERROR_SUCCESS THEN     '
      dwSize = SIZEOF(zRegVal)                                    '
      dwType = %REG_SZ                                            '
      IF RegSetValueEx(lKey, zRegName, 0, dwType, zRegVal, dwSize) = %ERROR_SUCCESS THEN FUNCTION = %True
      RegCloseKey lKey                                            '
   END IF                                                         '
END FUNCTION

SUB     Retention()
'--------------------------------------------------------------------------------------------------+
'- Apply Retention test to the Export files                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG
LOCAL RetTbl() AS STRING, RetCtr AS LONG
LOCAL TSTFileName, FileType, t, u AS STRING
LOCAL RetFD AS DIRDATA

DIM RetTbl(1 TO 100) AS STRING
   AddLog "Performing retention of EXPORT files, USING EXPMAX=" + FORMAT$(PExpMax), %MsgLog
   FileType = "Exp"                                               ' Lets do the Export files
   GOSUB DoRet                                                    '

   AddLog "Performing retention of LOG files, USING EXPMAX=" + FORMAT$(PExpMax), %MsgLog
   FileType = "Log"                                               ' Lets do the Log files
   GOSUB DoRet                                                    '
   EXIT SUB                                                       '

DoRet:
   '-----------------------------------------------------------------------------------------------+
   '- Find all existing Backups                                                                    |
   '-----------------------------------------------------------------------------------------------+
   TSTFileName = HomeFolder + "\CFGMaint " + FileType + "*.TXT"   ' Build generic find our files
   u = PCRE_Regex_Compile("\ [0-9]{4}\-[0-9]{2}\-[0-9]{2}\ [0-9]{2}\.[0-9]{2}") ' Look for our timestamp pattern
   t = DIR$(TSTFileName, TO RetFD)                                ' Look for the files
   DO WHILE ISNOTNULL(t)                                          ' While we're getting entries
      PCRE_Regex_Test(t, 1, j, k)                                 ' See if has our pattern
      IF J THEN                                                   ' A Match?
         IF INSTR(t, "[") = 0 THEN                                ' Ignore single table-name exports
            INCR RetCtr                                           ' Bump counter
            IF RetCtr > UBOUND(RetTbl()) THEN REDIM PRESERVE RetTbl(1 TO 2 * RetCtr) AS STRING
            RetTbl(RetCtr) = HomeData + "\" + t                   ' Stuff data into the table
         END IF                                                   '
      END IF                                                      '
      t = DIR$(NEXT)                                              ' Get next entry
   LOOP                                                           ' Done the search
   ARRAY SORT RetTbl() FOR RetCtr, COLLATE UCASE                  ' Sort to get in date order

   FOR i = 1 TO RetCtr - PExpMax                                  ' Loop through the 1st part of the table
      KILL RetTbl(i)                                              ' Kill the old ones
      AddLog "Retention has removed: " + RetTbl(i), %MsgLog
      t = RetTbl(i)                                               ' Get the name
   NEXT i                                                         ' Loop back
   RetCtr = 0                                                     ' Reset counter for next pass
   RETURN                                                         '
END SUB

FUNCTION SrchKW(sKW AS STRING, sValue AS STRING, TblID AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- See if Keyword is valid                                                                         |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG
LOCAL ValAddr AS DWORD, RC AS LONG, Ret AS STRING
   rc = Kwd.GetByName(lclK, sKW)                                  ' Go get it
   IF RC = 8 THEN FUNCTION = "8": EXIT FUNCTION                   ' Null string?  Not found

   '-----------------------------------------------------------------------------------------------+
   '- Validate the data                                                                            |
   '-----------------------------------------------------------------------------------------------+
   IF lclK.TType <> "?" THEN                                      ' If not the 'any table' type
      IF lclK.TType <> TblID THEN                                 ' In the correct table?
         FUNCTION = "8"                                           ' Return invalid keyword
         EXIT FUNCTION                                            ' Can't do anything else
      END IF                                                      '
   END IF                                                         '
   ValAddr = Kwd.GetCPtr(lclK.ValidateIX)                         ' Get Routine address
   CALL DWORD ValAddr USING ValAAA(sKW, sValue, TRIM$(lclK.ValidateStr), TRIM$(lclK.DefaultStr)) TO Ret   ' Call the routine
   IF LEFT$(Ret, 1) = "0" THEN                                    ' Exit if all OK
      IF (PMode AND (%PExpColor OR %PImpColor)) THEN              ' A COLOR Import/Export run?
         FUNCTION = "0" + lclK.ColorType                          ' Add COLOR flag to the answer
      ELSE                                                        '
         FUNCTION = Ret                                           ' Pass back OK
      END IF                                                      '
      EXIT FUNCTION                                               '
   END IF                                                         '
   FUNCTION = "4" + MID$(Ret, 2)                                  ' Pass back the correction
END FUNCTION

FUNCTION ValAAA(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Model method to use in CALL DWORD USING                                                         |
'--------------------------------------------------------------------------------------------------+
END FUNCTION

FUNCTION V1Char(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a single non-null                                                                        |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   IF LEN(TRIM$(sValue)) = 1 THEN                                 ' Must be 1 character
      FUNCTION = "0"                                              ' Set RC=0
   ELSE                                                           ' Handle error
      FUNCTION = "8" + sDefault                                   ' error, pass back the default
   END IF                                                         '
END FUNCTION

FUNCTION VAny(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Allow anything                                                                                  |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "0"                                                 ' Everything is OK
END FUNCTION

FUNCTION VCommaNum(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is a number, commas allowed                                                         |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   IF VERIFY(sValue, "0123456789,-") = 0 THEN                     ' Validate it's numeric + ,-
      FUNCTION = "0"                                              '
   ELSE                                                           '
      FUNCTION = "4" + sDefault                                   ' Else pass back correction
   END IF                                                         '
END FUNCTION

FUNCTION VDate(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is a dd-mm-yyyy                                                                     |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "4" + sDefault                                      ' Set as a correction entry
   IF LEN(sValue) <> 10 THEN EXIT FUNCTION                        ' Fail if incorrect length
   IF MID$(sValue, 3, 1) <> "-" THEN EXIT FUNCTION                ' Or format errors
   IF MID$(sValue, 6, 1) <> "-" THEN EXIT FUNCTION                '
   IF VERIFY(MID$(sValue, 1, 2), "0123456789") <> 0 THEN EXIT FUNCTION   ' Validate dd
   IF VERIFY(MID$(sValue, 4, 2), "0123456789") <> 0 THEN EXIT FUNCTION   ' Validate mm
   IF VERIFY(MID$(sValue, 7, 4), "0123456789") <> 0 THEN EXIT FUNCTION   ' Validate yyyy
   FUNCTION = "0"                                                 ' Mark it as OK
END FUNCTION

FUNCTION VEOL(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a valid EOL                                                                              |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   IF sValue = "CRLF" OR sValue = "CR"   OR sValue = "LF"     OR _
      sValue = "NL"   OR sValue = "AUTO" OR sValue = "AUTONL" OR _
      sValue = "NONE" THEN FUNCTION = "0": EXIT FUNCTION          ' It's OK, one of the normal ones
   IF LEN(sValue) = 2 OR LEN(sValue) = 4 AND VERIFY(sValue, "0123456789ABCDEF") = 0 THEN FUNCTION = "0": EXIT FUNCTION ' Or valid HEX
   FUNCTION = "4" + sDefault                                      ' Else pass back correction
END FUNCTION

FUNCTION VFMLayout(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a valid FM Layout string                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING
LOCAL i, j AS LONG
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   t = VLayout(sValue)                                            ' Go do full validation
   IF LEFT$(t, 1) = "0" THEN                                      ' OK?
      FUNCTION = "0"                                              ' Pass back the OK
   ELSE                                                           '
      FUNCTION = "4" + sDefault                                   ' Else pass back correction
   END IF                                                         '
END FUNCTION

FUNCTION VFileLine(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a single non-null, blank allowed                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "0"                                                 ' Start off as all OK
   t = PARSE$(sValue, ",", 1)                                     ' Get 1st word
   IF t = "LEFT" OR t = "RIGHT" OR t = "CENTER" OR t = "CENTRE" THEN EXIT FUNCTION
   FUNCTION = "4" + sDefault                                      ' Else pass back correction
END FUNCTION

FUNCTION VInvChar(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a single non-null, blank allowed                                                         |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "0"                                                 ' Start off as all OK
   IF LEN(sValue) = 1 THEN EXIT FUNCTION                          ' Must be 1 character
   FUNCTION = "4" + sDefault                                      ' Else pass back correction
END FUNCTION

FUNCTION VKillQ(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a non-null                                                                               |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   IF LEN(TRIM$(sValue)) >= 2 AND LEFT$(sValue, 1) = $DQ AND RIGHT$(sValue, 1) = $DQ THEN sValue = MID$(sValue, 2, LEN(sValue) - 2)
   FUNCTION = "0"                                                 ' Say it's OK
END FUNCTION

FUNCTION VList(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is in the Operand list                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL Ops() AS STRING
LOCAL i, j AS LONG
   FUNCTION = "0"                                                 ' Default to OK
   i = PARSECOUNT(sOperand, ",")                                  ' Get operand count
   DIM Ops(1 TO i) AS STRING                                      ' DIM the table
   PARSE sOperand, Ops(), ","                                     ' Parse it out
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FOR j = 1 TO i                                                 ' Ensure the operand is valid
      IF UCASE$(sValue) = Ops(j) THEN EXIT FUNCTION               ' If OK, exit
   NEXT j                                                         '
   FUNCTION = "4" + sDefault                                      ' Else pass back the default
END FUNCTION

FUNCTION VNonNull(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a non-null                                                                               |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   IF LEN(TRIM$(sValue)) > 0 THEN FUNCTION = "0": EXIT FUNCTION   ' If non-null, it's OK
   FUNCTION = "4" + sDefault                                      ' Else ass back the correction
END FUNCTION

FUNCTION VNumeric(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is numeric                                                                          |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "0"                                                 ' Default to OK
   IF VERIFY(sValue, "-0123456789") = 0 THEN EXIT FUNCTION        ' Validate it's numeric
   IF LEFT$(sValue, 2) = "&H" OR LEFT$(sValue, 2) = "&h" THEN     ' Possible Hex?
      IF VERIFY(MID$(sValue, 3), "0123456789ABCDEFabcdef") = 0 THEN EXIT FUNCTION
   END IF                                                         '
   FUNCTION = "4" + sDefault                                      ' Else pas back correction
END FUNCTION

FUNCTION VOnOff(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is ON/OFF                                                                           |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "0"                                                 ' Default to OK
   IF sValue = "0" OR sValue = "1" THEN EXIT FUNCTION             ' Pass if 0 or 1
   FUNCTION = "4" + sDefault                                      ' Else return the correction
END FUNCTION

FUNCTION VPerNum(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is a number, periods allowed                                                        |
'--------------------------------------------------------------------------------------------------+
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "0"                                                 ' Default to OK
   IF VERIFY(sValue, "0123456789.") = 0 THEN EXIT FUNCTION        ' Validate it's numeric + .
   FUNCTION = "4" + sDefault                                      ' Else pass back correction
END FUNCTION

FUNCTION VRange(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is within a numeric range                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL Ops() AS STRING
LOCAL i, j AS LONG
   i = PARSECOUNT(sOperand, ",")                                  ' Get operand count
   DIM Ops(1 TO i) AS STRING                                      ' DIM the table
   PARSE sOperand, Ops(), ","                                     ' Parse it out
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "4" + sDefault                                      ' Default to a correction
   IF VERIFY(sValue, "0123456789") <> 0  THEN EXIT FUNCTION       ' Pass back correction if not even numeric
   IF VAL(sValue) < VAL(Ops(1)) OR VAL(sValue) > VAL(Ops(2)) THEN EXIT FUNCTION ' Pass back correction if not in range
   FUNCTION = "0"                                                 ' Else say it's OK
END FUNCTION

FUNCTION VSBLayout(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Ensure a valid FM Layout string                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL Ops(), t AS STRING
LOCAL i, j, k AS LONG
   IF sValue = "$Default" THEN FUNCTION = "8" + sDefault: EXIT FUNCTION ' Just pass the default if asked
   i = PARSECOUNT(sValue, ",")                                    ' Get number of values
   DIM Ops(1 TO i) AS STRING                                      ' DIM the table
   PARSE sValue, Ops(), ","                                       ' Parse it out
   FOR j = 1 TO i                                                 ' Verify each value
      k = INSTR(Ops(j), "(")                                      ' A trailing (nn)?
      IF k THEN                                                   ' Yes
         t = MID$(Ops(j), k + 1): IF RIGHT$(t, 1) = ")" THEN t = CLIP$(RIGHT, t, 1) ' Extract nn
         Ops(j) = LEFT$(Ops(j), k - 1)                            ' Extract kwd
      END IF                                                      '
      IF VERIFY(t, "0123456789") <> 0  THEN FUNCTION = "4" + sDefault: EXIT FUNCTION
      IF Ops(j) = "BNDS"   OR Ops(j) = "CAPS"   OR Ops(j) = "CASE"    OR _
         Ops(j) = "CHANGE" OR Ops(j) = "COLS"   OR Ops(j) = "EOL"     OR _
         Ops(j) = "INSOVR" OR Ops(j) = "LINES"  OR Ops(j) = "LINNO"   OR _
         Ops(j) = "MISC"   OR Ops(j) = "MODE"   OR Ops(j) = "SELECT"  OR _
         Ops(j) = "SOURCE" OR Ops(j) = "STATE" THEN ITERATE FOR   ' It's OK, continue
      FUNCTION = "4" + sDefault: EXIT FUNCTION                    ' Bad, pass back correction
   NEXT j                                                         '
   FUNCTION = "0"                                                 ' Say it's OK
END FUNCTION

FUNCTION VTStamp(sKW AS STRING, sValue AS STRING, sOperand AS STRING, sDefault AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate KW is a Last Access date yyyy-mm-dd  hh:mm                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL NewStamp AS STRING
   NewStamp = TimePretty(0)                                       ' Get a default answer
   IF sValue = "$Default" THEN FUNCTION = "8" + NewStamp: EXIT FUNCTION ' Just pass the default if asked
   FUNCTION = "4" + NewStamp                                      ' Set as a correction entry
   IF LEN(sValue) <> 17 THEN EXIT FUNCTION                        ' Fail if incorrect length
   IF MID$(sValue, 5, 1) <> "-" THEN EXIT FUNCTION                ' Or format errors
   IF MID$(sValue, 8, 1) <> "-" THEN EXIT FUNCTION                '
   IF MID$(sValue, 11, 2) <> "  " THEN EXIT FUNCTION              '
   IF MID$(sValue, 15, 1) <> ":" THEN EXIT FUNCTION               '
   IF VERIFY(MID$(sValue, 1, 4), "0123456789") <> 0 THEN EXIT FUNCTION   ' Validate yyyy
   IF VERIFY(MID$(sValue, 6, 2), "0123456789") <> 0 THEN EXIT FUNCTION   ' Validate mm
   IF VERIFY(MID$(sValue, 9, 2), "0123456789") <> 0 THEN EXIT FUNCTION   ' Validate dd
   IF VERIFY(MID$(sValue, 13, 2), "0123456789") <> 0 THEN EXIT FUNCTION  ' Validate hh
   IF VERIFY(MID$(sValue, 16, 2), "0123456789") <> 0 THEN EXIT FUNCTION  ' Validate mm
   FUNCTION = "0"                                                 ' Mark it as OK
END FUNCTION

FUNCTION VLayout(sLayout AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Validate FM screen layout parameters                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, CPos, OBPos, CBPos, OpCtr, SubCtr AS LONG
LOCAL Layout, LH, RH AS STRING
LOCAL opers(), subs() AS STRING
   DIM opers(1 TO 30) AS STRING                                   ' Dim the Opers table
   Layout = REMOVE$(sLayout, " ")                                 ' Get copy without spaces

   '-----------------------------------------------------------------------------------------------+
   '- Parse out the Layout string                                                                  |
   '-----------------------------------------------------------------------------------------------+
   DO WHILE LEN(Layout)                                           ' While still DATA IN STRING
      cPos  = INSTR(1, Layout, ",")                               ' Find first comma
      OBPos = INSTR(1, Layout, "(")                               ' Find first open bracket
      CBPos = INSTR(1, Layout, ")")                               ' Find first closing )
      IF CPos = 0 THEN CPos = LEN(Layout) + 1                     ' To handle last operand

      '--------------------------------------------------------------------------------------------+
      '- A simple keyword, style                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF OBPos = 0 OR cPos < OBPos THEN
         INCR OpCtr                                               ' Bump operand Index
         opers(OpCtr) = LEFT$(Layout, cPos - 1)                   ' Copy the operand
         Layout = MID$(Layout, CPos + 1)                          ' Remove from front of Layout
         ITERATE DO                                               ' Loop-de-loop
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- A keyword( style                                                                          |
      '--------------------------------------------------------------------------------------------+
      IF CBPos = 0 THEN FUNCTION = "8Parse ERROR ON: " + Layout: EXIT FUNCTION
      INCR OpCtr                                                  ' Bump operand Index
      opers(OpCtr) = LEFT$(Layout, CBPos)                         ' Copy the operand
      Layout = MID$(Layout, CBPos + 1)                            ' Remove from front of Layout
      IF LEFT$(Layout, 1) = "," THEN Layout = MID$(Layout, 2)     ' Also get rid of the comma if present

   LOOP

   '-----------------------------------------------------------------------------------------------+
   '- Process each Layout operand                                                                  |
   '-----------------------------------------------------------------------------------------------+
   FOR j = 1 TO OpCtr                                             ' Loop through them
      k = INSTR(opers(j), "(")                                    ' Does it have sub-operands?
      IF k THEN                                                   ' Yes
         LH = UCASE$(LEFT$(opers(j), k - 1))                      ' Separate LH and RH
         RH = MID$(opers(j), k + 1 TO LEN(opers(j)) - 1)          '
         SubCtr = PARSECOUNT(RH, ",")                             ' Get number of sub-operands
         REDIM subs(1 TO SubCtr) AS STRING                        ' Dim the Sub-Operand table
         PARSE RH, subs(), ","                                    ' Break them out
      ELSE                                                        ' No sub-ops
         LH = UCASE$(opers(j))                                    ' Just LH
         RH = "": SubCtr = 0                                      ' No RH or Sub-ops
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Operands and Sub-operands all parsed out                                                  |
      '--------------------------------------------------------------------------------------------+
      SELECT CASE AS CONST$ LH                                    ' See what field
         CASE "NAME", "PATH", "ATTR", "SIZESHORT", "SIZELONG"     ' Check 5 byte minimum fields
            IF SubCtr > 0 THEN                                    ' Got a (..) operand?
               IF SubCtr > 1 OR VAL(subs(1)) < 5 THEN             ' Verify size
                  FUNCTION = "8Invalid " + LH + " length": EXIT FUNCTION
               END IF                                             '
            END IF                                                '
         CASE "LINES", "MODE"                                     ' Check 6 byte minimum fields
            IF SubCtr > 0 THEN                                    ' Got a (..) operand?
               IF SubCtr > 1 OR VAL(subs(1)) < 6 THEN             ' Verify size
                  FUNCTION = "8Invalid LINES length": EXIT FUNCTION
               END IF                                             '
            END IF                                                '
         CASE "LWDATE", "LWDATETIME", "LRDATE", "LRDATETIME", "CRDATE", "CRDATETIME" ' Check 7 byte minimum fields
            IF SubCtr > 0 THEN                                    ' Got a (..) operand?
               IF SubCtr > 1 OR VAL(subs(1)) < 7 THEN             ' Verify size
                  FUNCTION = "8Invalid " + LH + " length": EXIT FUNCTION
               END IF                                             '
            END IF                                                '
         CASE "PRP1", "PRP2", "PRP3", "PRP4", "PRP5", "PRP6"      ' Only PRP type possible now
            IF SubCtr <> 3  THEN                                  ' Must be 3 operands
               FUNCTION = "8Invalid " + LH + " operand, must have 3 SUB-operands": EXIT FUNCTION
            END IF                                                '
            ARRAY SCAN gFMProp() FOR gFMPropNum, COLLATE UCASE, =Subs(3), TO k
            IF k = 0 THEN                                         ' Valid Property name?
               FUNCTION = "8Invalid " + LH + " operand, " + Subs(3) + " IS NOT a valid Property": EXIT FUNCTION
            END IF                                                '
            IF VAL(subs(1)) < (LEN(Subs(3)) + 1) THEN             ' Verify size
               FUNCTION = "8Invalid " + LH + " operand, length IS too short": EXIT FUNCTION
            END IF                                                '
            IF (UCASE$(Subs(2)) <> "L" AND UCASE$(subs(2)) <> "R") THEN
               FUNCTION = "8Invalid " + LH + " operand, 2nd operand must be 'L' or 'R'": EXIT FUNCTION
            END IF                                                '
        CASE ELSE
            FUNCTION = "8Invalid Operand: " + LH: EXIT FUNCTION   '

      END SELECT                                                  '

   NEXT j
   FUNCTION = "0OK"                                               ' Say we're OK
END FUNCTION

FUNCTION MyMsgBox(mTxt AS STRING, OPT mStyle AS LONG, OPT mTitle AS STRING, OPT mpitch AS LONG, OPT mBG AS LONG) AS LONG
'--------------------------------------------------------------------------------------------------+
'- Private MSGBOX equivalent with color/Font size support                                          |
'- mTxt     Text of the message                                                                    |
'-        Default text color is %RGB_BLUE.                                                         |
'-        Change anywhere with embedded |x where                                                   |
'-        x can be: "K" - %RGB_BLACK       "G" - %RGB_GREEN       "B" - %RGB_BLUE                  |
'-                  "R" - %RGB_RED         "O" - %RGB_ORANGE      "I" - %RGB_INDIGO                |
'-                  "P" - %RGB_DEEPPINK                                                            |
'-        e.g.  "This message has a |GGreen |Band |RRed |Bword in it"                              |
'-                                                                                                 |
'- mStyle   Supports                                                                               |
'-        %MB_OK                %MB_YESNO             %MB_OKCANCEL                                 |
'-        %MB_RETRYCANCEL       %MB_YESNOCANCEL       %MB_ABORTRETRYIGNORE                         |
'-        %MB_CANCELTRYCONTINUE %MB_WOPENOPENCANCEL                                                |
'-                                                                                                 |
'-        %MB_ICONERROR         %MB_ICONSTOP          %MB_ICONHAND                                 |
'-        %MB_ICONEXCLAMATION   %MB_ICONINFORMATION   %MB_ICONQUESTION                             |
'-        %MB_ICONWARNING       %MB_ICONASTERISK      %MB_USERICON                                 |
'-                                                                                                 |
'-        %MB_DEFBUTTON1        %MB_DEFBUTTON2        %MB_DEFBUTTON3                               |
'-                                                                                                 |
'- mTitle   Text for popup box Title                                                               |
'-                                                                                                 |
'- mPitch   Default size of Font for the message text                                              |
'-                                                                                                 |
'-        May be overridden FOR INDIVIDUAL lines by prefixing the line with |n                     |
'-            Where n = 1 - Standard default size                                                  |
'-                      2 - Standard * 1.25                                                        |
'-                      3 - Standard * 1.50                                                        |
'-                      4 - Standard * 1.75                                                        |
'-                      ...................                                                        |
'-                      9 - Standard * 3.00                                                        |
'-                                                                                                 |
'- mBG      Color for message Background (Default is %RGB_BEIGE                                    |
'--------------------------------------------------------------------------------------------------+

REGISTER i AS LONG
REGISTER j AS LONG
LOCAL mlist(), t, t2, bTxt, lTitle AS STRING
LOCAL hmsg, hIcon, hFont() AS DWORD
LOCAL mlisth(), mlistf(), lResult, ChrX, ChrY, TxtX, TxtY, NumLines AS LONG
LOCAL x, y, w, h, clr, lStyle, lPitch, lBG, bID, bDef, bLoc, FontIX, yPos, yMax AS LONG
DIM hFont(10) AS DWORD

   '-----------------------------------------------------------------------------------------------+
   '- Get parameters and build fonts                                                               |
   '-----------------------------------------------------------------------------------------------+
   lStyle = IIF(ISMISSING(mStyle), %MB_OK OR %MB_USERICON, mStyle)' Get Style if provided
   lTitle = IIF$(ISMISSING(mTitle), "", mTitle)                   ' Get Title if provided
   lPitch = IIF(ISMISSING(mpitch), 11, mpitch)                    ' Get pitch if provided
   lBG    = IIF(ISMISSING(mBG), %RGB_BEIGE, mBG)                  ' Get BG color if provided
   FONT NEW "Segoe UI SemiBold", 12 TO hFont(0)                   ' Build our Font for button text
   FONT NEW "Segoe UI SemiBold", lPitch TO hFont(1)               ' Build our Base Font
   FontIX = 1                                                     ' Say Base font is current

   '-----------------------------------------------------------------------------------------------+
   '- Build an empty dialog to get font sizes                                                      |
   '-----------------------------------------------------------------------------------------------+
   DIALOG NEW PIXELS, 0, lTitle, 0, 0, 20, 20 TO hmsg             ' Create the Dialog
   DIALOG SET COLOR hMsg, %RGB_BLUE, lBG                          ' Set color
   CONTROL ADD GRAPHIC, hmsg, %MMB_msg, "", 0, 0, 20, 20          ' Add the graphic text area
   GRAPHIC ATTACH hmsg, %MMB_msg                                  ' Attach it
   GRAPHIC COLOR %RGB_BLUE, lBG                                   ' Set default color
   GRAPHIC SET FONT hfont(1)                                      ' Set it to our Base Font
   ChrX = GRAPHIC(CHR.SIZE.X)                                     ' Get the average character width
   ChrY = GRAPHIC(CHR.SIZE.Y)                                     ' Get the average character height

   '-----------------------------------------------------------------------------------------------+
   '- Calc width and line height based on the supplied text / Font                                 |
   '-----------------------------------------------------------------------------------------------+
   NumLines = PARSECOUNT(mTxt, $CRLF)                             ' Get the Maximum line length
   REDIM mlist(NumLines): REDIM mlisth(NumLines): REDIM mlistf(NumLines)
   PARSE mTxt, mlist(), $CRLF                                     '
   FOR i = 0 TO NumLines                                          '
      t2 = LEFT$(mlist(i), 2)                                     'See if a Font request
      IF LEFT$(t2,1) = "|" AND INSTR("123456789", RIGHT$(t2,1)) <> 0 THEN ' Start with |n ?
         FontIX = VAL(RIGHT$(t2,1))                               ' Make it numeric
         mlistf(i) = FontIX                                       ' Save as FontIX for this line
         IF hFont(FontIX) = 0 THEN                                ' If we don't have it already
            x = lPitch * ((Fontix + 3) * .25)
            FONT NEW "Segoe UI SemiBold", lPitch * ((Fontix + 3) * .25) TO hFont(FontIX) ' Build a scaled version
         END IF                                                   '
         GRAPHIC SET FONT hfont(FontIX)                           ' Set it to the new font
         mlist(i) = MID$(mlist(i), 3)                             ' Remove /n
      END IF                                                      '
      j = GRAPHIC(TEXT.SIZE.X, mlist(i))                          '
      TxtX = MAX(j, TxtX)                                         '
      mlisth(i) = MAX(GRAPHIC(TEXT.SIZE.Y, mlist(i)), ChrY)       ' Save height of this line
      yMax += mlisth(i)                                           ' Accum total height
   NEXT i                                                         '

   TxtX += 90: TxtX = MAX(txtX, 340)                              ' Add 90 for Icon + Left/Right margins; ensure size for buttons
   TxtY = MAX(yMax + 10, 40)                                      ' Get total height for all lines - Minimum 40 for Icon

   '-----------------------------------------------------------------------------------------------+
   '- Resize now to actual size needed                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG SET CLIENT hmsg, TxtX, TxtY + 30                        ' Resize dialog (+ 30 for buttons)
   CONTROL SET SIZE hmsg, %MMB_msg, TxtX, TxtY                    ' Resize the text area

   '-----------------------------------------------------------------------------------------------+
   '- Print the text finally                                                                       |
   '-----------------------------------------------------------------------------------------------+
   ypos = IIF(NumLines = 1, (40 - ChrY) / 2, 5)                   ' Set position of line 1
   FOR i = 0 TO NumLines                                          ' Print text now
      GRAPHIC SET POS (50, yPos)                                  ' Set position of this line
      GRAPHIC SET FONT hFont(mlistf(i))                           ' Set font for this line
      t = mlist(i)                                                ' Get a working copy
      IF LEN(t) = 0 THEN GRAPHIC PRINT: GOTO lExit                ' Skip null lines
      x = 1                                                       ' Start at the left
      DO WHILE x <= LEN(t)                                        ' While still stuff IN t
         y = INSTR(x, t, "|")                                     ' Look for a color change
         IF y = 0 THEN GRAPHIC PRINT MID$(t, x);: GOTO lExit      ' No change, print remainder of line
         IF y > x THEN GRAPHIC PRINT MID$(t, x TO y - 1);         ' Print up to the |
         t2 = MID$(t, y + 1, 1)                                   ' Extract the color character
         clr = SWITCH(t2 = "O", %RGB_ORANGE, t2 = "B", %RGB_BLUE,     t2 = "R", %RGB_RED, _
                      t2 = "G", %RGB_GREEN,  t2 = "P", %RGB_DEEPPINK, t2 = "I", %RGB_INDIGO, _
                      t2 = "K", %RGB_BLACK)
         GRAPHIC COLOR clr, lBG                                   ' Set the new color
         x = y + 2                                                ' Step over |x
      LOOP                                                        ' Continue on this string
      lExit:
      yPos += mlisth(i)                                           ' Move Y down to nex line
   NEXT i                                                         ' Loop back for next line

   '-----------------------------------------------------------------------------------------------+
   '- Position the dialog                                                                          |
   '-----------------------------------------------------------------------------------------------+
   DESKTOP GET CLIENT TO w, h                                     '
   x = (w - TxtX) / 2                                             '
   y = (h - (TxtY + 30)) / 2                                      '
   DIALOG SET LOC hMsg, x, y                                      '

   '-----------------------------------------------------------------------------------------------+
   '- Add whatever buttons are needed                                                              |
   '-----------------------------------------------------------------------------------------------+
   h = TxtY + 5
   i = lStyle AND &H0000000F                                      ' Isolate low nibble for button
   j = lStyle AND &H00000F00                                      ' Isolate 3rd nibble for button default
   IF i = %MB_YESNOCANCEL THEN
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Yes:      bTxt = "&Yes":       bLoc = 10:  bDef = %True:  GOSUB BtnDef
         bID = %MMB_No:       bTxt = "&No":        bLoc = 120: bDef = %False: GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Yes:      bTxt = "&Yes":       bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_No:       bTxt = "&No":        bLoc = 120: bDef = %True:  GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSE                                                        ' Button 3
         bID = %MMB_Yes:      bTxt = "&Yes":       bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_No:       bTxt = "&No":        bLoc = 120: bDef = %False: GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 230: bDef = %True:  GOSUB BtnDef
      END IF                                                      '
   ELSEIF i = %MB_ABORTRETRYIGNORE THEN
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Abort:    bTxt = "&Abort":     bLoc = 10:  bDef = %True:  GOSUB BtnDef
         bID = %MMB_Retry:    bTxt = "&Retry":     bLoc = 110: bDef = %False: GOSUB BtnDef
         bID = %MMB_Ignore:   bTxt = "&Ignore":    bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Abort:    bTxt = "&Abort":     bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_Retry:    bTxt = "&Retry":     bLoc = 110: bDef = %True:  GOSUB BtnDef
         bID = %MMB_Ignore:   bTxt = "&Ignore":    bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSE                                                        ' Button 3
         bID = %MMB_Abort:    bTxt = "&Abort":     bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_Retry:    bTxt = "&Retry":     bLoc = 120: bDef = %False: GOSUB BtnDef
         bID = %MMB_Ignore:   bTxt = "&Ignore":    bLoc = 230: bDef = %True:  GOSUB BtnDef
      END IF                                                      '
   ELSEIF i = %MB_CANCELTRYCONTINUE THEN
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 10:  bDef = %True:  GOSUB BtnDef
         bID = %MMB_TryAgain: bTxt = "&Try Again": bLoc = 120: bDef = %False: GOSUB BtnDef
         bID = %MMB_Continue: bTxt = "C&ontinue":  bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_TryAgain: bTxt = "&Try Again": bLoc = 120: bDef = %True:  GOSUB BtnDef
         bID = %MMB_Continue: bTxt = "C&ontinue":  bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSE                                                        ' Button 3
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_TryAgain: bTxt = "&Try Again": bLoc = 120: bDef = %False: GOSUB BtnDef
         bID = %MMB_Continue: bTxt = "C&ontinue":  bLoc = 230: bDef = %True:  GOSUB BtnDef
      END IF                                                      '
   ELSEIF i = %MB_WopenOpenCancel THEN
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_WOpen:    bTxt = "&WINOpen":   bLoc = 10:  bDef = %True:  GOSUB BtnDef
         bID = %MMB_Open:     bTxt = "&Open":      bLoc = 120: bDef = %False: GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_WOpen:    bTxt = "&WINOpen":   bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_Open:     bTxt = "&Open":      bLoc = 120: bDef = %True:  GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 230: bDef = %False: GOSUB BtnDef
      ELSE                                                        ' Button 3
         bID = %MMB_WOpen:    bTxt = "&WINOpen":   bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_Open:     bTxt = "&Open":      bLoc = 120: bDef = %False: GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 230: bDef = %True:  GOSUB BtnDef
      END IF                                                      '

      ELSEIF i = %MB_YESNO THEN
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Yes:      bTxt = "&Yes":       bLoc = 10:  bDef = %True:  GOSUB BtnDef
         bID = %MMB_No:       bTxt = "&No":        bLoc = 120: bDef = %False: GOSUB BtnDef
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Yes:      bTxt = "&Yes":       bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_No:       bTxt = "&No":        bLoc = 120: bDef = %True:  GOSUB BtnDef
      END IF                                                      '
   ELSEIF i = %MB_RETRYCANCEL THEN
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Retry:    bTxt = "&Retry":     bLoc = 10:  bDef = %True:  GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 120: bDef = %False: GOSUB BtnDef
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Retry:    bTxt = "&Retry":     bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 120: bDef = %True:  GOSUB BtnDef
      END IF                                                      '
   ELSEIF i = %MB_OKCANCEL THEN
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_OK:       bTxt = "&OK":        bLoc = 10:  bDef = %True:  GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 120: bDef = %False: GOSUB BtnDef
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_OK:       bTxt = "&OK":        bLoc = 10:  bDef = %False: GOSUB BtnDef
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bLoc = 120: bDef = %True:  GOSUB BtnDef
      END IF                                                      '
   ELSE
      bID = %MMB_OK:          bTxt = "&OK":        bLoc = 30:  bDef = %True:  GOSUB BtnDef
   END IF
   DIALOG POST hMsg, %WM_CHANGEUISTATE, MAKLNG(%UIS_CLEAR, %UISF_HIDEFOCUS OR %UISF_HIDEACCEL), 0

   '-----------------------------------------------------------------------------------------------+
   '- Add icon                                                                                     |
   '-----------------------------------------------------------------------------------------------+
   h = lStyle AND &H000000F0                                      ' Isolate Icon portion
   IF h = 0 THEN h = %MB_USERICON                                 ' Provide a default
   IF h = %MB_USERICON THEN                                       ' The user version?
      CONTROL ADD IMAGEX, hMsg, %MMB_Icon, "a", 10, 8, 32, 32, %SS_ICON
   ELSE                                                           ' Do the standard Icons
      CONTROL ADD LABEL,  hMsg, %MMB_Icon, "",  10, 8, 0, 0, %SS_ICON
      i = 0: j = %MB_OK                                           '
      SELECT CASE AS LONG h                                       '
         CASE %MB_ICONERROR, %MB_ICONHAND, %MB_ICONSTOP           '
            i = 103: j = %MB_ICONHAND                             '
         CASE %MB_ICONQUESTION                                    '
            i = 102: j = %MB_ICONQUESTION                         '
         CASE %MB_ICONWARNING, %MB_ICONEXCLAMATION                '
            i = 101: j = %MB_ICONEXCLAMATION                      '
         CASE %MB_ICONINFORMATION, %MB_ICONASTERISK               '
            i = 104: j = %MB_ICONASTERISK                         '
      END SELECT                                                  '
      hIcon = LoadImage(BYVAL 0, BYVAL i, %IMAGE_ICON, 32, 32, 0)
      SendDlgItemMessage hMsg, %MMB_Icon, %STM_SETIMAGE, %IMAGE_ICON, hIcon
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Finally we can display it                                                                    |
   '-----------------------------------------------------------------------------------------------+
   DIALOG SHOW MODAL hmsg, CALL MyMsgBoxproc() TO lResult         ' Go display it
   FOR i = 0 TO 10
      IF hFont(i) <> 0 THEN FONT END hfont(i)                     ' Destroy our fonts
   NEXT i                                                         '
   FUNCTION = lResult                                             ' Pass back result
   EXIT FUNCTION

BtnDef:
   CONTROL ADD BUTTON, hMsg, bID, bTxt, bLoc, h, 90, 20, IIF(bDef, %BS_DEFAULT, 0)
   CONTROL SET FONT hMsg, bID, hFont(0)                           ' Set Button font
   IF bDef THEN CONTROL SET FOCUS hMsg, bID                       ' Set focus if default
   RETURN                                                         ' Done
END FUNCTION

CALLBACK FUNCTION MyMsgBoxProc() AS LONG
LOCAL RC AS LONG
   SELECT CASE CB.MSG
      CASE %WM_COMMAND
         IF CB.CTLMSG = %BN_CLICKED THEN                          ' If button clicked,
            SELECT CASE CB.CTL                                    ' Return with which one
               CASE %MMB_OK:      RC = %IDOK
               CASE %MMB_Yes:     RC = %IDYES
               CASE %MMB_No:      RC = %IDNO
               CASE %MMB_Cancel:  RC = %IDCANCEL
               CASE %MMB_Abort:   RC = %IDABORT
               CASE %MMB_Retry:   RC = %IDRETRY
               CASE %MMB_Ignore:  RC = %IDIGNORE
               CASE %MMB_TryAgain:RC = %IDTRYAGAIN
               CASE %MMB_Continue:RC = %IDCONTINUE
               CASE %MMB_WOpen:   RC = %IDOK
               CASE %MMB_Open:    RC = %IDYES
            END SELECT
            DIALOG END CB.HNDL, RC
         END IF
    END SELECT
END FUNCTION

FUNCTION sFindWindow(BYVAL lTitle AS STRING, WinCtr AS LONG) AS LONG
'--------------------------------------------------------------------------------------------------+
'- Find a window by title                                                                          |
'--------------------------------------------------------------------------------------------------+
REGISTER Ctr AS LONG
   gWinListPos = 0: WinCtr = 0                                                ' Init
   ENUMWindows CODEPTR(sEnumWindowsProc), 0                       ' Count windows
   lTitle = UCASE$(lTitle)                                        ' Uppercase request
   FOR Ctr = 1 TO gWinListPos                                     ' Loop through list
      IF ISWindowVisible(gWinList(Ctr).WinHandle) = 1 THEN        ' Visible one?
         IF INSTR(UCASE$(gWinList(Ctr).WinTitle), lTitle) THEN    ' Yes, contain our string?
            IF WinCtr = 0 THEN FUNCTION = gWinList(Ctr).WinHandle ' Yes, pass back the first one
            INCR WinCtr                                           ' Count instances
         END IF                                                   '
      END IF                                                      '
   NEXT Ctr                                                       ' Loop back
END FUNCTION

FUNCTION sEnumWindowsProc(BYVAL lHandle AS LONG, BYVAL lNotUsed AS LONG) AS LONG
'--------------------------------------------------------------------------------------------------+
'- Get list of windows                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL wTitle AS ASCIIZ * 256, sTitle AS STRING
LOCAL lPos   AS LONG
   GETWindowText lHandle, wTitle, 255                             '
   sTitle = TRIM$(wTitle)                                         '
   IF LEN(sTitle) THEN                                            '
      INCR gWinListPos                                            '
      IF gWinListPos > UBOUND(gWinList()) THEN _                  '
         REDIM PRESERVE gWinList(1 TO gWinListPos * 2) AS GLOBAL WININFOTYPE ' Expand if needed
      gWinList(gWinListPos).WinTitle = sTitle                     '
      gWinList(gWinListPos).WinHandle = lHandle                   '
   END IF                                                         '
   FUNCTION = 1                                                   '
END FUNCTION

FUNCTION StrAnsi2Utf8 (BYREF a_str AS STRING) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Convert an ANSI string to UTF8                                                                  |
'           it is necessary to convert ANSI to Unicode first                                       |
'           then convert Unicode to UTF-8                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL u_str                   AS STRING                           ' output UTF-8 string
LOCAL u_num1                  AS LONG                             ' first  UTF-8 byte
LOCAL u_num2                  AS LONG                             ' second UTF-8 byte
LOCAL u_num3                  AS LONG                             ' third  UTF-8 byte
LOCAL u_len                   AS LONG                             ' length of output string

LOCAL w_num                   AS LONG                             ' binary value of Unicode char
LOCAL w_char                  AS WSTRING * 1                      ' one Unicode char

LOCAL a_ndx                   AS LONG                             ' index into input string
LOCAL a_char                  AS STRING * 1                       ' one Ansi char

   IF LEN (a_str) = 0 THEN FUNCTION = "": EXIT FUNCTION           ' supplied Ansi string was null, return null
   u_len = 0                                                      ' where new string written

   '-----------------------------------------------------------------------------------------------+
   '- est. size must take account that Unicode translations of Ansi may take 2 or 3 bytes in UTF-8 |
   '-----------------------------------------------------------------------------------------------+
   u_str = SPACE$ (LEN (a_str) * 3)                               ' allocate result string max length, may need less
   FOR a_ndx = 1 TO LEN (a_str)                                   ' examine each character in the input string
      a_char = MID$ (a_str, a_ndx, 1)                             ' grab one Ansi char
      w_char = a_char                                             ' convert to Unicode
      w_num = ASC(w_char) AND &H0FFFF                             ' get binary value of Unicode
      IF (w_num <= &H07F) AND (w_num > 0) THEN                    ' ASCII is a 1-byte sequence
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = a_char                          ' copy Ansi to output as is

      '--------------------------------------------------------------------------------------------+
      '- 2-byte UTF-8 has up 11 significant bits, divided into 5 and 6                             |
      '--------------------------------------------------------------------------------------------+
      ELSEIF (w_num <= &H07FF) OR (w_num = 0) THEN                ' data requires a 2-byte sequence
         u_num2 = ((w_num AND &H03F) OR &H080)                    ' byte 2 of UTF-8 gets 6 lower bits, plus x'80' marker
         SHIFT RIGHT w_num, 6
         u_num1 = ((w_num AND &H01F) OR &H0C0)                    ' byte 1 of UTF-8 gets 5 upper bits, plus x'C0' marker
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num1)
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num2)

      '--------------------------------------------------------------------------------------------+
      '- 3-byte UTF-8 has up 16 significant bits, divided into 4, 6 and 6                          |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' data requires a 3-byte sequence
         u_num3 = ((w_num AND &H03F) OR &H080)                    ' byte 3 of UTF-8 gets 6 lower bits, plus x'80' marker
         SHIFT RIGHT w_num, 6
         u_num2 = ((w_num AND &H03F) OR &H080)                    ' byte 2 of UTF-8 gets next 6 bits, plus x'80' marker
         SHIFT RIGHT w_num, 6
         u_num1 = ((w_num AND &H0F) OR &H0E0)                     ' byte 1 of UTF-8 gets 4 upper bits, plus x'E0' marker
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num1)
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num2)
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num3)
      END IF
   NEXT
   FUNCTION = LEFT$ (u_str, u_len)                                ' return the encoded UTF-8 string
END FUNCTION

FUNCTION StrCmpr(str1 AS STRING, str2 AS STRING) AS LONG
'---------- Case insensitive string compare
LOCAL S3, s4 AS DWORD, match AS LONG
' --------------------------------------------------
' compare two basic dynamic strings case insensitive
' Return values.
' -1 -- Str1 is low
'  0 -- Str1 = Str2
'  1 -- Str2 is low
' --------------------------------------------------
#DEBUG CODE OFF
    #REGISTER NONE
   s3 = LEN(str1): s4 = LEN(str2)
    PREFIX "! "
    mov   esi, str1                                               ' Copy text pointers into register
    mov   edi, str2                                               '
    mov   esi, [esi]                                              ' Dereference it to get text address
    mov   edi, [edi]                                              '

    mov   ecx,s3                                                  ' Get the length of 1st string in ecx
    mov   edx,s4                                                  ' Get the lenght of 2nd string in edx
    cmp   ecx,edx                                                 ' Compare the two lengths
    pushf                                                         ' Save the current status on the stack
    jbe   LgthSet                                                 ' Put shorter length in ecx
    mov   ecx,edx                                                 '

  LgthSet:
    SUB   edx,edx                                                 ' Clear counter

  MainTest:
    AND   ecx,ecx                                                 ' Any length left?
    jz    AllEqual                                                ' No? We're done byte comparisons
    movzx eax, BYTE PTR [esi+edx]                                 ' Get Str1 byte into eax
    movzx eax, BYTE PTR Cmpi_tbl[eax]                             ' Get translated Str1 byte into eax
    movzx ebx, BYTE PTR [edi+edx]                                 ' Get Str2 byte into ebx
    movzx ebx, BYTE PTR Cmpi_tbl[ebx]                             ' Get translated Str1 byte into eax
    inc   edx                                                     ' Bump index
    dec   ecx                                                     ' Decr length left
    cmp   al, bl                                                  ' Compare Str1 translated to Str2 translated
    je    MainTest                                                ' Loop till done
    pop   ax                                                      ' Flush the length test held status from the stack

  RealMismatch:
    jb    Str1Low                                                 ' If 1st string lowest, we are done
    inc   match                                                   ' Else 2nd string lower, set Match = 1
    jmp   short SetRC                                             ' Exit

   Str1Low:
    dec   match                                                   ' 1st string low, set match to -1
    jmp   short SetRC                                             ' Exit

   AllEqual:                                                      ' All matched chars agree
    popf                                                          ' So use the result of the original length compare
    jnz   RealMismatch                                            ' If not equal, go set match status

   SetRC:

   END PREFIX
#DEBUG CODE ON
   FUNCTION = match                                               ' Pass back our answer
   EXIT FUNCTION
END FUNCTION

FUNCTION StrUtf82Ansi(BYREF u_str AS STRING, err_flag AS LONG) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Converts an UTF-8 encoded string to an Ansi string                                              |
'                                                                                                  |
'  err_flag 1 = value found outside Ansi 8-bit range                                               |
'  err_flag 2 = UTF-8 value is malformed, errors replaced with X'A4' substitution                  |
'  err_flag 3 = errors 1 and 2 both occurred                                                       |
'                                                                                                  |
'  if valid UTF-8 converts to a Unicode value that is not Ansi, we can't use it                    |
'--------------------------------------------------------------------------------------------------+

STATIC st_valid_unicode_set   AS LONG
STATIC st_valid_unicode ()    AS WSTRING * 1

LOCAL a_str                   AS STRING                           ' output Ansi string
LOCAL a_char                  AS STRING * 1                       ' an Ansi char

LOCAL w_str                   AS WSTRING                          ' intermediate Unicode string
LOCAL w_len                   AS LONG                             ' length of output string
LOCAL w_num                   AS LONG                             ' accumulated Unicode char value
LOCAL w_char                  AS WSTRING * 1                      ' a Unicode char

LOCAL u_ndx                   AS LONG                             ' index into input string
LOCAL u_word                  AS LONG                             ' UTF accumulation value
LOCAL u_byte                  AS LONG                             ' individual UTF value in binary
LOCAL u_char                  AS STRING * 1                       ' a UTF-8 char

LOCAL format_err              AS LONG                             ' something wrong with UTF format
LOCAL data_err                AS LONG                             ' may be valid UTF but is out of range

LOCAL one_bits                AS LONG                             ' number of leading 1 bits in  a UTF byte
LOCAL select_mask             AS LONG                             ' used to select bits for testing
LOCAL test_mask               AS LONG                             ' used to compare bits after being selected
LOCAL data_mask               AS LONG                             ' used to mask off data portion of byte
LOCAL avail_len               AS LONG                             ' how many bytes left in the buffer
LOCAL actual_len              AS LONG                             ' byte length used to decode UTF data
LOCAL n                       AS LONG

   '-----------------------------------------------------------------------------------------------+
   '- first time we are called, define the Unicode validation table                                |
   '-----------------------------------------------------------------------------------------------+
   IF st_valid_unicode_set = 0 THEN
      st_valid_unicode_set = 1
      DIM st_valid_unicode (0 TO 255) AS STATIC WSTRING * 1
      FOR n = 0 TO 255
         st_valid_unicode (n) = CHR$ (n)                          ' the assignment converts Ansi to Unicode here
      NEXT
   END IF
   err_flag = 0
   IF LEN (u_str) = 0 THEN
      FUNCTION = ""                                               ' nothing to convert
      EXIT FUNCTION
   END IF
   w_len = 0                                                      ' where new string written
   w_str = SPACE$ (LEN (u_str))                                   ' allocate result string max length, may need less
   u_ndx = 0                                                      ' examine each character in the UTF-8 string
   DO WHILE (u_ndx < LEN (u_str))
      u_ndx += 1                                                  ' get next position in input string
      u_char = MID$ (u_str, u_ndx, 1)                             ' grab first UTF-8 byte
      u_byte = (ASC(u_char) AND &H0FF)                            ' form binary of UTF value

      '--------------------------------------------------------------------------------------------+
      '- determine the number of leading 1 bits                                                    |
      '--------------------------------------------------------------------------------------------+
      one_bits = 0
      select_mask = &H0100
      data_mask   = &H00FF

      '--------------------------------------------------------------------------------------------+
      '- scan the value left to right, stopping when first 0 bit is found                          |
      '-     data mask is 1 bit to right of select_mask                                            |
      '--------------------------------------------------------------------------------------------+
      FOR n = 1 TO 8
         SHIFT RIGHT select_mask, 1
         SHIFT RIGHT data_mask, 1
         IF ((u_byte AND select_mask) = 0) THEN EXIT FOR
         one_bits = n
      NEXT

      '--------------------------------------------------------------------------------------------+
      '- when one_bits = 0 is it ASCII                                                             |
      '      1 leading 1-bit is a continuation byte without a lead byte                            |
      '      leading 1 bits of 2-4 are UTF-8, any more is invalid                                  |
      '--------------------------------------------------------------------------------------------+
      IF one_bits = 0 THEN                                        ' UTF byte is 7-bit ASCII
         w_len += 1                                               ' get next position in buffer
         MID$ (w_str, w_len, 1) = CHR$$ (u_byte)                  ' copy non-encoded Ansi to intermeidate buffer
         ITERATE LOOP
      ELSEIF (one_bits = 1) OR (one_bits > 4) THEN
         err_flag = (err_flag OR 2)                               ' make note of format error
         w_len += 1                                               ' get next position in output string
         MID$ (w_str, w_len, 1) = CHR$$ (&H0A4)                   ' substitute char is logenze/square/currency symbol
         ITERATE LOOP
      END IF

      '--------------------------------------------------------------------------------------------+
      '- at this point, the UTF-8 value is 2, 3 or 4 bytes long, indicated by number of 1 bits     |
      '-                                                                                           |
      '-     there are two "format issues" to contend with.                                        |
      '-     first, there may not be that many bytes left in the buffer (it's "truncated")         |
      '-     second, all extra bytes must be proper continuation bytes, with '10' bits on the left |
      '-     if either of these requirements are not met, the UTF-8 is malformed                   |
      '-                                                                                           |
      '-     there is also a "data issue".  a properly formatted UTF-8 string may be encoding value|
      '-     that is outside the range of Ansi.  that is nothing wrong with the UTF-8. it is simply|
      '-     a limitation of SPFLite, which can't HANDLE true UNICODE                              |
      '--------------------------------------------------------------------------------------------+

      format_err = 0                                              ' assume no error for now
      avail_len = LEN (u_str) - u_ndx + 1                         ' how many bytes left including curr one
      IF one_bits > avail_len THEN
         format_err = 1
         actual_len = avail_len
      ELSE
         actual_len = one_bits
      END IF
      w_num = (u_byte AND data_mask)                              ' holds accumulated Unicode value

      '--------------------------------------------------------------------------------------------+
      '- get remaining bytes of UTF-8.  these must all be continuation bytes                       |
      '--------------------------------------------------------------------------------------------+
      FOR n = 2 TO actual_len
         u_ndx += 1                                               ' get next position in input string
         u_char = MID$ (u_str, u_ndx, 1)                          ' grab next UTF-8 byte
         u_byte = (ASC(u_char) AND &H0FF)                         ' form binary of Unicode value
         IF ((u_byte AND &H0C0) <> &H080) THEN                    ' this is not a continuation byte - FORMAT ERROR
            format_err = 1
            u_ndx -= 1                                            ' we cannot use this byte - BACK OFF THE SCAN HERE
            EXIT FOR                                              ' no point in trying to converting any more of this
         END IF
         SHIFT LEFT w_num, 6                                      ' make room for next 6 bits of data
         w_num += (u_byte AND &H03F)
      NEXT

      '--------------------------------------------------------------------------------------------+
      '- see if the accumulated Unicode value can be converted to Ansi                             |
      '--------------------------------------------------------------------------------------------+
      IF w_num > &H0FFFF THEN
         data_err = 1                                             ' no Ansi value has a Unicode value > FFFF
      ELSEIF w_num > &H07F THEN
         data_err = 1                                             ' assume it's bad unless found IN the table
         w_char = CHR$$ (w_num)
         FOR n = 128 TO 255
            IF w_char = st_valid_unicode (n) THEN
               data_err = 0                                       ' if found it table, it can be converted
               EXIT FOR
            END IF
         NEXT
      ELSE
         data_err = 0                                             ' data is not out of range
      END IF
      IF format_err THEN
         err_flag = (err_flag OR 2)                               ' make note of format error
         w_char = CHR$$ (&H0A4)                                   ' substitute char is lozenge/square/currency symbol
      ELSEIF data_err THEN
         err_flag = (err_flag OR 1)                               ' make note of data error
         w_char = CHR$$ (&H0A4)                                   ' substitute char is lozenge/square/currency symbol
      ELSE
         w_char = CHR$$ (w_num)
      END IF
      w_len += 1                                                  ' get next position in intermediate buffer
      MID$ (w_str, w_len, 1) = w_char                             ' store one Unicode char
   LOOP
   a_str = LEFT$ (w_str, w_len)                                   ' convert Unicode to Ansi
   FUNCTION = a_str                                               ' return the Ansi string
END FUNCTION

SUB      StrUnQuote(str AS STRING)
'--------------------------------------------------------------------------------------------------+
'- Remove quotes from a string                                                                     |
'--------------------------------------------------------------------------------------------------+
   DO WHILE LEFT$(str, 1) = $DQ
      str = CLIP$(LEFT, str, 1): SawQuote = %True
   LOOP
   DO WHILE RIGHT$(str, 1) = $DQ
      str = CLIP$(RIGHT, str, 1): SawQuote = %True
   LOOP
END SUB

FUNCTION TimePretty(BYVAL vl AS QUAD) AS STRING
'--------------------------------------------------------------------------------------------------+
'- Make a 'pretty' TimeStamp                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL LTime AS IPOWERTIME                                         ' Create a PowerTime object
LET LTime = CLASS "PowerTime"                                     '
   IF vl = 0 THEN                                                 ' If nothing passed
      LTime.Now                                                   ' Use current timestamp
   ELSE                                                           ' Otherwise
      LTime.FileTime = vl                                         ' Assign the passed FILETIME QUAD to it
      LTime.ToLocalTime                                           '
   END IF                                                         '
   FUNCTION = FORMAT$(LTime.year(), "0000") + "-" + FORMAT$(LTime.Month(), "00") + "-" + FORMAT$(LTime.day(), "00") + "  " + _
              FORMAT$(LTime.Hour(), "00") + ":" + FORMAT$(LTime.Minute(), "00")
END FUNCTION                                                      '

SUB      DEBUG (st AS STRING)
'--------------------------------------------------------------------------------------------------+
'- Print stuff to a console                                                                        |
'--------------------------------------------------------------------------------------------------+
STATIC Consl AS LONG
LOCAL szConsole AS ASCIIZ * 1024
   '-----------------------------------------------------------------------------------------------+
   '- Allocate a console if we haven't already done so                                             |
   '-----------------------------------------------------------------------------------------------+
   IF Consl = 0 THEN
      AllocConsole
      SetConsoleTitle "PB Diagnostic Console"
      Consl = GetStdHandle(%STD_OUTPUT_HANDLE)
      SetConsoleTextAttribute 0, %FOREGROUND_RED OR _
                                     %FOREGROUND_GREEN OR _
                                     %FOREGROUND_BLUE
   END IF

   '-----------------------------------------------------------------------------------------------+
   '- print the line                                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF Consl > 0 THEN
      szConsole = st & $CRLF
      WriteConsole Consl, szConsole, LEN(szConsole), %Null, %Null
    END IF
END SUB
