'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- KB.inc                                                                                          |
'--------------------------------------------------------------------------------------------------+
                                                                  '
'--------------------------------------------------------------------------------------------------+
'- Keyboard related code included within the cObjTabData Object                                    |
'--------------------------------------------------------------------------------------------------+
                                                                  '
   METHOD   FMkbBackSpace()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode BackSpace key                                                                        |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CType                              '
         CASE %CCmd                                               ' In pCommand?
            IF @P.C.CCol > 11 THEN                                ' Room to BKSP?
               pCommand = STRDELETE$(pCommand, @P.C.CLCol - 1, 1) + " " ' Delete it
               me.WindowCmd                                       ' Re-do the command line
               me.CsrColSub(1)                                    ' Adjust cursor location
            END IF                                                '

         CASE %CScrl                                              ' In Scroll field
            IF @P.C.CCol > 21 + @P.PCmdLen THEN                   ' Room to BKSP?
               FCB.ScrollAmt = STRDELETE$(FCB.ScrollAmt, @P.C.CLCol - 1, 1) + " "   ' Delete it
               DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, 1, 21 + @P.PCmdLen) ' Redisplay the entire string
               me.CsrColSub(1)                                    ' Adjust cursor location
            END IF                                                '

         CASE %CFPath                                             ' In Path
            IF @P.C.CCol > gFM_Path_Left THEN                     ' Room to BKSP?
               FPath = STRDELETE$(FPath, @P.C.CLCol - 1, 1) + " " ' Delete it
               DoPrint (FPath, $$TxtLo, @P.C.CRow, gFM_Path_Left) ' Redisplay the entire string
               me.CsrColSub(1)                                    ' Adjust cursor location
            END IF                                                '

         CASE %CFMask                                             ' In Mask
            IF @P.C.CCol > gFM_Mask_Left THEN                     ' Room to BKSP?
               FMask = STRDELETE$(FMask, @P.C.CLCol - 1, 1) + " " ' Delete it
               DoPrint (FMask, $$TxtLo, @P.C.CRow, gFM_Mask_Left) ' Redisplay the entire string
               me.CsrColSub(1)                                    ' Adjust cursor location
            END IF                                                '

         CASE %CFLCmd                                             ' In Line Cmd Area
            IF @P.C.CLCol > 1 THEN                                ' Room to BKSP?
               gFMD(@P.C.CIX).Cmd = STRDELETE$(gFMD(@P.C.CIX).Cmd, @P.C.CLCol - 1, 1)  ' Delete it
               IF gFMD(@P.C.CIX).CmdOff > 0 THEN                  ' Room to BKSP within offset?
                  gFMD(@P.C.CIX).CmdOff = gFMD(@P.C.CIX).CmdOff - 1  '
                  me.CsrColAdd(0)                                 ' To trigger CsrMode processing
               ELSE                                               ' Else no offset available
                  me.CsrColSub(1)                                 ' Adjust cursor location
               END IF                                             '
               DoPrint (me.WindowLCmd(@P.C.CIX), $$TxtHi, @P.C.CRow, 1) ' Redisplay the entire string
            END IF                                                '

         CASE ELSE                                                ' Weird position
            DoBeep                                                '

      END SELECT                                                  '
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbBackTab()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode BackTab key                                                                          |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CRow                               ' First base things on the row
         CASE 1                                                   '
            SELECT CASE AS LONG @P.C.CCol                         ' Now base on the column
               CASE < @P.PScrHdr: SetCmd                          ' Most, go to Command
               CASE = @P.PScrData: SetCmd                         ' At the Scr field
               CASE > @P.PScrData: SetScrl                        ' Far right, go to Scroll
            END SELECT                                            '

         CASE 2, gFM_Quick_Line_1                                 ' Dash Line or Quick Line
            SetScrl                                               ' Go to Scroll field

         CASE gFM_Path_Line                                       ' Def Path Line
            IF @P.C.CCol <= gFM_Path_Left THEN                    ' In left header area
               SetScrl                                            ' Go to Scroll field
            ELSE                                                  ' Else
               me.CsrRow = gFM_Path_Line: me.CsrCol = gFM_Path_Left  ' Go to start of field
            END IF                                                '

         CASE gFM_Mask_Line                                       ' Mask Line
            IF @P.C.CCol <= gFM_Mask_Left THEN                    ' In left header area
               me.CsrRow = gFM_Path_Line: me.CsrCol = gFM_Path_Left  ' Go to start of field
            ELSE                                                  ' Else
               me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Go to start of field
            END IF                                                '

         CASE gFM_Head_Line                                       '
            me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Go back to Mask line

         CASE > gFM_Top_File_Line                                 ' Lower than 1st file line?
            IF @P.C.CCol > 1 THEN                                 ' Within the line
               me.CsrCol = @P.PLeft                               ' Just col 1
            ELSE                                                  '
               me.CsrRowSub(1)                                    ' Simple DECR
               me.CsrCol = @P.PLeft                               '
            END IF                                                '

         CASE = gFM_Top_File_Line                                 '
            IF @P.C.CCol > 1 THEN                                 ' Within the line
               me.CsrCol = @P.PLeft                               ' Just col 1
            ELSE                                                  '
               me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Goto Mask line
            END IF                                                '

      END SELECT                                                  '
      me.MarkLineNumb                                             ' Refresh the line number
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbChar()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode normal character                                                                     |
   '-----------------------------------------------------------------------------------------------+
   LOCAL tText AS STRING                                          '
      MEntry                                                      '

      SELECT CASE AS LONG @P.C.CType                              '

         CASE %CCmd                                               '
            IF IsNotNsrtFlag THEN                                 ' Normal non-Insert?
               me.pCmdCharRep(@P.C.CLCol, gKeyChr)                ' Just overlay the Key into the string
            ELSE                                                  ' Insert mode
               pCommand = STRINSERT$(pCommand, gKeyChr, @P.C.CLCol)  ' Insert the Key
            END IF                                                '
            IF @P.C.CSCol = @P.PCmdLen THEN                       ' In the last position?
               me.COffsetAdd(1)                                   ' Shift a bit
               me.CsrColAdd(0)                                    ' To trigger CsrMode update
            ELSE                                                  '
               me.CsrColAdd(1)                                    ' Adjust cursor
            END IF                                                '
            me.WindowCmd                                          ' Re-do the command line

         CASE %CScrl                                              '
            IF IsNotNsrtFlag THEN                                 ' Normal non-Insert?
               me.ProfScrlRep(@P.C.CLCol, gKeyChr)                ' Just overlay the Key into the string
            ELSE                                                  '
               FCB.ScrollAmt = LEFT$(STRINSERT$(FCB.ScrollAmt, gKeyChr, @P.C.CLCol), 4)   ' Insert the Key
            END IF                                                '
            DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, 1, 21 + @P.PCmdLen) ' Print the whole string again
            me.CsrColAdd(1)                                       ' Adjust cursor

         CASE %CFPath                                             '
            IF LEN(FPath) < @P.C.CLCol THEN FPath = LSET$(FPath, @P.C.CLCol)  ' Lengthen field if needed
            IF IsNotNsrtFlag THEN                                 ' Normal non-Insert?
               MID$(FPath, @P.C.CLCol, 1) = gKeyChr               ' Just overlay the Key into the string
            ELSE                                                  '
               FPath = STRINSERT$(FPath, gKeyChr, @P.C.CLCol)     ' Insert the key
            END IF                                                '
            DoPrint (FPath, $$TxtLo, @P.C.CRow, gFM_Path_Left)    ' Print the whole string again
            me.CsrColAdd(1)                                       ' Adjust cursor

         CASE %CFMask                                             '
            IF LEN(FMask) < @P.C.CLCol THEN FMask = LSET$(FMask, @P.C.CLCol)  ' Lengthen field if needed
            IF IsNotNsrtFlag THEN                                 ' Normal non-Insert?
               MID$(FMask, @P.C.CLCol, 1) = gKeyChr               ' Just overlay the Key into the string
            ELSE                                                  '
               FMask = STRINSERT$(FMask, gKeyChr, @P.C.CLCol)     ' Insert the key
            END IF                                                '
            DoPrint (FMask, $$TxtLo, @P.C.CRow, gFM_Mask_Left)    ' Print the whole string again
            me.CsrColAdd(1)                                       ' Adjust cursor

         CASE %CFLCmd                                             '
            tText = TRIM$(gFMD(@P.C.CIX).Cmd)                     ' Save field before altering it
            IF LEN(TRIM$(gFMD(@P.C.CIX).Cmd)) < @P.C.CLCol THEN gFMD(@P.C.CIX).Cmd = LSET$(gFMD(@P.C.CIX).Cmd, @P.C.CLCol) ' Lengthen field if needed
            IF IsNotNsrtFlag THEN                                 ' Normal non-Insert?
               gFMD(@P.C.CIX).CmdR1(@P.C.CLCol, gKeyChr)          ' Stuff in the character
            ELSE                                                  '
               gFMD(@P.C.CIX).CmdI1(@P.C.CLCol, gKeyChr)          ' Insert the key
            END IF                                                '
            IF ISNULL(tText) THEN                                 ' If first entry in the field
               IF TRIM$(gFMD(@P.C.CIX).Cmd) <> "" THEN            ' Watch for a blank field
                  DO WHILE LEFT$(gFMD(@P.C.CIX).Cmd, 1) = " "     ' Leading " "?
                     gFMD(@P.C.CIX).Cmd = CLIP$(LEFT, gFMD(@P.C.CIX).Cmd, 1) + " "  '
                     me.CsrColAdd(-1)                             ' Adjust cursor
                  LOOP                                            '
               END IF                                             '
            END IF                                                '
            IF @P.C.CSCol = gENV.FMLCmdWidth THEN                 ' In the last position?
               gFMD(@P.C.CIX).CmdOff = gFMD(@P.C.CIX).CmdOff + 1  ' Bump offset
               me.CsrColAdd(0)                                    ' To trigger CsrMode
            ELSE                                                  '
               me.CsrColAdd(1)                                    ' Adjust cursor
            END IF                                                '
            DoPrint(me.WindowLCmd(@P.C.CIX), $$TxtHi, @P.C.CRow, 1)  '

         CASE ELSE                                                '
            DoBeep                                                ' Beep on errors
      END SELECT                                                  '
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbClipName()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Stuff file name into the clipboard                                                           |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING, j AS LONG                                  '
      MEntry                                                      '
      IF ISFALSE IsCLLin AND ISFALSE IsCLCmd THEN DoBeep: MExitMeth  ' Exit if not in line area
      IF @P.C.CRow >= gFM_Top_File_Line + gFMDCtr - @P.PTopLine THEN DoBeep: MExitMeth ' Exit if below last line
      ln = TRIM$(gFMD(@P.C.CIX).FileName)                         '
      j = INSTR(-1, ln, "\")                                      ' Find last \
      IF j THEN ln = MID$(ln, j + 1)                              ' Reduce to just filename
      ClipBoardSet(ln)                                            ' Send it to the Clipboard
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbClipPath()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Stuff full file path into the clipboard                                                      |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      MEntry                                                      '
      IF ISFALSE IsCLLin AND ISFALSE IsCLCmd THEN DoBeep: MExitMeth  ' Exit if not in line area
      IF @P.C.CRow >= gFM_Top_File_Line + gFMDCtr - @P.PTopLine THEN DoBeep: MExitMeth ' Exit if below last line
      ln = gFMD(@P.C.CIX).FullPath                                ' Use FullPath
      ClipBoardSet(ln)                                            ' Send it to the Clipboard
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbCmdHome()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Get to nearest command area                                                                  |
   '-----------------------------------------------------------------------------------------------+
      IF IsCLLin OR IsCLCmd THEN                                  ' In a line area somewhere
         me.CsrCol = @P.PLeft                                     ' Go back to LCmd area
         gFMD(@P.C.CIX).CmdOff = 0                                ' Clear Offset
         me.DispScreen                                            ' Re-do the whole mess
      ELSE                                                        ' Somewhere else
         pCommand = LTRIM$(pCommand)                              ' Trim command
         me.WindowCmd                                             ' Re-do the command line
         SetCmd                                                   ' Set the cursor
      END IF                                                      '
   END METHOD                                                     '

   METHOD   FMkbCopyLCmd()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- FM copy LCmd                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   LOCAL CBD AS STRING                                            ' new name of ClipBoard Data
      MEntry                                                      '
      IF @P.C.CRow < gFM_Top_File_Line OR @P.C.CRow >= gFM_Top_File_Line + gFMDCtr - @P.PTopLine THEN ' In valid area?
         CBD = " "                                                ' Clear the clipboard
         ClipboardWrite(CBD)                                      '
      ELSE                                                        '
         CBD = TRIM$(gFMD(@P.C.CIX).Cmd)                          ' Copy line command
         IF ISNULL(CBD) THEN CBD = " "                            '
         ClipboardWrite(CBD)                                      '
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbDelete()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- FM mode Delete key                                                                           |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CType                              '
         CASE %CCmd                                               ' In pCommand?
            pCommand = STRDELETE$(pCommand, @P.C.CLCol, 1) + " "  ' Delete it
            me.WindowCmd                                          ' Re-do the command line

         CASE %CScrl                                              ' In Scroll field
            FCB.ScrollAmt = STRDELETE$(FCB.ScrollAmt, @P.C.CLCol, 1) + " " ' Delete it
            DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, 1, 21 + @P.PCmdLen) ' Redisplay the entire string

         CASE %CFPath                                             ' In Path
            FPath = STRDELETE$(FPath, @P.C.CLCol, 1) + " "        ' Delete it
            DoPrint (FPath, $$TxtLo, @P.C.CRow, gFM_Path_Left)    ' Redisplay the entire string

         CASE %CFMask                                             ' In Mask
            FMask = STRDELETE$(FMask, @P.C.CLCol, 1) + " "        ' Delete it
            DoPrint (FMask, $$TxtLo, @P.C.CRow, gFM_Mask_Left)    ' Redisplay the entire string

         CASE %CFLCmd                                             ' In Line Cmd Area
            gFMD(@P.C.CIX).Cmd = STRDELETE$(gFMD(@P.C.CIX).Cmd, @P.C.CLCol, 1)   ' Delete it
            DoPrint (me.WindowLCmd(@P.C.CIX), $$TxtHi, @P.C.CRow, 1) ' Redisplay the entire string

         CASE ELSE                                                '
            DoBeep                                                '

      END SELECT                                                  '
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbDown()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode Down key                                                                             |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      me.CsrRowAdd(1)                                             ' Simple INCR

      IF @P.C.CRow >= gFM_Top_File_Line + gFM_List_Height THEN    ' Scroll the screen if needed

         IF ISFALSE gENV.KBVerScroll THEN                         ' AutoScroll or not
            me.CsrRow = @P.PTop                                   ' NO - Handle Wrap if needed
         ELSE                                                     ' Yes, Scrolling
            @P.PTopLine = MIN(@P.PTopLine + 1, MAX(1, gFMDCtr - gFM_List_Height + 7))  ' Move TopScrn by scroll amount
            me.CsrRowSub(1)                                       ' Undo INCR
            LastTop = 0                                           ' Make sure it moves
            me.DispScreen                                         ' and display screen
         END IF                                                   '
      END IF                                                      '
      me.MarkLineNumb                                             ' Mark the line number
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbEndOfLine(LorT AS STRING)                         '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode EndOfLine key                                                                        |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j AS LONG                                                '
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CType                              '
         CASE %CCmd                                               ' In the Cmd area
            j = IIF(LorT = "L", LEN(pCommand), LEN(RTRIM$(pCommand)))   ' How long is Cmd
            IF j > @P.PCmdLen + @P.PCOffset THEN                  ' Is it to the right of the Window?
               @P.PCOffset = j - (@P.PCmdLen / 2)                 ' Adjust offset
            ELSEIF j < @P.PCOffset THEN                           ' Is it to the left of the Window?
               @P.PCOffset = MAX(0, j - (@P.PCmdLen / 2))         ' Adjust offset
            END IF                                                '
            me.WindowCmd                                          ' Redisplay the line
            me.CsrCol = j - @P.PCOffset + 11                      '

         CASE %CScrl                                              ' In Scroll area
            j = IIF(LorT = "L", LEN(FCB.ScrollAmt), LEN(RTRIM$(FCB.ScrollAmt)))  ' How long is fieldCmd
            j = MIN(3, j)                                         ' So we don't point cursor off the right edge
            me.CsrCol = j + 21 + @P.PCmdLen                       '

         CASE %CFPath                                             ' Path line
            me.CsrCol = IIF(LorT = "L", LEN(FPath), LEN(RTRIM$(FPath))) + gFM_Path_Left   '

         CASE %CFMask                                             ' Mask Line
            me.CsrCol = IIF(LorT = "L", LEN(FMask), LEN(RTRIM$(FMask))) + gFM_Mask_Left   '

         CASE %CFLCmd                                             ' Line command
            j = IIF(LorT = "L", LEN(gFMD(@P.C.CIX).Cmd), LEN(RTRIM$(gFMD(@P.C.CIX).Cmd))) + 1   ' Get length of LCmd
            IF j > gENV.FMLCmdWidth + gFMD(@P.C.CIX).CmdOff THEN  ' Is it to the right of the Window?
               gFMD(@P.C.CIX).CmdOff = j - gENV.FMLCmdWidth       ' Adjust offset
            ELSEIF j < gFMD(@P.C.CIX).CmdOff THEN                 ' Is it to the left of the Window?
               gFMD(@P.C.CIX).CmdOff = MAX(0, j - gENV.FMLCmdWidth)  ' Adjust offset
            END IF                                                '
            DoPrint(me.WindowLCmd(@P.C.CIX), $$LnoHi, @P.C.CRow, 1)  '
            me.CsrCol = j - gFMD(@P.C.CIX).CmdOff                 '

         CASE ELSE                                                '
            DoBeep                                                '
      END SELECT                                                  '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  FMkbEnter()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Enter pressed on File Manager Tab                                                            |
   '-----------------------------------------------------------------------------------------------+
      DoSet(%Attention)                                           ' Just call Attention
   END METHOD                                                     '

   METHOD   FMkbEraseEOL()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- FM mode EraseEOL key                                                                         |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CType                              ' Base things on the field
         CASE %CCmd                                               ' pCommand line
            pCommand = LEFT$(pCommand, @P.C.CLCol - 1)            '
            me.WindowCmd                                          ' Re-do the command line
            me.CsrCol = @P.C.CCol                                 '

         CASE %CScrl                                              ' Scroll field
            FCB.ScrollAmt = LEFT$(LEFT$(FCB.ScrollAmt, @P.C.CLCol - 1) + "    ", 4)  ' Truncate the line then
            DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, 1, 21 + @P.PCmdLen) ' Print the whole string again

         CASE %CFPath                                             '
            FPath = LEFT$(FPath, @P.C.CLCol - 1)                  ' Truncate the line then
            DoPrint (LSET$(FPath, gENV.ScrWidth - gFM_Path_Left), $$TxtLo, @P.C.CRow, gFM_Path_Left)  ' Print the whole string again

         CASE %CFMask                                             '
            FMask = LEFT$(FMask, @P.C.CLCol - 1)                  ' Truncate the line then
            DoPrint (LSET$(FMask, gENV.ScrWidth - gFM_Mask_Left), $$TxtLo, @P.C.CRow, gFM_Mask_Left)  ' Print the whole string again

         CASE %CFLCmd                                             '
            gFMD(@P.C.CIX).Cmd = LEFT$(gFMD(@P.C.CIX).Cmd, @P.C.CLCol - 1) '
            DoPrint (me.WindowLCmd(@P.C.CIX), $$TxtHi, @P.C.CRow, 1) ' Redisplay the entire string

         CASE ELSE                                                '
            DoBeep                                                '

      END SELECT                                                  '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  FMkbFMBack()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- FM Back Screen                                                                               |
   '-----------------------------------------------------------------------------------------------+
      FMNestBack                                                  ' Let FMNestBack do it's thing
   END METHOD                                                     '

   METHOD  FMkbFMFwd()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- FM Fwd Screen                                                                                |
   '-----------------------------------------------------------------------------------------------+
      FMNestFwd                                                   ' Let FMNestFwd do it's thing
   END METHOD                                                     '

   METHOD  FMkbFirstLCmd()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- First Line Cmd area                                                                          |
   '-----------------------------------------------------------------------------------------------+
      me.CsrRow = gFM_Top_File_Line: me.CsrCol = @P.PLeft         ' Go to 1st File Line
   END METHOD                                                     '

   METHOD   FMkbHome()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode Home key                                                                             |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      me.CsrRow = @P.PTop: me.CsrCol = @P.PCmdCol: @P.PCOffset = 0 ' Reset things
      me.WindowCmd                                                ' Re-do the command line in case we shifted
      me.MarkLineNumb                                             ' Refresh the line number
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbLeft()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode Left key                                                                             |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CType                              ' Basee things on the field
         CASE %CCmd                                               ' pCommand line
            IF @P.C.CSCol = 1 AND @P.PCOffset > 0 THEN            ' Left end and offset available?
               me.COffsetAdd(-1)                                  ' Decr the offset
               me.WindowCmd                                       ' Re-do the command line
            ELSE                                                  '
               GOSUB Back1                                        ' Simple DECR
            END IF                                                '

         CASE %CFLCmd                                             ' Line command
            IF @P.C.CSCol = 1 AND gFMD(@P.C.CIX).CmdOff > 0 THEN  ' If left and and offset > 0
               gFMD(@P.C.CIX).CmdOff = gFMD(@P.C.CIX).CmdOff - 1  ' Reduce the offset
               DoPrint(me.WindowLCmd(@P.C.CIX), $$LnoHi, @P.C.CRow, 1)  ' Re-Display it
            ELSE                                                  '
               GOSUB Back1                                        ' Simple DECR
            END IF                                                '

         CASE ELSE                                                ' Everything else
            GOSUB Back1                                           ' Simple Decr

      END SELECT                                                  '
      me.MarkLineNumb                                             ' In case line number moved
      MExitMeth                                                   '
      Back1:                                                      '
         me.CsrColAdd(-1)                                         ' Simple Decr
         IF @P.C.CCol < 1 THEN                                    ' Column wrap?
            me.CsrCol = gENV.ScrWidth: me.CsrRowAdd(-1)           ' Yes, adjust for it
            IF @P.C.CRow < 1 THEN me.CsrRow = gENV.ScrHeight - (3 * gENV.FMHelpFlag)   ' also for CRow wrap if needed
         END IF                                                   '
         RETURN                                                   '
   END METHOD                                                     '

   METHOD   FMkbLineNo()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- LineNo key                                                                                   |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      IF ISFALSE IsCLLin AND ISFALSE IsCLCmd THEN DoBeep: MExitMeth  ' Exit if not in line area
      me.CsrCol = @P.PLeft                                        ' Go back to LCmd area
      gFMD(@P.C.CIX).CmdOff = 0                                   ' Reset offset
      me.DispScreen                                               ' Re-do the whole mess
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbNewLine()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode NewLine key                                                                          |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CRow                               ' First base things on the row
         CASE 1, 2, gFM_Quick_Line_1                              ' pCommand line, dash line or quick line
            IF ISNOTNULL(FileListNm) THEN                         ' FileList mode?
               me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Go to Mask line
            ELSE                                                  '
               me.CsrRow = gFM_Path_Line: me.CsrCol = gFM_Path_Left  ' Go to Path line
            END IF                                                '

         CASE gFM_Path_Line                                       ' Path Line
            me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Go to mask line

         CASE gFM_Mask_Line                                       ' Def Types Line
            me.CsrRow = gFM_Top_File_Line: me.CsrCol = @P.PLeft   ' Go to 1st File Line

         CASE gFM_Head_Line                                       '
            me.CsrRow = gFM_Top_File_Line: me.CsrCol = @P.PLeft   ' Go to 1st File Line

         CASE >= gFM_Top_File_Line                                ' In File list
            IF @P.C.CRow >= gENV.ScrHeight - (2 * gENV.FMHelpFlag) OR _ '
               @P.C.CRow >= gFM_Top_File_Line - 1 + gFMDCtr - @P.PTopLine THEN   '
               me.CsrRow = @P.PTop: me.CsrCol = @P.PCmdCol        ' Go to top line
            ELSE                                                  '
               me.CsrRowAdd(1)                                    '
               me.CsrCol = @P.PLeft                               '
            END IF                                                '
      END SELECT                                                  '
      me.MarkLineNumb                                             ' Refresh the line number
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbPaste                                             '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode Paste key                                                                            |
   '-----------------------------------------------------------------------------------------------+
   LOCAL t, ln, MyDlm, Tx AS STRING, i AS LONG                    '
      MEntry                                                      '
      ClipboardRead(t, MyDLM, %False)                             ' Go get Clipboard, keep the file
      IF LEN(t) < 1 THEN DoBeep: MExitMeth                        ' Error if nothing there
      ln = EXTRACT$(t, MyDLM)                                     ' Get 1st line from Clipboard
      me.MarkKill                                                 ' Kill any active block select

      SELECT CASE AS LONG @P.C.CType                              ' Split now by what field we're on

         CASE %CCmd                                               ' pCommand
            Tx = pCommand                                         ' Get working copy
            GOSUB Pasteit                                         ' Paste the string
            PCommand = Tx                                         ' Copy back
            i = @P.C.CLCol + LEN(ln)                              ' Move cursor logically
            IF i > @P.PCmdLen + @P.PCOffset THEN                  ' Is it to the right of the Window?
               @P.PCOffset = i - (@P.PCmdLen / 2)                 ' Adjust offset
            ELSEIF i < @P.PCOffset THEN                           ' Is it to the left of the Window?
               @P.PCOffset = MAX(0, i - (@P.PCmdLen / 2))         ' Adjust offset
            END IF                                                '
            me.WindowCmd                                          ' Print the whole string again
            me.CsrCol = i - @P.PCOffset + 10                      ' Move cursor

         CASE %CFPath                                             '
            Tx = FPath                                            ' Get working copy
            GOSUB Pasteit                                         ' Paste the string
            FPath = Tx                                            ' Copy it back
            DoPrint (FPath, $$TxtLo, gFM_Path_Line, gFM_Path_Left)   '
            me.CsrCol = @P.C.CLCol + LEN(ln) + gFM_Path_Left - 1  ' Move cursor

         CASE %CFMask                                             '
            Tx = FMask                                            ' Get working copy
            GOSUB Pasteit                                         ' Paste the string
            FMask = Tx                                            ' Copy it back
            DoPrint (FMask, $$TxtLo, gFM_Mask_Line, gFM_Mask_Left)   '
            me.CsrCol = @P.C.CLCol + LEN(ln) + gFM_Mask_Left - 1  ' Move cursor

         CASE %CFLCmd                                             ' In the Line Command area?
            Tx = gFMD(@P.C.CIX).Cmd                               ' Get working copy
            GOSUB Pasteit                                         ' Paste the string
            gFMD(@P.C.CIX).Cmd = Tx                               ' Copy back
            i = @P.C.CCol + gFMD(@P.C.CIX).CmdOff + LEN(ln)       ' Move cursor logically
            IF i > gENV.FMLCmdWidth + gFMD(@P.C.CIX).CmdOff THEN  ' Is it to the right of the Window?
               gFMD(@P.C.CIX).CmdOff = i - (gENV.FMLCmdWidth / 2) ' Adjust offset
            ELSEIF i < gFMD(@P.C.CIX).CmdOff THEN                 ' Is it to the left of the Window?
               gFMD(@P.C.CIX).CmdOff = MAX(0, i - (gENV.FMLCmdWidth / 2))  ' Adjust offset
            END IF                                                '
            DoPrint(me.WindowLCmd(@P.C.CIX), $$TxtHi, @P.C.CRow, 1)  ' Re-Display it
            me.CsrCol = i - gFMD(@P.C.CIX).CmdOff                 ' Move cursor

         CASE ELSE                                                '
            DoBeep                                                '

      END SELECT                                                  '
      MExitMeth                                                   '

      PasteIt:                                                    '
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF LEN(Tx) < @P.C.CLCol + LEN(ln) - 1 THEN Tx = LSET$(Tx, @P.C.CLCol + LEN(ln) - 1) ' Lengthen if needed
            MID$(Tx, @P.C.CLCol, LEN(ln)) = ln                    ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            Tx = LEFT$(Tx, @P.C.CLCol - 1) + ln + MID$(Tx, @P.C.CLCol)  '
         END IF                                                   '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD   FMkbRefresh                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Force FM Refresh                                                                             |
   '-----------------------------------------------------------------------------------------------+
      TPDOSet(%LoadData OR %Refresh)                              ' Set refresh request
   END METHOD                                                     '

   METHOD   FMkbRight                                             '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode Right key                                                                            |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CType                              ' Basee things on the field
         CASE %CCmd                                               ' pCommand line
            IF @P.C.CSCol = @P.PCmdLen THEN                       ' End of line?
               me.COffsetAdd(1)                                   ' Bump the offset
               me.WindowCmd                                       ' Re-do the command line
            ELSE                                                  '
               GOSUB Fwd1                                         ' Simple Incr
            END IF                                                '

         CASE %CFLCmd                                             ' Line command
            IF @P.C.CSCol = gENV.FMLCmdWidth AND ISNOTNULL(TRIM$(gFMD(@P.C.CIX).Cmd)) THEN   ' If at right bound and data present
               gFMD(@P.C.CIX).CmdOff = gFMD(@P.C.CIX).CmdOff + 1  ' Bump the offset
               DoPrint(me.WindowLCmd(@P.C.CIX), $$LnoHi, @P.C.CRow, 1)  ' Re-Display it
            ELSE                                                  '
               GOSUB Fwd1                                         ' Simple Incr
            END IF                                                '

         CASE ELSE                                                ' Everything else
            GOSUB Fwd1                                            ' Simple INCR

      END SELECT                                                  '
      me.MarkLineNumb                                             ' In case line number moved
      MExitMeth                                                   '
      Fwd1:                                                       '
         me.CsrColAdd(1)                                          ' Simple INCR
         IF @P.C.CCol > gENV.ScrWidth THEN                        ' Column wrap?
            me.CsrCol = @P.PLeft: me.CsrRowAdd(1)                 ' Yes, adjust for it
            IF @P.C.CRow > gENV.ScrHeight + 1 - (3 * gENV.FMHelpFlag) THEN me.CsrRow = @P.PTop  ' also for Row wrap if needed
         END IF                                                   '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD   FMkbTab()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode Tab key                                                                              |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      SELECT CASE AS LONG @P.C.CRow                               ' First base things on the row
         CASE 1                                                   ' pCommand line
            SELECT CASE AS LONG @P.C.CCol                         ' Now base on the column
               CASE < @P.PCmdCol: me.CsrCol = @P.PCmdCol          ' Left of Cmd, go to Cmd
               CASE < @P.PScrHdr: SetScrl                        ' In Cmd, go to Scroll
               CASE ELSE:                                         ' All Else
                  IF ISNOTNULL(FileListNm) THEN                   ' FILELIST
                     me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Go to Mask line
                  ELSE                                            '
                     me.CsrRow = gFM_Path_Line: me.CsrCol = gFM_Path_Left  ' Path Line for all else
                  END IF                                          '
            END SELECT                                            '

         CASE 2, gFM_Quick_Line_1                                 ' Dash Line or quick line
            IF ISNOTNULL(FileListNm) THEN                         ' FILELIST
               me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Go to Mask line
            ELSE                                                  '
               me.CsrRow = gFM_Path_Line: me.CsrCol = gFM_Path_Left  ' Path Line for all else
            END IF                                                '

         CASE gFM_Path_Line                                       ' Def Path Line
            IF @P.C.CCol < gFM_Path_Left THEN                     ' In left header area
               me.CsrCol = gFM_Path_Left                          ' Go to Path
            ELSE                                                  '
               me.CsrRow = gFM_Mask_Line: me.CsrCol = gFM_Mask_Left  ' Mask Line for all else
            END IF                                                '

         CASE gFM_Mask_Line                                       ' Mask Line
            IF @P.C.CCol < gFM_Mask_Left THEN                     ' In left header area
               me.CsrCol = gFM_Mask_Left                          ' Go to Mask
            ELSE                                                  '
               me.CsrRow = gFM_Top_File_Line: me.CsrCol = @P.PLeft' Top File line for FileLists
            END IF                                                '

         CASE gFM_Head_Line                                       '
            me.CsrRow = gFM_Top_File_Line                         ' Go to 1st File Line
            me.CsrCol = @P.PLeft                                  '

         CASE >= gFM_Top_File_Line                                '
            IF @P.C.CRow >= gENV.ScrHeight - (2 * gENV.FMHelpFlag) OR _ '
               @P.C.CRow >= gFM_Top_File_Line + gFMDCtr - @P.PTopLine THEN '
               me.CsrRow = @P.PTop                                ' Go to top line
               me.CsrCol = @P.PCmdCol                             '
            ELSE                                                  '
               me.CsrRowAdd(1)                                    '
               me.CsrCol = @P.PLeft                               '
            END IF                                                '
      END SELECT                                                  '
      me.MarkLineNumb                                             ' Refresh the line number
      MExit                                                       '
   END METHOD                                                     '

   METHOD   FMkbUp()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- FM Mode Up key                                                                               |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      me.CsrRowSub(1)                                             ' Simple DECR

      IF @P.C.CRow = 0 THEN me.CsrRow = gFM_Top_File_Line + gFM_List_Height - 1  ' Handle wrap if needed
      IF @P.C.CRow + 1 < gFM_Top_File_Line THEN MExitMeth         ' In header area
      IF @P.C.CRow + 1 = gFM_Top_File_Line THEN                   ' Top line see if scrolling
         IF @P.PTopLine = 1 THEN MexitMeth                        ' No place to go, move cursor up
         IF ISFALSE gENV.KBVerScroll THEN MExitMeth               ' No Scrolling, just go up
         @P.PTopLine = MAX(1, @P.PTopLine - 1)                    ' Move TopScrn
         me.CsrRowAdd(1)                                          ' Keep the cursor here
         LastTop = 0                                              ' Let scrolling proceed
         me.FMkbEnter                                             '
         MexitMeth                                                '
      END IF                                                      '
      me.MarkLineNumb                                             ' Refresh the line number
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krANSI                                                 '
   '-----------------------------------------------------------------------------------------------+
   '- ANSI pop-up in row mode (original layout)                                                    |
   '-----------------------------------------------------------------------------------------------+
      me.DispANSI (%False)                                        ' Pop it open, flag = not column mode
      GRAPHIC ATTACH PgHandle, WindowID                           ' Set graphics back
   END METHOD                                                     '

   METHOD  krANSIcol                                              '
   '-----------------------------------------------------------------------------------------------+
   '- ANSI pop-up in column mode                                                                   |
   '-----------------------------------------------------------------------------------------------+
      me.DispANSI (%True)                                         ' Pop it open, flag = column mode
      GRAPHIC ATTACH PgHandle, WindowID                           ' Set graphics back
   END METHOD                                                     '

   METHOD  krBackTab()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Tab backward To previous field                                                               |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, wLin AS LONG, lclTabs AS STRING                    '
      OnInsClnSupp                                                ' Suppress Insert cleanup for 1 Attn pass

      SELECT CASE @P.C.CRow                                       ' First base things on the row
         '-----------------------------------------------------------------------------------------+
         '- Cursor on top line                                                                     |
         '-----------------------------------------------------------------------------------------+
         CASE @P.PTop                                             ' Top row (Command)
            IF @P.C.CCol <= @P.PCmdCol THEN GOSUB BotLine: GOSUB LastTab: EXIT METHOD  ' Simple one
            IF @P.C.CCol >= @P.PCmdCol AND @P.C.CCol < @P.PScrHdr THEN SetCmd: EXIT METHOD   ' Another
            IF @P.C.CCol >= @P.PScrData THEN SetCmd: EXIT METHOD  ' Another
            SetScrl: EXIT METHOD                                  '

         '-----------------------------------------------------------------------------------------+
         '- Cursor on Line 2                                                                       |
         '-----------------------------------------------------------------------------------------+
         CASE @P.PTop + 1                                         ' Line 2 (Message)
            SetScrl: EXIT METHOD                                  ' Back to Scroll Amt.

         '-----------------------------------------------------------------------------------------+
         '- If on fixed COLS line, get out                                                         |
         '-----------------------------------------------------------------------------------------+
         CASE @P.PData1 - 1                                       ' Possible Cols Line?
            SetScrl: EXIT METHOD                                  ' Back to Scroll Amt.

      END SELECT                                                  '

      '--------------------------------------------------------------------------------------------+
      '- OK then, Cursor in the data area somewhere                                                |
      '--------------------------------------------------------------------------------------------+
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      wLin = me.SGet(@P.C.CRow)                                   ' Get data line number we're on
      '--------------------------------------------------------------------------------------------+
      '- Below the Bottom line?                                                                    |
      '--------------------------------------------------------------------------------------------+
      IF wLin = 0 THEN                                            ' Below last line?
         GOSUB BotLine: GOSUB LastTab: EXIT METHOD                ' Go to last tab on last line
      END IF                                                      '
      IF IsLTop(wLin) THEN                                        ' On the Top Line
         IF @P.C.CCol > @P.PDataCol THEN me.CsrCol = @P.PDataCol ELSE SetScrl '
         EXIT METHOD                                              '
      END IF                                                      '
      IF IsLBottom(wLin) THEN                                     ' On the bottom of Data Line
         me.CsrCol = @P.PLeft                                     ' Just go to Col 1
         EXIT METHOD                                              '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Split by where in the line                                                                |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CCol < @P.PDataCol THEN                             ' If lineno area
         IF @P.C.CRow = @P.PData1 THEN SetScrl: EXIT METHOD       ' If to line goto Scroll
         DECR @P.C.CRow                                           ' Backup to prev line
         GOSUB LastTab: EXIT METHOD                               ' We're done
      ELSE                                                        ' In the data portion
         '--------------------------------------------------------------------------------------------+
         '- Somewhere in the data portion of a line                                                   |
         '--------------------------------------------------------------------------------------------+
         IF ISFALSE FCB.Tabs THEN me.CsrCol = @P.PDataCol: EXIT METHOD  ' No TABS, just go to left margin
         IF @P.C.CCol = @P.PDataCol THEN me.CsrCol = @P.PLeft: EXIT METHOD '
         '-----------------------------------------------------------------------------------------+
         '- TABS ON, figure out where to go                                                        |
         '-----------------------------------------------------------------------------------------+
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc index into data string
         lclTabs = me.TabsSimple(LEN(L(wLin).@LTxt))              ' Get a working tabs line
         IF i > LEN(lclTabs) THEN                                 ' If right of last tab
            GOSUB LastTab                                         ' Go set to the last tab
         ELSE                                                     '
            i = INSTR(i - LEN(lclTabs) - 2, lclTabs, "*")         ' look for prev tab marker
            IF i THEN                                             ' If we have one
               IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, wLin, i, %True)         ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
                  EXIT METHOD                                     '
               ELSE                                               ' Still on screen, just move cursor
                  me.CsrCol = i + @P.PGapCol - @P.POffset         '
               END IF                                             '
            ELSE                                                  ' No more to the left
               IF @P.C.CCol <> @P.PDataCol THEN me.CsrCol = @P.PDataCol ' Left margin if not already there
            END IF                                                '
         END IF                                                   '
         EXIT METHOD                                              '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Find Bottom line of screen (Panel)                                                        |
      '--------------------------------------------------------------------------------------------+
      BotLine:                                                    ' Find Last Screen Line
         FOR i = @P.PBottom TO @P.PData1 STEP -1                  '
            IF me.SGet(i) > 0 THEN                                '
               me.CsrRow = i                                      ' Got it, exit
               wLin = me.SGet(@P.C.CRow)                          ' Get data line index
               EXIT FOR                                           '
            END IF                                                '
         NEXT i                                                   '
      RETURN                                                      '


      '--------------------------------------------------------------------------------------------+
      '- Find the last tab on a line                                                               |
      '--------------------------------------------------------------------------------------------+
      LastTab:                                                    ' Find Last Tab
         lclTabs = me.TabsSimple(LEN(L(wLin).@LTxt))              ' Get a working tabs line
         IF FCB.Tabs THEN                                         ' If TABS active
            i = INSTR(-1, lclTabs, "*")                           '
         END IF                                                   '
         i = MAX(1, i)                                            '
         IF IsLTop(wLin) OR IsLBottom(wLin) THEN                  ' On the Top or bottom of Data Line
            me.CsrCol = @P.PLeft                                  ' Just go to Col 1
            RETURN                                                '
         END IF                                                   '
         IF i <= @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN   ' Still on current screen
            me.CurSetReq(%Position, wLin, i, %True)               ' Set cursor set attempt
            DoSet(%Refresh)                                       ' Have it looked at
         ELSE                                                     '
            me.CsrCol = i + @P.PGapCol - @P.POffset               '
         END IF                                                   '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  krTrkBack()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Backup 1 Track Point                                                                         |
   '-----------------------------------------------------------------------------------------------+
      me.TrkBak()                                                 '
   END METHOD                                                     '

   METHOD  krTrkC()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Create a Track Point                                                                         |
   '-----------------------------------------------------------------------------------------------+
      me.TrkAdd(@P.PTopLine, me.CsrRow, me.CsrCol)                ' Create one
   END METHOD                                                     '

   METHOD  krTrkFwd()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Forward 1 Track Point                                                                        |
   '-----------------------------------------------------------------------------------------------+
      me.TrkFwd()                                                 '
   END METHOD                                                     '

   METHOD  krBPaste()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Block PASTE Clipboard data into the dataset                                                  |
   '-----------------------------------------------------------------------------------------------+
   LOCAL lclTop, i, j, tcol, curline, curcol, fMIX AS LONG        '
   LOCAL ln, t, tt AS STRING, tc AS WSTRING                       '
   LOCAL MyDLM AS STRING                                          '

      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Reset any marked area                                                                     |
      '--------------------------------------------------------------------------------------------+
      me.MarkKill                                                 ' Kill any active block select
      me.SwapKill                                                 '
      me.AttrInvClearFind                                         ' Also any Find HiLite
      lclTop = @P.PTopLine                                        ' Save current top

      '--------------------------------------------------------------------------------------------+
      '- Ensure we're in the text area, locate the text line number                                |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CCol < @P.PDataCol OR @P.C.CRow < @P.PData1 THEN DoBeep: MExitMeth ' Better be in text area
      tcol = @P.C.CLCol                                           ' Get column insert position
      i = @P.C.CIX                                                ' Get 1st line number
      IF i = 0 OR NOT IsLData(i) THEN DoBeep: MExitMeth           ' Better be valid
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Fetch the Clipboard data                                                                  |
      '--------------------------------------------------------------------------------------------+
      ClipboardRead(t, MyDLM, %False)                             ' Go get Clipboard, keep the file

      '--------------------------------------------------------------------------------------------+
      '- Extract Clipboard a line at a time                                                        |
      '--------------------------------------------------------------------------------------------+
      DO WHILE LEN(t) > 1                                         ' Loop extracting text lines
         ln = EXTRACT$(t, MyDLM)                                  ' Get one line
         t =  REMAIN$(t, MyDlm)                                   ' Make t = the remainder of the line

         '-----------------------------------------------------------------------------------------+
         '- Skip till eligible line, or insert one if at the end                                   |
         '-----------------------------------------------------------------------------------------+
         WHILE NOT IsLData(i)                                     ' Only paste into data lines
            IF IsLBottom(i) OR IsLFile(i) THEN                    ' Bottom line?  (or bottom of a %File group)
               me.LInsertLines(i - 1, 1, %Data)                   ' Request insert 1, %Data line
               IF IsMEdit THEN                                    ' In MEdit mode?
                  fMIX = me.MEditTbl("I", FORMAT$(i - 1))         ' Go get the MIX value of previous line
                  LMixS(i) = fMIX                                 ' Set into the new line
               END IF                                             '
            ELSE                                                  '
               INCR i                                             '
            END IF                                                '
         WEND                                                     '

         j = @P.C.CLCol                                           ' Get index into string
         tt = LTxtG(i)                                            ' Get working copy of text
         tc = LAttrG(i)                                           ' And Attr line

         '-----------------------------------------------------------------------------------------+
         '- Do it either Insert or non-Insert way                                                  |
         '-----------------------------------------------------------------------------------------+
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF j + LEN(ln) - 1 > LEN(tt) THEN                     '
               tt = LSET$(tt, j + LEN(ln) - 1)                    ' Lengthen if needed
               tc = LSET$(tc, LEN(tt) USING CHR$$(0))             ' Attr as well
            END IF                                                '
            MID$(tt, j, LEN(ln)) = ln                             ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            me.DataInsert(tt, tc, ln, j)                          ' Insert the data
         END IF                                                   '

         IF FCB.ImportTabs > 0 THEN _                             ' Need TAB expansion?
            tt = TAB$(tt, FCB.ImportTabs)                         ' Do any needed tab conversion
         me.LTxtSet(i, tt)                                        ' Save it back
         me.LAttrSet(i, tc)                                       '
         me.UCIfNeeded(i)                                         ' Do UC if CAPS ON
         me.ModSet(i)                                             ' Remember we changed something
         curline = i: curcol = tcol + LEN(ln)                     '
         INCR i                                                   ' Next line
      LOOP                                                        '

      '--------------------------------------------------------------------------------------------+
      '- We're done, clean up and exit                                                             |
      '--------------------------------------------------------------------------------------------+
      @P.PTopLine = lclTop                                        ' Restore CRP
      me.CurSetReq(%LineCmd, curline, curcol, %True)              ' Set cursor set attempt
      DoSet(%Refresh)                                             ' Have it looked at
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krBS()                                                 '
   '-----------------------------------------------------------------------------------------------+
   '- Do a PC type Bksp function                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, x AS LONG, lcltxt, lcltabs, rh AS STRING       '

      MEntry                                                      '                                                                  '
      '--------------------------------------------------------------------------------------------+
      '- Bksp in the command line                                                                  |
      '--------------------------------------------------------------------------------------------+
      IF IsCCmnd THEN                                             ' In Command line
         IF @P.PCOffset > 0 THEN                                  ' Cmd shifted?
            i = @P.C.CCol - @P.PCmdCol + @P.PCOffset              ' Save old cursor location
            pCommand = STRDELETE$(pCommand, i, 1)                 ' Delete char to it's left
            IF @P.C.CCol > @P.PCmdCol AND @P.C.CCol < (@P.PCmdCol + 4) THEN   ' Left hand side?
               @P.PCOffset = MAX(0, @P.PCOffset - (@P.PCmdLen / 2))  '
            END IF                                                '
            me.WindowCmd                                          ' Print the whole string again
            me.CsrCol = i - @P.PCOffset + @P.PCmdCol - 1          ' Move cursor left now
         ELSEIF @P.C.CCol > @P.PCmdCol THEN                       '
            pCommand = STRDELETE$(pCommand, @P.C.CCol - @P.PCmdCol + @P.PCOffset, 1)   ' Delete it
            me.WindowCmd                                          ' Print the whole string again
            me.CsrColSub(1)                                       '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Bksp in the Scroll amount field                                                           |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCScrl THEN                                         ' In Scroll Amt.
         IF @P.C.CCol > @P.PScrData THEN                          ' Room to BKSP?
            FCB.ScrollAmt = STRDELETE$(FCB.ScrollAmt, @P.C.CCol - @P.PScrData + 1, 1) + " "  ' Delete it
            DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, 1, @P.PScrData)  ' Redisplay the entire string
            me.CsrColSub(1)                                       ' Adjust cursor location
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Bksp in the text data area                                                                |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCData THEN                                         ' In Data area?
         IF IsBrowse THEN DoBeep: MExitMeth                       ' Not allowed in Browse mode
         me.AttrInvClearFind                                      ' Clear any Find HiLite
         IF IsBrowse THEN DoBeep: MExitMeth                       ' Not allowed in Browse mode
         me.MarkKill                                              ' Reset the select frame
         me.SwapKill                                              '
         IF @P.C.CCol > @P.PDataCol THEN                          ' Room to BKSP?
            ix = me.SGet(@P.C.CRow)                               ' Get IX of real DataLine
            IF ix = 0 THEN MExitMeth                              ' Bail out if below last line
            IF FCB.HexMode = &4 AND ix < 0 THEN DoBeep: MExitMeth ' If on a non-Char line
            CsrLinDX = 0                                          ' Reset possible hidden DX line location

            IF ISTRUE (LFlagG(ix) AND %NonTypable) THEN           ' Ignore non-typable lines
               '- Null                                            '

            ELSE                                                  '
               me.ModSet(ix)                                      ' Remember we changed something
               i = @P.C.CCol - @P.PGapCol + @P.POffset - 1        ' Calc IX into the Text
               lclTabs = me.TabsSimple(LEN(L(ix).@LTxt))          ' Get a working tabs line
               j = INSTR(i + 1, lclTabs, "*")                     ' Find next tab
               IF ISFALSE FCB.TabBnds OR _                        ' If not TABSBNDS OR
                  (ISTRUE FCB.TabBNDS AND j = 0) THEN             ' TabBNDS and no further tabs?
                  me.LTxtCharDel(ix, i)                           ' Delete 1 char
                  me.LAttrAdjust(ix, i, -1)                       ' Adjust any Attr hilite
               ELSE                                               ' TabBNDS processing
                  lclTxt = LTxtG(ix)                              ' Get the text
                  RH = MID$(lclTxt, j)                            ' Save RH from next tab stop
                  lclTxt = LEFT$(lclTxt, j - 1)                   ' Save LH part
                  lclTxt = STRDELETE$(lclTxt, i, 1) + " " + RH    ' Delete the char, join the line
                  LTxtS(ix) = lclTxt                              ' Save it
                  me.CsrColSub(1)                                 ' Adjust cursor
               END IF                                             '
               me.UCIfNeeded(IX)                                  ' Do UC if CAPS ON
               me.AttrScan(ix)                                    ' Recolorize
               me.DispLine(ix, @P.C.CRow)                         ' Re-display the line

               '-----------------------------------------------------------------------------------+
               '- Extra stuff if in HEX mode                                                       |
               '-----------------------------------------------------------------------------------+
               IF FCB.HexMode = &4 THEN                           ' If Hex mode, do extra
                  IF @P.C.CRow + 1 <= TP.gPBottom THEN            ' Make sure we don't go off the bottom
                     DoPrint (me.WindowHexTop(LTxtG(ix)), $$TxtHi, @P.C.CRow + 1, @P.PDataCol)  ' Print upper hex
                     me.MarkReDraw(@P.C.CRow + 1)                 ' Re-draw the MARK lines
                  END IF                                          '
                  IF @P.C.CRow + 2 <= TP.gPBottom THEN            ' Make sure we don't go off the bottom
                     DoPrint (me.WindowHexBottom(LTxtG(ix)), $$TxtHi, @P.C.CRow + 2, @P.PDataCol)  ' Print lower hex
                     me.MarkReDraw(@P.C.CRow + 2)                 ' Re-draw the MARK lines
                  END IF                                          '
               END IF                                             '
            END IF                                                '
            me.CsrColSub(1)                                       '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Bksp in the Line number area                                                              |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCLinN THEN                                         ' In the Line control area
         ix = me.SGet(@P.C.CRow)                                  ' Get IX of real DataLine
         IF ix = 0 THEN MExitMeth                                 ' Bail out if below last line
         IF me.IsTouchable(ix) THEN                               ' If 1st interaction in the line number area
            LLCtlS(ix) = $BlankLNo: me.CsrCol = @P.PLeft          ' Blank the Line number
            DoPrint (BYCOPY LEFT$(LLCtlG(ix), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
            me.TTblAdd(ix, TRIM$(LLCtlG(ix)))                     ' Update touched items
         END IF                                                   '
         IF @P.C.CCol > @P.PLeft THEN                             ' Room to BKSP?
            LLCtlS(ix) = STRDELETE$(LLCtlG(ix), @P.C.CLCol, 1) + " " ' Delete a char
            me.TTblAdd(ix, TRIM$(LLCtlG(ix)))                     ' Update touched items
            DoPrint (BYCOPY LEFT$(LLCtlG(ix), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
            me.CsrColSub(1)                                       '
         END IF                                                   '
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krChar()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Process normal character                                                                     |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k AS LONG, lclTxt, lclTabs, t, t2, RH AS STRING, tc, RHW AS WSTRING  '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- If text is hilited and this key is within it, replace the marked text                     |
      '--------------------------------------------------------------------------------------------+
      IF IsMarkActive AND IsCData THEN                            ' Hi-lighted text and cursor in Data area?
         IF IsWithin(MarkRect, @P.C.CIX, @P.C.CLCol) THEN         ' Is cursor within the marked area?
            me.AttrInvClearFind                                   ' Clear any Find HiLite
            IF IsBrowse THEN DoBeep: MExitMeth                    ' Not allowed in Browse mode
            IF IsNotNsrtFlag THEN                                 ' Do the non-Insert mode handling
               me.MarkKill                                        ' Reset the select frame
               me.SwapKill                                        '
               FOR i = MarkRect.Top TO MarkRect.Bottom            ' Process each line in the marked area
                  IF ISTRUE IsLData(i) OR ISTRUE IsLNote(i) THEN  ' Just data/note lines
                     me.ModSet(i)                                 ' Remember we changed something
                     lclTxt = LTxtG(i)                            ' Get the text
                     IF LEN(lclTxt) < MarkRect.Right THEN _       ' Need to lengthen
                        lclTxt = LSET$(lclTxt, MarkRect.Right)    ' Do so
                     lclTxt = STRDELETE$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete the characters
                     me.LAttrAdjust(i, MarkRect.Left, -(MarkRect.Right - MarkRect.Left + 1)) ' Adjust any Attr hilite
                     lclTxt = STRINSERT$(lclTxt, gKeyChr, MarkRect.Left)   ' Insert the replacement
                     me.LAttrAdjust(i, MarkRect.Left, 1)          ' Adjust any Attr hilite
                     me.LTxtSet(i, lclTxt)                        ' Put work string back
                     me.AttrScan(i)                               ' Recolorize
                     me.UCIfNeeded(i)                             ' Do UC if CAPS ON
                     me.CurSetReq(%Position, MarkRect.Bottom, MarkRect.Left + 1, %True)   ' Set cursor set attempt
                     me.CsrCol = MarkRect.Left + @P.POffset + @P.PGapCol   '
                  END IF                                          '
               NEXT i                                             '
               DoSet(%Refresh)                                    ' Have it looked at
               MExitMeth                                          '

            ELSE                                                  ' This is the Insert mode version
               FOR i = MarkRect.Top TO MarkRect.Bottom            ' Process each line in the marked area
                  IF ISTRUE IsLData(i) OR ISTRUE IsLNote(i) THEN  ' Just data/note lines
                     me.ModSet(i)                                 ' Remember we changed something
                     lclTxt = LTxtG(i)                            ' Get the text
                     IF LEN(lclTxt) < MarkRect.Right THEN _       ' Need to lengthen
                        lclTxt = LSET$(lclTxt, MarkRect.Right)    ' Do so
                     lclTxt = STRINSERT$(lclTxt, gKeyChr, @P.C.CLCol)   ' Insert the character
                     me.LAttrAdjust(i, @P.C.CLCol, 1)             ' Adjust any Attr hilite
                     me.LTxtSet(i, lclTxt)                        ' Put work string back
                     me.AttrScan(i)                               ' Recolorize
                     me.UCIfNeeded(i)                             ' Do UC if CAPS ON
                  END IF                                          '
               NEXT i                                             '
               INCR MarkRect.Right                                ' Push over the Mark End column
               me.CurSetReq(%Position, @P.C.CIX, @P.C.CLCol + 1, %True) ' Set cursor set attempt
               me.CsrCol = @P.C.CLCol + 1 + @P.POffset + @P.PGapCol  '
               DoSet(%Refresh)                                    ' Have it looked at
               MExitMeth                                          '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Major split -This is the non-INSERT mode                                                  |
      '--------------------------------------------------------------------------------------------+
      IF IsNotNsrtFlag THEN                                       ' Do the non-Insert mode handling

         '-----------------------------------------------------------------------------------------+
         '- Type in the Command line                                                               |
         '-----------------------------------------------------------------------------------------+
         IF IsCCmnd THEN                                          ' In Command line
            me.pCmdCharRep(@P.C.CLCol, gKeyChr)                   ' Just overlay the Key into the string
            me.WindowCmd                                          '
            IF @P.C.CSCol = @P.PCmdLen THEN                       ' In the last position?
               me.COffsetAdd(1)                                   ' Shift a bit
               me.CsrColAdd(0)                                    ' To trigger CsrMode update
               me.WindowCmd                                       ' Re-do the command line
            ELSE                                                  '
               me.CsrColAdd(1)                                    ' Adjust cursor
            END IF                                                '
            MExitMeth                                             ' Exit to avoid kbRight on SUB exit

         '-----------------------------------------------------------------------------------------+
         '- Type in the Scroll amount field                                                        |
         '-----------------------------------------------------------------------------------------+
         ELSEIF IsCScrl THEN                                      ' In the Scroll Amt area?
            me.ProfScrlRep(@P.C.CLCol, gKeyChr)                   ' Just overlay the Key into the string
            DoPrint (gKeyChr, $$TxtLo, @P.C.CRow, @P.C.CCol)      '

         '-----------------------------------------------------------------------------------------+
         '- Type in the text data area                                                             |
         '-----------------------------------------------------------------------------------------+
         ELSEIF IsCData THEN                                      ' In the Data Area?
            me.AttrInvClearFind                                   ' Clear any Find HiLite
            IF IsBrowse THEN DoBeep: MExitMeth                    ' Not allowed in Browse mode
            me.MarkKill                                           ' Reset the select frame
            me.SwapKill                                           '
            j = @P.PS(@P.C.CRow)                                  ' Get raw line index type
                                                                  '
            IF ISTRUE (LFlagG(@P.C.CIX) AND %NonTypable) THEN     ' Ignore non-typable lines
               DoBeep                                             '

            ELSE                                                  '
               t = lTxtG(@P.C.CIX)                                ' Get current text
               me.ModSet(@P.C.CIX)                                ' Remember we changed something
               IF @P.C.CLCol > LEN(t) THEN                        ' If right of the end-of-text, lengthen it to reach
                  k = @P.C.CLCol - LEN(t)                         '
                  me.LTxtSet(@P.C.CIX, t + STRING$(k, " "))       '
               END IF                                             '
               IF FCB.HexMode = &1 THEN                           ' If not hex mode
                  me.LTxtCharRep(@P.C.CIX, @P.C.CLCol, gKeyChr)   ' Now overlay the Key into the string
                  me.AttrScan(@P.C.CIX)                           ' Recolorize
                  me.UCIfNeeded(@P.C.CIX)                         ' Do UC if CAPS ON
                  me.DispLine(@P.C.CIX, @P.C.CRow)                ' Re-display the line

               '-----------------------------------------------------------------------------------+
               '- Lots of work in HEX mode                                                         |
               '-----------------------------------------------------------------------------------+
               ELSE                                               '
                  SELECT CASE j                                   ' Handle differently for Char/Upper/Lower

                     '-----------------------------------------------------------------------------+
                     '- Upper Hex line                                                             |
                     '-----------------------------------------------------------------------------+
                     CASE -1                                      ' Upper hex
                        GOSUB HexVal                              ' Validate it
                        gKeyChr = StrChgHexUpper(gKeyChr, MID$(LTxtG(@P.C.CIX), @P.C.CLCol, 1)) ' Go insert the upper half
                        me.LTxtCharRep(@P.C.CIX, @P.C.CLCol, gKeyChr)   ' Overlay the Key into the string
                        DoPrint (gKeyChr, $$TxtLo, @P.C.CRow - 1, @P.C.CCol)  '
                        me.MarkReDraw(@P.C.CRow - 1)              ' Re-draw the MARK lines
                        DoPrint (me.WindowHexTop(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow, @P.PDataCol)   ' Print upper hex
                        me.MarkReDraw(@P.C.CRow)                  ' Re-draw the MARK lines

                     '-----------------------------------------------------------------------------+
                     '- Lower HEX line                                                             |
                     '-----------------------------------------------------------------------------+
                     CASE -2                                      ' Lower hex
                        GOSUB HexVal                              ' Validate it
                        gKeyChr = StrChgHexLower(gKeyChr, MID$(LTxtG(@P.C.CIX), @P.C.CLCol, 1)) ' Go insert the lower half
                        me.LTxtCharRep(@P.C.CIX, @P.C.CLCol, gKeyChr)   ' Overlay the Key into the string
                        DoPrint (gKeyChr, $$TxtLo, @P.C.CRow - 2, @P.C.CCol)  '
                        me.MarkReDraw(@P.C.CRow - 2)              ' Re-draw the MARK lines
                        DoPrint (me.WindowHexBottom(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow, @P.PDataCol)   ' Print lower hex
                        me.MarkReDraw(@P.C.CRow)                  ' Re-draw the MARK lines

                     '-----------------------------------------------------------------------------+
                     '- Dash line                                                                  |
                     '-----------------------------------------------------------------------------+
                     CASE -3                                      ' Dash line
                        DoBeep: MExitMeth                         ' do nothing

                     '-----------------------------------------------------------------------------+
                     '- Normal character line                                                      |
                     '-----------------------------------------------------------------------------+
                     CASE ELSE                                    ' Normal Char
                        me.LTxtCharRep(@P.C.CIX, @P.C.CLCol, gKeyChr)   ' Overlay the Key into the string
                        me.AttrScan(@P.C.CIX)                     ' Recolorize
                        me.DispLine(@P.C.CIX, @P.C.CRow)          ' Re-display the line
                        IF @P.C.CRow + 1 <= TP.gPBottom THEN      ' Make sure we don't go off the bottom
                           DoPrint (me.WindowHexTop(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 1, @P.PDataCol)  ' Print upper hex
                           me.MarkReDraw(@P.C.CRow + 1)           ' Re-draw the MARK lines
                        END IF                                    '
                        IF @P.C.CRow + 2 <= TP.gPBottom THEN      ' Make sure we don't go off the bottom
                           DoPrint (me.WindowHexBottom(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 2, @P.PDataCol)  ' Print lower hex
                           me.MarkReDraw(@P.C.CRow + 2)           ' Re-draw the MARK lines
                        END IF                                    '
                  END SELECT                                      '
               END IF                                             '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- Line number area                                                                       |
         '-----------------------------------------------------------------------------------------+
         ELSEIF IsCLinN THEN                                      ' In the Line Number area?
            IF me.IsTouchable(@P.C.CIX) THEN                      ' If 1st interaction in the line number area
               me.LFlagBitOff(@P.C.CIX, %EQChange)                ' Reset ==CHG>
               LLCtlS(@P.C.CIX) = $BlankLNo: me.CsrCol = @P.PLeft ' Blank the Line number
               DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
            END IF                                                '
            me.LLCtlCharRep(@P.C.CIX, @P.C.CLCol, gKeyChr)        ' Overlay the Key into the LineNum string
            me.TTblAdd(@P.C.CIX, TRIM$(LLCtlG(@P.C.CIX)))         ' Update touched items
            DoPrint (gKeyChr, $$TxtLo, @P.C.CRow, @P.C.CCol)      '
         ELSE                                                     '
            DoBeep: MExitMeth                                     '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- INSERT mode versions                                                                      |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' Do all the same stuff in Insert mode

         '-----------------------------------------------------------------------------------------+
         '- Type Insert mode command line                                                          |
         '-----------------------------------------------------------------------------------------+
         IF IsCCmnd THEN                                          ' In Command line
            IF @P.C.CLCol > LEN(pCommand) THEN                    ' If too short, lengthen it
               pCommand += SPACE$(@P.C.CLCol - LEN(pCommand) - 1) '
            END IF                                                '
            pCommand = STRINSERT$(pCommand, gKeyChr, @P.C.CLCol)  ' Insert the Key
            IF @P.C.CSCol = @P.PCmdLen THEN                       ' In the last position?
               me.COffsetAdd(1)                                   ' Shift a bit
               me.CsrColAdd(0)                                    ' To trigger CsrMode update
            ELSE                                                  '
               me.CsrColAdd(1)                                    ' Adjust cursor
            END IF                                                '
            me.WindowCmd                                          ' Re-do the command line
            MExitMeth                                             ' Exit to avoid kbRight on SUB exit

         '-----------------------------------------------------------------------------------------+
         '- Type Insert mode Scroll amount field                                                   |
         '-----------------------------------------------------------------------------------------+
         ELSEIF IsCScrl THEN                                      ' In the Scroll Amt  area?
            FCB.ScrollAmt = LEFT$(STRINSERT$(FCB.ScrollAmt, gKeyChr, @P.C.CLCol), 4)   ' Insert the Key
            DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, 1, @P.PScrData)  ' Print the whole string again

         '-----------------------------------------------------------------------------------------+
         '- Type Insert mode text data area                                                        |
         '-----------------------------------------------------------------------------------------+
         ELSEIF IsCData THEN                                      ' In the Data area?
            me.AttrInvClearFind                                   ' Clear any Find HiLite
            IF IsBrowse THEN DoBeep: MExitMeth                    ' Not allowed in Browse mode
            me.MarkKill                                           ' Reset the select frame
            me.SwapKill                                           '
            j = @P.PS(@P.C.CRow)                                  ' Get raw line index type
            IF FCB.HexMode = &4 AND j < 0 THEN DoBeep: MExitMeth  ' Insert and in the Hex lines? Bad.
            i = @P.C.CCol - @P.PGapCol + @P.POffset               ' Calc index into string

            IF ISTRUE (LFlagG(@P.C.CIX) AND %NonTypable) THEN     ' Ignore non-typable lines
               DoBeep                                             '

            ELSE                                                  '
               lclTabs = me.TabsSimple(LEN(L(@P.C.CIX).@LTxt))    ' Get a working tabs line
               j = INSTR(i + 1, lclTabs, "*")                     ' Find next tab
               me.ModSet(@P.C.CIX)                                ' Remember we changed something
               IF ISFALSE FCB.TabBnds OR _                        ' If not TABSBNDS OR
                  (ISTRUE FCB.TabBNDS AND j = 0) OR _             ' TabBNDS and no further tabs?
                  KBTabFree THEN                                  ' TabFree has been set
                  t = lTxtG(@P.C.CIX)                             ' Get current text
                  tc = lAttrG(@P.C.CIX)                           ' And the attributes
                  me.DataInsert(t, tc, gKeyChr, @P.C.CLCol)       ' Do the insert
                  me.LTxtSet(@P.C.CIX, t)                         ' Save text
                  me.LAttrSet(@P.C.CIX, tc)                       ' Save attr
                  me.UCIfNeeded(@P.C.CIX)                         ' Do UC if CAPS ON

                  me.AttrScan(@P.C.CIX)                           ' Recolorize
                  me.DispLine(@P.C.CIX, @P.C.CRow)                ' Re-display the line

               ELSE                                               ' TabsBNDS AND a further Tab
                  '--------------------------------------------------------------------------------+
                  '- Insert in TabsBNDS mode                                                       |
                  '--------------------------------------------------------------------------------+
                  t = LEFT$(lTxtG(@P.C.CIX), j - 1)               ' Get current text LH
                  t2 = t                                          ' Save before change
                  RH = MID$(lTxtG(@P.C.CIX), j)                   ' Get current text RH
                  tc = LEFT$(lAttrG(@P.C.CIX), j - 1)             ' Get Attr line LH
                  RHW = MID$(lAttrG(@P.C.CIX), j)                 ' Get Attr line RH
                  me.DataInsert(t, tc, gKeyChr, @P.C.CLCol)       ' Do the insert
                  IF LEN(t2) = LEN(t) THEN                        ' If length unchanged
                                                                  '                                            ' Leave t alone
                  ELSEIF ISNULL(TRIM$(RH)) THEN                   ' or no data to the right
                     KBTabFree = %True                            ' Release tab checking
                  ELSEIF RIGHT$(t, 1) = " " THEN                  ' Can we truncate it?
                     t = CLIP$(RIGHT, t, 1)                       '
                     tc = CLIP$(RIGHT, tc, 1)                     '
                  ELSE                                            ' KB Lock time
                     DoBeep                                       ' No, column overflow, kill it
                     MexitMeth                                    ' Bail out
                  END IF                                          '
                  t = t + RH                                      ' Join line together again
                  tc = tc + RHW                                   '
                  me.LTxtSet(@P.C.CIX, t)                         ' Save text
                  me.LAttrSet(@P.C.CIX, tc)                       ' Save attr
                  me.UCIfNeeded(@P.C.CIX)                         ' Do UC if CAPS ON

                  me.AttrScan(@P.C.CIX)                           ' Recolorize
                  me.DispLine(@P.C.CIX, @P.C.CRow)                ' Re-display the line
               END IF                                             '
               '-----------------------------------------------------------------------------------+
               '- Hex mode version                                                                 |
               '-----------------------------------------------------------------------------------+
               IF FCB.HexMode = &4 THEN                           ' If Hex mode, do extra
                  IF @P.C.CRow + 1 <= TP.gPBottom THEN            ' Make sure we don't go off the bottom
                     DoPrint (me.WindowHexTop(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 1, @P.PDataCol)  ' Print upper hex
                     me.MarkReDraw(@P.C.CRow + 1)                 ' Re-draw the MARK lines
                  END IF                                          '
                  IF @P.C.CRow + 2 <= TP.gPBottom THEN            ' Make sure we don't go off the bottom
                     DoPrint (me.WindowHexBottom(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 2, @P.PDataCol)  ' Print lower hex
                     me.MarkReDraw(@P.C.CRow + 2)                 ' Re-draw the MARK lines
                  END IF                                          '
               END IF                                             '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- Type Insert mode Line number area                                                      |
         '-----------------------------------------------------------------------------------------+
         ELSEIF IsCLinN THEN                                      ' In Line Number area?
            gKeyChr = UUCASE(gKeyChr)                             ' Make all Uppercase

            IF me.IsTouchable(@P.C.CIX) THEN                      ' If 1st interaction in the line number area
               me.LFlagBitOff(@P.C.CIX, %EQChange)                ' Reset ==CHG>
               LLCtlS(@P.C.CIX) = $BlankLNo: me.CsrCol = @P.PLeft ' Blank the Line number
               DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
            END IF                                                '
            LLCtlS(@P.C.CIX) = LEFT$(STRINSERT$(LLCtlG(@P.C.CIX), gKeyChr, @P.C.CLCol), 8)   '

            DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) '
            me.TTblAdd(@P.C.CIX, TRIM$(LLCtlG(@P.C.CIX)))         ' Update touched items
         ELSE                                                     '
            DoBeep: MExitMeth                                     '
         END IF                                                   '

      END IF                                                      '
      krRight                                                     ' We can finally move over to the next column
      MExitMeth                                                   ' We're done

   HexVal:                                                        '
      IF INSTR("0123456789ABCDEF", UUCASE(gKeyChr)) = 0 THEN      '
         DoBeep: MExitMeth                                        ' Better be valid Hex char
      END IF                                                      '
      gKeyChr = UUCASE(gKeyChr)                                   ' Uppercase it
      RETURN                                                      ' OK, Back
   END METHOD                                                     '

   METHOD  krClearInsert()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Reset all Insert modes                                                                       |
   '-----------------------------------------------------------------------------------------------+
      OffNsrtSave                                                 ' Reset everything
      OffNsrtSaveD                                                '
      OffNsrtFlag                                                 '
      OffNsrtData                                                 '
      IF gENV.Insmode THEN OnNsrtFlag                             ' Set the Options default
      FCB.TabBNDS = %False                                        ' Reset TabBNDS
      DoSet(%Attention)                                           ' Call Attention
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar INS/OVR box
   END METHOD                                                     '

   METHOD  krClipClear()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- Clear the clipboard                                                                          |
   '-----------------------------------------------------------------------------------------------+
      ClipboardWrite("")                                          ' Write null to the clipboard
   END METHOD                                                     '

   METHOD  krClipDate()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Stuff Date into the clipboard                                                                |
   '-----------------------------------------------------------------------------------------------+
      ClipboardWrite(DateWinFormat())                             ' Write it
   END METHOD                                                     '

   METHOD  krClipISODate()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Put ISO Date into the Clipboard                                                              |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = DATE$                                                  ' Go get the date
      ln = MID$(ln, 7) + "-" + LEFT$(ln, 2) + "-" + MID$(ln, 4, 2)   ' Reformat it to ISO standard
      ClipboardWrite(ln)                                          ' Write it
   END METHOD                                                     '

   METHOD  krClipISOTime()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Put ISO Time into the Clipboard                                                              |
   '-----------------------------------------------------------------------------------------------+
      ClipboardWrite(TIME$)                                       ' Write it
   END METHOD                                                     '

   METHOD  krClipName()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Stuff file name into the clipboard                                                           |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING, i, j AS LONG                               '
      ln = TP.FCB_.File                                           ' Get the filename
      IF IsMEdit THEN                                             ' In a multi edit session, more to do
         IF ISFALSE IsCData AND ISFALSE IsCLinN THEN DoBeep: EXIT METHOD   ' Ignore totally if not in Data area
         IF @P.C.CIX = 0 THEN DoBeep: EXIT METHOD                 ' Exit if below bottom line
         i = me.MEditTbl("I", FORMAT$(@P.C.CIX))                  ' Get the Medit index
         ln = me.MEditListGet(i)                                  ' Get the MEdit filename
         j = INSTR(-1, ln, "\")                                   ' Find last \
         IF j THEN ln = MID$(ln, j + 1)                           ' Reduce to just filename
      END IF                                                      '
      ClipboardWrite(ln)                                          ' Write it
   END METHOD                                                     '

   METHOD  krClipPath()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Stuff full file path into the clipboard                                                      |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING, i AS LONG                                  '
      ln = TP.FCB_.FilePath                                       ' Get the full path
      IF IsMEdit THEN                                             ' In a multi edit session, more to do
         IF ISFALSE IsCData AND ISFALSE IsCLinN THEN DoBeep: EXIT METHOD   ' Ignore totally if not in Data area
         IF @P.C.CIX = 0 THEN DoBeep: EXIT METHOD                 ' Exit if below bottom line
         i = me.MEditTbl("I", FORMAT$(@P.C.CIX))                  ' Get the Medit index
         ln = me.MEditListGet(i)                                  ' Get the MEdit filename
      END IF                                                      '
      ClipboardWrite(ln)                                          ' Write it
   END METHOD                                                     '

   METHOD  krClipTime()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Stuff Time into the clipboard                                                                |
   '-----------------------------------------------------------------------------------------------+
      ClipboardWrite(Time12HR)                                    ' Write it
   END METHOD                                                     '

   METHOD   krCmdHome()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Get to nearest command area                                                                  |
   '-----------------------------------------------------------------------------------------------+
      IF IsCData OR IsCLinN THEN                                  ' In a line area somewhere
         me.CsrCol = @P.PLeft                                     ' Go back to LCmd area
      ELSE                                                        ' Somewhere else
         pCommand = LTRIM$(pCommand)                              ' Trim command
         me.WindowCmd                                             ' Re-do the command line
         SetCmd                                                   ' Set the cursor
      END IF                                                      '
   END METHOD                                                     '

   METHOD   krCmdLog()                                            '
   LOCAL lclFn, lclTime AS STRING                                 '
   LOCAL LTime AS IPOWERTIME                                      '
      MEntry                                                      '
      LET LTime = CLASS "PowerTime"                               ' Create a PowerTime object
      LTime.Now                                                   ' Use current timestamp
      lclTime = FORMAT$(LTime.year(), "0000") + FORMAT$(LTime.Month(), "00") + FORMAT$(LTime.day(), "00") + "." + _  '
                FORMAT$(LTime.Hour(), "00") + FORMAT$(LTime.Minute(), "00")   '

   '-----------------------------------------------------------------------------------------------+
   '- Toggle the CmdLog trace On or Off                                                            |
   '-----------------------------------------------------------------------------------------------+
      IF ISTRUE gCmdLogFlag THEN                                  ' If ON, then turn off
         CLOSE # gCmdLogFn                                        ' Then close it
         gCmdLogFlag = %False                                     '
         TP.ErrMsgAdd(%eNone, "Cmd Logging stopped")              ' Say we've done so
         DoSet(%Attention)                                        ' Get it issued
      ELSE                                                        ' else turn it on
         lclTime = FORMAT$(LTime.year(), "0000") + FORMAT$(LTime.Month(), "00") + FORMAT$(LTime.day(), "00") + "." + _  '
                   FORMAT$(LTime.Hour(), "00") + FORMAT$(LTime.Minute(), "00")   '
         gCmdLogFn = FREEFILE                                     ' Get a file number
         lclFn = gENV.HomeData + "SPFCmdLog." + lclTime + ".TXT"  ' Build the file name
            Call3(TryOpenOutPut(lclFn, gCmdLogFn), _              ' Try the open
                  DoMessageBox("Error OPENing log file", %MB_OK OR %MB_USERICON, "CmdLog"): MExitMeth, _ '
                  DoMessageBox("Error, LOG file is in use?", %MB_OK OR %MB_USERICON, "CmdLog"): MExitMeth, _   '
                  Nul)                                            ' Continue
         gCmdLogFlag = %True                                      ' Turn on the flag
         TP.ErrMsgAdd(%eNone, "Cmd Logging started")              ' Say we've done so
         DoSet(%Attention)                                        ' Get it issued
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD   krCmdPad()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Stuff CmdPad data into the KB stream                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i AS LONG                                                '
   LOCAL DMsg AS KBMsg                                            '
      MEntry                                                      '
      i = DOCmdLoadMac("CMDPAD")                                  ' Get CMDPAD loaded
      IF i = 0 THEN _                                             '
         MErrExit(%eFail, "There is no CMDPAD.CLIP file, or it is empty")  '
      '-------------------------------------------------------------------------------------------+
      '- Now get them executed                                                                     |
      '--------------------------------------------------------------------------------------------+
      MID$(DMsg.kbString, 1, 1) = CHR$(5)                         ' Flag 1st byte as Hex 5 - DO execute
      MID$(DMsg.kbString, 2, 1) = CHR$(0)                         ' Flag 2nd byte as null
      DMsg.kbInt(1) = 0                                           ' Copy Int as zero
      i = PostMessage(ghWnd, %WM_USER, DMsg.MsgwParam, 0)         ' To the mainline Callback routine
      Mexit                                                       '
   END METHOD                                                     '

   METHOD  krColumn()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Jump to specified column                                                                     |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ccCol, HexRow AS LONG                                    '
      ccCol = IIF(VAL(gKeyPrimOper) > 0, VAL(gKeyPrimOper), 1)    ' Set the column number
      IF @P.C.CIX = 0 THEN EXIT METHOD                            ' Exit if below bottom line
      IF @P.C.CIX < 0 THEN                                        ' A Hex line?
         HexRow = ABS(@P.C.CIX)                                   ' Save the hex line
         @P.C.CIX = @P.C.CIX - ABS(@P.C.CIX)                      ' Get real data line
      END IF                                                      '
      me.CurSetReq(%Position, @P.C.CIX, ccCol, %True, 0, HexRow)  ' Set cursor set attempt
      OnInsClnSupp                                                ' Suppress Insert cleanup for 1 Attn pass
      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  krComments()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Handle comment positioning                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, lclCmntStart AS LONG, t, linetext, linecmnt, sCmnt, eCmnt AS STRING  '
      IF (ISFALSE IsCData AND ISFALSE IsCLinN) OR _               ' Not in the Data Area? Exit.
         FCB.HexMode = 4 OR _                                     ' HEX mode, also exit
         FCB.CmntCol = 0 THEN EXIT METHOD                         ' No comment column, also exit
      IF @P.C.CIX = 0 THEN EXIT METHOD                            ' Exit if below bottom line
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      me.MarkKill                                                 ' Reset the select frame
      me.SwapKill                                                 '
      '--------------------------------------------------------------------------------------------+
      '- See what we have to do                                                                    |
      '--------------------------------------------------------------------------------------------+
      sCmnt = Cmnt.GTxt1(FCB.CmntID)                              ' Get opening comment
      eCmnt = Cmnt.GTxt2(FCB.CmntID)                              ' Get closing comment
      t = lTxtG(@P.C.CIX)                                         ' Get current text in line
      me.ModSet(@P.C.CIX)                                         ' Remember we changed something
      IF ISNULL(TRIM$(t)) THEN                                    ' A blank line?
         '-----------------------------------------------------------------------------------------+
         '- Null Line                                                                              |
         '-----------------------------------------------------------------------------------------+
         t = SPACE$(FCB.CmntCol - 1) + sCmnt                      ' Build the line
         me.CurSetReq(%Position, @P.C.CIX, FCB.CmntCol + LEN(sCmnt) + 1, %True)  ' Set cursor set attempt
         IF ISNOTNULL(eCmnt) THEN t = LSET$(t, FCB.CmntEnd - 1) + eCmnt ' Add the closing if needed
         GOTO CmntDone                                            ' We're done
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Line with data in it                                                                      |
      '--------------------------------------------------------------------------------------------+
      lclCmntStart = me.GetCmntStart(t)                           ' Get loc of comment on this line
      IF lclCmntStart = 0 THEN                                    ' No existing comment?
         '-----------------------------------------------------------------------------------------+
         '- No existing comment                                                                    |
         '-----------------------------------------------------------------------------------------+
         i = LEN(RTRIM$(t)) + 1                                   ' Point past end-of-text
         j = FCB.CmntCol                                          ' Point at standard location+
         IF i > j THEN DO UNTIL j > i: j += FCB.CmntIncr: LOOP    ' Shift right if needed
         t = LSET$(t, j - 1) + sCmnt                              ' Build the line
         me.CurSetReq(%Position, @P.C.CIX, j + LEN(sCmnt) + 1, %True)   ' Set cursor set attempt
         j = MAX(j + LEN(sCmnt) + 1, FCB.CmntEnd - 1)             ' Set next possible end comment
         IF ISNOTNULL(eCmnt) THEN t = LSET$(t, j) + eCmnt         ' Add the closing if needed
         GOTO CmntDone                                            ' We're done
      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '- Line has an existing comment                                                           |
         '-----------------------------------------------------------------------------------------+
         k = 0: IF ISNOTNULL(eCmnt) THEN k = INSTR(-1, t, eCmnt)  ' See if an ending comment
         linetext = RTRIM$(LEFT$(t, lclCmntStart - 1))            ' Separate text and comment
         linecmnt = RTRIM$(IIF$(k, MID$(t, lclCmntStart TO k - 1), MID$(t, lclCmntStart)))   '
         i = LEN(linetext) + 1                                    ' Point past end-of-text
         j = FCB.CmntCol                                          ' Point at standard location+
         IF i >= j THEN DO UNTIL j > i: j += FCB.CmntIncr: LOOP   ' Shift right if needed
         t = LSET$(linetext, j - 1) + linecmnt                    ' Build the line
         IF ISNOTNULL(eCmnt) THEN                                 ' Need to add eCmnt?
            t = IIF$(LEN(t) > FCB.CmntEnd, t + " " + eCmnt, LSET$(t, FCB.CmntEnd - 1) + eCmnt)  '
         END IF                                                   '
         GOTO CmntDone                                            ' We're done
      END IF                                                      '

      CmntDone:                                                   '
         me.LTxtSet(@P.C.CIX, t)                                  ' Store it
         me.AttrScan(@P.C.CIX)                                    ' Recolorize
         me.DispLine(@P.C.CIX, @P.C.CRow)                         ' Re-display the line
         DoSet(%Refresh)                                          ' Have it looked at
   END METHOD                                                     '

   METHOD  krCondLineNo()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Conditional LineNo key                                                                       |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, l AS LONG                                       '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      l = @P.C.CRow                                               ' Copy row

      '--------------------------------------------------------------------------------------------+
      '- Only if in an eligible line                                                               |
      '--------------------------------------------------------------------------------------------+
      l = MAX(@P.C.CRow, @P.PData1)                               ' Step past headers if needed
      FOR i = l TO 300                                            ' Search screen lines
         j = @P.PS(i)                                             ' Get the L() index from S()
         IF j = 0 AND k = 0 THEN DoBeep: EXIT FOR                 '
         IF IsLData(j) THEN me.CsrRow = i: me.CsrCol = @P.PLeft: EXIT METHOD  ' Got a line number of a data line?
         IF IsLTop(j) THEN k = i                                  ' Save Top if seen
      NEXT i                                                      '
      IF k THEN me.CsrRow = k: me.CsrCol = @P.PLeft               '
   END METHOD                                                     '

   METHOD  krCopyLCmd()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Copy the line command (if present)                                                           |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i AS LONG, CBD AS STRING                                 '
      IF ISFALSE IsCData AND ISFALSE IsCLinN THEN                 ' Not a valid location?
         CBD = " "                                                ' Clear the clipboard
         ClipboardWrite(CBD)                                      '
         EXIT METHOD                                              ' All done
      END IF                                                      '

      IF LLCtlG(@P.C.CIX) <> LLNumG(@P.C.CIX) THEN CBD = LLCtlG(@P.C.CIX)  ' Get the LLCtl data
      ARRAY SCAN gLnoTextTxt(), = LSET$(CBD, 8), TO i             ' One of the special lines?
      IF i OR LEFT$(CBD, 1) = "." OR LEFT$(CBD, 1) = ":" THEN CBD = " " ' If special or a label or a tag, then null the CBD

      '--------------------------------------------------------------------------------------------+
      '- Stuff it in the clipboard                                                                 |
      '--------------------------------------------------------------------------------------------+
      ClipboardWrite(CBD)                                         ' Write it
   END METHOD                                                     '

   METHOD   krCopyPaste()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do Copy or Paste depending on whether selected                                               |
   '-----------------------------------------------------------------------------------------------+
      IF (IsMarkActive AND IsMarkDrawn) OR _                      ' Is something selected
         (IsMiscActive AND IsMiscDrawn) THEN                      '
         krKCpy                                                   ' yes, COPY it
      ELSE                                                        '
         IF IsBrowse THEN DoBeep: EXIT METHOD                     ' Not allowed in Browse mode
         IF IsFMTab THEN                                          ' FM screen?
            FMkbPaste                                             ' Do it that way
         ELSE                                                     '
            krPaste                                               ' No? Normal Paste
         END IF                                                   '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krCopyPasteAdd()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Block copypaste in ADD mode                                                                  |
   '-----------------------------------------------------------------------------------------------+
      gKeyPrimOper = "$RAA" + gKeyPrimOper                        ' Tell krCopyPaste it's ADD mode
      CALL krCopyPaste()                                          ' Let IT do the work
   END METHOD                                                     '

   METHOD  krCopyPasteRaw()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Block copypaste in RAW mode                                                                  |
   '-----------------------------------------------------------------------------------------------+
      gKeyPrimOper = "$RAW" + gKeyPrimOper                        ' Tell krCopyPaste it's RAW mode
      CALL krCopyPaste()                                          ' Let IT do the work
   END METHOD                                                     '

   METHOD  krCtlLeft()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Tab Left one 'word'-                                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j AS LONG                                             '
   LOCAL t, CS AS STRING                                          '
      MEntry                                                      '
      CS = gENV.CharSet                                           '
      '--------------------------------------------------------------------------------------------+
      '- Make sure we're in a valid location                                                       |
      '--------------------------------------------------------------------------------------------+
      IF IsCCmnd THEN                                             ' Command line
         t = RTRIM$(PCommand)                                     ' Get a copy of the text
         i = @P.C.CLCol                                           ' Where is cursor now
         IF i = 1 THEN MExitMeth                                  ' Nothing to do
         i = MIN(i, LEN(t))                                       ' Set start scan
         '-----------------------------------------------------------------------------------------+
         '- Command Line - On space between words?                                                 |
         '-----------------------------------------------------------------------------------------+
         IF MID$(t, i, 1) = " " THEN                              ' Currently sitting on a blank?
            j = INSTR(-(LEN(t) - i) - 2, t, ANY CS)               ' Look for prev visible character
            j = INSTR(-(LEN(t) - j)  - 2, t, " ") + 1             ' Look for prev blank
            IF j = 0 THEN MExitMeth                               ' None?
            IF j < @P.PCOffset + 1 THEN @P.PCOffset = j - 1       ' Adjust Offset if needed
            me.CsrCol = j + 10 - @P.PCOffset                      ' Just move cursor on the screen
            me.WindowCmd                                          ' Re-do the command line

         ELSE                                                     ' We're sitting on a character
            '--------------------------------------------------------------------------------------+
            '- Command Line - Sitting on 1st character of a word                                   |
            '--------------------------------------------------------------------------------------+
            IF i > 1 AND MID$(t, i - 1, 1) = " " THEN             ' Are we sitting on the 1st char of a word?
               j = INSTR(-(LEN(t) - i) - 3, t, ANY CS)            ' Look for prev visible character
               j = INSTR(-(LEN(t) - j) - 2, t, " ") + 1           ' Look for prev blank
               IF j < @P.PCOffset + 1 THEN @P.PCOffset = j - 1    ' Adjust Offset if needed
               me.CsrCol = j + 10 - @P.PCOffset                   ' Just move cursor on the screen
               me.WindowCmd                                       ' Re-do the command line

            ELSE                                                  ' Sitting on other than 1st char of word
               '-----------------------------------------------------------------------------------+
               '- Command Line - Sitting on some other character in the word                       |
               '-----------------------------------------------------------------------------------+
               j = INSTR(-(LEN(t) - i) - 2, t, " ") + 1           ' Look for prev blank + 1
               IF j = 0 THEN MExitMeth                            ' None?
               IF j < @P.PCOffset + 1 THEN @P.PCOffset = j - 1    ' Adjust Offset if needed
               me.CsrCol = j + 10 - @P.PCOffset                   ' Just move cursor on the screen
               me.WindowCmd                                       ' Re-do the command line
            END IF                                                '
         END IF                                                   '
         MExitMeth                                                '
      END IF                                                      '

      IF IsCLinN THEN GOSUB PrevLine: MExitMeth                   ' In Line # area, go back
      IF ISFALSE IsCData THEN MExitMeth                           ' Ignore totally if not in Data area
      IF @P.C.CIX = 0 THEN MExitMeth                              ' Exit if below bottom line
      IF ISFALSE IsLData(@P.C.CIX) AND ISFALSE IsLNote(@P.C.CIX) THEN GOSUB PrevLine: MExitMeth ' Also must be on a data/note line

      '--------------------------------------------------------------------------------------------+
      '- Get local copy of the text and the column # we're in                                      |
      '--------------------------------------------------------------------------------------------+
      t = RTRIM$(LTxtG(@P.C.CIX))                                 ' Get a copy of the text
      i = @P.C.CCol + @P.POffset - @P.PGapCol                     ' Where is cursor now

      '--------------------------------------------------------------------------------------------+
      '- Col 1, simple, go to prev line                                                            |
      '--------------------------------------------------------------------------------------------+
      IF i = 1 THEN                                               ' Column 1? (The simple one)
         GOSUB PrevLine                                           ' Then Prev line
         MExitMeth                                                ' We're done
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Past the End, go to the last word                                                         |
      '--------------------------------------------------------------------------------------------+
      IF i > LEN(RTRIM$(t)) THEN                                  ' At or past last char?
         GOSUB CurrLastWord                                       ' Go to Last Word
         MExitMeth                                                ' We're done
      '--------------------------------------------------------------------------------------------+
      '- Within the actual text, work to do                                                        |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' Within line, find next location

         '-----------------------------------------------------------------------------------------+
         '- On space between words?                                                                |
         '-----------------------------------------------------------------------------------------+
         IF MID$(t, i, 1) = " " THEN                              ' Currently sitting on a blank?
            j = INSTR(-(LEN(t) - i) - 2, t, ANY CS)               ' Look for prev visible character
            j = INSTR(-(LEN(t) - j)  - 2, t, " ") + 1             ' Look for prev blank
            IF j = 0 THEN                                         ' None?
               GOSUB PrevLine                                     ' Go to prev line then
            ELSE                                                  ' We've got the next 'word'
               IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, @P.C.CIX, j, %True)     ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               '
                  me.CsrCol = j + @P.PGapCol - @P.POffset         ' Just move cursor on the screen
               END IF                                             '
            END IF                                                '

         ELSE                                                     ' We're sitting on a character

            '--------------------------------------------------------------------------------------+
            '- Sitting on 1st character of a word                                                  |
            '--------------------------------------------------------------------------------------+
            IF i > 1 AND MID$(t, i - 1, 1) = " " THEN             ' Are we sitting on the 1st char of a word?
               j = INSTR(-(LEN(t) - i) - 3, t, ANY CS)            ' Look for prev visible character
               j = INSTR(-(LEN(t) - j) - 2, t, " ") + 1           ' Look for prev blank
               IF j = 0 THEN                                      ' None?
                  GOSUB PrevLine                                  ' Go to prev line then
               ELSE                                               ' We've got the next 'word'
                  IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                     me.CurSetReq(%Position, @P.C.CIX, j, %True)  ' No, Set cursor set attempt
                     DoSet(%Refresh)                              ' Have it looked at
                  ELSE                                            '
                     me.CsrCol = j + @P.PGapCol - @P.POffset      ' Just move cursor on the screen
                  END IF                                          '
               END IF                                             '

            ELSE                                                  ' Sitting on other than 1st char of word
               '-----------------------------------------------------------------------------------+
               '- Sitting on some other character in the word                                      |
               '-----------------------------------------------------------------------------------+
               j = INSTR(-(LEN(t) - i) - 2, t, " ") + 1           ' Look for prev blank + 1
               IF j = 0 THEN                                      ' None?
                  GOSUB PrevLine                                  ' Go to prev line then
               ELSE                                               ' We've got the next 'word'
                  IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                     me.CurSetReq(%Position, @P.C.CIX, j, %True)  ' No, Set cursor set attempt
                     DoSet(%Refresh)                              ' Have it looked at
                  ELSE                                            '
                     me.CsrCol = j + @P.PGapCol - @P.POffset      ' Just move cursor on the screen
                  END IF                                          '
               END IF                                             '
            END IF                                                '
        END IF                                                    '
     END IF                                                       '
     MExitMeth                                                    ' We're done

   '-----------------------------------------------------------------------------------------------+
   '- Go to last word on the previous line                                                         |
   '-----------------------------------------------------------------------------------------------+
   PrevLine:                                                      '
      @P.C.CIX = me.CrpBack(%mData, @P.C.CIX, 1)                  ' Get address of prev data line
      IF @P.C.CIX = 0 THEN MExitMeth                              ' Do nothing
      IF IsLInvisible(@P.C.CIX) THEN                              ' Invisible?
         @P.C.CIX = me.LPopOutX(@P.C.CIX)                         ' Yes, Uugh! go do lots of work, get adjusted line number
      END IF                                                      '
      t = RTRIM$(LTxtG(@P.C.CIX))                                 ' Get text of prev line
      j = INSTR(-1, t, " ")                                       ' Look for last blank
      IF j <> 0 THEN INCR j                                       ' 1st char of last word
      j = MAX(1, j)                                               ' If not found, set to 1
      me.CurSetReq(%Position, @P.C.CIX, j, %True)                 ' Set cursor set attempt
      DoSet(%Refresh)                                             ' Have it looked at
      RETURN                                                      '

   '-----------------------------------------------------------------------------------------------+
   '- Go to last word on the current line                                                          |
   '-----------------------------------------------------------------------------------------------+
   CurrLastWord:                                                  '
      j = INSTR(-1, t, " ")                                       ' Look for last blank
      IF j <> 0 THEN INCR j                                       ' 1st char of last word
      j = MAX(1, j)                                               ' If not found, set to 1
      IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
         me.CurSetReq(%Position, @P.C.CIX, j, %True)              ' No, Set cursor set attempt
         DoSet(%Refresh)                                          ' Have it looked at
      ELSE                                                        '
         me.CsrCol = j + @P.PGapCol - @P.POffset                  ' Just move cursor on the screen
      END IF                                                      '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  krCtlRight()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Tab right one 'word'                                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j AS LONG                                             '
   LOCAL t, CS AS STRING                                          '
      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Make sure we're somewhere legal                                                           |
      '--------------------------------------------------------------------------------------------+
      IF IsCCmnd THEN                                             ' Command line
         t = RTRIM$(PCommand)                                     ' Get a copy of the text
         i = @P.C.CLCol                                           ' Where is cursor now
         IF i >= LEN(t) THEN MExitMeth                            ' Nothing to do
         '-----------------------------------------------------------------------------------------+
         '- Command Line - On space between words?                                                 |
         '-----------------------------------------------------------------------------------------+
         IF MID$(t, i, 1) = " " THEN                              ' Currently sitting on a blank?
            j = INSTR(i + 1, t, ANY CS)                           ' Look for next visible character
            IF j = 0 THEN MExitMeth                               ' None?
            IF j - @P.PCOffset > @P.PCmdLen THEN                  ' Still visible?
               @P.PCOffset = j - (@P.PCmdLen / 2)                 ' Adjust Offset if needed
               me.WindowCmd                                       ' Shift it
            END IF                                                '
            me.CsrCol = j + 10 - @P.PCOffset                      ' Just move cursor on the screen

         ELSE                                                     ' We're sitting on a character
            '--------------------------------------------------------------------------------------+
            '- Command Line - Sitting on a character                                               |
            '--------------------------------------------------------------------------------------+
            j = INSTR(i + 1, t, " ")                              ' Look for next blank
            j = INSTR(j + 1, t, ANY CS)                           ' Look for next word character
            IF j = 0 THEN MExitMeth                               ' None?
            IF j - @P.PCOffset > @P.PCmdLen THEN                  ' Still visible?
               @P.PCOffset = j - (@P.PCmdLen / 2)                 ' Adjust Offset if needed
               me.WindowCmd                                       ' Shift it
            END IF                                                '
            me.CsrCol = j + 10 - @P.PCOffset                      ' Just move cursor on the screen
         END IF                                                   '
         MExitMeth                                                '
      END IF                                                      '

      IF IsCLinN THEN DECR @P.C.CIX: GOSUB NextLine: MExitMeth    ' If LineNumber goto next available
      IF ISFALSE IsCData THEN MExitMeth                           ' Ignore totally if not in Data area
      IF @P.C.CIX = 0 THEN MExitMeth                              ' Exit if below bottom line
      IF ISFALSE IsLData(@P.C.CIX) AND ISFALSE IsLNote(@P.C.CIX) THEN GOSUB NextLine: MExitMeth ' Also must be on a data/note line
      CS = gENV.CharSet                                           ' Get local copy of CharSet

      '--------------------------------------------------------------------------------------------+
      '- Get current line and column #                                                             |
      '--------------------------------------------------------------------------------------------+
      t = RTRIM$(LTxtG(@P.C.CIX)) + " "                           ' Get a copy of the text (+ 1 blank)
      i = @P.C.CCol + @P.POffset - @P.PGapCol                     ' Where is cursor now

      '--------------------------------------------------------------------------------------------+
      '- Past last character, go to next line                                                      |
      '--------------------------------------------------------------------------------------------+
      IF i > LEN(RTRIM$(t)) THEN                                  ' At or past last char?
         GOSUB NextLine                                           ' Go to Col 1 next line

      ELSE                                                        ' Within line, find next location

         '-----------------------------------------------------------------------------------------+
         '- Sitting ON a character                                                                 |
         '-----------------------------------------------------------------------------------------+
         IF MID$(t, i, 1) <> " " THEN                             ' Currently sitting on a char?
            j = INSTR(i + 1, t, " ")                              ' Look for next blank
            j = INSTR(j + 1, t, ANY CS)                           ' Look for next word character
            IF j = 0 THEN                                         ' None?
               GOSUB NextLine                                     ' Go to next line then
            ELSE                                                  ' We've got the next 'word'
               IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, @P.C.CIX, j, %True)     ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               '
                  me.CsrCol = j + @P.PGapCol - @P.POffset         ' Just move cursor on the screen
               END IF                                             '
            END IF                                                '
         ELSE                                                     ' We're sitting on a blank

            '--------------------------------------------------------------------------------------+
            '- Sitting on a blank                                                                  |
            '--------------------------------------------------------------------------------------+
            j = INSTR(i + 1, t, ANY CS)                           ' Look for next visible character
            IF j = 0 THEN                                         ' None?
               GOSUB NextLine                                     ' Go to next line then
            ELSE                                                  ' We've got the next 'word'
               IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, @P.C.CIX, j, %True)     ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               '
                  me.CsrCol = j + @P.PGapCol - @P.POffset         ' Just move cursor on the screen
               END IF                                             '
            END IF                                                '
        END IF                                                    '
     END IF                                                       '
     MExitMeth                                                    ' We're done

   '-----------------------------------------------------------------------------------------------+
   '- Go to the next line                                                                          |
   '-----------------------------------------------------------------------------------------------+
   NextLine:                                                      '
      @P.C.CIX = me.CrpFwd(%mData, @P.C.CIX, 1)                   ' Move to next line
      IF @P.C.CIX = 0 THEN MExitMeth                              ' No more lines, exit
      IF IsLInvisible(@P.C.CIX) THEN                              ' Invisible?
         @P.C.CIX = me.LPopOutX(@P.C.CIX)                         ' Yes, Uugh! go do lots of work, get adjusted line number
      END IF                                                      '
      me.CurSetReq(%Position, @P.C.CIX, 1, %True)                 ' No, Set cursor set attempt
      DoSet(%Refresh)                                             ' Have it looked at
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  krDataDeleteMark()                                     '
   '-----------------------------------------------------------------------------------------------+
   '- Data Delete a marked area (if there is one)                                                  |
   '-----------------------------------------------------------------------------------------------+
      IF ISFALSE IsMarkActive THEN EXIT METHOD                    ' Is something selected?  No?  Exit
      me.krDataDelBS("D")                                         ' Just do a Data Delete
   END METHOD                                                     '

   METHOD  krDataDelBS(which AS STRING)                           '
   '-----------------------------------------------------------------------------------------------+
   '- DataDeleteBackspace                                                                          |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, q, qq, x, y, z, OldLen, GotColumns AS LONG, lcltxt, lclTabs, lh, qDlm, t AS STRING, lclWTxt, lhW, tW AS WSTRING   '
      MEntry                                                      '
      IF ISFALSE IsCData THEN                                     ' Pass off if not text data
         IF IsFMTab THEN                                          ' FM mode?
            IF which = "D" THEN me.FMkbDelete                     ' Del mode
            IF which = "B" THEN me.FMkbBackspace                  ' Bksp mode
         ELSE                                                     '
            IF which = "D" THEN me.KrDel                          ' Del mode
            IF which = "B" THEN me.KrBS                           ' Bksp mode
         END IF                                                   '
         MExitMeth                                                '
      END IF                                                      '

      IF @P.C.CIX = 0 THEN DoBeep: MExitMeth                      ' Bail out if below last line
      IF ISTRUE (LFlagG(@P.C.CIX) AND %NonTypable) THEN DoBeep: MExitMeth  ' Ignore non-typable lines
      IF FCB.HexMode = &4 AND @P.C.CIX < 0 THEN DoBeep: MExitMeth ' If on a non-Char line alert user
      i = @P.C.CCol - @P.PGapCol + @P.POffset                     ' Calc index into string
      IF which = "B" THEN                                         ' The Backspace version?
         i = IIF(i = 1, 1, i - 1)                                 ' Point at prev char if this is a backspace
      END IF                                                      '
      lclTabs = me.TabsSimple(LEN(L(@P.C.CIX).@LTxt))             ' Get a working tabs line
      j = INSTR(i + 1, lclTabs, "*")                              ' Find next tab

      IF ISTRUE FCB.TabBNDS AND j > 0 THEN                        ' TabBNDS style?
         IF IsMarkActive THEN DoBeep: MExitMeth                   ' Not in Mark mode
         '-----------------------------------------------------------------------------------------+
         '- Handle delete in TabsBNDS mode                                                         |
         '-----------------------------------------------------------------------------------------+
         me.ModSet(@P.C.CIX)                                      ' Remember we changed something
         '-----------------------------------------------------------------------------------------+
         '- See if any 'gap columns' in the data   i = Csrcol in text, J = next tab                |
         '-----------------------------------------------------------------------------------------+
         lcltxt = LTxtG(@P.C.CIX)                                 ' Get the whole line
         lcltxt = LEFT$(lcltxt, j - 1)                            ' Trim off after this tab column
         k = i                                                    ' Get the text and start scan ptr
         IF MID$(lcltxt, k, 1) = " " THEN                         ' Sitting on a space?
            FOR y = k + 1 TO LEN(lcltxt)                          ' Look for the next a non- blank
               IF MID$(lcltxt, y, 1) <> " " THEN                  ' Got one?
                  k = y                                           ' Update the start scan
                  EXIT FOR                                        ' We're done here
               END IF                                             '
            NEXT y                                                '
         END IF                                                   '
         DO                                                       ' Loop looking for compressible spaces
            x = INSTR(k, lcltxt, "  ")                            ' Look for at least 2 blanks following found string
            IF x = 0 THEN EXIT DO                                 ' No blanks, skip all the junk

            q = INSTR(k, lcltxt, ANY "'`" + $DQ)                  ' Any quotes?
            qDLM = MID$(lcltxt, q, 1)                             ' Save which one
            qq = INSTR(q + 1, lcltxt, qDLM)                       ' Look for closing
            IF q = 0 OR (q <> 0 AND qq = 0) THEN EXIT DO          ' If no valid quoted string, skip out

            IF x < q THEN EXIT DO                                 ' If spaces preceed quotes, skip out

            k = qq + 1                                            ' Scan again after closing quote
         LOOP                                                     '

         IF x THEN                                                ' If we've got spare blanks
            FOR y = x TO LEN(lcltxt)                              ' Look through remainder of line for a non- blank
               IF MID$(lcltxt, y, 1) <> " " THEN                  ' Got one?
                  GotColumns = %True                              ' Remember we have columns
                  EXIT FOR                                        ' Exit, y - 1 is split point for lh/rh
               END IF                                             '
            NEXT y                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- There are columns do it the hard way                                                   |
         '-----------------------------------------------------------------------------------------+
         IF GotColumns THEN                                       ' Data Delete AND columns?
            lh = LEFT$(lcltxt, y - 1)                             ' Create full lh portion
            lh = STRDELETE$(lh, i, 1) + " "                       ' Delete char and add a blank
            t = lh + MID$(lcltxt, y) + MID$(LTxtG(@P.C.CIX), j)   ' Re-build the altered text
            me.LTxtSet(@P.C.CIX, t)                               ' Save it back

            lclWTxt = LAttrG(@P.C.CIX)                            ' Get the Attr text
            lclWTxt = LEFT$(lclWTxt, j - 1)                       ' Trim off after this tab column
            lhw = LEFT$(lclWTxt, y - 1)                           ' Pick up LH portion
            lhW = STRDELETE$(lhW, i, 1) + CHR$$(0)                ' Delete chars and add $TxtLo
            lclWTxt = lhW + MID$(lclWTxt, y) + MID$(LAttrG(@P.C.CIX), j)   ' Re-build the altered text
            LAttrS(@P.C.CIX) = lclWTxt                            ' Save it back

         ELSE                                                     '
            t = STRDELETE$(lcltxt, i, 1) + " " + MID$(LTxtG(@P.C.CIX), j)  ' Delete 1 char
            LTxtS(@P.C.CIX) = t                                   ' Save it back
            lclWTxt = LAttrG(@P.C.CIX)                            ' Get the Attr text
            tW = LEFT$(lclWTxt, j - 1)                            ' Trim off after this tab column
            tW = STRDELETE$(tw, i, 1) + CHR$$(0) + MID$(lclWTxt, j)  ' Do the delete
            LAttrs(@P.C.CIX) = tw                                 ' Save it
         END IF                                                   '
         me.AttrScan(@P.C.CIX)                                    ' Recolorize
         me.UCIfNeeded(@P.C.CIX)                                  ' Do UC if CAPS ON
         me.DispLine(@P.C.CIX, @P.C.CRow)                         ' Re-display the line
         IF which = "B" THEN me.CsrCol = @P.C.CCol - 1            ' Move cursor back if this is a backspace
         MExitMeth                                                ' Done
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- This part handles a normal line, not in a marked block, and no TabsBNDS active            |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE IsMarkActive THEN                                ' If normal (nothing selected)
         me.AttrInvClearFind                                      ' Clear any Find HiLite
         IF @P.C.CIX = 0 THEN DoBeep: MExitMeth                   ' Bail out if below last line
         IF FCB.HexMode = &4 AND @P.C.CIX < 0 THEN DoBeep: MExitMeth ' If on a non-Char line alert user

         '-----------------------------------------------------------------------------------------+
         '- Delete a text character now                                                            |
         '-----------------------------------------------------------------------------------------+
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc IX into the Text
         IF which = "B" THEN                                      ' The Backspace version?
            i = IIF(i = 1, 1, i - 1)                              ' Point at prev char if this is a backspace
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- See if any 'columns' in the data                                                       |
         '-----------------------------------------------------------------------------------------+
         lcltxt = LTxtG(@P.C.CIX): j = i                          ' Get the text and start scan ptr
         IF MID$(lcltxt, j, 1) = " " THEN                         ' Sitting on a space?
            FOR y = j + 1 TO LEN(lcltxt)                          ' Look for the next a non- blank
               IF MID$(lcltxt, y, 1) <> " " THEN                  ' Got one?
                  j = y                                           ' Update the start scan
                  EXIT FOR                                        ' We're done here
               END IF                                             '
            NEXT y                                                '
         END IF                                                   '
         DO                                                       ' Loop looking for compressible spaces
            x = INSTR(j, lcltxt, "  ")                            ' Look for at least 2 blanks following found string
            IF x = 0 THEN EXIT DO                                 ' No blanks, skip all the junk

            q = INSTR(j, lcltxt, ANY "'`" + $DQ)                  ' Any quotes?
            qDLM = MID$(lcltxt, q, 1)                             ' Save which one
            qq = INSTR(q + 1, lcltxt, qDLM)                       ' Look for closing
            IF q = 0 OR (q <> 0 AND qq = 0) THEN EXIT DO          ' If no valid quoted string, skip out

            IF x < q THEN EXIT DO                                 ' If spaces preceed quotes, skip out

            j = qq + 1                                            ' Scan again after closing quote
         LOOP                                                     '

         IF x THEN                                                ' If we 've got spare blanks

            FOR y = x TO LEN(lcltxt)                              ' Look through remainder of line for a non- blank
               IF MID$(lcltxt, y, 1) <> " " THEN                  ' Got one?
                  GotColumns = %True                              ' Remember we have columns
                  EXIT FOR                                        ' Exit, y - 1 is split point for lh/rh
               END IF                                             '
            NEXT y                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- There are columns do it the hard way                                                   |
         '-----------------------------------------------------------------------------------------+
         IF GotColumns THEN                                       ' Data Delete AND columns?
            lh = LEFT$(lcltxt, y - 1)                             ' Create full lh portion
            lh = STRDELETE$(lh, i, 1) + " "                       ' Delete char and add a blank
            lcltxt = lh + MID$(lcltxt, y)                         ' Re-build the altered text
            me.LTxtSet(@P.C.CIX, lcltxt)                          ' Save it back

            lclWTxt = LAttrG(@P.C.CIX)                            ' Get the Attr text
            lhw = LEFT$(lclWTxt, y - 1)                           ' Pick up LH portion
            lhW = STRDELETE$(lhW, i, 1) + CHR$$(0)                ' Delete chars and add $TxtLo
            lclWTxt = lhW + MID$(lclWTxt, y)                      ' Re-build the altered text
            LAttrS(@P.C.CIX) = lclWTxt                            ' Save it back

         ELSE                                                     '
            me.LTxtCharDel(@P.C.CIX, i)                           ' Delete 1 char
         END IF                                                   '

         me.AttrScan(@P.C.CIX)                                    ' Recolorize
         Me.UCIfNeeded(@P.C.CIX)                                  ' UC if CAPS ON
         me.DispLine(@P.C.CIX, @P.C.CRow)                         ' Re-display the line
         me.ModSet(@P.C.CIX)                                      ' Remember we changed something
         IF which = "B" THEN me.CsrCol = @P.C.CCol - 1            ' Move cursor back if this is a backspace

         '-----------------------------------------------------------------------------------------+
         '- If HEX mode, we have to do the other lines                                             |
         '-----------------------------------------------------------------------------------------+
         IF FCB.HexMode = &4 THEN                                 ' If Hex mode, do extra
            IF @P.C.CRow + 1 <= TP.gPBottom THEN                  ' Make sure we don't go off the bottom
               DoPrint (me.WindowHexTop(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 1, @P.PDataCol)  ' Print upper hex
               me.MarkReDraw(@P.C.CRow + 1)                       ' Re-draw the MARK lines
            END IF                                                '
            IF @P.C.CRow + 2 <= TP.gPBottom THEN                  ' Make sure we don't go off the bottom
               DoPrint (me.WindowHexBottom(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 2, @P.PDataCol)  ' Print lower hex
               me.MarkReDraw(@P.C.CRow + 2)                       ' Re-draw the MARK lines
            END IF                                                '
         END IF                                                   '
         MExitMeth                                                '
      END IF                                                      '

      IF which = "B" THEN DoBeep: MexitMeth                       ' No DataBackspace of a marked block
      '--------------------------------------------------------------------------------------------+
      '- DataDelete of a highlighted area                                                          |
      '--------------------------------------------------------------------------------------------+
      me.MarkKill                                                 ' Reset the select frame
      me.SwapKill                                                 '
      IF @P.C.CIX = 0 THEN @P.C.CIX = MarkRect.Top                ' Use FromLin if not on screen

      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Delete of the marked range                                                 |
      '--------------------------------------------------------------------------------------------+
      me.CurSetReq(%Position, @P.C.CIX, MarkRect.Left, %True)     ' Set cursor set attempt
      FOR z = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISTRUE IsLData(z) OR ISTRUE IsLNote(z) THEN           ' Just data/note lines
            me.ModSet(z)                                          ' Remember we changed something
            OldLen = LEN(L(z).@LTxt)                              ' Save old length of line

            '--------------------------------------------------------------------------------------+
            '- See if any 'columns' in the data                                                    |
            '--------------------------------------------------------------------------------------+
            GotColumns = %False                                   ' Start as 'no columns'
            lcltxt = LTxtG(z)                                     ' Get the text
            x = INSTR(MarkRect.Right + 1, lcltxt, "  ")           ' Look for at least 2 blanks following deleted string
            IF x THEN                                             ' If we've got spare blanks
               FOR y = x TO LEN(lcltxt)                           ' Look through remainder of line for a non- blank
                  IF MID$(lcltxt, y, 1) <> " " THEN               ' Got one?
                     GotColumns = %True                           ' Remember we have columns
                     EXIT FOR                                     ' Exit, y - 1 is split point for lh/rh
                  END IF                                          '
               NEXT y                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- There are columns do it the hard way                                                |
            '--------------------------------------------------------------------------------------+
            IF GotColumns THEN                                    ' Data Delete AND columns?
               lh = LEFT$(lcltxt, y - 1)                          ' Pick up LH portion
               lh = STRDELETE$(lh, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)  ' Delete chars
               lh = LSET$(lh, y - 1)                              ' Pad back the length
               lcltxt = lh + MID$(lcltxt, y)                      ' Re-build the altered text
            ELSE                                                  '
               lh = LEFT$(lcltxt, MarkRect.Left - 1)              ' Create full lh portion
               lcltxt = lh + MID$(lcltxt, MarkRect.Right + 1)     ' Re-build the altered text
            END IF                                                '
            me.LTxtSet(z, lcltxt)                                 ' Save it back

            '--------------------------------------------------------------------------------------+
            '- Now do highlights                                                                   |
            '--------------------------------------------------------------------------------------+
            lclWTxt = LAttrG(z)                                   ' Get the Attr text
            IF GotColumns THEN                                    ' Data Delete AND columns?
               lhw = LEFT$(lclWTxt, y - 1)                        ' Pick up LH portion
               lhW = STRDELETE$(lhW, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete chars
               lhW = LSET$(lhW, y - 1)                            ' Pad back the length
               lclWTxt = lhW + MID$(lclWTxt, y)                   ' Re-build the altered text
            ELSE                                                  '
               lhW = LEFT$(lclWTxt, MarkRect.Left - 1)            ' Create full lh portion
               lclWTxt = lhW + MID$(lclWTxt, MarkRect.Right + 1)  ' Re-build the altered text
            END IF                                                '
            LAttrS(z) = lclWTxt                                   ' Save it back

            me.UCIfNeeded(z)                                      ' UC if CAPS ON
            me.AttrScan(z)                                        ' Recolorize
            me.ModSet(z)                                          ' Remember we changed something

         END IF                                                   '
      NEXT x                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      MExitMeth                                                   '
   END METHOD                                                     '

   METHOD  krDataInsert()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- DataInsert Toggle                                                                            |
   '-----------------------------------------------------------------------------------------------+
      IF IsNSrtData THEN                                          ' Already in DataInsert mode?
         IF IsNsrtSave  THEN OnNsrtFlag ELSE OffNsrtFlag          ' Restore previous mode
         IF IsNsrtSaveD THEN OnNsrtData ELSE OffNsrtData          ' Restore it
         OffNSrtData                                              ' Turn DataInsert off
      ELSE                                                        ' Lets turn it on then
         IF IsNsrtFlag THEN OnNsrtSave  ELSE OffNsrtSave          ' Save current Ins Mode
         IF IsNsrtData THEN OnNsrtSaveD ELSE OffNsrtSaveD         '
         OnNsrtFlag                                               ' Basic Insert goes ON
         OnNsrtData                                               ' DataInsert on
      END IF                                                      '
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar INS/OVR box
   END METHOD                                                     '

   METHOD  krDate()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Paste Date at cursor location                                                                |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = DateWinFormat()                                        ' Go get the date
      me.krTDPaste(ln)                                            '
   END METHOD                                                     '

   METHOD  krDel()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Delete character at current position                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x, i, j AS LONG, lclTxt, lclTabs, lh, rh, t AS STRING    '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Located on the Command line                                                               |
      '--------------------------------------------------------------------------------------------+
      IF IsCCmnd THEN                                             ' In Command line
         IF IsMiscActive THEN                                     ' Marked area
            me.MarkKill                                           ' Reset the select text
            pCommand = STRDELETE$(pCommand, MiscRect.Left, MiscRect.Right - MiscRect.Left + 1) + REPEAT$(MiscRect.Right - MiscRect.Left + 1, " ")  '
            me.CsrCol = MiscRect.Left - @P.PCOffset + @P.PCmdCol - 1 ' Set cursor to start of deleted area

         ELSE                                                     '
            pCommand = STRDELETE$(pCommand, @P.C.CCol - (@P.PCmdCol - 1) + @P.PCOffset, 1) + " "   ' Delete it
         END IF                                                   '
         me.WindowCmd                                             ' Re-do the command line

      '--------------------------------------------------------------------------------------------+
      '- Located in the Scroll Amt. area                                                           |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCScrl THEN                                         ' In Scrl Amt area?
         FCB.ScrollAmt = STRDELETE$(FCB.ScrollAmt, @P.C.CCol - @P.PScrData + 1, 1) + " "  ' Delete it
         DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, @P.PTop, @P.PScrData)  ' Redisplay the entire string

      '--------------------------------------------------------------------------------------------+
      '- Located in the normal text area                                                           |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCData THEN                                         ' In Data area
         me.AttrInvClearFind                                      ' Clear any Find HiLite
         IF IsBrowse THEN DoBeep: MExitMeth                       ' Not allowed in Browse mode

         '-----------------------------------------------------------------------------------------+
         '- If a highlighted area, get it's boundaries, then kill it                               |
         '-----------------------------------------------------------------------------------------+
         IF IsMarkActive THEN                                     ' Hi-lighted text and cursor in Data area?
            IF IsWithin(MarkRect, @P.C.CIX, @P.C.CLCol) THEN      ' Is cursor within the marked area?
               IF IsNsrtFlag THEN                                 ' Do the Insert mode handling
                  '--------------------------------------------------------------------------------+
                  '- Do a char mode delete on each line                                            |
                  '--------------------------------------------------------------------------------+
                  FOR i = MarkRect.Top TO MarkRect.Bottom         ' Process each line in the marked area
                     IF ISTRUE IsLData(i) OR ISTRUE IsLNote(i) THEN  ' Just data/note lines
                        IF @P.C.CLCol >= MarkRect.Left AND @P.C.CLCol <= MarkRect.Right THEN ' Room to Delete?
                           me.ModSet(i)                           ' Remember we changed something
                           me.LTxtCharDel(i, @P.C.CLCol)          ' Delete 1 char
                           me.LAttrAdjust(i, @P.C.CLCol, -1)      ' Adjust any Attr hilite
                           me.AttrScan(i)                         ' Recolorize
                           me.UCIfNeeded(i)                       ' UC if CAPS ON
                        ELSE                                      ' Not in the block
                           GOTO DelNonInsert                      ' Do nothing
                        END IF                                    '
                     END IF                                       '
                  NEXT i                                          '
                  DECR MarkRect.Right                             ' Pull in the Mark End column
                  IF MarkRect.Left > MarkRect.Right THEN          ' Nothing left?
                     me.MarkKill                                  ' Reset the select frame
                     me.SwapKill                                  '
                  END IF                                          '
                  me.CurSetReq(%Position, @P.C.CIX, @P.C.CLCol, %True)  ' Set cursor set attempt
                  me.CsrCol = @P.C.CLCol + @P.PGapCol - @P.POffset   '
                  DoSet(%Refresh)                                 ' Have it looked at
                  MExitMeth                                       '

               ELSE                                               ' Do the non-Insert mode handling
                  DelNonInsert:                                   '
                  me.MarkKill                                     ' Reset the select frame
                  me.SwapKill                                     '

                  '--------------------------------------------------------------------------------+
                  '- OK, now do the Delete of the marked range                                     |
                  '--------------------------------------------------------------------------------+
                  FOR x = MarkRect.Top TO MarkRect.Bottom         ' Loop through the requested range
                     IF ISTRUE IsLData(x) OR ISTRUE IsLNote(x) THEN  ' Just data/note lines
                        me.ModSet(x)                              ' Remember we changed something
                        lclTxt = LTxtG(x)                         ' Get the text
                        lclTxt = STRDELETE$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete the characters
                        me.LAttrAdjust(x, MarkRect.Left, -(MarkRect.Right - MarkRect.Left + 1)) ' Adjust any Attr hilite
                        me.LTxtSet(x, lclTxt)                     ' Put work string back
                        me.AttrScan(x)                            ' Recolorize
                        me.UCIfNeeded(x)                          ' UC if CAPS ON
                        me.CurSetReq(%Position, MarkRect.Bottom, MarkRect.Left, %True) ' Set cursor set attempt
                        me.CsrCol = MarkRect.Left + @P.PGapCol - @P.POffset   '
                     END IF                                       '
                  NEXT x                                          '
                  DoSet(%Refresh)                                 ' Have it looked at
                  MExitMeth                                       '
               END IF                                             '
            END IF                                                '
            me.MarkKill                                           ' Reset the select frame
            me.SwapKill                                           '

         END IF                                                   '
                                                                  '
         '-----------------------------------------------------------------------------------------+
         '- Get detail location and eliminate invalid ones                                         |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CIX = 0 THEN DoBeep: MExitMeth                   ' Bail out if below last line
         IF FCB.HexMode = &4 AND @P.C.CIX < 0 THEN DoBeep: MExitMeth ' If on a non-Char line alert user
         IF ISTRUE (LFlagG(@P.C.CIX) AND %NonTypable) THEN        ' Ignore non-typable lines
            DoBeep                                                '
         ELSE                                                     '

            '--------------------------------------------------------------------------------------+
            '- Delete a text character now                                                         |
            '--------------------------------------------------------------------------------------+
            me.ModSet(@P.C.CIX)                                   ' Remember we changed something
            i = @P.C.CCol - @P.PGapCol + @P.POffset               ' Calc index into string
            lclTabs = me.TabsSimple(LEN(L(@P.C.CIX).@LTxt))       ' Get a working tabs line
            j = INSTR(i + 1, lclTabs, "*")                        ' Find next tab
            IF ISFALSE FCB.TabBnds OR _                           ' If not TABSBNDS OR
               (ISTRUE FCB.TabBNDS AND j = 0) THEN                ' TabBNDS and no further tabs?
               me.LTxtCharDel(@P.C.CIX, i)                        ' Delete 1 char
            ELSE                                                  ' TabsBNDS AND a further Tab
               t = LTxtG(@P.C.CIX)                                ' Get the text
               lh = LEFT$(t, j - 1): rh = MID$(t, j)              ' Split into LH and RH
               lh = STRDELETE$(lh, i, 1) + " "                    ' Delete the character
               me.LTxtSet(@P.C.CIX, lh + rh)                      ' Store it back
            END IF                                                '
            me.UCIfNeeded(@P.C.CIX)                               ' UC if CAPS ON
            me.AttrScan(@P.C.CIX)                                 ' Recolorize
            me.DispLine(@P.C.CIX, @P.C.CRow)                      ' Re-display the line

            '--------------------------------------------------------------------------------------+
            '- If HEX mode, we have to do the other lines                                          |
            '--------------------------------------------------------------------------------------+
            IF FCB.HexMode = &4 THEN                              ' If Hex mode, do extra
               IF @P.C.CRow + 1 <= TP.gPBottom THEN               ' Make sure we don't go off the bottom
                  DoPrint (me.WindowHexTop(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 1, @P.PDataCol)  ' Print upper hex
                  me.MarkReDraw(@P.C.CRow + 1)                    ' Re-draw the MARK lines
               END IF                                             '
               IF @P.C.CRow + 2 <= TP.gPBottom THEN               ' Make sure we don't go off the bottom
                  DoPrint (me.WindowHexBottom(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 2, @P.PDataCol)  ' Print lower hex
                  me.MarkReDraw(@P.C.CRow + 2)                    ' Re-draw the MARK lines
               END IF                                             '
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Located in the Line Number area                                                           |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCLinN THEN                                         ' In the Line control area
         IF @P.C.CIX = 0 THEN MExitMeth                           ' Bail out if below last line
         IF me.IsTouchable(@P.C.CIX) THEN                         ' If 1st interaction in the line number area
            LLCtlS(@P.C.CIX) = $BlankLNo: me.CsrCol = @P.PLeft    ' Blank the Line number
            DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
         END IF                                                   '
         LLCtlS(@P.C.CIX) = STRDELETE$(LLCtlG(@P.C.CIX), @P.C.CLCol, 1) + " " ' Delete a char
         DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
         me.TTblAdd(@P.C.CIX, TRIM$(LLCtlG(@P.C.CIX)))            ' Update touched items
      ELSE                                                        ' Else weird area
         DoBeep                                                   '
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krDeleteMark()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Delete a marked area (if there is one                                                        |
   '-----------------------------------------------------------------------------------------------+
   LOCAL lclTxt AS STRING                                         '
      '--------------------------------------------------------------------------------------------+
      '- If a marked area, then remove it                                                          |
      '--------------------------------------------------------------------------------------------+
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      IF IsMarkActive THEN                                        ' Is something selected?
         IF IsBrowse THEN DoBeep: EXIT METHOD                     ' Not allowed in Browse mode
         IF IsWithin(MarkRect, MarkRect.Top, @P.C.CCol - @P.PGapCol + @P.POffset) THEN '
            me.MarkKill                                           ' Reset the select frame
            me.SwapKill                                           '

            '--------------------------------------------------------------------------------------+
            '- OK, now do the Delete                                                               |
            '--------------------------------------------------------------------------------------+
            me.ModSet(MarkRect.Top)                               ' Remember we changed something
            lclTxt = LTxtG(MarkRect.Top)                          ' Get the text
            lclTxt = STRDELETE$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete the characters
            me.LTxtSet(MarkRect.Top, lclTxt)                      ' Put work string back
            me.UCIfNeeded(MarkRect.Top)                           ' UC if CAPS ON
            me.LAttrAdjust(MarkRect.Top, MarkRect.Left, -(MarkRect.Right - MarkRect.Left + 1))  ' Adjust any Attr hilite
            me.CurSetReq(%Position, MarkRect.Top, MarkRect.Left, %True) ' Set cursor set attempt
            me.CsrCol = MarkRect.Left + @P.POffset + @P.PGapCol   '
            DoSet(%Refresh)                                       ' Have it looked at
         END IF                                                   '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krDown()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Increment CsrRow                                                                             |
   '-----------------------------------------------------------------------------------------------+
   LOCAL t AS STRING                                              '
   LOCAL cIncr AS LONG                                            '

      MEntry                                                      '
      cIncr = IIF(VAL(gKeyPrimOper) > 0, VAL(gKeyPrimOper), 1)    ' Set the INCR amount?
      '--------------------------------------------------------------------------------------------+
      '- Move the cursor down                                                                      |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CIX <> 0 AND @P.C.CRow + cIncr <= TP.gPBottom AND me.SGet(@P.C.CRow + 1) = 0 THEN ' End of Page display?
         FCB.ScrlPageSus = %True                                  ' Set suspend PAGE mode
         OnInsClnSupp                                             ' Suppress Insert cleanup for 1 Attn pass
         DoSet(%Refresh)                                          ' Have it looked at
         MExitMeth                                                '
      END IF                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      me.CsrRowAdd(cIncr)                                         ' Simple INCR

      '--------------------------------------------------------------------------------------------+
      '- Handle edge wrap when noscroll                                                            |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE gENV.KBVerScroll THEN                            ' AutoScroll or not
         IF @P.C.CRow > @P.PBottom THEN me.CsrRow = @P.PTop       ' NO - Handle Wrap if needed
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Scroll it at the bottom                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CRow <= @P.PBottom THEN MExitMeth                   ' Not the bottom, we're done
      me.CsrRowSub(cIncr)                                         ' Yes, Undo the INCR for now

      '-----------------------------------------------------------------------------------------+
      '- Get the actual line the cursor was on                                                  |
      '-----------------------------------------------------------------------------------------+
      IF @P.C.CIX < 0 THEN                                        ' A Hex extra line?
         @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))            ' Point at real character line
      END IF                                                      '

      '-----------------------------------------------------------------------------------------+
      '- Can't scroll if already below last line                                                |
      '-----------------------------------------------------------------------------------------+
      IF @P.C.CIX = 0 THEN MExitMeth                              ' Exit if not data line

      '-----------------------------------------------------------------------------------------+
      '- If not yet at the bottom line, find the next visible line                              |
      '-----------------------------------------------------------------------------------------+
      IF ISFALSE IsLBottom(@P.C.CIX) THEN                         ' See if cursor is at the bottom
         @P.PTopLine = me.CRPFwd(%mVisible, @P.PTopLine, cIncr)   ' Move TopScrn by scroll amount
         OnInsClnSupp                                             ' Suppress Insert cleanup for 1 Attn pass
         DoSet(%Refresh)                                          ' Have it looked at
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krDup()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Duplicate prior line into the marked block                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x, i AS LONG, lclTxt, t AS STRING                        '

      me.AttrInvClearFind                                         ' Clear any Find HiLite
      '--------------------------------------------------------------------------------------------+
      '- Get the data from the previous line                                                       |
      '--------------------------------------------------------------------------------------------+
      i = me.CrpBack(%mData, MarkRect.Top, 1)                     ' Get address of prev data line
      IF ISFALSE IsLData(i) THEN DoBeep: EXIT METHOD              ' Beep and exit if no prior
      t = LTxtG(i)                                                ' Get text from the previous line
      IF LEN(t) < MarkRect.Right THEN t = LSET$(t, MarkRect.Right)   ' If line shorter than select columns, lengthen it
      t = MID$(t, MarkRect.Left TO MarkRect.Right)                ' Get the string to be Dup'd

      '--------------------------------------------------------------------------------------------+
      '- OK, now stuff it into the lines                                                           |
      '--------------------------------------------------------------------------------------------+
      me.ModSet(MarkRect.Top)                                     ' Remember we changed something
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISFALSE (LFlagG(x) AND %NonTypable) THEN              ' Just typable lines
            lclTxt = LTxtG(x)                                     ' Get the text
            IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
            MID$(lclTxt, MarkRect.Left TO MarkRect.Right) = t     ' Extract the columns
            me.LTxtSet(x, lclTxt)                                 ' Save it back
            me.AttrScan(x)                                        ' Recolorize
         END IF                                                   '
      NEXT x                                                      '

      '--------------------------------------------------------------------------------------------+
      '- We're done, clean up and exit                                                             |
      '--------------------------------------------------------------------------------------------+
      me.MarkKill                                                 ' Reset the select frame
      me.CurSetReq(%LineCmd, MarkRect.Top, MarkRect.Left, %True)  ' Set cursor set attempt
      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  krEditBrowse(which AS STRING)                          '
   '-----------------------------------------------------------------------------------------------+
   '- Edit/Browse the highlighted filename                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL lclTxt, a AS STRING                                      '
      '--------------------------------------------------------------------------------------------+
      '- Ensure a marked area and get its boundaries                                               |
      '--------------------------------------------------------------------------------------------+
      IF MarkRect.Top <> MarkRect.Bottom OR _                     ' If not one line
         ISFALSE (IsLData(MarkRect.Bottom)) AND ISFALSE (IsLNote(MarkRect.Bottom)) THEN _ ' or not Data/Note line
         DoBeep: EXIT METHOD                                      '

      '--------------------------------------------------------------------------------------------+
      '- OK, now build the string                                                                  |
      '--------------------------------------------------------------------------------------------+
      lclTxt = LTxtG(MarkRect.Bottom)                             ' Get the text
      IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = lclTxt + SPACE$(MarkRect.Right - LEN(lclTxt))  ' Padd if needed
      lclTxt = MID$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Extract the columns
      IF TRIM$(lclTxt) = "" THEN DoBeep: EXIT METHOD              '
      DO WHILE INSTR($DQ + "'<([ ", LEFT$(lclTxt, 1)) <> 0        ' LEFT trim it
         lclTxt = MID$(lclTxt, 2)                                 '
      LOOP                                                        '
      DO WHILE INSTR($DQ + "'>)];,. ", RIGHT$(lclTxt, 1)) <> 0    ' RIGHT trim it
         lclTxt = CLIP$(RIGHT, lclTxt, 1)                         ' Remove quotes if present
      LOOP                                                        '
      REPLACE "/" WITH "\" IN lclTxt                              ' Normalize path delimiters
      IF INSTR(lclTxt, "\") = 0 THEN lclTxt = TP.FCB_.Path + lclTxt  ' Add path is none there

      '--------------------------------------------------------------------------------------------+
      '- Pass off to EDIT / BROWSE as needed                                                       |
      '--------------------------------------------------------------------------------------------+
      IF which = "EDIT" THEN                                      '
         PCmdEDIT("EDIT " + $DQ + lclTxt + $DQ)                   ' Call EDIT
      ELSEIF which = "BROWSE" THEN                                '
         PCmdBrowse("BROWSE " + $DQ + lclTxt + $DQ)               ' Call BROWSE
      ELSEIF which = "VIEW" THEN                                  '
         PCmdView("VIEW " + $DQ + lclTxt + $DQ)                   ' Call VIEW
      END IF                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  krEndLine()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- EndLine key                                                                                  |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, HexRow AS LONG, t AS STRING                           '
      '--------------------------------------------------------------------------------------------+
      '- On text data line                                                                         |
      '--------------------------------------------------------------------------------------------+
      IF IsCData OR IsCLinN THEN                                  '
         IF @P.C.CIX = 0 THEN EXIT METHOD                         ' Bail out if below last line
         IF @P.C.CIX = -3 THEN                                    ' Dash line?
            DoBeep: EXIT METHOD                                   ' Error
         ELSEIF @P.C.CIX < 0 THEN                                 ' A Hex extra line?
            HexRow = ABS(@P.C.CIX)                                ' Save the hex line
            @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))         ' Get real data line
         END IF                                                   '
         IF ISFALSE (LFlagG(@P.C.CIX) AND %NonTypable) THEN       ' See if cursor on a typable line
            t = LTxtG(@P.C.CIX)                                   '
            i = LEN(LTxtG(@P.C.CIX))                              ' Calc where cursor should go
            IF i >= @P.POffset AND i <= @P.POffset + @P.PDataLen THEN   ' Still on displayed screen?
               me.CsrCol = i + @P.PDataCol - @P.POffset           ' Just set the new Col value
            ELSE                                                  '
               me.CurSetReq(%Posend, @P.C.CIX, i + 1, %True, 0, Hexrow) ' Set cursor set attempt
               DoSet(%Refresh)                                    ' Have it looked at
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- On the Command line                                                                       |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCCmnd THEN                                         '
         i = LEN(pCommand)                                        '
         IF i > @P.PCmdLen + @P.PCOffset THEN                     ' Is it to the right of the Window?
            @P.PCOffset = i - (@P.PCmdLen / 2)                    ' Adjust offset
         ELSEIF i < @P.PCOffset THEN                              ' Is it to the left of the Window?
            @P.PCOffset = MAX(0, i - (@P.PCmdLen / 2))            ' Adjust offset
         END IF                                                   '
         me.WindowCmd                                             ' Redisplay the line
         me.CsrCol = i - @P.PCOffset + @P.PCmdCol                 '

      '--------------------------------------------------------------------------------------------+
      '- In the Scroll Command field                                                               |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCScrl THEN                                         '
         i = LEN(RTRIM$(FCB.ScrollAmt))                           '
         i = MIN(3, i)                                            ' So we don't point cursor off the right edge
         me.CsrCol = i + @P.PScrData                              '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krEndText()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- EndText key                                                                                  |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, HexRow AS LONG, t AS STRING                           '
      '--------------------------------------------------------------------------------------------+
      '- On a text data line                                                                       |
      '--------------------------------------------------------------------------------------------+
      IF IsCData OR IsCLinN THEN                                  '
         IF @P.C.CIX = 0 THEN EXIT METHOD                         ' Bail out if below last line
         IF @P.C.CIX = -3 THEN                                    ' Dash line?
            DoBeep: EXIT METHOD                                   ' Error
         ELSEIF @P.C.CIX < 0 THEN                                 ' A Hex extra line?
            IF @P.C.CIX < 0 THEN                                  ' A Hex line?
               HexRow = ABS(@P.C.CIX)                             ' Save the hex line
               @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))      ' Get real data line
            END IF                                                '
         END IF                                                   '
         IF ISFALSE (LFlagG(@P.C.CIX) AND %NonTypable) THEN       ' See if cursor on a typable line
            i = LEN(RTRIM$(LTxtG(@P.C.CIX)))                      ' Calc where cursor should go
            IF i >= @P.POffset AND i <= @P.POffset + @P.PDataLen THEN   ' Still on displayed screen?
               me.CsrCol = i + @P.PDataCol                        ' Just set the new Col value
            ELSE                                                  '
               me.CurSetReq(%Posend, @P.C.CIX, i + 1, %True, 0, HexRow) ' Set cursor set attempt
               DoSet(%Refresh)                                    ' Have it looked at
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- On the Command line                                                                       |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCCmnd THEN                                         '
         i = LEN(RTRIM$(pCommand))                                '
         IF i > @P.PCmdLen + @P.PCOffset THEN                     ' Is it to the right of the Window?
            @P.PCOffset = i - (@P.PCmdLen / 2)                    ' Adjust offset
         ELSEIF i < @P.PCOffset THEN                              ' Is it to the left of the Window?
            @P.PCOffset = MAX(0, i - (@P.PCmdLen / 2))            ' Adjust offset
         END IF                                                   '
         me.WindowCmd                                             ' Redisplay the line
         me.CsrCol = i - @P.PCOffset + @P.PCmdCol                 '

      '--------------------------------------------------------------------------------------------+
      '- On the Scroll Amount field                                                                |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCScrl THEN                                         '
         i = LEN(RTRIM$(FCB.ScrollAmt))                           '
         i = MIN(3, i)                                            ' So we don't point cursor off the right edge
         me.CsrCol = i + @P.PScrData                              '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krEnter()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Enter pressed                                                                                |
   '-----------------------------------------------------------------------------------------------+
   LOCAL lbefore, lafter, i, j, tmpCol AS LONG, w AS STRING       '
      MEntry                                                      '
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      IF gmacroMode THEN MexitMeth                                '
      IF IsFMTab THEN me.FMkbEnter: MExitMeth                     ' In case internal Enter passed
      DOSet(%Attention)                                           ' Enter always causes Attention
      DOSet(%MarkKill)                                            ' Clear any maeked area

      '--------------------------------------------------------------------------------------------+
      '- Exit quickly if a CRETREIV                                                                |
      '--------------------------------------------------------------------------------------------+
      w = UUCASE(GetNextWord(pCommand, %NoStrip))                 ' Get any pending command
      IF IsPFKInsert AND w = "CRETRIEV" THEN                      ' If a CRTRIEV?  (Avoid doing a sCurSetReq below)
         MExitMeth                                                '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If in text data area, add a new insert line if appropriate                                |
      '--------------------------------------------------------------------------------------------+
      IF IsCData THEN                                             ' In the data area?
         IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Get real data line if in Hex mode
         IF @P.C.CIX <> 0 THEN                                    ' Make sure not below bottom line
            i = IsLInsertLine(@P.C.CIX)                           '
            j = IsLInsertLine(@P.C.CIX + 1)                       '
            IF @P.C.CIX = @P.PLastCleard AND _                    ' See if cursor last used Insert Line
               ISFALSE IsLInsertLine(@P.C.CIX + 1) THEN           ' and the next line is not an Insert
               LLCtlS(@P.C.CIX) = "I1      "                      ' Default an extra insert line
               me.TTblAdd(@P.C.CIX, TRIM$(LLCtlG(@P.C.CIX)))      ' Update touched items
               @P.PLastCleard = 0                                 ' Clear last line
            END IF                                                '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If in line # area, get real line number                                                   |
      '--------------------------------------------------------------------------------------------+
      IF IsCLinN THEN                                             ' If cursor in the line number field
         IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Get real data line if in Hex mode
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If in the data area, do the complex 'where does the cursor go' routine                    |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CRow >= @P.pData1 AND @P.C.CRow <= @P.PBottom THEN  ' If cursor in the data lines
         IF ISNULL(TRIM$(pCommand)) THEN                          ' and the command is blank
            IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Get real data line if in Hex mode
            IF IsLXclude(@P.C.CIX) THEN                           ' Skip over excluded lines
               @P.C.CIX = me.CRPFwd(%MVisible, @P.C.CIX, 1)       '
            END IF                                                '
            IF @P.C.CIX <> 0 THEN                                 ' Ensure a data line
               IF @P.C.CCol > @P.PLeft + gENV.LinNoSize THEN _    ' If not in line number area
                  @P.C.CIX = me.CRPFwd(%MVisible, @P.C.CIX, 1)    ' Get next visible line

               IF LEN(L(@P.C.CIX).@LTxt) > 0 THEN                 ' If something in the line
                  tmpCol = MAX(VERIFY(MAX(@P.POffset + 1, 1), LTxtG(@P.C.CIX), " "), @P.POffset + 1)  ' Calc Column
                  me.CurSetReq(%Low, @P.C.CIX, tmpCol, %False)    ' Set it
               ELSE                                               '
                  lbefore = me.CRPBack(%MVisible, @P.C.CIX, 1)    ' Get previous line
                  lafter = me.CRPFwd(%MVisible, @P.C.CIX, 1)      ' Get next line
                  IF lbefore > 1 AND LEN(L(lbefore).@LTxt) = 0 THEN  ' If it's zero as well
                     IF lafter < LastLine AND LEN(L(lafter).@LTxt) = 0 THEN   '
                        tmpCol = 1 + @P.POffset                   ' Calc column - data column 1
                        me.CurSetReq(%Low, @P.C.CIX, tmpCol, %False) ' Set cursor to the data column 1
                     ELSE                                         ' lafter is present
                        tmpCol = MAX(VERIFY(MAX(@P.POffset + 1, 1), LTxtG(lafter), " "), @P.POffset + 1) ' Calc column position
                        me.CurSetReq(%Low, @P.C.CIX, tmpCol, %False) ' Set cursor as per next line
                     END IF                                       '
                  ELSE                                            '
                     tmpCol = MAX(VERIFY(MAX(@P.POffset + 1, 1), LTxtG(lbefore), " "), @P.POffset + 1)   ' Calc column position
                     me.CurSetReq(%Low, @P.C.CIX, tmpCol, %False) ' Set cursor as per previous line
                  END IF                                          '
               END IF                                             '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '

      MExit                                                       '
   END METHOD                                                     '

   METHOD  krEnum(which AS STRING)                                '
   '-----------------------------------------------------------------------------------------------+
   '- Do the Enum function                                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, enumz, ln AS LONG                               '
   LOCAL menum AS DWORD                                           '
   LOCAL t, tt, mprefix, msuffix, digits AS STRING                '
      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Do some basic setup                                                                       |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE IsMarkActive THEN MExitMeth                      ' Hi-lighted text? No? Bail out
      me.AttrInvClearFind                                         ' Clear any Find HiLite

      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      digits = $Numeric: IF which <> "D" THEN digits = $Hex + "abcdef"  ' Set the valid 'digits' string
      t = LTxtG(MarkRect.Top)                                     ' Get the first text line
      IF LEN(t) < MarkRect.Right THEN t += SPACE$(MarkRect.Right - LEN(t)) ' Padd if needed
      t = MID$(t, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1) ' Extract the columns containg the model

      '--------------------------------------------------------------------------------------------+
      '- See if there's a suffix                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF INSTR(digits, RIGHT$(t, 1)) > 0 THEN                     ' If it ends in a digit,
         msuffix = ""                                             ' then there is NO suffix
      ELSE                                                        ' Non-digit, we must extract the suffix
         i = INSTR(-1, t, ANY digits)                             ' Look for the last digit
         IF i = 0 THEN                                            ' None? whoops
            DoSet(%Refresh)                                       ' Have it looked at
            MErrExit(%eFail, "Enum model has no starting value")  ' Error
         END IF                                                   '
         msuffix = MID$(t, i + 1)                                 ' Found digit, extract suffix
         t = LEFT$(t, i)                                          ' Strip it off the model
      END IF                                                      '
      me.MarkKill                                                 ' Reset the select frame
      me.SwapKill                                                 '

      '--------------------------------------------------------------------------------------------+
      '- Now extract the prefix                                                                    |
      '--------------------------------------------------------------------------------------------+
      j = 0                                                       ' Reset j
      FOR i = LEN(t) TO 1 STEP -1                                 ' Look backward for 1st non-digit
         IF INSTR(digits, MID$(t, i, 1)) > 0 THEN ITERATE FOR     ' If a digit, keep looking
         j = i: EXIT FOR                                          ' Found a non digit, save its loc and exit for
      NEXT i                                                      '
      IF j = 0 THEN                                               ' All were digits
         mprefix = ""                                             ' Therefor no prefix
      ELSE                                                        ' Non-digit, we have a prefix
         mprefix = LEFT$(t, j)                                    ' Save prefix
         t = MID$(t, j + 1)                                       ' Extract it leaving t as the eval string.
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Extract the enum value                                                                    |
      '--------------------------------------------------------------------------------------------+
      ln = LEN(t)                                                 ' Save length for rebuilding
      IF which = "D" THEN                                         ' Decimal Enum?
         menum = VAL(t)                                           ' Save it
         IF LEN(t) <> LEN(FORMAT$(menum)) THEN enumz = %True      ' Entered as leading zeros?, remember that
      ELSE                                                        ' One of the Hex
         menum = VAL("&H" + t)                                    ' Save it that way
         IF LEN(t) <> LEN(HEX$(menum)) THEN enumz = %True         ' Entered as leading zeros?, remember that
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now modify the PT lines                                                                   |
      '--------------------------------------------------------------------------------------------+
      FOR k = MarkRect.Top TO MarkRect.Bottom                     ' Loop for each line
         IF ISFALSE IsLData(k) THEN ITERATE FOR                   ' Only Data lines
         me.ModSet(k)                                             ' Remember we changed something
         tt = LTxtG(k)                                            ' Get working copy of text
         IF LEN(tt) < MarkRect.Right THEN tt = tt + SPACE$(MarkRect.Right - LEN(tt))   ' Padd if needed

         '-----------------------------------------------------------------------------------------+
         '- Select which Enum type to do                                                           |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE AS CONST$ which                              ' Build output string
            CASE "D"                                              ' Decimal
               t = FORMAT$(menum)                                 '
               GOSUB AdjustPad                                    ' Do padding etc.
            CASE "L"                                              ' Lowercase Hex
               t = LLCASE(HEX$(menum))                            '
               GOSUB AdjustPad                                    ' Do padding etc.
            CASE "U"                                              ' Lowercase Hex
               t = HEX$(menum)                                    '
               GOSUB AdjustPad                                    ' Do padding etc.
         END SELECT                                               '

         '-----------------------------------------------------------------------------------------+
         '- Build the value and stuff it in                                                        |
         '-----------------------------------------------------------------------------------------+
         t = mprefix + t + msuffix                                ' Add prefix and suffix
         t = RIGHT$(RSET$(t, MarkRect.Right - MarkRect.Left + 1), MarkRect.Right - MarkRect.Left + 1) ' Right align and trim it
         MID$(tt, MarkRect.Left, LEN(t)) = t                      ' Overlay the enum text
         me.LTxtSet(k, tt)                                        ' Save it back
         me.AttrScan(k)                                           ' Recolorize

         menum += gEnumWith                                       ' Incr enum for next line
      NEXT k                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      MExitMeth                                                   '

   '-----------------------------------------------------------------------------------------------+
   '- Fiddle with the prefix padding                                                               |
   '-----------------------------------------------------------------------------------------------+
   AdjustPad:                                                     '
      IF LEN(t) > ln AND RIGHT$(mprefix, 1) = " " THEN            ' If enum needs more room, and Prefix has some
         mprefix = CLIP$(RIGHT, mprefix, 1)                       ' Steal right hand blank from prefix
         INCR ln                                                  ' Make enum longer
      ELSEIF LEN(t) > ln AND LEFT$(mprefix, 1) = " " THEN         ' If not right end, try left end
         mprefix = MID$(mprefix, 2)                               ' Steal left hand blank from prefix
         INCR ln                                                  ' Make enum longer
      END IF                                                      '
      IF LEN(t) > ln AND RIGHT$(msuffix, 1) = " " THEN            ' If enum needs more room, and Suffix has some
         msuffix = CLIP$(RIGHT, msuffix, 1)                       ' Steal right hand blank from suffix
         INCR ln                                                  ' Make enum longer
      ELSEIF LEN(t) > ln AND LEFT$(msuffix, 1) = " " THEN         ' If not right end, try left end
         msuffix = MID$(msuffix, 2)                               ' Steal left hand blank from suffix
         INCR ln                                                  ' Make enum longer
      END IF                                                      '
      IF enumz THEN                                               ' Pad appropriately
         t = RIGHT$(REPEAT$(ln, "0") + t, ln)                     '
      ELSE                                                        '
         t = RIGHT$(REPEAT$(ln, " ") + t, ln)                     '
      END IF                                                      '
      RETURN                                                      '

   END METHOD                                                     '

   METHOD  krEOL()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- EOL key                                                                                      |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j AS LONG, lclTabs, t AS STRING                       '

      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Cursor in the Command area                                                                |
      '--------------------------------------------------------------------------------------------+
      IF IsCCmnd THEN                                             ' In the Command area?
         pCommand = LEFT$(pCommand, @P.C.CCol - @P.PCmdCol + @P.PCOffset)  ' Truncate the line then
         me.WindowCmd                                             ' Re-do the command line
         me.CsrCol = @P.C.CCol                                    '

      '--------------------------------------------------------------------------------------------+
      '- Cursor in the Scroll amount field                                                         |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCScrl THEN                                         ' In the Scroll Amt area?
         FCB.ScrollAmt = LEFT$(LEFT$(FCB.ScrollAmt, @P.C.CLCol - 1) + "    ", 4)  ' Truncate the line then
         DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, @P.PTop, @P.PScrData)  ' Print the whole string again

      '--------------------------------------------------------------------------------------------+
      '- Cursor in the text data                                                                   |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCData  THEN                                        ' In the Data area?
         me.AttrInvClearFind                                      ' Clear any Find HiLite
         IF IsBrowse THEN DoBeep: MExitMeth                       ' Not allowed in Browse mode

         '-----------------------------------------------------------------------------------------+
         '- Ensure we're on a valid line                                                           |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CIX = 0 THEN DoBeep: MExitMeth                   ' Bail out if below last line
         IF FCB.TabBnds AND FCB.HexMode = 4 THEN DoBeep: MExitMeth' TabBNDS and Hex is a no-no
         IF @P.C.CIX < 0 THEN DoBeep: MExitMeth                   ' Hex extra line, error
         IF ISFALSE (LFlagG(@P.C.CIX) AND %NonTypable) THEN       ' See if cursor on a typable line

            '--------------------------------------------------------------------------------------+
            '- Finally, truncate the line                                                          |
            '--------------------------------------------------------------------------------------+
            i = @P.C.CCol - @P.PGapCol + @P.POffset               ' Calc index into string
            lclTabs = me.TabsSimple(LEN(L(@P.C.CIX).@LTxt))       ' Get a working tabs line
            j = INSTR(i + 1, lclTabs, "*")                        ' Find next tab
            IF ISFALSE FCB.TabBnds OR _                           ' If not TABSBNDS OR
               (ISTRUE FCB.TabBNDS AND j = 0) THEN                ' TabBNDS and no further tabs?
               me.LTxtSet(@P.C.CIX, LEFT$(LTxtG(@P.C.CIX), i - 1))' Truncate the line then
            ELSE                                                  ' TabsBNDS AND a further Tab
               t = LTxtG(@P.C.CIX)                                ' Get the Text
               MID$(t, i TO j - 1) = SPACE$(j - i)                ' Blank to next tab
               me.LTxtSet(@P.C.CIX, t)                            ' Save it
            END IF                                                '
            me.CurSetReq(%EOL, @P.C.CIX, i, %True)                ' Set cursor set attempt
            me.ModSet(@P.C.CIX)                                   ' Remember we changed something
            me.UCIfNeeded(@P.C.CIX)                               ' UC if CAPS ON
            me.AttrScan(@P.C.CIX)                                 ' Recolorize
            me.DispLine(@P.C.CIX, @P.C.CRow)                      ' Re-display the line

            '--------------------------------------------------------------------------------------+
            '- Do a lot more if in HEX mode                                                        |
            '--------------------------------------------------------------------------------------+
            IF FCB.HexMode = &4 THEN                              ' If Hex mode, do extra
               IF @P.C.CRow + 1 <= TP.gPBottom THEN               ' Make sure we don't go off the bottom
                  DoPrint (me.WindowHexTop(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 1, @P.PDataCol)  ' Print upper hex
                  me.MarkReDraw(@P.C.CRow + 1)                    ' Re-draw the MARK lines
               END IF                                             '
               IF @P.C.CRow + 2 <= TP.gPBottom THEN               ' Make sure we don't go off the bottom
                  DoPrint (me.WindowHexBottom(LTxtG(@P.C.CIX)), $$TxtHi, @P.C.CRow + 2, @P.PDataCol)  ' Print lower hex
                  me.MarkReDraw(@P.C.CRow + 2)                    ' Re-draw the MARK lines
               END IF                                             '
            END IF                                                '
         ELSE                                                     '
            DoBeep                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Cursor in the Line Number area                                                            |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCLinN  THEN                                        ' In the Line Number area
         IF @P.C.CIX = 0 THEN MExitMeth                           ' Bail out if below last line
         IF me.IsTouchable(@P.C.CIX) THEN                         ' If 1st interaction in the line number area
            LLCtlS(@P.C.CIX) = $BlankLNo: me.CsrCol = @P.PLeft    ' Blank the Line number
            DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
         END IF                                                   '
         LLCtlS(@P.C.CIX) = LEFT$(LEFT$(LLCtlG(@P.C.CIX), @P.C.CLCol - 1) + $BlankLNo, 8) '
         me.TTblAdd(@P.C.CIX, TRIM$(LLCtlG(@P.C.CIX)))            ' Update touched items
         DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
      ELSE                                                        '
         DoBeep                                                   '
      END IF                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krErase()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Erase (blank) a selected block                                                               |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x AS LONG, lclTxt, a AS STRING                           '
      IF ISFALSE IsMarkActive OR ISFALSE IsCData THEN EXIT METHOD ' Not possible, exit

      '--------------------------------------------------------------------------------------------+
      '- OK, do the erase                                                                          |
      '--------------------------------------------------------------------------------------------+
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISTRUE IsLData(x) THEN                                ' Just data lines
            lclTxt = LTxtG(x)                                     ' Get the text
            IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = lclTxt + SPACE$(MarkRect.Right - LEN(lclTxt))  ' Padd if needed
            MID$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1) = SPACE$(MarkRect.Right - MarkRect.Left + 1)   ' Blank the columns
            me.LTxtSet(x, lclTxt)                                 ' Stuff it back
            me.AttrScan(x)                                        ' Recolorize
            me.ModSet(x)                                          ' Remember we changed something
         END IF                                                   '
      NEXT x                                                      '
      me.MarkKill                                                 ' Reset the select frame
      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  krFind(which AS STRING)                                '
   '-----------------------------------------------------------------------------------------------+
   '- Find the highlighted filename                                                                |
   '-----------------------------------------------------------------------------------------------+
   LOCAL lclTxt, a AS STRING                                      '
      '--------------------------------------------------------------------------------------------+
      '- See if anything's highlighted, if not treat as RFIND                                      |
      '--------------------------------------------------------------------------------------------+
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      IF ISFALSE IsMarkActive THEN                                ' If nothing selected, treat as RFIND
         PCmdRFIND(IIF$(which = "NEXT", "RFIND ", "RFIND REV "))  ' Call RFIND
         me.DispScreen                                            ' Redisplay things

      '--------------------------------------------------------------------------------------------+
      '- Stuff highlighted, grab the boundaries                                                    |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' Else do the full marked thing
         IF MarkRect.Top <> MarkRect.Bottom THEN DoBeep: EXIT METHOD ' Better be just one line
         IF ISFALSE IsLData(MarkRect.Bottom) AND ISFALSE IsLNote(MarkRect.Bottom) THEN DoBeep: EXIT METHOD  ' Better be a data/note line

         '-----------------------------------------------------------------------------------------+
         '- OK, now build the string                                                               |
         '-----------------------------------------------------------------------------------------+
         lclTxt = LTxtG(MarkRect.Bottom)                          ' Get the text
         IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = lclTxt + SPACE$(MarkRect.Right - LEN(lclTxt))  ' Padd if needed
         lclTxt = MID$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Extract the columns
         lclTxt = StrQuote(lclTxt)                                ' Quote it to protect spaces, quotes etc.
         me.MarkKill                                              ' Reset the select frame
         me.SwapKill                                              '
         PCmdFIND("FIND " + which + " " + lclTxt)                 ' Call FIND
         me.DispScreen                                            ' Redisplay things
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krFirstLCmd()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- First Line Cmd area                                                                          |
   '-----------------------------------------------------------------------------------------------+
      me.CsrRow = @P.PData1: me.CsrCol = @P.PLeft                 '
   END METHOD                                                     '

   METHOD  krHome()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Home the cursor                                                                              |
   '-----------------------------------------------------------------------------------------------+
      SetCmd                                                      ' Cursor to the command line
      @P.PCOffset = 0                                             ' Remove Offset
      DoCursor                                                    '
      me.WindowCmd                                                ' Redisplay the line
   END METHOD                                                     '

   METHOD  krInsert()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Insert key ON or OFF                                                                         |
   '-----------------------------------------------------------------------------------------------+
      IF IsNsrtFlag THEN OffNsrtFlag ELSE OnNsrtFlag              ' Flip/Flop the mode
      OffNsrtData                                                 ' Always set DataInsert off
      CaretDestroy                                                '
      CaretCreate                                                 '
      DoCursor                                                    '
      CaretShow                                                   '
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar Ins/Ovr box
   END METHOD                                                     '

   METHOD  krISODate()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Paste ISO Date at cursor location                                                            |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = DATE$                                                  ' Go get the date
      ln = MID$(ln, 7) + "-" + LEFT$(ln, 2) + "-" + MID$(ln, 4, 2)   ' Reformat it to ISO standard
      me.krTDPaste(ln)                                            '
   END METHOD                                                     '

   METHOD  krISOTime()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Paste ISO Time at cursor location                                                            |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = TIME$                                                  ' Go get the time
      me.krTDPaste(ln)                                            '
   END METHOD                                                     '

   METHOD  krJustify()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Justify a selected block                                                                     |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x AS LONG, lclTxt, jtxt, ttxt AS STRING                  '
      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Justify                                                                    |
      '--------------------------------------------------------------------------------------------+
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISTRUE IsLData(x) OR ISTRUE IsLNote(x) THEN           ' Just data lines
            lclTxt = LTxtG(x)                                     ' Get the text
            me.ModSet(x)                                          ' Remember we changed something
            IF LEN(lclTxt) < MarkRect.Right THEN _                ' Lengthen text if needed
               lclTxt = LSET$(lclTxt, MarkRect.Right)             '
            jtxt = MID$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left +1)   ' Get the string to be justified
            SELECT CASE AS CONST$ gKeyChr                         ' Do the right type of justify
               CASE "JUSTIFYL": jtxt = LSET$(LTRIM$(jtxt), LEN(jtxt))   '
               CASE "JUSTIFYR": jtxt = RSET$(RTRIM$(jtxt), LEN(jtxt))   '
               CASE "JUSTIFYC": ttxt = SPACE$(LEN(jtxt)): jtxt = TRIM$(jtxt)  '
                                MID$(ttxt, (LEN(ttxt) - LEN(jtxt)) \ 2 + 1, LEN(jtxt)) = jtxt   '
                                jtxt = ttxt                       '
            END SELECT                                            '
            MID$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1) = jtxt  ' Re-insert the string
            me.LTxtSet(x, lclTxt)                                 ' Put work string back
            me.AttrScan(x)                                        ' Recolorize
            me.CurSetReq(%Position, MarkRect.Bottom, MarkRect.Left, %True) ' Set cursor set attempt
         END IF                                                   '
      NEXT x                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      me.MarkKill                                                 ' Reset the select frame
   END METHOD                                                     '

   METHOD  krKCpy()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Block COPY based on selected window text                                                     |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x AS LONG, lclTxt, CBD, MyDLM AS STRING                  '

      MEntry                                                      '
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      IF IsMarkActive THEN                                        ' Normal Text mark?
         '-----------------------------------------------------------------------------------------+
         '- OK, now build the Clipboard string                                                     |
         '-----------------------------------------------------------------------------------------+
         IF LEFT$(gKeyPrimOper, 4) <> "$RAA" THEN                 ' If not APPEND mode
            CBD = ""                                              ' Start as ""
         ELSE                                                     '
            ClipboardRead(CBD, MyDLM, %False)                     ' Go get whatever's there, keep the file
         END IF                                                   '

         FOR x = MarkRect.Top TO MarkRect.Bottom                  ' Loop through the requested range
            IF ISTRUE IsLData(x) OR ISTRUE IsLNote(x) THEN        ' Just Data / Note lines
               lclTxt = LTxtG(x)                                  ' Get the text
               IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
               lclTxt = MID$(lclTxt, MarkRect.Left TO MarkRect.Right)   ' Extract the columns
               IF LEFT$(gKeyPrimOper, 4) <> "$RAW"  AND LEFT$(gKeyPrimOper, 4) <> "$RAA" THEN   ' If not RAW or RAA, do it the normal way
                  CBD += lclTxt + $CR + $LF                       ' Add each line with CR/LF
               ELSE                                               ' Else
                  CBD += lclTxt                                   ' Do it without CRLF
               END IF                                             '
            END IF                                                '
         NEXT x                                                   '
         IF LEFT$(gKeyPrimOper, 4) = "$RAW" OR LEFT$(gKeyPrimOper, 4) = "$RAA" THEN gKeyPrimOper = MID$(gKeyPrimOper, 5)   ' If RAW, strip it off now

      '--------------------------------------------------------------------------------------------+
      '- Must be Misc line mark                                                                    |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        '
         SELECT CASE AS LONG MiscZone                             ' Which one?
            CASE %CCmd                                            ' Command line
               CBD = MID$(pCommand, MiscRect.Left TO MiscRect.Right) ' Get string from command line
            CASE %CFPath                                          ' FM Path line
               CBD = MID$(FPath, MiscRect.Left TO MiscRect.Right) ' Get string from the line
            CASE %CFMask                                          ' FM Mask line
               CBD = MID$(FMask, MiscRect.Left TO MiscRect.Right) ' Get string from the line
         END SELECT                                               '
      END IF                                                      '

      '-----------------------------------------------------------------------------------------+
      '- Stuff it in the clipboard                                                              |
      '-----------------------------------------------------------------------------------------+
      IF ISNOTNULL(CBD) THEN                                      ' If not null
         IF ClipboardWrite(CBD) THEN _                            ' Write it
            me.MarkKill                                           ' Reset the select frame
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krKCpyAdd()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Block copy in RAW APPEND mode                                                                |
   '-----------------------------------------------------------------------------------------------+
      gKeyPrimOper = "$RAA" + gKeyPrimOper                        ' Tell krKCpy it's RAW mode
      me.krKCpy()                                                 ' Let IT do the work
   END METHOD                                                     '

   METHOD  krKCpyRaw()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Block copy in RAW mode                                                                       |
   '-----------------------------------------------------------------------------------------------+
      gKeyPrimOper = "$RAW" + gKeyPrimOper                        ' Tell krKCpy it's RAW mode
      me.krKCpy()                                                 ' Let IT do the work
   END METHOD                                                     '

   METHOD  krKCut()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Block CUT based on selected window text                                                      |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x AS LONG, lclTxt, CBD AS STRING                         '

      MEntry                                                      '
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      IF IsMarkActive THEN                                        ' Normal Text mark?
         '-----------------------------------------------------------------------------------------+
         '- OK, now build the Clipboard string                                                     |
         '-----------------------------------------------------------------------------------------+
         CBD = ""                                                 ' Start as ""
         FOR x = MarkRect.Top TO MarkRect.Bottom                  ' Loop through the requested range
            IF ISTRUE IsLData(x) OR ISTRUE IsLNote(x) THEN        ' Just Data.Note lines
               lclTxt = LTxtG(x)                                  ' Get the text
               IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
               lclTxt = MID$(lclTxt, MarkRect.Left TO MarkRect.Right)   ' Extract the columns
               CBD += lclTxt + $CR + $LF                          ' Add each line with CR/LF

               me.ModSet(x)                                       ' Remember we changed something
               lclTxt = LTxtG(x)                                  ' Get the text again
               lclTxt = STRDELETE$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete the characters
               me.LAttrAdjust(x, MarkRect.Left, -(MarkRect.Right - MarkRect.Left + 1)) ' Adjust any Attr hilite
               me.LTxtSet(x, lclTxt)                              ' Put work string back
               me.UCIfNeeded(x)                                   ' UC if CAPS ON
               me.AttrScan(x)                                     ' Recolorize
            END IF                                                '
         NEXT x                                                   '
         me.CurSetReq(%Position, MarkRect.Bottom, MarkRect.Right - (MarkRect.Right - MarkRect.Left), %True) ' Set cursor set attempt


      ELSE                                                        '
         SELECT CASE AS LONG MiscZone                             ' Which one?
            CASE %CCmd                                            ' Command line
               CBD = MID$(pCommand, MiscRect.Left TO MiscRect.Right) ' Get string from command line
               pCommand = STRDELETE$(pCommand, MiscRect.Left, MiscRect.Right - MiscRect.Left + 1)  ' Delete the characters
            CASE %CFPath                                          ' FM Path line
               CBD = MID$(FPath, MiscRect.Left TO MiscRect.Right) ' Get string from the line
               FPath = STRDELETE$(FPath, MiscRect.Left, MiscRect.Right - MiscRect.Left + 1)  ' Delete the characters
            CASE %CFMask                                          ' FM Mask line
               CBD = MID$(FMask, MiscRect.Left TO MiscRect.Right) ' Get string from the line
               FMask = STRDELETE$(FMask, MiscRect.Left, MiscRect.Right - MiscRect.Left + 1)  ' Delete the characters
         END SELECT                                               '
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Stuff it in the clipboard                                                                 |
      '--------------------------------------------------------------------------------------------+
      IF ISNOTNULL(CBD) THEN                                      ' If not null
         IF ClipboardWrite(CBD) THEN _                            ' Write it
            me.MarkKill                                           ' Reset the select frame
      END IF                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krLastTab()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Tab To the Last Tab marker                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k AS LONG, lclTabs AS STRING                       '
      MEntry                                                      '
      OnInsClnSupp                                                ' Suppress Insert cleanup for 1 Attn pass

      SELECT CASE @P.C.CRow                                       ' Do tabbing based on where we are

         '-----------------------------------------------------------------------------------------+
         '- Top line                                                                               |
         '-----------------------------------------------------------------------------------------+
         CASE @P.PTop                                             ' Top Row
            IF @P.C.CCol < @P.PCmdCol THEN SetCmd: MExitMeth      '
            IF @P.C.CCol < @P.PScrData THEN me.CsrCol = @P.PScrData: MExitMeth   '
            me.CsrRow = @P.PData1: me.CsrCol = @P.PDataCol: MExitMeth   '

         '-----------------------------------------------------------------------------------------+
         '- Message or COLS line                                                                   |
         '-----------------------------------------------------------------------------------------+
         CASE < @P.PData1                                         ' Line 2 or COLS line
            me.CsrRow = @P.PData1: me.CsrCol = @P.PDataCol: MExitMeth   '

         '-----------------------------------------------------------------------------------------+
         '- Not in the headers                                                                     |
         '-----------------------------------------------------------------------------------------+
         CASE ELSE                                                ' In data area

            '--------------------------------------------------------------------------------------+
            '- Get text line number and working TABS line                                          |
            '--------------------------------------------------------------------------------------+
            lclTabs = me.TabsSimple(LEN(L(@P.C.CIX).@LTxt))       ' Get a working tabs line

            i = INSTR(FCB.TabsLine, "+")                          ' + type tab line

            '--------------------------------------------------------------------------------------+
            '- Normal, non + type tab line                                                         |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE i THEN                                     ' Can't really do LastTab with extensible tabs
               IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Get real data line
               k = 0                                              ' Say no next ine
               IF @P.C.CRow < TP.gPBottom THEN k = me.SGet(@P.C.CRow + 1)  ' See if another screen line
               IF ISFALSE FCB.Tabs THEN                           ' If not tabbing
                  me.CsrRowAdd(1): me.CsrCol = @P.PLeft           ' Do basic bump
                  IF @P.C.CRow > TP.gPBottom OR k = 0 THEN SetCmd ' Down too far?   Cursor to the command line
                  MExitMeth                                       ' Leave now
               END IF                                             '
               IF IsLTop(@P.C.CIX) THEN                           ' On the Top of Data Line
                  me.CsrCol = @P.PDataCol: me.CsrRowAdd(1)        ' Col 1 of next line
               END IF                                             '
                                                                  ' Tabbing IN a data line
               i = INSTR(-1, lclTabs, "*")                        ' look for last tab marker
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Tab line has + repeating tab                                                        |
            '--------------------------------------------------------------------------------------+
            IF i THEN                                             ' we have one
               IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, @P.C.CIX, i, %True)     ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
                  MExitMeth                                       '
               ELSE                                               '
                  me.CsrCol = i + @P.PGapCol - @P.POffset         ' Just move cursor on the screen
                  MExitMeth                                       '
               END IF                                             '
            ELSE                                                  ' ?? No tabs?
               me.CsrCol = @P.PDataCol - @P.POffset               ' Just move cursor on the screen
            END IF                                                '
         END SELECT                                               '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krLeft()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Decrement CsrCol                                                                             |
   '-----------------------------------------------------------------------------------------------+
   LOCAL cIncr, OldOffset, Hexrow AS LONG                         '
   LOCAL t AS STRING                                              '
      MEntry                                                      '
      cIncr = IIF(VAL(gKeyPrimOper) > 0, VAL(gKeyPrimOper), 1)    ' Set the INCR amount?
      IF ISFALSE gENV.KBHorScroll THEN                            ' No KeybScroll
         '-----------------------------------------------------------------------------------------+
         '- No horizontal scrolling                                                                |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CCol = @P.PLeft THEN                             ' Line Wrap?
            me.CsrCol = @P.PRight: me.CsrRowSub(1)                ' Yes, make adjustment
            IF @P.C.CRow < @P.PTop THEN me.CsrRow = @P.PBottom    ' Also Row Wrap if needed
         ELSE                                                     '
            me.CsrColSub(cIncr)                                   ' Simple DECR
            IF @P.C.CCol < @P.PLeft THEN                          ' Line Wrap?
               me.CsrCol = @P.PRight: me.CsrRowSub(1)             ' Yes, make adjustment
               IF @P.C.CRow < @P.PTop THEN me.CsrRow = @P.PBottom ' Also Row Wrap if needed
            END IF                                                '
         END IF                                                   '
      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '- Horizontal scrolling is active                                                         |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CRow = @P.PTop THEN                              ' In the command area
            IF @P.C.CCol <= @P.PCmdCol THEN                       ' If left of command
               IF @P.PCOffset > 0 THEN                            ' If offset > 0
                  cIncr = MIN(cIncr, @P.PCOffSet)                 ' Make sure we don't go too far left
                  me.COffsetSub(cIncr)                            ' Reduce the offset
                  me.WindowCmd                                    ' Re-do the command line
               ELSE                                               ' No Offset left?
                  IF @P.C.CCol >= @P.PLeft + cIncr THEN me.CsrColSub(cIncr)   ' Just move left if room
               END IF                                             '
            ELSE                                                  '
               IF @P.C.CCol >= @P.PLeft + cIncr THEN me.CsrColSub(cIncr)   ' Just move left if room
            END IF                                                '

         ELSEIF @P.C.CRow < @P.PData1 THEN                        ' Message of COLS line?
            IF @P.C.CCol >= @P.PLeft + cIncr THEN me.CsrColSub(cIncr)   ' Just move left if room

         ELSE                                                     ' We're in Data Line area
            '--------------------------------------------------------------------------------------+
            '- In the Data Line area                                                               |
            '--------------------------------------------------------------------------------------+
            IF @P.C.CCol < @P.PDataCol THEN                       ' In Line # area
               IF @P.C.CCol >= @P.PLeft + cIncr THEN me.CsrColSub(cIncr)   ' Just move left if room
            ELSE                                                  '
               IF @P.POffset > 0 AND @P.C.CCol = @P.PDataCol THEN ' YES - at left hand and room to scroll?
                  cIncr = MIN(cIncr, @P.POffSet)                  ' Make sure we don't go too far left
                  IF @P.C.CIX = 0 THEN MExitMeth                  ' Exit if below bottom line
                  IF @P.C.CIX < 0 THEN                            ' A Hex line?
                     HexRow = ABS(@P.C.CIX)                       ' Save the hex line
                     @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Get real data line
                  END IF                                          '
                  me.CurSetReq(%Position, @P.C.CIX, @P.PLeft - 1 + @P.C.CCol + @P.POffset - @P.PGapCol - cIncr, %False, 0, Hexrow)  ' Set cursor set attempt
                  me.OffsetSub(cIncr)                             ' Drop the offset
                  OnInsClnSupp                                    ' Suppress Insert cleanup for 1 Attn pass
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               ' No Offset left
                  IF @P.C.CCol >= @P.PLeft + cIncr THEN me.CsrColSub(cIncr)   ' Just move left if room
               END IF                                             '
            END IF                                                '

         END IF                                                   '

      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krLift()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Block COPY and Erase based on selected window text                                           |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x AS LONG, lclTxt, ltxt2, a, CBD AS STRING               '

      MEntry                                                      '
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      IF IsMarkActive THEN                                        ' Normal text hilighted
         IF IsBrowse THEN DoBeep: MExitMeth                       ' Not allowed in Browse mode

         '-----------------------------------------------------------------------------------------+
         '- OK, now build the Clipboard string                                                     |
         '-----------------------------------------------------------------------------------------+
         CBD = ""                                                 ' Start as ""
         FOR x = MarkRect.Top TO MarkRect.Bottom                  ' Loop through the requested range
            IF ISTRUE IsLData(x) THEN                             ' Just data lines
               lclTxt = LTxtG(x)                                  ' Get the text
               IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
               lTxt2 = MID$(lclTxt, MarkRect.Left TO MarkRect.Right) ' Extract the columns
               CBD += lTxt2 + $CR + $LF                           ' Add each line with CR/LF
               MID$(lclTxt, MarkRect.Left TO MarkRect.Right) = SPACE$(MarkRect.Right - MarkRect.Left + 1)   ' Blank the columns
               me.LTxtSet(x, lclTxt)                              ' Stuff it back
               me.AttrScan(x)                                     ' Recolorize
               me.ModSet(x)                                       ' Remember we changed something
            END IF                                                '
         NEXT x                                                   '
      ELSE                                                        '
         SELECT CASE AS LONG MiscZone                             ' Which one?
            CASE %CCmd                                            ' Command line
               CBD = MID$(pCommand, MiscRect.Left TO MiscRect.Right) ' Get string from command line
               lclTxt = pCommand                                  ' Get a copy of the line
               MID$(lclTxt, MiscRect.Left TO MiscRect.Right) = SPACE$(LEN(CBD))  ' Blank the columnss
               pCommand = lclTxt                                  ' Store it back
            CASE %CFPath                                          ' FM Path line
               CBD = MID$(FPath, MiscRect.Left TO MiscRect.Right) ' Get string from the line
               lclTxt = FPath                                     ' Get a copy of the line
               MID$(lclTxt, MiscRect.Left TO MiscRect.Right) = SPACE$(LEN(CBD))  ' Blank the columnss
               FPath = lclTxt                                     ' Store it back
            CASE %CFMask                                          ' FM Mask line
               CBD = MID$(FMask, MiscRect.Left TO MiscRect.Right) ' Get string from the line
               lclTxt = FMask                                     ' Get a copy of the line
               MID$(lclTxt, MiscRect.Left TO MiscRect.Right) = SPACE$(LEN(CBD))  ' Blank the columnss
               FMask = lclTxt                                     ' Store it back
         END SELECT                                               '
            me.MarkKill                                           ' Reset the select frame
      END IF                                                      '
      '-----------------------------------------------------------------------------------------+
      '- Stuff it in the clipboard                                                              |
      '-----------------------------------------------------------------------------------------+
      IF ISNOTNULL(CBD) THEN                                      ' If not null
         IF ClipboardWrite(CBD) THEN _                            ' Write it
            me.MarkKill                                           ' Reset the select frame
      END IF                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krLineNo()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- LineNo key                                                                                   |
   '-----------------------------------------------------------------------------------------------+
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Only if in an eligible line                                                               |
      '--------------------------------------------------------------------------------------------+
      IF IsCData OR IsCLinN THEN                                  '
         IF @P.C.CIX = 0 OR @P.C.CIX = -3 THEN DoBeep: EXIT METHOD   ' Below last line or Hex dash line? Bail out
         me.CsrCol = @P.PLeft                                     ' Move cursor back to col 1
      ELSE                                                        '
         DoBeep                                                   ' Beep
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krLowerCase()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- LowerCase a selected block                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x, i AS LONG, lclTxt AS STRING                           '
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      IF ISFALSE IsMarkActive THEN DoBeep: EXIT METHOD            ' Better be something selected, else exit

      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Lowercase                                                                  |
      '--------------------------------------------------------------------------------------------+
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISTRUE IsLData(x) OR ISTRUE IsLNote(x) THEN           ' Just data/note lines
            lclTxt = LTxtG(x)                                     ' Get the text
            me.ModSet(x)                                          ' Remember we changed something
            IF MarkRect.Left <= LEN(lclTxt) THEN                  ' Do only if long enough
               FOR i = MarkRect.Left TO MIN(MarkRect.Right, LEN(lclTxt))   ' Just ones that are there
                  MID$(lclTxt, i, 1) = LLCASE(MID$(lclTxt, i, 1)) '
               NEXT i                                             '
               me.LTxtSet(x, lclTxt)                              ' Put work string back
               me.AttrScan(x)                                     ' Recolorize
               me.CurSetReq(%Position, MarkRect.Bottom, MarkRect.Right + 1, %True)  ' Set cursor set attempt
            END IF                                                '
         END IF                                                   '
      NEXT x                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      me.MarkKill                                                 ' Reset the select frame
   END METHOD                                                     '

   METHOD  krMarkc(Dir AS STRING, Pass AS DWORD)                  '
   '-----------------------------------------------------------------------------------------------+
   '- Conditional Mark Arrow                                                                       |
   '-----------------------------------------------------------------------------------------------+
      IF (ISFALSE IsMiscActive) AND (ISFALSE IsMarkActive) THEN   '
         me.krMark(Dir, Pass)                                     ' If no active area right now, start one
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krMEditList()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- Handle the Display of the MEdit Files list                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL fn AS STRING                                             '
   REGISTER i AS LONG                                             '
   LOCAL IPList(), PopList() AS STRING                            '
      IF ISFALSE IsMedit THEN EXIT METHOD                         ' Nobody here, move along
      DIM IPList(1 TO MEditCount)                                 ' Get array sized
      FOR i = 1 TO MeditCount                                     ' Build a temp list
         IPList(i) = MeditList(i)                                 '
      NEXT i                                                      '
      ARRAY SORT IPList() FOR MEditCount                          ' Sort it
      DIM PopList(1 TO MEditCount + 1)                            ' Get array sized
      PopList(1) = "9999.Jump to which file?"                     ' Insert header
      FOR i = 1 TO MeditCount                                     ' Build a Popup list
         PopList(i + 1) = FORMAT$(i) + "." + IPList(i)            '
      NEXT i                                                      '
      i = DoPopup(PopList(), 50, 50)                              ' Display it
      IF i = 0  OR i = 9999 THEN EXIT METHOD                      ' Ignore? Exit
      fn = IPList(i)                                              ' Get the desired name
      IF ISNULL(fn) THEN EXIT METHOD                              ' Nothing, leave
      FOR i = 1 TO LastLine                                       ' Now position it
         IF ISFALSE IsLFile(i) THEN ITERATE FOR                   ' Find file line
         IF LTxtG(i) <> fn THEN ITERATE FOR                       '
         @P.PTopLine = i                                          ' Move TopScrn by scroll amount
         TP.ErrMsgAdd(%eNone, "File: " + fn + " found")           '
         DoSet(%Refresh)                                          ' Have it looked at
         EXIT FOR                                                 '
      NEXT i                                                      '
   END METHOD                                                     '

   METHOD  krMark(Dir AS STRING, Pass AS DWORD)                   '
   '-----------------------------------------------------------------------------------------------+
   '- Mark Arrow                                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, TLin, TCol, OldLin, NewLin, ColAdj AS LONG            '
   LOCAL t AS STRING                                              '
      MEntry                                                      '
      IF IsMiscActive AND MiscZone <> @P.C.CType THEN _           ' Moved outside current marked @P.C.CType?
         me.MarkKill: MExitMeth                                   ' Kill it and leave cursor alone

      SELECT CASE AS LONG @P.C.CType                              ' Split by where we are

         '-----------------------------------------------------------------------------------------+
         '- Mark in the command line                                                               |
         '-----------------------------------------------------------------------------------------+
         CASE %CCmd                                               ' Command line

            '--------------------------------------------------------------------------------------+
            '- If highlight is active                                                              |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE IsMiscActive THEN                          ' If no active area right now, start one
               '-----------------------------------------------------------------------------------+
               '- No active bounds right now, Start one up                                         |
               '-----------------------------------------------------------------------------------+
               MiscZone = @P.C.CType                              ' Save the @P.C.CType we're marking in
               IF dir = "E" THEN                                  ' If END case
                  MiscRect.Left = @P.C.CLCol: MiscRect.Right = LEN(RTRIM$(pCommand))   '
                  CALL DWORD Pass                                 ' Then just move the cursor
               ELSE                                               '
                  MiscRect.Left = @P.C.CLCol: MiscRect.Right = @P.C.CLCol  '
               END IF                                             '
               OnMiscActive                                       ' We're starting a marked area
               me.MiscMark                                        ' Go Draw it

            ELSE                                                  '
               '-----------------------------------------------------------------------------------+
               '- We have an active area already                                                   |
               '-----------------------------------------------------------------------------------+
               GOSUB KillOrMove                                   ' Handle the simple conditions

               '-----------------------------------------------------------------------------------+
               '- We're at a boundary, see how to adjust the bounds                                |
               '-----------------------------------------------------------------------------------+
               SELECT CASE dir                                    ' Adjust boundaries
                  CASE "L"                                        ' Left
                     GOSUB MiscLeft                               ' Go adjust for Left

                  CASE "R"                                        ' Right
                     GOSUB MiscRight                              ' Go adjust for right

                  CASE "E"                                        ' End
                     MiscRect.Right = LEN(RTRIM$(pCommand))       ' Move right to text length column
                     me.MiscMark: CALL DWORD Pass: MExitMeth      ' Redraw the hilight and we're done

                  CASE "U"                                        ' Up
                     me.MarkKill: CALL DWORD Pass: MExitMeth      ' Just kill and move the cursor
                  CASE "D"                                        ' Down?

                     me.MarkKill: CALL DWORD Pass: MExitMeth      ' Just kill and move the cursor
               END SELECT                                         '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- Mark in the Path line                                                                  |
         '-----------------------------------------------------------------------------------------+
         CASE %CFPath                                             ' FM Path?

            '--------------------------------------------------------------------------------------+
            '- If highlight is active                                                              |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE IsMiscActive THEN                          ' If no active area right now, start one
               '-----------------------------------------------------------------------------------+
               '- No active bounds right now, Start one up                                         |
               '-----------------------------------------------------------------------------------+
               MiscZone = @P.C.CType                              ' Save the @P.C.CType we're marking in
               IF dir = "E" THEN                                  ' If END case
                  MiscRect.Left = @P.C.CLCol: MiscRect.Right = LEN(RTRIM$(FPath))   '
                  CALL DWORD Pass                                 ' Then just move the cursor
               ELSE                                               '
                  MiscRect.Left = @P.C.CLCol: MiscRect.Right = @P.C.CLCol  '
               END IF                                             '
               OnMiscActive                                       ' We're starting a marked area
               me.MiscMark                                        ' Go Draw it

            ELSE                                                  '
               '-----------------------------------------------------------------------------------+
               '- We have an active area already                                                   |
               '-----------------------------------------------------------------------------------+
               GOSUB KillOrMove                                   ' Handle the simple conditions

               '-----------------------------------------------------------------------------------+
               '- We're at a boundary, see how to adjust the bounds                                |
               '-----------------------------------------------------------------------------------+
               SELECT CASE dir                                    ' Adjust boundaries
                  CASE "L"                                        ' Left
                     GOSUB MiscLeft                               ' Go adjust for Left

                  CASE "R"                                        ' Right
                     GOSUB MiscRight                              ' Go adjust for right

                  CASE "E"                                        ' End
                     MiscRect.Right = LEN(RTRIM$(FPath))          ' Move right to text length column
                     me.MiscMark: CALL DWORD Pass: MExitMeth      ' Redraw the hilight and we're done

                  CASE "U", "D"                                   ' Up/Down?
                     me.MarkKill: CALL DWORD Pass: MExitMeth      ' Just kill and move the cursor

               END SELECT                                         '
            END IF                                                '

         CASE %CFMask                                             ' FM Mask?

            '--------------------------------------------------------------------------------------+
            '- If highlight is active                                                              |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE IsMiscActive THEN                          ' If no active area right now, start one
               '-----------------------------------------------------------------------------------+
               '- No active bounds right now, Start one up                                         |
               '-----------------------------------------------------------------------------------+
               MiscZone = @P.C.CType                              ' Save the @P.C.CType we're marking in
               IF dir = "E" THEN                                  ' If END case
                  MiscRect.Left = @P.C.CLCol: MiscRect.Right = LEN(RTRIM$(FMask))   '
                  CALL DWORD Pass                                 ' Then just move the cursor
               ELSE                                               '
                  MiscRect.Left = @P.C.CLCol: MiscRect.Right = @P.C.CLCol  '
               END IF                                             '
               OnMiscActive                                       ' We're starting a marked area
               me.MiscMark                                        ' Go Draw it

            ELSE                                                  '
               '-----------------------------------------------------------------------------------+
               '- We have an active area already                                                   |
               '-----------------------------------------------------------------------------------+
               GOSUB KillOrMove                                   ' Handle the simple conditions

               '-----------------------------------------------------------------------------------+
               '- We're at a boundary, see how to adjust the bounds                                |
               '-----------------------------------------------------------------------------------+
               SELECT CASE dir                                    ' Adjust boundaries
                  CASE "L"                                        ' Left
                     GOSUB MiscLeft                               ' Go adjust for Left

                  CASE "R"                                        ' Right
                     GOSUB MiscRight                              ' Go adjust for right

                  CASE "E"                                        ' End
                     MiscRect.Right = LEN(RTRIM$(FMask))          ' Move right to text length column
                     me.MiscMark: CALL DWORD Pass: MExitMeth      ' Redraw the hilight and we're done

                  CASE "U", "D"                                   ' Up/Down?
                     me.MarkKill: CALL DWORD Pass: MExitMeth      ' Just kill and move the cursor

               END SELECT                                         '
            END IF                                                '

         CASE %CLData                                             ' In text data area
            me.AttrInvClearFind                                   ' Clear any Find HiLite
            '--------------------------------------------------------------------------------------+
            '- Eliminate the can't handle type                                                     |
            '--------------------------------------------------------------------------------------+
            CsrLinDX = 0                                          ' Reset possible hidden DX line location
            IF FCB.HexMode = &4  THEN CALL DWORD Pass: DoBeep: MExitMeth   ' In HEX? Skip

            '--------------------------------------------------------------------------------------+
            '- Watch out for Swap overlap                                                          |
            '--------------------------------------------------------------------------------------+
            IF IsSwapActive THEN                                  ' Prevent Swap overlap
               TCol = @P.C.CLCol                                  '
               TCol += IIF(dir = "L", -1, 0)                      ' Create the 'next col'
               TCol += IIF(dir = "R", 1, 0)                       '
               TLin = @P.C.CIX                                    ' Check the top line
               IF TLin >= SwapSLin AND TLin <= SwapELin THEN      ' Within bounds vertically?
                  IF TCol >= SwapSCol AND TCol <= SwapECol THEN DoBeep: MExitMeth   ' And horizontally?
               END IF                                             '
               j = SwapLines - 1                                  ' Get number of data lines in Swap group
               DO WHILE j                                         ' See if enough lines here
                  IF IsLData(TLin) THEN                           ' If a data line
                     DECR j                                       ' Reduce count
                  END IF                                          '
                  INCR TLin                                       ' Next line
                  IF IsLBottom(TLin) THEN DoBeep: MExitMeth       '
               LOOP                                               '
               IF TLin >= SwapSLin AND TLin <= SwapELin THEN      ' Check the bottom lines
                  IF TCol >= SwapSCol AND TCol <= SwapECol THEN DoBeep: MExitMeth   ' And horizontally?
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- If highlight is active                                                              |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE IsMarkActive THEN                          ' If no current
               IF IsLXClude(@P.C.CIX) THEN MExitMeth              ' Can't start on an X'd line
               IF dir <> "E" THEN                                 ' If not the END case
                  MarkRect.Top = @P.C.CIX: MarkRect.Bottom = @P.C.CIX   ' Save 1 character area
                  MarkRect.Left = @P.C.CLCol: MarkRect.Right = @P.C.CLCol  '
               ELSE                                               ' END
                  MarkRect.Top = @P.C.CIX: MarkRect.Bottom = @P.C.CIX   ' Save area to end of text
                  MarkRect.Left = @P.C.CLCol: MarkRect.Right = LEN(RTRIM$(LTxtG(@P.C.CIX)))  '
                  CALL DWORD Pass                                 ' Then just move the cursor
               END IF                                             '
               IF IsSwapActive THEN                               ' If a SWAP is active
                  j = SwapLines - 1                               ' Get number of data lines in Swap group
                  DO WHILE j                                      ' See if enough lines here
                     IF IsLData(MarkRect.Bottom) THEN             ' If a data line
                        DECR j                                    ' Reduce count
                     END IF                                       '
                     MarkRect.Bottom = MarkRect.Bottom + 1        ' Next line
                     IF IsLBottom(MarkRect.Bottom) THEN DoBeep: MExitMeth  '
                  LOOP                                            '
               END IF                                             '
               OnMarkActive                                       ' Start a marked area
               me.MarkScr                                         ' Draw it

            ELSE                                                  ' We already have a Marked area

               '-----------------------------------------------------------------------------------+
               '- Kill mark if outside current boundaries                                          |
               '-----------------------------------------------------------------------------------+
               IF @P.C.CIX < MarkRect.Top OR @P.C.CIX > MarkRect.Bottom OR _  ' Somehow outside it's boundaries?
                  @P.C.CLCol < MarkRect.Left OR @P.C.CLCol > MarkRect.Right THEN '
                  me.MarkKill: MExitMeth                          ' Kill it and leave cursor alone
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- If within current bounds, just move the cursor                                   |
               '-----------------------------------------------------------------------------------+
               IF @P.C.CIX > MarkRect.Top AND @P.C.CIX < MarkRect.Bottom AND _   ' Somehow within the bounds?
                  @P.C.CLCol > MarkRect.Left AND @P.C.CLCol < MarkRect.Right THEN _ '
                  CALL DWORD Pass: MExitMeth                      ' Just move the cursor

               '-----------------------------------------------------------------------------------+
               '- We're at a boundary, see how to adjust the bounds                                |
               '-----------------------------------------------------------------------------------+
               SELECT CASE dir                                    ' Adjust boundaries

                  '--------------------------------------------------------------------------------+
                  '- Move boundary left                                                            |
                  '--------------------------------------------------------------------------------+
                  CASE "L"                                        ' Left
                     IF @P.C.CLCol = MarkRect.Left AND MarkRect.Left > 1 THEN ' At left and got room?
                        MarkRect.Left = MarkRect.Left - 1         ' Move left boundary
                        me.MarkScr: CALL DWORD Pass: MExitMeth    ' Redraw the hilight
                     ELSEIF @P.C.CLCol = MarkRect.Right AND MarkRect.Right > MarkRect.Left THEN ' At right and have room
                        MarkRect.Right = MarkRect.Right - 1       ' Move right boundary
                        me.MarkScr: CALL DWORD Pass: MExitMeth    ' Redraw the hilight
                     ELSE                                         '
                        CALL DWORD Pass: MExitMeth                ' Just move the cursor
                     END IF                                       '
                     IF IsMarkActive THEN me.MarkScr              ' Possibly redraw the highlight

                  '--------------------------------------------------------------------------------+
                  '- Move boundary right                                                           |
                  '--------------------------------------------------------------------------------+
                  CASE "R"                                        ' Right
                     IF @P.C.CLCol = MarkRect.Left AND MarkRect.Left < MarkRect.Right THEN   ' At left end and have room?
                        MarkRect.Left = MarkRect.Left + 1         ' Move left boundary
                        me.MarkScr: CALL DWORD Pass: MExitMeth    ' Redraw the hilight
                     ELSEIF @P.C.CLCol = MarkRect.Right THEN      ' At right
                        MarkRect.Right = MarkRect.Right + 1       ' Move right boundary
                        me.MarkScr: CALL DWORD Pass: MExitMeth    ' Redraw the hilight
                     ELSE                                         '
                        CALL DWORD Pass: MExitMeth                ' Just move the cursor
                     END IF                                       '

                  '--------------------------------------------------------------------------------+
                  '- Move boundary up                                                              |
                  '--------------------------------------------------------------------------------+
                  CASE "U"                                        ' Up
                     IF IsSwapActive THEN MExitMeth               ' Do nothing if SWAP active
                     IF @P.C.CIX = MarkRect.Top AND MarkRect.Top > 2 THEN  ' At the top or mark area and have room?
                        OldLin = me.sSearch(MarkRect.Top)         ' Get where current top is
                        MarkRect.Top = me.CRPBack(%MVisData, MarkRect.Top, 1) ' Move top boundary
                        NewLin = me.sSearch(MarkRect.Top)         ' Get where new top is
                        OldLin = OldLin - NewLin                  ' OldLin = # screen lines we went up
                        GOSUB DoDraw                              ' Draw, move cursor and exit
                     ELSEIF @P.C.CIX = MarkRect.Bottom AND MarkRect.Bottom > MarkRect.Top THEN  ' At bottom and got room?
                        OldLin = me.sSearch(MarkRect.Bottom)      ' Get where current bottom is
                        MarkRect.Bottom = me.CRPBack(%MVisData, MarkRect.Bottom, 1) ' Move bottom boundary
                        NewLin = me.sSearch(MarkRect.Bottom)      ' Get where new bottom is
                        OldLin = OldLin - NewLin                  ' OldLin = # screen lines we went up
                        GOSUB DoDraw                              ' Draw, move cursor and exit
                     ELSE                                         '
                        CALL DWORD Pass: MExitMeth                ' Just move the cursor
                     END IF                                       '

                  '--------------------------------------------------------------------------------+
                  '- Move boundary down                                                            |
                  '--------------------------------------------------------------------------------+
                  CASE "D"                                        ' Down
                     IF IsSwapActive THEN MExitMeth               ' Do nothing if SWAP active
                     IF @P.C.CIX = MarkRect.Top AND MarkRect.Top < MarkRect.Bottom THEN   ' At the top and have room?
                        OldLin = me.sSearch(MarkRect.Top)         ' Get where current top is
                        MarkRect.Top = me.CRPFwd(%MVisData, MarkRect.Top, 1)  ' Move top boundary
                        NewLin = me.sSearch(MarkRect.Top)         ' Get where new top is
                        OldLin = NewLin - OldLin                  ' OldLin = # screen lines we went down
                        GOSUB DoDraw                              ' Draw, move cursor and exit
                     ELSEIF @P.C.CIX = MarkRect.Bottom AND MarkRect.Bottom < LastLine - 1 THEN  ' At bottom and got room?
                        OldLin = me.sSearch(MarkRect.Bottom)      ' Get where current bottom is
                        MarkRect.Bottom = me.CRPFwd(%MVisData, MarkRect.Bottom, 1)  ' Move bottom boundary
                        NewLin = me.sSearch(MarkRect.Bottom)      ' Get where new bottom is
                        OldLin = NewLin - OldLin                  ' OldLin = # screen lines we went down
                        IF OldLin < 0 THEN OldLin = 1             ' Adjust if off the bottom and scrolling
                        GOSUB DoDraw                              ' Draw, move cursor and exit
                     ELSE                                         '
                        CALL DWORD Pass: MExitMeth                ' Just move the cursor
                     END IF                                       '

                  '--------------------------------------------------------------------------------+
                  '- Move boundary to End of text                                                  |
                  '--------------------------------------------------------------------------------+
                  CASE "E"                                        ' End
                     MarkRect.Right = LEN(RTRIM$(LTxtG(@P.C.CIX)))   ' Move right to text length column
                     me.MarkScr                                   ' Redraw the hilight
                     CALL DWORD Pass: MExitMeth                   ' Then just move the cursor

               END SELECT                                         '
            END IF                                                '

         CASE ELSE                                                '
            CALL DWORD Pass: DoBeep: MExitMeth                    ' Not in Data. Skip
      END SELECT                                                  '
      MExitMeth                                                   '

   KillOrMove:                                                    '
      '--------------------------------------------------------------------------------------------+
      '- Kill mark if outside current boundaries                                                   |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CLCol < MiscRect.Left OR @P.C.CLCol > MiscRect.Right THEN _  ' Outside it's boundaries?
         me.MarkKill: MExitMeth                                   ' Kill it and leave cursor alone

      '--------------------------------------------------------------------------------------------+
      '- If within current bounds, just move the cursor                                            |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CLCol > MiscRect.Left AND @P.C.CLCol < MiscRect.Right THEN _ ' Within the bounds?
         CALL DWORD Pass: MExitMeth                               ' Just move the cursor

      RETURN                                                      '

   AdjMiscCol:                                                    '
      IF ColAdj < 0 AND MiscRect.Left > 1 THEN                    ' At left and got room
         MiscRect.Left = MiscRect.Left + ColAdj                   ' Move left boundary
      ELSEIF ColAdj > 0 AND @P.C.CLCol = MiscRect.Left AND MiscRect.Left <> MiscRect.Right THEN ' At left edge and going right
         MiscRect.Left = MiscRect.Left + ColAdj                   ' Move left boundary
      ELSEIF ColAdj > 0 THEN                                      ' Going right
         MiscRect.Right = MiscRect.Right + ColAdj                 ' Move right boundary
      ELSE                                                        '
         DoBeep                                                   '
      END IF                                                      '
      me.MiscMark: CALL DWORD Pass: MExitMeth                     ' Redraw the hilight and we're done
      RETURN                                                      '


   DoDraw:                                                        '
      me.MarkScr                                                  ' Redraw the hilight
      DO WHILE OldLin > 0                                         ' Adjust the cursor correctly
         CALL DWORD Pass                                          ' Then just move the cursor
         DECR OldLin                                              '
      LOOP                                                        '
      MExitMeth                                                   '
      RETURN                                                      '

   MiscLeft:                                                      '
      IF @P.C.CLCol = MiscRect.Left AND MiscRect.Left = MiscRect.Right THEN   ' Sitting on one char field?
         MiscRect.Left = MAX(1, MiscRect.Left - 1)                ' Adjust left end
      ELSEIF @P.C.CLCol = MiscRect.Left THEN                      ' Sitting on left end of string
         MiscRect.Left = MAX(1, MiscRect.Left - 1)                ' Adjust left end
      ELSE                                                        ' Must be on Right Boundary
         MiscRect.Right = MAX(MiscRect.Left, MiscRect.Right - 1)  ' Adjust left end
      END IF                                                      '
      me.MiscMark: CALL DWORD Pass: MExitMeth                     ' Redraw the hilight and we're done
      RETURN                                                      '

   MiscRight:                                                     '
      IF @P.C.CLCol = MiscRect.Left AND MiscRect.Left = MiscRect.Right THEN   ' Sitting on a one char field?
         MiscRect.Right = MiscRect.Right + 1                      ' Adjust right end
      ELSEIF @P.C.CLCol = MiscRect.Left THEN                      ' Sitting on Left boundary
         MiscRect.Left = MIN(MiscRect.Right, MiscRect.Left + 1)   ' Adjust left end
      ELSE                                                        ' Must be on Right Boundary
         MiscRect.Right = MiscRect.Right + 1                      ' Adjust right end
      END IF                                                      '
      me.MiscMark: CALL DWORD Pass: MExitMeth                     ' Redraw the hilight and we're done
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  krNewLine(OPTIONAL ns AS LONG)                         '
   '-----------------------------------------------------------------------------------------------+
   '- Next line on screen                                                                          |
   '-----------------------------------------------------------------------------------------------+
   LOCAL noscroll AS LONG                                         '
      MEntry                                                      '
      noscroll = IIF(ISMISSING(ns), %False, ns)                   ' Pick up No Scroll flag
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Top of screen area                                                                        |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CRow < @P.PData1 THEN                               ' Command line, line 2 or COLS line
         me.CsrRow = @P.PData1: me.CsrCol = @P.PLeft: MExitMeth   ' Go to 1st data line
      END IF                                                      ' Else in data area

      '--------------------------------------------------------------------------------------------+
      '- If not in text data area, go to Command line                                              |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CIX = 0 THEN                                        ' Not in data area?
         SetCmd                                                   ' Cursor to the command line
         MExitMeth                                                '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If in Text data area go to next line                                                      |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' If Hex extra line, get real line
      me.CsrRowAdd(1)                                             ' Simple INCR
      IF @P.C.CRow > TP.gPBottom OR IsLBottom(@P.C.CIX) THEN      ' At bottom line yet?
         IF @P.C.CIX = 0 OR IsLBottom(@P.C.CIX) OR ISTRUE noscroll THEN ' Not in data area or noscroll requested?
            SetCmd                                                ' Cursor to the command line
            MExitMeth                                             '
         END IF                                                   '
         @P.C.CIX = me.CRPFwd(%mVisible, @P.C.CIX, 1)             ' Move to next visible line
         me.CurSetReq(%Position, @P.C.CIX, 0, %True)              ' Set cursor set attempt
         @P.PTopLine = me.CRPFwd(%mVisible, @P.PTopLine, 1)       ' Move TopScrn by scroll amount
         OnInsClnSupp                                             ' Suppress Insert cleanup for 1 Attn pass
         DoSet(%Refresh)                                          ' Have it looked at
      ELSE                                                        '
         me.CsrCol = @P.PLeft                                     '
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krPA2()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Do a PA2 Attention                                                                           |
   '-----------------------------------------------------------------------------------------------+
      me.DoPA2Load                                                ' Reload stuff
      DoSet(%Attention)                                           ' Have it looked at
   END METHOD                                                     '

   METHOD  krPanelH()                                             '
   LOCAL u AS STRING, SP, i, j AS LONG                            '
   '-----------------------------------------------------------------------------------------------+
   '- Do a horizontal PANEL start / resize / close                                                 |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      VPanelSplit = 0: VPanelSize = 0                             ' Kill any alternate Split
      SP = @P.C.CRow                                              ' What row are we on
      IF SP < 6 THEN                                              ' Reasonable?
         TP.ErrMsgAdd(%eNone, "Split point invalid, default value used")  '
         SP = 0.6 * (gENV.ScrHeight - gENV.PFKShow)               ' Set the default
      ELSEIF (gENV.ScrHeight - gENV.PFKShow - SP) < 6 THEN        '
         TP.ErrMsgAdd(%eNone, "Split point invalid, default value used")  '
         SP = 0.4 * (gENV.ScrHeight - gENV.PFKShow)               ' Set the default
      END IF                                                      '
      IF HPanelSplit = 0 THEN                                     ' Is there a current split
         '-----------------------------------------------------------------------------------------+
         '- Setup the requested split point                                                        |
         '-----------------------------------------------------------------------------------------+
         HPanelSplit = SP                                         ' Set split point
         HPanelSize = gENV.ScrHeight - gENV.PFKShow               ' Save Height at this point
         P = VARPTR(P1)                                           ' Point at default P1
         PPActive       = VARPTR(P1)                              ' Set P1 pointer
         me.PanelSet(1, 1, SP - 1, 1, gEnv.ScrWidth, "H", %True) ' Setup P1
         P1.PTopLine    = P1.PTopLine                             ' Keep P1.PTopLine
         P1.C.CRow      = 1                                       ' P2 to command line
         P1.C.CCol      = P1.PCmdCol                              '

         me.PanelSet(2, SP + 1, gENV.ScrHeight - gENV.PFKShow, 1, gEnv.ScrWidth, "H", %True) ' Setup P2
         P2.PTopLine    = P1.PTopLine                             ' Copy P1.PTopLine
         P2.C.CRow      = P2.PTop                                 ' P2 to command line
         P2.C.CCol      = P2.PCmdCol                              '
         DoSet(%Refresh)                                          ' Have it looked at
         me.CsrMode                                               ' Refresh mode

      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '- Already in split mode, see what to do                                                  |
         '-----------------------------------------------------------------------------------------+
         HPanelSplit  = SP                                        ' Set split point
         HPanelSize = gENV.ScrHeight - gENV.PFKShow               ' Save Height at this point
         me.PanelSet(1, 1, SP - 1, 1, gEnv.ScrWidth, "H", %True) ' Setup P1

         me.PanelSet(2, SP + 1, gENV.ScrHeight - gENV.PFKShow, 1, gEnv.ScrWidth, "H",%True) ' Setup P2
         P2.C.CRow    = P2.PTop                                   ' P2 to command line
         P2.C.CCol    = P2.PCmdCol                                '
         DoSet(%Refresh)                                          ' Have it looked at
         me.CsrMode                                               ' Refresh mode
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krPanelOff()                                           '
   LOCAL u AS STRING
   '-----------------------------------------------------------------------------------------------+
   '- Kill PANEL Mode                                                                              |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      IF VPanelSplit = 0 AND HPanelSplit = 0 THEN MExitMeth       ' If no current split, just exit
      VPanelSplit = 0: VPanelSize = 0                             ' ReSet split point
      HPanelSplit = 0: HPanelSize = 0                             '
      P = VARPTR(P1): PPActive = P                                ' Point at default P1
      me.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, gEnv.ScrWidth, "N", %True) ' Setup P1
      P1.C.CRow = P1.PTop: P1.C.CCol = P1.PCmdCol                 ' Csr to command line
      DoSet(%Refresh)                                             ' Have it looked at
      me.CsrMode                                                  ' Refresh mode
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krPanelSwap()                                          '
   LOCAL u AS STRING                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Do a PANEL Swap                                                                              |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      IF (HPanelSplit OR VPanelSplit) = 0 THEN _                  ' Is there a current split
         MErrExit(%eFail, "Panel Mode is not active")             ' Oops
      IF PPActive = VARPTR(P1) THEN                               ' P1 active?
         me.PPSetP2                                               '
      ELSE                                                        ' Else
         me.PPSetP1                                               '
      END IF                                                      '
      DoCursor                                                    '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krPanelV()                                             '
   LOCAL u AS STRING, SP, i, j AS LONG                            '
   '-----------------------------------------------------------------------------------------------+
   '- Do a vertical PANEL start / resize / close                                                   |
   '-----------------------------------------------------------------------------------------------+
      MEntry                                                      '
      HPanelSplit = 0: HPanelSize = 0                             ' Kill any alternate Split
      SP = @P.C.CCol                                              ' What col are we on
      IF sp < 30 THEN                                             ' Reasonable?
         TP.ErrMsgAdd(%eNone, "Split point invalid, default value used")  '
         SP = 0.6 * gENV.ScrWidth                                 ' Set the default
      ELSEIF gENV.ScrWidth - SP < 30 THEN                         '
         TP.ErrMsgAdd(%eNone, "Split point invalid, default value used")  '
         SP = 0.4 * gENV.ScrWidth                                 ' Set the default
      END IF                                                      '
      IF VPanelSplit = 0 THEN                                     ' Is there a current split

         '-----------------------------------------------------------------------------------------+
         '- Setup the requested split point                                                        |
         '-----------------------------------------------------------------------------------------+
         VPanelSplit = SP                                         ' Set split point
         VPanelSize = gEnv.ScrWidth                               ' Save Width at this point
         P = VARPTR(P1)                                           ' Point at default P1
         PPActive       = VARPTR(P1)                              ' Set P1 pointer
         me.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, SP - 1, "V", %True)    ' Setup P1
         P1.PTopLine    = P1.PTopLine                             ' Keep P1.PTopLine
         P1.C.CRow      = P1.PTop                                 ' Start in command line
         P1.C.CCol      = P1.PCmdCol                              '

         me.PanelSet(2, 1, gENV.ScrHeight - gENV.PFKShow, SP + 1, gEnv.ScrWidth, "V", %True)    ' Setup P2
         P2.PTopLine    = P1.PTopLine                             ' Copy P1.PTopLine
         P2.C.CRow      = P2.PTop                                 ' P2 to command line
         P2.C.CCol      = P2.PCmdCol                              '
         DoSet(%Refresh)                                          ' Have it looked at
         me.CsrMode                                               ' Refresh mode

      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '- Already in split mode, see what to do                                                  |
         '-----------------------------------------------------------------------------------------+
         VPanelSplit  = SP                                        ' Set split point
         VPanelSize = gEnv.ScrWidth                               ' Save Width at this point
         me.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, SP - 1, "V", %True) ' Setup P1

         me.PanelSet(2, 1, gENV.ScrHeight - gENV.PFKShow, SP + 1, gEnv.ScrWidth, "V", %True) ' Setup P1
         DoSet(%Refresh)                                          ' Have it looked at
         me.CsrMode                                               ' Refresh mode
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krPaste()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Paste text at cursor location                                                                |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j AS LONG                                             '
   LOCAL ln, t, tt, MyDLM AS STRING, tc AS WSTRING                '

      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Get the Clipboard text                                                                    |
      '--------------------------------------------------------------------------------------------+
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      ClipboardRead(t, MyDLM, %False)                             ' Go get Clipboard, keep the file
      IF LEN(t) < 1 THEN DoBeep: MExitMeth                        ' Error if nothing there
      me.AttrInvClearFind                                         ' Clear any Find HiLite

      IF RIGHT$(t, LEN(MyDLM)) = MyDlm THEN t = LEFT$(t, LEN(t) - LEN(MyDlm)) ' Remove trailing MyDlm to get PARSECOUNT accurate
      IF PARSECOUNT(t, MyDlm) > 1 AND ISTRUE IsCData THEN         ' Potential BlockPaste?
         me.krBPaste                                              ' Yes, pass it off
         MExitMeth                                                ' Done here
      END IF                                                      '

      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Get first line                                                                            |
      '--------------------------------------------------------------------------------------------+
      ln = EXTRACT$(t, MyDLM)                                     ' Get 1st line from Clipboard
      me.MarkKill                                                 ' Kill any active block select
      me.SwapKill                                                 '

      '--------------------------------------------------------------------------------------------+
      '- Paste into Command line                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF IsCCmnd THEN                                             ' In the Command area?
         tt = pCommand                                            ' Get working copy
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            i = @P.C.CLCol + LEN(ln)                              ' Calc new end point
            IF i > LEN(tt) THEN tt += SPACE$(i - LEN(tt))         ' Lengthen if needed
            MID$(tt, @P.C.CLCol, LEN(ln)) = ln                    ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            tt = LEFT$(tt, @P.C.CLCol - 1) + ln + MID$(tt, @P.C.CLCol)  '
         END IF                                                   '
         PCommand = tt                                            ' Copy back
         i = @P.C.CLCol + LEN(ln)                                 ' Move cursor
         IF i > @P.PCmdLen + @P.PCOffset THEN                     ' Is it to the right of the Window?
            @P.PCOffset = i - (@P.PCmdLen / 2)                    ' Adjust offset
         ELSEIF i < @P.PCOffset THEN                              ' Is it to the left of the Window?
            @P.PCOffset = MAX(0, i - (@P.PCmdLen / 2))            ' Adjust offset
         END IF                                                   '
         me.WindowCmd                                             ' Print the whole string again
         me.CsrCol = @P.PCmdCol + i - @P.PCOffset - 1             ' Move cursor

      '--------------------------------------------------------------------------------------------+
      '- Paste into Scroll Amt (Weird but ...)                                                     |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCScrl THEN                                         ' Scroll area?
         tt = FCB.ScrollAmt                                       ' Get working copy
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            tt = LEFT$(LEFT$(tt, @P.C.CLCol - 1) + ln + MID$(tt, @P.C.CLCol + LEN(ln)) + "    ", 4)   '
         ELSE                                                     ' Do the Insert method
            tt = LEFT$(LEFT$(tt, @P.C.CLCol - 1) + ln + MID$(tt, @P.C.CLCol) + "    ", 4) '
         END IF                                                   '
         FCB.ScrollAmt = tt                                       ' Copy back
         DoPrint (tt, $$TxtLo, @P.PTop, @P.PScrData)              ' Print the whole string again

      '--------------------------------------------------------------------------------------------+
      '- Paste into Line Number area                                                               |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCLinN THEN                                         ' Line Number area?
         IF @P.C.CIX = 0 THEN DoBeep: MExitMeth                   ' Below last line? Bail out
         IF me.IsTouchable(@P.C.CIX) THEN                         ' If 1st interaction in the line number area
            me.LFlagBitOff(@P.C.CIX, %EQChange)                   ' Reset ==CHG>
            LLCtlS(@P.C.CIX) = $BlankLNo: @P.C.CCol = @P.PLeft    ' Blank the Line number
            DoPrint (BYCOPY LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft) ' ReDisplay it
         END IF                                                   '

         LLCtlS(@P.C.CIX) = LEFT$(ln, 8)                          ' Overlay the data into the LineNum string
         me.TTblAdd(@P.C.CIX, TRIM$(LLCtlG(@P.C.CIX)))            ' Update touched items
         DoPrint (LEFT$(LLCtlG(@P.C.CIX), gENV.LinNoSize), $$LnoHi, @P.C.CRow, @P.PLeft)  ' Print the whole string again
         me.CsrCol = @P.PLeft                                     ' Move cursor

      '--------------------------------------------------------------------------------------------+
      '- Paste into the Text data area                                                             |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCData THEN                                         ' In the Data Area?
         IF IsBrowse THEN DoBeep: MExitMeth                       ' Not allowed in Browse mode
         IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Convert to real line index
         IF @P.C.CIX <= 0 THEN DoBeep: MExitMeth                  ' Bail out if below last line or a Hex Line
         IF ISTRUE (LFlagG(@P.C.CIX) AND %NonTypable) THEN        ' Ignore non-typable lines
            DoBeep: MExitMeth                                     '
         END IF                                                   '
         me.ModSet(@P.C.CIX)                                      ' Remember we changed something
         tt = LTxtG(@P.C.CIX)                                     ' Get working copy of text
         tc = LAttrG(@P.C.CIX)                                    ' and it's color line

         '-----------------------------------------------------------------------------------------+
         '- Do it either Insert or non-Insert way                                                  |
         '-----------------------------------------------------------------------------------------+
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF @P.C.CLCol + LEN(ln) - 1 > LEN(tt) THEN            ' If line not long enough
               tt = LSET$(tt , @P.C.CLCol + LEN(ln) - 1)          ' Lengthen if needed
               tc = LSET$(tc , LEN(tt) USING CHR$$(0))            ' Lengthen Attr as well
            END IF                                                '
            MID$(tt, @P.C.CLCol, LEN(ln)) = ln                    ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            me.DataInsert(tt, tc, ln, @P.C.CLCol)                 ' Insert the data
         END IF                                                   '

         IF FCB.ImportTabs > 0 THEN                               ' Need TAB expansion?
            tt = TAB$(tt, FCB.ImportTabs)                         ' Do any needed tab conversion
         END IF                                                   '
         me.LTxtSet(@P.C.CIX, tt)                                 ' Save it back
         me.UCIfNeeded(@P.C.CIX)                                  ' UC if CAPS ON
         me.LAttrSet(@P.C.CIX, tc)                                '
         me.AttrScan(@P.C.CIX)                                    ' Recolorize

         '-----------------------------------------------------------------------------------------+
         '- Print it, do extra of course if Hex mode                                               |
         '-----------------------------------------------------------------------------------------+
         me.DispLine(@P.C.CIX, @P.C.CRow)                         ' Re-display the line
         IF FCB.HexMode <> &1 THEN                                ' If hex mode
            IF @P.C.CRow + 1 <= TP.gPBottom THEN                  ' Make sure we don't go off the bottom
               DoPrint (me.WindowHexTop(tt), $$TxtLo, @P.C.CRow + 1, @P.PDataCol)   ' Print upper hex
            me.MarkReDraw(@P.C.CRow + 1)                          ' Re-draw the MARK lines
            END IF                                                '
            IF @P.C.CRow + 2 <= TP.gPBottom THEN                  ' Make sure we don't go off the bottom
               DoPrint (me.WindowHexBottom(tt), $$TxtLo, @P.C.CRow + 2, @P.PDataCol)   ' Print lower hex
               me.MarkReDraw(@P.C.CRow + 2)                       ' Re-draw the MARK lines
            END IF                                                '
         END IF                                                   '

         @P.C.CLCol += LEN(ln)                                    ' Move cursor
         IF @P.C.CIX > @P.POffset + @P.PDataLen - 1 THEN          ' Off current screen?
            me.CurSetReq(%Position, @P.C.CIX, @P.C.CLCol, %True)  ' No, Set cursor set attempt
            DoSet(%Refresh)                                       ' Have it looked at
         ELSE                                                     '
            me.CsrCol = @P.C.CLCol - @P.POffset + @P.PGapCol      '
         END IF                                                   '

      ELSE                                                        ' Anything else (CursBad)
         DoBeep                                                   ' Beep it
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krPenBlue()                                            '
      gkeyPrimOper = "BLUE"                                       '
      me.krPenCommon                                              '
   END METHOD                                                     '

   METHOD  krPenGreen()                                           '
      gkeyPrimOper = "GREEN"                                      '
      me.krPenCommon                                              '
   END METHOD                                                     '

   METHOD  krPenRed()                                             '
      gkeyPrimOper = "RED"                                        '
      me.krPenCommon                                              '
   END METHOD                                                     '

   METHOD  krPenYellow()                                          '
      gkeyPrimOper = "YELLOW"                                     '
      me.krPenCommon                                              '
   END METHOD                                                     '

   METHOD  krPenStd()                                             '
      gkeyPrimOper = "STD"                                        '
      me.krPenCommon                                              '
   END METHOD                                                     '

   METHOD  krPenCommon()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- Set Pen color for a hi-lite block                                                            |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x, i, clr AS LONG, a, clrname AS STRING                  '
      IF ISFALSE IsMarkActive THEN DoBeep: EXIT METHOD            ' Better be something selected, else exit
      clrname = uucase(IIF$(gKeyPrimOper = "", "STD", gKeyPrimOper)) ' Get the requested color
      IF clrname = "STD" THEN                                     ' If STD, set scheme 0
         clr = 0                                                  '
      ELSE                                                        ' else look it up
         ARRAY SCAN gHiLites(), = clrname, TO clr                 ' See if a HiLite Name
      END IF                                                      '
      me.MarkKill                                                 ' Reset the select frame

      '--------------------------------------------------------------------------------------------+
      '- OK, process the lines                                                                     |
      '--------------------------------------------------------------------------------------------+
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISFALSE (LFlagG(x) AND %NonTypable) THEN              ' Just typable lines
            IF MarkRect.Left > LAttrGLen(x) THEN ITERATE FOR      ' If past end of line, do nothing
            i = MIN(MarkRect.Right, LEN(L(x).@LTxt))              ' Setup end of mark section
            me.AttrHiLiteSet(x, MarkRect.Left, i, clr)            ' Set in the requested color
         END IF                                                   '
      NEXT x                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  krRecord()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Start/Stop Keyboard recording                                                                |
   '-----------------------------------------------------------------------------------------------+
      IF ISTRUE gKbdRecFlag THEN                                  ' If ON, then turn off
         gKbdRecFlag = %False                                     ' Else, turn on the flag
         gKbdRecording = LEFT$(gKbdRecording, INSTR(-1, gKbdRecording, "(") - 1) ' Remove the (Record) OFF command
         IF ISNOTNULL(TRIM$(gKbdRecording)) THEN                  ' See if we recorded anything
            ClipBoardWrite(gKbdRecording)                         ' Stuff it into Clipboard
            TP.ErrMsgAdd(%eNone, "KB Recording saved to the " + gKeyPrimOper + " Clipboard") ' Say we've done so
            DoSet(%Attention)                                     ' Get it issued
         END IF                                                   '
      ELSE                                                        ' else turn it on
         gKbdRecording = ""                                       ' Start string as null
         gKbdRecFlag = %True                                      ' Turn on the flag
      END IF                                                      '
      DoStatusBar($SBMisc)                                        ' re-Do the StatusBar Misc box
   END METHOD                                                     '

   METHOD  krResetCmd()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Reset Line Commands                                                                          |
   '-----------------------------------------------------------------------------------------------+
   REGISTER i AS LONG                                             '
      RESET gLTblAIX, gLTblBIX                                    ' Reset LLCtl table indexes
      me.TTblReset                                                ' Reset the touched table
      FOR i = 1 TO LastLine                                       ' Process each line in the marked area
         '-----------------------------------------------------------------------------------------+
         '- Clear line commands                                                                    |
         '-----------------------------------------------------------------------------------------+
         LLCtlS(i) = LLNumG(i)                                    ' Set the line number in
         me.UpdLControl(i)                                        ' Redo the LLCtl
      NEXT i                                                      '
      TCtr = 0                                                    '
   END METHOD                                                     '

   METHOD  krSetOVR()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Reset Insert mode to the default                                                             |
   '-----------------------------------------------------------------------------------------------+
      IF IsNsrtFlag THEN OnNsrtSave  ELSE OffNsrtSave             ' Save it
      IF IsNsrtData THEN OnNsrtSaveD ELSE OffNsrtSaveD            ' Save it
      OffNsrtFlag                                                 ' Set Insert OFF
      OffNsrtData                                                 ' Set DataInsert OFF
      FCB.TabBNDS = %False                                        ' Reset TabBNDS
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar INS/OVR box
   END METHOD                                                     '

   METHOD  krSpellChk()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Spell check the word under the cursor                                                        |
   '-----------------------------------------------------------------------------------------------+
   LOCAL RCA AS RCUser, Sugg() AS STRING                          '
   DIM Pop(1 TO 1) AS STRING                                      '
   LOCAL hpopup, i, l, RC, cx, cy, maxpop, tx, SaveCheck, fline  AS LONG, t, sOptions, sCmds AS STRING   '
   LOCAL wpos AS RECT, lclSpell AS LONG                           '
      MEntry                                                      '
      me.CursorWord(%True)                                        ' Get the current word, add $SQ to list
      IF me.CursCol = 0 THEN DoBeep: MExitMeth                    ' None? Bail out
      IF ISNULL(gEnv.LANG) THEN MErrExit(%eFail," SPELL impossible. Options => General has no LANG specification")   '
      lclSpell = IIF(SpellClr <> 0, SpellClr, 3)                  ' Get hilite color
      SpellCheck(CursWord, Sugg(), RCA)                           ' Check the word for spelling
      SELECT CASE RCA.RC                                          ' How'd it do
         CASE 0                                                   ' OK
            MErrExit(4, $DQ + CursWord + $DQ + " is spelled correctly") ' Say it's OK

         CASE 1                                                   ' Wrong, with suggestions
            '---------------------------------------------------------------------------------------+
                                                                  ' OK now try and display the Popup                                                      |
            '---------------------------------------------------------------------------------------+
            fline = 0                                             ' Get the Screen line
            FOR l = 0 TO 300                                      '
               IF @P.PS(l) = curslnum THEN fline = l: EXIT FOR    '
            NEXT l                                                '
            me.AttrHiLiteSet(curslnum, curscol, curscol + LEN(CursWord) - 1, lclSpell) ' Set the hilite
            IF fline <> 0 AND fline <= TP.gPBottom THEN me.DispLine(curslnum, fline)   ' Re-display the line with the hi-light
            cx = ((CursColE - @P.POffset + @P.PDataCol) * gFontWidth) + %GLM: cy = @P.C.CRow * gFontHeight  ' Where we are in our window
            SaveCheck = gLoopCheck: gLoopCheck = %False           ' Stop loop check

            REDIM Pop(1 TO UBOUND(Sugg()) + 7)                    ' DIM the POP table
            POP(1) = "91.<< Ignore this occurrence of " + $DQ + CursWord + $DQ + " >>" '
            POP(2) = "92.<< Ignore all " + $DQ + CursWord + $DQ + " for this session >>"  '
            Pop(3) = "93.<< Add " + $DQ + CursWord + $DQ + " to User Dictionary >>" '
            Pop(4) = "0. "                                        '
            Pop(5) = "94.Or replace with one of the following:"   '
            Pop(6) = "0. "                                        '
            IF RCA.RC = 1 THEN                                    ' Got suggestions?
               FOR i = 0 TO UBOUND(Sugg())                        ' Add the suggestions
                  POP(i + 7) = FORMAT$(i + 1) + "." + Sugg(i)     '
               NEXT                                               '
            END IF                                                '
            RC = DoPopUp(Pop(), cx, cy)                           ' Display and get user's choice
            gLoopCheck = SaveCheck                                ' Restore loop check
            SELECT CASE RC                                        ' Handle the RC answer
               CASE 91, 94, 0                                     ' Ignore
                  me.AttrHiLiteClear(curslnum, curscol, curscol + LEN(CursWord) - 1, lclSpell)  '
                  IF fline <> 0 AND fline <= TP.gPBottom THEN me.DispLine(curslnum, fline)   ' Re-display the line with the hi-light
               CASE 92                                            ' Add to Temp ignore?
                  me.AttrHiLiteClear(curslnum, curscol, curscol + LEN(CursWord) - 1, lclSpell)  '
                  IF fline <> 0 AND fline <= TP.gPBottom THEN me.DispLine(curslnum, fline)   ' Re-display the line with the hi-light
                  RCA.RC = 122                                    ' Set 'magic' RC to indicate temp add
                  SpellCheck(CursWord, Sugg(), RCA)               ' Add the word to Hunspell in-memory
                  t = "CHANGE ALL WORD +STD T`" + cursword + "` T`" + cursword + "` !" + FORMAT$(curslnum) + " .ZLast"  '
                  FCB.HiFindSupp = %True: pCmdChange(t): FCB.HiFindSupp = %False ' Try it
                  me.CurSetReq(%Position, curslnum, curscol, %True)  ' Set cursor set attempt
                  me.DispScreen                                   ' Re-display the screen
               CASE 93                                            ' Add to User Dictionary?
                  me.AttrHiLiteClear(curslnum, curscol, curscol + LEN(CursWord) - 1, lclSpell)  '
                  IF fline <> 0 AND fline <= TP.gPBottom THEN me.DispLine(curslnum, fline)   ' Re-display the line with the hi-light
                  RCA.RC = 123                                    ' Set 'magic' RC to indicate an Add
                  SpellCheck(CursWord, Sugg(), RCA)               ' Add the word to USER.DIC + Hunspell in-memory
                  t = "CHANGE ALL WORD +STD T`" + cursword + "` T`" + cursword + "` !" + FORMAT$(curslnum) + " .ZLast"  '
                  FCB.HiFindSupp = %True: pCmdChange(t): FCB.HiFindSupp = %False ' Try it
                  me.CurSetReq(%Position, curslnum, curscol, %True)  ' Set cursor set attempt
                  me.DispScreen                                   ' Re-display the screen
               CASE ELSE                                          ' Add to User Dic
                  t = "CHANGE ALL WORD +STD T`" + cursword + "` T`" + Sugg(RC - 1) + "` !" + FORMAT$(curslnum) + " .ZLast" '
                  FCB.HiFindSupp = %True: pCmdChange(t): FCB.HiFindSupp = %False ' Try it
                  me.CurSetReq(%Position, curslnum, curscol, %True)  ' Set cursor set attempt
                  me.DispScreen                                   ' Re-display the screen
            END SELECT                                            '
            MExitMeth                                             '
         CASE 2                                                   '
            MErrExit(4, $DQ + CursWord + $DQ + " is spelled incorrectly, no suggestions") ' Say it's not OK

      END SELECT                                                  '
      MExitMeth                                                   '
                                                                  '
   END METHOD                                                     '

   METHOD  krRestoreCursor()                                      '
   '-----------------------------------------------------------------------------------------------+
   '- Restore Cursor location                                                                      |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i AS LONG                                                '
      IF SavCurLin = 0 THEN                                       ' No line number?
         SetCmd                                                   ' Cursor to the command line
      ELSE                                                        '
         i = me.sSearch(SavCurLin)                                ' See if location is on screen
         IF i < 0 THEN                                            ' Not on screen
            SetCmd                                                ' Cursor to the command line
         ELSE                                                     '
            me.CsrRow = i                                         ' Put cursor back
            me.CsrCol = IIF(SavCurCol = 0, @P.PLeft, SavCurCol + @P.PGapCol - @P.POffSet) '
         END IF                                                   '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krRestoreInsert()                                      '
   '-----------------------------------------------------------------------------------------------+
   '- Restore Insert mode                                                                          |
   '-----------------------------------------------------------------------------------------------+
      IF IsNsrtSave  THEN OnNsrtFlag ELSE OffNsrtFlag             ' Restore it
      IF IsNsrtSaveD THEN OnNsrtData ELSE OffNsrtData             ' Restore it
      IF IsNSrtData THEN OnNsrtFlag                               ' If Data, then always INS as well
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar INS/OVR box
   END METHOD                                                     '

   METHOD  krRight()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Increment Column                                                                             |
   '-----------------------------------------------------------------------------------------------+
   LOCAL cIncr, Hexrow AS LONG                                    '
      MEntry                                                      '
      cIncr = IIF(VAL(gKeyPrimOper) > 0, VAL(gKeyPrimOper), 1)    ' Set the INCR amount?
      '--------------------------------------------------------------------------------------------+
      '- If no auto scrolling                                                                      |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE gENV.KBHorScroll THEN                            ' No KeybScroll
         me.CsrColAdd(cIncr)                                      ' Move the cursor
         IF @P.C.CCol > @P.PRight THEN                            ' Column wrap?
            me.CsrCol = @P.PLeft: me.CsrRowAdd(1)                 ' Yes, adjust for it
            IF @P.C.CRow > @P.PBottom THEN me.CsrRow = @P.PTop    ' also for Row wrap if needed
         END IF                                                   '

      ELSE                                                        ' Scrolling is allowed
         '-----------------------------------------------------------------------------------------+
         '- Auto Scrolling is active                                                               |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CRow = @P.PTop THEN                              ' In the command area
            IF @P.C.CCol < @P.PDataCol OR @P.C.CCol > @P.PScrHdr - 1 THEN ' Not in the Command itself?
               IF @P.C.CCol < @P.PRight + cIncr THEN me.CsrColAdd(cIncr)   ' Just move right if room
            ELSE                                                  ' Within the command
               IF @P.C.CCol < @P.PScrHdr - 2 THEN                 ' Able to move cursor right?
                  IF @P.C.CCol + cIncr < @P.PScrHdr - 1 THEN me.CsrColAdd(cIncr)   ' Just move right if room
               ELSE                                               ' Do the scroll
                   @P.PCOffset = @P.PCOffSet + 1                  ' Adjust the offset
                   me.WindowCmd                                   ' Re-do the command line
               END IF                                             '
            END IF                                                '

         ELSEIF @P.C.CRow < @P.PData1 THEN                        ' Message or COLS?
            IF @P.C.CCol + cIncr <= @P.PRight THEN me.CsrColAdd(cIncr)  ' Just move right if room

         ELSE                                                     ' In the Data lines
            IF @P.C.CCol < @P.PDataCol THEN                       ' Line number area?
               me.CsrColAdd(cIncr)                                ' Just move right if room
            ELSE                                                  ' True data area
               IF @P.C.CCol = @P.PRight THEN                      ' Able to move cursor right?
                  INCR @P.POffset                                 ' No, adjust Offset
                  me.CsrMode                                      ' Refresh Csr data
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               '
                  IF @P.C.CCol + cIncr <= @P.PRight THEN me.CsrColAdd(cIncr)  ' Just move right if room
               END IF                                             '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krSaveCursor()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Save Cursor location                                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j AS LONG                                                '
      SELECT CASE @P.C.CRow                                       ' Do tabbing based on where we are

         '-----------------------------------------------------------------------------------------+
         '- Sitting in header area                                                                 |
         '-----------------------------------------------------------------------------------------+
         CASE < @P.PData1                                         ' Top Rows?
            SavCurCol = @P.PCmdCol                                ' Set for Command area
            SavCurLin = 0                                         '

         '-----------------------------------------------------------------------------------------+
         '- Sitting in text area                                                                   |
         '-----------------------------------------------------------------------------------------+
         CASE ELSE                                                ' In data area
            IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Get real data line
            IF @P.C.CIX = 0 THEN                                  ' Not a real text line?
               SavCurCol = @P.PCmdCol                             ' Set for Command area
               SavCurLin = 0                                      '
            ELSE                                                  '
               SavCurLin = @P.C.CIX                               ' Save line number
               SavCurCol = IIF(@P.C.CCol < @P.PDataCol, 0, @P.C.CCol - @P.PGapCol + @P.POffset) ' Save column
            END IF                                                '
      END SELECT                                                  '
   END METHOD                                                     '

   METHOD  krScrollD                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Scroll Down                                                                                  |
   '-----------------------------------------------------------------------------------------------+
      pCommand = "ISCROLL DOWN 1 K"                               ' Create internal command
      DoSet(%Attention)                                           ' Have it looked at
   END METHOD                                                     '

   METHOD  krScrollL                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Scroll Left                                                                                  |
   '-----------------------------------------------------------------------------------------------+
      pCommand = "ISCROLL LEFT 1 K"                               ' Create internal command
      DoSet(%Attention)                                           ' Have it looked at
   END METHOD                                                     '

   METHOD  krScrollR                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Scroll Right                                                                                 |
   '-----------------------------------------------------------------------------------------------+
      pCommand = "ISCROLL RIGHT 1 K"                              ' Create internal command
      DoSet(%Attention)                                           ' Have it looked at
   END METHOD                                                     '

   METHOD  krScrollU                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Scroll Up                                                                                    |
   '-----------------------------------------------------------------------------------------------+
      pCommand = "ISCROLL UP 1 K"                                 ' Create internal command
      DoSet(%Attention)                                           ' Have it looked at
   END METHOD                                                     '

   METHOD  krSentenceCase()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Sentence case a block                                                                        |
   '-----------------------------------------------------------------------------------------------+
   DIM words() AS STRING                                          '
   LOCAL Txt1, txt2 AS STRING                                     '
   LOCAL i, j, k, m, x, Caps AS LONG                              '

      MEntry                                                      '
      Caps = %True                                                ' 1st word overall gets capitalized
      me.AttrInvClearFind                                         ' Clear any Find HiLite

      '--------------------------------------------------------------------------------------------+
      '- Set the cursor and do the actual casing                                                   |
      '--------------------------------------------------------------------------------------------+
      me.CurSetReq(%Low, MarkRect.Bottom, 1 + MarkRect.Right + 1, %True)   ' Set cursor set attempt
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop for each line
         IF IsLData(x) OR ISTRUE IsLNote(x) THEN                  ' Only Data/note lines
            me.ModSet(x)                                          ' Remember we changed something
            Txt1 = LLCASE(MID$(LTxtG(x), MarkRect.Left TO MarkRect.Right)) ' Get copy of substring to process
            GOSUB DoAChunk                                        ' Go process this piece
            txt2 = LTxtG(x)                                       ' Get whole text line
            MID$(txt2, MarkRect.Left TO MarkRect.Right) = Txt1    ' Stuff back in the processed txt
            me.LTxtSet(x, txt2)                                   ' Replace the whole line
            me.AttrScan(x)                                        ' Recolorize
         END IF                                                   '
      NEXT x                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      me.MarkKill                                                 ' Reset the select frame
      MExitMeth                                                   '

   '-----------------------------------------------------------------------------------------------+
   '- Do the Sentence case stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   DoAChunk:                                                      '
      i = PARSECOUNT(Txt1, " ")                                   ' Count words
      REDIM words(1 TO i) AS STRING                               ' Make table correct size
      PARSE Txt1, words(), " "                                    ' Parse the words into the table
      m = 1                                                       ' Start scan at 1
      FOR j = 1 TO i                                              ' Loop for each word
         IF ISNOTNULL(words(j)) THEN                              ' Ignore null 'words'
            k = INSTR(m, Txt1, words(j))                          ' Find location of this word
            IF caps THEN                                          ' Capitalize this word?
               IF k THEN MID$(Txt1, k, 1) = UUCASE(MID$(Txt1, k, 1)) ' Uppercase the 1st letter
               Caps = %False                                      ' Off till next period
            END IF                                                '
            IF RIGHT$(words(j), 1) = "."  OR _                    ' Look for sentence trigger
               RIGHT$(words(j), 1) = "?"  OR _                    '
               RIGHT$(words(j), 1) = "!"  THEN                    '
               Caps = %True                                       ' Restart sentence if required
            END IF                                                '
            m = k + 1                                             ' Start scan adjust
         END IF                                                   '
      NEXT j                                                      '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  krSetDIN()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Set DataInsert ON                                                                            |
   '-----------------------------------------------------------------------------------------------+
      IF IsNsrtFlag THEN OnNsrtSave  ELSE OffNsrtSave             ' Save it
      IF IsNsrtData THEN OnNsrtSaveD ELSE OffNsrtSaveD            ' Save it
      OnNsrtFlag                                                  ' Set the mode
      OnNsrtData                                                  ' Set DataInsert
      FCB.TabBNDS = %False                                        ' Reset TabBNDS
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar Ins/Ovr box
   END METHOD                                                     '

   METHOD  krSetINS()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Set Insert key ON                                                                            |
   '-----------------------------------------------------------------------------------------------+
      IF IsNsrtFlag THEN OnNsrtSave  ELSE OffNsrtSave             ' Save it
      IF IsNsrtData THEN OnNsrtSaveD ELSE OffNsrtSaveD            ' Save it
      OnNsrtFlag                                                  ' Set the mode
      OffNsrtData                                                 ' Always set DataInsert off
      FCB.TabBNDS = %False                                        ' Reset TabBNDS
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar Ins/Ovr box
   END METHOD                                                     '

   METHOD  krSwap()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Swap command                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, swapLnum, markLnum, SNum AS LONG                   '
   LOCAL dSwapLine, dMarkLine, dSwapText, dMarkText, dPart1, dPart2, dPart3, dPart4 AS STRING   '
   LOCAL cSwapLine, cMarkLine, cSwapText, cMarkText, cPart1, cPart2, cPart3, cPart4 AS WSTRING  '
   LOCAL MaxECol, WorkECol AS LONG                                '
      MEntry                                                      '
      me.AttrInvClearFind                                         ' Clear any Find HiLite

      MaxECol = MAX(SwapECol, MarkRect.Right)                     '

      '--------------------------------------------------------------------------------------------+
      '- If both areas marked, we can do the Swap                                                  |
      '--------------------------------------------------------------------------------------------+
      IF IsMarkActive AND IsSwapActive THEN                       ' We have two marked areas ready
         '-----------------------------------------------------------------------------------------+
         '- Init for line loop                                                                     |
         '-----------------------------------------------------------------------------------------+
         me.SwapKill                                              ' To remove UL so they don't get copied
         swapLnum = SwapSLin: markLnum = MarkRect.Top             ' Point at the 1st two lines

         FOR SNum = 1 TO SwapLines                                ' Loop for the number of lines
            '--------------------------------------------------------------------------------------+
            '- Extract the two strings                                                             |
            '--------------------------------------------------------------------------------------+
            WorkECol = MAX(MaxECol, LTxtGLen(swapLNum))           '
            dSwapLine = LSET$(LTxtG(swapLnum), WorkECol USING " ")   ' Get the data text from the Swap line
            cSwapLine = LSET$(LAttrG(swapLnum), WorkECol USING CHR$$(0))   ' Get the attr text from the Swap line
            dSwapText = MID$(dSwapLine, SwapSCol TO SwapECol)     ' Extract the data columns
            cSwapText = MID$(cSwapLine, SwapSCol TO SwapECol)     ' Extract the attr columns
            me.ModSet(swapLnum)                                   ' Remember we changed something

            dMarkLine = LSET$(LTxtG(markLNum), WorkECol USING " ")   ' Get the data text from the Mark line
            cMarkLine = LSET$(LAttrG(markLnum), WorkECol USING CHR$$(0))   ' Get the attr text from the Mark line
            dMarkText = MID$(dMarkLine, MarkRect.Left TO MarkRect.Right)   ' Extract the data columns
            cMarkText = MID$(cMarkLine, MarkRect.Left TO MarkRect.Right)   ' Extract the attr columns
            me.ModSet(markLnum)                                   ' Remember we changed something

            IF swapLnum <> markLnum THEN                          ' We're dealing with two different lines

               '-----------------------------------------------------------------------------------+
               '- Handle the two different line combination                                        |
               '-----------------------------------------------------------------------------------+

               IF SwapSCol = 1 THEN                               ' If old Swap text is at LH end
                  dSwapLine = dMarkText + MID$(dSwapLine, SwapECol + 1) ' Just replace with the Mark text
                  cSwapLine = cMarkText + MID$(cSwapLine, SwapECol + 1) ' Just replace with the Mark text
               ELSE                                               '
                  '--------------------------------------------------------------------------------+
                  '- Insert dMarkText to replace dSwapText text                                    |
                  '--------------------------------------------------------------------------------+
                  dSwapLine = LEFT$(dSwapLine, SwapSCol - 1) + dMarkText + MID$(dSwapLine, SwapECol + 1) '
                  cSwapLine = LEFT$(cSwapLine, SwapSCol - 1) + cMarkText + MID$(cSwapLine, SwapECol + 1) '
               END IF                                             '
               me.LTxtSet(swapLnum, dSwapLine)                    ' Save the Swap line back
               me.LAttrSet(swapLnum,cSwapLine)                    '
               me.AttrScan(swapLnum)                              ' Recolorize

               IF MarkRect.Left = 1 THEN                          ' If old Mark text is at LH end
                  dMarkLine = dSwapText + MID$(dMarkLine, MarkRect.Right + 1) ' Just replace with the Swap text
                  cMarkLine = cSwapText + MID$(cMarkLine, MarkRect.Right + 1) ' Just replace with the Swap text
               ELSE                                               '
                  '--------------------------------------------------------------------------------+
                  '- Insert dMarkText to replace dSwapText text                                    |
                  '--------------------------------------------------------------------------------+
                  dMarkLine = LEFT$(dMarkLine, MarkRect.Left - 1) + dSwapText + MID$(dMarkLine, MarkRect.Right + 1)  '
                  cMarkLine = LEFT$(cMarkLine, MarkRect.Left - 1) + cSwapText + MID$(cMarkLine, MarkRect.Right + 1)  '
               END IF                                             '
               me.LTxtSet (markLnum, dMarkLine)                   ' Save the Swap line back
               me.LAttrSet(markLnum, cMarkLine)                   ' Save the Swap line back
               me.AttrScan(markLnum)                              ' Recolorize

            ELSE                                                  ' The Mark and Swap are on the same line
               '-----------------------------------------------------------------------------------+
               '- Swap on a single line                                                            |
               '-----------------------------------------------------------------------------------+
               IF SwapSCol < MarkRect.Left THEN                   ' Swap is left of Mark

                  '--------------------------------------------------------------------------------+
                  '- Swap area is Left of the Mark area                                            |
                  '--------------------------------------------------------------------------------+
                  dPart1 = LEFT$(dSwapLine, SwapSCol - 1)         ' Get part 1, the left of Swap string
                  cPart1 = LEFT$(cSwapLine, SwapSCol - 1)         ' Get part 1, the left of Swap string
                  '--------------------------------------------------------------------------------+
                  '- Get part 2, between the strings                                               |
                  '--------------------------------------------------------------------------------+
                  dPart2 = IIF$(SwapEcol + 1 = MarkRect.Left, "", MID$(dSwapLine, SwapECol + 1, MarkRect.Left - SwapECol - 1))   '
                  cPart2 = IIF$(SwapEcol + 1 = MarkRect.Left, "", MID$(cSwapLine, SwapECol + 1, MarkRect.Left - SwapECol - 1))   '
                  '--------------------------------------------------------------------------------+
                  '- Get part3, after the strings                                                  |
                  '--------------------------------------------------------------------------------+
                  dPart3 = MID$(dSwapLine, MarkRect.Right + 1)    ' Get part 3, After the strings
                  cPart3 = MID$(cSwapLine, MarkRect.Right + 1)    ' Get part 3, After the strings
                  '--------------------------------------------------------------------------------+
                  '- Rebuild the line                                                              |
                  '--------------------------------------------------------------------------------+
                  dSwapLine = BUILD$(dPart1, dMarkText, dPart2, dSwapText, dPart3)  ' Rebuild the line
                  cSwapLine = BUILD$(cPart1, cMarkText, cPart2, cSwapText, cPart3)  ' Rebuild the line

               ELSE                                               ' Mark is left of swap
                  '--------------------------------------------------------------------------------+
                  '- Swap area is Right of the Mark area                                           |
                  '--------------------------------------------------------------------------------+
                  dPart1 = LEFT$(dSwapLine, MarkRect.Left - 1)    ' Get part 1, the left of Mark string
                  cPart1 = LEFT$(cSwapLine, MarkRect.Left - 1)    ' Get part 1, the left of Mark string
                  '--------------------------------------------------------------------------------+
                  '- Get part 2, between the strings                                               |
                  '--------------------------------------------------------------------------------+
                  dPart2 = IIF$(MarkRect.Right + 1 = SwapSCol, "", MID$(dSwapLine, MarkRect.Right + 1, SwapSCol - MarkRect.Right - 1)) '
                  cPart2 = IIF$(MarkRect.Right + 1 = SwapSCol, "", MID$(cSwapLine, MarkRect.Right + 1, SwapSCol - MarkRect.Right - 1)) '
                  '--------------------------------------------------------------------------------+
                  '- Get part 3, after the strings                                                 |
                  '--------------------------------------------------------------------------------+
                  dPart3 = MID$(dSwapLine, SwapECol + 1)          ' Get part 3, After the strings
                  cPart3 = MID$(cSwapLine, SwapECol + 1)          ' Get part 3, After the strings
                  '--------------------------------------------------------------------------------+
                  '- Rebuild the line                                                              |
                  '--------------------------------------------------------------------------------+
                  dSwapLine = BUILD$(dPart1, dSwapText, dPart2, dMarkText, dPart3)  ' Rebuild the line
                  cSwapLine = BUILD$(cPart1, cSwapText, cPart2, cMarkText, cPart3)  ' Rebuild the line

               END IF                                             '
               me.LTxtSet (swapLnum, dSwapLine)                   ' Save the Swap line back
               me.LAttrSet(swapLnum, cSwapLine)                   '
               me.AttrScan(swapLnum)                              ' Recolorize

            END IF                                                '

            swapLnum = me.CRPFwd(%mOData, swapLnum, 1)            ' Move to next line
            markLnum = me.CRPFwd(%mOData, markLnum, 1)            ' Move to next line
         NEXT SNum                                                ' Loop till all lines in block done

         me.MarkKill                                              ' Kill the mark area
         me.CurSetReq(%Position, IIF(SwapSLin < MarkRect.Top, SwapSLin, MarkRect.Top), 1, %True)   ' Set cursor set attempt
         DoSet(%Refresh)                                          ' Have it looked at

      '--------------------------------------------------------------------------------------------+
      '- Only Mark area active, start a Swap activity                                              |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsMarkActive AND ISFALSE IsSwapActive THEN           ' We have a MARK but no SWAP, start a Swap
         SwapSCol = MarkRect.Left                                 ' Copy marked area as a swap area
         SwapECol = MarkRect.Right                                '
         SwapSLin = MarkRect.Top                                  '
         SwapELin = MarkRect.Bottom                               '

         SwapLines = 0                                            ' Clear counter
         FOR i = SwapSLin TO SwapELin                             ' Count data lines
            IF IsLData(i) THEN INCR SwapLines                     '
         NEXT i                                                   '
         me.MarkKill                                              ' Kill the mark area
         OnSwapActive                                             ' Make Swap active
         me.SwapScr                                               ' Draw the underline

      '--------------------------------------------------------------------------------------------+
      '- No Mark area, See if Move mode, or Kill time                                              |
      '--------------------------------------------------------------------------------------------+
      ELSEIF ISFALSE IsMarkActive AND IsSwapActive THEN           ' We have swap and no Mark, See if maybe Move mode
         IF IsCData THEN                                          ' Cursor In the Data Area?
            j = me.SGet(@P.C.CRow)                                ' Get line number of the cursor
            IF j < 0 THEN j = me.SGet(@P.C.CRow - ABS(j))         ' Convert to real line index
            IF j = 0 THEN GOSUB KillSwap: MExitMeth               ' Bail out if below last line
            i = @P.C.CCol - @P.PGapCol + @P.POffset               ' Calc column index into line

            IF j >= SwapSLin AND j <= SwapELin AND _              ' Cursor within the SWAP area?
               i >= SwapSCol AND i <= SwapECol THEN GOSUB KillSwap: MExitMeth ' Kill if

            '--------------------------------------------------------------------------------------+
            '- This looks like a SWAP Move mode request                                            |
            '--------------------------------------------------------------------------------------+
            '--------------------------------------------------------------------------------------+
            '- Init for line loop                                                                  |
            '--------------------------------------------------------------------------------------+
            me.SwapKill                                           ' Remove UL so it doesn't get copied
            swapLnum = SwapSLin: markLnum = j                     ' Point at the 1st two lines

            FOR SNum = 1 TO SwapLines                             ' Loop for the number of lines in Swap area
               '-----------------------------------------------------------------------------------+
               '- Extract the two lines                                                            |
               '-----------------------------------------------------------------------------------+

               dSwapLine = LTxtG(swapLnum)                        ' Get the text from the Swap line
               cSwapLine = LAttrG(swapLnum)                       ' Get the text from the Swap line
               dMarkLine = LTxtG(markLnum)                        ' Get the text from the Mark line
               cMarkLine = LAttrG(markLnum)                       ' Get the text from the Mark line

               IF LEN(dSwapLine) < j THEN dSwapLine = LSET$(dSwapLine, j)  ' Make sure lines are as long as the mark point
               IF LEN(cSwapLine) < j THEN cSwapLine = LSET$(cSwapLine, j USING CHR$$(0))  '

               IF LEN(dMarkLine) < j THEN dMarkLine = LSET$(dMarkLine, j)  '
               IF LEN(cMarkLine) < j THEN cMarkLine = LSET$(cMarkLine, j USING CHR$$(0))  '

               IF swapLnum <> markLnum THEN                       ' We're dealing with two different lines
                  dSwapText = MID$(dSwapLine, SwapSCol TO SwapECol)  ' Extract the swap data
                  cSwapText = MID$(cSwapLine, SwapSCol TO SwapECol)  ' Extract the swap data

                  dSwapLine = LEFT$(dSwapLine, SwapSCol - 1) + MID$(dSwapLine, SwapECol + 1) ' Remove if from the line
                  cSwapLine = LEFT$(cSwapLine, SwapSCol - 1) + MID$(cSwapLine, SwapECol + 1) ' Remove if from the line

                  me.LTxtSet (swapLnum, dSwapLine)                ' Save the Swap line back
                  me.LAttrSet(swapLnum, cSwapLine)                ' Save the Swap line back
                  me.AttrScan(swapLnum)                           ' Recolorize
                  me.ModSet(swapLnum)                             ' Remember we changed something

                  '--------------------------------------------------------------------------------+
                  '- Handle the two different line combination                                     |
                  '--------------------------------------------------------------------------------+
                  IF i = 1 THEN                                   ' If insert point is at LH end
                     dMarkLine = dSwapText + dMarkLine            ' Just insert it
                     cMarkLine = cSwapText + cMarkLine            ' Just insert it
                  ELSE                                            '
                     dMarkLine = LEFT$(dMarkLine, i - 1) + dSwapText + MID$(dMarkLine, i) ' Insert dMarkText at the cursor column
                     cMarkLine = LEFT$(cMarkLine, i - 1) + cSwapText + MID$(cMarkLine, i) ' Insert dMarkText at the cursor column
                  END IF                                          '
                  me.LTxtSet (markLnum, dMarkLine)                ' Save the Swap line back
                  me.LAttrSet(markLnum, cMarkLine)                ' Save the Swap line back
                  me.AttrScan(markLnum)                           ' Recolorize
                  me.ModSet(markLnum)                             ' Remember we changed something

               ELSE                                               ' The Mark and Swap are on the same line
                  '--------------------------------------------------------------------------------+
                  '- Swap on a single line                                                         |
                  '--------------------------------------------------------------------------------+
                  IF SwapSCol < i THEN                            ' Swap is left of Mark
                     '-----------------------------------------------------------------------------+
                     '- Swap area is Left of the Mark area                                         |
                     '-----------------------------------------------------------------------------+
                     dPart1 = LEFT$(dSwapLine, SwapSCol - 1)      ' Get part 1, the left of Swap string
                     cPart1 = LEFT$(cSwapLine, SwapSCol - 1)      ' Get part 1, the left of Swap string

                     dPart2 = MID$(dSwapLine, SwapECol + 1 TO i - 1) ' Get part 2, between the strings
                     cPart2 = MID$(cSwapLine, SwapECol + 1 TO i - 1) ' Get part 2, between the strings

                     dPart3 = MID$(dSwapLine, SwapSCol TO SwapECol)  ' Get part 3, The swap string
                     cPart3 = MID$(cSwapLine, SwapSCol TO SwapECol)  ' Get part 3, The swap string

                     dPart4 = MID$(dSwapLine, i)                  ' Get part 4, remainder of line
                     cPart4 = MID$(cSwapLine, i)                  ' Get part 4, remainder of line

                     dSwapLine = BUILD$(dPart1, dPart2, dPart3, dPart4) ' Rebuild the line
                     cSwapLine = BUILD$(cPart1, cPart2, cPart3, cPart4) ' Rebuild the line

                  ELSE                                            ' Mark is left of swap
                     '-----------------------------------------------------------------------------+
                     '- Swap area is Right of the Mark point                                       |
                     '-----------------------------------------------------------------------------+
                     dPart1 = LEFT$(dSwapLine, i - 1)             ' Get part 1, the left of Mark string
                     cPart1 = LEFT$(cSwapLine, i - 1)             ' Get part 1, the left of Mark string

                     dPart2 = MID$(dSwapLine, SwapSCol TO SwapECol)  ' Get part 2, the swap string
                     cPart2 = MID$(cSwapLine, SwapSCol TO SwapECol)  ' Get part 2, the swap string

                     dPart3 = MID$(dSwapLine, i TO SwapSCol - 1)  ' Get part 3, Between mark and swap string
                     cPart3 = MID$(cSwapLine, i TO SwapSCol - 1)  ' Get part 3, Between mark and swap string

                     dPart4 = MID$(dSwapLine, SwapECol + 1)       ' Get part 4, After the Swap string
                     cPart4 = MID$(cSwapLine, SwapECol + 1)       ' Get part 4, After the Swap string

                     dSwapLine = BUILD$(dPart1, dPart2, dPart3, dPart4) ' Rebuild the line
                     cSwapLine = BUILD$(cPart1, cPart2, cPart3, cPart4) ' Rebuild the line
                  END IF                                          '
                  me.LTxtSet (swapLnum, dSwapLine)                ' Save the Swap line back
                  me.LAttrSet(swapLnum, cSwapLine)                ' Save the Swap line back
                  me.AttrScan(swapLnum)                           ' Recolorize
                  me.ModSet(swapLnum)                             ' Remember we changed something
               END IF                                             '

               swapLnum = me.CRPFwd(%mOData, swapLnum, 1)         ' Move to next line
               markLnum = me.CRPFwd(%mOData, markLnum, 1)         ' Move to next line
            NEXT SNum                                             ' Loop till all lines in block done

            me.MarkKill                                           ' Kill the mark area
            me.SwapKill                                           ' Kill the Swap area
            me.CurSetReq(%Position, j, i, %True)                  ' Set cursor set attempt
            DoSet(%Refresh)                                       ' Have it looked at

         ELSE                                                     ' Not even in data area
            GOSUB KillSwap                                        ' Kill things
         END IF                                                   '

      END IF                                                      '
      MExitMeth                                                   '

   KillSwap:                                                      '
      IF IsSwapDrawn THEN me.SwapKill                             ' Kill underline if drawn
      OffSwapActive                                               ' Now kill Swap
      DoSet(%Refresh)                                             ' Have it looked at
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  krTab()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Tab forward To Next field                                                                    |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k AS LONG, lclTabs AS STRING                       '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      OnInsClnSupp                                                ' Suppress Insert cleanup for 1 Attn pass

      IF @P.C.CRow = @P.PTop THEN                                 ' Top line?
         '-----------------------------------------------------------------------------------------+
         '- Cursor on top line                                                                     |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CCol < @P.PCmdCol THEN SetCmd: MExitMeth         '
         IF @P.C.CCol < @P.PScrHdr THEN SetScrl: MExitMeth        '
         me.CsrRow = @P.PData1: me.CsrCol = @P.PLeft: MExitMeth   '

      ELSEIF @P.C.CRow = 2 THEN                                   ' Message line?
         '-----------------------------------------------------------------------------------------+
         '- Sitting on Line 2                                                                      |
         '-----------------------------------------------------------------------------------------+
         me.CsrRow = @P.PData1: me.CsrCol = @P.PLeft: MExitMeth   '

      ELSEIF @P.C.CRow = @P.PData1 - 1 THEN                       ' Possible Data or Cols Line?
         '-----------------------------------------------------------------------------------------+
         '- If on fixed COLS line, get out                                                         |
         '-----------------------------------------------------------------------------------------+
         IF FCB.Cols AND P = VARPTR(P1) THEN                      ' Yes
            me.CsrRow = @P.PData1: me.CsrCol = @P.PLeft: MexitMeth' If yes, down to data
         END IF                                                   '

      ELSEIF @P.C.CRow >= @P.PData1 THEN                          ' Data Line?
         '-----------------------------------------------------------------------------------------+
         '- Sitting in text area                                                                   |
         '-----------------------------------------------------------------------------------------+
         j = me.SGet(@P.C.CRow)                                   ' Get Line number of cursor line
         IF j = 0 THEN me.krHome: MexitMeth                       ' Below last line?
         IF j < 0 THEN j = me.SGet(@P.C.CRow - ABS(j))            ' Get real data line
         lclTabs = me.TabsSimple(LEN(L(j).@LTxt))                 ' Get a working tabs line
         SELECT CASE @P.C.CCol                                    ' Now base it on column
            CASE < @P.PGapCol                                     ' In line number area
               IF IsLBottom(j) THEN SetCmd: MExitMeth             ' If Bottom, go to command line
               IF IsLTop(j) THEN me.CsrRow = @P.C.CRow + 1:MExitMeth ' If TOP
               me.CsrCol = @P.PDataCol: MExitMeth                 '
            CASE ELSE                                             ' In the real data area
               GOSUB DataTab                                      '
         END SELECT                                               '
      END IF                                                      '
      MExitMeth                                                   '

   '-----------------------------------------------------------------------------------------------+
   '- Handle the actual tabbing logic                                                              |
   '-----------------------------------------------------------------------------------------------+
   DataTab:                                                       '
      IF ISFALSE FCB.Tabs THEN                                    ' If not tabbing
         me.CsrRowAdd(1): me.CsrCol = @P.PLeft                    ' Do basic bump
         IF @P.C.CRow > @P.PBottom THEN SetCmd                    ' Down too far? Cursor to the command line
         MExitMeth                                                ' Leave now
      END IF                                                      '
                                                                  ' Tabbing IN a data line
      '--------------------------------------------------------------------------------------------+
      '- Within a data line                                                                        |
      '--------------------------------------------------------------------------------------------+
      i = @P.C.CCol - @P.PGapCol + @P.POffset                     ' Calc index into data string
      i = INSTR(i + 1, lclTabs, "*")                              ' Look for next tab marker

      '--------------------------------------------------------------------------------------------+
      '- There's another marker on the line                                                        |
      '--------------------------------------------------------------------------------------------+
      IF i THEN                                                   ' We have one
         IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
            me.CurSetReq(%Position, j, i, %True)                  ' No, Set cursor set attempt
            DoSet(%Refresh)                                       ' Have it looked at
            MExitMeth                                             '
         ELSE                                                     '
            me.CsrCol = i + @P.PGapCol - @P.POffset               ' Just move cursor on the screen
            MExitMeth                                             '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- No more tabs, we need to get to the next line                                             |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' We're gone past last tab, go to next line
         IF INSTR(FCB.TabsLine, "+") = 0 THEN                     ' Extensible tabs?
            j = me.CRPFwd(%MVisible, j, 1)                        ' No
            @P.POffset = 0                                        '
            me.CurSetReq(%Position, j, 0, %True)                  ' Set cursor set attempt
            me.CsrMode                                            ' Refresh Csr data
            DoSet(%Refresh)                                       ' Have it looked at
         ELSE                                                     ' Yes, extensible tabs
            k = LEN(L(j).@LTxt)                                   ' Get current length of line
            DO UNTIL i > 0                                        ' OK, extend till we get a tab marker
               k += k                                             ' Double the length
               lclTabs = me.TabsSimple(k)                         ' Get a longer working tabs line
               i = @P.C.CCol - @P.PGapCol + @P.POffset            ' Calc index into data string
               i = INSTR(i + 1, lclTabs, "*")                     ' Look for next tab marker
            LOOP                                                  '
            IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
               me.CurSetReq(%Position, j, i, %True)               ' No, Set cursor set attempt
               DoSet(%Refresh)                                    ' Have it looked at
               MExitMeth                                          '
            ELSE                                                  '
               me.CsrCol = i + @P.PGapCol - @P.POffset            ' Just move cursor on the screen
               MExitMeth                                          '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD krTabBNDS()                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Toggle TabBNDS                                                                               |
   '-----------------------------------------------------------------------------------------------+
      TP.FCB_.TabBNDS = IIF(TP.FCB_.TabBNDS, %False, %True)       ' Toggle the setting
      DoSet(%Attention)                                           ' Just call Attention
      DoStatusBar($SBInsOvr)                                      ' re-Do the StatusBar Ins/Ovr box
   END METHOD                                                     '

   METHOD krTabRelease()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- Release tab lock                                                                               |
   '-----------------------------------------------------------------------------------------------+
      TP.KBTabFree = %True                                        ' Reset the flag
   END METHOD                                                     '

   METHOD krTabShift()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Do a Shift within Tab Boundaries                                                             |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, l AS LONG, lclTabs, t AS STRING                 '
      MEntry                                                      '
      IF @P.C.CRow < @P.PData1 THEN GOTO PassOff                  ' Let (Tab) take over
      IF @P.C.CIX = 0 THEN GOTO PassOff                           ' Below last line?
      IF ISFALSE IsLData(@P.C.CIX) THEN GOTO PassOff              ' Not on a Data line?
      IF FCB.HexMode = 4 THEN DoBeep: MExitMeth                   ' In Hex Mode?
      IF @P.C.CCol < @P.PDataCol THEN GOTO PassOff                ' In Line # area?
      lclTabs = me.TabsSimple(LEN(L(@P.C.CIX).@LTxt))             ' Get a working tabs line
      IF ISNULL(TRIM$(lclTabs)) THEN GOTO PassOff                 ' No tabs?

      '--------------------------------------------------------------------------------------------+
      '- Sitting in text area with active tabs                                                     |
      '--------------------------------------------------------------------------------------------+
      i = @P.C.CLCol                                              ' Calc index into data string
      k = INSTR(i + 1, lclTabs, "*")                              ' Look for next tab marker
      IF k = 0 THEN GOTO PassOff                                  ' No tab to the Right?

      '--------------------------------------------------------------------------------------------+
      '- There's another marker on the line  (i = cursor, @P.C.CIX = txt line, k = next tab)       |
      '--------------------------------------------------------------------------------------------+
      t = LTxtG(@P.C.CIX)                                         ' Get Text line
      IF ISNULL(TRIM$(MID$(t, i TO k - 1))) THEN GOTO PassOff     ' If all blank to next tab, just do a tab
      l = LEN(RTRIM$(MID$(t, i TO k - 1)))                        ' Get length of current col's movable data
      IF ISNULL(TRIM$(MID$(t, k TO k + l - 1))) THEN              ' Is next column effectively blank
         me.ModSet(@P.C.CIX)                                      ' Remember we changed something
         t = LSET$(LEFT$(t, i - 1), k - 1) + MID$(t, i, l) + MID$(t, k + l)   ' Shift to next tab column
      ELSE                                                        '
         t = LSET$(LEFT$(t, i - 1), k - 1) + MID$(t, i)           ' Shift to next tab column
      END IF                                                      '
      me.LTxtSet(@P.C.CIX, t)                                     ' Store it
      me.AttrScan(@P.C.CIX)                                       ' Recolorize
      me.DispLine(@P.C.CIX, @P.C.CRow)                            ' Re-display the line
      me.CurSetReq(%Position, @P.C.CIX, k, %True)                 ' Set cursor set attempt
      DoSet(%Refresh)                                             ' Have it looked at
      MExitMeth                                                   '
      PassOff:                                                    '
      krTab                                                       ' Just let (Tab) do its thing
   END METHOD                                                     '

   METHOD  krTDPaste(ln AS STRING)                                '
   '-----------------------------------------------------------------------------------------------+
   '- Paste in the passed string                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j AS LONG                                             '
   LOCAL t, tt AS STRING, tc AS WSTRING                           '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      me.MarkKill                                                 ' Kill any active block select
      me.SwapKill                                                 '
      me.AttrInvClearFind                                         ' Clear any Find HiLite

      '--------------------------------------------------------------------------------------------+
      '- Paste into the Command line                                                               |
      '--------------------------------------------------------------------------------------------+
      IF IsCCmnd THEN                                             ' In the Command area?
         tt = pCommand                                            ' Get working copy
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF LEN(tt) - @P.C.CLCol < LEN(ln) THEN tt = tt + SPACE$(LEN(ln))  ' Lengthen if needed
            MID$(tt, @P.C.CLCol, LEN(ln)) = ln                    ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            tt = LEFT$(tt, @P.C.CLCol - 1) + ln + MID$(tt, @P.C.CLCol)  '
         END IF                                                   '
         PCommand = tt                                            ' Copy back
         i = @P.C.CLCol + LEN(ln) - 1                             ' Move cursor
         IF i > @P.PCmdLen + @P.PCOffset THEN                     ' Is it to the right of the Window?
            @P.PCOffset = i - (@P.PCmdLen / 2)                    ' Adjust offset
         ELSEIF i < @P.PCOffset THEN                              ' Is it to the left of the Window?
            @P.PCOffset = MAX(0, i - (@P.PCmdLen / 2))            ' Adjust offset
         END IF                                                   '
         me.WindowCmd                                             ' Print the whole string again
         me.CsrCol = i + @P.PCmdCol                               ' Move cursor

      '--------------------------------------------------------------------------------------------+
      '- Paste into the text data                                                                  |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsCData THEN                                         ' In the Data Area?

         '-----------------------------------------------------------------------------------------+
         '- Make sure it's a valid data line                                                       |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' Convert to real line index
         IF @P.C.CIX = 0 OR @P.C.CIX < 0 THEN DoBeep: MExitMeth   ' Bail out if below last line or a Hex Line
         IF ISTRUE (LFlagG(@P.C.CIX) AND %NonTypable) THEN        ' Ignore non-typable lines
            DoBeep: MExitMeth                                     '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do the paste                                                                           |
         '-----------------------------------------------------------------------------------------+
         me.ModSet(@P.C.CIX)                                      ' Remember we changed something
         i = @P.C.CLCol                                           ' Get index into string
         tt = LTxtG(@P.C.CIX)                                     ' Get working copy of text
         tc = LAttrG(@P.C.CIX)                                    '

         '-----------------------------------------------------------------------------------------+
         '- Do it either Insert or non-Insert mode                                                 |
         '-----------------------------------------------------------------------------------------+
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF LEN(tt) - i < LEN(ln) THEN tt = tt + SPACE$(i + LEN(ln) - LEN(tt))   ' Lengthen if needed
            MID$(tt, i, LEN(ln)) = ln                             ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            me.DataInsert(tt, tc, ln, i)                          ' Insert the data
         END IF                                                   '

         me.LTxtSet(@P.C.CIX, tt)                                 ' Save it back
         me.UCIfNeeded(@P.C.CIX)                                  ' UC if CAPS ON
         me.LAttrSet(@P.C.CIX, tc)                                '
         me.AttrScan(@P.C.CIX)                                    ' Recolorize

         '-----------------------------------------------------------------------------------------+
         '- Print, do extra stuff if Hex mode                                                      |
         '-----------------------------------------------------------------------------------------+
         me.DispLine(@P.C.CIX, @P.C.CRow)                         ' Re-display the line
         IF FCB.HexMode <> &1 THEN                                ' If hex mode
            IF @P.C.CRow + 1 <= TP.gPBottom THEN                  ' Make sure we don't go off the bottom
               DoPrint (me.WindowHexTop(tt), $$TxtLo, @P.C.CRow + 1, @P.PDataCol)   ' Print upper hex
               me.MarkReDraw(@P.C.CRow + 1)                       ' Re-draw the MARK lines
            END IF                                                '
            IF @P.C.CRow + 2 <= TP.gPBottom THEN                  ' Make sure we don't go off the bottom
               DoPrint (me.WindowHexBottom(tt), $$TxtLo, @P.C.CRow + 2, @P.PDataCol)   ' Print lower hex
            me.MarkReDraw(@P.C.CRow + 2)                          ' Re-draw the MARK lines
            END IF                                                '
         END IF                                                   '

         me.CsrCol = @P.C.CCol + LEN(ln)                          ' Move cursor
         IF @P.C.CCol < @P.POffset + 1 OR @P.C.CCol > @P.POffset + @P.PDataLen - 1 THEN   ' Still on current screen
            me.CurSetReq(%Position, @P.C.CIX, @P.C.CCol, %True)   ' No, Set cursor set attempt
         DoSet(%Refresh)                                          ' Have it looked at
         END IF                                                   '

      ELSE                                                        ' Anything else (CursBad)
         DoBeep                                                   ' Beep it
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krTime()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Paste Date at cursor location                                                                |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = Time12HR()                                             ' Go get the date
      me.krTDPaste(ln)                                            ' Go do common code
   END METHOD                                                     '

   METHOD  krTitleCase()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- TitleCase a selected block                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x AS LONG                                                '
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Titlecase                                                                  |
      '--------------------------------------------------------------------------------------------+
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISTRUE IsLData(x) OR ISTRUE IsLNote(x) THEN           ' Just data lines
            me.ModSet(x)                                          ' Remember we changed something
            me.TitleCase(x, MarkRect.Left, MarkRect.Right)        ' Go process it
         END IF                                                   '
      NEXT x                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      me.MarkKill                                                 ' Reset the select frame
   END METHOD                                                     '

   METHOD  krToggleHome()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- ToggleHome key                                                                               |
   '-----------------------------------------------------------------------------------------------+
      '--------------------------------------------------------------------------------------------+
      '- Make sure it's a valid line                                                               |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CRow < @P.PData1 THEN DoBeep: EXIT METHOD           ' Command line, line 2 or COLS line
      IF @P.C.CIX = 0 OR @P.C.CIX = -3 THEN DoBeep: EXIT METHOD   ' Below last line or Hex dash line? Bail out
      IF ISFALSE (LFlagG(@P.C.CIX) AND %NonTypable) THEN          ' See if cursor on a typable line

         '-----------------------------------------------------------------------------------------+
         '- Toggle location back and forth                                                         |
         '-----------------------------------------------------------------------------------------+
         IF @P.C.CCol <> @P.PDataCol THEN                         ' If not in col 1
            me.CsrCol = @P.PDataCol                               ' Move cursor back to 1st data col
         ELSE                                                     '
            IF ISNULL(TRIM$(LTxtG(@P.C.CIX))) THEN                ' No text?
               me.CsrCol = @P.PDataCol                            ' Stay in col 1
            ELSE                                                  '
               me.CsrCol = @P.PGapCol + VERIFY(LTxtG(@P.C.CIX), " ") '
            END IF                                                '
         END IF                                                   '
      ELSE                                                        '
         DoBeep                                                   ' Beep
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krToggleSelect()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Toggle Select status                                                                         |
   '-----------------------------------------------------------------------------------------------+
      IF IsSlecSet THEN                                           ' Have a selection?
         IF IsSlecActive THEN                                     ' Toggle the Active status
            OffSlecActive                                         '
            IF IsMarkActive THEN me.MarkKill                      ' Something active, erase it
         ELSE                                                     '
            OnSlecActive                                          '
            IF ISFALSE IsMarkActive THEN                          ' Nothing active, flip it
               MarkRect.Left = SlecSCol                           ' Restore Marked area
               MarkRect.Right = SlecECol                          '
               MarkRect.Top = me.LineNoRef(FORMAT$(SlecSLin))     '
               MarkRect.Bottom = me.LineNoRef(FORMAT$(SlecELin))  '
               OnMarkActive                                       '
               me.MarkScr                                         ' Redraw screen
            END IF                                                '
         END IF                                                   '
         DoStatusBar($SBSelect)                                   ' re-Do the StatusBar Select box
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krTxtHome()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- TxtHome key                                                                                  |
   '-----------------------------------------------------------------------------------------------+
      '--------------------------------------------------------------------------------------------+
      '- Make sure the line's a valid one                                                          |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CRow < @P.PData1 THEN DoBeep: EXIT METHOD           ' Command line, line 2 or COLS line
      IF @P.C.CIX = 0 OR @P.C.CIX = -3 THEN DoBeep: EXIT METHOD   ' Below last line or Hex dash line? Bail out
      IF ISFALSE (LFlagG(@P.C.CIX) AND %NonTypable) THEN          ' See if cursor on a typable line
         me.CsrCol = @P.PDataCol                                  ' Move cursor back to 1st data col
      ELSE                                                        '
         DoBeep                                                   ' Beep
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krTxtNewLine(OPTIONAL ns AS LONG)                      '
   '-----------------------------------------------------------------------------------------------+
   '- TxtNewLine key                                                                               |
   '-----------------------------------------------------------------------------------------------+
   LOCAL noscroll AS LONG                                         '
      noscroll = IIF(ISMISSING(ns), %False, ns)                   ' Pick up No Scroll flag
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Top of screen area                                                                        |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CRow < @P.PData1 THEN                               ' Command line, line 2 or COLS line
         me.CsrRow = @P.PData1: me.CsrCol = @P.PDataCol: EXIT METHOD ' Go to 1st data line
      END IF                                                      ' Else in data area

      '--------------------------------------------------------------------------------------------+
      '- Get real line #                                                                           |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CIX = 0 THEN                                        ' Not in data area?
         SetCmd                                                   ' Cursor to Cmd line
         EXIT METHOD                                              '
      END IF                                                      '
      IF @P.C.CIX < 0 THEN @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX))   ' If Hex extra line, get real line

      '--------------------------------------------------------------------------------------------+
      '- Go to next line                                                                           |
      '--------------------------------------------------------------------------------------------+
      me.CsrRowAdd(1)                                             ' Simple INCR
      IF @P.C.CRow > TP.gPBottom OR IsLBottom(@P.C.CIX) THEN      ' At bottom line yet?
         IF @P.C.CIX = 0 OR IsLBottom(@P.C.CIX) OR ISTRUE noscroll THEN ' Not in data area or noscroll requested?
            SetCmd                                                ' Cursor to Cmd line
            EXIT METHOD                                           '
         END IF                                                   '
         @P.C.CIX = me.CRPFwd(%mVisible, @P.C.CIX, 1)             ' Move to next visible line
         me.CurSetReq(%Position, @P.C.CIX, @P.POffset + 1, %True) ' Set cursor set attempt
         @P.PTopLine = me.CRPFwd(%mVisible, @P.PTopLine, 1)       ' Move TopScrn by scroll amount
         OnInsClnSupp                                             ' Suppress Insert cleanup for 1 Attn pass
         DoSet(%Refresh)                                          ' Have it looked at
      ELSE                                                        '
         me.CsrCol = @P.PDataCol                                  '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  krUp()                                                 '
   '-----------------------------------------------------------------------------------------------+
   '- Decrement CsrRow                                                                             |
   '-----------------------------------------------------------------------------------------------+
   LOCAL cIncr AS LONG                                            '
      MEntry                                                      '
      cIncr = IIF(VAL(gKeyPrimOper) > 0, VAL(gKeyPrimOper), 1)    ' Set the INCR amount?
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      '--------------------------------------------------------------------------------------------+
      '- Possibility of scrolling upward                                                           |
      '--------------------------------------------------------------------------------------------+
      SELECT CASE @P.C.CRow                                       ' OK, lets see what we got
         '-----------------------------------------------------------------------------------------+
         '- Command line, always wrap                                                              |
         '-----------------------------------------------------------------------------------------+
         CASE @P.PTop                                             ' Currently on line 1
            IF ISFALSE gENV.KBVerScroll THEN                      ' If no Vertical scrolling
               me.CsrRow = @P.PBottom                             ' Then wrap to the bottom
            END IF                                                '

         CASE @P.PTop + 1                                         ' Message line?
            SetCmd                                                ' Yes

         CASE @P.PData1 - 1                                       ' Possible On the fixed COLS> line?
            SetCmd                                                ' Yes

         CASE @P.PData1                                           ' Time for a scroll?
         '-----------------------------------------------------------------------------------------+
         '- Top text data line then do scrolling if allowed                                        |
         '-----------------------------------------------------------------------------------------+
            IF ISFALSE gENV.KBVerScroll THEN                      ' No KeybScroll then we're done
               SetCmd                                             ' Go to command line
               MExitMeth                                          '
            END IF                                                '

            FCB.ScrlPageSus = %True                               ' Set suspend PAGE mode
            IF ISFALSE IsLTop(@P.C.CIX) THEN                      ' See if cursor is at the top
               @P.C.CIX = me.CRPBack(%mVisible, @P.C.CIX, cIncr)  ' Move back to next visible line
               me.CurSetReq(%Position, @P.C.CIX, @P.C.CCol - @P.PGapCol + @P.POffset, %False)   ' Set cursor set attempt
               @P.PTopLine = me.CRPBack(%mVisible, @P.PTopLine, cIncr)  ' Move TopScrn by scroll amount
               OnInsClnSupp                                       ' Suppress Insert cleanup for 1 Attn pass
               DoSet(%Refresh)                                    ' Have it looked at

            '--------------------------------------------------------------------------------------+
            '- Anything else, just a simple cursor up                                              |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  '
               me.CsrRow = MAX(@P.PTop, @P.C.CRow - cIncr)        ' Simple DECR, go no lower than 1
            END IF                                                '

         CASE ELSE                                                '
            me.CsrRow = MAX(@P.PTop, @P.C.CRow - cIncr)           ' Simple DECR, go no lower than 1
      END SELECT                                                  '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  krUpperCase()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- UpperCase a selected block                                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL x, i AS LONG, lclTxt AS STRING                           '
      me.AttrInvClearFind                                         ' Clear any Find HiLite
      '--------------------------------------------------------------------------------------------+
      '- Ensure a marked area and get its bounds                                                   |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE IsMarkActive THEN DoBeep: EXIT METHOD            ' Better be something selected, else exit

      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Uppercase                                                                  |
      '--------------------------------------------------------------------------------------------+
      FOR x = MarkRect.Top TO MarkRect.Bottom                     ' Loop through the requested range
         IF ISTRUE IsLData(x) OR ISTRUE IsLNote(x) THEN           ' Just data/note lines
            me.ModSet(x)                                          ' Remember we changed something
            lclTxt = LTxtG(x)                                     ' Get the text
            IF MarkRect.Left <= LEN(lclTxt) THEN                  ' Do only if long enough
               FOR i = MarkRect.Left TO MIN(MarkRect.Right, LEN(lclTxt))   ' Just ones that are there
                  MID$(lclTxt, i, 1) = UUCASE(MID$(lclTxt, i, 1)) '
               NEXT i                                             '
               me.LTxtSet(x, lclTxt)                              ' Put work string back
               me.AttrScan(x)                                     ' Recolorize
               me.CurSetReq(%Position, MarkRect.Bottom, MarkRect.Right + 1, %True)  ' Set cursor set attempt
            END IF                                                '
         END IF                                                   '
      NEXT x                                                      '
      DoSet(%Refresh)                                             ' Have it looked at
      me.MarkKill                                                 ' Reset the select frame
   END METHOD                                                     '

   METHOD  PTBackTab()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Tab backward To previous field in PowerType mode                                             |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j AS LONG, lclTabs AS STRING                          '
      MEntry                                                      '
      OnInsClnSupp                                                ' Suppress Insert cleanup for 1 Attn pass

      '--------------------------------------------------------------------------------------------+
      '- Do it based on where we are                                                               |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE FCB.Tabs THEN _                                  ' No TABS, just go to left margin
         me.CsrCol = @P.PDataCol: MExitMeth                       '
      i = @P.C.CLCol                                              ' Calc index into data string
      lclTabs = me.TabsSimple(i + 80)                             ' Get a working tabs line

      '--------------------------------------------------------------------------------------------+
      '- If far right, go to last tab                                                              |
      '--------------------------------------------------------------------------------------------+
      IF i > LEN(lclTabs) THEN                                    ' If right of last tab
         GOSUB LastTab                                            ' Go set to the last tab

      '--------------------------------------------------------------------------------------------+
      '- Else backup one tab                                                                       |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        '
         i = INSTR(i - LEN(lclTabs) - 2, lclTabs, "*")            ' look for prev tab marker
         IF i THEN                                                ' If we have one
            IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
               me.CurSetReq(%Position, @P.C.CIX, i, %True)        ' No, Set cursor set attempt
               DoSet(%Refresh)                                    ' Have it looked at
               MExitMeth                                          '
            ELSE                                                  ' Still on screen, just move cursor
               me.CsrCol = i + @P.PGapCol - @P.POffset            '
            END IF                                                '
         ELSE                                                     ' No more to the left
            me.CsrCol = @P.PDataCol                               ' Left margin if not already there
         END IF                                                   '
      END IF                                                      '

   MExitMeth                                                      '

   '-----------------------------------------------------------------------------------------------+
   '- Find the last tab                                                                            |
   '-----------------------------------------------------------------------------------------------+
   LastTab:                                                       ' Find Last Tab
      lclTabs = me.TabsSimple(LEN(L(@P.C.CIX).@LTxt))             ' Get a working tabs line
      IF FCB.Tabs THEN                                            ' If TABS active
         i = INSTR(-1, lclTabs, "*")                              '
      ELSE                                                        '
         i = 1                                                    '
      END IF                                                      '
      IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
         me.CurSetReq(%Position, @P.C.CIX, i, %True)              ' Set cursor set attempt
         DoSet(%Refresh)                                          ' Have it looked at
      ELSE                                                        '
         me.CsrCol = i + @P.PGapCol - @P.POffset                  '
      END IF                                                      '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  PTBS()                                                 '
   '-----------------------------------------------------------------------------------------------+
   '- Do a PC type Bksp function in PowerType mode                                                 |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k AS LONG                                      '
      '--------------------------------------------------------------------------------------------+
      '- Do it if there's room                                                                     |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CCol > @P.PDataCol THEN                             ' Room to BKSP?

         '-----------------------------------------------------------------------------------------+
         '- Repeat for each line in the PT group                                                   |
         '-----------------------------------------------------------------------------------------+
         FOR k = 1 TO gPTblCount                                  ' Loop for each PT line
            j = gPTbl(k).sRow                                     ' Get screen row
            ix = gPTbl(k).tLin                                    ' Get IX of real data line
            IF @P.C.CCol > @P.PDataCol AND IsLData(ix) THEN       ' Room to BKSP?
               me.ModSet(ix)                                      ' Remember we changed something
               i = @P.C.CLCol                                     ' Calc IX into the Text
               me.LTxtCharDel(ix, i - 1)                          ' Delete 1 char
               me.LAttrAdjust(ix, i, -1)                          ' Adjust any Attr hilite
               me.UCIfNeeded(ix)                                  ' UC if CAPS ON
               me.AttrScan(ix)                                    ' Recolorize

               '-----------------------------------------------------------------------------------+
               '- If the line is visible on the screen, re-display it                              |
               '-----------------------------------------------------------------------------------+
               IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible Re-display the line
            END IF                                                '
         NEXT k                                                   '
         me.CsrColSub(1)                                          ' Adjust cursor
      ELSE                                                        '
         DoBeep                                                   ' Beep if not possible
      END IF                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTChar()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Process normal character in PowerType Mode                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, ix AS LONG, t AS STRING, tc AS WSTRING          '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Do for each line in the PT Group                                                          |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line

         '-----------------------------------------------------------------------------------------+
         '- Do the non-Insert mode style                                                           |
         '-----------------------------------------------------------------------------------------+
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            j = gPTbl(k).sRow                                     ' Get screen row
            ix = gPTbl(k).tLin                                    ' Get IX of real data line
            IF ISFALSE IsLData(ix) THEN ITERATE FOR               ' Only Data lines
            me.ModSet(ix)                                         ' Remember we changed something
            i = @P.C.CLCol                                        ' Calc index into string
            IF i > LEN(L(ix).@LTxt) THEN me.LTxtSet(ix, LSET$(LTxtG(ix), i))  ' Past the right end? Then lengthen string
            me.LTxtCharRep(ix, i, gKeyChr)                        ' Insert the character

            '--------------------------------------------------------------------------------------+
            '- Do the CAPS thing and re-display if line is on the screen                           |
            '--------------------------------------------------------------------------------------+
            me.UCIfNeeded(ix)                                     ' UC if CAPS ON
            me.AttrScan(ix)                                       ' Recolorize
            IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line

         '-----------------------------------------------------------------------------------------+
         '- Do the Insert mode style                                                               |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     ' Do all the same stuff in Insert mode
            j = gPTbl(k).sRow                                     ' Get screen row
            ix = gPTbl(k).tLin                                    ' Get IX of real data line
            IF ISFALSE IsLData(ix) THEN ITERATE FOR               ' Only Data lines
            me.ModSet(ix)                                         ' Remember we changed something
            i = @P.C.CLCol                                        ' Calc index into string
            t = LTxtG(ix)                                         ' Get Text
            tc = LAttrG(ix)                                       '
            me.DataInsert(t, tc, gKeyChr, i)                      ' Insert it

            '--------------------------------------------------------------------------------------+
            '- Do the CAPS thing and re-display if line is on the screen                           |
            '--------------------------------------------------------------------------------------+
            LTxtS(ix) = t                                         ' Save back
            LAttrS(ix) = tc                                       '
            me.UCIfNeeded(ix)                                     ' UC if CAPS ON
            me.AttrScan(ix)                                       ' Recolorize
            IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line

         END IF                                                   '
      NEXT k                                                      ' Next PT line
      me.krRight                                                  ' We can finally move over to the next column
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTCopyPaste()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- Do Copy or Paste depending on whether selected in PT mode                                    |
   '-----------------------------------------------------------------------------------------------+
      IF IsMarkActive AND IsMarkDrawn THEN                        ' Is something selected
         me.krKCpy                                                ' yes, COPY it
      ELSE                                                        '
         me.PTPaste                                               ' No? Then do a Paste
         TP.LastPTCurs = 0                                        ' Force cursor to draw
         DoCursor                                                 ' To get back | | lines
      END IF                                                      '
   END METHOD                                                     '

   METHOD  PTCopyPasteAdd()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Block copypaste in RAW APPEND mode                                                           |
   '-----------------------------------------------------------------------------------------------+
      gKeyPrimOper = "$RAA" + gKeyPrimOper                        ' Tell PTCopyPaste it's RAW mode
      me.PTCopyPaste()                                            ' Let IT do the work
   END METHOD                                                     '

   METHOD  PTCopyPasteRaw()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Block copypaste in RAW mode                                                                  |
   '-----------------------------------------------------------------------------------------------+
      gKeyPrimOper = "$RAW" + gKeyPrimOper                        ' Tell PTCopyPaste it's RAW mode
      me.PTCopyPaste()                                            ' Let IT do the work
   END METHOD                                                     '

   METHOD  PTCtlLeft()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Tab Left one 'word'- in PowerType mode                                                       |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j AS LONG                                         '
   LOCAL t, CS AS STRING                                          '

      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Get the line we're on                                                                     |
      '--------------------------------------------------------------------------------------------+
      ix = gPTbl(1).tLin                                          ' Locate data line cursor was on
      t = RTRIM$(LTxtG(ix))                                       ' Get a copy of the text
      i = @P.C.CLCol                                              ' Where is cursor now
      CS = gENV.CharSet                                           ' Get local copy
      '--------------------------------------------------------------------------------------------+
      '- Handle col 1, the simple one                                                              |
      '--------------------------------------------------------------------------------------------+
      IF i = 1 THEN MExitMeth                                     ' Column 1? Do nothing

      '--------------------------------------------------------------------------------------------+
      '- Past the end, go to last word                                                             |
      '--------------------------------------------------------------------------------------------+
      IF i > LEN(RTRIM$(t)) THEN                                  ' At or past last char?
         GOSUB CurrLastWord                                       ' Go to Last Word

      '--------------------------------------------------------------------------------------------+
      '- Backup one word                                                                           |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' Within line, find next location

         '-----------------------------------------------------------------------------------------+
         '- Sitting on a blank                                                                     |
         '-----------------------------------------------------------------------------------------+
         IF MID$(t, i, 1) = " " THEN                              ' Currently sitting on a blank?
            j = INSTR(-(LEN(t) - i) - 2, t, ANY CS)               ' Look for prev visible character
            j = INSTR(-(LEN(t) - j)  - 2, t, " ") + 1             ' Look for prev blank
            IF j = 0 THEN                                         ' None?
               MExitMeth                                          ' Do nothing
            ELSE                                                  ' We've got the next 'word'
               IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, ix, j, %True)           ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               '
                  me.CsrCol = j + @P.PGapCol - @P.POffset         ' Just move cursor on the screen
               END IF                                             '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- Sitting on an actual character                                                         |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     ' We're sitting on a character

            '--------------------------------------------------------------------------------------+
            '- 1st character of a word                                                             |
            '--------------------------------------------------------------------------------------+
            IF i > 1 AND MID$(t, i - 1, 1) = " " THEN             ' Are we sitting on the 1st char of a word?
               j = INSTR(-(LEN(t) - i) - 3, t, ANY CS)            ' Look for prev visible character
               j = INSTR(-(LEN(t) - j) - 2, t, " ") + 1           ' Look for prev blank
               IF j = 0 THEN                                      ' None?
                  MExitMeth                                       ' Do nothing
               ELSE                                               ' We've got the next 'word'
                  IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                     me.CurSetReq(%Position, ix, j, %True)        ' No, Set cursor set attempt
                     DoSet(%Refresh)                              ' Have it looked at
                  ELSE                                            '
                     me.CsrCol = j + @P.PGapCol - @P.POffset      ' Just move cursor on the screen
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Non 1st char of word                                                                |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  ' Sitting on other than 1st char of word
               j = INSTR(-(LEN(t) - i) - 2, t, " ") + 1           ' Look for prev blank + 1
               IF j = 0 THEN                                      ' None?
                  MExitMeth                                       ' Do Nothing
               ELSE                                               ' We've got the next 'word'
                  IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                     me.CurSetReq(%Position, ix, j, %True)        ' No, Set cursor set attempt
                     DoSet(%Refresh)                              ' Have it looked at
                  ELSE                                            '
                     me.CsrCol = j + @P.PGapCol - @P.POffset      ' Just move cursor on the screen
                  END IF                                          '
               END IF                                             '
            END IF                                                '
        END IF                                                    '
     END IF                                                       '
     MExitMeth                                                    ' We're done

   '-----------------------------------------------------------------------------------------------+
   '- Go to last word                                                                              |
   '-----------------------------------------------------------------------------------------------+
   CurrLastWord:                                                  '
      j = INSTR(-1, t, " ")                                       ' Look for last blank
      IF j <> 0 THEN INCR j                                       ' 1st char of last word
      j = MAX(1, j)                                               ' If not found, set to 1
      IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
         me.CurSetReq(%Position, ix, j, %True)                    ' No, Set cursor set attempt
         DoSet(%Refresh)                                          ' Have it looked at
      ELSE                                                        '
         me.CsrCol = j + @P.PGapCol - @P.POffset                  ' Just move cursor on the screen
      END IF                                                      '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  PTCtlRight()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Tab right one 'word' in PowerType mode                                                       |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j AS LONG                                         '
   LOCAL t, CS AS STRING                                          '

      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Get line we're on                                                                         |
      '--------------------------------------------------------------------------------------------+
      ix = gPTbl(1).tLin                                          ' Locate data line cursor was on
      t = RTRIM$(LTxtG(ix)) + " "                                 ' Get a copy of the text (+ 1 blank)
      i = @P.C.CCol + @P.POffset - @P.PGapCol                     ' Where is cursor now
      CS = gENV.CharSet                                           ' Get local copy
      '--------------------------------------------------------------------------------------------+
      '- If past end of line, do nothing                                                           |
      '--------------------------------------------------------------------------------------------+
      IF i > LEN(RTRIM$(t)) THEN                                  ' At or past last char?
         MExitMeth                                                ' Do nothing

      '--------------------------------------------------------------------------------------------+
      '- Somewhere within the line                                                                 |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' Within line, find next location

         '-----------------------------------------------------------------------------------------+
         '- Sitting ON a character                                                                 |
         '-----------------------------------------------------------------------------------------+
         IF MID$(t, i, 1) <> " " THEN                             ' Currently sitting on a char?
            j = INSTR(i + 1, t, " ")                              ' Look for next blank
            j = INSTR(j + 1, t, ANY CS)                           ' Look for next visible character
            IF j = 0 THEN                                         ' None?
               MExitMeth                                          ' Do Nothing
            ELSE                                                  ' We've got the next 'word'
               IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, ix, j, %True)           ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               '
                  me.CsrCol = j + @P.PGapCol - @P.POffset         ' Just move cursor on the screen
               END IF                                             '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- Sitting ON a blank                                                                     |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     ' We're sitting on a blank
            j = INSTR(i + 1, t, ANY CS)                           ' Look for next visible character
            IF j = 0 THEN                                         ' None?
               MExitMeth                                          ' Do nothing
            ELSE                                                  ' We've got the next 'word'
               IF j < @P.POffset + 1 OR j > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
                  me.CurSetReq(%Position, ix, j, %True)           ' No, Set cursor set attempt
                  DoSet(%Refresh)                                 ' Have it looked at
               ELSE                                               '
                  me.CsrCol = j + @P.PGapCol - @P.POffset         ' Just move cursor on the screen
               END IF                                             '
            END IF                                                '
        END IF                                                    '
     END IF                                                       '
     MExit                                                        '
   END METHOD                                                     '

   METHOD  PTCut()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Cut selected columns in PT mode                                                              |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, k, ix AS LONG, lclTxt, CBD AS STRING                  '
      '--------------------------------------------------------------------------------------------+
      '- OK, build the Clipboard string                                                            |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE IsMarkActive THEN EXIT METHOD                    ' Nothing marked? Do nothing
      CBD = ""                                                    ' Start as ""
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         lclTxt = LTxtG(ix)                                       ' Get the text
         IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
         lclTxt = MID$(lclTxt, MarkRect.Left TO MarkRect.Right)   ' Extract the columns
         IF k = 1 THEN CBD += lclTxt + $CRLF                      ' Only the 1st line goes to the CBD
         lclTxt = LTxtG(ix)                                       ' Get the text again
         lclTxt = STRDELETE$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete the characters
         me.LAttrAdjust(ix, MarkRect.Left, -(MarkRect.Right - MarkRect.Left + 1))   ' Adjust any Attr hilite
         me.LTxtSet(ix, lclTxt)                                   ' Put work string back
         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '

      '-----------------------------------------------------------------------------------------+
      '- Stuff it in the clipboard                                                              |
      '-----------------------------------------------------------------------------------------+
      IF ISNOTNULL(CBD) THEN                                      ' If not null
         IF ClipboardWrite(CBD) THEN _                            ' Write it
            me.MarkKill                                           ' Reset the select frame
      END IF                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTDataDelBS(which AS STRING)                           '
   LOCAL ix, x, y, GotColumns, i, j, k AS LONG, lclTxt, lh AS STRING '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      IF which = "B" THEN me.CsrCol = @P.C.CCol - 1               ' Move cursor back if this is a backspace

      FOR k = 1 TO gPTblCount                                     ' Do for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc IX into the Text
         IF which = "B" THEN i = IIF(i = 1, 1, i - 1)             ' Point at prev char if this is a backspace

         '-----------------------------------------------------------------------------------------+
         '- See if any 'columns' in the data                                                       |
         '-----------------------------------------------------------------------------------------+
         lclTxt = LTxtG(ix)                                       ' Get the text
         x = INSTR(i, lclTxt, " ")                                ' Look for at least 2 blanks following found string
         IF x THEN                                                ' If we 've got spare blanks
            FOR y = x TO LEN(lclTxt)                              ' Look through remainder of line for a non- blank
               IF MID$(lclTxt, y, 1) <> " " THEN                  ' Got one?
                  GotColumns = %True                              ' Remember we have columns
                  EXIT FOR                                        ' Exit, y - 1 is split point for lh/rh
               END IF                                             '
            NEXT y                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- There are columns do it the hard way                                                   |
         '-----------------------------------------------------------------------------------------+
         IF GotColumns THEN                                       ' Data Insert AND columns?
            lh = LEFT$(lclTxt, y - 2)                             ' Create full lh portion
            lh = STRDELETE$(lh, i, 1) + " "                       ' Delete char and add a blank
            lclTxt = lh + MID$(lclTxt, y - 1)                     ' Re-build the altered text
            me.LTxtSet(ix, lclTxt)                                ' Save it back
         ELSE                                                     '
            me.LTxtCharDel(ix, i)                                 ' Delete 1 char
            me.LAttrAdjust(ix, i, -1)                             ' Adjust any Attr hilite
         END IF                                                   '

         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTDate()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Paste Date at cursor location in PowerType mode                                              |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = DateWinFormat()                                        ' Go get the date
      me.PTTDPaste(ln)                                            ' Go to common routine
   END METHOD                                                     '

   METHOD  PTDel()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Delete character at current position in PowerType Mode                                       |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k AS LONG, lclTxt AS STRING                    '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      IF IsMarkActive THEN                                        ' Is something selected?
         me.MarkKill                                              ' Reset the select frame

         '-----------------------------------------------------------------------------------------+
         '- OK, now do the Delete based on the marked column range                                 |
         '-----------------------------------------------------------------------------------------+
         FOR k = 1 TO gPTblCount                                  ' Do for each PT line
            j = gPTbl(k).sRow                                     ' Get screen row
            ix = gPTbl(k).tLin                                    ' Get IX of real data line
            IF ISFALSE IsLData(ix) THEN ITERATE FOR               ' Only Data lines
            me.ModSet(ix)                                         ' Remember we changed something
            lclTxt = LTxtG(ix)                                    ' Get the text
            lclTxt = STRDELETE$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete the characters
            me.LAttrAdjust(ix, MarkRect.Left, -(MarkRect.Right - MarkRect.Left + 1))   ' Adjust any Attr hilite
            me.LTxtSet(ix, lclTxt)                                ' Put work string back
            me.UCIfNeeded(ix)                                     ' UC if CAPS ON
            me.AttrScan(ix)                                       ' Recolorize
            IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
         NEXT k                                                   '
         me.CsrCol = MarkRect.Left - @P.POffset + @P.PGapCol      ' Position cursor
         TP.LastPTCurs = 0                                        ' Force cursor to draw
         DoCursor                                                 ' To get back | | lines
         MExitMeth                                                '
      END IF                                                      '

      FOR k = 1 TO gPTblCount                                     ' Do for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc IX into the Text
         me.LTxtCharDel(ix, i)                                    ' Delete 1 char
         me.LAttrAdjust(ix, i, -1)                                ' Adjust any Attr hilite
         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTDup()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Duplicate prior line into the marked block                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, ix AS LONG, lclTxt, t AS STRING                 '
      '--------------------------------------------------------------------------------------------+
      '- Get the data from the previous line                                                       |
      '--------------------------------------------------------------------------------------------+
      i = me.CrpBack(%mData, MarkRect.Top, 1)                     ' Get address of prev data line
      IF ISFALSE IsLData(i) THEN DoBeep: EXIT METHOD              ' Beep and exit if no prior
      t = LTxtG(i)                                                ' Get text from the previous line
      IF LEN(t) < MarkRect.Right THEN t = LSET$(t, MarkRect.Right)   ' If line shorter than select columns, lengthen it
      t = MID$(t, MarkRect.Left TO MarkRect.Right)                ' Get the string to be Dup'd

      '--------------------------------------------------------------------------------------------+
      '- Loop now through the PT lines                                                             |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         lclTxt = LTxtG(ix)                                       ' Get the text
         IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
         MID$(lclTxt, MarkRect.Left TO MarkRect.Right) = t        ' Extract the columns
         me.LTxtSet(ix, lclTxt)                                   ' Save it back
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '

      '--------------------------------------------------------------------------------------------+
      '- We're done, clean up and exit                                                             |
      '--------------------------------------------------------------------------------------------+
      me.MarkKill                                                 ' Reset the select frame
      me.CurSetReq(%LineCmd, MarkRect.Top, MarkRect.Left, %True)  ' Set cursor set attempt
      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  PTEnter                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Enter in PT mode                                                                             |
   '-----------------------------------------------------------------------------------------------+
      '--------------------------------------------------------------------------------------------+
      '- Kludge to get LEFT / RIGHT through in PType Mode                                          |
      '--------------------------------------------------------------------------------------------+
      IF IsEQ(TRIM$(pCommand), "LEFT") THEN                       ' Sneak LEFT through
         pCommand = ""                                            ' Blow the command away
         me.PTLeftScroll                                          ' Simulate a left Scroll
      ELSEIF IsEQ(TRIM$(pCommand), "RIGHT") THEN                  ' Sneak RIGHT through
         pCommand = ""                                            ' Blow the command away
         me.PTRightScroll                                         ' Simulate a right Scroll
      ELSE                                                        ' Else normal ENTER
         OffPTypeMode                                             ' Turn off PowerType
         gPTblCount = 0                                           '
         TP.ErrMsgReset                                           '
         me.krEnter                                               '
         DoSet(%Refresh)                                          '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  PTEnum(which AS STRING)                                '
   '-----------------------------------------------------------------------------------------------+
   '- Do the Enum function                                                                         |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k, enumz, ln AS LONG                           '
   LOCAL menum AS DWORD                                           '
   LOCAL t, tt, mprefix, msuffix, digits AS STRING                '
      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Do some basic setup                                                                       |
      '--------------------------------------------------------------------------------------------+
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      digits = $Numeric: IF which <> "D" THEN digits = $Hex + "abcdef"  ' Set the valid 'digits' string
      ix = gPTbl(1).tLin                                          ' Get IX of 1st PT line
      me.MarkKill                                                 ' Reset the select frame
      t = LTxtG(ix)                                               ' Get the text line
      IF LEN(t) < MarkRect.Right THEN t = LSET$(t, MarkRect.Right)   ' Padd if needed
      t = MID$(t, MarkRect.Left TO MarkRect.Right)                ' Extract the columns containg the model

      '--------------------------------------------------------------------------------------------+
      '- See if there's a suffix                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF INSTR(digits, RIGHT$(t, 1)) > 0 THEN                     ' If it ends in a digit,
         msuffix = ""                                             ' then there is NO suffix
      ELSE                                                        ' Non-digit, we must extract the suffix
         i = INSTR(-1, t, ANY digits)                             ' Look for the last digit
         IF i = 0 THEN                                            ' None? whoops
            tt = "Enum model has no starting value"               '
            GOSUB DispMsg                                         '
            MExitMeth                                             '
         END IF                                                   '
         msuffix = MID$(t, i + 1)                                 ' Found digit, extract suffix
         t = LEFT$(t, i)                                          ' Strip it off the model
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now extract the prefix                                                                    |
      '--------------------------------------------------------------------------------------------+
      j = 0                                                       ' Reset j
      FOR i = LEN(t) TO 1 STEP -1                                 ' Look backward for 1st non-digit
         IF INSTR(digits, MID$(t, i, 1)) > 0 THEN ITERATE FOR     ' If a digit, keep looking
         j = i: EXIT FOR                                          ' Found a non digit, save its loc and exit for
      NEXT i                                                      '
      IF j = 0 THEN                                               ' All were digits
         mprefix = ""                                             ' Therefor no prefix
      ELSE                                                        ' Non-digit, we have a prefix
         mprefix = LEFT$(t, j)                                    ' Save prefix
         t = MID$(t, j + 1)                                       ' Extract it leaving t as the eval string.
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Extract the enum value                                                                    |
      '--------------------------------------------------------------------------------------------+
      ln = LEN(t)                                                 ' Save length for rebuilding
      IF which = "D" THEN                                         ' Decimal Enum?
         menum = VAL(t)                                           ' Save it
         IF LEN(t) <> LEN(FORMAT$(menum)) THEN enumz = %True      ' Entered as leading zeros?, remember that
      ELSE                                                        ' One of the Hex
         menum = VAL("&H" + t)                                    ' Save it that way
         IF LEN(t) <> LEN(HEX$(menum)) THEN enumz = %True         ' Entered as leading zeros?, remember that
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now modify the PT lines                                                                   |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         tt = LTxtG(ix)                                           ' Get working copy of text
         IF LEN(tt) < MarkRect.Right THEN tt = LSET$(tt, MarkRect.Right)   ' Padd if needed

         '-----------------------------------------------------------------------------------------+
         '- Select which Enum type to do                                                           |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE AS CONST$ which                              ' Build output string
            CASE "D"                                              ' Decimal
               t = FORMAT$(menum)                                 '
               GOSUB AdjustPad                                    ' Do padding etc.
            CASE "L"                                              ' Lowercase Hex
               t = LLCASE(HEX$(menum))                            '
               GOSUB AdjustPad                                    ' Do padding etc.
            CASE "U"                                              ' Lowercase Hex
               t = HEX$(menum)                                    '
               GOSUB AdjustPad                                    ' Do padding etc.
         END SELECT                                               '

         '-----------------------------------------------------------------------------------------+
         '- Build the value and stuff it in                                                        |
         '-----------------------------------------------------------------------------------------+
         t = mprefix + t + msuffix                                ' Add prefix and suffix
         t = RIGHT$(RSET$(t, MarkRect.Right - MarkRect.Left + 1), MarkRect.Right - MarkRect.Left + 1) ' Right align and trim it
         MID$(tt, MarkRect.Left, LEN(t)) = t                      ' Overlay the enum text
         me.LTxtSet(ix, tt)                                       ' Save it back
         me.AttrScan(ix)                                          ' Recolorize

         '-----------------------------------------------------------------------------------------+
         '- If on the screen, display it                                                           |
         '-----------------------------------------------------------------------------------------+
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
         menum += gEnumWith                                       ' Incr enum for next line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExitMeth                                                   '

   '-----------------------------------------------------------------------------------------------+
   '- Fiddle with the prefix padding                                                               |
   '-----------------------------------------------------------------------------------------------+
   AdjustPad:                                                     '
      IF LEN(t) > ln AND RIGHT$(mprefix, 1) = " " THEN            ' If enum needs more room, and Prefix has some
         mprefix = CLIP$(RIGHT, mprefix, 1)                       ' Steal right hand blank from prefix
         INCR ln                                                  ' Make enum longer
      ELSEIF LEN(t) > ln AND LEFT$(mprefix, 1) = " " THEN         ' If not right end, try left end
         mprefix = MID$(mprefix, 2)                               ' Steal left hand blank from prefix
         INCR ln                                                  ' Make enum longer
      END IF                                                      '
      IF LEN(t) > ln AND RIGHT$(msuffix, 1) = " " THEN            ' If enum needs more room, and Suffix has some
         msuffix = CLIP$(RIGHT, msuffix, 1)                       ' Steal right hand blank from suffix
         INCR ln                                                  ' Make enum longer
      ELSEIF LEN(t) > ln AND LEFT$(msuffix, 1) = " " THEN         ' If not right end, try left end
         msuffix = MID$(msuffix, 2)                               ' Steal left hand blank from suffix
         INCR ln                                                  ' Make enum longer
      END IF                                                      '
      IF enumz THEN                                               ' Pad appropriately
         t = RIGHT$(REPEAT$(ln, "0") + t, ln)                     '
      ELSE                                                        '
         t = RIGHT$(REPEAT$(ln, " ") + t, ln)                     '
      END IF                                                      '
      RETURN                                                      '

   '-----------------------------------------------------------------------------------------------+
   '- Temporarily display an error message                                                         |
   '-----------------------------------------------------------------------------------------------+
   DispMsg:                                                       '
      t = STRING$(gENV.ScrWidth - LEN(tt), "_")                   ' Build LH part of dash line
      DoPrint (t, $$TxtLo, 2, 1)                                  ' Print LH part of line 2
      DoPrint (tt, $$Error, 2, gENV.ScrWidth - LEN(tt) + 1)       ' Print rest of line
      GRAPHIC REDRAW                                              '
      SLEEP 1500                                                  '
      tt = "Entering PowerType mode, Press Enter to exit"         '
      DoPrint (t, $$TxtLo, 2, 1)                                  ' Print LH part of line 2
      DoPrint (tt, $$Error, 2, gENV.ScrWidth - LEN(tt) + 1)       ' Print rest of line
      GRAPHIC REDRAW                                              '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  PTEOL()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- EOL key in PowerType mode                                                                    |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k AS LONG                                      '
      '--------------------------------------------------------------------------------------------+
      '- Ripple through the PT lines doing it                                                      |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc index into string
         me.LTxtSet(ix, LEFT$(LTxtG(ix), i - 1))                  ' Truncate the line then
         LAttrS(ix) = LEFT$(LAttrG(ix), i - 1)                    ' Truncate the Attr
         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTErase()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Erase selected columns from the PT range                                                     |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, k, ix AS LONG, lclTxt AS STRING                       '
      IF ISFALSE IsMarkActive THEN DoBeep: EXIT METHOD            ' Better be something selected

      '--------------------------------------------------------------------------------------------+
      '- OK, now do the erase                                                                      |
      '--------------------------------------------------------------------------------------------+
      me.MarkKill                                                 ' Reset the select frame
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         lclTxt = LTxtG(ix)                                       ' Get the text
         IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
         MID$(lclTxt, MarkRect.Left TO MarkRect.Right) = SPACE$(MarkRect.Right - MarkRect.Left + 1)   ' Blank it
         me.LTxtSet(ix, lclTxt)                                   ' Put work string back
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTISODate()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Paste ISO Date at cursor location in PowerType mode                                          |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = DATE$                                                  ' Go get the date
      ln = MID$(ln, 7) + "-" + LEFT$(ln, 2) + "-" + MID$(ln, 4, 2)   ' Reformat it to ISO standard
      me.PTTDPaste(ln)                                            ' Go to common routine
   END METHOD                                                     '

   METHOD  PTISOTime()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Paste ISO Time at cursor location in PowerType mode                                          |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = TIME$                                                  ' Go get the time
      me.PTTDPaste(ln)                                            ' Go to common routine
   END METHOD                                                     '

   METHOD  PTJustify()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Justify a selected block in PowerType mode                                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, k, ix AS LONG, lclTxt, jtxt, ttxt AS STRING           '
      me.MarkKill                                                 ' Reset the select frame
      '--------------------------------------------------------------------------------------------+
      '- OK, now do the justify                                                                    |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         lclTxt = LTxtG(ix)                                       ' Get the text
         me.ModSet(ix)                                            ' Remember we changed something
         IF LEN(lclTxt) < MarkRect.Right THEN _                   ' Lengthen text if needed
            lclTxt = LSET$(lclTxt, MarkRect.Right)                '
         jtxt = MID$(lclTxt, MarkRect.Left TO MarkRect.Right)     ' Get the string to be justified

         '-----------------------------------------------------------------------------------------+
         '- Select which Justify is needed                                                         |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE AS CONST$ gKeyChr                            ' Do the right type of justify
            CASE "JUSTIFYL": jtxt = LSET$(LTRIM$(jtxt), LEN(jtxt))   '
            CASE "JUSTIFYR": jtxt = RSET$(RTRIM$(jtxt), LEN(jtxt))   '
            CASE "JUSTIFYC": ttxt = SPACE$(LEN(jtxt)): jtxt = TRIM$(jtxt)  '
                             MID$(ttxt, (LEN(ttxt) - LEN(jtxt)) \ 2 + 1, LEN(jtxt)) = jtxt   '
                             jtxt = ttxt                          '
         END SELECT                                               '
         MID$(lclTxt, MarkRect.Left TO MarkRect.Right) = jtxt     ' Re-insert the string
         me.LTxtSet(ix, lclTxt)                                   ' Put work string back
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTLastTab()                                            '
   '-----------------------------------------------------------------------------------------------+
   '- Tab To the Last Tab marker                                                                   |
   '-----------------------------------------------------------------------------------------------+
   MEntry                                                         '
   LOCAL i, j, k AS LONG, lclTabs AS STRING                       '
      j = gPTbl(1).tLin                                           ' Get Line number of cursor line
      lclTabs = me.TabsSimple(LEN(L(j).@LTxt))                    ' Get a working tabs line
      i = INSTR(FCB.TabsLine, "+")                                ' + type tabs

      '--------------------------------------------------------------------------------------------+
      '- If extensible tabs, just use last *                                                       |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE i THEN                                           ' Can't do LastTab with extensible tabs
         k = 0                                                    ' Say no next ine
         IF ISFALSE FCB.Tabs THEN MExitMeth                       ' If not tabbing
         i = INSTR(-1, lclTabs, "*")                              ' look for last tab marker
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If no + (or adjusted to last *)                                                           |
      '--------------------------------------------------------------------------------------------+
      IF i THEN                                                   ' we have one
         IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
            me.CurSetReq(%Position, j, i, %True)                  ' No, Set cursor set attempt
            DoSet(%Refresh)                                       ' Have it looked at
            MExitMeth                                             '
         ELSE                                                     '
            me.CsrCol = i + @P.PGapCol - @P.POffset               ' Just move cursor on the screen
            MExitMeth                                             '
         END IF                                                   '
      ELSE                                                        ' ?? No tabs?
         me.CsrCol = @P.PDataCol - @P.POffset                     ' Just move cursor on the screen
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTLeft()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Decrement CsrCol in PowerType mode                                                           |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix AS LONG                                               '
      me.CsrColSub(1)                                             ' Simple DECR
      IF @P.C.CCol = @P.PGapCol AND @P.POffset > 0 THEN           ' At left side of screen and room to scroll?
         me.CsrColAdd(1)                                          ' Yes, Undo the DECR for now
         ix = gPTbl(1).tLin                                       ' Locate data line cursor was on
         me.CurSetReq(%Position, ix, @P.C.CCol + @P.POffset - @P.PGapCol - 1, %False)  ' Set cursor set attempt
         me.OffsetSub(1)                                          ' Drop the offset
         DoSet(%Refresh)                                          ' Have it looked at
      ELSEIF @P.C.CCol = @P.PGapCol THEN                          ' At left end and no scroll possible
         me.CsrColAdd(1)                                          ' Put things back
         DoBeep                                                   '
      END IF                                                      '
   END METHOD                                                     '

   METHOD  PTLift()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Copy and Erase selected columns from the PT range                                            |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, k, ix AS LONG, lclTxt, ltxt2, CBD AS STRING           '

      MEntry                                                      '
      IF ISFALSE (IsMarkActive) THEN MexitMeth                    ' Nothing marked? Do nothing
      CBD = ""                                                    ' Start as null

      '--------------------------------------------------------------------------------------------+
      '- OK, now do the erase                                                                      |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         lclTxt = LTxtG(ix)                                       ' Get the text
         IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
         lTxt2 = MID$(lclTxt, MarkRect.Left TO MarkRect.Right)    ' Extract the columns
         CBD += lTxt2 + $CR + $LF                                 ' Add each line with CR/LF
         MID$(lclTxt, MarkRect.Left TO MarkRect.Right) = SPACE$(MarkRect.Right - MarkRect.Left + 1)   ' Blank it
         me.LTxtSet(ix, lclTxt)                                   ' Put work string back
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Stuff it in the clibboard                                                                 |
      '--------------------------------------------------------------------------------------------+
      IF ClipboardWrite(CBD) THEN                                 ' Write it
         me.MarkKill                                              ' Reset the select frame
      END IF                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTLEFTScroll()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Scroll LEFT in PowerType mode                                                                |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ScrAmt AS LONG, ScrCmd AS STRING                         '
      IF @P.POffset = 0 THEN DoBeep: EXIT METHOD                  ' Already at the left?  Bail oput

      '--------------------------------------------------------------------------------------------+
      '- Get the amount to scroll                                                                  |
      '--------------------------------------------------------------------------------------------+
      ScrCmd = FCB.ScrollAmt                                      ' Pick up default scroll amount
      IF VAL(ScrCmd) <> 0 THEN                                    ' A Number?
         ScrAmt = VAL(ScrCmd)                                     ' Yes, use it
      ELSEIF ScrCmd = "HALF" THEN                                 ' Half?
         ScrAmt = INT(@P.PDataLen / 2)                            ' Yes, set it
      ELSEIF ScrCmd = "PAGE" THEN                                 ' Page?
         ScrAmt = @P.PDataLen                                     ' Yes, set it
      ELSEIF ScrCmd = "FULL" THEN                                 ' Full?
         ScrAmt = @P.PDataLen                                     ' Yes, set it
      ELSEIF ScrCmd = "DATA" THEN                                 ' Data?
         ScrAmt = @P.PDataLen - 1                                 ' Yes, set it
      ELSEIF IsCData THEN                                         ' No, In data area?
         ScrAmt = @P.C.CCol - @P.PDataCol                         ' Yes, move cursor to left of screen
         IF ScrAmt = 0 THEN ScrAmt = @P.PDataLen - 1              ' If already there go a default amount
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now adjust things                                                                         |
      '--------------------------------------------------------------------------------------------+
      @P.POffset = MAX(@P.POffset - ScrAmt, 0)                    '
      me.CurSetReq(%Position, gPTbl(1).tLin, @P.C.CCol - @P.PGapCol + @P.POffset + ScrAmt, %False) '
      me.CsrMode                                                  ' Refresh Csr data
      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  PTLowerCase()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- LowerCase a selected block in PowerType mode                                                 |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, ix AS LONG, lclTxt AS STRING                    '
      IF ISFALSE IsMarkActive THEN DoBeep: EXIT METHOD            ' Better be something selected, else exit
      me.MarkKill                                                 ' Reset the select frame
      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Lowercase                                                                  |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         lclTxt = LTxtG(ix)                                       ' Get the text
         me.ModSet(ix)                                            ' Remember we changed something
         IF MarkRect.Left <= LEN(lclTxt) THEN                     ' Do only if long enough
            FOR i = MarkRect.Left TO MIN(MarkRect.Right, LEN(lclTxt))   ' Just ones that are there
               MID$(lclTxt, i, 1) = LLCASE(MID$(lclTxt, i, 1))    '
            NEXT i                                                '
            me.LTxtSet(ix, lclTxt)                                ' Put work string back
            me.AttrScan(ix)                                       ' Recolorize
            IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
         END IF                                                   '
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTMarkc(Dir AS STRING, Pass AS DWORD)                  '
   '-----------------------------------------------------------------------------------------------+
   '- Conditionally Mark a block                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE IsMarkActive THEN me.PTMark(Dir, Pass)              ' If no Marked area, start one
   END METHOD                                                     '

   METHOD  PTMark(Dir AS STRING, Pass AS DWORD)                   '
   '-----------------------------------------------------------------------------------------------+
   '- Mark a block                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   LOCAL Lin, sCol AS LONG                                        '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      IF ISFALSE IsCData OR FCB.HexMode = &4  THEN CALL DWORD Pass: MExitMeth ' Not in the Data area or HEX? Treat as non-shifted key

      '--------------------------------------------------------------------------------------------+
      '- Only handle valid ones in PT mode                                                         |
      '--------------------------------------------------------------------------------------------+
      IF Dir <> "L" AND Dir <> "R" AND Dir <> "E" THEN MExitMeth  ' Ignore non L/R/E
      Lin = me.SGet(@P.C.CRow)                                    ' Get IX of real data line
      sCol = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc index into string

      '--------------------------------------------------------------------------------------------+
      '- Better be a marked area                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF IsMarkActive THEN                                        ' If we already have a Marked area
         IF Lin < MarkRect.Top OR Lin > MarkRect.Bottom OR _      ' Somehow outside it's boundaries?
            sCol < MarkRect.Left OR sCol > MarkRect.Right THEN    '
            me.MarkKill                                           ' Kill it and leave cursor alone
            MExitMeth                                             '
         END IF                                                   '
         IF Lin > MarkRect.Top AND Lin < MarkRect.Bottom AND _    ' Somehow within the bounds?
            sCol > MarkRect.Left AND sCol < MarkRect.Right THEN _ '
            CALL DWORD Pass: MExitMeth                            ' Just move the cursor

         '-----------------------------------------------------------------------------------------+
         '- Move boundary based on direction asked for                                             |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE dir                                          ' Adjust boundaries
            CASE "L"                                              ' Left
               IF sCol = MarkRect.Left AND MarkRect.Left > 1 THEN ' At left and got room?
                  MarkRect.Left = MarkRect.Left - 1               ' Move left boundary
                  me.MarkScr                                      ' Redraw the hilight
                  CALL DWORD Pass: MExitMeth                      ' Then just move the cursor
               ELSEIF sCol = MarkRect.Right AND MarkRect.Right > MarkRect.Left THEN ' At right and have room
                  MarkRect.Right = MarkRect.Right - 1             ' Move right boundary
                  me.MarkScr                                      ' Redraw the hilight
                  CALL DWORD Pass: MExitMeth                      ' Then just move the cursor
               ELSE                                               '
                  CALL DWORD Pass: MExitMeth                      ' Just move the cursor
               END IF                                             '
               IF IsMarkActive THEN me.MarkScr                    ' Possibly redraw the highlight

            CASE "R"                                              ' Right
               IF sCol = MarkRect.Left AND MarkRect.Left < MarkRect.Right THEN   ' At left end and have room?
                  MarkRect.Left = MarkRect.Left + 1               ' Move left boundary
                  me.MarkScr                                      ' Redraw the hilight
                  CALL DWORD Pass: MExitMeth                      ' Then just move the cursor
               ELSEIF sCol = MarkRect.Right THEN                  ' At right
                  MarkRect.Right = MarkRect.Right + 1             ' Move right boundary
                  me.MarkScr                                      ' Redraw the hilight
                  CALL DWORD Pass: MExitMeth                      ' Then just move the cursor
               ELSE                                               '
                  CALL DWORD Pass: MExitMeth                      ' Just move the cursor
               END IF                                             '

            CASE "E"                                              ' End
               MarkRect.Right = LEN(RTRIM$(LTxtG(lin)))           ' Move right to text length column
               me.MarkScr                                         ' Redraw the hilight
               CALL DWORD Pass: MExitMeth                         ' Then just move the cursor

         END SELECT                                               '

      '--------------------------------------------------------------------------------------------+
      '- No current marked area                                                                    |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        '
         IF dir <> "E" THEN                                       ' If not the END case
            MarkRect.Top = Lin: MarkRect.Bottom = Lin             ' Save 1 character area
            MarkRect.Left = sCol: MarkRect.Right = sCol           '
         ELSE                                                     ' END
            MarkRect.Top = Lin: MarkRect.Bottom = Lin             ' Save area to end of text
            MarkRect.Left = sCol: MarkRect.Right = LEN(RTRIM$(LTxtG(lin))) '
            CALL DWORD Pass                                       ' Then just move the cursor
         END IF                                                   '
         OnMarkActive                                             ' We're starting a marked area
         me.MarkScr                                               '
      END IF                                                      '
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTPaste()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Paste text at cursor location in PowerType mode                                              |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k AS LONG                                      '
   LOCAL ln, t, tt, MyDLM AS STRING, tc AS WSTRING                '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Get clipboard data (1st line)                                                             |
      '--------------------------------------------------------------------------------------------+
      ClipboardRead(t, MyDLM, %False)                             ' Go get Clipboard, keep the file
      ln = EXTRACT$(t, MyDLM)                                     ' Get 1st line from Clipboard

      '--------------------------------------------------------------------------------------------+
      '- Loop now through the PT lines                                                             |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         i = @P.C.CLCol                                           ' Calc index into string
         tt = LTxtG(ix)                                           ' Get working copy of text
         tc = LAttrG(ix)                                          '
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF i + LEN(ln) - 1 > LEN(tt) THEN tt = LSET$(tt , i + LEN(ln) - 1)   ' Lengthen if needed
            MID$(tt, i, LEN(ln)) = ln                             ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            me.DataInsert(tt, tc, ln, i)                          ' Insert the data
         END IF                                                   '
         me.LTxtSet(ix, tt)                                       ' Save it back
         me.LAttrSet(ix, tc)                                      '
         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      i += LEN(ln)                                                ' Move cursor
      IF i > @P.POffset + @P.PDataLen - 1 THEN                    ' Off current screen?
         me.CurSetReq(%Position, gPTbl(1).tLin, i, %True)         ' No, Set cursor set attempt
         DoSet(%Refresh)                                          ' Have it looked at
      ELSE                                                        '
         me.CsrCol = i - @P.POffset + @P.PGapCol                  '
      END IF                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTPenBlue()                                            '
      gkeyPrimOper = "BLUE"                                       '
      me.PTPenCommon                                              '
   END METHOD                                                     '

   METHOD  PTPenGreen()                                           '
      gkeyPrimOper = "GREEN"                                      '
      me.PTPenCommon                                              '
   END METHOD                                                     '

   METHOD  PTPenRed()                                             '
      gkeyPrimOper = "RED"                                        '
      me.PTPenCommon                                              '
   END METHOD                                                     '

   METHOD  PTPenYellow()                                          '
      gkeyPrimOper = "YELLOW"                                     '
      me.PTPenCommon                                              '
   END METHOD                                                     '

   METHOD  PTPenStd()                                             '
      gkeyPrimOper = "STD"                                        '
      me.PTPenCommon                                              '
   END METHOD                                                     '

   METHOD  PTPenCommon()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- Set Pen color for a hi-lite block in PowerType mode                                          |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k, clr AS LONG, clrname AS STRING              '
      clrname = uucase(IIF$(gKeyPrimOper = "", "STD", gKeyPrimOper)) ' Get the requested color
      IF clrname = "STD" THEN                                     ' If STD, set scheme 0
         clr = 0                                                  '
      ELSE                                                        ' else look it up
         ARRAY SCAN gHiLites(), = clrname, TO clr                 ' See if a HiLite Name
      END IF                                                      '
      me.MarkKill                                                 ' Reset the select frame

      '--------------------------------------------------------------------------------------------+
      '- OK, process the lines                                                                     |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         me.ModSet(ix)                                            ' Remember we changed something
         IF ISFALSE (LFlagG(ix) AND %NonTypable) THEN             ' Just typable lines
            IF MarkRect.Left > LAttrGLen(ix) THEN ITERATE FOR     ' If past end of line, do nothing
            i = MIN(MarkRect.Right, LEN(L(ix).@LTxt))             ' Setup end of mark section
            me.AttrHiLiteSet(ix, MarkRect.Left, i, clr)           ' Set in the requested color
         END IF                                                   '
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoSet(%Refresh)                                             ' Have it looked at
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTPowerCopy()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- Copy selected columns from the PT range to the clipboard                                     |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, k, ix AS LONG, lclTxt, CBD AS STRING                  '
      '--------------------------------------------------------------------------------------------+
      '- OK, now build the Clipboard string                                                        |
      '--------------------------------------------------------------------------------------------+
      CBD = ""                                                    ' Start as ""
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         lclTxt = LTxtG(ix)                                       ' Get the text
         IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
         lclTxt = MID$(lclTxt, MarkRect.Left TO MarkRect.Right)   ' Extract the columns
         CBD += lclTxt + $CRLF                                    ' Add each line with CR/LF
      NEXT k                                                      '
      IF ClipboardWrite(CBD) THEN _                               ' Write it
         me.MarkKill                                              ' Reset the select frame
   END METHOD                                                     '

   METHOD  PTPowerCut()                                           '
   '-----------------------------------------------------------------------------------------------+
   '- Cut selected columns from the PT range to the clipboard                                      |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, k, ix AS LONG, lclTxt, CBD AS STRING                  '
      '--------------------------------------------------------------------------------------------+
      '- OK, now build the Clipboard string                                                        |
      '--------------------------------------------------------------------------------------------+
      CBD = ""                                                    ' Start as ""
      me.MarkKill                                                 ' Reset the select frame
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         lclTxt = LTxtG(ix)                                       ' Get the text
         IF LEN(lclTxt) < MarkRect.Right THEN lclTxt = LSET$(lclTxt, MarkRect.Right)   ' Padd if needed
         lclTxt = MID$(lclTxt, MarkRect.Left TO MarkRect.Right)   ' Extract the columns
         CBD += lclTxt + $CRLF                                    ' Add each line with CR/LF
         lclTxt = LTxtG(ix)                                       ' Get the text again
         lclTxt = STRDELETE$(lclTxt, MarkRect.Left, MarkRect.Right - MarkRect.Left + 1)   ' Delete the characters
         me.LAttrAdjust(ix, MarkRect.Left, -(MarkRect.Right - MarkRect.Left + 1))   ' Adjust any Attr hilite
         me.LTxtSet(ix, lclTxt)                                   ' Put work string back
         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      ClipboardWrite(CBD)                                         ' Write it
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTPowerPaste()                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Paste whole clipboard at cursor location in PowerType mode                                   |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k, d AS LONG                                   '
   LOCAL ln, t, tt, MyDLM AS STRING                               '
   DIM CBD() AS STRING                                            '
      MEntry                                                      '
      IF gPTblCount = 0 THEN MExitMeth                            ' No PT count, then nothing to do
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Get data from clipboard, exit if none                                                     |
      '--------------------------------------------------------------------------------------------+
      ClipboardRead(t, MyDLM, %False)                             ' Go get Clipboard, keep the file
      IF LEN(t) < 1 THEN MExitMeth                                ' Error if nothing there
      REDIM CBD(1 TO PARSECOUNT(t, MyDLM))                        ' Get the lines in the clipboard
      PARSE t, CBD(), MyDLM                                       '

      '--------------------------------------------------------------------------------------------+
      '- Paste into the PT lines                                                                   |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         me.ModSet(ix)                                            ' Remember we changed something
         INCR d: IF d > UBOUND(CBD) THEN EXIT FOR                 ' If data line # > lines in clipboard, we're done
         ln = CBD(d)                                              ' Set ln to CBD data
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc index into string
         tt = LTxtG(ix)                                           ' Get working copy of text
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF i + LEN(ln) - 1 > LEN(tt) THEN tt = LSET$(tt , i + LEN(ln) - 1)   ' Lengthen if needed
            MID$(tt, i, LEN(ln)) = ln                             ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            tt = IIF$(i = 1, ln + tt, LEFT$(tt, i - 1) + ln + MID$(tt, i)) '
            me.LAttrAdjust(ix, i, LEN(ln))                        ' Adjust any Attr hilite
         END IF                                                   '
         me.LTxtSet(ix, tt)                                       ' Save it back
         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      i += LEN(ln)                                                ' Move cursor
      IF i > @P.POffset + @P.PDataLen - 1 THEN                    ' Off current screen?
         me.CurSetReq(%Position, gPTbl(1).tLin, i, %True)         ' No, Set cursor set attempt
         DoSet(%Refresh)                                          ' Have it looked at
      ELSE                                                        '
         me.CsrCol = i - @P.POffset + @P.PGapCol                  '
      END IF                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExit                                                       '
   END METHOD                                                     '

   METHOD  PTRight()                                              '
   '-----------------------------------------------------------------------------------------------+
   '- Increment Column in PowerType mode                                                           |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix AS LONG                                               '
      me.CsrColAdd(1)                                             ' Simple INCR
      IF @P.C.CCol > gENV.ScrWidth THEN                           ' At right side of screen?
         me.CsrColSub(1)                                          ' Yes, Undo the INCR for now
         ix = gPTbl(1).tLin                                       ' Locate data line cursor was on
         me.CurSetReq(%Position, ix, @P.C.CCol + @P.POffset - @P.PGapCol + 1, %False)  ' Set cursor set attempt
         me.OffsetAdd(1)                                          ' Bump the offset
         DoSet(%Refresh)                                          ' Have it looked at
      END IF                                                      '
   END METHOD                                                     '

   METHOD  PTRightScroll()                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Scroll RIGHT in Powertype mode                                                               |
   '-----------------------------------------------------------------------------------------------+
   DIM ScrAmt AS LONG, ScrCmd AS STRING                           '
      '--------------------------------------------------------------------------------------------+
      '- Get scroll amount                                                                         |
      '--------------------------------------------------------------------------------------------+
      ScrCmd = FCB.ScrollAmt                                      ' Pick up the default scroll amount
      IF VAL(ScrCmd) <> 0 THEN                                    ' A Number?
         ScrAmt = VAL(ScrCmd)                                     ' Yes, use it
      ELSEIF ScrCmd = "HALF" THEN                                 ' Half?
         ScrAmt = INT(@P.PDataLen / 2)                            ' Yes, set it
      ELSEIF ScrCmd = "PAGE" THEN                                 ' Page?
         ScrAmt = @P.PDataLen                                     ' Yes, set it
      ELSEIF ScrCmd = "FULL" THEN                                 ' Full?
         ScrAmt = @P.PDataLen                                     ' Yes, set it
      ELSEIF ScrCmd = "DATA" THEN                                 ' Data?
         ScrAmt = @P.PDataLen - 1                                 ' Yes, set it
      ELSEIF IsCData THEN                                         ' No, In data area?
         ScrAmt = @P.C.CCol - @P.PDataCol                         ' Yes, move cursor to left of screen
         IF ScrAmt = 0 THEN ScrAmt = @P.PDataLen - 1              ' If already there go a default amount
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Apply the scroll amount                                                                   |
      '--------------------------------------------------------------------------------------------+
      me.OffsetAdd(ScrAmt)                                        '
      me.CurSetReq(%Position, gPTbl(1).tLin, @P.C.CCol - @P.PGapCol + @P.POffset - ScrAmt, %False) '

      DoSet(%Refresh)                                             ' Have it looked at
   END METHOD                                                     '

   METHOD  PTSentenceCase()                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Sentence case a block in Power Type mode                                                     |
   '-----------------------------------------------------------------------------------------------+
   DIM words() AS STRING                                          '
   LOCAL Txt1, txt2 AS STRING                                     '
   LOCAL a, b, i, j, k, m, Caps, ix AS LONG                       '

      MEntry                                                      '
      me.MarkKill                                                 ' Reset the select frame
      Caps = %True                                                ' 1st word overall gets capitalized

      '--------------------------------------------------------------------------------------------+
      '- Loop through the PT lines                                                                 |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         me.ModSet(ix)                                            ' Remember we changed something
         Txt1 = LLCASE(MID$(LTxtG(ix), MarkRect.Left TO MarkRect.Right))   ' Get copy of substring to process
         GOSUB DoAChunk                                           ' Go process this piece
         txt2 = LTxtG(ix)                                         ' Get whole text line
         MID$(txt2, MarkRect.Left TO MarkRect.Right) = Txt1       ' Stuff back in the processed Txt1
         me.LTxtSet(ix, txt2)                                     ' Replace the whole line
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExitMeth                                                   '

   DoAChunk:                                                      '
      i = PARSECOUNT(Txt1, " ")                                   ' Count words
      REDIM words(1 TO i) AS STRING                               ' Make table correct size
      PARSE Txt1, words(), " "                                    ' Parse the words into the table
      m = 1                                                       ' Start scan at 1
      FOR b = 1 TO i                                              ' Loop for each word
         IF ISNOTNULL(words(b)) THEN                              ' Ignore null 'words'
            a = INSTR(m, Txt1, words(b))                          ' Find location of this word
            IF caps THEN                                          ' Capitalize this word?
               IF a THEN MID$(Txt1, a, 1) = UUCASE(MID$(Txt1, a, 1)) ' Uppercase the 1st letter
               Caps = %False                                      ' Off till next period
            END IF                                                '
            IF RIGHT$(words(b), 1) = "."  OR _                    ' Look for sentence trigger
               RIGHT$(words(b), 1) = "?"  OR _                    '
               RIGHT$(words(b), 1) = "!"  THEN                    '
               Caps = %True                                       ' Restart sentence if required
            END IF                                                '
            m = a + 1                                             ' Start scan adjust
         END IF                                                   '
      NEXT b                                                      '
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  PTSwap()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Swap chunks on a line                                                                        |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, ix AS LONG, lclTxt, CBD AS STRING               '
   LOCAL S1 AS LONG                                               '
   LOCAL l1, t1, t2, p1, p2, p3, p4 AS STRING                     '

      MEntry                                                      '
      '--------------------------------------------------------------------------------------------+
      '- If both areas marked, we can do the Swap                                                  |
      '--------------------------------------------------------------------------------------------+
      IF IsMarkActive AND IsSwapActive THEN                       ' We have two marked areas ready

         '-----------------------------------------------------------------------------------------+
         '- Init for line loop                                                                     |
         '-----------------------------------------------------------------------------------------+
         me.MarkKill                                              ' Kill the mark area
         me.SwapKill                                              ' Kill the Swap area
         FOR k = 1 TO gPTblCount                                  ' Loop for each PT line
            j = gPTbl(k).sRow                                     ' Get screen row
            s1 = gPTbl(k).tLin                                    ' Get IX of real data line
            IF ISFALSE IsLData(S1) THEN ITERATE FOR               ' Only Data lines

            '--------------------------------------------------------------------------------------+
            '- Extract the two strings                                                             |
            '--------------------------------------------------------------------------------------+
            IF LEN(L(s1).@LTxt) < MAX(SwapECol, MarkRect.Right) THEN me.LTxtSet(s1, LSET$(LTxtG(s1), MAX(SwapECol, MarkRect.Right)))   '
            l1 = LTxtG(s1)                                        ' Get the text from the Swap line
            t1 = MID$(l1, SwapSCol TO SwapECol)                   ' Extract the Swap columns
            t2 = MID$(l1, MarkRect.Left TO MarkRect.Right)        ' Extract the columns
            me.ModSet(S1)                                         ' Remember we changed something

            '--------------------------------------------------------------------------------------+
            '- Swap on a single line                                                               |
            '--------------------------------------------------------------------------------------+
            IF SwapSCol < MarkRect.Left THEN                      ' Swap is left of Mark
               '-----------------------------------------------------------------------------------+
               '- Swap area is Left of the Mark area                                               |
               '-----------------------------------------------------------------------------------+
               p1 = LEFT$(l1, SwapSCol - 1)                       ' Get part 1, the left of Swap string
               p2 = IIF$(SwapEcol + 1 = MarkRect.Left, "", MID$(l1, SwapECol + 1, MarkRect.Left - SwapECol -1))   ' Get part 2, between the strings
               p3 = MID$(l1, MarkRect.Right + 1)                  ' Get part 3, After the strings
               l1 = BUILD$(p1, t2, p2, t1, p3)                    ' Rebuild the line

            ELSE                                                  ' Mark is left of swap
               '-----------------------------------------------------------------------------------+
               '- Swap area is Right of the Mark area                                              |
               '-----------------------------------------------------------------------------------+
               p1 = LEFT$(l1, MarkRect.Left - 1)                  ' Get part 1, the left of Mark string
               p2 = IIF$(MarkRect.Right + 1 = SwapSCol, "", MID$(l1, MarkRect.Right + 1, SwapSCol - MarkRect.Right -1)) ' Get part 2, between the strings
               p3 = MID$(l1, SwapECol + 1)                        ' Get part 3, After the strings
               l1 = BUILD$(p1, t1, p2, t2, p3)                    ' Rebuild the line
            END IF                                                '
            me.LTxtSet(S1, l1)                                    ' Save the Swap line back
            me.UCIfNeeded(S1)                                     ' UC if CAPS ON
            me.AttrScan(S1)                                       ' Recolorize
            IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(s1, j)  ' If visible on the screen Re-display the line

         NEXT k                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Only Mark area active, start a Swap activity                                              |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsMarkActive AND ISFALSE IsSwapActive THEN           ' We have a MARK but no SWAP, start a Swap
         SwapSCol = MarkRect.Left                                 ' Copy marked area as a swap area
         SwapECol = MarkRect.Right                                '
         SwapSLin = MarkRect.Top                                  '
         SwapELin = MarkRect.Bottom                               '
         SwapLines = 1                                            ' Save # of data lines
         me.MarkKill                                              ' Kill the mark area
         OnSwapActive                                             ' Make Swap active
         me.SwapScr                                               ' Draw the underline

      '--------------------------------------------------------------------------------------------+
      '- No Mark area, See if Move more, or Kill time                                              |
      '--------------------------------------------------------------------------------------------+
      ELSEIF ISFALSE IsMarkActive AND IsSwapActive THEN           ' We have swap and no Mark, See if maybe Move mode
         j = me.SGet(@P.C.CRow)                                   ' Get line number of the cursor
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc column index into line
         IF i >= SwapSCol AND i <= SwapECol THEN GOSUB KillSwap: MExitMeth ' Kill if

         '-----------------------------------------------------------------------------------------+
         '- This looks like a SWAP Move mode request                                               |
         '-----------------------------------------------------------------------------------------+
         '-----------------------------------------------------------------------------------------+
         '- Init for line loop                                                                     |
         '-----------------------------------------------------------------------------------------+
         me.MarkKill                                              ' Kill the mark area
         me.SwapKill                                              ' Kill the Swap area
         FOR k = 1 TO gPTblCount                                  ' Loop for each PT line
            j = gPTbl(k).sRow                                     ' Get screen row
            s1 = gPTbl(k).tLin                                    ' Get IX of real data line

            '--------------------------------------------------------------------------------------+
            '- Extract the two line                                                                |
            '--------------------------------------------------------------------------------------+
            l1 = LTxtG(S1)                                        ' Get the text from the Swap line
            IF LEN(l1) < j THEN l1 = LSET$(l1, j)                 ' Make sure lines are as long as the mark point

            '--------------------------------------------------------------------------------------+
            '- Swap on a single line                                                               |
            '--------------------------------------------------------------------------------------+
            IF SwapSCol < i THEN                                  ' Swap is left of Mark

               '-----------------------------------------------------------------------------------+
               '- Swap area is Left of the Mark area                                               |
               '-----------------------------------------------------------------------------------+
               p1 = LEFT$(l1, SwapSCol - 1)                       ' Get part 1, the left of Swap string
               p2 = MID$(l1, SwapECol + 1 TO i - 1)               ' Get part 2, between the strings
               p3 = MID$(l1, SwapSCol TO SwapECol)                ' Get part 3, The swap string
               p4 = MID$(l1, i)                                   ' Get part 4, remainder of line
               l1 = BUILD$(p1, p2, p3, p4)                        ' Rebuild the line

            ELSE                                                  ' Mark is left of swap

               '-----------------------------------------------------------------------------------+
               '- Swap area is Right of the Mark point                                             |
               '-----------------------------------------------------------------------------------+
               p1 = LEFT$(l1, i - 1)                              ' Get part 1, the left of Mark string
               p2 = MID$(l1, SwapSCol TO SwapECol)                ' Get part 2, the swap string
               p3 = MID$(l1, i TO SwapSCol - 1)                   ' Get part 3, Between mark and swap string
               p4 = MID$(l1, SwapECol + 1)                        ' Get part 4, After the Swap string
               l1 = BUILD$(p1, p2, p3, p4)                        ' Rebuild the line
            END IF                                                '
            me.LTxtSet(S1, l1)                                    ' Save the Swap line back
            me.ModSet(S1)                                         ' Remember we changed something
            me.UCIfNeeded(S1)                                     ' UC if CAPS ON
            me.AttrScan(S1)                                       ' Recolorize
            IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(S1, j)  ' If visible on the screen Re-display the line
         NEXT k                                                   ' Onward
         DoSet(%Refresh)                                          ' Have it looked at

      '--------------------------------------------------------------------------------------------+
      '- Anything else, ignore                                                                     |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' Nothing going on, just exit
         MExitMeth                                                '

      END IF                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
      MExitMeth                                                   '

   KillSwap:                                                      '
      IF IsSwapDrawn THEN me.SwapKill                             ' Kill underline if drawn
      OffSwapActive                                               ' Now kill Swap
      RETURN                                                      '
   END METHOD                                                     '

   METHOD  PTTab()                                                '
   '-----------------------------------------------------------------------------------------------+
   '- Tab forward To Next field in PowerType mode                                                  |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k AS LONG, lclTabs AS STRING                       '
      MEntry                                                      '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location
      j = gPTbl(1).tLin                                           ' Get Line number of cursor line
      lclTabs = me.TabsSimple(LEN(L(j).@LTxt))                    ' Get a working tabs line
      k = 0                                                       ' Say no next line
      IF ISFALSE FCB.Tabs THEN MExitMeth                          ' If not tabbing, exit
      i = @P.C.CLCol                                              ' Calc index into data string
      i = INSTR(i + 1, lclTabs, "*")                              ' Look for next tab marker
      IF i THEN                                                   ' We have one
         IF i < @P.POffset + 1 OR i > @P.POffset + @P.PDataLen - 1 THEN ' Still on current screen
            me.CurSetReq(%Position, j, i, %True)                  ' No, Set cursor set attempt
            DoSet(%Refresh)                                       ' Have it looked at
            MExitMeth                                             '
         ELSE                                                     '
            me.CsrCol = i + @P.PGapCol - @P.POffset               ' Just move cursor on the screen
            MExitMeth                                             '
         END IF                                                   '
      END IF                                                      '
      Mexit                                                       '
   END METHOD                                                     '

   METHOD  PTTime()                                               '
   '-----------------------------------------------------------------------------------------------+
   '- Paste Date at cursor location in PowerType mode                                              |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ln AS STRING                                             '
      ln = Time12HR()                                             ' Go get the date
      me.PTTDPaste(ln)                                            ' Go do common code
   END METHOD                                                     '

   METHOD  PTTitleCase()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- TitleCase a selected block in Power Type mode                                                |
   '-----------------------------------------------------------------------------------------------+
   LOCAL j, k, ix AS LONG                                         '
      me.MarkKill                                                 ' Reset the select frame

      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Titlecase                                                                  |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         me.ModSet(ix)                                            ' Remember we changed something
         me.TitleCase(ix, MarkRect.Left, MarkRect.Right)          ' Go process it
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTTDPaste(ln AS STRING)                                '
   '-----------------------------------------------------------------------------------------------+
   '- Paste in the passed string in PowerType mode                                                 |
   '-----------------------------------------------------------------------------------------------+
   LOCAL ix, i, j, k AS LONG                                      '
   LOCAL tt AS STRING                                             '
      CsrLinDX = 0                                                ' Reset possible hidden DX line location

      '--------------------------------------------------------------------------------------------+
      '- Paste in the passed parameter into each PT line                                           |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         me.ModSet(ix)                                            ' Remember we changed something
         IF ISFALSE IsLData(ix) THEN ITERATE FOR                  ' Only Data lines
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc index into string
         tt = LTxtG(ix)                                           ' Get working copy of text
         IF IsNotNsrtFlag THEN                                    ' Do the non-Insert mode handling
            IF LEN(tt) - i < LEN(ln) THEN tt = tt + SPACE$(i + LEN(ln) - LEN(tt))   ' Lengthen if needed
            MID$(tt, i, LEN(ln)) = ln                             ' Overlay the CBD text
         ELSE                                                     ' Do the Insert method
            tt = IIF$(i = 1, ln + tt, LEFT$(tt, i - 1) + ln + MID$(tt, i)) '
            me.LAttrAdjust(ix, i, LEN(ln))                        ' Adjust any Attr hilite
         END IF                                                   '
         me.LTxtSet(ix, tt)                                       ' Save it back
         me.UCIfNeeded(ix)                                        ' UC if CAPS ON
         me.AttrScan(ix)                                          ' Recolorize
         IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
         IF @P.C.CCol < @P.POffset + 1 OR @P.C.CCol > @P.POffset + @P.PDataLen - 1 THEN   ' Still on current screen
            me.CurSetReq(%Position, ix, @P.C.CCol, %True)         ' No, Set cursor set attempt
            DoSet(%Refresh)                                       ' Have it looked at
         END IF                                                   '
      NEXT k                                                      '
      me.CsrCol = @P.C.CCol + LEN(ln)                             ' Move cursor
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '

   METHOD  PTUpperCase()                                          '
   '-----------------------------------------------------------------------------------------------+
   '- UpperCase a selected block in PowerType mode                                                 |
   '-----------------------------------------------------------------------------------------------+
   LOCAL i, j, k, ix AS LONG, lclTxt AS STRING                    '
      me.MarkKill                                                 ' Reset the select frame

      '--------------------------------------------------------------------------------------------+
      '- OK, now do the Lowercase                                                                  |
      '--------------------------------------------------------------------------------------------+
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         j = gPTbl(k).sRow                                        ' Get screen row
         ix = gPTbl(k).tLin                                       ' Get IX of real data line
         lclTxt = LTxtG(ix)                                       ' Get the text
         me.ModSet(ix)                                            ' Remember we changed something
         IF MarkRect.Left <= LEN(lclTxt) THEN                     ' Do only if long enough
            FOR i = MarkRect.Left TO MIN(MarkRect.Right, LEN(lclTxt))   ' Just ones that are there
               MID$(lclTxt, i, 1) = UUCASE(MID$(lclTxt, i, 1))    '
            NEXT i                                                '
            me.LTxtSet(ix, lclTxt)                                ' Put work string back
            me.AttrScan(ix)                                       ' Recolorize
            IF j >= @P.PData1 AND j <= @P.PBottom THEN me.DispLine(ix, j)  ' If visible on the screen Re-display the line
         END IF                                                   '
      NEXT k                                                      '
      TP.LastPTCurs = 0                                           ' Force cursor to draw
      DoCursor                                                    ' To get back | | lines
   END METHOD                                                     '
