#ifndef SPFLITEKEYS_H_INCLUDED
#define SPFLITEKEYS_H_INCLUDED


//  2 lines per key
//  1st line contains the MS keyname                                            
//  2nd line is comma delimited                                                 
//    Field 1 - Hex scancode                                                    
//          2 - 'E' if an Extended key                                          
//          3 - Icon name in resource file                                      
//          4 - Dialog draw location and size                                   
//          5 -   "                                                             
//          6 -   "                                                             
//          7 -   "                                                             
//          8 - Allowable Control combinations                                  
//          9 - External key name                                               
//  I think all you'll need are fields 1, 2 and 9                               
                                                                                
                                                                                
// ---- Table starts on next line ---------------                               


struct                      key_table_t
{
    int                     vk_code;
    int                     scan_code;
    char                    extended_key;
    char *                  icon_name;
    int                     draw_loc1;
    int                     draw_loc2;
    int                     draw_loc3;
    int                     draw_loc4;
    char *                  control_comb;
    char *                  key_name;
};
                                                                                
#define VK_PGUP             VK_PRIOR
#define VK_PGDN             VK_NEXT

#define VK_0                '0'
#define VK_1                '1'
#define VK_2                '2'
#define VK_3                '3'
#define VK_4                '4'
#define VK_5                '5'
#define VK_6                '6'
#define VK_7                '7'
#define VK_8                '8'
#define VK_9                '9'

#define VK_A                'A'                
#define VK_B                'B'                
#define VK_C                'C'                
#define VK_D                'D'                
#define VK_E                'E'                
#define VK_F                'F'                
#define VK_G                'G'                
#define VK_H                'H'                
#define VK_I                'I'                
#define VK_J                'J'                
#define VK_K                'K'                
#define VK_L                'L'                
#define VK_M                'M'                
#define VK_N                'N'                
#define VK_O                'O'                
#define VK_P                'P'                
#define VK_Q                'Q'                
#define VK_R                'R'                
#define VK_S                'S'                
#define VK_T                'T'                
#define VK_U                'U'                
#define VK_V                'V'                
#define VK_W                'W'                
#define VK_X                'X'                
#define VK_Y                'Y'                
#define VK_Z                'Z'                


key_table_t                  key_table[] = {

{ VK_ESCAPE,                                                                    
0x1B, ' ', "ESC     ",  32,  32,    1,   12, "N.....", "ESC" },       
{ VK_F1,                                                                        
0x70, ' ', "F1      ",  32,  32,   67,   12, "NSCA..", "F1" },        
{ VK_F2,                                                                        
0x71, ' ', "F2      ",  32,  32,  100,   12, "NSCA..", "F2" },        
{ VK_F3,                                                                        
0x72, ' ', "F3      ",  32,  32,  133,   12, "NSCA..", "F3" },        
{ VK_F4,                                                                        
0x73, ' ', "F4      ",  32,  32,  166,   12, "NSCA..", "F4" },        
{ VK_F5,                                                                        
0x74, ' ', "F5      ",  32,  32,  215,   12, "NSCA..", "F5" },        
{ VK_F6,                                                                        
0x75, ' ', "F6      ",  32,  32,  248,   12, "NSCA..", "F6" },        
{ VK_F7,                                                                        
0x76, ' ', "F7      ",  32,  32,  281,   12, "NSCA..", "F7" },        
{ VK_F8,                                                                        
0x77, ' ', "F8      ",  32,  32,  314,   12, "NSCA..", "F8" },        
{ VK_F9,                                                                        
0x78, ' ', "F9      ",  32,  32,  363,   12, "NSCA..", "F9" },        
{ VK_F10,                                                                       
0x79, ' ', "F10     ",  32,  32,  399,   12, "NSCA..", "F10" },       
{ VK_F11,                                                                       
0x7A, ' ', "F11     ",  32,  32,  432,   12, "NSCA..", "F11" },       
{ VK_F12,                                                                       
0x7B, ' ', "F12     ",  32,  32,  465,   12, "NSCA..", "F12" },       
{ VK_SNAPSHOT,                                                                  
0x2C, 'E', "PrtScr  ",  32,  32,  508,   12, "NSCA.U", "PRTSCR" },    
{ VK_SCROLL,                                                                    
0x91, ' ', "ScrlLock",  32,  32,  541,   12, "N..A..", "SCRLK" },     
{ VK_PAUSE,                                                                     
0x13, ' ', "Pause   ",  32,  32,  574,   12, "NSCA..", "PAUSE" },     
{ VK_OEM_3,                                                                     
0xC0, ' ', "BkQuote ",  32,  32,    1,   55, "NSCA..", "`" },         
{ VK_1,                                                                         
0x31, ' ', "I1      ",  32,  32,   34,   55, "NSCA..", "1" },         
{ VK_2,                                                                         
0x32, ' ', "I2      ",  32,  32,   67,   55, "NSCA..", "2" },         
{ VK_3,                                                                         
0x33, ' ', "I3      ",  32,  32,  100,   55, "NSCA..", "3" },         
{ VK_4,                                                                         
0x34, ' ', "I4      ",  32,  32,  133,   55, "NSCA..", "4" },         
{ VK_5,                                                                         
0x35, ' ', "I5      ",  32,  32,  166,   55, "NSCA..", "5" },         
{ VK_6,                                                                         
0x36, ' ', "I6      ",  32,  32,  199,   55, "NSCA..", "6" },         
{ VK_7,                                                                         
0x37, ' ', "I7      ",  32,  32,  232,   55, "NSCA..", "7" },         
{ VK_8,                                                                         
0x38, ' ', "I8      ",  32,  32,  265,   55, "NSCA..", "8" },         
{ VK_9,                                                                         
0x39, ' ', "I9      ",  32,  32,  298,   55, "NSCA..", "9" },         
{ VK_0,                                                                         
0x30, ' ', "I0      ",  32,  32,  331,   55, "NSCA..", "0" },         
{ VK_OEM_MINUS,                                                                 
0xBD, ' ', "Dash    ",  32,  32,  364,   55, "NSCA..", "-" },         
{ VK_OEM_PLUS,                                                                  
0xBB, ' ', "Equal   ",  32,  32,  397,   55, "NSCA..", "=" },         
{ VK_BACK,                                                                      
0x08, ' ', "Bksp    ",  66,  32,  430,   55, "NSCA..", "BKSP" },      
{ VK_TAB,                                                                       
0x09, ' ', "Tab     ",  48,  32,    1,   88, "NSC...", "TAB" },       
{ VK_Q,                                                                         
0x51, ' ', "Q       ",  32,  32,   50,   88, "NSCA..", "Q" },         
{ VK_W,                                                                         
0x57, ' ', "W       ",  32,  32,   83,   88, "NSCA..", "W" },         
{ VK_E,                                                                         
0x45, ' ', "E       ",  32,  32,  116,   88, "NSCA..", "E" },         
{ VK_R,                                                                         
0x52, ' ', "R       ",  32,  32,  149,   88, "NSCA..", "R" },         
{ VK_T,                                                                         
0x54, ' ', "T       ",  32,  32,  182,   88, "NSCA..", "T" },         
{ VK_Y,                                                                         
0x59, ' ', "Y       ",  32,  32,  215,   88, "NSCA..", "Y" },         
{ VK_U,                                                                         
0x55, ' ', "U       ",  32,  32,  248,   88, "NSCA..", "U" },         
{ VK_I,                                                                         
0x49, ' ', "I       ",  32,  32,  281,   88, "NSCA..", "I" },         
{ VK_O,                                                                         
0x4F, ' ', "O       ",  32,  32,  314,   88, "NSCA..", "O" },         
{ VK_P,                                                                         
0x50, ' ', "P       ",  32,  32,  347,   88, "NSCA..", "P" },         
{ VK_OEM_4,                                                                     
0xDB, ' ', "LSqBrkt ",  32,  32,  380,   88, "NSCA..", "[" },         
{ VK_OEM_6,                                                                     
0xDD, ' ', "RSqBrkt ",  32,  32,  413,   88, "NSCA..", "]" },         
{ VK_RETURN,                                                                    
0x0D, ' ', "Enter   ",  40,  66,  456,   88, "NSCA..", "ENTER" },     
{ VK_CAPITAL,                                                                   
0x14, ' ', "CapsLk  ",  56,  32,    1,  121, ".....D", "CAPSLK" },    
{ VK_A,                                                                         
0x41, ' ', "A       ",  32,  32,   59,  121, "NSCA..", "A" },         
{ VK_S,                                                                         
0x53, ' ', "S       ",  32,  32,   92,  121, "NSCA..", "S" },         
{ VK_D,                                                                         
0x44, ' ', "D       ",  32,  32,  125,  121, "NSCA..", "D" },         
{ VK_F,                                                                         
0x46, ' ', "F       ",  32,  32,  158,  121, "NSCA..", "F" },         
{ VK_G,                                                                         
0x47, ' ', "G       ",  32,  32,  191,  121, "NSCA..", "G" },         
{ VK_H,                                                                         
0x48, ' ', "H       ",  32,  32,  224,  121, "NSCA..", "H" },         
{ VK_J,                                                                         
0x4A, ' ', "J       ",  32,  32,  257,  121, "NSCA..", "J" },         
{ VK_K,                                                                         
0x4B, ' ', "K       ",  32,  32,  290,  121, "NSCA..", "K" },         
{ VK_L,                                                                         
0x4C, ' ', "L       ",  32,  32,  323,  121, "NSCA..", "L" },         
{ VK_OEM_1,                                                                     
0xBA, ' ', "SemColon",  32,  32,  356,  121, "NSCA..", ";" },         
{ VK_OEM_7,                                                                     
0xDE, ' ', "Quote   ",  32,  32,  389,  121, "NSCA..", "'" },         
{ VK_OEM_5,                                                                     
0xDC, ' ', "BSlash  ",  32,  32,  422,  121, "NSCA..", "\\" },         
{ VK_LSHIFT,                                                                    
0x10, ' ', "Shift2  ",  66,  32,    1,  154, ".....D", "LSHIFT" },    
{ VK_Z,                                                                         
0x5A, ' ', "Z       ",  32,  32,   68,  154, "NSCA..", "Z" },         
{ VK_X,                                                                         
0x58, ' ', "X       ",  32,  32,  101,  154, "NSCA..", "X" },         
{ VK_C,                                                                         
0x43, ' ', "C       ",  32,  32,  134,  154, "NSCA..", "C" },         
{ VK_V,                                                                         
0x56, ' ', "V       ",  32,  32,  167,  154, "NSCA..", "V" },         
{ VK_B,                                                                         
0x42, ' ', "B       ",  32,  32,  200,  154, "NSCA..", "B" },         
{ VK_N,                                                                         
0x4E, ' ', "N       ",  32,  32,  233,  154, "NSCA..", "N" },         
{ VK_M,                                                                         
0x4D, ' ', "M       ",  32,  32,  266,  154, "NSCA..", "M" },         
{ VK_OEM_COMMA,                                                                 
0xBC, ' ', "Comma   ",  32,  32,  299,  154, "NSCA..", "," },         
{ VK_OEM_PERIOD,                                                                
0xBE, ' ', "Period  ",  32,  32,  332,  154, "NSCA..", "." },         
{ VK_OEM_2,                                                                     
0xBF, ' ', "Slash   ",  32,  32,  365,  154, "NSCA..", "/" },         
{ VK_RSHIFT,                                                                     
0x10, ' ', "Shift3  ",  98,  32,  398,  154, ".....D", "RSHIFT" },    
{ VK_CONTROL,                                                                    
0x11, ' ', "Ctrl    ",  48,  32,    1,  187, "N....U", "LCTRL" },     
{ VK_LWIN,                                                                      
0x5B, ' ', "Windows ",  48,  32,   50,  187, ".....D", "LWIN" },      
{ VK_MENU,                                                                      
0x12, ' ', "Alt     ",  48,  32,   99,  187, "N....U", "LALT" },      
{ VK_SPACE,                                                                     
0x20, ' ', "Space   ", 154,  32,  148,  187, "NSCA..", "SPACE" },     
{ VK_MENU,                                                                      
0x12, 'E', "Alt     ",  48,  32,  303,  187, "N....U", "RALT" },      
{ VK_LWIN,                                                                      
0x5C, ' ', "Windows ",  48,  32,  351,  187, ".....D", "RWIN" },      
{ VK_APPS,                                                                      
0x5D, 'E', "WinMenu ",  48,  32,  400,  187, "NSCA..", "APPMENU" },   
{ VK_CONTROL,                                                                    
0x11, 'E', "Ctrl    ",  48,  32,  449,  187, "N....U", "RCTRL" },     
{ VK_INSERT,                                                                    
0x2D, 'E', "Insert  ",  32,  32,  508,   55, "NSCA..", "INS" },       
{ VK_HOME,                                                                      
0x24, 'E', "Home    ",  32,  32,  541,   55, "NSCA..", "HOME" },      
{ VK_PGUP,                                                                      
0x21, 'E', "PgUp    ",  32,  32,  574,   55, "NSCA..", "PGUP" },      
{ VK_DELETE,                                                                    
0x2E, 'E', "Del     ",  32,  32,  508,   88, "NSCA..", "DEL" },       
{ VK_END,                                                                       
0x23, 'E', "End     ",  32,  32,  541,   88, "NSCA..", "END" },       
{ VK_PGDN,                                                                      
0x22, 'E', "PgDn    ",  32,  32,  574,   88, "NSCA..", "PGDN" },      
{ VK_UP,                                                                        
0x26, 'E', "Up      ",  32,  32,  541,  154, "NSCA..", "UP" },        
{ VK_DOWN,                                                                      
0x28, 'E', "Down    ",  32,  32,  541,  187, "NSCA..", "DOWN" },      
{ VK_LEFT,                                                                      
0x25, 'E', "Left    ",  32,  32,  508,  187, "NSCA..", "LEFT" },      
{ VK_RIGHT,                                                                     
0x27, 'E', "Right   ",  32,  32,  574,  187, "NSCA..", "RIGHT" },     
{ VK_NUMLOCK,                                                                   
0x90, 'E', "NumLock ",  32,  32,  617,   55, "NSCA.U", "NUMLK" },     
{ VK_DIVIDE,                                                                    
0x6F, 'E', "KPSlash ",  32,  32,  650,   55, "NSCA..", "KP/" },       
{ VK_MULTIPLY,                                                                  
0x6A, ' ', "KPAster ",  32,  32,  683,   55, "NSCA..", "KP*" },       
{ VK_SUBTRACT,                                                                  
0x6D, ' ', "KPMinus ",  32,  32,  716,   55, "NSCA..", "KP-" },       
{ VK_NUMPAD7,
0x24, ' ', "KP7     ",  32,  32,  617,   88, "NSCA..", "KP7" },       
{ VK_NUMPAD8,
0x26, ' ', "KP8     ",  32,  32,  650,   88, "NSCA..", "KP8" },       
{ VK_NUMPAD9,
0x21, ' ', "KP9     ",  32,  32,  683,   88, "NSCA..", "KP9" },       
{ VK_ADD,                                                                       
0x6B, ' ', "KPPlus  ",  32,  66,  716,   88, "NSCA..", "KP+" },       
{ VK_NUMPAD4,
0x25, ' ', "KP4     ",  32,  32,  617,  121, "NSCA..", "KP4" },       
{ VK_NUMPAD5,
0x0C, ' ', "KP5     ",  32,  32,  650,  121, "NSCA..", "KP5" },       
{ VK_NUMPAD6,
0x27, ' ', "KP6     ",  32,  32,  683,  121, "NSCA..", "KP6" },       
{ VK_NUMPAD1,
0x23, ' ', "KP1     ",  32,  32,  617,  154, "NSCA..", "KP1" },       
{ VK_NUMPAD2,
0x28, ' ', "KP2     ",  32,  32,  650,  154, "NSCA..", "KP2" },       
{ VK_NUMPAD3,
0x22, ' ', "KP3     ",  32,  32,  683,  154, "NSCA..", "KP3" },       
{ VK_RETURN,                                                                    
0x0D, 'E', "KPEnter ",  32,  66,  716,  154, "NSCA..", "KPENTER" },   
{ VK_NUMPAD0,
0x2D, ' ', "KP0     ",  66,  32,  617,  187, "NSCA..", "KP0" },       
{ VK_DECIMAL,                                                                   
0x2E, ' ', "KPPeriod",  32,  32,  683,  187, "NSCA..", "KP." },       

};

#define key_table_size       ((sizeof(key_table))/(sizeof(key_table[0])))


//***********************************************************************
// table to fill-in keyboard name when key is not known as a US key
//***********************************************************************



struct                      unknown_key_table_t
{
    int                     unknown_code;
    char *                  unknown_name;
};
                                                                                

unknown_key_table_t                  unknown_key_table[] = {

{ /* VK_LBUTTON              */  0x01, "Left Mouse Button" },
{ /* VK_RBUTTON              */  0x02, "Right Mouse Button" },
{ /* VK_CANCEL               */  0x03, "Control-Break Processing" },
{ /* VK_MBUTTON              */  0x04, "Middle Mouse Button" },
{ /* VK_XBUTTON1             */  0x05, "X1 Mouse Button" },
{ /* VK_XBUTTON2             */  0x06, "X2 Mouse Button" },
{ /* VK_BACK                 */  0x08, "Backspace Key" },
{ /* VK_TAB                  */  0x09, "Tab Key" },
{ /* VK_CLEAR                */  0x0C, "Clear Key" },
{ /* VK_RETURN               */  0x0D, "Enter Key" },
{ /* VK_SHIFT                */  0x10, "Shift Key" },
{ /* VK_CONTROL              */  0x11, "Ctrl Key" },
{ /* VK_MENU                 */  0x12, "Alt Key" },
{ /* VK_PAUSE                */  0x13, "Pause Key" },
{ /* VK_CAPITAL              */  0x14, "Caps Lock Key" },
{ /* VK_KANA                 */  0x15, "IME Kana Mode" },
{ /* VK_HANGUL               */  0x15, "IME Hangul Mode" },
{ /* VK_IME_ON               */  0x16, "IME On" },
{ /* VK_JUNJA                */  0x17, "IME Junja Mode" },
{ /* VK_FINAL                */  0x18, "IME Final Mode" },
{ /* VK_HANJA                */  0x19, "IME Hanja Mode" },
{ /* VK_KANJI                */  0x19, "IME Kanji Mode" },
{ /* VK_IME_OFF              */  0x1A, "IME Off" },
{ /* VK_ESCAPE               */  0x1B, "Esc Key" },
{ /* VK_CONVERT              */  0x1C, "IME Convert" },
{ /* VK_NONCONVERT           */  0x1D, "IME Nonconvert" },
{ /* VK_ACCEPT               */  0x1E, "IME Accept" },
{ /* VK_MODECHANGE           */  0x1F, "IME Mode Change Request" },
{ /* VK_SPACE                */  0x20, "Spacebar" },
{ /* VK_PRIOR                */  0x21, "Page Up Key" },
{ /* VK_NEXT                 */  0x22, "Page Down Key" },
{ /* VK_END                  */  0x23, "End Key" },
{ /* VK_HOME                 */  0x24, "Home Key" },
{ /* VK_LEFT                 */  0x25, "Left Arrow Key" },
{ /* VK_UP                   */  0x26, "Up Arrow Key" },
{ /* VK_RIGHT                */  0x27, "Right Arrow Key" },
{ /* VK_DOWN                 */  0x28, "Down Arrow Key" },
{ /* VK_SELECT               */  0x29, "Select Key" },
{ /* VK_PRINT                */  0x2A, "Print Key" },
{ /* VK_EXECUTE              */  0x2B, "Execute Key" },
{ /* VK_SNAPSHOT             */  0x2C, "Print Screen Key" },
{ /* VK_INSERT               */  0x2D, "Ins Key" },
{ /* VK_DELETE               */  0x2E, "Del Key" },
{ /* VK_HELP                 */  0x2F, "Help Key" },
{ /* VK_LWIN                 */  0x5B, "Left Windows Key" },
{ /* VK_RWIN                 */  0x5C, "Right Windows Key" },
{ /* VK_APPS                 */  0x5D, "Applications Key" },
{ /* VK_SLEEP                */  0x5F, "Computer Sleep Key" },
{ /* VK_NUMPAD0              */  0x60, "Numeric Keypad 0 Key" },
{ /* VK_NUMPAD1              */  0x61, "Numeric Keypad 1 Key" },
{ /* VK_NUMPAD2              */  0x62, "Numeric Keypad 2 Key" },
{ /* VK_NUMPAD3              */  0x63, "Numeric Keypad 3 Key" },
{ /* VK_NUMPAD4              */  0x64, "Numeric Keypad 4 Key" },
{ /* VK_NUMPAD5              */  0x65, "Numeric Keypad 5 Key" },
{ /* VK_NUMPAD6              */  0x66, "Numeric Keypad 6 Key" },
{ /* VK_NUMPAD7              */  0x67, "Numeric Keypad 7 Key" },
{ /* VK_NUMPAD8              */  0x68, "Numeric Keypad 8 Key" },
{ /* VK_NUMPAD9              */  0x69, "Numeric Keypad 9 Key" },
{ /* VK_MULTIPLY             */  0x6A, "Multiply Key" },
{ /* VK_ADD                  */  0x6B, "Add Key" },
{ /* VK_SEPARATOR            */  0x6C, "Separator Key" },
{ /* VK_SUBTRACT             */  0x6D, "Subtract Key" },
{ /* VK_DECIMAL              */  0x6E, "Decimal Key" },
{ /* VK_DIVIDE               */  0x6F, "Divide Key" },
{ /* VK_F1                   */  0x70, "F1 Key" },
{ /* VK_F2                   */  0x71, "F2 Key" },
{ /* VK_F3                   */  0x72, "F3 Key" },
{ /* VK_F4                   */  0x73, "F4 Key" },
{ /* VK_F5                   */  0x74, "F5 Key" },
{ /* VK_F6                   */  0x75, "F6 Key" },
{ /* VK_F7                   */  0x76, "F7 Key" },
{ /* VK_F8                   */  0x77, "F8 Key" },
{ /* VK_F9                   */  0x78, "F9 Key" },
{ /* VK_F10                  */  0x79, "F10 Key" },
{ /* VK_F11                  */  0x7A, "F11 Key" },
{ /* VK_F12                  */  0x7B, "F12 Key" },
{ /* VK_F13                  */  0x7C, "F13 Key" },
{ /* VK_F14                  */  0x7D, "F14 Key" },
{ /* VK_F15                  */  0x7E, "F15 Key" },
{ /* VK_F16                  */  0x7F, "F16 Key" },
{ /* VK_F17                  */  0x80, "F17 Key" },
{ /* VK_F18                  */  0x81, "F18 Key" },
{ /* VK_F19                  */  0x82, "F19 Key" },
{ /* VK_F20                  */  0x83, "F20 Key" },
{ /* VK_F21                  */  0x84, "F21 Key" },
{ /* VK_F22                  */  0x85, "F22 Key" },
{ /* VK_F23                  */  0x86, "F23 Key" },
{ /* VK_F24                  */  0x87, "F24 Key" },
{ /* VK_NUMLOCK              */  0x90, "Num Lock Key" },
{ /* VK_SCROLL               */  0x91, "Scroll Lock Key" },
{ /* VK_LSHIFT               */  0xA0, "Left Shift Key" },
{ /* VK_RSHIFT               */  0xA1, "Right Shift Key" },
{ /* VK_LCONTROL             */  0xA2, "Left Control Key" },
{ /* VK_RCONTROL             */  0xA3, "Right Control Key" },
{ /* VK_LMENU                */  0xA4, "Left Alt Key" },
{ /* VK_RMENU                */  0xA5, "Right Alt Key" },
{ /* VK_BROWSER_BACK         */  0xA6, "Browser Back Key" },
{ /* VK_BROWSER_FORWARD      */  0xA7, "Browser Forward Key" },
{ /* VK_BROWSER_REFRESH      */  0xA8, "Browser Refresh Key" },
{ /* VK_BROWSER_STOP         */  0xA9, "Browser Stop Key" },
{ /* VK_BROWSER_SEARCH       */  0xAA, "Browser Search Key" },
{ /* VK_BROWSER_FAVORITES    */  0xAB, "Browser Favorites Key" },
{ /* VK_BROWSER_HOME         */  0xAC, "Browser Start And Home Key" },
{ /* VK_VOLUME_MUTE          */  0xAD, "Volume Mute Key" },
{ /* VK_VOLUME_DOWN          */  0xAE, "Volume Down Key" },
{ /* VK_VOLUME_UP            */  0xAF, "Volume Up Key" },
{ /* VK_MEDIA_NEXT_TRACK     */  0xB0, "Next Track Key" },
{ /* VK_MEDIA_PREV_TRACK     */  0xB1, "Previous Track Key" },
{ /* VK_MEDIA_STOP           */  0xB2, "Stop Media Key" },
{ /* VK_MEDIA_PLAY_PAUSE     */  0xB3, "Play/Pause Media Key" },
{ /* VK_LAUNCH_MAIL          */  0xB4, "Start Mail Key" },
{ /* VK_LAUNCH_MEDIA_SELECT  */  0xB5, "Select Media Key" },
{ /* VK_LAUNCH_APP1          */  0xB6, "Start Application 1 Key" },
{ /* VK_LAUNCH_APP2          */  0xB7, "Start Application 2 Key" },
{ /* VK_OEM_1                */  0xBA, "OEM_1 US ;: Key" },
{ /* VK_OEM_PLUS             */  0xBB, "OEM + Key" },
{ /* VK_OEM_COMMA            */  0xBC, "OEM , Key" },
{ /* VK_OEM_MINUS            */  0xBD, "OEM - Key" },
{ /* VK_OEM_PERIOD           */  0xBE, "OEM . Key" },
{ /* VK_OEM_2                */  0xBF, "OEM_2 US /? Key" },
{ /* VK_OEM_3                */  0xC0, "OEM_3 US `~ Key" },
{ /* VK_OEM_4                */  0xDB, "OEM_4 US [{ Key" },
{ /* VK_OEM_5                */  0xDC, "OEM_4 US \\| Key" },
{ /* VK_OEM_6                */  0xDD, "OEM_6 US ]} Key" },
{ /* VK_OEM_7                */  0xDE, "OEM_7 US '\" Key" },
{ /* VK_OEM_8                */  0xDF, "OEM_8" },
{ /* VK_OEM_102              */  0xE2, "OEM_102 US <> Key Or Non-US \\| Key" },
{ /* VK_PROCESSKEY           */  0xE5, "IME Process Key" },
{ /* VK_PACKET               */  0xE7, "Unicode Packet key" },
{ /* VK_ATTN                 */  0xF6, "Attn Key" },
{ /* VK_CRSEL                */  0xF7, "Crsel Key" },
{ /* VK_EXSEL                */  0xF8, "Exsel Key" },
{ /* VK_EREOF                */  0xF9, "Erase Eof Key" },
{ /* VK_PLAY                 */  0xFA, "Play Key" },
{ /* VK_ZOOM                 */  0xFB, "Zoom Key" },
{ /* VK_NONAME               */  0xFC, "Reserved" },
{ /* VK_PA1                  */  0xFD, "Pa1 Key" },
{ /* VK_OEM_CLEAR            */  0xFE, "OEM Clear Key" },


};


#define unknown_key_table_size       ((sizeof(unknown_key_table))/(sizeof(unknown_key_table[0])))

#endif /* SPFLITEKEYS_H_INCLUDED */
