#pragma comment(lib, "USER32")

#define _WIN32_WINNT 0x0500
#include <windows.h>
#include <stdio.h>

HWND GetConsoleHwnd(void);

#include "KBD-test-keylist.h"

#define ir_count            1

#define ENABLE_QUICK_EDIT_MODE 0x0040
#define ENABLE_EXTENDED_FLAGS  0x0080

#define ENABLE_AUTO_POSITION   0x0100   // XP
#define ENABLE_INSERT_MODE     0x0020   // XP

HHOOK                       hKeyHook;
HINSTANCE                   hExe;
CONSOLE_CURSOR_INFO         cci;
HANDLE                      hConsoleInput;
HANDLE                      hConsoleOutput;

int                         u;
bool                        halt = false;

DWORD                       mainThreadId;
DWORD                       myMainThreadId;

#ifndef KEYEVENTF_KEYDOWN
#define KEYEVENTF_KEYDOWN   0
#endif

#define ESC 0x1B
int                         esc_count = 0;
int                         snapshot_scancode = 0;



char *                      get_key_name (
    int                     vk_code,
    char                    extended_key)
{
    int                     i;


    for (i=0; i < key_table_size; i++)
    {
        if (key_table[i].vk_code == vk_code)
        {
            // if extended_key is defined, the code must match

            if (extended_key)
            {
                if (key_table[i].extended_key != extended_key) 
                {
                    continue;
                }
            }

            return key_table[i].key_name;
        }
    }

    // if we can't find the key name in the original KeyboardTest table, 
    // search for an extended name grabbed from a Microsoft web page that 
    // documented all VK codes. This is like a "fallback" lookup.
    // this is the main change added with version 2.

    for (i=0; i < unknown_key_table_size; i++)
    {
        if (unknown_key_table[i].unknown_code == vk_code)
        {
            return unknown_key_table[i].unknown_name;
        }
    }

    return "Unknown key";
}

void show_shift_state()
{
    int                     state = 0;

    int  shift = GetKeyState (VK_SHIFT);
    int rshift = GetKeyState (VK_RSHIFT);
    int lshift = GetKeyState (VK_LSHIFT);


    if (lshift < 0) state |= 0x10;
    if (rshift < 0) state |= 0x01;

    switch (state)
    {
        case 0x10: printf (" LSHIFT"); break;
        case 0x01: printf (" RSHIFT"); break;
        case 0x11: printf (" 2SHIFT"); break;
        default:   printf (" ------");
    }
}


void show_size (
    SHORT                   x, 
    SHORT                   y)
{
    printf ("window x=%2d y=%2d\n", x, y);
}


void show_mouse (
    SHORT                   x, 
    SHORT                   y)
{
    printf ("mouse pos x=%2d y=%2d  ", x, y);
}


void show_VK_code (
    WORD                    code)
{
    printf ("%02X ", code);
}


void show_scancode (
    WORD                    code)
{
    printf ("%02X ", code);
}


void show_repeat (
    WORD                    count)
{
    printf ("%d ", count);
}


void show_mouse_button_state (
    DWORD                   b, 
    DWORD                   e)

{
    char t[16];
    int i = 0;

    printf ("Button %08X Event %08X ", b, e);

    if (b & FROM_LEFT_1ST_BUTTON_PRESSED) t[i++] = '1';
    if (b & FROM_LEFT_2ND_BUTTON_PRESSED) t[i++] = '2';
    if (b & FROM_LEFT_3RD_BUTTON_PRESSED) t[i++] = '3';
    if (b & FROM_LEFT_4TH_BUTTON_PRESSED) t[i++] = '4';
    if (b & RIGHTMOST_BUTTON_PRESSED    ) t[i++] = 'R';

    if (e & DOUBLE_CLICK ) t[i++] = 'D';
    if (e & MOUSE_MOVED  ) t[i++] = 'M';

    if (e & MOUSE_WHEELED)
    {
        t[i++] = 'W';
        if (b & 0xFF000000)
            t[i++] = '-';   // wheel down
        else
            t[i++] = '+';   // wheel up
    }

    t[i] = 0;

    printf ("events: '%s'\n", t);
}


void show_ascii (
    WCHAR                   ascii)
{
    WCHAR                   lpBuffer [3];
    DWORD                   lpNumberOfCharsWritten = 0;

    printf (" %02X %03d ", ascii & 0xFF, ascii & 0xFF);

    lpBuffer[0] = ascii;
    lpBuffer[1] = 0;

    if (ascii < ' ')
    {
        lpBuffer[0] = ' ';
    }

    WriteConsoleW(
        hConsoleOutput,     // handle to a console screen buffer
        lpBuffer,           // pointer to buffer to write from
        1,                  // nNumberOfCharsToWrite,
                            // number of characters to write
        &lpNumberOfCharsWritten,
                            // pointer to number of characters written
        NULL);

    if (ascii == ESC)   
    {
        esc_count++;

        cci.dwSize = 10;
        SetConsoleCursorInfo(
            hConsoleOutput,  // handle to console screen buffer
            &cci);
    }
    else
    {
        esc_count = 0;
    }
}


void show_key_down (
    BOOL                    down)
{
    if (down)
        printf (" DOWN");
    else
        printf (" ----");
}


void show_control_state (
    DWORD                   state)
{
    if ((state & LEFT_ALT_PRESSED)
    &&  (state & RIGHT_ALT_PRESSED))
        printf (" 2ALT");

    else if (state & LEFT_ALT_PRESSED)
        printf (" LALT");

    else if (state & RIGHT_ALT_PRESSED)
        printf (" RALT");

    else
        printf (" ----");



    if ((state & LEFT_CTRL_PRESSED)
    &&  (state & RIGHT_CTRL_PRESSED))
        printf (" 2CTRL");

    else if (state & LEFT_CTRL_PRESSED)
        printf (" LCTRL");

    else if (state & RIGHT_CTRL_PRESSED)
        printf (" RCTRL");

    else
        printf (" -----");



    if (state & CAPSLOCK_ON)
        printf (" CAPS");
    else
        printf (" ----");

    if (state & NUMLOCK_ON)
        printf (" NUM");
    else
        printf (" ---");

    if (state & SCROLLLOCK_ON)
        printf (" SCR");
    else
        printf (" ---");


    if (state & SHIFT_PRESSED)
    {
        // printf ("shift pressed; state = %04X\n", state);
        show_shift_state();
    }

    else
        printf (" ------");

    if (state & ENHANCED_KEY)
        printf (" ENH");
    else
        printf (" ---");
}


BOOL WINAPI myConsoleCtrlHandler (
    DWORD                   dwCtrlType)
{
    switch (dwCtrlType)     //  control signal type
    {
        case CTRL_C_EVENT:
            printf ("\nCTRL C\n");
            halt = true;
            break;

        case CTRL_BREAK_EVENT:
            printf ("\nCTRL BREAK\n");
            halt = true;
            break;

        case CTRL_CLOSE_EVENT:
            printf ("\nCTRL CLOSE\n");
            halt = true;
            break;

        case CTRL_LOGOFF_EVENT:
            printf ("\nCTRL LOGOFF\n");
            halt = true;
            break;

        case CTRL_SHUTDOWN_EVENT:
            printf ("\nCTRL SHUTDOWN\n");
            halt = true;
            break;
    }

    return TRUE;
}

// __declspec(dllexport)

LRESULT CALLBACK LowLevelKeyboardProc (
    int                     nCode,          // hook code
    WPARAM                  wParam,         // message identifier
    LPARAM                  lParam)         // pointer to structure with message data
{
    KBDLLHOOKSTRUCT         *kbh;


    if ( (nCode < 0)
    ||   (nCode != HC_ACTION) )
    {
        return CallNextHookEx (
            hKeyHook,       // handle to current hook
            nCode,          // hook code passed to hook procedure
            wParam,         // value passed to hook procedure
            lParam);        // value passed to hook procedure
    }


   
    kbh = (KBDLLHOOKSTRUCT *) lParam;

#if 0
    if (kbh->vkCode == '3')
    {
        kbh->vkCode = '4';
        kbh->scanCode = 5;
    }
#endif

    return 1;
}

#if 1
DWORD WINAPI myThreadProc (
    LPVOID                  lpParameter)  // thread data
{
    MSG                     message;

    while (GetMessage(&message,NULL,0,0)) {
        TranslateMessage( &message );
        DispatchMessage( &message );
    }
    return 0;
}
#endif


// This is the function that is "exported" from the
// execuatable like any function is exported from a
// DLL. It is the hook handler routine for keyboard events.

__declspec(dllexport) LRESULT CALLBACK KeyboardProc (

    int                     nCode,   // The hook code
    WPARAM                  wParam,  // the VK code
    LPARAM                  lParam)  // A 32-bit value with repeat code, scan code, flags, etc.

{
    if (nCode == HC_ACTION)
    {
        if ( (BYTE) wParam == VK_SNAPSHOT)
        {
            // we don't have to check up or down, because PrntScrn only sends
            // a code on key up


            snapshot_scancode = (lParam >> 8) & 0xFF;

            INPUT           k;

            k.type          = INPUT_KEYBOARD;
            k.ki.wVk        = VK_SPACE;    // SPACE BAR
            k.ki.wScan      = VK_ESCAPE;   // ESCAPE's scan code
            k.ki.time       = 0;
            k.ki.dwExtraInfo = 0;

            // create a key down event where an up SPACE has an ESC 
            // scan code.  this is a fake key to signify that a print
            // screen key was pressed.

            k.ki.dwFlags = KEYEVENTF_KEYDOWN;
            SendInput (1, &k, sizeof (INPUT));
        }
    }

    return CallNextHookEx (   
        hKeyHook, nCode, wParam, lParam);
}


void hook_keyboard()
{

    int                     rc;

    hExe = GetModuleHandle (NULL);

    if (! hExe)
    {
        extern char **      __argv;

        hExe = LoadLibrary((LPCSTR) __argv[0]);
    }

    if (hExe)
    {
        hKeyHook = SetWindowsHookEx (WH_KEYBOARD, KeyboardProc, hExe, 0);

        rc = GetLastError();
    }
    else
    {
        //  printf ("hook_keyboard: could not GetModuleHandle\n");
    }

}


DWORD WINAPI myMain(
  LPVOID                    lpParameter)  // thread data
{
    BOOL                    status;
    INPUT_RECORD            ir;
    DWORD                   nLength = ir_count;
    DWORD                   numberOfEventsRead = 0;
    DWORD                   getMode;
    STARTUPINFO             startup;

    int                     rc;
    int                     err;
    int                     i;
    char                    *hex = "0123456789ABCDEF";

    WORD                    color;
    COORD                   dwBufferSize;
    COORD                   dwBufferCoord;
    SMALL_RECT              lpWriteRegion;
    MSG                     message;

#define kbdlayoutSize 256
    char                    kbdlayout[kbdlayoutSize+4];

    CHAR_INFO cbuf[32];

#define oldConsoleTitleSize 256

    char                    oldConsoleTitle[oldConsoleTitleSize+4];

    WCHAR lpBuffer[] = L"Hello in Unicode"
        L" ! " L"\xFF01"
        L" # " L"\xFF02"
        L" $ " L"\xFF03" L"\n";

    DWORD nNumberOfCharsToWrite = (sizeof (lpBuffer) / sizeof (WCHAR)) - 1;
    DWORD lpNumberOfCharsWritten = 0;

    PeekMessage(&message, NULL, WM_USER, WM_USER, PM_NOREMOVE);

    myMainThreadId = GetCurrentThreadId();

    AttachThreadInput(
        myMainThreadId,     // DWORD idAttach,    // thread to attach
        mainThreadId,       // DWORD idAttachTo,  // thread to attach to
        TRUE);              // BOOL fAttach       // attach or detach

    hConsoleInput = GetStdHandle (STD_INPUT_HANDLE);
    hConsoleOutput = GetStdHandle (STD_OUTPUT_HANDLE);

    GetKeyboardLayoutName(kbdlayout);

    GetConsoleMode(hConsoleInput, &getMode);

    rc = GetConsoleCursorInfo(
        hConsoleOutput,     // handle to console screen buffer
        &cci);

    cci.dwSize = 10;
    rc = SetConsoleCursorInfo(
        hConsoleOutput,     // handle to console screen buffer
        &cci);

    SetConsoleMode (hConsoleInput, 
        0
        | ENABLE_WINDOW_INPUT
//      | ENABLE_MOUSE_INPUT
//      | ENABLE_PROCESSED_INPUT
//      | ENABLE_EXTENDED_FLAGS
//      | ENABLE_QUICK_EDIT_MODE
//      | ENABLE_AUTO_POSITION
//      | ENABLE_INSERT_MODE
        );

    GetConsoleMode(hConsoleInput, &getMode);

    GetStartupInfo(
        &startup);                // address of STARTUPINFO structure
    SetConsoleCtrlHandler(myConsoleCtrlHandler,TRUE);


    color = 0
    | FOREGROUND_BLUE
    | BACKGROUND_BLUE
    | BACKGROUND_GREEN
    | BACKGROUND_RED
    | BACKGROUND_INTENSITY
    ;
   
//  0   BLACK
//  1   BLUE
//  2   GREEN
//  3   CYAN        BLUE+GREEN
//  4   RED
//  5   MAGENTA     BLUE+RED
//  6   YELLOW      GREEN+RED
//  7   LT GREY     BLUE+GREEN+RED
//  8   DK GREY
//  9   LT BLUE
//  A   LT GREEN
//  B   LT CYAN
//  C   LT RED
//  D   LT MAGENTA
//  E   LT YELLOW
//  F   WHITE

    color = 0
    | FOREGROUND_RED
    | BACKGROUND_BLUE
    | BACKGROUND_GREEN
    | BACKGROUND_RED
    | BACKGROUND_INTENSITY
    ;

    dwBufferSize.X = 16;
    dwBufferSize.Y = 1;

    dwBufferCoord.X = 0;
    dwBufferCoord.Y = 0;

    lpWriteRegion.Left   = 0;
    lpWriteRegion.Top    = 4;
    lpWriteRegion.Right  = 15;
    lpWriteRegion.Bottom = 4;

    hook_keyboard();

#define LOOPS 10

    int                     loopcount = LOOPS;
    char                    extended_key;

    printf ("\nSPFLite KBD-Test Diagnostic Program - (V2.0.23.337)\n");

    for (;;)
    {
        if (halt) exit(0);

        if (loopcount == LOOPS)
        {
            printf ("\nEnter any key, or press ESC twice to cancel -->\n");
            printf ("VK SC HEX DEC C *ALT *CTRL CAPS NUM SCR *SHIFT ENH KEYNAME\n");
            printf ("== == === === = ==== ===== ==== === === ====== === =======\n");
            loopcount = 0;
        }

        status = ReadConsoleInputW(
          hConsoleInput,                // handle to a console input buffer
          &ir,                          // address of the buffer for read data
          nLength,                      // number of records to read
          &numberOfEventsRead);         // address of number of records read

        if (numberOfEventsRead < 1) 
        {
            Sleep (40);
            continue;
        }

        if  ((ir.EventType == MOUSE_EVENT)
        ||   (ir.EventType == WINDOW_BUFFER_SIZE_EVENT)
        ||   (ir.EventType == FOCUS_EVENT)
        ||   (ir.EventType != KEY_EVENT))
        {
            continue;
        }

        if (! ir.Event.KeyEvent.bKeyDown)
            continue;

        if ( (ir.Event.KeyEvent.wVirtualKeyCode == VK_CONTROL)  // Ctrl
        ||   (ir.Event.KeyEvent.wVirtualKeyCode == VK_MENU)     // Alt
        ||   (ir.Event.KeyEvent.wVirtualKeyCode == VK_CAPITAL)  // caps lock
        ||   (ir.Event.KeyEvent.wVirtualKeyCode == VK_SHIFT) ) 
        {
            continue;
        }

        // translate PRINT SCREEN fake key to real one

        if ((ir.Event.KeyEvent.wVirtualKeyCode == VK_SPACE)
        &&  (ir.Event.KeyEvent.wVirtualScanCode == VK_ESCAPE))
        {
            ir.Event.KeyEvent.wVirtualKeyCode = VK_SNAPSHOT;
            ir.Event.KeyEvent.wVirtualScanCode = snapshot_scancode;
        }

        show_VK_code (ir.Event.KeyEvent.wVirtualKeyCode);
        show_scancode (ir.Event.KeyEvent.wVirtualScanCode);

//      show_ascii (ir.Event.KeyEvent.uChar.AsciiChar);
        show_ascii (ir.Event.KeyEvent.uChar.UnicodeChar);

//      show_repeat (ir.Event.KeyEvent.wRepeatCount);
        show_control_state (ir.Event.KeyEvent.dwControlKeyState);

        bool enh = (ir.Event.KeyEvent.dwControlKeyState & ENHANCED_KEY) != 0;

        extended_key = 0;

        switch (ir.Event.KeyEvent.wVirtualKeyCode)
        {
            case VK_RETURN:
                extended_key = enh ? 'E' : ' ';
        }

        printf (" %s\n", 
            get_key_name (ir.Event.KeyEvent.wVirtualKeyCode, extended_key));

        loopcount++;

        if (esc_count > 1) halt = true;

        if (halt) 
        {
        //  UninstallKeyHook();
            exit (0);
        }

    }
}

void main()
{
    MSG message;
    HWND cHnd;
    HANDLE myMainHandle;

    mainThreadId = GetCurrentThreadId();


    myMainHandle = CreateThread
        (   NULL            // LPSECURITY_ATTRIBUTES lpThreadAttributes
        ,   0               // DWORD dwStackSize,
        ,   (LPTHREAD_START_ROUTINE) myMain    // LPTHREAD_START_ROUTINE lpStartAddress
        ,   NULL            // LPVOID lpParameter
        ,   0               // DWORD dwCreationFlags
        ,   NULL            // LPDWORD lpThreadId - to receive thread ID
        );

    cHnd = GetConsoleHwnd();

//  PeekMessage(&message, cHnd, WM_USER, WM_USER, PM_NOREMOVE);
//      if (PeekMessage (&message, cHnd, 0, 0, PM_NOREMOVE))


    PeekMessage(&message, NULL, WM_USER, WM_USER, PM_NOREMOVE);

    for (;;)
    {
        if (halt) exit(0);
        if (PeekMessage (&message, NULL, 0, 0, PM_NOREMOVE))
        {
            int gm;
            gm = GetMessage(&message, cHnd, 0, 0);

    //      printf ("GetMessage = %08x\n", gm);

            if (gm == -1)
            {
                break;
            }

            TranslateMessage( &message );
//          DispatchMessage( &message );
        }
        else
        {
            Sleep (40);
        }
    }
}


HWND GetConsoleHwnd(void) {

#define MY_BUFSIZE 1024 // buffer size for console window titles
    HWND hwndFound;         // this is what is returned to the caller
    char pszNewWindowTitle[MY_BUFSIZE]; // contains fabricated WindowTitle
    char pszOldWindowTitle[MY_BUFSIZE]; // contains original WindowTitle

    // fetch current window title

    GetConsoleTitle(pszOldWindowTitle, MY_BUFSIZE);

    // format a "unique" NewWindowTitle

    wsprintf(pszNewWindowTitle,"%d/%d",
                GetTickCount(),
                GetCurrentProcessId());

    // change current window title

    SetConsoleTitle(pszNewWindowTitle);

    // ensure window title has been updated

    Sleep(40);

    // look for NewWindowTitle

    hwndFound=FindWindow(NULL, pszNewWindowTitle);

    // restore original window title

    SetConsoleTitle(pszOldWindowTitle);

    return(hwndFound);

}
