'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjENV.inc                                                                                      |
'--------------------------------------------------------------------------------------------------+
                                                                  '
CLASS cENVariables                                                '

'--------------------------------------------------------------------------------------------------+
'- Following are the Global working variables, most built by looking around                        |
'--------------------------------------------------------------------------------------------------+
   INSTANCE InitDone         AS LONG                              ' Set true when all initialization is complete
   INSTANCE AppPath          AS STRING                            ' Path to the Application folder
   INSTANCE ClipCmd          AS STRING                            ' CLIP operand
   INSTANCE CmdLine          AS STRING                            ' Command line (Raw)
   INSTANCE eInstance        AS STRING                            ' -INSTANCE from command line
   INSTANCE EXEFullPath      AS STRING                            ' Full path to the EXE file
   INSTANCE EXEPath          AS STRING                            ' Path to the EXE folder
   INSTANCE FirstTime        AS LONG                              ' This is a First Time run
   INSTANCE HomeFolder       AS STRING                            ' Home Folder for CFG file
   INSTANCE HomeData         AS STRING                            ' Home Folder for the Data sub-folders
   INSTANCE HomeBkpName      AS STRING                            ' Home default BKP table
   INSTANCE HomeRtrName      AS STRING                            ' Home default Retrieve table
   INSTANCE HomeEFTName      AS STRING                            ' Home default EFT table
   INSTANCE HomeKbdName      AS STRING                            ' Home default KBD table
   INSTANCE HomeSetName      AS STRING                            ' Home default SET table
   INSTANCE iDo              AS STRING                            ' -DO operand
   INSTANCE InitClip         AS LONG                              ' Cmd line asked for -CLIP
   INSTANCE InitString       AS STRING                            ' Cmd line filename or MRF file list
   INSTANCE InitProfile      AS STRING                            ' Cmd line .profile
   INSTANCE InitMacro        AS STRING                            ' Cmd line @macroname
   INSTANCE InitXForm        AS STRING                            ' Cmd line /macroname
   INSTANCE InitFMFileList   AS STRING                            ' Initial FLIST name from command line
   INSTANCE InitFMMask       AS STRING                            ' Initial FM Mask from command line
   INSTANCE InitFMPath       AS STRING                            ' Initial FM Path from command line
   INSTANCE InvChar          AS STRING                            ' Display char. for unprintable characters
   INSTANCE PMode            AS LONG                              ' Parameter options
   INSTANCE PgmDate          AS STRING                            ' EXE creation date
   INSTANCE PgmVers          AS STRING                            ' EXE version
   INSTANCE QuietMode        AS LONG                              ' -QUIET mode
   INSTANCE Roaming          AS LONG                              ' Execution roaming mode
   INSTANCE SETETab          AS LONG                              ' Tab # that issued SET Edit
   INSTANCE WineMode         AS LONG                              ' WINE mode
   INSTANCE NoLoopMode       AS LONG                              ' NOLOOP mode
   INSTANCE WorkingDir       AS STRING                            ' Our working directory

'--------------------------------------------------------------------------------------------------+
'- Following are the variables set from the CFG file                                               |
'--------------------------------------------------------------------------------------------------+

   INSTANCE ABeepFlag        AS LONG                              ' Beep on ErrMsgHigh=%eFail? True = yes
   INSTANCE AttnPos          AS LONG                              ' Reset position to Last Attention after Line Commands
   INSTANCE AutoScroll       AS LONG                              ' 0 = Off # = On and # of Lines/Cols to Scroll
   INSTANCE Banding          AS LONG                              ' Banding ON/OFF
   INSTANCE BKPRetention     AS LONG                              ' BACKUP Retention in days
   INSTANCE BKPMinGen        AS LONG                              ' BACKUP Minimum Generations
   INSTANCE BKPMaxGen        AS LONG                              ' BACKUP Maximum Generations
   INSTANCE Build            AS STRING                            ' Program Build version
   INSTANCE CharSet          AS STRING                            ' Character set
   INSTANCE CharSetR         AS STRING                            ' Character set for RegEx
   INSTANCE cMarkLine        AS LONG                              ' Color of MARK lines
   INSTANCE CmdChr           AS STRING                            ' Command delimiter
   INSTANCE CMDFlags         AS STRING                            ' CMD.EXE flags for CMD command
   INSTANCE CmdHiLite        AS LONG                              ' Cmd line KW hilite
   INSTANCE ConfDelFlag      AS LONG                              ' Confirm Deletes in File Manager?
   INSTANCE CursInsert       AS LONG                              ' Percent height of an Insert cursor
   INSTANCE CursNormal       AS LONG                              ' Percent height of a Normal cursor
   INSTANCE CustomClr        AS STRING                            ' Custom colors
   INSTANCE CutNew           AS LONG                              ' CUT defaults to NEW
   INSTANCE DBConsoleX       AS LONG                              ' Debug Console X dimension
   INSTANCE DBConsoleY       AS LONG                              '   "      "    Y     "
   INSTANCE DefDataShift     AS LONG                              ' Default shift for >> )) ]] line commands
   INSTANCE Diff1Column      AS LONG                              ' Diff 1Column flag
   INSTANCE DiffUseFileB     AS LONG                              ' Use FileB data on Equal match
   INSTANCE DiffOnly         AS LONG                              ' Diff Only flag
   INSTANCE DiffALB          AS LONG                              ' Diff FileA LB
   INSTANCE DiffARB          AS LONG                              ' Diff FileA RB
   INSTANCE DiffANX          AS LONG                              ' Diff FileA NX
   INSTANCE DiffAX           AS LONG                              ' Diff FileA X
   INSTANCE DiffBLB          AS LONG                              ' Diff FileB LB
   INSTANCE DiffBRB          AS LONG                              ' Diff FileB RB
   INSTANCE DiffBNX          AS LONG                              ' Diff FileB NX
   INSTANCE DiffBX           AS LONG                              ' Diff FileB X
   INSTANCE DiffNoSpace      AS LONG                              ' Diff FileA NoSpace
   INSTANCE DiffNoTab        AS LONG                              ' Diff FileA NoTab
   INSTANCE DiffNoComment    AS LONG                              ' Diff FileA NoComment
   INSTANCE DiffNoCASE       AS LONG                              ' Diff FileA NoCASE
   INSTANCE DiffNoMultB      AS LONG                              ' Diff No multiple blank lines
   INSTANCE DiffMinMatch     AS LONG                              ' DIFF MinMatch
   INSTANCE ENGChars         AS LONG                              ' English only A-Z and a-z characters
   INSTANCE FileLineFmt      AS STRING                            ' =FILE> line format
   INSTANCE FileListNm       AS STRING                            ' FM FileListNm
   INSTANCE FindWord         AS LONG                              ' Find default context is WORD
   INSTANCE FMCloseFlag      AS LONG                              ' Close FM with last tab?
   INSTANCE FMDateHiLite     AS LONG                              ' HiLite Recent/Active dates in the FM List
   INSTANCE FMDefMaster      AS STRING                            ' Master Default FM sort & Layout
   INSTANCE FMDefSort        AS STRING                            ' Default FM sort
   INSTANCE FMDirSort        AS STRING                            ' Default FM Dir sort
   INSTANCE FMFileList       AS STRING                            ' Initial FM FLIST name
   INSTANCE FMHelpFlag       AS LONG                              ' Display FM Help at bottom of screen?
   INSTANCE FMLastSectNo     AS LONG                              ' FM Index of last fetched section
   INSTANCE FMLayout         AS STRING                            ' FM Line layout STANDARD
   INSTANCE FMLayoutM        AS STRING                            ' FM Line layout ALTERNATE
   INSTANCE FMLCmdWidth      AS LONG                              ' Width of FM Line Command  area
   INSTANCE FMMask           AS STRING                            ' Initial FM Mask
   INSTANCE FMPath           AS STRING                            ' Initial FM Path
   INSTANCE FMScrlAmt        AS STRING                            ' FM Scroll amount
   INSTANCE FMSortSimple     AS LONG                              ' FM Sort to use old simple sort
   INSTANCE FontName         AS STRING                            ' Font name for screen
   INSTANCE FontPitch        AS LONG                              ' Font pitch for screen
   INSTANCE FontStyle        AS LONG                              ' Font Style for screen
   INSTANCE GlueWith         AS STRING                            ' GLUE join cgaracter string
   INSTANCE HRuler           AS LONG                              ' Horizontal ruler cursor
   INSTANCE HelpIntro        AS LONG                              ' HELP intro has been done
   INSTANCE HelpOpen         AS LONG                              ' HELP Open Mode 1=Normal, 3=FullScreen
   INSTANCE InsMode          AS LONG                              ' Default Insert mode
   INSTANCE InsReset         AS LONG                              ' Insert mode Reset at each Attn key?
   INSTANCE JobNumber        AS LONG                              ' Submit job number
   INSTANCE KBHorScroll      AS LONG                              ' Scroll (Hor) screen when cursor hits edge?
   INSTANCE KBVerScroll      AS LONG                              ' Scroll (Ver) screen when cursor hits edge?
   INSTANCE LANG             AS STRING                            ' SpellChk Language
   INSTANCE LastAccess       AS STRING                            ' Last access timestamp
   INSTANCE LastScreenX      AS LONG                              ' Last screen location X
   INSTANCE LastScreenY      AS LONG                              ' Last screen location Y
   INSTANCE LinNoSize        AS LONG                              ' Width of Line Number field
   INSTANCE LinRepeatMax     AS LONG                              ' Max Line Cmd rerpeat value
   INSTANCE MacName          AS LONG                              ' Display MacName on message line
   INSTANCE MAXIMIZED        AS LONG                              ' Screen is in MAX mode
   INSTANCE MinRetrieve      AS LONG                              ' Min length retrievable command
   INSTANCE MinToTray        AS LONG                              ' Minimize to the Syatem Tray
   INSTANCE MRFList          AS STRING                            ' Most Recent File list
   INSTANCE NotifyLevel      AS LONG                              ' Permanent Notify option
   INSTANCE NotifyLevelT     AS LONG                              ' Temporary (working) Notify option
   INSTANCE FileOpen         AS STRING                            ' The -FILEOPEN cmd line value
   INSTANCE FMode            AS STRING                            ' The Mode from the Cmd Line
   INSTANCE PanelMax         AS LONG                              ' Active panel will use larger size
   INSTANCE PFKShow          AS LONG                              ' Show PFKeys at bottom
   INSTANCE PDotRaw          AS STRING                            ' P'.' raw input
   INSTANCE PDotString       AS STRING                            ' P'.' string of invalid characters
   INSTANCE PrtBandColor     AS LONG                              ' Banding color
   INSTANCE PrtBanding       AS LONG                              ' Banding stripes
   INSTANCE PrtBandLines     AS LONG                              ' Banding lines
   INSTANCE PrtBMargin       AS SINGLE                            ' Printer bottom margin (in)
   INSTANCE PrtDuplex        AS LONG                              ' Printer duplex setting
   INSTANCE PrtFontName      AS STRING                            ' Printer font
   INSTANCE PrtFontPitch     AS STRING                            ' Printer pitch
   INSTANCE PrtFontStyle     AS STRING                            ' Printer style
   INSTANCE PrtFooter        AS LONG                              ' Printer footers 1 = yes
   INSTANCE PrtFooterCenter  AS STRING                            ' Printer center footers
   INSTANCE PrtFooterLeft    AS STRING                            ' Printer left footers
   INSTANCE PrtFooterRight   AS STRING                            ' Printer left footers
   INSTANCE PrtHeader        AS LONG                              ' Printer headers 1 = yes
   INSTANCE PrtHeaderCenter  AS STRING                            ' Printer center headers
   INSTANCE PrtHeaderLeft    AS STRING                            ' Printer left headers
   INSTANCE PrtHeaderRight   AS STRING                            ' Printer left headers
   INSTANCE PrtLMargin       AS SINGLE                            ' Printer left margin (in)
   INSTANCE PrtMetric        AS LONG                              ' Printer margins Eng/Metric
   INSTANCE PrtName          AS STRING                            ' Printer name
   INSTANCE PrtOrient        AS LONG                              ' Printer orientation, 1=Portrait 2=Landscape
   INSTANCE PrtPaper         AS LONG                              ' Paper index
   INSTANCE PrtRMargin       AS SINGLE                            ' Printer right margin (in)
   INSTANCE PrtTMargin       AS SINGLE                            ' Printer top margin (in)
   INSTANCE PrtPColor        AS LONG                              ' Print in color (%True or %False)
   INSTANCE RecentCtr        AS LONG                              ' How many recent files to keep
   INSTANCE ReOpenLast       AS LONG                              ' Re-Open last file(s)
   INSTANCE ResetU           AS LONG                              ' RESET clears U by default, like X
   INSTANCE RUNFlags         AS STRING                            ' CMD.EXE flags for RUN command
   INSTANCE SBLayout         AS STRING                            ' Status Bar layout
   INSTANCE SBFactor         AS SINGLE                            ' Status Bar Scale factor
   INSTANCE Scheme()         AS LONG                              ' Scheme color value
   INSTANCE SchemeSave()     AS LONG                              ' Saved copy of Scheme
   INSTANCE SchAliasAll      AS STRING                            ' Scheme ALIAS names as 1 list
   INSTANCE SchAlias()       AS STRING                            ' Scheme ALIAS names as a table
   INSTANCE SchAliasSave()   AS STRING                            ' Saved copy of Scheme alias
   INSTANCE ScrHeight        AS LONG                              ' Screen height
   INSTANCE ScrWidth         AS LONG                              ' Screen width
   INSTANCE ScrPosition      AS STRING                            ' Screen normal position values
   INSTANCE Splash           AS LONG                              ' Display Splash screen (True/False)
   INSTANCE SubmitCmd        AS STRING                            ' Model command for SUBMIT
   INSTANCE SubmitDir        AS STRING                            ' Working DIR for SUBMIT
   INSTANCE SubmitInclKey    AS STRING                            ' Include key string for SUBMIT
   INSTANCE SubmitInclCol    AS LONG                              ' Include key string column for SUBMIT
   INSTANCE UniqueFlag       AS LONG                              ' Keep only 1 instance running
   INSTANCE UndoLevels       AS LONG                              ' Number of UNDO levels
   INSTANCE UseRecycle       AS LONG                              ' Delete to Recycle bin?
   INSTANCE VBeepFlag        AS LONG                              ' Visual Beep on ErrMsgHigh=%eFail? True = yes
   INSTANCE VertInsCurs      AS LONG                              ' Vertical Insert Cursor
   INSTANCE ViewWarn         AS LONG                              ' Warn on modified View?
   INSTANCE VRuler           AS LONG                              ' Vertical ruler cursor
   INSTANCE VScrollBar       AS LONG                              ' Add Vertical ScrollBar
   INSTANCE WarnNonText      AS LONG                              ' Warn if Non-Text file opened
   INSTANCE WebCheck         AS LONG                              ' Days between Web check
   INSTANCE WebLastDate      AS STRING                            ' Date(mm-dd-yyyy) of last web check
   INSTANCE WebLastVers      AS STRING                            ' Version (2.7.nnnnn) as of last check
   INSTANCE WelcomeOpt       AS LONG                              ' DispWelcome return option

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
   LOCAL i, j, k, rc, lpdwHandle AS LONG, t, tt, BlockBuffer, sLangID, cword, MyDLM, lclMAXIMIZED AS STRING '
   LOCAL pLang AS LONG PTR                                        '
   LOCAL lclpValue AS ASCIIZ PTR                                  '
   LOCAL approvedlocation, lclScrHeight, lclScrWidth, FNum AS LONG   '
   LOCAL approvedpath  AS ASCIIZ * %MAX_PATH                      '
   LOCAL tASCIIZ       AS ASCIIZ * %MAX_PATH                      '
   LOCAL DriveHandle, zero, rlen, hLib, hProc AS DWORD            '
   LOCAL hp AS STORAGE_HOTPLUG_INFO                               '
   LOCAL RCA AS RCArea                                            '
   DIM Scheme(0 TO 47, 1 TO 3) AS INSTANCE LONG                   '
   DIM SchAlias(0 TO 15) AS INSTANCE STRING                       '
   DIM SchAliasSave(0 TO 15) AS INSTANCE STRING                   '
   LOCAL SystemTimeArea AS SYSTEMTIME                             '
   LOCAL LastWriteTime AS both                                    '
   LOCAL value, tDirSort, tDefSort, tFMask AS STRING              '
   LOCAL lclKwd AS KwdEnt                                         '
   LOCAL LTime AS IPOWERTIME                                      ' Create a PowerTime object
   LET LTime = CLASS "PowerTime"                                  '

      '--------------------------------------------------------------------------------------------+
      '- Fetch info about who we are, where we are etc.                                            |
      '--------------------------------------------------------------------------------------------+
      PMode = 0                                                   ' Start PMode as all off
      FirstTime = %True                                           ' Assume it's our first time
      EXEFullPath = EXE.FULL$                                     ' Save where the EXE file is
      tASCIIZ = EXEFullPath                                       ' Get an ASCIIZ version

      '--------------------------------------------------------------------------------------------+
      '- Get our program version from the EXE header                                               |
      '--------------------------------------------------------------------------------------------+
      i = GetFileVersionInfoSize(tASCIIZ, lpdwHandle)             ' Fetch size of area needed
      BlockBuffer = SPACE$(i)                                     ' Alloc a block
      rc = GetFileVersionInfo(BYCOPY EXEFullPath, _               ' Copy the EXE info block
                              lpdwHandle, _                       '
                              i, _                                '
                              BYVAL STRPTR(BlockBuffer))          '
      rc = VerQueryValue(BYVAL STRPTR(BlockBuffer), _             ' Fetch language
                              "\VarFileInfo\Translation", _       '
                              pLang, _                            '
                              lpdwHandle)                         '
      sLangID = IIF$(rc, HEX$(LO(WORD, @pLang), 4) + HEX$(HI(WORD, @pLang), 4), "040904E4")  ' Get lang. or use American English/ANSI

      rc = VerQueryValue(BYVAL STRPTR(BlockBuffer), _             ' Fetch the version date
                              "\StringFileInfo\" & sLangID & "\VersionDate", _   '
                              lclpValue, _                        '
                              lpdwHandle)                         '
      PgmDate = @lclpValue                                        ' Save date
      rc = VerQueryValue(BYVAL STRPTR(BlockBuffer), _             ' Fetch the version
                              "\StringFileInfo\" & sLangID & "\ProductVersion", _   '
                              lclpValue, _                        '
                              lpdwHandle)                         '
      PgmVers = @lclpValue                                        ' Save version

      '--------------------------------------------------------------------------------------------+
      '- Go Load our gENV keyword table                                                            |
      '--------------------------------------------------------------------------------------------+
      GOSUB LoadKWTable                                           ' Go load our table

      '--------------------------------------------------------------------------------------------+
      '- Save EXE and System Application paths                                                     |
      '--------------------------------------------------------------------------------------------+
      EXEPath = EXE.PATH$                                         ' Save the EXE path etc. we need gfRoaming setup real early
      approvedlocation = %csidl_personal                          ' Ask system for the correct CFG path
      rc = shgetfolderpath (BYVAL %Null, _                        ' Get system application path
                              approvedlocation OR %CSIDL_FLAG_CREATE, _ '
                              -0&, _                              '
                              %shgfp_type_current, _              '
                              approvedpath)                       '
      AppPath = TRIM$(approvedpath) + "\SPFLite\"                 ' Save the system's approved Path

      '--------------------------------------------------------------------------------------------+
      '- See if running under WINE                                                                 |
      '--------------------------------------------------------------------------------------------+
      hLib = LoadLibrary( BYCOPY "NTDLL.Dll" )                    ' Get NTDLL
      IF hLib THEN                                                ' Should always be true
         hProc = GetProcAddress(hLib, BYCOPY "wine_get_version")  ' See if WINE entry point defined
         IF hProc THEN                                            ' If so, set WINE flag
            WineMode = %True                                      '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- See if we're running from a removable drive, if so say we're in 'Roaming' mode            |
      '--------------------------------------------------------------------------------------------+
      tASCIIZ = "\\.\" + LEFT$(EXEPath, 2)                        ' Lets see where we're running from
      DriveHandle = CreateFile(tASCIIZ, 0, %FILE_SHARE_READ, BYVAL 0&, %OPEN_EXISTING, 0, BYVAL 0&)   ' Get a Handle for it
      DeviceIoControl(DriveHandle, %IOCTL_STORAGE_GET_HOTPLUG_INFO, Zero, 0&, BYREF hp, SIZEOF(hp), rlen, "")  ' Get hotplug data
      CloseHandle(DriveHandle)                                    ' Done with handle now
      IF hp.devicehotplug THEN                                    ' Romoveable?
         Roaming = %True                                          ' Running from a removeable drive? Say we 're in Roaming mode
         FirstTime = %False                                       ' Should never be 1st time
         AppPath = EXEPath + "CONFIG\"                            ' Swap App path
         HomeFolder = AppPath: HomeData = AppPath                 ' And Home path and Data path
      ELSE                                                        ' Else, native home
         '--------------------------------------------------------------------------------------------+
         '- See if we've done a setup already                                                         |
         '--------------------------------------------------------------------------------------------+
         HomeFolder = RegistryGet("Software\SPFLite", "HomeFolder", "MISSING")   ' Try getting the HomeFolder
         HomeData   = RegistryGet("Software\SPFLite", "HomeData", "MISSING")  ' Try getting the HomeData
         IF HomeFolder = "MISSING" THEN                           ' No V12 startup done yet
            HomeFolder = AppPath                                  ' Brand new, set default HomeFolder
            HomeData = AppPath                                    ' Brand new, set default HomeFolder
         ELSE                                                     ' We have HomeFolder
            IF ISFALSE ISFOLDER(HomeFolder) OR _                  ' If no HomeFolder  or
               ISFALSE ISFILE(HomeFolder + "SPFLite.CFG") THEN    ' If no CFG file
               i =DoMessageBox("|KSPFLite.CFG|B was not found in |K" + HomeFolder + $CRLF + _   '
                               "Enter |KCANCEL|B to terminate immediately." + $CRLF + _   '
                               "Enter |KOK|B to continue as a new installation. (A Default CFG File)", _ '
                               %MB_OKCANCEL OR %MB_USERICON OR %MB_DEFBUTTON2, "SPFLite CFG Missing") '
               IF i = %IDCANCEL THEN                              ' CANCEL?
                  ExitProcess(8)                                  ' Bail out.
               ELSEIF i = %IDYES THEN                             ' Treat as New
                  HomeData = HomeFolder                           ' Set HomeData
                  FirstTime = %True                               ' Force FirstTime
               END IF                                             '
            ELSE                                                  '
               FirstTime = %False                                 '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- New see if the Cmd line overrides anything                                                |
      '--------------------------------------------------------------------------------------------+
      CmdLine = COMMAND$                                          ' Get Command$
      InitFMFileList = ""                                         ' Initial FLIST name from command line
      InitFMMask = ""                                             ' Initial FM Mask from command line
      InitFMPath = ""                                             ' Initial FM Path from command line
      WorkingDir = CURDIR$                                        ' Get initial startup Working Directory
      FMode = "(e)"                                               ' Default to EDIT mode
      IF ISNOTNULL(CmdLine) THEN                                  ' Anything in COMMAND$
         '-----------------------------------------------------------------------------------------+
         '- Process the operands                                                                   |
         '-----------------------------------------------------------------------------------------+
         DO WHILE ISNOTNULL(TRIM$(CmdLine))                       ' Loop through operands
            CWord = GetNextWord(CmdLine, %Strip)                  ' Get a word from the command
            IF LEFT$(CWord,1) = "-" THEN CWord = UUCASE(CWord)    ' If a -xxx operand, ucase it
            '--------------------------------------------------------------------------------------+
            '- CLIP                                                                                |
            '--------------------------------------------------------------------------------------+
            IF cWord = LEFT$("-CLIP", LEN(CWord)) THEN            ' A CLIP request?
               InitClip = %True                                   '
               CmdLine = ""                                       ' Null anything else with CLIP
            '--------------------------------------------------------------------------------------+
            '- GOFM                                                                                |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-GOFM", LEN(CWord)) THEN        ' A GOFM request?
               PMode = %GoFM                                      ' Remember that
               CmdLine = ""                                       ' Null anything else with GOFM
            '--------------------------------------------------------------------------------------+
            '- WINE                                                                                |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-WINE", LEN(CWord)) THEN        ' A WINE request?
               WineMode = %True                                   ' Yes set flag
            '--------------------------------------------------------------------------------------+
            '- QUIET                                                                               |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-QUIET", LEN(CWord)) THEN       ' A QUIET request?
               QuietMode = %True                                 ' Yes set flag
            '--------------------------------------------------------------------------------------+
            '- NOLOOP                                                                              |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-NOLOOP", LEN(CWord)) THEN      ' A NOLOOP request?
               NoLoopMode = %True                                 ' Yes set flag
            '--------------------------------------------------------------------------------------+
            '- FILEOPEN                                                                            |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-FILEOPEN", LEN(CWord)) THEN    ' A FILEOPEN request?
               FileOpen = uucase(GetNextWord(CmdLine, %Strip))    ' Extract the filename string
               IF FileOpen = "*" THEN                             ' A Clipboard request?
                  FileOpen = gENV.HomeFolder + "_FILEOPEN.TXT"    ' Swap to it's location
               END IF                                             '
               StrUnquote(FileOpen)                               ' Remove any quotes
               FNum = FREEFILE                                    ' Get a file #
               Call3(TryOpenInput(FileOpen, FNum), _              ' Try the open
                     DoMessageBox("The -FILEOPEN file:" + $CRLF + "|K" + FileOpen + $CRLF + "|BCannot be found.", %MB_OK OR %MB_USERICON OR %MB_DEFBUTTON1, "Invalid -FILEOPEN"): ExitProcess(8), _   '
                     DoMessageBox("The -FILEOPEN file:" + $CRLF + "|K" + FileOpen + $CRLF + "|BCould not be opened.", %MB_OK OR %MB_USERICON OR %MB_DEFBUTTON1, "Invalid -FILEOPEN"): ExitProcess(8), _  '
                     Nul)                                         ' Continue
               FileOpen = ""                                      ' Reset
               DO WHILE ISFALSE EOF(FNum)                         ' Read the data
                  LINE INPUT # FNum, tt                           ' Get the line
                  FileOpen += TRIM$(tt)                           ' Build 1 big line
               LOOP                                               '
               CLOSE # FNum                                       ' Close the file
               REPLACE "," WITH "?" IN FileOpen                   ' Convert , to ?
               FileOpen = TRIM$(FileOpen)                         ' Trim it
               IF ISNULL(FileOpen) THEN _                         ' Better be something there
                     DoMessageBox("The -FILEOPEN data is empty.", %MB_OK OR %MB_USERICON OR %MB_DEFBUTTON1, "Invalid -FILEOPEN"): ExitProcess(8)   '
               '-----------------------------------------------------------------------------------+
               '- Validate (somewhat) the FileOpen string                                          |
               '-----------------------------------------------------------------------------------+
               tt = FileOpen                                      ' Get a temp copy
               IF LEFT$(tt, 1) = "?" THEN tt = CLIP$(LEFT, tt, 1) ' Peel off any leading / trailing ?
               IF RIGHT$(tt, 1) = "?" THEN tt = CLIP$(RIGHT, tt, 1)  '
               FOR i = 1 TO PARSECOUNT(tt, "?")                   ' Loop for each file in list
                  t = PARSE$(tt, "?", i)                          ' Get a filename
                  IF ISNULL(t) THEN _                             ' Null?
                     DoMessageBox("A -FILEOPEN filename is invalid.", %MB_OK OR %MB_USERICON OR %MB_DEFBUTTON1, "Invalid -FILEOPEN"): ExitProcess(8)  '
                  IF INSTR(t, "|") <> 0 THEN                      ' A MEdit list?
                     FOR j = 1 TO PARSECOUNT(t, "|")              ' Check it
                        IF ISNULL(PARSE$(t, "|", j)) THEN _       '
                           DoMessageBox("A -FILEOPEN MEdit filename is invalid.", %MB_OK OR %MB_USERICON OR %MB_DEFBUTTON1, "Invalid -FILEOPEN"): ExitProcess(8)  '
                     NEXT j                                       '
                  END IF                                          '
               NEXT i                                             '
            '--------------------------------------------------------------------------------------+
            '- INSTANCE                                                                            |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-INSTANCE", LEN(CWord)) THEN    ' An INSTANCE request?
               eInstance = uucase(GetNextWord(CmdLine, %Strip))   ' Extract the string
               IF VERIFY(eInstance, $Upper + $Numeric) > 0 THEN   ' Validate it
                  DoMessageBox("An Instance name cannot contain special characters.", %MB_OK OR %MB_USERICON OR %MB_DEFBUTTON1, "Invalid -INSTANCE")  '
                  ExitProcess(8)                                  ' Bail out.
               END IF                                             '
            '--------------------------------------------------------------------------------------+
            '- SCRSIZE                                                                             |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-SCRSIZE", LEN(cWord)) THEN     ' A SCRSIZE request?
               tt = GetNextWord(CmdLine, %Strip)                  ' Extract the operand
               tt = UCASE$(tt)                                    ' Uppercase it
               IF tt = "FULL" THEN                                ' SCRSIZE FULL?
                  lclMAXIMIZED = "T"                              ' Save it
               ELSE                                               ' Better now be hhXww value
                  lclScrHeight = VAL(tt)                          ' Get Height
                  lclScrWidth = VAL(MID$(tt, INSTR(tt, "X") + 1)) ' Get width
                  IF lclScrHeight < 10 OR lclScrHeight > 200 OR _ ' Reasonable values?
                     lclScrWidth  < 20 OR lclScrWidth > 400 THEN  '
                     lclScrHeight = 0: lclScrWidth = 0            ' No, forget the whole thing
                  ELSE                                            ' If OK
                     ScrPosition = ""                             ' Kill any previous screen position
                     lclMAXIMIZED = "F"                           ' Remove MAX just in case
                  END IF                                          '
               END IF                                             '
            '--------------------------------------------------------------------------------------+
            '- BROWSE                                                                              |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-BROWSE", LEN(CWord)) THEN      ' A BROWSE request?
               FMode = "(b)"                                      ' Remember that
            '--------------------------------------------------------------------------------------+
            '- VIEW                                                                                |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-VIEW", LEN(CWord)) THEN        ' A VIEW request?
               FMode = "(v)"                                      ' Remember that
            '--------------------------------------------------------------------------------------+
            '- OPEN                                                                                |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-OPEN", LEN(CWord)) THEN        ' An OPEN request?
               FMode = "(OE)": PMode = PMode AND %Open            ' Remember that
            '--------------------------------------------------------------------------------------+
            '- OPENE                                                                                |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-OPENE", LEN(CWord)) THEN       ' An OPENE request?
               FMode = "(OE)": PMode = PMode AND %Open            ' Remember that
            '--------------------------------------------------------------------------------------+
            '- OPENB                                                                               |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-OPENB", LEN(CWord)) THEN       ' An OPEN Browse?
               FMode = "(OB)": PMode = PMode AND %Open            ' Remember that
            '--------------------------------------------------------------------------------------+
            '- OPENV                                                                               |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-OPENV", LEN(CWord)) THEN       ' An OPEN View?
               FMode = "(OV)": PMode = PMode AND %Open            ' Remember that
            '--------------------------------------------------------------------------------------+
            '- KEYMAP                                                                              |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-KEYMAP", LEN(CWord)) THEN      ' A KEYMAP request?
               PMode = PMode OR %KeyMap                           ' Yes set flag
            '--------------------------------------------------------------------------------------+
            '- DO                                                                                  |
            '--------------------------------------------------------------------------------------+
            ELSEIF cWord = LEFT$("-DO", LEN(CWord)) THEN          ' A DO macro request?
               iDo = GetNextWord(CmdLine, %Strip)                 ' Extract the string
            '--------------------------------------------------------------------------------------+
            '- Maybe a .Profile name                                                               |
            '--------------------------------------------------------------------------------------+
            ELSEIF CmdLine <> "" AND LEFT$(cWord, 1) = "." THEN   '
               InitProfile = cWord                                ' Save as Profilename

            '--------------------------------------------------------------------------------------+
            '- Maybe a %Macroname                                                                  |
            '--------------------------------------------------------------------------------------+
            ELSEIF CmdLine <> "" AND LEFT$(cWord, 1) = "%" THEN   '
               InitMacro = cWord                                  ' Save as IMacroname

            '--------------------------------------------------------------------------------------+
            '- Maybe a /Macroname                                                                  |
            '--------------------------------------------------------------------------------------+
            ELSEIF CmdLine <> "" AND LEFT$(cWord, 1) = "/" THEN   '
               InitXForm = cWord                                  ' Save as XMacroname

            '--------------------------------------------------------------------------------------+
            '- Must be a filename or FM Path/Mask request then                                     |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  ' Anything else must be a filename
               t = CWord                                          ' Save it
               StrUnQuote(t)                                      ' Remove quotes
               IF LEFT$(t, 2) <> "\\" THEN                        ' Don't do UNC names
                  IF LEFT$(t, 1) = "\" THEN t = CLIP$(LEFT, t, 1) ' Strip off any leading \
               END IF                                             '
               IF ISNOTNULL(t) THEN                               ' Adjust if something there
                  IF RIGHT$(t, 1) = ":" THEN t += "\"             ' If simple trailing :, add a  \
                  IF RIGHT$(t, 1) = "\" THEN t += "*"             ' If simple trailing \, add an *

                  '--------------------------------------------------------------------------------+
                  '- Any Wild card chars                                                           |
                  '--------------------------------------------------------------------------------+
                  IF INSTR(t, ANY "*?") = 0 THEN                  ' No wild card characters?

                     '-----------------------------------------------------------------------------+
                     '- We have a simple filename                                                  |
                     '-----------------------------------------------------------------------------+
                     IF ISNOTNULL(FileOpen) THEN                  ' Should be no FILEOPEN
                        DoMessageBox("No filename is allowed when using -FILEOPEN", %MB_OK OR %MB_USERICON OR %MB_DEFBUTTON1, "Invalid -INSTANCE") '
                        ExitProcess(8)                            ' Bail out.
                     END IF                                       '
                     IF LEFT$(t, 2) = ".\" THEN t = WorkingDir + MID$(t, 2)   ' Convert . to WorkingDir
                     IF INSTR(t, "\") = 0 THEN _                  ' If not a full path specified
                        t = WorkingDir + "\" + t                  ' Add the current directory
                     IF ISFOLDER(t) THEN                          ' Folder?
                        InitFMPath = t + "\"                      ' Use for the path
                        InitFMMask = "*"                          ' Use * for Mask
                        INITFMFileList = "$Null$"                 ' Tell InitFManager that FMFileListNm is really null
                        t = ""                                    ' Kill the InitString
                     END IF                                       '

                  '--------------------------------------------------------------------------------+
                  '- Some kind of wild card request                                                |
                  '--------------------------------------------------------------------------------+
                  ELSE                                            '
                     IF INSTR(t, ANY "\") > 0 THEN                ' Got a directory level?
                        InitFMPath = LEFT$(t, INSTR(-1, t, "\"))  ' Extract path
                        InitFMMask = MID$(t, INSTR(-1, t, "\") + 1)  ' Peel off Mask
                        IF InitFMMask = "" THEN InitFMMask = "*"  ' If no mask, use *
                        InitFMFileList = "$Null$"                 ' Tell InitFManager that FileListNm is really null
                        t = ""                                    ' Kill the InitString
                     ELSE                                         '
                        InitFMMask = t                            ' Make what's left the FM File Mask
                        InitFMPath = CURDIR$ + "\"                ' Use the CurDir for the path
                        InitFMFileList = "$Null$"                 ' Tell InitFManager that FMFileListNm is really null
                        t = ""                                    ' Kill the InitString
                     END IF                                       '
                     IF INSTR(InitFMPath, ANY "*?") > 0 THEN      ' Invalid wild cards in FM File Path?
                        InitFMPath = "": InitFMMask = ""          ' Yes, kill what we did, the path will fail
                        InitFMFileList = "$Null$"                 ' Tell InitFManager that FMFileListNm is really null
                        t = ""                                    ' Kill the InitString
                     ELSE                                         '
                        t = ""                                    ' Kill InitString
                     END IF                                       '
                  END IF                                          '
               ELSE                                               '
                  t = "NEW"                                       '
               END IF                                             '
               IF ISNOTNULL(t) THEN                               ' Anything left in cmd line
                  InitString = FMode + t                          ' Yes, make it (E)filename
               ELSEIF ISNOTNULL(FileOpen) THEN                    ' No - something in FileOpen
                  InitString = FileOpen                           ' Yep, swap into InitString
               END IF                                             '
            END IF                                                '
         LOOP                                                     ' End of operand loop
         IF ISNULL(InitString) AND ISNOTNULL(FileOpen) THEN InitString = FileOpen   '
      END IF                                                      '

      IF FirstTime = %True THEN                                   ' If its the first time
         gENV.DispWelcome                                         ' Go display and get initial KB, HomeFolder options
         DIALOG NEW 0, "SPFLite Welcome", 0, 0, 200, 20, %WS_THICKFRAME OR %WS_CAPTION OR %WS_DISABLED TO ghPatience '
         DIALOG SET COLOR ghWel, %RGB_GAINSBORO, %RGB_GAINSBORO   '
         CONTROL ADD LABEL,  ghPatience, %WELCOME_TEXT+0, "Please be patient. This will take a moment", 5, 5, 200, 14   '
         DIALOG SHOW MODELESS ghPatience                          ' Fire it up
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Ensure the App path exists                                                                |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE ISFOLDER(HomeFolder) THEN MKDIR HomeFolder       ' Make sure HomeFolder exists

      '--------------------------------------------------------------------------------------------+
      '- Ensure HomeFolder/Data saved                                                              |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE Roaming THEN                                     '
         RegistrySet("Software\SPFLite", "HomeFolder", HomeFolder)   ' Save them
         RegistrySet("Software\SPFLite", "HomeData", HomeData)    '
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Open our SQL CFG file                                                                     |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE gSQL.DBOpen(HomeFolder + "SPFLite.CFG") THEN     ' Open the CFG file
         DoMessageBox "SPFLite.CFG file failed to Open", _        ' Tell User
                      %MB_OK OR %MB_USERICON, "CFG Open"          '
         ExitProcess(8)                                           ' Bail out.
      END IF                                                      ' Do something???

      '--------------------------------------------------------------------------------------------+
      '- Establish basic CFG tables                                                                |
      '--------------------------------------------------------------------------------------------+
      t = "OPKBRSE"                                               ' Set table IDs to create
      FOR i = 1 TO LEN(t)                                         ' Loop through them
         IF ISFALSE gSQL.TableCreate(MID$(t, i, 1) + "DEFAULT") THEN ' Create the tables
            DoMessageBox "SPFLite.CFG Table (" + MID$(t, i, 1) + ") failed to Initialize", _ ' Tell User
                         %MB_OK OR %MB_USERICON, "CFG Open"       '
            ExitProcess(8)                                        ' Bail out.
         END IF                                                   '
      NEXT i                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Set the HomeFolder into the Registry now                                                  |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE Roaming THEN                                     '
         RegistrySet("Software\SPFLite", "HomeFolder", HomeFolder)   ' Save as long as not roaming
         RegistrySet("Software\SPFLite", "HomeData", HomeData)    '
      END IF                                                      '
      gENV.HomeFolder = HomeFolder                                ' Stuff them in gENV
      gENV.HomeData  = HomeData                                   '

      '--------------------------------------------------------------------------------------------+
      '- See if an Instance requested                                                              |
      '--------------------------------------------------------------------------------------------+
      IF eInstance <> "" THEN                                     ' Was INSTANCE specified?
         IF gSQL.GetStringDirect("ODEFAULT", "LastAccess", "*MISSING*") = "*MISSING*" THEN   ' Does DEFAULT exist
            DoMessageBox "Cannot use -INSTANCE on initial execution",%MB_OK,"SPFLite"  '
            ExitProcess(8)                                        ' Bail out
         END IF                                                   '
         IF ISFALSE gSQL.TableExist("O" + eInstance) THEN         ' If INSTANCE table does not exist
            IF DispInstance(eInstance) THEN                       ' Go get user's choices for sharing
               DoMessageBox "New Instance creation cancelled",%MB_OK,"SPFLite"   '
               ExitProcess(8)                                     ' Bail out
            END IF                                                '
         END IF                                                   '
         gSQL.OptName = eInstance                                 ' Swap Options to the Instance name
         HomeFolder  = gSQL.GetString("O", "HomeFolder", AppPath) ' Get the new Home Folder
         HomeData    = gSQL.GetString("O", "HomeData", AppPath)   ' Get the new Data Folder
         gSQL.BkpName = gSQL.GetString("O", "HomeBkpName", "DEFAULT")   ' Get possible alternate table names
         gSQL.EFTName = gSQL.GetString("O", "HomeEFTName", "DEFAULT")   '
         gSQL.KbdName = gSQL.GetString("O", "HomeKbdName", "DEFAULT")   '
         gSQL.RtrName = gSQL.GetString("O", "HomeRtrName", "DEFAULT")   '
         gSQL.SetName = gSQL.GetString("O", "HomeSetName", "DEFAULT")   '
      ELSE                                                        ' Else set DEFAULT
         eInstance = "DEFAULT"                                    '
         IF FirstTime THEN                                        ' Get Options version of HomeFolder/Data set up
            gSQL.AddString("O", "HomeFolder", HomeFolder)         '
            gSQL.AddString("O", "HomeData", HomeData)             '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If command line Mask override, get FMDefMaster adjusted                                   |
      '--------------------------------------------------------------------------------------------+
      IF InitFMMask <> "" THEN                                    ' Have an override?
         gENV.GetFMCrit("FILEPATH", tDirSort, tDefSort, tFMask, gFMLayoutID)   ' Get the FMDefCrit value
         gENV.SetFMCrit(tDirSort, tDefSort, InitFMMask, gFMLayoutID)           ' Set with a new mask value
      END IF                                                      '

      IF VAL(gSQL.GetString("O", "Splash", "0")) THEN DispSplash  ' Display Splash as early as possible

      IF FirstTime THEN                                           ' Never been executed before?

         '-----------------------------------------------------------------------------------------+
         '- Do some First Time stuff                                                               |
         '-----------------------------------------------------------------------------------------+
         IF ISFALSE ISFOLDER(HomeData + "AUTO\")   THEN MKDIR HomeData + "AUTO\"       ' Ensure \AUTO exists
         IF ISFALSE ISFOLDER(Homedata + "CLIP\")   THEN MKDIR Homedata + "CLIP\"       ' Ensure \CLIP exists
         IF ISFALSE ISFOLDER(HomeData + "FILELIST\")  THEN MKDIR HomeData + "FILELIST\"' Ensure \FLIST exists
         IF ISFALSE ISFOLDER(HomeData + "JOBS\")   THEN MKDIR HomeData + "JOBS\"       ' Ensure \JOBS exists
         IF ISFALSE ISFOLDER(HomeData + "MACROS\") THEN MKDIR HomeData + "MACROS\"     ' Ensure \MACROS exists
         IF ISFALSE ISFOLDER(HomeData + "RUN\")    THEN MKDIR HomeData + "RUN\"        ' Ensure \RUN exists
         IF ISFALSE ISFOLDER(HomeData + "STATE\")  THEN MKDIR HomeData + "STATE\"      ' Ensure \STATE exists
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now load everything from the SQL file                                                     |
      '--------------------------------------------------------------------------------------------+
      gSQL.SelBegin("select * FROM " + $DQ + "O" + eInstance + $DQ)  ' Ask for everything
      IF gSQL.SelFirst() THEN                                     ' Select the first
         DO                                                       ' Loop through them
            i = gKwd.GetIXByName(gSQL.SelGet("DBKey"))            ' Return IX Entry for a Kwd Name
            IF i THEN                                             ' Got it
               gKwd.GetByIX(lclKwd, i)                            ' Fetch full entry
               IF lclKwd.TType <> "O" THEN ITERATE DO             ' KW from wrong table
               gKwd.SetFlag(i)                                    ' Say we've seen it
               IF lclKwd.VType = "S" THEN                         ' String value?
                  lclKwd.VPointer.@SVar = TRIM$(gSQL.SelGet("DBData"))  ' Yes, string, stuff it in
               ELSEIF lclKwd.VType = "L" THEN                     ' LONG value?
                  lclKwd.VPointer.@LVar = VAL(gSQL.SelGet("DBData")) ' Yes, a number, convert and stuff it in
               ELSE                                               ' Only SINGLE is left
                  lclKwd.VPointer.@FVar = VAL(gSQL.SelGet("DBData")) ' A Floating number, convert and stuff it in
               END IF                                             '
            ELSE                                                  '
            END IF                                                '
         LOOP WHILE gSQL.SelNext()                                '
      END IF                                                      '
      gSQL.SelEnd                                                 ' Close the SQL request

      '--------------------------------------------------------------------------------------------+
      '- Now see if all items were loaded                                                          |
      '--------------------------------------------------------------------------------------------+
      FOR i = 1 TO gKwd.KCtr                                      ' Look for unSEEN items
         IF FirstTime THEN gSQL.Execute("PRAGMA synchronous = OFF")  ' To optimize things
         IF ISFALSE gKwd.GetFlag(i) THEN                          ' Didn't get this one?
            gKwd.GetByIX(lclKwd, i)                               ' Fetch it's entry
            IF lclKwd.TType <> "O" THEN ITERATE FOR               ' KW from wrong table
            gSQL.SetString("O", UCASE$(TRIM$(lclKwd.Name)), TRIM$(lclKwd.DefaultStr))  '
            IF lclKwd.VType = "S" THEN                            ' String value?
               lclKwd.VPointer.@SVar = TRIM$(lclKwd.DefaultStr)   ' Yes, string, stuff it in
            ELSEIF lclKwd.VType = "L" THEN                        ' LONG?
               lclKwd.VPointer.@LVar = VAL(lclKwd.DefaultStr)     ' Yes, a number, convert and stuff it in
            ELSE                                                  ' Only SINGLE is left
               lclKwd.VPointer.@FVar = VAL(lclKwd.DefaultStr)     ' Yes, a Floating number, convert and stuff it in
            END IF                                                '
         END IF                                                   '
      NEXT i                                                      '
      IF FirstTime THEN gSQL.Execute("PRAGMA synchronous = ON")   ' Reset synchronous

      '--------------------------------------------------------------------------------------------+
      '- Override SCRsizes if specified on command line                                            |
      '--------------------------------------------------------------------------------------------+
      IF lclScrHeight <> 0 AND lclScrWidth <> 0 THEN              ' -SCRSIZE specified?
         ScrHeight = lclScrHeight: ScrWidth = lclScrWidth         ' Override them
      END IF                                                      '
      IF lclMAXIMIZED <> "" THEN MAXIMIZED = IIF(lclMAXIMIZED = "T", %True, %False) ' -SCRSIZE MAX specified?

      '--------------------------------------------------------------------------------------------+
      '- Now tweak those variables that need a bit of setup                                        |
      '--------------------------------------------------------------------------------------------+
      ScrWidth = MAX(30, ScrWidth): ScrHeight = MAX(10, ScrHeight) ' Ensure minimum
      SubmitDir = Homedata + "JOBS"                               ' Jobs is now a fixed location

      IF gENV.ENGChars THEN                                       ' Using ENGLISH only letters ?
         CharSet = $DefCharSet                                    ' Set it to include only ENGLISH
      ELSE                                                        '
         CharSet = $DefCharSet + $UpperNat + $LowerNat            ' Set it to include International
      END IF                                                      '

      CharSetR = CharSet                                          ' Massage into RegEx string
      REPLACE "\" WITH "\x5C" IN CharSetR                         '
      REPLACE "[" WITH "\x5B" IN CharSetR                         '
      REPLACE "]" WITH "\x5D" IN CharSetR                         '

      IF TRIM$(InvChar) = "" THEN InvChar = " "                   ' Ensure InvChar blanks is allowed

      i = GetSystemMetrics(%SM_CXVirtualScreen)                   ' Get width of virtual screen
      j = GetSystemMetrics(%SM_XVirtualScreen)                    ' Get left hand side of virtual screen
      IF i <> 0 THEN                                              ' Validate a bit
         IF LastScreenX < j OR LastScreenX > i+j THEN LastScreenX = 5   '
      END IF                                                      '
      i = GetSystemMetrics(%SM_CYVirtualScreen)                   ' Get height of virtual screen
      j = GetSystemMetrics(%SM_YVirtualScreen)                    ' Get top of virtual screen
      IF i <> 0 THEN                                              ' Validate a bit
         IF LastScreenY < j OR LastScreenY > i+j THEN LastScreenY = 5   '
      END IF                                                      '

      NotifyLevelT       = NotifyLevel                            '
      NormalizeCharMap(PDotRaw, pDotString)                       ' Convert to a real string
      IF PrtDuplex = 0 THEN PrtDuplex = 1                         '
      GetSystemTime SystemTimeArea                                ' Get the current time
      SystemtimeToFileTime SystemTimeArea, LastWriteTime.lft      ' Put it in LastWriteTime
      t = TimePretty(LastWriteTime.lq)                            ' Get formatted version
      IF LEFT$(t, 10) <> LEFT$(LastAccess, 10) THEN               ' A different day?
         gSQL.UpdateString("O", "DiffALB", "1")                   ' Reset Diff Bounds to 1,MAX
         gSQL.UpdateString("O", "DiffARB", "0")                   '
         gSQL.UpdateString("O", "DiffBLB", "1")                   '
         gSQL.UpdateString("O", "DiffBRB", "0")                   '
         DiffALB = 1: DiffARB = 0                                 '
         DiffBLB = 1: DiffBRB = 0                                 '
      END IF                                                      '
      gSQL.UpdateString("O", "LastAccess", t)                     ' Save the new Last Access time

      '--------------------------------------------------------------------------------------------+
      '- Get the EFT table loaded                                                                  |
      '--------------------------------------------------------------------------------------------+
      SQLArrayLoad("E" + eInstance, gEFTRaw(), gEFTRawCtr)        ' Load the EFT data
      IF gEFTRawCtr = 0 THEN                                      ' First time. or empty EFT table
         REDIM gEFTRaw(1 TO 1) AS STRING                          ' Create one
         gEFTRawCtr = 1                                           '
         gEFTRaw(1) = "; Enter your EFT entries following this line" '
      END IF                                                      '
      EFTRawLoad                                                  ' Process RAW into final tables

      '--------------------------------------------------------------------------------------------+
      '- Build the DEFAULT profile                                                                 |
      '--------------------------------------------------------------------------------------------+
      gENV.BuildDefaultProfile                                    ' Go build a default Profile
      gSQL.UpdateString("O", "Build", PgmVers)                    ' Save latest version
      gENV.SetGlobalClrs                                          ' Copy all colors to Global

      '--------------------------------------------------------------------------------------------+
      '- Build the SchAlias table                                                                  |
      '--------------------------------------------------------------------------------------------+
      PARSE SchAliasAll, SchAlias(), ","                          ' Break it out

      '--------------------------------------------------------------------------------------------+
      '- Setup the SET Table                                                                       |
      '--------------------------------------------------------------------------------------------+
      SQLArrayLoad(gSQL.SetName, gSetRaw(), gSetRawCtr)           ' Let SQLArrayLoad do the work
      IF gSetRawCtr THEN                                          ' If we have some
         REDIM gSetKey(1 TO gSetRawCtr) AS GLOBAL STRING          '
         REDIM gSetData(1 TO gSetRawCtr) AS GLOBAL STRING         '
         FOR j = 1 TO gSetRawCtr                                  ' Process the table
            t = gSetRaw(j)                                        ' Get next entry
            IF INSTR(t, ";") THEN                                 ' Comment?
               t = LEFT$(t, INSTR(t, ";") - 1)                    ' Remove it
               IF ISNULL(t) THEN ITERATE FOR                      ' If nothing left, skip it
            END IF                                                '
            IF UCASE$(LEFT$(t, 4)) = "SET " THEN t = MID$(t, 5)   ' Remove redundant SET command
            i = INSTR(t, "=")                                     ' Locate =
            IF i THEN                                             ' Got one
               INCR gSetCount                                     ' Count entry
               gSetKey(gSetCount) = TRIM$(LEFT$(t, i - 1))        ' Set key
               gSetData(gSetCount) = TRIM$(MID$(t, i + 1))        ' Set Data
               REPLACE "|" WITH ";" IN gSetData(gSetCount)        ' Handle the ; collision
            END IF                                                '
         NEXT j                                                   '
      ELSE                                                        '
         REDIM gSetKey(1 TO 1) AS GLOBAL STRING                   '
         REDIM gSetData(1 TO 1) AS GLOBAL STRING                  '
         REDIM gSetRaw(1 TO 1) AS GLOBAL STRING                   '
      END IF                                                      '


      '--------------------------------------------------------------------------------------------+
      '- Add some SET symbols to aid conversion to RESET UL and XL keywords.                       |
      '--------------------------------------------------------------------------------------------+
      SETTableUpd("GET", "ALIAS.RESET.X", RCA)                    ' See if we've done this already
      IF RCA.RC <> 0 THEN                                         ' Not Found?
         SETTableUpd("SET", "ALIAS.RESET.X RESET XL", RCA)        ' SET it now
         SETTableUpd("SET", "ALIAS.RES.X RESET XL", RCA)          '
         SETTableUpd("SET", "ALIAS.RESET.U RESET UL", RCA)        '
         SETTableUpd("SET", "ALIAS.RES.U RESET UL", RCA)          '
      END IF                                                      '

      EXIT METHOD                                                 '

      LoadKWTable:                                                ' Load our keyword table
      gKwd.SetKwdPtr("AttnPos",        VARPTR(AttnPos))           '
      gKwd.SetKwdPtr("AutoScrl",       VARPTR(AutoScroll))        '
      gKwd.SetKwdPtr("Banding",        VARPTR(Banding))           '
      gKwd.SetKwdPtr("BandingColor",   VARPTR(PrtBandColor))      '
      gKwd.SetKwdPtr("BandLines",      VARPTR(PrtBandLines))      '
      gKwd.SetKwdPtr("ABeepFlag",      VARPTR(ABeepFlag))         '
      gKwd.SetKwdPtr("BKPMaxGen",      VARPTR(BKPMaxGen))         '
      gKwd.SetKwdPtr("BKPMinGen",      VARPTR(BKPMinGen))         '
      gKwd.SetKwdPtr("BKPRetention",   VARPTR(BKPRetention))      '
      gKwd.SetKwdPtr("BM",             VARPTR(PrtBMargin))        '
      gKwd.SetKwdPtr("BrowseWarn",     VARPTR(ViewWarn))          '
      gKwd.SetKwdPtr("Build",          VARPTR(Build))             '
      gKwd.SetKwdPtr("CDelFlag",       VARPTR(ConfDelFlag))       '
      gKwd.SetKwdPtr("CharSet",        VARPTR(CharSet))           '
      gKwd.SetKwdPtr("cMarkLine",      VARPTR(cMarkLine))         '
      gKwd.SetKwdPtr("CmdChr",         VARPTR(CmdChr))            '
      gKwd.SetKwdPtr("CMDFlags",       VARPTR(CMDFlags))          '
      gKwd.SetKwdPtr("CmdHiLite",      VARPTR(CmdHiLite))         '
      gKwd.SetKwdPtr("Color",          VARPTR(PrtPColor))         '
      gKwd.SetKwdPtr("CursIns",        VARPTR(CursInsert))        '
      gKwd.SetKwdPtr("CursInsVert",    VARPTR(VertInsCurs))       '
      gKwd.SetKwdPtr("CursNorm",       VARPTR(CursNormal))        '
      gKwd.SetKwdPtr("CustomClr",      VARPTR(CustomClr))         '
      gKwd.SetKwdPtr("CutNew",         VARPTR(CutNew))            '
      gKwd.SetKwdPtr("DBConsoleX",     VARPTR(DBConsoleX))        '
      gKwd.SetKwdPtr("DBConsoleY",     VARPTR(DBConsoleY))        '
      gKwd.SetKwdPtr("DefDataShift",   VARPTR(DefDataShift))      '
      gKwd.SetKwdPtr("DefMask",        VARPTR(FMMask))            '
      gKwd.SetKwdPtr("DiffMinMatch",   VARPTR(DiffMinMatch))      '
      gKwd.SetKwdPtr("Diff1Column",    VARPTR(Diff1Column))       '
      gKwd.SetKwdPtr("DiffUseFileB",   VARPTR(DiffUseFileB))      '
      gKwd.SetKwdPtr("DiffOnly",       VARPTR(DiffOnly))          '
      gKwd.SetKwdPtr("DiffALB",        VARPTR(DiffALB))           '
      gKwd.SetKwdPtr("DiffARB",        VARPTR(DiffARB))           '
      gKwd.SetKwdPtr("DiffANX",        VARPTR(DiffANX))           '
      gKwd.SetKwdPtr("DiffAX",         VARPTR(DiffAX))            '
      gKwd.SetKwdPtr("DiffNoSpace",    VARPTR(DiffNoSpace))       '
      gKwd.SetKwdPtr("DiffNoTab",      VARPTR(DiffNoTab))         '
      gKwd.SetKwdPtr("DiffNoComment",  VARPTR(DiffNoComment))     '
      gKwd.SetKwdPtr("DiffNoCASE",     VARPTR(DiffNoCASE))        '
      gKwd.SetKwdPtr("DiffNoMultB",    VARPTR(DiffNoMultB))       '
      gKwd.SetKwdPtr("DiffBLB",        VARPTR(DiffBLB))           '
      gKwd.SetKwdPtr("DiffBRB",        VARPTR(DiffBRB))           '
      gKwd.SetKwdPtr("DiffBNX",        VARPTR(DiffBNX))           '
      gKwd.SetKwdPtr("DiffBX",         VARPTR(DiffBX))            '
      gKwd.SetKwdPtr("Duplex",         VARPTR(PrtDuplex))         '
      gKwd.SetKwdPtr("ENGChars",       VARPTR(ENGChars))          '
      gKwd.SetKwdPtr("FileLineFmt",    VARPTR(FileLineFmt))       '
      gKwd.SetKwdPtr("FCenter",        VARPTR(PrtFooterCenter))   '
      gKwd.SetKwdPtr("FindWord",       VARPTR(FindWord))          '
      gKwd.SetKwdPtr("FLeft",          VARPTR(PrtFooterLeft))     '
      gKwd.SetKwdPtr("FMDateHiLite",   VARPTR(FMDateHiLite))      '
      gKwd.SetKwdPtr("FMDefMaster",    VARPTR(FMDefMaster))       '
      gKwd.SetKwdPtr("DefDir1",        VARPTR(FMPath))            '
      gKwd.SetKwdPtr("FMHelpFlag",     VARPTR(FMHelpFlag))        '
      gKwd.SetKwdPtr("FMLayout",       VARPTR(FMLayout))          '
      gKwd.SetKwdPtr("FMLayoutM",      VARPTR(FMLayoutM))         '
      gKwd.SetKwdPtr("FMLCmdWidth",    VARPTR(FMLCmdWidth))       '
      gKwd.SetKwdPtr("FMOpFlag",       VARPTR(FMCloseFlag))       '
      gKwd.SetKwdPtr("FMSortSimple",   VARPTR(FMSortSimple))      '
      gKwd.SetKwdPtr("FontName",       VARPTR(FontName))          '
      gKwd.SetKwdPtr("FontPitch",      VARPTR(FontPitch))         '
      gKwd.SetKwdPtr("FontStyle",      VARPTR(FontStyle))         '
      gKwd.SetKwdPtr("Footers",        VARPTR(PrtFooter))         '
      gKwd.SetKwdPtr("FRight",         VARPTR(PrtFooterRight))    '
      gKwd.SetKwdPtr("GlueWith",       VARPTR(GlueWith))          '
      gKwd.SetKwdPtr("HCenter",        VARPTR(PrtHeaderCenter))   '
      gKwd.SetKwdPtr("Headers",        VARPTR(PrtHeader))         '
      gKwd.SetKwdPtr("HLeft",          VARPTR(PrtHeaderLeft))     '
      gKwd.SetKwdPtr("HomeFolder",     VARPTR(HomeFolder))        '
      gKwd.SetKwdPtr("HomeData",       VARPTR(HomeData))          '
      gKwd.SetKwdPtr("HomeBkpName",    VARPTR(HomeBkpName))       '
      gKwd.SetKwdPtr("HomeKbdName",    VARPTR(HomeKbdName))       '
      gKwd.SetKwdPtr("HomeEFTName",    VARPTR(HomeEFTName))       '
      gKwd.SetKwdPtr("HomeRtrName",    VARPTR(HomeRtrName))       '
      gKwd.SetKwdPtr("HomeSetName",    VARPTR(HomeSetName))       '
      gKwd.SetKwdPtr("HRight",         VARPTR(PrtHeaderRight))    '
      gKwd.SetKwdPtr("HRuler",         VARPTR(HRuler))            '
      gKwd.SetKwdPtr("HelpIntro",      VARPTR(HelpIntro))         '
      gKwd.SetKwdPtr("HelpOpen",       VARPTR(HelpOpen))          '
      gKwd.SetKwdPtr("InsMode",        VARPTR(InsMode))           '
      gKwd.SetKwdPtr("InsReset",       VARPTR(InsReset))          '
      gKwd.SetKwdPtr("InvChar",        VARPTR(InvChar))           '
      gKwd.SetKwdPtr("JobNumber",      VARPTR(JobNumber))         '
      gKwd.SetKwdPtr("KBHelp",         VARPTR(PFKShow))           '
      gKwd.SetKwdPtr("KBScrollH",      VARPTR(KBHorScroll))       '
      gKwd.SetKwdPtr("KBScrollV",      VARPTR(KBVerScroll))       '
      gKwd.SetKwdPtr("LANG",           VARPTR(LANG))              '
      gKwd.SetKwdPtr("LastAccess",     VARPTR(LastAccess))        '
      gKwd.SetKwdPtr("LastScrX",       VARPTR(LastScreenX))       '
      gKwd.SetKwdPtr("LastScrY",       VARPTR(LastScreenY))       '
      gKwd.SetKwdPtr("LineRepeatMax",  VARPTR(LinRepeatMax))      '
      gKwd.SetKwdPtr("LM",             VARPTR(PrtLMargin))        '
      gKwd.SetKwdPtr("LNoSize",        VARPTR(LinNoSize))         '
      gKwd.SetKwdPtr("MacName",        VARPTR(MacName))           '
      gKwd.SetKwdPtr("Maximized",      VARPTR(MAXIMIZED))         '
      gKwd.SetKwdPtr("Metric",         VARPTR(PrtMetric))         '
      gKwd.SetKwdPtr("MinRetrieve",    VARPTR(MinRetrieve))       '
      gKwd.SetKwdPtr("MinToTray",      VARPTR(MinToTray))         '
      gKwd.SetKwdPtr("MRFList",        VARPTR(MRFList))           '
      gKwd.SetKwdPtr("Name",           VARPTR(PrtName))           '
      gKwd.SetKwdPtr("Notify",         VARPTR(NotifyLevel))       '
      gKwd.SetKwdPtr("Orient",         VARPTR(PrtOrient))         '
      gKwd.SetKwdPtr("PanelMax",       VARPTR(PanelMax))          '
      gKwd.SetKwdPtr("Paper",          VARPTR(PrtPaper))          '
      gKwd.SetKwdPtr("pBanding",       VARPTR(PrtBanding))        '
      gKwd.SetKwdPtr("PDotRaw",        VARPTR(pDotRaw))           '
      gKwd.SetKwdPtr("Pitch",          VARPTR(PrtFontPitch))      '
      gKwd.SetKwdPtr("FileListNm",     VARPTR(FileListNm))        '
      gKwd.SetKwdPtr("RecentCtr",      VARPTR(RecentCtr))         '
      gKwd.SetKwdPtr("ResetU",         VARPTR(ResetU))            '
      gKwd.SetKwdPtr("RM",             VARPTR(PrtRMargin))        '
      gKwd.SetKwdPtr("ROpenLast",      VARPTR(ReOpenLast))        '
      gKwd.SetKwdPtr("RUNFlags",       VARPTR(RUNFlags))          '
      gKwd.SetKwdPtr("SBLayout",       VARPTR(SBLayout))          '
      gKwd.SetKwdPtr("SBFactor",       VARPTR(SBFactor))          '
      gKwd.SetKwdPtr("SchAliasAll",    VARPTR(SchAliasAll))       '
      gKwd.SetKwdPtr("Scheme00BG1",    VARPTR(Scheme(00, 2)))     '
      gKwd.SetKwdPtr("Scheme00BG2",    VARPTR(Scheme(00, 3)))     '
      gKwd.SetKwdPtr("Scheme00FG",     VARPTR(Scheme(00, 1)))     '
      gKwd.SetKwdPtr("Scheme01BG1",    VARPTR(Scheme(01, 2)))     '
      gKwd.SetKwdPtr("Scheme01BG2",    VARPTR(Scheme(01, 3)))     '
      gKwd.SetKwdPtr("Scheme01FG",     VARPTR(Scheme(01, 1)))     '
      gKwd.SetKwdPtr("Scheme02BG1",    VARPTR(Scheme(02, 2)))     '
      gKwd.SetKwdPtr("Scheme02BG2",    VARPTR(Scheme(02, 3)))     '
      gKwd.SetKwdPtr("Scheme02FG",     VARPTR(Scheme(02, 1)))     '
      gKwd.SetKwdPtr("Scheme03BG1",    VARPTR(Scheme(03, 2)))     '
      gKwd.SetKwdPtr("Scheme03BG2",    VARPTR(Scheme(03, 3)))     '
      gKwd.SetKwdPtr("Scheme03FG",     VARPTR(Scheme(03, 1)))     '
      gKwd.SetKwdPtr("Scheme04BG1",    VARPTR(Scheme(04, 2)))     '
      gKwd.SetKwdPtr("Scheme04BG2",    VARPTR(Scheme(04, 3)))     '
      gKwd.SetKwdPtr("Scheme04FG",     VARPTR(Scheme(04, 1)))     '
      gKwd.SetKwdPtr("Scheme05BG1",    VARPTR(Scheme(05, 2)))     '
      gKwd.SetKwdPtr("Scheme05BG2",    VARPTR(Scheme(05, 3)))     '
      gKwd.SetKwdPtr("Scheme05FG",     VARPTR(Scheme(05, 1)))     '
      gKwd.SetKwdPtr("Scheme06BG1",    VARPTR(Scheme(06, 2)))     '
      gKwd.SetKwdPtr("Scheme06BG2",    VARPTR(Scheme(06, 3)))     '
      gKwd.SetKwdPtr("Scheme06FG",     VARPTR(Scheme(06, 1)))     '
      gKwd.SetKwdPtr("Scheme07BG1",    VARPTR(Scheme(07, 2)))     '
      gKwd.SetKwdPtr("Scheme07BG2",    VARPTR(Scheme(07, 3)))     '
      gKwd.SetKwdPtr("Scheme07FG",     VARPTR(Scheme(07, 1)))     '
      gKwd.SetKwdPtr("Scheme08BG1",    VARPTR(Scheme(08, 2)))     '
      gKwd.SetKwdPtr("Scheme08BG2",    VARPTR(Scheme(08, 3)))     '
      gKwd.SetKwdPtr("Scheme08FG",     VARPTR(Scheme(08, 1)))     '
      gKwd.SetKwdPtr("Scheme09BG1",    VARPTR(Scheme(09, 2)))     '
      gKwd.SetKwdPtr("Scheme09BG2",    VARPTR(Scheme(09, 3)))     '
      gKwd.SetKwdPtr("Scheme09FG",     VARPTR(Scheme(09, 1)))     '
      gKwd.SetKwdPtr("Scheme10BG1",    VARPTR(Scheme(10, 2)))     '
      gKwd.SetKwdPtr("Scheme10BG2",    VARPTR(Scheme(10, 3)))     '
      gKwd.SetKwdPtr("Scheme10FG",     VARPTR(Scheme(10, 1)))     '
      gKwd.SetKwdPtr("Scheme11BG1",    VARPTR(Scheme(11, 2)))     '
      gKwd.SetKwdPtr("Scheme11BG2",    VARPTR(Scheme(11, 3)))     '
      gKwd.SetKwdPtr("Scheme11FG",     VARPTR(Scheme(11, 1)))     '
      gKwd.SetKwdPtr("Scheme12BG1",    VARPTR(Scheme(12, 2)))     '
      gKwd.SetKwdPtr("Scheme12BG2",    VARPTR(Scheme(12, 3)))     '
      gKwd.SetKwdPtr("Scheme12FG",     VARPTR(Scheme(12, 1)))     '
      gKwd.SetKwdPtr("Scheme13BG1",    VARPTR(Scheme(13, 2)))     '
      gKwd.SetKwdPtr("Scheme13BG2",    VARPTR(Scheme(13, 3)))     '
      gKwd.SetKwdPtr("Scheme13FG",     VARPTR(Scheme(13, 1)))     '
      gKwd.SetKwdPtr("Scheme14BG1",    VARPTR(Scheme(14, 2)))     '
      gKwd.SetKwdPtr("Scheme14BG2",    VARPTR(Scheme(14, 3)))     '
      gKwd.SetKwdPtr("Scheme14FG",     VARPTR(Scheme(14, 1)))     '
      gKwd.SetKwdPtr("Scheme15BG1",    VARPTR(Scheme(15, 2)))     '
      gKwd.SetKwdPtr("Scheme15BG2",    VARPTR(Scheme(15, 3)))     '
      gKwd.SetKwdPtr("Scheme15FG",     VARPTR(Scheme(15, 1)))     '
      gKwd.SetKwdPtr("Scheme16BG1",    VARPTR(Scheme(16, 2)))     '
      gKwd.SetKwdPtr("Scheme16BG2",    VARPTR(Scheme(16, 3)))     '
      gKwd.SetKwdPtr("Scheme16FG",     VARPTR(Scheme(16, 1)))     '
      gKwd.SetKwdPtr("Scheme17BG1",    VARPTR(Scheme(17, 2)))     '
      gKwd.SetKwdPtr("Scheme17BG2",    VARPTR(Scheme(17, 3)))     '
      gKwd.SetKwdPtr("Scheme17FG",     VARPTR(Scheme(17, 1)))     '
      gKwd.SetKwdPtr("Scheme18BG1",    VARPTR(Scheme(18, 2)))     '
      gKwd.SetKwdPtr("Scheme18BG2",    VARPTR(Scheme(18, 3)))     '
      gKwd.SetKwdPtr("Scheme18FG",     VARPTR(Scheme(18, 1)))     '
      gKwd.SetKwdPtr("Scheme19BG1",    VARPTR(Scheme(19, 2)))     '
      gKwd.SetKwdPtr("Scheme19BG2",    VARPTR(Scheme(19, 3)))     '
      gKwd.SetKwdPtr("Scheme19FG",     VARPTR(Scheme(19, 1)))     '
      gKwd.SetKwdPtr("Scheme20BG1",    VARPTR(Scheme(20, 2)))     '
      gKwd.SetKwdPtr("Scheme20BG2",    VARPTR(Scheme(20, 3)))     '
      gKwd.SetKwdPtr("Scheme20FG",     VARPTR(Scheme(20, 1)))     '
      gKwd.SetKwdPtr("Scheme21BG1",    VARPTR(Scheme(21, 2)))     '
      gKwd.SetKwdPtr("Scheme21BG2",    VARPTR(Scheme(21, 3)))     '
      gKwd.SetKwdPtr("Scheme21FG",     VARPTR(Scheme(21, 1)))     '
      gKwd.SetKwdPtr("Scheme22BG1",    VARPTR(Scheme(22, 2)))     '
      gKwd.SetKwdPtr("Scheme22BG2",    VARPTR(Scheme(22, 3)))     '
      gKwd.SetKwdPtr("Scheme22FG",     VARPTR(Scheme(22, 1)))     '
      gKwd.SetKwdPtr("Scheme23BG1",    VARPTR(Scheme(23, 2)))     '
      gKwd.SetKwdPtr("Scheme23BG2",    VARPTR(Scheme(23, 3)))     '
      gKwd.SetKwdPtr("Scheme23FG",     VARPTR(Scheme(23, 1)))     '
      gKwd.SetKwdPtr("Scheme24BG1",    VARPTR(Scheme(24, 2)))     '
      gKwd.SetKwdPtr("Scheme24BG2",    VARPTR(Scheme(24, 3)))     '
      gKwd.SetKwdPtr("Scheme24FG",     VARPTR(Scheme(24, 1)))     '
      gKwd.SetKwdPtr("Scheme25BG1",    VARPTR(Scheme(25, 2)))     '
      gKwd.SetKwdPtr("Scheme25BG2",    VARPTR(Scheme(25, 3)))     '
      gKwd.SetKwdPtr("Scheme25FG",     VARPTR(Scheme(25, 1)))     '
      gKwd.SetKwdPtr("Scheme26BG1",    VARPTR(Scheme(26, 2)))     '
      gKwd.SetKwdPtr("Scheme26BG2",    VARPTR(Scheme(26, 3)))     '
      gKwd.SetKwdPtr("Scheme26FG",     VARPTR(Scheme(26, 1)))     '
      gKwd.SetKwdPtr("Scheme27BG1",    VARPTR(Scheme(27, 2)))     '
      gKwd.SetKwdPtr("Scheme27BG2",    VARPTR(Scheme(27, 3)))     '
      gKwd.SetKwdPtr("Scheme27FG",     VARPTR(Scheme(27, 1)))     '
      gKwd.SetKwdPtr("Scheme28BG1",    VARPTR(Scheme(28, 2)))     '
      gKwd.SetKwdPtr("Scheme28BG2",    VARPTR(Scheme(28, 3)))     '
      gKwd.SetKwdPtr("Scheme28FG",     VARPTR(Scheme(28, 1)))     '
      gKwd.SetKwdPtr("Scheme29BG1",    VARPTR(Scheme(29, 2)))     '
      gKwd.SetKwdPtr("Scheme29BG2",    VARPTR(Scheme(29, 3)))     '
      gKwd.SetKwdPtr("Scheme29FG",     VARPTR(Scheme(29, 1)))     '
      gKwd.SetKwdPtr("Scheme30BG1",    VARPTR(Scheme(30, 2)))     '
      gKwd.SetKwdPtr("Scheme30BG2",    VARPTR(Scheme(30, 3)))     '
      gKwd.SetKwdPtr("Scheme30FG",     VARPTR(Scheme(30, 1)))     '
      gKwd.SetKwdPtr("Scheme31BG1",    VARPTR(Scheme(31, 2)))     '
      gKwd.SetKwdPtr("Scheme31BG2",    VARPTR(Scheme(31, 3)))     '
      gKwd.SetKwdPtr("Scheme31FG",     VARPTR(Scheme(31, 1)))     '
      gKwd.SetKwdPtr("Scheme32BG1",    VARPTR(Scheme(32, 2)))     '
      gKwd.SetKwdPtr("Scheme32BG2",    VARPTR(Scheme(32, 3)))     '
      gKwd.SetKwdPtr("Scheme32FG",     VARPTR(Scheme(32, 1)))     '
      gKwd.SetKwdPtr("Scheme33BG1",    VARPTR(Scheme(33, 2)))     '
      gKwd.SetKwdPtr("Scheme33BG2",    VARPTR(Scheme(33, 3)))     '
      gKwd.SetKwdPtr("Scheme33FG",     VARPTR(Scheme(33, 1)))     '
      gKwd.SetKwdPtr("Scheme34BG1",    VARPTR(Scheme(34, 2)))     '
      gKwd.SetKwdPtr("Scheme34BG2",    VARPTR(Scheme(34, 3)))     '
      gKwd.SetKwdPtr("Scheme34FG",     VARPTR(Scheme(34, 1)))     '
      gKwd.SetKwdPtr("Scheme35BG1",    VARPTR(Scheme(35, 2)))     '
      gKwd.SetKwdPtr("Scheme35BG2",    VARPTR(Scheme(35, 3)))     '
      gKwd.SetKwdPtr("Scheme35FG",     VARPTR(Scheme(35, 1)))     '
      gKwd.SetKwdPtr("Scheme36BG1",    VARPTR(Scheme(36, 2)))     '
      gKwd.SetKwdPtr("Scheme36BG2",    VARPTR(Scheme(36, 3)))     '
      gKwd.SetKwdPtr("Scheme36FG",     VARPTR(Scheme(36, 1)))     '
      gKwd.SetKwdPtr("Scheme37BG1",    VARPTR(Scheme(37, 2)))     '
      gKwd.SetKwdPtr("Scheme37BG2",    VARPTR(Scheme(37, 3)))     '
      gKwd.SetKwdPtr("Scheme37FG",     VARPTR(Scheme(37, 1)))     '
      gKwd.SetKwdPtr("Scheme38BG1",    VARPTR(Scheme(38, 2)))     '
      gKwd.SetKwdPtr("Scheme38BG2",    VARPTR(Scheme(38, 3)))     '
      gKwd.SetKwdPtr("Scheme38FG",     VARPTR(Scheme(38, 1)))     '
      gKwd.SetKwdPtr("Scheme39BG1",    VARPTR(Scheme(39, 2)))     '
      gKwd.SetKwdPtr("Scheme39BG2",    VARPTR(Scheme(39, 3)))     '
      gKwd.SetKwdPtr("Scheme39FG",     VARPTR(Scheme(39, 1)))     '
      gKwd.SetKwdPtr("Scheme40BG1",    VARPTR(Scheme(40, 2)))     '
      gKwd.SetKwdPtr("Scheme40BG2",    VARPTR(Scheme(40, 3)))     '
      gKwd.SetKwdPtr("Scheme40FG",     VARPTR(Scheme(40, 1)))     '
      gKwd.SetKwdPtr("Scheme41BG1",    VARPTR(Scheme(41, 2)))     '
      gKwd.SetKwdPtr("Scheme41BG2",    VARPTR(Scheme(41, 3)))     '
      gKwd.SetKwdPtr("Scheme41FG",     VARPTR(Scheme(41, 1)))     '
      gKwd.SetKwdPtr("Scheme42BG1",    VARPTR(Scheme(42, 2)))     '
      gKwd.SetKwdPtr("Scheme42BG2",    VARPTR(Scheme(42, 3)))     '
      gKwd.SetKwdPtr("Scheme42FG",     VARPTR(Scheme(42, 1)))     '
      gKwd.SetKwdPtr("Scheme43BG1",    VARPTR(Scheme(43, 2)))     '
      gKwd.SetKwdPtr("Scheme43BG2",    VARPTR(Scheme(43, 3)))     '
      gKwd.SetKwdPtr("Scheme43FG",     VARPTR(Scheme(43, 1)))     '
      gKwd.SetKwdPtr("Scheme44BG1",    VARPTR(Scheme(44, 2)))     '
      gKwd.SetKwdPtr("Scheme44BG2",    VARPTR(Scheme(44, 3)))     '
      gKwd.SetKwdPtr("Scheme44FG",     VARPTR(Scheme(44, 1)))     '
      gKwd.SetKwdPtr("Scheme45BG1",    VARPTR(Scheme(45, 2)))     '
      gKwd.SetKwdPtr("Scheme45BG2",    VARPTR(Scheme(45, 3)))     '
      gKwd.SetKwdPtr("Scheme45FG",     VARPTR(Scheme(45, 1)))     '
      gKwd.SetKwdPtr("Scheme46BG1",    VARPTR(Scheme(46, 2)))     '
      gKwd.SetKwdPtr("Scheme46BG2",    VARPTR(Scheme(46, 3)))     '
      gKwd.SetKwdPtr("Scheme46FG",     VARPTR(Scheme(46, 1)))     '
      gKwd.SetKwdPtr("ScrHeight",      VARPTR(ScrHeight))         '
      gKwd.SetKwdPtr("ScrlAmtc",       VARPTR(FMScrlAmt))         '
      gKwd.SetKwdPtr("ScrPosition",    VARPTR(ScrPosition))       '
      gKwd.SetKwdPtr("ScrWidth",       VARPTR(ScrWidth))          '
      gKwd.SetKwdPtr("Splash",         VARPTR(Splash))            '
      gKwd.SetKwdPtr("Style",          VARPTR(PrtFontStyle))      '
      gKwd.SetKwdPtr("SubmitCmd",      VARPTR(SubmitCmd))         '
      gKwd.SetKwdPtr("SubmitInclCol",  VARPTR(SubmitInclCol))     '
      gKwd.SetKwdPtr("SubmitInclKey",  VARPTR(SubmitInclKey))     '
      gKwd.SetKwdPtr("TM",             VARPTR(PrtTMargin))        '
      gKwd.SetKwdPtr("UniqFlag",       VARPTR(UniqueFlag))        '
      gKwd.SetKwdPtr("UndoLevels",     VARPTR(UndoLevels))        '
      gKwd.SetKwdPtr("UseRecycle",     VARPTR(UseRecycle))        '
      gKwd.SetKwdPtr("VBeepFlag",      VARPTR(VBeepFlag))         '
      gKwd.SetKwdPtr("VRuler",         VARPTR(VRuler))            '
      gKwd.SetKwdPtr("VScrollBar",     VARPTR(VScrollBar))        '
      gKwd.SetKwdPtr("WarnNonText",    VARPTR(WarnNonText))       '
      gKwd.SetKwdPtr("WebCheck",       VARPTR(Webcheck))          '
      gKwd.SetKwdPtr("WebLastDate",    VARPTR(WebLastDate))       '
      gKwd.SetKwdPtr("WebLastVers",    VARPTR(WebLastVers))       '
      RETURN                                                      '

   END METHOD                                                     '

   INTERFACE iENVariables: INHERIT IUNKNOWN                       ' Define the interface

      '--------------------------------------------------------------------------------------------+
      '- Following are the variables built by looking around                                       |
      '--------------------------------------------------------------------------------------------+
      GSProp(InitDone, LONG)                                      ' All Initialization done
      GSProp(ClipCmd, STRING)                                     ' CLIP operand
      GProp(CmdLine, STRING)                                      ' Command line
      GSProp(CustomClr, STRING)                                   ' Custom colors
      GProp(EXEFullPath, STRING)                                  ' Full path to the EXE file
      GProp(EXEPath, STRING)                                      ' Path to the EXE folder
      GProp(eInstance, STRING)                                    ' -INSTANCE string
      GSProp(iDo, STRING)                                         ' -DO string
      GSProp(FileOpen, STRING)                                    ' -FileOpen value
      GSProp(FMode, STRING)                                       ' Open mode from cmd line
      GSProp(FMLastSectNo, LONG)                                  ' Last section number in FM defaults
      GProp(FirstTime, LONG)                                      ' This is a First Time run
      GSProp(InitClip, LONG)                                      ' Cmd line asked for -CLIP
      GSProp(InitString, STRING)                                  ' Cmd line filename or Prev open MRF list
      GSProp(InitProfile, STRING)                                 ' Cmd line .profile
      GSProp(InitMacro, STRING)                                   ' Cmd line @macroname
      GSProp(InitXForm, STRING)                                   ' Cmd line /macroname
      GSProp(InitFMFileList, STRING)                              ' Initial FLIST name from command line
      GSProp(InitFMMask, STRING)                                  ' Initial FM Mask from command line
      GSProp(InitFMPath, STRING)                                  ' Initial FM Path from command line
      GSProp(PMode, LONG)                                         ' Parameter mode
      GProp(PgmDate, STRING)                                      ' EXE creation date
      GProp(PgmVers, STRING)                                      ' EXE version
      GProp(QuietMode, LONG)                                      ' -QUIET mode
      GProp(Roaming, LONG)                                        ' Execution roaming mode
      GSProp(SETETab, LONG)                                       ' Tab # that issued SET Edit
      GProp(WineMode, LONG)                                       ' WINE mode
      GProp(NoLoopMode, LONG)                                     ' NOLOOP mode
      GProp(WorkingDir, STRING)                                   ' Our working directory
      GSProp(WelcomeOpt, LONG)                                    ' DispWelcome return option

      '--------------------------------------------------------------------------------------------+
      '- Following are the variables set from the CFG file                                         |
      '--------------------------------------------------------------------------------------------+

      GProp(ABeepFlag, LONG)                                      ' Beep on ErrMsgHigh=%eFail? True = yes
      PROPERTY SET ABeepFlag(BYVAL v AS LONG)                     '
         ABeepFlag = v: gSQL.UpdateString("O", "ABeepFlag", FORMAT$(ABeepFlag))  '
      END PROPERTY                                                '

      GProp(AttnPos, LONG)                                        ' Try and keep screen at the Attention position
      PROPERTY SET AttnPos(BYVAL v AS LONG)                       '
         AttnPos = v: gSQL.UpdateString("O", "AttnPos", FORMAT$(AttnPos))  '
      END PROPERTY                                                '

      GProp(AutoScroll, LONG)                                     ' 0 = Off # = On and # of Lines/Cols to Scroll
      PROPERTY SET AutoScroll(BYVAL v AS LONG)                    '
         AutoScroll = v: gSQL.UpdateString("O", "AutoScrl", FORMAT$(AutoScroll)) '
      END PROPERTY                                                '

      GProp(Banding, LONG)                                        ' Banding ON/OFF
      PROPERTY SET Banding(BYVAL v AS LONG)                       '
         Banding = v: gSQL.UpdateString("O", "Banding", FORMAT$(Banding))  '
      END PROPERTY                                                '

      GProp(BKPRetention, LONG)                                   ' BACKUP Retention
      PROPERTY SET BKPRetention(BYVAL v AS LONG)                  '
         BKPRetention = v: gSQL.UpdateString("O", "BKPRetention", FORMAT$(BKPRetention))  '
      END PROPERTY                                                '

      GProp(BKPMinGen, LONG)                                      ' BACKUP MinGen
      PROPERTY SET BKPMinGen(BYVAL v AS LONG)                     '
         BKPMinGen = v: gSQL.UpdateString("O", "BKPMinGen", FORMAT$(BKPMinGen))  '
      END PROPERTY                                                '

      GProp(BKPMaxGen, LONG)                                      ' BACKUP MaxGen
      PROPERTY SET BKPMaxGen(BYVAL v AS LONG)                     '
         BKPMaxGen = v: gSQL.UpdateString("O", "BKPMaxGen", FORMAT$(BKPMaxGen))  '
      END PROPERTY                                                '

      GSProp(CharSet, STRING)                                     ' Character set
      GSProp(CharSetR, STRING)                                    ' Character set for RegEx

      GProp(cMarkLine, LONG)                                      ' Color of MARK lines
      PROPERTY SET cMarkLine(BYVAL v AS LONG)                     '
         cMarkLine = v: gSQL.UpdateString("O", "cMarkLine", FORMAT$(cMarkLine))  '
      END PROPERTY                                                '

      GProp(CmdChr, STRING)                                       ' Command delimiter
      PROPERTY SET CmdChr(BYVAL v AS STRING)                      '
         CmdChr = v: gSQL.UpdateString("O", "CmdChr", CmdChr)     '
      END PROPERTY                                                '

      GProp(CMDFlags, STRING)                                     ' CMD.EXE flags for CMD command
      PROPERTY SET CMDFlags(BYVAL v AS STRING)                    '
         CMDFlags = v: gSQL.UpdateString("O", "CMDFlags", CmdFlags)  '
      END PROPERTY                                                '

      GProp(CmdHiLite, LONG)                                      ' Cmd line KW hilite
      PROPERTY SET CmdHiLite(BYVAL v AS LONG)                     '
         CmdHiLite = v: gSQL.UpdateString("O", "CmdHiLite", FORMAT$(CmdHiLite))  '
      END PROPERTY                                                '

      GProp(ConfDelFlag, LONG)                                    ' Confirm Deletes in File Manager?
      PROPERTY SET ConfDelFlag(BYVAL v AS LONG)                   '
         ConfDelFlag = v: gSQL.UpdateString("O", "CdelFlag", FORMAT$(ConfDelFlag))  '
      END PROPERTY                                                '

      GProp(CursInsert, LONG)                                     ' Percent height of an Insert cursor
      PROPERTY SET CursInsert(BYVAL v AS LONG)                    '
         CursInsert = v: gSQL.UpdateString("O", "CursIns", FORMAT$(CursInsert))  '
      END PROPERTY                                                '

      GProp(CursNormal, LONG)                                     ' Percent height of a Normal cursor
      PROPERTY SET CursNormal(BYVAL v AS LONG)                    '
         CursNormal = v: gSQL.UpdateString("O", "CursNorm", FORMAT$(CursNormal)) '
      END PROPERTY                                                '

      GProp(CutNew, LONG)                                         ' CUT defaults to NEW
      PROPERTY SET CutNew(BYVAL v AS LONG)                        '
         CutNew = v: gSQL.UpdateString("O", "CutNew", FORMAT$(CutNew))  '
      END PROPERTY                                                '

      GProp(DBConsoleX, LONG)                                     ' Debug Console X
      PROPERTY SET DbConsoleX(BYVAL v AS LONG)                    '
         DBConsoleX = v: gSQL.UpdateString("O", "DBConsoleX", FORMAT$(DBConsoleX))  '
      END PROPERTY                                                '

      GProp(DBConsoleY, LONG)                                     ' Debug Console Y
      PROPERTY SET DbConsoleY(BYVAL v AS LONG)                    '
         DBConsoleY = v: gSQL.UpdateString("O", "DBConsoleY", FORMAT$(DBConsoleY))  '
      END PROPERTY                                                '

      GProp(DefDataShift, LONG)                                   ' Default shift for >>)) ]] line commands
      PROPERTY SET DefDataShift(BYVAL v AS LONG)                  '
         DefDataShift = v: gSQL.UpdateString("O", "DefDataShift", FORMAT$(DefDataShift))  '
      END PROPERTY                                                '

      GProp(DiffMinMatch, LONG)                                   ' DIFF command MinMatch
      PROPERTY SET DiffMinMatch(BYVAL v AS LONG)                  '
         DiffMinMatch = v: gSQL.UpdateString("O", "DiffMinMatch", FORMAT$(DiffMinMatch))  '
      END PROPERTY                                                '

      GProp(Diff1Column, LONG)                                    ' DIFF 1Column flag
      PROPERTY SET Diff1Column(BYVAL v AS LONG)                   '
         Diff1Column = v: gSQL.UpdateString("O", "Diff1Column", FORMAT$(Diff1Column))  '
      END PROPERTY                                                '

      GProp(DiffUseFileB, LONG)                                   ' DIFF UseFileB flag
      PROPERTY SET DiffUseFileB(BYVAL v AS LONG)                  '
         DiffUseFileB = v: gSQL.UpdateString("O", "DiffUseFileB", FORMAT$(DiffUseFileB))  '
      END PROPERTY                                                '

      GProp(DiffOnly, LONG)                                       ' DIFF Only flag
      PROPERTY SET DiffOnly(BYVAL v AS LONG)                      '
         DiffOnly = v: gSQL.UpdateString("O", "DiffOnly", FORMAT$(DiffOnly))  '
      END PROPERTY                                                '

      GProp(DiffALB, LONG)                                        ' DIFFALB
      PROPERTY SET DiffALB(BYVAL v AS LONG)                       '
         DiffALB = v: gSQL.UpdateString("O", "DiffALB", FORMAT$(DiffALB))  '
      END PROPERTY                                                '

      GProp(DiffARB, LONG)                                        ' DIFFARB
      PROPERTY SET DiffARB(BYVAL v AS LONG)                       '
         DiffARB = v: gSQL.UpdateString("O", "DiffARB", FORMAT$(DiffARB))  '
      END PROPERTY                                                '

      GProp(DiffANX, LONG)                                        ' DIFFANX
      PROPERTY SET DiffANX(BYVAL v AS LONG)                       '
         DiffANX = v: gSQL.UpdateString("O", "DiffANX", FORMAT$(DiffANX))  '
      END PROPERTY                                                '

      GProp(DiffAX, LONG)                                         ' DIFFAX
      PROPERTY SET DiffAX(BYVAL v AS LONG)                        '
         DiffAX = v: gSQL.UpdateString("O", "DiffAX", FORMAT$(DiffAX))  '
      END PROPERTY                                                '

      GProp(DiffNoSpace, LONG)                                    ' DIFFNoSpace
      PROPERTY SET DiffNoSpace(BYVAL v AS LONG)                   '
         DiffNoSpace = v: gSQL.UpdateString("O", "DiffNoSpace", FORMAT$(DiffNoSpace))  '
      END PROPERTY                                                '

      GProp(DiffNoTab, LONG)                                      ' DIFFNoTab
      PROPERTY SET DiffNoTab(BYVAL v AS LONG)                     '
         DiffNoTab = v: gSQL.UpdateString("O", "DiffNoTab", FORMAT$(DiffNoTab))  '
      END PROPERTY                                                '

      GProp(DiffNoComment, LONG)                                  ' DIFFNoComment
      PROPERTY SET DiffNoComment(BYVAL v AS LONG)                 '
         DiffNoComment = v: gSQL.UpdateString("O", "DiffNoComment", FORMAT$(DiffNoComment))  '
      END PROPERTY                                                '

      GProp(DiffNoCASE, LONG)                                     ' DIFFNoCASE
      PROPERTY SET DiffNoCASE(BYVAL v AS LONG)                    '
         DiffNoCASE = v: gSQL.UpdateString("O", "DiffNoCASE", FORMAT$(DiffNoCASE))  '
      END PROPERTY                                                '

      GProp(DiffNoMultB, LONG)                                    ' DIFFNoMultB
      PROPERTY SET DiffNoMultB(BYVAL v AS LONG)                   '
         DiffNoMultB = v: gSQL.UpdateString("O", "DiffNoMultB", FORMAT$(DiffNoMultB))  '
      END PROPERTY                                                '

      GProp(DiffBLB, LONG)                                        ' DIFFBLB
      PROPERTY SET DiffBLB(BYVAL v AS LONG)                       '
         DiffBLB = v: gSQL.UpdateString("O", "DiffBLB", FORMAT$(DiffBLB))  '
      END PROPERTY                                                '

      GProp(DiffBRB, LONG)                                        ' DIFFBRB
      PROPERTY SET DiffBRB(BYVAL v AS LONG)                       '
         DiffBRB = v: gSQL.UpdateString("O", "DiffBRB", FORMAT$(DiffBRB))  '
      END PROPERTY                                                '

      GProp(DiffBNX, LONG)                                        ' DIFFBNX
      PROPERTY SET DiffBNX(BYVAL v AS LONG)                       '
         DiffBNX = v: gSQL.UpdateString("O", "DiffBNX", FORMAT$(DiffBNX))  '
      END PROPERTY                                                '

      GProp(DiffBX, LONG)                                         ' DIFFBX
      PROPERTY SET DiffBX(BYVAL v AS LONG)                        '
         DiffBX = v: gSQL.UpdateString("O", "DiffBX", FORMAT$(DiffBX))  '
      END PROPERTY                                                '

      GProp(FindWord, LONG)                                       ' Find default context is WORD
      PROPERTY SET FindWord(BYVAL v AS LONG)                      '
         FindWord = v: gSQL.UpdateString("O", "FindWord", FORMAT$(FindWord))  '
      END PROPERTY                                                '

      GProp(FMCloseFlag, LONG)                                    ' Close FM with last tab?
      PROPERTY SET FMCloseFlag(BYVAL v AS LONG)                   '
         FMCloseFlag = v: gSQL.UpdateString("O", "FMOpFlag", FORMAT$(FMCloseFlag))  '
      END PROPERTY                                                '

      GProp(FMDateHiLite, LONG)                                   ' HiLite Recent/Active dates in FM list
      PROPERTY SET FMDateHiLite(BYVAL v AS LONG)                  '
         FMDateHiLite = v: gSQL.UpdateString("O", "FMDateHiLite", FORMAT$(FMDateHiLite))  '
      END PROPERTY                                                '

      GProp(FMDefMaster, STRING)                                  ' Master Default FM sort
      PROPERTY SET FMDefMaster(BYVAL v AS STRING)                 '
         FMDefMaster = v: gSQL.UpdateString("O", "FMDefMaster", FMDefMaster)  '
      END PROPERTY                                                '

      GProp(FMDefSort, STRING)                                    ' Default FM sort

      GProp(FMDirSort, STRING)                                    ' Default FM Dir sort

      GProp(FileListNm, STRING)                                   ' FIleListNm
      PROPERTY SET FileListNm(BYVAL v AS STRING)                  '
         FileListNm = v: gSQL.UpdateString("O", "FileListNm", FileListNm)  '
      END PROPERTY                                                '

      GProp(FMHelpFlag, LONG)                                     ' Display FM Help at bottom of screen?
      PROPERTY SET FMHelpFlag(BYVAL v AS LONG)                    '
         FMHelpFlag = v: gSQL.UpdateString("O", "FMHelpFlag", FORMAT$(FMHelpFlag))  '
      END PROPERTY                                                '

      GProp(FMLayout, STRING)                                     ' FM Line layout STANDARD
      PROPERTY SET FMLayout(BYVAL v AS STRING)                    '
         FMLayout = v: gSQL.UpdateString("O", "FMLayout", FMLayout)  '
      END PROPERTY                                                '

      GProp(FMLayoutM, STRING)                                    ' FM Line layout ALTERNATE
      PROPERTY SET FMLayoutM(BYVAL v AS STRING)                   '
         FMLayoutM = v: gSQL.UpdateString("O", "FMLayoutM", FMLayoutM)  '
      END PROPERTY                                                '

      GProp(FMLCmdWidth, LONG)                                    ' Width of FM Line Command  area
      PROPERTY SET FMLCmdWidth(BYVAL v AS LONG)                   '
         FMLCmdWidth = v: gSQL.UpdateString("O", "FMLCmdWidth", FORMAT$(FMLCmdWidth))  '
      END PROPERTY                                                '

      GProp(FMMask, STRING)                                       ' FM Mask
      PROPERTY SET FMMask(BYVAL v AS STRING)                      '
         FMMask = v: gSQL.UpdateString("O", "DefMask", FMMask)    '
      END PROPERTY                                                '

      GProp(FMPath, STRING)                                       ' FM Path
      PROPERTY SET FMPath(BYVAL v AS STRING)                      '
         FMPath = v: gSQL.UpdateString("O", "DefDir1", FMPath)    '
      END PROPERTY                                                '

      GProp(FMScrlAmt, STRING)                                    ' FM Scroll ammount
      PROPERTY SET FMScrlAmt(BYVAL v AS STRING)                   '
         FMScrlAmt = v: gSQL.UpdateString("O", "ScrlAmtc", TRIM$(FMScrlAmt))  '
      END PROPERTY                                                '

      GProp(FMSortSimple, LONG)                                   ' FM use old simple sort
      PROPERTY SET FMSortSimple(BYVAL v AS LONG)                  '
         FMSortSimple = v: gSQL.UpdateString("O", "FMSortSimple", FORMAT$(FMSortSimple))  '
      END PROPERTY                                                '

      GProp(FontName, STRING)                                     ' Font name for screen
      PROPERTY SET FontName(BYVAL v AS STRING)                    '
         FontName = v: gSQL.UpdateString("O", "FontName", FontName)  '
      END PROPERTY                                                '

      GProp(FontPitch, LONG)                                      ' Font pitch for screen
      PROPERTY SET FontPitch(BYVAL v AS LONG)                     '
         FontPitch = v: gSQL.UpdateString("O", "FontPitch", FORMAT$(FontPitch))  '
      END PROPERTY                                                '

      GProp(FontStyle, LONG)                                      ' Font style for screen
      PROPERTY SET FontStyle(BYVAL v AS LONG)                     '
         FontStyle = v: gSQL.UpdateString("O", "FontStyle", FORMAT$(FontStyle))  '
      END PROPERTY                                                '

      GProp(GlueWith, STRING)                                     ' GLUE join character string
      PROPERTY SET GlueWith(BYVAL v AS STRING)                    '
         GlueWith = v: gSQL.UpdateString("O", "GlueWith", GlueWith)  '
      END PROPERTY                                                '

      GProp(HomeData, STRING)                                     ' Home Data folder
      PROPERTY SET HomeData(BYVAL v AS STRING)                    '
         HomeData = v: gSQL.UpdateString("O", "HomeData", HomeData)  '
      END PROPERTY                                                '

      GProp(HomeFolder, STRING)                                   ' Home CFG folder
      PROPERTY SET HomeFolder(BYVAL v AS STRING)                  '
         HomeFolder = v: gSQL.UpdateString("O", "HomeFolder", HomeFolder)  '
      END PROPERTY                                                '

      GProp(HRuler, LONG)                                         ' Horizontal ruler cursor
      PROPERTY SET HRuler(BYVAL v AS LONG)                        '
         HRuler = v: gSQL.UpdateString("O", "HRuler", FORMAT$(HRuler))  '
      END PROPERTY                                                '

      GProp(HelpIntro, LONG)                                      ' Help Intro Done
      PROPERTY SET HelpIntro(BYVAL v AS LONG)                     '
         HelpIntro = v: gSQL.UpdateString("O", "HelpIntro", FORMAT$(HelpIntro))  '
      END PROPERTY                                                '

      GProp(HelpOpen, LONG)                                       ' Help Intro Done
      PROPERTY SET HelpOpen(BYVAL v AS LONG)                      '
         HelpOpen = v: gSQL.UpdateString("O", "HelpOpen", FORMAT$(HelpOpen))  '
      END PROPERTY                                                '

      GProp(InsMode, LONG)                                        ' Default Insert mode
      PROPERTY SET InsMode(BYVAL v AS LONG)                       '
         InsMode = v: gSQL.UpdateString("O", "InsMode", FORMAT$(InsMode))  '
      END PROPERTY                                                '

      GProp(InsReset, LONG)                                       ' Insert mode Reset at each Attn key?
      PROPERTY SET InsReset(BYVAL v AS LONG)                      '
         InsReset = v: gSQL.UpdateString("O", "InsReset", FORMAT$(InsReset))  '
      END PROPERTY                                                '

      GProp(InvChar, STRING)                                      ' Display invalid character
      PROPERTY SET InvChar(BYVAL v AS STRING)                     '
         InvChar = v: gSQL.UpdateString("O", "InvChar", InvChar)  '
      END PROPERTY                                                '

      GProp(JobNumber, LONG)                                      ' Submit job number
      PROPERTY SET JobNumber(BYVAL v AS LONG)                     '
         JobNumber = v: gSQL.UpdateString("O", "JobNumber", FORMAT$(Jobnumber))  '
      END PROPERTY                                                '

      GProp(KBHorScroll, LONG)                                    ' Scroll (Hor) screen when cursor hits edge?
      PROPERTY SET KBHorScroll(BYVAL v AS LONG)                   '
         KBHorScroll = v: gSQL.UpdateString("O", "KBScrollH", FORMAT$(KBHorScroll)) '
      END PROPERTY                                                '

      GProp(KBVerScroll, LONG)                                    ' Scroll (Ver) screen when cursor hits edge?
      PROPERTY SET KBVerScroll(BYVAL v AS LONG)                   '
         KBVerScroll = v: gSQL.UpdateString("O", "KBScrollV", FORMAT$(KBVerScroll)) '
      END PROPERTY                                                '

      GProp(LANG, STRING)                                         ' SpellChk LANG
      PROPERTY SET LANG(BYVAL v AS STRING)                        '
         LANG = v: gSQL.UpdateString("O", "LANG", LANG)           '
      END PROPERTY                                                '

      GProp(LastScreenX, LONG)                                    ' Last screen location X
      PROPERTY SET LastScreenX(BYVAL v AS LONG)                   '
         LastScreenX = v: gSQL.UpdateString("O", "LastScrX", FORMAT$(LastScreenX))  '
      END PROPERTY                                                '

      GProp(LastScreenY, LONG)                                    ' Last screen location Y
      PROPERTY SET LastScreenY(BYVAL v AS LONG)                   '
         LastScreenY = v: gSQL.UpdateString("O", "LastScrY", FORMAT$(LastScreenY))  '
      END PROPERTY                                                '

      GProp(LinNoSize, LONG)                                      ' Width of Line Number field
      PROPERTY SET LinNoSize(BYVAL v AS LONG)                     '
         LinNoSize = v: gSQL.UpdateString("O", "LNoSize", FORMAT$(LinNoSize)) '
      END PROPERTY                                                '

      GProp(LinRepeatMax, LONG)                                   ' Max Line repeat
      PROPERTY SET LinRepeatMax(BYVAL v AS LONG)                  '
         LinRepeatMax = v: gSQL.UpdateString("O", "LineRepeatMax", FORMAT$(LinRepeatMax)) '
      END PROPERTY                                                '

      GProp(MacName, LONG)                                        ' Display MacName on Message line
      PROPERTY SET MacName(BYVAL v AS LONG)                       '
         MacName = v: gSQL.UpdateString("O", "MacName", FORMAT$(MacName))  '
      END PROPERTY                                                '

      GProp(MAXIMIZED, LONG)                                      ' Screen is in Max mode
      PROPERTY SET MAXIMIZED(BYVAL v AS LONG)                     '
         MAXIMIZED = v: gSQL.UpdateString("O", "Maximized", FORMAT$(MAXIMIZED))  '
      END PROPERTY                                                '

      GProp(MinRetrieve, LONG)                                    ' Min length retrievable command
      PROPERTY SET MinRetrieve(BYVAL v AS LONG)                   '
         MinRetrieve = v: gSQL.UpdateString("O", "MinRetrieve", FORMAT$(MinRetrieve))  '
      END PROPERTY                                                '

      GProp(MinToTray, LONG)                                      ' Minimize to the Syatem Tray
      PROPERTY SET MinToTray(BYVAL v AS LONG)                     '
         MinToTray = v: gSQL.UpdateString("O", "MinToTray", FORMAT$(MinToTray))  '
      END PROPERTY                                                '

      GProp(MRFList, STRING)                                      ' MRF list
      PROPERTY SET MRFList(BYVAL v AS STRING)                     '
         MRFList = v: gSQL.UpdateString("O", "MRFList", MRFList)  '
      END PROPERTY                                                '

      GProp(ENGChars, LONG)                                       ' English only A-Z and a-z
      PROPERTY SET ENGChars(BYVAL v AS LONG)                      '
         ENGChars = v: gSQL.UpdateString("O", "ENGChars", FORMAT$(ENGChars))  '
      END PROPERTY                                                '

      GProp(FileLineFmt, STRING)                                  ' =FILE> line format
      PROPERTY SET FileLineFmt(BYVAL v AS STRING)                 '
         FileLineFmt = v: gSQL.UpdateString("O", "FileLineFmt", FileLineFmt)  '
      END PROPERTY                                                '

      GProp(NotifyLevel, LONG)                                    ' Notify option
      PROPERTY SET NotifyLevel(BYVAL v AS LONG)                   '
         NotifyLevel = v: NotifyLevelT = v: gSQL.UpdateString("O", "Notify", FORMAT$(NotifyLevel)) '
      END PROPERTY                                                '

      GSProp(NotifyLevelT, LONG)                                  ' Working Notify option

      GProp(PanelMax, LONG)                                       ' PanelMax
      PROPERTY SET PanelMax(BYVAL v AS LONG)                      '
         PanelMax = v: gSQL.UpdateString("O", "PanelMax", FORMAT$(PanelMax))  '
      END PROPERTY                                                '

       GProp(PFKShow, LONG)                                        ' Show PFKeys at bottom
      PROPERTY SET PFKShow(BYVAL v AS LONG)                       '
         PFKShow = v: gSQL.UpdateString("O", "KBHelp", FORMAT$(PFKShow))   '
      END PROPERTY                                                '

      GProp(PDotRaw, STRING)                                      ' P'.' Raw input
      PROPERTY SET PDotRaw(BYVAL v AS STRING)                     '
         PDotRaw = v: gSQL.UpdateString("O", "PDotRaw", PDotRaw)  '
      END PROPERTY                                                '

      GProp(PDotString, STRING)                                   ' P'.' string of invalid characters
      PROPERTY SET PDotString(BYVAL v AS STRING)                  '
         PDotString = v:                                          '
      END PROPERTY                                                '

      GProp(PrtBandColor, LONG)                                   ' Banding color
      PROPERTY SET PrtBandColor(BYVAL v AS LONG)                  '
         PrtBandColor = v: gSQL.UpdateString("O", "BandingColor", FORMAT$(PrtBandColor))  '
      END PROPERTY                                                '

      GProp(PrtBanding, LONG)                                     ' Banding stripes
      PROPERTY SET PrtBanding(BYVAL v AS LONG)                    '
         PrtBanding = v: gSQL.UpdateString("O", "Banding", FORMAT$(PrtBanding))  '
      END PROPERTY                                                '

      GProp(PrtBandLines, LONG)                                   ' Banding lines
      PROPERTY SET PrtBandLines(BYVAL v AS LONG)                  '
         PrtBandLines = v: gSQL.UpdateString("O", "BandLines", FORMAT$(PrtBandLines))  '
      END PROPERTY                                                '

      GProp(PrtBMargin, SINGLE)                                   ' Printer bottom margin (in)
      PROPERTY SET PrtBMargin(BYVAL v AS SINGLE)                  '
         PrtBMargin = v: gSQL.UpdateString("O", "BM", FORMAT$(PrtBMargin)) '
      END PROPERTY                                                '

      GProp(PrtDuplex, LONG)                                      ' Printer duplex setting
      PROPERTY SET PrtDuplex(BYVAL v AS LONG)                     '
         PrtDuplex = v: gSQL.UpdateString("O", "Duplex", FORMAT$(PrtDuplex))  '
      END PROPERTY                                                '

      GProp(PrtFontName, STRING)                                  ' Printer font
      PROPERTY SET PrtFontName(BYVAL v AS STRING)                 '
         PrtFontName = v: gSQL.UpdateString("O", "Font", PrtFontName)   '
      END PROPERTY                                                '

      GProp(PrtFontPitch, STRING)                                 ' Printer pitch
      PROPERTY SET PrtFontPitch(BYVAL v AS STRING)                '
         PrtFontPitch = v: gSQL.UpdateString("O", "Pitch", PrtFontPitch)   '
      END PROPERTY                                                '

      GProp(PrtFontStyle, STRING)                                 ' Printer Style
      PROPERTY SET PrtFontStyle(BYVAL v AS STRING)                '
         PrtFontStyle = v: gSQL.UpdateString("O", "Style", PrtFontStyle)   '
      END PROPERTY                                                '

      GProp(PrtFooter, LONG)                                      ' Printer footers 1 = yes
      PROPERTY SET PrtFooter(BYVAL v AS LONG)                     '
         PrtFooter = v: gSQL.UpdateString("O", "Footers", FORMAT$(PrtFooter)) '
      END PROPERTY                                                '

      GProp(PrtFooterCenter, STRING)                              ' Printer center footers
      PROPERTY SET PrtFooterCenter(BYVAL v AS STRING)             '
         PrtFooterCenter = v: gSQL.UpdateString("O", "FCenter", PrtFooterCenter) '
      END PROPERTY                                                '

      GProp(PrtFooterLeft, STRING)                                ' Printer left footers
      PROPERTY SET PrtFooterLeft(BYVAL v AS STRING)               '
         PrtFooterLeft = v: gSQL.UpdateString("O", "FLeft", PrtFooterLeft) '
      END PROPERTY                                                '

      GProp(PrtFooterRight, STRING)                               ' Printer right footers
      PROPERTY SET PrtFooterRight(BYVAL v AS STRING)              '
         PrtFooterRight = v: gSQL.UpdateString("O", "FRight", PrtFooterRight) '
      END PROPERTY                                                '

      GProp(PrtHeader, LONG)                                      ' Printer headers 1 = yes
      PROPERTY SET PrtHeader(BYVAL v AS LONG)                     '
         PrtHeader = v: gSQL.UpdateString("O", "Headers", FORMAT$(PrtHeader)) '
      END PROPERTY                                                '

      GProp(PrtHeaderCenter, STRING)                              ' Printer center headers
      PROPERTY SET PrtHeaderCenter(BYVAL v AS STRING)             '
         PrtHeaderCenter = v: gSQL.UpdateString("O", "HCenter", PrtHeaderCenter) '
      END PROPERTY                                                '

      GProp(PrtHeaderLeft, STRING)                                ' Printer left headers
      PROPERTY SET PrtHeaderLeft(BYVAL v AS STRING)               '
         PrtHeaderLeft = v: gSQL.UpdateString("O", "HLeft", PrtHeaderLeft) '
      END PROPERTY                                                '

      GProp(PrtHeaderRight, STRING)                               ' Printer left headers
      PROPERTY SET PrtHeaderRight(BYVAL v AS STRING)              '
         PrtHeaderRight = v: gSQL.UpdateString("O", "HRight", PrtHeaderRight) '
      END PROPERTY                                                '

      GProp(PrtLMargin, SINGLE)                                   ' Printer left margin (in)
      PROPERTY SET PrtLMargin(BYVAL v AS SINGLE)                  '
         PrtLMargin = v: gSQL.UpdateString("O", "LM", FORMAT$(PrtLMargin)) '
      END PROPERTY                                                '

      GProp(PrtMetric, LONG)                                      ' Printer margins Eng/Metric
      PROPERTY SET PrtMetric(BYVAL v AS LONG)                     '
         PrtMetric = v: gSQL.UpdateString("O", "Metric", FORMAT$(PrtMetric))  '
      END PROPERTY                                                '

      GProp(PrtName, STRING)                                      ' Printer name
      PROPERTY SET PrtName(BYVAL v AS STRING)                     '
         PrtName = v: gSQL.UpdateString("O", "Name", PrtName)     '
      END PROPERTY                                                '

      GProp(PrtOrient, LONG)                                      ' Printer orientation, 1=Portrait 2=Landscape
      PROPERTY SET PrtOrient(BYVAL v AS LONG)                     '
         PrtOrient = v: gSQL.UpdateString("O", "Orient", FORMAT$(PrtOrient))  '
      END PROPERTY                                                '

      GProp(PrtPaper, LONG)                                       ' Paper index
      PROPERTY SET PrtPaper(BYVAL v AS LONG)                      '
         PrtPaper = v: gSQL.UpdateString("O", "Paper", FORMAT$(PrtPaper))  '
      END PROPERTY                                                '

      GProp(PrtRMargin, SINGLE)                                   ' Printer right margin (in)
      PROPERTY SET PrtRMargin(BYVAL v AS SINGLE)                  '
         PrtRMargin = v: gSQL.UpdateString("O", "RM", FORMAT$(PrtRMargin)) '
      END PROPERTY                                                '

      GProp(PrtTMargin, SINGLE)                                   ' Printer top margin (in)
      PROPERTY SET PrtTMargin(BYVAL v AS SINGLE)                  '
         PrtTMargin = v: gSQL.UpdateString("O", "TM", FORMAT$(PrtTMargin)) '
      END PROPERTY                                                '

      GProp(PrtPColor, LONG)                                      ' Print in color (%True or %False)
      PROPERTY SET PrtPColor(BYVAL v AS LONG)                     '
         PrtPColor = v: gSQL.UpdateString("O", "Color", FORMAT$(PrtPColor))   '
      END PROPERTY                                                '

      GProp(RecentCtr, LONG)                                      ' How many recent files to keep
      PROPERTY SET RecentCtr(BYVAL v AS LONG)                     '
         RecentCtr = v: gSQL.UpdateString("O", "RecentCtr", FORMAT$(RecentCtr))  '
      END PROPERTY                                                '

      GProp(ReOpenLast, LONG)                                     ' Re-Open last file(s)
      PROPERTY SET ReOpenLast(BYVAL v AS LONG)                    '
         ReOpenLast = v: gSQL.UpdateString("O", "ROpenLast", FORMAT$(ReOpenLast))   '
      END PROPERTY                                                '

      GProp(ResetU, LONG)                                         ' RESET clears U by default, like X
      PROPERTY SET ResetU(BYVAL v AS LONG)                        '
         ResetU = v: gSQL.UpdateString("O", "ResetU", FORMAT$(ResetU))  '
      END PROPERTY                                                '

      GProp(RUNFlags, STRING)                                     ' CMD.EXE flags for RUN command
      PROPERTY SET RUNFlags(BYVAL v AS STRING)                    '
         RUNFlags = v: gSQL.UpdateString("O", "RUNFlags", RunFlags)  '
      END PROPERTY                                                '

      GProp(SBLayout, STRING)                                     ' Status Bar layout
      PROPERTY SET SBLayout(BYVAL v AS STRING)                    '
         SBLayout = v: gSQL.UpdateString("O", "SBLayout", SBLayout)  '
      END PROPERTY                                                '

      GProp(SBFactor, SINGLE)                                     ' Status Bar font scale factor
      PROPERTY SET SBFactor(BYVAL v AS SINGLE)                    '
         SBFactor = v: gSQL.UpdateString("O", "SBFactor", FORMAT$(SBFactor, "0.0")) '
      END PROPERTY                                                '

      GProp(ScrHeight, LONG)                                      ' Screen height
      PROPERTY SET ScrHeight(BYVAL v AS LONG)                     '
         ScrHeight = v: gSQL.UpdateString("O", "ScrHeight", FORMAT$(ScrHeight))  '
      END PROPERTY                                                '

      GProp(ScrWidth, LONG)                                       ' Screen width
      PROPERTY SET ScrWidth(BYVAL v AS LONG)                      '
         ScrWidth = v: gSQL.UpdateString("O", "ScrWidth", FORMAT$(ScrWidth))  '
      END PROPERTY                                                '

      GProp(ScrPosition, STRING)                                  ' Screen position values
      PROPERTY SET ScrPosition(BYVAL v AS STRING)                 '
         ScrPosition = v: gSQL.UpdateString("O", "ScrPosition", ScrPosition)  '
      END PROPERTY                                                '

      GProp(Splash, LONG)                                         ' Splash
      PROPERTY SET Splash(BYVAL v AS LONG)                        '
         Splash = v: gSQL.UpdateString("O", "Splash", FORMAT$(Splash))  '
      END PROPERTY                                                '

      GProp(SubmitCmd, STRING)                                    ' Model command for SUBMIT
      PROPERTY SET SubmitCmd(BYVAL v AS STRING)                   '
         SubmitCmd = v: gSQL.UpdateString("O", "SubmitCmd", SubmitCmd)  '
      END PROPERTY                                                '

      GProp(SubmitDir, STRING)                                    ' Working DIR for SUBMIT
      PROPERTY SET SubmitDir(BYVAL v AS STRING)                   '
         SubmitDir = v: gSQL.UpdateString("O", "SubmitDir", SubmitDir)  '
      END PROPERTY                                                '

      GProp(SubmitInclKey, STRING)                                ' Include Key for SUBMIT
      PROPERTY SET SubmitInclKey(BYVAL v AS STRING)               '
         SubmitInclKey = v: gSQL.UpdateString("O", "SubmitInclKey", SubmitInclKey)  '
      END PROPERTY                                                '

      GProp(SubmitInclCol, LONG)                                  ' Include Key Column for SUBMIT
      PROPERTY SET SubmitInclCol(BYVAL v AS LONG)                 '
         SubmitInclCol = v: gSQL.UpdateString("O", "SubmitInclCol", FORMAT$(SubmitInclCol))  '
      END PROPERTY                                                '

      GProp(UndoLevels, LONG)                                     ' Number of UNDO levels
      PROPERTY SET UndoLevels(BYVAL v AS LONG)                    '
         UndoLevels = v: gSQL.UpdateString("O", "UndoLevels", FORMAT$(UndoLevels))  '
      END PROPERTY                                                '

      GProp(UniqueFlag, LONG)                                     ' Keep only 1 instance running
      PROPERTY SET UniqueFlag(BYVAL v AS LONG)                    '
         UniqueFlag = v: gSQL.UpdateString("O", "UniqFlag", FORMAT$(UniqueFlag)) '
      END PROPERTY                                                '

      GProp(UseRecycle, LONG)                                     ' Delete to Recycle bin?
      PROPERTY SET UseRecycle(BYVAL v AS LONG)                    '
         UseRecycle = v: gSQL.UpdateString("O", "UseRecycle", FORMAT$(UseRecycle))  '
      END PROPERTY                                                '

      GProp(VBeepFlag, LONG)                                      ' Visual Beep on ErrMsgHigh=%eFail? True = yes
      PROPERTY SET VBeepFlag(BYVAL v AS LONG)                     '
         VBeepFlag = v: gSQL.UpdateString("O", "VBeepFlag", FORMAT$(VBeepFlag))  '
      END PROPERTY                                                '

      GProp(VertInsCurs, LONG)                                    ' Vertical Insert Cursor
      PROPERTY SET VertInsCurs(BYVAL v AS LONG)                   '
         VertInsCurs = v: gSQL.UpdateString("O", "CursInsVert", FORMAT$(VertInsCurs))  '
      END PROPERTY                                                '

      GProp(ViewWarn, LONG)                                       ' Warn on modified View?
      PROPERTY SET ViewWarn(BYVAL v AS LONG)                      '
         ViewWarn = v: gSQL.UpdateString("O", "BrowseWarn", FORMAT$(ViewWarn))   '
      END PROPERTY                                                '

      GProp(VRuler, LONG)                                         ' Vertical ruler cursor
      PROPERTY SET VRuler(BYVAL v AS LONG)                        '
         VRuler = v: gSQL.UpdateString("O", "VRuler", FORMAT$(VRuler))  '
      END PROPERTY                                                '

      GProp(VScrollBar, LONG)                                     ' Add ScrollBar
      PROPERTY SET VScrollBar(BYVAL v AS LONG)                    '
         VScrollBar = v: gSQL.UpdateString("O", "VScrollBar", FORMAT$(VScrollBar))  '
      END PROPERTY                                                '

      GProp(WarnNonText, LONG)                                    ' Warn on Open of Non-Text files
      PROPERTY SET WarnNonText(BYVAL v AS LONG)                   '
         WarnNonText = v: gSQL.UpdateString("O", "WarnNonText", FORMAT$(WarnNonText))  '
      END PROPERTY                                                '

      GProp(WebCheck, LONG)                                       ' Days between Web check
      PROPERTY SET WebCheck(BYVAL v AS LONG)                      '
         WebCheck = v: gSQL.UpdateString("O", "WebCheck", FORMAT$(WebCheck))  '
      END PROPERTY                                                '

      GProp(WebLastDate, STRING)                                  ' Date(mm-dd-yyyy) of last web check
      PROPERTY SET WebLastDate(BYVAL v AS STRING)                 '
         WebLastDate = v: gSQL.UpdateString("O", "WebLastDate", WebLastDate)  '
      END PROPERTY                                                '

      GProp(WebLastVers, STRING)                                  ' Version (2.7.nnnnn) as of last check
      PROPERTY SET WebLastVers(BYVAL v AS STRING)                 '
         WebLastVers = v: gSQL.UpdateString("O", "WebLastVers", WebLastVers)  '
      END PROPERTY                                                '

      METHOD BuildDefaultProfile()                                '
      '--------------------------------------------------------------------------------------------+
      '- Build an initial DEFAULT Profile                                                          |
      '--------------------------------------------------------------------------------------------+
      LOCAL t AS STRING                                           '
         IF gSQL.TableExist("PDEFAULT") THEN EXIT METHOD          ' See if Profile table exists, if so exit
         gSQL.Execute("PRAGMA synchronous = OFF")                 ' To optimize things
         gSQL.AddStringDirect("PDEFAULT", "Action",      "0")     '
         gSQL.AddStringDirect("PDEFAULT", "AutoBkup",    "0")     '
         gSQL.AddStringDirect("PDEFAULT", "AutoCaps",    "0")     '
         gSQL.AddStringDirect("PDEFAULT", "AutoNum",     "0")     '
         gSQL.AddStringDirect("PDEFAULT", "AutoName",    "$NONE$")   '
         gSQL.AddStringDirect("PDEFAULT", "AutoSave",    "2")     '
         gSQL.AddStringDirect("PDEFAULT", "BndL",        "1")     '
         gSQL.AddStringDirect("PDEFAULT", "BndR",        "0")     '
         gSQL.AddStringDirect("PDEFAULT", "BOM",         "0")     '
         gSQL.AddStringDirect("PDEFAULT", "CapsFlag",    "0")     '
         gSQL.AddStringDirect("PDEFAULT", "Case",        "T")     '
         gSQL.AddStringDirect("PDEFAULT", "Change",      "D")     '
         gSQL.AddStringDirect("PDEFAULT", "CMntCol",     "0")     '
         gSQL.AddStringDirect("PDEFAULT", "CMntEnd",     "0")     '
         gSQL.AddStringDirect("PDEFAULT", "CMntID",      "0")     '
         gSQL.AddStringDirect("PDEFAULT", "CMntIncr",    "0")     '
         gSQL.AddStringDirect("PDEFAULT", "Collate",     "ANSI")  '
         gSQL.AddStringDirect("PDEFAULT", "ColsFlag",    "1")     '
         gSQL.AddStringDirect("PDEFAULT", "EMacro",      "")      '
         gSQL.AddStringDirect("PDEFAULT", "EOLFlag",     "CRLF")  '
         gSQL.AddStringDirect("PDEFAULT", "HexMFlag",    "1")     '
         gSQL.AddStringDirect("PDEFAULT", "HiAuto",      "1")     '
         gSQL.AddStringDirect("PDEFAULT", "HiFind",      "1")     '
         gSQL.AddStringDirect("PDEFAULT", "IMacro",      "")      '
         gSQL.AddStringDirect("PDEFAULT", "ImportTabs",  "4")     '
         gSQL.AddStringDirect("PDEFAULT", "LRECL",       "0")     '
         gSQL.AddStringDirect("PDEFAULT", "MAcLib",       "")     '
         gSQL.AddStringDirect("PDEFAULT", "Mark",        "")      '
         gSQL.AddStringDirect("PDEFAULT", "MarkFlag",    "1")     '
         gSQL.AddStringDirect("PDEFAULT", "Mask",        "")      '
         gSQL.AddStringDirect("PDEFAULT", "MinLen",      "0")     '
         gSQL.AddStringDirect("PDEFAULT", "Mode",        "8")     '
         gSQL.AddStringDirect("PDEFAULT", "Page",        "0")     '
         gSQL.AddStringDirect("PDEFAULT", "PageOffset",  "0")     '
         gSQL.AddStringDirect("PDEFAULT", "Preserve",    "0")     '
         gSQL.AddStringDirect("PDEFAULT", "ProfLock",    "0")     '
         gSQL.AddStringDirect("PDEFAULT", "ProfUsing",   "")      '
         gSQL.AddStringDirect("PDEFAULT", "RECFM",       "U")     '
         gSQL.AddStringDirect("PDEFAULT", "ScrollAmount", "CSR")  '
         gSQL.AddStringDirect("PDEFAULT", "Source",      "ANSI")  '
         gSQL.AddStringDirect("PDEFAULT", "Start",       "FIRST") '
         gSQL.AddStringDirect("PDEFAULT", "StateFlag",   "0")     '
         gSQL.AddStringDirect("PDEFAULT", "SubArg",      "")      '
         gSQL.AddStringDirect("PDEFAULT", "SubCmd",      "")      '
         gSQL.AddStringDirect("PDEFAULT", "Tabs",        "")      '
         gSQL.AddStringDirect("PDEFAULT", "TabBnds",     "0")     '
         gSQL.AddStringDirect("PDEFAULT", "TabsFlag",    "1")     '
         gSQL.AddStringDirect("PDEFAULT", "Word",        "A-Z a-z 0-9") '
         gSQL.AddStringDirect("PDEFAULT", "XForm",       "")      '
         gSQL.Execute("PRAGMA synchronous = ON")                  ' Reset synchronous
         gSQL.TableCopy("PDEFAULT", "PSETEDIT")                   ' Create the other defaults
         gSQL.TableCopy("PDEFAULT", "PEFTEDIT")                   '
         gSQL.TableCopy("PDEFAULT", "PCLIP")                      '

      END METHOD                                                  '

      METHOD GetClr(RScheme AS LONG, which AS LONG) AS LONG       '
      '--------------------------------------------------------------------------------------------+
      '- Return color value for a particular scheme entry                                          |
      '--------------------------------------------------------------------------------------------+
         IF RScheme <> -1 THEN METHOD = Scheme(RScheme, which): EXIT METHOD   ' Not %SCCust, Pass it back
         METHOD = CHOOSE(which, gCustFG, gCustBG1, gCustBG2)      ' Pass back a custom value
      END METHOD                                                  '

      METHOD SetClr(RScheme AS LONG, which AS LONG, CValue AS LONG) AS LONG   '
      '--------------------------------------------------------------------------------------------+
      '- Save color value for a particular scheme entry                                            |
      '--------------------------------------------------------------------------------------------+
         Scheme(RScheme, which) = CValue                          ' Save it
      END METHOD                                                  '

      METHOD SetGlobalClrs()                                      '
      '--------------------------------------------------------------------------------------------+
      '- Copy Scheme colors to Globals (easier access)                                             |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         i = VARPTR(gLnoHiFG)                                     '
         DIM GValues(1 TO 48) AS LONG AT i                        '
         j = 1                                                    '
         FOR i = 16 TO 31                                         ' Copy the Scheme 16 to 31 entries
            gValues(j)   = Scheme(i, 1)                           ' FG
            gValues(j+1) = Scheme(i, 2)                           ' BG1
            gValues(j+2) = Scheme(i, 3)                           ' BG2
            j += 3                                                '
         NEXT i                                                   '
         gTxtLoFG = scheme(0, 1): gTxtLoBG1 = scheme(0, 2): gTxtLoBG2 = scheme(0, 3)   '
         gTxtHiFG = scheme(1, 1): gTxtHiBG1 = scheme(1, 2): gTxtHiBG2 = scheme(1, 3)   '

      END METHOD                                                  '

      METHOD SaveScheme()                                         '
      REGISTER i AS LONG                                          '
         MAT SchemeSave() = Scheme()                              ' Save Scheme array 'as is' in case cancelled
         FOR i = 0 TO 15                                          ' Save Aliases the same way
            SchAliasSave(i) = SchAlias(i)                         '
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD LoadScheme()                                         '
      REGISTER i AS LONG                                          '
         MAT Scheme() = SchemeSave()                              ' Reload saved Scheme array
         FOR i = 0 TO 15                                          ' Ditto for Aliases the same way
            SchAlias(i) = SchAliasSave(i)                         '
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD GetFMCrit(which AS STRING, DirPart AS STRING, DefPart AS STRING, DefMask AS STRING, DefLayout AS STRING)
      '--------------------------------------------------------------------------------------------+
      '- Return one of the Master FM sort controls                                                 |
      '--------------------------------------------------------------------------------------------+
      LOCAL section(), portion(), value AS STRING, i, j, k AS LONG   '
         DIM section(1 TO PARSECOUNT(FMDefMaster, " "))           ' Dim array to hold sections
         PARSE FMDefMaster, section(), " "                        ' Split out the sections
         '-----------------------------------------------------------------------------------------+
         '- If it exists, update it                                                                |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO UBOUND(section())                           ' Find the requested one
            j = INSTR(section(i), "(")                            ' Find operands
            k = INSTR(section(i), ")")                            '
            IF LEFT$(section(i), j - 1) = which THEN              ' Is this the one
               FMLastSectNo = i                                   ' Save last section index
               value = MID$(section(i), j + 1 TO k - 1)           ' Extract the (...) value
               DIM portion(1 TO PARSECOUNT(value, ","))           ' Dim the portion array
               PARSE value, portion(), ","                        ' Break it out
               DirPart = portion(1): DefPart = portion(2): DefMask = portion(3) ' Pass back answers
               DefLayout = IIF$(UBOUND(portion()) < 4, "S", portion(4))   '
               IF DirPart = "" THEN DirPart = "Dir+"              ' Just in case
               IF DefPart = "" THEN DefPart = "Name+"             '
               IF DefMask = "" THEN DefMask = "*"                 '
               IF DefLayout = "" THEN DefLayout = "S"             '
               EXIT METHOD                                        '
            END IF                                                '
         NEXT i                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If it doesn't exist, create it and return defaults                                     |
         '-----------------------------------------------------------------------------------------+
         FMLastSectNo = UBOUND(section()) + 1                     ' Bump to a new section #
         REDIM PRESERVE section(1 TO FMLastSectNo)                ' Expand section table
         section(FMLastSectNo) = which + "(Dir+,Name+,*)"         ' Build a new entry
         FMDefMaster = JOIN$(section(), " ")                      ' Rebuild FMDefMaster
         gSQL.UpdateString("O", "FMDefMaster", FMDefMaster)       ' Save it
         me.SetINITimeStamp                                       '
         DirPart = "Dir+": DefPart = "Name+": DefMask = "*"       ' Pass back new defaults
      END METHOD                                                  '

      METHOD GetSchNumber(sName AS STRING) AS LONG                '
      '--------------------------------------------------------------------------------------------+
      '- Get User scheme number for an Alias Name                                                  |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         ARRAY SCAN SchAlias(), COLLATE UCASE, =sName, TO i       ' Scan for it
         METHOD = IIF(i = 0, -1, i - 2)                           ' Adjust index and return
      END METHOD                                                  '

      METHOD GetSchAlias(i AS LONG) AS STRING                     '
      '--------------------------------------------------------------------------------------------+
      '- Return an Alias for a Scheme number                                                       |
      '--------------------------------------------------------------------------------------------+
         METHOD = SchAlias(i)                                     ' Return the name
      END METHOD                                                  '

      METHOD SetSchAlias(i AS LONG, vl AS STRING)                 '
      '--------------------------------------------------------------------------------------------+
      '- Save an Alias for a Scheme number                                                         |
      '--------------------------------------------------------------------------------------------+
         SchAlias(i + 1) = vl                                     ' Save the name
      END METHOD                                                  '

      METHOD SchemeSaveAll()                                      '
      '--------------------------------------------------------------------------------------------+
      '- Save all the Scheme values                                                                |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '

         FOR i = 0 TO 47                                          '
            gSQL.UpdateString("O", "Scheme" + FORMAT$(i, "00") + "FG", FORMAT$(Scheme(i, 1)))   '
            gSQL.UpdateString("O", "Scheme" + FORMAT$(i, "00") + "BG1", FORMAT$(Scheme(i, 2)))  '
            gSQL.UpdateString("O", "Scheme" + FORMAT$(i, "00") + "BG2", FORMAT$(Scheme(i, 3)))  '
         NEXT i                                                   '
         gSQL.UpdateString("O", "SchAliasAll", JOIN$(SchAlias(), ","))  '
      END METHOD                                                  '

      METHOD SetFMCrit(nv1 AS STRING, nv2 AS STRING, nv3 AS STRING, nv4 AS STRING)
      '--------------------------------------------------------------------------------------------+
      '- Change the last used (current) master section of FM sorts                                 |
      '--------------------------------------------------------------------------------------------+
      LOCAL section(), portion(), SectData, value AS STRING, i, j, k, Sects AS LONG
      MEntry                                                      '
         IF FMLastSectNo = 0 THEN MexitMeth                       ' Escape if called with zero
         Sects = PARSECOUNT(FMDefMaster, " ")                     ' How many Sections? Dim array to hold sections
         DIM section(1 TO Sects)                                  ' Dim array to hold sections
         PARSE FMDefMaster, section(), " "                        ' Split out the sections
         IF FMLastSectNo > Sects THEN FMLastSectNo = Sects        ' Just in case corrupted
         SectData = Section(FMLastSectNo)                         ' Grab the data
         SectData = LEFT$(SectData, INSTR(SectData, "(") - 1)     ' Keep the section name
         value = BUILD$("(", nv1, ",", nv2, ",", nv3, ",", nv4, ")") ' Build the new value
         section(FMLastSectNo) = SectData + value                 ' Save it back
         FMDefMaster = JOIN$(section(), " ")                      ' Rebuild FMDefMaster
         IF PARSECOUNT(FMDefMaster, " ") <> Sects THEN            ' Better not have changed
            MSGBOX "SetFMCrit Oops"                               ' Oops
         END IF                                                   '
         gSQL.UpdateString("O", "FMDefMaster", FMDefMaster)       ' Save it
         me.SetINITimeStamp                                       '
         MExit                                                    '
      END METHOD                                                  '

      METHOD SetINITimeStamp()                                    '
      '--------------------------------------------------------------------------------------------+
      '- Set a last update in the CFG file                                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL Stamp AS STRING                                       '
         Stamp = TimePretty(0)                                    ' Get a formatted time
         gSQL.UpdateString("O", "LastAccess", Stamp)              ' Write it
      END METHOD                                                  '

      METHOD DispWelcome()                                        '
      '--------------------------------------------------------------------------------------------+
      '- Display the Welcome dialog                                                                |
      '--------------------------------------------------------------------------------------------+
         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Build the dialog                                                                       |
         '-----------------------------------------------------------------------------------------+
         DIALOG FONT DEFAULT "Tahoma", 11 / gFontScale, 0, 0      '
         DIALOG NEW 0, "SPFLite Welcome",,, 250, 250, %WS_THICKFRAME OR %WS_CAPTION TO ghWel '
         DIALOG SET COLOR ghWel, %RGB_GAINSBORO, %RGB_GAINSBORO   '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+0, "Welcome to SPFLite Version " & gENV.PgmVers, 2, 5, 200, 14  '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+0, %BLACK, %RGB_GAINSBORO   '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+1, "This appears to be your first execution of SPFLite4, please complete", 2, 20, 247, 12  '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+1, %BLUE, %RGB_GAINSBORO '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+2, "the options below. Once you select A/B or C, you will then be taken", 2, 30, 247, 12   '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+2, %BLUE, %RGB_GAINSBORO '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+3, "to the standard OPTIONS panel which allows further customization.", 2, 40, 247, 12  '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+3, %BLUE, %RGB_GAINSBORO '

         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+9, "Please enter the folder for the SPFLite2 Common Configuration file.", 2, 60, 300, 12   '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+9, %BLUE, %RGB_GAINSBORO '
         CONTROL ADD TEXTBOX,ghWel, %WELCOME_HOMEFOLDER, gENV.HomeFolder, 2, 72, 190, 11, %ES_AUTOHSCROLL   '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+10,"Please enter the folder for the SPFLite2 Data Sub-Folders.", 2, 84, 300, 12   '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+10, %BLUE, %RGB_GAINSBORO   '
         CONTROL ADD TEXTBOX,ghWel, %WELCOME_HOMEDATA, gENV.HomeData, 2, 96, 190, 11, %ES_AUTOHSCROLL '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+12, "(The above locations can be altered later via the OPTIONS command)", 2, 108, 300, 12  '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+12, %BLACK, %RGB_GAINSBORO  '

         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+4, "Choose one of the following settings for ENTER and NEWLINE", 2, 120, 300, 12  '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+4, %BLUE, %RGB_GAINSBORO '
         CONTROL ADD BUTTON, ghWel, %WELCOME_OPTION1, "(&A)", 2, 135, 20, 13, %WS_BORDER  '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+6, "Enter key is ENTER, Backpace key is NEWLINE", 30, 137, 200, 12 '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+6, %BLUE, %RGB_GAINSBORO '
         CONTROL ADD BUTTON, ghWel, %WELCOME_OPTION2, "(&B)", 2, 155, 20, 13, %WS_BORDER  '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+7, "Enter key is ENTER, Ctrl-Enter key is NEWLINE", 30, 157, 200, 12  '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+7, %BLUE, %RGB_GAINSBORO '
         CONTROL ADD BUTTON, ghWel, %WELCOME_OPTION3, "(&C)", 2, 175, 20, 13, %WS_BORDER  '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+8, "Right Ctrl key is ENTER, Enter key is NEWLINE", 30, 177, 200, 12  '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+8, %BLUE, %RGB_GAINSBORO '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+5, "(You may alter these later via the KEYMAP command)", 2, 195, 300, 12 '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+5, %BLACK, %RGB_GAINSBORO   '

         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+20, "Note: This window will close, and Initialization may take a minute.", 2, 215, 247, 12 '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+20, %BLUE, %RGB_GAINSBORO   '
         CONTROL ADD LABEL,  ghWel, %WELCOME_TEXT+21, "            Please be patient, this is one-time delay only.", 2, 225, 247, 12   '
         CONTROL SET COLOR   ghWel, %WELCOME_TEXT+21, %BLUE, %RGB_GAINSBORO   '

         DIALOG SHOW MODAL ghWel CALL DlgWelcomeCallback          ' Display it all
         MExit                                                    '
      END METHOD                                                  '

      METHOD DlgWelcomeCallBack(BYVAL hDlg AS DWORD,  _           ' CB.HNDL
                               BYVAL wMsg AS LONG,   _            ' CB.MSG
                               BYVAL WPARAM AS LONG, _            ' CB.WPARAM    CB.CTLMSG = HI(WORD, wParam) CB.CTL = LO(WORD, wParam)
                               BYVAL LPARAM AS LONG) AS LONG      ' CB.LPARAM
      '--------------------------------------------------------------------------------------------+
      '- Callback function used by the Welcome Dialog                                              |
      '--------------------------------------------------------------------------------------------+
      LOCAL Txt1 AS STRING                                        '

         SELECT CASE AS LONG wMsg                                 '

            '--------------------------------------------------------------------------------------+
            '- SYSCOMMAND                                                                          |
            '--------------------------------------------------------------------------------------+
            CASE %WM_SYSCOMMAND                                   '
               IF (WPARAM AND &HFFF0) = %SC_CLOSE THEN            ' Trap the [x] button and Alt-F4
                  METHOD = 1                                      ' Ignore it
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Handle the various interactions                                                     |
            '--------------------------------------------------------------------------------------+
            CASE %WM_COMMAND                                      '
               SELECT CASE AS LONG LO(WORD, WPARAM)               '
                  CASE %WELCOME_OPTION1                           '
                     IF HI(WORD, WPARAM) = %BN_CLICKED THEN       '
                        gENV.WelcomeOpt = 1                       '
                        RESET ghToolTips                          ' Clear so Tooltips get re-created correctly
                        GOSUB HandlePath                          ' Handle HomeFolder
                        DIALOG END hDlg                           ' Shut things down
                     END IF                                       '

                  CASE %WELCOME_OPTION2                           '
                     IF HI(WORD, WPARAM) = %BN_CLICKED THEN       '
                        gENV.WelcomeOpt = 2                       '
                        RESET ghToolTips                          ' Clear so Tooltips get re-created correctly
                        GOSUB HandlePath                          ' Handle HomeFolder
                        DIALOG END hDlg                           ' Shut things down
                     END IF                                       '

                  CASE %WELCOME_OPTION3                           '
                     IF HI(WORD, WPARAM) = %BN_CLICKED THEN       '
                        gENV.WelcomeOpt = 3                       '
                        RESET ghToolTips                          ' Clear so Tooltips get re-created correctly
                        GOSUB HandlePath                          ' Handle HomeFolder
                        DIALOG END hDlg                           ' Shut things down
                     END IF                                       '
               END SELECT                                         '
         END SELECT                                               '
         EXIT METHOD                                              '

      HandlePath:                                                 '
         CONTROL GET TEXT ghWel, %WELCOME_HOMEFOLDER TO Txt1      ' Get user's HomeFolder selection
         IF RIGHT$(Txt1, 1) <> "\" THEN Txt1 += "\"               '
         HomeFolder = Txt1                                        ' Save it
         CONTROL GET TEXT ghWel, %WELCOME_HOMEDATA TO Txt1        ' Get user's HomeData selection
         IF RIGHT$(Txt1, 1) <> "\" THEN Txt1 += "\"               '
         HomeData = Txt1                                          ' Save it
         RETURN                                                   '
      END METHOD                                                  '

   END INTERFACE                                                  '

END CLASS                                                         '

   CALLBACK FUNCTION DlgWelcomeCallBack()                         '
      FUNCTION = gENV.DlgWelcomeCallBack(CB.HNDL, CB.MSG, CB.WPARAM, CB.LPARAM)  '
   END FUNCTION                                                   '
