'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjFCB.inc                                                                                      |
'--------------------------------------------------------------------------------------------------+
                                                                  '

CLASS cFCB                                                        '

   '-----------------------------------------------------------------------------------------------+
   '- File Control Block Data areas                                                                |
   '-----------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- File Related stuff                                                                           |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE FNum           AS LONG                                ' File number
   INSTANCE FilePath       AS STRING                              ' Full file name and path
   INSTANCE FD             AS DIRDATA                             ' Full DIRDATA area
   INSTANCE TabFound       AS LONG                                ' Tab found in other tab #
   '-----------------------------------------------------------------------------------------------+
   '- File Access Related stuff                                                                    |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE FileRO         AS BYTE                                ' Read Only State
   INSTANCE FileSkip       AS BYTE                                ' EFT Non-TXT file
   '-----------------------------------------------------------------------------------------------+
   '- File Profile Settings                                                                        |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE ActionSave  AS LONG                                   ' Count between automatic SAVEs
   INSTANCE AutoBkup    AS LONG                                   ' Perform BACKUP automatically (Yes / No)
   INSTANCE AUTOCAPS    AS LONG                                   ' AutoCaps On/Off
   INSTANCE AutoName    AS STRING                                 ' AutoName (Of the AUTO fle), or "$NONE$" = NONE
   INSTANCE AutoSave    AS LONG                                   ' Save on END / =X ? (0 = no, 1 = Yes, 2 = Prompt)
   INSTANCE BndLeft     AS LONG                                   ' Left Bound
   INSTANCE BndRight    AS LONG                                   ' Right Bound (0 = >> no limit)
   INSTANCE BndText     AS STRING                                 ' String representation of BNDS
   INSTANCE BOM         AS LONG                                   ' Write BOM for UTF8 files
   INSTANCE CA2S        AS STRING                                 ' COLLATE Translate table ANSI to Source
   INSTANCE CapsActual  AS LONG                                   ' CAPS actual flag
   INSTANCE CapsDesired AS LONG                                   ' CAPS desired flag
   INSTANCE CaseFlag    AS STRING                                 ' Default text case
   INSTANCE ChangeMode  AS STRING                                 ' Default Change shift mode
   INSTANCE ChrUpper    AS STRING                                 ' Uppercase string
   INSTANCE ChrLower    AS STRING                                 ' Lowercase string
   INSTANCE ChrRegLower AS STRING                                 ' Lowercase string (RegEx)
   INSTANCE ChrRegUpper AS STRING                                 ' Uppercase string (RegEx)
   INSTANCE CmntID      AS LONG                                   ' COMMENT ID
   INSTANCE CmntCol     AS LONG                                   ' COMMENT column
   INSTANCE CmntIncr    AS LONG                                   ' COMMENT increment
   INSTANCE CmntEnd     AS LONG                                   ' COMMENT End column
   INSTANCE ColateXlate AS LONG                                   ' COLLATE XLate is active
   INSTANCE Cols        AS LONG                                   ' Ruler Line Desired
   INSTANCE CS2A        AS STRING                                 '    "   "      "   SOURCE to ANSI
   INSTANCE EMacro      AS STRING                                 ' EMacro string
   INSTANCE EOL         AS STRING                                 ' EOL Default action
   INSTANCE EOLIX       AS LONG                                   ' EOL Select Index
   INSTANCE GoodBnds    AS STRING                                 ' Last 'good' BNDS string
   INSTANCE HexMode     AS LONG                                   ' Hex Mode 1 = off, 4 = on
   INSTANCE HiAuto      AS LONG                                   ' HiAuto flag
   INSTANCE HiFind      AS LONG                                   ' HiFind flag
   INSTANCE HiFindSupp  AS LONG                                   ' HiFind temporarily suppressed
   INSTANCE IMacro      AS STRING                                 ' IMacro string
   INSTANCE ImportTabs  AS LONG                                   ' Import Tab conversion
   INSTANCE JustCreated AS LONG                                   ' Profile was just created
   INSTANCE KWTable()   AS PKWTbl                                 ' Keyword Table
   INSTANCE KWCtr       AS LONG                                   ' Ctr
   INSTANCE LRECL       AS LONG                                   ' LRECL
   INSTANCE Maclib      AS STRING                                 ' MACLIB string or NONE
   INSTANCE MarkLine    AS STRING                                 ' Mark columns line
   INSTANCE MarkWorking AS STRING                                 ' Mark columns line (working)
   INSTANCE MaskLine    AS STRING                                 ' Mask model line
   INSTANCE MINLEN      AS LONG                                   ' MINLEN
   INSTANCE MODE        AS LONG                                   ' Mode
   INSTANCE PageFlag    AS LONG                                   ' PAGE ON/OFF
   INSTANCE PageOffset  AS LONG                                   ' PAGE ON offset
   INSTANCE CaseFfag    AS STRING                                 ' Default text case
   INSTANCE CollateStr  AS STRING                                 ' Collate option
   INSTANCE LockFlag    AS LONG                                   ' Profile Lock
   INSTANCE MarkFlag    AS LONG                                   ' MARK lines are active
   INSTANCE PInclude    AS STRING                                 ' INCLUDE parse string
   INSTANCE PreserveTyp AS LONG                                   ' Keep trailing blanks on save? (True = Yes, False = No)
   INSTANCE ProfName    AS STRING                                 ' Profile Name
   INSTANCE ProfNameSQL AS STRING                                 ' Profile Name (SQLname)
   INSTANCE SourceName  AS STRING                                 ' Desired encoding ANSI, UTF8 etc.
   INSTANCE StateFlag   AS LONG                                   ' State status 0=Off, 1=ON, 2=FEW, 3=MANY
   INSTANCE SubInclude  AS STRING                                 ' Path for SUBMIT #INCLUDE
   INSTANCE WordStr     AS STRING                                 ' Valid 'word' characters
   INSTANCE RECFM       AS STRING                                 ' RECFM
   INSTANCE SA2S        AS STRING                                 ' SOURCE Translate table ANSI to Source
   INSTANCE ScrlPageSus AS LONG                                   ' Scroll Amount PAGE suspended
   INSTANCE ScrollAmt   AS STRING                                 ' Scroll Amount (Profile)
   INSTANCE Skip        AS LONG                                   ' ProfReadAll sets if missing Profile and SKIP/CANCEL chosen
   INSTANCE SrceXlate   AS LONG                                   ' SOURCE XLate is active
   INSTANCE SS2A        AS STRING                                 '   "      "      "   SOURCE to ANSI
   INSTANCE Start       AS STRING                                 ' START setting
   INSTANCE SubArg      AS STRING                                 ' SUBARG data
   INSTANCE SubCmd      AS STRING                                 ' SUBCmd data
   INSTANCE Tabs        AS LONG                                   ' Tabs line in use
   INSTANCE TabBNDS     AS LONG                                   ' TabBNDS is Active
   INSTANCE TabsLine    AS STRING                                 ' Active Tabs line
   INSTANCE UndoNumber  AS LONG                                   ' No. of UNDO levels
   INSTANCE WordInput   AS STRING                                 ' Valid 'word' characters (CFG version)
   INSTANCE XFormStr    AS STRING                                 ' XForm Macro name

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
   REGISTER i AS LONG                                             '
      DIM KWTable(1 TO 49) AS INSTANCE PKWTbl                     ' Dim the KW table
      '--------------------------------------------------------------------------------------------+
      '- Initialize the table                                                                      |
      '--------------------------------------------------------------------------------------------+
      me.InitPKW("Action",        1,  VARPTR(ActionSave),     "0")   '
      me.InitPKW("AutoBkup",      1,  VARPTR(AutoBkup),       "0")   '
      me.InitPKW("AutoCaps",      1,  VARPTR(AUTOCAPS),       "0")   '
      me.InitPKW("AutoName",      0,  VARPTR(AutoName),       "$NONE$") '
      me.InitPKW("AutoSave",      1,  VARPTR(AutoSave),       "2")   '
      me.InitPKW("BndL",          1,  VARPTR(BndLeft),        "1")   '
      me.InitPKW("BndR",          1,  VARPTR(BndRight),       "0")   '
      me.InitPKW("BOM",           1,  VARPTR(BOM),            "1")   '
      me.InitPKW("CapsFlag",      1,  VARPTR(CapsActual),     "0")   '
      me.InitPKW("Case",          0,  VARPTR(CaseFlag),       "T")   '
      me.InitPKW("Change",        0,  VARPTR(ChangeMode),     "D")   '
      me.InitPKW("CmntID",        1,  VARPTR(CmntID),         "0")   '
      me.InitPKW("CmntCol",       1,  VARPTR(CmntCol),        "0")   '
      me.InitPKW("CmntIncr",      1,  VARPTR(CmntIncr),       "0")   '
      me.InitPKW("CmntEND",       1,  VARPTR(CmntEnd),        "0")   '
      me.InitPKW("Collate",       0,  VARPTR(CollateStr),     "ANSI")   '
      me.InitPKW("ColsFlag",      1,  VARPTR(Cols),           "1")   '
      me.InitPKW("EMacro",        0,  VARPTR(EMacro),         "") '
      me.InitPKW("EOLFlag",       0,  VARPTR(EOL),            "CRLF")   '
      me.InitPKW("HexMFlag",      1,  VARPTR(HexMode),        "1")   '
      me.InitPKW("HiAuto",        1,  VARPTR(HiAuto),         "1")   '
      me.InitPKW("HiFind",        1,  VARPTR(HiFind),         "1")   '
      me.InitPKW("IMacro",        0,  VARPTR(IMacro),         "") '
      me.InitPKW("ImportTabs",    1,  VARPTR(ImportTabs),     "4")   '
      me.InitPKW("LRECL",         1,  VARPTR(LRECL),          "0")   '
      me.InitPKW("MACLIB",        0,  VARPTR(Maclib),         "") '
      me.InitPKW("MARK",          0,  VARPTR(MarkLine),       "") '
      me.InitPKW("MASK",          0,  VARPTR(MaskLine),       "") '
      me.InitPKW("MINLEN",        1,  VARPTR(MINLEN),         "0")   '
      me.InitPKW("Mode",          1,  VARPTR(MODE),           FORMAT$(%Edit)) '
      me.InitPKW("MarkFlag",      1,  VARPTR(MarkFlag),       "1")   '
      me.InitPKW("Page",          1,  VARPTR(PageFlag),       "0")   '
      me.InitPKW("PageOffset",    1,  VARPTR(PageOffset),     "0")   '
      me.InitPKW("PInclude",      0,  VARPTR(PInclude),       "") '
      me.InitPKW("Preserve",      1,  VARPTR(PreserveTyp),    "0")   '
      me.InitPKW("ProfLock",      1,  VARPTR(LockFlag),       "0")   '
      me.InitPKW("RECFM",         0,  VARPTR(RECFM),          "U")   '
      me.InitPKW("ScrollAmount",  0,  VARPTR(SCROLLAmt),      "CSR") '
      me.InitPKW("Source",        0,  VARPTR(SourceName),     "ANSI")   '
      me.InitPKW("Start",         0,  VARPTR(Start),          "FIRST")  '
      me.InitPKW("StateFlag",     1,  VARPTR(StateFlag),      "0")   '
      me.InitPKW("SubInclude",    0,  VARPTR(SubInclude),     "$NONE$")   '
      me.InitPKW("SubArg",        0,  VARPTR(SubArg),         "") '
      me.InitPKW("SubCmd",        0,  VARPTR(SubCmd),         "") '
      me.InitPKW("TABS",          0,  VARPTR(TabsLine),       "") '
      me.InitPKW("TabBNDS",       1,  VARPTR(TabBNDS),        "0")   '
      me.InitPKW("TabsFlag",      1,  VARPTR(Tabs),           "1")   '
      me.InitPKW("WORD",          0,  VARPTR(WordInput),      $WORD) '
      me.InitPKW("XForm",         0,  VARPTR(XFormStr),       "") '
   END METHOD                                                     '

   CLASS METHOD InitPKW(KWord AS STRING, KType AS LONG, VAddr AS DWORD, TDef AS STRING)   '
   '-----------------------------------------------------------------------------------------------+
   '- Add an item to the KW table                                                                  |
   '-----------------------------------------------------------------------------------------------+
      INCR KWCtr                                                  ' Bump index
      KWTable(KWCtr).KWText = KWord                               ' Save the KW
      KWTable(KWCtr).KWType = KType                               ' Save the type
      KWTable(KWCtr).KWFlag = 0                                   ' Reset the flag
      KWTable(KWCtr).KWAddr.AVar = VAddr                          ' Save the pointer to it
      KWTable(KWCtr).KWDefault = TDef                             ' Save the default value
   END METHOD                                                     '

   INTERFACE iFCB: INHERIT IUNKNOWN                               ' Define the interface

      GProp(ActionSave, LONG)                                     '
      PROPERTY SET ActionSave(v AS LONG)                          '
         ActionSave = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Action", FORMAT$(ActionSave))   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(AutoBkup, LONG)                                       '
      PROPERTY SET AutoBkup(v AS LONG)                            '
         AutoBkup = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "AutoBkup", FORMAT$(AutoBkup))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(AUTOCAPS, LONG)                                       '
      PROPERTY SET AUTOCAPS(v AS LONG)                            '
         AUTOCAPS = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "AutoCaps", FORMAT$(AUTOCAPS))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(AutoName, STRING)                                     '
      PROPERTY SET AutoName(v AS STRING)                          '
         AutoName = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "AutoName", AutoName)  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(AutoSave, LONG)                                       '
      PROPERTY SET AutoSave(v AS LONG)                            '
         AutoSave = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "AutoSave", FORMAT$(AutoSave))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      METHOD BASE() AS STRING                                     '
      '--------------------------------------------------------------------------------------------+
      '- Return Base portion                                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG, t AS STRING                                '
         i = INSTR(-1, FilePath, "\")                             '
         t = IIF$(i, MID$(FilePath, i + 1), FilePath)             '
         i = INSTR(-1, t, ".")                                    '
         METHOD = IIF$(i, LEFT$(t, i - 1), t)                     '
      END METHOD                                                  '

      GProp(BndLeft, LONG)                                        '
      PROPERTY SET BndLeft(v AS LONG)                             '
         BndLeft = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "BndL", FORMAT$(BndLeft))  '
         me.BuildBndText                                          '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(BndRight, LONG)                                       '
      PROPERTY SET BndRight(v AS LONG)                            '
         BndRight = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "BndR", FORMAT$(BndRight))   '
         me.BuildBndText                                          '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(BndText, STRING)                                     '

      GProp(BOM, LONG)                                            '
      PROPERTY SET BOM(v AS LONG)                                 '
         BOM = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "BOM", FORMAT$(BOM))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      METHOD BuildBndText()                                       '
         IF BndRight > 0 THEN                                     ' We have a right bound
            BndText = RSET$(">", BndRight)                        ' Build string BndRight long
            MID$(BndText, BndLeft, 1) = "<"                       ' Stuff in BndLeft
         ELSE                                                     ' Else build a MAX format line
            BndText = RSET$("<+", BndLeft + 1)                    ' Stuff in BndLeft
         END IF                                                   '
         GoodBnds = BndText                                       ' Save good copy
         TP.BndText = BndText                                     ' Save to the working copy
      END METHOD                                                  '

      METHOD BuildLines()                                         '
      '--------------------------------------------------------------------------------------------+
      '- Build the Profile Display lines                                                           |
      '--------------------------------------------------------------------------------------------+
      LOCAL t1, t2, t3, t4 AS STRING, i1 AS LONG                  '
         MEntry                                                   '
         t4 = TP.EFTOVListG(0)                                    ' Get local copy
         TP.EFT1 = TP.EFTOVListG(0)                               ' Build EFT override line
         t2 =  "PROFILE " + UUCASE(ProfName) + _                  '
               IIF$(TP.EFTOVCtr, " EFT LOCKED", IIF$(ISFALSE LockFlag, " UNLOCKED", " LOCKED")) '
         t2 += ",  ": i1 = IsIn(t4, "ACTION")                     ' Setup ACTION
         t2 += IIF$(i1, "<", "") + "ACTION " + IIF$(ActionSave, FORMAT$(ActionSave), "OFF") + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "AUTOBKUP")                   ' Setup AUTOBKUP
         t2 += IIF$(i1, "<", "") + "AUTOBKUP " + IIF$(ISTRUE AutoBkup, "ON", "OFF") + IIF$(i1, ">", "")  '
         t2 += ",  ": i1 = IsIn(t4, "AUTOCAPS")                   ' Setup AUTOCAPS
         t2 += IIF$(i1, "<", "") + "AUTOCAPS " + IIF$(ISTRUE AUTOCAPS, "ON", "OFF") + IIF$(i1, ">", "")  '
         t2 += ",  ": i1 = IsIn(t4, "AUTONAME")                   ' Setup AUTONAME
         t2 += IIF$(i1, "<", "") + "AUTONAME " + IIF$(AutoName = "$NONE$", "NONE", AutoName) + IIF$(i1, ">", "")  '
         TP.Prof1 = t2                                            ' Save it

         i1 = IsIn(t4, "AUTOSAVE")                                ' Setup AUTOSAVE
         t3 =  IIF$((AutoSave AND %AutoSOn), "ON ", "OFF ")       '
         t3 += IIF$((AutoSave AND %AutoSPrompt), "PROMPT", "NOPROMPT")  '
         t2 = IIF$(i1, "<", "") + "AUTOSAVE " + T3 + IIF$(i1, ">", "")  '
         t2 += ",  ": i1 = IsIn(t4, "BOM")                        ' Setup BOM
         t2 += IIF$(i1, "<", "") + "BOM " + IIF$(ISTRUE BOM, "ON", "OFF") + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "CAPS")                       ' Setup CAPS
         t2 += IIF$(i1, "<", "") + "CAPS "                        '
         IF CapsDesired <> 2 THEN                                 '
            t2 += IIF$(CapsDesired, "ON", "OFF")                  '
         ELSE                                                     '
            t2 += IIF$(CapsActual, "AUTO:on", "AUTO:off")         '
         END IF                                                   '
         t2 += IIF$(i1, ">", "")                                  '
         t2 += ",  ": i1 = IsIn(t4, "CASE")                       ' Setup CASE
         t2 += IIF$(i1, "<", "") + "CASE " + TRIM$(CaseFlag) + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "CHANGE")                     ' Setup CHANGE
         t2 += IIF$(i1, "<", "") + "CHANGE " + IIF$(ChangeMode = "C", "CS", "DS") + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "COLLATE")                    ' Setup COLLATE
         t2 += IIF$(i1, "<", "") + "COLLATE " + CollateStr + IIF$(i1, ">", "")   '
         TP.Prof2 = t2                                            ' Save it

         i1 = IsIn(t4, "COLS")                                    ' Setup COLS
         t2 = IIF$(i1, "<", "") + "COLS " + IIF$(ISTRUE Cols, "ON", "OFF") + IIF$(i1, ">", "")  '
         i1 = IsIn(t4, "COMMENTS")                                ' Setup COMMENTS
         t2 += ",  " + IIF$(i1, "<", "") + "COMMENTS " + FORMAT$(CmntID) + " " +  FORMAT$(CmntCol) + " " + FORMAT$(CmntIncr) + " "  '
         T2 += FORMAT$(CmntEnd) + IIF$(i1, ">", "")               '
         t2 += ",  ": i1 = IsIn(t4, "EMACRO")                     ' Setup EMACRO
         t1 = EXTRACT$(EMacro, " ")                               ' Get macname
         t1 = IIF$(uucase(t1) = T1, " ON", " OFF")                ' Create ON/OFF
         t2 += IIF$(i1, "<", "") + "EMACRO " + IIF$(EMacro = "", "NONE", uucase(EMacro) + T1) + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "EOL") + IsIn(t4, "DCB")      ' Setup EOL/DCB
         t2 += IIF$(i1, "<", "") + "EOL " + IIF$(VERIFY(EOL, $Hex) = 0, "X'" + EOL + "'", EOL) + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "HEX")                        ' Setup HEX
         t2 += IIF$(i1, "<", "") + "HEX " + IIF$(HexMode = &1, "OFF", "ON") + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "HILITE")                     ' Setup HILITE
         t2 += IIF$(i1, "<", "") + "HILITE "                      '
         IF ISTRUE HiFind AND ISTRUE HiAuto THEN                  ' All on
            t2 += "FIND AUTO"                                     '
         ELSEIF ISTRUE HiFind THEN                                ' Find
            t2 += "FIND"                                          ' Yes, say FIND is on
         ELSEIF ISTRUE HiAuto THEN                                ' Auto
            t2 += "AUTO"                                          ' Yes, say AUTO is on
         ELSE                                                     ' Neither
            t2 += "OFF"                                           ' Yes, just say OFF
         END IF                                                   '
         t2 += IIF$(i1, ">", "")                                  '
         TP.Prof3 = t2                                            ' Save it

         i1 = IsIn(t4, "IMACRO")                                  ' Setup IMACRO
         t1 = EXTRACT$(IMacro, " ")                               ' Get macname
         t1 = IIF$(uucase(t1) = T1, " ON", " OFF")                ' Create ON/OFF
         t2 = IIF$(i1, "<", "") + "IMACRO " + IIF$(IMacro = "", "NONE", uucase(IMacro) + t1) + IIF$(i1, ">", "")  '
         t2 += ",  ": IsIn(t4, "INCLUDE")                         ' Setup INCLUDE
         t2 += IIF$(i1, "<", "") + "INCLUDE " + IIF$(PInclude = "", "NONE", PInclude) + IIF$(i1, ">", "")   '
         i1 = IsIn(t4, "LRECL") + IsIn(t4, "DCB")                 ' Setup LRECL/DCB
         t2 += ",  " + IIF$(i1, "<", "") + "LRECL " + FORMAT$(LRECL) + IIF$(i1, ">", "")  '
         t2 += ",  ": i1 = IsIn(t4, "MACLIB")                     ' Setup MACLIB
         t2 += IIF$(i1, "<", "") + "MACLIB " + IIF$(Maclib = "", "NONE", uucase(Maclib)) + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "MARK")                       ' Setup MARK
         t2 += IIF$(i1, "<", "") + "MARK " + IIF$(ISTRUE MarkFlag, "ON", "OFF") + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "MINLEN")                     ' Setup MINLEN
         t2 += IIF$(i1, "<", "") + "MINLEN " + FORMAT$(MINLEN) + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "MODE")                       ' Setup MODE
         t1 = SWITCH$(MODE = %Edit, "EDIT", MODE = %View, "VIEW", MODE = %Browse, "BROWSE")  '
         IF MODE <> TP.TabMode THEN t1 = "[" + t1 + "]"           '
         t2 += IIF$(i1, "<", "") + "MODE " + t1 + IIF$(i1, ">", "")  '
         TP.Prof4 = t2                                            ' Save it

         i1 = IsIn(t4, "PAGE")                                    ' Setup PAGE
         t2 = IIF$(i1, "<", "") + "PAGE " + IIF$(ISTRUE PageFlag, IIF$(PageFlag = 2, "SCROLL", "ON"), "OFF")  '
         IF PageFlag AND PageOffset <> 0 THEN t2 += " " + FORMAT$(PageOffset, "+#;-#") ' Add page offset if needed
         T2 += IIF$(i1, ">", "")                                  '
         i1 = IsIn(t4, "PRESERVE")                                ' Setup PRESERVE
         t2 += ",   " + IIF$(i1, "<", "") + "PRESERVE " + IIF$(PreserveTyp = 0, "OFF", IIF$(PreserveTyp = 1, "ON", "C")) + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "RECFM") + IsIn(t4, "DCB")    ' Setup RECFM/DCB
         t2 += IIF$(i1, "<", "") + "RECFM " + RECFM + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "SCROLL")                     ' Setup SCROLL
         t2 += IIF$(i1, "<", "") + "SCROLL " + TRIM$(SCROLLAmt) + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "SOURCE")                     ' Setup SOURCE
         t2 += IIF$(i1, "<", "") + "SOURCE " + SourceName + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "START")                      ' Setup START
         t2 += IIF$(i1, "<", "") + "START " + Start + IIF$(i1, ">", "")  '
         t2 += ",  ": i1 = IsIn(t4, "STATE")                      ' Setup STATE
         t2 += IIF$(i1, "<", "") + "STATE " + CHOOSE$(StateFlag + 1, "OFF", "ON", "FEW", "MOST") + IIF$(i1, ">", "")  '
         TP.Prof5 = t2                                            ' Save it

         i1 = IsIn(t4, "SUBARG")                                  ' Setup SUBARG
         t2 = IIF$(i1, "<", "") + "SUBARG " + IIF$(ISNULL(SubArg), "OFF", SubArg) + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "SUBCMD")                     ' Setup SUBCMD
         t2 += IIF$(i1, "<", "") + "SUBCMD " + IIF$(ISNULL(SubCmd), "OFF", SubCmd) + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "SUBINCLUDE")                 ' Setup SUBINCLUDE
         t2 += IIF$(i1, "<", "") + "SUBINCLUDE " + IIF$(SubInclude = "$NONE$", "NONE", SubInclude) + IIF$(i1, ">", "")   '
         t2 += ",  ": i1 = IsIn(t4, "TABS")                       ' Setup TABS
         t2 += IIF$(i1, "<", "") + "TABS " + IIF$(ISTRUE Tabs, "ON", "OFF") + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "TABBNDS")                    ' Setup TABBNDS
         t2 += IIF$(i1, "<", "") + "TABBNDS " + IIF$(ISTRUE TabBNDS, "ON", "OFF") + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "XFORM")                      ' Setup XFORM
         t1 = EXTRACT$(XFormStr, " ")                             ' Get macname
         t1 = IIF$(uucase(t1) = T1, " ON", " OFF")                ' Create ON/OFF
         t2 += IIF$(i1, "<", "") + "XFORM " + IIF$(XFormStr = "", "NONE", uucase(XFormStr) + T1) + IIF$(i1, ">", "") '
         t2 += ",  ": i1 = IsIn(t4, "XTABS")                      ' Setup XTABS
         t2 += IIF$(i1, "<", "") + "XTABS " + FORMAT$(ImportTabs) + IIF$(i1, ">", "")  '
         TP.Prof6 = t2                                            ' Save it
         MExit                                                    '
      END METHOD                                                  '

      METHOD BuildSourceXlate()                                   '
      REGISTER i AS LONG                                          '
      LOCAL S2A, A2S, t AS STRING                                 '

         t = SPACE$(256)                                          ' Make empty string
         FOR i = 0 TO 255                                         ' SOURCE ANSI to SOURCE table
            MID$(t, i + 1, 1) = CHR$(i)                           '
         NEXT                                                     '
         SA2S = t: SS2A = t: SrceXlate = %False                   ' Say no Source Xlate active

         t = SPACE$(256)                                          ' Make empty string
         FOR i = 0 TO 255                                         ' COLLATE ANSI to SOURCE table
            MID$(t, i + 1, 1) = CHR$(i)                           '
         NEXT                                                     '
         CA2S = t: CS2A = t: ColateXlate = %False                 ' Say no Collate Xlate active

         IF SourceName <> "ANSI" AND _                            ' Is SOURCE non-ANSI mode?
            SourceName <> "UTF8" AND _                            '
            SourceName <> "UTF16" AND _                           '
            SourceName <> "UTF16LE" AND _                         '
            SourceName <> "UTF16BE" THEN                          '
            IF SourceLoad(SourceName, A2S, S2A) THEN              ' Load table, if successful
               SA2S = A2S: SS2A = S2A: SrceXlate = %True          ' Say source Xlate active
            END IF                                                '
         END IF                                                   '
         IF CollateStr <> "ANSI" AND _                            ' Is SOURCE non-ANSI mode?
            CollateStr <> "UTF8" AND _                            '
            CollateStr <> "UTF16" AND _                           '
            CollateStr <> "UTF16LE" AND _                         '
            CollateStr <> "UTF16BE" THEN                          '

            '-----------------------------------------------------------------------------------------+
            '- if a SOURCE codepage failed validation, and we're asking for same name as COLLATE name |
            '- we will just get the same error again. if so, don't bother to load the COLLATE tables  |
            '- we only make the attempt to load if this is either a different name, or it's the same  |
            '- name as the SOURCE load above was successful                                           |
            '-----------------------------------------------------------------------------------------+

            IF (ISTRUE SrceXlate) OR (SourceName <> CollateStr) THEN '
               IF SourceLoad(CollateStr, A2S, S2A) THEN           ' Load table, if successful
                  CA2S = A2S: CS2A = S2A: ColateXlate = %True     ' Say source Xlate active
               END IF                                             '
            END IF                                                '
         END IF                                                   '
      END METHOD                                                  '

      GSProp(CA2S, STRING)                                        '

      GProp(CapsActual, LONG)                                     '
      PROPERTY SET CapsActual(v AS LONG)                          '
         CapsActual = v                                           '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(CapsDesired, LONG)                                    '
      PROPERTY SET CapsDesired(v AS LONG)                         '
         CapsDesired = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "CapsFlag", FORMAT$(CapsDesired))  '
         CapsActual = CapsDesired                                 '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(CaseFlag, STRING)                                     '
      PROPERTY SET CaseFlag(v AS STRING)                          '
         CaseFlag = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Case", CaseFlag)   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(ChangeMode, STRING)                                   '
      PROPERTY SET ChangeMode(v AS STRING)                        '
         ChangeMode = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Change", ChangeMode)   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(ChrUpper, STRING)                                    '
      GSProp(ChrLower, STRING)                                    '
      GSProp(ChrRegLower, STRING)                                 '
      GSProp(ChrRegUpper, STRING)                                 '

      GProp(CmntID, LONG)                                         '
      PROPERTY SET CmntID(v AS LONG)                              '
         CmntID = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "CmntID", FORMAT$(CmntID))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(CmntCol, LONG)                                        '
      PROPERTY SET CmntCol(v AS LONG)                             '
         CmntCol = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "CmntCol", FORMAT$(CmntCol))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(CmntIncr, LONG)                                       '
      PROPERTY SET CmntIncr(v AS LONG)                            '
         CmntIncr = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "CmntIncr", FORMAT$(CmntIncr))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(CmntEnd, LONG)                                        '
      PROPERTY SET CmntEnd(v AS LONG)                             '
         CmntEnd = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "CmntEnd", FORMAT$(CmntEnd))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(CollateStr, STRING)                                   '
      PROPERTY SET CollateStr(v AS STRING)                        '
         CollateStr = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Collate", CollateStr)  '
         me.BuildSourceXlate()                                    '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(ColateXlate, LONG)                                   '

      GProp(Cols, LONG)                                           '
      PROPERTY SET Cols(v AS LONG)                                '
         Cols = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "ColsFlag", FORMAT$(Cols)) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(CS2A, STRING)                                        '

      METHOD DATE() AS STRING                                     '
      '--------------------------------------------------------------------------------------------+
      '- Return File Date                                                                          |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF$(FilePath <> $New, LEFT$(TimePretty(FD.LastWriteTime), 10), "            ")  ' Save file date
      END METHOD                                                  '

      METHOD DispProfile()                                        '
      '--------------------------------------------------------------------------------------------+
      '- Build and display the Profile Dialog                                                      |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG, t AS STRING                                '
      DIM CAPSFlagList(2) AS STRING                               '
      DIM STATEFlagList(3) AS STRING                              '
      DIM PRESERVEList(2) AS STRING                               '
      DIM STARTList(4) AS STRING                                  '
      DIM AutoSaveList(3) AS GLOBAL STRING                        '
         MEntry                                                   '
         ARRAY ASSIGN CAPSFlagList() = "OFF", "ON", "AUTO"        '
         ARRAY ASSIGN STATEFlagList() = "OFF", "ON", "FEW", "MOST"   '
         ARRAY ASSIGN PRESERVEList() = "OFF", "ON", "C Mode"      '
         ARRAY ASSIGN STARTList() = "FIRST", "LAST", "PRIOR", "LABEL", "NEW"  '
         ARRAY ASSIGN AutoSaveList() = "OFF NOPROMPT", "ON NOPROMPT", "OFF PROMPT", "ON PROMPT" '

         '-----------------------------------------------------------------------------------------+
         '- Create the main dialogue                                                               |
         '-----------------------------------------------------------------------------------------+
         DIALOG FONT DEFAULT "Tahoma", 13 / gFontScale,0, 0       '
         DIALOG NEW ghWnd, "SPFLite Profile Editor - Profile = " + UUCASE(ProfName), , , 300, 250, %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR _ '
            %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR _  '
            %DS_SETFONT, %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO ghPrf '

         '-----------------------------------------------------------------------------------------+
         '- Add the Tab Control to main dialog box                                                 |
         '-----------------------------------------------------------------------------------------+
         CONTROL ADD TAB,     ghPrf, %TAB_CONTROL, "", 1, 1, 299, 225, %TCS_OWNERDRAWFIXED   '
         CONTROL ADD BUTTON,  ghPrf, %DIALOG_CANCEL, "&Cancel", 175, 233, 50, 14, %WS_BORDER OR %BS_DEFAULT '
         CONTROL SET FONT     ghPrf, %DIALOG_CANCEL, gBoldFont    '
         DLGToolTipSet(GetDlgItem(ghPrf, %DIALOG_CANCEL), " Press Cancel to return without saving the Profile ")  '
         CONTROL ADD BUTTON,  ghPrf, %DIALOG_DONE, "&Done", 235, 233, 50, 14, %WS_BORDER OR %BS_DEFAULT  '
         DLGToolTipSet(GetDlgItem(ghPrf, %DIALOG_DONE), " Press Done once you have made all Desired changes ") '
         CONTROL SET FONT     ghPrf, %DIALOG_DONE, gBoldFont      '
         CONTROL ADD IMAGEX,  ghPrf, %GENERAL_GPLV3, "GPLV3", 2, 226, 66, 24, %SS_ICON '

         '-----------------------------------------------------------------------------------------+
         '- Add the Tab 1                                                                          |
         '-----------------------------------------------------------------------------------------+
         TAB INSERT PAGE ghPrf, %TAB_CONTROL, 1, 0, "Editor Options", CALL DlgProfileCallBack TO ghPage1 '


         CONTROL ADD TEXTBOX, ghPage1, %FILE_AUTONAME, IIF$(AutoName = "$NONE$", "NONE", AutoName), 4,2, 96, 8, %ES_UPPERCASE '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_AUTONAME), " Enter the AUTO file to use")   '
         CONTROL ADD LABEL, ghPage1, %FILE_AUTONAME_TEXT, "Profile AUTONAME value", 130, 2, 250, 9 '
         CONTROL SET COLOR  ghPage1, %FILE_AUTONAME_TEXT, %WHITE, -2 '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_SUBCMD, IIF$(ISNULL(SubCmd), "NONE", SubCmd), 4,11, 96, 8, %ES_UPPERCASE   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_SUBCMD), " Enter optional substitute command to use if the SUBMIT command is issued for this file")  '
         CONTROL ADD LABEL, ghPage1, %FILE_SUBCMD_TEXT, "Profile SUBCMD name", 130, 11, 250, 9  '
         CONTROL SET COLOR  ghPage1, %FILE_SUBCMD_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_SUBARG, IIF$(ISNULL(SubArg), "NONE", SubArg), 4,20, 96, 8, %ES_UPPERCASE   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_SUBARG), " Enter optional SUBARG string")   '
         CONTROL ADD LABEL, ghPage1, %FILE_SUBARG_TEXT, "Profile SUBARG string", 130, 20, 250, 9   '
         CONTROL SET COLOR  ghPage1, %FILE_SUBARG_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_EMACRO, IIF$(EMacro = "", "NONE", UCASE$(EMacro) + IIF$(UCASE$(EMacro) = EMacro, " ON", " OFF")), _   '
                                      4,29, 96, 8, %ES_UPPERCASE  '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_EMACRO), " Enter optional EMACRO") '
         CONTROL ADD LABEL, ghPage1, %FILE_EMACRO_TEXT, "Profile EMACRO", 130, 29, 250, 9 '
         CONTROL SET COLOR  ghPage1, %FILE_EMACRO_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_IMACRO, IIF$(IMacro = "", "NONE", UCASE$(IMacro) + IIF$(UCASE$(IMacro) = IMacro, " ON", " OFF")), _   '
                                      4,38, 96, 8, %ES_UPPERCASE  '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_IMACRO), " Enter optional IMACRO") '
         CONTROL ADD LABEL, ghPage1, %FILE_IMACRO_TEXT, "Profile IMACRO", 130, 38, 250, 9 '
         CONTROL SET COLOR  ghPage1, %FILE_IMACRO_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_XFORM, IIF$(XFormStr = "", "NONE", UCASE$(XFormStr) + IIF$(UCASE$(XFormStr) = XFormStr, " ON", " OFF")), _  '
                              4,47, 96, 8, %ES_UPPERCASE          '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_XFORM), " Enter optional XFORM Macro Name") '
         CONTROL ADD LABEL, ghPage1, %FILE_XFORM_TEXT, "Profile XFORM Macro", 130, 47, 250, 9   '
         CONTROL SET COLOR  ghPage1, %FILE_XFORM_TEXT, %WHITE, -2 '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_MACLIB, IIF$(Maclib = "", "NONE", UCASE$(Maclib)), _  '
                              4,56, 96, 8, %ES_UPPERCASE          '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_MACLIB), " Enter optional MACLIB Name")  '
         CONTROL ADD LABEL, ghPage1, %FILE_MACLIB_TEXT, "Profile MACLIB Name", 130, 56, 250, 9  '
         CONTROL SET COLOR  ghPage1, %FILE_MACLIB_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_INCLUDE, IIF$(PInclude = "", "NONE", UCASE$(PInclude)), 4, 66, 96, 8, %ES_UPPERCASE '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_INCLUDE), " Enter the INCLUDE Parse string, See HELP")  '
         CONTROL ADD LABEL, ghPage1, %FILE_INCLUDE_TEXT, "INCLUDE SET Name", 130, 66, 75, 11 '
         CONTROL SET COLOR  ghPage1, %FILE_INCLUDE_TEXT, %WHITE, -2  '

         DLGAddCheck(ghPage1,%FILE_PROFLOCK, LockFlag, 4, 75, 75, "PROFILE LOCK")   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_PROFLOCK), "Start the Profile in LOCKed status ") '
         DLGAddCheck(ghPage1, %FILE_TABSFLAG, Tabs, 90, 75, 75, "TABS ON") '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_TABSFLAG), " Start the Profile in TABS ON mode ") '
         DLGAddCheck(ghPage1, %FILE_COLSFLAG, Cols, 4, 82, 75, "COLS ON")  '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_COLSFLAG), "Start the Profile with COLS ON ")  '
         DLGAddCheck(ghPage1, %FILE_HEXMFLAG, IIF(HexMode = 1, 0, 1), 90, 82, 75, "HEX ON")  '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_HEXMFLAG), "Start the Profile with HEX ON ")   '
         DLGAddCheck(ghPage1, %FILE_HIFIND, HiFind, 4, 90, 75, "HILITE FIND ON") '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_HIFIND), "Start the Profile with HILITE FIND ON ")   '
         DLGAddCheck(ghPage1, %FILE_HIAUTO, HiAuto, 90, 90, 75, "HILITE AUTO ON")   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_HIAUTO), "Start the Profile with HILITE AUTO ON ")   '
         DLGAddCheck(ghPage1, %FILE_CASE, IIF(CaseFlag = "C", 1, 0), 165, 98, 120, "Default CASE=C? (on=C, off=T)") '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_CASE), "Default CASE for text search strings ")   '
         DLGAddCheck(ghPage1, %FILE_MARKFLAG, MarkFlag, 165, 75, 75, "MARK ON")  '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_MARKFLAG), " Start the Profile in MARK ON mode ") '
         DLGAddCheck(ghPage1, %FILE_AUTOCAPS, AUTOCAPS, 4, 98, 75, "AUTOCAPS mode on")   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_AUTOCAPS), "Default for AUTOCAPS mode. AUTOCAPS converts keywords to CAPS based on the AUTO colorize file settings ")  '
         DLGAddCheck(ghPage1, %FILE_TABBNDS, TabBNDS, 90, 98, 75, "TABBNDS mode on")  '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_TABBNDS), "Default for TABBNDS mode. TABBNDS used the TABS line to create edit 'columns'. ")   '

         CONTROL ADD TEXTBOX, ghPage1, %FILE_SUBINCLUDE, IIF$(SubInclude = "$NONE$", "NONE", SubInclude), 4, 110, 175, 9  '
         CONTROL ADD LABEL, ghPage1, %FILE_SUBINCLUDE_TEXT, "SUBMIT #INCLUDE Path", 185, 110, 95, 11   '
         CONTROL SET COLOR  ghPage1, %FILE_SUBINCLUDE_TEXT, %WHITE, -2   '
         CONTROL ADD LABEL, ghPage1, %FILE_CMNTID_TEXT, "Comment: ID", 185, 122, 95, 11   '
         CONTROL SET COLOR  ghPage1, %FILE_CMNTID_TEXT, %WHITE, -2   '
         CONTROL ADD TEXTBOX, ghPage1, %FILE_CMNTID, FORMAT$(CmntID), 260, 122, 25, 9, %ES_NUMBER  '
         CONTROL ADD LABEL, ghPage1, %FILE_CMNTCOL_TEXT, ": Start Col", 217, 133, 55, 11  '
         CONTROL SET COLOR  ghPage1, %FILE_CMNTCOL_TEXT, %WHITE, -2  '
         CONTROL ADD TEXTBOX, ghPage1, %FILE_CMNTCOL, FORMAT$(CmntCol), 260, 133, 25, 9, %ES_NUMBER   '
         CONTROL ADD LABEL, ghPage1, %FILE_CMNTINCR_TEXT, ": Increment", 217, 144, 55, 11 '
         CONTROL SET COLOR  ghPage1, %FILE_CMNTINCR_TEXT, %WHITE, -2 '
         CONTROL ADD TEXTBOX, ghPage1, %FILE_CMNTINCR, FORMAT$(CmntIncr), 260, 144, 25, 9, %ES_NUMBER '
         CONTROL ADD LABEL, ghPage1, %FILE_CMNTEND_TEXT, ": End Col", 217, 155, 55, 11 '
         CONTROL SET COLOR  ghPage1, %FILE_CMNTEND_TEXT, %WHITE, -2  '
         CONTROL ADD TEXTBOX, ghPage1, %FILE_CMNTEND, FORMAT$(CmntEnd), 260, 155, 25, 9   '

         IF BndLeft = 1 AND BndRight = 0 THEN                     '
            t = "MAX"                                             '
         ELSEIF BndRight = 0 THEN                                 '
            t = FORMAT$(BndLeft) + ", MAX"                        '
         ELSE                                                     '
            t = FORMAT$(BndLeft) + ", " + FORMAT$(BndRight)       '
         END IF                                                   '
         CONTROL ADD TEXTBOX, ghPage1, %FILE_BOUNDS, t, 4, 124, 45, 9, %ES_UPPERCASE   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_BOUNDS), " Enter 'MAX', 'nn, MAX' or 'll,rr' left/right boundaries")   '
         CONTROL ADD LABEL, ghPage1, %FILE_BOUNDS_TEXT, "Default BOUNDS", 60, 124, 75, 11 '
         CONTROL SET COLOR  ghPage1, %FILE_BOUNDS_TEXT, %WHITE, -2   '

         CONTROL ADD COMBOBOX, ghPage1, %FILE_STATEFLAG, STATEFlagList(), 4, 135, 45, 64, %CBS_DROPDOWNLIST OR %WS_VSCROLL '
         COMBOBOX SELECT ghPage1, %FILE_STATEFLAG, StateFlag + 1  '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_STATEFLAG), " Select Desired handling of STATE information for this Profile ")  '
         CONTROL ADD LABEL, ghPage1, %FILE_STATEFLAG_TEXT, "STATE handling", 60, 135, 150, 11   '
         CONTROL SET COLOR  ghPage1, %FILE_STATEFLAG_TEXT, %WHITE, -2   '

         CONTROL ADD COMBOBOX, ghPage1, %FILE_CAPSDFLAG, CAPSFlagList(), 4, 149, 45, 64, %CBS_DROPDOWNLIST OR %WS_VSCROLL  '
         COMBOBOX SELECT ghPage1, %FILE_CAPSDFLAG, CapsDesired + 1   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_CAPSDFLAG), " Select ON/OFF to lock the setting, AUTO to base setting on the loaded file ") '
         CONTROL ADD LABEL, ghPage1, %FILE_CAPSDFLAG_TEXT, "CAPS mode", 60, 149, 150, 11  '
         CONTROL SET COLOR  ghPage1, %FILE_CAPSDFLAG_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX,   ghPage1, %FILE_SCRLAMTC, SCROLLAmt, 4, 163, 45, 9, %ES_CENTER OR %ES_UPPERCASE '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_SCRLAMTC), " Default scroll amount for PgUp/PgDn commands (CSR, PAGE, FULL, HALF, DATA or ###")   '
         CONTROL ADD LABEL, ghPage1, %FILE_SCRLAMTC_TEXT, "Scroll size when PgUp/PgDn keys are pressed", 60, 163, 250, 11  '
         CONTROL SET COLOR  ghPage1, %FILE_SCRLAMTC_TEXT, %WHITE, -2 '

         CONTROL ADD COMBOBOX, ghPage1, %FILE_START, STARTList(), 4, 174, 45, 80, %CBS_DROPDOWNLIST OR %WS_VSCROLL   '
         CONTROL ADD LABEL, ghPage1, %FILE_START_TEXT, "File positioning on load", 60, 175, 200, 11   '
         CONTROL SET COLOR  ghPage1, %FILE_START_TEXT, %WHITE, -2 '
         COMBOBOX SELECT ghPage1, %FILE_START, SWITCH(Start = "FIRST", 1, Start = "LAST", 2, Start = "PRIOR", 3, _   '
                                                     Start = "LABEL", 4, Start = "NEW", 5)   '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_START), " FIRST = Top of file, LAST = Bottom of file, PRIOR = Queue file, LABEL = User's .START label, NEW = Auto .START label ")  '

         CONTROL ADD TEXTBOX,   ghPage1, %FILE_ACTION, FORMAT$(ActionSave), 4, 187, 45, 9, %ES_NUMBER '
         DLGToolTipSet(GetDlgItem(ghPage1, %FILE_ACTION), " Enter #. # indicates no. of changes to trigger an automatic SAVE, 0 for NO automatic saves") '
         CONTROL ADD LABEL, ghPage1, %FILE_ACTION_TEXT, "SAVE after # changes, or 0 for no saves", 60, 187, 250, 11  '
         CONTROL SET COLOR  ghPage1, %FILE_ACTION_TEXT, %WHITE, -2   '

         CONTROL ADD LABEL, ghPage1, %FILE_MESSAGE1_TEXT, "For NEW - WORD, MARK, MASK and TABS are set to the defaults", 2, 197, 350, 11  '
         CONTROL SET COLOR  ghPage1, %FILE_MESSAGE1_TEXT, %YELLOW, -2   '
         CONTROL ADD LABEL, ghPage1, %FILE_MESSAGE2_TEXT, "For EDIT - WORD, MARK, MASK and TABS will be unaltered", 2, 205, 350, 11 '
         CONTROL SET COLOR  ghPage1, %FILE_MESSAGE2_TEXT, %YELLOW, -2   '

         '-----------------------------------------------------------------------------------------+
         '- Add the Tab 2                                                                          |
         '-----------------------------------------------------------------------------------------+
         TAB INSERT PAGE ghPrf, %TAB_CONTROL, 2, 0, "File Data Options", CALL DlgProfileCallBack TO ghPage2 '
         DLGAddCheck(ghPage2, %FILE_AUTOBKUP, AutoBkup, 4, 4, 115, "AUTOBKUP ON")   '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_AUTOBKUP), "Set the Profile to AUTOBKUP ON ")  '

         CONTROL ADD COMBOBOX, ghPage2, %FILE_PRESERVE, PRESERVEList(), 4, 20, 85, 80, %CBS_DROPDOWNLIST OR %WS_VSCROLL '
         CONTROL ADD LABEL, ghPage2, %FILE_PRESERVE_TEXT, "PRESERVE spaces on SAVE", 95, 22, 200, 12  '
         CONTROL SET COLOR  ghPage2, %FILE_PRESERVE_TEXT, %WHITE, -2 '
         COMBOBOX SELECT ghPage2, %FILE_PRESERVE, PreserveTyp + 1 '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_PRESERVE), " Select OFF to trim spaces, ON to keep them or C Mode to invoke C language mode ON ") '

         CONTROL ADD TEXTBOX, ghPage2, %FILE_SOURCEFLAG, SourceName, 4, 35, 85, 12  '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_SOURCEFLAG), " Enter the file's SOURCE encoding ")   '
         CONTROL ADD LABEL, ghPage2, %FILE_SOURCEFLAG_TEXT, "Encoding used (SOURCE)", 95, 37, 200, 12 '
         CONTROL SET COLOR  ghPage2, %FILE_SOURCEFLAG_TEXT, %WHITE, -2  '

         DLGAddCheck(ghPage2, %FILE_BOM, BOM, 4, 50, 115, "BOM Write ON")  '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_BOM), "Set ON to Write BOM (Byte Order Marker) at start of UTF files ")   '

         CONTROL ADD TEXTBOX, ghPage2, %FILE_COLLATE, CollateStr, 4, 65, 85, 12  '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_COLLATE), " Choose default Collate handling for HEX and SORT ")  '
         CONTROL ADD LABEL, ghPage2, %FILE_COLLATE_TEXT, "Collate handling", 95, 67, 200, 12 '
         CONTROL SET COLOR  ghPage2, %FILE_COLLATE_TEXT, %WHITE, -2  '

         CONTROL ADD COMBOBOX, ghPage2, %FILE_AUTOSAVE, AutoSaveList(), 4, 80, 85, 80, %CBS_DROPDOWNLIST OR %WS_VSCROLL '
         COMBOBOX SELECT ghPage2, %FILE_AUTOSAVE, AutoSave + 1    '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_AUTOSAVE), " Choose how modified files are to be handled when an END command is issued ")   '
         CONTROL ADD LABEL, ghPage2, %FILE_AUTOSAVE_TEXT, "Automatic file save at END (AUTOSAVE)", 95, 82, 200, 12   '
         CONTROL SET COLOR  ghPage2, %FILE_AUTOSAVE_TEXT, %WHITE, -2 '


         CONTROL ADD TEXTBOX, ghPage2, %FILE_LRECL, FORMAT$(LRECL), 4, 125, 45, 12  '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_LRECL), " If lines are not delimited by special characters, enter the fixed record length ")   '
         CONTROL ADD LABEL, ghPage2, %FILE_LRECL_TEXT, "Record length if fixed length records (LRECL)", 60, 127, 200, 12   '
         CONTROL SET COLOR  ghPage2, %FILE_LRECL_TEXT, %WHITE, -2 '

         i = SWITCH(UCASE$(RECFM) = "U", 1, RECFM = "F", 2, RECFM = "V", 3, RECFM = "VBI", 4, RECFM = "VLI", 5)   '
         CONTROL ADD COMBOBOX, ghPage2, %FILE_RECFM, gRECFMList(), 4, 140, 45, 64, %CBS_DROPDOWNLIST OR %WS_VSCROLL  '
         COMBOBOX SELECT ghPage2, %FILE_RECFM, i                  '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_RECFM), " Select the file's Record format (U, F or V) ")   '
         CONTROL ADD LABEL, ghPage2, %FILE_RECFM_TEXT, "File Record Format (RECFM)", 60, 142, 200, 12 '
         CONTROL SET COLOR  ghPage2, %FILE_RECFM_TEXT, %WHITE, -2 '

         i = SWITCH(EOL = "CRLF",     1, _                        '
                    EOL = "LF",       2, _                        '
                    EOL = "CR",       3, _                        '
                    EOL = "NL",       4, _                        '
                    EOL = "AUTO",     5, _                        '
                    EOL = "AUTONL",   6, _                        '
                    EOL = "NONE",     7)                          '
         IF i = 0 THEN                                            ' Not one of the standard EOLs?
            i = 8                                                 ' Set index for COMBOBOX SELECT below if Hex
            gEOLFlagList(7) = EOL                                 ' Set last slot th Hex value or blank
         END IF                                                   '
         CONTROL ADD COMBOBOX, ghPage2, %FILE_EOL, gEOLFlagList(), 4, 154, 45, 64, %CBS_DROPDOWN OR %WS_VSCROLL   '
         COMBOBOX SELECT ghPage2, %FILE_EOL, i                    '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_EOL), " Select the normal line delimiters or enter a 2 or 4 char. custom delimiter ") '
         CONTROL ADD LABEL, ghPage2, %FILE_EOL_TEXT, "End of line delimiter type (EOL)", 60, 156, 200, 12   '
         CONTROL SET COLOR  ghPage2, %FILE_EOL_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX,   ghPage2, %FILE_XTABS, FORMAT$(ImportTabs), 4, 168, 25, 12 '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_XTABS), " The TAB width to be used when expanding tabbed files") '
         CONTROL ADD LABEL, ghPage2, %FILE_XTABS_TEXT, "Import Tabs width", 60, 170, 250, 12 '
         CONTROL SET COLOR  ghPage2, %FILE_XTABS_TEXT, %WHITE, -2 '

         CONTROL ADD TEXTBOX,   ghPage2, %FILE_MINLEN, FORMAT$(MINLEN), 4, 183, 25, 12 '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_MINLEN), " Enter the minimum length of text lines DURING the edit") '
         CONTROL ADD LABEL, ghPage2, %FILE_MINLEN_TEXT, "Minimum working text line length", 60, 185, 250, 12   '
         CONTROL SET COLOR  ghPage2, %FILE_MINLEN_TEXT, %WHITE, -2   '

         CONTROL ADD TEXTBOX,   ghPage2, %FILE_CHANGE, IIF$(ChangeMode = "D", "DS", "CS"), 4, 198, 25, 12   '
         DLGToolTipSet(GetDlgItem(ghPage2, %FILE_CHANGE), " Enter your choice for default CHANGE processing")  '
         CONTROL ADD LABEL, ghPage2, %FILE_CHANGE_TEXT, "CHANGE default shift. DS=Data Shift, CS=Column Shift", 60, 200, 250, 12 '
         CONTROL SET COLOR  ghPage2, %FILE_CHANGE_Text, %WHITE, -2   '

         '-----------------------------------------------------------------------------------------+
         '- DISPLAY the Profile DIALOG BOX                                                         |
         '-----------------------------------------------------------------------------------------+
         TAB SELECT ghPrf, %TAB_CONTROL, 1                        '
         GRAPHIC REDRAW                                           '
         gfDialogDone = %False                                    ' Clear CANCEL flag
         KbdPopSave                                               ' Ready for pop-up
         DIALOG SHOW MODAL ghPrf CALL DlgProfileCallBack          '
         KbdPopRestore                                            ' Reset popup state
         MExit                                                    '
      END METHOD                                                  '

      METHOD DoneCheck() AS LONG                                  '
      '--------------------------------------------------------------------------------------------+
      '- Validate dialog variables when DONE clicked                                               |
      '--------------------------------------------------------------------------------------------+
      LOCAL lclScroll, lclText, lclW1, lclW2, lclW3, lclEOL, lclRECFM AS STRING, i, lclLRECL AS LONG  '
      LOCAL RCA AS RCArea, t1, t2 AS STRING                       '
         '-----------------------------------------------------------------------------------------+
         '- Check SCROLL                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_SCRLAMTC TO LclScroll    ' Get the Scroll amount
         lclScroll = TRIM$(UUCASE(lclScroll))                     ' Upper case
         IF lclScroll <> "P" AND lclScroll <> "PAGE" AND lclScroll <> "H" AND lclScroll <> "HALF" AND _  '
            lclScroll <> "D" AND lclScroll <> "DATA" AND lclScroll <> "F" AND lclScroll <> "FULL" AND _  '
            lclScroll <> "CSR" AND lclScroll <> "C" AND lclScroll <> "CUR" AND VAL(lclScroll) = 0 THEN   '
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            DoMessageBox "Scroll amount is invalid", %MB_OK OR %MB_USERICON, "SPFLite" '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check LRECL                                                                            |
         '-----------------------------------------------------------------------------------------+
         lclLRECL = LRECL                                         ' Save current in case no new one
         CONTROL GET TEXT ghPage2, %FILE_LRECL TO LclText         ' Validate LRECL
         IF VAL(lclText) < 0 OR VAL(lclText) > 32768 THEN         ' Reasonable range?
            TAB SELECT ghPrf, %TAB_CONTROL, 2                     '
            DoMessageBox "LRECL is invalid", %MB_OK OR %MB_USERICON, "SPFLite"   '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '
         lclLRECL = VAL(lclText)                                  ' Save for next section

         '-----------------------------------------------------------------------------------------+
         '- Check RECFM                                                                            |
         '-----------------------------------------------------------------------------------------+
         lclRECFM = RECFM                                         ' Save current in case no new one
         CONTROL GET TEXT ghPage2, %FILE_RECFM TO lclText         '
         lcltext = UUCASE(lcltext)                                ' UC it
         ARRAY SCAN gRECFMList(), = lcltext, TO i                 ' See if one of the 'normal' entries
         IF i = 0 THEN                                            ' No? error
            TAB SELECT ghPrf, %TAB_CONTROL, 2                     '
            DoMessageBox "No RECFM type selected", %MB_OK OR %MB_USERICON, "SPFLite"   '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '
         lclRECFM = lclText                                       ' Save for next section

         '-----------------------------------------------------------------------------------------+
         '- Check EOL                                                                              |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage2, %FILE_EOL TO lclText           '
         lcltext = TRIM$(UCASE$(lcltext))                         ' UCASE and trim it
         ARRAY SCAN gEOLFlagList() FOR 7, = lcltext, TO i         ' See if one of the 'normal' entries
         IF i = 8 THEN                                            ' Hex?
            IF (LEN(lcltext) <> 2 AND LEN(lcltext) <> 4) OR _     '
            VERIFY(lcltext, $Hex) <> 0 THEN                       ' If not a 2 or 4 byte hex value
               TAB SELECT ghPrf, %TAB_CONTROL, 2                  '
               DoMessageBox "EOL Hex string is not a valid 2 or 4 character hex string", %MB_OK OR %MB_USERICON, "SPFLite" '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '
         lclEOL = lcltext                                         '

         '-----------------------------------------------------------------------------------------------+
         '- Validate out the illogical combinations                                                      |
         '-----------------------------------------------------------------------------------------------+
         IF lclRECFM = "U" THEN                                   ' RECFM = U
            IF lclEOL = "NONE" THEN                               ' + EOL=NONE
               TAB SELECT ghPrf, %TAB_CONTROL, 2                  '
               DoMessageBox "RECFM=U and EOL=NONE cannot be combined", %MB_OK OR %MB_USERICON, "SPFLite" '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
            IF lclLRECL > 0 THEN                                  ' + LRECL=nnn
               TAB SELECT ghPrf, %TAB_CONTROL, 2                  '
               DoMessageBox "RECFM=U and LRECL=" + FORMAT$(lclLRECL) + " cannot be combined", %MB_OK OR %MB_USERICON, "SPFLite"  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         IF lclRECFM = "F" THEN                                   ' RECFM = F
            IF lclLRECL = 0 THEN                                  ' + LRECL=0
               TAB SELECT ghPrf, %TAB_CONTROL, 2                  '
               DoMessageBox "RECFM=F and LRECL=0 cannot be combined", %MB_OK OR %MB_USERICON, "SPFLite"  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         IF LEFT$(lclRECFM, 1) = "V" THEN                         ' RECFM = V
            IF lclEOL <> "NONE" THEN                              ' + EOL=NONE
               TAB SELECT ghPrf, %TAB_CONTROL, 2                  '
               DoMessageBox "RECFM=" + lclRECFM + " and EOL=" + lclEOL + " cannot be combined", %MB_OK OR %MB_USERICON, "SPFLite"   '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
            IF lclLRECL > 0 THEN                                  ' + LRECL=nnn
               TAB SELECT ghPrf, %TAB_CONTROL, 2                  '
               DoMessageBox "RECFM=" + lclRECFM + " and LRECL=" + FORMAT$(lclLRECL) + " cannot be combined", %MB_OK OR %MB_USERICON, "SPFLite"  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check XTABS                                                                            |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage2, %FILE_XTABS TO LclText         ' Validate XTabs
         IF VAL(lclText) < 0 OR VAL(lclText) > 16 THEN            ' Reasonable range?
            TAB SELECT ghPrf, %TAB_CONTROL, 2                     '
            DoMessageBox "Import tab expand value is invalid", %MB_OK OR %MB_USERICON, "SPFLite"   '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check CHANGE                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage2, %FILE_CHANGE TO LclText        ' Validate Change
         IF IsNE(lclText, "DS") AND IsNE(lclText, "CS") THEN      ' Correct choice?
            TAB SELECT ghPrf, %TAB_CONTROL, 2                     '
            DoMessageBox "Change shift type value is invalid", %MB_OK OR %MB_USERICON, "SPFLite"   '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check MINLEN                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage2, %FILE_MINLEN TO LclText        ' Validate MinLen
         IF VAL(lclText) < 0 THEN                                 ' Reasonable range?
            TAB SELECT ghPrf, %TAB_CONTROL, 2                     '
            DoMessageBox "Minimum working text length is invalid", %MB_OK OR %MB_USERICON, "SPFLite"  '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check SOURCE                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage2, %FILE_SOURCEFLAG TO LclText    ' Validate SOURCE
         LclText = UUCASE(LclText)                                '
         IF ISNULL(TRIM$(LclText)) THEN LclText = "ANSI"          ' Make null into ANSI
         IF LclText <> SourceName THEN                            ' If it has been changed
            IF LclText <> "ANSI" AND _                            ' Is SOURCE non-ANSI mode?
               LclText <> "UTF8" AND _                            '
               LclText <> "UTF16" AND _                           '
               LclText <> "UTF16LE" AND _                         '
               LclText <> "UTF16BE" THEN                          '
               IF ISFALSE ISFILE(gENV.HomeFolder + LclText + ".SOURCE") THEN  ' See if the Custom SOURCE file exists
                  DoMessageBox "SOURCE translate file: |K" + gENV.HomeFolder + LclText + ".SOURCE |Bis not found, please correct", _   '
                               %MB_OK OR %MB_USERICON, "SPFLite"  '
                  METHOD = %True: EXIT METHOD                     '
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check COLLATE                                                                          |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage2, %FILE_COLLATE TO LclText       ' Validate SOURCE
         LclText = UUCASE(LclText)                                '
         IF ISNULL(TRIM$(LclText)) THEN LclText = "ANSI"          ' Make null into ANSI
         IF LclText <> CollateStr THEN                            ' If it has been changed
            IF LclText <> "ANSI" AND _                            ' Is COLLATE non-ANSI mode?
               LclText <> "UTF8" AND _                            '
               LclText <> "UTF16" AND _                           '
               LclText <> "UTF16LE" AND _                         '
               LclText <> "UTF16BE" THEN                          '
               IF ISFALSE ISFILE(gENV.HomeFolder + LclText + ".SOURCE") THEN  ' See if the Custom SOURCE file exists
                  DoMessageBox "COLLATE translate file: |K" + gENV.HomeFolder + LclText + ".SOURCE |Bis not found, please correct", _  '
                               %MB_OK OR %MB_USERICON, "SPFLite"  '
                  METHOD = %True: EXIT METHOD                     '
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check ACTION                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_ACTION TO LclText        '
         LclText = REMOVE$(LclText, " ")                          ' Remove blanks
         IF INSTR(LclText, ",") = 0 THEN                          ' No comma?
            lclW1 = LclText: lclW2 = ""                           ' Single operand
         ELSE                                                     ' Two operands
            lclW1 = LEFT$(LclText, INSTR(LclText, ",") - 1)       ' Split them
            lclW2 = UUCASE(MID$(LclText, INSTR(LclText, ",") + 1))   '
         END IF                                                   '

         IF VERIFY(lclW1, $Numeric) <> 0 THEN                     ' Only numeric
            DoMessageBox "ACTION 1st operand is invalid", %MB_OK OR %MB_USERICON, "SPFLite"  '
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '

         IF lclW2 <> "" AND (lclW2 <> "SAVE") THEN                '
            DoMessageBox "ACTION 2nd operand is not |KSAVE|B ", %MB_OK OR %MB_USERICON, "SPFLite"  '
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check INCLUDE                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_INCLUDE TO lclText       '
         IF TRIM$(lclText) = "NONE" THEN lclText = ""             '
         IF lclText <> "" THEN                                    ' If a name, see if it exists
            t1 = ""                                               '
            SETTableUpd("GET", "INCLPARSE." + lclText, RCA)       ' GET The 1st SET value
            IF RCA.RC <> 0 THEN t1 += "INCLPARSE." + lclText      ' Fail? Remember the name
            SETTableUpd("GET", "INCLPATHS." + lclText, RCA)       ' GET The 2nd SET value
            IF RCA.RC <> 0 THEN t1 += IIF$(t1 <> "", " / ", "") + "INCLPATHS." + lclText  ' Fail? Remember the name
            IF t1 <> "" THEN                                      '
               DoMessageBox "Warning, the INCLUDE SET symbol(s) (" + t1 + ") are not yet defined", %MB_OK OR %MB_USERICON, "SPFLite"   '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               RCA.Msg = ""                                       ' Null Set
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check IMacro                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_IMACRO TO lclText        '
         lclText = SHRINK$(lclText, " ")                          ' Clean it
         IF lclText <> "" AND lclText <> "NONE" THEN              ' Worthwhile checking?
            lclW1 = EXTRACT$(lclText, " ")                        ' Separate macname and operands
            lclW2 = TRIM$(REMAIN$(lclText, " "))                  '
            IF lclW1 = "ON" OR lclW1 = "OFF" THEN                 ' Reserved names?
               DoMessageBox "IMACRO 1st operand can not be |KON|B or |KOFF|B", %MB_OK OR %MB_USERICON, "SPFLite"  '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
            IF lclW2 = "" THEN lclW2 = "ON"                       ' Default ON
            IF lclW2 <> "ON" AND lclW2 <> "OFF" THEN              ' Only ON/OFF allowed
               DoMessageBox "IMACRO 2nd operand is not |KON|B or |KOFF|B", %MB_OK OR %MB_USERICON, "SPFLite"   '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check EMacro                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_EMACRO TO lclText        '
         lclText = SHRINK$(lclText, " ")                          ' Clean it
         IF lclText <> "" AND lclText <> "NONE" THEN              ' Worthwhile checking?
            lclW1 = EXTRACT$(lclText, " ")                        ' Separate macname and operands
            lclW2 = TRIM$(REMAIN$(lclText, " "))                  '
            IF lclW1 = "ON" OR lclW1 = "OFF" THEN                 ' Reserved names?
               DoMessageBox "EMACRO 1st operand can not be |KON|B or |KOFF|B", %MB_OK OR %MB_USERICON, "SPFLite"  '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
            IF lclW2 = "" THEN lclW2 = "ON"                       ' Default ON
            IF lclW2 <> "ON" AND lclW2 <> "OFF" THEN              ' Only ON/OFF allowed
               DoMessageBox "EMACRO 2nd operand is not |KON|B or |KOFF|B", %MB_OK OR %MB_USERICON, "SPFLite"   '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check XFORM                                                                            |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_XFORM TO lclText         '
         lclText = SHRINK$(lclText, " ")                          ' Clean it
         IF lclText <> "" AND lclText <> "NONE" THEN              ' Worthwhile checking?
            lclW1 = EXTRACT$(lclText, " ")                        ' Separate macname and operands
            lclW2 = TRIM$(REMAIN$(lclText, " "))                  '
            IF lclW1 = "ON" OR lclW1 = "OFF" THEN                 ' Reserved names?
               DoMessageBox "XFORM 1st operand can not be |KON|B or |KOFF|B", %MB_OK OR %MB_USERICON, "SPFLite"   '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
            IF lclW2 = "" THEN lclW2 = "ON"                       ' Default ON
            IF lclW2 <> "ON" AND lclW2 <> "OFF" THEN              ' Only ON/OFF allowed
               DoMessageBox "XFORM 2nd operand is not |KON|B or |KOFF|B", %MB_OK OR %MB_USERICON, "SPFLite" '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check SubInclude                                                                       |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_SubInclude TO lclText    '
         IF lclText <> "" AND UCASE$(lclText) <> "NONE" THEN      ' Worthwhile checking?
            StrUnQuote(lclText)                                   ' Remove any quotes
            IF ISFALSE ISFOLDER(lclText) THEN                     ' Better be a folder
               DoMessageBox "SubInclude operand is not a valid folder", %MB_OK OR %MB_USERICON, "SPFLite"   '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check AUTONAME                                                                         |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_AUTONAME TO lclText      '
         IF TRIM$(lclText) = "NONE" THEN lclText = "$NONE$"       '
         IF TRIM$(lclText) = "*" THEN lclText = ProfName          '
         IF lclText <> "$NONE$" THEN                              ' If a name, see if it exists
            IF ISFALSE ISFILE(gENV.HomeData + "AUTO\" + lclText + ".AUTO") THEN   ' See if Colorize file exists
               DoMessageBox "The |K" + lclText + ".AUTO|B file does not exist", %MB_OK OR %MB_USERICON, "SPFLite" '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check MACLIB                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_MACLIB TO lclText        '
         lclText = TRIM$(lclText)                                 '
         IF lclText <> "NONE" THEN                                '
            SETTableUpd("GET", "MACLIB." + lclText, RCA)          ' GET The SET value
            IF RCA.RC <> 0 THEN                                   ' Fail?
               DoMessageBox "Warning, the MACLIB SET name: |KMACLIB." + lclText + "|B does not exist yet", %MB_OK OR %MB_USERICON, "SPFLite" '
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               RCA.Msg = ""                                       ' Null Set
            END IF                                                '
            t1 = RCA.Msg: strunquote(t1)                          ' Remove extraneous quotes from SET value
            IF ISNOTNULL(t1) THEN                                 ' Something?
               FOR i = 1 TO PARSECOUNT(t1, ";")                   ' Get number of paths
                  t2 = PARSE$(t1, ";", i)                         ' For each pathname
                  IF ISFALSE ISFOLDER(t2) THEN                    ' Exist?
                     DoMessageBox "Warning, the MACLIB Folder: |K" + t2 + "|B does not exist", %MB_OK OR %MB_USERICON, "SPFLite" '
                     TAB SELECT ghPrf, %TAB_CONTROL, 1            '
                  END IF                                          '
               NEXT i                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check COMMENTS fields                                                                  |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_CMNTID  TO LclW1         ' Validate ID
         IF VAL(lclW1) <> 0 THEN                                  ' If zero, ignore check
            IF VAL(LclW1) < 1 OR VAL(LclW1) > 9 THEN              ' Out of range?
               TAB SELECT ghPrf, %TAB_CONTROL, 1                  '
               DoMessageBox "COMMENTS ID must be between 1 and 9", %MB_OK OR %MB_USERICON, "SPFLite"  '
               METHOD = %True: EXIT METHOD                        '
            END IF                                                '
         END IF                                                   '
         CONTROL GET TEXT ghPage1, %FILE_CMNTCOL TO LclW1         ' Validate Column
         IF VAL(LclW1) > 150 THEN                                 ' Excessive?
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            DoMessageBox "COMMENTS Column is excessively large", %MB_OK OR %MB_USERICON, "SPFLite" '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '
         CONTROL GET TEXT ghPage1, %FILE_CmntIncr TO LclW2        ' Validate Increment (already numeric)
         IF VAL(LclW2) > 50 THEN                                  ' Excessive?
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            DoMessageBox "COMMENTS Increment is excessively large", %MB_OK OR %MB_USERICON, "SPFLite" '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '
         IF VAL(LclW1) > 0 AND VAL(LclW2) = 0 THEN                ' Missing Increment?
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            DoMessageBox "COMMENTS Increment cannot be zero with a specified column number", %MB_OK OR %MB_USERICON, "SPFLite"   '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '
         CONTROL GET TEXT ghPage1, %FILE_CmntEnd TO LclW1         ' Validate End
         IF VAL(LclW1) > 150 THEN                                 ' Excessive?
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            DoMessageBox "COMMENTS End Column is excessively large", %MB_OK OR %MB_USERICON, "SPFLite"   '
            METHOD = %True: EXIT METHOD                           '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check BOUNDS                                                                           |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_BOUNDS TO LclText        ' Validate BOUNDS
         LclText = REMOVE$(LclText, " ")                          ' Remove blanks
         IF INSTR(LclText, ",") = 0 THEN                          ' No comma?
            lclW1 = LclText: lclW2 = ""                           ' Single operand
         ELSE                                                     ' Two operands
            lclW1 = LEFT$(LclText, INSTR(LclText, ",") - 1)       ' Split them
            lclW2 = MID$(LclText, INSTR(LclText, ",") + 1)        '
         END IF                                                   '
         IF lclW2 = "" AND IsEQ(LclW1, "MAX") THEN                ' Simple MAX
            '-                                                    '
         ELSEIF lclW2 = "" AND VAL(lclW1) > 0 THEN                ' Single number?
            '-                                                    '
         ELSEIF VAL(lclW1) > 0 AND IsEQ(lclW2, "MAX") THEN        ' nn, MAX
            '-                                                    '
         ELSEIF VAL(lclW1) > 0 AND VAL(lclW2) > 0 AND _           '
                VAL(lclW1) < VAL(lclW2) THEN                      ' ll, rr range
                                                                  '
         ELSE                                                     '
            TAB SELECT ghPrf, %TAB_CONTROL, 1                     '
            DoMessageBox "BOUNDS specification is invalid", %MB_OK OR %MB_USERICON, "SPFLite"   '
            METHOD = %True: EXIT METHOD                           ' ------+
         END IF                                                   '       |
                                                                  '       |
         '-----------------------------------------------------------------------------------------+
         '- Now do it again, making the changes ' NOTE: Keep together     |                        |
         '-----------------------------------------------------------------------------------------+
                                                                  '       |
         '-----------------------------------------------------------------------------------------+
         '- Bounds                                                ' ------+                        |
         '-----------------------------------------------------------------------------------------+
         IF lclW2 = "" AND IsEQ(LclW1, "MAX") THEN                ' Simple MAX
            BndLeft = 1: BndRight = 0                             '
         ELSEIF lclW2 = "" AND VAL(lclW1) > 0 THEN                ' Single number?
            BndLeft = 1: BndRight = VAL(lclW1)                    '
         ELSEIF VAL(lclW1) > 0 AND IsEQ(lclW2, "MAX") THEN        ' nn, MAX
            BndLeft = VAL(lclW1): BndRight = 0                    '
         ELSEIF VAL(lclW1) > 0 AND VAL(lclW2) > 0 AND _           '
                VAL(lclW1) < VAL(lclW2) THEN                      ' ll, rr range
            BndLeft = VAL(lclW1): BndRight = VAL(lclW2)           '
         END IF                                                   '

         CONTROL GET TEXT ghPage1, %FILE_SUBARG TO lclText        '
         IF TRIM$(UCASE$(lclText)) = "NONE" THEN lclText = ""     ' Handle "NONE"
         SubArg = UUCASE(TRIM$(lclText))                          '
         CONTROL GET TEXT ghPage1, %FILE_SUBCMD TO lclText        '
         IF TRIM$(UCASE$(lclText)) = "NONE" THEN lclText = ""     '
         SubCmd = UUCASE(lclText)                                 '
         CONTROL GET TEXT ghPage1, %FILE_AUTONAME TO lclText      '
         IF TRIM$(UCASE$(lclText)) = "NONE" THEN lclText = "$NONE$"  '
         IF TRIM$(UCASE$(lclText)) = "*" THEN lclText = ProfName  '
         AutoName = UUCASE(lclText)                               '
         CONTROL GET TEXT ghPage1, %FILE_MACLIB TO lclText        '
         IF TRIM$(UCASE$(lclText)) = "NONE" THEN lclText = ""     '
         Maclib = UUCASE(lclText)                                 '

         CONTROL GET TEXT ghPage1, %FILE_IMACRO TO lclText        ' Handle IMACRO
         lclText = UCASE$(lclText)                                '
         IF TRIM$(lclText) = "NONE" THEN lclText = ""             ' Handle "NONE"
         IF lclText <> "" THEN                                    '
            lclW1 = EXTRACT$(lclText, " ")                        ' Separate macname and operands
            lclW2 = TRIM$(REMAIN$(lclText, " "))                  '
            IF lclW2 = "" THEN lclW2 = "ON"                       ' Default ON
            lclText = IIF$(lclW2 = "ON", lclW1, LCASE$(lclW1))    ' Save ON/OFF as UC/LC
         END IF                                                   '
         IMacro = lclText                                         ' Finally, save it

         CONTROL GET TEXT ghPage1, %FILE_EMACRO TO lclText        '
         lclText = UCASE$(TRIM$(lclText))                         '
         IF lclText = "NONE" THEN lclText = ""                    ' Handle NONE
         IF lclText <> "" THEN                                    '
            lclW1 = EXTRACT$(lclText, " ")                        ' Separate macname and operands
            lclW2 = TRIM$(REMAIN$(lclText, " "))                  '
            IF lclW2 = "" THEN lclW2 = "ON"                       ' Default ON
            lclText = IIF$(lclW2 = "ON", lclW1, LCASE$(lclW1))    ' Save ON/OFF as UC/LC
         END IF                                                   '
         EMacro = lclText                                         ' Finally, save it

         CONTROL GET TEXT ghPage1, %FILE_XFORM TO lclText         '
         lclText = UCASE$(TRIM$(lclText))                         '
         IF lclText = "NONE" THEN lclText = ""                    ' Handle NONE
         IF lclText <> "" THEN                                    '
            lclW1 = EXTRACT$(lclText, " ")                        ' Separate macname and operands
            lclW2 = TRIM$(REMAIN$(lclText, " "))                  '
            IF lclW2 = "" THEN lclW2 = "ON"                       ' Default ON
            lclText = IIF$(lclW2 = "ON", lclW1, LCASE$(lclW1))    ' Save ON/OFF as UC/LC
         END IF                                                   '
         XFormStr = lclText                                       '

         CONTROL GET TEXT ghPage1, %FILE_MACLIB TO lclText        '
         lclText = UCASE$(TRIM$(lclText))                         '
         IF lclText = "NONE" THEN lclText = ""                    ' Handle NONE
         Maclib = lclText                                         '

         CONTROL GET TEXT ghPage1, %FILE_INCLUDE TO lclText       '
         lclText = UCASE$(TRIM$(lclText))                         '
         IF lclText = "NONE" THEN lclText = ""                    '
         PInclude = lclText                                       '

         CONTROL GET TEXT ghPage1, %FILE_SUBINCLUDE TO lclText    '
         lclText = UCASE$(TRIM$(lclText)): strUnQuote(lclText)    '
         IF UCASE$(lclText) = "NONE" THEN lclText = "$NONE$"      '
         IF lclText <> "$NONE$" THEN                              '
            IF RIGHT$(lclText, 1) <> "\" THEN lclText += "\"      ' Add \ if missing
         END IF                                                   '
         SubInclude = lclText                                     '

         CONTROL GET TEXT ghPage1, %FILE_ACTION TO LclText        '
         ActionSave = VAL(LclText)                                '
         CONTROL GET CHECK ghPage1, %FILE_PROFLOCK TO i           '
         LockFlag = i                                             '
         CONTROL GET CHECK ghPage1, %FILE_TABSFLAG TO i           '
         Tabs = i                                                 '
         CONTROL GET CHECK ghPage1, %FILE_TABBNDS TO i            '
         TabBNDS = i                                              '
         CONTROL GET CHECK ghPage1, %FILE_MARKFLAG TO i           '
         MarkFlag = i                                             '
         CONTROL GET CHECK ghPage1, %FILE_COLSFLAG TO i           '
         Cols = i                                                 '
         CONTROL GET CHECK ghPage1, %FILE_HEXMFLAG TO i           '
         HexMode = IIF(i, 4, 1)                                   '
         CONTROL GET CHECK ghPage1, %FILE_HIAUTO TO i             '
         HiAuto = i                                               '
         CONTROL GET CHECK ghPage1, %FILE_HIFIND TO i             '
         HiFind = i                                               '
         CONTROL GET TEXT ghPage1, %FILE_IMACRO TO lclText        '

         '-----------------------------------------------------------------------------------------+
         '- Reformat IMACRO                                                                        |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_IMACRO TO lclText        '
         lclText = UCASE$(SHRINK$(lclText, " "))                  ' Uppercase and clean it
         lclW1 = EXTRACT$(lclText, " ")                           ' Separate macname and operands
         lclW2 = REMAIN$(lclText, " ")                            '
         lclW1 = IIF$(uucase(lclW1) = "NONE", "", lclW1)          ' Build the Profile save value
         IF lclW1 <> "" THEN                                      ' If not the NONE case
            lclText = IIF$(lclW2 = "ON", uucase(lclW1), llcase(lclW1))  ' Set v=uppercase for ON, lowercase for OFF
         ELSE                                                     '
            lclText = ""                                          '
         END IF                                                   '
         IMAcro = lclText                                         '

         '-----------------------------------------------------------------------------------------+
         '- Reformat XFORM                                                                         |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_XFORM TO lclText         '
         lclText = UCASE$(SHRINK$(lclText, " "))                  ' Uppercase and clean it
         lclW1 = EXTRACT$(lclText, " ")                           ' Separate macname and operands
         lclW2 = REMAIN$(lclText, " ")                            '
         lclW1 = IIF$(uucase(lclW1) = "NONE", "", lclW1)          ' Build the Profile save value
         IF lclW1 <> "" THEN                                      ' If not the NONE case
            lclText = IIF$(lclW2 = "ON", uucase(lclW1), llcase(lclW1))  ' Set v=uppercase for ON, lowercase for OFF
         ELSE                                                     '
            lclText = ""                                          '
         END IF                                                   '
         XFormStr = lclText                                       '

         '-----------------------------------------------------------------------------------------+
         '- Reformat MACLIB                                                                        |
         '-----------------------------------------------------------------------------------------+
         CONTROL GET TEXT ghPage1, %FILE_MACLIB TO lclText        '
         lclText = UCASE$(lclText)                                ' Uppercase
         lclText = IIF$(lclText = "NONE", "", lclText)            ' Build the Profile save value
         Maclib = lclText                                         '

         CONTROL GET CHECK ghPage1, %FILE_CASE TO i               '
         CaseFlag = IIF$(i, "C", "T")                             '
         CONTROL GET CHECK ghPage1, %FILE_AUTOCAPS TO i           '
         AUTOCAPS = i                                             '
         CONTROL GET CHECK ghPage1, %FILE_STATEFLAG TO i          '
         StateFlag = i                                            '
         CONTROL GET TEXT ghPage1, %FILE_STATEFLAG TO lclText     '
         lclText = UCASE$(lclText)                                '
         IF lclText = "ON" THEN                                   '
            StateFlag = 1                                         '
         ELSEIF lclText = "OFF" THEN                              '
            StateFlag = 0                                         '
         ELSEIF lclText = "FEW" THEN                              '
            StateFlag = 2                                         '
         ELSE                                                     '
            StateFlag = 3                                         '
         END IF                                                   '
         CONTROL GET TEXT ghPage1, %FILE_CAPSDFLAG TO lclText     '
         lclText = UCASE$(lclText)                                '
         IF lclText = "ON" THEN                                   '
            CapsDesired = 1                                       '
         ELSEIF lclText = "OFF" THEN                              '
            CapsDesired = 0                                       '
         ELSE                                                     '
            CapsDesired = 2                                       '
         END IF                                                   '
         CapsActual = CapsDesired                                 '
         CONTROL GET TEXT ghPage1, %FILE_START TO lclText         '
         lclText = UCASE$(lclText)                                '
         Start = lclText                                          '
         CONTROL GET TEXT ghPage1, %FILE_SCRLAMTC TO lclText      '
         lclText = UCASE$(lclText)                                '
         IF lclText = "P" OR lclText = "PAGE" THEN                '
            SCROLLAmt = "PAGE"                                    '
         ELSEIF lclText = "F" OR lclText = "FULL" THEN            '
            SCROLLAmt = "FULL"                                    '
         ELSEIF lclText = "H" OR lclText = "HALF" THEN            '
            SCROLLAmt = "HALF"                                    '
         ELSEIF lclText = "D" OR lclText = "DATA" THEN            '
            SCROLLAmt = "DATA"                                    '
         ELSEIF lclText = "CSR" OR lclText = "C" OR lclText = "CUR" THEN   '
            SCROLLAmt = "CSR "                                    '
         ELSE                                                     '
            SCROLLAmt = lclText                                   '
         END IF                                                   '

         CONTROL GET TEXT ghPage1, %FILE_CmntID  TO LclW1         ' Get the COMMENTS values
         CONTROL GET TEXT ghPage1, %FILE_CmntCol  TO LclW2        '
         CONTROL GET TEXT ghPage1, %FILE_CmntIncr TO LclW3        '
         CONTROL GET TEXT ghPage1, %FILE_CmntEnd  TO LclText      '
         CmntID = VAL(LclW1)                                      ' Save them
         CmntCol = VAL(LclW2)                                     '
         CmntIncr = VAL(LclW3)                                    '
         CmntEnd = VAL(LclText)                                   '

         CONTROL GET CHECK ghPage2, %FILE_AUTOBKUP TO i           '
         AutoBkup = i                                             '
         CONTROL GET TEXT ghPage2, %FILE_PRESERVE TO lclText      '
         lclText = UCASE$(lclText)                                '
         IF lclText = "ON" THEN                                   '
            PreserveTyp = 1                                       '
         ELSEIF lclText = "OFF" THEN                              '
            PreserveTyp = 0                                       '
         ELSE                                                     '
            PreserveTyp = 2                                       '
         END IF                                                   '
         CONTROL GET TEXT ghPage2, %FILE_SOURCEFLAG TO LclText    '
         SourceName = UUCASE(LclText)                             ' Set as SOURCE
         CONTROL GET TEXT ghPage2, %FILE_COLLATE TO LclText       '
         CollateStr = UUCASE(LclText)                             ' COLLATE
         CONTROL GET CHECK ghPage2, %FILE_BOM TO i                '
         IF SourceName = "ANSI" THEN i = %False                   ' Correct BOM for ANSI
         BOM = i                                                  '
         CONTROL GET TEXT ghPage2, %FILE_AUTOSAVE TO lclText      ' Convert autosave
         lclText = UCASE$(lclText)                                '
         IF lclText = "OFF PROMPT" THEN                           ' OFF PROMPT
            AutoSave = 2                                          '
         ELSEIF lclText = "ON NOPROMPT" THEN                      ' ON NOPROMPT
            AutoSave = 1                                          '
         ELSEIF lclText = "ON PROMPT" THEN                        ' ON PROMPT
            AutoSave = 3                                          '
         ELSEIF lclText = "OFF NOPROMPT" THEN                     ' OFF NOPROMPT
            AutoSave = 0                                          '
         END IF                                                   '
         CONTROL GET TEXT ghPage2, %FILE_LRECL TO LclText         '
         LRECL = VAL(lclText)                                     '
         CONTROL GET TEXT ghPage2, %FILE_RECFM TO LclText         '
         RECFM = UCASE$(lclText)                                  '
         CONTROL GET TEXT ghPage2, %FILE_EOL TO lclText           '
         EOL = TRIM$(UCASE$(lcltext))                             '
         CONTROL GET TEXT ghPage2, %FILE_XTABS TO lclText         '
         ImportTabs = VAL(lclText)                                '
         CONTROL GET TEXT ghPage2, %FILE_MINLEN TO LclText        '
         MINLEN = VAL(lclText)                                    '
         CONTROL GET TEXT ghPage2, %FILE_CHANGE TO lclText        '
         lclText = UUCASE(lclText)                                '
         ChangeMode = IIF$(lclText = "DS", "D", "C")              '
         me.WriteAll(%True)                                       ' Save it all TRUE overrides LOCK
         me.BuildLines                                            ' Rebuild PROF lines
         METHOD = %False                                          ' We made it through
      END METHOD                                                  '

      METHOD Drive() AS STRING                                    '
      '--------------------------------------------------------------------------------------------+
      '- Return Drive                                                                              |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF$(MID$(FilePath, 2, 1) = ":", LEFT$(FilePath, 2), "") ' Extract drive if present
      END METHOD                                                  '

      METHOD EditProf() AS STRING                                 '
      '--------------------------------------------------------------------------------------------+
      '- Edit a Profile file                                                                       |
      '--------------------------------------------------------------------------------------------+
      REGISTER j AS LONG                                          '
         MEntry                                                   '
         me.DispProfile                                           ' Let user set things up
         IF gfDialogDone THEN                                     ' Was dialog cancelled
            METHOD = "Profile EDIT cancelled"                     ' Say so
            MExitMeth                                             '
         END IF                                                   '
         me.WriteAll(%True)                                       ' Save it (True = override LOCK to do it
         DoStatusBar($AllStatusBarBoxes)                          ' Pick up whatever changed
         METHOD = "Profile Saved"                                 '
         MExit                                                    ' Set focus
      END METHOD                                                  '

      GProp(EMacro, STRING)                                       '
      PROPERTY SET EMacro(v AS STRING)                            '
         EMacro = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "EMacro",  EMacro) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(EOL, STRING)                                          '
      PROPERTY SET EOL(v AS STRING)                               '
         EOL = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "EOLFlag", EOL) '
         EOLIX = SWITCH(EOL = "CRLF", 1, EOL = "LF", 2, EOL = "CR", 3, EOL = "NL", 4, EOL = "AUTO", 5, EOL = "AUTONL", 6, EOL = "NONE", 7)   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(EOLIX, LONG)                                         '

      METHOD EXTN() AS STRING                                     '
      '--------------------------------------------------------------------------------------------+
      '- Return Extn portion                                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         i = INSTR(-1, FilePath, ".")                             '
         METHOD = IIF$(i, MID$(FilePath, i), "")                  '
      END METHOD                                                  '

      METHOD File() AS STRING                                     '
      '--------------------------------------------------------------------------------------------+
      '- Return File portion                                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         i = INSTR(-1, FilePath, "\")                             '
         METHOD = IIF$(i, MID$(FilePath, i + 1), FilePath)        '
      END METHOD                                                  '

      gsProp(FilePath,    STRING)                                 '
      gsProp(FileRO,      BYTE)                                   '
      gsProp(FileSkip,    BYTE)                                   '
      gSProp(FNum,        LONG)                                   '

      METHOD GetCA2SPtr() AS LONG: METHOD = VARPTR(CA2S): END METHOD '
      METHOD GetCS2APtr() AS LONG: METHOD = VARPTR(CS2A): END METHOD '
      METHOD GetSA2SPtr() AS LONG: METHOD = VARPTR(SA2S): END METHOD '
      METHOD GetSS2APtr() AS LONG: METHOD = VARPTR(SS2A): END METHOD '

      GProp(GoodBnds, STRING)                                     '

      GProp(HexMode, LONG)                                        '
      PROPERTY SET HexMode(v AS LONG)                             '
         HexMode = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "HexMFlag", FORMAT$(HexMode)) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(HiAuto, LONG)                                         '
      PROPERTY SET HiAuto(v AS LONG)                              '
         HiAuto = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "HiAuto", FORMAT$(HiAuto))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(HiFind, LONG)                                         '
      PROPERTY SET HiFind(v AS LONG)                              '
         HiFind = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "HiFind",  FORMAT$(HiFind)) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '
      GSProp(HiFindSupp, LONG)                                    ' Suppress HiFind temporarily

      GProp(IMacro, STRING)                                       '
      PROPERTY SET IMacro(v AS STRING)                            '
         IF LEFT$(v, 1) = "%" THEN                                ' Don't save?
            IMacro = MID$(v, 2)                                   ' Just update IMacro
         ELSE                                                     '
            IMacro = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "IMacro",  IMacro) '
         END IF                                                   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(ImportTabs, LONG)                                     '
      PROPERTY SET ImportTabs(v AS LONG)                          '
         ImportTabs = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "ImportTabs", FORMAT$(ImportTabs))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(JustCreated, LONG)                                   ' Profile just created

      GProp(LockFlag, LONG)                                       '
      PROPERTY SET LockFlag(v AS LONG)                            '
         LockFlag = v                                             '
         IF v <> 2 THEN                                           ' Ignore EFT lock mode saving
            gSQL.UpdateStringDirect(ProfNameSQL, "ProfLock", FORMAT$(LockFlag))  '
         END IF                                                   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(LRECL, LONG)                                          '
      PROPERTY SET LRECL(v AS LONG)                               '
         LRECL = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "LRECL", FORMAT$(LRECL))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(Maclib, STRING)                                       '
      PROPERTY SET Maclib(v AS STRING)                            '
         Maclib = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Maclib", RTRIM$(Maclib))   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(MarkFlag, LONG)                                       '
      PROPERTY SET MarkFlag(v AS LONG)                            '
         MarkFlag = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "MarkFlag", FORMAT$(MarkFlag))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(MarkLine, STRING)                                     '
      PROPERTY SET MarkLine(v AS STRING)                          '
         MarkLine = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "MARK", RTRIM$(MarkLine)) '
         MarkWorking = NormalizeMark(MarkLine)                    '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(MarkWorking, STRING)                                 '

      GProp(MaskLine, STRING)                                     '
      PROPERTY SET MaskLine(v AS STRING)                          '
         MaskLine = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "MASK", RTRIM$(MaskLine)) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(MINLEN, LONG)                                         '
      PROPERTY SET MINLEN(v AS LONG)                              '
         MINLEN = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "MINLEN", FORMAT$(MINLEN))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(MODE, LONG)                                           '
      PROPERTY SET MODE(v AS LONG)                                '
         MODE = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Mode", FORMAT$(MODE))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(PageFlag, LONG)                                       '
      PROPERTY SET PageFlag(v AS LONG)                            '
         PageFlag = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Page", FORMAT$(PageFlag))   '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(PageOffset, LONG)                                     '
      PROPERTY SET PageOffset(v AS LONG)                          '
         PageOffset = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "PageOffset", FORMAT$(PageOffset))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      METHOD PATH() AS STRING                                     '
      '--------------------------------------------------------------------------------------------+
      '- Return Path portion                                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         i = INSTR(-1, FilePath, "\")                             '
         METHOD = IIF$(i, LEFT$(FilePath, i), GetDefaultFolder)   '
      END METHOD                                                  '

      GProp(PInclude, STRING)                                     '
      PROPERTY SET PInclude(v AS STRING)                          '
         PInclude = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "PInclude", PInclude)  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(PreserveTyp, LONG)                                    '
      PROPERTY SET PreserveTyp(v AS LONG)                         '
         PreserveTyp = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Preserve", FORMAT$(PreserveTyp))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GsProp(ProfName, STRING)                                    '
      GsProp(ProfNameSQL, STRING)                                 '

      GProp(RECFM, STRING)                                        '
      PROPERTY SET RECFM(v AS STRING)                             '
         RECFM = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "RECFM", RECFM)  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      METHOD RESET()                                              '
      REGISTER i AS LONG                                          '
      '--------------------------------------------------------------------------------------------+
      '- Reset all Profile variables to the Default                                                |
      '--------------------------------------------------------------------------------------------+

         gSQL.Execute("PRAGMA synchronous = OFF")                 ' To optimize things
         ActionSave  = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "Action",      "0")   '
         AutoBkup    = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "AutoBkup",    "0")   '
         AUTOCAPS    = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "AutoCaps",    "0")   '
         AutoName    = "$NONE$":  gSQL.UpdateStringDirect(ProfNameSQL, "AutoName",    "$NONE$") '
         AutoSave    = 2:         gSQL.UpdateStringDirect(ProfNameSQL, "AutoSave",    "2")   '
         BndLeft     = 1:         gSQL.UpdateStringDirect(ProfNameSQL, "BndL",        "1")   '
         BndRight    = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "BndR",        "0")   '
         me.BuildBndText                                          '
         BOM         = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "BOM",         "0")   '
         CapsActual  = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "CapsFlag",    "0")   '
         CapsDesired = CapsActual                                 '
         CaseFlag    = "T":       gSQL.UpdateStringDirect(ProfNameSQL, "Case",        "T")   '
         ChangeMode  = "D":       gSQL.UpdateStringDirect(ProfNameSQL, "Change",      "D")   '
         CmntID      = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "CmntID",      "0")   '
         CmntCol     = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "CmntCol",     "0")   '
         CmntIncr    = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "CmntIncr",    "0")   '
         CmntEnd     = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "CmntEnd",     "0")   '
         ColateXlate = %False                                     '
         Cols        = 1:         gSQL.UpdateStringDirect(ProfNameSQL, "ColsFlag",    "1")   '
         EMacro      = "":        gSQL.UpdateStringDirect(ProfNameSQL, "EMacro",      "") '
         EOL         = "CRLF":    gSQL.UpdateStringDirect(ProfNameSQL, "EOLFlag",     "CRLF")   '
         EOLIX       = SWITCH(EOL = "CRLF", 1, EOL = "LF", 2, EOL = "CR", 3, EOL = "NL", 4, EOL = "AUTO", 5, EOL = "AUTONL", 6, EOL = "NONE", 7)   '
         HexMode     = 1:         gSQL.UpdateStringDirect(ProfNameSQL, "HexMFlag",    "1")   '
         HiAuto      = 1:         gSQL.UpdateStringDirect(ProfNameSQL, "HiAuto",      "1")   '
         HiFind      = 1:         gSQL.UpdateStringDirect(ProfNameSQL, "HiFind",      "1")   '
         IMacro      = "":        gSQL.UpdateStringDirect(ProfNameSQL, "IMacro",      "") '
         ImportTabs  = 4:         gSQL.UpdateStringDirect(ProfNameSQL, "ImportTabs",  "4")   '
         LRECL       = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "LRECL",       "0")   '
         Maclib      = "":        gSQL.UpdateStringDirect(ProfNameSQL, "Maclib",      "") '
         MarkLine    = "":        gSQL.UpdateStringDirect(ProfNameSQL, "Mark",        "") '
         MarkWorking = NormalizeMark(MarkLine)                    '
         MarkFlag    = 1:         gSQL.UpdateStringDirect(ProfNameSQL, "MarkFlag",    "1")   '
         MaskLine    = "":        gSQL.UpdateStringDirect(ProfNameSQL, "Mask",        "") '
         MinLen      = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "MinLen",      "0")   '
         MODE        = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "Mode",        FORMAT$(%Edit)) '
         PageFlag    = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "Page",        "0")   '
         PageOffset  = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "PageOffset",  "0")   '
         ScrlPageSus = %False                                     '
         CollateStr  = "ANSI":    gSQL.UpdateStringDirect(ProfNameSQL, "Collate",     "ANSI")   '
         PInclude    = "":        gSQL.UpdateStringDirect(ProfNameSQL, "PInclude",    "") '
         PreserveTyp = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "Preserve",    "0")   '
         LockFlag    = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "ProfLock",    "0")   '
         RECFM       = "U":       gSQL.UpdateStringDirect(ProfNameSQL, "RECFM",       "U")   '
         ScrollAmt   = "CSR":     gSQL.UpdateStringDirect(ProfNameSQL, "ScrollAmount", "CSR")   '
         SourceName  = "ANSI":    gSQL.UpdateStringDirect(ProfNameSQL, "Source",      "ANSI")   '
         Skip        = %False                                     '
         SrceXlate   = %False                                     '
         Start       = "FIRST":   gSQL.UpdateStringDirect(ProfNameSQL, "Start",       "FIRST")  '
         StateFlag   = 0:         gSQL.UpdateStringDirect(ProfNameSQL, "StateFlag",   "0")   '
         SubInclude  = "$NONE$":  gSQL.UpdateStringDirect(ProfNameSQL, "SubInclude",  "$NONE$")   '
         SubArg      = "":        gSQL.UpdateStringDirect(ProfNameSQL, "SubArg",      "") '
         SubCmd      = "":        gSQL.UpdateStringDirect(ProfNameSQL, "SubCmd",      "") '
         Tabs        = 1:         gSQL.UpdateStringDirect(ProfNameSQL, "TabsFlag",    "1")   '
         TabsLine    = "":        gSQL.UpdateStringDirect(ProfNameSQL, "TabsLine",    "1")   '
         WordInput   = $Word:     gSQL.UpdateStringDirect(ProfNameSQL, "Word",        $Word) '
         XFormStr    = "":        gSQL.UpdateStringDirect(ProfNameSQL, "XForm",       "") '
         gSQL.Execute("PRAGMA synchronous = ON")                  ' Reset synchronous
         me.WordVal                                               '
         RESET SA2S, SS2A, CA2S, CS2A                             ' Reset strings before building
         FOR i = 0 TO 255                                         ' SOURCE ANSI to SOURCE table
            SA2S += CHR$(i)                                       '
            SS2A += CHR$(i)                                       '
            CA2S += CHR$(i)                                       '
            CS2A += CHR$(i)                                       '
         NEXT                                                     '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END METHOD                                                  '

      METHOD ROState() AS LONG                                    '
      '--------------------------------------------------------------------------------------------+
      '- Return READ ONLY status                                                                   |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF((FD.FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY, %True, %False) '
      END METHOD                                                  '

      GSProp(SA2S, STRING)                                        '

      GSProp(ScrlPageSus, LONG)                                   '

      GProp(SCROLLAmt, STRING)                                    '
      PROPERTY SET SCROLLAmt(v AS STRING)                         '
         SCROLLAmt = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "ScrollAmount", TRIM$(SCROLLAmt)) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      METHOD SetupFN(fname AS STRING, DoProf AS LONG, RCA AS RCArea) '
      '--------------------------------------------------------------------------------------------+
      '- Setup the FCB and maybe the Profile for a FCB                                             |
      '--------------------------------------------------------------------------------------------+
      LOCAL lclFN, PDiag AS STRING                                '
         FNum = FREEFILE                                          ' Get a file #
         FilePath = fname                                         ' Store filename
         IF FilePath = $New OR ISNULL(FilePath) THEN              ' New Empty? or Dummy
            ProfName = "DEFAULT": GOTO GoGetProfile               ' Skip file related stuff
         END IF                                                   '
         IF INSTR(FilePath, "\") = 0 THEN _                       ' If we have something with no path
            FilePath = GetDefaultFolder + FilePath                ' Add a path if it doesn't have one
         '-----------------------------------------------------------------------------------------+
         '- Resolve LNK type if needed                                                             |
         '-----------------------------------------------------------------------------------------+
         IF IsEQ(RIGHT$(FilePath, 4), ".LNK") THEN                ' Passed a LNK file?
            FilePath = GetRealNameFromLNK(FilePath)               ' Convert to a full path
            IF ISNULL(FilePath) THEN                              ' If null returned, we failed
               AnswerMeth(8, "Shortcut lookup failed")            ' Say why we failed
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Eliminate folders                                                                      |
         '-----------------------------------------------------------------------------------------+
         IF ISFOLDER(FilePath) THEN                               ' Is this a folder
            AnswerMeth(8, "Filename is a Folder, not a File")     ' Say some words
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Ensure it exists                                                                       |
         '-----------------------------------------------------------------------------------------+
         lclFN = PATHSCAN$(FULL, FilePath)                        ' Let PATHSCAN have a go
         IF ISNULL(lclFN) THEN                                    ' Returns null if not found
            AnswerMeth(8, "File does not exist")                  ' Say some words
         END IF                                                   '
         lclFN = DIR$(FilePath, TO FD)                            ' Get all the DIR info
         FileRO = IIF((FD.FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY, _  '
                  %True, %False)                                  ' Set RO state
         '-----------------------------------------------------------------------------------------+
         '- Determine and load Profile data                                                        |
         '-----------------------------------------------------------------------------------------+
         IF DoProf THEN                                           ' Load Prof as well?
            Profname = GetProfileForFile(FilePath, PDiag, %True, %False)   ' Get the Profile name (EFT,NotQuery)
            IF TP.EFTSkip THEN AnswerMeth(8, "Open skipped, User cancel or EFT profile lookup failed")   '
            GoGetProfile:                                         '
            ProfNameSQL = "P" + Profname                          ' Create the SQL name
            me.SetupProf(ProfName, RCA)                           ' Load entire Profile
            IF RCA.RC <> 0 THEN                                   ' Error?
               AnswerMeth(8, "Profile: " + ProfName + " load data failed") ' Say some words
            END IF                                                '
         END IF                                                   '
         AnswerMeth(0, "OK")                                      ' Say all is well
      END METHOD                                                  '

      METHOD SetupProf(PName AS STRING, RCA AS RCArea)            '
      '--------------------------------------------------------------------------------------------+
      '- Read all the Profile Data                                                                 |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, tt AS STRING, i, j AS LONG, CallAddr AS DWORD      '
      LOCAL SystemTimeArea AS SYSTEMTIME                          '
      LOCAL LastWriteTime AS both                                 '
         IF PName = "NONTEXT" THEN                                ' If somehow NONTEXT gets here
            ProfName = "DEFAULT": ProfNameSQL = "P" + Profname    ' Use DEFAULT
         ELSE                                                     '
            IF ISFALSE gSQL.TableExist("P" + ProfName) THEN _     ' Better exist
               AnswerMeth(8, "Profile: " + PName + " does not exist")   '
            ProfName = PName: ProfNameSQL = "P" + Profname        ' Establish the names
         END IF                                                   '

         GetSystemTime SystemTimeArea                             ' Get the current time
         SystemtimeToFileTime SystemTimeArea, LastWriteTime.lft   ' Put it in LastWriteTime

         '-----------------------------------------------------------------------------------------+
         '- Load all the variables now from the SQL Table                                          |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO UBOUND(KWTable()): KWTable(i).KWFlag = 0: NEXT i  ' Reset SEEN flag
         gSQL.SelBegin("select * FROM " + $DQ + ProfNameSQL + $DQ)   ' Ask for everything
         IF gSQL.SelFirst() THEN                                  ' Select the first
            DO                                                    ' Loop through them
               ARRAY SCAN KWTable(), FROM 1 TO 16, COLLATE UCASE, = LSET$(gSQL.SelGet("DBKey"), 16), TO i   ' Look for it
               IF i THEN                                          ' We have it
                  KWTable(i).KWFlag = 1                           ' Say we've seen it
                  IF KWTable(i).KWType = 0 THEN                   ' String value?
                     KWTable(i).KWAddr.@SVar = gSQL.SelGet("DBData") ' Yes, string, stuff it in
                  ELSE                                            ' Numeric?
                     KWTable(i).KWAddr.@LVar = VAL(gSQL.SelGet("DBData"))  ' Yes, a number, convert and stuff it in
                  END IF                                          '
               END IF                                             '
            LOOP WHILE gSQL.SelNext()                             '
         END IF                                                   '
         gSQL.SelEnd                                              ' Close the SQL request

         '-----------------------------------------------------------------------------------------+
         '- Now see if all items were loaded                                                       |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO UBOUND(KWTable())                           ' Look for unSEEN items
            IF KWTable(i).KWFlag = 0 THEN                         ' Got one
               gSQL.SetStringDirect(ProfNameSQL, UCASE$(TRIM$(KWTable(i).KWText)), RTRIM$(KWTable(i).KWDefault))  '
               IF KWTable(i).KWType = 0 THEN                      ' String value?
                  KWTable(i).KWAddr.@SVar = RTRIM$(KWTable(i).KWDefault)   ' Yes, string, stuff it in
               ELSE                                               ' Numeric?
                  KWTable(i).KWAddr.@LVar = VAL(KWTable(i).KWDefault)   ' Yes, a number, convert and stuff it in
               END IF                                             '
            END IF                                                '

         NEXT i                                                   '
         gSQL.UpdateStringDirect(ProfNameSQL, "LastAccess", TimePretty(LastWriteTime.lq)) ' Save Last Access time

         '-----------------------------------------------------------------------------------------+
         '- Apply EFT overrides if they're applicable                                              |
         '-----------------------------------------------------------------------------------------+
         IF TP.EFTOVCtr > 0 AND Profname = TP.EFTOVName THEN      ' Any overrides for this Profile?
            LockFlag = 2                                          ' Say EFT Locked
            FOR i = 1 TO TP.EFTOVCtr                              ' Send them as Primary commands
               t = TP.EFTOVListG(i)                               ' Get a command
               tt = GetNextWord(t, %Strip)                        ' Get the basic command name
               j = gPCmdT.GetCmdIX(tt)                            ' Get the command table index?
               TP.ErrMsgHigh = 0                                  ' Clear flag to start
               IF gPCmdT.IsEFTOK(j) = %True THEN                  ' Valid for EFT?
                  CallAddr = gPCmdT.GetEditCode(j)                ' Get Routine address
                  CALL DWORD CallAddr USING pCmdModel(tt + " " + t)  ' Call the routine
               END IF                                             '
               IF TP.ErrMsgHigh THEN                              ' An error?
                  MyMsgBox("EFT override Profile change failed:" + $CRLF + _  '
                           "Command: " + tt + " " + t + $CRLF + _ '
                           "Message: " + TP.ErrMsgTop, + _        '
                           %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "EFT Override Failed") '
                  TP.EFTSkip = %True                              ' Skip it
               END IF                                             '
            NEXT i                                                '
            TP.ErrMsgReset                                        ' Reset residual messages
            TP.PCommand = ""                                      '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Now 'touch up' some of the variables                                                   |
         '-----------------------------------------------------------------------------------------+
         IF TP.GPData1 = 0 THEN                                   ' No Data1 yet?
            TP.SPData1(3 + Cols)                                  ' Set it
            TP.SPDLines(TP.GPBottom - TP.GPData1 + 1)             ' And DLines
         END IF                                                   '
         ScrlPageSus = %False                                     '
         CapsDesired = CapsActual                                 '
         EOLIX       = SWITCH(EOL = "CRLF", 1, EOL = "LF", 2, EOL = "CR", 3, EOL = "NL", 4, EOL = "AUTO", 5, EOL = "AUTONL", 6, EOL = "NONE", 7)   '
         Start       = UCASE$(Start)                              '
         AutoSave    = AutoSave AND &H00000003                    ' Just the 2 low bits
         TP.WordInput = WordInput                                 ' Copy for TP VARPTR usage
         me.WordVal()                                             ' Process it into FCB.WordStr
         TP.TabsLine = TabsLine                                   ' Copy for TP VARPTR usage
         IF MarkLine = CHR$(34,34) THEN MarkLine = ""             ' Just a double quote
         TP.MarkLine = MarkLine                                   ' Copy for TP VARPTR usage
         MarkWorking = NormalizeMark(MarkLine)                    ' Setup working version
         IF MaskLine = CHR$(34,34) THEN MaskLine = ""             ' Just a double quote
         TP.MaskLine = MaskLine                                   ' Copy for TP VARPTR usage
         me.BuildBndText                                          ' Go build the BndText string
         TP.BndText = BndText                                     ' Copy for TP VARPTR usage
         me.BuildSourceXlate()                                    '
         TP.ActionCtr = ActionSave                                ' Init action counter
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
         TP.PicSetAll                                             ' Ensure WORD etc. are
         TP.PicInit                                               ' setup for Picture searches
         IF ISNULL(AutoName) THEN                                 ' Old style?
            AutoName = "$NONE$"                                   ' Set to NONE
            gSQL.SetStringDirect(ProfNameSQL, "AUTONAME", "$NONE$")  ' Save it Back
         END IF                                                   '
         AnswerMeth(0, "OK")                                      ' Say all is well
         TP.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, gENV.ScrWidth, "N", %True)
      END METHOD                                                  '

      GSProp(SKIP, LONG)                                          '

      GProp(SourceName, STRING)                                   '
      PROPERTY SET SourceName(v AS STRING)                        '
         SourceName = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Source", SourceName)   '
         me.BuildSourceXlate()                                    '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(SrceXlate, LONG)                                     '
      GSProp(SS2A, STRING)                                        '

      GProp(Start, STRING)                                        '
      PROPERTY SET Start(v AS STRING)                             '
         Start = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "Start", Start)  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(StateFlag, LONG)                                      '
      PROPERTY SET StateFlag(v AS LONG)                           '
         StateFlag = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "StateFlag", FORMAT$(StateFlag))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(SubInclude, STRING)                                    '
      PROPERTY SET SubInclude(v AS STRING)                         '
         SubInclude = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "SubInclude", SubInclude)  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(SubArg, STRING)                                       '
      PROPERTY SET SubArg(v AS STRING)                            '
         SubArg = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "SubArg", SubArg)  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(SubCmd, STRING)                                       '
      PROPERTY SET SubCmd(v AS STRING)                            '
         SubCmd = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "SubCmd", SubCmd)  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GSProp(TabFound, LONG)                                      '

      GProp(Tabs, LONG)                                           '
      PROPERTY SET Tabs(v AS LONG)                                '
         Tabs = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "TabsFlag", FORMAT$(Tabs)) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(TabBNDS, LONG)                                        '
      PROPERTY SET TabBNDS(v AS LONG)                             '
         TabBNDS = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "TabBNDS", FORMAT$(TabBNDS))  '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GProp(TabsLine, STRING)                                     '
      PROPERTY SET TabsLine(v AS STRING)                          '
         TabsLine = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "TABS", RTRIM$(TabsLine)) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      METHOD TIME() AS STRING                                     '
      '--------------------------------------------------------------------------------------------+
      '- Return Time                                                                               |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF$(FilePath <> $New, MID$(TimePretty(FD.LastWriteTime), 13, 8), "          ")  ' Save file time
      END METHOD                                                  '

      METHOD TimeDateRefresh()                                    '
      LOCAL lclFN AS STRING                                       '
         lclFN = DIR$(FilePath, TO FD)                            ' Re-load the FD data
      END METHOD                                                  '

      GProp(WordInput, STRING)                                    '
      PROPERTY SET WordInput(v AS STRING)                         '
         WordInput = v                                            '
         IF me.WordVal THEN EXIT PROPERTY                         '
         IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "WORD", WordInput) '
         me.BuildLines                                            ' Rebuild PROF1/2/3/4/5 lines
      END PROPERTY                                                '

      GsProp(WordStr, STRING)                                     '

      METHOD WordVal() AS LONG                                    '
      '--------------------------------------------------------------------------------------------+
      '- Maniplulate FCB.WordInput to FCB.WordStr                                                  |
      '--------------------------------------------------------------------------------------------+
      LOCAL tbl, MSG AS STRING                                    '
         MEntry                                                   '
         MSG = NormalizeCharMap(WordInput, tbl)                   ' Go process the WordInput string
         IF MSG <> "" THEN MErrExit(%eFail, MSG)                  ' If an error message returned, issue it and exit

         ChrUpper = $Upper                                        ' Set defaults
         ChrLower = $Lower                                        '
         ChrRegUpper = $RegUpper                                  '
         ChrRegLower = $RegLower                                  '

         IF ISFALSE gENV.ENGChars THEN                            ' Add the non-English ASCII national characters?
            IF INSTR(WordInput, "A-Z") THEN                       ' Uppercase A-Z
               tbl += $UpperNat                                   ' Add them
               ChrUpper = $Upper + $UpperNat                      ' Adjust UC char set
               ChrRegUpper = $RegUpper + $RegUpperNat             '
            END IF                                                '
            IF INSTR(WordInput, "a-z") THEN                       ' Lowercase A-Z
               tbl += $LowerNat                                   ' Add them
               ChrLower = $Lower + $LowerNat                      ' Adjust LC char set
               ChrRegLower = $RegLower + $RegLowerNat             ' Adjust LC char set
            END IF                                                '
         END IF                                                   '

         WordStr = tbl                                            ' Save the answer
         Mexit                                                    '
      END METHOD                                                  '

      METHOD WriteAll(force AS LONG)                              '
      '--------------------------------------------------------------------------------------------+
      '- Write the File Profile CFG values                                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, w, h        AS LONG, t AS STRING                   '
         MEntry                                                   '
         IF LockFlag AND ISFALSE force THEN MExitMeth             ' Don't do if Profile is Locked
         gSQL.Execute("PRAGMA synchronous = OFF")                 ' To optimize things
         gSQL.UpdateStringDirect(ProfNameSQL, "ProfLock",    FORMAT$(LockFlag))  ' Dump out the values
         gSQL.UpdateStringDirect(ProfNameSQL, "Action",      FORMAT$(ActionSave))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "AutoBkup",    FORMAT$(AutoBkup))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "AutoCaps",    FORMAT$(AUTOCAPS))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "AutoName",    AutoName)  '
         gSQL.UpdateStringDirect(ProfNameSQL, "AutoSave",    FORMAT$(AutoSave))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "BOM",         FORMAT$(BOM)) '
         gSQL.UpdateStringDirect(ProfNameSQL, "StateFlag",   FORMAT$(StateFlag)) '
         gSQL.UpdateStringDirect(ProfNameSQL, "SubInclude",  SubInclude) '
         gSQL.UpdateStringDirect(ProfNameSQL, "EMacro",      EMacro) '
         gSQL.UpdateStringDirect(ProfNameSQL, "Collate",     CollateStr)   '
         gSQL.UpdateStringDirect(ProfNameSQL, "CmntID",      FORMAT$(CmntID)) '
         gSQL.UpdateStringDirect(ProfNameSQL, "CmntCol",     FORMAT$(CmntCol))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "CmntIncr",    FORMAT$(CmntIncr))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "CmntEnd",     FORMAT$(CmntEnd))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "Source",      SourceName)   '
         gSQL.UpdateStringDirect(ProfNameSQL, "Case",        CaseFlag)  '
         gSQL.UpdateStringDirect(ProfNameSQL, "Preserve",    FORMAT$(PreserveTyp))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "TabsFlag",    FORMAT$(Tabs))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "MarkFlag",    FORMAT$(MarkFlag))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "CapsFlag",    FORMAT$(CapsDesired))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "HexMFlag",    FORMAT$(HexMode))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "HiFind",      FORMAT$(HiFind)) '
         gSQL.UpdateStringDirect(ProfNameSQL, "IMacro",      IMacro) '
         gSQL.UpdateStringDirect(ProfNameSQL, "HiAuto",      FORMAT$(HiAuto)) '
         gSQL.UpdateStringDirect(ProfNameSQL, "ImportTabs",  FORMAT$(ImportTabs))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "Maclib",      Maclib) '
         gSQL.UpdateStringDirect(ProfNameSQL, "MINLEN",      FORMAT$(MINLEN)) '
         gSQL.UpdateStringDirect(ProfNameSQL, "Mode",        FORMAT$(MODE))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "LRECL",       FORMAT$(LRECL))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "RECFM",       RECFM)  '
         gSQL.UpdateStringDirect(ProfNameSQL, "EOLFlag",     EOL) '
         gSQL.UpdateStringDirect(ProfNameSQL, "Change",      ChangeMode)   '
         gSQL.UpdateStringDirect(ProfNameSQL, "ColsFlag",    FORMAT$(Cols))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "ScrollAmount", TRIM$(ScrollAmt))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "Page",        FORMAT$(PageFlag))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "PageOffset",  FORMAT$(PageOffset))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "PInclude",    PInclude)  '
         gSQL.UpdateStringDirect(ProfNameSQL, "SubArg",      SubArg) '
         gSQL.UpdateStringDirect(ProfNameSQL, "SubCmd",      SubCmd) '
         gSQL.UpdateStringDirect(ProfNameSQL, "Start",       Start)  '
         gSQL.UpdateStringDirect(ProfNameSQL, "WORD",        WordInput) '
         gSQL.UpdateStringDirect(ProfNameSQL, "BndL",        FORMAT$(BndLeft))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "BndR",        FORMAT$(BndRight))  '
         gSQL.UpdateStringDirect(ProfNameSQL, "TABS",        RTRIM$(TabsLine))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "MARK",        RTRIM$(MarkLine))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "MASK",        RTRIM$(MaskLine))   '
         gSQL.UpdateStringDirect(ProfNameSQL, "XForm",       XFormStr)  '
         gSQL.Execute("PRAGMA synchronous = ON")                  ' To optimize things
         MExit                                                    '
      END METHOD                                                  '

      GProp(XFormStr, STRING)                                     '
      PROPERTY SET XFormStr(v AS STRING)                          '
         IF LEFT$(v, 1) = "/" THEN                                ' A no save request
            XFormStr = MID$(v, 2)                                 ' Just update XFormStr
         ELSE                                                     '
            XFormStr = v: IF ISFALSE LockFlag THEN gSQL.UpdateStringDirect(ProfNameSQL, "XForm",  XFormStr) '
            me.BuildLines                                         ' Rebuild PROF1/2/3/4/5 lines
         END IF                                                   '
      END PROPERTY                                                '

   END INTERFACE                                                  '

END CLASS                                                         '
