'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjKwd.inc                                                                                      |
'--------------------------------------------------------------------------------------------------+
                                                                  '
TYPE KwdEnt                                                       '
   NAME             AS STRINGZ * 20                               ' Kwd name
   TType            AS STRING * 1                                 ' Table type ("O", "P", "?")
   ColorType        AS STRING * 1                                 ' A Color value ("C" or " ")
   Flag             AS BYTE                                       ' Work Flag - True/False
   VType            AS STRING * 1                                 ' Value Type ("L", "S", or "R")
   ValidateIX       AS LONG                                       ' Index # of Validate routine
   VPointer         AS KWVar                                      ' PTR real data location
   ValidateStr      AS STRINGZ * 40                               ' Validation string
   DefaultStr       AS STRINGZ * 250                              ' Default value
END TYPE                                                          '

ENUM CPtrs SINGULAR                                               ' Indexes to validation routines
   V1Char        = 1                                              '
   VAny                                                           '
   VCommaNum                                                      '
   VDate                                                          '
   VEOL                                                           '
   VFileLine                                                      '
   VFMLayout                                                      '
   VInvChar                                                       '
   VKillQ                                                         '
   VList                                                          '
   VNumeric                                                       '
   VOnOff                                                         '
   VPerNum                                                        '
   VRange                                                         '
   VSBLayout                                                      '
   VTStamp                                                        '
END ENUM                                                          '

CLASS cKwd                                                        '
   INSTANCE K()        AS KwdEnt                                  ' Keyword table
   INSTANCE KCtr       AS LONG                                    ' # in table
   INSTANCE CPtrs()    AS DWORD                                   ' Validate routine pointers

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
      DIM CPtrs(1 TO 16)  AS INSTANCE DWORD                       ' DIM the tables
      DIM K(1 TO 401)     AS INSTANCE KwdEnt                      '
      me.KwdBuild                                                 ' Initial Kwd build
   END METHOD                                                     '

   CLASS METHOD KWEnt(kWord AS STRING, _                          ' Keyword
                      kTblType AS STRING, _                       ' Table type
                      kVerify AS LONG, _                          ' IX of verify routine
                      kColor AS STRING, _                         ' Entry is a color value
                      kVType AS STRING, _                         ' Data format of the variable
                      kValid AS STRING, _                         ' Validation data
                      kDefault AS STRING)                         ' Default value
      '--------------------------------------------------------------------------------------------------+
      '- Add a Keyword entry                                                                             |
      '--------------------------------------------------------------------------------------------------+
      INCR KCtr                                                   ' Bump count
      K(KCtr).Name        = kWord                                 ' Save values
      K(KCtr).TType       = kTblType                              '
      K(KCtr).ColorType   = kColor                                '
      K(KCtr).VType       = kVType                                '
      K(KCtr).ValidateIX  = kVerify                               '
      K(KCtr).ValidateStr = kValid                                '
      K(KCtr).DefaultStr  = kDefault                              '
   END METHOD                                                     '

   CLASS METHOD KwdBuild()                                        '
      '-----------------------------------------------------------------------------------------------+
      '- Build the Keyword Data table                                                                 |
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      '-----------------------------------------------------------------------------------------------+
      me.KWEnt("ABeepFlag",     "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("Action",        "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("AttnPos",       "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("AutoBkup",      "P", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("AutoCaps",      "P", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("AutoName",      "P", %VAny,      " ", "S", "",               "$NONE$") '
      me.KWEnt("AutoSave",      "P", %VList,     " ", "L", "0,1,2,3",        "2")   '
      me.KWEnt("AutoScrl",      "O", %VRange,    " ", "L", "0,99",           "2")   '
      me.KWEnt("Banding",       "O", %VOnOff,    "C", "L", "",               "0")   '
      me.KWEnt("BandingColor",  "O", %VNumeric,  "C", "L", "",               FORMAT$(%RGB_ANTIQUEWHITE)) '
      me.KWEnt("BandLines",     "O", %VOnOff,    "C", "L", "",               "0")   '
      me.KWEnt("BKPMaxGen",     "O", %VNumeric,  " ", "L", "",               "5")   '
      me.KWEnt("BKPMinGen",     "O", %VNumeric,  " ", "L", "",               "2")   '
      me.KWEnt("BKPRetention",  "O", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("BM",            "O", %VPerNum,   " ", "R", "",               "0.5") '
      me.KWEnt("BndL",          "P", %VNumeric,  " ", "L", "",               "1")   '
      me.KWEnt("BndR",          "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("BOM",           "P", %VOnOff,    " ", "L", "",               "0")   '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("BrowseWarn",    "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("Build",         "O", %VPerNum,   " ", "S", "",               "") '
      me.KWEnt("CapsFlag",      "P", %VList,     " ", "L", "0,1,2",          "0")   '
      me.KWEnt("Case",          "P", %VList,     " ", "S", "C,T",            "T")   '
      me.KWEnt("CDelFlag",      "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("Change",        "P", %VList,     " ", "S", "C,D",            "D")   '
      me.KWEnt("CharSet",       "O", %VAny,      " ", "S", "",               "*MISSING*") '
      me.KWEnt("cMarkLine",     "O", %VNumeric,  "C", "L", "",               "&HC0C098")  '
      me.KWEnt("CmdChr",        "O", %V1Char,    " ", "S", "",               ";")   '
      me.KWEnt("CMDFlags",      "O", %VAny,      " ", "S", "",               "/K")  '
      me.KWEnt("CmdHiLite",     "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("CmntCol",       "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("CmntEnd",       "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("CmntID",        "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("CmntIncr",      "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("Collate",       "P", %VAny,      " ", "S", "",               "ANSI")   '
      me.KWEnt("Color",         "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("ColsFlag",      "P", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("CursIns",       "O", %VNumeric,  " ", "L", "",               "100") '
      me.KWEnt("CursInsVert",   "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("CursNorm",      "O", %VNumeric,  " ", "L", "",               "20")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("CustomClr",     "O", %VCommaNum, "C", "S", "",               "0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0")   '
      me.KWEnt("CutNew",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DBConsoleX",    "O", %VNumeric,  " ", "L", "",               "100") '
      me.KWEnt("DBConsoleY",    "O", %VNumeric,  " ", "L", "",               "37")  '
      me.KWEnt("DefDataShift",  "O", %VNumeric,  " ", "L", "",               "2")   '
      me.KWEnt("DefDir1",       "O", %VAny,      " ", "S", "",               "C:\") '
      me.KWEnt("DefMask",       "O", %VAny,      " ", "S", "",               "*")   '
      me.KWEnt("Diff1Column",   "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffALB",       "O", %VNumeric,  " ", "L", "",               "1")   '
      me.KWEnt("DiffANX",       "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffARB",       "O", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("DiffAX",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffBLB",       "O", %VNumeric,  " ", "L", "",               "1")   '
      me.KWEnt("DiffBNX",       "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffBRB",       "O", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("DiffBX",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffMinMatch",  "O", %VRange,    " ", "L", "1,50",           "5")   '
      me.KWEnt("DiffNoCASE",    "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffNoComment", "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffNoMultB",   "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffNoSpace",   "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffNoTab",     "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffOnly",      "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("DiffUseFileB",  "O", %VOnOff,    " ", "L", "",               "0")   '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Duplex",        "O", %VList,     " ", "L", "1,2,3",          "1")   '
      me.KWEnt("EMacro",        "P", %VAny,      " ", "S", "",               "") '
      me.KWEnt("ENGChars",      "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("EOLFlag",       "P", %VEOL,      " ", "S", "",               "CRLF")   '
      me.KWEnt("FCenter",       "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("FileLineFmt",   "O", %VFileLine, " ", "S", "",               "LEFT")   '
      me.KWEnt("FileListNm",    "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("FindWord",      "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("FLeft",         "O", %VAny,      " ", "S", "",               "File DATE: ~d ~t")   '
      me.KWEnt("FMDateHiLite",  "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("FMDefMaster",   "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("FMHelpFlag",    "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("FMLayout",      "O", %VFMLayout, " ", "S", "",               "NAME(40),LWDATETIME,SIZESHORT")  '
      me.KWEnt("FMLayoutM",     "O", %VFMLayout, " ", "S", "",               "NAME(40),PRP1(12,L,Dimension)")  '
      me.KWEnt("FMLCmdWidth",   "O", %VRange,    " ", "L", "5,20",           "5")   '
      me.KWEnt("FMOpFlag",      "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("FMSortSimple",  "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("FontName",      "O", %VAny,      " ", "S", "",               "Fixedsys")  '
      me.KWEnt("FontPitch",     "O", %VPerNum,   " ", "L", "",               "14")  '
      me.KWEnt("FontStyle",     "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("Footers",       "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("FRight",        "O", %VAny,      " ", "S", "",               "Print DATE: ~K(ISODate) ~K(ISOTime)")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("GlueWith",      "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("HCenter",       "O", %VAny,      " ", "S", "",               "SPFLite")   '
      me.KWEnt("Headers",       "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("HelpIntro",     "O", %VList,     " ", "L", "0,1,2",          "0")   '
      me.KWEnt("HelpOpen",      "O", %VList,     " ", "L", "1,3",            "1")   '
      me.KWEnt("HexMFlag",      "P", %VList,     " ", "L", "1,4",            "1")   '
      me.KWEnt("HiAuto",        "P", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("HiFind",        "P", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("HLeft",         "O", %VAny,      " ", "S", "",               "~f.~x")  '
      me.KWEnt("HomeBkpName",   "O", %VAny,      " ", "S", "",               "DEFAULT")   '
      me.KWEnt("HomeData",      "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("HomeEFTName",   "O", %VAny,      " ", "S", "",               "DEFAULT")   '
      me.KWEnt("HomeFolder",    "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("HomeKbdName",   "O", %VAny,      " ", "S", "",               "DEFAULT")   '
      me.KWEnt("HomeRtrName",   "O", %VAny,      " ", "S", "",               "DEFAULT")   '
      me.KWEnt("HomeSetName",   "O", %VAny,      " ", "S", "",               "DEFAULT")   '
      me.KWEnt("HRight",        "O", %VAny,      " ", "S", "",               "Page ~#")   '
      me.KWEnt("HRuler",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("IMacro",        "P", %VAny,      " ", "S", "",               "") '
      me.KWEnt("ImportTabs",    "P", %VNumeric,  " ", "L", "",               "4")   '
      me.KWEnt("InsMode",       "O", %VOnOff,    " ", "L", "",               "0")   '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("InsReset",      "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("InvChar",       "O", %VInvChar,  " ", "S", "",               ".")   '
      me.KWEnt("JobNumber",     "O", %VNumeric,  " ", "L", "",               "1")   '
      me.KWEnt("KBHelp",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("KBScrollH",     "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("KBScrollV",     "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("LANG",          "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("LastAccess",    "?", %VTStamp,   " ", "S", "",               "") '
      me.KWEnt("LastScrX",      "O", %VNumeric,  " ", "L", "",               "5")   '
      me.KWEnt("LastScrY",      "O", %VNumeric,  " ", "L", "",               "5")   '
      me.KWEnt("LineRepeatMax", "O", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("LM",            "O", %VPerNum,   " ", "R", "",               "0.5") '
      me.KWEnt("LNoSize",       "O", %VRange,    " ", "L", "5,8",            "6")   '
      me.KWEnt("LRECL",         "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("MACLIB",        "P", %VAny,      " ", "S", "",               "") '
      me.KWEnt("MacName",       "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("MARK",          "P", %VKillQ,    " ", "S", "",               "") '
      me.KWEnt("MarkFlag",      "P", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("MASK",          "P", %VKillQ,    " ", "S", "",               "") '
      me.KWEnt("Maximized",     "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("Metric",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("MINLEN",        "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("MinRetrieve",   "O", %VNumeric,  " ", "L", "",               "3")   '
      me.KWEnt("MinToTray",     "O", %VOnOff,    " ", "L", "",               "0")   '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Mode",          "P", %VList,     " ", "L", "2,4,8",          "8")   '
      me.KWEnt("MRFList",       "O", %VAny,      " ", "S", "",               "") '
      me.KWEnt("Name",          "O", %VAny,      " ", "S", "",               "DEFAULT")   '
      me.KWEnt("Notify",        "O", %VList,     " ", "L", "0,1,2",          "2")   '
      me.KWEnt("Orient",        "O", %VList,     " ", "L", "1,2",            "1")   '
      me.KWEnt("Page",          "P", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("PageOffset",    "P", %VNumeric,  " ", "L", "",               "0")   '
      me.KWEnt("PanelMax",      "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("Paper",         "O", %VNumeric,  " ", "L", "",               "1")   '
      me.KWEnt("PBanding",      "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("PDotRaw",       "O", %VAny,      " ", "S", "",               "00-1F 7F 81 8D 8F 9D")  '
      me.KWEnt("PInclude",      "P", %VAny,      " ", "S", "",               "") '
      me.KWEnt("Pitch",         "O", %VPerNum,   " ", "S", "",               "10")  '
      me.KWEnt("Preserve",      "P", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("ProfLock",      "P", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("RecentCtr",     "O", %VNumeric,  " ", "L", "",               "30")  '
      me.KWEnt("RECFM",         "P", %VList,     " ", "S", "U,F,V,VBI,VLI",  "U")   '
      me.KWEnt("ResetU",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("RM",            "O", %VPerNum,   " ", "R", "",               "0.5") '
      me.KWEnt("ROpenLast",     "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("RUNFlags",      "O", %VAny,      " ", "S", "",               "/K")  '
      me.KWEnt("SBFactor",      "O", %VPerNum,   " ", "R", "",               "1.0") '
      me.KWEnt("SBLayout",      "O", %VSBLayout, " ", "S", "",               "MODE(15),LINNO(20),LINES(15),COLS(23),BNDS(20),INSOVR(4),CASE(4),CHANGE(3),STATE(3),MISC(25),SELECT(30),CAPS(9),SOURCE(8),EOL(7)")  '
      me.KWEnt("SchAliasAll",   "O", %VAny,      " ", "S", "",               "TxtLo,TxtHi,Scheme1,Scheme2,Scheme3,Scheme4,Scheme5,Scheme6,Scheme7,Scheme8,Scheme9,Scheme10,Scheme11,Scheme12,Scheme13,Scheme14")  '
      me.KWEnt("Scheme00BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme00BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme00FG",    "O", %VNumeric,  "C", "L", "",               "&HFF6464")  '
      me.KWEnt("Scheme01BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Scheme01BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme01FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme02BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme02BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme02FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme03BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme03BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme03FG",    "O", %VNumeric,  "C", "L", "",               "&H0054A8")  '
      me.KWEnt("Scheme04BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme04BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme04FG",    "O", %VNumeric,  "C", "L", "",               "&HFF0000")  '
      me.KWEnt("Scheme05BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme05BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme05FG",    "O", %VNumeric,  "C", "L", "",               "&H0000C4")  '
      me.KWEnt("Scheme06BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme06BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme06FG",    "O", %VNumeric,  "C", "L", "",               "&HCA00CA")  '
      me.KWEnt("Scheme07BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme07BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme07FG",    "O", %VNumeric,  "C", "L", "",               "&H008000")  '
      me.KWEnt("Scheme08BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme08BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme08FG",    "O", %VNumeric,  "C", "L", "",               "&H8E4491")  '
      me.KWEnt("Scheme09BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme09BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme09FG",    "O", %VNumeric,  "C", "L", "",               "&H0000F2")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Scheme10BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme10BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme10FG",    "O", %VNumeric,  "C", "L", "",               "&H00A000")  '
      me.KWEnt("Scheme11BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme11BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme11FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFF00")  '
      me.KWEnt("Scheme12BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme12BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme12FG",    "O", %VNumeric,  "C", "L", "",               "&H626262")  '
      me.KWEnt("Scheme13BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme13BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme13FG",    "O", %VNumeric,  "C", "L", "",               "&HF0F0F0")  '
      me.KWEnt("Scheme14BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme14BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme14FG",    "O", %VNumeric,  "C", "L", "",               "&H0057AE")  '
      me.KWEnt("Scheme15BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme15BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme15FG",    "O", %VNumeric,  "C", "L", "",               "&H00C4FF")  '
      me.KWEnt("Scheme16BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme16BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme16FG",    "O", %VNumeric,  "C", "L", "",               "&HA00000")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Scheme17BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme17BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme17FG",    "O", %VNumeric,  "C", "L", "",               "&HB5B5B5")  '
      me.KWEnt("Scheme18BG1",   "O", %VNumeric,  "C", "L", "",               "&H00FFFF")  '
      me.KWEnt("Scheme18BG2",   "O", %VNumeric,  "C", "L", "",               "&H00FFFF")  '
      me.KWEnt("Scheme18FG",    "O", %VNumeric,  "C", "L", "",               "&H0000FF")  '
      me.KWEnt("Scheme19BG1",   "O", %VNumeric,  "C", "L", "",               "&H00FFFF")  '
      me.KWEnt("Scheme19BG2",   "O", %VNumeric,  "C", "L", "",               "&H00FFFF")  '
      me.KWEnt("Scheme19FG",    "O", %VNumeric,  "C", "L", "",               "&HFF46A3")  '
      me.KWEnt("Scheme20BG1",   "O", %VNumeric,  "C", "L", "",               "&HEFEFEF")  '
      me.KWEnt("Scheme20BG2",   "O", %VNumeric,  "C", "L", "",               "&HEFEFEF")  '
      me.KWEnt("Scheme20FG",    "O", %VNumeric,  "C", "L", "",               "&H0000FF")  '
      me.KWEnt("Scheme21BG1",   "O", %VNumeric,  "C", "L", "",               "&HEFEFEF")  '
      me.KWEnt("Scheme21BG2",   "O", %VNumeric,  "C", "L", "",               "&HEFEFEF")  '
      me.KWEnt("Scheme21FG",    "O", %VNumeric,  "C", "L", "",               "&HFF46A3")  '
      me.KWEnt("Scheme22BG1",   "O", %VNumeric,  "C", "L", "",               "&HE1DFCE")  '
      me.KWEnt("Scheme22BG2",   "O", %VNumeric,  "C", "L", "",               "&HE1DFCE")  '
      me.KWEnt("Scheme22FG",    "O", %VNumeric,  "C", "L", "",               "&H757575")  '
      me.KWEnt("Scheme23BG1",   "O", %VNumeric,  "C", "L", "",               "&HE2E2E2")  '
      me.KWEnt("Scheme23BG2",   "O", %VNumeric,  "C", "L", "",               "&HE2E2E2")  '
      me.KWEnt("Scheme23FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme24BG1",   "O", %VNumeric,  "C", "L", "",               "&HA39D6B")  '
      me.KWEnt("Scheme24BG2",   "O", %VNumeric,  "C", "L", "",               "&HA39D6B")  '
      me.KWEnt("Scheme24FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme25BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme25BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme25FG",    "O", %VNumeric,  "C", "L", "",               "&H0000FF")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Scheme26BG1",   "O", %VNumeric,  "C", "L", "",               "&HC5C5C5")  '
      me.KWEnt("Scheme26BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme26FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme27BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme27BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme27FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme28BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme28BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme28FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme29BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme29BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme29FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme30BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme30BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme30FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme31BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme31BG2",   "O", %VNumeric,  "C", "L", "",               "&HD9FFD9")  '
      me.KWEnt("Scheme31FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme32BG1",   "O", %VNumeric,  "C", "L", "",               "&HFF0000")  '
      me.KWEnt("Scheme32BG2",   "O", %VNumeric,  "C", "L", "",               "&HFF0000")  '
      me.KWEnt("Scheme32FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme33BG1",   "O", %VNumeric,  "C", "L", "",               "&H649632")  '
      me.KWEnt("Scheme33BG2",   "O", %VNumeric,  "C", "L", "",               "&H649632")  '
      me.KWEnt("Scheme33FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Scheme34BG1",   "O", %VNumeric,  "C", "L", "",               "&H00FFFF")  '
      me.KWEnt("Scheme34BG2",   "O", %VNumeric,  "C", "L", "",               "&H00FFFF")  '
      me.KWEnt("Scheme34FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme35BG1",   "O", %VNumeric,  "C", "L", "",               "&H0000F0")  '
      me.KWEnt("Scheme35BG2",   "O", %VNumeric,  "C", "L", "",               "&H0000F0")  '
      me.KWEnt("Scheme35FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme36BG1",   "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme36BG2",   "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme36FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme37BG1",   "O", %VNumeric,  "C", "L", "",               "&HD20000")  '
      me.KWEnt("Scheme37BG2",   "O", %VNumeric,  "C", "L", "",               "&HD20000")  '
      me.KWEnt("Scheme37FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme38BG1",   "O", %VNumeric,  "C", "L", "",               "&HC8C800")  '
      me.KWEnt("Scheme38BG2",   "O", %VNumeric,  "C", "L", "",               "&HC8C800")  '
      me.KWEnt("Scheme38FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme39BG1",   "O", %VNumeric,  "C", "L", "",               "&H8B008B")  '
      me.KWEnt("Scheme39BG2",   "O", %VNumeric,  "C", "L", "",               "&H8B008B")  '
      me.KWEnt("Scheme39FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme40BG1",   "O", %VNumeric,  "C", "L", "",               "&H00B4FF")  '
      me.KWEnt("Scheme40BG2",   "O", %VNumeric,  "C", "L", "",               "&H00B4FF")  '
      me.KWEnt("Scheme40FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme41BG1",   "O", %VNumeric,  "C", "L", "",               "&HB4B4B4")  '
      me.KWEnt("Scheme41BG2",   "O", %VNumeric,  "C", "L", "",               "&HB4B4B4")  '
      me.KWEnt("Scheme41FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("Scheme42BG1",   "O", %VNumeric,  "C", "L", "",               "&H00FF00")  '
      me.KWEnt("Scheme42BG2",   "O", %VNumeric,  "C", "L", "",               "&H00FF00")  '
      me.KWEnt("Scheme42FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme43BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFF00")  '
      me.KWEnt("Scheme43BG2",   "O", %VNumeric,  "C", "L", "",               "&HFFFF00")  '
      me.KWEnt("Scheme43FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme44BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFC8FF")  '
      me.KWEnt("Scheme44BG2",   "O", %VNumeric,  "C", "L", "",               "&HFFC8FF")  '
      me.KWEnt("Scheme44FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("Scheme45BG1",   "O", %VNumeric,  "C", "L", "",               "&HFF00FF")  '
      me.KWEnt("Scheme45BG2",   "O", %VNumeric,  "C", "L", "",               "&HFF00FF")  '
      me.KWEnt("Scheme45FG",    "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme46BG1",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme46BG2",   "O", %VNumeric,  "C", "L", "",               "&HFFFFFF")  '
      me.KWEnt("Scheme46FG",    "O", %VNumeric,  "C", "L", "",               "&H000000")  '
      me.KWEnt("ScrHeight",     "O", %VNumeric,  " ", "L", "",               "43")  '
      me.KWEnt("ScrlAmtc",      "O", %VAny,      " ", "S", "",               "PAGE")   '
      me.KWEnt("ScrollAmount",  "P", %VAny,      " ", "S", "",               "CSR") '
      me.KWEnt("ScrPosition",   "O", %VCommaNum, " ", "S", "",               "") '
      me.KWEnt("ScrWidth",      "O", %VNumeric,  " ", "L", "",               "90")  '
      me.KWEnt("Source",        "P", %VAny,      " ", "S", "",               "ANSI")   '
      me.KWEnt("Splash",        "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("Start",         "P", %VList,     " ", "S", "FIRST,LAST,PRIOR,LABEL,NEW", "FIRST")  '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      me.KWEnt("StateFlag",     "P", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("Style",         "O", %VOnOff,    " ", "S", "",               "0")   '
      me.KWEnt("SubArg",        "P", %VAny,      " ", "S", "",               "") '
      me.KWEnt("SubCmd",        "P", %VAny,      " ", "S", "",               "") '
      me.KWEnt("SubmitCmd",     "O", %VAny,      " ", "S", "",               "SPFSUB.BAT ~S")   '
      me.KWEnt("SubmitInclCol", "O", %VNumeric,  " ", "L", "",               "1")   '
      me.KWEnt("SubmitInclKey", "O", %VAny,      " ", "S", "",               "#INCLUDE")  '
      me.KWEnt("TabBNDS",       "P", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("TABS",          "P", %VKillQ,    " ", "S", "",               "") '
      me.KWEnt("TabsFlag",      "P", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("TM",            "O", %VPerNum,   " ", "R", "",               "0.5") '
      me.KWEnt("UndoLevels",    "O", %VNumeric,  " ", "L", "",               "10")  '
      me.KWEnt("UniqFlag",      "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("UseRecycle",    "O", %VOnOff,    " ", "L", "",               "1")   '
      me.KWEnt("VBeepFlag",     "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("VRuler",        "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("VScrollBar",    "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("WarnNonText",   "O", %VOnOff,    " ", "L", "",               "0")   '
      me.KWEnt("WebCheck",      "O", %VList,     " ", "L", "0,7,30",         "0")   '
      me.KWEnt("WebLastDate",   "O", %VDate,     " ", "S", "",               "01-01-2023")   '
      me.KWEnt("WebLastVers",   "O", %VAny,      " ", "S", "",               "PgmVers")   '
      me.KWEnt("WORD",          "P", %VKillQ,    " ", "S", "",               "A-Z a-z 0-9")  '
      me.KWEnt("XFORM",         "P", %VAny,      " ", "S", "",               "") '
      '---------Keyword---------Tbl--VRoutine----Clr--Fmt--Validation Data---Default Value------------|
      REDIM PRESERVE K(1 TO KCtr) AS INSTANCE KwdEnt              ' Reduce UBOUND to actual #
      END METHOD                                                  '

   INTERFACE iKwd: INHERIT IUNKNOWN                               ' Define the interface

      GProp(KCtr, LONG)                                           ' Make available

      METHOD AddCPtr(ix AS LONG, cPtr AS DWORD)                   '
         CPtrs(ix) = cPtr                                         ' Create the CODEPTR
      END METHOD                                                  '

      METHOD GetCPtr(ix AS LONG) AS DWORD                         '
         METHOD = CPtrs(ix)                                       ' Pass back the CODEPTR
      END METHOD                                                  '

      METHOD GetByIX(KTbl AS KwdEnt, IX AS LONG) AS LONG          ' Return Entry for an IX
         IF IX > UBOUND(k()) THEN METHOD = 8: EXIT METHOD         ' Invalid IX, RC=8
         KTbl = k(IX)                                             ' Copy the whole entry
      END METHOD                                                  '

      METHOD SetFlag(IX AS LONG)                                  ' Set entry flag
         IF IX > UBOUND(k()) THEN EXIT METHOD                     ' Invalid IX, ignore it
         k(IX).Flag = %True                                       ' Set flag
      END METHOD                                                  '

      METHOD GetFlag(IX AS LONG) AS LONG                          ' Return Flag for an Entry
         IF IX > UBOUND(k()) THEN METHOD = %False: EXIT METHOD    ' Invalid IX, False
         METHOD = IIF(k(IX).Flag = 0, %False, %True)              ' Return T/F
      END METHOD                                                  '

      METHOD SetKwdPtr(KName AS STRING, KPtr AS DWORD)            ' Set address of a Kwd's data
      LOCAL IX AS LONG                                            '
         IX = ArraySearch(K, KName, CompareName)                  ' See if it's there
         IF IX = 0 THEN MSGBOX "Kwd Ptr Setting Failed"": EXIT METHOD   ' Not found, big Oops
         k(IX).VPointer.Avar = KPtr                               ' Save the address
      END METHOD                                                  '

      METHOD GetKwdPtr(KName AS STRING) AS DWORD                  ' Get address of a Kwd's data
      LOCAL IX AS LONG                                            '
         IX = ArraySearch(K, KName, CompareName)                  ' See if it's there
         IF IX = 0 THEN MSGBOX "Kwd Ptr Fetch Failed"": EXIT METHOD  ' Not found, big Oops
         METHOD = k(IX).VPointer.AVar                             ' Return the address
      END METHOD                                                  '

      METHOD GetIXByName(KName AS STRING) AS LONG                 ' Return IX Entry for a Kwd Name
         METHOD = ArraySearch(K, KName, CompareName)              ' See if it's there
      END METHOD                                                  '

      METHOD GetByName(KTbl AS KwdEnt, KName AS STRING) AS LONG   ' Return Entry for a Kwd Name
      LOCAL IX AS LONG                                            '
         IX = ArraySearch(K, KName, CompareName)                  ' See if it's there
         IF IX = 0 THEN METHOD = 8: EXIT METHOD                   ' Not found, RC=8
         KTbl = k(IX)                                             ' Copy the whole entry
      END METHOD                                                  '


   END INTERFACE                                                  '
END CLASS                                                         '
