'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjPrimT.inc                                                                                    |
'--------------------------------------------------------------------------------------------------+
                                                                  '
CLASS cPrimTable                                                  '

   '-----------------------------------------------------------------------------------------------+
   '- Primitive Data                                                                               |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE PrimCount         AS LONG                             ' Number of Primitives
   INSTANCE PrimTable()       AS iPrimitiveEntry                  ' Table
   INSTANCE PName()           AS STRING                           ' Primitive name list
   INSTANCE PrimitiveList()   AS STRING                           ' List for KEYMAP

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
   LOCAL i, j AS LONG                                             '
      DIM PName(1 TO 165) AS INSTANCE STRING                      ' Dim the Name table
      DIM PrimTable (1 TO 165) AS INSTANCE iPrimitiveEntry        ' Dim the Primitive data table

      '--------------------------------------------------------------------------------------------+
      '- DIM size for PName and PrimTable above must be as large as # of Me.InitPrim calls below   |
      '--------------------------------------------------------------------------------------------+

                                                                  '                 Primitive           OKBrowse          Normal Edit               FM Screen                  PowerType
      Me.InitPrim("(BackSpace)",        %True,  CODEPTR(krBS),            CODEPTR(FMkbBackSpace),    CODEPTR(PTBS))  '
      Me.InitPrim("(BackTab)",          %True,  CODEPTR(krBackTab),       CODEPTR(FMkbBackTab),      CODEPTR(PTBackTab))   '
      Me.InitPrim("(BlockPaste)",       %False, CODEPTR(krBPaste),        0,                         0)  '
      Me.InitPrim("(Browse)",           %True,  CODEPTR(krBrowse),        0,                         0)  '
      Me.InitPrim("(CharSet)",          %True,  CODEPTR(krANSI),          CODEPTR(krANSI),           CODEPTR(krANSI))   '
      Me.InitPrim("(CharSetCol)",       %True,  CODEPTR(krANSIcol),       CODEPTR(krANSIcol),        CODEPTR(krANSIcol))   '
      Me.InitPrim("(ClearInsert)",      %True,  CODEPTR(krClearInsert),   CODEPTR(krClearInsert),    CODEPTR(krClearInsert))  '
      Me.InitPrim("(ClipClear)",        %True,  CODEPTR(krClipClear),     CODEPTR(krClipClear),      CODEPTR(krClipClear)) '
      Me.InitPrim("(ClipDate)",         %True,  CODEPTR(krClipDate),      CODEPTR(krClipDate),       CODEPTR(krClipDate))  '
      Me.InitPrim("(ClipISODate)",      %True,  CODEPTR(krClipISODate),   CODEPTR(krClipISODate),    CODEPTR(krClipISODate))  '
      Me.InitPrim("(ClipISOTime)",      %True,  CODEPTR(krClipISOTime),   CODEPTR(krClipISOTime),    CODEPTR(krClipISOTime))  '
      Me.InitPrim("(ClipName)",         %True,  CODEPTR(krClipName),      CODEPTR(FMkbClipName),     CODEPTR(krClipName))  '
      Me.InitPrim("(ClipPath)",         %True,  CODEPTR(krClipPath),      CODEPTR(FMkbClipPath),     CODEPTR(krClipPath))  '
      Me.InitPrim("(ClipTime)",         %True,  CODEPTR(krClipTime),      CODEPTR(krClipTime),       CODEPTR(krClipTime))  '
      Me.InitPrim("(CMarkDown)",        %True,  CODEPTR(krMarkcD),        CODEPTR(krMarkcD),         0)  '
      Me.InitPrim("(CMarkLeft)",        %True,  CODEPTR(krMarkcL),        CODEPTR(krMarkcL),         CODEPTR(PTMarkcL)) '
      Me.InitPrim("(CMarkRight)",       %True,  CODEPTR(krMarkcR),        CODEPTR(krMarkcR),         CODEPTR(PTMarkcR)) '
      Me.InitPrim("(CMarkUp)",          %True,  CODEPTR(krMarkcU),        CODEPTR(krMarkcU),         0)  '
      Me.InitPrim("(CmdHome)",          %True,  CODEPTR(krCmdHome),       CODEPTR(FMkbCmdHome),      0)  '
      Me.InitPrim("(CmdLog)",           %True,  CODEPTR(krCmdLog),        CODEPTR(krCmdLog),         CODEPTR(krCmdLog)) '
      Me.InitPrim("(CmdPad)",           %True,  CODEPTR(krCmdPad),        CODEPTR(krCmdPad),         CODEPTR(krCmdPad)) '
      Me.InitPrim("(Column)",           %True,  CODEPTR(krColumn),        0,                         0)  '
      Me.InitPrim("(CondLineNo)",       %True,  CODEPTR(krCondLineNo),    CODEPTR(FMkbLineNo),       0)  '
      Me.InitPrim("(Comments)",         %False, CODEPTR(krComments),      0,                         0)  '
                                                                  '                 Primitive           OKBrowse          Normal Edit               FM Screen                  PowerType
      Me.InitPrim("(Copy)",             %True,  CODEPTR(krKCpy),          CODEPTR(krKCpy),           CODEPTR(krKCpy))   '
      Me.InitPrim("(CopyAdd)",          %True,  CODEPTR(krKCpyAdd),       0,                         CODEPTR(krKCpyAdd))   '
      Me.InitPrim("(CopyLCmd)",         %True,  CODEPTR(krCopyLCmd),      CODEPTR(FMkbCopyLCmd),     CODEPTR(krCopyLCmd))  '
      Me.InitPrim("(CopyPaste)",        %True,  CODEPTR(krCopyPaste),     CODEPTR(krCopyPaste),      CODEPTR(PTCopyPaste)) '
      Me.InitPrim("(CopyPasteAdd)",     %True,  CODEPTR(krCopyPasteAdd),  0,                         CODEPTR(PTCopyPasteAdd)) '
      Me.InitPrim("(CopyPasteRaw)",     %True,  CODEPTR(krCopyPasteRaw),  0,                         CODEPTR(PTCopyPasteRaw)) '
      Me.InitPrim("(CopyRaw)",          %True,  CODEPTR(krKCpyRaw),       0,                         CODEPTR(krKCpyRaw))   '
      Me.InitPrim("(Cut)",              %False, CODEPTR(krKCut),          CODEPTR(krKCut),           CODEPTR(PTCut)) '
      Me.InitPrim("(DataBackspace)",    %False, CODEPTR(krDataBackSpace), CODEPTR(krDataBackSpace),  CODEPTR(PTDataBackspace))   '
      Me.InitPrim("(DataDelete)",       %False, CODEPTR(krDataDelete),    CODEPTR(krDataDelete),     CODEPTR(PTDataDelete))   '
      Me.InitPrim("(DataDeleteMark)",   %False, CODEPTR(krDataDeleteMark),CODEPTR(krDataDeleteMark), 0)  '
      Me.InitPrim("(DataInsert)",       %False, CODEPTR(krDataInsert),    CODEPTR(krDataInsert),     CODEPTR(krDataInsert))   '
      Me.InitPrim("(Date)",             %False, CODEPTR(krDate),          0,                         CODEPTR(PTDate))   '
      Me.InitPrim("(Delete)",           %True,  CODEPTR(krDel),           CODEPTR(FMkbDelete),       CODEPTR(PTDel)) '
      Me.InitPrim("(DeleteMark)",       %True,  CODEPTR(krDeleteMark),    0,                         0)  '
      Me.InitPrim("(Down)",             %True,  CODEPTR(krDown),          CODEPTR(FMkbDown),         0)  '
      Me.InitPrim("(Dup)",              %False, CODEPTR(krDup),           0,                         CODEPTR(PTDup)) '
      Me.InitPrim("(Edit)",             %True,  CODEPTR(krEdit),          0,                         0)  '
      Me.InitPrim("(EndOfLine)",        %True,  CODEPTR(krEndLine),       CODEPTR(FMkbEndOfLine),    CODEPTR(krEndLine))   '
      Me.InitPrim("(EndOfText)",        %True,  CODEPTR(krEndText),       CODEPTR(FMkbEndOfText),    CODEPTR(krEndText))   '
      Me.InitPrim("(Enter)",            %True,  CODEPTR(krEnter),         CODEPTR(FMkbEnter),        CODEPTR(PTEnter))  '
      Me.InitPrim("(Enum)",             %False, CODEPTR(krEnumD),         0,                         CODEPTR(PTEnumD))  '
      Me.InitPrim("(EnumHexLC)",        %False, CODEPTR(krEnumL),         0,                         CODEPTR(PTEnumL))  '
      Me.InitPrim("(EnumHexUC)",        %False, CODEPTR(krEnumU),         0,                         CODEPTR(PTEnumU))  '
      Me.InitPrim("(Erase)",            %False, CODEPTR(krErase),         0,                         CODEPTR(PTErase))  '
      Me.InitPrim("(EraseEOL)",         %True,  CODEPTR(krEOL),           CODEPTR(FMkbEraseEOL),     CODEPTR(PTEOL)) '
      Me.InitPrim("(FindNext)",         %True,  CODEPTR(krFindNext),      0,                         0)  '
      Me.InitPrim("(FindPrev)",         %True,  CODEPTR(krFindPrev),      0,                         0)  '
      Me.InitPrim("(FirstLineCmd)",     %True,  CODEPTR(krFirstLCmd),     CODEPTR(FMkbFirstLCmd),    0)  '
      Me.InitPrim("(FMBack)",           %False, 0,                        CODEPTR(FMkbFMBack),       0)  '
      Me.InitPrim("(FMFwd)",            %False, 0,                        CODEPTR(FMkbFMFwd),        0)  '
                                                                  '                 Primitive           OKBrowse          Normal Edit               FM Screen                  PowerType
      Me.InitPrim("(Home)",             %True,  CODEPTR(krHome),          CODEPTR(FMkbHome),         0)  '
      Me.InitPrim("(Insert)",           %True,  CODEPTR(krInsert),        CODEPTR(krInsert),         CODEPTR(krInsert)) '
      Me.InitPrim("(ISODate)",          %False, CODEPTR(krISODate),       0,                         CODEPTR(PTISODate))   '
      Me.InitPrim("(ISOTime)",          %False, CODEPTR(krISOTime),       0,                         CODEPTR(PTISOTime))   '
      Me.InitPrim("(JustifyC)",         %False, CODEPTR(krJustify),       0,                         CODEPTR(PTJustify))   '
      Me.InitPrim("(JustifyL)",         %False, CODEPTR(krJustify),       0,                         CODEPTR(PTJustify))   '
      Me.InitPrim("(JustifyL)",         %False, CODEPTR(krJustify),       0,                         CODEPTR(PTJustify))   '
      Me.InitPrim("(JustifyR)",         %False, CODEPTR(krJustify),       0,                         CODEPTR(PTJustify))   '
      Me.InitPrim("(SET0)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET1)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET2)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET3)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET4)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET5)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET6)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET7)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET8)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SET9)",             %True,  1,                        1,                         1)  '
      Me.InitPrim("(SpellChk)",         %False, CODEPTR(krSpellChk),      0,                         0)  '
      Me.InitPrim("(LastTab)",          %True,  CODEPTR(krLastTab),       0,                         CODEPTR(PTLastTab))   '
      Me.InitPrim("(Left)",             %True,  CODEPTR(krLeft),          CODEPTR(FMkbLeft),         CODEPTR(PTLeft))   '
      Me.InitPrim("(Lift)",             %True,  CODEPTR(krLift),          CODEPTR(krLift),           CODEPTR(PTLift))   '
      Me.InitPrim("(LineNo)",           %True,  CODEPTR(krLineNo),        CODEPTR(FMkbLineNo),       0)  '
      Me.InitPrim("(LowerCase)",        %False, CODEPTR(krLowerCase),     0,                         CODEPTR(PTLowerCase)) '
      Me.InitPrim("(MarkDown)",         %True,  CODEPTR(krMarkD),         CODEPTR(krMarkD),          0)  '
      Me.InitPrim("(MarkEnd)",          %True,  CODEPTR(krMarkE),         CODEPTR(krMarkE),          CODEPTR(PTMarkE))  '
      Me.InitPrim("(MarkLeft)",         %True,  CODEPTR(krMarkL),         CODEPTR(krMarkL),          CODEPTR(PTMarkL))  '
      Me.InitPrim("(MarkRight)",        %True,  CODEPTR(krMarkR),         CODEPTR(krMarkR),          CODEPTR(PTMarkR))  '
      Me.InitPrim("(MarkUp)",           %True,  CODEPTR(krMarkU),         CODEPTR(krMarkU),          0)  '
      Me.InitPrim("(MEditList)",        %False, CODEPTR(krMEditList),     0,                         0)  '
      Me.InitPrim("(NewLine)",          %True,  CODEPTR(krNewLine),       CODEPTR(FMkbNewLine),      0)  '
      Me.InitPrim("(NewLineNS)",        %True,  CODEPTR(krNewLineNS),     CODEPTR(FMkbNewLine),      0)  '
      Me.InitPrim("(Null)",             %True,  0,                        0,                         0)  '
                                                                  '                 Primitive           OKBrowse          Normal Edit               FM Screen                  PowerType
      Me.InitPrim("(PA1)",              %True,  CODEPTR(krPA2),           CODEPTR(krPA2),            CODEPTR(krPA2)) '
      Me.InitPrim("(PA2)",              %True,  CODEPTR(krPA2),           CODEPTR(krPA2),            CODEPTR(krPA2)) '
      Me.InitPrim("(PanelH)",           %True,  CODEPTR(krPanelH),        0,                         0)  '
      Me.InitPrim("(PanelOff)",         %True,  CODEPTR(krPanelOff),      0,                         0)  '
      Me.InitPrim("(PanelSwap)",        %True,  CODEPTR(krPanelSwap),     0,                         0)  '
      Me.InitPrim("(PanelV)",           %True,  CODEPTR(krPanelV),        0,                         0)  '
      Me.InitPrim("(PassThru)",         %True,  0,                        0,                         0)  '
      Me.InitPrim("(Paste)",            %True,  CODEPTR(krPaste),         CODEPTR(FMkbPaste),        CODEPTR(PTPaste))  '
      Me.InitPrim("(Pen)",              %True,  CODEPTR(krPen),           0,                         CODEPTR(PTPenCommon)) '
      Me.InitPrim("(PenBlue)",          %True,  CODEPTR(krPenBlue),       0,                         CODEPTR(PTPenBlue))   '
      Me.InitPrim("(PenGreen)",         %True,  CODEPTR(krPenGreen),      0,                         CODEPTR(PTPenGreen))  '
      Me.InitPrim("(PenRed)",           %True,  CODEPTR(krPenRed),        0,                         CODEPTR(PTPenRed)) '
      Me.InitPrim("(PenYellow)",        %True,  CODEPTR(krPenYellow),     0,                         CODEPTR(PTPenYellow)) '
      Me.InitPrim("(PenStd)",           %True,  CODEPTR(krPenStd),        0,                         CODEPTR(PTPenStd)) '
      Me.InitPrim("(PowerCopy)",        %False, 0,                        0,                         CODEPTR(PTPowerCopy)) '
      Me.InitPrim("(PowerCut)",         %False, 0,                        0,                         CODEPTR(PTPowerCut))  '
      Me.InitPrim("(PowerPaste)",       %False, 0,                        0,                         CODEPTR(PTPowerPaste))   '
      Me.InitPrim("(PrtScrnClipboard)", %True,  CODEPTR(ScreenPrint),     CODEPTR(ScreenPrint),      0)  '
      Me.InitPrim("(PrtScrnLog)",       %True,  CODEPTR(ScreenPrint),     CODEPTR(ScreenPrint),      0)  '
      Me.InitPrim("(PrtScrnPrinter)",   %True,  CODEPTR(ScreenPrint),     CODEPTR(ScreenPrint),      0)  '
      Me.InitPrim("(PrtTextClipboard)", %True,  CODEPTR(ScreenPrint),     CODEPTR(ScreenPrint),      0)  '
      Me.InitPrim("(Record)",           %True,  CODEPTR(krRecord),        CODEPTR(krRecord),         CODEPTR(krRecord)) '
      Me.InitPrim("(Refresh)",          %False, 0,                        CODEPTR(FMkbRefresh),      0)  '
      Me.InitPrim("(ResetCmd)",         %True,  CODEPTR(krResetCmd),      0,                         0)  '
      Me.InitPrim("(ResetInsert)",      %True,  CODEPTR(krSetOVR),        CODEPTR(krSetOVR),         CODEPTR(krSetOVR)) '
      Me.InitPrim("(RestoreCursor)",    %True,  CODEPTR(krRestoreCursor), 0,                         CODEPTR(krRestoreCursor))   '
      Me.InitPrim("(RestoreInsert)",    %True,  CODEPTR(krRestoreInsert), CODEPTR(krRestoreInsert),  CODEPTR(krRestoreInsert))   '
                                                                  '                 Primitive           OKBrowse          Normal Edit               FM Screen                  PowerType
      Me.InitPrim("(Right)",            %True,  CODEPTR(krRight),         CODEPTR(FMkbRight),        CODEPTR(PTRight))  '
      Me.InitPrim("(SaveCursor)",       %True,  CODEPTR(krSaveCursor),    0,                         CODEPTR(krSaveCursor))   '
      Me.InitPrim("(ScrollDown)",       %True,  CODEPTR(krScrollD),       CODEPTR(krScrollD),        0)  '
      Me.InitPrim("(ScrollLeft)",       %True,  CODEPTR(krScrollL),       0,                         CODEPTR(krScrollL))   '
      Me.InitPrim("(ScrollRight)",      %True,  CODEPTR(krScrollR),       0,                         CODEPTR(krScrollR))   '
      Me.InitPrim("(ScrollUp)",         %True,  CODEPTR(krScrollU),       CODEPTR(krScrollU),        0)  '
      Me.InitPrim("(SentenceCase)",     %False, CODEPTR(krSentenceCase),  0,                         CODEPTR(PTSentenceCase)) '
      Me.InitPrim("(SetInsert)",        %True,  CODEPTR(krSetINS),        CODEPTR(krSetINS),         CODEPTR(krSetINS)) '
      Me.InitPrim("(SetDIN)",           %True,  CODEPTR(krSetDIN),        CODEPTR(krSetDIN),         CODEPTR(krSetDIN)) '
      Me.InitPrim("(SetINS)",           %True,  CODEPTR(krSetINS),        CODEPTR(krSetINS),         CODEPTR(krSetINS)) '
      Me.InitPrim("(SetOVR)",           %True,  CODEPTR(krSetOVR),        CODEPTR(krSetOVR),         CODEPTR(krSetOVR)) '
      Me.InitPrim("(Swap)",             %False, CODEPTR(krSwap),          0,                         CODEPTR(PTSwap))   '
      Me.InitPrim("(Tab)",              %True,  CODEPTR(krTab),           CODEPTR(FMkbTab),          CODEPTR(PTTab)) '
      Me.InitPrim("(TabBNDS)",          %False, CODEPTR(krTabBNDS),       0,                         0)  '
      Me.InitPrim("(TabRelease)",       %False, CODEPTR(krTabRelease),    0,                         0)  '
      Me.InitPrim("(TabShift)",         %False, CODEPTR(krTabShift),      0,                         0)  '
      Me.InitPrim("(Time)",             %False, CODEPTR(krTime),          0,                         CODEPTR(PTTime))   '
      Me.InitPrim("(TitleCase)",        %False, CODEPTR(krTitleCase),     0,                         CODEPTR(PTTitleCase)) '
      Me.InitPrim("(ToggleHome)",       %True,  CODEPTR(krToggleHome),    0,                         CODEPTR(krToggleHome))   '
      Me.InitPrim("(ToggleSelect)",     %True,  CODEPTR(krToggleSelect),  0,                         0)  '
      Me.InitPrim("(Track)",            %True,  CODEPTR(krTrkBack),       CODEPTR(krTrkBack),        0)  '
      Me.InitPrim("(TrackF)",           %True,  CODEPTR(krTrkFwd),        CODEPTR(krTrkFwd),         0)  '
      Me.InitPrim("(TrackC)",           %True,  CODEPTR(krTrkC),          CODEPTR(krTrkC),           0)  '
      Me.InitPrim("(TxtHome)",          %True,  CODEPTR(krTxtHome),       0,                         CODEPTR(krTxtHome))   '
      Me.InitPrim("(TxtNewLine)",       %True,  CODEPTR(krTxtNewLine),    0,                         0)  '
      Me.InitPrim("(TxtNewLineNS)",     %True,  CODEPTR(krTxtNewLineNS),  0,                         0)  '
      Me.InitPrim("(Up)",               %True,  CODEPTR(krUp),            CODEPTR(FMkbUp),           0)  '
      Me.InitPrim("(UpperCase)",        %False, CODEPTR(krUpperCase),     0,                         CODEPTR(PTUpperCase)) '
      Me.InitPrim("(View)",             %True,  CODEPTR(krView),          0,                         0)  '
      Me.InitPrim("(VPanel)",           %True,  CODEPTR(krPanelV),        0,                         0)  '
      Me.InitPrim("(WordLeft)",         %True,  CODEPTR(krCtlLeft),       0,                         CODEPTR(PTCtlLeft))   '
      Me.InitPrim("(WordRight)",        %True,  CODEPTR(krCtlRight),      0,                         CODEPTR(PTCtlRight))  '
                                                                  '                 Primitive           OKBrowse          Normal Edit               FM Screen                  PowerType
      DIM gPrimTable(PrimCount - 2) AS STRING                     ' Hint list for KeyMap - deprecated(3)
      gPrimTable(0) = " Valid keyboard Primitives"                ' Insert heading
      FOR i = 1 TO PrimCount                                      ' Build the KEYMAP list
         IF PName(i) <> "ResetInsert" AND _                       ' Filter out deprecated
            PName(i) <> "SetInsert" AND _                         '
            PName(i) <> "ResetInsert" THEN                        '
            INCR j                                                '
            gPrimTable(j) = "(" + PName(i) + ")"                  '
         END IF                                                   '
      NEXT i                                                      '
      ARRAY SORT gPrimTable(0) FOR PrimCount + 1 - 3              ' Sort the primitive table

   END METHOD                                                     '

   INTERFACE iPrimTable: INHERIT IUNKNOWN                         ' Define the interface


      METHOD GetPrimIX(Cmd AS STRING) AS LONG                     '
      '--------------------------------------------------------------------------------------------+
      '- Validate Primitive name and return Index (0 if invalid)                                   |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
         ARRAY SCAN PName() FOR PrimCount, COLLATE UCASE, =Cmd, TO i '
         METHOD = i                                               ' Return ARRAY SCAN result
      END METHOD                                                  '

      METHOD BrowseOK(IX AS LONG) AS LONG                         '
      '--------------------------------------------------------------------------------------------+
      '- Return BrowseOK                                                                           |
      '--------------------------------------------------------------------------------------------+
         METHOD = PrimTable(ix).BrowseOK                          ' Pass back flag
      END METHOD                                                  '

      METHOD FPath(IX AS LONG) AS LONG                            '
      '--------------------------------------------------------------------------------------------+
      '- Return FPath                                                                              |
      '--------------------------------------------------------------------------------------------+
         METHOD = PrimTable(ix).FPath                             ' Pass back address
      END METHOD                                                  '

      METHOD NPath(IX AS LONG) AS LONG                            '
      '--------------------------------------------------------------------------------------------+
      '- Return NPath                                                                              |
      '--------------------------------------------------------------------------------------------+
         METHOD = PrimTable(ix).NPath                             ' Pass back address
      END METHOD                                                  '

      METHOD PPath(IX AS LONG) AS LONG                            '
      '--------------------------------------------------------------------------------------------+
      '- Return PPath                                                                              |
      '--------------------------------------------------------------------------------------------+
         METHOD = PrimTable(ix).PPath                             ' Pass back address
      END METHOD                                                  '

   END INTERFACE                                                  '

   CLASS METHOD InitPrim(kw AS STRING, OKBrowse AS LONG, norm AS LONG, fm AS LONG, pt AS LONG)  '
   '-----------------------------------------------------------------------------------------------+
   '- Add a single Primitive to the table                                                          |
   '-----------------------------------------------------------------------------------------------+
   LOCAL Cmd AS STRING                                            '
      INCR PrimCount                                              ' Bump count
      LET PrimTable(PrimCount) = CLASS "cPrimitiveEntry"          ' Allocate an entry
      Cmd = MID$(kw, 2)                                           ' Strip out the name
      Cmd = LEFT$(Cmd, INSTR(Cmd, ")") - 1)                       '
      PName(PrimCount) = Cmd                                      ' Add the primitive name
      PrimTable(PrimCount).BrowseOK = OKBrowse                    ' Add the data items
      PrimTable(PrimCount).NPath = norm                           '
      PrimTable(PrimCount).FPath = fm                             '
      PrimTable(PrimCount).PPath = pt                             '
   END METHOD                                                     '

END CLASS                                                         '

CLASS cPrimitiveEntry                                             '
   INSTANCE NPath    AS LONG                                      '
   INSTANCE FPath    AS LONG                                      '
   INSTANCE PPath    AS LONG                                      '
   INSTANCE BrowseOK AS LONG                                      '
   INSTANCE Lockable AS LONG                                      '

   INTERFACE iPrimitiveEntry: INHERIT IUNKNOWN                    '
      gsProp(NPath, LONG)                                         '
      gsProp(FPath, LONG)                                         '
      gsProp(PPath, LONG)                                         '
      gsProp(BrowseOK, LONG)                                      '
      gsProp(Lockable, LONG)                                      '
   END INTERFACE                                                  '
END CLASS                                                         '
