'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- _ObjRtr.inc                                                                                     |
'--------------------------------------------------------------------------------------------------+
                                                                  '
CLASS cRtrv                                                       '
   INSTANCE Rtr()          AS STRING                              ' Hold area for Retrieve commands
   INSTANCE RtrIX          AS LONG                                ' Pointer to next retrieve item

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
   REGISTER i AS LONG                                             '
   REGISTER k AS LONG                                             '
      '--------------------------------------------------------------------------------------------+
      '- Load the table from the CFG file                                                          |
      '--------------------------------------------------------------------------------------------+
      DIM Rtr(1 TO 50)     AS INSTANCE STRING                     ' Retrievable Command line(s)
      gSQL.SelBegin("select * FROM " + gSQL.RtrName)              ' Ask for everything
      IF gSQL.SelFirst() THEN                                     ' Select the first
         DO WHILE gSQL.SelNext()                                  ' Loop through them
            INCR i                                                ' Count the line
            IF i > 50 THEN EXIT DO                                ' Excess records, ignore them
            Rtr(i) = gSQL.SelGet("DBData")                        ' Get and save the the record
         LOOP                                                     '
         IF i < 50 THEN                                           ' Less than specified number?
            FOR k = i + 1 TO 50                                   ' Fill in nulls
               Rtr(k) = ""                                        '
            NEXT k                                                '
         END IF                                                   '
      END IF                                                      '
      gSQL.SelEnd                                                 ' Close the SQL request
      RtrIX = 0                                                   '
   END METHOD                                                     '

   INTERFACE iRtrv: INHERIT IUNKNOWN                              ' Define the interface

      METHOD ADD(Cmd AS STRING) AS LONG                           '
      '--------------------------------------------------------------------------------------------+
      '- Add an item to the Retrieve stack                                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, tCmdF AS STRING, RCA AS RCArea                     '
         t = UUCASE(GetNextWord(Cmd, %NoStrip))                   ' Get command name
         '-----------------------------------------------------------------------------------------+
         '- See if it is exempted from Retrieve                                                    |
         '-----------------------------------------------------------------------------------------+
         SETTableUpd("GET", "RETRIEVE." + t, RCA)                 ' See if user wants it exempted
         IF RCA.RC = 0 AND UCASE$(LEFT$(RCA.Msg, 1)) = "N" THEN EXIT METHOD   ' Yes, bail out

         tCmdF = LSET$(t, 8)                                      ' Make an 8 char version of it
         IF LEN(Cmd) >= gENV.MinRetrieve THEN                     ' Long enough to save?
            '--------------------------------------------------------------------------------------+
            '- Don't add certain commands                                                          |
            '--------------------------------------------------------------------------------------+
            IF INSTR("RETRIEVECRETRIEVRETF    ISCROLL TOP     BOTTOM  BOT     UP      DOWN    LEFT    RIGHT   RECALL  RC      UNDO    REDO    ",tCmdF) = 0 THEN   '
               IF Rtr(1) <> Cmd THEN                              ' If not the same as the current top of stack
                  RtrIX = 0                                       ' Reset if adding a new entry
                  ARRAY INSERT Rtr(1), Cmd                        ' Save new entry for Retrieve command
               END IF                                             '
            END IF                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD GetNext() AS STRING                                  '
      '--------------------------------------------------------------------------------------------+
      '- Retrieve next command from stack                                                          |
      '--------------------------------------------------------------------------------------------+
         INCR RtrIX                                               ' Point to "next" (older) stack entry
         IF RtrIX > UBOUND(Rtr()) THEN                            ' If end of stack passed
            RtrIX = 1                                             ' Wrap back to start of stack
         ELSEIF Rtr(RtrIX) = "" THEN                              ' At end of partially filled stack
            RtrIX = 1                                             ' Wrap back to start of stack
         END IF                                                   '
         TP.ErrMsgHigh = %eRetrieve                               '
         METHOD = Rtr(RtrIX)                                      ' Pass back the entry
      END METHOD                                                  '

      METHOD GetPrev() AS STRING                                  '
      REGISTER j AS LONG                                          '
      '--------------------------------------------------------------------------------------------+
      '- Retrieve previous command from stack                                                      |
      '--------------------------------------------------------------------------------------------+
         IF RtrIX > 1 THEN                                        ' Room to backup?
            DECR RtrIX                                            ' Get previous entry
            METHOD = Rtr(RtrIX)                                   '
         ELSE                                                     ' No Backup room, wrap
            FOR j = 50 TO 1 STEP -1                               ' Find the last non-null entry
               IF ISNOTNULL(Rtr(j)) THEN                          ' We have one
                  RtrIX = j: METHOD = Rtr(j): TP.ErrMsgHigh = %eRetrieve: EXIT METHOD  ' Use it
               END IF                                             '
            NEXT j                                                '
            METHOD = ""                                           ' Return null if all empty
         END IF                                                   '
         TP.ErrMsgHigh = %eRetrieve                               '
      END METHOD                                                  '

      METHOD RESET()                                              '
         RtrIX = 0                                                ' Back to the top
      END METHOD                                                  '

      METHOD CLEAR()                                              '
      REGISTER i AS LONG                                          '
         RtrIX = 0                                                ' Back to the top
         FOR i = 1 TO 50                                          ' Clear the entries
            Rtr(i) = ""                                           '
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD SAVE()                                               '
      REGISTER i AS LONG                                          '
         '-----------------------------------------------------------------------------------------+
         '- Save the table to the CFG file                                                         |
         '-----------------------------------------------------------------------------------------+
          gSQL.Execute("PRAGMA synchronous = OFF")                ' To optimize things
          gSQL.TableClear(gSQL.RtrName)                           ' Clear the existing table
          gSQL.AddString("R", "R00000", "50")                     ' Write the Total # entries
          FOR i = 1 TO 50                                         ' Dump the Table
             gSQL.AddString("R", "R" + FORMAT$(i, "00000"), Rtr(i))  '
          NEXT i                                                  '
          gSQL.Execute("PRAGMA synchronous = ON")                 '
      END METHOD                                                  '

   END INTERFACE                                                  '

END CLASS                                                         '
