$Beta    =   ""                                              ' Alter this to .Beta or "" (Null)
'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- SPFLite.bas                                                                                     |
'--------------------------------------------------------------------------------------------------+
                                                                  '
'--------------------------------------------------------------------------------------------------+
'- Compiler stuff                                                                                  |
'--------------------------------------------------------------------------------------------------+
#COMPILE EXE "D:\SPFLite3\SPFLite3.EXE"                           '
#DIM ALL                                                          '
#STACK 8388608                                                    '
#DEBUG DISPLAY OFF                                                '
#DEBUG ERROR OFF                                                  '
#TOOLS OFF                                                        '
#OPTIMIZE CODE ON                                                '
%USEMACROS = 1                                                    '
%USEPBDECL = 1                                                    '

'--------------------------------------------------------------------------------------------------+
'- Bring in some of the bits and pieces                                                            |
'--------------------------------------------------------------------------------------------------+
#INCLUDE "ASMData.INC"                                            ' ASM Data Statements
#INCLUDE ONCE "Win32Api.inc"                                      ' Windows standard stuff
#INCLUDE ONCE "WinIOCtl.inc"                                      ' Windows IOCtl stuff
#INCLUDE ONCE "ComDlg32.inc"                                      ' Common Dialog stuff
#INCLUDE ONCE "commCtrl.inc"                                      ' Common Controls stuff
#INCLUDE ONCE "ShlWAPI.inc"                                       ' Utility API's
#INCLUDE ONCE "shobjidl.inc"                                      ' Stuff for Property fetch
#INCLUDE ONCE "shlobj.inc"                                        ' .
#INCLUDE ONCE "propkey.inc"                                       ' .
#INCLUDE ONCE "propvarutil.inc"                                   ' .
#INCLUDE ONCE "HtmlHelp.inc"                                      ' HTML Help stuff
#INCLUDE ONCE "AfxShell.Inc"                                      ' Afx shell stuff
#INCLUDE ONCE "string.Inc"                                        ' MS string support
#INCLUDE ONCE "locale.Inc"                                        ' MS locale support
#INCLUDE ONCE "PCRE.inc"                                          ' PCRE Regex stuff
#INCLUDE ONCE "thinCore.INC"                                      ' thinBasic interface definitions
#INCLUDE ONCE "CDOSYS.INC"                                        ' Collaborative Data Objects
#INCLUDE ONCE "OLE2UTILS.INC"                                     ' OLE stuff
#INCLUDE ONCE "RICHEDIT.INC"                                      ' RichEdit stuff
#INCLUDE ONCE "WinINet.INC"                                       ' Internet stuff
#INCLUDE "Macros.INC"                                             ' Macros
#INCLUDE "Types.INC"                                              ' Type and Equates
#INCLUDE "ObjCmnt.INC"                                            ' Comment Tables
#INCLUDE "ObjDic.INC"                                             ' Dictionary Support
#INCLUDE "Resource.INC"                                           ' Resource Includes
#INCLUDE "SPFVersion.inc"                                         ' Version, Build number
#INCLUDE "DialogEquates.INC"                                      ' Dialog Equates
#RESOURCE RES "..\WinVerManifest.res"                             ' Needed for valid result with Windows 8.1 +
'--------------------------------------------------------------------------------------------------+
'- SQLite declares                                                                                 |
'--------------------------------------------------------------------------------------------------+
DECLARE SUB FREE CDECL LIB "msvcrt.dll" ALIAS "free" (BYVAL DWORD)   '
DECLARE FUNCTION sqlite3_open      CDECL LIB "sqlite3.dll" ALIAS _   '
                "sqlite3_open" (zFilename AS ASCIIZ, hDB AS LONG) AS LONG  '
DECLARE FUNCTION sqlite3_open16    CDECL LIB "sqlite3.dll" ALIAS _   '
                "sqlite3_open16" (zFilename AS ASCIIZ, hDB AS LONG) AS LONG   '
DECLARE SUB      sqlite3_close     CDECL LIB "sqlite3.dll" ALIAS _   '
                "sqlite3_close" (BYVAL hDB AS LONG)               '
DECLARE FUNCTION sqlite_get_table  CDECL LIB "sqlite3.dll" ALIAS _   '
                "sqlite3_get_table" (BYVAL hDB AS LONG, szSql AS ASCIIZ, _ '
                                     lpTable AS LONG, nRow AS LONG, nColumn AS LONG, lpErrMsg AS LONG) AS LONG '
DECLARE FUNCTION sqlite_free_table CDECL LIB "sqlite3.dll" ALIAS _   '
                "sqlite3_free_table" (BYVAL lpTable AS LONG PTR) AS LONG   '
DECLARE FUNCTION sqlite3_errmsg    CDECL LIB "sqlite3.dll" ALIAS _   '
                "sqlite3_errmsg" (BYVAL hDB AS LONG) AS LONG      '
'--------------------------------------------------------------------------------------------------+
'- Hunspell Declares                                                                               |
'--------------------------------------------------------------------------------------------------+
DECLARE FUNCTION Hunspell_create LIB "hunspell.dll" ALIAS "Hunspell_create" (affpath AS ASCIIZ,dicpath AS ASCIIZ) AS LONG  '
DECLARE FUNCTION Hunspell_destroy LIB "hunspell.dll" ALIAS "Hunspell_destroy" (BYVAL pHunspell AS LONG) AS LONG   '
DECLARE FUNCTION Hunspell_spell LIB "hunspell.dll" ALIAS "Hunspell_spell" (BYVAL pHunspell AS LONG, zword AS ASCIIZ) AS LONG  '
DECLARE FUNCTION Hunspell_suggest LIB "hunspell.dll" ALIAS "Hunspell_suggest" (BYVAL pHunspell AS LONG, BYREF slst AS DWORD, zword AS ASCIIZ) AS LONG '
DECLARE FUNCTION Hunspell_add LIB "hunspell.dll" ALIAS "Hunspell_add" (BYVAL pHunspell AS LONG, zword AS ASCIIZ) AS LONG   '
DECLARE FUNCTION Hunspell_free_list LIB "hunspell.dll" ALIAS "Hunspell_free_list" (BYVAL HANDLE AS DWORD, BYVAL slist AS DWORD PTR, BYVAL n AS LONG) AS LONG   '

'--------------------------------------------------------------------------------------------------+
'- Global Data                                                                                     |
'--------------------------------------------------------------------------------------------------+

'--------------------------------------------------------------------------------------------------+
'- Define the Dialog Tabs control data                                                             |
'--------------------------------------------------------------------------------------------------+

GLOBAL gTabs()             AS iObjTabData                         ' Table of active tabs
GLOBAL gTabsNum            AS LONG                                ' No. of entries in gTabs()
GLOBAL gTabUnique          AS LONG                                ' Unique ID ctr for the session
GLOBAL TP                  AS iObjTabData                         ' Pointer to current tab data
GLOBAL gTabsBusy           AS LONG                                ' Don't touch flag, Add/Del in progress

'--------------------------------------------------------------------------------------------------+
'- Dialog handles                                                                                  |
'--------------------------------------------------------------------------------------------------+

GLOBAL ghInstance          AS DOUBLE                              ' Handle for my own instance
GLOBAL ghWnd               AS LONG                                ' Main      Window   handle
GLOBAL ghTab               AS LONG                                ' Tab       Control  handle
GLOBAL ghStatusBar         AS LONG                                ' Status    Bar      handle
GLOBAL ghPrf               AS LONG                                ' PROFILE   Display  handle
GLOBAL ghPage1             AS LONG                                ' Profile   Page 1   handle
GLOBAL ghPage2             AS LONG                                ' Profile   Page 2   handle
GLOBAL ghWel               AS LONG                                ' Welcome   Display  handle
GLOBAL ghDebug             AS LONG                                ' Debug     window   handle
GLOBAL ghKey               AS LONG                                ' KEYMAP    Display  handle
GLOBAL ghOpt               AS LONG                                ' OPTIONS   Display  handle
GLOBAL ghGeneral           AS LONG                                ' OPTIONS   General  handle
GLOBAL ghSubmit            AS LONG                                ' OPTIONS   Submit   handle
GLOBAL ghFManager          AS LONG                                ' OPTIONS   FManager handle
GLOBAL ghScreen            AS LONG                                ' OPTIONS   Screen   handle
GLOBAL ghKeyboard          AS LONG                                ' OPTIONS   Keyboard handle
GLOBAL ghSBar              AS LONG                                ' OPTIONS   SBar     handle
GLOBAL ghScheme            AS LONG                                ' OPTIONS   Scheme   handle
GLOBAL ghHiLites           AS LONG                                ' OPTIONS   HiLites  handle
GLOBAL ghConfig            AS LONG                                ' OPTIONS   Config   handle
GLOBAL ghDef               AS LONG                                ' Default   Display  handle
GLOBAL ghPrt               AS LONG                                ' PRINT     Display  handle
GLOBAL ghANSI              AS LONG                                ' ANSI      Display  handle
GLOBAL ghDIFF              AS LONG                                ' DIFF      Display  handle
GLOBAL ghAMBIG             AS LONG                                ' AMBIG     Display  handle
GLOBAL ghUpdate            AS LONG                                ' VerUpd    Display  handle
GLOBAL ghRich              AS LONG                                ' Richedit  Display  handle
GLOBAL ghTray              AS LONG                                ' Tray      Popup    handle
GLOBAL ghPatience          AS LONG                                ' Patience           handle
GLOBAL ghIntr              AS LONG                                ' FF Interupt        handle
GLOBAL ghSplash            AS LONG                                ' Splash screen      handle
GLOBAL ghMsg               AS LONG                                ' Help Level2        handle
GLOBAL ghMsgHnd            AS LONG                                ' Help Level2 Send   handle
GLOBAL ghToolTips          AS LONG                                ' Tooltip creation   handle
GLOBAL ghKbrdHook          AS LONG                                ' Keyboard hook
GLOBAL gBoldFont           AS LONG                                ' Font handles
GLOBAL ghHunspell          AS LONG                                ' Hunspell           handle
GLOBAL gSpellCountry       AS STRING                              ' Country override from SPELL LANG xx
GLOBAL gFixedFont          AS LONG                                '
GLOBAL gKwdMast()          AS STRING                              ' Table of all Parse keywords
GLOBAL gKwdMastCtr         AS LONG                                ' # in table
GLOBAL gScrFont            AS LONG                                '
GLOBAL gScrFontUnd         AS LONG                                '
GLOBAL gScrFontStrike      AS LONG                                '
GLOBAL gScrCourier         AS LONG                                '
GLOBAL gHlpFont            AS LONG                                '
GLOBAL gHlpFontB           AS LONG                                '
GLOBAL gSBFont             AS LONG                                '
GLOBAL gSBFontB            AS LONG                                '
GLOBAL gSBWidth            AS LONG                                '
GLOBAL gSBHeight           AS LONG                                '
GLOBAL gSBSelect           AS LONG                                '
GLOBAL gSBLFlip            AS LONG                                '
GLOBAL gSCrlWidth          AS LONG                                '
GLOBAL gTabRC              AS RECT                                '
GLOBAL gTabHdrRC           AS RECT                                '
GLOBAL gResizeActive       AS LONG                                '

'--------------------------------------------------------------------------------------------------+
'- Global Colors (Set from gENV.Scheme variables)                                                  |
'--------------------------------------------------------------------------------------------------+
GLOBAL gCustFG             AS LONG                                ' Keep all these color variables in order
GLOBAL gCustBG1            AS LONG                                ' as they're also accessed as a table
GLOBAL gCustBG2            AS LONG                                '
GLOBAL gTxtLoFG            AS LONG                                '
GLOBAL gTxtLoBG1           AS LONG                                '
GLOBAL gTxtLoBG2           AS LONG                                '
GLOBAL gTxtHiFG            AS LONG                                '
GLOBAL gTxtHiBG1           AS LONG                                '
GLOBAL gTxtHiBG2           AS LONG                                '
GLOBAL gLnoHiFG            AS LONG                                '   1  Scheme 16
GLOBAL gLnoHiBG1           AS LONG                                '   2
GLOBAL gLnoHiBG2           AS LONG                                '   3
GLOBAL gLnoLoFG            AS LONG                                '   4         17
GLOBAL gLnoLoBG1           AS LONG                                '   5
GLOBAL gLnoLoBG2           AS LONG                                '   6
GLOBAL gATabModFG          AS LONG                                '   7         18
GLOBAL gATabModBG1         AS LONG                                '   8
GLOBAL gATabModBG2         AS LONG                                '   9
GLOBAL gATabNModFG         AS LONG                                '  10         19
GLOBAL gATabNModBG1        AS LONG                                '  11
GLOBAL gATabNModBG2        AS LONG                                '  12
GLOBAL gITabModFG          AS LONG                                '  13         20
GLOBAL gITabModBG1         AS LONG                                '  14
GLOBAL gITabModBG2         AS LONG                                '  15
GLOBAL gITabNModFG         AS LONG                                '  16         21
GLOBAL gITabNModBG1        AS LONG                                '  17
GLOBAL gITabNModBG2        AS LONG                                '  18
GLOBAL gPFKFG              AS LONG                                '  19         22
GLOBAL gPFKBG1             AS LONG                                '  20
GLOBAL gPFKBG2             AS LONG                                '  21
GLOBAL gStatFG             AS LONG                                '  22         23
GLOBAL gStatBG1            AS LONG                                '  23
GLOBAL gStatBG2            AS LONG                                '  24
GLOBAL gFMToolFG           AS LONG                                '  25         24
GLOBAL gFMToolBG1          AS LONG                                '  26
GLOBAL gFMToolBG2          AS LONG                                '  27
GLOBAL gErrorFG            AS LONG                                '  28         25
GLOBAL gErrorBG1           AS LONG                                '  29
GLOBAL gErrorBG2           AS LONG                                '  30
GLOBAL gDiffDFG            AS LONG                                '  31         26
GLOBAL gDiffDBG1           AS LONG                                '  32
GLOBAL gDiffDBG2           AS LONG                                '  33
GLOBAL gDiffIFG            AS LONG                                '  34         27
GLOBAL gDiffIBG1           AS LONG                                '  35
GLOBAL gDiffIBG2           AS LONG                                '  36
GLOBAL gRsvd4FG            AS LONG                                '  37         28
GLOBAL gRsvd4BG1           AS LONG                                '  38
GLOBAL gRsvd4BG2           AS LONG                                '  39
GLOBAL gRsvd3FG            AS LONG                                '  40         29
GLOBAL gRsvd3BG1           AS LONG                                '  41
GLOBAL gRsvd3BG2           AS LONG                                '  42
GLOBAL gRsvd2FG            AS LONG                                '  43         30
GLOBAL gRsvd2BG1           AS LONG                                '  44
GLOBAL gRsvd2BG2           AS LONG                                '  45
GLOBAL gRsvd1FG            AS LONG                                '  46         31
GLOBAL gRsvd1BG1           AS LONG                                '  47
GLOBAL gRsvd1BG2           AS LONG                                '  48
GLOBAL gBandBG             AS LONG                                ' Active BG for Banding needs

'--------------------------------------------------------------------------------------------------+
'- Global copy of HiLite names                                                                     |
'--------------------------------------------------------------------------------------------------+
GLOBAL gHiLites()          AS STRING                              ' Table of valid color names
GLOBAL gHiLitesChrs        AS STRING                              ' String of valid 1st characters

'--------------------------------------------------------------------------------------------------+
'- Global Variables for Printing Routines                                                          |
'--------------------------------------------------------------------------------------------------+

GLOBAL gPrinterOpen        AS INTEGER                             '
GLOBAL gPFontHndl          AS LONG                                '
GLOBAL gPCharWidth         AS LONG                                '
GLOBAL gPCharHeight        AS LONG                                '
GLOBAL gPPageWidth         AS LONG                                '
GLOBAL gPPageHeight        AS LONG                                '
GLOBAL gPCpl               AS LONG                                '
GLOBAL gPLpp               AS LONG                                '
GLOBAL gPLFill             AS LONG                                '
GLOBAL gPRFill             AS LONG                                '
GLOBAL gPTFill             AS LONG                                '
GLOBAL gPColor             AS LONG                                '

'--------------------------------------------------------------------------------------------------+
'- Global Variables during execution                                                               |
'--------------------------------------------------------------------------------------------------+
                                                                  '
GLOBAL gKbdRecFlag         AS LONG                                ' KB recording is active
GLOBAL gKbdRecTxtFlag      AS LONG                                ' KB doing a text string
GLOBAL gCmdLogFlag         AS LONG                                ' Cmd logging is active
GLOBAL gCmdLogFn           AS LONG                                ' Cmd logging File Number
GLOBAL gKbdRecording       AS STRING                              ' The recording data
GLOBAL gDateActive         AS STRING                              ' The Date/Time session started
GLOBAL gDateActive1        AS STRING                              ' The Date/Time session started - 1 hr
GLOBAL gDateActive8        AS STRING                              ' The Date/Time session started - 8 hr
GLOBAL gDateActive24       AS STRING                              ' The Date/Time session started - 24 hr
GLOBAL gDateActive48       AS STRING                              ' The Date/Time session started - 48 hr
GLOBAL gPTbl()             AS PTypeTable                          ' PowerType table
GLOBAL gPTblCount          AS LONG                                ' Number in PT
GLOBAL gBKPList()          AS STRING                              ' List of Active Backup folders
GLOBAL gBKPCtr             AS LONG                                ' Count of Active Backup folders
GLOBAL gFQ()               AS WatchData                           ' List of Open Filenames
GLOBAL gfDoingMsg          AS LONG                                ' Doing a MSGBOX, OPEN Dialog, etc. (active counter)
GLOBAL gfDoingPOP          AS LONG                                ' Doing a PopUp Menu
GLOBAL gPending            AS LONG                                ' File change notify message active            '
GLOBAL gfDialogDone        AS LONG                                ' Result of Dialog display
GLOBAL gfTermFlag          AS LONG                                ' Set for full termination
GLOBAL gfXRebuild          AS LONG                                ' Exclude lines rebuild needed
GLOBAL gfEndAll            AS LONG                                ' ENDALL in progress
GLOBAL gfInterrupt         AS LONG                                ' Interrupt flag
GLOBAL gEFTRaw()           AS STRING                              ' Raw EFT input table
GLOBAL gEFTRawCtr          AS LONG                                ' Raw EFT count
GLOBAL gEFT()              AS EFTData                             ' EFT map table
GLOBAL gEFTCtr             AS LONG                                ' No. of items in EFT table
GLOBAL gEFTName            AS STRING                              ' Profname to be overridden
GLOBAL gEFTOpenSource      AS STRING                              ' Open file initial invoker
GLOBAL gCaretCtr           AS LONG                                ' Count of Caret Show/Hide
GLOBAL gShutFlag           AS LONG                                ' Stacked =X or EXIT command
GLOBAL gLastKBTime         AS DWORD                               ' Time of last KB operation.
GLOBAL gfLeftDown          AS LONG                                ' To track Mouse button
GLOBAL gfMiddleDown        AS LONG                                ' To track Middle mouse button
GLOBAL gfSplitDown         AS LONG                                ' To track Left Down on the Split line
GLOBAL gfActive            AS LONG                                ' Are we active or not
GLOBAL gfOptCancel         AS LONG                                ' OPTION was cancelled
GLOBAL gCmdList()          AS STRING                              ' Command list for DO processing
GLOBAL gWinList()          AS WININFOTYPE                         '
GLOBAL gWinListPos         AS LONG                                '
GLOBAL gEOLFlagList()      AS STRING                              '
GLOBAL gRECFMList()        AS STRING                              '
GLOBAL gPrimTable()        AS STRING                              '
GLOBAL gTabDelList()       AS LONG                                ' Tabs to be deleted this interrupt
GLOBAL gTabDelCtr          AS LONG                                ' Count of entries
GLOBAL gTabDelMsg          AS STRING                              ' Message for next tab
GLOBAL gTabGoTo            AS TSwitch                             ' Data for tab switch (Number, Message, Command
GLOBAL gTabStack()         AS LONG                                ' Stack of Tab activity
GLOBAL gTabStackNum        AS LONG                                ' Number in stack
GLOBAL gFontHeight         AS INTEGER                             ' Current font height
GLOBAL gFontWidth          AS INTEGER                             ' Current font width
GLOBAL gFontScale          AS SINGLE                              ' Scale factor for dialog fonts
GLOBAL gLNPadCol           AS LONG                                ' Location of Pad column
GLOBAL gLNData1            AS LONG                                ' Location of Data column 1
GLOBAL gKeyChr             AS STRING                              ' Current KB key entered
GLOBAL gKeyPrimOper        AS STRING                              ' Current Primitive Operand
GLOBAL gSBTable()          AS SBarEntry                           ' Master SB table
GLOBAL gAttrTable()        AS AttrEntry                           ' FD Attribute table
GLOBAL gSBCount            AS LONG                                ' Active SB entries
GLOBAL gWSBTable()         AS sBarEntry                           ' StatusBar message area
GLOBAL gSubmitFile         AS STRING                              ' Submit filename
GLOBAL gResultFile         AS STRING                              ' Result (~R) filename
GLOBAL gSubmitType         AS STRING                              ' "J" or "S"
GLOBAL gJobID              AS STRING                              ' Current job number as JOB12345
GLOBAL gDosOperands        AS STRING                              ' User supplied DOS operands
GLOBAL gSetRaw()           AS STRING                              ' SET Key raw data
GLOBAL gSetRawCtr          AS LONG                                ' SET Key raw data count
GLOBAL gSetKey()           AS STRING                              ' SET Key table
GLOBAL gSetData()          AS STRING                              ' SET Data table
GLOBAL gSetCount           AS LONG                                ' No. of items in SET table
GLOBAL gSetClipB           AS STRING                              ' Saved clipboard
GLOBAL gPageNumber         AS STRING                              ' Print Page number for ~#
GLOBAL gPrtRaw             AS LONG                                ' Print Raw mode
GLOBAL gPrtPaper           AS STRING                              ' Current paper in printer
GLOBAL gEnumWith           AS LONG                                ' ENUM incr value
GLOBAL gLnoTextType()      AS LONG                                ' Table of Line Number display types
GLOBAL gLnoTextTxt()       AS STRING                              ' Table of Line Number display text
GLOBAL gUpper              AS STRING                              ' Upper list with Int. chars if needed
GLOBAL gLower              AS STRING                              ' Lower list with Int. chars if needed
GLOBAL gInternalCB         AS STRING                              ' Secret internal Clipboard
GLOBAL gDefaultAnswer      AS STRING                              ' Answer from the DispDefault popup
GLOBAL gLoopCheck          AS LONG                                ' LOOPCHECK ON/OFF
GLOBAL gLoopFlag           AS LONG                                ' Trigger Loop Detect Counting
GLOBAL gLoopCtr            AS LONG                                ' # seconds doing this transaction
GLOBAL gLoopThread         AS LONG                                ' Loop detect thread started
GLOBAL gCrashList()        AS STRING                              ' Module trace
GLOBAL gCrashCtr           AS LONG                                ' Module trace Index
GLOBAL gCrashOK            AS LONG                                ' OK to trace Tabnum
GLOBAL gCrashLastPCmd      AS STRING                              ' Last Primary command
GLOBAL gCrashTrace()       AS STRING                              ' Activity Trace
GLOBAL gCrashLastLCmd      AS STRING                              ' Last Line command
GLOBAL gCrashLastPrim      AS STRING                              ' Last Primitive
GLOBAL gValidChars         AS STRING                              ' Current valid characters in the active font
GLOBAL gDiffFileA          AS STRING                              ' DIFF FileA
GLOBAL gDiffFileB          AS STRING                              ' DIFF FileB
GLOBAL gDiffClipNo         AS LONG                                ' DIFF ClipList selection
GLOBAL gDiffColWidth       AS LONG                                ' DIFF Column width in 2 column mode
GLOBAL gTerminateInProgress AS LONG                               ' We're shutting down
GLOBAL gMsgBoxActive       AS LONG                                ' MyMsgBox is active
GLOBAL gEFTOVCtr           AS LONG                                ' Temp hold for EFT Override Count
GLOBAL gEFTOVList()        AS STRING                              ' Temp hold for EFT Override command list
GLOBAL ghConsoleO          AS DWORD                               ' Debug Console Handle Output
GLOBAL ghConsoleI          AS DWORD                               ' Debug Console Handle Input
GLOBAL ghDB                AS DWORD                               ' Debug console Window Handle
GLOBAL ghDBListBox         AS DWORD                               ' Debug console ListBox Handle
GLOBAL ghDBHide            AS LONG                                ' Debug console is hidden
GLOBAL ghDLines            AS LONG                                ' Debug console current # lines
GLOBAL ghDBOldProc         AS DWORD                               ' Previous proc for Subclass
GLOBAL ghDBLines           AS LONG                                ' # lines in Debug window
GLOBAL ghDBCtr             AS LONG                                ' # lines added to ListBox
GLOBAL ghDBFn              AS LONG                                ' DEBUGLOG File Number
GLOBAL ghDBFName           AS STRING                              ' DEBUGLOG File Name
GLOBAL gDoBeepFlag         AS LONG                                ' BEEP requested

'--------------------------------------------------------------------------------------------------+
'- Line Control handling                                                                           |
'--------------------------------------------------------------------------------------------------+

GLOBAL gLTblAIX            AS LONG                                ' Count of gLTblA entries
GLOBAL gLTblA()            AS LCtlScan                            ' Initial line scan table
GLOBAL gLTblBIX            AS LONG                                ' Count of gLTblB entries
GLOBAL gLTblB()            AS LCtlCmd                             ' Complete line command list
GLOBAL gLTblRange          AS LONG                                ' A line control range is available
GLOBAL gLTblSCmd           AS STRING * 8                          ' LLCtl Srce Line command
GLOBAL gLTblSFrom          AS LONG                                ' LLCtl Srce Cmd FromIX
GLOBAL gLTblSTo            AS LONG                                ' LLCtl Srce Cmd ToIX
GLOBAL gLTblSRpt           AS LONG                                ' LLCtl Srce Cmd Repeat
GLOBAL gLTblSFlag          AS LONG                                ' LLCtl Srce Cmd Flag
GLOBAL gLTblDCmd           AS STRING * 8                          ' LLCtl Dest Line command
GLOBAL gLTblDFrom          AS LONG                                ' LLCtl Dest Cmd FromIX
GLOBAL gLTblDTo            AS LONG                                ' LLCtl Dest Cmd ToIX
GLOBAL gLTblDRpt           AS LONG                                ' LLCtl Dest Cmd Repeat
GLOBAL gLTblDFlag          AS LONG                                ' LLCtl Dest Cmd Flag

'--------------------------------------------------------------------------------------------------+
'- Help Tables                                                                                     |
'--------------------------------------------------------------------------------------------------+
GLOBAL gHlpKilled          AS LONG                                ' Help killed, missing index file
GLOBAL gHlpT()             AS HTopic                              ' Topic IDs and Titles
GLOBAL gHlpK()             AS HEnt                                ' Topic IDs Keywords
GLOBAL gHlpW()             AS HEnt                                ' Topic Search words
GLOBAL gHlpF()             AS HFound                              ' Found Topics
GLOBAL gHlpKCtr            AS LONG                                ' # in gHlpK table
GLOBAL gHlpWCtr            AS LONG                                ' # in gHlpW table
GLOBAL gHlpFCtr            AS LONG                                ' # in gHlpF table
GLOBAL gHlpTMax            AS LONG                                ' Size of gHlpT table
GLOBAL gHlpKMax            AS LONG                                ' Size of gHlpK table
GLOBAL gHlpWMax            AS LONG                                ' Size of gHlpW table
GLOBAL gHlpFMax            AS LONG                                ' Size of gHlpF table
GLOBAL gHlpTopicNum        AS LONG                                ' Return value from Ambig dialog
GLOBAL gHlpSearchStr       AS STRING                              ' Current search list
GLOBAL gHlpSWords()        AS STRING                              ' Search words
GLOBAL gHlpSWordsCtr       AS LONG                                ' Search word count

'--------------------------------------------------------------------------------------------------+
'- Block cut / paste control                                                                       |
'--------------------------------------------------------------------------------------------------+

GLOBAL gSlecthDC           AS DWORD                               ' For handling Mouse text frame select

'--------------------------------------------------------------------------------------------------+
'- Global Object hooks                                                                             |
'--------------------------------------------------------------------------------------------------+
GLOBAL gPCmdT              AS iPCmdTable                          ' Primary command table
GLOBAL gLCmdT              AS iLCmdTable                          ' Line command table
GLOBAL gPrimT              AS iPrimTable                          ' Primitive table
GLOBAL gKwd                AS iKwd                                ' CFG Keyword table support
GLOBAL gENV                AS iENVariables                        ' Environment stuff
GLOBAL gKbdT               AS iKbdTable                           ' Keyboard table
GLOBAL gRtr                AS iRtrv                               ' Retrieve stack
GLOBAL gSQL                AS SQLI                                ' SQL DB handler
GLOBAL gSQLP               AS SQLMI                               ' SQL Parse master table

'--------------------------------------------------------------------------------------------------+
'- File Manager Data Areas                                                                         |
'--------------------------------------------------------------------------------------------------+
GLOBAL gFMRQList()         AS STRING                              ' Current request list (like FILELIST contents)
GLOBAL gFMRXList()         AS STRING                              ' Current Exclude list
GLOBAL gFMD()              AS iFMData                             ' Latest Dir scan results (Object pointers)
GLOBAL gFMC()              AS iFMColumn                           ' Column mapping
GLOBAL gFMLayout           AS STRING                              ' Current FM Layout
GLOBAL gFMLayoutID         AS STRING                              ' Current FM Layout ID
GLOBAL gFMQFList1          AS STRING                              ' Quick FLIST1
GLOBAL gFMQFList2          AS STRING                              ' Quick FLIST2
GLOBAL gFMQFList3          AS STRING                              ' Quick FLIST3
GLOBAL gFMQFList4          AS STRING                              ' Quick FLIST4
GLOBAL gFMQFList5          AS STRING                              ' Quick FLIST5
GLOBAL gFMQFList6          AS STRING                              ' Quick FLIST6
GLOBAL gFMRQCount          AS LONG                                ' Count in gFMRQList
GLOBAL gFMRXCount          AS LONG                                ' Count in gFMRXList
GLOBAL gFMDCtr             AS LONG                                ' Count in gFMD
GLOBAL gFMCCtr             AS LONG                                ' Count in gFMC
GLOBAL gFMProp()           AS STRING                              ' FM File Properties supported
GLOBAL gFMPropNum          AS LONG                                ' Number of FM File Properties
GLOBAL gFMPropAct          AS LONG                                ' Are there active Property columns
GLOBAL gFMFNameSz          AS LONG                                ' FNAME size from main Layout
GLOBAL gFMNumFiles         AS LONG                                ' Number of Files
GLOBAL gFMNumDirs          AS LONG                                ' Number of Dirs
GLOBAL gFMNumLines         AS LONG                                ' Number of lines
GLOBAL gFMTotSize          AS QUAD                                ' Total size
GLOBAL gFMMacMode          AS LONG                                ' 0 = Primary, 1 = Line
GLOBAL gFMNestCtr          AS LONG                                ' Counter of gFMNestTbl() entries
GLOBAL gFMNestTbl()        AS STRING                              ' Save table for FPath, FMask and FileListNm
GLOBAL gFMNestTopScrn      AS LONG                                ' Desired Topscreen when Nest is popped
GLOBAL gFMNestHigh         AS LONG                                ' Highest Nest entry
GLOBAL gFMDeleteAll        AS LONG                                ' A Delete ALL was entered
GLOBAL gFMLCmdTable()      AS FMLCtlValEnt                        ' Line Command Table

GLOBAL gFM_Crit_Size       AS LONG                                ' Screen size for FM Criteria lines
GLOBAL gFM_Quick_Line_1    AS LONG                                '
GLOBAL gFM_Quick_Pos_1     AS LONG                                '
GLOBAL gFM_Quick_Pos_2     AS LONG                                '
GLOBAL gFM_Quick_Pos_3     AS LONG                                '
GLOBAL gFM_Quick_Pos_4     AS LONG                                '
GLOBAL gFM_Quick_Pos_5     AS LONG                                '
GLOBAL gFM_Quick_Pos_6     AS LONG                                '
GLOBAL gFM_Quick_Pos_7     AS LONG                                '
GLOBAL gFM_Quick_Pos_8     AS LONG                                '
GLOBAL gFM_Quick_Pos_9     AS LONG                                '
GLOBAL gFM_Quick_Pos_10    AS LONG                                '
GLOBAL gFM_Quick_Pos_11    AS LONG                                '
GLOBAL gFM_Quick_Pos_12    AS LONG                                '
GLOBAL gFM_Quick_Pos_13    AS LONG                                '
GLOBAL gFM_Quick_Pos_14    AS LONG                                '
GLOBAL gFM_Quick_Pos_15    AS LONG                                '
GLOBAL gFM_Path_Line       AS LONG                                '
GLOBAL gFM_Path_Left       AS LONG                                '
GLOBAL gFM_Mask_Line       AS LONG                                '
GLOBAL gFM_Mask_Left       AS LONG                                '
GLOBAL gFM_Head_Line       AS LONG                                '
GLOBAL gFM_Head_Name_Left  AS LONG                                '
GLOBAL gFM_Head_Date_Left  AS LONG                                '
GLOBAL gFM_Top_File_Line   AS LONG                                '
GLOBAL gFM_List_Height     AS LONG                                '
GLOBAL gFM_RightMost       AS LONG                                '

'--------------------------------------------------------------------------------------------------+
'- RegEx areas                                                                                     |
'--------------------------------------------------------------------------------------------------+
GLOBAL gPCRE_Regex_Str2    AS STRING                              ' String to build pseudo ASCIIZ string
GLOBAL gPCRE_ErrPtr        AS ASCIIZ PTR                          ' Pointer to pcre_compile error message string
GLOBAL gPCRE_ErrOffsetPtr  AS DWORD                               ' Pointer to offset in Regex string where error was detected
GLOBAL gPCRE_Options       AS LONG                                ' Options passed to pcre
GLOBAL gPCRE_Offsets()     AS LONG                                ' Table of offsets to located strings
GLOBAL gPCRE_hLib          AS LONG                                ' Handle of PCRE3.dll library
GLOBAL gPCRE_hProc_Compile AS LONG                                ' Handle to Compile function
GLOBAL gPCRE_hProc_Exec    AS LONG                                ' Handle to Exec function
GLOBAL gPCRE_hProc_Free    AS LONG                                ' Handle to Free function
GLOBAL gPCRE_hProc_Free_Ptr AS LONG                               ' Handle to Real Free function

'--------------------------------------------------------------------------------------------------+
'- Macro Basic data                                                                                |
'--------------------------------------------------------------------------------------------------+
GLOBAL gMacroMode          AS LONG                                ' A Macro is running
GLOBAL gEDMacMode          AS LONG                                ' 0 = Primary, 1 = Line
GLOBAL gMacroName          AS STRING                              ' The macro name
GLOBAL gMacLib             AS STRING                              ' The maclib Set name
GLOBAL gMacLibList         AS STRING                              ' The macro Library List
GLOBAL gMacLines()         AS STRING                              ' The macro code
GLOBAL gMacThread          AS DWORD                               ' Macro thread handle
GLOBAL gStrVar             AS IDicObj                             ' STR variable pool
GLOBAL gNumVar             AS IDicObj                             ' NUM variable pool
GLOBAL gParseTbl           AS IPOWERCOLLECTION                    ' Parse table storage
GLOBAL gMacNoLoopTest      AS LONG                                ' User wants no Loop checking
GLOBAL gMacLCsr            AS LONG                                ' Macro has set LCsr
GLOBAL gMacroTrace         AS LONG                                ' Trace functions 0 = No, 1 = Yes, 3 = Error only
GLOBAL gMacroTHeader       AS STRING                              ' Trace function name, params
GLOBAL gMacroRC            AS LONG                                ' Final RC
GLOBAL gMacroMsg           AS STRING                              ' Final Msg
GLOBAL gMacroFile          AS STRING                              ' Full macro filename
GLOBAL gMacRange           AS LONG                                ' Line control range at Macro start
GLOBAL gMacSCmd            AS STRING                              ' LLCtl Srce Line command
GLOBAL gMacSFrom           AS LONG                                ' LLCtl Srce Cmd FromIX
GLOBAL gMacSTo             AS LONG                                ' LLCtl Srce Cmd ToIX
GLOBAL gMacSRpt            AS LONG                                ' LLCtl Srce Cmd Repeat
GLOBAL gMacSFlag           AS LONG                                ' LLCtl Srce Cmd Flag
GLOBAL gMacDCmd            AS STRING                              ' LLCtl Dest Line command
GLOBAL gMacDFrom           AS LONG                                ' LLCtl Dest Cmd FromIX
GLOBAL gMacDTo             AS LONG                                ' LLCtl Dest Cmd ToIX
GLOBAL gMacDRpt            AS LONG                                ' LLCtl Dest Cmd Repeat
GLOBAL gMacDFlag           AS LONG                                ' LLCtl Dest Cmd Flag
GLOBAL gMacCore            AS DWORD                               ' Address of thinBasic_Core
GLOBAL gMacRelease         AS DWORD                               ' Address of thinBasic_Release
GLOBAL gMacFString         AS STRING                              ' Find string for EXEC Macro / MapStr
GLOBAL gMacCString         AS STRING                              ' Change string returned from EXEC MACRO / MapStr
GLOBAL gMacErrString       AS STRING                              ' Error message string returned from MapStr
GLOBAL gMacGotlit, gMacGotnum, gMacGotlptr, gMacGottag AS LONG    ' Parse gotten operand counts
GLOBAL gMacOprands()       AS STRING                              '
GLOBAL gPTBLSAVE           AS iObjParse                           ' Backup Parse Object pointer
GLOBAL gPTBLsline, gPTBLscol, gPTBLsdir AS LONG                   ' Backup search position stuff

'--------------------------------------------------------------------------------------------------+
'- Benchmark timing data and sample code                                                           |
'--------------------------------------------------------------------------------------------------+
GLOBAL qFreq, qStart, qStop AS QUAD                               '
'-  QueryPerformanceFrequency qFreq                               ' Get the performance Freq
'-  qAccum = 0                                                    '
'-  QueryPerformanceCounter   qStart
'-  QueryPerformanceCounter   qStop
'-  qAccum = qAccum + (qStop - qStart)
'-  debug "Comment, CPU elapsed = " + FORMAT$(qAccum*1000/qFreq, "####.##")+"ms"

'--------------------------------------------------------------------------------------------------+
'- Include code stored in INC files                                                                |
'--------------------------------------------------------------------------------------------------+

#INCLUDE "ASMCode.INC"                                            ' Assembler Routines
#INCLUDE "ObjSQL.INC"                                             ' SQL Wrappers
#INCLUDE "ObjSQLM.INC"                                            ' SQL Memory Table Version
#INCLUDE "ObjKwd.INC"                                             ' Environment CFG Keywords
#INCLUDE "ObjENV.INC"                                             ' Environment stuff
#INCLUDE "ObjPCmdT.INC"                                           ' Primary Command Table
#INCLUDE "ObjLCmdT.INC"                                           ' Line Command Table
#INCLUDE "ObjKbdT.INC"                                            ' Keyboard Table
#INCLUDE "ObjPrimT.INC"                                           ' Primitive Table
#INCLUDE "ObjFCB.INC"                                             ' FCB Stuff
#INCLUDE "ObjRtr.INC"                                             ' Retrieve Stuff
#INCLUDE "ObjParse.INC"                                           ' Cpmmand parsing
#INCLUDE "TabData.INC"                                            ' Main Tab Related Stuff
#INCLUDE "ObjFMD.INC"                                             ' FM Data

'--------------------------------------------------------------------------------------------------+
'- Away we go!!!                                                                                   |
'--------------------------------------------------------------------------------------------------+

FUNCTION WINMAIN (BYVAL hInst AS LONG, BYVAL hPrevInst AS DWORD, BYVAL lpszCmdLine AS WSTRINGZ PTR, BYVAL nCmdShow  AS LONG ) AS LONG  '
   ghInstance = hInst                                             ' Save my Instance
   RealPBMain                                                     ' Call The real guy
'-  PROFILE "D:\Cloud\Documents\SPFLite3\SPFLiteProfile.txt"      ' Uncomment to create a profile
END FUNCTION                                                      '

FUNCTION RealPBMAIN AS LONG                                       '
LOCAL i, j, x, y, nx, ny, h AS LONG                               '
LOCAL MRF, Init AS STRING, RCA AS RCArea                          '
LOCAL tHndl, tResult, MRFOpen AS LONG, parmp, lptr AS LONG POINTER   '
LOCAL hDC AS DWORD                                                '
LOCAL DMsg AS KBMsg                                               '
LOCAL PTime, CTime AS IPOWERTIME                                  ' Create a PowerTime object
LET PTime = CLASS "PowerTime"                                     '
LET CTime = CLASS "PowerTime"                                     '
LET gPTBLsAVE = CLASS "cObjParse"                                 ' Backup Parse Object
'--------------------------------------------------------------------------------------------------+
'- Initialize the Global arrays                                                                    |
'--------------------------------------------------------------------------------------------------+

DIM gTabs(1)               AS iObjTabData                         ' Dim the Tabs table
DIM gBKPList(1 TO 1)       AS GLOBAL STRING                       ' List of active Backup folders
DIM gPTbl(1 TO 500)        AS GLOBAL PTypeTable                   ' PowerType table
DIM gFQ(1 TO 1000)         AS GLOBAL WatchData                    ' Global File Queue
DIM TTbl(1 TO 1000)        AS GLOBAL TouchEntry                   ' Touch Table
DIM gLTblA(500)            AS GLOBAL LCtlScan                     ' Initial line scan table
DIM gLTblB(500)            AS GLOBAL LCtlCmd                      ' Complete line command list
DIM gLnoTextType(1 TO 16)  AS GLOBAL LONG                         ' Table of Line Number display types
DIM gLnoTextTxt(1 TO 16)   AS GLOBAL STRING                       ' Table of Line Number display text
DIM gWinList(1 TO 500)     AS GLOBAL WININFOTYPE                  ' Windows list
DIM gCrashList(0 TO 1000)  AS GLOBAL STRING                       ' Module trace
DIM gCrashTrace(1 TO 20)   AS GLOBAL STRING                       ' Activity trace
DIM gMacOprands(1 TO 50)   AS GLOBAL STRING                       ' MACRO operands
DIM gTabDelList(1 TO 100)  AS GLOBAL LONG                         ' Tabs to be deleted this interrupt
DIM gTabDelNext(1 TO 100)  AS GLOBAL LONG                         ' Tabs to be switched to
DIM gTabStack(1 TO 100)    AS GLOBAL LONG                         ' Active tab stack
DIM gPCRE_Offsets(12)      AS GLOBAL LONG                         ' Table of offsets to PCRE located strings
DIM gFMRQList(1 TO 100)    AS GLOBAL STRING                       ' Current request list
DIM gFMRXList(1 TO 100)    AS GLOBAL STRING                       ' Current Exclude list
DIM gFMD(1 TO 100)         AS GLOBAL iFMData                      ' Latest Dir scan results in Object format
DIM gFMC(1 TO 20)          AS GLOBAL iFMColumn                    ' FM Column mapping
DIM gFMProp(1 TO 50)       AS GLOBAL STRING                       ' FM Properties supported
DIM gSBTable(1 TO 16)      AS GLOBAL SBarEntry                    ' StatusBar messages
DIM gAttrTable(1 TO 15)    AS GLOBAL AttrEntry                    ' FD Attr Table
DIM gWSBTable(1 TO 17)     AS GLOBAL SBarEntry                    ' StatusBar messages (+1 dummy @ the end)
DIM gKwdMast(1 TO 500)     AS GLOBAL STRING                       ' Parse keywords
DIM gEOLFlagList(7)        AS GLOBAL STRING                       ' Pulldown menu for EOLFlag
DIM gRECFMList(5)          AS GLOBAL STRING                       '     "      "   "  RECFM
DIM gCmdList(0)            AS GLOBAL STRING                       ' Cmd list for DO processing
DIM gHiLites(1 TO 16)      AS GLOBAL STRING                       ' HiLite color names
DIM gFMNestTbl(1 TO 25)    AS GLOBAL STRING                       ' Save table for FM Nest Status
    gHlpTMax = 600                                                ' Set Max
DIM gHlpT(0 TO gHlpTMax)   AS GLOBAL HTopic                       ' Help Topics and IDs ** Zero Based !! **
    gHlpKMax = 1500                                               ' Set Max
DIM gHlpK(1 TO gHlpKMax)   AS GLOBAL HEnt                         ' Help Kwds and IDs
    gHlpWMax = 50000                                              ' Set Max
DIM gHlpW(1 TO gHlpWMax)   AS GLOBAL HEnt                         ' Help Title Words and IDs
    gHlpFMax = 600                                                ' Set Max
DIM gHlpF(1 TO gHlpFMax)   AS GLOBAL HFound                       ' Found topic numbers
DIM gHlpSWords(1 TO 8)     AS GLOBAL STRING                       ' Search words
DIM gEFTRaw(1 TO 2)        AS GLOBAL STRING                       ' EFT raw table
DIM gSetRaw(1 TO 2)        AS GLOBAL STRING                       ' SET raw table
DIM gEFT(1 TO 100)         AS GLOBAL EFTData                      ' EFT Mask/Prof table
DIM gEFTOVList(0 TO 50)    AS GLOBAL STRING                       ' EFT Override commands
ARRAY ASSIGN gEOLFlagList() = "CRLF", "LF", "CR", "NL", "AUTO", "AUTONL", "NONE", " "  '
ARRAY ASSIGN gRECFMList() = "U", "F", "V", "VBI", "VLI"           '
ARRAY ASSIGN gHiLites() = "BLUE", "GREEN", "YELLOW", "RED", "BLACK", "NAVY", "TEAL", "VIOLET", _   '
                          "ORANGE", "GRAY", "LIME", "CYAN", "PINK", "MAGENTA", "WHITE", "GREY"  '
   gHiLitesChrs = "BGYRKNTVOALCPMWA"                              ' 1 char matching IDs
   QueryPerformanceFrequency qFreq                                ' Get the performance Freq
   gScrlWidth = GetSystemMetrics(%SM_CXVSCROLL)                   ' Get width of Vert Scrollbar + 2
   CoInitializeEx(0, 0)                                           ' Init for ShellExecute
   gLoopCheck = %True                                             ' Default LoopCheck
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Actually start doing something                                                               |
   '-----------------------------------------------------------------------------------------------+
   SETUNHANDLEDEXCEPTIONFILTER CODEPTR(DoLoopHandle)              ' Trap my exceptions
   RANDOMIZE TIMER                                                ' Good practice
   '-----------------------------------------------------------------------------------------------+
   '- Ready the Tray popup                                                                         |
   '-----------------------------------------------------------------------------------------------+
   MENU NEW POPUP TO ghTray                                       '
   MENU ADD STRING, ghTray, "&About", %TRAY_ABOUT, %MF_ENABLED    '

   '-----------------------------------------------------------------------------------------------+
   '- Get PCRE ready to use                                                                        |
   '-----------------------------------------------------------------------------------------------+
   gPCRE_hLib = LoadLibraryA( BYCOPY "PCRE3.Dll" )                ' Get handle to the DLL
   IF gPCRE_hLib THEN                                             ' PCRE exists

      '--------------------------------------------------------------------------------------------+
      '- Try to load the functions                                                                 |
      '--------------------------------------------------------------------------------------------+
      gPCRE_hProc_Compile         = GetProcAddress(gPCRE_hLib, BYCOPY "pcre_compile")  '
      gPCRE_hProc_Exec            = GetProcAddress(gPCRE_hLib, BYCOPY "pcre_exec")  '
      gPCRE_hProc_Free            = GetProcAddress(gPCRE_hLib, BYCOPY "pcre_free")  '
      lptr = gPCRE_hProc_Free                                     ' Free returns a POINTER to the real free routine
      gPCRE_hProc_Free_Ptr = @lptr                                ' so chain to it as the REAL entry point

      '--------------------------------------------------------------------------------------------+
      '- If all went fine ...                                                                      |
      '--------------------------------------------------------------------------------------------+
      IF gPCRE_hProc_Compile       AND _                          ' All three better be non-zero
         gPCRE_hProc_Exec          AND _                          '
         gPCRE_hProc_Free_Ptr      THEN                           '
         '-----------------------------------------------------------------------------------------+
         '- All is well                                           '                                |
         '-----------------------------------------------------------------------------------------+
      ELSE                                                        '
         MSGBOX "Internal PCRE functions not found"               ' Error
         MExitFunc                                                '
      END IF                                                      '

   ELSE                                                           '
      MSGBOX "PCRE DLL does not appear to be installed"           ' Say why we didn't do it
      MExitFunc                                                   '
   END IF                                                         '

'--------------------------------------------------------------------------------------------------+
'- Establish some Global Objects                                                                   |
'--------------------------------------------------------------------------------------------------+
LET gStrVar   = CLASS "cDicObj"                                   ' Macro global string variables
LET gNumVar   = CLASS "cDicObj"                                   ' Macro global numeric variables
LET gParseTbl = CLASS "PowerCollection"                           ' Macro parse
LET gKwd      = CLASS "cKwd"                                      ' CFG Keyword table support
LET gSQL      = CLASS "SQLC"                                      ' SQL Object (Init before gENV)
LET gSQLP     = CLASS "SQLMC"                                     ' SQL Object for Parse Master
LET gENV      = CLASS "cENVariables"                              ' Environment stuff
LET gPCmdT    = CLASS "cPCmdTable"                                ' Primary Command Table
LET gLCmdT    = CLASS "cLCmdTable"                                ' Line Command Table
LET gPrimT    = CLASS "cPrimTable"                                ' Primitive Table
LET gKbdT     = CLASS "cKbdTable"                                 ' Keyboard tables
LET gRtr      = CLASS "cRtrv"                                     ' Retrieve stack Object

   SetProcessDPIAware                                             ' So we can test DPI properly

   InitLocalTables                                                ' Initialize some more Local tables

   InitLNText                                                     ' Go initialize line number text constants

   FontAdjustSizes                                                ' Go Adjust font sizes
   '-----------------------------------------------------------------------------------------------+
   '- Get a valid TP environment real early                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE (gEnv.VScrollBar) THEN gScrlWidth = 0               ' Kill ScrollBar allocation
   INCR gTabsNum: INCR gTabUnique                                 ' Add a Tab
   LET gTabs(gTabsNum) = CLASS "cObjTabData"                      ' Build the Class entry
   TP = gTabs(gTabsNum)                                           ' Make the new entry the active tab class
   TP.Init(%True)                                                 ' Init FM PANEL structure
   TP.PTBL_.PTBLReset                                             ' Init the PTBL within it
   TP.PgNumber = gTabsNum                                         ' Save Page Number
   TP.LInitTxtData()                                              ' Initialize the Editor text data
   TP.FCB_.BuildBndText()                                         ' Do here since can't be done in CREATE
   gCrashOK = %True                                               ' OK to trace TabNum
   gFMDCtr = 1                                                    ' Allocate 1 FMD object
   LET gFMD(gFMDCtr) = CLASS "cFMData"                            '

   InitMoreStuff                                                  ' Initialize miscellaneous stuff
   SLEEP 500                                                      ' Give Debug2 thread some time
   InitHelp                                                       '

   '-----------------------------------------------------------------------------------------------+
   '- If first time user, let them do some settings                                                |
   '-----------------------------------------------------------------------------------------------+
   IF gENV.FirstTime THEN                                         '
      DispOptions(1)                                              ' Go let user play with them
   END IF                                                         '


   '-----------------------------------------------------------------------------------------------+
   '- Display emergency KEYMAP if asked for                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF IsENVKeyMap THEN DispKeyMap(0)                              ' Recovery mode KEYMAP?

   '-----------------------------------------------------------------------------------------------+
   '- See if we should pass this session off to a current running one                              |
   '-----------------------------------------------------------------------------------------------+
   IF InitSeeUnique(i) THEN MExitFunc                             ' Go see if we should be unique

   '-----------------------------------------------------------------------------------------------+
   '- Check for a version update if not in Manual Check mode                                       |
   '-----------------------------------------------------------------------------------------------+
   InitUpdateCheck                                                ' Go do the check

   '-----------------------------------------------------------------------------------------------+
   '- Handle the MRFList and InitString merging                                                    |
   '-----------------------------------------------------------------------------------------------+
   MRF = gSQL.GetString("O", "MRFList", "")                       ' Get the MRF list
   Init = gENV.InitString                                         ' Get the InitString
   IF ISNOTNULL(Init) THEN                                        ' Something from the command line?
      IF ISNOTNULL(MRF) AND gENV.ReOpenLast THEN                  ' Would a re-open have been done?
         IF LEFT$(Init, 1) = "?" THEN                             ' Append InitString?
            gENV.InitString = MRF + Init                          ' Do it
            MRFOpen = %True                                       ' Set MRF mode
         ELSEIF RIGHT$(Init, 1) = "?" THEN                        ' Prepend InitString?
            gENV.InitString = Init + MRF                          ' Do it
            MRFOpen = %True                                       ' Set MRF mode
         ELSE                                                     ' Replace it then
            gENV.InitString = Init                                '
         END IF                                                   '
         gSQL.UpdateString("O", "MRFList", "")                    ' Kill list so it is only used once
      ELSE                                                        ' No re-open would have been done
         IF LEFT$(Init, 1) = "?" THEN Init = CLIP$(LEFT, Init, 1) ' Remove extraneous ?
         IF RIGHT$(Init, 1) = "?" THEN Init = CLIP$(RIGHT, Init, 1)  ' Remove extraneous ?
         gENV.InitString = Init                                   ' Save it back
         gSQL.UpdateString("O", "MRFList", "")                    ' Kill list so it is only used once
      END IF                                                      '
   ELSE                                                           ' No command line data
      IF gENV.ReOpenLast AND ISNOTNULL(MRF) THEN                  ' Re-open possible?
         gENV.InitString = MRF                                    ' Save it back
         MRFOpen = %True                                          ' Set MRF mode
         gSQL.UpdateString("O", "MRFList", "")                    ' Kill list so it is only used once
      END IF                                                      '
   END IF                                                         '

   TabAddFManager                                                 ' Add the FM tab

   '-----------------------------------------------------------------------------------------------+
   '- Create a dummy invisible basic screen to get font sizes                                      |
   '-----------------------------------------------------------------------------------------------+
   gResizeActive = %True                                          ' Stop WindowSize during early Init
   DIALOG NEW PIXELS, 0, "SPFLite", gENV.LastScreenX + (i * 15), gENV.LastScreenY + (i * 15), 200, 200, _   '
          %WS_CAPTION OR %WS_THICKFRAME OR %WS_MINIMIZEBOX OR %WS_SYSMENU OR %WS_OVERLAPPEDWINDOW OR %WS_CLIPCHILDREN OR _ '
          %WS_DISABLED, 0 TO ghWnd                                '

   DIALOG SET ICON ghWnd, "A"                                     ' Set TitleBaR Icon
   DIALOG SET COLOR ghWnd, %RGB_WHITE, %RGB_DIMGRAY               ' Default color it
   DragAcceptFiles ghWnd, %TRUE                                   ' Turn on Drag/Drop
   DIALOG SHOW STATE ghWnd, %SW_HIDE                              ' Hide it

   '-----------------------------------------------------------------------------------------------+
   '- Create a dummy Graphic window just to get Font sizes                                         |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD GRAPHIC, ghWnd, %IDC_SPFLiteWindow, "", 0, 0, 100, 100   '
   GRAPHIC ATTACH ghWnd, %IDC_SPFLiteWindow                       ' Attach it

   '-----------------------------------------------------------------------------------------------+
   '- Continue                                                                                     |
   '-----------------------------------------------------------------------------------------------+
   FONT NEW gENV.FontName, gENV.FontPitch, gENV.FontStyle, 1, 1 TO gScrFont   ' Get the basic font
   FONT NEW gENV.FontName, gENV.FontPitch, gENV.FontStyle + 4, 1, 1 TO gScrFontUnd  ' Get the underline version of the basic font
   FONT NEW gENV.FontName, gENV.FontPitch, gENV.FontStyle + 8, 1, 1 TO gScrFontStrike  ' Get the strikethrough version of the basic font
   FONT NEW "Courier New", gENV.FontPitch, 1, 1, 1 TO gScrCourier ' Get a normal Courier
   GRAPHIC SET FONT gScrFont                                      ' Set the desired font

   GRAPHIC CELL SIZE TO gFontWidth, gFontHeight                   ' Get size of a character
   CONTROL KILL ghWnd, %IDC_SPFLiteWindow                         ' Kill dummy graphic area

   '-----------------------------------------------------------------------------------------------+
   '- Add the StatusBar                                                                            |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD STATUSBAR, ghWnd, %IDC_StatusBar, "", 0, 0, 0, 0, %CCS_BOTTOM, %WS_EX_WINDOWEDGE ' Add the Status Bar
   CONTROL HANDLE ghWnd, %IDC_StatusBar TO ghStatusBar            ' Save its handle
   CONTROL SET FONT   ghWnd, %IDC_StatusBar, gSBFont              ' Set font
   CONTROL GET SIZE   ghWnd, %IDC_StatusBar TO gSBWidth, gSBHeight   ' Get the SB size
   gSBHeight += 4                                                 ' Make it a bit bigger

   '-----------------------------------------------------------------------------------------------+
   '- Now calc our needed Graphic Window size                                                      |
   '-----------------------------------------------------------------------------------------------+
   x = (gENV.ScrWidth * gFontWidth) + %GLM + %GRM                 ' + the LM and RM pad values
   y = (gENV.ScrHeight * gFontHeight)                             ' Y

   '-----------------------------------------------------------------------------------------------+
   '- Now add a Tab control with no sizes yet                                                      |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD TAB, ghWnd, %IDC_SPFLiteTAB, "", 0, 0, 0, 0, %TCS_OWNERDRAWFIXED  '
   CONTROL HANDLE ghWnd, %IDC_SPFLiteTab TO ghTab                 ' Get handle for Tab
   CONTROL SET FONT ghWnd, %IDC_SPFLiteTAB, gSBFont               '
   CONTROL SET COLOR ghWnd, %IDC_SPFLiteTAB, gStatFG, gStatBG1    ' Default color it

   '-----------------------------------------------------------------------------------------------+
   '- Set Rect to our needed Graphic size and then set the Tab to that size                        |
   '-----------------------------------------------------------------------------------------------+
   gTabRC.Top = 0:      gTabRC.Left = 0                           ' Init Tab Rect
   gTabRC.Right = x: gTabRC.Bottom = y                            '
   TabCtrl_AdjustRect ghTab, 1, gTabRC                            ' Set Tab display to suit graphic
   TabCtrl_GetItemRect ghTab, 1, gTabHdrRC                        ' Get Tab title dimensions .Bottom = height
   CONTROL SET SIZE ghWnd, %IDC_SPFLiteTAB, gTabRC.Right - gTabRC.Left, gTabRC.Bottom - gTabRC.Top + gTabHdrRC.Bottom   '

   '-----------------------------------------------------------------------------------------------+
   '- Add the scrollbar                                                                            |
   '-----------------------------------------------------------------------------------------------+
   IF gENV.VScrollBar THEN                                        '
      CONTROL ADD SCROLLBAR, ghWnd, %IDC_ScrollBar, "", gTabRC.Right + 1, 0, _   '
                          gScrlWidth, gTabRC.Bottom - gTabHdrRC.Bottom, _  '
                          %SBS_VERT OR %SBS_RIGHTALIGN, CALL DlgScrollCallback   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Insert a page (will be used for the FM)                                                      |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghWnd, %IDC_SPFLiteTAB, TP.PgNumber, 0, $New, CALL DlgCallBack TO h '
   TP.PgHandle = h                                                ' Save the handle

   '-----------------------------------------------------------------------------------------------+
   '- Add our Graphic window to the new Page                                                       |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD GRAPHIC, TP.PgHandle, TP.WindowID, "", 0, 0, x, y  '
   CONTROL HANDLE TP.PgHandle, TP.WindowID TO h                   ' Save handle to graphic window
   TP.gHandle = h                                                 '
   GRAPHIC ATTACH TP.PgHandle, TP.WindowID                        ' Set as the default graphic area
   GRAPHIC CLEAR gTxtLoBG1                                        ' Clear the background
   TP.cCurrent = %False                                           ' Set cursor state
   GRAPHIC SET FONT gScrFont                                      ' Set the font
   TP.ScreenDim(gENV.ScrWidth)                                    ' Redim the Screen shadow copy
   GRAPHIC GET DC TO hDC                                          ' Get the DC for the graphic window
   gValidChars = FontGetValidChars(hDC)                           ' Build the valid chars list for this font

   '-----------------------------------------------------------------------------------------------+
   '- Now get the actual Tab size                                                                  |
   '-----------------------------------------------------------------------------------------------+
   CONTROL GET SIZE ghWnd, %IDC_SPFLiteTAB TO nx, ny              ' Now get the tab size
   DIALOG SET CLIENT ghWnd, nx + gScrlWidth, ny + gSBHeight       ' Resize the whole dialog, allowing for the headers

   '-----------------------------------------------------------------------------------------------+
   '- Calc some dependent values based on the screen size                                          |
   '-----------------------------------------------------------------------------------------------+
   gFMLayout = gENV.FMLayout: gFMLayoutID = "S"                   ' Setup a default layout
   IF ISFALSE InitFMLayout THEN _                                 ' If validated OK
      gFMFNameSz = gFMC(1).CSize                                  ' Save standard FNAME field size
   StatusBarSetup                                                 ' Setup the status bar
   gResizeActive = %False                                         ' Free WindowSize lock

   WindowSize                                                     ' Setup panel variables

   '-----------------------------------------------------------------------------------------------+
   '- Pretty up the display                                                                        |
   '-----------------------------------------------------------------------------------------------+
   TP.WindowTitle                                                 ' Alter window/Tab titles
   SetCmd                                                         ' Put cursor to command line
   TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber                 ' Select the FM Tab
   GRAPHIC REDRAW                                                 '
   DoCursor                                                       '
   TP.FCB_.SetupFN($New, %ProfGetY, RCA)                          ' Setup the FCB for FM
   '-----------------------------------------------------------------------------------------------+
   '- Open either CLIP mode or the InitFiles default                                               |
   '-----------------------------------------------------------------------------------------------+
   IF gENV.InitClip THEN                                          ' -CLIP mode
      pCmdCLIP("CLIP ")                                           ' Go do it

   ELSEIF ISNOTNULL(gENV.InitString) AND (gENV.PMode AND %GOFM) = 0 THEN   ' Got an Init value?
      GOSUB InitFiles                                             ' Go open the tabs
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Start the loop watching thread                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE IsPBDebuggerOn AND _                                ' Only if not in debugger
      ISFALSE gENV.NoLoopMode THEN                                ' and not NOLOOP mode
      THREAD CREATE DoLoopDetect(parmp) 65536, TO tHndl           ' Fire up the thread
      SLEEP 50                                                    ' Wait a bit
      THREAD STATUS tHndl TO tResult                              ' See if running OK
      THREAD CLOSE tHndl TO tResult                               ' Free up our handle
      gLoopThread = %True                                         ' Remember we started it
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- If a DO macro, schedule it                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF gENV.iDo <> "" THEN                                         ' Was there a DO macro?
      i = DOCmdLoadMac(gENV.iDo)                                  ' Get the specified DO file loaded to gCmdList()
      IF i = 0 THEN _                                             '
         DoMessageBox "Error loading " + gENV.iDo + ".DO file", %MB_OK OR %MB_USERICON, "SPFLite - DO file error" '
   END IF                                                         '
   IF UBOUND(gCmdList()) > 0 THEN                                 ' Pending commands?
      MID$(DMsg.kbString, 1, 4) = CHR$(5, 0, 0, 0)                ' Flag as Msg type 5 - DO execute
      i = PostMessage(ghWnd, %WM_USER, DMsg.MsgwParam, 0)         ' To the mainline Callback routine
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Finally show the Dialog and let it run                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF ghPatience THEN DIALOG END ghPatience                       ' Shut down Patience if active
   DOCmdAdd("(Enter)")                                            ' Stuff an initial (Enter) to trigger status line
   gENV.SetINITimeStamp                                           ' Timestamp initial settings
   IF gENV.Maximized THEN                                         ' Start in Maximized?
      DIALOG MAXIMIZE ghWnd                                       ' Return to that state
      WindowPlacementRestore                                      ' Reset the Restore screen values
   END IF                                                         '
   IF ISFALSE gENV.QuietMode THEN DIALOG SHOW STATE ghWnd, IIF(gENV.Maximized, %SW_SHOWMAXIMIZED, %SW_SHOW)  ' Un-Hide it
   ENABLEWINDOW(ghWnd, %True)                                     ' Remove disabled status
   ForceVisibleDisplay (ghWnd)                                    ' Ensure window is visible
   CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB                       ' Set focus
   DIALOG SHOW MODELESS ghWnd CALL DlgCallback                    ' Fire up the main Dialog
   DO                                                             ' Spin here
      DIALOG DOEVENTS                                             ' Let others work
      IF ghDebug THEN                                             ' If DEBUG window open
'         IF TXT.INSTAT THEN                                       ' and a key available
'            debug FORMAT$(ASC(TXT.INKEY$))                        '
'         END IF                                                   '
      END IF                                                      '
   LOOP WHILE ISWIN(ghWnd)                                        '

   '-----------------------------------------------------------------------------------------------+
   '- Finally, shut it down and close the CFG file                                                 |
   '-----------------------------------------------------------------------------------------------+
   Shutit:                                                        '
'  SETUNHANDLEDEXCEPTIONFILTER %Null                              ' Kill exception trap
   gSQL.VacuumDB                                                  ' Vacuum CFG
   gSQL.DBClose                                                   ' Close the CFG file
   MExitFunc                                                      '

'--------------------------------------------------------------------------------------------------+
'- Open either the $CMDLINE filename or MRF list                                                   |
'--------------------------------------------------------------------------------------------------+

InitFiles:                                                        '
   DoInitString(gENV.InitString, gENV.InitProfile, gENV.InitMacro, gENV.InitXForm, MRFOpen)  '
   gENV.InitString = ""                                           ' Reset
   gENV.InitProfile = ""                                          '
   gENV.InitMacro = ""                                            '
   gENV.InitXForm = ""                                            '
   RETURN                                                         '
END FUNCTION                                                      '
#INCLUDE "InitRoutines.INC"                                       ' Initialization Stuff
#INCLUDE "DialogStuff.INC"                                        ' Dialog Display and CallBacks
#INCLUDE "Mainline.INC"                                           ' Mainline
#INCLUDE "BMacro.INC"                                             ' thinBasic Macro Interface


SUB      BGBandEdit(lno AS LONG)                                  '
'--------------------------------------------------------------------------------------------------+
'- Calc banding value                                                                              |
'--------------------------------------------------------------------------------------------------+
   gBandBG = %False                                               ' Start as not needed
   IF lno <= (2 + TP.FCB_.Cols) THEN EXIT SUB                     ' Off if in Title area
   IF ISTRUE gENV.Banding THEN                                    ' Are we banding?
      gBandBG = IIF((lno) \ 3 MOD 2 = 0, %True, %False)           ' Setup based on line number
   END IF                                                         '
END SUB                                                           '

SUB      BKPAddPath(cPath AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Add (possibly) a new Backup path                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG, nPath AS STRING                               '
   nPath = cPath                                                  ' Copy it
   IF RIGHT$(nPath, 1) <> "\" THEN nPath += "\"                   ' Ensure it ends with a \
   j = UBOUND(gBKPList())                                         '

   '-----------------------------------------------------------------------------------------------+
   '- If no table exists                                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF j = 0 THEN                                                  ' UBOUND=0
      REDIM gBKPList(1 TO 1) AS GLOBAL STRING                     ' DIM it as 1 entry
      gBKPList(1) = nPath                                         ' Add it to empty slot
      SQLArraySave("BDEFAULT", gBKPList())                        ' Let SQLArraySave tuck it away
      EXIT SUB                                                    ' We're done
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- See if already in table                                                                      |
   '-----------------------------------------------------------------------------------------------+
   ARRAY SCAN gBKPList(), COLLATE UCASE, =nPath, TO i             ' See if it's already here
   IF i THEN EXIT SUB                                             ' All done if it is

   '-----------------------------------------------------------------------------------------------+
   '- Not present we must add it                                                                   |
   '-----------------------------------------------------------------------------------------------+
   INCR j                                                         ' Bump UBOUND
   REDIM PRESERVE gBKPList(1 TO j) AS GLOBAL STRING               ' Increase table
   gBKPList(j) = nPath                                            ' Add it to empty slot
   SQLArraySave("BDEFAULT", gBKPList())                           ' Let SQLArraySave do the work
END SUB                                                           '

SUB      BKPDelPath(cPath AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Delete a Backup path                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, nPath AS STRING                                  '
   nPath = cPath                                                  ' Copy it
   IF RIGHT$(nPath, 1) <> "\" THEN nPath += "\"                   ' Ensure it ends with a \
   ARRAY SCAN gBKPList(), COLLATE UCASE, =nPath, TO i             ' See if it's already here
   IF i = 0 THEN EXIT SUB                                         ' All done if not found
   ARRAY DELETE gBKPList(i)                                       ' Delete the entry
   REDIM PRESERVE gBKPList(1 TO UBOUND(gBKPlist()) - 1) AS GLOBAL STRING   ' Decrease table by one
   SQLArraySave("BDEFAULT", gBKPList())                           ' Let SQLArraySave do the work
END SUB                                                           '

SUB     BKPDoRetention(RPath AS STRING, CleanFolder AS LONG)      '
'--------------------------------------------------------------------------------------------------+
'- Apply Retention test to a path                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, m, BKPStart, BKPEnd, BKPCtr AS LONG                '
LOCAL RetTbl() AS RetTable, RetCtr AS LONG                        '
LOCAL TSTFileName, t, u, BKPTName, DelFile AS STRING              '
LOCAL RetFD AS DIRDATA                                            '

DIM RetTbl(1 TO 100) AS RetTable                                  '
   '-----------------------------------------------------------------------------------------------+
   '- Find all existing Backups                                                                    |
   '-----------------------------------------------------------------------------------------------+
   TSTFileName = RPath + "\*"                                     ' Build generic find all files
   u = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")         ' Look for our timestamp pattern
   t = DIR$(TSTFileName, TO RetFD)                                ' Look for Backups
   DO WHILE ISNOTNULL(t)                                          ' While we're getting entries
      PCRERegexTest(t, 1, j, k)                                   ' See if has our pattern
      IF j  AND RIGHT$(t, 6) <> ".STATE" THEN                     ' Got one, and NOT a STATE file
         INCR RetCtr                                              ' Bump counter
         IF RetCtr > UBOUND(RetTbl()) THEN REDIM PRESERVE RetTbl(1 TO 2 * RetCtr) AS RetTable   '
         RetTbl(RetCtr).BKPName = UUCASE(t)                       ' Stuff data into the table
         RetTbl(RetCtr).BKPDate = MID$(t, j + 15, 6)              '
         RetTbl(RetCtr).BKPFDate = MID$(t, j + 1, 13)             '
      END IF                                                      '
      t = DIR$(NEXT)                                              ' Get next entry
   LOOP                                                           ' Done the search
   ARRAY SORT RetTbl() FOR RetCtr, COLLATE UCASE                  ' Sort just in case

   FOR i = 1 TO RetCtr                                            ' Loop through the table
      '--------------------------------------------------------------------------------------------+
      '- Look for change of name                                                                   |
      '--------------------------------------------------------------------------------------------+
      PCRERegexTest(TRIM$(RetTbl(i).BKPName), 1, j, k)            ' Locate timestamp
      IF BKPTName <> LEFT$(RetTbl(i).BKPName, j - 1) THEN         ' It's changed
         IF BKPCtr > 0 THEN GOSUB Evaluate                        ' Do we have a set? Yes, Evaluate it
         BkpStart = i: BKPEnd = i: BKPCtr = 1                     ' Start a block
         BKPTName = LEFT$(RetTbl(i).BKPName, j - 1)               '
      ELSE                                                        ' Same name
         BKPEnd = i                                               ' Adjust end of block
         INCR BKPCtr                                              ' Count it in the block
      END IF                                                      '
   NEXT i                                                         ' Loop back
   IF BKPCtr > 0 THEN GOSUB Evaluate                              ' Do the last set

   '-----------------------------------------------------------------------------------------------+
   '- See if $BACKUP folder is now empty                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF CleanFolder THEN                                            ' Allowed to remove $BACKUP folder ?
      t = DIR$(TSTFileName, TO RetFD)                             ' Look for any file in the folder
      IF t = "" THEN                                              ' Yes, looks empty
         TRY                                                      '
            RMDIR RPath                                           ' Delete it
            BKPDelPath(RPath)                                     ' remove from BKPList of backup folders
         CATCH                                                    '
                                                                  '                                                     '
         END TRY                                                  '
      END IF                                                      '
   END IF                                                         '
   EXIT SUB                                                       '

Evaluate:                                                         '
    '----------------------------------------------------------------------------------------------+
                                                                  ' First see if Max generations are exceeded
    '----------------------------------------------------------------------------------------------+
    IF gENV.BKPMaxGen > 0 THEN                                    '
       k = (BkpEnd - BKPStart + 1) - gENV.BKPMaxGen               ' Calc how many over the max
       IF k > 0 THEN                                              ' If we have some to get rid of
          DO WHILE k > 0                                          '
             DelFile = RetTbl(BKPStart).BKPName                   ' Setup name to be deleted
             GOSUB RetDelete                                      ' Go delete it
             INCR  BKPStart: DECR k                               '
          LOOP                                                    '
       END IF                                                     '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  ' Now do Expiry test ones
    '----------------------------------------------------------------------------------------------+
    IF gENV.BKPRetention = 0 THEN RETURN                          ' User said no expiry, so we're done here
    IF gENV.BKPMinGen > 0 THEN                                    ' Is there a MinGen parameter?
       IF (BkpEnd - BKPStart + 1) <= gENV.BKPMinGen THEN RETURN   ' Got MinGen, If not over the minimum, we're also done
    END IF                                                        '
    m = (BkpEnd - BKPStart + 1) - gENV.BKPMinGen                  ' Calc max number to eliminate due to Ret
    FOR k = BKPStart TO BKPEnd                                    ' Loop through the available items
       IF GetNumDaysSince(MID$(RetTbl(k).BKPDate, 3, 2) + "-" + RIGHT$(RetTbl(k).BKPDate, 2) + "-20" + LEFT$(RetTbl(k).BKPDate, 2)) > gENV.BKPRetention THEN   ' If more than Expiry days old
          DelFile = RetTbl(k).BKPName                             ' Setup name to be deleted
          GOSUB RetDelete                                         ' Go delete it
          DECR m: IF m = 0 THEN EXIT FOR                          ' Done all we should?  Then Exit
       END IF                                                     '
    NEXT k                                                        '
    RETURN                                                        '
RetDelete:                                                        '
    KILL RPath + "\" + Delfile                                    ' Build full delete name and Kill it
    IF ISFILE(RPath + "\" + Delfile + ".STATE") THEN _            ' If a STATE file
       KILL RPath + "\" + Delfile + ".STATE"                      ' Delete it
    RETURN                                                        '
END SUB                                                           '

FUNCTION BuildMRF(cTab AS LONG) AS STRING                         '
'--------------------------------------------------------------------------------------------------+
'- Build an MRF list for the current state                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG, MRF, TabType, mnames AS STRING                '
   FOR i = gTabsNum TO 1 STEP -1                                  ' Do for each tab

      TP = gTabs(i)                                               ' Pick the Tab
      IF TP.LastLine < 3 OR TP.PgNumber = 1 THEN ITERATE FOR      ' Ignore empty tabs
      IF TP.XFormActive <> "" THEN ITERATE FOR                    ' XFORM running? Also ignore

      IF ISFALSE IsClip AND ISFALSE IsSetEdit AND ISFALSE IsEFTEdit THEN   ' Are we not in ClipBoard/SetEdit Mode?
         TabType = IIF$(IsBrowse , "(B)", IIF$(IsView, "(V)", "(E)"))   ' Set basic Tab Type
         IF cTab = TP.PgNumber THEN TabType = LCASE$(TabType)     ' Lowercase the active tab
      END IF                                                      '

      IF ISFALSE IsMedit AND ISFALSE IsClip AND ISFALSE IsSetEdit AND ISFALSE IsEFTEdit THEN ' If not oddball type
         IF TP.FCB_.FilePath <> $New THEN _                       '
            mrf = TabType + TP.FCB_.FilePath + IIF$(ISNULL(mrf), "", "?") + mrf  ' Add the open filename

      ELSEIF IsMEdit THEN                                         ' It's a MEdit session
         FOR j = TP.MEditCount TO 1 STEP -1                       ' Put all the names in a string
            mnames = TP.MEditListGet(j) + IIF$(ISNULL(mnames), "", "|") + mnames '
         NEXT j                                                   '
         IF ISNOTNULL(mnames) THEN _                              '
            mrf = TabType + mnames + IIF$(ISNULL(mrf), "", "?") + mrf   ' Add the mnames string
            mnames = ""                                           ' Reset mnames
      END IF                                                      '
   NEXT i                                                         '
   FUNCTION = MRF                                                 ' Pass back the result
END FUNCTION                                                      '

SUB      CaretCreate()                                            '
'--------------------------------------------------------------------------------------------------+
'- Create caret based on current settings                                                          |
'--------------------------------------------------------------------------------------------------+
   IF ISTRUE IsTPNSrtFlag THEN                                    ' Want an Insert mode cursor?
      IF ISTRUE gENV.VertInsCurs THEN                             ' Want a Vertical Insert cursor?
         CreateCaret(TP.gHandle, 0, 2, gFontHeight)               ' Create a vertical bar
      ELSE                                                        ' No, normal 'blob' cursor
         CreateCaret(TP.gHandle, 0, gFontWidth, INT((gFontHeight * gENV.CursInsert / 100)))  ' Create an Insert blob
      END IF                                                      '
   ELSE                                                           ' No, we want an ordinary cursor
      CreateCaret(TP.gHandle, 0, gFontWidth, INT((gFontHeight * gENV.CursNormal / 100)))  ' Create an Insert blob
   END IF                                                         '
END SUB                                                           '

SUB      CaretDestroy()                                           '
'--------------------------------------------------------------------------------------------------+
'- Destroy the Caret                                                                               |
'--------------------------------------------------------------------------------------------------+
   DestroyCaret()                                                 ' Destroy it
   gCaretCtr = 0                                                  ' Clear counter
END SUB                                                           '

SUB      CaretSet(lx AS LONG, ly AS LONG)                         '
'--------------------------------------------------------------------------------------------------+
'- Set Caret to current cursor location                                                            |
'--------------------------------------------------------------------------------------------------+
   IF ISFALSE gENV.VertInsCurs THEN                               ' If normal blob cursors
      IF ISFALSE IsTPNSrtFlag THEN                                ' And not insert mode
         SetCaretPos (lx, ly - INT((gFontHeight * gENV.CursNormal / 100))) ' Just set a normal position
      ELSE                                                        '
         SetCaretPos (lx, ly - INT((gFontHeight * gENV.CursInsert / 100))) ' Just set a normal position
      END IF                                                      '
   ELSE                                                           ' Maybe a vertical cursor
      IF ISFALSE IsTPNSrtFlag THEN                                ' Doing non insert cursor
         SetCaretPos (lx, ly - INT((gFontHeight * gENV.CursNormal / 100))) ' Just set a normal position
      ELSE                                                        ' Doing vertical Insert cursor
         SetCaretPos (lx - 1, ly - gFontHeight)                   ' Position for it
      END IF                                                      '
   END IF                                                         '
END SUB                                                           '

SUB      CaretShow()                                              '
'--------------------------------------------------------------------------------------------------+
'- Show the Caret                                                                                  |
'--------------------------------------------------------------------------------------------------+
   IF gCaretCtr = 0 THEN                                          ' Only do it once
      ShowCaret(TP.gHandle)                                       ' Show the caret
      INCR gCaretCtr                                              ' Count it
   END IF                                                         '
END SUB                                                           '

SUB      CaretHide()                                              '
'--------------------------------------------------------------------------------------------------+
'- Hide the Caret                                                                                  |
'--------------------------------------------------------------------------------------------------+
   DO WHILE gCaretCtr > 0                                         ' Only while ctr is > 0
      HideCaret(TP.gHandle)                                       ' Hide the caret
      DECR gCaretCtr                                              ' Reduce count
   LOOP                                                           '
END SUB                                                           '

FUNCTION ClipBoardGet(CBDString AS STRING) AS LONG                '
'--------------------------------------------------------------------------------------------------+
'- GET the Windows clipboard                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL RC AS LONG                                                  '
   MEntry                                                         '
   CBDString = CHR$(250, 252, 254)                                ' Set something oddball
   DO                                                             ' Loop till something comes in
      CLIPBOARD GET TEXT TO CBDString, RC                         '
      IF ISTRUE RC THEN EXIT DO                                   '
      IF CBDString <> CHR$(250, 252, 254) THEN EXIT DO            ' Something (even null) came in
   LOOP                                                           '
   FUNCTION = %True                                               '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION ClipboardRead(CBData AS STRING, dlm AS STRING, EraseIt AS LONG) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Read Clipboard for the caller                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lclPrimOper AS STRING, FNum AS LONG                         '

   MEntry                                                         '
   lclPrimOper = gKeyPrimOper                                     '
   IF LEFT$(lclPrimOper, 4) = "$RAW" OR LEFT$(lclPrimOper, 4) = "$RAA" THEN _ '
      lclPrimOper = MID$(lclPrimOper, 5)                          '
   dlm = $CRLF                                                    ' Use a std delimiter
   CBData = ""                                                    ' Start as null

   '-----------------------------------------------------------------------------------------------+
   '- See which Clipboard to read                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(lclPrimOper) THEN                                    ' If no operand, use normal Clipboard
      ClipBoardGet(CBData)                                        ' Read from Win Clipboard; data required


   ELSEIF lclPrimOper = "|InternalCB" THEN                        ' The internal CBD?
      CBData = gInternalCB                                        ' Yes, return it

   ELSE                                                           '
      FNum = FREEFILE                                             ' Get a file number
      Call2(TryOpenBinaryIn(gENV.Homedata + "CLIP\" + lclPrimOper + ".CLIP", FNum), _   ' Try the Opem
            TP.ErrMsgAdd(%eFail, "OPEN of Clipboard File: " + lclPrimOper + " failed"): MExitFunc, _  '
            Nul)                                                  ' Continue if OK
      GET$ # FNum, LOF(FNum), CBData                              ' Get whole file in one gulp
      CLOSE # FNum                                                ' Close the FBO
      IF EraseIt THEN FileRecycleBin(gENV.Homedata + "CLIP\" + lclPrimOper + ".CLIP", "D") ' If ERASE then delete the CLIP file
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Figure out delimiters; if none of these found, 'dlm' retains value set by caller             |
   '-----------------------------------------------------------------------------------------------+

   IF INSTR(CBData, $CRLF) THEN                                   ' See what kind of delimiters
      dlm = $CRLF                                                 ' CRLF
   ELSEIF INSTR(CBData, $CR) THEN                                 '
      dlm = $CR                                                   ' CR
   ELSEIF INSTR(CBData, $LF) THEN                                 '
      dlm = $LF                                                   ' LF
   END IF                                                         '
   MExitFunc                                                      '
END FUNCTION                                                      '

FUNCTION ClipBoardSet(CBDString AS STRING) AS LONG                '''
'--------------------------------------------------------------------------------------------------+
'- SET the Windows clipboard                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL RC AS LONG                                                  '
   MEntry                                                         '
   DO                                                             ' Empty the Clipboard
      CLIPBOARD RESET, RC                                         '
   LOOP UNTIL ISTRUE RC                                           '
   DO                                                             ' Write the Clipboard
      CLIPBOARD SET TEXT CBDString, RC                            '
   LOOP UNTIL ISTRUE RC                                           '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION ClipboardWrite(CBData AS STRING) AS LONG                 '
'--------------------------------------------------------------------------------------------------+
'- Write string to normal or private clipboard                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL FNum AS LONG, Fn AS STRING                                  '

   MEntry                                                         '
   IF INSTR(CBData, CHR$(0)) THEN _                               '
      TP.ErrMsgAdd(%eFail, "Data contains a NULL X'00' character, not allowed"): MExitFunc   ' Oops? Bail OUT

   '-----------------------------------------------------------------------------------------------+
   '- Stuff it in the clipboard                                                                    |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(gKeyPrimOper) THEN                                   ' If no operand, use normal Clipboard
      ClipBoardSet(CBData)                                        ' Write to Windows clipboard, null string OK
      FUNCTION = %True                                            ' Pass back result

   ELSE                                                           '
      IF ISNOTNULL(CBData) THEN                                   ' If something to save
         Fn = gENV.Homedata + "CLIP\" + gKeyPrimOper + ".CLIP"    ' Set filename
         FNum = FREEFILE                                          ' Get a file number
         Call3(TryOpenOutPut(Fn, FNum), _                         ' Try the open
               TP.ErrMsgAdd(%eFail, "Clipboard Write Open failed"): MExitFunc, _ ' Oops?  Bail out
               TP.ErrMsgAdd(%eFail, "Clipboard File is in use"): MExitFunc, _ ' In Use, Bail out
               Nul)                                               ' OK, continue
         PRINT # FNum, CBData;                                    ' Write the data
         CLOSE # FNum                                             ' Close the file
      ELSE                                                        '
         FileRecycleBin(gENV.Homedata + "CLIP\" + gKeyPrimOper + ".CLIP", "D") ' Delete any CLIP file
      END IF                                                      '
      FUNCTION = %True                                            ' Say all is well
   END IF                                                         '
   MExitFunc                                                      '
END FUNCTION                                                      '

SUB      CmdLog(ctype AS STRING, ccmd AS STRING, OpenClose AS LONG)  '
LOCAL t1, t2, t3 AS STRING                                        '
'--------------------------------------------------------------------------------------------------+
'- Write a CmdLog entry                                                                            |
'--------------------------------------------------------------------------------------------------+
   IF ISFALSE gCmdLogFlag THEN EXIT SUB                           ' Not even active
   t1 = TIME$: t2 = IIF$(OpenClose, "Start: ", "Ended: ")         ' Build text pieces                                            ' Get the time
   t3= BUILD$(t1, " ", ctype, " ", t2, ccmd)                      ' Build the string
   PRINT # gCmdLogFn, t3                                          ' Write the command out.
   FLUSH # gCmdLogFn                                              ' FLUSH it out
END SUB                                                           '

FUNCTION DateWinFormat() AS STRING                                '
'--------------------------------------------------------------------------------------------------+
'- Return Date in Windows format                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL st AS SYSTEMTIME                                            '
LOCAL szDate AS ASCIIZ * 64, Locale, Format AS LONG               '
LOCAL szFormat AS ASCIIZ * 2, rc AS LONG                          '
LOCAL szSep AS ASCIIZ * 2, sep, MyDate AS STRING                  '
   MEntry                                                         '
   GetLocalTime st                                                '
   GetDateFormat %LOCALE_SYSTEM_DEFAULT, %DATE_SHORTDATE, st, BYVAL %Null, szDate, SIZEOF(szDate)  '
   rc = GetLocaleInfo(Locale, %LOCALE_IDATE,  szFormat, SIZEOF(szFormat))  '
   Format = VAL(szFormat)                                         '
   rc = GetLocaleInfo(Locale, %LOCALE_SDATE, szSep, SIZEOF(szSep))   '
   sep = IIF$(rc = 0, "/", szSep)                                 '
   MyDate = DATE$                                                 '
   REPLACE "-" WITH sep IN MyDate                                 '
   SELECT CASE AS LONG format                                     '
      CASE 0: FUNCTION = MyDate                                   ' mmddyyyy
      CASE 1: FUNCTION = MID$(MyDate, 4, 3) & MID$(MyDate, 1, 3) & MID$(MyDate, 7)  ' ddmmyyyy
      CASE 2: FUNCTION = MID$(MyDate, 7) & sep & MID$(MyDate, 4, 3) & MID$(MyDate, 1, 2)  ' yyyymmdd
  END SELECT                                                      '
  MExit                                                           '
END FUNCTION                                                      '

SUB Dbg(str AS STRING)                                            ' Dbg used for real debugging
   Debug(str)                                                     ' Just pass off to normal Debug
END SUB                                                           '

SUB Debug(str AS STRING)                                          ' Used for User type DEBUG stuff
   IF ghDBFn <> 0 THEN DEBUGLOG(str): EXIT SUB                    ' Pass off if DEBUGLOG active
   IF ghDBHide AND (str = "$$CLS" OR str = "$$QUIT") THEN EXIT SUB   ' A 'do nothing' request - Exit
   IF str = "$$CLS" THEN                                          ' Clear the screen?
      LISTBOX RESET ghDB, %IDC_ListBox                            ' Clear table
      RESET ghDBCtr                                               ' And the counter
      EXIT SUB                                                    '
   END IF                                                         '
   IF str = "$$QUIT" THEN                                         ' QUIT?
      LISTBOX RESET ghDB, %IDC_ListBox                            ' Clear table
      RESET ghDBCtr: ghDBHide = %True                             ' And the counter and set Hidden
      DIALOG HIDE ghDB                                            '
      EXIT SUB                                                    '
   END IF                                                         '
   IF str = "$$STOP" THEN                                         ' STOP?
      LISTBOX RESET ghDB, %IDC_ListBox                            ' Clear table
      RESET ghDBCtr                                               ' And the counter
      DIALOG END ghDB                                             ' Kill the dialog
      EXIT SUB                                                    '
   END IF                                                         '

   IF ghDBHide THEN DIALOG NORMALIZE ghDB: ghDBHide = %False      '
   LISTBOX ADD ghDB, %IDC_ListBox, TIME$ + " " + Str TO ghDBCtr   '
   SendMessage ghDBListBox, %LB_SETTOPINDEX, MAX(0, ghDBCtr - ghDBLines + 1), 0  '
END SUB                                                           '

THREAD FUNCTION Debug2(BYVAL x AS LONG) AS LONG                   '
LOCAL rc AS RECT                                                  '
   '--------------------------------------------------------------------------------------------------+
   '- Initialize the Debug Window                                                                     |
   '--------------------------------------------------------------------------------------------------+
   DIALOG DEFAULT FONT "Courier New Bold", 10, 1                  ' Set default font
   DIALOG NEW PIXELS, 0, "SPFLite Debug Console", 10, 10, 1200, 750, %WS_SYSMENU TO ghDB  '
   CONTROL ADD LISTBOX, ghDB, %IDC_ListBox, , 10, 10, 1200, 740, _   '
                        %LBS_DISABLENOSCROLL OR %WS_HSCROLL OR %WS_VSCROLL OR %LBS_EXTENDEDSEL  '
   CONTROL HANDLE ghDB, %IDC_ListBox TO ghDBListBox               ' handle to ListBox
   DIALOG HIDE ghDB                                               ' Hide till someting happens
   ghDBHide = %True                                               ' Remember it's hidden
   GetClientRect(ghDBListBox, rc)                                 ' Get the client area of the listbox
   ghDBLines = (rc.Bottom - rc.Top) / SendMessage(ghDBListBox, %LB_GETITEMHEIGHT, 0, 0)   ' Calculate the number of visible items
   SendMessage(ghDBListBox,  %LB_SETHORIZONTALEXTENT, 2000, 0)    ' Set Horizontal width
   DIALOG SHOW MODAL ghDB, CALL DBDebugCallback                   ' Fire it up
END FUNCTION                                                      '

SUB      DEBUGLOG (st AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Print stuff to a file log                                                                       |
'--------------------------------------------------------------------------------------------------+
STATIC LastFile AS STRING                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Allocate a file if we haven't already done so                                                |
   '-----------------------------------------------------------------------------------------------+
   IF ghDBFn = 0 THEN                                             ' No Log currently?
      IF st = "$$QUIT" THEN EXIT SUB                              ' CLOSE but not even open? Ignore it
      ghDBFn = FREEFILE                                           ' Alloc a file number
      IF ghdbfName = "" THEN ghdbfName = "D:\DB"+ DATE$ + STR$(RND(1, 1000)) + ".TXT"  '
      IF LastFile = ghDBFName THEN                                ' If this is the same file as last time
         OPEN ghDBFName FOR APPEND AS # ghDBFn                    ' Open it in APPEND mode
         PRINT #ghDBFn, TIME$ + " Appending new Debug Data"       '
      ELSE                                                        ' Else
         OPEN ghDBFName FOR OUTPUT AS # ghDBFn                    ' Open it for normal Output
      END IF                                                      '
      LastFile = ghDBFName                                        ' Save as last opened one
   END IF                                                         '

   IF st = "$$QUIT" THEN                                          ' CLOSE request?
      CLOSE # ghDBFn                                              ' Do so
      ghDBFn = 0: ghDBFName = ""                                  ' Reset Fn and FName
   ELSE                                                           '
      PRINT #ghDBFn, TIME$ + " " + st                             '
      FLUSH #ghDBFn                                               '
   END IF                                                         '
END SUB                                                           '

SUB DiffCB(CBStr AS STRING, OPTIONAL CBMode AS STRING)            '
'--------------------------------------------------------------------------------------------------+
'- Handle clipboard for the DIFF command                                                           |
'--------------------------------------------------------------------------------------------------+
STATIC CB  AS ISTRINGBUILDERA                                     '
STATIC CBH AS ISTRINGBUILDERA                                     '
STATIC LCount AS LONG, t, th, CBName, LType AS STRING             '
   IF ISMISSING(CBMode) THEN                                      ' No specified mode?
      IF LType = "H" THEN                                         ' Header type?
         CBH.Add(CBStr + $CRLF)                                   ' Add to headers
      ELSE                                                        '
         CB.Add(CBStr + $CRLF)                                    ' Write the data
      END IF                                                      '
      INCR LCount                                                 ' Count lines
   ELSEIF CBMode = "R" THEN                                       ' RESET?
      LCount = 0                                                  ' Clear count
      CBName = ""                                                 '
      CB = CLASS "StringbuilderA"                                 ' Define CB
      CB.Clear                                                    ' Clear stringbuilder, just in case
      CB.Capacity = 65536                                         ' Set a starting capacity
      CBH = CLASS "StringbuilderA"                                ' Define CBH
      CBH.Clear                                                   ' Clear stringbuilder, just in case
      CBH.Capacity = 65536                                        ' Set a starting capacity
      IF gKeyPrimOper <> "" THEN CBName = gKeyPrimOper            ' Get Clipboard name
   ELSEIF CBMode = "H" THEN                                       ' Set Header?
      LType = "H"                                                 '
   ELSEIF CBMode = "B" THEN                                       ' Set Body?
      LType = "B"                                                 '
   ELSEIF CBMode = "W" THEN                                       ' WRITE
      th = CBH.String                                             ' Get the header string
      MID$(th, 16, 6) = FORMAT$(LCount + 1, "000000")             ' Stuff in the line count "C|SPFLite Diff 999999"
      t = CB.String                                               ' Get the body string
      gKeyPrimOper = CBName                                       ' Setup CB name
      ClipboardWrite(th + $CRLF + t)                              ' Save it all
      gKeyPrimOper = ""                                           '
      CB.Clear                                                    '
      LET CB = NOTHING                                            ' Free the stringbuilder Object
   END IF                                                         '
END SUB                                                           '

SUB DiffInitStream(x AS DiffStream, TxP AS iObjTabData, ttbl() AS STRING, sLB AS LONG, sRB AS LONG, sFlag AS LONG)   '
'--------------------------------------------------------------------------------------------------+
'- Get the streams Open                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, t, lastrec AS STRING                             '
   x.Last = 0: lastrec = "NonBlank"                               ' Reset record count, lastrec
   REDIM ttbl(0 TO TxP.LastLine) AS STRING                        ' Redim array to match save data
   FOR i = 1 TO TxP.LastLine                                      ' Copy the text lines
      IF ISTRUE (TxP.LFlagGet(i) AND %Data) THEN                  ' Only data lines

         '-----------------------------------------------------------------------------------------+
         '- Do X/NX exclusion stuff                                                                |
         '-----------------------------------------------------------------------------------------+
         IF (sFlag AND %NoX) THEN                                 ' If NoX then
            IF ISTRUE (TxP.LFlagGet(i) AND %Invisible) THEN ITERATE FOR ' Only Non-Excluded
         END IF                                                   '
         IF (sFlag AND %NoNX) THEN                                ' If NoNX then
            IF ISFALSE (TxP.LFlagGet(i) AND %Invisible) THEN ITERATE FOR   ' Only Non-User
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do Blank Lines collapse stuff                                                          |
         '-----------------------------------------------------------------------------------------+
         t = RTRIM$(TxP.LTxtGet(i))                               ' Get copy of line, trimmed
         IF ISFALSE (sFlag AND %NoMultB) THEN GOTO DiffAddRec     ' If NoMultB asked for, then skip
         IF ISNOTNULL(t) THEN                                     ' If a non-null line, this line is ok
            lastrec = t                                           ' Save as new lastrec
            GOTO DiffAddRec                                       ' Continue adding record
         END IF                                                   '
         IF ISNULL(lastrec) THEN ITERATE FOR                      ' If lastrec null as well, ignore this one
         lastrec = t                                              ' Save as new lastrec

         DiffAddRec:                                              '
         x.Last = x.Last + 1                                      ' Count
         ttbl(x.Last) = t                                         ' Copy the data
      END IF                                                      '
   NEXT i                                                         '

   x.TLine     = VARPTR(ttbl(0))                                  ' Save text table address
   x.Cursor    = 0                                                ' Init cursor
   x.Match     = 0                                                ' and match
   x.LB        = sLB                                              ' Left Bound
   x.RB        = sRB                                              ' Right Bound
   x.Flag      = sFlag                                            ' Option Flags
   IF x.Last   = 0 THEN x.Cursor = 1                              ' Push cursor past Last to mark EOF
END SUB                                                           '

FUNCTION DiffCompFiles(StrmA AS DiffStream, StrmB AS DiffStream) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- DO actual compares                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL FlipFlop, DiffMatch, i, j, k, ma, mb, ColW, mismatches AS LONG '
LOCAL t AS STRING                                                 '
   DiffMatch = %TRUE: FUNCTION = %True                            ' i.e. Beginnings of files match, all match
   IF gENV.Diff1Column THEN                                       ' Calc data column width
      ColW = TP.GPDataLen - 12                                    ' 1COLUMN
   ELSE                                                           '
      ColW = ((TP.GPDataLen - 3) \ 2) - 6                         ' 2COLUMN
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Look for Mis-Matches and Matches until we're done                                            |
   '-----------------------------------------------------------------------------------------------+
   DO                                                             '
      IF ISTRUE DiffMatch THEN                                    ' If currently matching
         '-----------------------------------------------------------------------------------------+
         '- Look for a Mis-Match                                                                   |
         '-----------------------------------------------------------------------------------------+
         DO                                                       ' Then go look for a mis-match
            IF StrmA.Cursor <= StrmA.Last THEN INCR StrmA.Cursor  ' Move to next lines
            IF StrmB.Cursor <= StrmB.Last THEN INCR StrmB.Cursor  '
            DiffMatch = DiffCompareLines(StrmA, StrmA.Cursor, StrmB, StrmB.Cursor)  ' Compare them
            IF ISTRUE DiffMatch THEN                              ' If equal
               StrmA.Match = StrmA.Cursor: StrmB.Match = StrmB.Cursor   ' Save our last matching positions

               '-----------------------------------------------------------------------------------+
               '- Display a matching line pair                                                     |
               '-----------------------------------------------------------------------------------+
               IF (gENV.DiffOnly) = 0 THEN                        ' If not DIFFONLY mode
                  IF StrmA.Cursor <= StrmA.Last THEN              ' If not the EOF match
                     IF gENV.Diff1Column THEN                     ' 1COLUMN?
                        IF (StrmA.Flag AND %UseFileB) THEN        ' Use File B on a match
                           DiffCB("N|" + FORMAT$(StrmA.Cursor, "00000 ") + FORMAT$(StrmB.Cursor, "00000 ") + StrmB.@TLine[StrmB.Cursor])  '
                        ELSE                                      '
                           DiffCB("N|" + FORMAT$(StrmA.Cursor, "00000 ") + FORMAT$(StrmB.Cursor, "00000 ") + StrmA.@TLine[StrmA.Cursor])  '
                        END IF                                    '
                     ELSE                                         '
                        DiffCB("N|" + FORMAT$(StrmA.Cursor, "00000 ") + LSET$(StrmA.@TLine[StrmA.Cursor], ColW) + _  '
                               " | " + FORMAT$(StrmB.Cursor, "00000 ") + LSET$(StrmB.@TLine[StrmB.Cursor], ColW)) '
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
            END IF                                                '
         LOOP WHILE ISTRUE DiffMatch AND StrmA.Cursor <= StrmA.Last AND StrmB.Cursor <= StrmB.Last ' Do while not EOF and still matching

      ELSE                                                        ' Or
         '-----------------------------------------------------------------------------------------+
         '- Look for a New Match                                                                   |
         '-----------------------------------------------------------------------------------------+
         FUNCTION = %FALSE                                        ' Look for a Match
         DO                                                       ' Loop while not matched
            INCR FlipFlop                                         ' Do FlipFlop (get Odd/Even)

            '--------------------------------------------------------------------------------------+
            '- Decide which way to Search                                                          |
            '--------------------------------------------------------------------------------------+
            IF (FlipFlop AND 1) = 1 THEN                          ' If ODD, advance B
               DiffMatch = DiffSearch(StrmB, StrmA)               ' Search that way
            ELSE                                                  ' Else
               DiffMatch = DiffSearch(StrmA, StrmB)               ' Search advancing A
            END IF                                                '
         LOOP WHILE ISFALSE DiffMatch                             ' Loop till we match (or EOF)

         '-----------------------------------------------------------------------------------------+
         '- We've found a match, output what we found                                              |
         '-----------------------------------------------------------------------------------------+
         IF StrmA.Cursor > StrmA.Last AND StrmB.Cursor <= StrmB.Last THEN  ' File-A ended but File-B hasn't
            StrmB.Cursor = StrmB.Last + 1                         ' Fudge EOF
         END IF                                                   '
         IF StrmA.Cursor <= StrmA.Last AND StrmB.Cursor >= StrmB.Last THEN ' File-B ended but File-A hasn't
            StrmA.Cursor = StrmA.Last + 1                         ' Fudge EOF
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- See if an Insert type, or a real mis-match                                             |
         '-----------------------------------------------------------------------------------------+
         INCR mismatches                                          ' Count mismatches
         IF ISTRUE (StrmA.Match + 1 = StrmA.Cursor) OR ISTRUE (StrmB.Match + 1 = StrmB.Cursor) THEN   ' If an Insert type mismatch
            IF ISTRUE (StrmA.Match + 1 = StrmA.Cursor) THEN       ' Display some output

               '-----------------------------------------------------------------------------------+
               '- Display an INSERT                                                                |
               '-----------------------------------------------------------------------------------+
               FOR i = StrmB.Match + 1 TO StrmB.Cursor - 1        ' Display the inserted lines
                  IF gENV.Diff1Column THEN                        ' 1COLUMN?
                     DiffCB("I|+++++ " + FORMAT$(i, "00000 ") + StrmB.@TLine[i]) '
                  ELSE                                            '
                     DiffCB("I|" + SPACE$(ColW + 6) + " > " + FORMAT$(i, "00000 ") + LSET$(StrmB.@TLine[i], ColW))   '
                  END IF                                          '
               NEXT i                                             '
            ELSE                                                  '
               '-----------------------------------------------------------------------------------+
               '- Display a DELETE                                                                 |
               '-----------------------------------------------------------------------------------+
               FOR i = StrmA.Match + 1 TO StrmA.Cursor - 1        ' Display the deleted lines
                  IF gENV.Diff1Column THEN                        ' 1COLUMN?
                     DiffCB("D|" + FORMAT$(i, "00000 ") + "----- " + StrmA.@TLine[i])  '
                  ELSE                                            '
                     DiffCB("D|" + FORMAT$(i, "00000 ") + LSET$(StrmA.@TLine[i], ColW) + " < " + SPACE$(ColW + 6))   '
                  END IF                                          '
               NEXT i                                             '
            END IF                                                '
         ELSE                                                     '
            '--------------------------------------------------------------------------------------+
            '- Display a plain mis-match                                                           |
            '--------------------------------------------------------------------------------------+
            IF gENV.Diff1Column THEN                              ' 1 column?
               FOR i = StrmA.Match + 1 TO StrmA.Cursor - 1        ' Display the deleted lines
                  DiffCB("D|" + FORMAT$(i, "00000 ") + "----- " + StrmA.@TLine[i])  '
               NEXT i                                             '
               FOR i = StrmB.Match + 1 TO StrmB.Cursor - 1        ' Display the inserted lines
                  DiffCB("I|+++++ " + FORMAT$(i, "00000 ") + StrmB.@TLine[i]) '
               NEXT i                                             '

            ELSE                                                  '
               ma = StrmA.Cursor - StrmA.Match - 1                ' Calc # if left  hand column
               mb = StrmB.Cursor - StrmB.Match - 1                ' Calc # in right hand column
               i = StrmA.Match + 1                                ' i -> 1st left  hand item
               j = StrmB.Match + 1                                ' j -> 1st right hand item
               FOR k = 1 TO MAX(ma, mb)                           ' Loop for # lines to print
                  IF i <= StrmA.Cursor - 1 THEN                   ' Still lines on the left?
                     t = "C|" + FORMAT$(i, "00000 ") + LSET$(StrmA.@TLine[i], ColW) '
                  ELSE                                            ' None left, blank it
                     t = "C|" + SPACE$(ColW + 6)                  '
                  END IF                                          '
                  INCR i                                          ' Bump i
                  t += " ~ "                                      ' Add divider
                  IF j <= StrmB.Cursor - 1 THEN                   ' Still lines on the right?
                     t += FORMAT$(j, "00000 ") + LSET$(StrmB.@TLine[j], ColW) '
                  ELSE                                            ' None left, blank it
                     t += SPACE$(ColW + 6)                        '
                  END IF                                          '
                  INCR j                                          ' Bump j
                  DiffCB(t)                                       ' Dump the line
               NEXT k                                             '
            END IF                                                '
         END IF                                                   '
         IF (gENV.DiffOnly AND gENV.Diff1Column) THEN DiffCB("N|" + REPEAT$((ColW + 12) \ 4, "- "))   '

         '-----------------------------------------------------------------------------------------+
         '- Now print the Unchanged line that got us back in step                                  |
         '-----------------------------------------------------------------------------------------+
         IF gENV.DiffOnly = 0 THEN                                ' If not DIFFONLY mode
            IF StrmA.Cursor <= StrmA.Last THEN                    ' If not the EOF match
               IF gENV.Diff1Column THEN                           ' 1COLUMN?
                  IF (StrmA.Flag AND %UseFileB) THEN              ' Use File B on a match
                     DiffCB("N|" + FORMAT$(StrmA.Cursor, "00000 ") + FORMAT$(StrmB.Cursor, "00000 ") + StrmB.@TLine[StrmB.Cursor])  '
                  ELSE                                            '
                     DiffCB("N|" + FORMAT$(StrmA.Cursor, "00000 ") + FORMAT$(StrmB.Cursor, "00000 ") + StrmA.@TLine[StrmA.Cursor])  '
                  END IF                                          '
               ELSE                                               '
                  DiffCB("N|" + FORMAT$(StrmA.Cursor, "00000 ") + LSET$(StrmA.@TLine[StrmA.Cursor], ColW) + _  '
                         " | " + FORMAT$(StrmB.Cursor, "00000 ") + LSET$(StrmB.@TLine[StrmB.Cursor], ColW)) '
               END IF                                             '
            END IF                                                '
         END IF                                                   '
         StrmA.Match = StrmA.Cursor: StrmB.Match = StrmB.Cursor   ' Save our last matching positions
      END IF                                                      '
   LOOP UNTIL StrmA.Cursor > StrmA.Last AND StrmB.Cursor > StrmB.Last   ' Do till EOF occurs
   DiffCB("", "H")                                                ' Switch to header
   IF mismatches > 0 THEN                                         ' If any mis-matches
      DiffCB("N|Number of mis-matches: " + FORMAT$(mismatches))   ' Tell of # of mismatches
   ELSE                                                           '
      DiffCB("N|No differences.")                                 ' If all the same, say so
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION DiffLoadClr(Strm AS DiffStream,  Fn AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Get comment data from the AUTO file                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL Profname, Txt1, PDiag, FName1, FName2 AS STRING, i, j, GotComm, FNum AS LONG  '
DIM parsed(100) AS STRING                                         '
   FOR i = 1 TO 9                                                 ' Reset the Strm fields
      Strm.Comm1(i) = ""                                          '
      Strm.Comm2(i) = ""                                          '
   NEXT i                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- See if AUTO even exists                                                                      |
   '-----------------------------------------------------------------------------------------------+
   FName1 = GetProfileForFile(Fn, PDiag, %True, %True)            ' Get the Profile name (NoEFT,Query)
   FName2 = gSQL.GetStringDirect("P" + FName1, "AUTONAME", "$NONE$") ' Get the AUTONAME value
   IF FName2 <> "$NONE$" THEN FName1 = FName2                     ' If specified, use it
   IF ISFALSE ISFILE(gENV.HomeData + "AUTO\" + FName1 + ".AUTO") THEN FUNCTION = %True: EXIT FUNCTION  ' See if Colorize file exists, kill if not

   '-----------------------------------------------------------------------------------------------+
   '- OK, Lets read the file                                                                       |
   '-----------------------------------------------------------------------------------------------+
   FNum = FREEFILE                                                ' Get a file #
   Call3(TryOpenInput(gENV.HomeData + "AUTO\" + FName1 + ".AUTO", FNum), _  ' Try the open
         TP.ErrMsgAdd(%eFail, "AUTO File: " + FName1 + " doesn't exist"): EXIT FUNCTION, _   ' Oops?  Bail out
         TP.ErrMsgAdd(%eFail, "OPEN of AUTO File: " + ProfName + " failed"): EXIT FUNCTION, _   '
         Nul)                                                     ' Continue
   DO WHILE ISFALSE EOF(FNum)                                     ' Read the data
      LINE INPUT # FNum, Txt1                                     ' Get a line
      IF LEN(TRIM$(Txt1)) > 0 AND LEFT$(Txt1, 1) <> ";" THEN      ' Process the statement

         '-----------------------------------------------------------------------------------------+
         '- If line has data and not a comment line, parse it                                      |
         '-----------------------------------------------------------------------------------------+
         PARSE Txt1, parsed(), " "                                '
         i = 0: j = 0                                             ' Shrink unused entries
         DO WHILE j <= 100                                        '
            IF ISNULL(parsed(i)) THEN ARRAY DELETE parsed(i) ELSE INCR i   '
            INCR j                                                '
         LOOP                                                     '

         IF LEFT$(UCASE$(parsed(0)), 6) = "QUOTED" THEN           ' Look for QUOTED statement
            Strm.CommQLeft = "": Strm.CommQRight = ""             ' Reset
            FOR i = 3 TO PARSECOUNT(Txt1, " ")                    ' Loop through QUOTED operands
               Strm.CommQLeft = TRIM$(Strm.CommQLeft) + LEFT$(parsed(i), 1)   ' Copy LEFT
               Strm.CommQRight = TRIM$(Strm.CommQRight) + RIGHT$(parsed(i), 1)   ' Copy Right
            NEXT i                                                '
         END IF                                                   '

         IF LEFT$(UCASE$(parsed(0)), 7) = "COMMENT" THEN          ' Look for COMMENTx statement
            IF INSTR("123456789", MID$(parsed(0), 8, 1)) = 0 THEN ' Not 1-9?
               CLOSE # FNum                                       ' Kill things
               FUNCTION = %True: EXIT FUNCTION                    '
            END IF                                                '
            i = VAL(MID$(parsed(0), 8, 1))                        ' Extract the COMMENT number
            Strm.Comm1(i) = UCASE$(parsed(2))                     ' Store things
            Strm.Comm2(i) = UCASE$(parsed(3))                     '
            GotComm = %True                                       ' Remember we got one
         ELSE                                                     ' A different keyword following COMMENT?
            IF GotComm THEN EXIT DO                               ' If we've seen COMMENTs, skip reading rest offile
         END IF                                                   '
      END IF                                                      '
   LOOP                                                           '
   CLOSE # FNum                                                   ' Close file
END FUNCTION                                                      '

FUNCTION DiffSearch(x AS DiffStream, y AS DiffStream) AS LONG     '
'--------------------------------------------------------------------------------------------------+
'- Look for the next line on stream y, and search for that line on stream x.                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG                                             '
    FUNCTION = %False                                             ' Say not found for a start
    FOR i = x.Match + 1 TO x.Last                                 ' Search X stream for a match
       IF DiffCompareLines(y, y.Cursor, x, i) THEN                ' Find a Match?
          k = 0                                                   ' Reset DiffMinMatch counter

          '----------------------------------------------------------------------------------------+
                                                                  ' Look for DiffMinMatch-1 additional matching lines
          '----------------------------------------------------------------------------------------+
          IF gENV.DiffMinMatch > 1 THEN                           ' Need more matches?
             FOR j = i + 1 TO i + gENV.DiffMinMatch - 1           ' Must find minmatch in a row
                INCR k                                            ' Bump offset
                IF DiffCompareLines(y, y.Cursor + k , x, i + k) THEN ' Find a Match?
                   ITERATE FOR                                    ' Good, keep going
                ELSE                                              ' Not a match
                   IF y.Cursor <= y.Last THEN y.Cursor = y.Cursor + 1   ' Bump cursor
                   EXIT FUNCTION                                  ' End the Search
                END IF                                            '
             NEXT j                                               ' Loop back
          END IF                                                  '

          '----------------------------------------------------------------------------------------+
                                                                  ' At this point we've found minmatch matches in a row
          '----------------------------------------------------------------------------------------+
          x.Cursor = i                                            ' Set X stream to the 1st match
          FUNCTION = %True                                        ' Say we found a match
          EXIT FUNCTION                                           ' And we're done
       END IF                                                     '
    NEXT i                                                        '
    IF y.Cursor <= y.Last THEN y.Cursor = y.Cursor + 1            ' Bump cursor for next iteration
END FUNCTION                                                      '

FUNCTION DiffCompareLines(a AS DiffStream, aindex AS LONG, b AS DiffStream, bindex AS LONG) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Compare the two lines, accounting for EOF handling                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL lcla, lclb AS STRING, i AS LONG                             '
   IF a.Cursor > a.Last AND b.Cursor > b.Last THEN FUNCTION = %True:  EXIT FUNCTION '
   IF aindex > a.Last OR bindex > b.Last      THEN FUNCTION = %False: EXIT FUNCTION '
   '-----------------------------------------------------------------------------------------------+
   '- We actually have to compare the text data                                                    |
   '-----------------------------------------------------------------------------------------------+
   IF a.Flag = 0 AND b.Flag = 0 AND _                             ' If no special options
      a.LB = 1 AND a.RB = 0 AND b.LB = 1 AND b.RB = 0 THEN        ' then just do a normal string comparison
      IF a.@TLine[aindex] = b.@TLine[bindex] THEN FUNCTION = %True:  EXIT FUNCTION  '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Some kind of special options were requested                                                  |
   '-----------------------------------------------------------------------------------------------+
   lcla = a.@TLine[aindex]: lclb = b.@TLine[bindex]               ' Get local copies of the text data

   '-----------------------------------------------------------------------------------------------+
   '- Do Bounds stuff first                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF a.LB <> 1 OR a.RB <> 0 THEN                                 ' Got some bounds
      IF a.rb = 0 THEN                                            ' RB = MAX?
         lcla = MID$(lcla, a.LB)                                  ' Do that
      ELSE                                                        ' Pick up substring
         lcla = MID$(lcla, a.LB TO a.RB)                          '
      END IF                                                      '
   END IF                                                         '

   IF b.LB <> 1 OR b.RB <> 0 THEN                                 ' Got some bounds
      IF b.rb = 0 THEN                                            ' RB = MAX?
         lclb = MID$(lclb, b.LB)                                  ' Do that
      ELSE                                                        ' Pick up substring
         lclb = MID$(lclb, b.LB TO b.RB)                          '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now do NoSpaces/NoTabs/NoComments/NoCASE                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF (a.Flag AND %NoComments) THEN                               ' If no comments, blank them\
      FOR i = 1 TO 9                                              ' Test each of the comments types
         IF TRIM$(a.Comm1(i)) <> "" THEN                          ' If valid entry
            DiffDoComment(lcla, TRIM$(a.Comm1(i)), TRIM$(a.Comm2(i)), TRIM$(a.CommQLeft), TRIM$(a.CommQRight)) ' Go process it for lcla
         END IF                                                   '
      NEXT i                                                      '
   END IF                                                         '
   IF (b.Flag AND %NoComments) THEN                               ' If no comments, blank them
      FOR i = 1 TO 9                                              ' Test each of the comments types
         IF TRIM$(b.Comm1(i)) <> "" THEN                          ' If valid entry
            DiffDoComment(lclb, TRIM$(b.Comm1(i)), TRIM$(b.Comm2(i)), TRIM$(a.CommQLeft), TRIM$(a.CommQRight)) ' Go process it for lclb
         END IF                                                   '
      NEXT i                                                      '
   END IF                                                         '

   IF (a.Flag AND %NoTabs) THEN                                   ' If no Tabs, replace them with blanks
      REPLACE $TAB WITH " " IN lcla                               '
   END IF                                                         '
   IF (b.Flag AND %NoTabs) THEN                                   ' If no Tabs, replace them with blanks
      REPLACE $TAB WITH " " IN lclb                               '
   END IF                                                         '

   IF (a.Flag AND %NoSpaces) THEN                                 ' If no spaces, condense them
      lcla = SHRINK$(lcla)                                        '
   END IF                                                         '
   IF (b.Flag AND %NoSpaces) THEN                                 ' If no spaces, condense them
      lclb= SHRINK$(lclb)                                         '
   END IF                                                         '

   IF (a.Flag AND %NoCASE) THEN                                   ' If no CASE, massage to UCase
      lcla = UUCASE(lcla): lclb = UUCASE(lclb)                    '
   END IF                                                         '

   IF lcla = lclb THEN FUNCTION = %True:  EXIT FUNCTION           ' Compare processed line
END FUNCTION                                                      '

SUB     DiffDoComment(str AS STRING, id1 AS STRING, id2 AS STRING, QLeft AS STRING, QRight AS STRING) '
'--------------------------------------------------------------------------------------------------+
'- Process string and blank any comment                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL j, x, y, q, qq AS LONG, qDLM AS STRING                      '
   x = 1                                                          ' Set start scan
   DO                                                             ' Scan
      y = INSTR(x, str, id1)                                      ' Is it even in the line?
      IF y = 0 THEN EXIT SUB                                      ' No, skip to next
      RESET Q, QQ                                                 ' Reset
      IF ISNOTNULL(QLeft) THEN                                    ' Quotes active?
         Q = INSTR(x, str, ANY QLeft)                             ' Look for a quote delimiter
         IF Q THEN                                                ' Got quote
            qDLM = MID$(str, Q, 1)                                ' Save which one
            qq = INSTR(Q + 1, str, qDLM)                          ' Look for closing
         END IF                                                   ' Q & QQ mark quoted string
         IF Q AND QQ THEN                                         ' If we found a quoted string
            IF (y > Q AND y < QQ) _                               ' Oops, found inside quotes
            OR QQ < y THEN                                        ' or Quoted string < comment string
               x = QQ + 1                                         ' Step over close quote
               ITERATE DO                                         ' Continue scan
            ELSE                                                  ' Else we have a winner
               EXIT DO                                            ' Y = Found
            END IF                                                '
         ELSE                                                     '
            EXIT DO                                               ' Y = found
         END IF                                                   '
      ELSE                                                        '
        EXIT DO                                                   ' Y = found
      END IF                                                      '
   LOOP                                                           '
   IF y = 0 THEN EXIT SUB                                         ' If nothing found, return doing nothing
   IF VERIFY(id2, "0123456789") = 0 THEN                          ' If id2 numeric
      j = VAL(id2)                                                ' Get value of id2
      IF j > 0 AND y <> j THEN EXIT SUB                           ' If fixed column, then not found, do nothing

      IF j = 0 THEN                                               ' id2 = 0, rest of line is a comment
         str = LEFT$(str, y - 1)                                  ' Strip the comment
         EXIT SUB                                                 '
      END IF                                                      '
   END IF                                                         '
   j = INSTR(y + 1, str, id2)                                     ' id2 must be a string, look for it
   IF j THEN                                                      ' Found it
      MID$(str, y TO j + LEN(id2) - 1) = SPACE$(j + LEN(id2) - 1 - y)   ' Blank the comment
   ELSE                                                           ' Else treat as remainder of line
      str = LEFT$(str, y - 1)                                     ' Strip the comment
   END IF                                                         '
END SUB                                                           '

SUB      DLGAddCheck(wnd AS LONG, ID AS LONG, Value AS LONG, x AS LONG, y AS LONG, lgth AS LONG, Txt1 AS STRING)  '
'--------------------------------------------------------------------------------------------------+
'- Add a checkbox to a Tab                                                                         |
'--------------------------------------------------------------------------------------------------+
   CONTROL ADD CHECKBOX, wnd, ID, Txt1, x, y, lgth, 12            '
   CONTROL SET COLOR     wnd, ID, %WHITE, -2                      '
   CONTROL SET CHECK     wnd, ID, Value                           '
END SUB                                                           '

FUNCTION DLGToolTipCreate(BYVAL Wnd AS LONG) AS LONG              '
'--------------------------------------------------------------------------------------------------+
'- Create tooltips control if needed.                   '                                          |
'--------------------------------------------------------------------------------------------------+
   IF ghToolTips = 0 THEN                                         '
      IF Wnd = 0 THEN Wnd = GetActiveWindow()                     '
      IF Wnd = 0 THEN EXIT FUNCTION                               '
      InitCommonControls                                          '
      ghToolTips = CreateWindowEx(0, "tooltips_class32", "", %TTS_ALWAYSTIP OR %TTS_BALLOON, _  '
             0, 0, 0, 0, Wnd, BYVAL 0&, GetModuleHandle(""), BYVAL %Null)  '
   END IF                                                         '
   FUNCTION = ghToolTips                                          '
END FUNCTION                                                      '

FUNCTION DLGToolTipSet(BYVAL Wnd AS LONG, BYVAL Txt1 AS STRING) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Add a tooltip to a window/control                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL ti AS TOOLINFO                                              '
   MEntry                                                         '
   IF gENV.WineMode THEN MExitFunc                                ' Skip this under WINE
   IF DLGToolTipCreate(GetParent(Wnd)) = 0 THEN MExitFunc         ' Ensure creation
   ti.cbSize   = LEN(ti)                                          '
   ti.uFlags   = %TTF_SUBCLASS OR %TTF_IDISHWND                   '
   ti.hWnd     = GetParent(Wnd)                                   '
   ti.uId      = ghWnd                                            '

   '-----------------------------------------------------------------------------------------------+
   '- Remove existing tooltip                           '                                          |
   '-----------------------------------------------------------------------------------------------+
   IF SENDMESSAGE (ghToolTips, %TTM_GETTOOLINFO, 0, BYVAL VARPTR(ti)) THEN '
      SENDMESSAGE ghToolTips, %TTM_DELTOOL, 0, BYVAL VARPTR(ti)   '
   END IF                                                         '
   ti.cbSize   = LEN(ti)                                          '
   ti.uFlags   = %TTF_SUBCLASS OR %TTF_IDISHWND                   '
   ti.hWnd     = GetParent(Wnd)                                   '
   ti.uId      = Wnd                                              '
   ti.lpszText = STRPTR(Txt1)                                     '
   FUNCTION = SENDMESSAGE(ghToolTips, %TTM_ADDTOOL, 0, BYVAL VARPTR(ti))   'add tooltip
   MExit                                                          '
END FUNCTION                                                      '

SUB DoBackup(FileName AS STRING, TabMode AS LONG, RCA AS RCArea)  '
'--------------------------------------------------------------------------------------------------+
'- Backup copy a Filename                                                                          |
'--------------------------------------------------------------------------------------------------+
REGISTER j AS LONG                                                '
LOCAL iFileName, iStateName, oStateName, BKPFileName, TSTFileName, t, u, BKPMode, BKPDate AS STRING   '
LOCAL k, hFile, hFile2, BKPCount AS LONG                          '
LOCAL iFileSize, tFileSize AS QUAD                                ' Size of File / State
LOCAL CreationTime, LastAccessTime, LastWriteTime AS MyFStamp     '
LOCAL FileFD, RetFD, BKPFD AS DIRDATA                             ' For directory data of the files
LOCAL iPath, iFile, iExt, iStamp AS STRING                        '
LOCAL oPath, oFile, oExt, oStamp AS STRING                        '
LOCAL LTime AS IPOWERTIME                                         ' Create a PowerTime object
   LET LTime = CLASS "PowerTime"                                  '

   BKPMode = LEFT$(FileName, 1)                                   ' Get operation Mode
   iFileName = TRIM$(MID$(FileName, 2))                           ' Get the Filename

   t = DIR$(iFileName TO FileFD)                                  ' Get the full FD set of data
   IF t = "" THEN                                                 ' Not found?
      AnswerSub(8, "File could not be found??")                   ' Shouldn't happen, but ...
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Does Filename already have a timestamp level within it                                       |
   '-----------------------------------------------------------------------------------------------+
   t = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")         ' Setup PCRE Search for .999999-999999.999999.
   PCRERegexTest(iFileName, 1, j, k)                              ' See if we can find it
   IF j <> 0 AND k = 21 THEN                                      ' Look reasonable?
      AnswerSub(8, "Backup files cannot be backed up.")           ' We don't get incestuous
   END IF                                                         '
   IF INSTR(uucase(iFileName), "\$BACKUP\") THEN                  ' Already in a \$BACKUP\ folder?
      AnswerSub(8, "No Nesting of \$BACKUP\ folders.")            ' We don't get tricky either
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get Dates and sizes of the file                                                              |
   '-----------------------------------------------------------------------------------------------+
   CreationTime.MyQuad   = FileFD.CreationTime                    ' Get original file Date Time Stamps
   LastAccessTime.MyQuad = FileFD.LastAccessTime                  '
   LastWriteTime.MyQuad  = FileFD.LastWriteTime                   '
   iFileSize = MAK(QUAD, FileFD.FileSizeLow, FileFD.FileSizeHigh) ' Get size of the file

   '-----------------------------------------------------------------------------------------------+
   '- Extract filename pieces                                                                      |
   '-----------------------------------------------------------------------------------------------+
   iPath = PATHNAME$(PATH, iFileName)                             ' Get its path
   oPath = iPath                                                  '
   iFile = PATHNAME$(NAMEX, iFileName)                            ' Get just the file.Ext
   oFile = iFile                                                  '
   iExt  = PATHNAME$(EXTN, iFileName)                             ' Get just the extension
   oExt = iExt                                                    '
   '-----------------------------------------------------------------------------------------------+
   '- Ensure \$BACKUP\ exists                                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF (TabMode AND %Clip) OR (TabMode AND %SetEdit) OR (TabMode AND %EFTEdit) THEN  '

      oPath = gENV.HomeData: iExt = ""                            '
      IF (TabMode AND %Clip)    THEN oFile = IIF$(ISNOTNULL(TP.ClipName), TP.ClipName + ".", "") + "CLIP": oExt = ".CLIP"  '
      IF (TabMode AND %SetEdit) THEN oFile = "SetEdit": oExt = ".SetEdit"  '
      IF (TabMode AND %EFTEdit) THEN oFile = "EFTEdit": oExt = ".EFTEdit"  '

      '--------------------------------------------------------------------------------------------+
      '- Do it for the special file's Backup folder                                                |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE ISFOLDER(gENV.HomeData + "$BACKUP") THEN         ' If not there
         MKDIR gENV.HomeData + "$BACKUP"                          ' Ensure \$BACKUP exists
         BKPAddPath(gENV.HomeData + "$BACKUP")                    ' Remember this folder
      ELSE                                                        ' If there
         BKPAddPath(gENV.HomeData + "$BACKUP")                    ' Make sure it's in the BKP table
         BKPDoRetention(gENV.HomeData + "$BACKUP", %False)        ' Do retention stuff, don't remove $BACKUP folder
      END IF                                                      '
   ELSE                                                           '
      '--------------------------------------------------------------------------------------------+
      '- Do it for the normal file's Backup folder                                                 |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE ISFOLDER(iPath + "$BACKUP") THEN                 ' If not there
         MKDIR iPath + "$BACKUP"                                  ' Ensure \$BACKUP exists
         BKPAddPath(iPath + "$BACKUP")                            ' Remember this folder
      ELSE                                                        ' If there
         BKPAddPath(iPath + "$BACKUP")                            ' Make sure it's in the BKP table
         BKPDoRetention(iPath + "$BACKUP", %False)                ' Do retention stuff, don't remove $BACKUP folder
      END IF                                                      '
   END IF                                                         '

   BKPDate = "." + RIGHT$(DATE$, 2) + LEFT$(DATE$, 2) + MID$(DATE$, 4, 2)  '

   '-----------------------------------------------------------------------------------------------+
   '- Build the Backup Name                                                                        |
   '-----------------------------------------------------------------------------------------------+
   LTime.FileTime = LastWriteTime.MyQuad                          ' Assign the passed FILETIME QUAD to it
   LTime.ToLocalTime                                              ' Make local time
   iStamp  = FORMAT$(LTime.year() - 2000, "00") + FORMAT$(LTime.Month(), "00") + FORMAT$(LTime.day(), "00") + "-" + _   '
             FORMAT$(LTime.Hour(), "00") + FORMAT$(LTime.Minute(), "00") + FORMAT$(LTime.Second(), "00") '

   IF (TabMode AND %Clip) OR (TabMode AND %SetEdit) OR (TabMode AND %EFTEdit) THEN  '
      BKPFileName = oPath + "$BACKUP\" + oFile  + "." + iStamp + BKPDate + oExt  '
   ELSE                                                           '
      BKPFileName = iPath + "$BACKUP\" + iFile  + "." + iStamp + BKPDate + IIF$(iExt = "", "", iExt)  '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Count existing backups                                                                       |
   '-----------------------------------------------------------------------------------------------+
   TSTFileName = oPath + "$BACKUP\" + oFile + ".*"                ' Build generic (no stamp) search version
   BKPCount = 0                                                   '
   u = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")         ' Look for our timestamp pattern
   t = DIR$(TSTFileName, TO RetFD)                                ' Look for Backups
   DO WHILE ISNOTNULL(t)                                          ' While we're getting entries
      PCRERegexTest(t, 1, j, k)                                   ' See if has our pattern
      IF j  AND RIGHT$(t, 6) <> ".STATE" THEN                     ' Got one, and NOT a STATE file
         INCR BKPCount                                            ' Bump counter
      END IF                                                      '
      t = DIR$(NEXT)                                              ' Get next entry
   LOOP                                                           '

   IF BKPMode = "?" THEN                                          ' If this is just a BkpQuery mode call
      IF BKPCount = 0 THEN                                        '
         AnswerSub(0, "No existing Backups.")                     ' Build message
      ELSE                                                        '
         AnswerSub(0, FORMAT$(BKPCount) + " existing Backup version" + IIF$(BKPCount = 1, "", "s"))   '
      END IF                                                      '
   END IF                                                         '

   TSTFileName = BKPFileName                                      ' Build search version
   u = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}")                   ' Look for our timestamp pattern minus the backup date
   PCRERegexTest(TSTFileName, 1, j, k)                            ' Find our pattern
   TSTFilename = LEFT$(TSTFileName, j + 13) + ".*"                ' Make it a mask to ignore backup date

   t = DIR$(TSTFileName TO BKPFD)                                 ' See if one exists
   IF t <> "" THEN                                                '
      tFileSize = MAK(QUAD, FileFD.FileSizeLow, FileFD.FileSizeHigh) ' Get size of the Requested Backup file
      IF iFileSize = tFileSize THEN                               ' Check file size
         AnswerSub(4, "Backup already exists, Same File Size")    ' BKP name already exists, same size
      ELSE                                                        '
         AnswerSub(4, "Backup already exists, DIFFERENT File Size")  ' BKP name already exists, different size
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now copy the main file                                                                       |
   '-----------------------------------------------------------------------------------------------+
   FILECOPY iFileName, BKPFileName                                ' Copy file

   '-----------------------------------------------------------------------------------------------+
   '- Now try to backup the STATE data if available                                                |
   '-----------------------------------------------------------------------------------------------+
   iStateName = iFileName + ".STATE"                              ' Build the orig STATE filename
   REPLACE ANY ":\/" WITH "```" IN iStateName                     ' Make : / and \ into `
   iStateName = gENV.HomeData + "STATE\" + iStateName             ' Add our STATE folder
   IF ISFILE(iStateName) THEN                                     ' Does a STATE file exist?
      oStateName = BKPFileName + ".STATE"                         ' Yes, create Output STATE name
      FILECOPY iStateName, oStateName                             ' Copy it
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now set the Backup file dates back to the original                                           |
   '-----------------------------------------------------------------------------------------------+
   TRY                                                            '
      hFile = FREEFILE                                            ' Touch the file now to set back te dates
      OPEN BKPFileName FOR APPEND ACCESS READ WRITE LOCK SHARED AS # hFile '
      hFile2 = FILEATTR(hFile, 2)                                 ' Get Windows handle for the file
      SetFileTime hFile2, CreationTime.MyTime, LastAccessTime.MyTime, LastWriteTime.MyTime   '
      CLOSE #hFile                                                ' Close it

   CATCH                                                          '
      AnswerSub(8, "Backup OK, couldn't set the File Dates")      ' Say DATE attempt failed
   END TRY                                                        '
   IF oStateName <> "" THEN                                       ' Did we have a STATE file?
      TRY                                                         '
         hFile = FREEFILE                                         ' Touch the file now to set back te dates
         OPEN oStateName FOR APPEND ACCESS READ WRITE LOCK SHARED AS # hFile  '
         hFile2 = FILEATTR(hFile, 2)                              ' Get Windows handle for the file
         SetFileTime hFile2, CreationTime.MyTime, LastAccessTime.MyTime, LastWriteTime.MyTime   '
         CLOSE #hFile                                             ' Close it

      CATCH                                                       '
         AnswerSub(8, "Backup OK, couldn't set the File Dates")   ' Say DATE attempt failed
      END TRY                                                     '
   END IF                                                         '

   INCR BKPCount                                                  ' Adjust count
   AnswerSub(0, "File" + IIF$(oStateName <> "", "+State", "") + " backed up, " + _  '
              FORMAT$(BKPCount) + " version" + IIF$(BKPCount = 1, "", "s") + " saved") '
END SUB                                                           '

SUB      DoBeepReal()                                             '
'--------------------------------------------------------------------------------------------------+
'- Issue BEEP if allowed                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL x, y, px, py AS LONG                                        '
REGISTER i AS LONG                                                '
   MEntry                                                         '
   IF ISFALSE gDoBeepFlag THEN MExitSub                           '
   gDoBeepFlag = %False                                           ' Turn off Beep request
   IF gMacroMode THEN MExitSub                                    ' Don't BEEP if inside a Macro
   IF ISTRUE gENV.ABeepFlag THEN PlaySound("SystemAsterisk", %Null, %SND_ASYNC)  '
   IF ISFALSE gENV.VBeepFlag THEN MExitSub                        ' Exit if no VBeep
   x = 3 * gFontWidth                                             ' Get width  of area
   y = 2 * gFontHeight                                            ' Get height of area
   px = (TP.CsrCol - 2) * gFontWidth + %GLM                       ' Calc x position
   py = (TP.CsrRow - 1) * gFontHeight - (gFontHeight / 2)         ' Calc y position
   GRAPHIC ATTACH TP.PgHandle, TP.WindowID                        ' Set as the default graphic area
   GRAPHIC SET MIX %MIX_NOT                                       ' Set MIX
   FOR i = 1 TO 4                                                 ' Invert it 4 times
      GRAPHIC BOX (px, py) - (px + x, py + y), 100, gTxtHiFG, gTxtHiFG  '
      IF i MOD 2 THEN                                             ' Alternate the command line blink
         DoPrint ("Command > ", $$Red, 1, 1)                      '
      ELSE                                                        '
         DoPrint ("Command > ", $$TxtHi, 1, 1)                    '
      END IF                                                      '
      SLEEP 80                                                    ' Delay between flips
   NEXT i                                                         '
   MExit                                                          '
END SUB                                                           '

SUB      DoCloneSession(fn AS STRING)                             '
'--------------------------------------------------------------------------------------------------+
'- Start another SPFLite process to edit a file                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL lclDrive, lclPath, lclCmd, lclMode, lclPCmd AS STRING       '
LOCAL RetC AS LONG                                                '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Build a command to start another SPFLite Instance                                            |
   '-----------------------------------------------------------------------------------------------+
   lclPCmd = TP.CurrPCmd                                          ' Get current command name
   lclMode = SWITCH$(lclPCmd = "OPEN", " -OPENE ", lclPCmd = "OPENE", " -OPENE ", lclPCmd = "OPENV", " -OPENV ", lclPCmd = "OPENB", " -OPENB ") '
   lclPath = CURDIR$                                              ' Locate where we are
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save for restore
   IF MID$(gENV.EXEPath, 2, 1) = ":" THEN _                       ' See if gEXEPath has drive
      CHDRIVE LEFT$(gENV.EXEPath, 2)                              ' If so, go to it
   CHDIR gENV.EXEPath                                             ' Switch to EXE path
   lclCmd = $DQ + EXE.FULL$ + $DQ + lclMode + $DQ + fn + $DQ      ' Build command string

   '-----------------------------------------------------------------------------------------------+
   '- Issue the command                                                                            |
   '-----------------------------------------------------------------------------------------------+
   RetC = SHELL(lclCmd,1)                                         '
   IF ERR THEN                                                    ' Tell user result
      TP.ErrMsgAdd(%eFail, "Error issuing START command, " + ERROR$) '
   ELSE                                                           '
      TP.ErrMsgAdd(0, "New instance of SPFLite started")          '
   END IF                                                         '
   IF ISNOTNULL(lclDrive) THEN CHDRIVE lclDrive                   ' Switch drive if needed
   CHDIR lclPath                                                  ' put back the original path
   MExit                                                          '
END SUB                                                           '

SUB      DoCmdInOtherTab(BYVAL tn AS LONG, tcmd AS STRING)        '
'--------------------------------------------------------------------------------------------------+
'- Execute a command in another tab                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL OurTab AS LONG                                              '
   MEntry                                                         '
   OurTab = TP.PgNumber                                           ' Save our page number
   TP = gTabs(tn)                                                 ' Switch to the tab
   TP.pCommand = tcmd                                             ' Stuff in the command
   TP.AttnDo =  (TP.AttnDo OR %Attention)                         ' Request Attention
   TP.PostKeyboard                                                ' Go try it
   TP = gTabs(OurTab)                                             ' Switch back to original tab
   DoPendingTabDeletes                                            ' In case a Del is needed
   MExit                                                          ' We're done
END SUB                                                           '

SUB      DoCursor ()                                              '
'--------------------------------------------------------------------------------------------------+
'- Handle the cursor on the graphic screen                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lx, ly AS LONG                                              '
LOCAL lRow, lclCol, i, j, k, lclBG, DidErase, DoRedraw, DTop, DBottom, DCol AS LONG '
LOCAL u AS STRING                                                 '
   MEntry                                                         '
   IF ISFALSE gENV.InitDone OR ISTRUE gMacroMode OR ISTRUE gfTermFlag OR ISTRUE gfEndAll THEN MExitSub   ' If INIT not done, Shutdown or MacroMode, exit
   IF gMacroMode OR gfTermFlag THEN MExitSub                      '
   DidErase = %False: DoRedraw = %False                           '
   IF gTabsNum = 0 THEN MexitSub                                  ' Prevent Memory Access during shutdown
   lRow = TP.CsrRow: lclCol = TP.CsrCol                           ' Get local copies
   DoStatusBar(BUILD$($SBMode,$SBLinNo,$SBLines,$SBCols,$SBMisc,$SBEOL,$SBState))   ' re-Do some StatusBar boxes

   '-----------------------------------------------------------------------------------------------+
   '- Finally do the actual cursor                                                                 |
   '-----------------------------------------------------------------------------------------------+
   lx = (lclCol - 1) * gFontWidth + %GLM                          ' Include LM pad
   ly = lRow  * gFontHeight + 1                                   '
   CaretSet(lx, ly)                                               ' Go set the caret and show it

   '-----------------------------------------------------------------------------------------------+
   '- Do other 'cursor' if in PTYPE mode                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF ISTRUE IsTPPTypeMode THEN                                   ' In PTYPE mode and not split?
      GRAPHIC ATTACH TP.PgHandle, TP.WindowID, REDRAW             ' Set as the default graphic area
      DoRedraw = %True                                            ' Do the redraw
      GRAPHIC SET MIX %MIX_COPYSRC                                '
      FOR k = 1 TO gPTblCount                                     ' Loop for each PT line
         i = gPTbl(k).tLin                                        ' Get IX of real data line
         j  = gPTbl(k).sRow                                       ' Get screen row
         IF j = 0 THEN ITERATE FOR                                ' Ignore if not on screen
         IF j >= TP.GPData1 AND j <= TP.GPBottom THEN             ' And within active panel?
            IF TP.LastPTCurs <> 0 AND TP.LastPTCurs <> TP.CsrCol THEN   ' Previous one to erase AND a new column?
               GRAPHIC LINE ((TP.LastPTCurs - 1) * gFontWidth + %GLM - 1, (j - 1) * gFontHeight) - _  '
                            ((TP.LastPTCurs - 1) * gFontWidth + %GLM - 1, (j) * gFontHeight), gTxtLoBG1  '
            END IF                                                '
            GRAPHIC LINE ((TP.CsrCol - 1) * gFontWidth + %GLM - 1, (j - 1) * gFontHeight) - _   '
                         ((TP.CsrCol - 1) * gFontWidth + %GLM - 1, (j) * gFontHeight), gTxtHiFG '
         END IF                                                   '
      NEXT k                                                      '
      TP.LastPTCurs = TP.CsrCol                                   ' Save it

   '-----------------------------------------------------------------------------------------------+
   '- Do other 'cursor' if in HRuler or VRuler                                                     |
   '-----------------------------------------------------------------------------------------------+
   ELSEIF ISTRUE gENV.HRuler OR ISTRUE gENV.VRuler THEN           ' Vertical or horizontal ruler mode?
      GRAPHIC ATTACH TP.PgHandle, TP.WindowID, REDRAW             ' Set as the default graphic area
      DoRedraw = %True                                            ' Do the redraw
      GRAPHIC SET MIX %MIX_COPYSRC                                '

      '--------------------------------------------------------------------------------------------+
      '- Split now for FM / Non-FM                                                                 |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE IsFMTab THEN                                     ' The Edit tab?

         '-----------------------------------------------------------------------------------------+
         '- Erase previous lines if needed                                                         |
         '-----------------------------------------------------------------------------------------+
         IF ISTRUE gENV.VRuler THEN                               ' Vertical?
            IF TP.LastRulCol <> 0 AND TP.LastRulCol <> TP.CsrCol THEN   ' Previous to erase?
               i = TP.LastRulCol                                  ' Working copy
               DidErase = %True                                   '
               DCol    = (i - 1) * gFontWidth + %GLM - 1          ' Calc column
               DBottom = (gENV.ScrHeight - gENV.PFKShow) * gFontHeight  ' Calc Bottom
               DTop = (TP.FCB_.Cols + 2) * gFontHeight            '
               IF ISFALSE gENV.Banding THEN                       '
                  GRAPHIC LINE (DCol, 1) - (DCol, DBottom), gTxtLoBG1   ' Draw the line
               ELSE                                               ' Much harder now, we're in Banding mode
                  FOR j = 1 TO (gENV.ScrHeight - gENV.PFKShow)    '
                     BGBandEdit(j)                                ' Calc Banding
                     lclBG = IIF(gBandBG, gENV.GetClr(%SCTxtLo, %SCBG2), gENV.GetClr(%SCTxtLo, %SCBG1))  ' Choose Scheme's BG color
                     GRAPHIC LINE (DCol, ((j - 1) * gFontHeight) + 1) - (DCol, (j * gFontHeight) + 1), lclBG   ' Draw the line
                  NEXT j                                          '
               END IF                                             '
               '-----------------------------------------------------------------------------------+
               '- If a MARK/TAB column, redraw the MARK/TAB line                                   |
               '-----------------------------------------------------------------------------------+
               u = IIF$(TP.FCB_.TabBnds, TP.TabsSimple(TP.GPOffSet + 200), TP.FCB_.MarkWorking) ' Get MARK/TAB line
               IF MID$(u, i + TP.GPOffset - TP.GPGapCol, 1) = "*" AND _ ' MARK/TAB column?
                  (ISTRUE TP.FCB_.MarkFlag OR ISTRUE TP.FCB_.TabBnds) THEN ' And MARK/Tab Mode?
                  IF ISTRUE (TP.FCB_.TabBnds) THEN                ' TABS style line?
                     GRAPHIC STYLE 2                              ' Set line type to dotted
                     GRAPHIC LINE (DCol, DTop) - (DCol, DBottom), gENV.cMarkLine ' Draw the line
                     GRAPHIC STYLE 0                              ' Reset line style
                  ELSE                                            '
                     GRAPHIC LINE (DCol, DTop) - (DCol, DBottom), gENV.cMarkLine ' Draw the line
                  END IF                                          '
               END IF                                             '
               TP.LastRulCol = 0                                  '
            END IF                                                '
         END IF                                                   '

         IF ISTRUE gENV.HRuler THEN                               ' Horizontal?
            IF TP.LastRulRow <> 0 AND TP.LastRulRow <> TP.CsrRow THEN   ' Previous to erase AND a new row?
               i = TP.LastRulRow                                  ' Working copy
               BGBandEdit(i)                                      ' Calc Banding
               lclBG = IIF(gBandBG, gENV.GetClr(%SCTxtLo, %SCBG2), gENV.GetClr(%SCTxtLo, %SCBG1))  ' Chose Scheme's BG color
               DidErase = %True                                   '
               GRAPHIC LINE (1, i * gFontHeight) - (gENV.ScrWidth * gFontWidth + %GLM, i * gFontHeight), lclBG ' Draw the line
               TP.LastRulRow = 0                                  '
               IF TP.FCB_.HexMode = &1 THEN                       ' If not HEX mode, do some more
                  IF TP.SGet(j) > 0 THEN                          ' If a text line
                     TP.DispLine(TP.SGet(j), j)                   ' Re disp it
                  END IF                                          '
               END IF                                             '
               TP.DoMarkLines                                     ' Redraw the MARK lines
            END IF                                                '
         END IF                                                   '

         IF ISTRUE gENV.VRuler THEN                               ' Vertical?
            IF (TP.CsrCol <> TP.LastRulCol) OR DidErase THEN      '
               i = TP.CsrCol                                      ' Get cursor column
               TP.LastRulCol = i                                  ' Save it
               GRAPHIC LINE ((i - 1) * gFontWidth + %GLM - 1, 1) - ((i - 1) * gFontWidth + %GLM - 1, (gENV.ScrHeight - gENV.PFKShow) * gFontHeight), gENV.cMarkLine  ' Draw the line
            END IF                                                '
         END IF                                                   '

         IF ISTRUE gENV.HRuler THEN                               ' Horizontal?
            IF (TP.CsrRow <> TP.LastRulRow) OR DidErase THEN      '
               i = TP.CsrRow                                      ' Get cursor row
               TP.LastRulRow = i                                  ' Save it
               GRAPHIC LINE (1, i * gFontHeight) - (gENV.ScrWidth * gFontWidth + %GLM, i * gFontHeight), gENV.cMarkLine ' Draw the line
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Do the FM variety                                                                         |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '- Erase previous lines if needed                                                         |
         '-----------------------------------------------------------------------------------------+
         IF ISTRUE gENV.VRuler THEN                               ' Vertical?
            IF TP.LastRulCol <> 0 AND TP.LastRulCol <> TP.CsrCol THEN   ' Previous to erase?
               i = TP.LastRulCol                                  ' Working copy
               DidErase = %True                                   '
               FOR j = 1 TO (gENV.ScrHeight - IIF(gENV.FMHelpFlag, 3, 0))  '
                  BGBandEdit(j)                                   ' Calc Banding
                  lclBG = IIF(gBandBG, gENV.GetClr(%SCTxtLo, %SCBG2), gENV.GetClr(%SCTxtLo, %SCBG1))  ' Chose Scheme's BG color
                  GRAPHIC LINE ((i - 1) * gFontWidth + %GLM - 1, ((j - 1) * gFontHeight)) - ((i - 1) * gFontWidth + %GLM - 1, (j * gFontHeight)), IIF(j = 3 OR j = 6, gFMToolBG1, lclBG)  ' Draw the line
               NEXT j                                             '
               TP.LastRulCol = 0                                  '
            END IF                                                '
         END IF                                                   '

         IF ISTRUE gENV.HRuler THEN                               ' Horizontal?
            IF 1 = 1 THEN                                         '
               IF TP.LastRulRow <> 0 AND TP.LastRulRow <> TP.CsrRow THEN   ' Previous to erase AND a new row?
                  i = TP.LastRulRow                               ' Working copy
                  BGBandEdit(i)                                   ' Calc Banding
                  lclBG = IIF(gBandBG, gENV.GetClr(%SCTxtLo, %SCBG2), gENV.GetClr(%SCTxtLo, %SCBG1))  ' Chose Scheme's BG color
                  DidErase = %True                                '
                  GRAPHIC LINE (1, i * gFontHeight) - (gENV.ScrWidth * gFontWidth + %GLM, i * gFontHeight), lclBG ' Draw the line
                  TP.LastRulRow = 0                               '
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         IF ISTRUE gENV.VRuler THEN                               ' Vertical?
            IF (1 = 1  AND TP.CsrCol <> TP.LastRulCol) OR DidErase THEN '
               i = TP.CsrCol                                      ' Get cursor column
               TP.LastRulCol = i                                  ' Save it
               GRAPHIC LINE ((i - 1) * gFontWidth + %GLM - 1, 1) - ((i - 1) * gFontWidth + %GLM - 1, (gENV.ScrHeight - IIF(gENV.FMHelpFlag, 3, 0)) * gFontHeight), gENV.cMarkLine   ' Draw the line
            END IF                                                '
         END IF                                                   '

         IF ISTRUE gENV.HRuler THEN                               ' Horizontal?
            IF (1 = 1  AND TP.CsrRow <> TP.LastRulRow) OR DidErase THEN '
               i = TP.CsrRow                                      ' Get cursor row
               TP.LastRulRow = i                                  ' Save it
               GRAPHIC LINE (1, i * gFontHeight) - (gENV.ScrWidth * gFontWidth + %GLM, i * gFontHeight), gENV.cMarkLine ' Draw the line
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
   IF DoRedraw THEN GRAPHIC REDRAW                                ' Redraw it if we need to
   MExitSub                                                       '
END SUB                                                           '

SUB DoHelpSearch(sKwd AS STRING, sNum AS LONG)                    '
'--------------------------------------------------------------------------------------------------+
'- Lookup Kwd and set gHlpT table found flags                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i, ID AS LONG, key AS STRING                                '
   MEntry                                                         '
   key = TRIM$(UUCASE(sKwd))                                      ' Trim and UC it

   '-----------------------------------------------------------------------------------------------+
   '- Search Main Kwds table first                                                                 |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gHlpKCtr                                          ' Search the topic keywords
      IF key = TRIM$(gHlpK(i).Kwd) THEN                           ' A word match?
         ID = gHlpK(i).Num                                        ' Yes get Topic ID #
         MID$(gHlpT(ID).Found, sNum, 1) = "1"                     ' Flag as found by search word (sNum)
         gHlpT(ID).Hits = gHlpT(ID).Hits + gHlpK(i).Hits          ' Accum hits count
      END IF                                                      '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- OK, search the Words table                                                                   |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gHlpWCtr                                          ' Loop through Word Table
      IF key = TRIM$(gHlpW(i).Kwd) THEN                           ' A word match?
         ID = gHlpW(i).Num                                        ' Yes get Topic ID #
         MID$(gHlpT(ID).Found, sNum, 1) = "1"                     ' Flag as found by search word (sNum)
         gHlpT(ID).Hits = gHlpT(ID).Hits + gHlpW(i).Hits          ' Accum hits count
      END IF                                                      '
   NEXT i                                                         ' Do the whole table
   MExit                                                          '
END SUB                                                           '

SUB DoInitString(Init AS STRING, PProf AS STRING, PMacr AS STRING, PXMacr AS STRING, MRFMode AS LONG) '
'--------------------------------------------------------------------------------------------------+
'- Process a startup Init string                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL Prof, Macr, XMacr, fn, fn2, t, cmd AS STRING                '
LOCAL i, j, cTab1, cTab2, tMode, MEditOnce AS LONG                '
LOCAL lFD AS DIRDATA                                              '
   IF PARSECOUNT(Init, "?") = 1 THEN                              ' If just one file
      IF PProf  <> "" THEN Prof = PProf                           ' And .Profile passed? Save it
      IF PMacr  <> "" THEN Macr = PMacr                           ' or @macroname? Save it
      IF PXMacr <> "" THEN XMacr = PXMacr                         ' or /macroname? Save it
   END IF                                                         '
   FOR i = 1 TO PARSECOUNT(Init, "?")                             ' Loop for each file in list
      fn = PARSE$(Init, "?", i)                                   ' Extract the next name
      '--------------------------------------------------------------------------------------------+
      '- Open a normal type filename list                                                          |
      '--------------------------------------------------------------------------------------------+
      IF ISNULL(fn) THEN ITERATE FOR                              ' ignore null strings
      IF INSTR(fn, "|") = 0 THEN                                  ' Just a normal filename?
         IF LEFT$(fn, 3) = "(e)" OR LEFT$(fn, 3) = "(b)" OR LEFT$(fn, 3) = "(v)" THEN  cTab1 = %True  ' If lowercase, this was the active tab
         IF fn <> "NEW" THEN                                      ' If not the NEW quirk
            t = UCASE$(LEFT$(fn, 4))                              ' Get Open type
            IF MID$(t, 3, 1) = ")" THEN                           ' Just a (?) style?
               fn = MID$(fn, 4)                                   ' Reduce to a simple fn
               SELECT CASE AS CONST$ UCASE$(LEFT$(t, 3))          ' Handle it
                  CASE "(E)": tMode = %Edit                       ' Setup Edit
                  CASE "(B)": tMode = %Browse                     '       Browse
                  CASE "(V)": tMode = %View                       '       View
                  CASE ELSE: tMode = %Edit                        ' Else Edit
               END SELECT                                         '
            ELSEIF MID$(t, 4, 1) = ")" THEN                       ' A (??) style?
               fn = MID$(fn, 5)                                   ' Reduce to a simple fn
               SELECT CASE AS CONST$ UCASE$(LEFT$(t, 4))          ' Handle it
                  CASE "(OE)": tMode = %Edit                      ' Setup Edit
                  CASE "(OB)": tMode = %Browse                    '       Browse
                  CASE "(OV)": tMode = %View                      '       View
                  CASE ELSE: tMode = %Edit                        ' Else Edit
               END SELECT                                         '
            ELSE                                                  ' All else become Edit
               tMode = %Edit                                      '
            END IF                                                '
            IF ISNULL(PATHSCAN$(FULL, fn)) THEN                   ' Valid name?
               IF MRFMode THEN                                    ' Re-Open style?
                  DoMessageBox "While re-opening previous files, the following file cannot be found:" + $CRLF + $CRLF + _  '
                               "|K" + fn, %MB_OK OR %MB_USERICON, "SPFLite - Missing File"   '
                  ITERATE FOR                                     '
               ELSE                                               ' A command line OPEN
                  MakeNullFile(fn)                                ' Create it as an empty file
                  DoMessageBox "The specified file (|K" + fn + "|B), cannot be found:" + $CRLF + _ '
                               "Created as a Zero length file", %MB_OK OR %MB_USERICON, "SPFLite - Missing File"  '
               END IF                                             '
            END IF                                                '
            IF tMode = %Edit THEN                                 ' Opening for EDIT?
               t = DIR$(fn, TO lFD)                               ' Get all the DIR info
               IF ISNOTNULL(t) AND (lFD.FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY THEN '
                  tMode = %View                                   ' Switch to View
                  DoMessageBox "The specified Edit file (|K" + fn + "|B), is now Read-Only." + $CRLF + _ '
                               "It will be opened in |KView", %MB_OK OR %MB_USERICON, "SPFLite - Read-Only File"  '
               END IF                                             '
            END IF                                                '
         ELSE                                                     '
            fn = "": tMode = %Edit                                ' Null for a NEW request
         END IF                                                   '
         fn2 = fn                                                 ' Copy for SetFMCrit
         GOSUB SaveFMCrit                                         ' Go set FM criteria
         gEFTOpenSource = ""                                      ' Reset OPEN invoker
         IF tmode = %Edit THEN                                    ' Do the Opens
            gEFTOpenSource = "EDIT"                               ' Set OPEN invoker
            pCmdEdit("EDIT " + $DQ + fn + $DQ + " " + Prof + " " + Macr + " " + XMacr) '
         ELSEIF tmode = %View THEN                                '
            gEFTOpenSource = "VIEW"                               ' Set OPEN invoker
            pCmdView("VIEW " + $DQ + fn + $DQ + " " + Prof + " " + Macr + " " + XMacr) '
         ELSEIF tmode = %Browse THEN                              '
            gEFTOpenSource = "BROWSE"                             ' Set OPEN invoker
            pCmdBrowse("BROWSE " + $DQ + fn + $DQ + " " + Prof + " " + Macr + " " + XMacr)   '
         END IF                                                   '
         RESET Prof, Macr, XMacr                                  ' Use only once
         IF cTab1 THEN cTab2 = gTabsNum: cTab1 = %False           ' If that was the active tab, remember the tab number

      '--------------------------------------------------------------------------------------------+
      '- Open a MEDIT session again                                                                |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' A MEdit string
         cmd = ""                                                 ' Init command
         FOR j = 1 TO PARSECOUNT(fn, "|")                         ' Loop for each file in list
            fn2 = PARSE$(fn, "|", j)                              ' Extract the next MEdit name
            IF LEFT$(fn2, 3) = "(e)" THEN cTab1 = %True           ' Remember if this was the active tab
            IF IsEQ(LEFT$(fn2, 3), "(E)") THEN fn2 = MID$(fn2, 4) ' Strip off the (E)
            IF ISNULL(TRIM$(fn2)) THEN ITERATE FOR                '
            cmd += $DQ + fn2 + $DQ + " "                          '
            IF j = 1 THEN cmd += "NEW "                           ' Add NEW as 2nd operand
            IF ISFALSE MeditOnce THEN                             ' Just once
               MeditOnce = %True                                  '
               GOSUB SaveFMCrit                                   ' Go set FM criteria
            END IF                                                '
         NEXT j                                                   '
         TP.CallTab("MEDIT", cmd)                                 ' Go do it
         IF cTab1 THEN cTab2 = gTabsNum: cTab1 = %False           ' If that was the active tab, remember the tab number
      END IF                                                      '
   NEXT i                                                         ' Loop-de-loop
   IF cTab2 > 0 OR gENV.iDo <> "" THEN                            ' Have a tab to go to?
      IF gENV.iDo <> "" THEN CTab2 = 1                            ' If an iDo macro, go to FM
      TP = gTabs(CTab2)                                           ' Switch to correct tab
      TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber              ' Select the new tab
      TP.WindowTitle                                              ' Alter window title
      DoCursor                                                    ' Get cursor going
   END IF                                                         '
   GoToTab(0, "", "")                                             ' Clear the normal tab switcher, we've done it
   DoPendingTabDeletes                                            ' In case an OPEN was CANCELed out of
   EXIT SUB                                                       '

SaveFMCrit:                                                        '
   IF TP.LastLine > 2 THEN                                        ' If 1st tab already in use
      gENV.FMPath = LEFT$(fn2, INSTR(-1, fn2, "\"))               ' Pass FM variables to the called command
      gENV.FMMask = "*"                                           '
      gENV.FileListNm = ""                                        '
   ELSE                                                           ' Else we'll be using this one
      TP.OFrmFPath = LEFT$(fn2, INSTR(-1, fn2, "\"))              ' Save any 'where we were started from' values
      TP.OFrmFMask = "*"                                          '
      TP.OFrmFileL = ""                                           '
   END IF                                                         '
   RETURN                                                         '
END SUB                                                           '

FUNCTION DoInputBox(iText AS STRING, iTitle AS STRING, iDefault AS STRING) AS STRING   '
'--------------------------------------------------------------------------------------------------+
'- Get an InputBox answer                                                                          |
'--------------------------------------------------------------------------------------------------+
   KbdPopSave                                                     ' Ready for pop-up
   FUNCTION = TRIM$(INPUTBOX$(iText, iTitle, iDefault))           ' Issue it, return trimmed answer
   KbdPopRestore                                                  ' Reset popup state
END FUNCTION                                                      '

SUB DoKBSubst(RCA AS RCArea)                                      '
LOCAL t1, t2, t, tCB, TestItem AS STRING, TF, TFAny, TFCtr, i, j, k, l, IfEnd, IfElse, Negate, NumAnd, NumOr AS LONG, RCA2 AS RCArea '
LOCAL tPCRE, tPCRE2 AS DWORD, c1 AS WSTRING                       '
DIM TestTable(1 TO 1) AS STRING                                   '
   '-----------------------------------------------------------------------------------------------+
   '- Do the (SET0) - (SET9) substitution                                                          |
   '-----------------------------------------------------------------------------------------------+
   tPCRE = TP.hPCRE: TP.hPCRE = 0                                 ' Save any PCRE area
   t1 = RCA.Msg                                                   ' Get the string to be processed
   TFAny = %False                                                 ' Reset the flag for DFLT
   t = PCRERegexCompile("(?i)\(SET[0-9]\)")                       ' Check for (SETn)
   DO                                                             ' Look for one
      PCRERegexTest(t1, 1, j, k)                                  ' See if we can find it
      IF j THEN                                                   ' We have one
         SETTableUpd("GET", MID$(t1, j + 1, k - 2), RCA2)         ' GET The SETn SET value
         IF RCA2.RC <> 0 THEN RCA2.Msg = ""                       ' If error(missing) then make it null
         REPLACE MID$(t1, j, k) WITH RCA2.Msg IN t1               ' Substitute it
      END IF                                                      '
   LOOP UNTIL j = 0                                               ' t1 is adjusted on loop exit

   '-----------------------------------------------------------------------------------------------+
   '- Now see if any conditional tests                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(t1) THEN RCA.RC = 0: RCA.Msg = "(Null)": GOSUB Cleanup: EXIT SUB ' Nothing left? Return (Null)
   t = PCRERegexCompile("(?i)\<IF\.[[:ascii:]]{1,}?\>")           ' Check for <IF.xxxx>

   StartOver:                                                     '
   PCRERegexTest(t1, 1, j, k)                                     ' See if we can find it
   IF j = 0 THEN RCA.RC = 0: RCA.Msg = t1: GOSUB Cleanup: EXIT SUB   ' No nore? Return what's left
   t2 = MID$(t1, j + 4, k - 5)                                    ' Get the xxxx from <IF.xxxx>

   '-----------------------------------------------------------------------------------------------+
   '- Do all requested tests                                                                       |
   '-----------------------------------------------------------------------------------------------+
   NumAnd = TALLY(t2, "+"): NumOr = TALLY(T2, "|")                ' Count ANDs and ORs
   IF NumAnd <> 0 AND NumOr <> 0 THEN                             ' Unsupported?
      RCA.RC = 8: RCA.Msg = "Conditional tests cannot use both AND/OR:" + $CRLF + t1
      GOSUB Cleanup: EXIT SUB                                     '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do we have more than 1 test                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF INSTR(t2, ANY "+|") = 0 THEN                                ' Just a simple one?
      TestItem = t2: GOSUB TestOne                                ' Just test it
   ELSE                                                           ' Multiple tests
      IF INSTR(t2, "+") <> 0 THEN                                 ' The AND type
         i = PARSECOUNT(t2, "+")                                  ' Get count
         REDIM TestTable(1 TO i) AS STRING                        ' Ready table
         PARSE T2, TestTable(), "+"                               ' Break it out
         TFCtr = 0                                                ' Reset count
         FOR l = 1 TO i                                           '
            TestItem = TestTable(l): GOSUB TestOne                ' Test each one
            IF TF THEN INCR TFCtr                                 ' Count winners
         NEXT l                                                   '
         TF = IIF(TFCtr = i, %True, %False)                       ' TF = True only if all are true
      ELSEIF INSTR(t2, "|") <> 0 THEN                             ' The OR type
         i = PARSECOUNT(t2, "|")                                  ' Get count
         REDIM TestTable(1 TO i) AS STRING                        ' Ready table
         PARSE T2, TestTable(), "|"                               ' Break it out
         FOR l = 1 TO i                                           '
            TestItem = TestTable(l): GOSUB TestOne                ' Test each one
            IF TF THEN EXIT FOR                                   ' A winner, we're done
         NEXT l                                                   '
      END IF                                                      '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- How did the test go                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IfEnd = INSTR(j + 1, t1, "<>")                                 ' Look for closing <>
   IfElse = INSTR(j + 1, t1, "||")                                ' See if there's an ELSE || present
   IF IfElse > IfEnd THEN IfElse = 0                              ' If || outside current test, make it not found
   IF IfEnd = 0 THEN _                                            ' Oops, exit
      RCA.RC = 8: RCA.Msg = "Invalid conditional test in:" + $CRLF + t1: GOSUB Cleanup: EXIT SUB   '
   IF TF = 0 THEN                                                 ' If FALSE
      IF IfElse = 0 THEN                                          ' No? Then skip this test string
         t1 = LEFT$(t1, j - 1) + MID$(t1, IfEnd + 2)              ' t1 has '<IF.xxx>yyy<>' removed
      ELSE                                                        ' A False string is present
         t2 = MID$(t1, IfElse + 2 TO IfEnd - 1)                   ' t2 has the false-string
         t1 = LEFT$(t1, j - 1) + t2 + MID$(t1, IfEnd + 2)         ' t1 has LH + t2 + RH
      END IF                                                      '
   ELSE                                                           ' TRUE
      TFAny = %True                                               ' Remember something was TRUE
      IF IsEQ(t2, "NONE") THEN TFAny = %False                     ' Reset TFANY in case it's not end-of-string
      IF IfElse THEN                                              ' We have a || delimiter
         t2 = MID$(t1, j + k TO IfElse - 1)                       ' t2 = the true-string
      ELSE                                                        ' Else the <> delimiter
         t2 = MID$(t1, j + k TO IfEnd - 1)                        ' t2 = the true-string
      END IF                                                      '
      t1 = LEFT$(t1, j - 1) + t2 + MID$(t1, IfEnd + 2)            ' t1 has '<IF.xxx>ccc<>' replaced with 'ccc'
   END IF                                                         '
   GOTO StartOver                                                 ' Loop back and continue

   '-----------------------------------------------------------------------------------------------+
   '- Test 1 type stored in TestItem                                                               |
   '-----------------------------------------------------------------------------------------------+
   TestOne:
      TF = %False: Negate = %False                                ' Start as False
      IF LEFT$(TestItem, 1) = "-" THEN                            ' Invert answer?
         Negate = %True: TestItem = MID$(TestItem, 2)             ' Remove the -
      END IF
      SELECT CASE AS CONST$ UCASE$(TestItem)                      ' Process the conditional test
         CASE "SPELL":    IF TP.GPCType = %CLData THEN            ' If in the data area
                             c1 = TP.AttrHiLiteGet(TP.GPCIX, TP.GPCLCol, TP.GPCLCol)  ' Get the hi-light
                             IF TP.SpellClr <> 0 AND c1 = CHR$$(TP.SpellClr) THEN TF = %True   ' And if = SpellClr, then True
                          END IF                                  '
         CASE "FM":       IF IsFMTab THEN TF = %True              ' Do the tests
         CASE "NONE":     IF ISFALSE TFAny THEN TF = %True        '
         CASE "EDIT":     IF IsEdit THEN TF=%True                 '
         CASE "BROWSE":   IF IsBrowse THEN TF = %True             '
         CASE "VIEW":     IF IsView THEN TF = %True               '
         CASE "CLIPEDIT": IF IsClip THEN TF = %True               '
         CASE "EFTEDIT":  IF IsEFTEdit THEN TF = %True            '
         CASE "SETEDIT":  IF IsSetEdit THEN TF = %True            '
         CASE "MEDIT":    IF IsMedit THEN TF = %True              '
         CASE "RDONLY":   IF IsView AND TP.FCB_.ROState THEN TF = %True
         CASE "CMND":     IF TP.GPCType = %CCmd THEN TF = %True   '
         CASE "LNUM":     IF TP.GPCType = %CLCmd OR TP.GPCType = %CFLCmd THEN TF = %True '
         CASE "DATA":     IF TP.GPCType = %CLData OR TP.GPCType = %CFLData THEN TF = %True  '
         CASE "PATH":     IF TP.GPCType = %CFPath THEN TF = %True '
         CASE "MASK":     IF TP.GPCType = %CFMask THEN TF = %True '
         CASE "LOCKED":   IF TP.GPCType = %CBad THEN TF = %True   '
         CASE "KB0":      SETTableUpd("GET", "KB0", RCA2)         ' GET The SET value
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  ' Set True if Y
         CASE "KB1":      SETTableUpd("GET", "KB1", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB2":      SETTableUpd("GET", "KB2", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB3":      SETTableUpd("GET", "KB3", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB4":      SETTableUpd("GET", "KB4", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB5":      SETTableUpd("GET", "KB5", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB6":      SETTableUpd("GET", "KB6", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB7":      SETTableUpd("GET", "KB7", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB8":      SETTableUpd("GET", "KB8", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "KB9":      SETTableUpd("GET", "KB9", RCA2)         '
                          IF UCASE$(RCA2.Msg) = "Y" THEN TF = %True  '
         CASE "CAPS":     IF ISTRUE (GetKeyState(%VK_CAPITAL) AND 1) THEN TF = %True  '
         CASE "SCROLL":   IF ISTRUE (GetKeyState(%VK_SCROLL) AND 1)  THEN TF = %True  '
         CASE "NUM":      IF ISTRUE (GetKeyState(%VK_NUMLOCK) AND 1) THEN TF = %True  '
         CASE "INS":      IF IsTPNsrtFlag THEN TF = %True         ' Insert mode
         CASE "CLIP":     CLIPBOARD GET TEXT TO tCB: IF ISNOTNULL(tCB) THEN TF = %True   ' Is something in CB?
         CASE "PAGE":     IF ISTRUE TP.FCB_.PageFlag THEN TF = %True ' Is PAGE ON
         CASE "SELECT":   IF (IsTPMarkActive AND IsTPMarkDrawn) OR _ ' Is something selected
                          (IsTPMiscActive AND IsTPMiscDrawn) THEN TF = %True '
         CASE ELSE                                                ' Better be Profname/Setname
            IF LEFT$(TestItem, 1) <> "!" AND LEFT$(TestItem, 1) <> "#" THEN _ ' Must be ! or #
               RCA.RC = 8: RCA.Msg = "Invalid conditional test in:" + $CRLF + t1: GOSUB Cleanup: EXIT SUB   '
            IF LEFT$(TestItem, 1) = "!" THEN                      ' Profile test?
               IF IsEQ(MID$(TestItem, 2), TP.FCB_.ProfName) THEN TF = %True' Match the Profile?
            END IF                                                '
            IF LEFT$(TestItem, 1) = "#" THEN                      ' SETname test?
               SETTableUpd("GET", MID$(TestItem, 2), RCA2)        ' GET The #xxxx SET value
               IF RCA2.RC <> 8 THEN TF = %True                    ' True if present
            END IF                                                '
      END SELECT                                                  '
      IF Negate THEN TF = IIF(TF, %False, %True)                  ' Reverse if asked for
   RETURN                                                         '

   Cleanup:                                                       '
      tPCRE2 = TP.hPCRE                                           ' Copy the one created by us
      TP.hPCRE = tPCRE                                            ' Restore the main PCRE compile area
      TRY                                                         ' Free the PCRE area we created
         FREE tPCRE2                                              ' Free it one way
      CATCH                                                       ' Oops, try the other way
         CALL DWORD gPCRE_hProc_Free_Ptr USING pcre_free( _       ' Free it
                    tPCRE2)                                       ' Compile handle
      END TRY                                                     '
   RETURN                                                         '
END SUB                                                           '

FUNCTION DoKMacroSubst(macline AS STRING) AS LONG                 '
'--------------------------------------------------------------------------------------------------+
'- Handle all the difficult ~K(...) substitutions                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG, Kline, Kkey1, KKey2, KData, KeyMode AS STRING '
LOCAL KeyName AS STRING * 12                                      '
   MEntry                                                         '
   KLine = macline                                                '
   i = INSTR(UUCASE(Kline), "~K("): IF i = 0 THEN i = INSTR(UUCASE(KLine), "^K(")   ' Find next ~K(
   DO WHILE i > 0                                                 ' Loop-de-loop
      k = INSTR(i, KLine, ")")                                    ' Look for closing bracket
      IF k = 0 OR k = i + 3 THEN FUNCTION = %True: MExitFunc      ' No?? or null (), Error return
      Kkey1 = MID$(Kline, i, k - i + 1)                           ' Extract K key1 ~K(xxx)
      Kkey2 = MID$(Kline, i + 3, k - i - 3)                       ' Extract K key2 xxx
      SELECT CASE AS CONST$ UUCASE(Kkey2)                         ' OK then, what've we got
         CASE "DATE"                                              ' DATE
            REPLACE KKey1 WITH DateWinFormat() IN KLine           '
         CASE "ISODATE"                                           ' ISODate
            KData = DATE$                                         ' Go get the date
            KData = MID$(KData, 7) + "-" + LEFT$(KData, 2) + "-" + MID$(KData, 4, 2)   ' Reformat it to ISO standard
            REPLACE KKey1 WITH KData IN KLine                     '
         CASE "ISOTIME"                                           ' ISOTime
            REPLACE KKey1 WITH TIME$ IN KLine                     '
         CASE ELSE                                                ' We're left with a Keyname style
            KeyMode = ""                                          ' Default mode
            KKey2 = UUCASE(KKey2)                                 '
            KeyName = KKey2                                       '
            j = INSTR(KKey2, "-")                                 ' Look for a dash
            IF j THEN                                             ' A dash, complicate it
               IF INSTR(LEFT$(KKey2, j - 1), "S") THEN KeyMode += "S"   '
               IF INSTR(LEFT$(KKey2, j - 1), "C") THEN KeyMode += "C"   '
               IF INSTR(LEFT$(KKey2, j - 1), "A") THEN KeyMode += "A"   '
               KeyName = MID$(KKey2, j + 1)                       ' Separate keyname
            END IF                                                '
            FOR j = 1 TO 104                                      ' Search the key master table
               IF gKbdT.Labl(j) = KeyName THEN                    ' Find the key?
                  IF ISNULL(Keymode) THEN KData = gKbdT.NData(j)  ' Select correct text string
                  IF Keymode = "S"   THEN KData = gKbdT.SData(j)  '
                  IF Keymode = "C"   THEN KData = gKbdT.CData(j)  '
                  IF Keymode = "A"   THEN KData = gKbdT.AData(j)  '
                  IF Keymode = "SC"  THEN KData = gKbdT.SCData(j) '
                  IF Keymode = "SA"  THEN KData = gKbdT.SAData(j) '
                  IF Keymode = "SCA" THEN KData = gKbdT.SCAData(j)   '
                  IF Keymode = "CA"  THEN KData = gKbdT.CAData(j) '
                  IF LEFT$(KData, 1) = "[" THEN                   ' Emitted text?
                     DO WHILE INSTR(KData, "[[")                  ' Clean up pairs
                        REPLACE "[[" WITH "[" IN KData            '
                     LOOP                                         '
                     DO WHILE INSTR(KData, "]]")                  ' Clean up pairs
                        REPLACE "]]" WITH "]" IN KData            '
                     LOOP                                         '
                     KData = MID$(KData, 2): KData = CLIP$(RIGHT, KData, 1)   '
                     REPLACE KKey1 WITH KData IN KLine            '
                     EXIT SELECT                                  '
                  ELSEIF LEFT$(Kdata, 1) = "(" OR LEFT$(Kdata, 1) = "{" THEN  '
                     FUNCTION = %True: MExitFunc                  '
                  ELSE                                            ' Non-bracketed string
                     REPLACE KKey1 WITH KData IN KLine            '
                     EXIT SELECT                                  '
                  END IF                                          '
               END IF                                             '
            NEXT j                                                '
            FUNCTION = %True: MExitFunc                           '
      END SELECT                                                  '
      i = INSTR(UUCASE(Kline), "~K("): IF i = 0 THEN i = INSTR(UUCASE(KLine), "^K(")   ' Find next ~K(
   LOOP                                                           '
   macline = KLine                                                '
   FUNCTION = %False                                              ' All is well
   MExit                                                          '
END FUNCTION                                                      '

SUB DoLCmdShiftLeft(BYREF orig_line         AS STRING, _          '
                    BYREF orig_attr         AS WSTRING, _         '
                    BYVAL shift_amount      AS LONG, _            '
                    BYVAL left_bound        AS LONG, _            '
                    BYVAL right_bound       AS LONG, _            '
                    BYREF shift_error       AS LONG, _            '
                    BYREF shift_change      AS LONG)              '
'--------------------------------------------------------------------------------------------------+
'-  DoLCmdShiftLeft                                                                                |
'-                                                                                                 |
'-  Accepts data line, bounds, and left-shift amount.                                              |
'-                                                                                                 |
'-  Returns shifted data as result, plus flag if "Data shifting incomplete"                        |
'-  has occurred. A revised color line is also returned.                                           |
'--------------------------------------------------------------------------------------------------+
DIM seg (0 TO 1)        AS DataShift_Segment_t                    '  REDIM'd by Setup
LOCAL space_width, delta, max_delta, s, seg_count  AS LONG        '
   MEntry                                                         '
   shift_error = 0                                                '
   shift_change = 0                                               '

   '-----------------------------------------------------------------------------------------------+
   '-  perform setup common to all < > << >> shifts                                                |
   '-  if Setup fails, pass original line back as is without reporting an error                    |
   '-----------------------------------------------------------------------------------------------+
   seg_count = DoLcmdShiftSetup                                               _  '
   (  orig_line                                                               _  '
   ,  shift_amount                                                            _  '
   ,  left_bound                                                              _  '
   ,  right_bound                                                             _  '
   ,  space_width                                                             _  '
   ,  seg ()                                                                  _  '
      )                                                           '''

   IF seg_count < 1 THEN                                          '
      '--------------------------------------------------------------------------------------------+
      '- line is zero-length, entirely blank, or data configuration will not permit a shift to take place|
      '--------------------------------------------------------------------------------------------+

      MExitSub                                                    '
   END IF                                                         '

   IF seg(1).gap_len <= space_width THEN                          '
      '--------------------------------------------------------------------------------------------+
      '-  first segment is already as far left as it can go, can't shift it                        |
      '--------------------------------------------------------------------------------------------+
      shift_error = 1                                             '  Data shifting incomplete
      MExitSub                                                    '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '-  max_delta is the maximum possible left-shift for segment 1                                  |
   '-----------------------------------------------------------------------------------------------+
   max_delta = seg(1).gap_len - space_width                       '

   '-----------------------------------------------------------------------------------------------+
   '- if shift_amount does not exceed the max_delta, then shift will be                            |
   '- successful, otherwise only shift by the max_delta and set the error flag                     |
   '- because we were not able to shift as much as was requested                                   |
   '-----------------------------------------------------------------------------------------------+
   IF shift_amount <= max_delta THEN                              '
      delta = shift_amount                                        '  shift for the amount requested
   ELSE                                                           '
      shift_error = 1                                             '  can't shift as much as requested
      delta = max_delta                                           '  only shift as much as possible
   END IF                                                         '
   seg(1).gap_len -= delta                                        '  slide segment 1 to the left

   '-----------------------------------------------------------------------------------------------+
   '- locate a segment, starting with segment 2, where the number of leading                       |
   '- spaces is greater than space_width that also contains data. when found,                      |
   '- that segment gets additional leading spaces to match the amount shifted                      |
   '- left by segment 1.                                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF delta > 0 THEN                                              '
      FOR s = 2 TO seg_count                                      '
         IF seg(s).gap_len > space_width AND seg(s).data_len > 0 THEN   '
            seg(s).gap_len += delta                               '
            delta = 0                                             '
            EXIT FOR                                              '
         END IF                                                   '
      NEXT                                                        '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- if the process above couldn't assign the blanks anywhere, put the blanks                     |
   '- on the tail segment regardless of any leading blanks IT may have, as long                    |
   '- as there is any data on it. otherwise, just discard the extra blanks,                        |
   '- and the line will end up being shorter.                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF delta > 0 THEN                                              '
      IF seg(seg_count+1).data_len > 0 THEN                       '
         seg(seg_count+1).gap_len += delta                        '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- after seg table has been adjusted, reconstruct and return a new data line                    |
   '-----------------------------------------------------------------------------------------------+
   DoLCmdShiftResult ( _                                          '
                      orig_line, _                                '
                      orig_attr, _                                '
                      seg (), _                                   '
                      seg_count, _                                '
                      shift_error, _                              '
                      shift_change )                              '
   MExit                                                          '
END SUB                                                           ' DoLCmdShiftLeft

SUB DoLcmdShiftResult(BYREF orig_line         AS STRING, _        '
                      BYREF orig_attr         AS WSTRING, _       '
                      BYREF seg ()            AS DataShift_Segment_t, _ '
                      BYVAL seg_count         AS LONG, _          '
                      BYREF shift_error       AS LONG, _          '
                      BYREF shift_change      AS LONG)            '
'--------------------------------------------------------------------------------------------------+
'- DoLcmdShiftResult                                                                               |
'-                                                                                                 |
'- using guidance from the segment table, transform orig_line string into a                        |
'- new string, in which the spacing between segments has been modified.                            |
'- build a string with modified spacing and copy back to orig_line.                                |
'--------------------------------------------------------------------------------------------------+
LOCAL work_line                                   AS STRING       '
LOCAL work_attr, Attr_Data, color_attr, cw        AS WSTRING      '
LOCAL work_size, work_pos, work_len, i            AS LONG         '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- "tail" segment is in segment (seg_count + 1).                                                |
   '-----------------------------------------------------------------------------------------------+

   work_size = 0                                                  '
   FOR i = 0 TO seg_count + 1                                     '
      work_size += seg(i).gap_len + seg(i).data_len               '
   NEXT                                                           '

   work_line  = SPACE$ (work_size)                                '
   work_attr = REPEAT$(work_size, CHR$$(0))                       '

   '-----------------------------------------------------------------------------------------------+
   '- copy data positions into work_line. since work_line already has blanks,                      |
   '- we don't need to copy the spaces - just skip over them.                                      |
   '-                                                                                              |
   '- if a color line was defined, create a new color line. in case the                            |
   '- original color line was short, the new one will have the same size as                        |
   '- the new data line.                                                                           |
   '-----------------------------------------------------------------------------------------------+
   work_pos = 1                                                   '
   FOR i = 0 TO seg_count + 1                                     '

      '--------------------------------------------------------------------------------------------+
      '- if a color line is defined, we have to copy the original color                            |
      '- attributes, if any, for blank characters as well as nonblanks.                            |
      '- if the size of a blank span has changed, the color attributes are                         |
      '- truncated or propagated on the right                                                      |
      '--------------------------------------------------------------------------------------------+

      '--------------------------------------------------------------------------------------------+
      '- the target location for the attribues of blanks is at 'work_pos'                          |
      '--------------------------------------------------------------------------------------------+
      IF  LEN(orig_Attr)  > 0  _                                  '  colors are defined
      AND seg(i).gap_len   > 0 _                                  '
      AND seg(i).blank_pos > 0 _                                  '
      AND seg(i).blank_len > 0 THEN                               '  need to copy blank attributes
         attr_data = MID$ (orig_attr, seg(i).blank_pos, seg(i).blank_len)  '

         color_attr = RIGHT$ (attr_data, 1)                       '
         MID$ (work_attr, work_pos, seg(i).gap_len) = _           '
            LSET$ (attr_data, seg(i).gap_len USING color_attr)    '

      END IF                                                      '

      work_pos += seg(i).gap_len                                  '
      work_len =  seg(i).data_len                                 '

      IF work_len > 0 THEN                                        '

         MID$ (work_line, work_pos, work_len) = _                 '
            MID$ (orig_line, seg(i).data_pos, work_len)           '

         cw = MID$ (orig_attr, seg(i).data_pos, work_len)         '
         cw = LSET$ (cw, work_len USING CHR$$(0))                 '  force matching length
         MID$ (work_attr, work_pos, work_len) = cw                '  update color line
         work_pos += work_len                                     '
      END IF                                                      '
   NEXT                                                           '

   IF orig_line = work_line THEN                                  '
      shift_error = 1                                             '  shift did not result in any change
      shift_change = 0                                            '  caller should not modify the line

   ELSE                                                           '
      '--------------------------------------------------------------------------------------------+
      '-  leave shift_error as-is, in case it was set on elsewhere                                 |
      '--------------------------------------------------------------------------------------------+

      shift_change = 1                                            '  caller should modify the line
      orig_line = work_line                                       '
      orig_attr = work_attr                                       '
   END IF                                                         '
   MExit                                                          '
END SUB                                                           ' DoLcmdShiftResult

SUB DoLcmdShiftRight(BYREF orig_line         AS STRING, _         '
                     BYREF orig_attr         AS WSTRING, _        '
                     BYVAL shift_amount      AS LONG, _           '
                     BYVAL left_bound        AS LONG, _           '
                     BYVAL right_bound       AS LONG, _           '
                     BYREF shift_error       AS LONG, _           '
                     BYREF shift_change      AS LONG)             '

'--------------------------------------------------------------------------------------------------+
'- DoLcmdShiftRight                                                                                |
'-                                                                                                 |
'- Accepts data line, bounds, and right-shift amount.                                              |
'-                                                                                                 |
'- Returns shifted data as result, plus flag if "Data shifting incomplete"                         |
'- has occurred. A revised color line is also returned.                                            |
'--------------------------------------------------------------------------------------------------+
DIM seg (0 TO 1)        AS DataShift_Segment_t                    '  REDIM'd by Setup

LOCAL right_edge, space_width, delta, remaining_delta, remaining_room AS LONG '
LOCAL right_bound_temp, s, seg_count  AS LONG                     '
   MEntry                                                         '
   shift_error = 0                                                '
   shift_change = 0                                               '

   '-----------------------------------------------------------------------------------------------+
   '- for a right data-shift, if we are running in BOUND MAX mode, add the                         |
   '- shift amount to the current length so we can make the line longer.                           |
   '- if we shift-right by n, the new line can't be any longer than 'n'                            |
   '- more than it already is, but it could possibly increase in size by                           |
   '- less than that (including zero, if the shift is 'taken up' by other                          |
   '- segments within the line.                                                                    |
   '- we check shift_amount > 0 to be sure we don't mask any parameter errors                      |
   '-----------------------------------------------------------------------------------------------+

   IF TP.FCB_.BndRight = 0 AND shift_amount > 0 THEN              '
      right_bound_temp = LEN (orig_line) + shift_amount           '
   ELSE                                                           '
      right_bound_temp = right_bound                              '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- perform setup common to all < > << >> shifts                                                 |
   '- if Setup fails, pass original line back as is without reporting an error                     |
   '-----------------------------------------------------------------------------------------------+
   seg_count = DoLcmdShiftSetup( _                                '
                                orig_line, _                      '                                                               _
                                shift_amount, _                   '
                                left_bound, _                     '
                                right_bound_temp, _               '
                                space_width, _                    '                                                             _
                                seg () _                          '
                               )                                  '

   IF seg_count < 1 THEN                                          '
      '--------------------------------------------------------------------------------------------+
      '- line is zero-length, entirely blank, or data configuration will not                       |
      '- permit a shift to take place                                                              |
      '--------------------------------------------------------------------------------------------+
      MExitSub                                                    '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- for all segments after the first one, attempt to collapse as many blanks                     |
   '- as possible, as long as doing to does not reduce the leading spaces by                       |
   '- less than space_width, nor removing more total spaces than then number of                    |
   '- columns in the shift_amount. the process continues until the complete                        |
   '- number of columns have been shifted, or there are no more segments with                      |
   '- which to apply them.                                                                         |
   '-----------------------------------------------------------------------------------------------+
   remaining_delta = shift_amount                                 '

   FOR s = 2 TO seg_count                                         '
      IF remaining_delta = 0 THEN EXIT FOR                        '

      '--------------------------------------------------------------------------------------------+
      '- the maximum possible number of leading blanks we can remove cannot                        |
      '- exceed space_width, unless the segment is a final one that contains                       |
      '- only blanks and no data. when that exists, all the blanks can be                          |
      '- taken.                                                                                    |
      '--------------------------------------------------------------------------------------------+
      IF s = seg_count        _                                   '
      AND seg(s).gap_len > 0 _                                    '
      AND seg(s).data_len = 0 THEN                                '
         '-----------------------------------------------------------------------------------------+
         '-  this is the last segment within bounds, and it's all blanks                           |
         '-----------------------------------------------------------------------------------------+
         delta = seg(s).gap_len                                   '
      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '-  this is a non-last segment, so don't take more than space_width                       |
         '-----------------------------------------------------------------------------------------+
         delta = seg(s).gap_len - space_width                     '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '-  unless the potential blanks is > 0 we cannot alter this segment                          |
      '--------------------------------------------------------------------------------------------+
      IF delta > 0 THEN                                           '
         '-----------------------------------------------------------------------------------------+
         '- if there are more leading blanks available than we need, take only                     |
         '- as many as needed; otherwise only take the possible amount                             |
         '-----------------------------------------------------------------------------------------+
         IF delta > remaining_delta THEN                          '
            delta = remaining_delta                               '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '-  move this segment closer to the one preceding it, while at the same                   |
         '-  time moving segment 1 to the right by the same amount                                 |
         '-----------------------------------------------------------------------------------------+
         seg(s).gap_len -= delta                                  '  rob Peter ...
         seg(1).gap_len += delta                                  '  to pay Paul ...
         remaining_delta -= delta                                 '
      END IF                                                      '
   NEXT                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- after distributing the spaces as best we can, if there are any spaces                        |
   '- not distributed, it is a potential shift error. the "tail" segment of                        |
   '- the line is at seg(seg_count+1). if this seg has a data length, then                         |
   '- the tail is not movable, and we have a shift error. if seg(seg_count+1)                      |
   '- has a data len of 0, it was at the end of the bounds or end of line.                         |
   '-                                                                                              |
   '- if that is so, and we are running with BOUNDS MAX, then we will assume                       |
   '- that the line is extensible, and all remaining blanks will be applied to                     |
   '- the first segment; otherwise a shift error is reported, and we have                          |
   '- shifted the line as much as it's ever going to get shifted.                                  |
   '-----------------------------------------------------------------------------------------------+
   IF remaining_delta > 0 THEN                                    '  shift is incomplete
      right_edge = 0                                              '
      FOR s = 0 TO seg_count + 1                                  '
         right_edge += seg(s).gap_len + seg(s).data_len           '
      NEXT                                                        '

      IF seg(seg_count+1).data_len > 0 THEN                       '  tail set not movable
         shift_error = 1                                          '

      ELSEIF right_edge < right_bound THEN                        '
         '-----------------------------------------------------------------------------------------+
         '- line is shorter than the right bound. if the difference between                        |
         '- the two is enough for the remaining shift amount, use it and shift                     |
         '- is successful. if not, use as much as is available and report that                     |
         '- the shift if incomplete                                                                |
         '-----------------------------------------------------------------------------------------+
         remaining_room = right_bound - right_edge                '

         IF remaining_room >= remaining_delta THEN                '
            seg(1).gap_len += remaining_delta                     '
         ELSE                                                     '
            seg(1).gap_len += remaining_room                      '
            shift_error = 1                                       '
         END IF                                                   '

      ELSEIF TP.FCB_.BndRight > 0 THEN                            '  BOUNDS MAX not in effect
         shift_error = 1                                          '  tail is null but line not extensible
      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '-  first segment gets all remaining blanks, and pushes line to right                     |
         '-----------------------------------------------------------------------------------------+
         seg(1).gap_len += remaining_delta                        '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '-  after seg table has been adjusted, reconstruct and return a new data line                   |
   '-----------------------------------------------------------------------------------------------+
   DoLcmdShiftResult (     _                                      '
      orig_line,           _                                      '
      orig_attr,           _                                      '
      seg (),              _                                      '
      seg_count,           _                                      '
      shift_error,         _                                      '
      shift_change)                                               '
   MExit                                                          '
END SUB                                                           ' DoLcmdShiftRight

FUNCTION DoLcmdShiftSetup(BYVAL orig_line            AS STRING, _ '
                            BYVAL shift_amount      AS LONG, _    '
                            BYVAL left_bound        AS LONG, _    '
                            BYVAL right_bound       AS LONG, _    '
                            BYREF space_width       AS LONG, _    '
                            BYREF seg ()            AS DataShift_Segment_t)  AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- DoLcmdShiftSetup                                                                                |
'-                                                                                                 |
'- Perform processing common to < > << and >> commands                                             |
'-                                                                                                 |
'- If errors, return 0 else return number of segments found                                        |
'- segment 0 will contain the number of trailing blanks                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i, s, n, seg_count, left_edge, right_edge     AS LONG       '
LOCAL test_line, c, quote               AS STRING                 '
LOCAL gap_len, data_pos, data_end, data_len, span   AS LONG       '
LOCAL blank_pos, blank_len AS LONG                                '
LOCAL check_escape  AS LONG                                       '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- validate parameters. part of this is to ensure calling code is correct,                      |
   '- and part is to filter out situations where we just can't shift anything.                     |
   '-----------------------------------------------------------------------------------------------+
   n = LEN (orig_line)                                            '
   IF n = 0 OR _                                                  '  can't shift-left a null line
      shift_amount < 1 OR _                                       '  shift amount is illegal
      left_bound < 1 OR _                                         '  bound location doesn't make sense
      left_bound >= right_bound OR _                              '  bound location doesn't make sense
      n < left_bound THEN                                         '  data is not in the bounded area
      FUNCTION = 0                                                '  unable to perform data shift
      MExitFunc                                                   '
   END IF                                                         '

   right_edge = MIN(n, right_bound)                               '
   IF VERIFY (MID$ (orig_line, left_bound TO right_edge), " ") = 0 THEN '
      '--------------------------------------------------------------------------------------------+
      '-  entire line within eligible area is blank                                                |
      '--------------------------------------------------------------------------------------------+
      FUNCTION = 0                                                '  unable to perform data shift
      MExitFunc                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- fetch overriding size of gap, and escape usage, if SET names defined                         |
   '-----------------------------------------------------------------------------------------------+
   space_width = SETReturnNumber ("OPT.DS.MINSIZE")               '
   IF space_width < 1 OR space_width > 9 THEN space_width = 1     '
   check_escape = SETReturnNumber ("OPT.DS.ESCAPE")               '
   IF check_escape <> 0 THEN check_escape = 1                     '

   '-----------------------------------------------------------------------------------------------+
   '- copy orig_line to test_line, changing unusable blanks into underscores                       |
   '- the test line is just used for calculating segment positioning, while                        |
   '- the orig_line remains the correct source of data                                             |
   '-                                                                                              |
   '- when spans of blanks are inside quoted strings, they are unusable.                           |
   '- however, according to ISPF logic, if a quoted string is never properly                       |
   '- closed, the (leading) quote is simply ignored. so, we have to do a                           |
   '- lookahead to make sure the opening quote has a trailing quote, otherwise                     |
   '- the string is not closed and we have to treat the quote as ordinary data.                    |
   '-----------------------------------------------------------------------------------------------+
   test_line = orig_line                                          '
   i = 1                                                          '
   quote = " "                                                    '

   DO WHILE i <= n                                                '
      c = MID$(test_line, i, 1)                                   '
      IF quote = " " THEN                                         '  not currently inside a string
         IF c = $DQ OR c = "'" THEN                               '
            IF StrIsProper(test_line, i, check_escape) THEN       '
               quote = c                                          '
            END IF                                                '

         ELSEIF c = " " THEN                                      '
            IF i < left_bound OR i > right_bound THEN             '
               MID$(test_line, i, 1) = "_"                        '  blanks outside bounds
            END IF                                                '
         END IF                                                   '

      ELSE                                                        '  inside a quote
         IF c = $DQ OR c = "'" THEN                               '
            quote = " "                                           '  quote has been closed
         ELSEIF c = " " THEN                                      '
            MID$(test_line, i, 1) = "_"                           '  quoted blanks are not eligible
         ELSEIF check_escape = 1 AND c = "\" THEN                 '  escaped char, maybe quote
            i += 1                                                '  skip over escape
            IF i <= n THEN                                        '
               IF MID$(test_line, i, 1) = " " THEN _              '
                  MID$(test_line, i, 1) = "_"                     '  ignore any escaped blank
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      i += 1                                                      '
   LOOP                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- spans of blanks that are still eligible from the logic above, but are                        |
   '- shorter than space_width are treated as if not blank at all. this only                       |
   '- applies when space_width > 1; otherwise all blanks spans are eligible.                       |
   '-                                                                                              |
   '- if there is no label at the left_bound, but there is a span of spaces                        |
   '- but (possibly) less than the space_width, that initial part of the line                      |
   '- can be detached during a shift right. so, any initial leading blanks are                     |
   '- skipped, even if shorter than shift_width.                                                   |
   '-                                                                                              |
   '- these added considerations don't exist in ISPF, because they only have a                     |
   '- fixed space-width of 1, while this code supports a variable space_width.                     |
   '-                                                                                              |
   '- if there is a short span starting at the left bound, allow it. this                          |
   '- makes it possible to detach from the left boundary during a right shift                      |
   '- if the space_width is > 1.                                                                   |
   '-                                                                                              |
   '- columns to the left of left_bound have already been handled.                                 |
   '-----------------------------------------------------------------------------------------------+
   IF space_width > 1 THEN                                        '
      i = left_bound                                              '

      '--------------------------------------------------------------------------------------------+
      '-  skip over any initial non-label blanks, regardless of size                               |
      '--------------------------------------------------------------------------------------------+
      DO WHILE i <= n AND MID$(test_line, i, 1) = " "             '
         i += 1                                                   '
      LOOP                                                        '

      DO WHILE i <= n                                             '
         IF MID$(test_line, i, 1) = " " THEN                      '
            span = GetLeadingBlanks (test_line, i)                '
            IF span < 1 THEN EXIT DO                              '  failsafe
            IF span < space_width THEN                            '  short span

               '-----------------------------------------------------------------------------------+
               '-  short spans are ineligible, except if starting at left bound                    |
               '-----------------------------------------------------------------------------------+
               IF i > left_bound THEN                             '
                  MID$(test_line, i, span) = STRING$ (span, "_")  '
               END IF                                             '
            END IF                                                '
            i += span                                             '  skip over span whether short or not

         ELSE                                                     '
            i += 1                                                '
         END IF                                                   '
      LOOP                                                        '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '-  count number of segments, and allocate seg table.                                           |
   '-----------------------------------------------------------------------------------------------+
   i = 1                                                          '
   s = 0                                                          '

   DO WHILE i <= right_edge AND MID$(test_line, i, 1) <> " "      '
      i += 1                                                      '  skip over nonblanks
   LOOP                                                           '

   DO WHILE i <= right_edge                                       '
      span = 0                                                    '
      DO WHILE i <= right_edge AND MID$(test_line, i, 1) = " "    '
         i += 1                                                   '  skip over blanks
         span = 1                                                 '
      LOOP                                                        '

      DO WHILE i <= right_edge AND MID$(test_line, i, 1) <> " "   '
         i += 1                                                   '  skip over nonblanks
         span = 1                                                 '
      LOOP                                                        '

      IF data_pos > 0 THEN                                        '
         data_len = data_end - data_pos + 1                       '
      END IF                                                      '

      IF span = 1 THEN                                            '
         s += 1                                                   '
      END IF                                                      '
   LOOP                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- allocate the segment table. the +3 accounts for the "tail" segment, plus
   '- a couple extra, just in case (being paranoid) so we don't overrun the
   '- table with any bad math ... and yes, it's a fudge factor.
   '-----------------------------------------------------------------------------------------------+
   REDIM seg (0 TO s + 3) AS DataShift_Segment_t                  '

   '-----------------------------------------------------------------------------------------------+
   '-  determine label prefix. if found, store as segment 0 which cannot be moved                  |
   '-----------------------------------------------------------------------------------------------+
   seg(0).gap_len = 0                                             '  segment 0 will never have leading space
   seg(0).blank_len = 0                                           '
   seg(0).blank_pos = 0                                           '
   left_edge = left_bound                                         '

   '-----------------------------------------------------------------------------------------------+
   '- the label ends at the first blank                                                            |
   '- because of preprocessing done previously, only spans of blanks that are                      |
   '- big enough will have true blanks in the test_line.                                           |
   '-----------------------------------------------------------------------------------------------+
   DO WHILE left_edge <= right_edge AND MID$(test_line, left_edge, 1) <> " "  '
      left_edge += 1                                              '
   LOOP                                                           '

   IF left_edge >= right_edge THEN                                '  label fills up entire bounds area
      FUNCTION = 0                                                '  unable to perform data shift
      MExitFunc                                                   '

   ELSEIF left_edge > left_bound THEN                             '  a label found in bounds
      seg(0).data_pos = 1                                         '
      seg(0).data_len = left_edge - 1                             '

   ELSEIF left_bound > 1 THEN                                     '  unmovable segment precedes bounds
      seg(0).data_pos = 1                                         '
      seg(0).data_len = left_bound - 1                            '

   ELSE                                                           '  there is no unmovable prefix
      seg(0).data_pos = 0                                         '
      seg(0).data_len = 0                                         '

   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- parse the remaining line, breaking it up into spans of blanks followed by                    |
   '- non_blanks, where the non_blanks are counted first. the code above will                      |
   '- ensure that left_edge starts out pointing to a blank.                                        |
   '-----------------------------------------------------------------------------------------------+
   i = left_edge                                                  '
   seg_count = 0                                                  '

   DO WHILE i <= right_edge                                       '
      gap_len = 0                                                 '
      data_pos = 0                                                '
      data_len = 0                                                '
      blank_pos = 0                                               '

      DO WHILE i <= right_edge AND MID$(test_line, i, 1) = " "    '
         IF blank_pos = 0 THEN blank_pos = i                      '
         gap_len += 1                                             '
         i += 1                                                   '  skip over blanks
      LOOP                                                        '

      DO WHILE i <= right_edge AND MID$(test_line, i, 1) <> " "   '
         data_end = i                                             '
         IF data_pos = 0 THEN data_pos = i                        '
         i += 1                                                   '  skip over nonblanks
      LOOP                                                        '

      IF data_pos > 0 THEN                                        '
         data_len = data_end - data_pos + 1                       '
      END IF                                                      '

      IF gap_len > 0 OR data_len > 0 THEN                         '
         seg_count += 1                                           '

         seg(seg_count).gap_len  = gap_len                        '
         seg(seg_count).data_pos = data_pos                       '
         seg(seg_count).data_len = data_len                       '

         '-  we need original pos/len of blanks to propagate color info
         seg(seg_count).blank_len = gap_len                       '
         seg(seg_count).blank_pos = blank_pos                     '
      END IF                                                      '
   LOOP                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- if there was a non-default bounds and line extends to the right of it,                       |
   '- it defines a 'tail'- segment that is unmovable. if so, define it here,                       |
   '- otherwise create a null tail segment. we disregard any blanks in the                         |
   '- tail, and simply record the data area extent of the tail.                                    |
   '-----------------------------------------------------------------------------------------------+
   seg(seg_count+1).gap_len   = 0                                 '
   seg(seg_count+1).blank_len = 0                                 '
   seg(seg_count+1).blank_pos = 0                                 '

   IF n > right_edge THEN                                         '
      seg(seg_count+1).data_pos = right_edge + 1                  '
      seg(seg_count+1).data_len = n - right_edge                  '
   ELSE                                                           '
      seg(seg_count+1).data_pos = 0                               '
      seg(seg_count+1).data_len = 0                               '
   END IF                                                         '
   FUNCTION = seg_count                                           '  normal return
   MExit                                                          '
END FUNCTION                                                      ' DoLcmdShiftSetup

THREAD FUNCTION DoLoopDetect(BYVAL dummy AS LONG POINTER) AS LONG '
'---------- See if it looks like we're looping
   DO                                                             '
      SLEEP 1000                                                  ' Wait 1 second
      IF ISFALSE gLoopCheck THEN                                  ' LOOPCHECK OFF (Global NO)
         RESET gLoopCtr                                           ' Reset the counter
      ELSEIF ISFALSE gLoopFlag OR ISTRUE gfDoingMsg THEN          ' No transaction in progress or external Dialog?
         RESET gLoopCtr                                           ' Reset the counter
      ELSEIF gLoopCtr = -1 THEN                                   ' Suppressed?
         '- Do nothing                                            ' Do nothing
      ELSE                                                        '
         INCR gLoopCtr                                            ' Count another, transaction still running
         IF gLoopCtr > 10 + (TP.LastLine / 750000) THEN           ' Do we consider this a loop? (10 seconds + 1 per 750,000 lines)
            RaiseException 123456789, %Null, %Null, %Null         ' Trigger a unique error
         END IF                                                   '
      END IF                                                      '
   LOOP                                                           ' On and on
END FUNCTION                                                      '

FUNCTION DoLoopHandle(BYREF lpEP AS MY_EXCEPTION_POINTERS) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Handle Loop trap exception                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL ErrorRecord AS EXCEPTION_RECORD POINTER                     '
LOCAL ErrorCode AS LONG POINTER                                   '
LOCAL MSG, MSG1, MSG2, Trc, fn  AS STRING, i, FNm AS LONG              '

   ErrorRecord =  lpEP.ExceptionRecord                            ' Get address of Exception record
   ErrorCode = @ErrorRecord.ExceptionCode                         ' Get the exception code
   IF gTerminateInProgress THEN                                   ' Oops, been here already
      MyMsgBox "A second serious error has occured, no recovery is possible", _  '
               %MB_OK OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "SPFLite Crash Intercept"   '
      SETUNHANDLEDEXCEPTIONFILTER %Null                           ' Deactivate our handler

   ELSE                                                           ' Lets see if it's ours
      gLoopCtr = - 1                                              ' Suspend Loop testing
      FNm = FREEFILE                                              ' Get file number
      fn = gENV.HomeFolder + "SPFLiteCrash."                      ' Build a filename
      fn += RIGHT$(DATE$, 4) + "-" + LEFT$(DATE$, 2) + "-" + MID$(DATE$, 4, 2) + "@"   ' Add the date
      fn += LEFT$(TIME$, 2) + "-" + MID$(TIME$, 4, 2) + "-" + RIGHT$(TIME$, 2)   ' Add the time
      fn += ".txt"                                                ' For saving this message
      MSG = "SPFLite V(" + gENV.PgmVers + ") @ " + TimePretty(0) + $CRLF   ' Build output
      MSG += "SPFLite has " + IIF$(Errorcode = 123456789, "detected an |Kinternal loop|B ", "encountered an |Kexecution exception|B (|K" + HEX$(Errorcode, 8) + "|B) ") '
      MSG += $CRLF + $CRLF                                        '
      Trc = "|KLast Interactions were:|B" + $CRLF                 '
      TRY                                                         '
         FOR i = 20 TO 1 STEP -1                                  ' Dump Trace items
            IF LEN(gCrashTrace(i)) THEN Trc += "  " + gCrashTrace(i) + $CRLF  '
         NEXT i                                                   '
         Trc += "|KModule Back Trace:|B" + $CRLF                  '
         FOR i = gCrashCtr - 1 TO 0 STEP -1                       '
               Trc += " " + FORMAT$(i, "00") + " " + gCrashList(i) + $CRLF ' Add to message
         NEXT i                                                   '
      CATCH                                                       '
         '                                                        '
      END TRY                                                     '
      MSG1 = MSG + Trc                                            ' Save around prompts
      '--------------------------------------------------------------------------------------------+
      '- Now display it to the user                                                                |
      '--------------------------------------------------------------------------------------------+
      MSG = "SPFLite V(" + gENV.PgmVers + ") @ " + TimePretty(0) + $CRLF   ' Build output
      MSG += "SPFLite has " + IIF$(Errorcode = 123456789, "detected an |Kinternal loop|B ", "encountered an |Kexecution exception|B (|K" + HEX$(Errorcode, 8) + "|B) ") '
      MSG += $CRLF + $CRLF                                        '
      MSG += $CRLF + "|KNote: Full Trace saved  in: " + $CRLF + fn + "|B" + $CRLF   '
      IF Errorcode = 123456789 THEN                               ' The Loop prompt
         MSG += "Select |KIgnore & Continue|B, to ignore loop and continue execution,  or" + $CRLF + _   '
                "            |KSave & Terminate|B, to attempt to SAVE modified data and then terminate." + $CRLF + _ '
                "Ignore && Continue" + $CRLF + "Save && Terminate"   '
         i = MyMsgBox(MSG, %MB_Custom2 OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "SPFLite Crash Intercept")   '
         IF i = %IDCustom1 THEN                                   ' Continue?
            gLoopCtr = 0                                          ' Reset loop counter
            FUNCTION = %EXCEPTION_CONTINUE_EXECUTION              '
         ELSE                                                     '
            GOSUB WriteCrash                                      ' Write Crash data and exit
         END IF                                                   '
      ELSE                                                        '
         MSG += "Select |KSave & Terminate|B to attempt to SAVE modified data and then terminate" + $CRLF + _  '
                "Save && Terminate"                               '
            i = MyMsgBox(MSG, %MB_Custom1 OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "SPFLite Crash Intercept")   '
         GOSUB WriteCrash                                         ' Write Crash data and exit
      END IF                                                      '
   END IF                                                         '
   EXIT FUNCTION                                                  '

   WriteCrash:                                                    '
      '--------------------------------------------------------------------------------------------+
      '- Write the crash text file                                                                 |
      '--------------------------------------------------------------------------------------------+
      OPEN fn FOR OUTPUT AS #FNm                                  ' Open the output File
      IF INSTR(MSG1, "|") <> 0 THEN                               ' Formatting characters?
         FOR i = 1 TO LEN(MSG1)                                   ' Yes, strip them out
            IF MID$(MSG1, i, 1) = "|" THEN                        ' Escape char?
               i += 1                                             ' Yes, step over them
               ITERATE FOR                                        ' Continue
            ELSE                                                  ' Else
               MSG2 += MID$(MSG1, i, 1)                           ' Add to the clean string
            END IF                                                '
         NEXT i                                                   '
      ELSE                                                        ' No cleaning needed
         MSG2 = MSG1                                              '
      END IF                                                      '
      PRINT #FNm, MSG2                                            ' Write the msg
      PRINT #FNm, Trc                                             ' Write the trace
      SETEOF #FNm                                                 '
      CLOSE #FNm                                                  '
      gLoopCtr = -1                                               ' Stop loop checking
      gTerminateInProgress = %True                                ' Once only please
      CrashSave                                                   ' Try CrashSave
      FUNCTION = %EXCEPTION_EXECUTE_HANDLER                       ' Continue dying
      RETURN                                                      '
END FUNCTION                                                      '

FUNCTION      DoMessageBox(mTxt AS STRING, mFlags AS LONG, title AS STRING, OPT mPitch AS LONG) AS LONG  '
'--------------------------------------------------------------------------------------------------+
'- Issue a MSGBOX                                                                                  |
'--------------------------------------------------------------------------------------------------+
   IF gENV.InitDone THEN KbdPopSave                               ' Ready for pop-up
   IF ISMISSING(mPitch) THEN                                      ' Pitch provided?
      FUNCTION = MyMsgBox(mTxt, mFlags, title)                    ' Pass on without pitch
   ELSE                                                           '
      FUNCTION = MyMsgBox(mTxt, mFlags, title, mPitch)            ' Pass the pitch onward
   END IF                                                         '
   IF gENV.InitDone THEN KbdPopRestore                            ' Reset popup state
END FUNCTION                                                      '

SUB      DoMultiEdit(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Multi-Edit startup                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL fn, fn2, t, DmyIMacro, BaseFile, NormName AS STRING         '
LOCAL i, j, op, NewTab, fMIX, WatchOff, OpsCtr, fFNum AS LONG     '
LOCAL lclOps(), fFName AS STRING, RCA AS RCArea                   ' For local operands
   MEntry                                                         '
   NormName = TP.FCB_.FilePath                                    ' Save any current filename
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(TP.PTBL_.ParseCmd(pCmd, %PAll), _                        ' Try the Parse
         TP.pCmdHelp("H MEDIT"), _                                ' ? entered
         TP.ErrMsgAdd(%eFail, TP.PTBL_.ErrMsg): MExitSub, _       ' Error, Bail out
         Nul)                                                     ' Continue
   '-----------------------------------------------------------------------------------------------+
   '- Validate NEW                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   NewTab = TP.PTBL_.IsKwd("NEW")                                 ' Specific NEW?
   IF IsFMTab THEN NewTab = %True                                 ' Or FM tab

   '-----------------------------------------------------------------------------------------------+
   '- Normal MEDIT, process the operands                                                           |
   '-----------------------------------------------------------------------------------------------+
   OpsCtr = TP.PTBL_.GotLit                                       ' Save count of Lit operands
   IF OpsCtr THEN                                                 ' Got something
      DIM lclOps(1 TO OpsCtr + 1) AS STRING                       ' DIM our copy needed table
      FOR i = 1 TO OpsCtr                                         ' Copy the table
         lclOps(i) = MID$(TP.PTBL_.Pos("$", i), 2)                '
         IF INSTR(lclOps(i), "\") = 0 THEN _                      ' If we have something with no path
            lclOps(i) = GetDefaultFolder + lclOps(i)              ' Add a path if it doesn't have one
      NEXT i                                                      '
   ELSE                                                           '
      DIM lclOps(1 TO 1) AS STRING                                ' DIM a dummy table
      lclOps(1) = DoOpenFile("Select file for MEdit", "")         ' Go get a filename
      IF ISNULL(lclOps(1)) THEN TP.ErrMsgAdd(%eFail, "File selection cancelled"): MExitSub   ' Bail out
      StrUnQuote(lclOps(1))                                       ' Save it
      IF INSTR(lclOps(1), "\") = 0 THEN _                         ' If we have something with no path
         lclOps(1) = GetDefaultFolder + lclOps(1)                 ' Add a path if it doesn't have one
      OpsCtr = 1                                                  '
    END IF                                                        '

   BaseFile = lclOps(1)                                           ' Save 1st filename
   '-----------------------------------------------------------------------------------------------+
   '- See if all files Exist and not Open already                                                  |
   '-----------------------------------------------------------------------------------------------+
   FOR op = 1 TO OpsCtr                                           ' Loop through operands
      fn = lclOps(op)                                             ' Get the filename
      fn2 = PATHSCAN$(FULL, fn)                                   ' See if file exists and get full name
      IF ISNOTNULL(fn2) THEN                                      ' A real file, see if in use
         i = VAL(FileQueue("S", " ", fn2))                        ' Returns tab number if open, else zero
         IF i > 0 THEN                                            ' Tab number?
            TP = gTabs(i)                                         ' Switch to found tab
            GoToTab(i, "File already open in this tab", "")       ' Setup switch
            MExitSub                                              '
         END IF                                                   '
      ELSE                                                        '
         TP.ErrMsgAdd(nMac(%eFail), fn + " does not exist"): MExitSub   '
      END IF                                                      '
   NEXT op                                                        '

   '-----------------------------------------------------------------------------------------------+
   '- See if a huge # of files                                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF OpsCtr > 200 THEN                                           ' More than 200 files?
      j = DoMessageBox("You are loading more than 200 files. This may trigger crashes due to" + $CRLF + _   '
                       "exhausted Stack space. Turning off File-Watch will help prevent this crash." + $CRLF + _  '
                       "Click |KYES |Bto turn off File-Watch, or |KNO |Bto attempt to continue.", _   '
                       %MB_YESNO OR %MB_USERICON, "SPFLite File-Watch") '
      WatchOff = IIF(j = %IDYES, %True, %False)                   ' Set chosen Suppress File-Watch
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get a new tab if needed                                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(BaseFile) OR NewTab THEN                             ' Needed?
      TabAdd(%MEdit)                                              ' Add a MEDIT tab
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Now do the Opens                                                                             |
   '-----------------------------------------------------------------------------------------------+
   FOR op = 1 TO OpsCtr                                           ' Loop through operands
      IF TP.MEditCount = 0 AND TP.LastLine > 2 THEN               ' If not yet Medit mode
         FOR i = 2 TO TP.LastLine - 1                             ' Mark all existing lines as being file 1 lines
            TP.LMixSet(i, 1)                                      '
         NEXT i                                                   '
         TP.LInsertLines(1, 1, %File)                             ' Insert for the =FILE> line
         TP.LMixSet(2, 1)                                         ' Mark as File 1
         TP.LTxtSet(2, NormName)                                  ' Stuff existing filename in as the text
         TP.MeditTbl("A", TP.FCB_.FilePath)                       ' Add to Medit table
         TP.MEditFlagSet(1, IIF(IsTPModdFlag, %True, %False))     ' Copy modified status
         TP.UpdLControl(2)                                        ' Setup LLCtl
      END IF                                                      '
      fn = lclOps(op)                                             ' Get the filename
      fn2 = PATHSCAN$(FULL, fn)                                   ' See if file exists and get full name
      IF TP.MeditTbl("S", fn2) > 0 THEN _                         ' Already here in MEdit mode?
         TP.ErrMsgAdd(%eFail, "File already Open in this MEdit session"): MExitSub  '
      TP.FCB_.SetupFn(fn2, %ProfGetY, RCA)                        ' Setup the FCB
      IF RCA.RC = 8 THEN                                          ' Not OK?
         TP.ErrMsgAdd(%eFail, TRIM$(RCA.MSG)): MExitSub           ' Issue error and fail
      END IF                                                      '
      IF TP.FCB_.ROState THEN _                                   ' No RO files
         TP.ErrMsgAdd(%eFail, fn2 + " ignored - a Read-Only file"): MExitSub  ' Oops? Bail out
      TP.TabMode = %MEdit                                         ' Set just in case
      fMIX = TP.MEditTbl("A", fn2)                                ' Go get MIX value
      j = TP.LastLine - 1                                         ' Point at last data line
      TP.LInsertLines(j, 1, %File)                                ' Insert for the =FILE> line
      TP.LTxtSet(j + 1, fn2)                                      ' Stuff filename in as the text
      TP.LMIXSet(j + 1, fMIX)                                     ' Mark with MIX index
      TP.UpdLControl(j + 1)                                       ' Setup LLCtl
      TP.CopyAFile(j + 1, 0, 0, 0, %False, DmyIMacro)             ' Go load the data (afterline, DoMIO, DoPrf, PMFlag, fromline, toline, not quick)
      IF TP.ErrMsgHigh <> %eNone THEN MExitSub                    ' If errors, bail out
      FileQueue("A", " ", fn2)                                    ' Add to Open queue
      IF ISFALSE WatchOff THEN                                    ' Do FileWatch if not suppressed
         IF TP.FileWatch(fn2, %WatchStart) THEN                   ' Establish the watch
            TP.ErrMsgAdd(0, "File watch could not be established")   '
         END IF                                                   '
      END IF                                                      '
   NEXT op                                                        '
   TP.FCB_.FilePath = BaseFile                                    ' Set FilePath to 1st filename
   TP.WindowTitle                                                 ' Alter window/Tab titles
   TP.ErrMsgHigh = %eNone                                         ' Say we're OK
   TP.UndoInit()                                                  ' Alloc files
   TP.UndoSave()                                                  ' Take an initial one
   GoToTab(TP.PgNumber, "", "")                                   ' Set to 'switch' here
   MExitSub                                                       '
END SUB                                                           '

FUNCTION DoMultiScan(FileName AS STRING, FArray() AS STRING, FCount AS LONG, ip AS InclParms) AS LONG '
LOCAL lFileNum, lFile, i, lnum, DEOF, InMem AS LONG, t, t2, SourceLine, INCFileName, TrimSource, lFileName AS STRING '
   '-----------------------------------------------------------------------------------------------+
   '- Scan for various types of INCLUDE                                                            |
   '-----------------------------------------------------------------------------------------------+
   IF FileName <> "*" THEN                                        ' If not the in-memory data
      lFileNum = FREEFILE                                         ' Get a file number
      lFileName = FileName: StrUnquote(lFileName)                 ' Get name and remove any passed quotes
      OPEN lFileName FOR INPUT AS lFileNum                        ' Open it
   ELSE                                                           ' Else setup for memory versio9n
      InMem = %True                                               ' Flag as InMem
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Spin through the data                                                                        |
   '-----------------------------------------------------------------------------------------------+
   DO WHILE ISFALSE DEOF                                          ' In not the end of data
      IF InMem THEN                                               ' If InMem
         GOSUB GetMemLine                                         ' Get one
         IF DEOF THEN ITERATE DO                                  ' EOF, we're done
      ELSE                                                        ' File version
         GOSUB GetFilLine                                         ' Go get one
         IF DEOF THEN ITERATE DO                                  ' EOF, we're done
      END IF                                                      '
      TrimSource = UCASE$(LTRIM$(SourceLine))                     ' Trimmed, UC version

      '--------------------------------------------------------------------------------------------+
      '- First see if the trigger string is present                                                |
      '--------------------------------------------------------------------------------------------+
      i = INSTR(TrimSource, ip.Trig)                              ' See if include trigger present
      IF i = 0 THEN ITERATE DO                                    ' No trigger, ignore line
      '--------------------------------------------------------------------------------------------+
      '- Trigger present, remove any numeric line #                                                |
      '--------------------------------------------------------------------------------------------+
      t2 = GetNextWord(TrimSource, %NoStrip)                      ' Get 1st 'word'
      IF VERIFY(t2, $Numeric) = 0 THEN                            ' If all Numeric (i.e. a line no.)
         t2 = GetNextWord(TrimSource, %Strip)                     ' Remove the Line #
         i = INSTR(TrimSource, ip.Trig)                           ' Find the Trig string again
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Make sure the trigger is at the beginning of the line                                     |
      '--------------------------------------------------------------------------------------------+
      IF i <> 1 AND SPACE$(i - 1) <> LEFT$(TrimSource, i - 1) THEN ITERATE DO ' Not the LH of the line
      '--------------------------------------------------------------------------------------------+
      '- Remove any inline comments                                                                |
      '--------------------------------------------------------------------------------------------+
      IF ip.Cmnt <> "" THEN                                       ' Possible comments?
         i = INSTR(TrimSource, ip.Cmnt)                           ' Any here?
         IF i THEN TrimSource = LEFT$(TrimSource, i - 1)          ' Remove comments
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- See if the line has a negate indicator                                                    |
      '--------------------------------------------------------------------------------------------+
      IF ip.Supp <> "" THEN                                       ' Any suppression?
         IF INSTR(TrimSource, ip.Supp) <> 0 THEN ITERATE DO       ' A Suppress trigger, ignore line
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Blank any useless delimiters                                                              |
      '--------------------------------------------------------------------------------------------+
      IF ip.DLMS <> "" THEN                                       ' Possible useless DLMs?
         REPLACE ANY ip.DLMS WITH SPACE$(LEN(ip.DLMS)) IN TrimSource ' Replace any with spaces
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Scan the 'words' to find the requested one                                                |
      '--------------------------------------------------------------------------------------------+
      t = TrimSource: i = 0                                       ' Get a copy
      DO WHILE ISNOTNULL(t)                                       ' Get words
         t2 = GetNextWord(t, %Strip): INCR i                      ' and Incr word count
         IF i = ip.Word THEN EXIT DO                              ' We have our word?
      LOOP                                                        '
      '--------------------------------------------------------------------------------------------+
      '- If we found a valid filename, get it processed by iterating ourselves                     |
      '--------------------------------------------------------------------------------------------+
      t2 += " "                                                   ' Ensure trailing space
      IF i <> ip.Word AND ip.Word <> 99 THEN ITERATE DO           ' If not correct Word or Last-word - skip
      '--------------------------------------------------------------------------------------------+
      '- Extract the filename, add path if needed, save in FArray, then recursive process it       |
      '--------------------------------------------------------------------------------------------+
      IncFilename = IIF$(INSTR($Quotes, LEFT$(t2, 1)) <> 0, _     ' If starts with quotes
                         MID$(t2, 2 TO INSTR(2, t2, ANY $Quotes) - 1), _   ' Grab quoted string
                          LEFT$(t2, INSTR(2, t2, " ") - 1))       ' Else, Grab until next space
      IF INSTR(IncFileName, "\") = 0 THEN                         ' If we have something with no path
         IncFileName = PATHSCAN$(FULL, IncFileName, ip.Path)      '
      END IF                                                      '
      IF ISNOTNULL(IncFileName) THEN                              ' End up with something?
         FOR i = 1 TO FCount                                      ' Don't add it twice
            IF UCASE$(IncFileName) = UCASE$(FArray(i)) THEN       ' Hmm, already here
               GOTO SKipAdd                                       ' Skip over doing it again
            END IF                                                '
         NEXT i                                                   '
         IF TP.TabMode <> %MEdit THEN GOTO DoAdd                  ' Not currently MEDIT, add it

         FOR i = 1 TO TP.MeditCount                               ' Scan existing MeditList
            IF UCASE$(IncFileName) = UCASE$(TP.GetMedList(i)) THEN   ' Already here
               GOTO SKipAdd                                       ' Skip over doing it again
            END IF                                                '
         NEXT i                                                   '

         DoAdd:                                                   '
         INCR FCount                                              ' Bump count
         FArray(FCount) = InCFilename                             ' Save the Include file
         DoMultiScan(INCFileName, FArray(), FCount, ip)           ' Scan the insert filename

         SkipAdd:                                                 '
      ELSE                                                        ' Can't find the file
                                                                  '         DoMessageBox(mTxt AS STRING, mFlags AS LONG, title AS STRING, OPT mPitch AS LONG) AS LONG
         DoMessageBox("Cannot find: |K" + t2 + "|B in" + $CRLF + _   '
                      "Path: |K" +ip.Path + "|B," + $CRLF + _     '
                      "Check (or Create) a SET INCLPATHS entry.", %MB_OK OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "IEDIT Missing File") '
      END IF                                                      '
   LOOP                                                           '
   EXIT FUNCTION                                                  '

   GetMemLine:                                                    '
      DO                                                          '
         INCR lnum                                                ' Bump line number
      LOOP UNTIL lnum = TP.LastLine OR ISTRUE (TP.GetLFlag(lnum) AND %Data)   '
      IF lnum = TP.LastLine THEN DEOF = %True: RETURN             ' Last? Return EOF
      SourceLine = TP.GetLTxt(lnum)                               ' Data Line, grab it
   RETURN                                                         '

   GetFilLine:                                                    '
      IF EOF(lFileNum) THEN                                       ' EOF
         DEOF = %True                                             ' Return it
         CLOSE # lFileNum                                         ' Close the file
         RETURN                                                   ' We're done
      END IF                                                      '
      LINE INPUT# lFileNum, SourceLine                            ' Get a line
   RETURN                                                         '
END FUNCTION                                                      '

FUNCTION DoOpenFile(iPrompt AS STRING, DefFn AS STRING) AS STRING '
'--------------------------------------------------------------------------------------------------+
'- Prompt for a filename                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL fn, fldr AS STRING                                          '
   KbdPopSave                                                     '
   fldr = GetDefaultFolder: fn = DefFn                            '
   IF RIGHT$(Fn, 1) = "\" THEN Fn += "*.*"                        ' Ready for pop-up
   DISPLAY OPENFILE ghWnd, , , iPrompt, fldr, CHR$("All Files", 0, "*.*", 0), Fn, "", _   '
                    %OFN_ENABLESIZING TO fn                       '
   KbdPopRestore                                                  ' Reset popup state
   FUNCTION = TRIM$(fn)                                           ' Return answer
END FUNCTION                                                      '

FUNCTION DoOpenFileDialog(BYVAL hFop AS LONG) AS STRING           '
'--------------------------------------------------------------------------------------------------+
'- Call up File Open dialog and get resulting file name, if any                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL fName   AS STRING                                           'for returned file name
                                                                  'don't want resizable dialog
  IF ISFALSE(OpenFileDialog(hFop, "DIFF File Select", fName, gENV.WorkingDir, _  '
                                  "All Files (*.*)|*.*", "TXT", %OFN_EXPLORER OR %OFN_FILEMUSTEXIST)) THEN EXIT FUNCTION   '
  FUNCTION = fName                                                ' Return what we got
END FUNCTION                                                      '

SUB      DoPendingTabDeletes                                      '
'--------------------------------------------------------------------------------------------------+
'- Do any pending Tab Deletes                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG                                             '
LOCAL lclTP AS iObjTabData                                        '
   MEntry                                                         '
   IF gTabDelCtr = 0 THEN MExitSub                                ' Nothing, exit quickly
   ARRAY SORT gTabDelList() FOR gTabDelCtr, TAGARRAY gTabDelNext(), DESCEND   '
   FOR i = 1 TO gTabDelCtr                                        ' Do the tab deletes
      lclTP = gTabs(gTabDelList(i))                               ' See if it's valid
      IF ISNOTHING(lclTP) THEN ITERATE FOR                        ' Skip it
      TP = gTabs(gTabDelList(i))                                  ' Switch to the tab to be deleted
      IF gTabDelList(i) = gTabGoTo.Number THEN GoToTab(0, "", "") ' If we were going to it, kill that switch
      TabStackDel(TP.PgNumber)                                    ' Remove from Tab Stack
      j = GTabStack(1)                                            ' Get tab to switch to
      TabDel                                                      ' Go delete it
   NEXT                                                           '
   RESET gTabDelCtr, gTabDelList(), gTabDelNext()                 ' Clear out the table

   '-----------------------------------------------------------------------------------------------+
   '- Figure out what other tab to switch to (or shut down)                                        |
   '-----------------------------------------------------------------------------------------------+

   IF gTabsNum = 1 AND gENV.FMCloseFlag THEN                      ' All that's left is FM and we should close it
      gTabsNum = 0                                                ' Say no more active tabs
      gfTermFlag = %True                                          ' So we don't loop
      GOSUB SaveFMStuff                                           ' Go save the FM status
      DIALOG END ghWnd                                            ' Kill our dialog
   END IF                                                         '

   IF j <> 0 THEN                                                 ' End up with a tab number
      TP = gTabs(j)                                               ' Switch to it
      IF ISNOTHING(TP) THEN                                       ' ?
         TP = gTabs(1)                                            '
      END IF                                                      '
      TP.ErrMsgAdd(0, gTabDelMsg)                                 ' Issue any message
      TAB SELECT ghWnd, %IDC_SPFLiteTAB, j                        '
   ELSE                                                           '
      IF gTabsNum > 1 THEN                                        ' Switch to another tab
         IF k > 1 THEN                                            '
            TP = gTabs(k - 1)                                     ' Switch TP right away
            IF ISNOTHING(TP) THEN                                 ' ?
               TP = gTabs(1)                                      '
            END IF                                                '
            TP.ErrMsgAdd(0, gTabDelMsg)                           ' Issue any message
            TAB SELECT ghWnd, %IDC_SPFLiteTAB, k - 1              ' Go Left
         ELSE                                                     '
            TP = gTabs(1)                                         ' Switch TP to FM
            TP.ErrMsgAdd(0, gTabDelMsg)                           ' Issue any message
            TAB SELECT ghWnd, %IDC_SPFLiteTAB, 1                  ' Go to 1st tab
         END IF                                                   '
      ELSEIF gTabsNum = 1 AND ISFALSE gENV.FMCloseFlag THEN       ' If just 1 and File Manager and we're not to autoclose it
         TP = gTabs(1)                                            ' Switch TP right away
         TP.ErrMsgAdd(0, gTabDelMsg)                              ' Issue any message
         TAB SELECT ghWnd, %IDC_SPFLiteTAB, 1                     ' Go to 1st tab
      ELSEIF gfEndAll THEN                                        '
         gfTermFlag = %True                                       ' So we don't loop
         GOSUB SaveFMStuff                                        ' Go save the FM status
         DIALOG END ghWnd                                         ' Kill our dialog
      ELSE                                                        ' ELSE (we're all done)
         gfTermFlag = %True                                       ' So we don't loop
         GOSUB SaveFMStuff                                        ' Go save the FM status
         DIALOG END ghWnd                                         ' Kill our dialog
      END IF                                                      '
   END IF                                                         '
   RESET gTabDelCtr, gTabDelMsg, gTabDelList(), gTabDelNext()     ' Clear out the table
   MExitSub                                                       '

SaveFMStuff:                                                      '
   gRtr.Save                                                      ' Save Retrieve stack
   TP = gTabs(1)                                                  ' Point at the FM tab
   gSQL.UpdateString("O", "FileListNM", TP.FileListNm)            '
   gSQL.UpdateString("O", "DefDir1", TP.FPath)                    '
   gSQL.UpdateString("O", "DefMask", TP.FMask)                    '
   gENV.SetFMCrit(TP.DirSort, TP.DefSort, TP.FMask, gFMLayoutID)  ' Save the new values in FMDefCrit as well
   RETURN                                                         '
END SUB                                                           '

SUB      DoPendingTabSwitch                                       '
'--------------------------------------------------------------------------------------------------+
'- Do a pending Tab Switch                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL k AS LONG                                                   '
   MEntry                                                         '
   IF gTabGoTo.Number = 0 OR gTabGoTo.Number > gTabsNum THEN MExitSub   ' If no switch, just exit
   TP = gTabs(gTabGoTo.Number): k = %True                         ' Switch to the tab to be switched to
   IF gTabGoTo.Message <> "" THEN                                 ' An associated message?
      TP.ErrMsgAdd(0, TRIM$(gTabGoTo.Message))                    ' Set it
      TP.AttnDo = (TP.AttnDo OR %Refresh)                         ' Have it looked at
   END IF                                                         '
   IF gTabGoTo.Command <> "" THEN                                 ' An associated command?
      TP.pCommand = gTabGoTo.Command                              ' Set it
      TP.AttnDo = (TP.AttnDo OR %Attention)                       ' Have it looked at
      TP.PostKeyBoard                                             '
   END IF                                                         '
   RESET gTabGoTo.Number, gTabGoTo.Message, gTabGoTo.Command      ' Clear things
   IF k THEN                                                      ' If we switched
      TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber              ' Select the new tab
      GRAPHIC ATTACH TP.PgHandle, TP.WindowID                     ' Swap the default graphic area
      CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB                    ' Set focus
      CaretDestroy                                                '
      CaretCreate                                                 '
      DoCursor                                                    '
      CaretShow                                                   '
   END IF                                                         '
   MExit                                                          '
END SUB                                                           '

FUNCTION DoPopup(MenuLines() AS STRING, xpos AS LONG, ypos AS LONG) AS LONG   '
'------------------------------------------------------------------------------------------+
                                                                  ' Display a popup menu and get user's choice                                               |
'------------------------------------------------------------------------------------------+
LOCAL hPopUp, hDC, hList, LPIy AS DWORD                           '
LOCAL i, j, ix, w, h, MaxLen, Height, lins, mrg, cpos, RC AS LONG '
LOCAL t AS STRING, tm AS SIZE                                     '
LOCAL factor, SBFac, SBFont, fontscale AS SINGLE                  '
   hDC = GetDC(%HWND_DESKTOP)                                     ' Get Desktop handle
   LPIy = GetDeviceCaps(hDC, %LOGPIXELSY)                         ' Get pixels / inch vertically
   ReleaseDC %HWND_DESKTOP, hDC                                   ' Free hDC
   factor = (LPiY/96) * 100                                       ' Calc % font size
   FontScale = factor / 100                                       ' Create a factor out of it

   lins = UBOUND(MenuLines()): mrg = 3                            ' Get # lines, set margin
   DIM LCmd(1 TO lins) AS LONG                                    ' Dim matching Cmd return value
   DIM LTxt(1 TO lins) AS STRING                                  ' Dim text
   '---------------------------------------------------------------------------------------+
                                                                  ' Build a popup dialog                                                                  |
   '---------------------------------------------------------------------------------------+
   DIALOG DEFAULT FONT "Segoe UI", 12 / fontscale, 0              '
   DIALOG NEW PIXELS, ghWnd, "", xpos, ypos, 50, 275, _           ' Create our window
                     %WS_POPUP, %WS_EX_TOOLWINDOW TO hPopup       '
   CONTROL ADD LISTBOX, hPopUp, 101, , 0, 0, 200, 275, %LBS_NOTIFY OR %WS_VSCROLL OR %WS_HSCROLL   '
   CONTROL HANDLE hPopup, 101 TO hList                            ' Get control
   hDC = GetDC(hList)                                             ' Get hDC

   '---------------------------------------------------------------------------------------+
                                                                  ' Parse the Array                                                                       |
   '---------------------------------------------------------------------------------------+
   FOR i = 1 TO lins                                              ' Calc longest line
      j = INSTR(MenuLines(i), ".")                                ' Extract & save the command code
      LCmd(i) = VAL(LEFT$(MenuLines(i), j - 1))                   '
      LTxt(i) = MID$(MenuLines(i), j + 1)                         ' And the text
      IF LCmd(i) = 0 THEN LTxt(i) = REPEAT$(100, "_")             '
      LISTBOX ADD hPopUp, 101, LTxt(i) TO j                       ' Add to the Listbox, get index
      LISTBOX SET USER hPopUp, 101, j, VARPTR(RC)                 ' Set pointer to RC
      GetTextExtentPoint32 hDC, BYVAL STRPTR(LTxt(i)), LEN(LTxt(i)), tm '
      IF LCmd(i) <> 0 THEN Maxlen = MAX(Maxlen, tm.cx)            ' Track maximum length of text lines
   NEXT i                                                         '
   DIALOG SET SIZE hPopup, (Maxlen * fontscale) + 15, 275         ' Resize
   CONTROL SET SIZE hPopUp, 101, (Maxlen * fontscale) + 15, 275   '
   '---------------------------------------------------------------------------------------+
                                                                  ' Finally show it                                                                       |
   '---------------------------------------------------------------------------------------+
   KbdPopSave                                                     ' Ready for pop-up
   DIALOG SHOW MODAL hPopUp, CALL DoPopUpCallBack                 ' Open it up
   FUNCTION = LCmd(RC)                                            ' Return the answer
   KbdPopRestore                                                  ' Reset popup state
END FUNCTION                                                      '

CALLBACK FUNCTION DoPopUpCallBack                                 '
LOCAL i, j AS LONG, pRC AS LONG PTR                               '
   SELECT CASE AS LONG CB.MSG                                     '

      CASE %WM_COMMAND                                            ' See what we have
         SELECT CASE LOWRD(CB.WPARAM)                             '
            CASE 101                                              ' For our LISTBOX?
               SELECT CASE HIWRD(CB.WPARAM)                       ' A Change?
                  CASE %LBN_SELCHANGE                             '
                     LISTBOX GET SELECT CB.HNDL, 101 TO i         ' Get the line #
                     LISTBOX GET COUNT CB.HNDL, 101 TO j          ' Get total lines
                     LISTBOX GET USER CB.HNDL, 101, i TO pRC      ' Get pointer to RC
                     IF i > j THEN i = 1                          ' If >, default to 1
                     @pRC = i                                     ' Pass it back
                     DIALOG END CB.HNDL                           ' We're done
               END SELECT                                         '
         END SELECT                                               '

      CASE %WM_NCACTIVATE                                         ' Outside our box?
         DIALOG POST CB.HNDL, %WM_USER, 0, 0                      ' Send myself a QUIT

      CASE %WM_USER                                               ' My USER msg?
         LISTBOX GET USER CB.HNDL, 101, 1 TO pRC                  ' Get pointer to RC
         @pRC = 1                                                 ' Pass back default
         DIALOG END CB.HNDL                                       ' Return
   END SELECT                                                     '
END FUNCTION                                                      '

SUB      DoPrint(BYVAL sTxt AS STRING, BYVAL sAttr AS WSTRING, BYVAL sRow AS LONG, BYVAL sCol AS LONG, _ '
                 OPT sOffset AS LONG, OPT BYREF sPad AS LONG)     '
'--------------------------------------------------------------------------------------------------+
'- Print a string at a specific row/col using the Attr definition                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER cPtr AS LONG                                             '
REGISTER oPtr AS LONG                                             '
LOCAL lclScheme, lclUC, lclLC, lclUL, lclBG, ncPtr, cLen, tLen, i AS LONG  '
LOCAL AttrAsc, AttrHiLite AS WORD                                 '
LOCAL lTxt, t AS STRING, pTxt AS STRING POINTER                   '
DP1:

   TP.ScreenRep(sRow, sCol, sTxt)                                 ' Update Text Image copy
   IF gMacroMode THEN EXIT SUB                                    ' If macro mode, exit
   '-----------------------------------------------------------------------------------------------+
   '- Setup possible translated string if a data text string                                       |
   '-----------------------------------------------------------------------------------------------+
   DP2:
   pTxt = VARPTR(sTxt)                                            ' Point at passed string to start
   IF ISFALSE ISMISSING(sOffset) THEN                             ' Only do this for text data lines
      IF UCASE$(gENV.InvChar) <> "N" THEN                         ' If user says no translate, skip this
         i = VERIFY(sTxt, gValidChars)                            ' Get location of any unprintable chars
         IF i THEN                                                ' Got some
            lTxt = sTxt: pTxt = VARPTR(lTxt)                      ' Copy and force use of the copied version
            DO WHILE i                                            ' Make them all the chosen
               MID$(lTxt, i, 1) = gENV.InvChar                    ' Invalid character substitute
               i = VERIFY(i + 1, lTxt, gValidChars)               ' Get location of any further unprintable chars
            LOOP                                                  '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
         DP3:
   '-----------------------------------------------------------------------------------------------+
   '- Setup for line scans                                                                         |
   '-----------------------------------------------------------------------------------------------+
   oPtr = 1                                                       '
   IF ISMISSING(sOffset) THEN                                     ' If no Offset or Pad
      cPtr = 1                                                    ' Start at left end of sTxt
      tLen = LEN(@pTxt)                                           ' Do length of Txt
   ELSE                                                           '
      cPtr = sOffset + 1                                          ' Start at Offset location
      tLen = sPad                                                 ' and do sPad # characters
   END IF                                                         '
         DP4:

   GRAPHIC SET POS ((sCol - 1) * gFontWidth + %GLM, (sRow - 1) * gFontHeight + 0)   ' Set position for Print
   DO WHILE cPtr <= LEN(@pTxt)                                    ' While still stuff in @pTxt
      GOSUB SetlclScheme                                          ' Setup lclScheme then
      SetDim(gENV.GetClr(lclScheme, %SCFG), lclBG)                ' Set the FG/BG colors
      IF lclUL THEN GRAPHIC SET FONT gScrFontUnd                  ' Switch font if underlined

      ncPtr = VERIFY(cPtr + 1, sAttr, CHR$$(AttrAsc))             ' Find next different Attr character
      IF ncPtr THEN                                               ' If another Attr upcoming,
         cLen = MIN(ncPtr - cPtr, tLen - oPtr + 1)                ' Length of current string
      ELSE                                                        ' If no upcoming Attr change
         ncPtr = LEN(@pTxt) + 1                                   ' Set 'next' continue pointer
         cLen = MIN(LEN(@pTxt) - cPtr + 1, tLen - oPtr + 1)       ' Length of string
      END IF                                                      '
      t = MID$(@pTxt, cPtr, cLen)                                 ' Get the chunk of text
      IF lclUC THEN t = UUCase$(t)                                ' UC if needed
      IF lclLC THEN t = LLCase$(t)                                ' LC if needed
      GRAPHIC PRINT t;                                            ' Print it now
      oPtr += cLen                                                ' Adjust pointers
      cPtr = ncPtr                                                '
      IF lclUL THEN GRAPHIC SET FONT gScrFont                     ' Put font back to normal if needed
   LOOP                                                           '
   DP5:
   IF oPtr <= tLen THEN                                           ' Pad needed?
      AttrAsc = %SCTxtLo                                          ' Get colors back to normal text
      GOSUB SetlclScheme2                                         '
      SetDim(gENV.GetClr(lclScheme, %SCFG), lclBG)                ' Set the FG/BG colors
      GRAPHIC PRINT SPACE$(tLen - (oPtr - sCol) + 1);             '
   END IF                                                         '
   DP6:
   EXIT SUB                                                       '

   SetlclScheme:                                                  '
      Attrasc = ASC(sAttr, cPtr)                                  ' Get Attribute byte
   SetlclScheme2:                                                 ' Alternate entry point
      AttrHiLite = (AttrAsc AND %AttrHiLite)                      ' Isolate the hi-lite color
      SHIFT RIGHT AttrHiLite, 12                                  '
      lclUC = IIF((Attrasc AND %AttrUC) <> 0, %True, %False)      ' Setup the UC flag
      lclLC = IIF((Attrasc AND %AttrLC) <> 0, %True, %False)      ' Setup the LC flag
      lclUL = IIF((Attrasc AND %AttrUL) <> 0, %True, %False)      ' Setup the UL flag
      lclScheme = AttrAsc AND %AttrSchNum                         ' Get scheme number
      IF AttrHiLite THEN lclScheme = AttrHiLite + 31              ' A color hilight? Adjust to a scheme number
      IF (AttrAsc AND %AttrInv) <> 0 THEN                         ' Invert request?
         gCustFG  = gENV.GetClr(lclScheme, %SCBG1)                ' Setup custom request
         gCustBG1 = gENV.GetClr(lclScheme, %SCFG)                 '
         gCustBG2 = gENV.GetClr(lclScheme, %SCFG)                 '
         lclScheme = %SCCust                                      '
      END IF                                                      '
      lclBG = IIF(gBandBG, gENV.GetClr(lclScheme, %SCBG2), gENV.GetClr(lclScheme, %SCBG1))   ' Chose Scheme's BG color
      RETURN                                                      '

END SUB                                                           '

SUB      DoPrintPFKHelp(iTxt AS STRING, iRow AS LONG)             '
'--------------------------------------------------------------------------------------------------+
'- Print a Help string with selective underlining                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL k AS LONG                                                   '
   IF gMacroMode THEN EXIT SUB                                    ' If macro mode, exit
   i = 1: j = 1                                                   ' Init for loop
   DO WHILE i <= LEN(iTxt)                                        '
      k = INSTR(i, iTxt, ANY $UpperSpec)                          ' Look for any > 128 chars
      IF k = 0 THEN DoPrint (MID$(iTxt, i), $$PFK, iRow, j): EXIT SUB   ' No more, remainder is normal
      IF k = i THEN                                               ' Found at start column?
         DoPrint (CHR$(ASC(iTxt, i) - 128), $$PFKUL, iRow, j)     '
         INCR i: INCR j                                           ' Step over
      ELSE                                                        '
         DoPrint (MID$(iTxt, i, k - i), $$PFK, iRow, j)           '
         j += (k - i): i = k                                      ' Adjust continue values
      END IF                                                      '
   LOOP                                                           '
END SUB                                                           '

SUB      DoProfMsg(tMSG AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Display a PROF setting message based on MacroMode                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   t = tMSG: IF LEFT$(t, 1) = "?" THEN t = CLIP$(LEFT, t, 1)      ' Remove ? if present
   IF gMacroMode THEN                                             ' If macro mode
      TP.ErrMsgAdd(0, t)                                          ' Do nothing but copy msg
   ELSEIF TP.ErrMsgHigh > 0 THEN                                  ' If Error
      TP.ErrMsgAdd(TP.ErrMsgHigh, t)                              ' Issue Short status message
   ELSE                                                           '
      TP.AddLockPrefix(tMSG)                                      ' Issue Long message
   END IF                                                         '
END SUB                                                           '

SUB DoRestore(FileName AS STRING, RCA AS RCArea)                  '
'--------------------------------------------------------------------------------------------------+
'- Restore a Filename                                                                              |
'--------------------------------------------------------------------------------------------------+
REGISTER j AS LONG                                                '
LOCAL BKPFileName, BKPPath, StateFileName, oFileName, oStateName, t, lclMode AS STRING '
LOCAL k, hFile, hFile2 AS LONG                                    '
LOCAL tFileSize AS DWORD                                          ' Size of File
LOCAL LTime AS IPOWERTIME                                         ' Create a PowerTime object
LOCAL CreationTime, LastAccessTime, LastWriteTime AS MyFStamp     ' BKP time stamps
LOCAL BKPFD AS DIRDATA                                            ' For directory data of the files
LOCAL iPath, iFile, iExt AS STRING                                '
   LET LTime = CLASS "PowerTime"                                  '
   lclMode = LEFT$(FileName, 1)                                   ' Copy Mode from parameter

   BkpFileName = TRIM$(MID$(FileName, 2))                         ' Get the selected Backup Filename
   t = DIR$(BKPFileName TO BKPFD)                                 ' Get the full FD set of data
   IF t = "" THEN                                                 ' Not found?
      AnswerSub(8, "File could not be found??")                   ' Shouldn't happen, but ...
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Does Filename have a timestamp level within it                                               |
   '-----------------------------------------------------------------------------------------------+
   t = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")         ' Check for 999999-999999.999999 timestamp
   PCRERegexTest(BKPFileName, 1, j, k)                            ' See if we can find it
   IF j = 0 OR k <> 21 OR INSTR(BKPFileName, ".STATE") THEN       ' Look reasonable?
      AnswerSub(8, "File does not appear to be a Backup file")    ' No, not one of ours
   END IF                                                         '

   BKPPath = PATHSCAN$(PATH, BKPFileName)                         ' Get the file's path

   '-----------------------------------------------------------------------------------------------+
   '- Extract file sizes and hash                                                                  |
   '-----------------------------------------------------------------------------------------------+
   tFileSize = MAK(QUAD, BKPFD.FileSizeLow, BKPFD.FileSizeHigh)   ' Get size from the directory

   '-----------------------------------------------------------------------------------------------+
   '- Get Dates from the Backup file                                                               |
   '-----------------------------------------------------------------------------------------------+

   CreationTime.MyQuad   = BKPFD.CreationTime                     ' Get original file Date Time Stamps
   LastAccessTime.MyQuad = BKPFD.LastAccessTime                   '
   LastWriteTime.MyQuad  = BKPFD.LastWriteTime                    '

   '-----------------------------------------------------------------------------------------------+
   '- Does Filename exist in a \BACKUP\ folder?                                                    |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE INSTR(uucase(BKPFileName), "\$BACKUP\") THEN        ' No \$BACKUP\ level in the name?
      AnswerSub(8, "Selected file is not located in a \$BACKUP\ folder")   ' It must reside in a \$BACKUP\ folder
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Is \BACKUP\ the last level?                                                                  |
   '-----------------------------------------------------------------------------------------------+

   iPath = PATHNAME$(PATH, BKPFileName)                           ' Get its path
   IF RIGHT$(uucase(iPath), 9) <> "\$BACKUP\" THEN                '
      AnswerSub(8, "The \$BACKUP\ folder is not the last level in the Filename") ' \$BACKUP\ must be the last level
   END IF                                                         '

   iPath = CLIP$(RIGHT, iPath, 8)                                 ' Strip off the \$BACKUP\ to get Restore path
   iFile = PATHNAME$(NAME, BKPFileName)                           ' Get just the file
   PCRERegexTest(iFile, 1, j, k)                                  ' Find timestamp
   iFile = LEFT$(iFile, j - 1)                                    ' Remove it
   iExt  = PATHNAME$(EXTN, iFile)                                 ' Get just the extension

   '-----------------------------------------------------------------------------------------------+
   '- Build restore names                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF lclmode = "E" THEN                                          ' If restore existing
      OFileName  = iPath + iFile                                  ' Format Original name
   ELSE                                                           ' Restore with Timestamp, build different names
      oFileName = iPath + PATHNAME$(NAMEX, BKPFileName)           ' Restore path + full backup filename
   END IF                                                         '
   oStateName = OFileName + ".STATE"                              ' Format a working STATE name
   REPLACE ANY ":\/" WITH "```" IN oStateName                     ' Make : / and \ into `
   oStateName = gENV.HomeData + "STATE\" + oStateName             ' Add STATE path

   '-----------------------------------------------------------------------------------------------+
   '- Now see if the file still exists                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF ISFILE(OFileName) THEN                                      ' If Original file still exists, ask
      j = DoMessageBox("File |K" + OFileName + "|B still exists, Replace it?", %MB_YESNO + %MB_USERICON, "SPFLite")  '
      IF j = %IDNO THEN                                           ' No?
         AnswerSub(8, "Restore cancelled")                        ' Bail out
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Finally, copy the file back to its home                                                      |
   '-----------------------------------------------------------------------------------------------+
   FILECOPY BKPFileName, oFileName                                ' Copy it back
   StateFileName = BKPFileName + ".STATE"                         ' Build STATE backup name
   IF ISFILE(StateFileName) THEN                                  ' If STATE backup exists
      FILECOPY StateFileName, oStateName                          ' Restore it as well
   ELSE                                                           '
      oStateName = ""                                             ' Null name to say it's not here
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now set all file dates back to the original                                                  |
   '-----------------------------------------------------------------------------------------------+
   TRY                                                            '
      hFile = FREEFILE                                            ' Touch the file now
      OPEN OFileName FOR APPEND ACCESS READ WRITE LOCK SHARED AS # hFile   '
      hFile2 = FILEATTR(hFile, 2)                                 ' Get Windows handle for the file
      SetFileTime hFile2, CreationTime.MyTime, LastAccessTime.MyTime, LastWriteTime.MyTime   '
      CLOSE #hFile                                                ' Close it

   CATCH                                                          '
      AnswerSub(8, "Restore successful, couldn't re-establish File Dates") ' Say DATE attempt failed
   END TRY                                                        '
   IF oStateName <> "" THEN                                       '
      TRY                                                         '
         hFile = FREEFILE                                         ' Touch the file now
         OPEN OStateName FOR APPEND ACCESS READ WRITE LOCK SHARED AS # hFile  '
         hFile2 = FILEATTR(hFile, 2)                              ' Get Windows handle for the file
         SetFileTime hFile2, CreationTime.MyTime, LastAccessTime.MyTime, LastWriteTime.MyTime   '
         CLOSE #hFile                                             ' Close it

      CATCH                                                       '
         AnswerSub(8, "Restore successful, couldn't re-establish File Dates") ' Say DATE attempt failed
      END TRY                                                     '
   END IF                                                         '

   AnswerSub(0, "Restore "+ IIF$(oStateName <> "", "(+ STATE)", "") + " successful")   '

END SUB                                                           '

FUNCTION DoSMacroSubst(macline AS STRING) AS LONG                 '
'--------------------------------------------------------------------------------------------------+
'- Handle all the difficult ~S(...) substitutions                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, k AS LONG, Sline, Skey1, SKey2, SData AS STRING, RCA AS RCArea '
   MEntry                                                         '
   SLine = macline                                                '
   i = INSTR(UUCASE(Sline), "~S("): IF i = 0 THEN i = INSTR(UUCASE(SLine), "^S(")   ' Find next ~S(
   DO WHILE i > 0                                                 ' Loop-de-loop
      k = INSTR(i, SLine, ")")                                    ' Look for closing bracket
      IF k = 0 OR k = i + 3 THEN FUNCTION = %True: MExitFunc      ' No?? or null (), Error return
      Skey1 = MID$(Sline, i, k - i + 1)                           ' Extract S key1 ~S(xxx)
      Skey2 = MID$(Sline, i + 3, k - i - 3)                       ' Extract S key2 xxx
      SETTableUpd("GET", SKey2, RCA)                              ' Fetch substitution value
      IF RCA.RC > 0 THEN                                          ' Not found?
         REPLACE Skey1 WITH "" IN SLine                           ' Substitute ""
         macline = SLine                                          '
         FUNCTION = %True: MExitFunc                              ' No?? Error return
      END IF                                                      '
      REPLACE Skey1 WITH RCA.Msg IN SLine                         ' Substitute
      i = INSTR(UUCASE(Sline), "~S("): IF i = 0 THEN i = INSTR(UUCASE(SLine), "^S(")   ' Find next ~S(
   LOOP                                                           '
   macline = SLine                                                '
   FUNCTION = %False                                              ' All is well
   MExit                                                          '
END FUNCTION                                                      '

SUB      DoStatusBar(which AS STRING)                             '
'--------------------------------------------------------------------------------------------------+
'- Do one or more StatusBar boxes                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL lr, lRow, lclCol, k, mx, my AS LONG                         '
LOCAL cLoc, char, LFMask, t, lclwhich AS STRING, cloc2 AS ASCIIZ * 200  '
   MEntry                                                         '
   IF ISFALSE ISOBJECT(TP) THEN  MExitSub                         ' Escape if ???
   k = gENV.InitDone                                              '
   IF ISFALSE gENV.InitDone OR ISTRUE gMacroMode OR ISTRUE gfEndAll OR ISTRUE gShutFlag THEN ' If INIT not done, MacroMode, or Shutdown exit
      MExitSub                                                    '
   END IF                                                         '
   lclwhich = which + "O"                                         ' Always add PAD
   LFMask = REPEAT$(gENV.LinNoSize, "0")                          '
   lRow = TP.CsrRow: lclCol = TP.CsrCol                           ' Get local copies

   '-----------------------------------------------------------------------------------------------+
   '- Do the requested StatusBar boxes for FM                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF IsFMTab THEN                                                ' If Tab mode
      '--------------------------------------------------------------------------------------------+
      '- Setup the SB boxes                                                                        |
      '--------------------------------------------------------------------------------------------+
      lclwhich = $AllStatusBarBoxes + "P"                         ' FM always does them all
      gWSBTable(gSBTable(%SBMode).SBAssigned).SBText = "SELECT"   ' Setup mode
      gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBText = " "       ' Setup LinNo
      gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBText = IIF$(IsTPNsrtFlag, "INS", "OVR") ' Add Insert Mode
      IF IsTPNsrtFlag AND gENV.InsMode = 1 _                      ' If at the default
      OR ISFALSE IsTPNsrtFlag AND gENV.InsMode = 0 THEN           ' Then normal colors
         gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCFG)   '
         gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCBG1)  '
      ELSE                                                        ' Else invert colors
         gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCBG1)  '
         gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCFG)   '
      END IF                                                      '
      IF IsTPNsrtFlag AND IsTPNsrtData THEN                       ' Then override if DataInsert mode
         gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBFG = gENV.GetClr(%SCHiGreen, %SCFG)  '
         gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBBG = gENV.GetClr(%SCHiGreen, %SCBG1) '
      END IF                                                      '
      gWSBTable(gSBTable(%SBCaseWord).SBAssigned).SBText = TP.FCB_.CaseFlag + IIF$(TP.FindWord, "  W", "")  '

      IF gKbdRecFlag THEN                                         ' Recording?
         gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
         gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
         gWSBTable(gSBTable(%SBMisc).SBAssigned).SBText = "KB Recording"   ' Misc
      ELSE                                                        '
         gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCFG)  '
         gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCBG1) '
         cLoc = "Lines " + FORMAT$(TP.GPTopLine) + ":"            '
         cLoc += IIF$((TP.GPTopLine + TP.gPBottom - 6) > gFMDCtr, FORMAT$(gFMDCtr - 1), FORMAT$(TP.GPTopLine + gFM_List_Height - 1))  '
         cLoc += " of " + FORMAT$(gFMDCtr - 1)                    '
         gWSBTable(gSBTable(%SBMisc).SBAssigned).SBText = cLoc    ' Misc
      END IF                                                      '
      gWSBTable(gSBTable(%SBLAYOUT).SBAssigned).SBText = IIF$(gFMLayoutID = "A", "ALTERNATE", "STANDARD")  ' Layout
      gWSBTable(gSBTable(%SBPAD).SBAssigned).SBText = TP.LNKRealName ' PAD (LNK real name)

   '-----------------------------------------------------------------------------------------------+
   '- Do the requested StatusBar boxes for non-FM                                                  |
   '-----------------------------------------------------------------------------------------------+
   ELSE                                                           '
      FOR i = 1 TO LEN(lclwhich)                                  ' Loop through Box requests
         SELECT CASE AS CONST$ MID$(lclwhich, i, 1)               ' See which are called for
            '--------------------------------------------------------------------------------------+
            '- Mode box                                                                            |
            '--------------------------------------------------------------------------------------+
            CASE $SBMode                                          '
               gWSBTable(gSBTable(%SBMode).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCFG)  '
               gWSBTable(gSBTable(%SBMode).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCBG1) '
               cLoc = SWITCH$(IsBrowse, "Browse", IsView, "View", IsClip, "Clip", ISEFTEdit, "EFT Edit", IsSetEdit, "SET Edit", %True, "Edit")  '
               IF cLoc = "View" AND TP.FCB_.ROState THEN cLoc = "RdOnly"   '
               IF TP.XFormActive <> "" THEN cLoc = "(X) " + cLoc  ' Flag it XFORM load
               IF cLoc ="Browse" OR _                             '
                  TP.XFormActive <> "" OR _                       '
                  ((cLoc = "View" OR cLoc = "RdOnly") AND IsTPModdFlag) THEN  '
                  gWSBTable(gSBTable(%SBMode).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                  gWSBTable(gSBTable(%SBMode).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
               END IF                                             '
               IF IsMedit THEN                                    ' If MEdit, re-do it all
                  cloc = FORMAT$(TP.MEditCount) + " Edit"         ' Build basic saying how many files
                  FOR k = 1 TO TP.MEditCount                      ' See how many modified
                     IF TP.MEditFlagGet(k) THEN INCR j            ' Count modified
                  NEXT k                                          '
                  IF j THEN cloc += " " + FORMAT$(j) + "*"        ' If any modified, show the count
               ELSE                                               '
                  cLoc += IIF$(IsTPModdFlag, " *", "")            ' Do simple modified display
               END IF                                             '
               gWSBTable(gSBTable(%SBMode).SBAssigned).SBText = cloc ' Filler box

            '--------------------------------------------------------------------------------------+
            '- LinNo box                                                                           |
            '--------------------------------------------------------------------------------------+
            CASE $SBLinNo                                         '
               gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCFG) '
               gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCBG1)   '
               IF TP.CursData THEN                                ' If in the data area
                  lr = TP.SGet(lRow)                              ' Add in the cursor position
                  IF lr = -1 OR lr = -2 THEN lr = TP.SGet(lRow - ABS(lr))  '
                  IF lr > 0 THEN                                  '
                     IF TP.LFlagData(lr) THEN                     '
                        cLoc = "L " + FORMAT$(VAL(TP.LLNumGet(lr)), LFMask) + "  C " + FORMAT$(lclCol - TP.GPGapCol + TP.GPOffset, 6)  '
                        GOSUB AddLabels                           ' Add Labels/Tags
                     ELSEIF ISTRUE (TP.LFlagGet(lr) AND (%Tabs OR %Mark OR %Mask OR %Note OR %Cols OR %Bounds)) THEN '
                        cLoc = "L ---  C " + FORMAT$(lclCol - TP.GPGapCol + TP.GPOffset, 6)  '
                        GOSUB AddLabels                           ' Add Labels/Tags
                     ELSEIF ISTRUE TP.LFlagXclude(lr) AND TP.CsrLinDx > 0 THEN   '
                        cLoc = "L " + FORMAT$(TP.CsrLinDX, LFMask) + "  C " + FORMAT$(lclCol - TP.GPGapCol + TP.GPOffset, 6)  '
                        gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBFG = gENV.GetClr(%SCHiGreen, %SCFG)   '
                        gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBBG = gENV.GetClr(%SCHiGreen, %SCBG1)  '
                        GOSUB AddLabels                           ' Add Labels/Tags
                     ELSEIF ISTRUE TP.LFlagXclude(lr) THEN        ' Simple Exclude
                        IF TP.LWrk1Get(lr) = 1 THEN               ' Just a single line?
                           INCR lr                                ' Point at the real line
                           cLoc = "L " + FORMAT$(VAL(TP.LLNumGet(lr)), LFMask) + "  C " + FORMAT$(lclCol - TP.GPGapCol + TP.GPOffset, 6)  '
                           GOSUB AddLabels                        ' Add Labels/Tags
                        ELSE                                      '
                           cLoc = "L " + FORMAT$(VAL(TP.LLNumGet(lr + 1)), LFMask) + " - " + FORMAT$(VAL(TP.LLNumGet(lr + TP.LWrk1Get(lr))), LFMask)  '
                        END IF                                    '
                     ELSE                                         '
                        cloc = " "                                ' Blank box
                     END IF                                       '
                     gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBText = cloc   ' LinNo box
                  END IF                                          '
               ELSEIF TP.CursLinN THEN                            ' If in the Line Number area
                  lr = TP.SGet(lRow)                              ' Add in the cursor position
                  IF lr = -1 OR lr = -2 THEN lr = TP.SGet(lRow - ABS(lr))  '
                  IF lr > 0 THEN                                  '
                     IF TP.LFlagData(lr) THEN                     '
                        cLoc = "  L " + FORMAT$(VAL(TP.LLNumGet(lr)), LFMask) '
                        GOSUB AddLabels                           ' Add Labels/Tags
                     ELSEIF ISTRUE TP.LFlagXclude(lr) THEN        ' Simple Exclude
                        IF TP.LWrk1Get(lr) = 1 THEN               ' Just a single line?
                           INCR lr                                ' Point at the real line
                           cLoc = "  L " + FORMAT$(VAL(TP.LLNumGet(lr)), LFMask) '
                           GOSUB AddLabels                        ' Add Labels/Tags
                        ELSE                                      '
                           cLoc = "  L " + FORMAT$(VAL(TP.LLNumGet(lr + 1)), LFMask) + " - " + FORMAT$(VAL(TP.LLNumGet(lr + TP.LWrk1Get(lr))), LFMask)   '
                        END IF                                    '
                     ELSE                                         '
                        cloc = " "                                '
                     END IF                                       '
                     gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBText = cloc   ' LinNo box
                  END IF                                          '
               ELSEIF TP.CursCmnd THEN                            ' If in the command area
                  IF ISFALSE IsClip AND ISFALSE IsSetEdit AND ISFALSE IsEFTEdit AND ISFALSE IsMEdit AND TP.FCB_.Date <> "" THEN  '
                     gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBText = "  " + TP.FCB_.Date + "  " + TP.FCB_.Time  ' LinNo box
                  ELSE                                            '
                     gWSBTable(gSBTable(%SBLinNo).SBAssigned).SBText = " " ' LinNo box
                  END IF                                          '
               END IF                                             '

               IF IsMedit THEN                                    ' If MEdit, do Title bar fudge
                  lr = TP.SGet(lRow)                              ' Add in the cursor position
                  IF lr = -1 OR lr = -2 OR lr = -3 THEN lr = TP.SGet(lRow - ABS(lr))   '
                  IF lr = 0 THEN                                  ' Wasn't on a data line
                     FOR mx = TP.gPTop TO TP.gPBottom             ' Find 1st data line on screen
                        my = TP.SGet(mx)                          ' Get a line reference
                        IF my = -1 OR my = -2 OR my = -3 THEN my = TP.SGet(mx - ABS(my))  '
                        IF my AND TP.LFlagData(my) THEN           ' A data line?
                           lr = my                                ' Lets use it
                           EXIT FOR                               ' We've found one
                        END IF                                    '
                     NEXT j                                       '
                  END IF                                          '
                  IF lr > 0 THEN                                  '
                     lr = TP.LMixGet(lr)                          ' Get the MIX index
                     IF lr > 0 THEN                               ' Valid?
                        cloc = "Multi-Edit - SPFLite" + IIF$(ISNULL(gENV.eInstance) OR gENV.eInstance = "DEFAULT", "(v" + gENV.PgmVers + $Beta + ")", "(" + gENV.eInstance + $Beta + ")") '
                        cloc += " - " + MID$(TP.MEditListGet(lr), INSTR(-1, TP.MEditListGet(lr), "\") + 1)  '
                        cloc2 = cloc                              ' Make correct format
                        SetWindowText(ghWnd, cloc2)               ' Alter window title
                     END IF                                       '
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Lines box                                                                           |
            '--------------------------------------------------------------------------------------+
            CASE $SBLines                                         '
               gWSBTable(gSBTable(%SBLines).SBAssigned).SBText = "Lines: " + FORMAT$(TP.LastReal)  ' Lines:

            '--------------------------------------------------------------------------------------+
            '- Cols box                                                                            |
            '--------------------------------------------------------------------------------------+
            CASE $SBCols                                          '
               gWSBTable(gSBTable(%SBCols).SBAssigned).SBText = "Cols " + FORMAT$((TP.GPOffset + 1), "#####") + " to " + FORMAT$((TP.GPOffset + TP.GPDataLen), "#####") 'Cols

            '--------------------------------------------------------------------------------------+
            '- Bounds box                                                                          |
            '--------------------------------------------------------------------------------------+
            CASE $SBBnds                                          '
               gWSBTable(gSBTable(%SBBnds).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCFG)  '
               gWSBTable(gSBTable(%SBBnds).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCBG1) '
               cLoc = "Bnds: "                                    ' Add Bnds
               IF TP.FCB_.BndLeft = 1 AND TP.FCB_.BndRight = 0 THEN  ' Entire line bounds?
                  cLoc += "MAX"                                   ' Say MAX
               ELSEIF TP.FCB_.BndRight = 0 THEN                   ' LB to Max?
                  cLoc += FORMAT$(TP.FCB_.BndLeft) + " to MAX"    ' Setup display
                  gWSBTable(gSBTable(%SBBnds).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                  gWSBTable(gSBTable(%SBBnds).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
               ELSEIF TP.FCB_.BndRight > 0 THEN                   ' LB to RB?
                  cLoc += FORMAT$(TP.FCB_.BndLeft) + " to " + FORMAT$(TP.FCB_.BndRight)   ' Setup display
                  gWSBTable(gSBTable(%SBBnds).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                  gWSBTable(gSBTable(%SBBnds).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
               END IF                                             '
               gWSBTable(gSBTable(%SBBnds).SBAssigned).SBText = cLoc '

            '--------------------------------------------------------------------------------------+
            '- InsOvr box                                                                          |
            '--------------------------------------------------------------------------------------+
            CASE $SBInsOvr                                        '
               cLoc = IIF$(IsTPNsrtFlag, "INS", "OVR")            ' Add Insert Mode
               IF TP.FCB_.TabBNDS THEN cLoc = "TAB " + cLoc       '
               gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBText = cLoc  '
               IF IsTPNsrtFlag AND gENV.InsMode = 1 _             ' If at the default
               OR ISFALSE IsTPNsrtFlag AND gENV.InsMode = 0 THEN  ' Then normal colors
                  gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCFG)   '
                  gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCBG1)  '
               ELSE                                               ' Else invert colors
                  gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCBG1)  '
                  gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCFG)   '
               END IF                                             '
               IF IsTPNsrtFlag AND IsTPNsrtData THEN              ' Then override if DataInsert mode
                  gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBText = IIF$(TP.FCB_.TabBNDS, "TAB DIN", "DIN")   ' Add DIN Mode
                  gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBFG = gENV.GetClr(%SCHiGreen, %SCFG)  '
                  gWSBTable(gSBTable(%SBInsOvr).SBAssigned).SBBG = gENV.GetClr(%SCHiGreen, %SCBG1) '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- CaseWord box                                                                        |
            '--------------------------------------------------------------------------------------+
            CASE $SBCaseWord                                      '
               gWSBTable(gSBTable(%SBCaseWord).SBAssigned).SBText = TP.FCB_.CaseFlag + IIF$(TP.FindWord, " W", "")   ' Add default literal Case and Find Word modes

            '--------------------------------------------------------------------------------------+
            '- Change box                                                                          |
            '--------------------------------------------------------------------------------------+
            CASE $SBChange                                        '
               gWSBTable(gSBTable(%SBChange).SBAssigned).SBText = IIF$(TP.FCB_.ChangeMode = "D", "DS", "CS")   ' Add Change setting

            '--------------------------------------------------------------------------------------+
            '- State box                                                                           |
            '--------------------------------------------------------------------------------------+
            CASE $SBState                                         '
               gWSBTable(gSBTable(%SBState).SBAssigned).SBText = "S" + IIF$(IsTPStateExist, "+", "-") ' Add STATE staus

            '--------------------------------------------------------------------------------------+
            '- Misc box                                                                            |
            '--------------------------------------------------------------------------------------+
            CASE $SBMisc                                          '
               gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCStatus, %SCFG)  '
               gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCStatus, %SCBG1) '
               IF ISFALSE IsTPMarkDrawn THEN                      ' If nothing hi-lighted
                  IF IsTPSwapDrawn THEN                           ' Insert the Swap Pending
                     cloc = "Swap Pending"                        '
                     gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                     gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
                  ELSE                                            '
                     IF IsTPPTypeMode THEN                        ' If PowerType
                        cLoc = "PowerType"                        ' Add to status bar
                        gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                        gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
                     ELSE                                         '
                        IF gKbdRecFlag THEN                       ' Multi use, pick one
                           cLoc = "KB Recording"                  '
                           gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                           gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
                        ELSEIF (TP.FCB_.AutoSave AND (%AutoSON OR %AutoSPrompt)) = 0 THEN '
                           cLoc = "AUTOSAVE OFF"                  '
                           gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                           gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
                        ELSEIF lrow = 1 THEN                      '
                              cLoc = "Profile: " + TP.FCB_.ProfName  ' Indicate Profile
                        ELSE                                      '
                           cLoc =  " "                            '
                        END IF                                    '
                        IF cLoc = " " THEN                        ' Result of prev tests a blank?
                           lr = TP.SGet(lRow)                     ' Get the line number
                           IF lr = -1 OR lr = -2 THEN lr = TP.SGet(lRow - ABS(lr))  '
                           IF lr > 0 THEN                         '
                              IF TP.LFlagData(lr) THEN            '
                                 cLoc = "Line Len " + FORMAT$(TP.LTxtLen(lr), "0000")  '
                              END IF                              '
                           END IF                                 '
                        END IF                                    '
                     END IF                                       '
                  END IF                                          '
                  gWSBTable(gSBTable(%SBMisc).SBAssigned).SBText = cLoc '
               ELSE                                               '
                  IF IsTPSwapDrawn THEN                           ' Insert the Swap Pending
                     cloc = "Swap Pending"                        '
                     gWSBTable(gSBTable(%SBMisc).SBAssigned).SBFG = gENV.GetClr(%SCHiRed, %SCFG)   '
                     gWSBTable(gSBTable(%SBMisc).SBAssigned).SBBG = gENV.GetClr(%SCHiRed, %SCBG1)  '
                  ELSE                                            '
                     IF TP.MarkGB <> TP.MarkGT  OR TP.MarkGR <> TP.MarkGL OR _   '
                        TP.MarkGL > TP.LTxtLen(TP.MarkGT) THEN    '
                        cLoc = "Len "                             ' Build selected message
                        cloc += FORMAT$(TP.MarkGR - TP.MarkGL + 1)   '
                        IF TP.MarkGB <> TP.MarkGT THEN            '
                           k = 0                                  '
                           FOR j = TP.MarkGT TO TP.MarkGB         ' Count lines in group
                              IF TP.LFlagData(j) THEN INCR k      '
                           NEXT j                                 '
                           IF k > 0 THEN cLoc += " x " + FORMAT$(k)  '
                        END IF                                    '
                     ELSE                                         '
                        char = MID$(TP.LTxtGet(TP.MarkGT), TP.MarkGL, 1)   ' Get char at cursor
                        IF TP.FCB_.SrceXlate THEN _               '
                           TP.Translate(char, TP.FCB_.GetSA2SPtr) ' Translate ANSI to SOURCE
                        cLoc = "X'" + HEX$(ASC(char), 2) + "' = " + FORMAT$(ASC(char)) ' Build rest of message
                     END IF                                       '
                  END IF                                          '
                  IF IsTPPTypeMode THEN cloc = "PT  " + cloc      '
                  gWSBTable(gSBTable(%SBMisc).SBAssigned).SBText = cLoc '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Select box                                                                          |
            '--------------------------------------------------------------------------------------+
            CASE $SBSelect                                        '
               IF IsTPSlecSet THEN                                ' If nothing set, do nothing
                  IF IsTPSlecActive THEN                          ' Active?
                     cloc = "@ " + FORMAT$(TP.SlecSCol) + " " + FORMAT$(TP.SlecECol) + "  # " + _  '
                            "." + FORMAT$(TP.SlecSLin) + " ." + FORMAT$(TP.SlecELin)   '
                     gWSBTable(gSBTable(%SBSelect).SBAssigned).SBText = cloc  '
                  ELSE                                            '
                     gWSBTable(gSBTable(%SBSelect).SBAssigned).SBText = "Select" '
                  END IF                                          '
               ELSE                                               '
                  gWSBTable(gSBTable(%SBSelect).SBAssigned).SBText = " "   '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Caps box                                                                            |
            '--------------------------------------------------------------------------------------+
            CASE $SBCaps                                          '
               cLoc = ""                                          '
               IF TP.FCB_.CapsDesired <> 2 THEN                   ' Add CAPS
                  cLoc += IIF$(TP.FCB_.CapsDesired, "CAPS ON", "CAPS OFF") '
               ELSE                                               '
                  cLoc += "CAPS AUTO:" + IIF$(TP.FCB_.CapsActual, "on", "off")   '
               END IF                                             '
               gWSBTable(gSBTable(%SBCaps).SBAssigned).SBText = cLoc '

            '--------------------------------------------------------------------------------------+
            '- Source box                                                                          |
            '--------------------------------------------------------------------------------------+
            CASE $SBSource                                        '
               gWSBTable(gSBTable(%SBSource).SBAssigned).SBText = TP.FCB_.SourceName   ' Add Source Encoding type

            '--------------------------------------------------------------------------------------+
            '- EOL box                                                                             |
            '--------------------------------------------------------------------------------------+
            CASE $SBEOL                                           '
               cLoc = TP.FCB_.EOL                                 ' Add EOL setting
               gWSBTable(gSBTable(%SBEOL).SBAssigned).SBText = cLoc  '

         END SELECT                                               '
      NEXT i                                                      '
      gWSBTable(gSBTable(%SBPad).SBAssigned).SBText = " "         ' Filler box
   END IF                                                         '

JustRefresh:                                                      '
   '-----------------------------------------------------------------------------------------------+
   '- Now output the selected boxes                                                                |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gSBCount                                          ' Loop through
      cloc2 = FORMAT$(i, "00")                                    ' Send table index as the text
      SENDMESSAGE (ghStatusBar, %SB_SETTEXT, (i - 1) OR %SBT_OWNERDRAW, BYVAL VARPTR(cloc2)) '
   NEXT i                                                         '
   MExitSub                                                       ' We're done

AddLabels:                                                        '
   IF TP.LTagGet(lr) <> $BlankLNo  AND TP.LLblGet(lr) <> $BlankLNo THEN '
      cloc += "  " + TRIM$(TP.LTagGet(lr))                        '
   END IF                                                         '
   RETURN                                                         '

END SUB                                                           '

SUB     DoTermination(ShutCmd AS STRING, NoReopen AS LONG)        '
'--------------------------------------------------------------------------------------------------+
'- Terminate all the tabs   (EXIT)                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i, x, y, cTab AS LONG, mnames, mrf, TabType, t AS STRING    '
   TRY
      gfEndAll = %True                                            ' Remember us in global memory
      cTab = TP.PgNumber                                          ' Save current tab
      mrf = BuildMRF(cTab)                                        ' Get the built MRF string
      FOR i = gTabsNum TO 2 STEP -1                               ' Do for each tab
         TP = gTabs(i)                                            ' Switch to it
         TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber           ' Select the tab
         IF LEFT$(shutcmd, 3) = "END" THEN                        ' Which type
            pCmdEND(shutcmd)                                      ' Let END have a go
         ELSE                                                     '
            pCmdCANCEL(shutcmd)                                   ' else let CANCEL have a go
         END IF                                                   '
         IF ISFALSE gfEndAll THEN GOTO Exit2                      ' Somebody selected CANCEL, bail out
      NEXT i                                                      '
      TP = gTabs(cTab)                                            ' Put back the visible tab
      '--------------------------------------------------------------------------------------------+
      '- Save FM stuff                                                                             |
      '--------------------------------------------------------------------------------------------+
      TP = gTabs(1)                                               ' Point at the FM tab
      gSQL.UpdateString("O", "FileListNm", TP.FileListNm)         '
      gSQL.UpdateString("O", "DefDir1", TP.FPath)                 '
      gSQL.UpdateString("O", "DefMask", TP.FMask)                 '
      IF gENV.FMLastSectNo <> 0 THEN gENV.SetFMCrit(TP.DirSort, TP.DefSort, TP.FMask, gFMLayoutID) ' Save the new values in FMDefCrit as well
   CATCH
      MSGBOX "Do Terminate Crash"
   END TRY
Exit1:                                                            '
   IF noreopen THEN mrf = ""                                      ' If NOREOPEN, null the list
   gSQL.UpdateString("O", "MRFList", mrf)                         ' Save it
   gRtr.Save                                                      ' Save Retrieve stack
   gfTermFlag = %True                                             ' So we don't loop
   DIALOG GET LOC ghWnd TO x, y                                   ' Get location where window was
   gENV.LastScreenX = x: gENV.LastScreenY = y                     ' Save them away
   gENV.SetINITimeStamp                                           '
   Debug "$$STOP"                                                 ' Kill the Debug window
   DIALOG END ghWnd                                               ' Kill our dialog
   gTabsNum = 0                                                   ' No more tabs
   gTabDelCtr = 0                                                 ' No more deletes
   GoToTab(0, "", "")                                             ' No more switches

Exit2:                                                            '
   'MSGBOX "DoTermination Exit"
   EXIT SUB                                                       '

'--------------------------------------------------------------------------------------------------+
'- Just in case                                                                                    |
'--------------------------------------------------------------------------------------------------+
Whoops:                                                           '
   IF ISFALSE gfEndAll THEN RESUME Exit2                          ' Somebody said CANCEL, don't save MRF
   RESUME Exit1                                                   '
END SUB                                                           '

FUNCTION DoVMacroSubst(macline AS STRING) AS LONG                 '
'--------------------------------------------------------------------------------------------------+
'- Handle all the difficult ~V(...) substitutions                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, k AS LONG, Sline, Skey1, SKey2, SData AS STRING          '
   MEntry                                                         '
   SLine = macline                                                '
   i = INSTR(UUCASE(Sline), "~V("): IF i = 0 THEN i = INSTR(UUCASE(SLine), "^V(")   ' Find next ~V(
   DO WHILE i > 0                                                 ' Loop-de-loop
      k = INSTR(i, SLine, ")")                                    ' Look for closing bracket
      IF k = 0 OR k = i + 3 THEN FUNCTION = %True: MExitFunc      ' No?? or null (), Error return
      Skey1 = MID$(Sline, i, k - i + 1)                           ' Extract S key1 ~S(xxx)
      Skey2 = MID$(Sline, i + 3, k - i - 3)                       ' Extract S key2 xxx
      SData = ENVIRON$(SKey2)                                     ' Fetch environ string
      REPLACE Skey1 WITH SData IN SLine                           ' Substitute
      i = INSTR(UUCASE(Sline), "~V("): IF i = 0 THEN i = INSTR(UUCASE(SLine), "^V(")   ' Find next ~V(
   LOOP                                                           '
   macline = SLine                                                '
   FUNCTION = %False                                              ' All is well
   MExit                                                          '
END FUNCTION                                                      '

SUB      DOCmdAdd(DoMSG AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Add an item to gCmdList                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i, k AS LONG                                                '
LOCAL DMsg AS KBMsg                                               '
   k = UBOUND(gCmdList())                                         ' Get current size of list
   REDIM PRESERVE gCmdList(0 TO k + 1) AS GLOBAL STRING           ' Redim gCmdList() to correct size
   gCmdList(k + 1) = DoMSG                                        ' Store it in gCmdList()
   MID$(DMsg.kbString, 1, 4) = CHR$(5, 0, 0, 0)                   ' Flag as Message type 5 - DO execute
   i = PostMessage(ghWnd, %WM_USER, DMsg.MsgwParam, 0)            ' To the mainline Callback routine
END SUB                                                           '

FUNCTION DOCmdLoadMac(MacName AS STRING) AS LONG                  '
'--------------------------------------------------------------------------------------------------+
'- Get gCmdList() setup                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, FNum AS LONG, Txt1, fn AS STRING                   '

   '-----------------------------------------------------------------------------------------------+
   '- OK, try and read it                                                                          |
   '-----------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- If CMDPAD name, fudge location                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF MacName <> "CMDPAD" THEN                                    ' If not CMDPAD
      fn = gENV.HomeData + "MACROS\" + MacName + ".DO"            ' Setup normal name
   ELSE                                                           ' Otherwise
      fn = gENV.Homedata + "CLIP\" + "CMDPAD.CLIP"                ' Setup CMDPAD location
   END IF                                                         '
   IF ISFALSE ISFILE(fn) THEN                                     ' See if a file exists
      FUNCTION = 0: EXIT FUNCTION                                 ' No file, then return error
   END IF                                                         '
   FNum = FREEFILE                                                ' Get a file number
   Call3(TryOpenInput(fn, FNum), _ GOTO LMExist, LMFail, LMOK     ' Try the open
         TP.ErrMsgAdd(%eFail, "Macro file: " + fn + " doesn't exist"): EXIT FUNCTION, _   ' Oops?  Bail out
         TP.ErrMsgAdd(%eFail, "OPEN of Macro: " + fn + " failed"): EXIT FUNCTION, _ '
         Nul)                                                     ' Continue
   FILESCAN # FNum, RECORDS TO j                                  ' Get # records in file
   k = UBOUND(gCmdList())                                         ' Save current size of list
   REDIM PRESERVE gCmdList(0 TO k + j) AS GLOBAL STRING           ' Redim gCmdList() to correct size
   i = UBOUND(gCmdList())                                         '
   DO WHILE ISFALSE EOF(FNum)                                     ' Read the data
      LINE INPUT # FNum, Txt1                                     ' Get a line
      INCR k                                                      ' Count it
      gCmdList(k) = Txt1                                          ' Store it in gCmdList()
   LOOP                                                           '
   CLOSE # FNum                                                   ' Close the file
   FUNCTION = j + k                                               ' Pass back # of entries
END FUNCTION                                                      '

SUB      FileChangeNotification()                                 '
'--------------------------------------------------------------------------------------------------+
'- Handle the notification that a file has changed                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i, NewStart, lclMode AS LONG, lclFn, MorD AS STRING         '

   MEntry                                                         '
   IF gPending THEN MExitSub                                      '
   FOR i = 1 TO UBOUND(gFQ())                                     ' Search for it
      IF ISTRUE gFQ(i).gInUse AND gFQ(i).gPgNumber = TP.PgNumber THEN   ' Is this an entry for this tab?
         IF gFQ(i).gFlag <> " " THEN                              ' Been flagged?
            lclFn = gFQ(i).gWatchFile                             ' Yes, get the filename involved
            MorD = gFQ(i).gFlag                                   ' And the type of change flag
            gFQ(i).gFlag = " "                                    ' Reset the flag
            EXIT FOR                                              ' Done searching
         END IF                                                   '
      END IF                                                      '
   NEXT i                                                         '
   IF ISNULL(lclFn) THEN TRACE OFF: MExitSub                      ' Oops! Shouldn't happen, but ...

   '-----------------------------------------------------------------------------------------------+
   '- Check the user's Notify options                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF gENV.NotifyLevelT = 0 THEN MexitSub                         ' Never notify, just exit
   IF gENV.NotifyLevelT = 1 THEN                                  ' Just EDIT tabs?
      IF IsBrowse OR IsView THEN MexitSub                         ' But this is BROWSE/VIEW, just exit
   END IF                                                         ' Following then is for Notify = 2 (All)

   '-----------------------------------------------------------------------------------------------+
   '- See if file was deleted                                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF MorD = "D" THEN                                             ' File has been deleted
      TP.WatchFlag = " "                                          ' Reset the WatchFlag
      gPending = %True                                            ' Say we've got a prompt out.
      DoMessageBox "The Current file:" + $CRLF + $CRLF + _        '
                   "|K" + lclFn + $CRLF + $CRLF + _               '
                   "|Bmay have been modified or Deleted. SPFLite cannot determine which." + $CRLF + $CRLF + _  '
                   "You should save this session under a temporary name" + $CRLF + _   '
                   "(|KOTHER THAN |Bit's true name) using the |KCREATE |Bcommand" + $CRLF + _   '
                   "for your own protection before investigating" + $CRLF + _ '
                   "the cause of this alteration.", %MB_OK OR %MB_USERICON, "SPFLite"  '
      gPending = %False                                           ' Kill outstanding prompt
      TRACE OFF                                                   '

   '-----------------------------------------------------------------------------------------------+
   '- File has been Modified                                                                       |
   '-----------------------------------------------------------------------------------------------+
   ELSEIF MorD = "M" THEN                                         ' Should be the only thing left but ...
      TP.WatchFlag = " "                                          ' Reset the WatchFlag
      IF IsMEdit THEN                                             ' Whoops! a MEdit session
         gPending = %True                                         ' Say we've got a prompt out.
         DoMessageBox "The Current file:" + $CRLF + $CRLF + _     '
                      "|K" + lclFn + $CRLF + $CRLF + _            '
                      "|Bhas been Modified and is part of this Multi-Edit session." + $CRLF + $CRLF + _  '
                      "You should evaluate the changes you may have made in this session and" + $CRLF + _   '
                      "determine the best action. If suitable, a RELOAD command should" + $CRLF + _   '
                      "be issued to re-load all the files for this session; but this will lose" + $CRLF + _ '
                      "all current changes." + $CRLF + $CRLF + _  '
                      "Or you could evaluate what the external change was and ignore the RELOAD.", %MB_OK OR %MB_USERICON, "SPFLite"   '
         gPending = %False                                        ' Kill outstanding prompt
         MExitSub                                                 '
      END IF                                                      '
      gPending = %True                                            ' Say we've got a prompt out.
      i = DoMessageBox("The Current file:" + $CRLF + $CRLF + _    '
                       "|K" + lclFn + $CRLF + $CRLF + _           '
                       "|BHas been modified elsewhere" + $CRLF + _   '
                       "Do you want to load the modified version?", %MB_YESNO OR %MB_USERICON, "SPFLite")   '
      gPending = %False                                           ' Kill outstanding prompt
      IF i = %IDYES THEN                                          ' Reply was YES, reload it
         lclMode = TP.TabMode                                     ' Save tab mode
         TP.MarkKill                                              ' Kill any active block select
         TP.SwapKill                                              ' Kill any active Swap select
         i = TP.FileWatch("", %WatchEnd)                          ' Kill any prior Watch
         IF ISFALSE IsTPModdFlag AND TP.FCB_.Start = "NEW" THEN   ' If not modified and START NEW
            NewStart = TP.LastLine - 1                            ' Save where .START should go
         END IF                                                   '
         TP.CurrPCmd = "FILEWATCH"                                ' Tell CopyaFile that it's FileWatch doing the Open
         TP.LInitTxtData()                                        ' Wipe everything out then
         TP.InitaFile(%False)                                     ' Initialize file stuff again
         IF NewStart <> 0 AND NewStart < TP.LastLine THEN         ' Is the save NewStart valid?
            TP.SPTopLine(NewStart)                                '
            TP.LLblSet(TP.LastLine - 1, ".START")                 ' Add the Label
            TP.UpdLControl(TP.LastLine - 1)                       ' Put back the line number
         END IF                                                   '
         TP.TabMode = lclMode                                     ' Restore Mode
         '-----------------------------------------------------------------------------------------+
         '- See if IMacro to be done                                                               |
         '-----------------------------------------------------------------------------------------+
         IF TP.FCB_.IMacro <> "" THEN                             ' Is there an IMacro?
            IF UCASE$(TP.FCB_.IMacro) = TP.FCB_.IMacro THEN       ' Is macroname Uppercase? (ON)
               IF isMacro(TP.FCB_.IMacro) THEN                    ' Does it exist?
                  TP.pCmdMacro(TP.FCB_.IMacro)                    ' Then go do it
               END IF                                             '
            END IF                                                '
         END IF                                                   '
         TP.UndoSave()                                            ' Take an initial one
         TP.FCB_.TimeDateRefresh                                  ' Get refreshed Date/Time
         TP.WindowTitle                                           ' Alter window title
         TP.ErrMsgAdd(0, "File data has been re-loaded")          ' Issue error
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END SUB                                                           '

FUNCTION FileListAdd(FileList AS STRING, BYVAL NewFile AS STRING, NewMode AS STRING, NewDate AS STRING) AS STRING '
'--------------------------------------------------------------------------------------------------+
'- Add/Update a FileList                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL FNum, i, j AS LONG                                          '
LOCAL fn, t, tlist(), tlist2(), MSG, lclFile AS STRING            '
LOCAL RQPath, RQMask, RQMode, RQDate AS STRING                    '
   MEntry                                                         '
   DIM tlist(1 TO gENV.RecentCtr) AS STRING                       '
   '-----------------------------------------------------------------------------------------------+
   '- Load the existing FILELIST                                                                   |
   '-----------------------------------------------------------------------------------------------+
   fn = gENV.HomeData + "FILELIST\" + FileList + ".FLIST"            ' Build it the normal way
   IF FileList = "Recent Files" AND gENV.eINSTANCE <> "DEFAULT" THEN ' An INSTANCE Recent Files?
      fn = gENV.HomeData + "FILELIST\" + FileList + "." + gENV.eINSTANCE + ".FLIST"  ' Build name
   END IF                                                         '

   FNum = FREEFILE                                                ' Load the table
   lclFile = NewFile                                              ' Get working copy

   '-----------------------------------------------------------------------------------------------+
   '- Make adjustment for Paths                                                                    |
   '-----------------------------------------------------------------------------------------------+
   IF FileList = "Recent Paths" THEN                              ' If Recent Paths, clean up the // and ///
      lclFile = LEFT$(lclFile, INSTR(-1, lclFile, "\"))           '
      IF RIGHT$(lclfile, 3) = "\\\" THEN lclFile = CLIP$(RIGHT, lclFile, 2)   '
      IF RIGHT$(lclfile, 2) = "\\"  THEN lclFile = CLIP$(RIGHT, lclFile, 1)   '
   END IF                                                         '

   IF ISFILE(fn) THEN                                             ' FLIST exist?
      TRY                                                         ' Just in case
         OPEN fn FOR INPUT AS #FNum                               ' Open the FILELIST File
         FILESCAN #FNum, RECORDS TO i                             ' Get the number of records
         REDIM tlist(1 TO i + 1) AS STRING                        ' Redim array to match save data plus one
         LINE INPUT #FNum, tlist() TO j                           ' Read it all into tlist()
         CLOSE #FNum                                              ' Close it
      CATCH                                                       ' An Oops?
         MSG = "FLIST update skipped, I/O Problem"                ' Say Something
         GOTO DoNothing                                           ' Skip doing anything
      END TRY                                                     '
      '--------------------------------------------------------------------------------------------+
      '- Now Update or Add the passed entry                                                        |
      '--------------------------------------------------------------------------------------------+
      FOR i = 1 TO j                                              ' First see if the file is already here
         TP.RQSplit(tlist(i), RQPath, RQMask, RQMode, RQDate)     ' Split entry
         IF uucase(lclFile) = uucase(RQPath) THEN                 ' Same file?
            MSG = "File updated in " + fn                         '
            tlist(i) = BUILD$(RQPath, "|", RQMask, "|", NewMode, "|", NewDate)   ' Update with new Mode/Date
            i = 0: EXIT FOR                                       ' Set i=0 to say found and Exit the FOR
         END IF                                                   '
      NEXT i                                                      '
      IF i <> 0 THEN                                              ' If we didn't find it
         INCR j                                                   ' Incr count in list
         MSG = "File added to " + fn                              '
         tlist(j) = BUILD$(lclFile, "||", NewMode, "|", NewDate)  ' Add the entry
      END IF                                                      '

   ELSE                                                           ' Empty file, create it
      MSG = "File added to New " + fn                             '
      REDIM tlist(1 TO 1) AS STRING                               ' Recreate a 1 item table
      tlist(1) = BUILD$(lclFile, "||", NewMode, "|", NewDate)     ' Swap in provided entry
      j = 1                                                       '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Cleanup if Recent and over the limit                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF (FileList = "Recent Files" OR FileList = "Recent Paths") AND j > gENV.RecentCtr THEN   ' Any need to do this?
      DIM tlist2(1 TO j) AS STRING                                ' DIM temp array
      FOR i = 1 TO j                                              ' Build sort key
         TP.RQSplit(tlist(i), RQPath, RQMask, RQMode, RQDate)     ' Split entry
         tlist2(i) = RQDate                                       ' Make date the key
      NEXT i                                                      '
      ARRAY SORT tlist2() FOR j, TAGARRAY tlist(), DESCEND        ' Sort
      j = gENV.RecentCtr                                          ' Trim back the count
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Finally, write back the updated file                                                         |
   '-----------------------------------------------------------------------------------------------+
   FNum = FREEFILE                                                ' Get file number
   OPEN fn FOR OUTPUT AS #FNum                                    ' Open the output File
   FOR i = 1 TO j                                                 ' Write the array back out
      IF ISNOTNULL(tlist(i)) THEN PRINT #FNum, tlist(i)           ' Just non-Null entries
   NEXT i                                                         '
   SETEOF #FNum                                                   '
   CLOSE #FNum                                                    '
   DoNothing:                                                     '
   FUNCTION = MSG                                                 ' Pass back the result
   MExit                                                          ' Say goodbye
END FUNCTION                                                      '

SUB      FileListDelete(list AS STRING, BYVAL file AS STRING)     '
'--------------------------------------------------------------------------------------------------+
'- Delete an entry from a list                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL FNum, c, i, j AS LONG                                       '
LOCAL fn, tlist(), RQPath, RQMask, RQMode, RQDate AS STRING       '
   MEntry                                                         '
   fn = gENV.HomeData + "FILELIST\" + list + ".FLIST"                ' Build it the normal way
   IF list = "Recent Files" AND gENV.eINSTANCE <> "DEFAULT" THEN  ' An INSTANCE Recent Files?
      fn = gENV.HomeData + "FILELIST\" + list + "." + gENV.eINSTANCE + ".FLIST"   ' Build name
   END IF                                                         '
   FNum = FREEFILE                                                ' Load the FILELIST
   IF ISFALSE ISFILE(fn) THEN MExitSub                            ' Exit if file not found.  ???
   OPEN fn FOR INPUT AS #FNum                                     ' Open the FILELIST File
   FILESCAN #FNum, RECORDS TO i                                   ' Get the number of records
   REDIM tlist(1 TO i) AS STRING                                  ' Redim array to match save data
   LINE INPUT #FNum, tlist() TO j                                 ' Read it all
   CLOSE #FNum                                                    ' Close it
   c = j                                                          ' Save original number
   FOR i = j TO 1 STEP -1                                         ' Look for file to delete
      tlist(i) = TRIM$(tlist(i))                                  ' Clean it up
      IF ISNULL(tlist(i)) OR _                                    ' A null entry?
         IsEQ(LEFT$(tlist(i), 9), "FILESRCH:") THEN               '
         ARRAY DELETE tlist(i)                                    ' Remove it from the list
         DECR j                                                   ' Adjust count
      END IF                                                      '
      TP.RQSplit(tlist(i), RQPath, RQMask, RQMode, RQDate)        ' Split operands
      StrUnQuote(RQPath)                                          ' Remove any quotes
      IF IsEQ(RQPath, file) THEN                                  ' The one to delete?
         ARRAY DELETE tlist(i)                                    ' Delete it
         DECR j                                                   ' Adjust count
         EXIT FOR                                                 ' Exit loop
      END IF                                                      '
   NEXT i                                                         '
   IF c <> j THEN                                                 ' Did we delete something?
      IF j = 0 THEN                                               ' End up empty?
         i = FileRecycleBin(fn, "D")                              ' Delete empty files
         TP.FileListNm = ""                                       ' Just turn it off
      ELSE                                                        '
         FNum = FREEFILE                                          ' Rewrite the file
         OPEN fn FOR OUTPUT AS #FNum                              ' Open the output File
         FOR i = 1 TO j                                           ' Write the array back out
            PRINT #FNum, tlist(i)                                 '
         NEXT i                                                   '
         SETEOF #FNum                                             '
         CLOSE #FNum                                              '
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END SUB                                                           '

SUB      FileListRecentAdd(file AS STRING, sMode AS STRING)       '
'--------------------------------------------------------------------------------------------------+
'- Add/Update an item in the RECENT list                                                           |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF IsNE(RIGHT$(file, 6), ".FLIST") THEN                        ' If not a FILELIST itself
      FileListAdd("Recent Files", file, sMode, TimePretty(0))     ' Call common routine with added unique parameters
      FileListAdd("Recent Paths", file, sMode, TimePretty(0))     ' Ditto for PATHS
   END IF                                                         '
   MExit                                                          '
END SUB                                                           '

SUB      FileListRename(oname AS STRING, nname AS STRING)         '
'--------------------------------------------------------------------------------------------------+
'- Rename throughout the FILELIST set                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL tfn, fn AS STRING, FD AS DIRDATA, FNum, i, j, OurTab, Found AS LONG, tlist() AS STRING '
LOCAL RQPath, RQMask, RQMode, RQDate AS STRING                    '
   OurTab = TP.PgNumber                                           ' Save our page number
   TP = gTabs(OurTab)                                             ' Switch back to original tab
   MEntry                                                         '
   tfn = DIR$(gENV.HomeData + "FILELIST\" + "*.FLIST" TO FD)         ' Look for our FILELIST files

   '-----------------------------------------------------------------------------------------------+
   '- Loop through the FILELIST files                                                              |
   '-----------------------------------------------------------------------------------------------+
   DO WHILE ISNOTNULL(tfn)                                        ' While we're getting entries
      IF (FD.FileAttributes AND %FILE_ATTRIBUTE_DIRECTORY) <> %FILE_ATTRIBUTE_DIRECTORY THEN '

         '-----------------------------------------------------------------------------------------+
         '- For each FILELIST file look at it's data                                               |
         '-----------------------------------------------------------------------------------------+
         fn = gENV.HomeData + "FILELIST\" + TRIM$(FD.FileName)       ' Get the filename
         FNum = FREEFILE                                          ' Load the Data
         OPEN fn FOR INPUT AS #FNum                               ' Open the FILELIST File
         FILESCAN #FNum, RECORDS TO i                             ' Get the number of records
         IF i > 0 THEN                                            ' Some records?
            REDIM tlist(1 TO i) AS STRING                         ' Redim array to match save data
            LINE INPUT #FNum, tlist() TO j                        ' Read it all
         END IF                                                   '
         CLOSE #FNum                                              ' Close it
         Found = %False                                           '

         '-----------------------------------------------------------------------------------------+
         '- Scan the lines in the file for our rename                                              |
         '-----------------------------------------------------------------------------------------+
         IF j THEN                                                ' Did we get some records?
            FOR i = 1 TO j                                        ' OK, let's scan the records
               IF INSTR(tlist(i), "|") = 0 THEN                   ' If not yet in the new | format
                  REPLACE ANY "," WITH "|" IN tlist(i)            ' Swap commas to |
               END IF                                             '
               TP.RQSplit(tlist(i), RQPath, RQMask, RQMode, RQDate)  ' Split out operands
               IF IsEQ(RQPath, oname) THEN                        ' Found it
                  '--------------------------------------------------------------------------------+
                  '- Found our rename, swap in the new name                                        |
                  '--------------------------------------------------------------------------------+
                  RQPath = nname                                  ' Swap in the new name
                  tlist(i) = BUILD$(RQPath, "|", RQMask, "|", RQMode, "|", RQDate)  '
                  Found = %True                                   ' Say to save it
               END IF                                             '
            NEXT i                                                '
            IF Found THEN                                         ' If we found it
               '-----------------------------------------------------------------------------------+
               '- Re-Write the FILELIST back out                                                   |
               '-----------------------------------------------------------------------------------+
               FNum = FREEFILE                                    ' Write the file back out
               OPEN fn FOR OUTPUT AS #FNum                        ' Open the output File
               PRINT #FNum, tlist()                               ' Dump it back out
               SETEOF #FNum                                       '
               CLOSE #FNum                                        '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      tfn = DIR$(NEXT, TO FD)                                     ' Get next FILELIST entry
   LOOP                                                           '
   OurTab = TP.PgNumber                                           ' Save our page number
   TP = gTabs(1)                                                  ' Switch to FM tab
   TP.AttnDo = TP.AttnDo OR %LoadReq                              ' Request reload any FileList
   TP = gTabs(OurTab)                                             ' Switch back to original tab
   MExit                                                          '
END SUB                                                           '

FUNCTION FileQueue(func AS STRING, pflag AS STRING, BYVAL fn AS STRING) AS STRING   '
'--------------------------------------------------------------------------------------------------+
'- Manage the FileQueue                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG                                                '
LOCAL lfull AS ASCIIZ * %MAX_PATH                                 '
LOCAL lpath AS ASCIIZ * %MAX_PATH                                 '
   MEntry                                                         '
   lfull = fn                                                     ' To fixed length string
   lpath = PATHNAME$(PATH, fn): lpath = LEFT$(lpath, LEN(TRIM$(lpath)) - 1)   '
   FUNCTION = ""                                                  '

   GOSUB CheckReset                                               ' See if table can be reset

   SELECT CASE AS CONST$ func                                     ' Split by transaction type
      CASE "A"                                                    ' Add
         FOR i = 1 TO UBOUND(gFQ())                               ' Search for an empty slot
            IF ISFALSE gFQ(i).gInUse THEN                         ' Is this available?
               gFQ(i).gWatchDir = lpath                           ' Add the entry
               gFQ(i).gWatchFile = lfull                          '
               gFQ(i).gPgNumber = TP.PgNumber                     '
               gFQ(i).gInUse = %True                              '
               gFQ(i).gFlag = " "                                 '
               MExitFunc                                          ' We're done
            END IF                                                '
         NEXT i                                                   '

      CASE "D"                                                    ' Del
         FOR i = 1 TO UBOUND(gFQ())                               ' Search for it
            IF ISTRUE gFQ(i).gInUse AND gFQ(i).gWatchFile = lfull THEN  ' Is this the one?
               gFQ(i).gInUse = %False                             ' Mark it no longer in use
               MExitFunc                                          ' We're done
            END IF                                                '
         NEXT i                                                   '

      CASE "F"                                                    ' Flag
         FOR i = 1 TO UBOUND(gFQ())                               ' Search for it
            IF ISTRUE gFQ(i).gInUse AND gFQ(i).gWatchFile = lfull THEN  ' Is this the one?
               IF gFQ(i).gflag = " " THEN                         ' Still blank?
                  gFQ(i).gflag = pflag                            ' Yes, update it
                  FUNCTION = pflag                                ' Return the flag as an OK
                  MExitFunc                                       ' We're done
               ELSE                                               ' Hmmm, already flagged?
                  MExitFunc                                       ' Exit with the default ""
               END IF                                             '
            END IF                                                '
         NEXT i                                                   '

      CASE "G"                                                    ' Get Flag
         FOR i = 1 TO UBOUND(gFQ())                               ' Search for it
            IF ISTRUE gFQ(i).gInUse AND gFQ(i).gWatchFile = lfull THEN  ' Is this the one?
               FUNCTION = gFQ(i).gflag                            ' Yes, pass back the flag
               MExitFunc                                          ' We're done
            END IF                                                '
         NEXT i                                                   '

      CASE "I"                                                    ' Search for index
         FOR i = 1 TO UBOUND(gFQ())                               ' Search for it
            IF ISTRUE gFQ(i).gInUse AND gFQ(i).gWatchFile = lfull THEN  ' Is this the one?
               FUNCTION = FORMAT$(i)                              ' Yes, pass back the index
               MExitFunc                                          ' We're done
            END IF                                                '
            FUNCTION = "0"                                        ' Return zero (fail)
         NEXT i                                                   '

      CASE "S"                                                    ' Search
         FUNCTION = "0"                                           ' Set not found return
         FOR i = 1 TO UBOUND(gFQ())                               ' Search for it
            IF ISTRUE gFQ(i).gInUse AND UUCASE(gFQ(i).gWatchFile) = UUCASE(lfull) THEN ' Is this the one?
               FUNCTION = FORMAT$(gFQ(i).gPgNumber)               ' Yes, pass back the tab numberflag
               MExitFunc                                          ' We're done
            END IF                                                '
         NEXT i                                                   '

      CASE "T"                                                    ' Adjust Tab numbers
         j = VAL(pflag)                                           ' Get deleted tab # from flag parameter
         FOR i = 1 TO UBOUND(gFQ())                               ' Search for it
            IF ISTRUE gFQ(i).gInUse AND gFQ(i).gPgNumber >= j THEN   ' In a tab higher than the deleted one?
               gFQ(i).gPgNumber = gFQ(i).gPgNumber - 1            ' Yes, reduce it's number by one
            END IF                                                '
         NEXT i                                                   '
   END SELECT                                                     '
   MExitFunc                                                      '

CheckReset:                                                       '
   FOR i = 1 TO UBOUND(gFQ())                                     ' Search for it
      IF ISTRUE gFQ(i).gInUse THEN RETURN                         ' Any active entry, just return
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- There are no active entries, we can do a reset                                               |
   '-----------------------------------------------------------------------------------------------+
   RESET gFQ()                                                    ' Clear the FQ table
   RETURN                                                         '
END FUNCTION                                                      '

FUNCTION FileRecycleBin(FilNam AS STRING, which AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Send file to the Recycle bin                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL shfo AS SHFILEOPSTRUCT                                      ' Predefined structure
LOCAL szSource AS ASCIIZ * %MAX_PATH                              '
LOCAL dummy AS LONG                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Setup the parameter list                                                                     |
   '-----------------------------------------------------------------------------------------------+
   szSource = FilNam + CHR$(0, 0)                                 ' Convert to ASCIIZ
   shfo.wFunc = %FO_DELETE                                        ' Function delete file
   shfo.pFrom = VARPTR(szSource)                                  ' Pointer to file

   '-----------------------------------------------------------------------------------------------+
   '- Set ALLOWUNDO based on gENV.UseRecycle and specific request                                  |
   '-----------------------------------------------------------------------------------------------+
   IF gENV.UseRecycle THEN                                        ' Set correct flags
      IF which = "D" THEN                                         ' Normal Delete?
         shfo.fFlags = %FOF_ALLOWUNDO OR %FOF_NOCONFIRMATION OR %FOF_NOERRORUI OR %FOF_NO_UI ' Enable undo / no confirm
      ELSE                                                        '
         shfo.fFlags = %FOF_NOCONFIRMATION OR %FOF_NOERRORUI OR %FOF_NO_UI ' Must be "K"ill, or P"U"rge
      END IF                                                      '
   ELSE                                                           '
      shfo.fFlags = %FOF_NOCONFIRMATION OR %FOF_NOERRORUI OR %FOF_NO_UI ' Enable no confirm
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Tell system to do it and return result                                                       |
   '-----------------------------------------------------------------------------------------------+
   dummy = SHFileOperation(shfo)                                  ' Call funtion
   FUNCTION = shfo.fAnyOperationsAborted                          ' Return value, either 0 or non-zero
   MExit                                                          '
END FUNCTION                                                      '

SUB FileTouch(BYVAL fName AS STRING, RCA AS RCArea)               '
'--------------------------------------------------------------------------------------------------+
'- Touch a file                                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL lclPath, lclDrive, TchDrive, TchPath, TchFn AS STRING       '
LOCAL hFile AS LONG, hfile2 AS DWORD                              '
LOCAL CreationTime, LastAccessTime, LastWriteTime AS FILETIME     '
LOCAL SystemTimeArea AS SYSTEMTIME                                '
   lclPath = CURDIR$                                              ' Get current path
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save it
   TchPath = PATHNAME$(PATH, fName)                               ' Build Path
   IF MID$(TchPath, 2, 1) = ":" THEN                              ' Extract Drive if present
      TchDrive = LEFT$(TchPath, 2)                                ' and save it
      TchPath  = MID$(TchPath, 3)                                 '
      IF ISNULL(TchPath) THEN TchPath = "\"                       ' In case we're at the root
   END IF                                                         '

   TchFn = PATHNAME$(NAMEX, fName)                                ' Get file Name
   IF VAL(FileQueue("S", " ", TchPath + "\" + TchFn)) <> 0 THEN _ ' Open in some tab?
      AnswerSub(8, "File open elsewhere")                         ' Bail out

   '-----------------------------------------------------------------------------------------------+
   '- Do the Touch                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF TchDrive <> lclDrive THEN CHDRIVE TchDrive                  '
   CHDIR TchPath                                                  '

   TRY                                                            '
      hFile = FREEFILE                                            ' Touch the file now
      OPEN TchFn FOR APPEND ACCESS READ WRITE LOCK SHARED AS #hFile  '
      hFile2 = FILEATTR(hFile,2)                                  ' Get Windows handle for the file
      GetFileTime hFile2, CreationTime, LastAccessTime, LastWriteTime   ' Fetch timestamps
      GetSystemTime SystemTimeArea                                ' Get the current time
      SystemtimeToFileTime SystemTimeArea, LastWriteTime          ' Put it in LastWriteTime
      SetFileTime hFile2, CreationTime, LastAccessTime, LastWriteTime   '
      CLOSE #hFile                                                ' Close it
      IF TchDrive <> lclDrive THEN CHDRIVE lclDrive               ' Switch drive if needed
      CHDIR lclPath                                               ' Put back the original path
      AnswerSub(0, "Touch successful")                            '
   CATCH                                                          '
      AnswerSub(8, "Touch File failed")                           '
   END TRY                                                        '
END SUB                                                           '

THREAD FUNCTION FileWatchThread(BYVAL tData AS LONG) AS LONG      ' Monitor a directory, stop when caller tells us via Event
THREADED T1pData AS WatchData POINTER, T1hSearch, T1Posted, T1i AS LONG '
THREADED T1FD         AS DIRDATA, ttxt AS STRING                  '
THREADED T1KMsg AS kbMsg                                          '
DIM WaitList(0 TO 1) AS THREADED LONG                             '
   T1pData = tData                                                ' Get address of our parameters
   @T1pData.gChanged = %False                                     ' Start off as %False
   @T1pData.gActive = %False                                      ' Start off as %False
   @T1pData.gGotStamp = %False                                    ' Say we haven't got Saved stamps yet

   WaitList(0) = @t1pData.gEvent                                  ' Copy Event address to our WaitList(0)
   WaitList(1) = FindFirstChangeNotification(@T1pData.gWatchDir, 0, _   ' Put FindFCN into WaitList(1)
                     %FILE_NOTIFY_CHANGE_FILE_NAME   OR _         '
                     %FILE_NOTIFY_CHANGE_ATTRIBUTES  OR _         '
                     %FILE_NOTIFY_CHANGE_SIZE        OR _         '
                     %FILE_NOTIFY_CHANGE_LAST_WRITE)              '
   IF WaitList(1) = %INVALID_HANDLE_VALUE THEN                    ' Should never happen, but ...
      FUNCTION = 8: EXIT FUNCTION                                 ' Tell mainline we couldn't start
   END IF                                                         '
   @T1pData.gActive = %True                                       ' Say we're active
   SLEEP 5000                                                     ' Wait 5 seconds

   '-----------------------------------------------------------------------------------------------+
   '- Get TimeStamps at OPEN time                                                                  |
   '-----------------------------------------------------------------------------------------------+
   T1hSearch = GetFileAttributesEx(@T1pData.gWatchFile, &H0, BYREF T1FD)   ' Search for the filename
   IF T1hSearch = 0 THEN                                          ' No file, error
      FUNCTION = 8: EXIT FUNCTION                                 ' Tell mainline we couldn't start
   END IF                                                         '
   @T1pData.gFileAttrib = T1FD.FileAttributes                     ' Save Status data
   @T1pData.gFileLWTime = T1FD.LastWriteTime                      '
   @T1pData.gFileCRTime = T1FD.CreationTime                       '
   @T1pData.gFileSizeHigh = T1FD.FileSizeHigh                     '
   @T1pData.gFileSizeLow = T1FD.FileSizeLow                       '
   @T1pData.gGotStamp = %True                                     ' Say we haven't got Saved stamps yet
'- debug "Start FileName       = " + @T1pData.gWatchFile
'- debug "Start FileLWTime     = " + FORMAT$(T1FD.LastWriteTime)
'- debug "Start FileSizeLow    = " + FORMAT$(T1FD.FileSizeLow)
'- debug "Start GotStamp=" + FORMAT$(@T1pData.gGotStamp)

   DO                                                             '
      T1Posted = WaitForMultipleObjects(2, WaitList(0), 0, %INFINITE)   ' Sleep till Windows Posts us
      SELECT CASE T1Posted                                        ' See who Posted us
         CASE %WAIT_OBJECT_0                                      ' Being told to stop by the MainLine?
            CloseHandle(WaitList(0))                              ' Close the Event handle
            FindCloseChangeNotification(WaitList(1))              ' Close the notification object
            EXIT LOOP                                             ' Fall out the bottom

         CASE %WAIT_OBJECT_0 + 1                                  ' Is this the FxCN?
            SLEEP 2000                                            ' Wait 2 secs for Windows multiple timestamps to be done
            IF ISTRUE @T1pData.gGotStamp THEN GOSUB CheckFileDates   ' See if our file's status has changed
            IF ISFALSE FindNextChangeNotification(WaitList(1)) THEN  ' Tell FNCN to keep looking
               FUNCTION = 8: @T1pData.gActive = %False: EXIT FUNCTION   ' Some kind of error, bail out to mainline
            END IF                                                '

         CASE ELSE                                                ' Anything else should not happen
            FUNCTION = 8: @T1pData.gActive = %False: EXIT FUNCTION   ' Some kind of error, bail out to mainline
      END SELECT                                                  '

      SLEEP 1

   LOOP                                                           '
   FUNCTION = 0                                                   '
   EXIT FUNCTION                                                  '

CheckFileDates:                                                   '
   T1hSearch = GetFileAttributesEx(@T1pData.gWatchFile, &H0, BYREF T1FD)   ' Search for the filename
   IF T1hSearch = 0 THEN                                          ' No file, error
      @T1pData.gChanged = 1                                       ' Say file has been deleted
      GOSUB NotifyMainLine                                        ' Send back a message
   ELSE                                                           ' Else file still exists
'- debug "Check FileName       = " + @T1pData.gWatchFile
'- debug "Check FileLWTime     = " + FORMAT$(T1FD.LastWriteTime)
'- debug "Check FileSizeLow    = " + FORMAT$(T1FD.FileSizeLow)
      IF @T1pData.gFileLWTime <> T1FD.LastWriteTime OR _          ' See if anything has changed
         @T1pData.gFileCRTime <> T1FD.CreationTime OR _           '
         @T1pData.gFileSizeHigh <> T1FD.FileSizeHigh OR _         '
         @T1pData.gFileSizeLow <> T1FD.FileSizeLow OR _           '
         @T1pData.gFileAttrib <> T1FD.FileAttributes THEN         '
         @T1pData.gChanged = -1                                   ' Say data has changed
         @T1pData.gFileLWTime = T1FD.LastWriteTime                ' Save for the next time
         @T1pData.gFileCRTime = T1FD.CreationTime                 '
         @T1pData.gFileSizeHigh = T1FD.FileSizeHigh               '
         @T1pData.gFileSizeLow = T1FD.FileSizeLow                 '
         @T1pData.gFileAttrib = T1FD.FileAttributes               '
         GOSUB NotifyMainLine                                     ' Send back a message
      END IF                                                      '
   END IF                                                         '
   RETURN                                                         '

NotifyMainLine:                                                   '
   MID$(T1KMsg.kbString, 1, 1) = CHR$(2)                          ' Flag 1st byte as Hex 2
   MID$(T1KMsg.kbString, 2, 1) = IIF$(@T1pData.gChanged = 1, "D", "M")  ' Flag 2nd byte as "D" or "M"
   t1KMsg.kbInt(1) = @t1pData.gPgNumber                           ' Copy Tab # to be notified
   ttxt = TRIM$(@T1pData.gWatchFile)                              ' Convert to normal string
   IF FileQueue("F", IIF$(@T1pData.gChanged = 1, "D", "M"), ttxt) = "" THEN RETURN  ' Set flag in FQ area, exit if already posted
   t1i = PostMessage(ghWnd, %WM_USER, t1KMsg.MsgwParam, 0)        ' To the mainline Callback routine
   RETURN                                                         '

END FUNCTION                                                      '

THREAD FUNCTION FileWatchSubmitThread(BYVAL rfile AS LONG) AS LONG   ' Monitor a directory, stop when file disappears
'--------------------------------------------------------------------------------------------------+
'- Watch a SUBMIT result file                                                                      |
'--------------------------------------------------------------------------------------------------+
THREADED Posted, i, FNm AS LONG                                   '
THREADED tfd AS DIRDATA                                           '
THREADED Fn, passfile, FL1, FL2, FL3, t AS STRING                 '
THREADED sfiletime, sfilesize AS QUAD                             '
THREADED watchdir AS ASCIIZ * %MAX_PATH                           '
THREADED WaitEvent AS LONG                                        '
THREADED fptr AS STRING POINTER                                   '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Use the file's data to establish a Watch event                                               |
   '-----------------------------------------------------------------------------------------------+
   fptr = rfile                                                   ' Get file parameter
   passfile = gResultFile                                         '
   fn = DIR$(passfile, TO tfd)                                    ' Get current file info
   IF ISNULL(fn) THEN FUNCTION = 8: MExitFunc                     ' Whoops! Should never happen
   sfiletime = tfd.LastWriteTime                                  ' Save original file timestamp
   sfilesize = MAK(QUAD, tFD.FileSizeLow , tFD.FileSizeHigh)      ' Save original file size
   watchdir = LEFT$(passfile, INSTR(-1, passfile, "\") - 1)       ' Extract the Dir path
   WaitEvent = FindFirstChangeNotification(watchDir, 0, _         ' Put FindFCN into WaitEvent
               %FILE_NOTIFY_CHANGE_FILE_NAME   OR _               '
               %FILE_NOTIFY_CHANGE_ATTRIBUTES  OR _               '
               %FILE_NOTIFY_CHANGE_SIZE        OR _               '
               %FILE_NOTIFY_CHANGE_LAST_WRITE)                    '
   IF WaitEvent = %INVALID_HANDLE_VALUE THEN _                    ' Should never happen, but ...
      FUNCTION = 8: MExitFunc                                     ' Tell mainline we couldn't start

   SLEEP 3000                                                     ' Let things settle down
   '-----------------------------------------------------------------------------------------------+
   '- Go to sleep now until something happens                                                      |
   '-----------------------------------------------------------------------------------------------+
   DO                                                             '
      Posted = WaitForSingleObject(WaitEvent, %INFINITE)          ' Sleep till Windows Posts us
      SLEEP 100                                                   ' Wait 100 ms for Windows multiple timestamps to be done

      '--------------------------------------------------------------------------------------------+
      '- Go see if we care about this, else  again                                            |
      '--------------------------------------------------------------------------------------------+
      GOSUB CheckFileDate                                         ' See if our file's status has changed
      IF ISFALSE FindNextChangeNotification(WaitEvent) THEN _     ' Tell FNCN to keep looking
         FUNCTION = 8: MExitFunc                                  ' Some kind of error, bail out to mainline
   LOOP                                                           '
   FUNCTION = 0                                                   '
   MExitFunc                                                      '

'--------------------------------------------------------------------------------------------------+
'- See if we should wake up the user                                                               |
'--------------------------------------------------------------------------------------------------+
CheckFileDate:                                                    '
   fn = DIR$(passfile, TO tfd)                                    ' Get current file info

   '-----------------------------------------------------------------------------------------------+
   '- If file's been deleted, just shut down                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(fn) THEN                                             ' No file?
      FUNCTION = 0: MExitFunc                                     ' Just terminate
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- If file timestamp has changed, if so, tell user                                              |
   '-----------------------------------------------------------------------------------------------+
   IF sfiletime <> tFD.LastWriteTime OR _                         ' See if file has changed
      sfilesize <> MAK(QUAD, tFD.FileSizeLow , tFD.FileSizeHigh) THEN   ' or size
      sfiletime = tFD.LastWriteTime                               ' Save for the next time
      sfilesize = MAK(QUAD, tFD.FileSizeLow , tFD.FileSizeHigh)   '

      '--------------------------------------------------------------------------------------------+
      '- Show user up to the first three lines of the file                                         |
      '--------------------------------------------------------------------------------------------+
      Fnm = FREEFILE                                              ' Get a file number
      OPEN gENV.SubmitDir + "\" + fn FOR INPUT ACCESS READ LOCK SHARED AS #FNm   ' Open the Result file
      FILESCAN #FNm, RECORDS TO i                                 ' Get the number of records
      IF i > 0 THEN LINE INPUT #FNm, FL1                          ' Some records?
      IF i > 1 THEN LINE INPUT #FNm, FL2                          '
      IF i > 2 THEN LINE INPUT #FNm, FL3                          '
      CLOSE #FNm                                                  ' Close it
      t = MID$(fn, LEN(fn) - 11, 8)                               ' extract the Jobnnnnn
      DoMessageBox FL1 + $CRLF + FL2 + $CRLF + FL3, %MB_OK OR %MB_USERICON, t '
   END IF                                                         '
   RETURN                                                         '

END FUNCTION                                                      '

SUB      FMNestBack()                                             '
'--------------------------------------------------------------------------------------------------+
'- Restore an FM Ckpt Backward                                                                     |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF gFMNestCtr = 1 THEN MExitSub                                ' Oops! Do nothing
   DECR gFMNestCtr                                                ' Reduce by 1
   TP.FPath       = PARSE$(gFMNestTbl(gFMNestCtr), "|", 1)        ' Restore the key values
   TP.FMask       = PARSE$(gFMNestTbl(gFMNestCtr), "|", 2)        '
   TP.FileListNm  = PARSE$(gFMNestTbl(gFMNestCtr), "|", 3)        '
   gFMNestTopScrn = VAL(PARSE$(gFMNestTbl(gFMNestCtr), "|", 4))   '
   TPDoSet(%LoadReq)                                              ' Trigger initial Req and Data load
   TPDoSet(%Attention)                                            ' Get it looked at
   MExit                                                          '
END SUB                                                           '

SUB      FMNestCkpt()                                             '
'--------------------------------------------------------------------------------------------------+
'- Create Ckpt of the current state                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL NewState AS STRING                                          '
'--------------------------------------------------------------------------------------------------+
'- Note Max Nest table is currently 25                                                             |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   NewState = TP.FPath + "|" + TP.FMask + "|" + TP.FileListNm + "|" + FORMAT$(TP.GPTopLine)   '
   IF gFMNestCtr > 0 THEN                                         ' If Nest has started
      IF NewState = gFMNestTbl(gFMNestCtr) THEN MExitSub          ' If no change, leave quickly
   END IF                                                         '
   INCR gFMNestCtr                                                ' Incr Nest count
   IF gFMNestCtr > 25 THEN                                        ' Table full?
      ARRAY DELETE gFMNestTbl(1): DECR gFMNestCtr                 ' Delete the oldest, adjust gFMNestCtr
   END IF                                                         '
   gFMNestHigh = MAX(gFMNestCtr, gFMNestHigh)                     ' Set as new High if higher
   gFMNestTbl(gFMNestCtr) = NewState                              ' Save the key values
   MExit                                                          '
END SUB                                                           '

SUB      FMNestFwd()                                              '
'--------------------------------------------------------------------------------------------------+
'- Restore an FM Ckpt Foreward                                                                     |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF gFMNestCtr = gFMNestHigh THEN MExitSub                      ' Oops! Do nothing
   INCR gFMNestCtr                                                ' Bump by 1
   TP.FPath       = PARSE$(gFMNestTbl(gFMNestCtr), "|", 1)        ' Restore the key values
   TP.FMask       = PARSE$(gFMNestTbl(gFMNestCtr), "|", 2)        '
   TP.FileListNm  = PARSE$(gFMNestTbl(gFMNestCtr), "|", 3)        '
   gFMNestTopScrn = VAL(PARSE$(gFMNestTbl(gFMNestCtr), "|", 4))   '
   TPDoSet(%LoadReq)                                              ' Trigger initial Req and Data load
   TPDoSet(%Attention)                                            ' Get it looked at
   MExit                                                          '
END SUB                                                           '

FUNCTION FMSortFlag(P1Flag AS STRING, P2Flag AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Handle the Dir sorting fudge                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL P1, P2 AS LONG                                              '
   P1 = VAL(P1Flag): P2 = VAL(P2Flag)                             ' Get flags into LONG
   IF TP.DirSort = "Dir+" THEN                                    ' Old style?
      IF P1 < P2 THEN FUNCTION = -1: EXIT FUNCTION                ' Do old style compare
      IF P1 > P2 THEN FUNCTION = +1: EXIT FUNCTION                '

   ELSEIF TP.DirSort = "Dir-" THEN                                ' If put Dirs last?
      IF P1 = %FDirDown THEN P1 = %FDirLow                        ' Swap to bottom keys
      IF P2 = %FDirDown THEN P2 = %FDirLow                        '
      IF P1 < P2 THEN FUNCTION = -1: EXIT FUNCTION                ' Do old style compare
      IF P1 > P2 THEN FUNCTION = +1: EXIT FUNCTION                '

   ELSE                                                           ' Else in-line
      IF P1 = %FDirUp THEN FUNCTION = -1: EXIT FUNCTION           ' Force Dir up to the top
      IF P1 = %FDirDown AND P2 >= %FEntry AND P2 <= %FConfig OR _ '
         P2 = %FDirDown AND P1 >= %FEntry AND P1 <= %FConfig THEN '
         '- Treat as equal
      ELSE                                                        '
         IF P1 < P2 THEN FUNCTION = -1: EXIT FUNCTION             ' Do old style compare
         IF P1 > P2 THEN FUNCTION = +1: EXIT FUNCTION             '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION FMSortUp(p1 AS WSTRINGZ * 512, p2 AS WSTRINGZ * 512) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Support sort of the FMFiles array                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL P1Flag, P2Flag AS STRING, FTest AS LONG                     '
   P1Flag = LEFT$(p1, 4): P2Flag = LEFT$(p2, 4)                   ' Get a working copy of flags
   FTest = FMSortFlag(P1Flag, P2Flag)                             ' Do test in common code
   IF FTest <> 0 THEN FUNCTION = FTest:EXIT FUNCTION              ' If < or > result, pass it back
   FTest = gENV.FMSortSimple                                      '
   IF gENV.FMSortSimple = 0 THEN                                  ' Which Sort method
      FUNCTION = StrCmpLogicalW(UCASE$(MID$(p1, 5)), UCASE$(MID$(p2, 5)))  ' MS Logical
      EXIT FUNCTION                                               '
   END IF                                                         '
   IF UCASE$(MID$(p1, 5)) > UCASE$(MID$(p2, 5)) THEN FUNCTION = +1: EXIT FUNCTION   '
   IF UCASE$(MID$(p1, 5)) < UCASE$(MID$(p2, 5)) THEN FUNCTION = -1: EXIT FUNCTION   '
END FUNCTION                                                      '

FUNCTION FMSortDown(p1 AS WSTRINGZ * 512, p2 AS WSTRINGZ * 512) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Support sort of the FMFiles array                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL P1Flag, P2Flag AS STRING, FTest AS LONG                     '
   P1Flag = LEFT$(p1, 4): P2Flag = LEFT$(p2, 4)                   ' Get a working copy of flags
   FTest = FMSortFlag(P1Flag, P2Flag)                             ' Do test in common code
   IF FTest <> 0 THEN FUNCTION = FTest:EXIT FUNCTION              ' If < or > result, pass it back
   FTest = gENV.FMSortSimple                                      '
   IF gENV.FMSortSimple = 0 THEN                                  ' Which Sort method
      FUNCTION = StrCmpLogicalW(UCASE$(MID$(p2, 5)), UCASE$(MID$(p1, 5)))  ' MS Logical
      EXIT FUNCTION                                               '
   END IF                                                         '
   IF UCASE$(MID$(p2, 5)) > UCASE$(MID$(p1, 5)) THEN FUNCTION = +1: EXIT FUNCTION   '
   IF UCASE$(MID$(p2, 5)) < UCASE$(MID$(p1, 5)) THEN FUNCTION = -1: EXIT FUNCTION   '
END FUNCTION                                                      '

SUB FontAdjustSizes()                                             '
'--------------------------------------------------------------------------------------------------+
'- Adjust fonts if high DPI used                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL hDC, LPIy AS DWORD, factor, SBFac, SBFont AS SINGLE         '
   hDC = GetDC(%HWND_DESKTOP)                                     ' Get Desktop handle
   LPIy = GetDeviceCaps(hDC, %LOGPIXELSY)                         ' Get pixels / inch vertically
   ReleaseDC %HWND_DESKTOP, hDC                                   ' Free hDC
   factor = (LPiY/96) * 100                                       ' Calc % font size
   gFontScale = factor / 100                                      ' Create a factor out of it
   SBFac = gENV.SBFactor                                          ' Cals SB/Tab Title font size
   SBFont = (12 * SBFac) / gFontScale                             '
   '-----------------------------------------------------------------------------------------------+
   '- Recreate the Fonts                                          |                                |
   '-----------------------------------------------------------------------------------------------+
   FONT NEW "Arial",       10 / gFontScale, 1, 1, 1 TO gBoldFont  ' Build font for our Preferences Dialog
   FONT NEW "Courier New", 10 / gFontScale, 1, 1, 1 TO gFixedFont ' Build font for our Preferences Dialog
   FONT NEW "Tahoma",      SBFont, 0, 1, 1 TO gSBFont             ' Build font for the Status Bar
   FONT NEW "Tahoma",      SBFont, 1, 1, 1 TO gSBFontB            ' Build font for the Status Bar Bold
   FONT NEW "Tahoma",      12 / gFontScale, 0, 1, 1 TO gHlpFont   ' Build font for the Help Dialog
   FONT NEW "Tahoma",      12 / gFontScale, 1, 1, 1 TO gHlpFontB  ' Build font for the Help Dialog
END SUB                                                           '

FUNCTION FontGetValidChars(lDC AS DWORD) AS STRING                '
'--------------------------------------------------------------------------------------------------+
'- Get list of valid characters in the current Font                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG                                             '
LOCAL AllChars, ValidChars AS STRING, StdWidth, StdHeight AS LONG '
DIM GlyphIX(0 TO 255) AS WORD                                     '
   GRAPHIC TEXT SIZE "0" TO StdWidth, StdHeight                   '
   AllChars = CHR$(0 TO 255)                                      ' Make list of all 256 characters
   GetGlyphIndices(lDC, BYVAL STRPTR(AllChars), 256, BYVAL VARPTR(GlyphIX(0)), %GGI_MARK_NONEXISTING_GLYPHS)   '
   FOR i = 0 TO 255                                               ' See which ones are valid
      IF GlyphIX(i) <> &HFFFF?? THEN                              ' We have a glyph
         GRAPHIC TEXT SIZE CHR$(i) TO j, k                        ' Get it's width
         IF j = StdWidth THEN                                     ' If it matches the standard
            ValidChars += CHR$(i)                                 ' Add to the valid chars string
         END IF                                                   '
      END IF                                                      '
   NEXT i                                                         '
   FUNCTION = ValidChars                                          ' Return the answer
END FUNCTION                                                      '

SUB ForceVisibleDisplay (BYVAL hwnd AS DWORD)                     '
'--------------------------------------------------------------------------------------------------+
'- Check if the specified window-recrangle is visible on any display                               |
'--------------------------------------------------------------------------------------------------+
LOCAL rc AS RECT                                                  '
LOCAL hMonitor AS DWORD                                           '
LOCAL mi AS MONITORINFO                                           '
   GetWindowRect(hwnd, rc)                                        ' Get current pos
   IF MonitorFromRect(rc, %MONITOR_DEFAULTTONULL) <> %Null THEN EXIT SUB   '

   mi.cbSize = SIZEOF(mi)                                         ' Find the nearest display to the rectangle
   hMonitor = MonitorFromRect(rc, %MONITOR_DEFAULTTONEAREST)      '
   GetMonitorInfo(hMonitor, mi)                                   '

   '-----------------------------------------------------------------------------------------------+
   '- Center window rectangle                                                                      |
   '-----------------------------------------------------------------------------------------------+
   rc.left = mi.rcWork.left + ((mi.rcWork.right - mi.rcWork.left) - (rc.right-rc.left)) \ 2  '
   rc.top = mi.rcWork.top + ((mi.rcWork.bottom - mi.rcWork.top) - (rc.bottom-rc.top)) \ 2 '
   SetWindowPos(hwnd, 0, rc.left, rc.top, 0, 0, %SWP_NOZORDER OR %SWP_NOSIZE OR %SWP_NOACTIVATE)   '
END SUB                                                           '

SUB EFTAdd(Prof1 AS STRING, Prof2 AS STRING, Oper AS STRING)      '
'--------------------------------------------------------------------------------------------------+
'- Add a simple EFT entry                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG, OperFull, OperMask, OperProf1, OperProf2 AS STRING  '
   MEntry                                                         '
   OperProf1 = uucase(Prof1): OperProf2 = uucase(Prof2)           ' Uppercase the args
   FOR i = 1 TO gEFTRawCtr                                        ' Spin though the Raw table
      OperFull = UUCASE(TRIM$(gEFTRaw(i)))                        ' Get raw string
      j = INSTR(OperFull, " "): k = INSTR(OperFull, "=")          ' Get the first delimiter
      j = MIN(j, k)                                               ' Use the shortest
      OperMask = LEFT$(OperFull, i)                               ' Extract the mask
      IF OperMask = OperProf1 _                                   ' Match?
      OR OperMask = "." + OperProf1 THEN                          ' or Match with period?
         ARRAY DELETE gEFTRaw(i): DECR gEFTRawCtr                 ' Found it, delete it
         EFTRawLoad()                                             ' Rebuild working table
         EXIT FOR                                                 ' We're done
      END IF                                                      '
   NEXT i                                                         '
   INCR gEFTRawCtr                                                ' Now add the new entry
   IF gEFTRawCtr > UBOUND(gEFTRaw()) THEN                         ' Keep table big enough
      REDIM PRESERVE gEFTRaw(1 TO 2 * gEFTRawCtr) AS GLOBAL STRING   '
   END IF                                                         '
   gEFTRaw(gEFTRawCtr) = "." + OperProf1 + " = " + OperProf2 + IIF$(ISNULL(oper), "", "," + oper)  '
   EFTRawLoad()                                                   ' Rebuild working table
   MExit                                                          '
END SUB                                                           '

SUB EFTRawLoad()                                                  '
'--------------------------------------------------------------------------------------------------+
'- Process EFTRaw into final tables                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, RC, MaskType, lclPCRE AS LONG, OperFull, OperMask, OperProf, OperOper, PDiag AS STRING, txtP AS ASCIIZ PTR  '
   MEntry                                                         '
   REDIM PRESERVE gEFTRaw(1 TO gEFTRawCtr) AS GLOBAL STRING       ' Truncate the raw table


   '-----------------------------------------------------------------------------------------------+
   '- Clean up any prior EFT PCRE compile areas                                                    |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gEFTCtr                                           ' Spin through existing table
      IF gEFT(i).PCRE <> 0 THEN                                   ' A PCRE handle?
         TRY                                                      ' Lets not crash
            FREE gEFT(i).PCRE                                     ' Free it one way
         CATCH                                                    ' Oops, try the other way
            CALL DWORD gPCRE_hProc_Free_Ptr USING pcre_free(gEFT(i).PCRE)  ' Free it
         FINALLY                                                  '
            gEFT(i).PCRE = 0                                      ' Regardless, zero the pointer
         END TRY                                                  '
      END IF                                                      '
   NEXT i                                                         '
   gEFTCtr = 0                                                    ' Reset now after cleanup

   FOR i = 1 TO gEFTRawCtr                                        ' Split it apart
      OperFull = UUCASE(TRIM$(gEFTRaw(i)))                        ' Get raw string
      IF ISNULL(TRIM$(OperFull)) THEN ITERATE FOR                 ' Ignore blank lines
      j = INSTR(OperFull, ";")                                    ' Comment?
      IF j THEN OperFull = TRIM$(LEFT$(OperFull, j - 1))          ' Strip it off
      IF ISNULL(OperFull) THEN ITERATE FOR                        ' Nothing left, ignore it

      MaskType = 0                                                ' Start as simple non-quoted mask
      IF LEFT$(OperFull, 1) = $DQ THEN MaskType = 1               ' Its a simple quoted mask
      IF LEFT$(OperFull, 2) = "R'" OR _                           ' Look like a RegEx?
         LEFT$(OperFull, 2) = "R`" OR _                           '
         LEFT$(OperFull, 2) = "R" + $DQ THEN MaskType = 2         ' It's a REGEX
      '--------------------------------------------------------------------------------------------+
      '- Remove Mask quotes if needed, then find the =                                             |
      '--------------------------------------------------------------------------------------------+
      j = 1                                                       ' For normal unquoted masks
      IF MaskType <> 0 THEN                                       ' Mask is quoted?
         j = INSTR(MaskType + 1, OperFull, MID$(OperFull, MaskType, 1)) ' Look for trailing equal quote mark
      END IF                                                      '
      j = INSTR(j + 1, OperFull, "=")                             ' Finally, look for the = sign

      OperMask = TRIM$(LEFT$(OperFull, j - 1))                    ' Get Mask value
      IF Masktype = 1 THEN OperMask = MID$(OperMask, 2, LEN(OperMask) - 2) ' Remove extraneous quotes
      IF Masktype = 2 THEN OperMask = MID$(OperMask, 3, LEN(OperMask) - 3) '
      OperProf = TRIM$(MID$(OperFull, j + 1))                     ' Get Prof value
      OperOper = ""                                               ' Null in case no operand
      j = INSTR(OperProf, ",")                                    ' See if optional operands
      IF j THEN OperOper = TRIM$(MID$(OperProf, j + 1))           ' Capture the optional operands
      IF j THEN OperProf = TRIM$(LEFT$(OperProf, j - 1))          ' Strip them off
      IF MaskType < 2 THEN                                        ' Prep the Mask (Types 0 and 1)
         RC = EFT_Translate(OperMask, OperMask, PDiag)            ' Convert to Regex
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Save it now and do PCRE Compile                                                           |
      '--------------------------------------------------------------------------------------------+
      INCR gEFTCtr                                                ' Count it
      IF gEFTCtr > UBOUND(gEFT()) THEN                            ' Keep table big enough
         REDIM PRESERVE gEFT(1 TO 2 * gEFTCtr) AS GLOBAL EFTData  '
      END IF                                                      '

      gEFT(gEFTCtr).Mask = OperMask                               ' Save Mask
      gEFT(gEFTCtr).Prof = OperProf                               ' Save Prof
      gEFT(gEFTCtr).Oper = OperOper                               ' Save Operands
      gEFT(gEFTCtr).RawIX = i                                     ' Save Raw table index
      gPCRE_Options = %PCRE_CASELESS                              ' Set Options
      gPCRE_Regex_Str2 = OperMask + CHR$(0)                       ' Make into pseudo ASCIIZ
      CALL DWORD gPCRE_hProc_Compile USING pcre_compile( _        ' Try the compile
              BYVAL STRPTR(gPCRE_Regex_Str2), _                   ' Regex string
              BYVAL gPCRE_Options,           _                    ' Options
              BYVAL VARPTR(gPCRE_ErrPtr),    _                    ' Pointer to error string
              BYVAL VARPTR(gPCRE_ErrOffsetPtr),_                  ' Error offset
              BYVAL &0) _                                         ' Character tables
              TO lclPCRE                                          ' Answer area
      IF lclPCRE = 0 THEN                                         ' OK?
         txtp = gPCRE_ErrPtr                                      ' No, get error message
         PDiag = "at Col: " + FORMAT$(gPCRE_ErrOffsetPtr + 1) + " : " + @Txtp '
         MSGBOX PDiag                                             '
      END IF                                                      '
      gEFT(gEFTCtr).PCRE = lclPCRE                                ' Save compiled area
   NEXT i                                                         '
   SQLArraySave(gSQL.EFTName, gEFTRaw())                          ' Save the result
   MExit                                                          '
END SUB                                                           '

SUB EFTRemove(Prof AS STRING)                                     '
'--------------------------------------------------------------------------------------------------+
'- Remove a simple Profile entry from the EFT table                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG, OperFull, OperMask, OperProf AS STRING     '
   MEntry                                                         '
   OperProf = UCASE$(Prof)                                        ' Uppercase the arg
   FOR i = 1 TO gEFTRawCtr                                        ' Spin though the Raw table
      OperFull = UUCASE(TRIM$(gEFTRaw(i)))                        ' Get raw string
      j = INSTR(OperFull, " "): k = INSTR(OperFull, "=")          ' Get the first delimiter
      j = MIN(j, k)                                               ' Use the shortest
      OperMask = LEFT$(OperFull, j - 1)                           ' Extract the mask
      IF UCASE$(OperMask) = OperProf _                            ' Match?
      OR UCASE$(OperMask) = "." + OperProf THEN                   ' or Match with period?
         ARRAY DELETE gEFTRaw(i): DECR gEFTRawCtr                 ' Found it, delete it
         EFTRawLoad()                                             ' Rebuild working table
         EXIT FOR                                                 ' We're done
      END IF                                                      '
   NEXT i                                                         '
   MExit                                                          '
END SUB                                                           '

FUNCTION EFT_Translate ( _                                        '
   BYVAL eft_patt_arg         AS STRING, _                        ' supplied EFT File Pattern string
   BYREF reg_patt_arg         AS STRING, _                        ' returned REGEX File Pattern string
   BYREF diag_arg             AS STRING) AS LONG                  ' returned diagnostic message in case of error

'--------------------------------------------------------------------------------------------------+
'- Translate an EFT Pattern into a RegEx Pattern, if possible                                      |
'-                                                                                                 |
'-    If successful,     rc = true   and  REG_patt_arg = RegEx pattern  plus  diag_arg = ""        |
'-    If not successful, rc = false  and  REG_patt_arg = ""             plus  diag_arg = error msg |
'--------------------------------------------------------------------------------------------------+

LOCAL n                       AS LONG                             ' general index
LOCAL c                       AS STRING                           ' general char value
LOCAL eft_patt_str            AS STRING                           '

LOCAL reg_patt_str            AS STRING                           '
LOCAL eft_prefix              AS STRING                           ' string prepended to user's EFT pattern
LOCAL eft_left_1              AS STRING                           ' work area for initial char
LOCAL eft_left_2              AS STRING                           ' work area for initial char
LOCAL eft_left_23             AS STRING                           ' work area for initial char
LOCAL eft_left_3              AS STRING                           ' work area to see if pattern has drive letter
LOCAL eft_right_1             AS STRING                           ' work area for finall char


   MEntry                                                         ' begin function

   FUNCTION = %False                                              '

   '-----------------------------------------------------------------------------------------------+
   '- local and parameter initialization                                                           |
   '-----------------------------------------------------------------------------------------------+

   reg_patt_arg = ""                                              ' default value of RegEx result if error
   reg_patt_str = ""                                              ' RegEx build area
   diag_arg = ""                                                  ' assume no errors
   eft_prefix = ""                                                '

   eft_patt_str = UCASE$(eft_patt_arg)                            ' local copy of arg
   REPLACE ANY "/" WITH "\" IN eft_patt_str                       ' Unix compatibility

   eft_left_1 = LEFT$ (eft_patt_str, 1)                           '
   eft_left_2 = LEFT$ (eft_patt_str, 2)                           '
   eft_left_3 = LEFT$ (eft_patt_str, 3)                           '
   eft_left_23 = MID$ (eft_patt_str, 2,3)                         '

   eft_right_1 = RIGHT$(eft_patt_str, 1)                          '

   IF eft_patt_str = "" THEN                                      '
      diag_arg = "EFT Pattern is null"                            '
      MExitFunc                                                   '

   ELSEIF INSTR(eft_patt_str, ANY "<>|" + $DQ + $NUL + CHR$(&H00 TO &H1F)) > 0      _  ' illegal characters
   OR     INSTR(eft_left_1,   ANY " ")    > 0 _                   ' leading blank
   OR     INSTR(eft_right_1,  ANY " .\:") > 0 THEN                ' illegal characters
      diag_arg = "EFT Pattern has illegal characters"             '
      MExitFunc                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Determine which file-name format is present in the Pattern                                   |
   '-   This is needed to choose which "use case" we are dealing with                              |
   '-----------------------------------------------------------------------------------------------+

   IF eft_left_2 = "\\" THEN                                      ' network name
      eft_prefix = ""                                             ' nothing else needed

   ELSEIF eft_left_23 = ":\" THEN                                 ' regular or symbolic drive
      IF  eft_left_1 >= "A" _                                     '
      AND eft_left_1 <= "Z" THEN                                  '
         eft_prefix = ""                                          ' nothing else needed

      ELSEIF eft_left_1 = "*" _                                   ' symbolic drive letter
      OR     eft_left_1 = "?" THEN                                ' symbolic drive letter
         reg_patt_str = "[A-Z]"                                   ' translate symbolic drive letter into regex
         eft_patt_str = MID$(eft_patt_str, 2)                     ' chop off the symbolic drive letter, leave :\

      END IF                                                      '

   ELSEIF eft_left_1 = "." THEN                                   ' pattern begins with a dot on left like .EXT
      eft_prefix = "**\*"                                         ' new EFT is "**\*.EXT"

   ELSEIF eft_left_2 = ":\" THEN                                  ' location-independent pattern
      reg_patt_str = "(([A-Z]\:)|(\\\\[^\\]+\\[^\\]+))"           ' matches \\server\share or C:\ where C is a letter
      eft_patt_str = MID$(eft_patt_str, 2)                        ' chop off the leading colon, leave \

   ELSEIF eft_left_1 =  "\" THEN                                  ' pattern like \name.ext or \path\name.ext
                                                                  ' and is not a network name
      eft_prefix = "**"                                           ' allow anything prior to leading \

   ELSEIF eft_left_1 <> "." THEN                                  ' no leading dots
      eft_prefix = "**\*"                                         ' new EFT is "**\*EXT"

   ELSEIF eft_left_2  <> "\\" _                                   ' not a network name
   AND    eft_left_23 <> ":\" THEN                                ' not a conventional C:\ drive letter
      diag_arg = "EFT Pattern not recognized"                     '
      MExitFunc                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Prepend any EFT prefix, then scan the EFT pattern                                            |
                                                                  '|    The regex prefix is already in RegEx format and does NOT get scanned                      |
   '-----------------------------------------------------------------------------------------------+

   eft_patt_str = eft_prefix + eft_patt_str                       '

   '-----------------------------------------------------------------------------------------------+
   '- begin scan of adjusted EFT pattern                                                           |
   '-----------------------------------------------------------------------------------------------+

   n = 0                                                          '
   DO                                                             '
      n += 1                                                      '
      IF n > LEN(eft_patt_str) THEN EXIT DO                       '
      c = MID$(eft_patt_str, n, 1)                                ' curr patt char

      IF  c = "*" _                                               ' see if * is beginning of ** token
      AND n < LEN(eft_patt_str)  _                                ' is there any room for ** to exist?
      AND MID$(eft_patt_str, n+1, 1) = "*" THEN                   ' ** was found
         c = "**"                                                 ' capture ** token as one string value
         n += 1                                                   ' skip over second *
      END IF                                                      '

      SELECT CASE c                                               '

         CASE "**"                                                '
            reg_patt_str += "(.*)"                                ' zero or more characters including \

         CASE "*"                                                 '
            reg_patt_str += "[^\\]*"                              ' zero or more characters except \

         CASE $FF                                                 ' a * code that is in an unusual context
            reg_patt_str += "[^\\]+"                              ' ONE or more characters except \

         CASE "?"                                                 '
            reg_patt_str += "[^\\]"                               ' any single character except \

         CASE "\",  "+",  "[",  "]",  ".",  "$",  "^",  "(",  ")" '
            reg_patt_str += "\" + c                               ' these chars require regex escape to work

         CASE ELSE                                                ' all other chars
            reg_patt_str += c                                     ' represent themselves, nothing else needed

      END SELECT                                                  '
   LOOP                                                           '

   reg_patt_arg = "^" + reg_patt_str + "$"                        ' return translated regex expression

   FUNCTION = %True                                               ' translation is successful

   MExit                                                          '

END FUNCTION                                                      '

FUNCTION GetAutoFavName(Fn AS STRING) AS STRING                   '
'--------------------------------------------------------------------------------------------------+
'- See if filename matches an AUTOFAV mask                                                         |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL Masks() AS ASCIIZ * 50, NumMask AS LONG                     '
LOCAL FavNames() AS STRING, MPtr, FPtr, TPtr AS BYTE POINTER      '
LOCAL FName AS ASCIIZ * %MAX_PATH, tmask AS ASCIIZ * 50           '
DIM Masks(1 TO 50) AS ASCIIZ * 50                                 '
DIM FavNames(1 TO 50) AS STRING                                   '
   MEntry                                                         '
   IF gSetCount > 0 THEN                                          ' Scan SET table
      FOR i = 1 TO gSetCount                                      '
         IF IsEQ(LEFT$(gSetKey(i), 8), "AUTOFAV.") THEN           ' is this an AUTOFAV. entry?
            INCR NumMask                                          ' We have one
            IF NumMask > UBOUND(Masks()) THEN                     ' Table exceeded
               REDIM PRESERVE Masks(1 TO 2 * NumMask) AS ASCIIZ * 50 ' Enlarge it
               REDIM PRESERVE FavNames(1 TO 2 * NumMask) AS STRING   '
            END IF                                                '
            Masks(NumMask) = UUCASE(MID$(gSetKey(i), 9))          ' Copy the mask
            FavNames(NumMask) = gSetData(i)                       ' Copy the FAV name
         END IF                                                   '
      NEXT i                                                      '
   END IF                                                         '
   IF NumMask = 0 THEN FUNCTION = "": MExitFunc                   ' No masks, return null

   '-----------------------------------------------------------------------------------------------+
   '- We have some masks, test them                                                                |
   '-----------------------------------------------------------------------------------------------+
   FUNCTION = ""                                                  ' Say we didn't find it
   FName = UUCASE(fn)                                             '
   FName = PATHNAME$(NAMEX, FName)                                ' Just use the filename portion

   FOR j = 1 TO NumMask                                           ' Now for each mask
      tmask = UUCASE(Masks(j))                                    ' Copy it

      MPtr = VARPTR(tmask)                                        ' Point at mask string
      FPtr = VARPTR(FName)                                        '
      DO WHILE @Mptr AND @FPtr                                    ' While each point at something
         SELECT CASE @MPtr                                        ' Work through the mask characters
            CASE 63                                               ' ? = Match any character
               INCR MPtr: INCR FPtr                               ' Step each pointer
            CASE 42                                               ' * = Match any string
               TPtr = MPtr + 1                                    ' Point at next mask char
               IF ISFALSE @TPtr THEN GOSUB PassName: MExitFunc    ' No more mask, so this mask is a win
               DO WHILE @TPtr <> @FPtr AND @FPtr                  ' Scan filename looking for a match
                  INCR FPtr                                       '
               LOOP                                               '
               IF ISFALSE @FPtr THEN EXIT DO                      ' Char not found
               INCR MPtr                                          ' Matched step over them
            CASE ELSE                                             ' Any other char must match
               IF @MPtr <> @FPtr THEN EXIT DO                     ' No, skip this mask
               INCR MPtr: INCR FPtr                               ' Yes, continue
         END SELECT                                               '
         IF ISFALSE @FPtr AND @MPtr = 42 THEN GOSUB PassName: MExitFunc '
      LOOP                                                        '
      IF ISFALSE @MPtr AND ISFALSE @FPtr THEN GOSUB PassName: MExitFunc '
   NEXT j                                                         '
   MExitFunc                                                      '
                                                                  '
PassName:                                                         '
   IF IsEQ(FavNames(j), "FAV") THEN FUNCTION = "Favorite Files": RETURN ' Handle aliases
   IF IsEQ(FavNames(j), "FAVORITE") THEN FUNCTION = "Favorite Files": RETURN  '
   IF IsEQ(FavNames(j), "FAVOURITE") THEN FUNCTION = "Favorite Files": RETURN '
   FUNCTION = FavNames(j)                                         ' Just return it
   RETURN                                                         '
END FUNCTION                                                      '

FUNCTION GetColorSelection(BYVAL hParent AS LONG, BYVAL iStartColor AS LONG) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Use common Dialog to get a colour                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL tt AS STRING                                                '
LOCAL ccTemp AS CustColor                                         '
LOCAL rc, i AS LONG                                               '
   MEntry                                                         '
   tt = gENV.CustomClr                                            ' Get gENV version
   FOR i = 0 TO 15                                                ' Fetch our custom colours
      ccTemp.cc(i) = VAL(PARSE$(tt, ",", i + 1))                  '
   NEXT i                                                         '
   KbdPopSave                                                     ' Ready for pop-up
   DISPLAY COLOR hParent, , , iStartColor, ccTemp, %CC_FULLOPEN TO rc   '
   KbdPopRestore                                                  ' Reset popup state
   tt = ""                                                        '
   FOR i = 0 TO 15                                                ' Store our custom colours
      tt = tt + FORMAT$(ccTemp.cc(i)) + ","                       '
   NEXT i                                                         '
   tt = CLIP$(RIGHT, tt, 1)                                       '
   gENV.CustomClr = tt                                            ' Change gENV copy
   gSQL.UpdateString("O", "CustomClr", tt)                        ' Save in CFG
   FUNCTION = IIF(rc = -1, iStartColor, rc)                       ' Return new if selected or the original
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetDefaultFolder() AS STRING                             '
'--------------------------------------------------------------------------------------------------+
'- Return the default Folder to use                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL sDir AS STRING, SaveTp AS iObjTabData                       '
   MEntry                                                         '
   IF TP.FCB_.FilePath = $New OR INSTR(TP.FCB_.FilePath, "\") = 0 THEN  ' If there's no active file with a path
      SaveTP = TP                                                 ' Save it
      TP = gTabs(1)                                               ' Get FM Tab
      sDir = TP.FPath                                             ' Yes, pass back what FM is using.
      TP = SaveTP                                                 ' Put it back
   ELSE                                                           ' We have an active file
      sDir = TP.FCB_.Path                                         ' So pass back its path
   END IF                                                         '
   IF ISNULL(sDir) THEN sDir = CURDIR$ + "\"                      ' Just in case
   FUNCTION = sDir                                                ' Pass back the string
   MExit                                                          '
END FUNCTION                                                      '
                                                                  '
SUB   GetDir2Array(mask AS STRING, dList() AS STRING, dNum AS LONG)  '
'--------------------------------------------------------------------------------------------------+
                                                                  '- Return a DIR filename list                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL tDir AS STRING                                              '
   dNum = 0                                                       ' Clear count
   tDir = DIR$(mask)                                              ' Get first entry
   WHILE LEN(tDir)                                                ' While we got something
      INCR dNum                                                   ' Bump count
      IF dNum > UBOUND(dList()) THEN _                            ' If needed, expand array
         REDIM PRESERVE dList(1 TO UBOUND(dList()) + 500) AS STRING  ' By 500
      dList(dNum) = tDir                                          ' Save answer
      tDir = DIR$(NEXT)                                           ' Try for another
   WEND                                                           '
END SUB                                                           '

FUNCTION GetDropFiles(BYVAL hDropParam AS DWORD) AS STRING        '
'--------------------------------------------------------------------------------------------------+
'- Return list of Drag/Drop filenames                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL sDropFiles AS STRING, sText AS STRING, i AS LONG            '
   MEntry                                                         '
   FOR i = 0 TO DragQueryFile(hDropParam, &HFFFFFFFF&, "", 0) - 1 ' Loop through passed entries
      sText = SPACE$(DragQueryFile(hDropParam, i, "", 0) + 1)     '
      DragQueryFile hDropParam, i, BYVAL STRPTR(sText), LEN(sText)   '
      sText = CLIP$(RIGHT, sText, 1)                              ' Drop last byte
      IF IsEQ(RIGHT$(sText, 4), ".LNK") THEN sText = GetRealNameFromLNK(sText)   ' Convert any .LNKs to filenames
      IF ISNOTNULL(sText) THEN sDropFiles = sDropFiles + sText + "|" ' Add filename now to string
   NEXT i                                                         '
   DragFinish hDropParam                                          ' Finish off the Drag param
   FUNCTION = sDropFiles                                          ' Pass back the string
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetHelpAmbig(NumWords AS LONG) AS LONG                   '
'--------------------------------------------------------------------------------------------------+
'- Dis-ambiguate an item from the Help Found Table                                                 |
'--------------------------------------------------------------------------------------------------+
DIM ListTxt(1 TO 100) AS STRING: DIM ListRel(1 TO 100) AS STRING: DIM ListNum(1 TO 100) AS LONG '
LOCAL i, j, k, lvCtr, PID AS LONG, maxfound, t, lclcmd AS STRING  '
   '-----------------------------------------------------------------------------------------------+
   '- Get the max found count                                                                      |
   '-----------------------------------------------------------------------------------------------+
   maxfound = gHlpF(1).Ctr                                        ' Since sorted DESCEND, 1st is max

   '-----------------------------------------------------------------------------------------------+
   '- Build the Listbox text items                                                                 |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gHlpFCtr                                          ' Spin through the found table
      IF gHlpF(i).Ctr <> maxfound THEN                            ' Ignore if not part of the largest group
         ITERATE FOR                                              '
      END IF                                                      '
      INCR lvCtr                                                  ' Bump ctr
      IF lvCtr > UBOUND(ListTxt()) THEN                           ' Keep tables big enough
         REDIM PRESERVE ListTxt(1 TO 2 * lvCtr) AS STRING         '
         REDIM PRESERVE ListRel(1 TO 2 * lvCtr) AS STRING         '
         REDIM PRESERVE ListNum(1 TO 2 * lvCtr) AS LONG           '
      END IF                                                      '
      ListRel(lvCtr) = RSET$(gHlpF(i).Hits, 8)                    ' Hit count
      SELECT CASE UCASE$(gHlpT(gHlpF(i).Num).Cat)                 ' Add the category
         CASE "I": ListTxt(lvCtr) = "Introduction: "              '
         CASE "C": ListTxt(lvCtr) = "Customization: "             '
         CASE "K": ListTxt(lvCtr) = "Keyboard: "                  '
         CASE "W": ListTxt(lvCtr) = "Working with: "              '
         CASE "L": ListTxt(lvCtr) = "Line Command: "              '
         CASE "P": ListTxt(lvCtr) = "Primary Command: "           '
         CASE "F": ListTxt(lvCtr) = "Macro Function: "            '
         CASE "M": ListTxt(lvCtr) = "Macros: "                    '
         CASE "A": ListTxt(lvCtr) = "Appendix: "                  '
      END SELECT                                                  '
      ListTxt(lvCtr) += gHlpT(gHlpF(i).Num).Title                 '
      ListNum(lvCtr) = gHlpF(i).Num                               '
      '--------------------------------------------------------------------------------------------+
      '- Uppercase search words ??                                                                 |
      '--------------------------------------------------------------------------------------------+
      t = UCASE$(ListTxt(lvCtr))                                  ' Get an UC version
      FOR j = 1 TO gHlpSWordsCtr                                  ' Look for each word
         k = INSTR(t, UCASE$(gHlpSWords(j)))                      ' Is the word present?
         IF k THEN MID$(ListTxt(lvCtr), k, LEN(gHlpSWords(j))) = UCASE$(gHlpSWords(j)) '
      NEXT j                                                      '

   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- If we end up with just one, just open it                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF lvCtr = 1 THEN                                              ' Just one?
      lclcmd = gENV.EXEPath + "SPFLite.chm"                       ' Build path
      lclCmd = "hh.exe -mapid " + FORMAT$(ListNum(1)) + " " + lclcmd ' Build command string
      PID = SHELL(lclCmd, gENV.HelpOpen)                          ' Start the shelled application:
      FUNCTION = -1: EXIT FUNCTION                                '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now ask user which one they'd like                                                           |
   '-----------------------------------------------------------------------------------------------+
   DIALOG FONT DEFAULT "Tahoma", 13 / gFontScale,0, 0             '
   DIALOG NEW ghWnd, "HELP - Multiple Topics Found", , , 450, 160, _ '
      %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR _ '
      %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR _  '
      %DS_SETFONT, %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO ghAMBIG  '
   DIALOG SET COLOR ghAMBIG, %BLUE, %RGB_GAINSBORO                '
   CONTROL ADD IMAGEX,   ghAMBIG, %AMBIG_Msg, "a", 5, 3, 24, 24, %SS_ICON  '

   CONTROL ADD LABEL, ghAMBIG, %AMBIG_Text + 1, "Scroll as needed, then click on desired topic", 35, 5, 300, 12   '
   CONTROL SET COLOR ghAMBIG, %AMBIG_Text + 1, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD LABEL, ghAMBIG, %AMBIG_LSearch, "Search terms: " + UCASE$(gHlpSearchStr), 35, 15, 300, 12 '
   CONTROL SET COLOR ghAMBIG, %AMBIG_LSearch, %BLACK, %RGB_GAINSBORO '

   CONTROL ADD LISTVIEW, ghAMBIG, %AMBIG_ListBox, "", 35, 25, 400, 115, _  '
                         %WS_CHILD OR %WS_VISIBLE OR %WS_TABSTOP OR %LVS_REPORT OR %LVS_SHOWSELALWAYS OR %LVS_SINGLESEL '
   CONTROL SEND ghAMBIG, %AMBIG_ListBox, %LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0 TO i   ' Add full row select to the ListView control
   i OR= %LVS_EX_FULLROWSELECT                                    '
   CONTROL SEND ghAMBIG, %AMBIG_ListBox, %LVM_SETEXTENDEDLISTVIEWSTYLE, 0, i  '
   CONTROL SET COLOR ghAMBIG, %AMBIG_ListBox, %BLACK, %RGB_SILVER '

   LISTVIEW INSERT COLUMN ghAMBIG, %AMBIG_ListBox, 1, "  Ranking", 40, 0   '
   LISTVIEW INSERT COLUMN ghAMBIG, %AMBIG_ListBox, 2, "Topic Title", 360, 0   '
   FOR i = 1 TO LvCtr                                             '
      LISTVIEW INSERT ITEM ghAMBIG, %AMBIG_ListBox, i, 0, ListRel(i) '
      LISTVIEW SET TEXT  ghAMBIG, %AMBIG_ListBox, i, 2, ListTxt(i)   '
      LISTVIEW SET USER ghAMBIG, %AMBIG_ListBox, i, ListNum(i)    '
   NEXT i                                                         '

   CONTROL ADD BUTTON,  ghAMBIG, %AMBIG_LMAIN, "Main Help", 375, 148, 40, 11, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER   '
   DLGToolTipSet(GetDlgItem(ghAMBIG, %AMBIG_LMAIN), " Press Main Help to proceed to Help Introduction. ")   '

   CONTROL ADD BUTTON,  ghAMBIG, %AMBIG_LBailOut, "Close", 325, 148, 40, 11, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER '
   DLGToolTipSet(GetDlgItem(ghAMBIG, %AMBIG_LBailOut), " Press to exit the Topic List. ") '

   DLGToolTipSet(GetDlgItem(ghAMBIG, %AMBIG_ListBox), " Select your desired HELP topic.") '
   KbdPopSave                                                     ' Ready for pop-up
   DIALOG SHOW MODAL ghAMBIG CALL DlgAMBIGListCallBack            '
   KbdPopRestore                                                  ' Reset popup state
   FUNCTION = IIF(gHlpTopicNum > 0, ListNum(gHlpTopicNum), gHlpTopicNum)   ' Return user's choice
END FUNCTION                                                      '

FUNCTION GetLeadingBlanks(input_str AS STRING, start_pos AS LONG) AS LONG  '''
'--------------------------------------------------------------------------------------------------+
'-  GetLeadingBlanks                                                                               |
'-  tally input_str from start_pos to end for leading blanks                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i, n, fresult AS LONG                                       '
                                                                  '   if instr(start_pos, input_str, " ") = 0 then function = 0: Exit function ' No blanks at all, return 0
                                                                  '   function = max(0, verify(start_pos, input_str, " ") - start_pos)         ' Look for non-blank, return length
   MEntry                                                         '
   n = LEN(input_str)                                             '
   IF n = 0 OR start_pos > n OR start_pos < 1 THEN                '
      FUNCTION = 0                                                '
      MExitFunc                                                   '
   END IF                                                         '
   fresult = 0                                                    '
   i = start_pos                                                  '
   DO WHILE i <= n AND MID$(input_str, i, 1) = " "                '
      fresult += 1                                                '
      i += 1                                                      '
   LOOP                                                           '
   FUNCTION = fresult                                             '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetLineNumber(ln AS LONG) AS LONG                        '
'--------------------------------------------------------------------------------------------------+
'- Return IX of a specified visible line number, 0 if not found                                    |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL t AS STRING                                                 '
   MEntry                                                         '
   IF TP.LastLine = 2 THEN FUNCTION = 0: MExitFunc                ' If no lines, then not found
   j = TP.LastLine - 1                                            ' Get Last data line
   DO WHILE j > 1 AND ISFALSE TP.LFlagData(j)                     ' If last line isn't data line, find it
      DECR j                                                      ' Backup
   LOOP                                                           '
   IF j = 1 THEN FUNCTION = 0: MExitFunc                          ' If just special lines, then not found

   t = FORMAT$(ln, "00000000")                                    ' Create search arg as Text
   IF t > TP.LLNumGet(j) THEN FUNCTION = 0: MExitFunc             ' If past the end, an error
   i = TP.LLNumScan(t)                                            '
   FUNCTION = IIF(i = 0, 0, i - 1)                                ' Pass back result
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetNextWord(Sent AS STRING, DoStrip AS LONG) AS STRING   '
'--------------------------------------------------------------------------------------------------+
'- Get Next Word from passed string, return null if error                                          |
'--------------------------------------------------------------------------------------------------+
REGISTER CurrPos AS LONG                                          '
REGISTER CloseQuote AS LONG                                       '
LOCAL WStr, c AS STRING                                           '
   IF ISNULL(Sent) THEN EXIT FUNCTION                             ' If nothing passed, return nothing
   WStr = TRIM$(Sent) + " "                                       ' Get working copy + space
   FOR CurrPos = 1 TO LEN(WStr)                                   ' OK, lets scan the string
      c = MID$(WStr, CurrPos, 1)                                  ' Get curr character
      IF c = " " THEN                                             ' Blank? - End of word
         EXIT FOR                                                 ' We can leave loop now and process it, CurrPos is set
      ELSEIF INSTR(CHR$(34, 39, 96), c) THEN                      ' Quotes -> " ' `
         CloseQuote = INSTR(CurrPos + 1, WStr, c)                 ' Find closing quote
         IF CloseQuote THEN CurrPos = CloseQuote                  ' Skip over literal if found
      END IF                                                      '
   NEXT CurrPos                                                   ' Loop till done
   FUNCTION = LEFT$(WStr, CurrPos - 1)                            ' Extract the word
   IF DoStrip THEN Sent = MID$(WStr, CurrPos + 1, LEN(WStr) - CurrPos - 1) ' Remove it from source string if requested
END FUNCTION                                                      '

FUNCTION GetNonTextOption(fn AS STRING, OpenPgm AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Perform filtering of non-text files                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL EFTi, RC, lclPCRE, strt, i, j AS LONG, oper, oarg AS STRING '
LOCAL lfn AS ASCIIZ * %MAX_PATH                                   '
LOCAL optr AS BYTE POINTER                                        '
   FUNCTION = 4                                                   ' Default, continue Open
   lfn = TRIM$(UUCASE(fn))                                        ' Make asciiZ
   '-----------------------------------------------------------------------------------------------+
   '- Now spin through each EFT entry                                                              |
   '-----------------------------------------------------------------------------------------------+
   FOR EFTi = 1 TO gEFTCtr                                        ' Look at each
      lclPCRE = gEFT(EFTi).PCRE                                   ' Get Compile area
      strt = 0                                                    ' Calc start column
      optr = VARPTR(gPCRE_Offsets(0))                             ' Point at answer array
      CALL DWORD gPCRE_hProc_Exec USING pcre_exec( _              ' Call for the test
                 lclPCRE,                         _               ' Compile handle
                 &0,                              _               ' extra-data
                 VARPTR(lfn),                     _               ' Test-string
                 LEN(lfn),                        _               ' length of Test-srtring
                 strt,                            _               ' Starting position
                 &0,                              _               ' Options
                 optr,                            _               ' gPCRE_Offsets array
                 &12)                             _               ' Size of offsets array
                 TO RC                                            ' Answer area

      IF RC < 1 THEN ITERATE FOR                                  ' Not found, onward to next entry
      IF gEFT(EFTi).Prof <> "NONTEXT" THEN EXIT FUNCTION          ' Not = NONTEXT, continue Open (4)

      '--------------------------------------------------------------------------------------------+
      '- We have a NONTEXT EFT entry                                                               |
      '--------------------------------------------------------------------------------------------+
      oper = gEFT(EFTi).Oper                                      ' Get the operands string
      i = INSTR(oper, "OPENWITH")                                 ' Is OPENWITH present?
      IF i = 0 THEN                                               ' No, see if Warn
         IF gENV.WarnNonText = 0 THEN FUNCTION = 3: EXIT FUNCTION ' Non-TXT, No warnings, fail it (3)
         '-----------------------------------------------------------------------------------------+
         '- Simple non-text with warning, Ask the user for permission (Yes or No)                  |
         '-----------------------------------------------------------------------------------------+
         j = DoMessageBox("File |K" + fn + "|B" + $CRLF + "is listed in the EFT table as a non-text file." + $CRLF + _  '
                          "Editing a non-TEXT file WITH a TEXT editor may damage your data." + $CRLF + $CRLF + _  '
                          "Enter |KYES|B to continue loading the file, |KNO|B to Exit?", %MB_YESNO + %MB_USERICON + %MB_DEFBUTTON2, "SPFLite")  '
         FUNCTION = IIF(j = %IDNO, 3, 4): EXIT FUNCTION           ' Bail out with Code 3 for NO, Code 4 for YES

      '--------------------------------------------------------------------------------------------+
      '- Non-Text with an OPENWITH                                                                 |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' Else NULL with OPENWITH
         oarg = TRIM$(MID$(oper, i + 8))                          ' Word after OPENWITH into oarg
         IF LEFT$(oarg, 1) = $DQ THEN                             ' Quoted string?
            j = INSTR(2, oarg, $DQ)                               ' Find closing quote
            oarg = LEFT$(oarg, j)                                 ' Throw the rest away
         END IF                                                   '
         IF OARG = "WINDOWS" THEN FUNCTION = 1: EXIT FUNCTION     ' Windows, do the simple open with Windows
         OpenPgm = oarg: FUNCTION = 2: EXIT FUNCTION              ' 2 for Open with OpenPgm
      END IF                                                      '
   NEXT EFTi                                                      '
   EXIT FUNCTION                                                  ' Not in list, just exit
END FUNCTION                                                      '

FUNCTION GetNumDaysSince(OldDate AS STRING) AS LONG               '
'--------------------------------------------------------------------------------------------------+
'- Calc # days since provided date (mm-dd-yyyy)                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL d, m, y, day1, day2 AS LONG, yy AS DOUBLE                   '
   MEntry                                                         '
   d = VAL(MID$(OldDate, 4, 2))                                   ' Convert passed date
   m = VAL(LEFT$(OldDate, 2))                                     '
   y = VAL(MID$(OldDate, 7, 4))                                   '
   yy = y + (m - 2.85) / 12                                       ' Convert to AstroDay
   Day1 = INT(INT(INT(367 * yy) - 1.75 * INT(yy) + d) -0.75 * INT(0.01 * yy)) + 1721119   '

   d = VAL(MID$(DATE$, 4, 2))                                     ' Convert today
   m = VAL(LEFT$(DATE$, 2))                                       '
   y = VAL(MID$(DATE$, 7, 4))                                     '
   yy = y + (m - 2.85) / 12                                       ' Convert to AstroDay
   Day2 = INT(INT(INT(367 * yy) - 1.75 * INT(yy) + d) -0.75 * INT(0.01 * yy)) + 1721119   '
   GetNumDaysSince = Day2 - Day1                                  ' Pass back difference
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetOnOff(param AS LONG, cValue AS LONG, PCmd AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Fetch and process an ON/OFF operand, return new value                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL wValue AS LONG, MSG, t AS STRING                            '
   FUNCTION = cValue                                              ' Start by changing nothing
   wValue = cValue                                                '
   Call3(TP.PTBL_.ParseCmd(pCmd, (%PAll - %Passign)), _           ' Try the basic Parse
      GOTO SetMsg, _                                              ' ? -> Issue msg and exit
      GOTO ErrorMsg, _                                            ' Error, Bail out
      Nul)                                                        ' Continue
   t = TP.PTBL_.Grp("ONOFF")                                      ' Get what was entered
   IF ISNULL(t) THEN                                              ' No param, do a toggle.
      wValue = IIF(wValue, %False, %True)                         '
      GOTO SetMsg                                                 ' Issue msg and exit
   END IF                                                         '
   wValue = IIF(t = "OFF", %False, %True)                         ' Set the input answer
   GOTO SetMsg                                                    ' and go issue it
   ErrorMsg:                                                      '
      MSG = TP.PTBL_.ErrMsg: TP.ErrMsgHigh = %eFail: GOTO MsgOut  ' Issue PTBL message
   SetMsg:                                                        '
      MSG = TP.CurrPCmd + " set to " + IIF$(wValue, "ON", "OFF")  ' Status message
   MsgOut:                                                        '
      DoProfMsg(MSG)                                              ' Display it properly
   FUNCTION = wValue                                              ' Set return value
END FUNCTION                                                      '

FUNCTION GetProfileForFile(fn AS STRING, PDiag AS STRING, EFT AS LONG, Query AS LONG) AS STRING '
'--------------------------------------------------------------------------------------------------+
'- Return Profile for a filename, with Diag as to how chosen                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL EFTi, RC, lclPCRE, strt, i AS LONG, XName, t, ProfName, ProfNameSQL AS STRING '
LOCAL lfn AS ASCIIZ * %MAX_PATH                                   '
LOCAL optr AS BYTE PTR                                            '
   MEntry                                                         '
   TP.EFTSkip = %False                                            ' Reset skip flag
   lfn = TRIM$(UUCASE(fn))                                        ' Make asciiZ
   i = INSTR(-1, lfn, ".")                                        ' Locate last period
   IF i THEN                                                      ' If we have one
      XName = MID$(lfn, i + 1)                                    ' Get Extension name
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Now spin through each EFT entry                                                              |
   '-----------------------------------------------------------------------------------------------+
   TP.EFTOvCtr = 0: gEFTOVCtr = 0                                 ' Reset
   TP.EFTOVListS(0, ""): gEFTOVList(0) = ""                       '
   FOR EFTi = 1 TO gEFTCtr                                        ' Look at each
      lclPCRE = gEFT(EFTi).PCRE                                   ' Get Compile area
      strt = 0                                                    ' Calc start column
      optr = VARPTR(gPCRE_Offsets(0))                             ' Point at answer array
      CALL DWORD gPCRE_hProc_Exec USING pcre_exec( _              ' Call for the test
                 lclPCRE,                         _               ' Compile handle
                 &0,                              _               ' extra-data
                 VARPTR(lfn),                     _               ' Test-string
                 LEN(lfn),                        _               ' length of Test-srtring
                 strt,                            _               ' Starting position
                 &0,                              _               ' Options
                 optr,                            _               ' gPCRE_Offsets array
                 &12)                             _               ' Size of offsets array
                 TO RC                                            ' Answer area

      IF RC < 1 THEN ITERATE FOR                                  ' Not found, onward to next EFT entry

      '--------------------------------------------------------------------------------------------+
      '- Found an entry                                                                            |
      '--------------------------------------------------------------------------------------------+
      FUNCTION = gEFT(EFTi).Prof                                  ' Return Profile name
      i = gEFT(EFTi).Rawix                                        ' Get the Raw index
      PDiag = "(" + gEFT(EFTi).Prof + ") was assigned, by EFT entry: " + SHRINK$(gEFTRaw(i), " ")  '
      t = SHRINK$(gEFTRaw(i), " "): TP.EFTOvCtr = 0: gEFTOVCtr = 0   ' Grab the list
      TP.EFTOVListS(0, t): gEFTOVList(0) = t                      ' Save entire string as entry 0 (Zero)
      gEFTName = ""                                               ' Say no profile gets overridden
      IF ISFALSE EFT THEN MExitFunc                               ' EFT not asked for
      IF ISNULL(gEFT(EFTi).Oper) THEN MExitFunc                   ' We're done
      IF Query THEN MExitFunc                                     ' Just Query? We're done
      '--------------------------------------------------------------------------------------------+
      '- EFT entry has some Profile overrides                                                      |
      '--------------------------------------------------------------------------------------------+
      gEFTName = gEFT(EFTi).Prof: TP.EFTOVName = gEFTName         ' Save Profname being overridden
      t = gEFT(EFTi).Oper                                         ' Get Oper string
      FOR i = 1 TO PARSECOUNT(t, ",")                             '
         TP.EFTOVCtr = TP.EFTOVCtr + 1                            ' Bump IX
         TP.EFTOVListS(TP.EFTOVCtr, PARSE$(t, ",", TP.EFTOVCtr))  ' Extract commands
         gEFTOVCtr = TP.EFTOVCtr: gEFTOVList(gEFTOVCtr) = TP.EFTOVListG(gEFTOVCtr)  ' Copy globally
      NEXT i                                                      '
      MExitFunc                                                   '
   NEXT EFTi                                                      '

   '-----------------------------------------------------------------------------------------------+
   '- Nothing in EFT table, if no extension use DEFAULT, Else see if Profile exists, else Prompt   |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(XName) THEN                                          ' If no extension
      FUNCTION = "DEFAULT"                                        ' Use DEFAULT
      PDiag = "(DEFAULT) was assigned, File has no Extension nor any EFT table entry"  '
      MExitFunc                                                   ' Now this one's done
   END IF                                                         '
   IF gSQL.TableExist("P" + XName) THEN                           ' If a Profile exists for the Ext
      FUNCTION = XName                                            ' then use it
      PDiag = "(" + XName + ") was assigned, File matched no EFT table entry, but matches a Profile"  '
      MExitFunc                                                   '
   END IF                                                         '

   IF Query THEN                                                  ' Just a Query
      FUNCTION = XName                                            ' Return extension
      PDiag = "(" + XName + ") was assigned, File matched no EFT table entry, but has an Extension"   '
      MExitFunc                                                   '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Prompt the user as to what to do                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF IsEFTActive THEN                                            ' If EFTEdit active
      DoMessageBox("An (EFTEdit) session is active." + $CRLF + _  '
                   "SPFLite cannot prompt for how to handle the Profile for:" + $CRLF + _ '
                   "|K" + Fn + "|B" + $CRLF + _                   '
                   "The |KDEFAULT|B profile will be assigned temporarily.", _ '
                   %MB_OK + %MB_USERICON, "SPFLite Profile Selection")  '
      FUNCTION = "DEFAULT"                                        ' Use DEFAULT
      PDiag = "(DEFAULT) was assigned, (EFTEdit) was active"      '
      MExitFunc                                                   ' Now this one's done
   END IF                                                         '
   t = DispDefault(TRIM$(XName))                                  ' Try the display, see what user wants to use
   IF LEFT$(t, 4) = "NEW " THEN                                   '
      ProfName = UCASE$(XName)                                    ' Setup for this profile then
      ProfNameSQL = "P" + ProfName                                '
      gSQL.TableCopy("P" + MID$(t, 5), ProfNameSQL)               ' Copy the selected Profile
      PDiag = "(" + ProfName + ") was assigned, File matched no EFT table entry, New Profile Created" '

   ELSEIF t = "DEF" THEN                                          ' Use the DEFAULT
      EFTAdd(XName, "DEFAULT", "")                                ' Add to EFT
      ProfName = "DEFAULT"                                        ' Swap in the DEFAULT
      ProfNameSQL =  "PDEFAULT"                                   ' Change SQL default Prof name
      PDiag = "(DEFAULT) was assigned, File matched no EFT table entry, DEFAULT was chosen"  '

   ELSEIF LEFT$(t, 4) = "USE " THEN                               ' Make a EFT entry for it
      '--------------------------------------------------------------------------------+
      '- Stuff it into gEFTRaw                                                         |
      '--------------------------------------------------------------------------------+
      EFTAdd(XName, MID$(t, 5), "")                               ' Add to EFT
      ProfStateTable("RESET")                                     ' Clear State Table Cache
      ProfName = UCASE$(MID$(t, 5))                               ' Setup for this profile then
      ProfNameSQL = "P" + ProfName                                '
      PDiag = "(" + ProfName + ") was assigned, File matched no EFT table entry, USE was selected" '

   ELSEIF t = "CANCEL" THEN                                       ' CANCEL the open
      TP.EFTSkip = %True                                          ' Say we're skipping this filetype
      ProfName = ""                                               '

   ELSEIF t = "SKIP" THEN                                         ' Skip this file type
      EFTAdd(XName, "NONTEXT", "")                                ' Create an ignore entry
      TP.EFTSkip = %True                                          ' Say we're skipping this filetype
      ProfName = ""                                               '

   ELSEIF t = "OPENW" THEN                                        ' Skip this file type and mark OpenW
      EFTAdd(XName, "NONTEXT", "OPENWITH WINDOWS")                ' Create a Windows open entry
      ProfName = "NONTEXT"                                        '
      TP.EFTSkip = %True                                          ' Say we're skipping this filetype

   ELSEIF t = "ABORT" THEN                                        ' Abort the FF
      ProfName = ""                                               '
      TP.EFTSkip = %True                                          ' Say we're skipping this filetype
      DIALOG END ghIntr                                           ' End the Interrupt window
      gfInterrupt = %True                                         ' Flag for mainline

   END IF                                                         '
   FUNCTION = ProfName                                            ' then use it
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetProperty(fName AS STRING, sField AS STRING) AS STRING '
'--------------------------------------------------------------------------------------------------+
'- Fetch some properties                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL pShellItem AS IShellItem2                                   '
LOCAL pPropStore AS IPropertyStore                                '
LOCAL fNameW, t AS WSTRING                                        '
LOCAL durM, durS, RC1, RC2 AS DWORD                               '
   fNameW = fName                                                 ' Make WSTRING

   RC1 = SHCreateItemFromParsingName(BYVAL STRPTR(fNameW), NOTHING, $IID_IShellItem2, pShellItem)  '
   IF RC1 <> %S_OK THEN EXIT FUNCTION                             ' Oops! Return NULL
   RC1 = pShellItem.GetPropertyStore(%GPS_DEFAULT, $IID_IPropertyStore, pPropStore) '
   IF RC1 <> %S_OK THEN EXIT FUNCTION                             ' Oops! Return NULL
   SELECT CASE AS CONST$ UCASE$(sField)                           ' Which field
      CASE "ALBUM":      FUNCTION = GetPropertyText(pPropStore, PKEY_Music_AlbumTitle) '
      CASE "ARTIST":     FUNCTION = GetPropertyText(pPropStore, PKEY_Music_DisplayArtist) '
      CASE "BDEPTH":     RC1 = GetPropertyDword(pPropStore, PKEY_Image_BitDepth) '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC1)                  '
      CASE "BRATE":      RC1 = GetPropertyDword(pPropStore, PKEY_Audio_EncodingBitrate)   '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC1/1000) + "K"       '
      CASE "CONTRIB":    t = GetPropertyText(pPropStore, PKEY_ItemParticipants)  '
                         FUNCTION = PARSE$(t, ";", 1)             '
      CASE "DIMENSION":  t = GetPropertyText(pPropStore, PKEY_Image_Dimensions)  '
                         IF t <> "" THEN FUNCTION = t: EXIT FUNCTION '
                         RC1 = GetPropertyDWord(pPropStore, PKEY_Video_FrameHeight) '
                         RC2 = GetPropertyDWord(pPropStore, PKEY_Video_FrameWidth)  '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC2) + " x " + FORMAT$(RC1) '

      CASE "CAMMAKER":   FUNCTION = GetPropertyText(pPropStore, PKEY_Photo_CameraManufacturer)  '
      CASE "CAMMODEL":   FUNCTION = GetPropertyText(pPropStore, PKEY_Photo_CameraModel)   '
      CASE "DATETAKEN":  FUNCTION = GetPropertyText(pPropStore, PKEY_Photo_DateTaken)  '
      CASE "DURATION":   RC1 = GetPropertyDword(pPropStore, PKEY_Media_Duration) '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         RC1 \= 10000: durS = RC1 \ 1000          '
                         durM = durS \ 60: DurS MOD= 60           '
                         FUNCTION = FORMAT$(durM) + ":" + FORMAT$(durS, "00") '
      CASE "EXP":        RC1 = GetPropertyDWord(pPropStore, PKEY_Photo_ExposureTimeDenominator) '
                         RC2 = GetPropertyDWord(pPropStore, PKEY_Photo_ExposureTimeNumerator)   '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC2) + "/" + FORMAT$(RC1)   '
      CASE "FLASH":      FUNCTION = GetPropertyText(pPropStore, PKEY_Photo_FlashText)  '
      CASE "FSTOP":      RC1 = GetPropertyDWord(pPropStore, PKEY_Photo_FNumberDenominator)   '
                         RC2 = GetPropertyDWord(pPropStore, PKEY_Photo_FNumberNumerator)  '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC2/RC1)              '
      CASE "GENRE":      FUNCTION = GetPropertyText(pPropStore, PKEY_Music_Genre)   '
      CASE "HRES":       RC1 = GetPropertyDWord(pPropStore, PKEY_Image_HorizontalResolution) '
                         RC2 = GetPropertyDWord(pPropStore, PKEY_Image_ResolutionUnit) '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC1) + IIF$(RC2 = 2, " dpi", " dpc") '
      CASE "ISO":        RC1 = GetPropertyDword(pPropStore, PKEY_Photo_ISOSpeed) '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC1)                  '
      CASE "PUBLISHER":  FUNCTION = GetPropertyText(pPropStore, PKEY_Media_Publisher)  '
      CASE "RATING":     RC1= GetPropertyDWord(pPropStore, PKEY_Rating) '
                         SELECT CASE RC1                          '
                            CASE 0:         FUNCTION = "UnRated"  '
                            CASE 1 TO 12:   FUNCTION = "*"        '
                            CASE 13 TO 37:  FUNCTION = "**"       '
                            CASE 38 TO 62:  FUNCTION = "***"      '
                            CASE 63 TO 87:  FUNCTION = "****"     '
                            CASE 88 TO 100: FUNCTION = "*****"    '
                         END SELECT                               '
      CASE "SUBTITLE":   FUNCTION = GetPropertyText(pPropStore, PKEY_Media_SubTitle)   '
      CASE "TITLE":      FUNCTION = GetPropertyText(pPropStore, PKEY_Title)   '
      CASE "TRK":        RC1 = GetPropertyDword(pPropStore, PKEY_Music_TrackNumber) '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC1)                  '
      CASE "VRES":       RC1 = GetPropertyDWord(pPropStore, PKEY_Image_VerticalResolution)   '
                         RC2 = GetPropertyDWord(pPropStore, PKEY_Image_ResolutionUnit) '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC1) + IIF$(RC2 = 2, " dpi", " dpc") '
      CASE "YEAR":       RC1 = GetPropertyDword(pPropStore, PKEY_Media_Year)  '
                         IF RC1 = 0 THEN FUNCTION = "": EXIT FUNCTION   '
                         FUNCTION = FORMAT$(RC1)                  '
   END SELECT                                                     '
END FUNCTION                                                      '

FUNCTION GetPropertyDword(pPropStore AS IPropertyStore, prop AS PropertyKey) AS DWORD  '
'--------------------------------------------------------------------------------------------------+
'- Get a DWORD Property value                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL d AS DWORD                                                  '
LOCAL propVar AS PropVariant                                      '
LOCAL RC AS LONG                                                  '
   RC = pPropStore.GetValue(prop, propVar)                        '
   IF RC = %S_OK THEN                                             '
      PropVariantToUint32(propVar, d)                             '
      PropVariantClear(propVar)                                   '
   END IF                                                         '
   FUNCTION = d                                                   '
END FUNCTION                                                      '

FUNCTION GetPropertyText(pPropStore AS IPropertyStore, prop AS PropertyKey) AS STRING  '
'--------------------------------------------------------------------------------------------------+
'- Get a TXT Propertystring                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL retText AS WSTRING                                          '
LOCAL propVar AS PropVariant                                      '
LOCAL RC AS LONG                                                  '
   RC = pPropStore.GetValue(prop, propVar)                        '
   IF RC = %S_OK THEN                                             '
      PropVariantToBSTR(propVar, retText)                         '
      PropVariantClear(propVar)                                   '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Some strings come back with what looks like a ? on either end, turns out to be &H202A ????   |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(retText, 1) = CHR$$(&H202A) THEN retText = MID$(retText, 2 TO LEN(RetText) - 1)  '
   FUNCTION = retText                                             '
END FUNCTION                                                      '

FUNCTION GetRealNameFromLNK(fname AS STRING) AS STRING            '
'--------------------------------------------------------------------------------------------------+
'- Convert a filename for LNK lookup                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL CLSID_ShellLink, IID_IShellLink AS GUIDAPI                  '
LOCAL CLSCTX_INPROC_SERVER, Flags, lResult AS DWORD               '
LOCAL lNull AS IUNKNOWN                                           '
LOCAL FileData AS WIN32_FIND_DATA                                 '
LOCAL IID_Persist AS STRING * 16, ppa, ppf, psl AS DWORD PTR      '
LOCAL outvalue, TmpAsciiz AS ASCIIZ * %MAX_PATH                   '
LOCAL TmpWide AS ASCIIZ * (2 * %MAX_PATH)                         '

   MEntry                                                         '
   POKE$ VARPTR(CLSID_ShellLink), MKL$(&H00021401) + CHR$(0, 0, 0, 0, &HC0, 0, 0, 0, 0, 0, 0, &H46)   '
   POKE$ VARPTR(IID_IShellLink), MKL$(&H000214EE) + CHR$(0, 0, 0, 0, &HC0, 0, 0, 0, 0, 0, 0, &H46) '
   IID_Persist = MKL$(&H0000010B) + CHR$(0, 0, 0, 0, &HC0, 0, 0, 0, 0, 0, 0, &H46)  '
   CLSCTX_INPROC_SERVER = 1                                       '

   IF ISFALSE (CoCreateInstance(CLSID_ShellLink, BYVAL lNull, CLSCTX_INPROC_SERVER, IID_IShellLink, psl)) THEN '
      ppa = @psl: CALL DWORD @ppa USING Sub3(BYVAL psl, IID_Persist, ppf) TO lResult   '
      TmpAsciiz = fname                                           '
      MultiByteToWideChar %CP_ACP, 0, TmpAsciiz, %MAX_PATH, BYVAL VARPTR(TmpWide), 2 * %MAX_PATH   '
      ppa = @ppf + 20: CALL DWORD @ppa USING Sub3(BYVAL ppf, TmpWide, BYVAL %TRUE)  '
      ppa = @psl + 12: CALL DWORD @ppa USING Sub5(BYVAL psl, outvalue, BYVAL %MAX_PATH, FileData, Flags) 'GetFilePath
      ppa = @ppf + 8: CALL DWORD @ppa USING Sub1(BYVAL ppf)       'Release the persistant file
      ppa = @psl + 8: CALL DWORD @ppa USING Sub1(BYVAL psl)       'Unbind the shell link object from the persistent file
      FUNCTION = outvalue                                         '
   END IF                                                         '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetShortName(BYREF longname AS ASCIIZ) AS STRING         '
'--------------------------------------------------------------------------------------------------+
'- Convert long name to short name                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL shortname AS ASCIIZ * %MAX_PATH                             '
   MEntry                                                         '
   IF GetShortPathName(longname, shortname, %MAX_PATH) THEN       ' Shorten the name
      FUNCTION = shortname                                        ' If OK, pass back the short name
   ELSE                                                           '
      FUNCTION = longname                                         ' Else pass the long name
   END IF                                                         '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION GetSimpleNum(param AS LONG, cValue AS LONG, AddOff AS LONG, PCmd AS STRING) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Fetch and process a Simple Numeric operand, return new value                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL wValue AS LONG, MSG AS STRING                               '
   FUNCTION = cValue                                              ' Start by changing nothing
   wValue = cValue                                                '
   Call3(TP.PTBL_.ParseCmd(pCmd, (%PAll - %PAssign)), _           ' Try the basic Parse
      GOTO SetMsg, _                                              ' ? -> Issue msg and exit
      GOTO ErrorMsg, _                                            ' Error, Bail out
      Nul)                                                        ' Continue
   wValue = VAL(TP.PTBL_.Pos("#", 1))                             ' Get the answer
   GOTO SetMsg                                                    ' and go issue it
   ErrorMsg:                                                      '
      MSG = TP.PTBL_.ErrMsg: TP.ErrMsgHigh = %eFail: GOTO MsgOut  ' Issue PTBL message
   SetMsg:                                                        '
      MSG = TP.CurrPCmd + " set to " + FORMAT$(wValue) + IIF$(wValue = 0 AND AddOff, " (OFF)", "") ' Status message
   MsgOut:                                                        '
      DoProfMsg(MSG)                                              ' Display it properly
   FUNCTION = wValue                                              ' Set return value
END FUNCTION                                                      '

FUNCTION GetStateLines(fName AS STRING) AS LONG                   '
'--------------------------------------------------------------------------------------------------+
'- Get # lines via the STATE data                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL pName, lclFn, sLine, PDiag AS STRING, fNum AS LONG          '

   '-----------------------------------------------------------------------------------------------+
   '- Get extension from the filename                                                              |
   '-----------------------------------------------------------------------------------------------+
   pName = GetProfileForFile(fName, PDiag, %False, %True)         ' Extract the extension (NoEFT,Query)

   '-----------------------------------------------------------------------------------------------+
   '- See if STATE active for this Profile                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE ProfStateTable("FETCH", pName) THEN                 ' If STATE=OFF for this Profile
      FUNCTION = -1: EXIT FUNCTION                                ' Then pass back -1 for N/A
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- See if a STATE file exists                                                                   |
   '-----------------------------------------------------------------------------------------------+
   lclFn = fName + ".STATE"                                       ' Temp copy with .STATE on the end
   REPLACE ANY ":\/" WITH "```" IN lclFN                          ' Make : / and \ into `
   lclFn = gENV.HomeData + "STATE\" + lclFn                       ' Add our STATE folder
   IF ISFALSE ISFILE(lclFn) THEN                                  ' If no STATE file
      IF INSTR(fName, "\$BACKUP\") <> 0 THEN                      ' Is this file in a $BACKUP folder?
         lclFn = fName + ".STATE"                                 ' Let's  try again in the same folder
         IF ISFALSE ISFILE(lclFn) THEN                            ' Not here either?
            FUNCTION = -1: EXIT FUNCTION                          ' Then pass back -1 for N/A
         END IF                                                   '
      ELSE                                                        '
         FUNCTION = -1: EXIT FUNCTION                             ' Then pass back -1 for N/A
      END IF                                                      '
   END IF                                                         '

   FNum = FREEFILE                                                ' Open the file
   TRY                                                            ' Just in case
      OPEN lclFn FOR INPUT AS #FNum                               ' Open the STATE File
      LINE INPUT #FNum, sLine                                     ' Read 1st line
      IF sLine = "[[--SPFLite-File-State-Information-//-Do-NOT-Modify--]]" THEN _   '
         LINE INPUT # FNum, sLine                                 ' Skip it and get another
      CLOSE #FNum                                                 ' Close it
   CATCH                                                          ' Oops
      FUNCTION = -1: EXIT FUNCTION                                ' Then pass back -1 for N/A
   END TRY                                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Get line count from header line                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(sLine, 2) <> "#1" THEN                                ' Better be the header line
      FUNCTION = -1: EXIT FUNCTION                                ' If not, then pass back -1 for N/A
   END IF                                                         '
   FUNCTION = VAL(PARSE$(sLine, ",", 2))                          ' Extract the # lines to return
END FUNCTION                                                      '

FUNCTION GetTempFile(pfx AS STRING) AS STRING                     '
'--------------------------------------------------------------------------------------------------+
'- Get a Temp file allocated                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lpTempFileName AS ASCIIZ * %MAX_PATH                        '
LOCAL lpszPrefix        AS ASCIIZ * 20                            '
LOCAL r                 AS LONG                                   '
   lpszPrefix = pfx                                               ' Get Prefix to ASCIIZ
   r = GetTempFileName(GetTempFolder, lpszPrefix, 0, lpTempFileName) '
   IF r = 0 THEN                                                  ' If Failed, then try current folder
      r = GetTempFileName(".", lpszPrefix, 0, lpTempFileName)     '
      IF r = 0 OR ISFALSE ISFILE(lpTempFileName) THEN             ' If failed again or can't find the file            '
         MSGBOX "GetTempFileName failed twice"                    ' Tell user
      END IF                                                      '
   END IF                                                         '
   FUNCTION = GetShortName(lpTempFileName)                        ' Return Shortened name
END FUNCTION                                                      '

FUNCTION GetTempFolder() AS STRING                                '
'--------------------------------------------------------------------------------------------------+
'- Get windows temp dir name                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lResult AS LONG                                             '
LOCAL buff AS ASCIIZ * %MAX_PATH                                  '
   lResult = GetTempPath(BYVAL SIZEOF(buff), Buff)                ' Ask Windows for it
   FUNCTION = TRIM$(buff)                                         '
END FUNCTION                                                      '

FUNCTION GetTimeInHundredths AS DWORD                             '
'--------------------------------------------------------------------------------------------------+
'- Get time in hundredths of a second                                                              |
'--------------------------------------------------------------------------------------------------+
STATIC sdwLastTime AS DWORD                                       '
STATIC slRollOvers AS LONG                                        '
STATIC dwTimeNow   AS DWORD                                       '
   dwTimeNow = GetTickCount                                       '
   IF dwTimeNow < sdwLastTime THEN INCR slRollOvers               ' GetTickCount has rolled over at 49.710 days.
   sdwLastTime = dwTimeNow                                        '
   FUNCTION = (dwTimeNow + (slRollOvers * (%MAXDWORD + 1))) \ 10&&   '
                                                                  'Change divisor to 100&& to return tenths of seconds.
                                                                  'Change divisor to 10&& to return hundredths of seconds.
END FUNCTION                                                      '

FUNCTION GetVerFile() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get SPFLite.VER file from the website                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL VerData AS STRING, URLPath1 AS ASCIIZ * %MAX_PATH, LocalPath AS ASCIIZ * %MAX_PATH  '
LOCAL iResult, FNum AS LONG, lNull AS DWORD                       '
   MEntry                                                         '
   URLPath1 = "http://www.spflite.com/files/SPFLite.ver"          '
   LocalPath = gENV.HomeData + "SPFLite.ver"                      '

   '-----------------------------------------------------------------------------------------------+
   '- Check 1st URL address                                                                        |
   '-----------------------------------------------------------------------------------------------+
   lNull = 0                                                      '
   iResult = DeleteURLCacheEntry(URLPath1)                        ' 1 = success  clear the cache
   IF URLDownloadToFile (BYVAL lNull, URLPath1, LocalPath, 0, 0)  THEN  '
      GOSUB VerError                                              ' Error Bail out
   END IF                                                         '
   FNum = FREEFILE                                                ' Get file number
   OPEN LocalPath FOR INPUT AS # FNum                             ' Get version on the server
   LINE INPUT # FNum, VerData                                     '
   CLOSE #FNum                                                    '
   IF LEFT$(VerData, 1) <> "<" THEN                               ' Look OK?
      FUNCTION = LEFT$(VerData, INSTR(VerData, " ") - 1)          ' Return 1st 'word' from line
      MExitFunc                                                   '
   END IF                                                         '

   GOSUB VerError                                                 '
   MExitFunc                                                      '

VerError:                                                         '
   MyMsgBox("Can't access SPFLite web site for Update check", %MB_OK OR %MB_USERICON OR %MB_TASKMODAL, "Version Check") '
   FUNCTION = ""                                                  ' Return null
   MExitFunc                                                      '
   RETURN                                                         '
END FUNCTION                                                      '

FUNCTION GetWindowHandle(BYVAL lTitle AS STRING, WinCtr AS LONG) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Find a window by title                                                                          |
'--------------------------------------------------------------------------------------------------+
REGISTER Ctr AS LONG                                              '
   gWinListPos = 0: WinCtr = 0                                    ' Init
   EnumWindows CODEPTR(GetWindowsList), 0                         ' Count windows
   lTitle = UUCASE(lTitle)                                        ' Uppercase request
   FOR Ctr = 1 TO gWinListPos                                     ' Loop through list
      IF INSTR(UUCASE(gWinList(Ctr).WinTitle), lTitle) THEN       ' Yes, contain our string?
         IF WinCtr = 0 THEN FUNCTION = gWinList(Ctr).WinHandle    ' Yes, pass back the first one
         INCR WinCtr                                              ' Count instances
      END IF                                                      '
   NEXT Ctr                                                       ' Loop back
END FUNCTION                                                      '

FUNCTION GetWindowsList(BYVAL lHandle AS LONG, BYVAL lNotUsed AS LONG) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Get list of windows                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL wTitle AS ASCIIZ * 256, sTitle AS STRING                    '
   GetWindowText lHandle, wTitle, 255                             '
   sTitle = TRIM$(wTitle)                                         '
   IF LEN(sTitle) THEN                                            '
      INCR gWinListPos                                            '
      IF gWinListPos > UBOUND(gWinList()) THEN _                  '
         REDIM PRESERVE gWinList(1 TO gWinListPos * 2) AS GLOBAL WININFOTYPE  ' Expand if needed
      gWinList(gWinListPos).WinTitle = sTitle                     '
      gWinList(gWinListPos).WinHandle = lHandle                   '
   END IF                                                         '
   FUNCTION = 1                                                   '
END FUNCTION                                                      '

SUB      GlobalOptionSet()                                        '
'--------------------------------------------------------------------------------------------------+
'- Correct all tabs after an OPTION command                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG                                                '
   MEntry                                                         '
   j = TP.PgNumber                                                ' Save where we are
   FOR i = gTabsNum TO 1 STEP -1                                  '
      TP = gTabs(i)                                               ' Swap to tabs data area
      TP.FCB_.WordVal()                                           ' Process WordInput into Word again
      TP.PicSetAll                                                ' Say total initialization Word has changed
      TP.PicInit                                                  ' Re-Initialize Picture control area
      StatusBarSetup                                              '
   NEXT i                                                         '
   TP = gTabs(j)                                                  ' Go back to initial tab
   StatusBarSetup                                                 ' One last time
   MExit                                                          '
END SUB                                                           '

SUB CrashSave ()                                                  ' Start the Crash Save stuff
'--------------------------------------------------------------------------------------------------+
'- Save edit sessions                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, stamp AS STRING                                  '
   FOR i = 1 TO gTabsNum                                          ' Do for each tab
      TP = gTabs(i)                                               ' Pick the Tab
      IF ISFALSE IsFMTab THEN                                     ' If not FM
         IF (TP.TabMode AND (%Clip OR %Browse OR %View)) THEN ITERATE FOR  ' Don't do certain types
         IF (TP.TabMode AND (%SetEdit OR %EFTEdit)) THEN          ' Special tabs?
            pCmdEnd("END KEEP")                                   ' Do an END KEEP
            ITERATE FOR                                           '
         END IF                                                   '
         IF IsTPModdFlag THEN                                     ' If modified
            IF IsMEdit THEN                                       '
               pCmdSave("SAVE COND ")                             '
            ELSE                                                  '
               pCmdSave("SAVE")                                   '
            END IF                                                '
            gLoopCtr = -1                                         ' Suspend loop detect
            Stamp = "." + RIGHT$(DATE$, 2) + LEFT$(DATE$, 2) + MID$(DATE$, 4, 2) + "." + LEFT$(TIME$, 2) + MID$(TIME$, 4,2)   '

            MSGBOX("Crash processing has saved: " + $CRLF + $CRLF +  _  '
                   TP.FCB_.Path + TP.FCB_.Base + Stamp + ".CrashSave" + TP.FCB_.Extn), _  '
                   %MB_OK OR %MB_TASKMODAL, "SPFLite Crash Intercept"   '
         END IF                                                   '
      END IF                                                      '
   NEXT i                                                         '
   SETUNHANDLEDEXCEPTIONFILTER %Null                              ' Deactivate our handler
   ExitProcess 8                                                  '
END SUB                                                           '

SUB      GlobalSaveAll(Cond AS LONG)                              '
'--------------------------------------------------------------------------------------------------+
'- Do the save all                                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL CurrTab, i AS LONG                                          '
   CurrTab = TP.PgNumber                                          ' Save where we are
   FOR i = 1 TO gTabsNum                                          ' Do for each tab
      TP = gTabs(i)                                               ' Pick the Tab
      IF ISFALSE IsFMTab THEN                                     ' If not FM
         IF (TP.TabMode AND (%Clip OR %SetEdit OR %Browse OR %View)) THEN ITERATE FOR  ' Don't do certain types
         IF Cond THEN                                             ' Conditional?
            IF IsTPModdFlag THEN                                  ' If modified
               TP.TabTitleSet(%True)                              '
               IF IsMEdit THEN                                    '
                  pCmdSave("SAVE COND ")                          '
               ELSE                                               '
                  pCmdSave("SAVE")                                '
               END IF                                             '
               TP.DispScreen                                      '
            END IF                                                '
         ELSE                                                     '
            TP.TabTitleSet(%True)                                 '
            pCmdSave("SAVE")                                      '
            TP.DispScreen                                         '
         END IF                                                   '
      END IF                                                      '
   NEXT i                                                         '
   TP = gTabs(CurrTab)                                            ' Go back to initial tab
   IF ISFALSE gMacroMode THEN                                     ' If not macro mode
      TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber              ' Select the new tab
   END IF                                                         '
END SUB                                                           '

FUNCTION HandleHyperlink(BYVAL HNDL AS LONG, lpLink AS DWORD) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Handle click on URL link                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lenLink AS ENLINK                                           '
LOCAL lenlinkPtr AS ENLINK PTR                                    '
LOCAL chrg AS CHARRANGE                                           '
LOCAL tr AS TEXTRANGE                                             '
LOCAL linkText AS STRING                                          '

   MEntry                                                         '
   lenlinkPtr = lpLink                                            '
   lenLink = @lenlinkPtr                                          '
   tr.chrg = lenLink.chrg                                         '
   linkText = SPACE$(tr.chrg.cpMax - tr.chrg.cpMin + 2)           '
   tr.lpstrText = STRPTR(linkText)                                '
   SENDMESSAGE(ghRich, %EM_GETTEXTRANGE, BYVAL 0, VARPTR(tr))     '

   SELECT CASE AS LONG lenLink.msg                                '
      CASE %WM_LBUTTONDOWN                                        '
         ShellExecute(%Null, "open", BYCOPY linktext, "", "", %SW_SHOW) '
         FUNCTION = %True: MExitFunc                              '
   END SELECT                                                     '
   FUNCTION = %False                                              '
   MExit                                                          '
END FUNCTION                                                      '

SUB InitCodePage (CP AS Codepage_cp_t)                            '
'--------------------------------------------------------------------------------------------------+
'-  Init_CodePage ()                                                                               |
'--------------------------------------------------------------------------------------------------+
                                                                  '
LOCAL I, T AS LONG                                                '
    CP.CP_LineNo            = 0                                   '
    CP.CP_Errors            = 0                                   '
    CP.CP_Reason            = ""                                  '
    CP.TT.TT_Errors         = 0                                   '
    CP.TT.TT_Reason         = ""                                  '
    CP.TT.TT_Author         = ""                                  '  Creator of table
    CP.TT.TT_GenDate        = ""                                  '  "2002-12-03 00:00:00"
    CP.TT.TT_Mode           = ""                                  '  RT/ES round trip/subset
    CP.TT.TT_Name           = ""                                  '  Name of translation table
    CP.TT.TT_Title          = ""                                  '  Title of translation table
    CP.TT.TT_Other          = ""                                  '  Creator of table
                                                                  '
    FOR I = 1 TO %TX_Max                                          '  From ASCII TO EBCDIC
        CP.TX(I).TX_Defined = 0                                   '
        CP.TX(I).TX_Errors  = 0                                   '
        CP.TX(I).TX_Values  = 0                                   '  Number of values stored
        CP.TX(I).TX_Reason  = ""                                  '  Reason for reported error
        FOR T = 0 TO 15                                           '
            CP.TX(I).TX_Entry (T) = 0                             '  Flage for 0_ TO F_ lines
        NEXT                                                      '
        CP.TX(I).TX_CCSID   = ""                                  '  Pieces of 'NUMBER' as Int
        CP.TX(I).TX_CGCSGID = ""                                  '  CGCSGID   "00695"
        CP.TX(I).TX_CodeSet = ""                                  '  Full CodeSet name
        CP.TX(I).TX_CPGID   = ""                                  '  CPGID  "01140"
        CP.TX(I).TX_Euro    = ""                                  '  Value of Euro OR 00
        CP.TX(I).TX_Number  = ""                                  '  "1140", "8859_1", ETC.
        CP.TX(I).TX_Origin  = ""                                  '  "IBM", "ISO" etc.
        CP.TX(I).TX_Related = ""                                  '  Related Euro CCSID "-37"
        CP.TX(I).TX_Scheme  = ""                                  '  Encoding scheme "1100"
        CP.TX(I).TX_Size    = ""                                  '  Num of defined chars
        CP.TX(I).TX_Sub     = ""                                  '  Substitution char
        CP.TX(I).TX_Type    = ""                                  '  "ASCII", "EBCDIC"
        CP.TX(I).TX_UCM     = ""                                  '  .UCM file name
        CP.TX(I).TX_UCMDate = ""                                  '  "2002-12-03 00:00:00"
        CP.TX(I).TX_Version = ""                                  '  "2.3.3", "1995", ETC.
        CP.TX(I).TX_Other   = ""                                  '  Unknown keyword value
        FOR T = 0 TO 255                                          '
            CP.TX(I).TX_Table (T) = 0                             '  Final translation table
        NEXT                                                      '
    NEXT                                                          '
END SUB                                                           ' InitCodePage

FUNCTION IsEFTActive() AS LONG                                    '
'--------------------------------------------------------------------------------------------------+
'- Return true if an EFTEdit session is active                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL ctab, i AS LONG                                             '
   ctab = TP.PgNumber                                             ' Save where we are
   FOR i = 1 TO gTabsNum                                          ' Do for each tab
      TP = gTabs(i)                                               ' Pick the Tab
      IF IsEFTEdit THEN                                           ' We have a EFTEdit tab active
         FUNCTION = %True: EXIT FOR                               ' Say we found one
      END IF                                                      '
   NEXT i                                                         '
   TP = gTabs(ctab)                                               ' Replace TP
END FUNCTION                                                      '

FUNCTION IsAvailable(sFileName AS STRING) AS LONG                 '
'--------------------------------------------------------------------------------------------------+
'- Return available status of file                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL hFile AS LONG                                               '
   IF ISFALSE ISFILE(sFilename) THEN FUNCTION = 1: EXIT FUNCTION  ' Not even a file, RC=1
   IF VAL(FileQueue("S", " ", sFileName)) > 0 THEN FUNCTION = 2: EXIT FUNCTION   ' RC=2 Open elsewhere
   hFile = FREEFILE                                               ' Get a free file number
   TRY                                                            ' Lets try
      OPEN sFileName FOR BINARY ACCESS READ WRITE LOCK READ WRITE AS hFile ' Try open for R/W LOCK
      CLOSE hFile                                                 ' We got it, close the file
      FUNCTION = 0                                                ' RC=0, file is not locked
   CATCH                                                          ' We failed
      CLOSE hFile                                                 ' Close the file
      FUNCTION = 3                                                ' RC=3, Signal the file is locked
   END TRY                                                        '
END FUNCTION                                                      '

FUNCTION IsNullFile(fn AS STRING) AS LONG                         '
'--------------------------------------------------------------------------------------------------+
'- Return true if a file exists AND it is zero length                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL FD AS DIRDATA, fn2 AS STRING                                '
   fn2 = DIR$(fn, TO FD)                                          ' Get the FD data if it exists
   IF ISNULL(fn2) THEN EXIT FUNCTION                              ' No file?  Then return false.
   IF FD.FileSizeHigh > 0 OR FD.FileSizeLow > 0 THEN EXIT FUNCTION   ' Something in the size, exit false
   FUNCTION = %True                                               ' Else we have a true nullfile
END FUNCTION                                                      '

FUNCTION IsIn(str1 AS STRING, str2 AS STRING) AS LONG             '
   FUNCTION = INSTR(str1, str2)                                   '
END FUNCTION                                                      '

FUNCTION IsMacro(MName AS STRING) AS LONG                         '
'--------------------------------------------------------------------------------------------------+
'- Is name a macro                                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL Maclib, MaclibSet, MacName AS STRING, RCA AS RCArea, i AS LONG '
   Maclib = TP.FCB_.Maclib: MacName = MName                       ' Fetch MACLIB value, Set defalt macname
   i = INSTR(MName, ":")                                          ' A Maclib prefix?  abc:macroname
   IF i THEN                                                      ' Yes
      Maclib = LEFT$(MName, i - 1)                                ' Peel it off
      MacName = MID$(MName, i + 1)                                ' Extract the macroname
   END IF                                                         '
   IF ISNULL(MacLib) THEN                                         ' No MacLib
      FUNCTION = ISFILE(gENV.HomeData + "MACROS\" + MacName + ".MACRO")     '
   ELSE                                                           ' Got a MacLib
      SETTableUpd("GET", "MACLIB." + Maclib, RCA)                 ' See if a MACLIB SET symbol
      IF RCA.RC <> 0 THEN RCA.Msg = gENV.HomeData + "MACROS\"     ' If it doesn't exist, stuff in the default
      FUNCTION = ISNOTNULL(PATHSCAN$(FULL, MacName + ".MACRO", RCA.Msg))   ' Set RC
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION IsWithin(pRect AS RECT, pRow AS LONG, pCol AS LONG) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Is pRow / pCol within a RECT area                                                               |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = (pCol >= pRect.Left   AND _                         ' Is x/y within the rectangle
               pCol <= pRect.Right  AND _                         '
               pRow >= pRect.Top    AND _                         '
               pRow <= pRect.Bottom)                              '
END FUNCTION                                                      '

SUB      KbdPopRestore()                                          '
'--------------------------------------------------------------------------------------------------+
'- Reset from a PopReady                                                                           |
'--------------------------------------------------------------------------------------------------+
   IF gfDoingMsg = 0 THEN EXIT SUB                                ' Nothing to do
   DECR gfDoingMsg                                                ' Decr count
   IF gfDoingMsg = 0 THEN                                         ' Gone to zero?
      CaretCreate                                                 ' Create it
      DoCursor                                                    ' Position it
      CaretShow                                                   ' Show the caret
   END IF                                                         '
END SUB                                                           '

SUB      KbdPopSave()                                             '
'--------------------------------------------------------------------------------------------------+
'- Ready cursor etc. for a popup dialog                                                            |
'--------------------------------------------------------------------------------------------------+
   IF gfDoingMsg = 0 THEN                                         ' If first time
      CaretHide                                                   ' Get rid of cursor
      CaretDestroy                                                '
   END IF                                                         '
   INCR gfDoingMsg                                                ' Tell KB hook to ignore things
END SUB                                                           '

FUNCTION KbdSortExit(BYREF p1 AS STRING * 32, BYREF p2 AS STRING * 32) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Custom sort key for the PFShow Help data                                                        |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL Key1, Key2, t, tt, p, b AS STRING                           '
   t = p1                                                         ' Process Key1
   REPLACE CHR$(0) WITH " " IN t                                  '
   t = TRIM$(t)                                                   '
   IF ISNULL(t) THEN                                              ' Handle null entry
      Key1 = ""                                                   '
   ELSE                                                           ' Else find the key
      GOSUB Breakout                                              '
      Key1 = b + p                                                ' Key = base followed by chord
   END IF                                                         '

   t = p2                                                         ' Process Key2
   REPLACE CHR$(0) WITH " " IN t                                  '
   t = TRIM$(t)                                                   '
   IF ISNULL(t) THEN                                              ' Handle null entry
      Key2 = ""                                                   '
   ELSE                                                           ' Else find the key
      GOSUB Breakout                                              '
      Key2 = b + p                                                ' Key = base followed by chord
   END IF                                                         '

   FUNCTION = StrCmpr(Key1, Key2)                                 ' Finally do the compare
   EXIT FUNCTION                                                  '

Breakout:                                                         '
   tt = LEFT$(t, INSTR(t, "=") - 1)                               ' Get the stuff before the =
   StrSub128(tt)                                                  ' Back to normal ANSI
   i = INSTR(tt, "-")                                             ' See if a chord prefix
   IF i THEN                                                      ' Yes
      p = LEFT$(tt, i - 1): b = MID$(tt, i + 1)                   ' Split prefix and base
   ELSE                                                           '
      p = "": b = tt                                              ' Else just a base name
   END IF                                                         '
   IF LEN(b) = 2 AND LEFT$(b, 1) = "F" THEN                       ' Fn name?
      b = "F0" + MID$(b, 2)                                       ' Normalize it to Fnn
   END IF                                                         '
   RETURN                                                         '
END FUNCTION                                                      '

FUNCTION LLCASE (BYVAL sAscii AS STRING) AS STRING                '
'--------------------------------------------------------------------------------------------------+
'- Do a character translate from upper to lower case ASCII                                         |
'--------------------------------------------------------------------------------------------------+
REGISTER n   AS LONG                                              '
LOCAL pAscii AS BYTE PTR                                          '
   IF LEN(sAscii) = 0 THEN                                        '  handle null-string case
      FUNCTION = ""                                               '
   ELSEIF gENV.ENGchars THEN                                      '  do ENGLISH-only LLCASE
      pAscii = STRPTR(sAscii)                                     '  point to first char of value
      FOR n = 1 TO LEN(sAscii)                                    '  scan ASCII looking for UC
         IF  @pAscii >= &H41  _                                   '  UC "A"
         AND @pAscii <= &H5A  THEN                                '  UC "Z"
             @pAscii += &H20                                      '  shift UC up to where LC ASCII is
         END IF                                                   '
         INCR pAscii                                              '  bump scan pointer to next char
      NEXT                                                        '
      FUNCTION = sAscii                                           '  return modified string argument as result
   ELSE                                                           '  do international LLCASE
      FUNCTION = LCASE$(sAscii)                                   '
   END IF                                                         '
END FUNCTION                                                      '

SUB      MakeNullFile(fn AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Create an empty physical file                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL FNm AS LONG                                                 '
   FNm = FREEFILE                                                 ' Create it as an empty file
   OPEN fn FOR OUTPUT AS #FNm                                     ' Open the File
   SETEOF #FNm                                                    ' Set EOF
   CLOSE #FNm                                                     ' Close it
END SUB                                                           '

FUNCTION NormalizeCharMap(RawString AS STRING, NewString AS STRING) AS STRING '
'--------------------------------------------------------------------------------------------------+
'- Convert a user's char string map to an effective string                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL tbl, t, op AS STRING                                        '
LOCAL i AS LONG                                                   '
   tbl = SPACE$(256)                                              ' Init the new string
   t = RawString                                                  ' Get a working copy of WORDS line

   DO WHILE LEN(t)                                                ' Break out the operands
      op = GetNextWord(t, %Strip)                                 ' Get next operand

      IF LEN(op) = 1 THEN                                         ' Just a single character?
         MID$(tbl, ASC(op) + 1, 1) = op                           ' Set it into the final table

      ELSEIF LEN(op) = 2 THEN                                     ' Two characters
         IF VERIFY(UUCASE(op), $Hex) = 0 THEN                     ' Valid Hex?
            op = CHR$(VAL("&H" + op))                             ' Convert it to a character
            MID$(tbl, ASC(op) + 1, 1) = op                        ' Set it into the final table
         ELSE                                                     '
            FUNCTION = "Invalid Hex value in the string"          ' Return an error message for the caller
            EXIT FUNCTION                                         ' Exit with the error
         END IF                                                   '

      ELSEIF LEN(op) = 3 THEN                                     ' Three, possible a-z type
         IF MID$(op, 2, 1) = "-" AND _                            ' Have a proper - character?
            MID$(op, 1, 1) <= MID$(op, 3, 1) THEN                 ' And in range sequence?
            FOR i = ASC(op, 1) TO ASC(op, 3)                      ' Loop through range
               MID$(tbl, i + 1, 1) = CHR$(i)                      ' Set it into the final table
            NEXT i                                                '
         ELSE                                                     '
            FUNCTION = "Invalid character range (" + op + ") in string" '
            EXIT FUNCTION                                         ' Exit with the error
         END IF                                                   '

      ELSEIF LEN(op) = 5 THEN                                     ' Five, possible hh-hh type
         IF MID$(op, 3, 1) = "-" AND _                            ' Have a proper - character?
            VERIFY(UUCASE(MID$(op, 1, 2)), $Hex) = 0 AND _        '
            VERIFY(UUCASE(MID$(op, 4, 2)), $Hex) = 0 AND _        '
            MID$(op, 1, 2) <= MID$(op, 4, 2) THEN                 ' And in range sequence?
            FOR i = VAL("&H" + MID$(op, 1, 2)) TO VAL("&H" + MID$(op, 4, 2))  ' Loop through range
               MID$(tbl, i + 1, 1) = CHR$(i)                      ' Set it into the final table
            NEXT i                                                '
         ELSE                                                     '
            FUNCTION = "Invalid hex range (" + op + ") in string" '
            EXIT FUNCTION                                         ' Exit with the error
         END IF                                                   '

      ELSE                                                        '
         FUNCTION = "Invalid operand (" + op + ") in  string"     '
         EXIT FUNCTION                                            '
      END IF                                                      '
   LOOP                                                           '

   NewString = REMOVE$(tbl, " ")                                  ' Condense the string
   FUNCTION = ""                                                  ' Say no error
END FUNCTION                                                      '

FUNCTION NormalizeMark(mk AS STRING) AS STRING                    '
'--------------------------------------------------------------------------------------------------+
'- Simplify the new Mark string                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL nmk AS STRING, i, j AS LONG                                 '
   MEntry                                                         '
   nmk = SPACE$(LEN(mk) + 1)                                      ' Get working copy of blanks
   j = 1                                                          '
   i = INSTR(1, mk, ANY "<*>")                                    ' Look for special chars
   DO WHILE i                                                     ' While a special char left
      SELECT CASE AS CONST$ MID$(mk, i, 1)                        ' Which one?
         CASE "<", "*"                                            ' < or *
            MID$(nmk, i, 1) = "*": j = i + 1                      ' Just transfer it
         CASE ">"                                                 ' >
            MID$(nmk, i + 1, 1) = "*": j = i + 1                  ' Put * in next column
      END SELECT                                                  '
      i = INSTR(j, mk, ANY "<*>")                                 ' Look for special chars
   LOOP                                                           '

   FUNCTION = nmk                                                 ' Pass back the answer
   MExit                                                          '
END FUNCTION                                                      '

FASTPROC Nul():END FASTPROC                                       '

SUB ParseCodePageDataLine(TX AS CODEPAGE_TX_T, BUF AS STRING, CP_LineNo AS LONG) '

'--------------------------------------------------------------------------------------------------+
'- Process_Codepage_Data_Line                                                                      |
'-                                                                                                 |
'- Process tran table data entries like that are prefixed like "3_"                                |
'- the prefix defines one of it sectors where the data is stored                                   |
'- there must be exactly 16 entries, and each can/must be used only once                           |
'- here is a sample AE line referenced by the code below.                                          |
'-                                                                                                 |
'- 3_ F0 F1 F2 F3 F4 F5 F6 F7 F8 F9 7A 5E 4C 7E 6E 6F 3_                                           |
'- 1234                                                                                            |
'- After the 16th entry on the line, the remainder is treated as comments                          |
'--------------------------------------------------------------------------------------------------+
LOCAL C, NUM, SECTOR_CODE  AS STRING                              '
LOCAL SECTOR_NUM, SECTOR_NDX, CHAR_NDX, CHAR_VALUE AS LONG        '
REGISTER I AS LONG                                                '

    IF  MID$(BUF, 2, 2) <> "_ " THEN                              '
        TX.TX_Errors += 1                                         '  A parse error occurred
        TX.TX_Reason = "LINE " + TRIM$(CP_LineNo) + _             '
            ": DATA FORMAT ERROR AT: " + BUF                      '
        EXIT SUB                                                  '
    END IF                                                        '

    SECTOR_CODE = UUCASE(LEFT$(BUF, 1))                           '
    IF  VERIFY (SECTOR_CODE, "0123456789ABCDEF") <> 0 THEN        '
        TX.TX_Errors += 1                                         '  A parse error occurred
        TX.TX_Reason = "1: " + SECTOR_CODE + "LINE " + TRIM$(CP_LineNo) _  '
            + ": DATA FORMAT ERROR AT: " + BUF                    '
        EXIT SUB                                                  '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '  Create sector number and index.   3_ becomes &H30 = 48
                                                                  '  we use &H0 in the VAL() to ensure an unsigned conversion happens                            |
    '----------------------------------------------------------------------------------------------+
    SECTOR_NUM = VAL ("&H0" & SECTOR_CODE)                        '  3_ --> 3
    SECTOR_NDX = SECTOR_NUM * 16                                  '  3 * 16 --> &H30 = 48
    CHAR_NDX = 0                                                  '
    I = 3                                                         '
    DO                                                            ' LOOP                                   '  Start with space after prefix
        IF  I > LEN(BUF) THEN EXIT DO                             '  Reached end of buffer
        C = MID$(BUF, I, 1)                                       '
        IF  C = " " THEN                                          '  Inter-number space
            I += 1                                                '  Skip over space
            ITERATE DO                                            '
        END IF                                                    '

        IF  C = "*" THEN EXIT DO                                  '  End of line comment

        '------------------------------------------------------------------------------------------+
                                                                  '   3_ F0 F1 F2 F3 <== CURR BUF
                                                                  '   ......0123      <-- Value of I + ?
        '------------------------------------------------------------------------------------------+
        C = MID$(BUF, I+2, 1)                                     '
        IF (C <> " ") AND (C <> "*") THEN                         '  Bad delimiter
            TX.TX_Errors += 1                                     '  A parse error occurred
            TX.TX_Reason = "LINE " + TRIM$(CP_LineNo) _           '
                + ": DELIMITER ERROR IN: " + BUF                  '
            EXIT SUB                                              '
        END IF                                                    '

        NUM = UUCASE(MID$(BUF, I, 2))                             '  Grab 2 digits like F1 above
        I += 2                                                    '  Consume the 2 digits

        IF  VERIFY (NUM, "0123456789ABCDEF") <> 0 THEN            '  Invalid hex code
            TX.TX_Errors += 1                                     '  A parse error occurred
            TX.TX_Reason = "2: " + NUM + "LINE " + TRIM$(CP_LineNo) _   '
                + ": DATA FORMAT ERROR AT: " + BUF                '
            EXIT DO                                               '
        END IF                                                    '

        CHAR_VALUE = VAL ("&H0" & NUM)                            '  Like F1 above --> 241
        TX.TX_Table (SECTOR_NDX + CHAR_NDX) = CHAR_VALUE          '
        TX.TX_Entry (SECTOR_NUM) += 1                             '  Count the number of 3_ entries
        TX.TX_Values += 1                                         '  Number of values stored
        TX.TX_Defined = 1                                         '  At least one entry defined
        CHAR_NDX += 1                                             '
        IF  CHAR_NDX >= 16 THEN EXIT DO                           '
    LOOP                                                          '

    IF  CHAR_NDX <> 16 THEN                                       '  Didn't get 16 good values
        TX.TX_Errors += 1                                         '  A parse error occurred
        TX.TX_Reason = "LINE " + TRIM$(CP_LineNo) _               '
            + ": DATA FORMAT ERROR AT: " + BUF                    '
        EXIT SUB                                                  '
    END IF                                                        '
END SUB                                                           ' ParseCodePageDataLine

SUB ParseCodePageSourceLine(CP AS CodePage_CP_T, BUF AS STRING)   '
'--------------------------------------------------------------------------------------------------+
'-  Process_CodePage_Source_Line                                                                   |
'-                                                                                                 |
'-  This routine examines the leading two character action code, and routes                        |
'-  the buffer to the appropriate handler.                                                         |
'-  Action codes are: TT, TA, TE, AE AND EA                                                        |
'-  The prefixes on data lines like "4_" are alco considered action codes                          |
'-  Blank lines, full-line comments, and the // EOF mark are handled elsewhere                     |
'--------------------------------------------------------------------------------------------------+
STATIC AE_EA_Mode       AS LONG                                   '
LOCAL ACTION            AS STRING                                 '
LOCAL TT_INDEX          AS LONG                                   '
    ACTION = UUCASE(LEFT$((BUF + "     "), 3))                    '
    TT_INDEX = 0                                                  '
    IF     ACTION = "TA " THEN                                    '
        TT_INDEX =%TA_Index                                       '
    ELSEIF ACTION = "TE " THEN                                    '
        TT_INDEX =%TE_Index                                       '
    ELSEIF ACTION = "AE " THEN                                    '
        AE_EA_Mode = %AE_Mode                                     '  Save static state of AE/EA
        EXIT SUB                                                  '
    ELSEIF ACTION = "EA " THEN                                    '
        AE_EA_Mode = %EA_Mode                                     '  Save static state of AE/EA
        EXIT SUB                                                  '
    END IF                                                        '

    BUF = BUF + " "                                               '  Processing routines need trailing space

    IF  TT_INDEX <> 0 THEN                                        '  BUF has TA or TE action code
        AE_EA_Mode = 0                                            '
        ParseCodePageTXLine (CP.TX (TT_INDEX), BUF, CP.CP_LineNo) '
        EXIT SUB                                                  '
    END IF                                                        '

    IF  ACTION = "TT " THEN                                       '  BUF has TT action code
        AE_EA_Mode = 0                                            '
        ParseCodePageTTLine (CP.TT, BUF, CP.CP_LineNo)            '
        EXIT SUB                                                  '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '   If current line is an AE/EA data entry, store it
                                                                  '   lines are only recognized in AE/EA mode
                                                                  '   unless we got a prior AE/EA action code, the lines are out of order                        |
    '----------------------------------------------------------------------------------------------+
    IF  AE_EA_Mode <> 0 THEN                                      '  This mode state is a static varioable
        IF  MID$(BUF, 2, 1) = "_"  THEN                           '  Entry looks like A "0_"

            '--------------------------------------------------------------------------------------+
            '-  We let Process_CodePage_Data_Line() validate the line                              |
            '--------------------------------------------------------------------------------------+
            ParseCodePageDataLine (CP.TX (AE_EA_Mode), BUF, CP.CP_LineNo)  '
            EXIT SUB                                              '
        END IF                                                    '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '  At this point, the line has an invalid action code
    '----------------------------------------------------------------------------------------------+
    AE_EA_Mode = 0                                                '
    CP.CP_Errors += 1                                             '
    CP.CP_Reason = "LINE " + TRIM$(CP.CP_LineNo) + ": " _         '
        + "ACTION CODE UNDEFINED: " + ACTION                      '
END SUB                                                           ' ParseCodePageSourceLine

SUB ParseCodePageTTLine(TT AS CODEPAGE_TT_T, BUF AS STRING, CP_LineNo AS LONG)   '
'--------------------------------------------------------------------------------------------------+
'-  Process_CodePage_TT_Line                                                                       |
'-                                                                                                 |
'-  Process tran table TT attributes.  These are general descriptive                               |
'-  attributes to help identify the source and nature of the codepage                              |
'--------------------------------------------------------------------------------------------------+
LOCAL KV                  AS KEYWORD_VALUE_DATA_T                 '
LOCAL FailSafe            AS LONG                                 '
    KV.KV_DATA = MID$(BUF, 3)                                     '  Skip the TT code
    FailSafe = LEN(BUF)                                           '  A rule-of-thumb upper limit to parse

    '----------------------------------------------------------------------------------------------+
                                                                  '  There can't be more tokens in a buffer than the number of characters.                       |
                                                                  '  The FailSafe is to protect the logic from locking up if the parse fails                     |
    '----------------------------------------------------------------------------------------------+
    DO  UNTIL FailSafe <= 0                                       '
        FailSafe -= 1                                             '
        ParseKeywordData (KV)                                     '
        IF  KV.KV_STATUS = 0 THEN EXIT DO                         '  Buffer consumed, parse completed
        IF  KV.KV_STATUS = 1 THEN                                 '  One keyword value pair found
            SELECT CASE KV.KV_KEYWORD                             '
                CASE "AUTHOR"   : TT.TT_Author  = KV.KV_VALUE     '
                CASE "GENDATE"  : TT.TT_GenDate = KV.KV_VALUE     '
                CASE "MODE"     : TT.TT_Mode    = KV.KV_VALUE     '
                CASE "NAME"     : TT.TT_Name    = KV.KV_VALUE     '
                CASE "TITLE"    : TT.TT_Title   = KV.KV_VALUE     '

                '----------------------------------------------------------------------------------+
                                                                  '  If we get an unknown keyword, just store keyword/value as is                    |
                                                                  '  maybe someone is trying to convey a 'note' we didn't                            |
                                                                  '  account for  so we don't treat this as a fatal error.                           |
                '----------------------------------------------------------------------------------+
                CASE ELSE:     TT.TT_Other = KV.KV_KEYWORD + "=" + KV.KV_VALUE   '
            END SELECT                                            '

        ELSE                                                      '
            '--------------------------------------------------------------------------------------+
            '-  At this point, some kind of parse error occurred                                   |
            '-  KV.KV_Data will have what is left of the parse buffer, which                       |
            '-  should be at the beginning of where the problem is                                 |
            '--------------------------------------------------------------------------------------+
            TT.TT_Errors += 1                                     '  A parse error occurred
            TT.TT_Reason = "LINE " + TRIM$(CP_LineNo) + ": " + KV.KV_Reason   '
            EXIT SUB                                              '
        END IF                                                    '
    LOOP                                                          '

END SUB                                                           ' ParseCodePageTTLine

SUB ParseCodePageTXLine(TX AS CODEPAGE_TX_T, BUF AS STRING, CP_LineNo AS LONG)   '
'--------------------------------------------------------------------------------------------------+
'-  Process_CodePage_TX_Line                                                                       |
'-                                                                                                 |
'-  This routine parses and stores all the keyword/value pairs associated with                     |
'-  the TA/TE lines.  Their format is the same, so we process both kinds in                        |
'-  the same routine.  We get passed the appropriate TA/TE structure                               |
'--------------------------------------------------------------------------------------------------+
    '----------------------------------------------------------------------------------------------+
                                                                  '  Process tran table TA/TE attributes
    '----------------------------------------------------------------------------------------------+
LOCAL KV                  AS KEYWORD_VALUE_DATA_T                 '
LOCAL FailSafe            AS LONG                                 '

    KV.KV_DATA = MID$(BUF, 3)                                     '  Skip the TA/TE code
    FailSafe = LEN(BUF)                                           '  A rule-of-thumb upper limit to parse

    '----------------------------------------------------------------------------------------------+
                                                                  '  There can't be more tokens in a buffer that the number of characters                        |
                                                                  '  THE FailSafe is to protect the logic from locking up if the parse fails                     |
    '----------------------------------------------------------------------------------------------+
    DO  UNTIL FailSafe <= 0                                       '
        FailSafe -= 1                                             '
        ParseKeywordData (KV)                                     '
        IF  KV.KV_STATUS = 0 THEN EXIT DO                         '  Buffer consumed, parse completed
        IF  KV.KV_STATUS = 1 THEN                                 '  One keyword value pair found
            SELECT CASE KV.KV_KEYWORD                             '
                CASE "CCSID"    : TX.TX_CCSID   = KV.KV_VALUE     '
                CASE "CGCSGID"  : TX.TX_CGCSGID = KV.KV_VALUE     '
                CASE "CODESET"  : TX.TX_CodeSet = KV.KV_VALUE     '
                CASE "CPGID"    : TX.TX_CPGID   = KV.KV_VALUE     '
                CASE "EURO"     : TX.TX_Euro    = KV.KV_VALUE     '
                CASE "NUMBER"   : TX.TX_Number  = KV.KV_VALUE     '
                CASE "ORIGIN"   : TX.TX_Origin  = KV.KV_VALUE     '
                CASE "RELATED"  : TX.TX_Related = KV.KV_VALUE     '
                CASE "SCHEME"   : TX.TX_SCHEME  = KV.KV_VALUE     '
                CASE "SIZE"     : TX.TX_Size    = KV.KV_VALUE     '
                CASE "SUB"      : TX.TX_Sub     = KV.KV_VALUE     '
                CASE "TYPE"     : TX.TX_Type    = KV.KV_VALUE     '
                CASE "UCM"      : TX.TX_UCM     = KV.KV_VALUE     '
                CASE "UCMDATE"  : TX.TX_UCMDate = KV.KV_VALUE     '
                CASE "VERSION"  : TX.TX_Version = KV.KV_VALUE     '
                '----------------------------------------------------------------------------------+
                                                                  '  If we get an unknown keyword, just store keyword/value as is                    |
                                                                  '  Maybe someone is trying to convey a 'note' we didn't                            |
                                                                  '  account for, so we don't treat this as a fatal error                            |
                '----------------------------------------------------------------------------------+
                CASE ELSE:     TX.TX_Other = KV.KV_KEYWORD + "=" + KV.KV_VALUE   '
            END SELECT                                            '

        ELSE                                                      '
            '--------------------------------------------------------------------------------------+
            '-  At this point, some kind of parse error occurred                                   |
            '-  KV.KV_Data will have what is left of the parse buffer, which                       |
            '-  should be at the beginning of where the problem is                                 |
            '--------------------------------------------------------------------------------------+
            TX.TX_Errors += 1                                     '  A parse error occurred
            TX.TX_Reason = "LINE " + TRIM$(CP_LineNo) + ": " + KV.KV_Reason   '
            EXIT SUB                                              '
        END IF                                                    '
    LOOP                                                          '
END SUB                                                           ' ParseCodePageTXLine

SUB ParseKeywordData(KV AS KEYWORD_VALUE_DATA_T)                  '
'--------------------------------------------------------------------------------------------------+
'-  Parse_Keyword_Value_Data                                                                       |
'-                                                                                                 |
'-  Keyword_Value_Data_T.KV_Data contains one or more pairs of                                     |
'-  Keyword=Value strings.  we scan left to right looking for the first such                       |
'-  pair, split the keyword and value into separate strings and store them.                        |
'-  Once a Keyword=Value is found, the KV_Data string is truncated on the left                     |
'-  and this continues until the entire KV_Data string is consumed.                                |
'--------------------------------------------------------------------------------------------------+
LOCAL C, QUOTE              AS STRING                             '
LOCAL I, LEN_IN_DATA        AS LONG                               '
LOCAL START_KEYWORD, START_VALUE, END_VALUE, NEXT_KEYWORD AS LONG '
                                                                  '
    LEN_IN_DATA = LEN(KV.KV_DATA)                                 '

    '----------------------------------------------------------------------------------------------+
                                                                  '  Initialize returned structure
    '----------------------------------------------------------------------------------------------+
    KV.KV_KEYWORD           = ""                                  '
    KV.KV_VALUE             = ""                                  '
    KV.KV_Reason            = ""                                  '
    KV.KV_STATUS            = 0                                   '  0 means no more values left to return

    '----------------------------------------------------------------------------------------------+
                                                                  '  Find start of keyword
    '----------------------------------------------------------------------------------------------+
    C = " "                                                       '  Initialize
    FOR I = 1 TO LEN_IN_DATA                                      '
        C = UUCASE(MID$(KV.KV_DATA, I, 1))                        '  Uses UUCASE
        IF  C = " " THEN ITERATE FOR                              '  Skip leading blanks
        START_KEYWORD = I                                         '
        EXIT FOR                                                  '
    NEXT                                                          '

    '----------------------------------------------------------------------------------------------+
                                                                  '  If line is blank or starts with an * as an end of line
                                                                  '  comment, we have reached and of buffer; parsing complete
    '----------------------------------------------------------------------------------------------+
    IF  (START_KEYWORD = 0) OR (C = "*") THEN                     '
        KV.KV_STATUS = 0                                          '  Parsing complete
        EXIT SUB                                                  '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '  At this point, C should be the first letter of the keyword
                                                                  '  which must be letter, otherwise keyword format is invalid
                                                                  '  keywords are forced to uppercaseE.
    '----------------------------------------------------------------------------------------------+
    IF  (C < "A") OR (C > "Z") THEN                               '
        KV.KV_Reason = "KEYWORD STARTS WITH INVALID CHARACTER: " + C '
        KV.KV_STATUS = -1                                         '  Bad keyword format
        EXIT SUB                                                  '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '  Store characters of keyword until '=' found
    '----------------------------------------------------------------------------------------------+
    FOR I = START_KEYWORD TO LEN_IN_DATA                          '
        C = UUCASE(MID$(KV.KV_DATA, I, 1))                        '  Uses UUCASE
        IF  ( (C >= "A") AND (C <= "Z") ) _                       '
        OR  ( (C >= "0") AND (C <= "9") ) _                       '
        OR    (C  = "_")                  _                       '
        OR    (C  = ".") THEN                                     '
            KV.KV_KEYWORD += C                                    '  Append char to keyword string
        ELSEIF C = "=" THEN                                       '
            START_VALUE = I + 1                                   '  Value starts after the '='
            EXIT FOR                                              '
        END IF                                                    '
    NEXT                                                          '

    IF  START_VALUE = 0 _                                         '
    OR  START_VALUE >= LEN_IN_DATA THEN                           '
        KV.KV_Reason = "KEYWORD " + KV.KV_KEYWORD + " NOT FOLLOWED BY = SIGN" '
        KV.KV_STATUS = -2                                         '  Value is missing or null
        EXIT SUB                                                  '
    END IF                                                        '

    C = MID$(KV.KV_DATA, START_VALUE, 1)                          '
    IF  C <= " " THEN                                             '  Nonblank value expected
        KV.KV_Reason = "KEYWORD " + KV.KV_KEYWORD + "= NOT FOLLOWED BY VALUE" '
        KV.KV_STATUS = -2                                         '  Value is missing or null
        EXIT SUB                                                  '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '  Values can be quoted or unquoted.
                                                                  '  Unquoted values are upper-cased, and end with space or end of string                        |
                                                                  '  Quoted values are not upper-cased, and end with matching quote                              |
                                                                  '----------------------------------------------------------------------------------------------+
    IF  (C = $SQ) OR (C = $DQ) OR (C = "`") THEN                  '
        QUOTE = C                                                 '
        START_VALUE += 1                                          '

        '------------------------------------------------------------------------------------------+
                                                                  '   For quoted string, Start_Value should point to first char of                           |
                                                                  '   value.  This means there must be at least 2 positions left: 1 for                      |
                                                                  '   the data and 1 for the ending quote.  Be sure there is enough                          |
                                                                  '   data left for them
        '------------------------------------------------------------------------------------------+
        IF  START_VALUE >= LEN_IN_DATA THEN                       '
            KV.KV_Reason = "KEYWORD " + KV.KV_KEYWORD _           '
                + " QUOTED VALUE MALFORMED"                       '
            KV.KV_STATUS = -3                                     '  Error in quoted value
            EXIT SUB                                              '
        END IF                                                    '
    ELSE                                                          '
        QUOTE = " "                                               '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '  Accumulate value string
    '----------------------------------------------------------------------------------------------+
    IF  QUOTE = " " THEN                                          '  Accumulate non-quoted value
        END_VALUE = LEN_IN_DATA                                   '  Default end if last value
        FOR I = START_VALUE TO LEN_IN_DATA                        '
            C = UUCASE(MID$(KV.KV_DATA, I, 1))                    '  Uses UUCASE
            IF  C = " " THEN                                      '
                END_VALUE = I                                     '  A non-quoted value ends at space
                EXIT FOR                                          '
            END IF                                                '
            KV.KV_VALUE += C                                      '  Append char to value string
        NEXT                                                      '
        NEXT_KEYWORD = END_VALUE + 1                              '
    ELSE                                                          '  Accumulate quoted value
        FOR I = START_VALUE TO LEN_IN_DATA                        '
            C = MID$(KV.KV_DATA, I, 1)                            '  Without UUCASE
            IF  C = QUOTE THEN                                    '
                END_VALUE = I                                     '  A quoted value ends at quote
                EXIT FOR                                          '
            END IF                                                '
            KV.KV_VALUE += C                                      '  Append char to value string
        NEXT                                                      '

        IF  END_VALUE = 0 THEN                                    '  Close quote never found
            KV.KV_Reason = "KEYWORD " + KV.KV_KEYWORD _           '
                + " QUOTED VALUE NOT CLOSED"                      '
            KV.KV_STATUS = -3                                     '  Error in quoted value
            EXIT SUB                                              '
        END IF                                                    '
        NEXT_KEYWORD = END_VALUE + 1                              '

        '------------------------------------------------------------------------------------------+
                                                                  '  Ending quote must have one space after, unless last
        '------------------------------------------------------------------------------------------+
        IF  NEXT_KEYWORD <= LEN_IN_DATA THEN                      '
            C = MID$(KV.KV_DATA, NEXT_KEYWORD, 1)                 '
            IF  C = " " THEN                                      '
                NEXT_KEYWORD += 1                                 '  Skip over trailing space
            ELSE                                                  '
                KV.KV_Reason = "KEYWORD " + KV.KV_KEYWORD _       '
                    + " CLOSE QUOTE NOT FOLLOED BY SPACE"         '
                KV.KV_STATUS = -3                                 '  Error in quoted value
                EXIT SUB                                          '
            END IF                                                '
        END IF                                                    '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '  Chop off data value for next time
    '----------------------------------------------------------------------------------------------+
    IF  NEXT_KEYWORD > LEN_IN_DATA THEN                           '
        KV.KV_DATA = ""                                           '  Data string was consumed
    ELSE                                                          '
        KV.KV_DATA = MID$(KV.KV_DATA, NEXT_KEYWORD)               '
    END IF                                                        '
    KV.KV_STATUS = 1                                              '  One Keyword-Value pair returned
END SUB                                                           ' ParseKeywordData

SUB PassCmdToOtherTab(BYVAL tn AS LONG, tcmd AS STRING)           '
   MEntry                                                         '
   TP = gTabs(tn)                                                 ' Switch to the tab
   TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber                 ' Select the new tab
   TP.pCommand = tcmd                                             ' Stuff in the command
   TP.AttnDo =  (TP.AttnDo OR %Attention)                         ' Request Attention
   TP.PostKeyboard                                                ' Go try it
   MExit                                                          ' We're done
END SUB                                                           '

FUNCTION PCRERegexCompile(str1 AS STRING) AS STRING               '
'--------------------------------------------------------------------------------------------------+
'- Compile / Test a Regex string                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL txtP AS ASCIIZ PTR, lclPCRE AS DWORD                        '

   MEntry                                                         '
   lclPCRE = TP.hPCRE                                             ' Get PCRE handle
   IF lclPCRE <> 0 THEN                                           ' Any prior area? Free it
      TRY                                                         ' Lets not crash
         FREE lclPCRE                                             ' Free it one way
      CATCH                                                       ' Oops, try the other way
         CALL DWORD gPCRE_hProc_Free_Ptr USING pcre_free( _       ' Free it
                    lclPCRE)                                      ' Compile handle
      FINALLY                                                     '
         TP.hPCRE = 0                                             ' Regardless, zero the pointer
      END TRY                                                     '
   END IF                                                         '
   gPCRE_Options = IIF(TP.FCB_.CaseFlag = "C", 0, %PCRE_CASELESS) ' Set Options to ignore CASE
   gPCRE_Regex_Str2 = str1 + CHR$(0)                              ' Make into pseudo ASCIIZ
   CALL DWORD gPCRE_hProc_Compile USING pcre_compile( _           ' Try the compile
              BYVAL STRPTR(gPCRE_Regex_Str2), _                   ' Regex string
              BYVAL gPCRE_Options,           _                    ' Options
              BYVAL VARPTR(gPCRE_ErrPtr),    _                    ' Pointer to error string
              BYVAL VARPTR(gPCRE_ErrOffsetPtr),_                  ' Error offset
              BYVAL &0) _                                         ' Character tables
              TO lclPCRE                                          ' Answer area
   IF lclPCRE = 0 THEN                                            ' OK?
      txtp = gPCRE_ErrPtr                                         ' No, get error message
      FUNCTION = "at Col: " + FORMAT$(gPCRE_ErrOffsetPtr + 1) + " : " + @Txtp '
      MExitFunc                                                   '
   END IF                                                         '
   FUNCTION = ""                                                  ' Return null to indicate OK
   TP.hPCRE = lclPCRE                                             ' Save PCRE area for this tab
   MExit                                                          '
END FUNCTION                                                      '

SUB PCRERegexTest(str1 AS STRING, scol AS LONG, fcol AS LONG, flen AS LONG)   '
'--------------------------------------------------------------------------------------------------+
'- PCRE regex test                                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL strt, RC AS LONG, lclPCRE AS DWORD                          '
LOCAL optr AS BYTE PTR                                            '
   MEntry                                                         '
   lclPCRE = TP.hPCRE                                             ' Get Compile area
   strt = scol - 1                                                ' Calc start column
   optr = VARPTR(gPCRE_Offsets(0))                                ' Point at answer array
   CALL DWORD gPCRE_hProc_Exec USING pcre_exec( _                 ' Call for the test
              lclPCRE,                         _                  ' Compile handle
              &0,                              _                  ' extra-data
              STRPTR(str1),                    _                  ' Test-string
              LEN(str1),                       _                  ' length of Test-srtring
              strt,                            _                  ' Starting position
              &0,                              _                  ' Options
              optr,                            _                  ' gPCRE_Offsets array
              &12)                             _                  ' Size of offsets array
              TO RC                                               ' Answer area

   IF RC < 1 THEN                                                 ' How'd search go?
      fcol = 0: flen = 0                                          ' Not found
   ELSE                                                           '
      fcol = gPCRE_Offsets(0) + 1                                 ' Pass back column found in
      flen = gPCRE_Offsets(1) - gPCRE_Offsets(0)                  ' And length
   END IF                                                         '
   MExit                                                          '
END SUB                                                           '

FUNCTION PrinterOpen(Setup AS STRING) AS INTEGER                  '
'--------------------------------------------------------------------------------------------------+
'- Open the Default Printer                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i, lclppix, lclppiy AS LONG, lcllm, lclrm, lcltm, lclbm AS SINGLE '
LOCAL fList AS STRING, fTable() AS STRING                         '
   MEntry                                                         '
   IF Setup = "SETUP" THEN                                        ' SETUP requested?
      DispPrint()                                                 ' Go let user set them
      FUNCTION = %True                                            '
      MExitFunc                                                   '
   END IF                                                         '

   IF ISNULL(gENV.PrtName) THEN                                   '
      TP.ErrMsgAdd(%eFail, "Printer SETUP has not been completed yet")  ' Tell user to do SETUP
      gPrinterOpen = %False                                       '
      FUNCTION = %False                                           ' Set a no-go default
      MExitFunc                                                   '
   END IF                                                         '

   gLoopCtr = - 1                                                 ' Prevent loop detection
   XPRINT CANCEL                                                  ' Just in case?
   XPRINT CLOSE                                                   '
   XPRINT ATTACH gENV.PrtName, "SPFLite Print"                    ' Attach the printer
   IF ERR = 0 AND LEN(XPRINT$) > 0 THEN                           ' OK?
      XPRINT GET DUPLEX TO i                                      ' Duplex supportable?
      IF ISTRUE i THEN XPRINT SET DUPLEX gENV.PrtDuplex           ' Set duplex
      XPRINT GET DUPLEX TO i                                      ' Get it again
      gENV.PrtDuplex = i                                          '
      IF gENV.PrtDuplex = 0 THEN gENV.PrtDuplex = 1               ' Eliminate zero case
      XPRINT SET ORIENTATION gENV.PrtOrient                       '
      XPRINT GET MARGIN TO lcllm, lcltm, lclrm, lclbm             '
      XPRINT GET PPI TO lclppix, lclppiy                          '
      FONT NEW gENV.PrtFontName, VAL(gENV.PrtFontPitch), VAL(gENV.PrtFontStyle), 1, 1 TO gPFontHndl   ' Create the font
      XPRINT SET FONT gPFontHndl                                  ' Set it
      XPRINT CHR SIZE TO gPCharWidth, gPCharHeight                ' Get size of a character
      XPRINT GET CLIENT TO gPPageWidth, gPPageHeight              ' Get page size
      gPCpl = gPPageWidth \ gPCharWidth                           ' Calc characters per line
      gPLpp = (gPPageHeight \ gPCharHeight) - 1                   ' Calc lines per page
      gPTFill = MAX(0, ((gENV.PrtTMargin * lclppiy) - lcltm) \ gPCharHeight)  ' Filler lines at top
      gPLpp -= gPTFill                                            ' Adjust line count
      gPLpp -= MAX(0, ((gENV.PrtBMargin * lclppiy) - lclbm) \ gPCharHeight)   ' Again for bottom margin
      gPLFill = MAX(0, ((gENV.PrtLMargin * lclppix) - lcllm) \ gPCharWidth)   ' Filler chars at left
      gPCpl -= gPLFill                                            ' Adjust line length
      gPCpl -= ((gENV.PrtRMargin * lclppix) - lclRm) \ gPCharWidth   ' Again for right margin
      gPRFill = MAX(0, ((gENV.PrtRMargin * lclppix) - lclRm) \ gPCharWidth)   ' Filler chars at right
      gPColor = gENV.PrtPColor                                    ' Printing in color?
      XPRINT SCALE (0, 0) - (gPCpl, gPLpp)                        ' Set page scale to characters
      XPRINT GET PAPERS TO fList                                  ' Get string of forms available
      REDIM fTable(1 TO PARSECOUNT(fList)) AS STRING              ' Build a table
      PARSE fList, fTable()                                       '
      FOR i = 1 TO UBOUND(fTable) STEP 2                          '
         IF VAL(fTable(i)) = gENV.PrtPaper THEN                   ' Found our entry?
            gPrtPaper = fTable(i + 1): EXIT FOR                   ' Save paper name
         END IF                                                   '
      NEXT i                                                      '
      gPrinterOpen = %True                                        ' Set the internal flag showing printer is open
      gENV.SetINITimeStamp                                        '
      FUNCTION = %True                                            '
   ELSE                                                           '
      gPrinterOpen = %False                                       '
      FUNCTION = %False                                           ' Set a no-go default
   END IF                                                         '
   MExit                                                          '
END FUNCTION                                                      '

SUB      PrinterPrint(sMode AS LONG, sTxt AS STRING, sAttr AS WSTRING, Number AS LONG) '
'--------------------------------------------------------------------------------------------------+
'- Print a string on the printer                                                                   |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
STATIC LineCtr, PageCtr, lgth, lgth2, posX, posY AS LONG          '
LOCAL k, lclScheme, cPtr, oPtr, tLen, DoingClose AS LONG, lAttr, lTxt AS WSTRING, xTxt, hText, subst AS STRING '
LOCAL AttrAsc AS WORD                                             '
   lAttr = sAttr: ltxt = sTxt                                     ' Get working copies

   '-----------------------------------------------------------------------------------------------+
   '- Split by Mode                                                                                |
   '-----------------------------------------------------------------------------------------------+
   SELECT CASE AS LONG sMode                                      ' Why called?
      CASE %PRTReset                                              ' Reset
         LineCtr = 0: PageCtr = 0                                 ' Line and Page counters

      CASE %PRTLine                                               ' Print some text
         GOSUB DoALine                                            ' Go do it

      CASE %PRTNewLine                                            ' Move to a new line
         XPRINT PRINT                                             '
         IF LineCtr > 0 THEN INCR LineCtr                         '

      CASE %PRTNewPage                                            ' Move to a new Page
         DO WHILE LineCtr <> 0                                    ' Loop to fill page
            lTxt = " ": lAttr = $$TxtLo                           ' Dummy values                                           '
            INCR Linectr                                          '
            GOSUB DoALine                                         '
         LOOP                                                     '

      CASE %PRTFlushClose                                         ' Shut things down
         DoingClose = %True                                       ' To avoid extra blank page at end
         DO WHILE LineCtr <> 0                                    ' Loop to fill page
            lTxt = " ": lAttr = $$TxtLo                           ' Dummy values
            INCR LineCtr                                          '
            GOSUB DoALine                                         '
            XPRINT PRINT                                          '
         LOOP                                                     '
         XPRINT CLOSE                                             ' End the document
         gPrinterOpen = %False                                    '
         FONT END gPFontHndl                                      ' Delete the font we created
         LineCtr = 0: PageCtr = 0                                 ' Reset Counters to 0
   END SELECT                                                     '
   EXIT SUB                                                       ' We're all done


   DoALine:                                                       '
      IF LineCtr = 0 THEN                                         ' Page heading time?
         IF PageCtr <> 0 THEN XPRINT FORMFEED                     ' Yes, start a new page (other than 1st page)
         GOSUB Bandit                                             ' Add bands
         FOR i = 1 TO gPTFill: XPRINT " ": INCR LineCtr: NEXT i   ' Add top fill lines
         INCR PageCtr                                             ' Bump page count
         gPageNumber = FORMAT$(PageCtr, "###")                    ' Make available for ~# substitution
         IF gENV.PrtHeader AND ISFALSE gPrtRaw THEN               ' Only if we're doing headers
            XPRINT COLOR IIF(gPColor, gENV.GetClr(%SCTxtHi, %SCFG), %BLACK), -1  ' Print headings in Hi-Intensity
            hText = SPACE$(gPCpl)                                 ' Make Heading 1
            subst = gENV.PrtHeaderLeft                            ' Get format string
            TP.MacSubst(subst)                                    ' Do substitution
            LSET ABS hText = subst                                ' Insert it
            subst = gENV.PrtHeaderRight                           ' Get format string
            TP.MacSubst(subst)                                    ' Do substitution
            RSET ABS hText = subst                                ' Insert it
            subst = gENV.PrtHeaderCenter                          ' Get format string
            TP.MacSubst(subst)                                    ' Do substitution
            lgth = LEN(subst)                                     ' Get length of center part
            lgth2 = (gPCpl - lgth) / 2                            '
            hText = LEFT$(hText, lgth2) + subst + RIGHT$(hText, gPCpl - lgth - lgth2)  '
            xTxt = SPACE$(gPLFill) + hText                        ' Add left fill
            XPRINT PRINT xTxt                                     ' Print it
            INCR LineCtr                                          '
            xTxt = SPACE$(gPLFill) + REPEAT$(gPCpl, "")          ' Make Heading 2
            XPRINT PRINT xTxt                                     ' Print it
            INCR LineCtr                                          '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Process a text string                                                                     |
      '--------------------------------------------------------------------------------------------+
      cPtr = 1                                                    ' Start at left end of lTxt
      tLen = LEN(lTxt)                                            ' Do length of lTxt
      IF sAttr <> " " THEN XPRINT PRINT SPACE$(gPLFill);          ' Insert left fill

      DO WHILE cPtr <= LEN(lTxt)                                  ' While still stuff in lTxt
         Attrasc = ASC(sAttr, cPtr)                               ' Get Attribute byte
         lclScheme = AttrAsc AND %AttrSchNum                      ' Get scheme number
         IF ISFALSE gENV.PRTPColor OR ISTRUE gPrtRaw THEN lclScheme = %SCTxtHi   ' Force TxtHi of not color printing
         XPRINT COLOR IIF(gPColor, gENV.GetClr(%SCTxtHi, %SCFG), %BLACK), -1  ' Print headings in Hi-Intensity

         i = VERIFY(cPtr + 1, sAttr, CHR$$(AttrAsc))              ' Find next different Attr character
         j = IIF(i, i - cPtr, MIN(LEN(sTxt) - cPtr + 1, tLen - oPtr))   ' Size of chunk
         IF j + XPRINT(POS.X) > gPCpl THEN                        ' Will this go over a line?
            k = gPCpl - XPRINT(POS.X)                             ' Calc how much will fit
            xTxt = MID$(lTxt, cPtr, k)                            ' Print whatever that is
            XPRINT PRINT xTxt                                     '
            INCR LineCtr                                          '
            cPtr += k: oPtr += k                                  ' Adjust pointers
            IF sAttr <> " " THEN XPRINT PRINT SPACE$(gPLFill);    ' Insert left fill
            IF Number THEN XPRINT PRINT SPACE$(gENV.LinNoSize + 1);  '
         ELSE                                                     '
            IF i = 0 THEN                                         ' Remainder of attributes are the same
               xTxt = MID$(lTxt, cPtr)                            ' Print rest of text
               XPRINT PRINT xTxt;                                 '
               cPtr = LEN(lTxt) + 1: oPtr += j                    ' Force loop exit
            ELSE                                                  ' There's another Scheme value coming up
               xTxt = MID$(lTxt, cPtr, i - cPtr)                  ' Print this segment
               XPRINT PRINT xTxt;                                 '
               cPtr += j: oPtr += j                               ' Adjust pointers
            END IF                                                '
         END IF                                                   '
      LOOP                                                        '

      IF LineCtr >= IIF(gENV.PrtFooter AND ISFALSE gPrtRaw, gPLpp - 2, gPLpp) THEN  ' Time for footer?
         IF gENV.PrtFooter AND ISFALSE gPrtRaw THEN               ' Doing footers?
            XPRINT PRINT                                          ' End the last line
            XPRINT COLOR IIF(gPColor, gENV.GetClr(%SCTxtHi, %SCFG), %BLACK), -1  ' Print headings in Hi-Intensity
            xTxt = SPACE$(gPLFill) + REPEAT$(gPCpl, "")          ' Make Footer 1
            XPRINT PRINT xTxt                                     ' Print it

            hText = SPACE$(gPCpl)                                 ' Make Footer 2
            subst = gENV.PrtFooterLeft                            ' Get format string
            TP.MacSubst(subst)                                    ' Do substitution
            LSET ABS hText = subst                                ' Insert it
            subst = gENV.PrtFooterRight                           ' Get format string
            TP.MacSubst(subst)                                    ' Do substitution
            RSET ABS hText = subst                                ' Insert it
            subst = gENV.PrtFooterCenter                          ' Get format string
            TP.MacSubst(subst)                                    ' Do substitution
            lgth = LEN(subst)                                     ' Get length of center part
            lgth2 = (gPCpl - lgth) / 2                            '
            hText = LEFT$(hText, lgth2) + subst + RIGHT$(hText, gPCpl - lgth - lgth2)  '
            xTxt = SPACE$(gPLFill) + hText                        ' Left fill it
            XPRINT PRINT xTxt                                     ' Print it
         END IF                                                   '
         LineCtr = 0                                              ' Start next page
      END IF                                                      '
      RETURN                                                      ' Back now

   Bandit:                                                        '

      IF ISFALSE gENV.PrtBanding AND ISFALSE gENV.PrtBandLines THEN RETURN '
      XPRINT GET POS TO posX, posY                                ' Save current POS
      XPRINT SCALE PIXELS                                         ' Switch to Pixel mode

      FOR i = 1 + gPTFill + IIF(gENV.PrtHeader AND ISFALSE gPrtRaw, 2, 0) TO gPLpp - ABS((2 * gENV.PrtFooter)) _  '
          STEP IIF(gENV.PrtBanding, 6, 3)                         ' For vertical # lines
         IF gENV.PrtBanding THEN                                  ' If banding
            XPRINT BOX (1 + (gPLFill * gPCharWidth), (i * gPCharHeight) - gPCharHeight)  - _ '
                       (gPPageWidth - (gPRFill * gPCharWidth), ((i+3) * gPCharHeight) - gPCharHeight), _ '
                       0, gENV.PrtBandColor, gENV.PrtBandColor, 0 '
         ELSEIF gENV.PrtBandLines THEN                            ' Else, is it the Line version?
            XPRINT LINE (1 + (gPLFill * gPCharWidth), (1 + (i+3) * gPCharHeight) - gPCharHeight)  - _ '
                       (gPPageWidth - (gPRFill * gPCharWidth), (1 + (i+3) * gPCharHeight) - gPCharHeight), gENV.PrtBandColor  '
         END IF                                                   '
      NEXT i                                                      '
      XPRINT SCALE (0, 0) - (gPCpl, gPLpp)                        ' Set page scale back to characters
      XPRINT SET POS (posX, posY)                                 ' Restore current POS
      RETURN                                                      '

END SUB                                                           '

FUNCTION ProfStateTable(verb AS STRING, OPTIONAL pName AS STRING) AS LONG  '
'--------------------------------------------------------------------------------------------------+
'- Handle Profile STATE table                                                                      |
'--------------------------------------------------------------------------------------------------+
STATIC ProfTable() AS STRING * 51                                 '
DIM ProfTable(1 TO 300) AS STATIC STRING * 51                     '
STATIC ProfNumber AS LONG                                         '
LOCAL i, j AS LONG, wProf, t  AS STRING                           '
                                                                  '
   IF ISFALSE ISMISSING(pName) THEN                               ' Only if optional parameter
      wProf = UCASE$(pName)                                       ' Create our working name
   END IF                                                         '

   SELECT CASE AS CONST$ verb                                     ' Why were we called?
      CASE "RESET": ProfNumber = 0: FUNCTION = 0                  ' RESET
      '--------------------------------------------------------------------------------------------+
      '- Return STATE setting                                                                      |
      '--------------------------------------------------------------------------------------------+
      CASE "FETCH"                                                ' FETCH
         '-----------------------------------------------------------------------------------------+
         '- See if in the table                                                                    |
         '-----------------------------------------------------------------------------------------+
         IF ProfNumber > 0 THEN                                   ' Got some cached?
            ARRAY SCAN ProfTable() FOR ProfNumber, FROM 2 TO 51, = LSET$(wProf, 50), TO i '
            IF i THEN FUNCTION = VAL(LEFT$(ProfTable(i), 1)): EXIT FUNCTION   '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Not cached, see if the PROFILE exiats                                                  |
         '-----------------------------------------------------------------------------------------+
         IF ISFALSE gSQL.TableExist("P" + wProf) THEN             ' If it doesn't exist, create an OFF entry
            GOSUB BumpNumber                                      ' Bump number saved
            ProfTable(ProfNumber) = "0" + LSET$(wProf, 50)        ' Save an OFF entry
            FUNCTION = %False: EXIT FUNCTION                      ' Return False
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Profile exists, have a look at it                                                      |
         '-----------------------------------------------------------------------------------------+
         j = VAL(gSQL.GetStringDirect("P" + wProf, "StateFlag", "0"))   ' Get the STATE value
         GOSUB BumpNumber                                         ' Bump number saved
         ProfTable(ProfNumber) = FORMAT$(j) + LSET$(wProf, 50)    ' Save the entry
         FUNCTION = j                                             ' Return the answer

      CASE ELSE                                                   ' ??
         FUNCTION = %False                                        '
   END SELECT                                                     '
   EXIT FUNCTION                                                  '
   BumpNumber:                                                    '
   INCR ProfNumber                                                '
   IF ProfNumber > UBOUND(ProfTable()) THEN                       '
      REDIM PRESERVE ProfTable(1 TO 2 * UBOUND(ProfTable())) AS STATIC STRING * 51  '
   END IF                                                         '
   RETURN                                                         '
END FUNCTION                                                      '

FUNCTION ReadCodePageSource(CP AS CodePage_CP_T, SOURCE_ID AS STRING) AS LONG '
'--------------------------------------------------------------------------------------------------+
'-  Read_CodePage_Source_File                                                                      |
'-                                                                                                 |
'-  Locate and read a .SOURCE file; Source_ID is base name like "EBCDIC"                           |
'-  Return 1 if read successful, else 0                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL BUF, SOURCE_FILE_Name AS STRING                             '
LOCAL SOURCE_FILE, RETCODE  AS LONG                               '
   SOURCE_FILE_Name = gENV.HomeFolder + SOURCE_ID + ".SOURCE"     '
   IF ISFILE (SOURCE_FILE_Name) THEN                              '
      InitCodePage (CP)                                           '
      SOURCE_FILE = FREEFILE                                      '
      OPEN SOURCE_FILE_Name FOR INPUT ACCESS READ AS # SOURCE_FILE   '
      DO WHILE ISFALSE EOF (SOURCE_FILE)                          '
         CP.CP_LineNo += 1                                        '
         LINE INPUT # SOURCE_FILE, BUF                            '
         BUF = TRIM$(BUF)                                         '
         IF BUF = "" THEN ITERATE DO                              '  Line is blank
         IF LEFT$(BUF, 1) = "*" THEN ITERATE DO                   '  Line is comment
         IF MID$(BUF, 2, 1) = "*" THEN ITERATE DO                 '  Line is comment

         '-----------------------------------------------------------------------------------------+
         '-  When the logical-EOF action code // is read, we stop reading                          |
         '-  the file.  The rest of the XX line is ignored, as is any other                        |
         '-  data following the XX line, which can be used for comments.                           |
         '-----------------------------------------------------------------------------------------+
         IF LEFT$(BUF, 2) = "//" THEN                             '  Logical EOF reached on file
            EXIT DO                                               '
         END IF                                                   '
         ParseCodePageSourceLine (CP, BUF)                        '
      LOOP                                                        '
      CLOSE # SOURCE_FILE                                         '
      RETCODE = ValidateCodepageData (CP)                         '  Return 1 if valid, else 0
      FUNCTION = RETCODE                                          '
      EXIT FUNCTION                                               '
   END IF                                                         '
   FUNCTION = 0                                                   '  Failure processing source file
END FUNCTION                                                      ' ReadCodePageSource

FUNCTION RegistryGet(BYVAL sSubKeys AS STRING, BYVAL sValueName AS STRING, BYVAL sDefault AS STRING) AS STRING '
'--------------------------------------------------------------------------------------------------+
'- Get a key from the Registry                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lKey AS DWORD, zRegVal AS ASCIIZ * 1024, dwType AS DWORD, dwSize AS DWORD  '
   zRegVal = sDefault                                             '
   IF (RegOpenKeyEx(%HKEY_CURRENT_USER, TRIM$(sSubKeys, "\"), 0, %KEY_READ, lKey) = %ERROR_SUCCESS) THEN '
      dwType = %REG_SZ                                            '
      dwSize = SIZEOF(zRegVal)                                    '
      RegQueryValueEx(lKey, BYCOPY sValueName, 0, dwType, zRegVal, dwSize) '
      RegCloseKey lKey                                            '
   END IF                                                         '
   FUNCTION = zRegVal                                             '
END FUNCTION                                                      '

FUNCTION RegistrySet(BYVAL sSubKeys AS STRING, BYVAL sValueName AS STRING, BYVAL sData AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Set a key into the Registry                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lKey AS DWORD, zRegName AS ASCIIZ * 1024, zRegVal AS ASCIIZ * 1024, dwType AS DWORD, dwSize AS DWORD  '
   zRegVal = sData                                                '
   zRegName = sValueName                                          '
   IF RegCreateKeyEx(%HKEY_CURRENT_USER, TRIM$(sSubKeys, "\"), 0, "", 0, %KEY_WRITE, BYVAL %Null, _   '
                     lKey, BYVAL %Null) = %ERROR_SUCCESS THEN     '
      dwSize = SIZEOF(zRegVal)                                    '
      dwType = %REG_SZ                                            '
      IF RegSetValueEx(lKey, zRegName, 0, dwType, zRegVal, dwSize) = %ERROR_SUCCESS THEN FUNCTION = %True   '
      RegCloseKey lKey                                            '
   END IF                                                         '
END FUNCTION                                                      '

SUB      ScreenPrint                                              '
'--------------------------------------------------------------------------------------------------+
'- Handle the Print Screen Requests                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL f, i, j AS LONG, fn, CBD, d, MSG AS STRING                  '
   '-----------------------------------------------------------------------------------------------+
   '- Split off based on which type called for                                                     |
   '-----------------------------------------------------------------------------------------------+
   MEntry                                                         '
   SELECT CASE AS CONST$ gKeyChr                                  ' Which flavour of PRT did we get
      CASE "PRTSCRNCLIPBOARD", "PRTTEXTCLIPBOARD"                 ' Plain Print or Data Print to Clipboard
         GOSUB PrtClipBoard                                       ' Go do it
      CASE "PRTSCRNPRINTER"                                       ' Print to default printer
         GOSUB PrtPrinter                                         ' Go do it
      CASE "PRTSCRNLOG"                                           ' Print to SPFLite.LOG (append)
         GOSUB PrtLog                                             '
   END SELECT                                                     '
   MExitSub                                                       '

'--------------------------------------------------------------------------------------------------+
'- Print to the Clipboard                                                                          |
'--------------------------------------------------------------------------------------------------+
PRTClipBoard:                                                     '
   '-----------------------------------------------------------------------------------------------+
   '- Build the Clipboard string                                                                   |
   '-----------------------------------------------------------------------------------------------+
   CBD = ""                                                       ' Start as ""
   IF gKeyChr = "PRTSCRNCLIPBOARD" THEN                           ' Do full screen dump
      FOR i = TP.gPTop TO TP.gPBottom                             ' Loop through the screen image
         CBD += TP.ScreenGet(i) + $CR + $LF                       ' Add each line with CR/LF
      NEXT x                                                      '
   ELSE                                                           ' Do data lines only
      FOR i = TP.gpData1 TO TP.gPBottom                           ' Loop through the screen data lines
         CBD += MID$(TP.ScreenGet(i), 8) + $CR + $LF              ' Add each line with CR/LF
      NEXT x                                                      '
   END IF                                                         '
   CBD += $NUL                                                    ' ASCIIZ terminate it

   j = ClipBoardSet(CBD)                                          ' Send print data to the Clipboard

   IF ISTRUE j THEN                                               ' OK?
      IF gKeyChr = "PRTTEXTCLIPBOARD" THEN                        ' Issue appropriate message
         MSG = "Data lines sent to Clipboard"                     '
         GOSUB PrtErrMsg                                          ' Issue locally since we're not in KBAttn mode
      ELSE                                                        '
         MSG = "Print Screen Image sent to Clipboard"             '
         GOSUB PrtErrMsg                                          ' Issue locally since we're not in KBAttn mode
      END IF                                                      '
   ELSE                                                           '
      MSG = "Print Screen failed"                                 '
      GOSUB PrtErrMsg                                             ' Issue locally since we're not in KBAttn mode
   END IF                                                         '
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Print to the Printer                                                                            |
'--------------------------------------------------------------------------------------------------+
PRTPrinter:                                                       '
   IF ISFALSE PrinterOpen("") THEN                                ' Get printer ready if not already
      MSG = "OPEN of Printer failed"                              ' Oops!
      GOSUB PrtErrMsg                                             ' Issue locally since we're not in KBAttn mode
   ELSE                                                           '
      gPrtRaw = %True                                             ' Say no headings etc.
      PrinterPrint(%PRTReset, " ", " ", %False)                   ' Tell PrinterPrint to reset
      FOR i = TP.gPTop TO TP.gPBottom                             ' Loop through the screen image
         PrinterPrint(%PRTLine, TP.ScreenGet(i), $$TxtHi, %False) ' Print each screen line
         PrinterPrint(%PRTNewLine, " ", " ", %False)              ' New Line
      NEXT i                                                      '
      PrinterPrint(%PRTFlushClose, " ", ",", %False)              ' Tell PrinterPrint to flush page
      gPrtRaw = %False                                            ' Turn off Raw mode print
      MSG = "Screen Image sent to Default Printer"                '
      GOSUB PrtErrMsg                                             ' Issue locally since we're not in KBAttn mode
   END IF                                                         '
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Print to the LOG file                                                                           |
'--------------------------------------------------------------------------------------------------+
PRTLog:                                                           '
   f = FREEFILE                                                   ' Get a free file number
   fn = gENV.HomeFolder + "SPFLiteScrPrt.LOG"                     ' Make full name of the log file
   OPEN fn FOR APPEND AS #f                                       ' Go open it
   FOR i = TP.gPTop TO TP.gPBottom                                ' Loop through the screen image
      PRINT#f, TP.ScreenGet(i)                                    ' Print each screen line
   NEXT i                                                         '
   CLOSE#f                                                        ' Close the file
   MSG = "Screen Image sent to SPFLiteScrPrt.LOG"                 '
   GOSUB PrtErrMsg                                                ' Issue locally since we're not in KBAttn mode
   RETURN                                                         '

PRTErrMsg:                                                        '
      d = STRING$(gENV.ScrWidth - LEN(MSG), "_")                  ' Build LH part of dash line
      DoPrint (d, $$TxtLo, 2, 1)                                  ' Print LH part of line 2
      DoPrint (MSG, $$Error, 2, gENV.ScrWidth - LEN(MSG) + 1)     ' Print rest of line
   RETURN                                                         '
END SUB                                                           '

FASTPROC SetCmd()                                                 ' Put cursor at Command line
   TP.CsrRow = TP.gPTop: TP.CsrCol = TP.gPCmdCol                  '
   TP.CsrMode                                                     '
END FASTPROC                                                      '

FUNCTION SetDim(iFG AS LONG, iBG AS LONG) AS LONG                 '
'---------------------------------------------------------------------------------------------------+
'- Set a Dimmed version of a foreground color. Inputs are the normal FG/BG colors                   |
'---------------------------------------------------------------------------------------------------+
LOCAL uFG, uBG AS CUnion, cRED, cGREEN, cBLUE, FGWeight, BGWeight AS LONG  '
   IF TP.P = TP.PPActive THEN                                     ' Doing Active panel?
      GRAPHIC COLOR iFG, iBG                                      ' Just set FG/BG
   ELSE                                                           ' Otherwise fudge FG to show Inactive
      FGWeight = 10: BGWeight = 15                                ' Set FG / BG weights (How Dim to make it)
      uFG.RGB = iFG: uBG.RGB = iBG                                ' Copy params to UNION (To access r g uBG values)
      cRED = (uFG.r * FGWeight + uBG.r * BGWeight)      \ (FGWeight + BGWeight)  ' Now recalc FG colors to dim it
      cGREEN = (uFG.g * FGWeight + uBG.g * BGWeight)    \ (FGWeight + BGWeight)  '
      cBLUE = (uFG.b * FGWeight + uBG.b * BGWeight)     \ (FGWeight + BGWeight)  '
      GRAPHIC COLOR RGB(cRED, cGREEN, cBLUE), iBG                 ' Set the adjusted FG/BG colors
   END IF                                                         '
END FUNCTION                                                      '

FASTPROC SetScrl()                                                ' Put cursor at Scroll Amount
   TP.CsrRow = TP.gPTop: TP.CsrCol = TP.gPScrData                 '
END FASTPROC                                                      '

SUB SetPanel(r AS LONG, c AS LONG)                                '
LOCAL P2col, lclR, lclC AS LONG
'--------------------------------------------------------------------------------------------------+
'-  Ensure P matches the specified screen row / col                                                |
'--------------------------------------------------------------------------------------------------+
   lclR = r: lclC = c                                             ' Get local copies of r/c
   IF TP.HPanelSplit <> 0 THEN                                    ' Are we in Horizontal split mode?
      IF lclR <= TP.HPanelSplit THEN                              ' In P1 area?
         IF ISFALSE TP.IsP1 THEN TP.PPSetP1                       ' If not P1, switch it
      ELSE                                                        ' We're in P2
         IF ISFALSE TP.IsP2 THEN TP.PPSetP2                       ' If not P2, switch it
      END IF                                                      '
   END IF                                                         '
   IF TP.VPanelSplit <> 0 THEN                                    ' Are we in Vertical split mode?
      IF lclC < TP.VPanelSplit THEN                               ' In P1 area?
         IF ISFALSE TP.IsP1 THEN TP.PPSetP1                       ' If not P1, switch it
      ELSE                                                        ' If we're going to P2 vertical - need to adjust CsrCol
         P2Col = lclC - TP.GP2Left                                ' Calc current logical column in P2
         IF ISFALSE TP.IsP2 THEN TP.PPSetP2                       ' If not P2, switch it
         lclc = TP.GP2Left + P2Col                                ' Adjust the real cursor position to keep it the same
      END IF                                                      '
   END IF                                                         '
   IF lclR <> 0 AND lclC <> 0 THEN TP.CsrRow = lclR: TP.CsrCol = lclC ' Stuff in the row/col if a full pair of R,C
END SUB                                                           '

FUNCTION SETReturnNumber(BYVAL var_name AS STRING) AS LONG        '
'--------------------------------------------------------------------------------------------------+
'-  fetch the value of named SET symbol, and convert to numeric.                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL set_symbol AS STRING, RCA AS RCArea                         '
   SETTableUpd("GET", var_name, RCA)                              '
   FUNCTION = IIF(RCA.RC = 0, VAL(RCA.Msg), 0)                    '
END FUNCTION                                                      '

SUB SETTableUpd(cmd AS STRING, operand AS STRING, RCA AS RCArea)  '
'--------------------------------------------------------------------------------------------------+
'- Handle updates to the SET table                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL key, tdata AS STRING, i AS LONG                             '
   SELECT CASE AS CONST$ cmd                                      ' Which kind do we have

      CASE "GET"                                                  ' GET (fetch)
         IF gSetCount > 0 THEN                                    ' Anything in table?
            ARRAY SCAN gSetKey(), COLLATE UCASE, =operand, TO i   ' Can we find the key?
            IF i = 0 THEN AnswerSub(8, "Unknown SET variable")    ' Exit
            AnswerSub(0, TRIM$(gSetData(i)))                      ' Return the data item
         ELSE                                                     '
            AnswerSub(8, "Unknown SET variable")                  ' Fail it
         END IF                                                   '

      CASE "DEL"                                                  ' DEL
         IF gSetCount > 0 THEN                                    ' Anything in table?
            ARRAY SCAN gSetKey() FOR gSetCount, COLLATE UCASE, =operand, TO i ' Can we find the key?
            IF i = 0 THEN AnswerSub(8, "Unknown SET variable")    ' Fail it
            ARRAY DELETE gSetKey(i)                               ' Delete it
            ARRAY DELETE gSetData(i)                              '
            DECR gSetCount                                        '
            '--------------------------------------------------------------------------------------+
            '- Do it from Raw                                                                      |
            '--------------------------------------------------------------------------------------+
            FOR i = 1 TO gSetRawCtr                               ' Search
               IF UCASE$(operand) = UCASE$(LEFT$(gSetRaw(i), LEN(operand))) THEN ' We found it
                  ARRAY DELETE gSetRaw(i)                         ' Delete it
                  DECR gSetRawCtr                                 ' reduce count
               END IF                                             '
            NEXT i                                                '
            SETTableWrite                                         ' Write the table
            AnswerSub(0, "SET variable removed")                  ' Say we're done
         ELSE                                                     '
            AnswerSub(8, "Unknown SET variable")                  ' Fail it
         END IF                                                   '

      CASE "SET"                                                  ' SET
         key = LEFT$(operand, INSTR(operand, " ") - 1)            ' Separate key and data
         tdata = MID$(operand, INSTR(operand, " ") + 1)           '
         IF VERIFY(LEFT$(Key, 1), $Numeric + ".") = 0 THEN _      ' No leading numbers or period
            AnswerSub(8, "Invalid characters in SET variable name.") ' Fail it

         i = 0                                                    ' Pretend not found
         IF gSetCount > 0 THEN                                    ' An existing table?
            ARRAY SCAN gSetKey(), COLLATE UCASE, =key, TO i       ' Can we find the key?
         END IF                                                   '
         IF i > 0 THEN                                            ' Already exist?
            gSetData(i) = tdata                                   ' Replace data
         ELSE                                                     '
            INCR gSetCount                                        ' Bump
            IF gSetCount > UBOUND(gSetKey()) THEN                 ' Add space if needed
               REDIM PRESERVE gSetKey(1 TO UBOUND(gSetKey()) * 2) AS STRING   '
               REDIM PRESERVE gSetData(1 TO UBOUND(gSetData()) * 2) AS STRING '
            END IF                                                '
            gSetKey(gSetCount) = key                              ' Doesn't exist, build a new item
            gSetData(gSetCount) = tdata                           '
         END IF                                                   '
         ARRAY SORT gSetKey() FOR gSetCount, TAGARRAY gSetData()  '
         '-----------------------------------------------------------------------------------------+
         '- Now do the Raw version                                                                |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO gSetRawCtr                                  ' Search
            IF UCASE$(key) = UCASE$(LEFT$(gSetRaw(i), LEN(key))) THEN   ' We found it
               gSetRaw(i) = key + "=" + tdata                     ' Update it
               GOTO GoWrite                                       ' Done
            END IF                                                '
         NEXT i                                                   '

         INCR gSetRawCtr                                          ' add to the end
         REDIM PRESERVE gSetRaw(1 TO gSetRawCtr) AS GLOBAL STRING ' Expand table
         gSetRaw(gSetRawCtr) = key + "=" + tdata                  ' Add it

         GoWrite:                                                 '
         SETTableWrite                                            ' Write the table
         AnswerSub(0, "SET variable stored")                      ' Setup return

   END SELECT                                                     '
END SUB                                                           '

SUB      SETTableWrite()                                          '
'--------------------------------------------------------------------------------------------------+
'- Re-write the SET table                                                                          |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF gSetRawCtr > 0 THEN                                         ' Only if there are entries
      SQLArraySave(gSQL.SetName, gSetRaw())                       ' Let SQLArraySave do the work
   ELSE                                                           ' Nothing?
      gSQL.TableClear(gSQL.SetName)                               ' Clear old contents
      gSQL.SetString("S", "R00000", "0")                          ' Write a zero count record
   END IF                                                         '
   MExit                                                          '
END SUB                                                           '

FUNCTION SortTouchTableExit(pt1 AS TouchEntry, pt2 AS TouchEntry) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Support sort of the FMFiles array                                                               |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF pt1.LinNo < pt2.LinNo THEN FUNCTION = -1: MExitFunc         '
   IF pt1.LinNo > pt2.LinNo THEN FUNCTION = +1: MExitFunc         '
   FUNCTION = 0                                                   '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION SizeLarge(vl AS QUAD) AS STRING                          '
'--------------------------------------------------------------------------------------------------+
'- Make a 15 char 'pretty' size field                                                              |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = RSET$(FORMAT$(vl, "0,"), 15)                        ' Simple FORMAT$
END FUNCTION                                                      '

FUNCTION SizeSmall(vl AS QUAD) AS STRING                          '
'--------------------------------------------------------------------------------------------------+
'- Make a 6 char 'pretty'- size field                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   SELECT CASE AS vl                                              ' Select which format
      CASE < 1000:          t = FORMAT$(vl, "* ####"): FUNCTION = IIF$(t = "     0", "      ", t)  '
      CASE < 1048576:       FUNCTION = FORMAT$(vl / 1024, "* #.0\K") '
      CASE < 1073741824:    FUNCTION = FORMAT$(vl / 1048576, "* #.0\M") '
      CASE ELSE:            FUNCTION = FORMAT$(vl / 1073741824, "* #.0\G") '
   END SELECT                                                     '
END FUNCTION                                                      '

FUNCTION SourceLoad(TblName AS STRING, A2S AS STRING, S2A AS STRING) AS LONG  '
'--------------------------------------------------------------------------------------------------+
'- Load a specified SOURCE table                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL CP AS CODEPAGE_CP_T                                         ' CODEPAGE data
LOCAL TX_TABLE_PTR AS STRING PTR * 256                            '
LOCAL Fn AS STRING                                                '
   MEntry                                                         '
                                                                  '
   Fn = gENV.HomeFolder + TblName + ".SOURCE"                     ' Build the filename
   FUNCTION = %True                                               ' Start off as all is well
   IF ISFILE(Fn) THEN                                             ' See if the Customized file exists
      IF ISFALSE ReadCodePageSource(CP, TblName) THEN             ' Go read the SOURCE file
         DoMessageBox "|K" + Fn + "|B failed validation, Null translate tables will be used", %MB_OK OR %MB_USERICON, "SPFLite"  '
         FUNCTION = %False: MExitFunc                             '
      END IF                                                      '

      TX_TABLE_PTR = VARPTR (CP.TX(%AE_MODE).TX_TABLE (0))        ' Pick up pointer to table
      A2S = @TX_TABLE_PTR                                         ' Pass it back
      TX_TABLE_PTR = VARPTR (CP.TX(%EA_MODE).TX_TABLE (0))        ' Now the reverse
      S2A = @TX_TABLE_PTR                                         '

   ELSE                                                           ' Else build two 'do nothing' translate tables
      DoMessageBox "|K" + Fn + "|B was not found, Null translate tables will be used", %MB_OK OR %MB_USERICON, "SPFLite"   '
      FUNCTION = %False                                           '
   END IF                                                         '
   MExit                                                          ' We're done
END FUNCTION                                                      '

SUB SpellCheck(sWord AS STRING, sugg() AS STRING, RCA AS RCUser)  '
'--------------------------------------------------------------------------------------------------+
'- Pass a 'word' to HunSpell to spell check and retrieve suggestions                               |
'--------------------------------------------------------------------------------------------------+
LOCAL FNum AS LONG                                                '
LOCAL slist AS DWORD PTR, t, Wd, UTF8Str, lclLang AS STRING       '
LOCAL Suggestion AS STRINGZ PTR                                   '
LOCAL pSuggestion AS DWORD                                        '
LOCAL pSuggestionList AS DWORD PTR                                ' Pointer to the list of suggestions
LOCAL szWord AS STRINGZ * %MAX_PATH, RC, i, j AS LONG             '
   lclLang = IIF$(ISNULL(gSpellCountry), gENV.LANG, gSpellCountry)   ' Get the country code

   '-----------------------------------------------------------------------------------------------+
   '- See if this is the LANG xx call                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF RCA.RC = 456 THEN                                           ' The 'magic' add call?
      IF ghHunSpell <> 0 THEN                                     ' Do we have Hunspell active?
         RCA.RC = 0: Hunspell_destroy(ghHunspell)                 ' Destroy it
         ghHunSpell = 0                                           ' Clear handle
      END IF                                                      '
      EXIT SUB                                                    ' We're done
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Fire up HunSpell if we don't have a current handle                                           |
   '-----------------------------------------------------------------------------------------------+
   IF ghHunspell = 0 THEN                                         ' Need to OPEN?
      IF ISNULL(lclLANG) THEN _                                   ' LANG specified?
         RCA.Msg = "No LANG specified in Options => General": RCA.RC = 2: EXIT SUB  '

      IF ISFALSE ISFILE(gENV.HomeData + "index-" + lclLang + ".aff") OR _  '
         ISFALSE ISFILE(gENV.HomeData + "index-" + lclLang + ".dic") THEN _   '
         RCA.Msg = "Dictionary files do not exist": RCA.RC = 2: EXIT SUB   '

      ghHunspell = Hunspell_create(gENV.HomeData + "index-" + lclLang + ".aff", _   '
                                   gENV.HomeData + "index-" + lclLang + ".dic")  '
      IF ghHunspell = 0 THEN RCA.Msg = "Dictionary files failed to Open": RCA.RC = 2: EXIT SUB  '
      IF ISFILE(genv.HomeData + "User-" + lclLang + ".Dic") THEN  ' If there's a User dictionary, load it
         FNum = FREEFILE                                          ' Get a file #
         OPEN genv.HomeData + "User-" + lclLang + ".Dic" FOR INPUT AS FNum ' Open the file
         WHILE NOT EOF(FNum)                                      ' Process it
            LINE INPUT #FNum, t                                   ' Get a word
            IF LEN(t) > 0 THEN                                    ' Eliminate nulls
               szword = t: Hunspell_Add(ghHunspell, szword)       ' Add the word
            END IF                                                '
         WEND                                                     '
         CLOSE FNum                                               ' Done
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Strip punctuation and adjust for length changes                                              |
   '-----------------------------------------------------------------------------------------------+
   Wd = REMOVE$(sword, ANY $DQ + ",.;:()[]{}!?")                  ' Cleanup
   StrUnquote(Wd)                                                 '
   IF LEN(sword) <> LEN(wd) THEN                                  ' Any need to adjust?
      RCA.User1 = INSTR(sword, wd) - 1                            ' Adjustment for Col. #
      RCA.User2 = LEN(sword) - LEN(wd)                            ' Adjustment for length of the word
   ELSE                                                           ' Else no difference
      RCA.User1 = 0: RCA.User2 = 0                                ' Reset adjustment values
   END IF                                                         '
   szword = StrAnsi2Utf8(wd)                                      ' Make STRINGZ -> UTF8

   '-----------------------------------------------------------------------------------------------+
   '- See if this is the Add() word call                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF RCA.RC = 123 OR RCA.RC = 122 THEN                           ' The 'magic' add types?
      IF szword = "" THEN RCA.RC = 0: EXIT SUB                    ' Null call? (to open files) - Exit
      IF RCA.RC = 123 THEN                                        ' A USER add?
         IF ISFALSE ISFILE(gEnv.HomeData + "User-" + lclLANG + ".Dic") THEN   ' First User dictionary word?
            FNum = FREEFILE: OPEN gEnv.HomeData + "User-" + lclLANG + ".Dic" FOR OUTPUT AS FNum: CLOSE FNum '
         END IF                                                   '
         FNum = FREEFILE: OPEN gEnv.HomeData + "User-" + lclLANG + ".Dic" FOR APPEND AS FNum: PRINT #FNum, szword: CLOSE FNum '
      END IF                                                      '
      RCA.RC = Hunspell_add(ghHunspell, szword)                   ' Add to Hunspell memory data
      EXIT SUB                                                    ' Pass back the RC
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Not an Add, do a spell check                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF LEN(szWord) < 2 THEN RCA.Msg = "": RCA.RC = 0: EXIT SUB     ' If tiny, just say OK
   RC = Hunspell_spell(ghHunspell, szWord)                        ' Check the word
   IF rc THEN RCA.Msg = "": RCA.RC = 0: EXIT SUB                  ' If OK, say so
   RC = Hunspell_suggest(ghHunspell, BYVAL VARPTR(pSuggestionList), szWord)   ' If not, ask for suggestions
   IF RC = 0 THEN                                                 ' None?
      Hunspell_free_list(ghHunspell, BYVAL VARPTR(pSuggestionList), RC) ' Cleanup
      RCA.Msg = "Misspelled: " + sword: RCA.RC = 2: EXIT SUB      ' And fail it
   END IF                                                         '
   slist = pSuggestionList                                        ' Swap pointer
   REDIM sugg(0 TO RC - 1)                                        ' Redim the answer array
   FOR i = 0 TO RC - 1                                            ' Pass back the suggestions
      pSuggestion = @slist[i]                                     '
      Suggestion = pSuggestion                                    '
      t = @Suggestion                                             ' Fetch as UTF8 string
      sugg(i) = TRIM$(StrUtf82Ansi(t, j))                         ' Back to ANSI
   NEXT i                                                         '
   Hunspell_free_list(ghHunspell, BYVAL VARPTR(pSuggestionList), RC) ' Cleanup
   RCA.Msg = "Misspelled: " +  sword + " is miss-spelled, suggestions returned": RCA.RC = 1: EXIT SUB ' Say there's a suggestion list
END SUB                                                           ' Return the suggestions

SUB      SQLArrayLoad(sTable AS STRING, tArray() AS STRING, tCtr AS LONG)  '
'--------------------------------------------------------------------------------------------------+
'- Load an array from an SQL Table                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, DoOnce AS LONG                                     '
   gSQL.SelBegin("select * FROM " + $DQ + sTable + $DQ)           ' Ask for everything
   IF gSQL.SelFirst() THEN                                        ' Select the first
      IF ISFALSE DoOnce THEN                                      ' One time stuff
         DoOnce = %True                                           '
         j = VAL(gSQL.SelGet("DBData"))                           ' Get the count
         tCtr = j                                                 ' Return it
         IF j THEN                                                ' Non-zero?
            REDIM tArray(1 TO j) AS GLOBAL STRING                 ' REDIM array the correct size
         ELSE                                                     '
            REDIM tArray(1 TO 1) AS GLOBAL STRING                 ' REDIM a null array
         END IF                                                   '
      END IF                                                      '

      DO WHILE gSQL.SelNext()                                     ' Loop through them
         INCR i                                                   ' Count the line
         IF i > j THEN EXIT DO                                    ' Excess records, ignore them
         tArray(i) = gSQL.SelGet("DBData")                        ' Get and save the the record
      LOOP                                                        '
      IF i < j THEN                                               ' Less than specified number?
         FOR k = i + 1 TO j                                       ' Fill in nulls
            tArray(k) = ""                                        '
         NEXT k                                                   '
      END IF                                                      '
   ELSE                                                           '
      REDIM tArray(1 TO 1) AS GLOBAL STRING                       ' REDIM an empty array
      tCtr = 0                                                    ' Set Ctr to 0
   END IF                                                         '
   gSQL.SelEnd                                                    ' Close the SQL request
END SUB                                                           '

SUB      SQLArraySave(sTable AS STRING, tArray() AS STRING)       '
'--------------------------------------------------------------------------------------------------+
'- Save an array as an SQL Table                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL tID AS STRING, i AS LONG                                    '
    '----------------------------------------------------------------------------------------------+
                                                                  ' Write the table out
    '----------------------------------------------------------------------------------------------+
    tID = LEFT$(sTable, 1)                                        ' Get table type
    gSQL.Execute("PRAGMA synchronous = OFF")                      ' To optimize things

    gSQL.TableClear(sTable)                                       ' Clear the existing table
    gSQL.AddString(tID, "R00000", FORMAT$(UBOUND(tArray())))      ' Write the Total # entries
    FOR i = 1 TO UBOUND(tArray())                                 ' Dump the Table
       gSQL.AddString(tID, "R" + FORMAT$(i, "00000"), tArray(i))  '
    NEXT i                                                        '
    gSQL.Execute("PRAGMA synchronous = ON")                       '
END SUB                                                           '

SUB      StatusBarDrawItem (BYVAL HDlg AS     DWORD, BYVAL LPARAM AS LONG) '
'--------------------------------------------------------------------------------------------------+
'- Ownerdraw for StatusBar                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lpdis AS DRAWITEMSTRUCT PTR, rc, rc2 AS RECT                '
LOCAL zp AS ASCIIZ PTR, stxt AS ASCIIZ * 64                       '
LOCAL Brush AS DWORD                                              '
LOCAL ALIGN, i, j, k AS LONG                                      '
   MEntry                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get access to what's going on                                                                |
   '-----------------------------------------------------------------------------------------------+
   IF HDlg = 0 OR LPARAM = 0 THEN MexitSub                        ' Bail out if passed zeros
   lpdis = LPARAM                                                 ' Get DrawItemStruct addressable
   rc = @lpdis.rcItem                                             ' Get box RECT
   zp = @lpdis.itemData                                           ' Get text addressable
   i = VAL(@zp)                                                   ' Get SBTable entry number from 1st two chars
   IF i < 1 OR i > gSBCount THEN MExitSub                         ' In range?
   stxt = TRIM$(gWSBTable(i).SBText)                              ' Pickup the text

   '-----------------------------------------------------------------------------------------------+
   '- Create the BG and position bar brushes                                                       |
   '-----------------------------------------------------------------------------------------------+
   Brush = CreateSolidBrush(gWSBTable(i).SBBG)                    ' Brush for the background
   FillRect @lpdis.hDC, rc, Brush                                 ' Fill the background
   DeleteObject Brush                                             '
   SetBkColor @lpdis.hDC, gWSBTable(i).SBBG                       ' Set BG for text printing
   SetTextColor @lpdis.hDC, gWSBTable(i).SBFG                     ' Set the text color

   '-----------------------------------------------------------------------------------------------+
   '- Set alignment differently for some boxes                                                     |
   '-----------------------------------------------------------------------------------------------+
   ALIGN = %DT_CENTER                                             '
   IF gWSBTable(i).SBAlign = "L" THEN ALIGN =%DT_LEFT: rc.left = rc.left + 5  ' Pad the left side a bit

   '-----------------------------------------------------------------------------------------------+
   '- Finally draw the text                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE IsFMTab THEN                                        ' If not FM
      IF gWSBTable(i).SBPosBar = "Y" AND TP.LastLine > TP.gPBottom - 3 THEN   ' Is this the Misc box and # lines > screen height?
         rc2 = rc                                                 ' Get Alternate RC area
         Brush = CreateSolidBrush(gWSBTable(i).SBBG XOR &H00FFFFFF)  ' Brush for position bar
         k = rc2.Right - rc2.Left                                 ' Get width of box
         i = MAX(INT((TP.gPDLines / MAX(TP.LastLine, TP.gPDLines)) * k), 5)   ' Length of bar (min 5)
         j = MIN(INT((TP.GPTopLine / MAX(TP.LastLine, TP.gPDLines)) * k), k - i)  ' Starting pos
         rc2.Left += j: rc2.Right = rc2.Left + i: rc2.Top = rc2.Bottom - 5 ' Width / Height
         FillRect @lpdis.hDC, rc2, Brush                          ' Draw box for relative file position
         DeleteObject Brush                                       '
         SetBkMode @lpdis.hDC, %Transparent                       '
      END IF                                                      '
   ELSE                                                           ' FM Version
      IF gWSBTable(i).SBPosBar = "Y" AND gFMDCtr > TP.gPDLines - 7 THEN ' Is this the Misc box and # lines > screen height?
         rc2 = rc                                                 ' Get Alternate RC area
         Brush = CreateSolidBrush(gWSBTable(i).SBBG XOR &H00FFFFFF)  ' Brush for position bar
         k = rc2.Right - rc2.Left                                 ' Get width of box
         i = MAX(INT((TP.gPDLines / MAX(gFMDCtr, TP.gPDLines)) * k), 5) ' Length of bar (min 5)
         j = MIN(INT((TP.GPTopLine / MAX(gFMDCtr, TP.gPDLines)) * k), k - i)   ' Starting pos
         rc2.Left += j: rc2.Right = rc2.Left + i: rc2.Top = rc2.Bottom - 5 ' Width / Height
         FillRect @lpdis.hDC, rc2, Brush                          ' Draw box for relative file position
         DeleteObject Brush                                       '
         SetBkMode @lpdis.hDC, %Transparent                       '
      END IF                                                      '
   END IF                                                         '
   DrawText @lpdis.hDC, stxt, LEN(stxt), rc, %DT_SINGLELINE OR ALIGN '
  MExit                                                           '
END SUB                                                           '

SUB StatusBarSetup()                                              '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL k, lgth AS LONG                                             '
LOCAL t AS STRING                                                 '
DIM SBParse(1 TO 16) AS STRING                                    '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Create the Working table                                                                     |
   '-----------------------------------------------------------------------------------------------+
   RESET gWSBTable()                                              ' Reset working table
   gSBCount = 0                                                   ' Reset count

   '-----------------------------------------------------------------------------------------------+
   '- Get SB box widths                                                                            |
   '-----------------------------------------------------------------------------------------------+
   GRAPHIC ATTACH TP.PgHandle, TP.WindowID                        ' Use our normal GRAPHIC window
   GRAPHIC SET FONT gSBFont                                       ' Set the SB font

   t = gENV.SBLayout + ",PAD"                                     ' Ensure PAD at the end
   IF IsFMTab THEN t = "MODE,LINNO,INSOVR,CASE,MISC,LAYOUT,PAD"   ' FM gets a fixed set of fields

   '-----------------------------------------------------------------------------------------------+
   '- Reset Assigned in Master to point @ dummy entry                                              |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO 16                                                ' Spin through
      gSBTable(i).SBAssigned = 17                                 ' Point at the dummy slot
   NEXT i                                                         '

   k = PARSECOUNT(t)                                              ' Get number of entries
   PARSE t, SBParse()                                             ' Break it into pieces
   FOR i = 1 TO k                                                 ' Process each entry
      lgth = 0                                                    ' Start with no overriding length
      t = SBParse(i)                                              ' Get the operand
      j = INSTR(t, "(")                                           ' See if an (nn) suffix
      IF j THEN                                                   ' If so
         lgth = VAL(MID$(t, j + 1))                               ' Extract length
         t = LEFT$(t, j - 1)                                      ' Strip it off
      END IF                                                      '
      t = LSET$(t, 6)                                             ' Make name 6 chars
      FOR j = 1 TO 16                                             ' Find name in table
         IF t = gSBTable(j).SBName THEN                           ' Found it
            INCR gSBCount                                         ' Bump our TP count
            IF t = "SELECT" THEN gSBSelect = gSBCount - 1         ' Remember box # for the CallBack Mouse Click
            IF t = "LAYOUT" THEN gSBLFlip  = gSBCount - 1         '
            IF lgth THEN gSBTable(j).SBMaxTxt = lgth              ' Swap in overriding length
            gSBTable(j).SBWidth = (GRAPHIC(TEXT.SIZE.X, REPEAT$(gSBTable(j).SBMaxTxt, "X"))) * 1.00   ' Width
            gWSBTable(gSBCount) = gSBTAble(j)                     ' Copy the master table data
            gSBTable(j).SBAssigned = gSBCount                     ' Master points to working
            EXIT FOR                                              ' We're done this entry
         END IF                                                   '
      NEXT j                                                      '
   NEXT i                                                         ' Onward to next KW
   GRAPHIC SET FONT gScrFont                                      ' Set the normal Font back

   '-----------------------------------------------------------------------------------------------+
   '- Now set the StatusBar itself to the right sizes                                              |
   '-----------------------------------------------------------------------------------------------+
   i = gSBCount                                                   '
   CONTROL SET SIZE ghWnd, %IDC_StatusBar, gSBWidth, gSBHeight    ' Set the SB size
   SELECT CASE i                                                  ' Pick the one that matches the count
      CASE 1: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, 9999 '
      CASE 2: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, 9999 '
      CASE 3: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, 9999 '
      CASE 4: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, 9999 '
      CASE 5: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, 9999 '
      CASE 6: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, 9999 '
      CASE 7: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, 9999 '
      CASE 8: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, 9999 '
      CASE 9: STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, 9999 '
      CASE 10:STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, _ '
                                                         gWSBTable(10).SBWidth, 9999   '
      CASE 11:STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, _ '
                                                         gWSBTable(10).SBWidth, _   '
                                                         gWSBTable(11).SBWidth, 9999   '
      CASE 12:STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, _ '
                                                         gWSBTable(10).SBWidth, _   '
                                                         gWSBTable(11).SBWidth, _   '
                                                         gWSBTable(12).SBWidth, 9999   '
      CASE 13:STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, _ '
                                                         gWSBTable(10).SBWidth, _   '
                                                         gWSBTable(11).SBWidth, _   '
                                                         gWSBTable(12).SBWidth, _   '
                                                         gWSBTable(13).SBWidth, 9999   '
      CASE 14:STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, _ '
                                                         gWSBTable(10).SBWidth, _   '
                                                         gWSBTable(11).SBWidth, _   '
                                                         gWSBTable(12).SBWidth, _   '
                                                         gWSBTable(13).SBWidth, _   '
                                                         gWSBTable(14).SBWidth, 9999   '
      CASE 15:STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, _ '
                                                         gWSBTable(10).SBWidth, _   '
                                                         gWSBTable(11).SBWidth, _   '
                                                         gWSBTable(12).SBWidth, _   '
                                                         gWSBTable(13).SBWidth, _   '
                                                         gWSBTable(14).SBWidth, _   '
                                                         gWSBTable(15).SBWidth, 9999   '
      CASE 16:STATUSBAR SET PARTS ghWnd, %IDC_STATUSBAR, gWSBTable(1).SBWidth, _ '
                                                         gWSBTable(2).SBWidth, _ '
                                                         gWSBTable(3).SBWidth, _ '
                                                         gWSBTable(4).SBWidth, _ '
                                                         gWSBTable(5).SBWidth, _ '
                                                         gWSBTable(6).SBWidth, _ '
                                                         gWSBTable(7).SBWidth, _ '
                                                         gWSBTable(8).SBWidth, _ '
                                                         gWSBTable(9).SBWidth, _ '
                                                         gWSBTable(10).SBWidth, _   '
                                                         gWSBTable(11).SBWidth, _   '
                                                         gWSBTable(12).SBWidth, _   '
                                                         gWSBTable(13).SBWidth, _   '
                                                         gWSBTable(14).SBWidth, _   '
                                                         gWSBTable(15).SBWidth, _   '
                                                         gWSBTable(16).SBWidth, 9999   '
   END SELECT                                                     '
   MExit                                                          '
END SUB                                                           '

FUNCTION Str2Hex(fstr AS STRING) AS STRING                        '
'--------------------------------------------------------------------------------------------------+
'- Convert a string to display hex                                                                 |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL fstr2 AS STRING                                             '
   fstr2 = "X'"                                                   ' Initialize fstr2
   FOR i = 1 TO LEN(fstr)                                         ' Convert it to hex
      fstr2 += HEX$(ASC(fstr, i), 2)                              '
   NEXT i                                                         '
   FUNCTION = fstr2 + "'"                                         '
END FUNCTION                                                      '

SUB StrAdd128(str AS STRING)                                      '
'--------------------------------------------------------------------------------------------------+
'- Shift a string upward by 128                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL letter AS BYTE PTR                                          '
    FOR letter = STRPTR(str) TO STRPTR(str) + LEN(str) - 1        '
       @letter = @letter + 128                                    '
    NEXT i                                                        '
END SUB                                                           '

FUNCTION StrAnsi2Utf8(BYREF a_str AS STRING) AS STRING            '
'--------------------------------------------------------------------------------------------------+
'- Convert an ANSI string to UTF8                                                                  |
'-          it is necessary to convert ANSI to Unicode first                                       |
'-          then convert Unicode to UTF-8                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL u_str                   AS STRING                           ' output UTF-8 string
LOCAL u_num1                  AS LONG                             ' first  UTF-8 byte
LOCAL u_num2                  AS LONG                             ' second UTF-8 byte
LOCAL u_num3                  AS LONG                             ' third  UTF-8 byte
LOCAL u_len                   AS LONG                             ' length of output string

LOCAL w_num                   AS LONG                             ' binary value of Unicode char
LOCAL w_char                  AS WSTRING * 1                      ' one Unicode char

LOCAL a_ndx                   AS LONG                             ' index into input string
LOCAL a_char                  AS STRING * 1                       ' one Ansi char

   IF LEN (a_str) = 0 THEN FUNCTION = "": EXIT FUNCTION           ' supplied Ansi string was null, return null

   u_len = 0                                                      ' where new string written

   '-----------------------------------------------------------------------------------------------+
   '- estimated size must take into account that Unicode translations of Ansi may take 2 or 3 bytes in UTF-8|
   '-----------------------------------------------------------------------------------------------+

   u_str = SPACE$ (LEN (a_str) * 3)                               ' allocate result string max length, may need less
   FOR a_ndx = 1 TO LEN (a_str)                                   ' examine each character in the input string

      a_char = MID$ (a_str, a_ndx, 1)                             ' grab one Ansi char
      w_char = a_char                                             ' convert to Unicode

      w_num = ASC(w_char) AND &H0FFFF                             ' get binary value of Unicode

      IF (w_num <= &H07F) AND (w_num > 0) THEN                    ' ASCII is a 1-byte sequence
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = a_char                          ' copy Ansi to output as is

      '--------------------------------------------------------------------------------------------+
      '- 2-byte UTF-8 has up 11 significant bits, divided into 5 and 6                             |
      '--------------------------------------------------------------------------------------------+

      ELSEIF (w_num <= &H07FF) OR (w_num = 0) THEN                ' data requires a 2-byte sequence
         u_num2 = ((w_num AND &H03F) OR &H080)                    ' byte 2 of UTF-8 gets 6 lower bits, plus x'80' marker
         SHIFT RIGHT w_num, 6                                     '
         u_num1 = ((w_num AND &H01F) OR &H0C0)                    ' byte 1 of UTF-8 gets 5 upper bits, plus x'C0' marker

         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num1)                   '
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num2)                   '

      '--------------------------------------------------------------------------------------------+
      '- 3-byte UTF-8 has up 16 significant bits, divided into 4, 6 and 6                          |
      '--------------------------------------------------------------------------------------------+

      ELSE                                                        ' data requires a 3-byte sequence
         u_num3 = ((w_num AND &H03F) OR &H080)                    ' byte 3 of UTF-8 gets 6 lower bits, plus x'80' marker
         SHIFT RIGHT w_num, 6                                     '

         u_num2 = ((w_num AND &H03F) OR &H080)                    ' byte 2 of UTF-8 gets next 6 bits, plus x'80' marker
         SHIFT RIGHT w_num, 6                                     '

         u_num1 = ((w_num AND &H0F) OR &H0E0)                     ' byte 1 of UTF-8 gets 4 upper bits, plus x'E0' marker

         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num1)                   '
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num2)                   '
         u_len += 1                                               ' get next position in output string
         MID$ (u_str, u_len, 1) = CHR$ (u_num3)                   '
                                                                  '
      END IF                                                      '
   NEXT                                                           '
   FUNCTION = LEFT$ (u_str, u_len)                                ' return the encoded UTF-8 string
END FUNCTION                                                      '

FUNCTION StrChgHexLower(Lower AS STRING, Orig AS STRING) AS STRING   '
'--------------------------------------------------------------------------------------------------+
'- Modify the lower half of a hex char                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL OrigHex, NewHex AS STRING                                   '
   MEntry                                                         '
   IF TP.FCB_.SrceXlate THEN                                      ' If not ANSI, must double translate
      OrigHex = Orig                                              ' Get Orig in equivalent SOURCE hex
      TP.Translate(OrigHex, TP.FCB_.GetSA2SPtr)                   '
      OrigHex = HEX$(ASC(OrigHex), 2)                             '
      NewHex = CHR$(VAL("&H" + LEFT$(OrigHex, 1) + Lower))        ' Alter the Hex now
      TP.Translate(NewHex, TP.FCB_.GetSS2APtr)                    '
      FUNCTION = NewHex                                           ' Pass back character in ANSI for screen display
   ELSE                                                           ' Else normal ANSI
      OrigHex = HEX$(ASC(Orig), 2)                                ' Make it hex
      FUNCTION = CHR$(VAL("&H" + LEFT$(OrigHex, 1) + Lower))      ' Alter and pass back the result
   END IF                                                         '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION StrChgHexUpper(Upper AS STRING, Orig AS STRING) AS STRING   '
'--------------------------------------------------------------------------------------------------+
'- Modify the upper half of a hex char                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL OrigHex, NewHex AS STRING                                   '
   MEntry                                                         '
   IF TP.FCB_.SrceXlate THEN                                      ' If not ANSI, must double translate
      OrigHex = Orig                                              ' Get Orig in equivalent SOURCE hex
      TP.Translate(OrigHex, TP.FCB_.GetSA2SPtr)                   '
      OrigHex = HEX$(ASC(OrigHex), 2)                             '
      NewHex = CHR$(VAL("&H" + Upper + RIGHT$(OrigHex, 1)))       ' Alter the Hex now
      TP.Translate(NewHex, TP.FCB_.GetSS2APtr)                    ' Pass back character in ANSI for screen display
      FUNCTION = NewHex                                           '
   ELSE                                                           ' Else normal ANSI
      OrigHex = HEX$(ASC(Orig), 2)                                ' Make it hex
      FUNCTION = CHR$(VAL("&H" + Upper + RIGHT$(OrigHex, 1)))     '
   END IF                                                         '
  MExit                                                           '
END FUNCTION                                                      '

FUNCTION StrFromHex(HexStr AS STRING) AS STRING                   '
'--------------------------------------------------------------------------------------------------+
'- Convert a Hex string to its proper self                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL Temp AS STRING, I AS LONG                                   '
   MEntry                                                         '
   Temp = SPACE$(LEN(HexStr) \ 2)                                 '
   FOR i = 1 TO LEN(HexStr) \ 2                                   '
      MID$(Temp, i, 1) = CHR$(VAL("&H" & MID$(HexStr, i * 2 - 1, 2)))   '
   NEXT I                                                         '
   FUNCTION = Temp                                                '
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION StrInvert(t AS STRING) AS STRING                         '
'--------------------------------------------------------------------------------------------------+
'- Invert a string for sorting                                                                     |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL nt AS STRING                                                '
   nt = ""                                                        '
   FOR i = 1 TO LEN(t)                                            ' Loop through string
      j = ASC(t, i)                                               ' Get the ASCII value
      j = j XOR 255                                               ' Invert it
      nt = nt + CHR$(j)                                           ' Stuff it back
   NEXT i                                                         '
   StrInvert = nt                                                 ' Pass back the answer
END FUNCTION                                                      '

FUNCTION StrIsProper(BYVAL test_line AS STRING, BYVAL i AS LONG, BYVAL check_escape AS LONG) AS LONG  '
'--------------------------------------------------------------------------------------------------+
'-  string_is_proper                                                                               |
'-                                                                                                 |
'-  test_line at position 'i' should contain a quote                                               |
'-  if there is at least one non-escaped quote of the same type after                              |
'-  position 'i', then the string at 'i' is a proper string; otherwise it is                       |
'-  unclosed. if the string is proper, return TRUE else FALSE                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL n AS LONG, quote AS STRING                                  '
   MEntry                                                         '
   n = LEN (test_line)                                            '

   '-----------------------------------------------------------------------------------------------+
   '-  if 'i'- is at the last position of test_line or beyond, there can't                         |
   '-  possibly be a proper string                                                                 |
   '-----------------------------------------------------------------------------------------------+

   IF n = 0 OR i < 1 OR i >= n  THEN                              '
      FUNCTION = 0                                                '
      MExitFunc                                                   '
   END IF                                                         '

   quote = MID$ (test_line, i, 1)                                 '
   IF quote <> $DQ AND quote <> "'" THEN                          '
      FUNCTION = 0                                                '  there was supposed to be a quote at position 'i'
      MExitFunc                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '-  scan remainder of line looking for close quote.                                             |
   '-  don't look at position 'i' in the loop because we already did that above.                   |
   '-----------------------------------------------------------------------------------------------+

   DO WHILE i < n                                                 '
      i += 1                                                      '
      IF MID$ (test_line, i, 1) = quote THEN                      '
         FUNCTION = 1                                             '  found closing quote
         MExitFunc                                                '
      END IF                                                      '
      IF check_escape = 1 THEN                                    '
         IF MID$ (test_line, i, 1) = "\" THEN                     '
            '-  skip over the escape, and next DO loop will skip over escaped char
            i += 1                                                '
         END IF                                                   '
      END IF                                                      '
   LOOP                                                           '
   FUNCTION = 0                                                   '  never found closing quote
   MExit                                                          '
END FUNCTION                                                      ' StrIsProper

FUNCTION StrQuote(x AS STRING) AS STRING                          '
'--------------------------------------------------------------------------------------------------+
'- Wrap quotes around a string, or convert to hex if needed                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL c, fresult AS STRING, n AS LONG                             '
   MEntry                                                         '
   IF INSTR(x, $DQ) = 0 THEN                                      ' See if safe to use $DQ
      fresult = BUILD$($DQ, x, $DQ)                               ' Yes, do so
   ELSEIF INSTR(x, $SQ) = 0 THEN                                  ' No? Maybe $SQ
      fresult = BUILD$($SQ, x, $SQ)                               ' Yes, do do
   ELSEIF TALLY(x, "`") = 0 THEN                                  ' No? Back-quote?
      fresult = BUILD$("`", x, "`")                               ' Yes, do so
   ELSE                                                           ' Wow! All 3 quotes in use

      '--------------------------------------------------------------------------------------------+
      '- string uses all three quotes, force into hex mode                                         |
      '--------------------------------------------------------------------------------------------+
      fresult = "X'"                                              ' Build a hex literal
      FOR n = 1 TO LEN(x)                                         ' Loop through it
         c = MID$(x, n, 1)                                        '
         fresult += HEX$(ASC(c), 2)                               '
      NEXT                                                        '
      fresult += "'"                                              '
   END IF                                                         '
   FUNCTION = fresult                                             '
   Mexit                                                          '
END FUNCTION                                                      '

SUB StrSub128(str AS STRING)                                      '
'--------------------------------------------------------------------------------------------------+
'- Shift a string down by 128                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL letter AS BYTE PTR                                          '
    FOR letter = STRPTR(str) TO STRPTR(str) + LEN(str) - 1        '
       @letter = @letter - 128                                    '
    NEXT i                                                        '
END SUB                                                           '

SUB      StrUnQuote(str AS STRING)                                '
LOCAL LH, RH AS STRING                                            '
'--------------------------------------------------------------------------------------------------+
'- Remove quotes from a string                                                                     |
'--------------------------------------------------------------------------------------------------+
   IF LEN(str) < 3 THEN EXIT SUB                                  '
   LH = LEFT$(str, 1): RH = RIGHT$(str, 1)                        ' Get framing characters
   IF LH <> RH THEN EXIT SUB                                      ' Different? Then not quoted
   IF INSTR($Quotes, LEFT$(str, 1)) <> 0 THEN _                   ' Same, and a quote mark
      str = MID$(str, 2, LEN(str) - 2)                            ' Remove them
END SUB                                                           '

FUNCTION StrUtf82Ansi(BYREF u_str AS STRING, err_flag AS LONG) AS STRING   '
'--------------------------------------------------------------------------------------------------+
'- Converts an UTF-8 encoded string to an Ansi string                                              |
'-                                                                                                 |
'-  err_flag 1 = value found outside Ansi 8-bit range                                              |
'-  err_flag 2 = UTF-8 value is malformed, errors replaced with X'A4' substitution                 |
'-  err_flag 3 = errors 1 and 2 both occurred                                                      |
'-                                                                                                 |
'-  if valid UTF-8 converts to a Unicode value that is not Ansi, we can't use it                   |
'--------------------------------------------------------------------------------------------------+

STATIC st_valid_unicode_set   AS LONG                             '
STATIC st_valid_unicode ()    AS WSTRING * 1                      '

LOCAL a_str                   AS STRING                           ' output Ansi string

LOCAL w_str                   AS WSTRING                          ' intermediate Unicode string
LOCAL w_len                   AS LONG                             ' length of output string
LOCAL w_num                   AS LONG                             ' accumulated Unicode char value
LOCAL w_char                  AS WSTRING * 1                      ' a Unicode char

LOCAL u_ndx                   AS LONG                             ' index into input string
LOCAL u_byte                  AS LONG                             ' individual UTF value in binary
LOCAL u_char                  AS STRING * 1                       ' a UTF-8 char

LOCAL format_err              AS LONG                             ' something wrong with UTF format
LOCAL data_err                AS LONG                             ' may be valid UTF but is out of range

LOCAL one_bits                AS LONG                             ' number of leading 1 bits in  a UTF byte
LOCAL select_mask             AS LONG                             ' used to select bits for testing
LOCAL data_mask               AS LONG                             ' used to mask off data portion of byte
LOCAL avail_len               AS LONG                             ' how many bytes left in the buffer
LOCAL actual_len              AS LONG                             ' byte length used to decode UTF data
LOCAL n                       AS LONG                             '


   '-----------------------------------------------------------------------------------------------+
   '- first time we are called, define the Unicode validation table                                |
   '-----------------------------------------------------------------------------------------------+

   IF st_valid_unicode_set = 0 THEN                               '
      st_valid_unicode_set = 1                                    '
      DIM st_valid_unicode (0 TO 255) AS STATIC WSTRING * 1       '

      FOR n = 0 TO 255                                            '
         st_valid_unicode (n) = CHR$ (n)                          ' the assignment converts Ansi to Unicode here
      NEXT                                                        '
   END IF                                                         '


   err_flag = 0                                                   '

   IF LEN (u_str) = 0 THEN                                        '
      FUNCTION = ""                                               ' nothing to convert
      EXIT FUNCTION                                               '
   END IF                                                         '

   w_len = 0                                                      ' where new string written
   w_str = SPACE$ (LEN (u_str))                                   ' allocate result string max length, may need less

   u_ndx = 0                                                      ' examine each character in the UTF-8 string
   DO WHILE (u_ndx < LEN (u_str))                                 '

      u_ndx += 1                                                  ' get next position in input string
      u_char = MID$ (u_str, u_ndx, 1)                             ' grab first UTF-8 byte
      u_byte = (ASC(u_char) AND &H0FF)                            ' form binary of UTF value

      '--------------------------------------------------------------------------------------------+
      '- determine the number of leading 1 bits                                                    |
      '--------------------------------------------------------------------------------------------+

      one_bits = 0                                                '
      select_mask = &H0100                                        '
      data_mask   = &H00FF                                        '

      '--------------------------------------------------------------------------------------------+
      '- scan the value left to right, stopping when first 0 bit is found                          |
      '-     data mask is 1 bit to right of select_mask                                            |
      '--------------------------------------------------------------------------------------------+

      FOR n = 1 TO 8                                              '
         SHIFT RIGHT select_mask, 1                               '
         SHIFT RIGHT data_mask, 1                                 '
         IF ((u_byte AND select_mask) = 0) THEN EXIT FOR          '
         one_bits = n                                             '
      NEXT                                                        '

      '--------------------------------------------------------------------------------------------+
      '- when one_bits = 0 is it ASCII                                                             |
      '-     1 leading 1-bit is a continuation byte without a lead byte                            |
      '-     leading 1 bits of 2-4 are UTF-8, any more is invalid                                  |
      '--------------------------------------------------------------------------------------------+

      IF one_bits = 0 THEN                                        ' UTF byte is 7-bit ASCII
         w_len += 1                                               ' get next position in buffer
         MID$ (w_str, w_len, 1) = CHR$$ (u_byte)                  ' copy non-encoded Ansi to intermeidate buffer
         ITERATE LOOP                                             '

      ELSEIF (one_bits = 1) OR (one_bits > 4) THEN                '
         err_flag = (err_flag OR 2)                               ' make note of format error
         w_len += 1                                               ' get next position in output string
         MID$ (w_str, w_len, 1) = CHR$$ (&H0A4)                   ' substitute char is logenze/square/currency symbol
         ITERATE LOOP                                             '

      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- at this point, the UTF-8 value is 2, 3 or 4 bytes long, indicated by number of 1 bits     |
      '-                                                                                           |
      '-     there are two "format issues" to contend with.                                        |
      '-     first, there may not be that many bytes left in the buffer (it's "truncated")         |
      '-     second, all of the extra bytes must be continuation bytes, with '10' bits on the left |
      '-     if either of these requirements are not met, the UTF-8 is malformed                   |
      '-                                                                                           |
      '-     there is also a "data issue".  a properly formatted UTF-8 string may be encoding value|
      '-     that is outside the range of Ansi.  that is nothing wrong with the UTF-8. it is simply|
      '-     a limitation of SPFLite, which can't handle true Unicode                              |
      '--------------------------------------------------------------------------------------------+

      format_err = 0                                              ' assume no error for now
      avail_len = LEN (u_str) - u_ndx + 1                         ' how many bytes left including curr one

      IF one_bits > avail_len THEN                                '
         format_err = 1                                           '
         actual_len = avail_len                                   '
      ELSE                                                        '
         actual_len = one_bits                                    '
      END IF                                                      '

      w_num = (u_byte AND data_mask)                              ' holds accumulated Unicode value

      '--------------------------------------------------------------------------------------------+
      '- get remaining bytes of UTF-8. these must all be continuation bytes                        |
      '--------------------------------------------------------------------------------------------+

      FOR n = 2 TO actual_len                                     '

         u_ndx += 1                                               ' get next position in input string
         u_char = MID$ (u_str, u_ndx, 1)                          ' grab next UTF-8 byte
         u_byte = (ASC(u_char) AND &H0FF)                         ' form binary of Unicode value

         IF ((u_byte AND &H0C0) <> &H080) THEN                    ' this is not a continuation byte - FORMAT ERROR
            format_err = 1                                        '
            u_ndx -= 1                                            ' we cannot use this byte - BACK OFF THE SCAN HERE
            EXIT FOR                                              ' no point in trying to converting any more of this
         END IF                                                   '

         SHIFT LEFT w_num, 6                                      ' make room for next 6 bits of data
         w_num += (u_byte AND &H03F)                              '
      NEXT                                                        '

      '--------------------------------------------------------------------------------------------+
      '- see if the accumulated Unicode value can be converted to Ansi                             |
      '--------------------------------------------------------------------------------------------+

      IF w_num > &H0FFFF THEN                                     '
         data_err = 1                                             ' no Ansi value has a Unicode value > FFFF

      ELSEIF w_num > &H07F THEN                                   '
         data_err = 1                                             ' assume it's bad unless found in the table
         w_char = CHR$$ (w_num)                                   '

         FOR n = 128 TO 255                                       '
            IF w_char = st_valid_unicode (n) THEN                 '
               data_err = 0                                       ' if found it table, it can be converted
               EXIT FOR                                           '
            END IF                                                '
         NEXT                                                     '

      ELSE                                                        '
         data_err = 0                                             ' data is not out of range
      END IF                                                      '


      IF format_err THEN                                          '
         err_flag = (err_flag OR 2)                               ' make note of format error
         w_char = CHR$$ (&H0A4)                                   ' substitute char is logenze/square/currency symbol

      ELSEIF data_err THEN                                        '
         err_flag = (err_flag OR 1)                               ' make note of data error
         w_char = CHR$$ (&H0A4)                                   ' substitute char is logenze/square/currency symbol

      ELSE                                                        '
         w_char = CHR$$ (w_num)                                   '

      END IF                                                      '

      w_len += 1                                                  ' get next position in intermediate buffer
      MID$ (w_str, w_len, 1) = w_char                             ' store one Unicode char

   LOOP                                                           '

   a_str = LEFT$ (w_str, w_len)                                   ' convert Unicode to Ansi
   FUNCTION = a_str                                               ' return the Ansi string
END FUNCTION                                                      '

FUNCTION  SubstEnviron(str AS STRING) AS STRING                   '
'--------------------------------------------------------------------------------------------------+
'- Do %xxx% environ string substitution                                                            |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL t, kVal, eVal, LH, MD, RH AS STRING                         '
   t = str                                                        ' Get working copy
   i = 1                                                          ' Set start scan
   DO WHILE TALLY(t, "%") > 1                                     ' While there's a %xxx% string
      i = INSTR(i, t, "%"): j = INSTR(i + 1, t, "%")              ' Find the %xxx% string
      lh = LEFT$(t, i - 1): md = MID$(t, i TO j): rh = MID$(t, j + 1)   ' Split to LH/MD/RH                                       ' Save LH (prior to the 1st %)
      kVal = MID$(t, i + 1 TO j - 1)                              ' Extract the Env string
      eVal = ENVIRON$(kVal)                                       ' Fetch the Env string
      IF ISNOTNULL(eVal) THEN                                     ' Got something?
         t = LH + eVal + RH: i = 1                                ' Swap in the new value, start over
      ELSE                                                        ' Missing variable
         i = j + 1                                                ' Step over it
         IF INSTR(i, t, "%") > 0 THEN ITERATE DO                  ' Continue if more
         EXIT DO                                                  ' Else we're done
      END IF                                                      '
      i = INSTR(t, eVal) + LEN(eVal)                              ' Set continue scan point
   LOOP                                                           '
   FUNCTION = t                                                   ' Return answer
END FUNCTION                                                      '

FUNCTION SubstSet(str AS STRING) AS LONG                          '
'--------------------------------------------------------------------------------------------------+
'- See if SET substitution is needed                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG, t, v, kw, value, cmd, ncmd, lcmd, dlm AS STRING, RCA AS RCArea  '
   MEntry                                                         '
   FUNCTION = %False                                              '
   lcmd = str + " "                                               ' Get a local copy plus a space

   '-----------------------------------------------------------------------------------------------+
   '- Now do the SET substitution                                                                  |
   '-----------------------------------------------------------------------------------------------+
   i = INSTR(lcmd, "=")                                           ' Look for '='
   IF i = 0 THEN MExitFunc                                        ' No '=', then nothing to do
   DO WHILE ISNOTNULL(TRIM$(lcmd))                                ' Process it
      cmd = GetNextWord(lcmd, %Strip) + " "                       ' Get an Operand plus a space
      IF LEFT$(cmd, 1) = "=" THEN                                 ' Look for '=' in first position
         j = INSTR(cmd, ANY " |")                                 ' Get trailing blank or |
         dlm = MID$(cmd, j, 1)                                    ' Save the dlm
         kw = MID$(cmd, 2 TO j - 1)                               ' Separate parts
         value = IIF$(dlm = "|", MID$(cmd, j + 1), "")            '
         IF ISNOTNULL(kw) THEN                                    ' If not a Solitary = sign?
            IF IsNE(kw, "X") THEN                                 ' If not the unique =X command
               SETTableUpd("GET", kw, RCA)                        ' Fetch substitution value
               IF RCA.RC > 0 THEN                                 ' Not found?
                  i = INSTR(j, cmd, "=")                          ' Ignore it, look onward
                  FUNCTION = %True                                '
                  TP.ErrMsgAdd(%eFail, MID$(v, 2) + ": " + t): MExitFunc   ' Else tell user
               ELSE                                               ' We have a value
                  cmd = RCA.Msg + IIF$(dlm = "|", "", " ")        ' Substitute it
                  IF LEFT$(value, 1) = $DQ THEN                   ' Quoted value?
                     cmd = $DQ + cmd                              ' Move to the front
                     value = MID$(value, 2)                       '
                  END IF                                          '
                  cmd += value                                    '
               END IF                                             '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      ncmd += cmd                                                 ' this operand done
   LOOP                                                           '
   str = ncmd                                                     ' Save replacement back
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION SubstSetEQ(strcmd AS STRING, strsub AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- See if SET substitution of =n style                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG, t, u, v, cmd, ncmd, lcmd, nvar AS STRING, RCA AS RCArea   '
DIM lOps(0 TO 10) AS STRING                                       '
   MEntry                                                         '
   FUNCTION = %False                                              '
   lcmd = strcmd + " "                                            ' Get a local copy of orig cmd
   DO WHILE ISNOTNULL(TRIM$(lcmd)) AND i <= 10                    ' Extract operands
      cmd = GetNextWord(lcmd, %Strip)                             ' Get an Operand
      IF i < 10 THEN                                              ' 1st nine?
         lOps(i) = cmd                                            ' Save it
      ELSE                                                        ' Number 10
         lOps(i) = cmd + " " + lcmd                               ' 10 = remainder of line
         EXIT DO                                                  ' We're done
      END IF                                                      '
      INCR i                                                      ' Bump oper number
   LOOP                                                           '
   lcmd = strsub + " "                                            ' Get a local copy of substitution str
   i = INSTR(lcmd, "=")                                           ' Look for '='
   IF i = 0 THEN MExitFunc                                        ' No '=', then nothing to do
   DO WHILE ISNOTNULL(TRIM$(lcmd))                                ' Process it
      cmd = GetNextWord(lcmd, %Strip) + " "                       ' Get an Operand
      k = 1                                                       ' Start column 1
      i = INSTR(k, cmd, "=")                                      ' Look for '='
      IF INSTR("'`" + $DQ, LEFT$(cmd, 1)) THEN i = 0              ' IF a quoted STRING, KILL ANY = location
      DO WHILE i                                                  ' While we see an = sign
         '-----------------------------------------------------------------------------------------+
         '- See if a simple =n request                                                             |
         '-----------------------------------------------------------------------------------------+
         IF MID$(cmd, i + 1, 1) >= "0" AND MID$(cmd, i + 1, 1) <= "9" THEN ' Is it =n ?
            nvar = MID$(cmd, i, 2)                                ' Extract it
            j = VAL(MID$(cmd, i + 1, 1))                          ' Make numeric
            REPLACE nvar WITH lOps(j) IN cmd                      ' Substitute it
         ELSE                                                     '
            j = INSTR(cmd, " ")                                   ' Get trailing blank
            IF j <> 2 THEN                                        ' If not a Solitary = sign?
               t = LEFT$(cmd, j - i)                              ' extract =xxx key
               IF IsNE(t, "=X") THEN                              ' If not =X
                  u = MID$(t, 2)                                  ' Extract xxx
                  SETTableUpd("GET", u, RCA)                      ' Fetch substitution value
                  IF RCA.RC > 0 THEN                              ' Not found?
                     i = INSTR(j, cmd, "=")                       ' Ignore it, look onward
                     FUNCTION = %True                             '
                     TP.ErrMsgAdd(%eFail, RCA.Msg + ": " + t): MExitFunc   ' Else tell user
                  ELSE                                            ' We have a value
                     cmd = RCA.Msg + " "                          ' Substitute it
                  END IF                                          '
               END IF                                             '
            END IF                                                '
            EXIT DO                                               '
         END IF                                                   '
         i = INSTR(k, cmd, "=")                                   ' Look for '='
      LOOP                                                        '
      ncmd += cmd                                                 ' this operand done
   LOOP                                                           '
   strsub = ncmd                                                  ' Save replacement back
   MExit                                                          '
END FUNCTION                                                      '

FUNCTION SubstSet2(str AS STRING) AS STRING                       '
'--------------------------------------------------------------------------------------------------+
'- Do =xxx substitution without rebuilding                                                         |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL t, eVar, eVal, lh, md, rh AS STRING, RCA AS RCArea          '
   t = str + " "                                                  ' Ensure trailing blank
   i = INSTR(t, "=")                                              ' Look for 1st =
   DO WHILE i                                                     ' While there's an =xxx string
      j = INSTR(i + 1, t, " ")                                    ' Find the end of =xxx string
      lh = LEFT$(t, i - 1)                                        ' Save LH (prior to the =)
      md = MID$(t, i TO j - 1)                                    ' Save MD (the =xxx string)
      rh = MID$(t, j)                                             ' Save RH (after the =xxx string)
      eVar = MID$(t, i + 1 TO j - 1)                              ' Extract the xxx value
      SETTableUpd("GET", eVar, RCA)                               ' Fetch substitution value
      IF RCA.RC > 0 THEN                                          ' Not found?
         i = INSTR(j, t, "=")                                     ' Ignore it, look onward
      ELSE                                                        ' Found the variable
         eVal = RCA.Msg                                           ' Copy the answer
         IF LEN(eVal) < LEN(md) THEN                              ' Is new value shorter?
            eVal = LSET$(eval, LEN(md))                           ' Extend eVal to Len(MD) to keep column alignment
         ELSEIF LEN(eVal) > LEN(MD) THEN                          ' Is new value longer?
            RH = CLIP$(LEFT, RH, LEN(eVal) - LEN(MD))             ' Trim RH by exces to keep column alignment
         END IF                                                   '
         t = LH + eVal + RH                                       ' Swap in the new value
         i = INSTR(i + LEN(eVal), t, "=")                         ' Look for another =
      END IF                                                      '
   LOOP                                                           '
   IF INSTR(t, "%") THEN t = SubstEnviron(t)                      ' If possible %xxx%, then eval them
   FUNCTION = t                                                   ' Return answer
END FUNCTION                                                      '

SUB TabAdd(tMode AS LONG)                                         '
'--------------------------------------------------------------------------------------------------+
'- Add a new TAB to the window and switch to it                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL x, y, h AS LONG, lclPCmd AS STRING                          '
   MEntry                                                         '
   lclPCmd = TP.CurrPCmd                                          ' Save what command triggered this
   '-----------------------------------------------------------------------------------------------+
   '- Expand TABS table if needed                                 '                                |
   '-----------------------------------------------------------------------------------------------+
   IF (gTabsNum + 1) > UBOUND(gTabs) THEN                         ' Need to resize?
      REDIM PRESERVE gTabs(gTabsNum + 1) AS iObjTabData           ' Yes, bump it up
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Create a new Tabs entry and associated storage CLASS                                         |
   '-----------------------------------------------------------------------------------------------+
   gTabsBusy = %True                                              ' Hands off
   INCR gTabsNum: INCR gTabUnique                                 ' Add a Tab
   LET gTabs(gTabsNum) = CLASS "cObjTabData"                      ' Build the Class entry
   TP = gTabs(gTabsNum)                                           ' Make the new entry the active tab class
   TP.Init(%False)                                                ' Init the Edit Panel structure
   TP.PTBL_.PTBLReset                                             ' Init the PTBL within it
   TP.PgNumber = gTabsNum                                         ' Save Page Number
   TP.PicInit                                                     ' Initialize Picture control area
   TP.ActionCtr = 0                                               ' Reset ActionCtr
   TP.CurrPCmd = lclPCmd                                          ' Propagate what command opened the tab
   TP.FindWord = gENV.FindWord                                    ' Start with global default
   '-----------------------------------------------------------------------------------------------+
   '- Build the Page and fire it up                                                                |
   '-----------------------------------------------------------------------------------------------+
   TP.WindowID = %IDC_SPFLiteWindow + gTabUnique                  ' Create the Dialog ID
   x = (gENV.ScrWidth * gFontWidth) + 1                           ' X
   y = (gENV.ScrHeight * gFontHeight)                             ' Y

   TAB INSERT PAGE ghWnd, %IDC_SPFLiteTAB, TP.PgNumber, 0, $New, CALL DlgCallBack TO h '
   TP.PgHandle = h                                                ' Save the handle
   CONTROL ADD GRAPHIC, TP.PgHandle, TP.WindowID, "", 0, 0, x, y  '
   GRAPHIC ATTACH TP.PgHandle, TP.WindowID                        ' Set as the default graphic area
   CONTROL HANDLE TP.PgHandle, TP.WindowID TO h                   ' Save handle to graphic window
   TP.gHandle = h                                                 '
   GRAPHIC CLEAR gTxtLoBG1                                        ' Clear the background
   TP.cCurrent = %False                                           ' Set cursor state
   GRAPHIC SET FONT gScrFont                                      ' Set the font
   TP.ScreenDim(gENV.ScrWidth)                                    ' Redim the Screen shadow copy
   GRAPHIC CLEAR gTxtLoBG1                                        ' Clear the background
   '-----------------------------------------------------------------------------------------------+
   '- Initialize Basic Data                                                                        |
   '-----------------------------------------------------------------------------------------------+
   TP.OFrmFPath = gENV.FMPath                                     ' Save any where we were started from values
   TP.OFrmFMask = gENV.FMMask                                     '
   TP.OFrmFileL = gENV.FileListNm                                 '
   TP.LInitTxtData()                                              ' Initialize our Text area
   GoToTab(TP.PgNumber, "", "")                                   ' Set to switch to this tab
   TabStackAdd(TP.PgNumber)                                       '
   gTabsBusy = %False                                             ' Clear Hands off
   TP.TabMode = tMode                                             ' Set to requested mode
   MExit                                                          '
END SUB                                                           '

FUNCTION TabInitFileData() AS LONG                                '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Get some data loaded                                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF TP.InitaFile(%False) THEN                                   ' Init, Not QUICK, returns True if Skipped
      TP.CleanTabData                                             ' Wipe everything out then
      INCR gTabDelCtr                                             ' Bump table index
      IF gTabDelCtr > UBOUND(gTabDelList()) THEN                  ' Keep table big enough
         REDIM PRESERVE gTabDelList(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
         REDIM PRESERVE gTabDelNext(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
      END IF                                                      '
      gTabDelList(gTabDelCtr) = TP.PgNumber                       ' Stuff in our page number
      TP.CmdStackNum = 0                                          ' No more commands allowed
      FUNCTION = %True                                            '
      MExitFunc                                                   '
   END IF                                                         '
   TP.UndoInit                                                    ' Init the Undo file names
   TP.UndoSave()                                                  ' Take an initial one
   TP.SetStart()                                                  ' Do initial positioning
   TP.WindowTitle                                                 ' Alter window/Tab titles
   StatusBarSetup                                                 ' Setup the status bar fields
   MExit                                                          '
END FUNCTION                                                      '

SUB      TabBGFill (BYVAL phDC AS DWORD)                          '
'--------------------------------------------------------------------------------------------------+
'- Fill background of Dialog tab                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL rectFill, rectClient AS RECT                                '
LOCAL hBrush AS DWORD                                             '
   GetClientRect WindowFromDC(phDC), rectClient                   '
   SetRect rectFill, 0, 0, rectClient.Right + 1, rectClient.Bottom   '
   hBrush = CreateSolidBrush(RGB(100, 100, 100))                  '
   Fillrect phDC, rectFill, hBrush                                '
   DeleteObject hBrush                                            '
END SUB                                                           '

SUB      TabDel()                                                 '
'--------------------------------------------------------------------------------------------------+
'- Delete a tab                                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL DelTab, i, j, lx, SaveTabsNum AS LONG, MSG AS STRING        '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Followed by an EXIT?                                                                         |
   '-----------------------------------------------------------------------------------------------+
   MSG = UUCASE(TP.CmdStackNext)                                  ' See if any pending commands
   IF MSG = "=X" OR MSG = "EXIT" THEN gShutFlag = %True           ' Remember we have to do this

   '-----------------------------------------------------------------------------------------------+
   '- Shut a TAB down                                                                              |
   '-----------------------------------------------------------------------------------------------+
   CaretDestroy                                                   '
   '-----------------------------------------------------------------------------------------------+
   '- Tell everyone to avoid tab structures                                                        |
   '-----------------------------------------------------------------------------------------------+
   SaveTabsNum = gTabsNum                                         '

   TRY                                                            '
      gTabsBusy = %True                                           ' Hands off
      '--------------------------------------------------------------------------------------------+
      '- OK, finally destroy the tab data areas                                                    |
      '--------------------------------------------------------------------------------------------+
      DelTab = TP.PgNumber                                        ' Save PageNum
      DECR gTabsNum                                               ' Reduce active count

      '--------------------------------------------------------------------------------------------+
      '- Remove from the Dialog                                                                    |
      '--------------------------------------------------------------------------------------------+
      TAB DELETE ghWnd, %IDC_SPFLiteTAB, DelTab                   ' Delete the tab
      '--------------------------------------------------------------------------------------------+
      '- Free the Tabs data areas, don't understand it all, but it works                           |
      '--------------------------------------------------------------------------------------------+
      TP = NOTHING                                                '
      FOR lx = 1 TO SaveTabsNum                                   ' Now lets delete all its data
         IF gTabs(lx).PgNumber = DelTab THEN EXIT FOR             ' Find the gTabs() entry we're deleting
      NEXT lx                                                     '
      j = UBOUND(gTabs)                                           ' Get the UBOUND
      gTabs(lx) = NOTHING                                         ' Free the Instance data
      FOR i = lx TO j - 1                                         ' Shift down the table
         gTabs(i) = gTabs(i + 1)                                  '
      NEXT                                                        '
      gTabs(j) = NOTHING                                          ' Make last entry empty
      IF j > 0 THEN                                               ' Resize the table
         REDIM PRESERVE gTabs(0 TO j - 1) AS GLOBAL IObjTabData   '
      ELSE                                                        '
         ERASE gTabs()                                            '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Adjust things for the deleted tab                                                         |
      '--------------------------------------------------------------------------------------------+
      IF gTabsNum > 0 THEN                                        ' If we're still active
         FOR i = 1 TO gTabsNum                                    ' Now lets reset the page numbers
            gTabs(i).PgNumber = i                                 '
         NEXT i                                                   '
      END IF                                                      '

      FileQueue("T", FORMAT$(DelTab), "")                         ' Go adjust FileQueue for deleted tab
   CATCH                                                          '
      debug "TabDel Catch entered"                                '
   END TRY                                                        '
   gTabsBusy = %False                                             ' Clear Hands off
   MExitSub                                                       '
END SUB                                                           '

SUB      TabAddFManager ()                                        '
'--------------------------------------------------------------------------------------------------+
'- Add the File Manager Tab data areas                                                             |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   TP.PgNumber = gTabsNum                                         ' Save Page Number
   TP.WindowID = %IDC_SPFLiteWindow + gTabUnique                  ' Create the Dialog ID
   TP.PicInit                                                     ' Initialize Picture control area
   TP.ActionCtr = 0                                               ' Reset ActionCtr

   '-----------------------------------------------------------------------------------------------+
   '- Initialize non-CFG file stuff                                                                |
   '-----------------------------------------------------------------------------------------------+
   TP.SPDataLen(gENV.ScrWidth - gLNPadCol)                        ' Calc derived values
   TP.SPCmdLen(gENV.ScrWidth - 24)                                ' Check sWindowCmd lengths as well
   TP.TabMode = TP.TabMode OR %FMTab                              ' Flag this as a File Manager Tab
   TP.TabTitleSet(%True)                                          '

   TP.FPath = gENV.FMPath                                         ' Establish FM startup values
   IF ISNOTNULL(gENV.InitFMPath) THEN TP.FPath = gENV.InitFMPath  '
   IF ISNULL(TP.FPath) THEN TP.FPath = "C:\"                      ' Just in case
   TP.FMask = gENV.FMMask                                         '
   IF ISNOTNULL(gENV.InitFMMask) THEN TP.FMask = gENV.InitFMMask  '
   IF ISNULL(TP.FMask) THEN TP.FMask = "*"                        ' Just in case
   TP.FileListNm = gENV.FileListNm                                '
   IF ISNOTNULL(gENV.InitFMFileList) THEN TP.FileListNm = gENV.InitFMFileList '
   IF TP.FileListNm = "$Null$" THEN TP.FileListNm = ""            '
   TP.LFPath      = TP.FPath                                      ' Save as 'previous' values
   TP.LFMask      = TP.FMask                                      '
   TP.LFileListNm = TP.FileListNm                                 '
   TP.LastLine = 3                                                ' Prevent Editor opens
   TP.ScrlAmtC    = gENV.FMScrlAmt                                '
   TP.AttnDo = (TP.AttnDo OR %LoadReq)                            ' Trigger initial Req and Data load
'-  StatusBarSetup                                                 ' Setup correct SB fields for FM
   TabStackAdd(1)                                                 '
   MExit                                                          ' Done Here
END SUB                                                           '

SUB      TabHighLight(HDLG AS LONG, wParm AS LONG, lParm AS LONG) '
'--------------------------------------------------------------------------------------------------+
'- Highlight the selected Dialog tab                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL lDISPtr AS DRAWITEMSTRUCT PTR, zCap AS ASCIIZ * 80          '
LOCAL ti AS TC_ITEM                                               '
LOCAL hBrush, active, modified, BGColor AS LONG                   '
   MEntry                                                         '
   IF HDLG = 0 OR wParm = 0 OR lparm = 0 THEN MExitSub            ' If no HDLG, wParm or lParm, bail out

   lDisPtr = lparm                                                '
   ti.mask = %TCIF_TEXT                                           '
   ti.pszText = VARPTR(zCap)                                      '
   ti.cchTextMax = SIZEOF(zCap)                                   '
   TabCtrl_GetItem(GetDlgItem(HDLG, wParm), @lDisptr.itemID, ti)  '
   @lDisptr.rcItem.Top = @lDisptr.rcItem.Top + 2                  '
   IF @lDisPtr.ItemState = %ODS_SELECTED THEN active = %True      '
   IF ASC(LEFT$(zCap, 1)) > 127 THEN                              ' Set Modified/NonModified color
      zCap = CHR$(ASC(LEFT$(zCap, 1)) - 128) + MID$(zCap, 2)      '
      modified = %True                                            '
   END IF                                                         '
   IF active THEN                                                 ' Set text color based on active
      SetTextColor @lDisPtr.hDc, IIF(modified, gATabModFG, gATabNModFG) '
      BGColor = IIF(modified, gATabModBG1, gATabNModBG1)          '
   ELSE                                                           '
      SetTextColor @lDisPtr.hDc, IIF(modified, gITabModFG, gITabNModFG) '
      BGColor = IIF(modified, gITabModBG1, gITabNModBG1)          '
   END IF                                                         '

   SetBkColor @lDisPtr.hDc, BGColor                               '
   hBrush = CreateSolidBrush(BGColor)                             '
   SelectObject @lDisptr.hDc, hBrush                              '
   FillRect @lDisptr.hDc, @lDisptr.rcItem, hBrush                 '
   SelectObject @lDisPtr.hDc, gSBFont                             '
   DrawText @lDisptr.hDc, zCap, LEN(zCap), @lDisptr.rcItem, %DT_SINGLELINE OR %DT_CENTER  '
   DeleteObject hBrush                                            '
   MExit                                                          '
END SUB                                                           '

SUB      TabStackAdd(tbnum AS LONG)                               '
'--------------------------------------------------------------------------------------------------+
'- Add tab number to the stack                                                                     |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
   IF tbnum = gTabStack(1) THEN EXIT SUB                          ' Exit quickly for the commonest case

   FOR i = 1 TO gTabStackNum                                      ' See if already in the list
      IF gTabStack(i) = tbnum THEN                                ' Found it lower down?
         ARRAY DELETE gTabStack(i)                                ' Remove it from the old location
         ARRAY INSERT gtabStack(1), tbnum                         ' Add it back at the top
         EXIT SUB                                                 ' We're done
      END IF                                                      '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Not found in the stack, add it                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF gTabStackNum + 1 > UBOUND(gTabStack()) THEN REDIM PRESERVE gTabStack(1 TO 2* gTabStackNum) AS GLOBAL LONG   '
   ARRAY INSERT gTabStack(1), tbnum                               ' Insert this at the top
   INCR gTabStackNum                                              ' count it
END SUB                                                           '

SUB      TabStackDel(tbnum AS LONG)                               '
'--------------------------------------------------------------------------------------------------+
'- Remove tab number to the stack                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '

   FOR i = 1 TO gTabStackNum                                      ' See if already in the list
      IF gTabStack(i) = tbnum THEN                                ' Found it lower down?
         j = i                                                    ' Save the one to be deleted
      ELSE                                                        ' Not the one being deleted
         IF gTabStack(i) > tbnum THEN                             ' If a higher tab number
            DECR gTabStack(i)                                     ' Reduce by the deleted tab
         END IF                                                   '
      END IF                                                      '
   NEXT i                                                         '
   IF j = 0 THEN EXIT SUB                                         ' Nothing to do
   ARRAY DELETE gTabStack(j)                                      ' Remove it from the old location
   DECR gTabStackNum                                              ' Adjust count
END SUB                                                           '

FUNCTION TagValidate(ptag AS STRING, lookup AS LONG) AS LONG      '
'--------------------------------------------------------------------------------------------------+
'- Validate a basic Tag operand                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   MEntry                                                         '
   t = UUCASE(ptag)                                               ' Get an uppercase copy
   FUNCTION = %True                                               ' Start as failure
   IF LEN(t) = 1 OR LEN(t) > 8 OR LEFT$(t, 1) <> ":" THEN MExitFunc  ' No starting :, just a single : or > 8?
   IF t = ":ZALL" THEN FUNCTION = %False: MExitFunc               '
   t = LSET$(t, 8)                                                ' Make it 8
   IF ISTRUE lookup THEN                                          ' Validate the tagname
      IF ISFALSE TP.LLTagScan(t) THEN MExitFunc                   ' Better exist
   END IF                                                         '
   FUNCTION = %False                                              ' Say it's OK
   MExit                                                          '
END FUNCTION                                                      '

SUB      TraceTblAdd(tItem AS STRING)                             '
'--------------------------------------------------------------------------------------------------+
'- Add item to trace table                                                                         |
'--------------------------------------------------------------------------------------------------+
   ARRAY INSERT gCrashTrace(1), tItem                             ' Stuff in the item
END SUB                                                           '

FUNCTION TryOpenBinaryIN(Fn AS STRING, FNum AS LONG) AS LONG      '
'--------------------------------------------------------------------------------------------------+
'- Return 2 = OK, 1 = Open Failed                                                                  |
'--------------------------------------------------------------------------------------------------+
   TRY                                                            ' Just in case
      OPEN Fn FOR BINARY ACCESS READ LOCK WRITE AS # FNum         ' Open the File
   CATCH                                                          '
      FUNCTION = 1: EXIT FUNCTION                                 ' Exit, failure
   END TRY                                                        '
   FUNCTION = 2                                                   ' Exit OK
END FUNCTION                                                      '

FUNCTION TryOpenBinaryOut(Fn AS STRING, FNum AS LONG) AS LONG     '
'--------------------------------------------------------------------------------------------------+
'- Return 2 = OK, 1 = Open Failed                                                                  |
'--------------------------------------------------------------------------------------------------+
   TRY                                                            ' Just in case
      OPEN Fn FOR BINARY ACCESS WRITE LOCK WRITE AS # FNum        ' Open the File
   CATCH                                                          '
      FUNCTION = 1: EXIT FUNCTION                                 ' Exit, failure
   END TRY                                                        '
   FUNCTION = 2                                                   ' Exit OK
END FUNCTION                                                      '

FUNCTION TryOpenInput(Fn AS STRING, FNum AS LONG) AS LONG         '
'--------------------------------------------------------------------------------------------------+
'- 1 = Doesn't exist, 2 = Open Failed, Return 3 = OK                                               |
'--------------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- See if it exists                                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE ISFILE(Fn) THEN                                     ' See if exists
      FUNCTION = 1                                                ' Return "Doesn't exist"
      EXIT FUNCTION                                               ' Exit with Failure
   END IF                                                         '
   TRY                                                            ' Just in case
      OPEN Fn FOR INPUT ACCESS READ LOCK SHARED AS #FNum          ' Open the File
   CATCH                                                          '
      FUNCTION = 2: EXIT FUNCTION                                 ' Exit, failure
   END TRY                                                        '
   FUNCTION = 3                                                   ' Exit success
END FUNCTION                                                      '

FUNCTION TryOpenOutput(Fn AS STRING, FNum AS LONG) AS LONG        '
'--------------------------------------------------------------------------------------------------+
'- Return 3 = OK, 2 = 'In Use", 1 = Open Failed                                                    |
'--------------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- Next see if it is 'In Use' elsewhere                                                         |
   '-----------------------------------------------------------------------------------------------+
   TRY                                                            ' See if file is in use
      OPEN Fn FOR BINARY ACCESS WRITE LOCK WRITE AS # FNum        ' Try binary open
      CLOSE # FNum                                                ' OK, then close it
   CATCH                                                          '
      FUNCTION = 2                                                ' Return "In Use"
      EXIT FUNCTION                                               ' Exit with Failure
   END TRY                                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Now try the real normal OPEN for output                                                      |
   '-----------------------------------------------------------------------------------------------+
   TRY                                                            ' Just in case
      OPEN Fn FOR OUTPUT ACCESS WRITE LOCK WRITE AS # FNum        ' Open the File
   CATCH                                                          '
         FUNCTION = 1                                             ' Return "Open Failed"
      EXIT FUNCTION                                               ' Exit with failure                                  ResultMsg = "File OPEN failed"                     ' Say some words
   END TRY                                                        '
   FUNCTION = 3                                                   ' Return "Open OK"
END FUNCTION                                                      '

FUNCTION Time12HR() AS STRING                                     '
'--------------------------------------------------------------------------------------------------+
'- Return Time                                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL MyTime AS STRING, hh AS LONG                                '
   MyTime = TIME$ + " AM"                                         ' Get the time  (hh:mm:ss)
   hh = VAL(LEFT$(MyTime, 2))                                     ' Make it a 12 hr clock
   IF hh > 12 THEN                                                '
      hh -= 12                                                    '
      MID$(MyTime, 1, 2) = FORMAT$(hh, "00")                      '
      MID$(MyTime, 10, 2) = "PM"                                  '
   END IF                                                         '
   FUNCTION = MyTime                                              '
END FUNCTION                                                      '

FUNCTION TimePretty(BYVAL vl AS QUAD) AS STRING                   '
'--------------------------------------------------------------------------------------------------+
'- Make a 'pretty' TimeStamp - yyyy-mm-dd hh:mm                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL LTime AS IPOWERTIME                                         ' Create a PowerTime object
LET LTime = CLASS "PowerTime"                                     '
   IF vl = 0 THEN                                                 ' If nothing passed
      LTime.Now                                                   ' Use current timestamp
   ELSE                                                           ' Otherwise
      LTime.FileTime = vl                                         ' Assign the passed FILETIME QUAD to it
      LTime.ToLocalTime                                           '
   END IF                                                         '
   FUNCTION = FORMAT$(LTime.year(), "0000") + "-" + FORMAT$(LTime.Month(), "00") + "-" + FORMAT$(LTime.day(), "00") + "  " + _   '
              FORMAT$(LTime.Hour(), "00") + ":" + FORMAT$(LTime.Minute(), "00")  '
END FUNCTION                                                      '

THREAD FUNCTION UndoSaveThread(BYVAL pData AS LONG) AS LONG       ' Save the UNDO data asynchronously
LOCAL lclBStack() AS LONG, lclL() AS DataLine                     '
LOCAL USFNum AS LONG, fnU, FnT, FnTW, FnIX, buf AS STRING, bufw, tw AS WSTRING   '
LOCAL supData AS UNDOType POINTER                                 '
REGISTER USi AS LONG                                              '
REGISTER USj AS LONG                                              '
   supData = pData                                                ' Copy pointer locally
   DIM lclL(@supData.UBoundL) AS DataLine                         ' Local L()
   DIM lclBStack(@supData.UBoundB) AS LONG                        ' Local BStack()

   FOR USi = 0 TO @supData.UBoundT                                ' first calculate whole size
      USj += LEN(@supData.@pT[USi]) + 2                           ' plus 2 for each line feed
   NEXT                                                           '
   buf = SPACE$(USj) : USj = 0                                    ' allocate enough space

   FOR USi = 0 TO @supData.UBoundT                                ' first calculate whole size
      USj += LEN(@supData.@pTW[USi]) + 2                          ' plus 2 for each line feed
   NEXT                                                           '
   bufw = SPACE$(USj) : USj = 1                                   ' allocate enough space

   FOR USi = 0 TO @supData.UBoundT                                ' then place array into string
      MID$(buf, USj, LEN(@supData.@pT[USi])) = @supData.@pT[USi]  ' array element goes here
      MID$(buf, USj, LEN(@supData.@pT[USi])) = @supData.@pT[USi]  ' array element goes here
      USj += LEN(@supData.@pT[USi])                               ' move position ahead
      MID$(buf, USj) = $CRLF                                      ' line feed goes here
      USj += 2                                                    ' move position ahead
   NEXT                                                           '
   USj = 1                                                        '
   FOR USi = 0 TO @supData.UBoundT                                ' then place array into string
      MID$(bufw, USj, LEN(@supData.@pTW[USi])) = @supData.@pTW[USi]  ' array element goes here
      USj += LEN(@supData.@pTW[USi])                              ' move position ahead
      MID$(bufw, USj) = $$CRLF                                    ' line feed goes here
      USj += 2                                                    ' move position ahead
   NEXT                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- Make copies of the data to be written                                                        |
   '-----------------------------------------------------------------------------------------------+

   MEMORY COPY @supData.pBStack, VARPTR(lclBStack(0)), @supData.UBoundB * 4   ' Copy the BStack() table
   MEMORY COPY @supData.pL, VARPTR(lclL(0)), @supData.UBoundL * SIZEOF(DataLine) ' Copy the L() table

   '-----------------------------------------------------------------------------------------------+
   '- Tell mainline the copies are done, they can resume                                           |
   '-----------------------------------------------------------------------------------------------+
   FnIX = @supData.IXFn                                           ' Get the filenames before
   FnU = @supData.UFn                                             ' Letting mainline resume
   FnT = @supData.TFn                                             ' So TP pointer doesn't get swapped under us.
   FnTW = @supData.TWFn                                           '
   @supData.mCpyBusy = %False                                     ' Say copies are done

   '-----------------------------------------------------------------------------------------------+
   '- Now do the actual I/O at our leisure                                                         |
   '-----------------------------------------------------------------------------------------------+

   USFNum = FREEFILE                                              '
   OPEN FnT FOR BINARY AS #USFNum                                 ' Write the string data
   PUT$ #USFNum, buf                                              '
   SETEOF #USFNum                                                 '
   CLOSE #USFNum                                                  '
   buf = ""                                                       ' free the text strings

   USFNum = FREEFILE                                              '
   OPEN FnTW FOR BINARY AS #USFNum                                ' Write the wstring data
   PUT$$ #USFNum, bufw                                            '
   SETEOF #USFNum                                                 '
   CLOSE #USFNum                                                  '
   bufw = ""                                                      ' free the wtext strings

   USFNum = FREEFILE                                              '
   OPEN FnIX FOR BINARY AS #USFNum                                ' Write the Buffer Stack
   PUT #USFNum, ,lclBStack()                                      '
   SETEOF #USFNum                                                 '
   CLOSE #USFNum                                                  '
   ERASE lclBStack()                                              ' free the Buffer Stack array

   USFNum = FREEFILE                                              '
   OPEN FnU FOR BINARY AS #USFNum                                 ' Write the L() array
   PUT #USFNum, ,lclL()                                           '
   SETEOF #USFNum                                                 '
   CLOSE #USFNum                                                  '
   ERASE lclL()                                                   ' free the line table
   @supData.Busy = %False                                         ' Clear this slot's Busy indicator

END FUNCTION                                                      '

FUNCTION UUCASE (BYVAL sAscii AS STRING) AS STRING                '
'--------------------------------------------------------------------------------------------------+
'- Do a character translate from lower to upper case ASCII                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL pAscii AS BYTE PTR                                          '
   IF LEN(sAscii) = 0 THEN                                        '  handle null-string case
      FUNCTION = ""                                               '
   ELSEIF gENV.ENGchars THEN                                      '  do ENGLISH-only UUCASE
      pAscii = STRPTR(sAscii)                                     '  point to first char of value
      DO WHILE @pAscii                                            '  scan ASCII looking for LC
         IF  @pAscii >= &H61  _                                   '  LC "a"
         AND @pAscii <= &H7A  THEN                                '  LC "z"
             @pAscii -= &H20                                      '  shift LC down to where UC ASCII is
         END IF                                                   '
         INCR pAscii                                              '  bump scan pointer to next char
      LOOP                                                        '
      FUNCTION = sAscii                                           '  return modified string argument as result
   ELSE                                                           '  do international UUCASE
      FUNCTION = UCASE$(sAscii)                                   '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION ValidateCodepageData(CP AS CodePage_CP_T) AS LONG        '
'--------------------------------------------------------------------------------------------------+
'-  Validate_CodePage_Data                                                                         |
'-                                                                                                 |
'-  The complete .SOURCE file has been read, parsed and stored into the Code                       |
'-  Page data structures.  Wenow validate thet we have a usable definition.                        |
'-  In addition, if one of the two tables was omitted, assuming that Roundtrip                     |
'-  Mode is in effect, we synthesize the missing table from the one that is                        |
'-  present, since the two tables are symmetrical.                                                 |
'-                                                                                                 |
'-  Return 1 if valid, else store error message in CP_Reason and Return 0                          |
'-                                                                                                 |
'-  Method: If initial storage of CodePage_CP_T created any errors, stop now.                      |
'-  Otherwise, validate each component, and return errors if these components                      |
'-  have any problems.  If all the components report valid status, so do we.                       |
'--------------------------------------------------------------------------------------------------+
LOCAL RETCODE, I, RT_Mode, AE_INDEX, AE_VALUE, EA_INDEX, EA_VALUE AS LONG  '
LOCAL D_CHAR, D, U AS LONG                                        '
    FUNCTION = 0                                                  '  Default as error
    IF  CP.CP_Errors > 0 THEN EXIT FUNCTION                       '  Errors found earlier
    RETCODE = ValidateCodepageTTData (CP.TT)                      '

    IF  RETCODE = 0 THEN                                          '  Problem with TT data
        CP.CP_Reason = CP.TT.TT_Reason                            '
        EXIT FUNCTION                                             '
    END IF                                                        '

    IF  CP.TT.TT_Mode  = "RT" THEN                                '
        RT_Mode = 1                                               '
    ELSE                                                          '
        RT_Mode = 0                                               '
    END IF                                                        '

    IF  CP.TX(%AE_Mode).TX_Defined = 0 _                          '
    AND CP.TX(%EA_Mode).TX_Defined = 0 THEN                       '
        CP.CP_Reason = "AE/EA TABLES ARE NOT DEFINED"             '
        EXIT FUNCTION                                             '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '   If round-trip mode, and only one table is defined, invert the table to                     |
                                                                  '   create the missing one.
    '----------------------------------------------------------------------------------------------+
    IF  RT_Mode = 1 THEN                                          '
        IF  CP.TX(%AE_Mode).TX_Defined <> CP.TX(%EA_Mode).TX_Defined THEN  '

            '--------------------------------------------------------------------------------------+
            '-  Figure out which one is defined and set indexes to make the                        |
            '-  logic easier to deal with                                                          |
            '--------------------------------------------------------------------------------------+
            IF  CP.TX(%AE_Mode).TX_Defined = 1 THEN               '
                D = %AE_Mode                                      '  AE was defined
                U = %EA_Mode                                      '  EA was undefined
            ELSE                                                  '
                D = %EA_Mode                                      '  EA was defined
                U = %AE_Mode                                      '  AE was undefined
            END IF                                                '
            IF  CP.TX(D).TX_Values = 256 _                        '
            AND CP.TX(U).TX_Values = 0   THEN                     '
                '----------------------------------------------------------------------------------+
                                                                  '  Copy error count, whatever it is
                '----------------------------------------------------------------------------------+
                CP.TX(U).TX_Errors  = CP.TX(D).TX_Errors          '
                CP.TX(U).TX_Values  = 256                         '  Force to correct value
                CP.TX(U).TX_Defined = 1                           '  Force to correct value

                '----------------------------------------------------------------------------------+
                                                                  '  Copy and invert the characters
                '----------------------------------------------------------------------------------+
                FOR I = 0 TO 255                                  '
                    D_CHAR = CP.TX(D).TX_Table (I)                '
                    CP.TX(U).TX_Table (D_CHAR) = I                '
                NEXT                                              '

                '----------------------------------------------------------------------------------+
                                                                  '  Replicate the TX_Entry list
                '----------------------------------------------------------------------------------+
                FOR I = 0 TO 15                                   '
                    CP.TX(U).TX_Entry (I) = CP.TX(D).TX_Entry (I) '
                NEXT                                              '
            END IF                                                '
        END IF                                                    '- TX_Defined values differ
    END IF                                                        ' RT_Mode = 1

    '----------------------------------------------------------------------------------------------+
                                                                  '   Now that inverted table was created, if necessary, finish the table                        |
                                                                  '   validation
    '----------------------------------------------------------------------------------------------+
    FOR I = %TX_ASCII TO %TX_EBCDIC                               '
        RETCODE = ValidateCodepageTXData (CP.TX(I), I, RT_Mode)   '
        IF  RETCODE = 0 THEN                                      '  Problem with TX data
            CP.CP_Reason = CP.TX(I).TX_Reason                     '
            EXIT FUNCTION                                         '
        END IF                                                    '
    NEXT                                                          '

    '----------------------------------------------------------------------------------------------+
                                                                  '   Cross-validate round-trap CodePage tables.  If RT_Mode, verify that                        |
                                                                  '   every byte value is double-translated bacl to itself
    '----------------------------------------------------------------------------------------------+
                                                                  '
    '----------------------------------------------------------------------------------------------+
                                                                  '   Example case: AE[39] = F9, so EA[F9] must = 39
    '----------------------------------------------------------------------------------------------+
    IF  RT_Mode = 1 THEN                                          '
        FOR AE_INDEX = 0 TO 255                                   '  AE_Index = 39

            AE_VALUE = CP.TX (%AE_Mode).TX_Table (AE_INDEX)       ' --> AE_Value = F9
            EA_INDEX = AE_VALUE                                   ' --> EA_Index = F9

            EA_VALUE = CP.TX (%EA_Mode).TX_Table (EA_INDEX)       '  EA_Value = 39

            '--------------------------------------------------------------------------------------+
            '-  We forced AE_Value = EA_Index at --> now do inverse test                           |
            '--------------------------------------------------------------------------------------+
            IF  AE_INDEX <> EA_VALUE THEN                         '
                CP.CP_Reason = "MODE=RT BUT AE/EA TABLES ARE NOT " +           _ '
                    "MUTUALLY ROUND-TRIP"                         '
                EXIT FUNCTION                                     '
            END IF                                                '
        NEXT                                                      '
    END IF                                                        '
    FUNCTION = 1                                                  '  Data structures are OK
END FUNCTION                                                      ' ValidateCodepageData

FUNCTION ValidateCodepageTTData(TT AS CODEPAGE_TT_T) AS LONG      '
'--------------------------------------------------------------------------------------------------+
'-  Validate_CodePage_TT_Data                                                                      |
'-                                                                                                 |
'-  Fields validated: AE, EA and MODE.                                                             |
'-  AE and EA must be 0, 1 or blank; BLANK defaults to 1.                                          |
'-  REMAINING FIELDS IGNORED                                                                       |
'-                                                                                                 |
'-  If MODE is RT, one of AE or EA can be omitted.                                                 |
'-                                                                                                 |
'-  Return 1 if valid, else return 0                                                               |
'--------------------------------------------------------------------------------------------------+
    FUNCTION = 0                                                  '  Default as error
    IF  TT.TT_Errors > 0 THEN EXIT FUNCTION                       '  Errors found earlier

    '----------------------------------------------------------------------------------------------+
                                                                  '   MODE value must be 'RT', 'ES' or BLANK; BLANK defaults to RT                               |
    '----------------------------------------------------------------------------------------------+
    IF  TRIM$(TT.TT_Mode) = "" THEN TT.TT_Mode = "RT"             '
    TT.TT_Mode = UUCASE(TT.TT_Mode)                               '
    IF  TT.TT_Mode <> "RT"  _                                     '
    AND TT.TT_Mode <> "ES"  THEN                                  '
        TT.TT_Errors += 1                                         '
        TT.TT_Reason = "INVALID: MODE=" + TT.TT_Mode              '
        EXIT FUNCTION                                             '
    END IF                                                        '
    FUNCTION = 1                                                  '  All required fields valid
END FUNCTION                                                      ' ValidateCodepageTTData

FUNCTION  ValidateCodepageTXData(TX AS CODEPAGE_TX_T, TX_Index AS LONG, RT_Mode AS LONG) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'-  Validate_CodePage_TX_Data                                                                      |
'-                                                                                                 |
'-  Fields validated: TX_Type                                                                      |
'-                                                                                                 |
'-  Return 1 if valid, else return 0                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL Deduced_Type        AS STRING                               '
LOCAL TX_ID               AS STRING                               '
DIM   Test (0 TO 255)     AS BYTE                                 '
LOCAL Byte_Index          AS BYTE                                 '
REGISTER I                AS LONG                                 '
    FUNCTION = 0                                                  '  Set failure code
    '----------------------------------------------------------------------------------------------+
                                                                  '  TX_Index is either %TX_ASCII or %TX_EBCDIC
    '----------------------------------------------------------------------------------------------+
    IF  TX.TX_Errors > 0 THEN EXIT FUNCTION                       '  Errors found earlier
                                                                  '
    IF  TX_Index = %TA_Index THEN                                 '
        TX_ID = "AE"                                              '
    ELSEIF TX_Index = %TE_Index THEN                              '
        TX_ID = "EA"                                              '
    ELSE                                                          '
        TX_ID = "??"                                              '  Should not occur
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '   Deduce type of CodePage from condition of digit '9'
                                                                  '   ASCII-to-ASCII is possible but unusual; EBCDIC-EBCDIC is invalid                           |
                                                                  '   we have to be able to deduce which kind of table we are dealing with                       |
    '----------------------------------------------------------------------------------------------+
    IF     TX.TX_Table(&H039) = &H0F9 THEN                        '  Table is ASCII to EBCDIC
        Deduced_Type = "ASCII"                                    '
    ELSEIF TX.TX_Table(&H0F9) = &H039 THEN                        '  Table is EBCDIC to ASCII
        Deduced_Type = "EBCDIC"                                   '
    ELSEIF TX.TX_Table(&H039) = &H039 THEN                        '  Table is ASCII to ASCII
        Deduced_Type = "ASCII"                                    '

    '----------------------------------------------------------------------------------------------+
                                                                  '  if we have a 'null' table that translates to itself, it's possible that                     |
                                                                  '  the entry at [F9] will equal F9.  it's not necessarily an error                             |
    '----------------------------------------------------------------------------------------------+

    ELSEIF TX.TX_Table(&H0F9) = &H0F9 THEN                        '  Table is EBCDIC to EBCDIC
        Deduced_Type = "ASCII"                                    '

    '----------------------------------------------------------------------------------------------+
                                                                  '   TX.TX_Errors += 1
                                                                  '   TX.TX_Reason = TX_ID + " INVALID: TABLE IS EBCDIC/EBCDIC"
                                                                  '   EXIT FUNCTION
    '----------------------------------------------------------------------------------------------+

    ELSE                                                          '
        TX.TX_Errors += 1                                         '
        TX.TX_Reason = TX_ID + " INVALID: [39] = " + HEX$(TX.TX_Table(&H39))   _ '
            + " [F9] = " + HEX$(TX.TX_Table(&HF9))                '
        EXIT FUNCTION                                             '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '   Make initial assumption about type based on TX index
    '----------------------------------------------------------------------------------------------+
    TX.TX_Type = UUCASE(TRIM$(TX.TX_Type))                        '
    IF  TX.TX_Type = "" THEN                                      '
        IF TX_Index = %TX_ASCII THEN                              '
            TX.TX_Type = "ASCII"                                  '
        ELSEIF TX_Index = %TX_EBCDIC THEN                         '
            TX.TX_Type = "EBCDIC"                                 '
        END IF                                                    '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '   A Code Page must have 256 values
    '----------------------------------------------------------------------------------------------+
    IF  TX.TX_Values <> 256 THEN                                  '
        TX.TX_Errors += 1                                         '
        TX.TX_Reason = "TYPE=" + TX.TX_Type + " HAS " + TRIM$(TX.TX_Values)    _ '
            + ", EXPECTING 256"                                   '

        '------------------------------------------------------------------------------------------+
                                                                  '  If the number of values is low, see if we can find a missing row                        |
        '------------------------------------------------------------------------------------------+
        FOR I = 0 TO 15                                           '
            IF  TX.TX_Entry (I) = 0 THEN                          '
                TX.TX_Reason += ", " + TX_ID + " ROW " + HEX$ (I) + "_ MISSING"  '
                EXIT FOR                                          '
            END IF                                                '
        NEXT                                                      '
        EXIT FUNCTION                                             '
    END IF                                                        '

    '----------------------------------------------------------------------------------------------+
                                                                  '   Each TX_Entry must have 16 values CP.TX(I).TX_Entry (T) = 0                                |
    '----------------------------------------------------------------------------------------------+
    FOR I = 0 TO 15                                               '
        IF  TX.TX_Entry (I) <> 16 THEN                            '
            TX.TX_Errors += 1                                     '
            TX.TX_Reason = TX_ID + " ROW " + HEX$ (I) + "_ HAS "_ '
                + TRIM$(TX.TX_Entry (I)) + " VALUES, EXPECTING 16"   '
            EXIT FUNCTION                                         '
        END IF                                                    '
    NEXT                                                          '

    '----------------------------------------------------------------------------------------------+
    '-  If round-trip mode, verify 100% coverage                                                   |
    '----------------------------------------------------------------------------------------------+
    IF  RT_Mode = 1 THEN                                          '
        FOR I = 0 TO 255                                          '
            Test (I) = 0                                          '  Initialize test array
        NEXT                                                      '
        FOR I = 0 TO 255                                          '
            Byte_Index = TX.TX_Table (I)                          '
            IF  Test (Byte_Index) = 1 THEN                        '
                TX.TX_Errors += 1                                 '
                TX.TX_Reason = TX_ID + " TABLE INCONSISTENT WITH MODE=RT"  '
                EXIT FUNCTION                                     '
            END IF                                                '
            Test (Byte_Index) = 1                                 '
        NEXT                                                      '
    END IF                                                        '
    FUNCTION = 1                                                  '  all required fields valid
END FUNCTION                                                      ' ValidateCodepageTXData

SUB ValidateLayout(sLayout AS STRING, RCA AS RCArea)              '
'--------------------------------------------------------------------------------------------------+
'- Validate FM screen layout parameters                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL j, k, CPos, OBPos, CBPos, OpCtr, SubCtr AS LONG             '
LOCAL Layout, LH, RH AS STRING                                    '
LOCAL opers(), subs() AS STRING                                   '
   DIM opers(1 TO 30) AS STRING                                   ' Dim the Opers table
   Layout = REMOVE$(sLayout, " ")                                 ' Get copy without spaces

   '-----------------------------------------------------------------------------------------------+
   '- Parse out the Layout string                                                                  |
   '-----------------------------------------------------------------------------------------------+
   DO WHILE LEN(Layout)                                           ' While still data in string
      cPos  = INSTR(1, Layout, ",")                               ' Find first comma
      OBPos = INSTR(1, Layout, "(")                               ' Find first open bracket
      CBPos = INSTR(1, Layout, ")")                               ' Find first closing )
      IF CPos = 0 THEN CPos = LEN(Layout) + 1                     ' To handle last operand

      '--------------------------------------------------------------------------------------------+
      '- A simple keyword, style                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF OBPos = 0 OR cPos < OBPos THEN                           '
         INCR OpCtr                                               ' Bump operand Index
         opers(OpCtr) = LEFT$(Layout, cPos - 1)                   ' Copy the operand
         Layout = MID$(Layout, CPos + 1)                          ' Remove from front of Layout
         ITERATE DO                                               ' Loop-de-loop
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- A keyword( style                                                                          |
      '--------------------------------------------------------------------------------------------+
      IF CBPos = 0 THEN AnswerSub(8, "Parse error on: " + Layout) '
      INCR OpCtr                                                  ' Bump operand Index
      opers(OpCtr) = LEFT$(Layout, CBPos)                         ' Copy the operand
      Layout = MID$(Layout, CBPos + 1)                            ' Remove from front of Layout
      IF LEFT$(Layout, 1) = "," THEN Layout = MID$(Layout, 2)     ' Also get rid of the comma if present

   LOOP                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- Process each Layout operand                                                                  |
   '-----------------------------------------------------------------------------------------------+
   FOR j = 1 TO OpCtr                                             ' Loop through them
      k = INSTR(opers(j), "(")                                    ' Does it have sub-operands?
      IF k THEN                                                   ' Yes
         LH = UCASE$(LEFT$(opers(j), k - 1))                      ' Separate LH and RH
         RH = MID$(opers(j), k + 1 TO LEN(opers(j)) - 1)          '
         SubCtr = PARSECOUNT(RH, ",")                             ' Get number of sub-operands
         REDIM subs(1 TO SubCtr) AS STRING                        ' Dim the Sub-Operand table
         PARSE RH, subs(), ","                                    ' Break them out
      ELSE                                                        ' No sub-ops
         LH = UCASE$(opers(j))                                    ' Just LH
         RH = "": SubCtr = 0                                      ' No RH or Sub-ops
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Operands and Sub-operands all parsed out                                                  |
      '--------------------------------------------------------------------------------------------+
      SELECT CASE AS CONST$ LH                                    ' See what field
         CASE "NAME", "PATH", "ATTR", "SIZESHORT", "SIZELONG"     ' Check 5 byte minimum fields
            IF SubCtr > 0 THEN                                    ' Got a (..) operand?
               IF SubCtr > 1 OR VAL(subs(1)) < 5 THEN             ' Verify size
                  AnswerSub(8, "Invalid " + LH + " length")       '
               END IF                                             '
            END IF                                                '
         CASE "LINES", "MODE"                                     ' Check 6 byte minimum fields
            IF SubCtr > 0 THEN                                    ' Got a (..) operand?
               IF SubCtr > 1 OR VAL(subs(1)) < 6 THEN             ' Verify size
                  AnswerSub(8, "Invalid LINES length")            '
               END IF                                             '
            END IF                                                '
         CASE "LWDATE", "LWDATETIME", "LRDATE", "LRDATETIME", "CRDATE", "CRDATETIME"   ' Check 7 byte minimum fields
            IF SubCtr > 0 THEN                                    ' Got a (..) operand?
               IF SubCtr > 1 OR VAL(subs(1)) < 7 THEN             ' Verify size
                  AnswerSub(8, "Invalid " + LH + " length")       '
               END IF                                             '
            END IF                                                '
         CASE "PRP1", "PRP2", "PRP3", "PRP4", "PRP5", "PRP6"      ' Only PRP type possible now
            IF SubCtr <> 3  THEN                                  ' Must be 3 operands
               AnswerSub(8, "Invalid " + LH + " operand, must have 3 sub-operands") '
            END IF                                                '
            ARRAY SCAN gFMProp() FOR gFMPropNum, COLLATE UCASE, =Subs(3), TO k   '
            IF k = 0 THEN                                         ' Valid Property name?
               AnswerSub(8, "Invalid " + LH + " operand, " + Subs(3) + " is not a valid Property") '
            END IF                                                '
            IF VAL(subs(1)) < (LEN(Subs(3)) + 1) THEN             ' Verify size
               AnswerSub(8, "Invalid " + LH + " operand, length is too short")   '
            END IF                                                '
            IF (UCASE$(Subs(2)) <> "L" AND UCASE$(subs(2)) <> "R") THEN '
               AnswerSub(8, "Invalid " + LH + " operand, 2nd operand must be 'L' or 'R'") '
            END IF                                                '
        CASE ELSE                                                 '
            AnswerSub(8, "Invalid Operand: " + LH)                '

      END SELECT                                                  '

   NEXT j                                                         '
   AnswerSub(0, "OK")                                             ' Say we're OK
END SUB                                                           '

FUNCTION WarnXForm(sCmd AS STRING) AS LONG                        '
'--------------------------------------------------------------------------------------------------+
'- Warn user of XFORM loaded data                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   i =DoMessageBox("The file data loaded was created by an |KXFORM|B macro." + $CRLF + $CRLF + _   '
                   "If you continue with the |K" + sCmd + "|B command, you will be writing the data" + $CRLF + _  '
                   "as it is displayed, |KNOT|B as an XFORM supported |KSAVE|B would do." + $CRLF + _ '
                   "Do you want to continue with |K" + sCmd + "|B? ", %MB_YESNO + %MB_USERICON, "SPFLite")  '
   FUNCTION = IIF(i = %IDNO, %True, %False)                       ' Pass back the answer
END FUNCTION                                                      '

SUB      WindowPlacementRestore()                                 '
'--------------------------------------------------------------------------------------------------+
'- Re-Load Window Placement data                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL WP AS Windowplacement                                       '
DIM WPItem(1 TO 4) AS STRING                                      '
LOCAL INIStr AS STRING                                            '

   '-----------------------------------------------------------------------------------------------+
   '- Get the saved values                                                                         |
   '-----------------------------------------------------------------------------------------------+
   INIStr = gENV.ScrPosition                                      ' Get saved position
   IF ISNULL(INIStr) THEN EXIT SUB                                ' If none, do nothing
   PARSE INIStr, WPItem()                                         ' Parse the values

   '-----------------------------------------------------------------------------------------------+
   '- Get the current Window placement                                                             |
   '-----------------------------------------------------------------------------------------------+
   WP.length = SIZEOF(Windowplacement)                            ' Setup API block
   GetWindowPlacement(ghWnd, WP)                                  ' Ask for the data

   '-----------------------------------------------------------------------------------------------+
   '- Replace the Normal position values                                                           |
   '-----------------------------------------------------------------------------------------------+
   WP.rcNormalPosition.left = VAL(WPItem(1)):     WP.rcNormalPosition.right  = VAL(WPItem(2))   '
   WP.rcNormalPosition.top  = VAL(WPItem(3)):     WP.rcNormalPosition.bottom = VAL(WPItem(4))   '
   SetWindowPlacement(ghWnd, WP)                                  ' Update the data
END SUB                                                           '

SUB      WindowPlacementSave()                                    '
'--------------------------------------------------------------------------------------------------+
'- Save Window Placement data                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL WP AS Windowplacement                                       '
DIM WPItem(1 TO 4) AS STRING                                      '
LOCAL INIStr AS STRING                                            '
   WP.length = SIZEOF(Windowplacement)                            ' Setup API block
   GetWindowPlacement(ghWnd, WP)                                  ' Ask for the data
   '-----------------------------------------------------------------------------------------------+
   '- Package and save everything in the CFG file                                                  |
   '-----------------------------------------------------------------------------------------------+
   WPItem(1) = FORMAT$(WP.rcNormalPosition.left): WPItem(2)  = FORMAT$(WP.rcNormalPosition.right)  '
   WPItem(3) = FORMAT$(WP.rcNormalPosition.top):  WPItem(4) = FORMAT$(WP.rcNormalPosition.bottom)  '
   INIStr = JOIN$(WPItem(), ",")                                  ' Build one string
   gENV.ScrPosition = INIStr                                      ' Save it
   gENV.SetINITimeStamp                                           '
END SUB                                                           '

SUB      WindowSize()                                             '
'--------------------------------------------------------------------------------------------------+
'- Do a Window resize based on current actual size                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL pgno, i, j AS LONG, hDC AS DWORD                                '
LOCAL CurrX, CurrY, ClientX, ClientY, UsableX, UsableY, cRows, cCols AS LONG
STATIC LastX, LastY AS LONG                                       '
   MEntry                                                         '
   IF gResizeActive THEN MExitSub                                 ' Don't run if aleady active
   gResizeActive = %True                                          ' Tell everyone we're active
   OffTPMarkActive                                                ' Kill any Active Mark area

   '-----------------------------------------------------------------------------------------------+
   '- Get the new size of the Window                                                               |
   '-----------------------------------------------------------------------------------------------+
   DIALOG GET SIZE ghWnd TO CurrX, CurrY                          ' Get current
   DIALOG GET CLIENT ghWnd TO ClientX, ClientY                    '

   IF ABS(LastX - CurrX) < 4 AND ABS(LastY - CurrY) < 4 THEN gResizeActive = %False: MExitSub ' Do nothing until we change a lot
   LastX = CurrX: LastY = CurrY                                   ' Save the last x,y we actually process

   UsableX = ClientX - %GLM - %GRM - gScrlWidth                   ' Usable x (minus LM/RM pad and scrollbar width
   UsableY = ClientY - gTabHdrRC.Bottom - gSBHeight               ' Usable y = Client size minus Tab Header size - SB height

   '-----------------------------------------------------------------------------------------------+
   '- Adjust all the other stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF gTabsNum > 0 THEN                                           ' Initialized already?
      GRAPHIC ATTACH TP.PgHandle, TP.WindowID                     ' Using the live window
      '--------------------------------------------------------------------------------------------+
      '- Set the new fonts and get their sizes                                                     |
      '--------------------------------------------------------------------------------------------+
      TRY
         IF gScrFont THEN FONT END gScrFont
      CATCH
         EXIT TRY
      END TRY                                                     '
      TRY
         IF gScrFontUnd THEN FONT END gScrFontUnd
      CATCH
         EXIT TRY
      END TRY
      FONT NEW gENV.FontName, gENV.FontPitch, gENV.FontStyle, 1, 1 TO gScrFont   ' Get the basic font
      FONT NEW gENV.FontName, gENV.FontPitch, gENV.FontStyle + 4, 1, 1 TO gScrFontUnd  ' Get the underline version of the basic font
      GRAPHIC SET FONT gScrFont                                   ' Set the desired font
      GRAPHIC GET DC TO hDC                                       ' Get the DC for the graphic window
      gValidChars = FontGetValidChars(hDC)                        ' Build the valid chars list for this font
      GRAPHIC CELL SIZE TO gFontWidth, gFontHeight                ' Get size of a character (done in PBMain for Init)
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Convert to Text width and height, see what's changed                                         |
   '-----------------------------------------------------------------------------------------------+
   cCols = FIX(UsableX \ gFontWidth): cRows = FIX(usableY \ gFontHeight) ' Calc rows and columns
   IF cCols < 30 OR cRows < 10 THEN                               ' Stupid user?
      DoBeep                                                      '
      cCols = MAX(30, cCols): cRows = MAX(10, cRows)              ' Make them valid
   END IF                                                         '
   UsableX = (cCols * gFontWidth) + %GLM + %GRM: UsableY = cRows * gFontHeight    ' Round down
   gENV.ScrWidth = cCols: gENV.ScrHeight = cRows                  '
   gENV.SetINITimeStamp                                           '

   '-----------------------------------------------------------------------------------------------+
   '- Re-size things                                                                               |
   '-----------------------------------------------------------------------------------------------+

   '-----------------------------------------------------------------------------------------------+
   '- Set Rect to our needed Graphic size and then set the Tab to that size                        |
   '-----------------------------------------------------------------------------------------------+
   gTabRC.Top = 0:      gTabRC.Left = 0                           ' Init Tab Rect
   gTabRC.Right = UsableX: gTabRC.Bottom = UsableY                '
   TabCtrl_AdjustRect ghTab, 1, gTabRC                            ' Set Tab display to suit graphic
   TabCtrl_GetItemRect ghTab, 1, gTabHdrRC                        ' Get Tab title dimensions .Bottom = height
   CONTROL SET SIZE ghWnd, %IDC_SPFLiteTAB, gTabRC.Right - gTabRC.Left, gTabRC.Bottom - gTabRC.Top
   CONTROL SET COLOR ghWnd, %IDC_SPFLiteTAB, gStatFG, gStatBG1    ' Default color it

   '-----------------------------------------------------------------------------------------------+
   '- Now get the actual Tab size                                                                  |
   '-----------------------------------------------------------------------------------------------+
   CONTROL GET SIZE ghWnd, %IDC_SPFLiteTAB TO UsableX, UsableY    ' Now get the tab size

   '-----------------------------------------------------------------------------------------------+
   '- Re-size things                                                                               |
   '-----------------------------------------------------------------------------------------------+
   DIALOG SET SIZE ghWnd, CurrX, CurrY                            ' Set to the values
   DIALOG SET COLOR ghWnd, gStatFG, gStatBG1                      ' Default color it
   gSBWidth = CurrX                                               ' Save as SB width
   CONTROL GET SIZE ghWnd, %IDC_StatusBar TO gSBWidth, gSBHeight  ' Get the SB size

   IF gENV.VScrollBar THEN                                        ' Doing Scrollbar?
      CONTROL SET LOC  ghWnd, %IDC_ScrollBar, gTabRC.Right + 2, 0 '
      CONTROL SET SIZE ghWnd, %IDC_ScrollBar, gScrlWidth, gTabRC.Bottom - gTabRC.Top   '
   END IF                                                         '

   StatusBarSetup                                                 ' Go set up the Status Bar

   InitFMLayout                                                   ' Adjust FM area

   '-----------------------------------------------------------------------------------------------+
   '- Re-do the existing tabs                                                                      |
   '-----------------------------------------------------------------------------------------------+
   PgNo = TP.PgNumber                                             ' Save what page we're on for later
   IF gTabsNum > 0 THEN                                           ' If at least one tab page
      FOR i = 1 TO gTabsNum                                       ' Establish the tabs (again)
         TP = gTabs(i)                                            ' Get tab data addressable
         IF ((TP.HPanelSplit = 0) AND (TP.VPanelSplit = 0)) THEN  ' No Split active?
            TP.PanelSet(1, 1, cRows - gENV.PFKShow, 1, cCols, "N", %False)

         ELSEIF TP.HPanelSplit <> 0 THEN                          ' Horizontal split?
            TP.HPanelSplit = CEIL((TP.GPPanelPct * (cRows - gENV.PFKShow - 1)) / 100) + 1 ' Calc new relative size of P1
            TP.PanelSet(1, 1, TP.HPanelSplit - 1, 1, cCols, "H", %False)
            TP.PanelSet(2, TP.HPanelSplit + 1, cRows - gENV.PFKShow, 1, cCols, "H", %False)

         ELSEIF TP.VPanelSplit <> 0 THEN                          ' Horizontal split?
            TP.VPanelSplit = CEIL((TP.GPPanelPct * (gENV.ScrWidth - 1) / 100)) + 1 ' Calc new relative size of P1
            TP.PanelSet(1, 1, cRows - gENV.PFKShow, 1, TP.VPanelSplit - 1, "V", %False)
            TP.PanelSet(2, 1, cRows - gENV.PFKShow, TP.VPanelSplit + 1, cCols, "V", %False)
         END IF                                                   '

         TP.SPMarkline(0): TP.SwapSLin = 0                        ' Clear marked lines for Edit and FM
         CONTROL SET SIZE TP.PgHandle, TP.WindowID, CurrX, CurrY  ' Resize the graphic
         GRAPHIC ATTACH TP.PgHandle, TP.WindowID                  ' Set as the default graphic area
         GRAPHIC SET FONT gScrFont                                ' Set the font
         GRAPHIC CLEAR gTxtLoBG1                                  ' Clear it

         TP.ScreenDim(cCols)                                      ' Redim the Screen shadow copy
         TP.DispScreen                                            ' Re-display stuff
      NEXT i                                                      '
      TP = gTabs(PgNo)                                            ' Put back starting page number
      TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber              ' Select its tab
      TP.WindowTitle                                              ' Alter window title
      DoCursor                                                    ' Activate cursor
   END IF                                                         '
   WindowPlacementSave                                            ' Save full window position values
   gResizeActive = %False                                         ' Say we're done
   MExit                                                          '
END SUB                                                           '
