'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- TabData.inc                                                                                     |
'--------------------------------------------------------------------------------------------------+
                                                                  '
CLASS cObjTabData                                                 '

   '-----------------------------------------------------------------------------------------------+
   '- Profile data                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE FCB         AS iFCB                                   ' FCB for the tab
   INSTANCE FCBPrimName AS STRING                                 ' Primary filename for the FCB
   INSTANCE EFTOVName   AS STRING                                 ' EFT source Profile name
   INSTANCE EFTOVCtr    AS LONG                                   ' EFT Override Count
   INSTANCE EFTSkip     AS LONG                                   ' EFT Says to Skip the file
   INSTANCE EFTOVList() AS STRING                                 ' EFT Override command list

   '-----------------------------------------------------------------------------------------------+
   '- Find Criteria Data                                                                           |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE PTBL        AS iObjParse                              ' Parse Object pointer
   INSTANCE PTBLSrch    AS iObjParse                              ' Parse Object full search
   INSTANCE PTBLLine    AS iObjParse                              ' Parse Object line search

   '-----------------------------------------------------------------------------------------------+
   '- These are copies of the FCB.varname, used only so that we can do VARPTR of them for L(i).LTxt|
   '-----------------------------------------------------------------------------------------------+
   INSTANCE BndText     AS STRING                                 ' BNDS
   INSTANCE MarkLine    AS STRING                                 ' MARK
   INSTANCE MaskLine    AS STRING                                 ' MASK
   INSTANCE WordInput   AS STRING                                 ' WORD
   INSTANCE TabsLine    AS STRING                                 ' TABS

   '-----------------------------------------------------------------------------------------------+
   '- Other Tab related data                                                                       |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE AttnDo      AS LONG                                   ' Flags of ToDo at next attention
   INSTANCE ActionCtr   AS LONG                                   ' ACTION counter
   INSTANCE ActionStop  AS LONG                                   ' Stop ACTION (set by End)
   INSTANCE BStack()    AS LONG                                   ' Buffer Stack for indexes to T() and TW() pools
   INSTANCE ClipName    AS STRING                                 ' Clipboard name loaded
   INSTANCE ClipFile    AS STRING                                 ' Name of the real data version
   INSTANCE cDesired    AS INTEGER                                ' Cursor desired
   INSTANCE cCurrent    AS INTEGER                                ' Cursor currently
   INSTANCE cMode       AS LONG                                   ' Cursor Mode
   INSTANCE cModeSave   AS LONG                                   ' Saved Cursor Mode
   INSTANCE Cmnt        AS iCmnt                                  ' Clr Comment storage
   INSTANCE ClrDLM      AS STRING                                 ' Delimiters
   INSTANCE ClrESC      AS STRING                                 ' Escape character (or blank)
   INSTANCE ClrQuoted   AS LONG                                   ' Quoted string color
   INSTANCE ClrQLeft    AS STRING                                 ' Quoted left DLMs
   INSTANCE ClrQRight   AS STRING                                 ' Quoted right DLMs
   INSTANCE ClrComList  AS STRING                                 ' String of 2 digit Scheme #s for comments
   INSTANCE ClrNumeric  AS LONG                                   ' Numeric string color
   INSTANCE ClrKWrdNum  AS LONG                                   ' Number of KW entries
   INSTANCE ClrKW()     AS STRING                                 ' Table of colorize Kwds
   INSTANCE ClrKWAns()  AS LONG                                   ' Table of colorize Kwd answers (Scheme #)
   INSTANCE ClrKWIX()   AS ClrKWIndex                             ' Index of Start/End by length
   INSTANCE ClrKWDlm()  AS LONG                                   ' Clr answers for 1 character 'words'
   INSTANCE ClrKWLoad   AS LONG                                   ' Table Has just been loaded
   INSTANCE CmdStack()  AS STRING                                 ' Command line stack
   INSTANCE CmdStackNum AS LONG                                   ' Number of entries in CmdStack()
   INSTANCE CsrLinDX    AS LONG                                   ' Hidden DX cursor line
   INSTANCE CurrPCmd    AS STRING                                 ' Latest (running) PCmd
   INSTANCE CursLine    AS STRING                                 ' Line under the Cursor at last AttnFlag
   INSTANCE CursWord    AS STRING                                 ' Word under the Cursor at last AttnFlag
   INSTANCE CursLNum    AS LONG                                   ' LNum of CursWord
   INSTANCE CursCol     AS LONG                                   ' Col # of CursWord
   INSTANCE CursColE    AS LONG                                   ' Col # of CursWord end
   INSTANCE CursFindInv AS RECT                                   ' FIND hilite under the cursor
   INSTANCE Encoding    AS STRING                                 ' Character Encoding (ANSI, UTF8, UTF16, UTF16BE)
   INSTANCE ErrMsgTbl() AS STRING                                 ' Table of the error message
   INSTANCE ErrMsgTblC  AS LONG                                   ' # entries in Table of error messages
   INSTANCE ErrMsgHigh  AS LONG                                   ' High RC in the list
   INSTANCE ErrMsgTop   AS STRING                                 ' Top severity message text
   INSTANCE ErrMsgLast  AS STRING                                 ' ErrMsgTbl as of last reset
   INSTANCE FileRecs    AS LONG                                   ' # lines written
   INSTANCE FindWord    AS LONG                                   ' Word/Chars mode
   INSTANCE FIXCtr      AS LONG                                   ' Find Index counter
   INSTANCE Flag        AS LONG                                   ' Misc bit flags
   INSTANCE Flag2       AS LONG                                   ' More misc bit flags
   INSTANCE Found1stLin AS LONG                                   ' Find 1st line
   INSTANCE Found1stLen AS LONG                                   ' Find 1st length
   INSTANCE Found1stCol AS LONG                                   ' Find 1st column
   INSTANCE FoundLstLin AS LONG                                   ' Find Last    aqline
   INSTANCE FoundLstLen AS LONG                                   ' Find Last length
   INSTANCE FoundLstCol AS LONG                                   ' Find Last column
   INSTANCE KBTabFree   AS LONG                                   ' Temp ignore TabsBNDS
   INSTANCE gHandle     AS DWORD                                  ' Window handle to the graphic area
   INSTANCE hPCRE       AS DWORD                                  ' PCRE area returned by pcre_compile
   INSTANCE pWatchData  AS WatchData POINTER                      ' Pointer to the param list
   INSTANCE pUNDOData   AS UNDOType POINTER                       ' Pointer to the UNDO Data
   INSTANCE UNDOThread  AS LONG                                   ' Thread address
   INSTANCE wResult     AS DWORD                                  '
   INSTANCE InsTbl()    AS LONG                                   ' Table of insert lines
   INSTANCE InsCount    AS LONG                                   ' No. of insert lines
   INSTANCE L()         AS Dataline                               ' TEXT control array
   INSTANCE LCtr        AS LONG                                   ' Free items in L()
   INSTANCE LastLine    AS LONG                                   ' Last line in the L() array
   INSTANCE LoadErrs()  AS STRING                                 ' File Load error list
   INSTANCE LoadErrsCtr AS LONG                                   ' # entries in LoadErrs
   INSTANCE HandleLast  AS LONG                                   ' Last issued Handle
   INSTANCE HandleMax   AS LONG                                   ' Max active handle
   INSTANCE HandleMin   AS LONG                                   ' Min active handle
   INSTANCE LastReal    AS LONG                                   ' Last real line (line count)
   INSTANCE LastPTCurs  AS LONG                                   ' Last PT Cursor col
   INSTANCE LastRulCol  AS LONG                                   ' Last Ruler Cursor col
   INSTANCE LastRulRow  AS LONG                                   ' Last Ruler Cursor row
   INSTANCE LineFirst   AS LONG                                   ' First text line (** top of data **)
   INSTANCE LineLast    AS LONG                                   ' Last  text line (** end of data **)
   INSTANCE LNKRealName AS STRING                                 ' Real name of a LNK in FM
   INSTANCE LocColor    AS LONG                                   ' LOCATE color index
   INSTANCE LocFind     AS STRING                                 ' LOCATE/FIND last command
   INSTANCE LocFlag     AS QUAD                                   ' LOCATE Flag
   INSTANCE LocLine     AS LONG                                   ' LOCATE last found line (resume)
   INSTANCE LocLine1stR AS LONG                                   ' LOCATE last found line (1st occurrence)
   INSTANCE LocLineLstR AS LONG                                   ' LOCATE last found line (Last occurrence)
   INSTANCE LocDir      AS LONG                                   ' LOCATE direction
   INSTANCE LocLabel1   AS STRING                                 ' LOCATE label1 string
   INSTANCE LocLabel2   AS STRING                                 ' LOCATE label2 string
   INSTANCE LocLabLine1 AS LONG                                   ' LOCATE label1 string
   INSTANCE LocLabLine2 AS LONG                                   ' LOCATE label2 string
   INSTANCE LocNotFound AS LONG                                   ' LOCATE last was Not Found
   INSTANCE LocNFDir    AS LONG                                   ' LOCATE Not Found Dir
   INSTANCE LocTag      AS STRING                                 ' LOCATE tag string
   INSTANCE LocLength   AS LONG                                   ' LOCATE length for LOCATE LONG nnn
   INSTANCE LocNVar     AS LONG                                   ' LOCATE NOTE variety
   INSTANCE MacName     AS STRING                                 ' Last Macro invoked
   INSTANCE MacWarn     AS LONG                                   ' Macro overlap warning done
   INSTANCE MarkRect    AS RECT                                   ' Mark - Row/Col coordinates of mark
   INSTANCE MarkRectS   AS RECT                                   ' Mark - Pixel   coordinates of mark
   INSTANCE MaxLength   AS LONG                                   ' Length of maximum Text line
   INSTANCE MEditCount  AS LONG                                   ' MEDIT count
   INSTANCE MEditList() AS STRING                                 ' MEDIT filename list
   INSTANCE MEditFlag() AS LONG                                   ' MEDIT filename flags
   INSTANCE MiscZone    AS LONG                                   ' MiscMark - Screen Zonen
   INSTANCE MiscRect    AS RECT                                   ' MiscMark - Row/Col coordinates of mark
   INSTANCE MiscRectS   AS RECT                                   ' MiscMark - Pixel coordinates of mark
   INSTANCE PA2Word     AS STRING                                 ' PA2 SAVE COPIES
   INSTANCE PA2Mark     AS STRING                                 '
   INSTANCE PA2Mask     AS STRING                                 '
   INSTANCE PA2Tabs     AS STRING                                 '
   INSTANCE PA2Bnds     AS STRING                                 '
   INSTANCE pCommand    AS STRING                                 ' Working (current) command
   INSTANCE pCommandRaw AS STRING                                 ' pCommand before PFK prepending
   INSTANCE pCommandPrv AS STRING                                 ' pCommand previous if prefixed by &
   INSTANCE PIC         AS PIC_type                               ' Picture string control area
   INSTANCE PrevPCmd    AS STRING                                 ' Previous PCmd
   INSTANCE PgHandle    AS LONG                                   ' Handle of edit window
   INSTANCE PgNumber    AS LONG                                   ' Page number of the Tab
   INSTANCE Prof1       AS STRING                                 ' Profile display 1
   INSTANCE Prof2       AS STRING                                 ' Profile display 2
   INSTANCE Prof3       AS STRING                                 ' Profile display 3
   INSTANCE Prof4       AS STRING                                 ' Profile display 4
   INSTANCE Prof5       AS STRING                                 ' Profile display 5
   INSTANCE Prof6       AS STRING                                 ' Profile display 6
   INSTANCE EFT1        AS STRING                                 ' EFT     display 1
   INSTANCE ResetClr    AS LONG                                   ' Reset color requested color
   INSTANCE ST()        AS STRING                                 ' PA2 Text save
   INSTANCE SW()        AS WSTRING                                ' PA2 Attr save
   INSTANCE SavCurCol   AS LONG                                   ' Saved Cursor Column
   INSTANCE SavCurLin   AS LONG                                   ' Saved Cursor Line
   INSTANCE SavFilLCtl  AS STRING                                 ' For range type if used
   INSTANCE ScrollLast  AS STRING                                 ' Last displayed ScrlAmtC
   INSTANCE sCurPrio    AS INTEGER                                ' Priority of current sCur... entries
   INSTANCE sCurLin     AS LONG                                   ' Current winning line number
   INSTANCE sCurScrl    AS LONG                                   ' Current winning SCRL operand
   INSTANCE sCurHexl    AS LONG                                   ' Current winning Hex line
   INSTANCE sCol        AS LONG                                   ' Search col
   INSTANCE ScrImage()  AS STRING                                 ' Screen image in text mode
   INSTANCE sDir        AS LONG                                   ' Search Dir
   INSTANCE SlecSCol    AS LONG                                   ' Select - Start Column
   INSTANCE SlecECol    AS LONG                                   ' Select - End Column
   INSTANCE SlecSLin    AS LONG                                   ' Select - Start Line
   INSTANCE SlecELin    AS LONG                                   ' Select - End Line
   INSTANCE sLine       AS LONG                                   ' Search Line
   INSTANCE SpellClr    AS LONG                                   ' Spell hilite color
   INSTANCE SpellCol    AS LONG                                   ' Spell word 1st Col
   INSTANCE SpellEnd    AS LONG                                   ' Spell word end Col
   INSTANCE SpellLin    AS LONG                                   ' Spell word Line
   INSTANCE SwapLines   AS LONG                                   ' Swap - # of data lines
   INSTANCE SwapSCol    AS LONG                                   ' Swap - Start Column
   INSTANCE SwapECol    AS LONG                                   ' Swap - End Column
   INSTANCE SwapSLin    AS LONG                                   ' Swap - Start Line
   INSTANCE SwapELin    AS LONG                                   ' Swap - End Line
   INSTANCE SwapRect    AS RECT                                   ' Swap - Saved Line/Column range marked
   INSTANCE T()         AS STRING                                 ' To hold the dynamic TEXT strings
   INSTANCE TW()        AS WSTRING                                ' To hold the dynamic Attr strings
   INSTANCE TTCtr       AS LONG                                   ' Free items in T()
   INSTANCE TabsDflt    AS STRING                                 ' Default tabs
   INSTANCE TCtr        AS LONG                                   ' Touch counter
   INSTANCE TTbl()      AS TouchEntry                             ' Touch table
   INSTANCE TopPCmd     AS STRING                                 ' Top Level PCmd
   INSTANCE TabMode     AS LONG                                   ' Tab Mode flags
   INSTANCE TrkStack()  AS TrkStackT                              ' Track Stack
   INSTANCE TrkNext     AS LONG                                   ' Next Trk ID
   INSTANCE TrkIX       AS LONG                                   ' Current Trk Stack Index
   INSTANCE TrkAfter    AS LONG                                   ' After Track needed
   INSTANCE UBoundL     AS LONG                                   ' Current UBound of L()
   INSTANCE UBoundT     AS LONG                                   ' Current UBound of T()
   INSTANCE Undo()      AS UndoType                               ' Array of Undo stuff
   INSTANCE UndoLast    AS LONG                                   ' Last written item
   INSTANCE UndoCurr    AS LONG                                   ' Current item restored/saved
   INSTANCE VisTop      AS LONG                                   ' Visible Top of screen
   INSTANCE VisBot      AS LONG                                   ' Visible Bottom of screen
   INSTANCE WatchFlag   AS STRING                                 ' WatchFlag "D" Deleted "M" Modified
   INSTANCE WindowID    AS LONG                                   ' Dialog Window ID
   INSTANCE XFormActive AS STRING                                 ' Name of XForm if active

   '-----------------------------------------------------------------------------------------------+
   '- Panel Control Data                                                                           |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE P1, P2      AS PanelCtl                               ' Primary, Secondary PANEL controls
   INSTANCE P           AS PanelCtl PTR                           ' Pointer to absolute Active PANEL control
   INSTANCE PPActive    AS PanelCtl PTR                           ' The active P (user perspective)
   INSTANCE HPanelSplit AS LONG                                   ' Horizontal Panel Split line
   INSTANCE HPanelSize  AS LONG                                   ' Horizontal size at last split
   INSTANCE VPanelSplit AS LONG                                   ' Vertical Panel Split columne
   INSTANCE VPanelSize  AS LONG                                   ' Vertical size at last split

   '-----------------------------------------------------------------------------------------------+
   '- File Manager Data                                                                            |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE FMode       AS LONG                                   ' Current FM mode of the tab
   INSTANCE FPath       AS STRING                                 ' Default directory path
   INSTANCE FMask       AS STRING                                 ' Default file mask
   INSTANCE FileListNm  AS STRING                                 ' Active recent file list name
   INSTANCE ScrlAmtC    AS STRING                                 ' Scroll Amount field (Char)
   INSTANCE LFPath      AS STRING                                 ' Last File Path
   INSTANCE LFMask      AS STRING                                 ' Last File Mask
   INSTANCE LFileListNm AS STRING                                 ' Last FileList Name
   INSTANCE LScrlAmtC   AS STRING                                 ' Last Scroll Amount
   INSTANCE DefSort     AS STRING                                 ' Default FM sort
   INSTANCE DefSortCol  AS LONG                                   ' Default FM sort column number
   INSTANCE DefFirstCol AS LONG                                   ' Default FM first column (after FNAME)
   INSTANCE DefActCol() AS LONG                                   ' Active column numbers displayed
   INSTANCE DirSort     AS STRING                                 ' Defalt Dir positioning
   INSTANCE LastTop     AS LONG                                   ' TopScrn as at last display
   INSTANCE FMMarkdSLin AS LONG                                   ' Last marked screen line
   INSTANCE FMMarkdALin AS LONG                                   ' Last marked gFMD line number
   INSTANCE FFSearch    AS STRING                                 ' FM FF search operand
   INSTANCE FSearch     AS STRING                                 ' FM Find search operand
   INSTANCE LastLoc     AS LONG                                   ' FM Last found line number
   INSTANCE FFCmd       AS STRING                                 ' FF command string
   INSTANCE MEditCmd    AS STRING                                 ' The MEDit command string
   INSTANCE OFrmFPath   AS STRING                                 ' Tab opened from FM Path variables
   INSTANCE OFrmFMask   AS STRING                                 '
   INSTANCE OFrmFileL   AS STRING                                 '
   INSTANCE FMLCmdNumber  AS LONG                                 ' Number of Line commands
   INSTANCE FMLCodeNumber AS LONG                                 ' Number of Line code routines
   INSTANCE FMLCodeTable()AS DWORD                                ' Code table (Temporary)


   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
   LOCAL i, j AS LONG, t AS STRING                                '
   DIM EFTOVList(0 TO 50) AS INSTANCE STRING                      ' EFT override Command List
      EFTOVCtr    = gEFTOVCTR: gEFTOVCtr = 0                      ' EFT Override Count
      FOR i = 0 TO EFTOVCTR                                       '
         EFTOVList(i) = gEFTOVList(i)                             '
         gEFTOVList(i) = ""                                       '
      NEXT i                                                      '
      LET FCB      = CLASS "cFCB"                                 ' Tab's FCB
      LET Cmnt     = CLASS "cCmnt"                                ' Clr Comment storage
      LET PTBLSrch = CLASS "cObjParse"                            ' Parse Object Full Search
      LET PTBLLine = CLASS "cObjParse"                            ' Parse Object Line Search
      LET PTBL     = PTBLLine                                     ' Set Parse Object Pointer to PTBLLine

      '--------------------------------------------------------------------------------------------+
      '- Copies of the FCB.varname, used only so that we can do VARPTR of them for L(i).LTxt       |
      '--------------------------------------------------------------------------------------------+
      BndText     = ""                                            ' BNDS
      MarkLine    = ""                                            ' MARK
      MaskLine    = ""                                            ' MASK
      WordInput   = ""                                            ' WORD
      TabsLine    = ""                                            ' TABS

      '--------------------------------------------------------------------------------------------+
      '- initialize the Tab defaults                                                               |
      '--------------------------------------------------------------------------------------------+
      AttnDo      = 0                                             ' Flags of ToDos at next attention
      ActionCtr   = 0                                             ' Action counter
      ActionStop  = %False                                        ' Stop Action flag
  DIM BStack(100000) AS INSTANCE LONG                             ' Initial Buffer Stack
      ClipName    = ""                                            ' Name of the loaded CLIP data
      ClipFile    = ""                                            ' Name of the real data file
      cDesired    = 0                                             ' Cursor desired
      cCurrent    = 0                                             ' Cursor currently
      cMode       = 0                                             ' Cursor Mode (True = Insert mode)
      cModeSave   = 0                                             ' Cursor Mode (Saved)

      ClrDLM      = ""                                            ' Delimiters
      ClrESC      = ""                                            ' Escape char
      ClrQuoted   = 0                                             ' Quoted string color
      ClrQLeft    = ""                                            ' Quoted left DLM
      ClrQRight   = ""                                            ' Quoted right DLM
      ClrNumeric  = 0                                             ' Numeric string color
      ClrKWrdNum  = 0                                             ' Number of KW entries
  DIM ClrKW(1 TO 1000) AS INSTANCE STRING                         ' Table of colorize Kwds
  DIM ClrKWAns(1 TO 1000) AS INSTANCE LONG                        ' Table of colorize Kwd answers
  DIM ClrKWIX(255) AS INSTANCE ClrKWIndex                         ' Index of Start/End by length
  DIM ClrKWDlm(255) AS INSTANCE LONG                              ' Clr answers for 1 character 'words'
      ClrKWLoad   = 0                                             ' Table was just loaded
  DIM CmdStack(20) AS INSTANCE STRING                             ' Stacked Command line(s)
      CmdStackNum = 0                                             ' Number of stacked commands
      CsrLinDX    = 0                                             ' Hidden DX line number
      CursLine    = ""                                            ' Line under the Cursor at last AttnFlag
      CurrPCmd    = " "                                           ' Latest (running) PCmd
      CursWord    = ""                                            ' Word under the Cursor at last AttnFlag
      CursLNum    = 0                                             ' LNum of CursWord
      CursCol     = 0                                             ' Column of CursWord
      CursColE    = 0                                             ' Column of CursWord end
      Encoding    = "ANSI"                                        ' Default to ANSI as usual
  DIM ErrMsgTbl(1 TO 100) AS INSTANCE STRING                      ' Table of error messages
      ErrMsgTblC  = 0                                             ' Count of Table of error messages
      ErrMsgHigh  = 0                                             ' High RC in the list
      ErrMsgTop   = ""                                            ' High RC message
      ErrMsgLast  = ""                                            ' Previous Err table
      FileRecs    = 0                                             ' # Recs written?
      FindWord    = gENV.FindWord                                 ' WORD / Chars mode from global
      FIXCtr      = 0                                             ' FIND Index counter
      Flag        = 0                                             ' Misc bit flags
      Flag2       = 0                                             ' More misc bit flags
      Found1stLin = 0                                             ' Find 1st line
      Found1stLen = 0                                             ' Find 1st length
      Found1stCol = 0                                             ' Find 1st column
      FoundLstLin = 0                                             ' Find Last line
      FoundLstLen = 0                                             ' Find Last length
      FoundLstCol = 0                                             ' Find Last column
      KBTabFree   = 0                                             ' Temp ignore TabBNDS
      gHandle     = 0                                             ' Graphic window handle
      hPCRE       = 0                                             ' PCRE compile area
  DIM InsTbl(1 TO 1000) AS INSTANCE LONG                          ' Table of insert lines
      InsCount    = 0                                             ' No. of insert lines
  DIM L(100000)   AS INSTANCE Dataline                            ' TEXT control array
      LCtr        = 100000                                        ' Number free in L()
      LastLine    = 2                                             ' Last Line
  DIM LoadErrs(1 TO 50) AS INSTANCE STRING                        ' Table of Load errors
      HandleLast  = 0                                             ' Last Handle
      HandleMax   = 0                                             ' Max active handle
      HandleMin   = 0                                             ' Min active handle
      LastReal    = 0                                             ' Last Real Line (Line Count)
      LastPTCurs  = 0                                             ' Last PT Cursor col
      LastRulCol  = 0                                             ' Last Ruler Cursor col
      LastRulRow  = 0                                             ' Last Ruler Cursor row
      LineFirst   = 0                                             ' First text line (** top of data **)
      LineLast    = 0                                             ' Last  text line (** end of data **)
      LNKRealName = ""                                            ' Real name of a LNK in FM
      LocColor    = 0                                             ' LOCATE color Index
      LocFind     = ""                                            ' LOCATE/FIND last command
      LocFlag     = 0                                             ' LOCATE Flag
      LocLine     = 0                                             ' LOCATE last found line resume
      LocLine1stR = 0                                             ' LOCATE last found line real line (1st one)
      LocLineLstR = 0                                             ' LOCATE last found line real line (Last one)
      LocDir      = 1                                             ' LOCATE Direction
      LocLabel1   = ""                                            ' LOCATE label1 string
      LocLabel2   = ""                                            ' LOCATE label2 string
      LocLabLine1 = 0                                             ' LOCATE label1 string
      LocLabLine2 = 0                                             ' LOCATE label2 string
      LocNotFound = 0                                             ' LOCATE last not found
      LocNFDir    = 0                                             ' LOCATE not found dir
      LocTag      = ""                                            ' LOCATE tag string
      LocLength   = 0                                             ' LOCATE length
      LocNVar     = 0                                             ' LOCATE NOTE variety
      MacName     = ""                                            ' Last Macro invoked
      MacWarn     = 0                                             ' Macro overlap warning issued
      MaxLength   = 0                                             ' Length of longest line
      MEditCount  = 0                                             ' MEDIT count
  DIM MEditList(1 TO 20) AS INSTANCE STRING                       ' MEDIT filename list
  DIM MEditFlag(1 TO 20) AS INSTANCE LONG                         ' MEDIT filename flags
      MiscZone    = 0                                             ' MiscMark - Screen Zone
      Flag2       = Flag2 OR IIF(gENV.InsMode, %NsrtFlag, 0)      ' Set default Insert mode
      Flag2       = Flag2 OR IIF(gENV.InsMode, %NsrtSave, 0)      ' Set default Insert mode
      pCommand    = ""                                            ' Working (current) command
      pCommandRaw = ""                                            ' pCommand prior to PFK prepending
      pCommandPrv = ""                                            ' pCommand previous if & prefixed
      PrevPCmd    = " "                                           ' Previous PCmd
      PgHandle    = 0                                             ' No handle to start
      PgNumber    = 0                                             ' No Page Number to start
      Prof1       = ""                                            ' Profile display 1
      Prof2       = ""                                            ' Profile display 2
      Prof3       = ""                                            ' Profile display 3
      Prof4       = ""                                            ' Profile display 4
      Prof5       = ""                                            ' Profile display 5
      Prof6       = ""                                            ' Profile display 6
      EFT1        = ""                                            ' EFT     display 1
      ResetClr    = 0                                             ' Reset color requested color
  DIM ST(300) AS INSTANCE STRING                                  ' PA2 text save
  DIM SW(300) AS INSTANCE WSTRING                                 ' PA2 attr save
      SavCurCol   = 11                                            ' Save Cursor Column
      SavCurLin   = 1                                             ' Save Cursor Line
      ScrollLast  = "CSR"                                         ' Last displayed scroll amount
      sCurPrio    = 0                                             ' Priority of current sCur... entries
      sCurLin     = 0                                             ' Current winning line
      sCurScrl    = 0                                             ' Current winning SCRL operand
      sCurHexl    = 0                                             ' Current winning Hex Line
      sCol        = 0                                             ' Search col
  DIM ScrImage(1 TO 300) AS INSTANCE STRING                       ' Screen image in text mode
      sDir        = 0                                             ' Search Dir
      SlecSCol    = 0                                             ' Select - Start Column
      SlecECol    = 0                                             ' Select - End Column
      SlecSLin    = 0                                             ' Select - Start Line
      SlecELin    = 0                                             ' Select - End Line
      sLine       = 0                                             ' Search Line
      SpellClr    = 0                                             ' Spell Hilite color
      SpellCol    = 0                                             ' Spell color found 1st col
      SpellEnd    = 0                                             ' Spell color found end Col
      SpellLin    = 0                                             ' Spell color folund line
      SwapLines   = 0                                             ' Swap - # of data lines
      SwapSCol    = 0                                             ' Swap - Start Column
      SwapECol    = 0                                             ' Swap - End Column
      SwapSLin    = 0                                             ' Swap - Start Line
      SwapELin    = 0                                             ' Swap - End Line
  DIM T(100000)    AS INSTANCE STRING                             ' To hold the dynamic TEXT strings
  DIM TW(100000)   AS INSTANCE WSTRING                            ' To hold the dynamic Attr strings
      TTCtr       = 100000                                        ' Number free in T()
      TabsDflt    = ""                                            ' Default tabs
      TCtr        = 0                                             ' Touch counter
  DIM TrkStack(1 TO %TrkMax) AS INSTANCE TrkStackT                ' Track Stack
      TrkNext     = 0                                             ' Next Track ID
      TrkIX       = 1                                             ' Reset Trk Stack index
  DIM TTbl(1 TO 300) AS INSTANCE TouchEntry                       ' Touch table
      TopPCmd     = ""                                            ' Top PCmd
      TabMode     = gENV.PMode                                    ' Tab Mode flags
      UBoundL     = 100000                                        ' Current table ubound
      UBoundT     = 100000                                        ' Current table ubound
  DIM Undo(gENV.UndoLevels) AS INSTANCE UndoType                  ' Undo slot data
      UndoLast    = 0                                             ' Last written item
      UndoCurr    = 0                                             ' Current undo number
      WatchFlag = " "                                             ' WatchFlag
      WindowID    = 0                                             ' No Dialog ID to start
      XFormActive = ""                                            ' XForm name if active

   '-----------------------------------------------------------------------------------------------+
   '- initialize the FM Data                                                                       |
   '-----------------------------------------------------------------------------------------------+
      FMode       = 0                                             ' Current FM mode of the tab
      FPath       = ""                                            ' Default directory path
      FMask       = ""                                            ' Default file mask
      ScrlAmtC    = "PAGE"                                        ' Scroll Amount field (Char)
      LFPath      = ""                                            ' Last File Path
      LFMask      = ""                                            ' Last File Mask
      LFileListNm = ""                                            ' Last FileList Name
      LScrlAmtC   = ""                                            ' Last Scroll Amount
      DefSort     = "Name+"                                       ' Default FM sort
      DefSortCol  = 1                                             ' Default FM sort column
      DefFirstCol = 2                                             ' First column following FNAME
  DIM DefActCol(1 TO 20) AS INSTANCE LONG                         ' Active column numbers
      DirSort     = "Dir+"                                        ' Default Fm Dir positioning
      LastTop     = 0                                             ' TopScrn as at last display
      FMMarkdSLin = 0                                             ' Last marked screen line number
      FMMarkdALin = 0                                             ' Last marked gFMD line number
      FilelistNm  = ""                                            ' Active recent file list name
      FFSearch    = ""                                            ' FM FF search operand
      FSearch     = ""                                            ' FM Find search operand
      LastLoc     = 0                                             ' FM Last found line number
      MEditCmd    = ""                                            ' MEdit command string
      FFCmd       = ""                                            ' FF command string
      OFrmFPath   = ""                                            ' Tab opened from FM Path variables
      OFrmFMask   = ""                                            '
      OFrmFileL   = ""                                            '

      '--------------------------------------------------------------------------------------------+
      '- initialize the FM Line command table                                                      |
      '--------------------------------------------------------------------------------------------+
      FMLCmdNumber = 130                                          ' Set current number of line commands
      FMLCodeNumber = 30                                          ' Set current number of command routines
      IF gTabsNum <> 1 THEN EXIT METHOD                           ' Only do this for FM Tab
      DIM gFMLCmdTable(1 TO FMLCmdNumber) AS GLOBAL FMLCtlValEnt  ' Dim the global Line command table
      DIM FMLCodeTable(1 TO FMLCodeNumber) AS DWORD               ' Dim the Primary code table

      '--------------------------------------------------------------------------------------------+
      '- Add the CodePtr values (CODEPTR cannot exist in DATA statements                           |
      '--------------------------------------------------------------------------------------------+
      FMLCodeTable(01) = CODEPTR(FMLCmdAdd)                       '
      FMLCodeTable(02) = CODEPTR(FMLCmdAll)                       '
      FMLCodeTable(03) = CODEPTR(FMLCmdBrowse)                    '
      FMLCodeTable(04) = CODEPTR(FMLCmdBackup)                    '
      FMLCodeTable(05) = CODEPTR(FMLCmdCancel)                    '
      FMLCodeTable(06) = CODEPTR(FMLCmdClone)                     '
      FMLCodeTable(07) = CODEPTR(FMLCmdDelete)                    '
      FMLCodeTable(08) = CODEPTR(FMLCmdDir)                       '
      FMLCodeTable(09) = CODEPTR(FMLCmdEdit)                      '
      FMLCodeTable(10) = CODEPTR(FMLCmdEFT)                       '
      FMLCodeTable(11) = CODEPTR(FMLCmdEnd)                       '
      FMLCodeTable(12) = CODEPTR(FMLCmdExclude)                   '
      FMLCodeTable(13) = CODEPTR(FMLCmdForget)                    '
      FMLCodeTable(14) = CODEPTR(FMLCmdFProp)                     '
      FMLCodeTable(15) = CODEPTR(FMLCmdLines)                     '
      FMLCodeTable(16) = CODEPTR(FMLCmdMEdit)                     '
      FMLCodeTable(17) = CODEPTR(FMLCmdNorm)                      '
      FMLCodeTable(18) = CODEPTR(FMLCmdOpenF)                     '
      FMLCodeTable(19) = CODEPTR(FMLCmdPrint)                     '
      FMLCodeTable(20) = CODEPTR(FMLCmdRename)                    '
      FMLCodeTable(21) = CODEPTR(FMLCmdRestore)                   '
      FMLCodeTable(22) = CODEPTR(FMLCmdSave)                      '
      FMLCodeTable(23) = CODEPTR(FMLCmdSelect)                    '
      FMLCodeTable(24) = CODEPTR(FMLCmdSubmit)                    '
      FMLCodeTable(25) = CODEPTR(FMLCmdTouch)                     '
      FMLCodeTable(26) = CODEPTR(FMLCmdView)                      '
      FMLCodeTable(27) = CODEPTR(FMLCmdWOpen)                     '
      FMLCodeTable(28) = CODEPTR(FMLCmdWDir)                      '
      FMLCodeTable(29) = CODEPTR(FMLCmdCopy)                      '
      FMLCodeTable(30) = CODEPTR(FMLCmdIEdit)                     '

      '- Line command table
      '-    Cmnd     - The 8 char command
      '-    IX       - The Index of the code routine in the Line routine table. 999 = no routine a Dest operand
      '-    Blk      - The command is the Block mode format
      '-    #        - Y/N - Does it accept a numeric operand OR / \
      '-    True     - Full Proper Name
                                                                  '
      '-    Cmnd        IX  B  #  True
      DATA "ADD     ",  01, N, Y, ADD                             ' ADD
      DATA "ADDD    ",  01, Y, N, ADD                             '
      DATA "A       ",  01, N, Y, ADD                             '
      DATA "AA      ",  01, Y, N, ADD                             '
      DATA "ALL     ",  02, N, N, ALL                             ' ALL
      DATA "BROWSE  ",  03, N, Y, BROWSE                          ' BROWSE
      DATA "BRO     ",  03, N, Y, BROWSE                          '
      DATA "B       ",  03, N, Y, BROWSE                          '
      DATA "BROWSEE ",  03, Y, N, BROWSE                          '
      DATA "BROO    ",  03, Y, N, BROWSE                          '
      DATA "BB      ",  03, Y, N, BROWSE                          '
      DATA "BACKUP  ",  04, N, Y, BACKUP                          ' BACKUP
      DATA "BACK    ",  04, N, Y, BACLUP                          '
      DATA "BK      ",  04, N, Y, BACKUP                          '
      DATA "BACKUPP ",  04, Y, N, BACKUP                          '
      DATA "BACKK   ",  04, Y, N, BACKUP                          '
      DATA "BKK     ",  04, Y, N, BACKUP                          '
      DATA "C       ",  29, N, Y, COPY                            ' C/CC
      DATA "CC      ",  29, Y, N, COPY                            '
      '-    Cmnd        IX  B  #  True
      DATA "CANCEL  ",  05, N, Y, CANCEL                          ' CANCEL
      DATA "CAN     ",  05, N, Y, CANCEL                          '
      DATA "CANCELL ",  05, Y, N, CANCEL                          '
      DATA "CANN    ",  05, Y, N, CANCEL                          '
      DATA "CLONE   ",  06, N, Y, CLONE                           ' CLONE
      DATA "CL      ",  06, N, Y, CLONE                           '
      DATA "CLONEE  ",  06, Y, N, CLONE                           '
      DATA "CLL     ",  06, Y, N, CLONE                           '
      DATA "DELETE  ",  07, N, Y, DELETE                          ' DELETE
      DATA "DEL     ",  07, N, Y, DELETE                          '
      DATA "D       ",  07, N, Y, DELETE                          '
      DATA "DELETEE ",  07, Y, N, DELETE                          '
      DATA "DELL    ",  07, Y, N, DELETE                          '
      DATA "DD      ",  07, Y, N, DELETE                          '
      DATA "DIR     ",  08, N, N, DIR                             ' DIR
      DATA "EDIT    ",  09, N, Y, EDIT                            ' EDIT
      DATA "E       ",  09, N, Y, EDIT                            '
      DATA "EDITT   ",  09, Y, N, EDIT                            '
      DATA "EE      ",  09, Y, N, EDIT                            '
      DATA "EFT     ",  10, N, Y, EFT                             ' EFT
      DATA "EFTT    ",  10, Y, N, EFT                             '
      DATA "END     ",  11, N, Y, END                             ' END
      '-    Cmnd        IX  B  #  True
      DATA "ENDD    ",  11, Y, N, END                             '
      DATA "X       ",  12, N, Y, EXCLUDE                         ' EXCLUDE
      DATA "XX      ",  12, Y, N, EXCLUDE                         '
      DATA "FORGET  ",  13, N, Y, FORGET                          ' FORGET
      DATA "F       ",  13, N, Y, FORGET                          '
      DATA "FF      ",  13, Y, N, FORGET                          '
      DATA "FPROP   ",  14, N, Y, FPROP                           ' FPROP
      DATA "FP      ",  14, N, Y, FPROP                           '
      DATA "FPROPP  ",  14, Y, N, FPROP                           '
      DATA "FPP     ",  14, Y, N, FPROP                           '
      DATA "I       ",  30, N, N, IEDIT                           ' IEDIT
      DATA "II      ",  30, Y, N, IEDIT                           '
      DATA "IEDIT   ",  30, N, N, IEDIT                           '
      DATA "IEDITT  ",  30, Y, N, IEDIT                           '
      DATA "IE      ",  30, N, N, IEDIT                           '
      DATA "IEE     ",  30, Y, N, IEDIT                           '
      DATA "LINES   ",  15, N, Y, LINES                           ' LINES
      DATA "LINE    ",  15, N, Y, LINES                           '
      DATA "L       ",  15, N, Y, LINES                           '
      DATA "LINESS  ",  15, Y, N, LINES                           '
      DATA "LINEE   ",  15, Y, N, LINES                           '
      DATA "LL      ",  15, Y, N, LINES                           '
      DATA "MEDIT   ",  16, N, Y, MEDIT                           ' MEDIT
      DATA "MEDITT  ",  16, Y, N, MEDIT                           '
      DATA "M       ",  16, N, Y, MEDIT                           '
      DATA "MM      ",  16, Y, N, MEDIT                           '
      DATA "ME      ",  16, N, Y, MEDIT                           '
      DATA "MEE     ",  16, Y, N, MEDIT                           '
      DATA "NORM    ",  17, N, Y, NORM                            ' NORM
      '-    Cmnd        IX  B  #  True
      DATA "N       ",  17, N, Y, NORM                            '
      DATA "NORMM   ",  17, Y, N, NORM                            '
      DATA "NN      ",  17, Y, N, NORM                            '
      DATA "OPEN    ",  18, N, Y, OPEN                            ' OPEN
      DATA "OPENV   ",  18, N, Y, OPEM                            '
      DATA "OPENB   ",  18, N, Y, OPEN                            '
      DATA "O       ",  18, N, Y, OPEN                            '
      DATA "OV      ",  18, N, Y, OPEN                            '
      DATA "OB      ",  18, N, Y, OPEN                            '
      DATA "OPENN   ",  18, Y, N, OPEN                            '
      DATA "OPENVV  ",  18, Y, N, OPEN                            '
      DATA "OPENBB  ",  18, Y, N, OPEN                            '
      DATA "OO      ",  18, Y, N, OPEN                            '
      DATA "OVV     ",  18, Y, N, OPEN                            '
      DATA "OBB     ",  18, Y, N, OPEN                            '
      DATA "PRINT   ",  19, N, Y, PRINT                           ' PRINT
      DATA "P       ",  19, N, Y, PRINT                           '
      DATA "PRINTT  ",  19, Y, N, PRINT                           '
      DATA "P       ",  19, Y, N, PRINT                           '
      DATA "RENAME  ",  20, N, Y, RENAME                          ' RENAME
      DATA "REN     ",  20, N, Y, RENAME                          '
      '-    Cmnd        IX  B  #  True
      DATA "R       ",  20, N, Y, RENAME                          '
      DATA "RENAMEE ",  20, Y, N, RENAME                          '
      DATA "RENN    ",  20, Y, N, RENAME                          '
      DATA "RR      ",  20, Y, N, RENAME                          '
      DATA "RESTORE ",  21, N, Y, RESTORE                         ' RESTORE
      DATA "RESTORET",  21, N, Y, RESTORET                        '
      DATA "RS      ",  21, N, Y, RESTORE                         '
      DATA "RST     ",  21, N, Y, RESTORET                        '
      DATA "RESTOREE",  21, Y, N, RESTORE                         '
      DATA "RSS     ",  21, Y, N, RESTORE                         '
      DATA "RSTT    ",  21, Y, N, RESTORET                        '
      DATA "SAVE    ",  22, N, Y, SAVE                            ' SAVE
      DATA "SAVEE   ",  22, Y, N, SAVE                            '
      DATA "SELECT  ",  23, N, Y, SELECT                          ' SELECT
      DATA "SEL     ",  23, N, Y, SELECT                          '
      DATA "S       ",  23, N, Y, SELECT                          '
      DATA "SELECTT ",  23, Y, N, SELECT                          '
      DATA "SELL    ",  23, Y, N, SELECT                          '
      DATA "SS      ",  23, Y, N, SELECT                          '
      DATA "SUBMIT  ",  24, N, Y, SUBMIT                          ' SUBMIT
      DATA "JOB     ",  24, N, Y, SUBMIT                          '
      DATA "J       ",  24, N, Y, SUBMIT                          '
      DATA "SUBMITT ",  24, Y, N, SUBMIT                          '
      DATA "JOBB    ",  24, Y, N, SUBMIT                          '
      DATA "JJ      ",  24, Y, N, SUBMIT                          '
      '-    Cmnd        IX  B  #  True
      DATA "TOUCH   ",  25, N, Y, TOUCH                           ' TOUCH
      DATA "T       ",  25, N, Y, TOUCH                           '
      DATA "TOUCHH  ",  25, Y, N, TOUCH                           '
      DATA "TT      ",  25, Y, N, TOUCH                           '
      DATA "VIEW    ",  26, N, Y, VIEW                            ' VIEW
      DATA "V       ",  26, N, Y, VIEW                            '
      DATA "VIEWW   ",  26, Y, N, VIEW                            '
      DATA "VV      ",  26, Y, N, VIEW                            '
      DATA "W       ",  27, N, Y, WOPEN                           ' WOPEN
      DATA "WW      ",  27, Y, N, WOPEN                           '
      DATA "WDIR    ",  28, N, Y, WDIR                            ' WDIR
      DATA "WDIRR   ",  28, Y, N, WDIR                            '
      DATA "DFA     ",  29, N, N, DFA                             '
      DATA "DFB     ",  29, N, N, DFB                             '
      '-    Cmnd        Ix  B  #  True

      FOR i = 1 TO FMLCmdNumber                                   ' Load the Table
         gFMLCmdTable(i).lcCmd   = READ$((i-1)*5 + 1)             '
         gFMLCmdTable(i).lcIX    = VAL(READ$((i-1)*5 + 2))        '
         gFMLCmdTable(i).lcBlock = READ$((i-1)*5 + 3)             '
         gFMLCmdTable(i).lcNumV  = READ$((i-1)*5 + 4)             '
         gFMLCmdTable(i).lcTrue  = READ$((i-1)*5 + 5)             '
         gFMLCmdTable(i).lcIX    = FMLCodeTable(gFMLCmdTable(i).lcIX)   ' Swap in a real code address instead of a number
      NEXT i                                                      '
      REDIM FMLCodeTable(1) AS INSTANCE DWORD                     ' Free the code table area
   END METHOD                                                     '

   INTERFACE iObjTabData: INHERIT IUNKNOWN                        ' Define the interface

      '--------------------------------------------------------------------------------------------+
      '- Setup links to embedded Objects                                                           |
      '--------------------------------------------------------------------------------------------+
      METHOD FCB_ AS iFCB                                         '
         METHOD = FCB                                             '
      END METHOD                                                  '
      METHOD Cmnt_ AS iCmnt                                       '
         METHOD = Cmnt                                            '
      END METHOD                                                  '
      METHOD PTBL_ AS iObjParse                                   '
         METHOD = PTBL                                            '
      END METHOD                                                  '

      '--------------------------------------------------------------------------------------------+
      '- Setup all the Properties and Methods for the tab related data                             |
      '--------------------------------------------------------------------------------------------+
      GSProp(BndText, STRING)                                     '
      GSProp(MarkLine, STRING)                                    '
      GSProp(MaskLine, STRING)                                    '
      GSProp(WordInput, STRING)                                   '
      GSProp(TabsLine, STRING)                                    '
      GProp(gFMDCtr, LONG)                                        '
      GSProp(AttnDo, LONG)                                        '
      GSProp(ActionCtr, LONG)                                     '
      GSProp(ActionStop, LONG)                                    '
      GSProp(cCurrent, INTEGER)                                   '
      GProp(ClipName, STRING)                                     '
      GProp(ClipFile, STRING)                                     '
      GSProp(ClrKWLoad, LONG)                                     '
      GSProp(CmdStackNum, LONG)                                   '
      GSProp(CsrLinDX, LONG)                                      '
      GSProp(CurrPcmd, STRING)                                    '
      GSProp(CursLine, STRING)                                    '
      GSProp(CursWord, STRING)                                    '
      GSProp(CursLNum, LONG)                                      '
      GSProp(CursCol, LONG)                                       '
      GSProp(CursColE, LONG)                                      '
      GSProp(EFTOVCtr, LONG)                                      '
      GSProp(EFTSkip, LONG)                                       '
      GSProp(EFTOVName, STRING)                                   '
      GSProp(ErrMsgTblC, LONG)                                    '
      GSProp(ErrMsgHigh, LONG)                                    '
      GSProp(ErrMsgTop, STRING)                                   '
      GSProp(ErrMsgLast, STRING)                                  '
      GSProp(FindWord, LONG)                                      '
      GSProp(FIXCtr, LONG)                                        '
      GSProp(Flag, LONG)                                          '
      GSProp(Flag2, LONG)                                         '
      GSProp(FMode, LONG)                                         '
      GSProp(Found1stLin, LONG)                                   '
      GSProp(Found1stLen, LONG)                                   '
      GSProp(Found1stCol, LONG)                                   '
      GSProp(FoundLstLin, LONG)                                   '
      GSProp(FoundLstLen, LONG)                                   '
      GSProp(FoundLstCol, LONG)                                   '
      GSProp(gHandle, DWORD)                                      '
      GSProp(KBTabFree, LONG)                                     '
      GSProp(hPCRE, DWORD)                                        '
      GSProp(LastLine, LONG)                                      '
      GSProp(HandleLast, LONG)                                    '
      GSProp(HandleMax, LONG)                                     '
      GSProp(HandleMin, LONG)                                     '
      GSProp(LastPTCurs, LONG)                                    '
      GSProp(LastReal, LONG)                                      '
      GSProp(LastRulCol, LONG)                                    '
      GSProp(LineFirst, LONG)                                     '
      GSProp(LineLast,  LONG)                                     '
      GSProp(LNKRealName, STRING)                                 '
      GSProp(LastRulRow, LONG)                                    '
      GSProp(LocLine1stR, LONG)                                   '
      GSProp(MacName, STRING)                                     '
      GSProp(MacWarn, LONG)                                       '
      GSProp(MaxLength, LONG)                                     '
      GSProp(MEditCount, LONG)                                    '
      GSProp(pCommand, STRING)                                    '
      GSProp(pCommandRaw, STRING)                                 '
      GSProp(pCommandPrv, STRING)                                 '
      GSProp(PgHandle, LONG)                                      '
      GSProp(PgNumber, LONG)                                      '
      GSProp(P, LONG)                                             '
      GSProp(PPActive, LONG)                                      '
      GSProp(HPanelSplit, LONG)                                   '
      GSProp(HPanelSize, LONG)                                   '
      GSProp(VPanelSplit, LONG)                                   '
      GSProp(VPanelSize, LONG)                                   '
      GSProp(Prof1, STRING)                                       '
      GSProp(Prof2, STRING)                                       '
      GSProp(Prof3, STRING)                                       '
      GSProp(Prof4, STRING)                                       '
      GSProp(Prof5, STRING)                                       '
      GSProp(Prof6, STRING)                                       '
      GSProp(EFT1,  STRING)                                       '
      GSProp(SlecECol, LONG)                                      '
      GSProp(SlecELin, LONG)                                      '
      GSProp(SlecSCol, LONG)                                      '
      GSProp(SlecSLin, LONG)                                      '
      GSProp(SpellClr, LONG)                                      '
      GSProp(SpellCol, LONG)                                      '
      GSProp(SpellEnd, LONG)                                      '
      GSProp(SpellLin, LONG)                                      '
      GSProp(sCol, LONG)                                          '
      GSProp(sDir, LONG)                                          '
      GSProp(sLine, LONG)                                         '
      GSProp(SwapSLin, LONG)                                      '
      GSProp(TopPcmd, STRING)                                     '
      GSProp(UBoundL, LONG)                                       '
      GSProp(UBoundT, LONG)                                       '
      GSProp(VisTop, LONG)                                        '
      GSProp(VisBot, LONG)                                        '
      GSProp(WatchFlag, STRING)                                   '
      GSProp(WindowID, LONG)                                      '
      GSProp(XFormActive, STRING)                                 '

      '--------------------------------------------------------------------------------------------+
      '- Setup all the FM Properties                                                               |
      '--------------------------------------------------------------------------------------------+

      GSProp(FileListNm, STRING)                                  ' Active recent file list name
      GSProp(FMask, STRING)                                       ' Default file mask
      GSProp(FPath, STRING)                                       ' Default directory path
      GSProp(DefSort, STRING)                                     ' Default FM sort
      GSProp(DefSortCol, LONG)                                    ' Default FM sort column
      GSProp(DefFirstCol, LONG)                                   ' First column after FNAME
      GSProp(DirSort, STRING)                                     ' Default FM directory positioning
      GSProp(LastTop, LONG)                                       ' TopScrn as at last display
      GSProp(LFileListNm, STRING)                                 ' Last FileList Name
      GSProp(LFMask, STRING)                                      ' Last File Mask
      GSProp(LFPath, STRING)                                      ' Last File Path
      GSProp(gFMNestCtr, LONG)                                    ' Nesting Depth
      GSProp(gFMNestTopScrn, LONG)                                ' Desired Topscreen when Nest is popped
      GSProp(OFrmFPath, STRING)                                   ' Tab opened from FM Path variables
      GSProp(OFrmFMask, STRING)                                   '
      GSProp(OFrmFileL, STRING)                                   '
      GSProp(ScrlAmtC, STRING)                                    ' Scroll Amount field (Char)
      GSProp(TabMode, LONG)                                       ' Tab mode

      GSProp(P1, PanelCtl)                                        ' Panel control areas
      GSProp(P2, PanelCtl)                                        '

      '--------------------------------------------------------------------------------------------------+
      '- The following provide Initial Get/Set Properties for the Active PANEL structure                 |
      '--------------------------------------------------------------------------------------------------+
      METHOD Init(FM AS LONG)                                     ' Init PANEL structure
         P = VARPTR(P1)                                           ' Point at default P1
         PPActive = P                                             ' Make it the active panel
         VPanelSplit = 0: HPanelSplit = 0                         ' Start as no split
         '-----------------------------------------------------------------------------------------------+
         '- Set the common values                                                                        |
         '-----------------------------------------------------------------------------------------------+
         @P.PTopLine = 1                                          ' Set Panel Topscreen Line
         @P.POffSet = 0                                           '  "    "   POffset
         @P.PCOffSet = 0                                          '  "    "   PCOffset
         @P.C.CRow = 1                                            '  "    "   PRow
         @P.C.CCol = 11                                           '  "    "   PCol

         IF FM THEN                                               ' If the FM tab
            @P.PTop = 1                                           '    Top Draw line
            @P.PBottom = gENV.ScrHeight                           '    End Draw Line
            @P.PLeft = 1                                          '    Left column
            @P.PRight = gENV.ScrWidth                             '    Right column
            @P.PGapCol = 1                                        '    Gap Column (unused)
            @P.PDataCol = 1                                       '    Data Column (unused)
            @P.PDLines = @P.PBottom - @P.PData1 + 1               '    # of lines
            @P.PCmdLen = gENV.ScrWidth - 24                       '    Panel Command Length
            @P.PData1 = 7                                         '    1st Data Line

         ELSE                                                     ' Else edit panel
            me.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, gENV.ScrWidth, "N", %True)
         END IF                                                   '
      END METHOD                                                  '

      METHOD GS(v AS LONG) AS LONG: METHOD = @P.PS(v):     END METHOD   ' Get current S(x) line
      METHOD SS(i AS LONG, v AS LONG): @P.PS(i) = v:       END METHOD   ' Set    "    S(x) line
      METHOD GPTopLine() AS LONG:  METHOD = @P.PTopLine:   END METHOD   ' Get    "    Panel TopScrn
      METHOD GP1TopLine() AS LONG:  METHOD = P1.PTopLine:  END METHOD   ' Get    "    Panel TopScrn
      METHOD GP2TopLine() AS LONG:  METHOD = P2.PTopLine:  END METHOD   ' Get    "    Panel TopScrn
      METHOD GP1Left() AS LONG:  METHOD = P1.PLeft:        END METHOD   ' Get    "    P1 Left
      METHOD GP2Left() AS LONG:  METHOD = P2.PLeft:        END METHOD   ' Get    "    P2Left
      METHOD SPTopLine(v AS LONG): @P.PTopLine = v:        END METHOD   ' Set    "      "   TopScrn
      METHOD GPTop() AS LONG:      METHOD = @P.PTop:       END METHOD   ' Get    "      "   Top Line
      METHOD SPTop(v AS LONG):     @P.PTop = v:            END METHOD   ' Set    "      "   Top Line
      METHOD SPLeft(v AS LONG):    @P.PLeft = v:           END METHOD   ' Set    "      "   Left
      METHOD GPLeft() AS LONG:     METHOD = @P.PLeft:      END METHOD   ' Get    "      "   Left
      METHOD GPRight() AS LONG:    METHOD = @P.PRight:     END METHOD   ' Get    "      "   Right
      METHOD SPRight(v AS LONG):   @P.PRight = v:          END METHOD   ' Set    "      "   Right
      METHOD SPCmdLen(v AS LONG):  @P.PCmdLen = v:         END METHOD   ' Set    "      "   CmdLen
      METHOD GPBottom() AS LONG:   METHOD = @P.PBottom:    END METHOD   ' Get    "      "   Bottom Line
      METHOD SPBottom(v AS LONG):  @P.PBottom = v:         END METHOD   ' Set    "      "   Bottom Line
      METHOD GPDataLen() AS LONG:  METHOD = @P.PDataLen:   END METHOD   ' Get    "      "   Data Line length
      METHOD SPDataLen(v AS LONG): @P.PDataLen = v:        END METHOD   ' Set    "      "   Data Line length
      METHOD GPPanelWidth() AS LONG:  METHOD = @P.PPanelWidth: END METHOD  ' Get    "      "   Panel width
      METHOD SPPanelWidth(v AS LONG): @P.PPanelWidth = v:      END METHOD  ' Set    "      "   Panel width
      METHOD GPPanelHeight() AS LONG:  METHOD = @P.PPanelHeight: END METHOD  ' Get    "      "   Panel height
      METHOD SPPanelHeight(v AS LONG): @P.PPanelHeight = v:      END METHOD  ' Set    "      "   Panel height
      METHOD GPLastWidth() AS LONG:  METHOD = @P.PLastWidth: END METHOD ' Get    "      "   Last Window width
      METHOD GPLastHeight() AS LONG:  METHOD = @P.PLastHeight: END METHOD ' Get    "      "   Last Window height
      METHOD GPPanelPct() AS LONG: METHOD = @P.PPanelPct:  END METHOD   ' Get    "      "   Panel % width
      METHOD SPPanelPct(v AS LONG):@P.PPanelPct = v:       END METHOD   ' Set    "      "   Panel % width
      METHOD GPDataCol() AS LONG:  METHOD = @P.PDataCol:   END METHOD   ' Get    "      "   Data left col
      METHOD GPData1() AS LONG:    METHOD = @P.PData1:     END METHOD   ' Get    "      "   1st data line
      METHOD SPData1(v AS LONG):   @P.PData1 = v:          END METHOD   ' Set    "      "   1st Data Line
      METHOD GPDLines() AS LONG:   METHOD = @P.PDLines:    END METHOD   ' Get    "      "   # Data Lines
      METHOD SPDLines(v AS LONG):  @P.PDLines = v:         END METHOD   ' Set    "      "   # Data Lines
      METHOD SPOffset(v AS LONG):  @P.POffset = v:         END METHOD   ' Set    "      "   Offset
      METHOD GPOffset() AS LONG:   METHOD = @P.POffset:    END METHOD   ' Get    "      "   Offset
      METHOD SPCOffset(v AS LONG): @P.PCOffset = v:        END METHOD   ' Set    "      "   Cmd Offset
      METHOD GPCOffset() AS LONG:  METHOD = @P.PCOffset:   END METHOD   ' Get    "      "   Cmd Offset
      METHOD GPScrData() AS LONG:  METHOD = @P.PScrData:   END METHOD   ' Get    "      "   Scroll Data column
      METHOD GPCmdCol() AS LONG:   METHOD = @P.PCmdCol:    END METHOD   ' Get    "      "   Command Data column
      METHOD GPGapCol() AS LONG:   METHOD = @P.PGapCol:    END METHOD   ' Get    "      "   Gap column
      METHOD SPGapCol(v AS LONG):  @P.PGapCol = v:         END METHOD   ' Set    "      "   Gap column
      METHOD SPMarkLine(v AS LONG):@P.PMarkLine = v:       END METHOD   ' Set    "      "   Edit MarkLine
      METHOD GPCType() AS LONG:    METHOD = @P.C.CType:    END METHOD   ' Get    "      "   C.CType
      METHOD GPCLCol() AS LONG:    METHOD = @P.C.CLCol:    END METHOD   ' Get    "      "   C.CLCol
      METHOD GPCIX() AS LONG:      METHOD = @P.C.CIX:      END METHOD   ' Get    "      "   C.CIX
      METHOD SPCCRow(v AS LONG):   @P.C.CRow = v:          END METHOD   ' Set    "      "   C.CRow
      METHOD SPCCCol(v AS LONG):   @P.C.CCol = v:          END METHOD   ' Set    "      "   C.CCol

      METHOD PPSetP1()                                            ' Swap to P1
         IF P <> VARPTR(P1) THEN                                  ' If this is a change from P2
            IF P1.PPanelPct < P2.PPanelPct AND gENV.PanelMax THEN ' And P1% < P2% then flip them
               IF HPanelSplit THEN                                ' If Horizontal split
                  HPanelSplit = (gENV.ScrHeight - gENV.PFKShow - 1) - HPanelSplit ' Recalc it
                  me.PanelSet(1, 1, me.HPanelSplit - 1, 1, gEnv.ScrWidth, "H", %True) ' Setup P1
                  me.PanelSet(2, HPanelSplit + 1, gENV.ScrHeight - gENV.PFKShow, 1, gEnv.ScrWidth, "H", %True) ' Setup P2
               ELSEIF VPanelSplit THEN                            ' If vertical split
                  VPanelSplit = (gENV.ScrWidth - 1) - VPanelSplit ' Recalc it
                  me.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, VPanelSplit - 1, "V", %True) ' Setup P1
                  me.PanelSet(2, 1, gENV.ScrHeight - gENV.PFKShow, VPanelSplit + 1, gEnv.ScrWidth, "V", %True) ' Setup P2
               END IF
            END IF                                                '
         END IF                                                   '
         P = VARPTR(P1): PPActive = P                             ' Setup P
         pCommand = ""                                            ' Clear command line
         me.WindowCmd                                             '
         me.PPSetScroll                                           ' Swap the scroll bar
         DoSet(%Refresh)                                          ' Have it looked at
         DoCursor                                                 ' Process it
         me.PostKeyboard                                          '
      END METHOD                                                  '

      METHOD PPSetP2()                                            ' Swap to P2
         IF P <> VARPTR(P2) THEN                                  ' If this is a change from P1
            IF P2.PPanelPct < P1.PPanelPct AND gENV.PanelMax THEN ' And P2% < P1% then flip them
               IF HPanelSplit THEN                                ' If Horizontal split
                  HPanelSplit = (gENV.ScrHeight - gENV.PFKShow - 1) - HPanelSplit  ' Recalc it
                  me.PanelSet(1, 1, HPanelSplit - 1, 1, gEnv.ScrWidth, "H", %True) ' Setup P1
                  me.PanelSet(2, HPanelSplit + 1, gENV.ScrHeight - gENV.PFKShow, 1, gEnv.ScrWidth, "H", %True) ' Setup P2
               ELSEIF VPanelSplit THEN                            ' If vertical split
                  VPanelSplit = (gENV.ScrWidth - 1) - VPanelSplit ' Recalc it
                  me.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, VPanelSplit - 1, "V", %True) ' Setup P1
                  me.PanelSet(2, 1, gENV.ScrHeight - gENV.PFKShow, VPanelSplit + 1, gEnv.ScrWidth, "V", %True) ' Setup P2
               END IF
            END IF                                                '
         END IF                                                   '
         P = VARPTR(P2): PPActive = P                             ' Setup P
         pCommand = ""                                            ' Clear command line
         me.WindowCmd                                             '
         me.PPSetScroll                                           ' Swap the scroll bar
         DoSet(%Refresh)                                          ' Have it looked at
         DoCursor                                                 ' Process it
         me.PostKeyboard                                          '
      END METHOD                                                  '

      METHOD PPSetScroll()                                        '
         IF gENV.VScrollBar THEN                                  ' Doing scrollbar?
            SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, @P.PBottom - @P.PTop   '
            SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, TP.LastLine + 3  '
            SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, @P.PTopLine  '
         END IF                                                   '
      END METHOD                                                  '

      METHOD EFTOVListG(i AS LONG) AS STRING: METHOD = EFTOVList(i): END METHOD  '
      METHOD EFTOVListS(i AS LONG, vl AS STRING): EFTOVList(i) = vl: END METHOD  '

      METHOD GetCmntStart(str AS STRING) AS LONG                  '
      '--------------------------------------------------------------------------------------------------+
      '- Process string and find start of a comment                                                      |
      '--------------------------------------------------------------------------------------------------+
      LOCAL i, j, ScanStart, CmntStart, QStart, QEnd, MaxCmnt AS LONG, qDLM, UStr AS STRING  '
         UStr = UCASE$(str)                                       '
         IF FCB.CmntID = 0 THEN EXIT METHOD                       ' If no ID then exit
         i = FCB.CmntID                                           ' Stuff in index
         IF ISFALSE Cmnt.GTxt1L(i) THEN EXIT METHOD               ' If no comment text ignore as well
         '-----------------------------------------------------------------------------------------------+
         '- Check for a comment                                                                          |
         '-----------------------------------------------------------------------------------------------+
         ScanStart = 1                                            ' Set start scan
         DO                                                       ' Scan
            CmntStart = INSTR(ScanStart, UStr, Cmnt.GTxt1(i))     ' Is it even in the line?
            IF CmntStart = 0 THEN EXIT METHOD                     ' No, we're done
            RESET QStart, QEnd                                    ' Reset Quotes
            IF ISNOTNULL(ClrQLeft) THEN                           ' Quotes active?
               QStart = INSTR(ScanStart, UStr, ANY ClrQLeft)      ' Look for a quote delimiter
               IF QStart THEN                                     ' Got quote
                  qDLM = MID$(UStr, QStart, 1)                    ' Save which quote we got
                  QEnd = INSTR(QStart + 1, Ustr, qDLM)            ' Look for closing
               END IF                                             ' Q & QQ mark quoted string
               IF QStart AND QEnd THEN                            ' If we found a quoted string
                  IF (CmntStart > QStart AND CmntStart < QEnd) _  ' Oops, comment inside quotes
                  OR QEnd < CmntStart THEN                        ' or Quoted string < comment string
                     ScanStart = QEnd + 1                         ' Step over close quote
                     ITERATE DO                                   ' Continue scan
                  ELSE                                            ' Else we have a winner
                     EXIT DO                                      ' CmntStart = Found
                  END IF                                          '
               ELSE                                               '
                  EXIT DO                                         ' CmntStart = found
               END IF                                             '
            ELSE                                                  '
              EXIT DO                                             ' CmntStart = found
            END IF                                                '
         LOOP                                                     '
         IF CmntStart = 0 THEN EXIT METHOD                        ' If nothing found, we're done
         IF VERIFY(Cmnt.GTxt2(i), "0123456789") > 0 THEN          ' If comment oper 2 alpha
            METHOD = CmntStart                                    ' Return comment start
            EXIT METHOD                                           '
         ELSE                                                     ' Else we have comment column
            j = VAL(Cmnt.GTxt2(i))                                ' Get value of oper 2
            IF j > 0 AND CmntStart <> j THEN EXIT METHOD          ' If fixed column, then not found, return 0
            METHOD = CmntStart                                    ' Return comment start
            EXIT METHOD                                           '
         END IF                                                   '
      END METHOD                                                  '

      METHOD GetTrkStack(i AS LONG) AS TrkStackT: METHOD = TrkStack(i): END METHOD  '
      METHOD GetDefActCol(i AS LONG) AS LONG: METHOD = DefActCol(i): END METHOD  '
      METHOD GetLFlag(i AS LONG) AS LONG: METHOD = L(i).LFlag: END METHOD  '
      METHOD GetLTxt(i AS LONG) AS STRING: METHOD = L(i).@LTxt: END METHOD '
      METHOD GetMedList(i AS LONG) AS STRING: METHOD = MEditList(i): END METHOD  '
      METHOD SetDefActCol(i AS LONG, v AS LONG): DefActCol(i) = v: END METHOD '
      METHOD GetScr(i AS LONG) AS STRING: METHOD = ScrImage(i): END METHOD   '

      METHOD GetWriteLine(ln AS LONG, recs AS LONG) AS STRING     '
      '--------------------------------------------------------------------------------------------+
      '- Preprocess a line to writable file format                                                 |
      '--------------------------------------------------------------------------------------------+
      LOCAL t AS STRING, i, j AS LONG, tw AS WSTRING, AttrB() AS INTEGER   '
         '-----------------------------------------------------------------------------------------+
         '- If AUTOCAPS, get the proper case'd version                                             |
         '-----------------------------------------------------------------------------------------+
         IF FCB.AutoCaps THEN                                     ' Do we need to do this?
            t = me.DoAutoCaps(ln)                                 ' Go do it
         ELSE                                                     '
            t = LTxtG(ln)                                         ' Else get the normal text
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- First do PRESERVE stuff                                                                |
         '-----------------------------------------------------------------------------------------+
         IF FCB.PreserveTyp = 0 THEN                              ' PRESERVE OFF?
            '--------------------------------------------------------------------------------------+
            '- Don't trim blanks that have Attributes                                              |
            '--------------------------------------------------------------------------------------+
            tw = LAttrG(ln)                                       ' Get the ATTR data
            IF LEN(tw) > 0 THEN                                   ' Something?
               DIM AttrB(1 TO LEN(tw)) AS INTEGER AT STRPTR(tw)   ' Overlay INT array over TW
               FOR i = LEN(tw) TO 1 STEP -1                       ' Find last char with a HILITE ATTR
                  IF (AttrB(i) AND %AttrHiLite) <> 0 THEN EXIT FOR   ' Exit if we found it
               NEXT i                                             '
               tw = LEFT$(tw, i)                                  ' Trim TW to that length
            END IF                                                '
            t = RTRIM$(t)                                         ' Temp trim
            IF LEN(tw) > LEN(t) THEN t = LSET$(t, LEN(tw))        ' Keep text as long as Attr
         ELSE                                                     '
            IF FCB.PreserveTyp = 1 THEN                           ' PRESERVE ON?
               '-                                                 ' Use the full line
            ELSE                                                  ' Must be PRESERVE C
               j = INSTR(-1, t, "\")                              ' Get location of last \ in the line
               IF j = 0 THEN                                      ' No \ character
                  '-                                              ' Then just like PRESERVE ON
               ELSE                                               ' We have a \
                  IF j = LEN(t) THEN                              ' Right at the end?
                     '-                                           ' Then just like PRESERVE ON
                  ELSE                                            ' Else we truncate it at the \
                     IF ISNULL(TRIM$(MID$(t, j+1))) THEN          ' Remaining all blank?
                        t = LEFT$(t, j)                           ' Then remove them
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If AUTOxx file, preserve FF page breaks                                                |
         '-----------------------------------------------------------------------------------------+
         IF LEFT$(FCB.EOL, 4) = "AUTO" THEN                       '
            IF IsLPage(ln) AND recs <> 0 THEN _                   ' =PAGE> line? (and not the first)
               t = $FF + t                                        ' Re-Insert the FF page break
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Lastly apply RECFM=F if needed                                                         |
         '-----------------------------------------------------------------------------------------+
         IF FCB.LRECL > 0 THEN                                    '
            t = LSET$(t, FCB.LRECL)                               '
         END IF                                                   '

         METHOD = t                                               '
      END METHOD                                                  '

      METHOD Change()                                             '
      '---------- Do the Change processing
      LOCAL i, j, k, l, m, q, qq, x, y, si, sj, sk, jj, GotColumns AS LONG, PosType AS INTEGER  '
      LOCAL lh, lh2, rh, lclChg, lclFound, lclChr, LastCase, t, lclPic, qDLM AS STRING '
      LOCAL cl, cl2, cr, CTxt AS WSTRING                          '
      LOCAL AttrAsc, tClr AS WORD                                 '

         MEntry                                                   '
         PosType = IIF(PTBL.FlgTop, %FChange, %Change)            ' Set positioning for TOP or not

         '-----------------------------------------------------------------------------------------+
         '- Get common variables into local data                                                   |
         '-----------------------------------------------------------------------------------------+
         i = PTBL.FoundLine                                       ' Line we're working on
         j = PTBL.FoundCol                                        ' Column where it was found
         k = PTBL.FoundLen                                        ' Length of found string
         l = LTxtGLen(i)                                          ' Length of text line

         '-----------------------------------------------------------------------------------------+
         '- Adjust k (Found length) if a picture type; for \ escapes and for { } boundary          |
         '-----------------------------------------------------------------------------------------+
         IF PTBL.FlgL1Picture THEN                                ' If doing a picture type search
            lclPic = PTBL.L1RData                                 ' Get a local copy
            IF LEFT$(lclPic, 1) = "{" THEN lclPic = MID$(lclPic, 2)  ' Remove the { and } if present
            IF RIGHT$(lclPic, 1) = "}" THEN lclPic = CLIP$(RIGHT, lclPic, 1)  '

            m = 1: k = 0                                          '
            t = LTxtG(i): RESET si, sj                            ' Get a local text copy
            DO WHILE m <= LEN(PTBL.L1RData)                       ' Get Pic true length
               IF MID$(PTBL.L1RData, m, 1) = "{" AND m = 1 THEN   ' A Left boundary spaces request
                  DECR k                                          ' Alow for the {
                  k += (VERIFY(t, " ") - 1 - (VERIFY(lclPic, " ") - 1)) ' Adjust k (found length
               END IF                                             '

               IF MID$(PTBL.L1RData, m, 1) = "}" AND m = LEN(PTBL.L1RData) THEN  ' A Right boundary spaces
                  DECR k                                          ' Allow for the }

                  IF RIGHT$(lclPic, 1) = " " THEN                 ' Trailing spaces in the picture?
                     FOR si = LEN(lclPic) TO 1 STEP -1            ' See how many
                        IF MID$(lclPic, si, 1) = " " THEN INCR sk ' Count trailing blanks
                        IF MID$(lclPic, si, 1) <> " " THEN EXIT FOR  ' Exit when a non-blank
                     NEXT si                                      '
                  END IF                                          ' sk has trailing picture spaces

                  FOR si = LEN(t) TO 1 STEP -1                    ' See how many
                     IF MID$(t, si, 1) = " " THEN INCR sj         ' Find last non-blank
                     IF MID$(t, si, 1) <> " " THEN EXIT FOR       '
                  NEXT si                                         ' sj has trailing text line blank count
                  k += sj - sk                                    ' Adjust k (found length
               END IF                                             '
               INCR k                                             '
               m = m + IIF(m < LEN(PTBL.L1RData) AND MID$(PTBL.L1RData, m, 1) = "\", 2, 1)   '
            LOOP                                                  '
         END IF                                                   '

         me.ModSet(i)                                             ' Remember we changed something
         me.LFlagBitOn(i, %EQChange)                              ' Mark the line number changed
         me.UpdLControl(i)                                        ' Update LLCtl

         '-----------------------------------------------------------------------------------------+
         '- Set color for any highlighting request                                                 |
         '-----------------------------------------------------------------------------------------+

         '-----------------------------------------------------------------------------------------+
         '- First see if any existing highlighting on the found string                             |
         '-----------------------------------------------------------------------------------------+
         AttrAsc = ASC(LAttrG(i), j)                              ' Get Attr of 1st change byte
         IF REPEAT$(k, CHR$$(AttrAsc)) <> MID$(LAttrG(i), j, k) THEN _  ' If not the same attr for whole string
            AttrAsc = AttrAsc AND (%AttrAll - %AttrHiLite)        ' Just make it normal text

         '-----------------------------------------------------------------------------------------+
         '- Override if specific Clr asked for                                                     |
         '-----------------------------------------------------------------------------------------+
         IF PTBL.HiLiteOn <> 0 THEN                               ' +color asked for?
            tClr = PTBL.HiLiteOn: SHIFT LEFT tClr, 12             ' Add it in
            AttrAsc = (AttrAsc AND (%AttrAll - %AttrHiLite)) OR tClr '
         END IF                                                   '
         IF PTBL.FlgPStd THEN AttrAsc = (AttrAsc AND (%AttrAll - %AttrHiLite))   ' Std? Remove color

         lh = LEFT$(LTxtG(i), j - 1)                              ' Get the LH portion of the text
         rh = MID$(LTxtG(i), j + k)                               ' Get the RH portion of the text
         cl = LEFT$(LAttrG(i), j - 1)                             ' Get the LH portion of the Attributes
         cr = MID$(LAttrG(i), j + k)                              ' Get the RH portion of the Attributes
         lclChg = PTBL.L2RData                                    ' Get local copy of change string

         '-----------------------------------------------------------------------------------------+
         '- At this point we have the LH/RH parts of the Text and Attribute lines                  |
         '-                           and the Scheme and color defaults for the change string      |
         '-----------------------------------------------------------------------------------------+
         '-----------------------------------------------------------------------------------------+
         '- Now let various options fiddle the change string                                       |
         '-----------------------------------------------------------------------------------------+

         '-----------------------------------------------------------------------------------------+
         '- Handle T' type changes                                                                 |
         '-----------------------------------------------------------------------------------------+
         IF PTBL.FlgL2CaseInComp THEN                             ' If replace is a T'string' type
            lclFound = MID$(LTxtG(i), j, k)                       ' Pickup found string
            IF LEN(lclChg) > 0 THEN                               ' If change string is not Null
               LastCase = "L"                                     ' Setup LastCase default
               FOR x = LEN(lclFound) TO 1 STEP -1                 ' Locate the last Alpha character
                  lclChr = MID$(lclFound, x, 1)                   ' Test char
                  IF INSTR(gUpper, lclChr) > 0 OR INSTR(gLower, lclChr) > 0 THEN ' We have an Alpha
                     LastCase = IIF$(INSTR(gUpper, lclChr) > 0, "U", "L")  ' Set a LastCase based on this char
                     EXIT FOR                                     ' We're done, LastCase is set
                  END IF                                          '
               NEXT x                                             '
               '-----------------------------------------------------------------------------------+
               '- LastCase now = the case of the last Alpha character in the found string          |
               '-----------------------------------------------------------------------------------+
               FOR x = 1 TO LEN(lclChg)                           ' Adjust case of the change string
                  IF x <= LEN(lclFound) THEN                      ' If Search string long enough
                     IF INSTR(gUpper, MID$(lclFound, x, 1)) > 0 THEN ' Found character UC?
                        MID$(lclChg, x, 1) = UUCASE(MID$(lclChg, x, 1)) ' Make change character UC
                     ELSEIF INSTR(gLower, MID$(lclFound, x, 1)) > 0 THEN   ' Found character LC?
                        MID$(lclChg, x, 1) = LLCASE(MID$(lclChg, x, 1)) ' Make change character LC
                     ELSE                                         ' Else blank, numeric etc.
                                                                  '                                         ' Do nothing
                     END IF                                       '
                  ELSE                                            ' We have characters past the found length
                     IF LastCase = "U" THEN MID$(lclChg, x, 1) = UUCASE(MID$(lclChg, x, 1))  '
                     IF LastCase = "L" THEN MID$(lclChg, x, 1) = LLCASE(MID$(lclChg, x, 1))  '
                  END IF                                          '
               NEXT x                                             '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- UC it all if CAPS ON                                                                   |
         '-----------------------------------------------------------------------------------------+
         ELSEIF (FCB.CapsDesired = 1 OR FCB.CapsActual = 1) THEN  ' CAPS ON?
            lclChg = UUCASE(lclChg)                               ' UC if CAPS is ON
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If this is a F' or P' type change                                                      |
         '-----------------------------------------------------------------------------------------+
         IF PTBL.FlgL2Format OR PTBL.FlgL2Picture THEN            ' If doing a format change
            lclChg = ""                                           ' Start result as null
            y = PTBL.FoundCol                                     ' Found data

            '--------------------------------------------------------------------------------------+
            '- Handle each of the special character requests                                       |
            '--------------------------------------------------------------------------------------+
            FOR x = 1 TO LEN(PTBL.L2RData)                        ' Loop doing the special change
               t = LTxtG(i)                                       ' Get a local text copy
               SELECT CASE AS CONST$ MID$(PTBL.L2RData, x, 1)     ' Do it based on the char inside P'xxx'
                  CASE "="                                        ' Copy the character
                     lclChg += MID$(t, y, 1)                      '
                     INCR y                                       '
                  CASE "<"                                        ' Lowercase it
                     lclChg += LLCASE(MID$(t, y, 1))              '
                     INCR y                                       '
                  CASE ">"                                        ' Uppercase it
                     lclChg += UUCASE(MID$(t, y, 1))              '
                     INCR y                                       '
                  CASE "!"                                        ' Entire found string
                     lclChg += MID$(t, j, k)                      '
                  CASE "", ""                                   ' Entire found string lowercased  "" is "" in OEM
                     lclChg += LLCASE(MID$(t, j, k))              '
                  CASE "", ""                                   ' Entire found string uppercase   "" is "" in OEM
                     lclChg += UUCASE(MID$(t, j, k))              '
                  CASE "~"                                        ' Ignore it
                     INCR y                                       '
                  CASE "\"                                        ' Escape?
                     lclChg += MID$(PTBL.L2RData, x + 1, 1)       ' Copy next char
                     INCR x                                       ' extra step
                     IF PTBL.FlgL2Picture THEN INCR y             ' If doing a picture
                  CASE "{"                                        ' Leading spaces
                     lclChg += SPACE$(VERIFY(t, " ") - 1)         '
                  CASE "}"                                        ' Trailing spaces
                     RESET si, sj                                 '
                     FOR si = LEN(t) TO 1 STEP -1                 ' See how many
                        IF MID$(t, si, 1) <> " " THEN sj = si: EXIT FOR ' Find last non-blank
                     NEXT si                                      '
                     IF sj > 0 THEN                               ' Found it
                        lclChg += SPACE$(LEN(t) - sj)             ' Add # spaces
                     END IF                                       '

                  '--------------------------------------------------------------------------------+
                  '- Not special character, just copy it                                           |
                  '--------------------------------------------------------------------------------+
                  CASE ELSE                                       ' Copy L12 character
                     lclChg += MID$(PTBL.L2RData, x, 1)           '
                     IF PTBL.FlgL2Picture THEN INCR y             ' If doing a picture
               END SELECT                                         '
            NEXT x                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- OK, everyone has fiddled lclChg their own way                                          |
         '-----------------------------------------------------------------------------------------+

         '-----------------------------------------------------------------------------------------+
         '- See if there are possible columns to try and retain                                    |
         '-----------------------------------------------------------------------------------------+
         GotColumns = %False                                      ' Reset flag
         IF IsColSupp THEN GOTO ColsTestDone                      ' Skip if somebody wants this suppressed
         IF PTBL.FlgCS  THEN GOTO ColsTestDone                    ' If specific CS operand
         IF FCB.ChangeMode = "C" AND ISFALSE PTBL.FlgDS THEN GOTO ColsTestDone   ' Default CS and not overriden?
         IF PTBL.FlgDS OR _                                       ' Specific DS request?
            (LEN(TRIM$(PTBL.L1RData)) <> 0 AND _                  ' Only do columns if search and replace was non-blank
             LEN(TRIM$(PTBL.L2RData)) <> 0) THEN                  '
            jj = J + k                                            ' Get start scan
            DO                                                    ' Loop looking for compressible spaces
               x = INSTR(jj, LTxtG(i), "  ")                      ' Look for at least 2 blanks following found string
               IF x = 0 THEN EXIT DO                              ' No blanks, skip all the junk
               q = INSTR(jj, LTxtG(i), ANY "'`" + $DQ)            ' Any quotes?
               qDLM = MID$(lTxtG(i), q, 1)                        ' Save which one
               qq = INSTR(q + 1, LTxtG(i), qDLM)                  ' Look for closing
               IF q = 0 OR (q <> 0 AND qq = 0) THEN EXIT DO       ' If no valid quoted string, skip out
               IF x < q THEN EXIT DO                              ' If spaces preceed quotes, skip out
               jj = qq + 1                                        ' Scan again after closing quote
            LOOP                                                  '
            IF x THEN                                             ' If we 've got spare blanks
               FOR y = x TO l                                     ' Look through remainder of line for a non- blank
                  IF MID$(LTxtG(i), y, 1) <> " " THEN             ' Got one?
                     GotColumns = %True                           ' Remember we have columns
                     EXIT FOR                                     ' Exit, y - 1 is split point for lh/rh
                 END IF                                           '
               NEXT y                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If there are columns do the change so we try and retain them                           |
         '-----------------------------------------------------------------------------------------+
         ColsTestDone:                                            '
         IF GotColumns AND ISFALSE PTBL.FlgL2Trunc THEN           ' We've columns and no TRUNC, do things the fancy way
            lh = LEFT$(LTxtG(i), y - 2)                           ' Create full lh portion
            rh = MID$(LTxtG(i), y - 1)                            ' Create full rh portion
            lh2 = RTRIM$(MID$(lh, j + k))                         ' Create rh part of the full lh portion
            lh = LEFT$(lh, j - 1)                                 ' Create lh part of the full lf portion
            lh = lh + lclChg + lh2                                ' Re-Build the full lh portion with the change
            IF LEN(lh) < y - 1 THEN                               ' If lh is less than orig length of lh portion
               lh = lh + STRING$((y - 2) - LEN(lh), " ")          ' make it back up to original length
            END IF                                                '
            me.LTxtSet(i, lh + rh)                                ' Re-build the altered line now

            '--------------------------------------------------------------------------------------+
            '- Ditto for the Attr line                                                             |
            '--------------------------------------------------------------------------------------+
            cl = LEFT$(LAttrG(i), y - 2)                          ' Create full lh portion
            cr = MID$(LAttrG(i), y - 1)                           ' Create full rh portion
            cl2 = RTRIM$(MID$(cl, j + k))                         ' Create rh part of the full lh portion
            cl = LEFT$(cl, j - 1)                                 ' Create lh part of the full lf portion
            cl = cl + REPEAT$(LEN(lclChg), CHR$$(AttrAsc)) + cl2  ' Re-Build the full lh portion with the change
            IF LEN(cl) < y - 1 THEN                               ' If lh is less than orig length of lh portion
               cl = cl + REPEAT$((y - 2) - LEN(cl), CHR$$(AttrAsc))  ' make it back up to original length
            END IF                                                '
            LAttrS(i) = cl + cr                                   ' Re-build the Attr line
            me.AttrScan(i)                                        ' Recolorize

         '-----------------------------------------------------------------------------------------+
         '- Just a simple non-column change                                                        |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     ' We've a plain simple change to do
            IF PTBL.FlgL2Trunc THEN                               ' TRUNC requested?
               me.LTxtSet(i, lh + lclChg)                         ' Re-build the line minus the rh portion
               CTxt = cl + REPEAT$(LEN(lclChg), CHR$$(AttrAsc))   ' Re-build the Attr line
            ELSE                                                  ' Else no TRUNC requested?
               me.LTxtSet(i, lh + lclChg + rh)                    ' Re-build the altered line
               CTxt = cl + REPEAT$(LEN(lclChg), CHR$$(AttrAsc)) + cr ' Re-build the Attr line
            END IF                                                '
            LAttrS(i) = Ctxt                                      ' Store the Attr line
            me.AttrScan(i)                                        ' Recolorize
         END IF                                                   '
         me.UCIfNeeded(i)                                         ' UC if CAPS ON

         '-----------------------------------------------------------------------------------------+
         '- Figure out if and what to HiLite                                                       |
         '-----------------------------------------------------------------------------------------+
         IF ISTRUE FCB.HiFind AND ISFALSE FCB.HiFindSupp THEN     ' See whether to hilite the string
            me.AttrInvSet(i, j, j + LEN(lclChg) - 1)              ' Set the Attr flags
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do cursor positioning                                                                  |
         '-----------------------------------------------------------------------------------------+
         IF ISTRUE FCB.HiFind AND ISFALSE FCB.HiFindSupp THEN     ' See whether to hilite the string
            IF IsLInvisible(i) THEN                               ' Still invisible (DX is active), else it'd be popped out
               me.CurSetReq(PosType, i, j + IIF(LEN(lclChg) = 0, 0, LEN(lclChg) - 1), %True, %True)   ' Put cursor on the X line
               CsrLinDX = VAL(LLNumG(i))                          ' Save hidden line number
            ELSE                                                  ' Not invisible
               IF sDir = 1 THEN                                   ' Forward?
                  me.CurSetReq(PosType, i, j + IIF(LEN(lclChg) = 0, 0, LEN(lclChg) - 1), %True) ' Set cursor set attempt
               ELSE                                               '
                  me.CurSetReq(PosType, i, j - 1, %True)          ' Set cursor set attempt
               END IF                                             '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- No Hi-Lite required                                                                    |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     ' Else no hilite
            IF sDir = 1 THEN                                      ' Forward?
               me.CurSetReq(PosType, i, j + IIF(LEN(lclChg) = 0, 0, LEN(lclChg) - 1), %True) ' Set cursor set attempt
            ELSE                                                  '
               me.CurSetReq(PosType, i, j - 1, %True)             ' Set cursor set attempt
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Set resume search parameters                                                           |
         '-----------------------------------------------------------------------------------------+
         IF sDir = 1 THEN                                         ' Forward search?
            sCol += IIF(LEN(lclChg) = -1, 0, LEN(lclChg) - 1)     ' Adjust continue search col
            IF PTBL.FlgLeft THEN sCol = LEN(L(i).@LTxt)           ' LEFT? Go to end of line
         ELSE                                                     '
            sCol = (j - 1) - LEN(L(sLine).@LTxt)                  ' No, calc new scan start
            IF PTBL.FlgLeft THEN                                  ' LEFT going backward?
               sLine -= 1                                         ' 'next' line
               sCol = -1                                          '
            END IF                                                '
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD CleanInsLines()                                      '
      '--------------------------------------------------------------------------------------------+
      '- Remove unused Insert Lines                                                                |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '

         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Skip if someone wants a one time pass on this                                          |
         '-----------------------------------------------------------------------------------------+
         IF IsInsClnSupp THEN OffInsClnSupp: MExitMeth            ' Suppress once

         '-----------------------------------------------------------------------------------------+
         '- Don't waste time if nobody asked for it at all                                         |
         '-----------------------------------------------------------------------------------------+
         IF InsCount = 0 OR LastLine < 3 THEN MExitMeth           ' Don't scan if not needed

         '-----------------------------------------------------------------------------------------+
         '- OK, grunt work to delete the unused '''''' lines                                       |
         '-----------------------------------------------------------------------------------------+
         ARRAY SORT InsTbl() FOR InsCount                         ' Sort into line number order
         FOR i = InsCount TO 1 STEP -1                            ' Loop through Insert table
            IF IsLInsertLine(InsTbl(i)) THEN                      ' An unused Insert Line?
               me.LTxtFree(InsTbl(i))                             ' Yes, Go free the dynamic string
               me.LEntDel(InsTbl(i))                              ' Remove from the L() array
               DECR LastLine: DECR LastReal                       ' Adjust Last Line
            END IF                                                '
         NEXT i                                                   '
         InsCount = 0                                             ' Say we have none
         MExit                                                    '
      END METHOD                                                  '

      METHOD CleanTabData()                                       '
      '--------------------------------------------------------------------------------------------+
      '- Clean up Edit tab data areas                                                              |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j AS LONG, fn AS STRING                            '

         IF IsMedit THEN                                          ' If a MEdit clear each filename
            FOR j = MEditCount TO 1 STEP -1                       ' Loop in reverse (Medit table shrinks as deleted)
               fn = me.MEditListGet(j)                            ' Get a filename
               me.UnWatchQueue(fn)                                ' Kill Watch and dequeue
               me.MeditTbl("D", fn)                               ' Remove from Medit table
            NEXT j                                                '

         ELSE                                                     ' Else the simple one
            me.UnWatchQueue("")                                   ' Kill the current file
         END IF                                                   '

         me.LInitTxtData()                                        ' Wipe everything out then

         IF UBOUND(Undo) > 0 THEN                                 ' If any UNDO table, get rid of it
            FOR i = 1 TO UBOUND(Undo())                           ' Delete temporary files
               TRY                                                '
                  IF ISNOTNULL(TRIM$(Undo(i).UFn)) THEN KILL TRIM$(Undo(i).UFn)  '
                  IF ISNOTNULL(TRIM$(Undo(i).TFn)) THEN KILL TRIM$(Undo(i).TFn)  '
                  IF ISNOTNULL(TRIM$(Undo(i).TWFn)) THEN KILL TRIM$(Undo(i).TWFn)   '
                  IF ISNOTNULL(TRIM$(Undo(i).IXFn)) THEN KILL TRIM$(Undo(i).IXFn)   '
               CATCH                                              '
               END TRY                                            '
            NEXT i                                                '
         END IF                                                   '

      END METHOD                                                  '

      METHOD ClrKWSrch (srch AS STRING, found AS DWORD) AS LONG   '
      '--------------------------------------------------------------------------------------------+
      '- Do Binary lookup of color keywords                                                        |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          ' Use registers everywhere possible
      REGISTER j AS LONG                                          '
      LOCAL ipos, k AS LONG                                       '

         METHOD = %SCTxtLo: found = VARPTR(srch)                  ' Default fail answer

         '-----------------------------------------------------------------------------------------+
         '- Build Index if KWs just loaded                                                         |
         '-----------------------------------------------------------------------------------------+
         IF ClrKWLoad THEN                                        ' Just loaded?
            ClrKWLoad = %False                                    ' Just do this once
            IF IsClrCase THEN                                     ' See how to sort it
               ARRAY SORT ClrKW() FOR ClrKWrdNum, TAGARRAY ClrKWAns()   '
            ELSE                                                  '
               ARRAY SORT ClrKW() FOR ClrKWrdNum, COLLATE UCASE, TAGARRAY ClrKWAns()   '
            END IF                                                '
            RESET ClrKWIX(): FOR i = 0 TO 255: ClrKWDlm(i) = %SCTxtLo: NEXT i ' Reset the Index and DLM tables
            FOR i = 1 TO ClrKWrdNum                               ' Build the index
               j = ASC(ClrKW(i))                                  ' Get length of this KW
               ClrKW(i) = MID$(ClrKW(i), 2)                       ' Strip off length byte
               IF j = 1 THEN ClrKWDlm(ASC(ClrKW(i))) = ClrKWAns(i): ITERATE FOR  ' Just a DLM? Save it's answer
               IF ClrKWIX(j).StartItem = 0 THEN ClrKWIX(j).StartItem = i   ' 1st item of this length?
               ClrKWIX(j).EndItem   = i                           ' And as the end
            NEXT i                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do the search                                                                          |
         '-----------------------------------------------------------------------------------------+
         j = LEN(srch)                                            ' Get length of this search word
         IF j = 1 THEN METHOD = ClrKWDlm(ASC(srch)): found = VARPTR(srch): EXIT METHOD '
         i = ClrKWIX(j).StartItem                                 ' Set starting range
         j = ClrKWIX(j).EndItem                                   ' Set ending range
         IF i = 0 THEN EXIT METHOD                                ' No range, exit
         IF IsClrCase THEN                                        ' Exact match version of search?
            DO                                                    ' Yes, do the search
               iPos  = (i + j) \ 2                                ' Calc the midpoint
               k = strcmp_(BYVAL STRPTR(ClrKW(iPos)), BYVAL STRPTR(srch))  ' Use strcmp to do the compare
               IF k = 0 THEN                                      ' If this happens to be the one
                  METHOD = ClrKWAns(iPos): found = VARPTR(ClrKW(iPos)): EXIT DO  ' We're all done
               ELSEIF K > 0 THEN                                  '
                  j = iPos - 1                                    '
               ELSE                                               '
                  i = iPos + 1                                    '
               END IF                                             '
            LOOP WHILE j >= i                                     ' And continue onward

         ELSE                                                     ' This is the "I don't care about CASE" search
            DO                                                    ' Start the search
               iPos  = (i + j) \ 2                                ' Calc the midpoint
               k = strcmpr(ClrKW(iPos), Srch)                     ' Use strcmpr to do the compare
               IF k = 0 THEN                                      ' If this happens to be the one
                  METHOD = ClrKWAns(iPos): found = VARPTR(ClrKW(iPos)): EXIT DO  ' We're all done
               ELSEIF k > 0 THEN                                  '
                  j = iPos - 1                                    '
               ELSE                                               '
                  i = iPos + 1                                    '
               END IF                                             '
            LOOP WHILE j >= i                                     ' And continue onward
         END IF                                                   '
      END METHOD                                                  '

      METHOD CmdStackParse (CmdString AS STRING)                  ' Break command string down and save it
      LOCAL tCmd, lcmd AS STRING, c, i, lastchr AS LONG           '
         MEntry                                                   '
         CmdStackNum = 0                                          ' Start with none stacked
         tCmd = TRIM$(cmdstring)                                  ' Working copy
         i = TALLY(tCmd, gENV.CmdChr)                             ' See how many Command delimiters
         IF i > UBOUND(CmdStack) THEN _                           ' Expand CmdStack if needed
            REDIM PRESERVE CmdStack(i + 2)                        ' Get room for our count plus some slack

         IF i = 0 THEN MExitMeth                                  ' If no stacking, we're done

         lastchr = 0: c = 0                                       '
         FOR i = 1 TO LEN(tCmd)                                   ' Process stacked commands
            IF MID$(tCmd, i, 1) = CHR$(34) THEN                   ' Skip quoted
               WHILE i <= LEN(tCmd)                               '
                  INCR i                                          '
                  IF MID$(tCmd, i, 1) = CHR$(34) THEN EXIT LOOP   '
               WEND                                               '
               INCR i                                             ' Look for trailing
            END IF                                                '
            IF MID$(tCmd, i, 1) = "'" THEN                        ' Skip quoted
               WHILE i <= LEN(tCmd)                               '
                  INCR i                                          '
                  IF MID$(tCmd, i, 1) = "'" THEN EXIT LOOP        '
               WEND                                               '
               INCR i                                             ' Look for trailing
            END IF                                                '
            IF MID$(tCmd, i, 1) = "`" THEN                        ' Skip ` quoted
               WHILE i <= LEN(tCmd)                               '
                  INCR i                                          '
                  IF MID$(tCmd, i, 1) = "`" THEN EXIT LOOP        '
               WEND                                               '
               INCR i                                             ' Look for trailing
            END IF                                                '

            IF MID$(tCmd, i, 1) = gENV.CmdChr THEN                ' Got a gENV.CmdChr
               lcmd = MID$(tCmd, lastchr + 1, i - lastchr - 1)    ' Extract command
               INCR c                                             '
               IF c = 1 THEN                                      ' 1st one?
                  pCommand = lcmd                                 ' Set it in pCommand
               ELSE                                               ' Else
                  CmdStack(c-2) = lcmd                            ' in the CmdStack array
                  INCR CmdStackNum                                ' Count it
               END IF                                             '
               lastchr = i                                        ' remember where last gENV.CmdChr was
            END IF                                                '
         NEXT i                                                   '
         IF i <> lastchr THEN                                     ' If we didn't end with a ;
            IF c > 0 THEN                                         ' If we're stacking, add another, else leave pCommand alone
               lcmd = MID$(tCmd, lastchr + 1)                     ' Extract last part
               CmdStack(CmdStackNum) = lcmd                       ' in the CmdStack array
               INCR CmdStackNum                                   ' Count it
            END IF                                                '
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD ClrLoad() AS LONG                                    '
      '--------------------------------------------------------------------------------------------+
      '- Load Colourize values for a named file extension                                          |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, k, x, FNum, LineNumber, lclScheme, parsectr, DupHdr AS LONG '
      LOCAL Txt1, lclext, t, DupErr AS STRING                     '
      DIM parsed(100) AS STRING                                   '

         MEntry                                                   '
         LET Cmnt = NOTHING                                       ' Reset Comment storage
         LET Cmnt = CLASS "cCmnt"                                 '
         IF ISFALSE FCB.HiAuto THEN MExitMeth                     ' Don't bother if no HiAuto

         '-----------------------------------------------------------------------------------------+
         '- First ensure we do the correct profile                                                 |
         '-----------------------------------------------------------------------------------------+
         lclext = IIF$(FCB.AutoName <> "$NONE$", FCB.AutoName, FCB.Profname)  ' Get name from AUTONAME
         GOSUB DoAClrFile                                         ' Go process an Attr file
         MExitMeth                                                '

      DoACLRFile:                                                 '
         '-----------------------------------------------------------------------------------------+
         '- Set up a bunch of dummy values                                                         |
         '-----------------------------------------------------------------------------------------+
         OffClrFlag                                               ' Colourize inactive
         OffClrCase                                               ' No MIXEDCASE
         ClrQuoted = 0                                            ' Setup dummy values
         ClrNumeric = 0                                           '
         ClrComList = ""                                          ' Null Scheme list
         ClrDLM = " "    :    ClrESC = ""     :   ClrKwrdNum = 0  '
         LoadErrsCtr = 0                                          ' Reset LoadErrsCtr

         '-----------------------------------------------------------------------------------------+
         '- If .AUTO file doesn't exist, just exit                                                 |
         '-----------------------------------------------------------------------------------------+
         IF ISFALSE ISFILE(gENV.HomeData + "AUTO\" + lclext + ".AUTO") THEN MExitMeth   ' See if Colorize file exists

         '-----------------------------------------------------------------------------------------+
         '- File present, process it                                                               |
         '-----------------------------------------------------------------------------------------+
         FNum = FREEFILE                                          ' Get a file number
         Call3(TryOpenInput(gENV.HomeData + "AUTO\" + lclext + ".AUTO", FNum), _  ' Try the open
               MErrExit(%eFail, "AUTO file: " + lclext + " doesn't exist"), _ ' Oops?  Bail out
               MErrExit(%eFail, "OPEN of AUTO file: " + lclext + " failed"), _   '
               Nul)                                               ' Continue
         DO WHILE ISFALSE EOF(FNum)                               ' Read the data
            LINE INPUT # FNum, Txt1                               ' Get a line
            INCR LineNumber                                       ' Incr linenumber for messages
            OnClrFlag                                             ' Somethings here
            IF LEN(TRIM$(Txt1)) > 0 AND LEFT$(Txt1, 1) <> ";" THEN   ' Process the statement

               '-----------------------------------------------------------------------------------+
               '- If line has data and not a comment line, parse it                                |
               '-----------------------------------------------------------------------------------+
               Txt1 = SHRINK$(Txt1)                               ' Compress blanks
               parsectr = PARSECOUNT(Txt1, " ")                   ' Get count of operands
               PARSE Txt1, parsed(), " "                          '

               '-----------------------------------------------------------------------------------+
               '- Handle each command type                                                         |
               '-----------------------------------------------------------------------------------+
               SELECT CASE AS CONST$ UUCASE(parsed(0))            ' Do different types

                  '--------------------------------------------------------------------------------+
                  '- NUMERIC command                                                               |
                  '--------------------------------------------------------------------------------+
                  CASE "NUMERIC"                                  ' NUMERIC, added, default set to 0
                     IF parsed(1) = "" THEN GOSUB KillClr         ' Enough params?
                     GOSUB ValidateScheme                         ' Make sure Scheme number is valid
                     ClrNumeric = lclScheme                       ' Save Scheme number

                  '--------------------------------------------------------------------------------+
                  '- EXCLUDE command                                                               |
                  '--------------------------------------------------------------------------------+
                  CASE "EXCLUDE"                                  ' EXCLUDE
                     IF parsed(2) = "" THEN GOSUB KillClr         ' Enough params?
                     j = 0                                        ' Reset found index
                     FOR i = 1 TO 9                               ' Look for an unused slot
                        IF Cmnt.GETxt(i) = "" THEN j = i: EXIT FOR   '
                     NEXT i                                       '
                     IF j = 0 THEN GOSUB KillClr                  ' All full?  Kill it
                     Cmnt.SETxt(j, UUCASE(parsed(2)))             ' Save the text
                     Cmnt.SEsCol(j, VAL(parsed(1)))               ' Column No

                  '--------------------------------------------------------------------------------+
                  '- INCLUDE command                                                               |
                  '--------------------------------------------------------------------------------+
                  CASE "INCLUDE"                                  ' INCLUDE
                     IF parsed(2) = "" THEN GOSUB KillClr         ' Enough params?
                     j = 0                                        ' Reset found index
                     FOR i = 1 TO 9                               ' Look for an unused slot
                        IF Cmnt.GITxt(i) = "" THEN j = i: EXIT FOR   '
                     NEXT i                                       '
                     IF j = 0 THEN GOSUB KillClr                  ' All full?  Kill it
                     Cmnt.SITxt(j, UUCASE(parsed(2)))             ' Save the text
                     Cmnt.SIsCol(j, VAL(parsed(1)))               ' Column No

                  '--------------------------------------------------------------------------------+
                  '- DELIMS command                                                                |
                  '--------------------------------------------------------------------------------+
                  CASE "DELIMS"                                   ' DELIMS
                     IF parsed(1) = "" THEN GOSUB KillClr         ' Enough params?
                     ClrDLM = parsed(1) + " "                     ' Dlm text + a blank

                  '--------------------------------------------------------------------------------+
                  '- ESCAPECHR command                                                             |
                  '--------------------------------------------------------------------------------+
                  CASE "ESCAPECHR"                                ' ESCAPECHR
                     IF parsed(1) = "" THEN GOSUB KillClr         ' Enough params?
                     ClrESC = parsed(1)                           ' ESC text

                  '--------------------------------------------------------------------------------+
                  '- MIXEDCASE command                                                             |
                  '--------------------------------------------------------------------------------+
                  CASE "MIXEDCASE"                                ' MIXEDCASE
                     IF parsed(1) = "" THEN GOSUB KillClr         ' Enough params?
                     IF IsEQ(parsed(1), "YES") THEN ONClrCase: EXIT SELECT ' Remember to honour case
                     IF IsEQ(parsed(1), "NO") THEN EXIT SELECT    ' False is the default

                  '--------------------------------------------------------------------------------+
                  '- WORD / AUTOCAPS / AUTOCASE command                                            |
                  '--------------------------------------------------------------------------------+
                  CASE "WORD", "AUTOCAPS", "AUTOCASE"             ' WORD, AUTOCAPS or AUTOCASE?
                     IF parsed(2) = "" THEN GOSUB KillClr         ' Enough params?
                     GOSUB ValidateScheme                         ' Make sure Scheme number is valid
                     IF UUCASE(parsed(0)) = "AUTOCAPS" THEN lclScheme += 100  ' Indicate UpperCase request
                     IF UUCASE(parsed(0)) = "AUTOCASE" THEN lclScheme += 200  ' Indicate AutoCase request
                     ClrKWrdNum += 1                              ' Count word
                     ClrKWLoad = %True                            ' Say we've loaded something
                     IF ClrKWrdNum > UBOUND(ClrKW) THEN           ' Expand tables if needed
                        REDIM PRESERVE ClrKW(1 TO ClrKWrdNum + 500) AS INSTANCE STRING '
                        REDIM PRESERVE ClrKWAns(1 TO ClrKWrdNum + 500) AS INSTANCE LONG   '
                     END IF                                       '

                     ClrKw(ClrKWrdNum) = CHR$(LEN(parsed(2))) + parsed(2)  ' Add it, prefix with length
                     ClrKwAns(ClrKWrdNum) = lclScheme             '

                  '--------------------------------------------------------------------------------+
                  '- QUOTED command                                                                |
                  '--------------------------------------------------------------------------------+
                  CASE "QUOTED"                                   ' Quoted strings
                     IF parsed(1) = "" THEN GOSUB KillClr         ' Enough params?
                     GOSUB ValidateScheme                         ' Make sure Scheme number is valid
                     ClrQuoted = lclScheme                        ' Scheme number
                     ClrQLeft  = $DQ                              ' Set Double quote as defaults
                     ClrQRight = $DQ                              '
                     IF parsectr > 2 THEN                         ' Optional operands?
                        RESET ClrQLeft, ClrQRight                 ' Reset DLMs
                        FOR x = 2 TO parsectr - 1                 ' Process them
                           IF LEN(parsed(x)) <> 2 THEN GOSUB KillClr '
                           ClrQLeft  += LEFT$(parsed(x), 1)       ' Save the DLMs
                           ClrQRight += RIGHT$(parsed(x), 1)      ' Save the DLMs
                        NEXT x                                    '
                     END IF                                       '

                  '--------------------------------------------------------------------------------+
                  '- Error for anything else if not COMMENTx                                       |
                  '--------------------------------------------------------------------------------+
                  CASE ELSE                                       ' Better be a COMMENTx then
                     '-----------------------------------------------------------------------------+
                     '- Try a COMMENT? command                                                     |
                     '-----------------------------------------------------------------------------+
                     IF LEFT$(UUCASE(parsed(0)), 7) <> "COMMENT" THEN GOSUB KillClr ' If not a COMMENTx statement
                     IF parsed(3) = "" THEN GOSUB KillClr         ' Enough params?
                     IF INSTR("123456789", MID$(parsed(0), 8, 1)) = 0 THEN GOSUB KillClr  ' Make sure 1-9
                     GOSUB ValidateScheme                         ' Make sure Scheme number is valid
                     i = VAL(MID$(parsed(0), 8, 1))               ' Extract the COMMENT number
                     ClrComList += FORMAT$(lclScheme, "00")       ' Add Scheme to list
                     Cmnt.SSch(i, lclScheme)                      ' Save Scheme
                     Cmnt.STxt1(i, UUCASE(parsed(2)))             ' Save Txt1 text
                     IF parsed(3) = "0" THEN                      ' A simple real zero?
                        Cmnt.STxt2(i, "")                         ' Txt2 gets nulled
                        Cmnt.SsCol(i, 0)                          ' Column No = zero
                     ELSEIF VERIFY(parsed(3), "0123456789") = 0 THEN ' Numeric (a column number)
                        Cmnt.STxt2(i, "")                         ' Txt2 gets nulled
                        Cmnt.SsCol(i, VAL(parsed(3)))             ' Column No = user's value
                     ELSE                                         ' Alpha, an ending string delimiter
                        Cmnt.STxt2(i, uucase(parsed(3)))          ' Txt2 gets the ending DLM
                        Cmnt.SsCol(i, 0)                          ' Column No = user's value
                     END IF                                       '
               END SELECT                                         '
            END IF                                                '
         LOOP                                                     '
         CLOSE # FNum                                             '
         '-----------------------------------------------------------------------------------------+
         '- Now look for duplicate KWDs                                                            |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO ClrKWrdNum                                  ' For each
            FOR j = i + 1 TO ClrKWrdNum                           ' Compare to the rest
               IF IsClrCase THEN                                  ' If MIXEDCASE
                  k = (ClrKW(i) = ClrKW(j))                       ' Do test the correct way
               ELSE                                               '
                  k = (UCASE$(ClrKW(i)) = UCASE$(ClrKW(j)))       '
               END IF                                             '
               IF k THEN                                          ' A match?
                  IF ISFALSE DupHdr THEN                          ' Have we put out a Header yet?
                     DupHdr = %True                               ' Just once
                     me.LoadErrsAdd("WARNING: Duplicate 'words' detected in the " + gENV.HomeData + "AUTO\" + lclext + ".AUTO" + " file.") '
                     DupErr = "        >"                         ' Init list line
                  END IF                                          '
                  DupErr += MID$(ClrKW(i), 2) + " "               ' Save it in line
                  IF LEN(DupErr) > 80 THEN                        ' Time to dump the line?
                     me.LoadErrsAdd(DupErr)                       ' Yes, go save it
                     DupErr = "        >"                         ' Init list line
                  END IF                                          '
               END IF                                             '
            NEXT j                                                '
         NEXT i                                                   '
         IF ISNOTNULL(TRIM$(DupErr)) THEN me.LoadErrsAdd(DupErr)  ' Save if some remaining
         RETURN                                                   '

      ValidateScheme:                                             '
         lclScheme = VAL(parsed(1))                               ' Get the scheme number
         IF lclScheme <> 0 AND (lclScheme < 1 OR lclScheme > 14) THEN GOSUB KillClr ' Invalid scheme number kill it
         IF lclScheme = 0 THEN                                    ' Maybe an Alias?
            lclScheme = gENV.GetSchNumber(parsed(1))              ' See if it is
            IF lclScheme = -1 THEN GOSUB KillClr                  ' Oops, kill it
         END IF                                                   '
         lclScheme += 1                                           ' Adjust scheme up past TxtLo and TxtHi
         RETURN                                                   '

      KillClr:                                                    '
         OffClrFlag                                               ' Turn off the flag
         DoMessageBox gENV.HomeData + "AUTO\" + lclext + ".AUTO" + $CRLF + "File contains an invalid statement at Line: " + FORMAT$(LineNumber) + $CRLF + _  '
                      "|K" + Txt1 + $CRLF + "|BAuto Colorize has been turned off", %MB_OK OR %MB_USERICON, "SPFLite" '
         CLOSE # FNum                                             ' Close the file
         MExitMeth                                                '
         RETURN                                                   '
      END METHOD                                                  '

      METHOD CmdAssign()                                          '
      '--------------------------------------------------------------------------------------------+
      '- Process the pCommand line                                                                 |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, BuiltIn AS LONG, s, t, u, v, P1, P2, lclCmd, lcmd, ncmd, cmd, st AS STRING, RCA AS RCArea '
      LOCAL CallAddr AS DWORD                                     '
         MEntry                                                   '
         PTBL = PTBLLine                                          ' Start parsing with the Line version
         IF ISNULL(TRIM$(pCommand)) THEN MExitMeth                ' Nothing? Just exit

         '-----------------------------------------------------------------------------------------+
         '- Handle any alias commands, from 3 words down to one word                               |
         '-----------------------------------------------------------------------------------------+
         s = pCommand                                             ' Get working copy of command line
         t = GetNextWord(s, %Strip)                               ' Get the basic command name
         u = GetNextWord(s, %Strip)                               '
         v = GetNextWord(s, %Strip)                               '
         IF ISNOTNULL(t) AND ISNOTNULL(u) AND ISNOTNULL(v) THEN   ' Got three words?
            st = "ALIAS." + t + "." + u + "." + v                 ' Build the SET key
            SETTableUpd("GET", st, RCA)                           ' See if an alias SET symbol
            IF RCA.RC = 0 THEN                                    ' Found?
               pCommand = RCA.Msg + " " + s                       ' Re-build command string
               GOTO SetCont                                       '
            END IF                                                '
         END IF                                                   '

         IF ISNOTNULL(t) AND ISNOTNULL(u) THEN                    ' Got two words?
            st = "ALIAS." + t + "." + u                           ' Build the SET key
            SETTableUpd("GET", st, RCA)                           ' See if an alias SET symbol
            IF RCA.RC = 0 THEN                                    ' Found?
               pCommand = RCA.Msg + " " + v + " " + s             ' No, normal re-build of command string
               GOTO SetCont                                       '
            END IF                                                '
         END IF                                                   '

         IF ISNOTNULL(t) THEN                                     ' Got one word?
            st = "ALIAS." + t                                     ' Build the SET key
            SETTableUpd("GET", st, RCA)                           ' See if an alias SET symbol
            IF RCA.RC = 0 THEN                                    ' Found?
              IF INSTR(RCA.Msg, "=") = 0 THEN                     ' Does ALIAS have substitutions?
                 pCommand = RCA.Msg + " " + u + " " + v + " " + s ' No, normal re-build of command string
               ELSE                                               '
                  t = RCA.Msg                                     ' Get substitution string
                  SubstSetEQ(pCommand, t)                         ' Go do it
                  pCommand = t                                    ' Swap it in
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         SetCont:                                                 '
         '-----------------------------------------------------------------------------------------+
         '- Now process the command                                                                |
         '-----------------------------------------------------------------------------------------+
         TrkAfter = %False                                        ' Reset flag
         PrevPCmd = CurrPcmd                                      ' Push back commands
         CurrPcmd = UUCASE(GetNextWord(pCommand, %NoStrip))       ' Get the basic command name
         IF CurrPCmd = "BUILTIN" THEN                             ' A BUILTIN request?
            CurrPcmd = UUCASE(GetNextWord(pCommand, %Strip))      ' Skip to the Next word
            BuiltIn = %True                                       ' Remember BUILTIN
            CurrPcmd = UUCASE(GetNextWord(pCommand, %NoStrip))    ' Re-do the prefetch
         END IF                                                   '

         '-----------------------------------------------------------------------------------------------+
         '- Do the @ and # substitution here                                                             |
         '-----------------------------------------------------------------------------------------------+
         ncmd = "": lcmd = pCommand                               ' Start with null
         DO WHILE ISNOTNULL(TRIM$(lcmd))                          ' Process it
            cmd = GetNextWord(lcmd, %Strip)                       ' Get an Operand
            IF cmd = "@" THEN                                     ' The magic @
               IF SlecSCol <> 0 THEN                              ' And we have a value
                  ncmd += FORMAT$(SlecSCol) + " " + FORMAT$(SlecECol) + " "   ' Add the column numbers
               END IF                                             '
            ELSEIF cmd = "#" THEN                                 ' The other guy - #
               IF SlecSLin <> 0 THEN                              ' And we have a value
                  ncmd += "." + FORMAT$(SlecSLin) + " ." + FORMAT$(SlecELin) + " "  ' Add the column numbers
               END IF                                             '
            ELSE                                                  ' Neither, pass it through
               ncmd += cmd + " "                                  ' Add it
            END IF                                                '
         LOOP                                                     '
         pCommand = ncmd                                          ' Swap it in

         '-----------------------------------------------------------------------------------------+
         '- Look up command in Cmd Table                                                           |
         '-----------------------------------------------------------------------------------------+
         TopPCmd = CurrPCmd                                       ' Save top level command name
         i = gPCmdT.GetCmdIX(CurrPcmd)                            ' Get the command table index?

         IF ISFALSE gMacroMode AND IsMacro(CurrPCmd) AND ISFALSE Builtin THEN ' If not already in a macro, do macros first
            IF IsFMTab THEN gFMMacMode = 0                        ' Flag as a Primary command Macro
            MacName = CurrPCmd                                    ' Save name
            SETTableUpd("GET", "TRACK." + CurrPcmd, RCA)          ' See if user wants Tracking
            IF RCA.RC = 0 AND UCASE$(LEFT$(RCA.Msg, 1)) = "Y" THEN   ' Yes?
               me.TrkAdd(@P.PTopLine, me.CsrRow, me.CsrCol)       ' Create one?
               TrkAfter = %True                                   ' Say an After Track needed
            END IF                                                '
            CmdLog("P", pCommand, %True): t = pCommand            ' Cmd Log it starting
            me.pCmdMacro(pCommand)                                ' Go do it
            CmdLog("P", t, %False)                                ' Cmd Log it ending
            MExitMeth                                             ' And we're done
         END IF                                                   '

         IF i THEN                                                ' We found it
            TraceTblAdd("P=" + PCommand)                          ' Trace command
            gCrashLastPCmd = PCommand                             ' Last Primary command
            IF gMacroMode THEN                                    ' In macro mode?
               IF ISFALSE gPCmdT.IsMacOK(i) THEN                  ' If not allowable in macro mode
                  IF INSTR(pCommand + " ", " ? ") = 0 THEN        ' If not a CMD ? query
                     TP.ErrMsgAdd(%eFail, CurrPcmd + " command not supported in Macro mode") ' Set error message
                     MExitmeth                                    ' and leave
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            IF IsFMTab THEN                                       ' If this is the FM tab
               IF ISFALSE gPCmdT.IsFMAllowed(i) THEN              ' If not allowable in FM Mode
                  MErrExit(%eFail, "Command not supported in FM tab")   ' Set error message
               ELSE                                               '
                  CallAddr = gPCmdT.GetFMCode(i)                  ' Get Routine address
                  CmdLog("P", pCommand, %True)                    ' Cmd Log it starting
                  CALL DWORD CallAddr USING pCmdModel(pCommand)   ' Call the routine
                  CmdLog("P", pCommand, %False)                   ' Cmd Log it ending
               END IF                                             '

            ELSE                                                  ' Not FM mode
               IF ISFALSE gPCmdT.IsEditAllowed(i) THEN            ' If not allowable in Edit Mode
                  MErrExit(%eFail, "Command only supported in FM tab")  ' Set error message
               ELSE                                               '
                  IF IsBrowse THEN                                ' If Browse, see if allowable
                     IF ISFALSE gPCmdT.IsBrowseOK(i) THEN _       ' If not allowable in BROWSE mode
                        MErrExit(%eFail, "Command not allowed in Browse mode")   ' Set error message
                  END IF                                          '

                  IF ErrMsgHigh > %eRetrieve THEN                 ' Probable pending?
                     IF gPCmdT.IsScrollOK(i) THEN                 ' If scrolling type command?
                        me.MarkKill                               ' Do command anyway
                        sCurPrio = 0                              ' Allow cursor requests for the new command
                        SETTableUpd("GET", "TRACK." + CurrPcmd, RCA) ' See if user wants Tracking
                        u = IIF$(RCA.RC <> 0, " ", UCASE$(LEFT$(RCA.Msg, 1))) '
                        IF (gPCmdT.IsTrackOK(i) AND u <> "N") OR _   ' If in table, and not negated
                           u = "Y" THEN                           ' Or forced OK in the SET Table
                           me.TrkAdd(@P.PTopLine, me.CsrRow, me.CsrCol) ' Create the Track Point
                           TrkAfter = %True                       ' Say an After Track needed
                        END IF                                    '
                        CmdLog("P", PCommand, %True)              ' Log it
                        CallAddr = gPCmdT.GetEditCode(i)          ' Get Routine address
                        CALL DWORD CallAddr USING pCmdModel(pCommand)   ' Call the routine
                        CmdLog("P", PCommand, %False)             '
                     END IF                                       '
                  ELSE                                            '
                     me.MarkKill                                  ' Kill any active block select
                     sCurPrio = 0                                 ' Allow cursor requests for the new command
                     SETTableUpd("GET", "TRACK." + CurrPcmd, RCA) ' See if user wants Tracking
                     u = IIF$(RCA.RC > 0, " ", UCASE$(LEFT$(RCA.Msg, 1)))  '
                     IF (gPCmdT.IsTrackOK(i) AND u <> "N") OR _   ' If in table, and not negated
                        u = "Y" THEN                              ' Or forced OK in the SET Table
                        me.TrkAdd(@P.PTopLine, me.CsrRow, me.CsrCol) ' Track Point wanted?
                        TrkAfter = %True                          ' Say an After Track needed
                     END IF                                       '
                     CmdLog("P", pCommand, %True)                 ' Log it
                     CallAddr = gPCmdT.GetEditCode(i)             ' Get Routine address
                     CALL DWORD CallAddr USING pCmdModel(pCommand)   ' Call the routine
                     CmdLog("P", pCommand, %False)                '
                  END IF                                          '
               END IF                                             '
            END IF                                                '

         ELSE                                                     '
            TP.ErrMsgAdd(%eFail, "Unknown command: " + CurrPcmd)  ' Set error message
            MExitMeth                                             ' and leave
         END IF                                                   '

         MExit                                                    '
      END METHOD                                                  '

      METHOD CmdAddStack() AS INTEGER                             '
      '--------------------------------------------------------------------------------------------+
      '- Break apart pCommand to multiple commands                                                 |
      '--------------------------------------------------------------------------------------------+
      LOCAL tCmd, tCmd2, tCMDF AS STRING                          '
         METHOD = %False                                          ' Indicate it's not a RESET command pending
         IF SubstSet(pCommand) THEN EXIT METHOD                   ' Do SET substitution, exit if failure

         tCmd = TRIM$(IIF$(IsPFKInsert, pCommandRaw, pCommand))   ' Set which command to use for Retrieve
         tCmd2 = UCASE$(GetNextWord(pCommand, %NoStrip))          ' Get Command name
         IF ISFALSE(IsPFKInsert) OR tCMD2 = "RFIND" OR tCmd2 = "RLOCFIND" THEN gRtr.Add(tCmd)   ' Let Rtr store it
         tCmd = GetNextWord(pCommand, %NoStrip)                   ' Get Command name
         me.CmdStackParse(pCommand)                               ' Go parse out to the command stack / pCommand
         pCommandRaw = ""                                         ' Null the raw command
         tCmdF = UCASE$(LSET$(tCmd, 6))                           ' Make a 6 char version
         IF INSTR("UNDO  RESET RES   CAN   CANCELRELOADEND   HELP  ", tCmdF) <> 0 THEN METHOD = %True ' Say we got a RESET or CANCEL command?
      END METHOD                                                  '

      METHOD CmdStackAdd(t AS STRING)                             '
         CmdStack(CmdStackNum) = t                                ' Jam in the text
         INCR CmdStackNum                                         ' Count it
         IF CmdStackNum > UBOUND(CmdStack()) THEN _               ' Keep table big enough
            REDIM PRESERVE CmdStack(2 * CmdStackNum) AS INSTANCE STRING '
      END METHOD                                                  '

      METHOD CmdStackNext () AS STRING                            ' Fetch next stacked command
         IF CmdStackNum < 1 THEN                                  ' If none (just in case)
            METHOD  = ""                                          ' Stuff blanks
            CmdStackNum = 0                                       '
            EXIT METHOD                                           ' And exit
         END IF                                                   '
         METHOD = CmdStack(0)                                     ' Pass back top of stack
         ARRAY DELETE CmdStack(0)                                 ' Remove from the stack
         DECR CmdStackNum                                         ' Reduce remaining count
      END METHOD                                                  '

      METHOD CopyAFile(lin AS LONG, lclPM AS LONG, frmlin AS LONG, tolin AS LONG, quick AS LONG,  OPTIONAL CBLines AS STRING) '
      '--------------------------------------------------------------------------------------------+
      '- Read file and insert after passed line pointer                                            |
      '--------------------------------------------------------------------------------------------+
      LOCAL ln, i, j, k, CP, fnum, lclLower, lclUpper, lclNull, lctr, UTFError AS LONG '
      LOCAL IsCopy, StateFrom, StateTo, PCtr AS LONG              '
      LOCAL lclSource, chunk, DLM, t, tt, lclXFormMac, RDW AS STRING '
      LOCAL bytesinfile AS QUAD                                   '
      LOCAL OneTime, PageFlag, LastPage AS INTEGER                '
      LOCAL lTxtP AS STRING POINTER                               '
      LOCAL C1, C2 AS BYTE POINTER                                '
      LOCAL tmpEOL, prfEOL AS STRING                              '
      DIM TData(1 TO 500000) AS TDataEnt                          ' LoadData Array
      LOCAL TD AS TDataEnt                                        ' Working entry
      LOCAL TDCount AS LONG                                       ' Count in TD array
         MEntry                                                   '
         ln = lin                                                 '

         '-----------------------------------------------------------------------------------------+
         '- Check for XFORM request                                                                |
         '-----------------------------------------------------------------------------------------+
         XFormActive = ""                                         ' Start by saying no XFORM is active
         IF CurrPCmd <> "EDIT" AND CurrPCmd <> "BROWSE" AND CurrPCmd <> "FILEWATCH" AND _ '
            CurrPCmd <> "VIEW" AND CurrPCmd <> "RELOAD" AND CurrPCmd <> "FF" THEN GOTO NoXMacro ' Only primary edit commands
         IF ISNULL(FCB.XFormStr) THEN GOTO NoXMacro               ' Skip if no macro
         lclXFormMac = FCB.XFormStr                               ' Pick up normal macname
         IF uucase(lclXFormMac) <> lclXFormMac THEN GOTO NoXMacro ' If lowercase, then treat as OFF
         IF ISFALSE IsMacro(lclXFormMac) THEN                     '
            j = DoMessageBox("File: |K" & TRIM$(FCB.FilePath) + "|B specifies |KXFORM=" + uucase(lclXFormMac) + "|B but" + $CRLF + _   '
                             "the XFORM macro does not exist. Performing a normal OPEN", %MB_OK + %MB_USERICON, _ '
                             "SPFLite FileLoad")                  '
            GOTO NoXMacro                                         '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Let the XFORM macro perform the file reading                                           |
         '-----------------------------------------------------------------------------------------+
         IF CurrPcmd <> "COPY" AND ISFALSE quick THEN             ' If not the COPY command and not quick
            me.ClrLoad                                            ' Go load Colorize data
         END IF                                                   '

         lctr = lin                                               ' Save start in lctr
         XFormActive = lclXFormMac                                ' Remember what XFORM is being used
         me.pCmdMacro(lclXFormMac + " READ " + $DQ + FCB.Filepath + $DQ)   ' Go do it
         IF gMacroRC > 0 THEN                                     ' Check the RC
            j = DoMessageBox("XFORM Macro: |K" + uucase(lclXFormMac) + "|B reported an error." + $CRLF + _  '
                             "Check carefully - File data status is indeterminate.", %MB_OK + %MB_USERICON, _  '
                             "SPFLite FileLoad")                  '
         END IF                                                   '
         GOTO VCloseDone                                          '

         NoXMacro:                                                '

         '-----------------------------------------------------------------------------------------+
         '- Open the file                                                                          |
         '-----------------------------------------------------------------------------------------+
         Call4(GetNonTextOption(FCB.FilePath, t), _               ' Get result for NON-TEXT
               GOTO InsertData, GOTO InsertData, GOTO InsertData, _  ' 1/2/3 all Insert data
               Nul)                                               ' Continue
         TRY                                                      ' Just in case
            OPEN FCB.FilePath FOR BINARY ACCESS READ LOCK SHARED AS # FCB.FNum   ' Open the File
         CATCH                                                    '
            TP.ErrMsgAdd(%eFail, "File OPEN failed")              ' Setup Err Msg
            MExitMeth                                             ' Say to exit
         END TRY                                                  '
         '-----------------------------------------------------------------------------------------+
         '- If a full OPEN (not a COPY) extract and setup some file data                           |
         '-----------------------------------------------------------------------------------------+
         IF CurrPcmd <> "COPY"  AND CurrPCmd <> "MEDIT" THEN      ' If not the COPY/MEDIT command
            CHDIR FCB.Path                                        ' Make this the 'current' directory
            IF ISFALSE gMacroMode THEN me.WindowTitle             ' Alter window title
         END IF                                                   '

         IF CurrPcmd <> "COPY" AND _                              ' If not the COPY command
            ISFALSE quick THEN                                    ' Not quick mode
            IF ISFALSE IsMEdit OR _                               '
            (IsMedit AND MEditCount < 2) THEN _                   ' Not MEdit
               me.ClrLoad                                         ' Go load Colorize data
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Init for the deblocking loop                                                           |
         '-----------------------------------------------------------------------------------------+
         lclSource = FCB.SourceName                               ' Default to Profile's SOURCE value
         bytesinfile = LOF(FCB.FNum)                              ' Get # bytes in file
         IF bytesinfile > 3000000 THEN gLoopCtr = - 1             ' Prevent loop detection for big files
         StateFrom = Lin + 1                                      ' Copy requested insertion point, remember for STATE
         GOSUB SetEOL: tmpEOL = prfEOL                            ' Set tmpEOL and DLM

         GET$ # FCB.FNum, bytesinfile, Chunk                      ' Read the entire file

         IF LEFT$(tmpEOL, 4) = "AUTO" THEN PageFlag = %True       ' Force a =PAGE> at the top for AUTO files

         CP = 1                                                   ' Start deblocking at position 1

         '-----------------------------------------------------------------------------------------+
         '- Process the file now                                                                   |
         '-----------------------------------------------------------------------------------------+
         DO UNTIL CP > bytesinfile                                ' Loop through file
            IF gfInterrupt THEN EXIT DO                           ' Break during FF search

            '--------------------------------------------------------------------------------------+
            '- If the 1st block, do a bunch of extra stuff                                         |
            '--------------------------------------------------------------------------------------+
            IF OneTime = 0 THEN                                   ' 1st data block?
               OneTime = 1                                        ' Flip it

               IF ISFALSE FCB.RECFM = "V" AND ISFALSE LEFT$(prfEOL, 4) = "AUTO" THEN   ' Skip next if RECFM=V or EOL=AUTO
                  IF MID$(Chunk, CP, 4) = $UTF32BE OR _           ' See if a Unicode file UTF32BE
                     MID$(Chunk, CP, 4) = $UTF32LE THEN           ' See if a Unicode file UTF32LE
                     TP.ErrMsgAdd(%eFail, "Unsupported Unicode file")   ' Tell user we don't do this one
                     CP += 4                                      ' Strip off the leader
                     lclSource = "ANSI"                           ' Default to ANSI
                  ELSEIF MID$(Chunk, CP, 3) = $UTF8 THEN          ' UTF8?
                     lclSource = "UTF8"                           ' Set it
                     CP += 3                                      ' Step over the BOM
                  ELSEIF MID$(Chunk, CP, 2) = $UTF16LE THEN       ' UTF16LE?
                     lclSource = "UTF16"                          ' Set it
                     CP += 2                                      ' Step over the BOM
                  ELSEIF MID$(Chunk, CP, 2) = $UTF16BE THEN       ' UTF16BE?
                     lclSource = "UTF16BE"                        ' Set it
                     CP += 2                                      ' Step over the BOM
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- See what EOL characters seem to be present for ANSI files                        |
               '-----------------------------------------------------------------------------------+
               IF FCB.RECFM = "V" THEN                            ' Skip if RECFM=V
                  tmpEOL = "NONE": DLM = ""                       '
               ELSE                                               '
                  ARRAY SCAN gEOLFlagList() FOR 7, = prfEOL, TO i ' Profile using one of the standard list items?
                  IF i THEN                                       ' Yes
                     IF INSTR(Chunk, $CRLF) THEN                  ' Normal?
                        tmpEOL = "CRLF": DLM = $CRLF              '
                     ELSEIF INSTR(Chunk, $CR) THEN                ' CR
                        tmpEOL = "CR": DLM = $CR                  '
                     ELSEIF INSTR(Chunk, $LF) THEN                ' LF
                        tmpEOL = "LF": DLM = $LF                  '
                     ELSEIF INSTR(Chunk, $NL) THEN                ' NL
                        tmpEOL = "NL": DLM = $NL                  '
                     END IF                                       '
                  END IF                                          '
               END IF                                             '

               IF lclSource = "UTF16"  OR lclSource = "UTF16LE" OR lclSource = "UTF16BE" THEN   ' For UTF 16 bit check other way
                  i = INSTR(Chunk, CHR$(13, 0, 10, 0))            ' Look for normal
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(13, 0, 10, 0)    ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
                  i = INSTR(Chunk, CHR$(0, 13, 0, 10))            ' Look for other normal
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(0, 13, 0, 10)    ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
                  i = INSTR(Chunk, CHR$(13, 0))                   ' CR
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(13, 0)           ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
                  i = INSTR(Chunk, CHR$(0, 13))                   ' CR
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(0, 13)           ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
                  i = INSTR(Chunk, CHR$(10, 0))                   ' LF
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(10, 0)           ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
                  i = INSTR(Chunk, CHR$(0, 10))                   ' LF
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(0, 10)           ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
                  i = INSTR(Chunk, CHR$(21, 0))                   ' NL
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(21, 0)           ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
                  i = INSTR(Chunk, CHR$(0, 21))                   ' NL
                  IF i AND (i - CP) MOD 2 = 0 THEN                ' On a boundary
                     tmpEOL = "CRLF": DLM = CHR$(0, 21)           ' Looks good
                     GOTO UTFDone                                 '
                  END IF                                          '
               END IF                                             '

               UTFDone:                                           '
               IF prfEOL = "NONE" THEN                            ' If EOL NONE
                  DLM = "": tmpEOL = "NONE"                       ' Null the DLM so it doesn't mess up LRECL
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Check possible LRECL problem                                                     |
               '-----------------------------------------------------------------------------------+
               IF FCB.LRECL > 0 THEN                              ' If Fixed records, see if user should be warned
                  j = LOF(FCB.FNum)                               '
                  j = FCB.LRECL + LEN(DLM)                        '
                  IF LOF(FCB.FNum) MOD (FCB.LRECL + LEN(DLM)) <> 0 THEN ' Evenly divisible?
                     j = DoMessageBox("File: |K" & FCB.FilePath + $CRLF + "|Bis not a multiple of LRECL " + FORMAT$(FCB.LRECL) + ", EOL=" + tmpEOL + $CRLF + _ '
                                      "the last record will be blank padded", %MB_OK + %MB_USERICON, _   '
                                      "SPFLite FileLoad")         '
                  END IF                                          '
               END IF                                             '

            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Finally, try deblocking a line out of the block                                     |
            '--------------------------------------------------------------------------------------+
            RESET gLoopCtr                                        ' Reset LoopCtr to avoid treating as a loop

            '--------------------------------------------------------------------------------------+
            '- If EOL AUTO we do lots of fiddles to try and get things neat                        |
            '--------------------------------------------------------------------------------------+
            IF LEFT$(prfEOL, 4) = "AUTO" THEN                     ' The ugly AUTO/NL type?
               i = INSTR(CP, Chunk, ANY $EOLDLM)                  ' See if any interesting delimiters
               IF i > 0 THEN                                      ' If there's a line present
                  IF MID$(Chunk, i, 3) = $CR + $FF + $LF THEN     ' The weird CR/FF/LF type?
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                     CP = i + 3                                   ' Step over it
                     GOSUB InsertT                                ' Insert t as a line
                     PageFlag = %True                             ' Make next line a PAGE
                  ELSEIF MID$(Chunk, i, 3) = $CR + $CR + $LF THEN ' The extra CR type?
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                     CP = i + 3                                   ' Step over it
                     GOSUB InsertT                                ' Insert t as a line
                  ELSEIF MID$(Chunk, i, 2) = $CRLF THEN           ' The normal line?
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                     CP = I + 2                                   ' Step over
                     GOSUB InsertT                                ' Insert t as a line
                  ELSEIF MID$(Chunk, i, 2) = $CR + $FF THEN       ' The normal line plus page?
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = %True  ' Setup for InsertT
                     CP = i + 2                                   ' Step over
                     GOSUB InsertT                                ' Insert t as a line
                     PageFlag = %True                             ' Make next line a PAGE MM1 set =PAGE
                  ELSEIF MID$(Chunk, i, 2) = $LF + $NUL THEN      ' Another weird LF line?
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                     CP = i + 2                                   ' Ste over
                     GOSUB InsertT                                ' Insert t as a line
                  ELSEIF MID$(Chunk, i, 1) = $LF THEN             ' The LF line?
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                     CP = i + 1                                   ' Step over
                     GOSUB InsertT                                ' Insert t as a line
                  ELSEIF MID$(Chunk, i, 1) = $CR THEN             ' The CR line?
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                     CP = i + 1                                   ' Step over
                     GOSUB InsertT                                ' Insert t as a line
                  ELSEIF MID$(Chunk, i, 1) = $EOF THEN            ' The EOF?
                     CP = i + 1                                   ' Step over
                  ELSEIF CP = 1 AND MID$(Chunk, i, 1) = $FF THEN  ' If file starts with a FF then ignore it
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0 ' Setup for insert
                     CP = i + 1                                   '
                     GOSUB InsertT                                ' Insert t as a line
                     PageFlag = %True                             ' Make next line a PAGE
                  ELSEIF MID$(Chunk, i, 1) = $FF THEN             ' If an FF then set flag for next line
                     CP = i + 1: PageFlag = %True                 '
                  ELSEIF MID$(Chunk, i, 3) = $CR + $CR + $LF THEN ' Extra $CR, ignore it
                     CP = i + 1                                   '
                  ELSEIF MID$(Chunk, i, 1) = $CR AND INSTR($CR + $LF + $FF, MID$(Chunk, i + 1, 1)) = 0 THEN ' Lonely $CR (overlay)
                     TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                     CP = i + 1                                   ' Step Over
                     GOSUB InsertT                                ' Insert t as a line
                  ELSE                                            ' Last piece with no delimiter
                     TD.TFrom = CP: TD.TLen = bytesinfile - CP + 1: TD.TPage = 0 ' Setup for InsertT
                     CP = bytesinfile + 1                         ' Force all done
                     GOSUB InsertT                                ' Insert t as a line
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- A simple delimited line                                                             |
            '--------------------------------------------------------------------------------------+
            ELSEIF FCB.RECFM = "U" THEN                           ' If a delimited type file
               i = INSTR(CP, Chunk, DLM)                          ' See if there's a line present
               IF i THEN                                          ' If there is
                  TD.TFrom = CP: TD.TLen = i - CP: TD.TPage = 0   ' Setup for InsertT
                  CP = i + LEN(DLM)                               ' Step over
                  GOSUB InsertT                                   ' Go insert the line
               ELSE                                               ' Remainder of buffer
                  TD.TFrom = CP: TD.TLen = bytesinfile - CP + 1: TD.TPage = 0 ' Setup for InsertT
                  GOSUB InsertT                                   ' Go insert the line
                  CP = bytesinfile + 1                            ' Exit
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Fixed LRECL type deblocking                                                         |
            '--------------------------------------------------------------------------------------+
            ELSEIF FCB.RECFM = "F" THEN                           ' Is this the fixed LRECL?
               IF CP + FCB.LRECL + LEN(DLM) <= bytesinfile THEN   ' If there's enough data for a record
                  TD.TFrom = CP: TD.TLen = FCB.LRECL: TD.TPage = 0   ' Setup for InsertT
                  CP += FCB.LRECL + LEN(DLM)                      ' Step over it
                  GOSUB InsertT                                   ' Go insert the line
               ELSE                                               ' Trailing stuff
                  TD.TFrom = CP: TD.TLen = bytesinfile - CP + 1 - LEN(DLM): TD.TPage = 0  ' Setup for InsertT
                  GOSUB InsertT                                   ' Exit to read more data
                  CP = bytesinfile + 1                            ' Force End
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Variable RDW type deblocking                                                        |
            '--------------------------------------------------------------------------------------+
            ELSEIF LEFT$(FCB.RECFM, 1) = "V" THEN                 ' If a RECFM=V

               DO UNTIL CP > bytesinfile                          ' Spin throough the buffer
                  IF gfInterrupt THEN EXIT DO                     ' Break during FF search

                  RDW = MID$(Chunk, CP, 4)                        ' Get in the RDW
                  CP += 4                                         ' Step over RDW
                  SELECT CASE AS CONST$ FCB.RECFM                 ' See how to handle it
                     CASE "V"                                     ' Old style V
                        i = CVL(MID$(RDW, 2, 1) + LEFT$(RDW, 1) + CHR$(0,0)) - 4 ' Get actual data length
                     CASE "VBI"                                   ' Big Endian
                        i = CVL(RDW)                              '
                     CASE "VLI"                                   ' Little EndiAN
                        i = CVL(RIGHT$(RDW, 1) + MID$(RDW, 3, 1) + MID$(RDW, 2, 1) + LEFT$(RDW, 1))   '
                  END SELECT                                      '
                  IF CP + i <= bytesinfile + 1 THEN               ' Better be this much left
                     TD.TFrom = CP: TD.TLen = i: TD.TPage = 0     ' Setup for InsertT
                     CP += i                                      ' Step over it
                  ELSE                                            '
                     j = DoMessageBox("File: |K" & FCB.FilePath + $CRLF + "|B does not appear to be a valid RECFM=" + FCB.RECFM + " file." + $CRLF + _   '
                                      "The data loaded should not be trusted", %MB_OK + %MB_USERICON, _  '
                                      "SPFLite FileLoad")         '
                     GOTO VDeblockDone                            ' Bail out
                  END IF                                          '
                  GOSUB InsertT                                   ' Insert t as a line
               LOOP                                               '
            END IF                                                '
         LOOP                                                     '

         VDeblockDone:                                            '
         '-----------------------------------------------------------------------------------------+
         '- Close the file                                                                         |
         '-----------------------------------------------------------------------------------------+
         CLOSE # FCB.FNum                                         ' Close it

         InsertData:                                              '
         GOSUB DoInserts                                          ' Go do the Inserts

         IF lin = 0 THEN MExitMeth                                ' If a simple read, just exit right away

         VCloseDone:                                              '
         IF ISFALSE (quick OR IsMedit) THEN                       ' If not quick or MEdit
            FileListRecentAdd(FCB.FilePath, "")                   ' Go add to RECENT list
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Figure out what STATE processing to do                                                 |
         '-----------------------------------------------------------------------------------------+
         IF XFormActive = "" THEN                                 ' STATE only if not XForm load
            IF FCB.StateFlag > %StateOff THEN                     ' STATE possible
               IF CurrPcmd = "COPY" THEN                          ' If the COPY command
                  IsCopy = %True                                  ' Tell STATE it's COPY calling
                  GOSUB DoState                                   ' Then go add any NOTEs

               ELSE                                               '
                  IF ISFALSE quick THEN                           ' Not quick mode
                     IF CurrPCmd = "MEDIT" THEN                   ' If MEDIT
                        IsCopy = %True                            ' Tell STATE it's COPY calling
                        GOSUB DoState                             ' Then go add the STATE data
                     ELSE                                         ' Else normal
                        IsCopy = %False                           ' Tell STATE it's NOT COPY calling
                        GOSUB DoState                             ' Then go add the STATE data
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check for UTF8 conversion error                                                        |
         '-----------------------------------------------------------------------------------------+
         IF UTFError <> 0 THEN                                    ' Was there an error?
            IF (UTFError AND 1) = 1 THEN                          ' Value outside ANSI range?
               TP.ErrMsgAdd(%eNone, "File contains UTF8 data outside ANSI range, UTF8 conversion terminated")  '
            ELSEIF (UTFError AND 2) = 2 THEN                      ' Malformed UTF8 value, X'A4' substituted
               TP.ErrMsgAdd(%eNone, "File contains malformed UTF8 data, X'A4' chars substituted")  '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do the NULLS warnng                                                                    |
         '-----------------------------------------------------------------------------------------+
         IF lclNull THEN TP.ErrMsgAdd(%eNone, "WARNING: File contains NULL (X'00') characters") '
                                                                  '
         '-----------------------------------------------------------------------------------------+
         '- Do the CAPS AUTO setting                                                               |
         '-----------------------------------------------------------------------------------------+
         IF FCB.CapsDesired = 2 AND CurrPcmd <> "COPY" THEN       ' If not COPY and CAPS=AUTO
            IF lclUpper AND ISFALSE lclLower THEN                 ' If only Upper, then set temp CAPS ON
               FCB.CapsActual = 1                                 '
               TP.ErrMsgAdd(%eNone, "CAPS set to AUTO:on")        '
            ELSE                                                  '
               FCB.CapsActual = 0                                 '
               TP.ErrMsgAdd(%eNone, "CAPS set to AUTO:off")       '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check SOURCE conflict possibility                                                      |
         '-----------------------------------------------------------------------------------------+
         IF XFormActive = "" THEN                                 ' Do only if not XForm load
            IF FCB.SourceName <> lclSource THEN                   ' Warn if encoding is different
               TP.ErrMsgAdd(0, "Warning, current SOURCE is " & FCB.SourceName & ", file loaded was " & TRIM$(lclSource))   '
            END IF                                                '
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Check EOL conflict possibility                                                         |
         '-----------------------------------------------------------------------------------------+
         IF XFormActive = "" THEN                                 ' Check only if not XForm load
            IF CurrPcmd <> "COPY" THEN                            ' If not the COPY command
               IF LEFT$(prfEOL, 4) <> "AUTO" AND _                '
                  LEFT$(prfEOL, 4) <> "NONE" AND _                '
                  tmpEOL <> prfEOL THEN                           ' Tell user of any EOL difference
                  t = TRIM$(tmpEOL)                               ' Format tmpEOL
                  IF VERIFY(t, $Hex) = 0 THEN t = "X'" + t + "'"  '
                  tt = TRIM$(prfEOL)                              ' Format EOL
                  IF VERIFY(tt, $Hex) = 0 THEN tt = "X'" + tt + "'"  ' IF hex operand, FRAME it FOR the message
                  TP.ErrMsgAdd(0, "Warning, Profile EOL is set to " + tt + ", file loaded was " + t)  ' Just warn
               END IF                                             '
            END IF                                                '
         END IF                                                   '
         IF ISFALSE quick THEN OffUndoFlag                        ' Make sure we get an Undo recorded

         '-----------------------------------------------------------------------------------------+
         '- Add ClrLoad error messages as NOTEs                                                    |
         '-----------------------------------------------------------------------------------------+
         me.LoadErrsDump                                          ' Dmp any errors

         gfXRebuild  = %True                                      '

         MExitMeth                                                '

      '--------------------------------------------------------------------------------------------+
      '- Insert a single line from the deblocking routines                                         |
      '--------------------------------------------------------------------------------------------+
      InsertT:                                                    '
         INCR lctr                                                ' Count the line
         IF lctr = 1 THEN LastPage = %False                       '
         IF frmlin <> 0 OR tolin <> 0 THEN                        ' Doing a line range
            IF lctr < frmlin OR lctr > tolin THEN RETURN          ' Only do lines in range
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If CopyaFile called as a simple line reader, stuff lines in a clipboard                |
         '-----------------------------------------------------------------------------------------+
         IF lin = 0 THEN                                          ' Called to insert after line zero?
            CBLines += MID$(Chunk, TD.TFrom, TD.TLen) + $CRLF     ' Add to CBLines
            RETURN                                                ' and return
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do CAPS LRECL test                                                                     |
         '-----------------------------------------------------------------------------------------+
         IF FCB.CapsDesired = 2 AND CurrPcmd <> "COPY" THEN       ' If not COPY and CAPS=AUTO
            t = MID$(Chunk, TD.TFrom, TD.TLen)                    ' Get line as a STRING forthe tests
            IF INSTR(t, ANY gLower) THEN lclLower = %True         ' Do tests for CAPS AUTO
            IF INSTR(t, ANY gUpper) THEN lclUpper = %True         '
         END IF                                                   '

         IF FCB.LRECL > 0 AND TD.TLen > FCB.LRECL THEN            ' A LONG LRECL record?
            TP.ErrMsgAdd(%eNone, "Records exceeding LRECL " + FORMAT$(FCB.LRECL) + " were detected")  '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Add data pointers to TD array                                                          |
         '-----------------------------------------------------------------------------------------+
         INCR TDCount                                             ' Bump TD count
         IF TDCount > UBOUND(TData()) THEN                        ' Need to expand?
            REDIM PRESERVE TData(1 TO 2 * UBOUND(TData())) AS TDataEnt  '
         END IF                                                   '
         IF PageFlag THEN PageFlag = %False: TD.TPage = 1         '
         TData(TDCount) = TD                                      ' Save pointers
         RETURN                                                   ' We're done

      DoInserts:                                                  '
         '-----------------------------------------------------------------------------------------+
         '- Expand the text table                                                                  |
         '-----------------------------------------------------------------------------------------+
         IF TDCount = 0 THEN RETURN                               ' Zero? Bail out
         me.LInsertLines(ln, TDCount, %Data)                      ' Get one line now, the slow way

         '-----------------------------------------------------------------------------------------+
         '- Now loop doing the inserts                                                             |
         '-----------------------------------------------------------------------------------------+
         FOR k = 1 TO TDCount                                     ' Process the TData table
            INCR ln                                               ' Bump insertion point
            me.LTxtSet(ln, MID$(Chunk, TData(k).TFrom, TData(k).TLen))  ' Set it in
            lTxtP = LTxtGP(ln)                                    ' Point at the Txt

            IF TData(k).TPage THEN                                ' Set as a PAGE line?
               IF ISFALSE LastPage THEN                           ' Try to prevent two in a row
                  me.LFlagBitOn(ln, %Page)                        ' Yes, set the flag
                  INCR PCtr                                       ' Count pages
                  LWrk2S(ln) = PCtr                               ' save it
                  LastPage = %True                                ' Remember for next
               END IF                                             '
               PageFlag = %False                                  ' Flip flag
            ELSE                                                  '
               LastPage = %False                                  ' No longer LastPage
            END IF                                                '
            me.UpdLControl(ln)                                    ' Setup LLCtl
            GOSUB DoPM                                            ' Go do PM processing

            '--------------------------------------------------------------------------------------+
            '- Do whatever translate is needed                                                     |
            '--------------------------------------------------------------------------------------+
            SELECT CASE AS CONST$ lclSource                       ' See what, if any, Unicode Xlate is needed
               CASE "ANSI"                                        ' Top choice - do nothing
                  EXIT SELECT                                     '
               CASE "UTF16", "UTF16LE"                            ' Standard UTF16? / LE
                  t = LTxtG(ln)                                   ' Get local copy
                  me.LTxtSet(ln, ACODE$(t))                       ' Do the conversion
               CASE "UTF8"                                        ' UTF8?
                  t = LTxtG(ln)                                   ' Get local copy
                  me.LTxtSet(ln, StrUtf82Ansi(t, UTFError))       ' Do the conversion
               CASE "UTF16BE"                                     ' UTF16 BigEndian?
                  t = LTxtG(ln)                                   ' Get local copy
                  FOR i = 0 TO LEN(t) - 1 STEP 2                  ' We have to reverse Char. Pairs 1st
                     C1 = STRPTR(t) + i: C2 = C1 + 1              ' Point at 1st two characters
                     SWAP @C1, @C2                                ' to get BE into LE format
                  NEXT                                            '
                  t = ACODE$(t)                                   ' Now we can Xlate it
                  me.LTxtSet(ln, t)                               ' Save it back
               CASE ELSE                                          ' Some other SOURCE value
                  t = LTxtG(ln)                                   ' Get local copy
                  me.Translate(t, FCB.GetSS2APtr)                 ' Translate SOURCE to ANSI
                  me.LTxtSet(ln, t)                               ' Translate SOURCE to ANSI
            END SELECT                                            '

            IF FCB.ImportTabs > 0 THEN                            ' Are we expanding tabs?
               lTxtP = LTxtGP(ln)                                 ' Point at the Txt
               me.LTxtSet(ln, TAB$(@lTxtP, FCB.ImportTabs))       ' Save it and do tab conversion
            END IF                                                '

            IF ISFALSE lclNull THEN                               ' If we haven't already found NULLS
               IF INSTR(@lTxtP, CHR$(0)) THEN lclNull = %True     ' then do NULL test, set lclNull if found
            END IF                                                '

            me.AttrScan(ln)                                       ' Setup attributes
            StateTo = ln                                          ' Last line for STATE processing
         NEXT k                                                   '
         RETURN                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Handle the STATE loading                                                                  |
      '--------------------------------------------------------------------------------------------+
      DoState:                                                    '
         me.StateLoad(FCB.FilePath, StateFrom, StateTo, IsCopy)   ' Go load them if valid (%True=COPY)
         RETURN                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Do the Post exclude processing                                                            |
      '--------------------------------------------------------------------------------------------+
      DoPM:                                                       '
         IF BIT(lclPM, %lCmdX) THEN                               ' Do the +/- processing for the Source
            me.LFlagBitOn(ln, %Invisible)                         ' If - make Invisible
            gfXRebuild = %True                                    ' Ask for Exclude processing
         ELSEIF BIT(lclPM, %lCmdNX) THEN                          '
            me.LFlagBitOff(ln, %Invisible)                        ' If + make visible
            gfXRebuild = %True                                    ' Ask for Exclude processing
         END IF                                                   '
         RETURN                                                   '

      SetEOL:                                                     '
         '-----------------------------------------------------------------------------------------+
         '- Choose the correct EOL delimiter                                                       |
         '-----------------------------------------------------------------------------------------+
         prfEOL = TRIM$(FCB.EOL)                                  ' Get the EOL
         SELECT CASE AS CONST$ prfEOL                             '
            CASE "CRLF":   DLM = $CRLF                            '
            CASE "LF":     DLM = $LF                              '
            CASE "CR":     DLM = $CR                              '
            CASE "NL":     DLM = $NL                              '
            CASE "NONE":   DLM = ""                               '
            CASE "AUTO":   DLM = $CRLF                            '
            CASE "AUTONL": DLM = $CRLF                            '
            CASE ELSE:     DLM = StrFromHex(prfEOL)               '
         END SELECT                                               '
         RETURN                                                   '

      END METHOD                                                  '


      METHOD CopyPTBL(a AS iObjParse, b AS iObjParse)             '
      '--------------------------------------------------------------------------------------------+
      '- Copy olne PTBL to another                                                                 |
      '--------------------------------------------------------------------------------------------+
         b.OpsNum           = a.OpsNum                            ' Copy PTBL data A => B
         b.MaxNum           = a.MaxNum                            '
         b.GotNum           = a.GotNum                            '
         b.MaxLit           = a.MaxLit                            '
         b.GotLit           = a.GotLit                            '
         b.MaxDotd          = a.MaxDotd                           '
         b.GotDotd          = a.GotDotd                           '
         b.MaxLptr          = a.MaxLptr                           '
         b.GotLPtr          = a.GotLPtr                           '
         b.MaxTag           = a.MaxTag                            '
         b.GotTag           = a.GotTag                            '
         b.MaxAdj           = a.MaxAdj                            '
         b.GotAdj           = a.GotAdj                            '
         b.MaxKwd           = a.MaxKwd                            '
         b.Flg              = a.Flg                               '
         b.ErrMsg           = a.ErrMsg                            '
         b.EType            = a.EType                             '
         b.ItemName         = a.ItemName                          '
         b.ItemValue        = a.ItemValue                         '
         b.ColFrom          = a.ColFrom                           '
         b.ColTo            = a.ColTo                             '
         b.FindRngEnd       = a.FindRngEnd                        '
         b.FindRngFlag      = a.FindRngFlag                       '
         b.FindRngLCtl      = a.FindRngLCtl                       '
         b.FindRngSet       = a.FindRngSet                        '
         b.FindRngStart     = a.FindRngStart                      '
         b.FindRngTag       = a.FindRngTag                        '
         b.FindRngTNF       = a.FindRngTNF                        '
         b.FlgAll           = a.FlgAll                            '
         b.FlgChars         = a.FlgChars                          '
         b.FlgCS            = a.FlgCS                             '
         b.FlgComment       = a.FlgComment                        '
         b.FlgDS            = a.FlgDS                             '
         b.FlgDX            = a.FlgDX                             '
         b.FlgFirst         = a.FlgFirst                          '
         b.FlgFCol          = a.FlgFCol                           '
         b.FlgHiClr         = a.FlgHiClr                          '
         b.FlgHiOff         = a.FlgHiOff                          '
         b.FlgHiOn          = a.FlgHiOn                           '
         b.FlgLast          = a.FlgLast                           '
         b.FlgLeft          = a.FlgLeft                           '
         b.FlgLit1          = a.FlgLit1                           '
         b.FlgL1Picture     = a.FlgL1Picture                      '
         b.FlgL1Hex         = a.FlgL1Hex                          '
         b.FlgL1RegEx       = a.FlgL1RegEx                        '
         b.FlgL1DLM         = a.FlgL1DLM                          '
         b.FlgL1CaseComp    = a.FlgL1CaseComp                     '
         b.FlgL1CaseInComp  = a.FlgL1CaseInComp                   '
         b.FlgLit2          = a.FlgLit2                           '
         b.FlgL2Picture     = a.FlgL2Picture                      '
         b.FlgL2Hex         = a.FlgL2Hex                          '
         b.FlgL2Format      = a.FlgL2Format                       '
         b.FlgL2CaseComp    = a.FlgL2CaseComp                     '
         b.FlgL2CaseInComp  = a.FlgL2CaseInComp                   '
         b.FlgL2Trunc       = a.FlgL2Trunc                        '
         b.FlgLM            = a.FlgLM                             '
         b.FlgMax           = a.FlgMax                            '
         b.FlgMSolid        = a.FlgMSolid                         '
         b.FlgMStd          = a.FlgMStd                           '
         b.FlgMX            = a.FlgMX                             '
         b.FlgNext          = a.FlgNext                           '
         b.FlgNF            = a.FlgNF                             '
         b.FlgNX            = a.FlgNX                             '
         b.FlgNU            = a.FlgNU                             '
         b.FlgOn            = a.FlgOn                             '
         b.FlgOff           = a.FlgOff                            '
         b.FlgPrefix        = a.FlgPrefix                         '
         b.FlgPrev          = a.FlgPrev                           '
         b.FlgPStd          = a.FlgPStd                           '
         b.FlgQuoted        = a.FlgQuoted                         '
         b.FlgRight         = a.FlgRight                          '
         b.FlgRngPass       = a.FlgRngPass                        '
         b.FlgRM            = a.FlgRM                             '
         b.FlgSet           = a.FlgSet                            '
         b.FlgSolid         = a.FlgSolid                          '
         b.FlgStd           = a.FlgStd                            '
         b.FlgSuffix        = a.FlgSuffix                         '
         b.FlgTCol          = a.FlgTCol                           '
         b.FlgText          = a.FlgText                           '
         b.FlgToggle        = a.FlgToggle                         '
         b.FlgTop           = a.FlgTop                            '
         b.FlgU             = a.FlgU                              '
         b.FlgWord          = a.FlgWord                           '
         b.FlgX             = a.FlgX                              '
         b.FoundFailed      = a.FoundFailed                       '
         b.FoundCol         = a.FoundCol                          '
         b.FoundLen         = a.FoundLen                          '
         b.FoundLine        = a.FoundLine                         '
         b.HiLiteOff        = a.HiLiteOff                         '
         b.HiLiteOn         = a.HiLiteOn                          '
         b.HiLiteSrch       = a.HiLiteSrch                        '
         b.L1Raw            = a.L1Raw                             '
         b.L1RData          = a.L1RData                           '
         b.L1Len            = a.L1Len                             '
         b.L2Raw            = a.L2Raw                             '
         b.L2RData          = a.L2RData                           '
         b.L2Len            = a.L2Len                             '
         b.SplitPoint1      = a.SplitPoint1                       '
         b.SplitPoint2      = a.SplitPoint2                       '
         b.RL1Raw           = a.RL1Raw                            '
         b.RL1RData         = a.RL1RData                          '
         b.RL1Len           = a.RL1Len                            '
         b.RSplitPoint1     = a.RSplitPoint1                      '
         b.RSplitPoint2     = a.RSplitPoint2                      '
         b.RFlgLit1         = a.RFlgLit1                          '
         b.RFlgL1Picture    = a.RFlgL1Picture                     '
         b.RFlgL1Hex        = a.RFlgL1Hex                         '
         b.RFlgL1RegEx      = a.RFlgL1RegEx                       '
         b.RFlgL1CaseComp   = a.RFlgL1CaseComp                    '
         b.RFlgL1CaseInComp = a.RFlgL1CaseInComp                  '
         b.RL2Raw           = a.RL2Raw                            '
         b.RL2RData         = a.RL2RData                          '
         b.RL2Len           = a.RL2Len                            '
         b.RFlgLit2         = a.RFlgLit2                          '
         b.RFlgL2Hex        = a.RFlgL2Hex                         '
         b.RFlgL2CaseComp   = a.RFlgL2CaseComp                    '
         b.RFlgL2CaseInComp = a.RFlgL2CaseInComp                  '
      END METHOD                                                  '

      METHOD CRPBack(MoveMode AS LONG, FromCRP AS LONG, NumRows AS LONG) AS LONG '
      '--------------------------------------------------------------------------------------------+
      '- Return an altered Row pointer                                                             |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Take a line pointer and move it backward accounting for X'd and special lines          |
         '-----------------------------------------------------------------------------------------+
         i = NumRows: j = FromCRP                                 ' Copy params

         DO WHILE i                                               ' While more lines to go back
            '--------------------------------------------------------------------------------------+
            '- Visible lines                                                                       |
            '--------------------------------------------------------------------------------------+
            IF MoveMode = %mVisible THEN                          ' Doing Visible lines?
               DO                                                 ' Yes, loop backward till a visible line is seen
                  j = MAX(j - 1, 1)                               '
               LOOP UNTIL (ISFALSE IsLInvisible(j) AND ISFALSE IsLXclude(j)) OR _   '
                          (IsLXclude(j) AND ISFALSE IsHideFlag) OR _ '
                          J = 1                                   '

            '--------------------------------------------------------------------------------------+
            '- Data lines                                                                          |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mData THEN                         ' Doing Data Lines?
               DO                                                 ' Yes, loop backward till a Data line is seen
                  j = MAX(j - 1, 1)                               '
               LOOP UNTIL IsLData(j) OR IsLNote(j) OR j = 1       '

            '--------------------------------------------------------------------------------------+
            '- Only Data lines                                                                     |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mOData THEN                        ' Doing Data Lines?
               IF j > 2 THEN                                      ' Room to move?
                  DO                                              ' Yes, loop backward till a Data line is seen
                     j = MAX(j - 1, 1)                            '
                  LOOP UNTIL IsLData(j) OR j = 2                  '
               END IF                                             '
            '--------------------------------------------------------------------------------------+
            '- Visible Data lines                                                                  |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mVisData THEN                      ' Doing visible Data Lines?
               DO                                                 ' Yes, loop backward till a Data line is seen
                  j = MAX(j - 1, 1)                               '
               LOOP UNTIL ((IsLData(j) OR IsLNote(j)) AND ISFALSE IsLInvisible(j)) OR j = 1  '

            '--------------------------------------------------------------------------------------+
            '- Page mode backward                                                                  |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mPage THEN                         ' Doing PAGE mode Lines?
               DO                                                 ' Yes, loop backward till a Page line is seen
                  j = MAX(j - 1, 1)                               '
               LOOP UNTIL (IsLData(j) AND ISFALSE IsLInvisible(j) AND IsLPage(j)) OR j = 1   '

            END IF                                                '
            IF j = 1 THEN EXIT DO                                 ' OK, if Row is zero, we'd better stop
            DECR i                                                ' Else DECR the number we're supposed to do
         LOOP                                                     ' and loop till done
         METHOD = j                                               ' Pass back the Row we ended up with
         MExit                                                    '
      END METHOD                                                  '

      METHOD CRPBack2Page() AS LONG                               '
      '--------------------------------------------------------------------------------------------+
      '- return # of lines to next page                                                            |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         j = 0                                                    ' Count lines to next page
         i = @P.PTopLine                                          ' i = current top of screen
         DO                                                       ' Find next page line or lastline
            INCR j: i = MAX(i - 1, 1)                             ' Count
         LOOP UNTIL IsLPage(i) OR i = 1                           '
         METHOD = j                                               ' Return count
      END METHOD                                                  '

      METHOD CRPFwd(MoveMode AS LONG, FromCRP AS LONG, NumRows AS LONG) AS LONG  '
      '--------------------------------------------------------------------------------------------+
      '- Return an altered Row pointer                                                             |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL k, l, indent AS LONG, dlm AS INTEGER                  '
         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Take a line pointer and move it forward accounting for X'd and special lines           |
         '-----------------------------------------------------------------------------------------+
         i = NumRows: j = FromCRP                                 ' Copy params

         '-----------------------------------------------------------------------------------------+
         '- Fudge text values                                                                      |
         '-----------------------------------------------------------------------------------------+
         IF MoveMode = %MText THEN                                '
            i = 99999999                                          ' If Text mode set a LARGE limit
            k = j                                                 ' Look for Text line 2
            DO                                                    '
               INCR k                                             '
            LOOP WHILE ISFALSE IsLData(k) AND k < LastLine        ' k ends up at next data line
            indent = LEN(L(k).@LTxt) - LEN(LTRIM$(LTxtG(k))) + 1  ' Set indent of 2nd line
         END IF                                                   '

         DO WHILE i                                               ' While more lines to go forward

            '--------------------------------------------------------------------------------------+
            '- Visible lines                                                                       |
            '--------------------------------------------------------------------------------------+
            IF MoveMode = %mVisible THEN                          ' Doing Visible lines?
               DO                                                 ' Yes, loop forward till a Visible line is seen
                  j = MIN(j + 1, LastLine)                        '
               LOOP UNTIL (ISFALSE IsLInvisible(j) AND ISFALSE IsLXclude(j)) OR _   '
                          (IsLXclude(j) AND ISFALSE IsHideFlag) OR _ '
                          J = LastLine                            '

            '--------------------------------------------------------------------------------------+
            '- Data lines                                                                          |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mData THEN                         ' Doing Data lines?
               DO                                                 ' Yes, loop forward till a Data line is seen
                  j = MIN(j + 1, LastLine)                        '
               LOOP UNTIL IsLData(j) OR IsLNote(j) OR j = LastLine   '

            '--------------------------------------------------------------------------------------+
            '- Only Data lines                                                                     |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mOData THEN                        ' Doing Data lines?
               IF j < LastLine - 1 THEN                           ' Room to move
                  DO                                              ' Yes, loop forward till a Data line is seen
                     j = MIN(j + 1, LastLine - 1)                 '
                  LOOP UNTIL IsLData(j) OR j = LastLine - 1       '
               END IF                                             '
            '--------------------------------------------------------------------------------------+
            '- Visible data lines                                                                  |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mVisData THEN                      ' Doing Visible Data lines?
               DO                                                 ' Yes, loop forward till a Data line is seen
                  j = MIN(j + 1, LastLine)                        '
               LOOP UNTIL ((IsLData(j) OR IsLNote(j)) AND ISFALSE IsLInvisible(j)) OR j = LastLine '

            '--------------------------------------------------------------------------------------+
            '- Page mode                                                                           |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mPage THEN                         ' Doing PAGE mode Lines?
               IF IsLTop(j) THEN INCR j                           ' Fudge top of file PAGE
               DO                                                 ' Yes, loop forward till a Page line is seen
                  j = MIN(j + 1, LastLine)                        '
               LOOP UNTIL (IsLData(j) AND ISFALSE IsLInvisible(j) AND IsLPage(j)) OR j = LastLine  '

            '--------------------------------------------------------------------------------------+
            '- Text mode                                                                           |
            '--------------------------------------------------------------------------------------+
            ELSEIF MoveMode = %mText THEN                         ' Doing Text lines?
               dlm = 0                                            ' Reset DLM flag
               DO                                                 ' Yes, loop foreward till end of paragraph
                  j = MIN(j + 1, LastLine)                        '
                  IF IsLData(j) THEN                              ' Look only at Data lines
                     IF LEFT$(LTxtG(j), 1) = "." OR _             ' Look for leading delimiters
                        LEFT$(LTxtG(j), 1) = ":" OR _             '
                        LEFT$(LTxtG(j), 1) = "&" OR _             '
                        LEFT$(LTxtG(j), 1) = "<" THEN             '
                        dlm = 1                                   ' Break out of loop
                        EXIT DO                                   '
                     END IF                                       '
                     IF ISNULL(TRIM$(LTxtG(j))) THEN              ' Look for blank line
                        dlm = 1                                   ' Break out of loop
                        EXIT DO                                   '
                     END IF                                       '
                     IF indent <> LEN(L(j).@LTxt) - LEN(LTRIM$(LTxtG(j))) + 1 THEN  ' Different indent than 2nd line
                        dlm = 1                                   ' Break out of loop
                        EXIT DO                                   '
                     END IF                                       '
                  ELSEIF j = LastLine THEN                        '
                     EXIT DO                                      '
                  END IF                                          '
               LOOP UNTIL dlm = 1                                 '
               DECR j                                             ' Point at the last one
               EXIT DO                                            '
            END IF                                                '

            IF j = LastLine THEN EXIT DO                          ' OK if Row is at the end, stop
            DECR i                                                ' Else DECR the number we're supposed to do
         LOOP                                                     ' and loop till done

         METHOD = j                                               ' Pass back the resulting Row
         MExit                                                    '
      END METHOD                                                  '

      METHOD CRPFwd2Page() AS LONG                                '
      '--------------------------------------------------------------------------------------------+
      '- return # of lines to next page                                                            |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         i = @P.PTopLine                                          ' i = current top of screen
         DO                                                       ' Find next page line or lastline
            INCR j: INCR i                                        ' Count
         LOOP UNTIL IsLPage(i) OR i = LastLine                    '
         METHOD = j                                               ' Return count
      END METHOD                                                  '

      PROPERTY GET CsrCol() AS LONG: PROPERTY = @P.C.CCol: END PROPERTY '
      PROPERTY SET CsrCol(v AS LONG): @P.C.CCol = v: me.CsrMode: END PROPERTY '

      METHOD CsrColAdd (amt AS LONG): @P.C.CCol += amt: me.CsrMode: END METHOD   '
      METHOD CsrColSub (amt AS LONG): @P.C.CCol -= amt: me.CsrMode: END METHOD   '

      PROPERTY GET CsrRow() AS LONG: PROPERTY = @P.C.CRow: END PROPERTY '
      PROPERTY SET CsrRow(v AS LONG): @P.C.CRow = v: me.CsrMode: END PROPERTY '

      METHOD CsrRowAdd (amt AS LONG): @P.C.CRow += amt: me.CsrMode: END METHOD   '
      METHOD CsrRowSub (amt AS LONG): @P.C.CRow -= amt: me.CsrMode: END METHOD   '

      METHOD CsrMode()                                            '
      LOCAL i AS LONG                                             '
      '--------------------------------------------------------------------------------------------+
      '- Set Csr @P.C.CType values                                                                 |
      '--------------------------------------------------------------------------------------------+
      IF @P.C.CRow <> @P.PLastRow THEN                            ' Watch for significant changes
         @P.PLastRow = @P.C.CRow                                  ' Update it
         KBTabFree = %False                                       ' Reset TabFree
      END IF                                                      '
      IF @P.C.CCol <> @P.PLastCol THEN                            '
         @P.PLastCol = @P.C.CCol                                  '
      END IF                                                      '
      IF ISFALSE IsFMTab THEN                                     ' Edit screen?
         SELECT CASE AS LONG @P.C.CRow                            ' Select first by row
            CASE @P.PTop                                          ' Command line
               @P.C.CIX = 0                                       ' Clear IX
               SELECT CASE AS LONG @P.C.CCol                      ' Select by column
                  CASE < @P.PCmdCol: @P.C.CType = %CBad           ' We're in Bad area
                  CASE < @P.PScrHdr                               ' In Command area?
                     @P.C.CType = %CCmd                           ' Set the type
                     @P.C.CLCol = @P.C.CCol - @P.PCmdCol + 1 + @P.PCOffset ' Calc logical position in field
                     @P.C.CSCol = @P.C.CCol - @P.PCmdCol + 1      ' Calc position in screen field
                  CASE >= @P.PScrData                             ' In Scroll Amt area?
                     @P.C.CType = %CScrl                          '
                     @P.C.CLCol = @P.C.CCol - @P.PScrData + 1     ' Calc logical offset in field
                     @P.C.CSCol = @P.C.CLCol                      ' Calc offset in screen field
               END SELECT                                         ' End of row 1

            CASE >= @P.PData1                                     ' In text area
               CursFindInv.Top = 0                                ' Null Find Hilite pointer
               SELECT CASE AS LONG @P.C.CCol                      ' Select by column
                  CASE < @P.PGapCol                               ' In line command area
                     IF @P.PS(@P.C.CRow) < 1 THEN _               ' If not a valid line (Hex)
                        @P.C.CType = %CBad: EXIT SELECT           ' flag it Bad instead
                     @P.C.CType = %CLCmd                          ' Yep, remember that
                     @P.C.CLCol = @P.C.CCol - @P.PLeft + 1        ' Calc logical offset in field
                     @P.C.CSCol = @P.C.CLCol                      ' Calc offset in screen field
                     @P.C.CIX = @P.PS(@P.C.CRow)                  ' Pass back the line index
                  CASE > @P.PGapCol                               ' In text data area?
                     @P.C.CType = %CLData                         ' Start as good Data
                     @P.C.CIX = me.SGet(@P.C.CRow)                ' Get real data IX pointer
                     IF @P.C.CIX = 0 OR @P.C.CIX = -3 THEN        ' Eliminate bad lines
                        @P.C.CType = %CBad: EXIT SELECT           ' If it is, flag it Bad instead
                     ELSEIF @P.C.CIX > 0 AND _                    '
                        (ISTRUE (L(@P.C.CIX).LFlag AND (%Top OR %Bottom))) THEN  '
                        @P.C.CType = %CBad: EXIT SELECT           ' If it is, flag it Bad instead
                     ELSEIF @P.C.CIX < 0 THEN                     ' A Hex Line?
                        @P.C.CIX = me.SGet(@P.C.CRow - ABS(@P.C.CIX)) ' Convert to real line index
                     END IF                                       '
                     @P.C.CLCol = @P.C.CCol - @P.PGapCol + @P.POffset ' Calc logical offset in field
                     @P.C.CSCol = @P.C.CCol - @P.PGapCol          ' Calc offset in screen field
                     me.AttrInvGrab(@P.C.CIX, @P.C.CLCol)         ' See if a find hilite to grab
               END SELECT                                         '

            CASE ELSE                                             '
               @P.C.CIX = 0                                       ' Clear IX
               @P.C.CType = %CBad                                 ' Make it Bad
         END SELECT                                               '

      ELSE                                                        ' FM Mode

         SELECT CASE AS LONG @P.C.CRow                            ' OK, figure it out

            CASE 1                                                ' Possible pCommand line?
               SELECT CASE AS LONG @P.C.CCol                      ' Now look at column
                  CASE < @P.PCmdCol: @P.C.CType = %CBad           ' We're in Bad area
                  CASE < @P.PScrHdr                               ' In Command area?
                     @P.C.CType = %CCmd                           '
                     @P.C.CLCol = @P.C.CCol - @P.PCmdCol + 1 + @P.PCOffset ' Calc logical offset in field
                     @P.C.CSCol = @P.C.CCol - @P.PCmdCol + 1      ' Calc offset in screen field
                  CASE >= @P.PScrData                             ' In Scroll Amt area?
                     @P.C.CType = %CScrl                          '
                     @P.C.CLCol = @P.C.CCol - @P.PScrData + 1     ' Calc logical offset in field
                     @P.C.CSCol = @P.C.CCol - @P.PScrdata + 1     ' Calc offset in screen field
               END SELECT                                         '

            CASE 2, gFM_Head_Line, > gENV.ScrHeight + 1 - (2 * gENV.FMHelpFlag)  ' Static rows
               @P.C.CType = %CBad                                 ' So remember we're in Bad area

            CASE gFM_Quick_Line_1                                 ' First quick line?
               @P.C.CType = %CBad                                 ' So remember we're in Bad area

            CASE gFM_Path_Line                                    ' Possible Default Path?
               IF ISNOTNULL(FileListNm) THEN @P.C.CType = %CBad: EXIT SELECT  ' Bad in FileList mode
               IF @P.C.CCol < gFM_Path_Left THEN @P.C.CType = %CBad: EXIT SELECT ' Left end? Bad
               @P.C.CType = %CFPath                               ' We're in Path field
               @P.C.CLCol = @P.C.CCol - gFM_Path_Left + 1         ' Calc logical offset in field
               @P.C.CSCol = @P.C.CCol - gFM_Path_Left + 1         ' Calc offset in screen field

            CASE gFM_Mask_Line                                    ' Not legal for FILELIST mode
               IF @P.C.CCol < gFM_Mask_Left THEN @P.C.CType = %CBad: EXIT SELECT ' Done
               @P.C.CType = %CFMask                               ' We're in Types
               @P.C.CLCol = @P.C.CCol - gFM_Mask_Left + 1         ' Calc logical offset in field
               @P.C.CSCol = @P.C.CCol - gFM_Mask_Left + 1         ' Calc offset in screen field

            CASE >= gFM_Top_File_Line                             ' File List area
               IF @P.C.CRow >= gFM_Top_File_Line + gFMDCtr - @P.PTopLine THEN @P.C.CType = %CBad: EXIT SELECT  '
               SELECT CASE AS LONG @P.C.CCol                      ' Now look at column
                  CASE 1 TO gENV.FMLCmdWidth                      ' We're in the line command area
                     @P.C.CIX = @P.C.CRow - gFM_Top_File_Line + @P.PTopLine   ' Calc gFMD index
                     @P.C.CType = %CFLCmd                         '
                     i = gFMD(@P.C.CIX).CmdOff                    '
                     @P.C.CLCol = @P.C.CCol + gFMD(@P.C.CIX).CmdOff  ' Calc logical offset in field
                     @P.C.CSCol = @P.C.CCol                       ' Calc offset in screen field

                  CASE ELSE: @P.C.CType = %CFLData                ' We're elsewhere in the line
               END SELECT                                         '
         END SELECT                                               '
      END IF                                                      '
      END METHOD                                                  '

      METHOD CursCmnd() AS LONG: METHOD = ISTRUE @P.C.CType = %CCmd:   END METHOD   '
      METHOD CursData() AS LONG: METHOD = ISTRUE @P.C.CType = %CLData: END METHOD   '
      METHOD CursLinN() AS LONG: METHOD = ISTRUE @P.C.CType = %CLCmd:  END METHOD   '

      METHOD CurSetReq(prio AS INTEGER, Lin AS LONG, pCol AS LONG, fscrl AS INTEGER, OPT Back AS LONG, OPT HexRow AS LONG) '
      '--------------------------------------------------------------------------------------------+
      '- Update the cursor request position if needed                                              |
      '--------------------------------------------------------------------------------------------+
         IF gENV.AttnPos AND (prio AND %LineCmd) AND TRIM$(pCommand) = "" THEN   ' If AttnPos AND a Line command calling, ignore items off the screen
            IF Lin < @P.PTopLine THEN EXIT METHOD                 ' If request above TOS, then ignore it
         END IF                                                   '
         IF prio > sCurPrio THEN                                  ' A higher priority request?
            IF sCurLin > 0 THEN                                   ' A previous line set?
               L(sCurLin).LCol =  0                               ' Clear it then
               me.LFlagBitOff(sCurLin, %Cursor)                   '
               me.LFlagBitOff(sCurLin, %Scroll)                   '
               me.LFlagBitOff(sCurLin, %XPtr)                     '
            END IF                                                '
            sCurPrio = prio                                       ' Save request reason (caller)
            sCurLin = lin                                         ' Save line
            sCurScrl = fscrl                                      ' Save SCRL flag
            sCurHexl = IIF(ISMISSING(HexRow), 0, HexRow)          ' Setup optional Hex Row
            L(lin).LCol =  pCol                                   ' Store in the actual text line area
            me.LFlagBitOn(lin, %Cursor)                           '
            IF fscrl THEN me.LFlagBitOn(lin, %Scroll)             '
            IF ISFALSE ISMISSING(Back) THEN                       '
               IF Back THEN me.LFlagBitOn(lin, %XPtr)             '
            END IF                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD CursLCmd()  AS LONG: METHOD = ISTRUE @P.C.CType = %CFLCmd: END METHOD  '
      METHOD CursLLin()  AS LONG: METHOD = ISTRUE @P.C.CType = %CFLData: END METHOD '

      METHOD DoMarkLines()                                        '
      '--------------------------------------------------------------------------------------------+
      '- Draw mark lines on the screen                                                             |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      LOCAL u AS STRING                                           '
         MEntry                                                   '
         IF (FCB.MarkFlag AND ISFALSE IsPTypeMode AND ISNOTNULL(TRIM$(FCB.MarkLine))) OR _   ' Column marking
            (FCB.TabBNDS  AND ISFALSE IsPTypeMode AND ISNOTNULL(TRIM$(FCB.TabsLine))) THEN   ' TabBNDS mode
            @P.PTopDrawn = @P.PData1                              '
            i = me.SGet(@P.PTopDrawn)                             '
            IF IsLTop(me.SGet(@P.PTopDrawn)) THEN INCR @P.PTopDrawn ' Adjust top line
            IF @P.PLastDrawn < @P.PTopDrawn THEN MexitMeth        ' (Empty file)
            i = 1: u = IIF$(FCB.TabBnds, me.TabsSimple(@P.POffSet + 200), FCB.MarkWorking)   '
            IF FCB.TabBNDS THEN GRAPHIC STYLE 2                   ' Switch to dotted line
                                                                  ' Scan for Mark columns
            DO                                                    '
               i = INSTR(i, u, "*")                               ' Look for next marker
               IF i = 0 THEN EXIT DO                              '

               IF i >= @P.POffset + 1 AND i <= @P.POffset + @P.PDataLen THEN  ' Within screen boundary
                  GRAPHIC SET MIX %MIX_COPYSRC                    '
                  GRAPHIC LINE ((i - 1 + gLNPadCol - @P.POffset) * gFontWidth + %GLM - 1, (@P.PTopDrawn - 1) * gFontHeight) - _   '
                               ((i - 1 + gLNPadCol - @P.POffset) * gFontWidth + %GLM - 1, @P.PLastDrawn * gFontHeight), gENV.cMarkLine  '
               END IF                                             '
               INCR i                                             '
            LOOP                                                  '
            GRAPHIC STYLE 0                                       ' Back to solid line
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD DoPFKShow                                            '
      LOCAL c, i, j AS LONG                                       '
      LOCAL Txt1, Txt2, Txt3, Txt4, Txt5 AS STRING                '
         MEntry                                                   '
         IF gENV.PFKShow = 0 OR IsFMTab THEN MExitMeth            ' Skip if not needed
         c = INT(gENV.ScrWidth / (gKbdT.KbdPFShowMax + 2))        '
         j = 1: txt1 = "": txt2 = "": txt3 = "": txt4 = "": txt5 = ""   ' Starting variables
         FOR i = 1 TO c                                           ' Build a line
            IF j <= gKbdT.KbdPFShowNum THEN                       ' Still PFSHOW entries left?
               txt1 += LSET$(MID$(gKbdT.KbdPFShow(j), 2), gKbdT.KbdPFShowMax + 2)   '
               INCR j                                             '
            END IF                                                '
         NEXT i                                                   '
         FOR i = 1 TO c                                           ' Build a line
            IF j <= gKbdT.KbdPFShowNum THEN                       ' Still PFSHOW entries left?
               txt2 += LSET$(MID$(gKbdT.KbdPFShow(j), 2), gKbdT.KbdPFShowMax + 2)   '
               INCR j                                             '
            END IF                                                '
         NEXT i                                                   '
         FOR i = 1 TO c                                           ' Build a line
            IF j <= gKbdT.KbdPFShowNum THEN                       ' Still PFSHOW entries left?
               txt3 += LSET$(MID$(gKbdT.KbdPFShow(j), 2), gKbdT.KbdPFShowMax + 2)   '
               INCR j                                             '
            END IF                                                '
         NEXT i                                                   '
         FOR i = 1 TO c                                           ' Build a line
            IF j <= gKbdT.KbdPFShowNum THEN                       ' Still PFSHOW entries left?
               txt4 += LSET$(MID$(gKbdT.KbdPFShow(j), 2), gKbdT.KbdPFShowMax + 2)   '
               INCR j                                             '
            END IF                                                '
         NEXT i                                                   '
         FOR i = 1 TO c                                           ' Build a line
            IF j <= gKbdT.KbdPFShowNum THEN                       ' Still PFSHOW entries left?
               txt5 += LSET$(MID$(gKbdT.KbdPFShow(j), 2), gKbdT.KbdPFShowMax + 2)   '
               INCR j                                             '
            END IF                                                '
         NEXT i                                                   '
         IF gENV.PFKShow > 0 THEN _                               '
            DoPrintPFKHelp(LSET$(txt1, gENV.ScrWidth), @P.PBottom + 1)  '
         IF gENV.PFKShow > 1 THEN _                               '
            DoPrintPFKHelp(LSET$(txt2, gENV.ScrWidth), @P.PBottom + 2)  '
         IF gENV.PFKShow > 2 THEN _                               '
            DoPrintPFKHelp(LSET$(txt3, gENV.ScrWidth), @P.PBottom + 3)  '
         IF gENV.PFKShow > 3 THEN _                               '
            DoPrintPFKHelp(LSET$(txt4, gENV.ScrWidth), @P.PBottom + 4)  '
         IF gENV.PFKShow > 4 THEN _                               '
            DoPrintPFKHelp(LSET$(txt5, gENV.ScrWidth), @P.PBottom + 5)  '
         MExit                                                    '
      END METHOD                                                  '

      METHOD  DoRenum()                                           '
      '--------------------------------------------------------------------------------------------------+
      '- Do the simple renum function                                                                    |
      '--------------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL lclNumb AS STRING                                     '
         MEntry                                                   '
         IF ISFALSE IsRenumFlag THEN MExitMeth                    '
         OffRenumFlag                                             ' Flip the flag
         FOR i = 1 TO LastLine                                    ' Spin through the lines
            IF IsLData(i) THEN                                    ' Only Data lines
               INCR j                                             ' Bump line number
               lclNumb = FORMAT$(j, "00000000")                   ' Format a number
               IF LLNumG(i) <> lclNumb THEN                       ' Different?
                  LLNumS(i) = lclNumb                             ' Stuff it in
                  me.UpdLControl(i)                               ' Update the LLCtl
               END IF                                             '
            END IF                                                '
         NEXT i                                                   '
         LastReal = j                                             ' Might as well save a known number
         MExit                                                    '
      END METHOD                                                  '

      METHOD ErrMsgAdd(sev AS LONG, MsgT AS STRING)               ' Go Queue the message text
      '--------------------------------------------------------------------------------------------+
      '- Queue error messages                                                                      |
      '--------------------------------------------------------------------------------------------+
         IF ISNULL(TRIM$(MsgT)) THEN EXIT METHOD                  ' Ignore null messages
         IF ErrMsgTblC + 1 > UBOUND(ErrMsgTbl()) THEN             ' Exceeding current table size?
            REDIM PRESERVE ErrMsgTbl(1 TO 2 * UBOUND(ErrMsgTbl())) AS INSTANCE STRING  ' Make it bigger
         END IF                                                   '
         ARRAY INSERT ErrMsgTbl(), MsgT                           ' Insert it and push the rest down
         INCR ErrMsgTblC                                          ' Count it
         IF sev >= ErrMsgHigh THEN                                ' New high? Or newer equal?
            ErrMsgHigh = sev: ErrMsgTop = MsgT                    ' Save new high RC and message
         END IF                                                   '
      END METHOD                                                  '

      METHOD ErrMsgReset(OPT Last AS LONG)                        '
      '--------------------------------------------------------------------------------------------+
      '- Reset error message areas                                                                 |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
         IF ISMISSING(Last) THEN                                  ' Not LAST?
            RESET ErrMsgHigh, ErrMsgTop, ErrMsgTblC, ErrMsgTbl()  ' Reset everything current
         ELSE                                                     ' Yes, LAST rebuild
            RESET ErrMsgLast                                      ' Save previous for + Help display
            IF ErrMsgTblC > 1 THEN                                ' If anything there
               FOR i = 1 TO ErrMsgTblC                            ' Add the entries
                  ErrMsgLast += ErrMsgTbl(i) + $CRLF              '
               NEXT i                                             '
            END IF                                                '
            RESET ErrMsgHigh, ErrMsgTop, ErrMsgTblC, ErrMsgTbl()  ' Reset everything current
         END IF                                                   '
      END METHOD                                                  '

      METHOD ErrTblGet(i AS LONG) AS STRING: METHOD = ErrMsgTbl(i): END METHOD   '

      METHOD FileWatch (WatchFile AS STRING, WatchFunc AS LONG) AS LONG '
      '--------------------------------------------------------------------------------------------+
      '- Setup a directory watch                                                                   |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j AS LONG, strbuffer AS ASCIIZ * 255               '

         MEntry                                                   '
         SELECT CASE WatchFunc                                    ' Split by what function requested
            CASE %WatchStart                                      ' %WatchStart
               j = VAL(FileQueue("I", " ", WatchFile))            ' Already in FQ table?
               IF j = 0 THEN                                      ' If not, Whoops!
                  METHOD = %True                                  '
                  MExitMeth                                       ' Oops!  Exit
               END IF                                             '
               IF gFQ(j).gWatchThread <> 0 THEN                   ' Already got thread address
                  METHOD = %True                                  ' Say we failed
                  MExitMeth                                       '
               END IF                                             '
               gFQ(j).gActive = %False                            '
               gFQ(j).gEvent = CreateEvent(BYVAL %Null, %TRUE, %FALSE, BYVAL %Null) '
               IF gFQ(j).gEvent = 0 THEN                          '
                  i = GetLastError                                '
                  FormatMessage %FORMAT_MESSAGE_FROM_SYSTEM, BYVAL %Null, i, %Null, strBuffer, SIZEOF(strBuffer), BYVAL %Null '
                  METHOD = %True                                  '
                  MExitMeth                                       ' Oops!  Exit
               END IF                                             '
               gFQ(j).gChanged = %False                           ' The change flag
               pWatchData = VARPTR(gFQ(j))                        ' Setup the pointer
               THREAD CREATE FileWatchThread(pWatchData) 65536, TO gFQ(j).gWatchThread ' Fire up the thread
               IF gFQ(j).gWatchThread = 0 THEN                    ' Failed?
                  METHOD = %True                                  ' Say we failed
                  MExitMeth                                       '
               END IF                                             '
               DO WHILE gFQ(j).gActive = %False                   ' Wait till thread starts
                  SLEEP 50                                        ' Wait a bit
               LOOP                                               '
               THREAD STATUS gFQ(j).gWatchThread TO wResult       ' See if running OK
               IF wResult <> 259 THEN                             ' If running OK STATUS returns &H103 (See Help)
                  METHOD = %True                                  ' Flag an error
               ELSE                                               '
                  METHOD = %False                                 ' Else, Say we started it
               END IF                                             '
               THREAD CLOSE gFQ(j).gWatchThread TO wResult        ' Free up our handle
               MExitMeth                                          '

            CASE %WatchEnd                                        ' %WatchEnd
               i = %False                                         '
               IF ISNULL(WatchFile) THEN                          ' If a normal End
                  FOR j = 1 TO UBOUND(gFQ())                      ' Just search for Tab number
                     IF gFQ(j).gPgNumber = PgNumber AND _         ' An entry for this tab?
                        gFQ(j).gInUse = %True THEN                '
                        i = %True                                 '
                        EXIT FOR                                  '
                     END IF                                       '
                  NEXT j                                          '
                  IF ISFALSE i THEN                               ' Didn't set j
                     METHOD = %True                               '
                     MExitMeth                                    ' Oops!  Exit
                  END IF                                          '
               ELSE                                               '
                  j = VAL(FileQueue("I", " ", WatchFile))         ' Fetch gFQ() index
                  IF j = 0 THEN                                   ' If not, Whoops!
                     METHOD = %True                               '
                     MExitMeth                                    ' Oops!  Exit
                  END IF                                          '
               END IF                                             '

               IF gFQ(j).gWatchThread = 0 THEN                    ' Never started?
                  METHOD = %False                                 ' Just return False
               ELSE                                               '
                  i = SetEvent(gFQ(j).gEvent)                     ' Tell watch thread to quit now
                  METHOD = gFQ(j).gChanged                        ' Copy the Changed flag result
                  gFQ(j).gWatchThread = 0                         '
                  gFQ(j).gActive = %False                         ' Say we're no longer active
                  gFQ(j).gInUse = %False                          ' Say the FQ entry is no longer in use
              END IF                                              '
         END SELECT                                               '
         MExit                                                    '
      END METHOD                                                  '

      METHOD IndentAsPrev(l AS LONG) AS LONG                      '
      '--------------------------------------------------------------------------------------------+
      '- Return an indent value = to indent of previous line                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         MEntry                                                   '
         i = me.CRPBack(%mData, l, 1)                             ' Backup to previous Data line
         IF ISNULL(TRIM$(LTxtG(i))) THEN                          ' If line empty, return 1
            METHOD = 1                                            '
         ELSE                                                     '
            METHOD = VERIFY(LTxtG(i), " ")                        ' Get the indent
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD InitaFile(quick AS LONG) AS LONG                     '
      '--------------------------------------------------------------------------------------------+
      '- Initialize file control stuff                                                             |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, FNum AS LONG, PName, MacName AS STRING, RCA AS RCArea '
         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Fudge CLIP SET EDIT and EFT EDIT modes                                                 |
         '-----------------------------------------------------------------------------------------+
         IF ISClipLoad THEN                                       ' Are we to load the clipboard?
            PName = "DEFAULT"                                     ' Set DEFAULT for special tabs
            IF IsDiff THEN                                        ' Set special Profiles
               PName = IIF$(gSQL.TableExist("PDiff"),    "DIFF",    "DEFAULT")   '
            ELSEIF IsEFTEdit THEN                                 '
               PName = IIF$(gSQL.TableExist("PEFTEdit"), "EFTEdit", "DEFAULT")   '
            ELSEIF IsSETEdit THEN                                 '
               PName = IIF$(gSQL.TableExist("PSETEdit"), "SETEdit", "DEFAULT")   '
            ELSEIF IsClip    THEN                                 '
               PName = IIF$(gSQL.TableExist("PClip"),    "CLIP",    "DEFAULT")   '
            END IF                                                '
            FCB.SetupProf(PName, RCA)                             ' Set the Profile
            IF RCA.RC <> 0 THEN METHOD = 8: MExitMeth             '
            me.PicSetWord                                         ' Say WORD has changed
            me.PicInit                                            ' Re-Initialize Picture control area
            ClipName = gENV.CLIPCmd                               ' Save the clipboard name
            gENV.ClipCmd = ""                                     ' Reset the clipboard name
            gENV.SetINITimeStamp                                  '
            me.ClrLoad                                            ' Go load Colorize data
            pCmdPASTE("PASTE " + $DQ + ClipName + $DQ)            '
            '--------------------------------------------------------------------------------------+
            '- Give clip tab some valid 'filename' data                                            |
            '--------------------------------------------------------------------------------------+
            IF IsClip THEN                                        ' CLIP?
               ClipFile = IIF$(ISNOTNULL(ClipName), gENV.Homedata + "CLIP\" + Clipname  + ".CLIP", GetTempFile("SPE"))   '
               IF ISNULL(ClipName) THEN                           ' Plain Clipboard?
                  FNum = FREEFILE                                 ' Get a file number
                  OPEN ClipFile FOR OUTPUT AS # FNum              ' Open it
                  FOR i = 1 TO LastLine                           ' Copy the data
                     IF ISFALSE IsLData(i) THEN ITERATE FOR       ' Skip non Data lines
                     PRINT # FNum, LTxtG(i)                       ' Write it
                  NEXT i                                          '
                  CLOSE # FNum                                    ' Close it
               END IF                                             '
               FCB.SetupFN(ClipFile, %ProfGetN, RCA)              ' Setup FCB names
            END IF                                                '
            me.LoadErrsDump                                       ' Dmp any errors
            OffModdFlag                                           '
            IF FCB.IMacro <> "" THEN                              ' Is there an IMacro?
               MacName = FCB.IMacro                               ' Get macro string
               IF UCASE$(MacName) = MacName THEN                  ' Is macroname Uppercase? (ON)
                  IF isMacro(MacName) THEN                        ' Does it exist?
                     me.pCmdMacro(MacName)                        ' Then go do it
                     DOCmdAdd("(Enter)")                          ' Force an (Enter)
                  ELSE                                            '
                     MErrExit(%eFail, "IMACRO - " + MacName + " not found")   ' Issue error
                  END IF                                          '
               END IF                                             '
            END IF                                                '
         ELSE                                                     '
            '--------------------------------------------------------------------------------------+
            '- We have a file to OPEN                                                              |
            '--------------------------------------------------------------------------------------+
            IF FCB.FilePath <> $New THEN                          ' Passed a filename?
               '-----------------------------------------------------------------------------------+
               '- Get file data loaded                                                             |
               '-----------------------------------------------------------------------------------+
               P1.PTopLine = 1: P2.PTopLine = 1                   ' N.B. May be overridden by StateLoad
               me.CopyAFile(1, 0, 0, 0, quick)                    ' Go load the data, MIX is always 1
               '-----------------------------------------------------------------------------------+
               '- Kill any prior watch                                                             |
               '-----------------------------------------------------------------------------------+
               i = me.FileWatch("", %WatchEnd)                    ' Kill any prior Watch

               '-----------------------------------------------------------------------------------+
               '- If not quick (i.e. FF command mode) start the File Watch                         |
               '-----------------------------------------------------------------------------------+
               IF ISFALSE quick THEN                              '
                  FileQueue("A", " ", TP.FCB_.FilePath)           ' Add to Open queue
                  IF me.FileWatch(TP.FCB_.FilePath, %WatchStart) THEN   ' Establish the watch
                     TP.ErrMsgAdd(0, "File watch could not be established")   '
                  END IF                                          '
               END IF                                             '
               OffModdFlag                                        ' Start off as not modified

               '-----------------------------------------------------------------------------------+
               '- If a MEDIT session we need a bit more work                                       |
               '-----------------------------------------------------------------------------------+
               IF IsMEdit THEN                                    ' Starting a MEdit session?
                  me.MeditTbl("A", TP.FCB_.FilePath)              ' Add to Medit table
                  me.LInsertLines(1, 1, %File)                    ' Insert for the =FILE> line
                  LMixS(2) = 1                                    ' Mark as File 1
                  me.LTxtSet(2, TP.FCB_.FilePath)                 ' Stuff filename in as the text
                  me.UpdLControl(2)                               ' Setup LLCtl
               END IF                                             '

            END IF                                                '
         END IF                                                   '

         SetCmd                                                   ' Cursor to Cmd line
         IF ISFALSE quick THEN                                    '
            OnUndoFlag                                            ' Take a 1st save checkpoint
            me.WindowTitle                                        ' Alter window/Tab titles
         END IF                                                   '
         DoStatusBar($AllStatusBarBoxes)                          ' re-Do the StatusBar box
         MExit                                                    '
      END METHOD                                                  '

      METHOD InsBounds(lno AS LONG)                               '
         me.LInsertLines(lno - 1, 1, %Bounds)                     ' Insert the requested line(s)
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.LTxtFree(lno)                                         ' Go free the normal dynamic string
         me.LTxt2Bnds(lno)                                        ' Point L.Txt to the Bnds data
         me.UpdLControl(lno)                                      ' Update the lineno area
      END METHOD                                                  '

      METHOD InsCols(lno AS LONG)                                 '
         me.LInsertLines(lno - 1, 1, %Cols)                       ' Insert a line
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.UpdLControl(lno)                                      ' Setup LLCtl
      END METHOD                                                  '

      METHOD InsMark(lno AS LONG)                                 '
         me.LInsertLines(lno - 1, 1, %Mark)                       ' Insert a line
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.LTxtFree(lno)                                         ' Go free the normal dynamic string
         me.LTxt2Mark(lno)                                        ' Point L.Txt to the Mark Data
         me.UpdLControl(lno)                                      ' Setup LLCtl
      END METHOD                                                  '

      METHOD InsMask(lno AS LONG)                                 '
         me.LInsertLines(lno - 1, 1, %Mask)                       ' Insert a line
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.LTxtFree(lno)                                         ' Go free the normal dynamic string
         me.LTxt2Mask(lno)                                        ' Point L.Txt to the Mark Data
         me.UpdLControl(lno)                                      ' Setup LLCtl
      END METHOD                                                  '

      METHOD InsProf(lno AS LONG, which AS LONG)                  '
         me.LInsertLines(lno - 1, 1, %Prof)                       ' Insert a line
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.LTxtFree(lno)                                         ' Go free the normal dynamic string
         SELECT CASE AS CONST which                               ' Point correct PROF line
            CASE 1: me.LTxt2Prof1(lno)                            '
            CASE 2: me.LTxt2Prof2(lno)                            '
            CASE 3: me.LTxt2Prof3(lno)                            '
            CASE 4: me.LTxt2Prof4(lno)                            '
            CASE 5: me.LTxt2Prof5(lno)                            '
            CASE 6: me.LTxt2Prof6(lno)                            '
         END SELECT                                               '
         me.UpdLControl(lno)                                      ' Setup LLCtl
      END METHOD                                                  '

      METHOD InsEFT(lno AS LONG)                                  '
         IF ISNULL(EFTOVList(0)) THEN EXIT METHOD                 ' Only if EFT was involved
         me.LInsertLines(lno - 1, 1, %EFT)                        ' Insert a line
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.LTxtFree(lno)                                         ' Go free the normal dynamic string
         me.LTxt2EFT1(lno)                                        '
         me.UpdLControl(lno)                                      ' Setup LLCtl
      END METHOD                                                  '

      METHOD InsTabs(lno AS LONG)                                 '
         me.LInsertLines(lno - 1, 1, %Tabs)                       ' Insert a line
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.LTxtFree(lno)                                         ' Go free the normal dynamic string
         me.LTxt2Tabs(lno)                                        ' Point L.Txt to the Tabs Data
         me.UpdLControl(lno)                                      ' Setup LLCtl
      END METHOD                                                  '

      METHOD InsWord(lno AS LONG)                                 '
         me.LInsertLines(lno - 1, 1, %Word)                       ' Insert a line
         me.AdjustPending(lno - 1, 1, 0)                          ' Adjust pending stuff
         me.LTxtFree(lno)                                         ' Go free the normal dynamic string
         me.LTxt2Word(lno)                                        ' Point L.Txt to the WORD Data
         me.UpdLControl(lno)                                      ' Setup LLCtl
      END METHOD                                                  '


      METHOD InsTblAdd(lno AS LONG)                               '
      REGISTER i AS LONG                                          '
         MEntry                                                   '
         INCR InsCount                                            ' Incr count
         IF InsCount > UBOUND(InsTbl()) THEN _                    ' Keep table big enough
            REDIM PRESERVE InsTbl(1 TO InsCount + 500) AS GLOBAL LONG   '
         InsTbl(InsCount) = lno                                   ' Save Insert Line
         FOR i = 1 TO InsCount                                    ' Adjust if a new insert lower than existing
            IF InsTbl(i) > lno THEN INCR InsTbl(i)                '
         NEXT i                                                   '
         MExit                                                    '
      END METHOD                                                  '


      METHOD LAttrGet (ix AS LONG) AS WSTRING: METHOD = L(ix).@LAttr: END METHOD '
      METHOD LAttrLen (ix AS LONG) AS LONG: METHOD = LEN(L(ix).@LAttr): END METHOD  '
      METHOD LAttrPtr (ix AS LONG) AS LONG: METHOD = L(ix).LAttr: END METHOD  '

      METHOD LAttrSet (BYVAL ix AS LONG, vl AS WSTRING)           '
         L(ix).@LAttr = vl                                        '
      END METHOD                                                  '

      METHOD LAttrAdjust(ix AS LONG, icol AS LONG, iamt AS LONG)  '
      LOCAL ichr, iOld, oldAttr AS WSTRING                        '
         oldAttr = L(ix).@LAttr                                   ' Get old Attr string
         IF iCol > LEN(oldAttr) THEN oldAttr = LSET$(oldAttr, icol USING CHR$$(0))  ' Lengthen if needed
         iOld = MID$(oldAttr, icol, 1)                            ' Get char at insert position
         IF iamt > 0 THEN                                         ' Doing an insert
            ichr = REPEAT$(iamt, iOld)                            ' Get insert string
            L(ix).@LAttr = STRINSERT$(oldAttr, ichr, icol)        '
         ELSE                                                     ' Doing a delete
            L(ix).@LAttr = STRDELETE$(oldAttr, icol, ABS(iamt))   ' Remove characters
         END IF                                                   '
      END METHOD                                                  '

      METHOD LTrakGet (ix AS LONG) AS LONG: METHOD = L(ix).LTrak: END METHOD  '
      METHOD LTrakSet (ix AS LONG, vl AS LONG): L(ix).LTrak = vl: END METHOD  '
      METHOD LFlagGet (ix AS LONG) AS LONG: METHOD = L(ix).LFlag: END METHOD  '
      METHOD LWrk2Get (ix AS LONG) AS LONG: METHOD = L(ix).LWrk2: END METHOD  '
      METHOD LHndlGet (ix AS LONG) AS LONG: METHOD = L(ix).LHndl: END METHOD  '
      METHOD LHndlSet (ix AS LONG, vl AS LONG): L(ix).LHndl = vl: END METHOD  '
      METHOD LLblGet (ix AS LONG) AS STRING: METHOD = L(ix).LLbl: END METHOD  '
      METHOD LLblSet (ix AS LONG, vl AS STRING): L(ix).LLbl = vl: END METHOD  '
      METHOD LLCtlGet (ix AS LONG) AS STRING: METHOD = L(ix).LLCtl: END METHOD   '
      METHOD LLCtlSet (ix AS LONG, vl AS STRING): L(ix).LLCtl = vl: END METHOD   '
      METHOD LLCtlTagSet(ix AS LONG)                              '
       IF L(ix).LTag <> $BlankLNo THEN L(ix).LLCtl = L(ix).LTag   '
        END METHOD                                                '
      METHOD LLCtlLblSet(ix AS LONG)                              '
       IF L(ix).LLbl <> $BlankLNo THEN L(ix).LLCtl = L(ix).LLbl   '
        END METHOD                                                '
      METHOD LLNumGet (ix AS LONG) AS STRING: METHOD = IIF$(ISTRUE (L(ix).LFlag AND %Data), L(ix).LLNum, "00000000"): END METHOD '
      METHOD LMIXGet (ix AS LONG) AS LONG: METHOD = L(ix).LMix: END METHOD '
      METHOD LMIXSet (ix AS LONG, vl AS LONG): L(ix).LMix = vl: END METHOD '
      METHOD LWrk1Get (ix AS LONG) AS LONG: METHOD = L(ix).LWrk1: END METHOD  '

      METHOD  LStubDelRange(lfrom AS LONG, lto AS LONG)           '
      '--------------------------------------------------------------------------------------------+
      '- Delete a range of lines                                                                   |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
         MEntry                                                   '
         IF IsSlecSet THEN                                        ' Need we check Slec line range?
            IF (lfrom >= me.LineNoRef(FORMAT$(SlecSLin)) AND lfrom <= me.LineNoRef(FORMAT$(SlecELin))) OR _ '
               (lto   >= me.LineNoRef(FORMAT$(SlecSLin)) AND lto   <= me.LineNoRef(FORMAT$(SlecELin))) THEN '
               OffSlecSet                                         ' Clear Slec status
               OffSlecActive                                      '
               DoStatusBar($SBSelect)                             ' re-Do the StatusBar Select box
               me.MarkKill                                        ' Reset the select frame
            END IF                                                '
         END IF                                                   '
         FOR i = lfrom TO lto                                     ' Loop for each deleted line
            DECR LastLine                                         ' Adjust Last Line
            IF IsLData(i) THEN DECR LastReal                      ' If Data, Adjust LastReal
            me.lTxtFree(i)                                        ' Go free the dynamic string
         NEXT i                                                   '
         me.LEntDelRange(lfrom, lto - lfrom +1)                   ' Remove from the L() array
         MExit                                                    '
      END METHOD                                                  '

      METHOD  lStubDoPM(flag AS LONG, lno AS LONG)                '
      '--------------------------------------------------------------------------------------------+
      '- Do +/- processing for a line                                                              |
      '--------------------------------------------------------------------------------------------+
         MEntry                                                   '
         IF BIT(flag, %lCmdX) THEN                                ' Do the +/- processing for the line
            IF ISFALSE IsLFile(lno) THEN me.LFlagBitOn(lno, %Invisible) ' If - make Invisible (except =FILE> lines)
            gfXRebuild = %True                                    ' Force exclude rebuild

         ELSEIF BIT(flag, %lCmdNX) THEN                           '
            me.LFlagBitOff(lno, %Invisible)                       ' If + make visible
            gfXRebuild = %True                                    ' Force exclude rebuild
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD LTagGet (BYVAL ix AS LONG) AS STRING: METHOD = L(ix).LTag: END METHOD  '

      METHOD LTblSize(needed AS LONG)                             '
      '--------------------------------------------------------------------------------------------+
      '- Expand T() and TW() if running out of room                                                |
      '--------------------------------------------------------------------------------------------+
      REGISTER x AS LONG                                          '
      REGISTER y AS LONG                                          '
         IF needed  > TTCtr  THEN                                 ' If running out of room in T() make it bigger
            y = MAX(2 * UBOUNDT, needed + 25000)                  ' Calc how many we're adding
            REDIM PRESERVE T(UBOUNDT + y) AS INSTANCE STRING      ' Get room for another bunch of lines in T() array
            REDIM PRESERVE TW(UBOUNDT + y) AS INSTANCE WSTRING    ' Ditto for TW()
            me.BStackGrow(y)                                      ' And the Buffer Stack
            TTCtr += y                                            ' Add to Free count
            FOR x = 1 TO UBOUND(L)                                ' Correct the @LTxt pointers in the L() array
               IF IsLData(x) THEN                                 ' If a Data line
                  IF L(x).LTxt <> 0 THEN                          ' Got a TXT pointer?
                     L(x).LTxt = VARPTR(T(L(x).LTxtIX))           ' Correct using the saved TxtIX value
                  END IF                                          '
                  IF L(x).LAttr <> 0 THEN                         ' Got an Attr pointer?
                     L(x).LAttr = VARPTR(TW(L(x).LAttrIX))        ' Correct using the saved AttrIX value
                  END IF                                          '
               END IF                                             '
            NEXT x                                                '
            UBoundT += y                                          ' Save new UBound value
         END IF                                                   '
      END METHOD                                                  '

      METHOD LTxtGet (BYVAL ix AS LONG) AS STRING: METHOD = L(ix).@LTxt: END METHOD '
      METHOD LTxtSet (BYVAL ix AS LONG, vl AS STRING)             '
      LOCAL t AS STRING, i AS LONG                                '
         IF FCB.MINLEN > 0 AND LEN(vl) < FCB.MINLEN THEN          '
            t = LSET$(vl, FCB.MINLEN)                             '
            L(ix).@LTxt = t                                       '
         ELSE                                                     '
            L(ix).@LTxt = vl                                      '
         END IF                                                   '
         MaxLength = MAX(MaxLength, LEN(L(ix).@LTxt))             ' Track MaxLength
      END METHOD                                                  '
      METHOD LFlagData (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Data): END METHOD   '
      METHOD LFlagTop (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Top): END METHOD  '
      METHOD LFlagBottom (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Bottom): END METHOD  '
      METHOD LFlagWord (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Word): END METHOD   '
      METHOD LFlagTabs (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Tabs): END METHOD   '
      METHOD LFlagBounds (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Bounds): END METHOD  '
      METHOD LFlagCols (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Cols): END METHOD   '
      METHOD LFlagXclude (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Xclude): END METHOD  '
      METHOD LFlagInvisible (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Invisible): END METHOD  '
      METHOD LFlagMark (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Mark): END METHOD   '
      METHOD LFlagMask (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Mask): END METHOD   '
      METHOD LFlagNote (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Note): END METHOD   '
      METHOD LFlagProf (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Prof): END METHOD   '
      METHOD LFlagEFT  (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %EFT) : END METHOD   '
      METHOD LFlagUser (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %User): END METHOD   '
      METHOD LFlagPage (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %Page): END METHOD   '
      METHOD LFlagFile (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE (L(ix).LFlag AND %File): END METHOD   '
      METHOD LFlagBitOn (BYVAL ix AS LONG, vl AS LONG): L(ix).LFlag = (L(ix).LFlag OR VL): END METHOD '
      METHOD LFlagBitOff (BYVAL ix AS LONG, vl AS LONG): L(ix).LFlag = (L(ix).LFlag AND (&HFFFFFFFF - vl)): END METHOD  '
      METHOD LFlagBitTog (BYVAL ix AS LONG, vl AS LONG): L(ix).LFlag = (L(ix).LFlag XOR vl): END METHOD  '

      METHOD LTxtCharDel (BYVAL ix AS LONG, posit AS LONG)        '
         LOCAL t AS STRING POINTER: t = LTxtGP(ix)                '
         LOCAL tw AS WSTRING POINTER: tw = LAttrGP(ix)            '
         L(ix).@LTxt = STRDELETE$(@t, posit, 1)                   '
         L(ix).@LAttr = STRDELETE$(@tw, posit, 1)                 '
         IF FCB.MINLEN > 0 AND FCB.MINLEN > LEN(@t) THEN          ' Apply MINLEN
            L(ix).@LTxt = LSET$(@t, FCB.MINLEN)                   '
            L(ix).@LAttr = LSET$(@tw, FCB.MINLEN USING CHR$$(0))  '
         END IF                                                   '
      END METHOD                                                  '
      METHOD LTxtCharRep (BYVAL ix AS LONG, posit AS LONG, char AS STRING): MID$(L(ix).@LTxt, posit, 1) = char: END METHOD '
      METHOD LTxtLen (BYVAL ix AS LONG) AS LONG: METHOD = LEN(L(ix).@LTxt): END METHOD '
      METHOD LTxt2Bnds (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(BndText): END METHOD '
      METHOD LTxt2Mark (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(MarkLine): END METHOD   '
      METHOD LTxt2Mask (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(MaskLine): END METHOD   '
      METHOD LTxt2Prof1 (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(Prof1): END METHOD  '
      METHOD LTxt2Prof2 (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(Prof2): END METHOD  '
      METHOD LTxt2Prof3 (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(Prof3): END METHOD  '
      METHOD LTxt2Prof4 (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(Prof4): END METHOD  '
      METHOD LTxt2Prof5 (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(Prof5): END METHOD  '
      METHOD LTxt2Prof6 (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(Prof6): END METHOD  '
      METHOD LTxt2EFT1  (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(EFT1): END METHOD   '
      METHOD LTxt2Word (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(WordInput): END METHOD  '
      METHOD LTxt2Tabs (BYVAL ix AS LONG): L(ix).LTxt = VARPTR(TabsLine): END METHOD   '
      METHOD LEntDel (BYVAL ix AS LONG)                           '
      REGISTER i AS LONG                                          '
         i = UBOUND(L())                                          ' Point at last entry
         ARRAY DELETE L(ix)                                       ' Delete the entry
         OnRenumFlag                                              ' Call for renum
         L(i).LTxt = 0                                            ' Reset the last entry
         L(i).LTxtIX = 0                                          '
         L(i).LAttr = 0                                           '
         L(i).LAttrIX = 0                                         '
         L(i).LFlag = 0                                           '
         L(i).LCol = 0                                            '
         L(i).LHndl = 0                                           '
         L(i).LTrak = 0                                           '
         L(i).LLCtl = $BlankLNo                                   '
         L(i).LLNum = $BlankLNo                                   '
         L(i).LLbl = $BlankLNo                                    '
      END METHOD                                                  '

      METHOD LEntDelRange (BYVAL ix AS LONG, cnt AS LONG)         '
      REGISTER i AS LONG                                          '

         MEMORY COPY VARPTR(L(ix + cnt)), VARPTR(L(ix)), SIZEOF(DataLine) * (UBoundL - ix - cnt + 1)  '

         FOR i = UBoundL - cnt + 1 TO UBoundL                     ' Pad the entries at the end
            L(i).LTxt = 0                                         '
            L(i).LTxtIX = 0                                       '
            L(i).LAttr = 0                                        '
            L(i).LAttrIX = 0                                      '
            L(i).LFlag = 0                                        '
            L(i).LCol = 0                                         '
            L(i).LHndl = 0                                        '
            L(i).LTrak = 0                                        '
            L(i).LLCtl = $BlankLNo                                '
            L(i).LLNum = $BlankLNo                                '
            L(i).LLbl = $BlankLNo                                 '
         NEXT i                                                   '
         LCtr += cnt                                              ' Add back to available L() count
         OnRenumFlag                                              '
      END METHOD                                                  '

      METHOD LLCtlCharRep (BYVAL ix AS LONG, posit AS LONG, char AS STRING)   '
         MID$(L(ix).LLCtl, posit, 1) = char                       '
      END METHOD                                                  '

      METHOD LLCtlScan (key AS STRING) AS LONG                    '
         LOCAL k AS LONG                                          '
         ARRAY SCAN L(), FROM 1 TO 8, COLLATE UCASE, = LSET$(key, 8), TO k '
         METHOD = k                                               '
      END METHOD                                                  '

      METHOD LLHndlScan (BYVAL key AS STRING * 4) AS LONG         '
         LOCAL k AS LONG                                          '
         ARRAY SCAN L(), FROM 33 TO 36, = key, TO k               '
         METHOD = k                                               '
      END METHOD                                                  '

      METHOD LLTrakScan (BYVAL key AS STRING * 4) AS LONG         '
         LOCAL k AS LONG                                          '
         ARRAY SCAN L(), FROM 37 TO 40, = key, TO k               '
         METHOD = k                                               '
      END METHOD                                                  '

      METHOD LLNumScan (BYVAL key AS STRING) AS LONG              '
      LOCAL x, y AS STRING                                        '
         LOCAL k AS LONG                                          '
         LOCAL i AS LONG                                          '
         ARRAY SCAN L(), FROM 9 TO 16, = LSET$(key, 8), TO k      '
         METHOD = k                                               '
         x = L(2).LLNum: y = L(2).@LTxt                           '
      END METHOD                                                  '

      METHOD LEntXPop (BYVAL ix AS LONG, cnt AS LONG)             '
         LOCAL i, j AS LONG, tmp AS DataLine                      '
         MEntry                                                   '
         L(ix).LWrk1 = L(ix).LWrk1 - i                            ' Adjust # in reduced range
         tmp = L(ix)                                              ' Save the XX marker line
         ARRAY DELETE L(ix)                                       ' Delete the XX marker line from its old location
         FOR j = ix TO ix + cnt - 1                               ' Un-'hide' the lines in the range
            L(j).LFlag = (L(j).LFlag AND (&HFFFFFFFF - %Invisible))  '
            L(j).LWrk1 = 0                                        ' Reset work field
         NEXT j                                                   '
         ARRAY INSERT L(ix + cnt), tmp                            ' Stuff saved XX marker back in
         FOR j = 1 TO tmp.LWrk1                                   ' Redo Work numbers in the new range
            L(ix + j + cnt).LWrk1 = j                             '
         NEXT j                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD LLTagScan (BYVAL key AS STRING) AS LONG              '
         LOCAL k AS LONG, lkey AS STRING * 8                      '
         MEntry                                                   '
         lkey = key                                               '
         IF lkey = ":Z      " OR lkey = ":ZF     " OR lkey = ":ZNF    " THEN  '
            METHOD = 1                                            '
            MexitMeth                                             '
         END IF                                                   '
         ARRAY SCAN L(), FROM 25 TO 32, COLLATE UCASE, = lkey, TO k  '
         METHOD = k                                               '
         MExit                                                    '
      END METHOD                                                  '

      METHOD LTxtFree(IX AS LONG)                                 '
         '-----------------------------------------------------------------------------------------+
         '- Free up T() line from the main L() entry                                               |
         '-----------------------------------------------------------------------------------------+
         LOCAL i AS LONG                                          '
         MEntry                                                   '
         IF ISTRUE (L(IX).LFlag AND (%Tabs OR %Mark OR %Mask OR %Prof OR %Word OR %Bounds OR %EFT)) THEN '
            i = (L(IX).LFlag AND (%Tabs OR %Mark OR %Mask OR %Word OR %Bounds))  'Isolate the flags
            SELECT CASE AS LONG i                                 ' Don't process changes for deleted lines
               CASE %Tabs:   OffTabsAFlag                         '
               CASE %Mark:   OffMarkAFlag                         '
               CASE %Mask:   OffMaskAFlag                         '
               CASE %Word:   OffWordAFlag                         '
               CASE %Bounds: OffBndsAFlag                         '
            END SELECT                                            '
            MExitMeth                                             ' Don't do this for 'special' lines
         END IF                                                   '
         me.BStackFree(L(IX).LTxtIX)                              ' Mark slot available
         L(IX).@LTxt = ""                                         ' Null the text string
         L(IX).LTxt = 0                                           ' Kill the pointer
         L(IX).LTxtIX = 0                                         ' Kill the IX value
         L(IX).@LAttr = ""                                        ' Null the Attr string
         L(IX).LAttr = 0                                          ' Kill the pointer
         L(IX).LAttrIX = 0                                        ' Kill the IX value
         MExit                                                    '
      END METHOD                                                  '

      METHOD LTxtSpecFree(IX AS LONG)                             '
         '-----------------------------------------------------------------------------------------+
         '- Free up T() line from the main L() entry                                               |
         '-----------------------------------------------------------------------------------------+
         MEntry                                                   '
         me.BStackFree(L(IX).LTxtIX)                              ' Mark slot available
         L(IX).@LTxt = ""                                         ' Null the text string
         L(IX).LTxt = 0                                           ' Kill the pointer
         L(IX).LTxtIX = 0                                         ' Kill the IX value
         MExit                                                    '
      END METHOD                                                  '

      METHOD LTxtAlloc(DataIX AS LONG)                            '
      '--------------------------------------------------------------------------------------------+
      '- Allocate a T() and TW() line to the main L() entry                                        |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
         MEntry                                                   '
         me.LTblSize(5)                                           ' Ensure enough room in text table

         i = me.BStackAlloc                                       ' Alloc a buffer
         T(i) = "": TW(i) = ""                                    ' Null the strings
         L(DataIX).LTxtIX = i                                     ' Remember the index in the L() entry
         L(DataIX).LTxt = VARPTR(T(i))                            ' Point L.LTxt to the dynamic String
         L(DataIX).LAttrIX = i                                    ' Remember the index in the L() entry
         L(DataIX).LAttr = VARPTR(TW(i))                          ' Point L.LAttr to the dynamic String
         MExit                                                    '
      END METHOD                                                  '

      METHOD LTxtSort (RCA AS RCArea) AS STRING                   '
      '--------------------------------------------------------------------------------------------+
      '- SORT the data                                                                             |
      '--------------------------------------------------------------------------------------------+
      DIM SCmd(1 TO 5) AS SortCtl                                 '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL k, s, x, y, NumKey AS LONG, LData, Oprand, StrStart, StrEnd AS STRING   '
      LOCAL t, cstring, lkey AS STRING, DidSort, Uniq, MarkU, delcount, basekey AS LONG   '
      LOCAL LUndo AS UNDOType POINTER                             ' Pointer to the UNDO Data
         FOR i = 1 TO 5                                           ' Init the sort key
            sCmd(i).AorD = " ": sCmd(i).CASE = FCB.CaseFlag       '
            sCmd(i).sFrom = 0: sCmd(i).sTo = 0                    '
         NEXT i                                                   '
         IF PTBL.OpsNum = 0 THEN SCmd(1).AorD = "A": SCmd(1).sFrom = 1: SCmd(1).sTo = MaxLength ' Setup a default key
         FOR i = 0 TO 255                                         ' Build collate string
            cstring += CHR$(i)                                    '
         NEXT                                                     '
         IF FCB.SrceXlate OR FCB.ColateXlate THEN                 ' In non-ANSI
            me.Translate(cstring, FCB.GetCA2SPtr)                 ' If needed
         END IF                                                   '
         i = 1                                                    ' Start Cmd table index at 1
         PTBL.FlgFirst = %True                                    ' Ensure we start at the top row

         FOR j = 1 TO PTBL.OpsNum                                 ' Process the remaining operands
            Oprand = uucase(PTBL.Ops(j))                          ' Get an UC version
            IF LEFT$(Oprand, 1) = "." OR LEFT$(Oprand, 1) = "!" THEN ' Line range?
               '-----------------------------------------------------------------------------------+
               '- Line range, we have to do our own parse                                          |
               '-----------------------------------------------------------------------------------+
               s = 0                                              ' See if different optypes present
               IF PTBL.GotDotd THEN INCR s                        '
               IF PTBL.GotLPtr THEN INCR s                        '
               IF s > 1 THEN AnswerMeth(8, "Mixed line pointer types are present")  '

               IF PTBL.GotDotd THEN                               ' And we have some
                  SELECT CASE PTBL.GotDotd                        ' How many
                     CASE 1: StrStart = PTBL.Pos(".", 1): StrEnd = ""   '
                     CASE 2: StrStart = PTBL.Pos(".", 1): StrEnd = PTBL.Pos(".", 2) '
                  END SELECT                                      '
               END IF                                             '

               IF PTBL.GotLPtr THEN                               ' We have some LPtrs
                  SELECT CASE PTBL.GotLPtr                        ' How many
                     CASE 1: StrStart = PTBL.Pos("!", 1): StrEnd = ""   '
                     CASE 2: StrStart = PTBL.Pos("!", 1): StrEnd = PTBL.Pos("!", 2) '
                  END SELECT                                      '
               END IF                                             '

               IF ISNOTNULL(StrStart) AND ISNULL(StrEnd) THEN     ' Just one operand
                  PTBL.FindRngStart = TP.LineNoRef(StrStart)      ' Yes, set 1st as start
                  IF PTBL.FindRngStart = -1 THEN _                ' An Oops?
                     AnswerMeth(8, "Line reference " + StrStart + " is undefined")  '
                  PTBL.FindRngEnd = 0                             ' End = 0 to say not there
                  PTBL.FindRngSet = %True                         ' Say we're OK
               ELSEIF ISNOTNULL(StrStart) AND ISNOTNULL(StrEnd) THEN ' Both?
                  PTBL.FindRngStart = TP.LineNoRef(StrStart)      ' Yes, set 1st as start
                  IF PTBL.FindRngStart = -1 THEN _                ' An Oops?
                     AnswerMeth(8, "Line reference " + StrStart + " is undefined")  '
                  PTBL.FindRngEnd = TP.LineNoRef(StrEnd)          ' Yes, set 2nd as end
                  IF PTBL.FindRngEnd = -1 THEN _                  ' An Oops?
                     AnswerMeth(8, "Line reference " + StrEnd + " is undefined") '
                  IF PTBL.FindRngStart > PTBL.FindRngEnd THEN     ' Look for the simple out of order swap
                     s = PTBL.FindRngStart                        '
                     PTBL.FindRngStart = PTBL.FindRngEnd          '
                     PTBL.FindRngEnd = s                          '
                  END IF                                          '
                  PTBL.FindRngSet = %True                         ' Say we're OK
               END IF                                             '
               ITERATE FOR                                        ' Done this operand
            END IF                                                '

            IF VAL(Oprand) > 0 THEN                               ' We got a #, see where to put it
               IF SCmd(i).sFrom = 0 THEN                          ' Haven't got From yet
                  SCmd(i).sFrom = VAL(Oprand)                     ' Now we do
               ELSEIF SCmd(i).sTo = 0 THEN                        ' If no To
                  SCmd(i).sTo = VAL(Oprand)                       ' Now we have a To
               ELSEIF i = 5 THEN                                  ' At our max?
                  AnswerMeth(8, "Excessive SORT operands")        ' Pass back error message
               ELSE                                               '
                  IF SCmd(i).AorD = " " THEN SCmd(i).AorD = "A"   ' Assign direction if not already done
                  INCR i                                          ' Bump
                  SCmd(i).sFrom = VAL(Oprand)                     ' assign this as the From value
               END IF                                             '
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "UNIQ" THEN                               ' UNIQ?
               uniq = %True                                       ' Add the flag
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "MARKUNIQ" THEN                           ' MARKUNIQ?
               MarkU = %True                                      ' Add the flag
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "X" THEN                                  ' X?
               PTBL.FlgX = %True                                  ' Add the flag
               PTBL.FindRngSet = %True                            ' Force RangeVal
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "NX" THEN                                 ' NX?
               PTBL.FlgNX = %True                                 ' Add the flag
               PTBL.FindRngSet = %True                            ' Force RangeVal
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "U" THEN                                  ' U?
               PTBL.FlgU = %True                                  ' Add the flag
               PTBL.FindRngSet = %True                            ' Force RangeVal
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "NU" THEN                                 ' NU?
               PTBL.FlgNU = %True                                 ' Add the flag
               PTBL.FindRngSet = %True                            ' Force RangeVal
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "DX" THEN                                 ' DX?
               PTBL.FlgDX = %True                                 ' Add the flag
               ITERATE FOR                                        '
            END IF                                                '

            IF Oprand = "MX" THEN                                 ' X?
               PTBL.FlgMX = %True                                 ' Add the flag
               ITERATE FOR                                        '
            END IF                                                '

            SELECT CASE LEFT$(Oprand, 1)                          ' See if a direction/case operand
               CASE "A", "D"                                      ' A direction?
                  IF SCmd(i).AorD = " " THEN                      ' Save direction if not yet set
                     SCmd(i).AorD = LEFT$(Oprand, 1)              '
                     GOSUB Do2ndOper                              ' Go handle 2nd oper
                  ELSEIF SCmd(i).sFrom <> 0 AND SCmd(i).sTo <> 0 THEN   '
                     IF i = 5 THEN                                ' At max?
                        AnswerMeth(8, "Excessive SORT operands")  ' Pass back error
                     ELSE                                         '
                        INCR i                                    ' Bump to next slot
                        SCmd(i).AorD = LEFT$(Oprand, 1)           '
                        GOSUB Do2ndOper                           ' Go handle 2nd oper
                     END IF                                       '
                  ELSE                                            '
                     AnswerMeth(8, "Illogical SORT operands")     ' Pass back message
                  END IF                                          '

               CASE "T", "C"                                      '
                  IF LEN(Oprand) > 1 THEN                         ' Alone?
                     AnswerMeth(8, "Invalid SORT operands")       ' Pass back message
                  END IF                                          '
                  SCmd(i).CASE = LEFT$(Oprand, 1)                 ' Save Case

               CASE ELSE                                          '
                  AnswerMeth(8, "Invalid SORT operands")          ' Pass back error
            END SELECT                                            '
         NEXT j                                                   '

         '--------------------------------------------------------------------------------+
         '- Last chance, see if a marked line range                                       |
         '--------------------------------------------------------------------------------+
         IF ISNULL(StrStart) AND ISNULL(StrEnd) THEN              ' If no line range yet
            IF ISTRUE gLTblRange THEN                             ' And a line range present
               PTBL.FindRngLCtl = TRIM$(gLTblSCmd)                ' Save C / M line mode
               PTBL.FindRngStart = gLTblSFrom                     ' Something there set it up
               PTBL.FindRngEnd = gLTblSTo                         '
               TP.TTblDel(gLTblSFrom)                             ' Remove from Touched lines
               TP.UpdLControl(gLTblSFrom)                         ' Clear from the line
               TP.TTblDel(gLTblSTo)                               ' Remove from Touched lines
               TP.UpdLControl(gLTblSTo)                           ' Clear from the line
               PTBL.FindRngSet = %True                            '
               PTBL.FindRngFlag = gLTblSFlag                      '
            END IF                                                '
         END IF                                                   '

         IF ISTRUE MarkU AND ISTRUE Uniq THEN                     ' Can't do both MarkU and Uniq
            AnswerMeth(8, "Cannot use MARKUNIQ and UNIQ together")   ' Pass back error
         END IF                                                   '
         NumKey = i                                               '

         IF PTBL.FlgX AND PTBL.FlgNX THEN _                       '
            AnswerMeth(8, "Both X and NX not allowed on the SORT command.")   '
         IF PTBL.FlgMX AND PTBL.FlgDX THEN _                      '
            AnswerMeth(8, "Both MX and DX not allowed on the SORT command.")  '

         FOR i = 1 TO NumKey                                      ' Validate entries

            IF SCmd(i).AorD = " " THEN SCmd(i).AorD = "A"         ' Set default direction
            IF SCmd(i).sFrom = 0 AND SCmd(i).sTo = 0 THEN         ' JUST the direction?
               sCmd(i).sFrom = 1: sCmd(i).sTo = MaxLength         ' then use defaults
            END IF                                                '
            IF SCmd(i).sFrom <> 0 AND SCmd(i).sTo = 0 THEN SCmd(i).sTo = MaxLength  '
            IF SCmd(i).sFrom = 0 OR SCmd(i).sTo = 0 THEN          ' Better be no zeros
               AnswerMeth(8, "Illogical SORT operands")           ' Pass back error msg
            END IF                                                '
            IF (SCmd(i).sFrom > SCmd(i).sTo AND SCmd(i).sTo <> 0) THEN  ' From GT To ?
               AnswerMeth(8, "Illogical SORT operands")           ' Pass back error
            END IF                                                '
         NEXT i                                                   '

         REDIM sKey(LastLine) AS STRING                           ' Get the SORT arrays
         REDIM sKey2(LastLine) AS STRING                          '
         REDIM STxt(LastLine) AS STRING                           '
         REDIM CTxt(LastLine) AS WSTRING                          '
         REDIM SLins(LastLine) AS LONG                            '
         REDIM DLins(LastLine) AS LONG                            '

         i = me.Search(0, %CBad)                                  ' Do the initial search
         IF i THEN GOSUB DoTblAdd                                 ' If found, add to tables
         DO WHILE i                                               ' Do till not found
            i = me.Search(1, %CBad)                               ' Do re-Finds
            IF i THEN GOSUB DoTblAdd                              ' If found, add to tables
         LOOP                                                     '

         IF (FCB.SrceXlate OR FCB.ColateXlate) AND ISFALSE uniq THEN ' If Non-ANSI, or UNIQ don't do check
            FOR i = 0 TO y - 2                                    ' See if already in order
               IF LEFT$(sKey(i), basekey) > LEFT$(sKey(i + 1), basekey) THEN DidSort = %True: EXIT FOR   '
            NEXT i                                                '
         ELSE                                                     '
            DidSort = %True                                       ' Say to do SORT
         END IF                                                   '

         IF DidSort THEN                                          ' Out of order, do the sort
            ARRAY SORT sKey() FOR y, COLLATE cstring, TAGARRAY STxt()   ' Do the sort
            ARRAY SORT sKey2() FOR y, COLLATE cstring, TAGARRAY CTxt()  ' Do the sort of the Clr records

            lkey = ""                                             ' Reset last key
            FOR i = 0 TO y - 1                                    ' Put the lines back now
               LFOff(Slins(i), %User)                             ' Reset the user flag
               IF LEFT$(STxt(i), 1) = "T" THEN LFOn(Slins(i), %User) ' Reset the user flag
               L(SLins(i)).LLbl = MID$(STxt(i), 2, 8)             ' The LBL
               L(SLins(i)).LTag = MID$(STxt(i), 10, 8)            ' and the Tag
               L(SLins(i)).LHndl = VAL(MID$(STxt(i), 18, 8))      ' and the Handle
               L(SLins(i)).LTrak = VAL(MID$(STxt(i), 26, 8))      ' and the Track
               L(SLins(i)).@LTxt = MID$(STxt(i), 34)              '
               L(SLins(i)).@LAttr = CTxt(i)                       ' Put back Attr
               me.ModSet(SLins(i))                                ' Remember we changed something
               IF MarkU THEN                                      ' If MarkU mode
                  me.LFlagBitOn(SLins(i), %User)                  ' Start by setting USER on all lines
                  IF LEFT$(sKey(i), basekey) <> lkey THEN         ' Different key as last one?
                     lkey = LEFT$(sKey(i), basekey)               ' Yes? save the new key
                     INCR delcount                                ' Count as a uniq item
                  ELSE                                            ' Same key
                     DECR delcount                                ' Previous line is no longer unique
                     me.LFlagBitOff(SLins(i - 1), %User)          ' Remove User from it
                     me.LFlagBitOff(SLins(i), %User)              ' And also from this line
                  END IF                                          '

               ELSEIF uniq THEN                                   ' Do some extra stuff for UNIQ
                  IF LEFT$(sKey(i), basekey) <> lkey THEN         ' Different key as last one?
                     lkey = LEFT$(sKey(i), basekey)               ' No? save the new key
                  ELSE                                            ' Same key!
                     dLins(delcount) = sLins(i)                   ' Mark line to be deleted
                     INCR delcount                                ' Count it
                  END IF                                          '
               END IF                                             '
            NEXT i                                                '
         END IF                                                   '

         IF ISTRUE uniq AND delcount > 0 THEN                     ' Do we have lines to delete?
            ARRAY SORT dLins() FOR delcount, DESCEND              ' Sort in descending order
            FOR i = 0 TO delcount - 1                             ' Delete the lines now
               me.lTxtFree(dLins(i))                              ' Go free the dynamic string
               me.LEntDel(dLins(i))                               ' Remove from the L() array
               DECR LastLine: DECR LastReal                       ' Adjust Last Line
            NEXT i                                                '
         END IF                                                   '
         REDIM sKey()                                             ' Free the Temp arrays
         REDIM sKey2()                                            '
         REDIM sTxt()                                             '
         REDIM cTxt()                                             '
         REDIM sLins()                                            '
         REDIM dLins()                                            '
         IF uniq THEN                                             ' UNIQ request?
            IF delcount > 0 THEN                                  '
               AnswerMeth(0, "SORT Complete, " + FORMAT$(delcount) + " non-Uniq lines deleted") ' Say all is well
            ELSE                                                  '
               AnswerMeth(0, "SORT Complete, all lines are unique")  ' Say all is well
            END IF                                                '
         ELSEIF MarkU THEN                                        ' If MarkU mode
            IF delcount > 0 THEN                                  '
               AnswerMeth(0, "SORT Complete, " + FORMAT$(delcount) + " Uniq lines marked as USER lines") '
            ELSE                                                  '
               AnswerMeth(0, "SORT Complete, all lines are unique and marked as USER lines") '
            END IF                                                '
         ELSE                                                     '
            AnswerMeth(0, "SORT Complete" + IIF$(DidSort, "", ", already sorted"))  ' Say all is well
         END IF                                                   '
         EXIT METHOD                                              '

         DoTblAdd:                                                ' Add a sort item
            x = PTBL.FoundLine                                    ' Get the line number
            sKey(y) = ""                                          ' Init key to null
            FOR k = 1 TO NumKey                                   ' Build the sort key

               j = SCmd(k).sTo - SCmd(k).sFrom + 1                ' Length of this Key
               t = LSET$(MID$(L(x).@ltxt, SCmd(k).sFrom, j), j)   '
               IF SCmd(k).CASE = "T" THEN t = UUCASE(t)           ' If CASE=T, uppercase it
               IF SCmd(k).AorD = "D" THEN                         ' Descending?
                  IF FCB.SrceXlate OR FCB.ColateXlate THEN        '
                     '-----------------------------------------------------------------------------+
                     '- Perform EBCDIC/non-ANSI invert of key if descending                       |
                     '-----------------------------------------------------------------------------+
                     me.Translate(t, FCB.GetCA2SPtr)              ' Translate around the Invert
                     t = StrInvert(t)                             ' Invert it
                     me.Translate(t, FCB.GetCS2APtr)              ' Translate back
                  ELSE                                            '
                     t = StrInvert(t)                             ' Perform ANSI invert of key if descending
                  END IF                                          '
               END IF                                             '
               sKey(y) += t                                       ' Add to key
             NEXT k                                               '
'-           basekey = LEN(sKey(y))                                ' Save length of base key for UNIQ test
            basekey = MAX(basekey, LEN(sKey(y)))                  ' Save length of base key for UNIQ test
            sKey(y) = skey(y) + FORMAT$(x, "00000000")            ' Add record number for a tie breaker
            LData = IIF$(IsLUser(x), "T", "F")                    ' Create LData for the line
            LData += L(x).LLbl + L(x).LTag + FORMAT$(L(x).LHndl, "00000000") + FORMAT$(L(x).LTrak, "00000000") '
            STxt(y) = LData + L(x).@LTxt                          ' Save LData and the Text
            SLins(y) = x                                          ' Save original source line #
            sKey2(y) = sKey(y)                                    ' Setup second dup key
            CTxt(y) = L(x).@LAttr                                 ' Save it
            INCR y                                                '
            RETURN                                                '

         Do2ndOper:                                               '
            IF LEN(PTBL.Ops(j)) = 2 THEN                          ' A 2nd character?
               IF INSTR("CT", RIGHT$(Oprand, 1)) = 0 THEN         ' Valid
                  AnswerMeth(8, "Invalid SORT operands")          ' Pass back error
               ELSE                                               '
                  SCmd(i).CASE = RIGHT$(Oprand, 1)                ' Else save it
               END IF                                             '
            ELSEIF LEN(Oprand) = 1 THEN                           ' Ignore these
                                                                  '
            ELSE                                                  '
               AnswerMeth(8, "Invalid SORT operands")             ' Pass back error
            END IF                                                '
            RETURN                                                '
      END METHOD                                                  '

      METHOD LInsertLines(AfterLn AS LONG, Num2Insert AS LONG, IFlag AS LONG) '
      '--------------------------------------------------------------------------------------------+
      '- Add new line(s) following passed line pointer                                             |
      '--------------------------------------------------------------------------------------------+
      LOCAL x, y, InsertPos, ol, nl, i, fMix, slno, rerr AS LONG  '
      LOCAL a AS LONG                                             '
         MEntry                                                   '
         UBoundT = UBOUND(T): UBoundL = UBOUND(L)                 ' Save current sizes
         IF IsSlecSet THEN                                        ' Need we check Slec line range?
            IF (AfterLn >= me.LineNoRef(FORMAT$(SlecSLin)) AND AfterLn <= me.LineNoRef(FORMAT$(SlecELin))) THEN   '
               OffSlecSet                                         ' Clear Slec status
               OffSlecActive                                      '
               DoStatusBar($SBSelect)                             ' re-Do the StatusBar Select box
            END IF                                                '
         END IF                                                   '
         OnRenumFlag                                              ' Say Renum needed
         slno = AfterLn                                           ' Setup starting line number
         IF IsMEdit THEN fMIX = me.MEditTbl("I", FORMAT$(AfterLn))   ' In MEdit mode? Yes, get the MIX value of previous line

         me.LTblSize(Num2Insert + 100)                            ' Ensure enough room in text table

         '-----------------------------------------------------------------------------------------+
         '- Expand L() if running out of room                                                      |
         '-----------------------------------------------------------------------------------------+
         IF Num2Insert + 100 > LCtr  THEN                         ' If running out of room in L() make it bigger

            ol = UBOUND(L()): nl = ol + Num2Insert + (ol * 2)     ' Save old array size, calc new size
            REDIM PRESERVE L(nl) AS INSTANCE DataLine             ' Get room for another bunch of lines in L() array
            rerr = ERR                                            '
            UBoundL = UBOUND(L())                                 ' Save new UBound value
            LCtr += (nl - ol)                                     ' Bump LCtr
            FOR x = 1 TO ol                                       ' Correct the @LTxt pointers
               IF ISTRUE (LFlagG(x) AND (%Data OR %File OR %NOTE OR %Tabs OR %Word OR %Mark OR %Mask OR %Prof OR %Bounds OR %Cols OR %EFT)) <> 0 THEN ' In data, or special line?
                  IF L(x).LTxt <> 0 THEN                          '
                     L(x).LTxt = VARPTR(T(L(x).LTxtIX))           ' Correct using the saved TxtIX value
                  END IF                                          '
                  IF L(x).LAttr <> 0 THEN                         '
                     L(x).LAttr = VARPTR(TW(L(x).LAttrIX))        ' Correct using the saved AttrIX value
                  END IF                                          '
               END IF                                             '
            NEXT x                                                '
            FOR x = ol + 1 TO UBOUND(L())                         ' Reset the new entries
               GOSUB ResetXEntry                                  '
            NEXT x                                                '
         END IF                                                   '

         InsertPos = AfterLn                                      ' Copy passed parameter

         '-----------------------------------------------------------------------------------------+
         '- Do fast alternative to ARRAY INSERT 1 line at a time                                   |
         '-----------------------------------------------------------------------------------------+

         IF Num2Insert > 1 THEN                                   ' If n > 1 then shift it ourselves
            MEMORY COPY VARPTR(L(InsertPos + 1)), VARPTR(L(InsertPos + Num2Insert + 1)), SIZEOF(DataLine) * (UBOUND(L) - InsertPos - Num2Insert)   '
         ELSE                                                     ' Else just let ARRAY INSERT do it
            ARRAY INSERT L(AfterLn + 1) FOR (LastLine - AfterLn + 2) ' Insert an entry in L() array
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Fill in the newly inserted lines                                                       |
         '-----------------------------------------------------------------------------------------+
         x = InsertPos                                            ' Copy position
         FOR y = 1 TO Num2Insert                                  ' Loop for the number to be inserted
            INCR x                                                ' Incr local line pointer value
            GOSUB ResetXEntry                                     '
            INCR LastLine                                         ' Incr total lines in array
            IF (Iflag AND %Data) THEN INCR LastReal               ' Incr LastReal if a data line
            DECR LCtr                                             ' Reduce L() count remaining
            i = me.BStackAlloc                                    ' Allocate a buffer
            DECR TTCtr                                            ' Reduce T() count remaining
            T(i) = ""                                             ' Null the string
            L(x).LTxtIX = i                                       ' Remember the index in the L() entry
            L(x).LTxt = VARPTR(T(i))                              ' Point L.LTxt to the dynamic String

            TW(i) = CHR$$(0)                                      ' Null the string
            L(x).LAttrIX = i                                      ' Remember the index in the L() entry
            L(x).LAttr = VARPTR(TW(i))                            ' Point L.LAttr to the dynamic String

            L(x).LFlag = IFlag                                    ' Setup flag as requested
            IF (IFlag AND %SpecialLine) = 0 OR _                  ' If not a special line
               (IFlag AND %InsertLine) <> 0 THEN _                ' or IS an Insert line
               L(x).LLNum = FORMAT$(slno, "00000000")             ' then assign it a line number
            L(x).LLCtl = FORMAT$(slno, "00000000")                '
            IF ISTRUE (L(x).LFlag AND %InsertLine) THEN L(x).LLCtl = "''''''''"  '
            IF ISTRUE (L(x).LFlag AND %Note)       THEN L(x).LLCtl = gLnoTextTxt(14)   ' =  NOTE>
            INCR slno                                             ' Bump inserted line number
            L(x).LLbl = $BlankLNo                                 '
            L(x).LTag = $BlankLNo                                 '
            L(x).LWrk1 = 0                                        '
            L(x).LWrk2 = 0                                        '
            L(x).LHndl = 0                                        '
            IF IsMEdit THEN L(x).LMix = fMIX                      ' In MEdit mode? Yes, Update the MIX
         NEXT y                                                   ' Loop for number to be inserted
         OnRenumFlag                                              ' Renum stuff
         MExitMeth                                                ' We're done

         ResetXEntry:                                             ' Reset an entry
            L(x).LTxt = 0                                         '
            L(x).LTxtIX = 0                                       '
            L(x).LAttr = 0                                        '
            L(x).LAttrIX = 0                                      '
            L(x).LFlag = 0                                        '
            L(x).LCol = 0                                         '
            L(x).LWrk2 = 0                                        '
            L(x).LHndl = 0                                        '
            INCR TrkNext                                          '
            L(x).LTrak = TrkNext                                  '
            L(x).LLCtl = $BlankLNo                                '
            L(x).LLNum = $BlankLNo                                '
            L(x).LLbl = $BlankLNo                                 '
            L(x).LTag = $BlankLNo                                 '
         RETURN                                                   '
      END METHOD                                                  '

      METHOD LineNoRef(operand AS STRING) AS LONG                 '
      '--------------------------------------------------------------------------------------------+
      '- Convert operand to line number                                                            |
      '--------------------------------------------------------------------------------------------+
      LOCAL oper AS STRING, Wrd8 AS STRING, i AS LONG             '
      LOCAL LAsS AS LAsString                                     '

         MEntry                                                   '
         IF LEN(operand) > 8 THEN METHOD = -1: MExitMeth          ' If too big, kill it
         oper = TRIM$(UUCASE(operand))                            ' Uppercase it
         IF oper = ".0" OR oper = "0" THEN                        ' Special zero case?
            METHOD = 1: MExitMeth                                 '
         END IF                                                   '
         IF LEFT$(oper, 1) = "." THEN                             ' Is this a label?
            IF LastLine = 2 THEN                                  ' Empty data area?
               METHOD = -1                                        ' Everything else is invalid
            ELSE                                                  '
               IF oper = ".ZFIRST" OR oper = ".ZF" THEN           ' Look for built in labels
                  METHOD = 2                                      '
               ELSEIF oper = ".ZLAST" OR oper = ".ZL" THEN        '
                  METHOD = LastLine - 1                           '
               ELSEIF oper = ".ZFINDA" THEN                       '
                  METHOD = IIF(Found1stLin, Found1stLin, -1)      '
               ELSEIF oper = ".ZFIND" OR oper = ".ZFINDB" THEN    '
                  METHOD = IIF(FoundLstLin, FoundLstLin, -1)      '
               ELSEIF oper = ".ZLOCA" THEN                        '
                  METHOD = IIF(LocLine1stR, LocLine1stR, -1)      '
               ELSEIF oper = ".ZLOC" OR oper = ".ZLOCB" THEN      '
                  METHOD = IIF(LocLineLstR, LocLineLstR, -1)      '
               ELSEIF oper = ".ZCSR" THEN                         '
                  METHOD = @P.PS(@P.C.CRow)                       '
               ELSEIF oper = ".ZTOP" THEN                         '
                  METHOD = @P.PTopLine                            '
               ELSEIF oper = ".ZBOT" THEN                         '
                  METHOD = TP.VisBot                              '
               ELSEIF VAL(MID$(oper, 2)) > 0 THEN                 ' Numeric dotted label?
                  i = VAL(MID$(oper, 2))                          ' Get the value
                  i = GetLineNumber(i)                            ' Convert to proper IX value
                  METHOD = IIF(i = 0, -1, i)                      ' Pass it back
               ELSEIF LEFT$(oper, 2) = "._" THEN                  ' Handle reference?
                  LAsS.LVar = VAL(MID$(oper, 3))                  ' Extract the nnnn from ._nnnnn
                  i = me.LLHndlScan(LAsS.CVar)                    ' See if we can find it
                  METHOD = IIF(i = 0, -1, i - 1)                  ' Pass zero if NFG, else LLNum of the line
               ELSE                                               '
                  Wrd8 = LSET$(oper, 8)                           ' Convert to fixed string for search
                  i = me.LLCtlScan(Wrd8)                          ' See if we can find it
                  METHOD = IIF(i = 0, -1, i - 1)                  ' Pass zero if NFG, else LLNum of the line
               END IF                                             '
            END IF                                                '

         ELSEIF LEFT$(oper, 1) = "!" THEN                         ' Is this an LPtr type?
            IF VAL(MID$(oper,2)) = 0 OR _                         ' !0 is not allowed
               VAL(MID$(oper, 2)) > Lastline THEN                 ' Or > Lastline
               METHOD = -1                                        ' Kill it
            ELSE                                                  '
               METHOD = VAL(MID$(oper, 2))                        ' Pass it back
            END IF                                                '

         ELSE                                                     '
            i = VAL(oper)                                         ' See if numeric
            IF i > 0 THEN i = GetLineNumber(i)                    ' Convert to proper IX value
            METHOD = IIF(i = 0, -1, i)                            ' Pass it back
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD LInitTxtData()                                       '
      '--------------------------------------------------------------------------------------------+
      '- Initialize the text work areas                                                            |
      '--------------------------------------------------------------------------------------------+
      LOCAL t AS STRING, i, tsize AS LONG                         '
         MEntry                                                   '
         tsize = 100000                                           ' Use 100000
         REDIM T(tsize) AS INSTANCE STRING                        ' To hold the dynamic TEXT strings
         REDIM TW(tsize) AS INSTANCE WSTRING                      ' To hold the dynamic Attr strings
         REDIM L(tsize) AS INSTANCE Dataline                      ' TEXT control array
         REDIM BStack(tsize) AS INSTANCE LONG                     ' Buffer Stack array
         REDIM TrkStack(1 TO %TrkMax) AS INSTANCE TrkStackT       ' Track Stack
         UBoundL = tsize: UBoundT = tsize                         '
         tTCtr = tsize                                            ' Set number available in table
         LCtr = tsize                                             '
         FOR i = 0 TO UBOUND(T)                                   ' Reset the Text array
            T(i) = "": TW(i) = ""                                 ' and the Attr array
         NEXT i                                                   '
         FOR i = 0 TO UBOUND(L)                                   ' Reset the DataLine array
            L(i).LTxt = 0                                         '
            L(i).LTxtIX = 0                                       '
            L(i).LAttr = 0                                        '
            L(i).LAttrIX = 0                                      '
            L(i).LFlag = 0                                        '
            L(i).LHndl = 0                                        '
            INCR TrkNext                                          '
            L(i).LTrak = TrkNext                                  '
            L(i).LLCtl = $BlankLNo                                '
            L(i).LLNum = $BlankLNo                                '
            L(i).LLbl = $BlankLNo                                 '
            L(i).LTag = $BlankLNo                                 '
         NEXT i                                                   '
         FOR i = 1 TO tsize                                       ' Init the Buffer Stack
            BStack(i) = i                                         '
         NEXT i                                                   '
         BStack(0) = 0                                            '
         REDIM MEditList(1 TO 20) AS INSTANCE STRING              ' MEDIT filename list
         REDIM MEditFlag(1 TO 20) AS INSTANCE LONG                ' MEDIT filename flags
         MEditCount = 0                                           '
         me.LTxtAlloc(1)                                          ' Initialize Top of Dataset Line
         L(1).LFlag = L(1).LFlag OR %Top                          '
         L(1).LLNum = "00000000"                                  '
         L(1).LLCtl = "********"                                  '
         me.LTxtAlloc(2)                                          ' Initialize Bottom of Dataset Line
         L(2).LFlag = L(2).LFlag OR %Bottom                       '
         L(2).LLNum = "00000000"                                  '
         L(2).LLCtl = "********"                                  '
         FOR i = 1 TO 300                                         '
            @P.PS(i) = 0                                          '
         NEXT i                                                   '
         me.CsrRow = @P.PTop: @P.POffset = 0: @P.PCOffset = 0     ' Set Startup values
         me.CsrCol = @P.PCmdCol: MaxLength = 0: sCurPrio = 0      '
         @P.PMarkLine = 0: Flag = 0: LastLine = 2: @P.PTopLine = 1   '
         TrkIX = 0: MacWarn = 0                                   '
         OffBackupDone: Encoding = "ANSI"                         '
         LastReal = 0: TabMode = (TabMode AND %FMTab)             ' Kill all but FMTab flag
         MExit                                                    '
      END METHOD                                                  '

      METHOD LocSearch() AS LONG                                  '
      '--------------------------------------------------------------------------------------------+
      '- Do the full LOCATE Search procedure                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, k, x, y, CurrWinner, WinnerLine, RevOnce, AllCount AS LONG  '
      LOCAL PosType AS INTEGER, aTxt AS WSTRING POINTER, AttrAsc AS WORD   '
         MEntry                                                   '
         METHOD = %False                                          ' Start off saying we've failed
         PosType = IIF(IsLfTop, %FLocate, %Locate)                ' Set position type based on TOP
         IF CurrPCmd = "RLOC" OR CurrPCmd = "RLOCFIND" THEN PosType = %Find   ' Give RLOC extra priority
         IF IsRevOnce THEN                                        ' Reverse one time only?
            OffRevOnce: RevOnce = %True                           ' Remove globally, remember locally
         END IF                                                   '
         LocDir = IIF(IsLfPrev, -1, 1)                            ' If PREV then reverse search direction
         IF IsCData OR IsCLinn THEN                               ' In the Data Area or Line number area
            LocLine = me.SGet(@P.C.CRow) + IIF(RevOnce, -1 * LocDir, LocDir)  ' Swap in current cursor location
         END IF                                                   '
         IF IsLfFirst OR IsLfAll THEN                             ' If FIRST/ALL then start as the top
            LocLine = 1: LfClear(%LocFirst): LfSet(%LocNext)      ' Remove so we do it just once
         END IF                                                   '
         IF IsLfLast THEN                                         ' If LAST then start as the bottom
            LocLine = LastLine: LocDir = -1                       '
            LfClear(%LocLast): LfSet(%LocPrev)                    ' Remove LAST and insert PREV
         END IF                                                   '

         IF LocNotFound  <> 0 THEN                                ' Was last search a not found?
            IF LocNotFound = 1 THEN                               ' Hit the top?
               LocLine = LastLine                                 ' Backward, restart at the bottom
            ELSE                                                  ' Else the bottom
               LocLine = 1                                        ' Forward, restart at the top
            END IF                                                '
            LocNotFound = 0                                       ' Clear, we wrap just once
         END IF                                                   '
         i = LocLine: LocNFDir = IIF(RevOnce, -1 * LocDir, LocDir)   ' Init for DO loop
         DO WHILE 1 = 1                                           ' Do forever
            j = %False                                            ' Start as not found
            IF (IIF(RevOnce, -1 * LocDir, LocDir) = 1  AND IsLBottom(i)) OR _ ' Do till top or bottom
               (IIF(RevOnce, -1 * LocDir, LocDir) = -1 AND IsLTop(i)) THEN EXIT DO  '

            IF IsLBottom(i) OR IsLTop(i) THEN i += IIF(RevOnce, -1 * LocDir, LocDir): ITERATE DO   '

            IF LocLabLine1 > 0 AND LocLabLine2 > 0 THEN           ' Line range request
               IF i < LocLabLine1 OR i > LocLabLine2 THEN         ' See if in range
                  i += IIF(RevOnce, -1 * LocDir, LocDir)          ' Next entry
                  ITERATE DO                                      '
               END IF                                             '
            END IF                                                '

            IF ISNOTNULL(LocTag) THEN                             ' Looking for a specific Tag?
               IF LTagG(i) = LocTag THEN                          ' Have a Match?
                  IF ISFALSE IsLfNot THEN j = %True               ' If it isn't NOT, set True
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfChange THEN                                ' Looking for a ==CHG> line
               IF ISFALSE IsLfCurrent THEN                        ' Looking for the current one?
                  IF IsLEQChange(i) THEN                          ' No, normal CHANGE, Is this  one
                     IF ISFALSE IsLfNot THEN j = %True            ' If it isn't NOT, set True
                  ELSE                                            ' Not a Match
                     IF IsLfNot THEN j = %True                    ' If it is NOT, set True
                  END IF                                          '
               ELSE                                               '
                  IF LFIXG(i) > CurrWinner THEN CurrWinner = LFIXG(i): WinnerLine = i  ' If more current, save the winner
               END IF                                             '

            ELSEIF IsLfFind THEN                                  ' Looking for a FIND line
               IF ISFALSE IsLfCurrent THEN                        ' Looking for the current one?
                  IF LFIXG(i) > 0 THEN                            ' No, is this one
                     IF ISFALSE IsLfNot THEN j = %True            ' If it isn't NOT, set True
                  ELSE                                            ' Not a Match
                     IF IsLfNot THEN j = %True                    ' If it is NOT, set True
                  END IF                                          '
               ELSE                                               '
                  IF LFIXG(i) > CurrWinner THEN CurrWinner = LFIXG(i): WinnerLine = i  ' If more current, save the winner
               END IF                                             '

            ELSEIF IsLfCommand THEN                               ' Looking for a pending command line
               IF me.LLCtlGet(i) <> LLNumG(i) AND _               ' If not a line number
                  me.LLCtlGet(i) <> "''''''''" AND _              ' AND NOT an INSERT LINE
                  me.LLCtlGet(i) <> "--------" AND _              ' and not a -------- line
                  LEFT$(me.LLCtlGet(i), 1) <> "." AND _           ' and not a label
                  LEFT$(me.LLCtlGet(i), 1) <> ":" AND _           ' and not a tag
                  LEFT$(me.LLCtlGet(i), 1) <> "=" THEN            ' and not a special, then its a command
                  IF ISFALSE IsLfNot THEN j = %True               ' If it isn't NOT, set True
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfError THEN                                 ' Looking for an Error
               '-                                                 ' Not yet

            ELSEIF IsLfExcluded THEN                              ' Looking for an Excluded line?
               IF ISFALSE IsLfNot THEN                            ' If it isn't NOT, look for Xclude lines
                  IF IsLXclude(i) THEN j = %True                  ' This is one
               ELSE                                               ' We're doing the NOT X search
                  IF IsLData(i) AND ISFALSE IsLInvisible(i) THEN j = %True ' A visible Data line
               END IF                                             '

            ELSEIF IsLfNX THEN                                    ' Looking for an NX line?
               IF ISFALSE IsLfNot THEN                            ' If it isn't NOT, look for Normal lines
                  IF IsLData(i) AND ISFALSE IsLInvisible(i) THEN j = %True ' This is one
               ELSE                                               ' We're doing the NOT X search
                  IF IsLXclude(i) THEN j = %True                  ' An Exclude line line
               END IF                                             '

            ELSEIF IsLfU THEN                                     ' Looking for a User line?
               IF ISFALSE IsLfNot THEN                            ' If it isn't NOT, look for User lines
                  IF IsLUser(i) THEN j = %True                    ' This is one
               ELSE                                               ' We're doing the NOT U search
                  IF ISFALSE IsLUser(i) THEN j = %True            ' A visible Data line
               END IF                                             '

            ELSEIF IsLfNU THEN                                    ' Looking for a non-User line?
               IF ISFALSE IsLfNot THEN                            ' If it isn't NOT, look for non-User lines
                  IF ISFALSE IsLUser(i) THEN j = %True            ' This is one
               ELSE                                               ' We're doing the NOT NU search
                  IF IsLUser(i) THEN j = %True                    ' A User line
               END IF                                             '

            ELSEIF IsLfLabel THEN                                 ' Looking for a Labelled line?
               IF L(i).LLbl <> $BlankLNo THEN                     ' This is one
                  IF ISFALSE IsLfNot THEN j = %True               ' If it isn't NOT, set True
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfHandle THEN                                ' Looking for a line with a handle?
               IF L(i).LHndl <> 0 THEN                            ' This is one
                  IF ISFALSE IsLfNot THEN                         ' If it isn't NOT, set True
                      j = %True                                   '
                      IF ISFALSE IsLfAll THEN TP.ErrMsgAdd(0, "Located Handle: ._" + FORMAT$(L(i).LHndl))   '
                  END IF                                          '
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfNote THEN                                  ' Looking for a Note line?
               IF IsLNote(i) THEN                                 ' This is one
                  IF LocNVar = 0 THEN                             ' An old NOTE type?
                     IF L(i).LWrk2 = 0 THEN                       ' And this is an old Note
                        IF ISFALSE IsLfNot THEN j = %True         ' If it isn't NOT, set True
                     ELSE                                         '
                        IF IsLfNot THEN j = %True                 ' If it is NOT, set True
                     END IF                                       '
                  ELSEIF LocNVar < 26 THEN                        ' A specific xNOTE type?
                     IF L(i).LWrk2 = LocNVar THEN                 ' And this is that NOTE type
                        IF ISFALSE IsLfNot THEN j = %True         ' If it isn't NOT, set True
                     ELSE                                         '
                        IF IsLfNot THEN j = %True                 ' If it is NOT, set True
                     END IF                                       '
                  ELSE                                            ' Must be ZNOTE
                     IF L(i).LWrk2 <> 0 THEN                      ' And this is a special NOTE type
                        IF ISFALSE IsLfNot THEN j = %True         ' If it isn't NOT, set True
                     ELSE                                         '
                        IF IsLfNot THEN j = %True                 ' If it is NOT, set True
                     END IF                                       '
                  END IF                                          '
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfSpecial THEN                               ' Looking for a Special line?
               IF IsLWord(i) OR _                                 ' One of them?
                  IsLTabs(i) OR _                                 '
                  IsLBounds(i) OR _                               '
                  IsLCols(i) OR _                                 '
                  IsLMark(i) OR _                                 '
                  IsLMask(i) OR _                                 '
                  IsLProf(i) THEN                                 ' Yes, set true
                  IF ISFALSE IsLfNot THEN j = %True               ' If it isn't NOT, set True
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfFile THEN                                  ' Looking for a File line?
               IF IsLFile(i) THEN                                 ' One of them?
                  IF ISFALSE IsLfNot THEN j = %True               ' If it isn't NOT, set True
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfPage THEN                                  ' Looking for a Page line?
               IF IsLPage(i) THEN                                 ' One of them?
                  IF LocLength > 0 THEN                           ' Specific page number?
                     IF LocLength - FCB.PageOffset = 1 AND i = 2 THEN   ' Page 1 fudge?
                        IF ISFALSE IsLfNot THEN j = %True         ' If it isn't NOT, set True
                     ELSEIF LocLength - FCB.PageOffset = L(i).LWrk2 THEN   ' Correct page?
                        IF ISFALSE IsLfNot THEN j = %True         ' If it isn't NOT, set True
                     ELSE                                         ' Not right page
                        IF IsLfNot THEN j = %True                 ' If it is NOT a page, set True
                     END IF                                       '
                  ELSE                                            ' Is PAGE, and is any old page
                     IF ISFALSE IsLfNot THEN j = %True            ' If it isn't NOT, set True
                  END IF                                          '
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT a page, set True
               END IF                                             '

            ELSEIF IsLfKeep THEN                                  ' Looking for a Kept command?
               IF INSTR(me.LLCtlGet(i), "&") <> 0 THEN            ' This is one
                  IF ISFALSE IsLfNot THEN j = %True               ' If it isn't NOT, set True
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfTag THEN                                   ' Looking for any Tag?
               IF LTagG(i) <> $BlankLNo THEN                      ' This is one
                  IF ISFALSE IsLfNot THEN j = %True               ' If it isn't NOT, set True
               ELSE                                               ' Not a Match
                  IF IsLfNot THEN j = %True                       ' If it is NOT, set True
               END IF                                             '

            ELSEIF IsLfLong THEN                                  ' Looking for any Long?
               IF IsLData(i) THEN                                 ' Only data lines
                  IF LEN(L(i).@LTxt) > LocLength THEN             ' This is one
                     IF ISFALSE IsLfNot THEN j = %True            ' If it isn't NOT, set True
                  ELSE                                            ' Not a Match
                     IF IsLfNot THEN j = %True                    ' If it is NOT, set True
                  END IF                                          '
               END IF                                             '

            ELSEIF IsLfSize THEN                                  ' Looking for Size?
               IF IsLData(i) THEN                                 ' Only data lines
                  IF LEN(L(i).@LTxt) = LocLength THEN             ' This is one
                     IF ISFALSE IsLfNot THEN j = %True            ' If it isn't NOT, set True
                  ELSE                                            ' Not a Match
                     IF IsLfNot THEN j = %True                    ' If it is NOT, set True
                  END IF                                          '
               END IF                                             '

            ELSEIF IsLfStd THEN                                   ' Looking for Std color
               IF IsLData(i) THEN                                 ' Only data lines
                  IF L(i).LAttr <> 0 THEN                         ' Line have a Attr line?
                     aTxt = LAttrGP(i)                            ' Get pointer to Attr text string
                     k = %False                                   ' Say no HiLites
                     FOR x = 1 TO LEN(@aTxt)                      ' Scan through it
                        AttrAsc = ASC(@aTxt, x) AND %AttrHiLite   ' Get the HiLite bits
                        IF AttrAsc <> 0 THEN k = %True: EXIT FOR  ' Found one
                     NEXT x                                       '

                     IF ISFALSE k THEN                            ' But nothing there?
                        IF ISFALSE IsLfNot THEN j = %True         ' If it isn't NOT, set True
                     ELSE                                         ' Not a Match
                        IF IsLfNot THEN j = %True                 ' If it is NOT, set True
                     END IF                                       '
                  ELSE                                            ' No Attr values
                     IF ISFALSE IsLfNot THEN j = %True            ' If it isn't NOT, set True
                  END IF                                          '
               END IF                                             '

            ELSEIF IsLfColor THEN                                 ' Looking for a specific color
               IF IsLData(i) THEN                                 ' Only data lines
                  IF L(i).LAttr <> 0 THEN                         ' Line have a Attr line?
                     aTxt = LAttrGP(i)                            ' Get pointer to Attr text string
                     k = %False                                   ' Say not found
                     FOR x = 1 TO LEN(@aTxt)                      ' Scan through it
                        AttrAsc = ASC(@aTxt, x) AND %AttrHiLite   ' Get the HiLite bits
                        SHIFT RIGHT AttrAsc, 12                   ' Right align
                        IF AttrAsc = LocColor THEN                ' Desired color?
                           k = %True                              ' Yes, found it
                           EXIT FOR                               ' Exit x loop
                        END IF                                    '
                     NEXT x                                       '

                     IF k THEN                                    ' Found?
                        IF ISFALSE IsLfNot THEN j = %True         ' If it isn't NOT, set True
                     ELSE                                         ' Not a Match
                        IF IsLfNot THEN j = %True                 ' If it is NOT, set True
                     END IF                                       '
                  ELSE                                            ' No Attr values
                     IF IsLfNot THEN j = %True                    ' If it isn't NOT, set True
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            IF j THEN                                             ' If we have a 'found' condition
               METHOD = %True                                     '
               INCR AllCount                                      ' Count winners
               IF ISFALSE IsLInvisible(i) THEN                    ' A normal non-X'd line?
                  me.CurSetReq(PosType, i, 0, %True)              ' Set cursor set attempt
                  IF IsLfMX THEN                                  ' MX requested
                     me.LFlagBitOn(i, %Invisible)                 ' Then make it invisible
                     gfXRebuild = %True                           ' Rebuild exclude state
                     OnUndoFlag                                   ' Take a snapshot
                  END IF                                          '
               ELSE                                               ' We have a line already X'd out
                  IF ISFALSE IsLfMX THEN                          ' No MX requested
                     me.LFlagBitOff(i, %Invisible)                '
                     gfXRebuild = %True                           ' Rebuild exclude state
                     OnUndoFlag                                   ' Take a snapshot
                     me.CurSetReq(PosType, i, 0, %True)           ' Set cursor set attempt
                  END IF                                          '
               END IF                                             '
               LocLineLstR = i                                    ' Save found line
               IF LocLine1stR = 0 THEN LocLine1stR = i            ' Do the 1st version of it
               LocLine = i + IIF(RevOnce, -1 * LocDir, LocDir)    ' Save continue line
               IF ISFALSE IsLfAll THEN                            '
                  EXIT DO                                         '
               ELSE                                               '
                  j = 0                                           '
               END IF                                             '
            END IF                                                '
            i += IIF(RevOnce, -1 * LocDir, LocDir)                '
         LOOP                                                     '

         IF IsLfAll THEN                                          ' Issue message for ALL
            TP.ErrMsgAdd(0, "LOCATE matched " + FORMAT$(AllCount) + IIF$(AllCount = 1, " line", " lines"))  '
         END IF                                                   '
         IF ISFALSE IsLfCurrent THEN MExitMeth                    ' If not CURRENT
         IF ISFALSE IsLfChange AND ISFALSE IsLfFind THEN MExitMeth   '
         IF CurrWinner = 0 THEN MExitMeth                         ' If no winner
         METHOD = %True                                           '
         IF ISFALSE IsLInvisible(WinnerLine) THEN                 ' A normal non-X'd line?
            me.CurSetReq(PosType, WinnerLine, 0, %True)           ' Set cursor set attempt
         ELSE                                                     ' We have a line already X'd out
            me.LFlagBitOff(WinnerLine, %Invisible)                '
            gfXRebuild = %True                                    ' Rebuild exclude state
            me.CurSetReq(PosType, WinnerLine, 0, %True)           ' Set cursor set attempt
         END IF                                                   '
         LocLineLstR = WinnerLine                                 ' Save winner line
         LocLine = WinnerLine + IIF(RevOnce, -1 * LocDir, LocDir) ' Save continue line
         MExit                                                    '
      END METHOD                                                  '

      METHOD LPopOutX(ln AS LONG) AS LONG                         '
      '--------------------------------------------------------------------------------------------+
      '- Pop out an X'd line                                                                       |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL k AS LONG, tmp AS DataLine                            '
         MEntry                                                   '
         i = ln - L(ln).LWrk1                                     ' Point i back at the XX control line
         j = i + l(i).LWrk1                                       ' Point j at last XX'd out line in the range

         IF L(i).LWrk1 = 1 THEN                                   ' Doing a whole 1 line range
            me.LTxtFree(i)                                        ' Go free the dynamic string of the XX line
            ARRAY DELETE L(i)                                     ' Remove from the L() array
            DECR LastLine                                         ' Adjust for removed XX line
            L(i).LFlag = L(i).LFlag AND (&HFFFFFFFF - %Invisible) ' Remove Invisible (i now = real line #)
            L(i).LFlag = L(i).LFlag OR %Popped                    ' Mark as popped during this interaction
            L(i).LWrk1 = 0                                        ' Clear Work
            IF ln <= PTBL.FindRngEnd THEN PTBL.FindRngEnd = PTBL.FindRngEnd - 1  ' Adjust the end range if needed
            METHOD = i                                            ' Pass Back the line number
            MExitMeth                                             ' We're done, a simple one
         END IF                                                   '

         IF j = ln THEN                                           ' Doing last line of a range
            L(ln).LFlag = L(ln).LFlag AND (&HFFFFFFFF - %Invisible)  ' Remove Invisible, that's all that's needed
            L(ln).LFlag = L(ln).LFlag OR %Popped                  ' Mark as popped during this interaction
            L(ln).LWrk1 = 0                                       ' Clear Work in the Pop'ed out line
            DECR L(i).LWrk1                                       ' and reduce count in the XX marker line
            METHOD = ln                                           ' Pass Back the line number
            MExitMeth                                             ' We're done, another simple one
         END IF                                                   '

         IF L(ln).LWrk1 = 1 THEN                                  ' Doing the 1st line of a range
            DECR L(i).LWrk1                                       ' Adjust # in reduced range
            tmp = L(i)                                            ' Save the XX marker line for a bit
            ARRAY DELETE L(i)                                     ' Delete the XX marker line from its old location
            l(i).LFlag = L(i).LFlag AND (&HFFFFFFFF - %Invisible) ' Make the line visible (i now = real line #)
            L(i).LFlag = L(i).LFlag OR %Popped                    ' Mark as popped during this interaction
            L(i).LWrk1 = 0                                        ' Clear Work in the Pop'ed out line
            ARRAY INSERT L(i + 1), tmp                            ' Stuff saved XX marker back in after Popped line
            FOR j = 1 TO L(i + 1).LWrk1                           ' Redo Work numbers in the new range
               L(i + 1 + j).LWrk1 = j                             '
            NEXT j                                                '
            METHOD = i                                            ' Pass Back the line number
            MExitMeth                                             '
         END IF                                                   '
                                                                  ' Doing a line in middle of a range
         k = L(i).LWrk1 - L(ln).LWrk1                             ' Calc count for the new 'lower' range
         L(i).LWrk1 = L(ln).LWrk1 - 1                             ' Set a new count in current marker
         L(ln).LFlag = L(ln).LFlag AND (&HFFFFFFFF - %Invisible)  ' Pop out the requested line
         L(ln).LFlag = (L(ln).LFlag OR %Popped)                   ' Mark as popped during this interaction
         me.LInsertLines(ln, 1, %Xclude)                          ' Insert a line to hold the Exclude marker
         L(ln + 1).LWrk1 = k                                      ' Stuff in the calculated # of X'd lines in new area
         L(ln + 1).LLNum = "00000000"                             ' Clear line number

         FOR j = 1 TO k                                           ' Redo Work numbers in the new range
            L(ln + 1 + j).LWrk1 = j                               '
         NEXT j                                                   '
         METHOD = ln                                              ' Pass Back the line number
         me.AdjustPending(ln, 1, 0)                               ' Adjust pending stuff
         IF ln <= PTBL.FindRngEnd THEN PTBL.FindRngEnd = PTBL.FindRngEnd + 1  ' Adjust the end range if needed
         MExit                                                    '
      END METHOD                                                  '

      METHOD LPopOutY(ln AS LONG) AS LONG                         '
      '--------------------------------------------------------------------------------------------+
      '- Pop out an X'd line, return needed adjustment for subsequent lines                        |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL k AS LONG, tmp AS DataLine                            '
         MEntry                                                   '
         i = ln - L(ln).LWrk1                                     ' Point i back at the XX control line
         j = i + l(i).LWrk1                                       ' Point j at last XX'd out line in the range

         IF L(i).LWrk1 = 1 THEN                                   ' Doing a whole 1 line range
            me.LTxtFree(i)                                        ' Go free the dynamic string of the XX line
            ARRAY DELETE L(i)                                     ' Remove from the L() array
            DECR LastLine                                         ' Adjust for removed XX line
            L(i).LFlag = L(i).LFlag AND (&HFFFFFFFF - %Invisible) ' Remove Invisible (i now = real line #)
            L(i).LFlag = L(i).LFlag OR %Popped                    ' Mark as popped during this interaction
            L(i).LWrk1 = 0                                        ' Clear Work
            METHOD = -1                                           ' We ended up deleting one line
            MExitMeth                                             ' We're done, a simple one
         END IF                                                   '

         IF j = ln THEN                                           ' Doing last line of a range
            L(ln).LFlag = L(ln).LFlag AND (&HFFFFFFFF - %Invisible)  ' Remove Invisible, that's all that's needed
            L(ln).LFlag = L(ln).LFlag OR %Popped                  ' Mark as popped during this interaction
            L(ln).LWrk1 = 0                                       ' Clear Work in the Pop'ed out line
            DECR L(i).LWrk1                                       ' and reduce count in the XX marker line
            METHOD = 0                                            ' Pass Back zero, we made no inserts/deletes
            MExitMeth                                             ' We're done, another simple one
         END IF                                                   '

         IF L(ln).LWrk1 = 1 THEN                                  ' Doing the 1st line of a range
            DECR L(i).LWrk1                                       ' Adjust # in reduced range
            tmp = L(i)                                            ' Save the XX marker line for a bit
            ARRAY DELETE L(i)                                     ' Delete the XX marker line from its old location
            L(i).LFlag = L(i).LFlag AND (&HFFFFFFFF - %Invisible) ' Make the line visible (i now = real line #)
            L(i).LFlag = L(i).LFlag OR %Popped                    ' Mark as popped during this interaction
            L(i).LWrk1 = 0                                        ' Clear Work in the Pop'ed out line
            ARRAY INSERT L(i + 1), tmp                            ' Stuff saved XX marker back in after Popped line
            FOR j = 1 TO L(i + 1).LWrk1                           ' Redo Work numbers in the new range
               L(i + 1 + j).LWrk1 = j                             '
            NEXT j                                                '
            METHOD = 0                                            ' Pass Back zero, we made no real inserts/deletes
            MExitMeth                                             '
         END IF                                                   '
                                                                  ' Doing a line in middle of a range
         k = L(i).LWrk1 - L(ln).LWrk1                             ' Calc count for the new 'lower' range
         L(i).LWrk1 = L(ln).LWrk1 - 1                             ' Set a new count in current marker
         L(ln).LFlag = L(ln).LFlag AND (&HFFFFFFFF - %Invisible)  ' Pop out the requested line
         L(ln).LFlag = L(ln).LFlag OR %Popped                     ' Mark as popped during this interaction
         me.LInsertLines(ln, 1, %Xclude)                          ' Insert a line to hold the Exclude marker
         L(ln + 1).LWrk1 = k                                      ' Stuff in the calculated # of X'd lines in new area
         L(ln + 1).LLNum = "00000000"                             ' Clear line number

         FOR j = 1 TO k                                           ' Redo Work numbers in the new range
            L(ln + 1 + j).LWrk1 = j                               '
         NEXT j                                                   '
         METHOD = 1                                               ' Pass Back 1 for the inserted line
         me.AdjustPending(ln, 1, 0)                               ' Adjust pending stuff
         MExit                                                    '
      END METHOD                                                  '

      METHOD UndoPut(BYVAL pData AS UNDOType POINTER)             '
      REGISTER j AS LONG                                          '
      LOCAL tResult AS LONG                                       '
         MEntry                                                   '
         @pData.pBStack = VARPTR(BStack(0))                       ' Build parameter list
         @pData.pL  = VARPTR(L(0))                                '
         @pData.pT  = VARPTR(T(0))                                '
         @pData.pTW = VARPTR(TW(0))                               '
         THREAD CREATE UndoSaveThread(BYVAL pData), TO UNDOThread ' Fire up the thread
         THREAD STATUS UndoThread TO tResult                      ' See if running OK
         IF tResult <> 259 THEN                                   ' If running OK STATUS returns &H103 (See Help)
            THREAD CLOSE UNDOThread TO tResult                    ' Free up our handle
         END IF                                                   '
         j = 0                                                    '
         DO WHILE @PData.mCpyBusy = %True                         ' Wait till thread has done copies
'            SLEEP 100                                             ' Wait a bit
            DIALOG DOEVENTS 0
            INCR j                                                ' Count for escape hatch
            IF j > 150 THEN EXIT DO                               ' Break out after 15 seconds
         LOOP                                                     '
         MExit                                                    '
      END METHOD                                                  '

      METHOD UndoGet(i AS LONG) AS LONG                           '
      LOCAL j, ProfLine, FNum AS LONG, buf AS STRING, bufw, w AS WSTRING   '
      LOCAL wk AS WsWork                                          '
      REGISTER ii AS LONG                                         '
         MEntry                                                   '
         FNum = FREEFILE                                          ' Get file #
         OPEN me.UndoIXFnGet(i) FOR BINARY ACCESS READ LOCK SHARED AS FNum '
         j = LOF(# FNum) / 4                                      ' Get size of an BStack entry
         REDIM BStack(j) AS INSTANCE LONG                         ' Redim BStack() to match save data
         GET # FNum, ,Bstack()                                    ' Read the Data (Can't pass BStack() to a METHOD)
         CLOSE # FNum                                             ' Close it

         FNum = FREEFILE                                          ' Get file #
         OPEN me.UndoUFnGet(i) FOR BINARY ACCESS READ LOCK SHARED AS FNum  '
         j = LOF(# FNum) / SIZEOF(DataLine)                       ' Get size of an L entry
         REDIM L(j) AS INSTANCE DataLine                          ' Redim L() to match save data
         GET # FNum, ,L()                                         ' Read the Data (Can't pass L() to a METHOD)
         CLOSE # FNum                                             '

         FNum = FREEFILE                                          ' Get file #
         OPEN me.UndoTFnGet(i) FOR BINARY ACCESS READ LOCK SHARED AS FNum  '
         j = me.UndoUBTGet(i)                                     ' Get size of T() table
         REDIM T(j) AS INSTANCE STRING                            ' Redim T() to match save data
         GET$ # FNum, LOF(# FNum), buf                            ' Read it back
         PARSE buf, T(), $CRLF                                    ' Assign back to the array
         CLOSE # FNum                                             '

         FOR ii = 1 TO j                                          ' Loop re-assigning pointers
            IF IsLProf(ii) THEN ProfLine = %True                  ' Remember if PRof lines exist
            L(ii).LTxt = VARPTR(T(L(ii).LTxtIX))                  ' Correct the Txt pointer
         NEXT ii                                                  '

         FNum = FREEFILE                                          ' Get file #
         OPEN me.UndoTWFnGet(i) FOR BINARY ACCESS READ LOCK SHARED AS FNum '
         j = me.UndoUBTGet(i)                                     ' Get size of TW() table
         REDIM TW(j) AS INSTANCE WSTRING                          ' Redim TW() to match save data
         GET$$ # FNum, (LOF(# FNum) / 2), bufw                    ' Read it back
         PARSE bufw, TW(), $$CRLF                                 ' Assign back to the array
         CLOSE # FNum                                             '

         FOR ii = 1 TO j                                          ' Loop re-assigning pointers
            L(ii).LAttr = VARPTR(TW(L(ii).LAttrIX))               ' Correct the Attr pointer
         NEXT ii                                                  '

         METHOD = IIF(ProfLine, &H00000001, 0)                    ' Say whether Prof lines exist
         MExit                                                    '
      END METHOD                                                  '

      METHOD IsTouchable(lin AS LONG) AS LONG                     '
      '--------------------------------------------------------------------------------------------+
      '- See if line area is 'touchable'                                                           |
      '--------------------------------------------------------------------------------------------+
      LOCAL ldata AS STRING                                       '
         MEntry                                                   '
         METHOD = %True                                           ' Default return
         IF TCtr = 0 THEN MExitMeth                               ' No touch entries, it's touchable
         ldata = me.TTblScan(lin)                                 ' See if a pending for this line
         IF ISNOTNULL(ldata) THEN METHOD = %False                 ' Swap it in
         MExit                                                    '
      END METHOD                                                  '

      METHOD IsP1() AS LONG                                       '
         METHOD = IIF(P = VARPTR(P1), %True, %False)              ' Return True is P1 active
      END METHOD                                                  '

      METHOD IsP2() AS LONG                                       '
         METHOD = IIF(P = VARPTR(P2), %True, %False)              ' Return True is P2 active
      END METHOD                                                  '

      METHOD Join() AS LONG                                       '
      '--------------------------------------------------------------------------------------------+
      '- Join a line for JOIN/RJOIN                                                                |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, k, l, l1, l2, x, y AS LONG                      '
      LOCAL TTxt, L1Txt, L2Txt, lclChg AS STRING                  '
      LOCAL CTxt, CWrk, L1Clr, L2Clr AS WSTRING, AttrAsc AS WORD  '

         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Get common variables into local data                                                   |
         '-----------------------------------------------------------------------------------------+
         i = PTBL.FoundLine                                       ' Find line
         j = PTBL.FoundCol                                        ' Column where it was found
         k = PTBL.FoundLen                                        ' Length of found string
         l = LEN(L(i).@LTxt)                                      ' Length of text line
         GOSUB GetPrevAttr                                        ' Get current Attr of the found string

         '-----------------------------------------------------------------------------------------+
         '- Prepare the Change string                                                              |
         '-----------------------------------------------------------------------------------------+
         y = j                                                    ' Found data
         TTxt = LTxtG(i)                                          ' Copy of the line's text
         FOR x = 1 TO LEN(PTBL.L2RData)                           ' Loop building the change string
            SELECT CASE AS CONST$ MID$(PTBL.L2RData, x, 1)        ' Do it based on the char inside P'xxx'
               CASE "=": lclChg += MID$(TTxt, y, 1): INCR y       ' Copy the character
               CASE "<": lclChg += LLCASE(MID$(TTxt, y, 1)): INCR y  ' Lowercase it
               CASE ">": lclChg += UUCASE(MID$(TTxt, y, 1)): INCR y  ' Uppercase it
               CASE "!": lclChg += MID$(TTxt, j, k)               ' Copy found string
               CASE "~": INCR y                                   ' Ignore it
               CASE "\"                                           ' Escape?
                  lclChg += MID$(PTBL.L2RData, x + 1, 1)          ' Copy next char
                  INCR x                                          ' extra step
                  IF PTBL.FlgL2Picture THEN INCR y                ' If doing a picture
               '-----------------------------------------------------------------------------------+
               '- Not special character, just copy it                                              |
               '-----------------------------------------------------------------------------------+
               CASE ELSE                                          ' Copy L12 character
                  lclChg += MID$(PTBL.L2RData, x, 1)              '
                  IF PTBL.FlgL2Picture THEN INCR y                ' If doing a picture
            END SELECT                                            '
         NEXT x                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Setup the two line numbers                                                             |
         '-----------------------------------------------------------------------------------------+
         IF PTBL.FlgLM THEN                                       ' LM join
            l1 = me.CRPBack(%mOData, i, 1)                        ' L1 point at previous line
            l2 = i                                                ' L2 at this line
            IF IsLTop(l1) THEN                                    ' Ignore Joins to the Top line
               sLine = l2 + 1: sCol = 0                           ' Skip onward
               PTBL.FoundFailed = 3                               ' New search needed
               MExitMeth                                          '
            END IF                                                '
            L1Txt = LTxtG(l1)                                     ' Get L1 text
            L1Clr = LAttrG(l1)                                    ' Get L1 Attr

            L2Txt = lclChg + MID$(LTxtG(l2), k + 1)               ' Get text
            L2Clr = REPEAT$(LEN(lclChg), CHR$$(AttrAsc)) + MID$(LAttrG(l2), k + 1)  ' And Attr
            sLine = l1: sCol = 2                                  ' Set resume point

         ELSE                                                     ' Else, RM join
            l1 = i                                                ' L1 points at this line
            l2 = me.CRPFwd(%MOData, i, 1)                         ' L2 points at next line
            IF l2 = LastLine THEN                                 ' Ignore Joins to the Bottom line
               PTBL.FoundFailed = 0                               '
               METHOD = %True                                     ' Tell caller to stop
               MExitMeth                                          '
            END IF                                                '
            PTBL.FoundFailed = 3                                  ' New search needed

            L1Txt = LEFT$(LTxtG(l1), j - 1) + lclChg              ' Get L1 text
            L1Clr = LAttrG(l1)                                    ' Get L1 Attr
            L1Clr = LEFT$(L1Clr, j - 1) + REPEAT$(LEN(lclChg), CHR$$(AttrAsc))   '

            L2Txt = LTxtG(l2)                                     ' Get text
            L2Clr = LAttrG(l2)                                    ' And Attr
            sLine = l1: sCol = 0                                  ' Set resume point
         END IF                                                   '

         me.LFlagBitOff(l1, %EQChange)                            ' Reset ==CHG>
         me.LFlagBitOff(l2, %EQChange)                            '
         me.ModSet(l1)                                            ' Remember we changed something
         IF IsLPopped(l2) THEN                                    ' Did L2 just Pop?
            me.LFlagBitOff(l1, %Invisible)                        ' Ditto it to L1
            me.LFlagBitOn(l1, %Popped)                            '
         END IF                                                   '

         me.LTxtSet(l1, L1Txt + L2Txt)                            ' Swap in combined lines
         IF L(L1).LLbl = $BlankLNo THEN LLblS(l1) = TRIM$(L(l2).LLbl)   ' Copy the .LLbl if it's blank
         IF LTagG(l1) = $BlankLNo THEN LTagS(l1) = TRIM$(LTagG(l2))  ' Copy the :tag if it's blank
         IF LHndlG(l1) = 0 THEN LHndlS(l1) = LHndlG(l2)           ' Copy the Handle if it's blank
         me.UpdLControl(l1)                                       '
         LAttrS(l1) = L1Clr + L2Clr                               ' Use it
         me.AttrScan(l1)                                          ' Recolorize

         me.lTxtFree(l2)                                          ' Remove the 2nd line
         me.LEntDel(l2)                                           '
         DECR LastLine: DECR LastReal                             ' Adjust LastLine and LastReal
         me.AdjustPending(l1, -1, 0)                              ' Adjust pending stuff
         PTBL.FindRngEnd = PTBL.FindRngEnd - 1                    ' Adjust range
         me.CurSetReq(%Position, l1, 1, %True)                    ' Set cursor set attempt

         MExitMeth                                                '

      GetPrevAttr:                                                '
         '-----------------------------------------------------------------------------------------+
         '- First see if any existing highlighting on the found string                             |
         '-----------------------------------------------------------------------------------------+
         AttrAsc = 0                                              '
         cTxt = LAttrG(i)                                         ' Get Attr line
         CWrk = MID$(ctxt, j, k)                                  ' Get Attr char for the found field
         IF CWrk = REPEAT$(k, LEFT$(CWrk, 1)) THEN                ' All the same color?
            AttrAsc = ASC(LEFT$(Cwrk, 1))                         ' Set AttrAsc to the current state
         END IF                                                   '
         RETURN                                                   '
      END METHOD                                                  '

      METHOD LAllocTxt(ln AS LONG)                                '
      '--------------------------------------------------------------------------------------------+
      '- Alloc a txt entry to this line                                                            |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         MEntry                                                   '
         i = me.BStackAlloc                                       ' Allocate a buffer
         T(i) = ""                                                ' Null the string
         L(ln).LTxtIX = i                                         ' Remember the index in the L() entry
         L(ln).LTxt = VARPTR(T(i))                                ' Point L.Txt to the dynamic String
         TW(i) = ""                                               ' Null the string
         L(ln).LAttrIX = i                                        ' Remember the index in the L() entry
         L(ln).LAttr = VARPTR(TW(i))                              ' Point L.Txt to the dynamic String
         MExit                                                    '
      END METHOD                                                  '

      METHOD MarkKill()                                           '
      '--------------------------------------------------------------------------------------------+
      '- UnMark and kill any text selection                                                        |
      '--------------------------------------------------------------------------------------------+
         IF IsMarkDrawn THEN                                      ' Blank any hi-lite
            CaretDestroy                                          '
            GRAPHIC SET MIX %MIX_NOT                              '
            GRAPHIC BOX (MarkRectS.Left, MarkRectS.Top) - (MarkRectS.Right, MarkRectS.Bottom), 0, %WHITE, -1   '
            OffMarkDrawn                                          '
            OffMarkDrawn                                          '
            GRAPHIC REDRAW                                        '
            CaretCreate                                           '
            DoCursor                                              ' Get cursor back
            CaretShow                                             '
         END IF                                                   '
         OffMarkActive                                            '
         '--------------------------------------------------------------------------------------------+
         '- UnMark and kill any misc selection                                                        |
         '--------------------------------------------------------------------------------------------+
         IF IsMiscDrawn THEN                                      ' Blank any hi-lite
            CaretDestroy                                          '
            GRAPHIC SET MIX %MIX_NOT                              '
            GRAPHIC BOX (MiscRectS.Left, MiscRectS.Top) - (MiscRectS.Right, MiscRectS.Bottom), 0, %WHITE, -1   '
            OffMiscDrawn                                          '
            GRAPHIC REDRAW                                        '
            CaretCreate                                           '
            DoCursor                                              ' Get cursor back
            CaretShow                                             '
         END IF                                                   '
         OffMiscActive: MiscZone = 0                              '
      END METHOD                                                  '

      METHOD MarkScr()                                            '
      '--------------------------------------------------------------------------------------------+
      '- Mark the selected area on the screen                                                      |
      '--------------------------------------------------------------------------------------------+
      LOCAL tl, tt, tr, tb, vb, i AS LONG, char AS STRING         '
         MEntry                                                   '
         IF ISFALSE IsMarkActive OR IsFMTab THEN MExitMeth        ' Just in case
         SlecSCol = MarkRect.Left                                 ' Save for permanent select area
         SlecECol = MarkRect.Right                                '
         SlecSLin = VAL(LLNumG(MarkRect.Top))                     ' Save lines as external references
         SlecELin = VAL(LLNumG(MarkRect.Bottom))                  '
         OnSlecSet                                                ' Say we've got an active set
         OnSlecActive                                             '

         FOR i = @P.PData1 TO 300                                 ' Locate line on visible bottom of screen
            IF i > @P.PBottom THEN EXIT FOR                       ' Watch for end of panel
            IF @P.PS(i) <> 0 THEN vb = i ELSE EXIT FOR            '
         NEXT i                                                   '
         tl = MAX(MarkRect.Left - @P.POffset + @P.PGapCol, @P.PDataCol) ' Calc char screen loc of left side
         tr = MIN(MarkRect.Right - @P.POffset + @P.PGapCol, @P.PRight)  ' Calc char screen loc of right side
         tt = me.sSearch(MarkRect.Top)                            ' Calc char screen loc of top
         tb = me.sSearch(MarkRect.Bottom)                         ' Calc char screen loc of bottom
         IF tt = -1 AND tb = -1 THEN MExitMeth                    ' Above the screen totally, just exit
         IF tt = -2 THEN MExitMeth                                ' Below the screen totally, just exit
         IF tt = -1 AND tb = -2 THEN                              ' Extends above and below the screen?
            tt = @P.PData1: tb = vb                               ' Do the entire height
         ELSEIF tt = -1 AND tb > 0 THEN                           ' Extends from above into the screen?
            tt = @P.PData1                                        ' Do top down to end line
         ELSEIF tt > 0 AND TB = -2 THEN                           ' Extends from middle of screen past the bottom
            tb = vb                                               ' Do from start line to bottom
         ELSEIF tt > 0 AND tb > 0 THEN                            ' Extends for part of screen
            '-                                                    ' tt and tb should be OK
         END IF                                                   '
         IF tl > @P.PRight THEN MExitMeth                         ' Right of the screen totally
         IF tr < tl THEN MExitMeth                                '
         CaretDestroy                                             ' Turn cursor off

         GRAPHIC SET MIX %MIX_NOT                                 '
         IF IsMarkDrawn THEN                                      ' Do we need to get rid of an old one?
            GRAPHIC BOX (MarkRectS.Left, MarkRectS.Top) - (MarkRectS.Right, MarkRectS.Bottom), 0, %WHITE, -1   '
            OffMarkDrawn                                          '
         END IF                                                   '
         MarkRectS.Left = (tl - 1) * gFontWidth + %GLM            ' Build new location
         MarkRectS.Right = tr * gFontWidth + %GLM                 '
         MarkRectS.Top = (tt - 1) * gFontHeight                   '
         MarkRectS.Bottom = tb * gFontHeight                      '
         GRAPHIC BOX (MarkRectS.Left, MarkRectS.Top) - (MarkRectS.Right, MarkRectS.Bottom), 0, %WHITE, -1   '
         GRAPHIC REDRAW                                           '
         OnMarkDrawn                                              '
         CaretCreate                                              '
         DoCursor                                                 ' Get cursor back
         CaretShow                                                '
         DoStatusBar($SBSelect)                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD MarkReDraw(lno AS LONG)                              '
      '--------------------------------------------------------------------------------------------+
      '- Redraw Mark lines for a single screen line                                                |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG, u AS STRING                                '
         MEntry                                                   '
         IF (FCB.MarkFlag AND ISFALSE IsPTypeMode AND ISNOTNULL(TRIM$(FCB.MarkLine))) OR _   ' Column marking
            (FCB.TabBNDS  AND ISFALSE IsPTypeMode AND ISNOTNULL(TRIM$(FCB.TabsLine))) THEN   ' TabBNDS mode
            i = 1: u = IIF$(FCB.TabBnds, me.TabsSimple(@P.POffSet + 200), FCB.MarkWorking)   '
            IF FCB.TabBNDS THEN GRAPHIC STYLE 2                   ' Set style to dotted
            DO                                                    '
               i = INSTR(i, u, "*")                               ' Look for next marker
               IF i = 0 THEN EXIT DO                              '
               IF i >= @P.POffset + 1 AND i <= @P.POffset + @P.PDataLen THEN  ' Within screen boundary
                  GRAPHIC SET MIX %MIX_COPYSRC                    '
                  GRAPHIC LINE ((i - 1 + gLNPadCol - @P.POffset) * gFontWidth + %GLM - 1, (lno - 1) * gFontHeight) - ((i - 1 + gLNPadCol - @P.POffset) * gFontWidth + %GLM - 1, lno * gFontHeight), gENV.cMarkLine   '
               END IF                                             '
               INCR i                                             '
            LOOP                                                  '
            GRAPHIC STYLE 0                                       '
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD MarkSave()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Save the Mark line by updating the CFG file                                               |
      '--------------------------------------------------------------------------------------------+
         OffMarkAFlag                                             ' Clear flag that got us here
         FCB.MarkLine = TP.MarkLine                               ' Set it into the Profile
         DoProfMsg("New MARK values established")                 '
      END METHOD                                                  '

      METHOD MarkStart(trow AS LONG, tcol AS LONG, StartRow AS LONG, StartCol AS LONG) '
      '--------------------------------------------------------------------------------------------+
      '- See if starting a mouse mark area                                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL j AS LONG                                             '
         IF tCol > @P.PGapCol AND tRow >= @P.PData1 AND _         ' Make sure its safe
            tRow <= @P.PBottom AND FCB.HexMode = &1 AND ISFALSE IsFMTab THEN  ' In true text area?
            IF IsLXClude(@P.PS(tRow)) OR _                        ' Can't start on an X'd line or Top/Bottom
               IsLTop(@P.PS(tRow)) OR _                           '
               IsLBottom(@P.PS(tRow)) THEN DoBeep: EXIT METHOD    '
            me.MarkKill                                           ' Kill any active text block select
            me.MarkKill                                           ' Kill any active cmd  select
            MarkRect.Left = tCol + @P.POffset - @P.PGapCol        ' Remember starting x/y of Select frame
            MarkRect.Top = @P.PS(tRow)                            '
            MarkRect.Right = MarkRect.Left                        '
            MarkRect.Bottom = MarkRect.Top                        '
            IF IsSwapActive THEN                                  ' If a SWAP is active
               IF MarkRect.Top >= SwapSLin AND MarkRect.Top <= SwapELin THEN  ' Test start line
                  IF MarkRect.Left >= SwapSCol AND MarkRect.Left <= SwapECol THEN DoBeep: EXIT METHOD ' And horizontally?
               END IF                                             '
               j = SwapLines - 1                                  ' Get number of data lines in Swap group
               DO WHILE j                                         ' See if enough lines here
                  IF IsLData(MarkRect.Bottom) THEN                ' If a data line
                     DECR j                                       ' Reduce count
                  END IF                                          '
                  INCR MarkRect.Bottom                            ' Next line
                  IF IsLBottom(MarkRect.Bottom) THEN DoBeep: EXIT METHOD   '
               LOOP                                               '
               IF MarkRect.Bottom >= SwapSLin AND MarkRect.Bottom <= SwapELin THEN  ' Test start line
                  IF MarkRect.Right >= SwapSCol AND MarkRect.Right <= SwapECol THEN DoBeep: EXIT METHOD  ' And horizontally?
               END IF                                             '
            END IF                                                '
            StartRow = MarkRect.Top                               '
            StartCol = MarkRect.Left                              '
            OnMarkActive                                          '

         '-----------------------------------------------------------------------------------------+
         '- In the Cmd area, start a Cmd highlight                                                 |
         '-----------------------------------------------------------------------------------------+
         ELSEIF tRow = @P.PTop AND tCol < @P.PScrHdr AND tCol >= @p.PCmdCol THEN  ' Make sure its safe
            me.MarkKill                                           ' Kill any active text block select
            me.MarkKill                                           ' Kill any active cmd  select
            MiscRect.Left = tCol - @P.PCmdCol + 1 + @P.PCOffset   ' Remember starting x/y of Select frame
            MiscRect.Right = MiscRect.Left                        '
            StartRow = @P.PTop                                    '
            StartCol = MiscRect.Left                              '
            MiscZone = %CCmd                                      ' Which area are we marking
            OnMiscActive                                          '
         END IF                                                   '
         gfLeftDown = %True                                       '
      END METHOD                                                  '

      METHOD MaskSave()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Save the Mask line by updating the CFG file                                               |
      '--------------------------------------------------------------------------------------------+
         OffMaskAFlag                                             ' Clear flag that got us here
         FCB.MaskLine = TP.MaskLine                               ' Set it into the Profile
         DoProfMsg("New MASK values established")                 '
      END METHOD                                                  '

      METHOD MEditListSet(BYVAL ix AS LONG, fn AS STRING)         '
         IF ix > UBOUND(MEditList()) THEN _                       '
            REDIM PRESERVE MEditList(1 TO 2 * UBOUND(MEditList())) AS INSTANCE STRING  '
         MEditList(ix) = fn                                       '
      END METHOD                                                  '

      METHOD MEditListGet(BYVAL ix AS LONG) AS STRING: METHOD = MEditList(ix): END METHOD '

      METHOD MEditFlagSet(BYVAL ix AS LONG, vl AS LONG)           '
         IF ix > UBOUND(MEditFlag()) THEN _                       '
            REDIM PRESERVE MEditFlag(1 TO 2 * UBOUND(MEditFlag())) AS INSTANCE LONG '
         MEditFlag(ix) = vl                                       '
      END METHOD                                                  '

      METHOD MEditFlagGet(BYVAL ix AS LONG) AS LONG: METHOD = MEditFlag(ix): END METHOD   '

      METHOD MeditTbl(func AS STRING, fn AS STRING) AS LONG       '
      '--------------------------------------------------------------------------------------------+
      '- Manipulate the MEdit table                                                                |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, k AS LONG                                       '
         MEntry                                                   '
         METHOD = 0                                               ' Default RC
         SELECT CASE AS CONST$ func                               ' What function?
            CASE "S"                                              ' Search
               IF MEditCount = 0 THEN MExitMeth                   ' No table, then not found
               FOR i = 1 TO MEditCount                            ' Search table then
                  IF IsEQ(fn, me.MEditListGet(i)) THEN METHOD = i: MExitMeth  '
               NEXT i                                             '

            CASE "A"                                              ' Add, Search should have failed already
               MEditCount += 1                                    ' Bump
               me.MEditListSet(MEditCount, fn)                    ' Add the new filename
               me.MEditFlagSet(MEditCount, %False)                ' Clear it's flag
               METHOD = MEditCount                                ' Pass back count (index)

            CASE "D"                                              ' Delete
               IF MEditCount = 0 THEN MExitMeth                   ' No table, then not found
               k = 0                                              ' Found index
               FOR i = 1 TO MEditCount                            ' Search table then
                  IF IsEQ(fn, me.MEditListGet(i)) THEN _          ' Got it?
                     k = i: EXIT FOR                              ' Save found entry
               NEXT i                                             '
               FOR i = k TO MEditCount - 1                        ' Ripple table down
                  me.MEditListSet(i, me.MEditListGet(i + 1))      '
                  me.MEditFlagSet(i, me.MEditFlagGet(i + 1))      '
               NEXT i                                             '
               MEditCount -= 1                                    '
               METHOD = k                                         ' Pass back deleted entry number

            CASE "I"                                              ' Get Index from line number
               FOR i = VAL(fn) TO 1 STEP -1                       ' BackScan
                  j = LMIXG(i)                                    ' Get line's MIX value
                  IF j <> 0 THEN METHOD = j: MExitMeth            ' Found, we're done, pass it back
               NEXT i                                             '
               METHOD = 1: MExitMeth                              ' In case not MEdit mode

         END SELECT                                               '
         MExit                                                    '
      END METHOD                                                  '

      METHOD MiscMark()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Mark a misc area                                                                          |
      '--------------------------------------------------------------------------------------------+
      LOCAL tl, tt, tr, tb AS LONG, char AS STRING                '
         MEntry                                                   '
         IF ISFALSE IsMiscActive THEN MExitMeth                   ' Just in case
         CaretDestroy                                             '
         GRAPHIC SET MIX %MIX_NOT                                 '
         IF IsMiscDrawn THEN                                      ' Do we need to get rid of an old one?
            GRAPHIC BOX (MiscRectS.Left, MiscRectS.Top) - (MiscRectS.Right, MiscRectS.Bottom), 0, %WHITE, -1   '
            OffMiscDrawn                                          '
         END IF                                                   '

         SELECT CASE AS LONG MiscZone                             ' Which area are we marking
            CASE %CCmd                                            ' Command line
               tl = MAX(MiscRect.Left - @P.PCOffset + @P.PCmdCol - 1, @P.PCmdCol)   ' Calc char screen loc of left side
               tr = MIN(MiscRect.Right - @P.PCOffset + @P.PCmdCol - 1, @P.PScrHdr)  ' Calc char screen loc of right side
               tt = @P.PTop                                       ' Calc char screen loc of top
               tb = @P.PTop                                       ' Calc char screen loc of bottom
               IF tr < tl THEN MExitMeth                          '
               MiscRectS.Left = (tl - 1) * gFontWidth + %GLM      ' Build new location
               MiscRectS.Right = tr * gFontWidth + 1              '
               MiscRectS.Top = (tt - 1) * gFontHeight             '
               MiscRectS.Bottom = tb * gFontHeight                '

            CASE %CFPath                                          ' FM Path line
               tl = gFM_Path_Left + MiscRect.Left - 1             ' Calc char screen loc of left side
               tr = gFM_Path_Left + MiscRect.Right - 1            ' Calc char screen loc of right side
               tt = gFM_Path_Line                                 ' Calc char screen loc of top
               tb = gFM_Path_Line                                 ' Calc char screen loc of bottom
               IF tr < tl THEN MExitMeth                          '
               MiscRectS.Left = (tl - 1) * gFontWidth + %GLM      ' Build new location
               MiscRectS.Right = tr * gFontWidth + 1              '
               MiscRectS.Top = (tt - 1) * gFontHeight             '
               MiscRectS.Bottom = tb * gFontHeight                '

            CASE %CFMask                                          ' FM Mask line
               tl = gFM_Mask_Left + MiscRect.Left - 1             ' Calc char screen loc of left side
               tr = gFM_Mask_Left + MiscRect.Right - 1            ' Calc char screen loc of right side
               tt = gFM_Mask_Line                                 ' Calc char screen loc of top
               tb = gFM_Mask_Line                                 ' Calc char screen loc of bottom
               IF tr < tl THEN MExitMeth                          '
               MiscRectS.Left = (tl - 1) * gFontWidth + %GLM      ' Build new location
               MiscRectS.Right = tr * gFontWidth + 1              '
               MiscRectS.Top = (tt - 1) * gFontHeight             '
               MiscRectS.Bottom = tb * gFontHeight                '

         END SELECT                                               '
         GRAPHIC BOX (MiscRectS.Left, MiscRectS.Top) - (MiscRectS.Right, MiscRectS.Bottom), 0, %WHITE, -1   '
         GRAPHIC REDRAW                                           '
         OnMiscDrawn                                              '
         CaretCreate                                              '
         DoCursor                                                 ' Get cursor back
         CaretShow                                                '
         MExit                                                    '
      END METHOD                                                  '

      METHOD OffsetAdd (amt AS LONG): @P.POffset += amt: END METHOD  '
      METHOD OffsetSub (amt AS LONG): @P.POffset = MAX(0, @P.POffset - amt): END METHOD   '
      METHOD COffsetAdd (amt AS LONG): @P.PCOffset += amt: END METHOD   '
      METHOD COffsetSub (amt AS LONG): @P.PCOffset = MAX(0, @P.PCOffset - amt): END METHOD   '

      METHOD OverlayText(SOURCE AS STRING, Dest AS STRING) AS STRING '
      '--------------------------------------------------------------------------------------------+
      '- Overlay text from one string to another                                                   |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      LOCAL TX AS STRING, lclRBnd AS LONG                         '
         MEntry                                                   '
         TX = Dest                                                ' Copy Dest as a work string
         lclRBnd = FCB.BndRight: IF lclRBnd = 0 THEN lclRBnd = MaxLength   ' Get correct right bounds
         IF LEN(SOURCE) > LEN(TX) THEN _                          ' The Source string is longer
            TX = LSET$(TX, LEN(SOURCE))                           ' Make the Dest as long as the Source

         FOR i = 1 TO LEN(SOURCE)                                 ' Loop through length of Source string
            IF FCB.BndLeft > 1 OR FCB.BndRight > 0 THEN           ' BNDS active?
               IF i >= FCB.BndLeft AND i <= lclRBnd THEN          ' Yes, current column within BNDS?
                  IF MID$(TX, i, 1) = " " THEN MID$(TX, i, 1) = MID$(SOURCE, i, 1)  ' Overlay if Dest is blank
               END IF                                             '
            ELSE                                                  ' No BNDS
               IF MID$(TX, i, 1) = " " THEN MID$(TX, i, 1) = MID$(SOURCE, i, 1)  ' Overlay if Dest is blank
            END IF                                                '
         NEXT I                                                   '

         METHOD = TX                                              ' Pass back the result
         MExit                                                    '
      END METHOD                                                  '

      METHOD OverlayTextDel(SOURCE AS STRING, Dest AS STRING) AS STRING '
      '--------------------------------------------------------------------------------------------+
      '- Overlay text from one string to another, return whether all data merged or not            |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      LOCAL STxt, DTxt AS STRING, lclRBnd AS LONG                 '
         MEntry                                                   '
         OffOvrTextDel                                            ' Start as saying no error occurred
         lclRBnd = FCB.BndRight: IF lclRBnd = 0 THEN lclRBnd = MaxLength   ' Get correct right bounds
         DTxt = Dest: STxt = SOURCE                               ' Copy to work strings
         IF LEN(STxt) > LEN(DTxt) THEN _                          ' The Source string is longer
            DTxt = LSET$(DTxt, LEN(STxt))                         ' Make the Dest as long as the Source

         FOR i = 1 TO LEN(STxt)                                   ' Loop through length of Source string
            IF FCB.BndLeft > 1 OR FCB.BndRight > 0 THEN           ' BNDS active?
               IF i >= FCB.BndLeft AND i <= lclRBnd THEN          ' Yes, current column within BNDS?
                  IF MID$(DTxt, i, 1) = " " OR MID$(DTxt, i, 1) = MID$(STxt, i, 1) THEN   '
                     MID$(DTxt, i, 1) = MID$(STxt, i, 1)          ' Overlay if Dest is blank or = char
                     MID$(STxt, i, 1) = " "                       ' Blank the char in the source string
                  END IF                                          '
               END IF                                             '
            ELSE                                                  ' No bounds, do it the simple way
               IF MID$(DTxt, i, 1) = " " OR MID$(DTxt, i, 1) = MID$(STxt, i, 1) THEN   '
                  MID$(DTxt, i, 1) = MID$(STxt, i, 1)             ' Overlay if Dest is blank
                  MID$(STxt, i, 1) = " "                          ' Blank the char in the source string
               END IF                                             '
            END IF                                                '
         NEXT I                                                   '

         METHOD = DTxt                                            ' Pass back the result
         IF ISNOTNULL(TRIM$(Stxt)) THEN OnOvrTextDel              ' If Source not all merged, then flag an error
         MExit                                                    '
      END METHOD                                                  '

      METHOD OverlayTextRepl(SOURCE AS STRING, Dest AS STRING) AS STRING   '
      '--------------------------------------------------------------------------------------------+
      '- Overlay text replace from one string to another                                           |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      LOCAL TX AS STRING, lclRBnd AS LONG                         '
         MEntry                                                   '
         TX = Dest                                                ' Copy Dest as a work string
         lclRBnd = FCB.BndRight: IF lclRBnd = 0 THEN lclRBnd = MaxLength   ' Get correct right bounds
         IF LEN(SOURCE) > LEN(TX) THEN _                          ' The Source string is longer
            TX = LSET$(TX, LEN(SOURCE))                           ' Make the Dest as long as the Source

         FOR i = 1 TO LEN(SOURCE)                                 ' Loop through length of Source string
            IF FCB.BndLeft > 1 OR FCB.BndRight > 0 THEN           ' BNDS active?
               IF i >= FCB.BndLeft AND i <= lclRBnd THEN          ' Yes, current column within BNDS?
                  IF MID$(SOURCE, i, 1) <> " " THEN _             ' If source is non-blank
                     MID$(TX, i, 1) = MID$(SOURCE, i, 1)          ' Copy it
               END IF                                             '
            ELSE                                                  ' No BNDS
               IF MID$(SOURCE, i, 1) <> " " THEN _                ' If source is non-blank
                  MID$(TX, i, 1) = MID$(SOURCE, i, 1)             ' Copy it
            END IF                                                '
         NEXT I                                                   '

         METHOD = TX                                              ' Pass back the result
         MExit                                                    '
      END METHOD                                                  '

      METHOD PanelSet(which AS LONG, Tp AS LONG, Bt AS LONG, Lf AS LONG, Rt AS LONG, Typ AS STRING, CalcPct AS LONG)
      '--------------------------------------------------------------------------------------------+
      '- Setup all the internal Panel locations and sizes                                          |
      '--------------------------------------------------------------------------------------------+
      LOCAL Px AS PanelCtl PTR                                    '
         Px = IIF(which = 1, VARPTR(P1), VARPTR(P2))              ' Setup which panel
         @Px.PPanelType = Typ                                     ' Panel type (N/H/V)
         @Px.PTop = Tp                                            ' Panel top
         @Px.PBottom = Bt                                         '       Bottom
         @Px.PLeft = Lf                                           '       Left
         @Px.PRight = Rt                                          '       Right
         @Px.PPanelWidth = @Px.PRight - @Px.PLeft + 1             '       Panel Width
         @Px.PPanelHeight = @Px.PBottom - @Px.PTop + 1            '       Panel Height
         @Px.PCmdLen = @Px.pPanelWidth - 24                       '       |Command > | and | Scroll > | and 4 char scroll field = 24
         @Px.PDataLen = @Px.PPanelWidth - gLNPadCol               '       Data Length
         @Px.PData1 = @Px.PTop + 2                                '       First data line
         @Px.PDLines = @Px.PBottom - @Px.PData1 + 1               '       # of data lines
         @Px.PCmdCol = @Px.PLeft + 10                             '       Command > position
         @Px.PScrHdr = @Px.PRight - 12                            '       Scroll > position
         @Px.PScrData = @Px.PRight - 3                            '       Scroll > nnnn position
         @Px.PGapCol = @Px.PLeft + gLNPadCol - 1                  '       Gap Column
         @Px.PDataCol = @Px.PGapCol + 1                           '       Data Column
         @Px.PLastWidth = gENV.ScrWidth                           '       Last used ScrWidth
         @Px.PLastHeight = gENV.ScrHeight                         '       Last used ScrHeight
         IF CalcPct THEN                                          ' Should we calc Pct?
            IF Typ = "N" THEN                                     ' Calc the % usage
               @Px.PPanelPct = 100                                '                             100 % for Normal
            ELSEIF Typ = "H" THEN                                 '
               @Px.PPanelPct = ((@Px.PPanelHeight) / (gENV.ScrHeight - gENV.PFKShow - 1)) * 100   ' % ScrHeight for Vertical
            ELSE                                                  '
               @Px.PPanelPct = ((@Px.PPanelWidth) / (gENV.ScrWidth - 1)) * 100                    ' % ScrWidth for Horizontal
            END IF                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD PanelColsSet(Which AS LONG, Cols AS LONG)
      '--------------------------------------------------------------------------------------------+
      '- Adjust the Panel data for the current COLS setting                                        |
      '--------------------------------------------------------------------------------------------+
      LOCAL Px AS PanelCtl PTR                                    '
         Px = IIF(Which = 1, VARPTR(P1), VARPTR(P2))              ' Setup which panel
         IF @Px.PData1 = @Px.PTop + 2 THEN                        ' Is First data line non-COLS
            IF Cols THEN                                          ' Going to COLS mode?
               INCR @Px.PData1                                    ' Adjust for it
               DECR @Px.PDLines                                   '
            END IF                                                '
         END IF                                                   '
         IF @Px.PData1 = @Px.PTop + 3 THEN                        ' Is First data line in COLS mode?
            IF ISFALSE Cols THEN                                  ' Leaving COLS mode?
               DECR @Px.PData1                                    ' Adjust for it
               INCR @Px.PDLines                                   '
            END IF                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD pCmdCharRep (posit AS LONG, char AS STRING)          '
         IF posit > LEN(pCommand) THEN                            ' If needed, lengthen the string
            pCommand += SPACE$(posit - LEN(pCommand))             '
         END IF                                                   '
         MID$(pCommand, posit, 1) = char                          ' Stuff in the character
      END METHOD                                                  '

      METHOD PicSetWord():    PIC.WORD_WORD_changed = 1:      END METHOD   '
      METHOD PicSetCharSet(): PIC.CharSet_changed = 1:        END METHOD   '
      METHOD PicSetAll():     PIC.defaults_initialized = 0:   END METHOD   '

      METHOD PicInit()                                            '
      '--------------------------------------------------------------------------------------------+
      '- initialize class-specific data areas for Picture processing                               |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, ASCII AS LONG, lclCharSet AS STRING                '
         MEntry                                                   '
         IF PIC.defaults_initialized = 0 THEN                     ' Do all?
            FOR i = 0 TO 255                                      ' Reset tables
               PIC.data_mask(i) = 0: PIC.pic_mask(i) = 0          '
            NEXT i                                                '
            PIC.WORD_WORD_changed = 1                             ' Force rebuild of WORD mapping
            PIC.CharSet_changed = 1                               ' Force rebuild of P'.' mapping
            PIC.mapping_initialized = 0                           ' Force basic initialize
            PIC.defaults_initialized = 1                          ' Do basic class initialization just once
         END IF                                                   '
         IF PIC.mapping_initialized = 0 THEN                      '

            FOR ASCII = 0 TO 255                                  ' Create mapping between data char and characterizing flag bits
               PIC.data_mask(ASCII) = (%PicMap_Any OR %PicMap_NonBlank) ' Map P'=' and also initialize other bits to 0
               IF (ASCII >= ASC("0")) AND (ASCII <= ASC("9")) THEN' Map P'#' and P'-'
                  PIC.data_mask(ASCII) OR= %PicMap_Numeric        '
               ELSE                                               '
                  PIC.data_mask(ASCII) OR= %PicMap_NonNumeric     '
               END IF                                             '
            NEXT                                                  '
            PIC.data_mask(ASC(" ")) XOR= %PicMap_NonBlank         ' Map P'^' and P'' (unmap only position which isn't nonblank)
            FOR I = 1 TO LEN(FCB.ChrUpper)                        ' Map P'>' and P'@'
               ASCII = ASC(FCB.ChrUpper, I)                       '
               PIC.data_mask(ASCII) OR= %PicMap_Upper             '
               PIC.data_mask(ASCII) OR= %PicMap_Alpha             '
            NEXT                                                  '
            FOR I = 1 TO LEN(FCB.ChrLower)                        ' Map P'<' and P'@'
               ASCII = ASC(FCB.ChrLower, I)                       '
               PIC.data_mask(ASCII) OR= %PicMap_Lower             '
               PIC.data_mask(ASCII) OR= %PicMap_Alpha             '
            NEXT                                                  '
            FOR ASCII = 0 TO 255                                  ' Map P'$'
               IF (PIC.data_mask(ASCII) AND (%PicMap_Alpha OR %PicMap_Numeric)) = 0 THEN  '
                  IF ASCII <> ASC(" ") THEN                       ' (undocumented) IBM ISPF P'$' does not match blanks
                     PIC.data_mask(ASCII) OR= %PicMap_Special     ' characters that are not P'@' or P'#' are P'$'
                  END IF                                          '
               END IF                                             '
            NEXT                                                  '

            FOR ASCII = 0 TO 255                                  ' Create picture map mask array to categorize the picture codes
               PIC.pic_mask(ASCII) = %PicMap_Literal              '
            NEXT                                                  '

            PIC.pic_mask(ASC("=")) = %PicMap_Any                  '
            PIC.pic_mask(ASC("^")) = %PicMap_NonBlank             '
            PIC.pic_mask(170)      = %PicMap_NonBlank             '  hex AA not sign (OEM)
            PIC.pic_mask(172)      = %PicMap_NonBlank             '  hex AC not sign (Ansi)
            PIC.pic_mask(ASC(".")) = %PicMap_NonDisplay           '
            PIC.pic_mask(ASC("#")) = %PicMap_Numeric              '
            PIC.pic_mask(ASC("-")) = %PicMap_NonNumeric           '
            PIC.pic_mask(ASC("@")) = %PicMap_Alpha                '
            PIC.pic_mask(ASC("<")) = %PicMap_Lower                '
            PIC.pic_mask(ASC(">")) = %PicMap_Upper                '
            PIC.pic_mask(ASC("$")) = %PicMap_Special              '
            PIC.pic_mask(ASC("&")) = %PicMap_WORD_Char            '
            PIC.pic_mask(ASC("%")) = %PicMap_Non_Word_Char        '
            PIC.pic_mask(ASC("{")) = %PicMap_LMargin              '
            PIC.pic_mask(ASC("}")) = %PicMap_RMargin              '
            FOR ASCII = 0 TO 255                                  ' Note literal alphabetic chars subject to CASE C/T handling
               IF (PIC.data_mask(ASCII) AND %PicMap_Alpha) THEN   '
                  PIC.pic_mask(ASCII) = %PicMap_LiteralAlpha      '
               END IF                                             '
            NEXT                                                  '
            PIC.pic_mask(ASC("\")) = %PicMap_Escape               '
            PIC.mapping_initialized = 1                           '
         END IF                                                   '

         IF PIC.WORD_WORD_changed THEN                            ' If a change to the WORD string, redo maps for P'%' and P'&'
            FOR ASCII = 0 TO 255                                  ' Clear all WORD/Non-WORD bits first
               PIC.data_mask(ASCII) AND= (NOT (%PicMap_WORD_Char OR %PicMap_Non_WORD_Char))  '
            NEXT                                                  '
            FOR I = 1 TO LEN(FCB.WordStr)                         ' Mark the WORD chars
               ASCII = ASC(FCB.WordStr, I)                        '
               PIC.data_mask(ASCII) OR= %PicMap_WORD_Char         '
            NEXT                                                  '
            FOR ASCII = 0 TO 255                                  ' Mark the non-WORD chars as WORD chars
               IF (PIC.data_mask(ASCII) AND %PicMap_WORD_Char) = 0 THEN '
                   PIC.data_mask(ASCII) OR= %PicMap_Non_WORD_Char '
               END IF                                             '
            NEXT                                                  '
            PIC.WORD_WORD_changed = 0                             '
         END IF                                                   '

         IF PIC.CharSet_changed THEN                              ' If a change to the Charset string, redo maps for P'.'
            lclCharset = gENV.PDotString                          ' Get the Invalid characters
            FOR ASCII = 0 TO 255                                  ' Set all %PicMap_NonDisplay first
               PIC.data_mask(ASCII) AND= (&HFFFF?? - %PicMap_NonDisplay)   ' Remove all non-display bits
            NEXT                                                  '
            FOR I = 1 TO LEN(lclCharSet)                          ' Set non-display for the PDotString characters
               ASCII = ASC(lclCharSet, I)                         '
               PIC.data_mask(ASCII) OR= %PicMap_NonDisplay        '
            NEXT                                                  '
            PIC.CharSet_changed = 0                               '
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD PicSearch(BYREF arg_data AS STRING, BYREF arg_pic AS STRING, BYREF arg_start_col AS LONG, _ '
                          BYREF ret_col  AS LONG, BYREF ret_len  AS LONG)  '
      '--------------------------------------------------------------------------------------------+
      '- Perform Picture type search                                                               |
      '--------------------------------------------------------------------------------------------+
      LOCAL len_true_pic, scan_first_col, scan_last_col, scan_incr, scan_col, curr_data_mask, j, k AS LONG  '
      LOCAL lclPic AS STRING                                      '
      REGISTER curr_pic_mask AS LONG                              '
      REGISTER i AS LONG                                          '
      LOCAL dp, P AS BYTE POINTER                                 '
         MEntry                                                   '
         ret_col = 0                                              ' Default return values
         ret_len = 0                                              '
         lclPic = arg_pic                                         ' Copy the picture

         '-----------------------------------------------------------------------------------------+
         '- Fudge mask for { usage                                                                 |
         '-----------------------------------------------------------------------------------------+
         IF INSTR(lclPic, "{") > 0 THEN                           ' Got a leading { picture?
            lclPic = MID$(lclPic, 2)                              ' Remove it
            IF LEFT$(arg_data, 1) = " " THEN                      ' And some leading spaces?
               lclPic = SPACE$(VERIFY(arg_data, " ") - 1 - (VERIFY(lclPic, " ") - 1) ) + lclPic ' Rebuild picture string
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Fudge mask for } usage                                                                 |
         '-----------------------------------------------------------------------------------------+
         IF INSTR(arg_pic, "}") > 0 THEN                          ' Got a trailing } picture?
            lclPic = CLIP$(RIGHT, LclPic, 1)                      ' Remove it
            RESET j, k                                            ' Clear some work vars
            IF RIGHT$(lclPic, 1) = " " THEN                       ' Trailing spaces in the picture?
               FOR i = LEN(lclPic) TO 1 STEP -1                   ' See how many
                  IF MID$(lclPic, i, 1) = " " THEN INCR k         ' Count trailing blanks
                  IF MID$(lclPic, i, 1) <> " " THEN EXIT FOR      ' Exit when a non-blank
               NEXT i                                             '
            END IF                                                '
            IF RIGHT$(arg_data, 1) = " " THEN                     ' And some trailing spaces?
               FOR i = LEN(arg_data) TO 1 STEP -1                 ' See how many
                  IF MID$(arg_data, i, 1) <> " " THEN j = i: EXIT FOR   ' Find last non-blank
               NEXT i                                             '
               IF j > 0 THEN                                      ' Found it
                  lclPic = lclPic + SPACE$(LEN(arg_data) - j - k) ' Rebuild picture string
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         IF ISFALSE arg_start_col THEN MExitMeth                  ' Exit if invalid arg
         IF ISFALSE LEN(arg_data) OR ISFALSE LEN(arg_pic) OR ABS(arg_start_col) > LEN(arg_data) THEN MExitMeth ' Sanity check on line and picture string lengths

         i = 1                                                    '
         DO WHILE i <= LEN(lclPic)                                ' Get Pic true length
            INCR len_true_pic                                     '
            i = i + IIF(i < LEN(lclPic) AND MID$(lclPic, i, 1) = "\", 2, 1)   '
         LOOP                                                     '
         '-----------------------------------------------------------------------------------------+
         '- Compute a scan window to search for                                                    |
         '- we create a left-justified window so only complete pic strings are                     |
         '- checked for.                                                                           |
         '-                                                                                        |
         '- example: line is 30 long, pic is 5 long                                                |
         '- forward, start = 1, scan column range is 1 to 26 (30-5+1)                              |
         '- backward, start = 30, scan is from 26 (30-5+1) to 1                                    |
         '-                                                                                        |
         '- ----+----1----+----2----+----3                                                         |
         '- 12345                   12345                                                          |
         '-----------------------------------------------------------------------------------------+
         IF arg_start_col > 0 THEN                                ' Validate arg_start_col
            IF len_true_pic > LEN(arg_data) - arg_start_col + 1 THEN MExitMeth   ' Pic is larger than remaining data
            scan_first_col = arg_start_col                        ' Forward scan: right boundary is fixed, left is moving
            scan_last_col = LEN(arg_data) - len_true_pic + 1      '
            scan_incr = 1                                         '
         ELSEIF arg_start_col < 0 THEN                            ' Backward scan: left boundary is fixed at 1, right is moving
            scan_last_col = 1                                     ' Set left boundary
            scan_first_col = LEN(arg_data) + arg_start_col + 1    ' Get start scan
            IF len_true_pic > scan_first_col THEN MExitMeth       ' Pic is larger than remaining data
            scan_incr = -1                                        '
         END IF                                                   '

         FOR scan_col = scan_first_col TO scan_last_col STEP scan_incr  ' Do the search
            GOSUB ScanPicture                                     '
            IF ret_col <> 0 THEN EXIT FOR                         ' We're done loop if found
         NEXT                                                     '
         MExitMeth                                                '

      ScanPicture:                                                '
         P = STRPTR(lclPic): dp = STRPTR(arg_data) + scan_col - 1 ' Point at picture and data strings
         FOR i = 1 TO len_true_pic                                ' Loop for picture length
            curr_pic_mask  = PIC.pic_mask(@P)                     ' Get mask which maps meaning of pic char
            curr_data_mask = PIC.data_mask(@dp)                   '

            IF curr_pic_mask = %PicMap_Escape THEN                '
               IF i < LEN(lclPic) THEN INCR P                     ' Next char is taken literally; a final \ is used as-is
               curr_pic_mask = %PicMap_Literal                    ' It must be exact match
            END IF                                                '

            IF curr_pic_mask = %PicMap_Literal THEN               '  Begin comparison process.  RETURN on first failed match
               IF @dp <> @P THEN RETURN                           ' Literal pic char must match exactly to data char

            ELSEIF (curr_pic_mask AND %PicMap_LiteralAlpha) THEN  ' Literal alpha is exact match if CASE C, or insensitive if CASE T
               IF FCB.CaseFlag = "C" THEN                         '
                  IF @dp <> @P THEN RETURN                        '
               ELSE                                               ' Assuming "T" if not "C"
                  IF IsNE(CHR$(@dp),CHR$(@P)) THEN RETURN         '
               END IF                                             '
            ELSE                                                  ' all remaining pic codes are class tests
               IF (curr_pic_mask AND curr_data_mask) = 0 THEN RETURN '
            END IF                                                '
            INCR P: INCR dp                                       ' Step to next picture column
         NEXT                                                     '
         ret_col = scan_col: ret_len = len_true_pic               ' if no failure, set success values
         RETURN                                                   '
      END METHOD                                                  '

      METHOD Search(MODE AS INTEGER, FCursMode AS LONG) AS LONG   '
      '--------------------------------------------------------------------------------------------+
      '- This is the single does-it-all string search routine                                      |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, k, ii, jj, l, x, lclRBnd, PClr, IsFind, CQTOK, BackPtr AS LONG '
      LOCAL t1, t2, c1, t, lclWord AS STRING, ONCE, Srch AS LONG, PosType AS INTEGER   '
      STATIC PassCount AS LONG                                    '
         MEntry                                                   '

'- debug "Search Entry: Mode=" + FORMAT$(MODE) + " L=" + FORMAT$(sLine) + " C=" + FORMAT$(sCol) + " sDir="+FORMAT$(sDir)
         i = sLine                                                ' Init values for debugging
         j = sCol                                                 '
         IF sDir = 0 THEN sDir = 1                                ' Ensure sDir is valid
         t1 = LSET$(CurrPCmd, 8)                                  ' Make a temp fixed length field
         IF INSTR("RLOCFINDFIND    F       FF      RFIND   ", t1) <> 0 THEN IsFind = %True   ' Flag FIND commands

         '-----------------------------------------------------------------------------------------+
         '- Get set up, set Failure as the default exit                                            |
         '-----------------------------------------------------------------------------------------+
         lclWord = FCB.WordStr: Srch = ISTRUE PTBL.FlgLit1        ' Fetch local copies
         ONCE = %True                                             '
         METHOD = %False                                          ' Start off saying we've failed
         IF LastLine > 50000 THEN gLoopCtr = - 1                  ' Prevent loop detection for big files

         '-----------------------------------------------------------------------------------------+
         '- If we're actually doing a search string, CASE process it                               |
         '-----------------------------------------------------------------------------------------+
         IF Srch THEN                                             ' If a literal type search
            t2 = PTBL.L1RData                                     ' Setup data from Search arg
            IF ISFALSE PTBL.FlgL1CaseComp AND _                   '
               ISFALSE PTBL.FlgL1RegEx AND _                      '
               ISFALSE PTBL.FlgL1Hex AND _                        '
               ISFALSE PTBL.FlgL1Picture THEN t2 = UUCASE(t2)     ' UC if not case sensitive search or RegEx
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- This is an initial FIND/CHANGE vs an RFIND/RCHANGE                                     |
         '-----------------------------------------------------------------------------------------+
         IF MODE = 0 THEN                                         ' Mode = 0 = Full Find
            '--------------------------------------------------------------------------------------+
            '- Figure out the line and column we're to start on                                    |
            '--------------------------------------------------------------------------------------+
            sLine = @P.PTopLine: sCol = 1: sDir = 1               ' Set start defaults
            IF PTBL.FlgAll THEN sLine = 1                         ' If ALL, start at line 1
            IF FCursMode = %CLData AND ISFALSE PTBL.FlgAll AND ISFALSE gMacLCsr THEN   ' In the Data Area and not an ALL request?
               sLine = me.SGet(@P.C.CRow)                         ' Swap in current cursor location
               sCol = @P.C.CCol - gLNPadCol + @P.POffset          ' Calc column position in line
               IF PTBL.FlgNext THEN                               ' NEXT?
                  sCol += IIF(sDir = 1, 1, -1)                    ' Adjust
                  IF sCol = 0 THEN                                ' Col went to zero?
                     sCol = -1: sLine = MIN(1, sLine - 1)         ' Backup a line
                  END IF                                          '
               END IF                                             '
            END IF                                                '
            gMacLCsr = %False                                     ' Reset the 1 time bypass flag
            IF FCursMode = %CLCmd AND ISFALSE PTBL.FlgAll THEN    ' In the Line # Area and not an ALL request?
               sLine = me.SGet(@P.C.CRow): @P.C.CCol = 1          ' Swap in current line location and Col 1
            END IF                                                '
            IF PTBL.FlgFirst THEN                                 ' If FIRST then start as the top
               sLine = 1: sCol = 1                                '
               PTBL.FlgFirst = %False                             ' Remove so we do it just once
               PTBL.FlgNext = %True                               ' Make it NEXT
               PTBL.FlgPrev = %False                              ' Kill Prev
            END IF                                                '
            IF PTBL.FlgLast THEN                                  ' If LAST then start as the bottom
               sLine = LastLine: sDir = -1: sCol = -1             '
               PTBL.FlgLast = %False: PTBL.FlgPrev = %True        ' Remove LAST and insert PREV
               PTBL.FlgNext = %False                              '
            END IF                                                '
            IF PTBL.FlgPrev THEN                                  ' If Prev set reverse
               sDir = -1: PTBL.FlgNext = %False                   '
               IF sCol = 1 THEN                                   '
                  sLine = MAX(sLine - 1, 1): sCol = -1            '
               ELSE                                               '
                  sCol -= 1                                       '
               END IF                                             '
            END IF                                                '
            IF PTBL.FlgNext THEN                                  ' If Next set it up
               sDir = 1: PTBL.FlgPrev = %False                    '
            END IF                                                '

         '-----------------------------------------------------------------------------------------+
         '- This is the RFIND/RCHANGE setup                                                        |
         '-----------------------------------------------------------------------------------------+
         ELSEIF MODE = 1 THEN                                     ' Mode = 1 = ReFind
            '--------------------------------------------------------------------------------------+
            '- Watch out for rollover at Top/Bottom                                                |
            '--------------------------------------------------------------------------------------+
            IF PTBL.FoundFailed = 0 OR PTBL.FoundFailed = 3 THEN  ' Have we just hit Top/Bottom not found?
               PTBL.FoundFailed = 0                               ' Reset it

               '-----------------------------------------------------------------------------------+
               '- Not a Top/Bottom rollover, set our starting line and column                      |
               '-----------------------------------------------------------------------------------+
               IF FCursMode = %CInternal THEN                     ' sCol/sLin internally set?
                                                                  '
               ELSEIF FCursMode = %CLData THEN                    ' No, In the Data Area?
                  sCol = @P.C.CCol - gLNPadCol + @P.POffset       ' Calc column position in line
                  l = me.SGet(@P.C.CRow)                          ' Get line cursor is on
                  IF l AND IsLXclude(l) THEN                      ' Is this an Xclude line?
                     i = CsrLinDX                                 '
                     IF CsrLinDX <> 0 THEN sLine = GetLineNumber(CsrLinDX) ' Continuing from within an X'd block? Use that line number then
                  ELSE                                            '
                     sLine = me.SGet(@P.C.CRow)                   ' Swap in current cursor location
                  END IF                                          '
                  GOSUB AdjustLinCol                              ' Adjust Lin/Col
               ELSEIF FCursMode = %CCmd THEN                      ' In the Command area?
                  sLine = @P.PTopLine                             ' Swap in top line of screen
                  sCol = 1                                        ' and Col 1
               ELSEIF FCursMode = %CLCmd THEN                     ' In the Line # area?
                  sLine = me.SGet(@P.C.CRow)                      ' Swap in the line #
                  sCol = 1                                        ' and Col 1
               ELSEIF FCursMode = %CNext THEN                     ' Next re-entry
                  GOSUB AdjustLinCol                              ' Adjust Lin/Col
               END IF                                             '
            '--------------------------------------------------------------------------------------+
            '- This is the Top/Bottom rollover setup                                               |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  ' Last one hit top/bottom
               sLine = IIF(PTBL.FoundFailed = 1, LastLine, 1)     ' Set restart point
               PTBL.FoundFailed = 0                               ' Clear, we wrap just once
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- OK, finally we start the search                                                        |
         '-----------------------------------------------------------------------------------------+
         IF sCol = 0 THEN sCol = 1                                '
         PTBL.FoundLen = 0                                        ' Clear FoundLen
         i = sLine                                                ' Init for DO loop
         j = sCol                                                 '
'- debug "Search Start: Mode=" + FORMAT$(MODE) + " L=" + FORMAT$(sLine) + " C=" + FORMAT$(sCol) + " sDir="+FORMAT$(sDir)

         DO WHILE 1 = 1                                           ' Do forever
            IF ISTRUE gfInterrupt THEN EXIT DO                    ' Break for an FF search

            '--------------------------------------------------------------------------------------+
            '- Watch for hitting Top/Bottom i.e. Not Found                                         |
            '--------------------------------------------------------------------------------------+
            IF (sDir = 1 AND IsLBottom(i)) OR _                   ' Do till top or bottom
               (sDir = -1 AND IsLTop(i)) THEN EXIT DO             '

            '--------------------------------------------------------------------------------------+
            '- Do the line range filtering                                                         |
            '--------------------------------------------------------------------------------------+
            IF PTBL.FlgRngPass THEN                               ' A one time pass?
               PTBL.FlgRngPass = %False                           ' Clear it
               Passcount = 2                                      ' Allow one more
            END IF                                                '
            IF PassCount > 0 THEN                                 ' Still a pass remaining?
               DECR PassCount                                     ' Yes, use it up

            ELSE                                                  ' else do the test
               '-----------------------------------------------------------------------------------+
               '- Do the line range filtering                                                      |
               '-----------------------------------------------------------------------------------+
               IF ISFALSE Me.RangeVal(i) OR _                     ' Do basic filtering
                  ISFALSE IsLData(i) THEN                         '
                  i += sDir                                       ' Next entry
                  ONCE = %False                                   ' Ignore restart column
                  sCol = IIF(sDir = 1, 1, -1)                     ' Reset starting col number
                  ITERATE DO                                      ' Onward to next line
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Do +/- processing for the source range                                              |
            '--------------------------------------------------------------------------------------+
            IF PTBL.FindRngSet AND PTBL.FindRngFlag <> 0 THEN     ' Possible + / - processing
               x = PTBL.FindRngFlag                               ' Get local copy
               IF BIT(x, %lCmdX) THEN                             ' Do the +/- processing for the Source
                  me.LFlagBitOn(i, %Invisible)                    ' If - make Invisible
                  gfXRebuild = %True                              ' Ask for Exclude processing
               ELSEIF BIT(x, %lCmdNX) THEN                        '
                  me.LFlagBitOff(i, %Invisible)                   ' If + make visible
                  gfXRebuild = %True                              ' Ask for Exclude processing
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- OK, we actually have to compare data to do this                                     |
            '--------------------------------------------------------------------------------------+
            IF Srch THEN                                          ' Actually have to do string compare?

               '-----------------------------------------------------------------------------------+
               '- Prep the text line for proper CASE handling                                      |
               '-----------------------------------------------------------------------------------+
               t1 = LTxtG(i)                                      ' Setup data from Txt line
               IF ISFALSE PTBL.FlgL1CaseComp AND _                '
                  ISFALSE PTBL.FlgL1RegEx AND _                   '
                  ISFALSE PTBL.FlgL1Hex AND _                     '
                  ISFALSE PTBL.FlgL1Picture THEN t1 = UUCASE(t1)  ' Uppercase if not case sensitive search or picture type

               '-----------------------------------------------------------------------------------+
               '- Escape hatch to prevent weird combination condition loop                         |
               '-----------------------------------------------------------------------------------+
               IF ISFALSE IsFind THEN                             ' CHANGE type command
                  IF FCB.MINLEN > 0 AND PTBL.L1RData = " " AND PTBL.L2RData = "" AND TRIM$(t1) = "" THEN GOSUB KeepSearching: ITERATE DO  '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Only for the first line we honor the starting column                             |
               '-----------------------------------------------------------------------------------+
               IF ONCE THEN                                       ' For 1st line, honour start col
                  ONCE = %False                                   ' Just once please

                  '--------------------------------------------------------------------------------+
                  '- Do Normal, Picture or RegEx search as appropriate using start column          |
                  '--------------------------------------------------------------------------------+
                  IF PTBL.FlgL1Picture THEN                       ' Picture type search?
                     me.PicSearch(t1, t2, sCol, j, k)             ' Call search routine
                  ELSEIF PTBL.FlgL1DLM THEN                       ' DLM type search?
                     me.DLMSearch(t2, t1, sCol, j, k)             ' Call search routine
                  ELSEIF PTBL.FlgL1RegEx THEN                     ' RegEx type search?
                     PCRERegexTest(t1, sCol, j, k)                ' See if we can find it
                  ELSE                                            '
                     j = INSTR(sCol, t1, t2)                      ' OK, see if its there
                     k = LEN(t2)                                  '
                  END IF                                          '

               '-----------------------------------------------------------------------------------+
               '- Don't honor the start column for 2nd and subsequent lines                        |
               '-----------------------------------------------------------------------------------+
               ELSE                                               '
                  IF sDir = -1 THEN                               ' If LAST or PREV then start as the end of the line
                     IF PTBL.FlgL1Picture THEN                    ' Picture type search?
                        me.PicSearch(t1, t2, sCol, j, k)          ' Call search routine
                     ELSEIF PTBL.FlgL1DLM THEN                    ' DLM type search?
                        me.DLMSearch(t2, t1, -1, j, k)            ' Call search routine
                     ELSEIF PTBL.FlgL1RegEx THEN                  ' RegEx type search?
                        PCRERegexTest(t1, 1, j, k)                ' See if we can find it
                        IF k = 0 THEN j = 0                       ' If found is zero length, then kill the find
                     ELSE                                         '
                        j = INSTR(-1, t1, t2)                     '
                        k = LEN(t2)                               '
                     END IF                                       '
                  ELSE                                            '
                     IF PTBL.FlgL1Picture THEN                    ' Picture type search?
                        me.PicSearch(t1 , t2 , sCol , j, k)       ' Call search routine
                     ELSEIF PTBL.FlgL1DLM THEN                    ' DLM type search?
                        me.DLMSearch(t2 , t1 , sCol , j, k)       ' Call search routine
                     ELSEIF PTBL.FlgL1RegEx THEN                  ' RegEx type search?
                        PCRERegexTest(t1, 1, j, k)                ' See if we can find it
                        IF k = 0 THEN j = 0                       ' If found is zero length, then kill the find
                     ELSE                                         '
                        j = INSTR(t1, t2)                         ' OK, see if its there
                        k = LEN(t2)                               '
                     END IF                                       '
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- If no real search, make it look like we did one and found it                        |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  ' If no Srch, fudge a 'found' answer
               j = 1: k = 1                                       ' Say found 1 byte in column 1
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- OK if we found it, we have still a lot of work to do                                |
            '--------------------------------------------------------------------------------------+
            IF j THEN                                             ' If we have a 'found' condition

               IF Srch THEN                                       ' Doing a string search
                  '--------------------------------------------------------------------------------+
                  '- Do column bounds if asked for                                                 |
                  '--------------------------------------------------------------------------------+
                  IF PTBL.FlgFCol AND ISFALSE PTBL.FlgTCol THEN   ' Request for locate in single column?
                     IF j <> PTBL.ColFrom THEN                    ' then is this in the right column?
                        GOSUB KeepSearching                       ' No, keep looking
                        ITERATE DO                                '
                     END IF                                       '
                  ELSEIF PTBL.FlgFCol AND PTBL.FlgTCol THEN       ' Request within Left/Right columns?
                     IF j < PTBL.ColFrom OR j + k - 1 > PTBL.ColTo THEN ' Is it within bounds?
                        GOSUB KeepSearching                       ' No, keep looking
                        ITERATE DO                                '
                     END IF                                       '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do the WORD test if asked for                                                 |
                  '--------------------------------------------------------------------------------+
                  IF PTBL.FlgWord THEN                            ' WORD requested?
                     IF j = 1 AND j + k - 1 = LEN(t1) THEN        ' If in left margin and only thing on line
                        GOTO DoPrefixTest                         ' We found it, continue next test
                     ELSEIF j = 1 AND j + k - 1 <> LEN(t1) THEN   ' In left margin, more on line
                        IF INSTR(lclWord, MID$(t1, j + k, 1)) = 0 THEN  ' Trailing char is a delimiter
                           GOTO DoPrefixTest                      ' We found it, continue next test
                        ELSE                                      '
                           GOSUB KeepSearching                    '
                           ITERATE DO                             '
                        END IF                                    '
                     ELSEIF INSTR(lclWord, MID$(t1, j - 1, 1)) = 0 THEN ' Left end is after a DLM
                        IF j + k - 1 = LEN(t1) THEN               ' and right is at the end
                           GOTO DoPrefixTest                      ' Another winner, continue next test
                        ELSE                                      '
                           IF INSTR(lclWord, MID$(t1, j + k, 1)) = 0 THEN  ' Trailing char is a delimiter
                              GOTO DoPrefixTest                   ' Another winner, continue next test
                           ELSE                                   '
                              GOSUB KeepSearching                 '
                              ITERATE DO                          '
                           END IF                                 '
                        END IF                                    '
                     ELSE                                         '
                        GOSUB KeepSearching                       '
                        ITERATE DO                                '
                     END IF                                       '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do the PREFIX test if asked for                                               |
                  '--------------------------------------------------------------------------------+
                  DoPrefixTest:                                   '
                  IF PTBL.FlgPrefix THEN                          ' PREFIX requested?
                     IF j = 1 OR INSTR(lclWord, MID$(t1, j - 1, 1)) = 0 THEN  ' If in left margin or left after a DLM
                        IF INSTR(lclWord, MID$(t1, j + k, 1)) <> 0 AND j + k - 1 <> LEN(t1) THEN   ' Trailing char is a non-delimiter
                           GOTO DoSuffixTest                      ' Another found it
                        ELSE                                      '
                           GOSUB KeepSearching                    '
                           ITERATE DO                             '
                        END IF                                    '
                     ELSE                                         '
                        GOSUB KeepSearching                       '
                        ITERATE DO                                '
                     END IF                                       '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do the SUFFIX test if asked for                                               |
                  '--------------------------------------------------------------------------------+
                  DoSuffixTest:                                   '
                  IF PTBL.FlgSuffix THEN                          ' SUFFIX requested?
                     IF j = 1 OR INSTR(lclWord, MID$(t1, j - 1, 1)) = 0 THEN  ' Can't be found in col 1 or preceeded by a DLM
                        GOSUB KeepSearching                       '
                        ITERATE DO                                '
                     ELSEIF INSTR(lclWord, MID$(t1, j + k, 1)) = 0 OR J + k -1 = LEN(t1) THEN   ' Trailing char is delimiter or EOL
                        GOTO DoLMTest                             ' We found it, continue
                     ELSE                                         '
                        GOSUB KeepSearching                       '
                        ITERATE DO                                '
                     END IF                                       '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do the LM test if asked for                                                   |
                  '--------------------------------------------------------------------------------+
                  DoLMTest:                                       '
                  IF PTBL.FlgLM THEN                              ' LM requested?
                     IF j <> FCB.BndLeft THEN                     ' OK if in LM column
                        GOSUB KeepSearching                       '
                        ITERATE DO                                '
                     END IF                                       '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do the RM test if asked for                                                   |
                  '--------------------------------------------------------------------------------+
                  IF PTBL.FlgRM THEN                              ' RM requested?
                     lclRBnd = LEN(L(i).@LTxt)                    ' Set where RM is to be found
                     IF j + k - 1 = lclRBnd THEN                  ' OK if in RM column
                        IF FCB.BndLeft > 1 OR FCB.BndRight > 0 THEN  ' BOUNDS set?
                           IF lclRBnd > FCB.BndRight OR lclRBnd < FCB.BndLeft THEN  ' Outside the LM / RM BNDS columns?
                              GOSUB KeepSearching                 ' Then fail it
                              ITERATE DO                          '
                           END IF                                 '
                        END IF                                    '
                     ELSE                                         ' Not at RM
                        GOSUB KeepSearching                       ' Then fail it
                        ITERATE DO                                '
                     END IF                                       '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do the Color tests if asked for                                               |
                  '--------------------------------------------------------------------------------+
                  LOCAL ccc AS LONG                               '
                  ccc = PTBL.HiLiteSrch                           '
                  IF PTBL.FlgStd OR PTBL.FlgMStd OR PTBL.HiLiteSrch <> 0 OR _ ' Any color type requests?
                     PTBL.FlgSolid OR PTBL.FlgMSolid THEN         '

                     c1 = me.AttrHiLiteGet(i, j, j + k - 1)       ' Get the string
                     IF PTBL.FlgStd AND c1 = REPEAT$(k, CHR$(0)) THEN GOTO DoCmQtTests ' Lets try STD first
                     IF PTBL.FlgMStd AND c1 <> REPEAT$(k, CHR$(0)) THEN GOTO DoCmQtTests  ' Lets try MSTD first

                     IF PTBL.HiLiteSrch AND PTBL.HiLiteSrch > 0 THEN ' If Positive, do that test
                        IF c1 = REPEAT$(k, CHR$(PTBL.HiLiteSrch)) THEN GOTO DoCmQtTests   ' Lets try a simple color test
                     END IF                                       '
                     IF PTBL.HiLiteSrch AND PTBL.HiLiteSrch < 0 THEN ' If Positive, do that test
                        IF c1 <> REPEAT$(k, CHR$(ABS(PTBL.HiLiteSrch))) THEN GOTO DoCmQtTests   ' Lets try a simple color test
                     END IF                                       '

                     IF PTBL.FlgSolid THEN                        ' Lets try SOLID next
                        IF c1 = REPEAT$(k, LEFT$(c1, 1)) AND _    ' Attr line field all the same color?
                           c1 <> REPEAT$(k, CHR$(0)) THEN GOTO DoCmQtTests ' and not STD
                     END IF                                       '
                     IF PTBL.FlgMSolid THEN                       ' Lets try -SOLID next
                        IF c1 <> REPEAT$(k, LEFT$(c1, 1)) THEN GOTO DoCmQtTests  ' Attr line field not all the same color?
                     END IF                                       '

                     GOSUB KeepSearching                          '
                     ITERATE DO                                   '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do the Commment, Quoted and Text type tests                                         |
                  '--------------------------------------------------------------------------------+
                  DoCmQtTests:                                    '
                  CQTOK = %False                                  ' Start as all failed
                  IF PTBL.FlgComment OR PTBL.FlgQuoted OR PTBL.FlgText THEN   ' Any need for the tests?

                     IF PTBL.FlgQuoted THEN                       ' The Quoted type?
                        '--------------------------------------------------------------------------+
                        '- Do Quoted type tests                                                    |
                        '--------------------------------------------------------------------------+
                        FOR ii = j TO j + k - 1                   ' Loop through found string
                           jj = me.AttrSchemeGet(i, ii)           ' Get the Scheme # for the character
                           IF jj =  ClrQuoted THEN ITERATE FOR    ' Q and it's ClrQuoted, continue
                           EXIT IF                                ' A mis-match, skip this one
                        NEXT ii                                   '
                        CQTOK = %True                             ' A winner
                     END IF                                       '

                     IF PTBL.FlgComment THEN                      ' The Comment type?
                        '--------------------------------------------------------------------------+
                        '- Do the Commment type tests                                              |
                        '--------------------------------------------------------------------------+
                        FOR ii = j TO j + k - 1                   ' Loop through found string
                           t = FORMAT$(me.AttrSchemeGet(i, ii), "00")   ' Get the Scheme # as a 2 char number
                           IF INSTR(ClrComList, t) <> 0 THEN ITERATE FOR   ' C and one of the ClrComments, continue
                           EXIT IF                                ' A mis-match, skip this one
                        NEXT ii                                   '
                        CQTOK = %True                             ' A winner
                     END IF                                       '

                     IF PTBL.FlgText THEN                         ' The Text type?
                        '--------------------------------------------------------------------------+
                        '- Find if in neither Quoted or Comment                                    |
                        '--------------------------------------------------------------------------+
                        FOR ii = j TO j + k - 1                   ' Loop through found string
                           jj = me.AttrSchemeGet(i, ii)           ' Get the Scheme # for the character
                           t = FORMAT$(jj, "00")                  ' Get the Scheme # as a 2 char number
                           IF jj <>  ClrQuoted AND INSTR(ClrComList, t) = 0 THEN ITERATE FOR ' Inside neither one. we fail
                           EXIT IF                                ' A mis-match, skip this one
                        NEXT ii                                   '
                        CQTOK = %True                             ' A winner
                     END IF                                       '
                     IF CQTOK GOTO TestsDone                      ' If OK continue on
                     GOSUB KeepSearching                          ' Not selected, kill this one
                     ITERATE DO                                   '
                  END IF                                          '

                  TestsDone:                                      '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Whoopee! an actual successful search, do the MarkTrue stuff and exit             |
               '-----------------------------------------------------------------------------------+
               GOSUB MarkTrue: MExitMeth                          ' No Specials (Word, Prefix, Suffix), we're done
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Failed the search, onward to the next line                                          |
            '--------------------------------------------------------------------------------------+
            i += sDir                                             '
            sCol = IIF(sDir = -1, -1, 1)                          ' Adjust start column
         LOOP                                                     '
         MExitMeth                                                '

         '-----------------------------------------------------------------------------------------+
         '- This does all the stuff needed for a True search condition                             |
         '-----------------------------------------------------------------------------------------+
         MarkTrue:                                                '
            PosType = IIF(PTBL.FlgTop, %FLocate, %Find)           ' Set positioning for TOP or not

            '--------------------------------------------------------------------------------------+
            '- Handle the weird LEFT/RIGHT considerations                                          |
            '--------------------------------------------------------------------------------------+
            IF PTBL.FlgLeft AND sDir = -1 THEN                    ' LEFT and doing a backward scan
               IF PTBL.FlgL1Picture THEN                          ' Picture type search?
                  me.PicSearch(t1 , t2 , 1 , j, k)                ' Search foreward from column 1
               ELSE                                               '
                  j = INSTR(1, t1, t2)                            ' Search foreward from column 1
                  k = LEN(t2)                                     '
               END IF                                             '
            END IF                                                '

            IF PTBL.FlgRight AND sDir = 1 THEN                    ' RIGHT and doing a foreward scan
               IF PTBL.FlgL1Picture THEN                          ' Picture type search?
                  me.PicSearch(t1 , t2 , -1 , j, k)               ' Search backward from the end
               ELSE                                               '
                  j = INSTR(-1, t1, t2)                           ' Search backward from the end
                  k = LEN(t2)                                     '
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- OK, finally we can consider it a Found condition                                    |
            '--------------------------------------------------------------------------------------+
            METHOD = %True                                        '
            INCR FixCtr                                           ' Bump FIXCtr
            LFIXS(i) = FixCtr                                     ' Save in line control area

            '--------------------------------------------------------------------------------------+
            '- If a normal non-X'd line see if that should be altered                              |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE IsLInvisible(i) THEN                       ' A normal non-X'd line?
               IF PTBL.FlgMX THEN                                 ' If caller is someone who wants X out the line
                  me.LFlagBitOn(i, %Invisible)                    ' Just make it invisible
                  me.LFlagBitOn(i, %Popped)                       ' Say we've just popped it
                  gfXRebuild = %True                              ' Call for rebuild exclude state
                  me.CurSetReq(PosType, i, j, %True, %True)       ' Put cursor on the X line, no hilite, XPtr to be set
                  GOSUB SeeSetClr                                 ' Go see if Pen colors to be set
                  CsrLinDX = VAL(LLNumG(i))                       ' Save hidden line number for Status Bar display
               ELSE                                               ' This is someone who is just looking like FIND / CHANGE'
                  IF IsFind THEN                                  ' A FIND command?
                     GOSUB SeeSetClr                              ' Go see if Pen colors to be set
                     IF Srch THEN                                 ' Was this a string search?
                        me.CurSetReq(PosType, i, j, %True)        ' Set cursor
                        IF ISTRUE FCB.HiFind AND ISFALSE FCB.HiFindSupp THEN  ' See whether to hilite the find string
                           IF PTBL.HiLiteOn = 0 AND ISFALSE PTBL.FlgPStd THEN '
                              me.AttrInvSet(i, j, j + k - 1)      ' Set for Hi-Lite
                           END IF                                 '
                        END IF                                    '
                     END IF                                       '
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- If an X'd line see if that should be altered                                        |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  ' We have a line already X'd out
               IF PTBL.FlgMX THEN                                 ' If caller is someone who wants X out the line
                  IF Srch THEN                                    ' A real string search?
                     me.CurSetReq(PosType, i, j, %True, %True)    ' Just set the cursor
                     GOSUB SeeSetClr                              ' Go see if Pen colors to be set
                     CsrLinDX = VAL(LLNumG(i))                    ' Save hidden line number for Status Bar display
                  END IF                                          '
               ELSE                                               '
                  IF PTBL.FlgDX THEN                              ' If told to leave X status alone
                     t1 = LSET$(CurrPCmd, 8)                      ' Make a temp fixed length field
                     IF INSTR("CHANGE  C       FC      FCHANGE CHA     CHG     RCHANGE ", t1) <> 0 THEN   ' A CHANGE command?
                        '- Do nothing, CHANGE should set hilighting
                     ELSE                                         '
                        IF Srch THEN                              ' If a real string search
                           me.CurSetReq(PosType, i, j, %True, %True) ' Put cursor on the X line, XPtr to be set
                           GOSUB SeeSetClr                        ' Go see if Pen colors to be set
                           CsrLinDX = VAL(LLNumG(i))              ' Save hidden line number for Status Bar display
                        END IF                                    '
                     END IF                                       '
                  ELSE                                            '
                     me.LFlagBitOff(i, %Invisible)                ' Remove the invisibility flag
                     me.LFlagBitOn(i, %Popped)                    ' Say we've just popped it
                     BackPtr = LWrk1G(i)                          ' Save Back pointer
                     LWrk1S(i) = 0                                ' Clear ptr back to the Xclude line
                     gfXRebuild = %True                           ' Rebuild exclude state
                     IF Srch THEN                                 ' If a real string search
                        GOSUB SeeSetClr                           ' Go see if Pen colors to be set
                        me.CurSetReq(PosType, i, j, %True)        ' Set Cursor
                        IF ISTRUE FCB.HiFind AND ISFALSE FCB.HiFindSupp THEN  ' See whether to hilite the find string
                           IF PTBL.HiLiteOn = 0 AND ISFALSE PTBL.FlgPStd THEN '
                              me.AttrInvSet(i, j, j + k - 1)      ' Set for Hi-Lite
                           END IF                                 '
                        END IF                                    '
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Save the 'found'- location for others                                               |
            '--------------------------------------------------------------------------------------+
            sLine = i: sCol = j                                   ' Save line and column where found
            IF ISFALSE Srch THEN sLine += 1                       ' If not really searching, continue on next line
'           IF IsLPopped(i) AND backPtr = 1 THEN DECR i           ' If Popped and 1st of group, adjust line num
            BackPtr = 0                                           ' Reset it
            PTBL.FoundLine = i: PTBL.FoundCol = j: PTBL.FoundLen = k ' Save in PTBL area
            FoundLstLin = i                                       ' Set the Last time values
            FoundLstCol = j                                       '
            FoundLstLen = k                                       '
            IF Found1stLin  = 0 THEN Found1stLin = i              ' Set the 1st time values
            IF Found1stCol  = 0 THEN Found1stCol = j              '
            IF Found1stLen  = 0 THEN Found1stLen = k              '
         RETURN                                                   '

         '-----------------------------------------------------------------------------------------+
         '- We failed, set things up to continue the search                                        |
         '-----------------------------------------------------------------------------------------+
         KeepSearching:                                           '
            IF sDir = 1 THEN                                      ' Forward
               sCol = j + 1                                       ' This isn't the one, set to continue at next column
               IF sCol > LEN(t1) THEN                             ' End of record?
                  sCol = 1                                        ' Yes, start back at 1
                  ONCE = %False                                   '
                  INCR i                                          '
               ELSE                                               '
                  ONCE = %True                                    ' Say to honour column, stay on same line
               END IF                                             '
            ELSE                                                  '
               IF PTBL.FlgL1RegEx THEN                            ' RegEx type search?
                  ONCE = %True                                    ' Stay on same line
                  sCol += 1                                       ' Step over this found one
                  RETURN                                          '
               END IF                                             '
               sCol = j - LEN(t1) - 2                             ' Backward, adjust the other way
               sCol += LEN(t2) - 1                                '
               l = sCol                                           '
               IF ABS(sCol) > LEN(t1) THEN                        ' Beginning of record?
                  sCol = -1                                       ' Yes, start back at end of record
                  ONCE = %False                                   '
                  DECR i                                          ' and next(prev) line
               ELSE                                               '
                  ONCE = %True                                    ' No, Honour column, stay on same line
               END IF                                             '
            END IF                                                '
         RETURN                                                   ' We'll never get here

      SeeSetClr:                                                  ' See if Pen colors to be set
         IF PTBL.HiLiteOn <> 0 THEN                               '
            PClr = PTBL.HiLiteOn                                  ' Override if requested
         ELSEIF PTBL.FlgPStd THEN                                 '
            PClr = %AttrHiSTD                                     ' +Std asked for?
         ELSE                                                     '
            RETURN                                                '
         END IF                                                   '
         me.AttrHiLiteSet(i, j, j + k - 1, PClr)                  ' Set the color
         RETURN                                                   '

      AdjustLinCol:                                               '
         IF sDir = 1 THEN                                         ' Forward?
            IF PTBL.FlgL1RegEx OR PTBL.FlgL1DLM THEN              ' If variable length is possible
               sCol += PTBL.FoundLen                              ' Adjust over prev found str
            ELSE                                                  '
               sCol += 1                                          ' Adjust only by 1
            END IF                                                '
            IF PTBL.FlgLeft THEN                                  ' If previous a LEFT
               IF sDir = 1 THEN                                   ' Going forward?
                  sLine += 1: sCol = 1                            ' Next line, col 1
               ELSE                                               '
                  sLine -= 1: sCol = -1                           ' Next line, col 1
               END IF                                             '
            END IF                                                '
         ELSE                                                     '
            IF PTBL.FlgL1Picture THEN                             ' If P'xxx'
               sCol = MIN(1, sCol - LEN(L(sLine).@LTxt) - 2)      ' Yes, calc new scan start
            ELSEIF PTBL.FlgL1RegEx THEN                           ' If Regex
               sCol = MIN(1, sCol - LEN(L(sLine).@LTxt) - 2)      ' Yes, calc new scan start
               sLine -= 1                                         '
            ELSE                                                  '
               sCol = MIN(1, sCol + LEN(t2) - 3 - LEN(L(sLine).@LTxt) - IIF(RIGHT$(t2, 1) <> " ", 0, LEN(t2))) ' No, calc new scan start
            END IF                                                '
         END IF                                                   '
         RETURN                                                   '

      END METHOD                                                  '

      METHOD SetNewStart()                                        '
      '--------------------------------------------------------------------------------------------+
      '- Set a new .START label at the last line                                                   |
      '--------------------------------------------------------------------------------------------+
      LOCAL k AS LONG                                             '
         MEntry                                                   '
         IF FCB.Start <> "NEW" THEN MExitMeth                     ' Do only if START NEW is set
         IF LastLine < 3 THEN MExitMeth                           ' Skip also if no lines
         k = me.LLCtlScan(".START")                               ' See if label exists already
         IF k THEN LLblS(k - 1) = $BlankLNo: LLCtlS(k - 1) = $BlankLNo  ' Blank label elsewhere if used
         LLblS(LastLine - 1) = ".START"                           ' Add the Label
         me.UpdLControl(LastLine - 1)                             ' Put back the line number
         MExit                                                    '
      END METHOD                                                  '

      METHOD SetStart()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Do initial positioning based on the Profile START operand                                 |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         MEntry                                                   '
         SELECT CASE AS CONST$ FCB.Start                          ' What is our default
            CASE "FIRST"                                          ' FIRST
               i = IIF(FCB.Pageflag, 2, 1)                        ' Set to 1 or 2 based on PAGE value
               IF i <> @P.PTopLine THEN                           ' Topscrn elsewhere right now?
                  me.LFlagBitOff(@P.PTopLine, %TopScreen)         ' Clear current TopScrn line flag
               END IF                                             '
               @P.PTopLine = i                                    ' Set to our choice
               me.LFlagBitOn(@P.PTopLine, %TopScreen)             ' Move %TopScreen to our choice

            CASE "LAST"                                           ' LAST
               i = LastLine                                       ' Set to bottom - 1 page
               i = me.CRPBack(%mVisible, i, @P.PBottom - @P.PTop - 1)   '
               IF @P.PTopLine <> i THEN                           ' Topscrn elsewhere right now?
                  me.LFlagBitOff(@P.PTopLine, %TopScreen)         ' Clear current TopScrn line flag
               END IF                                             '
               @P.PTopLine = i                                    ' Set to our choice
               me.LFlagBitOn(@P.PTopLine, %TopScreen)             ' Move %TopScreen to our choice

            CASE "LABEL", "NEW"                                   ' Both these position to .START
               i = me.LineNoRef(".START")                         ' Get the line number
               IF i = -1 THEN                                     ' Found?
                  i = 1                                           ' No, go to top
               ELSE                                               '
                  me.LFlagBitOff(i, %Invisible)                   ' Remove the invisibility flag
                  gfXRebuild = %True                              ' Rebuild exclude state
               END IF                                             '
               IF i <> @P.PTopLine THEN                           ' Topscrn elsewhere right now?
                  me.LFlagBitOff(@P.PTopLine, %TopScreen)         ' Clear current TopScrn line flag
               END IF                                             '
               @P.PTopLine = i                                    ' Set to our choice
               me.LFlagBitOn(@P.PTopLine, %TopScreen)             ' Move %TopScreen to our choice
         END SELECT                                               '
         MExit                                                    '
      END METHOD                                                  '

      METHOD sGet (BYVAL ix AS LONG) AS LONG: METHOD = IIF(@P.PS(ix) > LastLine, 0, @P.PS(ix)): END METHOD  '

      METHOD SPLIT()                                              '
      '--------------------------------------------------------------------------------------------+
      '- Split a line for SPLIT/RSPLIT                                                             |
      '--------------------------------------------------------------------------------------------+
      LOCAL sp1, sp2, i, j, k, l, x, y, bias AS LONG              '
      LOCAL ol, nl, TTxt, lclChg AS STRING                        '
      LOCAL oc, nc, cTxt, CWrk AS WSTRING, AttrAsc AS WORD        '

         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Get common variables into local data                                                   |
         '-----------------------------------------------------------------------------------------+
         i = PTBL.FoundLine                                       ' Find line
         j = PTBL.FoundCol                                        ' Column where it was found
         k = PTBL.FoundLen                                        ' Length of found string
         l = LEN(L(i).@LTxt)                                      ' Length of text line
         GOSUB GetPrevAttr                                        ' Get any Attr of the found string

         '-----------------------------------------------------------------------------------------+
         '- Prepare the Change string                                                              |
         '-----------------------------------------------------------------------------------------+
         sp1 = PTBL.SplitPoint2 - 1                               ' Calc the Split point in the source literal (Use Lit-2 instead)
         sp2 = PTBL.SplitPoint2 - 1                               ' Calc the Split point in the replace literal
         y = j                                                    ' Found data
         TTxt = LTxtG(i)                                          ' Copy of the line's text
         FOR x = 1 TO LEN(PTBL.L2RData)                           ' Loop building the change string
            SELECT CASE AS CONST$ MID$(PTBL.L2RData, x, 1)        ' Do it based on the char inside P'xxx'
               CASE "=": lclChg += MID$(TTxt, y, 1): INCR y       ' Copy the character
               CASE "<": lclChg += LLCASE(MID$(TTxt, y, 1)): INCR y  ' Lowercase it
               CASE ">": lclChg += UUCASE(MID$(TTxt, y, 1)): INCR y  ' Uppercase it
               CASE "!"                                           ' Copy found string
                  lclChg += MID$(TTxt, j, k)                      '
                  IF x + bias <= sp2 THEN                         '
                     sp2 += (k - 1)                               ' Shift split point by insert
                     bias += (k - 1)                              '
                  END IF                                          '
               CASE "~": INCR y                                   ' Ignore it
               CASE "\"                                           ' Escape?
                  lclChg += MID$(PTBL.L2RData, x + 1, 1)          ' Copy next char
                  INCR x                                          ' extra step
                  IF PTBL.FlgL2Picture THEN INCR y                ' If doing a picture
               '-----------------------------------------------------------------------------------+
               '- Not special character, just copy it                                              |
               '-----------------------------------------------------------------------------------+
               CASE ELSE                                          ' Copy L12 character
                  lclChg += MID$(PTBL.L2RData, x, 1)              '
                  IF PTBL.FlgL2Picture THEN INCR y                ' If doing a picture
            END SELECT                                            '
         NEXT x                                                   '

         me.LFlagBitOff(i, %EQChange)                             ' Reset ==CHG>
         me.ModSet(i)                                             ' Remember we changed something

         ol = LEFT$(LTxtG(i), j - 1) + LEFT$(lclChg, sp2)         ' Split line into left + lh of change literal
         nl = MID$(lclChg, sp2 + 1) + MID$(TTxt, j + k)           ' and right = rh of chg literal + line remainder

         oc = LAttrG(i)                                           ' Get Attr line
         nc = oc                                                  ' Copy to nc before we alter it
         oc = LEFT$(oc, j - 1) + REPEAT$(LEN(lclChg) - sp2, CHR$$(AttrAsc))   ' Split color into left + lh of change literal
         nc = REPEAT$(LEN(lclChg) - sp2, CHR$$(AttrAsc)) + MID$(nc, j + k) ' and right = rh of change literal + line remainder
         me.LInsertLines(i, 1, %Data)                             ' Insert the split data line

         me.LTxtSet(i, ol)                                        ' Swap in left hand data
         me.LTxtSet(i + 1, nl)                                    ' Swap in right hand data
         me.LFlagBitOff(i, %EQChange)                             ' Reset ==CHG>
         LTagS(i + 1) = TRIM$(LTagG(i))                           ' Copy the :tag
         me.UpdLControl(i + 1)                                    '

         me.AdjustPending(i, 1,0)                                 ' Adjust pending requests
         IF PTBL.FindRngEnd = 0 THEN PTBL.FindRngEnd = PTBL.FindRngStart   ' If no end, copy start
         PTBL.FindRngEnd = PTBL.FindRngEnd + 1                    ' Adjust range

         LAttrS(i) = oc                                           '
         LAttrS(i + 1) = nc                                       '
         me.AttrScan(i)                                           ' Recolorize
         me.AttrScan(i + 1)                                       ' Recolorize

         IF PTBL.FlgNext THEN                                     ' If FWD
            sLine += 1: sCol = 1 + LEN(MID$(lclChg, sp2 + 2))     ' Then start of new line + L'changestring
         ELSE                                                     '
            sLine += 1: sCol = 1                                  ' Else start of new line
         END IF                                                   '
         me.CurSetReq(%Position, sLine, sCol, %False)             ' Set cursor set attempt
         PTBL.FoundFailed = 3                                     ' Set to srch needed

         MExitMeth                                                '

      GetPrevAttr:                                                '
         '-----------------------------------------------------------------------------------------+
         '- First see if any existing highlighting on the found string                             |
         '-----------------------------------------------------------------------------------------+
         AttrAsc = 0                                              '
         cTxt = LAttrG(i)                                         ' Get Attr line
         CWrk = MID$(ctxt, j, k)                                  ' Get data for the found field
         IF CWrk = REPEAT$(k, LEFT$(CWrk, 1)) THEN                ' All the same?
            AttrAsc = ASC(LEFT$(Cwrk, 1))                         ' Set AttrAsc to the 1st char
         END IF                                                   '
         RETURN                                                   '
      END METHOD                                                  '

      METHOD sSearch (BYVAL lno AS LONG) AS LONG                  '
      LOCAL i AS LONG                                             '
         MEntry                                                   '
         IF lno < @P.PS(@P.PData1) THEN METHOD = -1: MExitMeth    ' If above screen, return -1
         FOR i = @P.PData1 TO 300                                 ' See if ON the screen
            IF @P.PS(i) = lno THEN METHOD = i: MExitMeth          ' If so, return screen line number
            IF @P.PS(i) = 0 THEN EXIT FOR                         ' Not above or ON the screen, must be below
         NEXT i                                                   '
         METHOD = -2                                              ' Return -2
         MExit                                                    '
      END METHOD                                                  '

      METHOD ScreenDim (lwidth AS LONG)                           '
      REGISTER i AS LONG                                          '
         MEntry                                                   '
         FOR i = 1 TO 300                                         ' Fill it
            ScrImage(i) = REPEAT$(lwidth, " ")                    '
         NEXT i                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD ScreenChrHit(rlin AS LONG, rcol AS LONG) AS LONG     ' non-blank or adjacent to one?
         LOCAL lclLCol, lclRCol AS LONG                           '
         lclLCol = MAX(1, rcol - 1): lclRCol = MIN(rcol + 1, gENV.ScrWidth)   ' Set boundaries
         IF MID$(ScrImage(rlin), lclLCol TO lclRCol) = SPACE$(lclRCol - lclLCol + 1) THEN EXIT METHOD   '
         METHOD = %True                                           ' Something non-blank, return true
      END METHOD                                                  '

      METHOD ScreenGet (i AS LONG) AS STRING: METHOD = ScrImage(i): END METHOD  '
      METHOD ScreenRep (i AS LONG, CCol AS LONG, str AS STRING)   '
         MID$(ScrImage(i), CCol, LEN(str)) = str                       '
      END METHOD                                                  '

      METHOD ProfScrlRep (posit AS LONG, char AS STRING)          '
      LOCAL t AS STRING                                           '
         t = FCB.ScrollAmt                                        '
         IF LEN(t) < posit THEN t = LEFT$(t + "    ", posit)      '
         MID$(t, posit, 1) = char                                 '
         FCB.ScrollAmt = t                                        '
      END METHOD                                                  '

      METHOD PTBLLoad()                                           '
      REGISTER i AS LONG                                          '
         me.CopyPTBL(gPTBLSave, PTBLSrch)                         ' Do the field by field copy
         sline = gPTBLsline                                       ' Do the Search pointers
         scol = gPTBLscol + 1                                     ' Adjust for resume
         sdir = gPTBLsdir                                         '
         @P.C.CRow = 1                                            ' Reset real line and column
         FOR i = 0 TO 300                                         '
            IF @P.PS(i) = sline THEN @P.C.CRow = i                '
         NEXT i                                                   '
         @P.C.CCol = scol + gLNPadCol - @P.POffset                '
      END METHOD                                                  '

      METHOD PTBLSave()                                           '
         me.CopyPTBL(PTBLSrch, gPTBLSave)                         ' Do the field by field copy
         gPTBLsline = sline                                       ' Do the Search pointers
         gPTBLscol  = scol                                        '
         gPTBLsdir  = sdir                                        '
      END METHOD                                                  '

      METHOD StateLoad(fn AS STRING, fromline AS LONG, ToLine AS LONG, IsCopy AS LONG) '
      '--------------------------------------------------------------------------------------------+
      '- If valid, re-load the STATE information                                                   |
      '--------------------------------------------------------------------------------------------+
      LOCAL RealLines, LblCount, TagCount, UsrCount, ClrCount, XCount, NoteCount, FNum, HNDL, nodup AS LONG
      LOCAL PanelSplit, PanelTop1, PanelTop2 AS LONG, PanelPct AS SINGLE      '
      DIM PanelArray(1 TO 4) AS STRING                            '
      LOCAL H1, HL, HT, HU, HC, HX, HN, t, ShortFn, lclFn, PanelType AS STRING, RCA AS RCArea  '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL k, l, a, bias, duplabel, tcol, tlen AS LONG, llabel, lcltag, tclr AS STRING   '
         MEntry                                                   '
         IF IsFMTab THEN MexitMeth                                ' If this is the FM tab, don't do it

         OffStateExist                                            ' Remove STATE data exists

         '-----------------------------------------------------------------------------------------+
         '- Make the fn into a 'safe' fn                                                           |
         '-----------------------------------------------------------------------------------------+
         ShortFn = MID$(fn, INSTR(-1, fn, "\") + 1)               ' Save shortname for messages
         lclFn = fn + ".STATE"                                    ' Temp copy with .STATE on the end
         REPLACE ANY ":\/" WITH "```" IN lclFN                    ' Make : / and \ into `
         lclFn = gENV.HomeData + "STATE\" + lclFn                 ' Add our STATE folder

         IF ISFALSE ISFILE(lclFn) THEN MExitMeth                  ' Exit if no STATE file
         IF IsNullFile(lclFn) THEN MExitMeth                      ' Also exit if the nullfile version

         '-----------------------------------------------------------------------------------------+
         '- See if passed reasonable data                                                          |
         '-----------------------------------------------------------------------------------------+
         Call3(TryOpenInput(lclfn, FNum), _ GOTO SIExist, SIFail, SIOK  ' Try the open
               MExitMeth, _                                       ' Just exit
               MErrExit(%eFail, "Warning, STATE file could not be opened, STATE ignored"), _ ' Bail out
               Nul)                                               ' Continue
         LINE INPUT # FNum, H1                                    ' Get a line
         IF H1 = "[[--SPFLite-File-State-Information-//-Do-NOT-Modify--]]" THEN _   '
            LINE INPUT # FNum, H1                                 ' Skip it and get another
         IF LEFT$(H1, 2) <> "#1" THEN                             ' Better be the header line
            CLOSE # FNum                                          '
            MErrExit(%eFail, "STATE file for: " + ShortFn + " is missing it's header line, STATE ignored")  '
         ELSE                                                     '
            H1 = MID$(H1, 3)                                      ' Strip off the #1
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Check line counts                                                                      |
         '-----------------------------------------------------------------------------------------+
         FOR i = Fromline TO ToLine                               ' Loop through the line range
            IF IsLData(i) THEN INCR RealLines                     ' Count real text lines
         NEXT i                                                   '
         FOR i = 4 TO 9                                           ' See if any REAL STATE data
            j += VAL(PARSE$(H1, ",", i))                          ' Accum count of all the different types
         NEXT i                                                   '
         P1.PTopLine = VAL(PARSE$(H1, ",", 3))                    ' Set top of screen line
         IF RealLines <> VAL(PARSE$(H1, ",", 2)) THEN             ' Correct # lines?
            IF j > 0 OR @P.PTopLine > RealLines THEN _            ' If other STATE data or TopScrn > # of lines
               CLOSE # FNum: MErrExit(%eFail, "STATE Line Count mismatch for: " + ShortFn + ", File(" + FORMAT$(RealLines) + "), State(" + PARSE$(H1, ",", 2) + ") STATE ignored")  '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Grab Panel data if present                                                             |
         '-----------------------------------------------------------------------------------------+
         t = PARSE$(H1, 10)                                       ' See if it's there
         IF ISNOTNULL(t) THEN                                     ' Something?
            PARSE t, PanelArray(), "/"                            ' Parse it's values
            PanelType  = PanelArray(1)                            ' Get the N/H/V
            PanelPct   = VAL(PanelArray(2))                       ' Get the %Split value nn.n
            PanelTop1  = VAL(PanelArray(3))                       ' Get topline(s)
            PanelTop2  = VAL(PanelArray(4))                       '
            IF PanelType = "H" THEN PanelSplit = (PanelPct * (gENV.ScrHeight - 1) / 100) + 1
            IF PanelType = "V" THEN PanelSplit = (PanelPct * (gENV.ScrWidth - 1) / 100) + 1
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Do Labels if present                                                                   |
         '-----------------------------------------------------------------------------------------+
         LblCount = VAL(PARSE$(H1, ",", 4))                       ' Get label count
         IF LblCount > 0 THEN                                     ' We have some to do
            LINE INPUT # FNum, HL                                 ' Get the label line
            IF LEFT$(HL, 2) <> "#L" THEN                          ' Better be the label line
               CLOSE # FNum                                       '
               MErrExit(%eFail, "STATE Label line for: " + ShortFn + " is misplaced, STATE terminating.")   '
            ELSE                                                  '
               HL = MID$(HL, 3)                                   ' Strip off the #L
            END IF                                                '
            j = PARSECOUNT(HL) - 1                                ' How many on the line
            IF j <> LblCount THEN _                               ' If not a match
               TP.ErrMsgAdd(%eFail, "STATE Label Count mismatch for: " + SHortFn + " Detail (" + FORMAT$(j) + "), Header(" + FORMAT$(LblCount) + "), Attempting STATE regardless")  ' Else tell user

            IF ISFALSE IsMedit THEN                               ' Not if MEdit
               FOR k = 1 TO PARSECOUNT(HL) - 1                    ' Loop through the entries
                  t = PARSE$(HL, ",", k)                          ' Get next string
                  llabel = PARSE$(t, "/", 1)                      ' Get line label
                  IF ISFALSE IsCopy THEN                          ' and NOT COPY?
                     i = VAL(PARSE$(t, "/", 2)) + FromLine - 1    ' Get line no
                     IF i > LastLine - 1 THEN                     ' Avoid out of range errors
                        ITERATE                                   ' Next For loop item
                     END IF                                       '
                     t = me.GetWriteLine(i, RealLines)            ' Get a 'massaged' line
                     llabel = UUCASE(llabel)                      ' Uppercase it
                     IF LEFT$(llabel, 2) = "._" THEN              ' Is this actually a Handle?
                        HNDL = VAL(MID$(llabel, 3))               ' Extract the number
                        nodup = 0                                 ' Reset exit flag
                        FOR l = 1 TO LastLine                     ' See if handle already exists
                           IF lHndlG(l) = HNDL THEN               ' A duplicate? Remember that
                              Duplabel = %True: nodup = %true     '
                              EXIT FOR                            '
                           END IF                                 '
                        NEXT l                                    '
                        IF ISFALSE nodup THEN                     ' If OK
                           lHndlS(i) = VAL(MID$(llabel, 3))       ' Yes, stuff it back
                           HandleLast = MAX(HandleLast, HNDL)     ' Save high water mark
                        END IF                                    '
                     ELSE                                         '
                        nodup = 0                                 ' Reset exit flag
                        FOR l = 1 TO LastLine                     ' See if label already exists
                           IF TRIM$(L(l).LLbl) = llabel THEN Duplabel = %True: nodup = %true ' A duplicate? Remember that
                        NEXT l                                    '
                        IF ISFALSE nodup THEN                     ' If still OK
                           LLblS(I) = llabel                      ' Then Re-insert the label
                           me.UpdLControl(i)                      ' Update LLCtl
                        END IF                                    '
                     END IF                                       '
                     ITERATE FOR                                  ' Done this one
                  END IF                                          '
               NEXT K                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do Tags if present                                                                     |
         '-----------------------------------------------------------------------------------------+
         TagCount = VAL(PARSE$(H1, ",", 5))                       ' Get Tag count
         IF TagCount > 0 THEN                                     ' We have some to do
            LINE INPUT # FNum, HT                                 ' Get the tag line
            IF LEFT$(HT, 2) <> "#T" THEN                          ' Better be the tag line
               CLOSE # FNum                                       '
               MErrExit(%eFail, "STATE Tag line for: " + ShortFn + " is misplaced, STATE terminating.")  '
            ELSE                                                  '
               HT = MID$(HT, 3)                                   ' Strip off the #T
            END IF                                                '
            j = PARSECOUNT(HT) - 1                                ' How many on the line
            IF j <> TagCount THEN _                               ' If not a match
               TP.ErrMsgAdd(%eFail, "STATE Tag Count mismatch for: " + SHortFn + " Detail (" + FORMAT$(j) + "), Header(" + FORMAT$(TagCount) + "), Attempting STATE regardless") ' Else tell user
            FOR k = 1 TO PARSECOUNT(HT) - 1                       ' Loop through the entries
               t = PARSE$(HT, ",", k)                             ' Get next string
               lcltag = PARSE$(t, "/", 1)                         ' Get line tag
               IF ISFALSE IsCopy THEN                             ' and NOT COPY?
                  i = VAL(PARSE$(t, "/", 2)) + FromLine - 1       ' Get line no
                  IF i > LastLine - 1 THEN                        ' Avoid out of range errors
                     ITERATE                                      ' Next For loop item
                  END IF                                          '
                  t = me.GetWriteLine(i, RealLines)               ' Get a 'massaged' line
                  lcltag = UUCASE(lcltag)                         ' Uppercase it
                  LTagS(i) = lcltag                               ' Then Re-insert the tag
                  me.UpdLControl(i)                               ' Update LLCtl
                  ITERATE FOR                                     ' Done this one
               END IF                                             '
            NEXT K                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do User flags if present                                                               |
         '-----------------------------------------------------------------------------------------+
         UsrCount = VAL(PARSE$(H1, ",", 6))                       ' Get Usr count
         IF UsrCount > 0 THEN                                     ' We have some to do
            LINE INPUT # FNum, HU                                 ' Get the user line
            IF LEFT$(HU, 2) <> "#U" THEN                          ' Better be the Usr line
               CLOSE # FNum                                       '
               MErrExit(%eFail, "STATE User line for: " + ShortFn + " is misplaced, STATE terminating.") '
            ELSE                                                  '
               HU = MID$(HU, 3)                                   ' Strip off the #U
            END IF                                                '
            j = PARSECOUNT(HU) - 1                                ' How many on the line
            IF j <> UsrCount THEN _                               ' If not a match
               TP.ErrMsgAdd(%eFail, "STATE User Count mismatch for: " + SHortFn + " Detail (" + FORMAT$(j) + "), Header(" + FORMAT$(UsrCount) + "), Attempting STATE regardless")   ' Else tell user
            FOR k = 1 TO PARSECOUNT(HU) - 1                       ' Loop through the entries
               t = PARSE$(HU, ",", k)                             ' Get next string
               i = VAL(PARSE$(t, "/", 1)) + FromLine - 1          ' Get line number
               IF i > LastLine - 1 THEN                           ' Avoid out of range errors
                  ITERATE                                         ' Next For loop item
               END IF                                             '
               t = me.GetWriteLine(i, RealLines)                  ' Get a 'massaged' line
               me.LFlagBitOn(i, %User)                            ' Then Re-insert the flag
               ITERATE FOR                                        ' Done this one
            NEXT K                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do Attr if present                                                                     |
         '-----------------------------------------------------------------------------------------+
         ClrCount = VAL(PARSE$(H1, ",", 7))                       ' Get Attr count
         IF ClrCount > 0 THEN                                     ' We have some to do
            LINE INPUT # FNum, HC                                 ' Get the Attr line
            IF LEFT$(HC, 2) <> "#C" THEN                          ' Better be the Attr line
               CLOSE # FNum                                       '
               MErrExit(%eFail, "STATE HiLite line for: " + ShortFn + " is misplaced, STATE terminating.")  '
            ELSE                                                  '
               HC = MID$(HC, 3)                                   ' Strip off the #C
            END IF                                                '
            j = PARSECOUNT(HC) - 1                                ' How many on the line
            IF j <> ClrCount THEN _                               ' If not a match
               TP.ErrMsgAdd(%eFail, "STATE HiLite Count mismatch for: " + SHortFn + " Detail (" + FORMAT$(j) + "), Header(" + FORMAT$(ClrCount) + "), Attempting STATE regardless") ' Else tell user
            FOR k = 1 TO PARSECOUNT(HC) - 1                       ' Loop through the entries
               t = PARSE$(HC, ",", k)                             ' Get next string
               i = VAL(PARSE$(t, "/", 1)) + FromLine - 1          ' Get line no
               tclr = PARSE$(t, "/", 2)                           ' Get color value
               tcol = VAL(PARSE$(t, "/", 3))                      ' Get column value
               tlen = VAL(PARSE$(t, "/", 4))                      ' Get length value
               t = me.GetWriteLine(i, RealLines)                  ' Get a 'massaged' line
               a = INSTR(gHiLitesChrs, tclr)                      ' Get index of the color char
               me.AttrHiLiteSet(i, tcol, tcol + tlen - 1, a)      '
               ITERATE FOR                                        ' Done this one
            NEXT K                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do Exclude if present                                                                  |
         '-----------------------------------------------------------------------------------------+
         XCount = VAL(PARSE$(H1, ",", 8))                         ' Get X count
         IF XCount > 0 THEN                                       ' We have some to do
            LINE INPUT # FNum, HX                                 ' Get the X line
            IF LEFT$(HX, 2) <> "#X" THEN                          ' Better be the X line
               CLOSE # FNum                                       '
               MErrExit(%eFail, "STATE Xclude line for: " + ShortFn + " is misplaced, STATE terminating.")  '
            ELSE                                                  '
               HX = MID$(HX, 3)                                   ' Strip off the #X
            END IF                                                '
            j = PARSECOUNT(HX) - 1                                ' How many on the line
            IF j <> XCount THEN _                                 ' If not a match
               TP.ErrMsgAdd(%eFail, "STATE XcludeCount mismatch for: " + SHortFn + " Detail (" + FORMAT$(j) + "), Header(" + FORMAT$(XCount) + "), Attempting STATE regardless") ' Else tell user
            FOR k = 1 TO PARSECOUNT(HX) - 1                       ' Loop through the entries
               t = PARSE$(HX, ",", k)                             ' Get next string
               i = VAL(PARSE$(t, "/", 1)) + FromLine - 1          ' Get line no
               IF i < @P.PTopLine THEN INCR @P.PTopLine           ' Adjust TopScrn if X is above it
               l = VAL(PARSE$(t, "/", 2))                         ' Get count of lines
               FOR a = i TO i + l - 1                             ' Init the loop
                  IF ISFALSE IsLBottom(a) THEN me.LFlagBitOn(a, %Invisible)   ' Mark the line Invisible now
               NEXT a                                             '
            NEXT k                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do NOTE lines if present                                                               |
         '-----------------------------------------------------------------------------------------+
         NoteCount = VAL(PARSE$(H1, ",", 9))                      ' Get Note count
         IF NoteCount > 0 THEN                                    ' We have some to do
            DO WHILE NoteCount                                    ' Loop doing them
               IF ISFALSE EOF(FNum) THEN                          ' Better be some lines here
                  LINE INPUT # FNum, HN                           ' Get a NOTE line
                  IF LEFT$(HN, 2) <> "#N" THEN                    ' Better be a NOTE line
                     CLOSE # FNum                                 '
                     MErrExit(%eFail, "STATE Note line for: " + ShortFn + " is misplaced, STATE terminating.") '
                  ELSE                                            '
                     HN = MID$(HN, 3)                             ' Strip off the #N
                  END IF                                          '
                  DECR NoteCount                                  ' Count them
                  j = VAL(PARSE$(HN, "/", 1))                     ' Get Note type
                  i = VAL(PARSE$(HN, "/", 2)) + FromLine - 1 + bias  ' Get line no
                  k = INSTR(HN, "/")                              ' Find next /
                  k = INSTR(k + 1, HN, "/")                       ' Find another /
                  t = MID$(HN, k + 1)                             ' Get the text
                  me.LInsertLines(i, 1, %Note)                    ' Insert a line to hold the Note
                  me.LTxtSet(i + 1, t)                            ' Add the text
                  LWrk2S(i + 1) = j                               ' Set the note type
                  IF IsLInvisible(i) AND IsLInvisible(i + 2) THEN me.LFlagBitOn(i + 1, %Invisible) '
                  me.UpdLControl(i + 1)                           ' Setup LLCtl
                  INCR Bias                                       '
               ELSE                                               ' We've hit EOF
                  CLOSE # FNum                                    '
                  MErrExit(%eFail, "STATE file is missing Note lines for: " + ShortFn + ", STATE terminating") '
               END IF                                             '
            LOOP                                                  '
         END IF                                                   '

         CLOSE # FNum                                             '
         FileTouch(lclFn, RCA)                                    ' Touch the STATE file to show activity

         '-----------------------------------------------------------------------------------------+
         '- Finish off                                                                             |
         '-----------------------------------------------------------------------------------------+
         IF duplabel THEN                                         ' Duplicate?
            TP.ErrMsgAdd(%eFail, "Warning, MEDIT detected duplicate labels, only the 1st reloaded")   '
         END IF                                                   '
         me.LFlagBitOn(@P.PTopLine, %TopScreen)                   ' Ensure TopScrn gets saved
         '-----------------------------------------------------------------------------------------+
         '- Re-establish Panels if we know about them                                              |
         '-----------------------------------------------------------------------------------------+
         IF PanelType = "V" OR PanelType = "H" THEN               ' Was it in Panel mode?
            P1.PPanelPct = PanelPct                               ' Ensure P1 % has been set
            IF PanelType = "H" THEN                               ' Horizontal split?
               TP.HPanelSplit = PanelSplit: TP.VPanelSplit = 0    ' Set the value
               TP.PanelSet(1, 1, TP.HPanelSplit - 1, 1, gENV.ScrWidth, "H", %False)
               TP.PanelSet(2, TP.HPanelSplit + 1, gENV.ScrHeight - gENV.PFKShow, 1, gENV.ScrWidth, "H", %False)
            ELSE                                                  ' Vertical split?
               TP.VPanelSplit = PanelSplit: TP.HPanelSplit = 0    ' Set it
               TP.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, TP.VPanelSplit - 1, "V", %False)
               TP.PanelSet(2, 1, gENV.ScrHeight - gENV.PFKShow, TP.VPanelSplit + 1, gENV.ScrWidth, "V", %False)
            END IF                                                '
            P1.PTopLine = PanelTop1                               ' Set top of screen line for panel 1
            P2.PTopLine = PanelTop2                               ' Set top of screen line for panel 2
            TP.PPSetP1                                            ' Start with P1 active
         ELSE                                                     ' Neither H nor V
            TP.HPanelSplit = 0: TP.VPanelSplit = 0                ' Set both to zero
            P1.PTopLine = PanelTop1                               ' Set top of screen line for panel 1
         END IF                                                   '
         OnStateExist                                             ' Remember STATE data existed
         DoStatusBar($SBState)                                    ' re-Do the StatusBar box
         MExitMeth                                                '

      END METHOD                                                  '

      METHOD StateSave(fn AS STRING, fline AS LONG, tline AS LONG, filter AS LONG) AS LONG   '
      '--------------------------------------------------------------------------------------------+
      '- Save the STATE information                                                                |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL RealLines, FNum, lclTop, LblLines, TagLines, ClrLines, XLines, UsrLines, NoteLines AS LONG   '
      LOCAL HL, HT, HC, HX, HU, lclFn, AttrClr, PanelStat AS STRING          '
      LOCAL k, x, bail, attr AS LONG, t AS STRING,  aTxt AS WSTRING  '
      LOCAL AttrAsc1, AttrAsc2 AS WORD                            '
      LOCAL Notes() AS STRING                                     '
      DIM Notes(1 TO 100) AS STRING                               '

         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Ensure file not in modified state                                                      |
         '-----------------------------------------------------------------------------------------+
         IF IsModdFlag THEN METHOD = %True: MExitMeth             ' Bail out, say no STATE created
         IF gTerminateInProgress THEN METHOD = %True: MExitMeth   ' If in shutdown, kill it?

         '-----------------------------------------------------------------------------------------+
         '- Make the fn into a 'safe' fn                                                           |
         '-----------------------------------------------------------------------------------------+
         lclFn = fn + ".STATE"                                    ' Temp copy with .STATE on the end
         REPLACE ANY ":\/" WITH "```" IN lclFN                    ' Make : / and \ into `
         lclFn = gENV.HomeData + "STATE\" + lclFn                 ' Add our STATE folder

         '-----------------------------------------------------------------------------------------+
         '- See if we even do anything at all                                                      |
         '-----------------------------------------------------------------------------------------+
         IF fn = "\" THEN METHOD = %True: MExitMeth               ' If this is an empty tab bail out

         '-----------------------------------------------------------------------------------------+
         '- Check STATE is on                                                                      |
         '-----------------------------------------------------------------------------------------+
         IF FCB.StateFlag = %StateOff THEN                        ' If we're not even doing STATE

            '--------------------------------------------------------------------------------------+
            '- No STATE data, delete any existing STATE file                                       |
            '--------------------------------------------------------------------------------------+
            FileRecycleBin(lclFN, "D")                            ' Delete STATE file to the recycle bin
            OffStateExist                                         ' Remember no STATE data existed
            DoStatusBar($SBState)                                 ' re-Do the StatusBar box

         '-----------------------------------------------------------------------------------------+
         '- OK, it appears STATE needs to be taken under some kind of circumstances                |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     '
            '--------------------------------------------------------------------------------------+
            '- See if FEW/MANY conditions to be met                                                |
            '--------------------------------------------------------------------------------------+
            IF FCB.StateFlag = %StateFew  AND ISFALSE ISFILE(lclFn) AND ISFALSE IsStateForce THEN METHOD = %True: MExitMeth   '
            IF FCB.StateFlag = %StateMost AND IsNullFile(lclFn) THEN METHOD = %True: MExitMeth  '

            '--------------------------------------------------------------------------------------+
            '- Spin through data lines collecting STATE data                                       |
            '--------------------------------------------------------------------------------------+
            lclTop = P1.PTopLine                                  '
            FOR i = fline TO tline                                ' Loop through the line range

               '-----------------------------------------------------------------------------------+
               '- Adjust Topscrn for Special lines above the TOS pointer                           |
               '-----------------------------------------------------------------------------------+
               IF i < P1.PTopLine THEN                            ' If above topscrn, adjust for specials
                  IF ISTRUE (L(i).LFlag AND (%Prof OR %Word OR %Mark OR %Mask OR %Tabs OR %Cols OR %Bounds OR %EFT)) THEN  '
                     DECR lclTop                                  ' Adjust lclTop
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Do filtering if needed to match the callers                                      |
               '-----------------------------------------------------------------------------------+
               IF IsLInsertLine(i) THEN ITERATE FOR               ' Ignore Insert lines
               IF filter THEN                                     ' Filtering asked for?
                  IF (PTBL.FlgNX AND IsLInvisible(i)) OR _        ' NX? If Invisible skip it
                     (PTBL.FlgX AND ISFALSE IsLInvisible(i)) OR _ ' X? If not Invisible skip it
                     (PTBL.FlgU AND ISFALSE IsLUser(i)) OR _      ' U?  If Not a User line, skip it?
                     (PTBL.FlgNU AND IsLUser(i)) THEN ITERATE FOR ' NU?  Skip if a User line?
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Do Data lines                                                                    |
               '-----------------------------------------------------------------------------------+
               IF IsLData(i) THEN                                 ' Data lines
                  INCR RealLines                                  ' Count real text lines
                  t = me.GetWriteLine(i, RealLines)               ' Get a 'massaged' line

                  IF ISFALSE IsMEdit THEN                         ' Don't do Labels and Handles in MEdit
                     '-----------------------------------------------------------------------------+
                     '- Handle Labels                                                              |
                     '-----------------------------------------------------------------------------+
                     IF L(i).LLbl <> $BlankLNo THEN               ' Look for any Labels
                        INCR LblLines                             ' Count them
                        IF LblLines = 1 THEN HL = "#L"            ' Initialize Label line
                        HL += TRIM$(L(i).LLbl) + "/" + FORMAT$(RealLines) + "/0,"   ' Add to HL string
                     END IF                                       '

                     '-----------------------------------------------------------------------------+
                     '- Handle Handles                                                             |
                     '-----------------------------------------------------------------------------+
                     IF L(i).LHndl <> 0 THEN                      ' Look for any Handles
                        INCR LblLines                             ' Count them
                        IF LblLines = 1 THEN HL = "#L"            ' Initialize Label line
                        HL += "._" + FORMAT$(L(i).LHndl) + "/" + FORMAT$(RealLines) + "/0,"  ' Add to HL string
                     END IF                                       '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Handle Tags                                                                   |
                  '--------------------------------------------------------------------------------+
                  IF LTagG(i) <> $BlankLNo THEN                   ' Look for any tags
                     INCR TagLines                                ' Count them
                     IF TagLines = 1 THEN HT = "#T"               ' Initialize Tag line
                     HT += TRIM$(LTagG(i)) + "/" + FORMAT$(RealLines) + "/0," ' Add to TL string
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Handle User Lines                                                             |
                  '--------------------------------------------------------------------------------+
                  IF IsLUser(i) THEN                              ' Look for %User flag
                     INCR UsrLines                                ' Count them
                     IF UsrLines = 1 THEN HU = "#U"               ' Initialize User Line
                     HU += FORMAT$(RealLines) + "/0,"             ' Add to HU string
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- PEN Clr entries                                                               |
                  '--------------------------------------------------------------------------------+
                  aTxt = LAttrG(i)                                ' Get temp copy of Attr
                  aTxt = LEFT$(aTxt, LEN(t))                      ' Truncate to LEN(t) in case of PRESERVE NO
                  FOR j = 1 TO LEN(Atxt)                          ' Loop through it
                     AttrAsc1 = ASC(aTxt, j) AND %AttrHiLite      ' Get any HiLite
                     IF AttrAsc1 <> 0 THEN                        ' Anything
                        k = AttrAsc1                              ' Temp copy
                        SHIFT RIGHT k, 12                         ' Right align
                        AttrClr = MID$(gHiLitesChrs, k, 1)        ' Convert to a single Alpha character
                        INCR ClrLines                             ' Count
                        IF ClrLines = 1 THEN HC = "#C"            '
                        HC += FORMAT$(RealLines) + "/" + AttrClr + "/"  + FORMAT$(j) + "/"   ' Start building the entry
                        FOR k = j TO LEN(aTxt)                    ' Look for end of hilight string
                           AttrAsc2 = ASC(aTxt, k) AND %AttrHiLite   ' Get next Attr byte
                           IF AttrAsc2 = AttrAsc1 THEN            ' Still the same?
                              IF k <> LEN(aTxt) THEN              ' If not last char
                                 ITERATE FOR                      ' -> keep looking
                              ELSE                                ' Last char?
                                 INCR k                           ' -> incr k by one for next line
                                 HC += FORMAT$(k - j)             ' Insert the length
                              END IF                              '
                           ELSE                                   '
                              HC += FORMAT$(k - j)                ' Found Attr diff, insert the length
                           END IF                                 '
                           j = k - 1: EXIT FOR                    ' Set J back by 1 so the NEXT i below doesn't double update it
                        NEXT k                                    '
                        HC += "/0,"                               '
                     END IF                                       '
                  NEXT i                                          '

               ELSEIF IsLXclude(i) THEN                           ' An X marker?
                  j = LWrk1G(i)                                   ' Get lines in the block
                  IF filter THEN                                  ' Filtering asked for?
                     FOR k = i + 1 TO i + j                       ' Scan block for NOTE/U/NU lines
                        IF IsLNote(k) THEN DECR j                 ' If a NOTE reduce X range
                        IF (PTBL.FlgU AND ISFALSE IsLUser(k)) OR _   ' If U or NU filtered,
                           (PTBL.FlgNU AND IsLUser(k)) THEN DECR j   ' then adjust count
                     NEXT                                         '
                  END IF                                          '
                  IF j > 0 THEN                                   ' Any left?
                     INCR XLines                                  ' Count it
                     IF XLines = 1 THEN HX = "#X"                 ' Init string
                     HX += FORMAT$(RealLines + 1) + "/" + FORMAT$(j) + "," ' Add to XL string
                  END IF                                          '

               '-----------------------------------------------------------------------------------+
               '- NOTE line(s)                                                                     |
               '-----------------------------------------------------------------------------------+
               ELSEIF IsLNote(i) THEN                             ' Look for NOTE lines
                  IF L(i).LWrk2 < 23 THEN                         ' Ignore Notes W/X/Y
                     INCR NoteLines                               ' Start counting
                     IF NoteLines > UBOUND(Notes()) THEN _        ' Keep array big enough
                        REDIM PRESERVE Notes(1 TO UBOUND(Notes()) * 2) AS STRING '
                     Notes(NoteLines) = "#N" + FORMAT$(L(i).LWrk2) + "/" + FORMAT$(RealLines) + "/" + LTxtG(i) ' Save data
                  END IF                                          '
               END IF                                             '

            NEXT i                                                '

            '--------------------------------------------------------------------------------------+
            '- Collect PANEL state                                                                 |
            '--------------------------------------------------------------------------------------+
            IF HPanelSplit = 0 AND VPanelSplit = 0 THEN           ' No split active?
               PanelStat = "N/100/" + FORMAT$(lclTop) + "//"      ' Normal
            ELSEIF HPanelSplit <> 0 THEN                          ' Horiz?
               PanelStat = "H/" + FORMAT$(P1.PPanelPct, "00.0") + "/" + _
                                 FORMAT$(P1.PTopLine) + "/" + FORMAT$(P2.PTopLine) + "/"
            ELSE                                                  ' Vertical?
               PanelStat = "V/" + FORMAT$(P1.PPanelPct, "00.0") + "/" + _
                                 FORMAT$(P1.PTopLine) + "/" + FORMAT$(P2.PTopLine) + "/"
            END IF                                                '
            '--------------------------------------------------------------------------------------+
            '- Write the STATE file                                                                |
            '--------------------------------------------------------------------------------------+
            FNum = FREEFILE                                       ' Get a file number
            Call3(TryOpenOutPut(lclfn, FNum), _                   ' Try the open
                  DoMessageBox("Error writing STATE file, Open failed", %MB_OK OR %MB_USERICON, "STATESave"): METHOD = %True: MExitMeth, _   '
                  DoMessageBox("Error writing STATE file, File is in use", %MB_OK OR %MB_USERICON, "STATESave"): METHOD = %True: MExitMeth, _   '
                  Nul)                                            ' Continue
            PRINT # FNum, "[[--SPFLite-File-State-Information-//-Do-NOT-Modify--]]" '
            t = "#10," + _                                        '
                FORMAT$(RealLines) + "," + _                      '
                IIF$(IsMEdit, "1", FORMAT$(lclTop)) + "," + _     '
                FORMAT$(LblLines)  + "," + _                      '
                FORMAT$(TagLines)  + "," + _                      '
                FORMAT$(UsrLines)  + "," + _                      '
                FORMAT$(ClrLines)  + "," + _                      '
                FORMAT$(XLines)    + "," + _                      '
                FORMAT$(NoteLines) + "," + _                      '
                PanelStat          + ","                          '
            PRINT # FNum, t                                       '
                                                                  '
            '--------------------------------------------------------------------------------------+
            '- Dump Label line if present                                                          |
            '--------------------------------------------------------------------------------------+
            IF LblLines > 0 THEN _                                '
               PRINT # FNum, HL                                   '
            '--------------------------------------------------------------------------------------+
            '- Dump Tag line if present                                                            |
            '--------------------------------------------------------------------------------------+
            IF TagLines > 0 THEN _                                '
               PRINT # FNum, HT                                   '
            '--------------------------------------------------------------------------------------+
            '- Dump Usr line if present                                                            |
            '--------------------------------------------------------------------------------------+
            IF UsrLines > 0 THEN _                                '
               PRINT # FNum, HU                                   '
            '--------------------------------------------------------------------------------------+
            '- Dump Clr line if present                                                            |
            '--------------------------------------------------------------------------------------+
            IF ClrLines > 0 THEN _                                '
               PRINT # FNum, HC                                   '
            '--------------------------------------------------------------------------------------+
            '- Dump Exclude line if present                                                        |
            '--------------------------------------------------------------------------------------+
            IF XLines > 0 THEN _                                  '
               PRINT # FNum, HX                                   '

            '--------------------------------------------------------------------------------------+
            '- Dump out NOTE lines if present                                                      |
            '--------------------------------------------------------------------------------------+
            IF NoteLines > 0 THEN                                 ' NOTE lines saved?
               FOR j = 1 TO NoteLines                             ' Yes, dump them out
                  PRINT # FNum, Notes(j)                          '
               NEXT j                                             '
            END IF                                                '
            CLOSE # FNum                                          ' Then close it
            OffStateForce                                         ' Clear Force just in case
            OnStateExist                                          ' Remember STATE data existed
            DoStatusBar($SBState)                                 ' re-Do the StatusBar box
         END IF                                                   '
         MExitmeth                                                '
      END METHOD                                                  '

      METHOD SwapKill()                                           '
      '--------------------------------------------------------------------------------------------+
      '- UnMark and kill any text selection                                                        |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         IF IsSwapDrawn THEN                                      ' A previous one drawn?
            FOR i = SwapRect.Top TO SwapRect.Bottom               ' Clear previous UL Attr for the lines
               IF IsLData(i) THEN _                               ' Only Data lines
                  me.AttrClear(i, SwapRect.Left, SwapRect.Right, %AttrUL)  '
            NEXT i                                                '
            OffSwapDrawn                                          '
         END IF                                                   '
         OffSwapActive                                            '
      END METHOD                                                  '

      METHOD SwapScr()                                            '
      '--------------------------------------------------------------------------------------------+
      '- Underline the selected text on the screen                                                 |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
         IF ISFALSE IsSwapActive THEN EXIT METHOD                 ' Just in case
         IF IsSwapDrawn THEN                                      ' A previous one drawn?
            FOR i = SwapRect.Top TO SwapRect.Bottom               ' Clear previous UL Attr for the lines
               IF IsLData(i) THEN _                               ' Only Data lines
                  me.AttrClear(i, SwapRect.Left, SwapRect.Right, %AttrUL)  '
            NEXT i                                                '
            OffSwapDrawn                                          '
         END IF                                                   '

         FOR i = SwapSLin TO SwapELin                             ' Set UL Attr for the lines
            IF IsLData(i) THEN _                                  ' Only Data lines
               me.AttrSet(i, SwapSCol, SwapECol, %AttrUL)         '
         NEXT i                                                   '

         SwapRect.Left = SwapSCol: SwapRect.Right    = SwapECol   ' Save where we drew it
         SwapRect.Top   = SwapSLin: SwapRect.Bottom = SwapELin    ' Save where we drew it
         DoSet(%Refresh)                                          ' Have it looked at
         OnSwapDrawn                                              '
         CaretCreate                                              '
         DoCursor                                                 ' Get cursor back
         CaretShow                                                '
      END METHOD                                                  '

      METHOD TitleCase(lno AS LONG, scol AS LONG, ecol AS LONG)   '
      '--------------------------------------------------------------------------------------------+
      '- Do title case on one line                                                                 |
      '--------------------------------------------------------------------------------------------+
      DIM words() AS STRING                                       '
      LOCAL txt1, txt2 AS STRING                                  '
      LOCAL i, j, k, m AS LONG                                    '
         MEntry                                                   '
         txt1 = LLCASE(MID$(LTxtG(lno), scol, ecol - scol + 1))   ' Get copy of substring to process

         '-----------------------------------------------------------------------------------------+
         '- Break the line into words                                                              |
         '-----------------------------------------------------------------------------------------+
         i = PARSECOUNT(txt1, ANY " ,.:;/\=_[]{}()-|'" + $DQ)     ' COUNT words
         REDIM words(1 TO i) AS STRING                            ' Make table correct size
         PARSE txt1, words(), ANY " ,.:;/\=_[]{}()-|'" + $DQ      ' PARSE the words into the table
         m = 1                                                    ' Start scan at 1

         '-----------------------------------------------------------------------------------------+
         '- Find each word now and uppercase it's 1st letter                                       |
         '-----------------------------------------------------------------------------------------+
         FOR j = 1 TO i                                           ' Loop for each word
            IF ISNOTNULL(words(j)) THEN                           ' Ignore null 'words'
               k = INSTR(m, txt1, words(j))                       ' Find location of this word

               '-----------------------------------------------------------------------------------+
               '- Watch for Contractions                                                           |
               '-----------------------------------------------------------------------------------+
               IF k > 1 AND MID$(txt1, k - 1, 1) = "'" THEN       ' IF opening delim IS a SINGLE '
                  IF k + LEN(words(j)) = LEN(txt1) + 1 OR _       ' If the last 'word' in the line
                     MID$(txt1, k + LEN(words(j)), 1) = " " THEN  ' or closed with a space
                     '-                                           ' Skip the uppercase
                  ELSE                                            '
                     MID$(txt1, k, 1) = UUCASE(MID$(txt1, k, 1))  ' Uppercase the 1st letter
                  END IF                                          '
               ELSE                                               '
                  MID$(txt1, k, 1) = UUCASE(MID$(txt1, k, 1))     ' Uppercase the 1st letter
               END IF                                             '
               m = k + LEN(words(j))                              ' Start scan adjust
            END IF                                                '
         NEXT j                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Stuff back the converted string                                                        |
         '-----------------------------------------------------------------------------------------+
         txt2 = LTxtG(lno)                                        ' Get whole text line
         MID$(txt2, scol, ecol - scol + 1) = txt1                 ' Stuff back in the processed txt
         me.LTxtSet(lno, txt2)                                    ' Replace the whole line
         me.AttrScan(lno)                                         ' Recolorize
         MExit                                                    '
      END METHOD                                                  '

      METHOD TPFMDFlag(i AS LONG) AS LONG: METHOD = gFMD(i).Flag: END METHOD  '

      METHOD Translate(BYREF InText AS STRING, TTbl AS LONG)      '
      '--------------------------------------------------------------------------------------------+
      '- Do a character translate                                                                  |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      LOCAL pSrc AS BYTE PTR                                      '
      LOCAL Rep() AS BYTE                                         '
      LOCAL tt AS STRING PTR                                      '
         tt = TTbl                                                '
         REDIM rep(255) AT STRPTR(@tt)                            ' Get the table
         pSrc = STRPTR(InText)                                    ' Create pointer to string
         FOR i = 1 TO LEN(InText)                                 ' Do each character
            @pSrc = rep(@pSrc)                                    '
            INCR pSrc                                             '
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD TTblLinNoGet(x AS LONG) AS LONG: METHOD = TTbl(x).LinNo: END METHOD '

      METHOD TTblLinNoSet(x AS LONG, lno AS LONG) AS LONG: TTbl(x).LinNo = lno: END METHOD   '

      METHOD TTblGet(x AS LONG) AS TouchEntry                     '
         METHOD = TTbl(x)                                         '
      END METHOD                                                  '
      METHOD TTblSet(x AS LONG, t AS TouchEntry)                  '
         TTbl(x) = t                                              '
      END METHOD                                                  '
      METHOD TTblReset(): RESET TCtr, TTbl(): END METHOD          '

      METHOD TTblScan(lno AS LONG) AS STRING                      '
      REGISTER i AS LONG                                          '
      LOCAL cv AS LAsString, tv AS STRING                         '
         MEntry                                                   '
         cv.LVar = lno: tv = cv.CVar                              '
         ARRAY SCAN TTbl(), FROM 1 TO 4, = tv, TO i               ' See if it's here
         IF i AND TTbl(i).LinNo <> 0 THEN                         ' and not been nulled
            METHOD = TTbl(i).LinCtl                               ' Pass String
         ELSE                                                     '
            METHOD = ""                                           ' Pass back Null
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD TrkAdd(tTop AS LONG, tRow AS LONG, tCol AS LONG)     '
      '--------------------------------------------------------------------------------------------+
      '- Add a Track Point entry                                                                   |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      LOCAL Trk AS TrkStackT                                      ' Working stack entry
         IF gMacroMode THEN EXIT METHOD                           ' No ADDs in Macro Mode
         INCR TrkNext                                             ' Incr Track ID
         Trk.TrkID = LTrakG(tTop)                                 ' Pickup TOS Track ID
         '-----------------------------------------------------------------------------------------+
         '- Convert screen row/col to an LPtr & text Col                                           |
         '-----------------------------------------------------------------------------------------+
         IF tRow <  @P.PData1 OR _                                ' In TOS area?
            @P.PS(tRow) < 1 THEN                                  ' Or invalid text line
            Trk.TrkRow = 0: Trk.TrkCol = 0                        ' Mark for the command line
         ELSE                                                     '
            i = @P.PS(tRow)                                       ' Get LPtr of the cursor line
            Trk.TrkRow = IIF(i, LTrakG(i), 0)                     ' Pick up Csr line Track ID
            Trk.TrkCol = IIF(tCol <= gLNPadCol, 0, tCol - gLNPadCol + @P.POffset)   '
            IF Trk.TrkRow = 0 THEN Trk.TrkCol = 0                 ' If row invalid, kill column
         END IF                                                   '
         IF Trk.TrkID = TrkStack(1).TrkID AND _                   ' Duplicate? (Before = Previous After)
            Trk.TrkRow = TrkStack(1).TrkRow AND _                 '
            Trk.TrkCol = TrkStack(1).TrkCol THEN                  '
            EXIT METHOD                                           ' Don't save it
         END IF                                                   '
         TrkIX = 0                                                ' Make it current 'go back' place
         ARRAY INSERT TrkStack(1), Trk                            ' Store in the stack
      END METHOD                                                  '

      METHOD TrkBak()                                             '
      '--------------------------------------------------------------------------------------------+
      '- Backup one Track Point                                                                    |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL Trk AS TrkStackT, r, c AS LONG                        '
         IF TrkNext = 0 THEN                                      ' Never Tracked, exit
            TP.ErrMsgAdd(%eNone, "No TRACK history yet")          ' Say so
            DoSet(%Attention)                                     ' Just have it looked at
            EXIT METHOD                                           ' And exit
         END IF                                                   '
         NextIX:                                                  '
         TrkIX = MIN(TrkIX + 1, %TrkMax)                          ' Bump for get next BAK
         Trk = TrkStack(TrkIX)                                    ' Get the Stack entry
         IF Trk.TrkID = 0 THEN                                    ' Unused entry? (i.e. no more)
            DECR TrkIX                                            ' Undo the bump
            TP.ErrMsgAdd(%eNone, "No further TRACK entries")      ' Say so
            DoSet(%Attention)                                     ' Just have it looked at
            EXIT METHOD                                           ' And exit
         END IF                                                   '
         i = me.TrkSrch(Trk.TrkID)                                ' Go fetch LPtr
         IF i = 0 THEN                                            ' Line missing? (i.e. deleted)
            ARRAY DELETE TrkStack(TrkIX)                          ' Remove the entry
            DECR TrkIX                                            ' Undo the bump
            TP.ErrMsgAdd(%eNone, "TRACK Top-of-Screen line no longer exists") ' Say so
            DoSet(%Attention)                                     ' Just have it looked at
            EXIT METHOD                                           ' And exit
         END IF                                                   '
         DECR i                                                   ' Table is zero based
         '-----------------------------------------------------------------------------------------+
         '- Now get the LPtr of the Cursor                                                         |
         '-----------------------------------------------------------------------------------------+
         IF Trk.TrkRow = 0 THEN                                   ' The Cmd line type?
            r = @P.PTop: c = @P.PCmdCol: j = 0                    ' Go to Cmd Line
         ELSE                                                     '
            j = me.TrkSrch(Trk.TrkRow)                            ' Go fetch LPtr for the TrkRow
            r = IIF(j = 0, @P.PTop, j - 1): c = IIF(j = 0, @P.PCmdCol, Trk.TrkCol)  ' Set row/col if we have an LPtr
         END IF                                                   '
         IF i = @P.PTopLine AND @P.PS(me.CsrRow) = r THEN GOTO NextIX   ' If sitting on the line, ignore it
         IF r = @P.PTop THEN                                      ' Cmd?
            me.CsrRow = @P.PTop: me.CsrCol = @P.PCmdCol           ' Go to Cmd Line
         ELSE                                                     '
            IF IsLInvisible(r) THEN GOTO NextIX                   ' Ignore if invisible
            me.CurSetReq(%Track, r, Trk.TrkCol, %True)            ' Set cursor in text area
         END IF                                                   '
         @P.PTopLine = i                                          ' Do the position
         DoSet(%Attention)                                        ' Just have it looked at
      END METHOD                                                  '

      METHOD TrkFwd()                                             '
      '--------------------------------------------------------------------------------------------+
      '- Forward one Track Point                                                                   |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL Trk AS TrkStackT, r, c AS LONG                        ' Working stack entry
         IF TrkNext = 0 THEN                                      ' Never Tracked, exit
            TP.ErrMsgAdd(%eNone, "No TRACK history yet")          ' Say so
            DoSet(%Attention)                                     ' Just have it looked at
            EXIT METHOD                                           ' And exit
         END IF                                                   '
         IF TrkIX < 2 THEN                                        ' Top?
            TP.ErrMsgAdd(%eNone, "No further TRACK entries")      ' Say so
            DoSet(%Attention)                                     ' Just have it looked at
            EXIT METHOD                                           ' And exit
         END IF                                                   '
         NextIXF:                                                 '
         DECR TrkIX                                               ' Move FWD 1
         Trk = TrkStack(TrkIX)                                    ' Get the Stack entry
         i = me.TrkSrch(Trk.TrkID)                                ' Fetch LPtr
         IF i = 0 THEN                                            ' Line missing? (i.e. deleted)
            ARRAY DELETE TrkStack(TrkIX)                          ' Remove the entry
            DECR TrkIX                                            ' Undo the bump
            TP.ErrMsgAdd(%eNone, "TRACK Top-of-Screen line no longer exists") ' Say so
            DoSet(%Attention)                                     ' Just have it looked at
            EXIT METHOD                                           ' And exit
         END IF                                                   '
         DECR i                                                   ' Table is zero based
         @P.PTopLine = i                                          ' Setup Topscrn
         '-----------------------------------------------------------------------------------------+
         '- Now get the LPtr of the Cursor                                                         |
         '-----------------------------------------------------------------------------------------+
         IF Trk.TrkRow = 0 THEN                                   ' The Cmd line type?
            r = @P.PTop: c = @P.PCmdCol: j = 0                    ' Go to Cmd Line
         ELSE                                                     '
            j = me.TrkSrch(Trk.TrkRow)                            ' Go fetch LPtr for the TrkRow
            r = IIF(j = 0, @P.PTop, j - 1): c = IIF(j = 0, @P.PCmdCol, Trk.TrkCol)  ' Set row/col if we have an LPtr
         END IF                                                   '
         IF i = @P.PTopLine AND @P.PS(me.CsrRow) = r THEN GOTO NextIXF  ' If sitting on the line, ignore it
         IF r = @P.PTop THEN                                      ' Cmd?
            me.CsrRow = @P.PTop: me.CsrCol = @P.PCmdCol           ' Go to Cmd Line
         ELSE                                                     '
            IF IsLInvisible(r) THEN GOTO NextIXF                  ' Ignore if invisible
            me.CurSetReq(%Track, r, Trk.TrkCol, %True)            ' Set cursor in text area
         END IF                                                   '
         @P.PTopLine = i                                          ' Do the position
         DoSet(%Attention)                                        ' Just have it looked at
      END METHOD                                                  '

      METHOD TrkSrch(TrkID AS LONG) AS LONG                       '
      '--------------------------------------------------------------------------------------------+
      '- Lookup a Track ID, return LPtr                                                            |
      '--------------------------------------------------------------------------------------------+
      LOCAL LAsS AS LAsString                                     '
         LAsS.LVar = TrkID                                        ' Pass lookup as a string
         METHOD = me.LLTrakScan(LAsS.CVar)                        ' See if we can find it
      END METHOD                                                  '

      METHOD TTblAdd(lno AS LONG, ldata AS STRING)                '
      REGISTER i AS LONG                                          '
         MEntry                                                   '
         IF TCtr > 0 THEN                                         ' Some already, see if already here
            FOR i = 1 TO TCtr                                     '
               IF TTbl(i).LinNo = lno THEN                        ' Already here?
                  TTbl(i).LinCtl = LSET$(ldata, 8)                ' Then replace the data
                  MExitMeth                                       ' We're done
               END IF                                             '
            NEXT i                                                '
         END IF                                                   '
         INCR TCtr                                                ' Must add it, Incr count
         IF TCtr > UBOUND(TTbl()) THEN _                          ' Keep table big enough
            REDIM PRESERVE TTbl(1 TO TCtr + 500) AS GLOBAL TouchEntry   '
         TTbl(TCtr).LinNo = lno                                   ' Save touched line
         TTbl(TCtr).LinCtl = LSET$(ldata, 8)                      ' And touched data
         TTbl(TCtr).LinCmd = $BlankLNo                            ' Clear all other fields
         TTbl(TCtr).LinRpt = 0                                    '
         TTbl(TCtr).LinFlag = 0                                   '
         TTbl(TCtr).LinCmdIX = 0                                  '
         TTbl(TCtr).LinCType = " "                                '
         TTbl(TCtr).LinCVar = " "                                 '
         MExit                                                    '
      END METHOD                                                  '

      METHOD TTblDel(lno AS LONG)                                 '
      REGISTER i AS LONG                                          '
         MEntry                                                   '
         IF TCtr = 0 THEN MExitMeth                               '
         FOR i = TCtr TO 1 STEP -1                                ' Loop through the Touched table
            IF BIT(TTbl(i).LinFlag, %LCmdR) THEN ITERATE FOR      ' If a R (retain) line command, ignore this
            IF TTbl(i).LinNo = lno THEN                           ' The one we're looking for?
               ARRAY DELETE TTbl(i)                               ' Delete the entry
               DECR TCtr                                          '
               EXIT FOR                                           '
            END IF                                                '
         NEXT i                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD UCIfNeeded(ix AS LONG)                               '
        IF (FCB.CapsDesired = 1 OR FCB.CapsActual = 1) AND IsLData(ix) THEN   ' CAPS ON?
           me.LTxtSet(ix, uucase(LTxtG(ix)))                      ' UC if CAPS is ON
        END IF                                                    '
      END METHOD                                                  '

      METHOD TTblSort()                                           '
      LOCAL i AS LONG                                             '
         ARRAY SORT TTbl() FOR TCtr, FROM 1 TO 4, CALL SortTouchTableExit()   '
      END METHOD                                                  '

      METHOD TTblPrune()                                          '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         MEntry                                                   '
         FOR i = TCtr TO 1 STEP -1                                ' Loop through the Touched table
            IF TTbl(i).LinNo = 0 THEN                             ' A 'nulled' entry
               ARRAY DELETE TTbl(i)                               ' Delete the entry
               INCR j                                             ' Count deleted, stay at tis index
            END IF                                                '
         NEXT i                                                   '
         TCtr -= j                                                '
         MExit                                                    '
      END METHOD                                                  '

      METHOD UndoInit()                                           '
      REGISTER i AS LONG                                          '
      LOCAL fn AS STRING                                          '
         MEntry                                                   '
         IF IsFMTab THEN MExitMeth                                ' Ignore accidental FM calls
         IF UBOUND(Undo) > 0 THEN                                 ' If any prior table, get rid of it
            FOR i = 1 TO UBOUND(Undo())                           ' Delete temporary files
               ON ERROR GOTO UndoError                            ' In case there are none to Kill
               IF ISNOTNULL(TRIM$(Undo(i).UFn)) THEN KILL TRIM$(Undo(i).UFn)  '
               IF ISNOTNULL(TRIM$(Undo(i).TFn)) THEN KILL TRIM$(Undo(i).TFn)  '
               IF ISNOTNULL(TRIM$(Undo(i).TWFn)) THEN KILL TRIM$(Undo(i).TWFn)   '
               IF ISNOTNULL(TRIM$(Undo(i).IXFn)) THEN KILL TRIM$(Undo(i).IXFn)   '
               UndoResume:                                        '
               ON ERROR GOTO 0                                    ' Kill error trap
            NEXT i                                                '
         END IF                                                   '

         IF gENV.UndoLevels > 0 THEN                              ' A new table needed?
            REDIM Undo(1 TO gENV.UndoLevels) AS INSTANCE UndoType ' Allocate Undo slot data
            FOR i = 1 TO gENV.UndoLevels                          ' Init Undotable
               Fn = GetTempFile("UNDO")                           ' Get temp files allocated
               Undo(i).UFn = Fn                                   ' Get temp files allocated
                                                                  '
               Fn = GetTempFile("UNDO")                           ' Get temp files allocated
               Undo(i).TFn = Fn                                   '
                                                                  '
               Fn = GetTempFile("UNDO")                           ' Get temp files allocated
               Undo(i).TWFn = Fn                                  '
                                                                  '
               Fn = GetTempFile("UNDO")                           ' Get temp files allocated
               Undo(i).IXFn = Fn                                  '
                                                                  '
               Undo(i).Time = 0                                   '
            NEXT i                                                '
         END IF                                                   '
         RESET UndoCurr                                           '
         MExitMeth                                                '

         UndoError:                                               '
            RESUME UndoResume                                     ' Ignore error
      END METHOD                                                  '


      METHOD UndoModifiedGet (BYVAL ix AS LONG) AS LONG: METHOD = Undo(ix).Modified: END METHOD '
      METHOD UndoModifiedSet (BYVAL ix AS LONG, BYVAL num AS LONG): Undo(ix).Modified = num: END METHOD  '
      METHOD UndoTopScrGet (BYVAL ix AS LONG) AS LONG: METHOD = Undo(ix).TopScr: END METHOD  '
      METHOD UndoTopScrSet (BYVAL ix AS LONG, BYVAL num AS LONG): Undo(ix).TopScr = num: END METHOD   '
      METHOD UndoLastLineGet (BYVAL ix AS LONG) AS LONG: METHOD = Undo(ix).LastLine: END METHOD '
      METHOD UndoLastLineSet (BYVAL ix AS LONG, BYVAL num AS LONG): Undo(ix).LastLine = num: END METHOD  '
      METHOD UndoLastRealGet (BYVAL ix AS LONG) AS LONG: METHOD = Undo(ix).LastReal: END METHOD '
      METHOD UndoLastRealSet (BYVAL ix AS LONG, BYVAL num AS LONG): Undo(ix).LastReal = num: END METHOD  '
      METHOD UndoTimeGet (BYVAL ix AS INTEGER) AS DOUBLE: METHOD = Undo(ix).Time: END METHOD '
      METHOD UndoTimeSet (BYVAL ix AS INTEGER, BYVAL num AS DOUBLE): Undo(ix).Time = num: END METHOD  '
      METHOD UndoUFnGet (BYVAL ix AS LONG) AS STRING: METHOD = Undo(ix).UFn: END METHOD   '
      METHOD UndoBusyGet (BYVAL ix AS LONG) AS LONG: METHOD = ISTRUE Undo(ix).Busy: END METHOD  '
      METHOD UndoBusySet (BYVAL ix AS LONG): Undo(ix).Busy = %True: END METHOD   '

      METHOD UndoSave()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Take an Undo save if needed                                                               |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j AS LONG, MEditStr AS STRING                      '
      LOCAL LUndo AS UNDOType POINTER                             ' Pointer to the UNDO Data
         MEntry                                                   '
         IF IsFMTab THEN MExitMeth                                ' Ignore accidental FM calls
         IF ISFALSE IsUndoFlag OR gENV.UndoLevels = 0 THEN MExitMeth ' Only if needed
         OffUndoFlag                                              ' Reset it
         IF UndoLast < gENV.UndoLevels THEN                       ' Select next save slot
            UndoLast += 1                                         '
         ELSE                                                     '
            UndoLast = 1                                          ' Wrap if at the end
         END IF                                                   '
         LUndo = VARPTR(Undo(UndoLast))                           ' Point at the entry used
         IF INSTR(@LUndo.UFn, "\UND") = 0 THEN                    ' A valid looking filename?
            DoMessageBox "The File name(s) in the |KUNDO|B control area do not appear to be valid." + $CRLF + $CRLF + _ '
                         "Bad Fn: |K" + @LUndo.UFn + "|B" + $CRLF + $CRLF + _ '
                         "The current UNDO SAVE function will be skipped.", %MB_OK OR %MB_USERICON, "SPFLite"  '
            MExitMeth                                             ' Don't do the UNDO
         END IF                                                   '
         j = 0                                                    ' Set escape counter
         DO WHILE @LUndo.Busy                                     ' Must wait if last write of this slot still active
           ' SLEEP 100                                             '
            DIALOG DOEVENTS 1
                                                                  '            INCR j                                                '
                                                                  '            IF j > 600 THEN EXIT DO                               ' 3 seconds?  Escape
         LOOP                                                     '

         '-----------------------------------------------------------------------------------------+
         '- Copy the TopScr/LastLine                                                               |
         '-----------------------------------------------------------------------------------------+
         @LUndo.TopScr = @P.PTopLine                              ' Just copy it
         @LUndo.LastLine = LastLine                               '
         @LUndo.LastReal = LastReal                               '
         @LUndo.Modified = IIF(IsModdFlag, %True, %False)         '
         @LUndo.UBoundL = UBoundL                                 '
         @LUndo.UBoundT = UBoundT                                 '
         @LUndo.UBoundB = UBOUND(BStack())                        '
         @LUndo.Time = TIMER                                      ' Save the time
         IF IsMedit THEN                                          ' If MEdit, must save individual modified status
            MEditStr = SPACE$(255)                                '
            FOR j = 1 TO MEditCount                               ' Pick up the MEdit modified values
               MID$(MEditStr, j, 1) = IIF$(me.MEditFlagGet(j), "T", "F")   ' Build string with T/F for each file
            NEXT j                                                '
            @LUndo.MEditMod = MEditStr                            ' Store it
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do the IX string, L(), T() and TW() arrays                                             |
         '-----------------------------------------------------------------------------------------+
         @LUndo.MCpyBusy = %True                                  ' Mark this as memory copy busy
         @LUndo.Busy = %True                                      ' Mark this slot Busy
         me.UndoPut(LUndo)                                        ' Go Write UNDO checkpoint
         UndoCurr = UndoLast                                      ' Make last written the current
         MExit                                                    '
      END METHOD                                                  '

      METHOD UndoTFnGet (BYVAL ix AS LONG) AS STRING: METHOD = Undo(ix).TFn: END METHOD   '
      METHOD UndoTWFnGet (BYVAL ix AS LONG) AS STRING: METHOD = Undo(ix).TWFn: END METHOD '
      METHOD UndoIXFnGet (BYVAL ix AS LONG) AS STRING: METHOD = Undo(ix).IXFn: END METHOD '
      METHOD UndoUBTGet (BYVAL ix AS LONG) AS LONG: METHOD = Undo(ix).UBoundT: END METHOD '
      METHOD UndoMEditGet (BYVAL ix AS LONG) AS STRING: METHOD = Undo(ix).MEditMod: END METHOD  '
      METHOD UndoMEditSet (BYVAL ix AS LONG, BYVAL st AS STRING): Undo(ix).MEditMod = st: END METHOD  '

      METHOD AddLockPrefix(MSG AS STRING)                         '
      '--------------------------------------------------------------------------------------------+
      '- Issue message with LOCK status added                                                      |
      '--------------------------------------------------------------------------------------------+
      LOCAL t AS STRING                                           '
         IF LEFT$(MSG, 1) = "?" THEN                              ' A query?
            t = MID$(MSG, 2)                                      ' Remove Query indicatot
            IF TP.EFTOVCtr THEN                                   ' EFT LOCK'ed ?
               TP.ErrMsgAdd(%eNone, t + ", Profile is EFT LOCKED")   ' Say so
            ELSEIF FCB.LockFlag = 1 THEN                          ' LOCK'ed ?
               TP.ErrMsgAdd(%eNone, t + ", Profile is LOCKED")    ' Say so
            ELSE                                                  ' UNLOCK'ed
               TP.ErrMsgAdd(%eNone, t + ", saved in the Profile") ' Say we saved it
            END IF                                                '
         ELSE                                                     '
            IF TP.EFTOVCtr THEN                                   ' EFT LOCK'ed ?
               TP.ErrMsgAdd(%eNone, MSG + " in this session, Not Saved, Profile is EFT LOCKED") ' Say so
            ELSEIF FCB.LockFlag = 1 THEN                          ' LOCK'ed ?
               TP.ErrMsgAdd(%eNone, MSG + " in this session, Not Saved, Profile is LOCKED")  ' Say so
            ELSE                                                  ' UNLOCK'ed
               TP.ErrMsgAdd(%eNone, MSG + ", saved in the Profile")  ' Say we saved it
            END IF                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD AdjustPending(ln AS LONG, Number AS LONG, CsrAdj AS LONG)  '
      '--------------------------------------------------------------------------------------------+
      '- Adjust all Pending stuff                                                                  |
      '--------------------------------------------------------------------------------------------+
      REGISTER x AS LONG                                          '
         MEntry                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Adjust TOS position if AttnPos active                                                  |
         '-----------------------------------------------------------------------------------------+
         IF gENV.AttnPos THEN                                     ' If AttnPos, adjust TOS
            IF ln < @P.PTopLine THEN LastTop += Number            '
            LastTop = MAX(1, LastTop)                             ' Ensure we don't go negative
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Adjust Cursor positioning                                                              |
         '-----------------------------------------------------------------------------------------+
         IF sCurPrio > 0 THEN                                     ' If Cursor request pending
            IF sCurLin > (ln + CsrAdj) THEN                       ' Only higher line numbers should need doing
               sCurLin = MAX(1, sCurLin + Number)                 '
            END IF                                                '
            IF (ln + CsrAdj) >= @P.C.CIX OR (ln + CsrAdj) + Number >= @P.C.CIX THEN   '
               '- Null                                            '
            ELSE                                                  '
               IF number > 0 THEN @P.C.CIX += number              ' Adjust @P.C.CIX if action above it
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Adjust gLTblB entries                                                                  |
         '-----------------------------------------------------------------------------------------+
         IF gLTblBIX <> 0 THEN                                    ' If gLTblB entries left
            FOR x = 1 TO gLTblBIX                                 ' Adjust remaining pending commands
               IF gLTblB(x).SrcFrom > ln THEN gLTblB(x).SrcFrom += Number  ' Only higher line numbers should need doing
               IF gLTblB(x).SrcTo > ln THEN gLTblB(x).SrcTo += Number   '
               IF gLTblB(x).DstFrom > ln THEN gLTblB(x).DstFrom += Number  '
               IF gLTblB(x).DstTo > ln THEN gLTblB(x).DstTo += Number   '
            NEXT x                                                ' Next pending command
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Adjust gLTblRange entries                                                              |
         '-----------------------------------------------------------------------------------------+
         IF gLTblRange THEN                                       ' Waiting line-range operands?
            IF gLTblSFrom > ln THEN gLTblSFrom += Number          ' If so, adjust source
            IF gLTblSTo  > ln THEN gLTblSTo  += Number            '
            IF gLTblDFrom > ln THEN gLTblDFrom += Number          ' If so, adjust destination
            IF gLTblDTo  > ln THEN gLTblDTo  += Number            '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Adjust Touch Table                                                                     |
         '-----------------------------------------------------------------------------------------+
         IF TCtr > 0 THEN                                         ' TTbl entries?
            FOR x = 1 TO TCtr                                     ' Loop through the Touched table
               IF me.TTblLinNoGet(x) > ln THEN                    ' A higher line number
                  me.TTblLinNoSet(x, me.TTblLinNoGet(x) + Number) ' Adjust it
               END IF                                             '
            NEXT x                                                '
         END IF                                                   '

         MExit                                                    '
      END METHOD                                                  '

      METHOD AFLCmdSet(i AS LONG, vl AS STRING)                   '
         gFMD(i).Cmd = vl                                         '
      END METHOD                                                  '

      METHOD AttrInvClear(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG)   '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            POKE WORD, i, (PEEK(WORD, i) AND (%AttrAll - %AttrInv))  ' Remove the INV flag
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD AttrInvClearFind()                                   '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         IF CursFindInv.Top <> 0 THEN                             ' If something marked
            j = LAttrSPtr(CursFindInv.Top)                        ' Get pointer to the line
            FOR i = j + ((CursFindInv.Left - 1) * 2) TO j + ((CursFindInv.Right - 1) * 2) STEP 2   ' Attr by Attr
               POKE WORD, i, (PEEK(WORD, i) AND (%AttrAll - %AttrInv))  ' Remove the INV flag
            NEXT i                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD AttrInvGet(lno AS LONG, pcolumn AS LONG) AS LONG     '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL AttrLine AS WSTRING POINTER                           '
         METHOD = %False                                          ' Default answer
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         i = j + ((pcolumn - 1) * 2)                              ' Point at Attr char
         IF (PEEK(WORD, i) AND %AttrInv) THEN METHOD = %True      ' Pass back INV status
      END METHOD                                                  '

      METHOD AttrInvGrab( lno AS LONG, ccolumn AS LONG)           '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL k AS LONG                                             '
         CursFindInv.Top = 0                                      ' Default to saying no hilite
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         k = j + (LAttrGLen(lno) - 1) * 2                         ' Get pointer to last Attr character
         IF LAttrGLen(lno) >= ccolumn THEN                        ' Only if a string is present and long enough
            i = j + (ccolumn - 1) * 2                             ' Point at cursor's location in line
            IF (PEEK(WORD, i) AND %AttrInv) = 0 THEN EXIT METHOD  ' If not sitting on a INV string, exit
            CursFindInv.Top = lno                                 ' Save the line number
            DO WHILE (i - 2) > j AND (PEEK(WORD, i - 2) AND %AttrInv) <> 0 ' Find start of INV string
               i -= 2                                             '
            LOOP                                                  '
            CursFindInv.Left = ((i - j) / 2) + 1                  ' Save Left end of INV string
            i = j + (ccolumn - 1) * 2                             ' Point at cursor's location in line
            DO WHILE (i + 2) <= k AND (PEEK(WORD, i + 2) AND %AttrInv) <> 0   ' Find end of INV string
               i += 2                                             '
            LOOP                                                  '
            CursFindInv.Right = ((i - j) / 2) + 1                 ' Save Right end of INV string
         END IF                                                   '
      END METHOD                                                  '

      METHOD AttrInvSet(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG)  '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            POKE WORD, i, (PEEK(WORD, i) OR %AttrInv)             ' Add the INV flag
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD AttrHiLiteClear(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG, pcolor AS LONG)  '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL scolor, AttrAsc AS WORD                               '
         scolor = pcolor                                          ' Get the color
         SHIFT LEFT scolor, 12                                    ' Shift up to hi-byte
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            AttrAsc = PEEK(WORD, i) AND %AttrHiLite               ' Get current hilite color
            IF scolor = AttrAsc THEN                              ' The requested color?
               POKE WORD, i, (PEEK(WORD, i) AND (%AttrAll - %AttrHiLite))  ' Remove the color
            END IF                                                '
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD AttrHiLiteGet(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG) AS STRING '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL t AS STRING, AttrLine AS WSTRING POINTER, AttrAsc AS WORD   '
         METHOD = ""                                              ' Default answer
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            AttrAsc = PEEK(WORD, i) AND %AttrHiLite               ' Get current hilite color
            SHIFT RIGHT AttrAsc, 12                               ' Shift to low order
            t += CHR$(AttrAsc)                                    ' Add in the CHR$ of the color
         NEXT i                                                   '
         METHOD = t                                               '
      END METHOD                                                  '

      METHOD AttrHiLiteSet(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG, pcolor AS LONG) '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL scolor AS LONG, AttrAsc AS WORD                       '
         scolor = pcolor                                          ' Get the color
         SHIFT LEFT scolor, 12                                    ' Shift up to hi-byte
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            POKE WORD, i, (PEEK(WORD, i) AND (%AttrAll - %AttrHiLite)) OR scolor ' Add in the color
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD AttrScan(lno AS LONG) AS LONG                        '
      '--------------------------------------------------------------------------------------------+
      '- Scan a line for Colorize                                                                  |
      '--------------------------------------------------------------------------------------------+
      LOCAL tSch, StartPos, ci, wFlag, TxtLen, MaxCmnt, GotComment, cFnd, q, qq, x, y, z AS LONG   '
      LOCAL qDlm AS STRING                                        '
      LOCAL letter, prvbyte, QSkip AS BYTE POINTER                '
      LOCAL ESCChar AS BYTE                                       '
      LOCAL sTxt AS STRING POINTER                                '
      LOCAL aTxt AS WSTRING POINTER                               '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL t, lclUpper AS STRING, found_str AS STRING POINTER    '
         MEntry                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Get set to go                                                                          |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO 9                                           ' See how many comment types
            IF Cmnt.GTxt1L(i) THEN INCR MaxCmnt                   ' Set the limit
         NEXT i                                                   '
         ESCChar = IIF(ISNOTNULL(ClrESC), ASC(ClrESC), 0)         ' Get local copy of ESC
         lclUpper = $Upper + $UpperNat                            ' Get full UC table
         sTxt = LTxtGP(lno): aTxt = LAttrGP(lno)                  ' Setup txt pointer variables
         TxtLen = LTXTGLen(lno)                                   ' Get length value once
         IF LEN(@atxt) < TxtLen THEN @aTxt = LSET$(@aTxt, TxtLen USING CHR$$(%SCTxtLo))   ' Init Attr line if needed
         aTxt = LAttrGP(lno)                                      '
         me.AttrClear(lno, 1, TxtLen, %AttrScheme)                ' Clear all Scheme attributes
         IF ISFALSE FCB.HiAuto OR ISFALSE IsClrFlag THEN MExitMeth   ' If colorization not possible, exit

         '-----------------------------------------------------------------------------------------+
         '- Start off doing EXCLUDE / INCLUDE stuff                                                |
         '-----------------------------------------------------------------------------------------+
         IF Cmnt.GEtxt(1) <> "" THEN GOSUB DoExclude              ' We have some excludes to do
         IF Cmnt.GITxt(1) <> "" THEN GOSUB DoInclude              ' Else test for INCLUDEs

         '-----------------------------------------------------------------------------------------+
         '- First look for posible comments                                                        |
         '-----------------------------------------------------------------------------------------+
         GotComment = %False                                      ' Say we saw none of them
         FOR i = 1 TO MaxCmnt                                     ' Look at all possible comment types
            IF Cmnt.GTxt1L(i) THEN                                ' A comment string present?
               x = 1                                              ' Set start scan
               DO                                                 ' Scan
                  Cmnt.SFnd(i, 0)                                 ' Reset Fnd in the Cmnt table
                  cFnd = INSTR(x, UCASE$(@sTxt), Cmnt.GTxt1(i))   ' Is it even in the line?
                  IF cFnd = 0 THEN ITERATE FOR                    ' No, skip to next
                  RESET Q, QQ                                     ' Reset
                  IF ISNOTNULL(ClrQLeft) THEN                     ' Is QUOTED active?
                     Q = INSTR(x, @sTxt, ANY ClrQLeft)            ' Look for a quote delimiter
                     IF Q THEN                                    ' Got quote
                        qDLM = MID$(@sTxt, Q, 1)                  ' Save which one
                        qq = INSTR(Q + 1, @sTxt, qDLM)            ' Look for closing
                     END IF                                       ' Q & QQ mark quoted string
                     IF Q AND QQ THEN                             ' If we found a quoted string
                        IF (cFnd > Q AND cFnd < QQ) _             ' Oops, found inside quotes
                        OR QQ < cFnd THEN                         ' or Quoted string < comment string
                           x = QQ + 1                             ' Step over close quote
                           ITERATE DO                             ' Continue scan
                        ELSE                                      ' Else we have a winner
                           Cmnt.SFnd(i, cFnd)                     ' Save found indication
                        END IF                                    '
                     ELSE                                         '
                        Cmnt.SFnd(i, cFnd)                        ' Save found indication
                     END IF                                       '
                  ELSE                                            '
                     Cmnt.SFnd(i, cFnd)                           ' Save found indication
                  END IF                                          '
                  IF Cmnt.GsCol(i) > 0 AND ISTRUE Cmnt.GFnd(i) <> Cmnt.GsCol(i) THEN Cmnt.SFnd(i, 0)  '
                  IF Cmnt.GFnd(i) > 0 THEN GotComment = %True     ' Remember we saw at least 1 comment
                  EXIT DO                                         '
               LOOP                                               '
            END IF                                                '
         NEXT i                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Set all the scan starting values                                                       |
         '-----------------------------------------------------------------------------------------+
         Letter = STRPTR(@sTxt) : wFlag = %False: StartPos = 1: i = 1   ' Startup values
         '-----------------------------------------------------------------------------------------+
         '- Now the hard work, byte by byte scanning                                               |
         '-----------------------------------------------------------------------------------------+
         DO                                                       ' Start real scanning
            '--------------------------------------------------------------------------------------+
            '- Past the end?  We're done                                                           |
            '--------------------------------------------------------------------------------------+
            IF i > TxtLen THEN                                    ' No more string? We're done
               IF ISTRUE wFlag THEN GOSUB CloseWord               ' If doing a word, go close it off
               MExitMeth                                          '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- White space detected                                                                |
            '--------------------------------------------------------------------------------------+
            IF @letter = 32 THEN                                  ' WhiteSpace?
               IF ISFALSE wFlag THEN                              ' Working on a word?
                  StartPos = i                                    ' No, Save start of whitespace area
                  DO WHILE @letter = 32 AND i <= TxtLen           ' find start of word
                     INCR letter: INCR i                          ' Move right
                  LOOP                                            '
                  me.AttrSchemesET(lno, StartPos, i - 1, %SCTxtLo)   ' Build the Attr line
                  IF i > TxtLen THEN                              ' Stopped by the end?
                     MExitMeth                                    ' We're done
                  ELSE                                            ' No, stopped by next string
                     ITERATE DO                                   ' Just loop back
                  END IF                                          '
               ELSE                                               ' We have a space delimited word
                  GOSUB CloseWord                                 ' Create an entry for it
                  ITERATE DO                                      ' Loop back
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Quote detected                                                                      |
            '--------------------------------------------------------------------------------------+
            IF ClrQuoted <> 0 THEN                                '
               x = INSTR(ClrQLeft, CHR$(@letter))                 ' Look for a quote delimiter
               IF x THEN                                          ' One of the quoted characters?
                  QSkip = STRPTR(ClrQRight) + x - 1               ' Point at the closing character
                  IF ISFALSE wflag THEN                           ' Not in a word?
                     wFlag = %True: StartPos = i                  ' Now we are
                  ELSE                                            '
                     GOSUB Closeword                              ' If in a word, close it
                     wFlag = %True: StartPos = i                  ' and start another
                  END IF                                          '
                  INCR letter: INCR i                             ' Move right
                  DO WHILE (@letter <> @QSkip) AND (i <= TxtLen)  ' find next quote
                     INCR letter: INCR i                          ' Move right
                     IF (@letter = ESCChar) AND (EscChar <> 0) THEN  ' Is this an ESC char?
                        IF i = TxtLen THEN                        ' At very last position of TXT?  Then ESC is 'orphaned'
                           Letter += 1: i += 1                    ' Step over 'orphaned' escape char ONLY
                        ELSE                                      ' they are not doing anything strange with ESC
                           Letter += 2: i += 2                    ' Step over escape AND escaped char
                        END IF                                    '
                     END IF                                       '
                  LOOP                                            '
                  IF i > TxtLen THEN                              ' Stopped by the end?
                     me.AttrSchemeSet(lno, StartPos, i, ClrQuoted)   ' Build the Attr line
                     wFlag = %False                               ' Turn off the word flag
                     MExitMeth                                    ' and bail out
                  ELSE                                            ' No, stopped by next Quote
                     me.AttrSchemeSet(lno, StartPos, i + 1, ClrQuoted)  ' Build the Attr line
                     wFlag = %False                               ' Turn off the word flag
                     INCR letter: INCR i                          ' Move right
                     ITERATE DO                                   ' Just loop back
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- See if we're at the point where any of the comments start                           |
            '--------------------------------------------------------------------------------------+
            IF GotComment THEN                                    ' ANything to even look for?
               FOR ci = 1 TO MaxCmnt                              ' Loop through the comment controls
                  '--------------------------------------------------------------------------------+
                  '- Are we're at the point where a comment starts?                                |
                  '--------------------------------------------------------------------------------+
                  IF (Cmnt.GTxt1L(ci) AND i = Cmnt.GFnd(ci)) THEN ' Finish line if rest is a Comment
                     IF ISTRUE wFlag THEN GOSUB CloseWord         ' If doing a word, go close it off

                     '-----------------------------------------------------------------------------+
                     '- Simple comment type                                                        |
                     '-----------------------------------------------------------------------------+
                     IF Cmnt.GTxt2L(ci) = 0 THEN                  ' If no closing trigger
                        me.AttrSchemeSet(lno, i, TxtLen, Cmnt.GSch(ci)) ' Build the Attr line
                        MExitMeth                                 ' We're done

                     '-----------------------------------------------------------------------------+
                     '- Start/End comment type like /*  */                                         |
                     '-----------------------------------------------------------------------------+
                     ELSE                                         '
                        j = INSTR(i + 1, @sTxt, Cmnt.GTxt2(ci))   ' Look for end comment delimiter
                        IF j = 0 THEN                             ' None, treat rest of line as comment
                           me.AttrSchemeSet(lno, i, TxtLen, Cmnt.GSch(ci)) ' Build the Attr line
                           MExitMeth                              ' We're done
                        ELSE                                      '
                           me.AttrSchemeSet(lno, i, j + Cmnt.GTxt2L(ci) - 1, Cmnt.GSch(ci))  ' Build the Attr line
                           letter = letter + (j - i) + Cmnt.GTxt2L(ci)  ' Adjust to continue scan
                           i = j + Cmnt.GTxt2L(ci)                '
                           Cmnt.SFnd(ci, INSTR(i, UUCASE(@sTxt), Cmnt.GTxt1(ci)))   ' See if a 2nd comment on the line
                           ITERATE DO                             ' Continue
                        END IF                                    '
                     END IF                                       '
                  END IF                                          '
               NEXT ci                                            '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- User specified delimiter detected                                                   |
            '--------------------------------------------------------------------------------------+
            IF INSTR(ClrDLM, CHR$(@letter)) THEN                  ' Look for a delimiter
               GOSUB GotDLM                                       ' Go handle DLM
               INCR letter: INCR i                                ' Step over
               ITERATE DO                                         ' and loop back
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Just any old character detected                                                     |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE wFlag THEN                                 ' Some other old character
               wFlag = %True: StartPos = i                        ' Just say we're in a word
            ELSE                                                  ' Maybe letter after a DLM?
               prvByte = letter - 1                               '
               IF INSTR(ClrDLM, CHR$(@prvbyte)) THEN              ' Look for a previous delimiter
                  GOSUB CloseWord                                 ' Yes, go output it
                  wFlag = %True: StartPos = i                     ' Start over
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- the ESC character detected                                                          |
            '--------------------------------------------------------------------------------------+
            IF @letter = ESCChar THEN                             ' Is this as ESC char?
               IF i < TxtLen THEN                                 ' Still remaining text?
                  Letter += 2: i += 2                             ' Step over 2 characters
               ELSE                                               '
                  INCR Letter: INCR i                             ' Do normal step over
               END IF                                             '
            ELSE                                                  '
               INCR Letter: INCR i                                ' Do normal step over
            END IF                                                '
         LOOP                                                     '
         MExitMeth                                                '

      '--------------------------------------------------------------------------------------------+
      '- End of word found, do KW lookup and build O/P control entry                               |
      '--------------------------------------------------------------------------------------------+
      CloseWord:                                                  '
         t = MID$(@sTxt, StartPos, i - StartPos)                  '
         tSch = me.ClrKwSrch(MID$(@sTxt, StartPos, i - StartPos), found_str)  ' Save colour from word lookup (zero default)
         '-----------------------------------------------------------------------------------------+
         '- See if a Numeric 'word'                                                                |
         '-----------------------------------------------------------------------------------------+
         IF tSch = %SCTxtLo THEN                                  ' If just a default scheme assigned by KwSrch
            IF VERIFY(MID$(@sTxt, Startpos, i - StartPos), "-0123456789.,") = 0 THEN   ' We have a numeric 'word'
               me.AttrSchemeSet(lno, StartPos, i, ClrNumeric)     ' Build the Attr line with the ClrNumeric value
            ELSE                                                  '
               me.AttrSchemeSet(lno, StartPos, i, tSch)           ' Build the Attr line with the returned value
            END IF                                                '
         ELSE                                                     ' Specific scheme passed back
            IF tSch < 100 THEN                                    ' A normal Scheme number?
               me.AttrSchemeSet(lno, StartPos, i, tSch)           ' Build the Attr string
            ELSEIF tSch < 200 THEN                                ' AUTOCAPS?
               tSch = ((tSch - 100) OR %AttrUC)                   ' Fudge to a UC version
               me.AttrSchemeSet(lno, StartPos, i, tSch)           ' Build the Attr line
            ELSE                                                  ' Must be COPYCASE
               y = 1: z = tSch - 200                              ' Point at 1st character, save tClr
               FOR x = StartPos TO i - 1                          ' Loop 1 char at a time
                  t = MID$(@found_str, y, 1)                      ' Get next char
                  IF INSTR(lclUpper, t) THEN                      ' An UC character
                     me.AttrSchemeSetOne(lno, x, (z + %AttrUC))   ' Set the Attr
                  ELSE                                            '
                     me.AttrSchemeSetOne(lno, x, (z + %AttrLC))   ' Set the Attr
                  END IF                                          '
                  INCR y                                          ' Bump to next char
               NEXT x                                             '
            END IF                                                '
         END IF                                                   '
         wFlag = %False                                           ' Turn off the word flag
         RETURN                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Delim found, maybe a word end or a word start                                             |
      '--------------------------------------------------------------------------------------------+
      GotDLM:                                                     '
         IF ISTRUE wFlag THEN                                     ' Working on a word?
            GOSUB CloseWord                                       ' Yes, go handle it
         END IF                                                   '
         StartPos = i: wFlag = %True                              ' Start over, call DLM a 'word'
         RETURN                                                   '

      '--------------------------------------------------------------------------------------------+
      '- See if this line to be excluded                                                           |
      '--------------------------------------------------------------------------------------------+
      DoExclude:                                                  '
         FOR i = 1 TO 9                                           ' Loop through Exclude list
            IF Cmnt.GETxt(i) = "" THEN RETURN                     ' Done? return as unexcluded
            IF Cmnt.GIsCol(i) = 0 THEN                            ' A scan type exclude?
               IF INSTR(UUCASE(@sTxt), Cmnt.GETxt(i)) <> 0 THEN GOSUB XcludeIt   '
            ELSE                                                  ' Fixed column test
               IF UUCASE(MID$(@sTxt, Cmnt.GEsCol(i), Cmnt.GETxtL(i))) = Cmnt.GETxt(i) THEN GOSUB XcludeIt   '
            END IF                                                '
         NEXT i                                                   '
         RETURN                                                   '

      '--------------------------------------------------------------------------------------------+
      '- See if this line to be included                                                           |
      '--------------------------------------------------------------------------------------------+
      DoInclude:                                                  '
         FOR i = 1 TO 9                                           ' Loop through Include list
            IF Cmnt.GITxt(i) = "" THEN GOSUB XcludeIt             ' Didn't find it, exclude the line
            IF Cmnt.GIsCol(i) = 0 THEN                            ' A scan type include?
               IF INSTR(UUCASE(@sTxt), Cmnt.GITxt(i)) <> 0 THEN RETURN  '
            ELSE                                                  ' Fixed column test
               IF UUCASE(MID$(@sTxt, Cmnt.GIsCol(i), Cmnt.GITxtL(i))) = Cmnt.GITxt(i) THEN GOSUB XcludeIt   '
            END IF                                                '
         NEXT i                                                   '
         GOSUB Xcludeit                                           ' Didn't match, exclude it
         RETURN                                                   '

      XcludeIt:                                                   '
         me.AttrSchemeSet(lno, 1, TxtLen, %SCTxtLo)               ' Build the Attr line
         MExitmeth                                                ' We're done

      END METHOD                                                  '

      METHOD AttrSchemeGet(lno AS LONG, pcolumn AS LONG) AS LONG  '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL AttrLine AS WSTRING POINTER                           '
         METHOD = %SCTxtLo                                        ' Default answer
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         i = j + ((pcolumn - 1) * 2)                              ' Point at Attr char
         METHOD = PEEK(WORD, i) AND %AttrSchNum                   ' Pass back Scheme number
      END METHOD                                                  '

      METHOD AttrSchemeSet(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG, scheme AS LONG) '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            POKE WORD, i, (PEEK(WORD, i) AND (%AttrAll - %AttrSchNum)) OR scheme ' Add in the scheme number
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD AttrSchemeSetOne(lno AS LONG, fcolumn AS LONG, scheme AS LONG)   '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         i = j + ((fcolumn - 1) * 2)                              ' Point at the single Attr
         POKE WORD, i, (PEEK(WORD, i) AND (%AttrAll - %AttrSchNum)) OR scheme ' Add in the scheme number
      END METHOD                                                  '

      METHOD AttrClear(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG, flag AS LONG) '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            POKE WORD, i, (PEEK(WORD, i) AND (%AttrAll - flag))   ' Remove the flag
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD AttrSet(lno AS LONG, fcolumn AS LONG, tcolumn AS LONG, flag AS LONG)   '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         j = LAttrSPtr(lno)                                       ' Get pointer to actual characters
         FOR i = j + ((fcolumn - 1) * 2) TO j + ((tcolumn - 1) * 2) STEP 2 ' Attr by Attr
            POKE WORD, i, (PEEK(WORD, i) OR flag)                 ' Add the flag
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD AFIsFileDir(i AS LONG) AS LONG                       '
         METHOD = ISTRUE (gFMD(i).Flag = %FDirDown OR gFMD(i).Flag = %FDirUp) '
      END METHOD                                                  '

      METHOD AFIsReadOnly(i AS LONG) AS LONG                      '
         METHOD = ISTRUE ((gFMD(i).FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY) '
      END METHOD                                                  '

      METHOD   LoadData()                                         '
      '--------------------------------------------------------------------------------------------+
      '- Load the Actual File list from the Request List                                           |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL tfn, lclPath, t, RQPath, RQMask, RQMode, RQDate, PropName AS STRING, FD AS DIRDATA   '
      LOCAL CurrTab, DummyCol AS LONG                             '
      LOCAL tSort() AS WSTRINGZ * 512                             '
      LOCAL DummyAttr AS WSTRING                                  '
         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- First get any User FLISTS for the Quick Line                                           |
         '-----------------------------------------------------------------------------------------+
         RESET gFMQFList1, gFMQFList2, gFMQFList3, gFMQFList4, gFMQFList5, gFMQFList6  '
         t =gENV.HomeData + "FILELIST\" + "_*.FLIST"
         RQPath = DIR$(gENV.HomeData + "FILELIST\" + "_*.FLIST")     ' See if any there
         DO WHILE ISNOTNULL(RQPath)                               ' While we're getting entries
            IF IsNE(RQPath, "Favorite Files.FLIST") AND _         ' Eliminate standard ones
               IsNE(RQPath, "Found Files.FLIST") AND _            '
               IsNE(RQPath, "Recent Files.FLIST") AND _           '
               IsNE(RQPath, "Recent Paths.FLIST") THEN            '
               IF ISNULL(gFMQFList1) THEN                         ' Save first 6
                  gFMQFList1 =  LEFT$(RQPath, INSTR(RQPath, ".") - 1)   '
                  gFM_Quick_Pos_11 = gFM_Quick_Pos_10 + LEN(gFMQFList1) + 2   ' 2 Past 1st User FLISTS
               ELSEIF ISNULL(gFMQFList2) THEN                     '
                  gFMQFList2 =  LEFT$(RQPath, INSTR(RQPath, ".") - 1)   '
                  gFM_Quick_Pos_12 = gFM_Quick_Pos_11 + LEN(gFMQFList2) + 2   ' 2 Past 2nd User FLISTS
               ELSEIF ISNULL(gFMQFList3) THEN                     '
                  gFMQFList3 =  LEFT$(RQPath, INSTR(RQPath, ".") - 1)   '
                  gFM_Quick_Pos_13 = gFM_Quick_Pos_12 + LEN(gFMQFList3) + 2   ' 2 Past 3rd User FLISTS
               ELSEIF ISNULL(gFMQFList4) THEN                     '
                  gFMQFList4 =  LEFT$(RQPath, INSTR(RQPath, ".") - 1)   '
                  gFM_Quick_Pos_14 = gFM_Quick_Pos_13 + LEN(gFMQFList4) + 2   ' 2 Past 4th User FLISTS
               ELSEIF ISNULL(gFMQFList5) THEN                     '
                  gFMQFList5 =  LEFT$(RQPath, INSTR(RQPath, ".") - 1)   '
                  gFM_Quick_Pos_15 = gFM_Quick_Pos_14 + LEN(gFMQFList5) + 2   ' 2 Past 5th User FLISTS
               ELSEIF ISNULL(gFMQFList6) THEN                     '
                  gFMQFList6 =  LEFT$(RQPath, INSTR(RQPath, ".") - 1)   '
               END IF                                             '
            END IF                                                '
            RQPath = DIR$(NEXT)                                   ' Get next FILELIST entry
         LOOP                                                     '

         RESET gFMDCtr, gFMNumDirs, gFMNumFiles, gFMNumLines, gFMTotSize, FMMarkdSLin  ' Reset stuff
         FOR i = 1 TO gFMDCtr                                     ' Free any prior allocated objects
            IF ISOBJECT(gFMD(i)) THEN LET gFMD(i) = NOTHING       '
         NEXT i                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Setup custom sorts and Layouts                                                         |
         '-----------------------------------------------------------------------------------------+
         gFMLayout = IIF$(gFMLayoutID = "S", gENV.FMLayout, gENV.FMLayoutM) ' Setup default layout

         SELECT CASE LONG FMode                                   ' Fetch the sort defaults
            CASE %FMFilePath:  gENV.GetFMCrit("FILEPATH", DirSort, DefSort, FMask, gFMLayoutID)  '
            CASE %FMFileTree:  gENV.GetFMCrit("FILETREE", DirSort, DefSort, FMask, gFMLayoutID)  '
            CASE %FMOpen:      gENV.GetFMCrit("OPEN", DirSort, DefSort, FMask, gFMLayoutID)   '
            CASE %FMFLISTS:    gENV.GetFMCrit("FLISTS", DirSort, DefSort, FMask, gFMLayoutID) '
            CASE %FMRecPaths:  gENV.GetFMCrit("PATHS", DirSort, DefSort, FMask, gFMLayoutID)  '
            CASE %FMConfigs:   gENV.GetFMCrit("CONFIGS", DirSort, DefSort, FMask, gFMLayoutID)   '
            CASE %FMFileList                                      ' A Filelist type
               SELECT CASE AS CONST$ FileListNm                   ' Which type
                  CASE "Recent Files":   gENV.GetFMCrit("RECENT", DirSort, DefSort, FMask, gFMLayoutID)   '
                  CASE "Found Files":    gENV.GetFMCrit("FOUND", DirSort, DefSort, FMask, gFMLayoutID) '
                  CASE "Favorite Files": gENV.GetFMCrit("FAVORITES", DirSort, DefSort, FMask, gFMLayoutID)   '
                  CASE ELSE                                       ' Any others (normal FLISTS)
                     IF LEFT$(FileListNM, 1) = "_" THEN           ' A special QuickList entry?
                        gENV.GetFMCrit(UCASE$(FileListNm), DirSort, DefSort, FMask, gFMLayoutID) ' Ask for it's private one
                     ELSE                                         '
                        gENV.GetFMCrit("FLISTDET", DirSort, DefSort, FMask, gFMLayoutID)   ' Default FLISTDET
                     END IF                                       '
               END SELECT                                         '
            CASE ELSE                                             '
               gENV.GetFMCrit("FILEPATH", DirSort, DefSort, FMask, gFMLayoutID)   ' Default FILEPATH
         END SELECT                                               '

         me.WindowTitle                                           '
         IF FMode = %FMFileTree THEN                              ' Full File Tree
            '--------------------------------------------------------------------------------------+
            '- Process the Single RQ List                                                          |
            '--------------------------------------------------------------------------------------+
            me.RQSplit(gFMRQList(1), RQPath, RQMask, RQMode, RQDate) ' Get request parameter operands
            me.LoadDataTree(RQPath, RQMask)                       ' Go process the Path

                                                                  '   (FMask = "*" OR ISTRUE me.TestMask(RQPath, FMask)) AND _  ' And the FMAsk

         ELSEIF FMode = %FMFilelist OR FMode = %FMFilePath THEN   ' One of the DIR list types?
            '--------------------------------------------------------------------------------------+
            '- Extract data from the file directories                                              |
            '--------------------------------------------------------------------------------------+
            FOR i = 1 TO gFMRQCount                               ' Loop through all gFMRQList items
               me.RQSplit(gFMRQList(i), RQPath, RQMask, RQMode, RQDate) ' Get request parameter operands

               IF RIGHT$(RQPath, 3) = "\\\" THEN                  ' A unique Path entry?
                  RQPath = CLIP$(RIGHT, RQPath, 2)                ' Remove extra \\
                  IF ISFALSE ISFOLDER(RQPath) THEN ITERATE FOR    ' Ignore if not a real folder
                  IF (FMask = "*" OR ISTRUE me.TestMask(RQPath, FMask)) THEN  ' And Mask it requested?
                     me.IncAFSize                                 ' Allocate a new entry
                     INCR gFMNumDirs                              ' Count as dirs
                     GOSUB BlankBasic                             ' Reset everything
                     gFMD(gFMDCtr).RQIX = gFMDCtr                 ' Save RQ Index
                     gFMD(gFMDCtr).FileName = RQPath              ' Build an entry
                     gFMD(gFMDCtr).DPath = RQPath                 ' Stuff in Path field as well
                     gFMD(gFMDCtr).Flag = %FPath                  ' Set RPath entry type
                     gFMD(gFMDCtr).OMode = RQMode                 ' Set Mode from FLIST
                     gFMD(gFMDCtr).LRTime = RQDate                ' Set Date from FLIST
                     gFMD(gFMDCtr).Exten = ""                     ' Null extension
                 END IF                                           '

               ELSEIF RIGHT$(RQPath, 2) = "\\" THEN               ' A FileTree type request
                  me.LoadDataTree(CLIP$(RIGHT TRIM$(RQPath), 1), RQMask)   ' Go process it


               ELSE                                               ' Else a non-tree style
                  IF RIGHT$(RQPath, 1) = "\" AND FileListNm = "" THEN   ' A PathName while doing a normal FilePath?
                     IF ISFALSE me.IsAFDup(RQPath + "..\") THEN   ' If not already there
                        me.IncAFSize                              ' Allocate a new entry
                        INCR gFMNumDirs                           ' Count as dirs
                        GOSUB BlankBasic                          ' Reset everything
                        gFMD(gFMDCtr).RQIX = gFMDCtr              ' Save RQ Index
                        gFMD(gFMDCtr).DPath = RQPath              ' Save Path name
                        lclPath = RQPath                          ' Save the path
                        j = INSTR(-2, RQPath, "\")                ' Find last \
                        IF j <> 0 THEN                            ' Got one
                           gFMD(gFMDCtr).DPath = LEFT$(RQPath, j) ' Cut off the last level
                        END IF                                    '
                        gFMD(gFMDCtr).FileName = "..\"            ' Stuff in ..\
                        gFMD(gFMDCtr).Flag = %FDirUp              ' Set DirUp entry type
                     END IF                                       '
                     RQPath += "*"                                ' Add * if a pathname
                  ELSE                                            '
                     lclPath = LEFT$(RQPath, INSTR(-1, RQPath, "\")) ' Extract path from the full name
                  END IF                                          '
                  RQPath = DIR$(RQPath, 22 TO FD)                 ' Look for the first entry
                  IF ISNULL(RQPath) THEN GOTO SkipMissing         ' If file missing, ignore it

                  '--------------------------------------------------------------------------------+
                  '- Loop through the returned entries                                             |
                  '--------------------------------------------------------------------------------+
                  DO WHILE ISNOTNULL(RQPath)                      ' While we're getting entries
                     IF (FD.FileAttributes AND %FILE_ATTRIBUTE_DIRECTORY) = %FILE_ATTRIBUTE_DIRECTORY THEN  '
                        IF ISFALSE me.IsAFDup(lclPath + TRIM$(FD.FileName) + "\") THEN ' If not already there
                           me.IncAFSize                           ' Allocate a new entry
                           INCR gFMNumDirs                        ' Count as dirs
                           GOSUB BlankBasic                       ' Reset everything
                           gFMD(gFMDCtr).RQIX = gFMDCtr           ' Save RQ Index
                           gFMD(gFMDCtr).FD = FD                  ' Copy the FD data into it
                           gFMD(gFMDCtr).FileName = TRIM$(gFMD(gFMDCtr).FileName) + "\"   'Add \ to indicate directory
                           gFMD(gFMDCtr).Flag = %FDirDown         ' Set DirDown entry type
                           gFMD(gFMDCtr).LWTime = TimePretty(FD.LastWriteTime)   ' Format LWTime
                           gFMD(gFMDCtr).CRTime = TimePretty(FD.CreationTime) ' Format CRTime
                           gFMD(gFMDCtr).LRTime = ""              ' Format LRTime
                           gFMD(gFMDCtr).DPath = lclPath          ' Add the path
                        END IF                                    '

                     ELSE                                         ' It's a File Entry
                        IF ISTRUE me.TestMask(TRIM$(FD.FileName), RQMask) AND _  ' If we pass the basic Mask test
                           ISFALSE me.TestExclude(TRIM$(lclPath) + TRIM$(FD.FileName)) AND _ ' And the Exclude test
                           (FMask = "*" OR ISTRUE me.TestMask(TRIM$(FD.FileName), FMask)) THEN  ' And second level Mask it requested?

                           IF ISFALSE me.IsAFDup(lclPath + TRIM$(FD.FileName)) THEN ' If not already there
                              me.IncAFSize                        ' Allocate a new entry
                              INCR gFMNumFiles                    ' Count as a fle
                              GOSUB BlankBasic                    ' Reset everything
                              gFMD(gFMDCtr).RQIX = gFMDCtr        ' Save RQ Index
                              gFMD(gFMDCtr).DPath = lclPath       ' Add the path
                              gFMD(gFMDCtr).FD = FD               ' Copy the FD data into it
                              gFMD(gFMDCtr).Flag = IIF(FMode = %FMFilePath, %FEntry, %FFLEntry) ' Set the file entry type
                              gFMD(gFMDCtr).LWTime = TimePretty(FD.LastWriteTime)   ' Format LWTime
                              gFMD(gFMDCtr).CRTime = TimePretty(FD.CreationTime) ' Format CRTime
                              gFMD(gFMDCtr).LRTime = ""           ' Format LRTime
                              gFMD(gFMDCtr).Exten = UUCASE(MID$(TRIM$(FD.FileName), INSTR(-1,TRIM$(FD.FileName), "."))) ' Extract extension
                              gFMD(gFMDCtr).OMode = RQMode        ' Set Mode from FLIST
                              IF LEFT$(FileListNm, 7) = "Recent " THEN gFMD(gFMDCtr).LRTime = RQDate  ' Set Date from FLIST if doing a Recent
                              gFMD(gFMDCtr).LinesInt = GetStateLines(lclPath + TRIM$(FD.FileName)) ' Get Line count from STATE
                              gFMD(gFMDCtr).SizeInt = MAK(QUAD, FD.FileSizeLow, FD.FileSizeHigh)   '
                              gFMNumLines += IIF(gFMD(gFMDCtr).LinesInt < 0, 0, gFMD(gFMDCtr).LinesInt)  '
                              gFMTotSize += gFMD(gFMDCtr).SizeInt '
                              IF INSTR(gFMD(gFMDCtr).Exten, "\") THEN gFMD(gFMDCtr).Exten = ""  '
                           END IF                                 '
                        END IF                                    '
                     END IF                                       '
                     RQPath = DIR$(NEXT, TO FD)                   ' Get next FILELIST entry
                  LOOP                                            '

               END IF                                             '
               SkipMissing:                                       '
            NEXT i                                                ' FM.gFMRQCount                                '

         ELSEIF FMode = %FMRecPaths THEN                          ' Recent paths?
            '--------------------------------------------------------------------------------------+
            '- Extract data from the file directories                                              |
            '--------------------------------------------------------------------------------------+
            FOR i = 1 TO gFMRQCount                               ' Loop through all gFMRQList items
               me.RQSplit(gFMRQList(i), RQPath, RQMask, RQMode, RQDate) ' Get request parameter operands

               '-----------------------------------------------------------------------------------+
               '- Make sure a path format                                                          |
               '-----------------------------------------------------------------------------------+
               IF RIGHT$(RQPath, 1) <> "\" THEN ITERATE FOR       ' If no trailing \ ignore it

               IF ISFALSE ISFOLDER(RQPath) THEN ITERATE FOR       ' Ignore if not a real folder
               IF (FMask = "*" OR ISTRUE me.TestMask(RQPath, FMask)) THEN  ' And Mask it requested?
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumDirs                                 ' Count as dirs
                  GOSUB BlankBasic                                ' Reset everything
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).FileName = RQPath                 ' Build an entry
                  gFMD(gFMDCtr).DPath = RQPath                    ' Stuff in Path field as well
                  gFMD(gFMDCtr).Flag = %FPath                     ' Set RPath entry type
                  gFMD(gFMDCtr).OMode = RQMode                    ' Set Mode from FLIST
                  gFMD(gFMDCtr).LRTime = RQDate                   ' Set Date from FLIST
                  gFMD(gFMDCtr).Exten = UUCASE(MID$(TRIM$(gFMD(gFMDCtr).FileName), INSTR(-1,TRIM$(gFMD(gFMDCtr).FileName), ".")))   ' Extract extension
                  IF INSTR(gFMD(gFMDCtr).Exten, "\") THEN gFMD(gFMDCtr).Exten = ""  '
              END IF                                              '
            NEXT i                                                ' FM.gFMRQCount                                '

         ELSEIF FMode = %FMFLISTS THEN                            ' FLISTS?

            '--------------------------------------------------------------------------------------+
            '- Extract data from the file directories                                              |
            '--------------------------------------------------------------------------------------+
            tfn = DIR$(gENV.HomeData + "FILELIST\" + "*.FLIST" TO FD)' Look for other FILELIST files
            DO WHILE ISNOTNULL(tfn)                               ' While we're getting entries
               IF (FD.FileAttributes AND %FILE_ATTRIBUTE_DIRECTORY) <> %FILE_ATTRIBUTE_DIRECTORY THEN '
                  IF me.TestExclude(TRIM$(lclPath) + TRIM$(FD.FileName)) THEN GOTO NextFList ' And the Exclude test
                  IF (FMask = "*" OR ISTRUE me.TestMask(TRIM$(FD.FileName), FMask)) THEN  ' And Mask it requested?
                     me.IncAFSize                                 ' Allocate a new entry
                     INCR gFMNumFiles                             ' Count as dirs
                     GOSUB BlankBasic                             ' Reset everything
                     gFMD(gFMDCtr).RQIX = gFMDCtr                 ' Save RQ Index
                     gFMD(gFMDCtr).FD = FD                        ' Copy the FD data into it
                     gFMD(gFMDCtr).Flag = %FFileList              ' Set as FILELIST entry type
                     gFMD(gFMDCtr).LWTime = TimePretty(FD.LastWriteTime)   ' Format LWTime
                     gFMD(gFMDCtr).CRTime = TimePretty(FD.CreationTime) ' Format CRTime
                     gFMD(gFMDCtr).LRTime = ""                    ' Format LRTime
                     gFMD(gFMDCtr).DPath = gENV.HomeData + "FILELIST\" ' Add the path
                     gFMD(gFMDCtr).Exten = UUCASE(MID$(TRIM$(gFMD(gFMDCtr).FileName), INSTR(-1,TRIM$(gFMD(gFMDCtr).FileName), ".")))   ' Extract extension
                     gFMD(gFMDCtr).SizeInt = MAK(QUAD, FD.FileSizeLow, FD.FileSizeHigh)   '
                     IF INSTR(gFMD(gFMDCtr).Exten, "\") THEN gFMD(gFMDCtr).Exten = ""  '
                  END IF                                          '
               END IF                                             '
               NextFList:                                         '
               tfn = DIR$(NEXT, TO FD)                            ' Get next entry
            LOOP                                                  '

         ELSEIF FMode = %FMConfigs THEN                           ' Configs?

            '--------------------------------------------------------------------------------------+
            '- Extract data from the CFG file                                                      |
            '--------------------------------------------------------------------------------------+
            gSQL.SelBegin("select name FROM sqlite_master WHERE type ='table' AND name like 'P%'") '
            IF gSQL.SelFirst() THEN                               ' Select the first
               i = gFMDCtr + 1                                    ' Save 1st entry
               DO                                                 ' Loop through them
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as dirs
                  GOSUB BlankBasic                                ' Reset everything
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).Flag = %FConfig                   ' Set as Config entry type
                  gFMD(gFMDCtr).FileName = "Profile:  " + MID$(gSQL.SelGet("Name"), 2) ' Collect the name
               LOOP WHILE gSQL.SelNext()                          '
            END IF                                                '
            gSQL.SelEnd                                           ' Close the SQL request

            gSQL.SelBegin("select name FROM sqlite_master WHERE type ='table' AND name like 'O%'") '
            IF gSQL.SelFirst() THEN                               ' Select the first
               DO                                                 ' Loop through them
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as dirs
                  GOSUB BlankBasic                                ' Reset everything
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).Flag = %FConfig                   ' Set as Config entry type
                  gFMD(gFMDCtr).FileName = "Instance: " + MID$(gSQL.SelGet("Name"), 2) ' Collect the name
               LOOP WHILE gSQL.SelNext()                          '
            END IF                                                '
            gSQL.SelEnd                                           ' Close the SQL request
            FOR i = i TO gFMDCtr                                  ' Loop through now to pick up timestamp
               IF LEFT$(gFMD(i).FileName, 10) = "Profile:  " THEN '
                  gFMD(i).LWTime = gSQL.GetStringDirect("P" + MID$(gFMD(i).FileName, 11), "LastAccess", "") '
               ELSE                                               ' Must be instance
                  gFMD(i).LWTime = gSQL.GetStringDirect("O" + MID$(gFMD(i).FileName, 11), "LastAccess", "") '
               END IF                                             '
            NEXT i                                                '

         ELSEIF FMode = %FMOpen THEN                              ' OPEN files?

            '--------------------------------------------------------------------------------------+
            '- Fetch Open Files                                                                    |
            '--------------------------------------------------------------------------------------+
            FOR i = 1 TO UBOUND(gFQ())                            ' Process the File Queue
               IF gFQ(i).gInUse = %False THEN ITERATE FOR         ' Skip if it no longer in use
               me.IncAFSize                                       ' Allocate a new entry
               INCR gFMNumFiles                                   ' Count as a file
               GOSUB BlankBasic                                   ' Reset everything
               gFMD(gFMDCtr).RQIX = gFMDCtr                       ' Save RQ Index
               gFMD(gFMDCtr).Uniq = gFQ(i).gPgNumber              ' Uniq to hide the tab number
               gFMD(gFMDCtr).DPath = gFQ(i).gWatchDir + "\"       '
               gFMD(gFMDCtr).FileName = MID$(gFQ(i).gWatchFile, INSTR(-1, gFQ(i).gWatchFile, "\") + 1)   '
               gFMD(gFMDCtr).Flag = %FOpen                        ' Set open file entry type
               gFMD(gFMDCtr).Exten = UUCASE(MID$(TRIM$(gFMD(gFMDCtr).FileName), INSTR(-1,TRIM$(gFMD(gFMDCtr).FileName), ".")))   ' Extract extension
               IF INSTR(gFMD(gFMDCtr).Exten, "\") THEN gFMD(gFMDCtr).Exten = ""  '
            NEXT i                                                '

            '--------------------------------------------------------------------------------------+
            '- Now pick up the Special tabs                                                        |
            '--------------------------------------------------------------------------------------+
            CurrTab = PgNumber                                    ' Save current tab number
            FOR i = gTabsNum TO 1 STEP - 1                        ' Now look for Special Tabs
               TP = gTabs(i)                                      ' Pick the Tab
               IF IsClip THEN                                     ' Look for specials
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as a file
                  GOSUB FillSpecial                               ' Complete special entry
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).FileName = "(Clip)"               '
                  IF TP.ClipName <> "" THEN                       ' Fiddle DIFF use of the clipboard
                     IF LEFT$(TP.ClipName, 6) = "_DIFF." THEN     ' Is this DIFF?
                        gFMD(gFMDCtr).FileName = MID$(TP.ClipName, 2)   ' Just use the DIFFname
                     END IF                                       '
                  END IF                                          '

               ELSEIF IsSetEdit THEN                              '
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as a file
                  GOSUB FillSpecial                               ' Complete special entry
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).FileName = "(SET Edit)"           '
               ELSEIF IsEFTEdit THEN                              '
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as a file
                  GOSUB FillSpecial                               ' Complete special entry
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).FileName = "(EFT Edit)"           '
               ELSEIF ISNULL(TP.FCB_.FilePath) AND ISFALSE IsFMTab THEN '
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as a file
                  GOSUB FillSpecial                               ' Complete special entry
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).FileName = $New                   '
               ELSEIF LEFT$(TP.FCB_.File, 1) = "*" THEN           ' CLONEd tab?
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as a file
                  GOSUB FillSpecial                               ' Complete special entry
                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).FileName = TP.FCB_.FilePath       '
               END IF                                             '
            NEXT i                                                '
            TP = gTabs(CurrTab)                                   ' Restore current tab
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Add total line                                                                         |
         '-----------------------------------------------------------------------------------------+
         me.IncAFSize                                             ' Allocate a new entry
         GOSUB BlankBasic                                         '
         gFMD(gFMDCtr).Flag = %FTotal                             ' Set as Total Line
         t = "-- End of List"                                     ' Build a last line marker
         IF gFMNumDirs <> 0 THEN                                  '
            t +=  ", " + FORMAT$(gFMNumDirs) + IIF$(gFMNumDirs = 1, " Dir", " Dirs")   '
         END IF                                                   '
         IF gFMNumFiles <> 0 THEN                                 ' Adding Files?
            t += ", " + FORMAT$(gFMNumFiles) + IIF$(gFMNumFiles = 1, " File", " Files")   '
            IF (FileListNm = "Recent Files" OR FileListNm = "Recent Paths") AND gFMNumFiles = gENV.RecentCtr THEN ' Warn of RECENT list full
               t += " (Max)"                                      '
            END IF                                                '
         END IF                                                   '
         IF gFMNumLines <> 0 THEN                                 ' Add Lines
            t +=  ", " + FORMAT$(gFMNumLines, "#,") + IIF$(gFMNumLines = 1, " Line", " Lines")  '
         END IF                                                   '
         IF gFMTotSize <> 0 THEN                                  ' Add Total Size
            t +=  ", " + FORMAT$(gFMTotSize, "#,") + " Bytes"     '
         END IF                                                   '
         IF gFMRXCount <> 0 THEN                                  ' Adding Excluded?
            t += ", " + FORMAT$(gFMRXCount) + " Excluded"         '
         END IF                                                   '
         t += " --"                                               '
         gFMD(gFMDCtr).FileName = t                               ' Save in FileName

         '-----------------------------------------------------------------------------------------+
         '- Get the previous Layout choice and process it                                          |
         '-----------------------------------------------------------------------------------------+
         gFMLayout = IIF$(gFMLayoutID = "S", gENV.FMLayout, gENV.FMLayoutM)                                     ' No forced Layout Mode?
         InitFMLayout                                             ' Do the Setup
         DoStatusBar($AllStatusBarBoxes)                          ' re-Do the StatusBar

         '-----------------------------------------------------------------------------------------+
         '- Now Add Property Values (if needed, by the selected Layout)                            |
         '-----------------------------------------------------------------------------------------+
         IF gFMPropAct THEN                                       ' If we have active Property columns
            FOR i = 1 TO gFMDCtr                                  ' Loop through them
               IF gFMD(i).Flag = %FFileList OR _                  ' If a real file entry
                  gFMD(i).Flag = %FEntry OR _                     '
                  gFMD(i).Flag = %FFLEntry THEN                   '
                  PropName = gFMC(1).GetPropName("PRP1")          ' See if PRP1 active
                  IF PropName <> "" THEN gFMD(i).PRP1 = GetProperty(TRIM$(gFMD(i).DPath) + TRIM$(gFMD(i).FileName), PropName) '
                  PropName = gFMC(1).GetPropName("PRP2")          ' See if PRP2 active
                  IF PropName <> "" THEN gFMD(i).PRP2 = GetProperty(TRIM$(gFMD(i).DPath) + TRIM$(gFMD(i).FileName), PropName) '
                  PropName = gFMC(1).GetPropName("PRP3")          ' See if PRP3 active
                  IF PropName <> "" THEN gFMD(i).PRP3 = GetProperty(TRIM$(gFMD(i).DPath) + TRIM$(gFMD(i).FileName), PropName) '
                  PropName = gFMC(1).GetPropName("PRP4")          ' See if PRP4 active
                  IF PropName <> "" THEN gFMD(i).PRP4 = GetProperty(TRIM$(gFMD(i).DPath) + TRIM$(gFMD(i).FileName), PropName) '
                  PropName = gFMC(1).GetPropName("PRP5")          ' See if PRP5 active
                  IF PropName <> "" THEN gFMD(i).PRP5 = GetProperty(TRIM$(gFMD(i).DPath) + TRIM$(gFMD(i).FileName), PropName) '
                  PropName = gFMC(1).GetPropName("PRP6")          ' See if PRP6 active
                  IF PropName <> "" THEN gFMD(i).PRP6 = GetProperty(TRIM$(gFMD(i).DPath) + TRIM$(gFMD(i).FileName), PropName) '
               END IF                                             '
            NEXT i                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Now Sort it they way the user wants                                                    |
         '-----------------------------------------------------------------------------------------+
         REDIM tSort(1 TO gFMDCtr) AS WSTRINGZ * 512              ' Get a working array

         SELECT CASE AS CONST$ TP.DefSort                         ' See how to sort it
            CASE "Name+"                                          ' Name Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF TP.FileListNm = "" THEN                      ' If not a FileList
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).FullPath '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).FileName '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Name-"                                          ' Name Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF TP.FileListNm = "" THEN                      ' If not a FileList
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).FullPath '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).FileName '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "Name."                                          ' Ext/Name Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF TP.FileListNm = "" THEN                      ' If not a FileList
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).Exten + gFMD(i).FullPath   '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).Exten + gFMD(i).FileName   '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Name*"                                          ' Physical Seq
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).PSeq)                '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Path+"                                          ' Path Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).DPath + " " + gFMD(i).FileName   '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Path-"                                          ' Path Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + " " + gFMD(i).DPath + " " + t   '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "LWDate+"                                        ' LWDate Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).LWTime + gFMD(i).FileName  '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "LWDate-"                                        ' LWDate Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).LWTime + t  ' Add inverted Filename to get Normal SortUp
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "LRDate+"                                        ' LRDate Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).LRTime, 17) + gFMD(i).FileName   '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "LRDate-"                                        ' LRDate Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).LRTime, 17) + t   ' Add inverted Filename to get Normal SortUp
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "CRDate+"                                        ' CRDate Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).CRTime + gFMD(i).FileName  '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "CRDate-"                                        ' CRDate Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).CRTime + t  ' Add inverted Filename to get Normal SortUp
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "Size+"                                          ' Size Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + FORMAT$(gFMD(i).SizeInt, "00000000") + gFMD(i).FileName '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Size-"                                          ' Size Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + FORMAT$(gFMD(i).SizeInt, "00000000") + t ' Add inverted Filename to get Normal SortUp
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "Lines+"                                         ' Lines Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + FORMAT$(gFMD(i).LinesInt, "00000000") + gFMD(i).FileName   '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Lines-"                                         ' Lines Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + FORMAT$(gFMD(i).LinesInt, "00000000") + t   ' Add inverted Filename to get Normal SortUp
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "Attr+"                                          ' Attr Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).PrtField("ATTR", DummyAttr, DummyCol), 8) + gFMD(i).FileName   '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Attr-"                                          ' Attr Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).PrtField("ATTR", DummyAttr, DummyCol), 8) + t   ' Add inverted Filename to get Normal SortUp
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "Mode+"                                          ' Mode Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).OMode + gFMD(i).FileName   '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "Mode-"                                          ' Mode Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + gFMD(i).OMode + t   ' Add inverted Filename to get Normal SortUp
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "PRP1+"                                          ' PRP1 Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp1, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp1, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "PRP1-"                                          ' PRP1 Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp1, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp1, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "PRP2+"                                          ' PRP2 Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp2, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp2, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "PRP2-"                                          ' PRP2 Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp2, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp2, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "PRP3+"                                          ' PRP3 Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp3, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp3, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "PRP3-"                                          ' PRP3 Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp3, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp3, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "PRP4+"                                          ' PRP4 Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp4, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp4, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "PRP4-"                                          ' PRP4 Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp4, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp4, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "PRP5+"                                          ' PRP5 Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp5, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp5, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "PRP5-"                                          ' PRP5 Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp5, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp5, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

            CASE "PRP6+"                                          ' PRP6 Ascending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp6, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp6, gFMC(TP.DefSortCol).CSize) + gFMD(i).FileName   '
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortUp                                     ' Go do the sort

            CASE "PRP6-"                                          ' PRP6 Descending
               FOR i = 1 TO gFMDCtr                               ' Build the key array
                  t = gFMD(i).FileName: t = StrInvert(t)          ' Get FileName and Invert it
                  IF gFMC(TP.DefSortCol).CAlign = "L" THEN        ' Left aligned?
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + LSET$(gFMD(i).Prp6, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  ELSE                                            '
                     tSort(i) = FORMAT$(gFMD(i).Flag, "0000") + RSET$(gFMD(i).Prp6, gFMC(TP.DefSortCol).CSize) + t   ' Add inverted Filename to get Normal SortUp
                  END IF                                          '
               NEXT i                                             '
               GOSUB DoSortDown                                   ' Go do the sort

         END SELECT                                               '

         DoClear(%LoadData)                                       ' Say we've done it
         DoSet(%Refresh)                                          ' New data always means a Refresh

         @P.PTopLine = IIF(gFMNestTopScrn > 0, gFMNestTopScrn, @P.PTopLine)   ' Set top to whatever Nest Pop wants
         me.CsrRow = @P.PTop: me.CsrCol = @P.PCmdCol: @P.PCOffset = 0   ' Reset things
         RESET gFMNestTopScrn                                     '
         MExitMeth                                                '

         FillSpecial:                                             '
            GOSUB BlankBasic                                      ' Reset everything
            gFMD(gFMDCtr).Uniq = i                                ' Uniq to hide the tab number
            gFMD(gFMDCtr).Flag = %FOpen                           ' Set Open file entry type
         RETURN                                                   '

         BlankBasic:                                              '
            gFMD(gFMDCtr).FileSizeLow = 0                         ' Clear fields
            gFMD(gFMDCtr).FileSizeHigh = 0                        '
            gFMD(gFMDCtr).SizeInt = 0                             '
            gFMD(gFMDCtr).Flag = 0                                '
            gFMD(gFMDCtr).CmdOff = 0                              '
            gFMD(gFMDCtr).Uniq = 0                                '
            gFMD(gFMDCtr).Exten = ""                              '
            gFMD(gFMDCtr).Message = ""                            '
            gFMD(gFMDCtr).LWTime = ""                             '
            gFMD(gFMDCtr).CRTime = ""                             '
            gFMD(gFMDCtr).DPath = ""                              '
            gFMD(gFMDCtr).OMode = ""                              '
            gFMD(gFMDCtr).Cmd = " "                               '
            gFMD(gFMDCtr).RQIX = 0                                '
            gFMD(gFMDCtr).LinesInt = -1                           '
            gFMD(gFMDCtr).Prp1 = ""                               '
            gFMD(gFMDCtr).Prp2 = ""                               '
            gFMD(gFMDCtr).Prp3 = ""                               '
            gFMD(gFMDCtr).Prp4 = ""                               '
            gFMD(gFMDCtr).Prp5 = ""                               '
            gFMD(gFMDCtr).Prp6 = ""                               '
         RETURN                                                   '

         DoSortDown:                                              '
            DIM ArrDWord(1 TO gFMDCtr) AS LOCAL DWORD AT VARPTR(gFMD(1))   ' Overlay s DWORD over the Obj pointers
            ARRAY SORT tSort() FOR gFMDCtr - 1, TAGARRAY ArrDWord(), CALL FMSortDown   '
            ERASE tSort()                                         ' Free the temp array
            FOR i = 1 TO gFMDCtr: gFMD(i).Sorted = i: NEXT i      '
         RETURN                                                   '

         DoSortUp:                                                '
            DIM ArrDWord(1 TO gFMDCtr) AS LOCAL DWORD AT VARPTR(gFMD(1))   ' Overlay s DWORD over the Obj pointers
            ARRAY SORT tSort() FOR gFMDCtr - 1, TAGARRAY ArrDWord(), CALL FMSortUp  '
            ERASE tSort()                                         ' Free the temp array
            FOR i = 1 TO gFMDCtr: gFMD(i).Sorted = i: NEXT i      '
         RETURN                                                   '

      END METHOD                                                  '

      METHOD LoadDataTree(rPath AS STRING, rMask AS STRING)       '
         LOCAL FD AS WIN32_FIND_DATA                              '
         LOCAL hFirst, hNext AS LONG                              '
         LOCAL FT AS both, t AS STRING                            '

         '-----------------------------------------------------------------------------------------+
         '- What are we searching for                                                              |
         '-----------------------------------------------------------------------------------------+
         hFirst = FindFirstFile(rPath + "*.*", FD)                ' Ask for all files
         IF hFirst = %INVALID_HANDLE_VALUE THEN EXIT METHOD       ' Nothing, just exit

         DO                                                       '
            '--------------------------------------------------------------------------------------+
            '- If it is a directory, recurse into it                                               |
            '--------------------------------------------------------------------------------------+
            IF (FD.dwFileAttributes AND %FILE_ATTRIBUTE_DIRECTORY) = %FILE_ATTRIBUTE_DIRECTORY THEN   '
               IF (TRIM$(FD.cFileName) <> ".") AND (TRIM$(FD.cFileName) <> "..") THEN  ' If not UP/DOWN folders
                  me.LoadDataTree(rPath + FD.cFileName + "\", rMask) '
               END IF                                             '
            ELSE                                                  '
               IF ISTRUE me.TestMask(TRIM$(FD.cFileName), rMask) AND _  ' If we pass the Mask test
                  (FMask = "*" OR ISTRUE me.TestMask(TRIM$(FD.cFileName), FMask)) AND _   ' And the FMAsk
                  ISFALSE me.TestExclude(TRIM$(rPath) + TRIM$(FD.cFileName)) THEN   ' And the Exclude test
                  me.IncAFSize                                    ' Allocate a new entry
                  INCR gFMNumFiles                                ' Count as a file
                  gFMD(gFMDCtr).FileSizeLow = 0                   ' Clear fields
                  gFMD(gFMDCtr).FileSizeHigh = 0                  '
                  gFMD(gFMDCtr).CmdOff = 0                        '
                  gFMD(gFMDCtr).Uniq = 0                          '
                  gFMD(gFMDCtr).Message = ""                      '
                  gFMD(gFMDCtr).OMode = ""                        '
                  gFMD(gFMDCtr).Cmd = " "                         '
                  gFMD(gFMDCtr).Prp1 = ""                         '
                  gFMD(gFMDCtr).Prp2 = ""                         '
                  gFMD(gFMDCtr).Prp3 = ""                         '
                  gFMD(gFMDCtr).Prp4 = ""                         '
                  gFMD(gFMDCtr).Prp5 = ""                         '
                  gFMD(gFMDCtr).Prp6 = ""                         '

                  gFMD(gFMDCtr).RQIX = gFMDCtr                    ' Save RQ Index
                  gFMD(gFMDCtr).DPath = rPath                     ' Add the path
                  gFMD(gFMDCtr).FileAttributes      = FD.dwFileAttributes  ' Copy WIN32_FIND_DATA to DirData
                  ft.lft = FD.ftCreationTime                      '
                  gFMD(gFMDCtr).CreationTime        = ft.lq       '
                  ft.lft = FD.ftLastAccessTime                    '
                  gFMD(gFMDCtr).LastAccessTime      = ft.lq       '
                  ft.lft = FD.ftLastWriteTime                     '
                  gFMD(gFMDCtr).LastWriteTime       = ft.lq       '
                  gFMD(gFMDCtr).FileSizeHigh        = FD.nFileSizeHigh  '
                  gFMD(gFMDCtr).FileSizeLow         = FD.nFileSizeLow   '
                  gFMD(gFMDCtr).FileName            = FD.cFileName   '
                  gFMD(gFMDCtr).ShortName           = FD.cAlternateFileName   '

                  gFMD(gFMDCtr).Flag = IIF(FMode = %FMFilePath, %FEntry, %FFLEntry) ' Set the file entry type
                  gFMD(gFMDCtr).LWTime = TimePretty(gFMD(gFMDCtr).LastWriteTime) ' Format LWTime
                  gFMD(gFMDCtr).CRTime = TimePretty(gFMD(gFMDCtr).CreationTime)  ' Format CRTime
                  gFMD(gFMDCtr).Exten = UUCASE(MID$(TRIM$(FD.cFileName), INSTR(-1,TRIM$(FD.cFileName), ".")))  ' Extract extension
                  gFMD(gFMDCtr).LinesInt = GetStateLines(rPath + TRIM$(FD.cFileName))  ' Get Line count from STATE
                  gFMD(gFMDCtr).SizeInt = MAK(QUAD, FD.nFileSizeLow, FD.nFileSizeHigh) '
                  gFMNumLines += IIF(gFMD(gFMDCtr).LinesInt < 0, 0, gFMD(gFMDCtr).LinesInt)  '
                  gFMTotSize += gFMD(gFMDCtr).SizeInt             '
                  IF INSTR(gFMD(gFMDCtr).Exten, "\") THEN gFMD(gFMDCtr).Exten = ""  '
                  t = gFMD(gFMDCtr).FullPath                      '

               END IF                                             ' End Mask OK
            END IF                                                ' End Dir/File
            hNext = FindNextFile(hFirst, FD)                      '
            IF hNext = 0 THEN EXIT DO                             '
         LOOP                                                     '

         '-----------------------------------------------------------------------------------------+
         '- Close the search                                                                       |
         '-----------------------------------------------------------------------------------------+
         FindClose hFirst                                         '
      END METHOD                                                  '

      METHOD   LoadErrsAdd(str AS STRING)                         '
      '--------------------------------------------------------------------------------------------+
      '- Add to the LoadErrs table                                                                 |
      '--------------------------------------------------------------------------------------------+
         INCR LoadErrsCtr                                         ' Save the entry
         IF LoadErrsCtr > UBOUND(LoadErrs()) THEN _               ' Keep table big enough
            REDIM PRESERVE LoadErrs(1 TO 2 * LoadErrsCtr) AS INSTANCE STRING  '
         LoadErrs(LoadErrsCtr) = str                              '
      END METHOD                                                  '

      METHOD   LoadErrsDump()                                     '
      '--------------------------------------------------------------------------------------------+
      '- Insert LoadErrs as WNote entries                                                          |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         IF LoadErrsCtr > 0 AND ISFALSE IsMEdit THEN              ' Possible
            j = @P.PTopLine                                       ' Get Topscrn
            FOR i = 1 TO LoadErrsCtr                              ' Collect errors
               me.LInsertLines(j, 1, %Note)                       ' Insert a NOTE line
               INCR j                                             ' Point at it
               me.LTxtSet(j, LoadErrs(i))                         ' Insert it
               LWrk2S(j) = 23                                     ' Make it a WNote
               me.UpdLControl(j)                                  ' Setup LLCtl
            NEXT i                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD   LoadFileList(flist AS STRING) AS LONG              '
      '--------------------------------------------------------------------------------------------+
      '- Load the Actual File list from the Request List                                           |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL table(), t, fn, MyDLM, RQPath, RQMask, RQMode, RQDate AS STRING   '
      LOCAL TableCount, FNum AS LONG                              '
         MEntry                                                   '
         GOSUB LoadData                                           ' Load raw FILELIST data
         IF TableCount = 0 THEN _                                 ' If empty, we had an error
            TP.ErrMsgAdd(%eFail, "FILELIST (" + flist + ") was empty"): METHOD = %True: MexitMeth  ' Issue msg, just exit

         '-----------------------------------------------------------------------------------------+
         '- Now process what's left in the table                                                   |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO TableCount                                  ' Each line of the FILELIST file
            IF LEFT$(Table(i), 10) = "FileSrch: " THEN            ' The magic word?
               FFSearch = MID$(Table(i), 11)                      ' Save the FF command
            ELSE                                                  '
               me.RQSplit(Table(i), RQPath, RQMask, RQMode, RQDate)  ' Get request parameter operands
               StrUnQuote(RQPath)                                 ' Clear quotes if any present
               me.IncRQSize                                       ' Allocate an RQ slot
               IF ISNULL(RQMask) THEN                             ' If no RQMask, use *
                  gFMRQList(gFMRQCount) = BUILD$(RQPath, "|*|", RQMode, "|", RQDate)   ' Create an entry with * as a mask
               ELSE                                               '
                  gFMRQList(gFMRQCount) = BUILD$(RQPath, "|", RQMask, "|", RQMode, "|", RQDate) ' Create an entry
               END IF                                             '
            END IF                                                '

         NEXT i                                                   ' TableCount                                      '

         METHOD = %False                                          ' Say we were successful
         MExitMeth                                                '

         LoadData:                                                '
            IF flist = "ClipBoard" THEN                           ' Is this a ClipBoard request?
               gKeyPrimOper = "": MyDLM = $CRLF                   ' Set clipboardname / delimiter
               ClipboardRead(t, MyDLM, %False)                    ' Go get whatever's there

               IF LEN(t) < 1 THEN                                 ' If nothing there
                  TableCount = 0                                  ' Return zero
                  RETURN                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Deblock the clipboard and insert the lines                                       |
               '-----------------------------------------------------------------------------------+
               TableCount = PARSECOUNT(t, $CRLF)                  ' Get how many lines there are
               REDIM table(1 TO TableCount) AS STRING             ' Redim array to match save data
               PARSE t, table(), $CRLF                            ' Break it into lines
               RETURN                                             ' We're done
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Do a normal FLIST read                                                              |
            '--------------------------------------------------------------------------------------+
            IF flist = "Recent Files" AND gENV.eINSTANCE <> "DEFAULT" THEN ' An INSTANCE Recent Files?
               fn = gENV.HomeData + "FILELIST\" + flist + "." + gENV.eINSTANCE + ".FLIST"  ' Build name
            ELSE                                                  ' Else
               fn = gENV.HomeData + "FILELIST\" + flist + ".FLIST"   ' Build it the old way
            END IF                                                '

            FNum = FREEFILE                                       ' Get a file number
            Call3(TryOpenInput(fn, FNum), _                       ' Try the open
                  MErrExit(%eFail, "FILELIST: " + fn + " doesn't exist"), _   ' Oops?  Bail out
                  MErrExit(%eFail, "OPEN of FILELIST: " + fn + " failed"), _  '
                  Nul)                                            ' Continue
            TableCount = 0                                        ' Say no records
            FILESCAN # FNum, RECORDS TO i                         ' Get the number of records
            IF i > 0 THEN                                         ' Some records?
               REDIM table(1 TO i) AS STRING                      ' Redim array to match save data
               LINE INPUT # FNum, table() TO j                    ' Read it all
            END IF                                                '
            CLOSE # FNum                                          ' Close the FBO
            TableCount = j                                        ' Pass back record count
         RETURN                                                   '

      END METHOD                                                  '

      METHOD   LoadReq(sPath AS STRING, mask AS STRING, flist AS STRING)   '
      '--------------------------------------------------------------------------------------------+
      '- Load the Request list                                                                     |
      '--------------------------------------------------------------------------------------------+
      LOCAL SaveMask, tDirSort, tDefSort, tFMask AS STRING        '
         MEntry                                                   '
         SaveMask = FMask                                         ' Save FMASK, it gets clobbered by the following
         RESET gFMRQCount, gFMRXCount                             '
         REDIM gFMRQList(1 TO 100) AS GLOBAL STRING               '
         REDIM gFMRXList(1 TO 100) AS GLOBAL STRING               '
         RESET FFSearch                                           '
         DoSet(%LoadData)                                         ' LoadReq always requires LoadData
         SELECT CASE AS CONST$ TRIM$(flist)                       ' Set our initial mode
            CASE ""                                               ' No FileListNm
               gENV.GetFMCrit("FILEPATH", tDirSort, tDefSort, tFMask, gFMLayoutID)   ' Get the FMDefCrit mask value
               IF RIGHT$(TRIM$(sPath), 2) = "\\" THEN             ' Double \\ ?
                  FMode = %FMFileTree                             ' Make this Tree mode
                  gFMRQList(1) = CLIP$(RIGHT TRIM$(sPath), 1) + "|" + TRIM$(tFMask) + "|" ' Create a '1 line' FILELIST
               ELSE                                               ' Make it FilePath mode
                  FMode = %FMFilePath                             ' FilePath/Mask mode
                  gFMRQList(1) = TRIM$(sPath) + "|" + TRIM$(tFMask) + "|"  ' Create a '1 line' FILELIST
               END IF                                             '
               gFMRQCount = 1                                     '
            CASE "Recent Paths"                                   '
               FMode = %FMRecPaths                                ' Recent Paths
               me.LoadFileList(flist)                             ' Go Load the FileList
            CASE "Open Files"                                     '
               FMode = %FMOpen                                    ' Open files
            CASE "FLISTS"                                         '
               FMode = %FMFLISTS                                  ' FLISTS
            CASE "Configs"                                        '
               FMode = %FMConfigs                                 ' Configs
            CASE ELSE                                             '
               FMode = %FMFileList                                ' FILELIST format
               me.LoadFileList(flist)                             ' Go Load the FileList
         END SELECT                                               '
         DoClear(%LoadReq)                                        ' Say we've done it
         @P.PTopLine = 1                                          ' We're going to be at the top
         me.CsrRow = @P.PTop: me.CsrCol = @P.PCmdCol: @P.PCOffset = 0   ' Reset things
         FMask = SaveMask                                         ' Restore FMask
         MExit                                                    '
      END METHOD                                                  '

      METHOD BndsSave()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Save the BNDS line by updating the CFG file                                               |
      '--------------------------------------------------------------------------------------------+
      LOCAL OrigBnds, NewBnds, t AS STRING                        '
      LOCAL L0, LC, R0, RC, PC AS LONG                            '
         MEntry                                                   '
         OffBndsAFlag                                             ' Clear flag that got us here
         '-----------------------------------------------------------------------------------------+
         '- Validate the BNDS line contents                                                        |
         '-----------------------------------------------------------------------------------------+
         OrigBnds = FCB.GoodBnds                                  ' Copy Good bnds
         L0 = INSTR(OrigBnds, "<")                                ' Get Orig LBnds
         R0 = INSTR(OrigBnds, ">")                                ' Get Orig RBnds
         NewBnds = TP.BndText                                     ' Lets test it

         IF ISNULL(TRIM$(NewBnds)) THEN NewBnds = "<+"            ' If null'ed, stuff in a default

         '-----------------------------------------------------------------------------------------+
         '- Basic format OK?                                                                       |
         '-----------------------------------------------------------------------------------------+
         LC = TALLY(NewBnds, "<")                                 ' Count markers
         RC = TALLY(NewBnds, ">")                                 '
         PC = TALLY(NewBnds, "+")                                 '
         IF LC > 2 OR _                                           ' Basic format OK
            RC > 2 OR _                                           '
            PC > 1 OR _                                           '
            TRIM$(REMOVE$(NewBnds, ANY " <>+")) <> "" THEN        '
            GOTO ErrorOut                                         ' Bail out
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Eliminate previous Bnds if present                                                     |
         '-----------------------------------------------------------------------------------------+
         IF LC = 2 THEN                                           ' Two < markers
            IF MID$(NewBnds, L0, 1) = "<" THEN                    ' If still a <
               MID$(NewBnds, L0, 1) = " "                         ' Kill the old marker
               DECR LC                                            ' Adjust count
            ELSE                                                  '
               GOTO ErrorOut                                      ' Else an Error
            END IF                                                '
         END IF                                                   '
         IF RC = 2 THEN                                           ' Two > markers
            IF MID$(NewBnds, R0, 1) = ">" THEN                    ' If still a >
               MID$(NewBnds, R0, 1) = " "                         ' Kill the old marker
               DECR RC                                            ' Adjust count
            ELSE                                                  '
               GOTO ErrorOut                                      ' Else an Error
            END IF                                                '
         END IF                                                   '

         IF (LC = 1 AND RC = 1) AND (INSTR(NewBnds,"<") > INSTR(NewBnds, ">")) THEN ' New < right of old > ?
            MID$(NewBnds, R0, 1) = " "                            ' Kill the old marker
            DECR RC                                               ' Adjust count
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Save our result                                                                        |
         '-----------------------------------------------------------------------------------------+
         IF LC = 1 AND RC = 1 THEN                                ' A normal Left/Right?
            FCB.BndLeft = INSTR(NewBnds,"<"): FCB.BndRight = INSTR(NewBnds, ">") ' Save the values
            t = SPACE$(FCB.BndRight)                              ' Build a BNDS line
            MID$(t, FCB.BndLeft, 1) = "<": MID$(t, FCB.BndRight, 1) = ">"  '
         ELSEIF LC = 1 AND RC = 0 THEN                            '
            FCB.BndLeft = INSTR(NewBnds,"<"): FCB.BndRight = 0    ' Save the values
            t = SPACE$(FCB.BndLeft + 1)                           ' Build a BNDS line
            MID$(t, FCB.BndLeft, 2) = "<+"                        '
         END IF                                                   '
         TP.BndText = t                                           ' Replace working copy
         IF ISFALSE gMacroMode THEN                               '
            DoStatusBar($SBBnds)                                  ' re-Do the StatusBar BNDS box
         END IF                                                   '
         DoProfMsg("New BNDS values established")                 '
         MExitMeth                                                ' We're done

         ErrorOut:                                                '
            MErrExit(%eFail, "Invalid or extra characters in BNDS line")   '

      END METHOD                                                  '

      METHOD BStackAlloc() AS LONG                                '
      '--------------------------------------------------------------------------------------------+
      '- Allocate buffer from the Buffer Stack                                                     |
      '--------------------------------------------------------------------------------------------+
         METHOD = BStack(BStack(0))                               ' Return next item
         BStack(BStack(0)) = 0                                    ' Clear it in the 'allocated' entry
         INCR BStack(0)                                           ' Adjust stack pointer over it
      END METHOD                                                  '

      METHOD BStackFree(BuffNum AS LONG)                          '
      '--------------------------------------------------------------------------------------------+
      '- Free a buffer back to the pool                                                            |
      '--------------------------------------------------------------------------------------------+
         DECR BStack(0)                                           ' Backup stack pointer to last used item
         IF BStack(BStack(0)) <> 0 THEN MSGBOX "Buffer Stack error"  ' Better be zero
         BStack(BStack(0)) = BuffNum                              ' Stuff back the buffer #
      END METHOD                                                  '

      METHOD BStackGrow(Growth AS LONG)                           '
      '--------------------------------------------------------------------------------------------+
      '- Enlarge the Buffer Stack                                                                  |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER OldSize AS LONG                                    '
         OldSize = UBOUND(BStack())                               ' Get current size of the Stack
         REDIM PRESERVE BStack(OldSize + Growth) AS INSTANCE LONG ' Redim the BStack array
         FOR i = OldSize + 1 TO OldSize + Growth                  ' Initialize the new entries
            BStack(i) = i                                         ' Slot = Buffer number
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD  CallTab(cmd AS STRING, oprnd AS STRING)             '
      '--------------------------------------------------------------------------------------------+
      '- Call another Tab and return                                                               |
      '--------------------------------------------------------------------------------------------+
      LOCAL OurTab AS LONG, lclFPath, lclFMask, lclFListNm AS STRING '
         MEntry                                                   '
         OurTab = TP.PgNumber                                     ' Save our page number
         lclFPath = gENV.FMPath: lclFMask = gENV.FMMask: lclFListNm = gENV.FileListNm  ' Save around calls
         gENV.FMPath = FPath                                      ' Pass our FM variables to the called command
         gENV.FMMask = FMask                                      '
         gENV.FileListNm = FileListNm                             '
         CurrPCmd = cmd                                           ' Say what command we're doing
         SELECT CASE AS CONST$ cmd                                ' Call the correct guy
            CASE "BROWSE":   gEFTOpenSource = "": pCmdBROWSE(cmd + " " + oprnd)  '
            CASE "CANCEL":   pCmdCANCEL(cmd + " " + oprnd)        '
            CASE "CLONE":    pCmdCLONE (cmd + " " + oprnd)        '
            CASE "EDIT":     IF gEFTOpenSource <> "SELECT" THEN gEFTOpenSource = "" '
                             pCmdEDIT  (cmd + " " + oprnd)        '
            CASE "END":      pCmdEND   (cmd + " " + oprnd)        '
            CASE "IEDIT":    pCmdIEDIT (cmd + " " + oprnd)        '
            CASE "MEDIT":    pCmdMEDIT (cmd + " " + oprnd)        '
            CASE "OPEN":     pCmdOPEN  (cmd + " " + oprnd)        '
            CASE "OPENV":    pCmdOPEN  (cmd + " " + oprnd)        '
            CASE "OPENB":    pCmdOPEN  (cmd + " " + oprnd)        '
            CASE "SAVE":     pCmdSAVE  (cmd + " " + oprnd)        '
            CASE "VIEW":     gEFTOpenSource = "": pCmdVIEW  (cmd + " " + oprnd)  '
            CASE "XSUBMIT":  pCmdXSUBMIT(cmd + " " + oprnd)       '
         END SELECT                                               '
         gENV.FMPath = lclFPath: gENV.FMMask = lclFMask: gENV.FileListNm = lclFListNm  ' Restore things
         gENV.SetINITimeStamp                                     '
         TP = gTabs(OurTab)                                       ' Switch back to original tab
         MExit                                                    ' We're done
      END METHOD                                                  '

      METHOD CursorWord(OPT AddSQ AS LONG)                        '
      '--------------------------------------------------------------------------------------------+
      '- Extract 'word' under the cursor if possible                                               |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL DataIX AS LONG                                        '
      LOCAL lclWord, t AS STRING                                  '

         MEntry                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Exit if not even in the data area                                                      |
         '-----------------------------------------------------------------------------------------+
         IF ISFALSE IsCData THEN GOTO CursBailOut                 ' If not in data area then null things

         lclWord = FCB.WordStr + IIF$(ISFALSE ISMISSING(AddSQ), "'", "")   ' Fetch a local copy, add ' if requested
         DataIX = me.SGet(@P.C.CRow)                              ' Get the cursor line

         '-----------------------------------------------------------------------------------------+
         '- Exit if not a data line                                                                |
         '-----------------------------------------------------------------------------------------+
         IF DataIX < 1 THEN GOTO CursBailOut                      ' None, bail out
         IF ISFALSE IsLData(DataIX) THEN GOTO CursBailOut         ' Bail if not on a data line

         CursLine = LTxtG(DataIX)                                 ' Save the line the cursor's on
         CursLNum = DataIX                                        ' Save LPtr
         t = CursLine                                             ' Temp copy
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc index into string where cursor is located
         '-----------------------------------------------------------------------------------------+
         '- Exit if cursor sitting on a delimiter                                                  |
         '-----------------------------------------------------------------------------------------+
         IF INSTR(lclWord, MID$(t, i, 1)) = 0 THEN GOTO CursBailOut  ' If cursor is not sitting on a word character. Bail

         '-----------------------------------------------------------------------------------------+
         '- Extract the word now, cursor in Col 1                                                  |
         '-----------------------------------------------------------------------------------------+
         IF i = 1 THEN                                            ' Simple case (in column 1)
            CursCol = 1                                           '
            j = 1                                                 ' Look for a delimiter
            WHILE INSTR(lclWord, MID$(t, j, 1)) <> 0 AND j <= LEN(t) '
               INCR j                                             '
            WEND                                                  ' j = delim or end + 1
            CursWord = LEFT$(t, j - 1)                            ' Then Cursword is 1 thru DLM (or end) -1
            CursColE = j - 1                                      '

         '-----------------------------------------------------------------------------------------+
         '- Extract the word now, cursor somewhere else                                            |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     ' We're not in column 1
            DO WHILE i                                            ' Backup to 1st DLM char
               IF INSTR(lclWord, MID$(t, i, 1)) <> 0 THEN         '
                  DECR i                                          ' Backup 1 char
               ELSE                                               '
                  INCR i: EXIT DO                                 ' i now equals 1st char of word
               END IF                                             '
            LOOP                                                  '
            i = MAX(1, i)                                         ' Minimum of 1
            j = i                                                 ' Look for a delimiter
            WHILE INSTR(lclWord, MID$(t, j, 1)) <> 0 AND j <= LEN(t) '
               INCR j                                             '
            WEND                                                  ' j = delim or end + 1
            CursCol = i                                           ' Save column
            CursWord = MID$(t, i TO j - 1)                        ' Then Cursword is i thru DLM (or end) -1
            CursColE = j - 1                                      '
         END IF                                                   '
         MExitMeth                                                '

      CursBailOut:                                                '
            RESET CursWord, CursLine, CursLNum, CursCol, CursColE ' Null answer fields
            MExitMeth                                             ' Exit
         RETURN                                                   '
      END METHOD                                                  '

      METHOD CursWordLoc()                                        '
      '--------------------------------------------------------------------------------------------+
      '- Mark 'word' under the cursor if possible                                                  |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL DataIX AS LONG                                        '
      LOCAL lclWord, t AS STRING                                  '
         MEntry                                                   '
         OffMarkActive                                            '

         '-----------------------------------------------------------------------------------------+
         '- See if cursor is at least somewhere reasonable                                         |
         '-----------------------------------------------------------------------------------------+
         lclWord = FCB.WordStr                                    ' Fetch a local copy
         DataIX = me.SGet(@P.C.CRow)                              ' Get the cursor line
         IF ISFALSE IsLData(DataIX) THEN MExitMeth                ' Bail if not on a data line
         t = LTxtG(DataIX)                                        ' Get the text
         i = @P.C.CCol - @P.PGapCol + @P.POffset                  ' Calc index into string where cursor is located
         IF INSTR(lclWord, MID$(t, i, 1)) = 0 THEN MExitMeth      ' If cursor in a deimiter type area, also bail out

         '-----------------------------------------------------------------------------------------+
         '- Set the MARK values                                                                    |
         '-----------------------------------------------------------------------------------------+
         MarkRect.Top = @P.PS(@P.C.CRow)                          '
         MarkRect.Bottom = MarkRect.Bottom                        '
         OnMarkActive                                             '

         IF i <> 1 THEN                                           ' If not the Simple case (in column 1)
            DO WHILE i                                            ' Backup to 1st DLM char
               IF INSTR(lclWord, MID$(t, i, 1)) <> 0 THEN         ' On a word char?
                  DECR i                                          ' Backup 1 char
               ELSE                                               '
                  INCR i: EXIT DO                                 ' i now equals 1st char of word
               END IF                                             '
            LOOP                                                  '
            i = MAX(i, 1)                                         ' i must be at least 1
         END IF                                                   '
         j = i                                                    ' Look for a delimiter
         WHILE INSTR(lclWord, MID$(t, j, 1)) <> 0 AND j <= LEN(t) '
            INCR j                                                '
         WEND                                                     ' j = delim or end + 1

         MarkRect.Left = i                                        ' Remember starting x/y of Select frame
         MarkRect.Right = j - 1                                   '

         '-----------------------------------------------------------------------------------------+
         '- Don't collide with SWAP highliting                                                     |
         '-----------------------------------------------------------------------------------------+
         IF IsSwapActive THEN                                     ' Prevent Swap overlap
            IF MarkRect.Top = SwapSLin THEN                       ' Same line?
               IF MarkRect.Left >= SwapSCol AND MarkRect.Left <= SwapECol THEN GOSUB ClrMark: MExitMeth  '
               IF MarkRect.Right >= SwapSCol AND MarkRect.Right <= SwapECol THEN GOSUB ClrMark: MExitMeth   '
            END IF                                                '
         END IF                                                   '
         MExitMeth                                                '

      ClrMark:                                                    '
         MarkRect.Top = 0: MarkRect.Bottom = 0                    ' Reset things
         MarkRect.Left = 0: MarkRect.Right = 0                    '
         OffMarkActive                                            '
         RETURN                                                   '

      END METHOD                                                  '

      METHOD DataInsert(iText AS STRING, cText AS WSTRING, iInsert AS STRING, i AS LONG)  '
      '--------------------------------------------------------------------------------------------+
      '- Handle inserting a string into a string                                                   |
      '--------------------------------------------------------------------------------------------+
      LOCAL j, x, y, q, qq, GotColumns AS LONG, lh, lh2, rh, qDlm AS STRING, cOld AS WSTRING '
      LOCAL lhW, lh2W, rhW AS WSTRING                             '
         MEntry                                                   '
         IF i > LEN(iText) THEN iText = LSET$(iText, i)           ' Make sure line is long enough
         IF LEN(iText) > LEN(CText) THEN CText = LSET$(CText, LEN(iText) USING CHR$$(0))  ' Lengthen Attr if needed
         cOld = MID$(CText, i, 1)                                 ' Get char at insert position
         cOld = REPEAT$(LEN(iInsert), cOld)                       ' Create Attr insert string
         IF ISFALSE IsNsrtData THEN                               ' If not the complex DataInsert, do it quick and exit
            iText = STRINSERT$(iText, iInsert, i)                 ' Simple string insert
            cText = STRINSERT$(cText, cOld, i)                    '
            MExitMeth                                             ' We're done
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- See if any 'columns' in the data                                                       |
         '-----------------------------------------------------------------------------------------+
         j = i                                                    ' Get start scan
         DO                                                       ' Loop looking for compressible spaces
            x = INSTR(j, iText, "  ")                             ' Look for at least 2 blanks following found string
            IF x = 0 THEN EXIT DO                                 ' No blanks, skip all the junk
            q = INSTR(j, iText, ANY "'`" + $DQ)                   ' Any quotes?
            qDLM = MID$(iText, q, 1)                              ' Save which one
            qq = INSTR(q + 1, iText, qDLM)                        ' Look for closing
            IF q = 0 OR (q <> 0 AND qq = 0) THEN EXIT DO          ' If no valid quoted string, skip out
            IF x < q THEN EXIT DO                                 ' If spaces preceed quotes, skip out
            j = qq + 1                                            ' Scan again after closing quote
         LOOP                                                     '
         IF x THEN                                                ' If we've got spare blanks
            FOR y = x TO LEN(iText)                               ' Look through remainder of line for a non- blank
               IF MID$(iText, y, 1) <> " " THEN                   ' Got one?
                  GotColumns = %True                              ' Remember we have columns
                  EXIT FOR                                        ' Exit, y - 1 is split point for lh/rh
               END IF                                             '
            NEXT y                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- There are columns and DataInsert requested                                             |
         '-----------------------------------------------------------------------------------------+
         IF GotColumns THEN                                       ' Data Insert AND columns?
               lh = LEFT$(iText, y - 1)                           ' Create full lh portion
               rh = MID$(iText, y)                                ' Create full rh portion
               lh2 = RTRIM$(MID$(lh, i))                          ' Create rh part of the full lh portion
               lh = LEFT$(lh, i - 1)                              ' Create lh part of the full lf portion
               lh = lh + iInsert + lh2                            ' Re-Build the full lh portion with the change
               IF LEN(lh) < y - 1 THEN                            ' If lh is less than orig length of lh portion
                  lh = LSET$(lh, y - 1)                           ' make it back up to original length
               END IF                                             '
               iText = lh + rh                                    ' Re-build the altered text

               lhw = LEFT$(cText, y - 1)                          ' Create full lh portion
               rhw = MID$(cText, y)                               ' Create full rh portion
               lh2w = LEFT$(MID$(lhw, i), LEN(lh2))               ' Create rh part of the full lh portion
               lhw = LEFT$(lhw, i - 1)                            ' Create lh part of the full lf portion
               lhw = lhw + cOld + lh2w                            ' Re-Build the full lh portion with the change
               IF LEN(lhw) < y - 1 THEN                           ' If lh is less than orig length of lh portion
                  lhw = LSET$(lhw, y - 1 USING CHR$$(0))          ' make it back up to original length
               END IF                                             '
               cText = lhw + rhw                                  ' Re-build the altered text

         '-----------------------------------------------------------------------------------------+
         '- Normal non- DataInsert mode                                                            |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     '
            IF i > LEN(iText) THEN iText = LSET$(iText, i)        ' Past the right end? Then lengthen string
            IF i > LEN(cText) THEN cText = LSET$(cText, i USING CHR$$(0))  ' Past the right end? Then lengthen string
            iText = STRINSERT$(iText, iInsert, i)                 ' Simple string insert
            cText = STRINSERT$(cText, cOld, i)                    '

         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '


      METHOD DispANSI(BYVAL colMode AS LONG)                      '
      '--------------------------------------------------------------------------------------------+
      '- Fire up ANSI window in a new thread                                                       |
      '--------------------------------------------------------------------------------------------+
      '- (CharSet)   passes colMode = %False
      '- (CharSetCol) passes colMode = %True

      LOCAL hANSIThread, i AS LONG                                '
         MEntry                                                   '

         THREAD CREATE DispANSI2(BYVAL colMode) 65536, TO hANSIThread   '

         IF hANSIThread = 0 THEN _                                ' Failed?
            MErrExit(%eFail, "Could not create ANSI Window")      '
         SLEEP 200                                                ' Wait a bit
         THREAD STATUS hANSIThread TO i                           ' See if running OK
         IF i <> 259 THEN _                                       ' If running OK STATUS returns &H103 (See Help)
            MErrExit(%eFail, "Could not run ANSI Window")         '
         THREAD CLOSE hANSIThread TO i                            ' Free up our handle
         MExit                                                    '
      END METHOD                                                  '

      METHOD  DispFM()                                            '
      '--------------------------------------------------------------------------------------------+
      '- Display the File Manager Screen                                                           |
      '--------------------------------------------------------------------------------------------+
      LOCAL sp, stp AS LONG                                       '
      LOCAL i, LastScrLine, ColIX AS LONG                         '
      LOCAL tText AS STRING                                       '
      LOCAL lclAttr AS WSTRING                                    '
         MEntry                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Always get refreshed data if needed                                                    |
         '-----------------------------------------------------------------------------------------+
         IF IsDoLoadReq THEN me.LoadReq(FPath, FMask, FileListNm) ' Maybe Load Requests if needed
         IF IsDoLoadData AND ISFALSE IsDoMsg THEN me.LoadData     ' Load Data if needed and no messages waiting
         DoClear(%Refresh)                                        '
         FMNestCkpt                                               ' Ckpt this display

         '-----------------------------------------------------------------------------------------+
         '- Display the FM window                                                                  |
         '-----------------------------------------------------------------------------------------+
         GRAPHIC ATTACH PgHandle, WindowID, REDRAW                ' Set as the default graphic area
         gBandBG = %False                                         ' Clear any prior banding state
         DoPrint ("Command > ", $$TxtHi, 1, 1)                    ' Re-do the command line
         IF ISNOTNULL(pCommandPrv) THEN                           ' Got an & command line?
            pCommand = pCommandPrv                                ' Swap it in
            pCommandPrv = ""                                      ' null it
         END IF                                                   '

         me.WindowCmd                                             '
         DoPrint ("Scroll > ", $$TxtHi, 1, @P.PLeft + 10 + @P.PCmdLen + 1) '
         DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, 1, @P.PLeft + 10 + @P.PCmdLen + 9 + 1)   '
         ScrollLast = FCB.ScrollAmt                               ' Save as last valid Scroll value

         DoPrint (STRING$(gENV.ScrWidth, " "), $$TxtLo, 2, 1)     ' Print normal dash line
         IF ISFALSE gResizeActive THEN                            ' Don't do messages during a RESIZE
            IF ErrMsgTblC > 0 THEN                                ' If there's an Error message?
               gBandBG = IIF(ErrMsgHigh, %True, %False)           ' Select BG color
               tText = IIF$(ErrMsgTblC > 1, " +", " ") + ErrMsgTop   '
               DoPrint (tText, $$Error, 2, gENV.ScrWidth - LEN(tText))  ' Print error message
               IF ErrMsgHigh = %eFail THEN                        ' Errors
                  DoBeep                                          ' Beep on errors
               END IF                                             '
            END IF                                                '
         END IF                                                   '
         IF gENV.MacName AND ISNOTNULL(MacName) THEN DoPrint ("Macro(" + MacName + ")", $$Error, 2, 1)   ' MacName
         gBandBG = %False                                         ' Reset BG color

         '-----------------------------------------------------------------------------------------+
         '- Do the Quick entries                                                                   |
         '-----------------------------------------------------------------------------------------+
         DoPrint (REPEAT$(gENV.ScrWidth, " "), $$FMTool, gFM_Quick_Line_1, 1) ' Blank the line on the screen
         DoPrint ("New", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_1)   ' Print the quick entries
         gBandBG = IIF(ISNULL(FileListNm), %True, %False)         '
         DoPrint ("FilePath", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_2) '
         gBandBG = IIF(FileListNm = "Recent Files", %True, %False)   '
         DoPrint ("Recent", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_3)   '
         gBandBG = IIF(FileListNm = "Found Files", %True, %False) '
         DoPrint ("Found", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_4) '
         gBandBG = IIF(FMode = %FMOpen, %True, %False)            '
         DoPrint ("Open", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_5)  '
         gBandBG = IIF(FileListNm = "Favorite Files", %True, %False) '
         DoPrint ("Favorites", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_6)   '
         gBandBG = IIF(FMode = %FMFLISTS, %True, %False)          '
         DoPrint ("FLISTS", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_7)   '
         gBandBG = IIF(FMode = %FMRecPaths, %True, %False)        '
         DoPrint ("Paths", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_8) '
         gBandBG = IIF(FMode = %FMConfigs, %True, %False)         '
         DoPrint ("Configs", $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_9)  '
         IF ISNOTNULL(gFMQFList1) THEN                            ' Now add the user entries
            gBandBG = IIF(FileListNm = gFMQFlist1, %True, %False) '
            DoPrint (gFMQFList1, $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_10)   '
         END IF                                                   '
         IF ISNOTNULL(gFMQFList2) THEN                            '
            gBandBG = IIF(FileListNm = gFMQFlist2, %True, %False) '
            DoPrint (gFMQFList2, $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_11)   '
         END IF                                                   '
         IF ISNOTNULL(gFMQFList3) THEN                            '
            gBandBG = IIF(FileListNm = gFMQFlist3, %True, %False) '
            DoPrint (gFMQFList3, $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_12)   '
         END IF                                                   '
         IF ISNOTNULL(gFMQFList4) THEN                            '
            gBandBG = IIF(FileListNm = gFMQFlist4, %True, %False) '
            DoPrint (gFMQFList4, $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_13)   '
         END IF                                                   '
         IF ISNOTNULL(gFMQFList5) THEN                            '
            gBandBG = IIF(FileListNm = gFMQFlist5, %True, %False) '
            DoPrint (gFMQFList5, $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_14)   '
         END IF                                                   '
         IF ISNOTNULL(gFMQFList6) THEN                            '
            gBandBG = IIF(FileListNm = gFMQFlist6, %True, %False) '
            DoPrint (gFMQFList6, $$FMTool, gFM_Quick_Line_1, gFM_Quick_Pos_15)   '
         END IF                                                   '
         gBandBG = %False                                         ' Ensure we end up with %False

         IF ISNULL(FileListNm) THEN                               ' Normal FM Screen
            DoPrint ("File / Path    > ", $$TxtHi, gFM_Path_Line, 1) '
            tText = LSET$(me.FileAbbrev(FPath, gFM_Crit_Size), gFM_Crit_Size) '
            DoPrint (tText, $$TxtHi, gFM_Path_Line, gFM_Path_Left)   '
            DoPrint ("Filter Mask    > ", $$TxtHi, gFM_Mask_Line, 1) '
            tText = LSET$(FMask, gFM_Crit_Size)                   '
            DoPrint (tText, $$TxtLo, gFM_Mask_Line, gFM_Mask_Left)   '

         '-----------------------------------------------------------------------------------------+
         '- Do a FM FILELIST type heading                                                          |
         '-----------------------------------------------------------------------------------------+
         ELSE                                                     '
            DoPrint ("File List Name > ", $$TxtHi, gFM_Path_Line, 1) '
            IF FFSearch = "" THEN                                 ' Handle Found list differently
               DoPrint (LSET$(FileListNm, gFM_Crit_Size), $$TxtHi, gFM_Path_Line, gFM_Path_Left)   '
            ELSE                                                  '
               DoPrint (LSET$(FileListNm + ": " + FFSearch, gFM_Crit_Size), $$TxtHi, gFM_Path_Line, gFM_Path_Left)   '
            END IF                                                '
            DoPrint ("Filter Mask    > ", $$TxtHi, gFM_Mask_Line, 1) ' Display the header
            DoPrint (LSET$(FMask, gFM_Crit_Size), $$TxtLo, gFM_Mask_Line, gFM_Mask_Left)  '

         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do the column headings                                                                 |
         '-----------------------------------------------------------------------------------------+
         DoPrint (REPEAT$(gENV.ScrWidth, " "), $$FMTool, gFM_Head_Line, 1) ' Blank the line on the screen
         DoPrint (IIF$(gENV.FMLCmdWidth > 6, "Command", "Cmd"), $$FMTool, gFM_Head_Line, 1)  '
         DoPrint (DirSort + " " + gFMC(1).CHead + "  ", $$FMTool, gFM_Head_Line, gFM_Head_Name_Left)  '
         ColIX = 2                                                ' Do Active Columns
         DO WHILE TP.GetDefActCol(ColIX) <> 0                     ' An active column?
            i = TP.GetDefActCol(ColIX)                            ' Fetch it
            IF gFMC(i).CAlign = "L" THEN                          ' Normal Left aligh?
               DoPrint (gFMC(i).CHead, $$FMTool, gFM_Head_Line, gFMC(i).CPos) '
            ELSE                                                  ' Right align
               DoPrint (RSET$(gFMC(i).CHead, gFMC(i).CSize), $$FMTool, gFM_Head_Line, gFMC(i).CPos)   '
            END IF                                                '
            INCR ColIX                                            '
         LOOP                                                     '

         '-----------------------------------------------------------------------------------------+
         '- Loop through data lines on the screen                                                  |
         '-----------------------------------------------------------------------------------------+
         stp = @P.PTopLine                                        ' Set Screen Text Pointer to current TopScrn setting
         IF gENV.VScrollBar THEN                                  ' Doing ScrollBar
            SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, @P.PDlines '
            SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, gFMDCtr + 7   '
            SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, @P.PTopLine  '
         END IF                                                   '
         FOR sp = gFM_Top_File_Line TO gFM_Top_File_Line + gFM_List_Height - 1   ' Loop for logical Screen data lines
            BGBandEdit(sp)                                        ' Get Banding setup

            '--------------------------------------------------------------------------------------+
            '- Below last data line                                                                |
            '--------------------------------------------------------------------------------------+
            IF stp > gFMDCtr THEN                                 ' Past end of dataset table?
               DoPrint (REPEAT$(gENV.ScrWidth, " "), $$TxtLo, sp, 1) ' Blank the line on the screen
               INCR stp                                           '
               ITERATE FOR                                        '

            ELSEIF gFMD(stp).Flag = %FTotal THEN                  '
               DoPrint REPEAT$(gENV.FMLCmdWidth + 1, " "), $$TxtLo, sp, 1  '
               DoPrint (LSET$(TRIM$(gFMD(stp).FileName), gENV.ScrWidth), $$TxtHi, sp, gFMC(1).CPos)   ' Dump total line
               LastScrLine = sp                                   ' Save last printed screen line
               INCR stp                                           '
               ITERATE FOR                                        '

            '--------------------------------------------------------------------------------------+
            '- A Normal entry                                                                      |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  '
               LastScrLine = sp                                   ' Save last printed screen line
               DoPrint gFMD(stp).PrtCmd + " ", $$TxtLo, sp, 1     ' Print the Line Command

               '-----------------------------------------------------------------------------------+
               '- Do the Message field or First column                                             |
               '-----------------------------------------------------------------------------------+
               IF ISNULL (gFMD(stp).Message) THEN                 ' Is there a message waiting?
                  tText = gFMD(stp).PrtField(gFMC(1).CField, lclAttr, 1)   ' No, get the text and its attribute
                  IF gFMC(1).CField = "NAME" OR gFMC(1).CField = "PATH" THEN  '
                     tText = TP.FileAbbrev(tText, gFMC(1).CSize)  ' Abbreviate it as needed
                  END IF                                          '
                  IF gFMC(1).CAlign = "L" THEN                    ' Left Align?
                     DoPrint(LSET$(tText, gFMC(1).CSize), lclAttr, sp, gFMC(1).CPos)   ' Print Field
                  ELSE                                            '
                     DoPrint(RSET$(LTRIM$(tText), gFMC(1).CSize), lclAttr, sp, gFMC(1).CPos) ' Print Field
                  END IF                                          '
                  DoPrint(LSET$(tText, gFMC(1).CSize + 2), lclAttr, sp, gFMC(1).CPos)  ' Print First Column
               ELSE                                               ' We have a message instead of the filename
                  DoPrint (LSET$(gFMD(stp).message, gENV.ScrWidth), $$Error, sp, gFMC(1).CPos)  '
                  DoSet(%LoadData)                                ' Trigger clear message
                  DOClear(%Msg)                                   ' Clear message flag
                  GOTO SkipCols                                   ' Ignore other columns
               END IF                                             '
               gFM_RightMost = gFMC(1).CPos + gFMC(1).CSize       ' Track rightmost

               ColIX = 2                                          ' Do Active Columns
               DO WHILE TP.GetDefActCol(ColIX) <> 0               ' An active column?
                  i = TP.GetDefActCol(ColIX)                      ' Fetch it
                  tText = gFMD(stp).PrtField(gFMC(i).CField, lclAttr, i)   ' Get field and print attribute
                  IF gFMC(i).CField = "NAME" OR gFMC(i).CField = "PATH" THEN  '
                     tText = TP.FileAbbrev(tText, gFMC(i).CSize)  ' Abbreviate it as needed
                  END IF                                          '
                  IF gFMC(i).CAlign = "L" THEN                    ' Left Align?
                     DoPrint(LSET$(tText, gFMC(i).CSize), lclAttr, sp, gFMC(i).CPos)   ' Print Field
                  ELSE                                            '
                     DoPrint(RSET$(LTRIM$(tText), gFMC(i).CSize), lclAttr, sp, gFMC(i).CPos) ' Print Field
                  END IF                                          '
                  IF i <> gFMCCtr THEN DoPrint("  ", $$TxtLo, sp, gFMC(i).CPos + gFMC(i).CSize) '
                  gFM_RightMost = gFMC(i).CPos + gFMC(i).CSize + IIF(i = gFMCCtr, 0, 2)   ' Track rightmost
                  INCR ColIX                                      '
               LOOP                                               '
               IF gFM_RightMost < gENV.ScrWidth THEN              ' Space on the right?
                  DoPrint (REPEAT$(gENV.ScrWidth - gFM_RightMost + 1, " "), $$TxtLo, sp, gFM_RightMost)  ' Blank the rest of the line
               END IF                                             '
               SkipCols:                                          ' For skipping columns 2-n when an error message is displayed
            END IF                                                '
            INCR stp                                              '
         NEXT sp                                                  '
         Me.DispFMHelp                                            ' Add help lines if needed
         IF IsCBad OR @P.C.CRow > LastScrLine THEN                ' If we ended up somewhere bad
            me.CsrRow = @P.PTop: me.CsrCol = @P.PCmdCol           ' Reset it to Cmd line
         ELSEIF @P.C.CRow >= gFM_Top_File_Line THEN               ' If in line area
            IF TRIM$(gFMD(@P.C.CRow - gFM_Top_File_Line + @P.PTopLine).Cmd) = "" THEN  ' If nothing in command
               me.CsrCol = @P.PLeft                               ' Reset it to Cmd line
            END IF                                                '
         END IF                                                   '

         me.MarkLineNumb                                          ' Mark the line number

         LFPath = UUCASE(TRIM$(FPath))                            ' Save last Path
         LFMask = UUCASE(TRIM$(FMask))                            ' Save last Mask
         LFileListNm = UUCASE(TRIM$(FileListNm))                  ' Save last FileListNm
         LScrlAmtC = UCASE$(FCB.ScrollAmt)                        ' Save last Scroll amount
         LastTop = @P.PTopLine                                    ' Save where we are
Bailout:                                                          '
         GRAPHIC REDRAW                                           '
         GRAPHIC ATTACH PgHandle, WindowID                        ' Set as the default graphic area
         IF gDoBeepFlag THEN DoBeepReal                           ' If needed, do a Beep
         MExitMeth                                                '

      END METHOD                                                  '

      METHOD  DispFMHelp()                                        '
      '--------------------------------------------------------------------------------------------+
      '- Display FM HELP if asked for                                                              |
      '--------------------------------------------------------------------------------------------+
      LOCAL HMask, tText, tItem AS STRING, i, j, DidOne AS LONG   '
      STATIC tt() AS STRING                                       '
      DIM tt(1 TO 27) AS STATIC STRING                            '
         IF ISFALSE gENV.FMHelpFlag THEN EXIT METHOD              ' Skip if not needed
         IF ISNULL(tt(1)) THEN                                    ' Build text array just once
            ARRAY ASSIGN tt() = _                                 ' Create the entries
                 "Add to Fav. ", _                               ' Add to Fav.   A + 128
                 "Kacup ", _                                    ' Backup        B + 128, K + 128
                 "Browse ", _                                    ' Browse        B + 128
                 "Ncel ", _                                    ' Cancel        C + 128, A + 128, N + 128
                 "Cone ", _                                     ' Clone         C + 128, L + 128
                 "Delete ", _                                    ' Delete        D + 128
                 "W ", _                                       ' DIR           D + 128, I + 128, R + 128
                 "|IF/ ", _                                   ' DiffA/B       D + 128, F + 128, A + 128, B + 128
                 "Edit ", _                                      ' Edit          E + 128
                 "Z ", _                                       ' End           E + 128, N + 128, D + 128
                 "$ec ", _                                      ' Exec          E + 128, X + 128
                 "Forget ", _                                    ' Forget        F + 128
                 "Job-submit ", _                                ' Job-Submit    J + 128
                 "Lines ", _                                     ' Lines         L + 128
                 "MultiEdit ", _                                 ' MultiEdit     M + 128
                 "Horm ", _                                      ' Norm          N + 128
                 "Open ", _                                      ' Open          O + 128
                 "Print ",_                                      ' Print         P + 128
                 "Rename ", _                                    ' Rename        R + 128
                 "Yetore ", _                                   ' Restore       R + 128, S + 128
                 "V ", _                                      ' Save          S + 128, A + 128, V + 128, E + 128
                 "Select ", _                                    ' Select        S + 128
                 "Touch ", _                                     ' Touch         T + 128
                 "X ", _                                      ' WDIR          W + 128, D + 128, I + 128, R + 128
                 "G ", _                                       ' ALL           A + 128, L + 128, L + 128
                 "Iiew ", _                                      ' View          V + 128
                 "Q "                                            ' W             W + 128
         END IF                                                   '

         SELECT CASE CONST$ FileListNm                            ' Setup the Command mask ith valid commands
            CASE ""               : HMask = "ABKCD|E$JLMOPRYSTIQX"   '
            CASE "Found Files"    : HMask = "ABKCD|WE$FJLMOPRYSTIQX" '
            CASE "Recent Files"   : HMask = "ABKCD|WE$FJLMOPRYSTIQX" '
            CASE "Recent Paths"   : HMask = "FSX"                 '
            CASE "Favorite Files" : HMask = "BKCD|WE$FJLMOPRYSTIQX"  '
            CASE "FLISTS"         : HMask = "GBDEHMRS"            '
            CASE "Open Files"     : HMask = "ANC|WZJOPVX"         '
            CASE "Configs"        : HMask = "DRS"                 '
            CASE ELSE:            : HMask = "ABKCD|WFEJLMOPRYSTI" '
         END SELECT                                               '

         tText = " Commands: "                                    ' Build help line 1
         FOR i = 1 TO LEN(HMask)                                  ' Loop through the valid items
            tItem = MID$(hMask, i, 1)                             ' Get next char
            ARRAY SCAN tt(), FROM 1 TO 1, =tItem, TO j            ' Find the entry
            tText += MID$(tt(j), 2)                               ' Add the text
            IF LEN(tText) > 85 THEN                               ' Filled the line?
               DoPrintPFKHelp (LSET$(tText, gENV.ScrWidth), gENV.ScrHeight - 2)  ' Go print it
               DidOne = %True                                     ' Say we did it
               tText = "           "                              ' Build help line 2
            END IF                                                '
         NEXT i                                                   '
         IF ISFALSE DidOne THEN                                   ' Didn't fill line 1?
            DoPrintPFKHelp (LSET$(tText, gENV.ScrWidth), gENV.ScrHeight - 2)  ' Go print it
            tText = "           "                                 ' Build help line 2
         END IF                                                   '
         DoPrintPFKHelp(LSET$(tText, gENV.ScrWidth), gENV.ScrHeight - 1)   ' Go print it
         tText = " Filters : Masks separated by ;  such as *.BAS;*.TXT;*.INC;*.H" ' Hint line
         DoPrintPFKHelp(LSET$(tText, gENV.ScrWidth), gENV.ScrHeight) ' Go print it
      END METHOD                                                  '

      METHOD DispLine(stp AS LONG, sp AS LONG)                    '
      '--------------------------------------------------------------------------------------------+
      '- Display one single text data line                                                         |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
         IF IsLData(stp) THEN                                     ' Peel off the most common first
            '--------------------------------------------------------------------------------------+
            '- Extra setup needed for PowerType mode                                               |
            '--------------------------------------------------------------------------------------+
            IF IsPTypeMode THEN                                   ' If in PType mode
               IF P = PPActive AND sp >= @P.PTop AND sp <= @P.PBottom THEN '
                  FOR i = 1 TO gPTblCount                         ' Update the PT table with screen row
                     IF stp = gPTbl(i).tLin THEN                  ' A PT line being displayed
                        gPTbl(i).sRow = sp                        ' Tell PT code what screen line it is
                        EXIT FOR                                  '
                     END IF                                       '
                  NEXT i                                          '
               END IF                                             '
            END IF                                                '
            DoPrint (LTxtG(stp), LAttrG(stp), sp, @P.PDataCol, @P.POffset, @P.PDatalen)   ' Go print the line, honor Offset/Datalen

         ELSEIF IsLWord(stp) THEN                                 '
            DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '
         ELSEIF IsLMark(stp) THEN                                 '
            DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '
         ELSEIF IsLMask(stp) THEN                                 '
            DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '
         ELSEIF IsLProf(stp) THEN                                 '
            DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '
         ELSEIF IsLTabs(stp) THEN                                 '
            DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '
         ELSEIF IsLNote(stp) THEN                                 '
            DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '
         ELSEIF IsLBounds(stp) THEN                               '
            DoPrint (me.WindowBnds, $$TxtHi, sp, @P.PDataCol)     '
         END IF                                                   '
         me.MarkReDraw(sp)                                        ' Re-draw the MARK lines
      END METHOD                                                  '

      METHOD DispScreen()                                         '
      '--------------------------------------------------------------------------------------------+
      '- Display new screen from TopScrn down                                                      |
      '--------------------------------------------------------------------------------------------+
      LOCAL Scrl, PageSeen AS LONG                                '
      LOCAL title, tText, u, v AS STRING                          '
      LOCAL i, j, k, TargetCol, lColumn, sp, stp, HideFlag AS LONG'
      LOCAL lScrl, CurSet AS INTEGER                              '

         MEntry                                                   '
         DoClear(%Refresh)                                        '
         IF ISFALSE gENV.InitDone THEN MexitMeth                  '
         '-----------------------------------------------------------------------------------------+
         '- If FM, pass off                                                                        |
         '-----------------------------------------------------------------------------------------+
         IF IsFMTab THEN me.DispFM: MexitMeth                     ' If this is the FM tab, pass it off
         '-----------------------------------------------------------------------------------------+
         '- See if FileWatch has posted us                                                         |
         '-----------------------------------------------------------------------------------------+
         IF WatchFlag <> " " THEN                                 ' Posted by File Watch?
            IF ISFALSE gfEndAll OR IsModdFlag THEN FileChangeNotification  ' If not doing shutdown or file modified
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Start building the screen                                                              |
         '-----------------------------------------------------------------------------------------+
         IF ISFALSE gMacroMode THEN GRAPHIC ATTACH PgHandle, WindowID, REDRAW ' Set as the default graphic area
         '-----------------------------------------------------------------------------------------+
         '- Do the Xcluded line rebuild if needed                                                  |
         '-----------------------------------------------------------------------------------------+
         me.LFlagBitOn(@P.PTopLine, %TopScreen)                   ' Ensure TopScrn gets saved
         me.XRebuild(i, j, k)                                     ' Go rebuild the Excluded stuff
         IF i THEN sCurLin = i                                    ' Save the answers
         IF j THEN @P.PTopLine = j                                '
         IF k THEN sCurScrl = k                                   '
         P = VARPTR(P1)                                           ' Point at 1st Panel

         DispPanel:                                               '
         '-----------------------------------------------------------------------------------------+
         '- If a cursor request pending, get screen positioned                                     |
         '-----------------------------------------------------------------------------------------+
         IF sCurPrio > 0 THEN                                     ' Cursor request provided?
            IF P = PPActive THEN                                  ' Doing active panel?
               IF sCurScrl THEN                                   ' If forced scrolling permitted
                  i = @P.PData1: j = @P.PBottom                   ' Get top/bottom screen lines of panel
                  VisTop = @P.PS(i): VisBot = VisTop              ' Get Lno of top panel line
                  FOR k = i TO j                                  ' Search Screen line table
                     IF @P.PS(k) = 0 THEN EXIT FOR                ' Below the bottom? Exit
                     Visbot = @P.PS(k)                            ' Save as last visible line
                  NEXT k                                          '

                  IF sCurPrio <> %FLocate AND sCurPrio <> %FChange THEN ' If not a forced locate/change
                     IF sCurLin < VisTop OR sCurLin > VisBot THEN ' Move if needed and allowed
                        @P.PTopLine = IIF(sCurPrio <> %Locate, MAX(1, sCurLin - 1), sCurLin) ' Move TopScrn accordingly
                     ELSE                                         ' Within window
                        @P.PTopLine = VisTop                      ' Stay where we are
                     END IF                                       '
                  ELSE                                            '
                     @P.PTopLine = MAX(1, sCurLin)                ' Move TopScrn accordingly
                  END IF                                          '

                  TargetCol = L(sCurLin).LCol                     ' Copy column request
                  IF TargetCol <> 0 AND (TargetCol <@P.POffset + @P.PLeft OR TargetCol > @P.PRight + @P.POffset - @P.PDataCol) THEN '
                     SELECT CASE AS CONST$ FCB.ScrollAmt          ' Get the default Scrl amount
                        CASE "HALF": Scrl = INT(@P.PDataLen / 2)  '
                        CASE "PAGE": Scrl = @P.PDataLen           '
                        CASE "FULL": Scrl = @P.PDataLen           '
                        CASE "DATA": Scrl = @P.PDataLen - 1       '
                        CASE ELSE:   Scrl = @P.PDataLen           '
                     END SELECT                                   '
                     @P.POffSet = 0                               ' Set temp back to zero
                     DO WHILE @P.POffSet + @P.PDataLen < TargetCol   ' While target column is offscreen
                        me.OffSetAdd(Scrl)                        '
                     LOOP                                         '
                  END IF                                          '
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Setup the Tab title                                                                    |
         '-----------------------------------------------------------------------------------------+
         me.TabTitleSet(%False)                                   '

         '-----------------------------------------------------------------------------------------+
         '- Building the screen, do first Panel line                                               |
         '-----------------------------------------------------------------------------------------+
         me.PanelColsSet(1, FCB.Cols): me.PanelColsSet(2, FCB.Cols) ' Ensure Cols mode is correct
         gBandBG = %False                                         ' Reset any prior Banding value
         CurSet = %False                                          ' Start as no cursor set
         LastRulCol = 0: LastRulRow = 0                           ' No line cursors are present
         IF gENV.VScrollBar AND ISFALSE gMacroMode AND PPActive = P THEN   ' Doing scrollbar?
            SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, @P.PBottom - @P.PTop   '
            SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, TP.LastLine + 3  '
            SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, @P.PTopLine  '
         END IF                                                   '
         DoPrint ("Command > ", $$TxtHi, @P.PTop, @P.PLeft)       ' Re-do the command line
         IF ISNOTNULL(pCommandPrv) THEN                           ' Got an & command line?
            pCommand = pCommandPrv                                ' Swap it in
            pCommandPrv = ""                                      ' null it
         END IF                                                   '
         me.WindowCmd                                             '
         DoPrint ("Scroll > ", $$TxtHi, @P.PTop, @P.PScrHdr)      '
         DoPrint (LSET$(FCB.ScrollAmt, 4), $$TxtLo, @P.PTop, @P.PScrData)  '
         ScrollLast = FCB.ScrollAmt                               ' Save as last valid Scroll value
         '-----------------------------------------------------------------------------------------+
         '- Draw the Horizontal Panel split line if needed                                         |
         '-----------------------------------------------------------------------------------------+
         IF HPanelSplit <> 0 AND P = VARPTR(P2) THEN              ' If PANEL mode and Doing P2 Command
            DoPrint (STRING$(@P.PPanelWidth, " "), $$TxtLo, @P.PTop - 1, @P.PLeft)  ' Clear line first
            GRAPHIC LINE (1, ((@P.PTop - 1) * gFontHeight) - 1 - (gFontHeight / 2)) - (gENV.ScrWidth * gFontWidth, ((@P.PTop - 1) * gFontHeight) - 1 - (gFontHeight / 2)), gTxtHiFG  '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do line 2 and the error message                                                        |
         '-----------------------------------------------------------------------------------------+
         DoPrint (STRING$(@P.PPanelWidth, " "), $$TxtLo, @P.PTop + 1, @P.PLeft)  ' Clear message line
         IF ISFALSE gResizeActive AND PPActive = P THEN           ' Don't do messages during a RESIZE or inactive panel
            IF ErrMsgTblC > 0 THEN                                ' If there are messages
               gBandBG = IIF(ErrMsgHigh, %True, %False)           ' Select BG color
               tText = IIF$(ErrMsgTblC > 1, " +", " ") + ErrMsgTop'
               DoPrint (tText, $$Error, @P.PTop + 1, @P.PRight - LEN(tText) + 1) ' Print error message
               IF ErrMsgHigh = %eFail THEN                        ' Errors
                  DoBeep                                          ' Beep on errors
               END IF                                             '
            END IF                                                '
            IF gENV.MacName AND ISNOTNULL(MacName) THEN DoPrint ("Macro(" + MacName + ")", $$Error, @P.PTop + 1, @P.pLeft) ' MacName
            gBandBG = %False                                      ' Set back to normal BG
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Display fixed COLS line if called for                                                  |
         '-----------------------------------------------------------------------------------------+
         IF FCB.Cols THEN                                         '
            @P.PS(3) = 0                                          ' Null data line pointer
            sp = @P.PTop + 2                                      ' Set line for print
            GOSUB DoColsLine                                      ' Go print it
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Loop through text screen lines                                                         |
         '-----------------------------------------------------------------------------------------+
         me.DoRenum                                               ' Do renum if needed
         stp = @P.PTopLine                                        ' Set Screen Text Pointer to current TopScrn setting
         vistop = stp                                             ' Save vistop
         FOR sp = @P.PData1 TO @P.PBottom                         ' Loop for logical Screen data lines
            BGBandEdit(sp)                                        ' Calc banding value
            IF ISTRUE IsLPage(stp) THEN                           ' A =PAGE> line ?
               i = sp: j = @P.PData1                              '
               IF LEFT$(FCB.EOL, 4) = "AUTO" AND FCB.ScrollAmt = "PAGE" AND ISTRUE FCB.PageFlag AND _ ' PAGE mode AUTO processing?
                  sp > @P.PData1 AND _                            ' Not top line
                  ISFALSE FCB.ScrlPageSus THEN                    ' In correct mode?
                  PageSeen = %True                                ' =PAGE> below the top line
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- If below last line                                                                  |
            '--------------------------------------------------------------------------------------+
            IF stp > LastLine  OR ISTRUE PageSeen THEN            ' Past end of dataset or end of Page in PAGE mode?
               @P.PS(sp) = 0                                      ' Null Txt index pointer
               DoPrint (SPACE$(@P.PPanelWidth), $$TxtLo, sp, @P.PLeft)  ' Blank the line on the screen

            '--------------------------------------------------------------------------------------+
            '- Do a file line                                                                      |
            '--------------------------------------------------------------------------------------+
            ELSE                                                  '
               @P.PLastDrawn = sp                                 ' Remember last drawn line
               HideFlag = IIF(IsLXclude(stp + 1) AND IsHideFlag, %True, %False)  ' Set HIDE mode underline

               '-----------------------------------------------------------------------------------+
               '- Base on line type                                                                |
               '-----------------------------------------------------------------------------------+
               IF IsLInvisible(stp) OR _                          ' Show this line at all?
                  (IsLFile(stp) AND IsFileHide) OR _              '
                  (IsLXclude(stp) AND IsHideFlag) THEN            '
                  sp -= 1                                         ' No, keep sp at this screen slot
                  INCR stp                                        ' Move on to the next line
                  ITERATE FOR                                     '

               ELSE                                               '

                  '--------------------------------------------------------------------------------+
                  '- First do the line number area                                                 |
                  '--------------------------------------------------------------------------------+
                  @P.PS(sp) = stp                                 ' Save which L() entry we're showing
                  IF ISFALSE gMacroMode THEN                      ' If not Macro Mode
                     IF IsPTypeMode THEN                          ' If in PType mode all line numbers go Hi
                        FOR i = 1 TO gPTblCount                   ' Update the PT table with screen row
                           IF stp = gPTbl(i).tLin THEN            ' A PT line being displayed
                              IF HideFlag THEN                    ' Underlined or not
                                 DoPrint (RIGHT$(LLNumG(stp), gENV.LinNoSize), $$LnoHiUL, sp, @P.PLeft)  ' Print the Line number
                              ELSE                                '
                                 DoPrint (RIGHT$(LLNumG(stp), gENV.LinNoSize), $$LnoHi, sp, @P.PLeft) ' Print the Line number
                              END IF                              '
                              EXIT FOR                            '
                           END IF                                 '
                        NEXT i                                    '
                     ELSE                                         '
                        IF HideFlag THEN                          ' Underlined or not                                     '
                           DoPrint (RIGHT$(LLNumG(stp), gENV.LinNoSize), $$LnoLoUL, sp, @P.PLeft)  ' Print the Line number
                        ELSE                                      '
                           DoPrint (RIGHT$(LLNumG(stp), gENV.LinNoSize), $$LnoLo, sp, @P.PLeft) ' Print the Line number
                        END IF                                    '
                     END IF                                       '
                     DoPrint(" ", $$TxtLo, sp, @P.PGapCol)        ' Clear pad column
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Now overlay if needed with special data                                       |
                  '--------------------------------------------------------------------------------+
                  IF stp = 1 THEN                                 '
                     u = me.LLCtlGet(stp): v = LLNumG(stp)        '
                                                                  '                                            '
                  END IF                                          '
                  IF me.LLCtlGet(stp) <> LLNumG(stp) THEN         ' A pending line control?
                      IF ISFALSE gMacroMode THEN                  ' If not Macro Mode
                         DoPrint (LEFT$(me.LLCtlGet(stp), gENV.LinNoSize), $$LnoHi, sp, @P.PLeft)  ' Print the Pending
                         IF LTagG(stp) <> $BlankLNo AND L(stp).LLbl <> $BlankLNo THEN _   ' A Label/Tag collision?
                            DoPrint (":", $$TxtLo, sp, @P.PGapCol)   ' Flag the pad column
                      END IF                                      '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Now add the User status                                                       |
                  '--------------------------------------------------------------------------------+
                  IF IsLUser(stp) THEN                            ' A User Line?
                      DoPrint ("|", $$TxtHi, sp, @P.PGapCol)      ' Flag column @P.PGapCol
                  END IF                                          '

'-  DoPrint (format$(L(stp).LMix), $$TxtHi, sp, @P.PGapCol)        ' Uncomment for MIX display during debugging
'-  DoPrint (IIF$(L(stp).PCmd<0, "-",RIGHT$(FORMAT$(L(stp).PCmd, "0000"), 1)), $$TxtHi, sp, @P.PGapCol)

                  IF IsLTop(stp) THEN                             ' Handle types differently
                     tText = STRING$(@P.PDataLen, "*")            '
                     MID$(tText, (@P.PDataLen - 16) \ 2 + 1, 16) = "* Top of Data **"  '
                     DoPrint (tText, $$TxtHi, sp,@P.PDataCol)     '

                  ELSEIF IsLBottom(stp) THEN                      '
                     tText = STRING$(@P.PDataLen, "*")            '
                     MID$(tText, (@P.PDataLen - 16) \ 2 + 1, 16) = " Bottom of Data "  '
                     DoPrint (tText, $$TxtHi, sp, @P.PDataCol)    '

                  ELSEIF IsLInsertLine(stp) THEN                  '
                     DoPrint (me.Window(LTxtG(stp)), $$TxtLo, sp, @P.PDataCol)   '
                     IF PPActive = P THEN visbot = stp            ' Save visbot

                  ELSEIF IsLFile(stp) THEN                        '
                     u = UCASE$(PARSE$(gENV.FileLineFmt, ",", 1)) ' Get LEFT/RIGHT
                     v = TRIM$(PARSE$(gENV.FileLineFmt, ",", 2))  ' Get Pad chars
                     StrUnquote(v)                                ' Remove any quotes
                     IF ISNULL(v) THEN v = " "                    ' Ensure something is there
                     tText = REPEAT$(@P.PDataLen / LEN(v), v)     ' Fill line with pad
                     v = TRIM$(LTxtG(stp))                        ' Get trimmed fn (in case MINLEN used)
                     IF u = "LEFT" THEN                           ' Do LEFT style
                        MID$(tText, 1, LEN(v) + 1) = v + " "      ' Insert filename
                     ELSEIF u = "RIGHT" THEN                      ' Do RIGHT style
                        MID$(tText, @P.PDataLen - LEN(v) - 1, LEN(v) + 2) = " " + v + " " ' Insert filename
                     ELSE                                         ' Do CENTER style
                        MID$(tText, (@P.PDataLen - LEN(v)) / 2, LEN(v) + 2) = " " + v + " "  ' Insert filename
                     END IF                                       '
                     DoPrint (tText, $$LNoHi, sp, @P.PDataCol)    '

                  ELSEIF IsLData(stp) THEN                        '
                     me.DispLine(stp, sp)                         '
                     IF PPActive = P THEN visbot = stp            ' Save visbot

                  ELSEIF IsLCols(stp) THEN                        '
                     GOSUB DoColsLine                             '

                  ELSEIF IsLWord(stp) THEN                        '
                     DoPrint (LSET$(FCB.WordInput, @P.PDataLen), $$TxtHi, sp, @P.PDataCol)   '

                  ELSEIF IsLMark(stp) THEN                        '
                     DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '

                  ELSEIF IsLMask(stp) THEN                        '
                     DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '

                  ELSEIF IsLProf(stp) OR IsLEFT(stp) THEN         '
                     DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '

                  ELSEIF IsLTabs(stp) THEN                        '
                     DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '

                  ELSEIF IsLNote(stp) THEN                        '
                     DoPrint (me.Window(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   '
                     me.MarkReDraw(sp)                            ' Re-draw the MARK lines

                  ELSEIF IsLBounds(stp) THEN                      '
                     DoPrint (me.WindowBnds, $$TxtHi, sp, @P.PDataCol)  '

                  ELSEIF IsLXclude(stp) THEN                      '
                     tText = STRING$(@P.PDataLen, " ")            ' Build the marker line
                     LSET tText = REPEAT$((@P.PDataLen), "-")     '
                     IF LWrk1G(stp) > 999999 THEN                 ' Choose a format
                        u = " <" + FORMAT$(LWrk1G(stp), "00000000") + "> " ' Build the sentence
                     ELSE                                         '
                        u = " < " + FORMAT$(LWrk1G(stp), "000000") + " > " ' Build the sentence
                     END IF                                       '
                     IF LEN(u) + 5 < LEN(tText) THEN              '
                        MID$(tText, (@P.PDataLen - LEN(u)) - 5, LEN(u)) = u   ' Insert into the ---- line
                     ELSE                                         '
                        MID$(tText, (@P.PDataLen - LEN(u)), LEN(u)) = u ' Insert into the ---- line
                     END IF                                       '
                     IF PPActive = P THEN visbot = stp            ' Save visbot
                     DoPrint (tText, $$TxtHi, sp, @P.PDataCol)    '

                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- See if this is the cursor line                                                   |
               '-----------------------------------------------------------------------------------+
               IF sCurPrio > 0 AND ISFALSE CurSet THEN            ' Is there a cursor request not yet done?
                  IF stp = sCurLin THEN                           ' Is this the line?
                     lScrl     = sCurScrl                         ' Fetch the winners data locally
                     lColumn   = L(stp).LCol                      '
                     me.CsrRow = sp + sCurHexl                    ' Yes set cursor on this row
                     IF lColumn = 0 THEN                          ' a LineNum request?
                        me.CsrCol = @P.PLeft                      ' Yes, stuff in column 1
                     ELSE                                         '
                        me.CsrCol = lColumn - @P.POffset + @P.PGapCol   ' Calc column position
                        IF @P.C.CCol < 1 OR @P.C.CCol > @P.PRight THEN me.CsrCol = @P.PDataCol  '
                     END IF                                       '
                     CurSet = %True                               '
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- If HEX mode, do all the extra stuff                                              |
               '-----------------------------------------------------------------------------------+
               IF FCB.HexMode = &4 THEN                           ' If HEX mode, do some more
                  INCR sp                                         ' Next Screen Line
                  IF sp <= @P.PBottom THEN                        ' If still on screen
                     @P.PS(sp) = -1                               ' Mark as Top Hex line
                     @P.PLastDrawn = sp                           ' Adjust LastDrawn
                     IF IsLData(stp) AND ISFALSE IsLInvisible(stp) THEN '
                        DoPrint ($BlankLNo, $$TxtLo, sp, @P.PLeft)   ' Blank Line Number
                        DoPrint (me.WindowHexTop(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   ' Just print upper hex
                     ELSE                                         '
                        DoPrint (SPACE$(gENV.ScrWidth), $$TxtLo, sp, @P.PLeft)   '
                     END IF                                       '
                  END IF                                          '
                  INCR sp                                         ' Next Screen line
                  IF sp <= @P.PBottom THEN                        ' If still on screen
                     @P.PS(sp) = -2                               ' Mark as Bottom Hex line
                     @P.PLastDrawn = sp                           ' Adjust LastDrawn
                     IF IsLData(stp) AND ISFALSE IsLInvisible(stp) THEN '
                        DoPrint ($BlankLNo, $$TxtLo, sp, @P.PLeft)   ' Blank Line Number
                        DoPrint (me.WindowHexBottom(LTxtG(stp)), $$TxtHi, sp, @P.PDataCol)   ' Just print lower hex
                     ELSE                                         '
                        DoPrint (SPACE$(gENV.ScrWidth), $$TxtLo, sp, @P.PLeft)   '
                     END IF                                       '
                  END IF                                          '
                  INCR sp                                         ' Next screen line
                  IF sp <= @P.PBottom THEN                        ' If still on screen
                     @P.PS(sp) = -3                               ' Mark as Dash line
                     @P.PLastDrawn = sp                           ' Adjust LastDrawn
                     IF stp <= LastLine THEN DoPrint (STRING$(gENV.ScrWidth,"-"), $$TxtLo, sp, @P.PLeft) ' Dash line on the screen
                  END IF                                          '
               END IF                                             '
            END IF                                                '
            stp = MIN(stp + 1, UBoundT)                           ' Bump text line
         NEXT sp                                                  ' Bump Screen line

         IF gMacroMode GOTO BailExit                              ' If Macro Mode, leave
         IF P = PPActive THEN                                     ' The active panel?
            me.MarkLineNumb                                       ' Mark the current line number area on the screen
            IF sCurPrio > 0 THEN                                  ' Was this a specified cursor location?
               me.LFlagBitOff(sCurLin, %Cursor)                   '
               L(sCurLin).LCol = 0                                '
               sCurPrio = 0                                       ' Reset for next time
               sCurLin  = 0                                       '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Mark selected text                                                                  |
            '--------------------------------------------------------------------------------------+
            IF IsMarkActive THEN                                  ' Do we have a marked area?
               OffMarkDrawn                                       ' Previous is gone, we just re-drew the screen
               me.MarkScr                                         ' Go re-draw the marked area
            END IF                                                '
            '--------------------------------------------------------------------------------------+
            '- Mark selected Cmd                                                                   |
            '--------------------------------------------------------------------------------------+
            IF IsMiscActive THEN                                  ' Do we have a marked Cmd?
               OffMiscDrawn                                       ' Previous is gone, we just re-drew the screen
               me.MiscMark                                        ' Go re-draw the marked area
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do 'After Track'- if requested                                                         |
         '-----------------------------------------------------------------------------------------+
         IF TrkAfter THEN                                         ' Add After Track if requested
            me.TrkAdd(@P.PTopLine, me.CsrRow, me.CsrCol): TrkAfter = %False   ' Do it and clear flag
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- See if Split mode and loop back for the 2nd panel                                      |
         '-----------------------------------------------------------------------------------------+
         IF (HPanelSplit OR VPanelSplit) AND P = VARPTR(P1) THEN  ' Finished P1
            P = VARPTR(P2)                                        ' Swap to P2
            GOTO DispPanel                                        ' Loop back
         END IF                                                   '

         DrawDone:                                                '
         '-----------------------------------------------------------------------------------------+
         '- Draw the Vertical Panel split line if needed                                           |
         '-----------------------------------------------------------------------------------------+
         IF VPanelSplit <> 0 AND P = VARPTR(P2) THEN              ' If PANEL mode and Doing P2 Command
            FOR i = 1 TO @P.PBottom                               ' Blank the column
               BGBandEdit(i)                                      ' Calc banding value
               DoPrint (" ", $$TxtLo, i, @P.PLeft - 1)            ' Blank it
            NEXT i                                                '
            GRAPHIC LINE ((@P.PLeft - 2) * gFontWidth + (gFontWidth / 2), 1) - ((@P.PLeft- 2) * gFontWidth    + (gFontWidth / 2), (@P.PBottom) * gFontHeight), gTxtHiFG '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do PFK show                                                                            |
         '-----------------------------------------------------------------------------------------+
         IF P = PPActive THEN _                                   ' Doing active panel?
            me.DoPFKShow                                          ' Re-do PFK show

         '-----------------------------------------------------------------------------------------+
         '- Tell system to actually draw it                                                        |
         '-----------------------------------------------------------------------------------------+
         GRAPHIC REDRAW                                           '
         GRAPHIC ATTACH PgHandle, WindowID                        ' Set as the default graphic area
      BailExit:                                                   '
         P = PPActive                                             ' Reset to default active
         IF gCrashLastPrim <> "PA2" AND _                         '
            gCrashLastPrim <> "PA1" THEN me.DoPA2Save             ' Go save a PA2 refresh data
         LastTop = @P.PTopLine                                    ' Save where we are
         IF gDoBeepFlag THEN DoBeepReal                           ' If needed, do a Beep
         ON ERROR GOTO 0                                          '
         MExitMeth                                                '

      '--------------------------------------------------------------------------------------------+
      '- Do special handling of COLS line                                                          |
      '--------------------------------------------------------------------------------------------+
      DoColsLine:                                                 '
         DoPrint (gLnoTextTxt(5) + " ", $$TxtHi, sp, @P.PLeft)    '
         tText = me.WindowCol()                                   ' Build Cols line
         i = 1: j = @P.PDataCol                                   ' Print it the hard way

         DO WHILE i <= LEN(tText)                                 '
            k = INSTR(i, tText, ANY $UpperSpec)                   ' Look for any > 128 chars
            IF k = 0 THEN DoPrint (MID$(tText, i), $$TxtHi, sp, j): EXIT DO   ' No more, remainder is normal
            IF k = i THEN                                         ' Found at start column?
               DoPrint (CHR$(ASC(tText, i) - 128), $$TxtHiUL, sp, j) '
               INCR i: INCR j                                     ' Step over
            ELSE                                                  '
               DoPrint (MID$(tText, i, k - i), $$TxtHi, sp, j)    '
               j += (k - i): i = k                                ' Adjust continue values
            END IF                                                '
         LOOP                                                     '
         RETURN                                                   '
      BailOut:                                                    '
         RESUME BailExit                                          '
      END METHOD                                                  '

      METHOD DLMSearch(arg_DLM  AS STRING, OPTIONAL arg_data AS STRING, OPTIONAL arg_start_col AS LONG, _   '
                       OPTIONAL ret_col  AS LONG,   OPTIONAL ret_len  AS LONG)   '
      '--------------------------------------------------------------------------------------------+
      '- Perform DLM (D-type literal) type search                                                  |
      '--------------------------------------------------------------------------------------------+
      LOCAL Pfx1, Pfx2, Sfx1, Sfx2, StrtCol, lTxt, LeftCol, RightCol AS LONG  '
      STATIC lclPfx, lclSfx AS STRING, lPfx, lSfx AS LONG         '
      REGISTER i AS LONG                                          '
         MEntry                                                   '

         IF ISMISSING(arg_data) THEN                              ' If just arg_DLM, pre-process it
            i = INSTR(arg_DLM, CHR$(0))                           ' Find the split point
            lclPfx = LEFT$(arg_DLM, i - 1)                        ' Extract the Prefix
            lclSfx = MID$(arg_DLM, i + 1)                         ' Extract the Suffix
            lPfx = LEN(lclPfx): lSfx = LEN(lclSfx)                ' Set their lengths
            MExitMeth                                             ' That's all we do for now
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- This is an actual search call                                                          |
         '-----------------------------------------------------------------------------------------+
         ret_col = 0: ret_len = 0                                 ' Default return values

         StrtCol = arg_start_col                                  '
         IF StrtCol < 0 AND StrtCol <> -1 THEN StrtCol += -1      '

         lTxt = LEN(arg_data)                                     '
         LeftCol = PTBL.ColFrom: RightCol = MIN(PTBL.ColTo, lTxt) ' Save margins

         '-----------------------------------------------------------------------------------------+
         '- OK, First lets split by whether we're scanning Fwd. or Bkwd.                           |
         '-----------------------------------------------------------------------------------------+
         IF strtCol > 0 THEN                                      ' If StrtCol positive, we're going forward

            '--------------------------------------------------------------------------------------+
            '- FORWARD: Split by the three basic formats of DLM request                            |
            '--------------------------------------------------------------------------------------+
            IF ISTRUE lPfx AND ISTRUE lSfx THEN                   ' Both Prefix / Suffix present
               GOSUB FwdSetPfx                                    ' Go find the Prefix
               GOSUB FwdSetSfx                                    ' Go find the Suffix
               ret_col = Pfx1: ret_len = (Sfx1 + lSfx) - Pfx1     ' Setup found values
               MExitmeth                                          ' Go back

            ELSEIF ISTRUE(lPfx) AND ISFALSE(lSfx) THEN            ' Prefix but no Suffix
               GOSUB FwdSetPfx                                    ' Go find the Prefix
               IF Pfx2 = 0 THEN                                   ' Prefix only ocurs once
                  ret_col = Pfx1: ret_len = RightCol - Pfx1 + 1   ' Setup found values
               ELSE                                               ' Second Prefix found
                  ret_col = Pfx1: ret_len = Pfx2 - Pfx1           ' Setup found values
               END IF                                             '
               MExitmeth                                          ' Done

            ELSE                                                  ' No Prefix but with Suffix
               Pfx1 = arg_start_col                               ' Fudge Pfx1 column
               GOSUB FwdSetSfx                                    ' Go find the Suffix
               ret_col = Pfx1: ret_len = (Sfx1 + lSfx) - Pfx1     ' Setup found values
               MExitmeth                                          ' Go back

            END IF                                                '

         ELSE                                                     ' StrtCol is negative, we're going backward

            '--------------------------------------------------------------------------------------+
            '- BACKWARD: Split by the three basic formats of DLM request                           |
            '--------------------------------------------------------------------------------------+
            IF ISTRUE lPfx AND ISTRUE lSfx THEN                   ' Both Prefix / Suffix present
               GOSUB BkwdSetSfx                                   ' Go find the Suffix
               GOSUB BkwdSetPfx                                   ' Go find the Prefix
               ret_col = Pfx1: ret_len = (Sfx1 + lSfx) - Pfx1     ' Setup found values
               MExitmeth                                          ' Go back

            ELSEIF ISTRUE(lPfx) AND ISFALSE(lSfx) THEN            ' Prefix but no Suffix
               IF StrtCol = -1 THEN                               ' Ifa new line scan, set to End + 1
                  Sfx1 = RightCol + 1                             ' Default Sfx1 to end of text
               ELSE                                               ' Else
                  Sfx1 = lTxt + StrtCol + 1                       ' Calc where previous found was located
               END IF                                             '
               GOSUB BkwdSetPfx                                   ' Go find the Prefix
               ret_col = Pfx1: ret_len = (Sfx1 - Pfx1)            ' Setup found values
               MExitmeth                                          ' Done

            ELSE                                                  ' No Prefix but with Suffix
               GOSUB BkwdSetSfx                                   ' Go find the Suffix
               IF Sfx2 > 0 THEN                                   ' Was there a 2nd suffix?
                  ret_col = Sfx2 + lSfx                           ' ret_col is 1 to the right of the 2nd suffix
                  ret_len = (Sfx1 + lSfx) - ret_col               ' Set the length
               ELSE                                               ' No second Suffix
                  ret_col = LeftCol                               ' ret_col is the left margin
                  ret_len = (Sfx1 + lSfx) - ret_col               ' Set the length
               END IF                                             '
               MExitmeth                                          ' Go back

            END IF                                                '

         END IF                                                   '

         MExitmeth                                                ' Done

      BkwdSetSfx:                                                 '
         RESET Sfx1, Sfx2                                         '
         Sfx1 = INSTR(Strtcol, arg_data, lclSfx)                  ' See if Suffix is present
         IF Sfx1 = 0 THEN MExitmeth                               ' No, leave with search failed.

         Sfx2 = INSTR(Sfx1 - lTxt - 2, arg_data, lclSfx)          ' Look for a second one (in case)
         RETURN                                                   '

      BkwdSetPfx:                                                 '
         RESET Pfx1, Pfx2                                         '
         Pfx1 = INSTR(IIF(lSfx, Sfx1 - lTxt - 2, StrtCol), arg_data, lclPfx)  ' See if Prefix is present
         IF Pfx1 = 0 THEN MExitmeth                               ' No, leave with search failed.

         Pfx2 = INSTR(Pfx1 - lTxt - 2, arg_data, lclPfx)          ' Look for a second one (in case)
         RETURN                                                   '

      FwdSetPfx:                                                  '
         RESET Pfx1, Pfx2                                         '
         Pfx1 = INSTR(Strtcol, arg_data, lclPfx)                  ' See if Prefix is present
         IF Pfx1 = 0 THEN MExitmeth                               ' No, leave with search failed.

         Pfx2 = INSTR(Pfx1 + lPfx, arg_data, lclPfx)              ' Look for a second one (in case)
         RETURN                                                   '

      FwdSetSfx:                                                  '
         RESET Sfx1, Sfx2                                         '
         Sfx1 = INSTR(Pfx1 + lPfx, arg_data, lclSfx)              ' See if Suffix is present
         IF Sfx1 = 0 THEN MExitmeth                               ' No, leave with search failed.

         Sfx2 = INSTR(Sfx1 + lSfx, arg_data, lclSfx)              ' Look for a second one (in case)
         RETURN                                                   '

      END METHOD                                                  '

      METHOD DoAutoCaps(lno AS LONG) AS STRING                    '
      '--------------------------------------------------------------------------------------------+
      '- Return an AUTOCAP version of a line                                                       |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL sTxt AS STRING, k AS LONG                             '
         sTxt = lTxtG(lno)                                        ' Get the text line
         IF ISFALSE FCB.HiAuto OR ISFALSE IsClrFlag THEN _        ' If colorize not active
            METHOD = sTxt: EXIT METHOD                            ' Return the normal line

         k = LAttrSPtr(lno): j = 1                                ' Get pointer to actual characters
         FOR i = k TO k + ((LEN(sTxt) - 1) * 2) STEP 2            ' Attr by Attr
            IF (PEEK(WORD, i) AND %AttrUC) THEN                   ' An UC position
               MID$(sTxt, j, 1) = uucase(MID$(sTxt, j, 1))        ' Then do it
            ELSEIF (PEEK(WORD, i) AND %AttrLC) THEN               ' An LC position
               MID$(sTxt, j, 1) = llcase(MID$(sTxt, j, 1))        ' Then do it
            END IF                                                '
            INCR j                                                ' Index through sTxt
         NEXT i                                                   '
         METHOD = sTxt                                            ' Pass back the modified line
      END METHOD                                                  '

      METHOD DoBROWSE(i AS LONG)                                  '
      '--------------------------------------------------------------------------------------------+
      '- Pass file to BROWSE                                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL lcmd, cmd, SetProf, SetXForm, RealName AS STRING      '
         RealName = gFMD(i).FullPath                              ' Get the filename
         IF UCASE$(RIGHT$(RealName, 4)) = ".LNK" THEN             ' If this is a Shortcut
            RealName = GetRealNameFromLNK(RealName)               ' Convert .LNK to filenames
            IF ISFOLDER(RealName) THEN                            ' If it's a folder
               me.DoDirDirect(RealName)                           ' Let's swap to it
               EXIT METHOD                                        ' And we're done
            END IF                                                '
         END IF                                                   '
         lcmd = gFMD(i).Cmd                                       ' Save command string
         WHILE lcmd <> ""                                         ' Process lcmd for .profile name
            cmd = GetNextWord(lcmd, %Strip)                       ' Get a word from the command
            IF LEFT$(cmd, 1) = "." THEN SetProf = UUCASE(cmd)     '
            IF LEFT$(cmd, 1) = "/" THEN SetXForm = UUCASE(cmd)    '
         WEND                                                     '
         me.CallTab("BROWSE", $DQ + RealName + $DQ + " " + SetProf + " " + SetXForm)   '
      END METHOD                                                  '

      METHOD  DoDirDown(i AS LONG)                                '
      '--------------------------------------------------------------------------------------------+
      '- Do a Dir Down function                                                                    |
      '--------------------------------------------------------------------------------------------+
         FPath = gFMD(i).FullPath                                 '
         FileListNm = ""                                          ' Kill FileList name
         DoSet(%LoadReq)                                          ' Full refresh
      END METHOD                                                  '

      METHOD  DoDirDirect(Dirname AS STRING)                      '
      '--------------------------------------------------------------------------------------------+
      '- Do a Dir Direct                                                                           |
      '--------------------------------------------------------------------------------------------+
         FPath = Dirname                                          ' Swap to the path
         FileListNm = ""                                          ' Kill FileList name
         DoSet(%LoadReq)                                          ' Full refresh
      END METHOD                                                  '

      METHOD  DoDirUp(i AS LONG)                                  '
      '--------------------------------------------------------------------------------------------+
      '- Do a Dir Up function                                                                      |
      '--------------------------------------------------------------------------------------------+
      LOCAL cmd AS STRING, j AS LONG                              '
         cmd = TRIM$(gFMD(i).DPath)                               '
         IF TRIM$(gFMD(i).FileName) = "..\" THEN                  '
            FPath = cmd                                           '
            FileListNm = ""                                       ' Kill FileList name
            DoSet(%LoadReq)                                       ' Full refresh
            EXIT METHOD                                           '
         ELSE                                                     '
            j = INSTR(-2, cmd, "\")                               ' Find 2nd last \
            IF j <> 0 THEN                                        ' Got one
               FPath = LEFT$(cmd, j)                              ' Cut off the last level
               FileListNm = ""                                    ' Kill FileList name
               DoSet(%LoadReq)                                    ' Full refresh
            END IF                                                ' Else do nothing
         END IF                                                   '
      END METHOD                                                  '

      METHOD DoEDIT(i AS LONG)                                    '
      '--------------------------------------------------------------------------------------------+
      '- Pass file to EDIT                                                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL lcmd, cmd, SetProf, SetMacr, SetXForm, RealName AS STRING   '
         RealName = gFMD(i).FullPath                              ' Get the filename
         IF UCASE$(RIGHT$(RealName, 4)) = ".LNK" THEN             ' If this is a Shortcut
            RealName = GetRealNameFromLNK(RealName)               ' Convert .LNK to filenames
            IF ISFOLDER(RealName) THEN                            ' If it's a folder
               me.DoDirDirect(RealName)                           ' Let's swap to it
               EXIT METHOD                                        ' And we're done
            END IF                                                '
         END IF                                                   '
         lcmd = gFMD(i).Cmd                                       ' Save command string
         WHILE lcmd <> ""                                         ' Process lcmd for .profile name
            cmd = GetNextWord(lcmd, %Strip)                       ' Get a word from the command
            IF LEFT$(cmd, 1) = "." THEN SetProf = UUCASE(cmd)     '
            IF LEFT$(cmd, 1) = "%" THEN SetMacr = UUCASE(cmd)     '
            IF LEFT$(cmd, 1) = "/" THEN SetXForm = UUCASE(cmd)    '
         WEND                                                     '

         IF (gFMD(i).FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY THEN  '
            me.CallTab("VIEW", $DQ + RealName + $DQ + " FORCE " + SetProf + " " + SetMacr + " " + SetXForm) '
         ELSE                                                     '
            me.CallTab("EDIT", $DQ + RealName + $DQ + " " + SetProf + " " + SetMacr + " " + SetXForm) '
         END IF                                                   '

      END METHOD                                                  '

      METHOD DoIEDIT(i AS LONG)                                   '
      '--------------------------------------------------------------------------------------------+
      '- Pass file to IEDIT                                                                        |
      '--------------------------------------------------------------------------------------------+
      LOCAL lcmd, cmd, RealName AS STRING                         '
         RealName = gFMD(i).FullPath                              ' Get the filename
         IF UCASE$(RIGHT$(RealName, 4)) = ".LNK" THEN             ' If this is a Shortcut
            RealName = GetRealNameFromLNK(RealName)               ' Convert .LNK to filenames
         END IF                                                   '
         me.CallTab("IEDIT", $DQ + RealName + $DQ)                '
      END METHOD                                                  '

      METHOD DoOpen(i AS LONG, oper AS STRING)                    '
      '--------------------------------------------------------------------------------------------+
      '- Pass file to Open                                                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL lcmd, cmd, SetProf, RealName AS STRING                '
         RealName = gFMD(i).FullPath                              ' Get the filename
         IF UCASE$(RIGHT$(RealName, 4)) = ".LNK" THEN             ' If this is a Shortcut
            RealName = GetRealNameFromLNK(RealName)               ' Convert .LNK to filenames
            IF ISFOLDER(RealName) THEN                            ' If it's a folder
               me.DoDirDirect(RealName)                           ' Let's swap to it
               EXIT METHOD                                        ' And we're done
            END IF                                                '
         END IF                                                   '
         lcmd = gFMD(i).Cmd                                       ' Save command string
         WHILE lcmd <> ""                                         ' Process lcmd for .profile name
            cmd = GetNextWord(lcmd, %Strip)                       ' Get a word from the command
            IF LEFT$(cmd, 1) = "." THEN SetProf = UUCASE(cmd)     '
         WEND                                                     '
         me.CallTab(oper, $DQ + RealName + $DQ + " " + SetProf)   '
      END METHOD                                                  '

      METHOD DoPA2Load                                            '
      '--------------------------------------------------------------------------------------------+
      '- Restore what's needed for a PA2                                                           |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         '-----------------------------------------------------------------------------------------+
                                                                  ' Loop through S() and restore what's needed                                              |
         '-----------------------------------------------------------------------------------------+
         IF IsFMTab THEN                                          ' If FM Tab, do it differently
            FOR i = 1 TO gFMDCtr                                  ' Clear any line commands
               gFMD(i).Cmd = " "                                  '
            NEXT i                                                '
            pCommand = " "                                        ' Clear pCommand
            FPath = LFPath                                        ' Restore previous criteria
            FMask = LFMask                                        '
            FileListNm = LFileListNm                              '
            LastTop = 0: DoSet(%LoadReq)                          ' Kill position and reload

         ELSE                                                     ' Do it the Edit way
            IF IsPTypeMode THEN TP.ErrMsgAdd(%eFail, "PA2 is not available in PowerType mode"): EXIT METHOD '
            pCommand = " "                                        ' Clear pCommand
            SWAP WordInput, PA2Word                               ' Restore the pseudo lines
            SWAP MarkLine, PA2Mark                                '
            SWAP MaskLine, PA2Mask                                '
            SWAP TabsLine, PA2Tabs                                '
            SWAP BndText, PA2Bnds                                 '
            FOR i = 1 TO 300                                      ' Scan screen table
               IF @P.PS(i) > 0 THEN                               ' If line has been used
                  j = @P.PS(i)                                    ' Get the line index
                  IF IsLData(j) THEN                              ' And this is a data line
                     SWAP L(j).@LTxt, ST(i)                       ' Put stuff back
                     SWAP L(j).@LAttr, SW(i)                      '
                  END IF                                          '
               END IF                                             '
            NEXT i                                                '
            me.ResetFunc(%ResetCommand)                           ' Restore line command area
            PA2Word = WordInput                                   ' Save this new set
            PA2Mark = MarkLine                                    '
            PA2Mask = MaskLine                                    '
            PA2Tabs = TabsLine                                    '
            PA2BNDS = BndText                                     '
            FOR i = 1 TO 300                                      ' Scan screen table
               IF @P.PS(i) > 0 THEN                               ' If line has been used
                  j = @P.PS(i)                                    ' Get the line index
                  IF IsLData(j) THEN                              ' And this is a data line
                     ST(i) = L(j).@LTxt                           ' Put stuff back
                     SW(i) = L(j).@LAttr                          '
                  END IF                                          '
               END IF                                             '
            NEXT i                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD DoPA2Save                                            '
      '--------------------------------------------------------------------------------------------+
      '- Save what's needed for a PA2 restore                                                      |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         '-----------------------------------------------------------------------------------------+
         '- Loop through S() and save what's needed                                                |
         '-----------------------------------------------------------------------------------------+
         PA2Word = WordInput                                      ' Save the pseudo lines
         PA2Mark = MarkLine                                       '
         PA2Mask = MaskLine                                       '
         PA2Tabs = TabsLine                                       '
         PA2Bnds = BndText                                        '
         FOR i = 1 TO 300                                         ' Scan screen table
            IF @P.PS(i) > 0 THEN                                  ' If line has been used
               j = @P.PS(i)                                       ' Get the line index
               IF IsLData(j) THEN                                 ' And this is a data line
                  ST(i) = LTxtG(j)                                ' Save the text
                  SW(i) = LAttrG(j)                               ' Save the attr
               END IF                                             '
            END IF                                                '
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD DoVIEW(i AS LONG)                                    '
      '--------------------------------------------------------------------------------------------+
      '- Pass file to VIEW                                                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL lcmd, cmd, SetProf, SetMacr, SetXForm, RealName AS STRING   '
         RealName = gFMD(i).FullPath                              ' Get the filename
         IF UCASE$(RIGHT$(RealName, 4)) = ".LNK" THEN             ' If this is a Shortcut
            RealName = GetRealNameFromLNK(RealName)               ' Convert .LNK to filenames
            IF ISFOLDER(RealName) THEN                            ' If it's a folder
               me.DoDirDirect(RealName)                           ' Let's swap to it
               EXIT METHOD                                        ' And we're done
            END IF                                                '
         END IF                                                   '
         lcmd = gFMD(i).Cmd                                       ' Save command string
         WHILE lcmd <> ""                                         ' Process lcmd for .profile name
            cmd = GetNextWord(lcmd, %Strip)                       ' Get a word from the command
            IF LEFT$(cmd, 1) = "." THEN SetProf = UUCASE(cmd)     '
            IF LEFT$(cmd, 1) = "%" THEN SetMacr = UUCASE(cmd)     '
            IF LEFT$(cmd, 1) = "/" THEN SetXForm = UUCASE(cmd)    '
         WEND                                                     '
         me.CallTab("VIEW", $DQ + RealName + $DQ + " " + SetProf + " " + SetMacr + " " + SetXForm) '
      END METHOD                                                  '

      METHOD  FileAbbrev(fnn AS STRING, BYVAL dl AS LONG) AS STRING  '
      '--------------------------------------------------------------------------------------------+
      '- Abbreviate a filename to specified length                                                 |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF$(LEN(Fnn) - Dl < 1, LSET$(fnn, Dl), LEFT$(fnn, (Dl - 3) \ 3) + "..." & RIGHT$(fnn, ((Dl - 3) * 2) \ 3)) '
      END METHOD                                                  '

      METHOD HandleMinMax()                                       '
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         RESET HandleMin, HandleMax                               ' Reset limits
         FOR i = 1 TO LastLine                                    ' Loop thru file
            j = TP.LHndlGet(i)                                    ' Get any handle
            IF j THEN                                             ' Do we have a handle?
               HandleMin = IIF(HandleMin = 0, j, HandleMin)       ' Handle zero case
               HandleMax = IIF(HandleMax = 0, j, HandleMax)       ' Handle zero case
               HandleMin = MIN(HandleMin, j)                      ' Set the min max
               HandleMax = MAX(HandleMax, j)                      '
            END IF                                                '
         NEXT i                                                   '
      END METHOD                                                  '

      METHOD IncAFSize()                                          '
         INCR gFMDCtr                                             '
         IF gFMDCtr > UBOUND(gFMD()) THEN                         ' Keep gFMRQList big enough
            REDIM PRESERVE gFMD(1 TO 2 * gFMDCtr) AS GLOBAL iFMData  ' Double it
         END IF                                                   '
         LET gFMD(gFMDCtr) = CLASS "cFMData"                      ' Allocate an Object
         gFMD(gFMDCtr).PSeq = gFMDCtr                             ' Save physical sequence it was added as
      END METHOD                                                  '

      METHOD IncRQSize()                                          '
         INCR gFMRQCount                                          '
         IF gFMRQCount > UBOUND(gFMRQList()) THEN                 ' Keep gFMRQList big enough
            REDIM PRESERVE gFMRQList(1 TO 2 * gFMRQCount) AS GLOBAL STRING ' Double it
         END IF                                                   '
      END METHOD                                                  '

      METHOD IncRXSize()                                          '
         INCR gFMRXCount                                          '
         IF gFMRXCount > UBOUND(gFMRXList()) THEN                 ' Keep gFMRXList big enough
            REDIM PRESERVE gFMRXList(1 TO 2 * gFMRXCount) AS GLOBAL STRING ' Double it
         END IF                                                   '
      END METHOD                                                  '

      METHOD IsAFDup(fn AS STRING) AS LONG                        '
      '--------------------------------------------------------------------------------------------+
      '- See if a filename is already in the gFMD array                                            |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
         IF gFMRQCount > 1 THEN                                   ' If > 1 request, check for DUPS
            FOR i = 1 TO gFMDCtr                                  ' Spin through the table
               IF fn = gFMD(i).FullPath THEN METHOD = %True: EXIT FOR   '
            NEXT i                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD MacOverlap(fname AS STRING)                          '
      '--------------------------------------------------------------------------------------------+
      '- Issue warning if possible macro/command overlap                                           |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j AS LONG, MName, MPath, fn, Ctype AS STRING       '
         fn = UCASE$(fname)                                       ' UC filename
         IF MacWarn THEN EXIT METHOD                              ' Already warned, don't harass the user
         IF PATHNAME$(EXTN, fn) <> ".MACRO" THEN EXIT METHOD      ' Same if not a macro
         MName = PATHNAME$(NAME, fn)                              ' Get the macro name
         MPath = PATHNAME$(PATH, fn)                              ' Get the Path for the save
         IF MPath <> UCASE$(gENV.HomeData + "MACROS\") THEN EXIT METHOD ' Exit if not primary MACLIB

         '-----------------------------------------------------------------------------------------+
         '- OK, Possible, match against the various command tables                                 |
         '-----------------------------------------------------------------------------------------+
         IF gPCmdT.GetCmdIX(MName) THEN CType = "P"               ' It matches a Primary command
         IF gLCmdT.GetCmdIX(MName) THEN CType += "L"              ' It matches an Edit Line command
         ARRAY SCAN gFMLCmdTable() FOR UBOUND(gFMLCmdTable()), FROM 1 TO 8, COLLATE UCASE, =LSET$(MName, 8), TO i '
         IF i <> 0 THEN CType += "F"                              ' FM Line cmd found
         IF ISNULL(CType) THEN EXIT METHOD                        ' Nothing? No message
         MsgWarn:                                                 '
         SELECT CASE AS CONST$ CType                              ' Build the message
            CASE "P"   : CType = "Primary Command"                '
            CASE "L"   : CType = "Edit Line Command"              '
            CASE "F"   : CType = "FM Line Command"                '
            CASE "PL"  : CType = "Primary and Edit Line Commands" '
            CASE "PF"  : CType = "Primary and FM Line Commands"   '
            CASE "PLF" : CType = "Primary, Edit Line & FM Line Commands"   '
            CASE "LF"  : CType = "Edit Line & FM Line Commands"   '
         END SELECT                                               '
         KbdPopSave                                               '
         MyMsgBox("|RWarning: |BThe |K" + Mname + "|B macro will override" + $CRLF + _ '
                  "                the same named |K" + CType + "|B" + $CRLF + _ '
                  "                Be sure this is what you want.", + _ '
                  %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "Macro override warning") '
         KbdPopRestore                                            '
         MacWarn = %True                                          ' So we don't keep doing it
      END METHOD                                                  '

      METHOD MacSubst(mline AS STRING) AS LONG                    '
      '--------------------------------------------------------------------------------------------+
      '- Do macro substitution                                                                     |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j AS LONG, fn, lsubarg, lclSet, TX, MOp AS STRING  '
      DIM Dops(1 TO 9) AS STRING                                  '
         '-----------------------------------------------------------------------------------------+
         '- If gDosOperands present, break into sub-parts                                          |
         '-----------------------------------------------------------------------------------------+
         IF ISNOTNULL(gDosOperands) THEN                          ' Break out gDosOperands?
            TX = gDosOperands                                     ' Get working copy
            DOps(1) = GetNextWord(TX, %Strip)                     ' Get an Operand
            DOps(2) = GetNextWord(TX, %Strip)                     '
            DOps(3) = GetNextWord(TX, %Strip)                     '
            DOps(4) = GetNextWord(TX, %Strip)                     '
            DOps(5) = GetNextWord(TX, %Strip)                     '
            DOps(6) = GetNextWord(TX, %Strip)                     '
            DOps(7) = GetNextWord(TX, %Strip)                     '
            DOps(8) = GetNextWord(TX, %Strip)                     '
            DOps(9) = TX                                          '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Setup Subarg and full filename                                                         |
         '-----------------------------------------------------------------------------------------+
         lsubarg = IIF$(ISNULL(FCB.SubArg), "OFF", FCB.SubArg)    '
         fn = TP.FCB_.FilePath                                    '

         '-----------------------------------------------------------------------------------------+
         '- If any Key arguments                                                                   |
         '-----------------------------------------------------------------------------------------+
         i = INSTR(UUCASE(mline), "~K"): IF i = 0 THEN i = INSTR(UUCASE(mline), "^K")  ' See if the hard one is present
         IF i THEN                                                ' Lots of extra stuff here
           IF MID$(mline, i + 2, 1) <> "(" OR INSTR(i + 2, mline, ")") = 0 THEN  '
              METHOD = %True: EXIT METHOD                         ' Sorry
           END IF                                                 '
           IF DoKMacroSubst(mline) THEN METHOD = %True: EXIT METHOD  ' Pass off the hard work (DoKMacroSubst does ALL ~K in line)
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If any Set arguments                                                                   |
         '-----------------------------------------------------------------------------------------+
         i = INSTR(UUCASE(mline), "~S("): IF i = 0 THEN i = INSTR(UUCASE(mline), "^S(")   ' See if the hard one is present
         IF i THEN                                                ' Lots of extra stuff here
            IF MID$(mline, i + 2, 1) <> "(" OR INSTR(i + 2, mline, ")") = 0 THEN '
               METHOD = %True: EXIT METHOD                        ' Sorry
            END IF                                                '
            IF DoSMacroSubst(mline) THEN METHOD = %True: EXIT METHOD ' Pass off the hard work (DoSMacroSubst does all ~S in line)
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If any Environment arguments                                                           |
         '-----------------------------------------------------------------------------------------+
         i = INSTR(UUCASE(mline), "~V("): IF i = 0 THEN i = INSTR(UUCASE(mline), "^V(")   ' See if the hard one is present
         IF i THEN                                                ' Lots of extra stuff here
            IF MID$(mline, i + 2, 1) <> "(" OR INSTR(i + 2, mline, ")") = 0 THEN '
               METHOD = %True: EXIT METHOD                        ' Sorry
            END IF                                                '
            IF DoVMacroSubst(mline) THEN METHOD = %True: EXIT METHOD ' Pass off the hard work (sVSet does all ~V in line)
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If any SET values, get lclSet built                                                    |
         '-----------------------------------------------------------------------------------------+

         REPLACE "^#" WITH gPageNumber IN mline                   ' Do Uppercase variation
         REPLACE "^1" WITH UUCASE(Dops(1)) IN mline               '
         REPLACE "^2" WITH UUCASE(Dops(2)) IN mline               '
         REPLACE "^3" WITH UUCASE(Dops(3)) IN mline               '
         REPLACE "^4" WITH UUCASE(Dops(4)) IN mline               '
         REPLACE "^5" WITH UUCASE(Dops(5)) IN mline               '
         REPLACE "^6" WITH UUCASE(Dops(6)) IN mline               '
         REPLACE "^7" WITH UUCASE(Dops(7)) IN mline               '
         REPLACE "^8" WITH UUCASE(Dops(8)) IN mline               '
         REPLACE "^9" WITH UUCASE(Dops(9)) IN mline               '
         REPLACE "^a" WITH UUCASE(gDosOperands) IN mline          '
         REPLACE "^A" WITH UUCASE(gDosOperands) IN mline          '
         REPLACE "^c" WITH UUCASE(gENV.HomeFolder) IN mline       '
         REPLACE "^C" WITH UUCASE(gENV.HomeFolder) IN mline       '
         REPLACE "^d" WITH UUCASE(TP.FCB_.Date) IN mline          '
         REPLACE "^D" WITH UUCASE(TP.FCB_.Date) IN mline          '
         REPLACE "^e" WITH UUCASE(gENV.EXEPath) IN mline          '
         REPLACE "^E" WITH UUCASE(gENV.EXEPath) IN mline          '
         REPLACE "^f" WITH UUCASE(TP.FCB_.FilePath) IN mline      '
         REPLACE "^F" WITH UUCASE(TP.FCB_.Base) IN mline          '
         REPLACE "^i" WITH UUCASE(gSubmitFile) IN mline           '
         REPLACE "^I" WITH UUCASE(gSubmitFile) IN mline           '
         REPLACE "^j" WITH UUCASE(gJobID) IN mline                '
         REPLACE "^J" WITH UUCASE(gJobID) IN mline                '
         REPLACE "^l" WITH UUCASE(CursLine) IN mline              '
         REPLACE "^L" WITH UUCASE(CursLine) IN mline              '
         REPLACE "^m" WITH UUCASE(MOp) IN mline                   '
         REPLACE "^M" WITH UUCASE(MOp) IN mline                   '
         REPLACE "^n" WITH UUCASE(fn) IN mline                    '
         REPLACE "^N" WITH UUCASE(fn) IN mline                    '
         REPLACE "^p" WITH UUCASE(TP.FCB_.Path) IN mline          '
         REPLACE "^P" WITH UUCASE(TP.FCB_.Path) IN mline          '
         REPLACE "^r" WITH UUCASE(gResultFile) IN mline           '
         REPLACE "^R" WITH UUCASE(gResultFile) IN mline           '
         REPLACE "^t" WITH UUCASE(TP.FCB_.Time) IN mline          '
         REPLACE "^T" WITH UUCASE(TP.FCB_.Time) IN mline          '
         REPLACE "^w" WITH UUCASE(CursWord) IN mline              '
         REPLACE "^W" WITH UUCASE(CursWord) IN mline              '
         REPLACE "^x" WITH UUCASE(TP.FCB_.Extn) IN mline          '
         REPLACE "^X" WITH UUCASE(TP.FCB_.Extn) IN mline          '
         REPLACE "^z" WITH UUCASE(lsubarg) IN mline               '
         REPLACE "^Z" WITH UUCASE(lsubarg) IN mline               '
         REPLACE "~#" WITH gPageNumber IN mline                   ' Do Lowercase variation
         REPLACE "~1" WITH Dops(1) IN mline                       '
         REPLACE "~2" WITH Dops(2) IN mline                       '
         REPLACE "~3" WITH Dops(3) IN mline                       '
         REPLACE "~4" WITH Dops(4) IN mline                       '
         REPLACE "~5" WITH Dops(5) IN mline                       '
         REPLACE "~6" WITH Dops(6) IN mline                       '
         REPLACE "~7" WITH Dops(7) IN mline                       '
         REPLACE "~8" WITH Dops(8) IN mline                       '
         REPLACE "~9" WITH Dops(9) IN mline                       '
         REPLACE "~a" WITH gDosOperands IN mline                  '
         REPLACE "~A" WITH gDosOperands IN mline                  '
         REPLACE "~c" WITH gENV.HomeFolder IN mline               '
         REPLACE "~C" WITH gENV.HomeFolder IN mline               '
         REPLACE "~d" WITH TP.FCB_.Date IN mline                  '
         REPLACE "~D" WITH TP.FCB_.Date IN mline                  '
         REPLACE "~e" WITH gENV.EXEPath IN mline                  '
         REPLACE "~E" WITH gENV.EXEPath IN mline                  '
         REPLACE "~f" WITH TP.FCB_.Base IN mline                  '
         REPLACE "~F" WITH TP.FCB_.Base IN mline                  '
         REPLACE "~i" WITH gSubmitFile IN mline                   '
         REPLACE "~I" WITH gSubmitFile IN mline                   '
         REPLACE "~j" WITH gJobID IN mline                        '
         REPLACE "~J" WITH gJobID IN mline                        '
         REPLACE "~l" WITH CursLine IN mline                      '
         REPLACE "~L" WITH CursLine IN mline                      '
         REPLACE "~n" WITH fn IN mline                            '
         REPLACE "~N" WITH fn IN mline                            '
         REPLACE "~p" WITH TP.FCB_.Path IN mline                  '
         REPLACE "~P" WITH TP.FCB_.Path IN mline                  '
         REPLACE "~r" WITH gResultFile IN mline                   '
         REPLACE "~R" WITH gResultFile IN mline                   '
         REPLACE "~t" WITH TP.FCB_.Time IN mline                  '
         REPLACE "~T" WITH TP.FCB_.Time IN mline                  '
         REPLACE "~w" WITH CursWord IN mline                      '
         REPLACE "~W" WITH CursWord IN mline                      '
         REPLACE "~x" WITH TP.FCB_.Extn IN mline                  '
         REPLACE "~X" WITH TP.FCB_.Extn IN mline                  '
         REPLACE "~z" WITH lsubarg IN mline                       '
         REPLACE "~Z" WITH lsubarg IN mline                       '
         METHOD = %False                                          ' Say we're OK
      END METHOD                                                  '

      METHOD MarkGL() AS LONG: METHOD = MarkRect.Left:   END METHOD  '
      METHOD MarkGR() AS LONG: METHOD = MarkRect.Right:  END METHOD  '
      METHOD MarkGT() AS LONG: METHOD = MarkRect.Top:    END METHOD  '
      METHOD MarkGB() AS LONG: METHOD = MarkRect.Bottom: END METHOD  '
      METHOD MarkSL(v AS LONG): MarkRect.Left = v:       END METHOD  '
      METHOD MarkSR(v AS LONG): MarkRect.Right = v:      END METHOD  '
      METHOD MarkST(v AS LONG): MarkRect.Top = v:        END METHOD  '
      METHOD MarkSB(v AS LONG): MarkRect.Bottom = v:     END METHOD  '

      METHOD MiscGL() AS LONG: METHOD = MiscRect.Left:   END METHOD  '
      METHOD MiscGR() AS LONG: METHOD = MiscRect.Right:  END METHOD  '
      METHOD MiscGT() AS LONG: METHOD = MiscRect.Top:    END METHOD  '
      METHOD MiscGB() AS LONG: METHOD = MiscRect.Bottom: END METHOD  '
      METHOD MiscSL(v AS LONG): MiscRect.Left = v:       END METHOD  '
      METHOD MiscSR(v AS LONG): MiscRect.Right = v:      END METHOD  '
      METHOD MiscST(v AS LONG): MiscRect.Top = v:        END METHOD  '
      METHOD MiscSB(v AS LONG): MiscRect.Bottom = v:     END METHOD  '

      METHOD MarkExtend(trow AS LONG, tcol AS LONG, StartRow AS LONG, StartCol AS LONG)   '
      '--------------------------------------------------------------------------------------------+
      '- See if a mouse mark area is to be extended                                                |
      '--------------------------------------------------------------------------------------------+
      DIM KeyStateArray(0 TO 255) AS BYTE                         ' Keyboard stats

      IF IsMarkActive THEN                                        '
         IF ISFALSE (tCol > @P.PGapCol AND tCol <= @p.PRight AND tRow >= @P.PData1 AND tRow <= @P.PBottom) THEN ' Outside true text area?
            me.MarkKill                                           ' Kill it
            EXIT METHOD                                           '
         END IF                                                   '
         IF IsLTop(@P.PS(tRow)) OR IsLBottom(@P.PS(tRow)) THEN EXIT METHOD ' Never include Top/Bottom lines
         tCol = tCol + @P.POffset - @P.PGapCol                    ' Convert to text column
         GetKeyboardState(BYVAL VARPTR(KeyStateArray(0)))         ' Get all key states etc
         tRow = @P.PS(tRow)                                       ' Get text line
         IF (LFlagG(tRow) AND (%Tabs OR %Word OR %Mark OR %Mask OR %Prof OR %EFT)) <> 0 THEN DoBeep: EXIT METHOD  '

         '-----------------------------------------------------------------------------------------+
         '- Don't let MARK overlap with SWAP area                                                  |
         '-----------------------------------------------------------------------------------------+
         IF IsSwapActive THEN                                     ' Prevent Swap overlap
            IF trow = SwapSLin THEN                               '
               IF tcol >= SwapSCol AND tCol <= SwapECol THEN EXIT METHOD   '
               IF MarkRect.Left <= SwapSCol AND tCol >= SwapSCol THEN EXIT METHOD   '
               IF MarkRect.Left >= SwapECol AND tCol <= SwapECol THEN EXIT METHOD   '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Set the MARK boundaries                                                                |
         '-----------------------------------------------------------------------------------------+
         IF tCol > StartCol THEN                                  ' Build SlectRC RECT structure appropriately
            MarkRect.Left = StartCol                              '
            MarkRect.Right = tCol                                 '
         ELSE                                                     '
            MarkRect.Left = tCol                                  '
            MarkRect.Right = StartCol                             '
         END IF                                                   '
         IF tRow <= StartRow THEN                                 '
            MarkRect.Top = tRow                                   '
            IF ISFALSE IsSwapActive THEN MarkRect.Bottom = StartRow  '
         ELSE                                                     '
            MarkRect.Top = StartRow                               '
            IF ISFALSE IsSwapActive THEN MarkRect.Bottom = tRow   '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Get the marked area drawn                                                              |
         '-----------------------------------------------------------------------------------------+
         me.MarkScr                                               ' Try drawing a hi-lite

      '--------------------------------------------------------------------------------------------+
      '- Check if the Cmd line hi-light version                                                    |
      '--------------------------------------------------------------------------------------------+
      ELSEIF IsMiscActive THEN                                    ' Misc highlight?
         IF ISFALSE (tCOL >= @P.PCmdCol AND tCOL < @P.PScrHdr) OR ISNULL(TRIM$(pCommand)) THEN  ' Outside the cmd area?
            me.MarkKill                                           ' Kill it
            EXIT METHOD                                           '
         END IF                                                   '
         tCol = tCol - @P.PCmdCol + 1                             ' Convert to cmd column
         tRow = @P.PTop                                           ' Always row 1

         '-----------------------------------------------------------------------------------------+
         '- Set the CmdM boundaries                                                                |
         '-----------------------------------------------------------------------------------------+
         MiscRect.Left = IIF(tCol > StartCol, StartCol, tCol)     ' Set appropriately
         MiscRect.Right = IIF(tCol > StartCol, tCol, StartCol)    '

         '-----------------------------------------------------------------------------------------+
         '- Get the marked area drawn                                                              |
         '-----------------------------------------------------------------------------------------+
         me.MiscMark                                              ' Try drawing a hi-lite
      END IF                                                      '
      END METHOD                                                  '

      METHOD   MarkFMLineNumb()                                   '
      '--------------------------------------------------------------------------------------------+
      '- Mark the line number where the cursor is                                                  |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER lr AS LONG                                         '
      LOCAL tText, t AS STRING, lclAttr AS WSTRING                '
         MEntry                                                   '

         lr = @P.C.CRow                                           ' Copy Cursor row
         IF lr < gFM_Top_File_Line THEN lr = 0                    ' Only do if below headers
         IF lr <> FMMarkdSLin AND ISTRUE FMMarkdSLin THEN         ' Clear any previous marked line
            IF LNKRealName <> "" THEN                             ' If a LNK displayed
               LNKRealName = ""                                   ' Clear it
               DoStatusBar($AllStatusBarBoxes)                    ' re-Do the StatusBar box
            END IF                                                '
            gBandBG = %False                                      ' remove banding
            IF ISNOTNULL(FileListNm) THEN DoPrint (LSET$("*", gFM_Crit_Size), $$TxtLo, gFM_Mask_Line, gFM_Mask_Left) '
            BGBandEdit(FMMarkdSLin)                               ' Calc BG value for banding

            IF ISNOTNULL (TRIM$(gFMD(FMMarkdALin).Message)) THEN  ' Is there a message waiting?
               DoPrint (LSET$(gFMD(FMMarkdALin).Message, gENV.ScrWidth), $$Error, FMMarkdSLin, gFM_Head_Name_Left)   '
            ELSE                                                  ' Else print the real first field
               tText = gFMD(FMMarkdALin).PrtField(gFMC(1).CField, lclAttr, 1) ' No, get the text and its attribute
               IF gFMC(1).CField = "NAME" OR gFMC(1).CField = "PATH" THEN  '
                  tText = TP.FileAbbrev(tText, gFMC(1).CSize)     ' Abbreviate it as needed
               END IF                                             '
               DoPrint(LSET$(tText, gFMC(1).CSize + 2), lclAttr, FMMarkdSLin, gFMC(1).CPos)  ' Print FileName
            END IF                                                '
            FMMarkdSLin = 0                                       '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Now see if a new line to mark                                                          |
         '-----------------------------------------------------------------------------------------+
         IF lr = 0 OR lr >= gFM_Top_File_Line + gFMDCtr - @P.PTopLine OR lr < gFM_Top_File_Line OR lr > gFM_Top_File_Line + gFM_List_Height - 1 THEN  '
            MExitMeth                                             '
         END IF                                                   '

         i = lr - gFM_Top_File_Line + @P.PTopLine                 ' Set i to gFMD index
         LNKRealName = ""                                         ' Null LNK name
         IF UCASE$(RIGHT$(TRIM$(gFMD(i).FileName), 4)) = ".LNK" THEN ' Get realname if a Shortcut
            t = gFMD(i).FullPath                                  '
            LNKRealName = GetRealNameFromLNK(t)                   '
            DoStatusBar($AllStatusBarBoxes)                       ' re-Do the StatusBar box
         END IF                                                   '

         IF ISNOTNULL (TRIM$(gFMD(i).Message)) THEN               ' Is there a message waiting?
            DoPrint (LSET$(gFMD(i).Message, gENV.ScrWidth), $$Error, lr, gFM_Head_Name_Left) '

         ELSE                                                     ' Else print the real filename

            '--------------------------------------------------------------------------------------+
            '- First print Fullname on the Mask Line                                               |
            '--------------------------------------------------------------------------------------+
            gBandBG = %False                                      ' remove banding
            DoPrint (LSET$(gFMD(i).FullPath, gFM_Crit_Size), $$TxtLo, gFM_Mask_Line, gFM_Mask_Left)   '
            BGBandEdit(lr)                                        ' Calc BG value for banding

            tText = gFMD(i).PrtField(gFMC(1).CField, lclAttr, 1)  ' Get the text and its attribute
            IF gFMC(1).CField = "NAME" OR gFMC(1).CField = "PATH" THEN  '
                  tText = TP.FileAbbrev(tText, gFMC(1).CSize)     ' Abbreviate it as needed
            END IF                                                '
            IF TP.DefSortCol = 1 THEN lclAttr = $$TxtLo ELSE lclAttr = $$TxtHi   '
            DoPrint(LSET$(tText, gFMC(1).CSize + 2), lclAttr, lr, gFMC(1).CPos)  ' Print FileName
            FMMarkdSLin = lr                                      ' Save cursor line
            FMMarkdALin = i                                       ' Save FMFiles index being highlighted
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD MarkLineNumb()                                       '
      '--------------------------------------------------------------------------------------------+
      '- Mark the line number where the cursor is                                                  |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER lrow AS LONG                                       '
      LOCAL lclScheme AS WSTRING                                  '
         MEntry                                                   '
         IF IsFMTab THEN me.MarkFMLineNumb: MExitMeth             ' Pass off the FM style quickly
         lrow = @P.C.CRow                                         ' Copy Cursor row
         IF lrow >= @P.PData1 THEN                                ' Only do if below headers
            IF @P.PS(lrow) < 0 THEN lrow = lrow - ABS(@P.PS(lrow))   '
         ELSE                                                     '
            lrow = 0                                              ' Force to zero
         END IF                                                   '
         IF @P.PS(lrow) <> 0 AND @P.PS(lrow) = @P.PLastCleard THEN MExitMeth  ' Skip if typing in a '''''' row
         BGBandEdit(@P.PMarkLine)                                 ' Calc banding value of last row marked

         IF lrow <> @P.PMarkLine AND ISTRUE @P.PMarkLine THEN                       ' New Lno and an old one to clear?
            IF @P.PS(@P.PMarkLine) <> 0 THEN i = me.SGet(@P.PMarkLine)              ' Get IX of real data line if still on screen
            lclScheme = IIF$(IsLXclude(i + 1) AND IsHideFlag, $$LnoHiUL, $$LnoHi)   ' Set HIDE mode underline
            IF me.LLCtlGet(i) <> LLNumG(i) OR _                                     ' A pending line control OR ?
               L(i).LLbl <> $BlankLNo OR LTagG(i) <> $BlankLNo OR _                 ' A label or Tag?
               ISTRUE (LFlagG(i) AND (%Top OR %Bottom OR %Word OR %Mark OR %Mask OR %Prof OR %Tabs OR %File OR %Cols OR %EQChange OR %Bounds OR %EFT)) THEN ' or special line type
               IF LTagG(i) <> $BlankLNo AND L(i).LLbl <> $BlankLNo THEN             ' A Label/Tag collision?
                  DoPrint (LEFT$(me.LLCtlGet(i), gENV.LinNoSize), lclScheme, @P.PMarkLine, @P.PLeft)  ' Print the Pending
                  DoPrint (":", $$TxtHi, @P.PMarkLine, @P.PGapCol)                  '
               ELSE                                                                 ' No Label/Tag collision
                  lclScheme = IIF$(IsLXclude(i + 1) AND IsHideFlag, $$LnoLoUL, $$LnoLo)   ' Set HIDE mode underline
                  DoPrint (LEFT$(me.LLCtlGet(i), gENV.LinNoSize), lclScheme, @P.PMarkLine, @P.PLeft)  ' Print the Pending
               END IF                                             '

            ELSE                                                  '
               lclScheme = IIF$(IsLXclude(i + 1) AND IsHideFlag, $$LnoLOUL, $$LnoLO)   ' Set HIDE mode underline
               DoPrint (RIGHT$(LLNumG(i), gENV.LinNoSize), lclScheme, @P.PMarkLine, @P.PLeft)   ' No, just make it normal
            END IF                                                '
            IF IsLUser(i) THEN DoPrint ("|", $$TxtHi, @P.PMarkLine, @P.PGapCol)  ' Flag column id %User
            me.MarkReDraw(@P.PMarkLine)                           ' Re-draw the MARK lines
            @P.PMarkLine = 0                                      ' Forget this marked location
         END IF                                                   '

         IF lrow > @P.PData1 THEN                                 ' Set any new marked line
            IF @P.PS(lrow) > 0 THEN                               ' On an active line?
               BGBandEdit(lrow)                                   ' Calc banding value
               i = me.SGet(lrow)                                  ' Get IX of real data line if still on screen
               IF me.LLCtlGet(i) = LLNumG(i) THEN                 ' A Pending line command?
                  lclScheme = IIF$(IsLXclude(i + 1) AND IsHideFlag, $$LnoHiUL, $$LnoHi)   ' Set HIDE mode underline
                  DoPrint (RIGHT$(LLNumG(i), gENV.LinNoSize), lclScheme, lrow, @P.PLeft)  ' No, just make the line number
               ELSE                                               '
                  lclScheme = IIF$(IsLXclude(i + 1) AND IsHideFlag, $$LnoHiUL, $$LnoHi)   ' Set HIDE mode underline
                  IF LTagG(i) <> $BlankLNo AND L(i).LLbl <> $BlankLNo THEN ' A Label/Tag collision?
                     DoPrint (LEFT$(me.LLCtlGet(i), gENV.LinNoSize), lclScheme, lrow, @P.PLeft) ' Print the Pending
                     DoPrint (":", $$LnoHi, lrow, @P.PGapCol)     ' Inverse
                  ELSE                                            ' No Label/Tag collision
                     DoPrint (LEFT$(me.LLCtlGet(i), gENV.LinNoSize), lclScheme, lrow, @P.PLeft) ' Print the Pending
                  END IF                                          '
               END IF                                             '
               IF IsLUser(i) THEN DoPrint ("|", $$TxtHi, lrow, @P.PGapCol) ' Flag column as %User
               @P.PMarkLine = lrow                                ' Remember where we did this
            END IF                                                '
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD ModSet(ln AS LONG)                                   '
      '--------------------------------------------------------------------------------------------+
      '- Set Modified flags for the edit                                                           |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
         MEntry                                                   '
         IF IsLTabs(ln) THEN OnTabsAFlag: MExitMeth               ' Watch for special lines
         IF IsLWord(ln) THEN OnWordAFlag: MExitMeth               '
         IF IsLMark(ln) THEN OnMarkAFlag: MExitMeth               '
         IF IsLMask(ln) THEN OnMaskAFlag: MExitMeth               '
         IF IsLBounds(ln) THEN OnBndsAFlag: MExitMeth             '
         IF (ISFALSE IsLData(ln) AND ISFALSE IsLTop(ln) AND ISFALSE IsLFile(ln)) THEN MExitMeth ' Only set MODD for Data lines
         OnModdFlag: OnUndoFlag: OnModdEver                       ' Remember we changed something
         me.LFlagBitOff(ln, %EQChange)                            ' Reset ==CHG>
         IF IsLInsertLine(ln) THEN                                ' Is this an Insert line?
            me.LFlagBitOff(ln, %InsertLine)                       '
            LLCtlS(ln) = LLNumG(ln)                               ' Set the line number in
            @P.PLastCleard = ln                                   ' Save Last line number cleared
         END IF                                                   '
         IF IsMEdit THEN                                          ' In a multi edit session, more to do
            me.MEditFlagSet(LMixG(ln), %True)                     ' Flag modified in the MEdit table
            FOR i = 1 TO LastLine                                 ' Find =FILE line
               IF IsLFile(i) THEN                                 ' A =FILE line?
                  INCR j                                          ' Count it
                  IF j = LMIXG(ln) THEN                           ' The one we want?
                     me.UpdLControl(i)                            ' Update it
                     MExitMeth                                    ' We're all done
                  END IF                                          '
               END IF                                             '
            NEXT i                                                '
         END IF                                                   '
         me.UpdLControl(ln)                                       ' Update LLCtl
         MExit                                                    '
      END METHOD                                                  '

      METHOD NFSearch(MODE AS INTEGER, FCursMode AS LONG) AS LONG '
      '--------------------------------------------------------------------------------------------+
      '- Do the NF (Not Found) version of full string Search procedure                             |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, k, l, ii, jj, lclRBnd, CQTOK AS LONG, PosType AS INTEGER, t1, t2, lclWord, c1, t AS STRING, ONCE AS LONG '
         MEntry                                                   '
         lclWord = FCB.WordStr                                    ' Fetch local copies
         ONCE = %True                                             '
         METHOD = %False                                          ' Start off saying we've failed
         IF LastLine > 50000 THEN gLoopCtr = - 1                  ' Prevent loop detection for big files
         t2 = PTBL.L1RData                                        ' Setup data from Search arg
         IF ISFALSE PTBL.FlgL1CaseComp AND _                      '
            ISFALSE PTBL.FlgL1RegEx AND _                         '
            ISFALSE PTBL.FlgL1Picture THEN t2 = UUCASE(t2)        ' UC if not case sensitive search or RegEx

         IF MODE = 0 THEN                                         ' Mode = 0 = Full Find
            sLine = MAX(2, @P.PTopLine): sCol = 1: sDir = 1       ' Set start defaults

            IF ISFALSE PTBL.FlgAll AND _                          ' If not ALL
               (FCursMode = %CLData OR FCursMode = %CLCmd) THEN   ' And in the Data/Line Area
               sLine = me.SGet(@P.C.CRow)                         ' Use the cursor line
            END IF                                                '
            IF PTBL.FlgAll THEN                                   ' ALL
               sLine = 2                                          ' Start at 1st line

            ELSEIF PTBL.FlgFirst THEN                             ' FIRST
               sLine = 2: PTBL.FlgFirst = %False                  '

            ELSEIF PTBL.FlgLast THEN                              ' LAST
               sLine = LastLine: sDir = -1                        '
               PTBL.FlgLast = %False                              '
               PTBL.FlgNext = %False                              '
               PTBL.FlgPrev = %True                               '

            ELSEIF PTBL.FlgPrev THEN                              ' PREV
               sDir = -1: sCol = -1                               '
               sLine = MAX(sLine - 1, 1)                          '
            END IF                                                '

         ELSEIF MODE = 1 THEN                                     ' Mode = 1 = ReFind
            IF PTBL.FoundFailed = 0 OR PTBL.FoundFailed = 3 THEN  ' If not a Top/Bottom not found situation
               PTBL.FoundFailed = 0                               ' Clear in case 3
               IF FCursMode = %CCmd THEN                          ' In the Command area?
                  sLine = @P.PTopLine                             ' Swap in top line of screen
               ELSEIF (FCursMode = %CLData OR FCursMode = %CLCmd) THEN  ' No, In the Data/Line Area?
                  l = me.SGet(@P.C.CRow)                          ' Get line cursor is on
                  IF l AND IsLXclude(l) THEN                      ' Is this an Xclude line?
                     i = CsrLinDX                                 '
                     IF CsrLinDX <> 0 THEN sLine = GetLineNumber(CsrLinDX) ' Continuing from within an X'd block? Use that line number then
                  ELSE                                            '
                     sLine = me.SGet(@P.C.CRow)                   ' Swap in current cursor location
                  END IF                                          '
                  sLine = sLine + sDir                            ' NF continues at next line
               ELSE                                               '
                  sLine = sLine + sDir                            ' NF continues at next line
               END IF                                             '
               sCol = 1                                           '
               IF sDir = -1 THEN sCol = -1                        ' Switch if backward
            ELSE                                                  ' Last one hit top/bottom
               sLine = IIF(PTBL.FoundFailed = 1, LastLine, 1)     ' Set restart point
               PTBL.FoundFailed = 0                               ' Clear, we wrap just once
            END IF                                                '
         END IF                                                   '

         i = sLine                                                ' Init for DO loop
         DO WHILE 1 = 1                                           ' Do forever
            IF gfInterrupt THEN EXIT DO                           ' Break for an FF search
            IF (sDir  = 1  AND IsLBottom(i)) OR _                 ' Do till top or bottom
               (sDir = -1 AND IsLTop(i)) THEN EXIT DO             '

            IF ISFALSE me.RangeVal(i) OR _                        ' Do basic filtering
               ISFALSE IsLData(i) THEN                            '
               i += sDir                                          ' Next entry
               ONCE = %False                                      ' Kill column search start
               ITERATE DO                                         '
            END IF                                                '

            t1 = LTxtG(i)                                         ' Setup data from Txt line
            IF ISFALSE PTBL.FlgL1CaseComp AND _                   '
               ISFALSE PTBL.FlgL1RegEx AND _                      '
               ISFALSE PTBL.FlgL1Picture THEN t1 = UUCASE(t1)     ' Uppercase if not case sensitive search or picture type
            IF ONCE THEN                                          ' For 1st line, honour start col
               ONCE = %False                                      ' Just once please
               IF PTBL.FlgL1Picture THEN                          ' Picture or RegEx type search?
                  me.PicSearch(t1 , t2 , sCol, j, k)              ' Call search routine
               ELSEIF PTBL.FlgL1RegEx THEN                        ' RegEx type search?
                  PCRERegexTest(t1, sCol, j, k)                   ' See if we can find it
               ELSEIF PTBL.FlgL1DLM THEN                          ' DLM type search?
                  me.DLMSearch(t2, t1, sCol, j, k)                ' Call search routine
               ELSE                                               '
                  j = INSTR(sCol, t1, t2)                         ' OK, see if its there
                  k = LEN(t2)                                     '
               END IF                                             '
            ELSE                                                  '
               IF sDir = -1 THEN                                  ' If LAST or PREV then start as the end of the line
                     IF PTBL.FlgL1Picture THEN                    ' Picture type search?
                        me.PicSearch(t1 , t2 , sCol , j, k)       ' Call search routine
                     ELSEIF PTBL.FlgL1RegEx THEN                  ' RegEx type search?
                        PCRERegexTest(t1, 1, j, k)                ' See if we can find it
                     ELSEIF PTBL.FlgL1DLM THEN                    ' DLM type search?
                        me.DLMSearch(t2, t1, sCol, j, k)          ' Call search routine
                     ELSE                                         '
                        j = INSTR(-1, t1, t2)                     '
                        k = LEN(t2)                               '
                     END IF                                       '
               ELSE                                               '
                  IF PTBL.FlgL1Picture THEN                       ' Picture type search?
                     me.PicSearch(t1 , t2 , sCol , j, k)          ' Call search routine
                  ELSEIF PTBL.FlgL1RegEx THEN                     ' RegEx type search?
                     PCRERegexTest(t1, 1, j, k)                   ' See if we can find it
                  ELSEIF PTBL.FlgL1DLM THEN                       ' DLM type search?
                     me.DLMSearch(t2, t1, sCol, j, k)             ' Call search routine
                  ELSE                                            '
                     j = INSTR(t1, t2)                            ' OK, see if its there
                     k = LEN(t2)                                  '
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            IF j THEN                                             ' If we have a 'found' string condition

               IF PTBL.FlgFCol AND ISFALSE PTBL.FlgTCol THEN      ' Request for locate in single column?
                  IF j <> PTBL.ColFrom THEN                       ' then is this in the right column?
                     GOSUB IsLineDone                             ' No, keep looking
                     ITERATE DO                                   '
                  END IF                                          '
               ELSEIF PTBL.FlgFCol AND PTBL.FlgTCol THEN          ' Request within Left/Right columns?
                  IF j < PTBL.ColFrom OR j + k - 1 > PTBL.ColTo THEN ' Is it within bounds?
                     GOSUB IsLineDone                             ' No, keep looking
                     ITERATE DO                                   '
                  END IF                                          '
               END IF                                             '

               IF PTBL.FlgWord THEN                               ' WORD requested?
                  IF j = 1 AND j + k - 1 = LEN(t1) THEN           ' If in left margin and only thing on line
                     i += sDir: ITERATE DO                        ' We found it, keep looking
                  ELSEIF j = 1 AND j + k - 1 <> LEN(t1) THEN      ' In left margin, more on line
                     IF INSTR(lclWord, MID$(t1, j + k, 1)) = 0 THEN  ' Trailing char is a delimiter
                        i += sDir: ITERATE DO                     ' We found it, keep looking
                     ELSE                                         '
                        GOSUB IsLineDone: ITERATE DO              '
                     END IF                                       '
                  ELSEIF INSTR(lclWord, MID$(t1, j - 1, 1)) = 0 THEN ' Left end is after a DLM
                     IF j + k - 1 = LEN(t1) THEN                  ' and right is at the end
                        i += sDir: ITERATE DO                     ' We found it, keep looking
                     ELSE                                         '
                        IF INSTR(lclWord, MID$(t1, j + k, 1)) = 0 THEN  ' Trailing char is a delimiter
                           i += sDir: ITERATE DO                  ' We found it, keep looking
                        ELSE                                      '
                           GOSUB IsLineDone: ITERATE DO           '
                        END IF                                    '
                     END IF                                       '
                  ELSE                                            '
                     GOSUB IsLineDone: ITERATE DO                 ' Keep looking
                  END IF                                          '
               END IF                                             '

               IF PTBL.FlgPrefix THEN                             ' PREFIX requested?
                  IF j = 1 OR INSTR(lclWord, MID$(t1, j - 1, 1)) = 0 THEN  ' If in left margin or preceded by dlm
                     IF j + k < LEN(t1) AND INSTR(lclWord, MID$(t1, j + k, 1)) <> 0 THEN  '
                        i += sDir: ITERATE DO                     ' We found it, keep looking
                     ELSE                                         '
                        GOSUB IsLineDone: ITERATE DO              '
                     END IF                                       '
                  ELSE                                            '
                     GOSUB IsLineDone: ITERATE DO                 '
                  END IF                                          '
               END IF                                             '

               IF PTBL.FlgSuffix THEN                             ' SUFFIX requested?
                  IF j = 1 THEN                                   ' Can't start in col 1
                     GOSUB IsLineDone: ITERATE DO                 '
                  END IF                                          '
                  IF INSTR(lclWord, MID$(t1, j - 1, 1)) = 0 THEN  ' Can't be preceeded by a DLM
                     GOSUB IsLineDone: ITERATE DO                 '
                  END IF                                          '
                  IF j + k > LEN(t1) OR INSTR(lclWord, MID$(t1, j + k, 1)) = 0 THEN ' If Trailing char is a delimiter
                     i += sDir: ITERATE DO                        ' We found it, keep looking
                  ELSE                                            '
                     GOSUB IsLineDone: ITERATE DO                 '
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Do the LM test if asked for                                                      |
               '-----------------------------------------------------------------------------------+
               IF PTBL.FlgLM THEN                                 ' LM requested?
                  IF j = FCB.BndLeft THEN                         ' OK if in LM column
                     i += sDir: ITERATE DO                        ' We found it, keep looking
                  ELSE                                            ' Else fail it
                     GOSUB IsLineDone: ITERATE DO                 '
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Do the RM test if asked for                                                      |
               '-----------------------------------------------------------------------------------+
               IF PTBL.FlgRM THEN                                 ' RM requested?
                  lclRBnd = IIF(FCB.BndRight > 0, FCB.BndRight, LEN(L(i).@LTxt)) ' Set where RM is to be found
                  IF j + k - 1 = lclRBnd THEN                     ' OK if in RM column
                     i += sDir: ITERATE DO                        ' We found it, keep looking
                  ELSE                                            ' Else fail it
                     GOSUB IsLineDone: ITERATE DO                 '
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Do the Color tests if asked for                                                  |
               '-----------------------------------------------------------------------------------+
               IF PTBL.FlgStd OR _                                ' Any color type requests?
                  PTBL.HiLiteSrch <> 0 OR PTBL.FlgSolid OR PTBL.FlgMSolid THEN   '
                  c1 = me.AttrHiLiteGet(i, j, j + k - 1)          ' Get the attr string

                  IF PTBL.FlgStd AND c1 = REPEAT$(k, CHR$(0)) THEN   ' Lets try STD first
                     i += sDir: ITERATE DO                        ' We found it, keep looking
                  END IF                                          '

                  IF c1 = REPEAT$(k, CHR$(PTBL.HiLiteSrch)) THEN  ' Matches requested color?
                     i += sDir: ITERATE DO                        ' We found it, keep looking
                  END IF                                          '

                  IF PTBL.FlgSolid THEN                           ' Lets try SOLID next
                     IF c1 = REPEAT$(k, LEFT$(c1, 1)) AND _       ' Attr line field all the same color?
                        c1 <> REPEAT$(k, CHR$(0)) THEN _          ' and not STD
                        i += sDir: ITERATE DO                     ' We found it, keep looking
                  END IF                                          '

                  IF PTBL.FlgMSolid THEN                          ' Lets try -SOLID next
                     IF c1 <> REPEAT$(k, LEFT$(c1, 1)) THEN   _   ' Attr line field not all the same color?
                        i += sDir: ITERATE DO                     ' We found it, keep looking
                  END IF                                          '

                  GOSUB IsLineDone: ITERATE DO                    '
               END IF                                             '

               '--------------------------------------------------------------------------------+
               '- Do the Commment, Quoted and Text type tests                                         |
               '--------------------------------------------------------------------------------+
               DoCmQtTests:                                       '
               CQTOK = %False                                     ' Start as all failed
               IF PTBL.FlgComment OR PTBL.FlgQuoted OR PTBL.FlgText THEN   ' Any need for the tests?

                  IF PTBL.FlgQuoted THEN                          ' The Quoted type?
                     '--------------------------------------------------------------------------+
                     '- Do Quoted type tests                                                    |
                     '--------------------------------------------------------------------------+
                     FOR ii = j TO j + k - 1                      ' Loop through found string
                        jj = me.AttrSchemeGet(i, ii)              ' Get the Scheme # for the character
                        IF jj =  ClrQuoted THEN ITERATE FOR       ' Q and it's ClrQuoted, continue
                        EXIT IF                                   ' A mis-match, skip this one
                     NEXT ii                                      '
                     CQTOK = %True                                ' A winner, found it
                  END IF                                          '

                  IF PTBL.FlgComment THEN                         ' The Comment type?
                     '--------------------------------------------------------------------------+
                     '- Do the Commment type tests                                              |
                     '--------------------------------------------------------------------------+
                     FOR ii = j TO j + k - 1                      ' Loop through found string
                        t = FORMAT$(me.AttrSchemeGet(i, ii), "00")   ' Get the Scheme # as a 2 char number
                        IF INSTR(ClrComList, t) <> 0 THEN ITERATE FOR   ' C and one of the ClrComments, continue
                        EXIT IF                                   ' A mis-match, skip this one
                     NEXT ii                                      '
                     CQTOK = %True                                ' A winner, found it
                  END IF                                          '

                  IF PTBL.FlgText THEN                            ' The Text type?
                     '--------------------------------------------------------------------------+
                     '- Find if in neither Quoted or Comment                                    |
                     '--------------------------------------------------------------------------+
                     FOR ii = j TO j + k - 1                      ' Loop through found string
                        jj = me.AttrSchemeGet(i, ii)              ' Get the Scheme # for the character
                        t = FORMAT$(jj, "00")                     ' Get the Scheme # as a 2 char number
                        IF jj <>  ClrQuoted AND INSTR(ClrComList, t) = 0 THEN ITERATE FOR ' Inside neither one. we fail
                        EXIT IF                                   ' A mis-match, skip this one
                     NEXT ii                                      '
                     CQTOK = %True                                ' A winner, found it
                  END IF                                          '
                  IF CQTOK THEN                                   ' If found
                     i += sDir: ITERATE DO                        ' We found it, keep looking
                  ELSE                                            ' Not found
                     GOSUB IsLineDone: ITERATE DO                 '
                  END IF                                          '
               END IF                                             '

               i += sDir: ITERATE DO                              ' A valid string compare winner, keep looking
            END IF                                                '

            GOTO MarkANotTrue                                     ' Not found, what we're looking for

         LOOP                                                     '
         MExitMeth                                                '

         NextLine:                                                ' Onward to next line
            IF sDir = 1 THEN                                      ' Forward
               sCol = j + 1                                       ' This isn't the one, set to continue at next column
               IF sCol > LEN(t1) THEN                             ' End of record?
                  GOTO MarkANotTrue                               ' Yes, we have a 'not found' line
               ELSE                                               '
                  ONCE = %True                                    ' Say to honour column, stay on same line
               END IF                                             '
            ELSE                                                  '
               IF ABS(sCol) = LEN(t1) THEN                        ' Beginning of record?
                  GOTO MarkANotTrue                               ' Yes, we have a 'not found' line
               ELSE                                               '
                  ONCE = %True                                    ' No, Honour column, stay on same line
               END IF                                             '
               sCol = j - LEN(t1) -2                              ' Backward, adjust the other way
            END IF                                                '
         RETURN                                                   ' We'll never get here

         IsLineDone:                                              ' See if this line is done or not
            IF sDir = 1 THEN                                      ' Forward
               sCol = j + 1                                       ' This isn't the one, set to continue at next column
               IF sCol > LEN(t1) THEN                             ' End of record?
                  GOTO MarkANotTrue                               ' Yes, we have a 'not found' line
               ELSE                                               '
                  ONCE = %True                                    ' Say to honour column, stay on same line
               END IF                                             '
            ELSE                                                  '
               IF ABS(sCol) = LEN(t1) THEN                        ' Beginning of record?
                  GOTO MarkANotTrue                               ' Yes, we have a 'not found' line
               ELSE                                               '
                  ONCE = %True                                    ' No, Honour column, stay on same line
               END IF                                             '
               sCol = j - LEN(t1) -2                              ' Backward, adjust the other way
            END IF                                                '
         RETURN                                                   ' We'll never get here

         MarkANotTrue:                                            '
            METHOD = %True                                        '
            INCR FixCtr                                           ' Bump FIXCtr
            LFIXS(i) = FixCtr                                     ' Save in line control area

            PosType = IIF(PTBL.FlgTop, %FLocate, %Find)           ' Set positioning for TOP or not

            IF ISFALSE IsLInvisible(i) THEN                       ' A normal non-X'd line?
               IF PTBL.FlgMX THEN                                 ' If caller is someone who wants X out the line
                  me.LFlagBitOn(i, %Invisible)                    ' Just make it invisible
                  me.LFlagBitOn(i, %Popped)                       ' Say we've just popped it
                  gfXRebuild = %True                              ' Rebuild exclude state
                  me.CurSetReq(PosType, i, 1, %True, %True)       ' Put cursor on the X line, Col 1, no hilite, XPtr to be set
                  CsrLinDX = VAL(LLNumG(i))                       ' Save hidden line number for Status Bar display
               ELSE                                               ' This is someone who is just looking like FIND / CHANGE'
                  IF ISTRUE FCB.HiFind THEN                       ' See whether to hilite the find string
                     me.CurSetReq(PosType, i, 1, %True)           ' Set cursor set attempt
                  ELSE                                            '
                     me.CurSetReq(PosType, i, 1, %True)           ' Do it without hilite
                  END IF                                          '
               END IF                                             '
            ELSE                                                  ' We have a line already X'd out
               IF PTBL.FlgMX THEN                                 ' If caller is someone who wants X out the line
                  me.CurSetReq(PosType, i, 1, %True, %True)       ' Just set the cursor
                  CsrLinDX = VAL(LLNumG(i))                       ' Save hidden line number for Status Bar display
               ELSE                                               '
                  IF PTBL.FlgDX THEN                              ' If told to leave X status alone
                     me.CurSetReq(PosType, i, 1, %True, %True)    ' Put cursor on the X line, Col 1, no hilite, XPtr to be set
                     CsrLinDX = VAL(LLNumG(i))                    ' Save hidden line number for Status Bar display
                  ELSE                                            '
                     me.LFlagBitOff(i, %Invisible)                ' Remove the invisibility flag
                     me.LFlagBitOn(i, %Popped)                    ' Say we've just popped it
                     gfXRebuild = %True                           ' Rebuild exclude state
                     IF ISTRUE FCB.HiFind THEN                    ' See whether to hilite the find string
                        me.CurSetReq(PosType, i, 1, %True)        ' Set cursor set attempt
                     ELSE                                         '
                        me.CurSetReq(PosType, i, 1, %True)        ' Do it without hilite
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
            END IF                                                '
            sLine = i: sCol = 1                                   ' Save line and column where found
            PTBL.FoundLine = i: PTBL.FoundCol = 1: PTBL.FoundLen = 1 ' Save
            FoundLstLin = i                                       ' Set the Last time values
            FoundLstCol = 1                                       '
            FoundLstLen = 1                                       '
            IF Found1stLin  = 0 THEN Found1stLin = i              ' Set the 1st time values
            IF Found1stCol  = 0 THEN Found1stCol = 1              '
            IF Found1stLen  = 0 THEN Found1stLen = 1              '
            IF sDir = -1 THEN sCol = j - LEN(t1) -2               ' Backward, adjust the other way
            MExitMeth                                             ' Bail out
        RETURN                                                    ' We'll never do the return
      END METHOD                                                  '

      METHOD PostKeyBoard()                                       '
      '--------------------------------------------------------------------------------------------+
      '- Do post keyboard activities if requested                                                  |
      '--------------------------------------------------------------------------------------------+
         LOCAL i, j, k, ActionSaveNeeded AS LONG                  '
         LOCAL Cmd, t AS STRING                                   '
         LOCAL FMPMacro AS STRING                                 '
         MEntry                                                   '
                                                                  '
         IF IsDoAttention THEN                                    ' Attention requested?
            DOClear(%Attention)                                   ' Yes, clear it now

            '--------------------------------------------------------------------------------------+
            '- Set Refresh and a default low priority cursor location request                      |
            '--------------------------------------------------------------------------------------+
            DoSet(%Refresh)                                       ' Attention always does a refresh as well
            TP.ErrMsgReset                                        ' Start clean

            IF LEFT$(TRIM$(pCommand), 1) = "&" THEN               ' Handle any & prefixed command line?
               pCommandPrv = pCommand                             ' Save & prefixed commands
               pCommand = MID$(pCommand, INSTR(pCommand, "&") + 1)' Strip the &
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Setup the ~w and ~l macro variables if not FM mode                                  |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE IsFMTab THEN                               ' Only do for non FM screens
               IF @P.C.CRow >= @P.PData1 AND @P.C.CRow <= @P.PBottom THEN  ' Save data line if cursor in data area
                  j = me.SGet(@P.C.CRow)                          ' Locate and save data line cursor was on
                  IF j < 0 THEN                                   '
                     me.CsrRowSub(ABS(j))                         ' Backup to 1st line
                     j = me.SGet(@P.C.CRow)                       ' Backward to real data, not hex
                  END IF                                          '
                  @P.C.CIX = j                                    '
               ELSE                                               '
                  @P.C.CIX = 0                                    ' else null
               END IF                                             '
               me.CursorWord()                                    ' Go see if extractable data under the cursor

            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Must validate Scrl amount on each Attention (Ugh)                                   |
            '--------------------------------------------------------------------------------------+
            me.ValScroll()                                        ' Go see if Scroll Amount is reasonable

            '--------------------------------------------------------------------------------------+
            '- Handle CmdSepChr stuff, stack the individual commands                               |
            '--------------------------------------------------------------------------------------+
            IF IsPFKInsert THEN TP.MacSubst(pCommand)             ' Do substitution if from a PFK
            IF me.CmdAddStack() = %False THEN                     ' Process I/P line to multiple commands and see if RESET
               IF IsFMTab THEN                                    ' If not RESET, do either File Manager version
                  IF ISNOTNULL(TRIM$(pCommand)) THEN              ' Command Line
                     FMPMacro = GetNextWord(pCommand, %NoStrip)   ' Get 1st word
                     IF IsMacro(FMPMacro) THEN                    ' If it's a Macro
                        MacName = FMPMacro                        ' Save name
                        gFMMacMode = 0                            ' Set Primary Cmd mode
                        me.pCmdMacro(pCommand)                    ' Go do it
                        pCommand = ""                             ' Null the command line
                     END IF                                       '
                  END IF                                          '
                  IF me.FMLCmdValidate THEN GOTO RefreshOut       ' Go do so, Skip processing if an error
                  me.FMLCmdProcess                                ' Process them now
                  IF ErrMsgHigh > 0 THEN GOTO RefreshOut          ' Errors, skip out

               ELSE                                               ' Or Normal Edit version of line commands
                  '--------------------------------------------------------------------------------+
                  '- Scan the Edit Line commands                                                   |
                  '--------------------------------------------------------------------------------+
                  me.LCtlProcess                                  ' Let LCtlProcess have a go
                  IF gLTblBIX > 0 THEN                            ' We end up with items in the B table?
                     me.LCtlCommands                              ' Go do them
                     IF gENV.AttnPos THEN @P.PTopLine = LastTop   ' If AttnPos restore TopScrn
                  END IF                                          '
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Do special processing if any of WORD, MARK, MASK, TABS or BNDS were modified.       |
            '--------------------------------------------------------------------------------------+
            IF IsWordAFlag THEN me.WordSave                       ' Validate WORD if modified
            IF IsMarkAFlag THEN me.MarkSave                       ' Validate Mark if modified
            IF IsMaskAFlag THEN me.MaskSave                       ' Validate Mask if modified
            IF IsTabsAFlag THEN me.TabsSave                       ' Validate TABS if modified
            IF IsBndsAFlag THEN me.BndsSave                       ' Validate BNDS if modified

            '--------------------------------------------------------------------------------------+
            '- Set ACTION for typing and Line command changes                                      |
            '--------------------------------------------------------------------------------------+
            IF IsUndoFlag AND ActionCtr THEN                      ' Set SAVE needed
               ActionSaveNeeded = %True                           ' Say SAVE might be needed
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Lets handle the command line if we get here                                         |
            '--------------------------------------------------------------------------------------+
            DO WHILE (ISNOTNULL(TRIM$(pCommand)) OR CmdStackNum > 0) AND ErrMsgHigh <= %eCmdPend   ' Do some commands

               '-----------------------------------------------------------------------------------+
               '- Get next stacked command if needed                                               |
               '-----------------------------------------------------------------------------------+
               IF ISNULL(TRIM$(pCommand)) THEN                    ' If no command
                  pCommand = me.CmdStackNext                      ' Get one from the stack
               END IF                                             '
               IF ISNULL(TRIM$(pCommand)) THEN ITERATE DO         ' If still null, ignore it

               '-----------------------------------------------------------------------------------+
               '- Go route and execute the command line                                            |
               '-----------------------------------------------------------------------------------+
               me.CmdAssign                                       '

               IF gTabsNum = 0 THEN MExitMeth                     ' If terminating , exit quickly

               '-----------------------------------------------------------------------------------+
               '- If we just did a RETRIEVE, we're done                                            |
               '-----------------------------------------------------------------------------------+
               IF ErrMsgHigh = %eRetrieve THEN SetCmd: EXIT DO    '

               '-----------------------------------------------------------------------------------+
               '- Use this location to handle the ACTION option for chained commands               |
               '-----------------------------------------------------------------------------------+
               IF (IsUndoFlag AND ActionCtr) OR ActionSaveNeeded THEN   ' If UndoFlag and ACTION running
                  GOSUB DoActionSave                              ' Yes, go do it
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- If no errors, clear the command                                                  |
               '-----------------------------------------------------------------------------------+
               IF ErrMsgHigh <> %eNone AND ErrMsgHigh <> %ePending THEN EXIT DO  ' If some kind of error, exit Cmd loop
               pCommand = ""                                      '

               '-----------------------------------------------------------------------------------+
               '- Do XRebuild if needed                                                            |
               '-----------------------------------------------------------------------------------+
               IF gfXRebuild AND CmdStackNum > 0 THEN             ' Need a rebuild?
                  me.XRebuild(i, j, k)                            ' Go rebuild the Excluded stuff
                  IF i THEN sCurLin = i                           ' Save the answers
                  IF j THEN @P.PTopLine = j                       '
                  IF k THEN sCurScrl = k                          '
               END IF                                             '

               '- Blank the Command now if not needed
               me.WindowCmd                                       ' Re-do the command line

               IF gFMNestTopScrn = 0 THEN SetCmd                  ' Put Cursor on the line if no pending Nest request

               '-----------------------------------------------------------------------------------+
               '- Watch out for Pending                                                            |
               '-----------------------------------------------------------------------------------+
               gRtr.Reset                                         ' Reset the Retrieve stack
               IF ErrMsgHigh = %eCmdPend THEN EXIT DO             ' If CmdPend let scrn display etc. happen
            LOOP                                                  '

            '--------------------------------------------------------------------------------------+
            '- Do some stuff now based on FM / Non-FM tab                                          |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE IsFMTab THEN                               ' If not FM

               '-----------------------------------------------------------------------------------+
               '- Do actual SAVE for Typing and Line Command Changes                               |
               '-----------------------------------------------------------------------------------+
               IF ActionSaveNeeded THEN                           ' If save WAITING
                  GOSUB DoActionSave                              ' Yes, go do it
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Reset flags; Clean '''''' lines; take an UNDO Chkpt                              |
               '-----------------------------------------------------------------------------------+
               OffPFKInsert                                       ' Clear flags now
               me.CleanInsLines()                                 ' Go remove unused Insert Lines
               me.UndoSave                                        ' Go take an Undo save if needed

            ELSE                                                  ' It IS an FM Tab
               IF IsDoSaveReq THEN me.SaveReq                     ' Save Req list if any action above modified something

               '-----------------------------------------------------------------------------------+
               '- See if Path/Mask/etc have changed                                                |
               '-----------------------------------------------------------------------------------+
               FPath = SubstEnviron(TRIM$(FPath))                 ' Clean up and do %xx% handling
               IF RIGHT$(FPath, 1) <> "\" THEN FPath += "\"       ' Ensure FPath has trailing \
               FMask = TRIM$(FMask)                               '
               IF IsNE(LScrlAmtC, TRIM$(FCB.ScrollAmt)) THEN _    ' Do Scrl separately
                  gSQL.UpdateString("O", "ScrlAmtC", FCB.ScrollAmt)  ' So refresh isn't triggered


               IF IsNE(LFPath, TRIM$(FPath)) OR _                 ' User changed criteria?
                  IsNE(lFMask, TRIM$(FMask)) OR _                 '
                  IsNE(lFileListNm, TRIM$(FileListNm)) THEN       '
                  LastTop = 0: DoSet(%LoadReq)                    ' Kill position

                  IF ISNULL(FMask) THEN FMask = "*"               '
                  IF ISNULL(FileListNm) THEN                      ' If this is a normal Directory
                     gSQL.UpdateString("O", "DefDir1", FPath)     '
                     gSQL.UpdateString("O", "DefMask", FMask)     '
                     gSQL.UpdateString("O", "FileListNm", "")     '
                  ELSE                                            ' Else save FileListNm
                     gSQL.UpdateString("O", "FileListNm", FileListNm)   '
                  END IF                                          '
                  gENV.SetFMCrit(DirSort, DefSort, FMask, gFMLayoutID) ' Save the new values in FMDefCrit

                  '--------------------------------------------------------------------------------+
                  '- Fudge Mask for $Backup folders                                                |
                  '--------------------------------------------------------------------------------+
                  IF IsNE(LFPath, TRIM$(FPath)) THEN              ' Was it the Path that changed
                     IF uucase(RIGHT$(TRIM$(FPath), 9)) = "\$BACKUP\" THEN ' Switching to a $BACKUP folder?
                        FMask += ";-*.STATE"                      ' Add exempt STATE files
                     ELSE                                         ' Not going to $BACKUP
                        REPLACE ";-*.STATE" WITH "" IN FMask      ' Remove $BACKUP filters then
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
            END IF                                                '
            IF ISFALSE gMacroMode THEN                            ' If not macro mode
               IF gENV.InsReset THEN                              ' If gENV.InsReset requested
                  IF gENV.InsMode THEN OnNsrtFlag ELSE OffNsrtFlag' then pick up the default
                  IF IsNsrtFlag THEN OffNsrtFlag ELSE OnNsrtFlag  ' Flip/Flop since krInsert also does this
                  me.krInsert                                     ' and go set it
               END IF                                             '
            END IF                                                '
            IF IsDOMarkKill THEN                                  ' Kill marked area?
               IF IsDoMarkKillSkip THEN                           ' Skip once?
                  DoClear(%MarkKillSkip)                          ' Yes, just clear the flag
               ELSE                                               '
                  me.MarkKill                                     ' Do so
                  DoClear(%MarkKill)                              ' Clear flag
               END IF                                             '
            END IF                                                '
            OffPFKInsert                                          ' Clear PFKInsert
            DoClear(%Attention)                                   ' Clear attention
         END IF                                                   '

      RefreshOut:                                                 '
         IF IsDoRefresh OR IsDoMsg OR ErrMsgHigh > 0 THEN         ' Refresh requested or an Error?
            me.DispScreen                                         ' Then re-display
         END IF                                                   '
         gEFTOpenSource = ""                                      ' Reset OPEN invoker
         IF gDoBeepFlag THEN DoBeepReal                           ' If needed, do a Beep
         MExitMeth                                                '

      DoActionSave:                                               '
         IF ISFALSE IsModdFlag THEN RETURN                        ' Only while modified
         DECR ActionCtr                                           ' OK, decrement it
         IF ActionCtr > 0 OR ActionStop THEN RETURN               ' Not time to do a SAVE or Stopped by END?
         ActionCtr = FCB.ActionSave                               ' Yes, reset the counter for next time
         IF IsMEdit OR IsView OR IsBrowse THEN                    ' Unsupported combo?
            '-                                                    ' Do nothing
         ELSE                                                     '
            pCmdSave("SAVE" + IIF$(IsMEdit, " COND Quiet", " Quiet"))   '
         END IF                                                   '
         ActionSaveNeeded = %False                                '
         RETURN                                                   '
      END METHOD                                                  '

      METHOD ProfDisp()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Build and display the PROF lines                                                          |
      '--------------------------------------------------------------------------------------------+
      LOCAL lcltop AS LONG                                        '
         MEntry                                                   '
         me.ResetFunc(%ResetSpecial)                              ' Clear any prior PROF display
         FCB.BuildLines                                           ' Build the Profile display lines (6)
         lclTop = IIF(@P.PS(3) = 0, @P.PS(4), @P.PS(3))           ' Get lcltop based on whether COLS line was there
         IF lclTop = 1 THEN lclTop = 2                            ' So we don't insert before the ** Top of File **
         IF lclTop = LastLine - 1 THEN                            ' Is this the last data line
            DO WHILE lclTop > 1 AND ISFALSE TP.LFlagData(lclTop)  ' If last line isn't data line, find it
               DECR lclTop                                        ' Backup
            LOOP                                                  '
         END IF                                                   '
         me.InsBounds(lclTop)                                     ' Insert the BNDS line
         me.InsCols(lclTop)                                       ' Insert the COLS line
         me.InsTabs(lclTop)                                       ' Insert the TABS line
         me.InsMask(lclTop)                                       ' Insert the MASK line
         me.InsMark(lclTop)                                       ' Insert the MARK line
         me.InsWord(lclTop)                                       ' Insert the WORD line
         me.InsProf(lclTop, 6)                                    ' Insert the PROF line
         me.InsProf(lclTop, 5)                                    ' Insert the PROF line
         me.InsProf(lclTop, 4)                                    ' Insert the PROF line
         me.InsProf(lclTop, 3)                                    ' Insert the PROF line
         me.InsProf(lclTop, 2)                                    ' Insert the PROF line
         me.InsProf(lclTop, 1)                                    ' Insert the PROF line
         me.InsEFT(lclTop)                                        ' Insert the EFT  line if needed

         MExit                                                    '
      END METHOD                                                  '

      METHOD RangeSetRange(fline AS LONG, tline AS LONG)          '
      '--------------------------------------------------------------------------------------------+
      '- Set a specific line range                                                                 |
      '--------------------------------------------------------------------------------------------+
         PTBL.FindRngStart = fline: PTBL.FindRngEnd = tline       ' Set the passed line range
         PTBL.FindRngFlag = 0: PTBL.FindRngLCtl = " "             '
         PTBL.FindRngTag = ""                                     ' Clear other Rangeval criteria
         PTBL.FindRngTNF = %False                                 '
         PTBL.FlgX       = %False                                 '
         PTBL.FlgNX      = %False                                 '
         PTBL.FlgU       = %False                                 '
         PTBL.FlgNU      = %False                                 '
         PTBL.FindRngSet = %True                                  '
      END METHOD                                                  '

      METHOD RangeVal(lno AS LONG) AS LONG                        '
      '--------------------------------------------------------------------------------------------+
      '- See if Line number meets the Line-Range criteria                                          |
      '--------------------------------------------------------------------------------------------+
      LOCAL s, e, ans AS LONG, tag1, tag2 AS STRING               '

         MEntry                                                   '
         METHOD = %False                                          ' Assume failure
         IF ISFALSE PTBL.FindRngSet THEN METHOD = %True: MExitMeth   ' No range, no test, it's true
         '-----------------------------------------------------------------------------------------+
         '- See if a real line range                                                               |
         '-----------------------------------------------------------------------------------------+
         s = PTBL.FindRngStart: e = PTBL.FindRngEnd               ' Do the basic line range tests
         IF s OR e THEN                                           ' Have a test to do?
            IF e = 0 AND lno <> s THEN MExitMeth                  ' If only start and it's incorrect, kill it
            IF lno < s THEN MexitMeth                             ' If lno < start fail it
            IF e AND lno > e THEN MExitMeth                       ' If an end AND lno > end, also done
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- A :tag style?                                                                          |
         '-----------------------------------------------------------------------------------------+
         IF ISNOTNULL(TRIM$(PTBL.FindRngTag)) THEN                ' Is this a Tag 'range'?
            tag1 = TRIM$(LTagG(lno)): tag2 = TRIM$(PTBL.FindRngTag)  ' Get tag from the line and FindRngTag
            IF PTBL.FindRngTNF THEN                               ' Is this the NotEqual style?
               '-----------------------------------------------------------------------------------+
               '- Handle the Not found test                                                        |
               '-----------------------------------------------------------------------------------+
               IF strcmpr(Tag2, ":ZALL") = 0 THEN                 ' The ZALL guy?
                  ans = IIF(ISNULL(tag1), %True, %False)          ' Set true if no tag at all
               ELSE                                               '
                  ans = IIF(strcmpr(tag1, tag2) <> 0, %True, %False) ' Set answer
               END IF                                             '
               IF ISTRUE ans THEN GOTO Others                     ' Something True, continue
               METHOD = %False: MExitMeth                         ' Exit failure, no more tests needed
            ELSE                                                  ' Do the normal Equal test
               '-----------------------------------------------------------------------------------+
               '- Handle the normal tags                                                           |
               '-----------------------------------------------------------------------------------+
               IF strcmpr(Tag2, ":ZALL") = 0 THEN                 ' The ZALL guy?
                  ans = IIF(ISNOTNULL(tag1), %True, %False)       ' Set true if any tag at all
               ELSE                                               '
                  ans = IIF(strcmpr(tag1, tag2) = 0, %True, %False)  ' Set answer
               END IF                                             '
               IF ISTRUE ans THEN GOTO Others                     ' Something True, continue
               METHOD = %False: MExitMeth                         ' Exit failure, no more tests needed
            END IF                                                '
         END IF                                                   '
         Others:                                                  '
         '-----------------------------------------------------------------------------------------+
         '- Other line types                                                                       |
         '-----------------------------------------------------------------------------------------+
         IF PTBL.FlgX  AND ISFALSE IsLInvisible(lno) AND ISFALSE IsLPopped(lno) THEN MexitMeth  '
         IF PTBL.FlgNX AND IsLInvisible(lno) THEN MexitMeth       '
         IF PTBL.FlgU  AND ISFALSE IsLUser(lno) THEN MExitMeth    '
         IF PTBL.FlgNU AND IsLUser(lno) THEN MexitMeth            '
         METHOD = %True                                           ' Passed all tests, a winner
         MExit                                                    '
      END METHOD                                                  '

      METHOD ResetFunc(Request AS LONG)                           '
      '--------------------------------------------------------------------------------------------+
      '- Do a RESET function                                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, lcltop, NumDel AS LONG, t AS STRING, pLCtl AS STRING * 8 '
         MEntry                                                   '
         lcltop = @P.PTopLine                                     ' Save where we were
         IF IsLXclude(lcltop) THEN INCR lcltop                    '

         '-----------------------------------------------------------------------------------------+
         '- Fudge line range if needed                                                             |
         '-----------------------------------------------------------------------------------------+
         IF PTBL.FindRngStart = 2 AND PTBL.FindRngEnd = LastLine - 1 THEN  '
            IF Request = %ResetCommand THEN                       ' Internal RESET command
               PTBL.FindRngStart = 1: PTBL.FindRngEnd = LastLine  ' Add Top/Bottom if an internal resetcommand
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do RETRIEVE separately                                                                 |
         '-----------------------------------------------------------------------------------------+
         IF (Request AND %ResetRetrieve) <> 0 THEN                ' RETRIEVE
            gRtr.CLEAR                                            '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Do TRACK                                                                               |
         '-----------------------------------------------------------------------------------------+
         IF (Request AND %ResetTrack) <> 0 THEN                   ' TRACK
            REDIM TrkStack(1 TO %TrkMax) AS INSTANCE TrkStackT    ' Track Stack
            TrkIX = 0                                             '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Clear line command working tables                                                      |
         '-----------------------------------------------------------------------------------------+
         IF (Request AND %ResetCommand)  <> 0 OR _                ' If %ResetCommand
            (Request AND %ResetCommandK) <> 0 THEN                ' or %ResetCommandK
            RESET gLTblAIX, gLTblBIX                              ' Reset LLCtl table indexes
            me.TTblReset                                          ' Reset the touched table
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Loop thru line range                                                                   |
         '-----------------------------------------------------------------------------------------+
         FOR i = 1 TO LastLine                                    ' Loop through them all
            j = L(i).LFlag                                        '
            '--------------------------------------------------------------------------------------+
            '- Just those in the range                                                             |
            '--------------------------------------------------------------------------------------+
            IF ISFALSE me.RangeVal(i) THEN ITERATE                ' Honour range

            '--------------------------------------------------------------------------------------+
            '- Data, Top, Bottom and Excluded lines                                                |
            '--------------------------------------------------------------------------------------+
            IF ISTRUE (LFlagG(i) AND (%Data OR %Top OR %Bottom OR %Xclude OR %File OR %NOTE)) THEN ' Do Data lines
               IF Request <> %ResetFind THEN LFIXS(i) = 0         ' Reset the FIND index if not just a %ResetFind

               '-----------------------------------------------------------------------------------+
               '- X indicator lines                                                                |
               '-----------------------------------------------------------------------------------+
               IF IsLXclude(i) THEN                               ' Reset X lines
                  IF (Request AND %ResetExcluded) <> 0 THEN       ' If %ResetExcluded
                     me.LTxtFree(i)                               ' Go free the dynamic string
                     me.LEntDel(i)                                ' Remove from the L() array
                     DECR i                                       ' Make sure we don't miss one
                     DECR LastLine: DECR LastReal                 ' Adjust LastLine and LastReal
                     INCR NumDel                                  ' reduce count of total lines
                     IF i <= lcltop THEN lcltop = MAX(1, lcltop - 1) ' Adjust final screen positioning
                     gfXRebuild = %True                           ' Do an X rebuild
                     OnUndoFlag                                   ' Call for an Undo Save
                     ITERATE FOR                                  '
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear Invisible status                                                           |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetExcluded) <> 0 THEN          ' If %ResetExcluded
                  me.LFlagBitOff(i, %Invisible)                   ' Reset Invisible
                  LWrk1S(i) = 0                                   ' Reset any Xclude back index
                  OnUndoFlag                                      ' Call for an Undo Save
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Misc stuff                                                                       |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetHide) <> 0 THEN              ' If %ResetHIDE
                  OffHideFlag                                     ' Set the new value
               END IF                                             '

               IF (Request AND %ResetWord) <> 0 THEN              ' If %ResetWord
                  FCB.WordInput = $WORD                           ' Reset
               END IF                                             '

               IF (Request AND %ResetSource) <> 0 THEN            ' If %ResetSource
                  FCB.SourceName = "ANSI"                         '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear User status                                                                |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetUser) <> 0 THEN              ' If %ResetExcluded
                  me.LFlagBitOff(i, %User)                        ' Reset User
                  OnUndoFlag                                      ' Call for an Undo Save
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear ==CHG> status                                                              |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetChange) <> 0 THEN            ' If %ResetChange
                  IF IsLChange(i) THEN                            ' And Change is on
                     me.LFlagBitOff(i, %EQChange)                 ' Reset ==CHG>
                     me.UpdLControl(i)                            ' Redo the LLCtl
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear line Tags                                                                  |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetTag) <> 0 THEN               ' If %ResetTag
                  IF LTagG(i) <> $BlankLNo THEN                   ' If one exists
                     LTagS(i) = $BlankLNo                         ' Reset the Tag
                     me.UpdLControl(i)                            ' Redo the LLCtl
                     OnUndoFlag                                   ' Call for an Undo Save
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear Color status                                                               |
               '-----------------------------------------------------------------------------------+
               IF ResetClr <> 0 THEN                              ' If a RESET color
                  OnUndoFlag                                      ' Call for an Undo Save
                  IF ResetClr = -1 THEN                           '
                     me.AttrHiLiteSet(i, 1, LAttrGLen(i), %AttrHiStd)   ' Clear all colors
                  ELSE                                            '
                     me.AttrHiLiteClear(i, 1, LAttrGLen(i), ResetClr)   ' Clear the requested color only
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear line labels                                                                |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetLabel) <> 0 THEN             ' If %ResetLabel
                  IF L(i).LLbl <> $BlankLNo THEN                  ' If one exists
                     LLblS(i) = $BlankLNo                         ' Reset Line label
                     me.UpdLControl(i)                            ' Redo the LLCtl
                     OnUndoFlag                                   ' Call for an Undo Save
                  END IF                                          '
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear line Handles                                                               |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetHandle) <> 0 THEN            ' If %ResetHandle
                  IF L(i).LHndl <> 0 THEN                         ' If one exists
                     LHndlS(i) = 0                                ' Reset Line label
                  END IF                                          '
                  RESET HandleLast, HandleMin, HandleMax          ' Reset Last/Min/Max as well
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear line commands                                                              |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetCommandK) <> 0 THEN          ' If %Reset Command by the user
                  pLCtl = L(i).LLCtl                              ' Save current LLCtl
'-                 LLCtlS(i) = LLNumG(i)                           ' Set the line number in
                  me.UpdLControl(i)                               ' Redo the LLCtl
               END IF                                             '

               '-----------------------------------------------------------------------------------+
               '- Clear FIND hiliting                                                              |
               '-----------------------------------------------------------------------------------+
               IF (Request AND %ResetFind) <> 0 AND IsLData(i) THEN  ' If %ResetFind
                  me.AttrInvClear(i, 1, LAttrGLen(i))             ' Clear Inv from all lines
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Misc. line types                                                                    |
            '--------------------------------------------------------------------------------------+
            ELSEIF ISTRUE (LFlagG(i) AND (%Tabs OR %Word OR %Mark OR %Mask OR %Prof OR %Bounds OR %Cols OR %EFT)) THEN  ' Delete Misc. Lines
               IF (Request AND %ResetSpecial) <> 0 THEN           ' If %ResetSpecial
                  IF LFlagG(i) AND (%Prof OR %EFT) = 0 THEN me.LTxtFree(i) ' Go free the dynamic string
                  me.LEntDel(i)                                   ' Remove from the L() array
                  DECR i                                          ' Make sure we don't miss one
                  DECR LastLine: DECR LastReal                    ' Adjust LastLine and LastReal
                  INCR NumDel                                     ' reduce count of total lines
               END IF                                             '
               IF (Request AND %ResetCommand) <> 0 THEN           ' If %ResetCommand
                  me.UpdLControl(i)                               ' Reset Line number
               END IF                                             '

            END IF                                                '
         NEXT i                                                   '
         ResetClr = 0                                             ' Clear type of Clr reset request

         '-----------------------------------------------------------------------------------------+
         '- Adjust for deleted lines                                                               |
         '-----------------------------------------------------------------------------------------+
         me.AdjustPending(1, 0 - NumDel, 0)                       ' Adjust pending requests

         '-----------------------------------------------------------------------------------------+
         '- Find/Change previous values                                                            |
         '-----------------------------------------------------------------------------------------+
         IF (Request AND %ResetAll) = %ResetAll THEN              '
            sCol = 1: sDir = 1: sLine = 1                         ' Restore RFind stuff
            PTBL.FoundLine = 0: PTBL.FoundCol = 0                 '
            TP.ErrMsgReset                                        ' Reset flags
         END IF                                                   '
         @P.PTopLine = lclTop                                     ' Go back to where we were
         MExit                                                    '
      END METHOD                                                  '

      METHOD  RQSplit(RQuest AS STRING, RQPath AS STRING, RQMask AS STRING, RQMode AS STRING, RQDate AS STRING)   '
      '--------------------------------------------------------------------------------------------+
      '- Split out the RQ entries                                                                  |
      '--------------------------------------------------------------------------------------------+
         RESET RQPath, RQMask, RQMode, RQDate                     ' Start all answers as null
         RQPath = PARSE$(RQuest, "|", 1)                          ' Extract the fields
         RQMask = PARSE$(RQuest, "|", 2)                          '
         RQMode = PARSE$(RQuest, "|", 3)                          '
         RQDate = PARSE$(RQuest, "|", 4)                          '
      END METHOD                                                  '

      METHOD  SaveReq()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Save the request list, it has been modified                                               |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      LOCAL fn AS STRING, FNum AS LONG                            '
         MEntry                                                   '
         DoClear(%SaveReq)                                        ' Say we did it
         IF FileListNm = "" THEN MExitMeth                        ' No FILELIST name, bail out

         IF FileListNm = "Recent Files" AND gENV.eINSTANCE <> "DEFAULT" THEN  ' An INSTANCE Recent Files?
            fn = gENV.HomeData + "FILELIST\" + FileListNm + "." + gENV.eINSTANCE + ".FLIST"   ' Build name
         ELSE                                                     ' Else
            fn = gENV.HomeData + "FILELIST\" + FileListNm + ".FLIST" ' Build it the old way
         END IF                                                   '

         FNum = FREEFILE                                          ' Get a file number
         Call3(TryOpenOutPut(fn, FNum), _                         ' Try the open
               MErrExit(%eFail, "FILELIST: " + FileListNm + " Open failed"), _   ' Oops?  Bail out
               MErrExit(%eFail, "FILELIST: " + FileListNm + " is in use"), _  ' Oops?  Bail out
               Nul)                                               ' Continue
         FOR i = 1 TO gFMRQCount                                  ' Write the file
            PRINT # FNum, gFMRQList(i)                            ' Print a line
         NEXT i                                                   '
         CLOSE # FNum                                             ' Close the File
         MExit                                                    '
      END METHOD                                                  '

      METHOD TabsSimple(ln AS LONG) AS STRING                     '
      '--------------------------------------------------------------------------------------------+
      '- Return a TABS line with + expanded at least to ln                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, j, k AS LONG, nTabs AS STRING                      '
         MEntry                                                   '
         k = MAX(ln, gENV.ScrWidth)                               ' Get min length of output
         i = INSTR(-1, FCB.TabsLine, "*")                         ' Get location of last *
         j = INSTR(-1, FCB.TabsLine, "+")                         ' Get location of last +
         IF j = 0 THEN METHOD = FCB.TabsLine: MExitMeth           ' No +, nothing to do
         nTabs = LEFT$(FCB.TabsLine, i)                           ' Start with LH end of Tabs line
         DO WHILE LEN(nTabs) < k                                  ' Extend until > length
            nTabs += SPACE$(j - i -1) + "*"                       ' Add ...* to create another tab stop
         LOOP                                                     '
         METHOD = nTabs                                           '
         MExit                                                    '
      END METHOD                                                  '

      METHOD TabsSave()                                           '
      '--------------------------------------------------------------------------------------------+
      '- Save the TABS line by updating the CFG file                                               |
      '--------------------------------------------------------------------------------------------+
      LOCAL Wrd1 AS STRING, i, j AS LONG                          '
         MEntry                                                   '
         OffTabsAFlag                                             ' Clear flag that got us here
         Wrd1 = TP.TabsLine                                       ' Get a working copy of Tabs line
         i = INSTR(-1, Wrd1, "+")                                 ' Get location of last + sign
         j = INSTR(-1, Wrd1, "*")                                 ' Get location of last * sign
         IF i > 0 AND j > 0 AND j > i THEN                        '
            FCB.TabsLine = ""                                     '
            MErrExit(%eFail, "Repeating tab is left of last fixed tab, TABS line nulled.")   ' Else tell user
         END IF                                                   '
         FCB.TabsLine = TP.TabsLine                               ' Set it into the Profile
         DoProfMsg("New TABS values established")                 '
         MExit                                                    '
      END METHOD                                                  '

      METHOD TabTitleSet(force AS LONG)                           '
      '--------------------------------------------------------------------------------------------+
      '- Setup the tab title                                                                       |
      '--------------------------------------------------------------------------------------------+
      LOCAL title, lh, rh AS STRING, lcltcitem AS TCITEMHEADER, newtxt AS ASCIIZ * 255, tWnd AS LONG  '
         MEntry                                                   '
         IF gMacroMode THEN MExitMeth                             ' If macro mode, exit
         IF IsFMTab THEN                                          ' The simple case?
            title = "File Manager"                                '
            GOSUB DoSwitch                                        ' Switch it
            MExitMeth                                             ' We're done
         END IF                                                   '
         IF ((IsModdFlag AND IsModdLast) OR (ISFALSE IsModdFlag AND ISFALSE IsModdLast)) AND _  '
            force = %False THEN MExitMeth                         ' Don't do if unchanged, causes flickering
         IF IsModdFlag THEN OnModdLast ELSE OffModdLast           ' Save as last status
         IF IsClip THEN                                           '
            title = "(CLIP)"                                      '
            IF ClipName <> "" THEN                                ' Fiddle DIFF use of the clipboard
               IF LEFT$(ClipName, 6) = "_DIFF." THEN              ' Is this DIFF?
                  lh = LEFT$(MID$(Clipname, 22), INSTR(MID$(Clipname, 22), "~~") - 1)  '
                  rh = MID$(MID$(Clipname, 2), INSTR(MID$(Clipname, 2), "~~") + 2)  '
                  lh = TRIM$(TP.FileAbbrev(lh, 30))               '
                  rh = TRIM$(TP.FileAbbrev(rh, 30))               '
                  title = TRIM$(lh) + "~~" + TRIM$(rh)            ' Use abbrev names
'-                 title = MID$(ClipName, 7)                      ' Just use the DIFFname
               ELSE                                               ' Else
                   title += " - " + ClipName                      ' Append Clipname
               END IF                                             '
            END IF                                                '
         ELSEIF IsSetEdit THEN                                    '
            title += "(SET Edit)"                                 '
         ELSEIF IsEFTEdit THEN                                    '
            title += "(EFT Edit)"                                 '
         ELSEIF IsMEdit THEN                                      '
            title += "(M-Edit)"                                   '
         ELSEIF ISNULL(TP.FCB_.FilePath) THEN                     '
            title += $New                                         ' So we don't display nulls
         ELSE                                                     '
            title += TP.FCB_.File                                 ' Start with the file name
         END IF                                                   '
         IF IsModdFlag THEN _                                     ' If modified, Add 128 to first char as a signal
            title = CHR$(ASC(LEFT$(title, 1)) + 128) + MID$(title, 2)   '
         GOSUB DoSwitch                                           '
         MExitMeth                                                '

      DoSwitch:                                                   '
         CONTROL HANDLE ghWnd, %IDC_SPFLiteTAB TO tWnd            ' Get the handle
         newtxt = TRIM$(title)                                    ' Copy title to ASCIIZ string
         lcltcitem.mask = %TCIF_TEXT                              ' Say which item we're changing
         lcltcitem.pszText = VARPTR(NewTxt)                       ' Point at the new text
'-        lcltcitem.cchTextMax = len(newtxt)                      ' Set length
         SendMessage(tWnd, %TCM_SETITEM, TP.PgNumber - 1, VARPTR(lcltcitem))  ' Make the change
         RETURN                                                   '
      END METHOD                                                  '

      METHOD TagChange(NewTag AS STRING) AS LONG                  '
      '--------------------------------------------------------------------------------------------+
      '- Do the TAG status change, return 1 if a change occurred                                   |
      '--------------------------------------------------------------------------------------------+
      LOCAL i, fresult AS LONG, t AS STRING                       '
         MEntry                                                   '
         i = PTBL.FoundLine: t = UUCASE(NewTag)                   ' Line we're working on
         IF PTBL.FlgOn OR PTBL.FlgSet THEN                        ' TAG :xxx ON/SET?
            IF LTagG(i) <> t THEN                                 ' Already set to this tag?
               LTagS(i) = t                                       ' No? Copy in the new Tag
               me.UpdLControl(i)                                  ' Reset line control
               fresult = 1                                        ' Pass back 1 to say we did something
            END IF                                                '
         ELSEIF PTBL.FlgOff THEN                                  ' TAG :xxx OFF?
            IF ISNULL(t) THEN                                     ' If no tag specified
               IF LTagG(i) <> $BlankLNo THEN                      ' If not already a blank tag?
                  LTagS(i) = $BlankLNo                            ' Clear the Tag
                  me.UpdLControl(i)                               ' Reset line control
                  fresult = 1                                     ' Pass back 1 to say we did something
               END IF                                             '
            ELSE                                                  ' Tag specified, OFF only if we match
               IF t = LTagG(i) THEN                               ' So, do we match?
                  LTagS(i) = $BlankLNo                            ' Clear the Tag
                  me.UpdLControl(i)                               ' Reset line control
                  fresult = 1                                     ' Pass back 1 to say we did something
               END IF                                             '
            END IF                                                '
         ELSEIF PTBL.FlgToggle THEN                               ' TAG :xxx TOGGLE?
            IF ISNULL(TRIM$(LTagG(i))) THEN                       ' If currently null
               LTagS(i) = t                                       ' Copy in the new Tag
               me.UpdLControl(i)                                  ' Reset line control
               fresult = 1                                        ' Pass back 1 to say we did something
            ELSE                                                  ' Already a tagname
               IF t = LTagG(i) THEN                               ' If we match
                  LTagS(i) = $BlankLNo                            ' Clear the Tag
                  me.UpdLControl(i)                               ' Reset line control
                  fresult = 1                                     ' Pass back 1 to say we did something
               END IF                                             '
            END IF                                                '
         END IF                                                   '
         METHOD = fresult                                         ' Pass back 0/1 for counting
         MExit                                                    '
      END METHOD                                                  '

      METHOD TestExclude(FName AS STRING) AS LONG                 '
      '--------------------------------------------------------------------------------------------+
      '- See if filename is in the Exclude list                                                    |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG                                             '
         IF gFMRXCount = 0 THEN METHOD = 0                        ' Nothing in table, then not found
         ARRAY SCAN gFMRXList() FOR gFMRXCount, COLLATE UCASE, =FName, TO i   ' Can we find the filename?
         METHOD = i                                               ' Pass back result
      END METHOD                                                  '

      METHOD TestMask(FName AS STRING, FTMask AS STRING) AS LONG  '
      '--------------------------------------------------------------------------------------------+
      '- See if filename matches a mask                                                            |
      '--------------------------------------------------------------------------------------------+
      LOCAL tmask AS STRING, TName, TMask2 AS ASCIIZ * %MAX_PATH  '
      LOCAL j, chosen, request AS LONG, RCA AS RCArea             '
      LOCAL Masks() AS STRING                                     '
         MEntry                                                   '
         tmask = IIF$(LEFT$(FTMask, 1) = "-", "*;" + FTMask, FTMask) ' Add a leading *; if mask starts off negative
         REDIM Masks(1 TO PARSECOUNT(tmask, ";")) AS STRING       ' Size the array
         PARSE UUCASE(TRIM$(tmask)), Masks(), ";"                 ' Split into the table
         TName = UUCASE(FName)                                    ' Make filename ASCIIZ

         FOR j = 1 TO UBOUND(Masks())                             ' Now for each mask
            request = %True                                       ' Start as True
            tmask = masks(j)                                      ' Copy it
            IF LEFT$(tmask, 1) = "-" THEN                         ' Unwanted?
               request = %False: tmask = MID$(tmask, 2)           ' Make Request false, drop the -
            ELSEIF LEFT$(tmask, 1) = "+" THEN                     ' Wanted?
               tmask = MID$(tmask, 2)                             ' Request true, drop the +
            END IF                                                '

            IF LEFT$(tmask, 1) = "=" THEN                         ' Set symbol?
               SETTableUpd("GET", MID$(tmask, 2), RCA)            ' Fetch substitution value
               IF RCA.RC > 0 THEN                                 ' Not found?
                  tmask = masks(j)                                ' Put back untouched operand
               ELSE                                               ' We have a value
                  tmask = RCA.Msg                                 ' Substitute it
               END IF                                             '
            END IF                                                '
            tmask2 = tmask                                        '

            IF PathMatchSpec(TName, TMask2) THEN                  ' Do we have a match?
               Chosen = Request: ITERATE FOR                      ' Set match
            ELSE                                                  '
               ITERATE FOR                                        '
            END IF                                                '
         NEXT j                                                   '

         IF chosen THEN METHOD = %True ELSE METHOD = %False       ' Result is final Chosen value
         MExit                                                    '
      END METHOD                                                  '

      METHOD UnWatchQueue(fn AS STRING)                           '
      '--------------------------------------------------------------------------------------------+
      '- Kill watch and dequeue the file                                                           |
      '--------------------------------------------------------------------------------------------+
         MEntry                                                   '
         IF ISNOTNULL(TRIM$(fn)) THEN                             ' If a filename
            me.FileWatch(fn, %WatchEnd)                           ' Kill specific filename Watch
            FileQueue("D", " ", fn)                               ' Remove from the Open queue
         ELSE                                                     '
            me.FileWatch("", %WatchEnd)                           ' Kill any prior Watch for the tab
            FileQueue("D", " ", TP.FCB_.FilePath)                 ' Remove default file from the Open queue
         END IF                                                   '
         Mexit                                                    '
      END METHOD                                                  '

      METHOD UpdLControl(lno AS LONG)                             '
      '--------------------------------------------------------------------------------------------+
      '- Update the Line Ctl field                                                                 |
      '--------------------------------------------------------------------------------------------+
      REGISTER i AS LONG                                          '
      REGISTER j AS LONG                                          '
      LOCAL f AS LONG, KCmd AS STRING                             '
         MEntry                                                   '
         i = lno                                                  ' Swap line number to local
         f = (LFlagG(i) AND %SpecialLine)                         ' Get a copy of the line flag, keep just the Type bits
         IF f THEN                                                ' It's a special one
            FOR j = 1 TO UBOUND(gLnoTextType)                     ' Lets search
               IF (f AND gLnoTextType(j)) THEN                    ' Match of type?
                  LLCtlS(i) = gLnoTextTxt(j)                      ' Set the text
                  EXIT FOR                                        ' We're done
               END IF                                             '
            NEXT j                                                '

            '--------------------------------------------------------------------------------------+
            '- Fiddle =FILE line if needed                                                         |
            '--------------------------------------------------------------------------------------+
            IF (f AND %File) THEN                                 ' Is this a =FILE> line?
               IF me.MeditFlagGet(LMIXG(i)) THEN                  ' Modified
                  KCmd = me.LLCtlGet(i)                           ' Get the current LLCtl
                  MID$(KCmd, CHOOSE(gENV.LinNoSize, 1, 1, 1, 1, 5, 6, 7, 8 ELSE 1), 1) = "*" ' Add modified *
                  LLCtlS(i) = KCmd                                ' Stuff it back
               END IF                                             '
            END IF                                                '

            '--------------------------------------------------------------------------------------+
            '- Fiddle =NOTE line if needed                                                         |
            '--------------------------------------------------------------------------------------+
            IF (f AND %Note) THEN                                 ' Is this a =NOTE> line?
               j = L(i).LWrk2                                     ' Get the LWrk2 value
               IF j THEN                                          ' Other than default note?
                  KCmd = me.LLCtlGet(i)                           ' Get the current LLCtl
                  MID$(KCmd, CHOOSE(gENV.LinNoSize, 1, 1, 1, 1, 2, 1, 2, 3 ELSE 1), 1) = MID$($Upper, j, 1) ' Add type of xNOTE
                  LLCtlS(i) = KCmd                                ' Stuff it back
               END IF                                             '
            END IF                                                '

         ELSE                                                     ' Nothing special, just a line number
            LLCtlS(i) = LLNumG(i)                                 ' Set the line number in
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Add Labels and tags                                                                    |
         '-----------------------------------------------------------------------------------------+
         me.LLctlTagSet(i)                                        ' Overlay with Tag
         me.LLctlLblSet(i)                                        ' Overlay with LLbl

         IF TCtr > 0 THEN                                         ' Pending line commands?
            KCmd = me.TTblScan(i)                                 ' See if a pending line command
            IF ISNOTNULL(TRIM$(KCmd)) THEN LLCtlS(i) = UUCASE(KCmd)  ' Swap it in
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD ValScroll()                                          '
      '--------------------------------------------------------------------------------------------+
      '- Validate Scroll Amount                                                                    |
      '--------------------------------------------------------------------------------------------+
      LOCAL lclScr AS STRING, i AS LONG                           '
         MEntry                                                   '
'         IF IsEQ(FCB.ScrollAmt, ScrollLast) THEN MexitMeth        ' Nothing changed?
         lclscr = UUCASE(FCB.ScrollAmt)                           ' Get local copy

         '-----------------------------------------------------------------------------------------+
         '- Use default if field nulled                                                            |
         '-----------------------------------------------------------------------------------------+
         IF ISNULL(TRIM$(lclscr)) THEN                            ' Null'd?
            FCB.ScrollAmt = ScrollLast                            ' set in default
            IF IsFMTab THEN gSQL.UpdateString("O", "ScrlAmtc", FCB.ScrollAmt) ' Save as the FM default if an FM Tab
            MExitMeth                                             '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If numeric, handle it first                                                            |
         '-----------------------------------------------------------------------------------------+
         lclscr = LSET$(lclscr,5)                                 ' Make it 5 chars long
         IF VERIFY(LEFT$(lclscr, 1), "0123456789") = 0 THEN       ' If leading numeric
            i = VERIFY(lclscr, "0123456789")                      ' Find first non-numeric
            lclscr = LEFT$(lclscr, i - 1)                         ' Throw away non-numerics
            IF VAL(lclscr) > 0 THEN                               ' Must not be zero or neg
               FCB.ScrollAmt = FORMAT$(VAL(lclscr), "####")       ' Stuff back pretty version
               IF IsFMTab THEN gSQL.UpdateString("O", "ScrlAmtc", FCB.ScrollAmt) ' Save as the FM default if an FM Tab
               MexitMeth                                          ' Done
            ELSE                                                  '
               FCB.ScrollAmt = ScrollLast                         ' set in default
               MErrExit(%eFail, "Invalid scroll Amt. Re-establishing the previous value") '
            END IF                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- See which alpha type it is                                                             |
         '-----------------------------------------------------------------------------------------+
         lclscr = TRIM$(lclscr)                                   ' Trim it
         SELECT CASE CONST$ LEFT$(lclscr, 1)                      ' Which was it?
            CASE "P": FCB.ScrollAmt = "PAGE"                      '
            CASE "F": FCB.ScrollAmt = "FULL"                      '
            CASE "H": FCB.ScrollAmt = "HALF"                      '
            CASE "D": FCB.ScrollAmt = "DATA"                      '
            CASE "C": FCB.ScrollAmt = "CSR "                      '
            CASE ELSE                                             '
               FCB.ScrollAmt = UUCASE(ScrollLast)                 ' Just in case
               MErrExit(%eFail, "Invalid scroll Amt. Re-establishing the previous value") '
         END SELECT                                               '

         IF IsFMTab THEN gSQL.UpdateString("O", "ScrlAmtc", FCB.ScrollAmt) ' Save as the FM default if an FM Tab
         MExit                                                    '

      END METHOD                                                  '

      METHOD WINDOW(BYREF Tx AS STRING) AS STRING                 '
      '--------------------------------------------------------------------------------------------+
      '- Return a portion of a Text string to match window offset                                  |
      '--------------------------------------------------------------------------------------------+
         METHOD = LSET$(MID$(TX, @P.POffset + 1, @P.PDataLen), @P.PDataLen)   ' Pass back string (Padded if needed)
      END METHOD                                                  '

      METHOD WindowBnds() AS STRING                               '
      '--------------------------------------------------------------------------------------------+
      '- Return a BNDS line to match current Window offset                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL t AS STRING                                           '
         t = MID$(BndText, @P.POffset + 1, @P.PDataLen)           ' Pickup DataLen characters from the Offset location
         IF LEN(t) < @P.PDataLen THEN _                           ' Make sure at least screen width
            t = LSET$(t, @P.PDataLen)                             ' Lengthen to DataLen if needed
         METHOD = t                                               ' Pass back the result
      END METHOD                                                  '

      METHOD WindowCmd()                                          '
      '--------------------------------------------------------------------------------------------+
      '- Reprint the command line                                                                  |
      '--------------------------------------------------------------------------------------------+
      LOCAL lCommand1, lCommand2, Wd1, Wd2 AS STRING, i AS LONG, AttrLine AS WSTRING   '
      STATIC LoadModel AS STRING                                  '
         MEntry                                                   '
         gBandBG = %False                                         ' Clear any prior banding state
         DoPrint (SPACE$(@P.PCmdLen), CHR$$(%SCTxtLo), @P.PTop, @P.PCmdCol)   '
         IF PPActive <> P THEN MExitMeth                          ' Only Active panel gets the command

         AttrLine = REPEAT$(MAX(1, LEN(pCommand)), CHR$$(%SCTxtLo))  ' Make whole line Lo intensity
         IF INSTR(pCommand, " ") = 0 THEN GOTO DoMark             ' If no deliminated cmd name yet, skip
         Wd1 = UUCASE(GetNextWord(pCommand, %NoStrip))            ' Get the basic command name
         IF ISNULL(Wd1) THEN GOTO DoMark                          ' If we can't identify a command
         i = gPCmdT.GetCmdIX(Wd1)                                 ' Get the command table index?
         IF i = 0 THEN GOTO DoMark                                '

         '-----------------------------------------------------------------------------------------+
         '- OK we have a recognized command that has KW type operands                              |
         '-----------------------------------------------------------------------------------------+
         IF IsNE(LoadModel, Wd1) THEN                             ' If LOAD needed
            PTBL.LoadModel(Wd1, %True): LoadModel = Wd1           ' Get it loaded, say it's a pre-load type
         END IF                                                   '
         lCommand1 = UUCASE(pCommand) + " "                       ' Working copy of pCommand
         lCommand2 = lCommand1                                    ' Another copy
         Wd1 = GetNextWord(lCommand1, %Strip)                     ' Strip off the command name
         i = INSTR(lCommand2, Wd1)                                ' Locate it in line in case not at the left
         MID$(AttrLine, i, LEN(Wd1)) = REPEAT$(LEN(Wd1), CHR$$(%ScTxtHi))  '
         DO WHILE TRIM$(lCommand1) <> ""                          ' While we have operands
            Wd1 = GetNextWord(lCommand1, %Strip)                  ' Get next operand
            IF PTBL.DefKwd(Wd1) THEN                              ' We've got one
               i = INSTR(lCommand2, " " + Wd1 + " ")              ' Locate it in line
               MID$(AttrLine, i + 1, LEN(Wd1)) = REPEAT$(LEN(Wd1), CHR$$(%ScTxtHi)) ' Mark it Hi
            END IF                                                '
         LOOP                                                     '
         DoMark:                                                  '
         DoPrint (LSET$(MID$(pCommand, @P.PCOffset + 1, @P.PCmdLen), @P.PCmdLen + 1), AttrLine, @P.PTop, @P.PCmdCol) '

         '-----------------------------------------------------------------------------------------+
         '- Mark selected Cmd                                                                      |
         '-----------------------------------------------------------------------------------------+
         IF IsMiscActive THEN                                     ' Do we have a marked Cmd?
            OffMiscDrawn                                          ' Previous is gone, we just re-drew the screen
            me.MiscMark                                           ' Go re-draw the marked area
         END IF                                                   '
         MExit                                                    '
      END METHOD                                                  '

      METHOD WindowCol() AS STRING                                '
      '--------------------------------------------------------------------------------------------+
      '- Return a COLS line to match current Window offset                                         |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, u, lcltabs AS STRING, i, j, DiffOff, lclOffset AS LONG   '
         lclOffset = @P.POffset                                   ' Pick up normal value
         IF (TabMode AND %Diff) THEN                              ' If DIFF mode
            IF gENV.Diff1Column = 1 THEN                          ' 1Column?
               DiffOff = 12                                       ' Set 1column Diff offset
            ELSE                                                  '
               lclOffset = 0                                      ' 2Column mode, force Offset to 0
            END IF                                                '
         END IF                                                   '

         lcltabs = me.TabsSimple(lclOffset + @P.PDataLen)         ' Get a working TABS line
         t = STRING$(@P.PDataLen + 5, "-")                        ' Fill line with dashes (plus a cushion)

         FOR i = 1 TO @P.PDataLen                                 ' Loop now for each character
            j = i + lclOffset - DiffOff                           ' j = real data column
            IF (j MOD 10) = 0 THEN                                ' At a column interval=10 ?
               u = FORMAT$(j/10, "#####")                         ' Format the column number
               MID$(t,i,LEN(u)) = u                               ' Overlay the number
            ELSEIF (j MOD 5) = 0 THEN                             ' At a column interval=5
               MID$(t,i,1) = "+"                                  ' Stuff in a +
            END IF                                                '
            IF MID$(lcltabs, j, 1) = "*" THEN                     ' Also a tab position
               MID$(t, i, 1) = CHR$(ASC(t, i) + 128)              ' Flag for reverse video
            END IF                                                '
         NEXT i                                                   '

         IF (TabMode AND %Diff) THEN                              ' If DIFF mode
            IF gENV.Diff1Column = 1 THEN                          ' 1Column mode
               IF DiffOff > lclOffset THEN                        ' Overlay offset columns
                  MID$(t, 1, DiffOff - @P.POffSet) = REPEAT$(DiffOff - @P.POffset, ".")   '
               END IF                                             '
            ELSE                                                  ' 2Column mode
               t = REPEAT$(6, ".") + LEFT$(t, gDiffColWidth - 6) + "........." + LEFT$(t, gDiffColWidth - 6)   '
            END IF                                                '
         END IF                                                   '
         METHOD = LEFT$(t, @P.PDataLen)                           ' Pass back the result
      END METHOD                                                  '

      METHOD WindowHexBottom(BYREF Txt1 AS STRING) AS STRING      '
      '--------------------------------------------------------------------------------------------+
      '- Return a portion of a Text string to match window offset                                  |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, c, HexTable2 AS STRING                             '
      REGISTER i AS LONG                                          '
         HexTable2 = REPEAT$(16, $Hex)                            '
         t = LSET$(MID$(Txt1, @P.POffset+1, @P.PDataLen), @P.PDataLen)  ' Get windowed substring

         FOR i = 1 TO LEN(t)                                      ' Loop through characters
            IF FCB.SrceXlate OR FCB.ColateXlate THEN              ' Non-ANSI SOURCE or COLLATE?
               c = MID$(t, i, 1)                                  ' Do the translate
               me.Translate(c, FCB.GetCA2SPtr)                    '
               MID$(t, i, 1) = MID$(HexTable2, 1 + ASC(c), 1)     '
            ELSE                                                  '
               MID$(t, i, 1) = MID$(HexTable2, 1 + ASC(t, i), 1)  '
            END IF                                                '
         NEXT i                                                   '

         METHOD = t                                               ' Pass back result
      END METHOD                                                  '

      METHOD WindowHexTop(BYREF Txt1 AS STRING) AS STRING         '
      '--------------------------------------------------------------------------------------------+
      '- Return a portion of a Text string as Upper Hex                                            |
      '--------------------------------------------------------------------------------------------+
      LOCAL t, c, HexTable1 AS STRING                             '
      REGISTER i AS LONG                                          '
         HexTable1 = BUILD$("0000000000000000111111111111111122222222222222223333333333333333", _  '
                            "4444444444444444555555555555555566666666666666667777777777777777", _  '
                            "88888888888888889999999999999999AAAAAAAAAAAAAAAABBBBBBBBBBBBBBBB", _  '
                            "CCCCCCCCCCCCCCCCDDDDDDDDDDDDDDDDEEEEEEEEEEEEEEEEFFFFFFFFFFFFFFFF") '
         t = LSET$(MID$(Txt1, @P.POffset+1, @P.PDataLen), @P.PDataLen)  ' Get windowed substring

         FOR i = 1 TO LEN(t)                                      ' Loop through characters
            IF FCB.SrceXlate OR FCB.ColateXlate THEN              ' Non-ANSI SOURCE or COLLATE?
               c = MID$(t, i, 1)                                  ' Do the translate
               me.Translate(c, FCB.GetCA2SPtr)                    '
               MID$(t, i, 1) = MID$(HexTable1, 1 + ASC(c), 1)     '
            ELSE                                                  '
               MID$(t, i, 1) = MID$(HexTable1, 1 + ASC(t, i), 1)  '
            END IF                                                '
         NEXT i                                                   '

         METHOD = t                                               ' Pass back result
      END METHOD                                                  '

      METHOD WindowLCmd(idx AS LONG) AS STRING                    '
      '--------------------------------------------------------------------------------------------+
      '- Extract the visible FM Line command portion                                               |
      '--------------------------------------------------------------------------------------------+
         IF TRIM$(gFMD(idx).Cmd) <> "" THEN                       ' Something in command?
            METHOD = LSET$(MID$(gFMD(idx).Cmd, gFMD(idx).CmdOff + 1), gENV.FMLCmdWidth) + " "   '
         ELSE                                                     '
            METHOD = REPEAT$(gENV.FMLCmdWidth, IIF$((gFMD(idx).FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY, ".","_")) + " "  '
         END IF                                                   '
      END METHOD                                                  '

      METHOD WindowTitle()                                        '
      '--------------------------------------------------