'----- License Stuff
'    This file is part of SPFLite.
'    SPFLite is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    SPFLite is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.
'
'----- _AsmCode.inc
                                                                  '
FUNCTION StrCmpr(str1 AS STRING, str2 AS STRING) AS LONG          '
'---------- Case insensitive string compare
LOCAL S3, s4 AS DWORD, match AS LONG                              '
' --------------------------------------------------
' compare two basic dynamic strings case insensitive
' Return values.
' -1 -- Str1 is low
'  0 -- Str1 = Str2
'  1 -- Str2 is low
' --------------------------------------------------
#DEBUG CODE OFF                                                   '
    #REGISTER NONE                                                '
   s3 = LEN(str1): s4 = LEN(str2)                                 '
    PREFIX "! "                                                   '
    mov   esi, str1                                               ' Copy text pointers into register
    mov   edi, str2                                               '
    mov   esi, [esi]                                              ' Dereference it to get text address
    mov   edi, [edi]                                              '

    mov   ecx,s3                                                  ' Get the length of 1st string in ecx
    mov   edx,s4                                                  ' Get the lenght of 2nd string in edx
    cmp   ecx,edx                                                 ' Compare the two lengths
    pushf                                                         ' Save the current status on the stack
    jbe   LgthSet                                                 ' Put shorter length in ecx
    mov   ecx,edx                                                 '

  LgthSet:                                                        '
    SUB   edx,edx                                                 ' Clear counter

  MainTest:                                                       '
    AND   ecx,ecx                                                 ' Any length left?
    jz    AllEqual                                                ' No? We're done byte comparisons
    movzx eax, BYTE PTR [esi+edx]                                 ' Get Str1 byte into eax
    movzx eax, BYTE PTR Cmpi_tbl[eax]                             ' Get translated Str1 byte into eax
    movzx ebx, BYTE PTR [edi+edx]                                 ' Get Str2 byte into ebx
    movzx ebx, BYTE PTR Cmpi_tbl[ebx]                             ' Get translated Str1 byte into eax
    inc   edx                                                     ' Bump index
    dec   ecx                                                     ' Decr length left
    cmp   al, bl                                                  ' Compare Str1 translated to Str2 translated
    je    MainTest                                                ' Loop till done
    pop   ax                                                      ' Flush the length test held status from the stack

  RealMismatch:                                                   '
    jb    Str1Low                                                 ' If 1st string lowest, we are done
    inc   match                                                   ' Else 2nd string lower, set Match = 1
    jmp   short SetRC                                             ' Exit

   Str1Low:                                                       '
    dec   match                                                   ' 1st string low, set match to -1
    jmp   short SetRC                                             ' Exit

   AllEqual:                                                      ' All matched chars agree
    popf                                                          ' So use the result of the original length compare
    jnz   RealMismatch                                            ' If not equal, go set match status

   SetRC:                                                         '

   END PREFIX                                                     '
#DEBUG CODE ON                                                    '
   FUNCTION = match                                               ' Pass back our answer
   EXIT FUNCTION                                                  '
END FUNCTION                                                      '
