'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- BMacro.inc                                                                                      |
'--------------------------------------------------------------------------------------------------+
                                                                  '
FUNCTION MB_Call() AS LONG                                        '
'--------------------------------------------------------------------------------------------------+
'- Execute the macro in a seperate thread in case it loops                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL idThread AS DWORD                                           '
LOCAL Arg, RetVal, i, j, WC, WinCtr, lRet AS LONG                 '
LOCAL MSG, t AS STRING                                            '
   gMacNoLoopTest = %False: gMacroTrace = %False                  ' Reset Users no loop check flag and Trace flag
   gMacThread = CreateThread(BYVAL %Null, 0, CODEPTR(MB_CallThread), BYREF Arg, _   '
                        %THREAD_TERMINATE OR %THREAD_QUERY_INFORMATION, _  '
                        BYVAL VARPTR(idThread))                   '

   IF gMacThread <> %INVALID_HANDLE_VALUE THEN                    '
      DO                                                          '
         WC = WaitForSingleObject(gMacThread, 10000)              ' Give macro 10 seconds to execute
         SELECT CASE WC                                           ' What came back?

            CASE %WAIT_ABANDONED                                  '
               '-                                                 '
            CASE %WAIT_OBJECT_0                                   ' Thread did its job and ended by itself
               GetExitCodeThread(gMacThread, Retval)              '
               TP.CsrRow = TP.GPTop: TP.CsrCol = TP.GPCmdCol      ' Reset the command line
               TP.ErrMsgReset                                     ' Clear intermediate errors
               IF gMacroRC > 0 OR gMacroMsg <> "" THEN            ' Something to issue?
                  TP.ErrMsgAdd(gMacroRC, gMacroMsg)               ' Issue the RC and Msg
                  '--------------------------------------------------------------------------------+
                  '- If error in line command, clear comamnd line                                  |
                  '--------------------------------------------------------------------------------+
                  IF IsFMTab THEN                                 ' If FM then
                     j = IIF(gFMMacMode = 1, %True, %False)       ' Use gFMMacMode
                  ELSE                                            '
                     j = IIF(gEDMacMode = 1, %True, %False)       ' Use gEDMacMode
                  END IF                                          '
                  IF j THEN TP.pCommand = ""                      ' Null Cmd if a line command
               END IF                                             '
               CloseHandle gMacThread                             ' Clear handle
               gMacroMode = %False                                ' Turn off Macro mode
               KbdPopRestore                                      ' Reset popup state
               TP.AttnDo = (TP.AttnDo OR %Refresh)                ' Ask for refresh
               DoStatusBar($AllStatusBarBoxes)                    ' re-Do the StatusBar box in case something's changed
               EXIT DO                                            ' Done

            CASE %WAIT_TIMEOUT                                    ' Delay is over, see what to do
               IF gMacNoLoopTest THEN ITERATE DO                  ' User says to ignore loops
               IF GetWindowHandle("thinBasic :: Script RunTime error!", WinCtr) THEN ITERATE DO ' If thinbasic telling of an error, also exit
               MSG = "Macro may be looping," + $CRLF + "Select OK, to ignore loop and continue execution," + $CRLF + _  '
                     "Select Cancel to terminate the macro"       '
               i = DoMessageBox(MSG, %MB_USERICON OR %MB_OKCANCEL, "SPFLite Macro Loop Intercept") '
               IF i = %IDOK THEN                                  ' Continue?
                  ITERATE DO                                      ' Just keep waiting
               ELSE                                               '
                  TerminateThread BYVAL gMacThread, 999           ' Second value is thread exit code
                  SLEEP 500                                       ' Give thread time to end
                  GetExitCodeThread(gMacThread, Retval)           '
                  CloseHandle gMacThread                          ' Call CloseHandle after TerminateThread
                  TP.ErrMsgAdd(%eFail, "Macro was terminated")    '
                  KbdPopRestore                                   ' Do final reset
                  TP.AttnDo = (TP.AttnDo OR %Refresh)             ' Ask for refresh
                  gMacroMode = %False                             ' Turn off Macro mode
                  EXIT DO                                         '
               END IF                                             '
            CASE ELSE
               '
        END SELECT                                                '
        SLEEP 1                                                   '
      LOOP                                                        '
   ELSE                                                           '
     TP.ErrMsgAdd(%eFail, "Unable to start macro thread")         '
   END IF                                                         '

   IF ghDBFn <> 0 THEN                                            ' A DebugLog Active?
      CLOSE # ghDBFn                                              ' Close it
      RESET ghDBFn, ghDBFName                                     ' Reset file info
   END IF                                                         '
   TP.CsrRow = TP.GPTop: TP.CsrCol = TP.GPCmdCol                  ' reset the command line
   gLTblRange = %False                                            ' Reset line ranges
END FUNCTION                                                      '

SUB      MB_CallThread()                                          '
'--------------------------------------------------------------------------------------------------+
'- Handle the MACRO BASIC format                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL BasicPgm AS STRING, RCA AS RCArea                           '
LOCAL hLib_thinCore                  AS LONG                      ' Handle of thinCore.dll library
LOCAL hProc_thinBasic_Init           AS LONG                      ' Handle to Init function
LOCAL hProc_thinBasic_LoadSymbol     AS LONG                      ' Handle to LoadSymbol function
LOCAL hProc_thinBasic_AddIncludePath AS LONG                      ' Handle to AddIncludePath function
LOCAL hProc_thinBasic_AddVariable    AS LONG                      ' Handle to AddVariable function
LOCAL hProc_thinBasic_AddEquate      AS LONG                      ' Handle to AddEquate function
LOCAL hProc_thinBasic_Run            AS LONG                      ' Handle to Run function
LOCAL hProc_thinBasic_Release        AS LONG                      ' Handle to Release function
LOCAL lRet, i, j                     AS LONG                      '
   gMacroRC = 0: gMacroMsg = ""                                   ' Clear the RC and Msg

   '-----------------------------------------------------------------------------------------------+
   '- Save the Line control context at start of macro                                              |
   '-----------------------------------------------------------------------------------------------+
   gMacRange  = gLTblRange                                        ' Line control range at Macro start
   gMacSCmd   = TRIM$(gLTblSCmd)                                  '
   gMacSFrom  = gLTblSFrom                                        '
   gMacSTo    = gLTblSTo                                          '
   gMacSRpt   = gLTblSRpt                                         '
   gMacSFlag  = gLTblSFlag                                        '
   gMacDCmd   = TRIM$(gLTblDCmd)                                  '
   gMacDFrom  = gLTblDFrom                                        '
   gMacDTo    = gLTblDTo                                          '
   gMacDRpt   = gLTblDRpt                                         '
   gMacDFlag  = gLTblDFlag                                        '

   '-----------------------------------------------------------------------------------------------+
   '- Open and load thinCore.dll library                                                           |
   '-----------------------------------------------------------------------------------------------+
   hLib_thinCore = LoadLibraryA( BYCOPY "thinCore.Dll" )          '

   '-----------------------------------------------------------------------------------------------+
   '- If all went fine                                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF hLib_thinCore THEN                                          ' thinCore exists
      gMacCore = hLib_thinCore                                    ' Save Core address

      '--------------------------------------------------------------------------------------------+
      '- Try to load the functions                                                                 |
      '--------------------------------------------------------------------------------------------+
      hProc_thinBasic_Init           = GetProcAddress(hLib_thinCore, BYCOPY "thinBasic_Init")   '
      hProc_thinBasic_LoadSymbol     = GetProcAddress(hLib_thinCore, BYCOPY "thinBasic_LoadSymbol")   '
      hProc_thinBasic_AddVariable    = GetProcAddress(hLib_thinCore, BYCOPY "thinBasic_AddVariable")  '
      hProc_thinBasic_AddIncludePath = GetProcAddress(hLib_thinCore, BYCOPY "thinBasic_AddIncludePath")  '
      hProc_thinBasic_AddEquate      = GetProcAddress(hLib_thinCore, BYCOPY "thinBasic_AddEquate") '
      hProc_thinBasic_Run            = GetProcAddress(hLib_thinCore, BYCOPY "thinBasic_Run"     )  '
      hProc_thinBasic_Release        = GetProcAddress(hLib_thinCore, BYCOPY "thinBasic_Release" )  '
      gMacRelease = hProc_thinBasic_Release                       ' Save release for global use

      '--------------------------------------------------------------------------------------------+
      '- If all went fine ...                                                                      |
      '--------------------------------------------------------------------------------------------+
      IF hProc_thinBasic_Init           AND _                     '
         hProc_thinBasic_LoadSymbol     AND _                     '
         hProc_thinBasic_AddVariable    AND _                     '
         hProc_thinBasic_AddIncludePath AND _                     '
         hProc_thinBasic_AddEquate      AND _                     '
         hProc_thinBasic_Run            AND _                     '
         hProc_thinBasic_Release        THEN                      '

         '-----------------------------------------------------------------------------------------+
         '- Initialise all necessary functions etc.                                                |
         '-----------------------------------------------------------------------------------------+
         CALL DWORD hProc_thinBasic_Init USING thinBasic_Init(0, ghInstance, "thinBasic") '

         '-----------------------------------------------------------------------------------------+
         '- Add our Macro paths to thinBasic's #INCLUDE path                                       |
         '-----------------------------------------------------------------------------------------+
         IF ISNULL(gMaclib) THEN                                  ' If no MACLIB overrides
            CALL DWORD hProc_thinBasic_AddIncludePath USING thinBasic_AddIncludePath(gENV.HomeData + "MACROS\") '
         ELSE                                                     ' If there IS a MACLIB
            FOR i = 1 TO PARSECOUNT(gMacLibList, ";")             ' Add each file in the list
               CALL DWORD hProc_thinBasic_AddIncludePath USING thinBasic_AddIncludePath(PARSE$(gMaclibList, ";", i)) '
            NEXT i                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Go Add our SPFLite Functions                                                           |
         '-----------------------------------------------------------------------------------------+
         GOSUB AddFuncs                                           ' Add the functions

         '-----------------------------------------------------------------------------------------+
         '- Go Add our SPFLite Constants and Equates                                               |
         '-----------------------------------------------------------------------------------------+
         GOSUB AddConst                                           ' Add the constants

         '-----------------------------------------------------------------------------------------+
         '- Run the program                                                                        |
         '-----------------------------------------------------------------------------------------+
         BasicPgm = JOIN$(gMaclines(), $CRLF) + $CRLF             ' Join the array together
         gMacroMode = %True                                       ' Flag we are in Macro Mode
         KbdPopSave                                               ' Ready for pop-up
         CALL DWORD hProc_thinBasic_Run USING thinBasic_RUN( _    '
                                     0&                             , _ 'Will be used in future release
                                     BasicPgm                       , _ 'File name or string Buffer
                                     %thinBasic_BufferType_IsScript , _ 'Previous op is a File Name, or previous op is a string Buffer
                                     (1 OR 2)                       , _ 'Options (See below)
                                     %FALSE                         , _ 'Debug Mode      %TRUE/%FALSE
                                     %FALSE                         , _ 'Log Mode        %TRUE/%FALSE
                                     %FALSE                         , _ 'Obfuscate Mode  %TRUE/%FALSE
                                     1&                             , _ 'Calling Program 1=thinBasic, 2=Console
                                     %FALSE                           _ 'Dependancy Mode %TRUE/%FALSE
                                   ) TO lRet                      '
                                                                  ' Option 1 = use base directory from the executable running thinBasic_Run
                                                                  '            else thinBasic itself
                                                                  ' Option 2 = In case of script run-time ERROR, DO NOT CLOSE calling application too.
                                                                  '            If this option is omitted, thinBasic will fire a PostQuitMessage

         '-----------------------------------------------------------------------------------------+
         '- Unload all modules, release all memory                                                 |
         '-----------------------------------------------------------------------------------------+
         CALL DWORD hProc_thinBasic_Release USING thinBasic_Release(0&  _  'Will be used in future release
                                                                    ) TO lRet '
         '-----------------------------------------------------------------------------------------+
         '- Free loaded thinCore library                                                           |
         '-----------------------------------------------------------------------------------------+
         FreeLibrary(hLib_thinCore)                               '
      ELSE                                                        '
         TP.ErrMsgAdd(%eFail, "Internal thinBasic functions not found") ' Error
      END IF                                                      '
   ELSE                                                           '
      TP.ErrMsgAdd(%eFail, "thinBasic does not appear to be installed") ' Say why we didn't do it
   END IF                                                         '
   EXIT SUB                                                       '

   AddFuncs:
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get$",                  %thinBasic_ReturnCodeString,CODEPTR(TryGetS))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get#",                  %thinBasic_ReturnCodeLong,  CODEPTR(TryGetN))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("TestIt",                %thinBasic_ReturnCodeLong,  CODEPTR(Testit))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Delete_Gbl_Num",        %thinBasic_ReturnCodeLong,  CODEPTR(Delete_GBLNUM))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Delete_Gbl_Num",        %thinBasic_ReturnCodeLong,  CODEPTR(Delete_GBLNUM))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Delete_Gbl_Str",        %thinBasic_ReturnCodeLong,  CODEPTR(Delete_GBLSTR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Drop_Handle$",          %thinBasic_ReturnString,    CODEPTR(Drop_HANDLE))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("First_Handle$",         %thinBasic_ReturnString,    CODEPTR(First_Handle)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Add_Line",              %thinBasic_ReturnCodeLong,  CODEPTR(Add_Line))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Add_Array",             %thinBasic_ReturnCodeLong,  CODEPTR(Add_Array)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Mode",            %thinBasic_ReturnCodeLong,  CODEPTR(FMGet_Mode))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_AbbrevName$",     %thinBasic_ReturnString,    CODEPTR(FMGet_AbbrevName))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Attr$",           %thinBasic_ReturnString,    CODEPTR(FMGet_Attr))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Backup_Versions", %thinBasic_ReturnCodeLong,  CODEPTR(FMGet_Backup_Versions)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FilePath$",       %thinBasic_ReturnString,    CODEPTR(FMGet_FilePath))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FilePattern$",    %thinBasic_ReturnString,    CODEPTR(FMGet_FilePattern))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FListName$",      %thinBasic_ReturnString,    CODEPTR(FMGet_FListName)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FCount",          %thinBasic_ReturnCodeLong,  CODEPTR(FMGet_FCount)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FType",           %thinBasic_ReturnCodeLong,  CODEPTR(FMGet_FType))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Path$",           %thinBasic_ReturnString,    CODEPTR(FMGet_Path))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Folder_Class",    %thinBasic_ReturnCodeLong,  CODEPTR(FMGet_Folder_Class)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_File_Class",      %thinBasic_ReturnCodeLong,  CODEPTR(FMGet_File_Class))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FileName$",       %thinBasic_ReturnString,    CODEPTR(FMGet_FileName))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Extension$",      %thinBasic_ReturnString,    CODEPTR(FMGet_Extension)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FileSize",        %thinBasic_ReturnCodeQuad,  CODEPTR(FMGet_FileSize))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Lines",           %thinBasic_ReturnCodeLong,  CODEPTR(FMGet_Lines))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_Cmd$",            %thinBasic_ReturnString,    CODEPTR(FMGet_Cmd)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FileAttributes",  %thinBasic_ReturnCodeDWord, CODEPTR(FMGet_Attributes))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_CreationTime$",   %thinBasic_ReturnString,    CODEPTR(FMGet_CreateTime))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_LastWriteTime$",  %thinBasic_ReturnString,    CODEPTR(FMGet_WriteTimeC))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_FileSize$",       %thinBasic_ReturnString,    CODEPTR(FMGet_FileSizeC)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_PRP1$",           %thinBasic_ReturnString,    CODEPTR(FMGet_PRP1))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_PRP2$",           %thinBasic_ReturnString,    CODEPTR(FMGet_PRP2))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_PRP3$",           %thinBasic_ReturnString,    CODEPTR(FMGet_PRP3))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_PRP4$",           %thinBasic_ReturnString,    CODEPTR(FMGet_PRP4))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_PRP5$",           %thinBasic_ReturnString,    CODEPTR(FMGet_PRP5))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMGet_PRP6$",           %thinBasic_ReturnString,    CODEPTR(FMGet_PRP6))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMSet_Cmd",             %thinBasic_ReturnCodeLong,  CODEPTR(FMSet_Cmd)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMSet_Msg",             %thinBasic_ReturnCodeLong,  CODEPTR(FMSet_Msg)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMSet_FilePath",        %thinBasic_ReturnCodeLong,  CODEPTR(FMSet_FilePath))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("FMSet_FilePattern",     %thinBasic_ReturnCodeLong,  CODEPTR(FMSet_FilePattern))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_ANSI2Source_Table$",%thinBasic_ReturnString,    CODEPTR(Get_ANSI2SOURCE)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg$",              %thinBasic_ReturnString,    CODEPTR(Get_ARG))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_Count",         %thinBasic_ReturnNumber,    CODEPTR(Get_ARGCOUNT)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_KW",            %thinBasic_ReturnNumber,    CODEPTR(Get_ARGKW)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_KWGroup$",      %thinBasic_ReturnString,    CODEPTR(Get_ARGKWGROUP))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_LRef$",         %thinBasic_ReturnString,    CODEPTR(Get_ARGLRef))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_LRef_Count",    %thinBasic_ReturnNumber,    CODEPTR(Get_ARGLRef_Count))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_NumLit$",       %thinBasic_ReturnString,    CODEPTR(Get_ARGNumLit))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_NumLit_Count",  %thinBasic_ReturnNumber,    CODEPTR(Get_ARGNumLit_Count))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_Tag$",          %thinBasic_ReturnString,    CODEPTR(Get_ARGTag))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_Tag_Count",     %thinBasic_ReturnNumber,    CODEPTR(Get_ARGTag_Count))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_TextLit$",      %thinBasic_ReturnString,    CODEPTR(Get_ARGTextLit))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Arg_TextLit_Count", %thinBasic_ReturnNumber,    CODEPTR(Get_ARGTextLit_Count))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_BNDSLine$",         %thinBasic_ReturnString,    CODEPTR(Get_BNDSLine)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_BottomScrn_LNum",   %thinBasic_ReturnNumber,    CODEPTR(Get_BOTSCREENLNum))'
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_BottomScrn_LPtr",   %thinBasic_ReturnNumber,    CODEPTR(Get_BOTSCREEN))'
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Clr_Line$",         %thinBasic_ReturnString,    CODEPTR(Get_ClrLine))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Csr_Col",           %thinBasic_ReturnNumber,    CODEPTR(Get_CSRCOL))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Csr_LNum",          %thinBasic_ReturnNumber,    CODEPTR(Get_CsrLNum))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Csr_LPtr",          %thinBasic_ReturnNumber,    CODEPTR(Get_CSRLPtr))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Curr_Line$",        %thinBasic_ReturnString,    CODEPTR(Get_CURRLINE)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Curr_Path$",        %thinBasic_ReturnString,    CODEPTR(Get_CURRPATH)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Curr_Word$",        %thinBasic_ReturnString,    CODEPTR(Get_CURRWORD)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Dest1_LPtr",        %thinBasic_ReturnNumber,    CODEPTR(Get_DESTL1))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Dest2_LPtr",        %thinBasic_ReturnNumber,    CODEPTR(Get_DESTL2))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Dest_LCmd$",        %thinBasic_ReturnString,    CODEPTR(Get_DESTLCMD)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Dest_LMod$",        %thinBasic_ReturnString,    CODEPTR(Get_DESTLMOD)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Dest_Op",           %thinBasic_ReturnNumber,    CODEPTR(Get_DESTOP))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_ENVVar$",           %thinBasic_ReturnString,    CODEPTR(Get_SYSVAR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_EOL_Str$",          %thinBasic_ReturnString,    CODEPTR(Get_EOLSTR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_EXEFullName$",      %thinBasic_ReturnString,    CODEPTR(Get_EXEFullName))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_EXE_Path$",         %thinBasic_ReturnString,    CODEPTR(Get_EXEPath))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_FileBase$",         %thinBasic_ReturnString,    CODEPTR(Get_FileBase)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_FileDate$",         %thinBasic_ReturnString,    CODEPTR(Get_FileDate)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_FileExt$",          %thinBasic_ReturnString,    CODEPTR(Get_FileExt))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_FileFull$",         %thinBasic_ReturnString,    CODEPTR(Get_FileFull)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_FileName$",         %thinBasic_ReturnString,    CODEPTR(Get_FileName)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_FilePath$",         %thinBasic_ReturnString,    CODEPTR(Get_FilePath)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_FileTime$",         %thinBasic_ReturnString,    CODEPTR(Get_FileTime)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_COL",          %thinBasic_ReturnNumber,    CODEPTR(Get_Find1stCol))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_First_Col",    %thinBasic_ReturnNumber,    CODEPTR(Get_Find1stCol))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_First_Len",    %thinBasic_ReturnNumber,    CODEPTR(Get_Find1stLen))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_First_LPtr",   %thinBasic_ReturnNumber,    CODEPTR(Get_Find1stLin))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_First_LNum",   %thinBasic_ReturnNumber,    CODEPTR(Get_Find1stLinLNum))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_Last_Col",     %thinBasic_ReturnNumber,    CODEPTR(Get_FindLstCol))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_Last_Len",     %thinBasic_ReturnNumber,    CODEPTR(Get_FindLstLen))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_Last_LPtr",    %thinBasic_ReturnNumber,    CODEPTR(Get_FindLstLin))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_Last_LNum",    %thinBasic_ReturnNumber,    CODEPTR(Get_FindLstLinLNum))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_Len",          %thinBasic_ReturnNumber,    CODEPTR(Get_Find1stLen))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Find_LPtr",         %thinBasic_ReturnNumber,    CODEPTR(Get_Find1stLin))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_First_LPtr",        %thinBasic_ReturnNumber,    CODEPTR(Get_FIRST))       '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_First_LNum",        %thinBasic_ReturnNumber,    CODEPTR(Get_FIRSTLNum))       '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_First_Real_LPtr",   %thinBasic_ReturnNumber,    CODEPTR(Get_FIRSTREAL))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_First_Real_LNum",   %thinBasic_ReturnNumber,    CODEPTR(Get_FIRSTREALLNum))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Num",           %thinBasic_ReturnNumber,    CODEPTR(Get_GBLNUM))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Num_Count",     %thinBasic_ReturnNumber,    CODEPTR(Get_GBLNUMCOUNT)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Num_Name$",     %thinBasic_ReturnString,    CODEPTR(Get_GBLNUMNAME))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Num_TableName$",%thinBasic_ReturnString,    CODEPTR(Get_GBLNUMTABLENAME))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Str$",          %thinBasic_ReturnString,    CODEPTR(Get_GBLSTR))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Str_Count",     %thinBasic_ReturnNumber,    CODEPTR(Get_GBLSTRCOUNT)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Str_Name$",     %thinBasic_ReturnString,    CODEPTR(Get_GBLSTRNAME))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Gbl_Str_TableName$",%thinBasic_ReturnString,    CODEPTR(Get_GBLSTRTABLENAME))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Handle$",           %thinBasic_ReturnString,    CODEPTR(Get_Handle))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_HomeData$",         %thinBasic_ReturnString,    CODEPTR(Get_HomeData))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_HomeFolder$",       %thinBasic_ReturnString,    CODEPTR(Get_HomeFolder))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_INI_Path$",         %thinBasic_ReturnString,    CODEPTR(Get_INIPath))     '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Instance$",         %thinBasic_ReturnString,    CODEPTR(Get_INSTANCE))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Label$",            %thinBasic_ReturnString,    CODEPTR(Get_Label))       '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Last_LPtr",         %thinBasic_ReturnNumber,    CODEPTR(Get_LAST))        '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Last_LNum",         %thinBasic_ReturnNumber,    CODEPTR(Get_LASTLNum))        '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Last_Real_LPtr",    %thinBasic_ReturnNumber,    CODEPTR(Get_LASTREAL))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Last_Real_LNum",    %thinBasic_ReturnNumber,    CODEPTR(Get_LASTREALLNum))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_LBound",            %thinBasic_ReturnNumber,    CODEPTR(Get_LBOUND))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_LeftScrn_Col",      %thinBasic_ReturnNumber,    CODEPTR(Get_LeftScrnCol)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Line$",             %thinBasic_ReturnString,    CODEPTR(Get_LINE))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_LNum_Width",        %thinBasic_ReturnNumber,    CODEPTR(Get_LineNumSize))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Line_Len",          %thinBasic_ReturnNumber,    CODEPTR(Get_LINELEN))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Line_Type$",        %thinBasic_ReturnString,    CODEPTR(Get_LINETYPE)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_LNum",              %thinBasic_ReturnNumber,    CODEPTR(Get_LNum))        '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Loc_LPtr",          %thinBasic_ReturnNumber,    CODEPTR(Get_LOCLIN))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Loc_LNum",          %thinBasic_ReturnNumber,    CODEPTR(Get_LOCLINLNum))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_LPtr",              %thinBasic_ReturnNumber,    CODEPTR(Get_LPtr))     '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_MacName$",          %thinBasic_ReturnString,    CODEPTR(Get_MacName))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_MarkLine$",         %thinBasic_ReturnString,    CODEPTR(Get_MarkLine)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_MaskLine$",         %thinBasic_ReturnString,    CODEPTR(Get_MaskLine)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Modified",          %thinBasic_ReturnNumber,    CODEPTR(Get_MODIFIED)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Modified_FileName", %thinBasic_ReturnNumber,    CODEPTR(Get_MODIFIEDFILENAME))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Msg$",              %thinBasic_ReturnString,    CODEPTR(Get_MSG))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Next_LPtr",         %thinBasic_ReturnNumber,    CODEPTR(Get_NextLPtr)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Panl_Height",       %thinBasic_ReturnNumber,    CODEPTR(Get_PanlHeight))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Panl_Mode$",        %thinBasic_ReturnString,    CODEPTR(Get_PanlMode))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Panl_Width",        %thinBasic_ReturnNumber,    CODEPTR(Get_PanlWidth))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Primary_Cmd$",      %thinBasic_ReturnString,    CODEPTR(Get_PrimCmd))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Profile$",          %thinBasic_ReturnString,    CODEPTR(Get_ProfString))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_RBound",            %thinBasic_ReturnNumber,    CODEPTR(Get_RBOUND))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_RC",                %thinBasic_ReturnNumber,    CODEPTR(Get_RC))       '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_RightScrn_Col",     %thinBasic_ReturnNumber,    CODEPTR(Get_RightScrnCol))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Scrn_Height",       %thinBasic_ReturnNumber,    CODEPTR(Get_ScrHeight))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Scrn_Width",        %thinBasic_ReturnNumber,    CODEPTR(Get_ScrWidth))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Select_Col",        %thinBasic_ReturnNumber,    CODEPTR(Get_SelCol))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Select_First_LPtr", %thinBasic_ReturnNumber,    CODEPTR(Get_SelFirst)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Select_First_LNum", %thinBasic_ReturnNumber,    CODEPTR(Get_SelFirstLNum)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Select_Last_LPtr",  %thinBasic_ReturnNumber,    CODEPTR(Get_SelLast))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Select_Last_LNum",  %thinBasic_ReturnNumber,    CODEPTR(Get_SelLastLNum))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Select_Len",        %thinBasic_ReturnNumber,    CODEPTR(Get_SelLen))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Session_Type$",     %thinBasic_ReturnString,    CODEPTR(Get_SESSIONTYPE)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_SETVar$",           %thinBasic_ReturnString,    CODEPTR(Get_SETVAR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Source2ANSI_Table$",%thinBasic_ReturnString,    CODEPTR(Get_SOURCE2ANSI)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_SPF_Version$",      %thinBasic_ReturnString,    CODEPTR(Get_SPFVersion))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Src1_LPtr",         %thinBasic_ReturnNumber,    CODEPTR(Get_SRCL1))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Src1_LNum",         %thinBasic_ReturnNumber,    CODEPTR(Get_SRCL1LNum))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Src2_LPtr",         %thinBasic_ReturnNumber,    CODEPTR(Get_SRCL2))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Src2_LNum",         %thinBasic_ReturnNumber,    CODEPTR(Get_SRCL2LNum))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Src_LCmd$",         %thinBasic_ReturnString,    CODEPTR(Get_SRCLCMD))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Src_LMod$",         %thinBasic_ReturnString,    CODEPTR(Get_SRCLMOD))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Src_Op",            %thinBasic_ReturnNumber,    CODEPTR(Get_SRCOP))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_TabNum",            %thinBasic_ReturnNumber,    CODEPTR(Get_TabNum))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_TabsLine$",         %thinBasic_ReturnString,    CODEPTR(Get_TabsLine)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Tag$",              %thinBasic_ReturnString,    CODEPTR(Get_Tag))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_TopScrn_LPtr",      %thinBasic_ReturnNumber,    CODEPTR(Get_TOPSCREEN))'
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_TopScrn_LNum",      %thinBasic_ReturnNumber,    CODEPTR(Get_TOPSCREENLNum))'
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Trk_LPtr",          %thinBasic_ReturnNumber,    CODEPTR(Get_TrkLPtr))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Trk_Pos$",          %thinBasic_ReturnString,    CODEPTR(Get_TrkPos))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Trk_TrkID",         %thinBasic_ReturnNumber,    CODEPTR(Get_TrkTrkID)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Text_Columns",      %thinBasic_ReturnNumber,    CODEPTR(Get_TxtColumns))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Text_Lines",        %thinBasic_ReturnNumber,    CODEPTR(Get_TxtLines))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Uniq_ID",           %thinBasic_ReturnNumber,    CODEPTR(Get_UniqueID)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_WordChars",         %thinBasic_ReturnString,    CODEPTR(Get_WordChar)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_Working_Dir$",      %thinBasic_ReturnString,    CODEPTR(Get_WorkingDir))
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_XLines",            %thinBasic_ReturnNumber,    CODEPTR(Get_XLines))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Get_XStatus$",          %thinBasic_ReturnString,    CODEPTR(Get_XStatus))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("HALT",                  %thinBasic_ReturnNumber,    CODEPTR(HALT))         '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Has_Handle",            %thinBasic_ReturnNumber,    CODEPTR(Has_HANDLE))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Available",          %thinBasic_ReturnNumber,    CODEPTR(ISAVAILABLEF)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_BNDS",               %thinBasic_ReturnNumber,    CODEPTR(Is_BNDS))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Bottom",             %thinBasic_ReturnNumber,    CODEPTR(Is_BOTTOM))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Cmd_Name$",          %thinBasic_ReturnString,    CODEPTR(ISCmdName))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Cols",               %thinBasic_ReturnNumber,    CODEPTR(Is_COLS))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Data",               %thinBasic_ReturnNumber,    CODEPTR(Is_DATA))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_File",               %thinBasic_ReturnNumber,    CODEPTR(Is_FILE))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_FM",                 %thinBasic_ReturnCodeLong,  CODEPTR(Is_FM))        '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Line_Cmd",           %thinBasic_ReturnNumber,    CODEPTR(Is_LineCmd))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_MARK",               %thinBasic_ReturnNumber,    CODEPTR(Is_MARK))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_MASK",               %thinBasic_ReturnNumber,    CODEPTR(Is_MASK))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_NOTE",               %thinBasic_ReturnNumber,    CODEPTR(Is_NOTE))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Page",               %thinBasic_ReturnNumber,    CODEPTR(Is_PAGE))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Primary_Cmd",        %thinBasic_ReturnNumber,    CODEPTR(Is_PrimCmd))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_PROF",               %thinBasic_ReturnNumber,    CODEPTR(Is_PROF))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_TABS",               %thinBasic_ReturnNumber,    CODEPTR(Is_TABS))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_Top",                %thinBasic_ReturnNumber,    CODEPTR(Is_TOP))       '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_ULine",              %thinBasic_ReturnNumber,    CODEPTR(Is_ULINE))     '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_WORD",               %thinBasic_ReturnNumber,    CODEPTR(Is_WORD))      '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_XLine",              %thinBasic_ReturnNumber,    CODEPTR(Is_XLine))     '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Is_XMarker",            %thinBasic_ReturnNumber,    CODEPTR(Is_XMARKER))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Last_Handle$",          %thinBasic_ReturnString,    CODEPTR(Last_Handle))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Next_Handle$",          %thinBasic_ReturnString,    CODEPTR(Next_Handle))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("NOP",                   %thinBasic_ReturnNumber,    CODEPTR(NOP))          '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("OF",                    %thinBasic_ReturnNumber,    CODEPTR(OV))           '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Prev_Handle$",          %thinBasic_ReturnString,    CODEPTR(Prev_Handle))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Release_Label$",        %thinBasic_ReturnString,    CODEPTR(Drop_HANDLE))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Request_Label$",        %thinBasic_ReturnString,    CODEPTR(Get_Handle))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Reset_Gbl_Num",         %thinBasic_ReturnNumber,    CODEPTR(Reset_GBLNUM)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Reset_Gbl_Str",         %thinBasic_ReturnNumber,    CODEPTR(Reset_GBLSTR)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Restore_SrchArgs",      %thinBasic_ReturnNumber,    CODEPTR(ParseLoad))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Save_SrchArgs",         %thinBasic_ReturnNumber,    CODEPTR(ParseSave))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_Clr_Line",          %thinBasic_ReturnNumber,    CODEPTR(Set_ClrLine))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_CSR",               %thinBasic_ReturnNumber,    CODEPTR(Set_CSR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_Gbl_Num",           %thinBasic_ReturnNumber,    CODEPTR(Set_GBLNUM))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_Gbl_Str",           %thinBasic_ReturnNumber,    CODEPTR(Set_GBLSTR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_LCsr",              %thinBasic_ReturnNumber,    CODEPTR(Set_LCSR))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_Line",              %thinBasic_ReturnNumber,    CODEPTR(Set_LINE))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_MARK",              %thinBasic_ReturnNumber,    CODEPTR(Set_MARK))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_MASK",              %thinBasic_ReturnNumber,    CODEPTR(Set_MASK))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_Msg",               %thinBasic_ReturnNumber,    CODEPTR(Set_MSG))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_SETVar",            %thinBasic_ReturnNumber,    CODEPTR(Set_SETVAR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_TABS",              %thinBasic_ReturnNumber,    CODEPTR(Set_TABS))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_TopScrn_LPtr",      %thinBasic_ReturnNumber,    CODEPTR(Set_TOPSCREEN))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("Set_WORD",              %thinBasic_ReturnNumber,    CODEPTR(Set_WORD))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Cmd",               %thinBasic_ReturnNumber,    CODEPTR(SPF_CMD))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Comment",           %thinBasic_ReturnNumber,    CODEPTR(SPF_COMMENT))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Debug",             %thinBasic_ReturnNumber,    CODEPTR(SPF_Debug)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_DebugLog",          %thinBasic_ReturnNumber,    CODEPTR(SPF_DebugLog)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_EXEC",              %thinBasic_ReturnNumber,    CODEPTR(SPF_EXEC))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Exempt_File",       %thinBasic_ReturnNumber,    CODEPTR(SPF_Exempt_File)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_FMLCmd",            %thinBasic_ReturnCodeLong,  CODEPTR(FMRun_LCmd))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Ins",               %thinBasic_ReturnNumber,    CODEPTR(SPF_INS))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_InvChars$",         %thinBasic_ReturnString,    CODEPTR(SPF_INVCHARS)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Loop_Check",        %thinBasic_ReturnNumber,    CODEPTR(SPF_LOOPCHECK))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Ovr",               %thinBasic_ReturnNumber,    CODEPTR(SPF_OVR))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Ovr_Rep",           %thinBasic_ReturnNumber,    CODEPTR(SPF_OVR_REP))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Parse",             %thinBasic_ReturnNumber,    CODEPTR(SPF_PARSE)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Post_Do",           %thinBasic_ReturnNumber,    CODEPTR(SPF_POST_DO))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Quote$",            %thinBasic_ReturnString,    CODEPTR(SPF_QUOTE)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Rep",               %thinBasic_ReturnNumber,    CODEPTR(SPF_REP))   '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Shell",             %thinBasic_ReturnNumber,    CODEPTR(SPF_SHELL))    '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_SpellChk$",         %thinBasic_ReturnString,    CODEPTR(MacSpellChk))  '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_Trace",             %thinBasic_ReturnNumber,    CODEPTR(SPF_Trace)) '
      CALL DWORD hProc_thinBasic_LoadSymbol USING thinBasic_LoadSymbol("SPF_UnQuote$",          %thinBasic_ReturnString,    CODEPTR(SPF_UNQUOTE))  '
   RETURN                                                         '

   AddConst:
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("OK",    "", 0,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("WARN",  "", 8,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FAIL",  "", 8,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("ON",    "", 1,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("OFF",   "", 0,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("ERROR", "", 2,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("YES",   "", 1,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("NO",    "", 0,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("SYNC",  "", 0,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("ASYNC", "", 1,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("NORMAL","", 1,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("HIDDEN","", 0,        %EquateTypeNumber)   '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("ARG_OPT","", 256,     %EquateTypeNumber)   ' X'00000100'
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("ARG_DEF","", 512,     %EquateTypeNumber)   ' X'00000200'
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("ARG_VAR","", 1024,    %EquateTypeNumber)   ' X'00000400'
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_FLISTData",    "", 0,          %EquateTypeNumber)  '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_FilePath",     "", 1,          %EquateTypeNumber)  '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Recent",        "", 2,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Found",         "", 3,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Opened",        "", 4,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Favorites",     "", 5,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_FLISTS",        "", 6,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Paths",         "", 7,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Configs",       "", 8,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Profiles",      "", 8,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_DirUp",         "", 1,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_DirDown",       "", 2,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_File",          "", 3,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Path",          "", 4,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_FList",         "", 5,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Profile",       "", 6,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_ReadOnly",      "", &H00000001, %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Hidden",        "", &H00000002, %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_System",        "", &H00000004, %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Directory",     "", &H00000010, %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Archive",       "", &H00000020, %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Data_File",     "", 1,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Backup_Data",   "", 2,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Backup_State",  "", 3,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Normal_Folder", "", 1,          %EquateTypeNumber) '
      CALL DWORD hProc_thinBasic_AddVariable USING thinBasic_AddVariable("FM_EQU_Backup_Folder", "", 2,          %EquateTypeNumber) '
   RETURN                                                         '

END SUB                                                           '

SUB       DoTrace()                                               '
'--------------------------------------------------------------------------------------------------+
'- Display a trace line                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING                                             '
   IF gMacroTrace = 0 THEN EXIT SUB                               ' Leave quickly if not tracing
   IF gmacroTrace = 2 AND TP.ErrMsgHigh = 0 THEN EXIT SUB         ' Also if ERR only and no error
   ltext = gMacroTHeader + " RC=" + FORMAT$(TP.ErrMsgHigh) + " " + TP.ErrMsgTop + " []"   '
   DEBUG lText                                                    ' Display it
END SUB                                                           '

SUB       DoTraceS(result AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Display a trace line                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING                                             '
   IF gMacroTrace = 0 THEN EXIT SUB                               ' Leave quickly if not tracing
   IF gmacroTrace = 2 AND TP.ErrMsgHigh = 0 THEN EXIT SUB         ' Also if ERR only and no error
   ltext = gMacroTHeader + " RC=" + FORMAT$(TP.ErrMsgHigh) + " " + TP.ErrMsgTop + " [" + LEFT$(result, 32) + "]"  '
   DEBUG lText                                                    ' Display it
END SUB                                                           '

SUB       DoTraceN(result AS LONG)                                '
'--------------------------------------------------------------------------------------------------+
'- Display a trace line                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING                                             '
   IF gMacroTrace = 0 THEN EXIT SUB                               ' Leave quickly if not tracing
   IF gmacroTrace = 2 AND TP.ErrMsgHigh = 0 THEN EXIT SUB         ' Also if ERR only and no error
   ltext = gMacroTHeader + " RC=" + FORMAT$(TP.ErrMsgHigh) + " " + TP.ErrMsgTop + " [" + FORMAT$(result) + "]" '
   DEBUG lText                                                    ' Display it
END SUB                                                           '

FUNCTION Delete_GBLNUM() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Delete a GBL variable                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL varname AS STRING, i, RC AS LONG                            '
   IF MACParseIS("", "Delete_Gbl_Num", i, varname) THEN DoTrace: EXIT FUNCTION   '
   varname = FORMAT$(i) + "," + varname                           ' Format the name
   IF ISNULL(varname) THEN                                        ' Ignore null requests
      FUNCTION = 0                                                ' Return OK
      DoTrace                                                     ' Do trace if needed
      EXIT FUNCTION                                               '
   END IF                                                         '
   RC = gNumVar.Remove(varname)                                   ' Try the removal
   IF RC <> 0 THEN                                                ' Error?
      FUNCTION = 8: TP.ErrMsgAdd(8, "Delete was unsuccessful")    ' Return code
   ELSE                                                           '
      FUNCTION = 0                                                ' Return OK
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Delete_GBLSTR() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Delete a GBL variable                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL varname AS STRING, i, RC AS LONG                            '
   IF MACParseIS("", "Delete_Gbl_Str", i, varname) THEN DoTrace: EXIT FUNCTION   '
   varname = FORMAT$(i) + "," + varname                           ' Format the name
   IF ISNULL(varname) THEN                                        ' Ignore null requests
      FUNCTION = 0                                                ' Return OK
      DoTrace                                                     ' Do trace if needed
      EXIT FUNCTION                                               '
   END IF                                                         '
   RC = gStrVar.Remove(varname)                                   ' Try the removal
   IF RC <> 0 THEN                                                ' Error?
      FUNCTION = 8: TP.ErrMsgAdd(8, "Delete was unsuccessful")    ' Return code
   ELSE                                                           '
      FUNCTION = 0                                                ' Return OK
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION MacParseI(MMode AS STRING, tHeader AS STRING, Ans AS LONG, OPT low AS LONG, OPT high AS LONG) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Parse out a single Integer                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL lIndex AS EXT                                               '
REGISTER i AS LONG                                                '
   gMacroTHeader = tHeader + "() "                                ' Build a basic trace header
   IF MMode = "F" THEN QNotFM(tHeader)                            ' Ensure we're in correct mode
   IF MMode = "E" THEN QNotEdit(tHeader)                          '
   IF thinBasic_CheckOpenParens THEN                              ' Better have a Open (
      thinBasic_ParseNumber lIndex                                ' Get the Index
      IF thinBasic_CheckCloseParens THEN                          ' Better be a closing )
         gMacroTHeader = tHeader + "(" + FORMAT$(lIndex) + ") "   ' Set proper trace header
         Ans = lIndex                                             ' Convert to LONG and pass back
         IF ISMISSING(low) THEN EXIT FUNCTION                     ' Optional range check? No, we're done
         IF Ans >= low AND Ans <= high THEN EXIT FUNCTION         ' If in range, we're done
         FUNCTION = 8: TP.ErrMsgAdd(8, "Invalid " + tHeader + " operand value")  '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION MacParseII(MMode AS STRING, tHeader AS STRING, Ans1 AS LONG, Ans2 AS LONG, OPT low AS LONG, OPT high AS LONG) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Parse out a two Integer                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lIndex AS EXT                                               '
REGISTER i AS LONG                                                '
   gMacroTHeader = tHeader + "() "                                ' Build a basic trace header
   IF MMode = "F" THEN QNotFM(tHeader)                            ' Ensure we're in correct mode
   IF MMode = "E" THEN QNotEdit(tHeader)                          '
   IF thinBasic_CheckOpenParens THEN                              ' Better have a Open (
      thinBasic_ParseNumber lIndex                                ' Get the Index
      Ans1 = lIndex                                               ' Save as answer 1
      IF thinBasic_CheckComma() THEN                              ' A Comma?
         thinBasic_ParseNumber lIndex                             ' Then get the 2nd number
         Ans2 = lIndex                                            ' Pass it back
         IF thinBasic_CheckCloseParens THEN                       ' Better be a closing )
            gMacroTHeader = tHeader + "(" + FORMAT$(Ans1) + "," + FORMAT$(ans2) +  ") "   ' Set proper trace header
            IF ISMISSING(low) THEN EXIT FUNCTION                  ' Optional range check? No, we're done
            IF ans1 >= low AND ans1 <= high THEN EXIT FUNCTION    ' If in range, we're done
            FUNCTION = 8: TP.ErrMsgAdd(8, "Invalid " + tHeader + " operand value")  '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION MacParseIIS(MMode AS STRING, tHeader AS STRING, one AS LONG, two AS LONG, str AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Parse out two integers and a string                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL lIndex AS EXT                                               '
   gMacroTHeader = tHeader + "() "                                ' Build a basic trace header
   IF MMode = "F" THEN QNotFM(tHeader)                            ' Ensure we're in correct mode
   IF MMode = "E" THEN QNotEdit(tHeader)                          '
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      thinBasic_ParseNumber lIndex                                ' Then get the 1st number
      one = lIndex                                                ' Pass it back
      IF thinBasic_CheckComma() THEN                              ' A Comma?
         thinBasic_ParseNumber lIndex                             ' Then get the 2nd number
         two = lIndex                                             ' Pass it back
         IF thinBasic_CheckComma() THEN                           ' A Comma?
            thinBasic_ParseString str                             ' Get the 3rd
            IF thinBasic_CheckCloseParens THEN                    ' And if closed by ) properly
               gMacroTHeader = tHeader + "(" + FORMAT$(one) + ", " + FORMAT$(two) + ", " + str + ") " ' Set proper trace header
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION MacParseS(MMode AS STRING, tHeader AS STRING, Ans AS STRING) AS LONG '
'--------------------------------------------------------------------------------------------------+
'- Parse out a single String                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lTxt AS STRING                                              '
REGISTER i AS LONG                                                '
   gMacroTHeader = tHeader + "() "                                ' Build a basic trace header
   IF MMode = "F" THEN QNotFM(tHeader)                            ' Ensure we're in correct mode
   IF MMode = "E" THEN QNotEdit(tHeader)                          '
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      thinBasic_ParseString lTxt                                  ' Then get the string
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         gMacroTHeader = tHeader + "(" + lTxt + ") "              ' Set proper trace header
         Ans = lTxt                                               ' Pass it back
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION MacParseIS(MMode AS STRING, tHeader AS STRING, IAns AS LONG, SAns AS STRING) AS LONG   '
'--------------------------------------------------------------------------------------------------+
'- Parse out a number and a string                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL tText AS STRING, iExt AS EXT, lRet AS LONG                  '
   gMacroTHeader = tHeader + "() "                                ' Build a basic trace header
   IF MMode = "F" THEN QNotFM(tHeader)                            ' Ensure we're in correct mode
   IF MMode = "E" THEN QNotEdit(tHeader)                          '
   IAns = 0: SAns = ""                                            ' Default answers
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber iExt                               ' Then get the numeric operand
         iAns = iExt                                              '
         IF thinBasic_CheckComma(%True, %True) THEN               ' A comma?
            thinBasic_ParseString sAns                            ' Then get the string
            DO WHILE thinBasic_CheckComma(%True, %True)           ' A Comma?
               thinBasic_ParseString tText                        ' Then get the next string
               sAns += " " + tText                                ' Add it to the string
            LOOP                                                  '
         END IF                                                   '
      ELSEIF thinBasic_DetermineType = %thinBasic_ReturnString THEN  ' A string?                                                   '
         thinBasic_ParseString sAns                               ' Then get the string
         DO WHILE thinBasic_CheckComma(%True, %True)              ' A Comma?
            thinBasic_ParseString tText                           ' Then get the next string
            sAns += " " + tText                                   ' Add it to the string
         LOOP                                                     '
      END IF                                                      '
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         gMacroTHeader = tHeader + "(" + FORMAT$(IAns) + ", " + SAns + ") "   '
      END IF                                                      '
   END IF                                                         '
   FUNCTION = 0                                                   ' All is well.
END FUNCTION                                                      '

FUNCTION Add_Array(BYVAL pObject AS LONG) AS LONG                 '
'--------------------------------------------------------------------------------------------------+
'- Add a whole Array to the edit session                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL ArrayName, lTxt() AS STRING                                 '
LOCAL iPoint, i, pVar, lMainType, lSubType, lIsArray, pDirect, ArrayElements, ArrayPtr, lSize, lCounter AS LONG   '
LOCAL ePoint AS EXT                                               '
   gMacroTHeader = "Add_Array() "                                 '
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      thinBasic_ParseNumber ePoint                                ' Then get the numeric operand
      iPoint = ePoint                                             ' Make into LONG
      IF thinBasic_CheckComma(%True, %True) THEN                  ' A comma?
         ArrayName = thinBasic_GetTokenName                       ' Get next token name as a string
         IF thinBasic_CheckCloseParens THEN                       ' Closed properly?
            pVar = thinBasic_VariableGetInfo(ArrayName, lMainType, lSubType, lIsArray) ' Get a ptr to a variable (name is ArrayName)
            IF pVar <> %Null THEN                                 ' If we get pointer then variable exists
                                                                  ' If OK lMainType, lSubType, lIsArray will be filled
               IF lIsArray = %TRUE THEN                           ' Check if variable is an array
                  IF thinBasic_CheckOpenParens_Optional THEN      ' Skip possible () after name of the array.
                     thinBasic_CheckCloseParens_Mandatory         '
                  END IF                                          '
                  pDirect = thinBasic_VariablePtrToDirectPtr(pVar)' We need to convert ptr inside parser to pointer inside thinBasic Core
                                                                  ' to get full access to data
                  IF lMainType = %MainType_String THEN            ' Check if array main type is string.
                     ArrayElements = thinBasic_ArrayGetInfo(pDirect, %Array_ElementsCount)   ' Get number of elements in array
                     ArrayPtr = thinBasic_ArrayGetInfo(pDirect, %Array_PtrToData)   ' Get a pointer to where first byte of data is stored

                     '-----------------------------------------------------------------------------+
                     '- String arrays can be arrays of fixed or dynamic strings                    |
                     '- Fixed strings are just a sequence of blocks of single element size         |
                     '- Dynamic string are a a sequence of pointers (4 bytes) to BSTR strings      |
                     '-----------------------------------------------------------------------------+

                     '-----------------------------------------------------------------------------+
                     '- If we have a dynanmic string, just overimpose a virtual array using PB REDIM ... AT ...|
                     '-----------------------------------------------------------------------------+
                     IF thinBasic_ArrayGetInfo(pDirect, %Array_ElementsAreFixed) = %FALSE THEN  '
                        REDIM lTxt(1& TO ArrayElements) AS STRING AT ArrayPtr ' Dynamic string array
                     ELSE                                         ' Fixed string array array. Get its element size.
                        lSize = thinBasic_ArrayGetInfo(pDirect, %Array_ElementSize) '
                        REDIM lTxt(1 TO ArrayElements) AS STRING  '
                        FOR lCounter = 1 TO ArrayElements         '
                           lTxt(lCounter) = PEEK$(ArrayPtr + lSize * (lCounter - 1), lSize)  '
                        NEXT                                      '
                     END IF                                       '

                     '-----------------------------------------------------------------------------+
                     '- OK finally have array. Add lines to the Edit sesion                        |
                     '-----------------------------------------------------------------------------+
                     IF ArrayElements > 0 THEN                    ' Got some to Add?
                        IF iPoint = 0 THEN iPoint = TP.LastLine - 1  ' Zero means 'at the end
                        TP.LInsertLines(iPoint, ArrayElements, %Data)   ' Request insert the needed lines, %Data line

                        FOR i = 1 TO ArrayElements                ' Loop now, stuffing them in
                           TP.LTxtSet(iPoint + 1, LTxt(i))        ' Set it in
                           TP.AttrScan(iPoint + 1)                ' Build attr line
                           INCR iPoint                            ' Bump insertion point
                        NEXT i                                    ' Loop back
                     END IF                                       '

                  ELSE                                            '
                     thinBasic_RunTimeError(%ERR__VARIABLE_MUSTBE_STRING_TYPE)   '
                  END IF                                          '
               ELSE                                               '
                  thinBasic_RunTimeError(%ERR__VARIABLE_ISNOT_ARRAY) '
               END IF                                             '
            ELSE                                                  '
               thinBasic_RunTimeError(%ERR__VARIABLE_NOT_DEFINED) '
            END IF                                                ' End IF pVar
         END IF                                                   ' End Close )
      END IF                                                      ' End Comma
   END IF                                                         ' End Open (

   FUNCTION = 0: TP.ErrMsgReset                                   '
   DoTrace                                                        '
END FUNCTION                                                      '

FUNCTION Add_Line() AS LONG                                       '
'--------------------------------------------------------------------------------------------------+
'- Insert a line into the edit session                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i AS LONG                                  '
   IF MACParseIS("", "Add_Line", i, lText) THEN DoTrace: EXIT FUNCTION  '
   gMacroTHeader = "Add_Line(" + FORMAT$(i) + ", " + LEFT$(lText, 32) + ")"   '
   IF i < 0 OR i > (TP.LastLine - 1) THEN                         ' Seem reasonable?
      TP.ErrMsgAdd(8, "Invalid line reference index")             ' Set ZRC
   ELSE                                                           '
      IF i = 0 THEN i = TP.LastLine - 1                           ' Zero means 'at the end
      TP.LInsertLines(i, 1, %Data)                                ' Request insert 1, %Data line
      TP.LTxtSet(i + 1, LText)                                    ' Set it in
      TP.AttrScan(i + 1)                                          ' Build attr line
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = 0: TP.ErrMsgReset                                   '
END FUNCTION                                                      '

FUNCTION Drop_HANDLE() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Release a Handle                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, lno AS EXT, i, j, k, AllFlag AS LONG       '
   gMacroTHeader = "Drop_Handle$() "                              '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber lno                                ' Then get the number
         gMacroTHeader = "Drop_Handle$(" + FORMAT$(lno) + ") "    ' Setup trace data
         IF LEFT$(FORMAT$(lno), 1) = "." THEN                     ' Is this an unquoted .nnn operand?
            i = TP.LineNoRef(FORMAT$(lno))                        ' Do a lookup on it
         ELSE                                                     ' Else just a number
            i = lno                                               ' Put line number in i
         END IF                                                   '
      ELSE                                                        '
         thinBasic_ParseString lText                              ' Then get the string
         gMacroTHeader = "Drop_Handle$(" + lText + ") "           ' Setup trace data
         IF uucase(lText) = "ALL" THEN AllFlag = %True            ' The ALL case? Remember it
         IF ISFALSE AllFlag THEN                                  ' If not ALL
            IF LEFT$(lText, 1) = "." THEN                         ' A dotted line number?
               i = TP.LineNoRef(lText)                            ' Go look it up
            ELSEIF LEFT$(lText, 1) = "!" THEN                     ' A pure line reference
               i = VAL(MID$(lText, 2))                            ' Extract the line number
            ELSE                                                  ' Alphabetic, reject it
               i = 0                                              ' Force failure
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         IF AllFlag THEN                                          ' The ALL option?
            GOSUB ClearAll                                        ' Do it
         ELSE                                                     ' Not ALL
            GOSUB DoDrop                                          ' Go drop it
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
   DoTrace                                                        ' Dump the trace
   EXIT FUNCTION                                                  ' We're done

DoDrop:                                                           '
   IF i > 0 AND i <= TP.LastLine AND ISTRUE TP.LFlagData(i) THEN  ' Within range and a Data Line?
      IF TP.LHndlGet(i) <> 0 THEN                                 ' Was there a handle?
         FUNCTION = "._" + FORMAT$(TP.LHndlGet(i))                ' Pass it back
         TP.LHndlSet(i, 0)                                        ' Then clear it
         TP.ErrMsgReset                                           ' Set good RC
         TP.HandleMinMax                                          ' Adjust MinMax values
      ELSE                                                        ' No existing handle
         TP.ErrMsgReset                                           ' Return Nulls
      END IF                                                      '
   ELSE                                                           '
      FUNCTION = "": TP.ErrMsgAdd(8, "Invalid line pointer")      ' Else pass back null
   END IF                                                         '
   RETURN                                                         '
ClearAll:                                                         '
   FOR i = 1 TO TP.LastLine                                       ' Must search all lines
      TP.LHndlSet(i, 0)                                           ' Clear the Handle
   NEXT i                                                         '
   TP.HandleMin = 0: TP.HandleMax = 0: TP.HandleLast = 0          ' Adjust MinMax and next values
   FUNCTION = "": TP.ErrMsgReset                                  ' Pass back OK
   RETURN                                                         ' We're done here
END FUNCTION                                                      '

FUNCTION First_Handle() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the lowest active Handle                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL Hnd AS STRING                                               '
   gMacroTHeader = "First_Handle "                                '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   Hnd = IIF$(TP.HandleMin <> 0, "._" + FORMAT$(TP.HandleMin), "")   ' Return it (or Null)
   FUNCTION = Hnd                                                 '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(Hnd)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_AbbrevName$() AS STRING                            '
'--------------------------------------------------------------------------------------------------+
'- Get Line Attributes                                                                             |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseII("F", "FMGet_AbbrevName$", i, j, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION  '
   t = TP.FileAbbrev(TRIM$(gFMD(i).Filename), j)                  ' Pass back abbreviated name
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Attributes() AS DWORD                              '
'--------------------------------------------------------------------------------------------------+
'- FM Get Line Attributes                                                                             |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   IF MACParseI("F", "FMGet_Attributes", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION '
   j = gFMD(i).FileAttributes                                     ' Pass back the Attributes
   FUNCTION = j                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Attr() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- FM Get Line Attr STRING                                                                            |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL lclattr AS WSTRING, lclPos AS LONG, t AS STRING             '
   IF MACParseI("F", "FMGet_Attr$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).PrtField("ATTR", lclAttr, lclPos)                  ' Get the text and its attribute
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Backup_Versions() AS LONG                          '
'--------------------------------------------------------------------------------------------------+
'- Return # of Backup versions                                                                     |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL iFileName, TSTFileName, ifile, t, u AS STRING               '
LOCAL BKPCount, k AS LONG                                         '
LOCAL FileFD, RetFD AS DIRDATA                                    ' For directory data of the files

   IF MACParseI("F", "FMGet_Backup_Versions ", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION '
   gMacroTHeader = "FMGet_Backup_Versions(" + FORMAT$(i) + ") "   ' Build proper trace header

   IF ISFALSE ISFOLDER(TRIM$(gFMD(i).DPath) + "$BACKUP") THEN     ' If no $BACKUP folder
      FUNCTION = 0                                                '
      TP.ErrMsgReset: DoTraceN(0): EXIT FUNCTION                  ' Then no Backups, answer is zero
   END IF                                                         '
   iFileName = gFMD(i).FullPath                                   ' Build the full Path/Filename

   t = DIR$(iFileName TO FileFD)                                  ' Get the full FD set of data
   IF t = "" THEN                                                 ' Not found?
      FUNCTION = 0                                                '
      TP.ErrMsgReset: DoTraceN(0): EXIT FUNCTION                  ' Then no Backups, answer is zero
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Extract filename                                                                             |
   '-----------------------------------------------------------------------------------------------+
   iFile = PATHNAME$(NAMEX, iFileName)                            ' Get just the file.Ext

   '-----------------------------------------------------------------------------------------------+
   '- Count existing backups                                                                       |
   '-----------------------------------------------------------------------------------------------+
   TSTFileName = TRIM$(gFMD(i).DPath) + "$BACKUP\" + iFile + ".*" ' Build generic (no stamp) search version
   BKPCount = 0                                                   '
   u = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")         ' Look for our timestamp pattern
   t = DIR$(TSTFileName, TO RetFD)                                ' Look for Backups
   DO WHILE ISNOTNULL(t)                                          ' While we're getting entries
      PCRERegexTest(t, 1, j, k)                                   ' See if has our pattern
      IF j  AND RIGHT$(t, 6) <> ".STATE" THEN                     ' Got one, and NOT a STATE file
         INCR BKPCount                                            ' Bump counter
      END IF                                                      '
      t = DIR$(NEXT)                                              ' Get next entry
   LOOP                                                           '
   FUNCTION = BKPCount                                            ' Pass back the answer
   DoTraceN(BkpCount)                                             '
END FUNCTION                                                      '

FUNCTION FMGet_Cmd() AS STRING                                    '
'--------------------------------------------------------------------------------------------------+
'- Get Line Cmd                                                                                    |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseI("F", "FMGet_Cmd$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION '
   t = SHRINK$(gFMD(i).Cmd)                                       ' Pass back a normalized string
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_CreateTime() AS STRING                             '
'--------------------------------------------------------------------------------------------------+
'- Get Line Creation Time                                                                          |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseI("F", "FMGet_CreationTime$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION '
   t = TimePretty(gFMD(i).CreationTime)                           ' Pass back the time
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_FCount() AS LONG                                   '
'--------------------------------------------------------------------------------------------------+
'- Get Line Count                                                                                  |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "FMGet_FCount() "                              '
   QNotFM(gMacroTHeader)                                          ' Ensure we're in FM mode
   FUNCTION = TP.gFMDCtr - 1                                      ' Return the count - 1 for total line
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceN(TP.gFMDCtr - 1)                                       ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Extension() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get Line Extension                                                                              |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseI("F", "FMGet_Extension$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION '
   t = TRIM$(gFMD(i).Exten)                                       ' Pass back the Extension
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_File_Class() AS LONG                               '
'--------------------------------------------------------------------------------------------------+
'- Return Class of a Filename                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL t1, t2 AS STRING                                            '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL Ans AS LONG                                                 '
   IF MACParseI("F", "FMGet_File_Class", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION '
   t1 = TRIM$(gFMD(i).FileName)                                   ' Get the filename
   t2 = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")        ' Check for .999999-999999.999999 timestamp
   PCRERegexTest(t1, 1, i, j)                                     ' See if we can find it
   IF i = 0 OR j <> 21 THEN                                       ' Possible Backup type?
      Ans = 1                                                     ' No, return 1 = FM_EQU_NORMAL_FILE
   ELSE                                                           ' Yes
      Ans = IIF(RIGHT$(t1, 6) = ".STATE", 3, 2)                   ' Return 2 for FM_EQU_BACKUP_DATA, 3 for FM_EQU_BACKUP_STATE
   END IF                                                         '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceN(Ans)                                                  ' Do trace if needed
   FUNCTION = Ans                                                 ' Return answer
END FUNCTION                                                      '

FUNCTION FMGet_FileName() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get Line FileName                                                                               |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseI("F", "FMGet_FileName$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION  '
   t = TRIM$(gFMD(i).FileName)                                    ' Pass back the FileName
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_FilePath() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get FilePath string                                                                             |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
   gMacroTHeader = "FMGet_FilePath$()"                            ' Setup trace
   QNotFM(gMacroTHeader)                                          ' Ensure we're in FM mode
   FUNCTION = TP.FPath                                            ' Return the FilePath
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(TP.FPath)                                             ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_FilePattern() AS STRING                            '
'--------------------------------------------------------------------------------------------------+
'- Get FilePattern                                                                                 |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "FMGet_FilePattern$() "                        '
   QNotFM(gMacroTHeader)                                          ' Ensure we're in FM mode
   FUNCTION = TP.FMask                                            ' Return the File Pattern
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(TP.FMask)                                             ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_FileSize() AS QUAD                                 '
'--------------------------------------------------------------------------------------------------+
'- Get Line FileSize                                                                               |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   IF MACParseI("F", "FMGet_FileSize", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = gFMD(i).SizeInt                                     ' Pass back the size
   TP.ErrMsgReset                                                 ' Return a good result
   j = gFMD(i).SizeInt                                            ' Cnvt to long
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_FListName() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get FLIST Name                                                                                  |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "FMGet_FListName$() "                          '
   QNotFM(gMacroTHeader)                                          ' Ensure we're in FM mode
   FUNCTION = TP.FileListNm                                       ' Return the FList Name
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(TP.FileListNm)                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Folder_Class() AS LONG                             '
'--------------------------------------------------------------------------------------------------+
'- Return Class of a folder                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lTxt AS STRING, Ans AS LONG                                 '
   gMacroTHeader = "FMGet_Folder_Class() "                        ' Setup header
   Ans = 1                                                        ' Default to FM_EQU_NORMAL_FOLDER
   QNotFM(gMacroTHeader)                                          ' Ensure we're in FM mode
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnString THEN   ' A string?
         thinBasic_ParseString lTxt                               ' Then get the string
      END IF                                                      '
      thinBasic_CheckCloseParens                                  ' Closed by ) properly
      gMacroTHeader = "FMGet_Folder_Class(" + lTxt + ") "         ' Set proper trace header
   END IF                                                         '
   IF lTxt = "" THEN                                              ' If a Pathname passed
      IF ISNULL(TP.FileListNm) AND _                              ' And no FileListName
         RIGHT$(TRIM$(TP.FPath), 9) = "\$BACKUP\" THEN _          ' And the current path ends in \$BACKUP\
         Ans = 2                                                  ' Then return FM_EQU_BACKUP_FOLDER
   ELSE                                                           ' If aPathname WAS passed
      IF RIGHT$(TRIM$(lTxt), 9) = "\$BACKUP\" THEN _              ' And the path ends in \$BACKUP\
         Ans = 2                                                  ' Then return FM_EQU_BACKUP_FOLDER
   END IF                                                         '
   TP.ErrMsgReset                                                 ' Set OK answer
   FUNCTION = Ans                                                 ' Return value
   DoTraceN(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_FType() AS LONG                                    '
'--------------------------------------------------------------------------------------------------+
'- Get File Line Type                                                                              |
                                                                  '--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL Ans AS LONG                                                 '
   IF MACParseI("F", "FMGet_FType", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   '-----------------------------------------------------------------------------------------------+
   '- Select Line Type                                                                             |
   '-----------------------------------------------------------------------------------------------+
   SELECT CASE AS LONG gFMD(i).fLAG                               ' See what we have
      CASE %FDirUp:                   Ans = 1                     ' Dir Up
      CASE %FDirDown:                 Ans = 2                     ' Dir Down
      CASE %FEntry:                   Ans = 3                     ' File (in FILEPATH)
      CASE %FFLEntry:                 Ans = 3                     ' File (in an FLIST)
      CASE %FOpen:                    Ans = 3                     ' File (in OPEN list)
      CASE %FPath:                    Ans = 4                     ' Entry (in the Paths list)
      CASE %FFileList:                Ans = 5                     ' FLIST (in the FLIST list)
      CASE %FConfig:                  Ans = 6                     ' Entry (in the CONFIG List)
      CASE ELSE:                      Ans = 0                     ' Unknown
   END SELECT                                                     '
   TP.ErrMsgReset                                                 ' Return a good result
   FUNCTION = Ans                                                 ' Return value
   DoTraceN(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Lines() AS LONG                                    '
'--------------------------------------------------------------------------------------------------+
'- Get Line LINES                                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL j AS LONG                                                   '
   IF MACParseI("F", "FMGet_Lines", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = gFMD(i).LinesInt                                    ' Pass back the size
   TP.ErrMsgReset                                                 ' Return a good result
   j = gFMD(i).LinesInt                                           ' Cnvt
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Mode() AS LONG                                     '
'--------------------------------------------------------------------------------------------------+
'- Get File Manager Mode                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS LONG                                                 '
   gMacroTHeader = "FMGet_Mode() "                                '
   QNotFM(gMacroTHeader)                                          ' Ensure we're in FM mode
   IF ISNULL(TP.FileListNm) THEN                                  ' If no Filelist name
      Ans = 1                                                     ' Then it's FilePath mode
   ELSE                                                           '
      SELECT CASE AS CONST$ TP.FileListNm                         ' It's a FLIST type
         CASE "Recent Files":    Ans = 2                          '
         CASE "Found Files":     Ans = 3                          '
         CASE "Open Files":      Ans = 4                          '
         CASE "Favorite Files":  Ans = 5                          '
         CASE "FLISTS":          Ans = 6                          '
         CASE "Recent Paths":    Ans = 7                          '
         CASE "Configs":         Ans = 8                          '
      END SELECT                                                  '
   END IF                                                         '
   TP.ErrMsgReset                                                 ' Return a good result
   FUNCTION = Ans                                                 ' Return value
   DoTraceN(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_Path() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get Line Path                                                                                   |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseI("F", "FMGet_Path$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = TRIM$(gFMD(i).DPath)                                       ' Pass back the Path
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_PRP1() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get PRP STRING                                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL lclattr AS WSTRING, lclPos AS LONG, t AS STRING             '
   IF MACParseI("F", "FMGet_PRP1$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).PrtField("PRP1", lclAttr, lclPos)                  ' Get the text and its attribute
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_PRP2() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get PRP STRING                                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL lclattr AS WSTRING, lclPos AS LONG, t AS STRING             '
   IF MACParseI("F", "FMGet_PRP2$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).PrtField("PRP2", lclAttr, lclPos)                  ' Get the text and its attribute
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_PRP3() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get PRP STRING                                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL lclattr AS WSTRING, lclPos AS LONG, t AS STRING             '
   IF MACParseI("F", "FMGet_PRP3$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).PrtField("PRP3", lclAttr, lclPos)                  ' Get the text and its attribute
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_PRP4() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get PRP STRING                                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL lclattr AS WSTRING, lclPos AS LONG, t AS STRING             '
   IF MACParseI("F", "FMGet_PRP4$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).PrtField("PRP4", lclAttr, lclPos)                  ' Get the text and its attribute
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_PRP5() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get PRP STRING                                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL lclattr AS WSTRING, lclPos AS LONG, t AS STRING             '
   IF MACParseI("F", "FMGet_PRP5$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).PrtField("PRP5", lclAttr, lclPos)                  ' Get the text and its attribute
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_PRP6() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get PRP STRING                                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL lclattr AS WSTRING, lclPos AS LONG, t AS STRING             '
   IF MACParseI("F", "FMGet_PRP6$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).PrtField("PRP6", lclAttr, lclPos)                  ' Get the text and its attribute
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMGet_WriteTimeC() AS STRING                             '
'--------------------------------------------------------------------------------------------------+
'- Get Line LastWrite Time Formatted                                                               |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseI("F", "FMGet_LastWriteTime$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION   '
   t = gFMD(i).LWTime                                             ' Pass back the time
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMRun_LCmd() AS LONG                                     '
'--------------------------------------------------------------------------------------------------+
'- Issue an SPFLite FM Line Command                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, lCmd, lRoot, lOper AS STRING, i, j AS LONG           '
   IF MACParseIS("F", "SPF_FMLCmd", i, lText) THEN DoTrace: EXIT FUNCTION  '
   IF i < 1 OR i > (TP.gFMDCtr - 1) THEN _                        ' Invalid line index
         FUNCTION = 8: TP.ErrMsgAdd(8, "Invalid SPF_FMLCmd operand value"): DoTrace: EXIT FUNCTION '
   lcmd = SHRINK$(lText) + " "                                    ' Normalize spaces
   IF LEFT$(lcmd, 1) = "." THEN lcmd = "S " + lcmd                ' If just a profile request, prefix it with "E"
   IF LEFT$(lcmd, 1) = "%" THEN lcmd = "S " + lcmd                ' If just a macro request,   prefix it with "E"
   IF LEFT$(lcmd, 1) = "/" THEN lcmd = "S " + lcmd                ' If just a XFORM request,   prefix it with "E"
   j = INSTR(lcmd, " ")                                           ' Find 1st blank
   lRoot = LEFT$(lcmd, j - 1)                                     ' Separate command
   lOper = TRIM$(MID$(lcmd, j + 1))                               ' and operand

   ARRAY SCAN gFMLCmdTable() FOR UBOUND(gFMLCmdTable()), FROM 1 TO 8, COLLATE UCASE, =LSET$(lRoot, 8), TO j '
   IF j = 0 THEN                                                  ' Nothing? Kill it
      FUNCTION = 8: TP.ErrMsgAdd(8, "Invalid SPF_FMLCmd operand value (" + lRoot + ")")   '
      DoTrace: EXIT FUNCTION                                      ' Kill if not found
   END IF                                                         '
   gFMD(i).CmdIX = j                                              ' Save it
   gFMD(i).CmdRoot = TRIM$(gFMLCmdTable(j).lcTrue)                ' Save true base name
   gFMD(i).CmdOper = lOper                                        ' Save operand
   gFMD(i).CmdCount = 1                                           ' Count = 1
   gFMD(i).CmdFlag = ""                                           ' No Flag
   SELECT CASE AS CONST$ gFMD(i).CmdRoot                          ' What command?
      CASE "ADD":      TP.FMLCmdAdd(i)                            '
      CASE "BACKUP":   TP.FMLCmdBackup(i)                         '
      CASE "FORGET":   TP.FMLCmdForget(i)                         '
      CASE "SUBMIT":   TP.FMLCmdSubmit(i)                         '
      CASE "LINES":    TP.FMLCmdLines(i)                          '
      CASE "NORM":     TP.FMLCmdNorm(i)                           '
      CASE "PRINT":    TP.FMLCmdPrint(i)                          '
      CASE "RENAME":   TP.FMLCmdRename(i)                         '
      CASE "RESTORE":  TP.FMLCmdRestore(i)                        '
      CASE "RESTORET": TP.FMLCmdRestore(i)                        '
      CASE "TOUCH":    TP.FMLCmdTouch(i)                          '
      CASE "W":        TP.FMLCmdWOpen(i)                          '
      CASE ELSE                                                   '
           FUNCTION = 8: TP.ErrMsgAdd(8, "Unsupported SPF_FMLCmd operand value (" + gFMD(i).CmdRoot + ")")  '
   END SELECT                                                     '
   DoTrace                                                        '
END FUNCTION                                                      '

FUNCTION FMSet_Cmd() AS LONG                                      '
'--------------------------------------------------------------------------------------------------+
'- Set the Command field for a line                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, lwText AS WSTRING, i, j, k AS LONG, aTxt AS WSTRING POINTER, AttrAsc AS WORD   '
   IF MACParseIS("F", "SPF_FMLCmd", i, lText) THEN DoTrace: EXIT FUNCTION  '
   IF i < 0 OR i > (TP.gFMDCtr - 1) THEN                          ' Seem reasonable?
      TP.ErrMsgAdd(8, "Invalid line reference index")             ' Set ZRC
   ELSE                                                           '
      gFMD(i).Cmd = lText                                         ' Stuff back the new value
      TP.ErrMsgReset                                              ' Return a good result
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' Set return
END FUNCTION                                                      '

FUNCTION FMSet_FilePath() AS LONG                                 '
'--------------------------------------------------------------------------------------------------+
'- Set FilePath string                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, lwText AS WSTRING, i, j, k AS LONG, aTxt AS WSTRING POINTER, AttrAsc AS WORD   '
   IF MACParseS("F", "FMSet_FilePath", lText) THEN DoTrace: EXIT FUNCTION  '
   TP.FPath = lText                                               ' Stuff it in
   FUNCTION= 0                                                    ' RC = 0
   TP.ErrMsgReset                                                 ' Return a good result
   DoTrace()                                                      ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMSet_FilePattern() AS LONG                              '
'--------------------------------------------------------------------------------------------------+
'- Set FilePattern string                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, lwText AS WSTRING, i, j, k AS LONG, aTxt AS WSTRING POINTER, AttrAsc AS WORD   '
   IF MACParseS("F", "FMSet_FilePattern", lText) THEN DoTrace: EXIT FUNCTION  '
   TP.FMask = lText                                               ' Stuff it in
   FUNCTION= 0                                                    ' RC = 0
   TP.ErrMsgReset                                                 ' Return a good result
   DoTrace()                                                      ' Do trace if needed
END FUNCTION                                                      '

FUNCTION FMSet_Msg() AS LONG                                      '
'--------------------------------------------------------------------------------------------------+
'- Set the Message field for a line                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, lwText AS WSTRING, i, j, k AS LONG, aTxt AS WSTRING POINTER, AttrAsc AS WORD   '
   IF MACParseIS("F", "FMSet_Msg", i, lText) THEN DoTrace: EXIT FUNCTION   '
   IF i < 0 OR i > (TP.gFMDCtr - 1) THEN                          ' Seem reasonable?
      TP.ErrMsgAdd(8, "Invalid line reference index")             ' Set ZRC
   ELSE                                                           '
      gFMD(i).Message = lText                                     ' Stuff back the new value
      TPDoSet(%Msg)                                               ' Get msg issued
      TP.ErrMsgReset                                              ' Return a good result
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' Set return
END FUNCTION                                                      '

FUNCTION FMGet_FileSizeC() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get Line LastWrite Time Formatted                                                               |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
LOCAL t AS STRING                                                 '
   IF MACParseI("F", "FMGet_FileSize$", i, 1, (TP.gFMDCtr - 1)) THEN DoTrace: EXIT FUNCTION  '
   t = SizeLarge(MAK(QUAD, gFMD(i).FileSizeLow, gFMD(i).FileSizeHigh))  '
   FUNCTION = t                                                   ' Set return value
   TP.ErrMsgReset                                                 ' Return a good result
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ANSI2SOURCE() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get the ANSI -> SOURCE translate table                                                          |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_ANSI2SOURCE_Table$() "                    '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION  = TP.FCB_.CA2S: TP.ErrMsgReset                       ' Return the table
   DoTraceS(TP.FCB_.CA2S)                                         ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARG() AS STRING                                      '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Paremeter(s)                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lIndex, lIndex2 AS EXT, t AS STRING                         '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   lIndex = 0: lIndex2 = 999                                      '
   IF thinBasic_CheckOpenParens THEN                              ' Better have a Open (
      thinBasic_ParseNumber lIndex                                ' Get the Index
      IF thinBasic_CheckComma(%True, %True) THEN                  ' See if optional comma
         thinBasic_ParseNumber lIndex2                            ' Get 2nd operand if present
         IF thinBasic_CheckCloseParens THEN                       ' Better be a closing ) now
            gMacroTHeader = "Get_Arg$(" + FORMAT$(lIndex) + ", " + FORMAT$(lIndex2) + ") "   '
            IF lIndex2 <> 0 AND lIndex2 < lIndex THEN             ' In sequence
               FUNCTION = ""                                      '
               TP.ErrMsgAdd(8, "Invalid ARG indexes")             ' ZRC = Fail
               DoTrace                                            ' Do trace if needed
               EXIT FUNCTION                                      '
            END IF                                                '
         ELSE                                                     '
            EXIT FUNCTION                                         '
         END IF                                                   '
      ELSEIF ISFALSE thinBasic_CheckCloseParens THEN              ' Better be a closing )
         EXIT FUNCTION                                            '
      END IF                                                      '
      TP.ErrMsgReset                                              ' ZRC = OK default
      IF lIndex2 = 999 THEN                                       ' Just one operand?
         gMacroTHeader = "Get_Arg$(" + FORMAT$(lIndex) + ") "     ' Set trace header
         IF lIndex <= UBOUND(gMacOprands()) AND lIndex > 0 THEN   ' If valid index
            t = gMacOprands(lIndex)                               '
         ELSEIF lIndex = 0 THEN                                   ' If index = 0
            t = TRIM$(JOIN$(gMacOprands(), $SPC))                 '
         ELSE                                                     ' Else return null
            FUNCTION = "": TP.ErrMsgAdd(8, "Invalid ARG index")   '
            DoTrace                                               ' Do trace if needed
            EXIT FUNCTION                                         '
         END IF                                                   '
         FUNCTION = t                                             ' Return result
         DoTraceS(t)                                              ' Do trace if needed
      ELSE                                                        ' Two argument numbers
         IF lIndex <= UBOUND(gMacOprands()) AND lIndex2 <= UBOUND(gMacOprands()) THEN  ' If valid index
            IF lIndex2 = 0 THEN                                   ' 2nd operand zero?
               j = 0                                              '
               FOR i = 1 TO 50                                    ' See how many operands
                  IF ISNOTNULL(gMacOprands(i)) THEN j = i         ' Save hi-water non-null parameter
               NEXT i                                             '
               lIndex2 = j                                        ' Set lIndex 2 to max operand number
            END IF                                                '
            IF lIndex > lIndex2  OR lIndex = 0 THEN               ' Illogical ?
               FUNCTION = ""                                      '
               TP.ErrMsgAdd(8, "Invalid ARG indexes")             ' ZRC = Fail
               DoTrace                                            ' Do trace if needed
               EXIT FUNCTION                                      '
            END IF                                                '
            FOR i = lIndex TO lIndex2                             ' Add operands together
               IF ISNOTNULL(gMacOprands(i)) THEN t += gMacOprands(i) + " " '
            NEXT i                                                '
            t = RTRIM$(t)                                         ' Trim it
            FUNCTION = t                                          '
         ELSE                                                     ' Else return null
            FUNCTION = "": TP.ErrMsgAdd(8, "Invalid ARG indexes") '
            DoTrace                                               ' Do trace if needed
            EXIT FUNCTION                                         '
         END IF                                                   '
         DoTraceS(t)                                              ' Do trace if needed
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION Get_ARGCOUNT() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Get number of macro parameters                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   gMacroTHeader = "Get_Arg_Count() "                             '
   j = 0                                                          '
   FOR i = 1 TO 50                                                ' See how many operands
      IF ISNOTNULL(gMacOprands(i)) THEN j = i                     ' Save hi-water non-null parameter
   NEXT i                                                         '
   FUNCTION = j: TP.ErrMsgReset                                   ' Return value
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARGKW() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Keyword True/False                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL wvarname AS WSTRING                                         '
LOCAL vvarvalue AS VARIANT                                        '
   IF MACParseS("", "Get_Arg_KW", t) THEN DoTrace: EXIT FUNCTION  '
   wvarname = UUCASE(t)                                           ' Build key
   vvarvalue = gParseTbl.Item(wvarname)                           ' Try the retrieval
   j = OBJRESULT                                                  ' look at answer
   IF j > 0 THEN                                                  ' Not found
      TP.ErrMsgAdd(8, "Invalid Keyword: " + t)                    ' KW not defined
      FUNCTION = %False                                           '
   ELSE                                                           ' Retrieved OK
      t = VARIANT$(vvarvalue)                                     ' Return string
      TP.ErrMsgReset                                              ' Set good RC
      IF LEFT$(t, 1) = "9" THEN                                   ' An ALIAS entry?
         wvarname = MID$(t, 2)                                    ' Pick up the truename
         vvarvalue = gParseTbl.Item(wvarname)                     ' Retrieve the truename entry
         j = OBJRESULT                                            ' look at answer
         IF j > 0 THEN                                            '
            FUNCTION = %False: TP.ErrMsgAdd(8, "Parse Table structure error") '
            DoTrace                                               '
            EXIT FUNCTION                                         '
         END IF                                                   '
         t = VARIANT$(vvarvalue)                                  ' Convert string
      ELSE                                                        ' OK, swap the truename status
         t = VARIANT$(vvarvalue)                                  ' Convert string
      END IF                                                      '
      j = IIF(LEFT$(t, 1) = "1", %True, %False)                   ' Present? Set True/False
      FUNCTION = j                                                '
   END IF                                                         '
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARGKWGROUP() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Keyword Group result                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL wvarname AS WSTRING                                         '
LOCAL vvarvalue AS VARIANT                                        '
   IF MACParseS("", "Get_Arg_KWGroup$", t) THEN DoTrace: EXIT FUNCTION   '
   wvarname = "$$" + UUCASE(t)                                    ' Build key
   vvarvalue = gParseTbl.Item(wvarname)                           ' Try the retrieval
   j = OBJRESULT                                                  ' look at answer
   IF j > 0 THEN                                                  ' Not found
      TP.ErrMsgAdd(8, "Invalid Groupname: " + t)                  ' Groupname not defined
      FUNCTION = ""                                               '
      DoTrace                                                     '
      EXIT FUNCTION                                               '
   ELSE                                                           ' Retrieved OK
      t = VARIANT$(vvarvalue)                                     ' Return string
      t = PARSE$(t, "|", 2)                                       ' Get 2nd value
      TP.ErrMsgReset                                              ' Set good RC
      FUNCTION = t                                                ' Return it
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARGLRef() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Line Reference                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL wvarname AS WSTRING                                         '
LOCAL vvarvalue AS VARIANT                                        '
   IF MACParseI("", "Get_Arg_LRef$", i) THEN EXIT FUNCTION        '
   IF i > gMacGotlptr THEN                                        ' Reasonable ?
      FUNCTION = "": TP.ErrMsgAdd(8, "Invalid line reference index") '
      DoTrace: EXIT FUNCTION                                      '
   ELSE                                                           ' Within range
      wvarname = "." + FORMAT$(i)                                 ' Build key
      vvarvalue = gParseTbl.Item(wvarname)                        ' Try the retrieval
      j = OBJRESULT                                               ' look at answer
      IF j > 0 THEN                                               ' Not found
         TP.ErrMsgAdd(8, "Invalid Parse Table structure")         ' Oops, should never happen
         FUNCTION = "": t = ""                                    '
      ELSE                                                        ' Retrieved OK
         t = VARIANT$(vvarvalue)                                  ' Return string
         FUNCTION = t                                             '
      END IF                                                      '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARGLRef_Count() AS EXT                               '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Line Reference Count                                                                |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_ArgLRef_Count() "                         '
   TP.ErrMsgReset                                                 '
   DoTraceN(gMacGotlptr)                                          ' Do trace if needed
   FUNCTION = gMacGotlptr                                         ' Return value
END FUNCTION                                                      '

FUNCTION Get_ARGNumLit() AS STRING                                '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Numeric literal                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL wvarname AS WSTRING                                         '
LOCAL vvarvalue AS VARIANT                                        '
   IF MACParseI("", "Get_Arg_NumLit$", i) THEN EXIT FUNCTION      '
   IF i > gMacGotnum THEN                                         ' Reasonable ?
      FUNCTION = "": TP.ErrMsgAdd(8, "Invalid numeric literal index")   '
      DoTrace: EXIT FUNCTION                                      '
   ELSE                                                           ' Within range
      wvarname = "#" + FORMAT$(i)                                 ' Build key
      vvarvalue = gParseTbl.Item(wvarname)                        ' Try the retrieval
      j = OBJRESULT                                               ' look at answer
      IF j > 0 THEN                                               ' Not found
         TP.ErrMsgAdd(8, "Invalid Parse Table structure")         ' Oops, should never happen
         FUNCTION = "": t = ""                                    '
      ELSE                                                        ' Retrieved OK
         t = VARIANT$(vvarvalue)                                  ' Return string
         FUNCTION = t                                             '
      END IF                                                      '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARGNumLit_Count() AS EXT                             '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Numeric Literal Count                                                          |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_ArgNumLit_Count() "                       '
   TP.ErrMsgReset                                                 '
   DoTraceN(gMacGotnum)                                           ' Do trace if needed
   FUNCTION = gMacGotnum                                          ' Return value
END FUNCTION                                                      '

FUNCTION Get_ARGTag() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Tag operand                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL wvarname AS WSTRING                                         '
LOCAL vvarvalue AS VARIANT                                        '
   IF MACParseI("", "Get_Arg_Tag$", i) THEN EXIT FUNCTION         '
   IF i > gMacGottag THEN                                         ' Reasonable ?
      FUNCTION = "": TP.ErrMsgAdd(8, "Invalid tag operand index") '
      DoTrace: EXIT FUNCTION                                      '
   ELSE                                                           ' Within range
      wvarname = ":" + FORMAT$(i)                                 ' Build key
      vvarvalue = gParseTbl.Item(wvarname)                        ' Try the retrieval
      j = OBJRESULT                                               ' look at answer
      IF j > 0 THEN                                               ' Not found
         TP.ErrMsgAdd(8, "Invalid Parse Table structure")         ' Oops, should never happen
         FUNCTION = "": t = ""                                    '
      ELSE                                                        ' Retrieved OK
         t  = VARIANT$(vvarvalue)                                 ' Return string
         FUNCTION = t                                             '
      END IF                                                      '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARGTag_Count() AS EXT                                '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Tag Count                                                                      |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_ArgTag_Count() "                          '
   TP.ErrMsgReset                                                 ' Good Return
   DoTraceN(gMacGottag)                                           ' Do trace if needed
   FUNCTION = gMacGottag                                          ' Return value
END FUNCTION                                                      '

FUNCTION Get_ARGTextLit() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Text literal                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL wvarname AS WSTRING                                         '
LOCAL vvarvalue AS VARIANT                                        '
   IF MACParseI("", "Get_Arg_TextLit$", i) THEN EXIT FUNCTION     '
   IF i > gMacGotlit THEN                                         ' Reasonable ?
      FUNCTION = "": TP.ErrMsgAdd(8, "Invalid text literal index")   '
      DoTrace: EXIT FUNCTION                                      '
   ELSE                                                           ' Within range
      wvarname = "$" + FORMAT$(i)                                 ' Build key
      vvarvalue = gParseTbl.Item(wvarname)                        ' Try the retrieval
      j = OBJRESULT                                               ' look at answer
      IF j > 0 THEN                                               ' Not found
         TP.ErrMsgAdd(8, "Invalid Parse Table structure")         ' Oops, should never happen
         FUNCTION = "": t = ""                                    '
      ELSE                                                        ' Retrieved OK
         t = VARIANT$(vvarvalue)                                  ' Return string
         FUNCTION = t                                             '
      END IF                                                      '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ARGTextLit_Count() AS EXT                            '
'--------------------------------------------------------------------------------------------------+
'- Get MACRO Parsed Text Literal Count                                                             |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_ArgTextLit_Count() "                      '
   TP.ErrMsgReset                                                 '
   DoTraceN(gMacGotlit)                                           ' Do trace if needed
   FUNCTION = gMacGotlit                                          ' Return value
END FUNCTION                                                      '

FUNCTION Get_BOTSCREEN() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get Line pointer of Bottom of Screen                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_BottomScrn_LPtr() "                       '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i  = TP.VisBot: TP.ErrMsgReset                                 ' Return Bottom of screen
   FUNCTION = TP.VisBot                                           '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_BOTSCREENLNum() AS EXT                               '
'--------------------------------------------------------------------------------------------------+
'- Get Line Number  of Bottom of Screen                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_BottomScrn_LNum() "                       '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = VAL(TP.LLNumGet(TP.VisBot)): FUNCTION = i                  ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_BNDSLine() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get BNDS character string                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_BNDSLine$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         '-                                                       '
      END IF                                                      '
   END IF                                                         '
   TP.FCB_.BuildBndText                                           ' Build the string
   FUNCTION = IIF$(ISNULL(TP.BndText), "NONE", TP.BndText)        ' Return the string
   TP.ErrMsgReset                                                 ' Set ZRC
   DoTraceS(IIF$(ISNULL(TP.BndText), "NONE", TP.BndText))         ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ClrLine() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get color text for a single line number                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, lclnHiLites AS STRING, lwText AS WSTRING, i, j, k AS LONG, aTxt AS WSTRING POINTER, AttrAsc AS WORD  '
   IF MACParseI("E", "Get_Clr_Line$", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   IF ISFALSE TP.LFlagData(i) THEN                                ' Ineligible line?
      FUNCTION = "": TP.ErrMsgAdd(8, "Not a Data line")           ' Else pass back null
      DoTrace: EXIT FUNCTION                                      '
   ELSE                                                           '
      lclnHiLites = " " + gHiLitesChrs                            ' Get string with a blank
      lwText = TP.LAttrGet(i): lText = ""                         ' Get the Attr line, null answer line
      FOR j = 1 TO LEN(lwText)                                    ' Convert to old Clr line format
         AttrAsc = ASC(lwText, j) AND %AttrHiLite                 ' Get Attr without the HiLite bits
         SHIFT RIGHT AttrAsc, 12                                  ' Align it properly
         lText += MID$(lclnHiLites, AttrAsc + 1, 1)               ' Get HiLite Index
      NEXT j                                                      '
      IF TRIM$(LText) = "" THEN LText = SPACE$(TP.LTxtLen(i))     ' fudge one
      FUNCTION = lText: TP.ErrMsgReset                            ' Yes, fetch the text
   END IF                                                         '
   DoTraceS(LText)                                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_CSRCOL() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the column number of the cursor                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Csr_Col() "                               '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(ISFALSE TP.CursData, 0, TP.CsrCol - TP.GPGapCol + TP.GPOffset)  ' Return the cursor column
   FUNCTION = i                                                   '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_CSRLNum() AS EXT                                     '
'--------------------------------------------------------------------------------------------------+
'- Get the current line number of the Cursor                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG
   gMacroTHeader = "Get_Csr_LNum() "                              '
   i = VAL(TP.LLNumGet(TP.sGet(TP.CsrRow))): FUNCTION = i         ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_CSRLPTR() AS EXT                                     '
'--------------------------------------------------------------------------------------------------+
'- Get the line number of the cursor                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Csr_LPtr() "                              '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.sGet(TP.CsrRow): TP.ErrMsgReset                         ' Return the cursor line
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_CURRLINE() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the Current text line                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   gMacroTHeader = "Get_Curr_Line$() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   t = TP.CursLine: TP.ErrMsgReset                                ' Return Current line
   FUNCTION  = t                                                  '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_CURRPATH() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the Current path                                                                            |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_CurrPath$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION  = CURDIR$: TP.ErrMsgReset                            ' Return Current Path
   DoTraceS(CURDIR$)                                              ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_CURRWORD() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the Current cursor word                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   gMacroTHeader = "Get_Curr_Word$() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   t  = TRIM$(TP.CursWord): TP.ErrMsgReset                        ' Return Current Word
   FUNCTION  = t                                                  '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_DESTL1() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the Dest line command start line pointer                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
   gMacroTHeader = "Get_Dest1_LPtr() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lno = IIF(gMacRange, IIF(gMacDFrom = 0, 0, gMacDFrom), 0)      ' If a range waiting, return the FromLin
   IF lno <> 0 THEN TP.UpdLControl(lno)                           ' Reset the LLCtl area
   FUNCTION = lno: TP.ErrMsgReset                                 ' Return the result
   DoTraceN(lno)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_DESTL2() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the Dest line command end line number                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
   gMacroTHeader = "Get_Dest2_LPtr() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lno = IIF(gMacRange, IIF(gMacDTo = 0, 0, gMacDTo), 0)          ' If a range waiting, return the ToLin
   IF lno <> 0 THEN TP.UpdLControl(INT(lno))                      ' Reset the LLCtl area
   FUNCTION = lno: TP.ErrMsgReset                                 ' Return the result
   DoTraceN(lno)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_DESTLCMD() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the dest line command                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   gMacroTHeader = "Get_Dest_LCmd$() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   t = IIF$(gMacRange, gMacDCmd, "")                              ' If a range waiting, return the LCmd
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(t)                                                    '
END FUNCTION                                                      '

FUNCTION Get_DESTLMOD$() AS STRING                                '
'--------------------------------------------------------------------------------------------------+
'- Get the Dest line command Post Operand                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL op AS STRING                                                '
   gMacroTHeader = "Get_Dest_LMod$() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   op = "  "                                                      ' Set default
   IF gMacRange THEN                                              ' If a range
      IF BIT(gMacDFlag, %lCmdX) THEN MID$(op, 1, 1) = "-"         ' Set +/- as appropriate
      IF BIT(gMacDFlag, %lCmdNX) THEN MID$(op, 1, 1) = "+"        '
      IF BIT(gMacDFlag, %lCmdR) THEN MID$(op, 2, 1) = "R"         '
   END IF                                                         '
   FUNCTION = op: TP.ErrMsgReset                                  '
   DoTraceS(op)                                                   ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_DESTOP() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the Dest command repeat value                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Dest_Op() "                               '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF (gMacDTo = gMacDFrom) AND gMacDTo <> 0 THEN                 ' Not an AA - AA range
      i = IIF(gMacDRpt = 0, 1, gMacDRpt)                          ' Pass back Rpt or 1
   ELSE                                                           '
      i =IIF(gMacDTo <> 0 OR gMacDFrom <> 0, gMacDTo - gMacDFrom + 1, gMacDRpt)  ' Pass it back
   END IF                                                         '
   FUNCTION = i: TP.ErrMsgReset                                   ' Return the result
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_EOLSTR() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get the Profile EOL string                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL t, u AS STRING, lno AS EXT, i AS LONG                       '
   gMacroTHeader = "Get_EOL_Str$() "                              '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         '-----------------------------------------------------------------------------------------+
         '- Choose the correct EOL delimiter                                                       |
         '-----------------------------------------------------------------------------------------+
         t = TP.FCB_.EOL                                          ' Get the EOL
         IF t = "CRLF" THEN                                       ' Setup the EOL delimiter
            u = $CRLF: FUNCTION = u                               '
         ELSEIF t = "LF" THEN                                     '
            u = $LF: FUNCTION = u                                 '
         ELSEIF t = "CR" THEN                                     '
            u = $CR: FUNCTION = u:                                '
         ELSEIF t = "NL" THEN                                     '
            u = $NL: FUNCTION = u                                 '
         ELSEIF t = "NONE" THEN                                   '
            u = "": FUNCTION = u                                  '
         ELSEIF LEFT$(t, 4) = "AUTO" THEN                         '
            u = $CRLF: FUNCTION = u                               '
         ELSE                                                     ' Must be hex
            u = StrFromHex(TRIM$(t)): FUNCTION = u                ' Set it up
         END IF                                                   '
         TP.ErrMsgReset                                           ' Set ZRC
         DoTraceS(u)                                              ' Do trace if needed
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION Get_EXEFullName() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get the full path to the EXE file                                                               |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_EXE_FullName$() "                         '
   FUNCTION = gENV.EXEFullPath                                    ' Return answer
   TP.ErrMsgReset: DoTraceS(gENV.EXEFullPath)                     ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_EXEPath() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the current EXE Path                                                                        |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_EXE_Path$() "                             '
   FUNCTION = gENV.EXEPath: TP.ErrMsgReset                        ' Pass back EXE path
   DoTraceS(gENV.EXEPath)                                         ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FileBase() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current File Base name                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS STRING                                               '
   gMacroTHeader = "Get_FileBase$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF IsClip AND ISNULL(TP.Clipname) THEN                         ' Handle special tabs
      Ans = "ClipBoard"                                           '
   ELSEIF IsSetEdit THEN                                          '
      Ans = "SetEdit"                                             '
   ELSEIF IsEFTEdit THEN                                          '
      Ans = "EFTEdit"                                             '
   ELSE                                                           ' Else
      Ans = TP.FCB_.Base                                          ' Return base
   END IF                                                         '
   FUNCTION = Ans                                                 '
   TP.ErrMsgReset                                                 '
   DoTraceS(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FileDate() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current File Date                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS STRING                                               '
   gMacroTHeader = "Get_FileDate$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF (IsClip AND ISNULL(TP.Clipname)) OR IsSetEdit OR IsEFTEdit THEN   ' Handle special tabs
      Ans = RIGHT$(DATE$, 2) + "-" + LEFT$(DATE$, 2) + "-" + MID$(DATE$, 4, 2)   '
   ELSE                                                           '
      Ans = TP.FCB_.Date                                          ' Return file Date
   END IF                                                         '
   FUNCTION = Ans                                                 '
   DoTraceS(TRIM$(Ans))                                           ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FileExt() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the current File Extension                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS STRING                                               '
   gMacroTHeader = "Get_FileExt$() "                              '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF (IsClip AND ISNULL(TP.Clipname)) OR IsSetEdit OR IsEFTEdit THEN   ' Handle special tabs
      Ans = ""                                                    '
   ELSE                                                           '
      Ans = TP.FCB_.Extn                                          ' Return file Date
   END IF                                                         '
   FUNCTION = Ans                                                 '
   TP.ErrMsgReset                                                 '
   DoTraceS(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FileName() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current File Name                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS STRING                                               '
   gMacroTHeader = "Get_FileName$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF IsClip AND ISNULL(TP.Clipname) THEN                         ' Handle special tabs
      Ans = "ClipBoard"                                           '
   ELSEIF IsSetEdit THEN                                          '
      Ans = "SetEdit"                                             '
   ELSEIF IsEFTEdit THEN                                          '
      Ans = "EFTEdit"                                             '
   ELSE                                                           ' Else
      Ans = TP.FCB_.File                                          ' Return Filename
   END IF                                                         '
   FUNCTION = Ans                                                 '
   TP.ErrMsgReset                                                 '
   DoTraceS(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FilePath() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current File Path                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS STRING                                               '
   gMacroTHeader = "Get_FilePath$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF IsClip AND ISNULL(TP.Clipname) THEN                         ' Handle special tabs
      Ans = "ClipBoard"                                           '
   ELSEIF IsSetEdit THEN                                          '
      Ans = "SetEdit"                                             '
   ELSEIF IsEFTEdit THEN                                          '
      Ans = "EFTEdit"                                             '
   ELSE                                                           ' Else
      Ans = TP.FCB_.Path                                          ' Return base
   END IF                                                         '
   FUNCTION = Ans                                                 '
   DoTraceS(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FileTime() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current File Time                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS STRING                                               '
   gMacroTHeader = "Get_FileTime$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF (IsClip AND ISNULL(TP.Clipname)) OR IsSetEdit OR IsEFTEdit THEN   ' Handle special tabs
      Ans = LEFT$(TIME$, 8)                                       '
   ELSE                                                           '
      Ans = TP.FCB_.Time                                          ' Return file Time
   END IF                                                         '
   FUNCTION = Ans                                                 '
   DoTraceS(TRIM$(Ans))                                           ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FindLstCol() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the last FIND column number                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_Last_Col() "                         '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.FoundLstCol: TP.ErrMsgReset                             ' Return ZFINDCOL
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FindLstLen() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the last FIND found length                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_Last_Len() "                         '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.FoundLstLen: TP.ErrMsgReset                             ' Return ZFINDLEN
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FindLstLin() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the last FIND line pointer                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_Last_LNum() "                        '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.FoundLstLin                                             ' Get the LPtr
   FUNCTION = i                                                   ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FindLstLinLNum() AS EXT                              '
'--------------------------------------------------------------------------------------------------+
'- Get the last FIND line number                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_Last_LNum() "                        '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.FoundLstLin                                             ' Get the LPtr
   i = VAL(TP.LLNumGet(i)): FUNCTION = i                          ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_Find1stCol() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the first FIND column number                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_First_Col() "                        '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.Found1stCol: TP.ErrMsgReset                             ' Return ZFINDCOL
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_Find1stLen() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the first FIND found length                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_First_Len() "                        '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.Found1stLen: TP.ErrMsgReset                             ' Return ZFINDLEN
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_Find1stLin() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the first FIND line pointer                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_First_LPtr() "                       '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.Found1stLin: TP.ErrMsgReset                             ' Return the line number
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_Find1stLinLNum() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the first FIND line number                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Find_First_LNum() "                       '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = TP.Found1stLin                                             ' Get the LPtr
   i = VAL(TP.LLNumGet(i)): FUNCTION = i                          ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FIRST() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Get the top line                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_First_LPtr() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(TP.LastLine = 2, 0, 1): TP.ErrMsgReset                 ' Return top line or 0 if empty file
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FIRSTLNum() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get the top line Number                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_First_LNum() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = 0: TP.ErrMsgReset                                   ' Always zero
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FIRSTREAL() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get the first real line pointer                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG
   gMacroTHeader = "Get_First_Real_LPtr() "                       '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FOR i = 1 TO TP.LastLine                                       ' Look for 1st Data line
      IF ISTRUE (TP.LFlagGet(i) AND %Data) THEN                   ' Found a Data Line?
         FUNCTION = i: TP.ErrMsgReset                             ' Return the LPtr
         DoTraceN(i): EXIT FUNCTION                               '
      END IF                                                      '
   NEXT i                                                         '
   FUNCTION = 0:                                                  '
   DoTraceN(0)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FIRSTREALLNum() AS EXT                               '
'--------------------------------------------------------------------------------------------------+
'- Get the first real line number                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG
   gMacroTHeader = "Get_First_Real_LNum() "                       '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FOR i = 1 TO TP.LastLine                                       ' Look for 1st Data line
      IF ISTRUE (TP.LFlagGet(i) AND %Data) THEN                   ' Found a Data Line?
         i = VAL(TP.LLNumGet(i)): FUNCTION = i                    ' Return answer
         TP.ErrMsgReset: DoTraceN(i)                              ' Do trace if needed
         EXIT FUNCTION                                            '
      END IF                                                      '
   NEXT i                                                         '
   FUNCTION = 0:                                                  '
   DoTraceN(0)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_FileFull() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Return the fully qualified filename                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL Ans AS STRING                                               '
   gMacroTHeader = "Get_FileFull$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF IsClip AND ISNULL(TP.Clipname) THEN                         ' Handle special tabs
      Ans = "ClipBoard"                                           '
   ELSEIF IsSetEdit THEN                                          '
      Ans = "SetEdit"                                             '
   ELSEIF IsEFTEdit THEN                                          '
      Ans = "EFTEdit"                                             '
   ELSE                                                           ' Else
      Ans = TP.FCB_.FilePath                                      ' Return full Path
   END IF                                                         '
   FUNCTION = Ans                                                 '
   TP.ErrMsgReset                                                 '
   DoTraceS(Ans)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLNUM() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get a GBL variable                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, s AS STRING, i, RC AS LONG, varvalue AS EXT        '
   IF MACParseIS("", "Get_Gbl_Num", i, varname) THEN DoTrace: EXIT FUNCTION   '
   varname = FORMAT$(i) + "," + varname                           ' Format the name
   IF ISNULL(varname) THEN                                        ' Ignore null requests
      FUNCTION = 0                                                ' Return OK
      DoTrace                                                     ' Do trace if needed
      EXIT FUNCTION                                               '
   END IF                                                         '
   s = gNumVar.GetValue(varname)                                  ' Try the retrieval
   IF ISNULL(s) THEN                                              ' Error?
      FUNCTION = 0: TP.ErrMsgAdd(8, "Unable to find variable")    ' Return code
      DoTrace: EXIT FUNCTION                                      '
   ELSE                                                           '
      i = VAL(s)                                                  '
      FUNCTION = i                                                ' Return OK
   END IF                                                         '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLNUMCOUNT() AS EXT                                 '
'--------------------------------------------------------------------------------------------------+
'- Get count of GLB NUM variables                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, tblsize AS LONG, level AS EXT, varname AS STRING, varvalue AS STRING  '
   level = -1                                                     ' Default to NO table number
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens(%True, %True) THEN            ' And if closed directly by a ) properly
         gMacroTHeader = "Get_GBL_Num_Count() "                   '

      ELSE                                                        ' Not an immediate )
         thinBasic_ParseNumber level                              ' Then get the table number
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Get_GBL_Num_Count(" + FORMAT$(level) + ")" '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   tblsize = gNumVar.Count                                        ' Get total number in table
   IF level = -1 THEN                                             ' Asking for whole table?
      FUNCTION = tblsize: TP.ErrMsgReset                          ' Return count of NumVars
      k = gNumVar.Count                                           ' Stick in k for trace

   ELSE                                                           ' We're asking for a sub-table
      FOR i = 1 TO gStrVar.DicNumEntries                          ' Look at each entry
         varname = gNumVar.GetIXKey(i)                            '
         IF ISNULL(varname) THEN ITERATE FOR                      '
         IF level = VAL(varname) THEN INCR k                      ' If correct table number, count it
      NEXT i                                                      '
      FUNCTION = k: TP.ErrMsgReset                                ' Return answer
   END IF                                                         '
   DoTraceN(k)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLNUMNAME() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get name of a variable entry                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, varvalue AS STRING, i AS LONG                      '
LOCAL t AS STRING                                                 '
   IF MACParseI("", "Get_Gbl_Num_Name$", i) THEN EXIT FUNCTION    '
   varname = gNumVar.GetIXKey(i)                                  '
   IF ISNOTNULL(varname) THEN                                     ' Get result
      varname = MID$(varname, INSTR(varname, ",") + 1)            ' Strip off table number
      FUNCTION = varname: t = varname: TP.ErrMsgReset             '
   ELSE                                                           '
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "No NUM Variable entry")   '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLNUMTABLENAME() AS STRING                          '
'--------------------------------------------------------------------------------------------------+
'- Get name plus table of a variable entry                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, varvalue, t AS STRING, i AS LONG
   IF MACParseI("", "Get_Gbl_Num_TableName$", i) THEN EXIT FUNCTION  '
   varname = gNumVar.GetIXKey(i)                                  '
   IF ISNOTNULL(varname) THEN                                     ' Get result
      FUNCTION = varname: t = varname: TP.ErrMsgReset             '
   ELSE                                                           '
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "No NUM Variable entry")   '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLSTR() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get a GBL variable                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, varvalue, t AS STRING, i, j AS LONG
   IF MACParseIS("", "Get_Gbl_Str$", i, varname) THEN DoTrace: EXIT FUNCTION  '
   IF ISNULL(varname) THEN                                        ' Ignore null requests
      FUNCTION = ""                                               ' Return OK
      DoTrace                                                     ' Do trace if needed
      EXIT FUNCTION                                               '
   END IF                                                         '
   varname = FORMAT$(i) + "," + varname                           ' Format the full name
   TP.ErrMsgReset                                                 ' Default answers
   varvalue = gStrVar.GetValue(varname)                           ' Try the retrieval
   IF ISNULL(varvalue) THEN                                       ' Error?
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "Unable to find variable") '
   ELSE                                                           '
      FUNCTION = varvalue: t = varvalue                           ' Return OK
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLSTRCOUNT() AS EXT                                 '
'--------------------------------------------------------------------------------------------------+
'- Get count of GLB STR variables                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, tblsize AS LONG, level AS EXT, varname, varvalue AS STRING
   level = -1                                                     ' Default the NO optional table number
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens(%True, %True) THEN            ' And if closed directly by a ) properly
         gMacroTHeader = "Get_GBL_Str_Count() "                   '

      ELSE                                                        ' Not an immediate )
         thinBasic_ParseNumber level                              ' Then get the table number
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Get_GBL_Str_Count(" + FORMAT$(level) + ")" '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   tblsize = gStrVar.Count                                        ' Get total number in table
   IF level = -1 THEN                                             ' Asking for whole table?
      FUNCTION = tblsize: k = tblsize: TP.ErrMsgReset             ' Return count of StrVars

   ELSE                                                           ' We're asking for a sub-table
      FOR i = 1 TO gStrVar.DicNumEntries                          ' Look at each entry
         varname = gStrVar.GetIXKey(i)                            '
         IF ISNOTNULL(varname) THEN                               ' If OK
            IF level = VAL(varname) THEN INCR k                   ' If correct table number, count it
         END IF                                                   '
      NEXT i                                                      '
      FUNCTION = k: TP.ErrMsgReset                                ' Return answer
   END IF                                                         '
   DoTraceN(k)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLSTRNAME() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get name of a variable entry                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, varvalue, t AS STRING, i AS LONG
   IF MACParseI("", "Get_Gbl_Str_Name$", i) THEN EXIT FUNCTION    '
   varName = gStrVar.GetIXKey(i)                                  '
   IF ISNOTNULL(varname) THEN                                     ' If OK
      varname = MID$(varname, INSTR(varname, ",") + 1)            ' Strip off table number
      FUNCTION = varname: t = varname: TP.ErrMsgReset             '
   ELSE                                                           '
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "No STR Variable entry")   '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_GBLSTRTABLENAME() AS STRING                          '
'--------------------------------------------------------------------------------------------------+
'- Get name plus table of a variable entry                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, varvalue, t AS STRING, i AS LONG
   IF MACParseI("", "Get_Gbl_Str_TableName$", i) THEN EXIT FUNCTION  '
   varname = gStrVar.GetIXKey(i)                                  '
   IF ISNOTNULL(varname) THEN                                     ' If OK
      FUNCTION = varname: t = varname: TP.ErrMsgReset             '
   ELSE                                                           '
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "No STR Variable entry")   '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_HANDLE() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get a Handle for the requested line                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, t AS STRING, lno AS EXT, i, j, k AS LONG             '

   gMacroTHeader = "Get_Handle$() "                               '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber lno                                ' Then get the number
         gMacroTHeader = "Get_Handle$(" + FORMAT$(lno) + ") "     ' Setup trace data
         IF LEFT$(FORMAT$(lno), 1) = "." THEN                     ' Is this an unquoted .nnn operand?
            i = TP.LineNoRef(FORMAT$(lno))                        ' Do a lookup on it
         ELSE                                                     ' Else just a number
            i = lno                                               ' Put line number in i
         END IF                                                   '
      ELSE                                                        '
         thinBasic_ParseString lText                              ' Then get the string
         gMacroTHeader = "Get_Handle$(" + lText + ") "            ' Setup trace data
         IF LEFT$(lText, 1) = "." THEN                            ' A dotted line number?
            i = TP.LineNoRef(lText)                               ' Go look it up
         ELSEIF LEFT$(lText, 1) = "!" THEN                        ' A pure line reference
            i = VAL(MID$(lText, 2))                               ' Extract the line number
         ELSE                                                     ' Alphabetic, reject it
            i = 0                                                 ' Force failure
         END IF                                                   '
      END IF                                                      '
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         GOSUB ReturnLabel                                        ' Go get a label for this line
      END IF                                                      '
      DoTraceS(t)                                                 ' Dump the trace
   END IF                                                         '
   EXIT FUNCTION                                                  ' We're done

ReturnLabel:                                                      '
   IF i > 0 AND i <= TP.LastLine AND ISTRUE TP.LFlagData(i) THEN  ' Within range and a Data Line?
      k = TP.LHndlGet(i)                                          ' Get existing Handle value
      IF k THEN                                                   ' A Handle exists, return it
         t = "._" + FORMAT$(k): TP.ErrMsgHigh = 0                 ' Build ._nnnnn format Handle
         FUNCTION = t                                             '
      ELSE                                                        ' No existing?
         TP.HandleLast = TP.HandleLast + 1                        ' Assign one
         TP.HandleMax = TP.HandleLast                             ' Also set as HandleMax
         IF TP.HandleMin = 0 THEN TP.HandleMin = TP.HandleMax     ' First time, establish Min
         k = TP.HandleLast                                        '
         TP.LHndlSet(i, k)                                        '
         t = "._" + FORMAT$(k): TP.ErrMsgHigh = 0                 ' Build ._nnnnn format Handle
         FUNCTION = t                                             '
      END IF                                                      '
   ELSE                                                           '
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "Invalid line pointer") ' Else pass back null
   END IF                                                         '
   RETURN                                                         ' We're done here
END FUNCTION                                                      '

FUNCTION Get_HomeData() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current Home data Path                                                                  |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_HomeData$() "                             '
   FUNCTION = gENV.HomeData: TP.ErrMsgReset                       ' Pass back Path to the Data folder.
   DoTraceS(gENV.HomeData)                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_HomeFolder() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get the current CFG Path                                                                        |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_HomeFolder$$() "                          '
   FUNCTION = gENV.HomeFolder: TP.ErrMsgReset                     ' Pass back Path to the Data folder.
   DoTraceS(gENV.HomeFolder)                                      ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_INIPath() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the current Data Path                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_INIPath$() "                              '
   FUNCTION = gENV.HomeData: TP.ErrMsgReset                       ' Pass back Path to the Data folder.
   DoTraceS(gENV.HomeData)                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_INSTANCE() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current Instance Name                                                                   |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_INSTANCE$() "                             '
   FUNCTION = gENV.eInstance: TP.ErrMsgReset                      ' Pass back the name
   DoTraceS(gENV.eInstance)                                       ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_Label() AS STRING                                    '
'--------------------------------------------------------------------------------------------------+
'- Get label for a single line number                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, t AS STRING, i AS LONG                               '
   IF MACParseI("E", "Get_Label$", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   IF ISFALSE TP.LFlagData(i) THEN                                ' Not a data line?
      FUNCTION = "": t = "": TP.ErrMsgHigh = 8                    ' Else pass back null
   ELSE                                                           '
      IF TRIM$(TP.LLblGet(i)) = "" THEN                           ' Is Label null?
         IF TP.LHndlGet(i) <> 0 THEN                              ' Yes, try for a Handle
            t = "._" + FORMAT$(TP.LHndlGet(i))                    ' Yes, fetch the Handle
            FUNCTION = t                                          '
         ELSE                                                     ' Both missing, return Null
            FUNCTION = "": t = ""                                 '
         END IF                                                   '
      ELSE                                                        ' Label not Null,
         t = TRIM$(TP.LLblGet(i))                                 ' Then fetch the label
         FUNCTION = t                                             '
      END IF                                                      '
      TP.ErrMsgReset                                              ' Set ZRC
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LAST() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Get the last line pointer                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Last_LPtr() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(TP.LastLine = 2, 0, TP.LastLine): TP.ErrMsgReset       ' Return last line or 0 if empty file
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LASTLNum() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Get the last line number                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Last_LNum() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = 0                                                   ' Always zero
   DoTraceN(0)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LASTREAL() AS EXT                                    '
LOCAL i AS LONG
'--------------------------------------------------------------------------------------------------+
'- Get the last real line pointer                                                                  |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_Last_Real_LPtr()"                         '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FOR i = TP.LastLine TO 1 STEP -1                               ' Look for Last Data line
      IF ISTRUE (TP.LFlagGet(i) AND %Data) THEN                   ' Found a Data Line?
         FUNCTION = i: TP.ErrMsgReset                             ' Return the LPtr
         DoTraceN(i): EXIT FUNCTION                               '
      END IF                                                      '
   NEXT i                                                         '
   FUNCTION = 0:                                                  '
   DoTraceN(0)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LASTREALLNum() AS EXT                                '
LOCAL i AS LONG
'--------------------------------------------------------------------------------------------------+
'- Get the last real line number                                                                   |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_Last_Real_LNum()"                         '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FOR i = TP.LastLine TO 1 STEP -1                               ' Look for Last Data line
      IF ISTRUE (TP.LFlagGet(i) AND %Data) THEN                   ' Found a Data Line?
         i = VAL(TP.LLNumGet(i)): FUNCTION = i                    ' Return answer
         TP.ErrMsgReset: DoTraceN(i)                              ' Do trace if needed
         EXIT FUNCTION                                            '
      END IF                                                      '
   NEXT i                                                         '
   FUNCTION = 0:                                                  '
   DoTraceN(0)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LEFTSCRNCOL() AS EXT                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the Left visible screen column                                                              |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_LeftScrn_Col() "                          '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION  = TP.GPOffset + 1: TP.ErrMsgReset                    ' Return LH col of screen
   DoTraceN(TP.GPOffset + 1)                                      ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LBOUND() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the left BOUNDS value                                                                       |
                                                                  '--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_LBound() "                                '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = TP.FCB_.BndLeft: TP.ErrMsgReset                     ' Return the left bounds
   DoTraceN(TP.FCB_.BndLeft)                                      ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LNum() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Convert Internal to External line number                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG                                                '
   IF MACParseI("E", "Get_LNum", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION  '
   j = VAL(TP.LLNumGet(i)): TP.ErrMsgReset                        ' Get the external line number
   FUNCTION = j                                                   '
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LINE() AS STRING                                     '
'--------------------------------------------------------------------------------------------------+
'- Get text for a single line number                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i AS LONG                                  '
   IF MACParseI("E", "Get_Line$", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION '
   lText = TP.LTxtGet(i)                                          ' Yes, fetch the text
   FUNCTION = lText                                               ' Yes, fetch the text
   TP.ErrMsgReset                                                 ' Set ZRC
   DoTraceS(lText)                                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LINELen() AS EXT                                     '
'--------------------------------------------------------------------------------------------------+
'- Get text length of single line number                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i, j AS LONG                               '
   IF MACParseI("E", "Get_Line_Len", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION '
   IF ISTRUE (TP.LFlagGet(i) AND %NonTypable) THEN                ' Ineligible line?
      j = 0                                                       ' Else pass back null
      TP.ErrMsgAdd(8, "Non modifyable line")                      ' Set ZRC
   ELSE                                                           '
      j = TP.LTxtLen(i)                                           ' Yes, fetch the text length
      TP.ErrMsgReset                                              ' Set ZRC
   END IF                                                         '
   FUNCTION = j                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LineNumSize() AS EXT                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the current size of the line number field                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG
   gMacroTHeader = "Get_LineNum_Size() "                          '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = gENV.LinNoSize: FUNCTION = i                               ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LINETYPE() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get text version of Line Type                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i, j AS LONG                               '
   IF MACParseI("E", "Get_Line_Type$", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION  '
   lText = "UNKN"                                                 ' Default unknown
   TP.ErrMsgReset                                                 ' ZRC = OK
   lText = SWITCH$( _                                             ' Return the type
      ISTRUE (TP.LFlagGet(i) AND %Data),       "DATA", _          '
      ISTRUE (TP.LFlagGet(i) AND %Xclude),     "EXCL", _          '
      ISTRUE (TP.LFlagGet(i) AND %Top),        "TOP",  _          '
      ISTRUE (TP.LFlagGet(i) AND %Bottom),     "BOT",  _          '
      ISTRUE (TP.LFlagGet(i) AND %Tabs),       "TABS", _          '
      ISTRUE (TP.LFlagGet(i) AND %Bounds),     "BNDS", _          '
      ISTRUE (TP.LFlagGet(i) AND %Cols),       "COLS", _          '
      ISTRUE (TP.LFlagGet(i) AND %Word),       "WORD", _          '
      ISTRUE (TP.LFlagGet(i) AND %Mark),       "MARK", _          '
      ISTRUE (TP.LFlagGet(i) AND %Mask),       "MASK", _          '
      ISTRUE (TP.LFlagGet(i) AND %Prof),       "PROF", _          '
      ISTRUE (TP.LFlagGet(i) AND %EFT),        "EFT", _           '
      ISTRUE (TP.LFlagGet(i) AND %File),       "FILE")            '
   IF ISTRUE (TP.LFlagGet(i) AND %Note) THEN                      ' Enhance NOTE with the Note type
      j = TP.LWrk2Get(i)                                          ' Get the LWrk2 value
      IF j THEN                                                   ' Other than default note?
         lText = MID$($Upper, j, 1) + "NOTE"                      ' Add type of xNOTE
      ELSE                                                        ' Just a plain NOTE
         lText = "NOTE"                                           '
      END IF                                                      '
   END IF                                                         '

   FUNCTION = lText                                               ' Return answer
   DoTraceS(lText)                                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LOCLIN() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the LOCATE line pointer                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_LOC_Lptr() "                              '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(TP.LocLine1stR = 0, 0, TP.LocLine1stR)                 ' Return zero if no ZLOC else the line number
   FUNCTION = i                                                   '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LOCLINLNum() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the LOCATE line number                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_LOC_LNum() "                              '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(TP.LocLine1stR = 0, 0, TP.LocLine1stR)                 ' Return zero if no ZLOC else the line number
   i = VAL(TP.LLNumGet(i)): FUNCTION = i                          ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_MacName() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the current Macro name                                                                      |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_MacName$() "                              '
   FUNCTION  = gMacroName                                         ' Return Macro Name
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(gMacroName)                                           ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_MarkLine() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get MARK character string                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_MarkLine$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         '-                                                       '
      END IF                                                      '
   END IF                                                         '
   FUNCTION = IIF$(ISNULL(TP.FCB_.MarkLine), "NONE", TP.FCB_.MarkLine)  ' Return the string
   TP.ErrMsgReset                                                 ' Set ZRC
   DoTraceS(IIF$(ISNULL(TP.FCB_.MarkLine), "NONE", TP.FCB_.MarkLine))   ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_MaskLine() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get MASK character string                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_MaskLine$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         '-                                                       '
      END IF                                                      '
   END IF                                                         '
   FUNCTION = IIF$(ISNULL(TP.FCB_.MaskLine), "NONE", TP.FCB_.MaskLine)  ' Return the string
   TP.ErrMsgReset                                                 ' Set ZRC
   DoTraceS(IIF$(ISNULL(TP.FCB_.MaskLine), "NONE", TP.FCB_.MaskLine))   ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_MODIFIED() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Get the modified status                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Modified() "                              '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(IsTPModdFlag, %True, %False)                           ' Return modified status
   FUNCTION = i                                                   '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_MODIFIEDFILENAME() AS EXT                            '
'--------------------------------------------------------------------------------------------------+
'- Get the modified status of a file                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, XList AS STRING, i, j AS LONG                        '
   IF MACParseS("E", "Get_Modified_FileName", lText) THEN DoTrace: EXIT FUNCTION '
   IF ISTRUE (TP.TabMode AND %MEdit) THEN                         ' In MEdit mode
      i = TP.MeditTbl("S", ltext)                                 ' Get MEdit table index
      IF i = 0 THEN                                               ' Not found?
         j = %False: TP.ErrMsgAdd(8, "Filename not found")        ' Return
      ELSE                                                        '
         j = TP.MEditFlagGet(i): TP.ErrMsgReset                   ' Return the modified flag
      END IF                                                      '
   ELSE                                                           '
      j = IIF(IsTPModdFlag, %True, %False)                        ' Return modified status
      TP.ErrMsgReset                                              ' ZRC = OK
   END IF                                                         '
   FUNCTION = j                                                   ' Return value
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_MSG() AS STRING                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the Error message                                                                           |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_Msg$() "                                  '
   FUNCTION = TRIM$(TP.ErrMsgTop)                                 ' Error message
   DoTraceS(TRIM$(TP.ErrMsgTop))                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_LPtr() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Convert External to Internal line number                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS STRING, i AS LONG                                    '
   IF MACParseS("E", "Get_LPtr", lno) THEN DoTrace: EXIT FUNCTION '
   i = TP.LineNoRef(lno)                                          ' Go look it up
   IF i = -1 THEN i = 0                                           ' Make the -1 into a zero
   FUNCTION = i                                                   ' Return it
   TP.ErrMsgAdd(IIF(i <> 0, 0, 8), IIF$(i <> 0, "", "Invalid line number"))   ' Set ZRC
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_NextLPtr() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Get the Next +/- line pointer of a type                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lptr, lincr AS EXT, ltype, ltype2, t AS STRING, k AS LONG   '
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   gMacroTHeader = "Get_Next_Lptr() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lincr = 1: ltype = "DATA"                                      '
   IF thinBasic_CheckOpenParens THEN                              ' Better have a Open (
      thinBasic_ParseNumber lptr                                  ' Get the current line pointer
      IF thinBasic_CheckComma(%True, %True) THEN                  ' See if optional comma
         thinBasic_ParseNumber lincr                              ' Get 2nd operand into the increment
         IF thinBasic_CheckComma(%True, %True) THEN               ' See if optional data type
            thinBasic_ParseString ltype                           ' Fetch the optional type
            IF thinBasic_CheckCloseParens THEN                    ' End of a 3 parameter set?
               gMacroTHeader = "Get_Next_Lptr(" + FORMAT$(lptr) + ", " + FORMAT$(lincr) + ", " + ltype + ") "  '
               IF IsNE(ltype, "DATA") AND IsNE(ltype, "SPECIAL") AND LEFT$(ltype, 1) <> ":" THEN   ' Valid type?
                  FUNCTION = 0                                    '
                  TP.ErrMsgAdd(8, "Invalid Line type argument")   ' Fail it
                  DoTrace                                         ' Do trace if needed
                  EXIT FUNCTION                                   '
               END IF                                             '
            ELSE                                                  '
               EXIT FUNCTION                                      '
            END IF                                                '
         ELSEIF thinBasic_CheckCloseParens THEN                   ' Closing ) after 2nd param
            gMacroTHeader = "Get_Next_Lptr(" + FORMAT$(lptr) + ", " + FORMAT$(lincr) + ") "  '
         END IF                                                   '
      ELSEIF thinBasic_CheckCloseParens THEN                      ' Better be a closing ) after 1st param
         gMacroTHeader = "Get_Next_Lptr(" + FORMAT$(lptr) + ") "  '
      END IF                                                      '

      IF lincr = 0 THEN                                           ' Must not be zero
         FUNCTION = 0: TP.ErrMsgAdd(8, "Invalid number of lines argument") ' Fail it
         DoTrace                                                  ' Do trace if needed
         EXIT FUNCTION                                            '
      END IF                                                      '

      IF lptr < 1 OR lptr > TP.LastLine THEN                      ' Valid starting line pointer?
         FUNCTION = 0: TP.ErrMsgAdd(8, "Invalid starting line pointer argument") ' Fail it
         DoTrace                                                  ' Do trace if needed
         EXIT FUNCTION                                            '
      END IF                                                      '

      IF LEFT$(ltype, 1) = ":" THEN ltype2 = LSET$(UUCASE(ltype), 8) ' Pad to 8
      i = lincr: j = lptr                                         ' Copy params

      IF i > 0 THEN                                               ' Moving forward?
         DO WHILE i                                               ' While more lines to go forward
            IF LEFT$(ltype, 1) = ":" THEN                         ' Doing Tag search?
               DO                                                 ' Yes, loop forward till a Data line is seen
                  j = MIN(j + 1, TP.LastLine)                     '
                  t = TP.LTagGet(j)                               '
               LOOP UNTIL TP.LTagGet(j) = ltype2 OR j = TP.LastLine  '
            ELSEIF IsEQ(ltype, "DATA") THEN                       ' Doing Data lines?
               DO                                                 ' Yes, loop forward till a Data line is seen
                  j = MIN(j + 1, TP.LastLine)                     '
               LOOP UNTIL TP.LFlagData(j) OR j = TP.LastLine      '
            ELSE                                                  '
               DO                                                 ' Yes, loop forward till a non-Data line is seen
                  j = MIN(j + 1, TP.LastLine)                     '
               LOOP UNTIL ISFALSE TP.LFlagData(j) OR j = TP.LastLine '
            END IF                                                '

            IF j = TP.LastLine THEN EXIT DO                       ' OK if Row is at the end, stop
            DECR i                                                ' Else DECR the number we're supposed to do
         LOOP                                                     ' and loop till done

         IF j = TP.LastLine THEN                                  ' End of file?
            FUNCTION = 0: k = 0: TP.ErrMsgAdd(8, "Bottom of file reached") '
         ELSE                                                     '
            FUNCTION = j: k = j: TP.ErrMsgReset                   '
         END IF                                                   '
         DoTraceN(k)                                              ' Dump trace

      ELSE                                                        ' Moving backward
         DO WHILE i                                               ' While more lines to go forward
            IF LEFT$(ltype, 1) = ":" THEN                         ' Doing Tag search?
               DO                                                 ' Yes, loop foreward till a Data line is seen
                  j = MAX(j - 1, 1)                               '
               LOOP UNTIL TP.LTagGet(j) = ltype2 OR j = 1         '
            ELSEIF IsEQ(ltype, "DATA") THEN                       ' Doing Data lines?
               DO                                                 ' Yes, loop backward till a Data line is seen
                  j = MAX(j - 1, 1)                               '
               LOOP UNTIL TP.LFlagData(j) OR j = 1                '
            ELSE                                                  '
               DO                                                 ' Yes, loop backward till a Data line is seen
                  j = MAX(j - 1, 1)                               '
               LOOP UNTIL ISFALSE TP.LFlagData(j) OR j = 1        '
            END IF                                                '

            IF j = 1 THEN EXIT DO                                 ' OK if Row is at the top, stop
            INCR i                                                ' Else INCR the number we're supposed to do
         LOOP                                                     ' and loop till done

         IF j = 1 THEN                                            ' End of file?
            FUNCTION = 0: k = 0: TP.ErrMsgAdd(8, "Top of file reached") '
         ELSE                                                     '
            FUNCTION = j: k = j: TP.ErrMsgReset                   '
         END IF                                                   '
         DoTraceN(k)                                              ' Dump trace
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION Get_PanlHeight() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the height of the current Panel/Screen                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Panl_Height() "                           '
   i = TP.GPPanelHeight: TP.ErrMsgReset                           ' Return answer
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_PanlMode() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the width of the current Panel/Screen                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL s AS STRING                                                 '
   gMacroTHeader = "Get_Panl_Mode() "                             '
   IF TP.HPanelSplit = 0 AND TP.VPanelSplit = 0 THEN              ' No splits
      s = "NONE"                                                  ' Setup answer
   ELSEIF TP.HPanelSplit THEN                                     '
      s = "HORZ"                                                  '
   ELSE                                                           '
      s = "VERT"
   END IF                                                         '
   FUNCTION = s: TP.ErrMsgReset                                   '
   DoTraceS(s)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_PanlWidth() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get the width of the current Panel/Screen                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                 '
   i = TP.GPPanelWidth: TP.ErrMsgReset                            ' Return answer
   FUNCTION = i: : TP.ErrMsgReset                                 '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_PrimCmd() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the current Primary Command name                                                            |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_Primary_Cmd$() "                          '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = UCASE$(gCrashLastPCmd)                              '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(UCASE$(gCrashLastPCmd))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ProfString() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get a Profile string                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, t AS STRING                                          '
   IF MACParseS("E", "Get_Profile$", lText) THEN DoTrace: EXIT FUNCTION '
   TP.ErrMsgReset                                                 ' Assume all OK for now
   lText = UCASE$(lText)                                          ' Uppercase it
   t = ""                                                         ' Set a failing value
   SELECT CASE CONST$ lText                                       ' See what was asked for
      CASE "NAME":       t = TP.FCB_.ProfName                     '
      CASE "LOCK":       t = IIF$(TP.FCB_.LockFlag, "LOCKED", "UNLOCKED")  '
      CASE "ACTION":     t = IIF$(TP.FCB_.Actionsave, FORMAT$(TP.FCB_.ActionSave), "OFF") '
      CASE "AUTOBKUP":   t = IIF$(TP.FCB_.AutoBkup, "ON", "OFF")  '
      CASE "AUTOCAPS":   t = IIF$(TP.FCB_.AutoCaps, "ON", "OFF")  '
      CASE "AUTONAME":   t = IIF$(TP.FCB_.AutoName = "$NONE$", "NONE", TP.FCB_.AutoName)  '
      CASE "AUTOSAVE":   t = IIF$((TP.FCB_.AutoSave AND 1) = 1, "ON ", "OFF ")  + IIF$((TP.FCB_.AutoSave AND 2) = 2, "PROMPT", "NOPROMPT")   '
      CASE "BNDS":       t = FORMAT$(TP.FCB_.BndLeft) + " THRU " + IIF$(TP.FCB_.BndRight = 0, "MAX", FORMAT$(TP.FCB_.BndRight))  '
      CASE "BNDSLINE":   TP.FCB_.BuildBndText                     ' Build the string
                         t = TP.BndText                           ' Return the string
      CASE "BOM":        t = IIF$(TP.FCB_.BOM, "ON", "OFF")       '
      CASE "CAPS"                                                 '
                         IF TP.FCB_.CapsDesired <> 2 THEN         '
                            t = IIF$(TP.FCB_.CapsDesired, "ON", "OFF")  '
                         ELSE                                     '
                            t = IIF$(TP.FCB_.CapsActual, "AUTO:on", "AUTO:off")  '
                         END IF                                   '
      CASE "CASE":       t = UUCASE(TP.FCB_.CaseFlag)             '
      CASE "CHANGE":     t = IIF$(TP.FCB_.ChangeMode = "D", "DS", "CS") '
      CASE "COLS":       t = IIF$(TP.FCB_.Cols, "ON", "OFF")      '
      CASE "COLLATE":    t = TP.FCB_.CollateStr                   '
      CASE "COMMENTS":   t = FORMAT$(TP.FCB_.CmntID) + " " + FORMAT$(TP.FCB_.CmntCol) + " " + _ '
                             FORMAT$(TP.FCB_.CmntIncr) + " " + FORMAT$(TP.FCB_.CmntEnd)   '
      CASE "DCB":        t = TP.FCB_.RECFM + " " + FORMAT$(TP.FCB_.LRECL) + " " + IIF$(VERIFY(TP.FCB_.EOL, $Hex) = 0, "X'" + TP.FCB_.EOL + "'", TP.FCB_.EOL)   '
      CASE "EMACRO":     t = IIF$(ISNULL(TP.FCB_.EMacro), "NONE", uucase(TP.FCB_.EMacro)) '
                         IF t <> "NONE" THEN t += IIF$(uucase(TP.FCB_.EMacro) = TP.FCB_.EMacro, " ON", " OFF") '
      CASE "EFT":        t = TP.EFTOVListG(0)                     '
      CASE "EOL":        t = IIF$(VERIFY(TP.FCB_.EOL, $Hex) = 0, "X'" + TP.FCB_.EOL + "'", TP.FCB_.EOL)  '
      CASE "HEX":        t = IIF$(TP.FCB_.HexMode = 4, "ON", "OFF")  '
      CASE "HIDE":       t = "X " +IIF$(IsTPHideFlag, "ON", "OFF") + " FILE " + IIF$(IsTPFileHide, "ON", "OFF")   '
      CASE "HILITE":     IF ISFALSE TP.FCB_.HiFind AND ISFALSE TP.FCB_.HiAuto THEN  '
                            t = "OFF"                             '
                         ELSE                                     '
                            t = "FIND " + IIF$(TP.FCB_.HiFind, "ON", "OFF") + _  '
                               " AUTO " + IIF$(TP.FCB_.HiAuto, "ON", "OFF")   '
                         END IF                                   '
      CASE "INCLUDE":    t = IIF$(TP.FCB_.PInclude = "", "NONE", TP.FCB_.PInclude)  '
      CASE "IMACRO":     t = IIF$(ISNULL(TP.FCB_.IMacro), "NONE", uucase(TP.FCB_.IMacro)) '
                         IF t <> "NONE" THEN t += IIF$(uucase(TP.FCB_.IMacro) = TP.FCB_.IMacro, " ON", " OFF") '
      CASE "XTABS":      t = FORMAT$(TP.FCB_.ImportTabs)          '
      CASE "LRECL":      t = FORMAT$(TP.FCB_.LRECL)               '
      CASE "MACLIB":     t = IIF$(ISNULL(TP.FCB_.Maclib), "NONE", TP.FCB_.Maclib)   '
      CASE "MARK":       t = IIF$(TP.FCB_.MarkFlag, "ON", "OFF")  '
      CASE "MARKLINE":   t = IIF$(ISNULL(TP.FCB_.MarkLine), "NONE", TP.FCB_.MarkLine)  '
      CASE "MASK":       t = IIF$(ISNULL(TP.FCB_.MaskLine), "NONE", TP.FCB_.MaskLine)  '
      CASE "MASKLINE":   t = IIF$(ISNULL(TP.FCB_.MaskLine), "NONE", TP.FCB_.MaskLine)  '
      CASE "MINLEN":     t = FORMAT$(TP.FCB_.MINLEN)              '
      CASE "MODE":       t = SWITCH$(TP.FCB_.MODE = %Edit, "EDIT", TP.FCB_.MODE = %View, "VIEW", TP.FCB_.MODE = %Browse, "BROWSE")
      CASE "NOTIFY":     t = SWITCH$(gENV.NotifyLevelT = 0, "NONE", gENV.NotifyLevelT = 1, "EDIT", gENV.NotifyLevelT = 2, "ALL") '
      CASE "PAGE":       t = IIF$(TP.FCB_.PageFlag, _             '
                                         IIF$(TP.FCB_.PageFlag = 2, "SCROLL", "ON"), _ '
                                         "OFF") + _               '
                                    IIF$(TP.FCB_.PageOffset <> 0, "/" + FORMAT$(TP.FCB_.PageOffset, "+#;-#"), "") '
      CASE "PRESERVE":   t = IIF$(TP.FCB_.PreserveTyp = 0 , "OFF", IIF$(TP.FCB_.PreserveTyp = 1, "ON", "C"))   '
      CASE "RECFM":      t = TP.FCB_.RECFM                        '
      CASE "SCROLL":     t = TP.FCB_.ScrollAmt                    '
      CASE "SOURCE":     t = TP.FCB_.SourceName                   '
      CASE "START":      t = TP.FCB_.Start                        '
      CASE "STATE":      t = IIF$(TP.FCB_.StateFlag, "ON", "OFF") '
      CASE "SUBARG":     t = IIF$(ISNULL(TP.FCB_.SubArg), "NONE", TP.FCB_.SubArg)   '
      CASE "SUBCMD":     t = IIF$(ISNULL(TP.FCB_.SubCmd), "NONE", TP.FCB_.SubCmd)   '
      CASE "TABBNDS":    t = IIF$(TP.FCB_.TabBNDS, "ON", "OFF")   '
      CASE "TABS":       t = IIF$(TP.FCB_.Tabs, "ON", "OFF")      '
      CASE "TABSLINE":   t = IIF$(ISNULL(TP.FCB_.TabsLine), "NONE", TP.FCB_.TabsLine)  '
      CASE "WORD":       t = TP.FCB_.WordInput                    '
      CASE "XFORM":      t = IIF$(ISNULL(TP.FCB_.XFormStr), "NONE", uucase(TP.FCB_.XFormStr))   '
                         IF t <> "NONE" THEN t += IIF$(uucase(TP.FCB_.XFormStr) = TP.FCB_.XFormStr, " ON", " OFF")   '
      CASE ELSE                                                   ' Oops
         t = ""                                                   ' Return null
         TP.ErrMsgAdd(8, "Invalid Profile request")               ' Plus error msg
   END SELECT                                                     '
   FUNCTION = t                                                   ' Set the return value
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_RBOUND() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the right BOUNDS value                                                                      |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_RBound() "                                '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = TP.FCB_.BndRight: TP.ErrMsgReset                    ' Return the right bounds
   DoTraceN(TP.FCB_.BndRight)                                     ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_RC() AS EXT                                          '
'--------------------------------------------------------------------------------------------------+
'- Get the Error code                                                                              |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_RC() "                                    '
   FUNCTION = TP.ErrMsgHigh                                       ' Return Code
   DoTraceN(TP.ErrMsgHigh)                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_RIGHTSCRNCOL() AS EXT                                '
'--------------------------------------------------------------------------------------------------+
'- Get the Right visible screen column                                                             |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_RightScrn_Col() "                         '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = TP.GPOffset + TP.GPDataLen: TP.ErrMsgReset          ' Return RH col of screen
   DoTraceN(TP.GPOffset + TP.GPDataLen)                           ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ScrHeight() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get the height of the current full Screen                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Scr_Height() "                            '
   i = gENV.ScrHeight: TP.ErrMsgReset                             ' Return answer
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_ScrWidth() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Get the width of the current Panel/Screen                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Scr_Width() "                             '
   i = gENV.ScrWidth: TP.ErrMsgReset                              ' Return answer
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SelCol() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the selected starting column                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_SELECT_Col() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(IsTPMarkActive, TP.MarkGL, 0): TP.ErrMsgReset          ' Copy starting column
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SelFirst() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Get the selected starting line pointer                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Select_First_LPtr() "                     '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(IsTPMarkActive, TP.MarkGT, 0): TP.ErrMsgReset          ' Copy starting line
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SelFirstLNum() AS EXT                                '
'--------------------------------------------------------------------------------------------------+
'- Get the selected starting line number                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Select_First_LNum() "                     '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(IsTPMarkActive, TP.MarkGT, 0): TP.ErrMsgReset          ' Copy starting line
   i = VAL(TP.LLNumGet(i)): FUNCTION = i                          ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SelLast() AS EXT                                     '
'--------------------------------------------------------------------------------------------------+
'- Get the selected Last line pointer                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Select_Last_LPtr() "                      '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(IsTPMarkActive, TP.MarkGB, 0): TP.ErrMsgReset          ' Copy ending line
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SelLastLNum() AS EXT                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the selected Last line number                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_Select_Last_LNum() "                      '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(IsTPMarkActive, TP.MarkGB, 0): TP.ErrMsgReset          ' Copy ending line
   i = VAL(TP.LLNumGet(i)): FUNCTION = i                          ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SelLen() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the selected length                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_SELECT_Len() "                            '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = IIF(IsTPMarkActive, TP.MarkGR - TP.MarkGL + 1, 0): TP.ErrMsgReset   ' Return length
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SESSIONTYPE() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get Tab type                                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING                                             '
   gMacroTHeader = "Get_Session_Type$() "                         '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lText = SWITCH$(IsBrowse, "BROWSE", IsView, "VIEW", IsClip, "CLIP-EDIT", IsSetEdit, "SET-EDIT", IsEFTEdit, "EFT-EDIT", %True, "EDIT")  '
   IF lText = "VIEW" AND TP.FCB_.ROState THEN lText = "RDONLY"    '
   IF IsMedit THEN lText = "MEDIT"                                ' If MEdit, re-do it all
   FUNCTION = lText                                               '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(lText)                                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SETVAR() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get a SET variable                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, t AS STRING, RCA AS RCArea                         '
   IF MACParseS("", "Get_SetVar$", varname) THEN DoTrace: EXIT FUNCTION '
   SETTableUpd("GET", varname, RCA)                               ' Retrieve substitution value
   IF RCA.RC > 0 THEN                                             ' Not found?
      FUNCTION = "": t = ""                                       ' Return ""
      TP.ErrMsgAdd(8, "Unknown SET name")                         ' Set RC
   ELSE                                                           '
     t = RCA.Msg                                                  ' Set t for DoTraceS
     FUNCTION = RCA.Msg                                           ' Return looked up value
     TP.ErrMsgReset                                               ' ZRC = OK
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SOURCE2ANSI() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get the SOURCE -> ANSI translate table                                                          |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_SOURCE2ANSI_Table$() "                    '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION  = TP.FCB_.SS2A: TP.ErrMsgReset                       ' Return the table
   DoTraceS(TP.FCB_.SS2A)                                         ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SPFVersion() AS STRING                              '
'--------------------------------------------------------------------------------------------------+
'- Get the SPFLite version                                                                         |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_SPF_Version$() "                          '
   FUNCTION  = gENV.PgmVers: TP.ErrMsgReset                       ' Return the answer
   DoTraceS(gENV.PgmVers)                                         ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SRCL1() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Get the line command start line pointer                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
   gMacroTHeader = "Get_Src1_LPtr() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lno = IIF(gMacRange, IIF(gMacSFrom = 0, 0, gMacSFrom), 0)      ' If a range waiting, return the FromLin
   IF lno <> 0 THEN TP.UpdLControl(INT(lno))                      ' Reset the LLCtl area
   FUNCTION = lno                                                 ' Return the result
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(lno)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SRCL1LNum() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get the line command start line number                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
   gMacroTHeader = "Get_Src1_LNum() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lno = IIF(gMacRange, IIF(gMacSFrom = 0, 0, gMacSFrom), 0)      ' If a range waiting, return the FromLin
   IF lno <> 0 THEN TP.UpdLControl(INT(lno))                      ' Reset the LLCtl area
   lno = VAL(TP.LLNumGet(lno)): FUNCTION = lno                    ' Return answer
   TP.ErrMsgReset: DoTraceN(lno)                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SRCL2() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Get the line command end line pointer                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
   gMacroTHeader = "Get_Src2_LPtr() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lno = IIF(gMacRange, IIF(gMacSTo = 0, 0, gMacSTo), 0)          ' If a range waiting, return the ToLin
   IF lno <> 0 THEN TP.UpdLControl(INT(lno))                      ' Reset the LLCtl area
   FUNCTION = lno                                                 ' Return the result
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(lno)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SRCL2LNum() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get the line command end line number                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
   gMacroTHeader = "Get_Src2_LNum() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lno = IIF(gMacRange, IIF(gMacSTo = 0, 0, gMacSTo), 0)          ' If a range waiting, return the ToLin
   IF lno <> 0 THEN TP.UpdLControl(INT(lno))                      ' Reset the LLCtl area
   lno = VAL(TP.LLNumGet(lno)): FUNCTION = lno                    ' Return answer
   TP.ErrMsgReset: DoTraceN(lno)                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SRCLCMD() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the last line command                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   gMacroTHeader = "Get_SRC_LCmd$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   t = IIF$(gMacRange, gMacSCmd, ""): TP.ErrMsgReset              ' If a range waiting, return the LCmd
   FUNCTION = t                                                   '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SRCOP() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Get the line command numeric value                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL rpt AS LONG                                                 '
   gMacroTHeader = "Get_SRC_Op() "                                '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF gEDMacMode THEN                                             ' A LineCmd Macro
      rpt = gMacSRpt                                              ' Always pass back Rpt
   ELSE                                                           ' It's a Primary macro
      rpt =IIF(gMacSTo <> 0 OR gMacSFrom <> 0, gMacSTo - gMacSFrom + 1, gMacSRpt)   ' Pass it back
   END IF                                                         '
   FUNCTION = rpt                                                 ' Return the result
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(rpt)                                                  ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SRCLMOD$() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get the line command Post Operand                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL op AS STRING                                                '
   gMacroTHeader = "Get_SRC_LMOD$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   op = "  "                                                      ' Set default
   IF gMacRange THEN                                              ' If a range
      IF BIT(gMacSFlag, %lCmdX) THEN MID$(op, 1, 1) = "-"         ' Set +/- as appropriate
      IF BIT(gMacSFlag, %lCmdNX) THEN MID$(op, 1, 1) = "+"        '
      IF BIT(gMacSFlag, %lCmdR) THEN MID$(op, 2, 1) = "R"         '
   END IF                                                         '
   FUNCTION = op                                                  '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(op)                                                   ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_SYSVAR() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get a System gENV. variable                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL varname AS STRING                                           '
   IF MACParseS("", "Get_ENVVar$", varname) THEN DoTrace: EXIT FUNCTION '
   FUNCTION = ENVIRON$(varname)                                   ' Fetch environ string
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(ENVIRON$(varname))                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TabNum() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the active Tab Number                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_TabNum() "                                '
   FUNCTION = TP.PgNumber: TP.ErrMsgReset                         ' Return the result
   DoTraceN(TP.PgNumber)                                          ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TabsLine() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get TABS character string                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_TabsLine$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         '-                                                       '
      END IF                                                      '
   END IF                                                         '
   FUNCTION = IIF$(ISNULL(TP.FCB_.TabsLine), "NONE", TP.FCB_.TabsLine)  ' Return the string
   TP.ErrMsgReset                                                 ' Set ZRC
   DoTraceS(IIF$(ISNULL(TP.FCB_.TabsLine), "NONE", TP.FCB_.TabsLine))   ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_Tag() AS STRING                                      '
'--------------------------------------------------------------------------------------------------+
'- Get tag for a single line number                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING, i AS LONG                                      '
   IF MACParseI("E", "Get_Tag$", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION  '
   IF ISFALSE TP.LFlagData(i) THEN                                ' Not a data line?
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "Invalid line pointer") ' Else pass back null
   ELSE                                                           '
      t = TRIM$(TP.LTagGet(i)): FUNCTION = t: TP.ErrMsgReset      ' Yes, fetch the tag
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TOPSCREEN() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Get Line pointer of Top of Screen                                                               |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_TopScrn_LPtr() "                          '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION  = TP.GPTopLine: TP.ErrMsgReset                       ' Return TopScrn
   DoTraceN(TP.GPTopLine)                                         ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TOPSCREENLNum() AS EXT                               '
'--------------------------------------------------------------------------------------------------+
'- Get Line number of Top of Screen                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Get_TopScrn_LNum() "                          '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   i = VAL(TP.LLNumGet(TP.GPTopLine)): FUNCTION = i               ' Return answer
   TP.ErrMsgReset: DoTraceN(i)                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TrkLPtr() AS EXT                                     '
'--------------------------------------------------------------------------------------------------+
'- Convert TrackID to Internal line pointer                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lno, i, j AS LONG                                           '
   IF MACParseI("E", "Get_Trk_LPtr", lno) THEN DoTrace: EXIT FUNCTION   '
   i = TP.TrkSrch(lno)                                            ' See if we can find it
   j = IIF(i = 0, 0, i - 1)                                       ' Return it
   FUNCTION = j                                                   '
   TP.ErrMsgAdd(IIF(i <> 0, 0, 8), IIF$(i <> 0, "", "Line with Track ID no longer exists"))  '
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TrkPos() AS STRING                                   '
'--------------------------------------------------------------------------------------------------+
'- Get TRACK position                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL Lno, i, r, c AS LONG, TrkNum AS EXT, t AS STRING            '
LOCAL Trk AS TrkStackT                                            ' Working stack entry
   TrkNum = 1                                                     ' Default if no operand provided
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens(%True, %True) THEN            ' And if closed directly by a ) properly
         gMacroTHeader = "Get_Track_Pos$() "                      '
      ELSE                                                        ' Not an immediate )
         thinBasic_ParseNumber TrkNum                             ' Then get the Track index Number
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Get_Track_Pos$(" + FORMAT$(TrkNum) + ")"   '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   i = TrkNum                                                     ' Convert EXT to LONG
   Trk = TP.GetTrkStack(i)                                        ' Get the Stack entry
   IF Trk.TrkID = 0 THEN                                          ' Unused entry?
      FUNCTION = "": t = "": TP.ErrMsgAdd(8, "Requested STACK entry does not exist")   '
   ELSE                                                           '
      lno = TP.TrkSrch(Trk.TrkID)                                 ' See if we can find it
      IF lno = 0 THEN                                             ' Line missing? (i.e. deleted)
         FUNCTION = "": t = "": TP.ErrMsgAdd(8, "STACK Top-of-Screen line no longer exists") '
      ELSE                                                        '
         DECR lno                                                 ' Text Table is zero based
         IF Trk.TrkRow = 0 THEN                                   ' The Cmd line type?
            r = TP.GPTop: c = TP.GPCmdCol                         ' Set it
         ELSE                                                     '
            i = TP.TrkSrch(Trk.TrkRow)                            ' Go fetch LPtr for the TrkRow
            IF i = 0 THEN                                         ' Line missing? (i.e. deleted)
               r = TP.GPTop: c = TP.GPCmdCol                      ' Set to Cmd Line
            ELSE                                                  '
               r = i - 1: c = Trk.TrkCol                          ' Set cursor in text area
            END IF                                                '
         END IF                                                   '
         t = FORMAT$(lno) + "," + FORMAT$(r) + "," + FORMAT$(c)   ' Setup Topscrn
         FUNCTION = t                                             '                                                  ' Setup Topscrn
         TP.ErrMsgReset                                           ' Say answer is good
      END IF                                                      '
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TrkTrkID() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Convert LPtr to TrackID                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG                                                '
   IF MACParseI("E", "Get_Trk_TrkID", i) THEN DoTrace: EXIT FUNCTION '
   j = TP.LTrakGet(i)                                             ' Get the Track ID
   FUNCTION = j                                                   '
   TP.ErrMsgAdd(IIF(i <> 0, 0, 8), IIF$(i <> 0, "", "Line with LPtr no longer exists"))   '
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TxtColumns() AS EXT                                  '
'--------------------------------------------------------------------------------------------------+
'- Convert number of available text columns                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG                                                '
   gMacroTHeader = "Get_Txt_Columns() "                           '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = TP.GPDataLen: TP.ErrMsgReset                        ' Return the answer
   DoTraceN(TP.GPDataLen)                                         ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_TxtLines() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Convert number of available text lines                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG                                                '
   gMacroTHeader = "Get_Txt_Lines() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   FUNCTION = TP.GPDLines: TP.ErrMsgReset                         ' Return the answer
   DoTraceN(TP.GPDLines)                                          ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_UniqueID() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Get Unique Tab ID                                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL PID AS WORD, i AS LONG                                      '
   gMacroTHeader = "Get_Unique_ID() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   pid = GetCurrentProcessId                                      '
   i = (pid * 10000) + (TP.WindowID * 100)                        ' Return PID + WindowID
   FUNCTION = i                                                   '
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_WordChar() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Get WORD character string                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_WordChar$() "                             '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens(%True, %True) THEN                ' An Open (
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         '-                                                       '
      END IF                                                      '
   END IF                                                         '
   FUNCTION = TP.FCB_.WordStr                                     ' Return the string
   TP.ErrMsgReset                                                 ' Set ZRC
   DoTraceS(TP.FCB_.WordStr)                                      ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_WorkingDir() AS STRING                               '
'--------------------------------------------------------------------------------------------------+
'- Get WORD character string                                                                       |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Get_Working_Dir$() "                          '
   FUNCTION = gENV.WorkingDir: TP.ErrMsgReset                     ' Return answer
   DoTraceS(gENV.WorkingDir)                                      ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_BOTTOM() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Bottom status                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Bottom", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION '
   FUNCTION = ISTRUE TP.LFlagBottom(i): TP.ErrMsgReset            ' Return Bottom status
   DoTraceN(ISTRUE TP.LFlagBottom(i))                             ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_XLines() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get # Excluded lines in an X block                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i, j AS LONG                               '
   IF MACParseI("E", "Get_Xlines", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   IF ISTRUE TP.LFlagXClude(i) THEN                               ' Xclude line?
      j = TP.LWrk1Get(i): TP.ErrMsgReset                          ' Yes, pass back the number
   ELSE                                                           '
      j = 0: TP.ErrMsgAdd(8, "LPtr is not an Exclude Marker line")   '
   END IF                                                         '
   FUNCTION = j                                                   '
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Get_XStatus() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get Exclude status for a single line number                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING, i AS LONG                                      '
   IF MACParseI("E", "Get_XStatus$", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION '
   IF ISTRUE TP.LFlagInvisible(i) THEN                            ' Invisible line?
      t = "X": TP.ErrMsgReset                                     ' Else pass back X
   ELSE                                                           '
      t = "NX": TP.ErrMsgReset                                    ' Yes, pass back NX
   END IF                                                         '
   FUNCTION = t                                                   '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION HALT() AS EXT                                            '
'--------------------------------------------------------------------------------------------------+
'- Set Error state and exit                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, level, lRet AS LONG                        '
   IF MACParseIS("", "Halt", level, lText) THEN DoTrace: EXIT FUNCTION  '
   IF level <> 0 AND level <> 8 THEN                              ' Only allow 0 or 8
      gMacroRC = 8: gMacroMsg = "HALT RC can only be (OK or FAIL), setting to FAIL" '
   ELSE                                                           '
      gMacroRC = level: gMacroMsg = IIF$(level = 0, lText, "RC=" + FORMAT$(level) + ": " + lText)  '
   END IF                                                         '
   TP.ErrMsgAdd(level, gMacroMsg)                                 ' Dup in normal areas

   '---Unload all modules, release all memory
   CALL DWORD gMacRelease USING thinBasic_Release(0&) TO lRet     ' Will be used in future release

   '---Free loaded thinCore library
   FreeLibrary(gMacCore)                                          '
   TerminateThread BYVAL gMacThread, 900                          ' Second value is thread exit code

   FUNCTION = 0                                                   ' All is well.
END FUNCTION                                                      '

FUNCTION Has_HANDLE() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Release a Handle                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, lno AS EXT, i, j, k AS LONG                '
   gMacroTHeader = "Has_Handle() "                                '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber lno                                ' Then get the number
         gMacroTHeader = "Has_Handle(" + FORMAT$(lno) + ") "      ' Setup trace data
         IF LEFT$(FORMAT$(lno), 1) = "." THEN                     ' Is this an unquoted .nnn operand?
            i = TP.LineNoRef(FORMAT$(lno))                        ' Do a lookup on it
         ELSE                                                     ' Else just a number
            i = lno                                               ' Put line number in i
         END IF                                                   '
      ELSE                                                        '
         thinBasic_ParseString lText                              ' Then get the string
         gMacroTHeader = "Has_Handle(" + lText + ") "             ' Setup trace data
         IF LEFT$(lText, 1) = "." THEN                            ' A dotted line number?
            i = TP.LineNoRef(lText)                               ' Go look it up
         ELSEIF LEFT$(lText, 1) = "!" THEN                        ' A pure line reference
            i = VAL(MID$(lText, 2))                               ' Extract the line number
         ELSE                                                     ' Alphabetic, reject it
            i = 0                                                 ' Force failure
         END IF                                                   '
      END IF                                                      '
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         IF i > 0 AND i <= TP.LastLine AND ISTRUE TP.LFlagData(i) THEN  ' Within range and a Data Line?
            IF TP.LHndlGet(i) <> 0 THEN                           ' Was there a handle?
               k = %True:  TP.ErrMsgReset                         ' Return True
            ELSE                                                  ' Else false
               k = %False: TP.ErrMsgReset                         ' Return false
            END IF                                                '
         ELSE                                                     '
            k = %False: TP.ErrMsgAdd(8, "Invalid line pointer")   ' Else pass back error
         END IF                                                   '
      END IF                                                      '
      FUNCTION = k                                                ' Return answer
      DoTraceN(k)                                                 ' Dump the trace
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION Is_BNDS() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's BNDS status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_BNDS", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagBounds(i): TP.ErrMsgReset            ' Return BNDS status
   DoTraceN(ISTRUE TP.LFlagBounds(i))                             ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_COLS() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's COLS status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Cols", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagCols(i): TP.ErrMsgReset              ' Return COLS status
   DoTraceN(ISTRUE TP.LFlagCols(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION IsAvailableF() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- See if a filename is properly available i.e. exists and not in use                              |
'--------------------------------------------------------------------------------------------------+
LOCAL fname AS STRING, i AS LONG                                  '
   IF MACParseS("", "Is_Available", fname) THEN DoTrace: EXIT FUNCTION  '
   i = IsAvailable(fname)                                         ' Get the answer
   FUNCTION = i                                                   ' Send it back
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION IsCmdName() AS STRING                                    '
'--------------------------------------------------------------------------------------------------+
'- See if a string matches any command name                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, CType AS STRING, i AS LONG                         '
   IF MACParseS("", "Is_Cmd_Name$", varname) THEN DoTrace: EXIT FUNCTION   '
   IF gPCmdT.GetCmdIX(varname) THEN CType = "Primary,"            ' It matches a Primary command
   IF gLCmdT.GetCmdIX(varname) THEN CType += "Edit-Line,"         ' It matches an Edit Line command
   ARRAY SCAN gFMLCmdTable() FOR UBOUND(gFMLCmdTable()), FROM 1 TO 8, COLLATE UCASE, =LSET$(varname, 8), TO i  '
   IF i <> 0 THEN CType += "FM-Line"                              ' It matches an FM line command
   IF RIGHT$(CType, 1) = "," THEN CType = CLIP$(RIGHT, CType, 1)  ' Remove any trailing ,
   FUNCTION = CType                                               ' Return it
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(CType)                                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_DATA() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Data status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Data", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagData(i): TP.ErrMsgReset              ' Return Data status
   DoTraceN(ISTRUE TP.LFlagData(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_FILE() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's FILE status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_File", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagFile(i): TP.ErrMsgReset              ' Return FILE status
   DoTraceN(ISTRUE TP.LFlagFile(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_FM() AS LONG                                          '
'--------------------------------------------------------------------------------------------------+
'- Get FM status                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   gMacroTHeader = "Is_FM() "                                     ' Setup header
   i = %False                                                     ' Default &False
   IF IsFMTab THEN i = %True                                      ' Alter if needed
   TP.ErrMsgReset                                                 ' Set OK answer
   FUNCTION = i                                                   ' Return answer
   DoTraceN(i)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_MARK() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Mark status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Mark", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagMark(i): TP.ErrMsgReset              ' Return Mark status
   DoTraceN(ISTRUE TP.LFlagMark(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_MASK() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Mask status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Mask", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagMask(i): TP.ErrMsgReset              ' Return Mask status
   DoTraceN(ISTRUE TP.LFlagMask(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_NOTE() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Note status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Note$", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION  '
   FUNCTION = ISTRUE TP.LFlagNote(i): TP.ErrMsgReset              ' Return Note status
   DoTraceN(ISTRUE TP.LFlagNote(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_PAGE() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's PAGE status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Page", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagPage(i): TP.ErrMsgReset              ' Return PAGE status
   DoTraceN(ISTRUE TP.LFlagPage(i))                               ' Do trace if needed
END FUNCTION
                                                     '
FUNCTION Is_Prof() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Prof status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Prof", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagProf(i): TP.ErrMsgReset              ' Return Prof status
   DoTraceN(ISTRUE TP.LFlagProf(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_TABS() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Tabs status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Tabs", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagTabs(i): TP.ErrMsgReset              ' Return Tabs status
   DoTraceN(ISTRUE TP.LFlagTabs(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_TOP() AS EXT                                          '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Top status                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Top", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION '
   FUNCTION = ISTRUE TP.LFlagTop(i): TP.ErrMsgReset               ' Return Top status
   DoTraceN(ISTRUE TP.LFlagTop(i))                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_ULINE() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Get the line's User status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_ULine", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION  '
   FUNCTION = ISTRUE TP.LFlagUser(i): TP.ErrMsgReset              ' Return User status
   DoTraceN(ISTRUE TP.LFlagUser(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_WORD() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Get the line's WORD status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_Word", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagWord(i): TP.ErrMsgReset              ' Return WORD status
   DoTraceN(ISTRUE TP.LFlagWord(i))                               ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_XLine() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Get the line's Invisible status                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_XLine", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION  '
   FUNCTION = ISTRUE TP.LFlagInvisible(i): TP.ErrMsgReset         ' Return Excl status
   DoTraceN(ISTRUE TP.LFlagInvisible(i))                          ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_XMARKER() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the line's EXCL status                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Is_XMarker", i, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION   '
   FUNCTION = ISTRUE TP.LFlagXclude(i): TP.ErrMsgReset            ' Return Excl status
   DoTraceN(ISTRUE TP.LFlagXclude(i))                             ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_PrimCmd() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the macro execution mode                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL lcmd AS STRING, i, j AS LONG                                '
   gMacroTHeader = "Is_Primary_Cmd() "                            '
   IF IsFMTab THEN                                                ' If FM then
      j = IIF(gFMMacMode = 0, %True, %False)                      ' Set the answer
   ELSE                                                           '
      lcmd = TRIM$(gLTblSCmd)                                     ' Format the cmd name
      IF lcmd = "" THEN                                           ' If no Lcmd
         j = %True                                                ' Pass back true
      ELSE                                                        '
         i = gLCmdT.GetCmdIX(lcmd)                                ' See if source command is an internal line command
         j = IIF(i, %True, %False)                                ' Pass back answer
      END IF                                                      '
   END IF                                                         '
   FUNCTION = j                                                   ' Pass back answer
   TP.ErrMsgReset                                                 '
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Is_LineCmd() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Get the macro execution mode                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL lcmd AS STRING, i, j AS LONG                                '
   gMacroTHeader = "Is_Line_Cmd() "                               '
   IF IsFMTab THEN                                                ' If FM then
      j = IIF(gFMMacMode = 1, %True, %False)                      ' Set the answer
   ELSE                                                           '
      lcmd = TRIM$(gLTblSCmd)                                     ' Format the cmd name
      IF lcmd = "" THEN                                           ' If no Lcmd
         j = %False                                               ' Pass back false
      ELSE                                                        '
         i = gLCmdT.GetCmdIX(lcmd)                                ' See if source command is an internal line command
         j = IIF(i, %False, %True)                                ' Pass back answer
      END IF                                                      '
   END IF                                                         '
   FUNCTION = j                                                   ' Return result
   TP.ErrMsgReset                                                 '
   DoTraceN(j)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Last_Handle() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the Highest active Handle                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   gMacroTHeader = "Last_Handle "                                 '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   t = IIF$(TP.HandleMax <> 0, "._" + FORMAT$(TP.HandleMax), "")  ' Return it (or Null)
   FUNCTION = t                                                   '
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Next_Handle() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the Next Highest active Handle                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, t AS STRING, Hndl1, Hndl2, i, j AS LONG              '
   IF MACParseS("E", "Next_Handle$", lText) THEN DoTrace: EXIT FUNCTION '
   gMacroTHeader = "Next_Handle(" + lText + ") "                  ' Replace trace header
   IF LEFT$(lText, 2) <> "._" THEN                                ' Better look like a Handle
      FUNCTION = "": TP.ErrMsgAdd(8, "Invalid Handle pointer")    ' Else pass back error
      DoTrace: EXIT FUNCTION                                      ' Set ZRC
   ELSE                                                           '
      Hndl1 = VAL(MID$(lText, 3))                                 ' Get the operand handle number
      FOR i = 1 TO TP.LastLine                                    ' Loop through the file
         j = TP.LHndlGet(i)                                       ' Get line's handle
         IF ISFALSE j OR j <= Hndl1 THEN ITERATE FOR              ' Skip if none or less than operand

         IF ISFALSE Hndl2 THEN                                    ' If no candidate yet?
            Hndl2 = j: ITERATE FOR                                ' Pick this guy as a start
         ELSE                                                     ' We have an existing candidate
            IF j < Hndl2 THEN Hndl2 = j                           ' Lower?  Then swap as new winner
         END IF                                                   '
      NEXT i                                                      '
      t = IIF$(Hndl2 = 0, "", "._" + FORMAT$(Hndl2))              ' Pass back next Handle of "" for end
      FUNCTION = t                                                '
      TP.ErrMsgReset                                              ' ZRC = OK
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION NOP() AS EXT                                             '
'--------------------------------------------------------------------------------------------------+
'- Do nothing                                                                                      |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "NOP() "                                       '
   FUNCTION = 0: TP.ErrMsgReset                                   ' Pass back all OK
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION OV() AS EXT                                              '
'--------------------------------------------------------------------------------------------------+
'- Return -1                                                                                       |
'--------------------------------------------------------------------------------------------------+
   FUNCTION = -1                                                  ' Pass back answer
END FUNCTION                                                      '

FUNCTION Prev_Handle() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Get the Next Lowest active Handle                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, t AS STRING, Hndl1, Hndl2, i, j AS LONG              '
   IF MACParseS("E", "Prev_Handle$", lText) THEN DoTrace: EXIT FUNCTION '
   gMacroTHeader = "Prev_Handle(" + lText + ") "                  ' Replace trace header
   IF LEFT$(lText, 2) <> "._" THEN                                ' Better look like a Handle
      FUNCTION = "": TP.ErrMsgAdd(8, "Invalid Handle pointer")    ' Else pass back error
      DoTrace: EXIT FUNCTION                                      ' Set ZRC
   ELSE                                                           '
      Hndl1 = VAL(MID$(lText, 3))                                 ' Get the operand handle number
      FOR i = 1 TO TP.LastLine                                    ' Loop through the file
         j = TP.LHndlGet(i)                                       ' Get line's handle
         IF ISFALSE j OR j >= Hndl1 THEN ITERATE FOR              ' Skip if none or greater than operand

         IF ISFALSE Hndl2 THEN                                    ' If no candidate yet?
            Hndl2 = j: ITERATE FOR                                ' Pick this guy as a start
         ELSE                                                     ' We have an existing candidate
            IF j > Hndl2 THEN Hndl2 = j                           ' Higher?  Then swap as new winner
         END IF                                                   '
      NEXT i                                                      '
      t = IIF$(Hndl2 = 0, "", "._" + FORMAT$(Hndl2))              ' Pass back next Handle of "" for end
      FUNCTION = t                                                '
      TP.ErrMsgReset                                              ' ZRC = OK
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Reset_GBLNum() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Clear a table                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, o AS LONG, level AS EXT, varprefix, lclprefix, varname, varvalue AS STRING
   level = -1                                                     ' Say no table number
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_CheckCloseParens(%True, %True) THEN            ' And if closed directly by a ) properly
         gMacroTHeader = "Reset_GBL_Num() "                       '

      ELSE                                                        ' Not an immediate )
         thinBasic_ParseNumber level                              ' Then get the table number
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Reset_GBL_Num(" + FORMAT$(level) + ")"   '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   j = gNumVar.Count                                              ' Get  total # items in the collection
   '-----------------------------------------------------------------------------------------------+
   '- Doing all or just one table                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF level = -1 THEN                                             '
      IF j > 0 THEN                                               ' Some entries?
         gNumVar.Clear                                            ' Clear the collection
         FUNCTION = 0: TP.ErrMsgAdd(8, "Deleted Item count: " + FORMAT$(j))   ' Return count
      ELSE                                                        '
         FUNCTION = 0: TP.ErrMsgAdd(8, "Table was already empty") ' Return code
      END IF                                                      '
      DoTrace                                                     ' Do trace if needed
   ELSE                                                           '
      '--------------------------------------------------------------------------------------------+
      '- Clear just one table                                                                      |
      '--------------------------------------------------------------------------------------------+
      varprefix = FORMAT$(level) + ","                            ' Build table prefix string
      IF j > 0 THEN                                               ' If anything in the collection
         FOR i = j TO 1 STEP -1                                   ' Loop through it
            varname = gNumVar.GetIXKey(i)                         '
            IF ISNOTNULL(varname) THEN                            ' If OK
               lclprefix = LEFT$(varname, INSTR(varname, ","))    ' Extract the table number
               IF lclprefix = varprefix THEN                      ' Is this one we want?
                  gNumVar.Remove(varname)                         ' Delete it
                  INCR k                                          ' Count deleted
               END IF                                             '
            ELSE                                                  ' Error
               ITERATE FOR                                        ' Ignore it
            END IF                                                '
         NEXT i                                                   '
         FUNCTION = 0: TP.ErrMsgAdd(8, "Deleted Item count: " + FORMAT$(k))   ' Return code
      ELSE                                                        '
         FUNCTION = 0: TP.ErrMsgAdd(8, "Table was already empty") ' Return code
      END IF                                                      '
   END IF                                                         '
   DoTrace                                                        '                                                         '
END FUNCTION                                                      '

FUNCTION Reset_GBLSTR() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Clear a table                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, o AS LONG, level AS EXT, varprefix, lclprefix, varname, varvalue AS STRING
   level = -1                                                     ' Say NO table number
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_CheckCloseParens(%True, %True) THEN            ' And if closed directly by a ) properly
         gMacroTHeader = "Reset_GBL_Str() "                       '

      ELSE                                                        ' Not an immediate )
         thinBasic_ParseNumber level                              ' Then get the table number
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Reset_GBL_Str(" + FORMAT$(level) + ")"   '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Doing all or just one table                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF level = -1 THEN                                             ' All?
      gStrVar.Clear                                               ' Clear the collection
      FUNCTION = 0: TP.ErrMsgAdd(0, "Deleted All Tables")         ' Return code
      DoTrace                                                     ' Do trace if needed
   ELSE                                                           '
      '--------------------------------------------------------------------------------------------+
      '- Clear just one table                                                                      |
      '--------------------------------------------------------------------------------------------+
      varprefix = FORMAT$(level) + ","                            ' Build table prefix string
      j = gStrVar.Count                                           ' Get # items in the whole collection
      IF j > 0 THEN                                               ' If anything in the collection
         FOR i = j TO 1 STEP -1                                   ' Loop through it
            varname = gStrVar.GetIXKey(i)                         '
            IF ISNOTNULL(varname) THEN                            ' If OK
               lclprefix = LEFT$(varname, INSTR(varname, ","))    ' Extract the table number
               IF lclprefix = varprefix THEN                      ' Is this one we want?
                  gStrVar.Remove(varname)                         ' Delete it
                  INCR k                                          ' Count deleted
               END IF                                             '
            ELSE                                                  ' Error
               EXIT FOR                                           ' Bail out
            END IF                                                '
         NEXT i                                                   '
         FUNCTION = 0: TP.ErrMsgAdd(0, "Deleted Item count: " + FORMAT$(k))   ' Return code
      ELSE                                                        '
         FUNCTION = 0: TP.ErrMsgAdd(0, "Table was already empty") ' Return code
      END IF                                                      '
      DoTrace                                                  '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION ParseLoad() AS LONG                                      '
'--------------------------------------------------------------------------------------------------+
'- Restore the main command parse data                                                             |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Restore_SrchArgs "                            '
   TP.PTBLLoad()                                                  ' Restore the saved PTBL
   FUNCTION = 0                                                   ' All is well
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(0)                                                    ' Do trace if needed
END FUNCTION                                                      '


FUNCTION ParseSave() AS LONG                                      '
'--------------------------------------------------------------------------------------------------+
'- Save the main command parse data                                                                |
'--------------------------------------------------------------------------------------------------+
   gMacroTHeader = "Save_SrchArgs "                               '
   TP.PTBLSave()                                                  ' Copy the current PTBL
   FUNCTION = 0                                                   ' All is well
   TP.ErrMsgReset                                                 ' ZRC = OK
   DoTraceN(0)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Set_ClrLINE() AS EXT                                     '
'--------------------------------------------------------------------------------------------------+
'- Set color text for a line                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, lclnHiLites AS STRING, lwText AS WSTRING, lno, i, j, k AS LONG, aTxt AS WSTRING POINTER, AttrAsc AS WORD   '
   IF MACParseIS("E", "Set_Clr_Line", i, lText) THEN DoTrace: EXIT FUNCTION   '
   lText = UUCASE(lText)                                          ' Uppercase it
   IF i > 0 AND i <= TP.LastLine THEN                             ' Within range?
      IF ISFALSE TP.LFlagData(i) THEN                             ' Ineligible line?
         TP.ErrMsgAdd(8, "Non-Data line")                         ' Set ZRC
      ELSE                                                        '
         lclnHiLites = " " + gHiLitesChrs                         ' Add blank to valid chars
         IF VERIFY(LText,lclnHiLites) > 0 THEN                    ' Invalid characters?
            TP.ErrMsgAdd(8, "Invalid color request characters")   ' Set ZRC
            FUNCTION = 8                                          '
         ELSE                                                     '
            lText = LSET$(lText, TP.LTxtLen(i))                   ' Make = text length
            lwText = LSET$(lwText, TP.LTxtLen(i) USING CHR$$(0))  ' Make Attr = text length
            aTxt = TP.LAttrPtr(i)                                 ' Get address of existing Attr data
            FOR j = 1 TO LEN(lwText)                              ' Update the Attribute line now
               AttrAsc = ASC(@aTxt, j) AND (%AttrAll - %AttrHiLite)  ' Get Attr without the HiLite bits
               k = INSTR(lclnHiLites, MID$(lText, j, 1)) - 1      ' Get HiLite Index
               SHIFT LEFT k, 12                                   ' Align it properly
               AttrAsc = AttrAsc OR k                             ' Stuff it in the Attribute byte
               MID$(@aTxt, j, 1) = CHR$$(AttrAsc)                 '
            NEXT j                                                '
            TP.ModSet(i)                                          ' Remember we changed something
         END IF                                                   '
      END IF                                                      '
      DoTrace                                                     ' Do trace if needed
   END IF                                                         '
   FUNCTION = TP.ErrMsgHigh                                       ' Set return
END FUNCTION                                                      '

FUNCTION Set_CSR() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Set next cursor position                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lno, colno, lgth AS EXT, ilno, icol, ilgth AS LONG          '
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      thinBasic_ParseNumber lno                                   ' Then get the line number
      IF thinBasic_CheckComma() THEN                              ' A Comma?
         thinBasic_ParseNumber colno                              ' Then get the column number
         IF thinBasic_CheckComma(%True, %True) THEN               ' A Comma?
            thinBasic_ParseNumber lgth                            ' Then get the length
            IF thinBasic_CheckCloseParens THEN                    ' And if closed by ) properly
               '-                                                 '
            END IF                                                '
            gMacroTHeader = "Set_Csr(" + FORMAT$(lno) + ", " + FORMAT$(colno) + ", " + FORMAT$(lgth) + ") " '
         ELSE                                                     ' No length
            lgth = 0                                              ' Default to zero
            IF thinBasic_CheckCloseParens THEN                    ' And if closed by ) properly
                                                                  '
            END IF                                                '
            gMacroTHeader = "Set_Csr(" + FORMAT$(lno) + ", " + FORMAT$(colno) + ") "   '
         END IF                                                   '
         ilno = INT(lno): icol = INT(colno): ilgth = INT(lgth)    ' Make long
         IF ilno > 0 AND ilno < TP.LastLine THEN                  ' Within range?
            TP.CurSetReq(%CurMacro, ilno, icol, %True)            '
            IF ilgth > 0 THEN TP.AttrInvSet(ilno, icol, icol + ilgth - 1)  ' Set for Hi-Lite
            TP.ErrMsgReset                                        '
         ELSE                                                     '
            TP.ErrMsgAdd(8, "Invalid line pointer")               ' Bad line pointer
         END IF                                                   '
         DoTrace                                                  ' Do trace if needed
      END IF                                                      '
   END IF                                                         '
   FUNCTION = TP.ErrMsgHigh                                       ' Set return
END FUNCTION                                                      '

FUNCTION Set_GBLNUM() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Set a GBL NUM variable                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL varprefix, varname, varvalue AS STRING, i AS LONG, level, varvaluex AS EXT  '
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber level                              ' Then get the table number
         varprefix = FORMAT$(level) + ","                         ' Format it
         IF thinBasic_CheckComma() THEN                           ' A comma?
            '-                                                    ' Better be there
         END IF                                                   '
      ELSE                                                        ' No table prefix - assign zero
         varprefix = "0,"                                         '
      END IF                                                      '
      thinBasic_ParseString varname                               ' Then get the variable name
      varname = varprefix + varname                               ' Add the table prefix
      IF thinBasic_CheckComma() THEN                              ' A Comma?
         thinBasic_ParseNumber varvaluex                          ' Then get the string
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Set_Gbl_Num(" + varname + ", " + FORMAT$(varvaluex) + ") " '
            TP.ErrMsgReset                                        ' Default answers
            IF ISNULL(varname) THEN                               ' Null?  Ignore it
               FUNCTION = 0                                       ' Return OK
               EXIT FUNCTION                                      '
            END IF                                                '
            varvalue = FORMAT$(varvaluex)                         '
            gNumVar.AddRep(varname, varvalue)                     ' Try the Add
            DoTrace                                               ' Do trace if needed
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION Set_GBLSTR() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Set a GBL STR variable                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL varprefix, varname, varvalue AS STRING, i AS LONG, level AS EXT
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber level                              ' Then get the table number
         varprefix = FORMAT$(level) + ","                         ' Format it
         IF thinBasic_CheckComma() THEN                           ' A comma?
            '-                                                    ' Better be there
         END IF                                                   '
      ELSE                                                        ' No table prefix - assign zero
         varprefix = "0,"                                         '
      END IF                                                      '
      thinBasic_ParseString varname                               ' Then get the variable name
      varname = varprefix + varname                               ' Prefix it
      IF thinBasic_CheckComma() THEN                              ' A Comma?
         thinBasic_ParseString varvalue                           ' Then get the string
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Set_Gbl_Str(" + varname + ", " + varvalue + ") " '
            TP.ErrMsgReset                                        ' Default answers
            IF ISNULL(varname) THEN                               ' Null?  Ignore it
               FUNCTION = 0                                       ' Return OK
               EXIT FUNCTION                                      '
            END IF                                                '
            gStrVar.AddRep(varname, varvalue)                     ' Try the Add
            DoTrace                                               ' Do trace if needed
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION Set_LCSR() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Set logical cursor position                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lno, colno, lgth AS LONG, ilno, icol, ilgth AS LONG         '
   IF MACParseII("E", "Set_LCsr", lno, colno, 1, (TP.LastLine - 1)) THEN DoTrace: EXIT FUNCTION '
   TP.SLine = lno: TP.SCol = colno                                ' Store them
   gMacLCsr = %True                                               ' Tell Search we've set it
   DoTrace                                                        ' Do trace if needed
   TP.ErrMsgReset                                                 '
END FUNCTION                                                      '

FUNCTION Set_LINE() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Set text for a line                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i, j AS LONG, aTxt AS WSTRING POINTER      '
   IF MACParseIS("", "Set_Line", i, lText) THEN DoTrace: EXIT FUNCTION  '
   IF i = 0 THEN                                                  ' Request for Cmd Line?
      TP.CmdStackAdd(lText)                                       ' Save in the CmdStack array
      TP.ErrMsgReset                                              ' Set ZRC
   ELSEIF IsFMtab THEN                                            ' Only line 0 allowed in FM
      TP.ErrMsgAdd(8, "Only Set_Line(0,xxx) allowed in FM")       ' Set ZRC
      doTrace                                                     '
      EXIT FUNCTION                                               '
   ELSEIF i > 0 AND i <= TP.LastLine THEN                         ' Within range?
      IF ISTRUE (TP.LFlagGet(i) AND %NonTypable) THEN             ' Ineligible line?
         TP.ErrMsgAdd(8, "Non-modifyable line type")              ' Set ZRC
      ELSE                                                        '
         TP.LTxtSet(i, lText)                                     ' Yes, set the text
         TP.ModSet(i)                                             ' Remember we changed something
         TP.ErrMsgReset                                           ' Set ZRC
         IF TP.LFlagWord(i) THEN TP.WordSave                      '
         IF TP.LFlagMark(i) THEN TP.MarkSave                      '
         IF TP.LFlagMask(i) THEN TP.MaskSave                      '
         IF TP.LFlagBounds(i) THEN TP.BndsSave                    '
         IF TP.LFlagTabs(i) THEN TP.TabsSave                      '
         aTxt = TP.LAttrPtr(i)                                    ' Get it
         @aTxt = LSET$(@aTxt, TP.LTxtLen(i) USING CHR$$(0))       ' Make = text length
         TP.AttrScan(i)                                           ' Recolorize
      END IF                                                      '
   ELSE                                                           '
      TP.ErrMsgAdd(8, "Invalid line pointer")                     ' Set ZRC
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' Set return
END FUNCTION                                                      '

FUNCTION Set_MARK() AS LONG                                       '
'--------------------------------------------------------------------------------------------------+
'- Set MARK Line                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING, i AS LONG                           '
   IF MACParseS("", "Set_Mark", lText) THEN DoTrace: EXIT FUNCTION   '
   TP.FCB_.MarkLine = lText                                       ' Save it
   TP.ErrMsgReset                                                 ' Set RC etc.
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Set_MASK() AS LONG                                       '
'--------------------------------------------------------------------------------------------------+
'- Set MASK Line                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING, i AS LONG                           '
   IF MACParseS("", "Set_Mask", lText) THEN DoTrace: EXIT FUNCTION   '
   TP.FCB_.MaskLine = lText                                       ' Save it
   TP.MaskLine = lText                                            ' Copy for TP VARPTR usage
   TP.ErrMsgReset                                                 ' Set RC etc.
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Set_MSG() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Set error messages                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING, i AS LONG                           '
   IF MACParseIS("", "Set_Msg", i, lText) THEN DoTrace: EXIT FUNCTION   '
   IF i <> 0 AND i <> 8 THEN                                      ' Only allow 0 or 8
      gMacroRC = 8: gMacroMsg = "MSG RC can only be (OK or FAIL), setting to FAIL"  '
   ELSE                                                           '
      gMacroRC = i: gMacroMsg = IIF$(i = 0, lText, "RC=" + FORMAT$(i) + ": " + lText)  '
   END IF                                                         '
   TP.ErrMsgAdd(gMacroRC, gMacroMsg)                              ' Dup in normal areas
   DoTrace                                                        ' Do trace if needed
   FUNCTION = 0                                                   ' All is well.
END FUNCTION                                                      '

FUNCTION Set_SETVAR() AS EXT                                      '
'--------------------------------------------------------------------------------------------------+
'- Set a SET variable                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL varname, varvalue, SetRet AS STRING, ctab, i AS LONG, RCA AS RCArea  '
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      thinBasic_ParseString varname                               ' Then get the variable name
      IF thinBasic_CheckComma() THEN                              ' A Comma?
         thinBasic_ParseString varvalue                           ' Then get the string
         IF thinBasic_CheckCloseParens THEN                       ' And if closed by ) properly
            gMacroTHeader = "Set_SETVar(" + varname + ", " + varvalue + ") "  '
            ctab = TP.PgNumber                                    ' Save where we are
            FOR i = 1 TO gTabsNum                                 ' Do for each tab
               TP = gTabs(i)                                      ' Pick the Tab
               IF IsSetEdit THEN                                  ' We have a SetEdit tab active
                  TP = gTabs(ctab)                                ' Replace TP
                  FUNCTION = 8: TP.ErrMsgAdd(8, "A SET-EDIT session is active")  ' Set fail RC
                  EXIT FUNCTION                                   '
               END IF                                             '
            NEXT i                                                '
            TP = gTabs(ctab)                                      ' Replace TP
            SETTableUpd("SET", varname + " " + varvalue, RCA)     ' Do the variable SET
            IF RCA.RC > 0 THEN                                    ' Error?
               FUNCTION = RCA.RC                                  ' Return code
               TP.ErrMsgAdd(RCA.RC, TRIM$(RCA.Msg))               '
            ELSE                                                  '
               FUNCTION = 0: TP.ErrMsgReset                       ' Return OK
            END IF                                                '
            DoTrace                                               ' Do trace if needed
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION Set_TABS() AS LONG                                       '
'--------------------------------------------------------------------------------------------------+
'- Set TABS Line                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i, j AS LONG                               '
   IF MACParseS("", "Set_Tabs", lText) THEN DoTrace: EXIT FUNCTION   '
   i = INSTR(-1, lText, "+")                                      ' Get location of last + sign
   j = INSTR(-1, lText, "*")                                      ' Get location of last * sign
   IF i > 0 AND j > 0 AND j > i THEN                              '
      lText = ""                                                  '
      FUNCTION = 8: TP.ErrMsgAdd(8, "Invalid TABS line, TABS reset to Null")  ' Set fail RC
      TP.FCB_.TabsLine = "": TP.TabsLine = ""                     '
   ELSE                                                           '
      TP.FCB_.TabsLine = lText: TP.TabsLine = lText               ' Set it into the Profile and TP
      TP.ErrMsgReset                                              ' Set RC etc.
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Set_TOPSCREEN() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Set Line pointer of Top of Screen                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   IF MACParseI("E", "Set_TopScrn_LPtr", i, 1, TP.LastLine - 1) THEN DoTrace: EXIT FUNCTION  '
   IF i <> TP.GPTopLine THEN                                      ' Topscrn elsewhere right now?
      TP.LFlagBitOff(TP.GPTopLine, %TopScreen)                    ' Clear current TopScrn line flag
   END IF                                                         '
   TP.SPTopLine(i)                                                ' Set to our choice
   TP.LFlagBitOn(i, %TopScreen)                                   ' Move %TopScreen to our choice
   TP.ErrMsgReset                                                 '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' Set return
END FUNCTION                                                      '

FUNCTION Set_WORD() AS LONG                                       '
'--------------------------------------------------------------------------------------------------+
'- Set WORD Line                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING, i AS LONG                           '
   IF MACParseS("", "Set_Word", lText) THEN DoTrace: EXIT FUNCTION   '
   TP.WordInput = lText                                           ' Copy to normal input area
   TP.WordSave                                                    ' Save it
   TP.ErrMsgReset                                                 ' Set RC etc.
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION MacSpellChk() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- Spell check the word passed from the macro                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL RCA AS RCUser, Sugg() AS STRING, cWord, t AS STRING, i AS LONG '
   IF MACParseS("", "SPF_SpellChk$", cWord) THEN DoTrace: EXIT FUNCTION '
   SpellCheck(cWord, Sugg(), RCA)                                 ' Check the word for spelling
   SELECT CASE RCA.RC                                             ' How'd it do
      CASE 0                                                      ' OK
         FUNCTION = "": TP.ErrMsgReset                            ' Return Null and RC = 0
      CASE 2                                                      ' Error, no suggestions
         FUNCTION = "": TP.ErrMsgAdd(8, $DQ + cword + $DQ + " is spelled incorrectly, there are no suggestions")  '
      CASE 1                                                      ' Wrong, with suggestions
         TP.ErrMsgAdd(4, $DQ + cword + $DQ + " is spelled incorrectly, suggestions returned")   '
         FOR i = 0 TO UBOUND(Sugg())                              ' Add the suggestions
            t += Sugg(i) + "|"                                    ' Build suggestion string
         NEXT i                                                   '
         t = CLIP$(RIGHT, t, 1)                                   ' Remove teailing |
         FUNCTION = t                                             ' Return it
   END SELECT                                                     '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION SPF_CMD() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Issue an SPFLite Primary command                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, MSG AS STRING                                        '
LOCAL errRC AS LONG                                               '
   gMacroTHeader = "SPF_Cmd() "                                   '
   QNotEdit(gMacroTHeader)                                        ' Not Edit? Bail out
   lText = sGetStrConcat                                          ' Go get the operands
   SubstSet(lText)                                                ' Do SET substitution
   IF lText <> "" THEN                                            ' Null "" means errors
      gMacroTHeader = "SPF_Cmd(" + ltext + ") "                   ' Build trace header
      TP.pCommand = lText                                         ' Set string in pCommand
      TP.ErrMsgReset                                              ' Start off clean
      TP.lCtlProcess                                              ' Get any line commands ready
      TP.CmdAssign                                                ' Try to run it
      errRC = TP.ErrMsgHigh: MSG = TP.ErrMsgTop                   ' Copy RC and message
      TP.DispScreen                                               ' Let cursor positioing take place
      TP.ErrMsgAdd(errRC, TP.ErrMsgTop)                           ' Restore so trace has correct values
      DoTrace                                                     ' Do trace if needed
      FUNCTION = errRC                                            ' Return error flag
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION SPF_Comment() AS LONG                                    '
'-----------------------------------------------------------------------------------------------+
'- Handle comment positioning                                                                   |
'-----------------------------------------------------------------------------------------------+
LOCAL ix, i, j, k, lclCmntStart AS LONG, t, linetext, linecmnt, sCmnt, eCmnt AS STRING '
   IF MACParseI("E", "SPF_Comment", iX, 1, TP.LastLine) THEN DoTrace: EXIT FUNCTION '
   IF ISFALSE (TP.Flag AND %ClrFlag) THEN FUNCTION = 8: TP.ErrMsgAdd(8, "Comment handling requires Colorization to be ative"): EXIT FUNCTION '
   IF TP.FCB_.CmntCol = 0 THEN FUNCTION = 8: TP.ErrMsgAdd(8, "No Comment Column specified in the Profile"): EXIT FUNCTION  '
   IF ISFALSE (TP.LFlagGet(ix) AND %Data) THEN FUNCTION = 4: TP.ErrMsgAdd(4, "Selected line is not a Data line"): EXIT FUNCTION  '
   IF TP.FCB_.HexMode <> 1 THEN FUNCTION = 8: TP.ErrMsgAdd(8, "Comment handling is not available in HEX mode"): EXIT FUNCTION '

   '--------------------------------------------------------------------------------------------+
   '- See what we have to do                                                                    |
   '--------------------------------------------------------------------------------------------+
   sCmnt = TP.Cmnt_.GTxt1(TP.FCB_.CmntID)                         ' Get opening comment
   eCmnt = TP.Cmnt_.GTxt2(TP.FCB_.CmntID)                         ' Get closing comment
   t = TP.LTxtGet(ix)                                             ' Get current text in line
   TP.ModSet(ix)                                                  ' Remember we changed something
   IF ISNULL(TRIM$(t)) THEN                                       ' A blank line?
      '-----------------------------------------------------------------------------------------+
      '- Null Line                                                                              |
      '-----------------------------------------------------------------------------------------+
      t = SPACE$(TP.FCB_.CmntCol - 1) + sCmnt                     ' Build the line
      IF ISNOTNULL(eCmnt) THEN t = LSET$(t, TP.FCB_.CmntEnd - 1) + eCmnt   ' Add the closing if needed
      GOTO CmntDone                                               ' We're done
   END IF                                                         '
   '--------------------------------------------------------------------------------------------+
   '- Line with data in it                                                                      |
   '--------------------------------------------------------------------------------------------+
   lclCmntStart = TP.GetCmntStart(t)                              ' Get loc of comment on this line
   IF lclCmntStart = 0 THEN                                       ' No existing comment?
      '-----------------------------------------------------------------------------------------+
      '- No existing comment                                                                    |
      '-----------------------------------------------------------------------------------------+
      i = LEN(RTRIM$(t)) + 1                                      ' Point past end-of-text
      j = TP.FCB_.CmntCol                                         ' Point at standard location+
      IF i > j THEN DO UNTIL j > i: j += TP.FCB_.CmntIncr: LOOP   ' Shift right if needed
      t = LSET$(t, j - 1) + sCmnt                                 ' Build the line
      j = MAX(j + LEN(sCmnt) + 1, TP.FCB_.CmntEnd - 1)            ' Set next possible end comment
      IF ISNOTNULL(eCmnt) THEN t = LSET$(t, j) + eCmnt            ' Add the closing if needed
      GOTO CmntDone                                               ' We're done
   ELSE                                                           '
      '-----------------------------------------------------------------------------------------+
      '- Line has an existing comment                                                           |
      '-----------------------------------------------------------------------------------------+
      k = 0: IF ISNOTNULL(eCmnt) THEN k = INSTR(-1, t, eCmnt)     ' See if an ending comment
      linetext = RTRIM$(LEFT$(t, lclCmntStart - 1))               ' Separate text and comment
      linecmnt = RTRIM$(IIF$(k, MID$(t, lclCmntStart TO k - 1), MID$(t, lclCmntStart)))   '
      i = LEN(linetext) + 1                                       ' Point past end-of-text
      j = TP.FCB_.CmntCol                                         ' Point at standard location+
      IF i >= j THEN DO UNTIL j > i: j += TP.FCB_.CmntIncr: LOOP  ' Shift right if needed
      t = LSET$(linetext, j - 1) + linecmnt                       ' Build the line
      IF ISNOTNULL(eCmnt) THEN                                    ' Need to add eCmnt?
         t = IIF$(LEN(t) > TP.FCB_.CmntEnd, t + " " + eCmnt, LSET$(t, TP.FCB_.CmntEnd - 1) + eCmnt)   '
      END IF                                                      '
      GOTO CmntDone                                               ' We're done
   END IF                                                         '

   CmntDone:                                                      '
      TP.LTxtSet(ix, t)                                           ' Store it
      TP.AttrScan(ix)                                             ' Recolorize
END FUNCTION                                                      '

FUNCTION SPF_Debug() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Display a string                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING                                             '
   lText = sGetStrConcat                                          ' Go get the operands
   IF lText <> "" THEN                                            ' Null "" means errors
      gMacroTHeader = "SPF_Debug(" + ltext + ") "                 '
      TP.ErrMsgReset                                              '
      DEBUG lText                                                 ' Display it
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION SPF_DebugLog() AS EXT                                    '
'--------------------------------------------------------------------------------------------------+
'- Turn DEBUGLOG ON / OFF                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, TimeStamp AS STRING, i, j AS LONG, aTxt AS WSTRING POINTER '
   IF MACParseIS("", "SPF_DebugLog", i, lText) THEN DoTrace: EXIT FUNCTION '
   IF i <> 0 AND i <> 1 THEN                                      ' ON or OFF?
      TP.ErrMsgAdd(8, "First operand must be ON or OFF")          ' Set ZRC
      doTrace                                                     '
      EXIT FUNCTION                                               '
   END IF                                                         '
   TP.ErrMsgReset                                                 '
   IF i = 0 THEN                                                  ' OFF request
      IF ghDBFn = 0 THEN                                          ' Inactive?
         FUNCTION = %True: TP.ErrMsgAdd(8, "DebugLog is not active") ' Error
      ELSE                                                        '
         IF ISNOTNULL(lText) AND UCASE$(lText) = "VIEW" THEN      ' VIEW asked for
            DoCmdAdd("VIEW " + $DQ + ghDBFName + $DQ)             ' Add a Post_Do cmd
         END IF                                                   '
         DebugLog("$$QUIT")                                       ' Do the close
      END IF                                                      '

   ELSE                                                           ' ON request
      IF ghDBFn <> 0 THEN                                         ' Already active
         FUNCTION = %True: TP.ErrMsgAdd(8, "DebugLog is already active")   ' Error
      ELSE                                                        '
         TimeStamp  = MID$(DATE$, 7, 4) + "-" + MID$(DATE$, 1, 2) + "-" + MID$(DATE$, 4, 2)  '
         TimeStamp += " " + MID$(TIME$, 1, 2) + "." + MID$(TIME$, 4, 2) ' Build the Run Timestamp
         ghDBFName = genv.HomeFolder + "SPFLite DebugLog " + TimeStamp + ".TXT"  ' Setup default filename
         IF ISNOTNULL(lText) THEN                                 ' An overriding filename
            StrUnquote(lText)                                     ' Remove any quotes
            IF INSTR(lText, ANY ":\") = 0 THEN _                  ' If not already qualified
               lText = gENV.HomeData + lText                      ' Add prefix with HomeData
            ghDBFName = lText                                     ' Set it up
         END IF                                                   '
         DebugLog("Debug Log Started")                            ' Start it
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION SPF_EXEC() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Issue a DOS execute command                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING, i, j AS LONG, sync, normal AS EXT   '
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber sync                               ' Then get the SYNC/ASYNC flag
         IF thinBasic_CheckComma() THEN                           ' Better be a comma
            IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next also a number?
               thinBasic_ParseNumber normal                       ' Then get the SHOW/HIDE  flag
               IF thinBasic_CheckComma() THEN                     ' Better be a another comma
                  thinBasic_ParseString lText                     ' Then get the string
                  DO WHILE thinBasic_CheckComma(%True, %True)     ' A Comma?
                     thinBasic_ParseString tText                  ' Then get the next string
                     lText += " " + tText                         ' Add it to the string
                  LOOP                                            '
               END IF                                             '
            ELSE                                                  ' Not a SHOW/HIDE flag
               normal = 1                                         ' Set to NORMAL
               thinBasic_ParseString lText                        ' Then get the string
               DO WHILE thinBasic_CheckComma(%True, %True)        ' A Comma?
                  thinBasic_ParseString tText                     ' Then get the next string
                  lText += " " + tText                            ' Add it to the string
               LOOP                                               '
            END IF                                                '
         END IF                                                   '
      ELSE                                                        '
         sync = 0                                                 ' Default SYNC to zero  (SYNC)
         normal = 1                                               ' Default SHOW/HIDE to 1 (NORMAL)
         thinBasic_ParseString lText                              ' Then get the string
         DO WHILE thinBasic_CheckComma(%True, %True)              ' A Comma?
            thinBasic_ParseString tText                           ' Then get the next string
            lText += " " + tText                                  ' Add it to the string
         LOOP                                                     '
      END IF                                                      '
      j = normal                                                  ' Convert SHOW/HIDE to integer
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         gMacroTHeader = "SPF_Exec(" + IIF$(sync = 0, "SYNC", "ASYNC") + ", " + IIF$(j = 1, "NORMAL", "HIDDEN") + ", " + lText + ") "  '
         IF sync = 0 THEN                                         ' Normal SYNC?
            SHELL lText, j, EXIT TO i                             '
            TP.ErrMsgAdd(i, IIF$(i =0, "", ERROR$)): FUNCTION = i ' Set RC
         ELSE                                                     '
            i = SHELL(lText, j)                                   '
            TP.ErrMsgReset: FUNCTION = i                          ' Set RC
         END IF                                                   '
         DoTrace                                                  ' Do trace if needed
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION SPF_Exempt_File() AS EXT                                 '
'--------------------------------------------------------------------------------------------------+
'- See if a file extension is NONTEXT                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL xText, yText, XList, OpenWith AS STRING, i AS LONG          '
   IF MACParseS("", "SPF_Exempt_File", xText) THEN DoTrace: EXIT FUNCTION  '
   IF LEFT$(xText, 1) = "." THEN xText = CLIP$(LEFT, xText, 1)    ' Strip off any leading period.
   i = GetNonTextOption(xText, OpenWith)                          ' In the EFT list?
   IF i = 4 THEN                                                  ' No
      FUNCTION = %False: TP.ErrMsgAdd(0, "File is NOT flagged as NONTEXT") ' Return
   ELSE                                                           '
      FUNCTION = %True: TP.ErrMsgAdd(8, "File IS flagged as NONTEXT")   ' Return
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' All is well.
END FUNCTION                                                      '

FUNCTION SPF_INS() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Insert text into a line                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, ltext2 AS STRING, lclCol, i AS LONG, aTxt AS WSTRING POINTER  '
   IF MACParseIIS("E", "SPF_Ins", i, lclCol, lText) THEN DoTrace: EXIT FUNCTION  '
   gMacroTHeader = "SPF_INS(" + FORMAT$(i) + ", " + FORMAT$(lclCol) + ", " + ltext + ") " '
   TP.ErrMsgReset                                                 ' Start off as no error
   IF i > 0 AND i <= TP.LastLine THEN                             ' Within range?
      IF ISTRUE (TP.LFlagGet(i) AND %NonTypable) THEN             ' Ineligible line?
         TP.ErrMsgAdd(8, "Non-modifyable line type")              ' Set ZRC
      ELSE                                                        '
         ltext2 = TP.LTxtGet(i)                                   ' Get the original text
         IF LEN(ltext2) < lclCol - 1 THEN ltext2 = LSET$(ltext2, lclCol - 1)  ' Make minimum needed length
         ltext2 = LEFT$(ltext2, lclCol - 1) + ltext + MID$(ltext2, lclCol) '
         TP.LTxtSet(i, lText2)                                    ' Yes, set back the text
         TP.ModSet(i)                                             ' Remember we changed something
         IF TP.LFlagWord(i) THEN TP.WordSave                      '
         IF TP.LFlagMark(i) THEN TP.MarkSave                      '
         IF TP.LFlagMask(i) THEN TP.MaskSave                      '
         IF TP.LFlagBounds(i) THEN TP.BndsSave                    '
         IF TP.LFlagTabs(i) THEN TP.TabsSave                      '
         aTxt = TP.LAttrPtr(i)                                    ' Get it
         @aTxt = LSET$(@aTxt, TP.LTxtLen(i) USING CHR$$(0))       ' Make = text length
         TP.AttrScan(i)                                           ' Recolorize
      END IF                                                      '
   ELSE                                                           '
      TP.ErrMsgAdd(8, "Invalid line pointer")                     ' Set ZRC to fail
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' All is well.
END FUNCTION                                                      '

FUNCTION SPF_INVCHARS() AS STRING                                 '
'--------------------------------------------------------------------------------------------------+
'- Filter out invalid characters in string                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING, i AS LONG                           '
   IF MACParseS("", "SPF_InvChars$", lText) THEN DoTrace: EXIT FUNCTION '
   IF UCASE$(gENV.InvChar) = "N" THEN GOTO DoNothing              ' Translate suspemded?

   i = VERIFY(lText, gValidChars)                                 ' Get location of any unprintable chars
   IF i <> 0 THEN                                                 ' Someting invalid in there?
      DO WHILE i                                                  ' Make them all the chosen
         MID$(lText, i, 1) = gENV.InvChar                         ' Invalid character substitute
         i = VERIFY(i + 1, lText, gValidChars)                    ' Get location of any further unprintable chars
      LOOP                                                        ' Loop till done
   END IF                                                         '
DoNothing:                                                        '
   FUNCTION = lText                                               ' Pass back the text
   TP.ErrMsgReset                                                 ' Say all is OK
   DoTraceS(lText)                                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION SPF_LOOPCHECK() AS EXT                                   '
'--------------------------------------------------------------------------------------------------+
'- Tell SPFLite no loop checking                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL OnOff, nvalue AS LONG, i AS LONG                            '
   OnOff = IIF(gMacNoLoopTest, %False, %True)                     ' Save current state (inverted)
   IF MACParseI("", "SPF_Loop_Check", nvalue) THEN DoTrace: EXIT FUNCTION  '
   i = IIF(nvalue, %False, %True)                                 ' Make long and invert
   gMacNoLoopTest = i                                             ' Set in the new value
   FUNCTION = OnOff: TP.ErrMsgReset                               ' Return previous setting
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION SPF_OVR() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Overlay text in a line                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, ltext2 AS STRING, lclCol, i, j AS LONG, aTxt AS WSTRING POINTER  '
   IF MACParseIIS("E", "SPF_Ovr", i, lclCol, lText) THEN DoTrace: EXIT FUNCTION  '
   gMacroTHeader = "SPF_OVR(" + FORMAT$(i) + ", " + FORMAT$(lclCol) + ", " + ltext + ") " '
   TP.ErrMsgReset                                                 ' Start off as no error
   IF i > 0 AND i <= TP.LastLine THEN                             ' Within range?
      IF ISTRUE (TP.LFlagGet(i) AND %NonTypable) THEN             ' Ineligible line?
         TP.ErrMsgAdd(8, "Non-modifyable line type")              ' Set ZRC
      ELSE                                                        '
         ltext2 = TP.LTxtGet(i)                                   ' Get the original text
         IF LEN(ltext2) < lclCol + LEN(ltext) - 1 THEN ltext2 = LSET$(ltext2, lclCol + LEN(ltext) - 1)   ' Make minimum needed length
         FOR j = lclCol TO lclCol + LEN(ltext) - 1                ' Loop doing the overlay
            IF MID$(ltext2, j, 1) = " " THEN _                    ' If blank in original text
               MID$(ltext2, j, 1) = MID$(ltext, j - lclCol + 1, 1)   ' Copy character from overlay text
         NEXT j                                                   '
         TP.LTxtSet(i, lText2)                                    ' Yes, set back the text
         TP.ModSet(i)                                             ' Remember we changed something
         IF TP.LFlagWord(i) THEN TP.WordSave                      '
         IF TP.LFlagMark(i) THEN TP.MarkSave                      '
         IF TP.LFlagMask(i) THEN TP.MaskSave                      '
         IF TP.LFlagBounds(i) THEN TP.BndsSave                    '
         IF TP.LFlagTabs(i) THEN TP.TabsSave                      '
         aTxt = TP.LAttrPtr(i)                                    ' Get it
         @aTxt = LSET$(@aTxt, TP.LTxtLen(i) USING CHR$$(0))       ' Make = text length
         TP.AttrScan(i)                                           ' Recolorize
      END IF                                                      '
   ELSE                                                           '
      TP.ErrMsgAdd(8, "Invalid line pointer")                     ' Set ZRC to fail
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' All is well.
END FUNCTION                                                      '

FUNCTION SPF_OVR_REP() AS EXT                                     '
'--------------------------------------------------------------------------------------------------+
'- Force Overlay text in a line                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, ltext2 AS STRING, lclCol, i, j AS LONG, aTxt AS WSTRING POINTER  '
   IF MACParseIIS("E", "SPF_Ovr_Rep", i, lclCol, lText) THEN DoTrace: EXIT FUNCTION '
   gMacroTHeader = "SPF_Ovr_Rep(" + FORMAT$(i) + ", " + FORMAT$(lclCol) + ", " + ltext + ") "   '
   TP.ErrMsgReset                                                 ' Start off as no error
   IF i > 0 AND i <= TP.LastLine THEN                             ' Within range?
      IF ISTRUE (TP.LFlagGet(i) AND %NonTypable) THEN             ' Ineligible line?
         TP.ErrMsgAdd(8, "Non-modifyable line type")              ' Set ZRC
      ELSE                                                        '
         ltext2 = TP.LTxtGet(i)                                   ' Get the original text
         IF LEN(ltext2) < lclCol + LEN(ltext) - 1 THEN ltext2 = LSET$(ltext2, lclCol + LEN(ltext) - 1)   ' Make minimum needed length
         FOR j = lclCol TO lclCol + LEN(ltext) - 1                ' Loop doing the overlay
            IF MID$(ltext, j - lclCol + 1, 1) <> " " THEN _       ' If non-blank in overlay
               MID$(ltext2, j, 1) = MID$(ltext, j - lclCol + 1, 1)   ' Copy character from overlay text
         NEXT j                                                   '
         TP.LTxtSet(i, lText2)                                    ' Yes, set back the text
         TP.ModSet(i)                                             ' Remember we changed something
         IF TP.LFlagWord(i) THEN TP.WordSave                      '
         IF TP.LFlagMark(i) THEN TP.MarkSave                      '
         IF TP.LFlagMask(i) THEN TP.MaskSave                      '
         IF TP.LFlagBounds(i) THEN TP.BndsSave                    '
         IF TP.LFlagTabs(i) THEN TP.TabsSave                      '
         aTxt = TP.LAttrPtr(i)                                    ' Get it
         @aTxt = LSET$(@aTxt, TP.LTxtLen(i) USING CHR$$(0))       ' Make = text length
         TP.AttrScan(i)                                           ' Recolorize
      END IF                                                      '
   ELSE                                                           '
      TP.ErrMsgAdd(8, "Invalid line pointer")                     ' Set ZRC to fail
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' All is well.
END FUNCTION                                                      '

FUNCTION SPF_PARSE() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Parse the Get_Arg$ array                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL num AS EXT                                                  '
LOCAL maxlit, maxnum, maxlptr, maxtag, tv AS LONG                 '
LOCAL KWCtl, KWCtl2, KWGroup, KWEntry, OrigKWCtl, KWMastName, t, aliasname, KWUse AS STRING  '
LOCAL wvarname, wvarvalue AS WSTRING                              '
LOCAL vvarvalue AS VARIANT                                        '
LOCAL i, j, k, parsedone, brkted AS LONG                          '
   gParseTbl.Clear                                                ' Clear the Parse table
   RESET gMacGotlit, gMacGotnum, gMacGotlptr, gMacGottag          '

   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      thinBasic_ParseNumber num                                   ' Then get the maxlit value
      maxlit = num                                                '
      IF thinBasic_CheckComma() THEN                              ' A Comma?
         thinBasic_ParseNumber num                                ' Then get the maxnum value
         maxnum = num                                             '
         IF thinBasic_CheckComma() THEN                           ' A Comma?
            thinBasic_ParseNumber num                             ' Then get the maxlptr value
            maxlptr = num                                         '
            IF thinBasic_CheckComma() THEN                        ' A Comma?
               thinBasic_ParseNumber num                          ' Then get the maxtag value
               maxtag = num                                       '
               gMacroTHeader = "SPF_Parse(" + FORMAT$(maxlit) + ", " + FORMAT$(maxnum) + ", " + FORMAT$(maxlptr) + ", " + FORMAT$(maxtag) '
               DO WHILE thinBasic_CheckComma(%True, %True)        ' A Comma?
                  thinBasic_ParseString KWCtl                     ' Then get the KWCtl string
                  gMacroTHeader += ", " + KWCtl                   ' Add to trace string
                  GOSUB DoKWCtl                                   ' Go process it
               LOOP                                               '
               IF thinBasic_CheckCloseParens THEN                 ' And if closed by ) properly
                  gMacroTHeader += ")"                            ' Add to trace string
                  parsedone = %True                               ' Remember we've reached the )
               END IF                                             '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle old style -ve operands, convert to new flag oriented style                            |
   '-----------------------------------------------------------------------------------------------+
   IF maxlit  < 0 THEN maxlit  = (ABS(maxlit) OR %ARGM_VAR)       ' Do each one
   IF (maxlit AND (%ARGM_VAR + %ARGM_OPT)) = (%ARGM_VAR + %ARGM_OPT) THEN TP.ErrMsgAdd(8, "Cannot use both ARG_VAR and ARG_OPT"): GOSUB ErrorExit  '
   IF maxnum  < 0 THEN maxnum  = (ABS(maxnum) OR %ARGM_VAR)       '
   IF (maxnum AND (%ARGM_VAR + %ARGM_OPT)) = (%ARGM_VAR + %ARGM_OPT) THEN TP.ErrMsgAdd(8, "Cannot use both ARG_VAR and ARG_OPT"): GOSUB ErrorExit  '
   IF maxlptr < 0 THEN maxlptr = (ABS(maxlptr) OR %ARGM_VAR)      '
   IF (maxlptr AND (%ARGM_VAR + %ARGM_OPT)) = (%ARGM_VAR + %ARGM_OPT) THEN TP.ErrMsgAdd(8, "Cannot use both ARG_VAR and ARG_OPT"): GOSUB ErrorExit '
   IF maxtag  < 0 THEN maxtag  = (ABS(maxtag)  OR %ARGM_VAR)      '
   IF (maxtag AND (%ARGM_VAR + %ARGM_OPT)) = (%ARGM_VAR + %ARGM_OPT) THEN TP.ErrMsgAdd(8, "Cannot use both ARG_VAR and ARG_OPT"): GOSUB ErrorExit  '

   '-----------------------------------------------------------------------------------------------+
   '- Parse parameters have been done, now process the Arg$ array                                  |
   '-----------------------------------------------------------------------------------------------+
   FOR j = 1 TO 50                                                ' OK, now process the arguments
      IF ISNOTNULL(gMacOprands(j)) THEN                           ' Only do non-null operands

         '-----------------------------------------------------------------------------------------+
         '- First see if it's a Keyword                                                            |
         '-----------------------------------------------------------------------------------------+
         wvarname = UUCASE(gMacOprands(j))                        ' Convert to WSTRING, always uppercase the name
         KWUse = UUCASE(gMacOprands(j))                           ' Save as name to use
         vvarvalue = gParseTbl.Item(wvarname)                     ' Try the retrieval
         k = OBJRESULT                                            ' look at answer
         IF k = 0 THEN                                            ' Found, validate it
            KWMastName = VARIANT$(vvarvalue)                      ' Make normal string
            IF LEFT$(KWMastName, 1) = "9" THEN                    ' An Alias entry?
               wvarname = UUCASE(MID$(KWMastName, 2))             ' Swap names
               KWUse = UUCASE(MID$(KWMastName, 2))                ' Save this as the name to use
               vvarvalue = gParseTbl.Item(wvarname)               ' Try the retrieval
               k = OBJRESULT                                      ' look at answer
               IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl Structure error"): GOSUB ErrorExit ' Bail out, shold never happen
               KWMastName = VARIANT$(vvarvalue)                   ' Make normal string
            END IF                                                '
            KWMastName = MID$(KWMastName, 2)                      ' Extract the master name
            wvarname = KWMastName                                 ' Lets see if MasterName has a set value
            vvarvalue = gParseTbl.Item(wvarname)                  ' Try the retrieval
            k = OBJRESULT                                         ' look at answer
            IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl Structure error"): GOSUB ErrorExit ' Bail out, should never happen
            t = VARIANT$(vvarvalue)                               ' Make a string
            IF ISNULL(t) THEN                                     ' If still null, goodness, no collision
               wvarvalue = UUCASE(gMacOprands(j) + "|" + KWUse)   ' Set it to the original Operand followed by main name
               gParseTbl.Replace(wvarname, wvarvalue)             '
               k = OBJRESULT                                      ' look at answer
               IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl REPLACE error"): GOSUB ErrorExit   ' Bail out
               wvarvalue = "1" + UUCASE(KWMastName)               ' Set the KW Entry to True
               wvarname = UUCASE(KWUse)                           '
               gParseTbl.Replace(wvarname, wvarvalue)             '
               k = OBJRESULT                                      ' look at answer
               IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl REPLACE error"): GOSUB ErrorExit   ' Bail out
            ELSE                                                  '
               IF IsEQ(gMacOprands(j), PARSE$(t, "|", 1)) THEN    ' Simple duplicate
                  TP.ErrMsgAdd(8, "Keyword: " + UUCASE(gMacOprands(j)) + " has been entered twice")   '
               ELSE                                               '
                  TP.ErrMsgAdd(8, "Keyword: " + UUCASE(gMacOprands(j)) + " cannot be entered along with: " + UUCASE(PARSE$(t, "|", 1)))   '
               END IF                                             '
               GOSUB ErrorExit                                    ' Bail out
            END IF                                                '

         ELSE                                                     ' Not a KW
            IF LEFT$(gMacOprands(j), 1) = "." THEN                ' Is this a dotted label?
               IF gMacGotlptr = (maxlptr AND &H000000FF) THEN TP.ErrMsgAdd(8, gMacOprands(j) + " exceeds the maximum allowed Line References"): GOSUB ErrorExit   ' At the maximum
               GOSUB vLRef                                        ' Go Validate it
               INCR gMacGotlptr                                   ' Count it
               wvarvalue = gMacOprands(j)                         ' Make it Wide
               wvarname = "." + FORMAT$(gMacGotlptr)              ' Build the key
               gParseTbl.Add(wvarname, wvarvalue)                 ' Try to Add the .n entry
               k = OBJRESULT                                      ' look at answer
               IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out

            ELSEIF LEFT$(gMacOprands(j), 1) = ":" THEN            ' Is this a Tag??
               IF gMacGottag = (maxtag AND &H000000FF) THEN TP.ErrMsgAdd(8, gMacOprands(j) + " exceeds the maximum allowed Tag References"): GOSUB ErrorExit   ' At the maximum
               GOSUB vTag                                         ' Go Validate it
               INCR gMacGottag                                    ' Count it
               wvarvalue = gMacOprands(j)                         ' Make it Wide
               wvarname = ":" + FORMAT$(gMacGottag)               ' Build the key
               gParseTbl.Add(wvarname, wvarvalue)                 ' Try to Add the .n entry
               k = OBJRESULT                                      ' look at answer
               IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out

            ELSEIF VERIFY(gMacOprands(j), "0123456789") = 0 THEN  ' Is this a numeric literal
               IF gMacGotnum = (maxnum AND &H000000FF) THEN TP.ErrMsgAdd(8, gMacOprands(j) + " exceeds the maximum allowed numeric literals"): GOSUB ErrorExit ' At the maximum
               INCR gMacGotnum                                    ' Count it
               wvarvalue = gMacOprands(j)                         ' Make it Wide
               wvarname = "#" + FORMAT$(gMacGotnum)               ' Build the key
               gParseTbl.Add(wvarname, wvarvalue)                 ' Try to Add the .n entry
               k = OBJRESULT                                      ' look at answer
               IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out

            ELSE                                                  ' This is a string
               IF gMacGotlit = (maxlit AND &H000000FF) THEN TP.ErrMsgAdd(8, gMacOprands(j) + " exceeds the maximum allowed text literals"): GOSUB ErrorExit ' At the maximum
               INCR gMacGotlit                                    ' Count it
               wvarvalue = gMacOprands(j)                         ' Make it Wide
               wvarname = "$" + FORMAT$(gMacGotlit)               ' Build the key
               gParseTbl.Add(wvarname, wvarvalue)                 ' Try to Add the .n entry
               k = OBJRESULT                                      ' look at answer
               IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out

            END IF                                                '
         END IF                                                   '
      END IF                                                      '
   NEXT j                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Test for overall limit requirements                                                          |
   '-----------------------------------------------------------------------------------------------+
   tv = maxlit AND &H000000FF                                     ' Get value without flag bits
   IF tv > 0 THEN                                                 ' Something is wanted
      IF (maxlit AND %ARGM_VAR) THEN                              ' If VAR specified, anything is fine
         '-                                                       '
      ELSEIF (maxlit AND %ARGM_OPT) THEN                          ' If OPT specified, must be equal or zero
         IF gMacGotlit <> tv AND gMacGotlit <> 0 THEN             '
            TP.ErrMsgAdd(8, "Command requires 0 or " + FORMAT$(tv) + " TEXT literals, " + FORMAT$(gMacGotlit) + IIF$(gMacGotlit = 1, " was ", " were ") + "entered"): GOSUB ErrorExit  '
         END IF                                                   '
      ELSE                                                        ' Else must be equal
         IF gMacGotlit <> tv THEN                                 '
             TP.ErrMsgAdd(8, "Command requires " + FORMAT$(tv) + " TEXT literals, " + FORMAT$(gMacGotlit) + IIF$(gMacGotlit = 1, " was ", " were ") + "entered"): GOSUB ErrorExit   '
          END IF                                                  '
       END IF                                                     '
   END IF                                                         '

   tv = maxnum AND &H000000FF                                     ' Get value without flag bits
   IF tv > 0 THEN                                                 ' Something is wanted
      IF (maxnum AND %ARGM_VAR) THEN                              ' If VAR specified, anything is fine
         '-                                                       '
      ELSEIF (maxnum AND %ARGM_OPT) THEN                          ' If OPT specified, must be equal or zero
         IF gMacGotnum <> tv AND gMacGotnum <> 0 THEN             '
            TP.ErrMsgAdd(8, "Command requires 0 or " + FORMAT$(tv) + " Numeric literals, " +  FORMAT$(gMacGotnum) + IIF$(gMacGotnum = 1, " was ", " were ") + "entered"): GOSUB ErrorExit '
         END IF                                                   '
      ELSE                                                        '
         IF gMacGotnum <> tv THEN                                 '
            TP.ErrMsgAdd(8, "Command requires " + FORMAT$(tv) + " Numeric literals, " +  FORMAT$(gMacGotnum) + IIF$(gMacGotnum = 1, " was ", " were ") + "entered"): GOSUB ErrorExit   '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   tv = maxtag AND &H000000FF                                     ' Get value without flag bits
   IF tv > 0 THEN                                                 ' Something is wanted
      IF (maxtag AND %ARGM_VAR) THEN                              ' If VAR specified, anything is fine
         '-                                                       '
      ELSEIF (maxtag AND %ARGM_OPT) THEN                          ' If OPT specified, must be equal or zero
         IF gMacGottag <> tv AND gMacGottag <> 0 THEN             '
            TP.ErrMsgAdd(8, "Command requires 0 or " + FORMAT$(tv) + " Tag operands, " +  FORMAT$(gMacGottag) + IIF$(gMacGottag = 1, " was ", " were ") + "entered"): GOSUB ErrorExit  '
         END IF                                                   '
      ELSE                                                        '
         IF gMacGottag <> tv THEN                                 '
            TP.ErrMsgAdd(8, "Command requires " + FORMAT$(tv) + " Tag operands, " +  FORMAT$(gMacGottag) + IIF$(gMacGottag = 1, " was ", " were ") + "entered"): GOSUB ErrorExit '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   tv = maxlptr AND &H000000FF                                    ' Get value without flag bits
   IF tv > 0 THEN                                                 ' Something is wanted
      IF (maxlptr AND %ARGM_VAR) THEN                             ' If VAR specified, anything is fine
         '-                                                       '
      ELSEIF (maxlptr AND %ARGM_OPT) THEN                         ' If OPT specified, must be equal or zero
         IF gMacGotlptr <> tv AND gMacGotlptr <> 0 THEN           '
            TP.ErrMsgAdd(8, "Command requires 0 or " + FORMAT$(tv) + " Line References, " +  FORMAT$(gMacGotlptr) + IIF$(gMacGotlptr = 1, " was ", " were ") + "entered"): GOSUB ErrorExit   '
         END IF                                                   '
      ELSE                                                        '
         IF gMacGotlptr <> tv THEN                                '
            TP.ErrMsgAdd(8, "Command requires " + FORMAT$(tv) + " Line References, " +  FORMAT$(gMacGotlptr) + IIF$(gMacGotlptr = 1, " was ", " were ") + "entered"): GOSUB ErrorExit  '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   FUNCTION = 0: TP.ErrMsgReset                                   ' Set return
   DoTrace                                                        ' Do Trace if needed
   EXIT FUNCTION                                                  '

'--------------------------------------------------------------------------------------------------+
'- Process one KWCtl string                                                                        |
'--------------------------------------------------------------------------------------------------+
DoKWCtl:                                                          '
   origKWCtl = KWCtl: KWGroup = ""                                ' Save original, reset the groupname

   '-----------------------------------------------------------------------------------------------+
   '- Process the Groupname if present                                                             |
   '-----------------------------------------------------------------------------------------------+
   i = INSTR(KWCtl, ":")                                          ' Is a groupname present?
   IF i THEN                                                      '
      IF i = 1 THEN                                               ' Oops?
         TP.ErrMsgAdd(8, "Invalid/Missing Groupname for a Keyword list")   ' Set error text
         GOSUB ErrorExit                                          ' Bail out
      END IF                                                      '
      KWGroup = LEFT$(KWCtl, i - 1)                               ' Extract it
      KWCtl = MID$(KWCtl, i + 1)                                  ' Strip from KWCtl
      IF ISNULL(KWCtl) THEN                                       '
         TP.ErrMsgAdd(8, "No keywords in the keyword list - " + origKWCtl) '
         GOSUB ErrorExit                                          ' Bail out
      END IF                                                      '
      GOSUB AddGroup                                              ' Add the parse Group entry
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Process the keywords now                                                                     |
   '-----------------------------------------------------------------------------------------------+
   KWCtl += ","                                                   ' Force trailing ,
   DO WHILE KWCtl <> ""                                           ' Do while still some data left
      i = INSTR(KWCtl, ",")                                       ' Get comma location
      j = INSTR(KWCtl, "(")                                       ' Get any ( location
      IF j <> 0 AND j < i THEN                                    ' Bracketed operand?
         i = INSTR(KWCtl, ")")                                    ' Better have a trailing )
         IF i = 0 THEN                                            ' Oops
            TP.ErrMsgAdd(8, "Unmatched parenthesis in keyword entry - " + origKWCtl)   '
            GOSUB ErrorExit                                       ' Bail out
         END IF                                                   '
         i = INSTR(i, KWCtl, ",")                                 ' position at , following )
      END IF                                                      ' i now marks , following next operand
      KWEntry = LEFT$(KWCtl, i - 1)                               ' Extract one entry
      KWCtl = MID$(KWCtl, i + 1)                                  ' Shorten KWCtl
      IF ISNOTNULL(KWEntry) THEN                                  ' If we got something
         GOSUB DoKWEntry                                          ' Go process it
      END IF                                                      '
   LOOP                                                           '
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Add Group entry                                                                                 |
'--------------------------------------------------------------------------------------------------+
AddGroup:                                                         '
   wvarname = UUCASE("$$" + KWGroup)                              ' Convert to WSTRING, always uppercase the name
   vvarvalue = gParseTbl.Item(wvarname)                           ' Try the retrieval
   k = OBJRESULT                                                  ' look at answer
   IF k = 0 THEN                                                  ' Groupname already in use?
      TP.ErrMsgAdd(8,"KW Definition Groupname (" + KWGroup + ") has been used more than once")  ' Oops, shouldn't already exist
      GOSUB ErrorExit                                             ' Kill it
   END IF                                                         '
   wvarvalue = ""                                                 ' Initialize as null
   gParseTbl.Add(wvarname, wvarvalue)                             ' Try to Add the $$Grpname entry
   k = OBJRESULT                                                  ' look at answer
   IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Process one Keyword entry                                                                       |
'--------------------------------------------------------------------------------------------------+
DoKWEntry:                                                        '
   brkted = %False                                                ' Reset flag
   IF LEFT$(KWEntry, 1) = "(" THEN                                ' Bracketed type?
      brkted = %true                                              ' Remember brackets
      KWEntry = MID$(KWEntry, 2, LEN(KWEntry) - 2)                ' Remove them
   END IF                                                         '
   IF ISNULL(KWGroup) THEN                                        ' Any Group entry yet?
      k = INSTR(KWEntry, ",")                                     ' Any comma?
      KWGroup = IIF$(k, LEFT$(KWEntry, k - 1), KWEntry)           ' Use 1st KW as the Groupname
      GOSUB AddGroup                                              ' Add the parse Group entry
   END IF                                                         '
   IF ISFALSE(brkted) THEN                                        ' Normal, non-aliased KW?
      wvarname = UUCASE(KWEntry)                                  ' Convert to WSTRING, always uppercase the name
      vvarvalue = gParseTbl.Item(wvarname)                        ' Try the retrieval
      k = OBJRESULT                                               ' look at answer
      IF k = 0 THEN                                               ' Groupname already in use?
         TP.ErrMsgAdd(8, "Keyword Definition (" + KWEntry + ") has been used more than once")   ' Oops, shouldn't already exist
         GOSUB ErrorExit                                          ' Kill it
      END IF                                                      '
      wvarvalue = "0$$" + KWGroup                                 ' Initialize as 0 + the $$grpname
      gParseTbl.Add(wvarname, wvarvalue)                          ' Try to Add the keyword entry
      k = OBJRESULT                                               ' look at answer
      IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out
   ELSE                                                           ' Bracketed
      KWEntry += ","                                              ' Ensure trailing comma
      DO WHILE KWEntry <> ""                                      ' Do each operand
         k = INSTR(KWEntry, ",")                                  ' Find next comma
         wvarname = UUCASE(LEFT$(KWEntry, k - 1))                 ' Convert to WSTRING, always uppercase the name
         KWEntry = MID$(KWEntry, k + 1)                           ' Reduce string
         vvarvalue = gParseTbl.Item(wvarname)                     ' Try the retrieval
         k = OBJRESULT                                            ' look at answer
         IF k = 0 THEN                                            ' Groupname already in use?
            TP.ErrMsgAdd(8, "Keyword Definition (" + wvarname + ") has been used more than once")  'Oops, shouldn't already exist
            GOSUB ErrorExit                                       ' Kill it
         END IF                                                   '
         IF brkted THEN                                           ' Use brkted as a one time switch
            brkted = %False                                       '
            wvarvalue = "0$$" + KWGroup                           ' Build an entry
            gParseTbl.Add(wvarname, wvarvalue)                    ' Try to Add the keyword entry
            aliasname = wvarname                                  ' Save the alias name
            k = OBJRESULT                                         ' look at answer
            IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out
         ELSE                                                     ' Non-first entry
            wvarvalue = "9" + UUCASE(aliasname)                   ' Build an alias entry
            gParseTbl.Add(wvarname, wvarvalue)                    ' Try to Add the keyword entry
            k = OBJRESULT                                         ' look at answer
            IF k > 0 THEN TP.ErrMsgAdd(8, "ParseTbl ADD error"): GOSUB ErrorExit ' Bail out
         END IF                                                   '
      LOOP                                                        '
   END IF                                                         '
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Validate a Line Reference                                                                       |
'--------------------------------------------------------------------------------------------------+
vLRef:                                                            '
   k = VERIFY(2, gMacOprands(j), "<>=\" + CHR$(172))              ' Find 1st Label/Tagname character
   IF k = 2 THEN                                                  ' No condition
      t = gMacOprands(j)                                          ' Take whole operand
   ELSE                                                           '
      t = "." + MID$(gMacOprands(j), k)                           ' Else make one without the condition
   END IF                                                         '
   IF (maxlptr AND %ARGM_DEF) <> 0 THEN                           ' If ARG_DEF, then it must exist
       IF TP.LineNoRef(t) = -1 THEN                               ' If invalid
          TP.ErrMsgAdd(8, "Line Reference: " + gMacOprands(j) + " is invalid")   '
          GOSUB ErrorExit                                         '
       END IF                                                     '
   END IF                                                         '
   RETURN                                                         '

vTag:                                                             '
   k = VERIFY(2, gMacOprands(j), "<>=\" + CHR$(172))              ' Find 1st Label/Tagname character
   IF k = 2 THEN                                                  ' No condition
      t = gMacOprands(j)                                          ' Take whole operand
   ELSE                                                           '
      t = "." + MID$(gMacOprands(j), k)                           ' Else make one without the condition
   END IF                                                         '
   IF (maxtag AND %ARGM_DEF) <> 0 THEN                            ' If ARG_DEF, make sure it's valid
       IF TagValidate(t, %True) THEN                              ' If invalid
          TP.ErrMsgAdd(8, "Tag Operand: " + gMacOprands(j) + " is invalid")   '
          GOSUB ErrorExit                                         '
       END IF                                                     '
   END IF                                                         '
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Kill the function and return                                                                    |
'--------------------------------------------------------------------------------------------------+
ErrorExit:                                                        '
   TP.ErrMsgHigh = 8: FUNCTION = 8                                ' Set error level
   IF ISFALSE parsedone THEN                                      ' Have we reached the ) ?
      DO                                                          ' Spin to closing )
         thinBasic_GetToken                                       '
         IF thinBasic_CheckCloseParens(%True, %False) THEN EXIT DO   '
      LOOP                                                        '
   END IF                                                         '
   DoTrace                                                        ' Do Trace if needed
   EXIT FUNCTION                                                  '
   RETURN                                                         '

END FUNCTION                                                      '

FUNCTION SPF_QUOTE() AS STRING                                    '
'--------------------------------------------------------------------------------------------------+
'- Wrap quotes around a string                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, lText2 AS STRING, q1, q2, q3 AS LONG                 '
   IF MACParseS("", "SPF_Quote$", lText) THEN DoTrace: EXIT FUNCTION '
   '-----------------------------------------------------------------------------------------------+
   '- See if existing string is quoted                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF INSTR($DQ + "'`", LEFT$(lText, 1)) <> 0 AND _               ' IF a leading " ' OR `
      LEFT$(lText, 1) = RIGHT$(lText, 1)  AND _                   ' and trailing = leading
      INSTR(MID$(lText, 2, LEN(lText) - 2), LEFT$(lText, 1)) = 0 THEN   '
      FUNCTION = lText: TP.ErrMsgReset                            ' Return string unchanged
      DoTraceS(lText)                                             '
   ELSE                                                           '
      q1 = TALLY(lText, $DQ)                                      ' Count types of quotes
      q2 = TALLY(lText, "'")                                      '
      q3 = TALLY(lText, "`")                                      '
      IF q1 AND q2 AND q3 THEN                                    ' No available quote?
         FUNCTION = lText: TP.ErrMsgAdd(8, "String uses all three quotes") ' Return string unchanged
         DoTraceS(lText)                                          '
      ELSE                                                        '
         IF q1 = 0 THEN                                           ' " available?
            lText2 = WRAP$(lText, $DQ, $DQ)                       ' Use it
         ELSEIF q2 = 0 THEN                                       ' ' available?
            lText2 = WRAP$(lText, "'", "'")                       ' Use it
         ELSE                                                     ' ` must be available
            lText2 = WRAP$(lText, "'", "'")                       ' Use it
         END IF                                                   '
         FUNCTION = lText2: TP.ErrMsgReset                        ' Return the quoted operand
         DoTraceS(lText2)                                         '
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION SPF_POST_DO() AS LONG                                    '
'--------------------------------------------------------------------------------------------------+
'- Add a Post macro DO string                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL lText AS STRING, i AS LONG                                  '
LOCAL DMsg AS KBMsg                                               '
   gMacroTHeader = "SPF_Post_Do() "                               '
   lText = sGetStrConcat                                          ' Go get the operands
   IF lText <> "" THEN                                            ' Null "" means errors
      gMacroTHeader = "SPF_Post_Do(" + ltext + ") "               ' Build trace header
      DOCmdAdd(lText)                                             ' Stack the DO string
      MID$(DMsg.kbString, 1, 4) = CHR$(5, 0, 0, 0)                ' Flag as Message type 5 - DO execute
      i = PostMessage(ghWnd, %WM_USER, DMsg.MsgwParam, 0)         ' To the mainline Callback routine
      TPDoSet(%MarkKillSkip)                                      ' Prevent Enter from clearing marks.
      TP.ErrMsgReset                                              ' Return OK
      DoTrace                                                     ' Do trace if needed
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION SPF_REP() AS EXT                                         '
'--------------------------------------------------------------------------------------------------+
'- Replace text in a line                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, ltext2 AS STRING, lclCol, i AS LONG, aTxt AS WSTRING POINTER  '
   IF MACParseIIS("E", "SPF_Rep", i, lclCol, lText) THEN DoTrace: EXIT FUNCTION  '
   gMacroTHeader = "SPF_REP(" + FORMAT$(i) + ", " + FORMAT$(lclCol) + ", " + ltext + ") " '
   TP.ErrMsgReset                                                 ' Start off as no error
   IF i > 0 AND i <= TP.LastLine THEN                             ' Within range?
      IF ISTRUE (TP.LFlagGet(i) AND %NonTypable) THEN             ' Ineligible line?
         TP.ErrMsgAdd(8, "Non-modifyable line type")              ' Set ZRC
      ELSE                                                        '
         ltext2 = TP.LTxtGet(i)                                   ' Get the original text
         IF LEN(ltext2) < lclCol + LEN(ltext) - 1 THEN ltext2 = LSET$(ltext2, lclCol + LEN(ltext) - 1)   ' Make minimum needed length
         MID$(ltext2, lclCol, LEN(ltext)) = ltext                 '
         TP.LTxtSet(i, lText2)                                    ' Yes, set back the text
         TP.ModSet(i)                                             ' Remember we changed something
         IF TP.LFlagWord(i) THEN TP.WordSave                      '
         IF TP.LFlagMark(i) THEN TP.MarkSave                      '
         IF TP.LFlagMask(i) THEN TP.MaskSave                      '
         IF TP.LFlagBounds(i) THEN TP.BndsSave                    '
         IF TP.LFlagTabs(i) THEN TP.TabsSave                      '
         aTxt = TP.LAttrPtr(i)                                    ' Get it
         @aTxt = LSET$(@aTxt, TP.LTxtLen(i) USING CHR$$(0))       ' Make = text length
         TP.AttrScan(i)                                           ' Recolorize
      END IF                                                      '
   ELSE                                                           '
      TP.ErrMsgAdd(8, "Invalid line pointer")                     ' Set ZRC to fail
   END IF                                                         '
   DoTrace                                                        ' Do trace if needed
   FUNCTION = TP.ErrMsgHigh                                       ' All is well.
END FUNCTION                                                      '

FUNCTION SPF_SHELL() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Issue a DOS command                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING, i, j AS LONG, sync, normal AS EXT   '
   IF thinBasic_CheckOpenParens() THEN                            ' An Open (
      IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next param a number?
         thinBasic_ParseNumber sync                               ' Then get the SYNC/ASYNC flag
         IF thinBasic_CheckComma() THEN                           ' Better be a comma
            IF thinBasic_DetermineType = %thinBasic_ReturnNumber THEN   ' Is next also a number?
               thinBasic_ParseNumber normal                       ' Then get the SHOW/HIDE  flag
               IF thinBasic_CheckComma() THEN                     ' Better be a another comma
                  thinBasic_ParseString lText                     ' Then get the string
                  DO WHILE thinBasic_CheckComma(%True, %True)     ' A Comma?
                     thinBasic_ParseString tText                  ' Then get the next string
                     lText += " " + tText                         ' Add it to the string
                  LOOP                                            '
               END IF                                             '
            ELSE                                                  ' Not a SHOW/HIDE flag
               normal = 1                                         ' Set to NORMAL
               thinBasic_ParseString lText                        ' Then get the string
               DO WHILE thinBasic_CheckComma(%True, %True)        ' A Comma?
                  thinBasic_ParseString tText                     ' Then get the next string
                  lText += " " + tText                            ' Add it to the string
               LOOP                                               '
            END IF                                                '
         END IF                                                   '
      ELSE                                                        '
         sync = 0                                                 ' Default SYNC to zero  (SYNC)
         normal = 1                                               ' Default SHOW/HIDE to 1 (NORMAL)
         thinBasic_ParseString lText                              ' Then get the string
         DO WHILE thinBasic_CheckComma(%True, %True)              ' A Comma?
            thinBasic_ParseString tText                           ' Then get the next string
            lText += " " + tText                                  ' Add it to the string
         LOOP                                                     '
      END IF                                                      '
      j = normal                                                  ' Convert SHOW/HIDE to integer
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         gMacroTHeader = "SPF_Shell(" + IIF$(sync = 0, "SYNC", "ASYNC") + ", " + IIF$(j = 1, "NORMAL", "HIDDEN") + ", " + lText + ") " '
         IF sync = 0 THEN                                         ' Normal SYNC?
            SHELL ENVIRON$("COMSPEC") + " /D /C" + lText, j, EXIT TO i  '
            TP.ErrMsgAdd(i, ""): FUNCTION = i                     ' Set RC
         ELSE                                                     '
            i = SHELL(ENVIRON$("COMSPEC") + " /D /K" + lText, j)  '
            TP.ErrMsgReset: FUNCTION = i                          ' Set RC
         END IF                                                   '
         DoTrace                                                  ' Do trace if needed
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION SPF_Trace() AS EXT                                       '
'--------------------------------------------------------------------------------------------------+
'- Set Trace mode                                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
   IF MACParseI("", "SPF_Trace", lno, 0, 2) THEN DoTrace: EXIT FUNCTION '
   gMacroTrace = lno                                              ' Save the value
   FUNCTION = 0: TP.ErrMsgReset                                   '
   DoTrace                                                        ' Do trace if needed
END FUNCTION                                                      '

FUNCTION Testit() AS EXT                                          '
'--------------------------------------------------------------------------------------------------+
'- Set Trace mode                                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL lno AS LONG                                                 '
'   gStrVar.Testit()
   FUNCTION = 0: TP.ErrMsgReset                                   '
END FUNCTION                                                      '

FUNCTION SPF_UNQUOTE() AS STRING                                  '
'--------------------------------------------------------------------------------------------------+
'- UnWrap quotes from a string                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, t AS STRING                                          '
   IF MACParseS("", "SPF_UnQuote$", lText) THEN DoTrace: EXIT FUNCTION  '

   '-----------------------------------------------------------------------------------------------+
   '- See if existing string is quoted                                                             |
   '-----------------------------------------------------------------------------------------------+
   TP.ErrMsgReset                                                 ' Set RC = 0
   IF INSTR($DQ + "'`", LEFT$(lText, 1)) <> 0 AND _               ' IF a leading " ' OR `
      LEFT$(lText, 1) = RIGHT$(lText, 1) THEN                     ' and trailing = leading
      t = MID$(lText, 2, LEN(LText) - 2)                          ' Return string stripped
      FUNCTION = t                                                '
   ELSE                                                           '
      FUNCTION = lText: t = lText                                 ' Return the quoted operand
   END IF                                                         '
   DoTraceS(t)                                                    ' Do trace if needed
END FUNCTION                                                      '

FUNCTION sGetStrConcat() AS STRING                                '
'--------------------------------------------------------------------------------------------------+
'- Get and concatenate the remaining operands as a string                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lText, tText AS STRING                                      '
   FUNCTION = ""                                                  ' Default a failing answer
   IF thinBasic_CheckOpenParens() THEN                            ' A Open (
      thinBasic_ParseString lText                                 ' Then get the string
      DO WHILE thinBasic_CheckComma(%True, %True)                 ' A Comma?
         thinBasic_ParseString tText                              ' Then get the next string
         lText += " " + tText                                     ' Add it to the string
      LOOP                                                        '
      IF thinBasic_CheckCloseParens THEN                          ' And if closed by ) properly
         FUNCTION = lText                                         ' pass back the result
      END IF                                                      '
   END IF                                                         '
END FUNCTION                                                      '

FUNCTION TryGetS() AS STRING                                      '
'--------------------------------------------------------------------------------------------------+
'- Get number of macro parameters                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   gMacroTHeader = "Get$() "                                      '
   FUNCTION = "ABC": TP.ErrMsgReset                               ' Return value
   DoTraceS("ABC")                                                ' Do trace if needed
END FUNCTION                                                      '

FUNCTION TryGetN() AS EXT                                        '
'--------------------------------------------------------------------------------------------------+
'- Get number of macro parameters                                                                  |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   gMacroTHeader = "Get#() "                                      '
   FUNCTION = 123: TP.ErrMsgReset                                 ' Return value
   DoTraceN(123)                                                  ' Do trace if needed
END FUNCTION                                                      '
