'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- DialogEquates.inc                                                                               |
'--------------------------------------------------------------------------------------------------+
                                                                  '
'--------------------------------------------------------------------------------------------------+
'- Size equates                                                                                    |
'--------------------------------------------------------------------------------------------------+
%GLM = 2                                                          ' Graphic area LM pad
%GRM = 2                                                          ' Graphic area RM pad

'--------------------------------------------------------------------------------------------------+
'- Control equates                                                                                 |
'--------------------------------------------------------------------------------------------------+
ENUM B1 SINGULAR                                                  '
   TAB_CONTROL              = 1000                                '
   DIALOG_DONE                                                    '
   DIALOG_CANCEL                                                  '
   DIALOG_INI_TEXT1                                               '
   DIALOG_INI_TEXT2                                               '
   DIALOG_INI_TEXT3                                               '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Options General and Submit Tabs                                                                 |
'--------------------------------------------------------------------------------------------------+
ENUM O1 SINGULAR                                                  '
   GENERAL_INIABeepFlag     = 1101                                '
   GENERAL_INIAttnPos                                             '
   GENERAL_INIVBeepFlag                                           '
   GENERAL_INIMinRetrieve                                         '
   GENERAL_INIMinRetrieve_TEXT                                    '
   GENERAL_INICmdChr                                              '
   GENERAL_INICmdChr_TEXT                                         '
   GENERAL_INIReOpenLast                                          '
   GENERAL_FILETITLE                                              '
   GENERAL_FILETITLE_TEXT                                         '
   GENERAL_INIUniqueFlag                                          '
   GENERAL_INIUniqueFlag_TEXT                                     '
   GENERAL_INIUseRecycle                                          '
   GENERAL_INIUseRecycle_TEXT                                     '
   GENERAL_INIViewWarn                                            '
   GENERAL_INIViewWarn_TEXT                                       '
   GENERAL_BKUPLAST                                               '
   GENERAL_BKUPLAST_TEXT                                          '
   GENERAL_FINDWORD                                               '
   GENERAL_FINDWORD_TEXT                                          '
   GENERAL_INIDefDataShift                                        '
   GENERAL_INIDefDataShift_TEXT1                                  '
   GENERAL_INIDefDataShift_TEXT2                                  '
   GENERAL_INIBKPRetentionHeader_TEXT                             '
   GENERAL_INIBKPRETPD                                            '
   GENERAL_INIBKPRETPD_TEXT                                       '
   GENERAL_INIBKPMinGen                                           '
   GENERAL_INIBKPMinGen_TEXT                                      '
   GENERAL_INIBKPMaxGen                                           '
   GENERAL_INIBKPMaxGen_TEXT                                      '
   GENERAL_INICUTNew                                              '
   GENERAL_INICUTNew_TEXT                                         '
   GENERAL_INILANG                                                '
   GENERAL_INILANG_TEXT                                           '
   GENERAL_INIAutoScroll                                          '
   GENERAL_INIAutoScroll_TEXT                                     '
   GENERAL_Allow2D                                                '
   GENERAL_ININotify                                              '
   GENERAL_ININotify_TEXT                                         '
   GENERAL_INIENGChars                                            '
   GENERAL_INIENGChars_TEXT                                       '
   GENERAL_INIHelpOpen                                            '
   GENERAL_INIHelpOpen_TEXT                                       '
   GENERAL_INIInvChar                                             '
   GENERAL_INIInvChar_TEXT1                                       '
   GENERAL_INIInvChar_TEXT2                                       '
   GENERAL_INIResetU                                              '
   GENERAL_INILinRepeatMax                                        '
   GENERAL_INILinRepeatMax_TEXT                                   '
   GENERAL_INISetUNDO                                             '
   GENERAL_INISetUNDO_TEXT                                        '
   GENERAL_INIPDotRaw                                             '
   GENERAL_INIPDotRaw_TEXT                                        '
   GENERAL_INIWarnNonText                                         '
   GENERAL_INIWarnNonText_TEXT                                    '
   GENERAL_INIHomeFolder                                          '
   GENERAL_INIHomeFolder_TEXT                                     '
   GENERAL_INIMinToTray                                           '
   GENERAL_INIMinToTray_TEXT                                      '
   GENERAL_INISplash                                              '
   GENERAL_INIWebCheck                                            '
   GENERAL_INIWebCheck_TEXT                                       '
   GENERAL_INIWebCheck_NOW                                        '
   GENERAL_PanelMax                                               '
   GENERAL_GPLV3                                                  '
   GENERAL_LOGO                                                   '
   GENERAL_MacName                                                '
   GENERAL_T1                                                     '
   GENERAL_T2                                                     '
   GENERAL_T3                                                     '
   GENERAL_T4                                                     '
   GENERAL_T5                                                     '
   GENERAL_T6                                                     '
   GENERAL_T7                                                     '
   GENERAL_T8                                                     '
   GENERAL_T9                                                     '
   GENERAL_T10                                                    '
   GENERAL_T11                                                    '
   GENERAL_T12                                                    '
   GENERAL_T13                                                    '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- File Manager Screen Tab                                                                         |
'--------------------------------------------------------------------------------------------------+
ENUM F1 SINGULAR                                                  '
   FMANAGER_INIFMLayout = 1201                                    '
   FMANAGER_INIFMLayout_TEXT                                      '
   FMANAGER_FMDATEHILITE                                          '
   FMANAGER_INIFMDefSort                                          '
   FMANAGER_INIFMDefSort_TEXT                                     '
   FMANAGER_INIFMDirSort                                          '
   FMANAGER_INIFMDirSort_TEXT                                     '
   FMANAGER_INIFMLayout_Help1_TEXT                                '
   FMANAGER_INIFMLayout_Help2_TEXT                                '
   FMANAGER_INIFMLayout_Help3_TEXT                                '
   FMANAGER_INIFMLayout_Help4_TEXT                                '
   FMANAGER_INIFMLayout_Help5_TEXT                                '
   FMANAGER_INIFMLayout_Help6_TEXT                                '
   FMANAGER_INIFMLayout_Help7_TEXT                                '
   FMANAGER_INIFMLayout_Help8_TEXT                                '
   FMANAGER_INIFMCloseFlag                                        '
   FMANAGER_INIFMNoteWidth                                        '
   FMANAGER_INIFMNoteWidth_TEXT                                   '
   FMANAGER_INIFMCloseFlag_TEXT                                   '
   FMANAGER_INIFMLCmdWidth                                        '
   FMANAGER_INIFMLCmdWidth_TEXT                                   '
   FMANAGER_INIConfDelFlag                                        '
   FMANAGER_INIConfDelFlag_TEXT                                   '
   FMANAGER_FMHLFLAG                                              '
   FMANAGER_FMHLFLAG_TEXT                                         '
   FMANAGER_INIRecentCtr                                          '
   FMANAGER_INIRecentCtr_TEXT                                     '
   FMANAGER_INIFMLayoutM                                          '
   FMANAGER_INIFMLayoutM_TEXT                                     '
   FMANAGER_INIFMSortSimple                                       '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- SUBMIT equates                                                                                  |
'--------------------------------------------------------------------------------------------------+
ENUM S2 SINGULAR                                                  '
   SUBMIT_SUBMIT            = 1301                                '
   SUBMIT_SUBMIT_TEXT                                             '
   SUBMIT_INICMDFlags                                             '
   SUBMIT_INICMDFlags_TEXT                                        '
   SUBMIT_INIRUNFlags                                             '
   SUBMIT_INIRUNFlags_TEXT                                        '
   SUBMIT_INIInclKey                                              '
   SUBMIT_INIInclKey_TEXT                                         '
   SUBMIT_INIInclCol                                              '
   SUBMIT_INIInclCol_TEXT                                         '
   SUBMIT_H1                                                      '
   SUBMIT_H2                                                      '
   SUBMIT_H3                                                      '
   SUBMIT_H4                                                      '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Options Screen Tab                                                                              |
'--------------------------------------------------------------------------------------------------+
ENUM O2 SINGULAR                                                  '
   SCREEN_STATFLAG          = 1401                                '
   SCREEN_CURSHGHTNORM                                            '
   SCREEN_CURSHGHTNORM_TEXT                                       '
   SCREEN_CURSHGHTINS                                             '
   SCREEN_CURSHGHTINS_TEXT                                        '
   SCREEN_INIBanding                                              '
   SCREEN_INIBanding_TEXT                                         '
   SCREEN_INIHRuler                                               '
   SCREEN_INIVRuler                                               '
   SCREEN_INICMDHILITE                                            '
   SCREEN_COLORIZE                                                '
   SCREEN_INIScrWidth                                             '
   SCREEN_INIScrWidth_TEXT                                        '
   SCREEN_INIScrHeight                                            '
   SCREEN_INIScrHeight_TEXT                                       '
   SCREEN_INIFontName                                             '
   SCREEN_INIFontName_TEXT                                        '
   SCREEN_INIFontPitch                                            '
   SCREEN_INIFontPitch_TEXT                                       '
   SCREEN_FONT_CHOOSE                                             '
   SCREEN_FONT_CHOOSE_TEXT                                        '
   SCREEN_FILELINEFMT                                             '
   SCREEN_FILELINEFMT_TEXT                                        '
   SCREEN_INIPFKShow                                              '
   SCREEN_INIPFKShow_TEXT                                         '
   SCREEN_COLOR_PROMPT_TEXT                                       '
   SCREEN_FONTCHARS                                               '
   SCREEN_FONTCHARS_TEXT                                          '
   SCREEN_INISBFactor                                             '
   SCREEN_INISBFactor_TEXT                                        '
   SCREEN_INILNOSIZE                                              '
   SCREEN_INILNOSIZE_TEXT                                         '
   SCREEN_INIVERTINSCURS                                          '
   SCREEN_INIVERTINSCURS_TEXT                                     '
   SCREEN_INIcMarkLine                                            '
   SCREEN_INIcMarkLine_TEXT                                       '
   SCREEN_INIvSCROLLBAR                                           '
   SCREEN_16_FG                                                   ' Keep these together 1435
   SCREEN_16_BG1                                                  '
   SCREEN_16_BG2                                                  '
   SCREEN_16_TEXT                                                 '

END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Options Keyboard Tab                                                                            |
'--------------------------------------------------------------------------------------------------+
ENUM O3 SINGULAR                                                  '
   KBOARD_KBSCROLLH         = 1550                                '
   KBOARD_KBSCROLLV                                               '
   KBOARD_INIInsMode                                              '
   KBOARD_INIInsReset                                             '
   KBOARD_FRPTFLAG                                                '
   KBOARD_FRPTFLAG_TEXT                                           '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Options Scheme Tab                                                                              |
'--------------------------------------------------------------------------------------------------+
ENUM C1 SINGULAR                                                  '
   SCHEME_HEADING1          = 1600                                '
   SCHEME_HEADING2                                                '
   SCHEME_HEADING3                                                '
   SCHEME_HEADING4                                                '
   SCHEME_00_FG                                                   '
   SCHEME_00_BG1                                                  '
   SCHEME_00_BG2                                                  '
   SCHEME_00_TEXT                                                 '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Options Status Bar Tab                                                                          |
'--------------------------------------------------------------------------------------------------+
ENUM O4 SINGULAR                                                  '
   SBAR_INISBOrder         = 1800                                 '
   SBAR_INISBOrder_TEXT                                           '
   SBAR_Help1                                                     '
   SBAR_Help2                                                     '
   SBAR_Help3                                                     '
   SBAR_Help4                                                     '
   SBAR_Help5                                                     '
   SBAR_Help6                                                     '
   SBAR_Help7                                                     '
   SBAR_Help8                                                     '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Options HiLites Tab                                                                             |
'--------------------------------------------------------------------------------------------------+
ENUM V1 SINGULAR                                                  '
   HILITES_HEADING1          = 1851                               '
   HILITES_HEADING2                                               '
   HILITES_HEADING3                                               '
   HILITES_00_TEXT                                                '
   HILITES_01_TEXT                                                '
   HILITES_02_TEXT                                                '
   HILITES_03_TEXT                                                '
   HILITES_04_TEXT                                                '
   HILITES_05_TEXT                                                '
   HILITES_06_TEXT                                                '
   HILITES_07_TEXT                                                '
   HILITES_08_TEXT                                                '
   HILITES_09_TEXT                                                '
   HILITES_10_TEXT                                                '
   HILITES_11_TEXT                                                '
   HILITES_12_TEXT                                                '
   HILITES_13_TEXT                                                '
   HILITES_14_TEXT                                                '
   HILITES_15_TEXT                                                '
   HILITES_01_FG                                                  ' 1867
   HILITES_01_BG1                                                 '
   HILITES_01_BG2                                                 '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Options Config Tab                                                                              |
'--------------------------------------------------------------------------------------------------+
ENUM V2 SINGULAR                                                  '
   CONFIG_HOMEPATH           = 1901                               '
   CONFIG_HOMEPATH_TEXT                                           '
   CONFIG_HOMEDATA                                                '
   CONFIG_HOMEDATA_TEXT                                           '
   CONFIG_HOMEBKPNAME                                             '
   CONFIG_HOMEEFTNAME                                             '
   CONFIG_HOMEKBDNAME                                             '
   CONFIG_HOMERTRNAME                                             '
   CONFIG_HOMESETNAME                                             '
   CONFIG_TEXT1                                                   '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- System Tray                                                                                     |
'--------------------------------------------------------------------------------------------------+
ENUM V3 SINGULAR                                                  '
   TRAY_ABOUT              = 1945                                 '
   TRAY_ICON                                                      '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Profile Dialog                                                                                  |
'--------------------------------------------------------------------------------------------------+
ENUM P1 SINGULAR                                                  '
   FILE_PROFLOCK            = 1950                                '
   FILE_AUTOSAVE                                                  '
   FILE_AUTOSAVE_TEXT                                             '
   FILE_TABSFLAG                                                  '
   FILE_TABBNDS                                                   '
   FILE_MARKFLAG                                                  '
   FILE_AUTOBKUP                                                  '
   FILE_AUTOCAPS                                                  '
   FILE_BOM                                                       '
   FILE_PRESERVE                                                  '
   FILE_PRESERVE_TEXT                                             '
   FILE_INCLUDE                                                   '
   FILE_INCLUDE_TEXT                                              '
   FILE_SUBINCLUDE                                                '
   FILE_SUBINCLUDE_TEXT                                           '
   FILE_BOUNDS                                                    '
   FILE_BOUNDS_TEXT                                               '
   FILE_COLSFLAG                                                  '
   FILE_CAPSDFLAG                                                 '
   FILE_CAPSDFLAG_TEXT                                            '
   FILE_CMNTID                                                    '
   FILE_CMNTID_TEXT                                               '
   FILE_CMNTCOL                                                   '
   FILE_CMNTCOL_TEXT                                              '
   FILE_CMNTINCR                                                  '
   FILE_CMNTINCR_TEXT                                             '
   FILE_CMNTEND                                                   '
   FILE_CMNTEND_TEXT                                              '
   FILE_RECFM                                                     '
   FILE_RECFM_TEXT                                                '
   FILE_EMACRO                                                    '
   FILE_EOL                                                       '
   FILE_EOL_TEXT                                                  '
   FILE_EMACRO_TEXT                                               '
   FILE_HIFIND                                                    '
   FILE_HIAUTO                                                    '
   FILE_IMACRO                                                    '
   FILE_IMACRO_TEXT                                               '
   FILE_LRECL                                                     '
   FILE_LRECL_TEXT                                                '
   FILE_XFORM                                                     '
   FILE_XFORM_TEXT                                                '
   FILE_MACLIB                                                    '
   FILE_MACLIB_TEXT                                               '
   FILE_HEXMFLAG                                                  '
   FILE_XTABS                                                     '
   FILE_XTABS_TEXT                                                '
   FILE_SCRLAMTC                                                  '
   FILE_SCRLAMTC_TEXT                                             '
   FILE_ACTION                                                    '
   FILE_ACTION_TEXT                                               '
   FILE_MESSAGE1_TEXT                                             '
   FILE_MESSAGE2_TEXT                                             '
   FILE_MESSAGE3_TEXT                                             '
   FILE_STATEFLAG                                                 '
   FILE_STATEFLAG_TEXT                                            '
   FILE_SOURCEFLAG                                                '
   FILE_SOURCEFLAG_TEXT                                           '
   FILE_CASE                                                      '
   FILE_START                                                     '
   FILE_START_TEXT                                                '
   FILE_MINLEN                                                    '
   FILE_MINLEN_TEXT                                               '
   FILE_CHANGE                                                    '
   FILE_CHANGE_TEXT                                               '
   FILE_COLLATE                                                   '
   FILE_COLLATE_TEXT                                              '
   FILE_SUBARG                                                    '
   FILE_SUBARG_TEXT                                               '
   FILE_SUBCMD                                                    '
   FILE_SUBCMD_TEXT                                               '
   FILE_AUTONAME                                                  '
   FILE_AUTONAME_TEXT                                             '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Keymap Dialog                                                                                   |
'--------------------------------------------------------------------------------------------------+
ENUM K1 SINGULAR                                                  '
   KEYMAP_KBFRAME           = 2101                                '
   KEYMAP_DONE                                                    '
   KEYMAP_PROMPT                                                  '
   KEYMAP_CANCEL                                                  '
   KEYMAP_NORMAL                                                  '
   KEYMAP_SHIFT                                                   '
   KEYMAP_CONTROL                                                 '
   KEYMAP_ALT                                                     '
   KEYMAP_SHIFTCONTROL                                            '
   KEYMAP_SHIFTALT                                                '
   KEYMAP_SHIFTCONTALT                                            '
   KEYMAP_CONTROLALT                                              '
   KEYMAP_NORMAL_TEXT                                             '
   KEYMAP_SHIFT_TEXT                                              '
   KEYMAP_CONTROL_TEXT                                            '
   KEYMAP_ALT_TEXT                                                '
   KEYMAP_SHIFTCONTROL_TEXT                                       '
   KEYMAP_SHIFTALT_TEXT                                           '
   KEYMAP_SHIFTCONTALT_TEXT                                       '
   KEYMAP_CONTROLALT_TEXT                                         '
   KEYMAP_NUP                                                     '
   KEYMAP_SUP                                                     '
   KEYMAP_CUP                                                     '
   KEYMAP_AUP                                                     '
   KEYMAP_SCUP                                                    '
   KEYMAP_SAUP                                                    '
   KEYMAP_SCAUP                                                   '
   KEYMAP_CAUP                                                    '
   KEYMAP_HINT_1                                                  '
   KEYMAP_HINT_2                                                  '
   KEYMAP_HINT_3                                                  '
   KEYMAP_HINT_4                                                  '
   KEYMAP_HINT_5                                                  '
   KEYMAP_HINT_6                                                  '
   KEYMAP_HINT_7                                                  '
   KEYMAP_PRIMITIVEHINT                                           '
   KEYMAP_CURRENT_TEXT                                            '
   KEYMAP_CURRENT_ICON                                            '
   KEYMAP_REPEAT_TEXT                                             '
   KEYMAP_ANSI                                                    '
   KEYMAP_KEYRESET                                                '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- PRINT Setup Dialog                                                                              |
'--------------------------------------------------------------------------------------------------+
ENUM p2 SINGULAR                                                  '
   PRINT_PTEXT1             = 2201                                '
   PRINT_INIPrtName_TEXT                                          '
   PRINT_INIPrtOrient_TEXT                                        '
   PRINT_INIPrtPaper_TEXT                                         '
   PRINT_PCHOOSE                                                  '
   PRINT_FTEXT1                                                   '
   PRINT_FNAME_TEXT                                               '
   PRINT_FPOINT_TEXT                                              '
   PRINT_FBOLD_TEXT                                               '
   PRINT_FCHOOSE                                                  '
   PRINT_HLINE                                                    '
   PRINT_VLINE                                                    '
   PRINT_MTEXT1                                                   '
   PRINT_METRIC                                                   '
   PRINT_BANDING                                                  '
   PRINT_BANDLINES                                                '
   PRINT_BANDINGCOLOR                                             '
   PRINT_BANDINGCOLOR_TEXT                                        '
   PRINT_LM                                                       '
   PRINT_LM_TEXT                                                  '
   PRINT_RM                                                       '
   PRINT_RM_TEXT                                                  '
   PRINT_TM                                                       '
   PRINT_TM_TEXT                                                  '
   PRINT_BM                                                       '
   PRINT_BM_TEXT                                                  '
   PRINT_HTEXT1                                                   '
   PRINT_HEADER                                                   '
   PRINT_HEADER_LEFT                                              '
   PRINT_HEADER_LEFT_TEXT                                         '
   PRINT_HEADER_CENTER                                            '
   PRINT_HEADER_CENTER_TEXT                                       '
   PRINT_HEADER_RIGHT                                             '
   PRINT_HEADER_RIGHT_TEXT                                        '
   PRINT_FTEST1                                                   '
   PRINT_FOOTER                                                   '
   PRINT_FOOTER_LEFT                                              '
   PRINT_FOOTER_LEFT_TEXT                                         '
   PRINT_FOOTER_CENTER                                            '
   PRINT_FOOTER_CENTER_TEXT                                       '
   PRINT_FOOTER_RIGHT                                             '
   PRINT_FOOTER_RIGHT_TEXT                                        '
   PRINT_PCOLOR                                                   '
   PRINT_CANCEL                                                   '
   PRINT_DONE                                                     '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Welcome, choose Enter key Dialog                                                                |
'--------------------------------------------------------------------------------------------------+
ENUM W1 SINGULAR                                                  '
   WELCOME_HOMEFOLDER       = 2301                                '
   WELCOME_HOMEDATA                                               '
   WELCOME_PBAR                                                   '
   WELCOME_OPTION1                                                '
   WELCOME_OPTION2                                                '
   WELCOME_OPTION3                                                '
   WELCOME_OPTION4                                                '
   WELCOME_OPTION5                                                '
   WELCOME_OPTION6                                                '
   WELCOME_OPTION7                                                '
   WELCOME_TEXT                                                   '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- FF Interrupt Dialog                                                                             |
'--------------------------------------------------------------------------------------------------+
ENUM I1 SINGULAR                                                  '
   INTERRUPT_TEXT1          = 2351                                '
   INTERRUPT_TEXT2                                                '
   INTERRUPT_TEXT3                                                '
   INTERRUPT_BREAK                                                '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Instance Dialog                                                                                 |
'--------------------------------------------------------------------------------------------------+
ENUM I2 SINGULAR                                                  '
   INSTANCE_BKP             = 2401                                '
   INSTANCE_BKP_TEXT                                              '
   INSTANCE_EFT                                                   '
   INSTANCE_EFT_TEXT                                              '
   INSTANCE_KBD                                                   '
   INSTANCE_KBD_TEXT                                              '
   INSTANCE_RTR                                                   '
   INSTANCE_RTR_TEXT                                              '
   INSTANCE_SET                                                   '
   INSTANCE_SET_TEXT                                              '
   INSTANCE_CFGLIST                                               '
   INSTANCE_CFGLIST_TEXT                                          '
   INSTANCE_TEXT1                                                 '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Debug Window                                                                                    |
'--------------------------------------------------------------------------------------------------+
ENUM I3 SINGULAR                                                  '
   DEBUG_LISTVIEW           = 2501                                '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- DIFF Input Window                                                                               |
'--------------------------------------------------------------------------------------------------+
ENUM I4 SINGULAR                                                  '
   DIFF_FileA               = 2601                                '
   DIFF_FileA_Text                                                '
   DIFF_FileA_Choose                                              '
   DIFF_FileA_Bounds_Text                                         '
   DIFF_FileA_Bounds                                              '
   DIFF_FileA_Exclude                                             '
   DIFF_FileA_NXNone                                              '
   DIFF_FileA_NX                                                  '
   DIFF_FileA_X                                                   '
   DIFF_FileB                                                     '
   DIFF_FileB_Text                                                '
   DIFF_FileB_Choose                                              '
   DIFF_FileB_Bounds_Text                                         '
   DIFF_FileB_Bounds                                              '
   DIFF_FileB_Exclude                                             '
   DIFF_FileB_NXNone                                              '
   DIFF_FileB_NX                                                  '
   DIFF_FileB_X                                                   '
   DIFF_NoSpace                                                   '
   DIFF_NoTabs                                                    '
   DIFF_NoComment                                                 '
   DIFF_NoCASE                                                    '
   DIFF_NoMultB                                                   '
   DIFF_UseFileB                                                  '
   DIFF_1Column                                                   '
   DIFF_MinMatch_Text                                             '
   DIFF_MinMatch                                                  '
   DIFF_Only                                                      '
   DIFF_Cancel                                                    '
   DIFF_Done                                                      '
   DIFF_Line1                                                     '
   DIFF_Line2                                                     '
   DIFF_OPtions                                                   '
   DIFF_View                                                      '
   DIFF_Msg                                                       '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- DIFF List Window                                                                                |
'--------------------------------------------------------------------------------------------------+
ENUM I5 SINGULAR                                                  '
   DIFF_ListBox             = 2701                                '
   DIFF_LCancel                                                   '
   DIFF_Text                                                      '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- AMBIG List Window                                                                               |
'--------------------------------------------------------------------------------------------------+
ENUM I6 SINGULAR                                                  '
   AMBIG_ListBox            = 2701                                '
   AMBIG_LMain                                                    '
   AMBIG_LSearch                                                  '
   AMBIG_LProceed                                                 '
   AMBIG_LBailOut                                                 '
   AMBIG_Msg                                                      '
   AMBIG_Text                                                     '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- Dialog Equates                                                                                  |
'--------------------------------------------------------------------------------------------------+
%ID_Timer          = 100                                          '
%IDC_SPFLiteWindow = 200                                          '
%IDC_SPFLiteTAB    = 121                                          '
%IDC_SPFLitePREF   = 122                                          '
%IDC_Progress      = 123                                          '
%IDC_StatusBar     = 124                                          '
%IDC_ScrollBar     = 125                                          '
%IDC_LISTBOX       = 126                                          '
%MSG_ListBox       = 127                                          '
%CMD_TextBox       = 128                                          '
%IDC_OK            = 129                                          '

'--------------------------------------------------------------------------------------------------+
'- Tooltip stuff                                                                                   |
'--------------------------------------------------------------------------------------------------+
%TTS_ALWAYSTIP     = &H01                                         '
%TTS_BALLOON       = &H40                                         '
%TTF_IDISHWND      = &H0001                                       '
%TTF_SUBCLASS      = &H0010                                       '
%TTM_ADDTOOL       = %WM_USER +  4                                '
%TTM_DELTOOL       = %WM_USER +  5                                '
%TTM_GETTOOLINFO   = %WM_USER +  8                                '

'--------------------------------------------------------------------------------------------------+
'- New Version Dialog                                                                              |
'--------------------------------------------------------------------------------------------------+
ENUM U1 SINGULAR                                                  '
   UPDATE_RICHEDIT        = 2400                                  '
   UPDATE_LABEL                                                   '
END ENUM                                                          '

'--------------------------------------------------------------------------------------------------+
'- MyMsgBox Equates                                                                                |
'--------------------------------------------------------------------------------------------------+
ENUM MyMsgBox_equates SINGULAR                                    '
    MMB_Dlg = 9800                                                '
    MMB_Msg                                                       ' Return Code
    MMB_OK                                                        '  1  %IDO
    MMB_Cancel                                                    '  2  %IDCANCE
    MMB_Abort                                                     '  3  %IDABOR
    MMB_Retry                                                     '  4  %IDRETR
    MMB_Ignore                                                    '  5  %IDIGNOR
    MMB_Yes                                                       '  6  %IDYE
    MMB_No                                                        '  7  %IDN
    MMB_TryAgain                                                  ' 10  %IDTRYAGAI
    MMB_Continue                                                  ' 11  %IDCONTINU
    MMB_Icon                                                      '
    MMB_WOpen                                                     '
    MMB_Open                                                      '
    MMB_Custom1                                                   ' 12  %IDCustom
    MMB_Custom2                                                   ' 13  %IDCustom
    MMB_Custom3                                                   ' 14  %IDCustom
    MMB_Dummy                                                     ' Dummy ID
END ENUM                                                          '
