'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- DialogStuff.inc                                                                                 |
'--------------------------------------------------------------------------------------------------+
                                                                  '
CALLBACK FUNCTION DBDebugCallback ()                              '
   SELECT CASE AS LONG CB.MSG                                     '
      CASE %WM_INITDIALOG                                         '
        ghDBOldProc = SetWindowLongW(GetDlgItem(CB.HNDL, %IDC_LISTBOX), %GWL_WNDPROC, BYVAL CODEPTR(LBProc))   '

      CASE %WM_DESTROY                                            '
         SetWindowLongW(GetDlgItem(CB.HNDL, %IDC_LISTBOX), %GWL_WNDPROC, ghDBOldProc)  '

      CASE %WM_SYSCOMMAND                                         '
         IF (CBWPARAM AND &HFFF0) = %SC_CLOSE THEN                ' [X] ?
            LISTBOX RESET ghDB, %IDC_ListBox                      ' Clear table
            DIALOG HIDE ghDB                                      ' Make it hidden
            ghDBHide = %True                                      '
            FUNCTION = 1                                          ' App won't close
         END IF                                                   '
      CASE %WM_KEYDOWN                                            '
         IF CB.CTL = %IDC_LISTBOX THEN                            '
            MSGBOX "Keystroke detected in ListBox: " + FORMAT$(CB.WPARAM)  '
         END IF                                                   '
      CASE %WM_CHAR                                               ' A keyboard character as been typed
         MSGBOX "Keystroke detected in ListBox: " + FORMAT$(CB.WPARAM)  '
    END SELECT                                                    '
END FUNCTION                                                      '


FUNCTION LBProc(BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, BYVAL WPARAM AS LONG, BYVAL LPARAM AS LONG) AS LONG '
LOCAL ln, selctr, selitems(), i AS LONG, buffer AS ASCIIZ * 4096, CB AS STRING   '
LOCAL Info AS SCROLLINFO                                          '
STATIC LM AS LONG                                                 '

   SELECT CASE AS LONG wMsg                                       '

      CASE %WM_KEYDOWN                                            '

         IF GetKeyState(%VK_CONTROL) AND &H8000 THEN              ' Ctrl key down?
            IF WPARAM = ASC("C") THEN                             ' and a C   i.e. Ctrl-C (Copy)
               selctr = SendMessage(ghDBListBox, %LB_GETSELCOUNT, 0, 0) ' Get # of seleted lines
               IF selctr > 0 THEN                                 ' If some are selected
                  REDIM selItems(selctr - 1)                      ' Make table big enough to hold the item list
                  SendMessage(ghDBListBox, %LB_GETSELITEMS, selctr, VARPTR(selItems(0)))  ' Get the items
                  FOR i = 0 TO selctr - 1                         ' Loop picking up he text
                     SendMessage ghDBListBox, %LB_GETTEXT, selItems(i), VARPTR(buffer) '
                     CB += buffer + $CRLF                         ' Concatenate together
                  NEXT                                            '
                  CLIPBOARD SET TEXT CB                           ' Stuff in the Clipboard
                  SendMessage(ghDBListBox, %LB_SETSEL, %FALSE, -1)   ' Unselect the items to show we did it
               END IF                                             '
            END IF                                                '
         END IF                                                   '

         SELECT CASE AS LONG WPARAM                               '

            CASE %VK_UP                                           '
               ln = SendMessage(ghDBListBox, %LB_GETTOPINDEX, 0, 0)  '
               SendMessage ghDBListBox, %LB_SETTOPINDEX, MAX(0, ln - 1), 0 '

            CASE %VK_DOWN                                         '
               ln = SendMessage(ghDBListBox, %LB_GETTOPINDEX, 0, 0)  '
               SendMessage ghDBListBox, %LB_SETTOPINDEX, MIN(ghDBCtr - ghDBLines + 1, ln + 1), 0   '

            CASE %VK_RIGHT                                        '
               Info.cbSize = SIZEOF(scrollInfo)                   '
               Info.fMask = %SIF_POS                              '
               lm += 200                                          '
               Info.nPos = lm                                     '
               SetScrollInfo(ghDBListBox, %SB_HORZ, Info, %TRUE)  '
               SendMessage(ghDBListBox, %WM_HSCROLL, %SB_THUMBPOSITION OR (Info.nPos * 65536), ghDBListBox) '

            CASE %VK_LEFT                                         '
               Info.cbSize = SIZEOF(scrollInfo)                   '
               Info.fMask = %SIF_POS                              '
               lm = MAX(0, lm - 200)                              '
               Info.nPos = lm                                     '
               SetScrollInfo(ghDBListBox, %SB_HORZ, Info, %TRUE)  '
               SendMessage(ghDBListBox, %WM_HSCROLL, %SB_THUMBPOSITION OR (Info.nPos * 65536), ghDBListBox) '

            CASE %VK_PGUP                                         '
               ln = SendMessage(ghDBListBox, %LB_GETTOPINDEX, 0, 0)  '
               SendMessage ghDBListBox, %LB_SETTOPINDEX, MAX(0, ln - ghDBLines), 0  '

            CASE %VK_PGDN                                         '
               ln = SendMessage(ghDBListBox, %LB_GETTOPINDEX, 0, 0)  '
               SendMessage ghDBListBox, %LB_SETTOPINDEX, MIN(ghDBCtr - ghDBLines + 1, ln + ghDBLines), 0 '

            CASE %VK_HOME                                         '
               SendMessage ghDBListBox, %LB_SETTOPINDEX, 0, 0     '

            CASE %VK_END                                          '
               SendMessage ghDBListBox, %LB_SETTOPINDEX, MAX(0, ghDBCtr - ghDBLines + 1), 0  '

         END SELECT                                               '

         FUNCTION = 0                                             ' Say this message was handled
         EXIT FUNCTION                                            '

  END SELECT                                                      '

  FUNCTION = CallWindowProcW(ghDBOldProc, hWnd, wMsg, WPARAM, LPARAM)   '
END FUNCTION                                                      '

THREAD FUNCTION DispANSI2 (BYVAL colMode AS LONG) AS LONG         ' Start the ANSI window
'--------------------------------------------------------------------------------------------------+
'- Display the ANSI table                                                                          |
'--------------------------------------------------------------------------------------------------+
'- (CharSet)   passes colMode = %False via METHOD DispANSI in _TabData
'- (CharSetCol) passes colMode = %True via METHOD DispANSI in _TabData

LOCAL i, j AS LONG, TX, Char, txChar AS STRING                    '

THREADED tls_hANSI AS DWORD                                       '
THREADED tls_colMode AS LONG                                      '
THREADED tls_PrfGetX2APtr AS LONG                                 ' for either COLLATE or SOURCE tran table
THREADED tls_PrfGetA2XPtr AS LONG                                 ' for either COLLATE or SOURCE tran table
THREADED tls_ansiSource AS STRINGZ * 32                           ' a name like ANSI or EBCDIC

   MEntry                                                         '

   tls_colMode = colMode                                          '

   IF TP.FCB_.ColateXlate THEN                                    '
      tls_ansiSource = TP.FCB_.CollateStr                         ' a name like EBCDIC
      tls_PrfGetX2APtr = TP.FCB_.GetCS2APtr                       ' pointer to COLLATE tran table
      tls_PrfGetA2XPtr = TP.FCB_.GetCA2SPtr                       ' pointer to COLLATE tran table

   ELSEIF TP.FCB_.SrceXlate THEN                                  '
      tls_ansiSource = TP.FCB_.SourceName                         ' a name like EBCDIC
      tls_PrfGetX2APtr = TP.FCB_.GetSS2APtr                       ' pointer to SOURCE  tran table
      tls_PrfGetA2XPtr = TP.FCB_.GetSA2SPtr                       ' pointer to SOURCE  tran table

   ELSE                                                           '
      tls_ansiSource = "ANSI"                                     '
      tls_PrfGetX2APtr = 0                                        ' no active translation table
   END IF                                                         '

   DIALOG DEFAULT FONT gENV.FontName, gENV.FontPitch, gENV.FontStyle, 0 '

   DIALOG NEW PIXELS, 0, tls_ansiSource,,, _                      '
                      54 * gFontWidth, 24 * gFontHeight, _        '
                      %WS_CAPTION OR %WS_SYSMENU OR %WS_MINIMIZEBOX _   '
                      TO tls_hANSI                                '

   CONTROL ADD GRAPHIC, tls_hANSI, 5001, "", 0, 0, 54 * gFontWidth, 24 * gFontHeight   '
   GRAPHIC ATTACH tls_hANSI, 5001                                 ' Set as the default graphic area
   GRAPHIC SET FONT gScrFont                                      ' Set the desired font

   GRAPHIC CLEAR gTxtLoBG1                                        ' Clear it
   GRAPHIC COLOR gTxtLoFG, gTxtLoBG1                              '

   ClipBoardGet(TX)                                               ' Get any current text to start

   TX = PARSE$(TX, $CRLF, 1)                                      ' Get 1st 'line'

   '-----------------------------------------------------------------------------------------------+
   '- Finally draw the chart                                                                       |
   '-----------------------------------------------------------------------------------------------+
   GRAPHIC SET POS (1, 1)                                         ' Starting position

   GOSUB ShowHorizontalCaption                                    '

   FOR i = 1 TO 16                                                ' Display the table
      GRAPHIC SET POS (1, gFontHeight + i * gFontHeight)          ' Set position for one row

      GOSUB ShowVerticalCaption                                   ' Print the left hand heading

      FOR j = 1 TO 16                                             ' Now a row of characters
         GRAPHIC SET POS (4 * gFontWidth + ((j - 1) * (gFontWidth * 3)), gFontHeight + i * gFontHeight)  ' Set position for Print

         IF tls_colMode THEN                                      '
            char = CHR$(CHR$(((j-1) * 16) + (i-1)))               ' Create character - column mode order
         ELSE                                                     '
            char = CHR$(CHR$(((i-1) * 16) + (j-1)))               ' Create character - row mode order
         END IF                                                   '

         IF tls_PrfGetX2APtr THEN                                 ' If not ANSI
            TP.Translate(Char, tls_PrfGetX2APtr)                  ' Get the ANSI equivalent
         END IF                                                   '

         GRAPHIC PRINT Char                                       ' Print the next ANSI char
      NEXT j                                                      '

      GRAPHIC SET POS (5 * gFontWidth + (16 * (gFontWidth * 3) - gFontWidth), gFontHeight + i * gFontHeight)   '
      GOSUB ShowVerticalCaption                                   ' Print the right hand heading

   NEXT i                                                         '
   GRAPHIC SET POS (1, 19 * gFontHeight)                          ' Starting position

   GOSUB ShowHorizontalCaption                                    '

   '-----------------------------------------------------------------------------------------------+
   '- New format on bottom of ANSI popup, with new line added:                                     |
   '-                                                                                              |
   '-  Dec Hex Chr Len Current ANSI Clipboard:                                                     |
   '-  051 33 '3'  6  "ABC123"                                                                     |
   '-                 |                                                                            |
   '-  1234567890123456|                                                                           |
   '-----------------------------------------------------------------------------------------------+

   GRAPHIC SET POS (1, 21 * gFontHeight)                          ' Set position for Instruction row
   GRAPHIC PRINT "Clipboard: Left-Click=Replace - Right-Click=Append"   '
   GRAPHIC SET POS (1, 22 * gFontHeight)                          ' Set position for Data row
   GRAPHIC PRINT "Dec Hex Chr Len Current " + tls_ansiSource + " Clipboard:"  ' Clipboard data caption

   '-----------------------------------------------------------------------------------------------+
   '- We will make the initial display be consistant as if we just typed the last character        |
   '- in the clipboard. if the clipboard's length is zero, we pretend they entered a NUL,          |
   '- which they can't really do.                                                                  |
   '-----------------------------------------------------------------------------------------------+

   IF LEN(TX) = 0 THEN                                            '
      Char = $NUL                                                 '
      txChar = " "                                                '
   ELSE                                                           '
      Char = RIGHT$(TX, 1)                                        '
      txChar = Char                                               '
   END IF                                                         '

   IF tls_PrfGetX2APtr THEN                                       ' If not ANSI
      TP.Translate(Char, tls_PrfGetA2XPtr)                        ' Get the non-ANSI equivalent
   END IF                                                         '

   GRAPHIC SET POS (1, 23 * gFontHeight)                          ' Set position for last row

   GRAPHIC PRINT FORMAT$(ASC(Char), "000") + "  " + HEX$(ASC(Char), 2) _   '
      + " '" + txChar + "'" + DEC$(LEN(TX), -3) + "  " + $DQ + TX + $DQ + SPACE$(50)   '

   GRAPHIC REDRAW                                                 '

   '-----------------------------------------------------------------------------------------------+
   '-  Store pointers to tls data so dialog can grab them                                          |
   '-----------------------------------------------------------------------------------------------+

   DIALOG SET USER tls_hANSI, %uda_colMode,      tls_colMode      '
   DIALOG SET USER tls_hANSI, %uda_PrfGetX2APtr, tls_PrfGetX2APtr '
   DIALOG SET USER tls_hANSI, %uda_ansiSource,   VARPTR (tls_ansiSource)   '

   DIALOG SHOW MODAL tls_hANSI CALL DlgANSICallback               ' Display ANSI screen

   MExitFunc                                                      '

ShowHorizontalCaption:                                            '
   IF tls_colMode THEN                                            '
      GRAPHIC PRINT "   00 10 20 30 40 50 60 70 80 90 A0 B0 C0 D0 E0 F0"   ' Print heading
   ELSE                                                           '
      GRAPHIC PRINT "   00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F"   ' Print heading
   END IF                                                         '
   RETURN                                                         '

ShowVerticalCaption:                                              '
   IF tls_colMode THEN                                            '
      GRAPHIC PRINT "0" + HEX$(i - 1, 1)                          ' Print left/right heading as 0x
   ELSE                                                           '
      GRAPHIC PRINT       HEX$(i - 1, 1) + "0"                    ' Print left/right heading as x0
   END IF                                                         '
   RETURN                                                         '

END FUNCTION                                                      '

FUNCTION DispDefault(ft AS STRING) AS STRING                      '
'--------------------------------------------------------------------------------------------------+
'- Display the Default dialog                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL CFGs() AS STRING, CFGCtr, i, j AS LONG                      '
DIM CFGs(1 TO 100) AS STRING                                      '
LOCAL lclFt AS STRING                                             '
   MEntry                                                         '
   lclFt = UCASE$(ft)                                             '
   '-----------------------------------------------------------------------------------------------+
   '- Collect the existing Profile file names from the CFG file                                    |
   '-----------------------------------------------------------------------------------------------+
   CFGCtr = 1: CFGs(CFGCtr) = " (Choose)"                         ' Put header in list
   gSQL.SelBegin("select name FROM sqlite_master WHERE type ='table' AND name like 'P%'") '
   IF gSQL.SelFirst() THEN                                        ' Select the first
      DO                                                          ' Loop through them
         INCR CFGCtr                                              ' Count it
         IF CFGCtr > UBOUND(CFGs()) THEN REDIM PRESERVE CFGs(1 TO UBOUND(CFGs()) * 2) AS STRING '
         CFGs(CFGCtr) = MID$(gSQL.SelGet("Name"), 2)              ' Collect the name
      LOOP WHILE gSQL.SelNext()                                   '
   END IF                                                         '
   gSQL.SelEnd                                                    ' Close the SQL request
   ARRAY SORT CFGs() FOR CFGCtr                                   ' Sort it
   FOR i = 1 TO CFGCtr                                            ' Locate the DEFAULT entry
      IF CFGs(i) = "DEFAULT" THEN j = i: EXIT FOR                 ' Save it
   NEXT i                                                         '
   gDefaultAnswer = ""                                            ' Clear answer

   '-----------------------------------------------------------------------------------------------+
   '- Build the dialog                                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG FONT DEFAULT "Tahoma", 12 / gFontScale, 0, 0            '
   DIALOG NEW ghWnd, "Create new Profile",,, 300, 135, %WS_THICKFRAME OR %WS_CAPTION TO ghDef   '
   DIALOG SET COLOR ghDef, %RGB_GAINSBORO, %RGB_GAINSBORO         '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+0, "No profile currently exists for file-type " + lclFt, 1, 1, 200, 11   '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+0, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+1, "You may choose one of the following options:", 1, 11, 247, 11  '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+1, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD BUTTON, ghDef, %WELCOME_OPTION1, "DEFAULT", 1, 27, 85, 13, %WS_BORDER   '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+7, "Use DEFAULT Profile for this file-type", 90, 29, 200, 11 '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+7, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD COMBOBOX, ghDef, %WELCOME_OPTION2, CFGs(), 1, 43, 85, 60, %CBS_DROPDOWNLIST OR %WS_VSCROLL   '
   COMBOBOX SELECT ghDef, %WELCOME_OPTION2, j                     '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+8, "Create Profile " + lclFt + " based on this existing Profile", 90, 45, 200, 11 '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+8, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD COMBOBOX, ghDef, %WELCOME_OPTION3, CFGs(), 1, 59, 85, 60, %CBS_DROPDOWNLIST OR %WS_VSCROLL   '
   COMBOBOX SELECT ghDef, %WELCOME_OPTION3, 1                     '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+9, "Assign a current Profile (using EFT) to use for this file-type", 90, 61, 200, 11 '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+9, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD BUTTON, ghDef, %WELCOME_OPTION4, IIF$(IsFMTab, "&Abort", "&Cancel"), 1, 76, 85, 13, %WS_BORDER  '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+12, IIF$(IsFMTab, "Cancel this FF Search", "Cancel the file OPEN"), 90, 78, 200, 11  '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+12, %BLUE, %RGB_GAINSBORO   '
   CONTROL ADD BUTTON, ghDef, %WELCOME_OPTION5, IIF$(IsFMTab, "&Skip", "Mark as NONTEXT"), 1, 92, 85, 13, %WS_BORDER '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+11, IIF$(IsFMTab, "Skip file", "Cancel Open") + " and mark " + lclFT + " as NONTEXT in EFT list", 90, 94, 200, 11  '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+11, %BLUE, %RGB_GAINSBORO   '
   CONTROL ADD BUTTON, ghDef, %WELCOME_OPTION6, IIF$(IsFMTab, "&Skip", "Mark as OPENWITH"), 1, 108, 85, 13, %WS_BORDER  '
   CONTROL ADD LABEL,  ghDef, %WELCOME_TEXT+13, IIF$(IsFMTab, "Skip file", "Cancel Open") + " and mark " + lclFT + " as OPENWITH in EFT list", 90, 110, 250, 11   '
   CONTROL SET COLOR   ghDef, %WELCOME_TEXT+13, %BLUE, %RGB_GAINSBORO   '
   KbdPopSave                                                     ' Ready for pop-up
   DIALOG SHOW MODAL ghDef CALL DlgDefaultCallback                ' Display it all
   KbdPopRestore                                                  ' Reset popup state
   FUNCTION = gDefaultAnswer                                      ' Pass back the answer
   MExit                                                          '
END FUNCTION                                                      '

SUB     DispInterrupt(title AS STRING, titem AS STRING)           '
'--------------------------------------------------------------------------------------------------+
'- Display the Interrupt button                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j AS LONG                                                '
   DIALOG GET LOC ghWnd TO i, j                                   ' Get location where window was
   DIALOG NEW PIXELS, 0, title, i + 15, j + 15, 300, 86, %WS_CAPTION OR %WS_SYSMENU, %WS_EX_TOPMOST TO ghIntr  '
   DIALOG SET COLOR     ghIntr, %RGB_GAINSBORO, %RGB_GAINSBORO    '
   CONTROL ADD LABEL,   ghIntr, %INTERRUPT_TEXT1, titem, 4, 4, 300, 16  '
   CONTROL SET FONT     ghIntr, %INTERRUPT_TEXT1, gFixedFont      '
   CONTROL SET COLOR    ghIntr, %INTERRUPT_TEXT1, %BLACK, %RGB_GAINSBORO   '
   CONTROL ADD LABEL,   ghIntr, %INTERRUPT_TEXT2, " ", 14, 20, 250, 16  '
   CONTROL SET FONT     ghIntr, %INTERRUPT_TEXT2, gFixedFont      '
   CONTROL SET COLOR    ghIntr, %INTERRUPT_TEXT2, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD LABEL,   ghIntr, %INTERRUPT_TEXT3, " ", 14, 36, 250, 16  '
   CONTROL SET FONT     ghIntr, %INTERRUPT_TEXT3, gFixedFont      '
   CONTROL SET COLOR    ghIntr, %INTERRUPT_TEXT3, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD BUTTON,  ghIntr, %INTERRUPT_BREAK, "&Break", 115, 56, 75, 28, %WS_BORDER   '
   DIALOG SHOW MODELESS ghIntr CALL DlgIntruptCallback            ' Display it all

END SUB                                                           '

FUNCTION DispInstance(iName AS STRING) AS LONG                    '
'--------------------------------------------------------------------------------------------------+
'- Display the Welcome dialog                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL CFGCount, RC AS LONG                                        '
DIM CFGList(1 TO 1) AS STRING                                     '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Get the currently available Instances                                                        |
   '-----------------------------------------------------------------------------------------------+
   gSQL.SelBegin("select name FROM sqlite_master WHERE type ='table' AND name like 'O%'") '
   IF gSQL.SelFirst() THEN                                        ' Select the first
      DO                                                          ' Loop through them
         INCR CFGCount                                            ' Count it
         IF CFGCount > UBOUND(CFGList()) THEN _                   ' Keep table big enough
            REDIM PRESERVE CFGList(1 TO CFGCount) AS LOCAL STRING '
         CFGList(CFGCount) = MID$(gSQL.SelGet("Name"), 2)         ' Collect the name
      LOOP WHILE gSQL.SelNext()                                   '
   END IF                                                         '
   gSQL.SelEnd                                                    ' Close the SQL request

   '-----------------------------------------------------------------------------------------------+
   '- Build the dialog                                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG FONT DEFAULT "Tahoma", 11 / gFontScale, 0, 0            '
   DIALOG NEW 0, "SPFLite New Instance - " + iName, , , 250, 175, _  '
      %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR _ '
      %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR _  '
      %DS_SETFONT, %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO ghWel '
   DIALOG SET COLOR ghWel, %RGB_GAINSBORO, %RGB_GAINSBORO         '
   CONTROL ADD LABEL,  ghWel, %INSTANCE_TEXT1, "This is the first execution of the Instance: ", 15, 5, 248, 14 '
   CONTROL SET COLOR   ghWel, %INSTANCE_TEXT1, %BLUE, %RGB_GAINSBORO '
   CONTROL ADD LABEL,  ghWel, %INSTANCE_TEXT1+1, iName, 155, 5, 75, 14  '
   CONTROL SET COLOR   ghWel, %INSTANCE_TEXT1+1, %BLACK, %RGB_GAINSBORO '
   CONTROL ADD LABEL,  ghWel, %INSTANCE_TEXT1+2, "Before continuing, you must choose which current Instance you", 15, 20, 248, 12   '
   CONTROL SET COLOR   ghWel, %INSTANCE_TEXT1+2, %BLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL,  ghWel, %INSTANCE_TEXT1+3, "wish to base this on, and which other options should be unique.", 15, 30, 248, 12 '
   CONTROL SET COLOR   ghWel, %INSTANCE_TEXT1+3, %BLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL,  ghWel, %INSTANCE_TEXT1+4, "Please choose the Instance name to copy, and select (Tick)", 15, 50, 248, 12   '
   CONTROL SET COLOR   ghWel, %INSTANCE_TEXT1+4, %BLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL,  ghWel, %INSTANCE_TEXT1+5, "the options below you wish to be UNIQUE.", 15, 60, 248, 12   '
   CONTROL SET COLOR   ghWel, %INSTANCE_TEXT1+5, %BLUE, %RGB_GAINSBORO  '

   CONTROL ADD COMBOBOX, ghWel, %INSTANCE_CFGLIST, CFGList(), 150, 75, 75, 60, %CBS_DROPDOWN OR %WS_VSCROLL '
   COMBOBOX SELECT ghWel, %INSTANCE_CFGLIST, 1                    '
   DLGToolTipSet(GetDlgItem(ghWel, %INSTANCE_CFGLIST), " Select the Instance on which to base the new one. ")  '
   CONTROL ADD LABEL, ghWel, %INSTANCE_CFGLIST_TEXT, "Choose Instance to be copied", 15, 75, 135, 12  '
   CONTROL SET COLOR  ghWel, %INSTANCE_CFGLIST_TEXT, %BLACK, %RGB_GAINSBORO   '

   DLGAddCheck(ghWel, %INSTANCE_EFT, 0, 15, 93, 155, "EFT table entries are Unique")   '
   DLGToolTipSet(GetDlgItem(ghWel, %INSTANCE_EFT), " Select to maintain unique EFT table variables ") '
   CONTROL SET COLOR   ghWel, %INSTANCE_EFT, %BLACK, %RGB_GAINSBORO  '
   DLGAddCheck(ghWel, %INSTANCE_SET, 0, 15, 106, 155, "SET table entries are Unique")  '
   DLGToolTipSet(GetDlgItem(ghWel, %INSTANCE_SET), " Select to maintain unique SET table variables ") '
   CONTROL SET COLOR   ghWel, %INSTANCE_SET, %BLACK, %RGB_GAINSBORO  '
   DLGAddCheck(ghWel, %INSTANCE_RTR, 0, 15, 119, 155, "Retrieve table entries are Unique")   '
   DLGToolTipSet(GetDlgItem(ghWel, %INSTANCE_RTR), " Select to maintain unique Retrieve table variables ")  '
   CONTROL SET COLOR   ghWel, %INSTANCE_RTR, %BLACK, %RGB_GAINSBORO  '
   DLGAddCheck(ghWel, %INSTANCE_KBD, 0, 15, 132, 155, "Keyboard table entries are Unique")   '
   DLGToolTipSet(GetDlgItem(ghWel, %INSTANCE_KBD), " Select to maintain unique Keyboard customization ") '
   CONTROL SET COLOR   ghWel, %INSTANCE_KBD, %BLACK, %RGB_GAINSBORO  '

   CONTROL ADD BUTTON,  ghWel, %DIALOG_CANCEL, "&Cancel", 150, 160, 40, 11, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER  '
   DLGToolTipSet(GetDlgItem(ghWel, %DIALOG_CANCEL), " Press Cancel to exit and start over. ")   '
   CONTROL ADD BUTTON,  ghWel, %DIALOG_DONE, "&Done", 200, 160, 40, 11, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER   '
   DLGToolTipSet(GetDlgItem(ghWel, %DIALOG_DONE), " Press Done once you have made your choices. ") '

   DIALOG SHOW MODAL ghWel CALL DlgiNSTANCECallback TO RC         ' Display it all
   FUNCTION = RC                                                  '
   MExit                                                          '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgDiffCallBack()                               '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by the DIFF Dialog                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, t, lh, rh AS STRING                              '
LOCAL Alb, Arb, Blb, Brb AS LONG                                  '
   SELECT CASE AS LONG CB.MSG                                     '
      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '

            '--------------------------------------------------------------------------------------+
            '- FIleA Choose button pressed                                                         |
            '--------------------------------------------------------------------------------------+
            CASE %DIFF_FileA_Choose                               '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Choose FileA
                  t = DoOpenFileDialog(ghDIFF)                    ' Go get a filename
                  IF t = "" THEN EXIT FUNCTION                    ' Null? Ignore this
                  gDiffFileA = t                                  '
                  COMBOBOX SET TEXT ghDIFF, %DIFF_FileA, 1, gDiffFileA  ' Stuff it in position 1
                  COMBOBOX SELECT ghDIFF, %DIFF_FileA, 1          ' Select it
               END IF                                             '

            CASE %DIFF_FileB_Choose                               '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Choose FileB
                  t = DoOpenFileDialog(ghDIFF)                    ' Go get a filename
                  IF t = "" THEN EXIT FUNCTION                    ' Null? Ignore this
                  gDiffFileB = t                                  '
                  COMBOBOX SET TEXT ghDIFF, %DIFF_FileB, 1, gDiffFileB  ' Stuff it in position 1
                  COMBOBOX SELECT ghDIFF, %DIFF_FileB, 1          ' Select it
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- DONE button pressed                                                                 |
            '--------------------------------------------------------------------------------------+
            CASE %DIFF_Done                                       '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Done button pressed
                  COMBOBOX GET TEXT ghDIFF, %DIFF_FileA TO gDiffFileA   ' Get the FileA name
                  IF ISNULL(TRIM$(gDiffFileA)) THEN               '
                     DoMessageBox("FileA cannot be null or blank.", %MB_OK OR %MB_USERICON, "SPFLite DIFF") '
                     EXIT FUNCTION                                '
                  END IF                                          '

                  COMBOBOX GET TEXT ghDIFF, %DIFF_FileB TO gDiffFileB   ' Get the FileB name
                  IF ISNULL(TRIM$(gDiffFileB)) THEN               '
                     DoMessageBox("FileB cannot be null or blank.", %MB_OK OR %MB_USERICON, "SPFLite DIFF") '
                     EXIT FUNCTION                                '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Validate LB/RB                                                                |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghDIFF, %DIFF_FileA_Bounds TO t   ' Get the FileA Bounds
                  t = UCASE$(SHRINK$(t))                          ' Crush blanks
                  lh = LEFT$(t, INSTR(t, ",") - 1)                ' Split it
                  rh = MID$(t, INSTR(t, ",") + 1)                 '
                  Alb = VAL(lh)                                   ' Get LB/RB values
                  IF rh = "MAX" THEN rh = "0"                     '
                  Arb = VAL(rh)                                   '
                  IF Alb < 1 OR Arb < 0 OR _                      '
                     (Arb <> 0 AND Arb <= Alb < 0) THEN           '
                     DoMessageBox("FileA Left/Right bounds are invalid.", %MB_OK OR %MB_USERICON, "SPFLite DIFF") '
                     EXIT FUNCTION                                '
                  END IF                                          '
                  CONTROL GET TEXT ghDIFF, %DIFF_FileB_Bounds TO t   ' Get the FileB Bounds
                  t = UCASE$(SHRINK$(t))                          ' Crush blanks
                  lh = LEFT$(t, INSTR(t, ",") - 1)                ' Split it
                  rh = MID$(t, INSTR(t, ",") + 1)                 '
                  Blb = VAL(lh)                                   ' Get LB/RB values
                  IF rh = "MAX" THEN rh = "0"                     '
                  Brb = VAL(rh)                                   '
                  IF Blb < 1 OR Brb < 0 OR _                      '
                     (Brb <> 0 AND Brb <= Blb < 0) THEN           '
                     DoMessageBox("FileB Left/Right bounds are invalid.", %MB_OK OR %MB_USERICON, "SPFLite DIFF") '
                     EXIT FUNCTION                                '
                  END IF                                          '

                  gENV.DiffALB = Alb                              '
                  gENV.DiffARB = Arb                              '
                  gENV.DiffBLB = Blb                              '
                  gENV.DiffBRB = Brb                              '

                  CONTROL GET CHECK ghDIFF, %DIFF_NoSpace TO i    ' Get the NoSpace value
                  gENV.DiffNoSpace = i                            '
                  CONTROL GET CHECK ghDIFF, %DIFF_NoTabs TO i     ' Get the NoTab value
                  gENV.DiffNoTab = i                              '
                  CONTROL GET CHECK ghDIFF, %DIFF_NoComment TO i  ' Get the NoComment value
                  gENV.DiffNoComment = i                          '
                  CONTROL GET CHECK ghDIFF, %DIFF_NoCASE TO i     ' Get the NoCASE value
                  gENV.DiffNoCASE = i                             '
                  CONTROL GET CHECK ghDIFF, %DIFF_NoMultB TO i    ' Get the NoMultB value
                  gENV.DiffNoMultB = i                            '
                  CONTROL GET CHECK ghDIFF, %DIFF_Only TO i       ' Get the DIFFONLY option
                  gENV.DiffOnly = i                               '
                  CONTROL GET CHECK ghDIFF, %DIFF_1Column TO i    ' Get the 1Column option
                  gENV.Diff1Column = i                            '
                  CONTROL GET CHECK ghDIFF, %DIFF_UseFileB TO i   ' Get the UseFileB option
                  gENV.DiffUseFileB = i                           '
                  CONTROL GET CHECK ghDIFF, %DIFF_FileA_NXNone TO i  ' Get the A-NXNone option
                  IF i THEN gENV.DiffANX = 0: gENV.DiffAX = 0     ' Turn NX and X off
                  CONTROL GET CHECK ghDIFF, %DIFF_FileA_NX TO i   ' Get the A-NX option
                  IF i THEN gENV.DiffANX = 1: gENV.DiffAX = 0     ' Turn NX ON and X OFF
                  CONTROL GET CHECK ghDIFF, %DIFF_FileA_X TO i    ' Get the A-X option
                  IF i THEN gENV.DiffANX = 0: gENV.DiffAX = 1     ' Turn NX OFF and X ON
                  CONTROL GET CHECK ghDIFF, %DIFF_FileB_NXNone TO i  ' Get the B-NXNone option
                  IF i THEN gENV.DiffBNX = 0: gENV.DiffBX = 0     ' Turn NX and X off
                  CONTROL GET CHECK ghDIFF, %DIFF_FileB_NX TO i   ' Get the B-NX option
                  IF i THEN gENV.DiffBNX = 1: gENV.DiffBX = 0     ' Turn NX ON and X OFF
                  CONTROL GET CHECK ghDIFF, %DIFF_FileB_X TO i    ' Get the B-X option
                  IF i THEN gENV.DiffBNX = 0: gENV.DiffBX = 1     ' Turn NX OFF and X ON

                  CONTROL GET TEXT ghDIFF, %DIFF_MinMatch TO t    '
                  IF VAL(t) < 1 OR VAL(t) > 50 THEN               '
                     DoMessageBox("MinMatch value is 0 or unreasonably high.", %MB_OK OR %MB_USERICON, "SPFLite DIFF")  '
                     EXIT FUNCTION                                '
                  END IF                                          '
                  gENV.DiffMinMatch = VAL(t)                      ' Save it
                  DIALOG END ghDIFF                               ' Shut things down
               END IF                                             '
            CASE %DIFF_Cancel                                     ' CANCEL
               DIALOG END ghDIFF                                  ' Shut things down
               gDiffFileA = ""                                    ' Null FileA to indicate CANCEL

         END SELECT                                               '
   END SELECT                                                     '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgInstanceCallBack()                           '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by the Instance Dialog                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, CFGName AS STRING                                '
   SELECT CASE AS LONG CB.MSG                                     '
      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '

            '--------------------------------------------------------------------------------------+
            '- DONE button pressed                                                                 |
            '--------------------------------------------------------------------------------------+
            CASE %DIALOG_DONE                                     '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Done button pressed
                  COMBOBOX GET TEXT ghWel, %INSTANCE_CFGList TO CFGName ' Get the CFG to be copied
                  gSQL.TableCopy("O" + CFGName, "O" + gENV.eInstance)   ' Create Instance Options table now
                  gSQL.OptName = gENV.eInstance                   ' Make it the default

                  CONTROL GET CHECK ghWel, %INSTANCE_EFT TO i     ' Get the EFT choice
                  IF i THEN                                       ' EFT unique requested
                     IF gSQL.TableExist("E" + CFGName) THEN       ' If old Instance has the table
                        gSQL.TableCopy("E" + CFGName, "E" + gENV.eInstance)   ' Copy it
                     ELSE                                         ' If not
                        gSQL.TableCopy("EDEFAULT", "E" + gENV.eInstance)   ' Copy the default
                     END IF                                       '
                     gSQL.EFTName = gENV.eInstance                ' Set the unique table name
                     gSQL.UpdateString("O", "HomeEFTName", gENV.eInstance) '
                  END IF                                          '
                  CONTROL GET CHECK ghWel, %INSTANCE_KBD TO i     ' Get the KBD choice
                  IF i THEN                                       ' KBD unique requested
                     IF gSQL.TableExist("K" + CFGName) THEN       ' If old Instance has the table
                        gSQL.TableCopy("K" + CFGName, "K" + gENV.eInstance)   ' Copy it
                     ELSE                                         ' If not
                        gSQL.TableCopy("KDEFAULT", "K" + gENV.eInstance)   ' Copy the default
                     END IF                                       '
                     gSQL.KbdName = gENV.eInstance                ' Set the unique table name
                     gSQL.UpdateString("O", "HomeKbdName", gENV.eInstance) '
                  END IF                                          '
                  CONTROL GET CHECK ghWel, %INSTANCE_RTR TO i     ' Get the RTR choice
                  IF i THEN                                       ' RTR unique requested
                     IF gSQL.TableExist("R" + CFGName) THEN       ' If old Instance has the table
                        gSQL.TableCopy("R" + CFGName, "R" + gENV.eInstance)   ' Copy it
                     ELSE                                         ' If not
                        gSQL.TableCopy("RDEFAULT", "R" + gENV.eInstance)   ' Copy the default
                     END IF                                       '
                     gSQL.RtrName = gENV.eInstance                ' Set the unique table name
                     gSQL.UpdateString("O", "HomeRtrName", gENV.eInstance) '
                  END IF                                          '
                  CONTROL GET CHECK ghWel, %INSTANCE_SET TO i     ' Get the SET choice
                  IF i THEN                                       ' SET unique requested
                     IF gSQL.TableExist("S" + CFGName) THEN       ' If old Instance has the table
                        gSQL.TableCopy("S" + CFGName, "S" + gENV.eInstance)   ' Copy it
                     ELSE                                         ' If not
                        gSQL.TableCopy("SDEFAULT", "S" + gENV.eInstance)   ' Copy the default
                     END IF                                       '
                     gSQL.SetName = gENV.eInstance                ' Set the unique table name
                     gSQL.UpdateString("O", "HomeSetName", gENV.eInstance) '
                  END IF                                          '
                  DIALOG END ghWel, 0                             ' Shut things down as OK
               END IF                                             '
            CASE %DIALOG_CANCEl                                   ' CANCEL
               DIALOG END ghWel, 8                                ' Shut things down as Fail

         END SELECT                                               '
   END SELECT                                                     '
END FUNCTION                                                      '

SUB DispKeyMap(MsgMode AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- Build and display the Keyboard Mapper                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, NormalText, ShiftText, ControlText, AltText, SCText, SAText, SCAText, CAText AS STRING  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Build the screen                                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG FONT DEFAULT "Tahoma", 11 / gFontScale, 0, 0            '
   DIALOG NEW PIXELS, ghWnd, "SPFLite KeyMap for: " + MID$(gSQL.KBDName, 2), , , 755, 538, %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR _   '
                            %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR _ '
                            %DS_SETFONT, %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO ghKey   '
   DIALOG SET COLOR ghKey, %RGB_GAINSBORO, %RGB_GAINSBORO         '

   '-----------------------------------------------------------------------------------------------+
   '- Add the bottom DONE and CANCEL buttons                                                       |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD BUTTON,  ghKey, %KEYMAP_DONE, "&Done", 600, 507, 75, 24, %WS_BORDER  '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_DONE), " Press Done once you have made all desired changes. ")   '

   CONTROL ADD BUTTON,  ghKey, %KEYMAP_CANCEL, "&Cancel", 500, 507, 75, 24, %WS_BORDER '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CANCEL), " Press Cancel to Discard all changes. ")   '

   '-----------------------------------------------------------------------------------------------+
   '- Add the graphic keyboard map. X/Y coordinates are stored in the Keyboard Master Table        |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO 107                                               ' Add the Key Images
      CONTROL ADD IMAGEX, ghKey, INT(5000 + i), TRIM$(gKbdT.KIcon(i)), gKbdT.X(i), gKbdT.Y(i), _   '
                          gKbdT.W(i) - 1, gKbdT.H(i) - 1, %SS_CENTERIMAGE OR %SS_NOTIFY   '
      CONTROL SET USER ghKey, INT(5000 + i), 1, i                 '

   NEXT i                                                         '
   CONTROL ADD LINE, ghKey, INT(5000 + i), "", 1, 215, 741, 3     '

   '-----------------------------------------------------------------------------------------------+
   '- Add some various text messages                                                               |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL, ghKey, %KEYMAP_CURRENT_TEXT, "Choose key", 3, 217, 250, 24 '
   CONTROL SET COLOR  ghKey, %KEYMAP_CURRENT_TEXT, %RGB_DARKRED, %RGB_GAINSBORO  '

   CONTROL ADD LABEL, ghKey, %KEYMAP_HINT_1, "Hints", 490, 220, 65, 16  '
   CONTROL SET FONT   ghKey, %KEYMAP_HINT_1, gFixedFont           '
   CONTROL SET COLOR  ghKey, %KEYMAP_HINT_1, %RGB_DARKGREEN, -2   '
   CONTROL ADD LABEL, ghKey, %KEYMAP_HINT_2, "Unenclosed - Primary Cmd", 490, 240, 275, 18   '
   CONTROL SET FONT   ghKey, %KEYMAP_HINT_2, gFixedFont           '
   CONTROL SET COLOR  ghKey, %KEYMAP_HINT_2, %RGB_DARKGREEN, -2   '
   CONTROL ADD LABEL, ghKey, %KEYMAP_HINT_3, "{Braces}   - Line Command", 490, 260, 275, 18  '
   CONTROL SET FONT   ghKey, %KEYMAP_HINT_3, gFixedFont           '
   CONTROL SET COLOR  ghKey, %KEYMAP_HINT_3, %RGB_DARKGREEN, -2   '
   CONTROL ADD LABEL, ghKey, %KEYMAP_HINT_4, "<Angles>   - PFSHOW Label", 490, 280, 275, 18  '
   CONTROL SET FONT   ghKey, %KEYMAP_HINT_4, gFixedFont           '
   CONTROL SET COLOR  ghKey, %KEYMAP_HINT_4, %RGB_DARKGREEN, -2   '
   CONTROL ADD LABEL, ghKey, %KEYMAP_HINT_5, "[Brackets] - Text String", 490, 300, 275, 18   '
   CONTROL SET FONT   ghKey, %KEYMAP_HINT_5, gFixedFont           '
   CONTROL SET COLOR  ghKey, %KEYMAP_HINT_5, %RGB_DARKGREEN, -2   '
   CONTROL ADD LABEL, ghKey, %KEYMAP_HINT_6, "(Parens)   - KB Primitive", 490, 320, 275, 18  '
   CONTROL SET FONT   ghKey, %KEYMAP_HINT_6, gFixedFont           '
   CONTROL SET COLOR  ghKey, %KEYMAP_HINT_6, %RGB_DARKGREEN, -2   '
   CONTROL ADD LABEL, ghKey, %KEYMAP_HINT_7, "Select hint below to place in Clipboard", 490, 340, 250, 36, %SS_CENTER   '
   CONTROL SET FONT   ghKey, %KEYMAP_HINT_7, gFixedFont           '
   CONTROL SET COLOR  ghKey, %KEYMAP_HINT_7, %RGB_DARKGREEN, -2   '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Primitive list and CharSet button                                                    |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD COMBOBOX, ghKey, %KEYMAP_PRIMITIVEHINT, gPrimTable(), 500, 385, 250, 160, %CBS_DROPDOWNLIST OR %WS_VSCROLL  '
   COMBOBOX SELECT    ghKey, %KEYMAP_PRIMITIVEHINT, 1             '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_PRIMITIVEHINT), " List of valid Keyboard Primitives. ") '

   CONTROL ADD BUTTON,  ghKey, %KEYMAP_ANSI, "Show Character map", 500, 423, 250, 24, %WS_BORDER   '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_ANSI), " Click to display a full character map popup. ")   '

   CONTROL ADD BUTTON,  ghKey, %KEYMAP_KEYRESET, "Reset selected key to default", 500, 455, 250, 24, %WS_BORDER   '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_ANSI), " Click to reset the selected key combination to the standard default. ")   '


   '-----------------------------------------------------------------------------------------------+
   '- Add the 8 boxes for the various key modes                                                    |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL, ghKey, %KEYMAP_NORMAL_TEXT, "Normal", 74, 252, 100, 18  '
   CONTROL SET COLOR  ghKey, %KEYMAP_NORMAL_TEXT, %BLACK, -2      '
   CONTROL DISABLE    ghKey, %KEYMAP_NORMAL_TEXT                  '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_NORMAL, NormalText, 220, 252, 260, 26  '
   CONTROL SET FONT   ghKey, %KEYMAP_NORMAL, gFixedFont           '
   CONTROL DISABLE    ghKey, %KEYMAP_NORMAL                       '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_NORMAL), " Enter the keyboard command string for the Normal Key Mode. ")  '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_NUP, " ", 195, 255, 16, 16, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET CHECK     ghKey, %KEYMAP_NUP, 0                    '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_NUP), " Should keyboard AutoRepeat be allowed for this key? ")   '
   CONTROL DISABLE ghKey, %KEYMAP_NUP                             '

   CONTROL ADD LABEL, ghKey, %KEYMAP_SHIFT_TEXT, "Shift", 74, 280, 100, 18 '
   CONTROL SET COLOR  ghKey, %KEYMAP_SHIFT_TEXT, %BLACK, -2       '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFT_TEXT                   '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_SHIFT, ShiftText, 220, 280, 260, 26 '
   CONTROL SET FONT   ghKey, %KEYMAP_SHIFT, gFixedFont            '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFT                        '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SHIFT), " Enter the keyboard command string for the Shifted Key Mode. ")  '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_SUP, " ", 195, 283, 16, 16, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET CHECK     ghKey, %KEYMAP_SUP, 0                    '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SUP), " Should keyboard AutoRepeat be allowed for this key? ")   '
   CONTROL DISABLE ghKey, %KEYMAP_SUP                             '

   CONTROL ADD LABEL, ghKey, %KEYMAP_CONTROL_TEXT, "Ctrl", 74, 308, 100, 18   '
   CONTROL SET COLOR  ghKey, %KEYMAP_CONTROL_TEXT, %BLACK, -2     '
   CONTROL DISABLE    ghKey, %KEYMAP_CONTROL_TEXT                 '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_CONTROL, ControlText, 220, 308, 260, 26   '
   CONTROL SET FONT   ghKey, %KEYMAP_CONTROL, gFixedFont          '
   CONTROL DISABLE    ghKey, %KEYMAP_CONTROL                      '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CONTROL), " Enter the keyboard command string for the Control Key Mode. ")   '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_CUP, " ", 195, 311, 16, 16, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET CHECK     ghKey, %KEYMAP_CUP, 0                    '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CUP), " Should keyboard AutoRepeat be allowed for this key? ")   '
   CONTROL DISABLE ghKey, %KEYMAP_CUP                             '

   CONTROL ADD LABEL, ghKey, %KEYMAP_ALT_TEXT, "Alt", 74, 336, 100, 18  '
   CONTROL SET COLOR  ghKey, %KEYMAP_ALT_TEXT, %BLACK, -2         '
   CONTROL DISABLE    ghKey, %KEYMAP_ALT_TEXT                     '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_ALT, AltText, 220, 336, 260, 26  '
   CONTROL SET FONT   ghKey, %KEYMAP_ALT, gFixedFont              '
   CONTROL DISABLE    ghKey, %KEYMAP_ALT                          '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_ALT), " Enter the keyboard command string for the Alt Key Mode. ")  '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_AUP, " ", 195, 339, 16, 16, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET CHECK     ghKey, %KEYMAP_AUP, 0                    '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_AUP), " Should keyboard AutoRepeat be allowed for this key? ")   '
   CONTROL DISABLE ghKey, %KEYMAP_AUP                             '

   CONTROL ADD LABEL, ghKey, %KEYMAP_SHIFTCONTROL_TEXT, "Shift-Ctrl", 74, 364, 100, 18 '
   CONTROL SET COLOR  ghKey, %KEYMAP_SHIFTCONTROL_TEXT, %BLACK, -2   '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFTCONTROL_TEXT            '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_SHIFTCONTROL, SCText, 220, 364, 260, 26   '
   CONTROL SET FONT   ghKey, %KEYMAP_SHIFTCONTROL, gFixedFont     '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFTCONTROL                 '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SHIFTCONTROL), " Enter the keyboard command string for the Shift-Control Key Mode. ") '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_SCUP, " ", 195, 370, 16, 16, %BS_LEFT OR %BS_VCENTER '
   CONTROL SET CHECK     ghKey, %KEYMAP_SCUP, 0                   '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SCUP), " Should keyboard AutoRepeat be allowed for this key? ")  '
   CONTROL DISABLE ghKey, %KEYMAP_SCUP                            '

   CONTROL ADD LABEL, ghKey, %KEYMAP_SHIFTALT_TEXT, "Shift-Alt", 74, 392, 100, 18   '
   CONTROL SET COLOR  ghKey, %KEYMAP_SHIFTALT_TEXT, %BLACK, -2    '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFTALT_TEXT                '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_SHIFTALT, SAText, 220, 392, 260, 26 '
   CONTROL SET FONT   ghKey, %KEYMAP_SHIFTALT, gFixedFont         '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFTALT                     '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SHIFTALT), " Enter the keyboard command string for the Shift-Alt Key Mode. ")   '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_SAUP, " ", 195, 395, 16, 16, %BS_LEFT OR %BS_VCENTER '
   CONTROL SET CHECK     ghKey, %KEYMAP_SAUP, 0                   '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SAUP), " Should keyboard AutoRepeat be allowed for this key? ")  '
   CONTROL DISABLE ghKey, %KEYMAP_SAUP                            '

   CONTROL ADD LABEL, ghKey, %KEYMAP_SHIFTCONTALT_TEXT, "Shift-Ctrl-Alt", 74, 420, 100, 18   '
   CONTROL SET COLOR  ghKey, %KEYMAP_SHIFTCONTALT_TEXT, %BLACK, -2   '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFTCONTALT_TEXT            '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_SHIFTCONTALT, SCAText, 220, 420, 260, 26  '
   CONTROL SET FONT   ghKey, %KEYMAP_SHIFTCONTALT, gFixedFont     '
   CONTROL DISABLE    ghKey, %KEYMAP_SHIFTCONTALT                 '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SHIFTCONTALT), " Enter the keyboard command string for the Shift-Control-Alt Key Mode. ")   '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_SCAUP, " ", 195, 423, 16, 16, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET CHECK     ghKey, %KEYMAP_SCAUP, 0                  '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SCAUP), " Should keyboard AutoRepeat be allowed for this key? ") '
   CONTROL DISABLE ghKey, %KEYMAP_SCAUP                           '

   CONTROL ADD LABEL, ghKey, %KEYMAP_CONTROLALT_TEXT, "Ctrl-Alt", 74, 448, 100, 18  '
   CONTROL SET COLOR  ghKey, %KEYMAP_CONTROLALT_TEXT, %BLACK, -2  '
   CONTROL DISABLE    ghKey, %KEYMAP_CONTROLALT_TEXT              '
   CONTROL ADD TEXTBOX, ghKey, %KEYMAP_CONTROLALT, CAText, 220, 448, 260, 26  '
   CONTROL SET FONT   ghKey, %KEYMAP_CONTROLALT, gFixedFont       '
   CONTROL DISABLE    ghKey, %KEYMAP_CONTROLALT                   '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CONTROLALT), " Enter the keyboard command string for the Control-Alt Key Mode. ")  '
   CONTROL ADD CHECKBOX, ghKey, %KEYMAP_CAUP, " ", 195, 451, 16, 16, %BS_LEFT OR %BS_VCENTER '
   CONTROL SET CHECK     ghKey, %KEYMAP_CAUP, 0                   '
   DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CAUP), " Should keyboard AutoRepeat be allowed for this key? ")  '
   CONTROL DISABLE ghKey, %KEYMAP_CAUP                            '

   CONTROL ADD LABEL, ghKey, %KEYMAP_REPEAT_TEXT, "v- Allow key combination to repeat?",197, 228, 290, 22   '
   CONTROL SET COLOR  ghKey, %KEYMAP_REPEAT_TEXT, %BLACK, %RGB_GAINSBORO   '

   '-----------------------------------------------------------------------------------------------+
   '- DISPLAY the KeyMap DIALOG BOX                                                                |
   '-----------------------------------------------------------------------------------------------+
   GRAPHIC REDRAW                                                 '

   KbdPopSave                                                     ' Ready for pop-up
   DIALOG SHOW MODAL ghKey, CALL DlgKeyMapCallBack                '
   KbdPopRestore                                                  ' Reset popup state
   IF ghANSI THEN  DIALOG END ghANSI, 0                           ' Now shut the ANSI dialog if used
   MExit                                                          '
END SUB                                                           '

CALLBACK FUNCTION DlgKeyMapCallBack()                             '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by the KeyMap Dialog                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, Repeat AS LONG, t, tpf, u, kfield, MSG, sname, IconName AS STRING '
LOCAL BrkCount, SqgCount AS LONG                                  '
STATIC lastID, lclmap, lclMapP, lclBox AS LONG                    '

   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- KEYMAP is starting up                                                                     |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_INITDIALOG                                         '
         RESET lclMap, lclMapP, lastID, lclBox                    ' Kill Previous pointers

      '--------------------------------------------------------------------------------------------+
      '- Handle the various interactions                                                           |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_COMMAND                                            '
         IF CB.CTLMSG = %EN_SETFOCUS THEN                         ' Save who has the last focus
            IF INT(CB.CTL) >= %KEYMAP_NORMAL AND _                '
               INT(CB.CTL) <= %KEYMAP_CONTROLALT THEN             '
               lclBox = INT(CB.CTL)                               '
            ELSE                                                  ' Not one we care about
               lclBox = 0                                         ' No text box focus
            END IF                                                '
         END IF                                                   '

         SELECT CASE AS LONG CB.CTL                               '

            '--------------------------------------------------------------------------------------+
            '- CANCEL button pressed                                                               |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_CANCEL                                   '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Cancel?
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghKey                                ' Shut things down
                  gKbdT.LoadKBTable                               ' Reload Normal Keyboard stuff
                  gKbdT.LoadKBFinal                               ' Finalize it
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- ANSI button, bring up the ANSI dialog                                               |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_ANSI                                     '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Equiv CB.CTLMSG - Done button pressed
                  TP.DispANSI (%False)                            ' Pop up the ANSI table in non-column mode
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Reset Key button, process it                                                        |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_KEYRESET                                 '
               IF lclBox = 0 THEN                                 ' Must have a key selected
                  DoMessageBox "There is no curently selected key combination.", _  '
                               %MB_OK OR %MB_USERICON, "SPFLite KeyMap" ' Issue a msg
                  EXIT FUNCTION                                   '
               END IF                                             '
               SELECT CASE lclBox                                 ' Split by which box
                  CASE %KEYMAP_NORMAL                             ' N
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_NORMAL, t, u)   ' Fetch Master KeyTable entry values
                     gKbdT.SetNData(lclMap, t)                    ' Update them
                     gKbdT.SetNup(lclMap, u)                      '
                     CONTROL SET TEXT ghKey, %KEYMAP_NORMAL, t    ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_NUP, IIF(u = ".", 1, 0) '

                  CASE %KEYMAP_SHIFT                              ' S
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_SHIFT, t, u) ' Fetch Master KeyTable entry values
                     gKbdT.SetSData(lclMap, t)                    ' Update them
                     gKbdT.SetSUp(lclMap, u)                      '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFT, t     ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_SUP, IIF(u = ".", 1, 0) '

                  CASE %KEYMAP_CONTROL                            ' C
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_CONTROL, t, u)  ' Fetch Master KeyTable entry values
                     gKbdT.SetCData(lclMap, t)                    ' Update them
                     gKbdT.SetCUp(lclMap, u)                      '
                     CONTROL SET TEXT ghKey, %KEYMAP_CONTROL, t   ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_CUP, IIF(u = ".", 1, 0) '

                  CASE %KEYMAP_ALT                                ' A
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_ALT, t, u)   ' Fetch Master KeyTable entry values
                     gKbdT.SetAData(lclMap, t)                    ' Update them
                     gKbdT.SetAUp(lclMap, u)                      '
                     CONTROL SET TEXT ghKey, %KEYMAP_ALT, t       ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_AUP, IIF(u = ".", 1, 0) '

                  CASE %KEYMAP_SHIFTCONTROL                       ' SC
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_SHIFTCONTROL, t, u)   ' Fetch Master KeyTable entry values
                     gKbdT.SetSCData(lclMap, t)                   ' Update them
                     gKbdT.SetSCUp(lclMap, u)                     '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTROL, t ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_SCUP, IIF(u = ".", 1, 0)   '

                  CASE %KEYMAP_SHIFTALT                           ' SA
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_SHIFTALT, t, u) ' Fetch Master KeyTable entry values
                     gKbdT.SetSAData(lclMap, t)                   ' Update them
                     gKbdT.SetSAUp(lclMap, u)                     '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTALT, t  ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_SAUP, IIF(u = ".", 1, 0)   '

                  CASE %KEYMAP_SHIFTCONTALT                       ' SCA
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_SHIFTCONTALT, t, u)   ' Fetch Master KeyTable entry values
                     gKbdT.SetSCAData(lclMap, t)                  ' Update them
                     gKbdT.SetSCAUp(lclMap, u)                    '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTALT, t ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_SCAUP, IIF(u = ".", 1, 0)  '

                  CASE %KEYMAP_CONTROLALT                         ' CA
                     gKbdT.KBGetMastKey(lclMap, %KEYMAP_CONTROLALT, t, u)  ' Fetch Master KeyTable entry values
                     gKbdT.SetCAData(lclMap, t)                   ' Update them
                     gKbdT.SetCAUp(lclMap, u)                     '
                     CONTROL SET TEXT ghKey, %KEYMAP_CONTROLALT, t   ' Re-display them
                     CONTROL SET CHECK ghKey, %KEYMAP_CAUP, IIF(u = ".", 1, 0)   '

               END SELECT                                         '

            '--------------------------------------------------------------------------------------+
            '- DONE buton, lots of work now                                                        |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_DONE                                     '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Done button pressed

                  '--------------------------------------------------------------------------------+
                  '- If a key currently displayed update the Repeat flags                          |
                  '--------------------------------------------------------------------------------+
                  IF lclMap <> 0 THEN                             ' If a previous key being displayed
                     CONTROL GET CHECK ghKey, %KEYMAP_NUP TO Repeat  ' Copy the previous key's Repeat key data
                     gKbdT.SetNUp(lclMap, IIF$(Repeat, ".", "U")) '
                     CONTROL GET CHECK ghKey, %KEYMAP_SUP TO Repeat  '
                     gKbdT.SetSUp(lclMap, IIF$(Repeat, ".", "U")) '
                     CONTROL GET CHECK ghKey, %KEYMAP_CUP TO Repeat  '
                     gKbdT.SetCUp(lclMap, IIF$(Repeat, ".", "U")) '
                     CONTROL GET CHECK ghKey, %KEYMAP_AUP TO Repeat  '
                     gKbdT.SetAUp(lclMap, IIF$(Repeat, ".", "U")) '
                     CONTROL GET CHECK ghKey, %KEYMAP_SCUP TO Repeat '
                     gKbdT.SetSCUp(lclMap, IIF$(Repeat, ".", "U"))   '
                     CONTROL GET CHECK ghKey, %KEYMAP_SAUP TO Repeat '
                     gKbdT.SetSAUp(lclMap, IIF$(Repeat, ".", "U"))   '
                     CONTROL GET CHECK ghKey, %KEYMAP_SCAUP TO Repeat   '
                     gKbdT.SetSCAUp(lclMap, IIF$(Repeat, ".", "U"))  '
                     CONTROL GET CHECK ghKey, %KEYMAP_CAUP TO Repeat '
                     gKbdT.SetCAUp(lclMap, IIF$(Repeat, ".", "U"))   '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Validate we have an (ENTER) key defined                                       |
                  '--------------------------------------------------------------------------------+
                  j = 0                                           ' Clear J
                  FOR i = 1 TO 104                                ' Search the Table
                     IF UUCASE(gKbdT.NData(i)) = "(ENTER)" THEN J += 1  ' Look for an Enter key
                     IF UUCASE(gKbdT.SData(i)) = "(ENTER)" THEN J += 1  '
                     IF UUCASE(gKbdT.CData(i)) = "(ENTER)" THEN J += 1  '
                     IF UUCASE(gKbdT.AData(i)) = "(ENTER)" THEN J += 1  '
                     IF UUCASE(gKbdT.SCData(i)) = "(ENTER)" THEN J += 1 '
                     IF UUCASE(gKbdT.SAData(i)) = "(ENTER)" THEN J += 1 '
                     IF UUCASE(gKbdT.SCAData(i)) = "(ENTER)" THEN J += 1   '
                     IF UUCASE(gKbdT.CAData(i)) = "(ENTER)" THEN J += 1 '
                  NEXT i                                          '
                  IF j = 0 THEN                                   ' No Enter key found?
                     DoMessageBox "You have no key defined as |K(Enter)|B, please assign one.", _  '
                                  %MB_OK OR %MB_USERICON, "SPFLite KeyMap" ' Issue a msg
                     EXIT FUNCTION                                '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Kill the dialog and save the new data                                         |
                  '--------------------------------------------------------------------------------+
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghKey                                ' Shut things down
                  gKbdT.WriteKBUser                               ' Save things
                  gKbdT.LoadKBFinal                               ' Finalize it
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the NORMAL key area                                                        |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_NORMAL                                   ' Normal data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Losing focus?
                  GOSUB ValNormal                                 ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_NORMAL, %EM_SETSEL, 0, 0  '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the SHIFT key area                                                         |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_SHIFT                                    ' Shift data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Data changed?
                  GOSUB ValShift                                  ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_SHIFT, %EM_SETSEL, 0, 0   '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the CONTROL key area                                                       |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_CONTROL                                  ' Control data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Data changed?
                  GOSUB ValControl                                ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_CONTROL, %EM_SETSEL, 0, 0 '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the ALT key area                                                           |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_ALT                                      ' Normal data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Data changed?
                  GOSUB ValAlt                                    ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_ALT, %EM_SETSEL, 0, 0  '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the SHIFT CONTOL key area                                                  |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_SHIFTCONTROL                             ' Shift-Control Data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Losing focus?
                  GOSUB ValShiftControl                           ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_SHIFTCONTROL, %EM_SETSEL, 0, 0  '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the SHIFT ALT key area                                                     |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_SHIFTALT                                 ' Shift-Alt data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Data changed?
                  GOSUB ValShiftAlt                               ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_SHIFTALT, %EM_SETSEL, 0, 0   '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the SHIFT CONTROL ALT key area                                             |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_SHIFTCONTALT                             ' Shift-Control-Alt data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Data changed?
                  GOSUB ValShiftCtlAlt                            ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_SHIFTCONTALT, %EM_SETSEL, 0, 0  '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- We're in the CONTROL ALT key area                                                   |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_CONTROLALT                               ' Control-Alt data area?
               IF CB.CTLMSG = %EN_KILLFOCUS THEN                  ' Data changed?
                  GOSUB ValControlAlt                             ' Go process the key
               END IF                                             '
               IF CB.CTLMSG = %EN_SETFOCUS THEN                   '
                  CONTROL SEND ghKey, %KEYMAP_CONTROLALT, %EM_SETSEL, 0, 0 '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- One of the Key Icons was pressed                                                    |
            '--------------------------------------------------------------------------------------+
            CASE > 5000                                           ' A keyboard key?
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Button pressed

                  '--------------------------------------------------------------------------------+
                  '- If a previous key being displayed, validate it                                |
                  '--------------------------------------------------------------------------------+
                  IF lclMap <> 0 THEN                             ' Was a key displayed?
                     GOSUB ValNormal                              ' Process key data
                     GOSUB ValShift                               '
                     GOSUB ValControl                             '
                     GOSUB ValAlt                                 '
                     GOSUB ValShiftControl                        '
                     GOSUB ValShiftAlt                            '
                     GOSUB ValShiftCtlAlt                         '
                     GOSUB ValControlAlt                          '

                     CONTROL GET CHECK ghKey, %KEYMAP_NUP TO Repeat  ' Copy the previous key's Repeat key data
                     gKbdT.SetNUp(lclMap, IIF$(Repeat, ".", "U")) ' Stuff back in Allow area

                     CONTROL GET CHECK ghKey, %KEYMAP_SUP TO Repeat  '
                     gKbdT.SetSUp(lclMap, IIF$(Repeat, ".", "U")) '

                     CONTROL GET CHECK ghKey, %KEYMAP_CUP TO Repeat  '
                     gKbdT.SetCUp(lclMap, IIF$(Repeat, ".", "U")) '

                     CONTROL GET CHECK ghKey, %KEYMAP_AUP TO Repeat  '
                     gKbdT.SetAUp(lclMap, IIF$(Repeat, ".", "U")) '

                     CONTROL GET CHECK ghKey, %KEYMAP_SCUP TO Repeat '
                     gKbdT.SetSCUp(lclMap, IIF$(Repeat, ".", "U"))   '

                     CONTROL GET CHECK ghKey, %KEYMAP_SAUP TO Repeat '
                     gKbdT.SetSAUp(lclMap, IIF$(Repeat, ".", "U"))   '

                     CONTROL GET CHECK ghKey, %KEYMAP_SCAUP TO Repeat   '
                     gKbdT.SetSCAUp(lclMap, IIF$(Repeat, ".", "U"))  '

                     CONTROL GET CHECK ghKey, %KEYMAP_CAUP TO Repeat '
                     gKbdT.SetCAUp(lclMap, IIF$(Repeat, ".", "U"))   '

                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- See if the key is even mappable                                               |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET USER ghKey, CB.CTL, 1 TO lclMap     ' Get pointer to KeyMaster area
                  IF gKbdT.ForceUp(lclMap) = "D" THEN             ' Disallowed key?
                     DoMessageBox "The |K" + gKbdT.Labl(lclMap) + "|B key is not mappable", _   '
                                  %MB_OK OR %MB_USERICON, "SPFLite KeyMap" '
                     EXIT FUNCTION                                '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Alter the ICON if needed                                                      |
                  '--------------------------------------------------------------------------------+
                  IF lclMapP <> 0 AND lclMapP <> lclMap THEN      ' Switching keys?
                     IconName = gKbdT.kIcon(lclMapP)              ' Restore the normal Icon
                     CONTROL SET IMAGEX ghKey, lastID, IconName   ' Set the Selected Icon image
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Get the key's data displayed                                                  |
                  '--------------------------------------------------------------------------------+
                  lclMapP = lclMap                                ' Save as previous
                  lastID = CB.CTL                                 '
                  IconName = "S" + FORMAT$(gKbdT.W(lclMapP)) + FORMAT$(gKbdT.H(lclMapP))  ' Build the name of the Blob Icon
                  CONTROL SET IMAGEX ghKey, lastID, IconName      ' Set the Selected Icon image
                  CONTROL SET TEXT ghKey, %KEYMAP_CURRENT_TEXT, "Current Key: " + gKbdT.Labl(lclMapP) ' Set in Dialog
                  CONTROL SET COLOR ghKey, %KEYMAP_CURRENT_TEXT, %BLACK, %RGB_GAINSBORO   '
                  CONTROL KILL ghKey, %KEYMAP_CURRENT_ICON        ' Kill Previous
                  t = gKbdT.KIcon(lclMap)                         '
'-                 if rnd(1,3) = 1 then
'-                      CONTROL ADD LINE, ghKey, -1, "", 4, 247, _
'-                          gKbdT.W(lclmap) + 3, gKbdT.H(lclmap) + 3, %SS_BLACKRECT
'-                      CONTROL ADD IMAGEX, ghKey,%KEYMAP_CURRENT_ICON, gKbdT.KIcon(lclMap), 6, 249, _
'-                               gKbdT.W(lclMap), gKbdT.H(lclMap), %SS_ICON OR %SS_CENTERIMAGE OR %SS_NOTIFY
'-                 else
'-                      CONTROL ADD LINE, ghKey, -1, "", 4, 247, _
'-                          gKbdT.W(lclmap) + 3, gKbdT.H(lclmap) + 3
                       CONTROL ADD IMAGEX, ghKey,%KEYMAP_CURRENT_ICON, gKbdT.KIcon(lclMap), 6, 249, _ '
                                gKbdT.W(lclMap), gKbdT.H(lclMap), %SS_ICON OR %SS_CENTERIMAGE OR %SS_NOTIFY '
'-                 end if
                  sname = gKbdT.Labl(lclMapP)                     ' Save trimmed key label
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SCAUP), " Should keyboard AutoRepeat be allowed for this key? ") '
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SAUP), " Should keyboard AutoRepeat be allowed for this key? ")  '
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CAUP), " Should keyboard AutoRepeat be allowed for this key? ")  '
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SCUP), " Should keyboard AutoRepeat be allowed for this key? ")  '
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SUP), " Should keyboard AutoRepeat be allowed for this key? ")   '
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CUP), " Should keyboard AutoRepeat be allowed for this key? ")   '
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_AUP), " Should keyboard AutoRepeat be allowed for this key? ")   '
                  DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_NUP),  " Should keyboard AutoRepeat be allowed for this key? ")  '
                  CONTROL SET TEXT ghKey, %KEYMAP_REPEAT_TEXT, "v- Allow key combination to repeat?"  '
                  IF sname = "LMB" OR sname = "MMB" OR sname = "RMB" THEN  '
                     CONTROL SET TEXT ghKey, %KEYMAP_REPEAT_TEXT, "v- Position Cursor on mouse click?"   '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SCAUP), " Should cursor be set when the mouse button is clicked? ") '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SAUP), " Should cursor be set when the mouse button is clicked? ")  '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CAUP), " Should cursor be set when the mouse button is clicked? ")  '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SCUP), " Should cursor be set when the mouse button is clicked? ")  '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_SUP), " Should cursor be set when the mouse button is clicked? ")   '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_CUP), " Should cursor be set when the mouse button is clicked? ")   '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_AUP), " Should cursor be set when the mouse button is clicked? ")   '
                     DLGToolTipSet(GetDlgItem(ghKey, %KEYMAP_NUP), " Should cursor be set when the mouse button is clicked? ")   '
                  END IF                                          '


                  IF gKbdT.NAllow(lclMap) = "N" THEN              ' Open up the Normal key input?
                     CONTROL ENABLE ghKey, %KEYMAP_NORMAL_TEXT    '
                     CONTROL ENABLE ghKey, %KEYMAP_NORMAL         '
                     CONTROL ENABLE ghKey, %KEYMAP_NUP            '
                     CONTROL SET CHECK ghKey, %KEYMAP_NUP, IIF(gKbdT.NUp(lclMap) = ".", 1, 0)   '
                     CONTROL SET TEXT ghKey, %KEYMAP_NORMAL, gKbdT.NData(lclMap) '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_NORMAL_TEXT   '
                     CONTROL DISABLE ghKey, %KEYMAP_NORMAL        '
                     CONTROL SET CHECK ghKey, %KEYMAP_NUP, 0      '
                     CONTROL DISABLE ghKey, %KEYMAP_NUP           '
                     CONTROL SET TEXT ghKey, %KEYMAP_NORMAL, ""   '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_NUP           '
                     CONTROL SET CHECK ghKey, %KEYMAP_NUP, 0      '
                  END IF                                          '

                  IF gKbdT.SAllow(lclMap) = "S" THEN              ' Open up the Shift key input?
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFT_TEXT     '
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFT          '
                     CONTROL ENABLE ghKey, %KEYMAP_SUP            '
                     CONTROL SET CHECK ghKey, %KEYMAP_SUP, IIF(gKbdT.SUp(lclMap) = ".", 1, 0)   '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFT, gKbdT.SData(lclMap)  '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFT_TEXT    '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFT         '
                     CONTROL SET CHECK ghKey, %KEYMAP_SUP, 0      '
                     CONTROL DISABLE ghKey, %KEYMAP_SUP           '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFT, ""    '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_SUP           '
                     CONTROL SET CHECK ghKey, %KEYMAP_SUP, 0      '
                  END IF                                          '

                  IF gKbdT.CAllow(lclMap) = "C" THEN              ' Open up the Control key input?
                     CONTROL ENABLE ghKey, %KEYMAP_CONTROL_TEXT   '
                     CONTROL ENABLE ghKey, %KEYMAP_CONTROL        '
                     CONTROL ENABLE ghKey, %KEYMAP_CUP            '
                     CONTROL SET CHECK ghKey, %KEYMAP_CUP, IIF(gKbdT.CUp(lclMap) = ".", 1, 0)   '
                     CONTROL SET TEXT ghKey, %KEYMAP_CONTROL, gKbdT.CData(lclMap)   '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_CONTROL_TEXT  '
                     CONTROL DISABLE ghKey, %KEYMAP_CONTROL       '
                     CONTROL SET CHECK ghKey, %KEYMAP_CUP, 0      '
                     CONTROL DISABLE ghKey, %KEYMAP_CUP           '
                     CONTROL SET TEXT ghKey, %KEYMAP_CONTROL, ""  '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_CUP           '
                     CONTROL SET CHECK ghKey, %KEYMAP_CUP, 0      '
                  END IF                                          '

                  IF gKbdT.AAllow(lclMap) = "A" THEN              ' Open up the Alt key input?
                     CONTROL ENABLE ghKey, %KEYMAP_ALT_TEXT       '
                     CONTROL ENABLE ghKey, %KEYMAP_ALT            '
                     CONTROL ENABLE ghKey, %KEYMAP_AUP            '
                     CONTROL SET CHECK ghKey, %KEYMAP_AUP, IIF(gKbdT.AUp(lclMap) = ".", 1, 0)   '
                     CONTROL SET TEXT ghKey, %KEYMAP_ALT, gKbdT.AData(lclMap) '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_ALT_TEXT      '
                     CONTROL DISABLE ghKey, %KEYMAP_ALT           '
                     CONTROL SET CHECK ghKey, %KEYMAP_AUP, 0      '
                     CONTROL DISABLE ghKey, %KEYMAP_AUP           '
                     CONTROL SET TEXT ghKey, %KEYMAP_ALT, ""      '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_AUP           '
                     CONTROL SET CHECK ghKey, %KEYMAP_AUP, 0      '
                  END IF                                          '

                  IF gKbdT.SAllow(lclMap) = "S" AND gKbdT.CAllow(lclMap) = "C" THEN ' Open up the Shift-Control?
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFTCONTROL_TEXT '
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFTCONTROL   '
                     CONTROL ENABLE ghKey, %KEYMAP_SCUP           '
                     CONTROL SET CHECK ghKey, %KEYMAP_SCUP, IIF(gKbdT.SCUp(lclMap) = ".", 1, 0) '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTROL, gKbdT.SCData(lclMap)   '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFTCONTROL_TEXT   '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFTCONTROL  '
                     CONTROL SET CHECK ghKey, %KEYMAP_SCUP, 0     '
                     CONTROL DISABLE ghKey, %KEYMAP_SCUP          '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTROL, ""   '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_SCUP          '
                     CONTROL SET CHECK ghKey, %KEYMAP_SCUP, 0     '
                  END IF                                          '

                  IF gKbdT.SAllow(lclMap) = "S" AND gKbdT.AAllow(lclMap) = "A" THEN ' Open up the Shift-Alt?
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFTALT_TEXT  '
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFTALT       '
                     CONTROL ENABLE ghKey, %KEYMAP_SAUP           '
                     CONTROL SET CHECK ghKey, %KEYMAP_SAUP, IIF(gKbdT.SAUp(lclMap) = ".", 1, 0) '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTALT, gKbdT.SAData(lclMap) '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFTALT_TEXT '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFTALT      '
                     CONTROL SET CHECK ghKey, %KEYMAP_SAUP, 0     '
                     CONTROL DISABLE ghKey, %KEYMAP_SAUP          '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTALT, "" '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_SAUP          '
                     CONTROL SET CHECK ghKey, %KEYMAP_SAUP, 0     '
                  END IF                                          '

                  IF gKbdT.SAllow(lclMap) = "S" AND gKbdT.CAllow(lclMap) = "C" AND gKbdT.AAllow(lclMap) = "A" THEN   ' Open up the Shift-Control-Alt?
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFTCONTALT_TEXT '
                     CONTROL ENABLE ghKey, %KEYMAP_SHIFTCONTALT   '
                     CONTROL ENABLE ghKey, %KEYMAP_SCAUP          '
                     CONTROL SET CHECK ghKey, %KEYMAP_SCAUP, IIF(gKbdT.SCAUp(lclMap) = ".", 1, 0)  '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTALT, gKbdT.SCAData(lclMap)  '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFTCONTALT_TEXT   '
                     CONTROL DISABLE ghKey, %KEYMAP_SHIFTCONTALT  '
                     CONTROL SET CHECK ghKey, %KEYMAP_SCAUP, 0    '
                     CONTROL DISABLE ghKey, %KEYMAP_SCAUP         '
                     CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTALT, ""   '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_SCAUP         '
                     CONTROL SET CHECK ghKey, %KEYMAP_SCAUP, 0    '
                  END IF                                          '

                  IF gKbdT.CAllow(lclMap) = "C" AND gKbdT.AAllow(lclMap) = "A" THEN ' Open up the Control-Alt?
                     CONTROL ENABLE ghKey, %KEYMAP_CONTROLALT_TEXT   '
                     CONTROL ENABLE ghKey, %KEYMAP_CONTROLALT     '
                     CONTROL ENABLE ghKey, %KEYMAP_CAUP           '
                     CONTROL SET CHECK ghKey, %KEYMAP_CAUP, IIF(gKbdT.CAUp(lclMap) = ".", 1, 0) '
                     CONTROL SET TEXT ghKey, %KEYMAP_CONTROLALT, gKbdT.CAData(lclMap)  '
                  ELSE                                            '
                     CONTROL DISABLE ghKey, %KEYMAP_CONTROLALT_TEXT  '
                     CONTROL DISABLE ghKey, %KEYMAP_CONTROLALT    '
                     CONTROL SET CHECK ghKey, %KEYMAP_CAUP, 0     '
                     CONTROL DISABLE ghKey, %KEYMAP_CAUP          '
                     CONTROL SET TEXT ghKey, %KEYMAP_CONTROLALT, ""  '
                  END IF                                          '
                  IF gKbdT.ForceUp(lclMap) = "U" THEN             ' Forced Upkey mode?
                     CONTROL DISABLE ghKey, %KEYMAP_CAUP          '
                     CONTROL SET CHECK ghKey, %KEYMAP_CAUP, 0     '
                  END IF                                          '

               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Show the Primitive keys hint list                                                   |
            '--------------------------------------------------------------------------------------+
            CASE %KEYMAP_PRIMITIVEHINT                            ' Keymap Primitive hint list
               IF CB.CTLMSG = %CBN_SELENDOK THEN                  ' Item Selected
                  COMBOBOX GET SELECT ghKey, %KEYMAP_PRIMITIVEHINT TO i ' Get the selected Index
                  IF i > 1 THEN                                   ' Ignore the heading
                     t = gPrimTable(i - 1)                        '
                     ClipBoardSet(t)                              ' Stuff it into clipboard
                  END IF                                          '
               END IF                                             '


         END SELECT                                               '
   END SELECT                                                     '
   EXIT FUNCTION                                                  '

'--------------------------------------------------------------------------------------------------+
'- Validate a key's entry                                                                          |
'--------------------------------------------------------------------------------------------------+
ValNormal:                                                        '
   CONTROL GET TEXT ghKey, %KEYMAP_NORMAL TO t                    ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Passthru)", TRIM$(t))             '
   kfield = "Normal mode key"                                     '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetNData(lclMap, t)                                      ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_NORMAL, t                      ' Re-display it
   RETURN                                                         '

ValShift:                                                         '
   CONTROL GET TEXT ghKey, %KEYMAP_SHIFT TO t                     ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Passthru)", TRIM$(t))             '
   kfield = "Shift mode key"                                      '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetSData(lclMap, t)                                      ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_SHIFT, t                       ' Re-display it
   RETURN                                                         '

ValControl:                                                       '
   CONTROL GET TEXT ghKey, %KEYMAP_CONTROL TO t                   ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Null)", TRIM$(t))                 '
   kfield = "Control mode key"                                    '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetCData(lclMap, t)                                      ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_CONTROL, t                     ' Re-display it
   RETURN                                                         '

ValAlt:                                                           '
   CONTROL GET TEXT ghKey, %KEYMAP_ALT TO t                       ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Null)", TRIM$(t))                 '
   kfield = "Alt mode key"                                        '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetAData(lclMap, t)                                      ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_ALT, t                         ' Re-display it
   RETURN                                                         '

ValShiftControl:                                                  '
   CONTROL GET TEXT ghKey, %KEYMAP_SHIFTCONTROL TO t              ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Null)", TRIM$(t))                 '
   kfield = "Shift-Control mode key"                              '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetSCData(lclMap, t)                                     ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTROL, t                ' Re-display it
   RETURN                                                         '

ValShiftAlt:                                                      '
   CONTROL GET TEXT ghKey, %KEYMAP_SHIFTALT TO t                  ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Null)", TRIM$(t))                 '
   kfield = "Shift-Alt mode key"                                  '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetSAData(lclMap, t)                                     ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_SHIFTALT, t                    ' Re-display it
   RETURN                                                         '

ValShiftCtlAlt:                                                   '
   CONTROL GET TEXT ghKey, %KEYMAP_SHIFTCONTALT TO t              ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Null)", TRIM$(t))                 '
   kfield = "Shift-Control-Alt mode key"                          '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetSCAData(lclMap, t)                                    ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_SHIFTCONTALT, t                ' Re-display it
   RETURN                                                         '

ValControlAlt:                                                    '
   CONTROL GET TEXT ghKey, %KEYMAP_CONTROLALT TO t                ' Get the modified data
   t = IIF$(ISNULL(TRIM$(t)), "(Null)", TRIM$(t))                 '
   kfield = "Control-Alt mode key"                                '
   GOSUB ValKey                                                   ' Do some basic validation
   gKbdT.SetCAData(lclMap, t)                                     ' Replace in case ValKey 'fixed' it
   CONTROL SET TEXT ghKey, %KEYMAP_CONTROLALT, t                  ' Re-display it
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Common routine called by all the key types above                                                |
'--------------------------------------------------------------------------------------------------+
ValKey:                                                           '
   IF ISNULL(t) THEN RETURN                                       ' Nulls are always valid
   tpf = ""                                                       ' Null <...> prefix save
   IF LEFT$(t, 1) = "<" THEN                                      ' PFSHOW labelled?
      i = INSTR(t, ">")                                           ' Look for closing
      IF i THEN                                                   ' Found it, strip it off
         tpf = LEFT$(t, i)                                        ' And save in tpf
         t = MID$(t, i + 1)                                       '
      ELSE                                                        '
         MSG = "invalid PFSHOW label"                             '
         GOSUB ValError                                           '
         RETURN                                                   '
      END IF                                                      '
   END IF                                                         '

   IF LEFT$(t, 1) = ":" AND INSTR(t, ANY "(){}") = 0 THEN         ' Probable ISPF style line command?
      u = t: t = "{" + MID$(t, 2) + "}"                           ' Convert it
      DoMessageBox("ISPF style line command detected." + $CRLF + $CRLF + _ '
                   "The string: |K" + u + "|B has been converted to: |K" + t, _  '
                   %MB_OK OR %MB_USERICON, "Line Command converted") '
   END IF                                                         '

   SELECT CASE CONST$ LEFT$(t, 1)                                 ' See if a bracketd command string?
      CASE "{"                                                    '
         IF INSTR(t, "}") = 0 THEN GOSUB BrkErr: RETURN           ' Make sure closing } is there
         IF LEN(PARSE$(t, ANY "{}", 2)) > 8 THEN                  ' Line command too long?
            MSG = "line command too long"                         '
            GOSUB ValError                                        '
            RETURN                                                '
         END IF                                                   '
      CASE "(": IF INSTR(t, ")") = 0 THEN GOSUB BrkErr: RETURN    ' Make sure closing ) is there
      CASE "[": IF INSTR(t, "]") = 0 THEN GOSUB BrkErr: RETURN    ' Make sure closing ] is there
   END SELECT                                                     '

   BrkCount = TALLY(t, ANY "()")                                  ' Count ()
   IF INSTR(UUCASE(t), "(PASSTHRU)") > 0 THEN                     ' (Passthru) should be alone
      IF BrkCount > 2 OR INSTR(t, ")") <> LEN(t)  THEN            '
         MSG = "(Passthru) may not be combined with anything else"   '
         GOSUB ValError                                           '
         RETURN                                                   '
      END IF                                                      '
   END IF                                                         '
   IF (BrkCount MOD 2) <> 0 THEN                                  ' Test ( ) count
      MSG = "may have mismatched Primitive parentheses ( )"       '
      GOSUB ValError                                              '
      RETURN                                                      '
   END IF                                                         '

   SqgCount = TALLY(t, ANY "{}")                                  ' Count various brackets
   IF (SqgCount MOD 2) <> 0 THEN                                  ' Test { } count
      MSG = "may have mismatched Line Command braces { }"         '
      GOSUB ValError                                              '
      RETURN                                                      '
   END IF                                                         '
   t = tpf + t                                                    ' Restore <...>
   RETURN                                                         '

BrkErr:                                                           '
   MSG = "missing closing for " + LEFT$(t, 1)                     ' Finalize message
   GOSUB ValError                                                 ' Issue it
   RETURN                                                         '

ValError:                                                         '
   MSGBOX "Warning! " + kfield + " - " + MSG, _                   ' Issue a msg
             %MB_OK OR %MB_ICONERROR, "SPFLite KeyMap"            '
   RETURN                                                         '
END FUNCTION                                                      '

SUB      DispMessageList()                                        '
'--------------------------------------------------------------------------------------------------+
'- Display the ErrMsgLast string                                                                   |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Build the dialog                                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG NEW ghWnd, "Messages",,, 400, 200, %WS_THICKFRAME OR %WS_CAPTION OR %WS_SYSMENU TO ghMsg '
   CONTROL ADD TEXTBOX, ghMsg, %MSG_ListBox, TP.ErrMsgLast, 0, 0, 400, 200, %ES_AUTOHSCROLL OR %ES_MULTILINE OR %ES_AUTOVSCROLL OR _   '
                                                      %WS_HSCROLL OR %WS_VSCROLL, %WS_EX_CLIENTEDGE   '
   CONTROL SET FONT     ghMsg, %MSG_ListBox, gFixedFont           '
   KbdPopSave                                                     ' Ready for pop-up
   DIALOG SHOW MODAL    ghMsg, CALL DlgMessageCallback            '
   KbdPopRestore                                                  ' Back from pop-up
   MExit                                                          '
END SUB                                                           '

SUB      DispOptions(StartPg AS LONG)                             '
'--------------------------------------------------------------------------------------------------+
'- Build and display the Options Dialog                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j               AS LONG                                  '
LOCAL t                  AS STRING                                '
DIM MinRetrieveList(9)   AS STRING                                '
DIM NotifyList(3)        AS STRING                                '
DIM ScrLabels(16 TO 27)  AS STRING                                '
DIM WebCheckList(3)      AS STRING                                '

   MEntry                                                         '
   ARRAY ASSIGN MinRetrieveList() = "1", "2", "3", "4", "5", "6", "7", "8", "9"  '
   ARRAY ASSIGN NotifyList() = "None", "Edit", "All"              '
   ARRAY ASSIGN ScrLabels() = "Line Number Hi-Intensity", "Line Number Lo-Intensity", _   '
                              "Active Tab Modified", "Active Tab Unmodified", _  '
                              "Inactive Tab Modified", "Inactive Tab Unmodified", _ '
                              "PFK Help Lines", "Status Line", "FM Quick Launch Bar", "Messages / Errors", _   '
                              "Diff Deleted lines", "Diff Inserted Lines"  '
   ARRAY ASSIGN WebCheckList() = "Check Manually", "7 Days", "30 Days"  '

   '-----------------------------------------------------------------------------------------------+
   '- Create the main dialogue                                                                     |
   '-----------------------------------------------------------------------------------------------+
   DIALOG FONT DEFAULT "Tahoma", 13 / gFontScale,0, 0             '
   DIALOG NEW ghWnd, "SPFLite Global Options (" + MID$(gSQL.OptName, 2) + ")", , , 350, 260, _  '
      %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR _ '
      %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR _  '
      %DS_SETFONT, %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO ghOpt '
   DIALOG SET COLOR ghOpt, %WHITE, -2                             '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Tab Control to main dialog box                                                       |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD TAB,     ghOpt, %TAB_CONTROL, "", 1, 1, 348, 233, %TCS_OWNERDRAWFIXED   '
   CONTROL ADD IMAGEX,  ghOpt, %GENERAL_GPLV3, "GPLV3", 2, 235, 66, 24, %SS_ICON '
   CONTROL ADD LABEL,   ghOpt, %DIALOG_INI_TEXT1, "SPFLite.CFG file Folder:", 74, 240, 200, 12  '
   CONTROL SET COLOR    ghOpt, %DIALOG_INI_TEXT1, %WHITE, -2      '
   CONTROL ADD TEXTBOX, ghOpt, %DIALOG_INI_TEXT2, gENV.HomeFolder, 155, 240, 145, 11, %ES_AUTOHSCROLL '
   CONTROL ADD BUTTON,  ghOpt, %DIALOG_CANCEL, "&Cancel", 305, 234, 40, 11, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER  '
   DLGToolTipSet(GetDlgItem(ghOpt, %DIALOG_CANCEL), " Press Cancel to exit Options and make NO changes ")   '
   CONTROL ADD BUTTON,  ghOpt, %DIALOG_DONE, "&Done", 305, 247, 40, 11, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER   '
   DLGToolTipSet(GetDlgItem(ghOpt, %DIALOG_DONE), " Press Done once you have made all desired changes ") '

   '-----------------------------------------------------------------------------------------------+
   '- Add the General Tab                                                                          |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 1, 0, "General", CALL DlgOptionsCallBack TO ghGeneral   '
   DLGAddCheck(ghGeneral, %GENERAL_INIABeepFlag, gENV.ABeepFlag, 4, 4, 115, "Audible BEEP on Errors") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIABeepFlag), " Make a BEEP on error messages or invalid keyboard entry ")   '
   DLGAddCheck(ghGeneral, %GENERAL_INIUniqueFlag, gENV.UniqueFlag, 200, 4, 115, "Only 1 SPFLite running")   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIUniqueFlag), " Use 1 Window (multiple tabs) for all SPFLite Edit sessions ")  '
   DLGAddCheck(ghGeneral, %GENERAL_INIVBeepFlag, gENV.VBeepFlag, 4, 12, 115, "Visual BEEP on Errors") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIVBeepFlag), " Do a visual Blink to show a BEEP on error messages or invalid keyboard entry ")   '
   DLGAddCheck(ghGeneral, %GENERAL_INIReOpenLast, gENV.ReOpenLast, 200, 12, 115, "Re-Open last file(s) at start") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIReOpenLast), " Open last file used file set if no other file specified on the Cmd line ") '
   DLGAddCheck(ghGeneral, %GENERAL_INIUseRecycle, gENV.UseRecycle, 4, 20, 115, "Delete to Recycle Bin")  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIUseRecycle), " If Ticked, Deleted files will be moved to the Recycle Bin ")   '
   DLGAddCheck(ghGeneral, %GENERAL_INIViewWarn, gENV.ViewWarn, 200, 20, 115, "Warn on modified View file")  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIViewWarn), " If Ticked, an END for a modified View tab will generate a warning prompt ")  '
   DLGAddCheck(ghGeneral, %GENERAL_FINDWORD, gENV.FindWord, 4, 28, 200, "Use WORD as default for FIND/CHANGE commands") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_FINDWORD), " If Ticked, FIND/CHANGE will assume WORD mode unless otherwise specified") '
   DLGAddCheck(ghGeneral, %GENERAL_INISplash, gENV.Splash, 200, 28, 135, "Display splash screen on startup")   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INISplash), " If Ticked, SPFLite will display it's Splash screen whenever it starts")  '
   DLGAddCheck(ghGeneral, %GENERAL_INIWarnNonText, gENV.WarnNonText, 200, 36, 135, "Warn on Open of Non-Text files") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIWarnNonText), " If Ticked, SPFLite will ask for confirmation before opening files with Non-Text file extensions") '
   DLGAddCheck(ghGeneral, %GENERAL_INIENGChars, gENV.ENGChars, 4, 36, 175, "Only English A-Z and a-z are considered alphabetic") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIENGChars), " If Ticked, only A-Z and a-z will be considered alphabatic")   '
   DLGAddCheck(ghGeneral, %GENERAL_INICUTNew, gENV.CUTNew, 200, 44, 135, "CUT should default to NEW") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INICUTNew), " If Ticked, CUT commands will default to using a NEW operand")   '
   DLGAddCheck(ghGeneral, %GENERAL_INIResetU, gENV.ResetU, 4, 44, 175, "Default RESET will Revert User line status") '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIResetU), " If Ticked, a RESET command will clear all User line status, just like Exclude status")  '
   DLGAddCheck(ghGeneral, %GENERAL_INIAttnPos, gENV.AttnPos, 200, 52, 150, "Maintain screen position after Line Cmds")  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIAttnPos), " If Ticked, preference is given to retainng the screen position as of the last Attention position") '
   DLGAddCheck(ghGeneral, %GENERAL_INIHelpOpen, IIF(gENV.HelpOpen = 3, 1, 0), 4, 52, 175, "Open HELP screens in Full Screen mode")  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIHelpOpen), " If Ticked, HELP will open in Full Screen, otherwise in the last used size and position") '
   DLGAddCheck(ghGeneral, %GENERAL_MacName, gENV.MacName, 4, 60, 175, "Display Macroname on Message line")  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_MacName), " If Ticked, after any macro invocation, the macro name will be shown at the left end of the Message line")
   DLGAddCheck(ghGeneral, %GENERAL_INIMinToTray, gENV.MinToTray, 200, 60, 150, "Minimize SPFLite to the System Tray")   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIMinToTray), " If Ticked, SPFLite will minimize to the System Tray instead of the Task Bar")  '
   DLGAddCheck(ghGeneral, %GENERAL_PanelMax, gENV.PanelMax, 4, 68, 175, "Active Panel always uses largest size")  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_PanelMax), " If Ticked, in Panel Split mode, the Active panel will always use the larger of the two panel sizes.")

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIBKPRetentionHeader_TEXT, "BACKUP Retention Criteria", 130, 79, 175, 12  '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIBKPRetentionHeader_TEXT, %YELLOW, -2   '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIBKPRETPD_TEXT, "RETPD [Days]", 4, 88, 90, 12 '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIBKPRETPD_TEXT, %WHITE, -2  '
   CONTROL ADD TEXTBOX, ghGeneral, %GENERAL_INIBKPRETPD, FORMAT$(gENV.BKPRetention), 60, 88, 25, 10, %ES_NUMBER   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIBKPRETPD), "Enter the number of RETPD days to use for the Retention criteria ")  '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIBKPMinGen_TEXT, "Minimum Gens [Num]", 90, 88, 90, 12  '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIBKPMinGen_TEXT, %WHITE, -2 '
   CONTROL ADD TEXTBOX, ghGeneral, %GENERAL_INIBKPMinGen, FORMAT$(gENV.BKPMinGen), 170, 88, 25, 10, %ES_NUMBER '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIBKPMinGen), "Enter the miniimum number of generations for the Retention criteria ") '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIBKPMaxGen_TEXT, "Maximum Gens [Num]", 200, 88, 90, 12 '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIBKPMaxGen_TEXT, %WHITE, -2 '
   CONTROL ADD TEXTBOX, ghGeneral, %GENERAL_INIBKPMaxGen, FORMAT$(gENV.BKPMaxGen), 285, 88, 30, 10, %ES_NUMBER '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIBKPMaxGen), "Enter the maximum number of generations for the Retention criteria ")  '

   CONTROL ADD COMBOBOX, ghGeneral, %GENERAL_INIMinRetrieve, MinRetrieveList(), 125, 100, 30, 40, %CBS_DROPDOWNLIST OR %WS_VSCROLL   '
   COMBOBOX SELECT ghGeneral, %GENERAL_INIMinRetrieve, gENV.MinRetrieve '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIMinRetrieve), " Command lines whose length is less than this value will not be saved for RETRIEVE ")  '
   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIMinRetrieve_TEXT, "Min. command length for RETRIEVE", 4, 101, 120, 12 '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIMinRetrieve_TEXT, %WHITE, -2  '

   CONTROL ADD TEXTBOX,   ghGeneral, %GENERAL_INICmdChr, gENV.CmdChr, 285, 100, 30, 9, %ES_CENTER   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INICmdChr), " Single character used to separate multiple commands on the Command Line ")  '
   CONTROL POST ghGeneral, %GENERAL_INICmdChr, %EM_LIMITTEXT, 1, 0   '
   CONTROL ADD LABEL, ghGeneral, %GENERAL_INICmdChr_TEXT, "Command separator character", 170, 100, 150, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INICmdChr_TEXT, %WHITE, -2 '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIAutoScroll_TEXT, "Number of cols/lines per Auto-Scroll", 4, 113, 150, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIAutoScroll_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX, ghGeneral, %GENERAL_INIAutoScroll, FORMAT$(gENV.AutoScroll), 125, 113, 30, 9, %ES_NUMBER  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIAutoScroll), " Number of columns/lines to scroll per scroll event ") '
   CONTROL POST ghGeneral, %GENERAL_INIAutoScroll, %EM_LIMITTEXT, 3, 0  '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INILinRepeatMax_TEXT, "Line Cmd repeat limit (0=no limit)", 170, 112, 150, 12 '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INILinRepeatMax_TEXT, %WHITE, -2 '
   CONTROL ADD TEXTBOX,   ghGeneral, %GENERAL_INILinRepeatMax, FORMAT$(gENV.LinRepeatMax), 285, 112, 30, 9, %ES_NUMBER  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INILinRepeatMax), " Limit Line Command repeat value to this maximum ")  '
   CONTROL POST ghGeneral, %GENERAL_INILinRepeatMax, %EM_LIMITTEXT, 9999, 0   '

   CONTROL ADD COMBOBOX, ghGeneral, %GENERAL_ININotify, NotifyList(), 125, 124, 30, 40, %CBS_DROPDOWNLIST OR %WS_VSCROLL   '
   COMBOBOX SELECT ghGeneral, %GENERAL_ININotify, SWITCH(gENV.NotifyLevel = 0, 1, gENV.NotifyLevel = 1, 2, gENV.NotifyLevel = 2, 3) '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_ININotify), " Select Tab types to be Notified on an external file change occurring ")  '
   CONTROL ADD LABEL, ghGeneral, %GENERAL_ININotify_TEXT, "Notify tabs on external file change", 4, 125, 150, 12  '
   CONTROL SET COLOR  ghGeneral, %GENERAL_ININotify_TEXT, %WHITE, -2 '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INILANG_TEXT, "Spell Check language code", 170, 124, 150, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INILANG_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX,   ghGeneral, %GENERAL_INILANG, IIF$(gENV.LANG <> "", gENV.LANG, "None"), 285, 124, 30, 9  '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INILANG), " The Suffix of the Dictionary files to be used for Spell check")   '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIDefDataShift_TEXT1, "Default # cols to use for data shifts (Min 1)", 4, 149, 190, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIDefDataShift_TEXT1, %WHITE, -2   '
   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIDefDataShift_TEXT2, "(Append 'P' to use Profile XTAB)", 235, 149, 190, 12  '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIDefDataShift_TEXT2, %WHITE, -2   '
   i = gENV.DefDataShift                                          ' Format the value
   t = IIF$(i < 0, FORMAT$(ABS(i)) + "P", FORMAT$(i))             '
   CONTROL ADD TEXTBOX,   ghGeneral, %GENERAL_INIDefDataShift, t, 200, 149, 30, 9   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIDefDataShift), " Number of columns to shift for )) >> ]] line commands ")  '
   CONTROL POST ghGeneral, %GENERAL_INIDefDataShift, %EM_LIMITTEXT, 3, 0   '

   CONTROL ADD COMBOBOX, ghGeneral, %GENERAL_INIWebCheck, WebCheckList(), 200, 160, 70, 64, %CBS_DROPDOWNLIST OR %WS_VSCROLL  '
   COMBOBOX SELECT ghGeneral, %GENERAL_INIWebCheck, SWITCH(gENV.WebCheck = 0, 1, gENV.WebCheck = 7, 2, gENV.WebCheck = 30, 3) '
   DlgToolTipSet (GetDlgItem(ghGeneral, %GENERAL_INIWebCheck), " Select # days between checks for SPFLite updates ") '
   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIWebCheck_TEXT, "Check for SPFLite update interval", 4, 160, 150, 12  '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIWebCheck_TEXT, %WHITE, -2  '

   CONTROL ADD BUTTON,  ghGeneral, %GENERAL_INIWebCheck_NOW, "Check now", 275, 160, 40, 11, %BS_VCENTER OR %BS_CENTER   '
   DlgToolTipSet (GetDlgItem(ghGeneral, %GENERAL_INIWebCheck_NOW), " Press to check immediately for any SPFLite program updates. ") '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INISetUndo_TEXT, "Number of UNDO levels (0 to turn off UNDO)", 4, 173, 150, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INISetUndo_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX,   ghGeneral, %GENERAL_INISetUNDO, FORMAT$(gENV.UndoLevels), 200, 173, 30, 9, %ES_NUMBER   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INISetUNDO), " The number of UNDO levels you prefer. (0) Zero to turn OFF UNDO ")   '
   CONTROL POST ghGeneral, %GENERAL_INISetUNDO, %EM_LIMITTEXT, 10, 0 '

   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIPDotRaw_TEXT, "Enter the invalid characters for P'.' picture literals", 4, 184, 300, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIPDotRaw_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX,   ghGeneral, %GENERAL_INIPDotRaw, gENV.PDotRaw, 4, 192, 337, 9, %ES_AUTOHSCROLL OR %ES_UPPERCASE   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIPDotRaw), " Enter the character range description for the invalid characters ")  '

   CONTROL ADD TEXTBOX,   ghGeneral, %GENERAL_INIInvChar, gENV.InvChar, 201, 203, 20, 9, %ES_CENTER   '
   DLGToolTipSet(GetDlgItem(ghGeneral, %GENERAL_INIInvChar), " Display character to use when one of the above characters is displayed ")  '
   CONTROL POST ghGeneral, %GENERAL_INIInvChar, %EM_LIMITTEXT, 1, 0  '
   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIInvChar_TEXT1, "Display Character to use for Invalid characters", 4, 203, 200, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIInvChar_TEXT1, %WHITE, -2  '
   CONTROL ADD LABEL, ghGeneral, %GENERAL_INIInvChar_TEXT2, "(Or N to suppress translation)", 235, 203, 200, 12   '
   CONTROL SET COLOR  ghGeneral, %GENERAL_INIInvChar_TEXT2, %WHITE, -2  '

   '-----------------------------------------------------------------------------------------------+
   '- Add the File Manager Tab                                                                     |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 2, 0, "FM", CALL DlgOptionsCallBack TO ghFManager '
   DLGAddCheck(ghFManager, %FMANAGER_INIFMCloseFlag, gENV.FMCloseFlag, 4, 2, 115, "Close SPFLite with last file tab")   '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_INIFMCloseFlag), " If Ticked, SPFLite will close when last file data tab closes ")   '
   DLGAddCheck(ghFManager, %FMANAGER_INIConfDelFlag, gENV.ConfDelFlag, 4, 10, 115, "Confirm file Deletes")  '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_INIConfDelFlag), " If Ticked, you will be asked permission before each file delete ")   '

   DLGAddCheck(ghFManager, %FMANAGER_FMHLFLAG, gENV.FMHelpFlag, 150, 2, 115, "Display File Manager Help")   '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_FMHLFLAG), " If Ticked, FM will Display 3 lines of Help @ bottom of Screen")   '
   DLGAddCheck(ghFManager, %FMANAGER_FMDATEHILITE, gENV.FMDateHiLite, 150, 10, 115, "Highlight Recent / Active dates")  '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_FMDATEHILITE), " If Ticked, FM will Highlight Recent / Active Dates in the File List")  '

   DLGAddCheck(ghFManager, %FMANAGER_INIFMSORTSIMPLE, gENV.FMSortSimple, 4, 18, 115, "Use simple ANSI sort method")  '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_INIFMSORTSIMPLE), " If Ticked, FM use a simple ANSI sort rather than the Explorer compatible Logical sort")  '

   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_TEXT, "Enter the STANDARD column layout, in order", 4, 54, 200, 12 '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX,   ghFManager, %FMANAGER_INIFMLayout, gENV.FMLayout, 4, 62, 337, 12   '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_INIFMLayout), " Enter the STANDARD FM column layout in the desired left to right order ")  '

   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayoutM_TEXT, "Enter the ALTERNATE column layout, in order", 4, 75, 200, 12  '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayoutM_TEXT, %WHITE, -2  '
   CONTROL ADD TEXTBOX,   ghFManager, %FMANAGER_INIFMLayoutM, gENV.FMLayoutM, 4, 83, 337, 12 '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_INIFMLayoutM), " Enter the ALTERNATE FM column layout in the desired left to right order ")   '

   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_Help1_TEXT, "Valid column names to choose from are:", 4, 98, 200, 10  '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_Help1_TEXT, %WHITE, -2   '
   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_Help2_TEXT, "   ATTR, CRDATE, CRDATETIME, LINES, LRDATE, LRDATETIME, LWDATE, LWDATETIME,", 4, 105, 325, 10   '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_Help2_TEXT, %YELLOW, -2  '
   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_Help3_TEXT, "   NAME, PATH, PRP1, PRP2, PRP3, PRP4, PRP5, PRP6, SIZESHORT, SIZELONG, ", 4, 112, 325, 10   '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_Help3_TEXT, %YELLOW, -2  '
   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_Help4_TEXT, "PRPn entries may request any of the following Properties, please read the Help file for full details.", 4, 119, 325, 10 '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_Help4_TEXT, %WHITE, -2   '
   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_Help5_TEXT, "   ALBUM, ARTIST, BDEPTH, BRATE, CONTRIB, CAMMAKER, CAMMODEL, DATETAKEN,", 4, 126, 325, 10   '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_Help5_TEXT, %YELLOW, -2  '
   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_Help6_TEXT, "   DIMENSION, DURATION, EXP, FLASH, FSTOP, GENRE, HRES, ISO, PUBLISHER,", 4, 133, 325, 10 '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_Help6_TEXT, %YELLOW, -2  '
   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLayout_Help7_TEXT, "   RATING, SUBTITLE, TITLE, TRK, VRES, YEAR", 4, 140, 325, 10  '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLayout_Help7_TEXT, %YELLOW, -2  '

   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIRecentCtr_TEXT, "Number of entries in recent lists", 4, 171, 150, 12  '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIRecentCtr_TEXT, %WHITE, -2  '
   CONTROL ADD TEXTBOX,   ghFManager, %FMANAGER_INIRecentCtr, FORMAT$(gENV.RecentCtr), 175, 171, 20, 10, %ES_NUMBER  '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_INIRecentCtr), " Specify how many entries to retain in the recent file/path lists ") '
   CONTROL POST ghFManager, %FMANAGER_INIRecentCtr, %EM_LIMITTEXT, 2, 0 '

   CONTROL ADD LABEL, ghFManager, %FMANAGER_INIFMLCmdWidth_TEXT, "Width of Line Command area (5 to 20)", 4, 200, 150, 12   '
   CONTROL SET COLOR  ghFManager, %FMANAGER_INIFMLCmdWidth_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX,   ghFManager, %FMANAGER_INIFMLCmdWidth, FORMAT$(gENV.FMLCmdWidth), 175, 200, 20, 10, %ES_NUMBER '
   DLGToolTipSet(GetDlgItem(ghFManager, %FMANAGER_INIFMLCmdWidth), " Enter desired display width in characters of the FM Line command area ")   '
   CONTROL POST ghFManager, %FMANAGER_INIFMLCmdWidth, %EM_LIMITTEXT, 2, 0  '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Submit Tab                                                                           |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 3, 0, "Submit", CALL DlgOptionsCallBack TO ghSubmit  '

   CONTROL ADD LABEL, ghSubmit, %SUBMIT_SUBMIT_TEXT, "Prototype command line to be used by SUBMIT", 4, 4, 200, 12 '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_SUBMIT_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX,   ghSubmit, %SUBMIT_SUBMIT, gENV.SubmitCmd, 4, 14, 337, 10, %ES_AUTOHSCROLL   '
   DLGToolTipSet(GetDlgItem(ghSubmit, %SUBMIT_SUBMIT), " Enter your prototype SUBMIT command string using fixed and/or substitution strings as needed ") '

   CONTROL ADD LABEL, ghSubmit, %SUBMIT_INICMDFlags_TEXT, "CMD.EXE flags used by SPFLite CMD command", 4, 64, 200, 12   '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_INICMDFlags_TEXT, %WHITE, -2 '
   CONTROL ADD TEXTBOX,   ghSubmit, %SUBMIT_INICMDFlags, gENV.CmdFlags, 4, 74, 337, 10, %ES_AUTOHSCROLL  '
   DLGToolTipSet(GetDlgItem(ghSubmit, %SUBMIT_INICMDFlags), " Enter the CMD.EXE command line flags to be used by the SPFLite CMD command ")  '

   CONTROL ADD LABEL, ghSubmit, %SUBMIT_INIRUNFlags_TEXT, "CMD.EXE flags used by SPFLite RUN command", 4, 94, 200, 12   '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_INIRUNFlags_TEXT, %WHITE, -2 '
   CONTROL ADD TEXTBOX,   ghSubmit, %SUBMIT_INIRUNFlags, gENV.RunFlags, 4, 104, 337, 10, %ES_AUTOHSCROLL '
   DLGToolTipSet(GetDlgItem(ghSubmit, %SUBMIT_INIRUNFlags), " Enter the CMD.EXE command line flags to be used by the SPFLite RUN command ")  '

   CONTROL ADD LABEL, ghSubmit, %SUBMIT_INIInclKey_TEXT, "Trigger key for the SUBMIT Include statement", 4, 124, 200, 12   '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_INIInclKey_TEXT, %WHITE, -2  '
   CONTROL ADD TEXTBOX,   ghSubmit, %SUBMIT_INIInclKey, gENV.SubmitInclKey, 4, 134, 337, 10, %ES_AUTOHSCROLL   '
   DLGToolTipSet(GetDlgItem(ghSubmit, %SUBMIT_INIInclKey), " Enter the special key that identifies the SUBMIT Include statement ")  '

   CONTROL ADD LABEL, ghSubmit, %SUBMIT_INIInclCol_TEXT, "Column number where above Include Key must appear", 4, 154, 200, 12 '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_INIInclCol_TEXT, %WHITE, -2  '
   CONTROL ADD TEXTBOX,   ghSubmit, %SUBMIT_INIInclCol, FORMAT$(gENV.SubmitInclCol), 4, 164, 337, 10, %ES_AUTOHSCROLL   '
   DLGToolTipSet(GetDlgItem(ghSubmit, %SUBMIT_INIInclCol), " Enter the specific column number where the Include Key must appear ")  '

   CONTROL ADD LABEL, ghSubmit, %SUBMIT_H1, "Reminder for the CMD.EXE flags.", 4, 175, 200, 12  '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_H1, %YELLOW, -2           '
   CONTROL ADD LABEL, ghSubmit, %SUBMIT_H2, "  The 2 commonest flags used are:", 4, 184, 200, 12   '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_H2, %YELLOW, -2           '
   CONTROL ADD LABEL, ghSubmit, %SUBMIT_H3, "    /C   Carries out the command and then terminates", 4, 191, 200, 12  '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_H3, %YELLOW, -2           '
   CONTROL ADD LABEL, ghSubmit, %SUBMIT_H4, "    /K   Carries out the command but remains", 4, 198, 200, 12 '
   CONTROL SET COLOR  ghSubmit, %SUBMIT_H4, %YELLOW, -2           '
   '-----------------------------------------------------------------------------------------------+
   '- Add the Screen Tab                                                                           |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 4, 0, "Screen", CALL DlgOptionsCallBack TO ghScreen  '

   DLGAddCheck(ghScreen, %SCREEN_INIHRuler, gENV.HRuler, 184, 1, 80, "Horizontal cursor")   '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIHRuler), " Select to display a horizontal line at the cursor row ") '
   DLGAddCheck(ghScreen, %SCREEN_INIVRuler, gENV.VRuler, 280, 1, 80, "Vertical cursor")  '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIVRuler), " Select to display a vertical line at the cursor row ")   '
   DLGAddCheck(ghScreen, %SCREEN_INIBanding, gENV.Banding, 184, 9, 150, "Alternating Background screen colors")   '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIBanding), " Select to display alternating backgrond colors every 3 lines ")  '
   DLGAddCheck(ghScreen, %SCREEN_INICMDHILITE, gENV.CmdHiLite, 184, 17, 150, "Hilight Command line keywords")  '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INICMDHILITE), " Select to have Command line keywords highlighted ")   '
   DLGAddCheck(ghScreen, %SCREEN_INIVSCROLLBAR, gENV.VScrollBar, 184, 25, 150, "Add Vertical ScrollBars")   '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIVSCROLLBAR), " Select to have a Vertical ScrollBar added to the screen ") '

   CONTROL ADD TEXTBOX, ghScreen, %SCREEN_FILELINEFMT, gENV.FileLineFmt, 184, 38, 75, 10  '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_FILELINEFMT), " Enter the Format description for the =FILE> line ") '
   CONTROL ADD LABEL, ghScreen, %SCREEN_FILELINEFMT_TEXT, "=FILE> line format", 270, 38, 150, 10   '
   CONTROL SET COLOR  ghScreen, %SCREEN_FILELINEFMT_TEXT, %WHITE, -2 '

   CONTROL ADD TEXTBOX, ghScreen, %SCREEN_INISBFactor, FORMAT$(gENV.SBFactor, "0.0"), 184, 48, 15, 10 '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INISBFactor), " Enter a factor to Increase / Decrease the size of the Font used ") '
   CONTROL ADD LABEL, ghScreen, %SCREEN_INISBFactor_TEXT, "Status Bar/Tab Title Font scale factor", 210, 48, 150, 10 '
   CONTROL SET COLOR  ghScreen, %SCREEN_INISBFactor_TEXT, %WHITE, -2 '

   CONTROL ADD TEXTBOX, ghScreen, %SCREEN_INIPFKShow, FORMAT$(gENV.PFKShow), 184, 58, 15, 10 '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIPFKShow), " Enter the # lines at bottom of screen reserved for Keyboard Help")  '
   CONTROL ADD LABEL, ghScreen, %SCREEN_INIPFKShow_TEXT, "# K-Board help lines to show", 210, 58, 100, 10   '
   CONTROL SET COLOR  ghScreen, %SCREEN_INIPFKShow_TEXT, %WHITE, -2  '

   CONTROL ADD TEXTBOX, ghScreen, %SCREEN_INILNOSIZE, FORMAT$(gENV.LinNoSize), 184, 68, 15, 10  '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INILNOSIZE), " Enter the display width of the Line numbers on the screen")   '
   CONTROL ADD LABEL, ghScreen, %SCREEN_INILNOSIZE_TEXT, "Width of Line Numbers (5-8)", 210, 68, 100, 10 '
   CONTROL SET COLOR  ghScreen, %SCREEN_INILNOSIZE_TEXT, %WHITE, -2  '

   DLGAddCheck(ghScreen, %SCREEN_INIVERTINSCURS, gENV.VertInsCurs, 4, 1, 120, "    Vertical cursor in Ins. Mode") '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIVERTINSCURS), " Use a vertical cursor rather than a blob when in Inset Mode ")  '

   CONTROL ADD TEXTBOX,   ghScreen, %SCREEN_CURSHGHTNORM, FORMAT$(gENV.CursNormal), 4, 13, 20, 10, %ES_NUMBER  '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_CURSHGHTNORM), " Specifies % Height (0-100) of a Normal cursor vs a Full Blob ")   '
   CONTROL ADD LABEL, ghScreen, %SCREEN_CURSHGHTNORM_TEXT, "% Height Normal Cursor", 30, 13, 150, 10  '
   CONTROL SET COLOR  ghScreen, %SCREEN_CURSHGHTNORM_TEXT, %WHITE, -2   '

   CONTROL ADD TEXTBOX,   ghScreen, %SCREEN_CURSHGHTINS, FORMAT$(gENV.CursInsert), 4, 25, 20, 10, %ES_NUMBER   '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_CURSHGHTINS), " Specifies % Height (20-100) of an Insert cursor vs a Full Blob ")  '
   CONTROL ADD LABEL, ghScreen, %SCREEN_CURSHGHTINS_TEXT, "% Height Insert Cursor", 30, 25, 150, 10   '
   CONTROL SET COLOR  ghScreen, %SCREEN_CURSHGHTINS_TEXT, %WHITE, -2 '

   CONTROL ADD TEXTBOX,   ghScreen, %SCREEN_INIFontName, gENV.FontName, 4, 37, 90, 10  '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIFontName), " Enter the name of the Font to use for the Edit text display ")  '
   CONTROL ADD LABEL, ghScreen, %SCREEN_INIFontName_TEXT, "Font Name", 100, 37, 50, 10 '
   CONTROL SET COLOR  ghScreen, %SCREEN_INIFontName_TEXT, %WHITE, -2 '

   CONTROL ADD TEXTBOX,   ghScreen, %SCREEN_INIFontPitch, FORMAT$(gENV.FontPitch), 4, 49, 20, 10   '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIFontPitch), " Enter the size of the Font (in points) ") '
   CONTROL ADD LABEL, ghScreen, %SCREEN_INIFontPitch_TEXT, "Font Pitch", 100, 49, 50, 10  '
   CONTROL SET COLOR  ghScreen, %SCREEN_INIFontPitch_TEXT, %WHITE, -2   '

   CONTROL ADD BUTTON, ghScreen, %SCREEN_FONT_CHOOSE, "Choose", 4, 61, 45, 10 ', , %WS_BORDER
   CONTROL SET COLOR  ghScreen, %SCREEN_FONT_CHOOSE, %BLUE, %WHITE   '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_FONT_CHOOSE), " Click this button for a Font Selection Dialog which allows you to choose both Font and Pitch ")  '
   CONTROL ADD LABEL, ghScreen, %SCREEN_FONT_CHOOSE_TEXT, "(or Choose Font here)", 100, 61, 80, 10 '
   CONTROL SET COLOR  ghScreen, %SCREEN_FONT_CHOOSE_TEXT, %WHITE, -2 '

   CONTROL ADD GRAPHIC, ghScreen, %SCREEN_INIcMarkLine, "", 4, 73, 12, 12, %WS_BORDER OR %SS_NOTIFY   '
   GRAPHIC ATTACH ghScreen, %SCREEN_INIcMarkLine, REDRAW          '
   GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.cMarkLine, 0   '
   DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_INIcMarkLine), " Press to choose the color for the Column Mark Lines ")   '
   CONTROL ADD LABEL, ghScreen, %SCREEN_INIcMarkLine_TEXT, "Column Marker Line Color", 30, 75, 150, 12   '
   CONTROL SET COLOR  ghScreen, %SCREEN_INIcMarkLine_TEXT, %WHITE, -2   '

   '-----------------------------------------------------------------------------------------------+
   '- Now add the Screen component color choices                                                   |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL, ghScreen, %SCHEME_HEADING1, "FG BG1 BG2", 202 , 78, 50, 12 '
   CONTROL SET COLOR  ghScreen, %SCHEME_HEADING1, %YELLOW, -2     '
   i = 0                                                          '
   FOR j = 16 TO 27                                               '
      CONTROL ADD LABEL, ghScreen, %SCREEN_16_TEXT + (i * 4), ScrLabels(j), 4 , 88 + (i * 11), 200, 10, %SS_CENTERIMAGE '
      CONTROL SET COLOR  ghScreen, %SCREEN_16_TEXT + (i * 4), gENV.GetClr(j, 1), gENV.GetClr(j, 2) '
      CONTROL ADD LABEL, ghScreen, %SCREEN_16_TEXT + 50 + (i * 4), "BG2 Alternate", 134 , 88 + (i * 11), 70, 10, %SS_CENTERIMAGE '
      CONTROL SET COLOR  ghScreen, %SCREEN_16_TEXT + 50 + (i * 4), gENV.GetClr(j, 1), gENV.GetClr(j, 3)  '
      IF j = 23 THEN                                              ' If Status Bar position
         CONTROL SET FONT   ghScreen, %SCREEN_16_TEXT + (i * 4), gSBFont   '
         CONTROL SET FONT   ghScreen, %SCREEN_16_TEXT + 50 + (i * 4), gSBFont '
      ELSE                                                        '
         CONTROL SET FONT   ghScreen, %SCREEN_16_TEXT + (i * 4), gScrFont  '
         CONTROL SET FONT   ghScreen, %SCREEN_16_TEXT + 50 + (i * 4), gScrFont   '
      END IF                                                      '
      CONTROL ADD GRAPHIC, ghScreen, %SCREEN_16_FG + (i * 4), "", 201, 87 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY  '
      CONTROL SET USER   ghScreen, %SCREEN_16_FG + (i * 4), 1, j  '
      CONTROL SET USER   ghScreen, %SCREEN_16_FG + (i * 4), 2, 1  '
      GRAPHIC ATTACH ghScreen, %SCREEN_16_FG + (i * 4), REDRAW    '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(j, 1), 0   '
      DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_16_FG + (i * 4)), " Click to choose " + ScrLabels(j) + " ForeGround color ") '

      CONTROL ADD GRAPHIC, ghScreen, %SCREEN_16_FG + 1 + (i * 4), "", 214, 87 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY '
      CONTROL SET USER   ghScreen, %SCREEN_16_FG + 1 + (i * 4), 1, j '
      CONTROL SET USER   ghScreen, %SCREEN_16_FG + 1 + (i * 4), 2, 2 '
      GRAPHIC ATTACH ghScreen, %SCREEN_16_FG + 1 + (i * 4), REDRAW   '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(j, 2), 0   '
      DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_16_FG + 1 + (i * 4)), " Click to choose " + ScrLabels(j) + " BackGround 1 color ") '

      CONTROL ADD GRAPHIC, ghScreen, %SCREEN_16_FG + 2 + (i * 4), "", 229, 87 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY '
      CONTROL SET USER   ghScreen, %SCREEN_16_FG + 2 + (i * 4), 1, j '
      CONTROL SET USER   ghScreen, %SCREEN_16_FG + 2 + (i * 4), 2, 3 '
      GRAPHIC ATTACH ghScreen, %SCREEN_16_FG + 2 + (i * 4), REDRAW   '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(j, 3), 0   '
      DLGToolTipSet(GetDlgItem(ghScreen, %SCREEN_16_FG + 2 + (i * 4)), " Click to choose " + ScrLabels(j) + " BackGround 2 color ") '
      INCR i                                                      '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Keyboard Tab                                                                         |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 5, 0, "KBD", CALL DlgOptionsCallBack TO ghKeyboard   '
   DLGAddCheck(ghKeyboard, %KBOARD_KBSCROLLH, gENV.KBHorScroll, 4, 4, 150, "Scroll left/right with Arrow Keys")   '
   DLGToolTipSet(GetDlgItem(ghKeyboard, %KBOARD_KBSCROLLH), _     '
                    " If selected, scrolling will occur at the edge of the text area, otherwise the cursor will 'wrap' to the opposite screen edge ") '

   DLGAddCheck(ghKeyboard, %KBOARD_KBSCROLLV, gENV.KBVerScroll, 4, 18, 150, "Scroll up/down with Arrow Keys")  '
   DLGToolTipSet(GetDlgItem(ghKeyboard, %KBOARD_KBSCROLLV), _     '
                    " If selected, scrolling will occur at the edge of the text area, otherwise the cursor will 'wrap' to the opposite screen edge ") '

   DLGAddCheck(ghKeyboard, %KBOARD_INIInsMode, gENV.InsMode, 4, 32, 150, "Keyboard starts in INSERT mode")  '
   DLGToolTipSet(GetDlgItem(ghKeyboard, %KBOARD_INIInsMode), " Default Cursor mode to be used ")   '

   DLGAddCheck(ghKeyboard, %KBOARD_INIInsReset, gENV.InsReset, 4, 46, 150, "Reset INSERT mode on Attention")   '
   DLGToolTipSet(GetDlgItem(ghKeyboard, %KBOARD_INIInsReset), " Select if Cursor should return to the Default Cursor mode following a Keyboard Attention key (Enter, PFK, etc.)")   '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Status Bar Tab                                                                       |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 6, 0, "Status", CALL DlgOptionsCallBack TO ghSBar '

   CONTROL ADD LABEL, ghSBar, %SBAR_Help1, "You may customize the contents of the Status Bar here", 4, 5, 200, 10 '
   CONTROL SET COLOR  ghSBar, %SBAR_Help1, %YELLOW, -2            '
   CONTROL ADD LABEL, ghSBar, %SBAR_Help2, "Simply choose below which fields you want to appear", 4, 20, 225, 10  '
   CONTROL SET COLOR  ghSBar, %SBAR_Help2, %YELLOW, -2            '
   CONTROL ADD LABEL, ghSBar, %SBAR_INISBOrder_TEXT, "Enter your desired Status Bar fields from Left to Right", 4, 45, 200, 12   '
   CONTROL SET COLOR  ghSBar, %SBAR_INISBOrder_TEXT, %WHITE, -2   '
   CONTROL ADD TEXTBOX,   ghSBar, %SBAR_INISBOrder, gENV.SBLayout, 4, 55, 337, 25, %ES_UPPERCASE OR %ES_MULTILINE '
   DLGToolTipSet(GetDlgItem(ghSBar, %SBAR_INISBOrder), " Enter desired Status Bar fields in order from left to right ") '
   CONTROL ADD LABEL, ghSBar, %SBAR_Help3, "Valid field names to choose from are:", 4, 80, 200, 10 '
   CONTROL SET COLOR  ghSBar, %SBAR_Help3, %WHITE, -2             '
   t = "   "                                                      '
   FOR i = 1 TO 7                                                 ' Build the string
      t += RTRIM$(gSBTable(i).SBNAME) + "(" + FORMAT$(gSBTable(i).SBMaxTxt) + "),"  '
   NEXT i                                                         '
   CONTROL ADD LABEL, ghSBar, %SBAR_Help4, t, 4, 90, 500, 10      '
   CONTROL SET COLOR  ghSBar, %SBAR_Help4, %WHITE, -2             '
   t = "   "                                                      '
   FOR i = 8 TO 14                                                ' Build the string
      t += RTRIM$(gSBTable(i).SBNAME) + "(" + FORMAT$(gSBTable(i).SBMaxTxt) + "),"  '
   NEXT i                                                         '
   t = CLIP$(RIGHT, t, 1)                                         '
   CONTROL ADD LABEL, ghSBar, %SBAR_Help5, t, 4, 100, 500, 10     '
   CONTROL SET COLOR  ghSBar, %SBAR_Help5, %WHITE, -2             '
   CONTROL ADD LABEL, ghSBar, %SBAR_Help6, " Append (nn) to any field name to customize the width of the box", 4, 115, 225, 10   '
   CONTROL SET COLOR  ghSBar, %SBAR_Help6, %WHITE, -2             '
   CONTROL ADD LABEL, ghSBar, %SBAR_Help7, "    (nn) is the maximum message text, in characters; the value in the list above is the default.", 4, 125, 500, 10 '
   CONTROL SET COLOR  ghSBar, %SBAR_Help7, %WHITE, -2             '
   CONTROL ADD LABEL, ghSBar, %SBAR_Help8, " Refer to Help => Working with SPFLite => Status Bar for more information", 4, 150, 337, 30   '
   CONTROL SET COLOR  ghSBar, %SBAR_Help8, %WHITE, -2             '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Scheme Tab                                                                           |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 7, 0, "Schemes", CALL DlgOptionsCallBack TO ghScheme '
   CONTROL ADD LABEL, ghScheme, %SCHEME_HEADING1, "Scheme", 2 , 2, 250, 12 '
   CONTROL SET COLOR  ghScheme, %SCHEME_HEADING1, %YELLOW, -2     '
   CONTROL ADD LABEL, ghScheme, %SCHEME_HEADING2, "FG   BG1 BG2", 198, 2, 50, 12 '
   CONTROL SET COLOR  ghScheme, %SCHEME_HEADING2, %YELLOW, -2     '
   CONTROL ADD LABEL, ghScheme, %SCHEME_HEADING3, "Alias", 5, 14, 50, 12   '
   CONTROL SET COLOR  ghScheme, %SCHEME_HEADING3, %YELLOW, -2     '
   CONTROL ADD LABEL, ghScheme, %SCHEME_HEADING4, "Description", 64, 14, 50, 12  '
   CONTROL SET COLOR  ghScheme, %SCHEME_HEADING4, %YELLOW, -2     '
   FOR i = 0 TO 15                                                '
      IF i < 2 THEN                                               '
         CONTROL ADD TEXTBOX, ghScheme, %SCHEME_00_TEXT + (i * 6), gENV.GetSchAlias(i), 4, 23 + (i * 11), 61, 10, %ES_LEFT OR %ES_READONLY OR %WS_BORDER, %WS_EX_LEFT   '
      ELSE                                                        '
         CONTROL ADD TEXTBOX, ghScheme, %SCHEME_00_TEXT + (i * 6), gENV.GetSchAlias(i), 4, 23 + (i * 11), 61, 10, %ES_LEFT OR %WS_BORDER, %WS_EX_LEFT '
      END IF                                                      '
      CONTROL SET COLOR    ghScheme, %SCHEME_00_TEXT + (i * 6), gENV.GetClr(i, 1), gENV.GetClr(i, 2)  '
      CONTROL SET FONT     ghScheme, %SCHEME_00_TEXT + (i * 6), gScrFont   '
      IF i = 0 THEN                                               '
         CONTROL ADD LABEL,   ghScheme, %SCHEME_00_TEXT + 1 + (i * 6), "Text Low", 64, 23 + (i * 11), 50, 10, %SS_CENTERIMAGE '
      ELSEIF i = 1 THEN                                           '
         CONTROL ADD LABEL,   ghScheme, %SCHEME_00_TEXT + 1 + (i * 6), "Text High", 64, 23 + (i * 11), 50, 10, %SS_CENTERIMAGE   '
      ELSE                                                        '
         CONTROL ADD LABEL,   ghScheme, %SCHEME_00_TEXT + 1 + (i * 6), "Scheme " + FORMAT$(i - 1), 64, 23 + (i * 11), 50, 10, %SS_CENTERIMAGE   '
      END IF                                                      '
      CONTROL SET COLOR    ghScheme, %SCHEME_00_TEXT + 1 + (i * 6), gENV.GetClr(i, 1), gENV.GetClr(i, 2) '
      CONTROL SET FONT     ghScheme, %SCHEME_00_TEXT + 1 + (i * 6), gScrFont  '
      CONTROL ADD LABEL,   ghScheme, %SCHEME_00_TEXT + 2 + (i * 6), "BG2 Alternative", 114, 23 + (i * 11), 75, 10, %SS_CENTERIMAGE  '
      CONTROL SET COLOR    ghScheme, %SCHEME_00_TEXT + 2 + (i * 6), gENV.GetClr(i, 1), gENV.GetClr(i, 3) '
      CONTROL SET FONT     ghScheme, %SCHEME_00_TEXT + 2 + (i * 6), gScrFont  '

      CONTROL ADD GRAPHIC, ghScheme, %SCHEME_00_TEXT + 3 + (i * 6), "", 198, 22 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY  '
      CONTROL SET USER     ghScheme, %SCHEME_00_TEXT + 3 + (i * 6), 1, i   '
      CONTROL SET USER     ghScheme, %SCHEME_00_TEXT + 3 + (i * 6), 2, 1   '
      GRAPHIC ATTACH       ghScheme, %SCHEME_00_TEXT + 3 + (i * 6), REDRAW '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i, 1), 0   '
      DLGToolTipSet(GetDlgItem(ghScheme, %SCHEME_00_Text + 3 + (i * 6)), " Click to choose SCHEME ForeGround color ")   '

      CONTROL ADD GRAPHIC, ghScheme, %SCHEME_00_TEXT + 4 + (i * 6), "", 213, 22 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY  '
      CONTROL SET USER     ghScheme, %SCHEME_00_TEXT + 4 + (i * 6), 1, i   '
      CONTROL SET USER     ghScheme, %SCHEME_00_TEXT + 4 + (i * 6), 2, 2   '
      GRAPHIC ATTACH       ghScheme, %SCHEME_00_TEXT + 4 + (i * 6), REDRAW '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i, 2), 0   '
      DLGToolTipSet(GetDlgItem(ghScheme, %SCHEME_00_TEXT + 4 + (i * 6)), " Click to choose SCHEME BackGround 1 color ") '

      CONTROL ADD GRAPHIC, ghScheme, %SCHEME_00_TEXT + 5 + (i * 6), "", 229, 22 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY  '
      CONTROL SET USER     ghScheme, %SCHEME_00_TEXT + 5 + (i * 6), 1, i   '
      CONTROL SET USER     ghScheme, %SCHEME_00_TEXT + 5 + (i * 6), 2, 3   '
      GRAPHIC ATTACH       ghScheme, %SCHEME_00_TEXT + 5 + (i * 6), REDRAW '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i, 3), 0   '
      DLGToolTipSet(GetDlgItem(ghScheme, %SCHEME_00_TEXT + 5 + (i * 6)), " Click to choose SCHEME BackGround 2 color ") '

   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Add the HiLites Tab                                                                          |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 8, 0, "Hilights", CALL DlgOptionsCallBack TO ghHiLites  '
   CONTROL ADD LABEL, ghHiLites, %HILITES_HEADING1, "Hilight Color Name", 17 , 2, 150, 12 '
   CONTROL SET COLOR  ghHiLites, %HILITES_HEADING1, %YELLOW, -2   '
   CONTROL ADD LABEL, ghHiLites, %HILITES_HEADING2, "FG   BG1 BG2", 98 , 2, 250, 12 '
   CONTROL SET COLOR  ghHiLites, %HILITES_HEADING2, %YELLOW, -2   '
   CONTROL ADD LABEL, ghHiLites, %HILITES_HEADING3, "The letters in parens are used as color-setting codes in SPFLite macros", 2 , 195, 250, 12 '
   CONTROL SET COLOR  ghHiLites, %HILITES_HEADING3, %YELLOW, -2   '
   FOR i = 0 TO 14                                                '
      CONTROL ADD LABEL, ghHiLites, %HILITES_01_TEXT + (i * 1), "(" + MID$(gHiLitesChrs, (i + 1), 1) + ") " + gHiLites(i + 1), 17, 24 + (i * 11), 70, 10 '
      CONTROL SET COLOR  ghHiLites, %HILITES_01_TEXT + (i * 1), gENV.GetClr(i + 32, 1), gENV.GetClr(i + 32, 2) '
      CONTROL SET FONT   ghHiLites, %HILITES_01_TEXT + (i * 1), gScrFont   '

      CONTROL ADD GRAPHIC, ghHiLites, %HILITES_01_FG + (i * 3), "", 98, 22 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY '
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + (i * 3), 1, i + 32 ' Pass HiLite Scheme number
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + (i * 3), 2, 1   ' Pass FG/BG1/BG2
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + (i * 3), 3, %HILITES_01_TEXT + (i * 1)  ' Pass back Text control ID
      GRAPHIC ATTACH ghHiLites, %HILITES_01_FG + (i * 3), REDRAW  '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i + 32, 1), 0 '
      DLGToolTipSet(GetDlgItem(ghHiLites, %HILITES_01_FG + (i * 3)), " Click to choose HILITE ForeGround color ") '

      CONTROL ADD GRAPHIC, ghHiLites, %HILITES_01_FG + 1 + (i * 3), "", 113, 22 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY  '
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + 1 + (i * 3), 1, i + 32   ' Pass HiLite Scheme number
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + 1 + (i * 3), 2, 2  ' Pass FG/BG1/BG2
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + 1 + (i * 3), 3, %HILITES_01_TEXT + (i * 1) ' Pass back Text control ID
      GRAPHIC ATTACH ghHiLites, %HILITES_01_FG + 1 + (i * 3), REDRAW '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i + 32, 2), 0 '
      DLGToolTipSet(GetDlgItem(ghHiLites, %HILITES_01_FG + 1 + (i * 3)), " Click to choose HILITE BackGround 1 color ") '

      CONTROL ADD GRAPHIC, ghHiLites, %HILITES_01_FG + 2 + (i * 3), "", 129, 22 + (i * 11), 12, 12, %WS_BORDER OR %SS_NOTIFY  '
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + 2 + (i * 3), 1, i + 32   ' Pass HiLite Scheme number
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + 2 + (i * 3), 2, 3  ' Pass FG/BG1/BG2
      CONTROL SET USER   ghHiLites, %HILITES_01_FG + 2 + (i * 3), 3, %HILITES_01_TEXT + (i * 1) ' Pass back Text control ID
      GRAPHIC ATTACH ghHiLites, %HILITES_01_FG + 2 + (i * 3), REDRAW '
      GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i + 32, 3), 0 '
      DLGToolTipSet(GetDlgItem(ghHiLites, %HILITES_01_FG + 2 + (i * 3)), " Click to choose HILITE BackGround 2 color ") '

   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Config Tab                                                                           |
   '-----------------------------------------------------------------------------------------------+
   TAB INSERT PAGE ghOpt, %TAB_CONTROL, 9, 0, "Config", CALL DlgOptionsCallBack TO ghConfig  '

   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1,   "The following Config values apply to the Instance: ", 4, 4, 300, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1,   %WHITE, -2       '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+1, MID$(gSQL.Optname, 2), 180, 4, 150, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+1, %YELLOW, -2      '

   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+2, "This tab is for ADVANCED users only", 4, 15, 375, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+2, %YELLOW, -2      '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+3, "If you are happy with SPFLite's previous handling of Options and the location of the SPFLite", 4, 25, 375, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+3, %RGB_GAINSBORO, -2  '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+4, "folder, or have not reviewed 'Working With Instances', leave these settings alone", 4, 35, 375, 12  '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+4, %RGB_GAINSBORO, -2  '

   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+5, "The options below control the degree of sharing of configuration data", 4, 50, 375, 12  '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+5, %WHITE, -2       '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+6, "That is, some items can be shared with all Instances, and others can be maintained", 4, 60, 375, 12 '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+6, %WHITE, -2       '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+7, "uniquely for this Instance", 4, 70, 375, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+7, %WHITE, -2       '

   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+8, "NOTES:", 4, 90, 375, 12  '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+8, %YELLOW, -2      '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+9, "1. ", 4, 100, 375, 12 '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+9, %YELLOW, -2      '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+10, "If You change an item from Shared to Unique, the initial unique settings will be copied from the", 15, 100, 375, 12  '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+10, %WHITE, -2      '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+11, "DEFAULT Instance", 15, 110, 375, 12 '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+11, %WHITE, -2      '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+14, "2. ", 4, 120, 375, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+14, %YELLOW, -2     '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+15, "A restart of SPFLite is generally needed to have these changes take effect", 15, 120, 375, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+15, %WHITE, -2      '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+16, "3. ", 4, 130, 375, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+16, %YELLOW, -2     '
   CONTROL ADD LABEL, ghConfig, %CONFIG_TEXT1+17, "Changing Config folder locations requires the folder structure be built beforehand", 15, 130, 375, 12 '
   CONTROL SET COLOR  ghConfig, %CONFIG_TEXT1+17, %WHITE, -2      '

   t = gSQL.GetString("O", "HomeEFTName", ""): i = IIF(t = "DEFAULT", 0, 1)   '
   DLGAddCheck(ghConfig, %CONFIG_HOMEEFTNAME, i, 15, 140, 250, "Select (Tick) if the EFT table is maintained uniquely") '
   DLGToolTipSet(GetDlgItem(ghConfig, %CONFIG_HOMEEFTNAME), _     '
                    " Select (Tick) if you want the EFT (Extended File Type) table maintained uniquely for this Instance ")   '
   CONTROL SET USER   ghConfig, %CONFIG_HOMEEFTNAME, 1, i         ' Save starting value
   t = gSQL.GetString("O", "HomeKbdName", ""): i = IIF(t = "DEFAULT", 0, 1)   '
   DLGAddCheck(ghConfig, %CONFIG_HOMEKBDNAME, i, 15, 150, 250, "Select (Tick) if the Keyboard table is maintained uniquely")  '
   DLGToolTipSet(GetDlgItem(ghConfig, %CONFIG_HOMEKBDNAME), _     '
                    " Select (Tick) if you want the Keyboard mapping table maintained uniquely for this Instance ")  '
   CONTROL SET USER   ghConfig, %CONFIG_HOMEKBDNAME, 1, i         ' Save starting value
   t = gSQL.GetString("O", "HomeRtrName", ""): i = IIF(t = "DEFAULT", 0, 1)   '
   DLGAddCheck(ghConfig, %CONFIG_HOMERTRNAME, i, 15, 160, 250, "Select (Tick) if the Command Retrieve table is maintained uniquely")   '
   DLGToolTipSet(GetDlgItem(ghConfig, %CONFIG_HOMERTRNAME), _     '
                    " Select (Tick) if you want the Command Retrieve table maintained uniquely for this Instance ")  '
   CONTROL SET USER   ghConfig, %CONFIG_HOMERTRNAME, 1, i         ' Save starting value
   t = gSQL.GetString("O", "HomeSetName", ""): i = IIF(t = "DEFAULT", 0, 1)   '
   DLGAddCheck(ghConfig, %CONFIG_HOMESETNAME, i, 15, 170, 250, "Select (Tick) if the SET variable table is maintained uniquely") '
   DLGToolTipSet(GetDlgItem(ghConfig, %CONFIG_HOMESETNAME), _     '
                    " Select (Tick) if you want the SET variable table maintained uniquely for this Instance ")   '
   CONTROL SET USER   ghConfig, %CONFIG_HOMESETNAME, 1, i         ' Save starting value

   CONTROL ADD LABEL, ghConfig, %CONFIG_HOMEDATA_TEXT, "Location for the SPFLite Data storage folders (MACROS, AUTO, STATE etc.)", 15, 185, 375, 12   '
   CONTROL SET COLOR  ghConfig, %CONFIG_HOMEDATA_TEXT, %WHITE, -2 '
   CONTROL ADD TEXTBOX,ghConfig, %CONFIG_HOMEDATA, gENV.HomeData, 15, 197, 190, 11, %ES_AUTOHSCROLL   '

   '-----------------------------------------------------------------------------------------------+
   '- DISPLAY the Options DIALOG BOX                                                               |
   '-----------------------------------------------------------------------------------------------+
   TAB SELECT ghOpt, %TAB_CONTROL, StartPg                        '
   GRAPHIC REDRAW                                                 '
   KbdPopSave                                                     ' Ready for pop-up
   DIALOG SHOW MODAL ghOpt CALL DlgOptionsCallBack                '
   KbdPopRestore                                                  ' Reset popup state
   MExit                                                          '
END SUB                                                           '

SUB      DispPrint()                                              '
'--------------------------------------------------------------------------------------------------+
'- Build and display the PRINT FORMAT dialog                                                       |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Get printer attached                                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE PrinterOpen("") THEN                                ' Get printer open
      DoMessageBox("Can't attach default printer, current printer info may be incorrect.", %MB_OK OR %MB_USERICON, "Print Setup")   '
   END IF                                                         '
   XPRINT CANCEL                                                  ' Cancel
   XPRINT CLOSE                                                   ' and close it

   '-----------------------------------------------------------------------------------------------+
   '- Build the Dialog                                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG FONT DEFAULT "Tahoma", 10 / gFontScale, 0, 0            '
   DIALOG NEW PIXELS, ghWnd, "SPFLite Print Setup", , , 700, 430, %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR _ '
                            %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR _ '
                            %DS_SETFONT, %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO ghPrt   '
   DIALOG SET COLOR ghPrt, %RGB_GAINSBORO, %RGB_GAINSBORO         '

   '-----------------------------------------------------------------------------------------------+
   '- Add the DONE and CANCEL buttons                                                              |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD BUTTON,  ghPrt, %PRINT_DONE, "&Done", 600, 400, 75, 24, %WS_BORDER   '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_DONE), " Press Done once you have made all desired changes. ") '

   '-----------------------------------------------------------------------------------------------+
   '- Add the printer information                                                                  |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghPrt, %PRINT_PTEXT1, "Current Printer", 4, 10, 150, 16 '
   CONTROL SET COLOR     ghPrt, %PRINT_PTEXT1, %RGB_DARKBLUE, -2  '
   CONTROL ADD LABEL,    ghPrt, %PRINT_INIPrtName_TEXT, "Printer: " + gENV.PrtName, 10, 35, 250, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_INIPrtName_TEXT, %BLACK, %RGB_GAINSBORO   '
   CONTROL SET FONT      ghPrt, %PRINT_INIPrtName_TEXT, gFixedFont   '
   CONTROL ADD LABEL,    ghPrt, %PRINT_INIPrtOrient_TEXT, "Orientation: " + IIF$(gENV.PrtOrient = 1, "Portrait", "Landscape"), 10, 60, 250, 16  '
   CONTROL SET COLOR     ghPrt, %PRINT_INIPrtOrient_TEXT, %BLACK, %RGB_GAINSBORO '
   CONTROL SET FONT      ghPrt, %PRINT_INIPrtOrient_TEXT, gFixedFont '
   CONTROL ADD LABEL,    ghPrt, %PRINT_INIPrtPaper_TEXT, "Paper: " + gPrtPaper, 10, 85, 250, 16 '
   CONTROL SET COLOR     ghPrt, %PRINT_INIPrtPaper_TEXT, %BLACK, %RGB_GAINSBORO  '
   CONTROL SET FONT      ghPrt, %PRINT_INIPrtPaper_TEXT, gFixedFont  '
   CONTROL ADD BUTTON,   ghPrt, %PRINT_PCHOOSE, "Choose Printer", 40, 120, 100, 24, %WS_BORDER  '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_PCHOOSE), " Press to change your printer choice. ")   '

   CONTROL ADD LINE, ghPrt, %PRINT_VLine, "", 350, 2, 3, 148      '

   '-----------------------------------------------------------------------------------------------+
   '- Add the Font data                                                                            |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghPrt, %PRINT_FTEXT1, "Current Font", 354, 10, 150, 16  '
   CONTROL SET COLOR     ghPrt, %PRINT_FTEXT1, %RGB_DARKBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL,    ghPrt, %PRINT_FNAME_TEXT, "Fontname: " + gENV.PrtFontName, 360, 35, 250, 16  '
   CONTROL SET COLOR     ghPrt, %PRINT_FNAME_TEXT, %BLACK, %RGB_GAINSBORO  '
   CONTROL SET FONT      ghPrt, %PRINT_FNAME_TEXT, gFixedFont     '
   CONTROL ADD LABEL,    ghPrt, %PRINT_FPOINT_TEXT, "Pitch: " + gENV.PrtFontPitch, 360, 60, 250, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_FPOINT_TEXT, %BLACK, %RGB_GAINSBORO '
   CONTROL SET FONT      ghPrt, %PRINT_FPOINT_TEXT, gFixedFont    '
   CONTROL ADD LABEL,    ghPrt, %PRINT_FBOLD_TEXT, "Bold: " + IIF$(gENV.PrtFontStyle = "0", "Off", "On"), 360, 85, 250, 16 '
   CONTROL SET COLOR     ghPrt, %PRINT_FBOLD_TEXT, %BLACK, %RGB_GAINSBORO  '
   CONTROL SET FONT      ghPrt, %PRINT_FBOLD_TEXT, gFixedFont     '
   CONTROL ADD BUTTON,   ghPrt, %PRINT_FCHOOSE, "Choose Font", 390, 120, 100, 24, %WS_BORDER '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_FCHOOSE), " Press to change your Font choice. ")   '

   CONTROL ADD LINE, ghPrt, %PRINT_HLine, "", 2, 148, 698, 3      '

   '-----------------------------------------------------------------------------------------------+
   '- Add margin values                                                                            |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghPrt, %PRINT_MTEXT1, "Page margins", 4, 152, 75, 16 '
   CONTROL SET COLOR     ghPrt, %PRINT_MTEXT1, %RGB_DARKBLUE, %RGB_GAINSBORO  '
   CONTROL ADD CHECKBOX, ghPrt, %PRINT_METRIC, "Use Metric (mm) instead of inches? ", 85, 152, 350, 16, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET CHECK     ghPrt, %PRINT_METRIC, gENV.PrtMetric     '
   CONTROL SET COLOR     ghPrt, %PRINT_METRIC, %RGB_DARKBLUE, %RGB_GAINSBORO  '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_METRIC), " Select if you prefer margins in millimeters, else settings are in inches? ")   '

   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_TM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtTMargin * 25.4, gENV.PrtTMargin), "0.00"), 354, 175, 50, 20   '
   CONTROL SET FONT      ghPrt, %PRINT_TM, gFixedFont             '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_TM), " Enter the page top margin space. ")   '
   CONTROL ADD LABEL,    ghPrt, %PRINT_TM_TEXT, "Page top margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)"), 415, 175, 175, 16  '
   CONTROL SET COLOR     ghPrt, %PRINT_TM_TEXT, %BLACK, %RGB_GAINSBORO  '

   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_BM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtBMargin * 25.4, gENV.PrtBMargin), "0.00"), 4, 175, 50, 20  '
   CONTROL SET FONT      ghPrt, %PRINT_BM, gFixedFont             '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_BM), " Enter the page bottom margin space. ")   '
   CONTROL ADD LABEL,    ghPrt, %PRINT_BM_TEXT, "Page bottom margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)"), 60, 175, 175, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_BM_TEXT, %BLACK, %RGB_GAINSBORO  '

   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_RM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtRMargin * 25.4, gENV.PrtRMargin), "0.00"), 354, 201, 50, 20   '
   CONTROL SET FONT      ghPrt, %PRINT_RM, gFixedFont             '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_RM * 25.4), " Enter the page right margin space. ")   '
   CONTROL ADD LABEL,    ghPrt, %PRINT_RM_TEXT, "Page right margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)"), 415, 201, 175, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_RM_TEXT, %BLACK, %RGB_GAINSBORO  '

   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_LM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtLMargin * 25.4, gENV.PrtLMargin), "0.00"), 4, 201, 50, 20  '
   CONTROL SET FONT      ghPrt, %PRINT_LM, gFixedFont             '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_LM), " Enter the page left margin space. ")  '
   CONTROL ADD LABEL,    ghPrt, %PRINT_LM_TEXT, "Page left margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)"), 60, 201, 175, 16  '
   CONTROL SET COLOR     ghPrt, %PRINT_LM_TEXT, %BLACK, %RGB_GAINSBORO  '

   CONTROL ADD CHECKBOX, ghPrt, %PRINT_BANDING, "Print band stripes? ", 4, 228, 130, 16, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET CHECK     ghPrt, %PRINT_BANDING, gENV.PrtBanding   '
   CONTROL SET COLOR     ghPrt, %PRINT_BANDING, %BLACK, %RGB_GAINSBORO  '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_BANDING), " Should horizontal band stripes be added to the page for readability? ") '

   CONTROL ADD CHECKBOX, ghPrt, %PRINT_BANDLINES, "Print band lines? ", 140, 228, 130, 16, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET CHECK     ghPrt, %PRINT_BANDLINES, gENV.PrtBandLines  '
   CONTROL SET COLOR     ghPrt, %PRINT_BANDLINES, %BLACK, %RGB_GAINSBORO   '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_BANDLINES), " Should horizontal lines be added to the page for readability? ")   '

   CONTROL ADD GRAPHIC, ghPrt, %PRINT_BandingColor, "", 275, 228, 18, 18, %WS_BORDER OR %SS_NOTIFY '
   GRAPHIC ATTACH ghPrt, %PRINT_BandingColor, REDRAW              '
   GRAPHIC BOX (1, 1) - (16, 16), 20, %BLACK, gENV.PrtBandColor, 0   '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_BandingColor), " Press here to choose the Print Band Stripe/Line color. ") '
   CONTROL ADD LABEL, ghPrt, %PRINT_BandingColor_TEXT, "Print Band Stripe/Line color", 305, 228, 250, 16 '
   CONTROL SET COLOR  ghPrt, %PRINT_BandingColor_TEXT, %BLACK, %RGB_GAINSBORO '

   CONTROL ADD CHECKBOX, ghPrt, %PRINT_PCOLOR, "Print in Color? ", 475, 228, 130, 16, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET CHECK     ghPrt, %PRINT_PCOLOR, gENV.PrtPColor     '
   CONTROL SET COLOR     ghPrt, %PRINT_PCOLOR, %BLACK, %RGB_GAINSBORO   '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_PCOLOR), " Should the Print be in Color?")   '

   CONTROL ADD LINE, ghPrt, %PRINT_HLine + 1, "", 2, 248, 698, 3  '

   '-----------------------------------------------------------------------------------------------+
   '- Add page heading and footer stuff                                                            |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD CHECKBOX, ghPrt, %PRINT_HEADER, "Print page headers? ", 4, 255, 160, 16, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET CHECK     ghPrt, %PRINT_HEADER, gENV.PrtHeader     '
   CONTROL SET COLOR     ghPrt, %PRINT_HEADER, %RGB_DARKBLUE, %RGB_GAINSBORO  '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_HEADER), " Should page headers as described below be printed? ")  '

   CONTROL ADD LABEL,    ghPrt, %PRINT_HEADER_LEFT_TEXT, "Left-hand header", 4, 275, 100, 16 '
   CONTROL SET COLOR     ghPrt, %PRINT_HEADER_LEFT_TEXT, %BLACK, %RGB_GAINSBORO  '
   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_HEADER_LEFT, gENV.PrtHeaderLeft, 4, 295, 225, 20   '
   CONTROL SET FONT      ghPrt, %PRINT_HEADER_LEFT, gFixedFont    '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_HEADER_LEFT), " Enter the format string for the left side of the header line. ") '

   CONTROL ADD LABEL,    ghPrt, %PRINT_HEADER_CENTER_TEXT, "Center header", 235, 275, 200, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_HEADER_CENTER_TEXT, %BLACK, %RGB_GAINSBORO   '
   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_HEADER_CENTER, gENV.PrtHeaderCenter, 235, 295, 225, 20   '
   CONTROL SET FONT      ghPrt, %PRINT_HEADER_CENTER, gFixedFont  '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_HEADER_CENTER), " Enter the format string for the center of the header line. ")  '

   CONTROL ADD LABEL,    ghPrt, %PRINT_HEADER_RIGHT_TEXT, "Right-hand header", 465, 275, 200, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_HEADER_RIGHT_TEXT, %BLACK, %RGB_GAINSBORO '
   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_HEADER_RIGHT, gENV.PrtHeaderRight, 465, 295, 225, 20  '
   CONTROL SET FONT      ghPrt, %PRINT_HEADER_RIGHT, gFixedFont   '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_HEADER_RIGHT), " Enter the format string for the right hand of the header line. ")  '

   CONTROL ADD CHECKBOX, ghPrt, %PRINT_FOOTER, "Print page footers? ", 4, 330, 160, 16, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET CHECK     ghPrt, %PRINT_FOOTER, gENV.PrtFooter     '
   CONTROL SET COLOR     ghPrt, %PRINT_FOOTER, %RGB_DARKBLUE, %RGB_GAINSBORO  '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_FOOTER), " Should page footers as described below be printed? ")  '

   CONTROL ADD LABEL,    ghPrt, %PRINT_FOOTER_LEFT_TEXT, "Left-hand footer", 4, 345, 100, 16 '
   CONTROL SET COLOR     ghPrt, %PRINT_FOOTER_LEFT_TEXT, %BLACK, %RGB_GAINSBORO  '
   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_FOOTER_LEFT, gENV.PrtFooterLeft, 4, 365, 225, 20   '
   CONTROL SET FONT      ghPrt, %PRINT_FOOTER_LEFT, gFixedFont    '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_FOOTER_LEFT), " Enter the format string for the left side of the footer line. ") '

   CONTROL ADD LABEL,    ghPrt, %PRINT_FOOTER_CENTER_TEXT, "Center footer", 235, 345, 200, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_FOOTER_CENTER_TEXT, %BLACK, %RGB_GAINSBORO   '
   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_FOOTER_CENTER, gENV.PrtFooterCenter, 235, 365, 225, 20   '
   CONTROL SET FONT      ghPrt, %PRINT_FOOTER_CENTER, gFixedFont  '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_FOOTER_CENTER), " Enter the format string for the center of the footer line. ")  '

   CONTROL ADD LABEL,    ghPrt, %PRINT_FOOTER_RIGHT_TEXT, "Right-hand footer", 465, 345, 200, 16   '
   CONTROL SET COLOR     ghPrt, %PRINT_FOOTER_RIGHT_TEXT, %BLACK, %RGB_GAINSBORO '
   CONTROL ADD TEXTBOX,  ghPrt, %PRINT_FOOTER_RIGHT, gENV.PrtFooterRight, 465, 365, 225, 20  '
   CONTROL SET FONT      ghPrt, %PRINT_FOOTER_RIGHT, gFixedFont   '
   DLGToolTipSet(GetDlgItem(ghPrt, %PRINT_FOOTER_RIGHT), " Enter the format string for the right hand of the footer line. ")  '

   '-----------------------------------------------------------------------------------------------+
   '- DISPLAY the PRINT FORMAT DIALOG BOX                                                          |
   '-----------------------------------------------------------------------------------------------+
   GRAPHIC REDRAW                                                 '
   KbdPopSave                                                     ' Ready for pop-up
   DIALOG SHOW MODAL ghPrt, CALL DlgPrintCallBack                 '
   KbdPopRestore                                                  ' Reset popup state
   TAB SELECT ghWnd, %IDC_SPFLiteTAB, TP.PgNumber                 ' Select its tab
   MExit                                                          '
END SUB                                                           '

CALLBACK FUNCTION DlgANSICallBack () AS LONG                      '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by the PRINT FORMAT Dialog                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL Txt1, txtBin, txtAnsi AS STRING, cRow, cCol AS LONG, MSG AS ASCIIZ * 100   '
LOCAL xRow AS LONG, xCol AS LONG                                  '

LOCAL dlg_PrfGetX2APtr AS LONG                                    ' ptr to translation table
LOCAL dlg_colMode AS LONG                                         '
LOCAL dlg_hANSI AS DWORD                                          '

LOCAL ptr_ansiSource AS DWORD                                     '
DIM   dlg_ansiSource() AS STRINGZ * 32 AT ptr_ansiSource          '

   dlg_hANSI = CB.HNDL                                            '

   DIALOG GET USER dlg_hANSI, %uda_colMode TO dlg_colMode         '
   DIALOG GET USER dlg_hANSI, %uda_PrfGetX2APtr TO dlg_PrfGetX2APtr  '

   DIALOG GET USER dlg_hANSI, %uda_ansiSource TO ptr_ansiSource   '
   REDIM dlg_ansiSource(0) AS STRINGZ * 32 AT ptr_ansiSource      '

   '-----------------------------------------------------------------------------------------------+
   '- in non-ANSI mode, we "lie" and say that an EBCDIC (or other) char is put in clipboard        |
   '- in reality, we ONLY put ANSI data in clipboard, because that is the only kind it can have    |
   '-----------------------------------------------------------------------------------------------+

   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- Left Button, put selected chr in clipboard                                                |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_LBUTTONDOWN                                        '
         Txt1 = ""                                                ' Null for left click
         GOSUB getchar                                            ' Go get character


      '--------------------------------------------------------------------------------------------+
      '- Right Button, ADD selected chr to clipboard                                               |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_RBUTTONUP                                          '
         ClipBoardGet(Txt1)                                       ' Get any current text to start
         Txt1 = PARSE$(Txt1, $CRLF, 1)                            ' Get 1st 'line'
         GOSUB getchar                                            '

      '--------------------------------------------------------------------------------------------+
      '- Final Dialog termination                                                                  |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_DESTROY                                            ' Sent when the dialog is being destroyed
         RESET dlg_hANSI                                          ' Kill hook

   END SELECT                                                     '

   EXIT FUNCTION                                                  '

'--------------------------------------------------------------------------------------------------+
'- Figure out which chr pointed to, add to clipboard                                               |
'--------------------------------------------------------------------------------------------------+
getchar:                                                          '
   IF LO(WORD,CB.LPARAM) = 0 THEN EXIT FUNCTION                   ' If invalid location, ignore
   IF HI(WORD,CB.LPARAM) = 0 THEN EXIT FUNCTION                   '
   cCol = CEIL(LO(WORD,CB.LPARAM) / gFontWidth)                   ' Calc where click was
   cRow = CEIL(HI(WORD,CB.LPARAM) / gFontHeight)                  '

   xRow = cRow - 3                                                ' form relative-0 row value
   xCol = (cCol - 4) \ 3                                          ' form relative-0 col value

   IF xRow < 0 OR xRow > 15 THEN EXIT FUNCTION                    ' Ignore headings
   IF xCol < 0 OR xCol > 15 THEN EXIT FUNCTION                    ' and clipboard line

   IF dlg_colMode THEN                                            '
      txtBin = CHR$(xCol * 16 + xRow)                             ' Get character in col mode
   ELSE                                                           '
      txtBin = CHR$(xRow * 16 + xCol)                             ' Get character in row mode
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '-  at this point, 'txtBin' is the NATIVE binary value, which is either ANSI or EBCDIC          |
   '-----------------------------------------------------------------------------------------------+

   txtAnsi = txtBin                                               ' Save ANSI version

   IF xRow + xCol = 0 THEN EXIT FUNCTION                          ' Don't store NUL

   '-----------------------------------------------------------------------------------------------+
   '-  if we are in ANSI mode, ANSI and SOURCE are the same thing                                  |
   '-  if not in ANSI mode, txtAnsi actually has a 'binary' value (like EBCDIC)                    |
   '-  so we have to convert it from its non-ANSI source to an ANSI one                            |
   '-                                                                                              |
   '-  the ANSI mode we are checking is the mode in effect when the popup was launched             |
   '-  we can't check gfANSIMode, because that changes each time the current edit                  |
   '-  screen is changed to a different file, which may have a different source attribute          |
   '-----------------------------------------------------------------------------------------------+

   IF dlg_PrfGetX2APtr <> 0 THEN                                  ' If not ANSI mode
      TP.Translate(txtAnsi, dlg_PrfGetX2APtr)                     ' Get the ANSI equivalent
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '-  New format on bottom of ANSI popup, with new line added:                                    |
   '-                                                                                              |
   '-  Dec Hex Chr Len Current ANSI Clipboard:                                                     |
   '-  051 33 '3'  6  "ABC123"                                                                     |
   '-                 |                                                                            |
   '-  1234567890123456|                                                                           |
   '-----------------------------------------------------------------------------------------------+

   Txt1 += txtAnsi                                                ' Add to string

   MSG = FORMAT$(ASC(txtBin), "000") + "  " + HEX$(ASC(txtBin), 2) _ '
      + " '" + txtAnsi + "'" + DEC$(LEN(Txt1), -3) + " " + $DQ    '

   ClipBoardSet(Txt1)                                             ' Send it to the Clipboard

   GRAPHIC ATTACH dlg_hANSI, 5001                                 ' Set as the default graphic area
   GRAPHIC SET FONT gScrFont                                      ' Set the desired font

   GRAPHIC COLOR gTxtLoFG, gTxtLoBG1                              '

   '-----------------------------------------------------------------------------------------------+
   '- the caption "Dec Hex Chr Len Current ANSI Clipboard:" does not need to be redrawn here       |
   '-----------------------------------------------------------------------------------------------+

   GRAPHIC SET POS (1, 22 * gFontHeight)                          ' Set position for last row

   GRAPHIC PRINT MSG + Txt1 + $DQ + SPACE$(50)                    ' Print the next ANSI char

   GRAPHIC REDRAW                                                 '
   RETURN                                                         '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgCallback()                                   '
'--------------------------------------------------------------------------------------------------+
'- Main Dialog's Callback Procedure                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL x, y, PageNo AS LONG                                        '
LOCAL MSG AS kbMsg, pDrop AS LONG, sFiles, fn, Factor, tt AS STRING  '
LOCAL ptnmhdr AS NMHDR PTR                                        ' Notify msg header
LOCAL lpnm AS NMMOUSE PTR                                         '
LOCAL tRow, tCol, i, j, k AS LONG                                 '
LOCAL p AS POINTAPI                                               '
STATIC pDataToGet AS COPYDATASTRUCT POINTER                       ' WM_COPYDATA data
STATIC pBuffer    AS ASCIIZ PTR                                   '
STATIC aRow, aCol, WentMin AS LONG                                '
STATIC StartRow, StartCol, LastX, LastY, DblClick AS LONG         ' For mouse select
STATIC LDownTime, HoverTime AS DOUBLE                             ' To time mouse events
STATIC dbi AS LONG                                                '
STATIC ti AS NOTIFYICONDATA                                       '
STATIC hScrollClr AS LONG                                         '

   IF CB.HNDL <> ghWnd THEN                                       '
      GOTO PageDialog                                             '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle messages related to the main ghWnd Dialog                                             |
   '-----------------------------------------------------------------------------------------------+
   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- Set BG color of the scrollbar                                                             |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_CTLCOLORSCROLLBAR                                  '
         FUNCTION = hScrollClr                                    '

      '--------------------------------------------------------------------------------------------+
      '- Right Click on Tab Header                                                                 |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_ContextMenu                                        '
         LOCAL HT AS TC_HitTestInfo                               '
         GetCursorPos HT.pt : ScreenToClient ghTab, HT.pt         ' Tab coordinates of mouse
         PageNo = SendMessage(ghTab, %TCM_HitTest, 0, VARPTR(HT)) + 1   ' Tab page under mouse at drop
         IF PageNo = 0 THEN GOTO DlgExit                          ' Leave if other than on tab header
         IF gPending THEN GOTO DlgExit                            ' File change is in message mode
         IF gTabsNum = 0 THEN EXIT SELECT                         ' Prevent Memory Access violations at termination
         j = 0                                                    ' Clear answer index
         FOR i = 1 TO gTabsNum                                    ' Search for correct TP entry
            IF ISOBJECT(gTabs(i)) THEN                            ' Is this still a valid entry?
               TP = gTabs(i)                                      ' Make it addressable
               IF PageNo = TP.PgNumber THEN                       ' This is the one, exit
                  j = i                                           ' Save the winner
                  EXIT FOR                                        '
               END IF                                             '
            END IF                                                '
         NEXT i                                                   '
         IF j = 0 THEN EXIT SELECT                                ' Bail out if we didn't find a valid Tab
         IF IsFMTab THEN                                          ' The FM Tab?
            IF (TP.AttnDo AND %SaveReq) THEN                      ' Anything pending?
               TP.SaveReq                                         ' Save Req list if anything pending
               TPDOset(%LoadReq)                                  ' Ensure it's re-loaded
            END IF                                                '
         END IF                                                   '
         DoCmdInOtherTab(j, "END ")                               ' Try a END command

      '--------------------------------------------------------------------------------------------+
      '- Dialog is being initialized                                                               |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_INITDIALOG                                         '
         '-----------------------------------------------------------------------------------------+
         '- Initialize the ScrollBar                                                               |
         '-----------------------------------------------------------------------------------------+
         hScrollClr = CreateSolidBrush(RGB(196, 196, 196))        ' ScrollBar BG color
         IF gENV.VScrollBar THEN                                  ' Doing ScrollBar?
            SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, gFM_Top_File_Line + gFM_List_Height - 1  '
            SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, TP.LastLine + 3  '
            SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, 1            '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Set Keyboard Hook                                                                      |
         '-----------------------------------------------------------------------------------------+
         ghKbrdHook = SetWindowsHookEx(%WH_KEYBOARD, CODEPTR(MainAKeyHook), _ '
                     0, GetCurrentThreadId)                       '
         IF IsTPNsrtFlag THEN OnTPNsrtSave ELSE OffTPNsrtSave     ' Set initial Insert status
         OffTPNsrtData                                            '
         CaretDestroy                                             '
         CaretCreate                                              ' Create the caret
         DoCursor                                                 ' Set Cursor
         CaretShow                                                ' Show it
         gENV.SetINITimeStamp                                     '
         DoStatusBar($AllStatusBarBoxes)                          ' re-Do the StatusBar box
         gENV.InitDone = %True                                    ' Say all Initialization is done


      CASE %WM_GETMINMAXINFO

         LOCAL pMMI AS MINMAXINFO PTR                             ' Point to MINMAXINFO structure
         pMMI = CBLPARAM                                          '
         @pMMI.ptMinTrackSize.x = 500                             ' Set the minimum width and height (in pixels)
         @pMMI.ptMinTrackSize.y = 300                             ' Min height
         FUNCTION = 0                                             '

      CASE %WM_SIZE                                               '
         IF gTabsNum > 0 THEN                                     ' Initialized?
            IF CB.WPARAM = %SIZE_MAXIMIZED THEN                   ' Maximized?
               WindowSize()                                       ' Go do what the user wants
               gENV.Maximized = %True                             ' Remember we're maximixed
               gENV.SetINITimeStamp                               '
               WentMin = %False                                   '
               IF IsFMTab THEN                                    ' The FM Tab?
                  IF (TP.AttnDo AND %SaveReq) THEN                ' Anything pending?
                     TP.SaveReq                                   ' Save Req list if anything pending
                     TPDOset(%LoadReq)                            ' Ensure it's re-loaded
                  END IF                                          '
               END IF                                             '
            ELSEIF CB.WPARAM = %SIZE_RESTORED THEN                ' Restored?
               WindowSize()                                       ' Go do what the user wants
               gENV.Maximized = %False                            ' Remember we're normal
               gENV.SetINITimeStamp                               '
               IF WentMin THEN                                    ' Coming back from minimized?
                  WentMin = %False                                '
                  TP.DispScreen                                   ' Make sure we actually display something
               END IF                                             '
            ELSEIF CB.WPARAM = %SIZE_MINIMIZED THEN               ' Minimized
               IF IsFMTab THEN                                    ' The FM Tab?
                  IF (TP.AttnDo AND %SaveReq) THEN                ' Anything pending?
                     TP.SaveReq                                   ' Save Req list if anything pending
                     TPDOset(%LoadReq)                            ' Ensure it's re-loaded
                  END IF                                          '
               END IF                                             '
               WentMin = %True                                    '
            END IF                                                '
         END IF                                                   '
         DoStatusBar($AllStatusBarBoxes)                          ' re-Do the StatusBar box
         FUNCTION = 0                                             '

      '--------------------------------------------------------------------------------------------+
      '- Our window is being activated/deactivated                                                 |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_ACTIVATEAPP                                        '
         IF gTabsNum = 0 THEN FUNCTION = 0: GOTO DlgExit          ' Prevent Memory Access violations at termination
         IF gfDoingMsg THEN GOTO DlgExit                          ' Don't activate if doing a pop-up, let IT get control
         IF gPending THEN GOTO DlgExit                            ' File change is in message mode
         IF CB.WPARAM THEN                                        ' Being activated
            TP.CsrCol = aCol: TP.CsrRow = aRow                    '
            gfActive = %True                                      ' Tell the world we're active
            GRAPHIC ATTACH TP.PgHandle, TP.WindowID               ' Set as the default graphic area
            GRAPHIC CLEAR gTxtLoBG1                               ' Clear
            CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB              ' Set focus
            IF IsTPPTypeMode THEN _                               ' Restore PTYPE message
               TP.ErrMsgAdd(%eNone, "Entering PowerType mode, Press Enter to exit") '
            TP.LastRulCol = 0: TP.LastRulRow = 0: TP.LastPTCurs = 0  ' In case special cursors active
            TP.DispScreen                                         ' Refresh
            CaretDestroy                                          '
            CaretCreate                                           ' Create it
            DoCursor                                              ' Position it
            CaretShow                                             ' Show the caret
            FUNCTION = 0                                          ' We're done
         ELSE                                                     ' Being deactivated
            aRow = TP.CsrRow: aCol = TP.CsrCol                    '
            IF IsFMTab THEN                                       ' The FM Tab?
               IF (TP.AttnDo AND %SaveReq) THEN                   ' Anything pending?
                  TP.SaveReq                                      ' Save Req list if anything pending
                  TPDOset(%LoadReq)                               ' Ensure it's re-loaded
               END IF                                             '
            END IF                                                '
            CaretDestroy                                          ' Destroy it
            gfActive = %False                                     ' Tell the world we're NOT active
            FUNCTION = 0                                          ' We're done
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- A file has been dropped on our window                                                     |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_DROPFILES                                          ' Look for dropped files
         IF gfDoingMsg > 0 THEN GOTO DlgExit                      ' Busy doing pop-up, ignore
         IF gPending THEN GOTO DlgExit                            ' File change is in message mode
         TP.MarkKill                                              ' Kill any select box
         TP.SwapKill                                              ' Kill any Swap box
         pDrop = CBWPARAM                                         ' Copy param
         sFiles = GetDropFiles(pDrop)                             ' Go get list
         DO WHILE ISNOTNULL(sFiles)                               ' Process the list
            fn = EXTRACT$(sFiles, "|")                            ' Get next filename
            sFiles = REMAIN$(sFiles, "|")                         ' Strip it out
            '--------------------------------------------------------------------------------------+
            '- A file> or a Folder?                                                                |
            '--------------------------------------------------------------------------------------+
            IF ISFOLDER(fn) THEN                                  '
               TP = gTabs(1)                                      ' Point at FM Tab
               TP.FPath = fn + "\"                                ' Set the Path
               TP.FMask = "*"                                     ' Mask
               TP.FileListNm = ""                                 ' Remove any FList
               TPDoSet(%LoadReq): TPDoSet(%Attention)             ' Ask for refresh
               gENV.SetFMCrit(TP.DirSort, TP.DefSort, TP.FMask, gFMLayoutID) ' Set the proper criteria
               GotoTab(1, "Folder Opened", "")                    ' Setup a message
               DoPendingTabSwitch                                 ' Do the switch
               ITERATE DO                                         ' Done

            ELSE                                                  ' Else a real file
               pCmdEdit("EDIT " + $DQ + fn + $DQ)                 ' Let Edit have a go
               IF gTabGoTo.Number <> 0 THEN DoPendingTabSwitch    '
               gCaretCtr = 0                                      ' Force caret out
               CaretCreate                                        ' Create it
               DoCursor                                           ' Position it
               CaretShow                                          ' Show the caret
            END IF                                                '
         LOOP                                                     '

      '--------------------------------------------------------------------------------------------+
      '- Someone is sending us data                                                                |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_COPYDATA                                           ' We are receiving data
         IF gfDoingMsg > 0 THEN GOTO DlgExit                      ' Busy doing popup, ignore
         IF gPending THEN GOTO DlgExit                            ' File change is in message mode
         pDataToGet = CBLPARAM                                    ' Pointer is in CBLPARAM
         pBuffer    = @pDataToGet.lpData                          ' Pointer to data string
         tt = TRIM$(@pBuffer)                                     ' Get the string
         IF ISNOTNULL(tt) THEN                                    ' Actually got something?
            TP = gTabs(1)                                         ' Switch to FM to do this
            DoInitString(tt, "", "", "", %False)                  ' Go do the Open(s)
            DoPendingTabSwitch                                    ' Do any pending Tab switch
            DoPendingTabDeletes                                   ' Do any pending Tab Delete
         END IF                                                   '
         FUNCTION = 1                                             ' Say we've handled it

      '--------------------------------------------------------------------------------------------+
      '- A NOTIFY message coming in                                                                |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_NOTIFY                                             ' Notify message

         ptnmhdr = CBLPARAM                                       ' Point at notify header
         IF gPending THEN GOTO DlgExit                            ' File change is in message mode
         SELECT CASE @ptnmhdr.idFrom                              ' See where Notify from
            CASE %IDC_Statusbar                                   ' The statusbar
               IF @ptnmhdr.code = %NM_CLICK THEN                  ' A mouse click?
                  lpnm = CBLPARAM                                 ' Check the box number
                  IF @lpnm.dwItemSpec = gSBSelect AND ISFALSE IsFMTab THEN ' Select box?
                     krToggleSelect                               ' Toggle it
                  END IF                                          '
                  IF @lpnm.dwItemSpec = gSBLFlip AND IsFMTab THEN ' Layout toggle?
                     IF gFMLayoutID = "S" THEN                    ' Currently "S" Standard
                        gFMLayout = gENV.FMLayoutM: gFMLayoutID = "A" ' Switch to ALTERNATE
                     ELSE                                         ' If in forced ALTERNATE
                        gFMLayout = gENV.FMLayout: gFMLayoutID = "S" ' Switch back to STANDARD
                     END IF                                       '
                     gENV.SetFMCrit(TP.DirSort, TP.DefSort, TP.FMask, gFMLayoutID) ' Set with a new ID
                     DoStatusBar($AllStatusBarBoxes)              ' re-Do the StatusBar
                     TPDoSet(%LoadData)                           ' Request LoadData
                     TP.DispScreen                                ' and display screen
                  END IF                                          '
               END IF                                             '
         END SELECT                                               '

         SELECT CASE AS LONG CB.NMCODE                            ' What type?

            '--------------------------------------------------------------------------------------+
            '- A tab is getting control                                                            |
            '--------------------------------------------------------------------------------------+
            CASE %TCN_SELCHANGE                                   ' We're getting control
               IF gTabsNum = 0 THEN EXIT SELECT                   ' Prevent Memory Access violations at termination
               CONTROL SEND CB.HNDL, %IDC_SPFLiteTAB, %TCM_GETCURSEL,0,0 TO PageNo  '
               TP = NOTHING                                       '
               FOR i = 1 TO gTabsNum                              ' Search for correct TP entry
                  IF ISOBJECT(gTabs(i)) THEN                      ' Is this still a valid entry?
                     TP = gTabs(i)                                ' Copy the TP address
                     IF PageNo + 1 = TP.PgNumber THEN             ' This is the one, exit
                        EXIT FOR                                  '
                     END IF                                       '
                  END IF                                          '
               NEXT i                                             '
               IF ISNOTHING(TP) THEN EXIT SELECT                  ' Bail out if we didn't set TP to a valid Tab

               GRAPHIC ATTACH TP.PgHandle, TP.WindowID            ' Swap the default graphic area
               CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB           ' Regain focus.
               TP.WindowTitle                                     ' Swap the Title bar
               TP.LastPTCurs = 0                                  '
               TP.LastRulCol = 0: TP.LastRulRow = 0               ' In case crosshair cursors active
               IF IsFMTab THEN TP.AttnDo = (TP.AttnDo OR %LoadData)  ' If an FM screen, trigger a re-load
               TP.DispScreen                                      ' Refresh if the very first show
               IF gENV.VScrollBar THEN                            ' Doing ScrollBars?
                  IF IsFMTab THEN                                 ' FM?
                     SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, gFM_Top_File_Line + gFM_List_Height - 1  '
                     SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, gFMDCtr + 7   '
                     SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, TP.GPTopLine  '
                  ELSE                                            '
                     SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, gENV.ScrHeight - gENV.PFKShow   '
                     SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, TP.LastLine + 3  '
                     SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, TP.GPTopLine  '
                  END IF                                          '
               END IF                                             '
               CaretDestroy                                       '
               CaretCreate                                        ' Create it
               DoCursor                                           ' Position it
               CaretShow                                          ' Show the caret
               StatusBarSetup                                     ' Setup the status bar fields
               DoStatusBar($AllStatusBarBoxes)                    ' Make sure they're all done
               TabStackAdd(TP.PgNumber)                           '

            '--------------------------------------------------------------------------------------+
            '- A tab is losing control                                                             |
            '--------------------------------------------------------------------------------------+
            CASE %TCN_SELCHANGING                                 ' We're losing control
               IF IsTPPTypeMode THEN                              ' If PowerType mode
                  OffTPPTypeMode                                  ' Kill it
                  gPTblCount = 0                                  '
                  TP.ErrMsgReset                                  '
               END IF                                             '
               IF gTabsNum = 0 THEN EXIT SELECT                   ' Prevent Memory Access violations at termination
               IF IsFMTab THEN                                    ' The FM Tab?
                  IF (TP.AttnDo AND %SaveReq) THEN                ' Anything pending?
                     TP.SaveReq                                   ' Save Req list if anything pending
                     TPDOset(%LoadReq)                            ' Ensure it's re-loaded
                  END IF                                          '
               END IF                                             '
               CONTROL SEND CB.HNDL, %IDC_SPFLiteTAB, %TCM_GETCURSEL,0,0 TO PageNo  '
               TP = NOTHING                                       '
               FOR i = 1 TO gTabsNum                              ' Search for correct TP entry
                  IF ISOBJECT(gTabs(i)) THEN                      ' Is this still a valid entry?
                     TP = gTabs(i)                                ' Copy the TP address
                     IF PageNo + 1 = TP.PgNumber THEN EXIT FOR    ' This is the one, exit
                  END IF                                          '
               NEXT i                                             '
               IF ISNOTHING(TP) THEN EXIT SELECT                  ' Bail out if we didn't set TP to a valid Tab
               TP.MarkKill                                        ' Kill any marked text
               TP.SwapKill                                        ' Kill any swap text
               CaretHide                                          '
               CaretDestroy                                       '
               FUNCTION = 0                                       ' Allow tab swap to continue
         END SELECT                                               '

      '--------------------------------------------------------------------------------------------+
      '- A user draw item request                                                                  |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_DRAWITEM                                           '
         IF CBWPARAM = %IDC_STATUSBAR THEN                        ' Our statusbar redraw?
            StatusBarDrawItem CBHNDL, CBLPARAM                    ' Do it
         END IF                                                   '
         IF CB.WPARAM = %IDC_SPFLiteTAB THEN                      '
            TabHighLight CBHNDL, CBWPARAM, CBLPARAM               '
         END IF                                                   '
         FUNCTION = 1                                             '

      '--------------------------------------------------------------------------------------------+
      '- A USER message, either KB activity or FileWatch notify                                    |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_USER                                               ' A User message coming in
         Msg.MsgWparam = CB.WPARAM                                ' Put wParam into the UNION
         gKeyChr = Msg.kbString                                   ' Move string into gKeyChr
         MainBUserMsg()                                           ' Go analyze what came in

      '--------------------------------------------------------------------------------------------+
      '- A MouseWheel movement occurred                                                            |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_MOUSEWHEEL                                         ' Scroll wheel moved
         x = LO(WORD,CBLPARAM)                                    ' Must do different r/c calc
         y = HI(WORD,CBLPARAM)                                    ' as x/y are Screen, not Window
         IF x = 0 OR y = 0 THEN GOTO DlgExit                      '
         p.x = x: p.y = y                                         ' Convert screen to client coordinates
         ScreenToClient ghWnd, p                                  ' hWnd is your window handle
         tCol = CEIL((p.x - %GLM + 2) / gFontWidth)               ' Calc where cursor is
         tRow = CEIL(p.y + 1) / gFontHeight                       '
         IF tCol < 1 OR tCol > gENV.ScrWidth OR _                 ' Ignore any outside our window
            tRow < 1 OR tRow > gENV.ScrHeight THEN GOTO DlgExit   '
         SetPanel(tRow, tcol)                                     ' Ensure panel is correct

         INCR dbi                                                 '
         IF gfMiddleDown THEN GOTO DlgExit                        ' Ignore if Middle button down
         IF gENV.AutoScroll AND ISNULL(TRIM$(TP.pCommand)) THEN   ' Honor it at all? (i.e. no current pCommand + gENV.AutoScroll)
            i = CINT(HI(WORD, CBWPARAM))                          ' Get wheel direction and amount
            j = CINT(LO(WORD, CBWPARAM))                          ' Get Ctl keys
            Factor = FORMAT$(IIF((j AND %MK_CONTROL) = %MK_CONTROL, 4, 1)) + " M"   ' Set Factor based on Ctrl key state
            IF (j AND %MK_SHIFT) <> %MK_SHIFT THEN                ' Shift key down?
               IF IsTPPTypeMode THEN GOTO DlgExit                 ' No Up/Down in PT mode
               IF i < 0 THEN                                      ' Backward rotation
                  OnTPInsClnSupp                                  ' Suppress Insert cleanup for 1 Attn pass
                  pCmdScroll("ISCROLL DOWN " + Factor)            ' Directly Call Scroll
                  TP.DispScreen                                   ' and display screen
                  DoCursor                                        ' Set cursor
               ELSE                                               ' Forward
                  OnTPInsClnSupp                                  ' Suppress Insert cleanup for 1 Attn pass
                  pCmdScroll("ISCROLL UP " + Factor)              ' Directly call Scroll
                  TP.DispScreen                                   ' and display screen
                  DoCursor                                        ' Set cursor
               END IF                                             '
            ELSE                                                  '
               IF i < 0 THEN                                      ' Backward rotation
                  OnTPInsClnSupp                                  ' Suppress Insert cleanup for 1 Attn pass
                  pCmdScroll("ISCROLL RIGHT " + Factor)           ' Directly call Scroll
                  TP.DispScreen                                   ' and display screen
                  DoCursor                                        ' Set cursor
               ELSE                                               ' Forward
                  OnTPInsClnSupp                                  ' Suppress Insert cleanup for 1 Attn pass
                  pCmdScroll("ISCROLL LEFT " + Factor)            ' Directly call Scroll
                  TP.DispScreen                                   ' and display screen
                  DoCursor                                        ' Set cursor
               END IF                                             '
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- SYSCOMMAND                                                                                |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_SYSCOMMAND                                         '
         IF CB.HNDL <> ghWnd THEN GOTO DlgExit                    '
         IF gPending THEN GOTO DlgExit                            ' File change is in message mode
         '-----------------------------------------------------------------------------------------+
         '- Hide window and taskbar icon when minimized                                            |
         '-----------------------------------------------------------------------------------------+
         IF gENV.MinToTray THEN                                   ' Minimize to System Tray?
            IF CB.WPARAM = %SC_MINIMIZE THEN                      ' Is this Mimimize?
               DIALOG SHOW STATE CB.HNDL, %SW_HIDE: FUNCTION = 1  '
               '--------------------------------------------------------------------------------------+
               '- Add tray icon - Build the control block                                             |
               '--------------------------------------------------------------------------------------+
               ti.cbSize           = SIZEOF(ti)                   '
               ti.hWnd             = CB.HNDL                      '
               ti.uID              = GetModuleHandle(BYVAL 0)     '
               ti.uFlags           = %NIF_ICON OR %NIF_MESSAGE OR %NIF_TIP '
               ti.uCallbackMessage = %TRAY_ICON                   '
               ti.hIcon            = LoadIcon(GetModuleHandle(BYVAL 0) , "a") '
               ti.szTip            = IIF$(ISNULL(gENV.eInstance) OR gENV.eInstance = "DEFAULT", "SPFLite", "SPFLite(" + gENV.eInstance + ")")   '
               Shell_NotifyIconA %NIM_ADD, BYVAL VARPTR(ti)       ' Tell system to add it
               DestroyIcon ti.hIcon                               '
            END IF                                                '
         END IF                                                   '
         IF (CBWPARAM AND &HFFF0) = %SC_CLOSE THEN                ' Trap the [x] button and Alt-F4
            IF ISFALSE gfTermFlag THEN                            ' Been here before?
               pCmdExit("EXIT")                                   ' No, Treat as an EXIT command
               IF ISFALSE gfEndAll THEN FUNCTION = 1 ELSE FUNCTION = 0  '
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- CLOSE button pressed                                                                      |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_CLOSE                                              ' Sent when the Close button is pressed
         IF CB.HNDL <> ghWnd THEN GOTO DlgExit                    '
         IF gPending THEN GOTO DlgExit                            ' File change is in message mode
         DIALOG GET LOC ghWnd TO x, y                             ' Get location where window was
         gENV.LastScreenX = x: gENV.LastScreenY = y               ' Save them away
         gENV.SetINITimeStamp                                     '

      '--------------------------------------------------------------------------------------------+
      '- Final Dialog termination                                                                  |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_DESTROY                                            ' Sent when the dialog is being destroyed
         UnhookWindowsHookEx ghKbrdHook                           ' Kill the Keyboard hook
         ghKbrdHook = 0                                           '
         Shell_NotifyIcon %NIM_DELETE, BYVAL VARPTR(ti)           ' Remove tray icon notify
         DeleteObject(hScrollClr)                                 '

       CASE %TRAY_ICON                                            '
           '---------------------------------------------------------------------------------------+
                                                                  ' Show window when tray icon cicked                                                     |
           '---------------------------------------------------------------------------------------+
           IF CB.LPARAM = %WM_LBUTTONDOWN THEN                    ' Clicked?
              DIALOG SHOW STATE CB.HNDL, %SW_SHOW                 ' Restore it
              Shell_NotifyIconA %NIM_DELETE, BYVAL VARPTR(ti)     ' Remove Taskbar Icon
           END IF                                                 '
           IF CB.LPARAM = %WM_RBUTTONDOWN THEN                    '
                GetCursorPos p                                    '
                TrackPopupMenu ghTray, 0, p.x, p.y, 0, CB.HNDL, BYVAL %Null   '
           END IF                                                 '

        CASE %WM_COMMAND                                          '
           SELECT CASE AS LONG CB.CTL                             '
                CASE %TRAY_ABOUT                                  '
                    ? "SPFLite - " + IIF$(ISNULL(gENV.eInstance) OR gENV.eInstance = "DEFAULT", "(v" + gENV.PgmVers + ")", "(" + gENV.eInstance + ")")   '
           END SELECT                                             '
      CASE ELSE                                                   '
         EXIT FUNCTION                                            '
   END SELECT                                                     '

      GOTO DlgExit                                                '

   '-----------------------------------------------------------------------------------------------+
   '- Handle messages related to the main Tab Page                                                 |
   '-----------------------------------------------------------------------------------------------+

   PageDialog:                                                    '

   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- Left button press                                                                         |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_LBUTTONDOWN                                        '
         GOSUB GetRowCol                                          ' Get Row/Col to tRow/tCol
         LastX = LO(WORD,CBLPARAM)                                ' Save last Mouse coordinate
         LastY = HI(WORD,CBLPARAM)                                '
         IF IsTPPTypeMode AND tRow <> gPTbl(1).sRow THEN GOTO DlgExit ' Must be same as PTmode Model line
         LDownTime = TIMER                                        ' Save button down time
         TP.MarkStart(trow, tcol,StartRow, StartCol)              ' See if we start a mark area

      '--------------------------------------------------------------------------------------------+
      '- The mouse moved                                                                           |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_MOUSEMOVE                                          '
         IF gfLeftDown THEN                                       ' If Mouse is down
            gSlecthDC = GetDC(CBHNDL)                             '
            GOSUB GetRowCol                                       ' Get Row/Col to tRow/tCol
            IF ABS(LastX - LO(WORD,CBLPARAM)) < 3 AND _           ' See if minimum movement
               ABS(LastY - HI(WORD,CBLPARAM)) < 3 THEN GOTO DlgExit  '
            TP.MarkExtend(trow, tcol, StartRow, StartCol)         ' Go see if we extend an area
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Left Button Up                                                                            |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_LBUTTONUP                                          '
         gfLeftDown = %False: gfSplitDown = %False                '
         SetCursor(LoadCursor(%Null, BYVAL %IDC_ARROW))           ' Set regular cursor
         IF ISTRUE DblClick THEN                                  ' Is this the UP following a DblClick?
            DblClick = %False                                     ' Turn it off
            GOTO DlgExit                                          ' And ignore it
         END IF                                                   '
         GOSUB GetRowCol                                          ' Get Row/Col to tRow/tCol

         IF IsTPPTypeMode AND tRow <> gPTbl(1).sRow THEN GOTO DlgExit   ' Must be same as PTmode Model line
         IF (TIMER - LDownTime) < 0.3 AND _                       '
            TP.MarkGL = TP.MarkGR AND _                           '
            TP.MarkGT = TP.MarkGB THEN                            '
            TP.MarkKill                                           '
         END IF                                                   '
         IF TP.ErrMsgTblC THEN                                    ' Error being displayed
            TP.ErrMsgReset                                        ' Clear any message
            DoPrint (STRING$(gENV.ScrWidth, " "), $$TxtLo, 2, 1)  ' Clear message line
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- If we're on the FM screen                                                              |
         '-----------------------------------------------------------------------------------------+
         IF IsFMTab THEN                                          ' If we're on the FM screen
            GOSUB SetCurs                                         ' Go do it

            '--------------------------------------------------------------------------------------+
            '- If on column header line, adjust the data SORT criteria                             |
            '--------------------------------------------------------------------------------------+
            IF TP.CsrRow = gFM_Head_Line AND _                    ' Column header line?
               TP.ScreenChrHit(gFM_Head_Line, TP.CsrCol) THEN     ' And on a non-blank?

               '-----------------------------------------------------------------------------------+
               '- See which column was clicked on, eliminate Dir+ first since it's not a 'column   |
               '-----------------------------------------------------------------------------------+
               IF TP.CsrCol >= gFM_Head_Name_Left AND TP.CsrCol <= gFM_Head_Name_Left + 3 THEN  ' Somewhere over Dir. ?
                  IF RIGHT$(TP.DirSort, 1) = "+" THEN             '
                     TP.DirSort = "Dir-"                          ' Rotate through the options
                  ELSEIF RIGHT$(TP.DirSort, 1) = "-" THEN         '
                     TP.DirSort = "Dir*"                          '
                  ELSEIF RIGHT$(TP.DirSort, 1) = "*" THEN         '
                     TP.DirSort = "Dir+"                          '
                  END IF                                          '
               ELSE                                               ' Else do column scan

                  '--------------------------------------------------------------------------------+
                  '- Look at active column numbers                                                 |
                  '--------------------------------------------------------------------------------+
                  FOR i = 1 TO 20                                 ' Search active columns
                     j = TP.GetDefActCol(i)                       ' Get the column number
                     IF j = 0 THEN EXIT FOR                       ' End of active columns
                     IF TP.CsrCol >= gFMC(j).CPos AND TP.CsrCol < gFMC(j).CPos + gFMC(j).CSize THEN   ' We've found our column

                        '--------------------------------------------------------------------------+
                        '- See which column it is by name                                          |
                        '--------------------------------------------------------------------------+
                        IF gFMC(j).CField = "NAME" THEN           ' File Name?
                           tt = RIGHT$(gFMC(j).CHead, 1)          ' Get the last char
                           IF tt = "+" THEN                       '
                              TP.DefSort = "Name-"                ' Rotate through the options
                           ELSEIF tt = "-" THEN                   '
                              TP.DefSort = "Name*"                '
                           ELSEIF tt = "*" THEN                   '
                              TP.DefSort = "Name."                '
                           ELSEIF tt = "." THEN                   '
                              TP.DefSort = "Name+"                '
                           ELSE                                   '
                              TP.DefSort = "Name+"                '
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "SIZESHORT"  OR gFMC(j).CField = "SIZELONG" THEN   ' Size?
                           IF LEFT$(TP.DefSort, 4) = "Size" THEN  ' Already doing SIZE sort?
                              TP.DefSort = IIF$(TP.DefSort = "Size+", "Size-", "Size+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "Size-"                ' Swap to SIZE- sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "LINES" THEN      ' Lines?
                           IF LEFT$(TP.DefSort, 5) = "Lines" THEN ' Already doing LINES sort?
                              TP.DefSort = IIF$(TP.DefSort = "Lines+", "Lines-", "Lines+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "Lines-"               ' Swap to LINES- sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "LWDATE" OR gFMC(j).CField = "LWDATETIME" THEN  ' LWDate?
                           IF LEFT$(TP.DefSort, 6) = "LWDate" THEN   ' Already doing LWDate sort?
                              TP.DefSort = IIF$(TP.DefSort = "LWDate+", "LWDate-", "LWDate+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "LWDate-"              ' Swap to LWDATE- sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "LRDATE" OR gFMC(j).CField = "LRDATETIME" THEN  ' LRDate?
                           IF LEFT$(TP.DefSort, 6) = "LRDate" THEN   ' Already doing LRDate sort?
                              TP.DefSort = IIF$(TP.DefSort = "LRDate+", "LRDate-", "LRDate+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "LRDate-"              ' Swap to LRDATE- sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "CRDATE" OR gFMC(j).CField = "CRDATETIME" THEN  ' CRDate?
                           IF LEFT$(TP.DefSort, 6) = "CRDate" THEN   ' Already doing CRDate sort?
                              TP.DefSort = IIF$(TP.DefSort = "CRDate+", "CRDate-", "CRDate+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "CRDate-"              ' Swap to DATE- sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "ATTR" THEN       ' Attr?
                           IF LEFT$(TP.DefSort, 4) = "Attr" THEN  ' Already doing Attr sort?
                              TP.DefSort = IIF$(TP.DefSort = "Attr+", "Attr-", "Attr+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "Attr+"                ' Swap to Attr+ sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "PATH" THEN       ' Path?
                           IF LEFT$(TP.DefSort, 4) = "Path" THEN  ' Already doing Path sort?
                              TP.DefSort = IIF$(TP.DefSort = "Path+", "Path-", "Path+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "Path+"                ' Swap to Path+ sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF gFMC(j).CField = "MODE" THEN       ' Mode?
                           IF LEFT$(TP.DefSort, 4) = "Mode" THEN  ' Already doing Mode sort?
                              TP.DefSort = IIF$(TP.DefSort = "Mode+", "Mode-", "Mode+")   ' Yes, flip direction
                           ELSE                                   '
                              TP.DefSort = "Mode+"                ' Swap to Mode+ sort
                           END IF                                 '
                           gFMC(j).CHead = TP.DefSort             ' Alter it in the column definition
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        ELSEIF LEFT$(gFMC(j).CField, 3) = "PRP" THEN ' A PRPx column?
                           '-----------------------------------------------------------------------+
                           '- Special handling for Prpn columns                                    |
                           '-----------------------------------------------------------------------+
                           IF LEFT$(TP.DefSort, 4) = LEFT$(gFMC(j).CField, 4) THEN  ' Already doing THIS Prpx sort?
                              tt = RIGHT$(TP.DefSort, 1)          ' Get the current direction
                              IF tt = "+" THEN                    ' Alternate it
                                 TP.DefSort = CLIP$(RIGHT, TP.DefSort, 1) + "-"  '
                                 gFMC(j).CHead = CLIP$(RIGHT, gFMC(j).CHead, 1) + "-"  '
                              ELSE                                '
                                 TP.DefSort = CLIP$(RIGHT, TP.DefSort, 1) + "+"  '
                                 gFMC(j).CHead = CLIP$(RIGHT, gFMC(j).CHead, 1) + "+"  '
                              END IF                              '
                           ELSE                                   '
                              TP.DefSort = "PRP" + MID$(gFMC(j).CField, 4, 1) + "+" ' Swap to Prpx+ sort
                              gFMC(j).CHead = gFMC(j).CHead + "+" '
                           END IF                                 '
                           TP.DefSortCol = j                      ' Set DefSortCol
                           GOSUB ResetCols                        ' Reset other columns

                        END IF                                    '
                        EXIT FOR                                  '
                     END IF                                       '
                  NEXT i                                          '

                  TP.LastTop = 0                                  ' Kill position
               END IF                                             '
               gENV.SetFMCrit(TP.DirSort, TP.DefSort, TP.FMask, gFMLayoutID) ' Save the new values
               gENV.SetINITimeStamp                               '
               TP.AttnDo = (TP.AttnDo OR %LoadData)               ' Request a data refresh
               CaretDestroy                                       ' Hide cursor
               TP.DispScreen                                      '
               CaretCreate                                        '
               DoCursor                                           ' Turn Cursor back on
               CaretShow                                          '
               GOTO DlgExit                                       '

            '--------------------------------------------------------------------------------------+
            '- Left up click in the FM quick row                                                   |
            '--------------------------------------------------------------------------------------+
            ELSEIF TP.CsrRow = gFM_Quick_Line_1 AND TP.ScreenChrHit(TP.CsrRow, TP.CsrCol) THEN  ' Quick items?
               gENV.SetFMCrit(TP.DirSort, TP.DefSort, TP.FMask, gFMLayoutID)   ' Save the new values
               SELECT CASE AS LONG TP.CsrCol                      ' Yes, now look at column
                  CASE gFM_Quick_Pos_1 TO gFM_Quick_Pos_2 - 1     ' Within item?
                     TP.PCommand = "EDIT NEW"                     ' Create an EDIT NEW command
                     GOSUB PostAttention                          ' Post an Attention request
                  CASE gFM_Quick_Pos_2 TO gFM_Quick_Pos_3 - 1     ' Ditto for each item
                     TP.PCommand = "RC FilePath"                  '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_3 TO gFM_Quick_Pos_4 - 1     '
                     TP.PCommand = "RC Recent"                    '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_4 TO gFM_Quick_Pos_5 - 1     '
                     TP.PCommand = "RC Found"                     '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_5 TO gFM_Quick_Pos_6 - 1     '
                     TP.PCommand = "RC Open"                      '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_6 TO gFM_Quick_Pos_7 - 1     '
                     TP.PCommand = "RC Favorite"                  '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_7 TO gFM_Quick_Pos_8 - 1     '
                     TP.PCommand = "RC FLISTS"                    '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_8 TO gFM_Quick_Pos_9 - 1     '
                     TP.PCommand = "RC Paths"                     '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_9 TO gFM_Quick_Pos_10 - 1    '
                     TP.PCommand = "RC Configs"                   '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_10 TO gFM_Quick_Pos_11 - 1   '
                     TP.PCommand = "RC " + gFMQFList1             '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_11 TO gFM_Quick_Pos_12 - 1   '
                     TP.PCommand = "RC " + gFMQFList2             '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_12 TO gFM_Quick_Pos_13 - 1   '
                     TP.PCommand = "RC " + gFMQFList3             '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_13 TO gFM_Quick_Pos_14 - 1   '
                     TP.PCommand = "RC " + gFMQFList4             '
                     GOSUB PostAttention                          '
                  CASE gFM_Quick_Pos_14 TO gFM_Quick_Pos_15 - 1   '
                     TP.PCommand = "RC " + gFMQFList5             '
                     GOSUB PostAttention                          '
                  CASE >= gFM_Quick_Pos_15                        '
                     TP.PCommand = "RC " + gFMQFList6             '
                     GOSUB PostAttention                          '
               END SELECT                                         '

            '--------------------------------------------------------------------------------------+
            '- Left up click in the FM file list area                                              |
            '--------------------------------------------------------------------------------------+
            ELSEIF TP.CursLCmd  OR TP.CursLLin THEN               ' Was this a click in the list area?
               IF TP.CsrCol < gFM_Head_Name_Left THEN             ' In the Cmd char area?
                  j = CINT(LO(WORD, CBWPARAM))                    ' Get Ctl keys
                  IF GetKeyState(%VK_MENU) < 0 THEN j = j OR %MK_ALT ' Add in ALT key if pressed
                  GOSUB DoMouseKB                                 ' Figure out what mouse KB simulation to do

               ELSE                                               '
                  IF TP.CsrCol >= gFM_Head_Name_Left AND _        ' In the line data area
                     TP.ScreenChrHit(TP.CsrRow, TP.CsrCol) THEN   ' And on a non-blank?
                     TP.AFLCmdSet(TP.CsrRow - gFM_Top_File_Line + TP.GPTopLine, "SELECT")  '
                     TP.CsrCol = 1                                ' Yes, pretend cursor is in Column 1
                     GOSUB PostAttention                          ' Post an Attention request
                  END IF                                          '
               END IF                                             '
               GOTO DlgExit                                       '
            ELSE                                                  ' Not list area
               GOTO DlgExit                                       '
            END IF                                                '
         END IF                                                   ' End FM code

         j = CINT(LO(WORD, CBWPARAM))                             ' Get Ctl keys
         IF GetKeyState(%VK_MENU) < 0 THEN j = j OR %MK_ALT       ' Add in ALT key if pressed
         GOSUB DoMouseKB                                          ' Figure out what mouse KB simulation to do

      '--------------------------------------------------------------------------------------------+
      '- Left Button Double click                                                                  |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_LBUTTONDBLCLK                                      '
         DblClick = %True                                         ' To tell next UP to be ignored
         GOSUB GetRowCol                                          ' Get Row/Col to tRow/tCol
         IF IsTPPTypeMode AND tRow <> gPTbl(1).sRow THEN GOTO DlgExit   ' Must be same as PTmode Model line
         IF IsTPMarkActive AND _                                  ' Mark active with a real range?
            (TP.MarkGL <> TP.MarkGR) OR _                         '
            (TP.MarkGT <> TP.MarkGB) THEN GOTO DlgExit            '
         TP.CsrCol = tCol                                         ' Move cursor
         TP.CsrRow = tRow                                         '
         IF ISFALSE TP.CursData THEN GOTO DlgExit                 ' Exit if not in the data area

         '-----------------------------------------------------------------------------------------+
         '- Continue only if we're in the Data area, mark a word if we're on one                   |
         '-----------------------------------------------------------------------------------------+
         IF TP.CsrCol > TP.GPGapCol AND TP.CsrRow >= TP.GPData1 AND _   ' Make sure its safe
            TP.CsrRow <= TP.GPBottom AND TP.FCB_.HexMode = &1 AND ISFALSE IsFMTab THEN ' In true text area?
            TP.CursWordLoc                                        ' Go see if we can locate a word
            IF IsTPMarkActive THEN                                ' If we marked it, try drawing a hi-lite
               CaretDestroy                                       ' Turn cursor off
               TP.MarkScr                                         '
               CaretCreate                                        '
               DoCursor                                           ' Get cursor back
               CaretShow                                          '
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Middle Button Down                                                                        |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_MBUTTONDOWN                                        '
         gfMiddleDown = %True                                     ' Middle down

      '--------------------------------------------------------------------------------------------+
      '- Middle Button Up                                                                          |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_MBUTTONUP                                          '
         gfMiddleDown = %False                                    ' Middle up
         GOSUB GetRowCol                                          ' Get Row/Col to tRow/tCol
         IF IsTPPTypeMode AND tRow <> gPTbl(1).sRow THEN GOTO DlgExit   ' Must be same as PTmode Model line
         j = CINT(LO(WORD, CBWPARAM))                             ' Get Ctl keys
         IF GetKeyState(%VK_MENU) < 0 THEN j = j OR %MK_ALT       ' Add in ALT key if pressed

         IF (j AND (%MK_SHIFT OR %MK_CONTROL OR %MK_ALT)) = (%MK_SHIFT OR %MK_CONTROL OR %MK_ALT) THEN   ' Shift-Ctrl-Alt Middle-click
            IF gKbdT.SCAUp(106) = "." THEN GOSUB SetCurs          ' Set Cursor?
            IF UUCASE(gKbdT.SCAData(106)) <> "(NULL)" AND UUCASE(gKbdT.SCAData(106)) <> "(PASSTHRU)" THEN   '
               gKeyChr = CHR$(03) + gKbdT.SCAData(106)            ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND (%MK_SHIFT OR %MK_ALT)) = (%MK_SHIFT OR %MK_ALT) THEN  ' Shift-Alt Middle-click
            IF gKbdT.SAUp(106) = "." THEN GOSUB SetCurs           ' Set Cursor?
            IF UUCASE(gKbdT.SAData(106)) <> "(NULL)" AND UUCASE(gKbdT.SAData(106)) <> "(PASSTHRU)" THEN  '
               gKeyChr = CHR$(03) + gKbdT.SAData(106)             ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND (%MK_CONTROL OR %MK_ALT)) = (%MK_CONTROL OR %MK_ALT) THEN ' Control-Alt Middle-click
            IF gKbdT.CAUp(106)= "." THEN GOSUB SetCurs            ' Set Cursor?
            IF UUCASE(gKbdT.CAData(106)) <> "(NULL)" AND UUCASE(gKbdT.CAData(106)) <> "(PASSTHRU)" THEN  '
               gKeyChr = CHR$(03) + gKbdT.CAData(106)             ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND (%MK_SHIFT OR %MK_CONTROL)) = (%MK_SHIFT OR %MK_CONTROL) THEN   ' Shift-Control Middle-click
            IF gKbdT.SCUp(106)= "." THEN GOSUB SetCurs            ' Set Cursor?
            IF UUCASE(gKbdT.SCData(106)) <> "(NULL)" AND UUCASE(gKbdT.SCData(106)) <> "(PASSTHRU)" THEN  '
               gKeyChr = CHR$(03) + gKbdT.SCData(106)             ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND %MK_SHIFT) = %MK_SHIFT THEN                ' Shift Middle-Click
            IF gKbdT.SUp(106)= "." THEN GOSUB SetCurs             ' Set Cursor?
            IF UUCASE(gKbdT.SData(106)) <> "(NULL)" AND UUCASE(gKbdT.SData(106)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.SData(106)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND %MK_CONTROL) = %MK_CONTROL THEN            ' Control Middle-click
            IF gKbdT.CUp(106)= "." THEN GOSUB SetCurs             ' Set Cursor?
            IF UUCASE(gKbdT.CData(106)) <> "(NULL)" AND UUCASE(gKbdT.CData(106)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.CData(106)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND %MK_ALT) = %MK_ALT THEN                    ' Alt Middle-click
            IF gKbdT.AUp(106)= "." THEN GOSUB SetCurs             ' Set Cursor?
            IF UUCASE(gKbdT.AData(106)) <> "(NULL)" AND UUCASE(gKbdT.AData(106)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.AData(106)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSE                                                     ' Normal Middle-Click
            IF gKbdT.NUp(106)= "." THEN GOSUB SetCurs             ' Set Cursor?
            IF UUCASE(gKbdT.NData(106)) <> "(NULL)" AND UUCASE(gKbdT.NData(106)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.NData(106)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '
         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Right Button Down                                                                         |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_RBUTTONDOWN                                        '

      '--------------------------------------------------------------------------------------------+
      '- Right Button Up                                                                           |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_RBUTTONUP                                          '
         GOSUB GetRowCol                                          ' Get Row/Col to tRow/tCol
         IF IsTPPTypeMode AND tRow <> gPTbl(1).sRow THEN GOTO DlgExit   ' Must be same as PTmode Model line
         j = CINT(LO(WORD, CBWPARAM))                             ' Get Ctl keys
         IF GetKeyState(%VK_MENU) < 0 THEN j = j OR %MK_ALT       ' Add in ALT key if pressed

         IF (j AND (%MK_SHIFT OR %MK_CONTROL OR %MK_ALT)) = (%MK_SHIFT OR %MK_CONTROL OR %MK_ALT) THEN   ' Shift-Ctrl-Alt Right-click
            IF gKbdT.SCAUp(107)= "." THEN GOSUB SetCurs           ' Set Cursor?
            IF UUCASE(gKbdT.SCAData(107)) <> "(NULL)" AND UUCASE(gKbdT.SCAData(107)) <> "(PASSTHRU)" THEN   '
               gKeyChr = CHR$(03) + gKbdT.SCAData(107)            ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND (%MK_SHIFT OR %MK_ALT)) = (%MK_SHIFT OR %MK_ALT) THEN  ' Shift-Alt Right-click
            IF gKbdT.SAUp(107)= "." THEN GOSUB SetCurs            ' Set Cursor?
            IF UUCASE(gKbdT.SAData(107)) <> "(NULL)" AND UUCASE(gKbdT.SAData(107)) <> "(PASSTHRU)" THEN  '
               gKeyChr = CHR$(03) + gKbdT.SAData(107)             ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND (%MK_CONTROL OR %MK_ALT)) = (%MK_CONTROL OR %MK_ALT) THEN ' Control-Alt Right-click
            IF gKbdT.CAUp(107)= "." THEN GOSUB SetCurs            ' Set Cursor?
            IF UUCASE(gKbdT.CAData(107)) <> "(NULL)" AND UUCASE(gKbdT.CAData(107)) <> "(PASSTHRU)" THEN  '
               gKeyChr = CHR$(03) + gKbdT.CAData(107)             ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND (%MK_SHIFT OR %MK_CONTROL)) = (%MK_SHIFT OR %MK_CONTROL) THEN   ' Shift-Control Right-click
            IF gKbdT.SCUp(107)= "." THEN GOSUB SetCurs            ' Set Cursor?
            IF UUCASE(gKbdT.SCData(107)) <> "(NULL)" AND UUCASE(gKbdT.SCData(107)) <> "(PASSTHRU)" THEN  '
               gKeyChr = CHR$(03) + gKbdT.SCData(107)             ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND %MK_SHIFT) = %MK_SHIFT THEN                ' Shift Right-Click
            IF gKbdT.SUp(107)= "." THEN GOSUB SetCurs             ' Set Cursor?
            IF UUCASE(gKbdT.SData(107)) <> "(NULL)" AND UUCASE(gKbdT.SData(107)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.SData(107)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND %MK_CONTROL) = %MK_CONTROL THEN            ' Control Right-click
            IF gKbdT.CUp(107)= "." THEN GOSUB SetCurs             ' Set Cursor?
            IF UUCASE(gKbdT.CData(107)) <> "(NULL)" AND UUCASE(gKbdT.CData(107)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.CData(107)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSEIF (j AND %MK_ALT) = %MK_ALT THEN                    ' Alt Right-click
            IF gKbdT.AUp(107)= "." THEN GOSUB SetCurs             ' Set Cursor?
            IF UUCASE(gKbdT.AData(107)) <> "(NULL)" AND UUCASE(gKbdT.AData(107)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.AData(107)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            END IF                                                '

         ELSE                                                     ' Normal Right-Click
            IF gKbdT.NUp(107) = "." THEN GOSUB SetCurs            ' Set Cursor?
            IF UUCASE(gKbdT.NData(107)) <> "(NULL)" AND UUCASE(gKbdT.NData(107)) <> "(PASSTHRU)" THEN '
               gKeyChr = CHR$(03) + gKbdT.NData(107)              ' Pretend the selected key was hit
               MainBUserMsg()                                     ' Process the key event
            ELSE                                                  ' Maybe Context Menu?
               GOSUB GetRowCol                                    ' Get Row/Col to tRow/tCol
               TP.CsrCol = tCol                                   ' Move cursor
               TP.CsrRow = tRow                                   '
               IF IsFMTab AND (TP.CursLCmd OR TP.CursLLin) THEN   ' Only if we're on the FM screen list area
                  tt = DispContext(tRow)                          ' DispContext
                  IF tt <> "" THEN                                ' Got a command?
                     TP.AFLCmdSet(TP.CsrRow - gFM_Top_File_Line + TP.GPTopLine, tt)  '
                     TP.CsrCol = 1                                ' Yes, pretend cursor is in Column 1
                     GOSUB PostAttention                          ' Post an Attention request
                  END IF                                          '
               END IF                                             ' Otherwise do nothing
            END IF                                                '

         END IF                                                   '

      '--------------------------------------------------------------------------------------------+
      '- Throw all else away                                                                       |
      '--------------------------------------------------------------------------------------------+
      CASE ELSE                                                   '
         GOTO DlgExit                                             '
   END SELECT                                                     '

DlgExit:                                                          '
   EXIT FUNCTION                                                  '

SetCurs:                                                          '
   GOSUB GetRowCol                                                ' Get Row/Col to tRow/tCol
   TP.CsrCol = tCol: TP.CsrRow = tRow                             ' Set where cursor goes
   IF ISFALSE IsFMTab THEN                                        ' If not FM                                                           '
      '--------------------------------------------------------------------------------------------+
      '- In the Line number area                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF TP.CsrCol < TP.GPGapCol AND TP.CsrRow >= TP.GPDATA1 AND _   ' Make sure its safe
         TP.CsrRow <= TP.GPBottom AND TP.FCB_.HexMode = 1 THEN    ' In true text area?
         i = TP.sGet(TP.CsrRow)                                   '
         IF TP.LLCtlGet(i) = $BlankLNo OR TP.LLCtlGet(i) = "''''''''" OR _ ' Useless data?
            TP.LLCtlGet(i) = "--------" OR TP.LLCtlGet(i) = "********" OR _   '
            LEFT$(TP.LLCtlGet(i), 1) = "=" OR VERIFY(TP.LLCtlGet(i), $Numeric) = 0 THEN   '
            TP.CsrCol = TP.GPLeft                                 ' Put cursor in column 1 of LineNum
         END IF                                                   '
      END IF                                                      '
      SetPanel(tRow, tCol)                                        ' Swap panels if needed
   END IF                                                         '
   TP.MarkLineNumb                                                ' Hilite the line
   DoCursor                                                       ' Go move the cursor
   RETURN                                                         '

GetRowCol:                                                        '
   IF LO(WORD,CBLPARAM) = 0 THEN GOTO DlgExit                     ' If invalid location, ignore
   IF HI(WORD,CBLPARAM) = 0 THEN GOTO DlgExit                     '
   tCol = CEIL((LO(WORD,CBLPARAM) - %GLM + 2) / gFontWidth)       ' Calc where cursor is
   tRow = CEIL((HI(WORD,CBLPARAM) + 1) / gFontHeight)             '
   RETURN                                                         '

PostAttention:                                                    ' Post an Attention request
   Msg.kbString = CHR$(4, 0, 0, 0)                                ' Setup as an Attention request message
   PostMessage(ghWnd, %WM_USER, Msg.MsgwParam, 0)                 ' To the mainline Callback routine
   RETURN                                                         '

ResetCols:                                                        '
   FOR k = 1 TO gFMCCtr                                           ' Reset other column headers
      IF k <> j THEN                                              ' Don't do ourselves
         gFMC(k).CHead = REMOVE$(gFMC(k).CHead, ANY "+-*")        ' Remove any active direction
      END IF                                                      '
   NEXT k                                                         '
   RETURN                                                         '

DoMouseKB:                                                        '
   IF (j AND (%MK_SHIFT OR %MK_CONTROL OR %MK_ALT)) = (%MK_SHIFT OR %MK_CONTROL OR %MK_ALT) THEN   ' Shift-Ctrl-Alt Left-click
      IF gKbdT.SCAUp(105) = "." THEN                              ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.SCAData(105)) <> "(NULL)" AND UUCASE(gKbdT.SCAData(105)) <> "(PASSTHRU)" THEN   '
         gKeyChr = CHR$(03) + gKbdT.SCAData(105)                  ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   ELSEIF (j AND (%MK_SHIFT OR %MK_ALT)) = (%MK_SHIFT OR %MK_ALT) THEN  ' Shift-Alt Left-click
      IF gKbdT.SAUp(105) = "." THEN                               ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.SAData(105)) <> "(NULL)" AND UUCASE(gKbdT.SAData(105)) <> "(PASSTHRU)" THEN  '
         gKeyChr = CHR$(03) + gKbdT.SAData(105)                   ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   ELSEIF (j AND (%MK_CONTROL OR %MK_ALT)) = (%MK_CONTROL OR %MK_ALT) THEN ' Control-Alt Left-click
      IF gKbdT.CAUp(105) = "." THEN                               ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.CAData(105)) <> "(NULL)" AND UUCASE(gKbdT.CAData(105)) <> "(PASSTHRU)" THEN  '
         gKeyChr = CHR$(03) + gKbdT.CAData(105)                   ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   ELSEIF (j AND (%MK_SHIFT OR %MK_CONTROL)) = (%MK_SHIFT OR %MK_CONTROL) THEN   ' Shift-Control Left-click
      IF gKbdT.SCUp(105) = "." THEN                               ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.SCData(105)) <> "(NULL)" AND UUCASE(gKbdT.SCData(105)) <> "(PASSTHRU)" THEN  '
         gKeyChr = CHR$(03) + gKbdT.SCData(105)                   ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   ELSEIF (j AND %MK_SHIFT) = %MK_SHIFT THEN                      ' Shift Left-Click
      IF gKbdT.SUp(105) = "." THEN                                ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.SData(105)) <> "(NULL)" AND UUCASE(gKbdT.SData(105)) <> "(PASSTHRU)" THEN '
         gKeyChr = CHR$(03) + gKbdT.SData(105)                    ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   ELSEIF (j AND %MK_CONTROL) = %MK_CONTROL THEN                  ' Control Left-click
      IF gKbdT.CUp(105) = "." THEN                                ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.CData(105)) <> "(NULL)" AND UUCASE(gKbdT.CData(105)) <> "(PASSTHRU)" THEN '
         gKeyChr = CHR$(03) + gKbdT.CData(105)                    ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   ELSEIF (j AND %MK_ALT) = %MK_ALT THEN                          ' Control Alt-click
      IF gKbdT.AUp(105) = "." THEN                                ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.AData(105)) <> "(NULL)" AND UUCASE(gKbdT.AData(105)) <> "(PASSTHRU)" THEN '
         gKeyChr = CHR$(03) + gKbdT.AData(105)                    ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   ELSE                                                           ' Normal Left-Click
      IF gKbdT.NUp(105) = "." THEN                                ' Set Cursor?
         GOSUB SetCurs                                            ' Go do it
      END IF                                                      '
      IF UUCASE(gKbdT.NData(105)) <> "(NULL)" AND UUCASE(gKbdT.NData(105)) <> "(PASSTHRU)" THEN '
         gKeyChr = CHR$(03) + gKbdT.NData(105)                    ' Pretend the selected key was hit
         MainBUserMsg()                                           ' Process the key event
      END IF                                                      '

   END IF                                                         '

   RETURN                                                         '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgDefaultCallBack                              '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by the Profile Default Dialog                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL lclText AS STRING                                           '
   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- Handle the various interactions                                                           |
      '--------------------------------------------------------------------------------------------+

      '--------------------------------------------------------------------------------------------+
      '- SYSCOMMAND                                                                                |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_SYSCOMMAND                                         '
         IF CB.HNDL <> ghDef THEN EXIT FUNCTION                   '
         IF (CBWPARAM AND &HFFF0) = %SC_CLOSE THEN                ' Trap the [x] button and Alt-F4
            FUNCTION = 1                                          ' Ignore it
         END IF                                                   '

      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '
            CASE %WELCOME_OPTION1                                 '
               IF CB.CTLMSG = %BN_CLICKED THEN                    '
                  gDefaultAnswer = "DEF"                          ' Say to use the DEFAULT profile
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghDef                                ' Shut things down
               END IF                                             '

            CASE %WELCOME_OPTION2                                 '
               IF CB.CTLMSG = %CBN_SELENDOK THEN                  ' Something selected?
                  CONTROL GET TEXT ghDef, %WELCOME_OPTION2 TO lclText   '
                  IF lclText = "(Choose)" THEN EXIT FUNCTION      ' If nothing chosen, ignore
                  gDefaultAnswer = "NEW " + lclText               ' Say to create a NEW  profile
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghDef                                ' Shut things down
               END IF                                             '

            CASE %WELCOME_OPTION3                                 '
               IF CB.CTLMSG = %CBN_SELENDOK THEN                  ' Something selected?
                  CONTROL GET TEXT ghDef, %WELCOME_OPTION3 TO lclText   '
                  IF lclText = "(Choose)" THEN EXIT FUNCTION      ' If nothing chosen, ignore
                  gDefaultAnswer = "USE " + lclText               ' Say to create a USE the profile
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghDef                                ' Shut things down
               END IF                                             '

            CASE %WELCOME_OPTION4                                 '
               IF CB.CTLMSG = %BN_CLICKED THEN                    '
                  gDefaultAnswer = IIF$(IsFMTab, "ABORT", "CANCEL")  ' Say to Cancel/Abort
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghDef                                ' Shut things down
               END IF                                             '

            CASE %WELCOME_OPTION5                                 '
               IF CB.CTLMSG = %BN_CLICKED THEN                    '
                  gDefaultAnswer = "SKIP"                         ' Say to Skip this file type
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghDef                                ' Shut things down
               END IF                                             '

            CASE %WELCOME_OPTION6                                 '
               IF CB.CTLMSG = %BN_CLICKED THEN                    '
                  gDefaultAnswer = "OPENW"                        ' Say to Set OpenW status
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghDef                                ' Shut things down
               END IF                                             '

         END SELECT                                               '
   END SELECT                                                     '
   EXIT FUNCTION                                                  '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgIntruptCallBack                              '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by the FF search Interrupt                                               |
'--------------------------------------------------------------------------------------------------+
   SELECT CASE AS LONG CB.MSG                                     '
      '--------------------------------------------------------------------------------------------+
      '- Handle the FF Interrupt                                                                   |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '
            CASE %INTERRUPT_BREAK                                 '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Break?
                  gfInterrupt = %True                             ' Flag for mainline
                  DIALOG END ghIntr                               ' End the window
               END IF                                             '
         END SELECT                                               '
   END SELECT                                                     '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgMessageCallBack                              '
'--------------------------------------------------------------------------------------------------+
'- Make sure Message box text starts off unselected                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL mx, my AS LONG                                              '
   SELECT CASE CBMSG                                              '
      CASE %WM_INITDIALOG                                         '
         CONTROL HANDLE ghMsg, %MSG_ListBox TO ghMsgHnd           '
      CASE %WM_PAINT                                              '
         SendMessage ghMsgHnd, %EM_SETSEL, -1, 0                  '
      CASE %WM_SIZE                                               '
         DIALOG GET SIZE ghMsg TO mx, my                          '
         CONTROL SET SIZE ghMsg, %MSG_ListBox, mx - 4, my - 30    '
         FUNCTION = 0                                             '
   END SELECT                                                     '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgOptionsCallBack                              '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by Options dialog                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL ttxt, t, Txt1, Txt2, Txt3, MSG AS STRING, RCA AS RCArea     '
LOCAL i, j, k, m, CurrTab, hDC, DoRestart AS LONG                 '
STATIC lclENGChars AS LONG                                        '
LOCAL lclFontname, VerData AS STRING, lclFontPitch, lclStyle AS INTEGER '

   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- Dialog is being initialized                                                               |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_INITDIALOG                                         '
         lclENGChars = gENV.ENGChars                              ' Save starting ENG Char value

      '--------------------------------------------------------------------------------------------+
      '- Fill TAB background                                                                       |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_ERASEBKGND                                         ' Time to fill Tab background
         hDC = CB.WPARAM                                          ' Get hDC
         TabBGFill hDC                                            ' Pass to fill routine
         FUNCTION = 1                                             ' Say we did it

      '--------------------------------------------------------------------------------------------+
      '- Draw Tab Item Text                                                                        |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_DRAWITEM                                           ' draw tab item text in different color on select
         IF CB.WPARAM = %TAB_CONTROL THEN  TabHighLight CBHNDL, CBWPARAM, CBLPARAM  '

      '--------------------------------------------------------------------------------------------+
      '- Handle various interactions                                                               |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '

            '--------------------------------------------------------------------------------------+
            '- DONE button pressed                                                                 |
            '--------------------------------------------------------------------------------------+
            CASE %DIALOG_DONE                                     '
               IF CB.CTLMSG = %BN_CLICKED AND gMsgBoxActive = %False THEN  ' Done button pressed

                  '--------------------------------------------------------------------------------+
                  '- Validate Cmd Character                                                        |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghGeneral, %GENERAL_INICmdChr TO Txt1   '
                  Txt1 = LEFT$(Txt1, 1)                           '
                  IF LEN(Txt1) = 0 OR Txt1 = " " THEN             '
                     DoMessageBox("Command separator character cannot be null or blank.", %MB_OK OR %MB_USERICON, "Options")  '
                     EXIT FUNCTION                                '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Validate DefDataShift                                                         |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIDefDataShift TO Txt1   '
                  Txt1 = UCASE$(Txt1)                             '
                  IF VERIFY(RIGHT$(Txt1, 1), $Numeric) > 0 THEN   ' Non-numeric trailer
                     IF RIGHT$(Txt1, 1) <> "P" THEN               '
                        DoMessageBox("Only 'P' allowed for Data Shift suffix.", %MB_OK OR %MB_USERICON, "Options")   '
                        EXIT FUNCTION                             '
                     END IF                                       '
                  END IF                                          '
                  IF VAL(Txt1) = 0 THEN                           '
                     DoMessageBox("Minimum value for Data Shift is 1.", %MB_OK OR %MB_USERICON, "Options")  '
                     EXIT FUNCTION                                '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Validate CMDFlags                                                             |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghSubmit, %SUBMIT_INICMDFlags TO ttxt   '
                  GOSUB FlagCheck                                 '
                  CONTROL SET TEXT ghSubmit, %SUBMIT_INICMDFlags, ttxt  '

                  '--------------------------------------------------------------------------------+
                  '- Validate RUNFlags                                                             |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghSubmit, %SUBMIT_INIRUNFlags TO ttxt   '
                  GOSUB FlagCheck                                 '
                  CONTROL SET TEXT ghSubmit, %SUBMIT_INIRUNFlags, ttxt  '

                  '--------------------------------------------------------------------------------+
                  '- Validate the FM Layout strings                                                |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghFManager, %FMANAGER_INIFMLayout TO ttxt  '
                  ValidateLayout(ttxt, RCA)                       ' Do validation
                  IF RCA.RC <> 0 THEN                             ' If not OK
                     DoMessageBox("FM Layout error: |K" + TRIM$(RCA.Msg) + "|B", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION  '
                  END IF                                          '
                  CONTROL SET TEXT ghFManager, %FMANAGER_INIFMLayout,ttxt  '

                  CONTROL GET TEXT ghFManager, %FMANAGER_INIFMLayoutM TO ttxt '
                  ValidateLayout(ttxt, RCA)                       ' Do validation
                  IF RCA.RC <> 0 THEN                             ' If not OK
                     DoMessageBox("FM LayoutM error: |K" + TRIM$(RCA.Msg) + "|B", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION '
                  END IF                                          '
                  CONTROL SET TEXT ghFManager, %FMANAGER_INIFMLayoutM,ttxt '

                  '--------------------------------------------------------------------------------+
                  '- Validate the =FILE> line format                                               |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghScreen, %SCREEN_FILELINEFMT TO ttxt   '

                  Txt1 = UCASE$(PARSE$(ttxt, ",", 1))             ' Get operand 1
                  IF Txt1 <> "LEFT" AND Txt1 <> "RIGHT" AND _     ' Do validation
                     Txt1 <> "CENTER" AND Txt1 <> "CENTRE" THEN _ '
                     DoMessageBox("=FILE> format is neither LEFT, RIGHT nor CENTER", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION '

                  '--------------------------------------------------------------------------------+
                  '- Validate the SBAR Layout string                                               |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghSBar, %SBAR_INISBOrder TO ttxt  '
                  ttxt = UUCASE(REMOVE$(ttxt, " "))               ' Remove any blanks, uppercase it
                  ttxt = RTRIM$(ttxt, ",")                        ' Remove trailing comma
                  FOR i = 1 TO PARSECOUNT(ttxt, ",")              ' Check the operands
                     t = PARSE$(ttxt, i)                          ' Get operand
                     j = INSTR(t, "(")                            ' See if a (nn) length
                     IF j THEN                                    ' Yes
                        k = VAL(MID$(t, j + 1))                   ' A value?
                        IF k = 0 THEN                             ' No, error
                           DoMessageBox("Status Bar Layout operand: |K" + TRIM$(t) + "|B has invalid length", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '
                        END IF                                    '
                        t = LEFT$(t, j - 1)                       ' Remove (nn)
                     END IF                                       '
                     t = LSET$(t, 6)                              ' Get operand padded
                     IF INSTR("MODE  LINNO LINES COLS  BNDS  INSOVRCASE  CHANGESTATE MISC  SELECTCAPS  SOURCEEOL   LAYOUT", t) = 0 THEN _ '
                        DoMessageBox("Status Bar Layout operand: |K" + TRIM$(t) + "|B is not recognixed.", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '
                  NEXT i                                          '
                  IF TALLY(ttxt, "MODE")   > 1 OR _               ' Look for duplicates
                     TALLY(ttxt, "LINNO")  > 1 OR _               '
                     TALLY(ttxt, "LINES")  > 1 OR _               '
                     TALLY(ttxt, "COLS")   > 1 OR _               '
                     TALLY(ttxt, "BNDS")   > 1 OR _               '
                     TALLY(ttxt, "INSOVR") > 1 OR _               '
                     TALLY(ttxt, "CASE")   > 1 OR _               '
                     TALLY(ttxt, "CHANGE") > 1 OR _               '
                     TALLY(ttxt, "STATE")  > 1 OR _               '
                     TALLY(ttxt, "MISC")   > 1 OR _               '
                     TALLY(ttxt, "SELECT") > 1 OR _               '
                     TALLY(ttxt, "CAPS")   > 1 OR _               '
                     TALLY(ttxt, "SOURCE") > 1 OR _               '
                     TALLY(ttxt, "LAYOUT") > 1 OR _               '
                     TALLY(ttxt, "EOL")    > 1 THEN _             '
                        DoMessageBox("Status Bar Layout duplicate operand(s) detected.", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '
                  CONTROL SET TEXT ghSBar, %SBAR_INISBOrder,ttxt  '

                  '--------------------------------------------------------------------------------+
                  '- Validate Backup Retention                                                     |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIBKPRETPD TO Txt1 '
                  IF ISNULL(Txt1) THEN _                          ' Must be present
                     DoMessageBox("Backup RETPD value cannot be Null. ", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIBKPMinGen TO Txt1   '
                  IF ISNULL(Txt1) THEN _                          ' Must be present
                     DoMessageBox("Backup Minimum Gens value cannot be Null. ", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIBKPMaxGen TO Txt2   '
                  IF ISNULL(Txt2) THEN _                          ' Must be present
                     DoMessageBox("Backup Maximum Gens value cannot be Null. ", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '
                  IF VAL(Txt2) < VAL(Txt1) THEN _                 ' Max must be greater than Min
                     DoMessageBox("Backup Maximum Gens must be equal or greater then Minimum Gens ", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '

                  '--------------------------------------------------------------------------------+
                  '- Validate LANG optionntion                                                     |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghGeneral, %GENERAL_INILANG TO Txt1  '
                  IF UCASE$(TRIM$(Txt1)) <> "NONE" THEN           ' If not NONE
                     IF ISFALSE ISFILE(gENV.HomeData + "index-" + TRIM$(Txt1) + ".aff") OR _ '
                        ISFALSE ISFILE(gENV.HomeData + "index-" + TRIM$(Txt1) + ".dic") THEN _  '
                        DoMessageBox "The Spelling dictionary files: Index-" + TRIM$(Txt1) + ".dic and .aff files do not exist." + $CRLF + _ '
                                     "They must be present in the HomeData folder.", %MB_OK OR %MB_USERICON, "Options": EXIT FUNCTION  '
                  END IF                                          '
                  '--------------------------------------------------------------------------------+
                  '- Validate the Config entries                                                   |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghOpt, %DIALOG_INI_TEXT2 TO Txt1  '
                  IF RIGHT$(Txt1,1) <> "\" THEN Txt1 += "\"       ' Ensure a trailing \
                  IF ISFALSE ISFILE(Txt1 + "SPFLite.CFG") THEN    ' Better have the CFG file waiting
                     DoMessageBox "The New Config Storage folder does not contain an |KSPFLite.CFG|B file." + $CRLF + _ '
                                  "The existing CFG file must be copied FIRST before this change.", %MB_OK OR %MB_USERICON, "Options": EXIT FUNCTION  '
                  END IF                                          '

                  CONTROL GET TEXT ghConfig, %CONFIG_HOMEDATA TO Txt1   '
                  IF RIGHT$(Txt1,1) <> "\" THEN Txt1 += "\"       ' Ensure a trailing \
                  i = 0                                           ' Reset counter
                  i += IIF(ISFOLDER(Txt1 + "AUTO\"), 1, 0)        ' Count \AUTO
                  i += IIF(ISFOLDER(Txt1 + "CLIP\"), 1, 0)        ' Count \CLIP
                  i += IIF(ISFOLDER(Txt1 + "FILELIST\"), 1, 0)    ' Count \FILELIST
                  i += IIF(ISFOLDER(Txt1 + "JOBS\"), 1, 0)        ' Count \JOBS
                  i += IIF(ISFOLDER(Txt1 + "MACROS\"), 1, 0)      ' Count \MACROS
                  i += IIF(ISFOLDER(Txt1 + "RUN\"), 1, 0)         ' Count \RUN
                  i += IIF(ISFOLDER(Txt1 + "STATE\"), 1, 0)       ' Count \STATE
                  IF i <> 7 THEN                                  ' Better be valid
                     DoMessageBox "The Data Storage folder structure under:|K" + $CRLF + _   '
                                  Txt1 + $CRLF + _                '
                                  "|Bis missing one or more sub-folders.", %MB_OK OR %MB_USERICON, "Options": EXIT FUNCTION   '
                  END IF                                          '

                  CONTROL GET CHECK ghConfig, %CONFIG_HOMEEFTNAME TO i  ' Get the EFT choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMEEFTNAME, 1 TO j   ' Get the original value
                  IF (i <> j) AND gSQL.Optname = "ODEFAULT" THEN _   '
                     DoMessageBox("Altering the EFT Tabls option is not allowed for the DEFAULT Instance", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '
                  CONTROL GET CHECK ghConfig, %CONFIG_HOMEKBDNAME TO i  ' Get the KBD choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMEKBDNAME, 1 TO j   ' Get the original value
                  IF (i <> j) AND gSQL.Optname = "ODEFAULT" THEN _   '
                     DoMessageBox("Altering the Keyboard option is not allowed for the DEFAULT Instance", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION '
                  CONTROL GET CHECK ghConfig, %CONFIG_HOMERTRNAME TO i  ' Get the RTR choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMERTRNAME, 1 TO j   ' Get the original value
                  IF (i <> j) AND gSQL.Optname = "ODEFAULT" THEN _   '
                     DoMessageBox("Altering the Retrieve option is not allowed for the DEFAULT Instance", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION '
                  CONTROL GET CHECK ghConfig, %CONFIG_HOMESETNAME TO i  ' Get the SET choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMESETNAME, 1 TO j   ' Get the original value
                  IF (i <> j) AND gSQL.Optname = "ODEFAULT" THEN _   '
                     DoMessageBox("Altering the SET Table option is not allowed for the DEFAULT Instance", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '

                  '--------------------------------------------------------------------------------+
                  '- Validate the Scheme Alias Names                                               |
                  '--------------------------------------------------------------------------------+
                  FOR i = 1 TO 14                                 '
                     CONTROL GET TEXT ghScheme, %SCHEME_00_TEXT + ((i + 1) * 6) TO Txt1   '
                     IF ISNULL(TRIM$(Txt1)) OR TRIM$(Txt1) <> Txt1 OR INSTR(Txt1, ANY ", ") > 0 THEN  '
                        DoMessageBox("Scheme Alias Names cannot have embedded blanks or commas", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION '
                     END IF                                       '
                  NEXT i                                          '

                  '--------------------------------------------------------------------------------+
                  '- Validate Invalid Char String - KEEP THIS AS THE LAST VALIDATION ROUTINE       |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIPDotRaw TO Txt2  '
                  MSG = NormalizeCharMap(Txt2, Txt1)              ' Convert to a real string
                  IF MSG <> "" THEN _                             ' If Msg returned, issue it
                     DoMessageBox("P'.' Character list - " + MSG, %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION  '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIInvChar TO Txt3  '
                  Txt3 = LEFT$(Txt3, 1)                           ' Force 1 char just in case
                  IF Txt3 = "" THEN _                             ' Must choose a character
                     DoMessageBox("Substitution character cannot be Null. ", %MB_OK OR %MB_USERICON, "Options"): EXIT FUNCTION   '

                  '--------------------------------------------------------------------------------+
                  '- All seems OK, save all the option values                                      |
                  '--------------------------------------------------------------------------------+
                  gENV.PDotRaw = Txt2: gENV.PDotString = Txt1: gENV.InvChar = Txt3  ' Save these before Txt1/2/3 clobbered
                  TP.PicSetCharSet()                              '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIABeepFlag TO i                  : gENV.ABeepFlag = i   '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIVBeepFlag TO i                  : gENV.VBeepFlag = i   '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIUniqueFlag TO i                 : gENV.UniqueFlag = i  '
                  CONTROL GET CHECK ghFManager, %FMANAGER_INIFMCloseFlag TO i              : gENV.FMCloseFlag = i '
                  CONTROL GET CHECK ghFManager, %FMANAGER_FMDATEHILITE TO i                : gENV.FMDateHiLite = i   '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIResetU TO i                     : gENV.ResetU = i   '
                  CONTROL GET CHECK ghFManager, %FMANAGER_INIConfDelFlag TO i              : gENV.ConfDelFlag = i '
                  CONTROL GET CHECK ghFManager, %FMANAGER_INIFMSORTSIMPLE TO i             : gENV.FMSortSimple = i   '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIUseRecycle TO i                 : gENV.UseRecycle = i  '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIViewWarn TO i                   : gENV.ViewWarn = i '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INISplash TO i                     : gENV.Splash = i   '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIHelpOpen TO i                   : gENV.HelpOpen = IIF(i = 1, 3, 1) '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INILang TO Txt1  '
                  Txt1 = UCASE$(TRIM$(Txt1))                                               : gENV.Lang = IIF$(Txt1 = "NONE", "", Txt1) '
                  CONTROL GET CHECK ghGeneral, %GENERAL_MacName TO i                       : gENV.MacName = i  '
                  CONTROL GET CHECK ghGeneral, %GENERAL_PanelMax TO i                      : gENV.PanelMax = i  '
                  CONTROL GET CHECK ghFManager, %FMANAGER_FMHLFLAG TO i                    : gENV.FMHelpFlag = i  '
                  CONTROL GET TEXT ghFManager, %FMANAGER_INIFMLAYOUT TO Txt1               : gENV.FMLayout = Txt1 '
                  CONTROL GET TEXT ghFManager, %FMANAGER_INIFMLAYOUTM TO Txt1              : gENV.FMLayoutM = Txt1   '
                  CONTROL GET TEXT ghSBar, %SBAR_INISBOrder TO Txt1                        : gENV.SBLayout = Txt1 '
                  COMBOBOX GET SELECT ghGeneral, %GENERAL_INIMinRetrieve TO i              : gENV.MinRetrieve = i '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INICmdChr TO Txt1                   : gENV.CmdChr = LEFT$(Txt1, 1)  '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIReOpenLast TO i                 : gENV.ReOpenLast = i  '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIWARNNONTEXT TO i                : gENV.WarnNonText = i '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INICutNew TO i                     : gENV.CutNew = i   '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIAttnPos TO i                    : gENV.AttnPos = i  '
                  CONTROL GET CHECK ghGeneral, %GENERAL_INIMinToTray TO i  '
                  gENV.MinToTray = i                              '

                  CONTROL GET CHECK ghGeneral, %GENERAL_INIENGChars TO i   ' Get ENGLISH-only setting ...
                  IF gENV.ENGChars THEN                           ' Using ENGLISH only letters ?
                     gENV.CharSet = $DefCharSet                   ' Set it to include only ENGLISH
                  ELSE                                            '
                     gENV.CharSet = $DefCharSet + $UpperNat + $LowerNat ' Set it to include International
                  END IF                                          '

                  gENV.CharSet = REMOVE$(gENV.CharSet, " ")       ' Charset should not have blanks
                  Txt1 = gENV.CharSet                             ' Massage into RegEx string
                  REPLACE "\" WITH "\x5C" IN Txt1                 '
                  REPLACE "[" WITH "\x5B" IN Txt1                 '
                  REPLACE "]" WITH "\x5D" IN Txt1                 '
                  gENV.CharSetR = Txt1                            '
                  TP.PicSetWord(): TP.PicSetCharSet()             ' Reset Picture strings

                  COMBOBOX GET SELECT ghGeneral, %GENERAL_ININotify TO i                   : gENV.NotifyLevel = i '
                  gENV.NotifyLevel = SWITCH(gENV.NotifyLevel = 1, 0, gENV.NotifyLevel = 2, 1, gENV.NotifyLevel = 3, 2)  '
                  gENV.NotifyLevelT = gENV.NotifyLevel            '
                  CONTROL GET CHECK ghGeneral, %GENERAL_FINDWORD TO i                      : gENV.FindWord = i '


                  CONTROL GET TEXT ghFManager, %FMANAGER_INIRecentCtr TO Txt1              : gENV.RecentCtr = VAL(Txt1) '
                  CONTROL GET TEXT ghFManager, %FMANAGER_INIFMLCmdWidth TO Txt1  '
                  i = VAL(Txt1): i = MAX(5, i): i = MIN(i, 20): Txt1 = FORMAT$(i)          : gENV.FMLCmdWidth = i '

                  CONTROL GET TEXT ghGeneral, %GENERAL_INIBKPRETPD TO Txt1 '
                  gENV.BKPRetention = VAL(Txt1)                   '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIBKPMinGen TO Txt1   '
                  gENV.BKPMinGen = VAL(Txt1)                      '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIBKPMaxGen TO Txt1   '
                  gENV.BKPMaxGen = VAL(Txt1)                      '
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIDefDataShift TO Txt1   '
                  txt1 = UCASE$(Txt1)                             '
                  i = VAL(Txt1)                                   ' Get numeric value
                  IF RIGHT$(Txt1, 1) = "P" THEN i = 0 - i         ' If "P" then make negative
                  gENV.DefDataShift = i                           ' Save it
                  CONTROL GET TEXT ghGeneral, %GENERAL_INIAutoScroll TO Txt1  '
                  gENV.AutoScroll = VAL(Txt1): gENV.AutoScroll= MAX(0, gENV.AutoScroll)   ' Keep it zero or positive
                  CONTROL GET TEXT ghGeneral, %GENERAL_INISetUNDO TO Txt1  '
                  gENV.UndoLevels = VAL(Txt1): gENV.UndoLevels = MAX(0, gENV.UndoLevels)  ' Keep it zero or positive
                  CONTROL GET TEXT ghGeneral, %GENERAL_INILinRepeatMax TO Txt1             : gENV.LinRepeatMax = VAL(Txt1) '
                  COMBOBOX GET SELECT ghGeneral, %GENERAL_INIWebCheck TO i                 : gENV.WebCheck = i '
                  gENV.WebCheck = SWITCH(gENV.WebCheck = 1, 0, gENV.WebCheck = 2, 7, gENV.WebCheck = 3, 30) '
                  CONTROL GET TEXT ghSubmit, %SUBMIT_SUBMIT TO Txt1                        : gENV.SubmitCmd = Txt1   '
                  CONTROL GET TEXT ghSubmit, %SUBMIT_INICMDFlags TO Txt1                   : gENV.CmdFlags = Txt1 '
                  CONTROL GET TEXT ghSubmit, %SUBMIT_INIRUNFlags TO Txt1                   : gENV.RunFlags = Txt1 '
                  CONTROL GET TEXT ghSubmit, %SUBMIT_INIInclKey TO Txt1                    : gENV.SubmitInclKey = TRIM$(Txt1) '
                  CONTROL GET TEXT ghSubmit, %SUBMIT_INIInclCol TO Txt1                    : gENV.SubmitInclCol = VAL(TRIM$(Txt1))  '
                  CONTROL GET CHECK ghScreen, %SCREEN_INIHRuler TO i                       : gENV.HRuler = i   '
                  CONTROL GET CHECK ghScreen, %SCREEN_INIVRuler TO i                       : gENV.VRuler = i   '
                  CONTROL GET CHECK ghScreen, %SCREEN_INIVScrollBar TO i   '
                  IF i <> gENV.VScrollBar THEN                    '
                     DoMessageBox("Changes to 'Add ScrollBars' will take effect next SPFLite restart", %MB_OK OR %MB_USERICON, "Options") '
                  END IF                                          '
                  gENV.VScrollBar = i                             '
                  IF gEnv.VScrollBar THEN gScrlWidth = GetSystemMetrics(%SM_CXVSCROLL) + 2   ' Get width of Vert Scrollbar + 2

                  CONTROL GET CHECK ghScreen, %SCREEN_INIBanding TO i                      : gENV.Banding = i  '
                  CONTROL GET CHECK ghScreen, %SCREEN_INIVERTINSCURS TO i                  : gENV.VertInsCurs = i '
                  CONTROL GET CHECK ghScreen, %SCREEN_INICMDHILITE TO i                    : gENV.CmdHiLite = i   '
                  CONTROL GET TEXT  ghScreen, %SCREEN_FILELINEFMT TO Txt1  '
                     gENV.FileLineFmt = UCASE$(PARSE$(Txt1, ",", 1)) + "," + PARSE$(Txt1, ",", 2)  '
                  CONTROL GET TEXT ghScreen, %SCREEN_INISBFACTOR TO Txt1   '
                  IF FORMAT$(VAL(txt1), "0.0") <> FORMAT$(gENV.SBFactor, "0.0") THEN   '
                     MyMsgBox("Changes to |KStatus Bar Factor|B will take effect on next SPFLite restart", %MB_OK OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "SPFLite Restart Needed") '
                  END IF                                          '
                  gENV.SBFactor = VAL(Txt1)                       '
                  CONTROL GET TEXT ghScreen, %SCREEN_CURSHGHTNORM TO Txt1  '
                  gENV.CursNormal = VAL(Txt1): gENV.CursNormal = MIN(gENV.CursNormal, 100)   '
                  CONTROL GET TEXT ghScreen, %SCREEN_CURSHGHTINS TO Txt1   '
                  gENV.CursInsert = VAL(Txt1): gENV.CursInsert = MIN(gENV.CursInsert, 100)   '
                  CONTROL GET TEXT ghScreen, %SCREEN_INIFontPitch TO Txt1  '
                  gENV.FontPitch = VAL(Txt1): gENV.FontPitch = MAX(gENV.FontPitch, 5): gENV.FontPitch = MIN(gENV.FontPitch, 24)  '
                  CONTROL GET TEXT ghScreen, %SCREEN_INIFontName TO Txt1                   : gENV.FontName = Txt1 '
                  CONTROL GET TEXT ghScreen, %SCREEN_INIPFKShow TO Txt1                    : gENV.PFKShow = MIN(VAL(Txt1), 5) '
                  CONTROL GET TEXT ghScreen, %SCREEN_INILNOSIZE TO Txt1 '
                  gENV.LinNoSize = MAX(VAL(Txt1), 5)              '
                  gENV.LinNoSize = MIN(gENV.LinNoSize, 8)         '
                  CONTROL GET CHECK ghKeyboard, %KBOARD_KBSCROLLH TO i                     : gENV.KBHorScroll = i '
                  CONTROL GET CHECK ghKeyboard, %KBOARD_KBSCROLLV TO i                     : gENV.KBVerScroll = i '
                  CONTROL GET CHECK ghKeyboard, %KBOARD_INIInsMode TO i                    : gENV.InsMode = i  '
                  CONTROL GET CHECK ghKeyboard, %KBOARD_INIInsReset TO i                   : gENV.InsReset = i '

                  '--------------------------------------------------------------------------------+
                  '- Save the Scheme Alias Names                                                   |
                  '--------------------------------------------------------------------------------+
                  FOR i = 1 TO 14                                 '
                     CONTROL GET TEXT ghScheme, %SCHEME_00_TEXT + ((i + 1) * 6) TO Txt1   '
                     gENV.SetSchAlias(i, Txt1)                    ' Save it
                  NEXT i                                          '

                  '--------------------------------------------------------------------------------+
                  '- Save away the Config values                                                   |
                  '--------------------------------------------------------------------------------+
                  CONTROL GET CHECK ghConfig, %CONFIG_HOMEEFTNAME TO i  ' Get the EFT choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMEEFTNAME, 1 TO j   ' Get the original value
                  IF i <> j THEN                                  ' EFT status has changed
                     DoRestart = %True                            ' Suggest a restart
                     IF ISTRUE i THEN                             ' Unique EFT is turning ON
                        gSQL.EFTName = gENV.eInstance             ' Alter the EFT name
                        gSQL.TableCopy("EDEFAULT", "E" + gENV.eInstance)   ' Create the table
                        gSQL.UpdateString("O", "HomeEFTName", gENV.eInstance) ' Set the name in the Options table
                     ELSE                                         ' Unique EFT is turning OFF
                        gSQL.EFTName = "DEFAULT"                  ' Reset the EFT name
                        gSQL.TableDelete("E" + gENV.eInstance)    ' Delete the table
                        gSQL.UpdateString("O", "HomeEFTName", "DEFAULT")   ' Reset the name in the Options table
                     END IF                                       '
                  END IF                                          '

                  CONTROL GET CHECK ghConfig, %CONFIG_HOMEKBDNAME TO i  ' Get the KBD choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMEKBDNAME, 1 TO j   ' Get the original value
                  IF i <> j THEN                                  ' KBD status has changed
                     DoRestart = %True                            ' Suggest a restart
                     IF ISTRUE i THEN                             ' Unique KBD is turning ON
                        gSQL.KbdName = gENV.eInstance             ' Alter the KBD name
                        gSQL.TableCopy("KDEFAULT", "K" + gENV.eInstance)   ' Create the table
                        gSQL.UpdateString("O", "HomeKbdName", gENV.eInstance) ' Set the name in the Options table
                     ELSE                                         ' Unique KBD is turning OFF
                        gSQL.KbdName = "DEFAULT"                  ' Reset the KBD name
                        gSQL.TableDelete("K" + gENV.eInstance)    ' Delete the table
                        gSQL.UpdateString("O", "HomeKbdName", "DEFAULT")   ' Reset the name in the Options table
                     END IF                                       '
                  END IF                                          '

                  CONTROL GET CHECK ghConfig, %CONFIG_HOMERTRNAME TO i  ' Get the RTR choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMERTRNAME, 1 TO j   ' Get the original value
                  IF i <> j THEN                                  ' RTR status has changed
                     DoRestart = %True                            ' Suggest a restart
                     IF ISTRUE i THEN                             ' Unique RTR is turning ON
                        gSQL.RtrName = gENV.eInstance             ' Alter the RTR name
                        gSQL.TableCopy("RDEFAULT", "R" + gENV.eInstance)   ' Create the table
                        gSQL.UpdateString("O", "HomeRtrName", gENV.eInstance) ' Set the name in the Options table
                     ELSE                                         ' Unique RTR is turning OFF
                        gSQL.RtrName = "DEFAULT"                  ' Reset the RTR name
                        gSQL.TableDelete("R" + gENV.eInstance)    ' Delete the table
                        gSQL.UpdateString("O", "HomeRtrName", "DEFAULT")   ' Reset the name in the Options table
                     END IF                                       '
                  END IF                                          '

                  CONTROL GET CHECK ghConfig, %CONFIG_HOMESETNAME TO i  ' Get the SET choice
                  CONTROL GET USER ghConfig, %CONFIG_HOMESETNAME, 1 TO j   ' Get the original value
                  IF i <> j THEN                                  ' SET status has changed
                     DoRestart = %True                            ' Suggest a restart
                     IF ISTRUE i THEN                             ' Unique SET is turning ON
                        gSQL.SetName = gENV.eInstance             ' Alter the SET name
                        gSQL.TableCopy("SDEFAULT", "S" + gENV.eInstance)   ' Create the table
                        gSQL.UpdateString("O", "HomeSetName", gENV.eInstance) ' Set the name in the Options table
                     ELSE                                         ' Unique SET is turning OFF
                        gSQL.SetName = "DEFAULT"                  ' Reset the SET name
                        gSQL.TableDelete("S" + gENV.eInstance)    ' Delete the table
                        gSQL.UpdateString("O", "HomeSetName", "DEFAULT")   ' Reset the name in the Options table
                     END IF                                       '
                  END IF                                          '

                  IF ISFALSE gENV.Roaming THEN                    '
                     CONTROL GET TEXT ghOpt, %DIALOG_INI_TEXT2 TO Txt1  ' Get the HomeFolder again
                     IF RIGHT$(Txt1, 1) <> "\" THEN Txt1 += "\"   ' Ensure trailing \
                     IF uucase(Txt1) <> uucase(gENV.HomeFolder) THEN ' Folder has been moved
                        DoRestart = %True                         ' Suggest a restart
                        '--------------------------------------------------------------------------+
                        '- Set the HomeFolder into the Registry now for the next re-start          |
                        '--------------------------------------------------------------------------+
                        gENV.HomeFolder = TRIM$(Txt1)             ' Stuff in in gENV
                        RegistrySet("Software\SPFLite", "HomeFolder", TRIM$(Txt1))  ' Save it now
                     END IF                                       '

                     CONTROL GET TEXT ghConfig, %CONFIG_HOMEDATA TO Txt1   '
                     IF RIGHT$(Txt1,1) <> "\" THEN Txt1 += "\"    ' Ensure a trailing \
                     IF uucase(gENV.HomeData) <> uucase(Txt1) THEN   ' Is it changing?
                        DoRestart = %True                         ' Suggest a restart
                        '--------------------------------------------------------------------------+
                        '- Set the HomeData into the Registry now for the next re-start            |
                        '--------------------------------------------------------------------------+
                        gENV.HomeData = TRIM$(Txt1)               ' Stuff in in gENV
                        RegistrySet("Software\SPFLite", "HomeData", TRIM$(Txt1)) ' Save it now
                     END IF                                       '
                  END IF                                          '

                  IF DoRestart THEN                               ' Tell user to restart?
                     DoMessageBox("You have altered how Config data is handled, it is recommended that" + $CRLF + _  '
                                  "SPFLite be restarted immediately", %MB_OK OR %MB_USERICON, "Restart Needed")   '
                  END IF                                          '

                  '--------------------------------------------------------------------------------+
                  '- Do wrap-up stuff                                                              |
                  '--------------------------------------------------------------------------------+
                  gENV.SchemeSaveAll                              ' Save the Schemes and Hilites
                  gENV.SetINITimeStamp                            '
                  StatusBarSetup                                  ' In case it changed
                  '--------------------------------------------------------------------------------+
                  '- Change the running FM Tab values                                              |
                  '--------------------------------------------------------------------------------+
                  CurrTab = TP.PgNumber                           ' Remember active tab
                  TP = gTabs(1)                                   ' Switch to the FM tab
                  TP.LastTop = 0                                  ' Kill position
                  TP = gTabs(CurrTab)                             ' Switch tab back
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghOpt                                ' Shut things down
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- CANCEL button pressed                                                               |
            '--------------------------------------------------------------------------------------+
            CASE %DIALOG_CANCEL, %IDCANCEL                        '
               IF CB.CTLMSG = %BN_CLICKED AND gMsgBoxActive = %False THEN  ' Cancel button pressed
                  gfOptCancel = %True                             ' Tell Options command we cancelled out
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghOpt                                ' Shut things down
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Check Web for update right now                                                      |
            '--------------------------------------------------------------------------------------+
            CASE %GENERAL_INIWebCheck_NOW                         ' Do immediate Web check?
               Verdata = GetVerFile()                             ' Get version data from the web
               IF ISNULL(VerData) THEN                            ' Null?  Error occurred, tell user
                  MyMsgBox("Unable to access SPFLite web site for update check.", %MB_OK OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "Update Check")   '
                  EXIT FUNCTION                                   '
               END IF                                             '
               gENV.WebLastDate = DATE$                           ' Remember when we last checked
               gENV.WebLastVers = VerData                         ' Update last one we told about
               IF VerData <= gENV.PgmVers THEN                    ' Current version, just exit
                  MyMsgBox("Your current SPFLite version is up to date.", %MB_OK OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "Update Check")  '
                  EXIT FUNCTION                                   '
               END IF                                             '
               DispUpdate(VerData)                                ' Go tell user

            '--------------------------------------------------------------------------------------+
            '- Font choose button pressed                                                          |
            '--------------------------------------------------------------------------------------+
            CASE %SCREEN_FONT_CHOOSE                              ' Manual choose font?
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Choose button pressed
                  KbdPopSave                                      ' Ready for pop-up
                  DISPLAY FONT ghOpt, , , gENV.FontName, gENV.FontPitch, gENV.FontStyle, %CF_FIXEDPITCHONLY + %CF_SCREENFONTS _  '
                               TO lclFontName, lclFontPitch, lclStyle   '
                  KbdPopRestore                                   ' Reset popup state
                  IF LEN(TRIM$(lclFontName)) <> 0 THEN            '
                      gENV.FontName = lclFontName + IIF$(lclStyle = 1, " Bold", "") '
                      gENV.FontPitch = lclFontPitch: gENV.FontStyle = lclStyle   ' Save used values
                      gENV.SetINITimeStamp                        '
                      CONTROL SET TEXT ghScreen, %SCREEN_INIFontName, gENV.FontName '
                      CONTROL SET TEXT ghScreen, %SCREEN_INIFontPitch, FORMAT$(gENV.FontPitch)  '
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Is it the Mark Line color                                                           |
            '--------------------------------------------------------------------------------------+
            CASE %SCREEN_INIcMarkLine                             '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Button pressed
                  k = GetColorSelection(ghOpt, gENV.cMarkLine)    ' Get a new value
                  gENV.cMarkLine = k                              ' Save it
                  gENV.SetINITimeStamp                            '
                  GRAPHIC ATTACH ghScreen, %SCREEN_INIcMarkLine   '
                  GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, k, 0 '
                  CONTROL REDRAW ghScreen, %SCREEN_INIcMarkLine   '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- One of the Screen color boxes was clicked                                           |
            '--------------------------------------------------------------------------------------+
            CASE %SCREEN_16_FG  TO %SCREEN_16_FG + 48             '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Button pressed
                  CONTROL GET USER ghScreen, CB.CTL, 1 TO i       ' Get the 1st index of the Color field
                  CONTROL GET USER ghScreen, CB.CTL, 2 TO j       ' Get the 2nd index of the Color field
                  k = GetColorSelection(ghOpt, gENV.GetClr(i, j)) ' Get a new value
                  gENV.SetClr(i, j, k)                            ' Save it
                  gENV.SetINITimeStamp                            '
                  CONTROL SET COLOR  ghScreen, %SCREEN_16_TEXT + ((i - 16) * 4), gENV.GetClr(i, 1), gENV.GetClr(i, 2)   '
                  CONTROL REDRAW ghScreen, %SCREEN_16_TEXT + ((i - 16) * 4)   '
                  CONTROL SET COLOR  ghScreen, %SCREEN_16_TEXT + 50 + ((i - 16) * 4), gENV.GetClr(i, 1), gENV.GetClr(i, 3) '
                  CONTROL REDRAW ghScreen, %SCREEN_16_TEXT + 50 + ((i - 16) * 4) '
                  GRAPHIC ATTACH ghScreen, %SCREEN_16_FG + (j-1) + ((i - 16) * 4)   '
                  GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i, j), 0   '
                  CONTROL REDRAW ghScreen, %SCREEN_16_FG + (j-1) + ((i - 16) * 4)   '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- One of the Scheme color boxes was clicked                                           |
            '--------------------------------------------------------------------------------------+
            CASE (%SCHEME_00_TEXT + 3)   TO (%SCHEME_00_TEXT + 115)  '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Button pressed
                  CONTROL GET USER ghScheme, CB.CTL, 1 TO i       ' Get the 1st index of the Color field
                  CONTROL GET USER ghScheme, CB.CTL, 2 TO j       ' Get the 2nd index of the Color field
                  k = GetColorSelection(ghOpt, gENV.GetClr(i, j)) ' Get a new value
                  gENV.SetClr(i, j, k)                            ' Save it
                  gENV.SetINITimeStamp                            '
                  CONTROL SET COLOR  ghScheme, %SCHEME_00_TEXT + (i * 6), gENV.GetClr(i, 1), gENV.GetClr(i, 2) '
                  CONTROL REDRAW ghScheme, %SCHEME_00_TEXT + (i * 6) '
                  CONTROL SET COLOR  ghScheme, %SCHEME_00_TEXT + 1 + (i * 6), gENV.GetClr(i, 1), gENV.GetClr(i, 2)   '
                  CONTROL REDRAW ghScheme, %SCHEME_00_TEXT + 1 + (i * 6)   '
                  CONTROL SET COLOR  ghScheme, %SCHEME_00_TEXT + 2 + (i * 6), gENV.GetClr(i, 1), gENV.GetClr(i, 3)   '
                  CONTROL REDRAW ghScheme, %SCHEME_00_TEXT + 2 + (i * 6)   '
                  GRAPHIC ATTACH ghScheme, %SCHEME_00_TEXT + 3 + (j-1) + (i * 6) '
                  GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i, j), 0   '
                  CONTROL REDRAW ghScheme, %SCHEME_00_TEXT + 3 + (j-1) + (i * 6) '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- One of the HiLites color boxes was clicked                                          |
            '--------------------------------------------------------------------------------------+
            CASE %HILITES_01_FG TO (%HILITES_01_FG + 45)          '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Button pressed
                  CONTROL GET USER ghHiLites, CB.CTL, 1 TO i      ' Get the passed Scheme Number
                  CONTROL GET USER ghHiLites, CB.CTL, 2 TO j      ' Get the passed FG/BG1/BG2 value
                  CONTROL GET USER ghHiLites, CB.CTL, 3 TO k      ' Get the passed Text ID User value
                  m = GetColorSelection(ghOpt, gENV.GetClr(i, j)) ' Get a new value
                  gENV.SetClr(i, j, m)                            ' Save it
                  gENV.SetINITimeStamp                            '
                  CONTROL SET COLOR ghHiLites, k, gENV.GetClr(i, 1), gENV.GetClr(i, 2) '
                  CONTROL REDRAW ghHiLites, k                     '
                  GRAPHIC ATTACH ghHiLites, CB.CTL                '
                  GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i, j), 0   '
                  CONTROL REDRAW ghHiLites, CB.CTL                '
                  '--------------------------------------------------------------------------------+
                  '- If BG1, propagate to BG2 automatically                                        |
                  '--------------------------------------------------------------------------------+
                  IF j = 2 THEN                                   ' If BG1, propagate to BG2
                     j = 3                                        ' Set to BG2
                     gENV.SetClr(i, j, m)                         ' Save BG1 color into BG2
                     gENV.SetINITimeStamp                         '
                     GRAPHIC ATTACH ghHiLites, CB.CTL + 1         ' Point at it
                     GRAPHIC BOX (1, 1) - (12, 12), 20, %BLACK, gENV.GetClr(i, j), 0   '
                     CONTROL REDRAW ghHiLites, CB.CTL + 1         '
                  END IF                                          '
               END IF                                             '

         END SELECT                                               '
   END SELECT                                                     '
   EXIT FUNCTION                                                  '

FlagCheck:                                                        '
   ttxt = UUCASE(TRIM$(ttxt))                                     ' Get rid of white space
   i = INSTR(ttxt, "/K"): j = INSTR(ttxt, "/C")                   ' Test if /C or /K are there

   IF i <> 0 AND j <> 0 THEN                                      ' Both /C and /K ?
      ttxt = REMOVE$(ttxt, "/C")                                  ' Remove the /C
      i = INSTR(ttxt, "/K"): j = INSTR(ttxt, "/C")                ' Re-do the scan
   END IF                                                         '

   IF i = 0 AND j = 0 THEN                                        ' Neither?
      ttxt += " /K"                                               ' Default to /K
      ttxt = SHRINK$(ttxt)                                        ' remove extra spaces
      RETURN                                                      ' And we're done
   END IF                                                         '

   IF i <> 0 AND i <> LEN(ttxt) - 1 THEN                          ' /K and it's not at the end
      ttxt = REMOVE$(ttxt, "/K")                                  ' Remove the /K
      ttxt += " /K"                                               ' Add it at the end
   END IF                                                         '

   IF j <> 0 AND j <> LEN(ttxt) - 1 THEN                          ' /C and it's not at the end
      ttxt = REMOVE$(ttxt, "/C")                                  ' Remove the /C
      ttxt += " /C"                                               ' Add it at the end
   END IF                                                         '
   ttxt = SHRINK$(ttxt)                                           ' Remove extra spaces
   RETURN                                                         '

END FUNCTION                                                      '

CALLBACK FUNCTION DlgPrintCallBack                                '
'--------------------------------------------------------------------------------------------------+
'- Callback function used by the PRINT FORMAT Dialog                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL lclFontName, Txt1 AS STRING, lclFontPitch AS SINGLE, lclFontStyle AS LONG  '
LOCAL i, j AS LONG, fList AS STRING, fTable() AS STRING           '

   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- Handle various interactions                                                               |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '

            '--------------------------------------------------------------------------------------+
            '- Choose Printer button pressed                                                       |
            '--------------------------------------------------------------------------------------+
            CASE %PRINT_PCHOOSE                                   '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Choose Printer?
                  KbdPopSave                                      ' Ready for pop-up
                  XPRINT ATTACH CHOOSE, "SPFLite Printer Selection"  ' Attach printer Choice menu
                  KbdPopRestore                                   ' Reset popup state
                  IF ERR = 0 AND LEN(XPRINT$) > 0 THEN            ' OK?
                     XPRINT GET DUPLEX TO i                       ' Get duplex setting
                     gENV.PrtDuplex = i                           '
                     IF gENV.PrtDuplex = 0 THEN gENV.PrtDuplex = 1   ' Eliminate the 0 case
                     XPRINT GET ORIENTATION TO i                  ' Get orientation setting
                     gENV.PrtOrient = i                           '
                     gENV.PrtName = XPRINT$                       '
                     XPRINT GET PAPER TO i                        ' Get index to Paper type
                     gENV.PrtPaper = i                            '
                     XPRINT GET PAPERS TO fList                   ' Get string of forms available
                     REDIM fTable(1 TO PARSECOUNT(fList)) AS STRING  ' Build a table
                     PARSE fList, fTable()                        '
                     FOR i = 1 TO UBOUND(fTable) STEP 2           '
                        IF VAL(fTable(i)) = gENV.PrtPaper THEN    ' Found our entry?
                           gPrtPaper = fTable(i + 1): EXIT FOR    ' Save paper name
                        END IF                                    '
                     NEXT i                                       '
                     CONTROL SET TEXT  ghPrt, %PRINT_INIPrtName_TEXT, "Printer: " + gENV.PrtName   '
                     CONTROL SET TEXT  ghPrt, %PRINT_INIPrtOrient_TEXT, "Orientation: " + IIF$(gENV.PrtOrient = 1, "Portrait", "Landscape")  '
                     CONTROL SET TEXT  ghPrt, %PRINT_INIPrtPaper_TEXT, "Paper: " + gPrtPaper '
                     XPRINT CANCEL                                '
                     XPRINT CLOSE                                 '
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Font choose button pressed                                                          |
            '--------------------------------------------------------------------------------------+
            CASE %PRINT_FCHOOSE                                   '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Choose Font?
                  KbdPopSave                                      ' Ready for pop-up
                  DISPLAY FONT ghWnd, , , gENV.PrtFontName, VAL(gENV.PrtFontPitch), VAL(gENV.PrtFontStyle), %CF_FIXEDPITCHONLY _ '
                          TO lclFontName, lclFontPitch, lclFontStyle '
                  KbdPopRestore                                   ' Reset popup state
                  IF LEN(TRIM$(lclFontName)) <> 0 THEN            '
                     gENV.PrtFontName = lclFontName + IIF$(lclFontStyle = 1, " BOLD", "") ' Swap
                     gENV.PrtFontPitch = FORMAT$(lclFontPitch, "00.0")  '
                     gENV.PrtFontStyle = FORMAT$(lclFontStyle)    '
                     CONTROL SET TEXT  ghPrt, %PRINT_FNAME_TEXT, "Fontname: " + gENV.PrtFontName   '
                     CONTROL SET TEXT  ghPrt, %PRINT_FPOINT_TEXT, "Pitch: " + gENV.PrtFontPitch '
                     CONTROL SET TEXT  ghPrt, %PRINT_FBOLD_TEXT, "Bold: " + IIF$(gENV.PrtFontStyle = "0", "Off", "On")  '
                  END IF                                          '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Metric toggle altered                                                               |
            '--------------------------------------------------------------------------------------+
            CASE %PRINT_METRIC                                    '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Metric button pressed
                  CONTROL GET CHECK ghPrt, %PRINT_METRIC TO i     '
                  gENV.PrtMetric = i                              '
                  CONTROL SET TEXT ghPrt, %PRINT_LM_TEXT, "Page left margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)") '
                  CONTROL SET TEXT ghPrt, %PRINT_RM_TEXT, "Page right margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)")   '
                  CONTROL SET TEXT ghPrt, %PRINT_TM_TEXT, "Page top margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)")  '
                  CONTROL SET TEXT ghPrt, %PRINT_BM_TEXT, "Page bottom margin " + IIF$(gENV.PrtMetric, "(mm)", "(in)")  '
                  CONTROL SET TEXT ghPrt, %PRINT_LM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtLMargin * 25.4, gENV.PrtLMargin), "0.00")  '
                  CONTROL SET TEXT ghPrt, %PRINT_RM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtRMargin * 25.4, gENV.PrtRMargin), "0.00")  '
                  CONTROL SET TEXT ghPrt, %PRINT_TM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtTMargin * 25.4, gENV.PrtTMargin), "0.00")  '
                  CONTROL SET TEXT ghPrt, %PRINT_BM, FORMAT$(IIF(gENV.PrtMetric, gENV.PrtBMargin * 25.4, gENV.PrtBMargin), "0.00")  '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Banding color choice                                                                |
            '--------------------------------------------------------------------------------------+
            CASE %Print_BANDINGCOLOR                              ' A screen color choice
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Button pressed
                  j = gENV.PrtBandColor                           ' Get the current color
                  i = GetColorSelection(ghOpt, j)                 ' Get a new value
                  IF ISFALSE ISWIN(ghPrt) THEN EXIT FUNCTION      '
                  gENV.PrtBandColor = i                           ' Save it back
                  GRAPHIC ATTACH ghPrt, CB.CTL                    ' Point at the control
                  GRAPHIC SET MIX %MIX_COPYSRC                    ' Set Mix mode
                  GRAPHIC BOX (1, 1) - (16, 16), 20, %BLACK, i, 0 ' Repaint it in the new color
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- DONE button pressed                                                                 |
            '--------------------------------------------------------------------------------------+
            CASE %PRINT_DONE                                      '
               IF CB.CTLMSG = %BN_CLICKED THEN                    ' Done button pressed
                  CONTROL GET CHECK ghPrt, %PRINT_PCOLOR TO i     '
                  gENV.PrtPColor = i                              '
                  CONTROL GET CHECK ghPrt, %PRINT_BANDING TO i    '
                  gENV.PrtBanding = i                             '
                  CONTROL GET CHECK ghPrt, %PRINT_BANDLINES TO i  '
                  gENV.PrtBandLines = i                           '
                  IF gENV.PrtBanding AND gENV.PrtBandLines THEN _ '
                        DoMessageBox("Cannot have both Band stripes and Band Lines. ", %MB_OK OR %MB_USERICON, "Print Options"): EXIT FUNCTION  '
                  CONTROL GET CHECK ghPrt, %PRINT_METRIC TO i     '
                  gENV.PrtMetric = i                              '
                  CONTROL GET TEXT ghPrt, %PRINT_LM TO Txt1       '
                  gENV.PrtLMargin = IIF(gENV.PrtMetric, VAL(Txt1) / 25.4, VAL(Txt1))   '
                  CONTROL GET TEXT ghPrt, %PRINT_RM TO Txt1       '
                  gENV.PrtRMargin = IIF(gENV.PrtMetric, VAL(Txt1) / 25.4, VAL(Txt1))   '
                  CONTROL GET TEXT ghPrt, %PRINT_TM TO Txt1       '
                  gENV.PrtTMargin = IIF(gENV.PrtMetric, VAL(Txt1) / 25.4, VAL(Txt1))   '
                  CONTROL GET TEXT ghPrt, %PRINT_BM TO Txt1       '
                  gENV.PrtBMargin = IIF(gENV.PrtMetric, VAL(Txt1) / 25.4, VAL(Txt1))   '
                  CONTROL GET CHECK ghPrt, %PRINT_HEADER TO i     '
                  gENV.PrtHeader = i                              '
                  CONTROL GET TEXT ghPrt, %PRINT_HEADER_LEFT TO Txt1 '
                  gENV.PrtHeaderLeft = Txt1                       '
                  CONTROL GET TEXT ghPrt, %PRINT_HEADER_CENTER TO Txt1  '
                  gENV.PrtHeaderCenter = Txt1                     '
                  CONTROL GET TEXT ghPrt, %PRINT_HEADER_RIGHT TO Txt1   '
                  gENV.PrtHeaderRight = Txt1                      '
                  CONTROL GET CHECK ghPrt, %PRINT_FOOTER TO i     '
                  gENV.PrtFooter = i                              '
                  CONTROL GET TEXT ghPrt, %PRINT_FOOTER_LEFT TO Txt1 '
                  gENV.PrtFooterLeft = Txt1                       '
                  CONTROL GET TEXT ghPrt, %PRINT_FOOTER_CENTER TO Txt1  '
                  gENV.PrtFooterCenter = Txt1                     '
                  CONTROL GET TEXT ghPrt, %PRINT_FOOTER_RIGHT TO Txt1   '
                  gENV.PrtFooterRight = Txt1                      '
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghPrt                                ' Shut things down
               END IF                                             '

         END SELECT                                               '
         gENV.SetINITimeStamp                                     '

   END SELECT                                                     '
   EXIT FUNCTION                                                  '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgProfileCallBack                              '
'--------------------------------------------------------------------------------------------------+
'-     (BYVAL ghPrf AS DWORD, _           ' CB.HNDL                                                |
'-                               BYVAL wMsg AS LONG,   _            CB.MSG                         |
'-                               BYVAL wParam AS LONG, _            CB.WPARAM                      |
'-                                                                  CB.CTLMSG = HI(WORD, wParam)   |
'-                                                                  CB.CTL = LO(WORD, wParam)      |
'-                               BYVAL lParam AS LONG) AS LONG      CB.LPARAM                      |
'--------------------------------------------------------------------------------------------------+
'- Callback function used by Profile Dialog                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL hDC AS LONG                                                 '

   SELECT CASE AS LONG CB.MSG                                     '

      '--------------------------------------------------------------------------------------------+
      '- Fill TAB background                                                                       |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_ERASEBKGND                                         ' Time to fill Tab background
         hDC = CB.WPARAM                                          ' Get hDC
         TabBGFill hDC                                            ' Pass to fill routine
         FUNCTION = 1                                             ' Say we did it

      '--------------------------------------------------------------------------------------------+
      '- Draw tab text                                                                             |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_DRAWITEM                                           ' draw tab item text in different color on select
         IF CB.WPARAM = %TAB_CONTROL THEN  TabHighLight CB.HNDL, CB.WPARAM, CB.LPARAM  '

      '--------------------------------------------------------------------------------------------+
      '- Handle various interactions                                                               |
      '--------------------------------------------------------------------------------------------+
      CASE %WM_COMMAND                                            '
         SELECT CASE AS CB.CTL                                    '

            '--------------------------------------------------------------------------------------+
            '- CANCEL pressed, bail out                                                            |
            '--------------------------------------------------------------------------------------+
            CASE %DIALOG_CANCEL, %IDCANCEL                        '
               IF CB.CTLMSG = %BN_CLICKED AND gMsgBoxActive = %False THEN  ' Cancel button pressed
                  gfDialogDone = %True                            ' Say dialog was cancelled
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghPrf                                ' Shut things down
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- DONE button pressed, validate and save                                              |
            '--------------------------------------------------------------------------------------+
            CASE %DIALOG_DONE                                     '
               IF CB.CTLMSG = %BN_CLICKED AND gMsgBoxActive = %False THEN  ' Done button pressed
                  IF TP.FCB_.DoneCheck() THEN                     ' Check validity, exit if errors
                     CONTROL SET FOCUS ghPrf, %FILE_SCRLAMTC      ' Regain focus.
                     EXIT FUNCTION                                '
                  END IF                                          '

                  gfDialogDone = %False                           ' Say dialog ended normally
                  RESET ghToolTips                                ' Clear so Tooltips get re-created correctly
                  DIALOG END ghPrf                                ' Shut things down
               END IF                                             '

         END SELECT                                               '
   END SELECT                                                     '
END FUNCTION                                                      '

FUNCTION MyMsgBox(mTxt AS STRING, _                               '
                  OPT mStyle AS LONG, _                           '
                  OPT mTitle AS STRING, _                         '
                  OPT mpitch AS LONG, _                           '
                  OPT mBG AS LONG) _                              '
                  AS LONG                                         '
'--------------------------------------------------------------------------------------------------+
'- Private MSGBOX equivalent with color/Font size support                                          |
'--------------------------------------------------------------------------------------------------+
                                                                  'mTxt     Text of the message                                                                      |
'-        Default text color is %RGB_BLUE.                                                         |
'-        Change anywhere with embedded |x where                                                   |
'-        x can be: "K" - %RGB_BLACK       "G" - %RGB_GREEN       "B" - %RGB_BLUE                  |
'-                  "R" - %RGB_RED         "O" - %RGB_ORANGE      "I" - %RGB_INDIGO                |
'-                  "P" - %RGB_DEEPPINK                                                            |
'-        e.g.  "This message has a |GGreen |Band |RRed |Bword in it"                              |
'-                                                                                                 |
'-        If %MB_CUSTOMx style is chosen, the custom Button text(s) are passed as extra            |
'-        lines, separated by $CRLF, at the end of the true text message.                          |
'-        e.g.  "This message has a |GGreen |Band |RRed |Bword in it" + $CRLF + "Button 1 text"    |
'-              would use the custom text for Button 1 with %MB_CUSTOM1                            |
'-                                                                                                 |
'-                                                                                                 |
                                                                  'mStyle   Supports                                                                                 |
'-        %MB_OK                %MB_YESNO             %MB_OKCANCEL                                 |
'-        %MB_RETRYCANCEL       %MB_YESNOCANCEL       %MB_ABORTRETRYIGNORE                         |
'-        %MB_CANCELTRYCONTINUE                                                                    |
'-                                                                                                 |
'-        %MB_ICONERROR         %MB_ICONSTOP          %MB_ICONHAND                                 |
'-        %MB_ICONEXCLAMATION   %MB_ICONINFORMATION   %MB_ICONQUESTION                             |
'-        %MB_ICONWARNING       %MB_ICONASTERISK      %MB_USERICON                                 |
'-                                                                                                 |
'-        %MB_DEFBUTTON1        %MB_DEFBUTTON2        %MB_DEFBUTTON3                               |
'-        %MB_CUSTOM1           %MB_CUSTOM2           %MB_CUSTOM3                                  |
'-                                                                                                 |
'mTitle   Text for popup box Title                                                                 |
'-                                                                                                 |
'mPitch   Default size of Font for the message text                                                |
'-                                                                                                 |
'-        May be overridden FOR INDIVIDUAL lines by prefixing the line with |n                     |
'-            Where n = 1 - Standard default size                                                  |
'-                      2 - Standard * 1.25                                                        |
'-                      3 - Standard * 1.50                                                        |
'-                      4 - Standard * 1.75                                                        |
'-                      ...................                                                        |
'-                      9 - Standard * 3.00                                                        |
'-                                                                                                 |
'mBG      Color for message Background (Default is %RGB_BEIGE                                      |
'--------------------------------------------------------------------------------------------------+

REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL mlist(), t, t2, bTxt, lTitle, cTxt1, cTxt2, cTxt3 AS STRING '
LOCAL hMsg, hIcon, hFont() AS DWORD                               '
LOCAL mlisth(), mlistf(), lResult, BLen, ChrX, ChrY, TxtX, TxtY, NumLines, ButtonLen AS LONG '
LOCAL x, y, w, h, clr, lStyle, lPitch, lBG, bID, bDef, bLoc, FontIX, yPos, yMax AS LONG   '
DIM hFont(10) AS DWORD                                            '

   '-----------------------------------------------------------------------------------------------+
   '- Get parameters and build fonts                                                               |
   '-----------------------------------------------------------------------------------------------+
   lStyle = IIF(ISMISSING(mStyle), %MB_OK OR %MB_USERICON, mStyle)   ' Get Style if provided
   lTitle = IIF$(ISMISSING(mTitle), "", mTitle)                   ' Get Title if provided
   lPitch = IIF(ISMISSING(mpitch), 11, mpitch)                    ' Get pitch if provided
   lBG    = IIF(ISMISSING(mBG), %RGB_BEIGE, mBG)                  ' Get BG color if provided
   FONT NEW "Segoe UI SemiBold", 11 TO hFont(0)                   ' Build our Font for button text
   FONT NEW "Segoe UI SemiBold", lPitch TO hFont(1)               ' Build our Base Font
   FontIX = 1                                                     ' Say Base font is current

   '-----------------------------------------------------------------------------------------------+
   '- Build a dummy dialog to get font sizes                                                       |
   '-----------------------------------------------------------------------------------------------+
   DIALOG NEW PIXELS, 0, lTitle, 0, 0, 20, 20, , %WS_EX_TOPMOST TO hMsg ' Create the Dialog
   DIALOG SET COLOR hMsg, %RGB_BLUE, lBG                          ' Set color
   CONTROL ADD GRAPHIC, hMsg, %MMB_msg, "", 0, 0, 20, 20          ' Add the graphic text area
   GRAPHIC ATTACH hMsg, %MMB_msg                                  ' Attach it
   GRAPHIC COLOR %RGB_BLUE, lBG                                   ' Set default color
   GRAPHIC SET FONT hfont(1)                                      ' Set it to our Base Font
   ChrX = GRAPHIC(CHR.SIZE.X)                                     ' Get the average character width
   ChrY = GRAPHIC(CHR.SIZE.Y)                                     ' Get the average character height

   '-----------------------------------------------------------------------------------------------+
   '- Calc width and line height based on the supplied text / Font                                 |
   '-----------------------------------------------------------------------------------------------+
   NumLines = PARSECOUNT(mTxt, $CRLF)                             ' Get the Maximum line length
   REDIM mlist(NumLines): REDIM mlisth(NumLines): REDIM mlistf(NumLines)   '
   PARSE mTxt, mlist(), $CRLF                                     '
   '-----------------------------------------------------------------------------------------------+
   '- Calc width needed for buttons, collect Custom button text if provided                        |
   '-----------------------------------------------------------------------------------------------+
   ButtonLen = 10                                                 ' Starting offset
   SELECT CASE AS LONG lStyle AND &H0000000F                      ' A Custom button request?
      CASE = %MB_YESNOCANCEL                                      ' YES/NO/CANCEL
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Yes") + 50           ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&No") + 50            '
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Cancel") + 50        '
      CASE = %MB_ABORTRETRYIGNORE                                 ' ABORT/RETRY/IGNORE
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Abort") + 50         ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Retry") + 50         '
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Ignore") + 50        '
      CASE = %MB_CANCELTRYCONTINUE                                ' CANCEL/TRY AGAIN/CONTINUE
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Cancel") + 50        ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Try Again") + 50     '
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "C&ontinue") + 50      '
      CASE = %MB_YESNO                                            ' YES/NO
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Yes") + 50           ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&No") + 50            '
      CASE = %MB_RETRYCANCEL                                      ' RETRY/CANCEL
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Retry") + 50         ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Cancel") + 50        '
      CASE = %MB_OKCANCEL                                         ' OK/CANCEL
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&OK") + 50            ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Cancel") + 50        '
      CASE = %MB_OK                                               ' OK
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&OK") + 50            ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&OK") + 50            ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, "&Cancel") + 50        '
      CASE %MB_Custom1                                            ' One button
         cTxt1 = mlist(NumLines - 1)                              ' Pick the last line
         NumLines -= 1                                            ' Remove from list
         ButtonLen += GRAPHIC(TEXT.SIZE.X, cTxt1) + 50            ' Accum the lengths
      CASE %MB_Custom2                                            ' Two buttons
         cTxt1 = mlist(NumLines - 2)                              ' Pick the last 2 lines
         cTxt2 = mlist(NumLines - 1)                              '
         NumLines -= 2                                            ' Remove from list
         ButtonLen += GRAPHIC(TEXT.SIZE.X, cTxt1) + 50            ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, cTxt2) + 50            '
      CASE %MB_Custom3                                            ' Three buttons
         cTxt1 = mlist(NumLines - 3)                              ' Pick the last 3 lines
         cTxt2 = mlist(NumLines - 2)                              '
         cTxt3 = mlist(NumLines - 1)                              '
         NumLines -= 3                                            ' Remove from list
         ButtonLen += GRAPHIC(TEXT.SIZE.X, cTxt1) + 50            ' Accum the lengths
         ButtonLen += GRAPHIC(TEXT.SIZE.X, cTxt2) + 50            '
         ButtonLen += GRAPHIC(TEXT.SIZE.X, cTxt3) + 50            '
   END SELECT                                                     '

   FOR i = 0 TO NumLines - 1                                      '
      t2 = LEFT$(mlist(i), 2)                                     'See if a Font request
      IF LEFT$(t2,1) = "|" AND INSTR("123456789", RIGHT$(t2,1)) <> 0 THEN  ' Start with |n ?
         FontIX = VAL(RIGHT$(t2,1))                               ' Make it numeric
         mlistf(i) = FontIX                                       ' Save as FontIX for this line
         IF hFont(FontIX) = 0 THEN                                ' If we don't have it already
            x = lPitch * ((Fontix + 3) * .25)                     '
            FONT NEW "Segoe UI SemiBold", lPitch * ((Fontix + 3) * .25) TO hFont(FontIX)  ' Build a scaled version
         END IF                                                   '
         GRAPHIC SET FONT hfont(FontIX)                           ' Set it to the new font
         mlist(i) = MID$(mlist(i), 3)                             ' Remove /n
      END IF                                                      '
      j = GRAPHIC(TEXT.SIZE.X, mlist(i))                          '
      TxtX = MAX(j, TxtX)                                         '
      mlisth(i) = MAX(GRAPHIC(TEXT.SIZE.Y, mlist(i)), ChrY)       ' Save height of this line
      yMax += mlisth(i)                                           ' Accum total height
   NEXT i                                                         '

   TxtX += 90: TxtX = MAX(txtX, ButtonLen)                        ' Add 90 for Icon + Left/Right margins; ensure size for buttons
   TxtY = MAX(yMax + 12, 42)                                      ' Get total height for all lines - Minimum 42 for Icon

   '-----------------------------------------------------------------------------------------------+
   '- Resize now to actual size needed                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG SET CLIENT hMsg, TxtX, TxtY + 40                        ' Resize dialog (+ 40 for buttons)
   CONTROL SET SIZE hMsg, %MMB_msg, TxtX, TxtY                    ' Resize the text area

   '-----------------------------------------------------------------------------------------------+
   '- Print the text finally                                                                       |
   '-----------------------------------------------------------------------------------------------+
   ypos = IIF(NumLines = 1, (40 - ChrY) / 2, 5)                   ' Set position of line 1
   FOR i = 0 TO NumLines - 1                                      ' Print text now
      GRAPHIC SET POS (50, yPos)                                  ' Set position of this line
      GRAPHIC SET FONT hFont(mlistf(i))                           ' Set font for this line
      t = mlist(i)                                                ' Get a working copy
      IF LEN(t) = 0 THEN GRAPHIC PRINT: GOTO lExit                ' Skip null lines
      x = 1                                                       ' Start at the left
      DO WHILE x <= LEN(t)                                        ' While still stuff in t
         y = INSTR(x, t, "|")                                     ' Look for a color change
         IF y = 0 THEN GRAPHIC PRINT MID$(t, x);: GOTO lExit      ' No change, print remainder of line
         IF y > x THEN GRAPHIC PRINT MID$(t, x TO y - 1);         ' Print up to the |
         t2 = MID$(t, y + 1, 1)                                   ' Extract the color character
         clr = SWITCH(t2 = "O", %RGB_ORANGE, t2 = "B", %RGB_BLUE,     t2 = "R", %RGB_RED, _  '
                      t2 = "G", %RGB_GREEN,  t2 = "P", %RGB_DEEPPINK, t2 = "I", %RGB_INDIGO, _  '
                      t2 = "K", %RGB_BLACK)                       '
         GRAPHIC COLOR clr, lBG                                   ' Set the new color
         x = y + 2                                                ' Step over |x
      LOOP                                                        ' Continue on this string
      lExit:                                                      '
      yPos += mlisth(i)                                           ' Move Y down to nex line
   NEXT i                                                         ' Loop back for next line

   '-----------------------------------------------------------------------------------------------+
   '- Position the dialog                                                                          |
   '-----------------------------------------------------------------------------------------------+
   DESKTOP GET CLIENT TO w, h                                     '
   x = (w - TxtX) / 2                                             '
   y = (h - (TxtY + 30)) / 2                                      '
   DIALOG SET LOC hMsg, x, y                                      '

   '-----------------------------------------------------------------------------------------------+
   '- Add whatever buttons are needed                                                              |
   '-----------------------------------------------------------------------------------------------+
   h = TxtY + 4                                                   ' Set h as y position
   i = lStyle AND &H0000000F                                      ' Isolate low nibble for button
   j = lStyle AND &H00000F00                                      ' Isolate 3rd nibble for button default
   bLoc = 10                                                      ' Buttons start at 10
   IF i = %MB_YESNOCANCEL THEN                                    '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Yes:      bTxt = "&Yes":       bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_No:       bTxt = "&No":        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Yes:      bTxt = "&Yes":       bDef = %False: GOSUB BtnDef   '
         bID = %MMB_No:       bTxt = "&No":        bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %False: GOSUB BtnDef   '
      ELSE                                                        ' Button 3
         bID = %MMB_Yes:      bTxt = "&Yes":       bDef = %False: GOSUB BtnDef   '
         bID = %MMB_No:       bTxt = "&No":        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '
   ELSEIF i = %MB_ABORTRETRYIGNORE THEN                           '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Abort:    bTxt = "&Abort":     bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Retry:    bTxt = "&Retry":     bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Ignore:   bTxt = "&Ignore":    bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Abort:    bTxt = "&Abort":     bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Retry:    bTxt = "&Retry":     bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Ignore:   bTxt = "&Ignore":    bDef = %False: GOSUB BtnDef   '
      ELSE                                                        ' Button 3
         bID = %MMB_Abort:    bTxt = "&Abort":     bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Retry:    bTxt = "&Retry":     bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Ignore:   bTxt = "&Ignore":    bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '
   ELSEIF i = %MB_CANCELTRYCONTINUE THEN                          '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_TryAgain: bTxt = "&Try Again": bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Continue: bTxt = "C&ontinue":  bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %False: GOSUB BtnDef   '
         bID = %MMB_TryAgain: bTxt = "&Try Again": bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Continue: bTxt = "C&ontinue":  bDef = %False: GOSUB BtnDef   '
      ELSE                                                        ' Button 3
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %False: GOSUB BtnDef   '
         bID = %MMB_TryAgain: bTxt = "&Try Again": bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Continue: bTxt = "C&ontinue":  bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '
   ELSEIF i = %MB_YESNO THEN                                      '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Yes:      bTxt = "&Yes":       bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_No:       bTxt = "&No":        bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Yes:      bTxt = "&Yes":       bDef = %False: GOSUB BtnDef   '
         bID = %MMB_No:       bTxt = "&No":        bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '
   ELSEIF i = %MB_RETRYCANCEL THEN                                '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Retry:    bTxt = "&Retry":     bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Retry:    bTxt = "&Retry":     bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '
   ELSEIF i = %MB_OKCANCEL THEN                                   '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_OK:       bTxt = "&OK":        bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_OK:       bTxt = "&OK":        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Cancel:   bTxt = "&Cancel":    bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '
   ELSEIF i = %MB_OK THEN                                         '
      bID = %MMB_OK:          bTxt = "&OK":        bDef = %True:  GOSUB BtnDef   '
   ELSEIF i = %MB_Custom1 THEN                                    '
      bID = %MMB_Custom1:     bTxt = cTxt1:        bDef = %True:  GOSUB BtnDef   '
   ELSEIF i = %MB_Custom2 THEN                                    '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Custom1:  bTxt = cTxt1:        bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Custom2:  bTxt = cTxt2:        bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Custom1:  bTxt = cTxt1:        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Custom2:  bTxt = cTxt2:        bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '
   ELSEIF i = %MB_Custom3 THEN                                    '
      IF j = %MB_DEFBUTTON1 OR j = 0 THEN                         ' Button 1 (or null request)
         bID = %MMB_Custom1:  bTxt = cTxt1:        bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Custom2:  bTxt = cTxt2:        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Custom3:  bTxt = cTxt3:        bDef = %False: GOSUB BtnDef   '
      ELSEIF j = %MB_DEFBUTTON2 THEN                              ' Button 2
         bID = %MMB_Custom1:  bTxt = cTxt1:        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Custom2:  bTxt = cTxt2:        bDef = %True:  GOSUB BtnDef   '
         bID = %MMB_Custom3:  bTxt = cTxt3:        bDef = %False: GOSUB BtnDef   '
      ELSE                                                        ' Button 3
         bID = %MMB_Custom1:  bTxt = cTxt1:        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Custom2:  bTxt = cTxt2:        bDef = %False: GOSUB BtnDef   '
         bID = %MMB_Custom3:  bTxt = cTxt3:        bDef = %True:  GOSUB BtnDef   '
      END IF                                                      '

   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Add a dummy button to force the last button to be drawn (its a Win11 bug)                    |
   '-----------------------------------------------------------------------------------------------+
'   sleep 500
    bID = %MMB_Dummy: bTxt = "XXX": bDef = %False:  GOSUB BtnDef  ' Draw it
    CONTROL HIDE hMsg, %MMB_Dummy                                 ' Hide it
    CONTROL REDRAW hMsg, bID                                      ' Do a REDRAW


   DIALOG POST hMsg, %WM_CHANGEUISTATE, MAKLNG(%UIS_CLEAR, %UISF_HIDEFOCUS OR %UISF_HIDEACCEL), 0  '

   '-----------------------------------------------------------------------------------------------+
   '- Add icon                                                                                     |
   '-----------------------------------------------------------------------------------------------+
   h = lStyle AND &H000000F0                                      ' Isolate Icon portion
   IF h = 0 THEN h = %MB_USERICON                                 ' Provide a default
   IF h = %MB_USERICON THEN                                       ' The user version?
      CONTROL ADD IMAGEX, hMsg, %MMB_Icon, "a", 10, 8, 32, 32, %SS_ICON '
   ELSE                                                           ' Do the standard Icons
      CONTROL ADD LABEL,  hMsg, %MMB_Icon, "", 10, 8, 0, 0, %SS_ICON '
      i = 0: j = %MB_OK                                           '
      SELECT CASE AS LONG h                                       '
         CASE %MB_ICONERROR, %MB_ICONHAND, %MB_ICONSTOP           '
            i = 103: j = %MB_ICONHAND                             '
         CASE %MB_ICONQUESTION                                    '
            i = 102: j = %MB_ICONQUESTION                         '
         CASE %MB_ICONWARNING, %MB_ICONEXCLAMATION                '
            i = 101: j = %MB_ICONEXCLAMATION                      '
         CASE %MB_ICONINFORMATION, %MB_ICONASTERISK               '
            i = 104: j = %MB_ICONASTERISK                         '
      END SELECT                                                  '
      hIcon = LoadImage(BYVAL 0, BYVAL i, %IMAGE_ICON, 32, 32, 0) '
      SendDlgItemMessage hMsg, %MMB_Icon, %STM_SETIMAGE, %IMAGE_ICON, hIcon   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Finally we can display it                                                                    |
   '-----------------------------------------------------------------------------------------------+
   gMsgBoxActive = %True                                          ' Say we're active
   DIALOG REDRAW hMsg                                             ' Force a redraw
   DIALOG SHOW MODAL hMsg, CALL MyMsgBoxproc() TO lResult         ' Go display it
   gMsgBoxActive = %False                                         ' Say we've closed
   FOR i = 0 TO 10                                                '
      IF hFont(i) <> 0 THEN FONT END hfont(i)                     ' Destroy our fonts
   NEXT i                                                         '
   FUNCTION = lResult                                             ' Pass back result
   EXIT FUNCTION                                                  '

BtnDef:                                                           '
   BLen = GRAPHIC(TEXT.SIZE.X, bTxt) + 25                         ' Calc size of button
   CONTROL ADD BUTTON, hMsg, bID, bTxt, bLoc, h, BLen, 27, IIF(bDef, %BS_DEFAULT, 0)   '
   bLoc += BLen + 25                                              ' Set next button loc
   CONTROL SET FONT hMsg, bID, hFont(0)                           ' Set Button font
   IF bDef THEN CONTROL SET FOCUS hMsg, bID                       ' Set focus if default
   CONTROL REDRAW hMsg, bID                                       '
   RETURN                                                         ' Done
END FUNCTION                                                      '

CALLBACK FUNCTION MyMsgBoxProc() AS LONG                          '
LOCAL RC AS LONG                                                  '
   SELECT CASE CB.MSG                                             '
      CASE %WM_COMMAND                                            '
         IF CB.CTLMSG = %BN_CLICKED THEN                          ' If button clicked,
            SELECT CASE CB.CTL                                    ' Return with which one
               CASE %MMB_OK:      RC = %IDOK                      '
               CASE %MMB_Yes:     RC = %IDYES                     '
               CASE %MMB_No:      RC = %IDNO                      '
               CASE %MMB_Cancel:  RC = %IDCANCEL                  '
               CASE %MMB_Abort:   RC = %IDABORT                   '
               CASE %MMB_Retry:   RC = %IDRETRY                   '
               CASE %MMB_Ignore:  RC = %IDIGNORE                  '
               CASE %MMB_TryAgain:RC = %IDTRYAGAIN                '
               CASE %MMB_Continue:RC = %IDCONTINUE                '
               CASE %MMB_WOpen:   RC = %IDOK                      '
               CASE %MMB_Open:    RC = %IDYES                     '
               CASE %MMB_Custom1: RC = %IDCUSTOM1                 '
               CASE %MMB_Custom2: RC = %IDCUSTOM2                 '
               CASE %MMB_Custom3: RC = %IDCUSTOM3                 '
            END SELECT                                            '
            DIALOG END CB.HNDL, RC                                '
         END IF                                                   '
    END SELECT                                                    '
END FUNCTION                                                      '

SUB     DispSplash()                                              '
'--------------------------------------------------------------------------------------------------+
'- Display the Splash screen                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL hFont1, hFont2, hFont3 AS LONG, x, y AS LONG                '
   '-----------------------------------------------------------------------------------------------+
   '- Put out the Splash screen                                                                    |
   '-----------------------------------------------------------------------------------------------+
   FONT NEW "Segoe Script Bold", 12 TO hFont1                     ' Build normal
   FONT NEW "Segoe UI SemiBold", 13 TO hFont2                     ' Build larger
   FONT NEW "Segoe UI", 10 TO hFont3                              ' Build smaller
   DIALOG NEW PIXELS, 0, "", 0, 0, 375, 375, %WS_POPUP, %WS_EX_TOPMOST TO ghSplash  '
   DIALOG SET COLOR   ghSplash, %RGB_MEDIUMBLUE, %RGB_GAINSBORO   '
   CONTROL ADD FRAME, ghSplash, 101, "", 0, -5, 375, 375          ' Add a frame
   CONTROL SET COLOR  ghSplash, 101, %BLACK, %RGB_GAINSBORO       '
   CONTROL ADD IMAGE, ghSplash, %GENERAL_LOGO, "SPFLogo", 47, 5, 300, 50   '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T1, "A Windows Editor for SPF lovers", 47, 55, 290, 25 '
   CONTROL SET FONT   ghSplash, %GENERAL_T1, hFont1               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T1, %BLACK, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T2, "SPFLite Copyright  2005-2025", 57, 90, 290, 25   '
   CONTROL SET FONT   ghSplash, %GENERAL_T2, hFont2               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T2, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T3, "G. D. Deluca and R. L. Hodge", 59, 115, 290, 25   '
   CONTROL SET FONT   ghSplash, %GENERAL_T3, hFont2               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T3, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T4, "SPFLite is free software and comes with ABSOLUTELY", 4, 135, 350, 15, %SS_CENTER   '
   CONTROL SET FONT   ghSplash, %GENERAL_T4, hFont3               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T4, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T5, "NO WARRANTY. You are welcome to redistribute it under", 4, 150, 350, 15, %SS_CENTER   '
   CONTROL SET FONT   ghSplash, %GENERAL_T5, hFont3               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T5, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T6, "certain conditions. See 'License.txt' in the root install", 4, 165, 350, 15, %SS_CENTER  '
   CONTROL SET FONT   ghSplash, %GENERAL_T6, hFont3               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T6, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T7, "folder for distribution details.", 4, 180, 350, 15, %SS_CENTER   '
   CONTROL SET FONT   ghSplash, %GENERAL_T7, hFont3               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T7, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T8, "SPFLite uses other support tools:", 4, 200, 350, 15, %SS_CENTER  '
   CONTROL SET FONT   ghSplash, %GENERAL_T8, hFont3               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T8, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T9, "thinBasic (C) 2015 Eros Olmi", 4, 215, 350, 15, %SS_CENTER '
   CONTROL SET FONT   ghSplash, %GENERAL_T9, hFont3               '
   CONTROL SET COLOR  ghSplash, %GENERAL_T9, %RGB_MEDIUMBLUE, %RGB_GAINSBORO  '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T10, "PCRE (C) 2018 Philip Hazel", 4, 230, 350, 15, %SS_CENTER  '
   CONTROL SET FONT   ghSplash, %GENERAL_T10, hFont3              '
   CONTROL SET COLOR  ghSplash, %GENERAL_T10, %RGB_MEDIUMBLUE, %RGB_GAINSBORO '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T11, "SQLite - Public Domain courtesy of Hwaci", 1, 245, 350, 15, %SS_CENTER   '
   CONTROL SET FONT   ghSplash, %GENERAL_T11, hFont3              '
   CONTROL SET COLOR  ghSplash, %GENERAL_T11, %RGB_MEDIUMBLUE, %RGB_GAINSBORO '
   CONTROL ADD LABEL, ghSplash, %GENERAL_T12, "HunSpell - (C)  Lszl Nmeth", 1, 260, 350, 15, %SS_CENTER  '
   CONTROL SET FONT   ghSplash, %GENERAL_T12, hFont3              '
   CONTROL SET COLOR  ghSplash, %GENERAL_T12, %RGB_MEDIUMBLUE, %RGB_GAINSBORO '

   CONTROL ADD IMAGE, ghSplash, %GENERAL_GPLV3, "GPLV3L", 107, 285, 136, 68   '
   DESKTOP GET CLIENT TO x, y                                     '
   DIALOG SET LOC ghSplash, (x - 375) / 2 , (y - 375) / 2         '
   DIALOG SHOW MODELESS ghSplash CALL DlgSplashCallback           ' Display it

END SUB                                                           '

CALLBACK FUNCTION DlgSplashCallback() AS LONG                     '
   SELECT CASE CB.MSG                                             '
      CASE %WM_INITDIALOG                                         '
         SetTimer(ghSplash, %ID_Timer, 10000, BYVAL %Null)        '
      CASE %WM_TIMER                                              '
         DIALOG END ghSplash                                      '
   END SELECT                                                     '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgScrollCallback() AS LONG                     '
LOCAL sPos, i, j AS LONG                                          '
   SELECT CASE CB.MSG                                             '

      CASE %WM_VSCROLL                                            ' Scroll event
         IF IsTPPTypeMode THEN FUNCTION = %True: EXIT FUNCTION    ' No Up/Down in PT mode
         SCROLLBAR GET POS CB.HNDL, %IDC_ScrollBar TO sPos        ' Get the position for this control
         SELECT CASE LO(WORD, CBWPARAM)                           ' Get message
            CASE %SB_LINEUP                                       '
               TP.SPTopLine(TP.GPTopLine - 2)                     ' Small steps going up
            CASE %SB_PAGEUP                                       '
               TP.SPTopLine(TP.GPTopLine - TP.GPDLines)           ' Large steps going up
            CASE %SB_LINEDOWN                                     '
               TP.SPTopLine(TP.GPTopLine + 2)                     ' Small steps going down
            CASE %SB_PAGEDOWN                                     '
               i = TP.GPDLines: j = TP.GPTopLine                  '
               TP.SPTopLine(TP.GPTopLine + TP.GPDLines)           ' Large steps going down
            CASE %SB_THUMBTRACK                                   '
               SCROLLBAR GET TRACKPOS CB.HNDL, %IDC_ScrollBar TO sPos   'set the position
               TP.SPTopLine(sPos)                                 ' Save in TP
            CASE ELSE                                             '
               EXIT FUNCTION                                      '
         END SELECT                                               '
         TP.SPTopLine(MAX(1, TP.GPTopLine))                       ' Elim negative
         TP.SPTopLine(MIN(IIF(IsFMTab, gFMDCtr, TP.LastLine), TP.GPTopLine)) ' Same thing to the maximum limit
         IF IsFMTab THEN                                          ' FM?
            SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, TP.GPDLines   '
            SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, gFMDCtr + 7   '
            SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, TP.GPTopLine '
         ELSE                                                     '
            SCROLLBAR SET PAGESIZE ghWnd, %IDC_ScrollBar, TP.GPBottom - TP.GPTop + 1   '
            SCROLLBAR SET RANGE ghWnd, %IDC_ScrollBar, 1, TP.LastLine + 3  '
            SCROLLBAR SET POS ghWnd, %IDC_ScrollBar, TP.GPTopLine '
            OnTPInsClnSupp                                        ' Suppress Insert cleanup for 1 Attn pass
         END IF                                                   '
         TP.DispScreen                                            ' Display screen
         DoCursor                                                 ' Set cursor

         FUNCTION = 1                                             '
         EXIT FUNCTION                                            '
   END SELECT                                                     '
END FUNCTION                                                      '

SUB      DispUpdate(version AS STRING)                            '
'--------------------------------------------------------------------------------------------------+
'- Display the Update available dialog                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL rText AS STRING                                             '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Get Richedit available                                                                       |
   '-----------------------------------------------------------------------------------------------+
   LoadLibrary("Riched20.DLL")                                    ' Get RichEdit ready
   InitCommonControls                                             '

   '-----------------------------------------------------------------------------------------------+
   '- Build the dialog                                                                             |
   '-----------------------------------------------------------------------------------------------+
   DIALOG NEW 0, "SPFLite Update check",,, 220, 65, %WS_THICKFRAME OR %WS_CAPTION OR %WS_SYSMENU OR %WS_MAXIMIZEBOX TO ghUpdate  '
   CONTROL ADD LABEL, ghUpdate, %UPDATE_LABEL, "There is a new version of SPFLite available: " + version, 2, 4, 200, 32 '
   CONTROL ADD "RichEdit20A", ghUpdate, %UPDATE_RICHEDIT, "", 6, 50, 126, 110, _ '
                              %WS_CHILD OR %WS_VISIBLE OR %ES_MULTILINE OR %WS_VSCROLL _  '
                              OR %ES_NOHIDESEL OR %ES_AUTOVSCROLL OR %ES_WANTRETURN,  _   '
                              %WS_EX_CLIENTEDGE                   '
   CONTROL HANDLE ghUpdate, %UPDATE_RICHEDIT TO ghRich            ' Get edit's handle
   SendMessage(ghRich, %EM_AUTOURLDETECT, %True, 0)               ' Setup hyperlink
   SendMessage(ghRich, %EM_SETEVENTMASK, 0, %ENM_LINK)            '
   rText = "To visit the web download site, click here: http://www.SPFLite.com/Downloads " + CHR$(0)  ' Create and set some text
   SendMessage(ghRich, %WM_SETTEXT, 0, STRPTR(rText))             '
   DIALOG SHOW MODAL ghUpdate CALL DlgUpdateCallback              ' Display it all
   MExit                                                          '
END SUB                                                           '

CALLBACK FUNCTION DlgUpdateCallback()                             '
'--------------------------------------------------------------------------------------------------+
'- Callback for New Version Dialog                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL lpnmhdr AS NMHDR                                            '
LOCAL lpnmhdrPtr AS NMHDR PTR                                     '
   '-----------------------------------------------------------------------------------------------+
   '- If user clicked the Website link, go to it                                                   |
   '-----------------------------------------------------------------------------------------------+
   SELECT CASE AS LONG CBMSG                                      ' What'd we get
      CASE %WM_NOTIFY                                             ' NOTIFY
         lpnmhdrPtr = CBLPARAM                                    ' get a Pointer to the NMHDR structure
         lpnmhdr = @lpnmhdrPtr                                    '
         IF lpnmhdr.idFrom = %UPDATE_RICHEDIT THEN                ' MSDN says it's better to use nmhdr.idFrom
            SELECT CASE AS LONG lpnmhdr.code                      ' than Wparam for ID detection.
               CASE %EN_LINK                                      '
                  SetWindowLong(CBHNDL, %DWL_MSGRESULT, HandleHyperlink(CBHNDL, CBLPARAM))   '
            END SELECT                                            '
            FUNCTION = %True                                      ' Exit Function
         END IF                                                   '
         FUNCTION = %False                                        ' Exit Function

      CASE %WM_SIZE                                               '
         MoveWindow GetDlgItem(CBHNDL, %UPDATE_RICHEDIT), 4, 40, LOWRD(CBLPARAM) - 8, HIWRD(CBLPARAM) - 30, - 1   '
   END SELECT                                                     '
END FUNCTION                                                      '

FUNCTION  DispContext(tRow AS LONG) AS STRING                     '
'--------------------------------------------------------------------------------------------------+
'- Display the Context Menu                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i, RC  AS LONG, pt AS POINTAPI, sCmds AS STRING, Pop() AS STRING  '
LOCAL wpos AS RECT                                                '
    i = TP.TPFMDFlag(tRow - gFM_Top_File_Line + TP.GPTopLine)     ' Get flag type of the line
    SELECT CASE AS LONG i                                         ' Figure out what commands to offer
       CASE %FDirUp                                               ' Dir UP
          DIM Pop(1 TO 2) AS STRING                               ' Dim the array
          ARRAY ASSIGN Pop() = "1.Choose One", "2.Select"         ' Setup possibilities
          sCmds = ",S"                                            '
       CASE %FDirDown, %FDirLow                                   ' Dir DOWN
          DIM Pop(1 TO 6) AS STRING                               ' Dim the array
          ARRAY ASSIGN Pop() = "1.Choose One", "2.Select", "3.Browse", "4.Delete", "5.Rename", "7.Win Explorer"   '
          sCmds = ",S,B,D,R,WDIR"                                 '
       CASE %FEntry, %FFLEntry                                    ' A File Entry
          DIM Pop(1 TO 8) AS STRING                               ' Dim the array
          ARRAY ASSIGN Pop() = "1.Choose One", "2.Select", "3.Browse", "4.Edit", "5.View", "6.Delete", "7.Rename", "8.Win Explorer" '
          sCmds = ",S,B,E,V,D,R,WDIR"                             '
       CASE %FOpen                                                ' Open Files
          DIM Pop(1 TO 6) AS STRING                               ' Dim the array
          ARRAY ASSIGN Pop() = "1.Choose One", "2.Switch To", "3.Cancel","4.End", "5.Save", "6.Print" '
          sCmds = ",S,CAN,END,SAVE,P"                             '
       CASE %FPath                                                ' Open Files
          DIM Pop(1 TO 2) AS STRING                               ' Dim the array
          ARRAY ASSIGN Pop() = "1.Choose One", "2.Select"         ' Setup possibilities
          sCmds = ",S"                                            '
       CASE %FFileList                                            ' FLISTS
          DIM Pop(1 TO 7) AS STRING                               ' Dim the array
          ARRAY ASSIGN Pop() = "1.Choose One", "2.Select", "3.Browse", "4.Delete", "5.Edit", "6.Normalize", "7.Rename"  '
          sCmds = ",S,B,D,E,N,R"                                  '
       CASE %FConfig                                              ' Configs
          DIM Pop(1 TO 4) AS STRING                               ' Dim the array
          ARRAY ASSIGN Pop() = "1.Choose One", "2.Select", "3.Delete", "5.Rename"   '
          sCmds = ",S,D,R"                                        '
       CASE ELSE                                                  ' Anything else
          FUNCTION = "": EXIT FUNCTION                            ' Return null
    END SELECT                                                    '

    '----------------------------------------------------------------------------------------------+
                                                                  ' OK now try and display the menu                                                              |
    '----------------------------------------------------------------------------------------------+
    getcursorpos(pt)                                              ' Get cursor position on desktop
    GetWindowRect(ghWnd, wpos)                                    ' Get main window position
    RC = DoPopUp(Pop(), pt.x - wpos.Left, pt.y - wpos.Top - 20)   ' Do the PopUp
    FUNCTION = PARSE$(sCmds, RC)                                  ' Return the chosen answer
END FUNCTION                                                      '


CALLBACK FUNCTION DlgDiffListCallBack AS LONG                     '
LOCAL i AS LONG                                                   '
   SELECT CASE AS LONG CB.MSG                                     '

   CASE %WM_NOTIFY                                                '
      SELECT CASE CB.NMID                                         '
         CASE %DIFF_ListBox                                       '
            SELECT CASE CB.NMCODE                                 '
               CASE %LVN_ITEMCHANGED                              '
                  LISTVIEW GET SELECT ghDIFF, %DIFF_ListBox TO i  '
                     IF i THEN                                    '
                        gDiffClipNo = i                           '
                        DIALOG END ghDIFF                         '
                     END IF                                       '
            END SELECT                                            '
         END SELECT                                               '

      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '

            '--------------------------------------------------------------------------------------+
            '- Cancel                                        '                                     |
            '--------------------------------------------------------------------------------------+
            CASE %DIFF_LCancel                                    '
               gDiffClipNo = 0                                    ' Set 0 to indicate CANCEL
               DIALOG END ghDIFF                                  '
         END SELECT                                               '
   END SELECT                                                     '
END FUNCTION                                                      '

CALLBACK FUNCTION DlgAMBIGListCallBack AS LONG                    '
LOCAL i AS LONG, lclcmd AS STRING                                 '
LOCAL KeyDown AS LV_KEYDOWN PTR                                   '
STATIC PID AS DWORD                                               '

   SELECT CASE AS LONG CB.MSG                                     '

      CASE %WM_INITDIALOG                                         '
'-        LISTVIEW SELECT ghAmbig, %AMBIG_ListBox, 1
'-        ListView_SetItemState GetDlgItem(ghAmbig, %AMBIG_ListBox), -1, %LVIS_Focused, %LVIS_Focused
'-        CONTROL SET FOCUS ghAmbig, %AMBIG_ListBox

      CASE %WM_NOTIFY                                             '
         KeyDown = CBLPARAM                                       '
         SELECT CASE @KeyDown.hdr.code                            '
            CASE %LVN_KEYDOWN                                     '
               '-----------------------------------------------------------------------------------+
               '- Ignore cursor movement keys                                                      |
               '-----------------------------------------------------------------------------------+
               IF @Keydown.wVKey = %VK_UP      THEN FUNCTION = %TRUE : EXIT SELECT  '
               IF @Keydown.wVKey = %VK_DOWN    THEN FUNCTION = %TRUE : EXIT SELECT  '
               IF @Keydown.wVKey = %VK_LEFT    THEN FUNCTION = %TRUE : EXIT SELECT  '
               IF @Keydown.wVKey = %VK_RIGHT   THEN FUNCTION = %TRUE : EXIT SELECT  '
               FUNCTION = %FALSE                                  '
          END SELECT                                              '


         SELECT CASE CB.NMID                                      '
            CASE %AMBIG_ListBox                                   '
               SELECT CASE CB.NMCODE                              '
                  CASE %LVN_ITEMCHANGED                           '
                     LISTVIEW GET SELECT ghAMBIG, %AMBIG_ListBox TO i   '
                        IF i THEN                                 '
                           LISTVIEW GET USER ghAMBIG, %AMBIG_ListBox, i TO gHlpTopicNum   '
                           GOSUB InvokeHH                         '
                        END IF                                    '
               END SELECT                                         '
            END SELECT                                            '

      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '

            CASE %IDOK, %AMBIG_LProceed                           '
               LISTVIEW GET SELECT ghAMBIG, %AMBIG_ListBox TO i   '
               IF i THEN                                          '
                  LISTVIEW GET USER ghAMBIG, %AMBIG_ListBox, i TO gHlpTopicNum   '
                  GOSUB InvokeHH                                  '
               END IF                                             '

            '--------------------------------------------------------------------------------------+
            '- Main                                          '                                     |
            '--------------------------------------------------------------------------------------+
            CASE %AMBIG_LMain                                     '
               gHlpTopicNum = 0                                   ' Set 0 to indicate Main Menu
               GOSUB InvokeHH                                     '

            '--------------------------------------------------------------------------------------+
            '- BailOut                                       '                                     |
            '--------------------------------------------------------------------------------------+
            CASE %AMBIG_LBailOut                                  '
               gHlpTopicNum = -1                                  ' Set -1 to indicate BailOut
               PID = 0                                            ' Clear PID
               DIALOG END ghAMBIG                                 '

         END SELECT                                               '
   END SELECT                                                     '
   EXIT FUNCTION                                                  '

   InvokeHH:                                                      '
      IF PID <> 0 THEN _                                          ' If we have a started one
         SHELL("taskkill.exe /PID "+FORMAT$(PID)+" /T", 0)        ' Kill it
      lclcmd = gENV.EXEPath + "SPFLite.chm"                       ' Build path
      lclCmd = "hh.exe -mapid " + FORMAT$(gHlpTopicNum) + " " + lclcmd  ' Build command string
      PID = SHELL(lclCmd, gENV.HelpOpen)                          ' Start the shelled application:
      RETURN                                                      '
END FUNCTION                                                      '
