'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- FMLCmd.inc                                                                                      |
'--------------------------------------------------------------------------------------------------+
                                                                  '
METHOD  FMLCmdAdd(i AS LONG)                                      '
'---------- FM Add Favorite line command
LOCAL llist AS STRING                                             '
   MEntry                                                         '
   llist = IIF$(ISNOTNULL(gFMD(i).CmdOper), (gFMD(i).CmdOper), "Favorite Files") ' Set FLIST name
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by entry type
      CASE %FEntry, %FFLEntry, %FDirDown                          ' Normal file or Down Dir
         FileListAdd(llist, gFMD(i).FullPath, "", TimePretty(0))  ' Go add it

      CASE %FOpen                                                 ' Open files
         IF TRIM$(gFMD(i).FileName) = "(Clip)" OR _               ' Eliminate Special entries
            TRIM$(gFMD(i).FileName) = "(SET Edit)" OR _           '
            TRIM$(gFMD(i).FileName) = $New THEN                   '
            gFMD(i).Message = "Entry not eligible for Add to FILELIST"  '
            DoSet(%Msg): MExitMeth                                ' Get msg issued
         END IF                                                   '
         FileListAdd(llist, gFMD(i).FullPath, "", TimePretty(0))  ' Go add it
      CASE ELSE                                                   ' for not supported File types
         gFMD(i).Message = "Entry not added: " + TRIM$(gFMD(i).Filename)   '
         DoSet(%Msg): gFMD(i).Cmd = "": MExitMeth                 ' Get msg issued if not done
   END SELECT                                                     '
   gFMD(i).Message = "File added to " + UUCASE(llist) + ".FLIST"  '
   gFMD(i).Cmd = ""                                               ' Clear Cmd
   DoSet(%LoadData OR %Msg)                                       ' Get msg issued and data refreshed
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdAll(i AS LONG)                                      '
'--------------------------------------------------------------------------------------------------+
'- FM ALL line command                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL fn, mask,  rlist(), tlist(), tstyle, ACmd, DirPath, RQPath, RQMask, RQMode, RQDate AS STRING, ix, RC, delctr AS LONG '
LOCAL j, hFile, FNum AS LONG, hfile2 AS DWORD                     '
LOCAL CreationTime, LastAccessTime, LastWriteTime AS FILETIME     '
LOCAL SystemTimeArea AS SYSTEMTIME                                '
   MEntry                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Only certain entries supported                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF gFMD(i).Flag <> %FFileList THEN MLErrExit(i, "ALL is not supported for this entry type")  ' Kill if not a valid FILELIST

   '-----------------------------------------------------------------------------------------------+
   '- Better have a command operand                                                                |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(gFMD(i).CmdOper) THEN MLErrExit(i, "ALL requires a command operand")   ' Kill if no operand

   '-----------------------------------------------------------------------------------------------+
   '- Load and validate the FILELIST contents                                                      |
   '-----------------------------------------------------------------------------------------------+
   GOSUB LoadList                                                 ' Go load and validate the contents
   ACmd = UCASE$(gFMD(i).CmdOper)                                 ' Get UC Trimmed cmd
   SELECT CASE AS CONST$ ACmd                                     ' What command have we got?

      CASE "B", "BROWSE", "BRO"                                   ' Browse
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.CallTab("BROWSE", $DQ + tlist(ix) + $DQ)           '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE "CL", "CLONE"                                          ' Clone
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.CallTab("CLONE", $DQ + tlist(ix) + $DQ)            '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE "D", "DELETE", "DEL"                                   ' Delete
         FOR ix = 1 TO UBOUND(tlist())                            ' First check if not Open elsewhere
            IF VAL(FileQueue("S", " ", tlist(ix))) <> 0 THEN MLErrExit(i, "File is open elsewhere")   ' Open in some tab?
         NEXT ix                                                  '

         tstyle = IIF$(gENV.UseRecycle, "Send to Recycle Bin: ", "Permanently Delete: ")  ' Pick message text

         j = 99                                                   ' Set dummy value
         IF ISFALSE gENV.ConfDelFlag THEN                         ' Are we going to individually prompt?
            j = DoMessageBox("OK to |K" + tstyle + FORMAT$(UBOUND(tlist())) + "|B files", _  '
                          %MB_YESNO OR %MB_DEFBUTTON2 OR %MB_USERICON, "SPFLite Delete")  '
            IF j = %IDNO THEN MExitMeth                           ' Ignore if told not to
         END IF                                                   '

         FOR ix = 1 TO UBOUND(tlist())                            ' Now actually Do it
            IF gENV.ConfDelFlag AND j <> %IDOK AND j <> %IDYES THEN  ' Need we prompt user for an OK?
               j = DoMessageBox("OK to |K" + tstyle + tlist(ix), %MB_YESNOCANCEL OR %MB_DEFBUTTON2 OR %MB_USERICON, "SPFLite Delete")  '
               IF j = %IDNO THEN ITERATE FOR                      ' Ignore if told not to
               IF j = %IDCANCEL THEN MExitMeth                    ' Bail out
            END IF                                                '
            RC = FileRecycleBin(tlist(ix), IIF$(LEFT$(tstyle, 1) = "R", "D", "U"))  '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Refresh Data
         MLErrExit(i, FORMAT$(delctr) + " files deleted")         ' Issue message and exit

      CASE "E", "EDIT"                                            ' Edit
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.CallTab("EDIT", $DQ + tlist(ix) + $DQ)             '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE "M", "MEDIT"                                           ' Multi-Edit
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            IF ISNULL(MEditCmd) THEN                              ' First M command?
               MEditCmd += $DQ + tlist(ix) + $DQ + " "            '
               MEditCmd += " NEW "                                '
            ELSE                                                  ' Else just add a filename on
               MEditCmd += $DQ + tlist(ix) + $DQ + " "            '
            END IF                                                '
         NEXT ix                                                  '
         me.CallTab("MEDIT", MEditCmd)                            '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE "O", "OPEN"                                            ' OPEN Edit
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.CallTab("OPEN", $DQ + tlist(ix) + $DQ)             '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE "OV", "OPENV"                                          ' OPEN View
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.CallTab("OPENV", $DQ + tlist(ix) + $DQ)            '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE "OB", "OPENB"                                          ' OPEN Browse
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.CallTab("OPENB", $DQ + tlist(ix) + $DQ)            '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE "P", "PRINT"                                           ' Print
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.FMLCmdPrintIt($DQ + tlist(ix) + $DQ, 0)            '
         NEXT ix                                                  '

      CASE "T", "TOUCH"                                           ' Touch
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            ON ERROR GOTO TchError                                ' Ignore errors
            hFile = FREEFILE                                      ' Touch the file now
            OPEN tlist(ix) FOR APPEND ACCESS READ WRITE LOCK SHARED AS #hFile '
            hFile2 = FILEATTR(hFile,2)                            ' Get Windows handle for the file
            GetFileTime hFile2, CreationTime, LastAccessTime, LastWriteTime   ' Fetch timestamps
            GetSystemTime SystemTimeArea                          ' Get the current time
            SystemtimeToFileTime SystemTimeArea, LastWriteTime    ' Put it in LastWriteTime
            SetFileTime hFile2, CreationTime, LastAccessTime, LastWriteTime   '
            TchExit:                                              '
            CLOSE #hFile                                          ' Close it
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh
         MLErrExit(i, "All files Touched")                        '

      CASE "V", "VIEW"                                            ' View
         FOR ix = 1 TO UBOUND(tlist())                            ' OK loop actually DOING it
            me.CallTab("VIEW", $DQ + tlist(ix) + $DQ)             '
         NEXT ix                                                  '
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE ELSE                                                   '
         MLErrExit(i, "Unsupported ALL command: " + UCASE$(gFMD(i).CmdOper))  '
   END SELECT                                                     '
   MExitMeth                                                      '

TchError:                                                         '
   RESUME TchExit                                                 '

LoadList:                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Load FILELIST and validate the contents                                                      |
   '-----------------------------------------------------------------------------------------------+
   fn = gENV.HomeData + "FILELIST\" + TRIM$(gFMD(i).FileName)               ' Build the filename
   FNum = FREEFILE                                                ' Get a file number
   Call3(TryOpenInput(fn, FNum), _                                ' Try the open
         MErrExit(%eFail, "FILELIST: " + fn + " doesn't exist"), _   ' Oops?  Bail out
         MErrExit(%eFail, "OPEN of FILELIST: " + fn + " failed"), _  ' Oops?  Bail out
         Nul)                                                     ' Continue
   '-----------------------------------------------------------------------------------------------+
   '- Get # records, DIM our table and load the file                                               |
   '-----------------------------------------------------------------------------------------------+
   FILESCAN # FNum, RECORDS TO ix                                 ' Get the number of records
   IF ix > 0 THEN                                                 ' Some records?
      REDIM rlist(1 TO ix) AS STRING                              ' Redim array to match save data
      LINE INPUT # FNum, rlist() TO ix                            ' Read it all
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Close the file now                                                                           |
   '-----------------------------------------------------------------------------------------------+
   CLOSE # FNum                                                   ' Close the File

   '-----------------------------------------------------------------------------------------------+
   '- Do various validation stuff                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF ix = 0 THEN MLErrExit(i, "The FILELIST was empty")          ' Nothing?

   '-----------------------------------------------------------------------------------------------+
   '- Process the loaded entries                                                                   |
   '-----------------------------------------------------------------------------------------------+
   REDIM tlist(1 TO 1) AS STRING                                  ' Reset tlist
   tlist(1) = ""                                                  ' Null 1st entry
   ix = 0                                                         ' Reset index
   FOR j = 1 TO UBOUND(rlist())                                   ' Loop through the loaded FILELIST entries
      me.RQSplit(rlist(j), RQPath, RQMask, RQMode, RQDate)        ' Split it up
      IF RIGHT$(RQPath, 1) <> "\" THEN                            ' A simple file name?
         IF ISFILE(RQPath) THEN                                   ' File still exist?
            INCR ix                                               ' Count found entry
            REDIM PRESERVE tlist(1 TO ix) AS STRING               ' Resize table
            tlist(ix) = RQPath                                    ' Save this filename
         ELSE                                                     '
            MLErrExit(i, "FILELIST entry: " + RQPath + " no longer exists")   '
         END IF                                                   '

      ELSE                                                        ' Must be a path entry
         DirPath = RQPath                                         ' Save Dir path
         Fn = DIR$(BUILD$(DirPath, "*"), 22)                      ' Search for 1st * filename  (22 = Normal, hidden, system, Dirs)
         DO WHILE ISNOTNULL(Fn)                                   ' Loop
            IF ISTRUE me.TestMask(TRIM$(fn), RQMask) THEN         ' If we pass the Mask test
               INCR ix                                            ' Count found entry
               REDIM PRESERVE tlist(1 TO ix) AS STRING            ' Resize table
               tlist(ix) = DirPath + fn                           ' Save this filename
            END IF                                                '
            Fn = DIR$(NEXT)                                       '
         LOOP                                                     '
      END IF                                                      '
   NEXT j                                                         '
   RETURN                                                         ' We're OK if we made it to here

END METHOD                                                        '

METHOD  FMLCmdBackup(i AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- FM Create a Backup copy                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL lclFileName, CallType, MSG  AS STRING, RCA AS RCArea        '

   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Clear command char
   CallType = "!"                                                 ' Set default Calltype

   IF ISNOTNULL(gFMD(i).CmdOper) THEN                             ' If a 2nd operand
      IF gFMD(i).CmdOper <> "?" THEN _                            ' It can only be a ?
         MLErrExit(i, "BACKUP 2nd operand is invalid, only ? allowed")  '
      CallType = "?"                                              ' Set query CallType
   END IF                                                         '

   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by type

      CASE %FEntry, %FFLEntry                                     ' Normal File
         '-----------------------------------------------------------------------------------------+
         '- OK, Finally try the Backup                                                             |
         '-----------------------------------------------------------------------------------------+
         lclFileName = CallType + gFMD(i).FullPath                ' Get the Filename
         DoBackup(lclFileName, %Edit, RCA)                        ' Go do the Backup
         MSG = RCA.Msg                                            ' Copy the message
      CASE ELSE                                                   '
         MLErrExit(i, "BACKUP is not supported for this entry type") '
   END SELECT                                                     '

   gFMD(i).Message = MSG                                          '
   DoSet(%Msg)                                                    ' Get msg issued
   DoSet(%LoadData)                                               ' Ask for refresh
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD   FMLCmdBrowse(i AS LONG)                                  '
'--------------------------------------------------------------------------------------------------+
'- FM Browse line command                                                                          |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by entry type
      CASE %FEntry, %FFLEntry, %FFileList                         ' Existing File?
         me.DoBROWSE(i)                                           ' Go do Browse
         DoSet(%LoadData)                                         ' Ask for refresh

      CASE %FDirDown                                              ' Dir Down
         me.DoDirDown(i)                                          ' Go do it

      CASE %FDirUp                                                ' Dir Up
         me.DoDirUp(i)                                            ' Go do it

      CASE ELSE                                                   ' A Config?
         MLErrExit(i, "BROWSE not supported for this entry type") '

   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdCancel(i AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- FM CANCEL line command                                                                          |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF gFMD(i).Flag <> %FOpen THEN MLErrExit(i, "CANCEL only usable against OPEN files")   ' An OPEN entry?
   DoCmdInOtherTab(gFMD(i).Uniq, "CANCEL ")                       '
   DoSet(%LoadData)                                               ' Ask for refresh
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdClone(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- FM Clone line command                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL cmd, SetProf AS STRING                                      '
   MEntry                                                         '
   IF ISNOTNULL(gFMD(i).CmdOper) THEN                             ' Another operand?
      IF LEFT$(gFMD(i).CmdOper, 1) = "." THEN                     ' Look like a Profile?
         SetProf = UUCASE(gFMD(i).CmdOper)                        ' Save as Profile name
      ELSE                                                        '
         MLErrExit(i, "CLONE unknown operand: " + gFMD(i).CmdOper)   ' Get msg issued
      END IF                                                      '
   END IF                                                         '
   gFMD(i).Cmd = " "                                              ' Blank the command area

   SELECT CASE AS LONG gFMD(i).Flag                               ' Split off
      CASE %FEntry, %FFLEntry, %FFileList                         ' Normal type File
         cmd = $DQ + gFMD(i).FullPath + $DQ + " " + SetProf       '

      CASE %FOpen                                                 ' Open file list
         IF TRIM$(gFMD(i).FileName) = "(Clip)" OR _               ' Eliminate Special entries
            TRIM$(gFMD(i).FileName) = "(SET Edit)" OR _           '
            TRIM$(gFMD(i).FileName) = "(EFT Edit)" OR _           '
            TRIM$(gFMD(i).FileName) = $New THEN MExitMeth         '
         cmd = $DQ + gFMD(i).FullPath + $DQ + " " + SetProf       '

      CASE  ELSE                                                  '
         MLErrExit(i, "CLONE is not supported for this entry type")  ' Get msg issued
   END SELECT                                                     '
   me.CallTab("CLONE", cmd)                                       '
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdCopy(i AS LONG)                                     '
'--------------------------------------------------------------------------------------------------+
'- FM C/CC line command                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL cmd, SetProf AS STRING                                      '
   MEntry                                                         '
   IF UCASE$(GetNextWord(PCommand, %NoStrip)) <> "CUT" THEN       ' Only valid with CUT comamnd
      MLErrExit(i, "C/CC can only be used with a CUT command")    ' GET MSG issued
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdDelete(i AS LONG, which AS STRING)                  '
'--------------------------------------------------------------------------------------------------+
'- FM Delete line command                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lclPath, lclDrive, DelDrive, DelPath, DelFn, DelState AS STRING   '
LOCAL tstyle, lfPath, lfFile, t AS STRING                         '
LOCAL j, k, RC, InBackup AS LONG                                  '

   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by entry type
      CASE %FEntry, %FFLEntry, %FFileList, %FDirDown, %FConfig    ' Normal type file
      CASE ELSE                                                   ' Ignore all others
         MLErrExit(i, "Can't Delete this entry type")             ' GET MSG issued
   END SELECT                                                     '

   '-----------------------------------------------------------------------------------------------+
   '- Handle Configs differently                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF gFMD(i).Flag = %FConfig THEN                                ' Do Configs here.
      IF TRIM$(MID$(gFMD(i).FileName, 11)) = "DEFAULT" THEN      _   ' Prevent stupidity
         MLErrExit(i, "Can't Delete the DEFAULT entries")         ' GET MSG issued
      IF LEFT$(gFMD(i).FileName, 10) = "Profile:  " THEN          ' The Profile Type?
         gSQL.TableDelete("P" + TRIM$(MID$(gFMD(i).FileName, 11)))   ' Delete the PRF table
      ELSE                                                        ' Must be the Instance type
         IF TRIM$(MID$(gFMD(i).FileName, 11)) = gENV.eInstance THEN _   '
            MLErrExit(i, "Can't Delete the active Instance")      '
         gSQL.TableDelete("O" + TRIM$(MID$(gFMD(i).FileName, 11)))   ' Delete the Options table
         gSQL.TableDelete("E" + TRIM$(MID$(gFMD(i).FileName, 11)))   ' Delete the EFT table
         gSQL.TableDelete("K" + TRIM$(MID$(gFMD(i).FileName, 11)))   ' Delete the KBD table
         gSQL.TableDelete("S" + TRIM$(MID$(gFMD(i).FileName, 11)))   ' Delete the SET table
         gSQL.TableDelete("R" + TRIM$(MID$(gFMD(i).FileName, 11)))   ' Delete the RTR table
      END IF                                                      '
      gFMD(i).Cmd = " "                                           ' Blank the command area
      Doset(%LoadData OR %Refresh)                                ' Reload things
      MExitMeth                                                   ' Exit
   END IF                                                         '

   IF (gFMD(i).FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY THEN _   ' If RO
      MLErrExit(i, "Can't Delete a Read-Only file")               ' GET MSG issued

   lfPath = TRIM$(gFMD(i).DPath)                                  ' Simplify coding
   lfFile = TRIM$(gFMD(i).FileName)                               '
   DelFn = lfPath + lfFile                                        ' What we're deleting

   '-----------------------------------------------------------------------------------------------+
   '- Do fudges for deletes within a $BACKUP folder                                                |
   '-----------------------------------------------------------------------------------------------+
   IF RIGHT$(lfPath, 9) = "\$BACKUP\" THEN                        ' Are we in a $BACKUP folder?
      InBackup = %True                                            ' Yes, remember that
      t = PCRERegexCompile("\.[0-9]{6}\-[0-9]{6}\.[0-9]{6}")      ' Setup PCRE Search for .999999-999999.999999
      PCRERegexTest(DelFn, 1, j, k)                               ' Look like a Backup file?
      IF j <> 0 AND k = 21 THEN                                   ' Look reasonable?
         IF uucase(RIGHT$(DelFn, 6)) = ".STATE" THEN              ' Dumb user select STATE?
            DelState = DelFn: DelFn = CLIP$(RIGHT, DelFn, 6)      ' Yes, swap them around
            IF ISFALSE ISFILE(DelFn) THEN                         ' If base file already gone (somehow?)
               DelFn = DelState: DelState = ""                    ' Swap back and null State name.
            END IF                                                '
         ELSE                                                     ' No, the backup file itself
            DelState = DelFn + ".STATE"                           ' Build the STATE file name
            IF ISFALSE ISFILE(DelState) THEN DelState = ""        ' If it doesn't exist, null the State name
         END IF                                                   '
      END IF                                                      '
   '-----------------------------------------------------------------------------------------------+
   '- Look for STATE in non $BACKUP folders                                                        |
   '-----------------------------------------------------------------------------------------------+
   ELSE                                                           ' Not a $BACKUP folder
      DelState = DelFn + ".STATE"                                 ' Build the STATE file name
      REPLACE ANY ":\/" WITH "```" IN DelState                    ' Make : / and \ into `
      DelState = gENV.HomeData + "STATE\" + DelState              ' Add our STATE folder
      IF ISFALSE ISFILE(DelState) THEN DelState = ""              ' If not there, null the State name
   END IF                                                         '

   lclPath = CURDIR$                                              ' Get current path
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save it
   IF MID$(lfPath, 2, 1) = ":" THEN                               ' Extract Drive if present
      DelDrive = LEFT$(lfPath, 2)                                 ' and save it
      DelPath = MID$(lfPath, 3)                                   '
      IF ISNULL(DelPath) THEN DelPath = "\"                       ' In case we're at the root
   END IF                                                         '
   IF RIGHT$(TRIM$(DelFn), 1) = "\" THEN                          ' Is this the DIR name?
      DelFn = LEFT$(DelFn, LEN(TRIM$(DelFn)) - 1)                 ' Remove the last \
   END IF                                                         '
   IF VAL(FileQueue("S", " ", lfPath + lfFile)) <> 0 THEN MLErrExit(i, "File open elsewhere: " + Delfn)  ' Open in some tab?
   IF gFMD(i).Flag <> %FDirDown THEN                              ' Not a Downward Directory?
      IF ISFALSE ISFILE(DelFn) THEN MLErrExit(i, "File no longer exists: " + DelFn) '
   END IF                                                         '

   tstyle = IIF$(which = "D", "Delete to Recycle Bin: ", "Permanently Delete: ") ' Pick message text

   IF gENV.ConfDelFlag  AND (gFMDeleteAll = %False) THEN          ' Need we prompt user for an OK?
      IF InBackup  THEN                                           ' In a $BACKUP folder?
         j = DoMessageBox("OK to " + tstyle + $CRLF + _           '
                          "Backup: |K" + DelFn + "   " + _        '
                          IIF$(DelState = "", "", $CRLF + "|BState   : |K" + DelState) + $CRLF +  _   '
                          SPACE$(80) + $CRLF + _                  '
                          "&Delete this one" + $CRLF + _          '
                          "Delete &ALL" + $CRLF + _               '
                          "&CANCEL Delete", _                     '
                          %MB_Custom3 + %MB_DEFBUTTON3 + %MB_USERICON, "SPFLite Delete")  '
      ELSE                                                        ' No, a normal file
         j = DoMessageBox("OK to " + tstyle + "|K" + $CRLF + _    '
                          "|BFile    : |K" + DelFn + " " + $CRLF + _ '
                          IIF$(DelState = "", "", "|BState : |K" + DelState) + $CRLF +  _ '
                          SPACE$(80) + $CRLF + _                  '
                          "&Delete this one" + $CRLF + _          '
                          "Delete &ALL" + $CRLF + _               '
                          "&CANCEL Delete", _                     '
                          %MB_Custom3 + %MB_DEFBUTTON3 + %MB_USERICON, "SPFLite Delete")  '
      END IF                                                      '
      IF j = %IDCustom1 THEN                                      ' OK?
         GOSUB DoADel                                             ' Actually Do the Delete
      ELSEIF j = %IDCustom2 THEN                                  ' OK to ALL
         GOSUB DoADel                                             ' Actually Do the Delete
         gFMDeleteAll = %True                                     ' Set DELETE ALL
      ELSE                                                        ' NO
         MExitMeth                                                '
      END IF                                                      '
   ELSE                                                           '
      GOSUB DoADel                                                ' Actually Do the Delete
   END IF                                                         '
   IF DelDrive <> lclDrive THEN CHDRIVE lclDrive                  ' Switch drive if needed
   CHDIR lclPath                                                  ' put back the original path

   IF RC = 75 THEN                                                '
      MLErrExit(i, DelFn + " is not Empty")                       '
   ELSEIF RC <> 0 THEN                                            '
      MLErrExit(i, "Delete of: " + DelFn + " unsuccessful")       '
   END IF                                                         '

   IF ISNOTNULL(FileListNm) AND FileListNm <> "FLISTS" THEN       ' A real FILELIST entry
      FileListDelete(FileListNm, gFMD(i).FullPath)                ' Remove from FILELIST
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get STATE name if available                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF DelState <> "" THEN                                         ' Does STATE exist?
      RC = FileRecycleBin(DelState, LEFT$(which, 1))              ' Yes, go delete it
   END IF                                                         '

   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExitMeth                                                      '

   DoADel:                                                        '
      IF DelDrive <> lclDrive THEN CHDRIVE DelDrive               '
      CHDIR DelPath                                               '
      IF gFMD(i).Flag <> %FDirDown THEN                           ' Not a Downward Directory?
         RC = FileRecycleBin(DelFn, LEFT$(which, 1))              '
      ELSE                                                        '
         RMDIR DelFn                                              ' Dir DEL
         RC = ERR                                                 '
      END IF                                                      '
      DoSet(%LoadData)                                            ' Ask for refresh
      RETURN                                                      '
END METHOD                                                        '

METHOD  FMLCmdDir(i AS LONG)                                      '
'--------------------------------------------------------------------------------------------------+
'- Switch to this file's DIR Folder                                                                |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by type
      CASE %FEntry, %FFLEntry, %FOpen                             ' Normal file entry
         FMask = "*"                                              ' Set the FileMask for FM
         FPath = RTRIM$(gFMD(i).DPath)                            ' Set the path
         FileListNm = ""                                          ' Null any FILELIST setting
         gSQL.UpdateString("O", "DefDir1", FPath)                 '
         gSQL.UpdateString("O", "DefMask", FMask)                 '
         gSQL.UpdateString("O", "FileListNm", FileListNm)         '
         DoSet(%LoadReq)                                          ' Full refresh
      CASE ELSE                                                   '
         MLErrExit(i, "DIR is only for normal File entries")      '
   END SELECT                                                     '
   MExit                                                          '
END METHOD                                                        '

METHOD   FMLCmdEdit(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- FM Edit line command                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL SaveProf, p AS STRING, RCA AS RCArea                        '
   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by entry type
      CASE %FEntry, %FFLEntry, %FFileList                         ' Existing File?
         me.DoEDIT(i)                                             ' Go do Edit

      CASE %FDirDown                                              ' Dir Down
         me.DoDirDown(i)                                          ' Go do it

      CASE %FDirUp                                                ' Dir Up
         me.DoDirUp(i)                                            ' Go do it

      CASE %FConfig                                               ' Config?
         IF LEFT$(gFMD(i).FileName, 10) = "Profile:  " THEN       ' The Profile Type?
            SaveProf = IIF$(FCB.ProfName <> "", FCB.ProfName, "DEFAULT")   ' Save where we are
            p = TRIM$(MID$(gFMD(i).FileName, 11))                 ' Get Profile name
            FCB.SetupProf(p, RCA)                                 ' Setup
            FCB.EditProf                                          ' Let user Have a look
            FCB.SetupProf(SaveProf, RCA)                          '
            CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB              ' Set focus
         ELSE                                                     ' Must be the Instance type
            IF TRIM$(MID$(gFMD(i).FileName, 11)) <> gENV.eInstance THEN _  '
               MLErrExit(i, "EDIT only available for the active Instance") '
            pCmdOptions("")                                       ' Let Options have a go
            CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB              ' Set focus
         END IF                                                   '
      CASE ELSE                                                   '
         MLErrExit(i, "EDIT not supported for this type of entry")   '

   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   DoSet(%LoadData)                                               ' Ask for refresh
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdEFT(i AS LONG)                                      '
'--------------------------------------------------------------------------------------------------+
'- FM EFT test command                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL fn, PName, PDiag AS STRING                                  '
   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split off

      CASE %FEntry, %FFLEntry, %FFileList                         ' Existing file
         fn = gFMD(i).FullPath                                    ' Get this line's filename
         pName = GetProfileForFile(fn, PDiag, %False, %True)      ' Extract the extension, get PDiag (NoEFT,Query)
         gFMD(i).Message = PDiag                                  ' Pass back answer
         DoSet(%Msg)                                              ' Get msg issued

      CASE ELSE                                                   '
         gFMD(i).Message = "EFT cannot be used on this type of entry"   '
         DoSet(%Msg)                                              ' Get msg issued
   END SELECT                                                     '
   MExitMeth                                                      '
END METHOD                                                        '

METHOD  FMLCmdEnd(i AS LONG)                                      '
'--------------------------------------------------------------------------------------------------+
'- FM END line command                                                                             |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF gFMD(i).Flag <> %FOpen THEN MLErrExit(i, "END only usable against OPEN files")   ' An OPEN entry?
   DoCmdInOtherTab(gFMD(i).Uniq, "END ")                          ' Call END
   DoSet(%LoadData)                                               ' Ask for refresh
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdExclude(i AS LONG)                                  '
'--------------------------------------------------------------------------------------------------+
'- FM Exclude line command                                                                         |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF gFMD(i).Flag = %FEntry OR gFMD(i).Flag = %FFLEntry OR gFMD(i).Flag = %FFileList THEN   '
      gFMD(i).Cmd = " "                                           ' Clear command char
      me.IncRXSize                                                ' Allocate an RX slot
      gFMRXList(gFMRXCount) = TRIM$(gFMD(i).DPath) + TRIM$(gFMD(i).FileName)  ' Create an Exclude entry
      DoSet(%LoadData)                                            ' Have it take effect
   ELSE                                                           '
      MLErrExit(i, "Exclude cannot be used on this Entry type")   '
   END IF                                                         '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdForget(i AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- FM Forget line command                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL j AS LONG, fn, RQPath, RQMask, RQMode, RQDate AS STRING     '
   MEntry                                                         '
   IF FMode <> %FMFilelist AND FMode <> %FMRecPaths THEN MLErrExit(i, "FORGET can only be used with FILELIST displays") '
   IF FMode = %FMRecPaths THEN                                    ' Recent Paths?
      fn = gFMD(i).DPath                                          ' Pick up DPath
   ELSE                                                           '
      fn = gFMD(i).DPath                                          ' Start with DPath
      IF TRIM$(gFMD(i).DPath) <> TRIM$(gFMD(i).FileName) THEN _   ' If not the \\\ version
         fn = gFMD(i).FullPath                                    ' Swap to FullPath
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- See if it's in the Request list                                                              |
   '-----------------------------------------------------------------------------------------------+
   FOR j = 1 TO gFMRQCount                                        ' Spin through RQ table
      me.RQSplit(gFMRQList(j), RQPath, RQMask, RQMode, RQDate)    ' Split operands
      IF IsEQ(fn, RQPath) THEN                                    ' We have a match
         FileListDelete(FileListNm, RQPath)                       ' Delete it from the FLIST
         DoSet(%LoadReq)                                          ' Ask for FILELIST to be re-loaded
         MExitMeth                                                '
      END IF                                                      '
      IF IsEQ(fn + "\\", RQPath) THEN                             ' Try the \\\ version as well
         FileListDelete(FileListNm, fn + "\\")                    ' Delete it from the FLIST
         DoSet(%LoadReq)                                          ' Ask for FILELIST to be re-loaded
         MExitMeth                                                '
      END IF                                                      '
   NEXT j                                                         '
   MLErrExit(i, "FORGET skipped, file was listed via a Generic Path request") '
END METHOD                                                        '

METHOD  FMLCmdFProp(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- Open File Properties for a file                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL lclpath AS WSTRINGZ * %MAX_PATH                             '
   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by Entry type
      CASE %FEntry, %FFLEntry                                     ' File type?
         lclPath = gFMD(i).FullPath                               ' Build the full Set the filename
         AfxShowFileProperties(%HWND_DESKTOP, lclPath)            ' Open the file property menu

      CASE ELSE                                                   '
         MLErrExit(i, "FP is not supported for this entry type")  '
   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD   FMLCmdIEdit(i AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- FM IEdit line command                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL SaveProf, p AS STRING, RCA AS RCArea                        '
   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by entry type
      CASE %FEntry, %FFLEntry, %FFileList                         ' Existing File?
         me.DoIEDIT(i)                                            ' Go do Edit

      CASE ELSE                                                   '
         MLErrExit(i, "IEDIT not supported for this type of entry")  '
   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   DoSet(%LoadData)                                               ' Ask for refresh
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdLines(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- FM LINES line command                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL fn, PDiag AS STRING, SaveTop, Uncond AS LONG, RCA AS RCArea '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   IF UCASE$(gFMD(i).CmdOper) = "U" THEN Uncond = %True           ' UNCOND requested?
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split off

      CASE %FEntry, %FFLEntry                                     ' Eligible File?
         '-----------------------------------------------------------------------------------------+
         '- Look at it's data                                                                      |
         '-----------------------------------------------------------------------------------------+
         fn = gFMD(i).FullPath                                    ' Get the filename
         SaveTop = @P.PTopLine                                    ' Save TopScrn around LInitTxtData
         me.LInitTxtData()                                        ' Initialize our Text area
         FCB.SetupFN(fn, %ProfGetN, RCA)                          ' Set filename in FCB area
         FCB.SetupProf(GetProfileForFile(fn, PDIag, %True, %False), RCA)   ' Get Prof. (EFT,NotQuery)
         IF RCA.RC = 0 THEN                                       ' Profile OK
            IF me.InitaFile(%True) THEN                           ' Initialize file stuff with quick
               gFMD(i).Message = "LINES cannot be used on this type of entry" '
               DoSet(%Msg)                                        ' Get msg issued
            END IF                                                '
         ELSE                                                     '
            gFMD(i).Message = "LINES cannot be used on this type of entry" '
            DoSet(%Msg)                                           ' Get msg issued
         END IF                                                   '
         @P.PTopLine = SaveTop                                    ' Save TopScrn around LInitTxtData
         IF FCB.StateFlag = %StateOff THEN                        ' If STATE OFF for this filetype
            gFMD(i).Message = "File has PROFILE STATE OFF, LINES skipped"  '
            DoSet(%Msg)                                           ' Get msg issued
         ELSE                                                     '
            IF gFMD(i).LinesInt = -1 OR ISTRUE Uncond THEN        ' If no current LINES or Uncond
               me.StateSave(fn, 1, LastLine, %False)              ' Go setup/refresh STATE data
               gFMD(i).LinesInt = GetStateLines(fn)               ' Get Line count from STATE
               gFMD(i).Message = "File STATE information updated."   '
               DoSet(%Msg)                                        ' Get msg issued
            END IF                                                '
         END IF                                                   '
         FileQueue("D", " ", TP.FCB_.FilePath)                    ' Remove from Open queue
      CASE ELSE                                                   '
         gFMD(i).Message = "LINES cannot be used on this type of entry" '
         DoSet(%Msg)                                              ' Get msg issued
   END SELECT                                                     '
END METHOD                                                        '

METHOD  FMLCmdMEdit(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- FM MEdit line command                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL FNum AS LONG, fn, t1, t2 AS STRING                          '
   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Clear command char
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split off
      CASE %FEntry, %FFLEntry                                     ' A valid entry?
         IF ISNULL(MEditCmd) THEN                                 ' First M command?
            MEditCmd = "NEW " + $DQ + gFMD(i).FullPath + $DQ + " "   ' Start with NEW
         ELSE                                                     ' Else just add a filename on
            MEditCmd += $DQ + gFMD(i).FullPath + $DQ + " "        '
         END IF                                                   '

      CASE %FFileList                                             ' A FileList?
         FNum = FREEFILE: fn = gFMD(i).FullPath                   ' Get a file number and filename
         Call3(TryOpenInput(fn, FNum), _                          ' Try the open
            MErrExit(%eFail, "FILELIST: " + fn + " doesn't exist"), _   ' Oops?  Bail out
            MErrExit(%eFail, "OPEN of FILELIST: " + fn + " failed"), _  '
            Nul)                                                  ' Continue
         MEditCmd = "NEW "                                        ' Start building the command
         DO WHILE ISFALSE EOF(FNum)                               ' Process the FLIST
            LINE INPUT # FNum, t1                                 ' Read a line
            t2 = LEFT$(t1, INSTR(t1, "|") - 1)                    ' Extract the filename
            MEditCmd += t2 + " "                                  ' add to command
         LOOP                                                     '                                                   '
         CLOSE # FNum                                             ' Close the FLIST

      CASE ELSE                                                   '
   END SELECT                                                     '
   DoSet(%LoadData)                                               ' Ask for refresh
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdNorm(i AS LONG)                                     '
'--------------------------------------------------------------------------------------------------+
'- FM Normalize line command                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL fn AS STRING, FNum, j, k, fremoved, premoved, altered AS LONG, tlist() AS STRING '
LOCAL RQPath, RQMask, RQMode, RQDate AS STRING                    '
   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split off

      CASE %FFileList                                             ' A FILELIST?
         '-----------------------------------------------------------------------------------------+
         '- Look at it's data                                                                      |
         '-----------------------------------------------------------------------------------------+
         fn = gFMD(i).FullPath                                    ' Get the filename
         FNum = FREEFILE                                          ' Get a file number
         Call3(TryOpenInput(fn, FNum), _                          ' Try the open
               MErrExit(%eFail, "FILELIST: " + fn + " doesn't exist"), _   ' Oops?  Bail out
               MErrExit(%eFail, "OPEN of FILELIST: " + fn + " failed"), _  ' Oops?  Bail out
               Nul)                                               ' Continue
         FILESCAN # FNum, RECORDS TO k                            ' Get the number of records
         IF k > 0 THEN                                            ' Some records?
            REDIM tlist(1 TO k) AS STRING                         ' Redim array to match save data
            LINE INPUT # FNum, tlist() TO j                       ' Read it all
         END IF                                                   '
         CLOSE #FNum                                              ' Close it

         '-----------------------------------------------------------------------------------------+
         '- Scan the lines in the file for our verify                                              |
         '-----------------------------------------------------------------------------------------+
         IF j THEN                                                ' Did we get some records?
            FOR k = j TO 1 STEP -1                                ' OK, let's scan the records
               IF TRIM$(tlist(k)) = "" THEN                       ' Null record?
                  ARRAY DELETE tlist(k)                           ' Remove it
                  DECR j: altered = %True                         ' Reduce count, remember we altered it
                  ITERATE FOR                                     '
               END IF                                             '

               me.RQSplit(tlist(k), RQPath, RQMask, RQMask, RQDate)  ' Split out operands
               IF RIGHT$(RQPath, 1) = "\" THEN                    ' Is this a Path request?
                  IF ISFALSE ISFOLDER(RQPath) THEN                ' If it doesn't still exist?
                     ARRAY DELETE tlist(k)                        ' Remove it
                     DECR j: altered = %True                      ' Reduce count, remember we altered it
                     INCR premoved                                ' Count paths removed
                  END IF                                          '

               ELSE                                               ' This is a specific file entry
                  IF ISFALSE ISFILE(RQPath) THEN                  ' If it doesn't still exist
                     ARRAY DELETE tlist(k)                        ' Remove it
                     DECR j: altered = %True                      ' Reduce count, remember we altered it
                     INCR fremoved                                ' Count files removed
                  END IF                                          '
               END IF                                             '
            NEXT k                                                '
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- Re-write the FILELIST if it still contains something                                   |
         '-----------------------------------------------------------------------------------------+
         IF j > 0 AND altered THEN                                '
            FNum = FREEFILE                                       ' Get a file number
            Call3(TryOpenOutPut(fn, FNum), _                      ' Try the open
                  MErrExit(%eFail, "FILELIST: " + FileListNm + " Write OPEN failed"), _   ' Oops?  Bail out
                  MErrExit(%eFail, "FILELIST: " + FileListNm + " is in use"), _  ' Oops?  Bail out
                  Nul)                                            ' Continue
            FOR k = 1 TO j                                        ' Write things
               IF TRIM$(tlist(k)) <> "" THEN PRINT # FNum, tlist(k)  '
            NEXT k                                                '
            CLOSE # FNum                                          '
            IF premoved = 0 AND fremoved = 0 THEN                 ' Choose message to issue
               gFMD(i).Message = "All entries normalized"         '
            ELSEIF premoved > 0 AND fremoved = 0 THEN             '
               gFMD(i).Message = FORMAT$(premoved) + " empty path request(s) removed"  '
            ELSEIF premoved = 0 AND fremoved > 0 THEN             '
               gFMD(i).Message = FORMAT$(fremoved) + " empty/forgotten filename request(s) removed"   '
            ELSE                                                  '
               gFMD(i).Message = FORMAT$(premoved) + " empty path and " + FORMAT$(fremoved) + " empty/forgotten file request(s) removed"  '
            END IF                                                '
            DoSet(%Msg)                                           ' Get msg issued

         ELSEIF j = 0 THEN                                        ' FILELIST is empty, delete it
            FileRecycleBin(fn, "D")                               ' Delete empty files
            gFMD(i).Message = "No valid entries remain, the FLIST will be removed"  '
            DoSet(%Msg)                                           ' Get msg issued
         ELSE                                                     '
            gFMD(i).Message = "All FLIST entries validated, no changes were made"   '
            DoSet(%Msg)                                           ' Get msg issued
         END IF                                                   '
         DoSet(%LoadData)                                         ' Refresh the display

      CASE ELSE                                                   '
         gFMD(i).Message = "NORM cannot be used on this type of entry"  '
         DoSet(%Msg)                                              ' Get msg issued
   END SELECT                                                     '

   MExit                                                          '
END METHOD                                                        '

METHOD   FMLCmdOpenF(i AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- FM Open File line command                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lclCmd, lclOper AS STRING                                   '
   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by entry type
      CASE %FEntry, %FFLEntry, %FFileList                         ' Existing File?
         lclCmd = UUCASE(TRIM$(gFMD(i).Cmd))                      ' Get original command
         IF lclCmd = "O" OR lclCmd = "OPEN" THEN                  ' Setup type
            lclOper = "OPEN"                                      '
         ELSEIF lclCmd = "OB" OR lclCmd = "OPENB" THEN            '
            lclOper = "OPENB"                                     '
         ELSEIF lclCmd = "OV" OR lclCmd = "OPENV" THEN            '
            lclOper = "OPENV"                                     '
         END IF                                                   '
         me.DoOpen(i, lclOper)                                    ' Go do Open
         DoSet(%LoadData)                                         ' Ask for refresh
      CASE ELSE                                                   '
         MLErrExit(i, "Command not supported for this type of entry")   '
   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdPrint(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- FM Print line command                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL Fn AS STRING                                                '
   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Clear command char
   IF gFMD(i).Flag = %FEntry OR _                                 ' File Entry?
      gFMD(i).Flag = %FOpen OR _                                  '
      gFMD(i).Flag = %FFLEntry THEN                               '
      fn = gFMD(i).FullPath                                       ' Get filename
   ELSE                                                           '
      MLErrExit(i, "PRINT not supported for this type of entry")  '
   END IF                                                         '

   me.FMLCmdPrintit(fn, i)                                        ' Do the actual print
   gFMD(i).Message = "File printed"                               '
   DoSet(%Msg)                                                    ' Get msg issued
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdPrintIt(fn AS STRING, i AS LONG)                    '
'--------------------------------------------------------------------------------------------------+
'- Print a specified filename                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL lctr, FNum AS LONG, pLine AS STRING                         '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Open the Printer                                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE PrinterOpen("") THEN                                ' Get printer ready if not already
      IF i <> 0 THEN                                              ' Got table index?
         gFMD(i).Message = "OPEN of printer failed"               '
         DoSet(%Msg)                                              ' Get msg issued
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '
   PrinterPrint(%PRTReset, " ", " ", %False)                      ' Tell PrinterPrint to reset

   '-----------------------------------------------------------------------------------------------+
   '- Open the file and process it                                                                 |
   '-----------------------------------------------------------------------------------------------+
   FNum = FREEFILE                                                ' Get a file number
   Call3(TryOpenInput(fn, FNum), _                                ' Try the open
         gFMD(i).Message = "Print File: " + fn + " doesn't exist": DoSet(%Msg): MExitMeth, _ '
         gFMD(i).Message = "OPEN of Print File: " + fn + " failed": DoSet(%Msg): MExitMeth, _   '
         Nul)                                                     ' Continue
   DO WHILE ISFALSE EOF(FNum)                                     ' If not EOF
      LINE INPUT # FNum, PLine                                    ' Read a line
      INCR lctr                                                   ' Incr line count
      PrinterPrint(%PRTLine, PLine, $$TxtHi, %False)              ' Print each line in NONUM mode
      PrinterPrint(%PRTNewLine, " ", " ", %False)                 '
   LOOP                                                           '
   PrinterPrint(%PRTFlushClose, " ", " ", %False)                 ' Tell PrinterPrint to flush page
   CLOSE # FNum                                                   ' Fiddle flags for close
   Mexit                                                          '
END METHOD                                                        '

METHOD FMLCmdProcess() AS LONG                                    '
'--------------------------------------------------------------------------------------------------+
'- Process the FM Line commands                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL Deferred(), t, tt, ttt, tttt, SavMac, LogName AS STRING, i, DefCtr AS LONG '
DIM Deferred(1 TO gFMDCtr) AS STRING, CallAddr AS DWORD           '
   MEntry                                                         '
   MEditCmd = ""                                                  ' Start MEdit command as null
   gFMDeleteAll = %False                                          ' Clear Delete ALL
   gDiffFileA = "": gDiffFileB = ""                               ' Clear DIFF filenames

   LookAtLines:                                                   '
   '-----------------------------------------------------------------------------------------------+
   '- Look for Macros first                                                                        |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gFMDCtr                                           ' Lets see if any macros to do
      IF gFMD(i).CmdIX = 999 THEN                                 ' We have a macro
         IF LEFT$(gFMD(i).Cmd, 1) = "=" THEN ITERATE FOR          ' Ignore ==x > messages
         SavMac = gFMD(i).CmdRoot                                 ' Save Cmd field
         gFMMacMode = 1                                           ' Flag as a Line Mode Macro
         t = SavMac + " " + FORMAT$(i) + " " + gFMD(i).CmdOper    ' Build command line
         CmdLog("P", t, %True)                                    ' Cmd Log it starting
         me.pCmdMacro(t)                                          ' Go do it
         CmdLog("P", t, %False)                                   ' Cmd Log it ending
         gFMMacMode = 0                                           ' Reset
         gFMD(i).CmdIX = 0: gFMD(i).CmdRoot = ""                  '
         t = UCASE$(GetNextWord(TRIM$(gFMD(i).Cmd), %NoStrip))    ' Re-get 1st word
         IF SavMac = t THEN gFMD(i).Cmd = " "                     ' Clear command line if macro didn't alter it
         gFMD(i).CmdOff = 0                                       ' Reset offset
      END IF                                                      '
   NEXT i                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Now do normal FM Line commands                                                               |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gFMDCtr                                           ' Lets see if any lines were selected
      IF gFMD(i).CmdIX = 999 THEN ITERATE FOR                     ' Ignore line macros
      IF ISNOTNULL(TRIM$(gFMD(i).CmdRoot)) THEN                   ' We have a command
         IF LEFT$(gFMD(i).CmdRoot, 1) = "=" THEN ITERATE FOR      ' Ignore ==x > messages
         DoSet(%LoadData)                                         ' Request Data reload
         '-----------------------------------------------------------------------------------------+
         '- Handle the peculiar commands first                                                     |
         '-----------------------------------------------------------------------------------------+
         SELECT CASE AS CONST$ gFMLCmdTable(gFMD(i).CmdIX).lcTrue ' What command?
            CASE "CANCEL  "                                       ' Handle special cmds
               INCR DefCtr                                        '
               Deferred(DefCtr) = FORMAT$(gFMD(i).Uniq, "000") + " CANCEL " + FORMAT$(i, "000") '
            CASE "DELETE  "                                       '
               INCR DefCtr                                        '
               Deferred(DefCtr) = FORMAT$(gFMD(i).Uniq, "000") + " DELETE " + FORMAT$(i, "000") + " " + _   '
                                  IIF$(ISNOTNULL(gFMD(i).CmdOper), UCASE$(gFMD(i).CmdOper), "D")   '
            CASE "DFA     "                                       '
               IF gFMD(i).Flag = %FEntry OR _                     ' File Entry?
                  gFMD(i).Flag = %FOpen OR _                      '
                  gFMD(i).Flag = %FFLEntry THEN                   '
                  IF gDiffFileA = "" THEN                         ' Haven't got DF1 yet?
                     gDiffFileA = gFMD(i).FullPath                ' Save it
                  ELSE                                            '
                     MLErrExit(i, "DFA already used on another line")   '
                  END IF                                          '
               ELSE                                               '
                  MLErrExit(i, "DFA not supported for this type of entry") '
               END IF                                             '
            CASE "DFB     "                                       '
               IF gFMD(i).Flag = %FEntry OR _                     ' File Entry?
                  gFMD(i).Flag = %FOpen OR _                      '
                  gFMD(i).Flag = %FFLEntry THEN                   '
                  IF gDiffFileB = "" THEN                         ' Haven't got DF1 yet?
                     gDiffFileB = gFMD(i).FullPath                ' Save it
                  ELSE                                            '
                     MLErrExit(i, "DFB already used on another line")   '
                  END IF                                          '
               ELSE                                               '
                  MLErrExit(i, "DFB not supported for this type of entry") '
               END IF                                             '
            CASE "END     "                                       '
               INCR DefCtr                                        '
               Deferred(DefCtr) = FORMAT$(gFMD(i).Uniq, "000") + " END " + FORMAT$(i, "000") '
            '--------------------------------------------------------------------------------------+
            '- All other line commands just get routed to their own handler                        |
            '--------------------------------------------------------------------------------------+
            CASE ELSE                                             ' Handle the normal ones
               CallAddr = gFMLCmdTable(gFMD(i).CmdIX).lcIX        ' Get Routine address
               LogName = TRIM$(gFMLCmdTable(gFMD(i).CmdIX).lcCmd) ' Grab the command name
               CmdLog("L", LogName, %True)                        ' Do Start Log
               CALL DWORD CallAddr USING pFMCmdModel(i)           ' Call the routine
               CmdLog("L", LogName, %False)                       ' Do End Log
         END SELECT                                               '
      END IF                                                      '
   NEXT i                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Next, handle the commands deferred till the main loop ends                                   |
   '-----------------------------------------------------------------------------------------------+
   IF DefCtr > 0 THEN                                             ' Any deferred commands?
      ARRAY SORT Deferred(1) FOR DefCtr, DESCEND                  ' Reverse sort
      FOR i = 1 TO DefCtr                                         ' Do the deferred commands
         t    = GetNextWord(Deferred(i), %Strip)                  ' Get the 1st word (Uniq)
         tt   = GetNextWord(Deferred(i), %Strip)                  ' Get the 2nd word 'command'
         ttt  = GetNextWord(Deferred(i), %Strip)                  ' Get the 3rd word 'IX'
         tttt = GetNextWord(Deferred(i), %Strip)                  ' Get the 4rd word 'operand'
         IF tt = "END"    THEN                                    ' END?
            CmdLog("L", "END", %True)                             '
            me.FMLCmdEnd(VAL(ttt))                                '
            CmdLog("L", "END", %False)                            '
         END IF                                                   '
         IF tt = "CANCEL" THEN                                    ' CANCEL?
            CmdLog("L", "CANCEL", %True)                          '
            me.FMLCmdCancel(VAL(ttt))                             '
            CmdLog("L", "CANCEL", %False)                         '
         END IF                                                   '
         IF tt = "DELETE" THEN                                    ' DELETE
            CmdLog("L", "DELETE", %True)                          '
            me.FMLCmdDelete(VAL(ttt), tttt)                       '
            CmdLog("L", "DELETE", %False)                         '
         END IF                                                   '
      NEXT i                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Fire off MEdit if we build a command                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(MEditCmd) THEN                                    ' A pending MEDIT command
      me.CallTab("MEDIT", MEditCmd)                               ' Let MEDIT start it
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Start DIFF perhaps                                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(gDiffFileA) AND ISNOTNULL(gDiffFileB) THEN        ' Got two operands?
      pCommand = " ": SetCmd                                      ' Clear command line
      pCmdDIFF("DIFF " + $DQ + gDiffFileA + $DQ + " " + $DQ + gDiffFileB + $DQ)  ' Invoke DIFF
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdRename(i AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- FM Rename line command                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lclPath, lclDrive, RenDrive, RenPath, OldFn, RenFn, MSG, lclOldState, lclNewState AS STRING, j AS LONG   '
LOCAL RCA AS RCArea

   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Clear command char
   IF ISNOTNULL(gFMD(i).CmdOper) THEN RenFn = gFMD(i).CmdOper     ' New name provided?  Save it

   '-----------------------------------------------------------------------------------------------+
   '- Do Configs separately                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF gFMD(i).Flag = %FConfig THEN                                ' Do Configs here
      IF LEFT$(gFMD(i).FileName, 10) = "Profile:  " THEN          ' The Profile Type?
         IF TRIM$(MID$(gFMD(i).FileName, 11)) = "DEFAULT" THEN _  ' Prevent stupidity
            MLErrExit(i, "Can't Rename the DEFAULT entries")      ' GET MSG issued
         OldFn = TRIM$(MID$(gFMD(i).Filename, 11))                ' Setup OldFn
         IF ISNULL(RenFn) THEN RenFn = DoInputBox("Enter the new Name: ", "Rename", RTRIM$(OldFn)) '
         IF ISNULL(RenFn) OR RenFn = OldFn THEN MExitMeth         ' Bail out if none provided or they're the same
         gSQL.TableRename("P" + OldFn, "P" + RenFn)               ' Do the rename
         DoSet(%LoadData)                                         ' Ask for refresh
      ELSE                                                        '
         MLErrExit(i, "RENAME is not supported for this entry type") '
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   lclPath = CURDIR$                                              ' Get current path
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save it
   RenPath = RTRIM$(gFMD(i).DPath)                                ' Build Path
   RenPath = CLIP$(RIGHT, RenPath, 1)                             ' Remove trailing \

   '-----------------------------------------------------------------------------------------------+
   '- If $BACKUP, warn user then let it go                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF RIGHT$(RenPath, 8) = "\$BACKUP" THEN                        ' Are we in a $BACKUP folder?
      DoMessageBox("Performing file maintenance actions within a |K$BACKUP|B folder" + $CRLF + _   '
                   "could cause operational problems and is not recommended." + $CRLF + $CRLF + _  '
                   "Press |KOK|B to acknowledge.", _              '
                   %MB_USERICON OR %MB_OK, "FM RENAME in $BACKUP folder")  '
   END IF                                                         '

   IF MID$(RenPath, 2, 1) = ":" THEN                              ' Extract Drive if present
      RenDrive = LEFT$(RenPath, 2)                                ' and save it
      RenPath = MID$(RenPath, 3)                                  ' Now remove Drive portion
      RenPath = IIF$(ISNULL(RenPath), "\", RenPath)               ' If null, make it \
   END IF                                                         '
   OldFn = RTRIM$(gFMD(i).FileName)                               ' Get old file Name

   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by type

      CASE %FEntry, %FFLEntry, %FFileList, %FConfig               ' File
         IF (gFMD(i).FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY THEN _   '
            MLErrExit(i, "Can't Rename a Read-Only file")         '
         IF VAL(FileQueue("S", " ", gFMD(i).FullPath)) <> 0 THEN _   ' Open in some tab?
            MLErrExit(i, "File open elsewhere")                   '

         IF ISNULL(RenFn) THEN RenFn = DoInputBox("Enter the new FileName: ", "Rename", RTRIM$(OldFn))   '
         IF ISNULL(RenFn) OR RenFn = OldFn THEN MExitMeth         ' Bail out if none provided or they're the same

         '-----------------------------------------------------------------------------------------+
         '- Get STATE names if available                                                           |
         '-----------------------------------------------------------------------------------------+
         lclOldState = BUILD$(RenDrive, Renpath, "\", OldFN, ".STATE")  ' Build STATE file name
         REPLACE ANY ":\/" WITH "```" IN lclOldState              ' Make : / and \ into `
         lclOldState = gENV.HomeData + "STATE\" + lclOldState     ' Add our STATE folder
         IF ISFALSE ISFILE(lclOldState) THEN                      ' Does STATE even exist?
            lclOldState = ""                                      ' Kill it if no STATE file
         ELSE                                                     '
            lclNewState = BUILD$(RenDrive, Renpath, "\", RenFN, ".STATE")  ' Build new STATE file name
            REPLACE ANY ":\/" WITH "```" IN lclNewState           ' Make : / and \ into `
            lclNewState = gENV.HomeData + "STATE\" + lclNewState  ' Add our STATE folder
            IF ISFILE(lclNewState) THEN lclOldState = ""          ' Kill it all if new STATE already exists
         END IF                                                   '

         '-----------------------------------------------------------------------------------------+
         '- OK, Finally try the rename                                                             |
         '-----------------------------------------------------------------------------------------+
         ERRCLEAR                                                 ' Reset ERR
         IF RenDrive <> lclDrive THEN CHDRIVE RenDrive            '
         CHDIR RenPath                                            '
         NAME OldFn AS RenFn                                      ' Do the rename
         MacWarn = 0                                              ' Ensure MacOverlap issues a message
         me.MacOverlap(BUILD$(RenDrive, Renpath, "\", RenFN))     ' Warn if Macro/command overlap
         FileListRename(BUILD$(RenDrive, Renpath, "\", OldFN), BUILD$(RenDrive, Renpath, "\", RenFN)) ' Global rename
         IF lclOldState <> "" THEN                                ' Doing STATE rename?
            NAME lclOldState AS lclNewState                       ' Yes, do it
         END IF                                                   '
         DoBackup("!" + RenFn, %Edit, RCA)                        ' Backup the new file


      CASE %FDirDown                                              ' Downward Directory
         OldFn = TRIM$(OldFn)                                     ' Trim
         OldFn = CLIP$(RIGHT, OldFn, 1)                           ' Remove trailing \ character
         IF ISNULL(RenFn) THEN RenFn = DoInputBox("Enter the new Directory Name: ", "Rename Directory", TRIM$(OldFn))   '
         IF ISNULL(RenFn) OR IsEQ(RenFn, OldFn) THEN MExitMeth    ' Bail out if none provided

         ERRCLEAR                                                 ' Reset ERR
         IF RenDrive <> lclDrive THEN CHDRIVE RenDrive            '
         CHDIR RenPath                                            '
         NAME OldFn AS RenFn                                      ' Do the rename
         IF RenDrive <> lclDrive THEN CHDRIVE lclDrive            ' Switch drive if needed
         CHDIR lclPath                                            ' put back the original path

      CASE ELSE                                                   '
         MLErrExit(i, "RENAME is not supported for this entry type") '
   END SELECT                                                     '

   '-----------------------------------------------------------------------------------------------+
   '- See if an error msg to issue                                                                 |
   '-----------------------------------------------------------------------------------------------+
   MSG = ""                                                       '
   IF ERR = %ERR_FILENOTFOUND THEN                                '
      MSG = "File/Dir no longerfound??"                           '
   ELSEIF ERR = %ERR_FILEALREADYEXISTS THEN                       '
      MSG = "File/Dir already exists."                            '
   ELSEIF ERR = %ERR_PERMISSIONDENIED THEN                        '
      MSG = "File/Dir is Read Only."                              '
   ELSEIF ERR = %ERR_PATHFILEACCESSERROR THEN                     '
      MSG = "Path/File Access error."                             '
   ELSEIF ERR <> 0 THEN                                           '
      MSG = "UnKnown Error - Err: " + FORMAT$(ERR)                '
   END IF                                                         '
   IF ISNOTNULL(MSG) THEN                                         ' Any error?
      gFMD(i).Message = MSG                                       '
      DoSet(%Msg)                                                 ' Get msg issued
   END IF                                                         '
   DoSet(%LoadData)                                               ' Ask for refresh
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdRestore(i AS LONG)                                  '
'--------------------------------------------------------------------------------------------------+
'- FM Restore a Backup copy                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lclFileName, lclMode AS STRING, j AS LONG, RCA AS RCArea    '
   MEntry                                                         '
   IF gFMD(i).CmdRoot = "RESTORE" THEN                            ' Choose existing or new mode
      lclMode = "E"                                               ' Existing
   ELSEIF gFMD(i).CmdRoot = "RESTORET" THEN                       '
      lclMode = "T"                                               ' With Timestamp
   END IF                                                         '
   gFMD(i).Cmd = " "                                              ' Clear command char

   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by type

      CASE %FEntry, %FFLEntry                                     ' Normal File
         '-----------------------------------------------------------------------------------------+
         '- OK, Finally try the Restore                                                            |
         '-----------------------------------------------------------------------------------------+
         lclFileName = gFMD(i).FullPath                           ' Get the Filename
         j = INSTR(-1, lclFileName, "\")                          ' Find the last \
         IF MID$(lclFileName, j, 6) = "\CLIP." _                  ' Not the special guys
         OR MID$(lclFileName, j, 9) = "\SetEdit." _               '
         OR MID$(lclFileName, j, 9) = "\EFTEdit." THEN            '
            MLErrExit(i, "Restore is not supported for this entry type")   '
         END IF                                                   '
         DoRestore(lclMode + lclFileName, RCA)                    ' Go do the Restore
      CASE ELSE                                                   '
         MLErrExit(i, "Restore is not supported for this entry type")   '
   END SELECT                                                     '

   gFMD(i).Message = RCA.Msg                                      '
   DoSet(%Msg)                                                    ' Get msg issued
   DoSet(%LoadData)                                               ' Ask for refresh
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdSave(i AS LONG)                                     '
'--------------------------------------------------------------------------------------------------+
'- FM SAVE line command                                                                            |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   IF gFMD(i).Flag <> %FOpen THEN MLErrExit(i, "SAVE only usable against OPEN files")  ' An OPEN entry?
   DoCmdInOtherTab(gFMD(i).Uniq, "SAVE ")                         ' Try the command
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '



METHOD   FMLCmdSelect(i AS LONG)                                  '
'--------------------------------------------------------------------------------------------------+
'- FM Select line command                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL cmd, fn, t, SaveProf, p, OpenWith AS STRING, j AS LONG, RCA AS RCArea   '
LOCAL FN2 AS ASCIIZ * %MAX_PATH                                   '
   MEntry                                                         '

   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by type of entry

      CASE %FEntry, %FFLEntry                                     ' A file entry
         fn = gFMD(i).FullPath                                    ' Build the full Set the filename
         IF UUCASE(RIGHT$(RTRIM$(fn), 4)) = ".LNK" THEN           ' A LNK shortcut?
            Fn = GetRealNameFromLNK(fn)                           ' Get real Fn
         END IF                                                   '
         Call4(GetNonTextOption(Fn, OpenWith), _                  ' Get result for NON-TEXT
               FN2 = Fn: j = ShellExecute(0, "Open", FN2, $NUL, $NUL, %SW_SHOWNORMAL): GOTO SelDone, _   '
               t = OpenWith + " " + $DQ + fn + $DQ: j = SHELL(t, 1): GOTO SelDone, _   '
               FCB.Skip = %True: GOTO SelDone, _                  '
               gEFTOpenSource = "SELECT": me.DoEDIT(i): gEFTOpenSource = "")  ' Clear it

      CASE %FOpen                                                 ' OPEN file entry
         GoToTab(gFMD(i).Uniq, "", "")                            ' Set to cause a switch to this tab

      CASE %FPath                                                 ' Recent path entry
         FPath = gFMD(i).FileName                                 '
         FMask = "*"                                              '
         FileListNm = ""                                          ' Kill FileList name
         gSQL.UpdateString("O", "DefDir1", FPath)                 '
         gSQL.UpdateString("O", "DefMask", FMask)                 '
         gSQL.UpdateString("O", "FileListNm", FileListNm)         '
         DoSet(%LoadReq)                                          ' Full refresh
         me.WindowTitle                                           ' Alter Window Title

      CASE %FDirDown                                              ' Dir Down
         me.DoDirDown(i)                                          ' Go do it

      CASE %FDirUp                                                ' Dir Up
         me.DoDirUp(i)                                            ' Go do it

      CASE %FFileList                                             ' FILELIST
         FileListNm = CLIP$(RIGHT, gFMD(i).FileName, 6)           '
         gSQL.UpdateString("O", "FileListNm", FileListNm)         '
         me.WindowTitle                                           ' Alter Window Title

      CASE %FConfig                                               ' Config
         IF LEFT$(gFMD(i).FileName, 10) = "Profile:  " THEN       ' The Profile Type?
            SaveProf = IIF$(FCB.ProfName <> "", FCB.ProfName, "DEFAULT")   ' Save where we are
            p = TRIM$(MID$(gFMD(i).FileName, 11))                 ' Get Profile name
            FCB.SetupProf(p, RCA)                                 ' Setup
            FCB.EditProf                                          ' Let user Have a look
            FCB.SetupProf(SaveProf, RCA)                          '
            CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB              ' Set focus
         ELSE                                                     ' Must be an Instance type
            IF TRIM$(MID$(gFMD(i).FileName, 11)) <> gENV.eInstance THEN _  '
               MLErrExit(i, "SELECT only available for the active Instance")  '
            pCmdOptions("OPT")                                    ' Let Options have a go
            CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB              ' Set focus
         END IF                                                   '

      CASE ELSE                                                   '
         MLErrExit(i, "Select not supported for this entry type") ' An OPEN entry?

   END SELECT                                                     '
   SelDone:                                                       '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdSubmit(i AS LONG)                                   '
'--------------------------------------------------------------------------------------------------+
'- FM SUBMIT process                                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL fn AS STRING                                                '
   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by file entry type
      CASE %FEntry, %FFLEntry, %FOpen                             ' File Entry?
         fn = gFMD(i).FullPath                                    ' Get filename
      CASE ELSE                                                   '
         MLErrExit(i, "SUBMIT cannot be used on this entry type") '
   END SELECT                                                     '
   pCmdXSubmit("XSUBMIT " + $DQ + fn + $DQ)                       ' Run it
   DoSet(%Refresh)                                                '
   MExit                                                          ' We're done
END METHOD                                                        '

METHOD  FMLCmdTouch(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- FM Touch line command                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL RCA AS RCArea                                               '
   MEntry                                                         '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split off

      CASE %FEntry, %FFLEntry, %FFileList                         ' Existing file
         FileTouch(gFMD(i).FullPath, RCA)                         ' Go try and get response
         IF RCA.RC <> 0 THEN                                      ' If an error
            gFMD(i).Message = RCA.Msg                             ' Issue the message text
            DoSet(%Msg)                                           ' Get msg issued
         END IF                                                   ' If no error, do nothing

      CASE ELSE                                                   '
         gFMD(i).Message = "TOUCH cannot be used on this type of entry" '
         DoSet(%Msg)                                              ' Get msg issued
   END SELECT                                                     '

   DoSet(%LoadData)                                               ' Ask for refresh
   MExitMeth                                                      '
END METHOD                                                        '

METHOD FMLCmdParse(i AS LONG, RCA AS RCArea)                      '
'--------------------------------------------------------------------------------------------------+
'- Parse the FM Line command                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL lcmd1, lcmd2, w1, w2 AS STRING, j, x AS LONG                '
   lcmd1 = TRIM$(gFMD(i).Cmd): lcmd2 = lcmd1                      ' Get command on this line
   gFMD(i).CmdRoot = "": gFMD(i).CmdCount = 0: gFMD(i).CmdFlag = "": gFMD(i).CmdOper = "" ' Reset operands

   '-----------------------------------------------------------------------------------------------+
   '- 1st parse into two 'words'                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(TRIM$(lcmd1)) OR LEFT$(lcmd1, 1) = "=" THEN AnswerMeth(0, "OK")  ' Nothing, or =Msg> just return
   w1 = UCASE$(GetNextWord(lcmd1, %Strip)): w2 = lcmd1            ' w1 has primary operand

   '-----------------------------------------------------------------------------------------------+
   '- Handle the shortcut options                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(w1, 1) = "." THEN                                     ' A Profile request?
      IF ISFALSE IsProfile(MID$(w1, 2)) THEN                      ' It better exist
         AnswerMeth(8, "Invalid Profile name: " + lcmd2)          ' No, kill it
      END IF                                                      '
      w2 = w1 + " " + w2: w1 = "S"                                ' Else prefix with a Select
   ELSEIF LEFT$(w1, 1) = "%" THEN                                 ' A IMacro request?
      IF ISFALSE IsMacro(MID$(w1, 2)) THEN                        ' It better exist
         AnswerMeth(8, "Invalid IMacro name: " + lcmd2)           ' No, kill it
      END IF                                                      '
      w2 = w1 + " " + w2: w1 = "S"                                ' Else prefix with a Select
   ELSEIF LEFT$(w1, 1) = "/" THEN                                 ' An XFORM request?
      IF ISFALSE IsMacro(MID$(w1, 2)) THEN                        ' It better exist
         AnswerMeth(8, "Invalid XFORM Macro name: " + lcmd2)      ' No, kill it
      END IF                                                      '
      w2 = w1 + " " + w2: w1 = "S"                                ' Else prefix with a Select
   END IF                                                         '
   gFMD(i).CmdOper = w2                                           ' Save 2nd operand
   '--------------------------------------------------------------------------------------------+
   '- Remove / \ if present                                                                     |
   '--------------------------------------------------------------------------------------------+
   IF RIGHT$(w1, 1) = ","  THEN REPLACE ","  WITH "\" IN w1       ' Support ,  alias of \
   IF RIGHT$(w1, 2) = ".." THEN REPLACE ".." WITH "\" IN w1       ' Support .. alias of \
   IF RIGHT$(w1, 1) = "."  THEN REPLACE "."  WITH "/" IN w1       ' Support .  alias of /
   IF RIGHT$(w1, 1) = "\" OR RIGHT$(w1, 1) = "/" THEN             ' / or \ ?
      gFMD(i).CmdFlag = RIGHT$(w1, 1): w1 = CLIP$(RIGHT, w1, 1)   ' Remove it
   END IF                                                         '
   '--------------------------------------------------------------------------------------------+
   '- See if a numeric trailer value                                                            |
   '--------------------------------------------------------------------------------------------+
   x = INSTR(w1, ANY $Numeric)                                    ' Get loc of any trailing numeric
   IF x THEN gFMD(i).CmdCount = MAX(VAL(MID$(w1, x)), 1)          ' Save numeric value
   gFMD(i).CmdRoot = IIF$(x = 0, w1, LEFT$(w1, x - 1))            ' Strip off numeric if present

   '--------------------------------------------------------------------------------------------+
   '- Now validate the actual command                                                           |
   '--------------------------------------------------------------------------------------------+
   ARRAY SCAN gFMLCmdTable() FOR UBOUND(gFMLCmdTable()), FROM 1 TO 8, COLLATE UCASE, =LSET$(gFMD(i).CmdRoot, 8), TO j   ' Can we find the command?
   IF j = 0 THEN                                                  ' Nothing? Kill it
      IF ISFALSE IsMacro((gFMD(i).CmdRoot)) THEN                  ' Maybe a Line Macro
         AnswerMeth(8, "Unknown line command: " + lcmd2)          ' No, kill it
      END IF                                                      '
      j = 999                                                     ' Set 999 to indicate a macro
   END IF                                                         '
   gFMD(i).CmdIX = j                                              ' Save it
   IF j <> 999 THEN                                               ' If not a macro
      gFMD(i).CmdRoot = TRIM$(gFMLCmdTable(j).lcTrue)             ' Save truename
      IF gFMD(i).CmdCount > 1 AND gFMLCmdTable(j).lcNumV <> "Y" THEN '
         AnswerMeth(8, "Line command: " + gFMD(i).Cmd + " does not support Repeat value") ' Kill it
      END IF                                                      '
   ELSE                                                           '
                                                                  ' Leave Root = macroname                                    '
   END IF                                                         '
   AnswerMeth(0, "OK")                                            ' Return OK
END METHOD                                                        '

METHOD FMLCmdValidate() AS LONG                                   '
'--------------------------------------------------------------------------------------------------+
'- Validate the raw line command strings                                                           |
'--------------------------------------------------------------------------------------------------+
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
LOCAL MSG AS STRING, x, y AS LONG, RCA AS RCArea                  '
   MEntry                                                         '
   METHOD = %True                                                 ' Default to an error

   '-----------------------------------------------------------------------------------------------+
   '- Loop through the gFMD table, catch obvious errors                                            |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gFMDCtr                                           ' Loop through gFMD
      me.FMLCmdParse(i, RCA)                                      ' Parse the line command
      IF RCA.RC <> 0 THEN MLErrExit(i, TRIM$(RCA.Msg))            ' No, kill it
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now look for more complex errors                                                             |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO gFMDCtr                                           ' Loop through gFMD again
      IF ISNULL(gFMD(i).CmdRoot) THEN ITERATE FOR                 ' Looking only at real entries
      IF gFMD(i).CmdIX = 999     THEN ITERATE FOR                 ' And ignore Line Macros
      '--------------------------------------------------------------------------------------------+
      '- Validate block command                                                                    |
      '--------------------------------------------------------------------------------------------+
      IF gFMLCmdTable(gFMD(i).CmdIX).lcBlock = "Y" THEN           ' A doubled command
         IF ISNOTNULL(gFMD(i).CmdFlag) THEN _                     ' Catch bad usage
            MLErrExit(i, "Block commands cannot use \ / modifiers")  '
         FOR x = i + 1 TO gFMDCtr                                 ' See if the other part is here
            IF ISNULL(gFMD(x).CmdRoot) THEN ITERATE FOR           ' Ignore blank commands
            IF gFMD(x).CmdRoot <> gFMD(i).CmdRoot THEN _          ' Extraneous command?
               MLErrExit(i, "Extra command: " + gFMD(x).Cmd + " found within a block command")  '
            '--------------------------------------------------------------------------------------+
            '- We found end of block                                                               |
            '--------------------------------------------------------------------------------------+
            IF ISNOTNULL(gFMD(x).CmdFlag) THEN _                  ' Catch bad usage
               MLErrExit(i, "Block commands cannot use \ / modifiers")  '
            IF ISNOTNULL(gFMD(i).CmdOper) AND ISNOTNULL(gFMD(x).CmdOper) AND _   ' Different operands?
               gFMD(i).CmdOper <> gFMD(x).CmdOper THEN _          '
               MLErrExit(i, "Block commands have differing operands")   '
            IF ISNOTNULL(gFMD(i).CmdOper) AND ISNULL(gFMD(x).Cmdoper) THEN _  ' Propagate operand
               gFMD(x).CmdOper = gFMD(i).CmdOper                  '
            IF ISNULL(gFMD(i).CmdOper) AND ISNOTNULL(gFMD(x).Cmdoper) THEN _  '
               gFMD(i).CmdOper = gFMD(x).CmdOper                  '
            '--------------------------------------------------------------------------------------+
            '- Spread the block fields                                                             |
            '--------------------------------------------------------------------------------------+
            FOR y = i + 1 TO x                                    '
               gFMD(y).CmdRoot  = gFMD(i).CmdRoot                 '
               gFMD(y).CmdCount = 1                               '
               gFMD(y).CmdFlag  = ""                              '
               gFMD(y).CmdOper  = gFMD(i).CmdOper                 '
               gFMD(y).CmdIX    = gFMD(i).CmdIX                   '
            NEXT y                                                '
            i = y: EXIT IF                                        ' Continue after closing block cmd
         NEXT x                                                   '
         MLErrExit(i, "No matching line command for: " + gFMD(i).Cmd)   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Validate numeric range command                                                            |
      '--------------------------------------------------------------------------------------------+
      IF gFMD(i).CmdCount > 1 THEN                                ' A repeat value
         IF i + gFMD(i).CmdCount > gFMDCtr THEN                   ' > # of FM entries?
            gFMD(i).CmdCount = 0                                  ' Make into a / format
            gFMD(i).CmdFlag = "/"                                 '
            GOTO SeeSlash                                         ' Exit the numeric range logic
         END IF                                                   '
         FOR x = i + 1 TO MIN(i + gFMD(i).CmdCount - 1, gFMDCtr)  ' See if all blank within range
            IF ISNOTNULL(gFMD(x).CmdRoot) THEN _                  ' Something there?
               MLErrExit(i, "Command repeat overlaps next command: " + gFMD(x).Cmd) '
          NEXT x                                                  '
         FOR x = i + 1 TO MIN(i + gFMD(i).CmdCount - 1, gFMDCtr)  ' Spread the command
            gFMD(x).CmdRoot  = gFMD(i).CmdRoot                    '
            gFMD(x).CmdCount = 1                                  '
            gFMD(x).CmdFlag  = ""                                 '
            gFMD(x).CmdOper  = gFMD(i).CmdOper                    '
            gFMD(x).CmdIX    = gFMD(i).CmdIX                      '
         NEXT j                                                   '

      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- See if a / or \ operand                                                                   |
      '--------------------------------------------------------------------------------------------+
      SeeSlash:                                                   '
      IF gFMD(i).CmdFlag = "\" THEN                               ' Back \ ?
         FOR j = 1 TO i - 1                                       ' See if the rows are all blank
            IF ISNOTNULL(gFMD(j).CmdRoot) THEN MLErrExit(i, "Line commands from 1 to " + FORMAT$(i - 1) + " are not blank")   '
         NEXT j                                                   '
         FOR j = 1 TO i                                           ' Spread the command
            gFMD(j).CmdRoot  = gFMD(i).CmdRoot                    '
            gFMD(j).CmdCount = 1                                  '
            gFMD(j).CmdFlag  = ""                                 '
            gFMD(j).CmdOper  = gFMD(i).CmdOper                    '
            gFMD(j).CmdIX    = gFMD(i).CmdIX                      '
         NEXT j                                                   '
      END IF                                                      '
      IF gFMD(i).CmdFlag = "/" THEN                               ' Fwd / ?
         FOR j = i + 1 TO gFMDCtr - 1                             ' See if the rows are all blank
            IF ISNOTNULL(gFMD(j).CmdRoot) THEN MLErrExit(i, "Line commands from " + FORMAT$(i) + " to " + FORMAT$(gFMDCtr - 1) + " are not blank") '
         NEXT j                                                   '
         FOR j = i TO gFMDCtr - 1                                 ' Spread the command
            gFMD(j).CmdRoot  = gFMD(i).CmdRoot                    '
            gFMD(j).CmdCount = 1                                  '
            gFMD(j).CmdFlag  = ""                                 '
            gFMD(j).CmdOper  = gFMD(i).CmdOper                    '
            gFMD(j).CmdIX    = gFMD(i).CmdIX                      '
         NEXT j                                                   '
      END IF                                                      '

   NEXT i                                                         '
   METHOD = %False                                                '
   MExit                                                          '
END METHOD                                                        '

METHOD   FMLCmdView(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- FM View line command                                                                            |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by entry type
      CASE %FEntry, %FFLEntry, %FFileList                         ' Existing File?
         me.DoVIEW(i)                                             ' Go do View
         DoSet(%LoadData)                                         ' Ask for refresh
      CASE ELSE                                                   '
         MLErrExit(i, "VIEW not supported for this type of entry")   '

   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdWDir(i AS LONG)                                     '
'--------------------------------------------------------------------------------------------------+
'- Open a Windows Explorer to this file's DIR Folder                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL lclpath AS STRING, j AS LONG                                '
   MEntry                                                         '
   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by Entry type
      CASE %FEntry, %FFLEntry, %FOpen                             ' File type?
         lclPath = gFMD(i).FullPath                               ' Build the full Set the filename
         SHELL "EXPLORER.EXE /SELECT, " + $DQ + lclPath + $DQ, 1  '

      CASE %FDirDown                                              ' Dir Entry name
        lclPath = gFMD(i).DPath                                   ' Set the path
        SHELL "EXPLORER.EXE /ROOT," + $DQ + lclPath + $DQ, 1      '

      CASE %FPath                                                 ' Dir Entry name
         lclPath = gFMD(i).DPath                                  '
         SHELL "EXPLORER.EXE /ROOT," + $DQ + lclPath + $DQ, 1     '

      CASE %FDirUp                                                ' Dir Entry name
         lclPath = gFMD(i).DPath                                  '
         IF RIGHT$(lclPath, 1) = "\" THEN lclPath = CLIP$(RIGHT, lclPath, 1)  '
         j = INSTR(-1, lclPath, "\")                              ' Find last \
         IF j <> 0 THEN                                           ' Got one
            lclPath = LEFT$(lclPath, j - 1)                       ' Cut off the last level
         END IF                                                   ' Else do nothing
         SHELL "EXPLORER.EXE /ROOT, " + $DQ + lclPath + $DQ, 1    '

      CASE ELSE                                                   '
         MLErrExit(i, "WDIR is not supported for this entry type")   '
   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '

METHOD  FMLCmdWOpen(i AS LONG)                                    '
'--------------------------------------------------------------------------------------------------+
'- Open a File in it's native application                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lclcmd, lclpath AS ASCIIZ * %MAX_PATH, j AS LONG            '
LOCAL SavPath, SavDrive, XPath, XDrive, t AS STRING, SavTop AS LONG  '
   MEntry                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get any Cmd operand                                                                          |
   '-----------------------------------------------------------------------------------------------+
   lclcmd = gFMD(i).CmdOper                                       ' Save it

   SELECT CASE AS LONG gFMD(i).Flag                               ' Split by Entry type
      CASE %FEntry, %FFLEntry, %FOpen                             ' File type?
         lclPath = $DQ + gFMD(i).FullPath + $DQ                   ' Build the full path to the filename
         IF ISNULL(lclcmd) THEN                                   ' No Cmd operand
            j = ShellExecute(0, "Open", lclPath, $NUL, $NUL, %SW_SHOWNORMAL)  ' Just OPEN the filename
         ELSE                                                     '
            '--------------------------------------------------------------------------------------+
            '- Do a full SHELL invocation                                                          |
            '--------------------------------------------------------------------------------------+
            '-----------------------------------------------------------------------------------------+
            '- Switch to the EXE path                                                                 |
            '-----------------------------------------------------------------------------------------+
            SavTop = @P.PTopLine                                  ' Save TopScrn
            XPath = gFMD(i).FullPath                              ' Build the full filename
            IF MID$(XPath, 2, 1) = ":" THEN _                     ' Extract Drive if present
               XDrive = LEFT$(xPath, 1)                           ' and save it
            XPath = MID$(XPath, 3 TO INSTR(-1, XPath, "\"))       ' Strip to a path
            SavPath = CURDIR$                                     ' Save where we are
            IF MID$(SavPath, 2, 1) = ":" THEN _                   ' Extract Drive if present
               SavDrive = LEFT$(SavPath, 1)                       ' and save it
            SavPath = MID$(SavPath, 3 TO INSTR(-1, SavPath, "\")) ' Strip to a path
            CHDRIVE XDrive                                        ' Switch to RUN drive
            CHDIR XPath                                           ' Switch to RUN path

            '-----------------------------------------------------------------------------------------+
            '- Fire it up                                                                             |
            '-----------------------------------------------------------------------------------------+
            gLoopCtr = -1                                         ' Suspend loop checking
            t = ENVIRON$("COMSPEC") + " /C " + lclcmd + " " + $DQ + gFMD(i).FullPath + $DQ   '
            j = SHELL(t, 0)                                       '
            RESET gLoopCtr                                        ' Reset the counter

            '-----------------------------------------------------------------------------------------+
            '- Restore PATH                                                                           |
            '-----------------------------------------------------------------------------------------+
            IF ISNOTNULL(SavDrive) THEN CHDRIVE SavDrive          ' Switch drive if needed
            CHDIR SavPath                                         ' put back the original path
            @P.PTopLine = SavTop                                  ' Put back TopScrn
         END IF                                                   '

      CASE %FDirDown                                              ' Dir Entry name
         IF ISNOTNULL(lclcmd) THEN _                              ' Cmd is not allowed
            MLErrExit(i, "Command operand not allowed on DIR entry type")  '
         lclPath = gFMD(i).FullPath                               ' Set the path
         SHELL "EXPLORER.EXE /ROOT," + $DQ + lclPath + $DQ, 1     '

      CASE %FDirUp                                                ' Dir Entry name
         IF ISNOTNULL(lclcmd) THEN _                              ' Cmd is not allowed
            MLErrExit(i, "Command operand not allowed on DIR entry type")  '
         lclPath = TRIM$(gFMD(i).DPath)                           '
         IF RIGHT$(lclPath, 1) = "\" THEN lclPath = CLIP$(RIGHT, lclPath, 1)  '
         j = INSTR(-1, lclPath, "\")                              ' Find last \
         IF j <> 0 THEN                                           ' Got one
            lclPath = LEFT$(lclPath, j - 1)                       ' Cut off the last level
         END IF                                                   ' Else do nothing
         SHELL "EXPLORER.EXE /ROOT, " + $DQ + lclPath + $DQ, 1    '

      CASE ELSE                                                   '
         MLErrExit(i, "W is not supported for this entry type")   '
   END SELECT                                                     '
   gFMD(i).Cmd = " "                                              ' Blank the command area
   MExit                                                          '
END METHOD                                                        '
