'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- InitRoutines.inc                                                                                |
'--------------------------------------------------------------------------------------------------+
                                                                  '
FUNCTION InitFMLayout() AS LONG                                   '
'--------------------------------------------------------------------------------------------------+
'- Setup FM screen layout parameters                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, CPos, OBPos, CBPos, OpCtr, SubCtr AS LONG          '
LOCAL Layout, LH, RH AS STRING, RCA AS RCArea                     '
LOCAL opers(), subs() AS STRING                                   '
   DIM opers(1 TO 30) AS STRING                                   ' Dim the Opers table
'--------------------------------------------------------------------------------------------------+
'-     Valid FMLayout KWs are: NAME, SIZESHORT, SIZELONG, LWDATE, LWDATETIME, CRDATE               |
'-                             CRDATETIME, LRDATE, LRWDATETIME, PATH, LINES, ATTR, MODE, PRPn      |
'-   New  FilePath  Recent  Found  Open  Favorites  FLISTs  Paths  Configs  _AAA  _BBB  _CCC       |
'-  0         1         2         3         4         5         6         7         8         9    |
'-   123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890    |
'--------------------------------------------------------------------------------------------------+
   gFM_Quick_Line_1    = 3                                        ' Set top of screen area
   gFM_Path_Line       = 4                                        '
   gFM_Path_Left       = 18                                       '
   gFM_Mask_Line       = 5                                        '
   gFM_Mask_Left       = 18                                       '
   gFM_Head_Line       = 6                                        '
   gFM_Top_File_Line   = 7                                        '
   gFM_Quick_Pos_1     = 1                                        '
   gFM_Quick_Pos_2     = 6                                        '
   gFM_Quick_Pos_3     = 16                                       '
   gFM_Quick_Pos_4     = 24                                       '
   gFM_Quick_Pos_5     = 31                                       '
   gFM_Quick_Pos_6     = 37                                       '
   gFM_Quick_Pos_7     = 48                                       '
   gFM_Quick_Pos_8     = 56                                       '
   gFM_Quick_Pos_9     = 63                                       '
   gFM_Quick_Pos_10    = 72                                       '
   gFM_Head_Name_Left  = gENV.FMLCmdWidth + 2                     '
   gFM_Crit_Size = gENV.ScrWidth - gFM_Path_Left                  ' Calc available criteria size
   Layout = REMOVE$(gFMLayout, " ")                               ' Get copy without spaces
   ValidateLayout(Layout, RCA)                                    ' Validate the string
   IF RCA.RC <> 0 THEN                                            ' If not OK
      DoMessageBox "The FM Layout string is invalid: " + $CRLF + _   '
                   "|K" + gFMLayout + "|B" + $CRLF + _            '
                   "Error: |K" + TRIM$(RCA.Msg) + "|B, the Layout will be ignored", %MB_OK OR %MB_USERICON, "SPFLite"   '
      gFMLayout = "NAME(40),LWDATETIME,SIZESHORT"                 ' Set back to default
      gENV.FMLayout = gFMLayout                                   ' Save it
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Parse out the Layout string                                                                  |
   '-----------------------------------------------------------------------------------------------+
   DO WHILE LEN(Layout)                                           ' While still data in string
      cPos  = INSTR(1, Layout, ",")                               ' Find first comma
      OBPos = INSTR(1, Layout, "(")                               ' Find first open bracket
      CBPos = INSTR(1, Layout, ")")                               ' Find first closing )
      IF CPos = 0 THEN CPos = LEN(Layout) + 1                     ' To handle last operand

      '--------------------------------------------------------------------------------------------+
      '- A simple keyword, style                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF OBPos = 0 OR cPos < OBPos THEN                           '
         INCR OpCtr                                               ' Bump operand Index
         opers(OpCtr) = LEFT$(Layout, cPos - 1)                   ' Copy the operand
         Layout = MID$(Layout, CPos + 1)                          ' Remove from front of Layout
         ITERATE DO                                               ' Loop-de-loop
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- A keyword( style                                                                          |
      '--------------------------------------------------------------------------------------------+
      INCR OpCtr                                                  ' Bump operand Index
      opers(OpCtr) = LEFT$(Layout, CBPos)                         ' Copy the operand
      Layout = MID$(Layout, CBPos + 1)                            ' Remove from front of Layout
      IF LEFT$(Layout, 1) = "," THEN Layout = MID$(Layout, 2)     ' Also get rid of the comma if present

   LOOP                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- Allocate the Filename column 1st                                                             |
   '-----------------------------------------------------------------------------------------------+
   gFMCCtr = 0                                                    ' Start gFMC table
   gFMPropAct = %False                                            ' Say no active Property columns

   '-----------------------------------------------------------------------------------------------+
   '- Process each Layout operand                                                                  |
   '-----------------------------------------------------------------------------------------------+
   FOR j = 1 TO OpCtr                                             ' Loop through them
      k = INSTR(opers(j), "(")                                    ' Does it have sub-operands?
      IF k THEN                                                   ' Yes
         LH = UCASE$(LEFT$(opers(j), k - 1))                      ' Separate LH and RH
         RH = MID$(opers(j), k + 1 TO LEN(opers(j)) - 1)          '
         SubCtr = PARSECOUNT(RH, ",")                             ' Get number of sub-operands
         REDIM subs(1 TO SubCtr) AS STRING                        ' Dim the Sub-Operand table
         PARSE RH, subs(), ","                                    ' Break them out
      ELSE                                                        ' No sub-ops
         LH = UCASE$(opers(j))                                    ' Just LH
         RH = "": SubCtr = 0                                      ' No RH or Sub-ops
      END IF                                                      '

'--------------------------------------------------------------------------------------------------+
'- FM Display field lengths                                                                        |
'--------------------------------------------------------------------------------------------------+

      '--------------------------------------------------------------------------------------------+
      '- Operands and Sub-operands all parsed out                                                  |
      '--------------------------------------------------------------------------------------------+
      SELECT CASE AS CONST$ LH                                    ' See what field
         CASE "NAME"                                              ' NAME
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "Name"                          ' Default Header
            IF LEFT$(TP.DefSort, 4) = "Name" THEN                 ' Sorted on Name
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead     = TP.DefSort               ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize  = IIF(SubCtr, VAL(subs(1)), 40)  ' Setup Object size
            gFMC(gFMCCtr).CField = "NAME"                         ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "PATH"                                              ' PATH
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "Path"                          ' Default Header
            IF LEFT$(TP.DefSort, 4) = "Path" THEN                 ' Sorted on Path
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead     = TP.DefSort               ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 40)  ' Setup PATH size
            gFMC(gFMCCtr).CField    = "PATH"                      ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "SIZESHORT"                                         ' SIZESHORT
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "Size"                          ' Default Header
            IF LEFT$(TP.DefSort, 4) = "Size" THEN                 ' Sorted on Size
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 6)   ' Setup SIZESHORT size
            gFMC(gFMCCtr).CField    = "SIZESHORT"                 ' Field name
            gFMC(gFMCCtr).CAlign    = "R"                         ' Right align
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "SIZELONG"                                          ' SIZELONG
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "Size"                          ' Default Header
            IF LEFT$(TP.DefSort, 4) = "Size" THEN                 ' Sorted on Size
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 14)  ' Setup SIZELONG size
            gFMC(gFMCCtr).CField    = "SIZELONG"                  ' Field name
            gFMC(gFMCCtr).CAlign    = "R"                         ' Right align
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "LWDATE"                                            ' LWDATE
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "LWDate"                        ' Default Header
            IF LEFT$(TP.DefSort, 6) = "LWDate" THEN               ' Sorted on LWDate
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 10)  ' Setup DATE size
            gFMC(gFMCCtr).CField    = "LWDATE"                    ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "LRDATE"                                            ' LRDATE
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "LRDate"                        ' Default Header
            IF LEFT$(TP.DefSort, 6) = "LRDate" THEN               ' Sorted on LRDate
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 10)  ' Setup DATE size
            gFMC(gFMCCtr).CField    = "LRDATE"                    ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "LWDATETIME"                                        ' LWDATETIME
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "LWDate"                        ' Default Header
            IF LEFT$(TP.DefSort, 6) = "LWDate" THEN               ' Sorted on Date
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 17)  ' Setup DATETIME size
            gFMC(gFMCCtr).CField    = "LWDATETIME"                ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "LRDATETIME"                                        ' LRDATETIME
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "LRDate"                        ' Default Header
            IF LEFT$(TP.DefSort, 6) = "LRDate" THEN               ' Sorted on LRDate
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 17)  ' Setup DATETIME size
            gFMC(gFMCCtr).CField    = "LRDATETIME"                ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "CRDATE"                                            ' CRDATE
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "CRDate"                        ' Default Header
            IF LEFT$(TP.DefSort, 6) = "CRDate" THEN               ' Sorted on Date
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 10)  ' Setup DATE size
            gFMC(gFMCCtr).CField    = "CRDATE"                    ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "CRDATETIME"                                        ' CRDATETIME
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "CRDate"                        ' Default Header
            IF LEFT$(TP.DefSort, 6) = "CRDate" THEN               ' Sorted on Date
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 17)  ' Setup DATETIME size
            gFMC(gFMCCtr).CField    = "CRDATETIME"                ' Field name
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "LINES"                                             ' LINES
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "Lines"                         ' Default Header
            IF LEFT$(TP.DefSort, 5) = "Lines" THEN                ' Sorted on Lines
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 11)  ' Setup LINES size
            gFMC(gFMCCtr).CField    = "LINES"                     ' Field name
            gFMC(gFMCCtr).CAlign    = "R"                         ' Right align
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "ATTR"                                              ' ATTR
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "Attr"                          ' Default Header
            IF LEFT$(TP.DefSort, 4) = "Attr" THEN                 ' Sorted on Attr
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 5)   ' Setup LINES size
            gFMC(gFMCCtr).CField    = "ATTR"                      ' Field name
            gFMC(gFMCCtr).CAlign    = "L"                         ' Left align
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE "MODE"                                              ' MODE
            INCR gFMCCtr                                          ' Bump column count
            GOSUB DoBasic                                         ' Allocate and fill in common stuff
            gFMC(gFMCCtr).CHead = "Mode"                          ' Default Header
            IF LEFT$(TP.DefSort, 4) = "Mode" THEN                 ' Sorted on Mode
               TP.DefSortCol = gFMCCtr                            ' Set DefSortCol
               gFMC(gFMCCtr).CHead  = TP.DefSort                  ' Fill in the column header
            END IF                                                '
            gFMC(gFMCCtr).CSize     = IIF(SubCtr, VAL(subs(1)), 8)   ' Setup Mode size
            gFMC(gFMCCtr).CField    = "MODE"                      ' Field name
            gFMC(gFMCCtr).CAlign    = "L"                         ' Left align
            IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

         CASE ELSE                                                ' Only PRP type possible now
            gFMPropAct = %True                                    ' Remember we have Property columns
            SELECT CASE AS CONST$ LH                              '
               CASE "PRP1"                                        '
                  INCR gFMCCtr                                    ' Bump column count
                  GOSUB DoBasic                                   ' Allocate and fill in common stuff
                  gFMC(gFMCCtr).CHead = subs(3)                   ' Set Header
                  gFMC(gFMCCtr).CProperty = subs(3)               ' Set Property Name
                  IF LEFT$(TP.DefSort, 4) = "PRP1" THEN           ' Sorted on Prp1
                     TP.DefSortCol = gFMCCtr                      ' Set DefSortCol
                     gFMC(gFMCCtr).CHead = gFMC(gFMCCtr).CHead + RIGHT$(TP.DefSort, 1) ' Fill it the column header
                  END IF                                          '
                  gFMC(gFMCCtr).CSize     = VAL(subs(1))          ' Setup PRP size
                  gFMC(gFMCCtr).CField    = "PRP1"                ' Field name
                  gFMC(gFMCCtr).CAlign    = UCASE$(subs(2))       ' Set alignment
                  IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

               CASE "PRP2"                                        '
                  INCR gFMCCtr                                    ' Bump column count
                  GOSUB DoBasic                                   ' Allocate and fill in common stuff
                  gFMC(gFMCCtr).CHead = subs(3)                   ' Set Header
                  gFMC(gFMCCtr).CProperty = subs(3)               ' Set Property Name
                  IF LEFT$(TP.DefSort, 4) = "PRP2" THEN           ' Sorted on Prp2
                     TP.DefSortCol = gFMCCtr                      ' Set DefSortCol
                     gFMC(gFMCCtr).CHead = gFMC(gFMCCtr).CHead + RIGHT$(TP.DefSort, 1) ' Fill it the column header
                  END IF                                          '
                  gFMC(gFMCCtr).CSize     = VAL(subs(1))          ' Setup PRP size
                  gFMC(gFMCCtr).CField    = "PRP2"                ' Field name
                  gFMC(gFMCCtr).CAlign    = UCASE$(subs(2))       ' Set alignment
                  IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

               CASE "PRP3"                                        '
                  INCR gFMCCtr                                    ' Bump column count
                  GOSUB DoBasic                                   ' Allocate and fill in common stuff
                  gFMC(gFMCCtr).CHead = subs(3)                   ' Set Header
                  gFMC(gFMCCtr).CProperty = subs(3)               ' Set Property Name
                  IF LEFT$(TP.DefSort, 4) = "PRP3" THEN           ' Sorted on Prp3
                     TP.DefSortCol = gFMCCtr                      ' Set DefSortCol
                     gFMC(gFMCCtr).CHead = gFMC(gFMCCtr).CHead + RIGHT$(TP.DefSort, 1) ' Fill it the column header
                  END IF                                          '
                  gFMC(gFMCCtr).CSize     = VAL(subs(1))          ' Setup PRP size
                  gFMC(gFMCCtr).CField    = "PRP3"                ' Field name
                  gFMC(gFMCCtr).CAlign    = UCASE$(subs(2))       ' Set alignment
                  IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

               CASE "PRP4"                                        '
                  INCR gFMCCtr                                    ' Bump column count
                  GOSUB DoBasic                                   ' Allocate and fill in common stuff
                  gFMC(gFMCCtr).CHead = subs(3)                   ' Set Header
                  gFMC(gFMCCtr).CProperty = subs(3)               ' Set Property Name
                  IF LEFT$(TP.DefSort, 4) = "PRP4" THEN           ' Sorted on Prp4
                     TP.DefSortCol = gFMCCtr                      ' Set DefSortCol
                     gFMC(gFMCCtr).CHead = gFMC(gFMCCtr).CHead + RIGHT$(TP.DefSort, 1) ' Fill it the column header
                  END IF                                          '
                  gFMC(gFMCCtr).CSize     = VAL(subs(1))          ' Setup PRP size
                  gFMC(gFMCCtr).CField    = "PRP4"                ' Field name
                  gFMC(gFMCCtr).CAlign    = UCASE$(subs(2))       ' Set alignment
                  IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

               CASE "PRP5"                                        '
                  INCR gFMCCtr                                    ' Bump column count
                  GOSUB DoBasic                                   ' Allocate and fill in common stuff
                  gFMC(gFMCCtr).CHead = subs(3)                   ' Set Header
                  gFMC(gFMCCtr).CProperty = subs(3)               ' Set Property Name
                  IF LEFT$(TP.DefSort, 4) = "PRP5" THEN           ' Sorted on Prp5
                     TP.DefSortCol = gFMCCtr                      ' Set DefSortCol
                     gFMC(gFMCCtr).CHead = gFMC(gFMCCtr).CHead + RIGHT$(TP.DefSort, 1) ' Fill it the column header
                  END IF                                          '
                  gFMC(gFMCCtr).CSize     = VAL(subs(1))          ' Setup PRP size
                  gFMC(gFMCCtr).CField    = "PRP5"                ' Field name
                  gFMC(gFMCCtr).CAlign    = UCASE$(subs(2))       ' Set alignment
                  IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

               CASE "PRP6"                                        '
                  INCR gFMCCtr                                    ' Bump column count
                  GOSUB DoBasic                                   ' Allocate and fill in common stuff
                  gFMC(gFMCCtr).CHead = subs(3)                   ' Set Header
                  gFMC(gFMCCtr).CProperty = subs(3)               ' Set Property Name
                  IF LEFT$(TP.DefSort, 4) = "PRP6" THEN           ' Sorted on Prp6
                     TP.DefSortCol = gFMCCtr                      ' Set DefSortCol
                     gFMC(gFMCCtr).CHead = gFMC(gFMCCtr).CHead + RIGHT$(TP.DefSort, 1) ' Fill it the column header
                  END IF                                          '
                  gFMC(gFMCCtr).CSize     = VAL(subs(1))          ' Setup PRP size
                  gFMC(gFMCCtr).CField    = "PRP6"                ' Field name
                  gFMC(gFMCCtr).CAlign    = UCASE$(subs(2))       ' Set alignment
                  IF gFMCCtr = 1 THEN gFMC(1).CPos = gFM_Head_Name_Left ' If 1st column, set Starting position

            END SELECT                                            '
      END SELECT                                                  '

   NEXT j                                                         '

   FOR i = 1 TO 20                                                ' Reset active columns
      TP.SetDefActCol(i, 0)                                       '
   NEXT i                                                         '
   k = 1                                                          ' Set Active Index
   TP.SetDefActCol(k, 1)                                          ' Set 1st active
   j = gFMC(1).CPos + gFMC(1).CSize + 2                           ' Point after 1st column

   FOR i = TP.DefFirstCol TO gFMCCtr                              ' Set print positions for other columns
      IF j + gFMC(i).CSize <= gENV.ScrWidth THEN                  ' If this column will still fit on the screen
          gFMC(i).CPos = j                                        ' Set it's horizontal position
         INCR k: TP.SetDefActCol(k, i)                            ' Add this column to active list
         IF j + gFMC(i).CSize + 2 <= gENV.ScrWidth THEN j += 2    ' If enough room, add pad columns
         j += gFMC(i).CSize                                       ' Calc next column position
      END IF                                                      '
   NEXT i                                                         '

   gFM_List_Height = gENV.ScrHeight - gFM_Top_File_Line - (3 * gENV.FMHelpFlag) + 1 ' Calc size of scrolling area
   EXIT FUNCTION                                                  '

   DoBasic:                                                       '
      IF ISFALSE ISOBJECT(gFMC(gFMCCtr)) THEN LET gFMC(gFMCCtr) = CLASS "cFMColumn" ' Allocate an Object
      gFMC(gFMCCtr).CPos      = gFMCCtr                           '
      gFMC(gFMCCtr).CAlign    = "L"                               '
      gFMC(gFMCCtr).CProperty = ""                                '
      gFMC(gFMCCtr).CGUID     = ""                                '
      RETURN                                                      '
END FUNCTION                                                      '

SUB InitHelp()                                                    '
'--------------------------------------------------------------------------------------------------+
'- Get the Help tables loaded                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL hHelpThread, i AS LONG                                      '
   THREAD CREATE InitHelp2(i) 65536, TO hHelpThread               '
   SLEEP 200                                                      ' Wait a bit
   THREAD STATUS hHelpThread TO i                                 ' See if running OK
   THREAD CLOSE hHelpThread TO i                                  ' Free up our handle
END SUB                                                           '

THREAD FUNCTION InitHelp2(BYVAL p AS LONG) AS LONG                '
'--------------------------------------------------------------------------------------------------+
'- Add the HELP operand keywords                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL t, numlist, kwd, FName AS STRING, k, l, a, Fn AS LONG       '
DIM opers(1 TO 5) AS STRING                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Get our Help Index Table                                                                     |
   '-----------------------------------------------------------------------------------------------+
   Fn = FREEFILE                                                  ' Get a file number
   FName =gENV.EXEPath + "HnDIndex.txt"                           ' Build the file name
   TRY                                                            ' Lets try the OPEN
      OPEN Fname FOR INPUT ACCESS READ LOCK SHARED AS # Fn        '
   CATCH                                                          ' An error occurred
      MyMsgBox("Unable to OPEN: |K" + FName + "|B, HELP command will be unavailable", %MB_OK OR %MB_USERICON OR %MB_TASKMODAL OR %MB_DEFBUTTON1, "SPFLite Missing File")   '
      gHlpKilled = %True                                          ' Kill the help command
      EXIT FUNCTION                                               '
   END TRY                                                        '
   DO WHILE ISFALSE EOF (#Fn)                                     ' Read the file
      LINE INPUT # Fn, t                                          '

      '--------------------------------------------------------------------------------------------+
      '- Topic Title                                                                               |
      '--------------------------------------------------------------------------------------------+
      IF LEFT$(t, 1) = "T" THEN                                   ' Topic header?
         a = VAL(MID$(t, 2 TO 4))                                 ' Get Topic ID #
         gHlpT(a).Cat = MID$(t, 5, 1)                             ' Save Topic Category
         gHlpT(a).Found = REPEAT$(8, "0")                         ' Clear found flags
         gHlpT(a).Title = MID$(t, 6)                              ' Save Topic Title
         ITERATE DO                                               '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Topic Keywords                                                                            |
      '--------------------------------------------------------------------------------------------+
      IF LEFT$(t, 1) = "K" THEN                                   ' Kwd from TopicID?
         IF INSTR(t, "LBRK") THEN REPLACE "LBRK" WITH "(,))" IN t ' Do fudge for HnD not handling ()[]<> in TopicIDs
         IF INSTR(t, "RBRK") THEN REPLACE "RBRK" WITH "),))" IN t '
         IF INSTR(t, "LARR") THEN REPLACE "LARR" WITH "<,<<" IN t '
         IF INSTR(t, "RARR") THEN REPLACE "RARR" WITH ">,>>" IN t '
         IF INSTR(t, "LIND") THEN REPLACE "LIND" WITH "[,[[" IN t '
         IF INSTR(t, "RIND") THEN REPLACE "RIND" WITH "],]]" IN t '
         k = PARSECOUNT(MID$(t, 5), ",")                          ' How many Kwds?
         REDIM opers(1 TO k) AS STRING                            '
         PARSE MID$(t, 5), opers(), ","                           '
         FOR l = 1 TO k                                           '
            INCR gHlpKCtr                                         ' Add it to the table
            IF gHlpKCtr > UBOUND(gHlpK()) THEN _                  ' Keep table big enough
               REDIM PRESERVE gHlpK(1 TO 2 * gHlpKCtr) AS GLOBAL hEnt   '
            gHlpK(gHlpKCtr).Num = VAL(MID$(t, 2 TO 4))            ' Save Topic #
            gHlpK(gHlpKCtr).Kwd = opers(l)                        ' Save Topic Kwd
            gHlpK(gHlpKCtr).Hits = 50                             ' Boost Hits count
         NEXT l                                                   '
         ITERATE DO                                               '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Topic Words from Title or Full Search                                                     |
      '--------------------------------------------------------------------------------------------+
      IF LEFT$(t, 1) = "W" OR LEFT$(t, 1) = "U" THEN              ' Words from Title / Full Search
         l = INSTR(t, "\")                                        ' Locate the break
         kwd = MID$(t, 2 TO l - 1)                                ' Peel off the kwd
         numlist = MID$(t, l + 1)                                 ' Get the list of topic numbers
         FOR l = 1 TO LEN(numlist) STEP 6                         ' Walk through, 6 chars at a time
            INCR gHlpWCtr                                         ' Add it to the table
            IF gHlpWCtr > UBOUND(gHlpW()) THEN _                  ' Keep table big enough
               REDIM PRESERVE gHlpW(1 TO 2 * gHlpWCtr) AS GLOBAL hEnt   '
            gHlpW(gHlpWCtr).Num = VAL(MID$(numlist, l, 3))        ' Save Topic #
            gHlpW(gHlpWCtr).Kwd = kwd                             ' Save Topic Kwd
            gHlpW(gHlpWCtr).Hits = VAL(MID$(numlist, l + 3, 3))   ' Save Hit count
            IF LEFT$(t, 1) = "U" THEN gHlpW(gHlpWCtr).Hits = gHlpW(gHlpWCtr).Hits + 50 '
         NEXT l                                                   '
         ITERATE DO                                               '
      END IF                                                      '

   LOOP                                                           ' Loop throough the file
   CLOSE #Fn                                                      ' Close it when done
END FUNCTION                                                      '

SUB      InitLNText                                               '
'--------------------------------------------------------------------------------------------------+
'- Init the Line Number text constants                                                             |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   gLNPadCol = gENV.LinNoSize + 1                                 ' Pad column number
   gLNData1  = gENV.LinNoSize + 2                                 ' Data column 1 location
   ARRAY ASSIGN gLnoTextType() = %Top, %Bottom, %Tabs, %Bounds, %Cols, %Xclude, %InsertLine, %EQChange, %Word, %Mark, %Mask, %Prof, %File, %Note, %Page, %EFT, %PanelUpper, %PanelLower   '
   gLnoTextTxt(1) = REPEAT$(8, "*")                               ' Setup constants
   gLnoTextTxt(2) = REPEAT$(8, "*")                               '
   gLnoTextTxt(6) = REPEAT$(8, "-")                               '
   gLnoTextTxt(7) = REPEAT$(8, "'")                               '
   IF gENV.LinNoSize = 5 THEN                                     ' Set constants differently
      gLnoTextTxt(3)  = "TABS>   "                                '
      gLnoTextTxt(4)  = "BNDS>   "                                '
      gLnoTextTxt(5)  = "COLS>   "                                '
      gLnoTextTxt(8)  = "=CHG>   "                                '
      gLnoTextTxt(9)  = "WORD>   "                                '
      gLnoTextTxt(10) = "MARK>   "                                '
      gLnoTextTxt(11) = "MASK>   "                                '
      gLnoTextTxt(12) = "PROF>   "                                '
      gLnoTextTxt(13) = "FILE>   "                                '
      gLnoTextTxt(14) = "=##=>   "                                '
      gLnoTextTxt(15) = "PAGE>   "                                '
      gLnoTextTxt(16) = "=EFT>   "                                '
   ELSEIF gENV.LinNoSize = 6 THEN                                 '
      gLnoTextTxt(3)  = "=TABS>  "                                '
      gLnoTextTxt(4)  = "=BNDS>  "                                '
      gLnoTextTxt(5)  = "=COLS>  "                                '
      gLnoTextTxt(8)  = "==CHG>  "                                '
      gLnoTextTxt(9)  = "=WORD>  "                                '
      gLnoTextTxt(10) = "=MARK>  "                                '
      gLnoTextTxt(11) = "=MASK>  "                                '
      gLnoTextTxt(12) = "=PROF>  "                                '
      gLnoTextTxt(13) = "=FILE>  "                                '
      gLnoTextTxt(14) = "=NOTE>  "                                '
      gLnoTextTxt(15) = "=PAGE>  "                                '
      gLnoTextTxt(16) = "==EFT>  "                                '
   ELSEIF gENV.LinNoSize = 7 THEN                                 '
      gLnoTextTxt(3)  = "==TABS> "                                '
      gLnoTextTxt(4)  = "==BNDS> "                                '
      gLnoTextTxt(5)  = "==COLS> "                                '
      gLnoTextTxt(8)  = "===CHG> "                                '
      gLnoTextTxt(9)  = "==WORD> "                                '
      gLnoTextTxt(10) = "==MARK> "                                '
      gLnoTextTxt(11) = "==MASK> "                                '
      gLnoTextTxt(12) = "==PROF> "                                '
      gLnoTextTxt(13) = "==FILE> "                                '
      gLnoTextTxt(14) = "==NOTE> "                                '
      gLnoTextTxt(15) = "==PAGE> "                                '
      gLnoTextTxt(16) = "===EFT> "                                '
   ELSEIF gENV.LinNoSize = 8 THEN                                 '
      gLnoTextTxt(3)  = "===TABS>"                                '
      gLnoTextTxt(4)  = "===BNDS>"                                '
      gLnoTextTxt(5)  = "===COLS>"                                '
      gLnoTextTxt(8)  = "====CHG>"                                '
      gLnoTextTxt(9)  = "===WORD>"                                '
      gLnoTextTxt(10) = "===MARK>"                                '
      gLnoTextTxt(11) = "===MASK>"                                '
      gLnoTextTxt(12) = "===PROF>"                                '
      gLnoTextTxt(13) = "===FILE>"                                '
      gLnoTextTxt(14) = "===NOTE>"                                '
      gLnoTextTxt(15) = "===PAGE>"                                '
      gLnoTextTxt(16) = "====EFT>"                                '
   END IF                                                         '
   MExit                                                          '
END SUB                                                           '

SUB      InitLocalTables()                                        '
'--------------------------------------------------------------------------------------------------+
'- Setup some misc. tables                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, x, y AS LONG                                       '
LOCAL t, u, v, lin AS STRING                                      '
LOCAL SetArray() AS STRING                                        '
LOCAL LTime AS IPOWERTIME                                         ' Create a PowerTime object
   MEntry                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Load the FM File Properties                                                                  |
   '-----------------------------------------------------------------------------------------------+
   ARRAY ASSIGN gFMProp() = "Artist", "Album", "BRate", "BDepth", "Contrib", "CamMaker", "CamModel", "DateTaken", _  '
                            "Dimension", "Duration", "Exp", "Flash", "FStop", "Genre", "HRes", "ISO", _  '
                            "Publisher", "Rating", "SubTitle", "Title", "Trk", "VRes", "Year"   '
   gFMPropNum = 22                                                ' Set the count

   DIM SetArray(0) AS LOCAL STRING                                '

   '-----------------------------------------------------------------------------------------------+
   '- Set up some other stuff                                                                      |
   '-----------------------------------------------------------------------------------------------+
   gEnumWith = 1                                                  ' Global ENUM increment
                                                                  '
   '-----------------------------------------------------------------------------------------------+
   '- Setup gDateActive and gDateRecent                                                            |
   '-----------------------------------------------------------------------------------------------+
   LET LTime = CLASS "PowerTime"                                  '
   LTime.Now                                                      ' Assign the current Date/Time to LTime
   LTime.AddMinutes(-10)                                          ' Minus 10 minutes
   gDateActive = FORMAT$(LTime.year(), "0000") + "-" + FORMAT$(LTime.Month(), "00") + "-" + FORMAT$(LTime.day(), "00") + "  " + _   '
            FORMAT$(LTime.Hour(), "00") + ":" + FORMAT$(LTime.Minute(), "00") '
   LTime.Now                                                      ' Assign the current Date/Time to LTime
   LTime.AddHours(-1)                                             ' Minus 1 hour
   gDateActive1 = FORMAT$(LTime.year(), "0000") + "-" + FORMAT$(LTime.Month(), "00") + "-" + FORMAT$(LTime.day(), "00") + "  " + _  '
            FORMAT$(LTime.Hour(), "00") + ":" + FORMAT$(LTime.Minute(), "00") '
   LTime.AddHours(-7)                                             ' Minus 7 more hours to make -8
   gDateActive8 = FORMAT$(LTime.year(), "0000") + "-" + FORMAT$(LTime.Month(), "00") + "-" + FORMAT$(LTime.day(), "00") + "  " + _  '
            FORMAT$(LTime.Hour(), "00") + ":" + FORMAT$(LTime.Minute(), "00") '
   LTime.AddHours(-16)                                            ' Minus 16 more hours to make -24
   gDateActive24 = FORMAT$(LTime.year(), "0000") + "-" + FORMAT$(LTime.Month(), "00") + "-" + FORMAT$(LTime.day(), "00") + "  " + _ '
            FORMAT$(LTime.Hour(), "00") + ":" + FORMAT$(LTime.Minute(), "00") '
   LTime.AddHours(-24)                                            ' Minus 24 more hours to make -48
   gDateActive48 = FORMAT$(LTime.year(), "0000") + "-" + FORMAT$(LTime.Month(), "00") + "-" + FORMAT$(LTime.day(), "00") + "  " + _ '
            FORMAT$(LTime.Hour(), "00") + ":" + FORMAT$(LTime.Minute(), "00") '

   '-----------------------------------------------------------------------------------------------+
   '- Setup the Backup folder Table                                                                |
   '-----------------------------------------------------------------------------------------------+
   SQLArrayLoad("BDEFAULT", gBKPList(), gBKPCtr)                  ' Let SQLArrayLoad do the work

   InitSBTable                                                    ' Setup SB Table defaults

   '-----------------------------------------------------------------------------------------------+
   '- Next setup the Attr Table                                                                    |
   '-----------------------------------------------------------------------------------------------+
   sAttrInit("N", %File_Attribute_Normal)                         '
   sAttrInit("D", %File_Attribute_Directory)                      '
   sAttrInit("R", %File_Attribute_Readonly)                       '
   sAttrInit("H", %File_Attribute_Hidden)                         '
   sAttrInit("S", %File_Attribute_System)                         '
   sAttrInit("A", %File_Attribute_Archive)                        '
   sAttrInit("T", %File_Attribute_Temporary)                      '
   sAttrInit("C", %File_Attribute_Compressed)                     '
   sAttrInit("P", %File_Attribute_Sparse_File)                    '
   sAttrInit("U", %File_Attribute_Device)                         '
   sAttrInit("L", %File_Attribute_Reparse_Point)                  '
   sAttrInit("O", %File_Attribute_Offline)                        '
   sAttrInit("I", %File_Attribute_Not_Content_Indexed)            '
   sAttrInit("E", %File_Attribute_Encrypted)                      '
   sAttrInit("V", %File_Attribute_Virtual)                        '

   '-----------------------------------------------------------------------------------------------+
   '- The Parse master table                                                                       |
   '-----------------------------------------------------------------------------------------------+
   gSQLP.DBOpen()                                                 ' Open the ParseMaster SQL file
   gSQLP.TableCreate()                                            ' Create the table
   t = RESOURCE$(RCDATA, "PARSEDATA")                             ' Get the data from our EXE file
   j = PARSECOUNT(t, $CRLF)                                       ' Loop through the data finally
   FOR i = 1 TO j                                                 '
      lin = PARSE$(t, $CRLF, i)                                   ' Extract a line
      IF LEFT$(lin, 1) = ";" THEN ITERATE FOR                     ' Ignore comments
      '--------------------------------------------------------------------------------------------+
      '- Handle the ALLKWDS entry                                                                  |
      '--------------------------------------------------------------------------------------------+
      IF LEFT$(lin, 8) = "_ALLKWDS" THEN                          ' If this is it
         FOR x = 2 TO PARSECOUNT(lin, " ")                        ' Get next word
            INCR gKwdMastCtr                                      ' Count it
            gKwdMast(gKwdMastCtr) = PARSE$(lin, " ", x)           ' Store each item
         NEXT x                                                   '
         ITERATE FOR                                              ' All done here
      END IF                                                      '
      IF LEFT$(lin, 1) = "_" THEN                                 ' A Subst string?
         gSQLP.SetString(TRIM$(LEFT$(lin, 10)), MID$(lin, 11) + " ") ' Just store it
      ELSE                                                        ' A master string?
         DO WHILE INSTR(lin, "_")                                 ' Any substitutions to do?
            x = INSTR(lin, "_")                                   ' Extract the _name
            y = INSTR(x + 1, lin, " ")                            ' Find end of name
            u = MID$(lin, x TO y - 1)                             ' Extract it
            v = gSQLP.GetString(u)                                ' Get replacement string
            REPLACE u WITH v IN lin                               ' Swap it in
         LOOP                                                     '
         gSQLP.SetString(TRIM$(LEFT$(lin, 10)), SHRINK$(MID$(lin, 11))) ' Store the updated string
      END IF                                                      '
   NEXT i                                                         '
   REDIM PRESERVE gKwdMast(1 TO gKwdMastCtr) AS GLOBAL STRING     ' Trim upper bound
   MExitSub                                                       '
END SUB                                                           '

SUB InitSBTable()                                                 '
   '-----------------------------------------------------------------------------------------------+
   '- Next setup the Status Bar Table                                                              |
   '-----------------------------------------------------------------------------------------------+
LOCAL lclFG, lclBG, i, j AS LONG, t, tt AS STRING                 '
   lclFG = gENV.GetClr(%SCStatus, %SCFG): lclBG = gENV.GetClr(%SCStatus, %SCBG1) '
   '-  '    Name      ID  Align PosBar Width    FG       BG   Text CWidth
   sSBInit("MODE  ", "A", "C",  "N",     80,  lclFG,   lclBG,  "",  15) '
   sSBInit("LINNO ", "B", "L",  "N",    175,  lclFG,   lclBG,  "",  20) '
   sSBInit("LINES ", "C", "C",  "N",    105,  lclFG,   lclBG,  "",  15) '
   sSBInit("COLS  ", "D", "C",  "N",    135,  lclFG,   lclBG,  "",  23) '
   sSBInit("BNDS  ", "E", "C",  "N",    135,  lclFG,   lclBG,  "",  20) '
   sSBInit("INSOVR", "F", "C",  "N",     75,  lclFG,   lclBG,  "",  04) '
   sSBInit("CASE  ", "G", "C",  "N",     35,  lclFG,   lclBG,  "",  04) '
   sSBInit("CHANGE", "H", "C",  "N",     35,  lclFG,   lclBG,  "",  03) '
   sSBInit("STATE ", "I", "C",  "N",     35,  lclFG,   lclBG,  "",  03) '
   sSBInit("MISC  ", "J", "C",  "Y",    150,  lclFG,   lclBG,  "",  25) '
   sSBInit("SELECT", "K", "C",  "N",    150,  lclFG,   lclBG,  "",  30) '
   sSBInit("CAPS  ", "L", "C",  "N",    120,  lclFG,   lclBG,  "",  09) '
   sSBInit("SOURCE", "M", "C",  "N",     90,  lclFG,   lclBG,  "",  08) '
   sSBInit("EOL   ", "N", "C",  "N",     90,  lclFG,   lclBG,  "",  07) '
   sSBInit("LAYOUT", "O", "C",  "N",     80,  lclFG,   lclBG,  "",  10) '
   sSBInit("PAD   ", "P", "L",  "N",   9999,  lclFG,   lclBG,  "",  99) '
   '-----------------------------------------------------------------------------------------------+
   '- Convert old SBLAYOUT is needed                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF INSTR(gENV.SBLayout, "(") THEN EXIT SUB                     '
   tt = ""                                                        ' Reset replacement string
   FOR i = 1 TO PARSECOUNT(gENV.SBLayout, ",")                    ' Process each entry
      t = LSET$(PARSE$(gENV.SBLayout, ",", i), 6)                 ' Get next entry, make 6 characters                          ' Make name 6 chars
      FOR j = 1 TO 16                                             ' Find name in table
         IF t = gSBTable(j).SBName THEN                           ' Found it
            tt += TRIM$(t) + "("                                  ' Add the fieldname(
            tt += FORMAT$(gSBTable(j).SBMaxTxt) + "),"            ' Add the nn)
         END IF                                                   '
      NEXT j                                                      '
   NEXT i                                                         ' Onward to next KW
   tt = CLIP$(RIGHT, tt, 1)                                       ' Remove trailing ,
   gENV.SBLayout = tt                                             ' Replace the old string
   gSQL.UpdateString("O", "SBLayout", gENV.SBLayout)              '
END SUB                                                           '

SUB      sSBInit(SB1 AS STRING, SB2 AS STRING, SB3 AS STRING, SB4 AS STRING, SB5 AS LONG, SB6 AS LONG, SB7 AS LONG, SB8 AS STRING, SB9 AS LONG) '
'--------------------------------------------------------------------------------------------------+
'- Add a single SB item to the table                                                               |
'--------------------------------------------------------------------------------------------------+
STATIC SBI AS LONG                                                '
   INCR SBI                                                       ' Bump index
   gSBTable(SBI).SBName     = SB1                                 ' Name
   gSBTable(SBI).SBID       = SB2                                 ' ID
   gSBTable(SBI).SBAlign    = SB3                                 ' Alignment
   gSBTable(SBI).SBPosBar   = SB4                                 ' Position Bar box
   gSBTable(SBI).SBAssigned = SBI                                 ' Assigned working position
   gSBTable(SBI).SBWidth    = SB5                                 ' Width
   gSBTable(SBI).SBFG       = SB6                                 ' FG
   gSBTable(SBI).SBBG       = SB7                                 ' BG
   gSBTable(SBI).SBText     = SB8                                 ' Message Text
   gSBTable(SBI).SBMaxTxt   = SB9                                 ' Max char width

END SUB                                                           '

SUB      sAttrInit(ID AS STRING, Mask AS LONG)                    '
'--------------------------------------------------------------------------------------------------+
'- Add a single Attr item to the table                                                             |
'--------------------------------------------------------------------------------------------------+
STATIC Aix AS LONG                                                '
   INCR Aix                                                       ' Bump index
   gAttrTable(Aix).AttrChar   = ID                                ' ID
   gAttrTable(Aix).AttrMask   = Mask                              ' Mask
END SUB                                                           '

FUNCTION InitMoreStuff() AS LONG                                  ' Do the miscellaneous stuff
REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '

LOCAL fn, kfn, kPath, txt1, t, tt AS STRING, FD AS DIRDATA, Expiry, WinCtr, fnum AS LONG, DThread AS DWORD   '
   '-----------------------------------------------------------------------------------------------+
   '- Create the DEBUG window thread now                                                           |
   '-----------------------------------------------------------------------------------------------+
   THREAD CREATE Debug2(i) 65536, TO j                            ' Try to start it
   IF j = 0 THEN                                                  ' Failed?
      MSGBOX "Could not create Debug Window (1)": EXIT FUNCTION   '
   END IF                                                         '
   SLEEP 200                                                      ' Wait a bit
   THREAD STATUS j TO i                                           ' See if running OK
   IF i <> 259 THEN                                               ' If running OK STATUS returns &H103 (See Help)
      MSGBOX "Could not create DEBUG Window (2)"                  '
      THREAD CLOSE j TO i                                         ' Free up our handle
      EXIT FUNCTION                                               '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- If only one instance running, do UNDO file cleanup                                           |
   '-----------------------------------------------------------------------------------------------+

   GetWindowHandle("SPFLite(", WinCtr)                            ' Go Count instances
   IF WinCtr = 0 THEN                                             ' If nobody else here
      fn = GetTempFolder()                                        ' Get the temp directory
      fn += "UND*.TMP"                                            ' Make a generic name
      IF DIR$(fn) <> "" THEN                                      ' Anything to delete?
         TRY                                                      '
            KILL fn                                               ' Wipe out any left over UNDO files
            EXIT TRY                                              '
         CATCH                                                    '
            EXIT TRY                                              '
         END TRY                                                  '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Make sure some directories exist, create them if not                                         |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE ISFOLDER(gENV.Homedata + "CLIP\") THEN MKDIR gENV.Homedata + "CLIP\"          ' Ensure \CLIP exists
   IF ISFALSE ISFOLDER(gENV.HomeData + "AUTO\") THEN MKDIR gENV.HomeData + "AUTO\"          ' Ensure \AUTO exists
   IF ISFALSE ISFOLDER(gENV.HomeData + "FILELIST\") THEN MKDIR gENV.HomeData + "FILELIST\"  ' Ensure \FILELIST exists
   IF ISFALSE ISFOLDER(gENV.HomeData + "RUN\") THEN MKDIR gENV.HomeData + "RUN\"            ' Ensure \RUN exists
   IF ISFALSE ISFOLDER(gENV.HomeData + "MACROS\") THEN MKDIR gENV.HomeData + "MACROS\"      ' Ensure \MACROS exists
   IF ISFALSE ISFOLDER(gENV.HomeData + "STATE\") THEN MKDIR gENV.HomeData + "STATE\"        ' Ensure \STATE exists
   IF ISFALSE ISFOLDER(gENV.HomeData + "JOBS\")  THEN MKDIR gENV.HomeData + "JOBS\"         ' Ensure \JOBS exists

   Expiry = 1                                                     ' Do the 1 day expiry guys
   '-----------------------------------------------------------------------------------------------+
   '- Clean up any old SUBMIT files                                                                |
   '-----------------------------------------------------------------------------------------------+
   fn = gENV.SubmitDir + "\SUB*.*"                                ' Get SUBMIT named files
   GOSUB DoClean                                                  ' Clean them up

   '-----------------------------------------------------------------------------------------------+
   '- Clean up any old RUN files                                                                   |
   '-----------------------------------------------------------------------------------------------+
   fn = gENV.HomeData + "RUN\" + "*.*"                            ' Build an ALL mask
   GOSUB DoClean                                                  ' Clean them up

   Expiry = 180                                                   ' Do the 180 day expiry guys
   '-----------------------------------------------------------------------------------------------+
   '- Clean up any old STATE files                                                                 |
   '-----------------------------------------------------------------------------------------------+
   fn = gENV.HomeData + "STATE\" + "*.*"                          ' Build an ALL mask
   GOSUB DoClean                                                  ' Clean them up

   Expiry = 2                                                     ' Do the 2 day expiry with Temp Clip files
   '-----------------------------------------------------------------------------------------------+
   '- Clean up any old Clip Temp files files                                                       |
   '-----------------------------------------------------------------------------------------------+
   fn = gENV.Homedata + "CLIP\" + "_*.*"                          ' Build an ALL mask
   GOSUB DoClean                                                  ' Clean them up

   '-----------------------------------------------------------------------------------------------+
   '- Now do Retention cleanup                                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF UBOUND(gBKPList()) > 0 THEN                                 ' Have a BKP table?
      IF gBKPList(1) <> RIGHT$(DATE$, 4) + "-" + LEFT$(DATE$, 5) THEN   ' Is BKPList Date not todays?
         FOR i = UBOUND(gBKPList()) TO 2 STEP - 1                 ' Loop throough the list bottom to top
            IF gBKPList(i) <> "" THEN                             ' Ignore unused entries
               BKPDoRetention(CLIP$(RIGHT, gBKPList(i), 1), %True)   ' Let BKPRetention do its thing, allow $BACKUP removal
            END IF                                                '
         NEXT i                                                   '
      END IF                                                      '
      gBKPList(1) = RIGHT$(DATE$, 4) + "-" + LEFT$(DATE$, 5)      ' Set the date to today
      SQLArraySave("BDEFAULT", gBKPList())                        ' Let SQLArraySave do the work
   END IF                                                         '

   EXIT FUNCTION                                                  ' We're done

DoClean:                                                          '
   kPath = PATHNAME$(PATH, fn)                                    ' Get our path
   kfn = DIR$(fn, TO FD)                                          '
   DO WHILE ISNOTNULL(kfn)                                        ' See if any files to delete
      txt1 = TimePretty(FD.LastWriteTime)                         ' Get timestamp from file
      IF GetNumDaysSince(MID$(txt1, 6, 2) + "-" + MID$(txt1, 9, 2) + "-" + LEFT$(txt1, 4)) > Expiry THEN ' If more than Expiry days old
         TRY                                                      '
            KILL kPath + kfn                                      ' Delete it
            EXIT TRY                                              '
         CATCH                                                    '
            EXIT TRY                                              '
         END TRY                                                  '
      END IF                                                      '
      kfn = DIR$(NEXT, TO FD)                                     ' Try for another
   LOOP                                                           '
   RETURN                                                         '
END FUNCTION                                                      '

FUNCTION InitSeeUnique(WCtr AS LONG) AS LONG                      '
'--------------------------------------------------------------------------------------------------+
'- See if we should be running as one instance                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL fWnd, MyThread, OtherThread AS LONG, Title AS STRING        '
STATIC DataToSend AS COPYDATASTRUCT                               '
STATIC zBuffer    AS STRING * 131072                              ' Alloc a huge area
   MEntry                                                         '
   IF ISFALSE gENV.UniqueFlag THEN MExitFunc                      ' If user doesn't want Unique, then just exit
   IF LEN(gENV.FMode) = 4 THEN MExitFunc                          ' An (OE) (OB) (OV) type request?
   '-----------------------------------------------------------------------------------------------+
   '- See if we're running somewhere else                                                          |
   '-----------------------------------------------------------------------------------------------+
   Title = IIF$(gENV.eInstance = "DEFAULT", "SPFLite(v" + gENV.PgmVers + $Beta + ")", "SPFLite(" + gENV.eInstance + $Beta + ")") '
   fWnd = GetWindowHandle(Title, WCtr)                            ' Go see if we're running somewhere
   IF fWnd = 0 OR IsENVOpen THEN MExitFunc                        ' No handle returned, or forced by -OPEN then we're fine

   '-----------------------------------------------------------------------------------------------+
   '- Tell the running instance to 'take over' this request                                        |
   '-----------------------------------------------------------------------------------------------+
   zBuffer = gENV.InitString                                      ' Get Init String
   DataToSend.lpData  = VARPTR(zBuffer)                           ' Build the message
   DataToSend.cbdata  = LEN(zBuffer) + 1                          '
   DataToSend.dwData  = 1                                         '
   SendMessage fWnd, %WM_COPYDATA, ghWnd, VARPTR(DataToSend)      ' Send data to other instance
   '-----------------------------------------------------------------------------------------------+
   '- Tell our caller we passed it off, this instance will be shut down                            |
   '-----------------------------------------------------------------------------------------------+
   FUNCTION = %True                                               '

   '-----------------------------------------------------------------------------------------------+
   '- Make sure the other window is moved to the top to show that 'something' has happened.        |
   '-----------------------------------------------------------------------------------------------+
   MyThread = GetWindowThreadProcessId(ghWnd, 0)                  ' Do the fudge to put the other
   OtherThread = GetWindowThreadProcessId(fWnd, 0)                ' Window active in the foreground
   AttachThreadInput(MyThread, OtherThread, %TRUE)                '
   SetForegroundWindow(fWnd)                                      '
   AttachThreadInput(MyThread, OtherThread, %FALSE)               '
   IF IsIconic(fWnd) THEN                                         '
      ShowWindow(fWnd, %SW_RESTORE)                               '
   ELSEIF IsZoomed(fWnd) THEN                                     '
      ShowWindow(fWnd, %SW_SHOWMAXIMIZED)                         '
   ELSE                                                           '
      ShowWindow(fWnd, %SW_SHOW)                                  '
   END IF                                                         '
   MExit                                                          '
END FUNCTION                                                      '

SUB      InitUpdateCheck                                          '
'--------------------------------------------------------------------------------------------------+
'- See if an update check needed and do it if so                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL VerData AS STRING                                           '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Only do this if needed                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF gENV.WebCheck = 0 THEN MExitSub                             ' If we're not doing checking, exit
   IF GetNumDaysSince(gENV.WebLastDate) < gENV.WebCheck THEN MExitSub   ' If interval not passed, just exit

   '-----------------------------------------------------------------------------------------------+
   '- Get version from the Website, see if it's current                                            |
   '-----------------------------------------------------------------------------------------------+
   Verdata = GetVerFile()                                         ' Get version data from the web
   IF ISNULL(VerData) THEN MExitSub                               ' Null?  Error occurred, just exit
   gENV.WebLastDate = DATE$                                       ' Remember when we last checked
   IF VerData <= gENV.PgmVers THEN MExitSub                       ' Current version (or Beta), just exit
   IF VerData = gENV.WebLastVers THEN MExitSub                    ' Already told user, just exit

   '-----------------------------------------------------------------------------------------------+
   '- Tell user about the new version                                                              |
   '-----------------------------------------------------------------------------------------------+
   DispUpdate(VerData)                                            ' Go tell user
   gENV.WebLastVers = VerData                                     ' Update last one we told about
   MExit                                                          '
END SUB                                                           '
