'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- Macros.inc                                                                                      |
'--------------------------------------------------------------------------------------------------+
                                                                  '
'--------------------------------------------------------------------------------------------------+
'- Get / Set Property Macro                                                                        |
'--------------------------------------------------------------------------------------------------+
MACRO GProp(pName, varType) = PROPERTY GET pName() AS varType: PROPERTY = pName: END PROPERTY   '
MACRO SProp(pName, varType) = PROPERTY SET pName(BYREF v AS varType): pName = v: END PROPERTY   '
MACRO GSProp(pName, varType) = GProp(pName, varType): SProp(pName, varType)   '

'--------------------------------------------------------------------------------------------------+
'- Call and Branch macros, for calling routines using RC values of 1, 2, 3, ...                    |
'--------------------------------------------------------------------------------------------------+
MACRO Call2(Func, Do1, Do2)                                       '
   MACROTEMP R1, R2                                               '
   ON Func GOTO R1, R2                                            '
   R1:                                                            '
     Do1                                                          '
   R2:                                                            '
     Do2                                                          '
END MACRO                                                         '

MACRO Call3(Func, Do1, Do2, Do3)                                  '
   MACROTEMP R1, R2, R3                                           '
   ON Func GOTO R1, R2, R3                                        '
   R1:                                                            '
     Do1                                                          '
   R2:                                                            '
     Do2                                                          '
   R3:                                                            '
     Do3                                                          '
END MACRO                                                         '

MACRO Call4(Func, Do1, Do2, Do3, Do4)                             '
   MACROTEMP R1, R2, R3, R4                                       '
   ON Func GOTO R1, R2, R3, R4                                    '
   R1:                                                            '
     Do1                                                          '
   R2:                                                            '
     Do2                                                          '
   R3:                                                            '
     Do3                                                          '
   R4:                                                            '
     Do4                                                          '
END MACRO                                                         '

'--------------------------------------------------------------------------------------------------+
'- Compare routines to support ArraySearch                                                         |
'--------------------------------------------------------------------------------------------------+
MACRO FUNCTION CompareSimpleS(A, B) = strcmpr(a, b)               ' Simple STRING Compare case independent
MACRO FUNCTION CompareSimpleL(A, B) = SWITCH&(A < B, -1, A > B, 1)   ' Simple LONG Compare

MACRO FUNCTION CompareUDTL(A, B)                                  ' Sample LONG compare of a UDT field
   MACROTEMP Lng                                                  '
   LOCAL lng AS LONG                                              '
   lng = B.udtl                                                   '
END MACRO = CompareSimpleL(A, lng)                                '

MACRO FUNCTION CompareUDTS(A, B)                                  ' Sample String compare of a UDT field
   MACROTEMP str                                                  '
   LOCAL str AS STRING                                            '
   str = B.udts                                                   '
END MACRO = strcmpr(A, str)                                       '

MACRO FUNCTION CompareNAME(A, B)                                  ' String compare of a UDT field NAME
   MACROTEMP str                                                  '
   LOCAL str AS STRING                                            '
   str = B.NAME                                                   '
END MACRO = strcmpr(A, str)                                       '

MACRO FUNCTION ComparelcTxt(A, B)                                 ' String compare of a UDT field lcTxt
   MACROTEMP str                                                  '
   LOCAL str AS STRING                                            '
   str = B.lcTxt                                                  '
END MACRO = strcmpr(A, str)                                       '

MACRO FUNCTION ArraySearch(Arr, Arg, CompareMacro)                '
   MACROTEMP i, bot, top, compare, result                         '
   REGISTER i AS LONG : LOCAL bot, top, compare, result AS LONG   '
   result = 0                                                     '
   bot = LBOUND(Arr): top = UBOUND(ARR)                           '
   DO WHILE top >= bot                                            '
      i = bot + (top + 1) : SHIFT RIGHT i, 1                      '
      compare = CompareMacro(Arg, Arr(i))                         '
      IF compare > 0 THEN                                         '
         bot = i + 1                                              '
      ELSEIF compare < 0 THEN                                     '
         top = i - 1                                              '
      ELSE                                                        '
         Result = i : EXIT DO                                     '
      END IF                                                      '
   LOOP                                                           '
END MACRO = Result                                                '

'--------------------------------------------------------------------------------------------------+
'- Handle Debug module trace                                                                       |
'--------------------------------------------------------------------------------------------------+
'- : Debuglog FUNCNAME$
MACRO MEntry()          = gCrashList(gCrashCtr) = FUNCNAME$ : gCrashCtr = MIN(1000, gCrashCtr + 1)
MACRO MExit()           = gCrashCtr = MAX(1, gCrashCtr - 1)
MACRO MExitSub()        = gCrashCtr = MAX(1, gCrashCtr - 1): EXIT SUB
MACRO MExitFunc()       = gCrashCtr = MAX(1, gCrashCtr - 1): EXIT FUNCTION
MACRO MExitMeth()       = gCrashCtr = MAX(1, gCrashCtr - 1): EXIT METHOD
'MACRO MEntry()          = gCrashCtr = 0
'MACRO MExit()           = gCrashCtr = 0
'MACRO MExitSub()        = EXIT SUB
'MACRO MExitFunc()       = EXIT FUNCTION
'MACRO MExitMeth()       = EXIT METHOD
'macro DDebug(str)        = DEBUG str
MACRO DDebug(str)        =
'
MACRO MErrExit(a, b)    = TP.ErrMsgAdd(a, b): MExitMeth
MACRO MLErrExit(a, b)   = gFMD(a).Message = b: DoSet(%Msg): MExitMeth
MACRO AnswerSub(a, b)   = RCA.RC = a: RCA.Msg = b: EXIT SUB
MACRO AnswerMeth(a, b)  = RCA.RC = a: RCA.Msg = b: EXIT METHOD

'--------------------------------------------------------------------------------------------------+
'- Running in debugger?                                                                            |
'--------------------------------------------------------------------------------------------------+
MACRO IsPBDebuggerOn = (ISTRUE LEN(ENVIRON$("PBDEBUG")))          '

'--------------------------------------------------------------------------------------------------+
'- TP.ErrMsgAdd code if not gMacroMode                                                             |
'--------------------------------------------------------------------------------------------------+
MACRO NMac(errcd) = IIF(gMacroMode, errcd, %eNone)                '

'--------------------------------------------------------------------------------------------------+
'- Misc macros                                                                                     |
'--------------------------------------------------------------------------------------------------+
MACRO DoBeep            = gDoBeepFlag = %True                     '
MACRO IsEQ(a,b)         = ISTRUE (StrCmpr(a, b) = 0)              '
MACRO IsNE(a,b)         = ISTRUE (StrCmpr(a, b) <> 0)             '
MACRO IsProfile(pname)  = gSQL.TableExist("P" + pname)            '
MACRO IsCCmnd           = @P.C.CType = %CCmd                      '
MACRO IsCScrl           = @P.C.CType = %CScrl                     '
MACRO IsCData           = @P.C.CType = %CLData                    '
MACRO IsCLinN           = @P.C.CType = %CLCmd                     '
MACRO IsCLLin           = @P.C.CType = %CFLData                   '
MACRO IsCLCmd           = @P.C.CType = %CFLCmd                    '
MACRO IsCPath           = @P.C.CType = %CFPath                    '
MACRO IsCMask           = @P.C.CType = %CFMask                    '
MACRO IsCBad            = @P.C.CType = %CBad                      '

MACRO IsLfAll           = ISTRUE BIT(LocFlag, %LocAll)            '
MACRO IsLfTop           = ISTRUE BIT(LocFlag, %LocTop)            '
MACRO IsLfPrev          = ISTRUE BIT(LocFlag, %LocPrev)           '
MACRO IsLfFirst         = ISTRUE BIT(LocFlag, %LocFirst)          '
MACRO IsLfLast          = ISTRUE BIT(LocFlag, %LocLast)           '
MACRO IsLfNot           = ISTRUE BIT(LocFlag, %LocNot)            '
MACRO IsLfChange        = ISTRUE BIT(LocFlag, %LocChange)         '
MACRO IsLfCurrent       = ISTRUE BIT(LocFlag, %LocCurrent)        '
MACRO IsLfFind          = ISTRUE BIT(LocFlag, %LocFind)           '
MACRO IsLfCommand       = ISTRUE BIT(LocFlag, %LocCommand)        '
MACRO IsLfError         = ISTRUE BIT(LocFlag, %LocError)          '
MACRO IsLfExcluded      = ISTRUE BIT(LocFlag, %LocExcluded)       '
MACRO IsLfU             = ISTRUE BIT(LocFlag, %LocU)              '
MACRO IsLfNU            = ISTRUE BIT(LocFlag, %LocNU)             '
MACRO IsLfLabel         = ISTRUE BIT(LocFlag, %LocLabel)          '
MACRO IsLfHandle        = ISTRUE BIT(LocFlag, %LocHandle)         '
MACRO IsLfNote          = ISTRUE BIT(LocFlag, %LocNote)           '
MACRO IsLfSpecial       = ISTRUE BIT(LocFlag, %LocSpecial)        '
MACRO IsLfFile          = ISTRUE BIT(LocFlag, %LocFile)           '
MACRO IsLfPage          = ISTRUE BIT(LocFlag, %LocPage)           '
MACRO IsLfKeep          = ISTRUE BIT(LocFlag, %LocKeep)           '
MACRO IsLfTag           = ISTRUE BIT(LocFlag, %LocTag)            '
MACRO IsLfLong          = ISTRUE BIT(LocFlag, %LocLong)           '
MACRO IsLfSize          = ISTRUE BIT(LocFlag, %LocSize)           '
MACRO IsLfColor         = ISTRUE BIT(LocFlag, %LocColor)          '
MACRO IsLfStd           = ISTRUE BIT(LocFlag, %LocStd)            '
MACRO IsLfMX            = ISTRUE BIT(LocFlag, %LocMX)             '
MACRO IsLfNX            = ISTRUE BIT(LocFlag, %LocNX)             '
MACRO IsLfSpell         = ISTRUE BIT(LocFlag, %LocSpell)          '

MACRO LfSet(flag)       = BIT SET LocFlag, flag                   '
MACRO LfClear(flag)     = BIT RESET LocFlag, flag                 '

MACRO DOSet(flag)       = AttnDo OR= flag                         '
MACRO TPDOSet(flag)     = TP.AttnDo = TP.AttnDo OR flag           '
MACRO DOClear(flag)     = AttnDo = AttnDo AND (&HFFFFFFFF - flag) '

MACRO IsDOLoadReq       = (AttnDo AND %LoadReq)                   '
MACRO IsDOLoadData      = (AttnDo AND %LoadData)                  '
MACRO IsDOSaveReq       = (AttnDo AND %SaveReq)                   '
MACRO IsDORefresh       = (AttnDo AND %Refresh)                   '
MACRO IsDOAttention     = (AttnDo AND %Attention)                 '
MACRO IsDOMsg           = (AttnDo AND %Msg)                       '
MACRO IsDOMarkKill      = (AttnDo AND %MarkKill)                  '
MACRO IsDOMarkKillSkip  = (AttnDo AND %MarkKillSkip)              '

MACRO IsLData(i)        = ISTRUE (L(i).LFlag AND %Data)           '
MACRO IsLTop(i)         = ISTRUE (L(i).LFlag AND %Top)            '
MACRO IsLBottom(i)      = ISTRUE (L(i).LFlag AND %Bottom)         '
MACRO IsLFile(i)        = ISTRUE (L(i).LFlag AND %File)           '
MACRO IsLXClude(i)      = ISTRUE (L(i).LFlag AND %XClude)         '
MACRO IsLTabs(i)        = ISTRUE (L(i).LFlag AND %Tabs)           '
MACRO IsLBounds(i)      = ISTRUE (L(i).LFlag AND %Bounds)         '
MACRO IsLCols(i)        = ISTRUE (L(i).LFlag AND %Cols)           '
MACRO IsLInvisible(i)   = ISTRUE (L(i).LFlag AND %Invisible)      '
MACRO IsLInsertLine(i)  = ISTRUE (L(i).LFlag AND %InsertLine)     '
MACRO IsLEQChange(i)    = ISTRUE (L(i).LFlag AND %EQChange)       '
MACRO IsLWord(i)        = ISTRUE (L(i).LFlag AND %Word)           '
MACRO IsLMark(i)        = ISTRUE (L(i).LFlag AND %Mark)           '
MACRO IsLMask(i)        = ISTRUE (L(i).LFlag AND %Mask)           '
MACRO IsLProf(i)        = ISTRUE (L(i).LFlag AND %Prof)           '
MACRO IsLEFT(i)         = ISTRUE (L(i).LFlag AND %EFT)            '
MACRO IsLCursor(i)      = ISTRUE (L(i).LFlag AND %Cursor)         '
MACRO IsLTopScreen(i)   = ISTRUE (L(i).LFlag AND %TopScreen)      '
MACRO IsLScroll(i)      = ISTRUE (L(i).LFlag AND %Scroll)         '
MACRO IsLXPtr(i)        = ISTRUE (L(i).LFlag AND %XPtr)           '
MACRO IsLPage(i)        = ISTRUE (L(i).LFlag AND %Page)           '
MACRO IsLNote(i)        = ISTRUE (L(i).LFlag AND %Note)           '
MACRO IsLPopped(i)      = ISTRUE (L(i).LFlag AND %Popped)         '
MACRO IsLUser(i)        = ISTRUE (L(i).LFlag AND %User)           '
MACRO IsLChange(i)      = ISTRUE (L(i).LFlag AND %EQChange)       '

MACRO IsFMTab           = ISTRUE (TP.TabMode AND %FMTab)          '
MACRO IsEdit            = ISTRUE (TP.TabMode AND %Edit)           '
MACRO IsMEdit           = ISTRUE (TP.TabMode AND %MEdit)          '
MACRO IsSetEdit         = ISTRUE (TP.TabMode AND %SetEdit)        '
MACRO IsEFTEdit         = ISTRUE (TP.TabMode AND %EFTEdit)        '
MACRO IsClip            = ISTRUE (TP.TabMode AND %Clip)           '
MACRO IsDiff            = ISTRUE (TP.TabMode AND %Diff)           '
MACRO IsView            = ISTRUE (TP.TabMode AND %View)           '
MACRO IsBrowse          = ISTRUE (TP.TabMode AND %Browse)         '
MACRO IsOpen            = ISTRUE (TP.TabMode AND %Open)           '
MACRO IsClipLoad        = ISTRUE (TP.TabMode AND %ClipLoad)       '

MACRO IsENVOpen         = ISTRUE (gENV.PMode AND %Open)           '
MACRO IsENVKeyMap       = ISTRUE (gENV.PMode AND %KeyMap)         '

MACRO IsBndsAFlag        = ISTRUE (Flag AND %BndsAFlag)           '
MACRO OnBndsAFlag        = Flag OR= %BndsAFlag                    '
MACRO OffBndsAFlag       = Flag AND= (&HFFFFFFFF - %BndsAFlag)    '

MACRO IsWordAFlag        = ISTRUE (Flag AND %WordAFlag)           '
MACRO OnWordAFlag        = Flag OR= %WordAFlag                    '
MACRO OffWordAFlag       = Flag AND= (&HFFFFFFFF - %WordAFlag)    '

MACRO IsMarkAFlag        = ISTRUE (Flag AND %MarkAFlag)           '
MACRO OnMarkAFlag        = Flag OR= %MarkAFlag                    '
MACRO OffMarkAFlag       = Flag AND= (&HFFFFFFFF - %MarkAFlag)    '

MACRO IsMaskAFlag        = ISTRUE (Flag AND %MaskAFlag)           '
MACRO OnMaskAFlag        = Flag OR= %MaskAFlag                    '
MACRO OffMaskAFlag       = Flag AND= (&HFFFFFFFF - %MaskAFlag)    '

MACRO IsTabsAFlag        = ISTRUE (Flag AND %TabsAFlag)           '
MACRO OnTabsAFlag        = Flag OR= %TabsAFlag                    '
MACRO OffTabsAFlag       = Flag AND= (&HFFFFFFFF - %TabsAFlag)    '

MACRO IsUndoFlag         = ISTRUE (Flag AND %UndoFlag)            '
MACRO OnUndoFlag         = Flag OR= %UndoFlag                     '
MACRO OffUndoFlag        = Flag AND= (&HFFFFFFFF - %UndoFlag)     '

MACRO IsClrCase          = ISTRUE (Flag AND %ClrCase)             '
MACRO OnClrCase          = Flag OR= %ClrCase                      '
MACRO OffClrCase         = Flag AND= (&HFFFFFFFF - %ClrCase)      '

MACRO IsBackupDone       = ISTRUE (Flag AND %BackupDone)          '
MACRO OnBackupDone       = Flag OR= %BackupDone                   '
MACRO OffBackupDone      = Flag AND= (&HFFFFFFFF - %BackupDone)   '

MACRO IsHideFlag         = ISTRUE (Flag AND %HideFlag)            '
MACRO IsTPHideFlag       = ISTRUE (TP.Flag AND %HideFlag)         '
MACRO OnHideFlag         = Flag OR= %HideFlag                     '
MACRO OffHideFlag        = Flag AND= (&HFFFFFFFF - %HideFlag)     '

MACRO IsInsClnSupp       = ISTRUE (Flag AND %InsClnSupp)          '
MACRO OnInsClnSupp       = Flag OR= %InsClnSupp                   '
MACRO OnTPInsClnSupp     = TP.Flag = (TP.Flag OR %InsClnSupp)     '
MACRO OffInsClnSupp      = Flag AND= (&HFFFFFFFF - %InsClnSupp)   '

MACRO IsRenumFlag        = ISTRUE (Flag AND %RenumFlag)           '
MACRO OnRenumFlag        = Flag OR= %RenumFlag                    '
MACRO OffRenumFlag       = Flag AND= (&HFFFFFFFF - %RenumFlag)    '

MACRO IsModdFlag         = ISTRUE (Flag AND %ModdFlag)            '
MACRO IsTPModdFlag       = ISTRUE (TP.Flag AND %ModdFlag)         '
MACRO OnModdFlag         = Flag OR= %ModdFlag                     '
MACRO OffModdFlag        = Flag AND= (&HFFFFFFFF - %ModdFlag)     '

MACRO IsModdEver         = ISTRUE (Flag AND %ModdEver)            '
MACRO OnModdEver         = Flag OR= %ModdEver                     '
MACRO OffModdEver        = Flag AND= (&HFFFFFFFF - %ModdEver)     '
MACRO IsModdLast         = ISTRUE (Flag AND %ModdLast)            '
MACRO OnModdLast         = Flag OR= %ModdLast                     '
MACRO OffModdLast        = Flag AND= (&HFFFFFFFF - %ModdLast)     '

MACRO IsOvrTextDel       = ISTRUE (Flag AND %OvrTextDel)          '
MACRO OnOvrTextDel       = Flag OR= %OvrTextDel                   '
MACRO OffOvrTextDel      = Flag AND= (&HFFFFFFFF - %OvrTextDel)   '

MACRO IsColSupp          = ISTRUE (Flag AND %ColSupp)             '
MACRO OnColSupp          = Flag OR= %ColSupp                      '
MACRO OffColSupp         = Flag AND= (&HFFFFFFFF - %ColSupp)      '

MACRO IsPFKInsert        = ISTRUE (Flag AND %PFKInsert)           '
MACRO OnPFKInsert        = Flag OR= %PFKInsert                    '
MACRO OnTPPFKInsert      = TP.Flag = (TP.Flag OR %PFKInsert)      '
MACRO OffPFKInsert       = Flag AND= (&HFFFFFFFF - %PFKInsert)    '

MACRO IsPTypeMode        = ISTRUE (Flag AND %PTypeMode)           '
MACRO IsTPPTypeMode      = ISTRUE (TP.Flag AND %PTypeMode)        '
MACRO OnPTypeMode        = Flag OR= %PTypeMode                    '
MACRO OffPTypeMode       = Flag AND= (&HFFFFFFFF - %PTypeMode)    '
MACRO OffTPPTypeMode     = TP.Flag = (TP.Flag AND (&HFFFFFFFF - %PTypeMode))  '

MACRO IsRevOnce          = ISTRUE (Flag AND %RevOnce)             '
MACRO OnRevOnce          = Flag OR= %RevOnce                      '
MACRO OffRevOnce         = Flag AND= (&HFFFFFFFF - %RevOnce)      '

MACRO IsStateExist       = ISTRUE (Flag AND %StateExist)          '
MACRO IsTPStateExist     = ISTRUE (TP.Flag AND %StateExist)       '
MACRO OnStateExist       = Flag OR= %StateExist                   '
MACRO OffStateExist      = Flag AND= (&HFFFFFFFF - %StateExist)   '

MACRO IsStateForce       = ISTRUE (Flag AND %StateForce)          '
MACRO OnStateForce       = Flag OR= %StateForce                   '
MACRO OffStateForce      = Flag AND= (&HFFFFFFFF - %StateForce)   '

MACRO IsClrFlag          = ISTRUE (Flag AND %ClrFlag)             '
MACRO IsTPClrFlag        = ISTRUE (TP.Flag AND %ClrFlag)          '
MACRO OnClrFlag          = Flag OR= %ClrFlag                      '
MACRO OffClrFlag         = Flag AND= (&HFFFFFFFF - %ClrFlag)      '

MACRO IsMarkActive       = ISTRUE (Flag AND %MarkActive)          '
MACRO IsTPMarkActive     = ISTRUE (TP.Flag AND %MarkActive)       '
MACRO OnMarkActive       = Flag OR= %MarkActive                   '
MACRO OffMarkActive      = Flag AND= (&HFFFFFFFF - %MarkActive)   '
MACRO OffTPMarkActive    = TP.Flag =  TP.Flag AND (&HFFFFFFFF - %MarkActive)  '

MACRO IsMarkDrawn        = ISTRUE (Flag AND %MarkDrawn)           '
MACRO IsTPMarkDrawn      = ISTRUE (TP.Flag AND %MarkDrawn)        '
MACRO OnMarkDrawn        = Flag OR= %MarkDrawn                    '
MACRO OffMarkDrawn       = Flag AND= (&HFFFFFFFF - %MarkDrawn)    '

MACRO IsMiscActive       = ISTRUE (Flag AND %MiscActive)          '
MACRO IsTPMiscActive     = ISTRUE (TP.Flag AND %MiscActive)       '
MACRO OnMiscActive       = Flag OR= %MiscActive                   '
MACRO OffMiscActive      = Flag AND= (&HFFFFFFFF - %MiscActive)   '
MACRO OffTPMiscActive    = TP.Flag =  TP.Flag AND (&HFFFFFFFF - %MiscActive)  '

MACRO IsMiscDrawn        = ISTRUE (Flag AND %MiscDrawn)           '
MACRO IsTPMiscDrawn      = ISTRUE (TP.Flag AND %MiscDrawn)        '
MACRO OnMiscDrawn        = Flag OR= %MiscDrawn                    '
MACRO OffMiscDrawn       = Flag AND= (&HFFFFFFFF - %MiscDrawn)    '

MACRO IsSwapActive       = ISTRUE (Flag AND %SwapActive)          '
MACRO IsTPSwapActive     = ISTRUE (TP.Flag AND %SwapActive)       '
MACRO OnSwapActive       = Flag OR= %SwapActive                   '
MACRO OffSwapActive      = Flag AND= (&HFFFFFFFF - %SwapActive)   '
MACRO OffTPSwapActive    = TP.Flag =  TP.Flag AND (&HFFFFFFFF - %SwapActive)  '

MACRO IsSwapDrawn        = ISTRUE (Flag AND %SwapDrawn)           '
MACRO IsTPSwapDrawn      = ISTRUE (TP.Flag AND %SwapDrawn)        '
MACRO OnSwapDrawn        = Flag OR= %SwapDrawn                    '
MACRO OffSwapDrawn       = Flag AND= (&HFFFFFFFF - %SwapDrawn)    '

MACRO IsSlecSet          = ISTRUE (Flag AND %SlecSet)             '
MACRO IsTPSlecSet        = ISTRUE (TP.Flag AND %SlecSet)          '
MACRO OnSlecSet          = Flag OR= %SlecSet                      '
MACRO OffSlecSet         = Flag AND= (&HFFFFFFFF - %SlecSet)      '

MACRO IsSlecActive       = ISTRUE (Flag AND %SlecActive)          '
MACRO IsTPSlecActive     = ISTRUE (TP.Flag AND %SlecActive)       '
MACRO OnSlecActive       = Flag OR= %SlecActive                   '
MACRO OffSlecActive      = Flag AND= (&HFFFFFFFF - %SlecActive)   '

MACRO IsNSrtData         = ISTRUE (Flag2 AND %NSrtData)           '
MACRO IsTPNSrtData       = ISTRUE (TP.Flag2 AND %NSrtData)        '
MACRO OnNSrtData         = Flag2 OR= %NSrtData                    '
MACRO OffNSrtData        = Flag2 AND= (&HFFFFFFFF - %NSrtData)    '
MACRO OffTPNSrtData      = TP.Flag2 = TP.Flag2  AND (&HFFFFFFFF - %NSrtData)  '

MACRO IsNsrtFlag         = ISTRUE (Flag2 AND %NsrtFlag)           '
MACRO IsNotNsrtFlag      = ISFALSE (Flag2 AND %NsrtFlag)          '
MACRO IsTPNsrtFlag       = ISTRUE (TP.Flag2 AND %NsrtFlag)        '
MACRO OnNsrtFlag         = Flag2 OR= %NsrtFlag                    '
MACRO OffNsrtFlag        = Flag2 AND= (&HFFFFFFFF - %NsrtFlag)    '

MACRO IsNsrtSave         = ISTRUE (Flag2 AND %NsrtSave)           '
MACRO OnNsrtSave         = Flag2 OR= %NsrtSave                    '
MACRO OnTPNsrtSave       = TP.Flag2 = (TP.Flag2 OR %NsrtSave)     '
MACRO OffNsrtSave        = Flag2 AND= (&HFFFFFFFF - %NsrtSave)    '
MACRO OffTPNsrtSave      = TP.Flag2 = TP.Flag2  AND (&HFFFFFFFF - %NsrtSave)  '

MACRO IsNsrtSaveD        = ISTRUE (Flag2 AND %NsrtSaveD)          '
MACRO OnNsrtSaveD        = Flag2 OR= %NsrtSaveD                   '
MACRO OnTPNsrtSaveD      = TP.Flag2 = (TP.Flag2 OR %NsrtSaveD)    '
MACRO OffNsrtSaveD       = Flag2 AND= (&HFFFFFFFF - %NsrtSaveD)   '
MACRO OffTPNsrtSaveD     = TP.Flag2 = TP.Flag2  AND (&HFFFFFFFF - %NsrtSaveD) '

MACRO IsFileHide         = ISTRUE (Flag2 AND %FileHide)           '
MACRO IsTPFileHide       = ISTRUE (TP.Flag2 AND %FileHide)        '
MACRO OnFileHide         = Flag2 OR= %FileHide                    '
MACRO OffFileHide        = Flag2 AND= (&HFFFFFFFF - %FileHide)    '
MACRO OffTPFileHide      = TP.Flag2 = TP.Flag2  AND (&HFFFFFFFF - %FileHide)  '

MACRO LFOn(i, fl)       = L(i).LFlag = (L(i).LFlag OR fl)         '
MACRO LFOff(i, fl)      = L(i).LFlag = (L(i).LFlag AND (&HFFFFFFFF - fl))  '
MACRO LFTog(i, fl)      = L(i).LFlag = (L(i).LFlag XOR fl)        '

MACRO LTxtG(i)          = L(i).@LTxt                              '
MACRO LTxtGP(i)         = L(i).LTxt                               '
MACRO LTxtGLen(i)       = LEN(L(i).@LTxt)                         '
MACRO LTxtSPtr(i)       = STRPTR(L(i).@LTxt)                      '
MACRO LTxtS(i)          = L(i).@LTxt                              '

MACRO LAttrG(i)         = L(i).@LAttr                             '
MACRO LAttrGP(i)        = L(i).LAttr                              '
MACRO LAttrGLen(i)      = LEN(L(i).@LAttr)                        '
MACRO LAttrSPtr(i)      = STRPTR(L(i).@LAttr)                     '

MACRO LMIXG(i)          = L(i).LMix                               '
MACRO LFIXG(i)          = L(i).LFix                               '

MACRO LFlagG(i)         = L(i).LFlag                              '
MACRO LTagG(i)          = L(i).LTag                               '
MACRO LLNumG(i)         = L(i).LLNum                              '
MACRO LLCtlG(i)         = L(i).LLCtl                              '
MACRO LLblG(i)          = L(i).LLbl                               '
MACRO LWrk1G(i)         = L(i).LWrk1                              '
MACRO LWrk2G(i)         = L(i).LWrk2                              '
MACRO LHndlG(i)         = L(i).LHndl                              '
MACRO LTrakG(i)         = L(i).LTrak                              '

MACRO LAttrS(i)         = L(i).@LAttr                             '
MACRO LMIXS(i)          = L(i).LMix                               '
MACRO LFixS(i)          = L(i).LFix                               '
MACRO LFlagS(i)         = L(i).LFlag                              '
MACRO LTagS(i)          = L(i).LTag                               '
MACRO LLNumS(i)         = L(i).LLNum                              '
MACRO LLCtlS(i)         = L(i).LLCtl                              '
MACRO LLblS(i)          = L(i).LLbl                               '
MACRO LWrk1S(i)         = L(i).LWrk1                              '
MACRO LWrk2S(i)         = L(i).LWrk2                              '
MACRO LHndlS(i)         = L(i).LHndl                              '
MACRO LTrakS(i)         = L(i).LTrak                              '

MACRO GoToTab(num,MSG,cmd) = gTabGoto.Number = num: gTabGoTo.Message = MSG: gTabGoTo.Command = cmd '
