'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjCmnt.inc                                                                                     |
'--------------------------------------------------------------------------------------------------+
                                                                  '
CLASS cCmnt                                                       '
   INSTANCE Txt1()     AS STRING                                  ' Comment string 1
   INSTANCE Txt2()     AS STRING                                  ' Comment string 2
   INSTANCE ETxt()     AS STRING                                  ' Exclude string
   INSTANCE ITxt()     AS STRING                                  ' Include string
   INSTANCE CData()    AS CommModel                               ' Fixed length data

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
   DIM Txt1(1 TO 9)  AS INSTANCE STRING                           ' DIM the tables
   DIM Txt2(1 TO 9)  AS INSTANCE STRING                           '
   DIM ETxt(1 TO 9)  AS INSTANCE STRING                           '
   DIM ITxt(1 TO 9)  AS INSTANCE STRING                           '
   DIM CData(1 TO 9) AS INSTANCE CommModel                        '
   END METHOD                                                     '

   INTERFACE iCmnt: INHERIT IUNKNOWN                              ' Define the interface

      METHOD GTxt1(i AS LONG) AS STRING: METHOD = Txt1(i):            END METHOD '
      METHOD GTxt1L(i AS LONG) AS LONG:  METHOD = CData(i).Txt1L:     END METHOD '
      METHOD GTxt2(i AS LONG) AS STRING: METHOD = Txt2(i):            END METHOD '
      METHOD GTxt2L(i AS LONG) AS LONG:  METHOD = CData(i).Txt2L:     END METHOD '
      METHOD GETxt(i AS LONG) AS STRING: METHOD = ETxt(i):            END METHOD '
      METHOD GETxtL(i AS LONG) AS LONG:  METHOD = LEN(ETxt(i)):       END METHOD '
      METHOD GITxt(i AS LONG) AS STRING: METHOD = ITxt(i):            END METHOD '
      METHOD GITxtL(i AS LONG) AS LONG:  METHOD = LEN(ITxt(i)):       END METHOD '
      METHOD GsCol(i AS LONG) AS LONG:   METHOD = CData(i).sCol:      END METHOD '
      METHOD GSch(i AS LONG)  AS LONG:   METHOD = CData(i).Sch:       END METHOD '
      METHOD GFnd(i AS LONG)  AS LONG:   METHOD = CData(i).Fnd:       END METHOD '
      METHOD GEsCol(i AS LONG) AS LONG:  METHOD = CData(i).EsCol:     END METHOD '
      METHOD GIsCol(i AS LONG) AS LONG:  METHOD = CData(i).IsCol:     END METHOD '

      METHOD STxt1(i AS LONG, v AS STRING): Txt1(i) = v: CData(i).Txt1L = LEN(v): END METHOD '
      METHOD STxt2(i AS LONG, v AS STRING): Txt2(i) = v: CData(i).Txt2L = LEN(v): END METHOD '
      METHOD SETxt(i AS LONG, v AS STRING): ETxt(i) = v:              END METHOD '
      METHOD SITxt(i AS LONG, v AS STRING): ITxt(i) = v:              END METHOD '
      METHOD SsCol(i AS LONG, v AS LONG):   CData(i).sCol = v:        END METHOD '
      METHOD SSch(i AS LONG,  v AS LONG):   CData(i).Sch = v:         END METHOD '
      METHOD SFnd(i AS LONG,  v AS LONG):   CData(i).Fnd = v:         END METHOD '
      METHOD SEsCol(i AS LONG, v AS LONG):  CData(i).EsCol = v:       END METHOD '
      METHOD SIsCol(i AS LONG, v AS LONG):  CData(i).IsCol = v:       END METHOD '
   END INTERFACE                                                  '

END CLASS                                                         '
