'--------------------------------------------------------------------------------------------------+
'- A single Dictionary Entry                                                                       +
'--------------------------------------------------------------------------------------------------+
CLASS cDicEntry                                                   '
   INSTANCE DicNext        AS LONG                                ' Next pointer
   INSTANCE DicKey         AS STRING                              ' The Key
   INSTANCE DicVal         AS STRING                              ' The Valuetext

   INTERFACE iDicEntry: INHERIT IUNKNOWN                          ' Define the interface

      gsProp(DicNext, LONG)                                       ' Properties
      gsProp(DicKey,  STRING)                                     '
      gsProp(DicVal,  STRING)                                     '
   END INTERFACE                                                  '
END CLASS                                                         '

'--------------------------------------------------------------------------------------------------+
'- Class to support our own Dictionary instead of PB Collections                                   +
'--------------------------------------------------------------------------------------------------+
CLASS cDicObj                                                     '
   INSTANCE DicShelves()   AS LONG                                ' Shelf chain of Hash Dupicates
   INSTANCE DicEntries()   AS iDicEntry                           ' The actual Dict. entries
   INSTANCE DicFree        AS STRING                              ' Map of free DicEntries
   INSTANCE DicCount       AS LONG                                ' Count of current active Entries
   INSTANCE DicNumShelves  AS LONG                                ' How many DicShelves

   CLASS METHOD CREATE()
       REDIM DicShelves(1 TO 100) AS INSTANCE LONG
       REDIM DicEntries(1 TO 100) AS INSTANCE iDicEntry
       DicFree = REPEAT$(100, "_")
       DicCount = 0
       DicNumShelves = 100
   END METHOD

   INTERFACE iDicObj: INHERIT IUNKNOWN                            ' Define the interface

   METHOD DicNumEntries() AS LONG: METHOD = UBOUND(DicEntries()): END METHOD

   METHOD DicHash(s AS STRING) AS LONG
   '-----------------------------------------------------------------------------------------------+
   '- Hash a key into a Shelf Number                                                               +
   '-----------------------------------------------------------------------------------------------+
   REGISTER i AS LONG                                             '
   REGISTER h AS DWORD                                            '
       h = 5381                                                   ' Start with a Prime
       FOR i = 1 TO LEN(s)                                        ' Massage it
           h = (h * 33) + ASC(MID$(s, i, 1))                      '
       NEXT i                                                     '
       METHOD = (h MOD DicNumShelves) + 1                         ' Hash key to get Shelf #
   END METHOD                                                     '

   METHOD DicAlloc() AS LONG
   '-----------------------------------------------------------------------------------------------+
   '- Allocate a DicEntries item for use                                                           +
   '-----------------------------------------------------------------------------------------------+
   LOCAL IX, PrevHi AS LONG
      PrevHi = LEN(DicFree)                                       ' Save the current # entries
      IX = INSTR(DicFree, "_")                                    ' Look for a free entry
      IF IX = 0 THEN                                              ' None? Time to grow
         REDIM PRESERVE DicEntries(1 TO (2 * PrevHi)) AS INSTANCE iDicEntry ' Double the current
         DicFree += REPEAT$(PrevHi, "_")                          ' Add same number of free entries
         IX = PrevHi + 1                                          ' Point IX at the 1st new free item
      END IF                                                      '
      MID$(DicFree, IX, 1) = "U"                                  ' Mark the item as 'in use'
      IF ISFALSE ISOBJECT(DicEntries(ix)) THEN DicEntries(ix) = CLASS "cDicEntry" ' If brand new, create the Obj
      DicEntries(IX).DicNext = 0                                  ' Reset it's values
      DicEntries(IX).DicKey = ""                                  '
      DicEntries(IX).DicVal = ""                                  '
      INCR DicCount                                               ' Count it as active
      METHOD = IX                                                 ' Return its Index
   END METHOD                                                     '

   METHOD DicEntFree(IX AS LONG)
   '-----------------------------------------------------------------------------------------------+
   '- Free a DicEntries entry for reuse                                                            +
   '-----------------------------------------------------------------------------------------------+
      DicEntries(IX).DicNext = 0                                  ' First, clear it
      DicEntries(IX).DicKey = ""                                  '
      DicEntries(IX).DicVal = ""                                  '
      MID$(DicFree, IX, 1) = "_"                                  ' Mark it available
      DECR DicCount                                               ' Reduce active count
   END METHOD                                                     '

   METHOD CLEAR()
   '-----------------------------------------------------------------------------------------------+
   '- Clear out all entries                                                                        +
   '-----------------------------------------------------------------------------------------------+
   REGISTER IX AS LONG                                            '
      FOR IX = 1 TO LEN(DicFree)                                  '
         DicEntries(IX) = NOTHING                                 ' Free all DicEntries Objects
      NEXT IX                                                     '
      FOR IX = LBOUND(DicShelves()) TO UBOUND(DicShelves())       ' Clear the shelves
          DicShelves(IX) = 0                                      '
      NEXT                                                        '
      DicFree = REPEAT$(LEN(DicFree), "_")                        ' Mark all slots available
      DicCount = 0:                                               ' Set active count to zero
   END METHOD                                                     '

   METHOD AddRep(key AS STRING, Value AS STRING)
   '-----------------------------------------------------------------------------------------------+
   '- Add/Replace a dictionary entry                                                               +
   '-----------------------------------------------------------------------------------------------+
   LOCAL Shelf, idx, prev AS LONG                                 '
       IF key = "" THEN EXIT METHOD                               ' No Key? Do nothing.
       Shelf = me.DicHash(key)                                    ' Hash the key to get Shelf #
       idx = DicShelves(Shelf)                                    ' Search current Shelf chain
       WHILE idx <> 0                                             '
           IF DicEntries(idx).DicKey = key THEN                   ' If already there
              DicEntries(idx).DicVal = Value                      ' Just swap in a new value
              EXIT METHOD                                         '
           END IF                                                 '
           idx = DicEntries(idx).DicNext                          ' Onward
       WEND                                                       '
       idx = me.DicAlloc()                                        ' Not found, lets create a new entry
       DicEntries(idx).DicKey = key                               ' Fill it in
       DicEntries(idx).DicVal = Value                             '
       DicEntries(idx).DicNext = DicShelves(Shelf)                ' Add to Shelf chain
       DicShelves(Shelf) = idx                                    '
   END METHOD                                                     '

   METHOD Exists(key AS STRING) AS LONG
   '-----------------------------------------------------------------------------------------------+
   '- See if a Key exists                                                                          +
   '-----------------------------------------------------------------------------------------------+
   LOCAL Shelf, idx AS LONG                                       '
       IF key = "" THEN METHOD = 0: EXIT METHOD                   ' If key = "", obviously not found
       Shelf = me.DicHash(key)                                    ' Hash key to get Shelf #
       idx = DicShelves(Shelf)                                    ' Search Shelf chain
       WHILE idx <> 0                                             '
           IF DicEntries(idx).DicKey = key THEN                   ' If found
               METHOD = 1                                         ' Say its found
               EXIT METHOD                                        '
           END IF                                                 '
           idx = DicEntries(idx).DicNext                          ' Onward
       WEND                                                       '
       METHOD = 0                                                 ' Exit not found
   END METHOD                                                     '

   METHOD GetValue(key AS STRING) AS STRING
   '-----------------------------------------------------------------------------------------------+
   '- Fetch the value for a key. Null if not found.                                                +
   '-----------------------------------------------------------------------------------------------+
   LOCAL Shelf, idx AS LONG                                       '
       METHOD = ""                                                ' Default answer
       IF key = "" THEN EXIT METHOD                               ' No Key, null answer
       Shelf = me.DicHash(key)                                    ' Hash key to get Shelf #
       idx = DicShelves(Shelf)                                    ' Search Shelf chain
       WHILE idx <> 0                                             '
           IF DicEntries(idx).DicKey = key THEN                   ' If found
               METHOD = DicEntries(idx).DicVal                    ' Return the value
               EXIT METHOD                                        '
           END IF                                                 '
           idx = DicEntries(idx).DicNext                          ' Onward
       WEND                                                       '
   END METHOD                                                     '

   METHOD GetIXKey(IX AS LONG) AS STRING
   '-----------------------------------------------------------------------------------------------+
   '- Fetch the key for an item by IX number                                                       +
   '-----------------------------------------------------------------------------------------------+
       METHOD = ""                                                ' Default answer
       IF IX < 1 OR IX > LEN(DicFree) THEN EXIT METHOD            ' No IX, null answer
       IF MID$(DicFree, IX, 1) <> "U" THEN EXIT METHOD            ' If unused, null answer
       METHOD = DicEntries(IX).DicKey                             ' Return the key
   END METHOD                                                     '

   METHOD GetIXVal(IX AS LONG) AS STRING
   '-----------------------------------------------------------------------------------------------+
   '- Fetch the value for an item by IX number                                                     +
   '-----------------------------------------------------------------------------------------------+
       METHOD = ""                                                ' Default answer
       IF IX < 1 OR IX > LEN(DicFree) THEN EXIT METHOD            ' No IX, null answer
       IF MID$(DicFree, IX, 1) <> "U" THEN EXIT METHOD            ' If unused, null answer
       METHOD = DicEntries(ix).DicVal                             ' Return the key
   END METHOD                                                     '

   METHOD Remove(key AS STRING) AS LONG
   '-----------------------------------------------------------------------------------------------+
   '- Remove a Key/Value pair                                                                      +
   '-----------------------------------------------------------------------------------------------+
   LOCAL h AS DWORD, Shelf AS LONG, idx AS LONG, prev AS LONG     '
      METHOD = %False                                             ' Default to failure
      IF key = "" THEN EXIT METHOD                                ' No key - we're done
      Shelf = me.DicHash(key)                                     ' Hask key to get Shelf #
      idx = DicShelves(Shelf)                                     ' Search Shelf chain
      prev = 0                                                    ' Remember a previous entry
      WHILE idx <> 0                                              '
          IF DicEntries(idx).DicKey = key THEN                    ' Found it?
             IF prev = 0 THEN                                     ' No previous DicEntries item?
                DicShelves(Shelf) = DicEntries(idx).DicNext       ' Then swap the Shelf head
             ELSE                                                 ' Else
                DicEntries(prev).DicNext = DicEntries(idx).DicNext' Swap the DicEntries own Next pointer
             END IF                                               '
             me.DicEntFree(idx)                                   ' Now Free the entry
             METHOD = %True                                       ' Success
             EXIT METHOD                                          ' And exit
          END IF                                                  '
          prev = idx                                              ' Save Prev entry
          idx = DicEntries(idx).DicNext                           ' Onward
      WEND                                                        '
   END METHOD                                                     '

   METHOD COUNT() AS LONG
   '-----------------------------------------------------------------------------------------------+
   '- Return the total # of entries                                                                +
   '-----------------------------------------------------------------------------------------------+
      METHOD = DicCount
   END METHOD

   END INTERFACE                                                  '
END CLASS                                                         '
