'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjFMD.inc                                                                                      |
'--------------------------------------------------------------------------------------------------+
                                                                  '

CLASS cFMData                                                     '
   INSTANCE FD            AS DIRDATA                              '
   INSTANCE SizeInt       AS QUAD                                 ' Size in integer
   INSTANCE Flag          AS LONG                                 ' Flag byte
   INSTANCE CmdOff        AS LONG                                 ' Command offset
   INSTANCE Uniq          AS LONG                                 ' Uniq
   INSTANCE RQIX          AS LONG                                 ' RQ Index
   INSTANCE LinesInt      AS LONG                                 ' Lines in integer
   INSTANCE PSeq          AS LONG                                 ' Physical sequence
   INSTANCE Sorted        AS LONG                                 ' Sort sequence
   INSTANCE OMode         AS STRING                               ' Open Mode (for Recent FileList
   INSTANCE Exten         AS STRING                               ' Extension
   INSTANCE Message       AS STRING                               ' Message
   INSTANCE LWTime        AS STRING                               ' Last Write time in display format
   INSTANCE CRTime        AS STRING                               ' Creation time in display format
   INSTANCE LRTime        AS STRING                               ' Last Ref. time in display format
   INSTANCE DPath         AS STRING                               ' Path
   INSTANCE Cmd           AS STRING                               ' Command string
   INSTANCE CmdRoot       AS STRING                               ' Command root (Basic command)
   INSTANCE CmdCount      AS LONG                                 ' Command Numeric suffix
   INSTANCE CmdFlag       AS STRING                               ' Command Flag (/ \ etc.)
   INSTANCE CmdIX         AS LONG                                 ' IX of line command table
   INSTANCE CmdOper       AS STRING                               ' Optional Operand
   INSTANCE Prp1          AS STRING                               ' Property 1
   INSTANCE Prp2          AS STRING                               ' Property 2
   INSTANCE Prp3          AS STRING                               ' Property 3
   INSTANCE Prp4          AS STRING                               ' Property 4
   INSTANCE Prp5          AS STRING                               ' Property 5
   INSTANCE Prp6          AS STRING                               ' Property 6

   INTERFACE iFMData: INHERIT IUNKNOWN                            '
      gsProp(FD, DIRDATA)                                         '
      gsProp(SizeInt, QUAD)                                       '
      gsProp(Flag, LONG)                                          '
      gsProp(CmdOff, LONG)                                        '
      gsProp(Uniq, LONG)                                          '
      gsProp(RQIX, LONG)                                          '
      gsProp(LinesInt, LONG)                                      '
      gsProp(PSeq, LONG)                                          '
      gsProp(Sorted, LONG)                                        '
      gsProp(OMode,STRING)                                        '
      gsProp(Exten,STRING)                                        '
      gsProp(Message,STRING)                                      '
      gsProp(LWTime,STRING)                                       '
      gsProp(CRTime,STRING)                                       '
      gsProp(LRTime,STRING)                                       '
      gsProp(DPath,STRING)                                        '
      gsProp(Cmd,STRING)                                          '
      gsProp(CmdRoot,STRING)                                      '
      gsProp(CmdCount,LONG)                                       '
      gsProp(CmdIX,LONG)                                          '
      gsProp(CmdOper,STRING)                                      '
      gsProp(CmdFlag,STRING)                                      '
      gsProp(Prp1,STRING)                                         '
      gsProp(Prp2,STRING)                                         '
      gsProp(Prp3,STRING)                                         '
      gsProp(Prp4,STRING)                                         '
      gsProp(Prp5,STRING)                                         '
      gsProp(Prp6,STRING)                                         '
      PROPERTY GET FileSizeLow  AS DWORD: PROPERTY = FD.FileSizeLow:  END PROPERTY  '
      PROPERTY SET FileSizeLow(v AS DWORD):  FD.FileSizeLow = v:  END PROPERTY   '
      PROPERTY GET FileSizeHigh AS DWORD: PROPERTY = FD.FileSizeHigh: END PROPERTY  '
      PROPERTY SET FileSizeHigh(v AS DWORD): FD.FileSizeHigh = v: END PROPERTY   '
      PROPERTY GET FileName AS STRING: PROPERTY = FD.FileName: END PROPERTY   '
      PROPERTY SET FileName(v AS STRING): FD.FileName = v: END PROPERTY '
      PROPERTY GET ShortName AS STRING: PROPERTY = FD.ShortName: END PROPERTY '
      PROPERTY SET ShortName(v AS STRING): FD.ShortName = v: END PROPERTY  '
      PROPERTY GET LastWriteTime AS QUAD: PROPERTY = FD.LastWriteTime: END PROPERTY '
      PROPERTY SET LastWriteTime(v AS QUAD): FD.LastWriteTime = v: END PROPERTY  '
      PROPERTY GET LastAccessTime AS QUAD: PROPERTY = FD.LastAccessTime: END PROPERTY  '
      PROPERTY SET LastAccessTime(v AS QUAD): FD.LastAccessTime = v: END PROPERTY   '
      PROPERTY GET CreationTime AS QUAD: PROPERTY = FD.CreationTime: END PROPERTY   '
      PROPERTY SET CreationTime(v AS QUAD): FD.CreationTime = v: END PROPERTY '
      PROPERTY GET FileAttributes AS DWORD: PROPERTY = FD.FileAttributes: END PROPERTY '
      PROPERTY SET FileAttributes(v AS DWORD): FD.FileAttributes = v: END PROPERTY  '

      PROPERTY GET FullPath() AS STRING                           '
         PROPERTY = IIF$(DPath = FD.FileName, DPath, DPath + TRIM$(FD.FileName)) '
      END PROPERTY                                                '

      METHOD CmdR1(cPos AS LONG, cChr AS STRING): MID$(Cmd, cPos, 1) = cChr: END METHOD   '
      METHOD CmdI1(cPos AS LONG, cChr AS STRING): Cmd = STRINSERT$(Cmd, cChr, cPos): END METHOD '

      METHOD PrtCmd() AS STRING                                   '
      LOCAL FillStr AS STRING                                     '
         IF Flag = %FTotal THEN                                   ' Total Line
            METHOD = REPEAT$(gENV.FMLCmdWidth + 1, " ")           ' Just return blanks
         ELSE                                                     ' Else
            IF TRIM$(Cmd) <> "" THEN                              ' Something in command?
               METHOD = LSET$(MID$(Cmd, CmdOff + 1), gENV.FMLCmdWidth)  '
            ELSE                                                  '
               FillStr = REPEAT$(gENV.FMLCmdWidth, IIF$((FD.FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY, ".","_")) + " "  '
               METHOD = FillStr                                   '
            END IF                                                '
         END IF                                                   '
      END METHOD                                                  '

      METHOD PrtField(BYVAL sField AS STRING, sAttr AS WSTRING, sCol AS LONG) AS STRING   '
      '--------------------------------------------------------------------------------------------+
      '- Retrieve one field for printing                                                           |
      '--------------------------------------------------------------------------------------------+
      LOCAL tText1 AS STRING, i AS LONG                           '
         SELECT CASE AS CONST$ sField                             '
            CASE "CMD"                                            '
               IF Flag = %FTotal THEN                             ' Total Line
                  sAttr = $$TxtHi: METHOD = REPEAT$(gENV.FMLCmdWidth + 1, " ")   ' Just return blanks
               ELSE                                               ' Else
                  IF TRIM$(Cmd) <> "" THEN                        ' Something in command?
                     sAttr = $$TxtHi: METHOD = LSET$(MID$(Cmd, CmdOff + 1), gENV.FMLCmdWidth + 1)  '
                  ELSE                                            '
                     sAttr = $$TxtLo: METHOD = REPEAT$(gENV.FMLCmdWidth, IIF$((FD.FileAttributes AND %FILE_ATTRIBUTE_READONLY) = %FILE_ATTRIBUTE_READONLY, ".","_")) + " " '
                  END IF                                          '
               END IF                                             '

            CASE "NAME"                                           '
               IF TP.FMode = %FMFilePath OR TP.FMode = %FMFLISTS OR TP.FMode = %FMConfigs OR TP.FileListNm <> ""  THEN  ' FLIST just gets filename too
                  tText1 = TRIM$(FD.FileName)                     ' Build just filename
               ELSE                                               '
                  tText1 = me.FullPath                            ' Build full path\filename
               END IF                                             '
               IF Flag = %FDirUp THEN tText1 = "..\"              ' Correct DirUp
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = tText1                                    ' Pass it back

            CASE "PATH"                                           '
               tText1 = TRIM$(DPath)                              ' Build just path
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = tText1                                    ' Pass it back

            CASE "SIZESHORT"                                      '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = SizeSmall(SizeInt)                        '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "SIZELONG"                                       '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = SizeLarge(SizeInt)                        '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "LINES"                                          '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = FORMAT$(LinesInt, "* #,###,###")          '
               IF LinesInt = -1 THEN METHOD = ""                  '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "LWDATETIME"                                     '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = LSET$(LWTime, 17)                         ' Get correct length text item
               IF gENV.FMDateHilite THEN                          ' Do the Date hilite version?
                  IF LWTime >= gDateActive THEN                   '
                     sAttr = $$Red                                '
                  ELSEIF LWTime > gDateActive1 THEN               '
                     sAttr = $$Yellow                             '
                  ELSEIF LWTime > gDateActive8 THEN               '
                     sAttr = $$Green                              '
                  ELSEIF LWTime > gDateActive24 AND LWTime > gDateActive48 THEN  '
                     sAttr = $$Blue                               '
                  END IF                                          '
               END IF                                             '

            CASE "LRDATETIME"                                     '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = LSET$(LRTime, 17)                         ' Get correct length text item

            CASE "LWDATE"                                         '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = LSET$(LWTime, 10)                         ' Get correct length text item
               IF gENV.FMDateHilite THEN                          ' Do the Date hilite version?
                  IF LWTime >= gDateActive THEN                   '
                     sAttr = $$Red                                '
                  ELSEIF LWTime > gDateActive1 THEN               '
                     sAttr = $$Yellow                             '
                  ELSEIF LWTime > gDateActive8 THEN               '
                     sAttr = $$Green                              '
                  ELSEIF LWTime > gDateActive24 AND LWTime > gDateActive48 THEN  '
                     sAttr = $$Blue                               '
                  END IF                                          '
               END IF                                             '

            CASE "LRDATE"                                         '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = LSET$(LRTime, 10)                         ' Get correct length text item

            CASE "CRDATETIME"                                     '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = LSET$(CRTime, 17)                         ' Get correct length text item

            CASE "CRDATE"                                         '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = LSET$(CRTime, 10)                         ' Get correct length text item

            CASE "ATTR"                                           '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               FOR i = 1 TO 15                                    ' Loop through the Attr table
                  IF (gAttrTable(i).AttrMask AND FD.FileAttributes) = gAttrTable(i).AttrMask THEN  '
                     tText1 += gAttrTable(i).AttrChar             ' If bit set, add the AttrChar
                  END IF                                          '
               NEXT i                                             '
               METHOD = tText1                                    ' Pass Back the answer

            CASE "MODE"                                           '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute
               METHOD = OMode                                     ' Pass Back the answer

            CASE "PRP1"                                           '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = Prp1                                      '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "PRP2"                                           '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = Prp2                                      '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "PRP3"                                           '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = Prp3                                      '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "PRP4"                                           '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = Prp4                                      '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "PRP5"                                           '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = Prp5                                      '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

            CASE "PRP6"                                           '
               METHOD = ""                                        ' Default to null
               sAttr = $$TxtLo                                    ' Ensure Attr is set
               IF Flag = %FDirDown OR Flag = %FDirUp THEN EXIT METHOD   ' Exit with blanks for Directories
               METHOD = Prp6                                      '
               IF sCol = TP.DefSortCol THEN sAttr = $$TxtHi ELSE sAttr = $$TxtLo ' Set attribute

         END SELECT                                               '

      END METHOD                                                  '

      METHOD TYPE(f1 AS LONG, OPT f2 AS LONG, OPT f3 AS LONG, OPT f4 AS LONG) AS LONG  '
      '--------------------------------------------------------------------------------------------+
      '- Return %True if Flag = any of the passed flags                                            |
      '--------------------------------------------------------------------------------------------+
          IF Flag = f1 THEN METHOD = %True: EXIT METHOD           '
          IF ISMISSING(f2) THEN EXIT METHOD                       '
          IF Flag = f2 THEN METHOD = %True: EXIT METHOD           '
          IF ISMISSING(f3) THEN EXIT METHOD                       '
          IF Flag = f3 THEN METHOD = %True: EXIT METHOD           '
          IF ISMISSING(f4) THEN EXIT METHOD                       '
          IF Flag = f4 THEN METHOD = %True: EXIT METHOD           '
      END METHOD                                                  '
   END INTERFACE                                                  '
END CLASS                                                         '

CLASS cFMColumn                                                   '
   INSTANCE CSize         AS LONG                                 ' Default size
   INSTANCE CPos          AS LONG                                 ' Horizontal position
   INSTANCE CField        AS STRING                               ' Name of field to be printed (internal name)
   INSTANCE CHead         AS STRING                               ' Column header
   INSTANCE CAlign        AS STRING                               ' Alignment (L/R)
   INSTANCE CProperty     AS STRING                               ' External Property Name
   INSTANCE CGUID         AS STRING                               ' Internal Property ID

   INTERFACE iFMColumn: INHERIT IUNKNOWN                          '
   gsProp(CSize,          LONG)                                   ' Default size
   gsProp(CPos,           LONG)                                   ' Horizontal position
   gsProp(CField,         STRING)                                 ' Name of field (internal name)
   gsProp(CHead,          STRING)                                 ' Column header
   gsProp(CAlign,         STRING)                                 ' Alignment (L/R)
   gsProp(CProperty,      STRING)                                 ' External Property Name
   gsProp(CGUID,          STRING)                                 ' Internal Property ID

   METHOD GetPropName(sColName AS STRING) AS STRING               '
   '-----------------------------------------------------------------------------------------------+
   '- If PRPn is in use, return Property name                                                      |
   '-----------------------------------------------------------------------------------------------+
   REGISTER i AS LONG                                             '
      FOR i = 1 TO gFMCCtr                                        ' See if PRPx is active
         IF sColName = gFMC(i).CField THEN                        ' We got it!
            METHOD = gFMC(i).CProperty                            ' Pass back Property name
            EXIT METHOD                                           ' We're done
         END IF                                                   '
      NEXT i                                                      '
   END METHOD                                                     '

   END INTERFACE                                                  '
END CLASS                                                         '
