'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- ObjPCmdT.inc                                                                                    |
'--------------------------------------------------------------------------------------------------+
                                                                  '
CLASS cPCmdTable                                                  '

   '-----------------------------------------------------------------------------------------------+
   '- Primary Command Table Data                                                                   |
   '-----------------------------------------------------------------------------------------------+
   INSTANCE CmdNumber    AS LONG                                  ' Number of Primary commands
   INSTANCE CodeNumber   AS LONG                                  ' Number of Primary routines
   INSTANCE PCmdTable()   AS CmdTable                             ' Primary Command Table
   INSTANCE PCodeTable()  AS DWORD                                ' Code table (Temporary)

   CLASS METHOD CREATE()                                          ' Constructor - Initialize Class stuff
   LOCAL i AS LONG                                                '
      CmdNumber = 219                                             ' Set current number of primary commands
      CodeNumber = 162                                            ' Set current number of command routines
      DIM PCmdTable(1 TO CmdNumber) AS INSTANCE CmdTable          ' Dim the Primary command table
      DIM PCodeTable(1 TO CodeNumber) AS DWORD                    ' Dim the Primary code table

      '--------------------------------------------------------------------------------------------+
      '- Add the CodePtr values (CODEPTR cannot exist in DATA statements                           |
      '--------------------------------------------------------------------------------------------+
      PCodeTable(001) = CODEPTR(PCmdBounds)                       '
      PCodeTable(002) = CODEPTR(PCmdBrowse)                       '
      PCodeTable(003) = CODEPTR(PCmdCancel)                       '
      PCodeTable(004) = CODEPTR(PCmdCaps)                         '
      PCodeTable(005) = CODEPTR(PCmdChange)                       '
      PCodeTable(006) = CODEPTR(PCmdClip)                         '
      PCodeTable(007) = CODEPTR(PCmdCopy)                         '
      PCodeTable(008) = CODEPTR(PCmdCreate)                       '
      PCodeTable(009) = CODEPTR(PCmdDCB)                          '
      PCodeTable(010) = CODEPTR(PCmdCut)                          '
      PCodeTable(011) = CODEPTR(PCmdDelete)                       '
      PCodeTable(012) = CODEPTR(PCmdDown)                         '
      PCodeTable(013) = CODEPTR(PCmdEdit)                         '
      PCodeTable(014) = CODEPTR(PCmdSource)                       '
      PCodeTable(015) = CODEPTR(PCmdEnd)                          '
      PCodeTable(016) = CODEPTR(PCmdExit)                         '
      PCodeTable(017) = CODEPTR(PCmdExclude)                      '
      PCodeTable(018) = CODEPTR(PCmdFind)                         '
      PCodeTable(019) = CODEPTR(PCmdFlip)                         '
      PCodeTable(020) = CODEPTR(PCmdHelp)                         '
      PCodeTable(021) = CODEPTR(PCmdHex)                          '
      PCodeTable(022) = CODEPTR(PCmdHide)                         '
      PCodeTable(023) = CODEPTR(PCmdKeyMap)                       '
      PCodeTable(024) = CODEPTR(PCmdLeft)                         '
      PCodeTable(025) = CODEPTR(PCmdLocate)                       '
      PCodeTable(026) = CODEPTR(PCmdMacro)                        '
      PCodeTable(027) = CODEPTR(FMpCmdCSV)                        '
      PCodeTable(028) = CODEPTR(PCmdOpen)                         '
      PCodeTable(029) = CODEPTR(PCmdPaste)                        '
      PCodeTable(030) = CODEPTR(PCmdComments)                     '
      PCodeTable(031) = CODEPTR(PCmdPrint)                        '
      PCodeTable(032) = CODEPTR(PCmdOptions)                      '
      PCodeTable(033) = CODEPTR(PCmdReplace)                      '
      PCodeTable(034) = CODEPTR(PCmdReset)                        '
      PCodeTable(035) = CODEPTR(PCmdRetrieve)                     '
      PCodeTable(036) = CODEPTR(PCmdRight)                        '
      PCodeTable(037) = CODEPTR(PCmdRChange)                      '
      PCodeTable(038) = CODEPTR(PCmdRFind)                        '
      PCodeTable(039) = CODEPTR(PCmdCmd)                          '
      PCodeTable(040) = CODEPTR(PCmdSave)                         '
      PCodeTable(041) = CODEPTR(PCmdSaveAs)                       '
      PCodeTable(042) = CODEPTR(PCmdScroll)                       '
      PCodeTable(043) = CODEPTR(PCmdSort)                         '
      PCodeTable(044) = CODEPTR(PCmdSwap)                         '
      PCodeTable(045) = CODEPTR(PCmdTabs)                         '
      PCodeTable(046) = CODEPTR(PCmdUndo)                         '
      PCodeTable(047) = CODEPTR(PCmdTop)                          '
      PCodeTable(048) = CODEPTR(PCmdUp)                           '
      PCodeTable(049) = CODEPTR(PCmdProfile)                      '
      PCodeTable(050) = CODEPTR(pCmdAUTOBKUP)                     '
      PCodeTable(051) = CODEPTR(PCmdAUTOSAVE)                     '
      PCodeTable(052) = CODEPTR(PCmdXTABS)                        '
      PCodeTable(053) = CODEPTR(PCmdCOLS)                         '
      PCodeTable(054) = CODEPTR(pCmdPRESERVE)                     '
      PCodeTable(055) = CODEPTR(pCmdLABEL)                        '
      PCodeTable(056) = CODEPTR(PCmdHILITE)                       '
      PCodeTable(057) = CODEPTR(PcmdState)                        '
      PCodeTable(058) = CODEPTR(PCmdEOL)                          '
      PCodeTable(059) = CODEPTR(PCmdTag)                          '
      PCodeTable(060) = CODEPTR(PCmdNFIND)                        '
      PCodeTable(061) = CODEPTR(pCmdNExclude)                     '
      PCodeTable(062) = CODEPTR(PCmdLRECL)                        '
      PCodeTable(063) = CODEPTR(PCmdCASE)                         '
      PCodeTable(064) = CODEPTR(PCmdLCUC)                         '
      PCodeTable(065) = CODEPTR(pCmdRLoc)                         '
      PCodeTable(066) = CODEPTR(pCmdRLocFind)                     '
      PCodeTable(067) = CODEPTR(pCmdSHOW)                         '
      PCodeTable(068) = CODEPTR(PCmdNSHow)                        '
      PCodeTable(069) = CODEPTR(PCmdRECFM)                        '
      PCodeTable(070) = CODEPTR(pCmdRECALL)                       '
      PCodeTable(071) = CODEPTR(pCmdFav)                          '
      PCodeTable(072) = CODEPTR(PCmdEnd)                          '
      PCodeTable(073) = CODEPTR(pCmdSet)                          '
      PCodeTable(074) = CODEPTR(pCmdNFLIP)                        '
      PCodeTable(075) = CODEPTR(pCmdSubmit)                       '
      PCodeTable(076) = CODEPTR(PCmdSubArg)                       '
      PCodeTable(077) = CODEPTR(pCmdReLoad)                       '
      PCodeTable(078) = CODEPTR(pCmdRename)                       '
      PCodeTable(079) = CODEPTR(pCmdNDelete)                      '
      PCodeTable(080) = CODEPTR(PCmdRedo)                         '
      PCodeTable(081) = CODEPTR(pCmdCompress)                     '
      PCodeTable(082) = CODEPTR(pCmdRetFwd)                       '
      PCodeTable(083) = CODEPTR(pCmdDO)                           '
      PCodeTable(084) = CODEPTR(PCmdPType)                        '
      PCodeTable(085) = CODEPTR(FMpCmdFF)                         '
      PCodeTable(086) = CODEPTR(pCmdMEdit)                        '
      PCodeTable(087) = CODEPTR(pCmdGlueWith)                     '
      PCodeTable(088) = CODEPTR(pCmdIMACRO)                       '
      PCodeTable(089) = CODEPTR(pCmdStart)                        '
      PCodeTable(090) = CODEPTR(pCmdSaveAll)                      '
      PCodeTable(091) = CODEPTR(pCmdClone)                        '
      PCodeTable(092) = CODEPTR(PCmdAppend)                       '
      PCodeTable(093) = CODEPTR(pCmdPrepend)                      '
      PCodeTable(094) = CODEPTR(pCmdEnumWith)                     '
      PCodeTable(095) = CODEPTR(FMPCmdBottom)                     '
      PCodeTable(096) = CODEPTR(FMpCmdBrowse)                     '
      PCodeTable(097) = CODEPTR(FMPCmdExclude)                    '
      PCodeTable(098) = CODEPTR(FMPCmdEnd)                        '
      PCodeTable(099) = CODEPTR(PCmdMakeList)                     '
      PCodeTable(100) = CODEPTR(FMpCmdDown)                       '
      PCodeTable(101) = CODEPTR(FMPCmdEdit)                       '
      PCodeTable(102) = CODEPTR(FMPCmdFind)                       '
      PCodeTable(103) = CODEPTR(FMPCmdLocate)                     '
      PCodeTable(104) = CODEPTR(FMPCmdRecall)                     '
      PCodeTable(105) = CODEPTR(FMPCmdTop)                        '
      PCodeTable(106) = CODEPTR(FMPCmdUp)                         '
      PCodeTable(107) = CODEPTR(PCmdBottom)                       '
      PCodeTable(108) = CODEPTR(PCmdSpell)                        '
      PCodeTable(109) = CODEPTR(pCmdMark)                         '
      PCodeTable(110) = CODEPTR(FMPCmdRFind)                      '
      PCodeTable(111) = CODEPTR(pCmdSplit)                        '
      PCodeTable(112) = CODEPTR(pCmdJoin)                         '
      PCodeTable(113) = CODEPTR(pCmdIEdit)                        '
      PCodeTable(114) = CODEPTR(pCmdInclude)                      '
      PCodeTable(115) = CODEPTR(FMPCmdReset)                      '
      PCodeTable(116) = CODEPTR(pCmdPlease)                       '
      PCodeTable(117) = CODEPTR(pCmdNotify)                       '
      PCodeTable(118) = CODEPTR(pCmdLine)                         '
      PCodeTable(119) = CODEPTR(FMPCmdView)                       '
      PCodeTable(120) = CODEPTR(pCmdMINLEN)                       '
      PCodeTable(121) = CODEPTR(pCmdDIR)                          '
      PCodeTable(122) = CODEPTR(pCmdPAGE)                         '
      PCodeTable(123) = CODEPTR(pCmdRUN)                          '
      PCodeTable(124) = CODEPTR(pCmdSubInclude)                   '
      PCodeTable(125) = CODEPTR(pCmdCOLLATE)                      '
      PCodeTable(126) = CODEPTR(pCmdView)                         '
      PCodeTable(127) = CODEPTR(pCmdXSUBMIT)                      '
      PCodeTable(128) = CODEPTR(pCmdWDIR)                         '
      PCodeTable(129) = CODEPTR(pCmdSUBCMD)                       '
      PCodeTable(130) = CODEPTR(pCmdADD)                          '
      PCodeTable(131) = CODEPTR(pCmdULine)                        '
      PCodeTable(132) = CODEPTR(pCmdNULine)                       '
      PCodeTable(133) = CODEPTR(pCmdRevert)                       '
      PCodeTable(134) = CODEPTR(pCmdNRevert)                      '
      PCodeTable(135) = CODEPTR(pCmdAutoName)                     '
      PCodeTable(136) = CODEPTR(pCmdEMacro)                       '
      PCodeTable(137) = CODEPTR(pCmdALIGN)                        '
      PCodeTable(138) = CODEPTR(pCmdAUTOCAPS)                     '
      PCodeTable(139) = CODEPTR(pCmdACTION)                       '
      PCodeTable(140) = CODEPTR(FMPCmdAll)                        '
      PCodeTable(141) = CODEPTR(pCmdTest)                         '
      PCodeTable(142) = CODEPTR(FMPCmdFC)                         '
      PCodeTable(143) = 0                                         '
      PCodeTable(144) = 0                                         '
      PCodeTable(145) = 0                                         '
      PCodeTable(146) = 0                                         '
      PCodeTable(147) = CODEPTR(pCmdBackup)                       '
      PCodeTable(148) = CODEPTR(pCmdCLS)                          '
      PCodeTable(149) = CODEPTR(pCmdBOM)                          '
      PCodeTable(150) = CODEPTR(pCmdXForm)                        '
      PCodeTable(151) = CODEPTR(pCmdDiff)                         '
      PCodeTable(152) = CODEPTR(FMPCmdLeft)                       '
      PCodeTable(153) = CODEPTR(FMPCmdRight)                      '
      PCodeTable(154) = CODEPTR(FMPCmdCut)                        '
      PCodeTable(155) = CODEPTR(FMPCmdCD)                         '
      PCodeTable(156) = CODEPTR(FMPCmdMD)                         '
      PCodeTable(157) = CODEPTR(pCmdEFT)                          '
      PCodeTable(158) = CODEPTR(pCmdMode)                         '
      PCodeTable(159) = CODEPTR(pCmdMaclib)                       '
      PCodeTable(160) = CODEPTR(pCmdInstance)                     '
      PCodeTable(161) = CODEPTR(pCmdLoopCheck)                    '
      PCodeTable(162) = CODEPTR(pCmdTabBNDS)                      '

      '--------------------------------------------------------------------------------------------+
      '- Now do the rest of the fields                                                             |
      '--------------------------------------------------------------------------------------------+

      '--------------------------------------------------------------------------------------------+
      '-                                                                                           |
      '-     Primary command data                                                                  |
      '-     Fields are:                                                                           |
      '-       Command name                                                                        |
      '-       Editor Index into pCodetable                                                        |
      '-       Are Line operands allowed                                                           |
      '-       Is Scrolling allowed                                                                |
      '-       FM Index into PCodeTable                                                            |
      '-       Allowed in MACRO Call                                                               |
      '-       Create Track Point Entry                                                            |
      '-       Valid in Browse Mode                                                                |
      '-       EFT Override eligible                                                               |
      '--------------------------------------------------------------------------------------------+
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "=X",          16,   N,  0,   16,     N,     N,    Y,   N '
      DATA "ACTION",     139,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "ADD",        130,   S,  0,    0,     Y,     N,    N,   N '
      DATA "ALL",          0,   N,  0,  140,     N,     N,    N,   N '
      DATA "ALIGN",      137,   S,  0,    0,     Y,     N,    N,   N '
      DATA "APPEND",      92,   S,  0,    0,     Y,     N,    N,   N '
      DATA "AUTOBKUP",    50,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "AUTOCAPS",   138,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "AUTONAME",   135,   N,  0,    0,     N,     N,    Y,   Y '
      DATA "AUTOSAVE",    51,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "B",            2,   N,  0,   96,     N,     N,    Y,   N '
      DATA "BACKUP",     147,   N,  0,    0,     N,     N,    Y,   N '
      DATA "BACK",       147,   N,  0,    0,     N,     N,    Y,   N '
      DATA "BK",         147,   N,  0,    0,     N,     N,    Y,   N '
      DATA "BND",          1,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "BNDS",         1,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "BOM",        149,   N,  0,    0,     N,     N,    N,   Y '
      DATA "BOT",        107,   N,  1,   95,     Y,     N,    Y,   N '
      DATA "BOTTOM",     107,   N,  1,   95,     Y,     N,    Y,   N '
      DATA "BOU",          1,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "BOUND",        1,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "BOUNDS",       1,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "BR",           2,   N,  0,   96,     N,     N,    Y,   N '
      DATA "BRO",          2,   N,  0,   96,     N,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "BROWSE",       2,   N,  0,   96,     N,     N,    Y,   N '
      DATA "C",            5,   S,  0,    0,     Y,     N,    N,   N '
      DATA "CAN",          3,   N,  0,    0,     N,     N,    Y,   N '
      DATA "CANCEL",       3,   N,  0,    0,     N,     N,    Y,   N '
      DATA "CAPS",         4,   N,  0,    0,     Y,     N,    N,   Y '
      DATA "CASE",        63,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "CD",           0,   N,  0,   155,    N,     N,    N,   N '
      DATA "CHA",          5,   S,  0,    0,     Y,     Y,    N,   Y '
      DATA "CHANGE",       5,   S,  0,    0,     Y,     Y,    N,   Y '
      DATA "CHG",          5,   S,  0,    0,     Y,     Y,    N,   Y '
      DATA "CLIP",         6,   N,  0,    6,     N,     N,    Y,   N '
      DATA "CLONE",       91,   N,  0,   91,     N,     N,    Y,   N '
      DATA "CLS",        148,   N,  0,  148,     Y,     N,    Y,   N '
      DATA "CMD",         39,   N,  0,   39,     Y,     N,    Y,   N '
      DATA "COL",         53,   N,  0,    0,     N,     N,    Y,   Y '
      DATA "COLS",        53,   N,  0,    0,     N,     N,    Y,   Y '
      DATA "COLLATE",    125,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "COMMENT",     30,   N,  0,    0,     Y,     N,    N,   Y '
      DATA "COMMENTS",    30,   N,  0,    0,     Y,     N,    N,   Y '
      DATA "COMPRESS",    81,   S,  0,    0,     Y,     N,    N,   N '
      DATA "CP",          81,   S,  0,    0,     Y,     N,    N,   N '
      DATA "COPY",         7,   D,  0,    0,     Y,     N,    N,   N '
      DATA "CRE",          8,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "CREATE",       8,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "CRETRIEV",    35,   N,  1,   35,     N,     N,    Y,   N '
      DATA "CSV",          0,   N,  0,   27,     N,     N,    N,   N '
      DATA "CUT",         10,   S,  0,  154,     Y,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "DCB",          9,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "DEF",          0,   N,  0,  135,     N,     N,    N,   N '
      DATA "DEL",         11,   S,  0,    0,     Y,     N,    N,   N '
      DATA "DELETE",      11,   S,  0,    0,     Y,     N,    N,   N '
      DATA "DIFF",       151,   N,  0,  151,     N,     N,    Y,   N '
      DATA "DO",          83,   S,  0,   83,     Y,     N,    Y,   N '
      DATA "DOWN",        12,   N,  1,  100,     N,     N,    Y,   N '
      DATA "DIR",        121,   N,  0,  121,     N,     N,    Y,   N '
      DATA "E",           13,   N,  0,  101,     N,     N,    Y,   N '
      DATA "ED",          13,   N,  0,  101,     N,     N,    Y,   N '
      DATA "EDIT",        13,   N,  0,  101,     N,     N,    Y,   N '
      DATA "END",         15,   N,  0,   98,     N,     N,    Y,   N '
      DATA "EFT",        157,   N,  0,  157,     N,     N,    Y,   N '
      DATA "EMACRO",     136,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "ENUMWITH",    94,   N,  0,    0,     Y,     N,    N,   N '
      DATA "EOL",         58,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "EX",          17,   S,  0,   97,     Y,     N,    Y,   N '
      DATA "EXC",         17,   S,  0,   97,     Y,     N,    Y,   N '
      DATA "EXCLUDE",     17,   S,  0,   97,     Y,     N,    Y,   N '
      DATA "EXCLUDED",    17,   S,  0,   97,     Y,     N,    Y,   N '
      DATA "EXIT",        16,   N,  0,   16,     N,     N,    Y,   N '
      DATA "F",           18,   S,  1,  102,     Y,     Y,    Y,   N '
      DATA "FAV",         71,   N,  0,    0,     Y,     N,    Y,   N '
      DATA "FAVORITE",    71,   N,  0,    0,     Y,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "FAVOURITE",   71,   N,  0,    0,     Y,     N,    Y,   N '
      DATA "FC",           0,   S,  0,  142,     N,     Y,    N,   N '
      DATA "FCHANGE",      0,   S,  0,  142,     N,     Y,    N,   N '
      DATA "FF",          18,   Y,  1,   85,     N,     Y,    Y,   N '
      DATA "FFIND",       18,   Y,  1,   85,     N,     Y,    Y,   N '
      DATA "FIND",        18,   Y,  1,  102,     Y,     Y,    Y,   N '
      DATA "FLIP",        19,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "GLUEWITH",    87,   N,  0,    0,     Y,     N,    N,   N '
      DATA "H",           20,   N,  0,   20,     N,     N,    Y,   N '
      DATA "HELP",        20,   N,  0,   20,     Y,     N,    Y,   N '
      DATA "HEX",         21,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "HI",          56,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "HIDE",        22,   N,  0,    0,     Y,     N,    Y,   N '
      DATA "HILIGHT",     56,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "HILITE",      56,   N,  0,    0,     Y,     N,    Y,   N '
      DATA "IMACRO",      88,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "IEDIT",      113,   N,  0,  113,     N,     N,    Y,   N '
      DATA "INCLUDE",    114,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "INSTANCE",   160,   N,  0,  160,     Y,     N,    N,   N '
      DATA "INST",       160,   N,  0,  160,     Y,     N,    N,   N '
      DATA "ISCROLL",     42,   N,  1,   42,     N,     N,    Y,   N '
      DATA "JOIN",       112,   S,  0,    0,     Y,     N,    N,   N '
      DATA "KEY",         23,   N,  0,   23,     N,     N,    Y,   N '
      DATA "KBD",         23,   N,  0,   23,     N,     N,    Y,   N '
      DATA "KEYMAP",      23,   N,  0,   23,     N,     N,    Y,   N '
      DATA "KEYS",        23,   N,  0,   23,     N,     N,    Y,   N '
      DATA "L",           25,   N,  1,  103,     Y,     Y,    Y,   N '
      DATA "LABEL",       55,   N,  0,    0,     Y,     Y,    Y,   N '
      DATA "LBL",         55,   N,  0,    0,     Y,     Y,    Y,   N '
      DATA "LAB",         55,   N,  0,    0,     Y,     Y,    Y,   N '
      DATA "LC",          64,   S,  0,    0,     Y,     Y,    N,   N '
      DATA "LEFT",        24,   N,  1,  152,     N,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "LINE",       118,   N,  1,    0,     Y,     N,    N,   N '
      DATA "LOC",         25,   N,  1,  103,     Y,     N,    Y,   N '
      DATA "LOCATE",      25,   N,  1,  103,     Y,     Y,    Y,   N '
      DATA "LOOPCHECK",  161,   N,  0,  161,     N,     N,    Y,   Y '
      DATA "LRECL",       62,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "MAC",         26,   N,  0,    0,     N,     N,    N,   N '
      DATA "MACLIB",     159,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "MACRO",       26,   N,  0,    0,     N,     N,    N,   N '
      DATA "MAKELIST",    99,   N,  0,   99,     N,     N,    N,   N '
      DATA "MARK",       109,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "MD",           0,   N,  0,  156,     N,     N,    N,   N '
      DATA "MEDIT",       86,   N,  0,   86,     N,     N,    Y,   N '
      DATA "MINLEN",     120,   N,  0,    0,     Y,     N,    N,   Y '
      DATA "ML",          99,   N,  0,   99,     N,     N,    N,   N '
      DATA "MODE",       158,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "NDEL",        79,   S,  0,    0,     Y,     N,    N,   N '
      DATA "NDELETE",     79,   S,  0,    0,     Y,     N,    N,   N '
      DATA "NEXCLUDE",    61,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "NF",          60,   S,  1,    0,     Y,     Y,    Y,   N '
      DATA "NFIND",       60,   S,  1,    0,     Y,     Y,    Y,   N '
      DATA "NFLIP",       74,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "NOTIFY",     117,   N,  0,  117,     Y,     N,    Y,   N '
      DATA "NREVERT",    134,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "NV",         134,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "NSHOW",       68,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "NU",         132,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "NULINE",     132,   S,  0,    0,     Y,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "NX",          61,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "OPEN",        28,   N,  0,   28,     Y,     N,    Y,   N '
      DATA "OPENE",       28,   N,  0,   28,     Y,     N,    Y,   N '
      DATA "OPENV",       28,   N,  0,   28,     Y,     N,    Y,   N '
      DATA "OPENB",       28,   N,  0,   28,     Y,     N,    Y,   N '
      DATA "OPENWITH",     0,   N,  0,    0,     N,     N,    N,   Y '
      DATA "OPT",         32,   N,  0,   32,     N,     N,    Y,   N '
      DATA "OPTION",      32,   N,  0,   32,     N,     N,    Y,   N '
      DATA "OPTIONS",     32,   N,  0,   32,     N,     N,    Y,   N '
      DATA "PAGE",       122,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "PASTE",       29,   D,  0,    0,     Y,     N,    N,   N '
      DATA "PLEASE",     116,   N,  0,  116,     N,     N,    N,   N '
      DATA "PREPEND",     93,   S,  0,    0,     Y,     N,    N,   N '
      DATA "PRESERVE",    54,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "PRINT",       31,   S,  0,   31,     Y,     N,    Y,   N '
      DATA "PRO",         49,   N,  0,   49,     N,     N,    Y,   N '
      DATA "PROF",        49,   N,  0,   49,     N,     N,    Y,   N '
      DATA "PROFILE",     49,   N,  0,   49,     N,     N,    Y,   N '
      DATA "PTYPE",       84,   S,  0,    0,     N,     N,    N,   N '
      DATA "PT",          84,   S,  0,    0,     N,     N,    N,   N '
      DATA "Q",            0,   N,  0,   27,     Y,     N,    Y,   N '
      DATA "RC",          70,   N,  0,  104,     N,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "RCHANGE",     37,   N,  0,    0,     Y,     Y,    N,   N '
      DATA "RECALL",      70,   N,  0,  104,     N,     N,    Y,   N '
      DATA "RECFM",       69,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "REDO",        80,   N,  0,    0,     N,     N,    N,   N '
      DATA "RELOAD",      77,   N,  0,    0,     N,     N,    Y,   N '
      DATA "RENAME",      78,   N,  0,    0,     Y,     N,    N,   N '
      DATA "REN",         78,   N,  0,    0,     Y,     N,    N,   N '
      DATA "REP",         33,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "REPL",        33,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "REPLACE",     33,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "RES",         34,   N,  1,  115,     Y,     N,    Y,   N '
      DATA "RESET",       34,   S,  1,  115,     Y,     N,    Y,   N '
      DATA "RETF",        82,   N,  1,   82,     N,     N,    Y,   N '
      DATA "RETRIEVE",    35,   N,  1,   35,     N,     N,    Y,   N '
      DATA "REVERT",     133,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "RFIND",       38,   N,  1,  110,     Y,     Y,    Y,   N '
      DATA "RIGHT",       36,   N,  1,  153,     N,     N,    Y,   N '
      DATA "RLOC",        65,   N,  1,    0,     Y,     Y,    Y,   N '
      DATA "RLOCFIND",    66,   N,  1,  110,     Y,     Y,    Y,   N '
      DATA "RUN",        123,   N,  0,    0,     N,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "SAV",         40,   N,  0,    0,     Y,     N,    N,   N '
      DATA "SAVE",        40,   N,  0,    0,     Y,     N,    N,   N '
      DATA "SAVEALL",     90,   N,  0,   90,     Y,     N,    N,   N '
      DATA "SAVEAS",      41,   N,  0,    0,     Y,     N,    Y,   N '
      DATA "SC",          64,   S,  0,    0,     Y,     N,    N,   N '
      DATA "SET",         73,   N,  0,   73,     Y,     N,    Y,   N '
      DATA "SHOW",        67,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "SORT",        43,   S,  0,    0,     Y,     N,    N,   N '
      DATA "SOURCE",      14,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "SPELL",      108,   S,  0,    0,     Y,     N,    N,   N '
      DATA "SPLIT",      111,   S,  0,    0,     Y,     N,    N,   N '
      DATA "START",       89,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "ST",          57,   N,  0,    0,     Y,     N,    N,   N '
      DATA "STATE",       57,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "STATS",       57,   N,  0,    0,     Y,     N,    Y,   N '
      DATA "SUB",         75,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "SUBARG",      76,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "SUBCMD",     129,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "SUBINCLUDE", 124,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "SUBMIT",      75,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "SWAP",        44,   N,  0,   44,     N,     N,    Y,   N '
      DATA "TAB",         45,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "TABS",        45,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "TABBNDS",    162,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "TAG",         59,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "TC",          64,   S,  0,    0,     Y,     N,    N,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
      DATA "TEST",       141,   N,  0,  141,     N,     N,    Y,   N '
      DATA "TOP",         47,   N,  1,  105,     Y,     N,    Y,   N '
      DATA "UC",          64,   S,  0,    0,     Y,     N,    N,   N '
      DATA "ULINE",      131,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "UU",         131,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "UNDO",        46,   N,  0,    0,     N,     N,    N,   N '
      DATA "UP",          48,   N,  1,  106,     N,     N,    Y,   N '
      DATA "V",          126,   N,  0,  119,     N,     N,    Y,   N '
      DATA "VIEW",       126,   N,  0,  119,     N,     N,    Y,   N '
      DATA "VV",         133,   S,  0,    0,     Y,     N,    Y,   N '
      DATA "WDIR",       128,   N,  0,  128,     N,     N,    Y,   N '
      DATA "XFORM",      150,   N,  0,    0,     Y,     N,    Y,   N '
      DATA "XSUBMIT",    127,   N,  0,  127,     Y,     N,    Y,   N '
      DATA "XSUB",       127,   N,  0,  127,     Y,     N,    Y,   N '
      DATA "XTABS",       52,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "XTAB",        52,   N,  0,    0,     Y,     N,    Y,   Y '
      DATA "X",           17,   S,  0,   97,     Y,     N,    Y,   N '
      '-               PCmd#  LnOp Scr  FMPcmd Macro Track  Brws EFT
                                                                  '
                                                                  '
      '--------------------------------------------------------------------------------------------+
      '- Load the Command table                                                                    |
      '--------------------------------------------------------------------------------------------+
      FOR i = 1 TO CmdNumber                                      ' Load the primary command table
         PCmdTable(i).NAME     = READ$((i - 1) * 9 + 1)           ' Command name
         PCmdTable(i).EditCode = VAL(READ$((i - 1) * 9 + 2))      ' Command Index into PCodeTable
         PCmdTable(i).LinOps   = READ$((i - 1) * 9 + 3)           ' Lin operands allowed
         PCmdTable(i).Scroll   = VAL(READ$((i - 1) * 9 + 4))      ' Scrolling allowed
         PCmdTable(i).FMCode   = VAL(READ$((i - 1) * 9 + 5))      ' Command index into PCodeTable
         PCmdTable(i).MacOK    = READ$((i - 1) * 9 + 6)           ' OK to run from MACRO SPFCommand call
         PCmdTable(i).TrakOK   = READ$((i - 1) * 9 + 7)           ' Track Point creator
         PCmdTable(i).BrowseOK = READ$((i - 1) * 9 + 8)           ' Valid for Browse mode
         PCmdTable(i).EFTOK    = READ$((i - 1) * 9 + 9)           ' Valid for Browse mode
      NEXT i                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now copy the CODEPTR values to the main table                                             |
      '--------------------------------------------------------------------------------------------+
      FOR i = 1 TO CmdNumber                                      ' Loop through
         IF PCmdTable(i).EditCode <> 0 THEN                       ' If there's an EDIT code routine number
            PCmdTable(i).EditCode = PCodeTable(PCmdTable(i).EditCode)   ' Swap in a real code address instead of a number
         END IF                                                   '
         IF PCmdTable(i).FMCode <> 0 THEN                         ' If there's an FM code routine number
            PCmdTable(i).FMCode = PCodeTable(PCmdTable(i).FMCode) ' Swap in a real code address instead of a number
         END IF                                                   '
      NEXT i                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Now Sort the tabls so BinSrch will work                                                   |
      '--------------------------------------------------------------------------------------------+
      ARRAY SORT pCmdTable()                                      ' Sort it

      REDIM PCodeTable(1) AS INSTANCE DWORD                       ' Free the table area
   END METHOD                                                     '

   INTERFACE iPCmdTable: INHERIT IUNKNOWN                         ' Define the interface

      METHOD GetCmdIX(CmdStr AS STRING) AS LONG                   '
      '--------------------------------------------------------------------------------------------+
      '- Validate Command name and return Index (0 if invalid)                                     |
      '--------------------------------------------------------------------------------------------+
      LOCAL i AS LONG, key AS STRING                              '
         key = LSET$(Cmdstr, 16)                                  ' Make it the length of the NAME field
         i = ArraySearch(PCmdTable, Key, CompareNAME)             ' Search for CmdStr
         METHOD = i                                               ' Return the AttaySearch result
      END METHOD                                                  '

      METHOD GetEditCode(IX AS LONG) AS DWORD                     '
      '--------------------------------------------------------------------------------------------+
      '- Get Editor Code address for a command                                                     |
      '--------------------------------------------------------------------------------------------+
         METHOD = PCmdTable(IX).EditCode                          ' Pass back address
      END METHOD                                                  '

      METHOD GetFMCode(IX AS LONG) AS DWORD                       '
      '--------------------------------------------------------------------------------------------+
      '- Get FM Code address for a command                                                         |
      '--------------------------------------------------------------------------------------------+
         METHOD = PCmdTable(IX).FMCode                            ' Pass back address
      END METHOD                                                  '

      METHOD GetLinOps(IX AS LONG) AS STRING                      '
      '--------------------------------------------------------------------------------------------+
      '- Get Line Type Operands                                                                    |
      '--------------------------------------------------------------------------------------------+
         METHOD = TRIM$(PCmdTable(IX).LinOps)                     ' Pass back name
      END METHOD                                                  '

      METHOD GetName(IX AS LONG) AS STRING                        '
      '--------------------------------------------------------------------------------------------+
      '- Get name of a command                                                                     |
      '--------------------------------------------------------------------------------------------+
         METHOD = TRIM$(PCmdTable(IX).Name)                       ' Pass back name
      END METHOD                                                  '

      METHOD IsTrackOK(IX AS LONG) AS LONG                        '
      '--------------------------------------------------------------------------------------------+
      '- See if command wants a Track Point created                                                |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF(PCmdTable(IX).TrakOK = "Y", %True, %False)  ' Return true/false
      END METHOD                                                  '

      METHOD IsBrowseOK(IX AS LONG) AS LONG                       '
      '--------------------------------------------------------------------------------------------+
      '- See if command supported in Browse Node                                                   |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF(PCmdTable(IX).BrowseOK = "Y", %True, %False)   ' Return true/false
      END METHOD                                                  '

      METHOD IsEFTOK(IX AS LONG) AS LONG                          '
      '--------------------------------------------------------------------------------------------+
      '- See if command supported by EFT command                                                   |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF(PCmdTable(IX).EFTOK = "Y", %True, %False)   ' Return true/false
      END METHOD                                                  '

      METHOD IsMacOK(IX AS LONG) AS LONG                          '
      '--------------------------------------------------------------------------------------------+
      '- See if command supported in Macros                                                        |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF(PCmdTable(IX).MacOK = "Y", %True, %False)   ' Return true/false
      END METHOD                                                  '

      METHOD IsScrollOK(IX AS LONG) AS LONG                       '
      '--------------------------------------------------------------------------------------------+
      '- See if command is a scrolling command                                                     |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF(PCmdTable(IX).Scroll <> 0, %True, %False)   ' Return true/false
      END METHOD                                                  '

      METHOD IsFMAllowed(IX AS LONG) AS LONG                      '
      '--------------------------------------------------------------------------------------------+
      '- See if command supported in File Manager                                                  |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF(PCmdTable(IX).FMCode <> 0, %True, %False)   ' Return true/false
      END METHOD                                                  '

      METHOD IsEditAllowed(IX AS LONG) AS LONG                    '
      '--------------------------------------------------------------------------------------------+
      '- See if command supported in Editor Mode                                                   |
      '--------------------------------------------------------------------------------------------+
         METHOD = IIF(PCmdTable(IX).EditCode <> 0, %True, %False) ' Return true/false
      END METHOD                                                  '

   END INTERFACE                                                  '

END CLASS                                                         '
