'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- PCmd.inc                                                                                        |
'--------------------------------------------------------------------------------------------------+
                                                                  '
'--------------------------------------------------------------------------------------------------+
'- Primary command Methods                                                                         |
'--------------------------------------------------------------------------------------------------+

METHOD  pCmdACTION(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Set ACTION or do a Query                                                                        |
'--------------------------------------------------------------------------------------------------+
   FCB.ActionSave = GetSimpleNum(1, FCB.ActionSave, %True, PCmd)  ' Let GetSimpleNum do all the work
END METHOD                                                        '

METHOD  pCmdADD(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- ADD a line to the file                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
   MEntry                                                         '
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H ADD"), _                                     ' Help ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   IF ISFALSE PTBL.FindRngSet OR _                                ' If no range set
      PTBL.FindRngStart = 0 THEN MErrExit(%eFail, "Missing line reference")   ' Or no start line
   '-----------------------------------------------------------------------------------------------+
   '- OK Lets insert the line                                                                      |
   '-----------------------------------------------------------------------------------------------+
   me.ModSet(PTBL.FindRngStart)                                   ' Remember we changed something
   me.LInsertLines(PTBL.FindRngStart, 1, %Data)                   '
   me.LTxtSet(PTBL.FindRngStart + 1, PTBL.Pos2(1))                ' Stuff in the text
   me.AttrScan(PTBL.FindRngStart + 1)                             ' Recolorize

   '-----------------------------------------------------------------------------------------------+
   '- If MEdit mode ensure the MIX value is correct                                                |
   '-----------------------------------------------------------------------------------------------+
   IF IsMEdit THEN                                                ' In MEdit mode?
      i = me.MEditTbl("I", FORMAT$(PTBL.FindRngStart + 1))        ' Go get the MIX value of previous line
      LMixS(PTBL.FindRngStart + 1) = i                            ' Set into the new line
   END IF                                                         '
   me.CurSetReq(%Position, PTBL.FindRngStart + 1, 1, %True)       ' Position
   gfXRebuild = %True                                             ' Force exclude rebuild
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdALIGN(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- ALIGN Command                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, l, p1, x, bi, AllCount, AlignCol, AlignErr AS LONG '
LOCAL fline AS LONG, lclTxt, lclCSDS AS STRING, aTxt, aPad AS WSTRING   '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H ALIGN"), _                                   ' Help ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   '-----------------------------------------------------------------------------------------------+
   '- Validate MAX and Column operands                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FlgMax THEN                                            ' If MAX was specified?
      IF PTBL.FlgTCol THEN _                                      ' If a 2nd column operand
         MErrExit(%eFail, "Both MAX and a 2nd column operand are present") '
      AlignCol = -1                                               ' Remember MAX
      IF PTBL.FlgFCol THEN                                        ' If a 1st column operand
         PTBL.ColTo = FCB.BndRight                                ' Fudge the right boundary
         IF PTBL.ColTo = 0 THEN PTBL.ColTo = MaxLength            ' If normal bounds=MAX, use MaxLength
         PTBL.FlgTCol = %True                                     '
      END IF                                                      '

   ELSE                                                           ' No MAX specified
      IF ISFALSE PTBL.FlgFCol AND ISFALSE PTBL.FlgTCol THEN _     ' Any column operands?
            MErrExit(%eFail, "ALIGN requires an alignment column operand") ' Sorry, must have something
      IF PTBL.FlgFCol AND ISFALSE PTBL.FlgTCol THEN               ' Just one column operand?
         AlignCol = PTBL.ColFrom                                  ' Save it
         PTBL.FlgFCol = %False                                    ' Null it for the search
         PTBL.FlgTCol = %False                                    ' The other one as well
      ELSEIF PTBL.FlgFCol AND PTBL.FlgTCol THEN                   ' Two column operands?
         AlignCol = PTBL.ColTo                                    ' Save 2nd operand
         PTBL.ColTo = FCB.BndRight                                ' Fudge the right boundary
         IF PTBL.ColTo = 0 THEN PTBL.ColTo = MaxLength            '
      END IF                                                      '
   END IF                                                         '
   PTBL.FlgLeft = %True                                           ' So only Leftmost is 'found'

   '-----------------------------------------------------------------------------------------------+
   '- Handle CS/DS setting                                                                         |
   '-----------------------------------------------------------------------------------------------+
   lclCSDS = FCB.ChangeMode                                       ' Get the Profile default
   IF PTBL.FlgCS THEN                                             ' Override if provided
      lclCSDS = "C"                                               '
   END IF                                                         '
   IF PTBL.FlgDS THEN                                             '
      lclCSDS = "D"                                               '
   END IF                                                         '

   IF ISFALSE PTBL.FlgNext THEN PTBL.FlgNext = %True              '
   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- We'd better have something to work with                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE PTBL.FlgLit1 THEN MErrExit(%eFail, "Missing ALIGN search string")  ' Lit1 present?

   '-----------------------------------------------------------------------------------------------+
   '- OK lets do the search now                                                                    |
   '-----------------------------------------------------------------------------------------------+
   IF AlignCol = -1 THEN                                          ' Was this a MAX request?
      '--------------------------------------------------------------------------------------------+
      '- We have to scan to create the AlignCol value                                              |
      '--------------------------------------------------------------------------------------------+
      i = @P.C.CType                                              ' Do the initial search
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         AlignCol = MAX(AlignCol, PTBL.FoundCol)                  ' Save high water mark found column
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            AlignCol = MAX(AlignCol, PTBL.FoundCol)               ' Save high water mark found column
         END IF                                                   '
      LOOP                                                        '
      IF AlignCol = -1 THEN _                                     ' Still sitting at -1
         MErrExit(%eFail, "ALIGN could not determine MAX ALIGN column") '
   END IF                                                         '

   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values

   '-----------------------------------------------------------------------------------------------+
   '- The ALL flavor search                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FlgAll THEN                                            ' ALL?
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         i = sLine                                                ' Get found line
         GOSUB AlignIt                                            ' Go align the i line
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            i = sLine                                             ' Get found line
            GOSUB AlignIt                                         ' Go align the i line
         END IF                                                   '
      LOOP                                                        '

   '-----------------------------------------------------------------------------------------------+
   '- The single line search                                                                       |
   '-----------------------------------------------------------------------------------------------+
   ELSE                                                           '
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         i = sLine                                                ' Get found line
         GOSUB AlignIt                                            ' Go align the i line
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Search over, report the result                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF AlignErr THEN                                               ' If an error
      TP.ErrMsgAdd(nMac(%eFail), "One or more lines would have Left Shifted") '
   ELSEIF AllCount = 0 THEN                                       ' Issue approp. message
      TP.ErrMsgAdd(nMac(%eFail), "No lines were adjusted")        '
   ELSE                                                           '
      TP.ErrMsgAdd(0, "Aligned " + FORMAT$(AllCount) + IIF$(AllCount > 1, " lines", " line"))   '
      me.CurSetReq(%Change, fline, 0, %True)                      ' Do it without hilite
   END IF                                                         '
   MExitMeth                                                      '

'--------------------------------------------------------------------------------------------------+
'- Do the alignment for one line                                                                   |
'--------------------------------------------------------------------------------------------------+
AlignIt:                                                          '
   IF PTBL.FoundCol > AlignCol THEN                               ' If this would shift left, it's an error
      AlignErr = %True                                            ' Remember that
      RETURN                                                      ' And do nothing
   END IF                                                         '

   j = PTBL.FoundCol                                              ' Column where it was found
   k = PTBL.FoundLen                                              ' Length of found string
   l = LTxtGLen(i)                                                ' Length of text line
   lclTxt = LTxtG(i)                                              ' Get text line
   atxt = LAttrG(i)                                               ' Get Attr line
   aPad = MID$(aTxt, j - 1, 1)                                    ' Get the Attr of the preceding byte
   p1 = AlignCol - j                                              ' Calc # of Pad bytes to be added

   '-----------------------------------------------------------------------------------------------+
   '- See which way to do it                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF lclCSDS = "C" THEN                                          ' If simple Column Shift
      lclTxt = LEFT$(lclTxt, j - 1) + SPACE$(p1) + MID$(lclTxt, j)   ' Rebuild a new line
      aTxt   = LEFT$(aTxt, j - 1) + REPEAT$(p1, aPad) + MID$(aTxt, j)   ' Rebuild the Attr line

   ELSE                                                           ' Do it the Data Shift way
      '--------------------------------------------------------------------------------------------+
      '- Do the fancy alignment stuff                                                              |
      '--------------------------------------------------------------------------------------------+
      DO WHILE p1                                                 ' Do until we're done
         bi = INSTR(j, lclTxt, "  ")                              ' Look for two blanks
         IF bi = 0 THEN                                           ' There are no more usable blanks
            lclTxt = LEFT$(lclTxt, j - 1) + SPACE$(p1)       + MID$(lclTxt, j)   ' Rebuild a new line
            aTxt   = LEFT$(aTxt, j - 1)   + REPEAT$(p1, aPad) + MID$(aTxt, j) ' Rebuild the Attr line
            EXIT DO                                               '
            RETURN                                                ' We're done
         END IF                                                   '
         '-----------------------------------------------------------------------------------------+
         '- Collapse one of the two blanks we found                                                |
         '-----------------------------------------------------------------------------------------+
         lclTxt = LEFT$(lclTxt, bi - 1) + MID$(lclTxt, bi + 1)    ' Rebuild line minus a blank
         aTxt   = LEFT$(aTxt, bi - 1)   + MID$(aTxt, bi + 1)      ' Rebuild the Attr line
         '-----------------------------------------------------------------------------------------+
         '- Now do one byte of the needed alignment                                                |
         '-----------------------------------------------------------------------------------------+
         lclTxt = LEFT$(lclTxt, j - 1) + " "              + MID$(lclTxt, j)   ' Shift 1 char right
         aTxt   = LEFT$(aTxt, j - 1)   + CHR$$(aPad)      + MID$(aTxt, j)  ' Rebuild the Attr line
         INCR j: DECR p1                                          ' Adjust for loop
      LOOP                                                        ' Back we go
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Save back the modified data                                                                  |
   '-----------------------------------------------------------------------------------------------+
   me.LTxtSet(i, lclTxt)                                          ' Save it back
   LAttrS(i) = atxt                                               ' Save back Attr
   me.ModSet(i)                                                   ' Remember we changed something
   me.AttrScan(i)                                                 ' Recolorize
   INCR Allcount                                                  ' Count it
   RETURN                                                         '

END METHOD                                                        '

METHOD  pCmdAUTOBKUP(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Turn AutoBkup ON or OFF or do a Query                                                           |
'--------------------------------------------------------------------------------------------------+
   FCB.AutoBkup = GetOnOff(1, FCB.AutoBkup, PCmd)                 ' Let GetOnOff do all the work
END METHOD                                                        '

METHOD  pCmdAUTOCAPS(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Turn AutoCaps ON or OFF or do a Query                                                           |
'--------------------------------------------------------------------------------------------------+
   FCB.AutoCaps = GetOnOff(1, FCB.AutoCaps, PCmd)                 ' Let GetOnOff do all the work
END METHOD                                                        '

METHOD  pCmdAUTONAME(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Set AUTONAME or do a Query                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL t, MSG AS STRING                                            '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispAutoName, _                                     ' Help ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 OR PTBL.OpsNum > 1 THEN MErrExit(%eFail, "Incorrect # of operands detected") ' No data?
   IF PTBL.IsKwd("NONE") THEN                                     ' NONE ?
      FCB.AutoName = "$NONE$"                                     ' Set to Pseudo( NULL)
   ELSEIF PTBL.IsKwd("*") THEN                                    ' * ?
      FCB.AutoName = FCB.ProfName                                 ' Set to ProfName
   ELSE                                                           ' Must be an AUTO name
      FCB.AutoName = UUCASE(PTBL.Pos2(1))                         ' Get the literal 1 entry
      IF ISFALSE ISFILE(gENV.HomeData + "AUTO\" + FCB.AutoName + ".AUTO") THEN ' See if Colorize file exists
         t = ", Warning, the " + FCB.AutoName + ".AUTO file does not exist"   ' Missing AUTO file
      END IF                                                      '
   END IF                                                         '
   DispAutoName:                                                  '
   MSG = "AUTONAME set to " + IIF$(FCB.AUTONAME = "$NONE$", "NONE", FCB.AutoName) + t  '
   DoProfMsg(MSG)                                                 ' Issue it
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdAUTOSAVE(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Alter the AutoSave setting                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL i, lclFlag AS LONG, lclMsg, t AS STRING                     '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Parse
         GOTO AutoSDisp, _                                        ' Help ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "No operands detected")  ' No data?
   lclFlag = (FCB.AutoSave) AND &H00000003                        ' Get current flag values from Profile
   t = PTBL.Grp("ONOFFOFF")                                       ' Get the ON/OFF
   IF t = "ON"  THEN lclFlag OR=  %AutoSON                        ' ON
   IF t = "OFF" THEN lclFlag AND= (&HFFFFFFFF - %AutoSON)         ' OFF
   t = PTBL.Grp("PROMPTNO")                                       ' Get the PROMPT/NOPROMPT
   IF t = "PROMPT"     THEN lclFlag OR=  %AutoSPrompt             ' PROMPT
   IF t = "NOPROMPT"   THEN lclFlag AND= (&HFFFFFFFF - %AutoSPrompt) ' NOPROMPT
   FCB.AutoSave = lclFlag                                         ' Save the new value

   AutoSDisp:                                                     '
   lclMsg = "AUTOSAVE set to "                                    ' Start building msg
   lclMsg += IIF$((FCB.AutoSave AND %AutoSON), "ON ", "OFF ")     ' Build msg string
   lclMsg += IIF$((FCB.AutoSave AND %AutoSPrompt), "PROMPT", "NOPROMPT")   '
   DoProfMsg(lclMsg)                                              '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdBACKUP(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Backup the current file                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL MSG, CallType, Fn, t AS STRING, i, FNum AS LONG, RCA AS RCArea '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   CallType = "!"                                                 ' Default CallType
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         CallType = "?": GOTO Continue, _                         ' Backup ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   Continue:                                                      '
   IF IsMEdit OR TP.FCB_.FilePath = $New THEN                     ' Check session type
      MErrExit(%eFail, "Can't 'Backup' in this Edit session type")   '
   END IF                                                         '
   Fn = TP.FCB_.FilePath                                          ' Set the name of the file to backup

   IF IsClip OR IsSetEdit OR IsEFTEdit THEN                       ' A special Edit session?
      '--------------------------------------------------------------------------------------------+
      '- We must create a REAL file for these                                                      |
      '--------------------------------------------------------------------------------------------+
      Fn = GetTempFile("SPE")                                     ' Allocate a temp file
      FNum = FREEFILE                                             ' Get a file number
      OPEN Fn FOR OUTPUT AS # FNum                                ' Open it
      FOR i = 1 TO LastLine                                       ' Copy the data
         IF ISFALSE IsLData(i) THEN ITERATE FOR                   ' Skip non Data lines
         t = LTxtG(i)                                             ' Get a line
         PRINT # FNum, t                                          ' Write it
      NEXT i                                                      '
      CLOSE # FNum                                                ' Close it
   END IF                                                         '

   DoBackup(CallType + Fn, TP.TabMode, RCA)                       ' Go try it and get message result
   MSG = RCA.Msg                                                  ' Copy the message
   IF CallType = "?" THEN                                         ' If the Query type
      TP.ErrMsgAdd(%eNone, MSG)                                   ' Just issue the answer
   ELSE                                                           '
      IF RCA.RC <= 4 THEN                                         ' All OK?
         IF IsClip OR IsSetEdit OR IsEFTEdit THEN                 ' A special Edit session?
            '-                                                    '
         ELSE                                                     '
            IF IsModdFlag THEN MSG += ", not including current changes."   ' Fiddle message based on Mod flag
         END IF                                                   '
      END IF                                                      '
      TP.ErrMsgAdd(%eNone, MSG)                                   ' Now issue the answer
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdBOM(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Set BOM or do a Query                                                                           |
'--------------------------------------------------------------------------------------------------+
   FCB.BOM = GetOnOff(1, FCB.BOM, PCmd)                           ' Let GetOnOff do all the work
END METHOD                                                        '

METHOD  pCmdBOTTOM(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Alias for DOWN MAX                                                                              |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H BOTTOM"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.pCmdDown("DOWN MAX ")                                       '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdBOUNDS(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Set BOUNDS via the command line                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL MSG AS STRING, l, r AS LONG                                 '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispBNDS, _                                         ' BNDS ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 OR (PTBL.OpsNum = 1 AND PTBL.IsKwd("MAX")) THEN   ' No Operands? Or just MAX?
      l = 1: r = 0                                                ' Yes, reset to defaults
      GOTO SetBnds                                                ' Set them
   END IF                                                         '

   IF PTBL.IsKwd("MAX") THEN                                      ' Is MAX spewcified?
      IF PTBL.GotNum > 1 THEN MErrExit(%eFail, "BOUNDS has invalid operands") '
      IF PTBL.GotNum = 1 THEN                                     ' One numeric?
         l = VAL(PTBL.Pos("#", 1)): r = 0                         ' Setup Left/Right
      END IF                                                      '
   ELSE                                                           ' Not MAX
      IF PTBL.GotNum = 1 THEN                                     ' One numeric?
         l = 1: r = VAL(PTBL.Pos("#", 1))                         '
      ELSEIF PTBL.GotNum = 2 THEN                                 ' Two numeric
         l = VAL(PTBL.Pos("#", 1))                                ' Setup Left/Right
         r = VAL(PTBL.Pos("#", 2))                                ' Setup Left/Right
      END IF                                                      '
   END IF                                                         '

   SetBnds:                                                       '
      FCB.BndLeft = l: FCB.BndRight = r                           ' Save margins
   DispBNDS:                                                      '
      MSG = "BOUNDS set to " + FORMAT$(FCB.BndLeft) + " thru " + IIF$(FCB.BndRight = 0, "MAX", FORMAT$(FCB.BndRight))   '
      DoProfMsg(MSG)                                              ' Issue message properly
      FCB.BuildBndText                                            ' Create the BNDS line
      DoStatusBar($SBBnds)                                        ' re-Do the StatusBar Bnds box
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdBEVOpen(tMode AS LONG, EType AS STRING)               '
'--------------------------------------------------------------------------------------------------+
'- OPEN a new tab in selected mode                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL fn, MSG, macname, t, t1, t2, FnType AS STRING, i, TabFound, FNCreated, Force AS LONG, RCA AS RCArea   '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- First extract the file name                                                                  |
   '-----------------------------------------------------------------------------------------------+
   i = PTBL.GotLit                                                '
   FOR i = 1 TO PTBL.GotLit                                       ' See if a 'normal' literal
      T1 = PTBL.Pos("$", i)                                       ' Get the operand
      T2 = MID$(T1, 2, 1)                                         ' Get 1st real character
      IF INSTR("/%.", T2) > 0 THEN ITERATE FOR                    ' Not the filename
      IF ISNULL(fn) THEN                                          ' Should be empty
         fn = MID$(T1, 2): FnType =LEFT$(t1, 1)                   ' Save the FileName and type
         PTBL.NULL("$", i)                                        ' Nullify it
      ELSE                                                        ' We have one already
         MErrExit(%eFail, "Multiple possible filenames entered")  '
      END IF                                                      '
   NEXT i                                                         '
   IF ISNULL(fn) THEN                                             ' No filename?
      fn = DoOpenFile("Select file to " + EType, "")              ' Go get a filename
      IF ISNULL(fn) THEN MErrExit(%eFail, "File selection cancelled")   ' Bail out
    END IF                                                        '
   fn = SubstEnviron(fn)                                          ' Do %xxx% substitution
   IF tMode = %Browse AND IsEQ(fn, "NEW") AND FnType <> $OpQStr THEN _  '
      MErrExit(%eFail, "Can't Browse NEW files")                  '
   '-----------------------------------------------------------------------------------------------+
   '- Adjust gEFTOpenSource now                                                                    |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(gEFTOpenSource) THEN _                               ' Nothing set?  i.e. not SELECT
      gEFTOpenSource = EType                                      ' Swap to BROWSE/EDIT/VIEW
   '-----------------------------------------------------------------------------------------------+
   '- Separate NEW and existing files                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF UCASE$(fn) = "NEW" THEN                                     ' NEW?
      fn = $New                                                   ' Make NEW pretty unique
      TabAdd(tMode)                                               ' Add a Tab in requested Mode
   ELSE                                                           '
      IF INSTR(Fn, "\") = 0 THEN _                                ' If we have something with no path
         Fn = GetDefaultFolder + Fn                               ' Add a path if it doesn't have one
      '--------------------------------------------------------------------------------------------+
      '- Eliminate open already somewhere else                                                     |
      '--------------------------------------------------------------------------------------------+
      TabFound = VAL(FileQueue("S", " ", Fn))                     ' Returns tab number if open, else zero
      IF TabFound > 0 THEN                                        ' Tab number?
         GoToTab(TabFound, "File already Open in this tab", "")   ' Issue msg and exit
         MExitMeth                                                '
      END IF                                                      '
      IF ISFALSE ISFILE(Fn) THEN                                  ' Exist?
         IF tMode <> %Edit THEN                                   ' If BROWSE, kill it
            MErrExit(%eFail, "File does not exist, command cancelled")  ' Bail out
         END IF                                                   '
         FnCreated = %True                                        ' Do message later
         MakeNullFile(Fn)                                         ' Create it
      END IF                                                      '
      TabAdd(tMode)                                               ' Add a Tab in requested Mode
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Setup the FCB                                                                                |
   '-----------------------------------------------------------------------------------------------+
   TP.FCB_.SetupFn(fn, %ProfGetY, RCA)                            ' Setup the FCB
   IF TP.EFTSkip THEN                                             ' Skipped?
      TabDel()                                                    '
      MExitMeth                                                   ' Delete the tab
   END IF                                                         '
   IF RCA.RC = 8 THEN                                             ' Not OK?
      MErrExit(%eFail, TRIM$(RCA.Msg))                            ' Issue error and fail
      TabDel(): MExitMeth                                         ' Kill this new tab
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- See if a specific Profile or Macro name provided                                             |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.GotDotd = 1 THEN                                       ' A dotted name
      TP.FCB_.SetupProf(UCASE$(MID$(PTBL.Pos(".", 1), 2)), RCA)   ' Switch Profile
      IF RCA.RC <> 0 THEN _                                       ' OK?
         MErrExit(%eFail, TRIM$(RCA.Msg))                         ' Issue error and fail
    END IF                                                        '
    IF PTBL.IsKwd("FORCE") THEN Force = %True                     ' Pick up FORCE

   FOR i = 1 TO PTBL.GotLit                                       ' Process them
      '--------------------------------------------------------------------------------------------+
      '- See if a specific Override provided                                                       |
      '--------------------------------------------------------------------------------------------+
      T1 = PTBL.Pos2(i)                                           ' Get op value
      IF ISNULL(T1) THEN ITERATE FOR                              ' Ignore nulified entries
      IF LEFT$(T1, 1) = "%" THEN                                  ' An iMacro request?
         t = uucase(MID$(T1, 2))                                  ' Grab the name
         IF t = "ON" THEN t = uucase(TP.FCB_.IMacro)              ' Turn on existing IMacro
         IF t = "OFF" OR t = "NONE" THEN t = ""                   ' Turn OFF existing IMacro
         TP.FCB_.IMacro = uucase(T1)                              ' Swap the name (Leading % means "No Profile Save")
      ELSEIF LEFT$(T1, 1) = "/" THEN                              ' An XForm request?
         t = uucase(MID$(T1, 2))                                  ' Grab the name
         IF t = "ON" THEN t = uucase(TP.FCB_.XFormStr)            ' Turn on existing IMacro
         IF t = "OFF" OR t = "NONE" THEN t = ""                   ' Turn OFF existing IMacro
         TP.FCB_.XFormStr = uucase(T1)                            ' Swap the name (Leading / means "No Profile Save")
      ELSE                                                        '
         MErrExit(%eFail, "Unknown operand: " + MID$(T1, 2))      ' Issue error
      END IF                                                      '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get the file loaded                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF TabInitFileData() THEN                                      ' Let TabInit do the work, if True, bail out
      TabDel()                                                    ' Kill this new tab
   END IF                                                         '
   IF gEFTOpenSource = "SELECT" THEN                              ' If a generic SELECT type open
      TP.TabMode = TP.FCB_.Mode                                   ' Swap to the final Profile chosen Mode
   ELSE                                                           ' Must be specific
      SELECT CASE AS CONST$ gEFTOpenSource                        ' Set based on caller
         CASE "EDIT": TP.TabMode = %Edit                          '
         CASE "VIEW": TP.TabMode = %View                          '
         CASE "BROWSE": TP.TabMode = %Browse                      '
      END SELECT                                                  '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Run IMacro if specified                                                                      |
   '-----------------------------------------------------------------------------------------------+
   macname = TP.FCB_.IMacro                                       ' Get IMacro
   IF ISNOTNULL(Macname) AND UCASE$(macname) = macname THEN       ' Present and 'active'?
      IF isMacro(macname) THEN                                    ' An actual Macro?
         me.pCmdMacro(macname)                                    ' Then go do it
      END IF                                                      '
   END IF                                                         '
   IF FnCreated THEN TP.ErrMsgAdd(%ENone, "File did not exist, Created as an empty file") '
   IF Force     THEN TP.ErrMsgAdd(%eNone, "File was ReadOnly, it has been opened in View mode") '
   GoToTab(TP.PgNumber, "", "")                                   ' Ensure we go to the tab
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdBROWSE(pCmd AS STRING)                                '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H BROWSE"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.pCmdBEVOpen(%Browse, "BROWSE")                              ' Pass to BEV to continue
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCANCEL(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Cancel without saving anything                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL j, RC AS LONG                                               '
LOCAL DelFlag, tstyle, errbase AS STRING                          '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H CANCEL"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   IF PTBL.IsKwd("DELETE") THEN                                   ' DELETE?
      errbase = "DELETE option cannot be used "                   ' Setup basic message
      IF IsMEdit    THEN MErrExit(%eFail, errbase + "in MEdit mode") ' Not for MEdit mode
      IF IsBrowse   THEN MErrExit(%eFail, errbase + "in BROWSE mode")   ' Not for Browse Mode
      IF FCB.ROState THEN MErrExit(%eFail, errbase + "on a Read Only file")   ' Nor read-only
      DelFlag = IIF$(gENV.UseRecycle, "D", "U")                   ' Remember what type of delete
   END IF                                                         '

   IF FCB.FilePath <> $New THEN                                   ' If not an (New) file
      IF ISNOTNULL(DelFlag) THEN                                  ' DELETE asked for
         IF gENV.ConfDelFlag THEN                                 ' Need we prompt user for an OK?
            tstyle = "Permanently Delete: |K"                     ' Pick message text
            IF delflag = "D" THEN tstyle = "Send to Recycle Bin: |K" '
            j =DoMessageBox("OK to " + tstyle + FCB.FilePath, %MB_YESNO OR %MB_USERICON OR %MB_DEFBUTTON2, "SPFLite Delete")  '
            IF j = %IDYES THEN                                    ' OK?
               RC = FileRecycleBin(FCB.FilePath, DelFlag)         '
            ELSE                                                  '
               GOTO CanDelTab                                     ' Close with no delete
            END IF                                                '
         ELSE                                                     '
            RC = FileRecycleBin(FCB.FilePath, DelFlag)            '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   CanDelTab:                                                     '

   me.CleanTabData                                                ' Wipe everything out then
   '-----------------------------------------------------------------------------------------------+
   '- Request tab be deleted                                                                       |
   '-----------------------------------------------------------------------------------------------+
   INCR gTabDelCtr                                                ' Bump table index
   IF gTabDelCtr > UBOUND(gTabDelList()) THEN                     ' Keep table big enough
      REDIM PRESERVE gTabDelList(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
      REDIM PRESERVE gTabDelNext(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
   END IF                                                         '
   gTabDelList(gTabDelCtr) = PgNumber                             ' Stuff in our page number
   CmdStackNum = 0                                                ' If a can, no more commands allowed
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCAPS(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Turn CAPS ON, OFF or AUTO                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL MSG AS STRING                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   MSG = "CAPS set to "                                           ' Start building MSG
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispCaps, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   SELECT CASE AS CONST$ PTBL.Grp("ONOFFAUTO")                    ' Get which one
      CASE "ON"                                                   ' ON
         FCB.CapsDesired = 1: FCB.CapsActual = 1                  '
      CASE "OFF"                                                  ' OFF
         FCB.CapsDesired = 0: FCB.CapsActual = 0                  '
      CASE "AUTO"                                                 ' AUTO
         IF FCB.CapsDesired = 2 THEN                              ' Already in AUTO
            FCB.CapsActual = IIF(FCB.CapsActual, 0, 1)            ' Yes, then toggle active mode
         ELSE                                                     '
            FCB.CapsDesired = 2                                   '
         END IF                                                   '
   END SELECT                                                     '
   DispCaps:                                                      '
   IF FCB.CapsDesired <> 2 THEN                                   ' If simple ON/OFF
      MSG += IIF$(FCB.CapsDesired, "ON", "OFF")                   '
   ELSE                                                           '
      MSG += IIF$(FCB.CapsActual, "AUTO:on", "AUTO:off")          '
   END IF                                                         '
   DoProfMsg(MSG)                                                 ' Issue msg properly
   DoStatusBar($SBCaps)                                           ' re-Do the StatusBar Caps box
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCASE(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Set CASE or do a Query                                                                          |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO CaseDisp, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "CASE requires a C/T operand") '
   FCB.CaseFlag = PTBL.Grp("CT")                                  ' Get the answer
   IF FCB.AutoCaps AND FCB.CaseFlag = "C" AND ISFALSE gMacroMode THEN _ '
      DoMessageBox("|KWarning:|B CASE=C and AutoCaps ON may cause problems", %MB_OK + %MB_USERICON, "SPFLite") '
   CaseDisp:                                                      '
      DoProfMsg("CASE set to " + FCB.CaseFlag)                    ' Issue msg properly
   DoStatusBar($SBCaseWord)                                       ' re-Do the StatusBar Case box
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCHANGE(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- CHANGE command                                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, AllCount, AllLines, LLastLine, RSRCH, RCHNG AS LONG      '
LOCAL modemsg, t AS STRING                                        '
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Parse, ignore Assign
         PCmdHelp("H CHANGE"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   RSRCH = PTBL.IsKwd("RSRCH"): RCHNG = PTBL.IsKwd("RCHNG")       ' Get the critical ones right off

   '-----------------------------------------------------------------------------------------------+
   '- Catch the RSRCH                                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 1 THEN                                        ' Just a single operand?
      IF RSRCH THEN me.pCmdFind("FIND RSRCH", "CHANGE"): MExitMeth   ' Pass off RFIND to the FIND command
      IF RCHNG AND ISFALSE PTBL.RFlgLit1 THEN _                   ' Do we have search setup?
         MErrExit(%eFail, "No prior Search parameters")           '
      IF RCHNG AND ISFALSE PTBL.RFlgLit2 THEN _                   ' Do we have change setup?
         MErrExit(%eFail, "No prior Change parameters")           '
      '-----------------------------------------------------------------------------------------------+
      '- We're doing a simple RCHANGE (i.e. no extra operands)                                        |
      '-----------------------------------------------------------------------------------------------+
      me.ResetFunc(%ResetFind)                                    ' Clear previous FIND hilighting
      LocFind = "CHANGE"                                          ' Remember who's in charge
      IF PrevPCmd = "FIND" OR PrevPCmd = "F" OR PrevPCmd = "RFIND" OR PrevPCmd = "RLOCFIND" THEN   ' If the last command was a FIND
         IF PTBL.FoundFailed = 0 THEN                             ' And last FIND was successful?
            me.Change()                                           ' Yes, Just do the Change
         ELSE                                                     '
            TP.ErrMsgAdd(%eFail, "Last search was not successful")   '
         END IF                                                   '
      ELSE                                                        '
         IF me.Search(1, @P.C.CType) THEN                         ' Go see if we can find it
            me.Change()                                           ' Go do the change
         ELSE                                                     ' Not found, issue message
            TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
            PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)            ' Remember we failed
         END IF                                                   '
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- More than 1 operand present                                                                  |
   '-----------------------------------------------------------------------------------------------+
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting
   LocFind = "CHANGE"                                             ' Remember who's in charge
   Call3(PTBL.ParseCmd(pCmd, %PAssign), _                         ' Complete the parse
         PCmdHelp("H CHANGE"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   '-----------------------------------------------------------------------------------------------+
   '- Look for combo's which create loops                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF FCB.MinLen > 0 AND PTBL.FlgALL THEN                         ' If MINLEN in use and ALL
      IF PTBL.L1RData = SPACE$(LEN(PTBL.L1RData)) THEN            ' If Search string is blanks
         IF ISNULL(PTBL.l2RData) THEN                             ' If change string is null
            MErrExit(%eFail, "MINLEN > 0 and CHANGE parameters may trigger a loop") '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
   GOSUB GetReady                                                 ' Do Misc. setup

   '-----------------------------------------------------------------------------------------------+
   '- OK, do the search                                                                            |
   '-----------------------------------------------------------------------------------------------+
   DoSrchChng:                                                    '
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      RESET AllCount, AllLines, lLastLine                         ' Reset counters
      i = me.Search(0, @P.C.CType)                                ' Do the initial search

      IF i THEN                                                   ' See if we have one
         INCR AllCount                                            ' Count successful find
         IF PTBL.FoundLine <> lLastLine THEN INCR AllLines: lLastLine = PTBL.FoundLine '
         me.Change()                                              ' Go do the Change
         IF RCHNG THEN GOTO ExitChg                               ' If RCHNG, exit
      END IF                                                      '

      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                '
            INCR AllCount                                         ' Count successful finds
            IF PTBL.FoundLine <> lLastLine THEN INCR AllLines: lLastLine = PTBL.FoundLine '
            me.Change()                                           '
            IF RCHNG THEN GOTO ExitChg                            ' If RCHNG, exit
         END IF                                                   '
      LOOP                                                        '
      ExitChg:                                                    '
      IF ISFALSE FCB.HiFindSupp THEN                              ' If we're NOT suppressing HiFind
         IF AllCount = 0 THEN                                     ' Issue approp. message
            TP.ErrMsgAdd(nMac(%eFail), modemsg + " Not found")    '
         ELSE                                                     '
            TP.ErrMsgAdd(0, modemsg + " triggered change processing " + FORMAT$(AllCount) + IIF$(AllCount > 1, " times", " time") + IIF$(AllCount = AllLines, "", " in " + FORMAT$(AllLines) + " lines"))   '
         END IF                                                   '
      END IF                                                      '

   ELSE                                                           ' The non-All version
      IF me.Search(0, @P.C.CType) THEN                            ' Go see if we can find it
         IF RSRCH THEN MExitMeth                                  ' If RSRCH override, exit now
         me.Change()                                              ' Do the change
      ELSE                                                        ' Not found, issue message
         TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)               ' Remember we failed
      END IF                                                      '
   END IF                                                         '
   MExitMeth                                                      '

   GetReady:                                                      '
      IF ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _      ' If no direction specified
         ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN _    '
         PTBL.FlgNext = %True                                     ' Set NEXT
      IF (RSRCH OR RCHNG) AND PTBL.FlgAll THEN PTBL.FlgAll = %False: PTBL.FlgNext = %True '
      t = IIF$(LEN(PTBL.L1Raw) < 16, PTBL.L1Raw, LEFT$(PTBL.L1Raw, 14) + "..")   ' Build msg literal
      modemsg = IIF$(PTBL.FlgWord, "WORD ", "CHARS ") + t         ' Build mode part
      RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values
      RETURN                                                      '
END METHOD                                                        '

METHOD  pCmdCLIP(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- OPEN a new CLIP mode window                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL RCA AS RCArea                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H CLIP"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   gENV.ClipCmd = IIF$(PTBL.OpsNum = 1, UCASE$(PTBL.Pos2(1)), "") ' Setup clipboard name if provided
   gENV.SetINITimeStamp                                           '
   IF LEFT$(gENV.ClipCmd, 6) <> "_DIFF." THEN _                   ' Don't add DIFF CLIPS to Recent
      FileListRecentAdd(gENV.Homedata + "CLIP\" + gENV.ClipCmd + ".CLIP", "")  ' Else, Add to recent path
   TabAdd(%Clip OR %ClipLoad OR %ClipSave)                        ' Add a Tab in requested Mode
   TP.FCB_.SetupFN("", %ProfGetY, RCA)                            ' Setup null FN
   TabInitFileData()                                              ' Let TabInit do the work
   me.UndoInit()                                                  ' Re-alloc the UNDO files if needed
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCLONE(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- CLONE (Copy) a file into a new tab                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL fn1, fn2, SetProf, PDiag AS STRING                          '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H CLONE"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   SELECT CASE AS LONG PTBL.OpsNum                                ' Split based on number of operands
      CASE 0                                                      ' No operands
         GOSUB Copyfn                                             ' Copy current fn
         SetProf = FCB.ProfName                                   ' and Profile name
         IF fn1 = "" THEN                                         ' Not valid?
            MErrExit(%eFail, "Cannot Clone contents of this tab") '
         END IF                                                   '

      CASE 1                                                      '
         IF PTBL.GotDotd = 1 THEN                                 ' Just a Profile request?
            GOSUB CopyFn: SetProf = UUCASE(MID$(PTBL.Pos(".", 1), 2))   ' Current file, specified Profile
         ELSE                                                     ' Else must be a filename
            fn1 = PTBL.Pos2(1)                                    '
            IF fn1 = "*" THEN GOSUB Copyfn                        ' If * get current filename
            SetProf = GetProfileForFile(fn1, PDiag, %True, %False)   ' Get fn from Ops(1) (EFT,NotQuery)
         END IF                                                   '

      CASE 2                                                      '
         IF PTBL.GotDotd = 0 OR PTBL.GotLit = 0 THEN MErrExit(%eFail, "Invalid operand format") ' Kill if not a profile
         fn1 = PTBL.Pos2(1): SetProf = UUCASE(MID$(PTBL.Pos(".", 1), 2))   ' Get fn and Profile from the operands

   END SELECT                                                     '

   '-----------------------------------------------------------------------------------------------+
   '- Validate the filename                                                                        |
   '-----------------------------------------------------------------------------------------------+
   fn1 = SubstEnviron(fn1)                                        ' Do %xxx% substitution
   IF INSTR(fn1, "\") = 0 THEN fn1 = GetDefaultFolder + fn1       ' Add default dir if needed
   IF ISFALSE ISFILE(fn1) THEN _                                  ' See if file already exists
      MErrExit(%eFail, "Original Clone file cannot be found")     '

   '-----------------------------------------------------------------------------------------------+
   '- Get the new filename                                                                         |
   '-----------------------------------------------------------------------------------------------+
   Fn2 = DoInputBox("Enter the new FileName: ", "Clone Name", RTRIM$(Fn1)) '
   IF ISNULL(Fn2) OR IsEQ(Fn2, RTRIM$(Fn1)) THEN MErrExit(%eNone, "Clone cancelled")   '
   IF INSTR(fn2, "\") = 0 THEN fn2 = GetDefaultFolder + fn2       ' Add default dir if needed
   IF ISFILE(fn2) THEN _                                          ' See if file already exists
      MErrExit(%eFail, "Specified filename already exists")       '

   '-----------------------------------------------------------------------------------------------+
   '- Copy the file                                                                                |
   '-----------------------------------------------------------------------------------------------+
   TRY                                                            '
      FILECOPY fn1, fn2                                           ' COPY the file
      FileListRecentAdd(fn2, "E")                                 ' Go add to RECENT list

   CATCH                                                          '
      MErrExit(%eFail, "Unable to create Cloned file (Authority?)")  ' Kill if FILECOPY failed
   END TRY                                                        '
   SETATTR fn2, %NORMAL                                           ' Clear any RO bits
   '-----------------------------------------------------------------------------------------------+
   '- Open a new tab                                                                               |
   '-----------------------------------------------------------------------------------------------+
   me.pCmdEdit("EDIT " + $DQ + fn2 + $DQ + " ." + SetProf)        ' Get it open
   MExitMeth                                                      ' Exit

   CopyFn:                                                        '
   IF ISFALSE IsFMTab AND _                                       ' Not FM
      ISFALSE IsClip AND _                                        ' Not CLIP
      ISFALSE IsSetEdit AND _                                     ' Not SetEdit
      ISFALSE IsEFTEdit AND _                                     ' Not EFTEdit
      FCB.FilePath <> $New THEN                                   ' Not (New)
      fn1 = FCB.FilePath                                          ' All looks well, use the current file
   ELSE                                                           ' Else null the fn
      fn1 = ""                                                    '
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdCLS(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Clear (or Shut) the DEBUG window                                                                |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H CLS"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   IF PTBL.OpsNum = 0 THEN                                        ' If no operands, treat as CLS
      Debug "$$CLS"                                               ' Clear it and exit

   ELSE                                                           '
      IF PTBL.IsKwd("T") THEN                                     ' Terminate?
         Debug "$$QUIT"                                           ' Do so
      ELSE                                                        ' Not "T" ?
         MErrExit(%eFail, "Unknown CLS operand")                  ' Tell user
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCMD(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- CMD - RUN an external command                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lclDrive, lclCmd, lclPath, newPath AS STRING                '
LOCAL RetC AS LONG                                                '
LOCAL lclCmd2 AS ASCIZ * 255                                      '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H CMD"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   lclCmd = TRIM$(pCommand)                                       ' Strip it clean
   GetNextWord(lclCmd, %Strip)                                    ' Strip off the command itself
   IF me.MacSubst(lclCmd) THEN _                                  ' Do substitution
      MErrExit(%eFail, "Malformed macro operand in command line") '
   lclPath = CURDIR$                                              ' Save current path

   IF IsFMTab OR IsSetEdit OR IsClip OR IsEFTEdit THEN            ' In FM or special Tab?
      newPath = PARSE$(gFMNestTbl(gFMNestCtr), "|", 1)            ' Use FM's FPath                                             ' Use the default Fm directory
   ELSE                                                           '
      newPath = IIF$(ISNULL(FCB.Path), CURDIR$, FCB.Path)         ' Setup something
   END IF                                                         '
   IF MID$(lclPath, 2, 1) = ":" THEN lclDrive = LEFT$(lclPath, 2) ' Extract Drive if present
   IF MID$(NewPath, 2, 1) = ":" THEN CHDRIVE LEFT$(NewPath, 2)    ' If NewPath has drive change to it
   CHDIR NewPath                                                  ' Switch to New path
   IF ISNULL(TRIM$(lclCmd)) THEN lclCmd = "CMD.EXE"               ' If no command, use CMD.EXE
   lclCmd2 = lclCmd                                               ' Swap to ASCIIZ string
'-   debug ENVIRON$("COMSPEC") + " " + gENV.CmdFlags + " " + lclCmd2
   RetC = SHELL(ENVIRON$("COMSPEC") + " " + gENV.CmdFlags + " " + lclCmd2, 1) '
   IF ERR THEN                                                    ' Tell user result
      TP.ErrMsgAdd(%eFail, "Error issuing command " + ERROR$)     '
   ELSE                                                           '
      TP.ErrMsgAdd(0, "Command issued")                           '
   END IF                                                         '
   IF ISNOTNULL(lclDrive) THEN CHDRIVE lclDrive                   ' Switch drive if needed
   CHDIR lclPath                                                  ' put back the original path
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCOLLATE(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Set COLLATE profile value                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL NewName AS STRING                                           '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispCollate, _                                      ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   NewName = UCASE$(PTBL.Pos2(1))                                 ' Get an uppercase version
   IF NewName <> "ANSI" AND _                                     ' Is SOURCE non-ANSI mode?
      NewName <> "UTF8" AND _                                     '
      NewName <> "UTF16" AND _                                    '
      NewName <> "UTF16LE" AND _                                  '
      NewName <> "UTF16BE" THEN                                   '
      IF ISFALSE ISFILE(gENV.HomeFolder + NewName + ".SOURCE") THEN _   ' See if the Custom SOURCE file exists
         MErrExit(%eFail, "COLLATE codepage file: " + gENV.HomeFolder + PTBL.Ops(1) + ".SOURCE is not found, command rejected")  '
   END IF                                                         '

   FCB.CollateStr = NewName                                       '
   DispCollate:                                                   '
   DoStatusBar($SBSource)                                         ' re-Do the StatusBar Source box
   DoProfMsg("SOURCE set to " + FCB.SourceName + ", COLLATE set to " + FCB.CollateStr) '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCOLS(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Set COLS or do a Query                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lCols AS LONG                                               '
   lCols = IIF(FCB.Cols, 1, 0)                                    ' Save current cols value
   FCB.Cols = GetOnOff(1, FCB.Cols, PCmd)                         ' Let GetOnOff do all the work
END METHOD                                                        '

METHOD  pCmdCOMMENTS(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Handle Comments Command                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL CmntID, CmntCol, CmntIncr, CmntEnd, i AS LONG               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispComments, _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   CmntID = VAL(PTBL.Pos("#", 1))                                 ' Get COMMENT ID
   CmntCol = VAL(PTBL.Pos("#", 2))                                ' Get column number
   CmntIncr = VAL(PTBL.Pos("#", 3))                               ' Extract the Incr
   CmntEnd = VAL(PTBL.Pos("#", 4))                                ' Extract the End col
   IF CmntID < 1 OR CmntID > 9 THEN MErrExit(%eFail, "COMMENTS ID is invalid")   '
   IF CmntCol > 150 OR CmntIncr > 50 THEN MErrExit(%eFail, "COMMENTS Column/Increment appear unreasonable") '
   IF CmntCol > 0 AND CmntIncr = 0 THEN MErrExit(%eFail, "COMMENTS Increment should be non-zero")  '
   IF CmntEnd > 150 THEN MErrExit(%eFail, "COMMENTS End-Col appears unreasonable")  '
   FCB.CmntID   = CmntID                                          ' Update the profile
   FCB.CmntCol  = CmntCol                                         '
   FCB.CmntIncr = CmntIncr                                        '
   FCB.CmntEnd  = CmntEnd                                         '
   DispComments:                                                  '
   DoProfMsg("COMMENTS set to: " + FORMAT$(FCB.CmntID) + " " + FORMAT$(FCB.CmntCol) + " " + _   '
             FORMAT$(FCB.CmntIncr) + " " + FORMAT$(FCB.CmntEnd))  '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCOMPRESS(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- COMPRESS Command                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, l, x, Condense, lclAll AS LONG, AllCount, lLastLine AS LONG '
LOCAL fline AS LONG, ftxt, lclTxt, t AS STRING, aTxt AS WSTRING   '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H COMPRESS"), _                                ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   IF ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _         '
      ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN _       '
      PTBL.FlgNext = %True                                        ' Set NEXT if no others specified
   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '
   lclAll = %True                                                 ' Set the 'do at least 1 line' ALL flag

   '-----------------------------------------------------------------------------------------------+
   '- We'd better have something to work with                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE PTBL.FlgLit1 THEN                                   ' Lit1 present?
      MErrExit(%eFail, "Missing COMPRESS search string")          '
   END IF                                                         '
   IF PTBL.FlgLit2 THEN                                           ' Lit2 present?
      IF LEN(PTBL.L2RData) >= LEN(PTBL.L1RData) THEN              ' Lengths look OK?
         MErrExit(%eFail, "COMPRESS second literal must be shorter than first literal")   '
      END IF                                                      '
      Condense = %True                                            ' Mark as Condense
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Look for combo's which create loops                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF FCB.MinLen > 0 AND PTBL.FlgALL THEN                         ' If MINLEN in use and ALL
      IF PTBL.L1RData = SPACE$(LEN(PTBL.L1RData)) THEN            ' If Search string is blanks
         IF ISNULL(PTBL.L2RData) THEN                             ' If change string is null
            MErrExit(%eFail, "MINLEN > 0 and COMPRESS parameters may trigger a loop")  '
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- OK lets do the search now                                                                    |
   '-----------------------------------------------------------------------------------------------+
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values

   '-----------------------------------------------------------------------------------------------+
   '- The ALL flavor search                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FlgAll OR lclAll THEN                                  ' ALL?
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         i = sLine                                                ' Get found line
         GOSUB CompIt                                             ' Go compress the i line
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            i = sLine                                             ' Get found line
            GOSUB CompIt                                          ' Go compress the i line
         END IF                                                   '
      LOOP                                                        '

   '-----------------------------------------------------------------------------------------------+
   '- The single line search                                                                       |
   '-----------------------------------------------------------------------------------------------+
   ELSE                                                           '
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         i = sLine                                                ' Get found line
         GOSUB CompIt                                             ' Go compress the i line
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Search over, report the result                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF AllCount = 0 THEN                                           ' Issue approp. message
      TP.ErrMsgAdd(nMac(%eFail), "No lines " + IIF$(Condense, "condensed", "compressed")) '
   ELSE                                                           '
      TP.ErrMsgAdd(0, IIF$(Condense, "Condensed ", "Compressed ") + FORMAT$(AllCount) + IIF$(AllCount > 1, " lines", " line"))   '
      me.CurSetReq(%Change, fline, 0, %True)                      ' Do it without hilite
   END IF                                                         '
   MExitMeth                                                      '

'--------------------------------------------------------------------------------------------------+
'- Do the compress for one line                                                                    |
'--------------------------------------------------------------------------------------------------+
CompIt:                                                           '
   IF Condense THEN GOSUB CondIt: RETURN                          ' Split off Condense here
   j = PTBL.FoundCol                                              ' Column where it was found
   k = PTBL.FoundLen                                              ' Length of found string (Use orig. length)
   l = LEN(L(i).@LTxt)                                            ' Length of text line
   lclTxt = LTxtG(i)                                              ' Get text line
   atxt = LAttrG(i)                                               ' Get Attr line
   ftxt = MID$(lclTxt, j, k)                                      ' Get found text
   x = j                                                          ' Where found
   DO                                                             ' Do forever
     IF x + k + k - 1 > LEN(lclTxt) THEN EXIT DO                  ' No more possibility of compressing, exit loop
     IF x + k + k - 1 > PTBL.ColTo THEN EXIT DO                   '
     IF MID$(lclTxt, x + k, k) = ftxt THEN                        ' Two in a row?
        lclTxt = LEFT$(lclTxt, x + k - 1) + MID$(lclTxt, x + k + k)  ' Compress
        atxt = LEFT$(atxt, x + k - 1) + MID$(atxt, x + k + k)     ' Compress Attr line in step
        IF i <> lLastLine THEN                                    ' Count actual changed lines
           INCR AllCount: lLastLine = i                           ' Count and save line #
        END IF                                                    '
        me.ModSet(i)                                              ' Remember we changed something
        LFOn(i, %EQChange)                                        ' Mark the line number
        me.UpdLControl(i)                                         ' Update LLCtl
        IF fline = 0 THEN fline = i                               ' Save 1st found line
     ELSE                                                         ' Not two in a row
        x = INSTR(x + k, lclTxt, ftxt)                            ' See if another string further along
        IF x = 0 THEN EXIT DO                                     ' No?  We're done
        IF x + k + k - 1 > PTBL.ColTo THEN EXIT DO                ' Yes, Within margins? No? We're done as well
     END IF                                                       '
   LOOP                                                           '

   me.LTxtSet(i, lclTxt)                                          ' Save it back
   LAttrS(i) = atxt                                               ' Save back Attr
   me.AttrScan(i)                                                 ' Recolorize
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Condense the line                                                                               |
'--------------------------------------------------------------------------------------------------+
CondIt:                                                           '
   OnColSupp                                                      ' Tell sChange not to maintain columns
   IF PTBL.FoundLine <> lLastLine THEN                            '
      IF lLastLine <> 0 AND ISFALSE PTBL.FlgAll AND ISTRUE lclAll THEN  ' Just a lclALL type and we've done one line?
         i = 0: RETURN                                            ' Kill the searc loop and bail out
      END IF                                                      '
      INCR AllCount: lLastLine = PTBL.FoundLine                   '
   END IF                                                         '
   IF AllCount = 1 THEN me.CurSetReq(%Position, PTBL.FoundLine, 1, %True)  '
   t = LTxtG(PTBL.FoundLine)                                      '
   me.Change()                                                    ' Go do the change
   sCol = 1                                                       ' Start at column 1 again
   sLine = sLine - 1                                              ' Backup sChanges restart point
   IF ISFALSE PTBL.FlgAll AND ISTRUE lclAll THEN                  ' Just a lclALL type?
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdCOPY(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Read file and insert after current row pointer                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i, x, ii, iLastLine, iCount, iPoint, NumAdj, NumInDest, pLastLine, SetCur AS LONG   '
LOCAL frmlin, tolin, before, after, ablabel, lclTop AS LONG       '
LOCAL fn, DmyIMacro, BaseFile, BasePath, t AS STRING, RCA AS RCArea  '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H COPY"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   BaseFile = FCB.FilePath                                        ' Save original filename
   BasePath = PATHNAME$(PATH, BaseFile)                           ' Extract and save the path
   '-----------------------------------------------------------------------------------------------+
   '- Pick up the parsed values                                                                    |
   '-----------------------------------------------------------------------------------------------+
   t = PTBL.Pos("#", 1): IF ISNOTNULL(t) THEN frmlin = VAL(t)     ' Get frmlin if present
   t = PTBL.Pos("#", 2): IF ISNOTNULL(t) THEN tolin = VAL(t)      ' Get tolin if present
   before = PTBL.IsKwd("BEFORE")                                  ' Get BEFORE state
   after  = PTBL.IsKwd("AFTER")                                   ' Get AFTER state
   t = PTBL.Pos(".", 1): IF ISNOTNULL(t) THEN ablabel = me.LineNoRef(t) '
   t = PTBL.Pos("!", 1)                                           ' Get possible LPtr reference
   IF ISNOTNULL(t) AND ablabel > 0 THEN MErrExit(%eFail, "Multiple line reference detected - " + t)   ' Oops!
   IF ISNOTNULL(t) THEN ablabel = me.LineNoRef(t)                 ' Save it

   '-----------------------------------------------------------------------------------------------+
   '- Validate what we scanned                                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF before AND after THEN MErrExit(%eFail, "Can't specify both BEFORE and AFTER") ' Issue ERROR
   IF (before OR after) AND ablabel = 0 THEN MErrExit(%eFail, "BEFORE/AFTER require a line label") ' Issue error
   IF frmlin <> 0 AND tolin = 0 THEN MErrExit(%eFail, "Both start and end line numbers of copied file are required") ' Issue error
   IF frmlin > tolin THEN SWAP frmlin, tolin                      '

   '-----------------------------------------------------------------------------------------------+
   '- OK, a bit more validation and set the starting line for Insert                               |
   '-----------------------------------------------------------------------------------------------+
   IF LastLine <> 2 THEN                                          ' If we're not empty
      IF before > 0 THEN                                          ' Stuff in A/B from cmd line
         i = ablabel - 1                                          ' Adjust if BEFORE
         IF ISTRUE gLTblRange THEN MErrExit(%eCmdPend, "Cannot specify BEFORE and also an A/B, AA/BB or C/CC line control")   '
      ELSEIF after > 0 THEN                                       '
         i = ablabel                                              '
         IF ISTRUE gLTblRange THEN MErrExit(%eCmdPend, "Cannot specify AFTER and also an A/B, AA/BB or C/CC line control") '
      ELSE                                                        '
         IF ISFALSE gLTblRange THEN                               ' Better have a line range at this point
            MErrExit(%eCmdPend, "Specify A/B, AA/BB or H/HH line control, or BEFORE/AFTER for COPY")  '
         ELSE                                                     ' We have a line range
            IF gLTblDCmd <> "H       " AND gLTblDCmd <> "HH      " AND _   ' Only H/HH
               gLTblDCmd <> "A       " AND gLTblDCmd <> "B       " AND _   ' Or A/B
               gLTblDCmd <> "AA      " AND gLTblDCmd <> "BB      " THEN ' or AA/BB
               MErrExit(%eCmdPend, "Specify A/B, AA/BB or H/HH line control, or BEFORE/AFTER for COPY")  '
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
   ELSE                                                           '
      i = 1                                                       ' Else insert after top line
   END IF                                                         '
   lclTop = @P.PTopLine                                           ' Save topscreen

   '-----------------------------------------------------------------------------------------------+
   '- Get the file to be copied                                                                    |
   '-----------------------------------------------------------------------------------------------+
   TP.ErrMsgReset                                                 ' Reset any Pending conflict flag
   fn = PTBL.Pos2(1)                                              ' Get filename operand if present

   '-----------------------------------------------------------------------------------------------+
   '- Get filename if needed and ready for reading                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(fn) THEN                                             ' No filename?
      fn = DoOpenFile("Select file to COPY", "")                  ' Go get a filename
      IF ISNULL(fn) THEN MErrExit(%eFail, "File selection cancelled")   ' Bail out
   END IF                                                         '
   IF INSTR(fn, "\") = 0 THEN fn = BasePath + fn                  ' If no path, add BasePath
   IF INSTR(fn, "\") = 0 THEN fn = GetDefaultFolder + Fn          ' If still no path, add DefaultFolder
   IF ISFALSE ISFILE(fn) THEN                                     ' Fail it
      MErrExit(%eFail, "File does not exist in: " +  PATHNAME$(PATH, fn))  '
   END IF                                                         '
   FCB.SetupFN(fn, %ProfGetY, RCA)                                ' Ready the file
   IF FCB.Skip THEN MErrExit(%eFail, "COPY skipped due to Profile NONTEXT")   ' Oops!

   '-----------------------------------------------------------------------------------------------+
   '- If the simple insert, do it                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF i = 1 AND gLTblDCmd <> "A       " AND gLTblDCmd <> "B       " AND ISFALSE Before AND ISFALSE After THEN  ' Empty default?
      GOSUB FileInsert                                            ' Insert the file
      GOSUB FinishCopy                                            ' Finish off things

   ELSEIF gLTblDCmd = "A       " OR gLTblDCmd = "B       " OR Before OR After THEN  ' Normal A / B ?
      IF ISFALSE Before AND ISFALSE After THEN                    '
         i = IIF(gLTblDCmd = "A       ", gLTblDFrom, gLTblDFrom - 1) ' Set Insert point
         me.TTblDel(gLTblDFrom)                                   ' Remove from Touched lines
         me.UpdLControl(gLTblDFrom)                               ' Clear from the line
      END IF                                                      '
      GOSUB FileInsert                                            ' Insert the file
      GOSUB FinishCopy                                            ' Finish off things

   '-----------------------------------------------------------------------------------------------+
   '- Insert in a replacement block                                                                |
   '-----------------------------------------------------------------------------------------------+
   ELSEIF gLTblDCmd = "H       " OR gLTblDCmd = "HH      " THEN   ' The H / HH ?

      '--------------------------------------------------------------------------------------------+
      '- Remove the HH block range                                                                 |
      '--------------------------------------------------------------------------------------------+
      me.LStubDelRange(gLTblDFrom, gLTblDTo)                      ' Delete the range
      me.TTblDel(gLTblDFrom)                                      ' Remove from Touched lines
      me.UpdLControl(gLTblDFrom)                                  ' Clear from the line
      me.TTblDel(gLTblDTo)                                        ' Remove from Touched lines
      me.UpdLControl(gLTblDTo)                                    ' Clear from the line
      i = gLTblDFrom - 1                                          ' Make previous line look like 'A'

      '--------------------------------------------------------------------------------------------+
      '- And Insert the file in it's place                                                         |
      '--------------------------------------------------------------------------------------------+
      GOSUB FileInsert                                            ' Insert the file
      GOSUB FinishCopy                                            ' Finish off things

   '-----------------------------------------------------------------------------------------------+
   '- Insert repeatedly in an AA block                                                             |
   '-----------------------------------------------------------------------------------------------+
   ELSEIF gLTblDCmd = "AA     " THEN                              ' The AA After mode?
      gLTblDRpt = MAX(1, gLTblDRpt)                               ' Ensure at least count of 1
      me.TTblDel(gLTblDFrom)                                      ' Remove from Touched lines
      me.UpdLControl(gLTblDFrom)                                  ' Clear from the line
      me.TTblDel(gLTblDTo)                                        ' Remove from Touched lines
      me.UpdLControl(gLTblDTo)                                    ' Clear from the line

      '--------------------------------------------------------------------------------------------+
      '- Determine size of block range                                                             |
      '--------------------------------------------------------------------------------------------+
      FOR x = gLTblDFrom TO gLTblDTo                              ' Count the data lines
         IF IsLData(x) OR IsLTop(x) OR IsLFile(x) THEN            ' Just data lines
            INCR NumInDest                                        ' + 1
            GOSUB DoPM                                            '
         END IF                                                   '
      NEXT x                                                      '
      IF NumInDest <= gLTblDRpt THEN MErrExit(%eFail, "AA number must be < range size")   ' Dest count reasonable?

      '--------------------------------------------------------------------------------------------+
      '- Setup and do the loop-de-loop                                                             |
      '--------------------------------------------------------------------------------------------+
      i = gLTblDFrom + gLTblDRpt - 1                              ' Init for loop
      SetCur = gLTblDFrom                                         ' Remember where cursor goes
      WHILE i <= gLTblDTo + NumAdj                                ' Big outer loop
         IF ISFALSE IsLData(i) AND ISFALSE IsLTop(i) AND ISFALSE IsLFile(i) THEN INCR i: ITERATE   ' Ignore non Data lines
         IF SetCur > 0 THEN                                       ' Set cursor just once
            me.CurSetReq(%LineCmd, SetCur, 1, %False)             '
            SetCur = 0                                            '
         END IF                                                   '
         pLastLine = LastLine                                     ' Save so we can calc # lines inserted
         GOSUB FileInsert                                         ' Insert the file after 'i'
         NumAdj += (LastLine - pLastLine)                         ' Track # inserted
         i += gLTblDRpt + (LastLine - pLastLine)                  ' Big outer loop
      LOOP                                                        ' next 'i'
      GOSUB FinishCopy                                            ' Finish off things

   '-----------------------------------------------------------------------------------------------+
   '- Insert repeatedly in an BB block                                                             |
   '-----------------------------------------------------------------------------------------------+
   ELSEIF gLTblDCmd = "BB     " THEN                              ' The BB After mode?
      gLTblDRpt = MAX(1, gLTblDRpt)                               ' Ensure at least count of 1
      me.TTblDel(gLTblDFrom)                                      ' Remove from Touched lines
      me.UpdLControl(gLTblDFrom)                                  ' Clear from the line
      me.TTblDel(gLTblDTo)                                        ' Remove from Touched lines
      me.UpdLControl(gLTblDTo)                                    ' Clear from the line

      '--------------------------------------------------------------------------------------------+
      '- Determine size of block range                                                             |
      '--------------------------------------------------------------------------------------------+
      FOR x = gLTblDFrom TO gLTblDTo                              ' Count the data lines
         IF IsLData(x) OR IsLBottom(x) OR IsLFile(x) THEN         ' Just data lines
            INCR NumInDest                                        ' + 1
            GOSUB DoPM                                            '
         END IF                                                   '
      NEXT x                                                      '
      IF NumInDest <= gLTblDRpt THEN MErrExit(%eFail, "BB number must be < range size")   ' Dest count reasonable?

      '--------------------------------------------------------------------------------------------+
      '- Setup and do the loop-de-loop                                                             |
      '--------------------------------------------------------------------------------------------+
      x = NumInDest \ gLTblDRpt                                   ' x = # of insertion points
      i = gLTblDTo - (x * gLTblDRpt)                              ' Initial insertion point
      SetCur = gLTblDFrom                                         ' Remember where cursor goes
      WHILE i < gLTblDTo + NumAdj                                 ' Big outer loop
         IF ISFALSE IsLData(i) AND ISFALSE IsLTop(i) AND ISFALSE IsLFile(i) THEN '
         INCR i: ITERATE                                          ' Ignore non Data lines
         END IF                                                   '
         IF SetCur > 0 THEN                                       ' Set cursor just once
            me.CurSetReq(%LineCmd, SetCur, 1, %False)             '
            SetCur = 0                                            '
         END IF                                                   '
         pLastLine = LastLine                                     ' Save so we can calc # lines inserted
         GOSUB FileInsert                                         ' Insert the file after 'i'
         NumAdj += (LastLine - pLastLine)                         ' Track # inserted
         i += gLTblDRpt + (LastLine - pLastLine)                  ' Big outer loop
      LOOP                                                        ' next 'i'
      GOSUB FinishCopy                                            ' Finish off things

   END IF                                                         '
   @P.PTopLine = lclTop                                           ' Restore topscreen
   MExitMeth                                                      '

'--------------------------------------------------------------------------------------------------+
'- Insert the file at the desired point                                                            |
'--------------------------------------------------------------------------------------------------+
FileInsert:                                                       '
   iPoint = i + 1                                                 ' Save location of 1st inserted line
   iLastLine = LastLine                                           ' Save so we can calc # lines inserted
   me.CopyAFile(i, gLTblDFlag, frmlin, tolin, %False, DmyIMacro)  ' Go load the data
   me.ModSet(i)                                                   ' Remember we changed something
   IF ErrMsgHigh <> %eNone THEN MExitMeth                         ' If errors, bail out
   iCount = (LastLine - iLastLine)                                ' Track # inserted
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Issue a done message                                                                            |
'--------------------------------------------------------------------------------------------------+
FinishCopy:                                                       '
   TP.ErrMsgAdd(%eNone, "File copied")                            ' Issue success message
   FCB.SetupFN(BaseFile, %ProfGetY, RCA)                          ' Restore FCB
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Handle the +/- involvement                                                                      |
'--------------------------------------------------------------------------------------------------+
DoPM:                                                             '
   IF BIT(gLTblDFlag, %lCmdX) THEN                                ' Do the +/- processing for the Source
      LFOn(x, %Invisible)                                         ' If - make Invisible
      gfXRebuild = %True                                          ' Ask for Exclude processing
   ELSEIF BIT(gLTblDFlag, %lCmdNX) THEN                           '
      LFOff(x, %Invisible)                                        ' If + make visible
      gfXRebuild = %True                                          ' Ask for Exclude processing
   END IF                                                         '
   RETURN                                                         '

END METHOD                                                        '

METHOD  pCmdCREATE(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- CREATE/REPLACE a filename                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL fn1, cmdname, BaseFile, t AS STRING, x, i, lclTop, lclRep AS LONG, RCA AS RCArea '

   MEntry                                                         '
   BaseFile = FCB.FilePath                                        ' Save orig filename
   cmdname = "CREATE"                                             ' Default
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H CREATE"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.IsKwd("REPSWAP") THEN cmdname = "REPLACE"              ' Swap if passed from REPLACE
   IF PTBL.IsKwd("REPLACE") THEN lclRep = %True                   ' Remember REPLACE Kwd

   lclTop = @P.PTopLine                                           ' Save where we are
   IF XFormActive <> "" THEN                                      ' XFORM loaded data?
      IF WarnXForm(cmdname) THEN MErrExit(%eNone, "XForm active, Command cancelled")   ' Warn user
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get parameters                                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      IF ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast AND _     ' And no modifiers
         ISFALSE PTBL.FlgNext  AND ISFALSE PTBL.FlgPrev THEN      '
         PTBL.FlgAll = %True                                      ' Force ALL if no modifiers
      END IF                                                      '
   END IF                                                         '

   IF ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgALL THEN        ' If still no range
      PTBL.FlgALL = %True                                         ' Set ALL
   END IF                                                         '

   fn1 = PTBL.Pos2(1)                                             ' Save entered filename
   IF ISFALSE PTBL.FlgLit1 THEN                                   ' If no filename
      fn1 = DoOpenFile("Enter Filename to be written", fn1)       ' Do a prompt
      IF ISNULL(fn1) THEN MErrExit(%eNone, "Write function cancelled")  '
   END IF                                                         '
   IF INSTR(fn1, "\") = 0 THEN fn1 = FCB.Path + fn1               ' If unqualified, add the path
   PTBL.FlgLit1 = %False                                          ' Say Lit1 is no longer there
   PTBL.FlgDX = %True                                             ' Say DX so X pop-outs are skipped
   fn1 = SubstEnviron(fn1)                                        ' Do %xxx% substitution
   IF ISFILE(fn1) AND ISFALSE lclRep AND cmdname <> "REPLACE" THEN   ' Warn of REPLACE?
      MErrExit(%eFail, "File exists, add REP/REPLACE to re-use it")  '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle a single range entry (force .ZL if needed                                             |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FindRngStart <> 0 AND PTBL.FindRngEnd = 0 THEN         ' No 2nd operand?
      PTBL.FindRngEnd = LastLine                                  '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Write the file now                                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE ISFILE(fn1) THEN                                    ' Not there (create)?
      MakeNullFile(fn1)                                           ' Create it
   END IF                                                         '
   FCB.SetupFN(fn1, %ProfGetY, RCA)                               ' Ready the file
   IF me.WriteFile(%False, "R") THEN                              ' Wrte the range
      MacWarn = 0                                                 ' Ensure MacOverlap issues a message
      me.MacOverlap(fn1)                                          ' Warn if Macro/command overlap

      '--------------------------------------------------------------------------------------------+
      '- If this is still an (New) tab make it a normal one now                                    |
      '--------------------------------------------------------------------------------------------+
      IF BaseFile = $New THEN                                     ' If Base is still $New
         me.WindowTitle                                           ' Alter window/Tab titles
         me.ClrLoad()                                             ' Get Attr loaded if it exists
         OffModdFlag: OnUndoFlag                                  ' Turn off the Modd flag
         me.FileWatch("", %WatchEnd)                              ' Kill any prior Watch
         FileQueue("A", " ", FCB.FilePath)                        ' Add to FQ
         IF me.FileWatch(FCB.FilePath, %WatchStart) THEN _        ' Establish the watch
            TP.ErrMsgAdd(0, "File watch could not be established")   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If the line range was a MM (Move) then delete the range                                   |
      '--------------------------------------------------------------------------------------------+
      IF PTBL.FindRngLCtl = "M" OR PTBL.FindRngLCtl = "MM" THEN   ' If the line selection was a Take

         '-----------------------------------------------------------------------------------------+
         '- But only if we're OK                                                                   |
         '-----------------------------------------------------------------------------------------+
         IF FileRecs = 0 THEN                                     '
            TP.ErrMsgAdd(%eFail, "No records written, File is empty, Record deletion skipped")  ' Issue error
         ELSE                                                     '
            me.ModSet(PTBL.FindRngStart)                          ' Remember we changed something
            me.LStubDelRange(PTBL.FindRngStart, PTBL.FindRngEnd)  ' Delete the range
            me.AdjustPending(PTBL.FindRngStart, PTBL.FindRngEnd - PTBL.FindRngStart + 1, 0)  ' Adjust pending requests
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Make sure we're in the RECENT list                                                        |
      '--------------------------------------------------------------------------------------------+
      FileListRecentAdd(FCB.FilePath, "")                         ' Go add to RECENT list
      DoSet(%LoadReq)                                             ' Request refresh

   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- See if Profile restore needed                                                                |
   '-----------------------------------------------------------------------------------------------+
   IF BaseFile <> $New THEN                                       ' Reload FCB?
      FCB.SetupFN(BaseFile, %ProfGetY, RCA)                       ' Swap to the Base name
   END IF                                                         '
   @P.PTopLine = lclTop                                           '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdCUT(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- CUT data to the Windows Clipboard                                                               |
'--------------------------------------------------------------------------------------------------+
LOCAL CBD, cbname, MyDLM AS STRING, lTxtp AS STRING POINTER       '
LOCAL i, j, k AS LONG                                             '
LOCAL NumDel, lclTop, AppendText, recs, Raw, DelLines, NewOnly, LastChosen AS LONG  '
DIM   DLines(1000) AS LONG                                        '
LOCAL CB AS ISTRINGBUILDERA                                       '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H CUT"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   CB = CLASS "StringbuilderA"                                    ' Define CB
   CB.Clear                                                       ' Clear stringbuilder, just in case
   CB.Capacity = 65536                                            ' Set a starting capacity
   IF gENV.CutNew THEN NewOnly = %True                            ' Get global option for NEW
   IF PTBL.GotLit = 1 THEN                                        ' Only one litersl
      IF LEFT$(PTBL.Pos2(1), 1) <> $OPQStr THEN                   ' Not a quoted Search literal
         cbname = UCASE$(PTBL.Pos2(1))                            ' Then its the cbname
         PTBL.FlgLit1 = %False                                    ' Say it's been used
      END IF                                                      '
   END IF                                                         '
   IF PTBL.GotLit = 2 THEN                                        ' Two?
      IF LEFT$(PTBL.Pos2(1), 1) =  $OPQStr AND _                  ' L1 Quoted AND
         LEFT$(PTBL.Pos2(2), 1) =  $OPQStr THEN _                 ' L2 Quoted
         MErrExit(%eFail, "There are TWO quoted literal, See Help Note")   ' Oops
      IF LEFT$(PTBL.Pos2(1), 1) =  $OPStr AND _                   ' L1 NOT Quoted
         LEFT$(PTBL.Pos2(2), 1) =  $OPQStr THEN                   ' L2 Quoted
         PTBL.SwapPos("$", 1, 2)                                  ' Swap them, incorrect order
         PTBL.SwapL1L2                                            '
      END IF                                                      '
      IF LEFT$(PTBL.Pos2(1), 1) =  $OPQStr AND _                  ' L1 Quoted
         LEFT$(PTBL.Pos2(2), 1) =  $OPStr THEN                    ' L2 NOT Quoted (Correct order)
         cbname = UCASE$(PTBL.Pos2(2))                            ' Then its the cbname
         PTBL.FlgLit2 = %False                                    ' Say it's been used
      END IF                                                      '
   END IF                                                         '

   AppendText = PTBL.IsKwd("APPEND")                              ' Pick up APPEND/ADD/A
   NewOnly = PTBL.IsKwd("NEW")                                    ' Pick up NEW
   IF PTBL.IsKwd("REPLACE") THEN NewOnly = %False                 ' Override with REPLACE
   DelLines = PTBL.IsKwd("DELETE")                                ' Pick up DELETE
   Raw = PTBL.IsKwd("RAW")                                        ' Pick up RAW

   IF PTBL.FindRngSet OR PTBL.FlgLit1 OR _                        ' If a line range or search literal
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '

   IF ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgALL THEN _      ' Better be something
      MErrExit(%eFail, "Pending line range")                      '

   PTBL.FlgDX = %True                                             ' Tell search hands off Invisible status

   '-----------------------------------------------------------------------------------------------+
   '- Handle NEW test                                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF cbname <> "" AND ISTRUE NewOnly THEN                        ' If NEW, make sure OK
      IF ISFILE(gENV.Homedata + "CLIP\" + cbname + ".CLIP") THEN  ' Does file exist?
         i =DoMessageBox("NEW specified, but |K" + gENV.Homedata + "CLIP\" + cbname + ".CLIP" + "|B already exists." + $CRLF + _  '
                         "Do you want to over-write the existing file?", %MB_YESNO + %MB_USERICON, "SPFLite")  '
         IF i = %IDNO THEN                                        '
            MErrExit(%eFail, "CUT cancelled")                     ' OK, go no further
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   gKeyPrimOper = cbname: MyDLM = $CRLF                           ' Set clipboardname / delimiter
   ErrMsgHigh = %eNone                                            ' Reset any Pending conflict flag
   lclTop = @P.PTopLine                                           '
   CB.Clear                                                       ' Start as ""
   IF AppendText THEN                                             '
      ClipboardRead(CBD, MyDLM, %False)                           ' Go get whatever's there, keep the file
      CB.Add(CBD)                                                 ' Stuff into new CB
      CBD = ""                                                    ' Free CBD
   END IF                                                         '
   RESET Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen  ' Reset 1st found values
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         GOSUB CutOne                                             ' Go handle one
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            GOSUB CutOne                                          ' Go handle one
         END IF                                                   '
      LOOP                                                        '
   ELSE                                                           ' The non-All version
      i = me.Search(0, @P.C.CType)                                ' Go see if we can find it
      IF i THEN                                                   ' Got it?
         GOSUB CutOne                                             ' Go handle one
      END IF                                                      '
   END IF                                                         '

   IF ISTRUE ClipboardWrite(CB.String) THEN                       ' OK?
      IF j THEN                                                   ' Something to delete?
         FOR i = j - 1 TO 0 STEP -1                               ' Now delete the lines (backward)
            IF IsLData(dLines(i)) THEN me.ModSet(dLines(i))       ' Remember we changed something
            me.LTxtFree(dLines(i))                                ' Go free the dynamic string
            me.LEntDel(dLines(i))                                 ' Remove from the L() array
            INCR NumDel                                           '
            me.AdjustPending(dLines(i), -1, 0)                    ' Adjust pending requests
            DECR LastLine: DECR LastReal                          ' Adjust LastLine and LastReal
         NEXT i                                                   '
      END IF                                                      '
      @P.PTopLine = lclTop                                        '
      IF recs > 0 THEN                                            '
         IF AppendText THEN                                       ' Issue appropriate message
            TP.ErrMsgAdd(0, FORMAT$(recs) + IIF$(recs > 1, " lines", " line") + " appended to " + IIF$(ISNULL(gKeyPrimOper), "Windows", gKeyPrimOper) + " clipboard")   '
         ELSE                                                     '
            TP.ErrMsgAdd(0, FORMAT$(recs) + IIF$(recs > 1, " lines", " line") + " cut to " + IIF$(ISNULL(gKeyPrimOper), "Windows", gKeyPrimOper) + " clipboard")  '
         END IF                                                   '
      ELSE                                                        '
         TP.ErrMsgAdd(%eFail, "No lines Cut to clipboard")        '
      END IF                                                      '
   END IF                                                         '
   RESET gKeyPrimOper                                             ' Blank clipboardname
   MExitMeth                                                      '

CutOne:                                                           '
   i = PTBL.FoundLine                                             ' Get the located line number
   IF i = LastChosen THEN RETURN                                  ' Don't select a line more than once
   IF IsLInsertLine(i) THEN RETURN                                ' Exempt Insert lines
   LastChosen = i                                                 ' Remember we chose this one
   lTxtp = LTxtGP(i)                                              ' Get a pointer to the text
   IF ISFALSE Raw THEN                                            ' Normal mode
      CB.Add(@lTxtP + MyDLM)                                      ' Add each line with delimiter
   ELSE                                                           ' Raw mode
      CB.Add(@lTxtP)                                              ' Add each line without a delimiter
   END IF                                                         '
   INCR recs                                                      ' Count records
   IF LEFT$(PTBL.FindRngLCtl, 1) = "M" OR DelLines THEN           ' A TAKE like reference, or DELETE asked for?
      IF j + 1 > UBOUND(dlines) THEN                              ' Do we need to expand table?
         REDIM PRESERVE dLines(UBOUND(dLines) + 1000)             ' Yes, do it
      END IF                                                      '
      dLines(j) = i                                               ' Save the line number
      INCR j                                                      ' Count it
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdDCB(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Common DCB routine for altering the RECFM, LRECL and EOL operands                               |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, RF, RF1, EO, EO1, t, MSG AS STRING, LR, LR1, GotLR AS LONG   '
   MEntry                                                         '
   MSG = "DCB is set to: "                                        ' Start building MSG
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO FormatMsg, _                                        ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum <> 2 AND PTBL.OpsNum <> 4 AND PTBL.OpsNum <> 6 THEN _ ' Must be 2, 4 or 6 operands
      MErrExit(%eFail, "Command must have 2, 4 or 6 operands")    ' If not, kill it
   RF1 = FCB.RECFM: EO1 = FCB.EOL: LR1 = FCB.LRECL                ' Get current values
   '-----------------------------------------------------------------------------------------------+
   '- Process the operands                                                                         |
   '-----------------------------------------------------------------------------------------------+
   t = PTBL.Grp("RECFM")                                          ' Get any RECFM operand
   IF ISNOTNULL(t) THEN RF = t                                    ' Grab it

   IF PTBL.GotNum THEN LR = VAL(PTBL.Pos("#", 1)): GotLR = %True  ' If present grab LRECL

   t = PTBL.Grp("EOL")                                            ' Get any EOL
   IF ISNOTNULL(t) THEN                                           ' If present
      EO = t                                                      ' Grab it
   ELSEIF PTBL.GotLit THEN                                        ' Nothing? Maybe a Hex Literal
      t = UCASE$(PTBL.Pos2(1))                                    ' Try for literal1
      IF (LEN(t) <> 2 AND LEN(t) <> 4) OR VERIFY(t, $Hex) <> 0 THEN _   ' See if valid hex
         MErrExit(%eFail, "EOL Operand: " + t + " is invalid")    '
      EO = t                                                      ' Grab it
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Use current values for omitted operands                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(RF) THEN RF = RF1                                    ' Copy current if needed
   IF ISNULL(EO) THEN EO = EO1                                    '
   IF ISFALSE GotLR THEN LR = LR1                                 '

   '-----------------------------------------------------------------------------------------------+
   '- Validate out the illogical combinations                                                      |
   '-----------------------------------------------------------------------------------------------+
   t = " conflict, Use DCB command to change both together"       '
   IF RF = "U" THEN                                               ' RECFM = U
      IF EO = "NONE" THEN _                                       ' + EOL=NONE
         MErrExit(%eFail, "RECFM=U and EOL=NONE" + t)             '
      IF LR > 0 THEN _                                            ' + LRECL=nnn
         MErrExit(%eFail, "RECFM=U and LRECL=" + FORMAT$(LR) + t) '
   END IF                                                         '

   IF RF = "F" THEN                                               ' RECFM = F
      IF LR = 0 THEN _                                            ' + LRECL=0
         MErrExit(%eFail, "RECFM=F and LRECL=0" + t)              '
   END IF                                                         '

   IF LEFT$(RF, 1) = "V" THEN                                     ' RECFM = V
      IF EO <> "NONE" THEN _                                      ' + EOL=NONE
         MErrExit(%eFail, "RECFM=" + RF + " and EOL=" + EO + t)   '
      IF LR > 0 THEN _                                            ' + LRECL=nnn
         MErrExit(%eFail, "RECFM=" + RF + " and LRECL=" + FORMAT$(LR) + t) '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Validated, now we can change the values                                                      |
   '-----------------------------------------------------------------------------------------------+
   FCB.RECFM = RF: FCB.EOL = EO: FCB.LRECL = LR                   ' Save them

   FormatMsg:                                                     '
   RF = FCB.RECFM                                                 ' Get RECFM
   EO = FCB.EOL                                                   ' Format EOL
   IF VERIFY(EO, $Hex) = 0 THEN EO = "X'" + EO + "'"              ' IF hex operand, FRAME it for the message
   DoProfMsg(MSG + "RECFM=" + RF + ", LRECL=" + FORMAT$(FCB.LRECL) + ", EOL=" + EO )   ' Issue message
   DoStatusBar($SBEOL)                                            ' re-Do the StatusBar EOL box
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdDELETE(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- DELETE Specified lines                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL Lasttxt, lclNote AS STRING                                  '
LOCAL i, j, k, AllCount, lclCol, lclDup, lDir, lsLine, RSRCH, RCHNG AS LONG   '
DIM dlines(1 TO 1000) AS LONG                                     ' To hold lines to be deleted
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Parse
         PCmdHelp("H DELETE"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   RSRCH = PTBL.IsKwd("RSRCH"): RCHNG = PTBL.IsKwd("RCHNG")       ' Get the critical ones right off

   lclDup  = PTBL.IsKwd("DUP")                                    ' Check for DUP presence
   lclNote = PTBL.Grp("NOTE")                                     ' Check for any xNOTE Kwds

   '-----------------------------------------------------------------------------------------------+
   '- Handle DUP here                                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF lclDup THEN                                                 ' DUP
      Call3(PTBL.ParseCmd(pCmd, %PAssign), _                      ' Finish Parse
            PCmdHelp("H DELETE"), _                               ' ? entered
            MErrExit(%eFail, PTBL.ErrMsg), _                      ' Error, Bail out
            Nul)                                                  ' Continue
      GOSUB GetReadyD                                             ' Setup for search
      i = PTBL.GotDotd + PTBL.GotLPtr                             ' Get how many line range operands
      IF (PTBL.OpsNum - 2) > i THEN _                             ' Extra operands over that number?
         MErrExit(%eFail, "DELETE DUP invalid operand detected")  ' Eliminate due to extra operands
      FOR i = 1 TO LastLine                                       ' Lets scan things
         IF ISFALSE me.RangeVal(i) THEN ITERATE                   ' Honour range
         IF IsLData(i) THEN                                       ' Only data lines
            IF LTxtG(i) = Lasttxt THEN                            ' A DUP?
               GOSUB AddDel                                       ' Mark for deletion
            ELSE                                                  '
               Lasttxt = LTxtG(i)                                 ' Save as new DUP text data
            END IF                                                '
         END IF                                                   '
      NEXT i                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If we found any, delete them                                                              |
      '--------------------------------------------------------------------------------------------+
      IF j THEN                                                   ' Any added to the Delete array?
         GOSUB DelThem                                            ' Go Delete them
         TP.ErrMsgAdd(0, FORMAT$(AllCount) + " duplicate " + IIF$(AllCount > 1, "lines", "line") + " removed") '
      ELSE                                                        '
         TP.ErrMsgAdd(0, "No duplicate lines found")              '
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle NOTE type here                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(lclNote) THEN                                     ' NOTE or xNOTE?
      Call3(PTBL.ParseCmd(pCmd, %PAssign), _                      ' Finish Parse
            PCmdHelp("H DELETE"), _                               ' ? entered
            MErrExit(%eFail, PTBL.ErrMsg), _                      ' Error, Bail out
            Nul)                                                  ' Continue
      GOSUB GetReadyD                                             ' Setup for search
      i = PTBL.GotDotd + PTBL.GotLPtr                             ' Get how many line range operands
      IF (PTBL.OpsNum - 1) > i THEN _                             ' Extra operands over that number?
         MErrExit(%eFail, "DELETE NOTE invalid operand detected") ' Eliminate due to extra operands

      FOR i = 1 TO LastLine                                       ' Lets scan things
         IF ISFALSE me.RangeVal(i) THEN ITERATE                   ' Honour range
         IF IsLNote(i) THEN                                       ' Is this even a NOTE line?
            IF lclNote = "NOTE" AND L(i).LWrk2 = 0 THEN           ' The simple NOTE type?
               GOSUB AddDel                                       ' Mark for deletion
            ELSEIF LEFT$(lclNote, 1)  = "Z" AND L(i).LWrk2 <> 0 THEN ' Generic special note (Z) and this is a special?
               GOSUB AddDel                                       ' Mark for deletion
            ELSEIF L(i).LWrk2 = INSTR($Upper, LEFT$(lclNote, 1)) THEN   ' Specific NOTE type and a match?
               GOSUB AddDel                                       ' Mark for deletion
            END IF                                                '
         END IF                                                   '
      NEXT i                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If we found any, delete them                                                              |
      '--------------------------------------------------------------------------------------------+
      IF j THEN                                                   ' Any added to the Delete array?
         GOSUB DelThem                                            ' Go Delete them
         TP.ErrMsgAdd(0, FORMAT$(AllCount) + " NOTE " + IIF$(AllCount > 1, "lines", "line") + " removed")   '
      ELSE                                                        '
         TP.ErrMsgAdd(0, "No NOTE lines found")                   '
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- The 'normal' type delete, with operands                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 1 THEN                                        ' Just one operand?
      IF RSRCH THEN me.pCmdFind("FIND RSRCH", "DELETE"): MExitMeth' Pass off RFIND to the FIND command

      IF RCHNG THEN                                               ' The RDELETE call?
         me.ResetFunc(%ResetFind)                                 ' Clear previous FIND hilighting
         IF LocFind <> "DELETE" THEN _                            ' Last better be DELETE
            MErrExit(%eFail, "Last search was NOT a DELETE command") '
         IF PTBL.FoundFailed = 0 THEN                             ' Last FIND was successful?
            i = PTBL.FoundLine                                    ' Get the found line
            GOSUB AddDel                                          ' Delete it
         ELSE                                                     '
            i = me.Search(0, @P.C.CType)                          ' Go see if we can find it
            IF i = 0 THEN                                         ' Got it?
               TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
               PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)         ' Remember we failed
            ELSE                                                  '
               i = PTBL.FoundLine                                 ' Get found line
               GOSUB AddDel                                       ' Delete it
            END IF                                                '
         END IF                                                   '
         GOSUB DelThem                                            ' Go do the deletes
         MExitMeth                                                '
      END IF                                                      '

   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Validate any weird combinations of operands                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAssign), _                         ' Finish Parse
         PCmdHelp("H DELETE"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.FlgAll AND PTBL.OpsNum = 1 AND ISFALSE PTBL.FindRngSet THEN  ' ALL and no line range?
      IF IsNE(CurrPCmd, "DELETE") THEN MErrExit(%eFail, "To delete entire file, fully spell out DELETE ALL")   '
      '--------------------------------------------------------------------------------------------+
      '- Do a quicker DELETE ALL right here                                                        |
      '--------------------------------------------------------------------------------------------+
      me.LStubDelRange(2, LastLine - 1)                           ' Delete the lines
      MExitMeth                                                   ' We're done
   END IF                                                         '
   IF ISFALSE PTBL.FlgLit1 THEN                                   ' No Lit1 present?
      IF ISFALSE PTBL.FlgAll AND ISFALSE PTBL.FindRngSet AND _    ' No Lit1, better have ALL or FindRngSet
         ISFALSE PTBL.FlgU AND ISFALSE PTBL.FlgNU AND _           ' or U or NU
         ISFALSE PTBL.FlgX AND ISFALSE PTBL.FlgNX THEN _          ' or X or NX
         MErrExit(%eFail, "No search string, but no ALL specified")  '
      IF PTBL.FlgWord OR PTBL.FlgPrefix OR PTBL.FlgSuffix THEN MErrExit(%eFail, "No search string, but string options are present") ' No extraneous operands
   ELSE                                                           '
      IF ISFALSE PTBL.FlgAll THEN LocFind = "DELETE"              ' If not ALL, remember which LOC / FIND command was last
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Run the standard search procedure                                                            |
   '-----------------------------------------------------------------------------------------------+
   PTBL.FlgDX = %True                                             ' Add the DX internally
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      i = me.Search(0, @P.C.CType)                                ' Do Find
      IF i THEN                                                   '
         i = PTBL.FoundLine                                       ' Get found line
         lclCol = sCol: lDir = sDir: lsLine = sLine               ' Save 1st located for RFIND stuff
         IF RSRCH THEN MExitMeth                                  ' Exit if RSRCH
         GOSUB AddDel                                             ' If found, Flag for delete
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            i = PTBL.FoundLine                                    ' Get found line
            IF RSRCH THEN MExitMeth                               ' Exit if RSRCH
            GOSUB AddDel                                          ' If found, Flag for delete
         END IF                                                   '
      LOOP                                                        '
      GOSUB DelThem                                               ' Go do the deletes
      IF AllCount = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(nMac(%eFail), "No lines found")             '
      ELSE                                                        '
         TP.ErrMsgAdd(0, "Deleted " + FORMAT$(AllCount) + IIF$(AllCount > 1, " lines", " line"))   '
         sCol = lclCol: sDir = lDir: sLine = lsLine               ' Restore to 1st one found
      END IF                                                      '

   ELSE                                                           ' The non-All version
      i = me.Search(0, @P.C.CType)                                ' Do Find
      IF i = 0 THEN                                               ' Got it?
         i = PTBL.FlgNext                                         '
         TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.Grp("Position") = "NEXT", "Bottom of data reached", "Top of data reached"))  '
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)               ' Remember we failed
      ELSE                                                        '
         i = PTBL.FoundLine                                       ' Get found line
         IF RSRCH THEN MExitMeth                                  ' Exit if RSRCH
         GOSUB AddDel                                             ' If found, Flag for delete
         GOSUB DelThem                                            '
         TP.ErrMsgAdd(0, "Deleted " + FORMAT$(AllCount) + " line")   '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
      END IF                                                      '
   END IF                                                         '
   gfXRebuild = %True                                             ' Force exclude rebuild
   MExitMeth                                                      '

AddDel:                                                           '
   FOR k = 1 TO j                                                 '
      IF dLines(k) = i THEN RETURN                                ' Don't add line more than once
   NEXT k                                                         '
   INCR j                                                         '
   IF J > UBOUND(dLines) THEN _                                   ' Expand table if needed
      REDIM PRESERVE dLines(1 TO UBOUND(dLines) * 2)              ' Double it
   dLines(j) = i                                                  ' Save the line number
   RETURN                                                         '

DelThem:                                                          '
   Allcount = 0                                                   '
   IF j = 0 THEN RETURN                                           ' Nothing to do
   FOR i = j TO 1 STEP -1                                         ' Now delete the lines (backward)
      me.ModSet(dLines(i))                                        ' Remember we changed something
      me.LTxtFree(dLines(i))                                      ' Go free the dynamic string
      me.LEntDel(dLines(i))                                       ' Remove from the L() array
      me.AdjustPending(dLines(i), -1, 0)                          ' Adjust pending requests
      DECR LastLine: DECR LastReal                                ' Adjust LastLine and LastReal
      INCR AllCount                                               ' Count real deletions
   NEXT i                                                         '
   me.CurSetReq(%Change, dLines(1) - 1, 0, %True)                 ' Set cursor set attempt
   RETURN                                                         '


GetReadyD:                                                        '
   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      IF ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _      ' If no direction specified
         ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN _    '
         PTBL.FlgNext = %True                                     ' Set NEXT
      IF (RSRCH OR RCHNG) AND PTBL.FlgAll THEN PTBL.FlgAll = %False: PTBL.FlgNext = %True '
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdDIFF(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Do a DIFF file compare                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL T1, T2, i, j, lclFlags, OpCount AS LONG, FileA, FileB, FileADate, FileBDate, tt1, tt2, t, CBDate, CBName AS STRING   '
LOCAL StrmA, StrmB    AS DiffStream                               ' Stream control
LOCAL TxtA(), TxtB()  AS STRING                                   ' Text arrays
LOCAL T1P             AS iObjTabData                              ' Pointer to Tab 1 data
LOCAL T2P             AS iObjTabData                              ' Pointer to Tab 2 data
LOCAL T1Sel, T2Sel    AS LONG                                     ' FileA/FileB initial selection
LOCAL OpenFiles()     AS STRING                                   ' Array of Open Files
LOCAL lclOperands()   AS STRING, RCA AS RCArea                    '
LOCAL T1FD, T2FD AS DIRDATA                                       '
DIM OpenFiles(1 TO 500) AS STRING                                 ' DIM OpenFiles
DIM lclOperands(1 TO 2) AS STRING                                 ' DIM lclOperands
LOCAL DIFFs() AS STRING, DIFFCount AS LONG                        '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H DIFF"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   T1Sel = 1: T2Sel = 1                                           ' Set default list selection
   gDiffFileA = "": gDiffFileB = ""                               ' Erase any previous Global stuff

   '-----------------------------------------------------------------------------------------------+
   '- Get the filenames of the current OPEN files                                                  |
   '-----------------------------------------------------------------------------------------------+
   OpenFiles(1) = " "                                             ' Ensure (1) has something in it
   IF gTabsNum > 1 THEN                                           ' If we have files Open
      FOR i = 2 TO gTabsNum                                       ' Pick up the current names
        T1P = gTabs(i)                                            '
        OpenFiles(i) = IIF$(ISNULL(T1P.FCB_.FilePath), "Tab " + FORMAT$(i), T1P.FCB_.FilePath)  ' Save the name
      NEXT i                                                      '
   END IF                                                         '

   IF gTabsNum > 1 THEN gDiffFileA = OpenFiles(2): T1Sel = 2      ' Default 1st 2 tabs if possible
   IF gTabsNum > 2 THEN gDiffFileB = OpenFiles(3): T2Sel = 3      '

   '-----------------------------------------------------------------------------------------------+
   '- See if the DIFF LIST option                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 1 AND PTBL.IsKwd("LIST") THEN                 ' A single LIST operand
      GetDir2Array(gENV.Homedata + "CLIP\" + "_DIFF*.CLIP", DIFFs(), DIFFCount)   '
      IF DIFFCount = 0 THEN MErrExit(%eFail, "There are no available DIFF reports to view")  '
      DIM DIFFList(1 TO DiffCount, 4) AS STRING                   '

      '--------------------------------------------------------------------------------------------+
      '- Break out the Date/Cols/FileA/FileB from the names, sort in descending Date/Time          |
      '--------------------------------------------------------------------------------------------+
      j = 0                                                       '
      FOR i = DiffCount TO 1 STEP -1                              ' Loop through them
         INCR j                                                   '
         DIFFList(j, 1) = MID$(DIFFs(i), 7, 2) + "-" + MID$(DIFFs(i), 9, 2) + "-" + MID$(DIFFs(i), 11, 2) + " " + MID$(DIFFs(i), 14, 2) + ":" +  MID$(Diffs(i), 16, 2)  '
         DIFFList(j, 2) = IIF$(MID$(DIFFs(i), 19, 2) = "1C", "1 Col", "2 Col")   '
         DIFFList(j, 3) = LEFT$(MID$(DIFFs(i), 22), INSTR(MID$(DIFFs(i), 22), "~~") - 1)  '
         DIFFList(j, 4) = MID$(DIFFS(i), INSTR(DIFFs(i), "~~") + 2)  '
         DIFFList(j, 4) = CLIP$(RIGHT, DIFFList(j, 4), 5)         ' remove .CLIP
      NEXT i                                                      '

      DIALOG FONT DEFAULT "Tahoma", 13 / gFontScale,0, 0          '
      DIALOG NEW ghWnd, "DIFF CLIP Selection", , , 450, 160, _    '
         %WS_POPUP OR %WS_BORDER OR %WS_DLGFRAME OR %WS_CAPTION OR _ '
         %WS_CLIPSIBLINGS OR %WS_VISIBLE OR %DS_MODALFRAME OR %DS_3DLOOK OR %DS_NOFAILCREATE OR _  '
         %DS_SETFONT, %WS_EX_CONTROLPARENT OR %WS_EX_LEFT OR %WS_EX_LTRREADING OR %WS_EX_RIGHTSCROLLBAR, TO ghDIFF   '
      DIALOG SET COLOR ghDIFF, %BLUE, %RGB_GAINSBORO              '
      CONTROL ADD IMAGEX,   ghDIFF, %Diff_Msg,   "a", 5, 3, 24, 24, %SS_ICON  '

      CONTROL ADD LABEL, ghDIFF, %DIFF_Text + 1, "Select which saved DIFF Report to view.", 35, 5, 150, 12  '
      CONTROL SET COLOR ghDIFF, %Diff_Text + 1, %BLUE, %RGB_GAINSBORO   '
      CONTROL ADD LISTVIEW, ghDIFF, %DIFF_ListBox, "", 35, 15, 400, 125, _ '
                            %WS_CHILD OR %WS_VISIBLE OR %WS_TABSTOP OR %LVS_REPORT OR %LVS_SHOWSELALWAYS OR %LVS_SINGLESEL '
      CONTROL SEND ghDIFF, %DIFF_ListBox, %LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0 TO i  ' Add full row select to the ListView control
      i OR= %LVS_EX_FULLROWSELECT                                 '
      CONTROL SEND ghDIFF, %DIFF_ListBox, %LVM_SETEXTENDEDLISTVIEWSTYLE, 0, i '
      CONTROL SET COLOR ghDIFF, %Diff_ListBox, %BLACK, %LTGRAY    '
      LISTVIEW INSERT COLUMN ghDIFF, %DIFF_ListBox, 1, "Date", 60, 0 '
      LISTVIEW INSERT COLUMN ghDIFF, %DIFF_ListBox, 2, "View", 30, 0 '
      LISTVIEW INSERT COLUMN ghDIFF, %DIFF_ListBox, 3, "FileA", 155, 0  '
      LISTVIEW INSERT COLUMN ghDIFF, %DIFF_ListBox, 4, "FileB", 155, 0  '
      FOR i = 1 TO DiffCount                                      '
         LISTVIEW INSERT ITEM ghDIFF, %DIFF_ListBox, i, 0, DIFFList(i, 1)  '
         LISTVIEW SET TEXT  ghDIFF, %DIFF_ListBox, i, 2, DIFFList(i, 2) '
         LISTVIEW SET TEXT  ghDIFF, %DIFF_ListBox, i, 3, me.FileAbbrev(DIFFList(i, 3), 45)   '
         LISTVIEW SET TEXT  ghDIFF, %DIFF_ListBox, i, 4, me.FileAbbrev(DIFFList(i, 4), 45)   '
      NEXT i                                                      '

      LISTVIEW SELECT ghDIFF, %DIFF_ListBox, 1                    '

      CONTROL ADD BUTTON,  ghDIFF, %DIFF_LCANCEL, "&Cancel", 375, 148, 40, 11, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER  '
      DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_LCANCEL), " Press Cancel to exit. ")   '


      DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_ListBox), " Select your desired DIFF report to view.")   '
      KbdPopSave                                                  ' Ready for pop-up
      DIALOG SHOW MODAL ghDIFF CALL DlgDiffListCallBack           '
      KbdPopRestore                                               ' Reset popup state
      IF gDIFFClipNo = 0 THEN MErrExit(%eNone, "DIFF Report list cancelled")  '

      '--------------------------------------------------------------------------------------------+
      '- Setup the selected DIFF Report                                                            |
      '--------------------------------------------------------------------------------------------+
      gENV.ClipCmd = LEFT$(Diffs(gDIFFClipNo), LEN(DIFFs(gDIFFClipNo)) - 5)   '
      FileListRecentAdd(gENV.Homedata + "CLIP\" + DIFFS(1), "")   ' Add to recent path

      TabAdd(%Clip OR %Diff OR %ClipLoad OR %ClipSave)            ' Add a new Tab
      TP.FCB_.SetupFN("", %ProfGetN, RCA)                         ' Setup null FN
      IF gSQL.TableExist("PDIFF") THEN                            ' If DIFF profile exists
         TP.FCB_.SetupProf("DIFF", RCA)                           ' Use it
      ELSE                                                        ' Else
         TP.FCB_.SetupProf("DEFAULT", RCA)                        ' Use DEFAULT
      END IF                                                      '
      TabInitFileData()                                           ' Let TabInit do the work
      PCommand = ""                                               '
      MExitMeth                                                   '
   END IF                                                         '

   IF PTBL.OpsNum = 0 THEN GOTO DoPopUpBox                        ' Zero operands? Then go do Pop-Up immediately

   '-----------------------------------------------------------------------------------------------+
   '- Process the operands                                                                         |
   '-----------------------------------------------------------------------------------------------+
   RESET gDiffFileA, gDiffFileB, T1, T2, T1Sel, T2Sel             ' Start over

   '-----------------------------------------------------------------------------------------------+
   '- Process numeric operands                                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.GotNum > 0 THEN                                        ' A number available?
      IF T1 = 0 AND gDiffFileA = "" THEN                          ' Got T1 yet?
         T1 = VAL(PTBL.Pos("#", 1))                               ' Pick up T1
         IF T1 < 2 OR T1 > gTabsNum THEN _                        ' Valid tab numbers?
            MErrExit(%eFail, "DIFF - Tab # operand " + PTBL.Pos("#", 1) + " is invalid")  ' Kill if errors
         T1Sel = T1                                               '
         T1P = gTabs(T1)                                          ' Point at the tab
         gDiffFileA = IIF$(ISNULL(T1P.FCB_.FilePath), "Tab " + FORMAT$(T1), T1P.FCB_.FilePath)  ' Save the name
      END IF                                                      '
   END IF                                                         '
   IF PTBL.GotNum > 1 THEN                                        ' A 2nd number available?
      IF T2 = 0 AND gDiffFileB = "" THEN                          ' Got T2 yet?
         T2 = VAL(PTBL.Pos("#", 2))                               ' Pick up T2
         IF T2 < 2 OR T2 > gTabsNum THEN _                        ' Valid tab numbers?
            MErrExit(%eFail, "DIFF - Tab # operand " + PTBL.Pos("#", 2) + " is invalid")  ' Kill if errors
         T2Sel = T2                                               '
         T1P = gTabs(T2)                                          ' Point at the tab
         gDiffFileB = IIF$(ISNULL(T1P.FCB_.FilePath), "Tab " + FORMAT$(T2), T1P.FCB_.FilePath)  ' Save the name
      ELSE                                                        '
         MErrExit(%eFail, "DIFF - Unknown/Extraneous operand detected") ' Kill if errors
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Process a string operand                                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.GotLit > 0 THEN                                        ' String operands?
      t = PTBL.Pos2(1)                                            ' Get first
      StrUnQuote(t)                                               ' Remove any quotes

      '--------------------------------------------------------------------------------------------+
      '- See if a filename that's already Open, else Open it                                       |
      '--------------------------------------------------------------------------------------------+
      IF gDiffFileA = "" AND T1 = 0 THEN                          ' No FileA yet?
         gDiffFileA = t                                           ' Stuff it here
         T1 = VAL(FileQueue("S", " ", gDiffFileA))                ' Find it Open?
         IF T1 = 0 THEN                                           ' No, let's try opening it
            me.pCmdEdit("EDIT " + $DQ + gDiffFileA + $DQ)         ' Try an Edit
            T1 = VAL(FileQueue("S", " ", gDiffFileA))             ' Find it now?
            IF T1 = 0 THEN _                                      ' Still No?
                  MErrExit(%eFail, "DIFF - FileA filename could not be opened")  ' Kill if errors
            FOR j = 2 TO 500                                      ' See if in OpenFiles list
               IF OpenFiles(j) = gDiffFileA THEN EXIT FOR         ' Present? Leave
               IF OpenFiles(j) = "" THEN                          ' End of list?
                  OpenFiles(j) = gDiffFileA                       ' Yes, add this item
                  EXIT FOR                                        ' We're done
               END IF                                             '
            NEXT j                                                '
         END IF                                                   '

      ELSEIF gDiffFileB = "" AND T2 = 0 THEN                      ' FileB?
         gDiffFileB = t                                           ' Stuff it here
         T2 = VAL(FileQueue("S", " ", gDiffFileB))                ' Find it Open?
         IF T2 = 0 THEN                                           ' No, let's try opening it
            me.pCmdEdit("EDIT " + $DQ + gDiffFileB + $DQ)         ' Try an Edit
            T2 = VAL(FileQueue("S", " ", gDiffFileB))             ' Find it now?
            IF T2 = 0 THEN _                                      ' Still No?
                  MErrExit(%eFail, "DIFF - FileB filename could not be opened")  ' Kill if errors
            FOR j = 2 TO 500                                      ' See if in OpenFiles list
               IF OpenFiles(j) = gDiffFileB THEN EXIT FOR         ' Present? Leave
               IF OpenFiles(j) = "" THEN                          ' End of list?
                  OpenFiles(j) = gDiffFileB                       ' Yes, add this item
                  EXIT FOR                                        ' We're done
               END IF                                             '
            NEXT j                                                '
         END IF                                                   '
      ELSE                                                        '
         MErrExit(%eFail, "DIFF - unknown operand: " + t)         '
      END IF                                                      '
   END IF                                                         '
   IF PTBL.GotLit > 1 THEN                                        ' Anther string operands?
      t = PTBL.Pos2(2)                                            ' Get first
      StrUnQuote(t)                                               ' Remove any quotes
      IF gDiffFileB = "" AND T2 = 0 THEN                          ' FileB?
         gDiffFileB = t                                           ' Stuff it here
         T2 = VAL(FileQueue("S", " ", gDiffFileB))                ' Find it Open?
         IF T2 = 0 THEN                                           ' No, let's try opening it
            me.pCmdEdit("EDIT " + $DQ + gDiffFileB + $DQ)         ' Try an Edit
            T2 = VAL(FileQueue("S", " ", gDiffFileB))             ' Find it now?
            IF T2 = 0 THEN _                                      ' Still No?
                  MErrExit(%eFail, "DIFF - FileB filename could not be opened")  ' Kill if errors
            FOR j = 2 TO 500                                      ' See if in OpenFiles list
               IF OpenFiles(j) = gDiffFileB THEN EXIT FOR         ' Present? Leave
               IF OpenFiles(j) = "" THEN                          ' End of list?
                  OpenFiles(j) = gDiffFileB                       ' Yes, add this item
                  EXIT FOR                                        ' We're done
               END IF                                             '
            NEXT j                                                '
         END IF                                                   '
      ELSE                                                        '
         MErrExit(%eFail, "DIFF - unknown operand: " + t)         '
      END IF                                                      '
   END IF                                                         '


   '-----------------------------------------------------------------------------------------------+
   '- See if we're popping up a dialog box to get our parameters                                   |
   '-----------------------------------------------------------------------------------------------+
   DoPopUpBox:                                                    '

   '-----------------------------------------------------------------------------------------------+
   '- Determine T1Sel/T2Sel                                                                        |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 2 TO 500                                               ' See if in OpenFiles list
      IF OpenFiles(i) = gDiffFileA THEN T1Sel = i: EXIT FOR       ' Set T1Sel index and leave
   NEXT i                                                         '
   FOR i = 2 TO 500                                               ' See if in OpenFiles list
      IF OpenFiles(i) = gDiffFileB THEN T2Sel = i: EXIT FOR       ' Set T2Sel index and leave
   NEXT i                                                         '

   DIALOG FONT DEFAULT "Tahoma", 12 / gFontScale, 0, 0            '
   DIALOG NEW PIXELS, ghWnd, "SPFLite DIFF Options", , , 750, 350, %WS_CAPTION TO ghDIFF  '
   DIALOG SET COLOR ghDIFF, %RGB_GAINSBORO, %RGB_GAINSBORO        '
   CONTROL ADD IMAGEX,   ghDIFF, %Diff_Msg,   "a", 5, 5, 32, 32, %SS_ICON  '
   CONTROL ADD LABEL,    ghDIFF, %DIFF_Msg+1, "Please select the two files to be compared, and the relevant options.", 75,  10, 500, 20   '
   CONTROL SET COLOR     ghDIFF, %DIFF_Msg+1, %BLUE, %RGB_GAINSBORO  '

   '-----------------------------------------------------------------------------------------------+
   '- Add the file select boxes for FileA                                                          |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghDIFF, %DIFF_FileA_Text, "FileA", 5,  42,  90, 20   '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileA_Text, %RGB_DARKBLUE, %RGB_GAINSBORO '
   CONTROL ADD COMBOBOX, ghDIFF, %DIFF_FileA, OpenFiles(), 75, 40, 670, 300, %CBS_DROPDOWNLIST OR %WS_VSCROLL  '
   COMBOBOX SELECT ghDIFF,%DIFF_FileA, T1Sel                      '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileA), " Select the file you want to consider the 'old' or 'base' file ") '

   '-----------------------------------------------------------------------------------------------+
   '- Add the LB/RB inputs                                                                         |
   '-----------------------------------------------------------------------------------------------+
   t = FORMAT$(gENV.DiffALB) + ", " + IIF$(gENV.DiffARB = 0, "MAX", FORMAT$(gENV.DiffARB))   '
   CONTROL ADD LABEL,    ghDIFF, %DIFF_FileA_Bounds_Text, "Limit comparison to BOUNDS", 75, 73, 275, 20  '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileA_Bounds_Text, %RGB_BLUE, %RGB_GAINSBORO '
   CONTROL ADD TEXTBOX,  ghDIFF, %DIFF_FileA_Bounds, t, 310, 73, 75, 20, %WS_BORDER OR %WS_TABSTOP OR %ES_LEFT OR %ES_AUTOHSCROLL   '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileA_Bounds), "Enter the BOUNDS for comparison purposes. ")   '
   CONTROL ADD BUTTON,   ghDIFF, %DIFF_FileA_Choose, "Open Other", 645, 73, 100, 24, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER  '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileA_Choose), " Press to Open and Select another file. ")  '

   '-----------------------------------------------------------------------------------------------+
   '- Add the NX Radio boxes                                                                       |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghDIFF, %DIFF_FileA_Exclude, "Lines to Exclude from DIFF:", 75, 95, 275, 20  '
   CONTROL ADD OPTION,   ghDIFF, %DIFF_FileA_NXNone, "None", 310, 95, 85, 20, %WS_GROUP OR %WS_TABSTOP   '
   CONTROL ADD OPTION,   ghDIFF, %DIFF_FileA_NX,    "NX Lines", 400, 95, 85, 20  '
   CONTROL ADD OPTION,   ghDIFF, %DIFF_FileA_X,     "X Lines", 490, 95, 85, 20   '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileA_Exclude, %BLUE, %RGB_GAINSBORO   '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileA_NXNone, %BLUE, %RGB_GAINSBORO '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileA_NX, %BLUE, %RGB_GAINSBORO  '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileA_X, %BLUE, %RGB_GAINSBORO   '
   IF gENV.DiffANX = 0 AND gENV.DiffAX = 0 THEN CONTROL SET OPTION ghDIFF, %DIFF_FileA_NXNone, %DIFF_FileA_NXNone, %DIFF_FileA_X '
   IF gENV.DiffANX = 1 AND gENV.DiffAX = 0 THEN CONTROL SET OPTION ghDIFF, %DIFF_FileA_NX, %DIFF_FileA_NXNone, %DIFF_FileA_X  '
   IF gENV.DiffANX = 0 AND gENV.DiffAX = 1 THEN CONTROL SET OPTION ghDIFF, %DIFF_FileA_X, %DIFF_FileA_NXNone, %DIFF_FileA_X   '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileA_NXNone), "Select to compare ALL lines in the file. ") '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileA_NX), "Select to exclude all Non-X'd lines in the file. ")   '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileA_X), "Select to exclude all X'd lines in the file. ")  '

   '-----------------------------------------------------------------------------------------------+
   '- Add the file select boxes for FileB                                                          |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghDIFF, %DIFF_FileB_Text, "FileB", 5,  120,  90, 20  '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileB_Text, %RGB_DARKBLUE, %RGB_GAINSBORO '
   CONTROL ADD COMBOBOX, ghDIFF, %DIFF_FileB, OpenFiles(), 75, 120, 670, 300, %CBS_DROPDOWNLIST OR %WS_VSCROLL '
   COMBOBOX SELECT ghDIFF,%DIFF_FileB, T2Sel                      '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileB), " Select the file you want to consider the 'old' or 'base' file ") '

   '-----------------------------------------------------------------------------------------------+
   '- Add the LB/RB inputs                                                                         |
   '-----------------------------------------------------------------------------------------------+
   t = FORMAT$(gENV.DiffBLB) + ", " + IIF$(gENV.DiffBRB = 0, "MAX", FORMAT$(gENV.DiffBRB))   '
   CONTROL ADD LABEL,    ghDIFF, %DIFF_FileB_Bounds_Text, "Limit comparison to BOUNDS", 75, 153, 275, 20 '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileB_Bounds_Text, %RGB_BLUE, %RGB_GAINSBORO '
   CONTROL ADD TEXTBOX,  ghDIFF, %DIFF_FileB_Bounds, t, 310, 153, 75, 20, %WS_BORDER OR %WS_TABSTOP OR %ES_LEFT OR %ES_AUTOHSCROLL  '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileB_Bounds), "Enter the BOUNDS for comparison purposes. ")   '
   CONTROL ADD BUTTON,   ghDIFF, %DIFF_FileB_Choose, "Open Other", 645, 153, 100, 24, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileB_Choose), " Press to Open and Select another file. ")  '

   '-----------------------------------------------------------------------------------------------+
   '- Add the NX Radio boxes                                                                       |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghDIFF, %DIFF_FileB_Exclude, "Lines to Exclude from DIFF:", 75, 175, 275, 20 '
   CONTROL ADD OPTION,   ghDIFF, %DIFF_FileB_NXNone, "None", 310, 175, 85, 20, %WS_GROUP OR %WS_TABSTOP  '
   CONTROL ADD OPTION,   ghDIFF, %DIFF_FileB_NX,    "NX Lines", 400, 175, 85, 20 '
   CONTROL ADD OPTION,   ghDIFF, %DIFF_FileB_X,     "X Lines", 490, 175, 85, 20  '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileB_Exclude, %BLUE, %RGB_GAINSBORO   '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileB_NXNone, %BLUE, %RGB_GAINSBORO '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileB_NX, %BLUE, %RGB_GAINSBORO  '
   CONTROL SET COLOR     ghDIFF, %DIFF_FileB_X, %BLUE, %RGB_GAINSBORO   '
   IF gENV.DiffBNX = 0 AND gENV.DiffBX = 0 THEN CONTROL SET OPTION ghDIFF, %DIFF_FileB_NXNone, %DIFF_FileB_NXNone, %DIFF_FileB_X '
   IF gENV.DiffBNX = 1 AND gENV.DiffBX = 0 THEN CONTROL SET OPTION ghDIFF, %DIFF_FileB_NX, %DIFF_FileB_NXNone, %DIFF_FileB_X  '
   IF gENV.DiffBNX = 0 AND gENV.DiffBX = 1 THEN CONTROL SET OPTION ghDIFF, %DIFF_FileB_X, %DIFF_FileB_NXNone, %DIFF_FileB_X   '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileB_NXNone), "Select to compare ALL lines in the file. ") '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileB_NX), "Select to exclude all Non-X'd lines in the file. ")   '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_FileB_X), "Select to exclude all X'd lines in the file. ")  '

   '-----------------------------------------------------------------------------------------------+
   '- Add OPTIONS                                                                                  |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LINE,     ghDIFF, %Diff_Line1, "", 5, 205, 740, 4  '
   CONTROL ADD LABEL,    ghDIFF, %DIFF_Options, "Options", 5,  210,  90, 20   '
   CONTROL SET COLOR     ghDIFF, %DIFF_Options, %RGB_DARKBLUE, %RGB_GAINSBORO '

   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_NoSpace, "Ignore multiple spaces", 75, 210, 225, 20, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET COLOR     ghDIFF, %DIFF_NoSpace, %RGB_BLUE, %RGB_GAINSBORO  '
   CONTROL SET CHECK     ghDIFF, %DIFF_NoSpace, gENV.DiffNoSpace  '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoSpace), "Select to have multiple spaces treated as a single space. ") '
   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_NoCASE, "CASE insensitive compare", 450, 210, 225, 20, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET COLOR     ghDIFF, %DIFF_NoCASE, %RGB_BLUE, %RGB_GAINSBORO   '
   CONTROL SET CHECK     ghDIFF, %DIFF_NoCASE, gENV.DiffNoCASE    '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoSpace), "Select to have the CASE of text ignored in the compare. ")   '

   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_NoTabs, "Ignore Tabs", 75, 230, 150, 20, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET COLOR     ghDIFF, %DIFF_NoTabs, %RGB_BLUE, %RGB_GAINSBORO   '
   CONTROL SET CHECK     ghDIFF, %DIFF_NoTabs, gENV.DiffNoTab     '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoTabs), "Select to have TABS ignored in the comparison. ") '

   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_NoComment, "Ignore Comments", 450, 230, 150, 20, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET COLOR     ghDIFF, %DIFF_NoComment, %RGB_BLUE, %RGB_GAINSBORO   '
   CONTROL SET CHECK     ghDIFF, %DIFF_NoComment, gENV.DiffNoComment '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoComment), "Select to have Source comments ignored in the comparison. ")  '

   '-----------------------------------------------------------------------------------------------+
   '- Add the minmatch input                                                                       |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD LABEL,    ghDIFF, %DIFF_MinMatch_Text, "Min. # of matching lines to be called a 'Match'", 100, 250, 330, 20 '
   CONTROL SET COLOR     ghDIFF, %DIFF_MinMatch_Text, %RGB_BLUE, %RGB_GAINSBORO  '
   CONTROL ADD TEXTBOX,  ghDIFF, %DIFF_MinMatch, FORMAT$(gENV.DiffMinMatch), 75, 252, 22, 20, %ES_NUMBER OR %WS_BORDER OR %WS_TABSTOP OR %ES_LEFT OR %ES_AUTOHSCROLL '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_MinMatch), "Enter the number of consecutive matching lines needed to be considered being 'back in sync'. ") '

   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_NoMultB, "Collapse Blank Lines", 450, 250, 225, 20, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET COLOR     ghDIFF, %DIFF_NoMultB, %RGB_BLUE, %RGB_GAINSBORO  '
   CONTROL SET CHECK     ghDIFF, %DIFF_NoMultB, gENV.DiffNoMultB  '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoMultB), "Select to have consecutive Blank lines reduced to a single Blank line. ")   '

   CONTROL ADD LINE,     ghDIFF, %Diff_Line2, "", 5, 278, 740, 4  '
   CONTROL ADD LABEL,    ghDIFF, %DIFF_View, "View", 5,  288,  90, 20   '
   CONTROL SET COLOR     ghDIFF, %DIFF_View, %RGB_DARKBLUE, %RGB_GAINSBORO '

   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_1Column, "Single column view", 75, 288, 225, 20, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET COLOR     ghDIFF, %DIFF_1Column, %RGB_BLUE, %RGB_GAINSBORO  '
   CONTROL SET CHECK     ghDIFF, %DIFF_1Column, gENV.Diff1Column  '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoSpace), "Select to choose a 1 column view, uncheck to have a 2 column view. ") '
   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_UseFileB, "Use FileB as source for unchanged lines", 95, 310, 325, 20, %BS_LEFT OR %BS_VCENTER  '
   CONTROL SET COLOR     ghDIFF, %DIFF_UseFileB, %RGB_BLUE, %RGB_GAINSBORO '
   CONTROL SET CHECK     ghDIFF, %DIFF_UseFileB, gENV.DiffUseFileB   '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoSpace), "Select to choose a 1 column view, uncheck to have a 2 column view. ") '
   CONTROL ADD CHECKBOX, ghDIFF, %DIFF_Only, "Do not display matching lines", 450, 288, 250, 20, %BS_LEFT OR %BS_VCENTER   '
   CONTROL SET COLOR     ghDIFF, %DIFF_Only, %RGB_BLUE, %RGB_GAINSBORO  '
   CONTROL SET CHECK     ghDIFF, %DIFF_Only, gENV.DiffOnly        '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_NoSpace), "Select to display only mis-matched lines. ")  '

   '-----------------------------------------------------------------------------------------------+
   '- Add Cancel and Done                                                                          |
   '-----------------------------------------------------------------------------------------------+
   CONTROL ADD BUTTON,  ghDIFF, %DIFF_Cancel, "&Cancel", 520, 320, 100, 24, %BS_VCENTER OR %BS_CENTER '
   DLGToolTipSet(GetDlgItem(ghWel, %DIFF_Cancel), " Press Cancel to exit and start over. ")  '
   CONTROL ADD BUTTON,  ghDIFF, %DIFF_Done, "&Done", 645, 320, 100, 24, %WS_BORDER OR %BS_VCENTER OR %BS_CENTER OR %BS_DEFAULT   '
   DLGToolTipSet(GetDlgItem(ghDIFF, %DIFF_Done), " Press Done once you have made your choices. ")  '
   CONTROL SET FOCUS ghDIFF, %DIFF_Done                           '
   KbdPopSave                                                     ' Ready for popup
   DIALOG SHOW MODAL ghDIFF CALL DlgDiffCallback                  ' Display it all
   KbdPopRestore                                                  ' Reset after popup

   '-----------------------------------------------------------------------------------------------+
   '- Convert the fileames to tab numbers                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF gDiffFileA = "" THEN MExitMeth                              ' If null, Cancel was selected

   FOR j = 2 TO gTabsNum                                          ' Search for it
      IF uucase(OpenFiles(j)) = uucase(gDiffFileA) THEN           ' Found it
         T1 = j: EXIT FOR                                         ' Save the index
      END IF                                                      '
   NEXT j                                                         '
   FOR j = 2 TO gTabsNum                                          ' Search for it
      IF uucase(OpenFiles(j)) = uucase(gDiffFileB) THEN           ' Found it
         T2 = j: EXIT FOR                                         ' Save the index
      END IF                                                      '
   NEXT j                                                         '

   GotOperands:                                                   '
   '-----------------------------------------------------------------------------------------------+
   '- Ensure have all the pieces                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF T1 = 0 THEN                                                 ' No FileA yet?
      IF gDiffFileA = "" THEN                                     ' and no FileA filename?
         MErrExit(%eFail, "DIFF - No FileA operand detected")     ' Kill if errors
      ELSE                                                        ' See if filename is useable
         T1 = VAL(FileQueue("S", " ", gDiffFileA))                ' Find it?
         IF T1 = 0 THEN                                           ' No, let's try opening it
            me.pCmdEdit("EDIT " + $DQ + gDiffFileA + $DQ)         ' Try an Edit
            T1 = VAL(FileQueue("S", " ", gDiffFileA))             ' Find it now?
            IF T1 = 0 THEN _                                      ' Still No?
               MErrExit(%eFail, "DIFF - FileA filename could not be opened")  ' Kill if errors
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
   IF T2 = 0 THEN                                                 ' No FileB yet?
      IF gDiffFileB = "" THEN                                     ' and no FileB filename?
         MErrExit(%eFail, "DIFF - No FileB operand detected")     ' Kill if errors
      ELSE                                                        ' See if filename is useable
         T2 = VAL(FileQueue("S", " ", gDiffFileB))                ' Find it?
         IF T2 = 0 THEN                                           ' No, let's try opening it
            me.pCmdEdit("EDIT " + $DQ + gDiffFileB + $DQ)         ' Try an Edit
            T2 = VAL(FileQueue("S", " ", gDiffFileB))             ' Find it now?
            IF T2 = 0 THEN _                                      ' Still No?
               MErrExit(%eFail, "DIFF - FileB filename could not be opened")  ' Kill if errors
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Access the tab data                                                                          |
   '-----------------------------------------------------------------------------------------------+
   DiffAllSet:                                                    '
   T1P = gTabs(T1): T2P = gTabs(T2)                               ' Point at the tabs data
   FileA = T1P.FCB_.FilePath: FileB = T2P.FCB_.FilePath           ' Get the edit filenames
   FileADate = DIR$(FileA, TO T1FD):  FileBDate = DIR$(FileB, TO T2FD)  ' Get their directory entries
   FileADate = TimePretty(T1FD.LastWriteTime)                     ' Format LWTimes
   FileBDate = TimePretty(T2FD.LastWriteTime)                     '

   lclFlags = 0                                                   ' Build FileA flags
   IF gENV.DiffNospace   THEN lclFlags OR= %NoSpaces              '
   IF gENV.DiffNoComment THEN lclFlags OR= %NoComments            '
   IF gENV.DiffNoTab     THEN lclFlags OR= %NoTabs                '
   IF gENV.DiffNoCASE    THEN lclFlags OR= %NoCASE                '
   IF gENV.DiffNoMultB   THEN lclFlags OR= %NoMultB               '
   IF gENV.DiffANX       THEN lclFlags OR= %NoNX                  '
   IF gENV.DiffAX        THEN lclFlags OR= %NoX                   '
   IF gENV.DiffUseFileB  THEN lclFlags OR= %UseFileB              '
   DiffInitStream(StrmA, T1P, TxtA(), gENV.DiffALB, gENV.DiffARB, lclFlags)   ' Load lines from the tab
   IF gENV.DiffNoComment THEN                                     ' Need colorize data?
      IF DiffLoadClr(StrmA, FileA) THEN                           ' Go get it
         MErrExit(%eFail, "DIFF - NoComments requires AUTO data, FileA has no AUTO file") ' Kill if errors
      END IF                                                      '
   END IF                                                         '
   lclFlags = 0                                                   ' Build FileB flags
   IF gENV.DiffNospace   THEN lclFlags OR= %NoSpaces              '
   IF gENV.DiffNoComment THEN lclFlags OR= %NoComments            '
   IF gENV.DiffNoTab     THEN lclFlags OR= %NoTabs                '
   IF gENV.DiffNoCASE    THEN lclFlags OR= %NoCASE                '
   IF gENV.DiffNoMultB   THEN lclFlags OR= %NoMultB               '
   IF gENV.DiffBNX       THEN lclFlags OR= %NoNX                  '
   IF gENV.DiffBX        THEN lclFlags OR= %NoX                   '
   IF gENV.DiffUseFileB  THEN lclFlags OR= %UseFileB              '
   DiffInitStream(StrmB, T2P, TxtB(), gENV.DiffBLB, gENV.DiffBRB, lclFlags)   '
   IF gENV.DiffNoComment THEN                                     ' Need colorize data?
      IF DiffLoadClr(StrmB, FileB) THEN                           ' Go get it
         MErrExit(%eFail, "DIFF - NoComments requires AUTO data, FileB has no AUTO file") ' Kill if errors
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- See what headings to do                                                                      |
   '-----------------------------------------------------------------------------------------------+
   CBDate = RIGHT$(DATE$, 2) + LEFT$(DATE$, 2) + MID$(DATE$, 4, 2) + "." + LEFT$(TIME$, 2) + MID$(TIME$, 4,2)  '
   CBName = "_DIFF." + CBDate + IIF$(gENV.Diff1Column, ".1C.", ".2C.") + T1P.FCB_.File + "~~" + T2P.FCB_.File  ' Build a clipboard name
   gENV.CLIPCmd = CBName                                          '
   gKeyPrimOper = CBName                                          ' (DiffCB will pick it up)
   DiffCB("", "R")                                                ' Do a CLIPBOARD RESET
   DiffCB("", "H")                                                ' Set to Header mode
   gKeyPrimOper = ""                                              ' Remove it
   DiffCB("C|SPFLite Diff 999999")                                ' Output Diff Eyeball
   DiffCB("N|***** SPFLite DIFF Report *****")                    ' Print headings
   DiffCB("N|FileA: " + IIF$(FileADate > FileBDate, " - (Newer) " + FileADate, " -         " + FileADate) + " - " + FileA) '
   IF gENV.DiffALB <> 1 OR gENV.DiffARB <> 0 OR _                 '
      gENV.DiffANX OR gENV.DiffAX THEN                            '
      t = ""                                                      '
      IF gENV.DiffALB <> 1 OR gENV.DiffARB <> 0 THEN t = "Bounds are " + FORMAT$(gENV.DiffALB) + "," + IIF$(gENV.DiffARB = 0, "MAX", FORMAT$(gENV.DiffARB)) '
      IF gENV.DiffANX THEN t += ", Ignore NX lines "              '
      IF gENV.DiffAX THEN t += ", Ignore X lines "                '
      DiffCB("N|        -         " + t)                          '
   END IF                                                         '
   DiffCB("N|FileB: " + IIF$(FileBDate > FileADate, " - (Newer) " + FileBDate, " -         " + FileBDate) + " - " + FileB) '
   IF gENV.DiffBLB <> 1 OR gENV.DiffBRB <> 0 OR _                 '
      gENV.DiffBNX OR gENV.DiffBX THEN                            '
      t = ""                                                      '
      IF gENV.DiffBLB <> 1 OR gENV.DiffBRB <> 0 THEN t = "Bounds are " + FORMAT$(gENV.DiffBLB) + "," + IIF$(gENV.DiffBRB = 0, "MAX", FORMAT$(gENV.DiffBRB)) '
      IF gENV.DiffBNX THEN t += ", Ignore NX lines "              '
      IF gENV.DiffBX THEN t += ", Ignore X lines "                '
      DiffCB("N|        -         " + t)                          '
   END IF                                                         '
   DiffCB("N|Options -         " + IIF$(gENV.DiffNoSpace, "NOSPACES, ", "") + IIF$(gENV.DiffNoTab, "NOTABS, ", "") + IIF$(gENV.DiffNoComment, "NOCOMMENTS, ", "") + IIF$(gENV.DiffNoCASE, "NOCASE, ", "") + _  '
           IIF$(gENV.DiffOnly, "NOMATCHING, ", "") + IIF$(gENV.DiffUseFileB AND gENV.Diff1Column, "USEFILEB, ", "") + "Match criteria = " + FORMAT$(gENV.DiffMinMatch) + " lines")  '
   IF (gENV.Diff1Column) THEN                                     ' 1Column
      tt1 = STRING$(@P.PDataLen - 12, "*")                        '
      MID$(tt1, (@P.PDataLen - 23) \ 2 + 1, 11) = " Text Data "   '
      DiffCB("N|FileA FileB " + tt1)                              '
   ELSE                                                           '
      i = (@P.PDataLen - 3) \ 2                                   ' Calc column width
      gDiffColWidth = i                                           ' Save it for the COLS routine
      tt1 = STRING$(i - 6, "*")                                   ' Column header
      MID$(tt1, (i - 18) \ 2 + 1, 12) = " FileA Data "            '
      tt2 = STRING$(i - 6, "*")                                   ' Column header
      MID$(tt2, (i - 18) \ 2 + 1, 12) = " FileB Data "            '
      DiffCB("N|***** " + tt1 + "   ***** " + tt2)                '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- OK, go do the DIFF stuff                                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF StrmA.Cursor > StrmA.Last THEN DiffCB("N| FileA is empty.") ' Tell of NULL files
   IF StrmB.Cursor > StrmB.Last THEN DiffCB("N| FileB is empty.") '

   IF ISTRUE StrmA.Last AND ISTRUE StrmB.Last THEN                ' Both files have records
      DiffCB("", "B")                                             ' Set to Body mode
      DiffCompFiles(StrmA, StrmB)                                 ' Go do the compare
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Do the wrap-up                                                                               |
   '-----------------------------------------------------------------------------------------------+
   DiffCB("", "W")                                                ' Write the Clipboard
   RESET TxtA(), TxtB()                                           ' Free the tables

   TabAdd(%Clip OR %Diff OR %ClipLoad OR %ClipSave)               ' Add a new Tab
   TP.FCB_.SetupFN("", %ProfGetY, RCA)                            ' Setup null FN
   TabInitFileData()                                              ' Let TabInit do the work
   PCommand = "": SetCmd                                          '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdDIR(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Open FM to current file's DIR                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lclPath, lclFn AS STRING, i AS LONG                         '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H DIR"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsSetEdit OR IsClip OR IsEFTEdit THEN MErrExit(%eFail, "This tab has no implied DIR folder") ' Ineligible tab?
   lclPath = FCB.Path                                             ' Get the path

   IF IsMEdit THEN                                                ' For MEdit, make sure all paths are the same
      FOR i = 1 TO MEditCount                                     '
         lclFn = me.MEditListGet(i)                               ' Get filename from MEdit list
         IF lclpath <> LEFT$(lclFn, INSTR(-1, lclFn, "\") - 1) THEN MErrExit(%eFail, "All MEdit files are not from the same DIR folder")  '
      NEXT i                                                      '
   END IF                                                         '

   FMask = IIF$(PTBL.GotLit = 1, PTBL.Pos2(1), "*")               ' Set the FileMask for FM
   FPath = lclPath                                                ' Set the path
   gSQL.UpdateString("O", "DefMask", FMask)                       '
   gSQL.UpdateString("O", "DefDir1", FPath)                       ' Save it

   TP = gTabs(1)                                                  ' Swap the TP pointer
   TP.FileListNm = ""                                             ' Null any FILELIST setting
   TP.FPath = gSQL.GetString("O", "FileListNm", "")               '
   TP.FPath = gSQL.GetString("O", "DefDir1", "")                  '
   TP.FMask = gSQL.GetString("O", "DefMask", "")                  '
   @P.PTopLine = 1                                                ' From the top
   Lasttop = 0                                                    '
   TP.AttnDo = TP.AttnDo OR %LoadReq                              ' Refresh
   GoToTab(1, "", "")                                             ' Pass command to the FM tab
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdDO(pCmd AS STRING)                                    '
'--------------------------------------------------------------------------------------------------+
'- DO a text block or a .CMD file                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG                                                   '
LOCAL DMsg AS KBMsg                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H DO"), _                                      ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.GotLit = 0 THEN                                        ' If no CMD file name, error
      TP.ErrMsgAdd(%eFail, "Missing DO file name")                '
      MExitMeth                                                   '
   END IF                                                         '

   i = DOCmdLoadMac(PTBL.Pos2(1))                                 ' Get the specified DO file loaded to gCmdList()
   IF i = 0 THEN                                                  '
      TP.ErrMsgAdd(%eFail, "Error loading " + PTBL.Pos2(1) + ".DO file")   '
      MExitMeth                                                   '
   END IF                                                         '

   MID$(DMsg.kbString, 1, 1) = CHR$(5)                            ' Flag 1st byte as Hex 5 - DO execute
   MID$(DMsg.kbString, 2, 1) = CHR$(0)                            ' Flag 2nd byte as null
   DMsg.kbInt(1) = 0                                              ' Copy Int as zero
   i = PostMessage(ghWnd, %WM_USER, DMsg.MsgwParam, 0)            ' To the mainline Callback routine
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdDOWN(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Scroll Down                                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL ScrAmt, Lines2Page AS LONG                                  '
LOCAL ScrCmd AS STRING                                            '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H DOWN"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum > 1 THEN _                                      ' Better be just one operand
      MErrExit(%eFail, "Invalid scroll amount")                   '
   IF PTBL.OpsNum = 0 THEN                                        ' No Ops, fudge it
      ScrCmd = FCB.ScrollAmt                                      ' Pick up Profile value
   ELSE                                                           '
      ScrCmd = PTBL.Grp("SCROLL")                                 ' Else pick up from command
      IF ISNULL(ScrCmd) THEN ScrCmd = PTBL.Pos("#", 1)            ' If not Kwd, then fetch the #
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle the various scroll types, set ScrAmt appropriately                                    |
   '-----------------------------------------------------------------------------------------------+
   IF VAL(ScrCmd) <> 0 THEN                                       ' A Number?
      ScrAmt = VAL(ScrCmd)                                        ' Yes, use it
   ELSEIF ScrCmd = "HALF" THEN                                    ' Half?
      ScrAmt = INT((@P.PBottom - @P.PData1) / 2)                  ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   ELSEIF ScrCmd = "PAGE" THEN                                    ' Page?
      ScrAmt = INT(@P.PBottom - @P.PData1 + 1)                    ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
      FCB.ScrlPageSus = %False                                    ' Clear suspend PAGE mode
   ELSEIF ScrCmd = "FULL" THEN                                    ' Full?
      ScrAmt = INT(@P.PBottom - @P.PData1)                        ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   ELSEIF ScrCmd = "DATA" THEN                                    ' Data?
      ScrAmt = INT(@P.PBottom - @P.PData1)                        ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   ELSEIF ScrCmd = "MAX" THEN                                     ' Max?
      ScrAmt = 9999999                                            ' Yes, set a BIG number
   ELSEIF IsCData THEN                                            ' No, In data area?
      IF @P.PTopLine = @P.C.CIX THEN                              ' If Cursor at top of data area
         ScrAmt = @P.PBottom - @P.PData1                          ' Do a full page
         ScrAmt = ScrAmt \ FCB.HexMode                            ' Adjust for Hex
      ELSE                                                        '
         @P.PTopLine = @P.C.CIX                                   '
         ErrMsgHigh = %eNone                                      ' Say we've done it
         MExitMeth                                                '
      END IF                                                      '
   ELSEIF IsCLinN THEN                                            ' No, In Line Number area?
      IF @P.PTopLine = @P.C.CIX THEN                              ' If Cursor at top of data area
         ScrAmt = @P.PBottom - @P.PData1                          ' Do a full page
         ScrAmt = ScrAmt \ FCB.HexMode                            ' Adjust for Hex
      ELSE                                                        '
         @P.PTopLine = @P.C.CIX                                   '
         ErrMsgHigh = %eNone                                      ' Say we've done it
         MExitMeth                                                '
      END IF                                                      '
   ELSE                                                           '
      ScrAmt = @P.PDLines - 1                                     ' None of above, Scroll forward one screen - 1 line
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Adjust the top of screen location now                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(FCB.EOL, 4) = "AUTO" AND ScrCmd = "PAGE" THEN         ' Page in EOL=AUTO mode?
      IF FCB.PageFlag = 2 THEN                                    ' Page in EOL=AUTO mode and not overridden?
         Lines2Page = me.CRPFwd2Page                              ' Get # lines to next =PAGE> line (or eof)
         IF Lines2Page <= (@P.PBottom - @P.PTop) THEN             ' Did this page all fit on the screen?
            @P.PTopLine = me.CRPFwd(%mPage, @P.PTopLine, 1)       ' Move TopScrn by a PAGE
         ELSE                                                     '
            ScrAmt = INT(@P.PBottom - @P.PTop)                    ' Calc like FULL does
            ScrAmt = ScrAmt \ FCB.HexMode                         '
            @P.PTopLine = me.CRPFwd(%mVisible, @P.PTopLine, ScrAmt)  ' Move TopScrn by scroll amount
            FCB.ScrlPageSus = %False                              '
         END IF                                                   '
      ELSEIF FCB.PageFlag = 1 THEN                                ' Just PAGE ON?
         @P.PTopLine = me.CRPFwd(%mPage, @P.PTopLine, 1)          ' Move TopScrn by a PAGE
      ELSE                                                        '
         @P.PTopLine = me.CRPFwd(%mVisible, @P.PTopLine, ScrAmt)  ' Move TopScrn by scroll amount
      END IF                                                      '
   ELSE                                                           ' Not AUTO PAGE
      @P.PTopLine = me.CRPFwd(%mVisible, @P.PTopLine, ScrAmt)     ' Move TopScrn by scroll amount
      IF ScrCmd = "MAX" THEN                                      ' If down max, backup by one screen
         ScrAmt = @P.PBottom - @P.PData1 - 1                      ' Do a full page
         ScrAmt = ScrAmt \ FCB.HexMode                            ' Adjust for Hex
         @P.PTopLine = me.CRPBack(%mVisible, @P.PTopLine, ScrAmt) '
      END IF                                                      '
   END IF                                                         '
   ErrMsgHigh = %eNone                                            ' Say we 've done it
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdEDIT(pCmd AS STRING)                                  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H EDIT"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.pCmdBEVOpen(%Edit, "EDIT")                                  ' Pass to BEV to do
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdEFT(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Handle EFT Command                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, x, ctab, tLen, TestCtr AS LONG, MSG, fn AS STRING  '
LOCAL RC AS LONG, PDiag, t, tt, RGEX AS STRING, RCA AS RCArea     '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H EFT"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum > 0 THEN GOTO TestMode                          ' Possible TEST mode
   IF IsEFTActive THEN                                            ' Make sure EFTEdit is not active
      MErrExit(%eFail, "An EFT Edit is currently active")         '
   END IF                                                         '
   ClipBoardGet(gSetClipB)                                        '

   FOR i = 1 TO gEFTRawCtr                                        '
      MSG += gEFTRaw(i) + $CRLF                                   ' Add to CBD
   NEXT i                                                         '
   ClipBoardSet(MSG)                                              ' Send it to the Clipboard

   TabAdd(%EFTEdit OR %ClipLoad)                                  ' Add a new Tab
   TP.FCB_.SetupFN("", %ProfGetN, RCA)                            ' Setup null FN
   IF gSQL.TableExist("PEFTEdit") THEN                            ' If EFT profile exists
      TP.FCB_.SetupProf("EFTEdit", RCA)                           ' Use it
   ELSE                                                           ' Else
      TP.FCB_.SetupProf("DEFAULT", RCA)                           ' Use DEFAULT
   END IF                                                         '
   TabInitFileData()                                              ' Let TabInit do the work
   gENV.SETETab = TP.PgNumber                                     ' Save current tab number
   PCommand = ""                                                  '
   MexitMeth                                                      ' Done here, continue in END command

TestMode:                                                         '
   t = PCRERegexCompile("^(.*)\\[^\\]*\.PBPRJ$")                  '
   PCRERegexTest("abc.PBPRJ", 1, j, k)                            ' See if we can find it
   IF ISFALSE IsEFTEdit THEN MErrExit(%eFail, "EFT TEST is only available in an EFT Edit session") '
   IF PTBL.OpsNum <> 2 THEN MErrExit(%eFail, "EFT command - incorrect # of operands")  '
   IF ISFALSE PTBL.IsKWD("TEST") THEN MErrExit(%eFail, "EFT command - unknown operand")   '
   IF IsFMTab THEN MErrExit(%eFail, "EFT TEST command not allowed in File Manager") '
   '-----------------------------------------------------------------------------------------------+
   '- Get the test filename                                                                        |
   '-----------------------------------------------------------------------------------------------+
   fn = uucase(PTBL.Pos2(1))                                      ' Get the filename
   StrUnquote(fn)                                                 ' Clear any quotes
   IF INSTR(FN, "\") = 0 THEN MErrExit(%eFail, "The test filename must be a full name, including Paath") '
   '-----------------------------------------------------------------------------------------------+
   '- Process the EFT data from the Edit session                                                   |
   '-----------------------------------------------------------------------------------------------+
   FOR x = 1 TO LastLine                                          ' Fetch the Data
      IF ISFALSE IsLData(x) THEN ITERATE FOR                      ' Skip non Data lines
      t = LTxtG(x)                                                ' Get a line
      tLen = LEN(t)                                               ' Save length
      t = uucase(TRIM$(t))                                        ' UC/Trim it
      tt = t                                                      ' Save original line

      '--------------------------------------------------------------------------------------------+
      '- Handle comments                                                                           |
      '--------------------------------------------------------------------------------------------+
      j = INSTR(t, ";")                                           ' See if a comment
      IF j THEN t = TRIM$(LEFT$(t, j - 1))                        ' Strip it off
      IF ISNULL(t) THEN ITERATE FOR                               ' Nothing left, ignore it

      '--------------------------------------------------------------------------------------------+
      '- See if a RegEx expression or not                                                          |
      '--------------------------------------------------------------------------------------------+
      IF LEFT$(t, 2) = "R'" OR _                                  ' Look like a RegEx?
         LEFT$(t, 2) = "R`" OR _                                  '
         LEFT$(t, 2) = "R" + $DQ THEN                             '
         j = INSTR(3, t, MID$(t, 2, 1))                           ' Look for trailing equal quote mark
         j = INSTR(j + 1, t, "=")                                 ' Finally, look for the = sign
         tt = TRIM$(LEFT$(t, j - 1))                              ' Get Mask value
         RGEX = MID$(tt, 3, LEN(tt) - 3)                          ' RegEX string
      ELSE                                                        '
         j = INSTR(t, "=")                                        ' Just search normally for the =
         tt = TRIM$(LEFT$(t, j - 1))                              ' Get Mask value
         StrUnquote(tt)                                           ' Remove any quotes
         RC = EFT_Translate(tt, RGEX, PDiag)                      ' Go see if it's valid
         IF ISFALSE RC THEN MErrExit(%eFail, PDiag + " - " + tt)  ' Report to the user if a failure
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Do a real RegEx test                                                                      |
      '--------------------------------------------------------------------------------------------+
      tt = PCRERegexCompile(RGEX)                                 ' Compile the RGEX string
      IF ISNOTNULL(tt) THEN MErrExit(%eFail, "PCE Compile failed: " + tt)  '
      PCRERegexTest(fn, 1, j, k)                                  ' See if it has our pattern
      IF j THEN                                                   ' It matches
         me.AttrInvSet(X, 1, tLen)                                ' Set for Hi-Lite
         INCR TestCtr                                             ' Count matches
      ELSE                                                        '
         me.AttrInvClear(X, 1, tLen)                              ' Set for Hi-Lite clear
      END IF                                                      '
   NEXT x                                                         '
   IF TestCtr = 0 THEN                                            ' Issue a message
      MErrExit(%eNone, "No EFT entries match the filename")       '
   ELSE                                                           '
      MErrExit(%eNone, FORMAT$(TestCtr) + " EFT entr" + IIF$(TestCtr = 1, "y ", "ies ") + "matched the filename and " + IIF$(TestCtr = 1, "was ", "were ") + "marked")  '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdEMACRO(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Alter the EMACRO setting                                                                        |
'--------------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- Pass off to common parse routine                                                             |
   '-----------------------------------------------------------------------------------------------+
   pCmdXIMacro(pCmd, "EMACRO")                                    ' Call common routine
END METHOD                                                        '

METHOD  pCmdEND(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Terminate the whole thing now                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, x, FNum, keep, SaveOK, SaveTop, lclModdFlag AS LONG, RCA AS RCArea   '
LOCAL MaskType, fline, tline, FCount, MCount, tRawCtr, PCREAns, PKeep AS LONG '
LOCAL t, tt, fn, PDiag, macname, stamp, EFTStr, EFTMask, EFTProf, EFTOper AS STRING '
LOCAL SetKey AS STRING                                            '
LOCAL txtP AS ASCIIZ PTR                                          '
LOCAL fnlist(), tRaw() AS STRING                                  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H END"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   ON ERROR GOTO EndBail                                          ' Set trap
   PKeep = PTBL.IsKwd("KEEP")                                     ' Get optional KEEP flags
   CurrPcmd = "END"                                               ' Make getting here via =X or RETURN look the same as END
   @P.C.CType = %CBad                                             ' So no false line range used

   IF IsClip THEN                                                 ' A CLIP session?
      IF LEFT$(ClipName, 1) <> "_" THEN                           ' And not a temp ClipBoard
         IF FCB.AutoBkup AND ISFALSE IsBackupDone AND IsModdFlag THEN   ' Need to create BKP file?
            DoBackup("!" + ClipFile, TP.TabMode, RCA)             ' Go try it and get message result
            IF RCA.RC > 4 THEN TP.ErrMsgAdd(%eFail, "Failed to create BACKUP of CLIP file")  ' Error msg
         END IF                                                   '
      END IF                                                      '
      GOSUB DoSpecEMacro                                          ' Maybe do EMacro
      IF (TabMode AND %Diff) = 0 THEN                             ' DIFF Mode
         pCmdCUT("CUT .ZF .ZL REPLACE " + ClipName)               ' Go CUT all the data to the Clipboard
      END IF                                                      '
      IF ISNULL(ClipName) THEN KILL ClipFile                      ' Un-named CB?  KILL the temp file
      GOTO DoDelExit                                              ' Go delete tab and exit
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle SETEdit exit                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF IsSetEdit THEN                                              ' SetEdit?
      IF PKeep THEN                                               ' CrashSave calling?
         FNum = FREEFILE                                          ' Prepare to write it
         Stamp = "." + RIGHT$(DATE$, 2) + LEFT$(DATE$, 2) + MID$(DATE$, 4, 2) + "." + LEFT$(TIME$, 2) + MID$(TIME$, 4,2)   '
         Fn = gEnv.HomeData + "SetEdit" + Stamp + ".CrashSave.SetEdit"  '
         OPEN Fn FOR OUTPUT AS # FNum                             ' Open if
         FOR x = 1 TO LastLine                                    ' Re-write the data
            IF ISFALSE IsLData(x) THEN ITERATE FOR                ' Skip non Data lines
            PRINT # FNum, LTxtG(x)                                ' Write a line
         NEXT x                                                   '
         CLOSE # FNum                                             ' Close it
         GOTO EndResume                                           ' We're done
      END IF                                                      '

      IF FCB.AutoBkup AND ISFALSE IsBackupDone AND IsModdFlag THEN   ' Need to create BKP file?
         '-----------------------------------------------------------------------------------------+
         '- We must create a REAL file for the BACKUP                                              |
         '-----------------------------------------------------------------------------------------+
         Fn = GetTempFile("SPE")                                  ' Allocate a temp file
         FNum = FREEFILE                                          ' Get a file number
         OPEN Fn FOR OUTPUT AS # FNum                             ' Open it
         IF gSetRawCtr > 0 THEN                                   ' Fetch the 'before' version
            FOR i = 1 TO gSetRawCtr                               '
               PRINT # FNum, gSetRaw(i)                           ' Add it
            NEXT i                                                '
         ELSE                                                     '
            PRINT # FNum, "None."                                 '
         END IF                                                   '
         CLOSE # FNum                                             ' Close it
         DoBackup("!" + Fn, TP.TabMode, RCA)                      ' Go try it and get message result
         IF RCA.RC > 4 THEN                                       ' Failure?
            TP.ErrMsgAdd(%eFail, "Failed to create BACKUP of SET Data") ' Error msg
         END IF                                                   '
      END IF                                                      '
      GOSUB DoSpecEMacro                                          ' Maybe do EMacro
      ClipBoardSet(gSetClipB)                                     ' Restore the clipboard
      gSetCount = 0                                               '
      DIM tRaw(1 TO LastLine) AS STRING                           '
      FOR x = 1 TO LastLine                                       ' Re-write the data
         IF ISFALSE IsLData(x) THEN ITERATE FOR                   ' Skip non Data lines
         t = LTxtG(x)                                             ' Get a line
         INCR tRawCtr                                             ' Save it away
         tRaw(tRawCtr) = t                                        '
      NEXT x                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Now process the Raw data                                                                  |
      '--------------------------------------------------------------------------------------------+
      IF tRawCtr > 0 THEN                                         ' Got something?
         FOR x = 1 TO tRawCtr                                     ' Loop through it
            t = tRaw(x)                                           '
            IF INSTR(t, ";") THEN                                 ' Handle commants
               t = LEFT$(t, INSTR(t, ";") - 1)                    ' Remove them
               IF ISNULL(t) THEN ITERATE FOR                      ' Skip if empty
            END IF                                                '
            IF UCASE$(LEFT$(t, 4)) = "SET " THEN t = MID$(t, 5)   ' Remove redundant SET command
            i = INSTR(t, "=")                                     ' Locate =

            IF i THEN                                             ' Got one
               SetKey = TRIM$(LEFT$(t, i - 1))                    ' Save the key
               IF VERIFY(LEFT$(SetKey, 1), $Numeric + ".") = 0 THEN  ' No leading numbers or period
                  SetCmd                                          ' Cursor to Cmd line
                  MErrExit(%eFail, "Invalid SET variable name: " + SetKey) '
               END IF                                             '
               INCR gSetCount                                     ' Bump var count
               IF gSetCount > UBOUND(gSetKey()) THEN              ' Time to expand?
                  REDIM PRESERVE gSetKey(1 TO gSetCount * 2) AS GLOBAL STRING '
                  REDIM PRESERVE gSetData(1 TO gSetCount * 2) AS GLOBAL STRING   '
               END IF                                             '
               gSetKey(gSetCount) = SetKey                        ' Save
               gSetData(gSetCount) = TRIM$(MID$(t, i + 1))        '
               REPLACE "|" WITH ";" IN gSetData(gSetCount)        ' Handle the ; collision
            END IF                                                '
         NEXT x                                                   '
         ARRAY SORT gSetKey() FOR gSetCount, TAGARRAY gSetData()  '
         gSetRawCtr = tRawCtr                                     ' Setup for save
         REDIM PRESERVE gSetRaw(1 TO gSetRawCtr) AS GLOBAL STRING '
         FOR i = 1 TO gSetRawCtr                                  '
            gSetRaw(i) = tRaw(i)                                  '
         NEXT i                                                   '
      ELSE                                                        ' Nothing?
         gSetRawCtr = 0                                           '
      END IF                                                      '
      SETTableWrite                                               ' Write the table

      '--------------------------------------------------------------------------------------------+
      '- Request tab be deleted                                                                    |
      '--------------------------------------------------------------------------------------------+
      INCR gTabDelCtr                                             ' Bump table index
      IF gTabDelCtr > UBOUND(gTabDelList()) THEN                  ' Keep table big enough
         REDIM PRESERVE gTabDelList(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
         REDIM PRESERVE gTabDelNext(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
      END IF                                                      '
      gTabDelList(gTabDelCtr) = PgNumber                          ' Stuff in our page number

      GOTO EndResume                                              ' Exit
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle EFT Edit exit                                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF IsEFTEdit THEN                                              ' EFTEdit?
      IF PKeep THEN                                               ' CrashSave calling?
         FNum = FREEFILE                                          ' Prepare to write it
         Stamp = "." + RIGHT$(DATE$, 2) + LEFT$(DATE$, 2) + MID$(DATE$, 4, 2) + "." + LEFT$(TIME$, 2) + MID$(TIME$, 4,2)   '
         Fn = gEnv.HomeData + "EFTEdit" + Stamp + ".CrashSave.EFTEdit"  '
         OPEN Fn FOR OUTPUT AS # FNum                             ' Open if
         FOR x = 1 TO LastLine                                    ' Re-write the data
            IF ISFALSE IsLData(x) THEN ITERATE FOR                ' Skip non Data lines
            PRINT # FNum, LTxtG(x)                                ' Write a line
         NEXT x                                                   '
         CLOSE # FNum                                             ' Close it
         GOTO EndResume                                           ' We're done
      END IF                                                      '

      IF FCB.AutoBkup AND ISFALSE IsBackupDone AND IsModdFlag THEN   ' Need to create BKP file?
         '-----------------------------------------------------------------------------------------+
         '- We must create a REAL file for the BACKUP                                              |
         '-----------------------------------------------------------------------------------------+
         Fn = GetTempFile("SPE")                                  ' Allocate a temp file
         FNum = FREEFILE                                          ' Get a file number
         OPEN Fn FOR OUTPUT AS # FNum                             ' Open it
         FOR i = 1 TO gEFTRawCtr                                  '
            PRINT # FNum, gEFTRaw(i)                              ' Add to the file
         NEXT i                                                   '
         CLOSE # FNum                                             ' Close it
         DoBackup("!" + Fn, TP.TabMode, RCA)                      ' Go try it and get message result
         IF RCA.RC > 4 THEN                                       ' Failure?
            TP.ErrMsgAdd(%eFail, "Failed to create BACKUP of EFT Data") ' Error msg
         END IF                                                   '
      END IF                                                      '
      GOSUB DoSpecEMacro                                          ' Maybe do EMacro
      ClipBoardSet(gSetClipB)                                     '

      '--------------------------------------------------------------------------------------------+
      '- Get data back to gEFTRaw array                                                            |
      '--------------------------------------------------------------------------------------------+
      gEFTRawCtr = 0                                              '
      FOR x = 1 TO LastLine                                       ' Copy the data
         IF ISFALSE IsLData(x) THEN ITERATE FOR                   ' Skip non Data lines
         t = LTxtG(x)                                             ' Get a line

         '-----------------------------------------------------------------------------------------+
         '- Stuff it into gEFTRaw                                                                  |
         '-----------------------------------------------------------------------------------------+
         INCR gEFTRawCtr                                          ' Count it
         IF gEFTRawCtr > UBOUND(gEFTRaw()) THEN                   ' Keep table big enough
            REDIM PRESERVE gEFTRaw(1 TO 2 * gEFTRawCtr) AS GLOBAL STRING   '
         END IF                                                   '
         gEFTRaw(gEFTRawCtr) = t                                  ' Save it
      NEXT x                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Validity Check what's there                                                               |
      '--------------------------------------------------------------------------------------------+
      FOR i = 1 TO gEFTRawCtr                                     ' Look at each line
         EFTStr = gEFTRaw(i)                                      ' Grab the next str
         IF ISNULL(TRIM$(EFTStr)) THEN ITERATE FOR                ' Ignore blank lines
         IF INSTR(EFTStr, ";") THEN                               ' Handle commants
            EFTStr = LEFT$(EFTStr, INSTR(EFTStr, ";") - 1)        ' Remove them
            IF ISNULL(EFTStr) THEN ITERATE FOR                    ' Skip if empty
         END IF                                                   '
         MaskType = 0                                             ' Start as simple non-quoted mask
         IF LEFT$(EFTStr, 1) = $DQ THEN MaskType = 1              ' Its a simple quoted mask
         IF LEFT$(EFTStr, 2) = "R'" OR _                          ' Look like a RegEx?
            LEFT$(EFTStr, 2) = "R`" OR _                          '
            LEFT$(EFTStr, 2) = "R" + $DQ THEN MaskType = 2        ' It's a REGEX
         '--------------------------------------------------------------------------------------------+
         '- Remove Mask quotes if needed, then find the =                                             |
         '--------------------------------------------------------------------------------------------+
         j = 1                                                    ' For normal quoted masks
         IF MaskType <> 0 THEN                                    ' Mask is quoted?
            j = INSTR(MaskType + 1, EFTStr, MID$(EFTStr, MaskType, 1))  ' Look for trailing equal quote mark
         END IF                                                   '
         j = INSTR(j + 1, EFTStr, "=")                            ' Finally, look for the = sign

         EFTMask = TRIM$(LEFT$(EFTStr, j - 1))                    ' Get Mask value
         IF MaskType > 0 THEN _                                   ' A quoted type
            EFTMask = MID$(EFTMask, MaskType + 1, LEN(EFTMask) - (MaskType + 1)) ' Remove extraneous quotes
         EFTProf = uucase(TRIM$(MID$(EFTStr, j + 1)))             ' Get Prof value
         EFTOper = ""                                             ' Null in case no operand
         j = INSTR(EFTProf, ",")                                  ' See if optional operands
         IF j THEN EFTOper = TRIM$(MID$(EFTProf, j + 1))          ' Capture the optional operands
         IF j THEN EFTProf = TRIM$(LEFT$(EFTProf, j - 1))         ' Strip them off
         IF MaskType < 2 THEN                                     ' Prep the Mask (Types 0 and 1)
            IF ISFALSE EFT_Translate(EFTMask, EFTMask, PDiag) THEN   ' See if valid and Convert to Regex
               MErrExit(%eFail, "Line: " + FORMAT$(i) + ", EFT Mask is invalid - " + PDiag)  ' Report to the user
            END IF                                                '
         ELSE                                                     ' Do a PCRE compile of the mask
            gPCRE_Options = %PCRE_CASELESS                        ' Set Options
            gPCRE_Regex_Str2 = EFTMask + CHR$(0)                  ' Make into pseudo ASCIIZ
            CALL DWORD gPCRE_hProc_Compile USING pcre_compile( _  ' Try the compile
                    BYVAL STRPTR(gPCRE_Regex_Str2), _             ' Regex string
                    BYVAL gPCRE_Options,           _              ' Options
                    BYVAL VARPTR(gPCRE_ErrPtr),    _              ' Pointer to error string
                    BYVAL VARPTR(gPCRE_ErrOffsetPtr),_            ' Error offset
                    BYVAL &0) _                                   ' Character tables
                    TO PCREAns                                    ' Answer area
            IF PCREAns = 0 THEN                                   ' OK?
               txtp = gPCRE_ErrPtr                                ' No, get error message
               PDiag = "Line: " + FORMAT$(i) + ", at Col: " + FORMAT$(gPCRE_ErrOffsetPtr + 1) + " : " + @Txtp  '
               MErrExit(%eFail, PDiag)                            ' Report to the user
            END IF                                                '
         END IF                                                   '
         '--------------------------------------------------------------------------------------------+
         '- If EFT overrides, validate them now                                                       |
         '--------------------------------------------------------------------------------------------+
         IF ISNOTNULL(EFTOper) THEN                               ' Got any?
            FOR j = 1 TO PARSECOUNT(EFTOper, ",")                 ' Check each out
               t = uucase(PARSE$(EFTOper, ",", j))                ' Extract one command
               tt = GetNextWord(t, %NoStrip)                      ' Get the basic command name
               IF tt <> "OPENWITH" AND EFTProf = "NONTEXT" THEN _ '
                  MErrExit(%eFail, "Line: " + FORMAT$(i) + ", EFT Overrides not allowed with NONTEXT")   ' Report to the user
               IF tt = "OPENWITH" AND EFTProf <> "NONTEXT" THEN _ '
                  MErrExit(%eFail, "Line: " + FORMAT$(i) + ", EFT OPENWITH not allowed with Profile Name")  ' Report to the user
               k = gPCmdT.GetCmdIX(tt)                            ' Good command?
               IF k = 0 _                                         ' Invalid cmd
               OR gPCmdT.IsEFTOK(k) = %False THEN                 ' Invalid for EFT?
                  MErrExit(%eFail, "Line: " + FORMAT$(i) + ", EFT Override command: " + tt + " not supported") ' Report to the user
               END IF                                             '
            NEXT i                                                '
         END IF                                                   '
         '--------------------------------------------------------------------------------------------+
         '- Save it now                                                                               |
         '--------------------------------------------------------------------------------------------+
         INCR gEFTCtr                                             ' Count it
         IF gEFTCtr > UBOUND(gEFT()) THEN                         ' Keep table big enough
            REDIM PRESERVE gEFT(1 TO 2 * gEFTCtr) AS GLOBAL EFTData  '
         END IF                                                   '

         gEFT(gEFTCtr).Mask = EFTMask                             ' Save Mask
         gEFT(gEFTCtr).Prof = EFTProf                             ' Save Prof
         gEFT(gEFTCtr).Oper = EFTOper                             ' Save Operands
         gEFT(gEFTCtr).RawIX = i                                  ' Save Raw table index
      NEXT i                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Validated, save it now                                                                    |
      '--------------------------------------------------------------------------------------------+
      EFTRawLoad                                                  ' Save and load final tables
      GOTO DoDelExit                                              ' Go delete tab and exit
   END IF                                                         '

   IF IsView THEN                                                 ' Just Viewing?
      IF ISTRUE gENV.ViewWarn AND IsModdFlag THEN                 ' Was data modified and gENV.ViewWarn set?
         i =DoMessageBox("Text in this View session has been modified," + $CRLF + $CRLF + _  '
                         "Do you want to exit without saving it - |KEXIT|B" + $CRLF + _   '
                         "Or continue the View session - |KCONTINUE|B" + $CRLF + _  '
                         "EXIT" + $CRLF + _                       '
                         "CONTINUE", %MB_CUSTOM2 + %MB_USERICON + %MB_DEFBUTTON2, "SPFLite") '
         IF i = %IDCustom2 THEN                                   '
            gfEndAll = %False: GOTO EndResume                     ' Just exit
         END IF                                                   '
      END IF                                                      '
      IF FCB.StateFlag <> %StateOff THEN                          ' STATE active?
         me.StateSave(FCB.FilePath, 1, LastLine, %False)          ' Go setup/refresh STATE data
      END IF                                                      '
      fn = FCB.FilePath                                           ' Build full filename
      me.UnWatchQueue(fn)                                         ' Unwatch and dequeue it
      GOTO DoDelExit                                              ' Go delete tab and exit
   END IF                                                         '

   IF IsBrowse THEN                                               ' Just Browsing?
      IF FCB.StateFlag <> %StateOff THEN                          ' STATE active?
         me.StateSave(FCB.FilePath, 1, LastLine, %False)          ' Go setup/refresh STATE data
      END IF                                                      '
      fn = FCB.FilePath                                           ' Build full filename
      me.UnWatchQueue(fn)                                         ' Unwatch and dequeue it
      GOTO DoDelExit                                              ' Go delete tab and exit
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Build list of files for potential SAVE/STATE processing                                      |
   '-----------------------------------------------------------------------------------------------+
   Fcount = IIF(IsMedit, MAX(1, MEditCount), 1)                   ' Set number of files to save (possibly)
   REDIM fnlist(Fcount) AS STRING                                 '
   IF ISFALSE IsMEdit THEN                                        ' Build the list
      fnlist(1) = FCB.FilePath                                    ' Build full name
      IF IsModdFlag THEN lclModdFlag = %True                      ' Copy global to local ModdFlag
   ELSE                                                           '
      FOR j = 1 TO fcount                                         '
         fnlist(j) = me.MEditListGet(j)                           ' Build full name from MEdit list
         IF me.MEditFlagGet(j) THEN lclModdFlag = %True: INCR MCount ' Turn on local ModdFlag, count modified
      NEXT j                                                      '
   END IF                                                         '

   SaveTop = @P.PTopLine                                          ' Save TOS around all the PTBL reset stuff
   PTBL.PTBLReset                                                 ' Set parse search output fields for ALL
   @P.PTopLine = SaveTop                                          '
   FOR j = 1 TO FCount                                            ' Do each file
      '--------------------------------------------------------------------------------------------+
      '- Ensure correct Profile if MEdit                                                           |
      '--------------------------------------------------------------------------------------------+
      IF IsMEdit AND FCB.ProfName <> GetProfileForFile(fnlist(j), PDiag, %False, %True) THEN ' Different Profile needed
         FCB.SetupProf(GetProfileForFile(fnlist(j), PDiag, %False, %True), RCA)  ' Swap to the oddball one
      END IF                                                      '

      IF (FCB.AutoSave AND (%AutoSON OR %AutoSPrompt)) = 0 THEN   ' AutoSave OFF NOPROMPT?
         '-----------------------------------------------------------------------------------------+
         '- Do nothing but try STATE saving                                                        |
         '-----------------------------------------------------------------------------------------+
         IF FCB.StateFlag <> %StateOff THEN                       ' STATE active?
            GOSUB DoRangeSet                                      ' Get line range setup
            @P.PTopLine = SaveTop                                 ' Restore TOS
            me.StateSave(fnlist(j), fline, tline, %False)         ' Go setup/refresh STATE data
         END IF                                                   '

      ELSEIF (FCB.AutoSave AND %AutoSON) <> 0 AND (FCB.AutoSave AND %AutoSPrompt) = 0 THEN   ' AutoSave ON NOPROMPT??
         IF lclModdFlag THEN                                      ' Yes, was data modified?
            IF ISFALSE IsMEdit AND (fnlist(j) = $New) THEN        ' Probable (New) or cloned file?
               pCmdSaveAs("SAVEAS")                               ' Go do a SaveAs
               IF ErrMsgHigh <> %eNone THEN                       ' Cancelled out?
                  me.UnWatchQueue("")                             ' Unwatch and dequeue it
                  GOTO DoDelExit                                  ' Go delete tab and exit
               ELSE                                               '
                  SaveOK = %True                                  ' Remember good save done
                  lclmoddflag = %False                            ' No longer 'modified'
               END IF                                             '
            ELSE                                                  '
               pCmdSAVE("SAVE")                                   ' Else a normal save
            END IF                                                '
            IF ErrMsgHigh = %eNone THEN                           ' Save OK?
               SaveOK = %True                                     ' Remember good save done
               lclmoddflag = %False                               ' No longer 'modified'
            ELSE                                                  '
               gfEndAll = %False                                  ' Kill the EndAll flag and exit
               GOTO EndResume                                     '
            END IF                                                '
         ELSE                                                     ' Save not needed
            '--------------------------------------------------------------------------------------+
            '- Do nothing but try STATE saving                                                     |
            '--------------------------------------------------------------------------------------+
            IF FCB.StateFlag <> %StateOff THEN                    ' STATE active?
               GOSUB DoRangeSet                                   ' Get line range setup
               @P.PTopLine = SaveTop                              ' Restore TOS
               me.StateSave(fnlist(j), fline, tline, %False)      ' Go setup/refresh STATE data
            END IF                                                '
         END IF                                                   '

      ELSEIF (FCB.AutoSave AND %AutoSPrompt) <> 0 THEN            ' AutoSave PROMPT
         IF lclModdFlag THEN                                      ' Yes, was data modified?
            IF ISFALSE keep THEN                                  ' Avoid prompting twice
               IF (FCB.AutoSave AND %AutoSON) <> 0 THEN           ' AutoSave ON PROMPT
                  IF ISFALSE IsMEdit THEN                         ' Choose message format
                     i = DoMessageBox("Save |K" & fnlist(j) + "|B before exiting?", %MB_YESNOCANCEL OR %MB_DEFBUTTON1, "SPFLite - File " + FCB.File + " has been modified")   '
                  ELSE                                            ' Use the MEdit format
                     i = DoMessageBox("Save modified files before exiting?", %MB_YESNOCANCEL OR %MB_DEFBUTTON1, "SPFLite - File " + FCB.File + " has been modified") '
                  END IF                                          '
               ELSE                                               ' AutoSave OFF PROMPT
                  IF ISFALSE IsMEdit THEN                         ' Choose message format
                     i = DoMessageBox("Save |K" & fnlist(j) + "|B before exiting?", %MB_YESNOCANCEL OR %MB_DEFBUTTON2, "SPFLite - File " + FCB.File + " has been modified")   '
                  ELSE                                            ' Use the MEdit format
                     i = DoMessageBox("Save modified files before exiting?", %MB_YESNOCANCEL OR %MB_DEFBUTTON2, "SPFLite - File " + FCB.File + " has been modified") '
                  END IF                                          '
               END IF                                             '
            ELSE                                                  '
               i = %IDYES                                         '
            END IF                                                '
            IF i = %IDYES THEN                                    '
               @P.PTopLine = SaveTop                              ' Restore TOS
               IF ISFALSE IsMEdit AND (fnlist(j) = $New) THEN     ' Probable (New)
                  pCmdSaveAs("SAVEAS")                            ' Go do a SaveAs
               ELSE                                               '
                  pCmdSAVE("SAVE")                                ' Else a normal save
               END IF                                             '
               IF ErrMsgHigh = %eNone THEN                        ' If Save OK
                  SaveOK = %True                                  ' Remember good save done
                  lclmoddflag = %False                            ' No longer 'modified'
               ELSE                                               '
                  gfEndAll = %False                               ' Kill the EndAll flag and exit
                  GOTO EndResume                                  '
               END IF                                             '
            ELSEIF i = %IDCANCEL THEN                             ' CANCEL the END?
               gfEndAll = %False                                  ' Kill the EndAll flag and exit
               GOTO EndResume                                     '
            ELSEIF i = %IDNO THEN                                 ' NO
               IF FCB.StateFlag <> %StateOff THEN                 ' STATE active?
                  GOSUB DoRangeSet                                ' Setup line range
                  @P.PTopLine = SaveTop                           ' Restore TOS
                  me.StateSave(fnlist(j), fline, tline, %False)   ' Go setup/refresh STATE data
               END IF                                             '
            END IF                                                '
         ELSE                                                     '
            IF FCB.StateFlag <> %StateOff THEN                    ' STATE active?
               GOSUB DoRangeSet                                   ' Setup line range
               @P.PTopLine = SaveTop                              ' Restore TOS
               me.StateSave(fnlist(j), fline, tline, %False)      ' Go setup/refresh STATE data
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
   NEXT j                                                         '

   IF SaveOK THEN                                                 ' Tell user Save was done
      IF ISFALSE IsMEdit THEN                                     '
         gTabDelMsg = "File saved"                                '
      ELSE                                                        '
         gTabDelMsg = FORMAT$(MCount) + " file" + IIF$(MCount = 1, "", "s") + " saved" '
      END IF                                                      '
   END IF                                                         '

DoDelExit:                                                        '
   ActionStop = %True                                             ' Kill ACTION SAVE processing
   gfXRebuild = %False                                            ' Kill any rebuild
   me.CleanTabData                                                ' Wipe out data

   '-----------------------------------------------------------------------------------------------+
   '- Request tab be deleted                                                                       |
   '-----------------------------------------------------------------------------------------------+
   INCR gTabDelCtr                                                ' Bump table index
   IF gTabDelCtr > UBOUND(gTabDelList()) THEN                     ' Keep table big enough
      REDIM PRESERVE gTabDelList(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
      REDIM PRESERVE gTabDelNext(1 TO 2 * gTabDelCtr) AS GLOBAL LONG '
   END IF                                                         '
   gTabDelList(gTabDelCtr) = PgNumber                             ' Stuff in our page number

EndResume:                                                        '
   ON ERROR GOTO 0                                                '
   CmdStackNum = 0                                                ' If an END, no more commands allowed
   MExitMeth                                                      '

EndBail:                                                          '
   RESUME EndResume                                               '
   RETURN                                                         '

DoRangeSet:                                                       '
   RESET fline, tline                                             ' Zero our answer areas
   IF ISFALSE IsMedit THEN fline = 1: tline = LastLine: RETURN    ' If not Medit, the whole thing
   FOR i = 1 TO LastLine                                          ' Must search for range of this MEdit file
      IF IsLFile(i) THEN                                          ' Look for =FILE> lines
         IF fnlist(j) = TRIM$(LTxtG(i)) THEN                      ' Found start of file
            fline = i + 1                                         ' Save start line number
            INCR i                                                '
            DO WHILE ISFALSE IsLFile(i) AND ISFALSE IsLBottom(i)  '
               tline = i                                          ' Save as hiwater last line
               INCR i                                             '
            LOOP                                                  '
            IF tline = 0 THEN tline = fline                       ' If tline = 0 (no lines) set it = to fline
            me.RangeSetRange(fline, tline)                        ' Set fline/tline as the range
            EXIT FOR                                              ' Done this looping crap
         END IF                                                   '
      END IF                                                      '
   NEXT i                                                         '
   RETURN                                                         '

DoSpecEMacro:                                                     '
   '-----------------------------------------------------------------------------------------------+
   '- See if an EMACRO to run                                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF TP.FCB_.EMacro <> "" THEN                                   ' Is there an EMacro?
      macname = TP.FCB_.EMacro                                    ' Get macro string
      IF UCASE$(macname) = macname THEN                           ' Is macroname Uppercase? (ON)
         IF isMacro(macname) THEN                                 ' Valid macro?
            me.pCmdMacro(macname)                                 ' Then go do it
         ELSE                                                     '
            MErrExit(%eFail, "EMACRO - " + macname + " not found")   ' Issue error
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdENUMWith(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Specify the ENUM increment value                                                                |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO MsgOut, _                                           ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   gEnumWith = VAL(PTBL.Pos("#", 1))                              ' Pick up the new value
   MsgOut:                                                        '
      MErrExit(%eNone, "ENUMWITH set to " + FORMAT$(gEnumWith))   ' Issue status message
END METHOD                                                        '

METHOD  pCmdEOL(pCmd AS STRING)                                   '
LOCAL EO, MSG AS STRING                                           '
   Mentry                                                         '
   MSG = "DCB is set to: "                                        ' Start building MSG
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO FormatMsg, _                                        ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   pCmdDCB("DCB " + pCmd)                                         ' Insert DCB and pass it on
   MExitMeth                                                      '

   FormatMsg:                                                     '
   EO = FCB.EOL                                                   ' Format EOL
   IF VERIFY(EO, $Hex) = 0 THEN EO = "X'" + EO + "'"              ' IF hex operand, FRAME it for the message
   DoProfMsg(MSG + "RECFM=" + FCB.RECFM + ", LRECL=" + FORMAT$(FCB.LRECL) + ", EOL=" + EO )  ' Issue message
   DoStatusBar($SBEOL)                                            ' re-Do the StatusBar EOL box
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdEXCLFLIPSHOW(pCmd AS STRING, cmd AS STRING, msgname AS STRING) '
'--------------------------------------------------------------------------------------------------+
'- handle the integrated Common Command code                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, AllCount, AllLines, LLastLine AS LONG                 '
LOCAL lclCol, ldir, lsline AS LONG                                ' Local saves for FIND ALL
DIM dlines(1 TO 1000) AS LONG                                     ' To hold lines to be deleted
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         GOTO CallHelp, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   '-----------------------------------------------------------------------------------------------+
   '- Parse the operands                                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _         '
      ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN         '
      PTBL.FlgNext = %True                                        ' Set NEXT if no others specified
      IF PTBL.FindRngSet THEN _                                   ' If a range from sRangeSet
         PTBL.FlgAll = %True                                      ' then set ALL
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Add selective options based of the major function                                            |
   '-----------------------------------------------------------------------------------------------+
   SELECT CASE AS CONST$ cmd                                      ' See what extras based on the command
      CASE "NDELETE"                                              ' NDELETE
         PTBL.FlgDX = %True                                       ' Add the DX internally
         PTBL.FlgNF = %True                                       ' and NF
      CASE "EXCLUDE"                                              ' EXCLUDE
         PTBL.FlgMX = %True                                       ' Add the MX internally
         PTBL.FlgNX = %True                                       ' and NX
         PTBL.FindRngSet = %True                                  ' and RangeSet
      CASE "NEXCLUDE"                                             ' NEXCLUDE
         PTBL.FlgMX = %True                                       ' Add the MX internally
                                                                  '         PTBL.FlgNX = %True                                       ' and NX
         PTBL.FlgNF = %True                                       ' and NF
      CASE "SHOW"                                                 ' SHOW
         PTBL.FlgX = %True                                        ' Add the X internally
         PTBL.FindRngSet = %True                                  ' and RangeSet
      CASE "NSHOW"                                                ' NSHOW
         PTBL.FlgX = %True                                        ' Add the X internally
         PTBL.FindRngSet = %True                                  ' and RangeSet
         PTBL.FlgNF = %True                                       ' and NF
      CASE "FLIP"                                                 ' FLIP
         PTBL.FlgDX = %True                                       ' Add the DX internally
      CASE "NFLIP"                                                ' NFLIP
         PTBL.FlgDX = %True                                       ' Add the DX internally
         PTBL.FlgNF = %True                                       ' and NF
      CASE "NULINE", "NREVERT"                                    ' NULINE / NREVERT
         PTBL.FlgNF = %True                                       ' Add NF
      CASE "APPEND", "PREPEND", "ULINE", "REVERT"                 ' APPEND / PREPEND / ULINE / REVERT
                                                                  'PTBL.FlgDX = %True                                      ' Add the DX internally
   END SELECT                                                     '

   '-----------------------------------------------------------------------------------------------+
   '- Negative stuff must have a literal                                                           |
   '-----------------------------------------------------------------------------------------------+
   SELECT CASE AS CONST$ cmd                                      ' See what extras based on the command
      CASE "NDELETE", "NEXCLUDE", "NSHOW", "NFLIP", "NULINE", "NREVERT" '
         IF ISFALSE PTBL.FlgLit1 THEN _                           '
            MErrExit(%eFail, cmd + " must specify a search literal") '
   END SELECT                                                     '

   '-----------------------------------------------------------------------------------------------+
   '- Validate any weird combinations of operands                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF cmd = "APPEND" OR cmd = "PREPEND"THEN                       ' APPEND/PREPEND must have a simple literal
      IF PTBL.FlgL1Picture OR PTBL.FlgL1RegEx THEN _              '
         MErrExit(%eFail, cmd + " must use only a simple literal type") '
      IF ISFALSE PTBL.FlgLit1 THEN _                              '
         MErrExit(%eFail, cmd + " string is missing")             '
      IF ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgAll THEN _   '
         MErrExit(%eFail, cmd + " has no line range specified or ALL")  '
      IF ISFALSE PTBL.FindRngSet AND PTBL.FlgAll THEN _           '
         PTBL.FindRngSet = %True: PTBL.FindRngStart = 1: PTBL.FindRngEnd = LastLine '
      PTBL.FlgLit1 = %False                                       ' Clear L1 so sStrSearch won't actually search 'literally'
   ELSE                                                           '
      IF ISFALSE PTBL.FlgLit1 THEN                                ' Lit1 present?
         IF ISFALSE PTBL.FlgAll AND ISFALSE PTBL.FindRngSet AND _ ' No Lit1, better have ALL or FindRngSet
            ISFALSE PTBL.FlgX AND ISFALSE PTBL.FlgNX THEN _       ' or X or NX
            MErrExit(%eFail, "No search string, but no ALL specified")  '
         IF PTBL.FlgWord OR PTBL.FlgPrefix OR PTBL.FlgSuffix THEN _  ' No extraneous operands
            MErrExit(%eFail, "No search string, but string options are present") '
      END IF                                                      '

      IF PTBL.FlgAll AND ISFALSE PTBL.FlgLit1 AND _               ' Ending up with just ALL?
         ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgX AND ISFALSE PTBL.FlgNX THEN  ' Nothing else?
         IF cmd = "DELETE" AND IsNE(PTBL.Ops(0), "DELETE") THEN _ '
            MErrExit(%eFail, "To delete entire file, fully spell out DELETE ALL")   '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Do the simple X/FLIP/SHOW ALL style                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FlgAll AND ISFALSE PTBL.FlgLit1 AND _                  ' Ending up with just ALL?
      ISFALSE PTBL.FindRngSet AND _                               ' Nothing else
      ISFALSE PTBL.FlgU AND ISFALSE PTBL.FlgNU AND _              '
      ISFALSE PTBL.FlgX AND ISFALSE PTBL.FlgNX THEN               '
      IF cmd = "EXCLUDE" OR cmd = "FLIP" OR cmd = "SHOW" OR _     ' The simple ALL visibility ones?
         cmd = "ULINE" OR cmd = "REVERT" THEN                     '
         @P.PTopLine = 1                                          '
         i = 2                                                    ' Spin through the file
         DO WHILE ISFALSE IsLBottom(i)                            '
            IF ISFALSE IsLFile(i) AND ISFALSE IsLXClude(i) THEN   ' Ignore MEdit FILE lines
               SELECT CASE AS CONST$ cmd                          ' Which one?
                  CASE "EXCLUDE": LFOn(i, %Invisible)             ' Set Invisible
                  CASE "FLIP"   : LFTog(i, %Invisible)            ' Invert Invisible
                  CASE "SHOW"   : LFOff(i, %Invisible)            ' Remove Invisible
                  CASE "ULINE"  : LFOn(i, %User)                  ' Add USER
                  CASE "REVERT" : LFOff(i, %User)                 ' Remove User
               END SELECT                                         '
            END IF                                                '
            INCR i                                                '
         LOOP                                                     '
         gfXRebuild = %True                                       ' Rebuild exclude stuff
         OnUndoFlag                                               ' Force a snapshot
         MExitMeth                                                ' We're done
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Run the standard search procedure                                                            |
   '-----------------------------------------------------------------------------------------------+
   RESET AllCount, AllLines, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen   ' Reset 1st found values
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      IF PTBL.FlgNF THEN                                          ' Do appropriate test
         i = me.NFSearch(0, @P.C.CType)                           ' Do the initial search
      ELSE                                                        '
         i = me.Search(0, @P.C.CType)                             '
      END IF                                                      '
      IF i THEN                                                   '
         i = PTBL.FoundLine                                       ' Get found line
         IF i <> LLastLine THEN INCR AllLines: LLastLine = i      '
         INCR AllCount: lclCol = sCol: lDir = sDir: lsLine = sLine   ' Count and save 1st located for RFIND stuff
         IF cmd = "SHOW" THEN GOSUB DoShow                        ' If found, Do the Show
         IF cmd = "FLIP" OR cmd = "NFLIP" THEN GOSUB DoFlip       ' If found, Do the Flip
         IF cmd = "NDELETE" THEN GOSUB AddDel                     ' If found, Flag for delete
         IF cmd = "APPEND" THEN GOSUB DoAppend                    ' If found, go append something
         IF cmd = "PREPEND" THEN GOSUB DoPrepend                  ' If found, go prepend something
         IF cmd = "ULINE"  OR cmd = "NULINE" THEN GOSUB DoULine   ' Add USER
         IF cmd = "REVERT"  OR cmd = "NREVERT" THEN GOSUB DoRevert   ' Remove USER
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         IF PTBL.FlgNF THEN                                       ' Do appropriate test
            i = me.NFSearch(1, %CNext)                            ' Do the initial search
         ELSE                                                     '
            i = me.Search(1, %CNext)                              ' Do re-Finds
         END IF                                                   '
         IF i THEN                                                ' Found one
            i = PTBL.FoundLine                                    ' Get found line
            IF i <> LLastLine THEN INCR AllLines: LLastLine = i   '
            INCR AllCount                                         ' Count successful
            IF cmd = "SHOW" THEN GOSUB DoShow                     ' If found,Do the Show
            IF cmd = "FLIP" OR cmd = "NFLIP" THEN GOSUB DoFlip    ' If found,Do the Flip
            IF cmd = "NDELETE" THEN GOSUB AddDel                  ' If found, Flag for delete
            IF cmd = "APPEND" THEN GOSUB DoAPPEND                 ' If found, go append something
            IF cmd = "PREPEND" THEN GOSUB DoPrepend               ' If found, go prepend something
            IF cmd = "ULINE"  OR cmd = "NULINE" THEN GOSUB DoULine   ' Add USER
            IF cmd = "REVERT"  OR cmd = "NREVERT" THEN GOSUB DoRevert   ' Remove USER
         END IF                                                   '
      LOOP                                                        '
      IF cmd = "NDELETE" THEN GOSUB DelThem                       '
      IF AllLines = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(nMac(%eFail), "No lines found")             '
      ELSE                                                        '
         TP.ErrMsgAdd(0, msgname + " " + FORMAT$(AllLines) + IIF$(AllLines > 1, " lines", " line"))   '
         sCol = lclCol: sDir = lDir: sLine = lsLine               ' Restore to 1st one found
      END IF                                                      '

   ELSE                                                           ' The non-All version
      IF PTBL.FlgNF THEN                                          ' Do appropriate test
         i = me.NFSearch(0, @P.C.CType)                           ' Do the initial search
      ELSE                                                        '
         i = me.Search(0, @P.C.CType)                             ' Do re-Finds
      END IF                                                      '
      IF i = 0 THEN                                               ' Got it?
         TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)               ' Remember we failed
      ELSE                                                        '
         i = me.sLine                                             ' Get found line
         INCR AllCount                                            '
         IF cmd = "FLIP" OR cmd = "NFLIP" THEN GOSUB DoFlip       ' If found,Do the Flip
         IF cmd = "SHOW" THEN GOSUB DoShow                        ' If found,Do the Show
         IF cmd = "NDELETE" THEN GOSUB AddDel                     ' If found, Flag for delete
         IF cmd = "DELETE" OR cmd = "NDELETE" THEN GOSUB DelThem  '
         IF cmd = "ULINE"  OR cmd = "NULINE" THEN GOSUB DoULine   ' Add USER
         IF cmd = "REVERT"  OR cmd = "NREVERT" THEN GOSUB DoRevert   ' Remove USER
         TP.ErrMsgAdd(0, msgname + " " + FORMAT$(AllCount) + " line")   '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
      END IF                                                      '
   END IF                                                         '
   gfXRebuild = %True                                             ' Force exclude rebuild
   OnUndoFlag                                                     ' Force a snapshot
   MExitMeth                                                      '

CallHelp:                                                         '
   PCmdHelp("H " + Cmd)                                           ' Call the correct Help
   MexitMeth                                                      '

DoAppend:                                                         '
   IF IsLData(PTBL.FoundLine) THEN                                ' Just data lines
      me.LTxtSet(PTBL.FoundLine, LTxtG(PTBL.FoundLine) + PTBL.L1RData)  ' Append the data
      LAttrS(PTBL.FoundLine) = LAttrG(PTBL.FoundLine) + REPEAT$(LEN(PTBL.L1RData), CHR$$(0)) ' Append Attr as well
      me.ModSet(PTBL.FoundLine)                                   ' Remember we changed something
   END IF                                                         '
   RETURN                                                         '

DoPrepend:                                                        '
   IF IsLData(PTBL.FoundLine) THEN                                ' Just data lines
      me.LTxtSet(PTBL.FoundLine, PTBL.L1RData + LTxtG(PTBL.FoundLine))  ' Prepend the data
      LAttrS(PTBL.FoundLine) = REPEAT$(LEN(PTBL.L1RData), CHR$$(0)) + LAttrG(PTBL.FoundLine) ' Prepend Attr as well
      me.ModSet(PTBL.FoundLine)                                   ' Remember we changed something
   END IF                                                         '
   RETURN                                                         '

DoFlip:                                                           '
   IF IsLData(PTBL.FoundLine) THEN                                ' Just data lines
      LFTog(PTBL.FoundLine, %Invisible)                           ' Do the FLIP of Invisible status
      sCol = IIF(PTBL.FlgPrev, 1, LEN(L(PTBL.FoundLine).@LTxt))   ' Set length so no more on this line
   END IF                                                         '
   RETURN                                                         '

DoShow:                                                           '
   IF IsLData(PTBL.FoundLine) THEN                                ' Just data lines
      LFOff(PTBL.FoundLine, %Invisible)                           ' SHOW the line
      sCol = IIF(PTBL.FlgPrev, 1, LEN(L(PTBL.FoundLine).@LTxt))   ' Set length so no more on this line
   END IF                                                         '
   RETURN                                                         '

DoULine:                                                          '
   IF IsLData(PTBL.FoundLine) THEN                                ' Just data lines
      LFOn(PTBL.FoundLine, %User)                                 ' Mark the line as USER
      sCol = IIF(PTBL.FlgPrev, 1, LEN(L(PTBL.FoundLine).@LTxt))   ' Set length so no more on this line
   END IF                                                         '
   RETURN                                                         '

DoRevert:                                                         '
   IF IsLData(PTBL.FoundLine) THEN                                ' Just data lines
      LFOff(PTBL.FoundLine, %User)                                ' Remove as USER
      sCol = IIF(PTBL.FlgPrev, 1, LEN(L(PTBL.FoundLine).@LTxt))   ' Set length so no more on this line
   END IF                                                         '
   RETURN                                                         '

AddDel:                                                           '
   FOR i = 1 TO j                                                 '
      IF dLines(i) = PTBL.FoundLine THEN RETURN                   ' Don't add line more than once
   NEXT i                                                         '
   INCR j                                                         '
   IF J > UBOUND(dLines) THEN _                                   ' Expand table if needed
      REDIM PRESERVE dLines(1 TO UBOUND(dLines) * 2)              ' Double it
   dLines(j) = PTBL.FoundLine                                     ' Save the line number
   RETURN                                                         '

DelThem:                                                          '
   Allcount = 0                                                   '
   FOR i = j TO 1 STEP -1                                         ' Now delete the lines (backward)
      IF IsLData(dLines(i)) THEN me.ModSet(dLines(i))             ' Remember we changed something
      me.LTxtFree(dLines(i))                                      ' Go free the dynamic string
      me.LEntDel(dLines(i))                                       ' Remove from the L() array
      me.ModSet(dLines(i))                                        ' Remember we changed something
      me.AdjustPending(dLines(i), -1, 0)                          ' Adjust pending requests
      DECR LastLine: DECR LastReal                                ' Adjust LastLine and LastReal
      INCR AllCount                                               ' Count real deletions
   NEXT i                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD PCmdExit(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Terminate all the tabs   (EXIT)                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, x, y, cTab, noreopen AS LONG, shutcmd, mnames, mrf, TabType, t AS STRING   '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H EXIT"), _                                    ' ? entered
         GOTO ParseError, _                                       ' Error, Bail out
         Nul)                                                     ' Continue
   NoReopen = PTBL.IsKwd("NOREOPEN")                              ' Get flags
   ShutCmd  = PTBL.Grp("WHICH") + " "                             ' Get close type
   IF PTBL.IsKwd("DELETE ") THEN                                  ' DELETE added?
      IF shutcmd = "CANCEL" THEN                                  '
         shutcmd += "DELETE "                                     '
      ELSE                                                        '
         GOTO DelError                                            '
      END IF                                                      '
   END IF                                                         '
   IF shutcmd = "" THEN shutcmd = "END "                          ' Provide default if no operands
'   MSGBOX "DoTermination Being called'
   DoTermination(ShutCmd, NoReopen)                               ' Let common code finish it off
'   MSGBOX "DoTermination Returned'
   EXIT METHOD                                                    '
   ParseError:
      TP.ErrMsgAdd(%eFail, PTBL.ErrMsg)                           ' Issue message
      EXIT METHOD                                                 '
   DelError:
      TP.ErrMsgAdd(%eFail, "DELETE allowed only with CANCEL")     ' Issue message
END METHOD                                                        '

METHOD  pCmdFAV(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Add file as a favorite                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL Wrd, wrd2, ln2 AS STRING                                    '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H FAVORITE"), _                                ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsMEdit THEN _                                              ' Sorry if MEdit mode
      MErrExit(%eFail, "Can't 'Favorite' in Multi-Edit mode")     '

   wrd2 = IIF$(PTBL.GotLit = 0, "Favorite Files", PTBL.Pos2(1))   ' Use command operand or FAVORITE
   wrd = UUCASE(wrd2)                                             ' UC the working version
   IF wrd = "RECENT FILES" OR wrd = "FLISTS" OR _                 ' Reserved name
      wrd = "RECENT PATHS" OR wrd = "FOUND FILES" OR wrd = "OPEN" OR _  '
      wrd = "RECENT" OR wrd = "FOUND" OR wrd = "PATHS" THEN _     '
      MErrExit(%eFail, "Sorry, name: " + wrd + " is reserved")    '
   IF FCB.FilePath = $New THEN _                                  ' Better be a file name
      MErrExit(%eFail, "Favorite applies only to named files")    '
   TP.ErrMsgAdd(%eNone, FileListAdd(Wrd2, FCB.FilePath, "", TimePretty(0)))   '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdFIND(pCmd AS STRING, OPT CallCmnd AS STRING)          '
'--------------------------------------------------------------------------------------------------+
'- FIND Command                                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL modemsg, str, istr, fstr, OptName AS STRING                 '
LOCAL i, ll AS LONG, AllCount, AllLines, LLastLine, OpCount, RSRCH AS LONG '
LOCAL lclCol, ldir, lsline AS LONG                                ' Local saves for FIND ALL
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   IF ISFALSE ISMISSING(CallCmnd) THEN OptName = CallCmnd         ' If an RSRCH type FIND call. save who
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff if not a simple RFIND entry                                       |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Parse
         PCmdHelp("H FIND"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   RSRCH = PTBL.IsKwd("RSRCH")                                    ' Get RSRCH value early
   '-----------------------------------------------------------------------------------------------+
   '- Do the odd 1 parameter tests                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 1 THEN                                        '
      IF RSRCH AND ISNULL(PTBL.RL1RData) THEN _                   ' A valid RSRCH environment?
      MErrExit(%eFail, "No prior search values to use")           '
   END IF                                                         '

   IF ISFALSE RSRCH OR PTBL.OpsNum > 1 THEN                       ' Complete Parse if needed
      Call3(PTBL.ParseCmd(pCmd, %PAssign), _                      ' Try the Parse Assign
            PCmdHelp("H FIND"), _                                 ' ? entered
            MErrExit(%eFail, PTBL.ErrMsg), _                      ' Error, Bail out
            Nul)                                                  ' Continue
   END IF                                                         '

   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   IF ISFALSE PTBL.FlgLit1 THEN MErrExit(%eFail, "No search string entered")  '

   IF ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _         '
      ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN _       '
      PTBL.FlgNext = %True                                        ' Set NEXT if no others specified

   IF RSRCH THEN PTBL.FlgAll = %False                             ' RSRCH kills ALL
   LocFind = IIF$(ISNOTNULL(OptName), OptName, "FIND")            ' Remember who's searching
   str = IIF$(LEN(PTBL.L1Raw) < 16, PTBL.L1Raw, LEFT$(PTBL.L1Raw, 14) + "..") ' Build msg literal
   modemsg = IIF$(PTBL.FlgWord, "WORD " + str, "CHARS " + str)    '
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values

   IF PTBL.FlgAll THEN                                            ' The ALL version?
      RESET AllCount, AllLines, LLastLine                         ' Reset variables
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         i = sLine                                                ' Get found line
         INCR AllCount: lclCol = sCol: lDir = sDir: lsLine = sLine   ' Count and save 1st located for RFIND stuff
         IF i <> LLastLine THEN INCR AllLines: LLastLine = i      '
      ELSE                                                        '
         PTBL.FoundLine = 0: PTBL.FoundCol = 0: PTBL.FoundLen = 0 ' Reset PTBL area
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            i = sLine                                             ' Get found line
            INCR AllCount                                         ' Count successful
            IF i <> LLastLine THEN INCR AllLines: LLastLine = i   '
         END IF                                                   '
      LOOP                                                        '
      IF AllCount = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(nmac(%eFail), modemsg + " not found")       '
      ELSE                                                        '
         fstr = MID$(LTxtG(PTBL.FoundLine), PTBL.FoundCol, PTBL.FoundLen)  ' Get the found string
         IF PTBL.FlgL1Picture OR PTBL.FlgL1DLM OR PTBL.FlgL1Hex OR PTBL.FlgL1RegEx THEN   '
            modemsg = IIF$(PTBL.FlgWord, "WORD '" + fstr + "'", "CHARS '" + fstr + "'")   '
         END IF                                                   '
         istr = gENV.PDotString                                   ' Get list of invalid characters
         IF INSTR(fstr, ANY istr) THEN                            ' Contains non-display chars?
            IF FCB.SrceXlate THEN                                 ' If Non-ANSI do before EOL
               me.Translate(fstr, FCB.GetSA2SPtr)                 ' Do the translate
            END IF                                                '
            modemsg = IIF$(PTBL.FlgWord, "WORD " + Str2Hex(fstr), "CHARS " + Str2Hex(fstr))  '
         END IF                                                   '
         TP.ErrMsgAdd(0, modemsg + " found " + FORMAT$(AllCount) + IIF$(AllCount > 1, " times", " time") + IIF$(AllCount = AllLines, "", " in " + FORMAT$(AllLines) + IIF$(AllLines = 1, " line", " lines")))  '
         sCol = lclCol: sDir = lDir: sLine = lsLine               ' Restore to 1st one found
      END IF                                                      '
   ELSE                                                           ' The non-All version
      i = me.Search(IIF(RSRCH, 1, 0), @P.C.CType)                 ' Go see if we can find it
      IF i = 0 THEN                                               ' Got it?
         TP.ErrMsgAdd(nmac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
         PTBL.FoundLine = 0: PTBL.FoundCol = 0: PTBL.FoundLen = 0 ' Reset PTBL area
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)               ' Remember we failed
      ELSE                                                        '
         fstr = MID$(LTxtG(PTBL.FoundLine), PTBL.FoundCol, PTBL.FoundLen)  ' Get the found string
         IF PTBL.FlgL1Picture OR PTBL.FlgL1DLM OR PTBL.FlgL1Hex OR PTBL.FlgL1RegEx THEN   '
            modemsg = IIF$(PTBL.FlgWord, "WORD '" + fstr + "'", "CHARS '" + fstr + "'")   '
         END IF                                                   '
         istr = gENV.PDotString                                   ' Get list of invalid characters
         IF INSTR(fstr, ANY istr) THEN                            ' Contains non-display chars?
            IF FCB.SrceXlate THEN                                 ' If Non-ANSI do before EOL
               me.Translate(fstr, FCB.GetSA2SPtr)                 ' Do the translate
            END IF                                                '
            modemsg = IIF$(PTBL.FlgWord, "WORD " + Str2Hex(fstr), "CHARS " + Str2Hex(fstr))  '
         END IF                                                   '
         TP.ErrMsgAdd(%eNone, modemsg + " found " + IIF$(PTBL.FlgMX, "and X'd", ""))   '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdGLUEWITH(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Specify the GLUE joining literal                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL s AS STRING                                                 '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO MsgOut, _                                           ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   gENV.GlueWith = PTBL.Pos2(1)                                   ' Pick up the new value
   MsgOut:                                                        '
      s = IIF$(ISNULL(gENV.GlueWith), $DQ + $DQ, gENV.GlueWith)   ' Make NULL 'visible'
      MErrExit(%eNone, "GLUEWITH set to " + s)                    ' Issue status message
END METHOD                                                        '

METHOD  pCmdHELP(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Invoke HELP file                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL mapid, i, j, lclALL, NumStart AS LONG, lclCmd, t AS STRING  '
LOCAL PID AS DWORD                                                '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHELP("HELP -IXHP"), _                                ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF gHlpKilled THEN MExitMeth                                   ' If killed, bail out

   '-----------------------------------------------------------------------------------------------+
   '- See if a multi-message follow on Help                                                        |
   '-----------------------------------------------------------------------------------------------+
   lclcmd = TP.ErrMsgLast                                         '
   IF PTBL.OpsNum = 0 AND ISNOTNULL(TP.ErrMsgLast) THEN           ' If possible multi-message
      INCR gfDoingMsg                                             '
      DispMessageList()                                           ' Go Display them
      CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB                    ' Set focus
      DECR gfDoingMsg                                             '
      TP.ErrMsgReset(%True)                                       ' Reset + LAST
      MExitMeth                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- To allow HELP CMDS, HELP LINE and HELP HELP to work, the CHM file must have                  |
   '-     non-changing KWDS to the appropriate Topic ID.                                           |
   '-     The code below needs -IXFM, -IXED, -IXFP, -IXFL, -IXEP, -IXEL and -IXHP to be kept in    |
   '-     the appropriate topics.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- See if we're doing ALL words                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.IsKwd("ALL") OR PTBL.GotLit > 1 THEN lclALL = %True    ' ALL?

   '-----------------------------------------------------------------------------------------------+
   '- Split by how many operands                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.GotLit = 0 THEN                                        ' No operands?
      IF IsFMtab THEN                                             ' If FM, OPEN at Working File Manager
         t = "-IXFM"                                              ' Fudge the KWD
         GOTO DoQLookup                                           '
      ELSE                                                        ' Else just Working ...
         t = "-IXED"                                              '
         GOTO DoQLookup                                           '
      END IF                                                      '
   END IF                                                         '

   IF PTBL.GotLit = 1 THEN                                        ' If just one parameter
      t = PTBL.Pos2(1)                                            ' Fetch it
      IF IsEQ(t, "MACROS") OR IsEQ(t, "MACRO") THEN               ' MACROS?
         t = "-IXMC"                                              '
         GOTO DoQLookup                                           '
      END IF                                                      '

      IF IsEQ(t, "THINBASIC") OR IsEQ(t, "BASIC") THEN            ' BASIC?
         lclcmd = "hh.exe " + gENV.EXEPath + "thinBasic.chm"      '
         PID = SHELL(lclcmd, gENV.HelpOpen)                       '
         MExitMeth                                                '
      END IF                                                      '

      IF IsEQ(t, "HELP") THEN                                     ' HELP itself?
         t = "-IXHP"                                              '
         GOTO DoQLookup                                           '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Not a switch to another HELP file, so ...                                                 |
      '--------------------------------------------------------------------------------------------+
      IF IsEQ(t, "CMD") OR IsEQ(t, "CMDS") OR IsEQ(t, "PRIM") OR IsEQ(t, "PRIMARY") THEN  '
         IF IsFMtab THEN                                          ' If FM, OPEN at FM Prim commands
            t = "-IXFP"                                           '
         ELSE                                                     '
            t = "-IXEP"                                           ' Else normal Primary
         END IF                                                   '
         GOTO DoQLookup                                           '
      ELSEIF IsEQ(t, "LINE") OR IsEQ(t, "LINES") THEN             '
         IF IsFMtab THEN                                          ' If FM, OPEN at FM Line commands
            t = "-IXFL"                                           '
         ELSE                                                     '
            t = "-IXEL"                                           ' Else Edit line commands
         END IF                                                   '
         GOTO DoQLookup                                           '
      END IF                                                      '
      '-----------------------------------------------------------------------------------------------+
      '- Do Quick lookup of a single word                                                             |
      '-----------------------------------------------------------------------------------------------+
      DoQLookup:                                                  '

      FOR i = 0 TO gHlpTMax                                       ' Reset found flags
         gHlpT(i).Found = REPEAT$(8, "0")                         '
         gHlpT(i).Hits = 0                                        '
      NEXT i                                                      '
      gHlpFCtr = 0                                                ' Reset stuff
      gHlpSWordsCtr = 1                                           '

      FOR i = 1 TO gHlpKCtr                                       ' Search the topic keywords
         IF UCASE$(gHlpK(i).Kwd) = UCASE$(t) THEN                 ' Found it?
            INCR gHlpFCtr                                         ' Count
            gHlpF(gHlpFCtr).Num = gHlpK(i).Num                    ' Save Topic ID
            gHlpF(gHlpFCtr).Ctr = "0001"                          ' Default count to 1
            gHlpF(gHlpFCtr).Hits = FORMAT$(gHlpK(i).Hits, "0000") ' Hits count
            EXIT FOR                                              '
         END IF                                                   '
      NEXT i                                                      '
      IF gHlpFCtr > 0 GOTO GotWhat                                '
   END IF                                                         '

   gHlpSWordsCtr = PTBL.GotLit                                    ' Set default
   gHlpSearchStr = ""                                             ' Reset search words
   j = 0                                                          '
   FOR i = 1 TO gHlpSWordsCtr                                     ' Extract search operands
      INCR j                                                      '
      gHlpSWords(j) = PTBL.Pos2(i)                                '
      gHlpSearchStr += PTBL.Pos2(i) + " "                         '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Do a full blown, multi word lookup                                                           |
   '-----------------------------------------------------------------------------------------------+
   FullLkup:                                                      '
   FOR i = 0 TO gHlpTMax                                          ' Reset found flags
      gHlpT(i).Found = REPEAT$(8, "0")                            '
      gHlpT(i).Hits = 0                                           '
   NEXT i                                                         '

   FOR i = 1 TO gHlpSWordsCtr                                     ' Look up each search word
      DoHelpSearch(gHlpSWords(i), i)                              '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now search for topics flagged as found                                                       |
   '-----------------------------------------------------------------------------------------------+
   gHlpFCtr = 0                                                   ' Reset found count
   FOR i = 0 TO gHlpTMax                                          ' Search found flags
      IF gHlpT(i).Found <> "00000000" THEN                        ' Found by some Kwd
         INCR gHlpFCtr                                            ' Save it
         gHlpF(gHlpFCtr).Num = i                                  ' Save TopicID
         gHlpF(gHlpFCtr).Ctr = FORMAT$(TALLY(gHlpT(i).Found, "1"), "0000") ' Count how many words were found
         gHlpF(gHlpFCtr).Hits = FORMAT$(gHlpT(i).Hits, "0000")    ' Copy the Hits count
      END IF                                                      '
   NEXT i                                                         '
   ARRAY SORT gHlpF() FOR gHlpFCtr, FROM 1 TO 8, DESCEND          ' Put highest count/Hits first

   GotWhat:                                                       '
   '-----------------------------------------------------------------------------------------------+
   '- What did we end up with                                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF gHlpFCtr = 0 THEN                                           ' Nothing?
      MErrExit(%eFail, "Topic search failed")                     '
   ELSEIF gHlpFCtr = 1 THEN                                       ' Just a single topic?
      mapid = gHlpF(1).Num                                        ' Then go open it
      GOTO Openit                                                 '
   ELSE                                                           ' More than one, must let user choose
      mapid = GetHelpAmbig(gHlpSWordsCtr)                         ' Go dis-ambiguate it
      MExitMeth                                                   ' GetHelpAMBIG has done it all
   END IF                                                         '

   Openit:                                                        '
   lclcmd = gENV.EXEPath + "SPFLite.chm"                          ' Build path
   lclCmd = "hh.exe -mapid " + FORMAT$(mapid) + " " + lclcmd      ' Build command string

   PID = SHELL(lclCmd, gENV.HelpOpen)                             ' Start the shelled application:
   ErrMsgHigh = %eNone                                            '
   MExitMeth                                                      '
END METHOD                                                        '

METHOD  pCmdHEX(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Turn HEX ON or OFF                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL lv AS LONG                                                  '
   lv = IIF(FCB.HexMode = 1, %False, %True)                       ' Convert existing to True/False
   FCB.HexMode = GetOnOff(1, lv, PCmd)                            ' Let GetOnOff do all the work
   FCB.HexMode = IIF(FCB.HexMode, 4, 1)                           ' Convert back to internal values
   SetCmd                                                         ' Cursor to Cmd line
   @P.PMarkLine = 0                                               ' Ditto for the Marked line
END METHOD                                                        '

METHOD  pCmdHIDE(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Turn Hide X|FILE ON or OFF                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL t1, t2, MSG AS STRING                                       '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   MSG = "?"                                                      ' Flag it
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO HideDisp, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "HIDE requires an operand") '

   T1 = PTBL.Grp("XFILE")                                         ' Get X or FILE
   T2 = PTBL.Grp("ONOFFON")                                       ' Get ON or OFF

   IF T1 = "X" THEN                                               ' If X HIDE
      IF T2 = "ON" THEN OnHideFlag                                ' Set the flag
      IF T2 = "OFF" THEN OffHideFlag                              '
   END IF                                                         '
   IF T1 = "FILE" THEN                                            ' If FILE HIDE
      IF T2 = "ON" THEN OnFileHide                                ' Set the flag
      IF T2 = "OFF" THEN OffFileHide                              '
   END IF                                                         '
   HideDisp:                                                      '
   t1 = IIF$(IsHideFlag, "ON", "OFF"): t2 = IIF$(IsFileHide, "ON", "OFF")  ' Set the variables
   DoProfMsg(MSG + "HIDE X is set to " + t1 + ", HIDE FILE is set to " + T2)  '
   MExitMeth                                                      '
END METHOD                                                        '

METHOD  pCmdHILITE(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Turn HILITE ON or OFF                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL Wrd AS STRING, i AS LONG                                    '
LOCAL fOn, fOff, fFind, fAuto AS LONG, MSG, t AS STRING           '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispHiLite, _                                       ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "HILITE requires an operand")  ' No Ops?

   t = PTBL.Grp("ONOFF")                                          ' Get the ON/OFF
   fFind = PTBL.IsKwd("FIND")                                     ' Get FIND status
   fAuto = PTBL.IsKwd("AUTO")                                     ' Get AUTO status

   IF t = "ON" THEN                                               ' ON specified
      IF ISFALSE fAuto AND ISFALSE fFind THEN                     ' Without operands
         FCB.HiFind = %True: FCB.HiAuto = %True                   ' Set FIND AUTO ON
         DoProfMsg("HILITE FIND/AUTO set ON")                     '
      ELSE                                                        ' Some Ops specified
         IF fFind THEN                                            ' FIND
            FCB.HiFind = %True: MSG = "FIND "                     ' Set FIND ON
         END IF                                                   '
         IF fAuto THEN                                            ' AUTO
            FCB.HiAuto = %True: MSG = IIF$(ISNULL(MSG), "AUTO ", MSG + "/AUTO ") ' Set AUTO ON
         END IF                                                   '
         IF ISNULL(MSG) THEN                                      ' No Operands?
            FCB.HiFind = %True                                    ' Set FIND ON
            FCB.HiAuto = %True                                    ' Set AUTO ON
            MSG = "FIND/AUTO "                                    '
         END IF                                                   '
         DoProfMsg("HILITE " + MSG + "set ON")                    '
         MExitMeth                                                '
      END IF                                                      '
   END IF                                                         '
   IF t = "OFF" THEN                                              ' OFF specified
      IF ISFALSE fAuto AND ISFALSE fFind THEN                     ' Without operands
         FCB.HiFind = %False                                      ' Set FIND OFF
         FCB.HiAuto = %False                                      ' Set AUTO OFF
         DoProfMsg("HILITE FIND/AUTO set OFF")                    '
      ELSE                                                        ' Some Ops specified
         IF fFind THEN                                            ' FIND
            FCB.HiFind = %False: MSG = "FIND "                    ' Set FIND OFF
         END IF                                                   '
         IF fAuto THEN                                            ' AUTO
            FCB.HiAuto = %False: MSG = IIF$(ISNULL(MSG), "AUTO ", MSG + "/AUTO ")   ' Set AUTO OFF
         END IF                                                   '
         IF ISNULL(MSG) THEN                                      ' No Operands?
            FCB.HiFind = %False                                   ' Set FIND OFF
            FCB.HiAuto = %False                                   ' Set AUTO OFF
            MSG = "FIND/AUTO "                                    '
         END IF                                                   '
         DoProfMsg("HILITE " + MSG + "set OFF")                   '
         MExitMeth                                                '
      END IF                                                      '
   END IF                                                         '
   IF fFind OR fAuto THEN                                         '
      IF fFind THEN                                               ' Just FIND?
         FCB.HiFind = %True                                       ' Set FIND ON
         MSG = "FIND "                                            ' Setup msg
      END IF                                                      '
      IF fAuto THEN                                               ' Just AUTO?
         FCB.HiAuto = %True                                       ' Set AUTO ON
         MSG = IIF$(ISNULL(MSG), "AUTO ", MSG + "/AUTO ")         ' Setup msg
      END IF                                                      '
      DoProfMsg("HILITE " + MSG + "set ON")                       '
   END IF                                                         '
   MExitMeth                                                      '

DispHilite:                                                       '
   IF ISTRUE FCB.HiFind AND ISTRUE FCB.HiAuto THEN                ' Both ON?
      DoProfMsg("?HILITE FIND/AUTO both ON")                      ' Tell user
   ELSEIF ISFALSE FCB.HiFind AND ISFALSE FCB.HiAuto THEN          ' Both OFF?
      DoProfMsg("?HILITE FIND/AUTO both OFF")                     ' Tell user
   ELSE                                                           ' Mixed
      DoProfMsg("?HILITE FIND " + IIF$(FCB.HiFind, "ON", "OFF") + _  '
                ", AUTO " + IIF$(FCB.HiAuto, "ON", "OFF"))        '
   END IF                                                         '
   MExitMeth                                                      ' Bail out
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdIMACRO(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Alter the IMACRO setting                                                                        |
'--------------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- Pass off to common parse routine                                                             |
   '-----------------------------------------------------------------------------------------------+
   pCmdXIMacro(pCmd, "IMACRO")                                    ' Call common routine
END METHOD                                                        '

METHOD  pCmdINCLUDE(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Set INCLUDE support name                                                                        |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispInclude, _                                      ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "INCLUDE requires an operand") '
   IF UCASE$(PTBL.Ops(1)) = "NONE" THEN                           ' What've we got
      FCB.PInclude = ""                                           '
   ELSE                                                           ' Save anything else
      FCB.PInclude = UCASE$(PTBL.Ops(1))                          '
   END IF                                                         '
   DispInclude:                                                   '
   DoProfMsg("?INCLUDE set to " + IIF$(ISNULL(FCB.PInclude), "NONE", FCB.PInclude)) ' Tell user
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdIEdit(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Invoke IEdit front end to MEdit                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL s, t1, t2, FNam, ProfName, PInclude, PDiag, InclPath, FArray AS STRING  '
LOCAL i, j, FCount, InMem AS LONG, RCA AS RCArea                  '
LOCAL ip AS InclParms                                             ' INCL parameters
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H IEDIT"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   '-----------------------------------------------------------------------------------------------+
   '- First extract the file name                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.GotLit = 0 THEN                                        ' No filename?
      IF TabMode <> %MEdit AND TabMode <> %Edit THEN MErrExit(%eFail, "Tab must be in EDIT or MEDIT mode")  '
      IF LastLine = 2 THEN MErrExit(%eFail, "There are no lines in the Edit") '
      InMem = %True                                               ' We're doing an InMem run
      FNam = "*"                                                  ' Set FNam to * (InMem)
      Profname = FCB.Profname                                     ' Copy Profname
   ELSE                                                           ' Got operand(s)
      FNam = MID$(PTBL.Pos("$", 1), 2)                            ' Get the filename
      FNam = SubstEnviron(FNam)                                   ' Do %xxx% substitution
      IF INSTR(FNam, "\") = 0 THEN _                              ' If we have something with no path
         FNam = GetDefaultFolder + FNam                           ' Add a path if it doesn't have one
      '--------------------------------------------------------------------------------------------+
      '- Eliminate open already somewhere else                                                     |
      '--------------------------------------------------------------------------------------------+
      i = VAL(FileQueue("S", " ", FNam))                          ' Returns tab number if open, else zero
      IF i THEN                                                   ' Tab number?
         GoToTab(i, "File already Open in this tab", "")          ' Issue msg and exit
         MExitMeth                                                '
      END IF                                                      '
      IF ISFALSE ISFILE(FNam) THEN _                              ' Exist?
         MErrExit(%eFail, "File does not exist, command cancelled")  ' Bail out
      Profname = GetProfileForFile(FNam, PDiag, %True, %True)     ' Get the Profile name (EFT,NotQuery)
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- See if INCLUDE has been set up                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE gSQL.TableExist("P" + ProfName) THEN _              ' Better exist
      MErrExit(%eFail, "Profile: " + ProfName + " does not exist")' Oops
   PInclude = gSQL.GetStringDirect("P" + ProfName, "PInclude", "")' Get the INCLUDE Profile value
   IF ISNULL(PInclude) THEN _                                     ' Never set up
      MErrExit(%eFail, "The INCLUDE option for Profile: " + ProfName + " has not been set up")  ' Oops
   '-----------------------------------------------------------------------------------------------+
   '- See if INCLPARSE looks valid                                                                 |
   '-----------------------------------------------------------------------------------------------+
   SETTableUpd("GET", "INCLPARSE." + PInclude, RCA)               ' Fetch INCLPARSE value
   IF RCA.RC > 0 THEN _                                           ' Not found?
      MErrExit(%eFail, "SET symbol: INCLPARSE." + PInclude + " not found") ' Fail it
   t1 = RCA.MSG: strunquote(t1)                                   ' Grab it
   DO WHILE ISNOTNULL(t1)                                         ' Verify ops
      t2 = GetNextWord(t1, %Strip)                                ' Get an operand
      strunquote(t2)                                              '
      SELECT CASE AS CONST$ UCASE$(LEFT$(t2, 5))                  ' Command name
         CASE "TRIG:": ip.Trig  = MID$(t2, 6)                     '
         CASE "CMNT:": ip.Cmnt  = MID$(t2, 6)                     '
         CASE "DLMS:": ip.DLMS  = MID$(t2, 6)                     '
         CASE "SUPP:": ip.Supp  = MID$(t2, 6)                     '
         CASE "WORD:": ip.Word = VAL(MID$(t2, 6))                 '
         CASE ELSE                                                ' Reject it
            MErrExit(%eFail, "INCLPARSE operand: " + t2 + " not recognized")  '
      END SELECT                                                  '
   LOOP                                                           '
   IF ISNULL(ip.Trig) OR ip.word = 0 THEN _                       ' More validation
      MErrExit(%eFail, "In INCLPARSE, Both TRIG: and WORD: operands are mandatory") '
   IF ip.word > 99 OR ip.Word < 1 THEN _                          '
      MErrExit(%eFail, "The INCLPARSE WORD: operand has an invalid value") '

   '-----------------------------------------------------------------------------------------------+
   '- Now do INCLPATHS                                                                             |
   '-----------------------------------------------------------------------------------------------+
   SETTableUpd("GET", "INCLPATHS." + PInclude, RCA)               ' Fetch INCLPATHS value
   IF RCA.RC > 0 THEN                                             ' Not found?
      InclPath = PATHNAME$(PATH, IIF$(FNam = "*", FCB.FilePath, FNam))  ' Use the FNam path
   ELSE                                                           '
      InclPath = RCA.Msg: strunquote(InclPath)                    ' Else get the SET value
      REPLACE "|" WITH ";" IN InclPath                            ' Swap | to ;
      REPLACE "*" WITH PATHNAME$(PATH, IIF$(FNam = "*", FCB.FilePath, FNam)) IN InclPath  ' Swap * to FNam path
   END IF                                                         '
   FOR i = 1 TO PARSECOUNT(InclPath, ";")                         ' Ensure they exist
      t1 = PARSE$(InclPath, ";", i)                               ' Get one
      IF ISFALSE ISFOLDER(t1) THEN _                              ' Better be a folder
         MErrExit(%eFail, "INCLPATHS folder: " + t1 + " does not exist")   '
   NEXT i                                                         '
   ip.Path = InclPath                                             ' Save in UDT area
   '-----------------------------------------------------------------------------------------------+
   '- Now do the scan and build of the MEdit command                                               |
   '-----------------------------------------------------------------------------------------------+
   DIM FArray(1 TO 1000) AS STRING                                ' Get answer array ready
   DoMultiScan(FNam, FArray(), FCount, ip)                        ' Scan it all
   t1 = "MEDIT " + IIF$(InMem, "", "NEW ")                        ' Start building the MEDIT cmd
   T1 += IIF$(FNam = "*", "", $DQ + FNam + $DQ + " ")             '
   IF FCount > 0 THEN                                             '
      ARRAY SORT FArray() FOR FCount                              ' Sort included files
      FOR i = 1 TO FCount                                         ' Copy the table
         t1 += $DQ + FArray(i) + $DQ + " "                        ' Add a filename
      NEXT i                                                      '
   END IF                                                         '
   pCMDMEdit(t1)                                                  ' Jump back to normal path
END METHOD                                                        '

METHOD  pCmdINSTANCE(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Do an INSTANCE switch                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL oEND, oCANCEL, oKeep, i, j, k, RC, x, y, FNum AS LONG       '
LOCAL INST, OpenL, DOMac, FileOpen, t, tt, fn, INSTMsg, IStyle AS STRING   '
STATIC CurrTab AS LONG, MRF AS STRING                             '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H INSTANCE"), _                                ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   '-----------------------------------------------------------------------------------------------+
   '- Create an MRF list immediately                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF IsFMTab THEN                                                ' In FM?
      IF Currtab = 0 THEN CurrTab = 1                             ' Set CurrTab if we started in FM
      MRF = BuildMRF(CurrTab)                                     ' Get an MRF list
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- See if we pass it off to the FM tab                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF ISFALSE IsFMTab THEN                                        ' Not in FM?
      CurrTab = TP.PgNumber                                       ' Save current tab #
      PassCmdToOtherTab(1, PCmd)                                  ' Do it in Tab 1
      MExitMeth                                                   '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- First string is always the Instance name                                                     |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "INSTANCE had no operands") '
   INST = UCASE$(PTBL.Pos2(1))                                    ' Copy it
   IF INST <> gENV.eInstance THEN                                 ' If a true switch
      FNum = FREEFILE                                             ' Get a file #
      t = gENV.HomeFolder + "_FILEOPEN.TXT"                       ' Create tempname
      Call3(TryOpenOutPut(t, FNum), _                             ' Try the open
            MErrExit(%eFail, "Oops! Can't open FILEOPEN.TXT file."), _  '
            MErrExit(%eFail, "Oops! The FILEOPEN.TXT file is in use."), _  '
            Nul)                                                  ' Continue
      PRINT # FNum, MRF                                           ' Save the data
      CLOSE # FNum                                                ' Close the file
   END IF                                                         '

   IStyle = PTBL.Grp("ECK")                                       ' Get the END/CAN/KEEP value
   IF IStyle = "END" THEN                                         ' Split off
      oEND = %True                                                ' END
   ELSEIF IStyle = "CANCEL" THEN                                  '
      oCANCEL = %True                                             ' CANCEL
   ELSEIF IStyle = "KEEP" THEN                                    '
      oKEEP = %True                                               ' KEEP
   END IF                                                         '

   IF PTBL.IsKwd("-F") THEN                                       ' The FILEOPEN operand ?
      '--------------------------------------------------------------------------------------------+
      '- Get the FILEOPEN filename, and do a bunch of validation on it                             |
      '--------------------------------------------------------------------------------------------+
      IF PTBL.GotLit < 2 THEN _                                   ' Kill if no operand
         InstMsg = "Missing -F operand value": GOSUB OTabMsg      '
      OpenL = UCASE$(PTBL.Pos2(2))                                ' Copy it
      IF OpenL = "*" THEN OpenL = gENV.HomeFolder + "_FILEOPEN.TXT"  ' If * use defaut name
      IF INSTR(OpenL, "\") = 0 THEN OpenL = gENV.HomeFolder + OpenL  ' Add Homefolder if no path present
      IF ISFALSE ISFILE(OpenL) THEN _                             ' If file does not exist
         InstMsg = "INSTANCE -F FILEOPEN file does not exist": GOSUB OTabMsg  ' Kill if no such file
      FNum = FREEFILE                                             ' Get a file #
      Call3(TryOpenInput(OpenL, FNum), _                          ' Try the open
            InstMsg = "The FILEOPEN file: " + OpenL + " Cannot be found.": GOSUB OTabMsg, _  '
            InstMsg = "The FILEOPEN file: " + OpenL + " Could not be opened.": GOSUB OTabMsg, _ '
            Nul)                                                  ' Continue
      FileOpen = ""                                               ' Reset
      DO WHILE ISFALSE EOF(FNum)                                  ' Read the data
         LINE INPUT # FNum, tt                                    ' Get the line
         FileOpen += TRIM$(tt)                                    ' Build 1 big line
      LOOP                                                        '
      CLOSE # FNum                                                ' Close the file
      REPLACE "," WITH "?" IN FileOpen                            ' Convert , to ?
      FileOpen = TRIM$(FileOpen)                                  ' Trim it
      IF ISNULL(FileOpen) THEN _                                  ' Better be something there
         InstMsg = "The FILEOPEN file is empty.": GOSUB OTabMsg   ' Bail out.
      '--------------------------------------------------------------------------------------------+
      '- Validate (somewhat) the FILEOPEN string                                                   |
      '--------------------------------------------------------------------------------------------+
      tt = FileOpen                                               ' Get a temp copy
      IF LEFT$(tt, 1) = "?" THEN tt = CLIP$(LEFT, tt, 1)          ' Peel off any leading / trailing ?
      IF RIGHT$(tt, 1) = "?" THEN tt = CLIP$(RIGHT, tt, 1)        '
      FOR j = 1 TO PARSECOUNT(tt, "?")                            ' Loop for each file in list
         t = PARSE$(tt, "?", j)                                   ' Get a filename
         IF LEFT$(t, 1) = "(" THEN t = CLIP$(LEFT, t, 3)          ' Remove any Open type
         IF INSTR(t, "|") <> 0 THEN                               ' A MEdit list?
            FOR k = 1 TO PARSECOUNT(t, "|")                       ' Check it
               fn =PARSE$(t, "|", k)                              ' Get a Fn from the MEdit string
               IF LEFT$(fn, 1) = "(" THEN fn = CLIP$(LEFT, fn, 3) ' Remove any Open type
               IF ISFALSE ISFILE(fn) THEN _                       '
                  InstMsg = "An -F FILEOPEN file: " + fn + " does not exist.": GOSUB OTabMsg ' Bail out.
            NEXT k                                                '
         ELSE                                                     '
            IF ISFALSE ISFILE(t) THEN _                           '
               InstMsg = "An -F FILEOPEN file: " + t + " does not exist.": GOSUB OTabMsg  ' Bail out.
         END IF                                                   '
      NEXT j                                                      '
   END IF                                                         '

   IF PTBL.IsKwd("-D") THEN                                       ' The DO operand ?
      '--------------------------------------------------------------------------------------------+
      '- Get the DO macro name and see if it exists                                                |
      '--------------------------------------------------------------------------------------------+
      k = IIF(ISNULL(OpenL), 2, 3)                                ' Setup needed Op number
      IF PTBL.GotLit < k THEN _                                   ' Kill if no operand
         InstMsg = "Missing -D operand value": GOSUB OTabMsg      ' Kill if no operand
      DoMac = UCASE$(PTBL.Pos2(k))                                ' Copy it
      IF ISFALSE ISFILE(gENV.HomeData + "MACROS\" + DoMac + ".DO") THEN _   ' See if it exists
         InstMsg = "INSTANCE -D macroname: " + DoMac + " does not exist": GOSUB OTabMsg   ' Kill if no such file
   END IF                                                         '

   IF ISFALSE oKEEP THEN                                          ' See if CAN|END needed?
      IF gTabsNum > 1 AND ISFALSE oCANCEL AND ISFALSE oEND THEN _ ' CAN|END needed?
         InstMsg = "Other tabs are active, close them or use the CANCEL, END or KEEP operands": GOSUB OTabMsg  '
   END IF                                                         '

   IF ISNOTNULL(DoMac) AND INST = gENV.eInstance AND oKEEP THEN _ ' Unsupported
      InstMsg = "Cannot use -D Macname with KEEP and the same Instance Name": GOSUB OTabMsg  '

   '-----------------------------------------------------------------------------------------------+
   '- Now actually DO something                                                                    |
   '-----------------------------------------------------------------------------------------------+
   gfEndAll = IIF(ISTRUE oKEEP, %False, %True)                    ' Set EndAll based on KEEP
   IF gTabsNum > 1 AND ISFALSE oKEEP THEN                         ' Remove other tabs if not KEEP
      FOR i = gTabsNum TO 2 STEP -1                               ' Do for each tab
         TP = gTabs(i)                                            ' Pick the Tab
         IF oEND THEN                                             ' END?
            me.CallTab("END", "")                                 ' Go do it
         ELSEIF oCANCEL THEN                                      ' CANCEL?
            me.CallTab("CANCEL", "")                              ' Go do it
         END IF                                                   '
      NEXT i                                                      '
      IF ISFALSE gfEndAll THEN gfEndAll = %False                  ' Somebody selected CANCEL, kill terminate
      IF gfEndAll AND oEND THEN                                   ' If shutting down with END
         gSQL.UpdateString("O", "MRFList", FileOpen)              ' Save the MRF
      ELSEIF gfEndAll AND oCANCEL THEN                            ' If shutting down with CAN
         gSQL.UpdateString("O", "MRFList", "")                    ' Save a null MRF
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Create BAT file to do the restart. Done to get a delay so 2 instances don't overlap          |
   '-----------------------------------------------------------------------------------------------+
   IF INST <> gENV.eInstance THEN                                 ' If not 'US' then
      FNum = FREEFILE                                             ' Get a file #
      t = gENV.HomeFolder + "_INSTANCE.BAT"                       ' Create tempname
      Call3(TryOpenOutPut(t, FNum), _                             ' Try the open
            InstMsg = "Oops! Can't open temp BAT file.": GOSUB OTabMsg, _  '
            InstMsg = "Oops! The temp BAT file is in use.": GOSUB OTabMsg, _  '
                  Nul)                                            ' Continue
      PRINT # FNum, "TIMEOUT /T 1 /NOBREAK"                       ' Insert the 1 second delay
      PRINT # FNum, $DQ + gENV.EXEFullPath + $DQ + " -I " + INST + _ ' Insert the command
                    IIF$(ISNOTNULL(OpenL), " -F " + IIF$(OpenL = "*", OpenL, $DQ + OpenL + $DQ), "") + _ '
                    IIF$(ISNOTNULL(DoMac), " -D " + DoMac, "")    '
      CLOSE # FNum                                                ' Close the file
      RC = SHELL(t, 0)                                            ' Invoke the BAT file
   ELSE                                                           '
      IF ISNOTNULL(OpenL) THEN                                    ' A FILEOPEN?
         DoInitString(FileOpen, "", "", "", %False)               ' Go do the Open(s)
      END IF                                                      '
   END IF                                                         '

   IF ISTRUE gfEndAll THEN                                        ' If we're shutting down
      gSQL.UpdateString("O", "FileListNm", TP.FileListNm)         ' Save some stuff
      gSQL.UpdateString("O", "DefDir1", TP.FPath)                 '
      gSQL.UpdateString("O", "DefMask", TP.FMask)                 '
      gENV.SetFMCrit(TP.DirSort, TP.DefSort, TP.FMask, gFMLayoutID) '
      gRtr.Save                                                   '
      gfTermFlag = %True                                          '
      DIALOG GET LOC ghWnd TO x, y                                '
      gENV.LastScreenX = x: gENV.LastScreenY = y                  '
      gENV.SetINITimeStamp                                        '
      DIALOG END ghWnd                                            ' Kill our dialog
      gTabsNum = 0                                                '
      gTabDelCtr = 0                                              '
      GoToTab(0, "", "")                                          '
      SETUNHANDLEDEXCEPTIONFILTER %Null                           ' Kill exception trap
      TRACE OFF                                                   '
      gSQL.VacuumDB                                               ' Vacuum CFG
      gSQL.DBClose                                                ' Close the CFG file
      ExitProcess(8)                                              ' Bail out
   ELSE                                                           '
      GoToTab(CurrTab, "", "")                                    ' Return to tab
      DoPendingTabSwitch                                          '
      TP.PCommand = ""                                            ' Clear command
      MErrExit(%eNone, "INSTANCE command processed")              ' Say we did something
   END IF                                                         '
   CurrTab = 0                                                    ' Reset CurrTab
   MExitMeth                                                      '

   OTabMsg:                                                       '
      GoToTab(CurrTab, "", "")                                    ' Return to tab
      DoPendingTabSwitch                                          '
      MErrExit(%eFail, InstMsg)                                   ' Issue message
      RETURN                                                      '
END METHOD                                                        '

METHOD  pCmdJOIN(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- JOIN Command                                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL i, RSRCH, RCHNG AS LONG, AllCount, PrevLastLine AS LONG     '
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Parse
         pCmdHelp("H JOIN"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   '-----------------------------------------------------------------------------------------------+
   '- Eliminate simple RSRCH first, then the RCHNG                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 1 AND RSRCH THEN me.pCmdFind("FIND RSRCH", "JOIN"): MExitMeth   ' Pass off RFIND to the FIND command

   IF PTBL.OpsNum = 1 AND RCHNG THEN                              ' RCHNG?
      IF LocFind <> "JOIN" THEN _                                 ' Last better be SPLIT
         MErrExit(%eFail, "Last search was NOT a JOIN command")   '
      RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values
      IF PTBL.FoundFailed = 0 THEN                                ' Last FIND was successful?
         me.Join()                                                ' Yes, Just do the Join
         TP.ErrMsgAdd(%eNone, "Join successful")                  '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
         PTBL.FoundFailed = 3                                     ' We're in not found mode again
      ELSE                                                        '
         i = me.Search(0, @P.C.CType)                             ' Go see if we can find it
         IF i = 0 THEN                                            ' Got it?
            TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
            PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)            ' Remember we failed
         ELSE                                                     '
            me.Join()                                             ' Do the Join
            TP.ErrMsgAdd(%eNone, "Join successful")               '
            ErrMsgHigh = %eNone                                   ' Say we 're OK
         END IF                                                   '
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Multiple operands handle them watching for RSRCH and RCHNG                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAssign), _                         ' Complete the Parse
         PCmdHelp("H JOIN"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   PTBL.FlgNext = %True: PTBL.FlgPrev = %False                    ' Set NEXT

   IF ISFALSE PTBL.FlgLit1 THEN _                                 ' Lit1 present?
      MErrExit(%eFail, "Missing JOIN search string")              '

   IF ISFALSE PTBL.FlgL1Picture AND ISFALSE PTBL.FlgL1RegEx THEN _   ' Lit1 must be P type  or R type
      MErrExit(%eFail, "JOIN search string must be P or R type literal")   '

   IF PTBL.FlgL1Picture OR PTBL.FlgL1RegEx THEN                   ' P/R type, must be with LM or RM, but not both
      IF (PTBL.FlgLM AND ISFALSE PTBL.FlgRM) OR _                 '
         (ISFALSE PTBL.FlgLM AND PTBL.FlgRM) THEN                 '
                                                                  '
      ELSE                                                        '
         MErrExit(%eFail, "JOIN search must not have both Line Start and Line End selection")   '
      END IF                                                      '
   END IF                                                         '

   IF ISFALSE PTBL.FlgLit2 THEN                                   ' Lit2 present?
      PTBL.FlgLit2 = %True                                        ' Provide a default
      PTBL.L2RData = "!"                                          ' of P'!'
   ELSE                                                           '
      IF PTBL.SplitPoint2 THEN _                                  ' No | chars in Join
         MErrExit(%eFail, "Split character | not allowed in JOIN change string") '
   END IF                                                         '
   LocFind = "JOIN"                                               ' Remember which LOC / FIND command was last
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values

   '-----------------------------------------------------------------------------------------------+
   '- OK - do the searching                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      RESET AllCount                                              ' Reset variables
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         IF RSRCH THEN MExitMeth                                  ' Just RSRCH, exit
         PrevLastLine = LastLine                                  ' Save LastLine
         IF me.Join() THEN i = %False                             ' Do the Join
         IF LastLine <> PrevLastLine THEN INCR AllCount           ' Linecount altered? count it
         IF RCHNG THEN MExitMeth                                  ' RCHNG, then exit
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CInternal)                             ' Do re-Finds, Tell Search that sLin/sCol are set
         IF i THEN                                                ' Found one
            IF RSRCH THEN MExitMeth                               ' Just RSRCH, exit
            PrevLastLine = LastLine                               ' Save LastLine
            IF me.Join() THEN i = %False                          ' Do Join, -  signalled LastLine?
            IF LastLine <> PrevLastLine THEN INCR AllCount        ' Linecount altered? count it
            IF RCHNG THEN MExitMeth                               ' RCHNG, then exit
         END IF                                                   '
      LOOP                                                        '
      IF AllCount = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(nMac(%eFail), "Join point not found")       '
      ELSE                                                        '
         TP.ErrMsgAdd(0, "Join performed " + FORMAT$(Allcount) + " times") '
      END IF                                                      '

   ELSE                                                           ' The non-All version
      i = me.Search(0, @P.C.CType)                                ' Go see if we can find it
      IF i = 0 THEN                                               ' Got it?
         TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)               ' Remember we failed
      ELSE                                                        '
         IF RSRCH THEN MExitMeth                                  ' Just RSRCH, exit
         PrevLastLine = LastLine                                  ' Save LastLine
         IF me.Join() THEN i = %False                             ' Do the Join
         TP.ErrMsgAdd(%eNone, IIF$(LastLine <> PrevLastLine, "Join successful", "Join not possible")) '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdKEYMAP(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Display the KeyMap                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k AS LONG, t, tf, tt, key AS STRING                   '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H KEYMAP"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN                                        ' The simple one?
      DispKeyMap(0)                                               ' Go Display it
      CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB                    ' Set focus
      MExitMeth                                                   '
   END IF                                                         '

   IF PTBL.IsKwd("LIST")  THEN GOTO DoList                        ' LIST - go do it
   IF PTBL.IsKwd("QUERY") THEN GOTO DoQuery                       ' Query - go do it
   MErrExit(%eFail, "Unknown KEYMAP operand")                     ' No, kill it

   DoList:                                                        '
   '-----------------------------------------------------------------------------------------------+
   '- Do the reverse map                                                                           |
   '-----------------------------------------------------------------------------------------------+
   GOSUB KBAddHeader1                                             ' Add header
   FOR i = 1 TO 107                                               ' Loop through the Key Table
      IF gKbdT.ForceUp(i) = "D" THEN ITERATE FOR                  '
      IF UUCASE(gKbdT.NData(i)) <> "(NULL)" AND UUCASE(gKbdT.NData(i)) <> "(PASSTHRU)" THEN  ' Set to something?
         tt = LSET$(gKbdT.Labl(i), 24)                            '
         IF UCASE$(LEFT$(gKbdT.NData(i), 3)) = "<IF" THEN         ' Conditional?
            tt += SPACE$(10) + gKbdT.NData(i) + $CRLF             ' No, just add the data
         ELSEIF LEFT$(gKbdT.NData(i), 1) <> "<" THEN              ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.NData(i) + $CRLF             ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.NData(i), INSTR(gKbdT.NData(i), ">")), 10)   '
            tt += MID$(gKbdT.NData(i), INSTR(gKbdT.NData(i), ">") + 1) + $CRLF   '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
      IF UUCASE(gKbdT.SData(i)) <> "(NULL)" AND UUCASE(gKbdT.SData(i)) <> "(PASSTHRU)" THEN  ' Set to something?
         tt = LSET$("Shft-" + gKbdT.Labl(i), 24)                  '
         IF UCASE$(LEFT$(gKbdT.SData(i), 3)) = "<IF" THEN         ' Conditional?
            tt += SPACE$(10) + gKbdT.SData(i) + $CRLF             ' No, just add the data
         ELSEIF LEFT$(gKbdT.SData(i), 1) <> "<" THEN              ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.SData(i) + $CRLF             ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.SData(i), INSTR(gKbdT.SData(i), ">")), 10)   '
            tt += MID$(gKbdT.SData(i), INSTR(gKbdT.SData(i), ">") + 1) + $CRLF   '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
      IF UUCASE(gKbdT.CData(i)) <> "(NULL)" AND UUCASE(gKbdT.CData(i)) <> "(PASSTHRU)" THEN  ' Set to something?
         tt = LSET$("Ctrl-" + gKbdT.Labl(i), 24)                  '
         IF UCASE$(LEFT$(gKbdT.CData(i), 3)) = "<IF" THEN         ' Conditional?
            tt += SPACE$(10) + gKbdT.CData(i) + $CRLF             ' No, just add the data
         ELSEIF LEFT$(gKbdT.CData(i), 1) <> "<" THEN              ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.CData(i) + $CRLF             ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.CData(i), INSTR(gKbdT.CData(i), ">")), 10)   '
            tt += MID$(gKbdT.CData(i), INSTR(gKbdT.CData(i), ">") + 1) + $CRLF   '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
      IF UUCASE(gKbdT.AData(i)) <> "(NULL)" AND UUCASE(gKbdT.AData(i)) <> "(PASSTHRU)" THEN  ' Set to something?
         tt = LSET$("Alt-" + gKbdT.Labl(i), 24)                   '
         IF UCASE$(LEFT$(gKbdT.AData(i), 3)) = "<IF" THEN         ' Conditional?
            tt += SPACE$(10) + gKbdT.AData(i) + $CRLF             ' No, just add the data
         ELSEIF LEFT$(gKbdT.AData(i), 1) <> "<" THEN              ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.AData(i) + $CRLF             ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.AData(i), INSTR(gKbdT.AData(i), ">")), 10)   '
            tt += MID$(gKbdT.AData(i), INSTR(gKbdT.AData(i), ">") + 1) + $CRLF   '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
      IF UUCASE(gKbdT.SCData(i)) <> "(NULL)" AND UUCASE(gKbdT.SCData(i)) <> "(PASSTHRU)" THEN   ' Set to something?
         tt = LSET$("Shft-Ctrl-" + gKbdT.Labl(i), 24)             '
         IF UCASE$(LEFT$(gKbdT.SCData(i), 3)) = "<IF" THEN        ' Conditional?
            tt += SPACE$(10) + gKbdT.SCData(i) + $CRLF            ' No, just add the data
         ELSEIF LEFT$(gKbdT.SCData(i), 1) <> "<" THEN             ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.SCData(i) + $CRLF            ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.SCData(i), INSTR(gKbdT.SCData(i), ">")), 10) '
            tt += MID$(gKbdT.SCData(i), INSTR(gKbdT.SCData(i), ">") + 1) + $CRLF '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
      IF UUCASE(gKbdT.SAData(i)) <> "(NULL)" AND UUCASE(gKbdT.SAData(i)) <> "(PASSTHRU)" THEN   ' Set to something?
         tt = LSET$("Shft-Alt-" + gKbdT.Labl(i), 24)              '
         IF UCASE$(LEFT$(gKbdT.SAData(i), 3)) = "<IF" THEN        ' Conditional?
            tt += SPACE$(10) + gKbdT.SAData(i) + $CRLF            ' No, just add the data
         ELSEIF LEFT$(gKbdT.SAData(i), 1) <> "<" THEN             ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.SAData(i) + $CRLF            ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.SAData(i), INSTR(gKbdT.SAData(i), ">")), 10) '
            tt += MID$(gKbdT.SAData(i), INSTR(gKbdT.SAData(i), ">") + 1) + $CRLF '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
      IF UUCASE(gKbdT.SCAData(i)) <> "(NULL)" AND UUCASE(gKbdT.SCAData(i)) <> "(PASSTHRU)" THEN ' Set to something?
         tt = LSET$("Shft-Ctrl-Alt-" + gKbdT.Labl(i), 24)         '
         IF UCASE$(LEFT$(gKbdT.SCAData(i), 3)) = "<IF" THEN       ' Conditional?
            tt += SPACE$(10) + gKbdT.SCAData(i) + $CRLF           ' No, just add the data
         ELSEIF LEFT$(gKbdT.SCAData(i), 1) <> "<" THEN            ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.SCAData(i) + $CRLF           ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.SCAData(i), INSTR(gKbdT.SCAData(i), ">")), 10)  '
            tt += MID$(gKbdT.SCAData(i), INSTR(gKbdT.SCAData(i), ">") + 1) + $CRLF  '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
      IF UUCASE(gKbdT.CAData(i)) <> "(NULL)" AND UUCASE(gKbdT.CAData(i)) <> "(PASSTHRU)" THEN   ' Set to something?
         tt = LSET$("Ctrl-Alt-" + gKbdT.Labl(i), 24)              '
         IF UCASE$(LEFT$(gKbdT.CAData(i), 3)) = "<IF" THEN        ' Conditional?
            tt += SPACE$(10) + gKbdT.CAData(i) + $CRLF            ' No, just add the data
         ELSEIF LEFT$(gKbdT.CAData(i), 1) <> "<" THEN             ' PFKSHOW Label?
            tt += SPACE$(10) + gKbdT.CAData(i) + $CRLF            ' No, just add the data
         ELSE                                                     ' Else, space out the label
            tt += LSET$(LEFT$(gKbdT.CAData(i), INSTR(gKbdT.CAData(i), ">")), 10) '
            tt += MID$(gKbdT.CAData(i), INSTR(gKbdT.CAData(i), ">") + 1) + $CRLF '
         END IF                                                   '
         t += tt                                                  ' Add line to string
      END IF                                                      '
   NEXT i                                                         '
   gKeyPrimOper = ""                                              ' Null clipboard descriptor
   ClipboardWrite(t)                                              ' Write string to clipboard
   pCmdCLIP("CLIP")                                               '
   MExitMeth                                                      '

   DoQuery:                                                       '
   IF PTBL.GotLit = 0 THEN _                                      ' If no key operand
      MErrExit(%eFail, "Missing KEYMAP QUERY operand")            '
   key = UUCASE(PTBL.Pos2(1))                                     '
   FOR i = 107 TO 1 STEP -1                                       ' Loop through the Key Table
      t = UUCASE(gKbdT.NData(i))                                  ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$(TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF   '
         END IF                                                   '
      END IF                                                      '
      t = UUCASE(gKbdT.SData(i))                                  ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$("S-" + TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF  '
         END IF                                                   '
      END IF                                                      '
      t = UUCASE(gKbdT.CData(i))                                  ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$("C-" + TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF  '
         END IF                                                   '
      END IF                                                      '
      t = UUCASE(gKbdT.AData(i))                                  ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$("A-" + TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF  '
         END IF                                                   '
      END IF                                                      '
      t = UUCASE(gKbdT.SCData(i))                                 ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$("SC-" + TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF '
         END IF                                                   '
      END IF                                                      '
      t = UUCASE(gKbdT.SAData(i))                                 ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$("SA-" + TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF '
         END IF                                                   '
      END IF                                                      '
      t = UUCASE(gKbdT.SCAData(i))                                ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$("SCA-" + TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF   '
         END IF                                                   '
      END IF                                                      '
      t = UUCASE(gKbdT.CAData(i))                                 ' Get the KB string
      IF t <> "(NULL)" THEN                                       ' Other than (NULL)?
         GOSUB KBSearch                                           ' Do the search
         IF ISNOTNULL(tf) THEN                                    ' If this key contains string
            GOSUB KBAddHeader2                                    ' Add header (Maybe)
            tt += LSET$("CA-" + TRIM$(gKbdT.Labl(i)), 12) + " Map: " + t + $CRLF '
         END IF                                                   '
      END IF                                                      '
   NEXT i                                                         '
   IF ISNULL(tt) THEN _                                           ' We issued a message
      MErrExit(%eFail, "'" + PTBL.Ops(2) + "'" + " was not found in any assigned key") '
   gKeyPrimOper = ""                                              ' Null clipboard descriptor
   ClipboardWrite(tt)                                             ' Write string to clipboard
   pCmdCLIP("CLIP")                                               '
   MExitMeth                                                      '

KBAddHeader1:                                                     '
   IF ISNULL(t) THEN  t = "Key                     PFK Def   Mapping" + $CRLF + REPEAT$(80, "=") + $CRLF '
   RETURN                                                         '
KBAddHeader2:                                                     '
   IF ISNULL(tt) THEN  tt = "'" + tf + "' was found in:" + $CRLF + REPEAT$(80, "=") + $CRLF  '
   RETURN                                                         '
KBSearch:                                                         '
   tf = ""                                                        ' Null answer for not found
   j = INSTR(t, key)                                              ' See if this key contain string
   IF j = 0 THEN RETURN                                           ' No, return not found
   IF j = 1 THEN                                                  ' Found at left end?
      k = j                                                       ' Look for delimiter
      DO WHILE k <= LEN(t) AND INSTR($AlphaNum, MID$(t, k, 1)) <> 0  '
         INCR k                                                   '
      LOOP                                                        '
      tf = MID$(t, j TO k - 1)                                    ' Pick up found word
   ELSEIF j + LEN(key) - 1 = LEN(t) THEN                          ' Found at right hand end?
      tf = MID$(t, j)                                             ' Pick up found word
   ELSE                                                           ' Found in the middle
      k = j                                                       ' Look for delimiter
      DO WHILE k >= 1 AND INSTR($AlphaNum, MID$(t, k, 1)) <> 0    '
         DECR k                                                   '
      LOOP                                                        '
      j = IIF(k = 0, 1, k + 1)                                    ' Set left end
      k = j                                                       ' Look for delimiter
      DO WHILE k <= LEN(t) AND INSTR($AlphaNum, MID$(t, k, 1)) <> 0  '
         INCR k                                                   '
      LOOP                                                        '
      tf = MID$(t, j TO k - 1)                                    ' Pick up found word
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdLABEL(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- LABEL Command                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lclLab, lclTag, t, NewCmd, Al, Rl, Sl, SrchMode AS STRING   '
LOCAL i, j, k AS LONG, LLastLine, OpCount, AdjDir, SrchFirst, SrchLast, SrchStep AS LONG  '
LOCAL lclCol, ldir, lsline AS LONG                                ' Local saves for FIND ALL
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H LABEL"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   '-----------------------------------------------------------------------------------------------+
   '- Extract the 1st label operand, then rescan                                                   |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO PTBL.OpsNum                                       ' Scan the operands
      t = PTBL.Ops(i)                                             ' Get into work field
      IF ISNULL(lclLab) THEN                                      ' Found it yet?
         IF (LEFT$(t, 1) = "." OR LEFT$(t, 1) = "!") AND LEN(t) > 1 THEN   ' Possible Label?
            lclLab = LSET$(UUCASE(t), 8)                          ' Save it
            ITERATE FOR                                           ' Done with this one
         END IF                                                   '
      END IF                                                      '
      NewCmd += t + " "                                           ' Add to NewCmd
   NEXT i                                                         '
   Call3(PTBL.ParseCmd("LABEL " + NewCmd, %PAll), _               ' Try the Parse again
         PCmdHelp("H LABEL"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   '-----------------------------------------------------------------------------------------------+
   '- Now decide what's left and reparse it with unique models                                     |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.GotLit THEN                                            ' The Literal (search) version?
      Call3(PTBL.ParseCmd("LABELS " + NewCmd, %PAll), _           ' Try the edited command now
            pCmdHelp("H LABEL"), _                                ' ? entered
            MErrExit(%eFail, PTBL.ErrMsg), _                      ' Error, Bail out
            Nul)                                                  '
      GOTO LabelLiteral                                           ' Continue

   ELSEIF PTBL.GotDotd = 1 OR PTBL.GotLPtr = 1 THEN               ' The .label version
      Call3(PTBL.ParseCmd("LABELL " + NewCmd, %PAll), _           ' Try the edited command now
            pCmdHelp("H LABEL"), _                                ' ? entered
            MErrExit(%eFail, PTBL.ErrMsg), _                      ' Error, Bail out
            Nul)                                                  '
      GOTO LabelLabel                                             ' Continue

   ELSEIF PTBL.GotTag THEN                                        ' The :Tag version
      Call3(PTBL.ParseCmd("LABELT " + NewCmd, %PAll), _           ' Try the edited command now
            pCmdHelp("H LABEL"), _                                ' ? entered
            MErrExit(%eFail, PTBL.ErrMsg), _                      ' Error, Bail out
            Nul)                                                  '
      GOTO LabelTag                                               ' Continue

   ELSEIF ISNOTNULL(lclLab) THEN                                  ' Just lclLab
      IF ISNOTNULL(TRIM$(NewCmd)) THEN MErrExit(%eFail, "Label command: Illogical operands") ' No idea what's wanted
      j = me.LineNoRef(lclLab)                                    ' First get real index
      IF j <> -1 THEN                                             ' If so
         Rl = TRIM$(LLblG(j))                                     ' Get current label
         LLblS(j) = $BlankLno                                     ' Blank it
         me.UpdLControl(j)                                        ' And LLCtl
         MErrExit(%eNone, IIF$(ISNULL(Rl), "There was no label on line " + TRIM$(lclLab), "Label: " + Rl + " removed")) '
      ELSE                                                        '
         MErrExit(%eFail, "Label: " + TRIM$(lclLab) + " is unassigned") '
      END IF                                                      '
   END IF                                                         '

LabelLiteral:                                                     '
   '-----------------------------------------------------------------------------------------------+
   '- Do the search literal style version                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(lclLab, 2) = ".Z" THEN MErrExit(%eFail, "Illegal use of a .Zxxx Label") ' No Special labels
   IF LEFT$(lclLab, 1) = "!"  THEN MErrExit(%eFail, "Illegal use of a !nnn Line Pointer") ' No Special labels
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   LocFind = "LABEL"                                              ' Remember who's searching
   RESET Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen  ' Reset 1st found values

   i = me.Search(0, @P.C.CType)                                   ' Go see if we can find it
   IF i = 0 THEN                                                  ' Got it?
      TP.ErrMsgAdd(nmac(%eFail), IIF$(PTBL.Grp("Position") = "NEXT", "Bottom of data reached", "Top of data reached"))  '
      PTBL.FoundLine = 0: PTBL.FoundCol = 0: PTBL.FoundLen = 0    ' Reset PTBL area
      PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)                  ' Remember we failed
      MExitMeth                                                   '
   END IF                                                         '
   i = PTBL.FoundLine                                             ' Put found location in i
   GOSUB LBLLine                                                  ' Go add the label
   MExitMeth                                                      ' We're done

LabelLabel:                                                       '
   '-----------------------------------------------------------------------------------------------+
   '- Set based on some other labeled line                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(lclLab, 2) = ".Z" THEN MErrExit(%eFail, "Illegal use of a .Zxxx Label") ' No Special labels
   IF LEFT$(lclLab, 1) = "!"  THEN MErrExit(%eFail, "Illegal use of a !nnn Line Pointer") ' No Special labels
   IF PTBL.GotDotd = 1 THEN                                       ' A dotted label?
      i = me.LineNoRef(PTBL.Pos(".", 1))                          ' Find the Dotted label
      IF i = -1 THEN MErrExit(%eFail, "Label: " + PTBL.Pos(".", 1) + " is not valid")  '
   END IF                                                         '
   IF PTBL.GotLPtr = 1 THEN                                       ' A ! line pointer?
      i = me.LineNoRef(PTBL.Pos("!", 1))                          ' Find the Lptr
      IF i = -1 THEN MErrExit(%eFail, "LinePtr: " + PTBL.Pos("!", 1) + " is not valid")   '
   END IF                                                         '
   GOSUB LBLLine                                                  ' Go add the label
   MExitMeth                                                      ' We're done

LabelTag:                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Set based on some Tagged line                                                                |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(lclLab, 2) = ".Z" THEN MErrExit(%eFail, "Illegal use of a .Zxxx Label") ' No Special labels
   IF LEFT$(lclLab, 1) = "!"  THEN MErrExit(%eFail, "Illegal use of a !nnn Line Pointer") ' No Special labels
   SrchMode = PTBL.Grp("POSITION")                                ' Get NEXT/PREV/FIRST/LAST
   IF PTBL.FindRngSet THEN                                        ' If a range set
      SrchFirst = PTBL.FindRngStart: SrchLast = PTBL.FindRngEnd   ' Pick it up
   ELSE                                                           '
      SrchFirst = 2: SrchLast = LastLine - 1                      ' Else ALL
   END IF                                                         '
   SELECT CASE AS CONST$ SrchMode                                 '
      CASE "LAST"                                                 ' LAST
         SWAP SrchFirst, SrchLast: SrchMode = "PREV": SrchStep = -1  '
      CASE "PREV"                                                 ' PREV
         SWAP SrchFirst, SrchLast: SrchStep = -1                  '
      CASE "NEXT"                                                 ' NEXT
         SrchStep = 1                                             '
         IF PTBL.GotDotd = 0 THEN                                 ' No specific range?
            SrchFirst = @P.PTopLine                               ' Figure out where to start
            IF @P.C.CType = %CLData AND ISFALSE gMacLCsr THEN     ' In the Data Area?
               SrchFirst = me.SGet(@P.C.CRow)                     ' Swap in current cursor location
            END IF                                                '
         END IF                                                   '
      CASE "FIRST"                                                ' FIRST
         SrchMode = "NEXT": SrchStep = 1                          '
   END SELECT                                                     '
   '-----------------------------------------------------------------------------------------------+
   '- OK, line range to search established, lets do it                                             |
   '-----------------------------------------------------------------------------------------------+
   lclTag = UCASE$(LSET$(PTBL.Pos(":", 1), 8)): i = 0             ' Setup the tag string
   FOR j = SrchFirst TO SrchLast STEP SrchStep                    ' Look for our tag
      IF lclTag = LTagG(j) THEN i = j: EXIT FOR                   ' We've found it
   NEXT i                                                         '
   IF i = 0 THEN MErrExit(%eFail, "Tag: " + TRIM$(lclTag) + " was not found") '
   GOSUB LBLLine                                                  ' Go add the label
   MExitMeth                                                      ' We're done

   LBLLine:                                                       '
      '--------------------------------------------------------------------------------------------+
      '- Mark the line (specified in i, after adjusting any +- value                               |
      '--------------------------------------------------------------------------------------------+
      j = me.LineNoRef(lclLab)                                    ' First clear any existing
      IF j <> -1 THEN                                             ' If so
         Rl = TRIM$(RIGHT$(LLNumG(j), gENV.LinNoSize))            ' Format the Removed Lno
         LLblS(j) = $BlankLno                                     ' Blank it
         me.UpdLControl(j)                                        ' And LLCtl
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Do any adjustment needed                                                                  |
      '--------------------------------------------------------------------------------------------+
      IF PTBL.GotAdj THEN                                         ' An adjustment coded?
         k = VAL(MID$(PTBL.Pos("+", 1), 2))                       ' Get numeric value
         AdjDir = IIF(LEFT$(PTBL.Pos("+", 1), 1) = "+", 1, -1)    ' Remember direction
         IF AdjDir = 1 THEN                                       ' Forward?
            i = me.CRPFwd(%MOData, i, k)                          ' Adjust it Fwd
         ELSE                                                     '
            i = me.CRPBack(%MOData, i, k)                         ' Or Backward
         END IF                                                   '
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Now set it in the new position                                                            |
      '--------------------------------------------------------------------------------------------+
      Sl = TRIM$(LLBLG(i))                                        ' Grab anything being overlaid
      LLblS(i) = lclLab                                           ' Set the label
      me.UpdLControl(i)                                           ' And LLCtl
      Al = RIGHT$(LLNumG(i), gENV.LinNoSize)                      ' Format the Add Lno
      IF ISNOTNULL(Rl) THEN                                       ' A replacement line
         TP.ErrMsgAdd(%eNone, "Label: " + TRIM$(lclLab) + " added to Line: " + Al + IIF$(j AND Al <> Rl, " and removed from: " + Rl, "")) '
      ELSE                                                        '
         TP.ErrMsgAdd(%eNone, "Label: " + TRIM$(lclLab) + " added to Line: " + Al + IIF$(ISNULL(Sl), "", " Replacing: " + Sl))   '
      END IF                                                      '
      ErrMsgHigh = %eNone                                         ' Say we 're OK
      RETURN                                                      '

   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdLCUC(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- LC / UC / SC / TC Commands                                                                      |
'--------------------------------------------------------------------------------------------------+
LOCAL Txt1, txt2 AS STRING                                        '
LOCAL i, j, k, scol, ecol, m, x, y, z, Caps, lclFlag AS LONG      '
LOCAL NumDone AS LONG                                             '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         pCmdHelp("H " + PTBL.Ops(0)), _                          ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   IF ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgALL THEN _      ' Better be something
      MErrExit(%eFail, "Pending line range")                      '
   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '

   scol = FCB.BndLeft: ecol = FCB.BndRight                        ' Get local bounds
   IF PTBL.FlgFCol THEN scol = PTBL.ColFrom                       ' Was left col specified? If so get it
   IF PTBL.FlgTCol THEN ecol = PTBL.ColTo                         ' Was right col specified? If so get it
   Caps = %True                                                   ' 1st word overall gets capitalized

   RESET Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen  ' Reset 1st found values
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN GOSUB DoChange                                    ' If found, Do the change
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN GOSUB DoChange                                 ' If found, Do the Change
      LOOP                                                        '
   ELSE                                                           ' The non-All version
      i = me.Search(0, @P.C.CType)                                ' Go see if we can find it
      IF i THEN GOSUB DoChange                                    ' If found, Do the change
   END IF                                                         '

   IF NumDone = 0 THEN                                            '
      TP.ErrMsgAdd(%eFail, "No eligible line(s) altered")         '
   ELSE                                                           '
      TP.ErrMsgAdd(%eNone, FORMAT$(NumDone) + " line" + IIF$(NumDone = 1, "", "s") + " altered")   '
   END IF                                                         '
   MExitMeth                                                      '

DoChange:                                                         '
   j = PTBL.FoundLine                                             ' Get the line index
   me.CurSetReq(%Change, j, 1 + @P.POffset, %True)                ' Set cursor set attempt
   me.ModSet(j)                                                   ' Remember we changed something
   SELECT CASE UUCASE(PTBL.Ops(0))                                ' See which we do
      CASE "UC"                                                   ' UpperCase
         IF IsLData(j) THEN                                       ' Only Data lines
            GOSUB DoPMinus                                        ' Do the +/- stuff
            me.LFlagBitOff(j, %EQChange)                          ' Reset ==CHG>
            me.UpdLControl(j)                                     ' And LLCtl
            IF scol > 1 OR ecol > 0 THEN                          ' Honour BNDS setting?
               FOR k = 1 TO LEN(L(j).@LTxt)                       ' Do it the hard way
                  IF k >= scol AND k <= ecol THEN _               '
                     me.LTxtCharRep(j, k, UUCASE(MID$(LTxtG(j), k, 1))) '
               NEXT k                                             '
            ELSE                                                  ' No BNDS, the simple way
               me.LTxtSet(j, UUCASE(LTxtG(j)))                    ' Do the Lowercase if a DataLine
            END IF                                                '
            INCR NumDone                                          '
         END IF                                                   '

      CASE "LC"                                                   ' LowerCase
         IF IsLData(j) THEN                                       ' Only Data lines
            GOSUB DoPMinus                                        ' Do the +/- stuff
            me.LFlagBitOff(j, %EQChange)                          ' Reset ==CHG>
            me.UpdLControl(j)                                     ' And LLCtl
            IF scol > 1 OR ecol > 0 THEN                          ' Honour BNDS setting?
               FOR k = 1 TO LEN(L(j).@LTxt)                       ' Do it the hard way
                  IF k >= scol AND k <= ecol THEN _               '
                     me.LTxtCharRep(j, k, LLCASE(MID$(LTxtG(j), k, 1))) '
               NEXT k                                             '
            ELSE                                                  ' No BNDS, the simple way
               me.LTxtSet(j, LLCASE(LTxtG(j)))                    ' Do the Lowercase if a DataLine
            END IF                                                '
            INCR NumDone                                          '
         END IF                                                   '

      CASE "SC"                                                   ' Sentence Case
         IF IsLData(j) THEN                                       ' Only Data lines
            GOSUB DoPMinus                                        ' Do the +/- stuff
            me.LFlagBitOff(j, %EQChange)                          ' Reset ==CHG>
            me.UpdLControl(j)                                     ' And LLCtl
            IF scol > 1 OR ecol > 0 THEN                          ' Honour BNDS setting?
               Txt1 = LLCASE(MID$(LTxtG(j), scol, ecol - scol + 1))  ' Get copy of substring to process
               GOSUB DoSChunk                                     ' Go process this piece
            ELSE                                                  ' No BNDS, the simple way
               Txt1 = LLCASE(MID$(LTxtG(j), 1, LEN(L(j).@LTxt)))  ' Get copy of substring to process
               GOSUB DoSChunk                                     ' Go process this piece
            END IF                                                '
            txt2 = LTxtG(j)                                       ' Get whole text line
            MID$(txt2, scol, ecol - scol + 1) = Txt1              ' Stuff back in the processed txt
            me.LTxtSet(j, txt2)                                   ' Replace the whole line
            INCR NumDone                                          '
         END IF                                                   '

      CASE "TC"                                                   ' Title Case
         IF IsLData(j) THEN                                       ' Only Data lines
            GOSUB DoPMinus                                        ' Do the +/- stuff
            me.LFlagBitOff(j, %EQChange)                          ' Reset ==CHG>
            me.UpdLControl(j)                                     ' And LLCtl
            IF scol > 1 OR ecol > 0 THEN                          ' Honour BNDS setting?
               me.TitleCase(j, scol, ecol)                        ' Go process it
            ELSE                                                  ' No BNDS, the simple way
               me.TitleCase(j, 1, LEN(L(j).@LTxt))                ' Go process it
            END IF                                                '
            INCR NumDone                                          '
         END IF                                                   '
   END SELECT                                                     '
   me.AttrScan(j)                                                 ' Recolorize

   RETURN                                                         '

DoPMinus:                                                         '
   lclFlag = PTBL.FindRngFlag                                     ' Get a copy of the +/- flag
   IF BIT(lclFlag, %lCmdX) THEN                                   ' Do the +/- processing for the Source
      me.LFlagBitOn(j, %Invisible)                                ' If - make Invisible
      gfXRebuild = %True                                          ' Do exclude stuff
   ELSEIF BIT(lclFlag, %lCmdNX) THEN                              '
      me.LFlagBitOff(j, %Invisible)                               ' If + make visible
      gfXRebuild = %True                                          ' Do exclude stuff
   END IF                                                         '
   RETURN                                                         '

DoSChunk:                                                         '
   x = PARSECOUNT(Txt1, " ")                                      ' Count words
   REDIM words(1 TO x) AS STRING                                  ' Make table correct size
   PARSE Txt1, words(), " "                                       ' Parse the words into the table
   m = 1                                                          ' Start scan at 1
   FOR y = 1 TO x                                                 ' Loop for each word
      IF ISNOTNULL(words(y)) THEN                                 ' Ignore null 'words'
         z = INSTR(m, Txt1, words(y))                             ' Find location of this word
         IF caps THEN                                             ' Capitalize this word?
            IF z THEN MID$(Txt1, z, 1) = UUCASE(MID$(Txt1, z, 1)) ' Uppercase the 1st letter
            Caps = %False                                         ' Off till next period
         END IF                                                   '
         IF RIGHT$(words(y), 1) = "."  OR _                       ' Look for sentence trigger
            RIGHT$(words(y), 1) = "?"  OR _                       '
            RIGHT$(words(y), 1) = "!"  THEN                       '
            Caps = %True                                          ' Restart sentence if required
         END IF                                                   '
         m = z + 1                                                ' Start scan adjust
      END IF                                                      '
   NEXT j                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdLEFT(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Scroll LEFT                                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL ScrAmt AS LONG, ScrCmd AS STRING                    '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H LEFT"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum > 1 THEN _                                      ' Better be just one operand
      MErrExit(%eFail, "Invalid scroll amount")                   '
   IF PTBL.OpsNum = 0 THEN                                        ' No Ops, fudge it
      ScrCmd = FCB.ScrollAmt                                      ' Pick up Profile value
   ELSE                                                           '
      ScrCmd = PTBL.Grp("SCROLL")                                 ' Else pick up from command
      IF ISNULL(ScrCmd) THEN ScrCmd = PTBL.Pos("#", 1)            ' If not Kwd, then fetch the #
   END IF                                                         '

   IF VAL(ScrCmd) <> 0 THEN                                       ' A Number?
      ScrAmt = VAL(ScrCmd)                                        ' Yes, use it
   ELSEIF ScrCmd = "HALF" THEN                                    ' Half?
      ScrAmt = INT(@P.PDataLen / 2)                               ' Yes, set it
   ELSEIF ScrCmd = "PAGE" THEN                                    ' Page?
      ScrAmt = @P.PDataLen                                        ' Yes, set it
   ELSEIF ScrCmd = "FULL" THEN                                    ' Full?
      ScrAmt = @P.PDataLen                                        ' Yes, set it
   ELSEIF ScrCmd = "DATA" THEN                                    ' Data?
      ScrAmt = @P.PDataLen - 1                                    ' Yes, set it
   ELSEIF ScrCmd = "MAX" THEN                                     ' Max?
      ScrAmt = 9999999                                            ' Yes, set a BIG number
   ELSEIF IsCData THEN                                            ' No, In the Data Area?
      ScrAmt = @P.PDataLen - (@P.C.CCol - @P.PDataCol)             ' Yes, move cursor to right of screen
   ELSEIF IsCLinN THEN                                            ' Line number area
      ScrAmt = @P.PDataLen - 1                                    ' Scroll width of screen
   ELSE                                                           '
      ScrAmt = @P.PDataLen - 1                                    ' No, Scroll width of screen - 1
   END IF                                                         '
   @P.POffset = MAX(@P.POffset - ScrAmt, 0)                       '
   ErrMsgHigh = %eNone                                            ' Say we 're OK
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdLINE(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Do the LINE command in Primary mode                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL fLine AS LONG                                               '
LOCAL OneLine, AllCount, i AS LONG, lcmd, MSG AS STRING, t AS TouchEntry   '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H LINE"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   '-----------------------------------------------------------------------------------------------+
   '- Extract the line range operands                                                              |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.FindRngSet AND ISNULL(PTBL.FindRngTag) THEN            ' If a line range and not a :TAG range
      IF PTBL.FindRngStart > 0 AND PTBL.FindRngEnd = 0 OR _       ' If a single line range
         PTBL.FindRngStart = PTBL.FindRngEnd THEN _               '
         OneLine = %True                                          ' Set the single line format flag
   END IF                                                         '

   IF ISFALSE PTBL.FlgLit1 OR _                                   ' Lit1 present?
      LEN(PTBL.L1RData) > 8 THEN _                                ' and not bigger than 8 chars
      MErrExit(%eFail, "Missing/Invalid Line command")            '
   PTBL.FlgLit1 = %False                                          ' Now remove Lit1 from the search criteria

   IF ISFALSE PTBL.FindRngSet AND _                               ' If no line range
      ISFALSE PTBL.FlgU AND ISFALSE PTBL.FlgNU AND ISFALSE PTBL.FlgX AND ISFALSE PTBL.FlgNX THEN  _   ' Or U / NU / X / NX
      MErrExit(%eFail, "No line reference or line range specified")  '

   IF ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _         '
      ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN         '
      PTBL.FlgNext = %True                                        ' Set NEXT if no others specified
      PTBL.FlgAll = %True                                         ' then set ALL
   END IF                                                         '

   lCmd = PTBL.L1RData                                            ' Get local copy of the line command
   IF (LEFT$(lCmd, 1) = "." OR LEFT$(lCmd, 1) = ":") AND _        ' Attempt to tweak label or tag?
      ISFALSE OneLine THEN _                                      ' Better be a single line
      MErrExit(%eFail, "Can only modify Label or Tag for a single line")   '

   '-----------------------------------------------------------------------------------------------+
   '- Now validate the command                                                                     |
   '-----------------------------------------------------------------------------------------------+
   t.LinNo = PTBL.FindRngStart                                    ' Build a Touch entry, complete line number
   t.LinCtl = lCmd                                                ' Add the specified command
   t.LinFlag = 0                                                  ' Clear the flag

   me.LCtlPreProcessEnt(t)                                        ' Go Preprocess (Normalize) the command

   '-----------------------------------------------------------------------------------------------+
   '- Now validate it's a valid line command                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF INSTR(".: ", LEFT$(lCmd, 1)) = 0 THEN                       ' if not a Label or tag manipulation?
      me.LCtlValidateEnt(t, MSG)                                  ' Go validate the command
      IF MSG <> "OK" THEN _                                       ' If not OK an error occurred
         MErrExit(%eFail, MSG)                                    ' Issue the message
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- If a single line, just stuff it in                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF OneLine THEN                                                ' Just a single line reference?
      me.TTblAdd(t.LinNo, lCmd)                                   ' Update touched items
      ErrMsgHigh = 0                                              ' Reset ErrMsgHigh to clear any pending etc.
      me.LCtlProcess                                              ' Go start the ugly Line Command Process
      IF ErrMsgHigh = %eNone THEN me.LCtlCommands                 ' If no errors, go give them a try
      IF ErrMsgHigh = 0 THEN MSG = ""                             '
      me.UpdLControl(t.LinNo)                                     ' Update LLCtl
      MErrExit(%eNone, $SQ + IIF$(TRIM$(lCmd) = "", " ", TRIM$(lCmd)) + $SQ + " applied") '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- OK lets do the search now for line range stuff                                               |
   '-----------------------------------------------------------------------------------------------+
   RESET AllCount                                                 ' Reset variables

   '-----------------------------------------------------------------------------------------------+
   '- The search                                                                                   |
   '-----------------------------------------------------------------------------------------------+
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values
   IF ISFALSE PTBL.FlgAll THEN                                    ' Not ALL?
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         i = PTBL.FoundLine                                       ' Get found line
         fline = i                                                ' Save first line
         me.TTblAdd(i, lCmd)                                      ' Update touched items
         ErrMsgHigh = 0                                           ' Reset ErrMsgHigh to clear any pending etc.
         me.LCtlProcess                                           ' Go start the ugly Line Command Process
         IF ErrMsgHigh = %eNone THEN me.LCtlCommands              ' If no errors, go give them a try
         MErrExit(%eNone, $SQ + IIF$(TRIM$(lCmd) = "", " ", TRIM$(lCmd)) + $SQ + " applied") '
      ELSE                                                        '
         MErrExit(%eFail, "No eligible line found")               '
      END IF                                                      '

   ELSE                                                           ' This is the ALL version
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         i = PTBL.FoundLine                                       ' Get found line
         me.TTblAdd(i, lCmd)                                      ' Update touched items
         INCR AllCount                                            ' Count it
      ELSE                                                        '
         MErrExit(%eFail, "No eligible line found")               '
      END IF                                                      '

      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CInternal)                             ' Do re-Finds, Say we're setting resume point
         IF i THEN                                                ' Found one
            i = PTBL.FoundLine                                    ' Get found line
            me.TTblAdd(i, lCmd)                                   ' Update touched items
            INCR AllCount                                         ' Count it
         END IF                                                   '
      LOOP                                                        '
   END IF                                                         '

   ErrMsgHigh = 0                                                 ' Reset ErrMsgHigh to clear any pending etc.
   me.LCtlProcess                                                 ' Go start the ugly Line Command Process
   IF ErrMsgHigh = %eNone THEN me.LCtlCommands                    ' If no errors, go give them a try

   '-----------------------------------------------------------------------------------------------+
   '- Search over, report the result                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF AllCount = 0 THEN                                           ' Issue approp. message
      TP.ErrMsgAdd(nMac(%eFail), "No lines processed")            '
   ELSE                                                           '
      TP.ErrMsgAdd(0, $SQ + IIF$(TRIM$(lCmd) = "", " ", TRIM$(lCmd)) + $SQ + " applied " + FORMAT$(AllCount) + " time" + IIF$(AllCount > 1, "s", "")) '
   END IF                                                         '
   MExit                                                          '

END METHOD                                                        '

METHOD  pCmdLOCATE(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Move screen to a particular line                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, llastline, lastcol AS LONG, postype AS INTEGER, t, op AS STRING   '
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff      NOTE: LOCATE only uses ParseCmd to break down the operands.  |
   '-                                       Because it doesn't use results of the full parse.      |
   '-                                       LOCATE's syntax is weird, and it uses its own          |
   '-                                       LOCSearch routine, totally different from everyone else|
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll - %PAssign), _                 ' Try the Parse
         PCmdHelp("H LOCATE"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   LocFind = "LOCATE"                                             ' Remember what Loc / FIND command was last
   IF PTBL.OpsNum = 0 THEN _                                      ' No Ops
      MErrExit(%eFail, "Missing LOCATE operand")                  ' Oops!
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   IF IsCData THEN                                                ' In the Data Area
      llastline = me.SGet(@P.C.CRow)                              ' Save line the cursor is on
      lastcol = @P.C.CCol - @P.PGapCol + @P.POffset + 1           ' Calc column position in line
   END IF                                                         '
   IF IsCLinN THEN                                                ' In the Line Area
      llastline  = me.SGet(@P.C.CRow): lastcol = 0                ' Swap in current cursor location
   END IF                                                         '

   RESET LocFlag, LocLine, LocNotFound                            ' Reset stuff
   RESET LocLabLine1, LocLabLine2, LocLabel1, LocLabel2           '
   RESET LocTag, LocLength, LocNVar, LocColor, LocNFDir           '
   LocDir = 1                                                     '

   FOR i = 1 TO PTBL.OpsNum                                       ' Process all our operands
      op = TRIM$(UCASE$(PTBL.Ops(i)))                             ' Get an UC trimmed version of the next Operand

      IF LEFT$(op, 1) = "." AND LEN(op) = 1 THEN _                ' A .Label and LEN=1
            MErrExit(%eFail, "Line reference " + op + " is invalid") ' Oops!
      IF VERIFY(op, $Numeric) = 0 OR LEFT$(op, 1) = "." THEN      ' Seems valid
         j = me.LineNoRef(op)                                     ' Get the line number
         IF j = -1 AND ISFALSE BIT(LocFlag, %LocSize) AND ISFALSE BIT(LocFlag, %LocLong)THEN _  ' If invalid
            MErrExit(%eFail, "Line reference " + op + " is undefined")  ' Oops!
         IF ISNULL(LocLabel1) THEN                                ' First one?
            LocLabel1 = LSET$(op, 8)                              '
            LocLabLine1 = j                                       '
         ELSEIF ISNULL(LocLabel2) THEN                            ' Second one?
            LocLabel2 = LSET$(op, 8)                              '
            LocLabLine2 = j                                       '
         ELSE                                                     '
            MErrExit(%eFail, "Third line reference detected - " + op)   ' Oops!
         END IF                                                   '
         ITERATE FOR                                              '
      END IF                                                      '

      SELECT CASE AS CONST$ op                                    ' Handle Kwd operands
         CASE "NEXT":                                 BIT SET LocFlag, %LocNext : ITERATE FOR   '
         CASE "LAST":                                 BIT SET LocFlag, %LocLast : ITERATE FOR   '
         CASE "PREV":                                 BIT SET LocFlag, %LocPrev : ITERATE FOR   '
         CASE "FIRST":                                BIT SET LocFlag, %LocFirst: ITERATE FOR   '
         CASE "NOT":                                  BIT SET LocFlag, %LocNot  : ITERATE FOR   '
         CASE "ALL":                                  BIT SET LocFlag, %LocAll  : ITERATE FOR   '
         CASE "MX":                                   BIT SET LocFlag, %LocMX   : ITERATE FOR   '
         CASE "TOP":                                  BIT SET LocFlag, %LocTop  : ITERATE FOR   '
         CASE "CURRENT":                              BIT SET LocFlag, %LocCurrent   : ITERATE FOR '
         CASE "CHANGE", "CHG", "CHA", "C":            BIT SET LocFlag, %LocChange: INCR k: ITERATE FOR   '
         CASE "FIND":                                 BIT SET LocFlag, %LocFind: INCR k: ITERATE FOR  '
         CASE "FILE":                                 BIT SET LocFlag, %LocFile: INCR k: ITERATE FOR  '
         CASE "COMMAND", "CMD", "COM":                BIT SET LocFlag, %LocCommand: INCR k: ITERATE FOR  '
         CASE "ERROR", "ERR":                         BIT SET LocFlag, %LocError: INCR k: ITERATE FOR '
         CASE "EXCLUDE", "EXCLUDED", "X", "EX", "EXC":BIT SET LocFlag, %LocExcluded: INCR k: ITERATE FOR '
         CASE "LABEL", "LABELS", "LAB":               BIT SET LocFlag, %LocLabel: INCR k: ITERATE FOR '
         CASE "HANDLE":                               BIT SET LocFlag, %LocHandle: INCR k: ITERATE FOR   '
         CASE "PAGE":                                 BIT SET LocFlag, %LocPage: INCR k: ITERATE FOR  '
         CASE "SPECIAL", "SPE":                       BIT SET LocFlag, %LocSpecial: INCR k: ITERATE FOR  '
         CASE "KEEP":                                 BIT SET LocFlag, %LocKeep: INCR k: ITERATE FOR  '
         CASE "TAG", "TAGS":                          BIT SET LocFlag, %LocTag: INCR k: ITERATE FOR   '
         CASE "LONG":                                 BIT SET LocFlag, %LocLong: INCR k: ITERATE FOR  '
         CASE "SIZE":                                 BIT SET LocFlag, %LocSize: INCR k: ITERATE FOR  '
         CASE "STD":                                  BIT SET LocFlag, %LocStd: INCR k: ITERATE FOR   '
         CASE "U", "DIFF":                            BIT SET LocFlag, %LocU: INCR k: ITERATE FOR  '
         CASE "NU":                                   BIT SET LocFlag, %LocNU: INCR k: ITERATE FOR '
         CASE "NX":                                   BIT SET LocFlag, %LocNX: INCR k: ITERATE FOR '
      END SELECT                                                  '

      IF RIGHT$(op, 4) = "NOTE" THEN                              ' A NOTE entry?
         BIT SET LocFlag, %LocNote: INCR k                        '
         IF op <> "NOTE" THEN LocNVar = INSTR($upper, LEFT$(op, 1))  ' Save the Note variety
         ITERATE FOR                                              '
      END IF                                                      '

      IF LEFT$(op, 1) = ":" THEN                                  ' :Tag operand
         IF op = ":ZALL" OR _                                     ' Eliminate ZALL
            op = ":Z" OR _                                        ' Eliminate Z
            op = ":ZF" OR _                                       ' Eliminate ZF
            op = ":ZNF" THEN _                                    ' Eliminate ZNF
            MErrExit(%eFail, "Invalid Tag operand")               '
         IF TagValidate(op, %False) THEN _                        ' See if 1st is a valid Tag
            MErrExit(%eFail, "Invalid Tag operand")               '
         LocTag = LSET$(op, 8): INCR k                            '
         ITERATE FOR                                              '
      END IF                                                      '

      IF LEFT$(op, 1) = "!" THEN                                  ' A LPtr?                                             ' A !LPtr?
         IF LEN(op) = 1 THEN _                                    ' just a !?
            MErrExit(%eFail, "Line reference: " + op + " is invalid")   ' Oops!
         j = VAL(MID$(op, 2))                                     ' Get the line number
         IF j = 0 OR j > LastLine THEN _                          ' If invalid
            MErrExit(%eFail, "Line reference: " + op + " is invalid")   ' Oops!
         IF ISNULL(LocLabel1) THEN                                ' First one?
            LocLabel1 = LSET$(op, 8)                              '
            LocLabLine1 = j                                       '
         ELSEIF ISNULL(LocLabel2) THEN                            ' Second one?
            LocLabel2 = LSET$(op, 8)                              '
            LocLabLine2 = j                                       '
         ELSE                                                     '
            MErrExit(%eFail, "Third line reference detected - " + op)   ' Oops!
         END IF                                                   '
         ITERATE FOR                                              '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Last chance, is it a color?                                                               |
      '--------------------------------------------------------------------------------------------+
      IF Op = "SPELL" THEN                                        ' The SPELL color?
         IF LocColor <> 0 THEN _                                  ' Already have one?
            MerrExit(%eFail, "Extra color name operand detected - " + op)  ' Issue error
         IF SpellClr = 0 THEN _                                   ' A SPELL done?
            MerrExit(%eFail, "No previous SPELL command was issued") ' Issue error
         LocColor = SpellClr                                      ' Swap it in
         BIT SET LocFlag, %LocSpell                               ' Activate color search + spell
         BIT SET LocFlag, %LocColor: INCR k                       '
         ITERATE FOR                                              '
      END IF                                                      '

      ARRAY SCAN gHiLites(), COLLATE UCASE, = op, TO j            ' See if a HiLite Name
      IF j THEN                                                   ' A winner
         IF LocColor <> 0 THEN                                    ' Already have one?
            MerrExit(%eFail, "Extra color name operand detected - " + op)  ' Issue error
         ELSE                                                     '
            LocColor = j                                          ' Save the color to search for
            BIT SET LocFlag, %LocColor: INCR k                    ' Activate color search
         END IF                                                   '
      ELSE                                                        '
         MErrExit(%eFail, "Unknown LOCATE operand - " + op)       ' Oops!
      END IF                                                      '
   NEXT i                                                         '
   RESET LocLine1stR, LocLineLstR                                 ' Reset .ZLOC stuff

   IF BIT(LocFlag, %LocTop) AND _                                 ' TOP only for simple positions
      (ISNOTNULL(LocLabel2) OR _                                  '
       BIT(LocFlag, %LocMX) OR _                                  '
       k > 1) THEN _                                              '
      MErrExit(%eFail, "TOP only available with simple position requests") '

   IF BIT(LocFlag, %LocNot) AND BIT(LocFlag, %LocCurrent) THEN _  ' Filter some obvious errors
      MErrExit(%eFail, "Can't use both NOT and CURRENT")          '
   IF BIT(LocFlag, %LocAll) AND BIT(LocFlag, %LocFile) THEN _     '
      MErrExit(%eFail, "Can't use both ALL and FILE")             '
   IF BIT(LocFlag, %LocLong) AND BIT(LocFlag, %LocSize) THEN _    '
      MErrExit(%eFail, "Can't use both SIZE and LONG")            '
   IF BIT(LocFlag, %LocNext) AND BIT(LocFlag, %LocPrev) THEN _    '
      MErrExit(%eFail, "Can't use both PREV and NEXT")            '
   IF BIT(LocFlag, %LocFirst) AND BIT(LocFlag, %LocLast) THEN _   '
      MErrExit(%eFail, "Can't use both FIRST and LAST")           '
   IF BIT(LocFlag, %LocAll)  AND _                                '
      (BIT(LocFlag, %LocFirst) OR BIT(LocFlag, %LocLast) OR _     '
       BIT(LocFlag, %LocPrev) OR BIT(LocFlag, %LocNext)) THEN _   '
      MErrExit(%eFail, "Can't use ALL with FIRST/LAST/PREV/NEXT") '
   IF k > 1 THEN _                                                ' Only one line type please
      MErrExit(%eFail, "Only 1 (one) line type can be requested") '
   IF k = 0 AND ISNULL(LocLabel1) THEN _                          ' Nothing to do
      MErrExit(%eFail, "No line search parameters present")       '
   IF BIT(LocFlag, %LocCurrent) AND ISFALSE BIT(LocFlag, %LocFind) AND ISFALSE BIT(LocFlag, %LocChange) THEN _ '
      MErrExit(%eFail, "CURRENT only allowed with FIND or CHANGE")   '

   IF (ISNOTNULL(LocLabel1) AND ISNOTNULL(LocLabel2) AND k = 0) OR _ ' Range but nothing else?
      (BIT(LocFlag, %LocAll) AND k = 0) THEN _                    ' All but nothing else?
      MErrExit(%eFail, "No, line type criteria specified")        '

   IF ISNOTNULL(LocLabel1) AND ISNULL(LocLabel2) AND k = 0 THEN   ' Just a simple Loc .A type?
      PosType = IIF(BIT(LocFlag, %LocTop), %FLocate, %Locate)     ' Set position type based on TOP
      IF IsLInvisible(LocLabLine1) THEN                           ' Is this an X'd out line?
         LocLabLine1 = me.LPopOutX(LocLabLine1)                   ' Yes, Uugh! go do lots of work, get adjusted line number
      END IF                                                      '
      IF BIT(LocFlag, %LocMX) THEN                                ' MX requested?
         me.LFlagBitOn(LocLabLine1, %Invisible)                   ' Just make it invisible
         gfXRebuild = %True                                       ' for rebuild exclude state
         me.CurSetReq(%Find, LocLabLine1, 0, %True, %True)        ' Put cursor on the X line, no hilite, XPtr to be set
         CsrLinDX = VAL(LLNumG(LocLabLine1))                      ' Save hidden line number for Status Bar display
      ELSE                                                        '
         IF BIT(LocFlag, %LocTop) THEN                            ' TOP requested?
            IF LocLabLine1 <> @P.PTopLine THEN                    ' Topscrn elsewhere right now?
               me.LFlagBitOff(@P.PTopLine, %TopScreen)            ' Clear current TopScrn line flag
            END IF                                                '
            @P.PTopLine = LocLabLine1                             ' Set to our choice
            me.LFlagBitOn(@P.PTopLine, %TopScreen)                ' Move %TopScreen to our choice
            me.CurSetReq(postype, LocLabLine1, 0, %True)          ' Put the line at the top
         ELSE                                                     '
            me.CurSetReq(postype, LocLabLine1, 0, %True)          ' Do normal set cursor set attempt
            LocLineLstR = LocLabLine1                             ' Save
            IF LocLine1stR = 0 THEN LocLine1stR = LocLineLstR     ' Set as .ZLOC
         END IF                                                   '
      END IF                                                      '
      ErrMsgHigh = %eNone                                         ' Say we 're OK
      MExitMeth                                                   '
   END IF                                                         '

   IF BIT(LocFlag, %LocLong) THEN                                 ' LOC LONG type?
      IF ISNOTNULL(LocLabel1) AND ISNULL(LocLabel2) THEN          ' Just LOC LONG nnn type?
         LocLength = VAL(LocLabel1)                               '
      ELSE                                                        '
         IF FCB.LRECL > 0 THEN LocLength = FCB.LRECL              ' Swap LRECL if present
      END IF                                                      '
      IF LocLength = 0 THEN _                                     '
         MErrExit(%eFail, "Using LONG requires LRECL > 0 or a length operand")   '
   END IF                                                         '

   IF BIT(LocFlag, %LocSize) THEN                                 ' LOC SIZE type?
      IF ISNOTNULL(LocLabel1) AND ISNULL(LocLabel2) THEN          ' Just LOC SIZE nnn type?
         LocLength = VAL(LocLabel1)                               '
      ELSE                                                        '
         IF FCB.LRECL > 0 THEN LocLength = FCB.LRECL              ' Swap LRECL if present
      END IF                                                      '
   END IF                                                         '

   IF BIT(LocFlag, %LocPage) THEN                                 ' LOC PAGE type?
      IF ISNOTNULL(LocLabel1) AND ISNULL(LocLabel2) THEN          ' Just LOC Page nnn type?
         LocLength = VAL(LocLabel1)                               ' Save page number in LocLength
         BIT SET LocFlag, %LocFirst                               ' Start at line 1
      ELSE                                                        '
         LocLength = 0                                            ' Zero page number
      END IF                                                      '
   END IF                                                         '

   IF BIT(LocFlag, %LocMX) THEN                                   ' LOC MX type?
      IF ISFALSE BIT(LocFlag, %LocAll) THEN _                     ' Must have ALL
         MErrExit(%eFail, "MX allowed only with ALL")             '
   END IF                                                         '

   LocLine = @P.PTopLine                                          ' In case no other shows up
   IF ISFALSE BIT(LocFlag, %LocFirst) AND ISFALSE BIT(LocFlag, %LocLast) AND ISFALSE BIT(LocFlag, %LocPrev) THEN  '
      BIT SET LocFlag, %LocNext                                   ' If nothing else, set NEXT
   END IF                                                         '

   IF ISFALSE me.LocSearch() THEN                                 ' Go do the full type search
      IF ErrMsgTblC = 0 THEN _                                    ' If Locsearch hasn't issued a msg already
         TP.ErrMsgAdd(nMac(%eFail), IIF$(locDir = 1, "Bottom of data reached", "Top of data reached"))   ' Do so now
      LocNotFound = IIF(BIT(LocFlag, %LocNext), 2, 1)             ' Remember the failure
      LocNFDir = LocDir                                           ' and direction
      IF llastline <> 0 THEN _                                    ' A saved cursor location?
         me.CurSetReq(%Find, llastline, lastcol, %False, %False)  ' Set cursor
   ELSE                                                           '
      IF IsMEdit AND BIT(LocFlag, %LocFile) THEN                  ' A MEdit LOC FILE command?
         TP.ErrMsgAdd(%eNone, "File " + FORMAT$(LMIXG(LocLineLstR)) + " of " + FORMAT$(MEditCount) + " found") '
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdLoopCheck(pCmd AS STRING)                             '
'--------------------------------------------------------------------------------------------------+
'- Turn LOOPCHECK ON or OFF or do a Query                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL tHndl, parmp, tResult AS DWORD                              '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispCheck, _                                        ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum < 1 THEN _                                      ' No param
      MErrExit(%eFail, "LOOPCHECK requires an ON / OFF operand")  '
   gLoopCheck = IIF(PTBL.IsKwd("ON"), %True, %False)              ' Set it accordingly
   IF ISTRUE gLoopCheck AND ISFALSE gLoopThread THEN              ' If no thread (due to -NOLOOP)
      THREAD CREATE DoLoopDetect(parmp) 65536, TO tHndl           ' Fire up the thread now
      SLEEP 50                                                    ' Wait a bit
      THREAD STATUS tHndl TO tResult                              ' See if running OK
      THREAD CLOSE tHndl TO tResult                               ' Free up our handle
      gLoopThread = %True                                         ' Remember we started it
   END IF                                                         '
   DispCheck:                                                     '
   MErrExit(%eNone, "LOOPCHECK is set to " + IIF$(gLoopCheck, "ON", "OFF"))   '
 END METHOD                                                       '

METHOD  pCmdLRECL(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Pass LRECL onward to the DCB command                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL EO, MSG AS STRING                                           '
   MEntry                                                         '
   MSG = "DCB is set to: "                                        ' Start building MSG
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO FormatMsg, _                                        ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   pCmdDCB("DCB " + pCmd)                                         ' Insert DCB and pass it on
   MExitMeth                                                      '

   FormatMsg:                                                     '
   EO = FCB.EOL                                                   ' Format EOL
   IF VERIFY(EO, $Hex) = 0 THEN EO = "X'" + EO + "'"              ' IF hex operand, FRAME it for the message
   DoProfMsg(MSG + "RECFM=" + FCB.RECFM + ", LRECL=" + FORMAT$(FCB.LRECL) + ", EOL=" + EO )  ' Issue message
   DoStatusBar($SBEOL)                                            ' re-Do the StatusBar EOL box
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdMACLIB(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Set the Profile MACLIB value                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL t1, t2, t3, MSG AS STRING, i AS LONG, RCA AS RCArea         '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispIt, _                                           ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "MACLIB requires an operand")  ' No Ops?
   t1 = IIF$(PTBL.IsKwd("NONE"), "", UCASE$(PTBL.Pos2(1)))        ' Either NONE or a SET name
   '-----------------------------------------------------------------------------------------------+
   '- If a MACLIB specified, validate it                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(t1) THEN                                             ' If null
      FCB.Maclib = t1                                             ' Just save it
   ELSE                                                           ' Else, validate it
      SETTableUpd("GET", "MACLIB." + t1, RCA)                     ' GET The SET value
      IF RCA.RC <> 0 THEN                                         ' Not found
         MSG = ", Warning, SET symbol (MACLIB." + t1 + ") is not yet defined" '
         FCB.Maclib = t1                                          ' Save it anyway
         GOTO Dispit                                              '
      END IF                                                      '
      t3 = RCA.Msg: strunquote(t3)                                ' Remove extraneous quotes
      FOR i = 1 TO PARSECOUNT(t3, ";")                            ' Get number of paths
         t2 = PARSE$(t3, ";", i)                                  ' For each pathname
         IF ISFALSE ISFOLDER(t2) THEN MSG = ", Warning, folder (" + t2 + ") does not exist"  '
      NEXT i                                                      '
      FCB.Maclib = t1                                             ' Save it regardless
   END IF                                                         '

   DispIt:                                                        '
   DoProfMsg("?MACLIB set to " + IIF$(ISNULL(FCB.MACLIB), "NONE", FCB.MACLIB)  + MSG)  '
   TP.FCB_.BuildLines                                             ' Re-do PROF lines
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdMACRO(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Invoke a Macro                                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL macline, t, tt, subname, origPCmd AS STRING                 '
LOCAL i, j, k, lno, NumLines, mOps, FNum AS LONG, RCA AS RCArea   '

   MEntry                                                         '
   OrigPCmd = PCmd                                                ' Save original
   IF gMacroMode THEN _                                           ' Can't already be in macro mode
      MErrExit(%eFail, "Already in macro mode, no nesting of macros supported")  '
   gMacroName = GetNextWord(PCmd, %Strip): t = GetNextWord(PCmd, %NoStrip) ' Get the macro name
   IF UCASE$(gMacroName) = "MACRO" AND t = "?" THEN pCmdHelp("H MACRO"): MexitMeth  ' Handle the help option
   gMaclib = TP.FCB_.Maclib                                       ' Fetch MACLIB value
   i = INSTR(gMacroName, ":")                                     ' A Maclib prefix?  abc:macroname
   IF i THEN                                                      ' Yes
      gMaclib = LEFT$(gMacroName, i - 1)                          ' Peel it off
      gMacroName = MID$(gMacroName, i + 1)                        ' Extract the macroname
   END IF                                                         '
   gMacroFile = gENV.HomeData + "MACROS\" + gMacroName + ".MACRO" ' Setup as normal macros location
   IF ISNOTNULL(gMaclib) THEN                                     ' If a MACLIB, override it
      SETTableUpd("GET", "MACLIB." + gMaclib, RCA)                ' See if a MACLIB SET symbol
      IF RCA.RC = 0 THEN                                          ' If yes
         gMacroFile = PATHSCAN$(FULL, gMacroName + ".MACRO", RCA.Msg)   ' Get full name of macro file
         gMacLibList = RCA.Msg                                    ' Save the Maclib list
      ELSE                                                        ' If MACLIB is missing
         gMacLibList = gENV.HomeData + "MACROS\"                  ' At least give it the default one
      END IF                                                      '
   END IF                                                         '
   IF ErrMsgHigh = %ePending THEN                                 ' If Pending, see if allowed
      SETTableUpd("GET", "PENDING." + gMacroName, RCA)            ' GET Macro pending allowed
      IF UCASE$(RCA.Msg) <> "Y" THEN MExitMeth                    ' Exit if NO
   END IF                                                         '
   FNum = FREEFILE                                                ' Get a file number
   Call3(TryOpenInput(gMacroFile, FNum), _                        ' Try the open
         MErrExit(%eFail, "Macro file: " + gMacroName + " doesn't exist"), _  ' Oops?  Bail out
         MErrExit(%eFail, "OPEN of Macro: " + gMacroName + " failed"), _   ' Oops?  Bail out
         Nul)                                                     ' Continue

   '-----------------------------------------------------------------------------------------------+
   '- Get number of lines in the Macro                                                             |
   '-----------------------------------------------------------------------------------------------+
   FILESCAN # FNum, RECORDS TO NumLines                           ' allow extra line for #INCLUDEDIR
   REDIM gMaclines(1 TO NumLines + 2) AS STRING                   ' Save away the macro in an array

   DO WHILE ISFALSE EOF(# FNum)                                   ' Read the data
      LINE INPUT# FNum, macline                                   '
      INCR lno                                                    ' Line number
      gMacLines(lno) = macline                                    '
   LOOP                                                           '
   INCR lno                                                       ' Add a trailing STOP line
   gMacLines(lno) = "STOP"                                        '
   CLOSE #FNum                                                    ' Close the file

   '-----------------------------------------------------------------------------------------------+
   '- Check for macro ID line for Basic                                                            |
   '-----------------------------------------------------------------------------------------------+
   macline = UUCASE(TRIM$(gmaclines(1))) + " "                    ' Get the 1st line
   IF LEFT$(macline, 1) = "'" THEN                                ' A Basic comment line?
      i = INSTR(macline, "MACRO ")                                ' Find MACRO
      IF i THEN                                                   ' Got it
         macline = MID$(macline, i + 6)                           ' Extract prototype operands
         GOSUB BuildOps                                           ' Process the operands
         GOSUB CheckSUB                                           ' Check for 1st line as a SUB
         MB_Call()                                                ' Pass off to the MACRO processor
         IF ErrMsgHigh > 0 THEN                                   ' Error?
            IF ISFALSE (gFMMacmode OR gEDMacmode) THEN PCmd = OrigPcmd  ' Put back orig cmd if a PCmd error
         ELSE                                                     '
            PCmd = "": TP.PCommand = ""                           ' Clear Cmd if all OK
         END IF                                                   '
         MexitMeth                                                ' We're done here
      END IF                                                      '
   END IF                                                         '

   MErrExit(%eFail, "Missing / Invalid Macro header line")        ' Oops

CheckSub:                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- See if a SUB type macro                                                                      |
   '-----------------------------------------------------------------------------------------------+
   i = 2                                                          ' Point at line 2
   macline = UUCASE(TRIM$(gmaclines(i)))                          ' Get the 2nd line and it's continuations
   DO WHILE RIGHT$(macline, 1) = "_"                              ' Add continuations if present
      INCR i                                                      ' Point at next line
      macline = CLIP$(RIGHT, macline, 1) + " " + UUCASE(TRIM$(gmaclines(i)))  '
   LOOP                                                           '
   IF LEFT$(macline, 4) <> "SUB " THEN RETURN                     ' Nothing to do

   '-----------------------------------------------------------------------------------------------+
   '- We have a SUB subname(arg [as string], arg [as string], ...) statement                       |
   '-----------------------------------------------------------------------------------------------+
   i = INSTR(macline, "(")                                        ' Find opening (
   IF i = 0 THEN GOTO SubErr                                      ' None?
   i = INSTR(i + 1, macline, ")")                                 ' Find closing )
   IF i = 0 THEN GOTO SubErr                                      ' None?
   k = 0                                                          ' Number of operands
   i = INSTR(macline, "(")                                        ' Find opening (
   subname = TRIM$(MID$(macline, 4 TO i - 1))                     ' Extract Subname

   DO WHILE INSTR(i + 1, macline, ANY ",)")                       ' look for , or )
      j = INSTR(i + 1, macline, ANY ",)")                         ' Look for delimiter
      t = MID$(macline, i + 1 TO j - 1)                           ' Extract the operand
      tt = GetNextWord(t, %Strip)                                 ' Get the operand name
      IF tt = "" THEN GOTO SubErr                                 ' Oops!
      tt = GetNextWord(t, %Strip)                                 ' Get the possible 'AS'
      IF tt <> "AS" THEN GOTO SubErr                              '
      tt = GetNextWord(t, %Strip)                                 ' Get the possible 'AS'
      IF tt <> "STRING" THEN GOTO SubErr                          '
      INCR k                                                      ' Count an operand
      IF MID$(macline, j, 1) = ")" THEN EXIT DO                   ' Terminated by ) ?
      i = j                                                       ' No, Continue scan
   LOOP                                                           ' We now have # arguments

   macline = subname + "("                                        ' Build the MACRO call
   FOR i = 1 TO k                                                 ' Pick up the operands
      IF LEFT$(gMacOprands(i), 1) <> $DQ THEN                     ' Insert the operands
         macline += $DQ + gMacOprands(i) + $DQ                    ' Quoted, if not already
      ELSE                                                        '
         macline += $DQ+ $DQ + gMacOprands(i) + $DQ + $DQ         ' Quoted, add lots more to make it work
      END IF                                                      '
      IF i < k THEN macline += ", "                               ' Add seperator
   NEXT i                                                         '
   macline += "): STOP"                                           ' Close it off
   gMacLines(1) = macline                                         ' Replace line 1
   RETURN                                                         '
SubErr:                                                           '
   MErrExit(%eFail, "Invalid syntax in the initial SUB statement")   ' Oops

BuildOps:                                                         '
  '------------------------------------------------------------------------------------------------+
                                                                  ' Process the macro operands                                                                     |
  '------------------------------------------------------------------------------------------------+
   gMacLCsr = %False                                              ' Reset the LCSr flag
   RESET gMacOprands()                                            ' Reset the Operand table
   DO WHILE ISNOTNULL(TRIM$(macline))                             ' Loop through operands
      INCR mOps                                                   ' Incr count
      IF mOps > UBOUND(gMacOprands()) THEN _                      ' Keep table big enough
         REDIM PRESERVE gMacOprands(1 TO 2 * mOps) AS GLOBAL STRING  '
      gMacOprands(mOps) = GetNextWord(macline, %Strip)            ' Get the next operand from string
   LOOP                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- Overlay prototype operands with real command line operands                                   |
   '-----------------------------------------------------------------------------------------------+
   i = 0                                                          ' Reset
   DO WHILE ISNOTNULL(Pcmd)                                       ' Operands?
      INCR i                                                      '
      IF i > UBOUND(gMacOprands()) THEN _                         ' Keep table big enough
         REDIM PRESERVE gMacOprands(1 TO 2 * i) AS GLOBAL STRING  '
      gMacOprands(i) = GetNextWord(PCmd, %Strip)                  ' Assign an operand
   LOOP                                                           '

   '-----------------------------------------------------------------------------------------------+
   '- Do SET substitution on the operands now                                                      |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO 50                                                ' Do SET substitution
      IF ISNOTNULL(gMacOprands(i)) THEN _                         ' If non-null operand
         IF me.MacSubst(gMacOprands(i)) THEN _                    ' Do substitution
            MErrExit(%eFail, "Malformed macro operand in MACRO prototype: " + gMacOprands(i))   ' Sorry
   NEXT i                                                         '

   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdMAKELIST(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- MAKELIST command for File Manager and MEDIT                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL ListName, LN2, t AS STRING                                  '
LOCAL i, j, SymFlag, RepFlag, AppFlag, FMFlag, ExistFlag, OldFLCtr, SymCtr, FNum AS LONG  '
DIM OldFL(1 TO 1) AS STRING                                       '
DIM SymEnt(1 TO 1) AS STRING                                      '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the basic parse
         pCmdHelp("H MAKELIST"), _                                ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "Missing MAKELIST operands")   '

   SymFlag = PTBL.IsKwd("SYM")                                    ' Grab flags
   RepFlag = PTBL.IsKwd("REPLACE")                                '
   AppFlag = PTBL.IsKwd("APPEND")                                 '
   FMFlag  = IsFMTab                                              '
   IF ISFALSE (FMFlag OR TabMode = %EDIT OR TabMode = %MEdit) THEN _ '
      MErrExit(%eFail, "MAKELIST only runs in File Manager and MEDIT sessions")  '
   IF PTBL.GotLit = 1 THEN ListName = PTBL.Pos2(1)                ' Get the ListName
   IF ISNULL(ListName) THEN MErrExit(%eFail, "Missing name for the list")  '

   IF ISFILE(gENV.HomeData + "FILELIST\" + ListName + ".FLIST") THEN ' Test if exists
      ExistFlag = %True                                           '
      IF ISFALSE RepFlag AND ISFALSE AppFlag THEN _               '
         MErrExit(%eFail, ListName + ".FLIST already exists, APPEND/REPLACE not specified")  '
   ELSE                                                           '
      IF ISTRUE AppFlag THEN _                                    '
         MErrExit(%eFail, ListName + ".FLIST doesn't exist, but APPEND requested")  '
   END IF                                                         '

   LN2 = UUCASE(ListName)                                         ' Uppercase it
   IF LN2 = "RECENT FILES" OR LN2 = "RECENT PATHS" OR _           ' Eliminate reserved ones
      LN2 = "FOUND FILES" OR LN2 = "FAVORITE FILES" OR _          '
      LN2 = "RECENT" OR LN2 = "PATHS" OR ln2 = "FOUND" OR _       '
      LN2 = "FLISTS" OR LN2 = "OPEN Files" THEN _                 '
         MErrExit(%eFail, "Reserved FILELIST name, cannot use")   '

   IF ISTRUE ExistFlag AND ISTRUE AppFlag THEN                    ' Are we appending?
      FNum = FREEFILE                                             ' Get a file number
      Call3(TryOpenInput(gENV.HomeData + "FILELIST\" + ListName + ".FLIST", FNum), _ ' Try the open
            MErrExit(%eFail, "FILELIST: " + ListName + " doesn't exist"), _   ' Oops?  Bail out
            MErrExit(%eFail, "OPEN of FILELIST: " + ListName + " failed"), _  ' Oops?  Bail out
            Nul)                                                  ' Continue
      FILESCAN # FNum, RECORDS TO i                               ' Get the number of records
      REDIM OldFL(1 TO i + IIF(FMFlag, gFMDCtr, MEditCount)) AS STRING  ' Redim array to match save data
      LINE INPUT # FNum, OldFL() TO OldFLCtr                      ' Read it all
      CLOSE # FNum                                                ' Close it
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- SYM requested?                                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF SymFlag THEN                                                ' Is SYM requested?
      IF FMFlag THEN                                              ' If FM
         REDIM SymEnt(1 TO gFMDCtr + OldFLCtr) AS STRING          ' Set table size
         FOR i = 1 TO gFMDCtr                                     ' Collect paths
            IF gFMD(i).Type(%FEntry, %FFLEntry) THEN              '
               INCR SymCtr: SymEnt(SymCtr) = gFMD(i).DPath        ' Save the path
            END IF                                                '
         NEXT i                                                   '
      ELSE                                                        '
         REDIM SymEnt(1 TO MEditCount + OldFLCtr) AS STRING       '
         FOR i = 1 TO MEditCount                                  ' Collect paths
            INCR SymCtr: SymEnt(SymCtr) = MEditList(i)            ' Save the path
         NEXT i                                                   '
      END IF                                                      '
      ARRAY SORT SymEnt() FOR SymCtr, COLLATE UCASE               ' Sort them
      FOR i = 1 TO SymCtr                                         ' Now remove duplicates
         IF i < SymCtr THEN                                       ' If not at the end
            IF IsEQ(SymEnt(i), SymEnt(i+1)) THEN                  ' We have a duplicate
               ARRAY DELETE SymEnt(i)                             ' Remove it
               DECR SymCtr: DECR i                                ' Adjust counters
            END IF                                                '
         END IF                                                   '
      NEXT i                                                      '

   '-----------------------------------------------------------------------------------------------+
   '- Do a full normal FileList type                                                               |
   '-----------------------------------------------------------------------------------------------+
   ELSE                                                           '
      IF FMFlag THEN                                              ' FM mode?
         REDIM SymEnt(1 TO gFMDCtr + OldFLCtr) AS STRING          ' Set table size
         FOR i = 1 TO gFMDCtr                                     ' Lets see if any lines were selected
            IF gFMD(i).Type(%FEntry, %FFLEntry, %FOpen) THEN      '
               INCR SymCtr                                        ' Save the path
               SymEnt(SymCtr) = gFMD(i).FullPath                  '
            END IF                                                '
         NEXT i                                                   '
      ELSE                                                        ' MEdit mode
         REDIM SymEnt(1 TO MEditCount + OldFLCtr) AS STRING       ' Set table size
         FOR i = 1 TO MEditCount                                  ' Lets see if any lines were selected
            INCR SymCtr                                           ' Save the path
            SymEnt(SymCtr) = MEditList(i)                         '
         NEXT i                                                   '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Merge in the OldFL if APPEND loaded it                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF OldFLCtr > 0 THEN                                           ' Some already?
      FOR i = 1 TO OldFLCtr                                       ' See if already here
         FOR j = 1 TO SymCtr                                      ' See if its in the new items
            IF IsEQ(OldFl(i), SymEnt(j)) THEN                     '
               OldFl(i) = ""                                      ' Null the old one
            END IF                                                '
         NEXT j                                                   '
      NEXT i                                                      '
      FOR i = 1 TO OldFLCtr                                       ' See if already here
         IF OldFl(i) <> "" THEN                                   ' Add remaining to SymEnt
            INCR SymCtr                                           ' Save the path
            SymEnt(SymCtr) = OldFL(i)                             '
         END IF                                                   '
      NEXT i                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Write it now                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF SymCtr = 0 THEN _                                           ' Did we end up with anything?
      MErrExit(%eNone, "MAKELIST skipped, no eligible file entries") '
   FNum = FREEFILE                                                ' Get a file number
   Call3(TryOpenOutPut(gENV.HomeData + "FILELIST\" + ListName + ".FLIST", FNum), _   ' Try the open
         MErrExit(%eFail, "FILELIST Write Open failed"), _        ' Oops?  Bail out
         MErrExit(%eFail, "FILELIST File is in use"), _           ' Oops?  Bail out
         Nul)                                                     ' Continue
   FOR i = 1 TO SymCtr                                            '
      IF ISFALSE INSTR(SymEnt(i), "|") THEN                       ' If not an Old item with operands
         IF FMFlag THEN                                           ' FM mode?
            SymEnt(i) = SymEnt(i) + "|" + IIF$(ISNULL(FileListNm), TRIM$(FMask), "*")  ' Add the current FMask if in FilePath mode
         ELSE                                                     ' MEDIT mode
            SymEnt(i) = SymEnt(i) + "|*"                          ' Add the current FMask if in FilePath mode
         END IF                                                   '
      END IF                                                      '
      PRINT # FNum, SymEnt(i)                                     ' Write the entry out
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Close up now                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   CLOSE # FNum                                                   ' Close the FBO
   TP.ErrMsgAdd(%eNone, ListName + ".FLIST " + IIF$(Appflag, "appended", IIF$(Repflag, " replaced", "created")))  '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdMARK(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Set MARK or do a Query                                                                          |
'--------------------------------------------------------------------------------------------------+
   FCB.MarkFlag = GetOnOff(1, FCB.MarkFlag, PCmd)                 ' Let GetOnOff do all the work
END METHOD                                                        '

METHOD  pCmdMEDIT(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Multi-Edit startup                                                                              |
'--------------------------------------------------------------------------------------------------+
   DoMultiEdit(pCmd)                                              ' Must do globally because of Tab additions
   IF TP.FCB_.IMacro <> "" THEN                                   ' Is there an IMacro?
      IF UCASE$(TP.FCB_.IMacro) = TP.FCB_.IMacro THEN             ' Is macroname Uppercase? (ON)
         IF isMacro(TP.FCB_.IMacro) THEN                          ' Does it exist?
            me.pCmdMacro(TP.FCB_.IMacro)                          ' Then go do it
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '
END METHOD                                                        '

METHOD  pCmdMINLEN(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Alter the MINLEN setting                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lCmd AS STRING, OldMINLEN AS LONG                           '
   OldMINLEN = FCB.MINLEN                                         ' Save current MINLEN
   FCB.MINLEN = GetSimpleNum(1, FCB.MINLEN, %False, PCmd)         ' Let GetSimpleNum do all the work

   '-----------------------------------------------------------------------------------------------+
   '- Possibly adjust lines                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF FCB.MINLEN > OldMINLEN THEN                                 ' Increasing MINLEN value
      lCmd = "PL 1 " + FORMAT$(LastLine) + " 0 0 . "              ' Build internal PL command line
      lCmd = lCmd + lCmd                                          '
      lCmdPL(lCmd)                                                ' Go do a PL/ command for all lines
   END IF                                                         '
END METHOD                                                        '

METHOD  pCmdMode(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Set the processing Mode                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL e, em, c, cm, w, wm, t AS STRING, i AS LONG                 '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispMode, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "MODE requires an operand") ' No Ops?
   e = PTBL.Grp("EMODE")                                          ' Get the Edit Mode
   c = PTBL.Grp("CSDS")                                           ' Get the CSDS Mode
   w = PTBL.Grp("WCHAR")                                          ' Get the Word/Char Mode

   '-----------------------------------------------------------------------------------------------+
   '- Handle the Edit mode stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(e) AND IsMEdit THEN                               '
      em = "MODE: " + e + " not supported in MEdit, ignored, ": e = "": GOTO DispIt ' MEdit Mode not supported
   END IF                                                         '
   t = "Settings: "                                               ' Start message
   IF ISNOTNULL(e) THEN                                           ' Got an operand?
      SELECT CASE AS CONST$ e                                     ' Check the operand
         CASE "EDIT":   i = %Edit                                 '
         CASE "BROWSE": i = %Browse                               '
         CASE "VIEW":   i = %View                                 '
      END SELECT                                                  '
      em = "Edit: " + e + ", "                                    ' Save as msg
      FCB.Mode = i                                                ' Save it
      TP.TabMode = i                                              ' Switch the actual tab
      DoStatusBar($SBMode)                                        ' Re-Do the StatusBar Mode box
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Handle the Word/Char stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   IF w = "WORD" THEN FindWord = %True:  wm = "Find: WORD, "      ' WORD?
   IF w = "CHAR" THEN FindWord = %False: wm = "Find: CHAR, "      ' CHAR?
   DoStatusBar($SBCaseWord)                                       ' re-Do the StatusBar Case box

   '-----------------------------------------------------------------------------------------------+
   '- Handle the CS/DS stuff                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(c) THEN                                           ' Get the CS/DS operand
      FCB.ChangeMode = LEFT$(c, 1)                                ' Set it
      FCB.BuildLines                                              ' Rebuild PROF1/2/3/4/5 lines
      cm = "Change: " + c + ", "                                  ' Build msg
      DoStatusBar($SBChange)                                      ' Change the status Change bar
   END IF                                                         '

   DispMode:                                                      '
      IF ISNULL(em) THEN em = "Edit: " + SWITCH$(TP.TabMode = %MEdit, "MEDIT", TP.TabMode = %Edit, "EDIT", TP.TabMode = %Browse, "BROWSE", TP.TabMode = %View, "VIEW") + ", " '
      IF ISNULL(cm) THEN cm = "Change: " + SWITCH$(FCB.ChangeMode = "C", "CS", FCB.ChangeMode = "D", "DS") + ", " '
      IF ISNULL(wm) THEN wm = "Find: " + IIF$(FindWord, "WORD", "CHAR") + ", "   '
   DispIt:                                                        '
      t += IIF$(ISNULL(wm), "", wm) + IIF$(ISNULL(cm), "", cm) + IIF$(ISNULL(em), "", em) '
      IF RIGHT$(t, 2) = ", " THEN t = CLIP$(RIGHT, t, 2)          ' Tidy it up
      MErrExit(%eNone, (t))                                       '
      TP.FCB_.BuildLines                                          ' Re-do PROF lines
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdNFIND(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- NFIND (Negative Find) Command                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL modemsg, str AS STRING                                      '
LOCAL i, RSRCH AS LONG, AllCount AS LONG                          '
LOCAL lclCol, ldir, lsline AS LONG                                ' Local saves for FIND ALL
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Parse
         PCmdHelp("HELP NFIND"), _                                ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   RSRCH = PTBL.IsKwd("RSRCH")                                    ' Grab RSRCH early
   LocFind = "NFIND"                                              ' Remember what Loc / FIND command was last
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   IF ISFALSE RSRCH THEN                                          ' If not a RSRCH
      Call3(PTBL.ParseCmd(pCmd, %PAssign), _                      ' Complete the Parse
            PCmdHelp("HELP NFIND"), _                             ' ? entered
            MErrExit(%eFail, PTBL.ErrMsg), _                      ' Error, Bail out
            Nul)                                                  ' Continue
   END IF                                                         '
   IF ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _         '
      ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN _       '
      PTBL.FlgNext = %True                                        ' Set NEXT if no others specified
      PTBL.FlgNF = %True                                          ' Force this to NF
   IF RSRCH THEN PTBL.FlgAll = %False                             '
   IF LEN(PTBL.L1Raw) < 16 THEN                                   ' Build msg literal
      str = PTBL.L1Raw                                            '
   ELSE                                                           '
      str = LEFT$(PTBL.L1Raw, 14) + ".."                          '
   END IF                                                         '

   modemsg = IIF$(PTBL.FlgWord, "WORD " + str, "CHARS " + str)    '
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values

   IF PTBL.FlgAll THEN                                            ' The ALL version?
      AllCount = 0                                                ' Reset variables
      i = me.NFSearch(0, @P.C.CType)                              ' Do the initial search
      IF i THEN                                                   '
         i = sLine                                                ' Get found line
         INCR AllCount: lclCol = sCol: lDir = sDir: lsLine = sLine   ' Count and save 1st located for RFIND stuff
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.NFSearch(1, %CNext)                               ' Do re-Finds
         IF i THEN                                                ' Found one
            i = sLine                                             ' Get found line
            INCR AllCount                                         ' Count successful
         END IF                                                   '
      LOOP                                                        '
      IF AllCount = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(%eFail, modemsg + " found on all lines")    '
      ELSE                                                        '
         TP.ErrMsgAdd(0, modemsg + " not found in " + FORMAT$(AllCount) + IIF$(AllCount > 1, " lines", " line"))  '
         sCol = lclCol: sDir = lDir: sLine = lsLine               ' Restore to 1st one found
      END IF                                                      '
   ELSE                                                           ' The non-All version
      i = me.NFSearch(IIF(RSRCH, 1, 0), @P.C.CType)               ' Go see if we can find it
      IF i = 0 THEN                                               ' Got it?
         TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)               ' Remember we failed
      ELSE                                                        '
         IF PTBL.FlgMX THEN                                       ' X'ing the line?
            TP.ErrMsgAdd(%eNone, modemsg + " not found and X'd")  '
         ELSE                                                     '
            TP.ErrMsgAdd(%eNone, modemsg + " not found")          '
         END IF                                                   '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdNotify(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Switch Notify level                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, t, MSG AS STRING                                 '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   MSG = "?"                                                      '
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO NotDisp, _                                          ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "NOTIFY requires an operand")  ' No Ops, kill it
   t = PTBL.Grp("NOTIFY")                                         ' Get which one
   SELECT CASE AS CONST$ t                                        ' Split by which one
      CASE "NONE":  gENV.NotifyLevelT = 0                         ' Set Notify to None
      CASE "EDIT":  gENV.NotifyLevelT = 1                         ' Set Notify to Edit
      CASE "ALL":   gENV.NotifyLevelT = 2                         ' Set Notify to All
      CASE "RESET": gENV.NotifyLevelT = gENV.NotifyLevel          ' Get the default user's value
   END SELECT                                                     '
   NotDisp:                                                       '
   DoProfMsg(MSG + "NOTIFY set to " + SWITCH$(gENV.NotifyLevelT = 0, "NONE", gENV.NotifyLevelT = 1, "EDIT", gENV.NotifyLevelT = 2, "ALL"))   '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdOPEN(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Start a new EDIT session                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL fn AS STRING                                                '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H OPEN"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 1 THEN fn = PTBL.Pos2(1)                      ' Try for an Operand
   IF ISNULL(fn) THEN                                             ' No filename?
      fn = DoOpenFile("Specify file to Edit", fn)                 ' Go get one
      IF ISNULL(fn) THEN _                                        '
         MErrExit(%eNone, "File selection cancelled")             ' No selection?    Bail out
   END IF                                                         ' We have fn="" for NEW or a filename

   IF INSTR(fn,"\") = 0 THEN fn = GetDefaultFolder + fn           '
   IF ISNULL(PATHSCAN$(FULL, fn)) THEN _                          ' Valid name?
      MErrExit(%eFail, "Invalid Filename or missing file")        ' No,  Bail out
   DoCloneSession(fn)                                             ' Go fire up the session
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdOPTIONS(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Handle Options Command                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL StartPg AS LONG                                             '
LOCAL lclLNoSize, lclENGChars, lclSetU, lclPFK AS LONG, t AS STRING  '
LOCAL PPSave AS PanelCtl PTR                                      '

REGISTER i AS LONG                                                '
REGISTER j AS LONG                                                '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H OPTION"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   PPSave = P                                                     ' Save Panel pointer at entry
   gENV.SaveScheme                                                ' Save Scheme array 'as is' in case cancelled
   DIALOG GET LOC ghWnd TO i, j                                   ' Get and save location where we are
   gENV.LastScreenX = i: gENV.LastScreenY = j                     '
   gfOptCancel = %False                                           ' Reset the cancelled flag
   lclENGChars = gENV.ENGChars                                    ' Save to monitor for changes
   lclLNoSize = gENV.LinNoSize                                    ' Save to monitor for changes
   lclSetU    = gENV.UndoLevels                                   ' Save to monitor for changes
   lclPFK     = gENV.PFKShow                                      ' Save to monitor for changes
   IF PTBL.OpsNum = 0 THEN                                        ' No operand - Use General
      StartPg = 1                                                 '
   ELSE                                                           '
      t = UCASE$(PTBL.Ops(1))                                     ' Fetch it
      SELECT CASE AS t                                            '
         CASE LEFT$("GENERAL",  LEN(t)): StartPg = 1              '
         CASE LEFT$("FILEMGR",  LEN(t)): StartPg = 2              '
         CASE LEFT$("FM",       LEN(t)): StartPg = 2              '
         CASE LEFT$("SUBMIT",   LEN(t)): StartPg = 3              '
         CASE LEFT$("SCREEN",   LEN(t)): StartPg = 4              '
         CASE LEFT$("KEYBOARD", LEN(t)): StartPg = 5              '
         CASE LEFT$("KBD",      LEN(t)): StartPg = 5              '
         CASE LEFT$("STATUS",   LEN(t)): StartPg = 6              '
         CASE LEFT$("SCHEMES",  LEN(t)): StartPg = 7              '
         CASE LEFT$("HILITES",  LEN(t)): StartPg = 8              '
         CASE LEFT$("HILIGHTS", LEN(t)): StartPg = 8              '
         CASE LEFT$("CONFIG",   LEN(t)): StartPg = 9              '
         CASE ELSE: StartPg = 1                                   '
      END SELECT                                                  '
   END IF                                                         '
   DispOptions(StartPg)                                           ' Go let user play with them
   IF gfOptCancel THEN                                            ' Cancelled out?
      gENV.LoadScheme                                             ' Restore original Scheme
      gENV.SetGlobalClrs                                          ' Copy all of it to Global
      CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB                    ' Set focus to regain mousewheel control
      MExitMeth                                                   ' Return
   END IF                                                         '
   gENV.SchemeSaveAll                                             ' Save scheme and HiLites
   gENV.SetGlobalClrs                                             ' Copy all of it to Global

   IF gENV.LinNoSize <> lclLNoSize THEN                           ' Has line number width changed?
      InitLNText                                                  ' Reset some stuff
   END IF                                                         '
   IF gENV.UndoLevels <> lclSetU THEN                             ' Has UndoLevels changed?
      DoMessageBox "UndoLevels has been altered, it is recommended you" + $CRLF + _ '
                   "restart SPFLite to complete the change.", %MB_OK OR %MB_USERICON, "SPFLite" '
   END IF                                                         '

   WindowSize()                                                   ' Go resize the window

   SetCmd                                                         ' Cursor to Cmd line
   TP.FCB_.WordVal()                                              ' re-do Word in case NatChar changed
   LastRulCol = 0: LastRulRow = 0                                 ' In case crosshair cursors active
   IF gTabsNum = 0 THEN MExitMeth                                 ' Don't screw up at termination
   GlobalOptionSet                                                ' Go do corrections to all tabs
   TP.ErrMsgAdd(%eNone, "Options set")                            ' Issue message
   gENV.SetINITimeStamp                                           '
   DoStatusBar($AllStatusBarBoxes)                                ' Get it re-drawn
   DOCmdAdd("(Enter)")                                            ' Force an (Enter)
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdPAGE(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Turn PAGE ON / OFF & set offset                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL PF, PO AS LONG, MSG AS STRING                               '
   MEntry                                                         '
   PF = FCB.PageFlag: PO = FCB.PageOffset                         ' Save in case needed
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO PageDisp, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "PAGE requires an operand") ' No Ops?

   FCB.PageOffset = 0                                             ' Start with zero
   SELECT CASE PTBL.Grp("PAGE")                                   ' Get ON OFF SCROLL
      CASE "ON":     FCB.PageFlag = 1                             '
      CASE "SCROLL": FCB.PageFlag = 2                             '
      CASE "OFF":    FCB.PageFlag = 0                             '
   END SELECT                                                     '

   IF PTBL.GotNum > 0 THEN                                        ' Simple numeric?
      FCB.PageOffset = VAL(PTBL.Pos("#", 1))                      ' Grab it
      IF PTBL.GotLit > 0 THEN GOSUB Restore: MErrExit(%eFail,"Unknown PAGE operand - " + PTBL.Pos2(1))   '
   ELSEIF PTBL.GotLit > 0 THEN                                    ' Possible + - nnn ?                                                 '
      IF VERIFY(PTBL.Pos2(1), "+-0123456789") > 0 THEN            ' +/- nnn
         GOSUB Restore                                            '
         MErrExit(%eFail,"Unknown PAGE operand - " + PTBL.Pos2(1))   ' Issue error message
      END IF                                                      '
      FCB.PageOffset = VAL(PTBL.Pos2(1))                          ' Grab it
   END IF                                                         '

   IF FCB.PageFlag = 2  AND FCB.PageOffset > 0 THEN               '
      GOSUB Restore                                               '
      MErrExit(%eFail, "Page offsets not allowed in PAGE SCROLL mode")  '
   END IF                                                         '
   PageDisp:                                                      '
   DoProfMsg(MSG + "PAGE set to " + IIF$(FCB.PageFlag, IIF$(FCB.PageFlag = 2, "SCROLL", "ON"), "OFF") + IIF$(FCB.PageOffset <> 0, "/" + FORMAT$(FCB.PageOffset, "+#;-#"), ""))   '
   MExitMeth                                                      '
   Restore:                                                       '
   FCB.PageFlag = PF: FCB.PageOffset = PO: RETURN                 '
END METHOD                                                        '

METHOD  pCmdPASTE(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- PASTE Clipboard data into the dataset                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL lclTop, lc, lc1, i, x, y, z, pl, ABi, NumAdj, NumInDest, before, after, cberase, ablabel, ColW AS LONG   '
LOCAL ln, t, cbname, MyDlm AS STRING, tc AS WSTRING               '
LOCAL CBCount AS LONG                                             '

   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H PASTE"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   lclTop = @P.PTopLine                                           ' Save current top
   ColW = ((@P.PDataLen - 3) \ 2) - 6                             ' 2COLUMN column width

   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   '-----------------------------------------------------------------------------------------------+
   '- Scan our operands                                                                            |
   '-----------------------------------------------------------------------------------------------+
   before  = PTBL.IsKwd("BEFORE")                                 ' Set flags
   after   = PTBL.IsKwd("AFTER" )                                 '
   cberase = PTBL.IsKwd("ERASE")                                  '
   IF PTBL.GotDotd > 0 THEN ablabel = me.LineNoRef(PTBL.Pos(".", 1)) ' Get the line number
   IF PTBL.GotLPtr > 0 THEN                                       '
      IF ablabel THEN MErrExit(%eFail, "Multiple line references entered") ' Oops!
      ablabel = me.LineNoRef(PTBL.Pos("!", 1))                    ' Get the line number
   END IF                                                         '
   IF PTBL.GotLit > 0 THEN                                        ' String?
      cbname = PTBL.Pos2(1)                                       ' Save clipboard name
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Look for stupidities                                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF (before OR after) AND ablabel = 0 THEN _                    '
      MErrExit(%eFail, "BEFORE/AFTER require a line label")       ' Issue error

   '-----------------------------------------------------------------------------------------------+
   '- See if we're empty or not                                                                    |
   '-----------------------------------------------------------------------------------------------+
   IF LastLine <> 2 THEN                                          ' If we're not empty

      '--------------------------------------------------------------------------------------------+
      '- Not empty, get our line reference                                                         |
      '--------------------------------------------------------------------------------------------+
      IF before > 0 THEN                                          ' Stuff in A/B from cmd line
         lc = ablabel - 1                                         '
         IF ISTRUE gLTblRange THEN _                              ' See if an A/B line control waiting
            MErrExit(%eCmdPend, "Cannot specify BEFORE and also an A/B, O/OO, OR/ORR, AA/BB or H/HH line control")   '

      ELSEIF after > 0 THEN                                       '
         lc = ablabel                                             '
         IF ISTRUE gLTblRange THEN _                              ' See if an A/B line control waiting
            MErrExit(%eCmdPend, "Cannot specify AFTER and also an A/B, O/OO, OR/ORR, AA/BB or H/HH line control") '

      ELSE                                                        '
         '-----------------------------------------------------------------------------------------+
         '- Last chance is a line command range                                                    |
         '-----------------------------------------------------------------------------------------+
         IF ISFALSE gLTblRange OR _                               ' A Line range?
            INSTR("A       B       H       HH      O       OO      OR      ORR     AA      BB      ", gLTblDCmd) = 0 THEN  ' But not a valid one?
               MErrExit(%eCmdPend, "Specify A/B, O/OO, OR/ORR, AA/BB or H/HH line control for PASTE") '
         END IF                                                   '

         IF gLTblDCmd = "A       " OR gLTblDCmd = "B       " THEN ' One of the simple ones?
            lc = IIF(gLTblDCmd = "A       ", gLTblDFrom, gLTblDFrom - 1)   ' Set Insert point
            me.TTblDel(gLTblDFrom)                                ' Remove from Touched lines
            me.UpdLControl(gLTblDFrom)                            ' Clear from the line
            IF IsLXClude(lc) THEN _                               ' If this is an Excluded line
               lc += LWrk1G(lc)                                   ' Step over
         ELSE                                                     ' It's one of the complicated ones
            GOSUB PasteBlock                                      ' Go handle specially
            MExitMeth                                             '
         END IF                                                   '
      END IF                                                      '

   '-----------------------------------------------------------------------------------------------+
   '- File is empty                                                                                |
   '-----------------------------------------------------------------------------------------------+
   ELSE                                                           '
      lc = 1                                                      ' Else insert after top line
      PTBL.PTBLReset                                              ' Ensure default range of ALL before reset
      IF ISTRUE gLTblRange THEN                                   ' User entered an A/B anyway?
         IF gLTblDCmd = "A       " OR gLTblDCmd = "B       " THEN ' One of the simple ones?
            me.TTblDel(gLTblDFrom)                                ' Remove from Touched lines
            me.UpdLControl(gLTblDFrom)                            ' Clear from the line
         END IF                                                   '
      END IF                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Insert after the lc pointer                                                                  |
   '-----------------------------------------------------------------------------------------------+
   gKeyPrimOper = cbname: MyDLM = $CRLF                           ' Set clipboardname / delimiter
   IF ClipboardRead(t, MyDLM, cberase) THEN                       ' Go get whatever's there (True = missing CLIP file
      MErrExit(%eFail, "The " + gKeyPrimOper + " CLIP file does not exist")   '
   END IF                                                         '

   IF LEN(t) < 1 THEN                                             ' Error if nothing there
      MErrExit(%eFail, "The " + IIF$(ISNULL(gKeyPrimOper), "Windows", gKeyPrimOper) + " clipboard was empty")  '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Deblock the clipboard and insert the lines                                                   |
   '-----------------------------------------------------------------------------------------------+
   me.ModSet(lc)                                                  ' Remember we changed something
   pl = 0                                                         ' Reset counter
   IF lc1 = 0 THEN lc1 = lc                                       ' Save 1st insertion point
   IF LEFT$(t, 14) <> "C|SPFLite Diff" THEN                       ' Look for our DIFF eyeball
      '--------------------------------------------------------------------------------------------+
      '- Normal clipboard handling                                                                 |
      '--------------------------------------------------------------------------------------------+
      DO WHILE LEN(t) > 1                                         ' Loop extracting text lines
         ln = EXTRACT$(t, MyDLM)                                  ' Get one line
         ln = TAB$(ln, FCB.ImportTabs)                            ' Do any needed tab conversion
         t =  REMAIN$(t, MyDlm)                                   ' Make t = the remainder of the line
         me.LInsertLines(lc, 1, %Data)                            ' Request insert 1, %Data line
         INCR lc: INCR pl                                         ' Bump insertion point, count line
         me.LTxtSet(lc, ln)                                       ' Copy in the extacted text
         me.UpdLControl(lc)                                       ' Setup LLCtl
         me.AttrScan(lc)                                          ' Recolorize
         GOSUB DoPMlc                                             ' Go do PM processing
      LOOP                                                        '

   ELSE                                                           '
      '--------------------------------------------------------------------------------------------+
      '- DIFF clipboard handling                                                                   |
      '--------------------------------------------------------------------------------------------+
      CBCount = VAL(MID$(t, 16, 6)) - 1                           ' Get linecount (- 1 for eyeball)
      me.LInsertLines(lc, CBCount, %Data)                         ' Request insert CBCount, %Data lines
      TabMode = TabMode OR %Diff                                  ' Set DIFF flag
      ln = EXTRACT$(t, $CRLF)                                     ' Get the Eyeball Line
      t =  REMAIN$(t, $CRLF)                                      '
      '--------------------------------------------------------------------------------------------+
      '- Clipboard deblocking                                                                      |
      '--------------------------------------------------------------------------------------------+
      DO WHILE LEN(t) > 1                                         ' Loop extracting text lines
         ln = EXTRACT$(t, $CRLF)                                  ' Get one line
         t =  REMAIN$(t, $CRLF)                                   '
         INCR lc                                                  ' Increment SPFLite line number
         SELECT CASE LEFT$(ln, 2)                                 ' See what type of line
            CASE "N|"                                             ' Normal
               me.LTxtSet(lc, MID$(ln, 3))                        ' Copy in the extacted text
               tc = REPEAT$(LEN(ln), CHR$$(0))                    ' Set default Attr
               me.LAttrSet(lc, tc)                                '
            CASE "D|"                                             ' Deletion
               me.LTxtSet(lc, MID$(ln, 3))                        ' Copy in the extacted text
               me.LFlagBitOn(lc, %User)                           ' Mark the line as a USER line
               IF (gENV.Diff1Column) THEN                         ' 1COLUMN
                  tc = REPEAT$(me.LTxtLen(lc), CHR$$(%SCDiffD))   ' Mark deleted line
               ELSE                                               '
                  tc = REPEAT$(ColW + 6, CHR$$(%SCDiffD)) + REPEAT$(ColW + 9, CHR$$(0))   '
               END IF                                             '
               me.LAttrSet(lc, tc)                                ' Set font/color attributes
            CASE "I|"                                             ' Insertion
               me.LTxtSet(lc, MID$(ln, 3))                        ' Copy in the extacted text
               me.LFlagBitOn(lc, %User)                           ' Mark the line as a USER line
               IF (gENV.Diff1Column) THEN                         ' 1COLUMN
                  tc = REPEAT$(me.LTxtLen(lc), CHR$$(%SCDiffI))   ' Mark Inserted line
               ELSE                                               '
                  tc = REPEAT$(ColW + 9, CHR$$(0)) + REPEAT$(ColW + 9, CHR$$(%SCDiffI))   '
               END IF                                             '
               me.LAttrSet(lc, tc)                                ' Set font/color attributes
            CASE "C|"                                             ' Mis-Match Change
               me.LTxtSet(lc, MID$(ln, 3))                        ' Copy in the extacted text
               me.LFlagBitOn(lc, %User)                           ' Mark the line as a USER line
               tc = REPEAT$(ColW + 6, CHR$$(%SCDiffD)) + REPEAT$(3, CHR$$(0)) + REPEAT$(ColW + 6, CHR$$(%SCDiffI))   '
               me.LAttrSet(lc, tc)                                ' Set font/color attributes
         END SELECT                                               '
         me.UpdLControl(lc)                                       ' Setup LLCtl
      LOOP                                                        '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Clean up and exit                                                                            |
   '-----------------------------------------------------------------------------------------------+
   @P.PTopLine = lclTop                                           ' Restore CRP

   IF ISFALSE IsSetEdit AND ISFALSE IsEFTEdit THEN                ' If not Set Edit of EFT Edit etc
      IF LEFT$(gKeyPrimOper, 6) <> "_DIFF." THEN _                ' Skip message if DIFF report
         TP.ErrMsgAdd(0, "Paste of " + FORMAT$(pl) + " line" + IIF$(pl > 1, "s", "") + " complete from " + IIF$(ISNULL(gKeyPrimOper), "Windows", gKeyPrimOper) + " clipboard")   '
      IF cberase THEN ClipboardWrite("")                          ' Erase if asked for
      RESET gKeyPrimOper                                          ' Blank clipboardname
      me.CurSetReq(%LineCmd, lc1 + 1, 1, %True)                   ' Set cursor set attempt

   ELSE                                                           '
      '--------------------------------------------------------------------------------------------+
      '- manage clipboard for special use in SET Edit session                                      |
      '--------------------------------------------------------------------------------------------+
      IF IsSetEdit THEN                                           ' Setup message
         TP.ErrMsgAdd(0, "Current SET values")                    '
      ELSEIF IsEFTEdit THEN                                       '
         TP.ErrMsgAdd(0, "Current EFT table")                     '
      END IF                                                      '
      ClipBoardSet(gSetClipB)                                     '
   END IF                                                         '

   MExitMeth                                                      '

'--------------------------------------------------------------------------------------------------+
'- Do the paste block mode type                                                                    |
'--------------------------------------------------------------------------------------------------+
PasteBlock:                                                       ' Do the Paste Overlay stuff

   '-----------------------------------------------------------------------------------------------+
   '- First get the CBD data into an array                                                         |
   '-----------------------------------------------------------------------------------------------+
   DIM IStr(1000) AS STRING                                       ' Get a table to hold paste data
   gKeyPrimOper = cbname: MyDLM = $CRLF                           ' Set clipboardname / delimiter
   IF ClipboardRead(t, MyDLM, cberase) THEN                       ' Go get whatever's there (True = missing CLIP file
      TP.ErrMsgAdd(%eFail, "The " + gKeyPrimOper + " CLIP file does not exist")  '
      me.TTblDel(gLTblSFrom): me.UpdLControl(gLTblSFrom)          ' Remove from Touched lines
      IF gLTblSFrom <> gLTblSTo THEN me.TTblDel(gLTblSTo): me.UpdLControl(gLTblSTo) '
      MExitMeth                                                   '
   END IF                                                         '
   IF LEN(t) < 1 THEN                                             ' Error if nothing there
      TP.ErrMsgAdd(%eFail, "Clipboard was empty")                 '
      MExitMeth                                                   '
   END IF                                                         '

   lclTop = @P.PTopLine                                           ' Save current top

   '-----------------------------------------------------------------------------------------------+
   '- Extract CBD lines to the IStr array                                                          |
   '-----------------------------------------------------------------------------------------------+
   pl = 0                                                         ' Reset count
   DO WHILE LEN(t) > 1                                            ' Loop extracting text lines
      INCR pl                                                     '
      IF pl > UBOUND(IStr) THEN                                   ' Expand IStr if needed
         REDIM PRESERVE IStr(UBOUND(IStr) + 1000)                 '
      END IF                                                      '
      IStr(pl) = EXTRACT$(t, MyDLM)                               ' Get one line
      IStr(pl) = TAB$(IStr(pl), FCB.ImportTabs)                   ' Do any needed tab conversion
      t =  REMAIN$(t, MyDlm)                                      ' Make t = the remainder of the line
   LOOP                                                           ' Loop til IStr holds pl paste lines

   '-----------------------------------------------------------------------------------------------+
   '- Handle the O/OO or OR/ORR style PASTE functions                                              |
   '-----------------------------------------------------------------------------------------------+
   IF gLTblDCmd = "O       " OR gLTblDCmd = "OO      " OR _       ' Is this the O / OO Overlay Type?
      gLTblDCmd = "OR      " OR gLTblDCmd = "ORR     " THEN       ' or OR/ORR

      IF gLTblDFrom = gLTblDTo THEN                               ' Same From/To  (i.e. O command)
         gLTblDTo = gLTblDFrom + MAX(1, gLTblDRpt) - 1            ' Set To address based on Onnn count (Def 1)
      END IF                                                      '
      me.TTblDel(gLTblDFrom)                                      ' Remove from Touched lines
      me.UpdLControl(gLTblDFrom)                                  ' Clear from the line
      me.TTblDel(gLTblDTo)                                        '
      me.UpdLControl(gLTblDTo)                                    '
      me.CurSetReq(%LineCmd, gLTblDFrom, 1, %False)               ' Set cursor set attempt
      z = 1                                                       ' Point at 1st Paste line
      FOR x = gLTblDFrom TO gLTblDTo                              ' Loop through destination lines
         IF IsLData(x) THEN                                       ' Overlay Dest Data lines
            me.ModSet(x)                                          ' Remember we changed something
            IF gLTblDCmd = "OR     " OR gLTblDCmd = "ORR    " OR gLTblDCmd = "OROR   " THEN  ' or OR/ORR/OROR
               me.LTxtSet(x, me.OverlayTextRepl(IStr(z), LTxtG(x)))  '
            ELSE                                                  '
               me.LTxtSet(x, me.OverlayText(IStr(z), LTxtG(x)))   '
            END IF                                                '
            me.AttrScan(x)                                        ' Recolorize
            me.LFlagBitOff(x, %EQChange)                          ' Reset ==CHG>
            me.UpdLControl(x)                                     ' And LLCtl
            GOSUB DoPMx                                           ' Go do PM processing
            IF z < pl THEN INCR z ELSE z = 1                      ' Next paste source line (or repeat from the top)
         END IF                                                   '
      NEXT x                                                      ' Loop Outer
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Handle the H/HH style PASTE functions                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF gLTblDCmd = "H       " OR gLTblDCmd = "HH      " THEN       ' Is this the H / HH Type?
      FOR x = gLTblDFrom TO gLTblDTo                              ' Loop for each deleted line
         me.ModSet(x)                                             ' Remember we changed something
         me.lTxtFree(x)                                           ' Go free the dynamic string
      NEXT x                                                      '
      FOR x = 1 TO gLTblDTo - gLTblDFrom + 1                      ' Loop for each deleted line
         me.LEntDel(gLTblDFrom)                                   ' Remove from the L() array
      NEXT x                                                      '
      LastLine -= gLTblDTo - gLTblDFrom + 1: LastReal -= gLTblDTo - gLTblDFrom + 1  ' Adjust LastLine and LastReal
      lc = gLTblDFrom - 1                                         ' Make previous line look like 'A'

      FOR x = 1 TO pl                                             ' Loop through extracted lines
         me.LInsertLines(lc, 1, %Data)                            ' Request insert 1, %Data line
         INCR lc                                                  ' Bump insertion point
         me.LTxtSet(lc, IStr(x))                                  ' Copy in the extacted text
         me.AttrScan(lc)                                          ' Recolorize
         me.UpdLControl(lc)                                       ' Setup LLCtl
         GOSUB DoPMlc                                             ' Go do PM processing
      NEXT x                                                      '
      me.CurSetReq(%LineCmd, gLTblDFrom, 1, %False)               ' Set cursor set attempt
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Handle the AA style PASTE functions                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF gLTblDCmd = "AA      " THEN                                 ' Is this the AA After type
      me.TTblDel(gLTblDFrom)                                      ' Remove from Touched lines
      me.UpdLControl(gLTblDFrom)                                  ' Clear from the line
      lc1 = gLTblDFrom + 1                                        ' Point where cursor goes
      me.TTblDel(gLTblDTo)                                        '
      me.UpdLControl(gLTblDTo)                                    '
      gLTblDRpt = MAX(1, gLTblDRpt)                               ' Ensure at least count of 1
      FOR x = gLTblDFrom TO gLTblDTo                              ' Count the data lines
         IF IsLData(x) OR IsLTop(x) OR IsLFile(x) THEN            ' Data only
            INCR NumInDest                                        ' in the Dest. range
            GOSUB DoPMx                                           ' Go do PM processing
         END IF                                                   '
      NEXT x                                                      '
      IF NumInDest <= gLTblDRpt THEN _                            ' Dest count reasonable?
         MErrExit(%eFail, "AA number must be < range size")       '
      ABi = gLTblDFrom + gLTblDRpt - 1                            ' Init for loop
      WHILE ABi <= gLTblDTo + NumAdj                              ' Big outer loop
         IF ISFALSE IsLData(ABi) AND ISFALSE IsLTop(ABi) AND ISFALSE IsLFile(ABi) THEN INCR Abi: ITERATE ' Ignore non Data lines
         me.ModSet(ABi)                                           ' Remember we changed something
         me.LInsertLines(ABi, pl, %Data)                          ' Insert enough lines for one copy
         NumAdj += pl                                             ' Track # inserted
         x = ABi + 1                                              ' Calc position to copy the data
         FOR y = 1 TO pl                                          ' For each item in the Clipboard
            me.LTxtSet(x, IStr(y))                                ' Copy in the extacted text
            me.AttrScan(x)                                        ' Recolorize
            me.UpdLControl(x)                                     ' Setup LLCtl
            GOSUB DoPMx                                           ' Go do PM processing
            INCR x                                                ' Bump 'to' pointer
         NEXT y                                                   ' Loop inner
         ABI += gLTblDRpt + pl                                    ' Big outer loop
      LOOP                                                        ' next ABi
      me.AdjustPending(gLTblDFrom + gLTblDRpt - 1, NumAdj, 0)     ' Adjust remaining items in Line Cmnd stack
      me.CurSetReq(%LineCmd, lc1, 1, %False)                      '
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Handle the BB style PASTE functions                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF gLTblDCmd = "BB      " THEN                                 ' Is this the BB After type
      me.TTblDel(gLTblDFrom)                                      ' Remove from Touched lines
      me.UpdLControl(gLTblDFrom)                                  ' Clear from the line
      me.TTblDel(gLTblDTo)                                        '
      me.UpdLControl(gLTblDTo)                                    '

      gLTblDRpt = MAX(1, gLTblDRpt)                               ' Ensure at least count of 1
      FOR x = gLTblDFrom TO gLTblDTo                              ' Count the data lines
         IF IsLData(x) OR IsLTop(x) OR IsLFile(x) THEN            ' Data only
            INCR NumInDest                                        ' in the Dest. range
            GOSUB DoPMx                                           ' Go do PM processing
         END IF                                                   '
      NEXT x                                                      '
      IF NumInDest <= gLTblDRpt THEN _                            ' Dest count reasonable?
         MErrExit(%eFail, "BB number must be < range size")       '
      gLTblDRpt = MAX(1, gLTblDRpt)                               ' Ensure at least count of 1
      x = NumInDest \ gLTblDRpt                                   ' x = # of insertion points
      ABi = gLTblDTo - (x * gLTblDRpt)                            ' Initial insertion point
      lc1 = gLTblDFrom                                            ' Remember where cursor goes
      WHILE ABi < gLTblDTo + NumAdj                               ' Big outer loop
         IF ISFALSE IsLData(ABi) AND ISFALSE IsLTop(ABi) AND ISFALSE IsLFile(ABi) THEN INCR Abi: ITERATE ' Ignore non Data lines
         me.ModSet(ABi)                                           ' Remember we changed something
         me.LInsertLines(ABi, pl, %Data)                          ' Insert enough lines for one copy
         NumAdj += pl                                             ' Track # inserted
         x = ABi + 1                                              ' Calc position to copy the data
         FOR y = 1 TO pl                                          ' For each item in the Clipboard
            me.LTxtSet(x, IStr(y))                                ' Copy in the extacted text
            me.AttrScan(x)                                        ' Recolorize
            me.UpdLControl(x)                                     ' Setup LLCtl
            GOSUB DoPMx                                           ' Go do PM processing
            INCR x                                                ' Bump 'to' pointer
         NEXT y                                                   ' Loop inner
         ABI += gLTblDRpt + pl                                    ' Big outer loop
      LOOP                                                        ' next ABi
      me.AdjustPending(gLTblDFrom + gLTblDRpt - 1, NumAdj, 0)     ' Adjust pending stuff
      me.CurSetReq(%LineCmd, lc1, 1, %False)                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Clean up and exit                                                                            |
   '-----------------------------------------------------------------------------------------------+
   PTBL.PTBLReset                                                 ' Ensure default range of ALL before reset
   @P.PTopLine = lclTop                                           ' Restore CRP
   IF cberase THEN ClipboardWrite("")                             ' Erase if asked for
   TP.ErrMsgAdd(0, "Paste of " + FORMAT$(pl) + " line" + IIF$(pl > 1, "s", "") + " complete from " + IIF$(ISNULL(gKeyPrimOper), "Windows", gKeyPrimOper) + " clipboard")   '
   RESET gKeyPrimOper                                             ' Blank clipboardname
   MExitMeth                                                      '

'--------------------------------------------------------------------------------------------------+
'- Do +/- processing for X lines                                                                   |
'--------------------------------------------------------------------------------------------------+
DoPMx:                                                            '
   IF BIT(gLTblDFlag, %lCmdX) THEN                                ' Do the +/- processing for the Source
      me.LFlagBitOn(x, %Invisible)                                ' If - make Invisible
      gfXRebuild = %True                                          ' Ask for Exclude processing
   ELSEIF BIT(gLTblDFlag, %lCmdNX) THEN                           '
      me.LFlagBitOff(x, %Invisible)                               ' If + make visible
      gfXRebuild = %True                                          ' Ask for Exclude processing
   END IF                                                         '
   RETURN                                                         '

'--------------------------------------------------------------------------------------------------+
'- Do +/- processing for lc lines                                                                  |
'--------------------------------------------------------------------------------------------------+
DoPMlc:                                                           '
   IF BIT(gLTblDFlag, %lCmdX) THEN                                ' Do the +/- processing for the Source
      me.LFlagBitOn(lc, %Invisible)                               ' If - make Invisible
      gfXRebuild = %True                                          ' Ask for Exclude processing
   ELSEIF BIT(gLTblSFlag, %lCmdNX) THEN                           '
      me.LFlagBitOff(lc, %Invisible)                              ' If + make visible
      gfXRebuild = %True                                          ' Ask for Exclude processing
   END IF                                                         '
   RETURN                                                         '

END METHOD                                                        '

METHOD  pCmdPLEASE(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- PLEASE debugging                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL Wrd, lclCmd, ErrMsg AS STRING, nv, i AS LONG                '
LOCAL RCA AS RCUser                                               '
LOCAL Sugg() AS STRING                                            '
   MEntry                                                         '
   Wrd = GetNextWord(pCommand, %Strip)                            '
   Wrd = GetNextWord(pCommand, %Strip)                            '
   IF IsEQ(Wrd, "LOOP") THEN                                      ' LOOP?
      DO WHILE 1 = 1                                              '
      LOOP                                                        '
   ELSEIF IsEQ(Wrd, "CRASH") THEN                                 ' CRASH?
      POKE 0, 12345                                               ' Force a crash
   ELSE                                                           '
                                                                  '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdPRESERVE(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Turn Preserve ON or OFF or C                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL nv AS LONG, str AS STRING                                   '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispPres, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   SELECT CASE AS CONST$ PTBL.Grp("PRESERVE")                     ' Which did we get?
      CASE "OFF": nv = 0                                          ' OFF
      CASE "ON": nv = 1                                           ' ON
      CASE "C": nv = 2                                            ' C
   END SELECT                                                     '
   FCB.PreserveTyp = nv                                           ' Set the new value
   DispPres:                                                      '
   DoProfMsg("PRESERVE set to " + CHOOSE$(FCB.PreserveTyp + 1, "OFF", "ON", "C"))   '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdPRINT(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Handle PRINT Command                                                                            |
'--------------------------------------------------------------------------------------------------+
LOCAL setup AS STRING                                             '
LOCAL i, j AS LONG                                                '
LOCAL lclTop, Number, lclmode AS LONG                             '
DIM dlines(1000) AS LONG                                          ' To hold lines to be deleted
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         pCmdHelp("H PRINT"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   Number = %False                                                ' Default to no-numbered listing
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "PRINT requires an operand")   ' Scan any operands
   IF PTBL.IsKwd("SETUP") THEN                                    ' SETUP ?
      IF PTBL.OpsNum > 1 THEN MErrExit(%eFail, "SETUP must be the only parameter")  ' Issue conflict error
      PrinterOpen("SETUP")                                        '
      MExitMeth                                                   ' And exit
   END IF                                                         '

   IF PTBL.IsKwd("NONUM") THEN Number = %False                    ' Get the NUM / NONUM
   IF PTBL.IsKwd("NUM")   THEN Number = %True                     ' Get the NUM / NONUM

   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '

   IF ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgALL THEN _      ' Better be something
      MErrExit(%eFail, "Pending line range")                      '

   IF IsFMTab THEN                                                ' Only SETUP allowed for File Manager
      MErrExit(%eFail,"Only PRINT SETUP allowed in File Manager") '
   END IF                                                         '

   PTBL.FlgDX = %True                                             ' Tell search hands off Invisible status
   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '
   ErrMsgHigh = %eNone                                            ' Reset any Pending conflict flag
   lclTop = @P.PTopLine                                           '

   IF ISFALSE PrinterOpen("") THEN                                ' Get printer ready if not already
      MErrExit(%eFail, "OPEN of printer failed")                  '
   END IF                                                         '

   PrinterPrint(%PRTReset, " ", " ", Number)                      ' Tell PrinterPrint to reset
   RESET Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen  ' Reset 1st found values
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         GOSUB PrintOne                                           ' Go handle one
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            GOSUB PrintOne                                        ' Go handle one
         END IF                                                   '
      LOOP                                                        '
   ELSE                                                           ' The non-All version
      i = me.Search(0, @P.C.CType)                                ' Go see if we can find it
      IF i THEN                                                   ' Got it?
         GOSUB PrintOne                                           ' Go handle one
      END IF                                                      '
   END IF                                                         '

   PrinterPrint(%PRTFlushClose, " ", " ", Number)                 ' Tell PrinterPrint to flush page and close
   @P.PTopLine = lclTop                                           '
   TP.ErrMsgAdd(0, "Print complete to default printer")           '
   MExitMeth                                                      '

PrintOne:                                                         '
   i = PTBL.FoundLine                                             ' Get the located line number
   IF IsLData(i) AND ISFALSE IsLInsertLine(i) THEN                ' Only data lines of course

      j = PTBL.FindRngFlag                                        ' Copy +/- flag
      IF BIT(j, %lCmdX) THEN                                      ' Do the +/- processing for the Source
         me.LFlagBitOn(i, %Invisible)                             ' If - make Invisible
         gfXRebuild = %True                                       ' Do exclude stuff
      ELSEIF BIT(j, %lCmdNX) THEN                                 '
         me.LFlagBitOff(i, %Invisible)                            ' If + make visible
         gfXRebuild = %True                                       ' Do exclude stuff
      END IF                                                      '

      lclmode = IIF(IsLPage(i), %PRTNewPage, %PRTLine)            ' Set lclmode for forced new page if a =PAGE> line
      IF Number THEN                                              ' Do listing with line numbers?
         PrinterPrint(lclMode, RIGHT$(LLNumG(i), gENV.LinNoSize) + " " + LTxtG(i), _   ' Print line with added linenumber
                            REPEAT$(gENV.LinNoSize + 1, $$TxtLo) + LAttrG(i), Number)  '
      ELSE                                                        '
         PrinterPrint(lclMode, LTxtG(i), LAttrG(i), Number)       ' Print each line without its line number
      END IF                                                      '
      PrinterPrint(%PRTNewLine, " ", " ", Number)                 ' Do end of line
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdPROFILE(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Handle PROFILE Command                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL SaveProf, CopyName, PType, Prf AS STRING, RCA AS RCArea     '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H PROFILE"), _                                 ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN                                        ' If no operands
      IF ISFALSE IsFMTab THEN                                     ' If no operands
         me.RangeSetRange(1, LastLine)                            ' Set full range
         me.ProfDisp                                              ' Just activate the display
         OnUndoFlag                                               ' Write it to the UNDO
         MExitMeth                                                '
      ELSE                                                        '
         MErrExit(%eFail, "Only NEW and EDIT allowed in File Manager")  '
      END IF                                                      '
   END IF                                                         '

   IF PTBL.OpsNum = 1 AND PTBL.GotLit = 1 THEN                    ' Just a Profile Name
      Prf = PTBL.Pos2(1)                                          ' Get the name
      IF ISFALSE gSQL.TableExist("P" + Prf) THEN _                ' See if it exists
         MErrExit(%eFail, "Specified Profile name does not exist")   '
      FCB.SetupProf(Prf, RCA)                                     ' Swap in place of existing
      FCB.BuildLines                                              ' Ensure the BuildLines match
      me.ProfDisp                                                 ' Just activate the display
      TP.ErrMsgAdd(%eNone, "Specified Profile values loaded")     '
   END IF                                                         '

   PType = PTBL.Grp("WHICH")                                      ' Some operand - Get it
   IF IsFMTab AND _                                               ' If FM mode only do certain functions
      PType <> "NEW" AND PType <> "EDIT" THEN _                   '
      MErrExit(%eFail, "Only NEW and EDIT allowed in File Manager")  '
   SELECT CASE AS CONST$ PType                                    ' Handle them
      CASE "UNLOCK"                                               ' UNLOCK / UNLOCKED
         GOSUB CheckEFTLock                                       ' Ensure not EFT locked
         FCB.LockFlag = %False                                    '
         me.RangeSetRange(1, LastLine)                            ' Set full range
         me.ProfDisp                                              ' Just activate the display
         MErrExit(%eNone, "Profile is now unlocked")              '

      CASE "LOCK"                                                 ' LOCK / LOCKED
         GOSUB CheckEFTLock                                       ' Ensure not EFT locked
         FCB.LockFlag = %True                                     '
         me.RangeSetRange(1, LastLine)                            ' Set full range
         me.ProfDisp                                              ' Just activate the display
         MErrExit(%eNone, "Profile is now locked")                '

      CASE "RESET"                                                ' Handle RESET
         GOSUB CheckEFTLock                                       ' Ensure not EFT locked
         FCB.Reset()                                              ' Reset things to standard set
         FCB.WriteAll(%True)                                      ' Write it all to the CFG file
         me.RangeSetRange(1, LastLine)                            ' Set full range
         me.ProfDisp                                              ' Just activate the display

      CASE "COPY"                                                 ' Handle COPY
         GOSUB CheckEFTLock                                       ' Ensure not EFT locked
         IF PTBL.OpsNum < 2 THEN _                                '
            MErrExit(%eFail, "No Profile name specified with COPY")  '
         Prf = PTBL.Pos2(1)                                       ' Get the name
         IF ISFALSE gSQL.TableExist("P"+ Prf) THEN _              ' See if it exists
            MErrExit(%eFail, "Specified Profile name does not exist")   '
         SaveProf = FCB.ProfName                                  ' Save current Profile Name
         FCB.SetupProf(Prf, RCA)                                  ' Set to the Profile being copied
         FCB.ProfName = SaveProf                                  ' Swap the old name back
         FCB.ProfNameSQL = "P" + SaveProf                         '
         FCB.WriteAll(%True)                                      ' Write it all
         me.ProfDisp                                              ' Just activate the display
         TP.ErrMsgAdd(%eNone, "Specified Profile values loaded")  '

      CASE "NEW"                                                  ' Handle NEW
         SaveProf = FCB.ProfName                                  ' Save current name
         IF PTBL.OpsNum < 2 THEN _                                '
            MErrExit(%eFail, "No Profile name specified with NEW")   '
         Prf = PTBL.Pos2(1)                                       ' Get the name
         IF VERIFY(Prf, $AlphaNum) > 0 THEN _                     '
            MErrExit(%eFail, "Profile name contains unsupported characters")  '
         IF gSQL.TableExist("P" + Prf) THEN _                     ' See if it exists
            MErrExit(%eFail, "Specified Profile name already exists")   '
         CopyName = "PDEFAULT"                                    ' Set default copy Profile

         '-----------------------------------------------------------------------------------------+
         '- Just copy whatever Default was specified to the new name                               |
         '-----------------------------------------------------------------------------------------+
         gSQL.TableCopy(CopyName, "P" + uucase(Prf))              ' Copy the default to the new name

         '-----------------------------------------------------------------------------------------+
         '- Remove from EFT just in case                                                           |
         '-----------------------------------------------------------------------------------------+
         EFTRemove(Prf)                                           ' Remove from EFT list
         FCB.SetupProf(Prf, RCA)                                  ' Swap in the Prof values
         TP.ErrMsgAdd(%eNone, FCB.EditProf)                       ' Go do it and return message
         FCB.WriteAll(%True)                                      ' Write it all
         FCB.SetupProf(SaveProf, RCA)                             ' Restore original
         DoStatusBar($AllStatusBarBoxes)                          ' Pick up changes

      CASE "EDIT"                                                 ' Handle EDIT
         GOSUB CheckEFTLock                                       ' Ensure not EFT locked
         Prf = PTBL.Pos2(1)                                       ' Get the name
         IF PTBL.OpsNum < 2 OR Prf = FCB.ProfName THEN            ' Doing ourselves?
            TP.ErrMsgAdd(%eNone, FCB.EditProf)                    ' Go do it and return message
            DoStatusBar($AllStatusBarBoxes)                       ' Pick up changes

         ELSE                                                     ' Doing some other Profile
            IF ISFALSE gSQL.TableExist("P" + Prf) THEN _          ' See if it exists
               MErrExit(%eFail, "Specified Profile name does not exist")   '
            SaveProf = FCB.ProfName                               ' Save current Profile Name
            FCB.SetupProf(Prf, RCA)                               ' Setup Prf to use
            TP.ErrMsgAdd(%eNone, FCB.EditProf)                    ' Go do it and return message

            '--------------------------------------------------------------------------------------+
            '- Put back the original Profile                                                       |
            '--------------------------------------------------------------------------------------+
            FCB.SetupProf(SaveProf, RCA)                          ' Setup Prf to use
            FCB.BuildLines                                        ' Ensure the BuildLines match
         END IF                                                   '
   END SELECT                                                     '
   CONTROL SET FOCUS ghWnd, %IDC_SPFLiteTAB                       ' Set focus
   DoStatusBar($AllStatusBarBoxes)                                ' re-Do the StatusBar box
   MExitMeth                                                      '

   CheckEFTLock:                                                  ' Ensure not EFT locked
      IF TP.EFTOVCtr THEN                                         ' In EFT override mode?
         MErrExit(%eNone, "Command not allowed when current Profile is EFT LOCKED") '
      END IF                                                      '
      RETURN                                                      '
END METHOD                                                        '

METHOD  pCmdPTYPE(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Power Type command                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, lclTop, lccol AS LONG                                 '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         pCmdHelp("H PTYPE"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF FCB.HexMode <> &1 THEN _                                    '
      MErrExit(%eFail, "PowerType not available in Hex mode")     '
   IF gKbdRecFlag THEN _                                          ' Doing a recording?
      MErrExit(%eFail, "PowerType not available during Keyboard recording")   '
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   IF PTBL.FindRngSet OR _                                        ' If a line range
      PTBL.FlgU OR PTBL.FlgNU OR PTBL.FlgX OR PTBL.FlgNX THEN     ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '

   IF ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgALL THEN _      ' Better be something
      MErrExit(%eFail, "Pending line range")                      '

   PTBL.FlgDX = %True                                             ' Tell search hands off Invisible status
   IF PTBL.ColFrom > 0 THEN                                       ' Was a col number entered?
      lccol = PTBL.ColFrom                                        ' Yes, use it
   ELSE                                                           '
      lccol = IIF(IsCData, @P.C.CCol - @P.PGapCol + @P.POffset, 1 + @P.POffset)  ' Calc IX into the Text
   END IF                                                         '
   ErrMsgHigh = %eNone                                            ' Reset any Pending conflict flag
   lclTop = @P.PTopLine: gPTblCount = 0                           '
   RESET Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen  ' Reset 1st found values

   i = me.Search(0, @P.C.CType)                                   ' Do the initial search
   IF i THEN GOSUB TableOne                                       ' Handle it if found
   DO WHILE i                                                     ' Do till not found
      i = me.Search(1, %CNext)                                    ' Do re-Finds
      IF i THEN GOSUB TableOne                                    ' Found one
   LOOP                                                           '
   IF gPTblCount = 0 THEN _                                       '
      MErrExit(%eFail, "No data lines in range")                  '

   IF IsLInvisible(gPTbl(1).tLin) THEN                            ' Is 'model' line visible?
      me.LFlagBitOff(gPTbl(1).tLin, %Invisible)                   ' No, make it visible

      IF LWrk1G(gPTbl(1).tLin) = 1 AND _                          ' If 1st and last in X'd group (i.e. 1 line)
         LWrk1G(gPTbl(1).tLin) = LWrk1G(gPTbl(1).tLin - LWrk1G(gPTbl(1).tLin)) THEN '
         gPTbl(1).tLin = gPTbl(1).tLin - 1                        ' Adjust new location
         FOR j = 2 TO gPTblCount                                  ' Adjust all lower PT entries by -1
            gPTbl(j).tLin = gPTbl(j).tlin - 1                     ' Since the ---- line is disappearing
         NEXT j                                                   '
      ELSEIF LWrk1G(gPTbl(1).tLin) = 1 THEN                       ' Adjust things
         gPTbl(1).tLin = gPTbl(1).tLin - 1                        ' If 1st in X'd range, adjust new location
      ELSEIF LWrk1G(gPTbl(1).tLin) = LWrk1G(gPTbl(1).tLin - LWrk1G(gPTbl(1).tLin)) THEN   '
         '- Nil                                                   ' If last in X'd range
      ELSE                                                        '
         FOR j = 2 TO gPTblCount                                  ' Adjust all lower PT entries by +1 since we
            gPTbl(j).tLin = gPTbl(j).tlin + 1                     ' are adding a new ---- line
         NEXT j                                                   '
      END IF                                                      '
   END IF                                                         '
   me.CurSetReq(%Position, gPTbl(1).tLin, lccol, %True)           ' Set cursor set attempt
   OnPTypeMode                                                    ' Set into PType mode now
   MErrExit(%eNone, "Entering PowerType mode, Press Enter to exit")  '

TableOne:                                                         '
   j = PTBL.FoundLine                                             ' Get the located line number
   IF IsLData(j) THEN                                             ' Only data lines of course
      INCR gPTblCount                                             ' Add to PT Table
      IF gPTblCount > UBOUND(gPTbl()) THEN _                      ' Table full
         REDIM PRESERVE gPTbl(1 TO 2 * UBOUND(gPTbl())) AS PTypeTable   ' Enlarge if needed
      gPTbl(gPTblCount).tLin = j                                  ' Save Txt line number
      gPTbl(gPTblCount).sRow = 0                                  ' Say no screen row
   END IF                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdRCHANGE(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- RCHANGE router, figure out to which command this needs to be passed                               |
'-                 pCmd can be NULL, "REVERSE/REV", or a full Command                                |
'--------------------------------------------------------------------------------------------------+
LOCAL t, lCmd, ROps() AS STRING, i, RevNum, ROpsNum AS LONG       '
   MEntry                                                         '
   DIM ROps(1 TO 100) AS STRING                                   ' Temp operand holder
   lCmd = TRIM$(pCmd)                                             ' Get a trimmed version
   '--------------------------------------------------------------------------------------------------+
   '- Figure out if REVERSE/REV are present and remove them and process them                          |
   '--------------------------------------------------------------------------------------------------+
   IF ISNOTNULL(lCmd) THEN                                        ' Break it down
      DO WHILE ISNOTNULL(TRIM$(lCmd))                             '
         INCR ROpsNum                                             '
         ROps(ROpsNum) = GetNextWord(lCmd, %Strip)                '
         IF IsEQ(ROps(ROpsNum), "REVERSE") OR IsEQ(ROps(ROpsNum), "REV") THEN '
            RevNum = ROpsNum                                      ' Save REVERSE Kwd position
            PTBL.Reverse                                          ' Reverse PTBL parameters
         END IF                                                   '
      LOOP                                                        '
      FOR i = 1 TO ROpsNum                                        ' Rebuild lCmd without REVERSE
         IF i <> RevNum THEN lCmd += ROps(i) + " "                '
      NEXT i                                                      '
      IF RevNum THEN DECR ROpsNum                                 ' Adjust ROpsNum
   END IF                                                         '
   IF ROpsNum = 1 AND UCASE$(ROps(1)) = "RCHANGE" THEN ROpsNum = 0   ' If just RCHANGE, then remove it
   '--------------------------------------------------------------------------------------------------+
   '- Now do the routing                                                                              |
   '--------------------------------------------------------------------------------------------------+
   IF ROpsNum = 0 THEN                                            ' No operands
      SELECT CASE AS CONST$ LocFind                               ' Split by what action was last
         CASE "CHANGE", ""                                        '
            pCmdChange("CHANGER RCHNG")                           '
         CASE "DELETE"                                            '
            pCmdDelete("DELETER RCHNG")                           '
         CASE "SPLIT"                                             '
            pCmdSplit("SPLITR RCHNG")                             '
         CASE "JOIN"                                              '
            pCmdJoin("JOINR RCHNG")                               '
         CASE ELSE                                                ' ????
            MErrExit(%eFail, "No prior command to repeat")        '
      END SELECT                                                  '

   ELSE                                                           ' There are other operands. (RCHANGE SPLIT ...)
      t = UCASE$(GetNextWord(lCmd, %Strip))                       ' Remove RCHANGE
      t = UCASE$(GetNextWord(lCmd, %NoStrip))                     ' Peek at next word (the command)
      SELECT CASE AS CONST$ t                                     ' Split by the command name
         CASE "CHANGE", "C", "CHG", "CHA"                         '
            pCmdChange(lCmd + " RCHNG")                           '
         CASE "DELETE", "DEL"                                     '
            pCmdDelete(lCmd + " RCHNG")                           '
         CASE "SPLIT"                                             '
            pCmdSplit(lCmd + " RCHNG")                            '
         CASE "JOIN"                                              '
            pCmdJoin(lCmd + " RCHNG")                             '
         CASE ELSE                                                '
            MErrExit(%eFail, "Illegal command for RCHANGE usage") '
      END SELECT                                                  '
   END IF                                                         '
   Mexit                                                          '
END METHOD                                                        '

METHOD PCmdRECALL(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- RECALL in Normal Mode                                                                           |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   GoToTab(1, "", pCmd)                                           ' Pass command to the FM tab
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRECFM(pCmd AS STRING)                                 '
LOCAL EO, MSG AS STRING                                           '
   MEntry                                                         '
   MSG = "DCB is set to: "                                        ' Start building MSG
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO FormatMsg, _                                        ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   pCmdDCB("DCB " + pCmd)                                         ' Insert DCB and pass it on
   MExitMeth                                                      '

   FormatMsg:                                                     '
   EO = FCB.EOL                                                   ' Format EOL
   IF VERIFY(EO, $Hex) = 0 THEN EO = "X'" + EO + "'"              ' IF hex operand, FRAME it for the message
   DoProfMsg(MSG + "RECFM=" + FCB.RECFM + ", LRECL=" + FORMAT$(FCB.LRECL) + ", EOL=" + EO )  ' Issue message
   DoStatusBar($SBEOL)                                            ' re-Do the StatusBar EOL box
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRELOAD(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Re-Load the current file                                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, lclMode AS LONG, NewCmd, macname AS STRING            '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H RELOAD"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsClip OR IsSetEdit OR IsEFTEdit THEN MErrExit(%eFail,"ReLoad allowed in Edit/Browse/View mode only") ' Issue error message
   IF FCB.FilePath = $New THEN MErrExit(%eFail,"(New) files can't be reloaded")  ' Issue ERROR message
   HPanelSplit = 0: VPanelSplit = 0                               ' ReSet split point
   P = VARPTR(P1)                                                 ' Point at default P1 after any PANEL cmd
   P1.PTopLine = 1                                                ' Set Panel Topscreen Line
   P1.POffSet = 0                                                 '  "    "   POffset
   P1.PCOffSet = 0                                                '  "    "   PCOffset
   me.PanelSet(1, 1, gENV.ScrHeight - gENV.PFKShow, 1, gENV.ScrWidth, "N", %True)
   IF ISFALSE IsMEdit THEN                                        ' Simple non MEdit session?
      IF IsModdFlag THEN                                          ' Yes, was data modified?
         i = DoMessageBox("RELOAD will discard all your current changes." + $CRLF + _  '
                          "Do you want to continue?", %MB_YESNO + %MB_USERICON, "SPFLite")   '
         IF i = %IDNO THEN MExitMeth                              '
      END IF                                                      '

      lclMode = TP.TabMode                                        ' Get current mode
      me.Init(%False)                                             ' Kill any PANEL mode

      me.UnWatchQueue("")                                         ' Kill Watch and dequeue it
      me.ResetFunc(%ResetCommand)                                 ' Kill Command line pendings
      PTBL.PTBLReset                                              ' Reset criteria
      me.LInitTxtData()                                           ' Wipe everything out then
      me.InitaFile(%False)                                        ' Go load it in
      me.UndoSave()                                               ' Take an initial one
      FCB.TimeDateRefresh                                         ' Get refreshed Date/Time
      TP.TabMode = lclMode                                        ' Set back mode
      me.WindowTitle                                              ' Alter window/Tab titles
      IF TP.FCB_.IMacro <> "" THEN                                ' Is there an IMacro?
         macname = TP.FCB_.IMacro                                 ' Get macro string
         IF UCASE$(macname) = macname THEN                        ' Is macroname Uppercase?  (ON)
            IF isMacro(macname) THEN                              '
               me.pCmdMacro(macname)                              ' Then go do it
            ELSE                                                  '
               MErrExit(%eFail, "IMACRO - " + macname + " not found")   ' Issue error
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      GOTO DoExit                                                 ' Put focus back on main window
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Do things the MEdit way                                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF IsModdFlag THEN                                             ' Yes, was data modified?
      i = DoMessageBox("RELOAD will lose all your current changes" + $CRLF + _   '
                      "in |KALL|B the loaded files." + $CRLF + _  '
                      "Do you want to continue?", %MB_YESNO + %MB_USERICON, "SPFLite") '
      IF i = %IDNO THEN MExitMeth                                 '
   END IF                                                         '
   NewCmd = "MEDIT "                                              ' Start NewCmd
   FOR j = 1 TO MEditCount                                        ' Build a MEdit command to reload things
      NewCmd += $DQ + me.MEditListGet(j) + $DQ + " "              '
      me.UnWatchQueue(me.MEditListGet(j))                         ' Kill Watch and dequeue it
   NEXT j                                                         '
   me.LInitTxtData()                                              ' Wipe everything out then
   pCmdMEDIT(NewCmd)                                              ' Let MEdit do the work
   DoExit:                                                        '
      CaretDestroy                                                '
      CaretCreate                                                 ' Create it
      DoCursor                                                    ' Position it
      CaretShow                                                   ' Show the caret
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRENAME(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Rename the current file                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, FNum AS LONG, RCA AS RCArea                           '
LOCAL lclPath, lclDrive, RenDrive, RenPath, BaseName, DelFN, RenFn, fn, LErrMsg, lclOldState, lclNewState AS STRING  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H RENAME"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsClip OR IsSetEdit OR IsEFTEdit OR IsMEdit OR XFormActive <> "" THEN _ ' Not CLIP, EFT, SETEDit or MEdit mode
      MErrExit(%eFail,"Rename invalid in CLIP/Set Edit/XForm/Multi-Edit mode")   ' Issue error message
   RenFn = IIF$(PTBL.OpsNum = 0, "", PTBL.Pos2(1))                ' Get filename if present
   BaseName = FCB.FilePath                                        '
   lclPath = CURDIR$                                              ' Get current path
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save it

   RenPath = FCB.Path                                             ' Build Path
   IF MID$(RenPath, 2, 1) = ":" THEN                              ' Extract Drive if present
      RenDrive = LEFT$(RenPath, 2)                                ' and save it
      RenPath = MID$(RenPath, 3)                                  '
   END IF                                                         '

   DelFn = FCB.File                                               ' Get file Name

   '-----------------------------------------------------------------------------------------------+
   '- If no name provided on the command, prompt for one                                           |
   '-----------------------------------------------------------------------------------------------+
   IF ISNULL(RenFn) THEN                                          ' Got a new name?
      RenFn = DoInputBox("Enter the new FileName: ", "Rename", RTRIM$(DelFn)) '
      IF ISNULL(RenFn) OR IsEQ(RenFn, RTRIM$(DelFn)) THEN MErrExit(%eNone, "Rename cancelled")  '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Ensure it's not in use elsewhere                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF VAL(FileQueue("S", " ", RenDrive + RenPath + RenFn)) > 0 THEN _   ' Open in some tab?
     MErrExit(%eFail,"File open elsewhere: " + Renfn)             '

   '-----------------------------------------------------------------------------------------------+
   '- Do the rename now                                                                            |
   '-----------------------------------------------------------------------------------------------+

   '-----------------------------------------------------------------------------------------------+
   '- First save STATE names if they exist                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF IsStateExist THEN                                           ' Does STATE even exist?
      lclOldState = RenDrive + RenPath + DelFN + ".STATE"         ' Build the STATE filename
      REPLACE ANY ":\/" WITH "```" IN lclOldState                 ' Make : / and \ into `
      lclOldState = gENV.HomeData + "STATE\" + lclOldState        ' Add our STATE folder
      IF ISFALSE ISFILE(lclOldState) THEN lclOldState = ""        ' Kill it if no STATE file
      lclNewState = RenDrive + Renpath + RenFn + ".STATE"         ' Build the new STATE filename
      REPLACE ANY ":\/" WITH "```" IN lclNewState                 ' Make : / and \ into `
      lclNewState = gENV.HomeData + "STATE\" + lclNewState        ' Add our STATE folder
      IF ISFILE(lclNewState) THEN lclOldState = ""                ' Kill it if no STATE file
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Continue with the file rename                                                                |
   '-----------------------------------------------------------------------------------------------+
   IF lclDrive <> RenDrive THEN CHDRIVE RenDrive                  '
   CHDIR RenPath                                                  '
   i = me.FileWatch("", %WatchEnd)                                ' Kill any prior Watch
   IF TRIM$(DelFn) <> "" AND DelFN <> $New THEN NAME DelFn AS RenFn  ' Do the rename
   LErrMsg = ""                                                   '
   IF ERR = %ERR_FILENOTFOUND THEN                                '
      LErrMsg = "File no longer found??"                          '
   ELSEIF ERR = %ERR_FILEALREADYEXISTS THEN                       '
      LErrMsg = "File already exists."                            '
   ELSEIF ERR = %ERR_PERMISSIONDENIED THEN                        '
      LErrMsg = "File is Read Only."                              '
   ELSEIF ERR = %ERR_PATHFILEACCESSERROR THEN                     '
      LErrMsg = "Path/File Access error."                         '
   ELSEIF ERR <> 0 THEN                                           '
      LErrMsg = "UnKnown Error - Err: " + FORMAT$(ERR)            '
   END IF                                                         '
   IF ISNOTNULL(LErrMsg) THEN _                                   ' Any error?
      MErrExit(%eFail, "Rename failed, " + LErrMsg)               '
   MacWarn = 0                                                    ' Ensure MacOverlap issues a message
   me.MacOverlap(BUILD$(RenDrive, Renpath, RenFN))                ' Warn if Macro/command overlap
   FileListRename(RenDrive + Renpath + DelFN, RenDrive + Renpath + RenFn)  ' Go adjust FILELIST entries

   TP.ErrMsgAdd(0, IIF$(ISNULL(DelFn), "File Saved", "Rename complete"))   '
   fn = RenDrive + RenPath + RenFn                                ' Get a full filename

   IF RenDrive <> lclDrive THEN CHDRIVE lclDrive                  ' Switch drive if needed
   CHDIR lclPath                                                  ' put back the original path

   FCB.SetupFN(fn, %ProfGetY, RCA)                                ' Alter FCB
   me.WindowTitle                                                 ' Alter window/Tab titles

   OnModdFlag                                                     ' Set (M)
   me.ClrLoad()                                                   ' Go load Colorize data
   IF lclOldState <> "" THEN                                      ' Doing STATE rename?
      NAME lclOldState AS lclNewState                             ' Yes, do it
   END IF                                                         '

   IF ISNULL(DelFn) OR DelFn = $New THEN                          ' If renaming (New)
      MakeNullFile(FCB.FilePath)                                  ' Create null file
      FCB.SetupFN(FCB.FilePath, %ProfGetY, RCA)                   ' Setup for write
      me.WriteFile(%False, "A")                                   ' Go Write the file with (ALL)
      OffModdFlag                                                 '
   END IF                                                         '

   FileQueue("A", " ", FCB.FilePath)                              ' Establish the watch
   IF me.FileWatch(TP.FCB_.FilePath, %WatchStart) THEN _          '
      TP.ErrMsgAdd(0, "File watch could not be established")      '
   IF FCB.AutoBkup THEN me.PcmdBACKUP("BACKUP ")                  ' If AutoBKUP then Backup the new guy
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdREPLACE(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- SAVE data to a specified filename, pass off to CREATE to do it                                  |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H REPLACE"), _                                 ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   pCmdCREATE("REPSWAP " + pCmd)                                  ' Insert REPSWAP and pass it on
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRESET(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Do a RESET Command                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL lclTop, i, j, Requests AS LONG                              '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         pCmdHelp("H RESET"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   lcltop = @P.PTopLine                                           ' Save where we are
   ResetClr = 0                                                   ' Clear color to be reset
   IF PTBL.OpsNum = 0 THEN                                        ' If no operands
      Requests = %ResetAll - %ResetRetrieve - %ResetLabel - %ResetTag - _  '
                 %ResetCommand - %ResetWord - %ResetHide - %ResetSource - %ResetTrack  '
      IF ISFALSE gENV.ResetU THEN requests -= %ResetUser          ' If not clearing User, then remove it's flag
      me.ResetFunc(Requests)                                      ' Go do the default set
      OffSlecSet                                                  ' Clear Slec status
      OffSlecActive                                               '
      me.MarkKill                                                 ' Kill marked areas
      me.SwapKill                                                 '
      IF ISFALSE gMacroMode THEN                                  '
         DoStatusBar($SBSelect)                                   ' Re-Do the StatusBar Select box
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   IF PTBL.OpsNum = 1 AND PTBL.IsKwd("ALL") THEN                  ' 1 operand? and ALL?
      Requests = %ResetAll - %ResetRetrieve - %ResetWord - %ResetHide - %ResetSource   ' ALL except a few
      me.ResetFunc(Requests)                                      ' Go do the set
      OffSlecSet                                                  ' Clear Slec status
      OffSlecActive                                               '
      IF ISFALSE gMacroMode THEN                                  '
         DoStatusBar($SBSelect)                                   ' re-Do the StatusBar Select box
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   IF PTBL.IsKwd("CHANGE")    THEN Requests = Requests OR %ResetChange  '
   IF PTBL.IsKwd("COMMAND")   THEN Requests = Requests OR %ResetCommandK   '
   IF PTBL.IsKwd("EXCLUDED")  THEN Requests = Requests OR %ResetExcluded   '
   IF PTBL.IsKwd("USER")      THEN Requests = Requests OR %ResetUser '
   IF PTBL.IsKwd("TAGS")      THEN Requests = Requests OR %ResetTag  '
   IF PTBL.IsKwd("LABEL")     THEN Requests = Requests OR %ResetLabel   '
   IF PTBL.IsKwd("HANDLE")    THEN Requests = Requests OR %ResetHandle  '
   IF PTBL.IsKwd("SPECIAL")   THEN Requests = Requests OR %ResetSpecial '
   IF PTBL.IsKwd("RETRIEVE")  THEN Requests = Requests OR %ResetRetrieve   '
   IF PTBL.IsKwd("FIND")      THEN Requests = Requests OR %ResetFind '
   IF PTBL.IsKwd("STD")       THEN Requests = Requests OR %ResetClr     : ResetClr = -1   '
   IF PTBL.IsKwd("COLOR")     THEN Requests = Requests OR %ResetClr     : ResetClr = -1   '
   IF PTBL.IsKwd("COLOUR")    THEN Requests = Requests OR %ResetClr     : ResetClr = -1   '
   IF PTBL.IsKwd("STATE")     THEN Requests = Requests OR (%ResetLabel OR %ResetTag OR %ResetExcluded)   '
   IF PTBL.IsKwd("HIDE")      THEN Requests = Requests OR %ResetHide '
   IF PTBL.IsKwd("WORD")      THEN Requests = Requests OR %ResetWord '
   IF PTBL.IsKwd("SOURCE")    THEN Requests = Requests OR %ResetSource  '
   IF PTBL.FlgHiClr           THEN Requests = Requests OR %ResetClr: ResetClr = PTBL.HiLiteSrch '
   IF Requests <> 0 THEN me.ResetFunc(Requests)                   ' Ask sResetFunc to do the specified work
   PTBL.PTBLReset                                                 ' Ensure default range of ALL before exit
   OnUndoFlag                                                     ' Remember we changed something
   @P.PTopLine = lclTop                                           ' Go back to where we were
   ErrMsgHigh = %eNone                                            ' Say we 're OK
   TP.ErrMsgAdd(0, "")                                            ' Reset error flag and message
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRETFWD(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Retrieve the oldest command line                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL cmd AS STRING, ix AS LONG                                   '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H RETF"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   cmd = gRtr.GetPrev                                             ' Get a reverse entry
   IF ISNULL(Cmd) THEN _                                          ' Exit if nothing here
      MErrExit(%eNone, "No (more) RETRIEVE commands available")   '
   pCommand = Cmd                                                 '
   @P.PCOffset = 0                                                ' Remove Offset
   ErrMsgHigh = %eRetrieve                                        '
   sCurPrio = 0                                                   ' Reset cursor requests
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRETRIEVE(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Retrieve the last command line                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL cmd AS STRING, ix AS LONG                                   '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H RETRIEVE"), _                                ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsEQ(PTBL.Ops(0), "CRETRIEV") THEN                          ' Is this the CRETRIEV version?
      IF ISFALSE IsCCmnd THEN                                     ' If not in the Command area
         pCommand = "": @P.PCOffset = 0                           ' Clear cmd
         SetCmd                                                   ' Cursor to Cmd line
         MExitMeth                                                ' That's all
      END IF                                                      '
   END IF                                                         ' Else it's a RETRIEVE effectively
   pCommand = ""                                                  '
   cmd = gRtr.GetNext                                             ' Retrieve a command
   IF ISNULL(cmd) THEN _                                          ' Nothing?
      MErrExit(%eFail, "No (more) RETRIEVE commands available")   '
   pCommand = Cmd                                                 '
   @P.PCOffset = 0                                                ' Remove Offset
   ErrMsgHigh = %eRetrieve                                        '
   sCurPrio = 0                                                   ' Reset cursor requests
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRFIND(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- RFIND router, figure out to which command this needs to be passed                               |
'-               pCmd can be NULL, "REVERSE/REV", or a full Command                                |
'--------------------------------------------------------------------------------------------------+
LOCAL t, lCmd, ROps() AS STRING, i, RevNum, ROpsNum, UndoRev AS LONG '
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   DIM ROps(1 TO 100) AS STRING                                   ' Temp operand holder
   lCmd = TRIM$(pCmd)                                             ' Get a trimmed version
   t = UUCASE(GetNextWord(lCmd, %NoStrip))                        ' Peel off RFIND
   IF t = "RFIND" THEN t = GetNextWord(lCmd, %Strip)              ' If it's the 1st word
   '--------------------------------------------------------------------------------------------------+
   '- Figure out if REVERSE/REV are present and remove them and process them                          |
   '--------------------------------------------------------------------------------------------------+
   IF ISNOTNULL(lCmd) THEN                                        ' Break it down
      DO WHILE ISNOTNULL(TRIM$(lCmd))                             '
         INCR ROpsNum                                             '
         ROps(ROpsNum) = GetNextWord(lCmd, %Strip)                '
         IF IsEQ(ROps(ROpsNum), "REVERSE") OR IsEQ(ROps(ROpsNum), "REV") THEN '
            RevNum = ROpsNum                                      ' Save REVERSE position
            PTBL.Reverse                                          ' Reverse PTBL parameters
            UndoRev = %True                                       ' Remember to UNDO the reverse
         END IF                                                   '
      LOOP                                                        '
      FOR i = 1 TO ROpsNum                                        ' Rebuild lCmd without REVERSE
         IF i <> RevNum THEN lCmd += ROps(i) + " "                '
      NEXT i                                                      '
      IF RevNum THEN DECR ROpsNum                                 ' Adjust ROpsNum
   END IF                                                         '
   '--------------------------------------------------------------------------------------------------+
   '- Now do the routing                                                                              |
   '--------------------------------------------------------------------------------------------------+
   IF ROpsNum = 0 THEN                                            ' No operands
      SELECT CASE AS CONST$ LocFind                               ' Split by what action was last
         CASE "FIND"                                              '
            pCmdFind("FINDR RSRCH")                               '
         CASE "CHANGE"                                            '
            pCmdCHANGE("CHANGER RSRCH")                           '
         CASE "NFIND"                                             '
            pCmdNFind("NFINDR RSRCH")                             '
         CASE "DELETE"                                            '
            pCmdDelete("DELETER RSRCH")                           '
         CASE "SPLIT"                                             '
            pCmdSplit("SPLITR RSRCH")                             '
         CASE "JOIN"                                              '
            pCmdJoin("JOINR RSRCH")                               '
         CASE ELSE                                                ' ????
            IF UndoRev THEN PTBL.Reverse                          ' Just in case
            MErrExit(%eFail, "No prior command to repeat")        '
      END SELECT                                                  '

   ELSE                                                           ' There are other operands. (RFIND CHANGE ...)
      t = UCASE$(GetNextWord(lCmd, %NoStrip))                     ' Peek at the next word (the command)
      SELECT CASE AS CONST$ t                                     ' Split by the command name
         CASE "FIND", "F", "RFIND"                                '
            pCmdFind(lCmd + " RSRCH")                             '
         CASE "NFIND", "NF"                                       '
            pCmdNFind(lCmd + " RSRCH")                            '
         CASE "CHANGE", "C", "CHG", "CHA"                         '
            pCmdChange(lCmd + " RSRCH")                           '
         CASE "DELETE", "DEL"                                     '
            pCmdDelete(lCmd + " RSRCH")                           '
         CASE "SPLIT"                                             '
            pCmdSplit(lCmd + " RSRCH")                            '
         CASE "JOIN"                                              '
            pCmdJoin(lCmd + " RSRCH")                             '
         CASE ELSE                                                '
            IF UndoRev THEN PTBL.Reverse                          ' Just in case
            MErrExit(%eFail, "Illegal command for RFIND usage")   '
      END SELECT                                                  '
   END IF                                                         '
   IF UndoRev THEN PTBL.Reverse                                   ' Undo REVERSE now to go back to normal
   Mexit                                                          '
END METHOD                                                        '

METHOD  pCmdRIGHT(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Scroll RIGHT                                                                                    |
'--------------------------------------------------------------------------------------------------+
DIM ScrAmt AS LONG, ScrCmd AS STRING, DataIX AS LONG              '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H RIGHT"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum > 1 THEN _                                      ' Better be just one operand
      MErrExit(%eFail, "Invalid scroll amount")                   '
   IF PTBL.OpsNum = 0 THEN                                        ' No Ops, fudge it
      ScrCmd = FCB.ScrollAmt                                      ' Pick up Profile value
   ELSE                                                           '
      ScrCmd = PTBL.Grp("SCROLL")                                 ' Else pick up from command
      IF ISNULL(ScrCmd) THEN ScrCmd = PTBL.Pos("#", 1)            ' If not Kwd, then fetch the #
   END IF                                                         '

   IF VAL(ScrCmd) <> 0 THEN                                       ' A Number?
      ScrAmt = VAL(ScrCmd)                                        ' Yes, use it
   ELSEIF ScrCmd = "HALF" THEN                                    ' Half?
      ScrAmt = INT(@P.PDataLen / 2)                               ' Yes, set it
   ELSEIF ScrCmd = "PAGE" THEN                                    ' Page?
      ScrAmt = @P.PDataLen                                        ' Yes, set it
   ELSEIF ScrCmd = "FULL" THEN                                    ' Full?
      ScrAmt = @P.PDataLen                                        ' Yes, set it
   ELSEIF ScrCmd = "DATA" THEN                                    ' Data?
      ScrAmt = @P.PDataLen - 1                                    ' Yes, set it
   ELSEIF ScrCmd = "MAX" THEN                                     ' Max?
      IF MaxLength < @P.PDataLen THEN                             ' Everything fit on the screen?
         ScrAmt = 0                                               ' Don't move
      ELSE                                                        '
         ScrAmt = (MaxLength - @P.PDataLen) - @P.POffset          ' Yes, set Incr amount
      END IF                                                      '
   ELSEIF IsCData THEN                                            ' No, In data area?
      ScrAmt = @P.C.CCol - @P.PDataCol                            ' Yes, move cursor to left of screen
      IF ScrAmt = 0 THEN                                          ' If already there go a default amount
         ScrAmt = @P.PDataLen - 1                                 '
         me.CurSetReq(%Position, DataIX, @P.C.CCol - @P.PGapCol + @P.POffset + ScrAmt, %False)  '
      END IF                                                      '
   ELSEIF IsCLinN THEN                                            ' Line number area
      DataIX = me.SGet(@P.C.CRow)                                 ' Locate data line cursor was on
      ScrAmt = @P.PDataLen - 1                                    ' Scroll width of screen
   ELSE                                                           '
      ScrAmt = @P.PDataLen - 1                                    ' Scroll width of screen
   END IF                                                         '
   me.OffsetAdd(ScrAmt)                                           '
   ErrMsgHigh = %eNone                                            ' Say we 're OK
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRLOC(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- RLOC Command                                                                                    |
'--------------------------------------------------------------------------------------------------+
LOCAL llastline, lastcol, RevOnce AS LONG                         '
   MEntry                                                         '
   IF LocLine = 0 OR LocFlag = 0 THEN _                           ' A previous LOCATE?
      MErrExit(%eFail, "No previous LOCATE")                      ' No? Too bad
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H RLOC"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 1 AND PTBL.IsKwd("REVERSE") THEN              ' Is this the simple REVERSE?
      OnRevOnce: RevOnce = %True                                  ' Reverse just once, remember it locally
      PTBL.OpsNum = 0                                             ' Pretend there are no operands now
   END IF                                                         '
   IF IsCData THEN                                                ' In the Data Area
      llastline = me.SGet(@P.C.CRow)                              ' Save line the cursor is on
      lastcol = @P.C.CCol - @P.PGapCol + @P.POffset + 1           ' Calc column position in line
   END IF                                                         '
   IF IsCLinn THEN                                                ' In the Line Area
      llastline  = me.SGet(@P.C.CRow): lastcol = 0                ' Swap in current cursor location
   END IF                                                         '
   LocFind = "LOCATE"                                             ' Remember what Loc / FIND command was last
   IF ISFALSE me.LocSearch() THEN                                 ' Go do the full type search
      IF RevOnce THEN                                             ' Get the right message
         TP.ErrMsgAdd(nMac(%eFail), IIF$(locDir = 1, "Top of data reached", "Bottom of data reached"))   '
         LocNotFound = IIF(locDir = 1, 1, 2): SetCmd: llastline = 0  '
      ELSE                                                        '
         TP.ErrMsgAdd(nMac(%eFail), IIF$(locDir = 1, "Bottom of data reached", "Top of data reached"))   '
         LocNotFound = IIF(locDir = 1, 2, 1): SetCmd: llastline = 0  '           1 = last 2 = first
      END IF                                                      '
      IF llastline <> 0 THEN _                                    ' A saved cursor location?
         me.CurSetReq(%Find, llastline, lastcol, %False, %False)  ' Set cursor
   ELSE                                                           '
      IF IsMEdit AND IsLfFile THEN                                ' A MEdit LOC FILE command?
         TP.ErrMsgAdd(%eNone, "File " + FORMAT$(LMIXG(LocLineLstR)) + " of " + FORMAT$(MEditCount) + " found") '
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRLOCFIND(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- RLOCFIND Command                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL t AS STRING                                                 '
   MEntry                                                         '
   t = UUCASE(GetNextWord(pCmd, %Strip))                          ' Peel off RLOCFIND
   '-----------------------------------------------------------------------------------------------+
   '- If previous LOCATE, eliminate it first                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF LocFind = "LOCATE" THEN pCmdRLOC("RLOC " + pCmd): MExitMeth ' Treat as RLOC
   '-----------------------------------------------------------------------------------------------+
   '- Pass off all others to the RFIND router code                                                 |
   '-----------------------------------------------------------------------------------------------+
   pCmdRFind(pCmd)                                                ' pCmd is NULL, "REVERSE" or a full command
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdRUN(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Run the current file (assumed to be a script)                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL operands, t AS STRING                                       '
LOCAL i, lcltop, FNum AS LONG                                     '
LOCAL recs AS LONG                                                '
LOCAL lclDrive, lclPath, lclBase, lclExtn AS STRING               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Basic parse
         PCmdHelp("H RUN"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsClip OR FCB.FilePath = $New THEN                          ' CLIP or (New) file?
      lclExtn = ".BAT"                                            ' Set default extension
      lclBase = IIF$(FCB.FilePath = $New, "New", "CLIP")          ' Set lclBase
   ELSEIF IsSetEdit OR _                                          ' SetEdit?
      IsEFTEdit OR _                                              ' EFTEdit?
      IsBrowse OR _                                               ' Browsing?
      IsView OR _                                                 ' Viewing?
      IsMedit OR _                                                ' MEdit?
      FCB.FilePath = $New THEN                                    ' (New) file?
      MErrExit(%eFail, "Not a suitable Edit session for RUN")     ' Say sorry
   END IF                                                         '
   lclTop = @P.PTopLine                                           ' Save where we are
   @P.PTopLine = 1                                                ' Ensure we're at the top

   '-----------------------------------------------------------------------------------------------+
   '- Get remaining command operands                                                               |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum > 0 THEN                                        ' Any operands?
      FOR i = 1 TO PTBL.OpsNum                                    ' Process them
         IF LEFT$(PTBL.Ops(i), 1) = "." THEN                      ' A Profile name?
            lclExtn = PTBL.Ops(i)                                 ' Get any provided Profile name
         ELSE                                                     ' Else stack it as an operand
            operands += PTBL.Ops(i) + " "                         '
         END IF                                                   '
      NEXT i                                                      '
   END IF                                                         '
   IF ISNULL(lclExtn) AND FCB.Extn = "" THEN _                    ' Still no extension?
      MErrExit(%eFail, "Not a suitable Edit session for RUN")     ' Say sorry
   IF ISNULL(lclExtn) THEN lclExtn = FCB.Extn                     ' Make sure something is in lclExtn

   lclBase = IIF$(lclBase = "", FCB.Base, lclBase)                '
   PTBL.PTBLReset                                                 ' Set parse search output fields for ALL

   i = me.Search(0, @P.C.CType)                                   ' Do the initial search
   IF i THEN                                                      ' We have the 1st RUN line
      '--------------------------------------------------------------------------------------------+
      '- Ready the output file                                                                     |
      '--------------------------------------------------------------------------------------------+
      FNum = FREEFILE                                             ' Get a file number
      Call3(TryOpenOutPut(gENV.HomeData + "RUN\" + lclBase + lclExtn, FNum), _ ' Try the open
            MErrExit(%eFail, "File Write Open failed"), _         ' Oops?  Bail out
            MErrExit(%eFail, "Output File is in use"), _          ' Oops?  Bail out
            Nul)                                                  ' Continue
      GOSUB PutOne                                                ' Go handle one
   END IF                                                         '
   DO WHILE i                                                     ' Do till not found
      i = me.Search(1, %CNext)                                    ' Do re-Finds
      IF i THEN GOSUB PutOne                                      ' Found one
   LOOP                                                           '
   CLOSE # FNum                                                   ' Close the file

'-  debug DCmd
   '-----------------------------------------------------------------------------------------------+
   '- Switch to the EXE path                                                                       |
   '-----------------------------------------------------------------------------------------------+
   lclPath = CURDIR$                                              ' Locate where we are
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save it
   CHDIR TRIM$(gENV.HomeData + "RUN\")                            ' Switch to RUN path

   '-----------------------------------------------------------------------------------------------+
   '- Fire it up                                                                                   |
   '-----------------------------------------------------------------------------------------------+
   gLoopCtr = -1                                                  ' Suspend loop detection
   t = ENVIRON$("COMSPEC") + " " + gENV.RunFlags + " " + $DQ + gENV.HomeData + "RUN\" + lclBase + lclExtn + $DQ + " " + operands  '
   SHELL t, 1                                                     '
   RESET gLoopCtr                                                 ' Reset the counter

   '-----------------------------------------------------------------------------------------------+
   '- Restore PATH                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(lclDrive) THEN CHDRIVE lclDrive                   ' Switch drive if needed
   CHDIR lclPath                                                  ' put back the original path
   @P.PTopLine = lcltop                                           ' Put back TopScrn
   MExitMeth                                                      '

PutOne:                                                           '
   PRINT # FNum, LTxtG(PTBL.FoundLine)                            ' Write line to RUN file
   INCR recs                                                      ' count it
   RETURN                                                         '

END METHOD                                                        '

METHOD  pCmdSAVE(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- SAVE to OrigName                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, FNum, lclTop, fcount, fline, tline, MOnly, MCount, MEditFLine, Quiet AS LONG, RCA AS RCArea  '
LOCAL BKPName, fn, lclDir, lclFile, lclExtn, lclProfName, t, u, CBD, macname, Stamp, PDiag AS STRING  '
DIM fnlist() AS STRING, FD AS DIRDATA, filesize AS QUAD           '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H SAVE"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsSetEdit OR IsEftEdit THEN _                               ' Eliminate some sessions
      MErrExit(%eNone, "SAVE is unnecessary, END will commit changes, or use CANCEL")  ' Tell user
   MOnly = PTBL.IsKwd("COND")                                     ' Get optional flags
   Quiet = PTBL.IsKwd("QUIET")                                    ' Get optional flags
   lclTop = @P.PTopLine                                           ' Save where we are
   IF IsBrowse OR IsView THEN MErrExit(%eFail, "SAVE disallowed, you're in BROWSE/VIEW Mode, use CREATE")   '
   '-----------------------------------------------------------------------------------------------+
   '- See if a named CLIP session                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF IsClip THEN                                                 ' CLIP session?
      gKeyPrimOper = IIF$(ISNOTNULL(ClipName), ClipName, "")      ' Set possible clipboardname
      IF LEFT$(ClipName, 1) <> "_" THEN                           ' And not a temp CB name
         IF FCB.AutoBkup AND IsModdFlag AND ISFALSE IsBackupDone THEN   ' Need to create BKP file?
            DoBackup("!" + ClipFile, TP.TabMode, RCA)             ' Go try it and get message result
            IF RCA.RC > 4 THEN                                    ' Failure?
               TP.ErrMsgAdd(%eFail, "Failed to create BACKUP of CLIP file")   ' Error msg
            END IF                                                '
         END IF                                                   '
      END IF                                                      '
      FOR i = 1 TO LastLine                                       ' Capture all the lines
         IF IsLData(i) AND ISFALSE IsLInsertLine(i) THEN          ' All Data but not Insert lines                                                  ' Get the located line number
            CBD += LTxtG(i) + $CRLF                               ' Build clipboard string
         END IF                                                   '
      NEXT i                                                      '
      IF ISTRUE ClipboardWrite(CBD) THEN                          ' OK?
         TP.ErrMsgAdd(%eNone, "Saved to " + IIF$(ISNULL(ClipName), "Windows Clipboard", "Clipboard: " + ClipName))   '
         OffModdFlag                                              ' Remove MOD flag
         MexitMeth                                                '
      END IF                                                      '
   END IF                                                         '

   IF FCB.FilePath = $New THEN pCmdSAVEAS("SAVEAS"): MExitMeth    ' Pass odd-ball ones to SAVEAS                                                   '

   fcount = IIF(IsMedit, MAX(1, MEditCount), 1)                   ' Set number of files to save (possibly)
   REDIM fnlist(fcount) AS STRING                                 '
   Stamp = "." + RIGHT$(DATE$, 2) + LEFT$(DATE$, 2) + MID$(DATE$, 4, 2) + "." + LEFT$(TIME$, 2) + MID$(TIME$, 4,2)   '
   IF ISFALSE IsMEdit THEN                                        ' Build the list
      fnlist(1) = FCB.FilePath                                    ' Build full name
      IF gTerminateInProgress THEN                                ' Fiddle name
          fnlist(1) = FCB.Path + FCB.Base + Stamp + ".CrashSave" + FCB.Extn   '
      END IF                                                      '
   ELSE                                                           '
      FOR i = 1 TO fcount                                         '
         fnlist(i) = me.MEditListGet(i)                           ' Build full name from MEdit list
         IF gTerminateInProgress THEN                             ' Fiddle name
            t = LEFT$(fnlist(i), INSTR(-1, fnlist(i), ".") - 1)   ' Get fn minus extension
            u = MID$(fnlist(i), INSTR(-1, fnlist(i), "."))        ' Get extension
            fnlist(i) = t + Stamp + ".CrashSave" + u              '
         END IF                                                   '
      NEXT i                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now do the SAVE                                                                              |
   '-----------------------------------------------------------------------------------------------+
   lclProfName = FCB.ProfName                                     ' Save base Profname
   FOR j = 1 TO fcount                                            ' OK, now loop doing the SAVE for each one
      IF IsMEdit AND MOnly AND ISFALSE me.MEditFlagGet(j) THEN ITERATE FOR ' If modified only MEdit, then ignore this one
      IF ISFALSE IsMEdit AND MOnly AND ISFALSE IsModdFlag THEN ITERATE FOR ' If modified only single, then ignore this one
      i = IIF(IsMEdit, me.FileWatch(fnlist(j), %WatchEnd), me.FileWatch("", %WatchEnd))   ' Stop watching
      lclDir = PATHNAME$(PATH, fnlist(j))                         ' Get PATH, up to and incl the \
      lclFile = PATHNAME$(NAME, fnlist(j))                        ' Get File, after \ and before .
      lclExtn = PATHNAME$(EXTN, fnlist(j))                        ' Get Extn, . and all after it
      IF fcount > 1 THEN                                          ' If MEdit
         FCB.SetupFN(fnlist(j), %ProfGetY, RCA)                   ' Reload the Profile
      ELSE                                                        ' else a normal file save
         FCB.SetupFN(fnlist(j), %ProfGetN, RCA)                   ' Don't refresh Profile
      END IF                                                      '
      '--------------------------------------------------------------------------------------------+
      '- Create the BACKUP file if needed                                                          |
      '--------------------------------------------------------------------------------------------+
      IF FCB.AutoBkup AND ISFALSE IsBackupDone THEN               ' Need to create BKP file?
         BKPName = "!" + lclDir + lclFile + lclExtn               ' Rebuild the name
         DoBackup(BKPName, TP.TabMode, RCA)                       ' Let BACKUP have a go
         IF RCA.RC > 4 THEN                                       ' If something bad happened
            TP.ErrMsgAdd(%eFail, "AUTOBKUP error: " + RCA.Msg)    ' Issue the error
         ELSE                                                     '
            OnBackupDone                                          ' Remember we did this
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- See if an EMACRO to run                                                                   |
      '--------------------------------------------------------------------------------------------+
      IF TP.FCB_.EMacro <> "" THEN                                ' Is there an EMacro?
         macname = TP.FCB_.EMacro                                 ' Get macro string
         IF UCASE$(macname) = macname THEN                        ' Is macroname Uppercase?
            IF isMacro(macname) THEN                              ' Valid macro?
               me.pCmdMacro(macname)                              ' Then go do it
            ELSE                                                  '
               MErrExit(%eFail, "EMACRO - " + macname + " not found")   ' Issue error
            END IF                                                '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Set criteria for the line range and write the file                                        |
      '--------------------------------------------------------------------------------------------+
      IF ISFALSE IsMEdit THEN                                     ' Set the correct line range
         me.RangeSetRange(2, LastLine - 1)                        ' Everything for non=MEdit mode
      ELSE                                                        '
         RESET fline, tline                                       ' Zero our answer areas
         FOR i = 1 TO LastLine                                    ' Must search for range of this MEdit file
            IF IsLFile(i) THEN                                    ' Look for =FILE> lines
               IF fnlist(j) = TRIM$(LTxtG(i)) THEN                ' Found start of file
                  MEditFLine = i                                  ' Save the FILE line pointer
                  fline = i + 1                                   ' Save start line number
                  INCR i                                          '
                  DO WHILE ISFALSE IsLFile(i) AND ISFALSE IsLBottom(i)  '
                     tline = i                                    ' Save as hiwater last line
                     INCR i                                       '
                  LOOP                                            '
                  IF tline = 0 THEN tline = fline                 ' If tline = 0 (no lines) set it = to fline
                  me.RangeSetRange(fline, tline)                  ' Set fline/tline as the range
                  EXIT FOR                                        ' Done this looping crap
               END IF                                             '
            END IF                                                '
         NEXT i                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If MEdit see if different Profile needed                                                  |
      '--------------------------------------------------------------------------------------------+
      IF IsMEdit THEN                                             ' MEdit?
         t = GetProfileForFile(fnlist(j), PDiag, %False, %True)   ' Get needed Profile (noEFT, Query)
         IF IsMEdit AND FCB.Profname <> t THEN                    ' If Different
            FCB.SetupProf(t, RCA)                                 ' Swap to the needed one
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Range is set, now go write the file                                                       |
      '--------------------------------------------------------------------------------------------+
      IF me.WriteFile(Quiet, "R") THEN                            ' Let WriteFile Range have a go
         me.MacOverlap(FCB.FilePath)                              ' Warn if Macro/command overlap
         INCR MCount                                              ' Count saved files
         IF IsMEdit THEN                                          ' Do the reset
            me.MeditFlagSet(j, %False)                            ' Turn off the Modd flag of THIS MEdit file
            me.UpdLControl(MEditFLine)                            ' Update the FILE line
         END IF                                                   '
         IF ISFALSE IsMEdit THEN FileListRecentAdd(lclDir + lclFile + lclExtn, "")  ' Go add to RECENT list
         t = GetAutoFavName(FCB.FilePath)                         ' Get AUTOFAV name if available
         IF t <> "" THEN                                          ' Got a name
            FileListAdd(t, FCB.FilePath, "", TimePretty(0))       ' Add to the list
         END IF                                                   '
      ELSE                                                        '
         IF XFormActive = "" THEN TP.ErrMsgAdd(%eFail, "File " + lclFile + " not written")   ' Tell User
      END IF                                                      '

      IF CurrPcmd <> "END" THEN                                   '
         FileQueue("A", " ", fnlist(j))                           ' Add back to FQ, FileWatch/Watchend removed it
         IF me.FileWatch(fnlist(j), %WatchStart) THEN             ' Re- Establish the watch
            TP.ErrMsgAdd(0, "File Watch could not be re-established")   '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- If MEdit see if Profile re-load needed                                                    |
      '--------------------------------------------------------------------------------------------+
      IF IsMEdit AND FCB.Profname <> lclProfName THEN             ' Different Profile needed
         FCB.SetupProf(lclProfName, RCA)                          ' Swap back to the primary
      END IF                                                      '
   NEXT j                                                         '
   ActionCtr = FCB.ActionSave                                     ' Reinit the action counter

   IF ISFALSE gTerminateInProgress THEN                           ' If not recovery SAVE
      IF IsMEdit AND MCount = 0 THEN                              '
         TP.ErrMsgAdd(0, "No modified files required saving")     '
      ELSE                                                        '
         IF ISFALSE Quiet THEN                                    ' Issue messages, maybe.
            IF IsMEdit THEN                                       '
               TP.ErrMsgAdd(0, FORMAT$(mcount) + " file" + IIF$(mcount = 1, "", "s") + " saved")   '
            ELSE                                                  '
               IF MCount = 0 THEN                                 ' Single file, did we do it
                  IF XFormActive = "" THEN TP.ErrMsgAdd(0, "File not saved, was not modified")  '
               END IF                                             '
               DoStatusBar($SBState)                              ' re-Do the StatusBar boxes
            END IF                                                '
         END IF                                                   '
         FCB.TimeDateRefresh                                      ' Get refreshed Date/Time
      END IF                                                      '
   END IF                                                         '

   @P.PTopLine = lclTop                                           ' Keep our position
   MExitMeth                                                      '
END METHOD                                                        '

METHOD  pCmdSAVEALL(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Save all modified tabs                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL Cond AS LONG                                                '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H SAVEALL"), _                                 ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   Cond = PTBL.IsKwd("COND")                                      ' Get the COND operand
   GlobalSaveAll(Cond)                                            ' Go do it from global routine
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSAVEAS(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- SAVEAS a new filename                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL lclCmd, lclWord, fn1, fn2, t, cftype, ProfName, PDiag AS STRING, i, lclTop, TabFound AS LONG, RCA AS RCArea '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H SAVEAS"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsSetEdit OR IsEFTEdit THEN                                 ' SetEdit or EFTEdit etc.
      lclcmd = pCmd                                               ' Get the command line
      lclWord = GetNextWord(lclCmd, %Strip)                       ' Strip the 1st word
      pCmdCREATE("CREATE " + lclcmd + " .ZF .ZL")                 ' Pass to CREATE
      MErrExit(%eNone, "SAVEAS was converted to a CREATE command")   '
   END IF                                                         '

   IF IsMEdit THEN pCmdSaveAsMedit(pCmd): MExitMeth               ' Pass off MEdit version

   lclTop = @P.PTopLine                                           ' Save where we are
   cftype = FCB.Extn                                              ' Save current extension
   @P.PTopLine = 1                                                ' Ensure we're at the top
   fn1 = PTBL.Pos2(1)                                             ' Pickup filename if provided
   fn2 = fn1                                                      ' Another copy

   i = INSTR(-1, FCB.FilePath, "\")                               ' See if available PATH
   IF INSTR(fn2, "\") = 0 THEN fn2 = IIF$(i, LEFT$(FCB.FilePath, i), "") + fn2   ' If unqualified, add the path

   IF ISNULL(fn1) OR INSTR(fn2, "\") = 0 THEN                     ' Got a filename?
      fn2 = DoOpenFile("Enter Filename to be written", fn2)       ' No, go get one
      IF ISNULL(fn2) THEN MErrExit(%eNone, "SAVEAS function cancelled") '
   END IF                                                         '
   fn2 = SubstEnviron(fn2)                                        ' Do %xxx% substitution
   IF ISNOTNULL(PATHSCAN$(FULL, fn2)) THEN _                      ' See if it exists
         MErrExit(%eFail, "File exists, use REPLACE to re-use it")   '
   TabFound = VAL(FileQueue("S", " ", Fn2))                       ' Returns tab number if open, else zero
   IF TabFound > 0 THEN                                           ' Tab number?
      GoToTab(TabFound, "File already Open in this tab", "")      ' Issue msg and exit
      MExit                                                       '
   END IF                                                         '

   FCB.SetupFN(fn2, %ProfGetN, RCA)                               ' Setup the filename
   Profname = GetProfileForFile(Fn2, PDiag, %True, %False)        ' Get the Profile name (EFT,NotQuery)
   IF TP.EFTSkip THEN AnswerMeth(8, "Open skipped, User cancel or EFT profile lookup failed")   '
   FCB.SetupProf(ProfName, RCA)                                   ' Load entire Profile
   IF RCA.RC <> 0 THEN                                            ' Error?
      AnswerMeth(8, "Profile: " + ProfName + " load data failed") ' Say some words
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- If XFORM is active, make sure the filetype doesn't change                                    |
   '-----------------------------------------------------------------------------------------------+
   IF XFormActive <> ""  AND UCASE$(FCB.EXTN) <> UCASE$(cftype) THEN _  '
      MErrExit(%eFail, "SAVEAS for an XFORM session cannot alter the File-Type") ' No filetype changes

   '-----------------------------------------------------------------------------------------------+
   '- OK, get ready to write it                                                                    |
   '-----------------------------------------------------------------------------------------------+
   i = me.FileWatch("", %WatchEnd)                                ' Kill any prior Watch

   IF ISFALSE me.WriteFile(%True, "A") THEN _                     ' Write ALL
      MErrExit(%eFail, "File creation failed")                    '
      MacWarn = 0                                                 ' Ensure MacOverlap issues a message
      me.MacOverlap(FCB.FilePath)                                 ' Warn if Macro/command overlap

   IF TabMode = %Clip THEN TabMode = %Edit                        ' Remove any possible CLIP status

   IF ISFALSE gMacroMode THEN                                     ' If not macro mode
      me.WindowTitle                                              ' Alter window/Tab titles
   END IF                                                         '
   me.ClrLoad()                                                   ' Get Attr loaded if it exists
   OffModdFlag: OnUndoFlag                                        ' Turn off the Modd flag
   FileQueue("A", " ", FCB.FilePath)                              ' Add to FQ
   IF me.FileWatch(FCB.FilePath, %WatchStart) THEN _              ' Establish the watch
      TP.ErrMsgAdd(0, "File watch could not be established")      '
   t = GetAutoFavName(FCB.FilePath)                               ' Get AUTOFAV name if available
   IF t <> "" THEN                                                '
      FileListAdd(t, FCB.FilePath, "", TimePretty(0))             ' Add to the list
   END IF                                                         '
   FileListAdd("Recent Files", FCB.FilePath, "", TimePretty(0))   ' Add to Recent
   DoSet(%LoadReq)                                                ' Request refresh
   TP.ErrMsgAdd(0, "SaveAs complete")                             '
   @P.PTopLine = lclTop                                           ' Re-Do position
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSAVEASMEdit(pCmd AS STRING)                           '
'--------------------------------------------------------------------------------------------------+
'- SAVEAS a MEdit session                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL lclWord, lclDir, lclFile, lclExtn, base1, base2, BaseProf AS STRING  '
LOCAL i, j, lclTop, fcount, fline, tline AS LONG, RCA AS RCArea   '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H SAVEAS"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   lclTop = @P.PTopLine                                           ' Save where we are
   IF PTBL.OpsNum > 0 THEN _                                      '
      MErrExit(%eFail, "SAVEAS for MEDIT sessions takes no operands")   ' Say sorry, no operands

   '-----------------------------------------------------------------------------------------------+
   '- Build table of filenames to be saved                                                         |
   '-----------------------------------------------------------------------------------------------+
   fcount = MEditCount                                            ' Set number of files to save
   REDIM fnlist(fcount) AS STRING                                 '

   '-----------------------------------------------------------------------------------------------+
   '- Add names making sure no duplicates                                                          |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO fcount                                            ' Build table of filenames
      base1 = me.MEditListGet(i)                                  ' Copy the new name
      IF INSTR(base1, "\") <> 0 THEN base1 = MID$(base1, INSTR(-1, base1, "\") + 1) ' Reduce to base filename
      base1 = UUCASE(base1)                                       ' Uppercase it
      FOR j = 1 TO fcount                                         ' Ensure no base name duplicates
         base2 = fnlist(j)                                        ' Copy one of the previous names
         IF INSTR(base2, "\") <> 0 THEN base2 = MID$(base2, INSTR(-1, base2, "\") + 1) ' Reduce to base filename
         IF ISNOTNULL(base1) AND IsEQ(base1, base2) THEN _        ' Duplicate?
            MErrExit(%eFail, "MEDIT session contains duplicate base file names, SAVEAS cancelled") '
      NEXT j                                                      '
      fnlist(i) = me.MEditListGet(i)                              '
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Get the directory where things go                                                            |
   '-----------------------------------------------------------------------------------------------+
   KbdPopSave                                                     ' Ready for pop-up
   DISPLAY BROWSE ghWnd, , , "Specify directory for SaveAs", GetDefaultFolder, %BIF_EDITBOX OR %BIF_RETURNONLYFSDIRS _  '
           TO lclDir                                              '
   KbdPopRestore                                                  ' Reset popup state
   IF ISNULL(lclDir) THEN _                                       '
      MErrExit(%eNone, "Directory selection cancelled")           ' No selection?    Bail out
   lclDir = TRIM$(lclDir) + "\"                                   ' Clean the Dir name, add \

   '-----------------------------------------------------------------------------------------------+
   '- OK, loop for each file, see if already exists                                                |
   '-----------------------------------------------------------------------------------------------+
   FOR j = 1 TO fcount                                            ' OK, now loop doing the SAVE for each one
      lclFile = PATHNAME$(NAME, fnlist(j))                        ' Get File, after \ and before .
      lclExtn = PATHNAME$(EXTN, fnlist(j))                        ' Get Extn, . and all after it
      IF ISNOTNULL(DIR$(lclDir + lclFile + lclExtn)) THEN _       ' See if file exists
         MErrExit(%eFail, "File: " + lclDir + lclFile + lclExtn + " already exists, SaveAs terminated")  '
      IF VAL(FileQueue("S", " ", lclDir + lclFile + lclExtn))   > 0 THEN _ ' Open in some tab?
         MErrExit(%eFail, "File: " + lclDir + lclFile + lclExtn + " is open in anoher tab, SaveAs terminated") '
   NEXT j                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Now loop and actually do something                                                           |
   '-----------------------------------------------------------------------------------------------+
   BaseProf = FCB.ProfName                                        ' Save the base Profile
   FOR j = 1 TO fcount                                            ' OK, now loop doing the SAVE for each one
      me.UnWatchQueue(fnlist(j))                                  ' Kill Watch and deque
      lclFile = PATHNAME$(NAME, fnlist(j))                        ' Get File, after \ and before .
      lclExtn = PATHNAME$(EXTN, fnlist(j))                        ' Get Extn, . and all after it
      PTBL.PTBLReset                                              ' Set parse search output fields for ALL
      RESET fline, tline                                          ' Zero our answer areas
      FOR i = 1 TO LastLine                                       ' Must search for range of this MEdit file
         IF IsLFile(i) THEN                                       ' Look for =FILE> lines
            IF fnlist(j) = TRIM$(LTxtG(i)) THEN                   ' Found start of file
               me.LTxtSet(i, lclDir + lclFile + lclExtn)          ' Swap name in =FILE> line
               fline = i + 1                                      ' Save start line number
               INCR i                                             '
               DO WHILE ISFALSE IsLFile(i) AND ISFALSE IsLBottom(i)  '
                  tline = i                                       ' Save as hiwater last line
                  INCR i                                          '
               LOOP                                               '
               me.RangeSetRange(fline, tline)                     ' Set fline/tline as the range
               EXIT FOR                                           ' Done this looping crap
            END IF                                                '
         END IF                                                   '
      NEXT i                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Do the actual write                                                                       |
      '--------------------------------------------------------------------------------------------+
      FCB.SetupFN(lclDir + lclFile + lclExtn, %ProfGetY, RCA)     ' Set FCB to this file
      IF ISFALSE me.WriteFile(%True, "R") THEN                    ' Let WriteFile Range have a go
         TP.ErrMsgAdd(%eFail, "File " + lclDir + lclFile + lclExtn + " not written")   ' Tell User
      END IF                                                      '

      lclWord = CLIP$(RIGHT, lclDir, 1)                           ' Strip off \
      FileQueue("A", " ", FCB.FilePath)                           ' Add to inuse queue
      IF me.FileWatch(FCB.FilePath, %WatchStart) THEN             '
         TP.ErrMsgAdd(0, "File Watch could not be established")   '
      END IF                                                      '

      me.MEditListSet(j, lclDir + lclFile + lclExtn)              ' Modify the MEdit list
      me.MEditFlagSet(j, %False)                                  ' Modify the MEdit list
   NEXT j                                                         '

   TP.ErrMsgAdd(0, "SaveAs complete")                             '
   @P.PTopLine = lclTop                                           ' Re-Do position
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSCROLL(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Scroll Down (Called internally via ISCROLL command)                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL lclScroll, lctop, lcrow, lccol, lcoff AS LONG               '
LOCAL MKType, DType AS STRING                                     '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H Scroll"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   MKType = PTBL.Grp("STYPE")                                     ' Get type M=Mouse K=Keyboard
   DType = PTBL.Grp("DTYPE")                                      ' Get type UP/DOWN/LEFT/RIGHT

   IF gENV.AutoScroll = 0 AND MKType = "M" THEN ErrMsgHigh = %eNone: MExitMeth   ' Exit if no mouse scrolling
   IF MKType = "K" AND gENV.AutoScroll = 0 THEN                   ' Keyboard but no scroll amount?
      lclScroll = VAL(PTBL.Pos("#", 1))                           ' At least treat as if it was one (1)
   ELSE                                                           '
      lclScroll = VAL(PTBL.Pos("#", 1)) * gENV.AutoScroll         ' Apply Factor
   END IF                                                         '
   lcrow = @P.C.CRow: lccol = @P.C.CCol                           ' Get local copies
   IF ISFALSE IsFMTab THEN                                        ' Not the FM screen
      IF ISFALSE (IsCBad OR IsCCmnd OR IsCScrl) THEN              ' In Data or Line area?
         lcrow = me.SGet(@P.C.CRow)                               ' Get data line number
         IF lcrow < 0 THEN lcrow = me.SGet(lCRow - ABS(lcrow))    ' Convert to real line index
         IF lCCol > @P.PGapCol THEN lccol = @P.POffset + lCCol - @P.PGapCol   ' Get column number, 0 = linenumber area
         IF lcRow = 0 THEN lccol = 0                              ' If no row, then no column
      END IF                                                      '
      IF lcrow > 0 THEN me.CurSetReq(%Low, lcrow, lccol, %False)  ' Set default cursor set attempt to where we are

      ErrMsgHigh = %eNone                                         ' Say we 're OK
      SELECT CASE AS CONST$ DType                                 ' What direction
         CASE "DOWN"                                              ' DOWN
            FCB.ScrlPageSus = %True                               ' Set suspend PAGE mode
            lctop = @P.PTopLine                                   ' Save current top
            @P.PTopLine = me.CRPFwd(%mVisible, @P.PTopLine, lclScroll)  ' Move TopScrn by scroll amount
            IF lctop = @P.PTopLine OR lcrow = 0 THEN MExitMeth    ' Didn't move, just exit
            IF MKType = "K"  AND lcrow <> 0 THEN lcrow += (@P.PTopLine - lctop)  ' Keep cursor from moving
            me.CurSetReq(%Position, lcrow, lccol, %False)         ' Set cursor set attempt

         CASE "UP"                                                ' UP
            FCB.ScrlPageSus = %True                               ' Set suspend PAGE mode
            lctop = @P.PTopLine                                   ' Save current top
            @P.PTopLine = me.CRPBack(%mVisible, @P.PTopLine, lclScroll) ' Move TopScrn by scroll amount
            IF lctop = @P.PTopLine OR lcrow = 0 THEN MExitMeth    ' Didn't move, just exit
            IF MKType = "K"  AND lcrow <> 0 THEN lcrow -= (lctop - @P.PTopLine)  ' Keep cursor from moving
            me.CurSetReq(%Position, lcrow, lccol, %False)         ' Set cursor set attempt

         CASE "RIGHT"                                             ' RIGHT
            lcoff = @P.POffSet                                    ' Get current offset
            me.OffsetAdd(lclScroll)                               ' Move OffSet over a bit
            IF MKType = "K" THEN lccol += lclScroll               '
            IF lcrow = 0 THEN MExitMeth                           '
            IF lccol - 1 >= @P.POffset AND lccol <= @P.POffset + @P.PDataLen THEN   ' Can we keep Cursor on the line?
               me.CurSetReq(%Position, lcrow, lccol, %False)      ' Set cursor set attempt
            ELSE                                                  ' Gone off screen, keep at the left
               me.CurSetReq(%Position, lcrow, @P.POffset + 1, %False)   ' Set cursor set attempt
            END IF                                                '

         CASE "LEFT"                                              ' LEFT
            lcoff = @P.POffSet                                    ' Get current offset
            me.OffsetSub(lclScroll)                               ' Move OffSet over a bit
            IF @P.POffset < 0 THEN @P.POffset = 0                 ' Don't go too far
            IF MKType = "K" AND lcoff <> @P.POffSet THEN lccol -= (lcoff - @P.POffSet) ' Keep cursor from moving
            IF lcrow = 0 THEN MExitMeth                           '
            IF lccol >= @P.POffset AND lccol <= @P.POffset + @P.PDataLen THEN ' Can we keep Cursor on the line?
               me.CurSetReq(%Position, lcrow, lccol, %False)      ' Set cursor set attempt
            ELSE                                                  ' Gone off screen, keep at the top
               me.CurSetReq(%Position, lcrow, @P.POffset + @P.PDataLen, %False)  ' Set cursor set attempt
            END IF                                                '
      END SELECT                                                  '

   ELSE                                                           ' Else it's FM mode
      ErrMsgHigh = %eNone                                         ' Say we 're OK
      SELECT CASE AS CONST$ DType                                 ' Direction?
         CASE "DOWN"                                              ' DOWN
            @P.PTopLine = MIN(@P.PTopLine + lclScroll, MAX(1, gFMDCtr - gENV.ScrHeight + (3 * gENV.FMHelpFlag) + 7)) ' Move TopScrn by scroll amount
            LastTop = 0                                           ' Make sure it moves

         CASE "UP"                                                ' DOWN
            @P.PTopLine = MAX(1, @P.PTopLine - lclScroll)         ' Move TopScrn by scroll amount
            LastTop = 0                                           ' Make sure it moves
      END SELECT                                                  '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSET(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Handle SET Command                                                                              |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, ctab AS LONG, MSG, MyOp, Op1, Op3 AS STRING, RCA AS RCArea  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff. NOTE: Set only uses basic operand separation                     |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H SET"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   GOSUB ChkActive                                                ' Make sure SetEdit is not active
   ClipBoardGet(gSetClipB)                                        ' Save the Clipboard

   '-----------------------------------------------------------------------------------------------+
   '- Try to accomodate the various possible operand combinations                                  |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 0 THEN                                        ' No operands?
      IF gSetRawCtr > 0 THEN                                      ' Add them
         FOR i = 1 TO gSetRawCtr                                  '
            MSG += gSetRaw(i) + $CRLF                             ' Add to CBD
         NEXT i                                                   '
      ELSE                                                        '
         MSG += "None."                                           '
      END IF                                                      '
      ClipBoardSet(MSG)                                           ' Send it to the Clipboard
      TabAdd(%ClipLoad OR %SetEdit)                               ' Add a Tab in requested Mode
      TP.FCB_.SetupFN("", %ProfGetY, RCA)                         ' Setup null FN
      TabInitFileData()                                           ' Let TabInit do the work
      MExitMeth                                                   ' We're done
   END IF                                                         '

   IF PTBL.OpsNum = 1 THEN                                        ' Just one operand?
      i = INSTR(PTBL.Ops(1), "=")                                 ' And no = within it
      IF i = 0 THEN                                               ' And no = within it
         SETTableUpd("GET", PTBL.Ops(1), RCA)                     ' Go fetch it
         IF RCA.RC = 0 THEN                                       '
            MSG = "Set variable " + PTBL.Ops(1) + " = " + RCA.Msg ' Add some words
            TP.ErrMsgAdd(%eNone, MSG)                             ' Issue message
         ELSE                                                     '
            TP.ErrMsgAdd(RCA.RC, TRIM$(RCA.Msg))                  ' Issue returned message
         END IF                                                   '
      ELSE                                                        '
         GOTO NotDisp                                             '
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

NotDisp:                                                          '
   IF PTBL.OpsNum = 2 AND UCASE$(PTBL.Ops(2)) = "OFF" THEN        ' Maybe SET xxx OFF?
      SETTableUpd("DEL", PTBL.Ops(1), RCA)                        ' Go delete it
      TP.ErrMsgAdd(RCA.RC, TRIM$(RCA.Msg))                        ' Issue returned message
      MExitMeth                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- The obvious are done, treat it as some kind of AAA=BBB                                       |
   '-----------------------------------------------------------------------------------------------+
   FOR k = 1 TO PTBL.OpsNum                                       ' Build a single big operand
      MyOp += PTBL.Ops(k) + " "                                   '
   NEXT k                                                         '
   MyOp = CLIP$(RIGHT, MyOp, 1)                                   '

   i = INSTR(MyOp, "=")                                           ' Get = location
   IF i = 0 THEN                                                  ' No = or blank before =
      MErrExit(%eFail, "Malformed SET operands")                  ' Kill it
   END IF                                                         '
   IF IsEQ(PTBL.Ops(1), "X") OR _                                 ' No =X allowed
      VERIFY(LEFT$(PTBL.Ops(1), 1), $Numeric + ".") = 0 THEN _    ' No leading numbers or period
      MErrExit(%eFail, "Invalid SET variable name: " + PTBL.Ops(1)) '
   Op1 = TRIM$(LEFT$(MyOp, i - 1))                                '
   Op3 = TRIM$(MID$(MyOp, i + 1)): StrUnquote(Op3)                '
   SETTableUpd("SET", Op1 + " " + Op3, RCA)                       ' Go set it
   TP.ErrMsgAdd(RCA.RC, TRIM$(RCA.Msg))                           ' Issue returned message
   MExitMeth                                                      '

ChkActive:                                                        '
   ctab = PgNumber                                                ' Save where we are
   FOR i = 1 TO gTabsNum                                          ' Do for each tab
      TP = gTabs(i)                                               ' Pick the Tab
      IF IsSetEdit THEN                                           ' We have a SetEdit tab active
         TP = gTabs(ctab)                                         ' Replace TP
         MErrExit(%eFail, "SET Edit is currently active")         '
      END IF                                                      '
   NEXT i                                                         '
   TP = gTabs(ctab)                                               ' Replace TP
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdSORT(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- SORT the data                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lclTop AS LONG, RCA AS RCArea                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff. NOTE: SORT only uses basic operand separation                    |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic parse
         PCmdHelp("H SORT"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   PTBL.PTBLReset                                                 ' Reset the assign areas
   lcltop = @P.PTopLine                                           ' Save where we are
   me.LTxtSort(RCA)                                               ' Go do the sort
   @P.PTopLine = lclTop                                           ' Go to where we were
   TP.ErrMsgAdd(RCA.RC, TRIM$(RCA.Msg))                           ' Issue returned message
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSOURCE(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Set default Encoding for current profile                                                        |
'--------------------------------------------------------------------------------------------------+
LOCAL lclSource, NewSource AS STRING                              '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic parse
         GOTO DispSource, _                                       ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   lclSource = FCB.SourceName                                     ' Save curent SOURCE
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "SOURCE requires an operand")  ' No Ops?
   NewSource = PTBL.Grp("FORMAT")                                 ' Was a normal name entered?
   IF ISNULL(NewSource) AND PTBL.GotLit > 0 THEN                  ' An alternate name?
      NewSource = PTBL.Pos2(1)                                    ' Grab it
      IF ISFALSE ISFILE(gENV.HomeFolder + NewSource + ".SOURCE") THEN _ ' See if the Custom SOURCE file exists
         MErrExit(%eFail, "SOURCE codepage file: " + gENV.HomeFolder + NewSource + ".SOURCE is not found, command rejected")  '
   END IF                                                         '

   FCB.SourceName = NewSource                                     ' Set as SOURCE and
   IF IsNE(FCB.SourceName, lclSource) AND LastReal > 0 THEN       ' Warn the user if live data?
      DoMessageBox ("SOURCE is changing from |K" + lclSource + "|B to |K" + FCB.SourceName + "|B," + $CRLF + _ '
                    "You should SAVE the current data immediately using this new format" + $CRLF + _  '
                    "to prevent incorrect loading the next time the file is processed" + $CRLF + $CRLF + _  '
                    "You may also want to examine your WORD character string setting and" + $CRLF + _ '
                    "adjust this as well if needed.", %MB_OK OR %MB_USERICON, "Source Warning") '
   END IF                                                         '
   DoStatusBar($SBSource)                                         ' re-Do the StatusBar Source box
   DispSource:                                                    '
   DoProfMsg("SOURCE set to " + FCB.SourceName + ", COLLATE to " + FCB.CollateStr)  '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSPELL(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- SPELL Check Command                                                                             |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, l, m, x, AllCount, cWordStart, FirstLine, FirstCol, lclALL, lclNext, sline, scol, Bail AS LONG  '
LOCAL fline, RC, SaveCheck AS LONG, ftxt, lclTxt, t, txt1, cWord, lclWordStr, DLMStr AS STRING  '
LOCAL RCA AS RCUser, Sugg() AS STRING                             '
DIM Pop(1 TO 1) AS STRING                                         '
STATIC ONCE AS LONG                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, %PAll), _                            ' Try the Parse
         PCmdHelp("H SPELL"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   IF ISNULL(gEnv.LANG) THEN MErrExit(%eFail," SPELL impossible. Options => General has no LANG specification")   '
   '-----------------------------------------------------------------------------------------------+
   '- Check for the ADD variation                                                                  |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.IsKwd("ADD") OR PTBL.IsKwd("ADDT") THEN                ' ADD or ADDT?
      IF PTBL.GotLit <> 1 THEN MErrExit(%eFail," SPELL ADD needs a single literal") '
      RCA.RC = IIF(PTBL.IsKwd("ADDT"), 122, 123)                  ' Set 'magic' RC to indicate an Add or AddT
      SpellCheck(MID$(PTBL.Pos("$",1), 2), Sugg(), RCA)           ' Go add it
      IF RCA.RC = 0 THEN MErrExit(%eNone, "Added successfully")   '
      MErrExit(%eFail, TRIM$(RCA.Msg))                            ' Else error exit
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Check for the LANG variation                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.IsKwd("LANG") THEN                                     ' LANG?
      IF PTBL.GotLit <> 1 THEN MErrExit(%eFail," SPELL LANG needs a single literal")   '
      RCA.RC = 456                                                ' Set 'magic' RC to indicate a LANG change
      SpellCheck(MID$(PTBL.Pos("$",1), 2), Sugg(), RCA)           ' Go let HunSpell add it
      IF RCA.RC = 0 THEN                                          ' OK?
         gSpellCountry = MID$(PTBL.Pos("$",1), 2)                 ' Swap in override
         MErrExit(%eNone, "LANG: " + MID$(PTBL.Pos("$",1), 2) + " swap successful") '
      END IF                                                      '
      MErrExit(%eFail, TRIM$(RCA.Msg))                            ' Else error exit
   END IF                                                         '

   lclWordStr = FCB.WordStr + "'"                                 ' Fetch a local copy of word chars, add '
   FOR i = 1 TO 255                                               ' Build the DLM string
      IF INSTR(lclWordStr, CHR$(i)) = 0 THEN DLMStr += CHR$(i)    '
   NEXT i                                                         '

   lclALL  = PTBL.IsKwd("ALL")                                    ' ALL?
   lclNext = PTBL.IsKwd("NEXT")                                   ' NEXT?
   IF lclAll AND lclNext THEN MErrExit(%eFail, "Can't use both ALL and NEXT") '
   IF (lclAll OR lclNext) = 0 THEN lclNext = %True                ' Default NEXT
   IF PTBL.HiLiteOn = 0 THEN PTBL.HiLiteOn = 3                    ' Add +Yellow if no color specified
   SpellClr = PTBL.HiLiteOn                                       ' Save it as SpellClr

   '-----------------------------------------------------------------------------------------------+
   '- The ALL flavor search                                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF lclALL THEN                                                 ' The ALL flavor?
      pCmdReset("RESET " + IIF$(SpellClr > 0, gHiLites(SpellClr), "YELLOW"))  ' Reset previous hilights
      gfInterrupt = %False                                        ' Reset the Interrupt flag
      DispInterrupt("Click to Interrupt Spell-Check", "Processing Line: ") ' Display the Interrupt popup
      RESET AllCount, sLine, sCol                                 ' Reset stuff
      FOR i = 1 TO LastLine                                       ' Spin through the lines
         IF gfInterrupt THEN EXIT FOR                             ' User has interrupted
         CONTROL SET TEXT ghIntr, %INTERRUPT_TEXT2, FORMAT$(i, "000000")   '
         CONTROL SET TEXT ghIntr, %INTERRUPT_TEXT3, "Errors Found: " + FORMAT$(AllCount)  '
         IF ISFALSE IsLData(i) THEN ITERATE FOR                   ' Only Data lines
         IF ISFALSE Me.RangeVal(i) THEN ITERATE FOR               ' Do basic filtering
         GOSUB CheckIt                                            ' Go process the line, mark errors
         RESET gLoopCtr                                           ' Reset LoopCtr to avoid treating as a loop
         DIALOG DOEVENTS 0                                        ' Let others process (Including Interrupt box)
      NEXT i                                                      '
      DIALOG END ghIntr                                           ' End the window

      IF AllCount = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(nMac(%eFail), "No misspelled words found")  '
      ELSE                                                        '
         TP.ErrMsgAdd(0, FORMAT$(AllCount) + " words misspelled") '
         me.CurSetReq(%Change, FirstLine, FirstCol, %True)        ' Put Csr on Line with first error
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- The NEXT flavor search                                                                       |
   '-----------------------------------------------------------------------------------------------+
   IF lclNext THEN                                                ' The Next flavor?
      pCommand = ""                                               ' Clear the command
      '--------------------------------------------------------------------------------------------+
      '- Figure out the line and column we're to start on                                          |
      '--------------------------------------------------------------------------------------------+
      sLine = @P.PTopLine: sCol = 1                               ' Set start defaults
      IF @P.C.CType = %CLData AND ISFALSE gMacLCsr THEN           ' In the Data Area and not a macro
         sLine = me.SGet(@P.C.CRow)                               ' Swap in current cursor location
         sCol = @P.C.CCol - @P.PGapCol + @P.POffset               ' Calc column position in line
      END IF                                                      '
      gLoopCtr = -1                                               ' Suspend loop checking
      FOR i = sLine TO LastLine                                   ' Spin through the lines
         IF ISFALSE IsLData(i) THEN ITERATE FOR                   ' Only Data lines
         IF ISFALSE Me.RangeVal(i) THEN ITERATE FOR               ' Do basic filtering
         GOSUB CheckIt                                            ' Go process the line, mark errors
         IF Bail THEN EXIT FOR                                    ' Bail out?
      NEXT i                                                      '
      RESET gLoopCtr                                              ' Resume loop checking
      MExitMeth                                                   '
   END IF                                                         '

'--------------------------------------------------------------------------------------------------+
'- Do checking one line at a time                                                                  |
'--------------------------------------------------------------------------------------------------+
CheckIt:                                                          '
   txt1 = LTxtG(i)                                                ' Grab the text
   '-----------------------------------------------------------------------------------------------+
   '- Scan a text line for words                                                                   |
   '-----------------------------------------------------------------------------------------------+
   j = IIF(sCol > 0, sCol, 1)                                     ' Start in col 1 or sCol
   DO WHILE j <= LEN(Txt1)                                        ' Extract all words from each line
      sCol = 0                                                    ' Use only once
      '--------------------------------------------------------------------------------------------+
      '- Find start of a word                                                                      |
      '--------------------------------------------------------------------------------------------+
      k = INSTR(j, Txt1, ANY lclWordStr)                          ' Find start of next 'word'
      IF k = 0 THEN sCol = 0: EXIT DO                             ' If none, we're done
      cWordStart = k                                              ' Save start of word
      '--------------------------------------------------------------------------------------------+
      '- Now find end of word                                                                      |
      '--------------------------------------------------------------------------------------------+
      m = INSTR(k, Txt1, ANY DLMStr)                              ' Look for delimiter
      '--------------------------------------------------------------------------------------------+
      '- We have the last word on the line                                                         |
      '--------------------------------------------------------------------------------------------+
      IF m = 0 THEN                                               ' No trailing blank?  (i.e. end of line)
         cWord = MID$(Txt1, k)                                    ' Save as cWord
         j = LEN(Txt1) + 1                                        ' Use up the Txt1 string
      '--------------------------------------------------------------------------------------------+
      '- We have a 'word' in the middle of the line                                                |
      '--------------------------------------------------------------------------------------------+
      ELSE                                                        ' We have a trailing blank
         cWord = MID$(Txt1, k TO m - 1)                           ' Extract the word
         j = m                                                    ' Set rescan  start
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Don't accidentally process blank words                                                    |
      '--------------------------------------------------------------------------------------------+
      IF ISNULL(TRIM$(cWord)) THEN ITERATE DO                     ' Dummy null word?
      '--------------------------------------------------------------------------------------------+
      '- Finally, lets spell check it                                                              |
      '--------------------------------------------------------------------------------------------+
      SpellCheck(CWord, Sugg(), RCA)                              ' Check the word for spelling
      SELECT CASE RCA.RC                                          ' How'd it do
         CASE 0                                                   ' OK
                                                                  ' Do nothing

         CASE 1, 2                                                ' Wrong, maybe with suggestions
            '---------------------------------------------------------------------------------------+
                                                                  ' Misspelled                                                                            |
            '---------------------------------------------------------------------------------------+
            IF FirstLine = 0 THEN FirstLine = i: FirstCol = cWordStart  ' Save where to position TOS
            GOSUB MarkIt                                          ' Go hilite/process it
            INCR AllCount                                         ' Count errors
            IF LEFT$(RCA.Msg, 12) <> "Misspelled: " THEN          ' Other than a simple misspell?
               IF ONCE = 0 THEN MSGBOX TRIM$(RCA.Msg)             ' Issue it
               ONCE = %True                                       ' Just Once
               EXIT LOOP                                          '
            END IF                                                '
            fline = 0                                             '
            FOR l = 0 TO 300                                      '
               IF @P.PS(l) = i THEN fline = l: EXIT FOR           ' Get the screen line
            NEXT l                                                '
            IF fline <> 0 AND fline <= TP.gPBottom AND ISFALSE lclNext THEN me.DispLine(i, fline)  ' Re-display the line with the hi-light
            IF lclALL THEN EXIT SELECT                            ' If ALL, we're done here

            '---------------------------------------------------------------------------------------+
                                                                  ' In NEXT mode, do a popup                                                              |
            '---------------------------------------------------------------------------------------+
            REDIM Pop(1 TO UBOUND(Sugg()) + 8)                    ' DIM the POP table
            POP(1) = "91.<< Ignore this occurrence of " + $DQ + cWord + $DQ + " >>" '
            POP(2) = "92.<< Ignore all " + $DQ + cWord + $DQ + " for this session >>"  '
            Pop(3) = "93.<< Add " + $DQ + cWord + $DQ + " to User Dictionary >>" '
            Pop(4) = "94.** Terminate SPELL NEXT Processing **"   '
            Pop(5) = "0. "                                        '
            Pop(6) = "95.Or replace with one of the following:"   '
            Pop(7) = "0. "                                        '
            FOR l = 0 TO UBOUND(Sugg())                           ' Add the suggestions
               POP(l + 8) = FORMAT$(l + 1) + "." + Sugg(l)        '
            NEXT                                                  '
            DO                                                    ' Get a response
               RC = DoPopUp(Pop(), 100, 130)                      ' Display and get user's choice
            LOOP UNTIL RC <> 0                                    ' Try again if a blank line
            SELECT CASE RC                                        ' Handle the RC answer
               CASE 91, 95, 0                                     ' Ignore? Back out
                  me.AttrHiLiteSet(i, cWordStart, cWordStart + LEN(cWord) - 1, %AttrHiSTD)   ' ReSet the color
                  me.DispLine(i, fline)                           ' Re-display the line
                  ITERATE DO                                      '
               CASE 92                                            ' Ignore temporarily?
                  RCA.RC = 122                                    ' Set 'magic' RC to indicate an Add
                  SpellCheck(cWord, Sugg(), RCA)                  ' Add the word to memory table
                  t = "CHANGE ALL WORD +STD T`" + cWord + "` T`" + cWord + "` !" + FORMAT$(i) + " .ZLast"   '
                  FCB.HiFindSupp = %True: pCmdChange(t): FCB.HiFindSupp = %False ' Try it
                  me.CurSetReq(%Position, i, cWordStart, %True)   ' Set cursor set attempt
                  me.DispScreen                                   ' Re-display the screen
                  ITERATE DO                                      '
               CASE 93                                            ' Add to Dictionary?
                  RCA.RC = 123                                    ' Set 'magic' RC to indicate an Add
                  SpellCheck(cWord, Sugg(), RCA)                  ' Add the word to USER.DIC
                  t = "CHANGE ALL WORD +STD T`" + cWord + "` T`" + cWord + "` !" + FORMAT$(i) + " .ZLast"   '
                  FCB.HiFindSupp = %True: pCmdChange(t): FCB.HiFindSupp = %False ' Try it
                  me.CurSetReq(%Position, i, cWordStart, %True)   ' Set cursor set attempt
                  me.DispScreen                                   ' Re-display the screen
                  ITERATE DO                                      '
               CASE 94                                            '
                  me.AttrHiLiteSet(i, cWordStart, cWordStart + LEN(cWord) - 1, %AttrHiSTD)   ' ReSet the color
                  me.DispLine(i, fline)                           ' Re-display the line
                  Bail = %True: EXIT DO                           '
               CASE ELSE                                          ' Within suggestion range?
                  t = "CHANGE ALL WORD +STD T`" + cWord + "` T`" + Sugg(RC - 1) + "` !" + FORMAT$(i) + " .ZLast"  '
                  FCB.HiFindSupp = %True: pCmdChange(t): FCB.HiFindSupp = %False ' Try it
                  me.CurSetReq(%Position, i, cWordStart, %True)   ' Set cursor set attempt
                  me.DispScreen                                   ' Re-display the screen
                  ITERATE DO                                      '
            END SELECT                                            '
      END SELECT                                                  '
   LOOP                                                           ' Loop till this line all done
   sCol = 0                                                       ' Clear resume column
   RETURN                                                         '

   MarkIt:                                                        '
      sLine = i: sCol = cWordStart + LEN(cWord)                   ' Set resume position for NEXT
      me.LFlagBitOff(i, %Invisible)                               ' Remove the invisibility flag
      me.LFlagBitOn(i, %Popped)                                   ' Say we've just popped it
      me.AttrHiLiteSet(i, cWordStart, cWordStart + LEN(cWord) - 1, SpellClr)  ' Set the color
      IF lclNext THEN                                             ' If NEXT
         me.LFlagBitOn(i, %TopScreen)                             ' Move %TopScreen to our choice
         me.CurSetReq(%FLocate, i, cWordStart, %True)             ' Set cursor set attempt
         me.DispScreen                                            ' Ensure it's visible
      END IF                                                      '
   RETURN                                                         '

END METHOD                                                        '

METHOD  pCmdSPLIT(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- SPLIT Command                                                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL i, RSRCH, RCHNG, AllCount AS LONG                           '
   MEntry                                                         '
   PTBL = PTBLSrch                                                ' Use the full search version
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the Parse
         PCmdHelp("H SPLIT"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   RSRCH = PTBL.IsKwd("RSRCH"): RCHNG = PTBL.IsKwd("RCHNG")       ' Get the critical ones right off
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   '-----------------------------------------------------------------------------------------------+
   '- Eliminate simple RSRCH first, then the RCHNG                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.OpsNum = 1 AND RSRCH THEN me.pCmdFind("FIND RSRCH", "SPLIT"): MExitMeth  ' Pass off RFIND to the FIND command

   IF PTBL.OpsNum = 1 AND RCHNG THEN                              ' RCHNG?
      IF LocFind <> "SPLIT" THEN _                                ' Last better be SPLIT
         MErrExit(%eFail, "Last search was NOT a SPLIT command")  '
      RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values
      IF PTBL.FoundFailed = 0 THEN                                ' Last FIND was successful?
         me.Split()                                               ' Yes, Just do the Split
         TP.ErrMsgAdd(%eNone, "Split successful")                 '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
         PTBL.FoundFailed = 3                                     ' We're in not found mode again
      ELSE                                                        '
         i = me.Search(0, @P.C.CType)                             ' Go see if we can find it
         IF i = 0 THEN                                            ' Got it?
            TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
            PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)            ' Remember we failed
         ELSE                                                     '
            me.Split()                                            ' Do the Split
            TP.ErrMsgAdd(%eNone, "Split successful")              '
            ErrMsgHigh = %eNone                                   ' Say we 're OK
         END IF                                                   '
      END IF                                                      '
      MExitMeth                                                   '
   END IF                                                         '

   Call3(PTBL.ParseCmd(pCmd, %PAssign), _                         ' Complete the Parse
         PCmdHelp("H SPLIT"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   PTBL.FlgNext = %True: PTBL.FlgPrev = %False                    ' Set NEXT

   IF ISFALSE PTBL.FlgLit1 THEN _                                 ' Lit1 present?
      MErrExit(%eFail, "Missing SPLIT search string")             '
   IF ISFALSE PTBL.FlgLit2 THEN _                                 ' Lit2 present?
      MErrExit(%eFail, "Missing SPLIT change string")             '
   IF (ISFALSE PTBL.FlgL2Format AND ISFALSE PTBL.FlgL2Picture) OR _  ' Lit2 must be F or P type
      PTBL.SplitPoint2 = 0 THEN _                                 ' Lit2 must have a | char
      MErrExit(%eFail, "SPLIT change string must be P or F'..|..' type literal") '
   LocFind = "SPLIT"                                              ' Remember which LOC / FIND command was last
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values

   IF PTBL.FlgAll THEN                                            ' The ALL version?
      RESET AllCount                                              ' Reset variables
      i = me.Search(0, @P.C.CType)                                ' Do the initial search
      IF i THEN                                                   '
         IF RSRCH THEN MExitMeth                                  ' Done if RSRCH
         me.Split()                                               ' Do the Split
         IF RCHNG THEN MExitMeth                                  ' Done if RCHNG
         INCR AllCount                                            ' Count
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         i = me.Search(1, %CNext)                                 ' Do re-Finds
         IF i THEN                                                ' Found one
            IF RSRCH THEN MExitMeth                               ' Done if RSRCH
            me.Split()                                            ' Do the Split
            IF RCHNG THEN MExitMeth                               ' Done if RCHNG
            INCR AllCount                                         ' Count successful
         END IF                                                   '
      LOOP                                                        '
      IF AllCount = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(nMac(%eFail), "Split point not found")      '
      ELSE                                                        '
         TP.ErrMsgAdd(0, "Split performed " + FORMAT$(Allcount) + " times")   '
      END IF                                                      '

   ELSE                                                           ' The non-All version
      i = me.Search(0, @P.C.CType)                                ' Go see if we can find it
      IF i = 0 THEN                                               ' Got it?
         TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 2, 1)               ' Remember we failed
      ELSE                                                        '
         IF RSRCH THEN MExitMeth                                  ' Done if RSRCH
         me.Split()                                               ' Do the Split
         IF RCHNG THEN MExitMeth                                  ' Done if RCHNG
         TP.ErrMsgAdd(%eNone, "Split successful")                 '
         ErrMsgHigh = %eNone                                      ' Say we 're OK
      END IF                                                      '
   END IF                                                         '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSTART(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Set START profile value                                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL nv AS LONG                                                  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispStart, _                                        ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "START requires an operand")   '
   FCB.Start = PTBL.Grp("HOW")                                    ' Get the answer
   SELECT CASE AS CONST$ FCB.Start                                '
      CASE "PRIOR", "LABEL", "NEW"                                ' Need STATE
         IF FCB.StateFlag = %StateOff THEN _                      ' If we're not even doing STATE
            DoMessageBox("|KWarning:|B START=" + FCB.Start + " requires STATE=ON to fnction", %MB_OK + %MB_USERICON, "SPFLite")  '
   END SELECT                                                     '
   DispStart:                                                     '
   MErrExit(%eNone, "START set to "+ FCB.Start)                   ' Dispay status
END METHOD                                                        '

METHOD  pCmdSTATE(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Set State save ststus                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL nv, RC AS LONG, lclFn, t AS STRING                          '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispState, _                                        ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "STATE requires an operand")   ' No Ops?
   t = PTBL.Grp("HOW")                                            ' What did we get
   SELECT CASE AS CONST$ t                                        '
      CASE "OFF"    : nv = %StateOff                              '
      CASE "ON"     : nv = %StateOn                               '
      CASE "FEW"    : nv = %StateFew                              '
      CASE "MOST"   : nv = %StateMost                             '
      CASE "DELETE":                                              ' Delete immediate request?
         IF FCB.FilePath = $New OR _                              ' Bad mode?
            IsBrowse OR  _                                        '
            IsView OR  _                                          '
            IsSetEdit OR _                                        ' SetEdit?
            IsEFTEdit OR _                                        ' EFTEdit?
            IsClip THEN _                                         ' Clip?
            MErrExit(%eFail, "STATE DELETE allowed only for normal Edit sessions")  '
         IF FCB.StateFlag <> %StateMost THEN _                    ' Only acceptable if STATE MOST
            MErrExit(%eFail, "STATE DELETE allowed only if STATE MOST is in effect")   '
         lclFn = FCB.FilePath + ".STATE"                          ' Temp copy with .STATE on the end
         REPLACE ANY ":\/" WITH "```" IN lclFN                    ' Make : / and \ into `
         lclFn = gENV.HomeData + "STATE\" + lclFn                 ' Add our STATE folder
         MakeNullFile(lclFn)                                      ' Create the nullfile
         OffStateExist                                            ' Kill the exists flag
         DoStatusBar($SBState)                                    ' re-Do the StatusBar boxes
         MErrExit(0, "STATE exemption set for the current file")  ' Tell user

      CASE "CREATE":                                              '
         IF FCB.StateFlag <> %StateFew THEN _                     ' Only acceptable if STATE FEW
            MErrExit(%eFail, "STATE CREATE allowed only if STATE FEW is in effect") '
         OnStateForce                                             ' Force StateSave to override FEW
         MErrExit(%eNone, "The next SAVE/END will create STATE data")   '

      CASE "SAVE"                                                 '
         IF IsMEdit THEN MErrExit(%eFail, "STATE SAVE not supported in MEdit mode, use a full SAVE")  '
         RC = me.StateSave(FCB.FilePath, 1, LastLine, %False)     ' Go setup/refresh STATE data
         IF ISFALSE RC THEN MErrExit(%eNone, "File STATE information updated/Created.")   '
         IF ISTRUE  RC THEN MErrExit(%ENone, "File STATE saving was skipped.")   '

   END SELECT                                                     '
   IF nv = %StateOff AND FCB.StateFlag > %StateOff THEN           ' Going from some kind of ON to OFF?
      IF FCB.Start = "PRIOR" OR FCB.Start = "LABEL" OR FCB.Start = "NEW" THEN ' A dependant START option?
         DoProfMsg("STATE set to OFF, START also set back to FIRST") '
         FCB.Start = "FIRST"                                      ' Reset the START value
      END IF                                                      '
      FCB.StateFlag = nv                                          ' Set the new value
      MExitMeth                                                   '
   END IF                                                         '
   FCB.StateFlag = nv                                             ' Set the new value
   DispState:                                                     '
   DoProfMsg("STATE set to " + CHOOSE$(FCB.StateFlag + 1, "OFF", "ON", "FEW", "MOST")) '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSUBARG(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Set SUBMIT default argument for current profile                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL MSG AS STRING                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispSubArg, _                                       ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "SUBARG requires an operand")  '
   IF UCASE$(PTBL.Ops(1)) = "OFF" THEN                            ' What've we got
      FCB.SubArg = ""                                             '
   ELSE                                                           ' Save anything else
      FCB.SubArg = PTBL.Pos2(1)                                   '
   END IF                                                         '
   DispSubArg:                                                    '
   DoProfMsg(MSG + "SUBARG is " + IIF$(ISNULL(FCB.SubArg), "OFF", FCB.SubArg))   '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSUBCMD(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Set SUBMIT command for current profile                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL MSG AS STRING                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispSubCmd, _                                       ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "SUBCMD requires an operand")  '
   IF UCASE$(PTBL.Ops(1)) = "OFF" THEN                            ' What've we got
      FCB.SubCmd = ""                                             '
   ELSE                                                           ' Save anything else
      FCB.SubCmd = PTBL.Pos2(1)                                   '
   END IF                                                         '
   DispSubCmd:                                                    '
   DoProfMsg(MSG + "SUBCMD is " + IIF$(ISNULL(FCB.SubCmd), "OFF", FCB.SubCmd))   '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSubInclude(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Set SubInclude path for current profile                                                         |
'--------------------------------------------------------------------------------------------------+
LOCAL MSG AS STRING                                               '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO DispSubInc, _                                       ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN MErrExit(%eFail, "SubInclude requires an operand")  '
   IF UCASE$(PTBL.Ops(1)) = "NONE" THEN                           ' What've we got
      FCB.SubInclude = "$NONE$"                                   '
   ELSE                                                           ' Save anything else
      FCB.SubInclude = PTBL.Pos2(1)                               '
   END IF                                                         '
   DispSubInc:                                                    '
   DoProfMsg(MSG + "SubInclude is " + IIF$(FCB.SubInclude = "$NONE$", "NONE", FCB.SubInclude))   '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdSUBMIT(pCmd AS STRING)                                '
'--------------------------------------------------------------------------------------------------+
'- Do the SUBMIT process                                                                           |
'--------------------------------------------------------------------------------------------------+
LOCAL lclCmd, lclWord, DCmd, t, JobName, W1, W2, W3, w4, BATFile, INCLFile, NewCmd AS STRING '
LOCAL i, j AS LONG                                                '
LOCAL lclTop, recs, BrkStart, hWatchThread, MSG, FNum, FNum2, TOnce AS LONG   '
LOCAL lclDrive, lclPath, CBLines AS STRING                        '
LOCAL fptr AS STRING POINTER                                      '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.   NOTE: Because of the [Dos operands style] only Basic Parsing   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic parse
         pCmdHelp("H SUBMIT"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF ISNOTNULL(FCB.SubCmd) THEN                                  ' SUBCMD specified?
      IF IsEQ(FCB.SubCmd, "SUB") OR IsEQ(FCB.SubCmd, "SUBMIT") THEN _   '
         MErrExit(%EFail, "Recursive SUBCMD detected")            '
      lclcmd = pCmd                                               ' Get the command line
      lclWord = GetNextWord(lclCmd, %Strip)                       ' Strip the 1st word
      me.pCmdRun(FCB.SubCmd + " " + lclCmd)                       ' Handle as a different command
      MExitMeth                                                   '
   END IF                                                         '
   gDosOperands = "": gResultFile = ""                            ' Null

   '-----------------------------------------------------------------------------------------------+
   '- Extract any DOS operands, rebuild the rest in NewCmd                                         |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO PTBL.OpsNum                                       ' Extract the operands
      t = PTBL.Ops(i)                                             ' Get into work field
      IF LEFT$(t, 1) = "["  AND ISFALSE BrkStart THEN             ' Start of DOS operands?
         BrkStart = %True                                         ' Say we've started
         gDosOperands = MID$(t, 2) + " "                          ' Start the string
         ITERATE FOR                                              ' Done with this one
      END IF                                                      '
      IF RIGHT$(t, 1) = "]"  AND BrkStart THEN                    ' End of DOS operands?
         BrkStart = %False                                        ' Say we've done the [...]
         gDosOperands += CLIP$(RIGHT, t, 1)                       ' End the string
         ITERATE FOR                                              ' Done with this one
      END IF                                                      '
      IF BrkStart THEN                                            ' Building DOS commands?
         gDosOperands += t + " "                                  ' Add it
         ITERATE FOR                                              ' Done with this
      END IF                                                      '
      NewCmd += t + " "                                           ' Add to NewCmd
      IF BrkStart THEN                                            ' Already building operands?
         gDosOperands += t + " "                                  ' Add as simple operand
         ITERATE FOR                                              ' Onward
      END IF                                                      '
   NEXT i                                                         '
   IF BrkStart THEN MErrExit(%eFail, "Missing closing ] ")        ' Oops

   '-----------------------------------------------------------------------------------------------+
   '- Re-parse it now with DOS commands removed                                                    |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd("SUB " + NewCmd, %PAll), _                 ' Try the basic parse
         pCmdHelp("H SUBMIT"), _                                  ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   gENV.Jobnumber = gENV.Jobnumber + 1                            ' Bump it
   gJobID = "JOB" + FORMAT$(gENV.Jobnumber, "00000")              ' Build ID

   PTBL.FlgDX = %True                                             ' Tell search hands off Invisible status

   IF ISFALSE PTBL.FindRngSet AND _                               ' If no line range
      ISFALSE PTBL.FlgU AND ISFALSE PTBL.FlgNU AND ISFALSE PTBL.FlgX AND ISFALSE PTBL.FlgNX THEN   ' Or U / NU / X / NX
      PTBL.FlgAll = %True                                         ' Force ALL if no modifiers
   END IF                                                         '

   Msg = PTBL.IsKwd("DEBUG")                                      ' Collect DEBUG keyword
   ErrMsgHigh = %eNone                                            ' Reset any Pending conflict flag
   lclTop = @P.PTopLine                                           '

   i = me.Search(0, @P.C.CType)                                   ' Do the initial search
   IF i THEN                                                      ' We have the 1st SUBMIT line
      t = UUCASE(LTxtG(PTBL.FoundLine))                           ' Get it's text
      w1 = GetNextWord(t, %Strip)                                 ' Get the 1st 4 'words'
      w2 = GetNextWord(t, %Strip)                                 '
      w3 = GetNextWord(t, %Strip)                                 '
      w4 = GetNextWord(t, %Strip)                                 '
      IF w1 = "//" AND w2 = "JOB" THEN                            ' DOS Job card?
         Jobname = w3                                             ' 3rd operand is JobName
      ELSEIF LEFT$(w1, 2) = "//" AND w2 = "JOB" THEN              ' OS Job card?
         JobName = MID$(w1, 3)                                    ' Then jobname follows the //
      ELSEIF w1 = "*" AND w2 = "$$" AND w3 = "JOB" AND LEFT$(w4, 4) = "JNM=" THEN   ' Power JCl?
         IF INSTR(w4, ",") > 0 THEN                               ' Trailing comma?
            JobName = MID$(LEFT$(w4, INSTR(w4, ",") - 1), 5)      ' Extract it
         ELSE                                                     '
            JobName = MID$(w4, 5)                                 '
         END IF                                                   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Ready the output file                                                                     |
      '--------------------------------------------------------------------------------------------+
      IF ISNOTNULL(JobName) THEN                                  ' If we have a JobName
         gSubmitFile = gENV.SubmitDir + "\SUBMIT_" + JobName + "_" + gJobID + FCB.Extn ' Get SUBMIT temp file allocated
      ELSE                                                        '
         gSubmitFile = gENV.SubmitDir + "\SUBMIT_" + gJobID + FCB.Extn  ' Get SUBMIT temp file allocated
      END IF                                                      '
      FNum = FREEFILE                                             ' Get a File Number
      Call3(TryOpenOutPut(gSubMitFile, FNum), _                   ' Try the open
            MErrExit(%eFail, "SUBMIT Write Open failed"), _       ' Oops?  Bail out
            MErrExit(%eFail, "SUBMIT File is in use"), _          ' Oops?  Bail out
            Nul)                                                  ' Continue
      GOSUB PutOne                                                ' Go handle one
   END IF                                                         '
   DO WHILE i                                                     ' Do till not found
      i = me.Search(1, %CNext)                                    ' Do re-Finds
      IF i THEN GOSUB PutOne                                      ' Found one
   LOOP                                                           '
   CLOSE #FNum                                                    ' Close the FBO

   IF INSTR(UUCASE(gENV.SubmitCmd), "~R") > 0 OR _                ' Results file being requested?
      INSTR(UUCASE(gENV.SubmitCmd), "^R") > 0 THEN                '
      IF ISNOTNULL(JobName) THEN                                  ' Base on Jobname
         gResultFile = gENV.SubmitDir + "\SUBRESULTS_" + JobName + "_" + gJobID + ".Txt"  '
      ELSE                                                        '
         gResultFile = gENV.SubmitDir + "\SUBRESULTS_" + gJobID + ".txt"   '
      END IF                                                      '
      MakeNullFile(gResultFile)                                   ' Create as empty file

      '--------------------------------------------------------------------------------------------+
      '- Start the File Watch                                                                      |
      '--------------------------------------------------------------------------------------------+
      fptr = VARPTR(gResultFile)                                  '
      THREAD CREATE FileWatchSubmitThread(BYVAL fptr) 65536, TO hWatchThread  ' Fire up the thread
      IF hWatchThread = 0 THEN _                                  ' Failed?
         MErrExit(%eFail, "Watch of Result file could not be started")  '
      SLEEP 50                                                    ' Wait a bit
      THREAD STATUS hWatchThread TO i                             ' See if running OK
      IF i <> 259 THEN _                                          ' If running OK STATUS returns &H103 (See Help)
         MErrExit(%eFail, "Watch of Result file could not be started")  '
      THREAD CLOSE hWatchThread TO i                              ' Free up our handle
      SLEEP 1000                                                  '
   END IF                                                         '
   DCmd = gENV.SubmitCmd                                          ' Get the SUBMIT command
   gSubmitType = "S"                                              ' Set Submit type
   IF me.MacSubst(DCmd) THEN _                                    ' Do substitution
      MErrExit(%EFail, "Malformed macro operand in SUBMIT prototype command") '

'-  debug DCmd
   '-----------------------------------------------------------------------------------------------+
   '- Create the BAT file                                                                          |
   '-----------------------------------------------------------------------------------------------+
   BATFile = gENV.HomeFolder + "SPFBatch.BAT"                     '
   FNum = FREEFILE                                                ' Get a File Number
   Call3(TryOpenOutPut(BATFile, FNum), _                          ' Try the open
         MErrExit(%eFail, "SUBMIT Write Open failed"), _          ' Oops?  Bail out
         MErrExit(%eFail, "SUBMIT File is in use"), _             ' Oops?  Bail out
         Nul)                                                     ' Continue
   PRINT # FNum, DCmd                                             ' Write the command out
   IF ISFALSE MSG THEN PRINT # FNum, "EXIT"                       ' Close the BAT file if not in DEBUG mode
   CLOSE #FNum                                                    ' Close the File

   '-----------------------------------------------------------------------------------------------+
   '- Switch to the EXE path                                                                       |
   '-----------------------------------------------------------------------------------------------+
   lclPath = CURDIR$                                              ' Locate where we are
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save it

   IF MID$(gENV.SubmitDir, 2, 1) = ":" THEN _                     ' See if Submit Path has drive
      CHDRIVE LEFT$(gENV.SubmitDir, 2)                            ' If so, go to it
   CHDIR gENV.SubmitDir                                           ' Switch to EXE path

   '-----------------------------------------------------------------------------------------------+
   '- Fire it up based on DEBUG / NODEBUG                                                          |
   '-----------------------------------------------------------------------------------------------+
   gLoopCtr = -1                                                  ' Suspend loop detection
   IF MSG THEN                                                    ' MSG
      t = ENVIRON$("COMSPEC") + " /K " + GetShortName(gENV.HomeFolder + "SPFBatch.bat")   '
      SHELL t, 1                                                  '
   ELSE                                                           ' MSG omitted
      t = ENVIRON$("COMSPEC") + " /C " + GetShortName(gENV.HomeFolder + "SPFBatch.bat")   '
      SHELL t, 0                                                  '
   END IF                                                         '
   RESET gLoopCtr                                                 ' Reset the counter

   '-----------------------------------------------------------------------------------------------+
   '- Check for errors                                                                             |
   '-----------------------------------------------------------------------------------------------+
   IF ERR THEN _                                                  ' Tell user result
      MErrExit(%eFail, "Error issuing SUBMIT " + ERROR$)          '

   '-----------------------------------------------------------------------------------------------+
   '- Restore PATH                                                                                 |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(lclDrive) THEN CHDRIVE lclDrive                   ' Switch drive if needed
   CHDIR lclPath                                                  ' put back the original path
   @P.PTopLine = lclTop                                           '

   '-----------------------------------------------------------------------------------------------+
   '- We're all done!                                                                              |
   '-----------------------------------------------------------------------------------------------+
   TP.ErrMsgAdd(0, FORMAT$(recs) + IIF$(recs <> 1, " lines", " line") + " submitted for " + IIF$(ISNULL(JobName), "(JOB", JobName + "(JOB") + FORMAT$(gENV.Jobnumber, "00000") + ")")  '
   MExitMeth                                                      '

PutOne:                                                           '
   IF IsLInsertLine(PTBL.FoundLine) THEN RETURN                   ' Exempt Insert lines
   t = LTxtG(PTBL.FoundLine)                                      ' Get the text
   IF uucase(MID$(t, gENV.SubmitInclCol, LEN(gENV.SubmitInclKey))) <> uucase(gENV.SubmitInclKey) THEN ' If not an #INCLUDE line
      PRINT # FNum, t                                             ' Just write the line to SUBMIT file
      INCR recs                                                   ' count it
   ELSE                                                           ' Else do the INCLUDE
      INCLFile = TRIM$(MID$(t, gENV.SubmitInclCol + LEN(gENV.SubmitInclKey))) ' Get the INCLUDE Filename
      StrUnQuote(INCLFile)                                        ' Remove any quotes
      IF INSTR(INCLFile, "\") = 0 THEN                            ' Already include a parh?
         IF FCB.SubInclude = "$NONE$" THEN                        ' No, is there a SubInclude path
            INCLFile = FCB.Path + INCLFile                        ' No, add the current file's path
         ELSE                                                     ' Yes, SubInclude exists
            INCLFile = FCB.SubInclude + INCLFile                  ' Use that
         END IF                                                   '
      END IF                                                      '
      IF ISFALSE ISFILE(INCLFile) THEN                            ' If it doesn't exist
         MErrExit(%EFail, "#INCLUDE filename (" + INCLFile + ") not found")   '
      END IF                                                      '

      '--------------------------------------------------------------------------------------------+
      '- Setup to read the Included filename                                                       |
      '--------------------------------------------------------------------------------------------+
      FNum2 = FREEFILE: TOnce = %False                            ' Get another file #, RESET TOnce
      Call3(TryOpenInput(INCLFile, FNum2), _                      ' Try the open
            MErrExit(%eFail, "SUBMIT INCLUDE file doesn't exist"), _ ' Oops?  Bail out
            MErrExit(%eFail, "OPEN of SUBMIT INCLUDE file failed"), _   ' Oops?  Bail out
            Nul)                                                  ' Continue
      '--------------------------------------------------------------------------------------------+
      '- Extract CBlines to the output file                                                        |
      '--------------------------------------------------------------------------------------------+
      DO WHILE ISFALSE EOF(# FNum2)                               ' Loop reading lines
         LINE INPUT # FNum2, t                                    ' Get one line
         '-----------------------------------------------------------------------------------------+
         '- Test for UTF fileo the output file                                                     |
         '-----------------------------------------------------------------------------------------+
         IF TOnce = %False THEN                                   ' Test for UTF?
            TOnce = %True                                         ' Flip it
            IF LEFT$(t, 3) = $UTF8 THEN                           ' UTF8?
               t = CLIP$(LEFT, t, 3)                              ' Remove it
            ELSEIF LEFT$(t, 2) = $UTF16LE OR _                    ' UTF16LE?
               LEFT$(t, 2) = $UTF16BE THEN                        ' UTF16BE?
               MErrExit(%eFail, "#INCLUDE does not support UTF16 format files")  ' Oops?  Bail out
            ELSEIF LEFT$(t, 4) = $UTF32BE OR _                    ' UTF32BE?
               LEFT$(t, 2) = $UTF32LE THEN                        ' UTF32LE?
               MErrExit(%eFail, "#INCLUDE does not support UTF32 format files")  ' Oops?  Bail out
            END IF                                                '
         END IF                                                   '
         t = TAB$(t, FCB.ImportTabs)                              ' Do any needed tab conversion
         PRINT # FNum, t                                          ' Just write the line to SUBMIT file
         INCR recs                                                ' count it
      LOOP                                                        ' Loop till all lines extracted
      CLOSE # FNum2                                               '
   END IF                                                         '
   RETURN                                                         '

END METHOD                                                        '

METHOD  pCmdSWAP(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Switch tab Pages                                                                                |
'--------------------------------------------------------------------------------------------------+
LOCAL i AS LONG, t AS STRING                                      '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic parse
         pCmdHelp("H SWAP"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   '-----------------------------------------------------------------------------------------------+
   '- See what we got                                                                              |
   '-----------------------------------------------------------------------------------------------+
   t = PTBL.Grp("WHICH")                                          ' Get the entry
   SELECT CASE AS CONST$ t                                        ' Split off
      CASE "NEXT"                                                 '
         i = IIF(PgNumber = gTabsNum, 1, PgNumber + 1)            ' Calc tab # we're going to
      CASE "PREV"                                                 '
         i = IIF(PgNumber > 1, PgNumber - 1, gTabsNum)            ' Calc tab # we're going to
      CASE "PRIOR"                                                '
         i = IIF(gTabStackNum > 1, gTabStack(2), 0)               ' Get previous page number
         IF i = 0 OR i > gTabsNum THEN i = 1                      ' Don't go to non-existant tab
      CASE "FIRST"                                                '
         i = IIF(gTabsNum > 1, 2, 1)                              ' First real tab (or FM if no Edit tabs)
      CASE "HOME"                                                 '
         i = 1                                                    ' FM tab
      CASE "LAST"                                                 '
         i = gTabsNum                                             ' Goto last tab
      CASE "OPEN", "LIST"                                         '
         pCmdRecall("RECALL OPEN")                                '
         MExitMeth                                                '
   END SELECT                                                     '
   CmdStackNum = 0                                                ' If a swap, no more commands allowed
   GoToTab(i, "", "")                                             ' Set tab to go to
   MExitMeth                                                      '
END METHOD                                                        '

METHOD  pCmdTABS(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Set TABS or do a Query                                                                          |
'--------------------------------------------------------------------------------------------------+
   FCB.Tabs = GetOnOff(1, FCB.Tabs, PCmd)                         ' Let GetOnOff do all the work
END METHOD                                                        '

METHOD  pCmdTABBNDS(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Set TABBNDS or do a Query                                                                       |
'--------------------------------------------------------------------------------------------------+
   FCB.TabBNDS = GetOnOff(1, FCB.TabBNDS, PCmd)                   ' Let GetOnOff do all the work
   DoStatusBar($SBInsOvr)                                         ' re-Do the StatusBar Ins/Ovr box
END METHOD                                                        '

METHOD  pCmdTAG(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- TAG command                                                                                     |
'--------------------------------------------------------------------------------------------------+
LOCAL action, lclTag, valid, t, NewCmd AS STRING                  '
LOCAL i, AllCount AS LONG                                         '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff.                                                                  |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic parse
         pCmdHelp("H TAG"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   IF PTBL.OpsNum = 0 THEN _                                      ' Exit if nothing to do
      MErrExit(%eFail, "Missing TAG operands")                    '
   '-----------------------------------------------------------------------------------------------+
   '- Extract the 1st tag operand, then rescan                                                     |
   '-----------------------------------------------------------------------------------------------+
   FOR i = 1 TO PTBL.OpsNum                                       ' Extract the operands
      t = PTBL.Ops(i)                                             ' Get into work field
      IF LEFT$(t, 1) = ":" AND LEN(t) > 1 AND ISNULL(lclTag) THEN ' The TAG?
         lclTag = LSET$(UUCASE(t), 8)                             ' Save it
         ITERATE FOR                                              ' Done with this one
      END IF                                                      '
      NewCmd += t + " "                                           ' Add to NewCmd, including any other tags
   NEXT i                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Re-parse it now with the 1st TAG removed                                                     |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd("TAG " + NewCmd, %PAll), _                 ' Try the edited command now
         pCmdHelp("H TAG"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue

   PTBL.FlgON = %FALSE: PTBL.FlgOff = %False: PTBL.FlgToggle = %False: PTBL.FlgSet = %False  '
   t = PTBL.Grp("WHICH")                                          ' Get the Mode
   SELECT CASE AS CONST$ t                                        '
      CASE "ON":       PTBL.FlgON = %True                         '
      CASE "OFF":      PTBL.FlgOff = %True                        '
      CASE "TOGGLE":   PTBL.FlgToggle = %True                     '
      CASE "SET":      PTBL.FlgSet = %True                        '
   END SELECT                                                     '
   me.ResetFunc(%ResetFind)                                       ' Clear previous FIND hilighting

   IF (PTBL.FlgOn OR PTBL.FlgSet OR PTBL.FlgToggle) AND ISNULL(lcltag) THEN _ '
      MErrExit(%eFail, "Target tag was not provided for " + IIF$(PTBL.FlgOn, "ON", IIF$(PTBL.FlgSet, "SET", "TOGGLE"))) '

   IF PTBL.FlgALL AND ISFALSE PTBL.FindRngSet AND ISFALSE PTBL.FlgLit1 AND _  '
      ISNULL(lcltag) AND ISFALSE PTBL.FlgOff AND _                '
      ISFALSE PTBL.FlgX AND ISFALSE PTBL.FlgNX THEN _             '
      MErrExit(%eFail, "ALL specified but no line range or search literal")   '

   IF ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast AND _        '
      ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _         '
      (ISTRUE PTBL.FindRngSet OR ISTRUE PTBL.FlgLit1) THEN _      '
         PTBL.FlgAll = %True                                      ' Default to All

   IF ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast AND _        '
      ISFALSE PTBL.FlgNext AND ISFALSE PTBL.FlgPrev AND _         '
      (ISFALSE PTBL.FindRngSet AND ISNOTNULL(lclTag)) THEN _      '
         PTBL.FlgAll = %True                                      ' Default to All

   IF ISFALSE PTBL.FlgLit1 THEN                                   ' Lit1 present?
      IF ISFALSE PTBL.FlgAll AND ISFALSE PTBL.FlgFirst AND ISFALSE PTBL.FlgLast THEN   ' No Lit1, better have ALL or a limit
         MErrExit(%eFail, "No search string, but no ALL/FIRST/LAST specified")   '
      END IF                                                      '
      IF PTBL.FlgWord OR PTBL.FlgPrefix OR PTBL.FlgSuffix OR _    ' No extraneous operands
         PTBL.FlgFCol OR PTBL.FlgTCol THEN  _                     '
         MErrExit(%eFail, "No search string, but string options are present") '
      IF PTBL.FlgNF THEN _                                        ' No Literal and NF asked for?
         MErrExit(%eFail, "No search string, but NF request is present")   '
   END IF                                                         '

   AllCount = 0                                                   ' Reset counter
   IF PTBL.FlgOn THEN                                             ' Build message text
      action = "Tag set ON on "                                   '
   ELSEIF PTBL.FlgOff THEN                                        '
      action = "Tagged set OFF on "                               '
   ELSEIF PTBL.FlgToggle THEN                                     '
      action = "Tag Toggled on "                                  '
   ELSEIF PTBL.FlgSet THEN                                        '
      action = "Tag SET modified "                                '
   END IF                                                         '
   RESET AllCount, Found1stLin, Found1stCol, Found1stLen, FoundLstLin, FoundLstCol, FoundLstLen ' Reset 1st found values
   IF PTBL.FlgAll THEN                                            ' The ALL version?
      IF PTBL.FlgNF THEN                                          ' Choose search routine based on NF status
         i = me.NFSearch(0, @P.C.CType)                           ' NF version
      ELSE                                                        '
         i = me.Search(0, @P.C.CType)                             ' Normal version
      END IF                                                      '
      IF i THEN                                                   ' See if we have one
         IF PTBL.FlgSet THEN _                                    ' If SET clear it so sTagChange will always set it
            LTagS(PTBL.FoundLine) = $BlankLNo                     '
         AllCount += me.TagChange(lclTag)                         ' Go do the Tag Change
      END IF                                                      '
      DO WHILE i                                                  ' Do till not found
         IF PTBL.FlgNF THEN                                       ' Choose search routine based on NF status
            i = me.NFSearch(1, %CNext)                            ' NF version
         ELSE                                                     '
            i = me.Search(1, %CNext)                              ' Normal version
         END IF                                                   '
         IF i THEN                                                '
            IF PTBL.FlgSet THEN _                                 ' If SET clear it so sTagChange will always set it
               LTagS(PTBL.FoundLine) = $BlankLNo                  '
            AllCount += me.TagChange(lclTag)                      ' Go do the Tag Change
         END IF                                                   '
      LOOP                                                        '
      IF AllCount = 0 THEN                                        ' Issue approp. message
         TP.ErrMsgAdd(nMac(%eFail), "No lines (re)tagged")        '
      ELSE                                                        '
         IF PTBL.FlgSet THEN GOSUB ClearRest                      ' If SET then clear all the rest
         TP.ErrMsgAdd(0, action + FORMAT$(AllCount) + IIF$(AllCount > 1, " lines", " line")) '
      END IF                                                      '
   ELSE                                                           ' The non-All version
      IF PTBL.FlgNF THEN                                          ' Choose search routine based on NF status
         i = me.NFSearch(0, @P.C.CType)                           ' NF version
      ELSE                                                        '
         i = me.Search(0, @P.C.CType)                             ' Normal version
      END IF                                                      '
      IF i THEN                                                   ' Did we find it
         IF PTBL.FlgSet THEN LTagS(PTBL.FoundLine) = $BlankLNo    ' If SET clear it so sTagChange will always set it
         me.TagChange(lclTag)                                     ' Go do the change
         IF PTBL.FlgSet THEN GOSUB ClearRest                      ' If SET then clear all the rest
      ELSE                                                        ' Not found, issue message
         TP.ErrMsgAdd(nMac(%eFail), IIF$(PTBL.FlgNext, "Bottom of data reached", "Top of data reached")) '
         PTBL.FoundFailed = IIF(PTBL.FlgNext, 1, 2)               ' Remember we failed
      END IF                                                      '
   END IF                                                         '
   gfXRebuild = %True                                             ' Force exclude rebuild
   OnUndoFlag                                                     ' Remember we changed something
   MExitMeth                                                      '

ClearRest:                                                        '
   FOR i = 1 TO LastLine                                          ' Reset tags for non-SET winners
      IF ISFALSE IsLData(i) THEN ITERATE FOR                      ' Just do data lines
      IF LTagG(i) = lclTag THEN ITERATE FOR                       ' Also ignore if a SET winner
      IF LTagG(i) = $BlankLNo THEN ITERATE FOR                    ' Also ignore if blank tag
      LTagS(i) = $BlankLNo                                        ' A loser, blank the tag
      me.UpdLControl(i)                                           ' Reset line number
      INCR AllCount                                               '
   NEXT i                                                         '
   RETURN                                                         '
END METHOD                                                        '

METHOD  pCmdTEST(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- TEST - Run the SPFTest program                                                                  |
'--------------------------------------------------------------------------------------------------+
LOCAL Oprand, lclcmd AS STRING                                    '
LOCAL RetC AS LONG                                                '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H TEST"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   Oprand = "1"                                                   ' RegEx, others were removed
   lclcmd = $DQ + gENV.EXEPath + "SPFTest.EXE" + $DQ + " 1"       '
   RetC = SHELL(lclcmd, 1)                                        '
   IF ERR THEN MErrExit(%eFail, "Error issuing command " + ERROR$)   ' Tell user result
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdTOP(pCmd AS STRING)                                   '
'--------------------------------------------------------------------------------------------------+
'- Alias for UP MAX                                                                                |
'--------------------------------------------------------------------------------------------------+
   MEntry                                                         '
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H TOP"), _                                     ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   pCmdUP("UP MAX ")                                              '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdUP(pCmd AS STRING)                                    '
'--------------------------------------------------------------------------------------------------+
'- Scroll UP                                                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL ScrAmt, ForceLine, Lines2Page AS LONG, ScrCmd AS STRING   '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H UP"), _                                      ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum > 1 THEN _                                      ' Better be just one operand
      MErrExit(%eFail, "Invalid scroll amount")                   '
   IF PTBL.OpsNum = 0 THEN                                        ' No Ops, fudge it
      ScrCmd = FCB.ScrollAmt                                      ' Pick up Profile value
   ELSE                                                           '
      ScrCmd = PTBL.Grp("SCROLL")                                 ' Else pick up from command
      IF ISNULL(ScrCmd) THEN ScrCmd = PTBL.Pos("#", 1)            ' If not Kwd, then fetch the #
   END IF                                                         '

   IF VAL(ScrCmd) <> 0 THEN                                       ' A Number?
      ScrAmt = VAL(ScrCmd)                                        ' Yes, use it
   ELSEIF ScrCmd = "HALF" THEN                                    ' Half?
      ScrAmt = INT((@P.PDLines) / 2)                              ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   ELSEIF ScrCmd = "PAGE" THEN                                    ' Page?
      ScrAmt = @P.PDLines                                         ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
      FCB.ScrlPageSus = %False                                    ' Clear suspend PAGE mode
   ELSEIF ScrCmd = "FULL" THEN                                    ' Full?
      ScrAmt = @P.PDLines                                         ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   ELSEIF ScrCmd = "DATA" THEN                                    ' Data?
      ScrAmt = @P.PDLines - 1                                     ' Yes, set it
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   ELSEIF ScrCmd = "MAX" THEN                                     ' Max?
      ScrAmt = 9999999                                            ' Yes, set a BIG number
   ELSEIF IsCData THEN                                            ' No, In data area?
      ForceLine = me.CRPBack(%mVisible, @P.C.CIX, @P.PDLines - 1) ' Backup by screensize to put line on bottom
      IF ForceLine <> me.SGet(@P.PData1 + 1) THEN                 ' As long as we move
      ELSE                                                        ' Else kill ForceLine
         ForceLine = 0                                            '
         ScrAmt = @P.PDLines - 1                                  ' Go back 1 screen
         ScrAmt = ScrAmt \ FCB.HexMode                            ' Adjust for Hex
      END IF                                                      '
   ELSEIF IsCLinN THEN                                            ' No, In Line Number area?
      ForceLine = me.CRPBack(%mVisible, @P.C.CIX, @P.PDLines - 1) ' Backup by screensize to put line on bottom
      IF ForceLine <> me.SGet(@P.PData1 + 1) THEN                 ' As long as we move
      ELSE                                                        ' Else kill ForceLine
         ForceLine = 0                                            '
         ScrAmt = @P.PDLines - 1                                  ' Go back 1 screen
         ScrAmt = ScrAmt \ FCB.HexMode                            ' Adjust for Hex
      END IF                                                      '
   ELSE                                                           '
      ScrAmt = @P.PDLines - 1                                     ' No, Scroll back one screen - 1
      ScrAmt = ScrAmt \ FCB.HexMode                               ' Adjust for Hex
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Adjust the top of screen location now                                                        |
   '-----------------------------------------------------------------------------------------------+
   IF LEFT$(FCB.EOL, 4) = "AUTO" AND ScrCmd = "PAGE" THEN         ' Page in EOL=AUTO mode?
      IF FCB.PageFlag = 2 THEN                                    ' Page SCROLL?
         Lines2Page = me.CRPBack2Page                             ' Get # lines to previous =PAGE> line (or top)
         IF Lines2Page <= @P.PDLines THEN                         ' Will this page all fit on the screen?
            @P.PTopLine = me.CRPBack(%mPage, @P.PTopLine, 1)      ' Move TopScrn by a PAGE
         ELSE                                                     '
            ScrAmt = @P.PDLines                                   ' Calc like FULL does
            ScrAmt = ScrAmt \ fcb.HexMode                         '
            @P.PTopLine = me.CRPBack(%mVisible, @P.PTopLine, ScrAmt) ' Move TopScrn by scroll amount
            FCB.ScrlPageSus = %False                              '
         END IF                                                   '
      ELSEIF FCB.PageFlag = 1 THEN                                ' PAGE ON mode?
         @P.PTopLine = me.CRPBack(%mPage, @P.PTopLine, 1)         ' Move TopScrn by a PAGE
      ELSE                                                        '
         @P.PTopLine = me.CRPBack(%mVisible, @P.PTopLine, ScrAmt) ' Move TopScrn by scroll amount
      END IF                                                      '
   ELSE                                                           ' Not AUTO PAGE
      IF ForceLine = 0 THEN                                       ' If we haven't already calculated it
         @P.PTopLine = me.CRPBack(%mVisible, @P.PTopLine, ScrAmt) ' Move TopScrn by scroll amount
      ELSE                                                        '
         @P.PTopLine = ForceLine                                  ' Use the forced one
      END IF                                                      '
   END IF                                                         '
   ErrMsgHigh = %eNone                                            ' Say we 're ok
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdUNDOREDO(pCmd AS STRING)                              '
'--------------------------------------------------------------------------------------------------+
'- Go back to prev/next checkpoint                                                                 |
'--------------------------------------------------------------------------------------------------+
LOCAL i, j, k, m, n, IsUNDO AS LONG, MEditStr AS STRING           '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H UNDOP"), _                                   ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF gENV.UndoLevels = 0 THEN _                                  ' Are we running UNDO?
      MErrExit(%eFail, "UNDO has been turned off")                ' No? Oops!
   IsUNDO = IIF(UCASE$(PTBL.Ops(0)) = "UNDO", %True, %False)      ' Set flag for which mode we're in

   i = UndoCurr                                                   ' i = Last taken, j = one to reload
   IF IsUNDO THEN                                                 ' UNDO?
      j = UndoCurr: GOSUB DecrCurr                                ' Point at the previous UNDO entry
   ELSE                                                           ' REDO
      GOSUB IncrCurr: j = UndoCurr                                ' Point at the next UNDO entry
   END IF                                                         '

   IF (me.UndoTimeGet(j) = 0)  OR _                               ' If Retore entry was never used
      (IsUNDO = %True  AND me.UndoTimeGet(j) > me.UndoTimeGet(i)) OR _  ' OR UNDO and Restore entry is Newer
      (IsUNDO = %False AND me.UndoTimeGet(j) < me.UndoTimeGet(i)) THEN  ' OR REDO and Restore entry is Older
      GOSUB ErrOut                                                ' Oops! No usable slot
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- See how many 'more'- are available                                                           |
   '-----------------------------------------------------------------------------------------------+
   IF IsUNDO THEN                                                 ' If UNDO
      m = IIF(UndoCurr = 1, gENV.UndoLevels, UndoCurr - 1)        ' Start with the one prior to the selected one
      DO UNTIL m = UndoCurr                                       ' Loop till we return to ourselves
         IF me.UndoTimeGet(m) = 0 OR me.UndoTimeGet(m) > me.UndoTimeGet(UndoCurr) THEN EXIT DO  '
         INCR n                                                   ' Count a valid UNDO entry
         m = IIF(m = 1, gENV.UndoLevels, m - 1)                   ' Onward
      LOOP                                                        '
   ELSE                                                           ' Else REDO
      m = IIF(UndoCurr = gENV.UndoLevels, 1, UndoCurr + 1)        ' Start with the one next to the selected one
      DO UNTIL m = UndoCurr                                       ' Loop till we return to ourselves
         IF me.UndoTimeGet(m) = 0 OR me.UndoTimeGet(m) < me.UndoTimeGet(UndoCurr) THEN EXIT DO  '
         INCR n                                                   ' Count a valid UNDO entry
         m = IIF(m = gENV.UndoLevels, 1, m + 1)                   ' Onward
      LOOP                                                        '
   END IF                                                         ' n contains remaining entries

   '-----------------------------------------------------------------------------------------------+
   '- Copy the TopScr/LastLine                                                                     |
   '-----------------------------------------------------------------------------------------------+
   @P.PTopLine = me.UndoTopScrGet(UndoCurr)                       ' Just copy it
   LastLine = me.UndoLastLineGet(UndoCurr)                        '
   LastReal = me.UndoLastRealGet(UndoCurr)                        '
   IF me.UndoModifiedGet(UndoCurr) THEN OnModdFlag ELSE OffModdFlag  '
   IF IsMedit THEN                                                ' If MEdit, must restore individual modified status
      MEditStr = me.UndoMEditGet(j)                               ' Fetch string
      FOR k = 1 TO LEN(MEditStr)                                  ' Restore the MEdit modified values
         IF MID$(MEditStr, k, 1) <> " " THEN _                    ' Just valid T/F entries
            me.MEditFlagSet(k, IIF(MID$(MEditStr, k, 1) = "T", %True, %False))   '
      NEXT j                                                      '
   END IF                                                         '

   '-----------------------------------------------------------------------------------------------+
   '- Go get the IX, L(), TW() and T() arrays                                                      |
   '-----------------------------------------------------------------------------------------------+
   k = me.UndoGet(UndoCurr)                                       ' Load the checkpoint, get PROFLine status
   gfXRebuild = %True                                             ' Force exclude rebuild
   me.ResetFunc(%ResetCommand)                                    ' Clear any pending Line commands
   IF k = &H00000001 THEN me.ProfDisp                             ' Build the Profile display if needed
   OnRenumFlag                                                    ' Let sRenum proceed
   OffUndoFlag                                                    ' So we don't re-save what we just restored
   MErrExit(%eNone, IIF$(IsUNDO, "UNDO ", "REDO ") + "successful, " + FORMAT$(n) + " remaining")   ' No? Oops!
   MExitMeth                                                      '

ErrOut:                                                           '
   MErrExit(%eNone, "No (more) UNDO entries")                     ' Oops!
   RETURN                                                         '

DecrCurr:                                                         '
   DO                                                             '
      UndoCurr = IIF(UndoCurr = 1, gENV.UndoLevels,  UndoCurr - 1)   ' Point at the prev UNDO entry
   LOOP UNTIL me.UndoTimeGet(UndoCurr) <> 0                       '
   RETURN                                                         '

IncrCurr:                                                         '
   DO                                                             '
      UndoCurr = IIF(UndoCurr = gENV.UndoLevels, 1, UndoCurr + 1) ' Point at the next UNDO entry
   LOOP UNTIL me.UndoTimeGet(UndoCurr) <> 0                       '
   RETURN                                                         '

END METHOD                                                        '

METHOD  pCmdVIEW(pCmd AS STRING)                                  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         PCmdHelp("H VIEW"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   me.pCmdBEVOpen(%View, "VIEW")                                  ' Pass to BEV to do
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdWDIR(pCmd AS STRING)                                  '
'--------------------------------------------------------------------------------------------------+
'- Open a Windows Explorer to current file's DIR                                                   |
'--------------------------------------------------------------------------------------------------+
LOCAL lclFn AS STRING                                             '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H WDIR"), _                                    ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF IsMEdit THEN _                                              ' For MEdit, make sure all paths are the same
      MErrExit(%eFail, "Not supported in MEdit mode")             '
   IF IsSetEdit OR IsEFTEdit OR IsClip THEN _                     ' Ineligible tab?
      MErrExit(%eFail, "This tab has no implied DIR folder")      '
   IF ISFALSE IsFMTab THEN                                        ' If not FM, use FCB.FilePath
      lclFn = FCB.FilePath                                        ' Get the filename
   ELSE                                                           ' If FM
      lclFn = PARSE$(gFMNestTbl(gFMNestCtr), "|", 1)              ' Use FM's path
   END IF                                                         '
   SHELL "EXPLORER.EXE /SELECT, " + $DQ + lclFn + $DQ, 1          '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdXSUBMIT(pCmd AS STRING)                               '
'--------------------------------------------------------------------------------------------------+
'- Do the XSUBMIT process                                                                          |
'--------------------------------------------------------------------------------------------------+
LOCAL Fn, lclPath, lclDrive, lclSubArg AS STRING                  '
LOCAL j AS LONG                                                   '
LOCAL DCmd, JobName AS STRING, RCA AS RCArea                      '
LOCAL hWatchThread AS LONG                                        '
LOCAL fptr AS STRING POINTER                                      '
LOCAL FCB2 AS iFCB                                                ' FCB for local use
DIM  slines(1 TO 1000) AS STRING                                  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Do the basic parsing stuff                                                                   |
   '-----------------------------------------------------------------------------------------------+
   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         pCmdHelp("H XSUBMIT"), _                                 ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   IF PTBL.OpsNum = 0 THEN _                                      ' Better be a filename operand
      MErrExit(%eFail, "Mising Submit filename")                  '
   IF TRIM$(gENV.SubmitDir) = "" THEN                             ' Has SUBMIT DIR been set
      DoMessageBox("The working SUBMIT folder has not been established - See Options => Submit", %MB_OK OR %MB_USERICON, "Submit"): MExitMeth   '
   END IF                                                         '

   LET FCB2 = CLASS "cFCB"                                        ' Local FCB
   gSubmitFile = PTBL.L1RData                                     ' Set in Global area
   IF ISFALSE ISFILE(gSubmitFile) THEN _                          ' Go validate
      MErrExit(%eFail, "File: " + gSubmitFile + " is missing")    ' Oops?  Bail out (File missing)

   '-----------------------------------------------------------------------------------------------+
   '- Setup Profile name to get SUBARG                                                             |
   '-----------------------------------------------------------------------------------------------+
   FCB2.SetupFN(gSubmitFile, %ProfGetY, RCA)                      ' Setup Fn
   lclSubArg = FCB.SubArg                                         ' Save the SubArg

   '-----------------------------------------------------------------------------------------------+
   '- Get next jobnumber                                                                           |
   '-----------------------------------------------------------------------------------------------+
   gENV.Jobnumber = gENV.Jobnumber + 1                            ' Bump jobnumber
   gENV.SetINITimeStamp                                           '

   gJobID = "JOB" + FORMAT$(gENV.Jobnumber, "00000")              ' Build ID

   '-----------------------------------------------------------------------------------------------+
   '- Create the Results file                                                                      |
   '-----------------------------------------------------------------------------------------------+
   IF ISNOTNULL(JobName) THEN                                     ' Base on Jobname
      gResultFile = gENV.SubmitDir + "\SUBRESULTS_" + JobName + "_" + gJobID + ".txt"  '
   ELSE                                                           '
      gResultFile = gENV.SubmitDir + "\SUBRESULTS_" + gJobID + ".txt"   '
   END IF                                                         '
   MakeNullFile(gResultFile)                                      ' Create null file
   gSubmitFile = $DQ + gSubmitFile + $DQ                          ' Add the quotes
   gResultFile = $DQ + gResultFile + $DQ                          '

   '-----------------------------------------------------------------------------------------------+
   '- Issue the SUBMIT command                                                                     |
   '-----------------------------------------------------------------------------------------------+
   DCmd = gENV.SubmitCmd                                          ' Get the SUBMIT command
   gSubmitType = "J"                                              ' Set Submit type
   IF me.MacSubst(DCmd) THEN                                      ' Do substitution
      DoMessageBox("Malformed macro operand in SUBMIT prototype command", %MB_OK OR %MB_USERICON, "Submit"): MExitMeth  '
   END IF                                                         '
'-  debug DCmd
   lclPath = CURDIR$                                              ' Locate where we are
   IF MID$(lclPath, 2, 1) = ":" THEN _                            ' Extract Drive if present
      lclDrive = LEFT$(lclPath, 2)                                ' and save it

   IF MID$(gENV.SubmitDir, 2, 1) = ":" THEN _                     ' See if Submit Path has drive
      CHDRIVE LEFT$(gENV.SubmitDir, 2)                            ' If so, go to it
   CHDIR gENV.SubmitDir                                           ' Switch to EXE path
   gLoopCtr = -1                                                  ' Suspend loop detection
   j = SHELL(ENVIRON$("COMSPEC") + " /c " + $DQ + DCmd + $DQ, 0)  '
   RESET gLoopCtr                                                 ' Reset loop detection
   IF ERR THEN                                                    ' Tell user result
      DoMessageBox("Error issuing SUBMIT: |K" + ERROR$, %MB_OK OR %MB_USERICON, "Submit") '
      MExitMeth                                                   '
   END IF                                                         '
   IF ISNOTNULL(lclDrive) THEN CHDRIVE lclDrive                   ' Switch drive if needed
   CHDIR lclPath                                                  ' put back the original path

   '-----------------------------------------------------------------------------------------------+
   '- Start FileWatch for the Result file                                                          |
   '-----------------------------------------------------------------------------------------------+
   StrUnquote gResultFile                                         ' remove Quotes again
   fptr = VARPTR(gResultFile)                                     '
   THREAD CREATE FileWatchSubmitThread(BYVAL fptr) 65536, TO hWatchThread  ' Fire up the thread
   IF hWatchThread = 0 THEN _                                     ' Failed?
      DoMessageBox("Watch of Result file could not be started", %MB_OK OR %MB_USERICON, "Submit"): MExitMeth   '
   SLEEP 50                                                       ' Wait a bit
   THREAD STATUS hWatchThread TO j                                ' See if running OK
   IF j <> 259 THEN _                                             ' If running OK STATUS returns &H103 (See Help)
      DoMessageBox("Watch of Result file could not be started", %MB_OK OR %MB_USERICON, "Submit"): MExitMeth   '
   THREAD CLOSE hWatchThread TO j                                 ' Free up our handle
   DoMessageBox("|K" + gSubmitFile + "|B submitted as JobNumber |K" + FORMAT$(gENV.Jobnumber, "00000"), %MB_OK OR %MB_USERICON, "Submit") '
   MExit                                                          '
END METHOD                                                        '

METHOD  pCmdXFORM(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Alter the XFORM setting                                                                         |
'--------------------------------------------------------------------------------------------------+
   '-----------------------------------------------------------------------------------------------+
   '- Pass off to common parse routine                                                             |
   '-----------------------------------------------------------------------------------------------+
   pCmdXIMacro(pCmd, "XFORM")                                     ' Call common routine
END METHOD                                                        '

METHOD  pCmdXTABS(pCmd AS STRING)                                 '
'--------------------------------------------------------------------------------------------------+
'- Set XTABS or do a Query                                                                         |
'--------------------------------------------------------------------------------------------------+
   FCB.ImportTabs = GetSimpleNum(1, FCB.ImportTabs, %False, PCmd) ' Let GetSimpleNum do all the work
END METHOD                                                        '

METHOD  pCmdXIMacro(pCmd AS STRING, which AS STRING)              '
'--------------------------------------------------------------------------------------------------+
'- Alter the EMacro / IMACRO / XFORM setting                                                       |
'--------------------------------------------------------------------------------------------------+
LOCAL i, kNONE, kON, kOFF, kWord AS LONG, wrd0, wrd1, wrd2, t, v, MSG AS STRING  '
   MEntry                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Get current setting                                                                          |
   '-----------------------------------------------------------------------------------------------+
   IF which = "EMACRO" THEN                                       ' Pick up correct Kwd
      Wrd0 = FCB.EMacro                                           '
   ELSEIF which = "IMACRO" THEN                                   '
      Wrd0 = FCB.IMacro                                           '
   ELSE                                                           '
      Wrd0 = FCB.XFormStr                                         '
   END IF                                                         '
   wrd1 = TRIM$(uucase(EXTRACT$(wrd0, " ")))                      ' Get Macname
   wrd2 = "ON"                                                    ' Default to ON
   IF wrd1 <> "" THEN                                             ' If a macro name
      wrd2 = IIF$(wrd0 = uucase(wrd0), "ON", "OFF")               ' Set ON/OFF based on case.
   ELSE                                                           '
      wrd2 = "OFF"                                                '
   END IF                                                         ' Wrd1 = Old old name, Wrd2 = old ON/OFF

   Call3(PTBL.ParseCmd(pCmd, (%PAll - %PAssign)), _               ' Try the basic Parse
         GOTO iDispMsg, _                                         ' ? entered
         MErrExit(%eFail, PTBL.ErrMsg), _                         ' Error, Bail out
         Nul)                                                     ' Continue
   '-----------------------------------------------------------------------------------------------+
   '- Examine the operands                                                                         |
   '-----------------------------------------------------------------------------------------------+
   IF PTBL.GotLit THEN Wrd0 = PTBL.Pos2(1): kWord = %True         ' Save macro name if present
   kNone = PTBL.IsKwd("NONE")                                     ' Get NONE if present
   t = PTBL.Grp("ONOFF")                                          ' Get ON/OFF
   IF ISNOTNULL(t) THEN                                           ' One of them is there
      kON  = IIF(t = "ON", %True, %False)                         ' Set ON status
      kOFF = IIF(t = "OFF", %True, %False)                        ' Set OFF status
   END IF                                                         '
   '-----------------------------------------------------------------------------------------------+
   '- Now see what to do, Wrd0 = new macname + Kflags for NONE/ON/OFF Word are set                 |
   '-----------------------------------------------------------------------------------------------+
   IF kNONE THEN                                                  ' NONE?  Nothing else matters
      wrd1 = "": wrd2 = ""                                        ' Turn it off
      GOTO SetChange                                              ' Go do the change
   END IF                                                         '

   IF kWord AND ISFALSE kON AND ISFALSE kOFF THEN                 ' Just a macroname, no ON/OFF
      IF wrd1 = "" THEN                                           ' If currently NONE
         wrd1 = wrd0: wrd2 = "ON"                                 ' Use ON as the default
      ELSE                                                        ' If there IS a current macroname
         wrd1 = wrd0                                              ' Swap the name, keep previous ON/OFF
      END IF                                                      '
      GOTO SetChange                                              ' Go do the change
   END IF                                                         '

   IF kON AND ISFALSE kWORD THEN                                  ' Just ON
      IF wrd1 = "" THEN mErrExit(%eFail, "ON specified, but no current macro-name") '
      wrd2 = "ON"                                                 ' Set current macro ON
      GOTO SetChange                                              ' Go do the change
   END IF                                                         '

   IF kOFF AND ISFALSE kWORD THEN                                 ' Just OFF
      IF wrd1 = "" THEN mErrExit(%eFail, "OFF specified, but no current macro-name")   '
      wrd2 = "OFF"                                                ' Set current macro OFF
      GOTO SetChange                                              ' Go do the change
   END IF                                                         '

   wrd1 = wrd0                                                    ' Set the entered values
   wrd2 = IIF$(kON, "ON", "OFF")                                  '

   SetChange:                                                     '
   v = Wrd1                                                       ' Build the Profile save value
   v = IIF$(Wrd2 = "ON", uucase(v), llcase(v))                    ' Set v=uppercase for ON, lowercase for OFF
   IF which = "EMACRO" THEN                                       ' Save it back to the right variable
      FCB.EMacro = v                                              '
   ELSEIF which = "IMACRO" THEN                                   '
      FCB.IMacro = v                                              '
   ELSE                                                           '
      FCB.XFormStr = v                                            '
   END IF                                                         '

   iDispMsg:                                                      '
      IF wrd1 <> "" THEN _                                        '
         MSG = IIF$(ISFALSE IsMacro(wrd1), "Warning, " + uucase(wrd1) + " macro doesn't exist, ", "") ' Build message
      MSG += which + " set to " + IIF$(Wrd1 = "", "NONE", uucase(Wrd1) +  " " + Wrd2)  '
      DoProfMsg(MSG)                                              '
      MExitMeth                                                   '
   RETURN                                                         '
END METHOD                                                        '
