'----- License Stuff
'This file is part of SPFLite.

'    SPFLite is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    SPFLite is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.

#COMPILE EXE "SPFTest.EXE"
#DIM ALL
#DEBUG DISPLAY ON
#DEBUG ERROR ON
#TOOLS OFF
#OPTIMIZE CODE ON
#INCLUDE ONCE "Win32Api.inc"                                      ' Windows standard stuff
#INCLUDE ONCE "CommCtrl.inc"                                      ' Common Controls
#INCLUDE ONCE "PCRE.inc"                                          ' RegEx stuff
#INCLUDE ONCE "Types.inc"                                         ' Standard Types etc.

' Fake structures to make mapping.inc compatible with main SPFLite source

TYPE TP_block
   PrfPCase                   AS STRING * 1
   FoundLine                  AS LONG                             ' Current found line
   FoundCol                   AS LONG                             ' Current found column
   ChangeLen   AS LONG                                            ' Current real length of change string
   OperFlag    AS QUAD                                            ' Current Operand flags
   FindLen     AS LONG                                            ' Current real length of find string
END TYPE

' Dialogue equates
ENUM A1 SINGULAR
   Dlg_Window                 = 1000
   Dlg_Icon
   Dlg_H1
   Dlg_H2
   Dlg_RegEx_Case_Str
   Dlg_RegEx_Case_Str_Text
   Dlg_RegEx_Test_Str
   Dlg_RegEx_Test_Str_Text
   Dlg_RegEx_Str
   Dlg_RegEx_Str_Text
   Dlg_Result_Str
   Dlg_Result_Str_Text
   Dlg_Error_Str
   Dlg_Error_Str_Text
   Dlg_Test_Button
END ENUM

'----- Resource Stuff
#RESOURCE ICON, A,        "D:\Cloud\Documents\SPFLite3\Resource File\SPFLite3.ICO"

'---------- Dialog I/O areas
GLOBAL RegEx_Case_Str         AS STRING
GLOBAL RegEx_Test_Str         AS STRING
GLOBAL RegEx_Str              AS STRING

GLOBAL result_Str             AS STRING

GLOBAL err_Str                AS STRING
GLOBAL retcode                AS LONG
GLOBAL pageno                 AS LONG

'---------- Dialog Handles
GLOBAL hWnd                   AS DWORD

GLOBAL hFixedFont             AS DWORD
GLOBAL hTabFont               AS DWORD
GLOBAL hHeadFont              AS DWORD
GLOBAL hToolTips              AS DWORD

'---------- RegEx areas
GLOBAL hPCRE                  AS DWORD
GLOBAL PCRE_Regex_Str2        AS STRING
GLOBAL PCRE_ErrPtr            AS ASCIIZ PTR
GLOBAL PCRE_ErrOffsetPtr      AS DWORD
GLOBAL PCRE_Options           AS LONG
GLOBAL PCRE_ExecRC            AS LONG
GLOBAL PCRE_Offsets()         AS LONG
GLOBAL PCRE_errMsg            AS STRING
GLOBAL PCRE_lperrMsg          AS STRING PTR

GLOBAL gCrashList()           AS STRING                           ' Module trace
GLOBAL gCrashCtr              AS LONG                             ' Module trace Index

'---------- PCRE links
GLOBAL hLib_PCRE              AS LONG                             ' Handle of PCRE3.dll library
GLOBAL hProc_PCRE_Compile     AS LONG                             ' Handle to Compile function
GLOBAL hProc_PCRE_Exec        AS LONG                             ' Handle to Exec function
GLOBAL hProc_PCRE_Free        AS LONG                             ' Handle to Free function
GLOBAL hProc_PCRE_Free_Ptr    AS LONG                             ' Handle to Real Free function
GLOBAL lptr                   AS LONG PTR                         ' Temp

GLOBAL TP                     AS TP_block


FUNCTION PBMAIN () AS LONG

'---------- DIM the global arrays
DIM    PCRE_Offsets(12)       AS GLOBAL LONG
DIM    gCrashList(0 TO 200)   AS GLOBAL STRING

'---------- Get PCRE reqady to use

   '---Open and load PCRE3.dll library
   hLib_PCRE = LoadLibraryA( BYCOPY "PCRE3.Dll" )

   '---If all went fine
   IF hLib_PCRE THEN                                              ' PCRE exists

      '---Try to load the functions
      hProc_PCRE_Compile          = GetProcAddress(hLib_PCRE, BYCOPY "pcre_compile")
      hProc_PCRE_Exec             = GetProcAddress(hLib_PCRE, BYCOPY "pcre_exec")
      hProc_PCRE_Free             = GetProcAddress(hLib_PCRE, BYCOPY "pcre_free")
      lptr = hProc_PCRE_Free                                      ' Free returns a POINTER to the real free routine
      hProc_PCRE_Free_Ptr = @lptr                                 ' so chain to it as the REAL entry point

      '---If all went fine ...
      IF hProc_PCRE_Compile        AND _                          ' All three better be non-zero
         hProc_PCRE_Exec           AND _                          '
         hProc_PCRE_Free_Ptr       THEN                           '
         ' All is well
      ELSE
         MSGBOX "Internal PCRE functions not found"               ' Error
         EXIT FUNCTION                                            '
      END IF                                                      '

   ELSE                                                           '
      MSGBOX "PCRE DLL does not appear to be installed"           ' Say why we didn't do it
      EXIT FUNCTION                                               '
   END IF                                                         '

'---------- Init some fields with defaults
   RegEx_Case_Str = "T"                                           ' Default CASE for Regex
   pageno = VAL(COMMAND$)                                         ' Get page number from command line
   pageno = IIF(pageno, pageno, 1)                                ' Default to 1 if none
   Build_Dialog                                                   ' Build the Dialog
END FUNCTION

CALLBACK FUNCTION DlgCallBack
'--------------------
' Callback function used by the Dialog
'--------------------
LOCAL lclText AS STRING
LOCAL txtP AS ASCIIZ PTR

   SELECT CASE AS LONG CB.MSG                                     '

      '----- SYSCOMMAND
      CASE %WM_SYSCOMMAND                                         '
         IF CB.HNDL <> hWnd THEN EXIT FUNCTION                    '
         IF (CBWPARAM AND &HFFF0) = %SC_CLOSE THEN                ' Trap the [x] button and Alt-F4
            DIALOG END HWnd                                       '
         END IF                                                   '

      '----- COMMAND                                              '
      CASE %WM_COMMAND                                            '
         SELECT CASE AS LONG CB.CTL                               '

            '----- Test button pressed (or Enter)
            CASE %Dlg_Test_Button                                 ' Test button?
               IF CB.CTLMSG = %BN_CLICKED THEN                    '

                  CONTROL GET TEXT hWnd, %Dlg_RegEx_Case_Str TO Regex_Case_Str ' Get the modified data
                  Regex_Case_Str = TRIM$(UCASE$(Regex_Case_Str))
                  IF RegEx_Case_Str <> "T" AND RegEx_Case_Str <> "C" THEN  ' Valid?               '
                     CONTROL SET TEXT hWnd, %Dlg_Error_Str, "CASE is not 'C' or 'T'"
                     EXIT FUNCTION                                '
                  END IF                                          '
                  CONTROL GET TEXT hWnd, %Dlg_RegEx_Test_Str TO Regex_Test_Str' Get the modified data
                  IF TRIM$(Regex_Test_Str) = "" THEN              '
                     CONTROL SET TEXT hWnd, %Dlg_Error_Str, "Test Source string is empty"
                     EXIT FUNCTION                                '
                  END IF                                          '
                  CONTROL GET TEXT hWnd, %Dlg_RegEx_Str TO RegEx_Str  ' Get the modified data
                  IF TRIM$(RegEx_Str) = "" THEN                   '
                     CONTROL SET TEXT hWnd, %Dlg_Error_Str, "RegEx expression string is empty"
                     EXIT FUNCTION                                '
                  END IF                                          '

                  '----- Actually run the test now                '
                  result_Str = ""                                 ' Clear the result fields
                  err_Str = ""                                    '
                  CONTROL SET TEXT hWnd, %Dlg_Result_Str, ""      '
                  CONTROL SET TEXT hWnd, %Dlg_Error_Str, ""       '
                  PCRE_Options = IIF(RegEx_Case_Str = "C", 0, %PCRE_CASELESS) ' Set Options to match CASE

                  PCRE_Regex_Str2 = RegEx_Str + CHR$(0)           ' Make into pseudo ASCIIZ
                  PCRE_lperrMsg = STRPTR(PCRE_errMsg)             ' Setup pointer

                  '----- Call PCRE Compile
                  CALL DWORD hProc_PCRE_Compile USING pcre_compile( _
                                 STRPTR(PCRE_Regex_Str2), _       ' Regex string
                                 PCRE_Options,            _       ' Options
                                 VARPTR(PCRE_ErrPtr),     _       ' Pointer to error string
                                 VARPTR(PCRE_ErrOffsetPtr),_      ' Error offset
                                 &0) _                            ' Character tables
                                 TO hPCRE
                  IF hPCRE = 0 THEN                               ' OK?
                     txtp = PCRE_ErrPtr                           '
                     err_Str = "Error found at Col: " + FORMAT$(PCRE_ErrOffsetPtr + 1) + " : " +  @txtp
                     CONTROL SET TEXT hWnd, %Dlg_Error_Str, err_Str
                     EXIT FUNCTION                                '
                  END IF                                          '

                  '----- Now call for an Exec of the compiled RegEx
                  CALL DWORD hProc_PCRE_Exec USING pcre_exec( _
                              hPCRE,                      _       ' Compile handle
                              &0,                         _       ' extra-data
                              STRPTR(RegEx_Test_Str),     _       ' Test-string
                              LEN(Regex_Test_Str),        _       ' length of Test-srtring
                              0,                          _       ' Starting position
                              &0,                         _       ' Options
                              VARPTR(PCRE_Offsets(0)),    _       ' PCRE_Offsets array
                              &12) _                              ' Size of offsets array
                              TO PCRE_ExecRC

                  IF PCRE_ExecRC < 1 THEN                         ' How'd search go?
                     err_Str = "Not found"                        ' Not found
                     CONTROL SET TEXT hWnd, %Dlg_Result_Str, "||" ' Do messages
                     CONTROL SET TEXT hWnd, %Dlg_Error_Str, err_Str
                     CALL DWORD hProc_PCRE_Free_Ptr USING pcre_free( _
                              hPCRE)                              ' Compile handle
                     hPCRE = 0                                    '
                     EXIT FUNCTION                                '

                  ELSE                                            '
                     IF PCRE_Offsets(2) <> 0 THEN                 ' A group returned?
                        CONTROL SET TEXT hWnd, %Dlg_Result_Str, "|" + MID$(Regex_Test_Str, PCRE_Offsets(2) + 1 TO PCRE_Offsets(3) -1) + "|"
                        CONTROL SET TEXT hWnd, %Dlg_Error_Str, "Found at Col: " + FORMAT$(PCRE_Offsets(2) + 1) + ", Lgth: " + _
                                                          FORMAT$(PCRE_Offsets(3) - PCRE_Offsets(2) - 1)
                        CALL DWORD hProc_PCRE_Free_Ptr USING pcre_free( _
                                 hPCRE)                           ' Compile handle
                        hPCRE = 0                                 '
                     ELSE
                        CONTROL SET TEXT hWnd, %Dlg_Result_Str, "|" + MID$(Regex_Test_Str, PCRE_Offsets(0) + 1 TO PCRE_Offsets(1)) + "|"
                        CONTROL SET TEXT hWnd, %Dlg_Error_Str, "Found at Col: " + FORMAT$(PCRE_Offsets(0) + 1) + ", Lgth: " + _
                                                          FORMAT$(PCRE_Offsets(1) - PCRE_Offsets(0))
                        CALL DWORD hProc_PCRE_Free_Ptr USING pcre_free( _
                                 hPCRE)                           ' Compile handle
                        hPCRE = 0                                 '
                     END IF                                       '
                  END IF                                          '
               END IF                                             '
         END SELECT
   END SELECT                                                     '
END FUNCTION

FUNCTION ToolTipCreate (BYVAL Wnd AS LONG) AS LONG
'---------- Create tooltips control if needed.                    '
   IF hToolTips = 0 THEN                                          '
      IF Wnd = 0 THEN Wnd = GetActiveWindow()                     '
      IF Wnd = 0 THEN EXIT FUNCTION                               '
      InitCommonControls                                          '
      hToolTips = CreateWindowEx(0, "tooltips_class32", "", %TTS_ALWAYSTIP OR %TTS_BALLOON, _
             0, 0, 0, 0, Wnd, BYVAL 0&, GetModuleHandle(""), BYVAL %NULL)
   END IF                                                         '
   FUNCTION = hToolTips                                           '
END FUNCTION

FUNCTION ToolTipSet (BYVAL Wnd AS LONG, BYVAL TXT AS STRING) AS LONG
'---------- Add a tooltip to a window/control
LOCAL ti AS TOOLINFO                                              '
   IF ToolTipCreate(GetParent(Wnd)) = 0 THEN EXIT FUNCTION        ' Ensure creation
   ti.cbSize   = LEN(ti)                                          '
   ti.uFlags   = %TTF_SUBCLASS OR %TTF_IDISHWND                   '
   ti.hWnd     = GetParent(Wnd)                                   '
   ti.uId      = hWnd                                             '

   '---------- Remove existing tooltip                            '
   IF SENDMESSAGE (hToolTips, %TTM_GETTOOLINFO, 0, BYVAL VARPTR(ti)) THEN
      SENDMESSAGE hToolTips, %TTM_DELTOOL, 0, BYVAL VARPTR(ti)    '
   END IF                                                         '
   ti.cbSize   = LEN(ti)                                          '
   ti.uFlags   = %TTF_SUBCLASS OR %TTF_IDISHWND                   '
   ti.hWnd     = GetParent(Wnd)                                   '
   ti.uId      = Wnd                                              '
   ti.lpszText = STRPTR(TXT)                                      '
   FUNCTION = SENDMESSAGE(hToolTips, %TTM_ADDTOOL, 0, BYVAL VARPTR(ti)) 'add tooltip
END FUNCTION

SUB Build_Dialog()
'---------- Build and start the Dialog
LOCAL hFixedFont AS DWORD
   FONT NEW "Courier New", 10, 1, 1, 1 TO hFixedFont              ' Build font for our Dialog text boxes
   FONT NEW "Tahoma", 9, 1, 1, 1 TO hTabFont                      ' Build font for tabs
   FONT NEW "Tahoma", 12, 0, 1, 1 TO hHeadFont                    ' Build font for heading
   DIALOG FONT DEFAULT "Tahoma", 10, 0, 0

   DIALOG NEW PIXELS, 0, "SPFTest", 0, 0, 600, 375, _
          %WS_CAPTION OR %WS_THICKFRAME OR %WS_MINIMIZEBOX OR %WS_SYSMENU OR %WS_OVERLAPPEDWINDOW OR %WS_CLIPCHILDREN, 0 _
          TO hWnd
   DIALOG SET COLOR hWnd, %BLUE, %RGB_GAINSBORO
   CONTROL ADD IMAGEX, hWnd, %Dlg_Icon, "A", 5, 5, 32, 32, %SS_ICON OR %SS_CENTERIMAGE OR %SS_NOTIFY

   CONTROL ADD LABEL,  hWnd, %Dlg_H1, "Test SPFLite RegEx Expressions", 50, 10, 550, 30
   CONTROL SET COLOR   hWnd, %Dlg_H1, %BLUE, %RGB_GAINSBORO
   CONTROL SET FONT hWnd, %Dlg_H1, hHeadFont                      '


   DIALOG SET COLOR hWnd, %BLUE, %RGB_GAINSBORO
   CONTROL ADD TEXTBOX, hWnd, %Dlg_RegEx_Case_Str, Regex_Case_Str, 10, 50, 20, 20, %ES_NOHIDESEL
   CONTROL SET FONT     hWnd, %Dlg_RegEx_Case_Str, hFixedFont
   ToolTipSet (GetDlgItem(hWnd, %Dlg_RegEx_Case_Str), " Enter the CASE value - C / T to be used as a default. ")
   CONTROL ADD LABEL, hWnd, %Dlg_RegEx_Case_Str_Text, "Default CASE value - C / T", 40, 50, 300, 16
   CONTROL SET COLOR  hWnd, %Dlg_RegEx_Case_Str_Text, %BLUE, %RGB_GAINSBORO


   CONTROL ADD TEXTBOX, hWnd, %Dlg_RegEx_Test_Str, Regex_Test_Str, 10, 95, 575, 20
   CONTROL SET FONT     hWnd, %Dlg_RegEx_Test_Str, hFixedFont
   ToolTipSet (GetDlgItem(hWnd, %Dlg_RegEx_Test_Str), " Source string for the test. ")
   CONTROL ADD LABEL, hWnd, %Dlg_RegEx_Test_Str_Text, "Source string for the test", 10, 118, 450, 16
   CONTROL SET COLOR  hWnd, %Dlg_RegEx_Test_Str_Text, %BLUE, %RGB_GAINSBORO

   CONTROL ADD TEXTBOX, hWnd, %Dlg_RegEx_Str, RegEx_Str, 10, 145, 575, 20
   CONTROL SET FONT     hWnd, %Dlg_RegEx_Str, hFixedFont
   ToolTipSet (GetDlgItem(hWnd, %Dlg_RegEx_Str), " Enter the Regex expression string. ")
   CONTROL ADD LABEL, hWnd, %Dlg_RegEx_Str_Text, " Regex expression string - No R'...' framing required ", 10, 168, 450, 16
   CONTROL SET COLOR  hWnd, %Dlg_RegEx_Str_Text, %BLUE, %RGB_GAINSBORO


   CONTROL ADD BUTTON,  hWnd, %Dlg_Test_Button, "Run Test", 265, 220, 75, 24, %WS_BORDER OR %BS_DEFAULT
   ToolTipSet (GetDlgItem(hWnd, %Dlg_Test_Button), " Click to run the test. ")

   CONTROL ADD LABEL,  hWnd, %Dlg_H2, "Results", 10, 245, 550, 30
   CONTROL SET COLOR   hWnd, %Dlg_H2, %BLUE, %RGB_GAINSBORO
   CONTROL SET FONT hWnd, %Dlg_H2, hHeadFont                      '

   CONTROL ADD TEXTBOX, hWnd, %Dlg_Result_Str, Result_Str, 10, 275, 575, 20
   CONTROL SET FONT     hWnd, %Dlg_Result_Str, hFixedFont
   ToolTipSet (GetDlgItem(hWnd, %Dlg_Result_Str), " Result string for the last test will appear here. ")
   CONTROL ADD LABEL, hWnd, %Dlg_Result_Str_Text, "Returned result string", 10, 298, 300, 16
   CONTROL SET COLOR  hWnd, %Dlg_Result_Str_Text, %BLUE, %RGB_GAINSBORO

   CONTROL ADD TEXTBOX, hWnd, %Dlg_Error_Str, Result_Str, 10, 325, 575, 20
   CONTROL SET FONT     hWnd, %Dlg_Error_Str, hFixedFont
   ToolTipSet (GetDlgItem(hWnd, %Dlg_Error_Str), " Any Error message for the last test will appear here. ")
   CONTROL ADD LABEL, hWnd, %Dlg_Error_Str_Text, "Returned error message", 10, 348, 300, 16
   CONTROL SET COLOR  hWnd, %Dlg_Error_Str_Text, %BLUE, %RGB_GAINSBORO


   DIALOG SHOW MODAL hWnd CALL DlgCallback                        ' Display it all

END SUB
