'--------------------------------------------------------------------------------------------------+
'- License Stuff                                                                                   |
'-                                                                                                 |
'-                                                                                                 |
'-   SPFLite is free software: you can redistribute it and/or modify                               |
'-   it under the terms of the GNU General Public License as published by                          |
'-   the Free Software Foundation, either version 3 of the License, or                             |
'-   (at your option) any later version.                                                           |
'-                                                                                                 |
'-   SPFLite is distributed in the hope that it will be useful,                                    |
'-   but WITHOUT ANY WARRANTY; without even the implied warranty of                                |
'-   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                                 |
'-   GNU General Public License for more details.                                                  |
'-                                                                                                 |
'-   You should have received a copy of the GNU General Public License                             |
'-   along with SPFLite.  If not, see <https://www.gnu.org/licenses/>.                             |
'-                                                                                                 |
'--------------------------------------------------------------------------------------------------+
'- Types.inc                                                                                       |
'--------------------------------------------------------------------------------------------------+
                                                                  '
'--------------------------------------------------------------------------------------------------+
'- Main Text storage Data                                                                          |
'--------------------------------------------------------------------------------------------------+
TYPE DataLine                                                     '
   LLbl    AS STRING * 8                                          ' Label
   LLNum   AS STRING * 8                                          ' Original line number at last AttnFlag refresh
   LLCtl   AS STRING * 8                                          ' Line control after KB interaction
   LTag    AS STRING * 8                                          ' Tag
   LHndl   AS LONG                                                ' Handle number
   LTrak   AS LONG                                                ' Track Point ID
   LFlag   AS LONG                                                ' Type of entry
   LWrk1   AS LONG                                                ' Misc. work value (e.g. XX count)
   LWrk2   AS LONG                                                ' Work value. =PAGE> ctr; Note type
   LCol    AS LONG                                                ' Column number if %Cursor line
   LFix    AS LONG                                                ' FIND index counter
   LMix    AS LONG                                                ' MultiEdit File Index
   LTxtIX  AS LONG                                                ' Index of allocated T() dynamic string for Txt
   LTxt    AS STRING POINTER                                      ' Ptr to real text string
   LAttrIX AS LONG                                                ' Index of allocated T() dynamic string for Attr
   LAttr   AS WSTRING POINTER                                     ' Ptr to Text attribute string
END TYPE                                                          '

%Data       = &H00000001                                          ' Equates for DataLine.LFlag
%Top        = &H00000002                                          '
%Bottom     = &H00000004                                          '
%Tabs       = &H00000008                                          '
%Bounds     = &H00000010                                          '
%Cols       = &H00000020                                          '
%Xclude     = &H00000040                                          '
%Invisible  = &H00000080                                          '
%InsertLine = &H00000100                                          '
%EQChange   = &H00000200                                          '
%Word       = &H00000400                                          '
%Mark       = &H00000800                                          '
%Mask       = &H00001000                                          '
%Prof       = &H00002000                                          '
%Cursor     = &H00004000                                          '
%TopScreen  = &H00008000                                          '
%Scroll     = &H00010000                                          '
%XPtr       = &H00020000                                          '
%Page       = &H00040000                                          '
%File       = &H00080000                                          '
%Note       = &H00100000                                          '
%Popped     = &H00200000                                          '
%User       = &H00400000                                          '
%EFT        = &H00800000                                          '
%PanelUpper = &H01000000                                          '
%PanelLower = &H02000000                                          '
%NonTypable = %Top OR %Bottom OR %Cols OR %File OR %Xclude OR %Prof OR %EFT   '
%SpecialLine= %Top OR %Bottom OR %Tabs OR %Bounds OR %Cols OR %Xclude OR %Mask OR _ '
              %InsertLine OR %EQChange OR %Word OR %Mark OR %Prof OR %File OR %Note OR %Page OR %EFT  '
%NonLineNum = %Top OR %Bottom OR %Tabs OR %Bounds OR %Cols OR %Xclude OR %Mask OR _ '
              %Word OR %Mark OR %Prof OR %File OR %Note OR %EFT OR %PanelUpper OR %PanelLower   '

'--------------------------------------------------------------------------------------------------+
'- Track Point Stack                                                                               |
'--------------------------------------------------------------------------------------------------+
TYPE TrkStackT                                                    '
   TrkID      AS LONG                                             '
   TrkRow     AS LONG                                             '
   TrkCol     AS LONG                                             '
END TYPE                                                          '
%TrkMax  = 200                                                    '

'--------------------------------------------------------------------------------------------------+
'- Retention Table                                                                                 |
'--------------------------------------------------------------------------------------------------+
TYPE RetTable                                                     '
   BKPName    AS ASCIIZ * %MAX_PATH                               ' Filename of the Backup
   BKPDate    AS STRING * 6                                       ' Date of the Backup
   BKPFDate   AS STRING * 13                                      ' Last Write date/time of the Backup
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- Retention Table                                                                                 |
'--------------------------------------------------------------------------------------------------+
TYPE TDataEnt                                                     '
   TFrom      AS LONG                                             ' Offset in the read buffer
   TLen       AS LONG                                             ' Length of text
   TPage      AS LONG                                             ' PageFlag
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- Undo Stuff                                                                                      |
'--------------------------------------------------------------------------------------------------+
TYPE UndoType                                                     '
   UFn        AS ASCIIZ * %MAX_PATH                               ' Filename of Udtsave data
   TFn        AS ASCIIZ * %MAX_PATH                               ' Filename of Txtsave data
   TWFn       AS ASCIIZ * %MAX_PATH                               ' Filename of WTxtsave data
   IXFn       AS ASCIIZ * %MAX_PATH                               ' Filename of IXsave data
   UBoundL    AS LONG                                             ' UBoundL
   UBoundT    AS LONG                                             ' UBoundT
   UBoundB    AS LONG                                             ' UBound BStack
   TopScr     AS LONG                                             ' Copy of TopScr
   LastLine   AS LONG                                             ' LastLine
   LastReal   AS LONG                                             ' LastReal
   Modified   AS LONG                                             ' Modified flag
   MEditMod   AS STRING * 255                                     ' MEdit Modified string
   TIME       AS DOUBLE                                           ' Time save was done
   pBStack    AS LONG POINTER                                     ' Pointer to BStack
   pL         AS Dataline POINTER                                 ' Pointer to L() array
   pT         AS STRING POINTER                                   ' Pointer to T() array
   pTW        AS WSTRING POINTER                                  ' Pointer to TW() array
   Busy       AS LONG                                             ' Busy doing the write
   MCpyBusy   AS LONG                                             ' Memory copy Busy
END TYPE                                                          '
%Valid = %True                                                    ' Valid Undo entry

UNION KWVar                                                       '
   SVar       AS STRING POINTER                                   '
   LVar       AS LONG POINTER                                     '
   FVar       AS SINGLE POINTER                                   '
   AVar       AS DWORD                                            '
END UNION                                                         '

'--------------------------------------------------------------------------------------------------+
'- Prof KW Table                                                                                   |
'--------------------------------------------------------------------------------------------------+
TYPE PKWTbl                                                       '
   KWText     AS STRING * 16                                      ' CFG keyword
   KWType     AS INTEGER                                          ' Type (1 - numeric, 0 = string)
   KWFlag     AS INTEGER                                          ' Flag
   KWAddr     AS KWVar                                            ' Address of variable
   KWDefault  AS STRING * 256                                     ' Default value
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- Line Control Data Areas                                                                         |
'--------------------------------------------------------------------------------------------------+

TYPE TouchEntry                                                   '
   LinNo      AS LONG                                             ' Line Number
   LinCtl     AS STRING * 8                                       ' Line Ctl data
   LinCmd     AS STRING * 8                                       ' Line Ctl extracted command
   LinRpt     AS LONG                                             ' Line Ctl extracted numeric
   LinFlag    AS LONG                                             ' Line Ctl flags (&+-\/)
   LinCmdIX   AS LONG                                             ' Index to LCmd table entry
   LinCType   AS STRING * 1                                       ' Command type (I/S/D)
   LinCVar    AS STRING * 1                                       ' Command variation (e,g, ANote = A, MNOTE = M, etc.)
END TYPE                                                          '

UNION LAsString                                                   '
   LVar       AS LONG                                             '
   CVar       AS STRING * 4                                       '
END UNION                                                         '

UNION LAsStringP                                                  '
   LVar       AS LONG                                             '
   PVar       AS STRING POINTER                                   '
END UNION                                                         '

UNION WSWork                                                      '
   WStr       AS WSTRING * 4                                      '
   WQuad      AS QUAD                                             '
END UNION                                                         '

TYPE CBytes                                                       ' For manipulating RGB values
   R      AS BYTE                                                 ' Red
   G      AS BYTE                                                 ' Green
   B      AS BYTE                                                 ' Blue
   A      AS BYTE                                                 ' Alpha
END TYPE                                                          '

UNION CUnion                                                      '
  RGB AS DWORD                                                    ' LONG version
  CBytes                                                          ' R/G/B/A ytes
END UNION                                                         '

'--------------------------------------------------------------------------------------------------+
'- Panel Control Stuff                                                                             |
'--------------------------------------------------------------------------------------------------+
TYPE CsrControl                                                   '
   '-----------------------------------------------------------------------------------------------+
   '- Next Items are set by CsrMode                                                                |
   '-----------------------------------------------------------------------------------------------+
   CRow        AS LONG                                            ' Cursor row
   CCol        AS LONG                                            ' Cursor col
   CType       AS LONG                                            ' Cursor location type
   CLCol       AS LONG                                            ' Cursor column in field
   CSCol       AS LONG                                            ' Cursor Screen column in field
   CIX         AS LONG                                            ' Cursor Data Line IX

   '-----------------------------------------------------------------------------------------------+
   '- Next Items are set by the individual commands                                                |
   '-----------------------------------------------------------------------------------------------+
END TYPE                                                          '

TYPE PanelCtl                                                     '
   PS(300)      AS LONG                                           ' Screen line <> Data Line Xref
   C            AS CsrControl                                     ' Current Csr status
   PBottom      AS LONG                                           ' Last screen line of the PANEL
   PCmdCol      AS LONG                                           ' Column of the Command entry
   PCmdLen      AS LONG                                           ' Length of Command line
   PCOffset     AS LONG                                           ' Right scroll Offset of pCommand
   PData1       AS LONG                                           ' First Data line of the PANEL
   PDataCol     AS LONG                                           ' Column of the Data itself
   PDataLen     AS LONG                                           ' Length of a Data Line
   PDLines      AS LONG                                           ' Number of Data Lines in the PANEL
   PGapCol      AS LONG                                           ' Column of the Gap after Lno
   PLastCleard  AS LONG                                           ' Last '''''' line cleared
   PLastDrawn   AS LONG                                           ' Last line drawn on panel
   PLastRow     AS LONG                                           ' Last cursor row
   PLastCol     AS LONG                                           ' Last cursor col
   PLeft        AS LONG                                           ' LEFT column of the PANEL
   PMarkLine    AS LONG                                           ' Current marked line number
   POffset      AS LONG                                           ' Right scroll Offset
   PPanelWidth  AS LONG                                           ' Panel width
   PPanelHeight AS LONG                                           ' Panel Height
   PLastWidth   AS LONG                                           ' Last Window width
   PLastHeight  AS LONG                                           ' Last Window Height
   PPanelPct    AS SINGLE                                         ' Panel % of Height or Width
   PRight       AS LONG                                           ' RIGHT column of the PANEL
   PScrData     AS LONG                                           ' Column of the Scroll Data
   PScrHdr      AS LONG                                           ' Column of the Scroll Header
   PTop         AS LONG                                           ' Top screen line of the PANEL
   PTopDrawn    AS LONG                                           ' Top drawn line
   PTopLine     AS LONG                                           ' Current line at 'top of PANEL'
   PPanelType   AS STRING * 1                                     ' Current type
                                                                  ' "N" - Normal, "H" - Horizontal, "V" - Vertical

END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- Status Bar stuff                                                                                |
'--------------------------------------------------------------------------------------------------+
TYPE SBarEntry                                                    '
   SBName     AS STRING * 6                                       ' External name for the box
   SBID       AS STRING * 1                                       ' $ID character
   SBAlign    AS STRING * 1                                       ' Box Alignment
   SBPosBar   AS STRING * 1                                       ' This is the Position Bar box
   SBAssigned AS LONG                                             ' Working position assignment
   SBWidth    AS LONG                                             ' Width of this box
   SBFG       AS LONG                                             ' FG colour
   SBBG       AS LONG                                             ' BG colour
   SBText     AS STRING * 128                                     ' Message text
   SBMaxTxt   AS LONG                                             ' Maximum text length
END TYPE                                                          '

%SBMode     = 01                                                  ' Statusbar box IDs
%SBLinNo    = 02                                                  '
%SBLines    = 03                                                  '
%SBCols     = 04                                                  '
%SBBnds     = 05                                                  '
%SBInsOvr   = 06                                                  '
%SBCaseWord = 07                                                  '
%SBChange   = 08                                                  '
%SBState    = 09                                                  '
%SBMisc     = 10                                                  '
%SBSelect   = 11                                                  '
%SBCaps     = 12                                                  '
%SBSource   = 13                                                  '
%SBEOL      = 14                                                  '
%SBLayout   = 15                                                  '
%SBPad      = 16                                                  '
$AllStatusBarBoxes = "ABCDEFGHIJKLMNO"                            ' All boxes
$SBMode     = "A"                                                 ' Statusbar box call IDs
$SBLinNo    = "B"                                                 '
$SBLines    = "C"                                                 '
$SBCols     = "D"                                                 '
$SBBnds     = "E"                                                 '
$SBInsOvr   = "F"                                                 '
$SBCaseWord = "G"                                                 '
$SBChange   = "H"                                                 '
$SBState    = "I"                                                 '
$SBMisc     = "J"                                                 '
$SBSelect   = "K"                                                 '
$SBCaps     = "L"                                                 '
$SBSource   = "M"                                                 '
$SBEOL      = "N"                                                 '
$SBPad      = "O"                                                 '

'--------------------------------------------------------------------------------------------------+
'- Attr Table                                                                                      |
'--------------------------------------------------------------------------------------------------+
TYPE AttrEntry                                                    '
   AttrChar   AS STRING * 1                                       ' 1 Char ID
   AttrMask   AS DWORD                                            ' Attr Mask
END TYPE                                                          '

%SCTxtLo    = 0                                                   ' Text scheme numbers
%SCTxtHi    = 1                                                   ' 1st 2 are locked
%SCUser3    = 2                                                   ' User defined schemes
%SCUser4    = 3                                                   '
%SCUser5    = 4                                                   '
%SCUser6    = 5                                                   '
%SCUser7    = 6                                                   '
%SCUser8    = 7                                                   '
%SCUser9    = 8                                                   '
%SCUser10   = 9                                                   '
%SCUser11   = 10                                                  '
%SCUser12   = 11                                                  '
%SCUser13   = 12                                                  '
%SCUser14   = 13                                                  '
%SCUser15   = 14                                                  '
%SCUser16   = 15                                                  '

%SCLnoHi    = 16                                                  ' Internal basic screen colors
%SCLnoLo    = 17                                                  '
%SCATabMod  = 18                                                  '
%SCATabNMod = 19                                                  '
%SCITabMod  = 20                                                  '
%SCITabNMod = 21                                                  '
%SCPFK      = 22                                                  '
%SCStatus   = 23                                                  '
%SCFMTool   = 24                                                  '
%SCError    = 25                                                  '
%SCDiffD    = 26                                                  '
%SCDiffI    = 27                                                  '
%SCRsvrd4   = 28                                                  '
%SCRsvrd3   = 29                                                  '
%SCRsvrd2   = 30                                                  '
%SCRsvrd1   = 31                                                  '

%SCHiBlue   = 32                                                  ' Hi-Lite colors
%SCHiGreen  = 33                                                  ' 1st 4 locked
%SCHiYellow = 34                                                  '
%SCHiRed    = 35                                                  '
%SCHiBlack  = 36                                                  '
%SCHiNavy   = 37                                                  '
%SCHiTeal   = 38                                                  '
%SCHiViolet = 39                                                  '
%SCHiOrange = 40                                                  '
%SCHiGray   = 41                                                  '
%SCHiLime   = 42                                                  '
%SCHiCyan   = 43                                                  '
%SCHiPink   = 44                                                  '
%SCHiMagenta= 45                                                  '
%SCHiWhite  = 46                                                  '

%SCCust     = -1                                                  '
%SCFG       = 1                                                   '
%SCBG1      = 2                                                   '
%SCBG2      = 3                                                   '

%AttrScheme = &H0EFF                                              ' Scheme bits
%AttrSchNum = &H001F                                              ' Scheme Number
%AttrUC     = &H0800                                              ' Attr Force UpperCase
%AttrLC     = &H0400                                              ' Attr Force LowerCase
%AttrUL     = &H0200                                              ' Attr Underline
%AttrInv    = &H0100                                              ' Attr Invert Hi-Lite
%AttrHiLite = &HF000                                              ' HiLite bits
%AttrHiSTD  = &H0000                                              ' HiLite STD
%AttrAll    = &HFFFF                                              ' All bits

$$FileLine  = CHR$$(&H000F)                                       ' MEdit File Line (Scheme 14)
$$TxtLo     = CHR$$(&H0000)                                       ' Normal Text Lo
$$TxtLoUL   = CHR$$(&H0200)                                       ' Normal Text Lo Underlined
$$TxtHi     = CHR$$(&H0001)                                       ' Normal Text Hi
$$TxtHiUL   = CHR$$(&H0201)                                       ' Normal Text Hi Underlined
$$LNoLo     = CHR$$(&H0011)                                       ' Line Number Lo
$$LNoLoUL   = CHR$$(&H0211)                                       ' Line Number Lo Underlined
$$LNoHi     = CHR$$(&H0010)                                       ' Line Number Hi
$$LNoHiUL   = CHR$$(&H0210)                                       ' Line Number Hi Underlined
$$PFK       = CHR$$(&H0016)                                       ' PFK text
$$PFKUL     = CHR$$(&H0216)                                       ' PFK Text underlined
$$FMTool    = CHR$$(&H0018)                                       ' FM Tool text
$$Error     = CHR$$(&H0019)                                       ' Error text
$$Selected  = CHR$$(&H001A)                                       ' Selected text
$$Blue      = CHR$$(&H1000)                                       ' Blue hilite
$$Green     = CHR$$(&H2000)                                       ' Green hilite
$$Yellow    = CHR$$(&H3000)                                       ' Yellow hilite
$$Red       = CHR$$(&H4000)                                       ' Red Hilite

TYPE LCtlScan                                                     ' Initial Scan data table entry (Pre-Process)
   FromIX     AS LONG                                             ' From line
   ToIX       AS LONG                                             ' To line
   ToIXOrig   AS LONG                                             ' To line (original)
   Cmd        AS STRING * 8                                       ' Command
   Repeat     AS LONG                                             ' Repeat factor
   CmdType    AS STRING * 1                                       ' Command Type
   CmdFlag    AS LONG                                             ' Command Flag (&, -, etc.)
   CmdIX      AS LONG                                             ' Index to LCmd table
   CmdVar     AS STRING * 1                                       ' Command Type
END TYPE                                                          '

TYPE LCtlCmd                                                      ' Final Line Command entry (After validation)
   SrcCmd     AS STRING * 8                                       ' Source Command (C, M, CC, etc.)
   SrcFrom    AS LONG                                             ' Source Start Line number
   SrcTo      AS LONG                                             ' Source End Line number
   SrcToOrig  AS LONG                                             ' Source End Orig Line number
   SrcRepeat  AS LONG                                             ' Source Repeat
   SrcFlag    AS LONG                                             ' Source Flag
   SrcVar     AS STRING * 1                                       ' Source Cmd Var

   DstCmd     AS STRING * 8                                       ' Dest Command (A, B, O/OO, H/HH etc.)
   DstFrom    AS LONG                                             ' Dest Start Line number
   DstTo      AS LONG                                             ' Dest End Line number
   DstToOrig  AS LONG                                             ' Dest End Orig Line number
   DstRepeat  AS LONG                                             ' Dest Repeat
   DstFlag    AS LONG                                             ' Dest Flag
   DstVar     AS STRING * 1                                       ' Dest Cmd Var
END TYPE                                                          '

%lCmdR         = 1                                                ' Line Cmd '&' modifier
%lCmdX         = 2                                                ' Line Cmd '+'    "
%lCmdNX        = 3                                                ' Line Cmd '-'    "
%lCmdBSlash    = 4                                                ' Line Cmd '\'    "
%lCmdFSlash    = 5                                                ' Line Cmd '/'    "
%lCmdForce0    = 6                                                ' Line Cmd has a specific zero numeric value

TYPE LCtlValEnt                                                   '
   lcTxt   AS STRING * 8                                          ' Text
   lcIndex AS LONG                                                ' Index to gLCmdCode() table
   lcRange AS STRING * 1                                          ' Range Cmnd? Y=Yes, N=No
   lcNumV  AS STRING * 1                                          ' Numbers valid? Y=Yes, N=No
   lcType  AS STRING * 1                                          ' Cmd Type S=Source D=Destination I=Immediate
   lcKeep  AS STRING * 1                                          ' Line Keep allowed
   lcpm    AS STRING * 1                                          ' Line +/- allowed
   lcSlsh  AS STRING * 1                                          ' Line \ / allowed
   lcRFac  AS STRING * 1                                          ' Repeat/Num. operand etc.
   lcPCOK  AS STRING * 1                                          ' Primary command LINE OK
   lcbrOK  AS STRING * 1                                          ' Valid in Browse mode
END TYPE                                                          '

TYPE FMLCtlValEnt                                                 '
   lcCmd   AS STRING * 8                                          ' Command text
   lcIX    AS LONG                                                ' Index to FMLCmdCode() table
   lcBlock AS STRING * 1                                          ' Block Cmnd? Y=Yes, N=No
   lcNumV  AS STRING * 1                                          ' Numbers valid? Y=Yes, N=No
   lcTrue  AS STRING * 8                                          ' True command name
END TYPE                                                          '

TYPE RCArea                                                       ' SUB/FUNCTION result area
   RC      AS LONG                                                ' Return code
   MSG     AS STRINGZ * 10000                                     ' Message
END TYPE                                                          '

TYPE RCUser                                                       ' SUB/FUNCTION result area with 2 User fields
   RC      AS LONG                                                ' Return code
   User1   AS LONG                                                ' User Data
   User2   AS LONG                                                '
   MSG     AS STRINGZ * 10000                                     ' Message
END TYPE                                                          '

TYPE SortCtl                                                      ' Sort Control
   sFROM   AS INTEGER                                             '
   sTO     AS INTEGER                                             '
   AorD    AS STRING * 1                                          '
   CASE    AS STRING * 1                                          '
END TYPE                                                          '

TYPE CmdTable                                                     '
   NAME     AS STRING * 16                                        ' Command name
   EditCode AS DWORD                                              ' Address of Edit mode command handler
   LinOps   AS STRING * 1                                         ' Accept Line Operands (S/D/B/N)
   MacOK    AS STRING * 1                                         ' OK to run from MACRO SPFCommand call
   SCROLL   AS LONG                                               ' A screen movement command Up, Down, Locate etc.
   FMCode   AS DWORD                                              ' Address of Edit mode command handler
   TrakOK   AS STRING * 1                                         ' Create Track Point entries
   BrowseOK AS STRING * 1                                         ' Valid in Browse mode
   EFTOK    AS STRING * 1                                         ' Valid as EFT modifier
END TYPE                                                          '

TYPE MacType                                                      '
   MName   AS STRING * 16                                         '
   MType   AS STRING * 1                                          '
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- ProfState settings                                                                              |
'--------------------------------------------------------------------------------------------------+
%StateOff     = 0                                                 '
%StateOn      = 1                                                 '
%StateFew     = 2                                                 '
%StateMost    = 3                                                 '

'--------------------------------------------------------------------------------------------------+
'- AUTOSAVE settings                                                                               |
'--------------------------------------------------------------------------------------------------+
%AutoSON      = &H00000001                                        ' ON / OFF
%AutoSPrompt  = &H00000002                                        ' PROMPT / NOPROMPT

'--------------------------------------------------------------------------------------------------+
'- AttnDo flags                                                                                    |
'--------------------------------------------------------------------------------------------------+
%Attention    = &H00000001                                        ' Attention processing needed
%Refresh      = &H00000002                                        ' TP.DispScreen needed
%LoadReq      = &H00000004                                        ' FM load request data
%LoadData     = &H00000008                                        ' FM Load data based on Req
%SaveReq      = &H00000010                                        ' FM Save current Req data back to FILELIST
%Msg          = &H00000020                                        ' FM Line Message waiting
%MarkKill     = &H00000040                                        ' Kill any marked area
%MarkKillSkip = &H00000080                                        ' Skip killing once

'--------------------------------------------------------------------------------------------------+
'- Parse string literal types                                                                      |
'--------------------------------------------------------------------------------------------------+
$OpStr   = "S"                                                    ' Simple character string
$OpQStr  = "Q"                                                    ' Quoted string
$OpPStr  = "P"                                                    ' Picture string
$OpRStr  = "R"                                                    ' RegEx string
$OpXStr  = "X"                                                    ' Hex string
$OpDStr  = "D"                                                    ' DLM string
$OpCStr  = "C"                                                    ' Char string C'aaa'
$OpTStr  = "T"                                                    ' Text string T'aaa'
$OpFStr  = "F"                                                    ' Text string F'aaa'

'--------------------------------------------------------------------------------------------------+
'- Macro function equates                                                                          |
'--------------------------------------------------------------------------------------------------+
%ARG_OPT  = &H01000000                                            '
%ARG_DEF  = &H02000000                                            '
%ARG_VAR  = &H04000000                                            '
%ARGM_OPT = &H00000100                                            ' Macro versions since thinBasic
%ARGM_DEF = &H00000200                                            ' numeric equates are limited
%ARGM_VAR = &H00000400                                            '

'--------------------------------------------------------------------------------------------------+
'- Parse equates                                                                                   |
'--------------------------------------------------------------------------------------------------+
%PLoad   = 1                                                      ' Load the Parse Model
%PParse  = 2                                                      ' Parse the command string
%PAssign = 4                                                      ' Assign values to search/change parms
%PAll    = 7                                                      ' Do all 3 Phases

'--------------------------------------------------------------------------------------------------+
'- Cursor setting stuff                                                                            |
'--------------------------------------------------------------------------------------------------+
%Track    = 28                                                    ' Positioning by TRACK
%CurMacro = 24                                                    ' Positioning by a macro
%PosEnd   = 20                                                    ' Positioning by the kbEND function
%CError   = 18                                                    ' Command error
%LError   = 18                                                    ' Line Command error
%Insert   = 14                                                    ' Insert lines
%Position = 16                                                    ' Positioning, Scrolling etc.
%Change   = 12                                                    ' Change
%FChange  = 10                                                    ' Forced Change
%FLocate  = 9                                                     ' Forced Locate
%Find     = 8                                                     ' Find
%Locate   = 7                                                     ' Locate
%LineCmd  = 6                                                     ' Line commands
%EOL      = 4                                                     ' EOL position
%Low      = 1                                                     ' Anything else

'--------------------------------------------------------------------------------------------------+
'- LOCATE Flag Equates                                                                             |
'--------------------------------------------------------------------------------------------------+
%LocNext     = 1                                                  '
%LocPrev     = 2                                                  '
%LocFirst    = 3                                                  '
%LocLast     = 4                                                  '
%LocAll      = 5                                                  '
%LocNot      = 6                                                  '
%LocChange   = 7                                                  '
%LocCommand  = 8                                                  '
%LocError    = 9                                                  '
%LocExcluded = 10                                                 '
%LocLabel    = 11                                                 '
%LocSpecial  = 12                                                 '
%LocKeep     = 13                                                 '
%LocTag      = 14                                                 '
%LocLong     = 15                                                 '
%LocMX       = 16                                                 '
%LocPage     = 17                                                 '
%LocFind     = 18                                                 '
%LocCurrent  = 19                                                 '
%LocFile     = 20                                                 '
%LocNote     = 21                                                 '
%LocSize     = 22                                                 '
%LocColor    = 23                                                 '
%LocStd      = 27                                                 '
%LocTop      = 28                                                 '
%LocU        = 29                                                 '
%LocNU       = 30                                                 '
%LocNX       = 31                                                 '
%LocHandle   = 32                                                 '
%LocSpell    = 33                                                 '

TYPE CommModel                                                    '
   Txt1L      AS LONG                                             ' L' Txt1
   Txt2L      AS LONG                                             ' L' Txt2
   sCol       AS LONG                                             ' Comment column
   Sch        AS LONG                                             ' Comment scheme
   Fnd        AS LONG                                             ' Comment found
   EsCol      AS LONG                                             ' Exclude column
   IsCol      AS LONG                                             ' Include column
END TYPE                                                          '

TYPE ClrKWIndex                                                   '
   StartItem  AS INTEGER                                          ' Start of range
   EndItem    AS INTEGER                                          ' End of range
END TYPE                                                          '

TYPE ParseFlags                                                   '
   LRangeOK   AS BIT * 1 IN BYTE                                  '
   LRangeNum  AS BIT * 1                                          '
   ColsOK     AS BIT * 1                                          '
   L1OK       AS BIT * 1                                          '
   L1FName    AS BIT * 1                                          '
   L2OK       AS BIT * 1                                          '
END TYPE                                                          '

TYPE TxtEntry                                                     '
   Length     AS LONG                                             ' Length of an entry
   Offset     AS LONG                                             ' Offset to 1st byte
   Clr        AS LONG                                             ' Color index
END TYPE                                                          '

TYPE TSwitch                                                      '
   Number     AS LONG                                             ' Tab # to switch to
   Message    AS STRINGZ * 64                                     ' Message to be issued in the tab
   COMMAND    AS STRINGZ * 64                                     ' Command to be issued in the tab
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- Equates for CursMode                                                                            |
'--------------------------------------------------------------------------------------------------+
   %CCmd         = 1                                              ' In pCommand area
   %CLData       = 2                                              ' In Data text ares
   %CLCmd        = 3                                              ' In Line number area
   %CScrl        = 4                                              ' In Scroll Amt. area
   %CInternal    = 5                                              ' sLin and sCol are set internally
   %CNext        = 6                                              ' Re-Entry of an ALL search
   %CBad         = 99                                             ' In non-typing area
   '-----------------------------------------------------------------------------------------------+
   '- FM entries                                                                                   |
   '-----------------------------------------------------------------------------------------------+
   %CFPath       = 7                                              ' In FM Path
   %CFMask       = 8                                              ' In FM Mask
   %CFLCmd       = 9                                              ' In FM LCmd segment
   %CFLData      = 10                                             ' In FM Line elsewhere

'--------------------------------------------------------------------------------------------------+
'- Equates for ErrMsgHigh                                                                          |
'--------------------------------------------------------------------------------------------------+
   %eNone = 0                                                     ' None
   %eRetrieve = 1                                                 ' RETRIEVE'd command
   %ePending = 2                                                  ' Line Command pending
   %eCmdPend = 4                                                  ' Command pending
   %eFail = 8                                                     ' Failure
   %eMultiple = 32                                                ' Multiple error override
   %eTerminate = 99                                               ' In termination

'--------------------------------------------------------------------------------------------------+
'- Equates for Tab Mode Flag and gENV.PMode                                                        |
'--------------------------------------------------------------------------------------------------+
%FMTab      = &H00000001                                          ' Equates for Tab Mode Flag
%Browse     = &H00000002                                          '
%View       = &H00000004                                          '
%Edit       = &H00000008                                          '
%Clip       = &H00000010                                          '
%SetEdit    = &H00000020                                          '
%MEdit      = &H00000040                                          '
%ClipLoad   = &H00000080                                          '
%ClipSave   = &H00000100                                          '
%Open       = &H00000200                                          '
%KeyMap     = &H00000400                                          '
%Diff       = &H00000800                                          '
%EFTEdit    = &H00001000                                          '
%GoFM       = &H00002000                                          '

'--------------------------------------------------------------------------------------------------+
'- Equates for TP.Flag - Misc flags                                                                |
'--------------------------------------------------------------------------------------------------+
%BndsAFlag  = &H00000001                                          ' BNDS line has been modified
%WordAFlag  = &H00000002                                          ' WORD line has been modified
%MarkAFlag  = &H00000004                                          ' MARK line has been modified
%MaskAFlag  = &H00000008                                          ' MASK line has been modified
%TabsAFlag  = &H00000010                                          ' TABS line has been modified
%UndoFlag   = &H00000020                                          ' UNDO save needed at next Attn
%ClrCase    = &H00000040                                          ' Clr KW's honor case
%BackupDone = &H00000100                                          ' File Backup has been done
%HideFlag   = &H00000200                                          ' Hide X'd lines
%InsClnSupp = &H00000400                                          ' Suppress Insert Line cleanup one time
%ModdFlag   = &H00000800                                          ' File is in Modified state
%ModdEver   = &H00001000                                          ' File was modified sometime since open
%ModdLast   = &H00002000                                          ' Modd status at last TabTitle
%OvrTextDel = &H00004000                                          ' OverlayTextDel flag
%ColSupp    = &H00008000                                          ' Suppress maintain col mode
%PFKInsert  = &H00010000                                          ' Command inserted by a PFK command
%PTypeMode  = &H00020000                                          ' PType Mode
%RenumFlag  = &H00040000                                          ' Renum needed
%RevOnce    = &H00080000                                          ' Reverse just once
%StateExist = &H00100000                                          ' STATE data exists
%StateForce = &H00200000                                          ' STATE force (set by STATE CREATE)
%ClrFlag    = &H00400000                                          ' AUTO color file available
%MarkActive = &H00800000                                          ' Mark - Marked area is active
%MarkDrawn  = &H01000000                                          ' Mark area has been drawn
%MiscActive = &H02000000                                          ' MiscMark - Marked area is active
%MiscDrawn  = &H04000000                                          ' MiscMark - Area is Marked on screen
%SwapActive = &H08000000                                          ' Swap - Marked area is active
%SwapDrawn  = &H10000000                                          ' Swap - Area is Marked on screen
%SlecSet    = &H20000000                                          ' Select is set
%SlecActive = &H40000000                                          ' Select is active

'--------------------------------------------------------------------------------------------------+
'- Equates for TP.Flag2 - Misc flags                                                               |
'--------------------------------------------------------------------------------------------------+
%NSrtFlag   = &H00000001                                          ' KB Insert mode or not
%NSrtSave   = &H00000002                                          ' KB Insert mode saved
%NSrtData   = &H00000004                                          ' KB DataInsert mode or not
%NSrtSaveD  = &H00000008                                          ' KB DataInsert mode saved
%FileHide   = &H00000010                                          ' Hide =File lines

%MB_Custom1              = &H00000007                             '
%MB_Custom2              = &H00000008                             '
%MB_Custom3              = &H00000009                             '
%IDCustom1               = 12                                     '
%IDCustom2               = 13                                     '
%IDCustom3               = 14                                     '

DECLARE FUNCTION Sub1( p1 AS ANY ) AS DWORD                       '
DECLARE FUNCTION Sub2( p1 AS ANY, p2 AS ANY ) AS DWORD            '
DECLARE FUNCTION Sub3( p1 AS ANY, p2 AS ANY, p3 AS ANY ) AS DWORD '
DECLARE FUNCTION Sub5( p1 AS ANY, p2 AS ANY, p3 AS ANY, p4 AS ANY, p5 AS ANY ) AS DWORD   '

'--------------------------------------------------------------------------------------------------+
'- Misc. Equates                                                                                   |
'--------------------------------------------------------------------------------------------------+
%Strip = %True                                                    ' For GetNextWord
%NoStrip = %False                                                 '
%Chunk = 262144                                                   ' Set size of file I/O chunks
'-                                                                ' Pseudo bit flag for DlgEditCallback mouse logic

$Numbers = "0123456789 *"                                         ' For Line control parsing
$Numeric = "0123456789"                                           '
$Hex     = "0123456789ABCDEF"                                     '
$NL      = CHR$(21)                                               ' EBCDIC NL character
$BlankLNo  = "        "                                           ' For line number stuff
$Quotes = $DQ + $SQ + CHR$(96)                                    ' Our 3 supported quotes
$AlphaNum = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_" '
$DefCharSet = "!" + $DQ + "#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`" + _  '
                "abcdefghijklmnopqrstuvwxyz{|}~"              '
$Upper  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"                            '
$Lower  = "abcdefghijklmnopqrstuvwxyz"                            '
$UpperNat = CHR$(138,140,142,159,192,193,194,195,196,197,198,199,200, _ '             
                 201,202,203,204,205,206,207,208,209,210,211,212,213, _ '             
                 214,216,217,218,219,220,221,222)                 '        

$LowerNat = CHR$(154,156,158,223,224,225,226,227,228,229,230,231,232, _ '             
                 233,234,235,236,237,238,239,240,241,242,243,244,245, _ '             
                 246,249,250,251,252,253,254,248)                 '        
$SpellChrs = $AlphaNum + $UpperNat + $LowerNat + "'"              '
$WORD    = "A-Z a-z 0-9"                                          ' For 'word', 'prefix' and 'suffix' tests
$EOLDLM = CHR$(10, 12, 13, 26)                                    ' $LF, $FF, $CR, $EOF

$RegUpper = "A-Z"                                                 ' Reg Expresssion UC
$RegUpperNat = "\x8A\x8C\x8E\x9F\xC0-\xD6\xD8-\xDE"               ' Reg Expresssion UC European chars
$RegLower = "a-z"                                                 ' Reg Expresssion LC
$RegLowerNat = "\x9A\x9C\x9E\xDF-\xF6\xF8-\xFF"                   ' Reg Expresssion LC European chars
$ConClose = "$CON:CLOSE"                                          '
$UpperSpec = CHR$(171, 173, 176 TO 185, 183 TO 218, 225 TO 250)   ' +, -, 0-9, A-Z, a-z
$NonBlank = CHR$(0 TO 31, 33 TO 255)                              ' Everything but blanks
$New = "(New)"                                                    '

$AttrColor = " BGR"                                               '

$UTF32BE = CHR$(&h00, &h00, &hFE, &hFF)                           '
$UTF32LE = CHR$(&hFF, &hFE, &h00, &h00)                           '
$UTF8    = CHR$(&hEF, &hBB, &hBF)                                 '
$UTF16LE = CHR$(&hFF, &hFE)                                       '
$UTF16BE = CHR$(&hFE, &hFF)                                       '

'--------------------------------------------------------------------------------------------------+
'- Constant equates for some SUB/FUNCTION calls                                                    |
'--------------------------------------------------------------------------------------------------+
%ProfGetY = %True                                                 '
%ProfGetN = %False                                                '
'--------------------------------------------------------------------------------------------------+
'- sCRPFwd MoveMode values                                                                         |
'--------------------------------------------------------------------------------------------------+
%mVisible = 1                                                     '
%mData    = 2                                                     '
%mText    = 3                                                     '
%mVisData = 4                                                     '
%mPage    = 5                                                     '
%mOData   = 62                                                    '

'--------------------------------------------------------------------------------------------------+
'- sResetFunc                                                                                      |
'--------------------------------------------------------------------------------------------------+
%ResetExcluded = &H0001                                           '
%ResetCommand  = &H0002                                           ' Internal RESET Command
%ResetCommandK = &H0004                                           ' User specified COMMAND keyword
%ResetLabel    = &H0008                                           '
%ResetSpecial  = &H0010                                           '
%ResetChange   = &H0020                                           '
%ResetTag      = &H0040                                           '
%ResetUser     = &H0080                                           '
%ResetFind     = &H0100                                           '
%ResetRetrieve = &H0200                                           '
%ResetClr      = &H0400                                           '
%ResetHandle   = &H0800                                           '
%ResetHide     = &H1000                                           '
%ResetSource   = &H2000                                           '
%ResetWord     = &H4000                                           '
%ResetTrack    = &H8000                                           '
%ResetAll      = &HFFFF                                           '

'--------------------------------------------------------------------------------------------------+
'- Symbol scan states                                                                              |
'--------------------------------------------------------------------------------------------------+
%Normal_State = 0                                                 '
%Quoted_State = 1                                                 '
%Symbol_State = 3                                                 '
%Format_State = 4                                                 '

'--------------------------------------------------------------------------------------------------+
'- PrinterPrint modes                                                                              |
'--------------------------------------------------------------------------------------------------+
%PrtReset      = 0                                                '
%PrtLine       = 1                                                '
%PrtNewLine    = 2                                                '
%PrtNewPage    = 3                                                '
%PrtFlushClose = 4                                                '

'--------------------------------------------------------------------------------------------------+
'- Declare stuff for ShellLink (Cnvt .LNK to full path)                                            |
'--------------------------------------------------------------------------------------------------+
%CIS                  = 1                                         'Component is allowed in the same process space.
$CLSID_ShellLink      = GUID$("{00021401-0000-0000-C000-000000000046}") 'CHR$(  1, 20, 2, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 70)
$IIDG_IShellLink      = GUID$("{000214EE-0000-0000-C000-000000000046}") 'CHR$(238, 20, 2, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 70)
$IID_IPersistFile     = GUID$("{0000010B-0000-0000-C000-000000000046}") 'CHR$( 11,  1, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 70)

'--------------------------------------------------------------------------------------------------+
'- Used in color selection dialogue                                                                |
'--------------------------------------------------------------------------------------------------+
TYPE CustColor                                                    '
   cc(16) AS LONG                                                 '
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- For searching window titles                                                                     |
'--------------------------------------------------------------------------------------------------+
TYPE WinInfoType                                                  '
   WinTitle AS STRING * 256                                       '
   WinHandle AS LONG                                              '
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- EFT Entry Data                                                                                  |
'--------------------------------------------------------------------------------------------------+
TYPE EFTData                                                      '
   ALgth AS LONG                                                  ' Active character length
   RawIX AS LONG                                                  ' Index of the RAW entry
   Mask  AS STRINGZ * 128                                         ' Mask (translated to PCRE)
   Prof  AS STRINGZ * 16                                          ' EFT 1st operand after the = sign
   Oper  AS STRINGZ * 256                                         ' EFT operands after the 1st operand
   PCRE  AS DWORD                                                 ' Handle of PCRE compile output
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- INCLUDE scan parameters                                                                         |
'--------------------------------------------------------------------------------------------------+
TYPE InclParms                                                    '
   Trig  AS STRINGZ * 32                                          ' Trigger Keyword
   Cmnt  AS STRINGZ * 8                                           ' Comment trigger
   DLMS  AS STRINGZ * 32                                          ' Unwanted delimiters
   Supp  AS STRINGZ * 16                                          ' Suppress Include
   PATH  AS STRINGZ * %MAX_PATH                                   ' Search path
   WORD  AS LONG                                                  ' Word number of the filename
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- Help table definitions                                                                          |
'--------------------------------------------------------------------------------------------------+
TYPE HTopic                                                       '
    Cat              AS STRINGZ * 2                               ' Topic Category
    Title            AS STRINGZ * 70                              ' Topic Title
    Found            AS STRING  * 8                               ' Found flags
    Hits             AS LONG                                      ' Hits count
END TYPE                                                          '

TYPE HEnt                                                         '
    Num              AS LONG                                      ' Topic ID# for the CHN file & Title table
    Hits             AS LONG                                      ' Count of hits in this Topic
    Kwd              AS STRINGZ * 16                              ' Topic Keyword
END TYPE                                                          '

TYPE HFound                                                       '
    Ctr              AS STRING * 4                                ' Count of number search words found
    Hits             AS STRING * 4                                ' Count of number of hits in the CHM file Topic
    Num              AS LONG                                      ' Topic ID# for the CHN file & Title table
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- For PowerType support                                                                           |
'--------------------------------------------------------------------------------------------------+
TYPE PTypeTable                                                   '
    tLin AS LONG                                                  '
    sRow AS LONG                                                  '
END TYPE                                                          '

TYPE DiffStream                                                   ' Bookkeeping for each file
   Cursor             AS LONG                                     ' Active line
   Match              AS LONG                                     ' Last matching line
   Last               AS LONG                                     ' Last Line
   TLine              AS STRING POINTER                           ' Address of Text Table
   LB                 AS LONG                                     ' Left Bound
   RB                 AS LONG                                     ' Right Bound
   Flag               AS LONG                                     ' Flags
   Comm1(1 TO 9)      AS STRING * 32                              ' Comment string 1
   Comm2(1 TO 9)      AS STRING * 32                              ' Comment column or 2nd dlm
   CommQLeft          AS STRING * 4                               ' AUTO Left  Quote
   CommQRight         AS STRING * 4                               ' AUTO Right Quote
END TYPE                                                          '
%NoSpaces    = &H00000001                                         '
%NoTabs      = &H00000002                                         '
%NoComments  = &H00000004                                         '
%NoCASE      = &H00000008                                         '
%NoMultB     = &H00000010                                         '
%NoX         = &H00000020                                         '
%NoNX        = &H00000040                                         '
%UseFileB    = &H00000080                                         '

'--------------------------------------------------------------------------------------------------+
'- Misc stuff                                                                                      |
'--------------------------------------------------------------------------------------------------+
UNION ClrCnvt                                                     '
   Clr  AS LONG                                                   '
   c(1 TO 4) AS BYTE                                              '
END UNION                                                         '

UNION Both                                                        '
   lft AS FILETIME                                                '
   lq  AS QUAD                                                    '
END UNION                                                         '

'--------------------------------------------------------------------------------------------------+
'- Directory Watching data                                                                         |
'--------------------------------------------------------------------------------------------------+
TYPE WatchData                                                    ' Parameter list for the Thread
   gWatchDir         AS ASCIIZ * %MAX_PATH                        ' The directory to watch
   gWatchFile        AS ASCIIZ * %MAX_PATH                        ' The file to watch
   gWatchThread      AS LONG                                      ' Thread address
   gEvent            AS LONG                                      ' Event to be signalled to stop the thread
   gChanged          AS LONG                                      ' Answer area from thread to signal a change
   gActive           AS LONG                                      ' Thread is active
   gFileAttrib       AS DWORD                                     ' File Attributes
   gFileCRTime       AS QUAD                                      ' Creation Timestamp when last seen
   gFileLWTime       AS QUAD                                      ' Modified Timestamp when last seen
   gFileSizeHigh     AS DWORD                                     ' File Size when last seen
   gFileSizeLow      AS DWORD                                     '
   gPgNumber         AS INTEGER                                   ' Tab # we're watching for
   gInUse            AS LONG                                      ' InUse - %True, Available - %False
   gGotStamp         AS LONG                                      ' Timestamps are saved
   gFlag             AS STRING * 1                                ' Modified flag
END TYPE                                                          '
%WatchStart = 1                                                   ' Start watching directory
%WatchCheck = 2                                                   ' Get current Changed status
%WatchEnd   = 3                                                   ' Stop watching, return result

'--------------------------------------------------------------------------------------------------+
'- CmdPad data                                                                                     |
'--------------------------------------------------------------------------------------------------+
TYPE CmdPadData                                                   ' Parameter list for the Thread
   gCmdPadActive     AS LONG                                      ' Flag, the CmdPad dialog is active
   gCmdPadTextP      AS STRING POINTER                            ' Pointer to gCmdPadText
END TYPE                                                          '

UNION kbMsg                                                       ' To support Keyboard hook passing a
   MsgWparam         AS LONG                                      ' text string via %WM_USER param
   kbString          AS STRING * 4                                '
   kbInt(0 TO 1)     AS INTEGER                                   '
END UNION                                                         '

'--------------------------------------------------------------------------------------------------+
'- Picture mapping equates                                                                         |
'--------------------------------------------------------------------------------------------------+
%PicMap_Literal            = &H00000001                           ' Literal data, non-alphabetic
%PicMap_Any                = &H00000002                           ' P'='    Any char
%PicMap_NonBlank           = &H00000004                           ' P''    Any nonblank char; also P'^'
%PicMap_NonDisplay         = &H00000008                           ' P'.'    Any non-displayable char
%PicMap_Numeric            = &H00000010                           ' P'#'    Any numeric character, 0-9
%PicMap_NonNumeric         = &H00000020                           ' P'-'    Any nonnumeric char
%PicMap_Alpha              = &H00000040                           ' P'@'    Any alphabetic char, UC or LC
%PicMap_Lower              = &H00000080                           ' P'<'    Any lowercase alphabetic char
%PicMap_Upper              = &H00000100                           ' P'>'    Any uppercase alphabetic char
%PicMap_Special            = &H00000200                           ' P'$'    Any char not alpha or numeric
%PicMap_WORD_Char          = &H00000400                           ' P'&'    Any WORD char
%PicMap_Non_WORD_Char      = &H00000800                           ' P'%'    Any non-WORD char
%PicMap_LMargin            = &H00001000                           ' P'{'    LM + leading spaces
%PicMap_RMargin            = &H00002000                           ' P'}'    RM + trailing spaces
%PicMap_LiteralAlpha       = &H00004000                           ' Literal data, alphabetic
%PicMap_Escape             = &H00008000                           ' To mark backslash escaped pic codes

'--------------------------------------------------------------------------------------------------+
'- Picture mapping globals                                                                         |
'--------------------------------------------------------------------------------------------------+
TYPE PIC_type                                                     '
                                                                  '
   data_mask(0 TO 255)     AS WORD                                '
   pic_mask(0 TO 255)      AS WORD                                '
   mapping_initialized     AS LONG                                '
   defaults_initialized    AS LONG                                '
   WORD_WORD_changed       AS LONG                                ' set to 1 when WORD changed
   CharSet_changed         AS LONG                                ' set to 1 when CharSet changed
                                                                  '
END TYPE                                                          '

TYPE MY_EXCEPTION_POINTERS                                        '
   ExceptionRecord      AS EXCEPTION_RECORD POINTER               '
   ContextRecord        AS CONTEXT          POINTER               '
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'-  SPFLiteCodePageTypes.inc                                                                       |
'--------------------------------------------------------------------------------------------------+
%TX_ASCII  = 1                                                    '
%TX_EBCDIC = 2                                                    '
%TA_INDEX  = %TX_ASCII                                            '
%TE_INDEX  = %TX_EBCDIC                                           '
%TX_MAX    = 2                                                    '
%AE_MODE   = 1                                                    '
%EA_MODE   = 2                                                    '
                                                                  '
'--------------------------------------------------------------------------------------------------+
'-  TYPE CODEPAGE_TT_T                                                                             |
'--------------------------------------------------------------------------------------------------+
TYPE CODEPAGE_TT_T                                                '-  CODEPAGE TRAITS FOR 'TT' LINE
    TT_ERRORS               AS LONG                               '  NUMBER OF ERRORS FOUND
    TT_REASON               AS ASCIIZ * (80+1)                    '  DESCRIPTION OF ERROR
    TT_AUTHOR               AS ASCIIZ * (64+1)                    '  CREATOR OF TABLE
    TT_GENDATE              AS ASCIIZ * (20+1)                    '  "2002-12-03 00:00:00"
    TT_MODE                 AS ASCIIZ * (2+1)                     '  RT/ES ROUND TRIP/SUBSET
    TT_NAME                 AS ASCIIZ * (64+1)                    '  NAME  OF TRANSLATION TABLE
    TT_TITLE                AS ASCIIZ * (64+1)                    '  TITLE OF TRANSLATION TABLE
    TT_OTHER                AS ASCIIZ * (80+1)                    '  UNKNOWN KEYWORD VALUE
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'-  TYPE CODEPAGE_TX_T                                                                             |
'--------------------------------------------------------------------------------------------------+
TYPE CODEPAGE_TX_T         '-  CODEPAGE TRAITS FOR 'TA' AND 'TE' LINES
    TX_DEFINED              AS BYTE                               '  IF AE/EA TABLE DEFINED
    TX_ERRORS               AS LONG                               '  NUMBER OF ERRORS FOUND
    TX_VALUES               AS LONG                               '  NUMBER OF VALUES STORED
    TX_REASON               AS ASCIIZ * (80+1)                    '  DESCRIPTION OF ERROR
    TX_ENTRY (0 TO 15)      AS BYTE                               '  FLAGS FOR AE/EA LINES
    TX_CCSID                AS ASCIIZ * (9+1)                     '  PIECES OF 'NUMBER' AS INT
    TX_CGCSGID              AS ASCIIZ * (10+1)                    '  CGCSGID   "00695"
    TX_CODESET              AS ASCIIZ * (64+1)                    '  FULL CODESET NAME
    TX_CPGID                AS ASCIIZ * (10+1)                    '  CPGID  "01140"
    TX_EURO                 AS ASCIIZ * (2+1)                     '  VALUE OF EURO OR 00
    TX_NUMBER               AS ASCIIZ * (20+1)                    '  "1140", "8859_1", ETC.
    TX_ORIGIN               AS ASCIIZ * (16+1)                    '  "IBM", "ISO" ETC.
    TX_RELATED              AS ASCIIZ * (10+1)                    '  RELATED EURO CCSID "-37"
    TX_SCHEME               AS ASCIIZ * (10+1)                    '  ENCODING SCHEME "1100"
    TX_SIZE                 AS ASCIIZ * (3+1)                     '  NUM OF DEFINED CHARS
    TX_SUB                  AS ASCIIZ * (2+1)                     '  SUBSTITUTION CHAR
    TX_TYPE                 AS ASCIIZ * (6+1)                     '  "ASCII", "EBCDIC"
    TX_UCM                  AS ASCIIZ * (64+1)                    '  .UCM FILE NAME
    TX_UCMDATE              AS ASCIIZ * (20+1)                    '  "2002-12-03 00:00:00"
    TX_VERSION              AS ASCIIZ * (16+1)                    '  "2.3.3", "1995", ETC.
    TX_OTHER                AS ASCIIZ * (80+1)                    '  UNKNOWN KEYWORD VALUE
    TX_TABLE (0 TO 255)     AS BYTE                               '  FINAL TRANSLATION TABLE
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'-  TYPE CODEPAGE_CP_T                                                                             |
'--------------------------------------------------------------------------------------------------+
TYPE CODEPAGE_CP_T         '-  CODEPAGE DATA STRUCTURE
    CP_LINENO               AS LONG                               '  LINE NUMBER FOR ERRORS
    CP_ERRORS               AS LONG                               '  NUMBER OF ERRORS FOUND
    CP_REASON               AS ASCIIZ * (80+1)                    '  DESCRIPTION OF ERROR
    TT                      AS CODEPAGE_TT_T                      '
    TX (1 TO %TX_MAX)       AS CODEPAGE_TX_T                      '
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'-  PARSE_KEYWORD_VALUE_DATA                                                                       |
'--------------------------------------------------------------------------------------------------+
TYPE                        KEYWORD_VALUE_DATA_T                  '
    KV_DATA                 AS ASCIIZ * (256+1)                   '
    KV_KEYWORD              AS ASCIIZ * (32+1)                    '
    KV_VALUE                AS ASCIIZ * (128+1)                   '
    KV_REASON               AS ASCIIZ * (80+1)                    '
    KV_STATUS               AS LONG                               '
END TYPE                                                          ' KEYWORD_VALUE_DATA_T

TYPE DataShift_Segment_t                                          '
   gap_len                 AS LONG                                '
   data_pos                AS LONG                                '
   data_len                AS LONG                                '
   blank_pos               AS LONG                                '
   blank_len               AS LONG                                '
END TYPE                                                          '

TYPE utab_t                                                       ' Private Unicode table
   valid            AS LONG                                       '
   uchar (0 TO 255) AS WSTRING * 1                                '
END TYPE                                                          '

'--------------------------------------------------------------------------------------------------+
'- User Data Area indexes for (CharSet) and (CharSetCol)                                           |
'--------------------------------------------------------------------------------------------------+

%uda_colMode          = 1                                         ' index to tls_colMode
%uda_PrfGetX2APtr     = 2                                         ' index to tls_rfGetX2APtr
%uda_ansiSource       = 3                                         ' index to tls_ansiSource

UNION MyFStamp                                                    '
   MyQuad AS QUAD                                                 '
   MyTime AS filetime                                             '
END UNION                                                         '

'--------------------------------------------------------------------------------------------------+
'- FM.Flag Equates                                                                                 |
'--------------------------------------------------------------------------------------------------+
%FDirUp          = 4                                              '
%FDirDown        = 6                                              '
%FEntry          = 8                                              '
%FFLEntry        = 10                                             '
%FOpen           = 12                                             '
%FPath           = 14                                             '
%FFileList       = 16                                             '
%FConfig         = 18                                             '
%FDirLow         = 20                                             '
%FTotal          = 24                                             '
%FEnd            = 26                                             '

'--------------------------------------------------------------------------------------------------+
'- FM.FMode Equates                                                                                |
'--------------------------------------------------------------------------------------------------+
%FMFilePath   = 1                                                 ' Normal FilePath/Mask mode
%FMFileTree   = 2                                                 ' Full FileTree mode
%FMOpen       = 3                                                 ' OPEN     files list
%FMConfigs    = 4                                                 ' Configs  files list
%FMRecPaths   = 5                                                 ' Recent   paths list
%FMFLISTS     = 6                                                 ' FLIST list
%FMFilelist   = 7                                                 ' Filelist type list
