#COMPILE EXE
#DIM ALL
#INCLUDE  ONCE "win32api.inc"

TYPE CBytes                                                       '
   R      AS BYTE                                                 'Red
   G      AS BYTE                                                 'Green
   B      AS BYTE                                                 'Blue
   A      AS BYTE                                                 'Alpha
END TYPE                                                          '

UNION CUnion                                                      '
  RGB AS DWORD                                                    ' LONG version
  CBytes                                                          ' R/G/B/A ytes
END UNION                                                         '

%fgWeight = 9
%bgWeight = 4

GLOBAL hWnd       AS DWORD

FUNCTION PBMAIN () AS LONG
LOCAL fg, bg AS LONG
   fg = %RGB_YELLOW:   bg = %RGB_GREEN
   MSGBOX HEX$(fg, 8) + " | " + HEX$(DimColor(fg, bg), 8)


   DIALOG NEW PIXELS, 0, "Test", 500, 50, 500, 500, %WS_CAPTION OR %WS_SYSMENU TO hWnd
   CONTROL ADD GRAPHIC, hWnd, 101, "", 0, 0, 500, 500
   GRAPHIC ATTACH hWnd, 101, REDRAW
   GRAPHIC CLEAR bg
   GRAPHIC SET POS (5, 5)
   GRAPHIC COLOR fg, bg
   GRAPHIC PRINT "This is Normal Text XXXXXWWWWW@XXXXXWWWWWW"

   GRAPHIC SET POS (5, 25)
   GRAPHIC COLOR DimColor(fg, bg), bg
   GRAPHIC PRINT "This is Dim  Text XXXXXWWWWWXXXXXWWWWW"

   GRAPHIC REDRAW
   DIALOG SHOW MODAL hWnd
   DIALOG END hWnd
END FUNCTION


FUNCTION DimColor(cfg AS LONG, cbg AS LONG) AS LONG
'---------------------------------------------------------------------------------------------------+
'- Create a Dimmed version of a color                                                               |
'---------------------------------------------------------------------------------------------------+
LOCAL f, b AS CUnion, rc, gc, bc AS LONG
   f.RGB = cfg: b.RGB = cbg
   rc = (f.r * %fgWeight + b.r * %bgWeight) \ (%fgWeight + %bgWeight)
   gc = (f.g * %fgWeight + b.g * %bgWeight) \ (%fgWeight + %bgWeight)
   bc = (f.b * %fgWeight + b.b * %bgWeight) \ (%fgWeight + %bgWeight)
   FUNCTION = RGB(rc, gc, bc)
END FUNCTION
